       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSCA322.                                            
       AUTHOR. JAYANTHI SANTHAPPAN.                                     
       DATE-WRITTEN. SEP-2002.                                          
      *****************************************************************         
      **               SOUTH CAROLINA ELECTRIC & GAS                 **         
      **                                                             **         
      **                                                             **         
      *****************************************************************         
      ********                    CIG                         *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **     DATE       INITIALS              REASON                 **         
      **   09-04-2002   JS83520               COMPETETIVE PRICING    **         
      **                                      INTERFACE FOR CIG      **         
      **   01-21-2003   SV85244               MADE CHANGES AS PER    **         
      **                                      STANDARDS.             **         
T27237**   05/06/2003   SK88120 CHANGES WERE MADE TO FIX PROD ISSUES **         
T27237**                      A) GENERATE COMPLETE REPORT            **         
T27237**                      B) UPDATE ROW IF ALREADY EXIST         **         
T33149**   10/06/2005   JC91900  MODIFIED TO FIX PROD ABEND - CREATE **         
T33149**                         WORKQUEUE IF CUSTOMER IS NOT ACTIVE.**         
T35434**   04/14/2007   MC95456  REPLACED CSS_MODEL_SQL WITH SET     **         
T35434**                         STATEMENTS                          **         
A03303**   09/03/2011   MC95456  FIXED FACTOR PRECISION CHANGES      **         
A03303**                         FROM 4 TO 6 DECIMAL POINTS FOR      **         
A03303**                         INDUSTRIAL BILLING.                 **         
A04860**   03/13/2014   AS7C117  REPLACE CSS_WQ_ITEMS_MF WITH        **         
A04860**                         CSS_WQ_ITEMS.                       **         
      *****************************************************************         
      *      REMARKS.                                                           
      *****************************************************************         
      *****************************************************************         
      *        REPORT GENERATOR FOR PCSCA322 PRODUCES A CONTROL REPORT*         
      *        THAT REPORTS THE NUMBER OF DAILY'S, OFF AT METER,      *         
      *        TRANSPORTING ETC                                       *         
      *****************************************************************         
                         ---- BASIC SEQUENCE STRUCTURE ----             
                    0000 - 0999     MAIN CONTROL PATH                   
                    1000 - 1999     INITIALIZATION                      
                    1000 - 1999     INPUT PROCESSING CONTROL PATH       
                    2000 - 2999     OUTPUT PROCESSING CONTROL PATH      
                    3000 - 4999     BATCH PROCESSING MODULES - NOT USED 
                    5000 - 5999     COMMON PROGRAM MODULES              
                    6000 - 6999     COMMON SYSTEM MODULES               
                    7000 - 7999     INPUT MODULES                       
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9799     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
     *                                                                  
       COPY CSSCA322.                                                           
     *                                                                  
       COPY CSSPT33.                                                            
     *                                                                  
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
     *                                                                  
       COPY CFDCA322.                                                           
       COPY FIOCA322.                                                           
     *                                                                  
       COPY CFDPT33.                                                            
     *                                                                  
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA322'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40) VALUE                
           'WORKING STORAGE FOR PCSCA322 STARTS HERE'.                  
                                                                        
       01  WS-MISC.                                                     
           05  WS-DISP-RC                PIC -ZZZZZZZZ9.9.              
           05  WS-ONE                    PIC 9(02) VALUE 01.            
           05  WS-ZERO                   PIC 9(02) VALUE 00.            
           05  WS-MAX-LINES              PIC 9(02) VALUE 56.            
           05  WS-LINE-COUNT             PIC 9(02) VALUE 57.            
           05  WS-PAGE-COUNT             PIC 9(03) VALUE ZERO.          
           05  WS-ERR-MSG                PIC X(40) VALUE SPACES.        
           05  WS-PGRMNAME               PIC X(08) VALUE 'PCSCA322'.    
           05  WS-PGRNAME                PIC X(08) VALUE 'PCSCA322'.    
           05  WS-COMP-NAME              PIC X(31) VALUE  SPACES.       
           05  WS-EFF-DATE               PIC X(10) VALUE SPACES.        
           05  WS-VALID-DATE             PIC X(10) VALUE SPACES.        
           05  WS-YES                    PIC X(01) VALUE 'Y'.           
           05  WS-NO                     PIC X(01) VALUE 'N'.           
           05  WS-OLD-FACTOR-ID          PIC X(09) VALUE SPACES.        
           05  WS-FACTOR                 PIC 9(13).                     
           05  WS-FACTOR-DEC         REDEFINES WS-FACTOR.               
A03303         10 WS-FACTOR-R            PIC 9(9)V9(6).                 
           05  WS-FAC-CHRG-BASE-AM       PIC 9(9).                      
           05  WS-FAC-CHRG-BASE-AM-DEC   REDEFINES WS-FAC-CHRG-BASE-AM. 
               10 WS-FAC-CHRG-BASE-AM-R  PIC 9(7)V9(2).                 
T33149     05  WS-FAC-CHRG-BASE-AM-FMTD  PIC $$,$$$,$$9.99.             
           05  WS-ACCT-PRESENT           PIC X(01) VALUE 'N'.           
SRIDHA     05  WS-ROWS-FOR-ACCT          PIC S9(04) COMP.               
T33149     05  WS-UTL-SERVICE-ACTIVE     PIC X(01) VALUE 'N'.           
           05  WS-ACCOUNT-NO             PIC 9(13).                     
           05  WS-CURRENT-TIMESTAMP      PIC X(26).                     
           05  WS-CURRENT-DATE           PIC X(10).                     
           05  WS-RESTART-DATA-LENGTH    PIC S9(04) COMP VALUE +35.     
           05  WS-CHKP-LUW-LIMIT         PIC 9(04).                     
           05  WS-FLAG-TO-TURN-OFF-COMMITS                              
                                         PIC 9(04)         VALUE 9999.  
           05  WS-CHKP-UPD-LIMIT         PIC 9(04).                     
           05  WS-CHKP-SEQ-NO            PIC 9(05)         VALUE ZERO.  
           05  WS-DEFAULT-RESTART-REQ    PIC X(01)         VALUE 'N'.   
           05  WS-DEFAULT-CHKP-LUW-LIMIT                                
                                         PIC 9(04)         VALUE 5.     
           05  WS-DEFAULT-CHKP-UPD-LIMIT                                
                                         PIC 9(04)         VALUE 20.    
           05  WS-CHKP-LUW-COUNTER       PIC 9(04)  COMP-3 VALUE ZERO.  
           05  WS-CHKP-UPD-COUNTER       PIC S9(04) COMP-3 VALUE ZERO.  
           05  WS-ERROR-DESCRIPTION      PIC X(40).                     
           05  WS-PARM-REVENUE-MONTH.                                   
               10 WS-PARM-REV-YEAR       PIC 9(04).                     
               10 WS-PARM-REV-MONTH      PIC 9(02).                     
           05  WS-PARM-REV-MONTH-N      REDEFINES                       
                                WS-PARM-REVENUE-MONTH     PIC 9(06).    
           05  WS-CURR-REV-MONTH-NUM     PIC 9(06).                     
           05  WS-CURR-REV-MONTH REDEFINES                              
                          WS-CURR-REV-MONTH-NUM  PIC X(06).             
                                                                        
       01  WS-COUNTERS.                                                 
           05  WS-INPUT-RECS-READ        PIC S9(04) COMP VALUE ZERO.    
           05  WS-INPUT-RECS-ERROR       PIC S9(04) COMP VALUE ZERO.    
           05  WS-NO-RECS-INSERTED       PIC S9(04) COMP VALUE ZERO.    
           05  WS-INPUT-RECS-READ-DIS    PIC ZZZ9.                      
           05  WS-INPUT-RECS-ERROR-DIS   PIC S9(04) COMP VALUE ZERO.    
           05  WS-NO-RECS-INSERTED-DIS   PIC S9(04) COMP VALUE ZERO.    
           05  WS-DELINQ-VALUE           PIC ZZZ9.99999.                
           05  WS-WORK-QUEUE-COUNT       PIC S9(04) COMP VALUE ZERO.    
                                                                        
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME              PIC X(08) VALUE 'PCSCA322'.    
A04860     05  SCSCB077                  PIC X(8)  VALUE 'SCSCB077'.    
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  WS-NULL-IND               PIC S9(4) COMP.                
                                                                        
       01  WS-SWITCHES.                                                 
           05 WS-COMPR-EOF-SW            PIC X(01) VALUE 'N'.           
              88 END-OF-INPUT            VALUE 'Y'.                     
           05 WS-FCSCA322-STATUS         PIC X(02).                     
              88 COMPRIC-SUCCESSFUL      VALUE '00'.                    
              88 COMPRIC-EOF             VALUE '23'.                    
           05 WS-MORE-ROWS-FLAG          PIC X(01)  VALUE 'Y'.          
              88 END-OF-ROWS             VALUE 'N'.                     
              88 MORE-ROWS               VALUE 'Y'.                     
           05 WS-VALID-ACCOUNT           PIC X(01)  VALUE 'Y'.          
              88 VALID-ACCOUNT           VALUE 'Y'.                     
              88 NOT-VALID-ACCOUNT       VALUE 'N'.                     
           05 WS-SYSIN-EXIST             PIC X(01)  VALUE 'Y'.          
              88 SYSIN-EXISTS            VALUE 'Y'.                     
              88 SYSIN-DOES-NOT-EXIST    VALUE 'N'.                     
           05 WS-IS-THIS-A-RESTART       PIC X(01)  VALUE 'N'.          
              88 WS-THIS-IS-A-RESTART    VALUE 'Y'.                     
           05 WS-FIRST-RESTART-READ      PIC X(01)  VALUE 'N'.          
              88 FIRST-RESTART-READ      VALUE 'Y'.                     
           05 WS-RESTART-REQ             PIC X(01).                     
           05  WS-COUNT-UNSUCCESSFUL-ROWS                               
                                        PIC S9(04) COMP-3 VALUE ZERO.   
                                                                        
       01 WS-RESTART-DATA.                                              
           05  WS-RESTART-PROCESS-TYPE      PIC 9(01).                  
           05  WS-RESTART-JOB-COMPLETE REDEFINES                        
               WS-RESTART-PROCESS-TYPE      PIC X(01).                  
           05  WS-RESTART-JOB-STATUS        PIC X(01).                  
               88  WS-RUN-COMPLETED-NO-PROBLEMS        VALUE 'A'.       
               88  WS-RERUN-COMPLETED                  VALUE 'B'.       
               88  WS-RERUN-PENDING                    VALUE 'C'.       
           05  WS-RESTART-INPUT-DATE        PIC X(10).                  
           05  WS-RESTART-CHKP-SEQ-NO       PIC 9(05)  VALUE ZERO.      
           05  WS-RESTART-RECS-READ         PIC 9(09)  VALUE ZERO.      
           05  WS-RESTART-INPUT-RECS-ERROR  PIC S9(04) COMP VALUE ZERO. 
           05  WS-RESTART-NO-RECS-INSERTED  PIC S9(04) COMP VALUE ZERO. 
COB305     05 WS-RESTART-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.         
                                                                        
      ***************** PCSCA322 REPORT HEADERS **********************          
                                                                        
       01  WS-HEADING-LINES.                                            
                                                                        
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR REPORT TITLE-1        **           
      ***************************************************************           
           05 WS-RPT-TITLE-1.                                           
              10  FILLER                 PIC X(02) VALUE SPACES.        
              10  P-RPT-TITLE-PGNM       PIC X(08) VALUE 'PCSCA322'.    
              10  FILLER                 PIC X(43) VALUE SPACES.        
              10  P-RPT-DUMMY            PIC X(31).                     
              10  FILLER                 PIC X(29) VALUE SPACES.        
              10  FILLER                 PIC X(09) VALUE 'RUN-DATE:'.   
              10  P-RPT-RUN-MM           PIC X(02).                     
              10  FILLER                 PIC X(01) VALUE '/'.           
              10  P-RPT-RUN-DD           PIC X(02).                     
              10  FILLER                 PIC X(01) VALUE '/'.           
              10  P-RPT-RUN-YY           PIC X(02).                     
              10  FILLER                 PIC X(03) VALUE SPACES.        
                                                                        
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR REPORT TITLE-2        **           
      ***************************************************************           
           05 WS-RPT-TITLE-2.                                           
              10 FILLER                  PIC X(57)  VALUE SPACES.       
              10 P-RPT-COMPANY-NAME      PIC X(23).                     
              10 FILLER                  PIC X(33)  VALUE SPACES.       
              10 FILLER                  PIC X(09)  VALUE 'RUN TIME:'.  
              10 WS-REP-HH               PIC X(02).                     
              10 FILLER                  PIC X(01)  VALUE ':'.          
              10 WS-REP-MIN              PIC X(02).                     
              10 FILLER                  PIC X(01)  VALUE ':'.          
              10 WS-REP-SS               PIC X(02).                     
              10 FILLER                  PIC X(03)  VALUE SPACES.       
                                                                        
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR REPORT TITLE-3        **           
      ***************************************************************           
           05 WS-RPT-TITLE-3.                                           
              10 FILLER                  PIC X(52) VALUE SPACES.        
              10 P-RPT-REP-NAME          PIC X(43) VALUE                
                       'COMPETITIVE PRICING CONTROL REPORT         '.   
              10 FILLER                  PIC X(18) VALUE SPACES.        
              10 FILLER                  PIC X(10) VALUE 'PAGE    : '.  
              10 FILLER                  PIC X(03) VALUE SPACES.        
              10 WS-REP-PAGE             PIC ZZZ9.                      
              10 FILLER                  PIC X(03) VALUE SPACES.        
                                                                        
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR REPORT TITLE-4        **           
      ***************************************************************           
           05 WS-RPT-TITLE-4.                                           
              10 FILLER                  PIC X(57) VALUE SPACES.        
              10 P-EFFECTIVE             PIC X(12) VALUE                
                                         'EFFECTIVE : '.                
              10 P-EFF-MONTH             PIC X(09).                     
              10 FILLER                  PIC X(01)  VALUE SPACES.       
              10 P-EFF-YEAR              PIC X(04).                     
              10 FILLER                  PIC X(08)  VALUE SPACES.       
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR REPORT HEADER.       **            
      ***************************************************************           
                                                                        
           05 WS-RPT-HEADER1.                                           
              10 FILLER                  PIC X(38)  VALUE SPACES.       
              10 FILLER                  PIC X(10)  VALUE               
                      'ACCOUNT NO'.                                     
              10 FILLER                  PIC X(18)  VALUE SPACES.       
              10 FILLER                  PIC X(05)  VALUE               
                      'IC NO'.                                          
              10 FILLER                  PIC X(15)  VALUE SPACES.       
              10 FILLER                  PIC X(10)  VALUE               
                      'COMP PRICE'.                                     
              10 FILLER                  PIC X(07)  VALUE SPACES.       
                                                                        
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR BLANK LINE            **           
      ***************************************************************           
           05  WS-BLANK-LINE.                                           
               10 FILLER                  PIC X(133) VALUE SPACES.      
                                                                        
      ***************************************************************           
                                                                        
       01  WS-DETAIL-LINE.                                              
           10 FILLER                  PIC X(36)  VALUE SPACES.          
           10 P-ACCOUNT-NO            PIC X(13).                        
           10 FILLER                  PIC X(19)  VALUE SPACES.          
           10 P-IC-NO                 PIC X(02).                        
           10 FILLER                  PIC X(17)  VALUE SPACES.          
A03303     10 P-COMP-PRICE            PIC ZZ9.999999.                   
A03303     10 FILLER                  PIC X(01)  VALUE SPACES.          
                                                                        
       01  WS-TOTALS-LINE.                                              
           10 FILLER                  PIC X(50)  VALUE SPACES.          
           10 P-TEXT                  PIC X(25).                        
           10 FILLER                  PIC X(03)  VALUE ' : '.           
           10 P-COUNT                 PIC ZZZ9.                         
           10 FILLER                  PIC X(03)  VALUE SPACES.          
                                                                        
       01  WS-NO-DATA-LINE.                                             
           05 FILLER                     PIC X(48) VALUE SPACES.        
           05 FILLER                     PIC X(25) VALUE                
               '**** NO DATA THIS RUN****'.                             
           05 FILLER                     PIC X(55) VALUE SPACES.        
                                                                        
       01  WS-FOOTER1.                                                  
           05 FILLER                     PIC X(35) VALUE SPACES.        
           05 FILLER                     PIC X(25) VALUE                
               '* * * END OF REPORT * * *'.                             
           05 FILLER                     PIC X(72) VALUE SPACES.        
                                                                        
       01  WS-CURRENT-DT.                                               
           05  WS-CURRENT-YY             PIC 9(02).                     
           05  WS-CURRENT-MM             PIC 9(02).                     
           05  WS-CURRENT-DD             PIC 9(02).                     
                                                                        
       01  WS-CURRENT-TIME               PIC 9(08).                     
                                                                        
       01  WS-FLAGS.                                                    
           05 WS-Y                       PIC X(01)     VALUE 'Y'.       
           05 WS-N                       PIC X(01)     VALUE 'N'.       
           05 WS-I                       PIC X(01)     VALUE 'I'.       
                                                                        
       01  WS-ERROR-VARIABLES.                                          
           05  RS-RETURN-CODE            PIC S9(04) COMP.               
           05  RS-RETURN-CODE-DISP       PIC +Z(04).                    
           05  WS-DISP-RETURN-CODE       PIC +Z(04).                    
                                                                        
      *************************************************                         
      *  COMMON COPYBOOK FOR WORKING STORAGE          *                         
      *************************************************                         
                                                                        
       COPY CWS00010.                                                           
       COPY CWS00303.                                                           
       COPY CWS00038.                                                           
       COPY CWS00114.                                                           
       COPY CWS00039.                                                           
       COPY CWS09900.                                                           
                                                                        
       COPY FIOJC01.                                                            
                                                                        
       COPY FIOCA00.                                                            
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * SQL COMMUNICATION AREA                                        *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_JOB_PARM                                                  *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBJBPARM                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_ACCOUNT                                                   *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_FIXED_FCTR                                                *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
              INCLUDE TBFXDFCT                                                  
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * ADDED TABLE INCLUDES FOR JOURNALING                           *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSPLFTR                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRESTRT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
A04860/****** FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077             
A04860      EXEC SQL                                                            
A04860           INCLUDE CWS00077                                               
A04860      END-EXEC.                                                           
A04860*                                                                         
                                                                        
       01  WS-END                              PIC X(40) VALUE          
             'WORKING STORAGE FOR PCSCA322 ENDS HERE  '.                
                                                                        
HPCCDM*EJECT                                                                    
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           MOVE '0000' TO  WS-ACTIVE-PARAGRAPH.                         
                                                                        
           PERFORM 0100-INITIALIZATION                                  
              THRU 0100-EXIT.                                           
                                                                        
           PERFORM 7000-READ-INPUT-FILE        THRU  7000-EXIT.         
                                                                        
           PERFORM 1000-PROCESS-INPUT-PARA     THRU  1000-EXIT          
                   UNTIL END-OF-INPUT                                   
                                                                        
           IF WS-INPUT-RECS-READ GREATER THAN ZERO                      
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '************PCSCA322 PROCESSING ERROR*******'   
               DISPLAY 'INPUT FILE EMPTY '                              
               MOVE SPACES                 TO  WS-RESTART-JOB-COMPLETE  
               PERFORM 8897-WRITE-RSDDR        THRU 8897-EXIT           
               MOVE 03 TO RETURN-CODE                                   
               PERFORM 8600-PRINT-RPT-NO-DATA  THRU 8600-EXIT           
               PERFORM 9000-TERMINATE THRU 9000-EXIT                    
               STOP RUN                                                 
           END-IF.                                                      
                                                                        
           MOVE SPACES                         TO                       
                                               WS-RESTART-JOB-COMPLETE. 
           IF WS-THIS-IS-A-RESTART                                      
              SET WS-RERUN-COMPLETED           TO TRUE                  
           ELSE                                                         
              SET WS-RUN-COMPLETED-NO-PROBLEMS TO TRUE                  
           END-IF.                                                      
           IF WS-CHKP-LUW-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS       
              AND WS-CHKP-UPD-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS   
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 8897-WRITE-RSDDR         THRU 8897-EXIT           
           END-IF.                                                      
                                                                        
           IF WS-RESTART-REQ EQUAL WS-YES                               
              PERFORM 8893-RESET-RESTART-REQ-PARM                       
                                               THRU 8893-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM 9000-TERMINATE              THRU 9000-EXIT           
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************               
      **                                                       **               
      **    0100-INITIALIZATION.                               **               
      **        INITIALIZATION ROUTINE                         **               
      **                                                       **               
      ***********************************************************               
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           MOVE '0100'                     TO   WS-ACTIVE-PARAGRAPH.    
                                                                        
      * GET CURRENT DATE                                                        
           ACCEPT WS-CURRENT-DT            FROM DATE.                   
           MOVE   WS-CURRENT-YY            TO   P-RPT-RUN-YY.           
           MOVE   WS-CURRENT-MM            TO   P-RPT-RUN-MM.           
           MOVE   WS-CURRENT-DD            TO   P-RPT-RUN-DD.           
                                                                        
      * GET CURRENT TIME                                                        
           ACCEPT WS-CURRENT-TIME          FROM TIME.                   
           MOVE   WS-CURRENT-TIME(1:2)     TO   WS-REP-HH.              
           MOVE   WS-CURRENT-TIME(3:2)     TO   WS-REP-MIN.             
           MOVE   WS-CURRENT-TIME(5:2)     TO   WS-REP-SS.              
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
                                                                        
           OPEN INPUT FCSCA322-FILE                                     
                                                                        
           IF COMPRIC-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '************************************'           
               DISPLAY '**   PCSCA322 PROCESSING ERROR    **'           
               DISPLAY '**     ERROR OPENING COMPRIC      **'           
               DISPLAY '**     FILE 3TATUS =' WS-FCSCA322-STATUS        
               DISPLAY '************************************'           
               PERFORM 9900-ABEND                    THRU 9900-EXIT     
           END-IF.                                                      
                                                                        
           PERFORM 7200-GET-CURRENT-TIMESTAMP THRU 7200-EXIT            
      *                                                                         
           PERFORM 6253-GET-FJC01-CHKP-LIMIT     THRU 6253-EXIT         
           INITIALIZE   WS-SYSIPT                                       
           IF WS-CHKP-LUW-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS       
             AND WS-CHKP-UPD-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS    
               DISPLAY ' '                                              
               DISPLAY '**   ' WS-PGRMNAME ' INFORMATIONAL MSG    **'   
               DISPLAY '**   CHKP-LUW AND CHKP-UPD PARMS   **'          
               DISPLAY '** BOTH SET TO ' WS-FLAG-TO-TURN-OFF-COMMITS    
                       ', INTERPRETED TO**'                             
               DISPLAY '**  INDICATE THAT INTERIM COMMIT   **'          
               DISPLAY '**   POINTS SHOULD NOT BE TAKEN.   **'          
               DISPLAY '** COMPLETE RERUN WILL BE REQUIRED **'          
               DISPLAY '**  UPON UNSUCCESSFUL COMPLETION.  **'          
               DISPLAY '**      PROCESSING CONTINUING      **'          
           END-IF.                                                      
                                                                        
      *****************************************************************         
      *    GET THE COMMON-DATE FROM THE JOB_PARM TABLE                *         
      *****************************************************************         
           PERFORM 6251-GET-FJC01-DATE     THRU 6251-EXIT.              
                                                                        
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON  '              TO WS-PGRMNAME               
              MOVE SPACES                  TO WS-INPUT-AREA             
              PERFORM 6251-GET-FJC01-DATE  THRU 6251-EXIT               
              MOVE WS-PGRNAME              TO WS-PGRMNAME               
           ELSE                                                         
              MOVE WS-FCA00-COMMON-DATE    TO WS-INPUT-DATE             
           END-IF                                                       
      *                                                                         
           PERFORM 6200-GET-PARAMETER-DATE THRU 6200-EXIT               
      *                                                                         
           IF  END-OF-SYSIPT                                            
               NEXT SENTENCE                                            
           ELSE                                                         
               PERFORM 7611-CLOSE          THRU 7611-EXIT               
           END-IF.                                                      
      *                                                                         
           MOVE WS-PARM-YR                 TO WS-PARM-REV-YEAR.         
           MOVE WS-PARM-MONTH              TO WS-PARM-REV-MONTH.        
           MOVE WS-PARM-REV-MONTH-N        TO WS-CURR-REV-MONTH-NUM.    
      *                                                                         
           PERFORM 6235-GET-FJC01-RESTART-REQ  THRU 6235-EXIT.          
           INITIALIZE   WS-SYSIPT                                       
           PERFORM 0600-PREPARE-FOR-RESTART    THRU  0600-EXIT.         
           PERFORM 0605-VALIDATE-RESTART-REQ   THRU 0605-EXIT.          
           IF  WS-THIS-IS-A-RESTART                                     
               NEXT SENTENCE                                            
           ELSE                                                         
               PERFORM 0610-INITIALIZE-RESTART THRU 0610-EXIT           
               MOVE WS-INPUT-DATE       TO WS-RESTART-INPUT-DATE        
           END-IF.                                                      
      *                                                                         
           MOVE '01'                             TO C8-COMPANY-NO       
           MOVE 'WQ-CIG-BID-MAX'                 TO C8-DELINQ-CD        
           PERFORM 7700-GET-MAX-WQ-LIMIT         THRU 7700-EXIT         
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *         0600-PREPARE-FOR-RESTART                              *         
      *****************************************************************         
       0600-PREPARE-FOR-RESTART.                                        
           MOVE PROGRAM-NAME                 TO RF-NAME-PROGRAM.        
           MOVE WS-ONE                       TO RF-PARTITION-NO.        
           MOVE WS-ONE                       TO RF-DUP-CNTRL-NO.        
           PERFORM 7450-SELECT-RESTART-DATA  THRU 7450-EXIT.            
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               MOVE RF-RESTART-DATA-TEXT     TO WS-RESTART-DATA         
               IF  WS-RESTART-PROCESS-TYPE NUMERIC                      
                   MOVE WS-YES               TO WS-IS-THIS-A-RESTART    
              ELSE                                                      
                 GO TO 0600-EXIT                                        
              END-IF                                                    
           ELSE                                                         
              GO TO 0600-EXIT                                           
           END-IF.                                                      
      *****************************************************************         
      *         REPOSITION INPUT FILE                                 *         
      *****************************************************************         
           PERFORM 7000-READ-INPUT-FILE      THRU 7000-EXIT             
             UNTIL WS-INPUT-RECS-READ EQUAL  WS-RESTART-RECS-READ.      
           DISPLAY '*******************************************'.       
           DISPLAY '*****  THIS IS A RESTART OF PCSCA322  *****'.       
           DISPLAY '*******************************************'.       
           MOVE WS-RESTART-CHKP-SEQ-NO       TO WS-CHKP-SEQ-NO.         
                                                                        
           MOVE WS-RESTART-RECS-READ         TO WS-INPUT-RECS-READ      
           MOVE WS-RESTART-INPUT-RECS-ERROR  TO WS-INPUT-RECS-ERROR     
           MOVE WS-RESTART-NO-RECS-INSERTED  TO WS-NO-RECS-INSERTED     
                                                                        
           SET FIRST-RESTART-READ            TO TRUE.                   
           MOVE ZERO                         TO WS-RESTART-RECS-READ.   
      *****************************************************************         
      *    THE FOLLOWING CODE COMPARES RUN DATE STORED IN                       
      *    RESTART DATA TO RUN DATE FROM JOB CONTROL FILE:                      
      *****************************************************************         
           IF WS-RESTART-INPUT-DATE  EQUAL WS-INPUT-DATE                
             OR WS-RESTART-INPUT-DATE EQUAL SPACES                      
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '***************************************'        
               DISPLAY '** RUN DATE WAS CHANGED PRIOR TO '              
                       'RESTART **'                                     
               DISPLAY '***************************************'        
               DISPLAY '** OLD RUN DATE = ' WS-RESTART-INPUT-DATE       
               DISPLAY '** NEW RUN DATE = ' WS-INPUT-DATE               
           END-IF.                                                      
       0600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                                         
      *    0605-VALIDATE-RESTART                                                
      *                                                                         
      *****************************************************************         
      *                                                               *         
       COPY CPD00030.                                                           
      *                                                               *         
      *****************************************************************         
      *    0610-INITIALIZE-RESTART                                    *         
      *****************************************************************         
      *                                                               *         
       0610-INITIALIZE-RESTART.                                         
      *                                                               *         
           MOVE ZEROS                      TO WS-RESTART-PROCESS-TYPE   
           MOVE SPACES                     TO WS-RESTART-INPUT-DATE     
           MOVE ZEROS                      TO WS-RESTART-CHKP-SEQ-NO    
           MOVE ZEROS                      TO WS-INPUT-RECS-READ.       
      *                                                                         
       0610-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *************************************************************             
      **                                                         **             
      **      1000-PROCESS-INPUT-PARA                            **             
      **           MAIN PROCESS                                  **             
      **                                                         **             
      *************************************************************             
                                                                        
       1000-PROCESS-INPUT-PARA.                                         
                                                                        
           MOVE '1000' TO WS-ACTIVE-PARAGRAPH.                          
                                                                        
A04860     INITIALIZE CWS00077-FIELDS                                   
                                                                        
           PERFORM 2100-POPULATE-EFF-DATE     THRU 2100-EXIT            
                                                                        
           PERFORM 2000-VALIDATE-INPUT  THRU 2000-EXIT                  
                                                                        
           DISPLAY 'ACCOUNT : ' E-FCA322-ACCOUNT-NO                     
                                                                        
           IF VALID-ACCOUNT                                             
              MOVE E-FCA322-ACCOUNT-NO       TO WS-ACCOUNT-NO           
              MOVE WS-ACCOUNT-NO             TO FF-ACCOUNT-NO           
T33149                                          UT-ACCOUNT-NO           
              MOVE E-FCA322-CODE-UTIL-TYPE   TO FF-CODE-UTIL-TYPE       
T33149                                          UT-CODE-UTIL-TYPE       
              MOVE E-FCA322-IC-NO            TO FF-IC-NO                
T33149                                          UT-IC-NO                
              MOVE E-FCA322-EFF-DATE-FROM    TO FF-EFF-DATE-FROM        
              MOVE E-FCA322-EFF-DATE-TO      TO FF-EFF-DATE-TO          
                                                                        
              MOVE WS-CURRENT-TIMESTAMP      TO FF-LAST-UPDATE-TS       
                                                                        
              MOVE E-FCA322-FACTOR           TO WS-FACTOR               
                                                                        
A03303        IF SF-FCTR-POWER-10 < 0                                   
A03303          COMPUTE WS-FACTOR-R  = FF-FACTOR * 10** SF-FCTR-POWER-10
A03303          MOVE WS-FACTOR-R             TO FF-FACTOR               
A03303          MOVE 0                       TO SF-FCTR-POWER-10        
A03303        ELSE                                                      
A03303           MOVE WS-FACTOR-R             TO FF-FACTOR              
A03303        END-IF                                                    
              MOVE E-FCA322-FACTOR-ID        TO FF-FACTOR-ID            
              MOVE E-FCA322-CMPNT-ID-CD      TO FF-CMPNT-ID-CD          
              MOVE E-FCA322-FIXED-FCTR-TYP-CD TO FF-FIXED-FCTR-TYP-CD   
              MOVE E-FCA322-INSTR-USE-TYPE-CD TO FF-INSTR-USE-TYPE-CD   
              MOVE E-FCA322-FAC-CHRG-BASE-AM TO WS-FAC-CHRG-BASE-AM     
              MOVE WS-FAC-CHRG-BASE-AM-R     TO FF-FAC-CHRG-BASE-AM     
              MOVE 0                         TO FF-CODE-TIME-PERIOD     
              MOVE 'B'                       TO FF-CODE-SEASON          
SRIDHA*- DO A SELECT TO SEE IF THIS ROW ALREADY EXISTS                          
SRIDHA*- QUERY TO DO THE SELECT WOULD FIND ANY ROWS WITH SAME                   
SRIDHA*- ACCOUNT NO , CODE UTIL TYPE, IC NO AND OVERLAPPING                     
SRIDHA*- EFFECTIVE TO DATE AND EFFECTIVE FROM DATE                              
              INITIALIZE                     FF-FIXED-FCTR-SEQ-NO       
              PERFORM 7100-SELECT-MAX-SEQ-NO THRU 7100-EXIT             
              COMPUTE FF-FIXED-FCTR-SEQ-NO = FF-FIXED-FCTR-SEQ-NO + 1   
SRIDHA        IF (WS-ROWS-FOR-ACCT = 0)                                 
T33149          PERFORM 7800-CHECK-SERVICE-ACTIVE THRU 7800-EXIT        
T33149          IF WS-UTL-SERVICE-ACTIVE = 'Y'                          
                  PERFORM 8100-INSERT-FACTOR      THRU 8100-EXIT        
T33149          ELSE                                                    
A04860            MOVE SPACES                TO WS-77-COMMENTS-TEXT     
T33149            MOVE WS-ACCOUNT-NO         TO AT-ACCOUNT-NO           
T33149            PERFORM 7400-GET-PREMISE-CUST THRU 7400-EXIT          
T33149            MOVE WS-FAC-CHRG-BASE-AM-R TO WS-FAC-CHRG-BASE-AM-FMTD
T33149            DISPLAY ' '                                           
T33149            DISPLAY 'COMPETITIVE PRICE CAN NOT BE POSTED AS THERE'
T33149                    ' ARE NO SERVICES ATTACHED TO IC = '          
T33149                    E-FCA322-IC-NO '. PRICE = '                   
T33149                    WS-FAC-CHRG-BASE-AM-FMTD                      
T33149            STRING  'COMPETITIVE PRICE CAN NOT BE POSTED AS THERE'
T33149                    ' ARE NO SERVICES ATTACHED TO IC = '          
T33149                    E-FCA322-IC-NO '. PRICE = '                   
T33149                    WS-FAC-CHRG-BASE-AM-FMTD                      
A04860            DELIMITED BY SIZE INTO WS-77-COMMENTS-TEXT            
T33149            PERFORM 5000-CREATE-WORK-QUEUE  THRU 5000-EXIT        
T33149          END-IF                                                  
SRIDHA        ELSE IF (WS-ROWS-FOR-ACCT = 1)                            
SRIDHA                PERFORM 8200-UPDATE-FACTOR THRU 8200-EXIT         
SRIDHA             END-IF                                               
T27237        END-IF                                                    
              ADD WS-ONE                     TO WS-CHKP-LUW-COUNTER     
              IF (WS-CHKP-LUW-COUNTER EQUAL WS-CHKP-LUW-LIMIT)          
                OR (WS-CHKP-UPD-COUNTER EQUAL WS-CHKP-UPD-LIMIT         
                OR GREATER WS-CHKP-UPD-LIMIT)                           
                 PERFORM 8896-ISSUE-CHKP THRU 8896-EXIT                 
              END-IF                                                    
                                                                        
              PERFORM 3000-CONTROL-REPORT    THRU 3000-EXIT             
           ELSE                                                         
              ADD +1                         TO WS-INPUT-RECS-ERROR     
           END-IF                                                       
                                                                        
           PERFORM 7000-READ-INPUT-FILE     THRU 7000-EXIT              
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **     2000-VALIDATE-INPUT                                   **           
      **          VALIDATE THE INPUT AND CREATE WQS IF INVALID     **           
      ***************************************************************           
                                                                        
       2000-VALIDATE-INPUT.                                             
                                                                        
           MOVE '2000'                          TO WS-ACTIVE-PARAGRAPH. 
                                                                        
           SET VALID-ACCOUNT                    TO TRUE                 
           IF E-FCA322-ACCOUNT-NO IS NUMERIC                            
              MOVE E-FCA322-FACTOR            TO WS-FACTOR              
              IF VALID-ACCOUNT AND E-FCA322-FACTOR IS NUMERIC           
                 AND WS-FACTOR > ZEROES                                 
                 MOVE E-FCA322-EFF-DATE-FROM  TO WS-EFF-DATE            
                 PERFORM 7500-VALIDATE-DATE  THRU 7500-EXIT             
                 MOVE E-FCA322-EFF-DATE-TO    TO WS-EFF-DATE            
                 PERFORM 7500-VALIDATE-DATE  THRU 7500-EXIT             
                 IF E-FCA322-EFF-DATE-FROM(1:4)                         
                                           EQUAL WS-CURR-REV-MONTH(1:4) 
                 AND E-FCA322-EFF-DATE-FROM(6:2)                        
                                           EQUAL WS-CURR-REV-MONTH(5:2) 
                    IF E-FCA322-EFF-DATE-TO(1:4)                        
                                           EQUAL WS-CURR-REV-MONTH(1:4) 
                    AND E-FCA322-EFF-DATE-TO(6:2)                       
                                            EQUAL WS-CURR-REV-MONTH(5:2)
                       PERFORM 7300-CHECK-FOR-ACCT THRU 7300-EXIT       
                       IF (WS-ACCT-PRESENT = 'Y'                        
SRIDHA*                    AND WS-ROWS-FOR-ACCT > 1)                            
T27237                     AND WS-ROWS-FOR-ACCT > 0)                    
                          MOVE E-FCA322-ACCOUNT-NO TO WS-ACCOUNT-NO     
                          MOVE WS-ACCOUNT-NO  TO AT-ACCOUNT-NO          
A03303                 PERFORM 7310-SPCL-FCTR-VALUE      THRU 7310-EXIT 
                          PERFORM 7400-GET-PREMISE-CUST THRU 7400-EXIT  
A04860                    MOVE SPACES TO WS-77-COMMENTS-TEXT            
                          DISPLAY ' '                                   
                          DISPLAY 'ACCOUNT NO: ' E-FCA322-ACCOUNT-NO    
                 ' FACTOR ALREADY EXISTS FOR THE EFFECTIVE PERIOD'      
                       END-IF                                           
                    ELSE                                                
                       MOVE E-FCA322-ACCOUNT-NO TO WS-ACCOUNT-NO        
                       MOVE WS-ACCOUNT-NO     TO AT-ACCOUNT-NO          
                       PERFORM 7400-GET-PREMISE-CUST THRU 7400-EXIT     
A04860                 MOVE SPACES            TO WS-77-COMMENTS-TEXT    
                       DISPLAY ' '                                      
                       DISPLAY 'ACCOUNT NO: ' E-FCA322-ACCOUNT-NO       
                               ' EFF-DATE-TO NOT IN CURRENT MONTH/YEAR' 
                       STRING 'ACCT NO : ' E-FCA322-ACCOUNT-NO          
                              ' EFF-DATE-TO ' E-FCA322-EFF-DATE-TO      
                              ' NOT IN CURRENT MONTH/YEAR'              
A04860                 DELIMITED BY SIZE INTO WS-77-COMMENTS-TEXT       
                       PERFORM 5000-CREATE-WORK-QUEUE THRU 5000-EXIT    
                       SET NOT-VALID-ACCOUNT      TO TRUE               
                    END-IF                                              
                 ELSE                                                   
                    MOVE E-FCA322-ACCOUNT-NO  TO WS-ACCOUNT-NO          
                    MOVE WS-ACCOUNT-NO        TO AT-ACCOUNT-NO          
                    PERFORM 7400-GET-PREMISE-CUST THRU 7400-EXIT        
A04860              MOVE SPACES               TO WS-77-COMMENTS-TEXT    
                    DISPLAY ' '                                         
                    DISPLAY 'ACCOUNT NO: ' E-FCA322-ACCOUNT-NO          
                            ' EFF FROM DATE NOT IN CURRENT MONTH/YEAR'  
                    STRING 'ACCT NO : ' E-FCA322-ACCOUNT-NO             
                           ' EFF-DATE-FROM ' E-FCA322-EFF-DATE-FROM     
                           ' NOT IN CURRENT MONTH/YEAR'                 
A04860              DELIMITED BY SIZE INTO WS-77-COMMENTS-TEXT          
                    PERFORM 5000-CREATE-WORK-QUEUE THRU 5000-EXIT       
                    SET NOT-VALID-ACCOUNT         TO TRUE               
                 END-IF                                                 
                 IF VALID-ACCOUNT                                       
                    IF E-FCA322-EFF-DATE-FROM <= E-FCA322-EFF-DATE-TO   
                       CONTINUE                                         
                    ELSE                                                
                       MOVE E-FCA322-ACCOUNT-NO TO WS-ACCOUNT-NO        
                       MOVE WS-ACCOUNT-NO     TO AT-ACCOUNT-NO          
                       PERFORM 7400-GET-PREMISE-CUST THRU 7400-EXIT     
A04860                 MOVE SPACES            TO WS-77-COMMENTS-TEXT    
                       DISPLAY ' '                                      
                       DISPLAY 'ACCOUNT NO: ' E-FCA322-ACCOUNT-NO       
                               ' EFF FROM DATE > EFF DATE TO'           
                       STRING 'ACCT NO : ' E-FCA322-ACCOUNT-NO          
                              ' EFF-DATE-FROM ' E-FCA322-EFF-DATE-FROM  
                              ' GREATER THAN EFF-DATE-TO '              
                                E-FCA322-EFF-DATE-TO                    
A04860                 DELIMITED BY SIZE INTO WS-77-COMMENTS-TEXT       
                       PERFORM 5000-CREATE-WORK-QUEUE THRU 5000-EXIT    
                       SET NOT-VALID-ACCOUNT      TO TRUE               
                    END-IF                                              
                 END-IF                                                 
              ELSE                                                      
                 MOVE E-FCA322-ACCOUNT-NO     TO WS-ACCOUNT-NO          
                 MOVE WS-ACCOUNT-NO           TO AT-ACCOUNT-NO          
                 PERFORM 7400-GET-PREMISE-CUST THRU 7400-EXIT           
A04860           MOVE SPACES         TO WS-77-COMMENTS-TEXT             
                 DISPLAY ' '                                            
                 DISPLAY 'ACCOUNT NO: ' E-FCA322-ACCOUNT-NO             
                         ' HAS A INVALID FACTOR '                       
                 STRING 'ACCT NO : ' E-FCA322-ACCOUNT-NO                
                        ' HAS A INVALID FACTOR  ' E-FCA322-FACTOR       
A04860           DELIMITED BY SIZE INTO WS-77-COMMENTS-TEXT             
                 PERFORM 5000-CREATE-WORK-QUEUE THRU 5000-EXIT          
                 SET NOT-VALID-ACCOUNT        TO TRUE                   
              END-IF                                                    
           ELSE                                                         
A04860        MOVE SPACES            TO WS-77-COMMENTS-TEXT             
              DISPLAY ' '                                               
              DISPLAY 'ACCOUNT NO: ' E-FCA322-ACCOUNT-NO                
                      ' NOT A VALID ACCOUNT NUMBER '                    
              STRING 'ACCT NO : ' E-FCA322-ACCOUNT-NO                   
                     ' NOT VALID   '                                    
A04860        DELIMITED BY SIZE INTO WS-77-COMMENTS-TEXT                
              INITIALIZE                     AT-ACCOUNT-NO              
                                             AT-PREMISE-NO              
                                             AT-CUSTOMER-NO             
              PERFORM 5000-CREATE-WORK-QUEUE  THRU 5000-EXIT            
              SET NOT-VALID-ACCOUNT           TO TRUE                   
           END-IF                                                       
           .                                                            
       2000-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************           
      **     2100-POPULATE-EFF-DATE                                **           
      **          POPULATE MONTH AND YEAR ON CONTROL REPORT        **           
      ***************************************************************           
                                                                        
       2100-POPULATE-EFF-DATE.                                          
                                                                        
           MOVE '2100'                      TO WS-ACTIVE-PARAGRAPH.     
                                                                        
           MOVE WS-CURR-REV-MONTH(1:4)      TO P-EFF-YEAR               
           EVALUATE WS-CURR-REV-MONTH-NUM(5:2)                          
              WHEN 01                                                   
                  MOVE '  JANUARY'          TO P-EFF-MONTH              
              WHEN 02                                                   
                  MOVE ' FEBRUARY'          TO P-EFF-MONTH              
              WHEN 03                                                   
                  MOVE '    MARCH'          TO P-EFF-MONTH              
              WHEN 04                                                   
                  MOVE '    APRIL'          TO P-EFF-MONTH              
              WHEN 05                                                   
                  MOVE '      MAY'          TO P-EFF-MONTH              
              WHEN 06                                                   
                  MOVE '     JUNE'          TO P-EFF-MONTH              
              WHEN 07                                                   
                  MOVE '     JULY'          TO P-EFF-MONTH              
              WHEN 08                                                   
                  MOVE '   AUGUST'          TO P-EFF-MONTH              
              WHEN 09                                                   
                  MOVE 'SEPTEMBER'          TO P-EFF-MONTH              
              WHEN 10                                                   
                  MOVE '  OCTOBER'          TO P-EFF-MONTH              
              WHEN 11                                                   
                  MOVE ' NOVEMBER'          TO P-EFF-MONTH              
              WHEN 12                                                   
                  MOVE ' DECEMBER'          TO P-EFF-MONTH              
           END-EVALUATE                                                 
           .                                                            
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **     3000-CONTROL-REPORT                                   **           
      **          MOVES VALUES FROM THE DATABASE TO THE REPORT     **           
      ***************************************************************           
                                                                        
       3000-CONTROL-REPORT.                                             
                                                                        
           MOVE '3000'                          TO WS-ACTIVE-PARAGRAPH. 
                                                                        
           MOVE WS-PGRMNAME                     TO   P-RPT-TITLE-PGNM.  
           MOVE '    S C ELECTRIC & GAS CO    ' TO P-RPT-DUMMY          
           MOVE '         CIG'                  TO P-RPT-COMPANY-NAME   
           MOVE E-FCA322-ACCOUNT-NO             TO P-ACCOUNT-NO         
           MOVE E-FCA322-IC-NO                  TO P-IC-NO              
           MOVE WS-FACTOR-R                     TO P-COMP-PRICE         
                                                                        
           PERFORM 8000-PRINT-RPT-REPORT        THRU 8000-EXIT          
           .                                                            
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       5000-CREATE-WORK-QUEUE.                                          
                                                                        
           IF WS-WORK-QUEUE-COUNT < C8-DELINQ-VALUE                     
A04860        MOVE '5000'                 TO WS-ACTIVE-PARAGRAPH        
A04860                                                                  
A04860        MOVE +125                   TO WS-77-COMMENTS-LEN         
A04860        MOVE +142                   TO WS-77-CATEGORY-ID          
A04860        MOVE 'H'                    TO WS-77-PRIORITY             
A04860        MOVE '4'                    TO WS-77-ROUTE-CATEGORY       
A04860        MOVE ZERO                   TO WS-77-SERV-ORDER-NO        
A04860        MOVE WS-CURRENT-TIMESTAMP   TO WS-77-DATE-REQUIRED        
A04860                                       WS-77-DATE-CREATED         
A04860        MOVE AT-ACCOUNT-NO          TO WS-77-ACCOUNT-NO           
A04860        MOVE SPACES                 TO WS-77-LOCAL-OFFICE         
A04860        MOVE AT-PREMISE-NO          TO WS-77-PREMISE-NO           
A04860        MOVE AT-CUSTOMER-NO         TO WS-77-CUSTOMER-NO          
A04860        MOVE 'SYSTEM'               TO WS-77-USER-ID-ORIG         
A04860        MOVE SPACES                 TO WS-77-RESP-AREA-ID         
A04860        MOVE ZERO                   TO WS-77-FREE-FORM-LEN        
A04860        MOVE LOW-VALUES             TO WS-77-FREE-FORM-TXT        
A04860        MOVE PROGRAM-NAME           TO WS-77-CREATED-BY           
A04860                                                                  
              PERFORM 8895-INSERT-WORK-QUEUE  THRU 8895-EXIT            
                                                                        
              ADD +1                      TO  WS-WORK-QUEUE-COUNT       
           ELSE                                                         
              DISPLAY '***  PROGRAM ABEND    ***'                       
              MOVE C8-DELINQ-VALUE        TO WS-DELINQ-VALUE            
              DISPLAY 'NO OF WQS EXCEEDED MAX LIMIT OF '                
                                           WS-DELINQ-VALUE              
              DISPLAY 'THE PROGRAM HAS BEEN FORCED TO ABEND'            
              PERFORM 9900-ABEND        THRU  9900-EXIT                 
           END-IF                                                       
           .                                                            
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *       8895-INSERT-WORK-QUEUE                                  *         
      *****************************************************************         
A04860*                                                                         
A04860 8895-INSERT-WORK-QUEUE.                                          
A04860*                                                                         
A04860     CALL SCSCB077 USING CWS00077-FIELDS,                         
A04860                         ABEND-FILE,                              
A04860                         RS-RETURN-CODE                           
A04860     MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE                 
A04860                                                                  
A04860     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
A04860        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A04860        DISPLAY '8895-INSERT-WORK-QUEUE'                          
A04860        DISPLAY 'CALL SCSCB077         '                          
A04860        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
A04860        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
A04860        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
A04860        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A04860        PERFORM 9900-ABEND    THRU 9900-EXIT                      
A04860     END-IF.                                                      
A04860 8895-EXIT.                                                       
A04860     EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *       6235-GET-FJC01-RESTART-REQ.                                       
      *****************************************************************         
      *                                                                         
       COPY CPD00035.                                                           
      *                                                                         
      *****************************************************************         
      *       6251-GET-FJC01-DATE.                                              
      *****************************************************************         
      *                                                                         
       COPY CPD00037.                                                           
      *                                                                         
      *****************************************************************         
      *       6253-GET-FJC01-CHKP-LIMIT.                                        
      *****************************************************************         
      *                                                                         
       COPY CPD00034.                                                           
      *                                                                         
      **********************************************************                
      ** 6200-GET-PARAMETER-DATE                              **                
      **********************************************************                
           EXEC SQL                                                             
                 INCLUDE CPD00114                                               
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      **  READ INPUT FILE COMPETITIVE PRICING                      **           
      ***************************************************************           
      *                                                                         
       7000-READ-INPUT-FILE.                                            
                                                                        
           READ FCSCA322-FILE                                           
               AT END                                                   
                  SET END-OF-INPUT    TO TRUE                           
                  GO TO 7000-EXIT.                                      
                                                                        
           IF COMPRIC-SUCCESSFUL                                        
              ADD +1                  TO WS-INPUT-RECS-READ             
           ELSE                                                         
               DISPLAY '**************************************'         
               DISPLAY '**     PCSCA322 PROCESSING ERROR    **'         
               DISPLAY '**       ERROR READING INPUT FILE   **'         
               DISPLAY '**      FILE STATUS = ' WS-FCSCA322-STATUS      
               DISPLAY '**       PROCESSING TERMINATED      **'         
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND                    THRU 9900-EXIT     
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-SELECT-MAX-SEQ-NO                                         *        
      ******************************************************************        
       7100-SELECT-MAX-SEQ-NO.                                          
                                                                        
           EXEC SQL                                                     
              SELECT MAX(FIXED_FCTR_SEQ_NO)                             
                INTO :FF-FIXED-FCTR-SEQ-NO :WS-NULL-IND                  
                FROM CSS_FIXED_FCTR                                     
               WHERE ACCOUNT_NO        = :FF-ACCOUNT-NO                 
                 AND CODE_UTIL_TYPE    = :FF-CODE-UTIL-TYPE             
                 AND IC_NO             = :FF-IC-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**************************************'          
              DISPLAY '**   PCSCA322 PROCESSING ERROR      **'          
              DISPLAY '**   ERROR SELECTING CSS_FIXED_FCTR **'          
              DISPLAY '**   PROCESSING TERMINATED IN 7100- **'          
              DISPLAY '**   ACCOUNT-NO   : '  WS-ACCOUNT-NO             
              DISPLAY '**   CODE-UTIL-TYPE: ' FF-CODE-UTIL-TYPE         
              DISPLAY '**   IC-NO         : ' UT-IC-NO                  
              DISPLAY '**************************************'          
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7200-GET-CURRENT-TIMESTAMP                                  **        
      **       GET THE CURRENT TIMESTAMP                              **        
      ******************************************************************        
                                                                        
       7200-GET-CURRENT-TIMESTAMP.                                      
                                                                        
           EXEC SQL                                                     
T35434        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*          ,:WS-CURRENT-DATE      = CURRENT DATE                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '** PROCESSING ERROR IN PROGRAM PCSRP800 **'     
               DISPLAY '** PARA 7200-GET-CURRENT-TIMESTAMP      **'     
               DISPLAY '** ERROR DURING SELECT OF TIMESTAMP     **'     
               DISPLAY '** RETURN CODE =' WS-ACTIVE-RETURN-CODE         
               DISPLAY '**  PROCESSING TERMINATED               **'     
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7300-CHECK-FOR-ACCT                                            *        
      ******************************************************************        
       7300-CHECK-FOR-ACCT.                                             
                                                                        
           MOVE '7300'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           MOVE E-FCA322-ACCOUNT-NO          TO WS-ACCOUNT-NO           
           MOVE WS-ACCOUNT-NO                TO FF-ACCOUNT-NO           
           MOVE E-FCA322-CODE-UTIL-TYPE      TO FF-CODE-UTIL-TYPE       
           MOVE E-FCA322-IC-NO               TO FF-IC-NO                
SRIDHA     MOVE E-FCA322-FACTOR-ID           TO FF-FACTOR-ID            
           MOVE E-FCA322-EFF-DATE-FROM       TO FF-EFF-DATE-FROM        
           MOVE E-FCA322-EFF-DATE-TO         TO FF-EFF-DATE-TO          
           MOVE 'N'                          TO WS-ACCT-PRESENT         
           MOVE  0                           TO WS-ROWS-FOR-ACCT        
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(*),'Y'                                       
              INTO :WS-ROWS-FOR-ACCT,:WS-ACCT-PRESENT                   
                FROM CSS_FIXED_FCTR                                     
               WHERE ACCOUNT_NO           = :FF-ACCOUNT-NO              
                 AND CODE_UTIL_TYPE       = :FF-CODE-UTIL-TYPE          
                 AND IC_NO                = :FF-IC-NO                   
                 AND FACTOR_ID            = :FF-FACTOR-ID               
                 AND EFF_DATE_FROM       <= IIF(TRY_CONVERT(DATE, 
                                                        :FF-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FF-EFF-DATE-TO
              ), CONVERT(DATE, :FF-EFF-DATE-TO) )             
                 AND EFF_DATE_TO         >= IIF(TRY_CONVERT(DATE, 
                                                      :FF-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FF-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FF-EFF-DATE-FROM
              ), CONVERT(DATE, :FF-EFF-DATE-FROM) )           
      ***        AND EFF_DATE_TO          = :FF-EFF-DATE-TO                     
      ***        AND EFF_DATE_FROM        = :FF-EFF-DATE-FROM                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*),'Y'                                               
MFA-TR*       INTO :WS-ROWS-FOR-ACCT,:WS-ACCT-PRESENT                           
MFA-TR*         FROM CSS_FIXED_FCTR                                             
MFA-TR*        WHERE ACCOUNT_NO           = :FF-ACCOUNT-NO                      
MFA-TR*          AND CODE_UTIL_TYPE       = :FF-CODE-UTIL-TYPE                  
MFA-TR*          AND IC_NO                = :FF-IC-NO                           
MFA-TR*          AND FACTOR_ID            = :FF-FACTOR-ID                       
MFA-TR*          AND EFF_DATE_FROM       <= :FF-EFF-DATE-TO                     
MFA-TR*          AND EFF_DATE_TO         >= :FF-EFF-DATE-FROM                   
MFA-TR***        AND EFF_DATE_TO          = :FF-EFF-DATE-TO                     
MFA-TR***        AND EFF_DATE_FROM        = :FF-EFF-DATE-FROM                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**************************************'          
              DISPLAY '**   PCSCA322 PROCESSING ERROR      **'          
              DISPLAY '**   ERROR UPDATING CSS_FIXED_FACTR **'          
              DISPLAY '**   PROCESSING TERMINATED IN 7300- **'          
              DISPLAY '**   RETURN CODE = ' SQLCODE                     
              DISPLAY '**   ACCOUNT-NO   : ' WS-ACCOUNT-NO              
              DISPLAY '**   IC-NO        : ' FF-IC-NO                   
              DISPLAY '**************************************'          
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
A03303******************************************************************        
A03303* 7310-SPCL-FCTR-VALUE                                           *        
A03303******************************************************************        
A03303 7310-SPCL-FCTR-VALUE.                                            
                                                                        
A03303     EXEC SQL                                                     
A03303        SELECT FF.FACTOR                                          
A03303              ,SF.FCTR_POWER_10                                   
A03303        INTO  :FF-FACTOR                                          
A03303             ,:SF-FCTR-POWER-10                                   
A03303          FROM CSS_FIXED_FCTR FF                                  
A03303              ,CSS_SPCL_FCTR  SF                                  
A03303         WHERE FF.ACCOUNT_NO           = :FF-ACCOUNT-NO           
A03303           AND FF.CODE_UTIL_TYPE       = :FF-CODE-UTIL-TYPE       
A03303           AND FF.IC_NO                = :FF-IC-NO                
A03303           AND FF.FACTOR_ID            = :FF-FACTOR-ID            
A03303           AND FF.EFF_DATE_FROM       <= IIF(TRY_CONVERT(DATE, 
                                                        :FF-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FF-EFF-DATE-TO
              ), CONVERT(DATE, :FF-EFF-DATE-TO) )          
A03303           AND FF.EFF_DATE_TO         >= IIF(TRY_CONVERT(DATE, 
                                                      :FF-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FF-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FF-EFF-DATE-FROM
              ), CONVERT(DATE, :FF-EFF-DATE-FROM) )        
A03303           AND FF.FACTOR_ID            = SF.FACTOR_ID             
A03303     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FF.FACTOR                                                  
MFA-TR*             ,SF.FCTR_POWER_10                                           
MFA-TR*       INTO  :FF-FACTOR                                                  
MFA-TR*            ,:SF-FCTR-POWER-10                                           
MFA-TR*         FROM CSS_FIXED_FCTR FF                                          
MFA-TR*             ,CSS_SPCL_FCTR  SF                                          
MFA-TR*        WHERE FF.ACCOUNT_NO           = :FF-ACCOUNT-NO                   
MFA-TR*          AND FF.CODE_UTIL_TYPE       = :FF-CODE-UTIL-TYPE               
MFA-TR*          AND FF.IC_NO                = :FF-IC-NO                        
MFA-TR*          AND FF.FACTOR_ID            = :FF-FACTOR-ID                    
MFA-TR*          AND FF.EFF_DATE_FROM       <= :FF-EFF-DATE-TO                  
MFA-TR*          AND FF.EFF_DATE_TO         >= :FF-EFF-DATE-FROM                
MFA-TR*          AND FF.FACTOR_ID            = SF.FACTOR_ID                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03303                                                                  
A03303     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A03303                                                                  
A03303     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A03303        CONTINUE                                                  
A03303     ELSE                                                         
A03303        DISPLAY '**************************************'          
A03303        DISPLAY '**   PCSCA322 PROCESSING ERROR      **'          
A03303        DISPLAY '**   ERROR FETCHING FCTR_POWER_10   **'          
A03303        DISPLAY '**   PROCESSING TERMINATED IN 7310- **'          
A03303        DISPLAY '**   RETURN CODE = ' SQLCODE                     
A03303        DISPLAY '**   ACCOUNT-NO   : ' WS-ACCOUNT-NO              
A03303        DISPLAY '**   IC-NO        : ' FF-IC-NO                   
A03303        DISPLAY '**************************************'          
A03303        PERFORM 9900-ABEND                 THRU 9900-EXIT         
A03303     END-IF.                                                      
                                                                        
A03303 7310-EXIT.                                                       
A03303     EXIT.                                                        
      ******************************************************************        
      * 7400-GET-PREMISE-CUST                                          *        
      ******************************************************************        
       7400-GET-PREMISE-CUST.                                           
                                                                        
           MOVE '7400'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT PREMISE_NO                                         
                    ,CUSTOMER_NO                                        
                INTO :AT-PREMISE-NO                                     
                    ,:AT-CUSTOMER-NO                                    
                FROM CSS_ACCOUNT                                        
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
A04860           MOVE SPACES         TO WS-77-COMMENTS-TEXT             
                 DISPLAY ' '                                            
                 DISPLAY 'ACCOUNT NO: ' E-FCA322-ACCOUNT-NO             
                         ' DOES NOT EXIST IN CSS_ACCOUNT '              
                 STRING 'ACCT NO : ' E-FCA322-ACCOUNT-NO                
                        ' DOES NOT EXIST IN CSS_ACCOUNT '               
A04860           DELIMITED BY SIZE INTO WS-77-COMMENTS-TEXT             
                 PERFORM 5000-CREATE-WORK-QUEUE THRU 5000-EXIT          
                 SET NOT-VALID-ACCOUNT        TO TRUE                   
              ELSE                                                      
                 DISPLAY '**************************************'       
                 DISPLAY '**   PCSCA322 PROCESSING ERROR      **'       
                 DISPLAY '**   ERROR RETRIEVE CSS_ACCOUNT     **'       
                 DISPLAY '**   PROCESSING TERMINATED IN 7400- **'       
                 DISPLAY '**   RETURN CODE = ' SQLCODE                  
                 DISPLAY '**   ACCOUNT-NO   : ' AT-ACCOUNT-NO           
                 DISPLAY '**************************************'       
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              END-IF                                                    
           END-IF                                                       
           .                                                            
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *************************************************************             
      **      7500-VALIDATE-DATE                                 **             
      **           CHECK IF VALID DATE                           **             
      *************************************************************             
                                                                        
       7500-VALIDATE-DATE.                                              
                                                                        
           MOVE '7500' TO WS-ACTIVE-PARAGRAPH.                          
                                                                        
           EXEC SQL                                                     
T35434        SELECT
              IIF(TRY_CONVERT(DATE, :WS-EFF-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-EFF-DATE
              ) <> 0) OR (LEN(:WS-EFF-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-EFF-DATE
              ), CONVERT(DATE, :WS-EFF-DATE) )
            INTO
              :WS-VALID-DATE                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-VALID-DATE  = DATE(:WS-EFF-DATE)                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE E-FCA322-ACCOUNT-NO        TO WS-ACCOUNT-NO          
              MOVE WS-ACCOUNT-NO              TO AT-ACCOUNT-NO          
              PERFORM 7400-GET-PREMISE-CUST THRU 7400-EXIT              
A04860        MOVE SPACES            TO WS-77-COMMENTS-TEXT             
              DISPLAY ' '                                               
              DISPLAY 'ACCOUNT NO: ' E-FCA322-ACCOUNT-NO                
                      ' HAS INVALID DATE  '                             
              STRING 'ACCT NO : ' E-FCA322-ACCOUNT-NO                   
                     ' HAS INVALID DATE ' WS-EFF-DATE                   
A04860        DELIMITED BY SIZE INTO WS-77-COMMENTS-TEXT                
              PERFORM 5000-CREATE-WORK-QUEUE THRU 5000-EXIT             
              SET NOT-VALID-ACCOUNT           TO TRUE                   
           END-IF                                                       
           .                                                            
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *************************************************************             
      **      7700-GET-MAX-WQ-LIMIT                              **             
      **           GET MAX WQ LIMIT FROM CSS_DELINQUENCY         **             
      *************************************************************             
                                                                        
       7700-GET-MAX-WQ-LIMIT.                                           
                                                                        
           MOVE '7700' TO WS-ACTIVE-PARAGRAPH.                          
                                                                        
           EXEC SQL                                                     
              SELECT  DELINQ_VALUE                                      
                INTO  :C8-DELINQ-VALUE                                  
                FROM  CSS_DELINQUENCY                                   
               WHERE  DELINQ_CD  = :C8-DELINQ-CD                        
                 AND  COMPANY_NO = :C8-COMPANY-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE  = SUCCESSFUL-CALL                                
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '** 7600-GET-MAX-WQ-LIMIT'                       
               DISPLAY '** ERROR ON SELECT FROM CSS_DELINQUENCY **'     
               DISPLAY '** DELINQ_CD = ' C8-DELINQ-CD ' ; SQLCODE = '   
                       SQLCODE                                          
               DISPLAY '** DCOMPANY_NO= ' C8-COMPANY-NO ' ; SQLCODE = ' 
                       SQLCODE                                          
               DISPLAY '**  PROCESSING TERMINATED  **'                  
               PERFORM 9900-ABEND      THRU  9900-EXIT                  
           END-IF                                                       
           .                                                            
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
T33149******************************************************************        
T33149* 7800-CHECK-SERVICE-ACTIVE                                      *        
T33149******************************************************************        
T33149 7800-CHECK-SERVICE-ACTIVE.                                       
T33149                                                                  
T33149     MOVE 'N'                          TO WS-UTL-SERVICE-ACTIVE   
T33149                                                                  
T33149     EXEC SQL                                                     
T33149        SELECT 'Y'                                                
T33149          INTO :WS-UTL-SERVICE-ACTIVE                             
T33149          FROM CSS_UTIL_ENVRNMT UT                                
T33149         WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                 
T33149           AND UT.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE             
T33149           AND UT.IC_NO          = :UT-IC-NO                      
T33149     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T33149                                                                  
T33149     IF SQLCODE  = SUCCESSFUL-CALL OR NOT-FOUND                   
T33149         CONTINUE                                                 
T33149     ELSE                                                         
T33149         MOVE '7800'                   TO WS-ACTIVE-PARAGRAPH     
T33149         DISPLAY '** 7800-CHECK-SERVICE-ACTIVE             **'    
T33149         DISPLAY '** ERROR ON SELECT FROM CSS_UTIL_ENVRNMT **'    
T33149         DISPLAY '** ACCOUNT_NO     ' UT-ACCOUNT-NO               
T33149         DISPLAY '** IC_NO          ' UT-IC-NO                    
T33149         DISPLAY '** CODE_UTIL_TYPE ' UT-CODE-UTIL-TYPE           
T33149         DISPLAY '** SQLCODE        ' SQLCODE                     
T33149         DISPLAY '** PROCESSING TERMINATED                 **'    
T33149         PERFORM 9900-ABEND      THRU  9900-EXIT                  
T33149     END-IF.                                                      
T33149                                                                  
T33149 7800-EXIT.                                                       
T33149     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8200-UPDATE-FACTOR                                             *        
      ******************************************************************        
       8200-UPDATE-FACTOR.                                              
                                                                        
            EXEC SQL                                                    
               UPDATE CSS_FIXED_FCTR                                    
               SET EFF_DATE_FROM     = IIF(TRY_CONVERT(DATE, 
                                                      :FF-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FF-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FF-EFF-DATE-FROM
              ), CONVERT(DATE, :FF-EFF-DATE-FROM) )                
               ,CMPNT_ID_CD      = :FF-CMPNT-ID-CD                      
               ,CODE_SEASON      = :FF-CODE-SEASON                      
               ,INSTR_USE_TYPE_CD= :FF-INSTR-USE-TYPE-CD                
               ,CODE_TIME_PERIOD = :FF-CODE-TIME-PERIOD                 
               ,EFF_DATE_TO      = IIF(TRY_CONVERT(DATE, :FF-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FF-EFF-DATE-TO
              ), CONVERT(DATE, :FF-EFF-DATE-TO) )                      
               ,FIXED_FCTR_TYP_CD= :FF-FIXED-FCTR-TYP-CD                
               ,FACTOR           = :FF-FACTOR                           
               ,FAC_CHRG_BASE_AM = :FF-FAC-CHRG-BASE-AM                 
               ,LAST_UPDATE_TS   = CIS.CHAR2TIMESTAMP(:FF-LAST-UPDATE-TS
              )                   
               WHERE ACCOUNT_NO     = :FF-ACCOUNT-NO                    
                 AND CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE                
                 AND IC_NO          = :FF-IC-NO                         
                 AND FACTOR_ID      = :FF-FACTOR-ID                     
T27237           AND EFF_DATE_FROM <= IIF(TRY_CONVERT(DATE, 
                                                        :FF-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FF-EFF-DATE-TO
              ), CONVERT(DATE, :FF-EFF-DATE-TO) )                   
T27237           AND EFF_DATE_TO   >= IIF(TRY_CONVERT(DATE, 
                                                      :FF-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FF-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FF-EFF-DATE-FROM
              ), CONVERT(DATE, :FF-EFF-DATE-FROM) )                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*        UPDATE CSS_FIXED_FCTR                                            
MFA-TR*        SET EFF_DATE_FROM     = :FF-EFF-DATE-FROM                        
MFA-TR*        ,CMPNT_ID_CD      = :FF-CMPNT-ID-CD                              
MFA-TR*        ,CODE_SEASON      = :FF-CODE-SEASON                              
MFA-TR*        ,INSTR_USE_TYPE_CD= :FF-INSTR-USE-TYPE-CD                        
MFA-TR*        ,CODE_TIME_PERIOD = :FF-CODE-TIME-PERIOD                         
MFA-TR*        ,EFF_DATE_TO      = :FF-EFF-DATE-TO                              
MFA-TR*        ,FIXED_FCTR_TYP_CD= :FF-FIXED-FCTR-TYP-CD                        
MFA-TR*        ,FACTOR           = :FF-FACTOR                                   
MFA-TR*        ,FAC_CHRG_BASE_AM = :FF-FAC-CHRG-BASE-AM                         
MFA-TR*        ,LAST_UPDATE_TS   = :FF-LAST-UPDATE-TS                           
MFA-TR*        WHERE ACCOUNT_NO     = :FF-ACCOUNT-NO                            
MFA-TR*          AND CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE                        
MFA-TR*          AND IC_NO          = :FF-IC-NO                                 
MFA-TR*          AND FACTOR_ID      = :FF-FACTOR-ID                             
MFA-TR*          AND EFF_DATE_FROM <= :FF-EFF-DATE-TO                           
MFA-TR*          AND EFF_DATE_TO   >= :FF-EFF-DATE-FROM                         
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            EVALUATE WS-ACTIVE-RETURN-CODE                              
               WHEN SUCCESSFUL-CALL                                     
                  ADD +1                      TO WS-NO-RECS-INSERTED    
               WHEN OTHER                                               
                  DISPLAY '**************************************'      
                  DISPLAY '**   PCSCA322 PROCESSING ERROR      **'      
                  DISPLAY '**   ERROR UPDATING CSS_FIXED_FACTR **'      
                  DISPLAY '**   PROCESSING TERMINATED IN 8200- **'      
                  DISPLAY '**   RETURN CODE = ' SQLCODE                 
                  DISPLAY '**   ACCOUNT-NO   : ' WS-ACCOUNT-NO          
                  DISPLAY '**************************************'      
                  PERFORM 9900-ABEND             THRU 9900-EXIT         
            END-EVALUATE                                                
            .                                                           
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
      ******************************************************************        
      * 8100-INSERT-FACTOR                                             *        
      ******************************************************************        
       8100-INSERT-FACTOR.                                              
                                                                        
            EXEC SQL                                                    
               INSERT INTO CSS_FIXED_FCTR                               
                     ( ACCOUNT_NO                                       
                     , CODE_UTIL_TYPE                                   
                     , IC_NO                                            
                     , FIXED_FCTR_SEQ_NO                                
                     , FACTOR_ID                                        
                     , EFF_DATE_FROM                                    
                     , CMPNT_ID_CD                                      
                     , CODE_SEASON                                      
                     , INSTR_USE_TYPE_CD                                
                     , CODE_TIME_PERIOD                                 
                     , EFF_DATE_TO                                      
                     , FIXED_FCTR_TYP_CD                                
                     , FACTOR                                           
                     , FAC_CHRG_BASE_AM                                 
                     , LAST_UPDATE_TS)                                  
               VALUES (:FF-ACCOUNT-NO                                   
                      ,:FF-CODE-UTIL-TYPE                               
                      ,:FF-IC-NO                                        
                      ,:FF-FIXED-FCTR-SEQ-NO                            
                      ,:FF-FACTOR-ID                                    
                      ,IIF(TRY_CONVERT(DATE, :FF-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FF-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FF-EFF-DATE-FROM
              ), CONVERT(DATE, :FF-EFF-DATE-FROM) )                            
                      ,:FF-CMPNT-ID-CD                                  
                      ,:FF-CODE-SEASON                                  
                      ,:FF-INSTR-USE-TYPE-CD                            
                      ,:FF-CODE-TIME-PERIOD                             
                      ,IIF(TRY_CONVERT(DATE, :FF-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FF-EFF-DATE-TO
              ), CONVERT(DATE, :FF-EFF-DATE-TO) )                              
                      ,:FF-FIXED-FCTR-TYP-CD                            
                      ,:FF-FACTOR                                       
                      ,:FF-FAC-CHRG-BASE-AM                             
                      ,CIS.CHAR2TIMESTAMP(:FF-LAST-UPDATE-TS))                  
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*        INSERT INTO CSS_FIXED_FCTR                                       
MFA-TR*              ( ACCOUNT_NO                                               
MFA-TR*              , CODE_UTIL_TYPE                                           
MFA-TR*              , IC_NO                                                    
MFA-TR*              , FIXED_FCTR_SEQ_NO                                        
MFA-TR*              , FACTOR_ID                                                
MFA-TR*              , EFF_DATE_FROM                                            
MFA-TR*              , CMPNT_ID_CD                                              
MFA-TR*              , CODE_SEASON                                              
MFA-TR*              , INSTR_USE_TYPE_CD                                        
MFA-TR*              , CODE_TIME_PERIOD                                         
MFA-TR*              , EFF_DATE_TO                                              
MFA-TR*              , FIXED_FCTR_TYP_CD                                        
MFA-TR*              , FACTOR                                                   
MFA-TR*              , FAC_CHRG_BASE_AM                                         
MFA-TR*              , LAST_UPDATE_TS)                                          
MFA-TR*        VALUES (:FF-ACCOUNT-NO                                           
MFA-TR*               ,:FF-CODE-UTIL-TYPE                                       
MFA-TR*               ,:FF-IC-NO                                                
MFA-TR*               ,:FF-FIXED-FCTR-SEQ-NO                                    
MFA-TR*               ,:FF-FACTOR-ID                                            
MFA-TR*               ,:FF-EFF-DATE-FROM                                        
MFA-TR*               ,:FF-CMPNT-ID-CD                                          
MFA-TR*               ,:FF-CODE-SEASON                                          
MFA-TR*               ,:FF-INSTR-USE-TYPE-CD                                    
MFA-TR*               ,:FF-CODE-TIME-PERIOD                                     
MFA-TR*               ,:FF-EFF-DATE-TO                                          
MFA-TR*               ,:FF-FIXED-FCTR-TYP-CD                                    
MFA-TR*               ,:FF-FACTOR                                               
MFA-TR*               ,:FF-FAC-CHRG-BASE-AM                                     
MFA-TR*               ,:FF-LAST-UPDATE-TS)                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            EVALUATE WS-ACTIVE-RETURN-CODE                              
               WHEN SUCCESSFUL-CALL                                     
                  ADD +1                      TO WS-NO-RECS-INSERTED    
               WHEN OTHER                                               
                  DISPLAY '**************************************'      
                  DISPLAY '**   PCSCA322 PROCESSING ERROR      **'      
                  DISPLAY '**   ERROR INSERTING CSS_FIXED_FACTR **'     
                  DISPLAY '**   PROCESSING TERMINATED IN 8100- **'      
                  DISPLAY '**   RETURN CODE = ' SQLCODE                 
                  DISPLAY '**   ACCOUNT-NO   : ' WS-ACCOUNT-NO          
                  DISPLAY '**************************************'      
                  PERFORM 9900-ABEND             THRU 9900-EXIT         
            END-EVALUATE                                                
            .                                                           
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **                                                              **        
      **  8000-PRINT-RPT-REPORT.                                      **        
      **       WRITES THE HEADER OR OUTPUT RECORDS TO THE REPORT FILE **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8000-PRINT-RPT-REPORT.                                           
                                                                        
           MOVE '8000' TO WS-ACTIVE-PARAGRAPH.                          
                                                                        
           IF WS-LINE-COUNT > WS-MAX-LINES                              
              PERFORM 8500-PRINT-RPT-HEADERS THRU 8500-EXIT             
           END-IF.                                                      
                                                                        
           PERFORM 8300-PRINT-RPT-DETAILS THRU 8300-EXIT.               
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8100-PRINT-RPT-NO-DATA.                                     **        
      **       WRITE THE MESSAGE "REPORT DOES NOT EXISTS"             **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8600-PRINT-RPT-NO-DATA.                                          
                                                                        
           MOVE '8100'                    TO   WS-ACTIVE-PARAGRAPH.     
           PERFORM 8500-PRINT-RPT-HEADERS THRU 8500-EXIT.               
                                                                        
           MOVE    WS-BLANK-LINE          TO   PRT33-DATA.              
           PERFORM 8900-WRITE-REPORT      THRU 8900-EXIT.               
                                                                        
           MOVE WS-NO-DATA-LINE           TO   PRT33-DATA.              
           PERFORM 8900-WRITE-REPORT      THRU 8900-EXIT.               
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8300-PRINT-RPT-DETAILS                                      **        
      **       WRITES THE OUTPUT RECORDS TO THE REPORT FILE           **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8300-PRINT-RPT-DETAILS.                                          
                                                                        
           MOVE '8300'                   TO   WS-ACTIVE-PARAGRAPH.      
                                                                        
           MOVE WS-DETAIL-LINE           TO   PRT33-DATA.               
           PERFORM 8900-WRITE-REPORT     THRU 8900-EXIT.                
SRIDHA     ADD  WS-ONE                   TO   WS-LINE-COUNT.            
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8400-PRINT-RPT-FOOTER.                                      **        
      **       WRITES THE FOOTER  TO THE REPORT FILE                  **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8400-PRINT-RPT-FOOTER.                                           
                                                                        
           MOVE '8400'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           MOVE WS-BLANK-LINE            TO PRT33-DATA                  
           PERFORM 8900-WRITE-REPORT     THRU 8900-EXIT                 
                                                                        
           MOVE WS-FOOTER1               TO PRT33-DATA                  
           PERFORM 8900-WRITE-REPORT     THRU 8900-EXIT.                
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8500-PRINT-RPT-HEADERS.                                     **        
      **       WRITES THE HEADER  TO THE REPORT FILE                  **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8500-PRINT-RPT-HEADERS.                                          
                                                                        
           MOVE '8500'                   TO   WS-ACTIVE-PARAGRAPH.      
                                                                        
           ADD 1                         TO   WS-PAGE-COUNT.            
           MOVE WS-PAGE-COUNT            TO   WS-REP-PAGE.              
                                                                        
           MOVE WS-RPT-TITLE-1           TO   PRT33-DATA.               
           PERFORM 8900-WRITE-REPORT     THRU 8900-EXIT.                
           ADD WS-ONE                    TO WS-LINE-COUNT.              
                                                                        
           MOVE    WS-RPT-TITLE-2        TO   PRT33-DATA.               
           PERFORM 8900-WRITE-REPORT     THRU 8900-EXIT.                
           ADD     WS-ONE                TO   WS-LINE-COUNT.            
                                                                        
           MOVE    WS-RPT-TITLE-3        TO   PRT33-DATA.               
           PERFORM 8900-WRITE-REPORT     THRU 8900-EXIT.                
           ADD     WS-ONE                TO   WS-LINE-COUNT.            
                                                                        
           MOVE    WS-RPT-TITLE-4        TO   PRT33-DATA.               
           PERFORM 8900-WRITE-REPORT     THRU 8900-EXIT.                
           ADD     WS-ONE                TO   WS-LINE-COUNT.            
                                                                        
           MOVE    WS-BLANK-LINE         TO   PRT33-DATA.               
           PERFORM 8900-WRITE-REPORT     THRU 8900-EXIT.                
           ADD     WS-ONE                TO   WS-LINE-COUNT.            
                                                                        
           MOVE WS-RPT-HEADER1           TO PRT33-DATA                  
           PERFORM 8900-WRITE-REPORT     THRU 8900-EXIT                 
           ADD     WS-ONE                TO   WS-LINE-COUNT.            
                                                                        
           MOVE    WS-BLANK-LINE         TO   PRT33-DATA.               
           PERFORM 8900-WRITE-REPORT     THRU 8900-EXIT.                
           ADD     WS-ONE                TO   WS-LINE-COUNT.            
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  8900-WRITE-REPORT                                           **        
      **       WRITES THE RECORD IN THE SAME PAGE OR TO THE NEXT PAGE **        
      **                                                              **        
      ******************************************************************        
                                                                        
       8900-WRITE-REPORT.                                               
                                                                        
           MOVE '8900'  TO WS-ACTIVE-PARAGRAPH.                         
                                                                        
           IF WS-LINE-COUNT > WS-MAX-LINES                              
              WRITE PRT33-RECORD AFTER ADVANCING PAGE                   
              MOVE  WS-ZERO TO WS-LINE-COUNT                            
           ELSE                                                         
              WRITE PRT33-RECORD                                        
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8893-RESET-RESTART-REQ-PARM                                   *         
      * 8894-COUNT-RESTART-DATA                                       *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CPD00029                                                 
           END-EXEC.                                                            
      *                                                                         
       8896-ISSUE-CHKP.                                                 
           MOVE '8896'                      TO ACTIVE-PARAGRAPH.        
           IF WS-CHKP-LUW-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS       
              AND WS-CHKP-UPD-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS   
              GO TO 8896-EXIT                                           
           END-IF.                                                      
           ADD WS-ONE                       TO WS-CHKP-SEQ-NO.          
           MOVE WS-CHKP-SEQ-NO              TO WS-RESTART-CHKP-SEQ-NO.  
                                                                        
           MOVE WS-ACCOUNT-NO               TO WS-RESTART-ACCOUNT-NO    
           MOVE WS-INPUT-RECS-READ          TO WS-RESTART-RECS-READ.    
           MOVE WS-NO-RECS-INSERTED         TO                          
                                            WS-RESTART-NO-RECS-INSERTED 
           MOVE WS-INPUT-RECS-ERROR         TO                          
                                            WS-RESTART-INPUT-RECS-ERROR 
           PERFORM 8897-WRITE-RSDDR         THRU 8897-EXIT.             
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
                                                                        
           DISPLAY 'COMMIT POINT # ' WS-CHKP-SEQ-NO ' TAKEN.'           
                   'LAST CHECK ENTRY PROCESSED = '                      
                    WS-RESTART-RECS-READ       '/'                      
           MOVE ZERO                        TO WS-CHKP-LUW-COUNTER      
                                               WS-CHKP-UPD-COUNTER.     
       8896-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8897-WRITE-RSDDR.                                                
           MOVE WS-ONE                      TO RF-PARTITION-NO.         
           MOVE PROGRAM-NAME                TO RF-NAME-PROGRAM.         
           MOVE WS-ONE                      TO RF-DUP-CNTRL-NO.         
           MOVE WS-RESTART-DATA             TO RF-RESTART-DATA-TEXT.    
      *    MOVE WS-RESTART-DATA-LENGTH      TO RF-RESTART-DATA-LEN.             
           MOVE LENGTH OF WS-RESTART-DATA   TO RF-RESTART-DATA-LEN.     
           PERFORM 8898-UPDATE-RESTART      THRU 8898-EXIT.             
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 8899-INSERT-RESTART   THRU 8899-EXIT              
           END-IF.                                                      
       8897-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8898-UPDATE-RESTART.                                             
           MOVE '8898'                      TO ACTIVE-PARAGRAPH.        
           EXEC SQL                                                     
               UPDATE CSS_RESTART                                       
                  SET RESTART_DATA = :RF-RESTART-DATA                   
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM AND               
                      PARTITION_NO = :RF-PARTITION-NO AND               
                      DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               ADD WS-ONE                   TO WS-CHKP-UPD-COUNTER      
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '8898-UPDATE RETURN CODE =' WS-ACTIVE-RETURN-CODE
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF
           END-IF                                                       
           .                                                            
       8898-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8899-INSERT-RESTART.                                             
           MOVE '8899'                      TO ACTIVE-PARAGRAPH.        
           EXEC SQL                                                     
               INSERT INTO CSS_RESTART                                  
                   (NAME_PROGRAM, PARTITION_NO, DUP_CNTRL_NO,           
                    RESTART_DATA)                                       
               VALUES                                                   
                   (:RF-NAME-PROGRAM, :RF-PARTITION-NO,                 
                    :RF-DUP-CNTRL-NO, :RF-RESTART-DATA)                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               ADD WS-ONE                   TO WS-CHKP-UPD-COUNTER      
           ELSE                                                         
               DISPLAY '8899-INSERT RETURN CODE =' WS-ACTIVE-RETURN-CODE
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF                                                       
           .                                                            
       8899-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **                                                              **        
      **  9000-TERMINATE.                                             **        
      **       TERMINATION ROUTINE                                    **        
      **                                                              **        
      ******************************************************************        
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           MOVE    WS-BLANK-LINE                  TO   PRT33-DATA.      
           PERFORM 8900-WRITE-REPORT              THRU 8900-EXIT.       
                                                                        
           MOVE ' NO OF ACCOUNTS INSERTED'        TO P-TEXT             
           MOVE WS-NO-RECS-INSERTED               TO P-COUNT            
           MOVE WS-TOTALS-LINE                    TO PRT33-DATA         
           PERFORM 8900-WRITE-REPORT              THRU 8900-EXIT        
                                                                        
           MOVE ' NO OF ACCOUNTS IN ERROR'        TO P-TEXT             
           MOVE WS-INPUT-RECS-ERROR               TO P-COUNT            
           MOVE WS-TOTALS-LINE                    TO PRT33-DATA         
           PERFORM 8900-WRITE-REPORT              THRU 8900-EXIT        
                                                                        
           PERFORM 8400-PRINT-RPT-FOOTER          THRU 8400-EXIT        
           CLOSE FCSPT33-FILE.                                          
           CLOSE FCSCA322-FILE.                                         
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *                                                          *              
      *  7600-START-FCSJC01                                      *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
                                                                        
      ************************************************************              
      *                                                          *              
      *  7450-SELECT-RESTART-DATA                                *              
      *                                                          *              
      ************************************************************              
       7450-SELECT-RESTART-DATA.                                        
                                                                        
           MOVE '7450'                  TO ACTIVE-PARAGRAPH.            
                                                                        
           EXEC SQL                                                     
               SELECT RESTART_DATA                                      
                 INTO :RF-RESTART-DATA                                  
                 FROM CSS_RESTART                                       
                WHERE NAME_PROGRAM  = :RF-NAME-PROGRAM                  
                  AND PARTITION_NO  = :RF-PARTITION-NO                  
                  AND DUP_CNTRL_NO  = :RF-DUP-CNTRL-NO                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '7450-SELECT RETURN CODE =' WS-ACTIVE-RETURN-CODE 
              PERFORM 9900-ABEND       THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
