       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  PCSCA316.                                           
       DATE-WRITTEN.  05/20/2010.                                       
       DATE-COMPILED.                                                   
       AUTHOR.         MADHAVI CH.                                      
      ***************************************************************** 00060000
      **              SOUTH CAROLINA ELECTRIC & GAS                  ** 00070000
      **                                                             ** 00080000
      **                  CUSTOMER SERVICE SYSTEM                    ** 00090000
      **                         DB2                                 ** 00100000
      ***************************************************************** 00110000
      **                                                             ** 00120000
      **              PROGRAM  MODIFICATION  LOG                     ** 00130000
      **                                                             ** 00140000
      ** DATE       INITIALS    REASON                               ** 00150000
      **                                                             ** 00160000
      ** 05/20/2010 MC95456     DEVELOPMENT OF NEW PROGRAM FOR SEB   ** 00170000
      **            A2459-01                                            00180000
A02459** 07/14/2010 SP94986     VALIDATION FOR INPUT DATE BILLED     ** 00190000
A02459** 20/08/2010 MS93554     ACCOUNT NO VALIDATION FOR SPACES.    ** 00200000
      **            ACT-05                                           ** 00210000
ACT116** 05/18/2011 BG17805     ADD CALL TO TABLE CSS_DIST_XREF_MTR     00220000
ACT116**            APPL3082    TO GET AGL METER NUMBER                 00230000
ACT116**                        THEN MOVE TO NEW FIELD IN OUTPUT FILE   00240000
ACT116**                        INCREASE LENGTH OF COPYBOOK CFDC3161    00250000
ACT116**                        TO BE ABLE TO HANDLE NEW FIELD          00260000
A03303** 05/30/2011 SV95326     FIXED FACTOR PRECISION CHANGES FROM  ** 00270000
A03303**            ACT011      4 TO 6 DECIMAL POINTS FOR INDUSTRIAL ** 00280000
A03303**                        BILLING .                            ** 00290000
      ***************************************************************** 00430000
      *                   PCSCA316   NARRATIVE                        * 00440000
      *                                                               * 00450000
      * THIS PROGRAM CREATES FILE TO SENT TO WAKE COUNTY SCHOOLS,     * 00460000
      * NC DEPARTMENT OF ADMINISTRATION, GASTONIA HOUSING AUTHORITY,  * 00470000
      * AND SEB MEDIA ONE.                                            * 00480000
      *                                                               * 00490000
      * INPUTFILE MASTERS HAS MASTER ACCOUNT NOS AND DATE BILLED FOR  * 00500000
      * WHICH ELECTRONIC FILES ARE NEEDED.IF NEED ARISES TO ADD       * 00501000
      * ONE MORE MASTER ACCOUNT,EDIT MASTERS TO ADD ACCOUNT NO.       * 00510000
      *                                                               * 00520000
      * OUTPUT FILE CONTAINS THE DATA FOR ALL THE MASTERS. EACH MASTER* 00540000
      * ACCOUNT IS SEPARATED AND SENT TO THE USER.                    * 00550000
      *                                                               * 00560000
      ***************************************************************** 00570000
      *                                                               * 00580000
      *             ---- BASIC SEQUENCE STRUCTURE ----                * 00590000
      *         0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  * 00600000
      *         1000 - 1999     INPUT PROCESSING CONTROL PATH         * 00610000
      *         2000 - 2999     OUTPUT PROCESSING CONTROL PATH        * 00620000
      *         7000 - 7999     DATABASE ACCESS / INPUT MODULES       * 00630000
      *         8000 - 8999     PHYSICAL OUTPUT ROUTINES              * 00640000
      *         9000 - 9799     TERMINATION MODULES                   * 00650000
      ***************************************************************** 00660000
HPCCDM*EJECT                                                            00670000
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSCA316.                                                   00710000
       COPY CSSC3161.                                                   00720000
       COPY CSSPT80.                                                    00731000
      *                                                                 00740000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDCA316.                                                   00841000
       COPY CFDC3161.                                                   00842000
       COPY CFDPT80.                                                    00844000
      *                                                                 00920000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA316'.
MSQ017     COPY MFASQLM.
      *                                                                 00990000
       01  WS-RECORD.                                                   
           05  WS-ACCT-NO                    PIC X(14) JUSTIFIED RIGHT. 
HEX01      05  WS-FILLER                     PIC X(01) VALUE X'09'.     
           05  WS-CUST-NAME                  PIC X(70).                 
HEX01      05  WS-FILLER                     PIC X(01) VALUE X'09'.     
           05  WS-SERVICE-CITY               PIC X(30).                 
HEX01      05  WS-FILLER                     PIC X(01) VALUE X'09'.     
           05  WS-SERVICE-ZIP                PIC X(10).                 
HEX01      05  WS-FILLER                     PIC X(01) VALUE X'09'.     
           05  WS-SERVICE-ADDRESS            PIC X(55).                 
HEX01      05  WS-FILLER                     PIC X(01) VALUE X'09'.     
           05  WS-CUST-ID-NO                 PIC X(35).                 
HEX01      05  WS-FILLER                     PIC X(01) VALUE X'09'.     
           05  WS-RATE-PLAN-NO               PIC X(04).                 
HEX01      05  WS-FILLER                     PIC X(01) VALUE X'09'.     
           05  WS-DAYS                       PIC 9(04).                 
HEX01      05  WS-FILLER                     PIC X(01) VALUE X'09'.     
           05  WS-READ-DATE                  PIC 9(09).                 
HEX01      05  WS-FILLER                     PIC X(01) VALUE X'09'.     
           05  WS-BILL-DATE                  PIC 9(09).                 
HEX01      05  WS-FILLER                     PIC X(01) VALUE X'09'.     
           05  WS-METER-NO                   PIC X(09).                 
HEX01      05  WS-FILLER                     PIC X(01) VALUE X'09'.     
           05  WS-CCF-UNITS                  PIC 9(09).                 
HEX01      05  WS-FILLER                     PIC X(01) VALUE X'09'.     
           05  WS-THERMS                     PIC 9(09).                 
HEX01      05  WS-FILLER                     PIC X(01) VALUE X'09'.     
A03303     05  WS-CUST-SER-CHG               PIC -9(09).9(6).           
HEX01      05  WS-FILLER                     PIC X(01) VALUE X'09'.     
A03303     05  WS-AGL-CHGS                   PIC -9(09).9(6).           
HEX01      05  WS-FILLER                     PIC X(01) VALUE X'09'.     
           05  WS-OTHER-CHGS                 PIC -9(09).99.             
HEX01      05  WS-FILLER                     PIC X(01) VALUE X'09'.     
           05  WS-TAXES                      PIC -9(8).99.              
HEX01      05  WS-FILLER                     PIC X(01) VALUE X'09'.     
           05  WS-CHARGES                    PIC -9(09).99.             
HEX01      05  WS-FILLER                     PIC X(01) VALUE X'09'.     
           05  WS-TOTAL-BILL-AMT             PIC -9(09).99.             
HEX01      05  WS-FILLER                     PIC X(01) VALUE X'09'.     
           05  WS-MAST-ACCT                  PIC X(13).                 
HEX01      05  WS-FILLER                     PIC X(01) VALUE X'09'.     
           05  WS-AGL-ACCT-NO                PIC X(20).                 
HEX01      05  WS-FILLER                     PIC X(01) VALUE X'09'.     
ACT116     05  WS-AGL-METER-NO               PIC X(09).                 
      *                                                                 01750000
       01  WS-DETAIL-RECORD.                                            
           05 FCSC-ACCOUNT-NO                PIC X(13).                 
           05 FILLER                         PIC X(04) VALUE SPACES.    
           05 FCSC-DATE-BILLED               PIC X(10).                 
           05 FILLER                         PIC X(06) VALUE SPACES.    
           05 FCSC-ACCT-REASON               PIC X(38).                 
           05 FILLER                         PIC X(09) VALUE SPACES.    
      *                                                                 01758000
       01  WS-HEADER.                                                   
           05  WS-ACCT-NO-HEADER             PIC X(14)  VALUE           
               'ACCOUNT #     '.                                        
HEX01      05  WS-FILLER                     PIC X(01)  VALUE X'09'.    
           05  WS-CUST-NAME-HEADER           PIC X(70)  VALUE           
               'NAME' JUSTIFIED RIGHT.                                  
HEX01      05  WS-FILLER                     PIC X(01)  VALUE X'09'.    
           05  WS-SERVICE-CITY-HEADER        PIC X(30)  VALUE           
               'SERVICE CITY' JUSTIFIED RIGHT.                          
HEX01      05  WS-FILLER                     PIC X(01)  VALUE X'09'.    
           05  WS-SERVICE-ZIP-HEADER         PIC X(10)  VALUE           
               'ZIP       '.                                            
HEX01      05  WS-FILLER                     PIC X(01)  VALUE X'09'.    
           05  WS-SERVICE-ADDRESS-HEADER     PIC X(55)  VALUE           
               'SERVICE ADDRESS' JUSTIFIED RIGHT.                       
HEX01      05  WS-FILLER                     PIC X(01)  VALUE X'09'.    
           05  WS-CUST-ID-NO-HEADER          PIC X(35)  VALUE           
               'CUST ID #' JUSTIFIED RIGHT.                             
HEX01      05  WS-FILLER                     PIC X(01)  VALUE X'09'.    
           05  WS-RATE-PLAN-NO-HEADER        PIC X(04)  VALUE           
               'RATE'.                                                  
HEX01      05  WS-FILLER                     PIC X(01)  VALUE X'09'.    
           05  WS-DAYS-HEADER                PIC X(04)  VALUE           
               'DAYS'.                                                  
HEX01      05  WS-FILLER                     PIC X(01)  VALUE X'09'.    
           05  WS-READ-DATE-HEADER           PIC X(09)  VALUE           
               'READ DATE'.                                             
HEX01      05  WS-FILLER                     PIC X(01)  VALUE X'09'.    
           05  WS-BILL-DATE-HEADER           PIC X(09)  VALUE           
               'BILL DATE'.                                             
HEX01      05  WS-FILLER                     PIC X(01)  VALUE X'09'.    
           05  WS-METER-NO-HEADER            PIC X(09)  VALUE           
               'METER #  '.                                             
HEX01      05  WS-FILLER                     PIC X(01)  VALUE X'09'.    
           05  WS-CCF-UNITS-HEADER           PIC X(09)  VALUE           
               'CCF      '.                                             
HEX01      05  WS-FILLER                     PIC X(01)  VALUE X'09'.    
           05  WS-THERMS-HEADER              PIC X(09)  VALUE           
               'THERMS   '.                                             
HEX01      05  WS-FILLER                     PIC X(01)  VALUE X'09'.    
A03303     05  WS-CUST-SER-CHG-HEADER        PIC X(17)  VALUE           
A03303         ' CUST SER CHG    '.                                     
HEX01      05  WS-FILLER                     PIC X(01)  VALUE X'09'.    
A03303     05  WS-AGL-CHGS-HEADER            PIC X(17)  VALUE           
A03303         ' AGL CHGS        '.                                     
HEX01      05  WS-FILLER                     PIC X(01)  VALUE X'09'.    
           05  WS-OTHER-CHGS-HEADER          PIC X(13)  VALUE           
               ' OTHER CHGS  '.                                         
HEX01      05  WS-FILLER                     PIC X(01)  VALUE X'09'.    
           05  WS-TAXES-HEADER               PIC X(12)  VALUE           
               ' TAXES      '.                                          
HEX01      05  WS-FILLER                     PIC X(01)  VALUE X'09'.    
           05  WS-CHARGES-HEADER             PIC X(10)  VALUE           
               ' CHARGES  '.                                            
HEX01      05  WS-FILLER                     PIC X(01)  VALUE X'09'.    
           05  WS-TOTAL-BILL-AMT-HEADER      PIC X(13)  VALUE           
               '    TOTALS   '.                                         
HEX01      05  WS-FILLER                     PIC X(01)  VALUE X'09'.    
           05  WS-MAST-ACCT-HEADER           PIC X(13)  VALUE           
               '   MASTERACCT'.                                         
HEX01      05  WS-FILLER                     PIC X(01)  VALUE X'09'.    
           05  WS-AGL-ACCT-NO-HEADER         PIC X(20)  VALUE           
               '   AGL ACCT #       '.                                  
HEX01      05  WS-FILLER                     PIC X(01)  VALUE X'09'.    
ACT116     05  WS-AGL-METER-NO-HEADER        PIC X(12)  VALUE           
ACT116         '   AGL METER'.                                          
      *                                                                 02390000
       01  WS-FCSPT80-HEADER.                                           
           05  WS-ACCT-NO-HEAD1              PIC X(13)  VALUE           
               'ACCOUNT #    '.                                         
           05  WS-FILLER                     PIC X(04)  VALUE SPACES.   
           05  WS-DATE-BILLED-HEAD1          PIC X(11)  VALUE           
               'BILLED DATE'.                                           
           05  WS-FILLER                     PIC X(06)  VALUE SPACES.   
           05  WS-REASON-HEAD1               PIC X(38)  VALUE           
               'REASON                               '.                 
           05  WS-FILLER                     PIC X(08)  VALUE SPACES.   
      *                                                                 02443100
       01  WS-SWITCHES.                                                 
           05  WS-MASTERS-STATUS             PIC X(02).                 
               88 MASTERS-SUCCESSFUL                    VALUE '00'.     
               88 END-OF-REC                            VALUE '10'.     
           05  WS-FCSCA316-STATUS            PIC X(02).                 
               88 FCSCA316-SUCCESSFUL                   VALUE '00'.     
           05  WS-FPT80-STATUS               PIC X(02).                 
               88 FPT80-SUCCESSFUL                      VALUE '00'.     
           05  WS-NO-MORE-MST-ROWS           PIC  X(01).                
               88 NO-MORE-MST-ROWS                      VALUE 'Y'.      
           05  WS-NO-MORE-BILL-ROWS          PIC  X(01).                
               88 NO-MORE-BILL-ROWS                     VALUE 'Y'.      
           05  WS-FIRST-ACCT-NOTFOU-SW       PIC  X(01) VALUE 'Y'.      
               88 FIRST-ACCT-NF-REP                     VALUE 'Y'.      
A02459     05  WS-IN-DATE-VALID              PIC  X(01) VALUE SPACES.   
A02459         88 INPUT-DATE-VALID                      VALUE 'Y'.      
A02459     05  WS-MST-ACCT-FOUND             PIC  X(01) VALUE SPACES.   
A02459         88 MST-ACCT-FOUND                        VALUE 'Y'.      
      *                                                                 02995000
       01  WS-ACCOUNT-NUMBER.                                           
           05 FILLER                         PIC 9(01) VALUE ZEROES.    
           05 WS-ACCOUNT-NO                  PIC X(13).                 
       01  WS-TAXES-AMOUNT                   PIC 9(09)V9(2).            
       01  WS-DATE-BILLED                    PIC X(10).                 
       01  WS-MAS-ACCT-REASON                PIC X(38) VALUE            
            'ACCT NOT PRESENT IN CSS_BILLING_HDR   '.                   
A02459 01  WS-DATE-INVALID-REA               PIC X(38) VALUE            
A02459      'DATE BILLED IS INVALID                '.                   
A03303 01  WS-FACTOR-FH                      PIC S9(09)V9(06)           
A03303                                       USAGE COMP-3 VALUE 0.      
      *                                                                 03160000
       01  WS-STATEMENT-DATE-TEMP.                                      
           05  WS-STATEMENT-CCYY             PIC X(04).                 
           05  FILLER                        PIC X(01).                 
           05  WS-STATEMENT-MM               PIC X(02).                 
           05  FILLER                        PIC X(01).                 
           05  WS-STATEMENT-DD               PIC X(02).                 
      *                                                                 03250000
       01  WS-FMT-DATE.                                                 
           05  WS-FMT-MM                     PIC X(02).                 
           05  WS-FMT-DD                     PIC X(02).                 
           05  WS-FMT-CCYY                   PIC X(04).                 
      *                                                                 03380000
A02459 01  WS-VALID-DATE                     PIC X(10).                 
      *                                                                 03385000
       01  WS-LITERALS.                                                 
           05 WS-PGRMNAME                    PIC X(08) VALUE            
              'PCSCA316'.                                               
           05 WS-N                           PIC X(01) VALUE 'N'.       
           05 WS-Y                           PIC X(01) VALUE 'Y'.       
           05 WS-811                         PIC S9(9) VALUE -811 COMP. 
A02459     05 WS-FACTOR-NULL                 PIC S9(4) COMP VALUE ZERO. 
      *                                                                 03480200
       01  WS-ADDRESS-ID-NULL                PIC S9(04) COMP VALUE 0.   
           88  ADDRESS-ID-NULL                         VALUE -1.        
      *                                                                 03480500
       01  WS-VARIABLES.                                                
           05 PROGRAM-NAME                   PIC X(8)  VALUE 'PCSCA316'.
           05 RS-RETURN-CODE                 PIC S9(9) VALUE +000 COMP. 
           05 RS-RETURN-CODE-DISP            PIC S9(9) VALUE +000 COMP. 
      *                                                                 03485000
      ***************************************************************** 03486000
      **      APPLICATION  TABLE DCLGENS                             ** 03487000
      ***************************************************************** 03488000
           EXEC SQL                                                     03489000
               INCLUDE SQLCA                                            03490000
           END-EXEC.                                                    03500000
      *                                                                 03510000
      ***************************************************************** 03590000
      *  CSS_ACCOUNT - AT                                               03600000
      ***************************************************************** 03610000
           EXEC SQL                                                     03620000
               INCLUDE TBACCT                                           03630000
           END-EXEC.                                                    03640000
      *                                                                 03650000
      ***************************************************************** 03730000
      *  CSS_MKT_XREF_ACCT - XM                                         03740000
      ***************************************************************** 03750000
           EXEC SQL                                                     03760000
               INCLUDE TBMRKXR                                          03770000
           END-EXEC.                                                    03780000
      *                                                                 03790000
      ***************************************************************** 03800000
      *  CSS_NAME - DQ                                                  03810000
      ***************************************************************** 03820000
           EXEC SQL                                                     03830000
               INCLUDE TBNAME                                           03840000
           END-EXEC.                                                    03850000
      *                                                                 03860000
      ***************************************************************** 03870000
      * CSS_NAME_ACCT_XREF - HT                                         03880000
      ***************************************************************** 03890000
           EXEC SQL                                                     03900000
               INCLUDE TBNMACTX                                         03910000
           END-EXEC.                                                    03920000
      *                                                                 03920100
      ****************************************************************  03920200
      * CSS_CUST_ADDR_XREF - DM                                      *  03920300
      ****************************************************************  03920400
           EXEC SQL                                                     03920500
               INCLUDE TBCSADRX                                         03920600
           END-EXEC.                                                    03920700
      ****************************************************************  03920800
      * CSS_ADDR_FREEFORM - DZ                         *                03920900
      ***************************************************************   03921000
           EXEC SQL                                                     03921100
               INCLUDE TBADRFRE                                         03921200
           END-EXEC.                                                    03921300
      ****************************************************************  03921400
      * CSS_ADDR_FORMATTED - DY                                       * 03921500
      ****************************************************************  03921600
           EXEC SQL                                                     03921700
               INCLUDE TBADRFMT                                         03921800
           END-EXEC.                                                    03921900
      ****************************************************************  03922000
      * CSS_ZIP_CODE - A4                                            *  03922100
      ****************************************************************  03922200
           EXEC SQL                                                     03922300
               INCLUDE TBZIPCD                                          03922400
           END-EXEC.                                                    03922500
      ****************************************************************  03922600
      * CSS_ACCT_MISC_INFO - TA                                      *  03922700
      ****************************************************************  03922800
           EXEC SQL                                                     03922900
               INCLUDE TBATMISC                                         03923000
           END-EXEC.                                                    03924000
      ***************************************************************** 03925000
      * CSS_BILLING_HDR - BI                                          * 03926000
      ***************************************************************** 03927000
           EXEC SQL                                                     03928000
               INCLUDE TBBLLHDR                                         03929000
           END-EXEC.                                                    03930000
      *                                                                 03940000
      ***************************************************************** 03950000
      * CSS_BILLING_DET - BG                                          * 03960000
      ***************************************************************** 03970000
           EXEC SQL                                                     03980000
               INCLUDE TBBLLDET                                         03990000
           END-EXEC.                                                    04000000
      *                                                                 04010000
      ***************************************************************** 04020000
      * CSS_BILL_CALC_DET - BZ                                        * 04030000
      ***************************************************************** 04040000
           EXEC SQL                                                     04050000
               INCLUDE TBBLCLDT                                         04060000
           END-EXEC.                                                    04070000
      *                                                                 04080000
      ******************************************************************04160000
      * CSS_CNSMPTN_HIST - CX                                          *04170000
      ******************************************************************04180000
           EXEC SQL                                                     04190000
               INCLUDE TBCNSMP                                          04200000
           END-EXEC.                                                    04210000
      *                                                                 04220000
      ******************************************************************04300000
      * CSS_FIXED_FCT_HIST - FH                                        *04310000
      ******************************************************************04320000
           EXEC SQL                                                     04330000
               INCLUDE TBFXHST                                          04340000
           END-EXEC.                                                    04350000
      *                                                                 04360000
      ******************************************************************04361000
      * CSS_BILL_ACCT_XFER - AF                                        *04362000
      ******************************************************************04363000
           EXEC SQL                                                     04364000
               INCLUDE TBBLACXF                                         04365000
           END-EXEC.                                                    04366000
      *                                                                 04367000
      ***************************************************************** 04410000
ACT116*                                                                 04411000
ACT116******************************************************************04412000
ACT116* CSS_DIST_XREF_MTR - TM                                         *04413000
ACT116******************************************************************04414000
ACT116     EXEC SQL                                                     04415000
ACT116         INCLUDE TBMRKXMT                                         04416000
ACT116     END-EXEC.                                                    04417000
ACT116*                                                                 04418000
ACT116***************************************************************** 04419000
       COPY CWS00303.                                                   04420000
      *ABEND SWITCH COPYBOOK                                            04450000
       COPY CWS09900.                                                   04460000
      *WS ABEND WORK AREA                                               04480000
       COPY CWS00010.                                                   04490000
      *                                                                 04500000
      *COPYBOOK USED BY CPD00074                                        04560200
       COPY CWS00074.                                                   04560300
      *                                                                 04560400
      *COPYBOOK FOR 6010-REDUCE-EMBEDDED-SPACES                         04560500
       COPY CWS00011.                                                   04560600
      *                                                                 04560700
      ***************************************************************** 04561300
      ** CURSOR DECLARATION TO SELECT DATE BILLED , BILL UNITS AND   ** 04561400
      ** BILL AMOUNT FROM CSS_BILLING_HDR AND CSS_BILL_CALC_DET.     ** 04561500
      ***************************************************************** 04562000
      *                                                                 04563000
           EXEC SQL                                                     
           DECLARE BILL-CURSOR  CURSOR FOR                              
            SELECT BI.DATE_BILLED,                                      
                   BI.TOT_OTHER_CHARGES,                                
                   BZ.READ_UNITS,                                       
                   BZ.BILL_UNITS,                                       
                   BZ.WNA_COMP_AM,                                      
                   BZ.BILLED_COMP_AM,                                   
                   BZ.CALC_COMP_AM,                                     
                   BG.ACCOUNT_NO,                                       
                   BG.AMT_BILL_ITEM,                                    
                   BG.RATE_PLAN_NO,                                     
                   BG.NO_OF_CONS_DAYS,                                  
                   BG.WNA_FACTOR,                                       
                   BG.AMT_STATE_TAX,                                    
                   BG.AMT_CITY_TAX,                                     
                   BG.AMT_OTHER_TAX,                                    
                   BG.CODE_UTIL_TYPE,                                   
                   BG.IC_NO,                                            
                   BG.BILL_NO,                                          
                   REPLACE(REPLACE(CONVERT(CHAR(26), 
           BG.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP,                               
                   BG.CODE_DR_CR_CNSMPTN                                
              FROM CSS_BILLING_HDR    BI WITH(READUNCOMMITTED)                  
                  ,CSS_BILLING_DET    BG WITH(READUNCOMMITTED)                  
                  ,CSS_BILL_CALC_DET  BZ WITH(READUNCOMMITTED)                  
                  ,CSS_BILLING_HDR    BIM WITH(READUNCOMMITTED)                 
                  ,CSS_BILL_ACCT_XFER AF WITH(READUNCOMMITTED)                  
             WHERE BI.ACCOUNT_NO         =  BG.ACCOUNT_NO               
               AND BI.BILL_NO            =  BG.BILL_NO                  
               AND BG.ACCOUNT_NO         =  BZ.ACCOUNT_NO               
               AND BG.CODE_UTIL_TYPE     =  BZ.CODE_UTIL_TYPE           
               AND BG.BILL_NO            =  BZ.BILL_NO                  
               AND BG.IC_NO              =  BZ.IC_NO                    
               AND BG.BILL_ITEM_TIMESTMP =  BZ.BILL_ITEM_TIMESTMP       
               AND BG.ACCOUNT_NO         =  AF.ACCT_XFER_FROM           
               AND BG.BILL_NO            =  AF.BILL_NO_XFER_FROM        
               AND BG.BILL_ITEM_TIMESTMP =  AF.BILL_ITEM_TIMESTMP       
               AND BG.CODE_UTIL_TYPE     =  AF.CODE_UTIL_TYPE           
               AND BG.IC_NO              =  AF.IC_NO                    
               AND BG.CODE_BILL_CALC     IN ('A','S')                   
               AND BG.CODE_BILL_ITM_TYPE =  'C'                         
               AND BG.CODE_BILL_ITM_IND  =  'A'                         
               AND BIM.ACCOUNT_NO        = :AF-ACCOUNT-NO               
               AND BIM.DATE_BILLED       = IIF(TRY_CONVERT(DATE, 
                                                        :WS-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-BILLED
              ) <> 0) OR (LEN(:WS-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :WS-DATE-BILLED
              ), CONVERT(DATE, :WS-DATE-BILLED) )              
               AND BIM.ACCOUNT_NO        =  AF.ACCOUNT_NO               
               AND BIM.BILL_NO           =  AF.BILL_NO                  
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     04991000
MFA-TR*    DECLARE BILL-CURSOR  CURSOR FOR                              04992000
MFA-TR*     SELECT BI.DATE_BILLED,                                      05000000
MFA-TR*            BI.TOT_OTHER_CHARGES,                                05010000
MFA-TR*            BZ.READ_UNITS,                                       05020000
MFA-TR*            BZ.BILL_UNITS,                                       05030000
MFA-TR*            BZ.WNA_COMP_AM,                                      05040000
MFA-TR*            BZ.BILLED_COMP_AM,                                   05041000
MFA-TR*            BZ.CALC_COMP_AM,                                     05042000
MFA-TR*            BG.ACCOUNT_NO,                                       05043000
MFA-TR*            BG.AMT_BILL_ITEM,                                    05044000
MFA-TR*            BG.RATE_PLAN_NO,                                     05045000
MFA-TR*            BG.NO_OF_CONS_DAYS,                                  05046000
MFA-TR*            BG.WNA_FACTOR,                                       05047000
MFA-TR*            BG.AMT_STATE_TAX,                                    05048000
MFA-TR*            BG.AMT_CITY_TAX,                                     05049000
MFA-TR*            BG.AMT_OTHER_TAX,                                    05049100
MFA-TR*            BG.CODE_UTIL_TYPE,                                   05049200
MFA-TR*            BG.IC_NO,                                            05049300
MFA-TR*            BG.BILL_NO,                                          05049400
MFA-TR*            BG.BILL_ITEM_TIMESTMP,                               05049500
MFA-TR*            BG.CODE_DR_CR_CNSMPTN                                05049600
MFA-TR*       FROM CSS_BILLING_HDR    BI                                05049800
MFA-TR*           ,CSS_BILLING_DET    BG                                05049900
MFA-TR*           ,CSS_BILL_CALC_DET  BZ                                05050000
MFA-TR*           ,CSS_BILLING_HDR    BIM                               05050100
MFA-TR*           ,CSS_BILL_ACCT_XFER AF                                05050200
MFA-TR*      WHERE BI.ACCOUNT_NO         =  BG.ACCOUNT_NO               05050400
MFA-TR*        AND BI.BILL_NO            =  BG.BILL_NO                  05050500
MFA-TR*        AND BG.ACCOUNT_NO         =  BZ.ACCOUNT_NO               05050700
MFA-TR*        AND BG.CODE_UTIL_TYPE     =  BZ.CODE_UTIL_TYPE           05050800
MFA-TR*        AND BG.BILL_NO            =  BZ.BILL_NO                  05050900
MFA-TR*        AND BG.IC_NO              =  BZ.IC_NO                    05051000
MFA-TR*        AND BG.BILL_ITEM_TIMESTMP =  BZ.BILL_ITEM_TIMESTMP       05051100
MFA-TR*        AND BG.ACCOUNT_NO         =  AF.ACCT_XFER_FROM           05051300
MFA-TR*        AND BG.BILL_NO            =  AF.BILL_NO_XFER_FROM        05051400
MFA-TR*        AND BG.BILL_ITEM_TIMESTMP =  AF.BILL_ITEM_TIMESTMP       05051500
MFA-TR*        AND BG.CODE_UTIL_TYPE     =  AF.CODE_UTIL_TYPE           05051600
MFA-TR*        AND BG.IC_NO              =  AF.IC_NO                    05051700
MFA-TR*        AND BG.CODE_BILL_CALC     IN ('A','S')                   05051900
MFA-TR*        AND BG.CODE_BILL_ITM_TYPE =  'C'                         05052000
MFA-TR*        AND BG.CODE_BILL_ITM_IND  =  'A'                         05052100
MFA-TR*        AND BIM.ACCOUNT_NO        = :AF-ACCOUNT-NO               05052300
MFA-TR*        AND BIM.DATE_BILLED       = :WS-DATE-BILLED              05052400
MFA-TR*        AND BIM.ACCOUNT_NO        =  AF.ACCOUNT_NO               05052500
MFA-TR*        AND BIM.BILL_NO           =  AF.BILL_NO                  05052600
MFA-TR*        FOR FETCH ONLY WITH UR                                   05052700
MFA-TR*        QUERYNO 7040                                             05052800
MFA-TR*    END-EXEC.                                                    05052900
      ******************************************************************05053000
       PROCEDURE DIVISION.                                              
      *                                                                 05070000
       0000-MAINLINE.                                                   
      *                                                                 05090000
      *                                                                 05092000
           PERFORM 0100-INITIALIZATION          THRU 0100-EXIT.         
           PERFORM 1000-PROCESS-INPUT           THRU 1000-EXIT          
              UNTIL END-OF-REC.                                         
           PERFORM 9000-TERMINATE               THRU 9000-EXIT.         
           STOP RUN.                                                    
      *                                                                 05170000
       0000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************05200000
      *   OPENS THE OUTPUT FILE PCSCA316,GETS MASTER ACCOUNT NO  AND   *05210000
      *   DATE BILLED.                                                 *05220000
      ******************************************************************05230000
       0100-INITIALIZATION.                                             
      *                                                                 05260000
           OPEN INPUT  MASTERS.                                         
           IF MASTERS-SUCCESSFUL                                        
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY 'ERROR IN OPENING MASTERS FILE'                   
              DISPLAY 'ERROR STATUS ' WS-MASTERS-STATUS                 
              PERFORM 9000-TERMINATE            THRU 9000-EXIT          
           END-IF.                                                      
      *                                                                 05570000
           OPEN OUTPUT FCSCA316-FILE.                                   
           IF FCSCA316-SUCCESSFUL                                       
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY 'ERROR IN OPENING FCSCA316 FILE'                  
              DISPLAY 'ERROR STATUS ' WS-FCSCA316-STATUS                
              PERFORM 9000-TERMINATE            THRU 9000-EXIT          
           END-IF.                                                      
      *                                                                 05660000
           OPEN OUTPUT FCSPT80-FILE.                                    
           IF FPT80-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY 'ERROR IN OPENING FCSPT80 FILE'                   
              DISPLAY 'ERROR STATUS ' WS-FPT80-STATUS                   
              PERFORM 9000-TERMINATE            THRU 9000-EXIT          
           END-IF.                                                      
      *                                                                 05669000
           PERFORM 8600-WRITE-HEADER            THRU 8600-EXIT          
           PERFORM 7100-READ-MASTERS            THRU 7100-EXIT          
      *                                                                 05890000
           IF END-OF-REC                                                
              DISPLAY 'NO DATA IN INPUT FILE'                           
              DISPLAY 'ERROR STATUS ' WS-MASTERS-STATUS                 
              PERFORM 9000-TERMINATE            THRU 9000-EXIT          
           END-IF.                                                      
      *                                                                 05970000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06000000
      ******************************************************************06310000
      * PROCESS ACCOUNTS                                              **06320000
      ******************************************************************06330000
       1000-PROCESS-INPUT.                                              
      *                                                                 06351000
A02459     IF IN-ACCT-NO > SPACES AND IN-DATE-BILLED > SPACES           
              MOVE IN-ACCOUNT-NO            TO AF-ACCOUNT-NO            
              MOVE IN-DATE-BILLED           TO WS-DATE-BILLED           
A02459        INITIALIZE   WS-IN-DATE-VALID                             
A02459        PERFORM 7070-VALID-INPUT-DATE     THRU 7070-EXIT          
A02459        IF INPUT-DATE-VALID                                       
A02459           PERFORM 1100-PROCESS-BILL      THRU 1100-EXIT          
A02459        ELSE                                                      
A02459           INITIALIZE PRT80-RECORD                                
A02459           MOVE IN-ACCT-NO            TO FCSC-ACCOUNT-NO          
A02459           MOVE IN-DATE-BILLED        TO FCSC-DATE-BILLED         
A02459           MOVE WS-DATE-INVALID-REA   TO FCSC-ACCT-REASON         
A02459           PERFORM 8700-WRITE-FCSPT80     THRU 8700-EXIT          
A02459        END-IF                                                    
           END-IF.                                                      
           PERFORM 7100-READ-MASTERS            THRU 7100-EXIT.         
      *                                                                 06401000
       1000-EXIT.                                                       
            EXIT.                                                       
      *                                                                 06430000
      ******************************************************************06440000
      * PROCESS FOR EACH ACCOUNT                                      **06450000
      ******************************************************************06601600
       1100-PROCESS-BILL.                                               
      *                                                                 06601800
           MOVE 'N'                         TO WS-NO-MORE-BILL-ROWS.    
A02459     MOVE SPACES                      TO WS-MST-ACCT-FOUND.       
           PERFORM 7030-OPEN-BILL-CURSOR        THRU 7030-EXIT.         
           PERFORM 7040-FETCH-BILL-CURSOR       THRU 7040-EXIT.         
           PERFORM UNTIL NO-MORE-BILL-ROWS                              
               PERFORM 2500-LOAD-OUTPUT         THRU 2500-EXIT          
               PERFORM 7040-FETCH-BILL-CURSOR   THRU 7040-EXIT          
           END-PERFORM.                                                 
                                                                        
A02459     IF MST-ACCT-FOUND                                            
A02459        CONTINUE                                                  
A02459     ELSE                                                         
              INITIALIZE PRT80-RECORD                                   
              MOVE IN-ACCT-NO               TO FCSC-ACCOUNT-NO          
              MOVE IN-DATE-BILLED           TO FCSC-DATE-BILLED         
              MOVE WS-MAS-ACCT-REASON       TO FCSC-ACCT-REASON         
              PERFORM 8700-WRITE-FCSPT80        THRU 8700-EXIT          
           EXIT
           END-IF.                                                        
      *                                                                 06642000
           PERFORM 7050-CLOSE-BILL-CURSOR       THRU 7050-EXIT.         
      *                                                                 06642200
       1100-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************07960000
      * POPULATES THE OUTPUT VARIABLES AND WRITES ON TO PCSCA316   *    07970000
      * FILE.                                                          *07980000
      ******************************************************************07990000
       2500-LOAD-OUTPUT.                                                
      *                                                                 08020000
           INITIALIZE WS-ACCT-NO                                        
                      WS-CUST-NAME                                      
                      WS-SERVICE-CITY                                   
                      WS-SERVICE-ZIP                                    
                      WS-SERVICE-ADDRESS                                
                      WS-CUST-ID-NO                                     
                      WS-RATE-PLAN-NO                                   
                      WS-DAYS                                           
                      WS-READ-DATE                                      
                      WS-BILL-DATE                                      
                      WS-METER-NO                                       
                      WS-CCF-UNITS                                      
                      WS-THERMS                                         
                      WS-CUST-SER-CHG                                   
                      WS-AGL-CHGS                                       
                      WS-OTHER-CHGS                                     
                      WS-TAXES                                          
                      WS-CHARGES                                        
                      WS-TOTAL-BILL-AMT                                 
                      WS-MAST-ACCT                                      
                      WS-AGL-ACCT-NO                                    
      *                                                                 08023200
           MOVE BG-ACCOUNT-NO               TO WS-ACCOUNT-NO            
                                               HT-ACCOUNT-NO            
                                               CX-ACCOUNT-NO            
                                               AT-ACCOUNT-NO            
                                               FH-ACCOUNT-NO            
                                               TA-ACCOUNT-NO            
                                               XM-ACCOUNT-NO.           
      *                                                                 08091000
           MOVE WS-ACCOUNT-NUMBER           TO WS-ACCT-NO.              
           MOVE IN-ACCT-NO                  TO WS-MAST-ACCT.            
      *                                                                 08130000
           PERFORM 7000-GET-NAME                THRU 7000-EXIT.         
           MOVE DQ-FULL-NAME                TO WS-CUST-NAME.            
      *                                                                 08160000
           PERFORM 7010-GET-ADDRESS-ID          THRU 7010-EXIT          
           IF ADDRESS-ID-NULL                                           
              MOVE ZEROES                   TO AT-ADDRESS-ID            
           END-IF .                                                     
      *                                                                 08201000
           PERFORM 4000-MAIL-NAME-ADDRESS       THRU 4000-EXIT.         
           MOVE WS-CITY                     TO WS-SERVICE-CITY.         
           MOVE WS-ZIP                      TO WS-SERVICE-ZIP.          
           MOVE WS-PR-STREET                TO WS-SERVICE-ADDRESS.      
      *                                                                 08250000
           PERFORM 7200-GET-AGL-ACCT-NUMBER     THRU 7200-EXIT.         
           MOVE XM-DIST-ACCT-NO             TO WS-AGL-ACCT-NO.          
      *                                                                 08280000
           PERFORM 7300-GET-CUST-ID-NUMBER      THRU 7300-EXIT.         
           MOVE TA-SPCL-BILL-STMNT-TX       TO WS-CUST-ID-NO.           
           MOVE BG-CODE-UTIL-TYPE           TO FH-CODE-UTIL-TYPE.       
           MOVE BG-IC-NO                    TO FH-IC-NO.                
           MOVE BG-BILL-NO                  TO FH-BILL-NO.              
           MOVE BG-BILL-ITEM-TIMESTMP       TO FH-BILL-ITEM-TIMESTMP.   
      *                                                                 08351000
           PERFORM 7400-GET-AGL-CHARGES         THRU 7400-EXIT.         
A03303     MOVE WS-FACTOR-FH                TO WS-AGL-CHGS.             
      *                                                                 08380000
           COMPUTE WS-CUST-SER-CHG     =                                
A03303     BZ-BILLED-COMP-AM - WS-FACTOR-FH - BZ-CALC-COMP-AM.          
      *                                                                 08410000
           MOVE BG-RATE-PLAN-NO             TO WS-RATE-PLAN-NO.         
           MOVE BG-NO-OF-CONS-DAYS          TO WS-DAYS.                 
           MOVE BZ-READ-UNITS               TO WS-CCF-UNITS.            
           MOVE BI-TOT-OTHER-CHARGES        TO WS-OTHER-CHGS.           
           MOVE BZ-CALC-COMP-AM             TO WS-CHARGES.              
      *                                                                 08470000
           MOVE BI-DATE-BILLED              TO WS-STATEMENT-DATE-TEMP.  
           MOVE WS-STATEMENT-CCYY           TO WS-FMT-CCYY.             
           MOVE WS-STATEMENT-MM             TO WS-FMT-MM.               
           MOVE WS-STATEMENT-DD             TO WS-FMT-DD.               
           MOVE WS-FMT-DATE                 TO WS-BILL-DATE.            
      *                                                                 08530000
           MOVE BG-CODE-UTIL-TYPE           TO CX-CODE-UTIL-TYPE.       
           MOVE BG-IC-NO                    TO CX-IC-NO.                
           MOVE BG-BILL-NO                  TO CX-BILL-NO.              
           MOVE BG-BILL-ITEM-TIMESTMP       TO CX-BILL-ITEM-TIMESTMP.   
           PERFORM 7020-GET-MTR-DETAILS         THRU 7020-EXIT.         
           MOVE CX-DATE-READ                TO WS-STATEMENT-DATE-TEMP.  
           MOVE WS-STATEMENT-CCYY           TO WS-FMT-CCYY.             
           MOVE WS-STATEMENT-MM             TO WS-FMT-MM.               
           MOVE WS-STATEMENT-DD             TO WS-FMT-DD.               
           MOVE WS-FMT-DATE                 TO WS-READ-DATE.            
           IF WS-ACTIVE-RETURN-CODE = WS-811                            
              MOVE SPACES                   TO WS-METER-NO              
           ELSE                                                         
              MOVE CX-METER-NO              TO WS-METER-NO              
           END-IF.                                                      
      *                                                                 08690000
ACT116     IF WS-METER-NO = SPACES                                      
ACT116        MOVE SPACES TO WS-AGL-METER-NO                            
ACT116     ELSE                                                         
ACT116        PERFORM 7500-GET-AGL-METER        THRU 7500-EXIT          
ACT116      END-IF.                                                     
ACT116*                                                                 08696000
           MOVE BZ-BILL-UNITS               TO WS-THERMS.               
      *                                                                 08710000
           COMPUTE WS-TAXES-AMOUNT ROUNDED =                            
                   BG-AMT-STATE-TAX +  BG-AMT-CITY-TAX                  
                                    +  BG-AMT-OTHER-TAX.                
           MOVE WS-TAXES-AMOUNT             TO WS-TAXES.                
      *                                                                 08820000
           IF BG-CODE-DR-CR-CNSMPTN = 'C'                               
              COMPUTE BG-AMT-BILL-ITEM = BG-AMT-BILL-ITEM * -1          
           END-IF.                                                      
      *                                                                 08826000
           MOVE BG-AMT-BILL-ITEM            TO WS-TOTAL-BILL-AMT.       
      *                                                                 08900000
           PERFORM 8500-WRITE-FCSCA316          THRU 8500-EXIT.         
A02459     MOVE 'Y'                         TO WS-MST-ACCT-FOUND.       
      *                                                                 08990000
       2500-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  09200000
      * THIS INCLUDES 4000-MAIL-NAME-ADDRESS                         *  09210000
      ****************************************************************  09220000
      *                                                                 09230000
           EXEC SQL                                                     09240000
                INCLUDE CPD00074                                        09250000
           END-EXEC.                                                    09260000
      ****************************************************************  09270000
      * THIS INCLUDES 6010-REDUCE-EMBEDDED-SPACES                    *  09280000
      ****************************************************************  09290000
      *                                                                 09300000
           EXEC SQL                                                     09310000
                INCLUDE CPD00004                                        09320000
           END-EXEC.                                                    09330000
      *                                                                 09340000
      ******************************************************************09370000
      * GET NAME FOR THE ACCOUNT                                      * 09380000
      ******************************************************************09390000
       7000-GET-NAME.                                                   
      *                                                                 09393000
           EXEC SQL                                                     
               SELECT DQ.FULL_NAME                                      
                 INTO :DQ-FULL-NAME                                     
                 FROM CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
                      CSS_NAME           DQ WITH(READUNCOMMITTED)               
                WHERE HT.ACCOUNT_NO = :HT-ACCOUNT-NO                    
                  AND HT.NAME_ID    = DQ.NAME_ID                        
                  AND DQ.NAME_TYPE  = 'CN'                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     09394000
MFA-TR*        SELECT DQ.FULL_NAME                                      09395000
MFA-TR*          INTO :DQ-FULL-NAME                                     09396000
MFA-TR*          FROM CSS_NAME_ACCT_XREF HT,                            09397000
MFA-TR*               CSS_NAME           DQ                             09398000
MFA-TR*         WHERE HT.ACCOUNT_NO = :HT-ACCOUNT-NO                    09399000
MFA-TR*           AND HT.NAME_ID    = DQ.NAME_ID                        09400000
MFA-TR*           AND DQ.NAME_TYPE  = 'CN'                              09410000
MFA-TR*        WITH UR                                                  09411000
MFA-TR*        QUERYNO 7000                                             09412000
MFA-TR*    END-EXEC.                                                    09420000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 09430000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 09450000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA316    ABORT ************'       
              DISPLAY '* 7000-GET-NAME                      *'          
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* ACCOUNT NO   = ' HT-ACCOUNT-NO                 
              DISPLAY '* PROGRAM ABORTING...                *'          
              DISPLAY '********** PCSCA316    ABORT ************'       
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 09560000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09590000
      ******************************************************************09600000
      * GET ADDRESS-ID,ACCOUNT-NO FROM ACCOUNT TABLE                   *09610000
      ******************************************************************09620000
       7010-GET-ADDRESS-ID.                                             
      *                                                                 09640000
           EXEC SQL                                                     
               SELECT ACCOUNT_NO,                                       
                      ADDRESS_ID                                        
                 INTO :AT-ACCOUNT-NO ,                                  
                      :AT-ADDRESS-ID :WS-ADDRESS-ID-NULL                 
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     09650000
MFA-TR*        SELECT ACCOUNT_NO,                                       09660000
MFA-TR*               ADDRESS_ID                                        09670000
MFA-TR*          INTO :AT-ACCOUNT-NO ,                                  09680000
MFA-TR*               :AT-ADDRESS-ID:WS-ADDRESS-ID-NULL                 09690000
MFA-TR*          FROM CSS_ACCOUNT                                       09700000
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       09710000
MFA-TR*        WITH UR                                                  09711000
MFA-TR*        QUERYNO 7010                                             09712000
MFA-TR*    END-EXEC.                                                    09720000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 09730000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 09750000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA316    ABORT ************'       
              DISPLAY '* 7010-GET-ADDRESS-ID                *'          
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* ACCOUNT NO   = ' AT-ACCOUNT-NO                 
              DISPLAY '* PROGRAM ABORTING...                *'          
              DISPLAY '********** PCSCA316    ABORT ************'       
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 09860000
       7010-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************09910000
      * GET METER LAST-READ-VALUE AND METER-NO                        * 09920000
      ******************************************************************09930000
       7020-GET-MTR-DETAILS.                                            
      *                                                                 09941000
           EXEC SQL                                                     
               SELECT DATE_READ,                                        
                      METER_NO                                          
               INTO   :CX-DATE-READ,                                    
                      :CX-METER-NO                                      
                 FROM CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO          = :CX-ACCOUNT-NO              
                  AND CODE_UTIL_TYPE      = :CX-CODE-UTIL-TYPE          
                  AND BILL_NO             = :CX-BILL-NO                 
                  AND BILL_ITEM_TIMESTMP  = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )      
                  AND IC_NO               = :CX-IC-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     09950000
MFA-TR*        SELECT DATE_READ,                                        09960000
MFA-TR*               METER_NO                                          09970000
MFA-TR*        INTO   :CX-DATE-READ,                                    09980000
MFA-TR*               :CX-METER-NO                                      09990000
MFA-TR*          FROM CSS_CNSMPTN_HIST                                  10000000
MFA-TR*         WHERE ACCOUNT_NO          = :CX-ACCOUNT-NO              10010000
MFA-TR*           AND CODE_UTIL_TYPE      = :CX-CODE-UTIL-TYPE          10020000
MFA-TR*           AND BILL_NO             = :CX-BILL-NO                 10030000
MFA-TR*           AND BILL_ITEM_TIMESTMP  = :CX-BILL-ITEM-TIMESTMP      10040000
MFA-TR*           AND IC_NO               = :CX-IC-NO                   10050000
MFA-TR*        WITH UR                                                  10051000
MFA-TR*        QUERYNO 7020                                             10052000
MFA-TR*    END-EXEC.                                                    10060000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 10070000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 10090000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
                                            OR WS-811                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA316    ABORT ************'       
              DISPLAY '* 7020-GET-MTR-DETAILS              *'           
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* ACCOUNT NO   = ' CX-ACCOUNT-NO                 
              DISPLAY '* UTIL TYPE    = ' CX-CODE-UTIL-TYPE             
              DISPLAY '* BILL NO      = ' CX-BILL-NO                    
              DISPLAY '* TIMESTAMP    = ' CX-BILL-ITEM-TIMESTMP         
              DISPLAY '* IC NO        = ' CX-IC-NO                      
              DISPLAY '* PROGRAM ABORTING...                *'          
              DISPLAY '********** PCSCA316    ABORT ************'       
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 10201000
       7020-EXIT.                                                       
            EXIT.                                                       
      *                                                                 10230000
      ******************************************************************10240000
      * OPENS BILL CURSOR                                               10250000
      ******************************************************************10260000
       7030-OPEN-BILL-CURSOR.                                           
      *                                                                 10290000
           EXEC SQL                                                     
              OPEN BILL-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO  WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE         EQUAL SUCCESSFUL-CALL       
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA316     ABORT ************'      
              DISPLAY '* 7030-OPEN-BILL-CURSOR               *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* ACCOUNT NO ', AF-ACCT-XFER-FROM                
              DISPLAY '* BILL NO    ', AF-BILL-NO                       
              DISPLAY '* UTIL TYPE  ', AF-CODE-UTIL-TYPE                
              DISPLAY '* IC NO      ', AF-IC-NO                         
              DISPLAY '* TIMESTMP   ', AF-BILL-ITEM-TIMESTMP            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA316     ABORT ************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 10460000
       7030-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************10500000
      * FETCHES DATE BILLED, BILL UNITS, BILL AMOUNT                   *10510000
      ******************************************************************10520000
       7040-FETCH-BILL-CURSOR.                                          
      *                                                                 10540000
           EXEC SQL                                                     
              FETCH   BILL-CURSOR                                       
               INTO  :BI-DATE-BILLED,                                   
                     :BI-TOT-OTHER-CHARGES,                             
                     :BZ-READ-UNITS,                                    
                     :BZ-BILL-UNITS,                                    
                     :BZ-WNA-COMP-AM,                                   
                     :BZ-BILLED-COMP-AM,                                
                     :BZ-CALC-COMP-AM,                                  
                     :BG-ACCOUNT-NO,                                    
                     :BG-AMT-BILL-ITEM,                                 
                     :BG-RATE-PLAN-NO,                                  
                     :BG-NO-OF-CONS-DAYS,                               
                     :BG-WNA-FACTOR,                                    
                     :BG-AMT-STATE-TAX,                                 
                     :BG-AMT-CITY-TAX,                                  
                     :BG-AMT-OTHER-TAX,                                 
                     :BG-CODE-UTIL-TYPE,                                
                     :BG-IC-NO,                                         
                     :BG-BILL-NO,                                       
                     :BG-BILL-ITEM-TIMESTMP,                            
                     :BG-CODE-DR-CR-CNSMPTN                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 10760000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 10780000
           IF WS-ACTIVE-RETURN-CODE         EQUAL SUCCESSFUL-CALL       
A02459        CONTINUE                                                  
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE       EQUAL NOT-FOUND             
                MOVE 'Y'                    TO WS-NO-MORE-BILL-ROWS     
             ELSE                                                       
                DISPLAY '********** PCSCA316    ABORT ************'     
                DISPLAY '* 7040-FETCH-BILL-CURSOR             *'        
                DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE          
                DISPLAY '* ACCOUNT NO ', AF-ACCT-XFER-FROM              
                DISPLAY '* BILL NO    ', AF-BILL-NO                     
                DISPLAY '* UTIL TYPE  ', AF-CODE-UTIL-TYPE              
                DISPLAY '* IC NO      ', AF-IC-NO                       
                DISPLAY '* TIMESTMP   ', AF-BILL-ITEM-TIMESTMP          
                DISPLAY '* PROGRAM ABORTING...                *'        
                DISPLAY '********** PCSCA316    ABORT ************'     
                PERFORM 9900-ABEND              THRU 9900-EXIT          
             END-IF                                                     
           END-IF.                                                      
      *                                                                 10890000
       7040-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************10930000
      * CLOSES BILL CURSOR                                             *10940000
      ******************************************************************10950000
       7050-CLOSE-BILL-CURSOR.                                          
      *                                                                 10970000
           EXEC SQL                                                     
              CLOSE BILL-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11010000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 11030000
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '********** PCSCA316    ABORT ************'       
              DISPLAY '* 7050-CLOSE-BILL-CURSOR             *'          
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* ACCOUNT NO ', AF-ACCT-XFER-FROM                
              DISPLAY '* BILL NO    ', AF-BILL-NO                       
              DISPLAY '* UTIL TYPE  ', AF-CODE-UTIL-TYPE                
              DISPLAY '* IC NO      ', AF-IC-NO                         
              DISPLAY '* TIMESTMP   ', AF-BILL-ITEM-TIMESTMP            
              DISPLAY '* PROGRAM ABORTING...                *'          
              DISPLAY '********** PCSCA316    ABORT ************'       
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 11140000
       7050-EXIT.                                                       
           EXIT.                                                        
A02459******************************************************************11460000
A02459* VALIDATE DATE BILLED DATE                                     **11470000
A02459******************************************************************11480000
A02459 7070-VALID-INPUT-DATE.                                           
A02459*                                                                 11500000
A02459     EXEC SQL                                                     
A02459         SELECT (IIF(TRY_CONVERT(DATE, :WS-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-BILLED
              ) <> 0) OR (LEN(:WS-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :WS-DATE-BILLED
              ), CONVERT(DATE, :WS-DATE-BILLED) ))                           
A02459           INTO :WS-VALID-DATE                                    
A02459           FROM CSS_MODEL_SQL WITH(READUNCOMMITTED)                       
A02459                                                           
A02459                                                      
A02459     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     11550000
MFA-TR*        SELECT (DATE(:WS-DATE-BILLED))                           11560000
MFA-TR*          INTO :WS-VALID-DATE                                    11570000
MFA-TR*          FROM CSS_MODEL_SQL                                     11580000
MFA-TR*        WITH UR                                                  11590000
MFA-TR*        QUERYNO 7070                                             11600000
MFA-TR*    END-EXEC.                                                    11610000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02459*                                                                 11620000
A02459     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A02459*                                                                 11640000
A02459     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A02459        MOVE 'Y'                      TO WS-IN-DATE-VALID         
A02459     ELSE                                                         
A02459        DISPLAY '********** PCSCA316    ABORT ************'       
A02459        DISPLAY '* 7070-VALID-INPUT-DATE                 *'       
A02459        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
A02459        DISPLAY '* ACCOUNT NO ', WS-DATE-BILLED                   
A02459        DISPLAY '********** PCSCA316    ABORT ************'       
A02459     END-IF.                                                      
A02459*                                                                 11740000
A02459 7070-EXIT.                                                       
A02459     EXIT.                                                        
      ****************************************************************  12240000
      *  READ MASTERS.                                                  12250000
      ****************************************************************  12260000
       7100-READ-MASTERS.                                               
      *                                                                 12300000
           READ MASTERS                                                 
           IF MASTERS-SUCCESSFUL OR END-OF-REC                          
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '************ PCSCA316 ***************'           
              DISPLAY '** ERROR IN READING MASTERS FILE ****'           
              DISPLAY '** FILE STATUS IS ' WS-MASTERS-STATUS            
              DISPLAY '** ABENDING PROGRAM              **'             
              DISPLAY '************ PCSCA316 ***************'           
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 12338000
       7100-EXIT.                                                       
            EXIT.                                                       
      ****************************************************************  12360000
      *  GET AGL ACCOUNT NUMBER.                                        12370000
      ****************************************************************  12380000
       7200-GET-AGL-ACCT-NUMBER.                                        
      *                                                                 12410000
           EXEC SQL                                                     
               SELECT XM.DIST_ACCT_NO                                   
                 INTO :XM-DIST-ACCT-NO                                  
                 FROM CSS_MKT_XREF_ACCT XM WITH(READUNCOMMITTED)                
                WHERE XM.ACCOUNT_NO = :XM-ACCOUNT-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     12420000
MFA-TR*        SELECT XM.DIST_ACCT_NO                                   12430000
MFA-TR*          INTO :XM-DIST-ACCT-NO                                  12440000
MFA-TR*          FROM CSS_MKT_XREF_ACCT XM                              12450000
MFA-TR*         WHERE XM.ACCOUNT_NO = :XM-ACCOUNT-NO                    12460000
MFA-TR*        WITH UR                                                  12461000
MFA-TR*        QUERYNO 7200                                             12462000
MFA-TR*    END-EXEC.                                                    12470000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12480000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 12500000
           IF WS-ACTIVE-RETURN-CODE         EQUAL SUCCESSFUL-CALL       
              CONTINUE                                                  
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE       EQUAL NOT-FOUND             
                MOVE SPACES                 TO XM-DIST-ACCT-NO          
             ELSE                                                       
                DISPLAY '********** PCSCA316    ABORT ************'     
                DISPLAY '* 7200-GET-AGL-ACCT-NUMBER              *'     
                DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE          
                DISPLAY '* ACCOUNT NO ', XM-ACCOUNT-NO                  
                DISPLAY '* PROGRAM ABORTING...                   *'     
                DISPLAY '********** PCSCA316    ABORT ************'     
                PERFORM 9900-ABEND              THRU 9900-EXIT          
             END-IF                                                     
           END-IF.                                                      
      *                                                                 12650000
       7200-EXIT.                                                       
            EXIT.                                                       
      ****************************************************************  12690000
      *  GET CUSTOMER ID NUMBER.                                        12700000
      ****************************************************************  12710000
       7300-GET-CUST-ID-NUMBER.                                         
      *                                                                 12730000
           EXEC SQL                                                     
               SELECT TA.SPCL_BILL_STMNT_TX                             
                 INTO :TA-SPCL-BILL-STMNT-TX                            
                 FROM CSS_ACCT_MISC_INFO TA WITH(READUNCOMMITTED)               
                WHERE TA.ACCOUNT_NO = :TA-ACCOUNT-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     12740000
MFA-TR*        SELECT TA.SPCL_BILL_STMNT_TX                             12750000
MFA-TR*          INTO :TA-SPCL-BILL-STMNT-TX                            12760000
MFA-TR*          FROM CSS_ACCT_MISC_INFO TA                             12770000
MFA-TR*         WHERE TA.ACCOUNT_NO = :TA-ACCOUNT-NO                    12780000
MFA-TR*        WITH UR                                                  12781000
MFA-TR*        QUERYNO 7300                                             12782000
MFA-TR*    END-EXEC.                                                    12790000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE         EQUAL SUCCESSFUL-CALL       
              CONTINUE                                                  
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE       EQUAL NOT-FOUND             
                MOVE SPACES                  TO TA-SPCL-BILL-STMNT-TX   
              ELSE                                                      
                DISPLAY '********** PCSCA316    ABORT ************'     
                DISPLAY '* 7300-GET-CUST-ID-NUMBER               *'     
                DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE          
                DISPLAY '* ACCOUNT NO ', TA-ACCOUNT-NO                  
                DISPLAY '* PROGRAM ABORTING...                   *'     
                DISPLAY '********** PCSCA316    ABORT ************'     
                PERFORM 9900-ABEND              THRU 9900-EXIT          
             END-IF                                                     
           END-IF.                                                      
      *                                                                 12970000
       7300-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************13010000
      * GET AGL CHARGES                                               * 13020000
      ******************************************************************13030000
       7400-GET-AGL-CHARGES.                                            
      *                                                                 13050000
           EXEC SQL                                                     
               SELECT                                                   
A03303            SUM(CIS.DECIMAL2DECIMAL3(FACTOR * POWER(10.0,
           FCTR_POWER_10),13,6)) 
A03303           INTO :WS-FACTOR-FH :WS-FACTOR-NULL                     
                 FROM CSS_FIXED_FCT_HIST WITH(READUNCOMMITTED)                  
                WHERE ACCOUNT_NO          = :FH-ACCOUNT-NO              
                  AND CODE_UTIL_TYPE      = :FH-CODE-UTIL-TYPE          
                  AND BILL_NO             = :FH-BILL-NO                 
                  AND BILL_ITEM_TIMESTMP  = CIS.CHAR2TIMESTAMP(
                                                 :FH-BILL-ITEM-TIMESTMP
              )      
                  AND IC_NO               = :FH-IC-NO                   
                  AND FACTOR_ID LIKE 'AGL%'                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     13060000
MFA-TR*        SELECT                                                   13070000
MFA-TR*           SUM(DECIMAL(FACTOR * POWER(10.0,FCTR_POWER_10),13,6)) 13071000
MFA-TR*          INTO :WS-FACTOR-FH :WS-FACTOR-NULL                     13072000
MFA-TR*          FROM CSS_FIXED_FCT_HIST                                13090000
MFA-TR*         WHERE ACCOUNT_NO          = :FH-ACCOUNT-NO              13100000
MFA-TR*           AND CODE_UTIL_TYPE      = :FH-CODE-UTIL-TYPE          13110000
MFA-TR*           AND BILL_NO             = :FH-BILL-NO                 13120000
MFA-TR*           AND BILL_ITEM_TIMESTMP  = :FH-BILL-ITEM-TIMESTMP      13130000
MFA-TR*           AND IC_NO               = :FH-IC-NO                   13140000
MFA-TR*           AND FACTOR_ID LIKE 'AGL%'                             13150000
MFA-TR*         WITH UR                                                 13151000
MFA-TR*         QUERYNO 7400                                            13152000
MFA-TR*    END-EXEC.                                                    13160000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13170000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 13190000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A02459        IF WS-FACTOR-NULL < 0                                     
A03303           MOVE ZEROS TO WS-FACTOR-FH                             
A02459        END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSCA316    ABORT ************'       
              DISPLAY '* 7400-GET-AGL-CHARGES              *'           
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* ACCOUNT NO ', FH-ACCOUNT-NO                    
              DISPLAY '* UTIL TYPE  ', FH-CODE-UTIL-TYPE                
              DISPLAY '* BILL NO    ', FH-BILL-NO                       
              DISPLAY '* TIMESTAMP  ', FH-BILL-ITEM-TIMESTMP            
              DISPLAY '* IC NO      ', FH-IC-NO                         
              DISPLAY '* PROGRAM ABORTING...                *'          
              DISPLAY '********** PCSCA316    ABORT ************'       
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 13300000
       7400-EXIT.                                                       
            EXIT.                                                       
ACT116******************************************************************13330000
ACT116* GET ORIGINAL AGL METER NUMBER                                 * 13340000
ACT116******************************************************************13350000
ACT116 7500-GET-AGL-METER.                                              
ACT116                                                                  
ACT116     EXEC SQL                                                     
ACT116         SELECT TM.DIST_METER_NO                                  
ACT116           INTO :TM-DIST-METER-NO                                 
ACT116           FROM CSS_DIST_XREF_MTR TM WITH(READUNCOMMITTED)                
ACT116          WHERE TM.METER_NO   = :WS-METER-NO                      
ACT116                                                           
ACT116                                                      
ACT116     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13820100
MFA-TR*        SELECT TM.DIST_METER_NO                                  13820200
MFA-TR*          INTO :TM-DIST-METER-NO                                 13820300
MFA-TR*          FROM CSS_DIST_XREF_MTR TM                              13820400
MFA-TR*         WHERE TM.METER_NO   = :WS-METER-NO                      13820500
MFA-TR*        WITH UR                                                  13820600
MFA-TR*        QUERYNO 7500                                             13820700
MFA-TR*    END-EXEC.                                                    13820800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT116                                                                  
ACT116     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
ACT116                                                                  
ACT116     IF WS-ACTIVE-RETURN-CODE         EQUAL SUCCESSFUL-CALL       
ACT116        MOVE TM-DIST-METER-NO TO WS-AGL-METER-NO                  
ACT116     ELSE                                                         
ACT116       IF WS-ACTIVE-RETURN-CODE       EQUAL NOT-FOUND             
ACT116          MOVE SPACES                  TO WS-AGL-METER-NO         
ACT116        ELSE                                                      
ACT116          DISPLAY '********** PCSCA316    ABORT ************'     
ACT116          DISPLAY '* 7500-GET-AGL-METER                    *'     
ACT116          DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE          
ACT116          DISPLAY '* METER USED IN CALL: ' WS-METER-NO            
ACT116          DISPLAY '* ACCT  USED IN CALL: ' WS-ACCT-NO             
ACT116          DISPLAY '* PROGRAM ABORTING...                   *'     
ACT116          DISPLAY '********** PCSCA316    ABORT ************'     
ACT116          PERFORM 9900-ABEND              THRU 9900-EXIT          
ACT116       END-IF                                                     
ACT116     END-IF.                                                      
ACT116                                                                  
ACT116 7500-EXIT.                                                       
ACT116      EXIT.                                                       
ACT116*                                                                 13824000
      *  WRITE TO OUTPUT FILE.                                          13830000
      ****************************************************************  13840000
       8500-WRITE-FCSCA316.                                             
      *                                                                 13870000
           WRITE FCSCA316-REC FROM WS-RECORD.                           
           IF FCSCA316-SUCCESSFUL                                       
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA316    ABORT ************'       
              DISPLAY '* 8500-WRITE-FCSCA316                   *'       
              DISPLAY 'ERROR IN WRITING FCSCA316 FILE'                  
              DISPLAY 'ERROR STATUS ' WS-FCSCA316-STATUS                
              DISPLAY 'ACCOUNT NO   ' IN-ACCOUNT-NO                     
              DISPLAY 'SUB ACCT NO  ' AF-ACCOUNT-NO                     
              DISPLAY '********** PCSCA316    ABORT ************'       
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 13950000
       8500-EXIT.                                                       
            EXIT.                                                       
      ****************************************************************  13970100
      *  WRITE TO OUTPUT FILE THE COLUMN HEADERS.                       13970200
      ****************************************************************  13970300
       8600-WRITE-HEADER.                                               
      *                                                                 13970500
           WRITE FCSCA316-REC FROM WS-HEADER.                           
           IF FCSCA316-SUCCESSFUL                                       
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA316    ABORT ************'       
              DISPLAY '* 8600-WRITE-HEADERES                   *'       
              DISPLAY 'ERROR IN WRITING FCSCA316 FILE'                  
              DISPLAY 'ERROR STATUS ' WS-FCSCA316-STATUS                
              DISPLAY 'ACCOUNT NO   ' IN-ACCOUNT-NO                     
              DISPLAY 'SUB ACCT NO  ' AF-ACCOUNT-NO                     
              DISPLAY '********** PCSCA316    ABORT ************'       
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 13971900
       8600-EXIT.                                                       
            EXIT.                                                       
      ****************************************************************  13972200
      *  WRITE TO FCSPT80  ERROR FILE                                   13972300
      ****************************************************************  13973000
       8700-WRITE-FCSPT80.                                              
      *                                                                 13976000
           IF FIRST-ACCT-NF-REP                                         
              WRITE PRT80-RECORD FROM WS-FCSPT80-HEADER                 
              MOVE  WS-N                    TO WS-FIRST-ACCT-NOTFOU-SW  
           END-IF.                                                      
                                                                        
           WRITE PRT80-RECORD FROM WS-DETAIL-RECORD.                    
           IF FPT80-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA316    ABORT ************'       
              DISPLAY '* 8700-WRITE-FCSPT80                    *'       
              DISPLAY 'ERROR IN WRITING FCSPT80 FILE'                   
              DISPLAY 'ERROR STATUS ' WS-FPT80-STATUS                   
              DISPLAY 'ACCOUNT NO   ' IN-ACCOUNT-NO                     
              DISPLAY 'SUB ACCT NO  ' AF-ACCOUNT-NO                     
              DISPLAY '********** PCSCA316    ABORT ************'       
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 13980100
       8700-EXIT.                                                       
            EXIT.                                                       
      ****************************************************************  13981000
      *  CLOSES  THE OUTPUT  FILE                                   **  13990000
      ****************************************************************  14000000
       9000-TERMINATE.                                                  
           CLOSE   MASTERS                                              
                   FCSCA316-FILE                                        
                   FCSPT80-FILE.                                        
      *                                                                 14042000
           IF  MASTERS-SUCCESSFUL                                       
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA316    ABORT ************'      
               DISPLAY '* 9000-TERMINATE                        *'      
               DISPLAY 'ERROR IN CLOSING MASTERS FILE'                  
               DISPLAY 'ERROR STATUS ' WS-MASTERS-STATUS                
               DISPLAY 'ACCOUNT NO   ' IN-ACCOUNT-NO                    
               DISPLAY '********** PCSCA316    ABORT ************'      
               PERFORM 9900-ABEND               THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 14110000
           IF  FCSCA316-SUCCESSFUL                                      
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA316    ABORT ************'      
               DISPLAY '* 9000-TERMINATE                        *'      
               DISPLAY 'ERROR IN CLOSING FCSCA316 FILE'                 
               DISPLAY 'ERROR STATUS ' WS-FCSCA316-STATUS               
               DISPLAY 'ACCOUNT NO   ' IN-ACCOUNT-NO                    
               DISPLAY '********** PCSCA316    ABORT ************'      
               PERFORM 9900-ABEND               THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 14180000
           IF  FPT80-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA316    ABORT ************'      
               DISPLAY '* 9000-TERMINATE                        *'      
               DISPLAY 'ERROR IN CLOSING FCSPT80 FILE'                  
               DISPLAY 'ERROR STATUS ' WS-FPT80-STATUS                  
               DISPLAY 'ACCOUNT NO   ' IN-ACCOUNT-NO                    
               DISPLAY '********** PCSCA316    ABORT ************'      
               PERFORM 9900-ABEND               THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 14187000
       9000-EXIT.                                                       
           EXIT.                                                        
      **************************************************************    14210000
      * THIS INCLUDES 9700-PROCESS-ABEND                           *    14220000
      **************************************************************    14220100
       COPY CPD0023B.                                                   14220200
      **************************************************************    14220300
      *  COPY BOOK CONTAINING 9900-ABEND AND 9900-EXIT             *    14220400
      **************************************************************    14220500
           EXEC SQL                                                     14220600
               INCLUDE CPD09900                                         14220700
           END-EXEC.                                                    14220800
