       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSCA312.                                            
       AUTHOR. DB41297.                                                 
       DATE-WRITTEN. JUN-2016.                                          
      *****************************************************************         
      **               SOUTH CAROLINA ELECTRIC & GAS                 **         
      *****************************************************************         
      ********                    CIG                         *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **     DATE       INITIALS  REASON                             **         
      **                                                             **         
      **   05/10/16     DB41297   WRITE REPORT OUTPUT TO DB2 TABLE   **         
      *****************************************************************         
            REMARKS.                                                    
      *****************************************************************         
      *  PURPOSE :                                                    *         
      *  THIS PROGRAM INSERTS INTO CSS_RPT312. IT ALSO GENERATES A    *         
      *  FILE CONTAINING THE FACTORS FOR EMERGENCY GAS                *         
      *                                                               *         
      *  INPUT :                                                      *         
      *  1. CSS_UTIL_ENVRNMT                                          *         
      *                                                               *         
      *  SCHEDULING DETAILS :                                         *         
      *  AN INITIAL RUN ON THE NIGHT OF THE 3RD WORK DAY OF THE MONTH *         
      *  AND A FINAL RUN ON THE 25TH DAY OF THE MONTH                 *         
      *                                                               *         
      *****************************************************************         
                         ---- BASIC SEQUENCE STRUCTURE ----             
                    0000 - 0999     MAIN CONTROL PATH                   
                    1000 - 1999     INITIALIZATION                      
                    1000 - 1999     INPUT PROCESSING CONTROL PATH       
                    2000 - 2999     OUTPUT PROCESSING CONTROL PATH      
                    3000 - 4999     BATCH PROCESSING MODULES - NOT USED 
                    5000 - 5999     COMMON PROGRAM MODULES              
                    6000 - 6999     COMMON SYSTEM MODULES               
                    7000 - 7999     INPUT MODULES                       
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9799     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA312'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40)  VALUE               
           'WORKING STORAGE FOR PCSCA312 STARTS HERE'.                  
                                                                        
       01  WS-MISC.                                                     
           05  WS-CURRENT-DATE-1         PIC X(10).                     
           05  WS-ONE                    PIC 9(02)  VALUE 01.           
           05  WS-ZERO                   PIC 9(02)  VALUE 00.           
           05  WS-ERR-MSG                PIC X(50)  VALUE SPACES.       
           05  WS-DISP-RC                PIC -ZZZZZZZZ9.9.              
           05  RS-RETURN-CODE            PIC S9(04) COMP.               
           05  RS-RETURN-CODE-DISP       PIC +Z(04).                    
           05  WS-COUNT                  PIC S9(04) COMP.               
           05  WS-TRNSP-COUNT            PIC S9(04) COMP.               
           05  WS-BILL-CODE              PIC X(01)  VALUE SPACE.        
           05  WS-BILL-DATE              PIC X(10)  VALUE SPACES.       
           05  WS-DATE-READ-NULL         PIC S9(4)  COMP.               
COB305     05 WS-BTU-FACTOR        PIC S9(2)V9(3) COMP-3 VALUE 0.         
           05  WS-TIMESTMP               PIC X(26).                     
           05  WS-ACCOUNT-NO             PIC X(13)  VALUE SPACES.       
           05  WS-BLOCK-NO               PIC S9(4)  COMP VALUE 1.       
           05  WS-TOTALREV               PIC S9(9)V9(2) COMP-3 VALUE 0. 
           05  WS-STANDBY-CHARGE         PIC S9(9)V9(2) COMP-3 VALUE 0. 
           05  WS-OTHER-CHARGE           PIC S9(9)V9(2) COMP-3 VALUE 0. 
           05  WS-TOTALDTS               PIC S9(10)V9(1) COMP-3 VALUE 0.
           05  WS-BILL-UNITS             PIC S9(9)V COMP-3 VALUE 0.     
           05  WS-HOLD-CX-DATA           PIC X(31000) VALUE SPACES.     
           05  WS-HOLD-BC-DATA           PIC X(100000) VALUE SPACES.    
           05  WS-HOLD-BA-DATA           PIC X(20400) VALUE SPACES.     
           05  WS-NO-UNITS-NULL-IND      PIC S9(04) COMP VALUE 0.       
           05  WS-TOTALDTS-NULL-IND      PIC S9(04) COMP VALUE 0.       
           05  WS-ERR-COMMENTS-TEXT-WF   PIC X(250) VALUE SPACES.       
           05  WS-SEQ-NO                 PIC 9(05)  VALUE 0.            
           05  WS-BEGIN-DATE             PIC X(10)  VALUE SPACES.       
           05  WS-END-DATE               PIC X(10)  VALUE SPACES.       
           05  WS-RS-DATE-FROM.                                         
               10  WS-RS-MM              PIC X(2) VALUE '00'.           
               10  WS-RS-DD              PIC X(2) VALUE '00'.           
           05  WS-CIG-DATE-FROM          PIC 9(4) VALUE ZEROES.         
           05  WS-MDQDATE.                                              
               10 WS-MDQDATE-YY          PIC 9(02).                     
               10 WS-MDQDATE-MM          PIC 9(02).                     
               10 WS-MDQDATE-DD          PIC 9(02).                     
           05  WS-CUR-REV-MON.                                          
               10  WS-REV-CCYY           PIC 9(04).                     
               10  WS-REV-MM             PIC 9(02).                     
           05  WS-CUR-REV-MON-CR      REDEFINES WS-CUR-REV-MON          
                                         PIC 9(06).                     
COB305     05 WS-CUR-REV-MON-NUM        PIC S9(6)V USAGE COMP-3 VALUE 0.       
                                                                        
           05  WS-REVENUE-MON.                                          
               10  WS-REV-CCYY-1         PIC 9(04).                     
               10  WS-REV-MM-1           PIC 9(02).                     
           05  WS-PROCESS-BILL-CALC      PIC X(01) VALUE 'N'.           
COB305     05 WS-BASE-RATE        PIC S9(5)V9(6) COMP-3 VALUE 0.         
           05  WS-FCTR-FF                PIC S9(09)V9(6) COMP-3         
                                              VALUE ZEROS.              
           05  WS-FCTR-FH                PIC S9(09)V9(6) COMP-3         
                                              VALUE ZEROS.              
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-PGRNAME                PIC X(08)  VALUE 'PCSCA312'.   
           05  WS-PGRMNAME               PIC X(08)  VALUE 'PCSCA312'.   
           05  PROGRAM-NAME              PIC X(08)  VALUE 'PCSCA312'.   
           05  SCSCA107                  PIC X(08)  VALUE 'SCSCA107'.   
           05  WS-DEFAULT-COMP-NO        PIC X(02)  VALUE '01'.         
           05  WS-ENERGY                 PIC X(01)  VALUE 'R'.          
           05  WS-BASE-ID                PIC X(02)  VALUE '10'.         
           05  WS-COMP-ID                PIC X(02)  VALUE '15'.         
           05  WS-EGAS-ID                PIC X(02)  VALUE '51'.         
           05  WS-PGAS-ID                PIC X(02)  VALUE '55'.         
           05  WS-TRANS-ID               PIC X(02)  VALUE '65'.         
           05  WS-G                      PIC X(01)  VALUE 'G'.          
           05  WS-VB                     PIC X(02)  VALUE 'VB'.         
           05  WS-VM                     PIC X(02)  VALUE 'VM'.         
           05  WS-BOTH                   PIC X(01)  VALUE 'B'.          
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  WS-NULL-DATE-ORIG-BILL      PIC S9(04) COMP VALUE 0.     
           05  WS-NULL-DATE-MTR-INSTALL    PIC S9(04) COMP VALUE 0.     
           05  WS-NULL-LAST-REG-READ-TIME  PIC S9(04) COMP VALUE 0.     
           05  WS-NULL-LAST-REG-READ-DATE  PIC S9(04) COMP VALUE 0.     
           05  WS-NULL-LAST-VALID-READ-TM  PIC S9(04) COMP VALUE 0.     
           05  WS-NULL-LAST-VALID-READ-DT  PIC S9(04) COMP VALUE 0.     
           05  WS-NULL-READ-CARD-PRINT-DT  PIC S9(04) COMP VALUE 0.     
           05  WS-NULL-LAST-UPDATE-TS      PIC S9(04) COMP VALUE 0.     
           05  WS-NULL-MTR-STATUS-CHNG-DT  PIC S9(04) COMP VALUE 0.     
           05  WS-NULL-BI-DATE-BILLED      PIC S9(04) COMP VALUE 0.     
           05  WS-NULL-DATE-BILLED         PIC S9(04) COMP VALUE 0.     
           05  WS-NULL-BILL-DATE           PIC S9(04) COMP VALUE 0.     
           05  WS-DATE-LFTM-HI-DMD-NULL    PIC S9(04) COMP VALUE 0.     
           05  WS-BG-DATE-LFTM-HI-DMD-NULL PIC S9(04) COMP VALUE 0.     
           05  WS-NULL-FF-FACTOR           PIC S9(04) COMP VALUE 0.     
           05  WS-OVRD-BILL-DT-NULL        PIC S9(04) COMP VALUE 0.     
                                                                        
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                  PIC X(02).                     
           05  WS-RD-DD                  PIC X(02).                     
           05  WS-RD-CC                  PIC X(02)  VALUE '20'.         
           05  WS-RD-YY                  PIC X(02).                     
      *                                                                         
       01  WS-PRIOR-MNTH-BREAKDOWN.                                     
           05  WS-PRIOR-YYYY             PIC X(04).                     
           05  WS-PRIOR-MM               PIC X(02).                     
                                                                        
       01  WS-SWITCHES.                                                 
           05 WS-CIG-CRSR-FL             PIC X(01) VALUE 'N'.           
              88 END-OF-CIG-CRSR         VALUE 'Y'.                     
           05 WS-BILL-CRSR-FL            PIC X(01) VALUE 'N'.           
              88 END-OF-BILL-CRSR        VALUE 'Y'.                     
           05 WS-BCAL-CRSR-FL            PIC X(01) VALUE 'N'.           
              88 END-OF-BCAL-CRSR        VALUE 'Y'.                     
           05 WS-CNSH-CRSR-FL            PIC X(01) VALUE 'N'.           
              88 END-OF-CNS-HST-CRSR     VALUE 'Y'.                     
           05 WS-MTRD-ENV-CRSR-FL        PIC X(01) VALUE 'N'.           
              88 END-OF-MTRD-ENV-CRSR    VALUE 'Y'.                     
           05 WS-BILLED-BG-FOUND         PIC X(01) VALUE 'N'.           
              88 BILLED-BG-FOUND         VALUE 'Y'.                     
              88 BILLED-BG-NOT-FOUND     VALUE 'N'.                     
           05 WS-FCTR-CRSR-FL            PIC X(01)  VALUE 'N'.          
              88 END-OF-FACTOR                      VALUE 'Y'.          
              88 MORE-FACTOR                        VALUE 'N'.          
           05  WS-BILL-DET-FL            PIC X(01)  VALUE SPACES.       
               88  MORE-BILLS                       VALUE 'Y'.          
               88  NO-MORE-BILLS                    VALUE 'N'.          
           05  WS-FIRST-ACCT-NOTFOU-SW   PIC  X(01) VALUE 'Y'.          
               88 FIRST-ACCT-NF-REP                 VALUE 'Y'.          
                                                                        
       01  WS-FLAGS.                                                    
           05 WS-Y                       PIC X(01)  VALUE 'Y'.          
           05 WS-N                       PIC X(01)  VALUE 'N'.          
                                                                        
      *    WS VARIABLE FOR REPORT 3 ERROR FILE                                  
                                                                        
           05  WS-RPT3-HEADER-LINE.                                     
               10 FILLER                   PIC X(10) VALUE              
                                            'ACCOUNT NO'.               
               10 FILLER                   PIC X(08) VALUE SPACES.      
               10 FILLER                   PIC X(07) VALUE 'BILL NO'.   
               10 FILLER                   PIC X(03) VALUE SPACES.      
               10 FILLER                   PIC X(10) VALUE              
                                            'ERROR CODE'.               
               10 FILLER                   PIC X(32) VALUE SPACES.      
                                                                        
           05 WS-RPT3-DETAIL-LINE1.                                     
              10 P-RPT3-ACCT-NO              PIC X(13)  VALUE SPACES.   
              10 FILLER                      PIC X(02)  VALUE SPACES.   
              10 P-RPT3-BILL-NO              PIC ZZZZZZZZ9.             
              10 FILLER                      PIC X(04)  VALUE SPACES.   
              10 P-RPT3-CALC-ERROR           PIC X(08).                 
              10 FILLER                      PIC X(44)  VALUE SPACES.   
           05 WS-RPT3-DETAIL-LINE2.                                     
              10 FILLER                      PIC X(20)  VALUE           
                 '         ERROR DESC:'.                                
              10 P-RPT3-MSG                  PIC X(60)  VALUE SPACES.   
                                                                        
      *************************************************                         
      *  COMMON COPYBOOK FOR WS-VARIABLES             *                         
      *************************************************                         
       COPY CWS00038.                                                           
       COPY CWS00114.                                                           
       COPY CWS00039.                                                           
       COPY CWS09900.                                                           
       COPY CWS00011.                                                           
       COPY CWS00074.                                                           
       COPY CWS00010.                                                           
       COPY CWS00303.                                                           
       COPY FIOJC01.                                                            
       COPY FIOCA00.                                                            
      *COPY FIOCA312.                                                           
      ******************************************************************        
      * FIOCA312 - I/O STATEMENT FOR MDQ AND VOLUMES BY MONTH REPORT   *        
      ******************************************************************        
      *                                                                         
       01 FIOCA312.                                                     
          02  FCA312-DATA-REC.                                          
              05  E-FCA312-SEQ-NO          PIC 9(05).                   
              05  E-FCA312-YRMO            PIC 9(06).                   
              05  E-FCA312-ACCOUNT-NO      PIC 9(13).                   
              05  E-FCA312-CUST-NAME       PIC X(40).                   
              05  E-FCA312-CUST-ADDRESS    PIC X(50).                   
              05  E-FCA312-CUST-ADDIT-ADDR PIC X(26).                   
              05  E-FCA312-CITY-STATE-ZIP  PIC X(41).                   
              05  E-FCA312-BSID            PIC 9(02).                   
              05  E-FCA312-BEG-DATE        PIC X(10).                   
              05  E-FCA312-PRORATE         PIC X(01).                   
              05  E-FCA312-RATE            PIC X(03).                   
              05  E-FCA312-CLASS           PIC X(03).                   
              05  E-FCA312-NUMERICS.                                    
COB305           10 E-FCA312-CDMDQ        PIC S9(7)V9(2) USAGE COMP-3 
COB305              VALUE 0.
COB305           10 E-FCA312-ACTMDQ        PIC S9(9)V9(1) USAGE COMP-3 
COB305              VALUE 0.
COB305           10 E-FCA312-BILLDEM        PIC S9(9)V USAGE COMP-3 
COB305              VALUE 0.
                 10  E-FCA312-MDQDATE      PIC 9(06).                   
COB305           10 E-FCA312-TOTALDTS        PIC S9(10)V9(1) 
COB305              USAGE COMP-3 VALUE 0.
COB305           10 E-FCA312-TRANSDTS        PIC S9(9)V USAGE COMP-3 
COB305              VALUE 0.
COB305           10 E-FCA312-COMPSDTS        PIC S9(9)V USAGE COMP-3 
COB305              VALUE 0.
COB305           10 E-FCA312-BASESDTS        PIC S9(9)V USAGE COMP-3 
COB305              VALUE 0.
COB305           10 E-FCA312-TRANSDEM        PIC S9(9)V USAGE COMP-3 
COB305              VALUE 0.
COB305           10 E-FCA312-BDEMREV        PIC S9(9)V9(2) USAGE COMP-3 
COB305              VALUE 0.
COB305           10 E-FCA312-TOTALREV        PIC S9(9)V9(2) 
COB305              USAGE COMP-3 VALUE 0.
COB305           10 E-FCA312-TRANSREV        PIC S9(9)V9(2) 
COB305              USAGE COMP-3 VALUE 0.
COB305           10 E-FCA312-COMPREV        PIC S9(9)V9(2) USAGE COMP-3 
COB305              VALUE 0.
COB305           10 E-FCA312-BASEREV        PIC S9(9)V9(2) USAGE COMP-3 
COB305              VALUE 0.
COB305           10 E-FCA312-OTHRREV        PIC S9(9)V9(2) USAGE COMP-3 
COB305              VALUE 0.
COB305           10 E-FCA312-STBYREV        PIC S9(9)V9(2) USAGE COMP-3 
COB305              VALUE 0.
COB305           10 E-FCA312-TDEMREV        PIC S9(9)V9(2) USAGE COMP-3 
COB305              VALUE 0.
                 10  E-FCA312-CATEGORY     PIC X(02).                   
                 10  E-FCA312-SICODE       PIC X(04).                   
COB305           10 E-FCA312-BASECOST        PIC S9(5)V9(6) 
COB305              USAGE COMP-3 VALUE 0.
COB305           10 E-FCA312-COMPCOST        PIC S9(5)V9(6) 
COB305              USAGE COMP-3 VALUE 0.
COB305           10 E-FCA312-TRANSCOST        PIC S9(5)V9(6) 
COB305              USAGE COMP-3 VALUE 0.
COB305           10 E-FCA312-EDTS        PIC S9(9)V USAGE COMP-3 
COB305              VALUE 0.
COB305           10 E-FCA312-EREV        PIC S9(9)V9(2) USAGE COMP-3 
COB305              VALUE 0.
COB305           10 E-FCA312-ECOST        PIC S9(5)V9(6) USAGE COMP-3 
COB305              VALUE 0.
COB305           10 E-FCA312-PDTS        PIC S9(9)V USAGE COMP-3 
COB305              VALUE 0.
COB305           10 E-FCA312-PREV        PIC S9(9)V9(2) USAGE COMP-3 
COB305              VALUE 0.
COB305           10 E-FCA312-PCOST        PIC S9(5)V9(6) USAGE COMP-3 
COB305              VALUE 0.
COB305           10 E-FCA312-MARKUP        PIC S9(5)V9(6) USAGE COMP-3 
COB305              VALUE 0.
              05  E-FCA312-CUST-NO         PIC 9(04).                   
          02  FCA312-BEGIN-REC REDEFINES FCA312-DATA-REC.               
              05  E-FCA312-KEY-BREC        PIC X(50).                   
              05  E-FCA312-REV-MONTH       PIC X(02).                   
              05  E-FCA312-REV-YEAR        PIC X(02).                   
              05  E-FCA312-FILE-ID         PIC X(01).                   
              05  E-FCA312-RUN-DATE        PIC X(08).                   
              05  FILLER                   PIC X(289).                  
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * SQL COMMUNICATION AREA                                        *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_ACCOUNT - AT                                              *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_UTIL_ENVRNMT - UT                                         *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBUTLENV                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_RATE_COMP_DEF - J1                                        *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBRTCDEF                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *  CSS_CNSMPTN_HIST                                             *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCNSMP                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_MTRD_ENVRNMT                                              *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBMTRENV                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_RATE_CREATOR - RT                                         *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBRTCRTR                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_BILLING_DET - BG                                          *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBBLLDET                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_BILL_CONTRACT  - BK                                       *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBBLCNTR                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_BILL_CNTR_HIST - BX                                       *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBBLCNTH                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_BILL_CALC_DET - BZ                                        *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBBLCLDT                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_PRTY_SVC_CAT -  Z4                                        *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSVCCAT                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_JOB_PARM - G6                                             *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_NAME - DQ                                               *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBNAME                                                  
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_NAME_ACCT_XREF - HT                                     *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBNMACTX                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_CUST_ADDR_XREF - DB                                     *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCSADRX                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_ADDR_FREEFORM - DZ                                      *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBADRFRE                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_ADDR_FORMATTED - DY                                     *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBADRFMT                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_ZIP_CODE - A4                                           *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBZIPCD                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_ACCT_MISC_INFO - TA                                     *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBATMISC                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_BILLING_HDR - BI                                        *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBBLLHDR                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_VOL_DAILY - ND                                          *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBVOLDLY                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_PRICE_SCHED  - PS                                       *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBPRCSCH                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_FIXED_FCT_HIST - FH                                     *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBFXHST                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_SPCL_FCTR_APPL - SA                                     *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSPLAPL                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_RATE_USE_SEASN - RS                                     *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBRTUSES                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_DELINQUENCY - C8                                        *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBDELQ                                                  
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_RATE_VRSN_DEF - J4                                      *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBRTVRSN                                                
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *   CSS_BILL_ADJUSTMNT - BP                                     *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
                INCLUDE TBBILADJ                                                
           END-EXEC.                                                            
                                                                        
      *COPY BOOK FOR GET_ORIG_BILL AND GET_CANCEL_BILL CURSORS                  
           EXEC SQL                                                             
                INCLUDE CWS00166                                                
           END-EXEC.                                                            
                                                                        
      *COPY BOOK FOR CDPCA107                                                   
           EXEC SQL                                                             
                INCLUDE CWS0022B                                                
           END-EXEC.                                                            
                                                                        
      **********************************                                        
      **  CSS_SPCL_FCTR               **                                        
      **********************************                                        
           EXEC SQL                                                             
             INCLUDE TBSPLFTR                                                   
           END-EXEC.                                                            
      *                                                                         
      **********************************                                        
      **  CSS_FIXED_FCTR              **                                        
      **********************************                                        
           EXEC SQL                                                             
             INCLUDE TBFXDFCT                                                   
           END-EXEC.                                                            
      *                                                                         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*             
      *   CSS_RPT_PCSCA312   - 4I                                               
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*             
                                                                        
           EXEC SQL                                                             
                INCLUDE TBRPT312                                                
           END-EXEC.                                                            
      *                                                                         
           COPY CWS1001A.                                                       
                                                                        
           COPY CWS1000A.                                                       
           COPY CWS1000B.                                                       
           COPY CWS0024B.                                                       
           COPY CWS1001B.                                                       
      *---------------------------------------------------------------*         
      * CIG_CRSR   CURSOR FOR FETCHING ALL THE INDUSTRIAL GAS         *         
      * CUSTOMERS FROM CSS_UTIL_ENVRNMT,CSS_RATE_COMP_DEF TABLES      *         
      *---------------------------------------------------------------*         
                                                                        
           EXEC SQL                                                     
             DECLARE CIG_CRSR CURSOR FOR                                
               SELECT  UT.ACCOUNT_NO,                                   
                       UT.IC_NO,                                        
                       UT.CODE_UTIL_TYPE,                               
                       UT.READ_CYCLE,                                   
                       UT.RATE_PLAN_NO,                                 
                       UT.CODE_REVENUE_CLASS,                           
                       UT.CODE_MTR_READ_FREQ                            
                 FROM  CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
                WHERE  UT.CODE_UTIL_TYPE   = :WS-G                      
                  AND  UT.COMPANY_NO       = :WS-DEFAULT-COMP-NO        
                  AND  UT.RATE_PLAN_NO IN                               
                      (SELECT J1.RATE_PLAN_NO                           
                         FROM CSS_RATE_COMP_DEF J1 WITH(READUNCOMMITTED)        
                        WHERE J1.CODE_UTIL_TYPE ='G'                    
                          AND J1.REG_TYPE_CD    = 'D'                   
                          AND J1.VERSION_NO_CNTRL =                     
                            (SELECT MAX(VERSION_NO_CNTRL)               
                               FROM CSS_RATE_COMP_DEF J2
                           WITH(READUNCOMMITTED)                
                              WHERE J2.CODE_UTIL_TYPE = 'G'             
                                AND J2.RATE_PLAN_NO = J1.RATE_PLAN_NO)) 
                ORDER BY UT.ACCOUNT_NO, UT.IC_NO                        
                FOR READ ONLY                                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE CIG_CRSR CURSOR FOR                                        
MFA-TR*        SELECT  UT.ACCOUNT_NO,                                           
MFA-TR*                UT.IC_NO,                                                
MFA-TR*                UT.CODE_UTIL_TYPE,                                       
MFA-TR*                UT.READ_CYCLE,                                           
MFA-TR*                UT.RATE_PLAN_NO,                                         
MFA-TR*                UT.CODE_REVENUE_CLASS,                                   
MFA-TR*                UT.CODE_MTR_READ_FREQ                                    
MFA-TR*          FROM  CSS_UTIL_ENVRNMT UT                                      
MFA-TR*         WHERE  UT.CODE_UTIL_TYPE   = :WS-G                              
MFA-TR*           AND  UT.COMPANY_NO       = :WS-DEFAULT-COMP-NO                
MFA-TR*           AND  UT.RATE_PLAN_NO IN                                       
MFA-TR*               (SELECT J1.RATE_PLAN_NO                                   
MFA-TR*                  FROM CSS_RATE_COMP_DEF J1                              
MFA-TR*                 WHERE J1.CODE_UTIL_TYPE ='G'                            
MFA-TR*                   AND J1.REG_TYPE_CD    = 'D'                           
MFA-TR*                   AND J1.VERSION_NO_CNTRL =                             
MFA-TR*                     (SELECT MAX(VERSION_NO_CNTRL)                       
MFA-TR*                        FROM CSS_RATE_COMP_DEF J2                        
MFA-TR*                       WHERE J2.CODE_UTIL_TYPE = 'G'                     
MFA-TR*                         AND J2.RATE_PLAN_NO = J1.RATE_PLAN_NO))         
MFA-TR*         ORDER BY UT.ACCOUNT_NO, UT.IC_NO                                
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7020                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
      *---------------------------------------------------------------*         
      * FIXED_FCT CURSOR FOR SELECTING FACTOR AND BILL UNITS FROM     *         
      * CSS_FIXED_FCT_HIST TABLE                                      *         
      *---------------------------------------------------------------*         
                                                                        
           EXEC SQL                                                     
                DECLARE FIXED_FCT CURSOR FOR                            
                  SELECT  FACTOR,                                       
                          BILL_UNITS,                                   
                          EFF_DATE_FROM,                                
                          EFF_DATE_TO,                                  
                          FCTR_POWER_10                                 
                    FROM  CSS_FIXED_FCT_HIST WITH(READUNCOMMITTED)              
                   WHERE  ACCOUNT_NO         = :BG-ACCOUNT-NO           
                     AND  CODE_UTIL_TYPE     = :WS-G                    
                     AND  IC_NO              = :BG-IC-NO                
                     AND  BILL_NO            = :BG-BILL-NO              
                     AND  BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )   
                     AND  FACTOR_ID          = '&EMERMAX'               
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE FIXED_FCT CURSOR FOR                                    
MFA-TR*           SELECT  FACTOR,                                               
MFA-TR*                   BILL_UNITS,                                           
MFA-TR*                   EFF_DATE_FROM,                                        
MFA-TR*                   EFF_DATE_TO,                                          
MFA-TR*                   FCTR_POWER_10                                         
MFA-TR*             FROM  CSS_FIXED_FCT_HIST                                    
MFA-TR*            WHERE  ACCOUNT_NO         = :BG-ACCOUNT-NO                   
MFA-TR*              AND  CODE_UTIL_TYPE     = :WS-G                            
MFA-TR*              AND  IC_NO              = :BG-IC-NO                        
MFA-TR*              AND  BILL_NO            = :BG-BILL-NO                      
MFA-TR*              AND  BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP           
MFA-TR*              AND  FACTOR_ID          = '&EMERMAX'                       
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*            QUERYNO 7750                                                 
MFA-TR*    END-EXEC.                                                            
                                                                        
      *---------------------------------------------------------------*         
      * BILL_CRSR CURSOR FOR SELECTING ALL BILL ROWS FROM             *         
      * CSS_BILLING_HDR AND CSS_BILLING_DET TABLE                     *         
      *---------------------------------------------------------------*         
                                                                        
           EXEC SQL                                                     
            DECLARE BILL_CRSR CURSOR FOR                                
              SELECT  BG.ACCOUNT_NO,                                    
                      BG.IC_NO,                                         
                      BG.BILL_NO,                                       
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           BG.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP,                            
                      BG.DATE_ORIG_BILL,                                
                      BG.CODE_DR_CR_CNSMPTN,                            
                      BG.CODE_BILL_CALC,                                
                      BG.CODE_BILL_ITM_TYPE,                            
                      BG.CODE_BILL_ITM_IND,                             
                      BG.AMT_BILL_ITEM,                                 
                      BG.AMT_STATE_TAX,                                 
                      BG.AMT_CITY_TAX,                                  
                      BG.AMT_OTHER_TAX,                                 
                      BI.DATE_BILLED,                                   
                      BG.CODE_UTIL_TYPE,                                
                      BG.CODE_REVENUE_CLASS,                            
                      CIS.CHAR2$DATE(BI.DATE_BILLED,'USA'),                     
                      BG.PREMISE_NO        ,                            
                      BG.RATE_PLAN_NO      ,                            
                      BG.CODE_CURTAIL_PRTY ,                            
                      BG.CODE_STAT_TAX_XMT ,                            
                      BG.CODE_CITY_TAX_XMT ,                            
                      BG.CODE_OTHR_TAX_XMT ,                            
                      BG.REV_RPT_CD        ,                            
                      BG.STANDBY_COMPLIED  ,                            
                      BG.CODE_SIC_NO       ,                            
                      BG.PRORATE_CD        ,                            
                      BG.NEW_RATE_PCT      ,                            
                      BG.CODE_SUB_TOTAL    ,                            
                      BG.TAX_REFUND_CD     ,                            
                      BG.COMPANY_NO        ,                            
                      BG.DATE_LFTM_HI_DMD  ,                            
                      BG.LFTM_HI_PEAK_DMD  ,                            
                      BG.REBILL_IND        ,                            
                      BG.ADJ_REASON_CD     ,                            
                      BG.REVENUE_MONTH     ,                            
                      BG.GAS_BASE_USE      ,                            
                      BG.WNA_FACTOR        ,                            
                      BG.BTU_FACTOR        ,                            
                      BG.REV_MTH_ORIG_BILL ,                            
                      BI.CODE_BILL_STATUS                               
                FROM  CSS_BILLING_DET    BG WITH(READUNCOMMITTED),              
                      CSS_BILLING_HDR    BI WITH(READUNCOMMITTED)               
               WHERE  BI.ACCOUNT_NO         = BG.ACCOUNT_NO             
                 AND  BI.BILL_NO            = BG.BILL_NO                
                 AND  BI.ACCOUNT_NO         = :BG-ACCOUNT-NO            
                 AND  BG.IC_NO              = :BG-IC-NO                 
                 AND  BG.CODE_UTIL_TYPE     = :WS-G                     
                 AND  BG.CODE_BILL_CALC     <> 'S'                      
                 AND  BG.CODE_BILL_ITM_TYPE = 'C'                       
                 AND  BG.CODE_BILL_ITM_IND  = 'A'                       
                 AND  BG.REVENUE_MONTH      IN (:BG-REVENUE-MONTH, 0)   
                 AND  BG.REV_MTH_ORIG_BILL  = 0                         
                 AND  BI.DATE_BILLED IS NULL                            
                 AND  EXISTS                                            
               ( SELECT ACCOUNT_NO                                      
                   FROM CSS_VOL_DAILY ND WITH(READUNCOMMITTED)                  
                  WHERE ND.ACCOUNT_NO         = BG.ACCOUNT_NO           
                    AND ND.BILL_NO            = BG.BILL_NO              
                    AND ND.IC_NO              = BG.IC_NO                
                    AND ND.CODE_UTIL_TYPE     = BG.CODE_UTIL_TYPE       
                    AND ND.VOL_TYPE_CD        = 'VB'                    
                    AND ND.DATE_READ BETWEEN IIF(TRY_CONVERT(DATE, 
                                                         :WS-BEGIN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-BEGIN-DATE
              ) <> 0) OR (LEN(:WS-BEGIN-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-BEGIN-DATE
              ), CONVERT(DATE, :WS-BEGIN-DATE) )             
                              AND IIF(TRY_CONVERT(DATE, :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) ))                         
               ORDER BY  BG.IC_NO, BG.BILL_NO                           
               FOR READ ONLY                                    
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE BILL_CRSR CURSOR FOR                                        
MFA-TR*       SELECT  BG.ACCOUNT_NO,                                            
MFA-TR*               BG.IC_NO,                                                 
MFA-TR*               BG.BILL_NO,                                               
MFA-TR*               BG.BILL_ITEM_TIMESTMP,                                    
MFA-TR*               BG.DATE_ORIG_BILL,                                        
MFA-TR*               BG.CODE_DR_CR_CNSMPTN,                                    
MFA-TR*               BG.CODE_BILL_CALC,                                        
MFA-TR*               BG.CODE_BILL_ITM_TYPE,                                    
MFA-TR*               BG.CODE_BILL_ITM_IND,                                     
MFA-TR*               BG.AMT_BILL_ITEM,                                         
MFA-TR*               BG.AMT_STATE_TAX,                                         
MFA-TR*               BG.AMT_CITY_TAX,                                          
MFA-TR*               BG.AMT_OTHER_TAX,                                         
MFA-TR*               BI.DATE_BILLED,                                           
MFA-TR*               BG.CODE_UTIL_TYPE,                                        
MFA-TR*               BG.CODE_REVENUE_CLASS,                                    
MFA-TR*               CHAR(BI.DATE_BILLED,USA),                                 
MFA-TR*               BG.PREMISE_NO        ,                                    
MFA-TR*               BG.RATE_PLAN_NO      ,                                    
MFA-TR*               BG.CODE_CURTAIL_PRTY ,                                    
MFA-TR*               BG.CODE_STAT_TAX_XMT ,                                    
MFA-TR*               BG.CODE_CITY_TAX_XMT ,                                    
MFA-TR*               BG.CODE_OTHR_TAX_XMT ,                                    
MFA-TR*               BG.REV_RPT_CD        ,                                    
MFA-TR*               BG.STANDBY_COMPLIED  ,                                    
MFA-TR*               BG.CODE_SIC_NO       ,                                    
MFA-TR*               BG.PRORATE_CD        ,                                    
MFA-TR*               BG.NEW_RATE_PCT      ,                                    
MFA-TR*               BG.CODE_SUB_TOTAL    ,                                    
MFA-TR*               BG.TAX_REFUND_CD     ,                                    
MFA-TR*               BG.COMPANY_NO        ,                                    
MFA-TR*               BG.DATE_LFTM_HI_DMD  ,                                    
MFA-TR*               BG.LFTM_HI_PEAK_DMD  ,                                    
MFA-TR*               BG.REBILL_IND        ,                                    
MFA-TR*               BG.ADJ_REASON_CD     ,                                    
MFA-TR*               BG.REVENUE_MONTH     ,                                    
MFA-TR*               BG.GAS_BASE_USE      ,                                    
MFA-TR*               BG.WNA_FACTOR        ,                                    
MFA-TR*               BG.BTU_FACTOR        ,                                    
MFA-TR*               BG.REV_MTH_ORIG_BILL ,                                    
MFA-TR*               BI.CODE_BILL_STATUS                                       
MFA-TR*         FROM  CSS_BILLING_DET    BG,                                    
MFA-TR*               CSS_BILLING_HDR    BI                                     
MFA-TR*        WHERE  BI.ACCOUNT_NO         = BG.ACCOUNT_NO                     
MFA-TR*          AND  BI.BILL_NO            = BG.BILL_NO                        
MFA-TR*          AND  BI.ACCOUNT_NO         = :BG-ACCOUNT-NO                    
MFA-TR*          AND  BG.IC_NO              = :BG-IC-NO                         
MFA-TR*          AND  BG.CODE_UTIL_TYPE     = :WS-G                             
MFA-TR*          AND  BG.CODE_BILL_CALC     <> 'S'                              
MFA-TR*          AND  BG.CODE_BILL_ITM_TYPE = 'C'                               
MFA-TR*          AND  BG.CODE_BILL_ITM_IND  = 'A'                               
MFA-TR*          AND  BG.REVENUE_MONTH      IN (:BG-REVENUE-MONTH, 0)           
MFA-TR*          AND  BG.REV_MTH_ORIG_BILL  = 0                                 
MFA-TR*          AND  BI.DATE_BILLED IS NULL                                    
MFA-TR*          AND  EXISTS                                                    
MFA-TR*        ( SELECT ACCOUNT_NO                                              
MFA-TR*            FROM CSS_VOL_DAILY ND                                        
MFA-TR*           WHERE ND.ACCOUNT_NO         = BG.ACCOUNT_NO                   
MFA-TR*             AND ND.BILL_NO            = BG.BILL_NO                      
MFA-TR*             AND ND.IC_NO              = BG.IC_NO                        
MFA-TR*             AND ND.CODE_UTIL_TYPE     = BG.CODE_UTIL_TYPE               
MFA-TR*             AND ND.VOL_TYPE_CD        = 'VB'                            
MFA-TR*             AND ND.DATE_READ BETWEEN :WS-BEGIN-DATE                     
MFA-TR*                       AND :WS-END-DATE)                                 
MFA-TR*        ORDER BY  BG.IC_NO, BG.BILL_NO                                   
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7220                                                     
MFA-TR*     END-EXEC.                                                           
                                                                        
      ******************************************************************        
      *  DECLARE CURSOR FOR METERED ENVIRONMENT                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
                DECLARE MTRD_ENVRNMT CURSOR FOR                         
                SELECT                                                  
                    ACCOUNT_NO,                                         
                    CODE_UTIL_TYPE,                                     
                    IC_NO,                                              
                    MTR_REF_NO,                                         
                    CODE_TIME_PERIOD,                                   
                    METER_NO,                                           
                    CODE_DISCOUNT,                                      
                    CODE_METER_LOC,                                     
                    CODE_METER_STATUS,                                  
                    CODE_STATUS_REAS,                                   
                    CODE_ALRT_CHNG_IND,                                 
                    DIST_NODE_POINT,                                    
                    CODE_DIVERSION,                                     
                    DATE_MTR_INSTALL,                                   
                    CODE_SPCL_SEAL,                                     
                    EST_USAGE,                                          
                    SPCL_MTR_CONDITION,                                 
                    CODE_DATA_PRESENT,                                  
                    CODE_USAGE_TYPE,                                    
                    CODE_USAGE_ID,                                      
                    CODE_USAGE_SOURCE,                                  
                    REG_ID_NO,                                          
                    REGISTER_RD_SEQ,                                    
                    CODE_CRNT_REG_READ,                                 
                    CODE_NO_RD_REASON,                                  
                    CODE_LAST_REG_READ,                                 
                    REPLACE(CONVERT(CHAR(8), LAST_REG_READ_TIME, 108), 
           ':', '.') LAST_REG_READ_TIME,                                 
                    LAST_REG_READ_DATE,                                 
                    LAST_READ_VALUE,                                    
                    NO_CONSEC_CRD_READ,                                 
                    NO_CONSEC_ESTIMATE,                                 
                    POINT_ID,                                           
                    LOCK_TYPE_ID,                                       
                    SEAL_CODE_ID,                                       
                    HEXAGRAM_LOCATION,                                  
                    INSULATED_IND,                                      
                    METER_SUPPLYING,                                    
                    REPLACE(CONVERT(CHAR(8), LAST_VALID_READ_TM, 108), 
           ':', '.') LAST_VALID_READ_TM,                                 
                    LAST_VALID_READ_DT,                                 
                    READ_CARD_PRINT_DT,                                 
                    EXCEPT_OVERRIDE_CD,                                 
                    CODE_MTR_RD_INST1,                                  
                    CODE_MTR_RD_INST2,                                  
                    CODE_MTR_RD_INST3,                                  
                    DIGTL_MTR_TYPE,                                     
                    REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,                        
                    LAST_VAL_RD_VALUE,                                  
                    CODE_LAST_VALID_RD,                                 
                    REMOTE_READ_IND,                                    
                    MTR_READ_SOURCE_CD,                                 
                    UTILITY_SOURCE_CD,                                  
                    DELIVERY_LEVEL_CD,                                  
                    MTR_STATUS_CHNG_DT                                  
                FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO     = :BG-ACCOUNT-NO      AND          
                      CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE  AND          
                      IC_NO          = :BG-IC-NO           AND          
                      METER_NO       > '         '                      
                FOR READ ONLY                                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE MTRD_ENVRNMT CURSOR FOR                                 
MFA-TR*         SELECT                                                          
MFA-TR*             ACCOUNT_NO,                                                 
MFA-TR*             CODE_UTIL_TYPE,                                             
MFA-TR*             IC_NO,                                                      
MFA-TR*             MTR_REF_NO,                                                 
MFA-TR*             CODE_TIME_PERIOD,                                           
MFA-TR*             METER_NO,                                                   
MFA-TR*             CODE_DISCOUNT,                                              
MFA-TR*             CODE_METER_LOC,                                             
MFA-TR*             CODE_METER_STATUS,                                          
MFA-TR*             CODE_STATUS_REAS,                                           
MFA-TR*             CODE_ALRT_CHNG_IND,                                         
MFA-TR*             DIST_NODE_POINT,                                            
MFA-TR*             CODE_DIVERSION,                                             
MFA-TR*             DATE_MTR_INSTALL,                                           
MFA-TR*             CODE_SPCL_SEAL,                                             
MFA-TR*             EST_USAGE,                                                  
MFA-TR*             SPCL_MTR_CONDITION,                                         
MFA-TR*             CODE_DATA_PRESENT,                                          
MFA-TR*             CODE_USAGE_TYPE,                                            
MFA-TR*             CODE_USAGE_ID,                                              
MFA-TR*             CODE_USAGE_SOURCE,                                          
MFA-TR*             REG_ID_NO,                                                  
MFA-TR*             REGISTER_RD_SEQ,                                            
MFA-TR*             CODE_CRNT_REG_READ,                                         
MFA-TR*             CODE_NO_RD_REASON,                                          
MFA-TR*             CODE_LAST_REG_READ,                                         
MFA-TR*             LAST_REG_READ_TIME,                                         
MFA-TR*             LAST_REG_READ_DATE,                                         
MFA-TR*             LAST_READ_VALUE,                                            
MFA-TR*             NO_CONSEC_CRD_READ,                                         
MFA-TR*             NO_CONSEC_ESTIMATE,                                         
MFA-TR*             POINT_ID,                                                   
MFA-TR*             LOCK_TYPE_ID,                                               
MFA-TR*             SEAL_CODE_ID,                                               
MFA-TR*             HEXAGRAM_LOCATION,                                          
MFA-TR*             INSULATED_IND,                                              
MFA-TR*             METER_SUPPLYING,                                            
MFA-TR*             LAST_VALID_READ_TM,                                         
MFA-TR*             LAST_VALID_READ_DT,                                         
MFA-TR*             READ_CARD_PRINT_DT,                                         
MFA-TR*             EXCEPT_OVERRIDE_CD,                                         
MFA-TR*             CODE_MTR_RD_INST1,                                          
MFA-TR*             CODE_MTR_RD_INST2,                                          
MFA-TR*             CODE_MTR_RD_INST3,                                          
MFA-TR*             DIGTL_MTR_TYPE,                                             
MFA-TR*             LAST_UPDATE_TS,                                             
MFA-TR*             LAST_VAL_RD_VALUE,                                          
MFA-TR*             CODE_LAST_VALID_RD,                                         
MFA-TR*             REMOTE_READ_IND,                                            
MFA-TR*             MTR_READ_SOURCE_CD,                                         
MFA-TR*             UTILITY_SOURCE_CD,                                          
MFA-TR*             DELIVERY_LEVEL_CD,                                          
MFA-TR*             MTR_STATUS_CHNG_DT                                          
MFA-TR*         FROM CSS_MTRD_ENVRNMT                                           
MFA-TR*         WHERE ACCOUNT_NO     = :BG-ACCOUNT-NO      AND                  
MFA-TR*               CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE  AND                  
MFA-TR*               IC_NO          = :BG-IC-NO           AND                  
MFA-TR*               METER_NO       > '         '                              
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7930                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  DECLARE CURSOR FOR CONSUMPTION HISTORY                        *        
      ******************************************************************        
           EXEC SQL                                                     
                DECLARE CNS_HST_CRSR CURSOR FOR                         
                  SELECT ACCOUNT_NO        ,                            
                         BILL_NO           ,                            
                         CODE_UTIL_TYPE    ,                            
                         IC_NO             ,                            
                         REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP,                            
                         CODE_TIME_PERIOD  ,                            
                         MTR_REF_NO        ,                            
                         CODE_USAGE_TYPE   ,                            
                         CODE_USAGE_ID     ,                            
                         CODE_USAGE_SOURCE ,                            
                         ITEM_SEQ_NO       ,                            
                         METER_NO          ,                            
                         REG_ID_NO         ,                            
                         DATE_READ         ,                            
                         CODE_METER_READ   ,                            
                         CODE_METER_NO_READ,                            
                         METER_READING     ,                            
                         DEMAND_READING    ,                            
                         EMPLOYEE_NO       ,                            
                         NO_UNITS          ,                            
                         NO_DEMAND_UNITS   ,                            
                         NO_DAYS           ,                            
                         CODE_SOURCE_ID    ,                            
                         CODE_DEBIT_CREDIT ,                            
                         CODE_ITEM_STATUS  ,                            
                         CODE_DISCOUNT     ,                            
                         CONSTANT          ,                            
                         NO_DIALS          ,                            
                         COMPANY_NO        ,                            
                         EXCEPT_OVERRIDE_CD,                            
                         REQUESTED_USAGE   ,                            
                         DIGTL_INTRL_MTR_NO,                            
                         DIGTL_MTR_TYPE    ,                            
                         CODE_TOU_SEASN    ,                            
                         EXCL_DMD_RCHT_IND                              
                    FROM CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                 
                   WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO            
                     AND BILL_NO            = :BG-BILL-NO               
                     AND CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE        
                     AND IC_NO              = :BG-IC-NO                 
                     AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )    
                    ORDER BY NO_DAYS DESC, DATE_READ DESC               
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE CNS_HST_CRSR CURSOR FOR                                 
MFA-TR*           SELECT ACCOUNT_NO        ,                                    
MFA-TR*                  BILL_NO           ,                                    
MFA-TR*                  CODE_UTIL_TYPE    ,                                    
MFA-TR*                  IC_NO             ,                                    
MFA-TR*                  BILL_ITEM_TIMESTMP,                                    
MFA-TR*                  CODE_TIME_PERIOD  ,                                    
MFA-TR*                  MTR_REF_NO        ,                                    
MFA-TR*                  CODE_USAGE_TYPE   ,                                    
MFA-TR*                  CODE_USAGE_ID     ,                                    
MFA-TR*                  CODE_USAGE_SOURCE ,                                    
MFA-TR*                  ITEM_SEQ_NO       ,                                    
MFA-TR*                  METER_NO          ,                                    
MFA-TR*                  REG_ID_NO         ,                                    
MFA-TR*                  DATE_READ         ,                                    
MFA-TR*                  CODE_METER_READ   ,                                    
MFA-TR*                  CODE_METER_NO_READ,                                    
MFA-TR*                  METER_READING     ,                                    
MFA-TR*                  DEMAND_READING    ,                                    
MFA-TR*                  EMPLOYEE_NO       ,                                    
MFA-TR*                  NO_UNITS          ,                                    
MFA-TR*                  NO_DEMAND_UNITS   ,                                    
MFA-TR*                  NO_DAYS           ,                                    
MFA-TR*                  CODE_SOURCE_ID    ,                                    
MFA-TR*                  CODE_DEBIT_CREDIT ,                                    
MFA-TR*                  CODE_ITEM_STATUS  ,                                    
MFA-TR*                  CODE_DISCOUNT     ,                                    
MFA-TR*                  CONSTANT          ,                                    
MFA-TR*                  NO_DIALS          ,                                    
MFA-TR*                  COMPANY_NO        ,                                    
MFA-TR*                  EXCEPT_OVERRIDE_CD,                                    
MFA-TR*                  REQUESTED_USAGE   ,                                    
MFA-TR*                  DIGTL_INTRL_MTR_NO,                                    
MFA-TR*                  DIGTL_MTR_TYPE    ,                                    
MFA-TR*                  CODE_TOU_SEASN    ,                                    
MFA-TR*                  EXCL_DMD_RCHT_IND                                      
MFA-TR*             FROM CSS_CNSMPTN_HIST                                       
MFA-TR*            WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO                    
MFA-TR*              AND BILL_NO            = :BG-BILL-NO                       
MFA-TR*              AND CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                
MFA-TR*              AND IC_NO              = :BG-IC-NO                         
MFA-TR*              AND BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP            
MFA-TR*             ORDER BY NO_DAYS DESC, DATE_READ DESC                       
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*            QUERYNO 7960                                                 
MFA-TR*    END-EXEC.                                                            
                                                                        
      *---------------------------------------------------------------*         
      *  CURSOR FOR BILL ADJUSTMENT                                   *         
      *---------------------------------------------------------------*         
                                                                        
           EXEC SQL                                                     
              DECLARE BILL_ADJ_CSR CURSOR FOR                           
                 SELECT BP.ADJ_TYPE_CD                                  
                       ,BP.REVENUE_MONTH                                
                       ,BP.ADJ_REASON_DESC                              
                       ,OVRRIDE_RT_REV_MTH                              
                       ,OVRRIDE_RT_BILL_DT                              
                       ,OVRRIDE_RT_BILL_CY                              
                   FROM CSS_BILL_ADJUSTMNT BP WITH(READUNCOMMITTED)             
                  WHERE BP.ACCOUNT_NO         = :BP-ACCOUNT-NO          
                    AND BP.BILL_NO            = :BP-BILL-NO             
                    AND BP.CODE_UTIL_TYPE     = :BP-CODE-UTIL-TYPE      
                    AND BP.IC_NO              = :BP-IC-NO               
                    AND BP.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BP-BILL-ITEM-TIMESTMP
              )  
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE BILL_ADJ_CSR CURSOR FOR                                   
MFA-TR*          SELECT BP.ADJ_TYPE_CD                                          
MFA-TR*                ,BP.REVENUE_MONTH                                        
MFA-TR*                ,BP.ADJ_REASON_DESC                                      
MFA-TR*                ,OVRRIDE_RT_REV_MTH                                      
MFA-TR*                ,OVRRIDE_RT_BILL_DT                                      
MFA-TR*                ,OVRRIDE_RT_BILL_CY                                      
MFA-TR*            FROM CSS_BILL_ADJUSTMNT BP                                   
MFA-TR*           WHERE BP.ACCOUNT_NO         = :BP-ACCOUNT-NO                  
MFA-TR*             AND BP.BILL_NO            = :BP-BILL-NO                     
MFA-TR*             AND BP.CODE_UTIL_TYPE     = :BP-CODE-UTIL-TYPE              
MFA-TR*             AND BP.IC_NO              = :BP-IC-NO                       
MFA-TR*             AND BP.BILL_ITEM_TIMESTMP = :BP-BILL-ITEM-TIMESTMP          
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7250                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
      *                                                                         
       01  WS-END                        PIC X(40)  VALUE               
             'WORKING STORAGE FOR PCSCA312 ENDS HERE  '.                
      *                                                                         
       PROCEDURE DIVISION.                                              

SCA006        SET WS-BILL-WQ-INDX TO 1.
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           MOVE '0000'                     TO  WS-ACTIVE-PARAGRAPH.     
                                                                        
           PERFORM 0100-INITIALIZATION     THRU 0100-EXIT.              
                                                                        
           PERFORM 1000-MAIN-PROCESS-PARA  THRU 1000-EXIT.              
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************               
      **                                                       **               
      **  0100-INITIALIZATION.                                 **               
      **        INITIALIZATION ROUTINE                         **               
      ***********************************************************               
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           MOVE '0100'                     TO   WS-ACTIVE-PARAGRAPH.    
                                                                        
      * GET THE RUN DATE FROM SYSTEM                                            
           PERFORM 7000-GET-CURRENT-DATE   THRU 7000-EXIT.              
                                                                        
           MOVE WS-CURRENT-DATE-1(3:2)     TO WS-RD-YY.                 
           MOVE WS-CURRENT-DATE-1(6:2)     TO WS-RD-MM.                 
           MOVE WS-CURRENT-DATE-1(9:2)     TO WS-RD-DD.                 
                                                                        
      * SELECT CURRENT REVENUE MONTH                                            
           PERFORM 0110-PROCESS-PARM-DATE  THRU 0110-EXIT.              
                                                                        
      * TO FIND THE BEGINNING AND END DATE OF THE REVENUE MONTH                 
           MOVE WS-CUR-REV-MON-CR          TO WS-PRIOR-MNTH-BREAKDOWN.  
                                                                        
           PERFORM 6000-GET-START-END-DATE THRU 6000-EXIT.              
                                                                        
           PERFORM 7985-DELETE-RPT312      THRU 7985-EXIT.              
                                                                        
           PERFORM 0500-PROCESS-BEGIN-REC  THRU 0500-EXIT.              
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    0110-PROCESS-PARM-DATE                                   **         
      **      PROCESSES THE REVENUE MONTH PARM.                      **         
      *****************************************************************         
       0110-PROCESS-PARM-DATE.                                          
                                                                        
           INITIALIZE WS-SYSIPT,                                        
                      WS-INPUT-DATA-BREAKDOWN.                          
                                                                        
           PERFORM 6200-GET-PARAMETER-DATE THRU 6200-EXIT.              
                                                                        
           MOVE WS-PARM-MONTH              TO WS-REV-MM-1.              
           MOVE WS-PARM-YR(1:4)            TO WS-REV-CCYY-1.            
                                                                        
           IF WS-RD-DD > '15'                                           
              MOVE WS-REV-CCYY-1           TO WS-REV-CCYY               
              SUBTRACT WS-ONE FROM WS-REV-MM-1 GIVING WS-REV-MM         
              IF WS-REV-MM = 0                                          
                 MOVE 12                   TO WS-REV-MM                 
                 SUBTRACT WS-ONE FROM WS-REV-CCYY-1 GIVING WS-REV-CCYY  
              END-IF                                                    
           ELSE                                                         
              MOVE WS-REV-MM-1             TO WS-REV-MM                 
              MOVE WS-REV-CCYY-1           TO WS-REV-CCYY               
           END-IF.                                                      
                                                                        
           IF NOT END-OF-SYSIPT                                         
               PERFORM 7611-CLOSE          THRU 7611-EXIT               
           END-IF.                                                      
                                                                        
           MOVE WS-CUR-REV-MON-CR          TO WS-CUR-REV-MON-NUM.       
      *                                                                         
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      **                                                         **             
      **      0500-PROCESS-BEGIN-REC.                            **             
      **           WRITES THE BEGINNING RECORD OF THE OUTPUT FILE**             
      *************************************************************             
      *                                                                         
       0500-PROCESS-BEGIN-REC.                                          
      *                                                                         
           MOVE '0500'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           INITIALIZE                       FIOCA312                    
                                            WS-TOTALREV.                
      *                                                                         
       0500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      **                                                         **             
      **      1000-MAIN-PROCESS-PARA                             **             
      **           MAIN PROCESS                                  **             
      *************************************************************             
      *                                                                         
       1000-MAIN-PROCESS-PARA.                                          
      *                                                                         
           MOVE '1000'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 7010-OPEN-CIG-CRSR         THRU 7010-EXIT            
           PERFORM 7020-FETCH-CIG-CRSR        THRU 7020-EXIT            
           PERFORM 2000-PROCESS-RECORDS       THRU 2000-EXIT            
                   UNTIL END-OF-CIG-CRSR                                
           PERFORM 7030-CLOSE-CIG-CRSR        THRU 7030-EXIT            
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **     2000-PROCESS-RECORDS.                                 **           
      **                                                           **           
      **  FROM THE CIG CUSTOMERS FETCHED, IDENTIFY THE ONES BILLED **           
      **  IN THE REVENUE MONTH PASSED USING COPYBOOK CPD00166      **           
      **                                                           **           
      ***************************************************************           
      *                                                                         
       2000-PROCESS-RECORDS.                                            
      *                                                                         
           MOVE '2000'                     TO WS-ACTIVE-PARAGRAPH.      
      *                                                                         
           INITIALIZE WS-CALC-ERROR                                     
                      WS-ERR-COMMENTS-TEXT-WF                           
      *                                                                         
           MOVE UT-ACCOUNT-NO              TO  AT-ACCOUNT-NO            
      *                                                                         
           PERFORM 7100-GET-ACCT-DET       THRU 7100-EXIT               
      *                                                                         
           PERFORM 2050-GET-CUST-INFO      THRU 2050-EXIT               
      *                                                                         
           IF WS-ACCOUNT-NO(2:4) EQUAL '1512'                           
              MOVE WS-ACCOUNT-NO(9:4)      TO  E-FCA312-CUST-NO         
           ELSE                                                         
              MOVE ZEROES                  TO  E-FCA312-CUST-NO         
           END-IF                                                       
      *                                                                         
           SET BG-RECORD-NOT-EXISTS        TO  TRUE                     
           MOVE 'N'                        TO  WS-NO-MORE-BG-SW         
           MOVE UT-ACCOUNT-NO              TO  BG-ACCOUNT-NO            
                                               BZ-ACCOUNT-NO            
                                               BX-ACCOUNT-NO            
                                               BK-ACCOUNT-NO            
                                               ND-ACCOUNT-NO            
           MOVE UT-CODE-UTIL-TYPE          TO  BG-CODE-UTIL-TYPE        
                                               BZ-CODE-UTIL-TYPE        
                                               BX-CODE-UTIL-TYPE        
                                               BK-CODE-UTIL-TYPE        
                                               ND-CODE-UTIL-TYPE        
                                               RS-CODE-UTIL-TYPE        
           MOVE UT-IC-NO                   TO  BG-IC-NO                 
                                               BZ-IC-NO                 
                                               BX-IC-NO                 
                                               BK-IC-NO                 
                                               ND-IC-NO                 
           MOVE WS-CUR-REV-MON-NUM         TO  BG-REVENUE-MONTH         
           SET BILLED-BG-NOT-FOUND                  TO TRUE             
      *                                                                         
           PERFORM 7110-OPEN-ORIG-BILL-CURSOR       THRU 7110-EXIT      
           PERFORM 7120-FETCH-ORIG-BILL-CURSOR      THRU 7120-EXIT      
           PERFORM UNTIL WS-NO-MORE-BG-SW EQUAL 'Y'                     
               PERFORM 7300-SELECT-BILLING-DET      THRU 7300-EXIT      
               IF BG-CODE-BILL-CALC     NOT EQUAL 'S' AND               
                  BG-CODE-REVENUE-CLASS NOT EQUAL '000'                 
                  SET BG-RECORD-EXISTS              TO TRUE             
                  SET BILLED-BG-NOT-FOUND           TO TRUE             
                  PERFORM 7150-OBTAIN-ALL-BG        THRU 7150-EXIT      
                  IF BG-RECORD-EXISTS                                   
                     SET BILLED-BG-FOUND            TO TRUE             
                     PERFORM 2100-PROCESS-BILLED-BG THRU 2100-EXIT      
                  END-IF                                                
               END-IF                                                   
               PERFORM 7120-FETCH-ORIG-BILL-CURSOR  THRU 7120-EXIT      
           END-PERFORM                                                  
      *                                                                         
           PERFORM 7130-CLOSE-ORIG-BILL-CURSOR      THRU 7130-EXIT      
      *                                                                         
           IF BILLED-BG-NOT-FOUND                                       
              PERFORM 2200-PROCESS-FUTURE-BILL      THRU 2200-EXIT      
           END-IF                                                       
      *                                                                         
           PERFORM 7020-FETCH-CIG-CRSR     THRU 7020-EXIT.              
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **     2050-GET-CUST-INFO.                                   **           
      **     GET CUSTOMER NAMD AND ADDRESS USING COPYBOOK CPD00074 **           
      ***************************************************************           
      *                                                                         
       2050-GET-CUST-INFO.                                              
      *                                                                         
           MOVE '2050'                     TO WS-ACTIVE-PARAGRAPH       
                                                                        
           MOVE UT-ACCOUNT-NO              TO HT-ACCOUNT-NO             
           PERFORM 4000-MAIL-NAME-ADDRESS  THRU 4000-EXIT               
      *                                                                         
           MOVE WS-CUSTOMER-NAME           TO E-FCA312-CUST-NAME        
           MOVE WS-PR-STREET               TO E-FCA312-CUST-ADDRESS     
           MOVE WS-PR-ADDR-OVERFLOW        TO E-FCA312-CUST-ADDIT-ADDR  
           MOVE WS-PR-ADDR-CITY-STATE-ZIP  TO E-FCA312-CITY-STATE-ZIP   
           MOVE WS-CUR-REV-MON-NUM         TO E-FCA312-YRMO             
           MOVE UT-ACCOUNT-NO              TO E-FCA312-ACCOUNT-NO       
                                              WS-ACCOUNT-NO             
           MOVE UT-IC-NO                   TO E-FCA312-BSID             
           MOVE WS-CUR-REV-MON-CR          TO E-FCA312-YRMO             
           .                                                            
       2050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **     2100-PROCESS-BILLED-BG.                               **           
      **     PROCESS CIG ACCOUNTS THAT HAVE BEEN BILLED ALREADY    **           
      ***************************************************************           
      *                                                                         
       2100-PROCESS-BILLED-BG.                                          
      *                                                                         
           MOVE '2100'                     TO WS-ACTIVE-PARAGRAPH       
                                                                        
           INITIALIZE                      WS-BILLING-COMPONENT         
                                           WS-BILLING-CALC-WORK         
                                           WS-BILLING-ADJUSTMENT        
                                           WS-BILL-CALC-BG              
                                           WS-BILL-CALC-CX              
                                           WS-BILL-CALC-UC              
                                           WS-BILL-CALC-FH              
                                           WS-BILL-CONTRACT-BK          
                                           WS-BILL-CNTR-HIST-BX         
                                           WS-BC-AMT-BILL-ITEM-BG.      
                                                                        
           PERFORM 7300-SELECT-BILLING-DET       THRU 7300-EXIT         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF BG-CODE-BILL-CALC     NOT EQUAL 'S' AND                
                 BG-CODE-REVENUE-CLASS NOT EQUAL '000'                  
                 CONTINUE                                               
              ELSE                                                      
                 GO TO 2100-EXIT                                        
              END-IF                                                    
           END-IF                                                       
           MOVE BG-PRORATE-CD                    TO E-FCA312-PRORATE    
           MOVE BG-RATE-PLAN-NO                  TO E-FCA312-RATE       
                                                    PS-RATE-PLAN-NO     
                                                    RS-RATE-PLAN-NO     
                                                    J4-RATE-PLAN-NO     
           MOVE BG-CODE-REVENUE-CLASS            TO E-FCA312-CLASS      
           MOVE BG-CODE-SIC-NO                   TO E-FCA312-SICODE     
                                                                        
      *** LOAD WS-BILL-CNTR-HIST-BX                                             
      *** GET CONTRACT DETAILS FROM CSS_BILLING_CONTRACT                        
                                                                        
           MOVE BG-BILL-NO                       TO BZ-BILL-NO          
                                                    ND-BILL-NO          
           MOVE BG-BILL-ITEM-TIMESTMP            TO                     
                                              BZ-BILL-ITEM-TIMESTMP     
                                              ND-BILL-ITEM-TIMESTMP     
                                                                        
           PERFORM 7355-SELECT-UBILL-CNTR-DMD    THRU 7355-EXIT         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE BK-CNTRCT-START-DT            TO E-FCA312-BEG-DATE   
              MOVE BK-CONTRACT-DEMAND            TO E-FCA312-CDMDQ      
           ELSE                                                         
              INITIALIZE                         E-FCA312-BEG-DATE      
                                                 E-FCA312-CDMDQ         
           END-IF                                                       
                                                                        
           MOVE +1                               TO WS-COUNT            
                                                                        
           MOVE BG-ACCOUNT-NO                    TO BI-ACCOUNT-NO       
           MOVE BG-BILL-NO                       TO BI-BILL-NO          
      *                                                                         
           PERFORM 7340-SELECT-BILLING-HDR       THRU 7340-EXIT         
      *                                                                         
           PERFORM 2500-BUILD-PASS-AREA    THRU 2500-EXIT               
           MOVE BI-CODE-BILL-STATUS        TO WS-BC-CODE-BILL-STATUS-BI 
      *                                                                         
           IF  WS-BC-REVENUE-MONTH-BG      EQUAL ZEROS AND              
               WS-BC-REV-MTH-ORIG-BILL-BG  EQUAL ZEROS                  
               MOVE WS-CUR-REV-MON-CR      TO WS-BC-REVENUE-MONTH-BG    
           END-IF.                                                      
      *                                                                         
           MOVE AT-COMPANY-NO              TO WS-COMPANY-NO-AT          
           MOVE AT-CODE-COMPANY-ACCT       TO WS-CODE-COMPANY-ACCT-AT   
           MOVE 'COG REPORT'               TO LS-INPUT-DATE             
      *                                                                         
           MOVE 'DATABASE'                 TO C8-DELINQ-CD              
           PERFORM 8600-SELECT-DELINQUENCY THRU 8600-EXIT               
           MOVE C8-DELINQ-VALUE            TO LS-DATABASE               
                                                                        
           INITIALIZE  LS-PCSCA100-COMM-AREA                            
      *                                                                         
           PERFORM 2450-CALL-BILL-CALC       THRU 2450-EXIT             
      *                                                                         
           IF WS-CALC-ERROR NOT = SPACES                                
              PERFORM 2455-CALL-BILL-CALC-ERROR  THRU 2455-EXIT         
              GO TO 2100-EXIT                                           
           END-IF                                                       
      *                                                                         
           PERFORM 2120-FORMAT-BASE-RATE-COG     THRU 2120-EXIT         
      *                                                                         
      *   CHECK FOR TRANSPORTATION BG                                           
      *                                                                         
           PERFORM 2130-SELECT-TRNSP-BG          THRU 2130-EXIT         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE WS-TOTALREV                   TO E-FCA312-TOTALREV   
              PERFORM 7990-INSERT-RPT312 THRU 7990-EXIT                 
           ELSE                                                         
              MOVE WS-TIMESTMP                TO BZ-BILL-ITEM-TIMESTMP  
                                                                        
              PERFORM 2500-BUILD-PASS-AREA    THRU 2500-EXIT            
              MOVE BI-CODE-BILL-STATUS     TO WS-BC-CODE-BILL-STATUS-BI 
                                                                        
              IF  WS-BC-REVENUE-MONTH-BG      EQUAL ZEROS AND           
                  WS-BC-REV-MTH-ORIG-BILL-BG  EQUAL ZEROS               
                  MOVE WS-CUR-REV-MON-CR      TO WS-BC-REVENUE-MONTH-BG 
              END-IF                                                    
                                                                        
              INITIALIZE  LS-PCSCA100-COMM-AREA                         
                          WS-BILLING-COMPONENT                          
                                                                        
              MOVE AT-COMPANY-NO           TO WS-COMPANY-NO-AT          
              MOVE AT-CODE-COMPANY-ACCT    TO WS-CODE-COMPANY-ACCT-AT   
              MOVE 'COG REPORT'            TO LS-INPUT-DATE             
                                                                        
              PERFORM 2450-CALL-BILL-CALC           THRU 2450-EXIT      
      *                                                                         
              IF WS-CALC-ERROR NOT = SPACES                             
                 PERFORM 2455-CALL-BILL-CALC-ERROR  THRU 2455-EXIT      
                 GO TO 2100-EXIT                                        
              END-IF                                                    
      *                                                                         
              MOVE 1                                TO WS-TRNSP-COUNT   
              PERFORM 2140-FORMAT-TRNSP-COG      THRU 2140-EXIT         
              MOVE WS-TOTALREV                   TO E-FCA312-TOTALREV   
              PERFORM 7990-INSERT-RPT312 THRU 7990-EXIT                 
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **     2120-FORMAT-BASE-RATE-COG                             **           
      **     CHECK FOR UNBILLED TRNSPORTATION BILLING DETAIL       **           
      ***************************************************************           
      *                                                                         
       2120-FORMAT-BASE-RATE-COG.                                       
      *                                                                         
           MOVE '2120'                     TO WS-ACTIVE-PARAGRAPH       
                                                                        
           MOVE BG-CODE-CURTAIL-PRTY       TO Z4-CODE-CURTAIL-PRTY      
           PERFORM 7400-SELECT-CATEGORY    THRU 7400-EXIT               
           MOVE Z4-PRTY-SVC-CAT-CD         TO E-FCA312-CATEGORY         
                                                                        
           PERFORM 7450-SELECT-ACTMDQ      THRU 7450-EXIT               
           IF WS-NO-UNITS-NULL-IND < 0                                  
              MOVE ZEROES                  TO E-FCA312-ACTMDQ           
                                              E-FCA312-MDQDATE          
           ELSE                                                         
              MOVE ND-NO-UNITS             TO E-FCA312-ACTMDQ           
              PERFORM 7460-SELECT-MDQDATE  THRU 7460-EXIT               
              MOVE ND-DATE-READ(3:2)       TO WS-MDQDATE-YY             
              MOVE ND-DATE-READ(6:2)       TO WS-MDQDATE-MM             
              MOVE ND-DATE-READ(9:2)       TO WS-MDQDATE-DD             
              MOVE WS-MDQDATE              TO E-FCA312-MDQDATE          
           END-IF                                                       
                                                                        
           PERFORM 7500-SELECT-TOTALDTS    THRU 7500-EXIT               
           MOVE WS-TOTALDTS                TO E-FCA312-TOTALDTS         
                                                                        
           MOVE ZEROES                     TO WS-TOTALREV               
                                                                        
           PERFORM VARYING BC-INDX FROM 1 BY 1                          
                   UNTIL BC-INDX > WS-BC-MAX-ENTRY                      
                   OR WS-BC-COMPONENT-ID(BC-INDX) = SPACES              
               PERFORM 2123-CHK-PROCESS-BILL-CALC   THRU 2123-EXIT      
               IF WS-PROCESS-BILL-CALC = 'Y'                            
                  PERFORM 2122-COMPUTE-TOTALS       THRU 2122-EXIT      
               END-IF                                                   
           END-PERFORM                                                  
           .                                                            
       2120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **     2121-PROCESS-BASE-ID.                                 **           
      **     ACCUMULATE TOTALS FOR COMPONENT ID '10'               **           
      ***************************************************************           
      *                                                                         
       2121-PROCESS-BASE-ID.                                            
      *                                                                         
           MOVE '2121'                     TO WS-ACTIVE-PARAGRAPH       
      *                                                                         
           ADD WS-BC-NET-COMPONENT-AMT(BC-INDX) TO WS-TOTALREV          
           IF ENERGY-COMPONENT(BC-INDX)                                 
              MOVE WS-BC-NET-UNITS(BC-INDX)                             
                                               TO E-FCA312-BASESDTS     
              MOVE WS-BC-CALC-COMPONENT-AMT(BC-INDX)                    
                                               TO E-FCA312-BASEREV      
                                                                        
                 MOVE ZEROES                   TO WS-STANDBY-CHARGE     
                                                     WS-OTHER-CHARGE    
                 PERFORM VARYING BA-INDX FROM 1 BY 1                    
                   UNTIL BA-INDX > 200                                  
                     OR WS-BC-FACTOR-ID (BA-INDX) NOT > SPACE           
                    IF WS-BC-FACTOR-COMPONENT (BA-INDX) =               
                             WS-BC-COMPONENT-KEY (BC-INDX) AND          
                       WS-BC-FACTOR-ID (BA-INDX) (1:7) = 'STANDBY'      
                          MOVE WS-BC-AMT-ADJUSTMENT (BA-INDX) TO        
                                                    WS-STANDBY-CHARGE   
                    END-IF                                              
                 END-PERFORM                                            
                                                                        
              MOVE ZEROES                        TO J4-AMT-CUST-CHRG    
              PERFORM 7980-GET-CUST-CHRG         THRU 7980-EXIT         
              ADD J4-AMT-CUST-CHRG               TO E-FCA312-BASEREV    
                                                                        
              MOVE WS-STANDBY-CHARGE             TO E-FCA312-STBYREV    
              COMPUTE WS-OTHER-CHARGE =                                 
                 WS-BC-NET-COMPONENT-AMT(BC-INDX) -                     
                 (WS-BC-CALC-COMPONENT-AMT(BC-INDX) + J4-AMT-CUST-CHRG  
                 + WS-STANDBY-CHARGE)                                   
              MOVE WS-OTHER-CHARGE               TO E-FCA312-OTHRREV    
                                                                        
      *** SELECT MARKUP FROM CSS_PRICE_SCHED ***                                
              MOVE WS-ENERGY                 TO PS-CODE-USE-INST-TYPE   
              MOVE WS-BASE-ID                TO PS-CMPNT-ID-CD          
              PERFORM 7650-SELECT-PRICE-SCHED     THRU 7650-EXIT        
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE ZERO                   TO PS-SCHED-PRICE-AM       
              END-IF                                                    
              PERFORM 2124-GET-BASE-RT          THRU 2124-EXIT          
              MOVE WS-BASE-RATE              TO E-FCA312-MARKUP         
              MOVE WS-BC-AMT-NET-RATE(BC-INDX, 1)                       
                                             TO E-FCA312-BASECOST       
           ELSE                                                         
              MOVE WS-BC-NET-UNITS(BC-INDX)                             
                                             TO E-FCA312-BILLDEM        
              MOVE WS-BC-NET-COMPONENT-AMT(BC-INDX)                     
                                             TO E-FCA312-BDEMREV        
           END-IF                                                       
           .                                                            
       2121-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **     2122-COMPUTE-TOTALS                                   **           
      **     COMPUTE REVENUE AND VOLUME TOTALS FROM OUTPUT OF      **           
      **     BILL CALC ROUTINE                                     **           
      ***************************************************************           
      *                                                                         
       2122-COMPUTE-TOTALS.                                             
      *                                                                         
           MOVE '2122'                     TO WS-ACTIVE-PARAGRAPH       
      *                                                                         
           EVALUATE WS-BC-COMPONENT-ID(BC-INDX)                         
               WHEN WS-BASE-ID                                          
                    PERFORM 2121-PROCESS-BASE-ID THRU 2121-EXIT         
               WHEN WS-COMP-ID                                          
                    ADD WS-BC-NET-COMPONENT-AMT(BC-INDX)                
                                              TO WS-TOTALREV            
                    MOVE WS-BC-NET-UNITS(BC-INDX)                       
                                              TO E-FCA312-COMPSDTS      
                    MOVE WS-BC-NET-COMPONENT-AMT(BC-INDX)               
                                              TO E-FCA312-COMPREV       
                    MOVE WS-BC-AMT-NET-RATE(BC-INDX, 1)                 
                                              TO E-FCA312-COMPCOST      
               WHEN WS-EGAS-ID                                          
                    ADD WS-BC-NET-COMPONENT-AMT(BC-INDX)                
                                              TO WS-TOTALREV            
                    MOVE WS-BC-NET-UNITS(BC-INDX)                       
                                              TO E-FCA312-EDTS          
                    MOVE WS-BC-NET-COMPONENT-AMT(BC-INDX)               
                                              TO E-FCA312-EREV          
                    IF E-FCA312-EDTS > 0                                
                       MOVE WS-BC-AMT-NET-RATE(BC-INDX, 1)              
                                             TO E-FCA312-ECOST          
                    ELSE                                                
                       MOVE ZEROES               TO E-FCA312-ECOST      
                    END-IF                                              
      ***                                                                       
      *** SELECT MARKUP FROM CSS_PRICE_SCHED ***                                
      ***                                                                       
                    MOVE WS-ENERGY           TO PS-CODE-USE-INST-TYPE   
                    MOVE WS-EGAS-ID          TO PS-CMPNT-ID-CD          
                    PERFORM 7650-SELECT-PRICE-SCHED THRU 7650-EXIT      
                    IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND            
                       MOVE ZERO             TO PS-SCHED-PRICE-AM       
                    END-IF                                              
                    PERFORM 2430-PROCESS-EMERGENCY-GAS                  
                                                 THRU 2430-EXIT         
               WHEN WS-PGAS-ID                                          
                    ADD WS-BC-NET-COMPONENT-AMT(BC-INDX)                
                                              TO WS-TOTALREV            
                    MOVE WS-BC-NET-UNITS(BC-INDX)                       
                                              TO E-FCA312-PDTS          
                    MOVE WS-BC-NET-COMPONENT-AMT(BC-INDX)               
                                              TO E-FCA312-PREV          
                    MOVE WS-BC-AMT-NET-RATE(BC-INDX, 1)                 
                                              TO E-FCA312-PCOST         
                                                                        
           END-EVALUATE                                                 
           .                                                            
       2122-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **     2123-CHK-PROCESS-BILL-CALC                            **           
      **     CHECK IF BILL CALC DETAILS SHOULD BE PROCESSED        **           
      ***************************************************************           
      *                                                                         
       2123-CHK-PROCESS-BILL-CALC.                                      
      *                                                                         
           MOVE '2123'                      TO WS-ACTIVE-PARAGRAPH      
      *                                                                         
           MOVE 'N'                         TO WS-PROCESS-BILL-CALC     
           MOVE WS-RS-DATE-FROM             TO WS-CIG-DATE-FROM         
           MOVE WS-CIG-DATE-FROM            TO RS-DATE-FROM             
           PERFORM 7910-GET-SEASONAL-CODE   THRU 7910-EXIT              
           IF WS-ACTIVE-RETURN-CODE EQUAL   TO NOT-FOUND                
              MOVE 'N'                      TO  RS-CODE-SEASON          
           END-IF                                                       
           IF WS-BC-NET-COMPONENT-AMT (BC-INDX) = ZERO AND              
              WS-BC-NET-UNITS (BC-INDX) = ZERO             AND          
              WS-BC-COMPONENT-ID(BC-INDX) <= '20'          AND          
              WS-BC-CIG-TRNSP-DET-BG = 'N'                 AND          
              WS-BC-TOTAL-WNA-AMT (BC-INDX) = 0            AND          
              ENERGY-COMPONENT (BC-INDX)                   AND          
              (WS-BC-CODE-SEASON (BC-INDX) = RS-CODE-SEASON      OR     
              WS-BC-CODE-SEASON (BC-INDX) = WS-BOTH)       AND          
              WS-BC-AMT-NET-RATE(BC-INDX, 1) > 0                        
              MOVE 'Y'          TO WS-PROCESS-BILL-CALC                 
           END-IF                                                       
           IF WS-BC-NET-COMPONENT-AMT (BC-INDX) NOT = ZERO              
               OR WS-BC-NET-UNITS (BC-INDX) NOT = ZERO                  
              MOVE 'Y'          TO WS-PROCESS-BILL-CALC                 
           END-IF                                                       
           .                                                            
       2123-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ***********************************************************               
      * 2124-GET-BASE-RT                                       **               
      *  BASE RATE = MARK-UP + COST OF GAS                     **               
      ***********************************************************               
       2124-GET-BASE-RT.                                                
      *                                                                         
           MOVE ZEROES                     TO WS-FCTR-FF.               
           MOVE WS-STNDTE-BEG-DATE         TO FF-EFF-DATE-FROM.         
           MOVE WS-STNDTE-END-DATE         TO FF-EFF-DATE-TO.           
           MOVE BG-ACCOUNT-NO              TO FF-ACCOUNT-NO.            
           MOVE BG-CODE-UTIL-TYPE          TO FF-CODE-UTIL-TYPE.        
           MOVE BG-IC-NO                   TO FF-IC-NO.                 
           PERFORM 7860-SELECT-FIXED-FCTR  THRU 7860-EXIT.              
           COMPUTE WS-BASE-RATE = WS-FCTR-FF + PS-SCHED-PRICE-AM.       
      *                                                                         
       2124-EXIT.                                                       
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **     2130-SELECT-TRNSP-BG                                  **           
      **     CHECK FOR UNBILLED TRNSPORTATION BILLING DETAIL       **           
      ***************************************************************           
      *                                                                         
       2130-SELECT-TRNSP-BG.                                            
      *                                                                         
           MOVE '2130'                     TO WS-ACTIVE-PARAGRAPH       
                                                                        
           PERFORM 7360-CALC-TRNSP-TIMESTMP    THRU 7360-EXIT           
                                                                        
           PERFORM 7370-SELECT-TRNSP-BG        THRU 7370-EXIT           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-NULL-DATE-BILLED < 0                                
                 MOVE SPACES               TO BI-DATE-BILLED            
              END-IF                                                    
              IF WS-NULL-BILL-DATE < 0                                  
                 MOVE SPACES               TO WS-BILL-DATE              
              END-IF                                                    
              IF WS-BG-DATE-LFTM-HI-DMD-NULL < 0                        
                 MOVE SPACES               TO BG-DATE-LFTM-HI-DMD       
              END-IF                                                    
           END-IF                                                       
           .                                                            
       2130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **     2140-FORMAT-TRNSP-COG.                                **           
      **     FORMAT TRANSPORTATION COG                             **           
      ***************************************************************           
      *                                                                         
       2140-FORMAT-TRNSP-COG.                                           
      *                                                                         
           MOVE '2140'                     TO WS-ACTIVE-PARAGRAPH       
                                                                        
           PERFORM VARYING BC-INDX FROM WS-TRNSP-COUNT BY 1             
              UNTIL BC-INDX > WS-BC-MAX-ENTRY                           
                 OR WS-BC-COMPONENT-ID(BC-INDX) = SPACES                
              PERFORM 2123-CHK-PROCESS-BILL-CALC     THRU 2123-EXIT     
              IF WS-PROCESS-BILL-CALC = 'Y'                             
                 EVALUATE WS-BC-COMPONENT-ID(BC-INDX)                   
                    WHEN WS-TRANS-ID                                    
                       ADD WS-BC-NET-COMPONENT-AMT(BC-INDX)             
                                                   TO WS-TOTALREV       
                       IF ENERGY-COMPONENT(BC-INDX)                     
                          MOVE WS-BC-NET-UNITS(BC-INDX) TO              
                                                   E-FCA312-TRANSDTS    
                          MOVE WS-BC-NET-COMPONENT-AMT(BC-INDX) TO      
                                                   E-FCA312-TRANSREV    
                          MOVE WS-BC-AMT-NET-RATE(BC-INDX, 1) TO        
                                                 E-FCA312-TRANSCOST     
                       ELSE                                             
                          MOVE WS-BC-NET-UNITS(BC-INDX) TO              
                                                   E-FCA312-TRANSDEM    
                          MOVE WS-BC-NET-COMPONENT-AMT(BC-INDX) TO      
                                                   E-FCA312-TDEMREV     
                       END-IF                                           
                 END-EVALUATE                                           
              END-IF                                                    
           END-PERFORM                                                  
           .                                                            
       2140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **     2200-PROCESS-FUTURE-BILL.                             **           
      **     PROCESS CIG ACCOUNTS THAT HAVE NOT BEEN BILLED        **           
      ***************************************************************           
      *                                                                         
       2200-PROCESS-FUTURE-BILL.                                        
      *                                                                         
           MOVE '2200'                     TO WS-ACTIVE-PARAGRAPH       
      *                                                                         
           MOVE 'N'                        TO WS-BILL-CRSR-FL           
      *                                                                         
           PERFORM 7210-OPEN-BILL-CURSOR   THRU 7210-EXIT               
           PERFORM 7220-FETCH-BILL-CURSOR  THRU 7220-EXIT               
           PERFORM UNTIL END-OF-BILL-CRSR                               
              IF BG-CODE-BILL-CALC     NOT EQUAL 'S' AND                
                 BG-CODE-REVENUE-CLASS NOT EQUAL '000'                  
                 PERFORM 2210-PROCESS-UNBILLED-BG THRU 2210-EXIT        
                 INITIALIZE                WS-TRNSP-COUNT               
              END-IF                                                    
              PERFORM 7220-FETCH-BILL-CURSOR THRU 7220-EXIT             
           END-PERFORM                                                  
           PERFORM 7230-CLOSE-BILL-CURSOR  THRU 7230-EXIT               
           .                                                            
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **     2210-PROCESS-UNBILLED-BG.                             **           
      **     CALL CPDCA107 TO PROCESS UNBILLED BG                  **           
      ***************************************************************           
      *                                                                         
       2210-PROCESS-UNBILLED-BG.                                        
      *                                                                         
           MOVE '2210'                     TO WS-ACTIVE-PARAGRAPH       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-NULL-DATE-ORIG-BILL < 0                             
                 MOVE LOW-VALUES           TO BG-DATE-ORIG-BILL         
              END-IF                                                    
              IF WS-NULL-DATE-BILLED < 0                                
                 MOVE SPACES               TO BI-DATE-BILLED            
              END-IF                                                    
              IF WS-NULL-BILL-DATE < 0                                  
                 MOVE SPACES               TO WS-BILL-DATE              
              END-IF                                                    
              IF WS-BG-DATE-LFTM-HI-DMD-NULL < 0                        
                 MOVE LOW-VALUES           TO BG-DATE-LFTM-HI-DMD       
              END-IF                                                    
           END-IF                                                       
                                                                        
           MOVE BG-BILL-NO                 TO ND-BILL-NO                
                                                                        
           MOVE BG-BILL-ITEM-TIMESTMP      TO ND-BILL-ITEM-TIMESTMP     
                                                                        
           MOVE BG-PRORATE-CD                    TO E-FCA312-PRORATE    
           MOVE BG-RATE-PLAN-NO                  TO E-FCA312-RATE       
                                                    PS-RATE-PLAN-NO     
                                                    RS-RATE-PLAN-NO     
           MOVE BG-CODE-REVENUE-CLASS            TO E-FCA312-CLASS      
           MOVE BG-CODE-SIC-NO                   TO E-FCA312-SICODE     
                                                                        
           PERFORM 7355-SELECT-UBILL-CNTR-DMD    THRU 7355-EXIT         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE BK-CNTRCT-START-DT            TO E-FCA312-BEG-DATE   
              MOVE BK-CONTRACT-DEMAND            TO E-FCA312-CDMDQ      
           ELSE                                                         
              MOVE SPACES                        TO E-FCA312-BEG-DATE   
              MOVE ZEROES                        TO E-FCA312-CDMDQ      
           END-IF                                                       
                                                                        
           PERFORM 2500-BUILD-PASS-AREA    THRU 2500-EXIT               
           MOVE BI-CODE-BILL-STATUS        TO WS-BC-CODE-BILL-STATUS-BI 
                                                                        
           IF  WS-BC-REVENUE-MONTH-BG      EQUAL ZEROS AND              
               WS-BC-REV-MTH-ORIG-BILL-BG  EQUAL ZEROS                  
               MOVE WS-CUR-REV-MON-CR      TO WS-BC-REVENUE-MONTH-BG    
           END-IF.                                                      
      *                                                                         
           MOVE AT-COMPANY-NO              TO WS-COMPANY-NO-AT          
           MOVE AT-CODE-COMPANY-ACCT       TO WS-CODE-COMPANY-ACCT-AT   
           MOVE 'COG REPORT'               TO LS-INPUT-DATE             
                                                                        
           MOVE 'DATABASE'                 TO C8-DELINQ-CD              
           PERFORM 8600-SELECT-DELINQUENCY THRU 8600-EXIT               
           MOVE C8-DELINQ-VALUE            TO LS-DATABASE               
                                                                        
           INITIALIZE  LS-PCSCA100-COMM-AREA                            
                                                                        
           PERFORM 2450-CALL-BILL-CALC           THRU 2450-EXIT         
      *                                                                         
           IF WS-CALC-ERROR NOT = SPACES                                
              PERFORM 2455-CALL-BILL-CALC-ERROR  THRU 2455-EXIT         
              GO TO 2210-EXIT                                           
           END-IF                                                       
      *                                                                         
           PERFORM 2120-FORMAT-BASE-RATE-COG     THRU 2120-EXIT         
      *                                                                         
           PERFORM 2215-UNBILLED-TRNSP-BG        THRU 2215-EXIT         
           .                                                            
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **     2215-UNBILLED-TRNSP-BG.                               **           
      **     IF TRNSP BG EXISTS, THEN ACCUMULATE THE DETAILS ALONG **           
      **     WITH BASERATE BG BEFORE WRITING TO OUTPUT             **           
      ***************************************************************           
      *                                                                         
       2215-UNBILLED-TRNSP-BG.                                          
      *                                                                         
           MOVE '2215'                     TO WS-ACTIVE-PARAGRAPH       
                                                                        
           PERFORM 2130-SELECT-TRNSP-BG    THRU 2130-EXIT               
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE WS-TOTALREV                   TO E-FCA312-TOTALREV   
              PERFORM 7990-INSERT-RPT312 THRU 7990-EXIT                 
           ELSE                                                         
              MOVE WS-TIMESTMP                TO BG-BILL-ITEM-TIMESTMP  
              PERFORM 2500-BUILD-PASS-AREA    THRU 2500-EXIT            
              MOVE BI-CODE-BILL-STATUS    TO WS-BC-CODE-BILL-STATUS-BI  
                                                                        
              IF  WS-BC-REVENUE-MONTH-BG      EQUAL ZEROS AND           
                  WS-BC-REV-MTH-ORIG-BILL-BG  EQUAL ZEROS               
                  MOVE WS-CUR-REV-MON-CR      TO WS-BC-REVENUE-MONTH-BG 
              END-IF                                                    
                                                                        
              INITIALIZE  LS-PCSCA100-COMM-AREA                         
                          WS-BILLING-COMPONENT                          
                                                                        
              MOVE AT-COMPANY-NO           TO WS-COMPANY-NO-AT          
              MOVE AT-CODE-COMPANY-ACCT    TO WS-CODE-COMPANY-ACCT-AT   
              MOVE 'COG REPORT'            TO LS-INPUT-DATE             
                                                                        
              PERFORM 2450-CALL-BILL-CALC           THRU 2450-EXIT      
      *                                                                         
              IF WS-CALC-ERROR NOT = SPACES                             
                 PERFORM 2455-CALL-BILL-CALC-ERROR  THRU 2455-EXIT      
                 GO TO 2215-EXIT                                        
              END-IF                                                    
      *                                                                         
              MOVE 1                                TO WS-TRNSP-COUNT   
              PERFORM 2140-FORMAT-TRNSP-COG         THRU 2140-EXIT      
              MOVE WS-TOTALREV                      TO E-FCA312-TOTALREV
              PERFORM 7990-INSERT-RPT312 THRU 7990-EXIT                 
           END-IF                                                       
           .                                                            
       2215-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **     2350-MOVE-FCSC3121-DET.                               **           
      **     MOVES DETAILS FOR FCSC3121 FILE                       **           
      ***************************************************************           
      *                                                                         
       2350-MOVE-FCSC3121-DET.                                          
      *                                                                         
           MOVE '2350'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
      *                                                                         
       2350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **     2420-PROCESS-FACTORS.                                 **           
      **     PROCESSES DETAILS FOR FIXED_FCT CURSOR                **           
      ***************************************************************           
      *                                                                         
       2420-PROCESS-FACTORS.                                            
      *                                                                         
           MOVE '2420'                     TO WS-ACTIVE-PARAGRAPH.      
      *                                                                         
           PERFORM 7850-SELECT-FACTOR-ID        THRU 7850-EXIT          
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              PERFORM 2350-MOVE-FCSC3121-DET    THRU 2350-EXIT          
           END-IF                                                       
                                                                        
           PERFORM 7750-FETCH-FIXED-FCT-CURSOR  THRU 7750-EXIT          
           .                                                            
       2420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **     2430-PROCESS-EMERGENCY-GAS                            **           
      **     PROCESSES DETAILS FOR EMERGENCY GAS FILE              **           
      ***************************************************************           
      *                                                                         
       2430-PROCESS-EMERGENCY-GAS.                                      
      *                                                                         
           MOVE '2430'                  TO WS-ACTIVE-PARAGRAPH          
                                                                        
           SET MORE-FACTOR              TO TRUE                         
           PERFORM 7700-OPEN-FIXED-FCT-CURSOR   THRU 7700-EXIT          
           PERFORM 7750-FETCH-FIXED-FCT-CURSOR  THRU 7750-EXIT          
           PERFORM 2420-PROCESS-FACTORS         THRU 2420-EXIT          
                   UNTIL END-OF-FACTOR.                                 
           PERFORM 7800-CLOSE-FIXED-FCT-CURSOR  THRU 7800-EXIT          
           .                                                            
       2430-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   2450-CALL-BILL-CALC                                      **          
      **   CALL BILL CALCULATION ROUTINE                            **          
      ****************************************************************          
                                                                        
       2450-CALL-BILL-CALC.                                             
                                                                        
           MOVE '2450'                     TO WS-ACTIVE-PARAGRAPH.      
           INITIALIZE WS-BC-BILL-DET-BT                                 
                      WS-BC-VOL-DAILY-ND                                
                      WS-BILL-CALC-DETAIL-X                             
                      WS-BILL-BSLN-CNTR-LN                              
                      WS-BILL-BSLN-HIST-LO                              
                      WS-RPT3-DETAIL-LINE1                              
                      WS-RPT3-DETAIL-LINE2,                             
                      WS-CNSMPTN-HOURLY,                                
                      WS-UTL-BILL-REL-TABLE-UR.                         
                                                                        
           CALL SCSCA107 USING   LS-PCSCA100-COMM-AREA   ,              
                                 WS-BILLING-CALC-WORK    ,              
                                 WS-BILLING-COMPONENT    ,              
                                 WS-BILLING-ADJUSTMENT   ,              
                                 WS-BILL-CALC-BG         ,              
                                 WS-BILL-CALC-CX         ,              
                                 WS-BILL-CALC-UC         ,              
                                 WS-BILL-CALC-FH         ,              
                                 WS-BILL-CONTRACT-BK     ,              
                                 WS-FIXED-FCTR-TABLE-FF  ,              
                                 WS-BILL-CNTR-HIST-BX    ,              
                                 WS-PEAK-HIST-PH         ,              
                                 WS-INTERRUPT-ACCT-IP    ,              
                                 WS-MTRD-ENVRNMT-TABLE-MN,              
                                 WS-STANDBY-GEN-SE       ,              
                                 WS-INTERRUPT-IR         ,              
                                 WS-HOLD-CX-DATA         ,              
                                 WS-HOLD-BC-DATA         ,              
                                 WS-HOLD-BA-DATA         ,              
                                 WS-BILLING-WQ-ITEMS-WF  ,              
                                 WS-REFUND-RN ,                         
                                 WS-ACCOUNT-AT,                         
                                 WS-BC-BILL-ADJUSTMNT,                  
                                 WS-BC-ACCT-RTPK-AGR-DF,                
                                 WS-BC-FIXED-FCTR-FF,                   
                                 WS-BC-BILL-DET-BT,                     
                                 WS-CWS22B-MAX-TBL-LIMITS,              
                                 WS-BILL-CALC-DETAIL-X,                 
                                 WS-BC-VOL-DAILY-ND,                    
                                 WS-BILL-BSLN-CNTR-LN,                  
                                 WS-BILL-BSLN-HIST-LO,                  
                                 WS-UTL-BILL-REL-TABLE-UR,              
                                 WS-INTERRUPT-NZ,                       
                                 WS-CNSMPTN-HOURLY.                     
                                                                        
       2450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *2455-CALL-BILL-CALC-ERROR. - MOVE THE VALUES TO RPT LAYOUT.   *          
      ****************************************************************          
       2455-CALL-BILL-CALC-ERROR.                                       
      *                                                                         
           MOVE BG-ACCOUNT-NO             TO P-RPT3-ACCT-NO             
           MOVE WS-COMMENTS-TEXT-WF(WS-BILL-WQ-INDX)                    
                                          TO WS-ERR-COMMENTS-TEXT-WF    
           MOVE WS-ERR-COMMENTS-TEXT-WF   TO P-RPT3-MSG                 
           MOVE WS-BC-BILL-NO-BG          TO P-RPT3-BILL-NO             
           MOVE WS-CALC-ERROR             TO P-RPT3-CALC-ERROR          
           DISPLAY '*** BILL CALC ERROR ***'.                           
           DISPLAY 'ACCOUNT  = ' P-RPT3-ACCT-NO                         
           DISPLAY 'COMMENTS = ' P-RPT3-MSG                             
           DISPLAY 'BILL NO  = ' P-RPT3-BILL-NO                         
           DISPLAY 'CALC ERR = ' P-RPT3-CALC-ERROR.                     
      *                                                                         
       2455-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2500-BUILD-PASS-AREA.                                          *        
      *  READ DATA BASE TABLES AND LOAD THE PASSAREA WITH DATA         *        
      ******************************************************************        
                                                                        
       2500-BUILD-PASS-AREA.                                            
      *                                                                         
           MOVE '2500'                     TO WS-ACTIVE-PARAGRAPH.      
      *                                                                         
           INITIALIZE  WS-BILLING-COMPONENT                             
                       WS-BILLING-CALC-WORK                             
                       WS-BILLING-ADJUSTMENT                            
                       WS-BILL-CALC-BG                                  
                       WS-BILL-CALC-CX                                  
                       WS-BILL-CALC-UC                                  
                       WS-BILL-CALC-FH                                  
                       WS-BILL-CONTRACT-BK                              
                       WS-BILL-CNTR-HIST-BX                             
                       WS-BC-AMT-BILL-ITEM-BG.                          
                                                                        
           PERFORM 8300-LOAD-BILLING-DETAILS                            
                                           THRU 8300-EXIT.              
                                                                        
           INITIALIZE WS-BC-BILL-ADJUSTMNT.                             
           SET WS-BC-ADJUSTMNT-INDEX          TO 1.                     
           MOVE BG-ACCOUNT-NO                 TO BP-ACCOUNT-NO.         
           MOVE BG-BILL-NO                    TO BP-BILL-NO.            
           MOVE BG-IC-NO                      TO BP-IC-NO.              
           MOVE BG-CODE-UTIL-TYPE             TO BP-CODE-UTIL-TYPE.     
           MOVE BG-BILL-ITEM-TIMESTMP         TO BP-BILL-ITEM-TIMESTMP. 
           PERFORM 7240-OPEN-BILL-ADJUSTMENT  THRU 7240-EXIT.           
           PERFORM 7250-FETCH-BILL-ADJUSTMENT THRU 7250-EXIT.           
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              PERFORM 7260-CLOSE-BILL-ADJUSTMENT THRU 7260-EXIT         
           ELSE                                                         
              PERFORM 8500-LOAD-BILL-ADJUSTMENT  THRU 8500-EXIT         
                UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND             
              PERFORM 7260-CLOSE-BILL-ADJUSTMENT THRU 7260-EXIT         
           END-IF.                                                      
                                                                        
           MOVE WS-CURRENT-DATE-1          TO WS-BC-CURRENT-DATE        
           IF  WS-BC-DATE-ORIG-BILL-BG  > SPACES                        
               MOVE WS-BC-DATE-ORIG-BILL-BG                             
                                           TO WS-BC-CALC-DATE           
           ELSE                                                         
              IF  BI-DATE-BILLED > SPACES                               
                  MOVE BI-DATE-BILLED      TO WS-BC-CALC-DATE           
              ELSE                                                      
                  MOVE WS-CURRENT-DATE-1   TO WS-BC-CALC-DATE           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7920-OPEN-MTRD-ENVRNMT  THRU  7920-EXIT.             
           PERFORM 7930-FETCH-MTRD-ENVRNMT THRU  7930-EXIT.             
                                                                        
           SET WS-MTRD-INDX TO 1.                                       
           PERFORM 8350-LOAD-MTR-ENVRNMT   THRU  8350-EXIT              
              UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.              
           PERFORM 7940-CLOSE-MTRD-ENVRNMT THRU  7940-EXIT.             
      *                                                                         
           PERFORM 7950-OPEN-CNSMPTN-HIST  THRU  7950-EXIT.             
           PERFORM 7960-FETCH-CNSMPTN-HIST THRU  7960-EXIT.             
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              SET CX-INDX TO 1                                          
               PERFORM 8400-LOAD-MTRD-CNSMPTN                           
                                           THRU  8400-EXIT              
                 UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND            
               PERFORM 7970-CLOSE-CNSMPTN-HIST                          
                                           THRU 7970-EXIT               
           ELSE                                                         
               PERFORM 7970-CLOSE-CNSMPTN-HIST                          
                                           THRU 7970-EXIT               
           END-IF                                                       
           .                                                            
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    4000-MAIL-NAME-ADDRESS.                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00074                                                 
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      ** 6000-GET-START-END-DATE.                                  **           
      ** THIS PARAGRAPH ESTABLISHS THE START AND ENDING DATES FOR  **           
      ** MONTH PASSED DOWN.                                        **           
      ***************************************************************           
                                                                        
       6000-GET-START-END-DATE.                                         
                                                                        
           MOVE '6000'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EVALUATE WS-PRIOR-MM                                         
              WHEN  '01'                                                
              WHEN  '03'                                                
              WHEN  '05'                                                
              WHEN  '07'                                                
              WHEN  '08'                                                
              WHEN  '10'                                                
              WHEN  '12'                                                
                 MOVE '31'                 TO WS-STNDTE-END-DAY         
              WHEN '04'                                                 
              WHEN '06'                                                 
              WHEN '09'                                                 
              WHEN '11'                                                 
                 MOVE '30'                 TO WS-STNDTE-END-DAY         
              WHEN '02'                                                 
                 MOVE 99                   TO WS-REMAINDER1             
                             WS-REMAINDER2                              
                 DIVIDE WS-NUM-CENTURY BY 4 GIVING WS-QUOTIENT          
                 REMAINDER WS-REMAINDER1                                
                 DIVIDE WS-NUM-CENTURY BY 400 GIVING WS-QUOTIENT        
                 REMAINDER WS-REMAINDER2                                
                    IF (    WS-REMAINDER1 NOT = ZERO                    
                         OR WS-REMAINDER2 = ZERO )                      
                         MOVE '28'         TO WS-STNDTE-END-DAY         
                    ELSE                                                
                         IF WS-REMAINDER1 = ZERO                        
                             MOVE '29'     TO WS-STNDTE-END-DAY         
                                                                        
                         END-IF                                         
                    END-IF                                              
              WHEN  OTHER                                               
                    DISPLAY '6000-GET-START-END-DATE'                   
                    'MONTH VALUE IS = ' WS-PRIOR-MM                     
                    PERFORM 9900-ABEND     THRU 9900-EXIT               
           END-EVALUATE.                                                
                                                                        
           MOVE '01'                       TO WS-STNDTE-BEG-DAY.        
                                                                        
           MOVE WS-PRIOR-MM                TO WS-STNDTE-BEG-MONTH       
                                              WS-STNDTE-END-MONTH.      
                                                                        
           MOVE WS-PRIOR-YYYY              TO WS-STNDTE-BEG-YEAR        
                                              WS-STNDTE-END-YEAR        
                                                                        
           MOVE WS-STNDTE-BEG-DATE         TO WS-BEGIN-DATE             
           MOVE WS-STNDTE-END-DATE         TO WS-END-DATE               
           MOVE WS-BEGIN-DATE(6:2)         TO WS-RS-MM                  
           MOVE '01'                       TO WS-RS-DD                  
           .                                                            
       6000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    6010-REDUCE-EMBEDDED-SPACES                                          
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00004                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    6200-GET-PARAMETER-DATE                                              
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00114                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   6251-GET-FJC01-DATE.                                                  
      ******************************************************************        
      *COPY CPD00037.                                                           
      *COPY CPD00040.                                                           
      ******************************************************************        
      *    7600-START-FJC01.                                                    
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    7600-START-FCJ01.                                                    
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **    7000-GET-CURRENT-DATE.                                 **           
      **         GETS CURRENT DATE USING SET STATEMENT                **        
      ***************************************************************           
      *                                                                         
       7000-GET-CURRENT-DATE.                                           
      *                                                                         
           MOVE '7000'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE-1                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET    :WS-CURRENT-DATE-1 =  CURRENT DATE                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA312 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7000       **'        
              DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **    7010-OPEN-CIG-CRSR.                                    **           
      **         OPENS CURSOR ON CSS_UTIL_ENVRNMT                  **           
      ***************************************************************           
                                                                        
       7010-OPEN-CIG-CRSR.                                              
                                                                        
           MOVE '7010'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                OPEN CIG_CRSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA312 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7010       **'        
              DISPLAY '**      SQLCODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**      UTIL TYPE = ' WS-G                       
              DISPLAY '**      COMP NO   = ' WS-DEFAULT-COMP-NO         
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **    7020-FETCH-CIG-CRSR.                                   **           
      **         FETCH ROWS FROM CSS_UTIL_ENVRNMT                  **           
      ***************************************************************           
                                                                        
       7020-FETCH-CIG-CRSR.                                             
                                                                        
           MOVE '7020'                     TO WS-ACTIVE-PARAGRAPH.      
           INITIALIZE                         FIOCA312.                 
                                                                        
           EXEC SQL                                                     
                FETCH CIG_CRSR                                          
                 INTO :UT-ACCOUNT-NO,                                   
                      :UT-IC-NO,                                        
                      :UT-CODE-UTIL-TYPE,                               
                      :UT-READ-CYCLE,                                   
                      :UT-RATE-PLAN-NO,                                 
                      :UT-CODE-REVENUE-CLASS,                           
                      :UT-CODE-MTR-READ-FREQ                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO  WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 SET END-OF-CIG-CRSR     TO TRUE                        
              WHEN OTHER                                                
                 DISPLAY '****************************************'     
                 DISPLAY '**     PCSCA312 PROCESSING ERROR      **'     
                 DISPLAY '**      ABEND IN PARAGRAPH 7020       **'     
                 DISPLAY '**      SQLCODE   = ' WS-ACTIVE-RETURN-CODE   
                 DISPLAY '**      UTIL TYPE = ' WS-G                    
                 DISPLAY '**      COMP NO   = ' WS-DEFAULT-COMP-NO      
                 DISPLAY '****************************************'     
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **    7030-CLOSE-CIG-CRSR.                                   **           
      **         CLOSES CURSOR ON CSS_UTIL_ENVRNMT                 **           
      ***************************************************************           
                                                                        
       7030-CLOSE-CIG-CRSR.                                             
                                                                        
           MOVE '7030'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                CLOSE CIG_CRSR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA312 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7030       **'        
              DISPLAY '**      SQLCODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**      SQLCODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**      UTIL TYPE = ' WS-G                       
              DISPLAY '**      COMP NO   = ' WS-DEFAULT-COMP-NO         
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **    7100-GET-ACCT-DET.                                     **           
      **         GET ACCOUNT DETAILS TO GET NAME AND ADDRESS       **           
      ***************************************************************           
                                                                        
       7100-GET-ACCT-DET.                                               
                                                                        
           MOVE '7100'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               SELECT ADDRESS_ID                                        
                     ,ADDRESS_FORMAT                                    
                     ,COMPANY_NO                                        
                     ,CODE_COMPANY_ACCT                                 
                 INTO :AT-ADDRESS-ID                                    
                     ,:AT-ADDRESS-FORMAT                                
                     ,:AT-COMPANY-NO                                    
                     ,:AT-CODE-COMPANY-ACCT                             
                  FROM  CSS_ACCOUNT WITH(READUNCOMMITTED)                       
                WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ADDRESS_ID                                                
MFA-TR*              ,ADDRESS_FORMAT                                            
MFA-TR*              ,COMPANY_NO                                                
MFA-TR*              ,CODE_COMPANY_ACCT                                         
MFA-TR*          INTO :AT-ADDRESS-ID                                            
MFA-TR*              ,:AT-ADDRESS-FORMAT                                        
MFA-TR*              ,:AT-COMPANY-NO                                            
MFA-TR*              ,:AT-CODE-COMPANY-ACCT                                     
MFA-TR*           FROM  CSS_ACCOUNT                                             
MFA-TR*         WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                              
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7100                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '*   PCSCA312 PROCESSING ERROR         **'        
              DISPLAY '*   ABEND IN PARAGRAPH 7100           **'        
              DISPLAY '*   SQLCODE =' WS-ACTIVE-RETURN-CODE             
              DISPLAY '*   ACCT NO =' AT-ACCOUNT-NO                     
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **    7150-OBTAIN-ALL-BG.                                    **           
      **         COPYBOOK FOR GETTING BILL NO                      **           
      **                                                           **           
      ***************************************************************           
                                                                        
           EXEC SQL                                                             
                INCLUDE CPD00166                                                
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **    7210-OPEN-BILL-CURSOR.                                 **           
      **         OPENS CURSOR ON CSS_BILLING_DET AND CSS_BILLING_HDR*           
      ***************************************************************           
                                                                        
       7210-OPEN-BILL-CURSOR.                                           
                                                                        
           MOVE '7210'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                OPEN BILL_CRSR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA312 PROCESSING ERROR      **'        
              DISPLAY '**     ABEND IN PARAGRAPH 7210        **'        
              DISPLAY '**     SQLCODE    = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**     ACCT NO    = ' BG-ACCOUNT-NO              
              DISPLAY '**     IC NO      = ' BG-IC-NO                   
              DISPLAY '**     UTIL TYPE  = ' WS-G                       
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **    7220-FETCH-BILL-CURSOR.                                **           
      **         FETCHES DETAILS FROM CSS_BILLING_DET,CSS_BILLING_HDR           
      ***************************************************************           
                                                                        
       7220-FETCH-BILL-CURSOR.                                          
                                                                        
           MOVE '7220'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                FETCH BILL_CRSR INTO                                    
                   :BG-ACCOUNT-NO,                                      
                   :BG-IC-NO,                                           
                   :BG-BILL-NO,                                         
                   :BG-BILL-ITEM-TIMESTMP,                              
                   :BG-DATE-ORIG-BILL :WS-NULL-DATE-ORIG-BILL,           
                   :BG-CODE-DR-CR-CNSMPTN,                              
                   :BG-CODE-BILL-CALC,                                  
                   :BG-CODE-BILL-ITM-TYPE,                              
                   :BG-CODE-BILL-ITM-IND,                               
                   :BG-AMT-BILL-ITEM,                                   
                   :BG-AMT-STATE-TAX,                                   
                   :BG-AMT-CITY-TAX,                                    
                   :BG-AMT-OTHER-TAX,                                   
                   :BI-DATE-BILLED :WS-NULL-DATE-BILLED,                 
                   :BG-CODE-UTIL-TYPE,                                  
                   :BG-CODE-REVENUE-CLASS,                              
                   :WS-BILL-DATE :WS-NULL-BILL-DATE,                     
                   :BG-PREMISE-NO       ,                               
                   :BG-RATE-PLAN-NO     ,                               
                   :BG-CODE-CURTAIL-PRTY ,                              
                   :BG-CODE-STAT-TAX-XMT,                               
                   :BG-CODE-CITY-TAX-XMT,                               
                   :BG-CODE-OTHR-TAX-XMT,                               
                   :BG-REV-RPT-CD       ,                               
                   :BG-STANDBY-COMPLIED ,                               
                   :BG-CODE-SIC-NO      ,                               
                   :BG-PRORATE-CD       ,                               
                   :BG-NEW-RATE-PCT     ,                               
                   :BG-CODE-SUB-TOTAL   ,                               
                   :BG-TAX-REFUND-CD    ,                               
                   :BG-COMPANY-NO       ,                               
                   :BG-DATE-LFTM-HI-DMD :WS-BG-DATE-LFTM-HI-DMD-NULL,    
                   :BG-LFTM-HI-PEAK-DMD ,                               
                   :BG-REBILL-IND       ,                               
                   :BG-ADJ-REASON-CD    ,                               
                   :BG-REVENUE-MONTH    ,                               
                   :BG-GAS-BASE-USE     ,                               
                   :BG-WNA-FACTOR       ,                               
                   :BG-BTU-FACTOR       ,                               
                   :BG-REV-MTH-ORIG-BILL,                               
                   :BI-CODE-BILL-STATUS                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 SET END-OF-BILL-CRSR       TO TRUE                     
              ELSE                                                      
                 DISPLAY '****************************************'     
                 DISPLAY '**     PCSCA312 PROCESSING ERROR      **'     
                 DISPLAY '**     ABEND IN PARAGRAPH 7220        **'     
                 DISPLAY '**     SQLCODE    = ' WS-ACTIVE-RETURN-CODE   
                 DISPLAY '**     ACCT NO    = ' BG-ACCOUNT-NO           
                 DISPLAY '**     IC NO      = ' BG-IC-NO                
                 DISPLAY '**     UTIL TYPE  = ' WS-G                    
                 DISPLAY '****************************************'     
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF                                                       
           .                                                            
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **    7230-CLOSE-BILL-CURSOR.                                **           
      **         CLOSES CURSOR ON CSS_BILLING_DET,CSS_BILLING_HDR  **           
      ***************************************************************           
                                                                        
       7230-CLOSE-BILL-CURSOR.                                          
                                                                        
           MOVE '7230'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                CLOSE BILL_CRSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA312 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7230       **'        
              DISPLAY '**     SQLCODE    = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**     ACCT NO    = ' BG-ACCOUNT-NO              
              DISPLAY '**     IC NO      = ' BG-IC-NO                   
              DISPLAY '**     UTIL TYPE  = ' WS-G                       
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **    7240-OPEN-BILL-ADJUSTMENT.                             **           
      **         OPENS CURSOR ON CSS_BILL_ADJUSTMNT                **           
      ***************************************************************           
       7240-OPEN-BILL-ADJUSTMENT.                                       
                                                                        
           MOVE '7240'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
                OPEN BILL_ADJ_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA312 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7240       **'        
              DISPLAY '**      ACCOUNT_NO    = ' BP-ACCOUNT-NO          
              DISPLAY '**      BILL_NO       = ' BP-BILL-NO             
              DISPLAY '**      CODE_UTIL_TYPE= ' BP-CODE-UTIL-TYPE      
              DISPLAY '**      IC_NO         = ' BP-IC-NO               
              DISPLAY '**      BILL TIMESTMP = ' BP-BILL-ITEM-TIMESTMP  
              DISPLAY '**      SQLCODE       = ' WS-ACTIVE-RETURN-CODE  
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **    7250-FETCH-BILL-ADJUSTMENT.                            **           
      **         FETCH CURSOR ON CSS_BILL_ADJUSTMNT                **           
      ***************************************************************           
       7250-FETCH-BILL-ADJUSTMENT.                                      
                                                                        
           MOVE '7250'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
               FETCH BILL_ADJ_CSR                                       
                INTO :BP-ADJ-TYPE-CD                                    
                    ,:BP-REVENUE-MONTH                                  
                    ,:BP-ADJ-REASON-DESC                                
                    ,:BP-OVRRIDE-RT-REV-MTH                             
                    ,:BP-OVRRIDE-RT-BILL-DT :WS-OVRD-BILL-DT-NULL        
                    ,:BP-OVRRIDE-RT-BILL-CY                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF WS-OVRD-BILL-DT-NULL < 0                            
                    MOVE SPACES              TO BP-OVRRIDE-RT-BILL-DT   
                 ELSE                                                   
                    CONTINUE                                            
                 END-IF                                                 
              ELSE                                                      
                 CONTINUE                                               
              END-IF                                                    
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA312 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7250       **'        
              DISPLAY '**      ACCOUNT_NO    = ' BP-ACCOUNT-NO          
              DISPLAY '**      BILL_NO       = ' BP-BILL-NO             
              DISPLAY '**      CODE_UTIL_TYPE= ' BP-CODE-UTIL-TYPE      
              DISPLAY '**      IC_NO         = ' BP-IC-NO               
              DISPLAY '**      BILL TIMESTMP = ' BP-BILL-ITEM-TIMESTMP  
              DISPLAY '**      SQLCODE       = ' WS-ACTIVE-RETURN-CODE  
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **    7260-CLOSE-BILL-ADJUSTMENT.                            **           
      **         CLOSE CURSOR ON CSS_BILL_ADJUSTMNT                **           
      ***************************************************************           
       7260-CLOSE-BILL-ADJUSTMENT.                                      
                                                                        
           MOVE '7260'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
               CLOSE BILL_ADJ_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA312 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7260       **'        
              DISPLAY '**      ACCOUNT_NO    = ' BP-ACCOUNT-NO          
              DISPLAY '**      BILL_NO       = ' BP-BILL-NO             
              DISPLAY '**      CODE_UTIL_TYPE= ' BP-CODE-UTIL-TYPE      
              DISPLAY '**      IC_NO         = ' BP-IC-NO               
              DISPLAY '**      BILL TIMESTMP = ' BP-BILL-ITEM-TIMESTMP  
              DISPLAY '**      SQLCODE       = ' WS-ACTIVE-RETURN-CODE  
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7260-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **                                                            **          
      **   7300-SELECT-BILLING-DET.                                 **          
      **      SELECTS DETILS FROM CSS_BILLING_DET TABLE             **          
      ****************************************************************          
                                                                        
       7300-SELECT-BILLING-DET.                                         
                                                                        
           MOVE '7300'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
             SELECT DATE_ORIG_BILL,                                     
                    CODE_DR_CR_CNSMPTN,                                 
                    CODE_BILL_CALC,                                     
                    CODE_BILL_ITM_TYPE,                                 
                    CODE_BILL_ITM_IND,                                  
                    AMT_BILL_ITEM,                                      
                    AMT_STATE_TAX,                                      
                    AMT_CITY_TAX,                                       
                    AMT_OTHER_TAX,                                      
                    PREMISE_NO,                                         
                    CODE_STAT_TAX_XMT,                                  
                    CODE_CITY_TAX_XMT,                                  
                    CODE_OTHR_TAX_XMT,                                  
                    REV_RPT_CD,                                         
                    STANDBY_COMPLIED,                                   
                    DATE_LFTM_HI_DMD,                                   
                    LFTM_HI_PEAK_DMD,                                   
                    REBILL_IND,                                         
                    ADJ_REASON_CD,                                      
                    GAS_BASE_USE,                                       
                    WNA_FACTOR,                                         
                    BTU_FACTOR,                                         
                    REV_MTH_ORIG_BILL,                                  
                    PRORATE_CD,                                         
                    NEW_RATE_PCT,                                       
                    CODE_SUB_TOTAL,                                     
                    TAX_REFUND_CD,                                      
                    COMPANY_NO,                                         
                    RATE_PLAN_NO,                                       
                    CODE_REVENUE_CLASS,                                 
                    CODE_SIC_NO,                                        
                    CODE_CURTAIL_PRTY                                   
               INTO :BG-DATE-ORIG-BILL :WS-NULL-DATE-ORIG-BILL,          
                    :BG-CODE-DR-CR-CNSMPTN,                             
                    :BG-CODE-BILL-CALC,                                 
                    :BG-CODE-BILL-ITM-TYPE,                             
                    :BG-CODE-BILL-ITM-IND,                              
                    :BG-AMT-BILL-ITEM,                                  
                    :BG-AMT-STATE-TAX,                                  
                    :BG-AMT-CITY-TAX,                                   
                    :BG-AMT-OTHER-TAX,                                  
                    :BG-PREMISE-NO,                                     
                    :BG-CODE-STAT-TAX-XMT,                              
                    :BG-CODE-CITY-TAX-XMT,                              
                    :BG-CODE-OTHR-TAX-XMT,                              
                    :BG-REV-RPT-CD,                                     
                    :BG-STANDBY-COMPLIED,                               
                    :BG-DATE-LFTM-HI-DMD :WS-BG-DATE-LFTM-HI-DMD-NULL,   
                    :BG-LFTM-HI-PEAK-DMD,                               
                    :BG-REBILL-IND,                                     
                    :BG-ADJ-REASON-CD,                                  
                    :BG-GAS-BASE-USE,                                   
                    :BG-WNA-FACTOR,                                     
                    :BG-BTU-FACTOR,                                     
                    :BG-REV-MTH-ORIG-BILL,                              
                    :BG-PRORATE-CD,                                     
                    :BG-NEW-RATE-PCT,                                   
                    :BG-CODE-SUB-TOTAL,                                 
                    :BG-TAX-REFUND-CD,                                  
                    :BG-COMPANY-NO,                                     
                    :BG-RATE-PLAN-NO,                                   
                    :BG-CODE-REVENUE-CLASS,                             
                    :BG-CODE-SIC-NO,                                    
                    :BG-CODE-CURTAIL-PRTY                               
               FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                       
              WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO                 
                AND BILL_NO            = :BG-BILL-NO                    
                AND CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE             
                AND IC_NO              = :BG-IC-NO                      
                AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DATE_ORIG_BILL,                                             
MFA-TR*             CODE_DR_CR_CNSMPTN,                                         
MFA-TR*             CODE_BILL_CALC,                                             
MFA-TR*             CODE_BILL_ITM_TYPE,                                         
MFA-TR*             CODE_BILL_ITM_IND,                                          
MFA-TR*             AMT_BILL_ITEM,                                              
MFA-TR*             AMT_STATE_TAX,                                              
MFA-TR*             AMT_CITY_TAX,                                               
MFA-TR*             AMT_OTHER_TAX,                                              
MFA-TR*             PREMISE_NO,                                                 
MFA-TR*             CODE_STAT_TAX_XMT,                                          
MFA-TR*             CODE_CITY_TAX_XMT,                                          
MFA-TR*             CODE_OTHR_TAX_XMT,                                          
MFA-TR*             REV_RPT_CD,                                                 
MFA-TR*             STANDBY_COMPLIED,                                           
MFA-TR*             DATE_LFTM_HI_DMD,                                           
MFA-TR*             LFTM_HI_PEAK_DMD,                                           
MFA-TR*             REBILL_IND,                                                 
MFA-TR*             ADJ_REASON_CD,                                              
MFA-TR*             GAS_BASE_USE,                                               
MFA-TR*             WNA_FACTOR,                                                 
MFA-TR*             BTU_FACTOR,                                                 
MFA-TR*             REV_MTH_ORIG_BILL,                                          
MFA-TR*             PRORATE_CD,                                                 
MFA-TR*             NEW_RATE_PCT,                                               
MFA-TR*             CODE_SUB_TOTAL,                                             
MFA-TR*             TAX_REFUND_CD,                                              
MFA-TR*             COMPANY_NO,                                                 
MFA-TR*             RATE_PLAN_NO,                                               
MFA-TR*             CODE_REVENUE_CLASS,                                         
MFA-TR*             CODE_SIC_NO,                                                
MFA-TR*             CODE_CURTAIL_PRTY                                           
MFA-TR*        INTO :BG-DATE-ORIG-BILL:WS-NULL-DATE-ORIG-BILL,                  
MFA-TR*             :BG-CODE-DR-CR-CNSMPTN,                                     
MFA-TR*             :BG-CODE-BILL-CALC,                                         
MFA-TR*             :BG-CODE-BILL-ITM-TYPE,                                     
MFA-TR*             :BG-CODE-BILL-ITM-IND,                                      
MFA-TR*             :BG-AMT-BILL-ITEM,                                          
MFA-TR*             :BG-AMT-STATE-TAX,                                          
MFA-TR*             :BG-AMT-CITY-TAX,                                           
MFA-TR*             :BG-AMT-OTHER-TAX,                                          
MFA-TR*             :BG-PREMISE-NO,                                             
MFA-TR*             :BG-CODE-STAT-TAX-XMT,                                      
MFA-TR*             :BG-CODE-CITY-TAX-XMT,                                      
MFA-TR*             :BG-CODE-OTHR-TAX-XMT,                                      
MFA-TR*             :BG-REV-RPT-CD,                                             
MFA-TR*             :BG-STANDBY-COMPLIED,                                       
MFA-TR*             :BG-DATE-LFTM-HI-DMD:WS-BG-DATE-LFTM-HI-DMD-NULL,           
MFA-TR*             :BG-LFTM-HI-PEAK-DMD,                                       
MFA-TR*             :BG-REBILL-IND,                                             
MFA-TR*             :BG-ADJ-REASON-CD,                                          
MFA-TR*             :BG-GAS-BASE-USE,                                           
MFA-TR*             :BG-WNA-FACTOR,                                             
MFA-TR*             :BG-BTU-FACTOR,                                             
MFA-TR*             :BG-REV-MTH-ORIG-BILL,                                      
MFA-TR*             :BG-PRORATE-CD,                                             
MFA-TR*             :BG-NEW-RATE-PCT,                                           
MFA-TR*             :BG-CODE-SUB-TOTAL,                                         
MFA-TR*             :BG-TAX-REFUND-CD,                                          
MFA-TR*             :BG-COMPANY-NO,                                             
MFA-TR*             :BG-RATE-PLAN-NO,                                           
MFA-TR*             :BG-CODE-REVENUE-CLASS,                                     
MFA-TR*             :BG-CODE-SIC-NO,                                            
MFA-TR*             :BG-CODE-CURTAIL-PRTY                                       
MFA-TR*        FROM CSS_BILLING_DET                                             
MFA-TR*       WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO                         
MFA-TR*         AND BILL_NO            = :BG-BILL-NO                            
MFA-TR*         AND CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                     
MFA-TR*         AND IC_NO              = :BG-IC-NO                              
MFA-TR*         AND BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP                 
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA312 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7300       **'        
              DISPLAY '**      SQLCODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**      ACCT NO   = ' BG-ACCOUNT-NO              
              DISPLAY '**      BILL NO   = ' BG-BILL-NO                 
              DISPLAY '**      UTIL TYPE = ' BG-CODE-UTIL-TYPE          
              DISPLAY '**      IC NO     = ' BG-IC-NO                   
              DISPLAY '**      TIMESTAMP = ' BG-BILL-ITEM-TIMESTMP      
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
        7300-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7340-SELECT-BILLING-HDR.                                 **          
      **      SELECTS DETAILS FROM CSS_BILLING_HDR                  **          
      ****************************************************************          
                                                                        
       7340-SELECT-BILLING-HDR.                                         
                                                                        
           MOVE '7340'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
             SELECT CODE_BILL_STATUS                                    
               INTO :BI-CODE-BILL-STATUS                                
               FROM CSS_BILLING_HDR WITH(READUNCOMMITTED)                       
              WHERE ACCOUNT_NO         = :BI-ACCOUNT-NO                 
                AND BILL_NO            = :BI-BILL-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CODE_BILL_STATUS                                            
MFA-TR*        INTO :BI-CODE-BILL-STATUS                                        
MFA-TR*        FROM CSS_BILLING_HDR                                             
MFA-TR*       WHERE ACCOUNT_NO         = :BI-ACCOUNT-NO                         
MFA-TR*         AND BILL_NO            = :BI-BILL-NO                            
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7340                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA312 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7340       **'        
              DISPLAY '**      SQLCODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**      ACCT NO   = ' BG-ACCOUNT-NO              
              DISPLAY '**      BILL NO   = ' BG-BILL-NO                 
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
        7340-EXIT.                                                      
            EXIT.                                                       
      ****************************************************************          
      **                                                            **          
      **   7355-SELECT-UBILL-CNTR-DMD                               **          
      **      SELECTS UNBILLED CONTRACT DEMAND FROM CSS_BILL_CNTR_HI**          
      ****************************************************************          
                                                                        
       7355-SELECT-UBILL-CNTR-DMD.                                      
                                                                        
           MOVE '7355'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) CNTRCT_START_DT,
              CONTRACT_DEMAND                                     
               INTO :BK-CNTRCT-START-DT,                                
                    :BK-CONTRACT-DEMAND                                 
               FROM CSS_BILL_CONTRACT WITH(READUNCOMMITTED)                     
              WHERE ACCOUNT_NO         = :BK-ACCOUNT-NO                 
                AND CODE_UTIL_TYPE     = :BK-CODE-UTIL-TYPE             
                AND IC_NO              = :BK-IC-NO                      
                AND CNTRCT_START_DT   <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-BEGIN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-BEGIN-DATE
              ) <> 0) OR (LEN(:WS-BEGIN-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-BEGIN-DATE
              ), CONVERT(DATE, :WS-BEGIN-DATE) )                 
              ORDER BY CNTRCT_START_DT                                  
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CNTRCT_START_DT,                                            
MFA-TR*             CONTRACT_DEMAND                                             
MFA-TR*        INTO :BK-CNTRCT-START-DT,                                        
MFA-TR*             :BK-CONTRACT-DEMAND                                         
MFA-TR*        FROM CSS_BILL_CONTRACT                                           
MFA-TR*       WHERE ACCOUNT_NO         = :BK-ACCOUNT-NO                         
MFA-TR*         AND CODE_UTIL_TYPE     = :BK-CODE-UTIL-TYPE                     
MFA-TR*         AND IC_NO              = :BK-IC-NO                              
MFA-TR*         AND CNTRCT_START_DT   <= :WS-BEGIN-DATE                         
MFA-TR*       ORDER BY CNTRCT_START_DT                                          
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7355                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *         AND CNTRCT_END_DT     >= :WS-END-DATE                           
                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA312 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7355       **'        
              DISPLAY '**      SQLCODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**      ACCT NO   = ' BK-ACCOUNT-NO              
              DISPLAY '**      UTIL TYPE = ' BK-CODE-UTIL-TYPE          
              DISPLAY '**      IC NO     = ' BK-IC-NO                   
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7355-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **    7360-CALC-TRNSP-TIMESTMP                                **          
      **      SELECTS DETAILS FROM CSS_BILL_CNTR_HIST               **          
      ****************************************************************          
                                                                        
       7360-CALC-TRNSP-TIMESTMP.                                        
                                                                        
           MOVE '7360'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MICROSECOND, 
              1, CIS.CHAR2TIMESTAMP(:BG-BILL-ITEM-TIMESTMP) ), 121), 
           ' ', '-'), ':', '.')
            INTO
              :WS-TIMESTMP   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-TIMESTMP   =                                              
MFA-TR*             TIMESTAMP(:BG-BILL-ITEM-TIMESTMP) + 1 MICROSECOND           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA312 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7360       **'        
              DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7360-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **    7370-SELECT-TRNSP-BG                                    **          
      **      SELECTS UNBILLED TRNSPORTATION BG                     **          
      ****************************************************************          
                                                                        
       7370-SELECT-TRNSP-BG.                                            
                                                                        
           MOVE '7370'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT BG.ACCOUNT_NO,                                     
                     BG.IC_NO,                                          
                     BG.BILL_NO,                                        
                     REPLACE(REPLACE(CONVERT(CHAR(26), 
           BG.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP,                             
                     BG.CODE_DR_CR_CNSMPTN,                             
                     BG.CODE_BILL_CALC,                                 
                     BG.CODE_BILL_ITM_TYPE,                             
                     BG.CODE_BILL_ITM_IND,                              
                     BG.AMT_BILL_ITEM,                                  
                     BG.AMT_STATE_TAX,                                  
                     BI.DATE_BILLED,                                    
                     BG.CODE_UTIL_TYPE,                                 
                     BG.CODE_REVENUE_CLASS,                             
                     CIS.CHAR2$DATE(BI.DATE_BILLED,'USA'),                      
                     BG.PREMISE_NO         ,                            
                     BG.RATE_PLAN_NO       ,                            
                     BG.CODE_CURTAIL_PRTY  ,                            
                     BG.PRORATE_CD         ,                            
                     BG.DATE_LFTM_HI_DMD   ,                            
                     BG.LFTM_HI_PEAK_DMD   ,                            
                     BG.REBILL_IND         ,                            
                     BG.REVENUE_MONTH      ,                            
                     BG.GAS_BASE_USE       ,                            
                     BG.WNA_FACTOR         ,                            
                     BG.BTU_FACTOR         ,                            
                     BG.REV_RPT_CD         ,                            
                     BG.REV_MTH_ORIG_BILL                               
                INTO :BG-ACCOUNT-NO,                                    
                     :BG-IC-NO,                                         
                     :BG-BILL-NO,                                       
                     :BG-BILL-ITEM-TIMESTMP,                            
                     :BG-CODE-DR-CR-CNSMPTN,                            
                     :BG-CODE-BILL-CALC,                                
                     :BG-CODE-BILL-ITM-TYPE,                            
                     :BG-CODE-BILL-ITM-IND,                             
                     :BG-AMT-BILL-ITEM,                                 
                     :BG-AMT-STATE-TAX,                                 
                     :BI-DATE-BILLED :WS-NULL-BI-DATE-BILLED,            
                     :BG-CODE-UTIL-TYPE,                                
                     :BG-CODE-REVENUE-CLASS,                            
                     :WS-BILL-DATE :WS-NULL-BILL-DATE,                   
                     :BG-PREMISE-NO         ,                           
                     :BG-RATE-PLAN-NO       ,                           
                     :BG-CODE-CURTAIL-PRTY  ,                           
                     :BG-PRORATE-CD         ,                           
                     :BG-DATE-LFTM-HI-DMD :WS-DATE-LFTM-HI-DMD-NULL,     
                     :BG-LFTM-HI-PEAK-DMD   ,                           
                     :BG-REBILL-IND         ,                           
                     :BG-REVENUE-MONTH      ,                           
                     :BG-GAS-BASE-USE       ,                           
                     :BG-WNA-FACTOR         ,                           
                     :BG-BTU-FACTOR         ,                           
                     :BG-REV-RPT-CD         ,                           
                     :BG-REV-MTH-ORIG-BILL                              
               FROM  CSS_BILLING_DET    BG WITH(READUNCOMMITTED),               
                     CSS_BILLING_HDR     BI WITH(READUNCOMMITTED)               
               WHERE  BI.ACCOUNT_NO         = BG.ACCOUNT_NO             
                 AND  BI.BILL_NO            = BG.BILL_NO                
                 AND  BI.ACCOUNT_NO         = :BG-ACCOUNT-NO            
                 AND  BG.IC_NO              = :BG-IC-NO                 
                 AND  BG.BILL_NO            = :BG-BILL-NO               
                 AND  BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE        
                 AND  BG.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                           :WS-TIMESTMP
              )              
                 AND  BG.CODE_BILL_CALC     <> 'S'                      
                 AND  BG.CODE_BILL_ITM_TYPE = 'C'                       
                 AND  BG.CODE_BILL_ITM_IND  = 'A'                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BG.ACCOUNT_NO,                                             
MFA-TR*              BG.IC_NO,                                                  
MFA-TR*              BG.BILL_NO,                                                
MFA-TR*              BG.BILL_ITEM_TIMESTMP,                                     
MFA-TR*              BG.CODE_DR_CR_CNSMPTN,                                     
MFA-TR*              BG.CODE_BILL_CALC,                                         
MFA-TR*              BG.CODE_BILL_ITM_TYPE,                                     
MFA-TR*              BG.CODE_BILL_ITM_IND,                                      
MFA-TR*              BG.AMT_BILL_ITEM,                                          
MFA-TR*              BG.AMT_STATE_TAX,                                          
MFA-TR*              BI.DATE_BILLED,                                            
MFA-TR*              BG.CODE_UTIL_TYPE,                                         
MFA-TR*              BG.CODE_REVENUE_CLASS,                                     
MFA-TR*              CHAR(BI.DATE_BILLED,USA),                                  
MFA-TR*              BG.PREMISE_NO         ,                                    
MFA-TR*              BG.RATE_PLAN_NO       ,                                    
MFA-TR*              BG.CODE_CURTAIL_PRTY  ,                                    
MFA-TR*              BG.PRORATE_CD         ,                                    
MFA-TR*              BG.DATE_LFTM_HI_DMD   ,                                    
MFA-TR*              BG.LFTM_HI_PEAK_DMD   ,                                    
MFA-TR*              BG.REBILL_IND         ,                                    
MFA-TR*              BG.REVENUE_MONTH      ,                                    
MFA-TR*              BG.GAS_BASE_USE       ,                                    
MFA-TR*              BG.WNA_FACTOR         ,                                    
MFA-TR*              BG.BTU_FACTOR         ,                                    
MFA-TR*              BG.REV_RPT_CD         ,                                    
MFA-TR*              BG.REV_MTH_ORIG_BILL                                       
MFA-TR*         INTO :BG-ACCOUNT-NO,                                            
MFA-TR*              :BG-IC-NO,                                                 
MFA-TR*              :BG-BILL-NO,                                               
MFA-TR*              :BG-BILL-ITEM-TIMESTMP,                                    
MFA-TR*              :BG-CODE-DR-CR-CNSMPTN,                                    
MFA-TR*              :BG-CODE-BILL-CALC,                                        
MFA-TR*              :BG-CODE-BILL-ITM-TYPE,                                    
MFA-TR*              :BG-CODE-BILL-ITM-IND,                                     
MFA-TR*              :BG-AMT-BILL-ITEM,                                         
MFA-TR*              :BG-AMT-STATE-TAX,                                         
MFA-TR*              :BI-DATE-BILLED:WS-NULL-BI-DATE-BILLED,                    
MFA-TR*              :BG-CODE-UTIL-TYPE,                                        
MFA-TR*              :BG-CODE-REVENUE-CLASS,                                    
MFA-TR*              :WS-BILL-DATE:WS-NULL-BILL-DATE,                           
MFA-TR*              :BG-PREMISE-NO         ,                                   
MFA-TR*              :BG-RATE-PLAN-NO       ,                                   
MFA-TR*              :BG-CODE-CURTAIL-PRTY  ,                                   
MFA-TR*              :BG-PRORATE-CD         ,                                   
MFA-TR*              :BG-DATE-LFTM-HI-DMD:WS-DATE-LFTM-HI-DMD-NULL,             
MFA-TR*              :BG-LFTM-HI-PEAK-DMD   ,                                   
MFA-TR*              :BG-REBILL-IND         ,                                   
MFA-TR*              :BG-REVENUE-MONTH      ,                                   
MFA-TR*              :BG-GAS-BASE-USE       ,                                   
MFA-TR*              :BG-WNA-FACTOR         ,                                   
MFA-TR*              :BG-BTU-FACTOR         ,                                   
MFA-TR*              :BG-REV-RPT-CD         ,                                   
MFA-TR*              :BG-REV-MTH-ORIG-BILL                                      
MFA-TR*        FROM  CSS_BILLING_DET    BG,                                     
MFA-TR*              CSS_BILLING_HDR     BI                                     
MFA-TR*        WHERE  BI.ACCOUNT_NO         = BG.ACCOUNT_NO                     
MFA-TR*          AND  BI.BILL_NO            = BG.BILL_NO                        
MFA-TR*          AND  BI.ACCOUNT_NO         = :BG-ACCOUNT-NO                    
MFA-TR*          AND  BG.IC_NO              = :BG-IC-NO                         
MFA-TR*          AND  BG.BILL_NO            = :BG-BILL-NO                       
MFA-TR*          AND  BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                
MFA-TR*          AND  BG.BILL_ITEM_TIMESTMP = :WS-TIMESTMP                      
MFA-TR*          AND  BG.CODE_BILL_CALC     <> 'S'                              
MFA-TR*          AND  BG.CODE_BILL_ITM_TYPE = 'C'                               
MFA-TR*          AND  BG.CODE_BILL_ITM_IND  = 'A'                               
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7370                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA312 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7370       **'        
              DISPLAY '**     SQLCODE    = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**     ACCOUNT NO = ' BG-ACCOUNT-NO              
              DISPLAY '**     BILL NO    = ' BG-BILL-NO                 
              DISPLAY '**     UTIL TYPE  = ' BG-CODE-UTIL-TYPE          
              DISPLAY '**     IC NO      = ' BG-IC-NO                   
              DISPLAY '**     TIMESTMP   = ' BG-BILL-ITEM-TIMESTMP      
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7370-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7400-SELECT-CATEGORY                                     **          
      **      SELECTS CATEGORY FROM CSS_PRTY_SVC_CAT TABLE          **          
      ****************************************************************          
                                                                        
       7400-SELECT-CATEGORY.                                            
                                                                        
           MOVE '7400'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
             SELECT PRTY_SVC_CAT_CD                                     
               INTO :Z4-PRTY-SVC-CAT-CD                                 
               FROM CSS_PRTY_SVC_CAT WITH(READUNCOMMITTED)                      
              WHERE COMPANY_NO        = :WS-DEFAULT-COMP-NO             
                AND CODE_CURTAIL_PRTY = :Z4-CODE-CURTAIL-PRTY           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT PRTY_SVC_CAT_CD                                             
MFA-TR*        INTO :Z4-PRTY-SVC-CAT-CD                                         
MFA-TR*        FROM CSS_PRTY_SVC_CAT                                            
MFA-TR*       WHERE COMPANY_NO        = :WS-DEFAULT-COMP-NO                     
MFA-TR*         AND CODE_CURTAIL_PRTY = :Z4-CODE-CURTAIL-PRTY                   
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7400                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA312 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7400       **'        
              DISPLAY '**     SQLCODE    = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**     COMPANY NO = ' WS-DEFAULT-COMP-NO         
              DISPLAY '**     CURTAIL-PRTY = ' Z4-CODE-CURTAIL-PRTY     
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
        7400-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7450-SELECT-ACTMDQ                                       **          
      **      SELECTS ACTUAL MDQ FROM CSS_VOL_DAILY TABLE           **          
      ****************************************************************          
      *                                                                         
       7450-SELECT-ACTMDQ.                                              
      *                                                                         
           MOVE '7450'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
             SELECT MAX(NO_UNITS)                                       
               INTO :ND-NO-UNITS :WS-NO-UNITS-NULL-IND                   
               FROM CSS_VOL_DAILY WITH(READUNCOMMITTED)                         
              WHERE ACCOUNT_NO          = :ND-ACCOUNT-NO                
                AND BILL_NO             = :ND-BILL-NO                   
                AND CODE_UTIL_TYPE      = :ND-CODE-UTIL-TYPE            
                AND IC_NO               = :ND-IC-NO                     
                AND BILL_ITEM_TIMESTMP  = CIS.CHAR2TIMESTAMP(
                                                 :ND-BILL-ITEM-TIMESTMP
              )        
                AND VOL_TYPE_CD         = :WS-VM                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT MAX(NO_UNITS)                                               
MFA-TR*        INTO :ND-NO-UNITS:WS-NO-UNITS-NULL-IND                           
MFA-TR*        FROM CSS_VOL_DAILY                                               
MFA-TR*       WHERE ACCOUNT_NO          = :ND-ACCOUNT-NO                        
MFA-TR*         AND BILL_NO             = :ND-BILL-NO                           
MFA-TR*         AND CODE_UTIL_TYPE      = :ND-CODE-UTIL-TYPE                    
MFA-TR*         AND IC_NO               = :ND-IC-NO                             
MFA-TR*         AND BILL_ITEM_TIMESTMP  = :ND-BILL-ITEM-TIMESTMP                
MFA-TR*         AND VOL_TYPE_CD         = :WS-VM                                
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7450                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA312 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7450       **'        
              DISPLAY '**      SQLCODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**      ACCT NO   = ' ND-ACCOUNT-NO              
              DISPLAY '**      BILL NO   = ' ND-BILL-NO                 
              DISPLAY '**      UTIL TYPE = ' ND-CODE-UTIL-TYPE          
              DISPLAY '**      IC NO     = ' ND-IC-NO                   
              DISPLAY '**      TIMESTAMP = ' ND-BILL-ITEM-TIMESTMP      
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
        7450-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7460-SELECT-MDQDATE                                      **          
      **      SELECTS ACTUAL MDQ DATE OF THE ACTUAL MDQ             **          
      ****************************************************************          
      *                                                                         
       7460-SELECT-MDQDATE.                                             
      *                                                                         
           MOVE '7460'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
             SELECT DATE_READ                                           
               INTO :ND-DATE-READ                                       
               FROM CSS_VOL_DAILY ND1 WITH(READUNCOMMITTED)                     
              WHERE ACCOUNT_NO          = :ND-ACCOUNT-NO                
                AND BILL_NO             = :ND-BILL-NO                   
                AND CODE_UTIL_TYPE      = :ND-CODE-UTIL-TYPE            
                AND IC_NO               = :ND-IC-NO                     
                AND BILL_ITEM_TIMESTMP  = CIS.CHAR2TIMESTAMP(
                                                 :ND-BILL-ITEM-TIMESTMP
              )        
                AND VOL_TYPE_CD         = :WS-VM                        
                AND NO_UNITS =                                          
                (SELECT MAX(NO_UNITS)                                   
                   FROM CSS_VOL_DAILY ND2 WITH(READUNCOMMITTED)                 
                  WHERE ND2.ACCOUNT_NO         = ND1.ACCOUNT_NO         
                    AND ND2.BILL_NO            = ND1.BILL_NO            
                    AND ND2.CODE_UTIL_TYPE     = ND1.CODE_UTIL_TYPE     
                    AND ND2.IC_NO              = ND1.IC_NO              
                    AND ND2.BILL_ITEM_TIMESTMP = ND1.BILL_ITEM_TIMESTMP 
                    AND ND2.VOL_TYPE_CD        = :WS-VM)                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DATE_READ                                                   
MFA-TR*        INTO :ND-DATE-READ                                               
MFA-TR*        FROM CSS_VOL_DAILY ND1                                           
MFA-TR*       WHERE ACCOUNT_NO          = :ND-ACCOUNT-NO                        
MFA-TR*         AND BILL_NO             = :ND-BILL-NO                           
MFA-TR*         AND CODE_UTIL_TYPE      = :ND-CODE-UTIL-TYPE                    
MFA-TR*         AND IC_NO               = :ND-IC-NO                             
MFA-TR*         AND BILL_ITEM_TIMESTMP  = :ND-BILL-ITEM-TIMESTMP                
MFA-TR*         AND VOL_TYPE_CD         = :WS-VM                                
MFA-TR*         AND NO_UNITS =                                                  
MFA-TR*         (SELECT MAX(NO_UNITS)                                           
MFA-TR*            FROM CSS_VOL_DAILY ND2                                       
MFA-TR*           WHERE ND2.ACCOUNT_NO         = ND1.ACCOUNT_NO                 
MFA-TR*             AND ND2.BILL_NO            = ND1.BILL_NO                    
MFA-TR*             AND ND2.CODE_UTIL_TYPE     = ND1.CODE_UTIL_TYPE             
MFA-TR*             AND ND2.IC_NO              = ND1.IC_NO                      
MFA-TR*             AND ND2.BILL_ITEM_TIMESTMP = ND1.BILL_ITEM_TIMESTMP         
MFA-TR*             AND ND2.VOL_TYPE_CD        = :WS-VM)                        
MFA-TR*      WITH UR                                                            
MFA-TR*       QUERYNO 7460                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA312 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7450       **'        
              DISPLAY '**      SQLCODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**      ACCT NO   = ' ND-ACCOUNT-NO              
              DISPLAY '**      BILL NO   = ' ND-BILL-NO                 
              DISPLAY '**      UTIL TYPE = ' ND-CODE-UTIL-TYPE          
              DISPLAY '**      IC NO     = ' ND-IC-NO                   
              DISPLAY '**      TIMESTAMP = ' ND-BILL-ITEM-TIMESTMP      
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
        7460-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7500-SELECT-TOTALDTS                                     **          
      **      SELECTS TOTAL DEKATHERMS FROM CSS_VOL_DAILY TABLE     **          
      ****************************************************************          
      *                                                                         
       7500-SELECT-TOTALDTS.                                            
      *                                                                         
           MOVE '7500'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
             SELECT SUM(NO_UNITS)                                       
               INTO :WS-TOTALDTS :WS-TOTALDTS-NULL-IND                   
               FROM CSS_VOL_DAILY WITH(READUNCOMMITTED)                         
              WHERE ACCOUNT_NO          = :ND-ACCOUNT-NO                
                AND BILL_NO             = :ND-BILL-NO                   
                AND CODE_UTIL_TYPE      = :WS-G                         
                AND IC_NO               = :ND-IC-NO                     
                AND BILL_ITEM_TIMESTMP  = CIS.CHAR2TIMESTAMP(
                                                 :ND-BILL-ITEM-TIMESTMP
              )        
                AND VOL_TYPE_CD         = :WS-VB                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT SUM(NO_UNITS)                                               
MFA-TR*        INTO :WS-TOTALDTS:WS-TOTALDTS-NULL-IND                           
MFA-TR*        FROM CSS_VOL_DAILY                                               
MFA-TR*       WHERE ACCOUNT_NO          = :ND-ACCOUNT-NO                        
MFA-TR*         AND BILL_NO             = :ND-BILL-NO                           
MFA-TR*         AND CODE_UTIL_TYPE      = :WS-G                                 
MFA-TR*         AND IC_NO               = :ND-IC-NO                             
MFA-TR*         AND BILL_ITEM_TIMESTMP  = :ND-BILL-ITEM-TIMESTMP                
MFA-TR*         AND VOL_TYPE_CD         = :WS-VB                                
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA312 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7500       **'        
              DISPLAY '**      SQLCODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**      ACCT NO   = ' ND-ACCOUNT-NO              
              DISPLAY '**      BILL NO   = ' ND-BILL-NO                 
              DISPLAY '**      UTIL TYPE = ' WS-G                       
              DISPLAY '**      IC NO     = ' ND-IC-NO                   
              DISPLAY '**      TIMESTAMP = ' ND-BILL-ITEM-TIMESTMP      
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
        7500-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7650-SELECT-PRICE-SCHED                                  **          
      **      SELECTS SCHEDULED PRICE FROM CSS_PRICE_SCHED TABLE    **          
      ****************************************************************          
      *                                                                         
       7650-SELECT-PRICE-SCHED.                                         
      *                                                                         
           MOVE '7650'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
             SELECT DISTINCT PS.SCHED_PRICE_AM                          
               INTO :PS-SCHED-PRICE-AM                                  
               FROM CSS_PRICE_SCHED PS WITH(READUNCOMMITTED)                    
              WHERE PS.CODE_UTIL_TYPE         = :WS-G                   
                AND PS.RATE_PLAN_NO           = :PS-RATE-PLAN-NO        
                AND PS.CMPNT_ID_CD            = :PS-CMPNT-ID-CD         
                AND (PS.CODE_SEASON           = :RS-CODE-SEASON         
                 OR PS.CODE_SEASON            = :WS-BOTH)               
                AND PS.CODE_USE_INST_TYPE     = :PS-CODE-USE-INST-TYPE  
                AND PS.BLOCK_NO               = :WS-BLOCK-NO            
                AND PS.VERSION_NO_CNTRL       =                         
                    (SELECT RT.VERSION_NO_CNTRL                         
                       FROM CSS_RATE_CREATOR RT WITH(READUNCOMMITTED)           
                      WHERE RT.RATE_PLAN_NO   = PS.RATE_PLAN_NO         
                        AND RT.CODE_UTIL_TYPE = :WS-G                   
                        AND RT.CODE_STATUS IN('A','F')                  
                        AND RT.VERSION_NO_CNTRL =                       
                       (SELECT MAX(RT1.VERSION_NO_CNTRL)                
                          FROM CSS_RATE_CREATOR RT1
                           WITH(READUNCOMMITTED)                     
                         WHERE RT1.RATE_PLAN_NO = RT.RATE_PLAN_NO       
                           AND RT1.CODE_UTIL_TYPE = RT.CODE_UTIL_TYPE   
                           AND RT1.CODE_STATUS IN ('A','F')             
                           AND RT1.FROM_EFFECTIVE_DT <= 
              IIF(TRY_CONVERT(DATE, :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) ) )) 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DISTINCT PS.SCHED_PRICE_AM                                  
MFA-TR*        INTO :PS-SCHED-PRICE-AM                                          
MFA-TR*        FROM CSS_PRICE_SCHED PS                                          
MFA-TR*       WHERE PS.CODE_UTIL_TYPE         = :WS-G                           
MFA-TR*         AND PS.RATE_PLAN_NO           = :PS-RATE-PLAN-NO                
MFA-TR*         AND PS.CMPNT_ID_CD            = :PS-CMPNT-ID-CD                 
MFA-TR*         AND (PS.CODE_SEASON           = :RS-CODE-SEASON                 
MFA-TR*          OR PS.CODE_SEASON            = :WS-BOTH)                       
MFA-TR*         AND PS.CODE_USE_INST_TYPE     = :PS-CODE-USE-INST-TYPE          
MFA-TR*         AND PS.BLOCK_NO               = :WS-BLOCK-NO                    
MFA-TR*         AND PS.VERSION_NO_CNTRL       =                                 
MFA-TR*             (SELECT RT.VERSION_NO_CNTRL                                 
MFA-TR*                FROM CSS_RATE_CREATOR RT                                 
MFA-TR*               WHERE RT.RATE_PLAN_NO   = PS.RATE_PLAN_NO                 
MFA-TR*                 AND RT.CODE_UTIL_TYPE = :WS-G                           
MFA-TR*                 AND RT.CODE_STATUS IN('A','F')                          
MFA-TR*                 AND RT.VERSION_NO_CNTRL =                               
MFA-TR*                (SELECT MAX(RT1.VERSION_NO_CNTRL)                        
MFA-TR*                   FROM CSS_RATE_CREATOR RT1                             
MFA-TR*                  WHERE RT1.RATE_PLAN_NO = RT.RATE_PLAN_NO               
MFA-TR*                    AND RT1.CODE_UTIL_TYPE = RT.CODE_UTIL_TYPE           
MFA-TR*                    AND RT1.CODE_STATUS IN ('A','F')                     
MFA-TR*                    AND RT1.FROM_EFFECTIVE_DT <= :WS-END-DATE ))         
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7650                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA312 PROCESSING ERROR      **'        
              DISPLAY '**     ABEND IN PARAGRAPH 7650        **'        
              DISPLAY '**     SQLCODE   = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**     UTIL TYPE = ' WS-G                        
              DISPLAY '**     RATE PLAN = ' PS-RATE-PLAN-NO             
              DISPLAY '**     CMPNT ID  = ' PS-CMPNT-ID-CD              
              DISPLAY '**     CODE SEASON=' RS-CODE-SEASON              
              DISPLAY '**     BLOCK NO  = ' WS-BLOCK-NO                 
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
        7650-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ***************************************************************           
      **                                                           **           
      **    7700-OPEN-FIXED-FCT-CURSOR.                            **           
      **         OPENS CURSOR ON CSS_FIXED_FCT_HIST TABLE          **           
      ***************************************************************           
      *                                                                         
       7700-OPEN-FIXED-FCT-CURSOR.                                      
                                                                        
           MOVE '7700'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                OPEN FIXED_FCT                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********************************************'    
              DISPLAY '**   PCSCA312 PROCESSING ERROR             *'    
              DISPLAY '**   ABEND IN PARAGRAPH 7700               *'    
              DISPLAY '**   SQLCODE   = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '**   ACCT NO   = ' BG-ACCOUNT-NO                 
              DISPLAY '**   UTIL TYPE = ' WS-G                          
              DISPLAY '**   IC NO     = ' BG-IC-NO                      
              DISPLAY '**   BILL NO   = ' BG-BILL-NO                    
              DISPLAY '**   TIMESTAMP = ' BG-BILL-ITEM-TIMESTMP         
              DISPLAY '********************************************'    
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **    7750-FETCH-FIXED-FCT-CURSOR.                           **           
      **         FETCH ROWS FROM CSS_FIXED_FCT_HIST TABLE          **           
      **                                                           **           
      ***************************************************************           
                                                                        
       7750-FETCH-FIXED-FCT-CURSOR.                                     
                                                                        
           MOVE '7750'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                FETCH FIXED_FCT INTO                                    
                   :FH-FACTOR,                                          
                   :FH-BILL-UNITS,                                      
                   :FH-EFF-DATE-FROM,                                   
                   :FH-EFF-DATE-TO,                                     
                   :FH-FCTR-POWER-10                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO  WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                    CONTINUE                                            
              WHEN NOT-FOUND                                            
                   SET END-OF-FACTOR       TO TRUE                      
              WHEN OTHER                                                
                 DISPLAY '****************************************'     
                 DISPLAY '**     PCSCA312 PROCESSING ERROR      **'     
                 DISPLAY '**      ABEND IN PARAGRAPH 7750       **'     
                 DISPLAY '**   SQLCODE   = ' WS-ACTIVE-RETURN-CODE      
                 DISPLAY '**   ACCT NO   = ' BG-ACCOUNT-NO              
                 DISPLAY '**   UTIL TYPE = ' WS-G                       
                 DISPLAY '**   IC NO     = ' BG-IC-NO                   
                 DISPLAY '**   BILL NO   = ' BG-BILL-NO                 
                 DISPLAY '**   TIMESTAMP = ' BG-BILL-ITEM-TIMESTMP      
                 DISPLAY '****************************************'     
                 PERFORM 9900-ABEND             THRU 9900-EXIT          
           END-EVALUATE.                                                
                                                                        
       7750-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **    7800-CLOSE-FIXED-FCT-CURSOR.                           **           
      **         CLOSES CURSOR ON CSS_FIXED_FCT_HIST TABLE         **           
      ***************************************************************           
                                                                        
       7800-CLOSE-FIXED-FCT-CURSOR.                                     
                                                                        
           MOVE '7800'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                CLOSE FIXED_FCT                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**   PCSCA312 PROCESSING ERROR        **'        
              DISPLAY '**   ABEND IN PARAGRAPH 7800          **'        
              DISPLAY '**   SQLCODE   = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '**   ACCT NO   = ' BG-ACCOUNT-NO                 
              DISPLAY '**   UTIL TYPE = ' WS-G                          
              DISPLAY '**   IC NO     = ' BG-IC-NO                      
              DISPLAY '**   BILL NO   = ' BG-BILL-NO                    
              DISPLAY '**   TIMESTAMP = ' BG-BILL-ITEM-TIMESTMP         
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ****************************************************************          
      **                                                            **          
      **   7850-SELECT-FACTOR-ID.                                   **          
      **      SELECTS FACTOR ID FROM CSS_SPCL_FCTR_APPL TABLE       **          
      ****************************************************************          
      *                                                                         
       7850-SELECT-FACTOR-ID.                                           
      *                                                                         
           MOVE '7850'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
             SELECT DISTINCT FACTOR_ID,                                 
                    DATE_FROM                                           
               INTO :SA-FACTOR-ID,                                      
                    :SA-DATE-FROM                                       
               FROM CSS_SPCL_FCTR_APPL WITH(READUNCOMMITTED)                    
              WHERE CODE_UTIL_TYPE = :WS-G                              
                AND RATE_PLAN_NO   = :BG-RATE-PLAN-NO                   
                AND FACTOR_ID      = 'TRANSCO'                          
                AND DATE_FROM      = IIF(TRY_CONVERT(DATE, 
                                                      :FH-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FH-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FH-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FH-EFF-DATE-FROM
              ), CONVERT(DATE, :FH-EFF-DATE-FROM) )                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DISTINCT FACTOR_ID,                                         
MFA-TR*             DATE_FROM                                                   
MFA-TR*        INTO :SA-FACTOR-ID,                                              
MFA-TR*             :SA-DATE-FROM                                               
MFA-TR*        FROM CSS_SPCL_FCTR_APPL                                          
MFA-TR*       WHERE CODE_UTIL_TYPE = :WS-G                                      
MFA-TR*         AND RATE_PLAN_NO   = :BG-RATE-PLAN-NO                           
MFA-TR*         AND FACTOR_ID      = 'TRANSCO'                                  
MFA-TR*         AND DATE_FROM      = :FH-EFF-DATE-FROM                          
MFA-TR*     WITH UR                                                             
MFA-TR*     QUERYNO 7850                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA312 PROCESSING ERROR      **'        
              DISPLAY '**     ABEND IN PARAGRAPH 7850       **'         
              DISPLAY '**     SQLCODE    = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**     UTIL TYPRE = ' WS-G                       
              DISPLAY '**     RATE PLAN #= ' BG-RATE-PLAN-NO            
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
        7850-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      **    7860-SELECT-FIXED-FCTR                                   **         
      *****************************************************************         
       7860-SELECT-FIXED-FCTR.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
             SUM(CIS.DECIMAL2DECIMAL3(FF.FACTOR * POWER(10.0,
           SF.FCTR_POWER_10),13,6))
               INTO  :WS-FCTR-FF :WS-NULL-FF-FACTOR                     
                FROM CSS_FIXED_FCTR FF WITH(READUNCOMMITTED),                   
                     CSS_SPCL_FCTR  SF WITH(READUNCOMMITTED)                    
               WHERE FF.ACCOUNT_NO        = :FF-ACCOUNT-NO              
                 AND FF.CODE_UTIL_TYPE    = :FF-CODE-UTIL-TYPE          
                 AND FF.IC_NO             = :FF-IC-NO                   
                 AND FF.FACTOR_ID         = SF.FACTOR_ID                
                 AND SF.ADJUST_ELEMENT    = 'C'                         
                 AND SF.CHECK_ELEMENT     = 'A'                         
                 AND SF.FACTOR_TYPE       = 'B'                         
                 AND SF.CODE_STATUS       = 'A'                         
                 AND FF.CMPNT_ID_CD       = '10'                        
                 AND FF.FIXED_FCTR_TYP_CD = 'SM'                        
                 AND EFF_DATE_FROM    <= IIF(TRY_CONVERT(DATE, 
                                                      :FF-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FF-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FF-EFF-DATE-FROM
              ), CONVERT(DATE, :FF-EFF-DATE-FROM) )              
                 AND (EFF_DATE_TO     IS NULL                           
                  OR EFF_DATE_TO      >= IIF(TRY_CONVERT(DATE, 
                                                        :FF-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FF-EFF-DATE-TO
              ), CONVERT(DATE, :FF-EFF-DATE-TO) ))               
                 AND INSTR_USE_TYPE_CD = 'R'                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*      SUM(DECIMAL(FF.FACTOR * POWER(10.0,SF.FCTR_POWER_10),13,6))        
MFA-TR*        INTO  :WS-FCTR-FF :WS-NULL-FF-FACTOR                             
MFA-TR*         FROM CSS_FIXED_FCTR FF,                                         
MFA-TR*              CSS_SPCL_FCTR  SF                                          
MFA-TR*        WHERE FF.ACCOUNT_NO        = :FF-ACCOUNT-NO                      
MFA-TR*          AND FF.CODE_UTIL_TYPE    = :FF-CODE-UTIL-TYPE                  
MFA-TR*          AND FF.IC_NO             = :FF-IC-NO                           
MFA-TR*          AND FF.FACTOR_ID         = SF.FACTOR_ID                        
MFA-TR*          AND SF.ADJUST_ELEMENT    = 'C'                                 
MFA-TR*          AND SF.CHECK_ELEMENT     = 'A'                                 
MFA-TR*          AND SF.FACTOR_TYPE       = 'B'                                 
MFA-TR*          AND SF.CODE_STATUS       = 'A'                                 
MFA-TR*          AND FF.CMPNT_ID_CD       = '10'                                
MFA-TR*          AND FF.FIXED_FCTR_TYP_CD = 'SM'                                
MFA-TR*          AND EFF_DATE_FROM    <= :FF-EFF-DATE-FROM                      
MFA-TR*          AND (EFF_DATE_TO     IS NULL                                   
MFA-TR*           OR EFF_DATE_TO      >= :FF-EFF-DATE-TO)                       
MFA-TR*          AND INSTR_USE_TYPE_CD = 'R'                                    
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7860                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR           
               WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
                  CONTINUE                                              
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA312 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7860       **'       
               DISPLAY '**      ACCOUNT_NO   = ' FF-ACCOUNT-NO          
               DISPLAY '**      CODE_UTIL_TYPE= ' FF-CODE-UTIL-TYPE     
               DISPLAY '**      IC_NO         = ' FF-IC-NO              
               DISPLAY '**      DATE_FROM     = ' FF-EFF-DATE-FROM      
               DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7860-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7900-CHECK-CODE-BILL-CALC.                               **          
      **      SELECTS CODE_BILL_CALC FROM CSS_BILLING_DET TABLE     **          
      ****************************************************************          
      *                                                                         
       7900-CHECK-CODE-BILL-CALC.                                       
      *                                                                         
           MOVE '7900'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
             SELECT CODE_BILL_CALC                                      
               INTO :WS-BILL-CODE                                       
               FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                       
              WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                 
                AND IC_NO              = :UT-IC-NO                      
                AND CODE_UTIL_TYPE     = :WS-G                          
                AND BILL_NO            = :BG-BILL-NO                    
                AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CODE_BILL_CALC                                              
MFA-TR*        INTO :WS-BILL-CODE                                               
MFA-TR*        FROM CSS_BILLING_DET                                             
MFA-TR*       WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                         
MFA-TR*         AND IC_NO              = :UT-IC-NO                              
MFA-TR*         AND CODE_UTIL_TYPE     = :WS-G                                  
MFA-TR*         AND BILL_NO            = :BG-BILL-NO                            
MFA-TR*         AND BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP                 
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7900                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA312 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7900       **'        
              DISPLAY '**      SQLCODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**      ACCT NO   = ' AT-ACCOUNT-NO              
              DISPLAY '**      IC NO     = ' UT-IC-NO                   
              DISPLAY '**      UTIL TYPE = ' WS-G                       
              DISPLAY '**      BILL NO   = ' BG-BILL-NO                 
              DISPLAY '**      TIMESTAMP = ' BG-BILL-ITEM-TIMESTMP      
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
        7900-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      **  7910-GET-SEASONAL-CODE.                                     **        
      **       MOVE CONSUMPTION HISTORY FIELDS TO PASSAREA            **        
      ******************************************************************        
       7910-GET-SEASONAL-CODE.                                          
      *                                                                         
           MOVE '7910'                     TO WS-ACTIVE-PARAGRAPH.      
      *                                                                         
           EXEC SQL                                                     
              SELECT CODE_SEASON                                        
                INTO :RS-CODE-SEASON                                    
                FROM CSS_RATE_USE_SEASN WITH(READUNCOMMITTED)                   
               WHERE CODE_UTIL_TYPE   = :RS-CODE-UTIL-TYPE              
                AND  RATE_PLAN_NO     = :RS-RATE-PLAN-NO                
                AND  VERSION_NO_CNTRL = (SELECT MAX(VERSION_NO_CNTRL)   
                          FROM CSS_RATE_USE_SEASN RS
                           WITH(READUNCOMMITTED)                    
                          WHERE RS.RATE_PLAN_NO  = :RS-RATE-PLAN-NO     
                          AND  RS.CODE_UTIL_TYPE = :RS-CODE-UTIL-TYPE)  
                AND CODE_USE_INST_TYPE = 'C'                            
                AND ((DATE_FROM        <= :RS-DATE-FROM                 
                      AND DATE_TO      >= :RS-DATE-FROM                 
                      AND DATE_FROM    <= DATE_TO)                      
                      OR  (DATE_FROM   >= :RS-DATE-FROM                 
                      AND DATE_TO      <= :RS-DATE-FROM                 
                      AND DATE_FROM    >= DATE_TO))                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_SEASON                                                
MFA-TR*         INTO :RS-CODE-SEASON                                            
MFA-TR*         FROM CSS_RATE_USE_SEASN                                         
MFA-TR*        WHERE CODE_UTIL_TYPE   = :RS-CODE-UTIL-TYPE                      
MFA-TR*         AND  RATE_PLAN_NO     = :RS-RATE-PLAN-NO                        
MFA-TR*         AND  VERSION_NO_CNTRL = (SELECT MAX(VERSION_NO_CNTRL)           
MFA-TR*                   FROM CSS_RATE_USE_SEASN RS                            
MFA-TR*                   WHERE RS.RATE_PLAN_NO  = :RS-RATE-PLAN-NO             
MFA-TR*                   AND  RS.CODE_UTIL_TYPE = :RS-CODE-UTIL-TYPE)          
MFA-TR*         AND CODE_USE_INST_TYPE = 'C'                                    
MFA-TR*         AND ((DATE_FROM        <= :RS-DATE-FROM                         
MFA-TR*               AND DATE_TO      >= :RS-DATE-FROM                         
MFA-TR*               AND DATE_FROM    <= DATE_TO)                              
MFA-TR*               OR  (DATE_FROM   >= :RS-DATE-FROM                         
MFA-TR*               AND DATE_TO      <= :RS-DATE-FROM                         
MFA-TR*               AND DATE_FROM    >= DATE_TO))                             
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7910                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
                                          OR NOT-FOUND                  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA312 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7910       **'        
              DISPLAY '**      SQLCODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**      CODE UTIL = ' RS-CODE-UTIL-TYPE          
              DISPLAY '**      RATE PLAN#= ' RS-RATE-PLAN-NO            
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *   7920-OPEN-MTRD-ENVRNMT.                                      *        
      *        OPENS CURSOR ON CSS_MTRD_ENVRNMT TABLE                  *        
      *                                                                *        
      ******************************************************************        
       7920-OPEN-MTRD-ENVRNMT.                                          
                                                                        
           MOVE '7920'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                OPEN MTRD_ENVRNMT                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL           
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA312 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7920       **'        
              DISPLAY '**      SQLCODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**      ACCT NO   = ' BG-ACCOUNT-NO              
              DISPLAY '**      UTIL TYPE = ' BG-CODE-UTIL-TYPE          
              DISPLAY '**      IC NO     = ' BG-IC-NO                   
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7920-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *   7930-FETCH-MTRD-ENVRNMT.                                     *        
      *        FETCHES FROM MTRD_ENVRNMT CURSOR                        *        
      *                                                                *        
      ******************************************************************        
       7930-FETCH-MTRD-ENVRNMT.                                         
                                                                        
           MOVE '7930'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                FETCH MTRD_ENVRNMT INTO                                 
                   :MN-ACCOUNT-NO,                                      
                   :MN-CODE-UTIL-TYPE,                                  
                   :MN-IC-NO,                                           
                   :MN-MTR-REF-NO,                                      
                   :MN-CODE-TIME-PERIOD,                                
                   :MN-METER-NO,                                        
                   :MN-CODE-DISCOUNT,                                   
                   :MN-CODE-METER-LOC,                                  
                   :MN-CODE-METER-STATUS,                               
                   :MN-CODE-STATUS-REAS,                                
                   :MN-CODE-ALRT-CHNG-IND,                              
                   :MN-DIST-NODE-POINT,                                 
                   :MN-CODE-DIVERSION,                                  
                   :MN-DATE-MTR-INSTALL :WS-NULL-DATE-MTR-INSTALL,      
                   :MN-CODE-SPCL-SEAL,                                  
                   :MN-EST-USAGE,                                       
                   :MN-SPCL-MTR-CONDITION,                              
                   :MN-CODE-DATA-PRESENT,                               
                   :MN-CODE-USAGE-TYPE,                                 
                   :MN-CODE-USAGE-ID,                                   
                   :MN-CODE-USAGE-SOURCE,                               
                   :MN-REG-ID-NO,                                       
                   :MN-REGISTER-RD-SEQ,                                 
                   :MN-CODE-CRNT-REG-READ,                              
                   :MN-CODE-NO-RD-REASON,                               
                   :MN-CODE-LAST-REG-READ,                              
                   :MN-LAST-REG-READ-TIME :WS-NULL-LAST-REG-READ-TIME,  
                   :MN-LAST-REG-READ-DATE :WS-NULL-LAST-REG-READ-DATE,  
                   :MN-LAST-READ-VALUE,                                 
                   :MN-NO-CONSEC-CRD-READ,                              
                   :MN-NO-CONSEC-ESTIMATE,                              
                   :MN-POINT-ID,                                        
                   :MN-LOCK-TYPE-ID,                                    
                   :MN-SEAL-CODE-ID,                                    
                   :MN-HEXAGRAM-LOCATION,                               
                   :MN-INSULATED-IND,                                   
                   :MN-METER-SUPPLYING,                                 
                   :MN-LAST-VALID-READ-TM :WS-NULL-LAST-VALID-READ-TM,  
                   :MN-LAST-VALID-READ-DT :WS-NULL-LAST-VALID-READ-DT,  
                   :MN-READ-CARD-PRINT-DT :WS-NULL-READ-CARD-PRINT-DT,  
                   :MN-EXCEPT-OVERRIDE-CD,                              
                   :MN-CODE-MTR-RD-INST1,                               
                   :MN-CODE-MTR-RD-INST2,                               
                   :MN-CODE-MTR-RD-INST3,                               
                   :MN-DIGTL-MTR-TYPE,                                  
                   :MN-LAST-UPDATE-TS :WS-NULL-LAST-UPDATE-TS,          
                   :MN-LAST-VAL-RD-VALUE,                               
                   :MN-CODE-LAST-VALID-RD,                              
                   :MN-REMOTE-READ-IND,                                 
                   :MN-MTR-READ-SOURCE-CD,                              
                   :MN-UTILITY-SOURCE-CD,                               
                   :MN-DELIVERY-LEVEL-CD,                               
                   :MN-MTR-STATUS-CHNG-DT :WS-NULL-MTR-STATUS-CHNG-DT   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL  TO SUCCESSFUL-CALL           
                                               OR NOT-FOUND             
               IF WS-NULL-DATE-MTR-INSTALL < ZERO                       
                   MOVE LOW-VALUES         TO MN-DATE-MTR-INSTALL       
               END-IF                                                   
               IF WS-NULL-LAST-REG-READ-TIME < ZERO                     
                   MOVE LOW-VALUES         TO MN-LAST-REG-READ-TIME     
               END-IF                                                   
               IF WS-NULL-LAST-REG-READ-DATE < ZERO                     
                   MOVE LOW-VALUES         TO MN-LAST-REG-READ-DATE     
               END-IF                                                   
               IF WS-NULL-LAST-VALID-READ-TM < ZERO                     
                   MOVE LOW-VALUES         TO MN-LAST-VALID-READ-TM     
               END-IF                                                   
               IF WS-NULL-LAST-VALID-READ-DT < ZERO                     
                   MOVE LOW-VALUES         TO MN-LAST-VALID-READ-DT     
               END-IF                                                   
               IF WS-NULL-READ-CARD-PRINT-DT < ZERO                     
                   MOVE LOW-VALUES         TO MN-READ-CARD-PRINT-DT     
               END-IF                                                   
               IF WS-NULL-LAST-UPDATE-TS < ZERO                         
                   MOVE LOW-VALUES         TO MN-LAST-UPDATE-TS         
               END-IF                                                   
               IF WS-NULL-MTR-STATUS-CHNG-DT < ZERO                     
                   MOVE LOW-VALUES         TO MN-MTR-STATUS-CHNG-DT     
               END-IF                                                   
           ELSE                                                         
                DISPLAY '****************************************'      
                DISPLAY '**     PCSCA312 PROCESSING ERROR      **'      
                DISPLAY '**      ABEND IN PARAGRAPH 7930       **'      
                DISPLAY '**      SQLCODE   = ' WS-ACTIVE-RETURN-CODE    
                DISPLAY '**      ACCT NO   = ' BG-ACCOUNT-NO            
                DISPLAY '**      UTIL TYPE = ' BG-CODE-UTIL-TYPE        
                DISPLAY '**      IC NO     = ' BG-IC-NO                 
                DISPLAY '****************************************'      
                PERFORM 9900-ABEND THRU 9900-EXIT                       
           END-IF                                                       
           .                                                            
       7930-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *   7940-CLOSE-MTRD-ENVRNMT.                                     *        
      *        CLOSES MTRD_ENVRNMT CURSOR                              *        
      *                                                                *        
      ******************************************************************        
       7940-CLOSE-MTRD-ENVRNMT.                                         
                                                                        
           MOVE '7940'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                CLOSE MTRD_ENVRNMT                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
           IF  WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL           
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA312 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7940       **'        
              DISPLAY '**      SQLCODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**      ACCT NO   = ' BG-ACCOUNT-NO              
              DISPLAY '**      UTIL TYPE = ' BG-CODE-UTIL-TYPE          
              DISPLAY '**      IC NO     = ' BG-IC-NO                   
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7940-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7950-OPEN-CNSMPTN-HIST                                         *        
      *      OPENS CURSOR ON CSS_CNSMPTN_HIST                          *        
      ******************************************************************        
       7950-OPEN-CNSMPTN-HIST.                                          
                                                                        
           MOVE '7950'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               OPEN CNS_HST_CRSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL           
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA312 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7950       **'        
              DISPLAY '**     SQLCODE    = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**     ACCOUNT NO = ' BG-ACCOUNT-NO              
              DISPLAY '**     BILL NO    = ' BG-BILL-NO                 
              DISPLAY '**     UTIL TYPE  = ' BG-CODE-UTIL-TYPE          
              DISPLAY '**     IC NO      = ' BG-IC-NO                   
              DISPLAY '**     TIMESTMP   = ' BG-BILL-ITEM-TIMESTMP      
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7950-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7960-FETCH-CNSMPTN-HIST.                                       *        
      *      FETCHES FROM CNSMPTN_HIST TABLE                           *        
      ******************************************************************        
       7960-FETCH-CNSMPTN-HIST.                                         
                                                                        
           MOVE '7960'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               FETCH CNS_HST_CRSR INTO                                  
                   :CX-ACCOUNT-NO                 ,                     
                   :CX-BILL-NO                    ,                     
                   :CX-CODE-UTIL-TYPE             ,                     
                   :CX-IC-NO                      ,                     
                   :CX-BILL-ITEM-TIMESTMP         ,                     
                   :CX-CODE-TIME-PERIOD           ,                     
                   :CX-MTR-REF-NO                 ,                     
                   :CX-CODE-USAGE-TYPE            ,                     
                   :CX-CODE-USAGE-ID              ,                     
                   :CX-CODE-USAGE-SOURCE          ,                     
                   :CX-ITEM-SEQ-NO                ,                     
                   :CX-METER-NO                   ,                     
                   :CX-REG-ID-NO                  ,                     
                   :CX-DATE-READ :WS-DATE-READ-NULL,                     
                   :CX-CODE-METER-READ            ,                     
                   :CX-CODE-METER-NO-READ         ,                     
                   :CX-METER-READING              ,                     
                   :CX-DEMAND-READING             ,                     
                   :CX-EMPLOYEE-NO                ,                     
                   :CX-NO-UNITS                   ,                     
                   :CX-NO-DEMAND-UNITS            ,                     
                   :CX-NO-DAYS                    ,                     
                   :CX-CODE-SOURCE-ID             ,                     
                   :CX-CODE-DEBIT-CREDIT          ,                     
                   :CX-CODE-ITEM-STATUS           ,                     
                   :CX-CODE-DISCOUNT              ,                     
                   :CX-CONSTANT                   ,                     
                   :CX-NO-DIALS                   ,                     
                   :CX-COMPANY-NO                 ,                     
                   :CX-EXCEPT-OVERRIDE-CD         ,                     
                   :CX-REQUESTED-USAGE            ,                     
                   :CX-DIGTL-INTRL-MTR-NO         ,                     
                   :CX-DIGTL-MTR-TYPE             ,                     
                   :CX-CODE-TOU-SEASN             ,                     
                   :CX-EXCL-DMD-RCHT-IND                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL   TO SUCCESSFUL-CALL         
                                             OR NOT-FOUND               
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA312 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7960       **'        
              DISPLAY '**     SQLCODE    = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**     ACCOUNT NO = ' BG-ACCOUNT-NO              
              DISPLAY '**     BILL NO    = ' BG-BILL-NO                 
              DISPLAY '**     UTIL TYPE  = ' BG-CODE-UTIL-TYPE          
              DISPLAY '**     IC NO      = ' BG-IC-NO                   
              DISPLAY '**     TIMESTMP   = ' BG-BILL-ITEM-TIMESTMP      
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF                                                       
           .                                                            
       7960-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7970-CLOSE-CNSMPTN-HIST.                                       *        
      *      CLOSES CURSOR ON CSS_CNSMPTN_HIST                         *        
      ******************************************************************        
       7970-CLOSE-CNSMPTN-HIST.                                         
                                                                        
           MOVE '7970'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                CLOSE CNS_HST_CRSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL           
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA312 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7970       **'        
              DISPLAY '**     SQLCODE    = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**     ACCOUNT NO = ' BG-ACCOUNT-NO              
              DISPLAY '**     BILL NO    = ' BG-BILL-NO                 
              DISPLAY '**     UTIL TYPE  = ' BG-CODE-UTIL-TYPE          
              DISPLAY '**     IC NO      = ' BG-IC-NO                   
              DISPLAY '**     TIMESTMP   = ' BG-BILL-ITEM-TIMESTMP      
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7970-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **     7980-GET-CUST-CHRG                                    **           
      **     GET CUSTOMER CHARGE FROM CSS_RATE_VRSN_DEF TABLE      **           
      ***************************************************************           
      *                                                                         
       7980-GET-CUST-CHRG.                                              
      *                                                                         
           MOVE '7980'                     TO WS-ACTIVE-PARAGRAPH       
      *                                                                         
           EXEC SQL                                                     
             SELECT AMT_CUST_CHRG                                       
               INTO :J4-AMT-CUST-CHRG                                   
               FROM CSS_RATE_VRSN_DEF J4 WITH(READUNCOMMITTED)                  
              WHERE J4.CODE_UTIL_TYPE         = :WS-G                   
                AND J4.RATE_PLAN_NO           = :J4-RATE-PLAN-NO        
                AND J4.VERSION_NO_CNTRL       =                         
                       (SELECT MAX(J41.VERSION_NO_CNTRL)                
                          FROM CSS_RATE_VRSN_DEF J41
                           WITH(READUNCOMMITTED)                    
                         WHERE J41.RATE_PLAN_NO = J4.RATE_PLAN_NO       
                           AND J41.CODE_UTIL_TYPE = J4.CODE_UTIL_TYPE)  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT AMT_CUST_CHRG                                               
MFA-TR*        INTO :J4-AMT-CUST-CHRG                                           
MFA-TR*        FROM CSS_RATE_VRSN_DEF J4                                        
MFA-TR*       WHERE J4.CODE_UTIL_TYPE         = :WS-G                           
MFA-TR*         AND J4.RATE_PLAN_NO           = :J4-RATE-PLAN-NO                
MFA-TR*         AND J4.VERSION_NO_CNTRL       =                                 
MFA-TR*                (SELECT MAX(J41.VERSION_NO_CNTRL)                        
MFA-TR*                   FROM CSS_RATE_VRSN_DEF J41                            
MFA-TR*                  WHERE J41.RATE_PLAN_NO = J4.RATE_PLAN_NO               
MFA-TR*                    AND J41.CODE_UTIL_TYPE = J4.CODE_UTIL_TYPE)          
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7980                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA312 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7980       **'        
              DISPLAY '**      SQLCODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**      UTIL TYPE = ' WS-G                       
              DISPLAY '**      RATE PLAN = ' J4-RATE-PLAN-NO            
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF                                                       
           .                                                            
       7980-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **     7985-DELETE-RPT312                                    **           
      **     DELETE DB2 TABLE BEFORE ANY INSERTS                   **           
      ***************************************************************           
      *                                                                         
       7985-DELETE-RPT312.                                              
      *                                                                         
           MOVE '7985'                     TO WS-ACTIVE-PARAGRAPH       
      *                                                                         
           EXEC SQL                                                     
           DELETE FROM CSS_RPT_PCSCA312                                 
             WHERE  SEQ_NO > 0                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA312 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7985       **'        
              DISPLAY '**      SQLCODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF                                                       
           .                                                            
       7985-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **                                                           **           
      **     7990-INSERT-RPT312                                    **           
      **     INSERT FILE INTO REPORT DATABASE.                     **           
      ***************************************************************           
      *                                                                         
       7990-INSERT-RPT312.                                              
      *                                                                         
           MOVE '7990'                    TO WS-ACTIVE-PARAGRAPH        
                                                                        
           IF E-FCA312-YRMO = 0                                         
              DISPLAY 'INVALID REVENUE MONTH FOR ACCOUNT '              
              E-FCA312-ACCOUNT-NO                                       
              GO TO 7990-EXIT                                           
           END-IF.                                                      
                                                                        
           ADD 1                          TO WS-SEQ-NO                  
           MOVE WS-SEQ-NO                 TO 4I-SEQ-NO                  
           MOVE E-FCA312-YRMO             TO 4I-REVENUE-MO              
           MOVE E-FCA312-ACCOUNT-NO       TO 4I-ACCOUNT-NO              
           MOVE E-FCA312-CUST-NAME        TO 4I-CUST-NAME-TEXT          
           MOVE LENGTH OF 4I-CUST-NAME-TEXT TO 4I-CUST-NAME-LEN         
           MOVE E-FCA312-CUST-ADDRESS     TO 4I-CUST-ADDR-TEXT          
           MOVE LENGTH OF 4I-CUST-ADDR-TEXT TO 4I-CUST-ADDR-LEN.        
           MOVE E-FCA312-CUST-ADDIT-ADDR TO 4I-CUST-ADDR-ADDL-TEXT      
           MOVE LENGTH OF 4I-CUST-ADDR-ADDL-TEXT TO                     
                4I-CUST-ADDR-ADDL-LEN.                                  
           MOVE E-FCA312-CITY-STATE-ZIP   TO 4I-CITY-STATE-ZIP-TEXT     
           MOVE LENGTH OF 4I-CITY-STATE-ZIP-TEXT TO                     
                4I-CITY-STATE-ZIP-LEN.                                  
           MOVE E-FCA312-BSID             TO 4I-BILL-STRUCTURE-ID       
           IF E-FCA312-BEG-DATE > ' '                                   
             MOVE E-FCA312-BEG-DATE         TO 4I-SERVICE-BEGIN-DT      
           ELSE                                                         
             MOVE '2000-01-01'              TO 4I-SERVICE-BEGIN-DT      
           END-IF.                                                      
           MOVE E-FCA312-PRORATE          TO 4I-PRORATE-CD              
           MOVE E-FCA312-RATE             TO 4I-RATE-PLAN-NO            
           MOVE E-FCA312-CLASS            TO 4I-CODE-REVENUE-CLASS      
           MOVE E-FCA312-CDMDQ            TO 4I-CT-DMD-MAX-DLY-QTY      
           MOVE E-FCA312-ACTMDQ           TO 4I-ACTUAL-MAX-DLY-QTY      
           MOVE E-FCA312-BILLDEM          TO 4I-CUST-BILLING-DMND       
           MOVE E-FCA312-MDQDATE          TO 4I-PRV-MAX-DLY-QTY-DT      
           MOVE E-FCA312-TOTALDTS         TO 4I-CUST-TOTAL-DKTHM        
           MOVE E-FCA312-TRANSDTS         TO 4I-CUST-TRNSPRT-DKTHM      
           MOVE E-FCA312-COMPSDTS         TO 4I-CUST-COMPETE-DKTHM      
           MOVE E-FCA312-BASESDTS         TO 4I-CUST-BASE-RT-DKTHM      
           MOVE E-FCA312-TRANSDEM         TO 4I-CUST-TRNSPRT-DMND       
           MOVE E-FCA312-BDEMREV          TO 4I-BILL-DEMAND-REV         
           MOVE E-FCA312-TOTALREV         TO 4I-TOT-VOL-BLOCK-REV       
           MOVE E-FCA312-TRANSREV         TO 4I-TRNSPRT-REV             
           MOVE E-FCA312-COMPREV          TO 4I-CMPT-PRICE-PGM-REV      
           MOVE E-FCA312-BASEREV          TO 4I-BASE-RT-PRICE-REV       
           MOVE E-FCA312-OTHRREV          TO 4I-OTHER-REV               
           MOVE E-FCA312-STBYREV          TO 4I-STNDBY-DEMAND-REV       
           MOVE E-FCA312-TDEMREV          TO 4I-TRNSPRT-DEMAND-REV      
           MOVE E-FCA312-CATEGORY         TO 4I-SVC-CATEGORY-CD         
           MOVE E-FCA312-SICODE           TO 4I-CODE-SIC-NO             
           MOVE E-FCA312-BASECOST         TO 4I-BASE-RT-COST-DKTHM      
           MOVE E-FCA312-COMPCOST         TO 4I-CMPT-PR-COST-DKTHM      
           MOVE E-FCA312-TRANSCOST        TO 4I-TRNSPRT-COST-DKTHM      
           MOVE E-FCA312-EDTS             TO 4I-EMERGNCY-GAS-DKTHM      
           MOVE E-FCA312-EREV             TO 4I-EMERNGCY-GAS-REV        
           MOVE E-FCA312-ECOST            TO 4I-EMERGNCY-GAS-COST       
           MOVE E-FCA312-PDTS             TO 4I-PENALTY-DKTHM           
           MOVE E-FCA312-PREV             TO 4I-PENALTY-REV             
           MOVE E-FCA312-PCOST            TO 4I-PENALTY-COST-DKTHM      
           MOVE E-FCA312-MARKUP           TO 4I-INTRRPT-CUST-MKUP       
           MOVE E-FCA312-CUST-NO          TO 4I-CUST-FOLIO-NO           
      *                                                                         
           EXEC SQL                                                     
           INSERT INTO CSS_RPT_PCSCA312                                 
                  ( CREATED_TS                                          
                   ,SEQ_NO                                              
                   ,REVENUE_MO                                          
                   ,CUST_NAME                                           
                   ,ACCOUNT_NO                                          
                   ,CUST_ADDR                                           
                   ,CUST_ADDR_ADDL                                      
                   ,CITY_STATE_ZIP                                      
                   ,BILL_STRUCTURE_ID                                   
                   ,SERVICE_BEGIN_DT                                    
                   ,PRORATE_CD                                          
                   ,RATE_PLAN_NO                                        
                   ,CODE_REVENUE_CLASS                                  
                   ,CT_DMD_MAX_DLY_QTY                                  
                   ,ACTUAL_MAX_DLY_QTY                                  
                   ,CUST_BILLING_DMND                                   
                   ,PRV_MAX_DLY_QTY_DT                                  
                   ,CUST_TOTAL_DKTHM                                    
                   ,CUST_TRNSPRT_DKTHM                                  
                   ,CUST_COMPETE_DKTHM                                  
                   ,CUST_BASE_RT_DKTHM                                  
                   ,CUST_TRNSPRT_DMND                                   
                   ,BILL_DEMAND_REV                                     
                   ,TOT_VOL_BLOCK_REV                                   
                   ,TRNSPRT_REV                                         
                   ,CMPT_PRICE_PGM_REV                                  
                   ,BASE_RT_PRICE_REV                                   
                   ,OTHER_REV                                           
                   ,STNDBY_DEMAND_REV                                   
                   ,TRNSPRT_DEMAND_REV                                  
                   ,SVC_CATEGORY_CD                                     
                   ,CODE_SIC_NO                                         
                   ,BASE_RT_COST_DKTHM                                  
                   ,CMPT_PR_COST_DKTHM                                  
                   ,TRNSPRT_COST_DKTHM                                  
                   ,EMERGNCY_GAS_DKTHM                                  
                   ,EMERNGCY_GAS_REV                                    
                   ,EMERGNCY_GAS_COST                                   
                   ,PENALTY_DKTHM                                       
                   ,PENALTY_REV                                         
                   ,PENALTY_COST_DKTHM                                  
                   ,INTRRPT_CUST_MKUP                                   
                   ,CUST_FOLIO_NO                                       
                   ,LAST_UPDATE_TS   )                                  
           VALUES ( CIS.CURRENT$TIMESTAMP()                                   
                  ,:4I-SEQ-NO                                           
                  ,:4I-REVENUE-MO                                       
                  ,:4I-CUST-NAME                                        
                  ,:4I-ACCOUNT-NO                                       
                  ,:4I-CUST-ADDR                                        
                  ,:4I-CUST-ADDR-ADDL                                   
                  ,:4I-CITY-STATE-ZIP                                   
                  ,:4I-BILL-STRUCTURE-ID                                
                  ,IIF(TRY_CONVERT(DATE, :4I-SERVICE-BEGIN-DT
              ) IS NULL OR (PATINDEX('%.%', :4I-SERVICE-BEGIN-DT
              ) <> 0) OR (LEN(:4I-SERVICE-BEGIN-DT
              ) <> 10), CIS.CHAR2DATE(:4I-SERVICE-BEGIN-DT
              ), CONVERT(DATE, :4I-SERVICE-BEGIN-DT) )                         
                  ,:4I-PRORATE-CD                                       
                  ,:4I-RATE-PLAN-NO                                     
                  ,:4I-CODE-REVENUE-CLASS                               
                  ,:4I-CT-DMD-MAX-DLY-QTY                               
                  ,:4I-ACTUAL-MAX-DLY-QTY                               
                  ,:4I-CUST-BILLING-DMND                                
                  ,:4I-PRV-MAX-DLY-QTY-DT                               
                  ,:4I-CUST-TOTAL-DKTHM                                 
                  ,:4I-CUST-TRNSPRT-DKTHM                               
                  ,:4I-CUST-COMPETE-DKTHM                               
                  ,:4I-CUST-BASE-RT-DKTHM                               
                  ,:4I-CUST-TRNSPRT-DMND                                
                  ,:4I-BILL-DEMAND-REV                                  
                  ,:4I-TOT-VOL-BLOCK-REV                                
                  ,:4I-TRNSPRT-REV                                      
                  ,:4I-CMPT-PRICE-PGM-REV                               
                  ,:4I-BASE-RT-PRICE-REV                                
                  ,:4I-OTHER-REV                                        
                  ,:4I-STNDBY-DEMAND-REV                                
                  ,:4I-TRNSPRT-DEMAND-REV                               
                  ,:4I-SVC-CATEGORY-CD                                  
                  ,:4I-CODE-SIC-NO                                      
                  ,:4I-BASE-RT-COST-DKTHM                               
                  ,:4I-CMPT-PR-COST-DKTHM                               
                  ,:4I-TRNSPRT-COST-DKTHM                               
                  ,:4I-EMERGNCY-GAS-DKTHM                               
                  ,:4I-EMERNGCY-GAS-REV                                 
                  ,:4I-EMERGNCY-GAS-COST                                
                  ,:4I-PENALTY-DKTHM                                    
                  ,:4I-PENALTY-REV                                      
                  ,:4I-PENALTY-COST-DKTHM                               
                  ,:4I-INTRRPT-CUST-MKUP                                
                  ,:4I-CUST-FOLIO-NO                                    
                  , CIS.CURRENT$TIMESTAMP()     )                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*    INSERT INTO CSS_RPT_PCSCA312                                         
MFA-TR*           ( CREATED_TS                                                  
MFA-TR*            ,SEQ_NO                                                      
MFA-TR*            ,REVENUE_MO                                                  
MFA-TR*            ,CUST_NAME                                                   
MFA-TR*            ,ACCOUNT_NO                                                  
MFA-TR*            ,CUST_ADDR                                                   
MFA-TR*            ,CUST_ADDR_ADDL                                              
MFA-TR*            ,CITY_STATE_ZIP                                              
MFA-TR*            ,BILL_STRUCTURE_ID                                           
MFA-TR*            ,SERVICE_BEGIN_DT                                            
MFA-TR*            ,PRORATE_CD                                                  
MFA-TR*            ,RATE_PLAN_NO                                                
MFA-TR*            ,CODE_REVENUE_CLASS                                          
MFA-TR*            ,CT_DMD_MAX_DLY_QTY                                          
MFA-TR*            ,ACTUAL_MAX_DLY_QTY                                          
MFA-TR*            ,CUST_BILLING_DMND                                           
MFA-TR*            ,PRV_MAX_DLY_QTY_DT                                          
MFA-TR*            ,CUST_TOTAL_DKTHM                                            
MFA-TR*            ,CUST_TRNSPRT_DKTHM                                          
MFA-TR*            ,CUST_COMPETE_DKTHM                                          
MFA-TR*            ,CUST_BASE_RT_DKTHM                                          
MFA-TR*            ,CUST_TRNSPRT_DMND                                           
MFA-TR*            ,BILL_DEMAND_REV                                             
MFA-TR*            ,TOT_VOL_BLOCK_REV                                           
MFA-TR*            ,TRNSPRT_REV                                                 
MFA-TR*            ,CMPT_PRICE_PGM_REV                                          
MFA-TR*            ,BASE_RT_PRICE_REV                                           
MFA-TR*            ,OTHER_REV                                                   
MFA-TR*            ,STNDBY_DEMAND_REV                                           
MFA-TR*            ,TRNSPRT_DEMAND_REV                                          
MFA-TR*            ,SVC_CATEGORY_CD                                             
MFA-TR*            ,CODE_SIC_NO                                                 
MFA-TR*            ,BASE_RT_COST_DKTHM                                          
MFA-TR*            ,CMPT_PR_COST_DKTHM                                          
MFA-TR*            ,TRNSPRT_COST_DKTHM                                          
MFA-TR*            ,EMERGNCY_GAS_DKTHM                                          
MFA-TR*            ,EMERNGCY_GAS_REV                                            
MFA-TR*            ,EMERGNCY_GAS_COST                                           
MFA-TR*            ,PENALTY_DKTHM                                               
MFA-TR*            ,PENALTY_REV                                                 
MFA-TR*            ,PENALTY_COST_DKTHM                                          
MFA-TR*            ,INTRRPT_CUST_MKUP                                           
MFA-TR*            ,CUST_FOLIO_NO                                               
MFA-TR*            ,LAST_UPDATE_TS   )                                          
MFA-TR*    VALUES ( CURRENT TIMESTAMP                                           
MFA-TR*           ,:4I-SEQ-NO                                                   
MFA-TR*           ,:4I-REVENUE-MO                                               
MFA-TR*           ,:4I-CUST-NAME                                                
MFA-TR*           ,:4I-ACCOUNT-NO                                               
MFA-TR*           ,:4I-CUST-ADDR                                                
MFA-TR*           ,:4I-CUST-ADDR-ADDL                                           
MFA-TR*           ,:4I-CITY-STATE-ZIP                                           
MFA-TR*           ,:4I-BILL-STRUCTURE-ID                                        
MFA-TR*           ,:4I-SERVICE-BEGIN-DT                                         
MFA-TR*           ,:4I-PRORATE-CD                                               
MFA-TR*           ,:4I-RATE-PLAN-NO                                             
MFA-TR*           ,:4I-CODE-REVENUE-CLASS                                       
MFA-TR*           ,:4I-CT-DMD-MAX-DLY-QTY                                       
MFA-TR*           ,:4I-ACTUAL-MAX-DLY-QTY                                       
MFA-TR*           ,:4I-CUST-BILLING-DMND                                        
MFA-TR*           ,:4I-PRV-MAX-DLY-QTY-DT                                       
MFA-TR*           ,:4I-CUST-TOTAL-DKTHM                                         
MFA-TR*           ,:4I-CUST-TRNSPRT-DKTHM                                       
MFA-TR*           ,:4I-CUST-COMPETE-DKTHM                                       
MFA-TR*           ,:4I-CUST-BASE-RT-DKTHM                                       
MFA-TR*           ,:4I-CUST-TRNSPRT-DMND                                        
MFA-TR*           ,:4I-BILL-DEMAND-REV                                          
MFA-TR*           ,:4I-TOT-VOL-BLOCK-REV                                        
MFA-TR*           ,:4I-TRNSPRT-REV                                              
MFA-TR*           ,:4I-CMPT-PRICE-PGM-REV                                       
MFA-TR*           ,:4I-BASE-RT-PRICE-REV                                        
MFA-TR*           ,:4I-OTHER-REV                                                
MFA-TR*           ,:4I-STNDBY-DEMAND-REV                                        
MFA-TR*           ,:4I-TRNSPRT-DEMAND-REV                                       
MFA-TR*           ,:4I-SVC-CATEGORY-CD                                          
MFA-TR*           ,:4I-CODE-SIC-NO                                              
MFA-TR*           ,:4I-BASE-RT-COST-DKTHM                                       
MFA-TR*           ,:4I-CMPT-PR-COST-DKTHM                                       
MFA-TR*           ,:4I-TRNSPRT-COST-DKTHM                                       
MFA-TR*           ,:4I-EMERGNCY-GAS-DKTHM                                       
MFA-TR*           ,:4I-EMERNGCY-GAS-REV                                         
MFA-TR*           ,:4I-EMERGNCY-GAS-COST                                        
MFA-TR*           ,:4I-PENALTY-DKTHM                                            
MFA-TR*           ,:4I-PENALTY-REV                                              
MFA-TR*           ,:4I-PENALTY-COST-DKTHM                                       
MFA-TR*           ,:4I-INTRRPT-CUST-MKUP                                        
MFA-TR*           ,:4I-CUST-FOLIO-NO                                            
MFA-TR*           , CURRENT TIMESTAMP     )                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              INITIALIZE E-FCA312-NUMERICS                              
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA312 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7990       **'        
              DISPLAY '**      SQLCODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**      BEGIN DATE= ' 4I-SERVICE-BEGIN-DT        
              DISPLAY '**      SEQ NO    = ' 4I-SEQ-NO                  
              DISPLAY '****************************************'        
              GO TO 7990-EXIT                                           
      *       PERFORM 9900-ABEND THRU 9900-EXIT                                 
           END-IF                                                       
           .                                                            
       7990-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 8300-LOAD-BILLING-DETAILS.                                    *         
      * MOVE BILLING DETAIL FIELDS TO PASSAREA                        *         
      *****************************************************************         
                                                                        
       8300-LOAD-BILLING-DETAILS.                                       
                                                                        
           MOVE '8300'                         TO WS-ACTIVE-PARAGRAPH.  
                                                                        
           MOVE BG-ACCOUNT-NO                  TO                       
                                        WS-BC-ACCOUNT-NO-BG             
           MOVE BG-BILL-NO                     TO                       
                                        WS-BC-BILL-NO-BG                
           MOVE BG-CODE-UTIL-TYPE              TO                       
                                        WS-BC-CODE-UTIL-TYPE-BG         
           MOVE BG-IC-NO                       TO                       
                                        WS-BC-IC-NO-BG                  
           MOVE BG-BILL-ITEM-TIMESTMP          TO                       
                                        WS-BC-BILL-ITEM-TIMESTMP-BG     
           MOVE BG-PREMISE-NO                  TO                       
                                        WS-BC-PREMISE-NO-BG             
           MOVE BG-DATE-ORIG-BILL              TO                       
                                        WS-BC-DATE-ORIG-BILL-BG         
           MOVE BG-AMT-BILL-ITEM               TO                       
                                        WS-BC-AMT-BILL-ITEM-BG          
           MOVE BG-CODE-BILL-CALC              TO                       
                                        WS-BC-CODE-BILL-CALC-BG         
           MOVE BG-CODE-BILL-ITM-TYPE          TO                       
                                        WS-BC-CODE-BILL-ITM-TYPE-BG     
           MOVE BG-CODE-BILL-ITM-IND           TO                       
                                        WS-BC-CODE-BILL-ITM-IND-BG      
           MOVE BG-CODE-DR-CR-CNSMPTN          TO                       
                                        WS-BC-CODE-DR-CR-CNSMPTN-BG     
           MOVE BG-AMT-STATE-TAX               TO                       
                                        WS-BC-AMT-STATE-TAX-BG          
           MOVE BG-AMT-CITY-TAX                TO                       
                                        WS-BC-AMT-CITY-TAX-BG.          
           MOVE BG-AMT-OTHER-TAX               TO                       
                                        WS-BC-AMT-OTHER-TAX-BG.         
           MOVE BG-CODE-REVENUE-CLASS          TO                       
                                        WS-BC-CODE-REVENUE-CLASS-BG     
           MOVE BG-CODE-SIC-NO                 TO                       
                                        WS-BC-CODE-SIC-NO-BG            
           MOVE BG-RATE-PLAN-NO                TO                       
                                        WS-BC-RATE-PLAN-NO-BG           
      *** IF ACCOUNT BILLED ON NEGOTIATED RATE PLAN, REPLACE WITH BASE          
      *** RATE PLAN TO DISPLAY ALL BILLED RATES INFORMATION.                    
           IF BG-RATE-PLAN-NO = '160'                                   
              MOVE UT-RATE-PLAN-NO              TO                      
                                        WS-BC-RATE-PLAN-NO-BG           
           END-IF                                                       
           MOVE BG-CODE-CURTAIL-PRTY           TO                       
                                        WS-BC-CODE-CURTAIL-PRTY-BG      
           MOVE BG-CODE-STAT-TAX-XMT           TO                       
                                        WS-BC-CODE-STAT-TAX-XMT-BG      
           MOVE BG-CODE-CITY-TAX-XMT           TO                       
                                        WS-BC-CODE-CITY-TAX-XMT-BG      
           MOVE BG-CODE-OTHR-TAX-XMT           TO                       
                                        WS-BC-CODE-OTHR-TAX-XMT-BG      
           MOVE BG-REV-RPT-CD                  TO                       
                                        WS-BC-REV-RPT-CD-BG             
           MOVE BG-STANDBY-COMPLIED            TO                       
                                        WS-BC-STANDBY-COMPLIED-BG       
           MOVE BG-PRORATE-CD                  TO                       
                                        WS-BC-PRORATE-CD-BG             
           MOVE BG-NEW-RATE-PCT                TO                       
                                        WS-BC-NEW-RATE-PCT-BG.          
           MOVE BG-CODE-SUB-TOTAL              TO                       
                                        WS-BC-CODE-SUB-TOTAL-BG.        
           MOVE BG-TAX-REFUND-CD               TO                       
                                        WS-BC-TAX-REFUND-CD-BG.         
           MOVE BG-COMPANY-NO                  TO                       
                                        WS-BC-COMPANY-NO-BG.            
           MOVE BG-DATE-LFTM-HI-DMD            TO                       
                                        WS-BC-DATE-LFTM-HI-DMD-BG       
           MOVE BG-LFTM-HI-PEAK-DMD            TO                       
                                        WS-BC-LFTM-HI-PEAK-DMD-BG       
           MOVE BG-REBILL-IND                  TO                       
                                        WS-BC-REBILL-IND-BG             
           MOVE BG-REVENUE-MONTH               TO                       
                                        WS-BC-REVENUE-MONTH-BG          
           MOVE BG-GAS-BASE-USE                TO                       
                                        WS-BC-GAS-BASE-USE-BG           
           MOVE BG-ADJ-REASON-CD               TO                       
                                        WS-BC-ADJ-REASON-CD-BG          
           MOVE BG-WNA-FACTOR                  TO                       
                                        WS-BC-WNA-FACTOR-BG             
           MOVE BG-BTU-FACTOR                  TO                       
                                        WS-BC-BTU-FACTOR-BG             
           MOVE BG-REV-MTH-ORIG-BILL           TO                       
                                        WS-BC-REV-MTH-ORIG-BILL-BG      
                                                                        
           MOVE UT-CODE-MTR-READ-FREQ TO WS-BC-CODE-MTR-READ-FREQ-BG    
                                                                        
           .                                                            
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8350-LOAD-MTR-ENVRNMT.                                        *         
      *      MOVE MTRD ENVRMNT FIELDS TO PASSAREA                     *         
      *****************************************************************         
                                                                        
       8350-LOAD-MTR-ENVRNMT.                                           
                                                                        
           MOVE  AT-ACCOUNT-NO             TO                           
                 WS-ACCOUNT-NO-MN (WS-MTRD-INDX).                       
           MOVE  BG-CODE-UTIL-TYPE         TO                           
                 WS-CODE-UTIL-TYPE-MN (WS-MTRD-INDX).                   
           MOVE  UT-IC-NO                  TO                           
                 WS-IC-NO-MN (WS-MTRD-INDX).                            
           MOVE  MN-MTR-REF-NO             TO                           
                 WS-MTR-REF-NO-MN (WS-MTRD-INDX).                       
           MOVE  MN-CODE-TIME-PERIOD       TO                           
                 WS-CODE-TIME-PERIOD-MN(WS-MTRD-INDX).                  
           MOVE  MN-METER-NO               TO                           
                 WS-METER-NO-MN (WS-MTRD-INDX).                         
           MOVE  MN-CODE-DISCOUNT          TO                           
                 WS-CODE-DISCOUNT-MN (WS-MTRD-INDX).                    
           MOVE  MN-CODE-METER-LOC         TO                           
                 WS-CODE-METER-LOC-MN(WS-MTRD-INDX).                    
           MOVE  MN-CODE-METER-STATUS      TO                           
                 WS-CODE-METER-STATUS-MN(WS-MTRD-INDX).                 
           MOVE  MN-CODE-STATUS-REAS       TO                           
                 WS-CODE-STATUS-REAS-MN(WS-MTRD-INDX).                  
           MOVE  MN-CODE-ALRT-CHNG-IND     TO                           
                 WS-CODE-ALRT-CHNG-IND-MN(WS-MTRD-INDX).                
           MOVE  MN-DIST-NODE-POINT        TO                           
                 WS-DIST-NODE-POINT-MN (WS-MTRD-INDX).                  
           MOVE  MN-CODE-DIVERSION         TO                           
                 WS-CODE-DIVERSION-MN(WS-MTRD-INDX).                    
           MOVE  MN-DATE-MTR-INSTALL       TO                           
                 WS-DATE-MTR-INSTALL-MN(WS-MTRD-INDX).                  
           MOVE  MN-CODE-SPCL-SEAL         TO                           
                 WS-CODE-SPCL-SEAL-MN(WS-MTRD-INDX).                    
           MOVE  MN-EST-USAGE              TO                           
                 WS-EST-USAGE-MN(WS-MTRD-INDX).                         
           MOVE  MN-SPCL-MTR-CONDITION     TO                           
                 WS-SPCL-MTR-CONDITION-MN(WS-MTRD-INDX).                
           MOVE  MN-CODE-DATA-PRESENT      TO                           
                 WS-CODE-DATA-PRESENT-MN(WS-MTRD-INDX).                 
           MOVE  MN-CODE-USAGE-TYPE        TO                           
                 WS-CODE-USAGE-TYPE-MN(WS-MTRD-INDX).                   
           MOVE  MN-CODE-USAGE-ID          TO                           
                 WS-CODE-USAGE-ID-MN(WS-MTRD-INDX).                     
           MOVE  MN-CODE-USAGE-SOURCE      TO                           
                 WS-CODE-USAGE-SOURCE-MN(WS-MTRD-INDX).                 
           MOVE  MN-REG-ID-NO              TO                           
                 WS-REG-ID-NO-MN(WS-MTRD-INDX).                         
           MOVE  MN-REGISTER-RD-SEQ        TO                           
                 WS-REGISTER-RD-SEQ-MN(WS-MTRD-INDX).                   
           MOVE  MN-CODE-CRNT-REG-READ     TO                           
                 WS-CODE-CRNT-REG-READ-MN(WS-MTRD-INDX).                
           MOVE  MN-CODE-NO-RD-REASON      TO                           
                 WS-CODE-NO-RD-REASON-MN(WS-MTRD-INDX).                 
           MOVE  MN-CODE-LAST-REG-READ     TO                           
                 WS-CODE-LAST-REG-READ-MN(WS-MTRD-INDX).                
           MOVE  MN-LAST-REG-READ-TIME     TO                           
                 WS-LAST-REG-READ-TIME-MN(WS-MTRD-INDX).                
           MOVE  MN-LAST-REG-READ-DATE     TO                           
                 WS-LAST-REG-READ-DATE-MN(WS-MTRD-INDX).                
           MOVE  MN-LAST-READ-VALUE        TO                           
                 WS-LAST-READ-VALUE-MN(WS-MTRD-INDX).                   
           MOVE  MN-NO-CONSEC-CRD-READ     TO                           
                 WS-NO-CONSEC-CRD-READ-MN(WS-MTRD-INDX).                
           MOVE  MN-NO-CONSEC-ESTIMATE     TO                           
                 WS-NO-CONSEC-ESTIMATE-MN (WS-MTRD-INDX).               
           MOVE  MN-POINT-ID               TO                           
                 WS-POINT-ID-MN (WS-MTRD-INDX).                         
           MOVE  MN-LOCK-TYPE-ID           TO                           
                 WS-LOCK-TYPE-ID-MN (WS-MTRD-INDX).                     
           MOVE  MN-SEAL-CODE-ID           TO                           
                 WS-SEAL-CODE-ID-MN (WS-MTRD-INDX).                     
           MOVE  MN-HEXAGRAM-LOCATION      TO                           
                 WS-HEXAGRAM-LOCATION-MN (WS-MTRD-INDX).                
           MOVE  MN-INSULATED-IND          TO                           
                 WS-INSULATED-IND-MN (WS-MTRD-INDX).                    
           MOVE  MN-METER-SUPPLYING        TO                           
                 WS-METER-SUPPLYING-MN (WS-MTRD-INDX).                  
           MOVE  MN-LAST-VALID-READ-TM     TO                           
                 WS-LAST-VALID-READ-TM-MN (WS-MTRD-INDX).               
           MOVE  MN-LAST-VALID-READ-DT     TO                           
                 WS-LAST-VALID-READ-DT-MN (WS-MTRD-INDX).               
           MOVE  MN-READ-CARD-PRINT-DT     TO                           
                 WS-READ-CARD-PRINT-DT-MN (WS-MTRD-INDX).               
           MOVE  MN-EXCEPT-OVERRIDE-CD     TO                           
                 WS-EXCEPT-OVERRIDE-CD-MN (WS-MTRD-INDX).               
           MOVE  MN-CODE-MTR-RD-INST1      TO                           
                 WS-CODE-MTR-RD-INST1-MN (WS-MTRD-INDX).                
           MOVE  MN-CODE-MTR-RD-INST2      TO                           
                 WS-CODE-MTR-RD-INST2-MN (WS-MTRD-INDX).                
           MOVE  MN-CODE-MTR-RD-INST3      TO                           
                 WS-CODE-MTR-RD-INST3-MN (WS-MTRD-INDX).                
           MOVE  MN-DIGTL-MTR-TYPE         TO                           
                 WS-DIGTL-MTR-TYPE-MN (WS-MTRD-INDX).                   
           MOVE  MN-LAST-VAL-RD-VALUE      TO                           
                 WS-LAST-VAL-RD-VALUE-MN (WS-MTRD-INDX).                
           MOVE  MN-CODE-LAST-VALID-RD     TO                           
                 WS-CODE-LAST-VALID-RD-MN (WS-MTRD-INDX).               
           MOVE  MN-LAST-UPDATE-TS         TO                           
                 WS-LAST-UPDATE-TS-MN (WS-MTRD-INDX).                   
           MOVE  MN-REMOTE-READ-IND        TO                           
                 WS-REMOTE-READ-IND-MN (WS-MTRD-INDX).                  
           MOVE  MN-MTR-READ-SOURCE-CD     TO                           
                 WS-MTR-READ-SOURCE-CD-MN (WS-MTRD-INDX).               
           MOVE  MN-UTILITY-SOURCE-CD      TO                           
                 WS-UTILITY-SOURCE-CD-MN (WS-MTRD-INDX)                 
           MOVE  MN-DELIVERY-LEVEL-CD      TO                           
                 WS-DELIVERY-LEVEL-CD-MN (WS-MTRD-INDX)                 
           MOVE  MN-MTR-STATUS-CHNG-DT     TO                           
                 WS-MTR-STATUS-CHNG-DT-MN (WS-MTRD-INDX)                
                                                                        
           SET WS-MTRD-INDX UP BY 1.                                    
           PERFORM 7930-FETCH-MTRD-ENVRNMT THRU  7930-EXIT.             
                                                                        
                                                                        
       8350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  8400-LOAD-MTRD-CNSMPTN.                                     **        
      **       MOVE CONSUMPTION HISTORY FIELDS TO PASSAREA            **        
      ******************************************************************        
       8400-LOAD-MTRD-CNSMPTN.                                          
                                                                        
           MOVE CX-ACCOUNT-NO              TO                           
                WS-BC-ACCOUNT-NO-CX (CX-INDX).                          
           MOVE CX-BILL-NO                 TO                           
                WS-BC-BILL-NO-CX (CX-INDX).                             
           MOVE CX-CODE-UTIL-TYPE          TO                           
                WS-BC-CODE-UTIL-TYPE-CX (CX-INDX).                      
           MOVE CX-IC-NO                   TO                           
                WS-BC-IC-NO-CX (CX-INDX).                               
           MOVE CX-BILL-ITEM-TIMESTMP      TO                           
                WS-BC-BILL-ITEM-TIMESTMP-CX (CX-INDX).                  
           MOVE CX-MTR-REF-NO              TO                           
                WS-BC-MTR-REF-NO-CX (CX-INDX).                          
           MOVE CX-CODE-USAGE-TYPE         TO                           
                WS-BC-CODE-USAGE-TYPE-CX (CX-INDX).                     
           MOVE CX-CODE-USAGE-ID           TO                           
                WS-BC-CODE-USAGE-ID-CX (CX-INDX).                       
           MOVE CX-CODE-USAGE-SOURCE       TO                           
                WS-BC-CODE-USAGE-SOURCE-CX (CX-INDX).                   
           MOVE CX-CODE-TIME-PERIOD        TO                           
                WS-BC-CODE-TIME-PERIOD-CX (CX-INDX).                    
           MOVE CX-ITEM-SEQ-NO             TO                           
                WS-BC-ITEM-SEQ-NO-CX (CX-INDX).                         
           MOVE CX-METER-NO                TO                           
                WS-BC-METER-NO-CX (CX-INDX).                            
           MOVE CX-REG-ID-NO               TO                           
                WS-BC-REG-ID-NO-CX (CX-INDX).                           
           MOVE CX-DATE-READ               TO                           
                WS-BC-DATE-READ-CX (CX-INDX).                           
           MOVE CX-CODE-METER-READ         TO                           
                WS-BC-CODE-METER-READ-CX (CX-INDX).                     
           MOVE CX-CODE-METER-NO-READ      TO                           
                WS-BC-CODE-METER-NO-READ-CX (CX-INDX).                  
           MOVE CX-METER-READING           TO                           
                WS-BC-METER-READING-CX (CX-INDX).                       
           MOVE CX-DEMAND-READING          TO                           
                WS-BC-DEMAND-READING-CX (CX-INDX).                      
           MOVE CX-EMPLOYEE-NO             TO                           
                WS-BC-EMPLOYEE-NO-CX (CX-INDX).                         
           MOVE CX-NO-UNITS                TO                           
                WS-BC-NO-UNITS-CX (CX-INDX).                            
           MOVE CX-NO-DEMAND-UNITS         TO                           
                WS-BC-NO-DEMAND-UNITS-CX (CX-INDX).                     
           MOVE CX-NO-DAYS                 TO                           
                WS-BC-NO-DAYS-CX (CX-INDX).                             
           MOVE CX-CODE-SOURCE-ID          TO                           
                WS-BC-CODE-SOURCE-ID-CX (CX-INDX).                      
           MOVE CX-CODE-DEBIT-CREDIT       TO                           
                WS-BC-CODE-DEBIT-CREDIT-CX (CX-INDX).                   
           MOVE CX-CODE-ITEM-STATUS        TO                           
                WS-BC-CODE-ITEM-STATUS-CX (CX-INDX).                    
           MOVE CX-CODE-DISCOUNT           TO                           
                WS-BC-CODE-DISCOUNT-CX (CX-INDX).                       
           MOVE CX-CONSTANT                TO                           
                WS-BC-CONSTANT-CX (CX-INDX).                            
           MOVE CX-NO-DIALS                TO                           
                WS-BC-NO-DIALS-CX (CX-INDX).                            
           MOVE CX-COMPANY-NO              TO                           
                WS-BC-COMPANY-NO-CX (CX-INDX).                          
           MOVE CX-EXCEPT-OVERRIDE-CD      TO                           
                WS-BC-EXCEPT-OVERRIDE-CD-CX (CX-INDX).                  
           MOVE CX-REQUESTED-USAGE         TO                           
                WS-BC-REQUESTED-USAGE-CX (CX-INDX).                     
           MOVE CX-DIGTL-INTRL-MTR-NO      TO                           
                WS-BC-DIGTL-INTRL-MTR-NO-CX (CX-INDX).                  
           MOVE CX-DIGTL-MTR-TYPE          TO                           
                WS-BC-DIGTL-MTR-TYPE-CX (CX-INDX).                      
           MOVE CX-CODE-TOU-SEASN          TO                           
                WS-BC-CODE-TOU-SEASN-CX (CX-INDX).                      
           MOVE CX-EXCL-DMD-RCHT-IND       TO                           
                WS-BC-EXCL-DMD-RCHT-IND-CX (CX-INDX).                   
           MOVE SPACE                      TO                           
                WS-BC-UPDATE-ACTION-IND-CX (CX-INDX).                   
           SET CX-INDX UP BY 1.                                         
           PERFORM 7960-FETCH-CNSMPTN-HIST THRU  7960-EXIT.             
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   8500-LOAD-BILL-ADJUSTMENT.                                  **        
      *        MOVE CSS_BILL_ADJUSTMNT FIELDS TO PASS AREA.           **        
      ******************************************************************        
       8500-LOAD-BILL-ADJUSTMENT.                                       
                                                                        
           MOVE BP-ACCOUNT-NO                                           
             TO WS-BC-ACCOUNT-NO-BP(WS-BC-ADJUSTMNT-INDEX)              
           MOVE BP-BILL-NO                                              
             TO WS-BC-BILL-NO-BP(WS-BC-ADJUSTMNT-INDEX)                 
           MOVE BP-CODE-UTIL-TYPE                                       
             TO WS-BC-CODE-UTIL-TYPE-BP(WS-BC-ADJUSTMNT-INDEX)          
           MOVE BP-IC-NO                                                
             TO WS-BC-IC-NO-BP(WS-BC-ADJUSTMNT-INDEX)                   
           MOVE BP-BILL-ITEM-TIMESTMP                                   
             TO WS-BC-BILL-ITEM-TIMESTMP-BP(WS-BC-ADJUSTMNT-INDEX)      
           MOVE BP-ADJ-TYPE-CD                                          
             TO WS-BC-ADJ-TYPE-CD-BP(WS-BC-ADJUSTMNT-INDEX)             
           MOVE BP-REVENUE-MONTH                                        
             TO WS-BC-REVENUE-MONTH-BP(WS-BC-ADJUSTMNT-INDEX)           
           MOVE BP-ADJ-REASON-DESC-LEN                                  
             TO WS-BC-ADJ-REASON-DESC-LEN-BP(WS-BC-ADJUSTMNT-INDEX)     
           MOVE BP-ADJ-REASON-DESC-TEXT                                 
             TO WS-BC-ADJ-REASON-DESC-TEXT-BP(WS-BC-ADJUSTMNT-INDEX)    
           MOVE BP-OVRRIDE-RT-REV-MTH                                   
             TO WS-BC-OVRRIDE-RT-REV-MTH-BP(WS-BC-ADJUSTMNT-INDEX)      
           MOVE BP-OVRRIDE-RT-BILL-DT                                   
             TO WS-BC-OVRRIDE-RT-BILL-DT-BP(WS-BC-ADJUSTMNT-INDEX)      
           MOVE BP-OVRRIDE-RT-BILL-CY                                   
             TO WS-BC-OVRRIDE-RT-BILL-CY-BP(WS-BC-ADJUSTMNT-INDEX)      
                                                                        
           SET WS-BC-ADJUSTMNT-INDEX UP BY +1.                          
           PERFORM 7250-FETCH-BILL-ADJUSTMENT THRU 7250-EXIT.           
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  8600-SELECT-DELINQUENCY.                                    **        
      **       GET DATABASE FROM CSS_DELINQUENCY                      **        
      ******************************************************************        
       8600-SELECT-DELINQUENCY.                                         
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD  = :C8-DELINQ-CD                         
                 AND COMPANY_NO = :AT-COMPANY-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*          AND COMPANY_NO = :AT-COMPANY-NO                                
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 8600                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA312 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 8600       **'        
              DISPLAY '**      SQLCODE   = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**      DELINQ CD = ' C8-DELINQ-CD               
              DISPLAY '**      COMP NO   = ' AT-COMPANY-NO              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  9000-TERMINATE.                                             **        
      **       TERMINATION ROUTINE                                    **        
      ******************************************************************        
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           DISPLAY 'PCSCA312 COMPLETED SUCCESSFULLY'.                   
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   9700-PROCESS-ABEND. - FOR COPYBOOK CPD00074 ABEND ROUTINE**          
      ****************************************************************          
       COPY CPD0023B.                                                           
      *                                                                         
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
