       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSCA302.                                            
       DATE-WRITTEN. FEB-2015.                                          
       DATE-COMPILED.                                                   
                                                                        
      *****************************************************************         
      *                SOUTH CAROLINA ELECTRIC & GAS                            
      *                                                                         
      *****************************************************************         
      *                 P R O G R A M  S U M M A R Y                  *         
      *                                                               *         
      *  THIS PROGRAM USES MONTHLY FIRM FILE TO CROSS CHECK CIS DATA  *         
      *  TO AVOID ANY BILLING INACCURACIES AND GENERATE TASK/WQ       *         
      *  WHEN THERE IS A MISMATCH.                                    *         
      *****************************************************************         
      *                     PROGRAM MODIFICATION LOG                            
      *                                                                         
      *    DATE    INITIALS   COMMENTS                                          
      *  --------  --------   ---------------------------------------           
A04998*  02/07/15  VK7L032    INITIAL VERSION.                                  
A04998*  05/20/15  VK7L032  1.MODIFIED THE CODE TO SKIP THE ACCNT FROM*         
      *                       ALL THE VALIDATIONS FOR THE STATUS 'P'. *         
      *                     2.SKIP THE 2500-VALIDATE-MTR-MLTPLR PARA  *         
      *                       WHEN THERE ARE MORE THAN 1 METER ON IC  *         
      *                     3.MODIFIED THE CODE TO CREATE WQ FOR THE  *         
      *                       ONLY FOUR ERROR MSGS AGL-SENIOR,DDDC,   *         
      *                       FAMILY UNITS, METER CONSTANT FOR THE    *         
      *                       PROCESS-TYPE=B IN JOB PARM TABLE        *         
ACT001*  07/10/15  SS45239    ADD SENIOR FACTOR START DATE TO WQ/MSG. *         
ACT002*  11/12/15  SS45239    GENERATE WQ FOR POOL GROUP VALIDATIONS. *         
ACT003*  12/28/15  SS45239    PRODUCTION ABEND FIX.                   *         
      *****************************************************************         
      *****************************************************************         
      *                                                                         
      *                ---- BASIC SEQUENCE STRUCTURE ----                       
      *                                                                         
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION                      
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                             
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                            
      *  3000 - 4999  NOT USED                                                  
      *  5000 - 5999  COMMON PROGRAM MODULES                                    
      *  6000 - 6999  COMMON SYSTEM MODULES                                     
      *  7000 - 7999  INPUT MODULES                                             
      *  8000 - 8999  OUTPUT MODULES                                            
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES                      
      *                                                                         
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSCA302.                                                           
       COPY CSSRP302.                                                           
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDCA302.                                                           
       COPY FIOCA302.                                                           
       COPY CFDRP302.                                                           
       COPY FIORP302.                                                           
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA302'.
MSQ017     COPY MFASQLM.
       01  WS-START                     PIC X(40)   VALUE               
           'WORKING STORAGE FOR PCSCA302 STARTS HERE'.                  
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME              PIC X(08)   VALUE 'PCSCA302'.   
ACT003     05  WS-811                   PIC S9(9)   VALUE -811 COMP.    
           05  WS-NO                    PIC X(01)   VALUE 'N'.          
           05  WS-YES                   PIC X(01)   VALUE 'Y'.          
           05  WS-TASK                  PIC X(01)   VALUE 'T'.          
           05  WS-REPORT                PIC X(01)   VALUE 'R'.          
           05  WS-BOTH                  PIC X(01)   VALUE 'B'.          
           05  WS-ONE                   PIC 9(01)   VALUE 1.            
           05  WS-FINAL-BILLED          PIC X(01)   VALUE 'B'.          
           05  WS-FDCG                  PIC X(04)   VALUE 'FDCG'.       
           05  SCSCB077                 PIC X(08)   VALUE 'SCSCB077'.   
           05  WS-REGULATED             PIC X(03)   VALUE 'REG'.        
           05  WS-DEREGULATED           PIC X(03)   VALUE 'AGL'.        
           05  WS-AGLSR-CUS             PIC X(09)   VALUE 'AGLSR CUS'.  
           05  WS-AGLSR-SOC             PIC X(09)   VALUE 'AGLSR SOC'.  
           05  WS-FAMUNITS              PIC X(09)   VALUE 'FAMUNITS '.  
           05  WS-DDC                   PIC X(09)   VALUE 'DDC      '.  
           05  WS-CIS-AGL-DISCNT-SR     PIC X(18)   VALUE               
                                                 'AGL DISCOUNT SR   '.  
           05  WS-DDAY-CONV-CONST       PIC X(20)   VALUE               
                                               'DDAY-CONV-CONST     '.  
           05  WS-TRAN-TRLR             PIC X(07) VALUE 'TRLR'.         
           05  WS-COMMON-PARM.                                          
              10  WS-COMMON-TEXT        PIC X(09) VALUE 'RUN DATE='.    
              10  WS-COMMON-RUN-DATE    PIC X(10).                      
A04998     05  WS-PENDING               PIC X(01) VALUE 'P'.            
                                                                        
       01  WS-RP302-HDR-REC.                                            
           05  E-RP302-HDR-CIS-ACCT     PIC X(11) VALUE 'CIS Account'.  
           05  E-RP302-HDR-FILLER-01    PIC X(01) VALUE ','.            
           05  E-RP302-HDR-BILL-CYCLE   PIC X(10) VALUE 'Bill Cycle'.   
           05  E-RP302-HDR-FILLER-02    PIC X(01) VALUE ','.            
           05  E-RP302-HDR-AGL-ACCT     PIC X(11) VALUE 'AGL Account'.  
           05  E-RP302-HDR-FILLER-03    PIC X(01) VALUE ','.            
           05  E-RP302-HDR-AGL-RATE-CD  PIC X(13) VALUE 'AGL Rate Code'.
           05  E-RP302-HDR-FILLER-04    PIC X(01) VALUE ','.            
           05  E-RP302-HDR-DDDC         PIC X(08) VALUE 'AGL Dddc'.     
           05  E-RP302-HDR-FILLER-05    PIC X(01) VALUE ','.            
           05  E-RP302-HDR-BILL-MONTH   PIC X(10) VALUE 'Bill Month'.   
           05  E-RP302-HDR-FILLER-06    PIC X(01) VALUE ','.            
           05  E-RP302-HDR-COUNTY-CD    PIC X(11) VALUE 'County Code'.  
           05  E-RP302-HDR-FILLER-07    PIC X(01) VALUE ','.            
           05  E-RP302-HDR-FAM-UNITS    PIC X(12) VALUE 'Family Units'. 
           05  E-RP302-HDR-FILLER-08    PIC X(01) VALUE ','.            
           05  E-RP302-HDR-MTR-MULT     PIC X(14) VALUE                 
                                                       'Meter Constant'.
           05  E-RP302-HDR-FILLER-09    PIC X(01) VALUE ','.            
           05  E-RP302-HDR-DELIVERY-GRP PIC X(19) VALUE                 
                                                  'Delivery Group Code'.
           05  E-RP302-HDR-FILLER-10    PIC X(01) VALUE ','.            
           05  E-RP302-HDR-FRNCHSE-DIST PIC X(23) VALUE                 
                                              'Franchise District Code'.
           05  E-RP302-HDR-FILLER-11    PIC X(01) VALUE ','.            
           05  E-RP302-HDR-ERR-MSG-CODE PIC X(10) VALUE 'Error Type'.   
           05  E-RP302-HDR-FILLER-12    PIC X(01) VALUE ','.            
           05  E-RP302-HDR-ERR-MSG      PIC X(07) VALUE 'Message'.      
           05  E-RP302-HDR-FILLER       PIC X(162)                      
                                                  VALUE SPACES.         
                                                                        
       01  WS-MISC.                                                     
           05  RS-RETURN-CODE           PIC S9(09)  COMP  VALUE +0.     
           05  WS-PARM-DATA             PIC X(80)   VALUE SPACES.       
COB305     05 WS-DEKA-CONV-CONST        PIC S9(4)V9(5) USAGE COMP-3 
COB305       VALUE 0.    
           05  WS-DEKA-CONV-CONST-TXT   PIC 9(1).9(3).                  
           05  WS-FLCA302-REC-CNTR      PIC 9(08)   VALUE ZEROES.       
           05  WS-FLRP302-REC-CNTR      PIC 9(08)   VALUE ZEROES.       
           05  WS-INSERT-REC-CNTR       PIC 9(08)   VALUE ZEROES.       
           05  WS-WORK-QUEUE-CNTR       PIC 9(08)   VALUE ZEROES.       
           05  WS-TRL-REC-COUNT         PIC 9(07)   VALUE ZEROES.       
           05  WS-AGL-TRL-COUNT-NUM     PIC 9(07)   VALUE ZEROES.       
           05  WS-CURRENT-DATE          PIC X(10)   VALUE SPACES.       
           05  WS-CURRENT-TIMESTAMP     PIC X(26)   VALUE SPACES.       
           05  WS-ERROR-MESG-CODE       PIC X(20)   VALUE SPACES.       
A04998         88 ACCOUNT-NOT-IN-CIS        VALUE 'Account not in CIS'. 
A04998         88 FINAL-BILL                VALUE 'Final Bill'.         
A04998         88 AGL-SENIOR                VALUE 'AGL Senior'.         
A04998         88 DDDC                      VALUE 'DDDC'.               
A04998         88 FRANCHISE-DISTRICT        VALUE 'Franchise District'. 
A04998         88 REVENUE-DISTRICT          VALUE 'Revenue District'.   
A04998         88 POOL-GROUP                VALUE 'Pool Group'.         
A04998         88 FAMILY-UNITS              VALUE 'Family Units'.       
A04998         88 METER-CONSTANT            VALUE 'Meter Constant'.     
ACT003         88 MULTIPLE-CIS-ACCTS        VALUE 'Multiple CIS Accts'. 
           05  WS-ERROR-MESG            PIC X(250)  VALUE SPACES.       
           05  WS-AGL-BILL-MONTH.                                       
               10  WS-AGL-CCYY          PIC X(04)   VALUE SPACES.       
               10  FILLER               PIC X(01)   VALUE '-'.          
               10  WS-AGL-MONTH         PIC X(02)   VALUE SPACES.       
               10  FILLER               PIC X(01)   VALUE '-'.          
               10  WS-AGL-DAY           PIC X(02)   VALUE '01'.         
A04998     05  WS-METER-COUNT           PIC S9(4) COMP VALUE ZEROES.    
ACT001     05  WS-SRCUS-FCTR-STRT-DT    PIC X(10) VALUE SPACES.         
ACT001     05  WS-SRSOC-FCTR-STRT-DT    PIC X(10) VALUE SPACES.         
                                                                        
       01  WS-AGL-CIS-VALUES.                                           
           05 WS-MKT-VALUE-N-CD.                                        
               15 WS-MKT-ID-VALUE       PIC X(20)   VALUE SPACES.       
               15 WS-MKT-ID-CD          PIC X(03)   VALUE SPACES.       
           05  WS-AGL-FRN-DST-COUNTY.                                   
               15  WS-AGL-FRNCHSE-DST   PIC X(04)   VALUE SPACES.       
               15  WS-AGL-COUNTY        PIC X(03)   VALUE SPACES.       
           05  WS-AGL-CIS-COUNTY        PIC X(03)   VALUE SPACES.       
           05  WS-AGL-CIS-POOL-GRP      PIC X(03)   VALUE SPACES.       
           05  WS-CIS-COUNTY            PIC X(03)   VALUE SPACES.       
           05  WS-CIS-LOCAL-OFFICE      PIC X(03)   VALUE SPACES.       
COB305     05 WS-CIS-FAMUNITS        PIC S9(9)V9(4) USAGE COMP-3 
COB305       VALUE 0.    
           05  WS-CIS-FAMUNITS-TXT      PIC 9(3).99.                    
COB305     05 WS-AGL-FAMUNITS        PIC S9(9)V9(4) USAGE COMP-3 
COB305       VALUE 0.    
COB305     05 WS-CIS-DDC-FCTR        PIC S9(9)V9(4) USAGE COMP-3 
COB305       VALUE 0.    
           05  WS-CIS-DDC-FCTR-TXT      PIC 9(4).9(3).                  
           05  WS-AGL-DDC-FCTR-TXT      PIC 9(4).9(3).                  
COB305     05 WS-CIS-MTR-MULTPLR        PIC S9(6)V9(3) USAGE COMP-3 
COB305       VALUE 0.    
           05  WS-CIS-MTR-MULTPLR-TXT   PIC 9(5).9(4).                  
                                                                        
       01  WS-TEMP-TBLS.                                                
           05  WS-CIS-COUNTY-LST                                        
                  OCCURS 400 TIMES                                      
                  ASCENDING KEY COUNTY-MKT-VAL-N-CD                     
                  INDEXED BY WS-CIS-CNTY-INDX.                          
               10 COUNTY-MKT-VAL-N-CD.                                  
                  15 CNTY-MKT-ID-VALUE  PIC X(20)   VALUE SPACES.       
                  15 CNTY-MKT-ID-CD     PIC X(03)   VALUE SPACES.       
               10 CNTY-CIS-VALUE        PIC X(03)   VALUE SPACES.       
           05  WS-CIS-POOL-GRP-LST                                      
                  OCCURS 100 TIMES                                      
                  ASCENDING KEY POOL-GRP-MKT-VAL-N-CD                   
                  INDEXED BY WS-POOL-GRP-INDX.                          
               10 POOL-GRP-MKT-VAL-N-CD.                                
                  15 POOL-MKT-ID-VALUE  PIC X(20)   VALUE SPACES.       
                  15 POOL-MKT-ID-CD     PIC X(03)   VALUE SPACES.       
               10 POOL-CIS-VALUE        PIC X(03)   VALUE SPACES.       
                                                                        
       01  WS-AGL-DDC-FCTR-FMT.                                         
           05 WS-AGL-DDC-FCTR-TEMP.                                     
              10 WS-AGL-DDC-FCTR-INT     PIC 9(04) VALUE 0.             
              10 WS-AGL-DDC-FCTR-DEC     PIC 9(03) VALUE 0.             
           05 WS-AGL-DDC-FCTR            PIC 9(04)V9(03) VALUE 0.       
           05 WS-AGL-DDC-FCTR-CMPR       PIC S9(9)V9(4) USAGE COMP-3    
                                                   VALUE 0.             
                                                                        
       01  WS-AGL-MTR-MULT-FMT.                                         
           05 WS-AGL-MTR-MULT-TEMP.                                     
              10 WS-AGL-MTR-MULTPLR-INT  PIC 9(05) VALUE 0.             
              10 WS-AGL-MTR-MULTPLR-DEC  PIC 9(04) VALUE 0.             
           05 WS-AGL-MTR-MULTPLR         PIC 9(05)V9(04) VALUE 0.       
                                                                        
       01  WS-SWITCH.                                                   
           05  WS-FLRP302-STATUS        PIC X(02).                      
               88 FLRP302-SUCCESSFUL               VALUE '00'.          
           05  WS-FLCA302-STATUS        PIC X(02).                      
               88 FLCA302-SUCCESSFUL               VALUE '00'.          
           05  WS-FLR302R-STATUS        PIC X(02).                      
               88 FLR302R-SUCCESSFUL               VALUE '00'.          
           05  WS-SKIP-ACCOUNT-SW       PIC X(01)  VALUE 'N'.           
               88 SKIP-ACCOUNT                     VALUE 'Y'.           
           05  WS-FRNCHSE-DST-MAP       PIC X(01)  VALUE 'N'.           
               88 FRNCHSE-DST-MAP-EXIST            VALUE 'Y'.           
               88 FRNCHSE-DST-MAP-NOT-EXIST        VALUE 'N'.           
           05  WS-AGLSR-CUS-SW          PIC X(01)  VALUE 'N'.           
               88 AGLSR-CUS-EXIST                  VALUE 'Y'.           
               88 AGLSR-CUS-NOT-EXIST              VALUE 'N'.           
           05  WS-AGLSR-SOC-SW          PIC X(01)  VALUE 'N'.           
               88 AGLSR-SOC-EXIST                  VALUE 'Y'.           
               88 AGLSR-SOC-NOT-EXIST              VALUE 'N'.           
           05  WS-AGLSR-ACT-SW          PIC X(01)  VALUE 'N'.           
               88 AGLSR-ACCOUNT-EXIST              VALUE 'Y'.           
               88 AGLSR-ACCOUNT-NOT-EXIST          VALUE 'N'.           
           05  WS-FAMUNITS-SW           PIC X(01)  VALUE 'N'.           
               88 FAMUNITS-EXIST                   VALUE 'Y'.           
               88 FAMUNITS-NOT-EXIST               VALUE 'N'.           
           05  WS-NO-MORE-ROWS          PIC X(01)  VALUE 'N'.           
               88 NO-MORE-ROWS                     VALUE 'Y'.           
           05  WS-MORE-DATA-SW          PIC X(01)  VALUE 'Y'.           
               88 NO-MORE-DATA                     VALUE 'N'.           
           05  WS-PROCESS-TYPE-SW       PIC X(01)  VALUE 'N'.           
               88 CREATE-TASK                      VALUE 'T'.           
               88 CREATE-REPORT                    VALUE 'R'.           
               88 CREATE-TASK-AND-REPORT           VALUE 'B'.           
                                                                        
      ****************************************************************          
      *   BELOW IS THE WORKING STORAGE AREA FOR RESTART LOGIC        *          
      ****************************************************************          
                                                                        
       01  WS-RESTART-DATA.                                             
           05  WS-RESTART-PROCESS-TYPE     PIC 9(01).                   
           05  WS-RESTART-JOB-COMPLETE REDEFINES                        
               WS-RESTART-PROCESS-TYPE     PIC X(01).                   
           05  WS-RESTART-JOB-STATUS       PIC X(01).                   
               88  WS-RUN-COMPLETED-NO-PROBLEMS VALUE 'A'.              
               88  WS-RERUN-COMPLETED           VALUE 'B'.              
               88  WS-RERUN-PENDING             VALUE 'C'.              
           05  WS-RESTART-INPUT-DATE       PIC X(10).                   
           05  WS-RESTART-CHKP-SEQ-NO      PIC 9(05) VALUE 0.           
           05  WS-RESTART-AGLC-ACCT-NO     PIC X(20).                   
           05  WS-RESTART-TOTAL-COUNT       PIC 9(07) VALUE 0.          
      *                                                                         
       01  WS-RESTART-MISC.                                             
           05  WS-RESTART-DATA-LENGTH      PIC S9(04) COMP VALUE +91.   
           05  WS-IS-THIS-A-RESTART        PIC X(01) VALUE 'N'.         
               88  WS-THIS-IS-A-RESTART              VALUE 'Y'.         
           05  WS-NEXT-RECORD-READ-FLAG    PIC X(01) VALUE 'N'.         
               88  WS-NEXT-RECORD-READ               VALUE 'Y'.         
               88  WS-NEXT-RECORD-NOT-READ           VALUE 'N'.         
           05  WS-RESTART-REC-CNT          PIC S9(09) COMP VALUE ZERO.  
           05  WS-RESTART-REQ              PIC X(01).                   
           05  WS-PRINT-COUNTERS           PIC X(01) VALUE 'A'.         
           05  WS-DEFAULT-RESTART-REQ      PIC X(01) VALUE 'N'.         
           05  WS-REPOSITION-NEEDED        PIC X(01) VALUE 'Y'.         
           05  WS-FLAG-TO-TURN-OFF-COMMITS PIC 9(04) VALUE 9999.        
           05  WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(04) VALUE 200.         
           05  WS-CHKP-LUW-LIMIT           PIC 9(04).                   
           05  WS-CHKP-LUW-COUNTER         PIC 9(04) COMP-3 VALUE ZERO. 
           05  WS-DEFAULT-CHKP-UPD-LIMIT   PIC 9(04) VALUE 200.         
           05  WS-CHKP-UPD-LIMIT           PIC 9(04).                   
           05  WS-COMMIT-COUNTER           PIC S9(3) COMP-3 VALUE 0.    
           05  WS-COMMIT-REQ-SW            PIC X(1)  VALUE 'Y'.         
               88 WS-COMMITS-REQUIRE                 VALUE 'Y'.         
               88 WS-COMMITS-NOT-REQUIRE             VALUE 'N'.         
           05  WS-CHKP-UPD-COUNTER         PIC S9(04) COMP-3 VALUE ZERO.
           05  WS-CHKP-ID.                                              
               10  WS-CHKP-PGM-ID          PIC X(02) VALUE 'B4'.        
               10  WS-CHKP-PART-NO         PIC 9(01) VALUE 1.           
               10  WS-CHKP-SEQ-NO          PIC 9(05) VALUE ZERO.        
           05  WS-COUNT-UNSUCCESSFUL-ROWS  PIC S9(04) COMP-3            
                                                     VALUE ZERO.        
      *LITERALS USED IN RESTART COPYBOOK                                        
                                                                        
           05  WS-Y                        PIC X(01) VALUE 'Y'.         
           05  WS-N                        PIC X(01) VALUE 'N'.         
           05  WS-I                        PIC X(01) VALUE 'I'.         
      *                                                                         
                                                                        
      *****************************************************************         
      * SQL COMMUNICATION AREA                                        *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_FIXED_FCTR FF                                             *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBFXDFCT                                                
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_SO_CODE_DESC SW                                           *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBSOCODE                                                
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_MKT_XREF_ACCT XM                                          *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBMRKXR                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_REG_PROFILE LR                                            *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBREGPRF                                                
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_MKT_VAL_TRANS V5                                          *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBMRKVLT                                                
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_ACCT_ATTRIBUTE YP                                         *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBACTATT                                                
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_PREMISE PR                                                *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBPREM                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_ACCOUNT AT                                                *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_MTR_CAP MC                                                *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBMTRCAP                                                
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_UTIL_ENVRNMT UT                                           *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBUTLENV                                                
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_MTRD_ENVRNMT MN                                           *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBMTRENV                                                
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_DELINQUENCY C8                                            *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBDELQ                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_JOB_PARM G6                                               *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_RESTART RF                                                *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRESTRT                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077         *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CWS00077                                                
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * ABEND SWITCH COPYBOOK                                         *         
      *****************************************************************         
      *                                                                         
           COPY CWS00038.                                                       
      *                                                                         
      *****************************************************************         
      * FIOJC01 - IO AREA FOR PARAMETER INPUT FILE 'A'                *         
      *****************************************************************         
      *                                                                         
           COPY FIOJC01.                                                        
      *                                                                         
      *****************************************************************         
      * COPY BOOK HAVING SUCCESSFUL-CALL AND NOT-FOUND                *         
      *****************************************************************         
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      *****************************************************************         
      * WS ABEND WORK AREA                                                      
      *****************************************************************         
      *                                                                         
           COPY CWS00010.                                                       
      *                                                                         
      *****************************************************************         
      * WS-ABEND-SWITCH                                               *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS09900                                                 
           END-EXEC.                                                            
      *                                                                         
       01  WS-END                        PIC X(40)  VALUE               
             'WORKING STORAGE FOR PCSCA302 ENDS HERE  '.                
                                                                        
      *****************************************************************         
      * CURSOR DECALRATION FOR FIXED FACTORS                          *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE FXD_FCTR_CSR CURSOR FOR                           
                  SELECT FF.FACTOR_ID,                                  
                         FF.FACTOR,                                     
                         FF.EFF_DATE_FROM,                              
                         FF.EFF_DATE_TO                                 
                    FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)              
                        ,CSS_FIXED_FCTR   FF WITH(READUNCOMMITTED)              
                   WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO             
                     AND FF.ACCOUNT_NO     =  UT.ACCOUNT_NO             
                     AND FF.CODE_UTIL_TYPE =  UT.CODE_UTIL_TYPE         
                     AND FF.IC_NO          =  UT.IC_NO                  
                     AND FACTOR_ID IN ('AGLSR CUS','AGLSR SOC',         
                                       'DDC','FAMUNITS')                
                     AND FF.EFF_DATE_TO   >= IIF(TRY_CONVERT(DATE, 
                                                        :FF-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FF-EFF-DATE-TO
              ), CONVERT(DATE, :FF-EFF-DATE-TO) )            
                   ORDER BY FF.EFF_DATE_TO DESC                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE FXD_FCTR_CSR CURSOR FOR                                   
MFA-TR*           SELECT FF.FACTOR_ID,                                          
MFA-TR*                  FF.FACTOR,                                             
MFA-TR*                  FF.EFF_DATE_FROM,                                      
MFA-TR*                  FF.EFF_DATE_TO                                         
MFA-TR*             FROM CSS_UTIL_ENVRNMT UT                                    
MFA-TR*                 ,CSS_FIXED_FCTR   FF                                    
MFA-TR*            WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                     
MFA-TR*              AND FF.ACCOUNT_NO     =  UT.ACCOUNT_NO                     
MFA-TR*              AND FF.CODE_UTIL_TYPE =  UT.CODE_UTIL_TYPE                 
MFA-TR*              AND FF.IC_NO          =  UT.IC_NO                          
MFA-TR*              AND FACTOR_ID IN ('AGLSR CUS','AGLSR SOC',                 
MFA-TR*                                'DDC','FAMUNITS')                        
MFA-TR*              AND FF.EFF_DATE_TO   >= :FF-EFF-DATE-TO                    
MFA-TR*            ORDER BY FF.EFF_DATE_TO DESC                                 
MFA-TR*             WITH UR                                                     
MFA-TR*          QUERYNO 7175                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CURSOR DECALRATION FOR MARKET VALUE TABLE                     *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE MKT_TRAN_CSR CURSOR FOR                           
                  SELECT LTRIM(RTRIM(MKT_ID_VALUE))                             
                        ,MKT_ID_CD                                      
                        ,LTRIM(RTRIM(CIS_VALUE))                                
                        ,LTRIM(RTRIM(VALUE_ID))                                 
                        ,LTRIM(RTRIM(VALUE_ID_DESC))                            
                    FROM CSS_MKT_VAL_TRANS V5 WITH(READUNCOMMITTED)             
                   WHERE VALUE_ID_DESC  IN ('REVENUE DISTRICT'          
                                           ,'LOCAL OFFICE')             
                     AND VALUE_ID       IN ('D','C')                    
                   ORDER BY VALUE_ID_DESC                               
                           ,MKT_ID_VALUE                                
                           ,MKT_ID_CD                                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MKT_TRAN_CSR CURSOR FOR                                   
MFA-TR*           SELECT TRIM(MKT_ID_VALUE)                                     
MFA-TR*                 ,MKT_ID_CD                                              
MFA-TR*                 ,TRIM(CIS_VALUE)                                        
MFA-TR*                 ,TRIM(VALUE_ID)                                         
MFA-TR*                 ,TRIM(VALUE_ID_DESC)                                    
MFA-TR*             FROM CSS_MKT_VAL_TRANS V5                                   
MFA-TR*            WHERE VALUE_ID_DESC  IN ('REVENUE DISTRICT'                  
MFA-TR*                                    ,'LOCAL OFFICE')                     
MFA-TR*              AND VALUE_ID       IN ('D','C')                            
MFA-TR*            ORDER BY VALUE_ID_DESC                                       
MFA-TR*                    ,MKT_ID_VALUE                                        
MFA-TR*                    ,MKT_ID_CD                                           
MFA-TR*             WITH UR                                                     
MFA-TR*          QUERYNO 7250                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      ***********************************************************               
      *0000-MAINLINE.                                          **               
      ***********************************************************               
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION          THRU 0100-EXIT.         
                                                                        
           PERFORM 0200-READ-FCSCA302           THRU 0200-EXIT.         
                                                                        
           PERFORM 0250-CHECK-EMPTY-FILE        THRU 0250-EXIT.         
                                                                        
           PERFORM 0275-GET-RUN-DATE            THRU 0275-EXIT.         
                                                                        
           PERFORM 1000-MAIN-PROCESS-PARA       THRU 1000-EXIT          
             UNTIL NO-MORE-DATA.                                        
                                                                        
           PERFORM 5900-PROCESS-SUCCESSFUL-JOB  THRU 5900-EXIT.         
                                                                        
           PERFORM 9000-TERMINATE               THRU 9000-EXIT.         
                                                                        
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***********************************************************               
      *0100-INITIALIZATION.                                    **               
      ***********************************************************               
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           MOVE 'N'                          TO WS-SKIP-ACCOUNT-SW.     
                                                                        
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           OPEN OUTPUT FCSRP302-FILE.                                   
           IF FLRP302-SUCCESSFUL                                        
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA302 ABORT *****************'     
              DISPLAY '**  PARA 0100-INITIALIZATION             **'     
              DISPLAY '**  OPEN ERROR OF FCSRP302 - INPUT FILE  **'     
              DISPLAY '**         FILE STATUS = ' WS-FLRP302-STATUS     
              DISPLAY '**         PROCESSING TERMINATED         **'     
              DISPLAY '********** PCSCA302 ABORT *****************'     
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
           OPEN INPUT FCSCA302-FILE.                                    
           IF FLCA302-SUCCESSFUL                                        
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA302 ABORT *****************'     
              DISPLAY '**  PARA 0100-INITIALIZATION             **'     
              DISPLAY '**  OPEN ERROR OF FCSCA302 - INPUT FILE  **'     
              DISPLAY '**         FILE STATUS = ' WS-FLCA302-STATUS     
              DISPLAY '**         PROCESSING TERMINATED         **'     
              DISPLAY '********** PCSCA302 ABORT *****************'     
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
           MOVE 'N'                          TO WS-PROCESS-TYPE-SW.     
           PERFORM 7050-PROCESS-PARM-SW         THRU 7050-EXIT.         
      * CHECK PROCESS-TYPE                                                      
      *    'T' - CREATE TASK                                                    
      *    'R' - CREATE REPORT                                                  
      *    'B' - CREATE BOTH TASK AND REPORT                                    
           EVALUATE WS-PARM-DATA(14:1)                                  
               WHEN WS-TASK                                             
                  SET CREATE-TASK            TO TRUE                    
               WHEN WS-REPORT                                           
                  SET CREATE-REPORT          TO TRUE                    
               WHEN WS-BOTH                                             
                  SET CREATE-TASK-AND-REPORT TO TRUE                    
               WHEN OTHER                                               
                  SET CREATE-REPORT          TO TRUE                    
           END-EVALUATE.                                                
      *                                                                         
           MOVE WS-DDAY-CONV-CONST           TO C8-DELINQ-CD.           
           PERFORM 7100-SELECT-DLQ-VAL          THRU 7100-EXIT.         
           MOVE C8-DELINQ-VALUE              TO WS-DEKA-CONV-CONST.     
           MOVE WS-DEKA-CONV-CONST           TO WS-DEKA-CONV-CONST-TXT. 
           MOVE WS-PGRMNAME                  TO G6-PROGRAM-NAME.        
      *                                                                         
           PERFORM 0150-LOAD-MKT-VAL-TRANS      THRU 0150-EXIT.         
      *                                                                         
      * GET CHECK POINT LIMIT FOR COMMITS                                       
           PERFORM 6253-GET-FJC01-CHKP-LIMIT    THRU 6253-EXIT.         
           IF WS-CHKP-LUW-LIMIT     = WS-FLAG-TO-TURN-OFF-COMMITS       
              AND WS-CHKP-UPD-LIMIT = WS-FLAG-TO-TURN-OFF-COMMITS       
                                                                        
              SET WS-COMMITS-NOT-REQUIRE     TO TRUE                    
                                                                        
              DISPLAY '**   ' WS-PGRMNAME ' INFORMATIONAL MSG    **'    
              DISPLAY '**   CHKP-LUW AND CHKP-UPD PARMS   **'           
              DISPLAY '** BOTH SET TO ' WS-FLAG-TO-TURN-OFF-COMMITS     
                      ', INTERPRETED TO  **'                            
              DISPLAY '**  INDICATE THAT INTERIM COMMIT   **'           
              DISPLAY '**   POINTS SHOULD NOT BE TAKEN.   **'           
              DISPLAY '** COMPLETE RERUN WILL BE REQUIRED **'           
              DISPLAY '**  UPON UNSUCCESSFUL COMPLETION.  **'           
              DISPLAY '**      PROCESSING CONTINUING      **'           
           END-IF.                                                      
                                                                        
      * CHECK FOR RESTART                                                       
           PERFORM 6235-GET-FJC01-RESTART-REQ   THRU 6235-EXIT.         
                                                                        
      * CHECK CSS_RESTART TABLE TO GET PRIOR RUN LAST COMMITED DATA             
           PERFORM 0600-CHECK-FOR-RESTART       THRU 0600-EXIT.         
                                                                        
      * VALIDATE JOB_PARM & CSS_RESTART STATUS                                  
           PERFORM 0605-VALIDATE-RESTART-REQ    THRU 0605-EXIT.         
                                                                        
           IF WS-THIS-IS-A-RESTART                                      
              MOVE WS-Y                      TO WS-REPOSITION-NEEDED    
              PERFORM 0601-REPOSITION-INPUT-FILE                        
                                                THRU 0601-EXIT          
           ELSE                                                         
              PERFORM 0610-INITIALIZE-RESTART   THRU 0610-EXIT          
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *0150-LOAD-MKT-VAL-TRANS.                                     **          
      ****************************************************************          
       0150-LOAD-MKT-VAL-TRANS.                                         
      *                                                                         
           SET WS-POOL-GRP-INDX              TO WS-ONE.                 
           SET WS-CIS-CNTY-INDX              TO WS-ONE.                 
                                                                        
           PERFORM 7225-OPEN-MKT-VAL-TRANS      THRU 7225-EXIT.         
           PERFORM 7250-FETCH-MKT-VAL-TRANS     THRU 7250-EXIT.         
                                                                        
           PERFORM UNTIL NO-MORE-ROWS                                   
              IF V5-VALUE-ID-DESC = 'LOCAL OFFICE'                      
                 MOVE V5-MKT-ID-VALUE                                   
                      TO POOL-MKT-ID-VALUE(WS-POOL-GRP-INDX)            
                 MOVE V5-MKT-ID-CD                                      
                      TO POOL-MKT-ID-CD(WS-POOL-GRP-INDX)               
                 MOVE V5-CIS-VALUE                                      
                      TO POOL-CIS-VALUE(WS-POOL-GRP-INDX)               
                 SET WS-POOL-GRP-INDX UP BY WS-ONE                      
              ELSE                                                      
                 MOVE V5-MKT-ID-VALUE                                   
                      TO CNTY-MKT-ID-VALUE(WS-CIS-CNTY-INDX)            
                 MOVE V5-MKT-ID-CD                                      
                      TO CNTY-MKT-ID-CD(WS-CIS-CNTY-INDX)               
                 MOVE V5-CIS-VALUE                                      
                      TO CNTY-CIS-VALUE(WS-CIS-CNTY-INDX)               
                 SET  WS-CIS-CNTY-INDX UP BY WS-ONE                     
              END-IF                                                    
              PERFORM 7250-FETCH-MKT-VAL-TRANS  THRU 7250-EXIT          
           END-PERFORM.                                                 
                                                                        
           PERFORM 7275-CLOSE-MKT-VAL-TRANS     THRU 7275-EXIT.         
      *                                                                         
       0150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      *0200-READ-FCSCA302                                        **             
      *************************************************************             
                                                                        
       0200-READ-FCSCA302.                                              
                                                                        
           INITIALIZE  WS-AGL-CIS-VALUES.                               
                                                                        
           MOVE WS-NO                        TO WS-NO-MORE-ROWS         
                                                WS-AGLSR-CUS-SW         
                                                WS-AGLSR-SOC-SW         
                                                WS-AGLSR-ACT-SW         
                                                WS-FAMUNITS-SW.         
                                                                        
           PERFORM 7000-READ-FCSCA302           THRU 7000-EXIT.         
                                                                        
           IF AGL-SUB-TYPE-CODE = WS-FDCG                               
              DISPLAY 'Processing AGL Account : ' AGL-DIST-ACCOUNT-NO   
              MOVE AGL-DIST-ACCOUNT-NO       TO XM-DIST-ACCT-NO         
              MOVE AGL-COUNTY                TO WS-AGL-COUNTY           
              MOVE AGL-FRANCHISE-DISTRICT    TO WS-AGL-FRNCHSE-DST      
              MOVE AGL-FAM-UNITS             TO WS-AGL-FAMUNITS         
              MOVE AGL-BILL-MONTH(1:4)       TO WS-AGL-CCYY             
              MOVE AGL-BILL-MONTH(5:2)       TO WS-AGL-MONTH            
              MOVE WS-AGL-BILL-MONTH         TO FF-EFF-DATE-TO          
                                                                        
              UNSTRING AGL-DESIGN-DAY-USAGE DELIMITED BY '.'            
                  INTO WS-AGL-DDC-FCTR-INT                              
                      ,WS-AGL-DDC-FCTR-DEC                              
              END-UNSTRING                                              
                                                                        
              UNSTRING AGL-METER-MULTIPLIER DELIMITED BY '.'            
                  INTO WS-AGL-MTR-MULTPLR-INT                           
                      ,WS-AGL-MTR-MULTPLR-DEC                           
              END-UNSTRING                                              
                                                                        
              MOVE WS-AGL-DDC-FCTR-TEMP      TO WS-AGL-DDC-FCTR         
              MOVE WS-AGL-MTR-MULT-TEMP      TO WS-AGL-MTR-MULTPLR      
           END-IF.                                                      
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *0250-CHECK-EMPTY-FILE.                                        *          
      ****************************************************************          
       0250-CHECK-EMPTY-FILE.                                           
      *                                                                         
           IF NO-MORE-DATA                                              
              DISPLAY ' FCSCA302 FILE IS EMPTY '                        
              MOVE 05                        TO RETURN-CODE             
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       0250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 0275-GET-RUN-DATE                                             *         
      * GETTING COMMON RUN DATE FROM JOB PARM TABLE.                  *         
      *****************************************************************         
       0275-GET-RUN-DATE.                                               
                                                                        
           MOVE SPACES                       TO WS-SYSIPT               
           MOVE SPACES                       TO WS-INPUT-DATA-BREAKDOWN 
           PERFORM 6251-GET-FJC01-DATE          THRU 6251-EXIT.         
                                                                        
              MOVE SPACES                    TO WS-SYSIPT.              
              MOVE SPACES                    TO WS-INPUT-DATA-BREAKDOWN.
              MOVE 'COMMON'                  TO WS-PROGRAM.             
              MOVE WS-DATE                   TO WS-COMMAND.             
              MOVE ZEROS                     TO WS-SEQUENCE.            
              MOVE WS-KEY-AREA               TO E-FJC01-KEY.            
              PERFORM 7600-START-FCSJC01        THRU  7600-EXIT.        
              PERFORM 7610-READ-FCSJC01         THRU  7610-EXIT         
                      UNTIL (RUN-DATE AND INPUT-ACTIVE)                 
                                 OR  END-OF-SYSIPT.                     
              IF WS-INPUT-RUN-DATE-MM  NUMERIC AND                      
                 WS-INPUT-RUN-DATE-DD  NUMERIC AND                      
                 WS-INPUT-RUN-DATE-YY  NUMERIC                          
                 PERFORM 7611-CLOSE             THRU 7611-EXIT          
                 MOVE  G6-PARM-DATA          TO WS-COMMON-PARM          
              ELSE                                                      
                 DISPLAY ' '                                            
                 DISPLAY '** ' WS-PGRMNAME ' PROCESSING ERROR  **'      
                 DISPLAY '**      COMMON IS NOT ACTIVE'                 
                 DISPLAY '**         KEY = ' E-FJC01-KEY                
                 DISPLAY '**      PROCESSING TERMINATED        **'      
                 PERFORM 9900-ABEND             THRU  9900-EXIT         
              END-IF.                                                   
                                                                        
       0275-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *0600-CHECK-FOR-RESTART.                                       *          
      ****************************************************************          
       0600-CHECK-FOR-RESTART.                                          
                                                                        
           MOVE WS-PGRMNAME                  TO RF-NAME-PROGRAM.        
           MOVE 1                            TO RF-PARTITION-NO         
                                                RF-DUP-CNTRL-NO.        
                                                                        
           PERFORM 7750-SELECT-RESTART-DATA     THRU 7750-EXIT.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE RF-RESTART-DATA-TEXT      TO WS-RESTART-DATA         
              IF WS-RESTART-PROCESS-TYPE NUMERIC                        
                 MOVE WS-YES                 TO WS-IS-THIS-A-RESTART    
              ELSE                                                      
                 MOVE WS-NO                  TO WS-IS-THIS-A-RESTART    
              END-IF                                                    
           ELSE                                                         
              MOVE WS-NO                     TO WS-IS-THIS-A-RESTART    
           END-IF.                                                      
                                                                        
       0600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *0601-REPOSITION-INPUT-FILE.                                   *          
      ****************************************************************          
      **** REPOSITION CA302 FILE TO LAST SUCCESSFUL COMMIT                      
       0601-REPOSITION-INPUT-FILE.                                      
                                                                        
           MOVE ZERO                         TO WS-FLCA302-REC-CNTR.    
      *                                                                         
           PERFORM 7000-READ-FCSCA302           THRU 7000-EXIT          
             UNTIL  WS-FLCA302-REC-CNTR EQUAL WS-RESTART-TOTAL-COUNT    
              OR NO-MORE-DATA.                                          
      *                                                                         
      *****************************************************************         
      *    THE FOLLOWING CODE COMPARES KEY VALUES STORED IN           *         
      *    RESTART DATA WITH REPOSITIONED RECORD KEY.                 *         
      *****************************************************************         
           IF AGL-DIST-ACCOUNT-NO = WS-RESTART-AGLC-ACCT-NO             
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '***************************************'         
              DISPLAY '** FAIL TO REPOSITION CA302 FILE     **'         
                      '** CHECK FOR CORRECT CA302 FILE      **'         
              DISPLAY ' '                                               
              DISPLAY '** LAST ACCOUNT PROCESSED IN PRIOR RUN: '        
                 WS-RESTART-AGLC-ACCT-NO                                
              DISPLAY '** BUT FILE POSITIONED AT             : '        
                 AGL-DIST-ACCOUNT-NO                                    
              DISPLAY '***************************************'         
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
           DISPLAY '*******************************************'.       
           DISPLAY '*****  THIS IS A RESTART OF PCSCA302  *****'.       
           DISPLAY '*******************************************'.       
           MOVE WS-RESTART-CHKP-SEQ-NO       TO WS-CHKP-SEQ-NO.         
      *                                                                         
       0601-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *0605-VALIDATE-RESTART-REQ                                     *          
      ****************************************************************          
       COPY CPD00030.                                                           
                                                                        
      ****************************************************************          
      *0610-INITIALIZE-RESTART                                       *          
      ****************************************************************          
       0610-INITIALIZE-RESTART.                                         
                                                                        
           MOVE ZEROES                       TO WS-RESTART-PROCESS-TYPE 
                                                WS-RESTART-CHKP-SEQ-NO  
                                                WS-RESTART-TOTAL-COUNT. 
           MOVE SPACES                       TO WS-RESTART-AGLC-ACCT-NO.
           SET WS-RERUN-PENDING              TO TRUE.                   
           MOVE WS-CURRENT-DATE              TO WS-RESTART-INPUT-DATE.  
           MOVE WS-NO                        TO WS-REPOSITION-NEEDED.   
                                                                        
       0610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 6251-GET-FJC01-DATE.                                         *          
      ****************************************************************          
       COPY CPD00037.                                                           
                                                                        
      *************************************************************             
      *1000-MAIN-PROCESS-PARA                                    **             
      *************************************************************             
                                                                        
       1000-MAIN-PROCESS-PARA.                                          
                                                                        
           IF AGL-SUB-TYPE-CODE = WS-FDCG                               
              PERFORM 2000-GET-ACCOUNT-NO       THRU 2000-EXIT          
              IF NOT SKIP-ACCOUNT                                       
                 PERFORM 2100-CHECK-REG-ACCOUNT THRU 2100-EXIT          
                 PERFORM 2150-GET-FXD-FCTR-DTLS THRU 2150-EXIT          
                 PERFORM 2200-VALIDATION-INPUTS THRU 2200-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF AGL-FIOCA302-TRL = WS-TRAN-TRLR                           
              MOVE AGL-FIOCA302-TRL-REC-CNT  TO WS-AGL-TRL-COUNT-NUM    
              ADD  WS-AGL-TRL-COUNT-NUM      TO WS-TRL-REC-COUNT        
           END-IF                                                       
                                                                        
           PERFORM 0200-READ-FCSCA302           THRU 0200-EXIT.         
           MOVE 'N'                          TO WS-SKIP-ACCOUNT-SW.     
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *1400-PROCESS-COMMIT.                                          *          
      ****************************************************************          
       1400-PROCESS-COMMIT.                                             
                                                                        
           ADD +1                           TO WS-COMMIT-COUNTER.       
                                                                        
           IF WS-COMMITS-REQUIRE                                        
              AND WS-COMMIT-COUNTER >= WS-CHKP-LUW-LIMIT                
              PERFORM 8898-ISSUE-CHKP       THRU 8898-EXIT              
           END-IF.                                                      
      *                                                                         
       1400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *2000-GET-ACCOUNT-NO                                          **          
      ****************************************************************          
       2000-GET-ACCOUNT-NO.                                             
      *                                                                         
           PERFORM 7300-GET-CIS-ACCOUNT-NO      THRU 7300-EXIT.         
                                                                        
           IF NOT SKIP-ACCOUNT                                          
ACT003        EVALUATE WS-ACTIVE-RETURN-CODE                            
ACT003            WHEN SUCCESSFUL-CALL                                  
ACT003                 IF AT-CODE-ACCT-STAT  EQUAL WS-PENDING           
ACT003                    SET SKIP-ACCOUNT   TO TRUE                    
ACT003                 END-IF                                           
ACT003            WHEN NOT-FOUND                                        
ACT003                 SET SKIP-ACCOUNT      TO TRUE                    
ACT003                 IF CREATE-REPORT OR CREATE-TASK-AND-REPORT       
ACT003                    MOVE ZEROS         TO XM-ACCOUNT-NO           
ACT003                    MOVE SPACES        TO AT-BILL-CYCLE           
ACT003                    SET ACCOUNT-NOT-IN-CIS                        
ACT003                                       TO TRUE                    
ACT003                    MOVE 'Acct on AGL firm file but not in CIS.'  
ACT003                                       TO WS-ERROR-MESG           
ACT003                    MOVE ' Customer Name: '                       
ACT003                                       TO WS-ERROR-MESG(41:16)    
ACT003                    MOVE AGL-CUSTOMER-NAME                        
ACT003                                       TO WS-ERROR-MESG(57:56)    
ACT003                    PERFORM 2550-ERROR-PARA                       
ACT003                                          THRU 2550-EXIT          
ACT003                 END-IF                                           
ACT003            WHEN WS-811                                           
ACT003                 SET SKIP-ACCOUNT      TO TRUE                    
ACT003                 IF CREATE-REPORT OR CREATE-TASK-AND-REPORT       
ACT003                    MOVE ZEROS         TO XM-ACCOUNT-NO           
ACT003                    MOVE SPACES        TO AT-BILL-CYCLE           
ACT003                    SET MULTIPLE-CIS-ACCTS                        
ACT003                                       TO TRUE                    
ACT003                    MOVE 'Multiple Accts in CIS for AGL Acct No.' 
ACT003                                       TO WS-ERROR-MESG           
ACT003                    PERFORM 2550-ERROR-PARA                       
ACT003                                          THRU 2550-EXIT          
ACT003                 END-IF                                           
ACT003        END-EVALUATE                                              
ACT003     END-IF.                                                      
                                                                        
           IF NOT SKIP-ACCOUNT                                          
              MOVE XM-ACCOUNT-NO             TO FF-ACCOUNT-NO           
                                                LR-ACCOUNT-NO           
                                                YP-ACCOUNT-NO           
                                                AT-ACCOUNT-NO           
                                                UT-ACCOUNT-NO           
              IF AT-CODE-ACCT-STAT = WS-FINAL-BILLED                    
                 PERFORM 7325-CHECK-FINAL-BILLED                        
                                                THRU 7325-EXIT          
A04998           SET  FINAL-BILL             TO TRUE                    
                 MOVE 'Account on firm file but final billed in CIS.'   
                                             TO WS-ERROR-MESG           
                 MOVE 'Final bill date: '    TO WS-ERROR-MESG(51:17)    
                 IF AT-ACCT-FINALED-DT EQUAL                            
                                        '1900-01-01-00.00.00.000000'    
                    MOVE SPACES              TO WS-ERROR-MESG(68:10)    
                 ELSE                                                   
                    MOVE AT-ACCT-FINALED-DT (1:10)                      
                                             TO WS-ERROR-MESG(68:10)    
                 END-IF                                                 
                 MOVE ' Status Reason: '     TO WS-ERROR-MESG(78:16)    
                 MOVE SW-CODE-SHORT-DESC     TO WS-ERROR-MESG(94:15)    
                                                                        
                 MOVE ' Last read date: '    TO WS-ERROR-MESG(109:17)   
                 IF MN-LAST-REG-READ-DATE EQUAL '1900-01-01'            
                    MOVE SPACES              TO WS-ERROR-MESG(126:10)   
                 ELSE                                                   
                    MOVE MN-LAST-REG-READ-DATE                          
                                             TO WS-ERROR-MESG(126:10)   
                 END-IF                                                 
                 PERFORM 2550-ERROR-PARA        THRU 2550-EXIT          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *2100-CHECK-REG-ACCOUNT                                       **          
      ****************************************************************          
       2100-CHECK-REG-ACCOUNT.                                          
      *                                                                         
           PERFORM 7350-SELECT-REG-PROFILE      THRU 7350-EXIT.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               MOVE WS-REGULATED             TO WS-MKT-ID-CD            
           ELSE                                                         
               MOVE WS-DEREGULATED           TO WS-MKT-ID-CD            
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *2150-GET-FXD-FCTR-DTLS                                       **          
      ****************************************************************          
       2150-GET-FXD-FCTR-DTLS.                                          
      *                                                                         
           PERFORM 7150-OPEN-FXD-FCTR-CUR       THRU 7150-EXIT.         
           PERFORM 7175-FETCH-FXD-FCTR-CUR      THRU 7175-EXIT.         
                                                                        
           PERFORM UNTIL NO-MORE-ROWS                                   
              EVALUATE FF-FACTOR-ID                                     
                 WHEN WS-AGLSR-CUS                                      
                      SET AGLSR-CUS-EXIST    TO TRUE                    
ACT001                MOVE FF-EFF-DATE-FROM  TO WS-SRCUS-FCTR-STRT-DT   
                 WHEN WS-AGLSR-SOC                                      
                      SET AGLSR-SOC-EXIST    TO TRUE                    
ACT001                MOVE FF-EFF-DATE-FROM  TO WS-SRSOC-FCTR-STRT-DT   
                 WHEN WS-DDC                                            
                      MOVE FF-FACTOR         TO WS-CIS-DDC-FCTR         
                 WHEN WS-FAMUNITS                                       
                      SET FAMUNITS-EXIST     TO TRUE                    
                      MOVE FF-FACTOR         TO WS-CIS-FAMUNITS         
              END-EVALUATE                                              
                                                                        
              PERFORM 7175-FETCH-FXD-FCTR-CUR   THRU 7175-EXIT          
           END-PERFORM.                                                 
                                                                        
           PERFORM 7200-CLOSE-FXD-FCTR-CUR      THRU 7200-EXIT.         
      *                                                                         
       2150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      *2200-VALIDATION-INPUTS                                    **             
      *************************************************************             
       2200-VALIDATION-INPUTS.                                          
      *                                                                         
           PERFORM 2300-VALIDATE-AGLSR-DISCOUNT THRU 2300-EXIT.         
           PERFORM 2350-VALIDATE-DDC            THRU 2350-EXIT.         
           PERFORM 7550-GET-REVENUE-DIST        THRU 7550-EXIT.         
           PERFORM 2375-VALIDATE-FRNCHSE-DST    THRU 2375-EXIT.         
           IF FRNCHSE-DST-MAP-NOT-EXIST                                 
              PERFORM 2400-VALIDATE-COUNTY      THRU 2400-EXIT          
           END-IF.                                                      
           PERFORM 2425-VALIDATE-DELIVERY-GROUP THRU 2425-EXIT.         
           PERFORM 2450-VALIDATE-FAM-UNITS      THRU 2450-EXIT.         
A04998     PERFORM 7710-GET-METER-COUNT         THRU 7710-EXIT.         
A04998     IF WS-METER-COUNT <= 1                                       
              PERFORM 2500-VALIDATE-MTR-MLTPLR  THRU 2500-EXIT          
A04998     END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *2300-VALIDATE-AGLSR-DISCOUNT                                 **          
      ****************************************************************          
       2300-VALIDATE-AGLSR-DISCOUNT.                                    
      *                                                                         
           IF AGL-RATE-CODE EQUAL '121' OR '122' OR '123'               
              PERFORM 7500-GET-AGLSR-DISCOUNT   THRU 7500-EXIT          
              IF AGLSR-ACCOUNT-EXIST                                    
                 IF AGLSR-CUS-NOT-EXIST OR AGLSR-SOC-NOT-EXIST          
A04998              SET  AGL-SENIOR          TO TRUE                    
                    MOVE 'Account on Senior AGL Rate Code but one or mor        
      -                  'e Senior credit factor/s missing in CIS.'             
                                             TO WS-ERROR-MESG           
                    PERFORM 2550-ERROR-PARA     THRU 2550-EXIT          
                 END-IF                                                 
              ELSE                                                      
A04998           SET  AGL-SENIOR             TO TRUE                    
                 MOVE 'Account on AGL Senior Rate Code but AGL discount         
      -               'account attribute missing in CIS.'                       
                                             TO WS-ERROR-MESG           
                 PERFORM 2550-ERROR-PARA        THRU 2550-EXIT          
              END-IF                                                    
           ELSE                                                         
              IF AGLSR-CUS-EXIST OR AGLSR-SOC-EXIST                     
A04998           SET  AGL-SENIOR            TO TRUE                     
                 MOVE 'Account on non-senior AGL Rate code but has one o        
      -               'r more senior credit factor/s in CIS. '                  
                                            TO WS-ERROR-MESG            
ACT001           IF AGLSR-CUS-EXIST AND AGLSR-SOC-EXIST                 
ACT001              MOVE 'AGLSR CUS factor start date '                 
ACT001                                      TO WS-ERROR-MESG(88:28)     
ACT001              MOVE WS-SRCUS-FCTR-STRT-DT                          
ACT001                                      TO WS-ERROR-MESG(116:10)    
ACT001              MOVE '. AGLSR SOC factor start date '               
ACT001                                      TO WS-ERROR-MESG(126:30)    
ACT001              MOVE WS-SRSOC-FCTR-STRT-DT                          
ACT001                                      TO WS-ERROR-MESG(156:10)    
ACT001           ELSE                                                   
ACT001              EVALUATE TRUE                                       
ACT001                  WHEN AGLSR-CUS-EXIST                            
ACT001                     MOVE 'AGLSR CUS factor start date '          
ACT001                                      TO WS-ERROR-MESG(88:28)     
ACT001                     MOVE WS-SRCUS-FCTR-STRT-DT                   
ACT001                                      TO WS-ERROR-MESG(116:10)    
ACT001                  WHEN AGLSR-SOC-EXIST                            
ACT001                     MOVE 'AGLSR SOC factor start date '          
ACT001                                      TO WS-ERROR-MESG(88:28)     
ACT001                     MOVE WS-SRSOC-FCTR-STRT-DT                   
ACT001                                      TO WS-ERROR-MESG(116:10)    
ACT001              END-EVALUATE                                        
ACT001           END-IF                                                 
                                                                        
                 PERFORM 2550-ERROR-PARA        THRU 2550-EXIT          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *2350-VALIDATE-DDC                                            **          
      ****************************************************************          
       2350-VALIDATE-DDC.                                               
                                                                        
      * CONVERT THE DDC FACTOR TO DEKATHERMS FROM MCFS.                         
           COMPUTE WS-AGL-DDC-FCTR ROUNDED =                            
                         ( WS-AGL-DDC-FCTR * WS-DEKA-CONV-CONST ).      
      *                                                                         
           MOVE WS-AGL-DDC-FCTR              TO WS-AGL-DDC-FCTR-CMPR.   
           MOVE WS-AGL-DDC-FCTR-CMPR         TO WS-AGL-DDC-FCTR-TXT.    
           IF WS-AGL-DDC-FCTR-CMPR NOT EQUAL WS-CIS-DDC-FCTR            
A04998        SET  DDDC                      TO TRUE                    
              MOVE 'Designated Design Day Capacity mismatch.'           
                                             TO WS-ERROR-MESG           
              MOVE ' AGL DDDC : '            TO WS-ERROR-MESG(41:12)    
              MOVE AGL-DESIGN-DAY-USAGE      TO WS-ERROR-MESG(53:8)     
              MOVE ' x '                     TO WS-ERROR-MESG(61:3)     
              MOVE WS-DEKA-CONV-CONST-TXT    TO WS-ERROR-MESG(64:5)     
              MOVE ' = '                     TO WS-ERROR-MESG(69:3)     
              MOVE WS-AGL-DDC-FCTR-TXT       TO WS-ERROR-MESG(72:8)     
              MOVE WS-CIS-DDC-FCTR           TO WS-CIS-DDC-FCTR-TXT     
              MOVE ' CIS DDDC : '            TO WS-ERROR-MESG(80:12)    
              MOVE WS-CIS-DDC-FCTR-TXT       TO WS-ERROR-MESG(92:8)     
              PERFORM 2550-ERROR-PARA           THRU 2550-EXIT          
           END-IF.                                                      
      *                                                                         
       2350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *2375-VALIDATE-FRNCHSE-DST.                                    *          
      ****************************************************************          
       2375-VALIDATE-FRNCHSE-DST.                                       
      *                                                                         
           MOVE WS-AGL-FRN-DST-COUNTY        TO WS-MKT-ID-VALUE.        
                                                                        
           SET WS-CIS-CNTY-INDX              TO WS-ONE.                 
           SET FRNCHSE-DST-MAP-NOT-EXIST     TO TRUE.                   
                                                                        
           SEARCH WS-CIS-COUNTY-LST                                     
               AT END                                                   
                  CONTINUE                                              
             WHEN COUNTY-MKT-VAL-N-CD(WS-CIS-CNTY-INDX) =               
                                                WS-MKT-VALUE-N-CD       
                  SET FRNCHSE-DST-MAP-EXIST  TO TRUE                    
                  MOVE CNTY-CIS-VALUE(WS-CIS-CNTY-INDX)                 
                                             TO WS-AGL-CIS-COUNTY       
                  IF WS-AGL-CIS-COUNTY NOT EQUAL WS-CIS-COUNTY          
A04998               SET  FRANCHISE-DISTRICT TO TRUE                    
                     MOVE 'Franchise district mapping error. '          
                                             TO WS-ERROR-MESG           
                     MOVE 'Mapping : '       TO WS-ERROR-MESG(35:10)    
                     MOVE WS-AGL-CIS-COUNTY  TO WS-ERROR-MESG(45:3)     
                     MOVE ' CIS Revenue District : '                    
                                             TO WS-ERROR-MESG(48:24)    
                     MOVE WS-CIS-COUNTY      TO WS-ERROR-MESG(72:3)     
                     PERFORM 2550-ERROR-PARA    THRU 2550-EXIT          
                  END-IF                                                
           END-SEARCH.                                                  
      *                                                                         
       2375-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *2400-VALIDATE-COUNTY                                          *          
      ****************************************************************          
       2400-VALIDATE-COUNTY.                                            
      *                                                                         
           MOVE WS-AGL-COUNTY                TO WS-MKT-ID-VALUE.        
                                                                        
           SET WS-CIS-CNTY-INDX              TO WS-ONE.                 
                                                                        
           SEARCH WS-CIS-COUNTY-LST                                     
               AT END                                                   
A04998            SET  REVENUE-DISTRICT      TO TRUE                    
                  MOVE 'Mapping not found for AGL county code '         
                                             TO WS-ERROR-MESG           
                  MOVE WS-AGL-COUNTY         TO WS-ERROR-MESG(39:3)     
                  PERFORM 2550-ERROR-PARA       THRU 2550-EXIT          
             WHEN COUNTY-MKT-VAL-N-CD(WS-CIS-CNTY-INDX) =               
                                                WS-MKT-VALUE-N-CD       
                  MOVE CNTY-CIS-VALUE(WS-CIS-CNTY-INDX)                 
                                             TO WS-AGL-CIS-COUNTY       
                  IF WS-AGL-CIS-COUNTY NOT EQUAL WS-CIS-COUNTY          
A04998               SET  REVENUE-DISTRICT   TO TRUE                    
                     MOVE 'County/Revenue district mapping error.'      
                                             TO WS-ERROR-MESG           
                     MOVE ' Mapping : '      TO WS-ERROR-MESG(39:11)    
                     MOVE WS-AGL-CIS-COUNTY  TO WS-ERROR-MESG(50:3)     
                     MOVE ' CIS Revenue District : '                    
                                             TO WS-ERROR-MESG(53:24)    
                     MOVE WS-CIS-COUNTY      TO WS-ERROR-MESG(77:3)     
                     PERFORM 2550-ERROR-PARA    THRU 2550-EXIT          
                  END-IF                                                
           END-SEARCH.                                                  
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *2425-VALIDATE-DELIVERY-GROUP.                                **          
      ****************************************************************          
       2425-VALIDATE-DELIVERY-GROUP.                                    
      *                                                                         
           MOVE AGL-DELIVERY-GRP             TO WS-MKT-ID-VALUE.        
                                                                        
           SET WS-POOL-GRP-INDX              TO WS-ONE.                 
                                                                        
           SEARCH WS-CIS-POOL-GRP-LST                                   
               AT END                                                   
A04998            SET  POOL-GROUP            TO TRUE                    
                  MOVE 'Mapping not found for AGL delivery group '      
                                             TO WS-ERROR-MESG           
                  MOVE AGL-DELIVERY-GRP      TO WS-ERROR-MESG(42:3)     
                  PERFORM 2550-ERROR-PARA       THRU 2550-EXIT          
             WHEN POOL-GRP-MKT-VAL-N-CD(WS-POOL-GRP-INDX) =             
                                                WS-MKT-VALUE-N-CD       
                  MOVE POOL-CIS-VALUE(WS-POOL-GRP-INDX)                 
                                             TO WS-AGL-CIS-POOL-GRP     
                  IF WS-AGL-CIS-POOL-GRP NOT EQUAL WS-CIS-LOCAL-OFFICE  
A04998               SET  POOL-GROUP         TO TRUE                    
                     MOVE 'Delivery/Pool group mapping error.'          
                                             TO WS-ERROR-MESG           
                     MOVE ' Mapping : '      TO WS-ERROR-MESG(35:11)    
                     MOVE POOL-CIS-VALUE(WS-POOL-GRP-INDX)              
                                             TO WS-ERROR-MESG(46:3)     
                     MOVE ' CIS Local Office : '                        
                                             TO WS-ERROR-MESG(49:20)    
                     MOVE WS-CIS-LOCAL-OFFICE                           
                                             TO WS-ERROR-MESG(69:3)     
                     PERFORM 2550-ERROR-PARA    THRU 2550-EXIT          
                  END-IF                                                
           END-SEARCH.                                                  
      *                                                                         
       2425-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *2450-VALIDATE-FAM-UNITS                                      **          
      ****************************************************************          
       2450-VALIDATE-FAM-UNITS.                                         
      *                                                                         
           IF FAMUNITS-EXIST OR WS-AGL-FAMUNITS > 1                     
              IF WS-AGL-FAMUNITS NOT EQUAL WS-CIS-FAMUNITS              
A04998           SET  FAMILY-UNITS             TO TRUE                  
                 MOVE 'Family units mismatch.' TO WS-ERROR-MESG         
                 MOVE ' AGL value : '          TO WS-ERROR-MESG(23:13)  
                 MOVE AGL-FAM-UNITS            TO WS-ERROR-MESG(36:3)   
                 MOVE ' CIS value : '          TO WS-ERROR-MESG(39:13)  
                 MOVE WS-CIS-FAMUNITS          TO WS-CIS-FAMUNITS-TXT   
                 MOVE WS-CIS-FAMUNITS-TXT      TO WS-ERROR-MESG(52:6)   
                 PERFORM 2550-ERROR-PARA          THRU 2550-EXIT        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *2500-VALIDATE-MTR-MLTPLR                                      *          
      ****************************************************************          
       2500-VALIDATE-MTR-MLTPLR.                                        
      *                                                                         
           PERFORM 7700-VALIDATE-MTR-MLTPLR     THRU 7700-EXIT          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
A04998        SET  METER-CONSTANT         TO TRUE                       
              MOVE 'Failed to verify meter constant.'                   
                                          TO WS-ERROR-MESG              
              PERFORM 2550-ERROR-PARA        THRU 2550-EXIT             
           ELSE                                                         
              IF WS-AGL-MTR-MULTPLR NOT EQUAL WS-CIS-MTR-MULTPLR        
                 SET  METER-CONSTANT      TO TRUE                       
                 MOVE 'Meter multiplier mismatch.'                      
                                          TO WS-ERROR-MESG              
                 MOVE ' AGL value : '     TO WS-ERROR-MESG(27:13)       
                 MOVE AGL-METER-MULTIPLIER                              
                                          TO WS-ERROR-MESG(40:10)       
                 MOVE ' CIS value : '     TO WS-ERROR-MESG(50:13)       
                 MOVE WS-CIS-MTR-MULTPLR  TO WS-CIS-MTR-MULTPLR-TXT     
                 MOVE WS-CIS-MTR-MULTPLR-TXT                            
                                          TO WS-ERROR-MESG(63:10)       
                 PERFORM 2550-ERROR-PARA     THRU 2550-EXIT             
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *2550-ERROR-PARA.                                             *           
      ****************************************************************          
       2550-ERROR-PARA.                                                 
      *                                                                         
           EVALUATE TRUE                                                
               WHEN CREATE-TASK                                         
                  PERFORM 2600-CREATE-TASK      THRU 2600-EXIT          
                                                                        
               WHEN CREATE-REPORT                                       
                  IF WS-FLRP302-REC-CNTR EQUAL 0                        
                     WRITE FIORP302-REC  FROM WS-RP302-HDR-REC          
                  END-IF                                                
                  PERFORM 2800-MOVE-ERROR-PARA  THRU 2800-EXIT          
                  PERFORM 8000-WRITE-ERROR-FILE THRU 8000-EXIT          
                                                                        
               WHEN CREATE-TASK-AND-REPORT                              
A04998            IF AGL-SENIOR OR DDDC OR FAMILY-UNITS                 
ACT002               OR METER-CONSTANT  OR POOL-GROUP                   
A04998               PERFORM 2600-CREATE-TASK   THRU 2600-EXIT          
A04998            END-IF                                                
                  IF WS-FLRP302-REC-CNTR EQUAL 0                        
                     WRITE FIORP302-REC  FROM WS-RP302-HDR-REC          
                  END-IF                                                
                  PERFORM 2800-MOVE-ERROR-PARA  THRU 2800-EXIT          
                  PERFORM 8000-WRITE-ERROR-FILE THRU 8000-EXIT          
           END-EVALUATE.                                                
      *                                                                         
       2550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *2600-CREATE-TASK                                              *          
      ****************************************************************          
       2600-CREATE-TASK.                                                
      *                                                                         
           INITIALIZE CWS00077-FIELDS.                                  
                                                                        
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE XM-ACCOUNT-NO                TO WS-77-ACCOUNT-NO.       
           MOVE WS-CURRENT-TIMESTAMP         TO WS-77-DATE-CREATED      
                                                WS-77-DATE-REQUIRED.    
           MOVE +577                         TO WS-77-CATEGORY-ID.      
           MOVE 'H'                          TO WS-77-PRIORITY.         
           MOVE '4'                          TO WS-77-ROUTE-CATEGORY.   
           MOVE WS-ERROR-MESG                TO WS-77-COMMENTS-TEXT.    
                                                                        
           COMPUTE WS-77-COMMENTS-LEN EQUAL LENGTH OF WS-ERROR-MESG.    
                                                                        
           MOVE WS-PGRMNAME                  TO WS-77-CREATED-BY        
           MOVE 'SYSTEM'                     TO WS-77-USER-ID-ORIG      
                                                                        
           PERFORM 6000-INSERT-WORK-QUEUE      THRU 6000-EXIT.          
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *2800-MOVE-ERROR-PARA                                          *          
      ****************************************************************          
       2800-MOVE-ERROR-PARA.                                            
      *                                                                         
           MOVE XM-ACCOUNT-NO                TO E-ACCOUNT-NO.           
           MOVE AT-BILL-CYCLE                TO E-BILL-CYCLE.           
           MOVE AGL-DIST-ACCOUNT-NO          TO E-DIST-ACCOUNT-NO.      
           MOVE AGL-RATE-CODE                TO E-RATE-CODE.            
           MOVE AGL-DESIGN-DAY-USAGE         TO E-DESIGN-DAY-USAGE.     
           MOVE AGL-BILL-MONTH               TO E-BILL-MONTH.           
           MOVE AGL-COUNTY                   TO E-COUNTY.               
           MOVE AGL-FAM-UNITS                TO E-FAM-UNITS.            
           MOVE AGL-METER-MULTIPLIER         TO E-METER-MULTIPLIER.     
           MOVE AGL-DELIVERY-GRP             TO E-AGL-DELIVERY-GROUP.   
           MOVE AGL-FRANCHISE-DISTRICT       TO E-AGL-FRANCHISE-DIST.   
           MOVE WS-ERROR-MESG-CODE           TO E-FLRP302-MESG-CODE.    
           MOVE WS-ERROR-MESG                TO E-FLRP302-DATA-MESG.    
           MOVE ','                          TO E-RP302-FILLER-01       
                                                E-RP302-FILLER-02       
                                                E-RP302-FILLER-03       
                                                E-RP302-FILLER-04       
                                                E-RP302-FILLER-05       
                                                E-RP302-FILLER-06       
                                                E-RP302-FILLER-07       
                                                E-RP302-FILLER-08       
                                                E-RP302-FILLER-09       
                                                E-RP302-FILLER-10       
                                                E-RP302-FILLER-11       
                                                E-RP302-FILLER-12.      
      *                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *5900-PROCESS-SUCCESSFUL-JOB                                   *          
      ****************************************************************          
       5900-PROCESS-SUCCESSFUL-JOB.                                     
      *                                                                         
           IF WS-TRL-REC-COUNT NOT EQUAL WS-FLCA302-REC-CNTR            
              DISPLAY ' RECORD COUNT MISMATCH ERROR '                   
           END-IF.                                                      
                                                                        
           MOVE SPACES                       TO WS-RESTART-JOB-COMPLETE.
           IF  WS-THIS-IS-A-RESTART                                     
               SET WS-RERUN-COMPLETED        TO TRUE                    
           ELSE                                                         
               SET WS-RUN-COMPLETED-NO-PROBLEMS TO TRUE                 
           END-IF.                                                      
                                                                        
           IF CREATE-TASK OR CREATE-TASK-AND-REPORT                     
              PERFORM 8899-WRITE-RSDDR          THRU 8899-EXIT          
           END-IF.                                                      
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
                                                                        
           IF  WS-RESTART-REQ EQUAL WS-YES                              
               PERFORM 8893-RESET-RESTART-REQ-PARM                      
                                                THRU 8893-EXIT          
           END-IF.                                                      
                                                                        
           IF CREATE-TASK                                               
              DISPLAY '*******************************************'     
              DISPLAY '** READ RECORDS FROM INPUT FILE:'                
                                                  WS-FLCA302-REC-CNTR   
              DISPLAY '** WRITTEN RECORDS INTO WORK QUEUE:'             
                                                  WS-WORK-QUEUE-CNTR    
              DISPLAY '*******************************************'     
           END-IF.                                                      
                                                                        
           IF CREATE-REPORT                                             
              DISPLAY '*******************************************'     
              DISPLAY '** READ RECORDS FROM INPUT FILE:'                
                                                  WS-FLCA302-REC-CNTR   
              DISPLAY '** WRITTEN RECORDS INTO ERROR FILE'              
                                                  WS-FLRP302-REC-CNTR   
              DISPLAY '*******************************************'     
           END-IF.                                                      
                                                                        
           IF CREATE-TASK-AND-REPORT                                    
              DISPLAY '*******************************************'     
              DISPLAY '** READ RECORDS FROM INPUT FILE:'                
                                                  WS-FLCA302-REC-CNTR   
              DISPLAY '** WRITTEN RECORDS INTO WORK QUEUE:'             
                                                  WS-WORK-QUEUE-CNTR    
              DISPLAY '** WRITTEN RECORDS INTO ERROR FILE'              
                                                  WS-FLRP302-REC-CNTR   
              DISPLAY '*******************************************'     
           END-IF.                                                      
      *                                                                         
       5900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   6000-INSERT-WORK-QUEUE.                                      *        
      * INSERT THE WORK QUEUE ITEMS IN THE CSS_WQ_ITEMS TABLE.         *        
      ******************************************************************        
      *                                                                         
       6000-INSERT-WORK-QUEUE.                                          
      *                                                                         
           CALL SCSCB077 USING CWS00077-FIELDS,                         
                               ABEND-FILE,                              
                               RS-RETURN-CODE                           
           MOVE RS-RETURN-CODE               TO WS-ACTIVE-RETURN-CODE   
      *                                                                         
           IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
              DISPLAY '6000-INSERT-WORK-QUEUE'                          
              DISPLAY 'CALL SCSCB077         '                          
              DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           ELSE                                                         
              ADD +1                         TO WS-WORK-QUEUE-CNTR      
              PERFORM 1400-PROCESS-COMMIT       THRU 1400-EXIT          
           END-IF.                                                      
      *                                                                         
       6000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *6235-GET-FJC01-RESTART-REQ                                    *          
      ****************************************************************          
       COPY CPD00035.                                                           
                                                                        
      ****************************************************************          
      *6253-GET-FJC01-CHKP-LIMIT                                     *          
      ****************************************************************          
       COPY CPD00034.                                                           
                                                                        
      ****************************************************************          
      *7000-READ-FCSCA302                                           **          
      ****************************************************************          
       7000-READ-FCSCA302.                                              
                                                                        
           READ FCSCA302-FILE                                           
                AT END                                                  
                         MOVE WS-NO          TO WS-MORE-DATA-SW         
                         GO                  TO 7000-EXIT.              
           IF FLCA302-SUCCESSFUL                                        
              IF AGL-SUB-TYPE-CODE = WS-FDCG                            
                 ADD 1                       TO WS-FLCA302-REC-CNTR     
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSCA302 ABORT ****************'      
              DISPLAY '**  PARA  7000-READ-FCSCA302            **'      
              DISPLAY '**  READ ERROR OF FCSCA302 - INPUT FILE **'      
              DISPLAY '**         FILE STATUS = ' WS-FLCA302-STATUS     
              DISPLAY '**         PROCESSING TERMINATED        **'      
              DISPLAY '********** PCSCA302 ABORT ****************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      *7050-PROCESS-PARM-FLAG                                    **             
      *************************************************************             
       7050-PROCESS-PARM-SW.                                            
      *                                                                         
           EXEC SQL                                                     
                SELECT G6.PARM_DATA                                     
                  INTO :G6-PARM-DATA                                    
                  FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                    
                 WHERE G6.PROGRAM_NAME = :WS-PGRMNAME                   
                   AND G6.COMPANY_NO   = '01'                           
                   AND G6.CMND_CODE    = 'PARM'                         
                   AND G6.STATUS       = 'A'                            
                   AND G6.SEQ_NO       =  2                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT G6.PARM_DATA                                             
MFA-TR*           INTO :G6-PARM-DATA                                            
MFA-TR*           FROM CSS_JOB_PARM G6                                          
MFA-TR*          WHERE G6.PROGRAM_NAME = :WS-PGRMNAME                           
MFA-TR*            AND G6.COMPANY_NO   = '01'                                   
MFA-TR*            AND G6.CMND_CODE    = 'PARM'                                 
MFA-TR*            AND G6.STATUS       = 'A'                                    
MFA-TR*            AND G6.SEQ_NO       =  2                                     
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7050                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE G6-PARM-DATA             TO WS-PARM-DATA             
           ELSE                                                         
              DISPLAY '********** PCSCA302 ABORT ****************'      
              DISPLAY '**  IN 7050-PROCESS-PARM-FLAG           **'      
              DISPLAY '**  PROGRAM-NAME = ' WS-PGRMNAME                 
              DISPLAY '**  SQL CODE    = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**         PROCESSING TERMINATED        **'      
              DISPLAY '********** PCSCA302 ABORT ****************'      
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      *7100-SELECT-DLQ-VAL                                           *          
      ****************************************************************          
       7100-SELECT-DLQ-VAL.                                             
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                   
               WHERE DELINQ_CD  = :C8-DELINQ-CD                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY C8                                         
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA302 ABORT ****************'      
              DISPLAY '** SELECT ERROR IN 7100-SELECT-DLQ-VAL  **'      
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '**         PROCESSING TERMINATED        **'      
              DISPLAY '********** PCSCA302 ABORT ****************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *7150-OPEN-FXD-FCTR-CUR                                       **          
      ****************************************************************          
       7150-OPEN-FXD-FCTR-CUR.                                          
      *                                                                         
           EXEC SQL                                                     
               OPEN FXD_FCTR_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA302 ABORT ****************'      
              DISPLAY '* ABEND IN 7150-OPEN-FXD-FCTR-CUR       **'      
              DISPLAY '* FXD_FCTR_CSR OPEN ERROR               **'      
              DISPLAY '* SQL RETURN CODE     = ' WS-ACTIVE-RETURN-CODE  
              DISPLAY '* PROCESSING TERMINATED                 **'      
              DISPLAY '********** PCSCA302 ABORT ****************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *7175-FETCH-FXD-FCTR-CUR                                      **          
      ****************************************************************          
       7175-FETCH-FXD-FCTR-CUR.                                         
      *                                                                         
           EXEC SQL                                                     
               FETCH FXD_FCTR_CSR                                       
                INTO :FF-FACTOR-ID                                      
                    ,:FF-FACTOR                                         
                    ,:FF-EFF-DATE-FROM                                  
                    ,:FF-EFF-DATE-TO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES                 TO   WS-NO-MORE-ROWS       
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSCA302 ABORT ****************'      
              DISPLAY '* ABEND IN 7175-FETCH-FXD-FCTR-CUR      **'      
              DISPLAY '* ACCOUNT_NO          = ' FF-ACCOUNT-NO          
              DISPLAY '* EFF-DATE-TO         = ' FF-EFF-DATE-TO         
              DISPLAY '* SQL RETURN CODE     = ' WS-ACTIVE-RETURN-CODE  
              DISPLAY '* PROCESSING TERMINATED                 **'      
              DISPLAY '********** PCSCA302 ABORT ****************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7175-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *7200-CLOSE-FXD-FCTR-CUR                                      **          
      ****************************************************************          
       7200-CLOSE-FXD-FCTR-CUR.                                         
      *                                                                         
           EXEC SQL                                                     
               CLOSE FXD_FCTR_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '********** PCSCA302 ABORT ****************'      
              DISPLAY '* ABEND IN 7200-CLOSE-FXD-FCTR-CUR      **'      
              DISPLAY '* SQL RETURN CODE     = ' WS-ACTIVE-RETURN-CODE  
              DISPLAY '* PROCESSING TERMINATED                 **'      
              DISPLAY '********** PCSCA302 ABORT ****************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *7225-OPEN-MKT-VAL-TRANS.                                     **          
      ****************************************************************          
       7225-OPEN-MKT-VAL-TRANS.                                         
      *                                                                         
           EXEC SQL                                                     
               OPEN MKT_TRAN_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '********** PCSCA302 ABORT ****************'      
              DISPLAY '* ABEND IN 7225-OPEN-MKT-VAL-TRANS      **'      
              DISPLAY '* MKT_TRAN_CSR OPEN ERROR               **'      
              DISPLAY '* SQL RETURN CODE     = ' WS-ACTIVE-RETURN-CODE  
              DISPLAY '* PROCESSING TERMINATED                 **'      
              DISPLAY '********** PCSCA302 ABORT ****************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7225-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *7250-FETCH-MKT-VAL-TRANS.                                    **          
      ****************************************************************          
       7250-FETCH-MKT-VAL-TRANS.                                        
      *                                                                         
           EXEC SQL                                                     
               FETCH MKT_TRAN_CSR                                       
                INTO :V5-MKT-ID-VALUE                                   
                    ,:V5-MKT-ID-CD                                      
                    ,:V5-CIS-VALUE                                      
                    ,:V5-VALUE-ID                                       
                    ,:V5-VALUE-ID-DESC                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES                 TO   WS-NO-MORE-ROWS       
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSCA302 ABORT ****************'      
              DISPLAY '* ABEND IN 7250-FETCH-MKT-VAL-TRANS     **'      
              DISPLAY '* VALUE_ID_DESC       = ' V5-VALUE-ID-DESC       
              DISPLAY '* VALUE_ID            = ' V5-VALUE-ID            
              DISPLAY '* SQL RETURN CODE     = ' WS-ACTIVE-RETURN-CODE  
              DISPLAY '* PROCESSING TERMINATED                 **'      
              DISPLAY '********** PCSCA302 ABORT ****************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *7275-CLOSE-MKT-VAL-TRANS.                                    **          
      ****************************************************************          
       7275-CLOSE-MKT-VAL-TRANS.                                        
      *                                                                         
           EXEC SQL                                                     
               CLOSE MKT_TRAN_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '********** PCSCA302 ABORT ****************'      
              DISPLAY '* ABEND IN 7275-CLOSE-MKT-VAL-TRANS     **'      
              DISPLAY '* SQL RETURN CODE     = ' WS-ACTIVE-RETURN-CODE  
              DISPLAY '* PROCESSING TERMINATED                 **'      
              DISPLAY '********** PCSCA302 ABORT ****************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7275-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *7300-GET-CIS-ACCOUNT-NO                                      **          
      ****************************************************************          
       7300-GET-CIS-ACCOUNT-NO.                                         
      *                                                                         
           EXEC SQL                                                     
                SELECT  XM.ACCOUNT_NO                                   
                      , AT.CODE_ACCT_STAT                               
                      , AT.BILL_CYCLE                                   
                  INTO :XM-ACCOUNT-NO                                   
                      ,:AT-CODE-ACCT-STAT                               
                      ,:AT-BILL-CYCLE                                   
                  FROM  CSS_MKT_XREF_ACCT  XM WITH(READUNCOMMITTED)             
                      , CSS_ACCOUNT        AT WITH(READUNCOMMITTED)             
                 WHERE  XM.DIST_ACCT_NO = :XM-DIST-ACCT-NO              
                   AND  XM.ACCOUNT_NO   =  AT.ACCOUNT_NO                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  XM.ACCOUNT_NO                                           
MFA-TR*               , AT.CODE_ACCT_STAT                                       
MFA-TR*               , AT.BILL_CYCLE                                           
MFA-TR*           INTO :XM-ACCOUNT-NO                                           
MFA-TR*               ,:AT-CODE-ACCT-STAT                                       
MFA-TR*               ,:AT-BILL-CYCLE                                           
MFA-TR*           FROM  CSS_MKT_XREF_ACCT  XM                                   
MFA-TR*               , CSS_ACCOUNT        AT                                   
MFA-TR*          WHERE  XM.DIST_ACCT_NO = :XM-DIST-ACCT-NO                      
MFA-TR*            AND  XM.ACCOUNT_NO   =  AT.ACCOUNT_NO                        
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT003                                OR WS-811                         
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA302 ABORT *******************'   
              DISPLAY '** SELECT ERROR IN 7300-GET-CIS-ACCOUNT-NO **'   
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '** ACCOUNT-NO  = ' XM-DIST-ACCT-NO               
              DISPLAY '**         PROCESSING TERMINATED           **'   
              DISPLAY '********** PCSCA302 ABORT *******************'   
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *7325-CHECK-FINAL-BILLED                                      **          
      ****************************************************************          
       7325-CHECK-FINAL-BILLED.                                         
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           COALESCE(AT.ACCT_FINALED_DT,                       
                             CIS.CHAR2TIMESTAMP(
              '1900-01-01-00.00.00.000000')), 121), ' ', '-'), ':', 
           '.'),
              COALESCE(LTRIM(RTRIM(SW.CODE_SHORT_DESC)),                 
                             '               '),
              COALESCE(MN.LAST_REG_READ_DATE,                    
                             IIF(TRY_CONVERT(DATE, '1900-01-01'
              ) IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') ))                    
                  INTO :AT-ACCT-FINALED-DT                              
                      ,:SW-CODE-SHORT-DESC                              
                      ,:MN-LAST-REG-READ-DATE                           
                  FROM CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                
                  LEFT JOIN                                             
                       CSS_SO_CODE_DESC SW WITH(READUNCOMMITTED)                
                    ON SW.CODE_VALUE     =  AT.CODE_STATUS_REASON       
                   AND SW.TABLE_NA       = 'CSS_ACCOUNT'                
                   AND SW.COLUMN_NA      = 'CODE_STATUS_REASON'         
                  JOIN CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                
                    ON MN.ACCOUNT_NO     =  AT.ACCOUNT_NO               
                 WHERE AT.ACCOUNT_NO     = :AT-ACCOUNT-NO               
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT IFNULL(AT.ACCT_FINALED_DT,                               
MFA-TR*                      '1900-01-01-00.00.00.000000')                      
MFA-TR*               ,IFNULL(TRIM(SW.CODE_SHORT_DESC),                         
MFA-TR*                      '               ')                                 
MFA-TR*               ,IFNULL(MN.LAST_REG_READ_DATE,                            
MFA-TR*                      '1900-01-01')                                      
MFA-TR*           INTO :AT-ACCT-FINALED-DT                                      
MFA-TR*               ,:SW-CODE-SHORT-DESC                                      
MFA-TR*               ,:MN-LAST-REG-READ-DATE                                   
MFA-TR*           FROM CSS_ACCOUNT      AT                                      
MFA-TR*           LEFT JOIN                                                     
MFA-TR*                CSS_SO_CODE_DESC SW                                      
MFA-TR*             ON SW.CODE_VALUE     =  AT.CODE_STATUS_REASON               
MFA-TR*            AND SW.TABLE_NA       = 'CSS_ACCOUNT'                        
MFA-TR*            AND SW.COLUMN_NA      = 'CODE_STATUS_REASON'                 
MFA-TR*           JOIN CSS_MTRD_ENVRNMT MN                                      
MFA-TR*             ON MN.ACCOUNT_NO     =  AT.ACCOUNT_NO                       
MFA-TR*          WHERE AT.ACCOUNT_NO     = :AT-ACCOUNT-NO                       
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7325                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE SPACES              TO SW-CODE-SHORT-DESC      
                    MOVE '1900-01-01-00.00.00.000000'                   
                                             TO AT-ACCT-FINALED-DT      
                    MOVE '1900-01-01'        TO MN-LAST-REG-READ-DATE   
               WHEN OTHER                                               
                    DISPLAY '*********** PCSCA302 ABORT ***************'
                    DISPLAY '** SELECT ERROR 7325-CHECK-FINAL-BILLED **'
                    DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
                    DISPLAY '** ACCOUNT-NO  = ' AT-ACCOUNT-NO           
                    DISPLAY '**         PROCESSING TERMINATED        **'
                    DISPLAY '*********** PCSCA302 ABORT ***************'
                    PERFORM 9900-ABEND          THRU 9900-EXIT          
           END-EVALUATE.                                                
      *                                                                         
       7325-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *7350-SELECT-REG-PROFILE                                      **          
      ****************************************************************          
       7350-SELECT-REG-PROFILE.                                         
      *                                                                         
           EXEC SQL                                                     
                SELECT CUSTOMER_NO                                      
                  INTO :LR-CUSTOMER-NO                                  
                  FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                    
                 WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT CUSTOMER_NO                                              
MFA-TR*           INTO :LR-CUSTOMER-NO                                          
MFA-TR*           FROM CSS_REG_PROFILE                                          
MFA-TR*          WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                              
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7350                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA302 ABORT *******************'   
              DISPLAY '** SELECT ERROR IN 7350-SELECT-REG-PROFILE **'   
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '** ACCOUNT-NO  = ' LR-ACCOUNT-NO                 
              DISPLAY '**         PROCESSING TERMINATED           **'   
              DISPLAY '********** PCSCA302 ABORT *******************'   
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *7500-GET-AGLSR-DISCOUT                                       **          
      ****************************************************************          
       7500-GET-AGLSR-DISCOUNT.                                         
      *                                                                         
           EXEC SQL                                                     
                SELECT ATTRIBUTE_VALUE_CD                               
                  INTO :YP-ATTRIBUTE-VALUE-CD                           
                  FROM CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                 
                 WHERE ATTRIBUTE_DESC     = :WS-CIS-AGL-DISCNT-SR       
                   AND ACCOUNT_NO         = :YP-ACCOUNT-NO              
                   AND ATTRIBUTE_VALUE_CD = 'YES'                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT ATTRIBUTE_VALUE_CD                                       
MFA-TR*           INTO :YP-ATTRIBUTE-VALUE-CD                                   
MFA-TR*           FROM CSS_ACCT_ATTRIBUTE                                       
MFA-TR*          WHERE ATTRIBUTE_DESC     = :WS-CIS-AGL-DISCNT-SR               
MFA-TR*            AND ACCOUNT_NO         = :YP-ACCOUNT-NO                      
MFA-TR*            AND ATTRIBUTE_VALUE_CD = 'YES'                               
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7500                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 SET AGLSR-ACCOUNT-EXIST     TO TRUE                    
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSCA302 ABORT ******************'    
              DISPLAY '** SELECT ERROR IN 7500-GET-AGLSR-DISCOUNT**'    
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '** ACCOUNT-NO  = ' YP-ACCOUNT-NO                 
              DISPLAY '**         PROCESSING TERMINATED          **'    
              DISPLAY '********** PCSCA302 ABORT ******************'    
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *7550-GET-REVENUE-DIST                                         *          
      ****************************************************************          
       7550-GET-REVENUE-DIST.                                           
                                                                        
           EXEC SQL                                                     
              SELECT PR.LOCAL_OFFICE                                    
                    ,PR.REV_DISTRICT_CD                                 
                INTO :WS-CIS-LOCAL-OFFICE                               
                    ,:WS-CIS-COUNTY                                     
                FROM CSS_PREMISE PR WITH(READUNCOMMITTED)                       
                    ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE PR.PREMISE_NO      =  AT.PREMISE_NO                
                 AND AT.ACCOUNT_NO      = :AT-ACCOUNT-NO                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PR.LOCAL_OFFICE                                            
MFA-TR*             ,PR.REV_DISTRICT_CD                                         
MFA-TR*         INTO :WS-CIS-LOCAL-OFFICE                                       
MFA-TR*             ,:WS-CIS-COUNTY                                             
MFA-TR*         FROM CSS_PREMISE PR                                             
MFA-TR*             ,CSS_ACCOUNT AT                                             
MFA-TR*        WHERE PR.PREMISE_NO      =  AT.PREMISE_NO                        
MFA-TR*          AND AT.ACCOUNT_NO      = :AT-ACCOUNT-NO                        
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7550                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA302 ABORT ******************'    
              DISPLAY '** SELECT ERROR IN 7550-GET-REVENUE-DIST  **'    
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '** ACCOUNT-NO  = ' AT-ACCOUNT-NO                 
              DISPLAY '**         PROCESSING TERMINATED          **'    
              DISPLAY '********** PCSCA302 ABORT ******************'    
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  7600-START-FCSJC01                                          *          
      *  7610-READ-FCSJC01                                           *          
      *  7611-CLOSE                                                  *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *7700-VALIDATE-MTR-MLTPLR                                      *          
      ****************************************************************          
       7700-VALIDATE-MTR-MLTPLR.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) MC.CONSTANT,
              UT.IC_NO,
              MN.METER_NO,
              MN.MTR_REF_NO                                      
                INTO :WS-CIS-MTR-MULTPLR                                
                    ,:MN-IC-NO                                          
                    ,:MN-METER-NO                                       
                    ,:MN-MTR-REF-NO                                     
                FROM CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                  
                    ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
                    ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                  
                    ,CSS_MTR_CAP      MC WITH(READUNCOMMITTED)                  
               WHERE UT.ACCOUNT_NO      =  AT.ACCOUNT_NO                
                 AND MN.ACCOUNT_NO      =  UT.ACCOUNT_NO                
                 AND MN.CODE_UTIL_TYPE  =  UT.CODE_UTIL_TYPE            
                 AND MN.IC_NO           =  UT.IC_NO                     
                 AND MC.CODE_UTIL_TYPE  =  MN.CODE_UTIL_TYPE            
                 AND MC.METER_NO        =  MN.METER_NO                  
                 AND AT.ACCOUNT_NO      = :AT-ACCOUNT-NO                
                 AND UT.CODE_UTIL_TYPE  = 'G'                           
                 AND MC.COMPANY_NO      = '01'                          
               ORDER BY MN.DATE_MTR_INSTALL DESC                        
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MC.CONSTANT                                                
MFA-TR*             ,UT.IC_NO                                                   
MFA-TR*             ,MN.METER_NO                                                
MFA-TR*             ,MN.MTR_REF_NO                                              
MFA-TR*         INTO :WS-CIS-MTR-MULTPLR                                        
MFA-TR*             ,:MN-IC-NO                                                  
MFA-TR*             ,:MN-METER-NO                                               
MFA-TR*             ,:MN-MTR-REF-NO                                             
MFA-TR*         FROM CSS_ACCOUNT      AT                                        
MFA-TR*             ,CSS_UTIL_ENVRNMT UT                                        
MFA-TR*             ,CSS_MTRD_ENVRNMT MN                                        
MFA-TR*             ,CSS_MTR_CAP      MC                                        
MFA-TR*        WHERE UT.ACCOUNT_NO      =  AT.ACCOUNT_NO                        
MFA-TR*          AND MN.ACCOUNT_NO      =  UT.ACCOUNT_NO                        
MFA-TR*          AND MN.CODE_UTIL_TYPE  =  UT.CODE_UTIL_TYPE                    
MFA-TR*          AND MN.IC_NO           =  UT.IC_NO                             
MFA-TR*          AND MC.CODE_UTIL_TYPE  =  MN.CODE_UTIL_TYPE                    
MFA-TR*          AND MC.METER_NO        =  MN.METER_NO                          
MFA-TR*          AND AT.ACCOUNT_NO      = :AT-ACCOUNT-NO                        
MFA-TR*          AND UT.CODE_UTIL_TYPE  = 'G'                                   
MFA-TR*          AND MC.COMPANY_NO      = '01'                                  
MFA-TR*        ORDER BY MN.DATE_MTR_INSTALL DESC                                
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7700                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                  CONTINUE                                              
               WHEN OTHER                                               
                  DISPLAY '********** PCSCA302 ABORT **********'        
                  DISPLAY '** ERROR 7700-VALIDATE-MTR-MLTPLR **'        
                  DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
                  DISPLAY '** ACCOUNT-NO  = ' AT-ACCOUNT-NO             
                  DISPLAY '**      PROCESSING TERMINATED     **'        
                  DISPLAY '********** PCSCA302 ABORT **********'        
                  PERFORM 9900-ABEND             THRU 9900-EXIT         
           END-EVALUATE.                                                
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
A04998*7710-GET-METER-COUNT.                                         *          
A04998****************************************************************          
A04998 7710-GET-METER-COUNT.                                            
A04998                                                                  
A04998     EXEC SQL                                                     
A04998        SELECT COUNT(MN.METER_NO)                                 
A04998          INTO :WS-METER-COUNT                                    
A04998          FROM CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                  
A04998              ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
A04998              ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                  
A04998         WHERE AT.ACCOUNT_NO      = :AT-ACCOUNT-NO                
A04998           AND UT.ACCOUNT_NO      =  AT.ACCOUNT_NO                
A04998           AND UT.CODE_UTIL_TYPE  = 'G'                           
A04998           AND MN.ACCOUNT_NO      =  UT.ACCOUNT_NO                
A04998           AND MN.CODE_UTIL_TYPE  =  UT.CODE_UTIL_TYPE            
A04998           AND MN.IC_NO           =  UT.IC_NO                     
A04998           AND MN.CODE_METER_STATUS NOT IN ('J','K')              
A04998                                                           
A04998                                                      
A04998     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(MN.METER_NO)                                         
MFA-TR*         INTO :WS-METER-COUNT                                            
MFA-TR*         FROM CSS_ACCOUNT      AT                                        
MFA-TR*             ,CSS_UTIL_ENVRNMT UT                                        
MFA-TR*             ,CSS_MTRD_ENVRNMT MN                                        
MFA-TR*        WHERE AT.ACCOUNT_NO      = :AT-ACCOUNT-NO                        
MFA-TR*          AND UT.ACCOUNT_NO      =  AT.ACCOUNT_NO                        
MFA-TR*          AND UT.CODE_UTIL_TYPE  = 'G'                                   
MFA-TR*          AND MN.ACCOUNT_NO      =  UT.ACCOUNT_NO                        
MFA-TR*          AND MN.CODE_UTIL_TYPE  =  UT.CODE_UTIL_TYPE                    
MFA-TR*          AND MN.IC_NO           =  UT.IC_NO                             
MFA-TR*          AND MN.CODE_METER_STATUS NOT IN ('J','K')                      
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7710                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04998                                                                  
A04998     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
A04998                                                                  
A04998     EVALUATE WS-ACTIVE-RETURN-CODE                               
A04998         WHEN SUCCESSFUL-CALL                                     
A04998            CONTINUE                                              
A04998         WHEN OTHER                                               
A04998            DISPLAY '********** PCSCA302 ABORT **********'        
A04998            DISPLAY '** ERROR 7710-GET-METER-COUNT     **'        
A04998            DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
A04998            DISPLAY '** ACCOUNT-NO  = ' AT-ACCOUNT-NO             
A04998            DISPLAY '**      PROCESSING TERMINATED     **'        
A04998            DISPLAY '********** PCSCA302 ABORT **********'        
A04998            PERFORM 9900-ABEND             THRU 9900-EXIT         
A04998     END-EVALUATE.                                                
A04998                                                                  
A04998 7710-EXIT.                                                       
A04998     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *7750-SELECT-RESTART-DATA                                      *          
      ****************************************************************          
       7750-SELECT-RESTART-DATA.                                        
                                                                        
           EXEC SQL                                                     
               SELECT RESTART_DATA                                      
                 INTO :RF-RESTART-DATA                                  
                 FROM CSS_RESTART WITH(READUNCOMMITTED)                         
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                   
                  AND PARTITION_NO = :RF-PARTITION-NO                   
                  AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RESTART_DATA                                              
MFA-TR*          INTO :RF-RESTART-DATA                                          
MFA-TR*          FROM CSS_RESTART                                               
MFA-TR*         WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                           
MFA-TR*           AND PARTITION_NO = :RF-PARTITION-NO                           
MFA-TR*           AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                           
MFA-TR*          WITH UR                                                        
MFA-TR*     QUERYNO 7750                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '      ABENDING PROGRAM '                         
              DISPLAY ' ERROR GETTING RESTART DATA '                    
              DISPLAY ' 7750-SELECT-RESTART-DATA   '                    
              DISPLAY ' SQLCODE = ' WS-ACTIVE-RETURN-CODE               
              DISPLAY ' PROGRAM      : ' RF-NAME-PROGRAM                
              DISPLAY ' PARTITION-NO : ' RF-PARTITION-NO                
              DISPLAY ' DUP-CNTRL-NO : ' RF-DUP-CNTRL-NO                
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
       7750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **                                                              **        
      **  8000-WRITE-ERROR-FILE                                       **        
      **       WRITES THE RECORD IN THE ERROR FILE                    **        
      **                                                              **        
      ******************************************************************        
      *                                                                         
       8000-WRITE-ERROR-FILE.                                           
                                                                        
           WRITE FIORP302-REC.                                          
           IF FLRP302-SUCCESSFUL                                        
               ADD 1                         TO WS-FLRP302-REC-CNTR     
           ELSE                                                         
              DISPLAY '********** PCSCA302 ABORT *****************'     
              DISPLAY '**  PARA 8000-WRITE-ERROR-FILE           **'     
              DISPLAY '**  WRITE ERROR OF FCSRP302 - INPUT FILE **'     
              DISPLAY '**         FILE STATUS = ' WS-FLRP302-STATUS     
              DISPLAY '**         PROCESSING TERMINATED         **'     
              DISPLAY '********** PCSCA302 ABORT *****************'     
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
           MOVE SPACES                       TO WS-ERROR-MESG           
                                                WS-ERROR-MESG-CODE.     
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *8893-RESET-RESTART-REQ-PARM                                   *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD00029                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *8896-UPDATE-RESTART                                           *          
      ****************************************************************          
       8896-UPDATE-RESTART.                                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_RESTART                                       
                  SET RESTART_DATA = :RF-RESTART-DATA                   
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                   
                  AND PARTITION_NO = :RF-PARTITION-NO                   
                  AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '      ABENDING PROGRAM      '                    
              DISPLAY ' ERROR UPDATING RESTART ROW '                    
              DISPLAY ' 8896-UPDATE-RESTART        '                    
              DISPLAY ' SQLCODE = ' WS-ACTIVE-RETURN-CODE               
              DISPLAY ' PROGRAM      : ' RF-NAME-PROGRAM                
              DISPLAY ' PARTITION-NO : ' RF-PARTITION-NO                
              DISPLAY ' DUP-CNTRL-NO : ' RF-DUP-CNTRL-NO                
              DISPLAY ' RESTART-DATA : ' RF-RESTART-DATA                
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
       8896-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *8897-INSERT-RESTART                                           *          
      ****************************************************************          
       8897-INSERT-RESTART.                                             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_RESTART                                  
                   (NAME_PROGRAM                                        
                   ,PARTITION_NO                                        
                   ,DUP_CNTRL_NO                                        
                   ,RESTART_DATA)                                       
               VALUES                                                   
                   (:RF-NAME-PROGRAM                                    
                   ,:RF-PARTITION-NO                                    
                   ,:RF-DUP-CNTRL-NO                                    
                   ,:RF-RESTART-DATA)                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '      ABENDING PROGRAM      '                    
              DISPLAY ' ERROR INSERTING RESTART ROW '                   
              DISPLAY ' 8897-INSERT-RESTART        '                    
              DISPLAY ' SQLCODE = ' WS-ACTIVE-RETURN-CODE               
              DISPLAY ' PROGRAM      : ' RF-NAME-PROGRAM                
              DISPLAY ' PARTITION-NO : ' RF-PARTITION-NO                
              DISPLAY ' DUP-CNTRL-NO : ' RF-DUP-CNTRL-NO                
              DISPLAY ' RESTART-DATA : ' RF-RESTART-DATA                
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8897-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *8898-ISSUE-CHKP                                               *          
      ****************************************************************          
       8898-ISSUE-CHKP.                                                 
                                                                        
           MOVE 1                            TO WS-RESTART-PROCESS-TYPE.
           ADD +1                            TO WS-CHKP-SEQ-NO.         
           MOVE WS-CHKP-SEQ-NO               TO WS-RESTART-CHKP-SEQ-NO. 
           MOVE AGL-DIST-ACCOUNT-NO          TO WS-RESTART-AGLC-ACCT-NO.
           MOVE WS-FLCA302-REC-CNTR          TO WS-RESTART-TOTAL-COUNT. 
                                                                        
           PERFORM 8899-WRITE-RSDDR             THRU 8899-EXIT.         
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
                                                                        
           MOVE 0                            TO WS-COMMIT-COUNTER.      
           DISPLAY 'COMMIT POINT # : ' WS-CHKP-SEQ-NO ' TAKEN '         
                   'LAST AGL ACCT # '  AGL-DIST-ACCOUNT-NO.             
      *                                                                         
       8898-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *8899-WRITE-RSDDR                                              *          
      ****************************************************************          
       8899-WRITE-RSDDR.                                                
                                                                        
           MOVE WS-PGRMNAME                  TO RF-NAME-PROGRAM.        
           MOVE 1                            TO RF-DUP-CNTRL-NO         
                                                RF-PARTITION-NO.        
           MOVE WS-RESTART-DATA              TO RF-RESTART-DATA-TEXT.   
           MOVE WS-RESTART-DATA-LENGTH       TO RF-RESTART-DATA-LEN.    
           PERFORM 8896-UPDATE-RESTART          THRU 8896-EXIT.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              PERFORM 8897-INSERT-RESTART       THRU 8897-EXIT          
           END-IF.                                                      
      *                                                                         
       8899-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **                                                              **        
      **  9000-TERMINATE.                                             **        
      **       TERMINATION ROUTINE                                    **        
      **                                                              **        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSCA302-FILE.                                         
           IF FLCA302-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '********** PCSCA302 ABORT *****************'     
              DISPLAY '**  PARA 9000-TERMINATE                  **'     
              DISPLAY '**  CLOSE ERROR OF FCSCA302 - INPUT FILE **'     
              DISPLAY '**         FILE STATUS = ' WS-FLCA302-STATUS     
              DISPLAY '**         PROCESSING TERMINATED         **'     
              DISPLAY '********** PCSCA302 ABORT *****************'     
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
           CLOSE FCSRP302-FILE.                                         
           IF FLRP302-SUCCESSFUL                                        
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA302 ABORT *****************'     
              DISPLAY '**  PARA 9000-TERMINATE                  **'     
              DISPLAY '**  CLOSE ERROR OF FCSRP302 - INPUT FILE **'     
              DISPLAY '**         FILE STATUS = ' WS-FLRP302-STATUS     
              DISPLAY '**         PROCESSING TERMINATED         **'     
              DISPLAY '********** PCSCA302 ABORT *****************'     
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
