       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.      PCSCA301.                                       
       AUTHOR.          ED DREW.                                        
       DATE-WRITTEN.    JULY 2016.                                      
      ***************************************************************** 00050000
      ********            CUSTOMER SERVICE SYSTEM             ********* 00060000
      **********************  ****  *********************************** 00070000
      **                                                             ** 00080000
      **              PROGRAM  MODIFICATION  LOG                     ** 00090000
      **                                                             ** 00100000
      **    DATE    INITIALS     REASON                              ** 00110000
      **    ---     ----         ---                                 ** 00120000
      ***************************************************************** 00602200
      **              PROGRAM NARRATIVE                              ** 00602300
      ***************************************************************** 00602400
      **  READ A FILE OF ACH/NOC TRANSACTIONS AND UPDATE ACCORDINGLY.** 00602500
      **  CURRENTLY, THREE TRANSACTIONS ARE PROCESSED:               ** 00602600
      **                                                             ** 00602600
      **  C01: CHANGE BANK ACCOUNT NUMBER                            ** 00602600
      **  C02: CHANGE BANK ROUTING NUMBER                            ** 00602600
      **  C03: CHANGE BANK ACCOUNT AND ROUTING NUMBERS               ** 00602600
      **                                                             ** 00602600
      **  TWO RECORD TYPES ARE PROCESSED:                            ** 00602600
      **  6: THE CUSTOMER'S BANKING INFO THAT WE PRESENTED           ** 00602600
      **  7: THE BANKING INFO THAT THE BANK SAYS WE SHOULD BE USING  ** 00602600
      **                                                             ** 00602600
      **  TWO TABLES ARE UPDATED IF THE INFORMATION IS FOUND:        ** 00602600
      **  CSS_BANK_EFT AND CSS_CUSTOMER_BANK                         ** 00602600
      **                                                             ** 00602600
      **  TRANSACTION HISTORY IS LOADED FOR AN UPDATE TO EITHER      ** 00602600
      **  CSS_BANK_EFT OR CSS_CUSTOMER_BANK                          ** 00602600
      **                                                             ** 00602600
      ***************************************************************** 00605000
      *                                                                 00606000
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT NOCFILE                                               
               ASSIGN TO NOCFILE.                                       
           SELECT AUDITREP                                              
               ASSIGN TO AUDITREP.                                      
           SELECT UPDATREP                                              
               ASSIGN TO UPDATREP.                                      
      *                                                                 00710000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD NOCFILE                                                       
           BLOCK CONTAINS 0 RECORDS.                                    
       01  NOC-RECORD.                                                  
           05  NOC-RECORD-TYPE           PIC X.                         
           05  FILLER                    PIC XX.                        
           05  NOC-TRANS-TYPE            PIC XXX.                       
           05  FILLER                    PIC X(88).                     
       FD AUDITREP                                                      
           BLOCK CONTAINS 0 RECORDS.                                    
       01  AUDITREP-RECORD               PIC X(133).                    
      *                                                                 00760000
       FD UPDATREP                                                      
           BLOCK CONTAINS 0 RECORDS.                                    
       01  UPDATREP-REC                  PIC X(133).                    
      *                                                                 00760000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA301'.
MSQ017     COPY MFASQLM.
       77  WS-PGRMNAME                   PIC X(8)     VALUE 'PCSCA301'. 
       77  WS-EOF                        PIC X        VALUE 'N'.        
           88  END-OF-FILE                            VALUE 'Y'.        
       77  WS-MESSAGE                    PIC X(40).                     
       77  WS-TRANS-HIST-HDR             PIC X        VALUE 'N'.        
       77  WS-PROCESS-TRANSACTION        PIC X        VALUE 'N'.        
       77  WS-INFO-CHANGED               PIC X        VALUE 'Y'.        
           88  INFO-CHANGED                           VALUE 'Y'.        
           88  INFO-DID-NOT-CHANGE                    VALUE 'N'.        
       77  WS-NBR-OF-SPACES               PIC S9(4)   COMP   VALUE 1.   
       77  I                              PIC S9(4)   COMP   VALUE 1.   
       77  WS-MAX-BANK-ACCT-LEN           PIC S9(4)   COMP   VALUE 1.   
       77  WS-MASK-LEN                    PIC S9(4)   COMP   VALUE 1.   
       77  WS-BANK-SEQ-NO                 PIC S9(8)   COMP   VALUE 0.   
       77  WS-CORRECTED-BANK-ID           PIC S9(6)   COMP-3 VALUE 0.   
       77  WS-BANK-ID                     PIC S9(6)   COMP-3 VALUE 0.   
       77  RS-RETURN-CODE                 PIC S9999   COMP.             
       77  RS-RETURN-CODE-DISP            PIC 99999-.                   
       77  WS-OLD-BANK-ACCT               PIC X(19).                    
       77  WS-NEW-BANK-ACCT               PIC X(19).                    
       77  WS-OLD-UPD-BANK-ACCT           PIC X(19).                    
       77  WS-NEW-UPD-BANK-ACCT           PIC X(19).                    
       77  WS-OLD-UPD-ROUTING-NBR         PIC X(09).                    
       77  WS-NEW-UPD-ROUTING-NBR         PIC X(09).                    
       77  WS-OLD-ROUTING-NO              PIC X(09).                    
       77  WS-NEW-ROUTING-NO              PIC X(09).                    
COB305 77 WS-ACCOUNT-NO        PIC S9(13) COMP-3 VALUE 0.           
       77  WS-PRINT-ACCOUNT               PIC 9B9999B9999B9999.         
       77  WS-DISPLAY-SQLCODE             PIC 9999-.                    
COB305 77 WS-CUSTOMER-NO        PIC S9(10) COMP-3 VALUE 0.           
       77  WS-CUSTOMER-NO-DISP            PIC 9(10).                    
       77  WS-BANK-NO-DISP                PIC Z9999.                    
       77  WS-SEQ-DISP                    PIC Z99.                      
       77  WS-CB-BANK-ACCT-NBR            PIC X(19).                    
       77  WS-NEW-BANK-ACCT-NBR           PIC X(19).                    
       77  WS-TABLE-ID                    PIC XX.                       
       77  WS-ROUTING-TABLE-ID            PIC XX.                       
       77  WS-RETURN-CODE                 PIC S9999   COMP.             
       77  S-RETURN-CODE                  PIC S9999   COMP.             
       77  WS-APPL-PROGRAM-ID             PIC X(8)   VALUE 'BANKUPDT'.  
       77  WS-NEW-ROUTING-NBR             PIC X(9).                     
       77  WS-UPDATREP-HDR                PIC X(100) VALUE                      
      -    'ACCOUNT NO,TRANS TYPE,OLD ROUTING NO,NEW ROUTING NO,OLD ACCO        
      -    'UNT NO,NEW ACCOUNT NO,MESSAGE'.                                     
       01  WS-INPUT-MISC.                                               
           05  WS-SYSIPT               PIC X(03)   VALUE SPACES.        
               88  END-OF-SYSIPT       VALUE 'END'.                     
           05      WS-PROGRAM          PIC X(10)  VALUE 'COMMON'.       
           05      WS-COMMAND          PIC X(04)  VALUE 'PARM'.         
           05      WS-SEQUENCE         PIC 9(04)  VALUE  ZERO.          
           EXEC SQL                                                             
               INCLUDE FIOCA301                                                 
           END-EXEC.                                                            
       01  WS-INPUT-AREA.                                               
           05  WS-INPUT-FUNC-ID        PIC X(01).                       
           05  WS-INPUT-KEY.                                            
               10  WS-PGRM-NAME        PIC X(10).                       
               10  WS-CMND-CODE        PIC X(04).                       
               10  WS-SEQ-NBR          PIC 9(04).                       
           05  WS-INPUT-STATUS         PIC X(01).                       
               88  INPUT-ACTIVE               VALUE 'A'.                
               88  INPUT-INACTIVE             VALUE 'I'.                
           05  WS-INPUT-DATA           PIC X(80).                       
       01  WS-INPUT-DATA-BREAKDOWN     VALUE SPACES.                    
           05  WS-INPUT-PROCESS        PIC X(8).                        
           05  WS-INPUT-PROCESS-FLAG   PIC X.                           
           05  FILLER                  PIC X.                           
           05  WS-INPUT-TRANS          PIC X(5).                        
           05  WS-INPUT-TRANS-TYPE     PIC XXX.                         
           05  FILLER                  PIC X.                           
           05  WS-INPUT-DESC           PIC X(61).                       
       01  WS-TRANSACTION-TABLE        VALUE SPACES.                    
           05 FILLER                   OCCURS 100 TIMES.                
              10  WS-TRANS-TYPE        PIC XXX.                         
              10  WS-PROCESS-FLAG      PIC X.                           
              10  WS-TRANS-DESC        PIC X(80).                       
       01  WS-UPDATE-CT                PIC 9(5)  VALUE 0.               
       01  FILLER REDEFINES WS-UPDATE-CT.                               
           03  WS-COMMIT-CT              PIC 999.                       
           03  WS-COMMIT-TEST            PIC S99.                       
      *                                                                 04641000
      *                                                                 04650000
      **************************************************************    04660000
      * COPYBOOKS FOR THE PURPOSE OF DISPLAYING ERROR MESSAGES     *    04670000
      **************************************************************    04680000
           COPY FIOJC01.                                                04690009
           COPY CWS00303.                                               04691009
           COPY CWS09900.                                               04710000
           COPY CWS00010.                                               04720000
           COPY CWS0070B.                                               04720000
           EXEC SQL                                                             
               INCLUDE CWSCA067                                                 
           END-EXEC.                                                    01510000
      ******************************************************************01590000
      * INCLUDE CSS_MNT_TRANS_HIST, MH                                  01950000
      ******************************************************************01960000
           EXEC SQL                                                     01970000
              INCLUDE TBMNHIST                                          01980000
           END-EXEC.                                                    01990000
                                                                        
      ******************************************************************02010000
      * INCLUDE CSS_MT_TRN_HST_DET, MI                                  02020000
      ******************************************************************02030000
           EXEC SQL                                                     02040000
              INCLUDE TBMNHDT                                           02050000
           END-EXEC.                                                    02060000
                                                                        
      ******************************************************************02010000
      * INCLUDE CSS_CUSTOMER_BANK, JF                                   02020000
      ******************************************************************02030000
           EXEC SQL                                                     02040000
              INCLUDE TBCSTBNK                                          02050000
           END-EXEC.                                                    02060000
      ******************************************************************02010000
      * INCLUDE CSS_BANK_EFT     , BE                                   02020000
      ******************************************************************02030000
           EXEC SQL                                                     02040000
              INCLUDE TBBNKEFT                                          02050000
           END-EXEC.                                                    02060000
      ******************************************************************02010000
      * INCLUDE CSS_BANK         , D1                                   02020000
      ******************************************************************02030000
           EXEC SQL                                                     02040000
              INCLUDE TBBANK                                            02050000
           END-EXEC.                                                    02060000
                                                                        
                                                                        
           EXEC SQL                                                     02675000
              INCLUDE TBJBPARM                                          02676000
           END-EXEC.                                                    02677000
           EXEC SQL                                                     02915000
              INCLUDE CWS00099                                          02916000
           END-EXEC.                                                    02917000
                                                                        
      ******************************************************************02920000
      *    COBOL WORKING STORAGE COPY BOOKS                            *02930000
      ******************************************************************02940000
                                                                        
           COPY CWS00011.                                               03000000
           EXEC SQL                                                     04761003
               INCLUDE SQLCA                                            04762003
           END-EXEC.                                                    04763003
           EXEC SQL DECLARE BANK_ACCOUNT_UPD   CURSOR FOR               
               SELECT 'JF',                                             
                   CB.BANK_ID,                                          
                   CB.CUSTOMER_NO,                                      
                   CB.CUST_BANK_SEQ_NO                                  
               FROM  CSS_CUSTOMER_BANK CB WITH(READUNCOMMITTED),                
                     CSS_ACCOUNT       AT WITH(READUNCOMMITTED),                
                     CSS_BANK          BKA WITH(READUNCOMMITTED)                
               WHERE AT.ACCOUNT_NO        = :WS-ACCOUNT-NO AND          
                     CB.CUSTOMER_NO       = AT.CUSTOMER_NO AND          
                     CB.BANK_ID           = BKA.BANK_ID    AND          
                     CB.BANK_ACCT_NO      = :FCA301-BANK-ACCOUNT AND    
                     CB.BANK_ACCT_STAT_CD <> 'D'                        
                  UNION                                                 
                  SELECT 'BE',                                          
                         EF.BANK_ID,                                    
                         AC.CUSTOMER_NO,                                
                         EF.CUST_BANK_SEQ_NO                            
                   FROM  CSS_BANK_EFT      EF WITH(READUNCOMMITTED),            
                         CSS_ACCOUNT       AC WITH(READUNCOMMITTED),            
                         CSS_BANK          BKB WITH(READUNCOMMITTED)            
                   WHERE AC.ACCOUNT_NO     = :WS-ACCOUNT-NO AND         
                         EF.ACCOUNT_NO     = AC.ACCOUNT_NO  AND         
                         EF.BANK_ID        = BKB.BANK_ID    AND         
                         EF.BANK_ACCT_NO  = :FCA301-BANK-ACCOUNT  AND   
                         EF.STATUS_CODE <> 'D'                          
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE BANK_ACCOUNT_UPD   CURSOR FOR                       
MFA-TR*        SELECT 'JF',                                                     
MFA-TR*            CB.BANK_ID,                                                  
MFA-TR*            CB.CUSTOMER_NO,                                              
MFA-TR*            CB.CUST_BANK_SEQ_NO                                          
MFA-TR*        FROM  CSS_CUSTOMER_BANK CB,                                      
MFA-TR*              CSS_ACCOUNT       AT,                                      
MFA-TR*              CSS_BANK          BKA                                      
MFA-TR*        WHERE AT.ACCOUNT_NO        = :WS-ACCOUNT-NO AND                  
MFA-TR*              CB.CUSTOMER_NO       = AT.CUSTOMER_NO AND                  
MFA-TR*              CB.BANK_ID           = BKA.BANK_ID    AND                  
MFA-TR*              CB.BANK_ACCT_NO      = :FCA301-BANK-ACCOUNT AND            
MFA-TR*              CB.BANK_ACCT_STAT_CD <> 'D'                                
MFA-TR*           UNION                                                         
MFA-TR*           SELECT 'BE',                                                  
MFA-TR*                  EF.BANK_ID,                                            
MFA-TR*                  AC.CUSTOMER_NO,                                        
MFA-TR*                  EF.CUST_BANK_SEQ_NO                                    
MFA-TR*            FROM  CSS_BANK_EFT      EF,                                  
MFA-TR*                  CSS_ACCOUNT       AC,                                  
MFA-TR*                  CSS_BANK          BKB                                  
MFA-TR*            WHERE AC.ACCOUNT_NO     = :WS-ACCOUNT-NO AND                 
MFA-TR*                  EF.ACCOUNT_NO     = AC.ACCOUNT_NO  AND                 
MFA-TR*                  EF.BANK_ID        = BKB.BANK_ID    AND                 
MFA-TR*                  EF.BANK_ACCT_NO  = :FCA301-BANK-ACCOUNT  AND           
MFA-TR*                  EF.STATUS_CODE <> 'D'                                  
MFA-TR*                  WITH UR                                                
MFA-TR*     END-EXEC.                                                           
           EXEC SQL DECLARE ROUTING_NBR_UPD    CURSOR FOR               
               SELECT 'JF',                                             
                   CB.BANK_ID,                                          
                   CB.CUSTOMER_NO,                                      
                   CB.CUST_BANK_SEQ_NO                                  
               FROM  CSS_CUSTOMER_BANK CB WITH(READUNCOMMITTED),                
                     CSS_ACCOUNT       AT WITH(READUNCOMMITTED),                
                     CSS_BANK          BKA WITH(READUNCOMMITTED)                
               WHERE AT.ACCOUNT_NO        = :WS-ACCOUNT-NO AND          
                     CB.CUSTOMER_NO       = AT.CUSTOMER_NO AND          
                     CB.BANK_ID           = BKA.BANK_ID    AND          
                     BKA.ROUTING_NUMBER   = :FCA301-ROUTING-NBR  AND    
                     CB.BANK_ACCT_STAT_CD <> 'D'                        
                  UNION                                                 
                  SELECT 'BE',                                          
                         EF.BANK_ID,                                    
                         AC.CUSTOMER_NO,                                
                         EF.CUST_BANK_SEQ_NO                            
                   FROM  CSS_BANK_EFT      EF WITH(READUNCOMMITTED),            
                         CSS_ACCOUNT       AC WITH(READUNCOMMITTED),            
                         CSS_BANK          BKB WITH(READUNCOMMITTED)            
                   WHERE AC.ACCOUNT_NO       = :WS-ACCOUNT-NO AND       
                         EF.ACCOUNT_NO       = AC.ACCOUNT_NO  AND       
                         EF.BANK_ID          = BKB.BANK_ID    AND       
                         BKB.ROUTING_NUMBER  = :FCA301-ROUTING-NBR  AND 
                         EF.STATUS_CODE <> 'D'                          
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE ROUTING_NBR_UPD    CURSOR FOR                       
MFA-TR*        SELECT 'JF',                                                     
MFA-TR*            CB.BANK_ID,                                                  
MFA-TR*            CB.CUSTOMER_NO,                                              
MFA-TR*            CB.CUST_BANK_SEQ_NO                                          
MFA-TR*        FROM  CSS_CUSTOMER_BANK CB,                                      
MFA-TR*              CSS_ACCOUNT       AT,                                      
MFA-TR*              CSS_BANK          BKA                                      
MFA-TR*        WHERE AT.ACCOUNT_NO        = :WS-ACCOUNT-NO AND                  
MFA-TR*              CB.CUSTOMER_NO       = AT.CUSTOMER_NO AND                  
MFA-TR*              CB.BANK_ID           = BKA.BANK_ID    AND                  
MFA-TR*              BKA.ROUTING_NUMBER   = :FCA301-ROUTING-NBR  AND            
MFA-TR*              CB.BANK_ACCT_STAT_CD <> 'D'                                
MFA-TR*           UNION                                                         
MFA-TR*           SELECT 'BE',                                                  
MFA-TR*                  EF.BANK_ID,                                            
MFA-TR*                  AC.CUSTOMER_NO,                                        
MFA-TR*                  EF.CUST_BANK_SEQ_NO                                    
MFA-TR*            FROM  CSS_BANK_EFT      EF,                                  
MFA-TR*                  CSS_ACCOUNT       AC,                                  
MFA-TR*                  CSS_BANK          BKB                                  
MFA-TR*            WHERE AC.ACCOUNT_NO       = :WS-ACCOUNT-NO AND               
MFA-TR*                  EF.ACCOUNT_NO       = AC.ACCOUNT_NO  AND               
MFA-TR*                  EF.BANK_ID          = BKB.BANK_ID    AND               
MFA-TR*                  BKB.ROUTING_NUMBER  = :FCA301-ROUTING-NBR  AND         
MFA-TR*                  EF.STATUS_CODE <> 'D'                                  
MFA-TR*                  WITH UR                                                
MFA-TR*     END-EXEC.                                                           
       PROCEDURE DIVISION.                                              
      *                                                                 06020000
           PERFORM 0100-INITIALIZE THRU 0100-EXIT.                      
           PERFORM UNTIL END-OF-FILE                                    
               PERFORM 0200-PROCESS-NOCFILE   THRU 0200-EXIT            
               PERFORM 8100-READ-NOCFILE                                
           END-PERFORM                                                  
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                 06320000
      *                                                                 06330000
       0100-INITIALIZE.                                                 
           OPEN INPUT  NOCFILE                                          
                OUTPUT AUDITREP UPDATREP.                               
           PERFORM 8100-READ-NOCFILE .                                  
           MOVE WS-PGRMNAME TO WS-PROGRAM.                              
           MOVE LENGTH OF WS-OLD-UPD-BANK-ACCT TO WS-MAX-BANK-ACCT-LEN. 
           INITIALIZE WS-INPUT-DATA-BREAKDOWN.                          
           PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
           PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT.                 
           PERFORM UNTIL END-OF-SYSIPT OR I > 100                       
               IF WS-INPUT-TRANS = 'CODE='                              
                   MOVE WS-INPUT-TRANS-TYPE   TO WS-TRANS-TYPE   (I)    
                   MOVE WS-INPUT-PROCESS-FLAG TO WS-PROCESS-FLAG (I)    
                   MOVE WS-INPUT-DESC         TO WS-TRANS-DESC   (I)    
               END-IF                                                   
               ADD +1 TO I                                              
               PERFORM 7610-READ-FCSJC01 THRU 7610-EXIT                 
           END-PERFORM.                                                 
           IF I > 90                                                    
               IF I > 100                                               
                   DISPLAY 'PCSCA301 - TABLE OVERFLOW - ABENDING'       
                   MOVE 12 TO WS-RETURN-CODE                            
                   PERFORM 9700-PROCESS-ABEND                           
           ELSE                                                         
               DISPLAY 'PCSCA301 - WARNING MESSAGE: '                   
                       'TABLE APPROACHING LIMIT - CURRENTLY AT ' I      
               MOVE 4 TO WS-RETURN-CODE                                 
               END-IF                                                   
           END-IF.                                                      
           WRITE UPDATREP-REC FROM WS-UPDATREP-HDR.                     
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07080000
       0200-PROCESS-NOCFILE.                                            
           IF NOC-RECORD-TYPE = '6'                                     
               MOVE NOC-RECORD TO FIOCA301-6-RECORD                     
           ELSE                                                         
               IF NOC-RECORD-TYPE = '7'                                 
                   MOVE NOC-RECORD TO FIOCA301-7-RECORD                 
                   MOVE 'N' TO WS-PROCESS-TRANSACTION                   
                   PERFORM VARYING I FROM 1 BY 1                        
                       UNTIL I > 100 OR                                 
                           WS-TRANS-TYPE  (I) = NOC-TRANS-TYPE OR       
                           WS-TRANS-TYPE  (I) = SPACES                  
                   END-PERFORM                                          
                   IF WS-PROCESS-FLAG (I) = 'Y'                         
                        PERFORM 0300-PROCESS-NOC-TRANSACTION            
                   ELSE                                                 
                       MOVE SPACES TO AUDITREP-RECORD                   
                       STRING FCA301-ACCOUNT-NBR ' TRANS TYPE     '     
                           NOC-TRANS-TYPE     '        WAS BYPASSED '   
                           'PROCESS FLAG NOT = Y'                       
                           DELIMITED BY SIZE                            
                           INTO AUDITREP-RECORD                         
                       PERFORM 8000-REPORT                              
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07650000
       0300-PROCESS-NOC-TRANSACTION.                                    
           MOVE FCA301-ACCOUNT-NBR TO WS-ACCOUNT-NO.                    
           MOVE 'Y'                TO WS-TRANS-HIST-HDR                 
                                      WS-PROCESS-TRANSACTION            
                                      WS-INFO-CHANGED.                  
           MOVE ' '                TO WS-MESSAGE.                       
           EVALUATE WS-TRANS-TYPE (I)                                   
               WHEN 'C01'                                               
                  MOVE FCA301-BANK-ACCOUNT TO WS-OLD-UPD-BANK-ACCT      
                  MOVE FCA301-CORRECTED-ACCOUNT-NBRB                    
                                           TO WS-NEW-UPD-BANK-ACCT      
                  MOVE SPACES              TO WS-OLD-UPD-ROUTING-NBR    
                                           WS-NEW-UPD-ROUTING-NBR       
                  IF FCA301-BANK-ACCOUNT = FCA301-CORRECTED-ACCOUNT-NBRB
                      PERFORM 1200-ACCOUNTS-MATCH                       
                  ELSE                                                  
                      PERFORM 0400-BANK-ACCOUNT-NBR                     
                  END-IF                                                
               WHEN 'C02'                                               
                  MOVE FCA301-BANK-ACCOUNT TO WS-OLD-UPD-BANK-ACCT      
                  MOVE FCA301-CORRECTED-ACCOUNT-NBRB                    
                                           TO WS-NEW-UPD-BANK-ACCT      
                  MOVE FCA301-ROUTING-NBR  TO WS-OLD-UPD-ROUTING-NBR    
                  MOVE FCA301-CORRECTED-ROUTING-NBR                     
                                           TO WS-NEW-UPD-ROUTING-NBR    
                  MOVE SPACES              TO WS-OLD-UPD-BANK-ACCT      
                                              WS-NEW-UPD-BANK-ACCT      
                  IF FCA301-ROUTING-NBR = FCA301-CORRECTED-ROUTING-NBR  
                      PERFORM 1000-ROUTING-NBRS-MATCH                   
                  ELSE                                                  
                      PERFORM 0500-ROUTING-NBR                          
                  END-IF                                                
               WHEN 'C03'                                               
                  MOVE FCA301-BANK-ACCOUNT TO WS-OLD-UPD-BANK-ACCT      
                  MOVE FCA301-CORRECTED-ACCOUNT-NBRA                    
                                           TO WS-NEW-UPD-BANK-ACCT      
                  MOVE FCA301-ROUTING-NBR  TO WS-OLD-UPD-ROUTING-NBR    
                  MOVE FCA301-CORRECTED-ROUTING-NBR                     
                                           TO WS-NEW-UPD-ROUTING-NBR    
                  PERFORM 0600-PROCESS-C03                              
               WHEN OTHER                                               
                   MOVE SPACES TO AUDITREP-RECORD                       
                   MOVE I TO WS-SEQ-DISP                                
                   STRING FCA301-ACCOUNT-NBR ' TRANS TYPE     '         
                        NOC-TRANS-TYPE     '        WAS BYPASSED '      
                        'TRANSACTION ' WS-TRANS-TYPE (I) ' ' WS-SEQ-DISP
                        ' NOT CODED'                                    
                        DELIMITED BY SIZE                               
                        INTO AUDITREP-RECORD                            
                   PERFORM 8000-REPORT                                  
            END-EVALUATE.                                               
       0300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07650000
       0400-BANK-ACCOUNT-NBR.                                           
           PERFORM 7800-OPEN-BANK-ACCT-CSR      THRU 7800-EXIT          
           PERFORM 7810-FETCH-BANK-ACCT-CSR     THRU 7810-EXIT          
           PERFORM UNTIL SQLCODE NOT = 0                                
               MOVE 'BANK ACCT NO'                  TO  MI-COLUMN-DESC  
               IF NOC-TRANS-TYPE = 'C01' OR                             
                   WS-TABLE-ID = WS-ROUTING-TABLE-ID AND                
                   WS-PROCESS-TRANSACTION = 'Y'                         
                       PERFORM 2700-DETERMINE-TABLE-BANK-ACCT           
                   IF SQLCODE = 0                                       
                       PERFORM 2900-TRANS-HIST          THRU 2900-EXIT  
                   END-IF                                               
               END-IF                                                   
               PERFORM 7810-FETCH-BANK-ACCT-CSR THRU 7810-EXIT          
           END-PERFORM.                                                 
           PERFORM 7820-CLOSE-BANK-ACCT-CSR THRU 7820-EXIT.             
       0400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07650000
       0500-ROUTING-NBR.                                                
           PERFORM 7900-OPEN-ROUTING-NBR-CSR    THRU 7900-EXIT          
           PERFORM 7910-FETCH-ROUTING-NBR-CSR   THRU 7910-EXIT          
           PERFORM UNTIL SQLCODE NOT = 0 OR                             
                         WS-PROCESS-TRANSACTION = 'N'                   
               MOVE 'ROUTING NO  '                  TO  MI-COLUMN-DESC  
               PERFORM 2800-DETERMINE-TABLE-ROUTING THRU 2800-EXIT      
               IF WS-PROCESS-TRANSACTION = 'Y'                          
                   PERFORM 2900-TRANS-HIST          THRU 2900-EXIT      
                   IF NOC-TRANS-TYPE = 'C03'                            
                       PERFORM 0400-BANK-ACCOUNT-NBR                    
                   END-IF                                               
               END-IF                                                   
               PERFORM 7910-FETCH-ROUTING-NBR-CSR THRU 7910-EXIT        
           END-PERFORM.                                                 
           PERFORM 7920-CLOSE-ROUTING-NBR-CSR THRU 7920-EXIT.           
       0500-EXIT.                                                       
           EXIT.                                                        
       0600-PROCESS-C03.                                                
           IF   FCA301-BANK-ACCOUNT = FCA301-CORRECTED-ACCOUNT-NBRA AND 
                FCA301-ROUTING-NBR = FCA301-CORRECTED-ROUTING-NBR       
                     PERFORM 1300-C03-MATCH                             
           ELSE                                                         
                IF FCA301-ROUTING-NBR = FCA301-CORRECTED-ROUTING-NBR    
                     PERFORM 1000-ROUTING-NBRS-MATCH                    
                ELSE                                                    
                     PERFORM 0500-ROUTING-NBR                           
                END-IF                                                  
                IF WS-PROCESS-TRANSACTION = 'Y'                         
                    IF FCA301-BANK-ACCOUNT =                            
                        FCA301-CORRECTED-ACCOUNT-NBRA                   
                        PERFORM 1200-ACCOUNTS-MATCH                     
                    ELSE                                                
                        PERFORM 0400-BANK-ACCOUNT-NBR                   
                    END-IF                                              
                END-IF                                                  
           END-IF.                                                      
       0600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07650000
       1000-ROUTING-NBRS-MATCH.                                         
           MOVE 'ROUTING NUMBERS MATCH' TO WS-MESSAGE.                  
           MOVE SPACES                  TO UPDATREP-REC.                
           MOVE   WS-ACCOUNT-NO TO WS-PRINT-ACCOUNT.                    
           INSPECT WS-PRINT-ACCOUNT REPLACING ALL ' ' BY '-'.           
           STRING WS-PRINT-ACCOUNT   ','                                
                  NOC-TRANS-TYPE       ','                              
                  FCA301-ROUTING-NBR   ','                              
                  WS-NEW-ROUTING-NBR   ',,,'                            
                  WS-MESSAGE                                            
                DELIMITED BY SIZE                                       
                INTO UPDATREP-REC.                                      
           PERFORM 8300-WRITE-UPDATE-LOG.                               
       1000-EXIT.                                                       
           EXIT.                                                        
       1200-ACCOUNTS-MATCH.                                             
           MOVE 'BANK ACCOUNTS MATCH'   TO WS-MESSAGE.                  
           MOVE SPACES                  TO UPDATREP-REC.                
           MOVE FCA301-ACCOUNT-NBR            TO                        
                                              WS-OLD-UPD-BANK-ACCT.     
           IF NOC-TRANS-TYPE = 'C01'                                    
              MOVE FCA301-CORRECTED-ACCOUNT-NBRB TO                     
                                              WS-NEW-UPD-BANK-ACCT      
           ELSE                                                         
              MOVE FCA301-CORRECTED-ACCOUNT-NBRA TO                     
                                              WS-NEW-UPD-BANK-ACCT      
           END-IF.                                                      
           PERFORM 3000-MASK-BANK-ACCT.                                 
           MOVE   WS-ACCOUNT-NO TO WS-PRINT-ACCOUNT.                    
           INSPECT WS-PRINT-ACCOUNT REPLACING ALL ' ' BY '-'.           
           STRING WS-PRINT-ACCOUNT   ','                                
                  NOC-TRANS-TYPE       ','                              
                  FCA301-ROUTING-NBR   ',,'                             
                  WS-OLD-UPD-BANK-ACCT ','                              
                  WS-OLD-UPD-BANK-ACCT ','                              
                  WS-MESSAGE                                            
                DELIMITED BY SIZE                                       
                INTO UPDATREP-REC.                                      
           PERFORM 8300-WRITE-UPDATE-LOG.                               
       1200-EXIT.                                                       
           EXIT.                                                        
       1300-C03-MATCH.                                                  
           MOVE 'BANK ACCOUNTS AND ROUTING NBRS MATCH' TO WS-MESSAGE.   
           MOVE SPACES                  TO UPDATREP-REC.                
           MOVE FCA301-BANK-ACCOUNT           TO                        
                                              WS-OLD-UPD-BANK-ACCT.     
           MOVE FCA301-CORRECTED-ACCOUNT-NBRA TO                        
                                              WS-NEW-UPD-BANK-ACCT.     
           PERFORM 3000-MASK-BANK-ACCT.                                 
           MOVE   WS-ACCOUNT-NO TO WS-PRINT-ACCOUNT.                    
           INSPECT WS-PRINT-ACCOUNT REPLACING ALL ' ' BY '-'.           
           STRING WS-PRINT-ACCOUNT   ','                                
                  NOC-TRANS-TYPE       ','                              
                  FCA301-ROUTING-NBR   ','                              
                  FCA301-CORRECTED-ROUTING-NBR ','                      
                  WS-OLD-UPD-BANK-ACCT ','                              
                  WS-NEW-UPD-BANK-ACCT ','                              
                  WS-MESSAGE                                            
                DELIMITED BY SIZE                                       
                INTO UPDATREP-REC.                                      
           PERFORM 8300-WRITE-UPDATE-LOG.                               
       1300-EXIT.                                                       
           EXIT.                                                        
       2700-DETERMINE-TABLE-BANK-ACCT.                                  
           IF WS-TABLE-ID = 'JF'                                        
               PERFORM 7100-UPDATE-CUST-BANK-ACCT-NBR                   
           ELSE                                                         
               IF WS-TABLE-ID = 'BE'                                    
                   PERFORM 7400-UPDATE-BANK-EFT-ACCT-NBR                
               ELSE                                                     
                   DISPLAY FCA301-ACCOUNT-NBR  ' '                      
                           FCA301-BANK-ACCOUNT ' '                      
                           NOC-TRANS-TYPE      ' '                      
                           WS-TABLE-ID ' BYPASSED - INVALID TABLE ID'   
                   MOVE SPACES TO AUDITREP-RECORD                       
                   STRING FCA301-ACCOUNT-NBR  ' '                       
                          FCA301-BANK-ACCOUNT ' '                       
                          NOC-TRANS-TYPE      ' '                       
                          WS-TABLE-ID ' BYPASSED - INVALID TABLE ID'    
                       DELIMITED BY SIZE                                
                       INTO AUDITREP-RECORD                             
                   PERFORM 8000-REPORT                                  
               END-IF                                                   
           END-IF.                                                      
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07650000
       2800-DETERMINE-TABLE-ROUTING.                                    
           IF WS-ROUTING-TABLE-ID = 'JF'                                
               PERFORM 7200-UPDATE-CUST-BANK-ROUTING THRU 7200-EXIT     
           ELSE                                                         
               IF WS-ROUTING-TABLE-ID = 'BE'                            
                   PERFORM 7500-UPDATE-BANK-EFT-ROUTING THRU 7500-EXIT  
               ELSE                                                     
                   DISPLAY FCA301-ACCOUNT-NBR ' '                       
                           FCA301-BANK-ACCOUNT   ' '                    
                           WS-ROUTING-TABLE-ID                          
                           ' BYPASSED - INVALID TABLE ID'               
                   MOVE SPACES TO AUDITREP-RECORD                       
                   STRING FCA301-ACCOUNT-NBR  ' '                       
                          FCA301-BANK-ACCOUNT ' '                       
                          NOC-TRANS-TYPE      ' '                       
                          WS-ROUTING-TABLE-ID                           
                          ' BYPASSED - INVALID TABLE ID'                
                       DELIMITED BY SIZE                                
                       INTO AUDITREP-RECORD                             
                   PERFORM 8000-REPORT                                  
               END-IF                                                   
           END-IF.                                                      
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07650000
       2900-TRANS-HIST.                                                 
           IF WS-TRANS-HIST-HDR = 'Y'                                   
               PERFORM 7550-TRANS-HIST-HDR                              
               PERFORM 8200-UPDATE-LIST                                 
               MOVE 'N' TO WS-TRANS-HIST-HDR                            
           END-IF.                                                      
           EVALUATE FCA301-TRANSACTION-TYPE                             
               WHEN 'C01'                                               
                   PERFORM 7570-THIST-BANK-ACCOUNT                      
               WHEN 'C02'                                               
                   PERFORM 7620-THIST-ROUTING-NBR                       
               WHEN 'C03'                                               
                   IF MI-COLUMN-DESC       = 'BANK ACCT NO'             
                       PERFORM 7570-THIST-BANK-ACCOUNT                  
                   ELSE                                                 
                       PERFORM 7620-THIST-ROUTING-NBR                   
                   END-IF                                               
           END-EVALUATE.                                                
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07650000
       3000-MASK-BANK-ACCT.                                             
           MOVE 0 TO WS-NBR-OF-SPACES.                                  
           INSPECT FUNCTION REVERSE (WS-OLD-UPD-BANK-ACCT)              
               TALLYING WS-NBR-OF-SPACES FOR LEADING SPACES             
           COMPUTE WS-MASK-LEN = WS-MAX-BANK-ACCT-LEN                   
                               - WS-NBR-OF-SPACES                       
                               - 4.                                     
           MOVE ALL '*' TO WS-OLD-UPD-BANK-ACCT (1:WS-MASK-LEN).        
           MOVE 0 TO WS-NBR-OF-SPACES.                                  
           INSPECT FUNCTION REVERSE (WS-NEW-UPD-BANK-ACCT)              
               TALLYING WS-NBR-OF-SPACES FOR LEADING SPACES.            
           COMPUTE WS-MASK-LEN = WS-MAX-BANK-ACCT-LEN                   
                               - WS-NBR-OF-SPACES                       
                               - 4.                                     
           MOVE ALL '*' TO WS-NEW-UPD-BANK-ACCT (1:WS-MASK-LEN).        
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07650000
           EXEC SQL                                                             
               INCLUDE CPDCA067                                                 
           END-EXEC.                                                            
      *                                                                 10480000
      *                                                                 07650000
       7100-UPDATE-CUST-BANK-ACCT-NBR.                                  
           IF NOC-TRANS-TYPE = 'C01'                                    
               MOVE FCA301-CORRECTED-ACCOUNT-NBRB                       
                                           TO WS-NEW-BANK-ACCT-NBR      
           ELSE                                                         
               MOVE FCA301-CORRECTED-ACCOUNT-NBRA                       
                                           TO WS-NEW-BANK-ACCT-NBR      
           END-IF.                                                      
HONK       EXEC SQL UPDATE CSS_CUSTOMER_BANK                            
HONK           SET BANK_ACCT_NO    = :WS-NEW-BANK-ACCT-NBR              
HONK           WHERE CUSTOMER_NO   = :WS-CUSTOMER-NO AND                
HONK              CUST_BANK_SEQ_NO = :WS-BANK-SEQ-NO AND                
HONK              BANK_ACCT_NO     = :FCA301-BANK-ACCOUNT AND           
HONK              BANK_ID          = :WS-BANK-ID                        
HONK       END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE = 100                                             
               MOVE ZERO TO SQLCODE                                     
           END-IF.                                                      
           EVALUATE SQLCODE                                             
               WHEN 0                                                   
                   CONTINUE                                             
               WHEN 100                                                 
                   DISPLAY FCA301-ACCOUNT-NBR ' '                       
                           FCA301-BANK-ACCOUNT   ' '                    
                           FCA301-CORRECTED-ACCOUNT-NBRA   ' '          
                           WS-BANK-ID                      ' '          
                           WS-BANK-SEQ-NO '  BYPASSED - NOT FOUND'      
                           ' - 7100'                                    
                   MOVE SPACES         TO AUDITREP-RECORD               
                   MOVE WS-BANK-ID     TO WS-BANK-NO-DISP               
                   MOVE WS-BANK-SEQ-NO TO WS-SEQ-DISP                   
                   STRING FCA301-ACCOUNT-NBR            ' '             
                          FCA301-BANK-ACCOUNT           ' '             
                          FCA301-CORRECTED-ACCOUNT-NBRA ' '             
                          WS-BANK-NO-DISP               ' '             
                          WS-SEQ-DISP                   ' '             
                          ' BYPASSED - NOT FOUND - 7100'                
                       DELIMITED BY SIZE                                
                       INTO AUDITREP-RECORD                             
                   PERFORM 8000-REPORT                                  
                                                                        
               WHEN OTHER                                               
                   MOVE 'UPDATE'              TO WS-DB2-FUNCTION        
                   MOVE SQLCODE               TO WS-DB2-RETURN-CODE     
                   MOVE ' '                   TO WS-DB2-MODULE-ID       
                   MOVE '7100'                TO WS-DB2-PARAGRAPH       
                   MOVE WS-CUSTOMER-NO        TO WS-DB2-KEY-1N          
                   MOVE WS-BANK-SEQ-NO        TO WS-DB2-KEY-1N          
                   MOVE FCA301-BANK-ACCOUNT   TO WS-DB2-KEY-3           
                   MOVE WS-BANK-ID            TO WS-DB2-KEY-4N          
                   MOVE 12                    TO WS-RETURN-CODE         
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07650000
       7200-UPDATE-CUST-BANK-ROUTING.                                   
           IF NOC-TRANS-TYPE = 'C02'                                    
               MOVE FCA301-BANK-ACCOUNT          TO WS-NEW-BANK-ACCT-NBR
               MOVE FCA301-CORRECTED-ACCOUNT-NBRB TO WS-NEW-ROUTING-NBR 
           ELSE                                                         
               MOVE FCA301-CORRECTED-ACCOUNT-NBRA TO                    
                                                    WS-NEW-BANK-ACCT-NBR
               MOVE FCA301-CORRECTED-ROUTING-NBR  TO WS-NEW-ROUTING-NBR 
           END-IF.                                                      
           PERFORM 7300-FIND-NEW-BANK-ID THRU 7300-EXIT.                
           IF WS-PROCESS-TRANSACTION = 'N'                              
               GO TO 7200-EXIT                                          
           END-IF.                                                      
HONK       EXEC SQL UPDATE CSS_CUSTOMER_BANK                            
HONK           SET BANK_ID         = :WS-CORRECTED-BANK-ID              
HONK           WHERE CUSTOMER_NO   = :WS-CUSTOMER-NO      AND           
HONK              CUST_BANK_SEQ_NO = :WS-BANK-SEQ-NO       AND          
HONK              BANK_ACCT_NO     = :FCA301-BANK-ACCOUNT  AND          
HONK              BANK_ID          = :WS-BANK-ID                        
HONK       END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EVALUATE SQLCODE                                             
               WHEN 0                                                   
                   CONTINUE                                             
               WHEN 100                                                 
                   DISPLAY FCA301-ACCOUNT-NBR    ' '                    
                           WS-CUSTOMER-NO        ' '                    
                           FCA301-BANK-ACCOUNT   ' '                    
                           WS-CORRECTED-BANK-ID                         
                           ' BYPASSED - NOT FOUND - 7200'               
                   MOVE SPACES TO AUDITREP-RECORD                       
                   MOVE WS-CUSTOMER-NO       TO WS-CUSTOMER-NO-DISP     
                   MOVE WS-CORRECTED-BANK-ID TO WS-BANK-NO-DISP         
                   STRING FCA301-ACCOUNT-NBR  ' '                       
                          WS-CUSTOMER-NO-DISP    ' '                    
                          FCA301-BANK-ACCOUNT ' '                       
                          WS-BANK-NO-DISP                               
                          ' BYPASSED - NOT FOUND - 7200'                
                       DELIMITED BY SIZE                                
                       INTO AUDITREP-RECORD                             
                   PERFORM 8000-REPORT                                  
               WHEN OTHER                                               
                   MOVE 'UPDATE'              TO WS-DB2-FUNCTION        
                   MOVE SQLCODE               TO WS-DB2-RETURN-CODE     
                   MOVE ' '                   TO WS-DB2-MODULE-ID       
                   MOVE '7200'                TO WS-DB2-PARAGRAPH       
                   MOVE WS-CUSTOMER-NO        TO WS-DB2-KEY-1N          
                   MOVE WS-BANK-SEQ-NO        TO WS-DB2-KEY-2N          
                   MOVE WS-NEW-BANK-ACCT-NBR  TO WS-DB2-KEY-3           
                   MOVE WS-BANK-ID            TO WS-DB2-KEY-4N          
                   MOVE 12                    TO WS-RETURN-CODE         
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07650000
       7300-FIND-NEW-BANK-ID.                                           
           EXEC SQL SELECT TOP(1) BANK_ID                                      
               INTO :WS-CORRECTED-BANK-ID                               
               FROM CSS_BANK WITH(READUNCOMMITTED)                              
               WHERE ROUTING_NUMBER = :WS-NEW-ROUTING-NBR               
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL SELECT BANK_ID                                              
MFA-TR*        INTO :WS-CORRECTED-BANK-ID                                       
MFA-TR*        FROM CSS_BANK                                                    
MFA-TR*        WHERE ROUTING_NUMBER = :WS-NEW-ROUTING-NBR                       
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EVALUATE SQLCODE                                             
               WHEN 0                                                   
                   CONTINUE                                             
               WHEN 100                                                 
                   MOVE 'N' TO WS-PROCESS-TRANSACTION                   
                   MOVE SPACES TO AUDITREP-RECORD                       
                   STRING FCA301-ACCOUNT-NBR ' '                        
                        WS-NEW-ROUTING-NBR  ' NOT FOUND ON TABLE - 7300'
                        DELIMITED BY SIZE                               
                        INTO AUDITREP-RECORD                            
                   PERFORM 8000-REPORT                                  
                   MOVE SPACES TO UPDATREP-REC                          
                   MOVE   WS-ACCOUNT-NO TO WS-PRINT-ACCOUNT             
                   INSPECT WS-PRINT-ACCOUNT REPLACING ALL ' ' BY '-'    
                   STRING WS-PRINT-ACCOUNT    ','                       
                        NOC-TRANS-TYPE        ','                       
                        FCA301-ROUTING-NBR    ','                       
                        WS-NEW-ROUTING-NBR    ','                       
                        ',,NOT UPDATED - NEW ROUTING NUMBER NOT FOUND'  
                        DELIMITED BY SIZE                               
                        INTO UPDATREP-REC                               
                   PERFORM 8300-WRITE-UPDATE-LOG                        
                   DISPLAY FCA301-ACCOUNT-NBR ' '                       
                           FCA301-BANK-ACCOUNT   ' '                    
                           WS-BANK-SEQ-NO '  BYPASSED - NOT FOUND'      
                             ' - 7300'                                  
               WHEN OTHER                                               
                   MOVE 'SELECT'                TO WS-DB2-FUNCTION      
                   MOVE SQLCODE                 TO WS-DB2-RETURN-CODE   
                   MOVE ' '                     TO WS-DB2-MODULE-ID     
                   MOVE '7300'                  TO WS-DB2-PARAGRAPH     
                   MOVE WS-NEW-ROUTING-NBR      TO WS-DB2-KEY-1         
                   MOVE 12                      TO WS-RETURN-CODE       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07650000
       7400-UPDATE-BANK-EFT-ACCT-NBR.                                   
           IF NOC-TRANS-TYPE = 'C01'                                    
               MOVE FCA301-CORRECTED-ACCOUNT-NBRB                       
                                           TO WS-NEW-BANK-ACCT-NBR      
           ELSE                                                         
               MOVE FCA301-CORRECTED-ACCOUNT-NBRA                       
                                           TO WS-NEW-BANK-ACCT-NBR      
           END-IF.                                                      
HONK       EXEC SQL UPDATE CSS_BANK_EFT                                 
HONK           SET BANK_ACCT_NO      = :WS-NEW-BANK-ACCT-NBR            
HONK           WHERE ACCOUNT_NO      = :WS-ACCOUNT-NO           AND     
HONK                 BANK_ACCT_NO    = :FCA301-BANK-ACCOUNT        AND  
HONK                 BANK_ID         = :WS-BANK-ID                      
HONK       END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EVALUATE SQLCODE                                             
               WHEN 0                                                   
                   CONTINUE                                             
               WHEN 100                                                 
                   DISPLAY FCA301-ACCOUNT-NBR ' '                       
                           FCA301-BANK-ACCOUNT   ' '                    
                           WS-BANK-ID     '  BYPASSED - NOT FOUND'      
                             ' - 7400'                                  
                   MOVE SPACES TO AUDITREP-RECORD                       
                   MOVE WS-BANK-ID TO WS-BANK-NO-DISP                   
                   STRING FCA301-ACCOUNT-NBR  ' '                       
                          FCA301-BANK-ACCOUNT ' '                       
                          WS-BANK-NO-DISP                               
                          ' BYPASSED - NOT FOUND - 7400'                
                       DELIMITED BY SIZE                                
                       INTO AUDITREP-RECORD                             
                   PERFORM 8000-REPORT                                  
               WHEN OTHER                                               
                   MOVE 'UPDATE'              TO WS-DB2-FUNCTION        
                   MOVE SQLCODE               TO WS-DB2-RETURN-CODE     
                   MOVE ' '                   TO WS-DB2-MODULE-ID       
                   MOVE '7100'                TO WS-DB2-PARAGRAPH       
                   MOVE FCA301-ACCOUNT-NBR TO WS-DB2-KEY-1              
                   MOVE WS-BANK-ID            TO WS-BANK-NO-DISP        
                   MOVE WS-BANK-NO-DISP       TO WS-DB2-KEY-2           
                   MOVE 12                    TO WS-RETURN-CODE         
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07650000
       7500-UPDATE-BANK-EFT-ROUTING.                                    
           IF NOC-TRANS-TYPE = 'C02'                                    
               MOVE FCA301-BANK-ACCOUNT          TO WS-NEW-BANK-ACCT-NBR
               MOVE FCA301-CORRECTED-ACCOUNT-NBRB TO WS-NEW-ROUTING-NBR 
           ELSE                                                         
               MOVE FCA301-CORRECTED-ACCOUNT-NBRA TO                    
                                                    WS-NEW-BANK-ACCT-NBR
               MOVE FCA301-CORRECTED-ROUTING-NBR  TO WS-NEW-ROUTING-NBR 
           END-IF.                                                      
           PERFORM 7300-FIND-NEW-BANK-ID THRU 7300-EXIT.                
           IF WS-PROCESS-TRANSACTION = 'N'                              
               GO TO 7500-EXIT                                          
           END-IF.                                                      
HONK       EXEC SQL UPDATE CSS_BANK_EFT                                 
HONK           SET BANK_ID      = :WS-CORRECTED-BANK-ID                 
HONK           WHERE ACCOUNT_NO    = :WS-ACCOUNT-NO       AND           
HONK              BANK_ACCT_NO     = :FCA301-BANK-ACCOUNT AND           
HONK                 BANK_ID       = :WS-BANK-ID                        
HONK       END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EVALUATE SQLCODE                                             
               WHEN 0                                                   
                   CONTINUE                                             
               WHEN 100                                                 
                   DISPLAY FCA301-ACCOUNT-NBR ' '                       
                           FCA301-BANK-ACCOUNT   ' '                    
                           WS-BANK-ID     '  BYPASSED - NOT FOUND'      
                             ' - 7500'                                  
                   MOVE SPACES TO AUDITREP-RECORD                       
                   MOVE WS-BANK-ID TO WS-BANK-NO-DISP                   
                   STRING FCA301-ACCOUNT-NBR  ' '                       
                          FCA301-BANK-ACCOUNT ' '                       
                          WS-BANK-NO-DISP                               
                          ' BYPASSED - NOT FOUND - 7500'                
                       DELIMITED BY SIZE                                
                       INTO AUDITREP-RECORD                             
                   PERFORM 8000-REPORT                                  
               WHEN OTHER                                               
                   MOVE 'UPDATE'              TO WS-DB2-FUNCTION        
                   MOVE SQLCODE               TO WS-DB2-RETURN-CODE     
                   MOVE ' '                   TO WS-DB2-MODULE-ID       
                   MOVE '7500'                TO WS-DB2-PARAGRAPH       
                   MOVE FCA301-ACCOUNT-NBR    TO WS-DB2-KEY-1           
                   MOVE WS-NEW-BANK-ACCT-NBR  TO WS-DB2-KEY-2           
                   MOVE WS-BANK-ID            TO WS-DB2-KEY-3N          
                   MOVE 12                    TO WS-RETURN-CODE         
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07650000
       7550-TRANS-HIST-HDR.                                             
           MOVE 'F'                    TO MH-CODE-TRAN-TYPE.            
           MOVE SPACES                 TO MH-RESP-AREA-ID.              
           MOVE WS-ACCOUNT-NO          TO MH-ACCOUNT-NO.                
           MOVE WS-CUSTOMER-NO         TO MH-CUSTOMER-NO.               
           MOVE 0                      TO MH-PREMISE-NO                 
                                          MI-TRAN-APPL-NO.              
           MOVE ' '                    TO MH-ENTITY-KEY-DESC-TEXT.      
           MOVE 1                      TO MH-ENTITY-KEY-DESC-LEN.       
           MOVE 'SYSTEM'               TO MH-USER-ID.                   
           MOVE WS-APPL-PROGRAM-ID     TO MH-APPL-PROGRAM-ID.           
           MOVE +33                    TO MH-TRAN-COMMENT-LEN.          
           MOVE 'MAINTAIN BANK ACCOUNT INFO'                            
                                       TO MH-TRAN-COMMENT-TEXT.         
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :MH-TRANS-HIST-SEQ-NO            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                    
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE MH-TRANS-HIST-SEQ-NO   TO MH-DATE-TRANS                 
           EXEC SQL                                                     
               INSERT INTO CSS_MNT_TRANS_HIST                           
                      (ACCOUNT_NO,                                      
                       APPL_PROGRAM_ID,                                 
                       CODE_TRAN_TYPE,                                  
                       CUSTOMER_NO,                                     
                       DATE_TRANS,                                      
                       ENTITY_KEY_DESC,                                 
                       PREMISE_NO,                                      
                       RESP_AREA_ID,                                    
                       TRAN_COMMENT,                                    
                       TRANS_HIST_SEQ_NO,                               
                       USER_ID)                                         
               VALUES                                                   
                      (:MH-ACCOUNT-NO,                                  
                       :MH-APPL-PROGRAM-ID,                             
                       :MH-CODE-TRAN-TYPE,                              
                       :MH-CUSTOMER-NO,                                 
                       IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) ),                              
                       :MH-ENTITY-KEY-DESC,                             
                       :MH-PREMISE-NO,                                  
                       :MH-RESP-AREA-ID,                                
                       :MH-TRAN-COMMENT,                                
                       CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO),               
                       :MH-USER-ID)                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MNT_TRANS_HIST                                   
MFA-TR*               (ACCOUNT_NO,                                              
MFA-TR*                APPL_PROGRAM_ID,                                         
MFA-TR*                CODE_TRAN_TYPE,                                          
MFA-TR*                CUSTOMER_NO,                                             
MFA-TR*                DATE_TRANS,                                              
MFA-TR*                ENTITY_KEY_DESC,                                         
MFA-TR*                PREMISE_NO,                                              
MFA-TR*                RESP_AREA_ID,                                            
MFA-TR*                TRAN_COMMENT,                                            
MFA-TR*                TRANS_HIST_SEQ_NO,                                       
MFA-TR*                USER_ID)                                                 
MFA-TR*        VALUES                                                           
MFA-TR*               (:MH-ACCOUNT-NO,                                          
MFA-TR*                :MH-APPL-PROGRAM-ID,                                     
MFA-TR*                :MH-CODE-TRAN-TYPE,                                      
MFA-TR*                :MH-CUSTOMER-NO,                                         
MFA-TR*                :MH-DATE-TRANS,                                          
MFA-TR*                :MH-ENTITY-KEY-DESC,                                     
MFA-TR*                :MH-PREMISE-NO,                                          
MFA-TR*                :MH-RESP-AREA-ID,                                        
MFA-TR*                :MH-TRAN-COMMENT,                                        
MFA-TR*                :MH-TRANS-HIST-SEQ-NO,                                   
MFA-TR*                :MH-USER-ID)                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = 0                                           
               MOVE 'INSERT'             TO WS-DB2-FUNCTION             
               MOVE SQLCODE              TO WS-DB2-RETURN-CODE          
               MOVE ' '                  TO WS-DB2-MODULE-ID            
               MOVE '2900'               TO WS-DB2-PARAGRAPH            
               MOVE MH-TRANS-HIST-SEQ-NO TO WS-DB2-KEY-1                
               MOVE 12                   TO WS-RETURN-CODE              
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
       7550-EXIT.                                                       
           EXIT.                                                        
       7570-THIST-BANK-ACCOUNT.                                         
           MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO.          
           MOVE 'BANK ACCT NO'        TO MI-COLUMN-DESC.                
           MOVE 19                    TO MI-PRV-COLUMN-VALUE-LEN        
                                         MI-CHG-COLUMN-VALUE-LEN.       
           MOVE FCA301-BANK-ACCOUNT   TO WS-OLD-UPD-BANK-ACCT.          
           MOVE WS-NEW-BANK-ACCT-NBR  TO WS-NEW-UPD-BANK-ACCT.          
           PERFORM 3000-MASK-BANK-ACCT THRU 3000-EXIT.                  
           MOVE WS-OLD-UPD-BANK-ACCT  TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE WS-NEW-UPD-BANK-ACCT  TO MI-CHG-COLUMN-VALUE-TEXT.      
           ADD +1                     TO MI-TRAN-APPL-NO.               
           MOVE WS-TABLE-ID           TO MI-TABLE-ID.                   
           PERFORM 7700-INSERT-TRANS-HIST-DETAIL.                       
       7570-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPDCA038                                                 
           END-EXEC.                                                            
                                                                        
       7620-THIST-ROUTING-NBR.                                          
           MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO           
           MOVE 'ROUTING NO  '        TO MI-COLUMN-DESC.                
           MOVE 9                     TO MI-PRV-COLUMN-VALUE-LEN        
                                         MI-CHG-COLUMN-VALUE-LEN.       
           MOVE FCA301-ROUTING-NBR    TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE WS-NEW-ROUTING-NBR    TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE WS-ROUTING-TABLE-ID   TO MI-TABLE-ID.                   
           ADD +1                     TO MI-TRAN-APPL-NO                
           PERFORM 7700-INSERT-TRANS-HIST-DETAIL.                       
       7620-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7700-INSERT-TRANS-HIST-DETAIL.                                   
           EXEC SQL INSERT                                              
               INTO CSS_MT_TRN_HST_DET                                  
                      (TRANS_HIST_SEQ_NO,                               
                       TRAN_APPL_NO,                                    
                       COLUMN_DESC,                                     
                       PRV_COLUMN_VALUE,                                
                       CHG_COLUMN_VALUE,                                
                       TABLE_ID)                                        
               VALUES                                                   
                      (CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO),               
                       :MI-TRAN-APPL-NO,                                
                       :MI-COLUMN-DESC,                                 
                       :MI-PRV-COLUMN-VALUE,                            
                       :MI-CHG-COLUMN-VALUE,                            
                       :MI-TABLE-ID)                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL INSERT                                                      
MFA-TR*        INTO CSS_MT_TRN_HST_DET                                          
MFA-TR*               (TRANS_HIST_SEQ_NO,                                       
MFA-TR*                TRAN_APPL_NO,                                            
MFA-TR*                COLUMN_DESC,                                             
MFA-TR*                PRV_COLUMN_VALUE,                                        
MFA-TR*                CHG_COLUMN_VALUE,                                        
MFA-TR*                TABLE_ID)                                                
MFA-TR*        VALUES                                                           
MFA-TR*               (:MI-TRANS-HIST-SEQ-NO,                                   
MFA-TR*                :MI-TRAN-APPL-NO,                                        
MFA-TR*                :MI-COLUMN-DESC,                                         
MFA-TR*                :MI-PRV-COLUMN-VALUE,                                    
MFA-TR*                :MI-CHG-COLUMN-VALUE,                                    
MFA-TR*                :MI-TABLE-ID)                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = 0                                           
               MOVE 'INSERT'             TO WS-DB2-FUNCTION             
               MOVE SQLCODE              TO WS-DB2-RETURN-CODE          
               MOVE ' '                  TO WS-DB2-MODULE-ID            
               MOVE '7700'               TO WS-DB2-PARAGRAPH            
               MOVE MI-TRANS-HIST-SEQ-NO TO WS-DB2-KEY-1                
               MOVE 12                   TO WS-RETURN-CODE              
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09270000
       7800-OPEN-BANK-ACCT-CSR.                                         
           EXEC SQL                                                     
               OPEN   BANK_ACCOUNT_UPD                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = 0                                           
               MOVE 'OPEN  '            TO WS-DB2-FUNCTION              
               MOVE SQLCODE             TO WS-DB2-RETURN-CODE           
               MOVE ' '                 TO WS-DB2-MODULE-ID             
               MOVE '7800'              TO WS-DB2-PARAGRAPH             
               MOVE ' '                 TO WS-DB2-KEY-1                 
               MOVE 12                  TO WS-RETURN-CODE               
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14990000
       7810-FETCH-BANK-ACCT-CSR.                                        
           EXEC SQL                                                     
               FETCH  BANK_ACCOUNT_UPD                                  
               INTO   :WS-TABLE-ID,                                     
                      :WS-BANK-ID,                                      
                      :WS-CUSTOMER-NO,                                  
                      :WS-BANK-SEQ-NO                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = 0 AND 100                                   
               MOVE 'FETCH '            TO WS-DB2-FUNCTION              
               MOVE SQLCODE             TO WS-DB2-RETURN-CODE           
               MOVE ' '                 TO WS-DB2-MODULE-ID             
               MOVE '7810'              TO WS-DB2-PARAGRAPH             
               MOVE 12                  TO WS-RETURN-CODE               
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
       7810-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14990000
       7820-CLOSE-BANK-ACCT-CSR.                                        
           EXEC SQL                                                     
               CLOSE  BANK_ACCOUNT_UPD                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = 0                                           
               MOVE 'CLOSE '            TO WS-DB2-FUNCTION              
               MOVE SQLCODE             TO WS-DB2-RETURN-CODE           
               MOVE ' '                 TO WS-DB2-MODULE-ID             
               MOVE '7800'              TO WS-DB2-PARAGRAPH             
               MOVE ' '                 TO WS-DB2-KEY-1                 
               MOVE 12                  TO WS-RETURN-CODE               
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
       7820-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14990000
       7900-OPEN-ROUTING-NBR-CSR.                                       
           EXEC SQL                                                     
               OPEN   ROUTING_NBR_UPD                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = 0                                           
               MOVE 'OPEN  '            TO WS-DB2-FUNCTION              
               MOVE SQLCODE             TO WS-DB2-RETURN-CODE           
               MOVE ' '                 TO WS-DB2-MODULE-ID             
               MOVE '7900'              TO WS-DB2-PARAGRAPH             
               MOVE ' '                 TO WS-DB2-KEY-1                 
               MOVE 12                  TO WS-RETURN-CODE               
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14990000
       7910-FETCH-ROUTING-NBR-CSR.                                      
           EXEC SQL                                                     
               FETCH  ROUTING_NBR_UPD                                   
               INTO   :WS-ROUTING-TABLE-ID,                             
                      :WS-BANK-ID,                                      
                      :WS-CUSTOMER-NO,                                  
                      :WS-BANK-SEQ-NO                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = 0 AND 100                                   
               MOVE 'FETCH '            TO WS-DB2-FUNCTION              
               MOVE SQLCODE             TO WS-DB2-RETURN-CODE           
               MOVE ' '                 TO WS-DB2-MODULE-ID             
               MOVE '7910'              TO WS-DB2-PARAGRAPH             
               MOVE 12                  TO WS-RETURN-CODE               
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
       7910-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14990000
       7920-CLOSE-ROUTING-NBR-CSR.                                      
           EXEC SQL                                                     
               CLOSE  ROUTING_NBR_UPD                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = 0                                           
               MOVE 'CLOSE '            TO WS-DB2-FUNCTION              
               MOVE SQLCODE             TO WS-DB2-RETURN-CODE           
               MOVE ' '                 TO WS-DB2-MODULE-ID             
               MOVE '7920'              TO WS-DB2-PARAGRAPH             
               MOVE ' '                 TO WS-DB2-KEY-1                 
               MOVE 12                  TO WS-RETURN-CODE               
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
       7920-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14990000
       8000-REPORT.                                                     
           WRITE AUDITREP-RECORD.                                       
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14990000
       8100-READ-NOCFILE .                                              
           READ NOCFILE AT END                                          
               MOVE 'Y' TO WS-EOF.                                      
       8200-UPDATE-LIST.                                                
           MOVE SPACES TO UPDATREP-REC.                                 
           IF NOC-TRANS-TYPE = 'C02'                                    
               MOVE SPACES                   TO WS-NEW-UPD-BANK-ACCT    
                                                WS-OLD-UPD-BANK-ACCT    
           ELSE                                                         
               MOVE FCA301-BANK-ACCOUNT      TO WS-OLD-UPD-BANK-ACCT    
               IF NOC-TRANS-TYPE = 'C01'                                
                   MOVE FCA301-CORRECTED-ACCOUNT-NBRB                   
                                             TO WS-NEW-UPD-BANK-ACCT    
               ELSE                                                     
                   MOVE FCA301-CORRECTED-ACCOUNT-NBRA                   
                                             TO WS-NEW-UPD-BANK-ACCT    
               END-IF                                                   
               PERFORM 3000-MASK-BANK-ACCT                              
           END-IF.                                                      
           MOVE   WS-ACCOUNT-NO TO WS-PRINT-ACCOUNT.                    
           INSPECT WS-PRINT-ACCOUNT REPLACING ALL ' ' BY '-'.           
           STRING WS-PRINT-ACCOUNT       ','                            
                  NOC-TRANS-TYPE         ','                            
                  WS-OLD-UPD-ROUTING-NBR ','                            
                  WS-NEW-UPD-ROUTING-NBR ','                            
                  WS-OLD-UPD-BANK-ACCT   ','                            
                  WS-NEW-UPD-BANK-ACCT   ','                            
                DELIMITED BY SIZE                                       
                INTO UPDATREP-REC.                                      
           PERFORM 8300-WRITE-UPDATE-LOG.                               
       8200-EXIT.                                                       
           EXIT.                                                        
       8300-WRITE-UPDATE-LOG.                                           
           WRITE UPDATREP-REC.                                          
       8300-WRITE-EXIT.                                                 
           EXIT.                                                        
       8900-COMMIT.                                                     
           EXEC SQL                                                     
                COMMIT                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
       8900-EXIT.                                                       
           EXIT.                                                        
       9000-SEND-ERROR-RESULT.                                          
           EXIT.                                                        
       9000-TERMINATE.                                                  
           CLOSE NOCFILE AUDITREP UPDATREP.                             
           MOVE WS-RETURN-CODE TO RETURN-CODE.                          
           STOP RUN.                                                    
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16280000
           EXEC SQL                                                     16850000
               INCLUDE CPD0023B                                         16860000
           END-EXEC.                                                    16870000
      *                                                                 16880000
       9900-SQL-ERROR-ROUTINE.                                          
                                                                        
           MOVE SQLCODE                TO WS-DISPLAY-SQLCODE.           
           DISPLAY ' '                                                  
           DISPLAY '**********************************************'     
           DISPLAY '***** 9900-SQL-ERROR-ROUTINE            ******'     
           DISPLAY '**********************************************'     
           DISPLAY ' '                                                  
           DISPLAY 'SQLCODE = ' WS-DISPLAY-SQLCODE                      
           DISPLAY ABEND-RECORD-1-DATA                                  
           DISPLAY ABEND-RECORD-2-DATA                                  
           DISPLAY ABEND-RECORD-3-DATA                                  
           DISPLAY '**********************************************'.    
           PERFORM 9900-ABEND                    THRU 9900-EXIT.        
      *                                                                 16840000
           EXEC SQL                                                     16850000
               INCLUDE CPD09900                                         16860000
           END-EXEC.                                                    16870000
