       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.      PCSCA300.                                       
       AUTHOR.          ED DREW.                                        
       DATE-WRITTEN.    NOVEMBER 2013.                                  
      ***************************************************************** 00060000
      ********            CUSTOMER SERVICE SYSTEM             ********* 00070000
      ***************************************************************** 00080000
      **                                                             ** 00090000
      **              PROGRAM  MODIFICATION  LOG                     ** 00100000
      **                                                             ** 00110000
      **    DATE    INITIALS     REASON                              ** 00120000
      **    -----   --------     ------                              ** 00602200
ACT080**  04/01/15  BD09555      1)  ADD NEW SEB PREMISE NUMBER TO   ** 00602300
ACT080**  A05136-ACT080              MESSAGE LOG.                    ** 00602400
ACT080**                         2)  ADD 'WAREHOUSE' AND 'HOUSE'  TO ** 00602500
ACT080**                             LIST OF ITEMS TO BE CONVERTED TO** 00602500
ACT080**                             FIT INTO STREET_LOCATION-1.     ** 00602600
ACT080**                         3)  IF THERE IS A LOCATOR ID, BUT   ** 00605000
ACT080**                             NO LOCATOR NUMBER, MOVE THE     ** 00606000
ACT080**                             LOCATOR-ID TO STREET_LOCATION_1 **         
ACT080**                             INSTEAD OF OVERFLOW.            **         
ACT151**  08/17/15  BD09555      1)  USE NEW SP CSR04837 for new     ** 00602300
ACT151**                             PREMISE CREATION                ** 00602300
ACT151**                         2)  SELECT NEW PREMISES TO TEMPORARY** 00602300
ACT151**                             FILE TO IMPROVE UPDATE PROCESS. ** 00602300
      *****************************************************************         
      **              PROGRAM NARRATIVE                              **         
      *****************************************************************         
      **  READ THE AGL CUSTOMER FILE, AND CREATE PREMISE RECORDS FOR **         
      **  NEWLY ADDED PREMISES.                                      **         
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT AGLFILE                                               
               ASSIGN TO AGLFILE.                                       
ACT151     SELECT AGLTEMP                                               
ACT151         ASSIGN TO AGLTEMP.                                       
           SELECT MSGLOG                                                
               ASSIGN TO MSGLOG.                                        
      *                                                                 00710000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD AGLFILE                                                       
           BLOCK CONTAINS 0 RECORDS.                                    
       01  AGLFILE-RECORD               PIC X(995).                     
ACT151 FD AGLTEMP                                                       
ACT151     BLOCK CONTAINS 0 RECORDS.                                    
ACT151 01  AGLTEMP-RECORD               PIC X(995).                     
       FD MSGLOG                                                        
           BLOCK CONTAINS 0 RECORDS.                                    
       01  MSGLOG-REC                   PIC X(140).                     
      *                                                                 00760000
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA300'.
MSQ017     COPY MFASQLM.
ACT151 77  WS-EOF-AGLTEMP                PIC X        VALUE 'N'.        
ACT151     88  END-OF-AGLTEMP                         VALUE 'Y'.        
       77  WS-EOF-AGLFILE                PIC X        VALUE 'N'.        
           88  END-OF-AGLFILE                         VALUE 'Y'.        
       77  WS-HOUSE-NUMBER-LENGTH        PIC S99      COMP.             
       77  WS-CURRENT-ZIP-COUNT          PIC 99999    VALUE 2000.       
COB305 77 WS-SEB-PREMISE-NO        PIC S9(10) COMP-3 VALUE 0.          
COB305 77 WS-AGL-PREMISE-NO        PIC S9(09) COMP-3 VALUE 0.          
       77  WS-AGL-PREMISE-STREET-NO      PIC X(15).                     
       77  WS-AGL-SERVICE-CENTER         PIC X(25).                     
       77  WS-NEW-PREMISE                PIC X(1).                      
           88 NEW-PREMISE                              VALUE 'Y'.       
       77  WS-OUT-PREM                   PIC 9(10).                     
       77  WS-RETURN-CODE                PIC S9(4)     COMP.            
       77  WS-SQL-RETURN-CODE            PIC S9(4)     COMP.            
       77  S-RETURN-CODE                 PIC S9(4)     COMP.            
       77  S-STATUS-CODE                 PIC S9(9)     COMP.            
       77  I                             PIC S9(4)     COMP.            
      *01  LOC1            USAGE IS SQL TYPE IS                         
      *                    RESULT-SET-LOCATOR VARYING.                  
       01  S-PREMISE-NO                  PIC X(10).                     
       01  S-PREMISE-NO-NUM REDEFINES S-PREMISE-NO     PIC 9(10).       
       01  PARM-INFO.                                                   
           05  PARM-UPDATE-TYPE        PIC X(01).                       
           05  PARM-PREMISE-NO         PIC X(10).                       
           05  PARM-ADDR-USAGE-CD      PIC X(01).                       
           05  PARM-HOUSE-NO           PIC X(15).                       
           05  PARM-ADDR-PREFIX-1      PIC X(03).                       
           05  PARM-ADDR-PREFIX-2      PIC X(02).                       
           05  PARM-STREET-NAME        PIC X(30).                       
           05  PARM-STREET-SUFFIX      PIC X(04).                       
           05  PARM-ADDR-SUFFIX        PIC X(02).                       
           05  PARM-STREET-LOC-1       PIC X(04).                       
           05  PARM-STREET-LOC-2       PIC X(11).                       
           05  PARM-ZIP-CODE           PIC X(05).                       
           05  PARM-ZIP-CODE-PLUS-FOUR PIC X(04).                       
           05  PARM-TOWN               PIC X(26).                       
           05  PARM-DELIVERY-POINT     PIC X(02).                       
           05  PARM-ADDRESS-OVERFLOW   PIC X(35).                       
           05  PARM-LOCAL-OFFICE       PIC X(03).                       
           05  PARM-COMPANY-NO         PIC X(02).                       
           05  PARM-SUBDIVISION-ID     PIC X(03).                       
           05  PARM-LOT                PIC X(05).                       
           05  PARM-BLOCK              PIC X(05).                       
           05  PARM-COUNTY             PIC X(03).                       
           05  PARM-LOCATOR-ID         PIC X(09).                       
           05  PARM-CITY-GATE-ID       PIC X(07).                       
           05  PARM-READ-ROUTE         PIC S9(4)      COMP.             
           05  PARM-LEAK-SURVEY-DT     PIC X(10).                       
           05  PARM-LEAK-SURVEY-FREQ   PIC X(02).                       
           05  PARM-REV-DISTRICT       PIC X(03).                       
           05  PARM-CROSS-STREET-1     PIC X(35).                       
           05  PARM-CROSS-STREET-2     PIC X(35).                       
COB305     05 PARM-LATITUDE        PIC S9(3)V9(6) COMP-3 VALUE 0.           
COB305     05 PARM-LONGITUDE        PIC S9(3)V9(6) COMP-3 VALUE 0.           
COB305     05 PARM-AGL-PREMISE-NO        PIC S9(9)V COMP-3 VALUE 0.           
           05  PARM-DIRECTIONS         PIC X(255).                      
           05  PARM-SCRATCH-PAD        PIC X(255).                      
           05  PARM-SPECIAL-INST       PIC X(255).                      
           05  PARM-SPECIAL-READ-INST  PIC X(255).                      
           05  PARM-DATE-SPCL-MSG-ENDS PIC X(10).                       
           05  PARM-FM-ELEC-SVC-WKDIST PIC X(40).                       
           05  PARM-FM-GAS-OPS-WKDIST  PIC X(40).                       
           05  PARM-FM-FLD-SVCS-WKDIST PIC X(40).                       
           05  PARM-FM-REV-PRT-WKDIST  PIC X(40).                       
           05  PARM-FM-DSM-ESVC-WKDIST PIC X(40).                       
COB305     05 PARM-DDDC-FCTR        PIC S9(9)V9(4) COMP-3 VALUE 0.           
           05  PARM-SEB-ENVRNMT        PIC X(01).                       
           05  PARM-USERID             PIC X(07).                       
           05  PARM-COMMENTS           PIC X(210).                      
           05  PARM-STATE              PIC X(02).                       
           05  PARM-NEAREST-PREM-NO    PIC X(10).                       
           05  PARM-GIS-STATUS-CD      PIC S9(4)      COMP.             
           05  PARM-ADDRESS-SOURCE     PIC X.                           
       01  WS-LOCATORS.                                                 
           05  WS-LOCATOR-1                  PIC X(15).                 
           05  FILLER REDEFINES WS-LOCATOR-1.                           
               10  FILLER                    PIC X(04).                 
               10  WS-LOCATOR-1-REST         PIC X(11).                 
           05  WS-LOCATOR-2                  PIC X(13).                 
           05  FILLER REDEFINES WS-LOCATOR-2.                           
               10  FILLER                    PIC X(11).                 
               10  WS-LOCATOR-2-REST         PIC X(02).                 
           05  WS-LOCATOR-3                  PIC X(11).                 
           05  WS-LOCATOR-4                  PIC X(09).                 
           05  WS-LOCATOR-5                  PIC X(07).                 
       01  WS-STRUCTURE                  PIC X(15).                     
       01  WS-LEN                        PIC S9999 COMP VALUE 0.        
       01  WS-START-POS                  PIC S9999 COMP VALUE 0.        
       01  WS-UPDATE-CT                  PIC S9999999 VALUE +0.         
       01  FILLER REDEFINES WS-UPDATE-CT.                               
           03  WS-COMMIT-CT              PIC 99999.                     
           03  WS-COMMIT-TEST            PIC S99.                       
      *                                                                 04641000
      *                                                                 04650000
      **************************************************************    04660000
      * COPYBOOKS FOR THE PURPOSE OF DISPLAYING ERROR MESSAGES     *    04670000
      **************************************************************    04680000
           COPY CWS00023.                                               04691009
           COPY CWS09900.                                               04710000
           COPY CWS00010.                                               04720000
       01  WS-START                           PIC X(40) VALUE           
           'WORKING STORAGE FOR RPC S037 STARTS HERE'.                  
      ******************************************************************02920000
      *    COBOL WORKING STORAGE COPY BOOKS                            *02930000
      ******************************************************************02940000
           EXEC SQL                                                     04752027
               INCLUDE TBPREM                                           04753027
           END-EXEC.                                                    04760000
           EXEC SQL                                                             
               INCLUDE FIOAGLFL                                         00750000
           END-EXEC.                                                            
           EXEC SQL                                                     04761003
               INCLUDE SQLCA                                            04762003
           END-EXEC.                                                    04763003
MSQ001        EXEC SQL
MSQ001          DECLARE C1 CURSOR
MSQ001          FOR CALL CSR04837 ( :PARM-UPDATE-TYPE
                  , :PARM-PREMISE-NO
                  , :PARM-ADDR-USAGE-CD
                  , :PARM-HOUSE-NO
                  , :PARM-ADDR-PREFIX-1
                  , :PARM-ADDR-PREFIX-2
                  , :PARM-STREET-NAME
                  , :PARM-STREET-SUFFIX
                  , :PARM-ADDR-SUFFIX
                  , :PARM-STREET-LOC-1
                  , :PARM-STREET-LOC-2
                  , :PARM-ZIP-CODE
                  , :PARM-ZIP-CODE-PLUS-FOUR
                  , :PARM-TOWN
                  , :PARM-DELIVERY-POINT
                  , :PARM-ADDRESS-OVERFLOW
                  , :PARM-LOCAL-OFFICE
                  , :PARM-COMPANY-NO
                  , :PARM-SUBDIVISION-ID
                  , :PARM-LOT
                  , :PARM-BLOCK
                  , :PARM-COUNTY
                  , :PARM-LOCATOR-ID
                  , :PARM-CITY-GATE-ID
                  , :PARM-READ-ROUTE
                  , :PARM-LEAK-SURVEY-DT
                  , :PARM-LEAK-SURVEY-FREQ
                  , :PARM-REV-DISTRICT
                  , :PARM-CROSS-STREET-1
                  , :PARM-CROSS-STREET-2
                  , :PARM-LATITUDE
                  , :PARM-LONGITUDE
                  , :PARM-AGL-PREMISE-NO
                  , :PARM-DIRECTIONS
                  , :PARM-SCRATCH-PAD
                  , :PARM-SPECIAL-INST
                  , :PARM-SPECIAL-READ-INST
                  , :PARM-DATE-SPCL-MSG-ENDS
                  , :PARM-FM-ELEC-SVC-WKDIST
                  , :PARM-FM-GAS-OPS-WKDIST
                  , :PARM-FM-FLD-SVCS-WKDIST
                  , :PARM-FM-REV-PRT-WKDIST
                  , :PARM-FM-DSM-ESVC-WKDIST
                  , :PARM-DDDC-FCTR
                  , :PARM-SEB-ENVRNMT
                  , :PARM-USERID
                  , :PARM-COMMENTS
                  , :PARM-STATE
                  , :PARM-NEAREST-PREM-NO
                  , :PARM-GIS-STATUS-CD
                  , :PARM-ADDRESS-SOURCE
                  )
MSQ001        END-EXEC.

      *                                                                 06000000
       PROCEDURE DIVISION.                                              
      *                                                                 06020000
           PERFORM 0100-INITIALIZE THRU 0100-EXIT.                      
           PERFORM 8000-READ-AGLFILE        THRU 8000-EXIT.             
ACT151     PERFORM 7100-TEST-FOR-ALREADY-ADDED THRU 7100-EXIT           
ACT151         UNTIL END-OF-AGLFILE.                                    
ACT151     CLOSE AGLTEMP.                                               
ACT151     OPEN  INPUT AGLTEMP.                                         
ACT151     PERFORM 8100-READ-AGLTEMP    THRU 8100-EXIT                  
           PERFORM 0200-PROCESS-AGLFILE THRU 0200-EXIT                  
               UNTIL END-OF-AGLTEMP.                                    
           PERFORM 9001-TERMINATE THRU 9001-EXIT.                       
                                                                        
       0100-INITIALIZE.                                                 
           OPEN INPUT  AGLFILE                                          
ACT151          OUTPUT AGLTEMP MSGLOG.                                  
           COMPUTE WS-HOUSE-NUMBER-LENGTH =                             
               FUNCTION LENGTH (AGL-PREMISE-STREET-NO).                 
           MOVE 'PCSCA300'  TO ABEND-PROGRAM.                           
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07080000
       0200-PROCESS-AGLFILE.                                            
           INITIALIZE PARM-INFO MSGLOG-REC I.                           
           MOVE AGL-PREMISE-NO            TO  WS-AGL-PREMISE-NO         
                                              PARM-AGL-PREMISE-NO.      
           IF AGL-ZIP-CODE > SPACES                                     
               MOVE AGL-ZIP-CODE          TO  PARM-ZIP-CODE             
           ELSE                                                         
               MOVE AGL-PREMISE-ZIP-CD    TO  PARM-ZIP-CODE             
           END-IF                                                       
           MOVE AGL-PREMISE-CITY-NM       TO  PARM-TOWN.                
           MOVE 'I'                       TO  PARM-UPDATE-TYPE.         
           IF AGL-PREMISE-STREET-NO > SPACES                            
               MOVE AGL-PREMISE-STREET-NO TO  WS-AGL-PREMISE-STREET-NO  
               INSPECT AGL-PREMISE-STREET-NO                            
                   TALLYING I FOR CHARACTERS BEFORE INITIAL '-1/2'      
                   REPLACING FIRST '-1/2' BY '    '                     
               MOVE AGL-PREMISE-STREET-NO TO  PARM-HOUSE-NO             
               IF I < WS-HOUSE-NUMBER-LENGTH                            
                   MOVE '1/2'             TO  PARM-ADDR-PREFIX-1        
               END-IF                                                   
           END-IF.                                                      
           MOVE AGL-PREMISE-ST-PREFIX-CD  TO  PARM-ADDR-PREFIX-2.       
           MOVE 'F'                       TO  PARM-ADDR-USAGE-CD.       
           IF AGL-PREMISE-STRUCT-ID > SPACES                            
               PERFORM 2900-STRUCTURE-ID THRU 2900-EXIT                 
           END-IF.                                                      
           MOVE AGL-PREMISE-STREET-NM     TO  PARM-STREET-NAME.         
           MOVE AGL-PREMISE-STREET-TYP-CD TO  PARM-STREET-SUFFIX.       
           MOVE AGL-PREMISE-ST-SUFFIX-CD  TO  PARM-ADDR-SUFFIX.         
           MOVE AGL-PREMISE-STATE-CD      TO  PARM-STATE.               
           MOVE '001'                     TO  PARM-LOCAL-OFFICE.        
           MOVE '01'                      TO  PARM-COMPANY-NO.          
           MOVE 'ZZY'                     TO  PARM-SUBDIVISION-ID.      
           MOVE '000'                     TO  PARM-COUNTY.              
           MOVE 'AGL'                     TO  PARM-CITY-GATE-ID.        
           MOVE '0000-00-00'              TO  PARM-LEAK-SURVEY-DT.      
           MOVE '008'                     TO  PARM-REV-DISTRICT.        
           MOVE 'SYSTEM'                  TO  PARM-USERID.              
           MOVE AGL-PREMISE-NO            TO  PARM-AGL-PREMISE-NO.      
           MOVE 'D'                       TO  PARM-SEB-ENVRNMT.         
           MOVE 'C'                       TO  PARM-ADDRESS-SOURCE.      
ACT151     COMPUTE PARM-DDDC-FCTR =                                     
ACT151             FUNCTION NUMVAL (AGL-DESIGN-DAY-MCF-QT).             
      *    EXEC SQL                                                     
ACT151*        CALL CSR04837 (:PARM-UPDATE-TYPE ,                       
      *                       :PARM-PREMISE-NO ,                        
      *                       :PARM-ADDR-USAGE-CD ,                     
      *                       :PARM-HOUSE-NO ,                          
      *                       :PARM-ADDR-PREFIX-1 ,                     
      *                       :PARM-ADDR-PREFIX-2 ,                     
      *                       :PARM-STREET-NAME ,                       
      *                       :PARM-STREET-SUFFIX ,                     
      *                       :PARM-ADDR-SUFFIX ,                       
      *                       :PARM-STREET-LOC-1,                       
      *                       :PARM-STREET-LOC-2,                       
      *                       :PARM-ZIP-CODE ,                          
      *                       :PARM-ZIP-CODE-PLUS-FOUR ,                
      *                       :PARM-TOWN ,                              
      *                       :PARM-DELIVERY-POINT ,                    
      *                       :PARM-ADDRESS-OVERFLOW ,                  
      *                       :PARM-LOCAL-OFFICE ,                      
      *                       :PARM-COMPANY-NO ,                        
      *                       :PARM-SUBDIVISION-ID ,                    
      *                       :PARM-LOT ,                               
      *                       :PARM-BLOCK ,                             
      *                       :PARM-COUNTY ,                            
      *                       :PARM-LOCATOR-ID ,                        
      *                       :PARM-CITY-GATE-ID ,                      
      *                       :PARM-READ-ROUTE ,                        
      *                       :PARM-LEAK-SURVEY-DT ,                    
      *                       :PARM-LEAK-SURVEY-FREQ ,                  
      *                       :PARM-REV-DISTRICT ,                      
      *                       :PARM-CROSS-STREET-1 ,                    
      *                       :PARM-CROSS-STREET-2 ,                    
      *                       :PARM-LATITUDE ,                          
      *                       :PARM-LONGITUDE ,                         
      *                       :PARM-AGL-PREMISE-NO ,                    
      *                       :PARM-DIRECTIONS ,                        
      *                       :PARM-SCRATCH-PAD ,                       
      *                       :PARM-SPECIAL-INST ,                      
      *                       :PARM-SPECIAL-READ-INST ,                 
      *                       :PARM-DATE-SPCL-MSG-ENDS ,                
      *                       :PARM-FM-ELEC-SVC-WKDIST ,                
      *                       :PARM-FM-GAS-OPS-WKDIST ,                 
      *                       :PARM-FM-FLD-SVCS-WKDIST ,                
      *                       :PARM-FM-REV-PRT-WKDIST ,                 
      *                       :PARM-FM-DSM-ESVC-WKDIST ,                
      *                       :PARM-DDDC-FCTR ,                         
      *                       :PARM-SEB-ENVRNMT ,                       
      *                       :PARM-USERID ,                            
      *                       :PARM-COMMENTS ,                          
      *                       :PARM-STATE ,                             
      *                       :PARM-NEAREST-PREM-NO ,                   
      *                       :PARM-GIS-STATUS-CD,                      
ACT151*                       :PARM-ADDRESS-SOURCE)                     
      *    END-EXEC                                                     

MSQ001        EXEC SQL
MSQ001          CLOSE C1
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C1
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C1 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
           IF SQLCODE = 466                                             
               PERFORM 7000-ADD-SERVICE-CENTER THRU 7000-EXIT           
           ELSE                                                         
ACT151         DISPLAY 'CSR04837 SQL CODE = ' SQLCODE ' AGL PREMISE = ' 
                   PARM-AGL-PREMISE-NO                                  
               MOVE 4 TO WS-RETURN-CODE                                 
           END-IF.                                                      
           MOVE PR-PREMISE-NO TO WS-OUT-PREM.                           
           MOVE ' ' TO MSGLOG-REC.                                      
           STRING  S-PREMISE-NO              ' '                        
                   AGL-PREMISE-NO            ' '                        
                   AGL-ACCOUNT-NUMBER        ' '                        
                   WS-AGL-PREMISE-STREET-NO                             
                   AGL-PREMISE-ST-PREFIX-CD  ' '                        
                   AGL-PREMISE-STREET-NM                                
                   AGL-PREMISE-STREET-TYP-CD ' '                        
                   AGL-PREMISE-ST-SUFFIX-CD  ' '                        
                   AGL-PREMISE-STRUCT-ID     ' '                        
                   AGL-PREMISE-CITY-NM                                  
                   AGL-PREMISE-ZIP-CD  ' WAS ADDED'                     
                   DELIMITED BY SIZE INTO MSGLOG-REC.                   
           WRITE MSGLOG-REC.                                            
           ADD +1 TO WS-UPDATE-CT.                                      
           IF WS-COMMIT-TEST = 0                                        
               EXEC SQL                                                 
                   COMMIT                                               
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               DISPLAY 'PCSCA300 - COMMIT #' WS-COMMIT-CT               
           END-IF.                                                      
           PERFORM 8100-READ-AGLTEMP    THRU 8100-EXIT.                 
       0200-EXIT.                                                       
           EXIT.                                                        
       2900-STRUCTURE-ID.                                               
      ******************************************************************        
      *STRUCTURE ID IS A COMBINATION OF LOCATOR INFO AND/OR OVERFLOW.  *        
      *LOCATOR INFORMATION (LIKE 'APT A4') IS ASSUMED TO BE IN THE     *        
      *FIRST PART OF THE STRUCTURE ID.  OUR TABLES ALLOW A LOCATOR     *        
      *TYPE (UNIT, APT, LOT, ETC.) TO BE ONLY FOUR BYTES LONG, AND THE *        
      *LOCATOR NUMBER TO BE NO MORE THAN 11.  THE STRUCTURE ID IS      *        
      *'UNSTRUNG' INTO AS MANY AS FIVE DIFFERENT COMPONENTS.  THEN     *        
      *THE FOLLOWING RULES APPLY IN THIS ORDER:                        *        
      *1)  IF THE FIRST COMPONENT IS MORE THAN FOUR BYTES ==OR== THE   *        
      *    SECOND COMPONENT IS MORE THAN 11, THEY ARE NOT CONVERTIBLE  *        
      *    TO LOCATOR TYPE AND NUMBER, SO THE ENTIRE STRUCTURE ID IS   *        
      *    MOVED TO OVERFLOW WITHOUT CONVERSION.                       *        
      *2)  AT THIS POINT, WE KNOW THAT WE HAVE A LOCATOR TYPE AND      *        
      *    NUMBER THAT ARE COMPATIBLE WITH THE ADDRESS TABLE, SO THEY  *        
      *    ARE LOADED ACCORDINGLY.                                     *        
      *3)  IF THERE IS A FOURTH COMPONENT, STRING COMPONENTS #3, #4,   *        
      *    AND #5 INTO THE OVERFLOW.                                   *        
      *4)  IF THERE IS NO FOURTH COMPONENT, SIMPLY MOVE COMPONENT #3   *        
      *    TO THE OVERFLOW.                                            *        
      *5)  IF THERE IS A FIFTH COMPONENT,SET A MESSAGE TO LET SOMEONE  *        
      *    KNOW TO LOOK AT IT IN CASE IT IS A MISTAKE.  (SO FAR, OUT OF*        
      *    OVER 1.7 MILLION ADDRESSES, NONE HAVE HAD MORE THAN FOUR    *        
      *    COMPONENTS.                                                 *        
      ******************************************************************        
           MOVE SPACES TO WS-LOCATORS                                   
                          MSGLOG-REC                                    
                          WS-CMP-TABLE.                                 
           MOVE AGL-PREMISE-STRUCT-ID TO WS-EMB-INPUT.                  
           MOVE 15           TO WS-EMB-LENG.                            
           PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT.          
           MOVE WS-CMP-TABLE TO WS-STRUCTURE.                           
           UNSTRING WS-STRUCTURE DELIMITED BY ' '                       
               INTO WS-LOCATOR-1                                        
                    WS-LOCATOR-2                                        
                    WS-LOCATOR-3                                        
                    WS-LOCATOR-4                                        
                    WS-LOCATOR-5.                                       
           IF WS-LOCATOR-1 = 'APT(#)'    OR 'Apt(#)'   OR '#'           
               MOVE 'APT' TO WS-LOCATOR-1                               
           END-IF.                                                      
           IF WS-LOCATOR-1 = 'BUILDING'  OR 'Building'                  
               MOVE 'BLDG' TO WS-LOCATOR-1                              
           END-IF.                                                      
           IF WS-LOCATOR-1 = 'HOUSE'     OR 'House'                     
               MOVE 'HSE' TO WS-LOCATOR-1                               
           END-IF.                                                      
           IF WS-LOCATOR-1 = 'SUITE'     OR 'Suite'                     
               MOVE 'STE' TO WS-LOCATOR-1                               
           END-IF.                                                      
           IF WS-LOCATOR-1 = 'WAREHOUSE' OR 'Warehouse'                 
               MOVE 'WHSE' TO WS-LOCATOR-1                              
           END-IF.                                                      
           IF WS-LOCATOR-1-REST > SPACES OR                             
              WS-LOCATOR-2-REST > SPACES                                
                   MOVE WS-STRUCTURE TO PARM-ADDRESS-OVERFLOW           
                   STRING  'STRUCTURE ' WS-STRUCTURE                    
                       ' WAS MOVED WITHOUT CONVERSION'                  
                       DELIMITED BY SIZE                                
                       INTO MSGLOG-REC                                  
           ELSE                                                         
               MOVE WS-LOCATOR-1 TO PARM-STREET-LOC-1                   
               MOVE WS-LOCATOR-2 TO PARM-STREET-LOC-2                   
               IF WS-LOCATOR-4 > SPACES                                 
                   STRING WS-LOCATOR-3 '' WS-LOCATOR-4 ''             
                          WS-LOCATOR-5                                  
                          DELIMITED BY ' ' INTO PARM-ADDRESS-OVERFLOW   
                   INSPECT PARM-ADDRESS-OVERFLOW                        
                       REPLACING ALL '' BY ' '                         
               ELSE                                                     
                   MOVE WS-LOCATOR-3 TO PARM-ADDRESS-OVERFLOW           
               END-IF                                                   
               STRING  'STRUCTURE ' WS-STRUCTURE ' CONVERTED TO '       
                   WS-LOCATOR-1 ' ' WS-LOCATOR-2 ' '                    
                   PARM-ADDRESS-OVERFLOW DELIMITED BY SIZE              
                   INTO MSGLOG-REC                                      
           END-IF.                                                      
           IF WS-LOCATOR-5 > SPACES                                     
               DISPLAY 'STRUCTURE ID ' AGL-PREMISE-STRUCT-ID            
                   ' FOR AGL PREMISE #' AGL-PREMISE-NO                  
                   ' HAS MORE THAN FOUR COMPONENTS'                     
                   MOVE 4 TO WS-RETURN-CODE                             
           END-IF.                                                      
           WRITE MSGLOG-REC.                                            
       2900-EXIT.                                                       
           EXIT.                                                        
                                                                        
           COPY CPD00004.                                               16860000
                                                                        
       7000-ADD-SERVICE-CENTER.                                         
      *    EXEC SQL ASSOCIATE LOCATORS(:LOC1) WITH PROCEDURE            
      *      CSR04837                                                   
      *    END-EXEC                                                     
      *    EXEC SQL ALLOCATE C1 CURSOR FOR RESULT SET :LOC1             
      *    END-EXEC                                                     
           EXEC SQL                                                     
               FETCH C1 INTO :S-RETURN-CODE                             
                            ,:S-STATUS-CODE                             
                            ,:S-PREMISE-NO                              
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF S-RETURN-CODE = 0 AND SQLCODE = 0                         
               MOVE S-PREMISE-NO-NUM   TO WS-SEB-PREMISE-NO             
               MOVE AGL-SERVICE-CENTER TO WS-AGL-SERVICE-CENTER         
               EXEC SQL                                                 
                   UPDATE CSS_PREMISE                                   
                   SET AGL_SERVICE_CENTER = :WS-AGL-SERVICE-CENTER      
                   WHERE PREMISE_NO       = :WS-SEB-PREMISE-NO          
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                 
           ELSE                                                         
               DISPLAY '7000 - SQLCODE = ' SQLCODE ' CURSOR STATUS = '  
                 S-RETURN-CODE ' AGL PREMISE = ' WS-AGL-PREMISE-NO ' '  
               ' SEB PREMISE = ' S-PREMISE-NO                           
               MOVE 4 TO WS-RETURN-CODE                                 
           END-IF.                                                      
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-TEST-FOR-ALREADY-ADDED.                                     
           MOVE 'N' TO WS-NEW-PREMISE.                                  
           MOVE AGL-PREMISE-NO TO WS-AGL-PREMISE-NO                     
           EXEC SQL                                                     
               SELECT TOP(1) PREMISE_NO                                        
               INTO :WS-SEB-PREMISE-NO                                  
               FROM CSS_PREMISE WITH(READUNCOMMITTED)                           
               WHERE AGL_PREM_NO = :WS-AGL-PREMISE-NO                   
                                                    
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PREMISE_NO                                                
MFA-TR*        INTO :WS-SEB-PREMISE-NO                                          
MFA-TR*        FROM CSS_PREMISE                                                 
MFA-TR*        WHERE AGL_PREM_NO = :WS-AGL-PREMISE-NO                           
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE WS-SEB-PREMISE-NO TO WS-OUT-PREM.                       
           EVALUATE SQLCODE                                             
               WHEN 0                                                   
                   MOVE ' ' TO MSGLOG-REC                               
                   STRING  'AGL PREMISE '                               
                       AGL-PREMISE-NO         ' WAS FOUND FOR  PREMISE '
                       WS-OUT-PREM ' - BYPASSED'                        
                       DELIMITED BY SIZE INTO MSGLOG-REC                
                   WRITE MSGLOG-REC                                     
               WHEN 100                                                 
                   MOVE 'Y' TO WS-NEW-PREMISE                           
               WHEN OTHER                                               
                   DISPLAY '7100-SELECT SQLCODE = ' SQLCODE             
                       ' AGL PREMISE = ' AGL-PREMISE-NO                 
                   MOVE 12 TO WS-RETURN-CODE                            
                   PERFORM 9900-ABEND                                   
           END-EVALUATE.                                                
           IF NEW-PREMISE                                               
               WRITE AGLTEMP-RECORD FROM AGLFILE-RECORD                 
           END-IF.                                                      
           PERFORM 8000-READ-AGLFILE     THRU 8000-EXIT.                
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10480000
       8000-READ-AGLFILE.                                               
               READ AGLFILE INTO AGL-ACCOUNT-INFO                       
                   AT END                                               
                       MOVE 'Y' TO WS-EOF-AGLFILE.                      
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16170000
       8100-READ-AGLTEMP.                                               
               READ AGLTEMP  INTO AGL-ACCOUNT-INFO                      
                   AT END                                               
                       MOVE 'Y' TO WS-EOF-AGLTEMP.                      
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16170000
       9001-TERMINATE.                                                  
           CLOSE AGLFILE AGLTEMP MSGLOG.                                
           MOVE WS-RETURN-CODE TO RETURN-CODE.                          
           STOP RUN.                                                    
       9001-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16170000
       9900-ABEND.                                                      
           DISPLAY 'PERFORMING 9900-ABEND'.                             
SCA003     EXEC SQL
SCA003         ROLLBACK
SCA003     END-EXEC.                                                  

SCA003     CALL "MFASQLCA"
SCA003       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
SCA003       BY REFERENCE MFSQLMESSAGETEXT
SCA003     END-CALL

           MOVE 12  TO  WS-RETURN-CODE.                                 
           PERFORM 9001-TERMINATE.                                      
       9900-EXIT.                                                       
           EXIT.                                                        
