       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSCA299.                                         
       DATE-WRITTEN.  APR 2010.                                         
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRIC & GAS                 **          
      **                                                            **          
      ****************************************************************          
      **                  P R O G R A M S U M M A R Y               **          
      **                                                            **          
      **  PURPOSE :                                                 **          
      **                                                            **          
      **  THIS PROGRAM WILL PROCESS THE CONSUMPTION FOR NET METERING**          
      **  ACCOUNTS AND ALLOCATE VOLUME DAILY ENTRIES.               **          
      **                                                            **          
      **  THIS PROGRAM CAN BE EXECUTED IN THREE WAYS.               **          
      **   (A) PRIOR TO NIGHTLY BATCH BILLING (DB07 INPUT).         **          
      **   (B) AFTER BATCH METER POSTING (DATABASE EXTRACT INPUT).  **          
      **   (C) ON-DEMAND (JOB_PARM ACCOUNT/S INPUT).                **          
      **                                                            **          
      **  PROGRAM HAS IN-BUILT COMMIT AND RE-START LOGIC.           **          
      **                                                            **          
      ****************************************************************          
      **                                                            **          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      **   DATE     INITIALS   REASON                               **          
      ** --------   --------   ---------------------------------    **          
P00251** 04/28/10   SJ94244    NEW PROGRAM.                         **          
A02950** 12/07/10  JC91900     Handle multiple revenue months.      **          
ACT092** 08/16/12  MC95456     Get override revenue month through   **          
ACT092**   APPL3967-ACT92      Job parm.                            **          
ID1959** 09/18/15  GD43988     NEM2 CHANGES: INSERT/UPDATE EXCESS   **          
ID1959**                       USAGE CREDIT FACTOR/FACTOR HISTORY   **          
ID1959**                       BASED ON FOLLOWING CRITERIA:         **          
ID1959**                       (DB07 ON/OFF CYCLE CODE = FINAL) OR  **          
ID1959**                       (REVNEUE MONTH = RESET REVENUE MONTH)**          
ID1959** 11/17/15  EM19682     Add code to correct an issue with    **          
ID1959**                       excess credit in solar.              **          
A04860** 06/04/16  MS7M727     REPLACE CSS_WQ_ITEMS_MF TABLE WITH   **  01790100
A04860**           ACT108      CSS_WQ_ITEMS TABLE                   **  01790200
      ****************************************************************          
                                                                        
       ENVIRONMENT DIVISION.                                            
                                                                        
       CONFIGURATION SECTION.                                           
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
       COPY CSSDB07.                                                            
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDDB07.                                                            
       COPY FIODB07.                                                            
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA299'.
MSQ017     COPY MFASQLM.
                                                                        
       01 WS-WORKING-STORAGE.                                           
          05 WS-ACCOUNT-NO           PIC 9(13)  VALUE ZEROES.           
          05 WS-COMPANY-NO           PIC X(02)  VALUE SPACES.           
          05 WS-BILL-CYCLE           PIC X(02)  VALUE SPACES.           
ACT108    05 SCSCB077                PIC X(08)  VALUE 'SCSCB077'.       
          05 WS-PART-NO              PIC 9(02)  VALUE ZEROES.           
          05 WS-RUN-DATE             PIC X(10)  VALUE SPACES.           
          05 WS-REVENUE-MONTH        PIC 9(06)  VALUE ZEROES.           
          05 WS-REVENUE-MONTH-JP     PIC 9(06)  VALUE ZEROES.           
COB305    05 WS-REV-MTH-LST-NRML        PIC S9(06)V COMP-3 VALUE 0.             
          05 WS-COUNT-UNSUCCESSFUL-ROWS                                 
                                     PIC S9(04) VALUE ZEROES COMP.      
          05 WS-FLAG-TO-TURN-OFF-COMMITS                                
                                     PIC S9(04)  COMP VALUE +0.         
COB305    05 WS-PREV-REVENUE-MONTH        PIC S9(06)V COMP-3 VALUE 0.           
COB305    05 WS-OLDEST-REV-MONTH        PIC S9(06)V COMP-3 VALUE 0.             
          05 WS-REV-COUNT            PIC 9(02)  VALUE ZEROES.           
          05 WS-INDEX                PIC 9(02)  VALUE ZEROES.           
          05 WS-ERROR-PARAGRAPH-NAME PIC X(32).                         
                                                                        
       01 WS-ACCOUNT-TABLE.                                             
          05 WS-ACCOUNT-DATA         OCCURS 10 TIMES                    
                                     INDEXED BY WS-AT-INDX.             
             10 WS-INP-ACCOUNT-NO    PIC 9(13).                         
                                                                        
       01 RS-RPC-RETURN-CODE.                                           
          05 RS-RETURN-CODE          PIC S9(04) COMP VALUE 0.           
          05 RS-RETURN-CODE-DISP     PIC +Z(04).                        
          05 S-RETURN-CODE           PIC S9(04) COMP VALUE 0.           
                                                                        
       01 WS-SWITCHES.                                                  
          05 WS-NO-MORE-ROWS-01      PIC X(01)  VALUE 'N'.              
             88 NO-MORE-ROWS-01                 VALUE 'Y'.              
          05 WS-FDB07-STATUS         PIC X(02).                         
             88 FDB07-SUCCESSFUL                VALUE '00'.             
             88 FDB07-END-OF-FILE               VALUE '10'.             
          05 WS-BEGIN-REC-SW         PIC X(01).                         
             88 WS-BEGIN-RECS-PROCESSED         VALUE 'Y'.              
             88 WS-BEGIN-REC-NOT-PROCESSED      VALUE 'N'.              
             88 WS-START-INPUT-DATA             VALUE 'X'.              
          05 WS-RECORD-FOUND         PIC X(01)  VALUE 'N'.              
             88 DATA-RECORD-FOUND               VALUE 'Y'.              
             88 NO-DATA-RECORD-FOUND            VALUE 'N'.              
          05 WS-ON-OFF-CYCLE-IND     PIC X(01).                         
             88 WS-OFF-CYCLE-FINAL              VALUE 'B'.              
             88 WS-OFF-CYCLE-REBILL             VALUE 'O'.              
          05 WS-PROCESS-TYPE         PIC X(01).                         
             88 WS-DB07-PROCESS                 VALUE 'F'.              
             88 WS-CRSR-PROCESS                 VALUE 'C'.              
             88 WS-JPRM-PROCESS                 VALUE 'J'.              
                                                                        
       01 WS-RESTART-MISC.                                              
          05 WS-RESTART-DATA-LENGTH    PIC S9(04)  COMP VALUE +45.      
          05 WS-IS-THIS-A-RESTART      PIC X(01)   VALUE 'N'.           
             88  WS-THIS-IS-A-RESTART              VALUE 'Y'.           
             88  WS-THIS-IS-NOT-A-RESTART          VALUE 'N'.           
          05 WS-RESTART-COMMIT-COUNTER PIC 9(04)   VALUE ZERO.          
          05 WS-RESTART-REQ            PIC X(01).                       
          05 WS-DEFAULT-RESTART-REQ    PIC X(01)   VALUE 'N'.           
          05 WS-DEFAULT-CHKP-LUW-LIMIT PIC 9(04)   VALUE 100.           
          05 WS-CHKP-LUW-LIMIT         PIC 9(04)   VALUE ZERO.          
          05 WS-CHKP-LUW-COUNTER       PIC 9(04)   VALUE ZERO COMP-3.   
          05 WS-DEFAULT-CHKP-UPD-LIMIT PIC 9(04)   VALUE 100.           
          05 WS-CHKP-UPD-LIMIT         PIC 9(04)   VALUE ZERO.          
          05 WS-CHKP-UPD-COUNTER       PIC 9(04)   VALUE ZERO COMP-3.   
          05 WS-CHKP-ID.                                                
             10  WS-CHKP-PART-NO       PIC 9(01)   VALUE 1.             
             10  WS-CHKP-SEQ-NO        PIC 9(08)   VALUE ZERO.          
          05 WS-FCSDB07-REC-CNTR       PIC S9(07)  VALUE ZERO COMP-3.   
                                                                        
       01 WS-RESTART-DATA.                                              
          05 WS-RESTART-PROCESS-TYPE   PIC 9(01).                       
          05 WS-RESTART-JOB-COMPLETE   REDEFINES                        
             WS-RESTART-PROCESS-TYPE   PIC X(01).                       
          05 WS-RESTART-JOB-STATUS     PIC X(01).                       
             88  WS-RUN-COMPLETED-NO-PROBLEMS    VALUE 'A'.             
             88  WS-RERUN-COMPLETED              VALUE 'B'.             
             88  WS-RERUN-PENDING                VALUE 'C'.             
          05 WS-RESTART-COMMON-DATE    PIC X(10) VALUE SPACES.          
          05 WS-RESTART-CHKP-SEQ-NO    PIC 9(08) VALUE 0.               
          05 WS-RESTART-ACCOUNT-NO     PIC 9(13) VALUE 0.               
          05 WS-RESTART-DB07-CNT       PIC 9(09) VALUE 0.               
                                                                        
       01 WS-LITERALS.                                                  
          05 WS-Y                      PIC X(01) VALUE 'Y'.             
          05 WS-N                      PIC X(01) VALUE 'N'.             
          05 WS-I                      PIC X(01) VALUE 'I'.             
          05 WS-PGRMNAME               PIC X(08) VALUE 'PCSCA299'.      
          05 PROGRAM-NAME              PIC X(08) VALUE 'PCSCA299'.      
                                                                        
ACT108     COPY CWS00077.                                                       
      *****************************************************************         
      *  CWS00010  CONTAINS DB2 ABEND VARIABLES                       *         
      *****************************************************************         
       COPY CWS00010.                                                           
                                                                        
      *****************************************************************         
      *  CWS00038  JOB PARM ROUTINE                                   *         
      *****************************************************************         
       COPY CWS00038.                                                           
                                                                        
      *** BEWARE OF BELOW REDIFINITIONS, WHICH ARE LINK TO CWS00038             
                                                                        
       01 WS-ACCOUNT-NUM  REDEFINES WS-INPUT-DATA-BREAKDOWN.            
          10 WS-ACCOUNT-NUM-TXT        PIC X(06).                       
             88 ACCOUNT-NUM            VALUE 'ACCT#='.                  
          10 WS-ACCOUNT-NUM-ARR        PIC X(13).                       
          10 FILLER                    PIC X(61).                       
                                                                        
      *****************************************************************         
      * IO AREA FOR GETTING THE REVENUE MONTH FROM CSS_JOB_PARM       *         
      *****************************************************************         
       COPY FIOJC01.                                                            
                                                                        
      *****************************************************************         
      * WORKING STORAGE FOR CPD09900                                  *         
      *****************************************************************         
       COPY CWS09900.                                                           
                                                                        
      *****************************************************************         
      *  COPYBOOK WITH COMMON SQL VARIABLES                           *         
      *****************************************************************         
       COPY CWS00303.                                                           
                                                                        
      *****************************************************************         
      *  COPYBOOK FOR CPD00039                                        *         
      *****************************************************************         
       COPY CWS00039.                                                           
                                                                        
      *****************************************************************         
      *  COPYBOOK WITH JOBS FILE/TABLE DEFINITIONS                    *         
      *****************************************************************         
       COPY FIOCA00.                                                            
                                                                        
      *****************************************************************         
      *    DECLARATION FOR SQL COMMAND AREA                           *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    TABLE : CSS_ACCOUNT, AT                                    *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    TABLE : CSS_BILLING_HDR, BI                                *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBBLLHDR                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_BILLING_DET, BG                                *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBBLLDET                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **   TABLE : CSS_CNSMPTN_HIST, CX                              **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCNSMP                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    TABLE : CSS_DELINQUENCY, C8                                *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    TABLE : CSS_JOB_PARM, G6                                   *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **   TABLE : CSS_RATE_PLAN_DESC, RD                            **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRTDESC                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **   TABLE : CSS_RATE_CREATOR, J1                              **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRTCRTR                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **   TABLE : CSS_RATE_COMP_DEF, RT                             **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRTCDEF                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    TABLE : CSS_RESTART, RF                                    *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBRESTRT                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    TABLE : CSS_UTIL_ENVRNMT, UT                               *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **   TABLE : CSS_VOL_DAILY, ND                                 **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBVOLDLY                                                 
           END-EXEC.                                                            
      *                                                                         
ID1959*****************************************************************         
ID1959*    TABLE : CSS_SPCL_FCTR, SF                                 **         
ID1959*****************************************************************         
ID1959     EXEC SQL                                                             
ID1959         INCLUDE TBSPLFTR                                                 
ID1959     END-EXEC.                                                            
ID1959                                                                  
ID1959*                                                                         
ID1959*****************************************************************         
ID1959*    TABLE : CSS_SPCL_FCTR_APPL, SA                            **         
ID1959*****************************************************************         
ID1959     EXEC SQL                                                             
ID1959         INCLUDE TBSPLAPL                                                 
ID1959     END-EXEC.                                                            
ID1959                                                                  
ID1959*                                                                         
ID1959*****************************************************************         
ID1959*    TABLE : CSS_SPCL_FCT_CMPNT, SK                            **         
ID1959*****************************************************************         
ID1959     EXEC SQL                                                             
ID1959         INCLUDE TBFCTCMP                                                 
ID1959     END-EXEC.                                                            
ID1959                                                                  
ID1959*                                                                         
ID1959*****************************************************************         
ID1959*    TABLE : CSS_FIXED_FCTR, FF                                **         
ID1959*****************************************************************         
ID1959     EXEC SQL                                                             
ID1959         INCLUDE TBFXDFCT                                                 
ID1959     END-EXEC.                                                            
ID1959                                                                  
ID1959*                                                                         
ID1959*****************************************************************         
ID1959*    TABLE : CSS_FIXED_FCT_HIST, FH                            **         
ID1959*****************************************************************         
ID1959     EXEC SQL                                                             
ID1959         INCLUDE TBFXHST                                                  
ID1959     END-EXEC.                                                            
ID1959                                                                  
ID1959*                                                                         
ID1959*****************************************************************         
ID1959*    TABLE : CSS_BILL_WINDOW, BN                               **         
ID1959*****************************************************************         
ID1959     EXEC SQL                                                             
ID1959         INCLUDE TBBILWDW                                                 
ID1959     END-EXEC.                                                            
ID1959                                                                  
ID1959*                                                                         
      ******************************************************************        
      *    COPY BOOK FOR VOLUME ALLOCATION WORKING STORAGE             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CWSCA299                                                   
           END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
                                                                        
       01 WS-INPUT-PARM.                                                
          05 PARM-LENGTH         PIC S9(4) COMP.                        
          05 PARM-DATA           PIC X(256).                            
      *                                                                         
       PROCEDURE DIVISION USING WS-INPUT-PARM.                          
      ******************************************************************        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 0100-INITIALIZATION.                                          *         
      *****************************************************************         
       0100-INITIALIZATION.                                             
                                                                        
           MOVE WS-PGRMNAME                  TO G6-PROGRAM-NAME         
           MOVE 'DATE'                       TO G6-CMND-CODE            
           MOVE PARM-DATA(1:1)               TO WS-PROCESS-TYPE         
                                                                        
           PERFORM 6251-GET-FJC01-DATE           THRU 6251-EXIT         
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT         
              MOVE WS-FCA00-COMMON-DATE      TO WS-INPUT-DATE           
           END-IF                                                       
                                                                        
           IF WS-DB07-PROCESS                                           
              OPEN INPUT FCSDB07-FILE                                   
              IF FDB07-SUCCESSFUL                                       
      *          SKIP ALL THE HEADER RECORDS                                    
                 PERFORM 0500-PROCESS-BEGIN-REC  THRU  0500-EXIT        
                           UNTIL E-FDB07-KEY-BREC NOT EQUAL LOW-VALUES  
              ELSE                                                      
                 DISPLAY '********** PCSCA299 ABORT **************'     
                 DISPLAY '*       0100-INITIALIZATION            *'     
                 DISPLAY '*    ERROR OPENING FCSDB07 FILE        *'     
                 DISPLAY '* FILE STATUS    : ' WS-FDB07-STATUS          
                 DISPLAY '*      PROCESSING TERMINATED           *'     
                 DISPLAY '********** PCSCA299 ABORT **************'     
                 PERFORM 9900-ABEND              THRU  9900-EXIT        
              END-IF                                                    
                                                                        
              INITIALIZE WS-SYSIPT                                      
              PERFORM 6235-GET-FJC01-RESTART-REQ THRU 6235-EXIT         
                                                                        
              INITIALIZE WS-SYSIPT                                      
              PERFORM 6253-GET-FJC01-CHKP-LIMIT  THRU 6253-EXIT         
                                                                        
              IF WS-CHKP-LUW-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS    
                AND WS-CHKP-UPD-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS 
                    DISPLAY '****PCSCA299 INFORMATIONAL MESSAGE******'  
                    DISPLAY '*     CHKP-LUW AND CHKP-UPD PARMS      *'  
                    DISPLAY '* BOTH SET TO ' WS-FLAG-TO-TURN-OFF-COMMITS
                    DISPLAY '* , INTERPRETED TO INDICATE THAT       *'  
                    DISPLAY '* INTERIM COMMIT POINTS SHOULD NOT BE  *'  
                    DISPLAY '* TAKEN. COMPLETE RE-RUN REQUIRED UPON *'  
                    DISPLAY '*    UNSUCCESSFUL COMPLETION.          *'  
                    DISPLAY '* PROCESSING CONTINUING...             *'  
                    DISPLAY '****************************************'  
              END-IF                                                    
                                                                        
              PERFORM 0200-CHECK-RESTART         THRU 0200-EXIT         
                                                                        
              IF WS-THIS-IS-A-RESTART                                   
                 PERFORM 0300-PREPARE-RESTART    THRU 0300-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 6241-GET-FCA00-BILL-CYCLES    THRU 6241-EXIT.        
                                                                        
ACT092     INITIALIZE WS-SYSIPT                                         
ACT092     MOVE WS-PGRMNAME                  TO WS-PROGRAM              
ACT092     MOVE WS-DATE                      TO WS-COMMAND              
ACT092     MOVE ZEROS                        TO WS-SEQUENCE             
ACT092     MOVE WS-KEY-AREA                  TO E-FJC01-KEY             
ACT092     PERFORM 7600-START-FCSJC01        THRU 7600-EXIt             
ACT092     PERFORM 7610-READ-FCSJC01         THRU 7610-EXIT             
ACT092                         UNTIL (REVENUE-MONTH AND INPUT-ACTIVE)   
ACT092                                              OR END-OF-SYSIPT    
ACT092     IF END-OF-SYSIPT                                             
              INITIALIZE WS-SYSIPT                                      
              MOVE 'COMMON'                     TO WS-PROGRAM           
              MOVE WS-DATE                      TO WS-COMMAND           
              MOVE ZEROS                        TO WS-SEQUENCE          
              MOVE WS-KEY-AREA                  TO E-FJC01-KEY          
              PERFORM 7600-START-FCSJC01        THRU 7600-EXIt          
              PERFORM 7610-READ-FCSJC01         THRU 7610-EXIT          
                               UNTIL (REVENUE-MONTH AND INPUT-ACTIVE)   
                                                    OR END-OF-SYSIPT    
              EVALUATE TRUE                                             
                 WHEN END-OF-SYSIPT                                     
                    DISPLAY '********** PCSCA299 ABORT **************'  
                    DISPLAY '*       0100-INITIALIZATION            *'  
                    DISPLAY '*  NO ACTIVE REVENUE MONTH IN COMMON   *'  
                    DISPLAY '*     PROCESSING TERMINATED            *'  
                    DISPLAY '********** PCSCA299 ABORT **************'  
                    PERFORM 9900-ABEND                THRU  9900-EXIT   
                 WHEN WS-REVENUE-MONTH-PARM    NOT NUMERIC              
                    DISPLAY '********** PCSCA299 ABORT **************'  
                    DISPLAY '*       0100-INITIALIZATION            *'  
                    DISPLAY '*    REVENUE MONTH PARM NOT NUMERIC    *'  
                    DISPLAY '*                KEY = ' E-FJC01-KEY       
                    DISPLAY '*     PROCESSING TERMINATED            *'  
                    DISPLAY '********** PCSCA299 ABORT **************'  
                    PERFORM 9900-ABEND                THRU  9900-EXIT   
                 WHEN OTHER                                             
                    PERFORM 7611-CLOSE THRU 7611-EXIT                   
                    MOVE WS-REVENUE-MONTH-PARM    TO WS-REVENUE-MONTH-JP
              END-EVALUATE                                              
ACT092     ELSE                                                         
ACT092        MOVE WS-REVENUE-MONTH-PARM         TO  WS-REVENUE-MONTH-JP
ACT092     END-IF.                                                      
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0200-CHECK-RESTART.                                            *        
      ******************************************************************        
       0200-CHECK-RESTART.                                              
                                                                        
           MOVE PROGRAM-NAME                 TO RF-NAME-PROGRAM.        
           MOVE WS-PART-NO                   TO RF-PARTITION-NO         
                                                WS-CHKP-PART-NO.        
           MOVE 1                            TO RF-DUP-CNTRL-NO.        
                                                                        
           PERFORM 7900-SELECT-RESTART         THRU 7900-EXIT           
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE RF-RESTART-DATA-TEXT     TO WS-RESTART-DATA         
               IF WS-RESTART-PROCESS-TYPE NUMERIC                       
                  MOVE WS-Y                  TO WS-IS-THIS-A-RESTART    
               END-IF                                                   
           END-IF                                                       
                                                                        
           PERFORM 0605-VALIDATE-RESTART-REQ   THRU 0605-EXIT.          
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0300-PREPARE-RESTART.                                          *        
      ******************************************************************        
       0300-PREPARE-RESTART.                                            
                                                                        
           DISPLAY '*******************************************'        
           DISPLAY '*       THIS IS A RESTART OF PCSCA299     *'        
           DISPLAY '*******************************************'        
                                                                        
           MOVE WS-RESTART-CHKP-SEQ-NO TO WS-CHKP-SEQ-NO                
           MOVE WS-CHKP-PART-NO        TO WS-PART-NO                    
           IF WS-RESTART-COMMON-DATE NOT EQUAL WS-INPUT-DATE            
                          AND WS-RESTART-COMMON-DATE NOT EQUAL SPACES   
              DISPLAY '********** PCSCA299 ABORT **************'        
              DISPLAY '*       0300-PREPARE-RESTART           *'        
              DISPLAY '* COMMON DATE CHANGED PRIOR TO RESTART *'        
              DISPLAY '* COMMON  DATE   : ' WS-INPUT-DATE               
              DISPLAY '* RESTART DATE   : ' WS-RESTART-COMMON-DATE      
              DISPLAY '*      PROCESSING TERMINATED           *'        
              DISPLAY '********** PCSCA299 ABORT **************'        
              PERFORM 9900-ABEND                THRU  9900-EXIT         
           END-IF.                                                      
                                                                        
           PERFORM 7000-READ-FCSDB07            THRU  7000-EXIT         
                       WS-RESTART-DB07-CNT TIMES.                       
                                                                        
           IF E-FDB07-ACCT-NO EQUAL WS-RESTART-ACCOUNT-NO               
              PERFORM 7000-READ-FCSDB07         THRU 7000-EXIT          
           ELSE                                                         
              DISPLAY '********** PCSCA299 ABORT **************'        
              DISPLAY '*       0300-PREPARE-RESTART           *'        
              DISPLAY '* ACCOUNT FROM RESTART TABLE DOES NOT  *'        
              DISPLAY '* MATCH WITH DB07 FILE ACCOUNT         *'        
              DISPLAY '* RESTART ACCOUNT : ' WS-RESTART-ACCOUNT-NO      
              DISPLAY '* DB07 ACCOUNT    : ' E-FDB07-ACCT-NO            
              DISPLAY '*      PROCESSING TERMINATED           *'        
              DISPLAY '********** PCSCA299 ABORT **************'        
              PERFORM 9900-ABEND                THRU  9900-EXIT         
           END-IF.                                                      
                                                                        
           MOVE ZEROES                 TO WS-RESTART-COMMIT-COUNTER.    
                                                                        
       0300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0400-PREPARE-PRECOMMIT.                                        *        
      *     MOVE ALL THE REQUIRED RESTART RECORD VALUES PRIOR TO UPDATE*        
      ******************************************************************        
       0400-PREPARE-PRECOMMIT.                                          
                                                                        
            ADD  1                           TO WS-CHKP-SEQ-NO.         
            MOVE 1                           TO WS-RESTART-PROCESS-TYPE.
            MOVE WS-C                        TO WS-RESTART-JOB-STATUS.  
            MOVE WS-INPUT-DATE               TO WS-RESTART-COMMON-DATE. 
            MOVE WS-CHKP-SEQ-NO              TO WS-RESTART-CHKP-SEQ-NO. 
            MOVE WS-ACCOUNT-NO               TO WS-RESTART-ACCOUNT-NO.  
            MOVE WS-FCSDB07-REC-CNTR         TO WS-RESTART-DB07-CNT.    
                                                                        
       0400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0500-PROCESS-BEGIN-REC.                                        *        
      ******************************************************************        
       0500-PROCESS-BEGIN-REC.                                          
                                                                        
           PERFORM 7000-READ-FCSDB07           THRU 7000-EXIT           
                                                                        
           EVALUATE TRUE                                                
              WHEN FDB07-END-OF-FILE                                    
                 DISPLAY '********** PCSCA299 ABORT **************'     
                 DISPLAY '*       0500-PROCESS-BEGIN-REC         *'     
                 DISPLAY '*        FCSDB07 FILE IS EMPTY         *'     
                 DISPLAY '*      PROCESSING TERMINATED           *'     
                 DISPLAY '********** PCSCA299 ABORT **************'     
                 PERFORM 9900-ABEND            THRU  9900-EXIT          
              WHEN E-FDB07-KEY-BREC EQUAL LOW-VALUES                    
                 IF E-FDB07-CREATE-DATE-BREC NOT = WS-INPUT-DATE        
                    DISPLAY '********** PCSCA299 ABORT **************'  
                    DISPLAY '*       0500-PROCESS-BEGIN-REC         *'  
                    DISPLAY '* FCSDB07 CREATE DATE NOT = RUN DATE   *'  
                    DISPLAY '* DB07 DATE: ' E-FDB07-CREATE-DATE-BREC    
                    DISPLAY '* RUN  DATE: ' WS-INPUT-DATE               
                    DISPLAY '*      PROCESSING TERMINATED           *'  
                    DISPLAY '********** PCSCA299 ABORT **************'  
                    PERFORM 9900-ABEND         THRU 9900-EXIT           
                 END-IF                                                 
                 IF E-FDB07-DB-PART-BREC  GREATER THAN ZERO             
                     MOVE  E-FDB07-DB-PART-BREC TO WS-PART-NO           
                 ELSE                                                   
                    DISPLAY '*********** PCSCA299 ABORT *************'  
                    DISPLAY '*        0500-PROCESS-BEGIN-REC        *'  
                    DISPLAY '*   FCSDB07 PART NO NOT GREATER THAN 0 *'  
                    DISPLAY '*         PROCESSING TERMINATED        *'  
                    DISPLAY '*********** PCSCA299 ABORT *************'  
                    PERFORM 9900-ABEND          THRU 9900-EXIT          
                 END-IF                                                 
                                                                        
                 SET WS-BEGIN-RECS-PROCESSED   TO TRUE                  
                                                                        
              WHEN WS-BEGIN-RECS-PROCESSED                              
                 IF E-FDB07-KEY-BREC EQUAL HIGH-VALUES OR LOW-VALUES    
                    IF E-FDB07-KEY-BREC EQUAL HIGH-VALUES               
                      AND NO-DATA-RECORD-FOUND                          
                      AND E-FDB07-RECORD-COUNT-EREC EQUAL ZERO          
                       DISPLAY '******* PCSCA299 MESSAGE*********'      
                       DISPLAY '*   0500-PROCESS-BEGIN-REC      *'      
                       DISPLAY '*    FCSDB07 FILE IS EMPTY      *'      
                       DISPLAY '*    PROCESSING CONTINUING...   *'      
                       DISPLAY '******* PCSCA299 ABORT **********'      
                    END-IF                                              
                 ELSE                                                   
                    SET DATA-RECORD-FOUND      TO TRUE                  
                 END-IF                                                 
              WHEN OTHER                                                
                 DISPLAY '********** PCSCA299 ABORT **************'     
                 DISPLAY '*       0500-PROCESS-BEGIN-REC         *'     
                 DISPLAY '*   FIRST RECORD IS NOT A CNTL REC     *'     
                 DISPLAY '*      PROCESSING TERMINATED           *'     
                 DISPLAY '********** PCSCA299 ABORT **************'     
                 PERFORM 9900-ABEND            THRU  9900-EXIT          
           END-EVALUATE.                                                
                                                                        
       0500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 1000-PROCESS-INPUT.                                           *         
      *  ACCOUNTS PROCESSED BASED ON THE INPUT PROCESS TYPE           *         
      *****************************************************************         
       1000-PROCESS-INPUT.                                              
                                                                        
           DISPLAY 'WS-PROCESS-TYPE:' WS-PROCESS-TYPE.                  
                                                                        
           EVALUATE TRUE                                                
              WHEN WS-DB07-PROCESS                                      
                 PERFORM 1100-PROCESS-ACCT-FROM-DB07    THRU 1100-EXIT  
                                                                        
              WHEN WS-CRSR-PROCESS                                      
                 PERFORM 1200-PROCESS-ACCT-FROM-CURSOR  THRU 1200-EXIT  
                                                                        
              WHEN WS-JPRM-PROCESS                                      
                 PERFORM 1300-PROCESS-ACCT-FROM-JOBPARM THRU 1300-EXIT  
           END-EVALUATE.                                                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 1100-PROCESS-ACCT-FROM-DB07                                   *         
      *  1. PROCESS ALL DB07 ACCOUNTS                                 *         
      *****************************************************************         
       1100-PROCESS-ACCT-FROM-DB07.                                     
                                                                        
           PERFORM 1150-PROCESS-ACCOUNTS        THRU 1150-EXIT          
                                                UNTIL FDB07-END-OF-FILE.
                                                                        
           PERFORM 0400-PREPARE-PRECOMMIT       THRU 0400-EXIT          
                                                                        
           MOVE SPACES                       TO WS-RESTART-JOB-COMPLETE 
           IF WS-THIS-IS-A-RESTART                                      
              MOVE WS-B                      TO WS-RESTART-JOB-STATUS   
           ELSE                                                         
              MOVE WS-A                      TO WS-RESTART-JOB-STATUS   
           END-IF                                                       
                                                                        
           PERFORM 8888-COMMIT                  THRU 8888-EXIT          
                                                                        
           IF WS-RESTART-REQ EQUAL WS-Y                                 
              PERFORM 8893-RESET-RESTART-REQ-PARM                       
                                                THRU 8893-EXIT          
           END-IF.                                                      
                                                                        
           IF WS-THIS-IS-A-RESTART                                      
              DISPLAY 'PCSCA299 RERUN COMPLETED'                        
           ELSE                                                         
              DISPLAY 'PCSCA299 COMPLETED SUCCESSFULLY'                 
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 1150-PROCESS-ACCOUNTS                                         *         
      *  1. PROCESS ALL DB07 ACCOUNTS                                 *         
      *****************************************************************         
       1150-PROCESS-ACCOUNTS.                                           
                                                                        
           IF E-FDB07-OFF-CYCLE-BILL-CODE ='B' OR 'O' OR SPACES         
                                                                        
              MOVE E-FDB07-ACCT-NO    TO CWS299-IN-ACCT-NO              
                                         WS-ACCOUNT-NO                  
                                         AT-ACCOUNT-NO                  
              MOVE E-FDB07-OFF-CYCLE-BILL-CODE                          
                                       TO WS-ON-OFF-CYCLE-IND           
ID1959                                    CWS299-IN-OFF-CYC-BILL-CD     
                                                                        
              PERFORM 7010-SEL-ACCOUNT-DET      THRU 7010-EXIT          
              MOVE AT-REV-MTH-LST-NRML TO WS-REV-MTH-LST-NRML           
ID1959                                    CWS299-IN-REV-MTH-LST-NRML    
              MOVE AT-BILL-CYCLE       TO WS-BILL-CYCLE                 
                                                                        
              PERFORM 5700-FIND-REVENUE-MONTH   THRU 5700-EXIT          
                                                                        
              MOVE WS-REVENUE-MONTH   TO CWS299-IN-REVENUE-MONTH        
              MOVE WS-INPUT-DATE      TO CWS299-IN-COMMON-DT            
              MOVE WS-PGRMNAME        TO CWS299-IN-APPL-PGM-ID          
                                                                        
              PERFORM 6001-CPD299-VOL-ALLOC-MAIN                        
                                                THRU 6001-CPD299-EXIT   
              MOVE '1150-PROCESS-ACCOUNTS' TO WS-ERROR-PARAGRAPH-NAME   
              PERFORM 5100-VALIDATE-CPD299-ERROR                        
                                                THRU 5100-EXIT          
           END-IF                                                       
                                                                        
           IF WS-RESTART-COMMIT-COUNTER = WS-CHKP-LUW-LIMIT             
                       OR WS-RESTART-COMMIT-COUNTER = WS-CHKP-UPD-LIMIT 
              PERFORM 0400-PREPARE-PRECOMMIT   THRU 0400-EXIT           
              PERFORM 8888-COMMIT              THRU 8888-EXIT           
              MOVE ZEROES             TO WS-RESTART-COMMIT-COUNTER      
           END-IF.                                                      
                                                                        
           PERFORM 7000-READ-FCSDB07           THRU 7000-EXIT.          
                                                                        
       1150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 1200-PROCESS-ACCT-FROM-CURSOR                                 *         
      *  1. PROCESS ALL ACCOUNTS                                      *         
      *****************************************************************         
       1200-PROCESS-ACCT-FROM-CURSOR.                                   
                                                                        
           MOVE SPACES             TO WS-ON-OFF-CYCLE-IND               
                                                                        
           MOVE WS-PGRMNAME        TO CWS299-IN-APPL-PGM-ID             
                                                                        
           PERFORM 7100-OPEN-NET-MTR-ACCTS     THRU 7100-EXIT.          
           PERFORM 7110-FETCH-NET-MTR-ACCTS    THRU 7110-EXIT.          
           PERFORM 5000-PROCESS-NET-MTR-ACCTS  THRU 5000-EXIT           
             UNTIL NO-MORE-ROWS-01                                      
           PERFORM 7120-CLOSE-NET-MTR-ACCTS    THRU 7120-EXIT.          
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 1300-PROCESS-ACCT-FROM-JOBPARM.                               *         
      *  1. PROCESS ALL ACCOUNTS                                      *         
      *****************************************************************         
       1300-PROCESS-ACCT-FROM-JOBPARM.                                  
                                                                        
           PERFORM 1310-GET-ACCT-NO-FRM-JPARM   THRU 1310-EXIT.         
                                                                        
           MOVE SPACES             TO WS-ON-OFF-CYCLE-IND               
                                                                        
           MOVE WS-PGRMNAME        TO CWS299-IN-APPL-PGM-ID             
                                                                        
           SET WS-AT-INDX          TO 1                                 
           PERFORM UNTIL WS-AT-INDX > 10 OR                             
                  WS-INP-ACCOUNT-NO(WS-AT-INDX) = 0                     
             MOVE WS-INP-ACCOUNT-NO(WS-AT-INDX) TO CWS299-IN-ACCT-NO    
A02950                                             AT-ACCOUNT-NO        
A02950       PERFORM 7010-SEL-ACCOUNT-DET      THRU 7010-EXIT           
A02950       MOVE AT-REV-MTH-LST-NRML TO WS-REV-MTH-LST-NRML            
A02950       MOVE AT-BILL-CYCLE       TO WS-BILL-CYCLE                  
A02950                                                                  
ID1959       MOVE ZEROES        TO BN-REVENUE-MONTH                     
ID1959       MOVE WS-INPUT-DATE TO BN-DATE-EXTRACT                      
ID1959       PERFORM 5600-FIND-GET-MIN-REV-MO   THRU 5600-EXIT          
ID1959       IF BN-REVENUE-MONTH > 0                                    
ID1959          MOVE BN-REVENUE-MONTH TO WS-REVENUE-MONTH               
ID1959       ELSE                                                       
ID1959          PERFORM 5700-FIND-REVENUE-MONTH THRU 5700-EXIT          
ID1959       END-IF                                                     
A02950                                                                  
A02950       MOVE WS-REVENUE-MONTH   TO CWS299-IN-REVENUE-MONTH         
A02950       MOVE WS-INPUT-DATE      TO CWS299-IN-COMMON-DT             
             PERFORM 6001-CPD299-VOL-ALLOC-MAIN THRU 6001-CPD299-EXIT   
                                                                        
             MOVE '1300-PROCESS-ACCT-FROM-JOBPARM'                      
                                   TO WS-ERROR-PARAGRAPH-NAME           
             PERFORM 5100-VALIDATE-CPD299-ERROR THRU 5100-EXIT          
                                                                        
             SET WS-AT-INDX UP BY 1                                     
                                                                        
           END-PERFORM.                                                 
      *                                                                         
       1300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1310-GET-ACCT-NO-FRM-JPARM.                                    *        
      * GET THE ACCOUNT NUMBERS FROM JOB PARM TABLE                    *        
      ******************************************************************        
       1310-GET-ACCT-NO-FRM-JPARM.                                      
                                                                        
           MOVE  WS-PGRMNAME TO WS-PROGRAM.                             
           MOVE  WS-PARM     TO WS-COMMAND.                             
           MOVE  ZEROS       TO WS-SEQUENCE.                            
           MOVE  SPACES      TO WS-SYSIPT.                              
           MOVE  WS-KEY-AREA TO E-FJC01-KEY.                            
           SET   WS-AT-INDX  TO 1.                                      
           INITIALIZE WS-ACCOUNT-TABLE.                                 
                                                                        
           PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
                                                                        
           PERFORM UNTIL END-OF-SYSIPT                                  
              PERFORM 7610-READ-FCSJC01 THRU 7610-EXIT                  
              IF END-OF-SYSIPT AND NOT ACCOUNT-NUM                      
                 DISPLAY '********** PCSCA299 ABORT ***************'    
                 DISPLAY '** ' WS-PGRMNAME ' PROCESSING WARNING  **'    
                 DISPLAY '**  ACCOUNT-NUM    PARM NOT ACTIVE     **'    
                 DISPLAY '**  PROCESSING TERMINATED              **'    
                 DISPLAY '********** PCSCA299 ABORT ***************'    
                 PERFORM 9900-ABEND    THRU  9900-EXIT                  
                                                                        
              ELSE                                                      
                 IF ACCOUNT-NUM AND NOT END-OF-SYSIPT                   
                    AND WS-AT-INDX <= 10                                
                    MOVE WS-ACCOUNT-NUM-ARR                             
                                TO WS-INP-ACCOUNT-NO(WS-AT-INDX)        
                    SET WS-AT-INDX UP BY 1                              
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                         
       1310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 5000-PROCESS-NET-MTR-ACCTS                                    *         
      * PROCESS NET METERING ACCOUNTS                                 *         
      *****************************************************************         
       5000-PROCESS-NET-MTR-ACCTS.                                      
                                                                        
           MOVE AT-ACCOUNT-NO    TO  CWS299-IN-ACCT-NO.                 
                                                                        
A02950     PERFORM 7010-SEL-ACCOUNT-DET      THRU 7010-EXIT             
A02950     MOVE AT-REV-MTH-LST-NRML TO WS-REV-MTH-LST-NRML              
A02950     MOVE AT-BILL-CYCLE       TO WS-BILL-CYCLE                    
                                                                        
ID1959     MOVE ZEROES        TO BN-REVENUE-MONTH.                      
ID1959     MOVE WS-INPUT-DATE TO BN-DATE-EXTRACT.                       
ID1959     PERFORM 5600-FIND-GET-MIN-REV-MO   THRU 5600-EXIT            
ID1959     IF BN-REVENUE-MONTH > 0                                      
ID1959        MOVE BN-REVENUE-MONTH TO WS-REVENUE-MONTH                 
ID1959     ELSE                                                         
ID1959        PERFORM 5700-FIND-REVENUE-MONTH THRU 5700-EXIT            
ID1959     END-IF.                                                      
                                                                        
           MOVE WS-REVENUE-MONTH   TO CWS299-IN-REVENUE-MONTH           
           MOVE WS-INPUT-DATE      TO CWS299-IN-COMMON-DT               
                                                                        
           PERFORM 6001-CPD299-VOL-ALLOC-MAIN   THRU 6001-CPD299-EXIT.  
                                                                        
           MOVE '5000-PROCESS-NET-MTR-ACCTS'                            
                                 TO WS-ERROR-PARAGRAPH-NAME.            
           PERFORM 5100-VALIDATE-CPD299-ERROR   THRU 5100-EXIT.         
                                                                        
           PERFORM 7110-FETCH-NET-MTR-ACCTS     THRU 7110-EXIT.         
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 5100-VALIDATE-CPD299-ERROR.                                    *        
      ******************************************************************        
       5100-VALIDATE-CPD299-ERROR.                                      
                                                                        
           EVALUATE TRUE                                                
              WHEN CWS299-DB2-ERROR                                     
                 DISPLAY '********** PCSCA299 ABORT **************'     
                 DISPLAY '*     ' WS-ERROR-PARAGRAPH-NAME   '    *'     
                 DISPLAY '* CWS299-ERROR-MESSAGE:' CWS299-ERROR-MESSAGE 
                 DISPLAY '* CWS299-ERROR-SQLCODE:' CWS299-ERROR-SQLCODE 
                 DISPLAY '* CWS299-ERROR-FUNCTION:'                     
                                            CWS299-ERROR-FUNCTION       
                 DISPLAY '* CWS299-ERROR-PARAGRAPH-NO:'                 
                                            CWS299-ERROR-PARAGRAPH-NO   
                 DISPLAY '* CWS299-ERROR-PARAGRAPH-NAME:'               
                                            CWS299-ERROR-PARAGRAPH-NAME 
                 DISPLAY '* CWS299-ERROR-TABLE1:' CWS299-ERROR-TABLE1   
                 DISPLAY '* CWS299-ERROR-TABLE2:' CWS299-ERROR-TABLE2   
                 DISPLAY '* CWS299-ERROR-TAB-COLUMN-1:'                 
                                            CWS299-ERROR-TAB-COLUMN-1   
                 DISPLAY '* CWS299-ERROR-TAB-COLUMN-2:'                 
                                            CWS299-ERROR-TAB-COLUMN-2   
                 DISPLAY '* CWS299-ERROR-TAB-COLUMN-3:'                 
                                            CWS299-ERROR-TAB-COLUMN-3   
                 DISPLAY '* CWS299-ERROR-TAB-COLUMN-4:'                 
                                            CWS299-ERROR-TAB-COLUMN-4   
                 DISPLAY '* CWS299-ERROR-HOSTVAR-1:'                    
                                            CWS299-ERROR-HOSTVAR-1      
                 DISPLAY '* CWS299-ERROR-HOSTVAR-2:'                    
                                            CWS299-ERROR-HOSTVAR-2      
                 DISPLAY '* CWS299-ERROR-HOSTVAR-3:'                    
                                            CWS299-ERROR-HOSTVAR-3      
                 DISPLAY '* CWS299-ERROR-HOSTVAR-4:'                    
                                            CWS299-ERROR-HOSTVAR-4      
                 DISPLAY '*     PROCESSING TERMINATED            *'     
                 DISPLAY '********** PCSCA299 ABORT **************'     
                 PERFORM 9900-ABEND         THRU 9900-EXIT              
              WHEN CWS299-NON-DB2-ERROR                                 
                 DISPLAY 'ACCOUNT #: ' CWS299-IN-ACCT-NO                
                 DISPLAY 'Error allocating volume:' CWS299-ERROR-MESSAGE
              WHEN OTHER                                                
                 CONTINUE                                               
           END-EVALUATE.                                                
                                                                        
           IF VOL-ALLOCATED                                             
              DISPLAY 'Volume allocated: ' CWS299-IN-ACCT-NO            
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 5600-FIND-GET-MIN-REV-MO                                       *        
      ******************************************************************        
ID1959 5600-FIND-GET-MIN-REV-MO.                                        
ID1959                                                                  
ID1959      EXEC SQL                                                    
ID1959         SELECT COALESCE(MIN(REVENUE_MONTH),0)                      
ID1959           INTO :BN-REVENUE-MONTH                                 
ID1959           FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                     
ID1959          WHERE BILL_CYCLE   = :WS-BILL-CYCLE                     
ID1959            AND DATE_EXTRACT >= IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )                  
ID1959                                                           
ID1959                                                      
ID1959      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT IFNULL(MIN(REVENUE_MONTH),0)                              
MFA-TR*          INTO :BN-REVENUE-MONTH                                         
MFA-TR*          FROM CSS_BILL_WINDOW                                           
MFA-TR*         WHERE BILL_CYCLE   = :WS-BILL-CYCLE                             
MFA-TR*           AND DATE_EXTRACT >= :BN-DATE-EXTRACT                          
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 5600                                                     
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ID1959                                                                  
ID1959     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
ID1959                                                                  
ID1959     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
ID1959                                    OR NOT-FOUND                  
ID1959        NEXT SENTENCE                                             
ID1959     ELSE                                                         
ID1959        DISPLAY '********** PCSCA299 ABORT **************'        
ID1959        DISPLAY '*       5600-FIND-GET-MIN-REV-MO       *'        
ID1959        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
ID1959        DISPLAY '* INPUT DATE        : ' BN-DATE-EXTRACT          
ID1959        DISPLAY '* BILL CYCLE        : ' WS-BILL-CYCLE            
ID1959        DISPLAY '*       PROCESSING TERMINATED          *'        
ID1959        DISPLAY '********** PCSCA299 ABORT **************'        
ID1959        PERFORM 9900-ABEND               THRU 9900-EXIT           
ID1959     END-IF.                                                      
ID1959                                                                  
ID1959 5600-EXIT.                                                       
ID1959     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 5700-FIND-REVENUE-MONTH.                                       *        
      ******************************************************************        
       5700-FIND-REVENUE-MONTH.                                         
                                                                        
           MOVE ZEROES                       TO WS-REV-COUNT            
                                                WS-OLDEST-REV-MONTH     
                                                WS-PREV-REVENUE-MONTH.  
                                                                        
           MOVE 1                            TO WS-INDEX.               
           PERFORM 5750-GET-OLDEST-REV-MONTH    THRU 5750-EXIT          
                   UNTIL WS-FCA00-BLCYC-NUMBER(WS-INDEX) = '00'         
                                                OR WS-INDEX >= 8.       
           PERFORM 5800-LOAD-REVENUE-MONTH      THRU 5800-EXIT.         
                                                                        
       5700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 5750-GET-OLDEST-REV-MONTH.                                     *        
      ******************************************************************        
       5750-GET-OLDEST-REV-MONTH.                                       
                                                                        
           IF WS-FCA00-REV-MONTH (WS-INDEX) =                           
                 WS-PREV-REVENUE-MONTH                                  
               CONTINUE                                                 
           ELSE                                                         
               ADD 1 TO WS-REV-COUNT                                    
             IF WS-PREV-REVENUE-MONTH = ZEROES                          
                 MOVE WS-FCA00-REV-MONTH(WS-INDEX)   TO                 
                       WS-OLDEST-REV-MONTH                              
             END-IF                                                     
             IF WS-FCA00-REV-MONTH (WS-INDEX) <=  WS-PREV-REVENUE-MONTH 
                AND WS-FCA00-REV-MONTH (WS-INDEX) NOT = ZEROES          
                   MOVE WS-FCA00-REV-MONTH(WS-INDEX) TO                 
                        WS-OLDEST-REV-MONTH                             
             END-IF                                                     
           END-IF                                                       
                                                                        
           MOVE WS-FCA00-REV-MONTH(WS-INDEX)                            
                                            TO WS-PREV-REVENUE-MONTH.   
           ADD 1                            TO WS-INDEX.                
                                                                        
       5750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 5800-LOAD-REVENUE-MONTH.                                       *        
      ******************************************************************        
       5800-LOAD-REVENUE-MONTH.                                         
                                                                        
           IF WS-REV-COUNT = 1                                          
              PERFORM 5850-LOAD-ONE-REVENUE-MONTH THRU 5850-EXIT        
           ELSE                                                         
              IF WS-OFF-CYCLE-FINAL OR WS-OFF-CYCLE-REBILL              
                 SET WS-BILL-CYC-INDX TO 1                              
                 SEARCH WS-FCA00-BILLING-CYCLES                         
                    AT END                                              
                      MOVE WS-OLDEST-REV-MONTH TO WS-REVENUE-MONTH      
                 WHEN (WS-FCA00-REV-MONTH (WS-BILL-CYC-INDX) EQUAL      
                       WS-REV-MTH-LST-NRML)  AND                        
                       (WS-REV-MTH-LST-NRML NOT = ZERO)                 
                       MOVE WS-FCA00-REV-MONTH (WS-BILL-CYC-INDX)       
                                             TO WS-REVENUE-MONTH        
                                                                        
                 END-SEARCH                                             
              ELSE                                                      
                 SET WS-BILL-CYC-INDX        TO 1                       
                 SEARCH WS-FCA00-BILLING-CYCLES                         
                    AT END                                              
                    MOVE WS-OLDEST-REV-MONTH TO WS-REVENUE-MONTH        
                 WHEN WS-FCA00-BLCYC-NUMBER (WS-BILL-CYC-INDX) EQUAL    
                       WS-BILL-CYCLE                                    
                 MOVE WS-FCA00-REV-MONTH (WS-BILL-CYC-INDX)             
                                             TO WS-REVENUE-MONTH        
                 END-SEARCH                                             
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 5850-LOAD-ONE-REVENUE-MONTH.                                   *        
      ******************************************************************        
       5850-LOAD-ONE-REVENUE-MONTH.                                     
                                                                        
           SET WS-BILL-CYC-INDX              TO 1                       
           SEARCH WS-FCA00-BILLING-CYCLES                               
              AT END                                                    
                MOVE WS-REVENUE-MONTH-JP     TO WS-REVENUE-MONTH        
              WHEN WS-FCA00-BLCYC-NUMBER (WS-BILL-CYC-INDX) EQUAL       
                   WS-BILL-CYCLE                                        
                 MOVE WS-FCA00-REV-MONTH (WS-BILL-CYC-INDX)             
                                             TO WS-REVENUE-MONTH        
           END-SEARCH.                                                  
                                                                        
       5850-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7000-READ-FCSDB07.                                             *        
      ******************************************************************        
       7000-READ-FCSDB07.                                               
                                                                        
           READ FCSDB07-FILE                                            
           IF FDB07-END-OF-FILE                                         
              GO TO 7000-EXIT                                           
           END-IF.                                                      
                                                                        
           IF FDB07-SUCCESSFUL                                          
               IF E-FDB07-KEY-BREC NOT EQUAL HIGH-VALUES                
                           OR E-FDB07-KEY-BREC NOT EQUAL LOW-VALUES     
                  IF DATA-RECORD-FOUND                                  
                     ADD +01                TO WS-FCSDB07-REC-CNTR      
                                               WS-RESTART-COMMIT-COUNTER
                  END-IF                                                
               END-IF                                                   
           ELSE                                                         
             DISPLAY '********** PCSCA299 ABORT **************'         
             DISPLAY '*     READ ERROR : DB07 FILE           *'         
             DISPLAY '* CURRENT PARA   : 7000                *'         
             DISPLAY '* FILE-STATUS    : ' WS-FDB07-STATUS              
             DISPLAY '*     PROCESSING TERMINATED            *'         
             DISPLAY '********** PCSCA299 ABORT **************'         
             PERFORM 9900-ABEND               THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7010-SEL-ACCOUNT-DET.                                         *         
      *****************************************************************         
       7010-SEL-ACCOUNT-DET.                                            
                                                                        
           EXEC SQL                                                     
                                                                        
               SELECT AT.REV_MTH_LST_NRML                               
                     ,AT.BILL_CYCLE                                     
                 INTO :AT-REV-MTH-LST-NRML                              
                     ,:AT-BILL-CYCLE                                    
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        SELECT AT.REV_MTH_LST_NRML                                       
MFA-TR*              ,AT.BILL_CYCLE                                             
MFA-TR*          INTO :AT-REV-MTH-LST-NRML                                      
MFA-TR*              ,:AT-BILL-CYCLE                                            
MFA-TR*          FROM CSS_ACCOUNT AT                                            
MFA-TR*         WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7010                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA299 ABORT **************'        
              DISPLAY '*     7010-SELECT-ACCOUNT-DET          *'        
              DISPLAY '* ACCOUNT NO     : ' AT-ACCOUNT-NO               
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA299 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7100-OPEN-NET-MTR-ACCTS                                       *         
      *****************************************************************         
       7100-OPEN-NET-MTR-ACCTS.                                         
                                                                        
           EXEC SQL                                                     
              OPEN NET_MTR_ACCTS                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA299 ABORT **************'        
              DISPLAY '*       7100-OPEN-NET-MTR-ACCTS        *'        
              DISPLAY '* CODE_ACCT_BILLED  : R '                        
              DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '*       PROCESSING TERMINATED          *'        
              DISPLAY '********** PCSCA299 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7110-FETCH-NET-MTR-ACCTS                                      *         
      *****************************************************************         
       7110-FETCH-NET-MTR-ACCTS.                                        
                                                                        
           EXEC SQL                                                     
              FETCH NET_MTR_ACCTS                                       
               INTO :AT-ACCOUNT-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
                 CONTINUE                                               
             WHEN NOT-FOUND                                             
                 MOVE 'Y'                    TO WS-NO-MORE-ROWS-01      
             WHEN OTHER                                                 
                 DISPLAY '********** PCSCA299 ABORT **************'     
                 DISPLAY '*       7110-FETCH-NET-MTR-ACCTS       *'     
                 DISPLAY '* CODE_ACCT_BILLED  : R '                     
                 DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE 
                 DISPLAY '*       PROCESSING TERMINATED          *'     
                 DISPLAY '********** PCSCA299 ABORT **************'     
                 PERFORM 9900-ABEND            THRU 9900-EXIT           
           END-EVALUATE.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 7120-CLOSE-NET-MTR-ACCTS.                                     *         
      *****************************************************************         
       7120-CLOSE-NET-MTR-ACCTS.                                        
                                                                        
           EXEC SQL                                                     
              CLOSE NET_MTR_ACCTS                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA299 ABORT **************'        
              DISPLAY '*       7120-CLOSE-NET-MTR-ACCTS       *'        
              DISPLAY '* CODE_ACCT_BILLED  : R '                        
              DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '*       PROCESSING TERMINATED          *'        
              DISPLAY '********** PCSCA299 ABORT **************'        
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7900-SELECT-RESTART.                                           *        
      ******************************************************************        
       7900-SELECT-RESTART.                                             
                                                                        
           EXEC SQL                                                     
              SELECT RF.RESTART_DATA                                    
                INTO :RF-RESTART-DATA                                   
                FROM CSS_RESTART RF WITH(READUNCOMMITTED)                       
               WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                 
                 AND RF.PARTITION_NO = :RF-PARTITION-NO                 
                 AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                 
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RF.RESTART_DATA                                            
MFA-TR*         INTO :RF-RESTART-DATA                                           
MFA-TR*         FROM CSS_RESTART RF                                             
MFA-TR*        WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                         
MFA-TR*          AND RF.PARTITION_NO = :RF-PARTITION-NO                         
MFA-TR*          AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                         
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7900                                                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA299 ABORT **************'        
              DISPLAY '**   ERROR ON 7900-SELECT-RESTART     **'        
              DISPLAY '**   PROGRAM NAME = ' RF-NAME-PROGRAM            
              DISPLAY '**   PARTITION NO = ' RF-PARTITION-NO            
              DISPLAY '**   DUP CNTRL NO = ' RF-DUP-CNTRL-NO            
              DISPLAY '**   RETURN CODE  = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**       PROCESSING TERMINATED        **'        
              DISPLAY '********** PCSCA299 ABORT **************'        
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8800-WRITE-RESTART                                             *        
      ******************************************************************        
       8800-WRITE-RESTART.                                              
                                                                        
           MOVE WS-PGRMNAME                      TO RF-NAME-PROGRAM     
           MOVE WS-PART-NO                       TO RF-PARTITION-NO     
           MOVE 1                                TO RF-DUP-CNTRL-NO     
           MOVE WS-RESTART-DATA                  TO                     
                                                 RF-RESTART-DATA-TEXT   
           MOVE WS-RESTART-DATA-LENGTH           TO RF-RESTART-DATA-LEN 
                                                                        
           PERFORM 8850-UPDATE-RESTART           THRU 8850-EXIT         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 8860-INSERT-RESTART        THRU 8860-EXIT         
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8850-UPDATE-RESTART.                                           *        
      ******************************************************************        
       8850-UPDATE-RESTART.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_RESTART                                        
                 SET RESTART_DATA = :RF-RESTART-DATA                    
               WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                    
                 AND PARTITION_NO = :RF-PARTITION-NO                    
                 AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                    
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO  WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA299 ABORT **************'        
              DISPLAY '*        8850-UPDATE-RESTART           *'        
              DISPLAY '* NAME_PROGRAM   : ' RF-NAME-PROGRAM             
              DISPLAY '* DUP_CNTRL_NO   : ' RF-DUP-CNTRL-NO             
              DISPLAY '* PARTITION_NO   : ' RF-PARTITION-NO             
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA299 ABORT **************'        
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF.                                                      
                                                                        
       8850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8860-INSERT-RESTART.                                           *        
      ******************************************************************        
       8860-INSERT-RESTART.                                             
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_RESTART                                   
                    ( NAME_PROGRAM                                      
                     ,PARTITION_NO                                      
                     ,DUP_CNTRL_NO                                      
                     ,RESTART_DATA)                                     
              VALUES(:RF-NAME-PROGRAM                                   
                    ,:RF-PARTITION-NO                                   
                    ,:RF-DUP-CNTRL-NO                                   
                    ,:RF-RESTART-DATA)                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO  WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA299 ABORT **************'        
              DISPLAY '*       8860-INSERT-RESTART            *'        
              DISPLAY '* NAME_PROGRAM   : ' RF-NAME-PROGRAM             
              DISPLAY '* DUP_CNTRL_NO   : ' RF-DUP-CNTRL-NO             
              DISPLAY '* PARTITION_NO   : ' RF-PARTITION-NO             
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA299 ABORT **************'        
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF.                                                      
                                                                        
       8860-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8888-COMMIT.                                                   *        
      ******************************************************************        
       8888-COMMIT.                                                     
                                                                        
           IF WS-CHKP-LUW-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS       
              AND WS-CHKP-UPD-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS   
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 8800-WRITE-RESTART         THRU 8800-EXIT         
                                                                        
              EXEC SQL                                                  
                  COMMIT                                                
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              DISPLAY 'COMMIT POINT # ' WS-CHKP-SEQ-NO ' TAKEN.'        
           END-IF.                                                      
                                                                        
       8888-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8893-RESET-RESTART-REQ-PARM                                    *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00029                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * APPL 765 - ADD DUMMY STATEMENT TO FIX ISSUE TRANS HIST CPYC   *         
      * 9000-TERMINATE.                                               *         
      *****************************************************************         
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           GO TO 9000-EXIT.                                             
                                                                        
      *****************************************************************         
      *                                                               *         
      * 9000-TERMINATE.                                               *         
      *****************************************************************         
       9000-TERMINATE.                                                  
                                                                        
           IF WS-DB07-PROCESS                                           
              CLOSE FCSDB07-FILE                                        
           END-IF.                                                      
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      *  6001-CPD299-VOL-ALLOC-MAIN.                                  *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE CPDCA299                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6240-GET-FCA00-COMMON-DATE.                                   *         
      *****************************************************************         
           COPY CPD00040.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6241-GET-FCA00-BILL-CYCLES.                                   *         
      *****************************************************************         
           COPY CPD00041.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      *  6251-GET-FJC01-DATE.                                         *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE CPD00037                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6253-GET-FJC01-CHKP-LIMIT.                                     *        
      ******************************************************************        
            EXEC SQL                                                            
                INCLUDE CPD00034                                                
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      *                                                               *         
      *  7600-START-FCSJC01                                           *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE CPD00038                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *                                                               *         
      *  7620-START-FCSCA00                                           *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *                                                               *         
      * 0605-VALIDATE-RESTART-REQ.                                    *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CPD00030                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6235-GET-FJC01-RESTART-REQ.                                   *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CPD00035                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *                                                               *         
      * 9900-SQL-ERROR-ROUTINE.                                       *         
      *****************************************************************         
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                         
           MOVE SQLCODE                TO RS-RETURN-CODE-DISP.          
           DISPLAY ' '                                                  
           DISPLAY '**********************************************'     
           DISPLAY '***** 9900-SQL-ERROR-ROUTINE            ******'     
           DISPLAY '**********************************************'     
           DISPLAY ' '                                                  
           DISPLAY 'ACCOUNT_NO = ' WS-ACCOUNT-NO                        
           DISPLAY 'SQLCODE    = ' RS-RETURN-CODE-DISP                  
           DISPLAY ABEND-RECORD-1-DATA                                  
           DISPLAY ABEND-RECORD-2-DATA                                  
           DISPLAY ABEND-RECORD-3-DATA                                  
           DISPLAY '**********************************************'.    
                                                                        
      *                                                                         
      *****************************************************************         
      * 9700-PROCESS-ABEND.                                           *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CPD0023B                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *                                                               *         
      * 9900-ABEND                                                    *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
