       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA296.                                        
       AUTHOR.         VIJAY ANAND.                                     
       DATE-WRITTEN.   SEP 2009.                                        
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRIC & GAS                 **          
      **                                                            **          
      ****************************************************************          
      **                  P R O G R A M S U M M A R Y               **          
      **                                                            **          
      **                                                            **          
      **  PROCESSING INCLUDES                                       **          
      **                                                            **          
      **   (A) SET PENDING CONTRACT TO ACTIVE, ONCE THE FIXED RATE  **          
      **       CONTRACT IS OVER.                                    **          
      **                                                            **          
      ****************************************************************          
      **                                                            **          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      **   DATE     INITIALS   REASON                               **          
      ** --------   --------   ---------------------------------    **          
P00211** 09/22/09   VY95550    NEW PROGRAM.                         **          
P00172** 03/19/10   VY95550    INSERT/UPDATE AN ATTRIBUTE WHEN THE  **          
P00172**                       FIXED RATE CUSTOMER RECEIVES A DREG  **          
P00172**                       SWITCH LETTER.                       **          
P00505** 07/05/11   SB93596    FOR HOME ENERGY REPORTS DSM PROGRAM, **          
P00505**                       WHEN AN ACCOUNT FINAL BILLS , UPDATE **          
P00505**                       THE STATUS AS OPT OUT IN CSS_DSM_PGM **          
P00505**                       _ACCT TABLE.                         **          
A04583** 04/30/13   HA7A338    REMOVED ENTIRE LOGIC THAT INSERT/UPD **          
A04583**                       ATTRIBUTE WHEN THE FIXED RATE CUST   **          
A04583**                       RECEIVES DREG SWITCH LETTER AND HAS  **          
A04583**                       BEEN HANDLED IN PCSCA325 PROGRAM     **          
A04860** 09/22/14 AS7C117      REPLACE CSS_WQ_ITEMS_MF WITH         **          
A04860**          ACT046       CSS_WQ_ITEMS.                        **          
      ****************************************************************          
                                                                        
       ENVIRONMENT DIVISION.                                            
                                                                        
       CONFIGURATION SECTION.                                           
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
       COPY CSSBE22.                                                            
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDBE22.                                                            
       COPY FIOBE22.                                                            
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA296'.
MSQ017     COPY MFASQLM.
       01  WS-START                   PIC X(40)                         
           VALUE 'WORKING STORAGE FOR PCSCA296 STARTS HERE'.            
      *                                                                         
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME             PIC X(08)   VALUE 'PCSCA296'.   
           05  WS-PGRMNAME              PIC X(10)   VALUE 'PCSCA296'.   
A04860     05  SCSCB077                 PIC X(08)   VALUE 'SCSCB077'.   
           05  WS-SUBROUTINE-IDS.                                       
               10 SCSCA326              PIC X(08)   VALUE 'SCSCA326'.   
           05  WS-ACTIVE                PIC X(01)   VALUE 'A'.          
           05  WS-PENDING               PIC X(01)   VALUE 'P'.          
           05  WS-PENDING-BATCH-CD      PIC X(01)   VALUE 'A'.          
           05  WS-OPEN-FOR-RENEWAL      PIC X(01)   VALUE 'O'.          
           05  WS-EXCLUDE-FROM-POST-BILLING                             
                                        PIC X(01)   VALUE 'P'.          
           05  WS-Y                     PIC X(01)   VALUE 'Y'.          
           05  WS-N                     PIC X(01)   VALUE 'N'.          
           05  WS-I                     PIC X(01)   VALUE 'I'.          
      *                                                                         
       01 WS-MISC.                                                      
           05  WS-DISPLAY-RC            PIC -ZZZZZZZZ9.9.               
           05  RS-RETURN-CODE           PIC S9(04)    COMP.             
           05  RS-RETURN-CODE-DISP      PIC S9(04).                     
           05  WS-REVENUE-MONTH-JP      PIC 9(06)  VALUE ZEROES.        
           05  WS-FLAG-TO-TURN-OFF-COMMITS                              
                                        PIC S9(04) COMP VALUE +9999.    
P00505     05  WS-EXISTS                PIC X(1) VALUE 'N'.             
P00505     05  WS-DSM-PGM-CD            PIC X(6) VALUE SPACES.          
           05  WS-PART-NO               PIC 9(02).                      
           05  WS-CURR-DUR-REM-NO       PIC S9(4) USAGE COMP VALUE 0.   
           05  WS-RT-CALC-TYP-CD        PIC X(2) VALUE SPACES.          
           05  WS-COUNT-UNSUCCESSFUL-ROWS                               
                                        PIC S9(04) VALUE ZEROES COMP.   
           05  WS-WQ-COMMENTS           PIC X(35) VALUE                 
               'EXCLUEDED FROM POST-BILLING PROCESS'.                   
A04860     05  WS-INPUT-TS.                                             
A04860         10 WS-INPUT-DATE-PT      PIC X(10).                      
A04860         10 WS-INPUT-TIME-PT      PIC X(16) VALUE                 
A04860                                      '-00.00.00.000000'.         
      *                                                                         
       01 WS-COUNTERS.                                                  
           05  WS-BG-ROW                PIC S9(3) COMP.                 
           05  WS-BT-CNT                PIC S9(3) COMP.                 
COB305     05 WS-CNTR-BG        PIC S9(03) COMP-3 VALUE 0.              
COB305     05 WS-CNTR-DF        PIC S9(03) COMP-3 VALUE 0.              
COB305     05 WS-CNTR-BT        PIC S9(03) COMP-3 VALUE 0.              
COB305     05 WS-CNTR-FH        PIC S9(03) COMP-3 VALUE 0.              
      *                                                                         
       01 WS-SUBSCRIPTS.                                                
          05 WS-BILLING-SUB             PIC S9(04) COMP.                
          05 WS-CALC-SUB                PIC S9(04) COMP.                
      *                                                                         
       01 WS-HOLD-VARIABLES.                                            
          05 WS-PREVIOUS-ACCT-NO        PIC 9(13) VALUE 0.              
      *                                                                         
       01  WS-RESTART-MISC.                                             
           05  WS-RESTART-DATA-LENGTH    PIC S9(04)  COMP VALUE +45.    
           05  WS-IS-THIS-A-RESTART      PIC X(01)   VALUE 'N'.         
               88  WS-THIS-IS-A-RESTART              VALUE 'Y'.         
               88  WS-THIS-IS-NOT-A-RESTART          VALUE 'N'.         
           05  WS-RESTART-COMMIT-COUNTER PIC 9(04)   VALUE ZERO.        
           05  WS-RESTART-REQ            PIC X(01).                     
           05  WS-DEFAULT-RESTART-REQ    PIC X(01)   VALUE 'N'.         
           05  WS-DEFAULT-CHKP-LUW-LIMIT PIC 9(04)   VALUE 100.         
           05  WS-CHKP-LUW-LIMIT         PIC 9(04)   VALUE ZERO.        
           05  WS-CHKP-LUW-COUNTER       PIC 9(04)   VALUE ZERO COMP-3. 
           05  WS-DEFAULT-CHKP-UPD-LIMIT PIC 9(04)   VALUE 100.         
           05  WS-CHKP-UPD-LIMIT         PIC 9(04)   VALUE ZERO.        
           05  WS-CHKP-UPD-COUNTER       PIC 9(04)   VALUE ZERO COMP-3. 
           05  WS-CHKP-ID.                                              
               10  WS-CHKP-PART-NO       PIC 9(01)   VALUE 1.           
               10  WS-CHKP-SEQ-NO        PIC 9(08)   VALUE ZERO.        
           05  WS-FCSBE22-REC-CNTR       PIC S9(07)  VALUE ZERO COMP-3. 
      *                                                                         
       01  WS-RESTART-DATA.                                             
           05  WS-RESTART-PROCESS-TYPE   PIC 9(01).                     
           05  WS-RESTART-JOB-COMPLETE   REDEFINES                      
               WS-RESTART-PROCESS-TYPE   PIC X(01).                     
           05  WS-RESTART-JOB-STATUS     PIC X(01).                     
               88  WS-RUN-COMPLETED-NO-PROBLEMS   VALUE 'A'.            
               88  WS-RERUN-COMPLETED             VALUE 'B'.            
               88  WS-RERUN-PENDING               VALUE 'C'.            
           05  WS-RESTART-COMMON-DATE PIC X(10) VALUE SPACES.           
           05  WS-RESTART-CHKP-SEQ-NO PIC 9(08) VALUE 0.                
           05  WS-RESTART-ACCOUNT-NO  PIC 9(13) VALUE 0.                
           05  WS-RESTART-BE22-CNT    PIC 9(09) VALUE 0.                
      *                                                                         
       01  WS-NULL-INDICATORS.                                          
           05 WS-DSM-ACCT-ENROLL-DT-IND    PIC S9(04) COMP.             
       01  WS-SWITCHES.                                                 
           05 WS-CWS-TABLE-ID              PIC  9(04).                  
              88 WS-CWS10000-TABLE-ID      VALUES                       
P00172            0300 1900 1910 2300 5300 6550 6750.                   
                                                                        
              88 WS-CWS10001-TABLE-ID      VALUES                       
                  3200 3300 3700 3800 4300 4310.                        
              88 WS-CWS10009-TABLE-ID      VALUES                       
                 6400.                                                  
           05 WS-BILL-PRT-MSG-CD           PIC X(3).                    
              88 FIXED-PRICE               VALUE                        
                 'FPN' 'FPL' 'FPM' 'FPH'.                               
           05 WS-END-OF-BE22-SW            PIC X(01).                   
              88 END-OF-BE22               VALUE 'Y'.                   
           05 WS-ROW-FOUND-SW              PIC X(01).                   
              88 ROW-FOUND                 VALUE 'Y'.                   
              88 ROW-NOT-FOUND             VALUE 'N'.                   
           05 WS-PENDING-FLAG              PIC  X(01).                  
              88 PENDING-OPT-EXIST         VALUE 'P'.                   
           05 WS-DATABASE                  PIC 9(01) VALUE ZERO.        
              88 CSR-DATABASE              VALUE 1.                     
              88 SEB-DATABASE              VALUE 2.                     
           05 WS-BEGIN-REC-SW              PIC X(01).                   
              88 WS-BEGIN-RECS-PROCESSED    VALUE 'Y'.                  
              88 WS-BEGIN-REC-NOT-PROCESSED VALUE 'N'.                  
              88 WS-START-INPUT-DATA             VALUE 'X'.             
           05 WS-RECORD-FOUND              PIC X(01) VALUE 'N'.         
              88 DATA-RECORD-FOUND          VALUE 'Y'.                  
              88 NO-DATA-RECORD-FOUND       VALUE 'N'.                  
           05 WS-RATE-TYPE                 PIC X(01) VALUE SPACES.      
              88 FIXED-RATE                VALUE 'F'.                   
              88 VARIABLE-RATE             VALUE 'V'.                   
           05 WS-FBE22-STATUS              PIC X(02).                   
              88 FCSBE22-SUCCESSFUL        VALUE '00'.                  
              88 END-OF-FCSBE22            VALUE '10'.                  
           05 WS-SKIP-ACCT-SW              PIC X(01) VALUE SPACE.       
              88 SKIP-ACCT                 VALUE 'Y'.                   
      *                                                                         
      ******************************************************************        
      *  FIOBE01 CONTAINS CWS10001 VARIABLES USED IN OTHER             *        
      ******************************************************************        
       COPY FIOBE01.                                                            
      *                                                                         
      ******************************************************************        
      *  FIOBE00 CONTAINS CWS10000 VARIABLES USED IN OTHER             *        
      ******************************************************************        
       COPY FIOBE00.                                                            
      *                                                                         
      ******************************************************************        
      *  FIOBE02 CONTAINS CWS10000 VARIABLES USED IN OTHER             *        
      ******************************************************************        
       COPY FIOBE02.                                                            
      *                                                                         
      ******************************************************************        
      *  CWS00010  CONTAINS DB2 ABEND VARIABLES                        *        
      ******************************************************************        
       COPY CWS00010.                                                           
      *                                                                         
      ******************************************************************        
      *  CWS00038 IS JC01 WORK DATA FOR RESTART PROCESSING             *        
      ******************************************************************        
       COPY CWS00038.                                                           
      *                                                                         
      ******************************************************************        
      *  CWS1000A & CWS1000B CONTAINS BE02 RECORD LAYOUTS              *        
      ******************************************************************        
       COPY CWS1000A.                                                           
       COPY CWS1000B.                                                           
      *                                                                         
      ******************************************************************        
      *  CWS10009 CONTAINS BE00 AR RECORDS AND MORE                    *        
      ******************************************************************        
       COPY CWS10009.                                                           
      *                                                                         
       COPY CWS10001.                                                           
      *                                                                         
      ******************************************************************        
      *   CWS10005 CONTAINS INDEX/TABLE ERROR MESSAGES BE02            *        
      ******************************************************************        
      * REQUIRE CHANGES TO INCLUDE ACCT_RTPK_AGR TABLE                          
       COPY CWS10005.                                                           
      *                                                                         
      ******************************************************************        
      *   CWS10006 CONTAINS INDEX/TABLE ERROR MESSAGES BE13            *        
      ******************************************************************        
       COPY CWS10006.                                                           
      *                                                                         
      ******************************************************************        
      *  CWS00038 JOB PARM ROUTINE CONTAINS WS-WARNING-DATA-ELEMENTS   *        
      ******************************************************************        
       COPY CWS00303.                                                           
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE FOR CPD09900 CONTAINS ABEND WS VARIABLES       *        
      ******************************************************************        
       COPY CWS09900.                                                           
                                                                        
      ******************************************************************        
      *    WORKING STORAGE SUPPORT FOR MESSAGING SUBPROGRAM - SCACA326 *        
      ******************************************************************        
       COPY CWS00326.                                                           
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
       01  WS-END                          PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSCA296 ENDS HERE  '.            
      *                                                                         
      ****** DB2 COMMUNICATION REQUIREMENT ****************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    TABLE : CSS_ACCOUNT, AT                                     *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
P00505******************************************************************        
P00505*    TABLE : CSS_DSM_PGM_ACCT PN                                 *        
P00505******************************************************************        
P00505     EXEC SQL                                                             
P00505         INCLUDE TBDSMACT                                                 
P00505     END-EXEC.                                                            
P00505*                                                                         
      ******************************************************************        
      *    TABLE : CSS_DELINQUENCY, C8                                 *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    TABLE : CSS_JOB_PARM, G6                                    *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    TABLE : CSS_RESTART, RF                                     *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBRESTRT                                                 
           END-EXEC.                                                            
A04860*                                                                         
A04860******* FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077             
A04860      EXEC SQL                                                            
A04860           INCLUDE CWS00077                                               
A04860      END-EXEC.                                                           
                                                                        
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      **                                                              **        
      **  0000-MAINLINE                                               **        
      **      CONTROLS MAIN PROCESSING OF PROGRAM                     **        
      **                                                              **        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION          THRU 0100-EXIT.         
           PERFORM 1000-PROCESS-INPUT           THRU 1000-EXIT.         
           PERFORM 9000-TERMINATE               THRU 9000-EXIT.         
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZATION.                                           *        
      ******************************************************************        
       0100-INITIALIZATION.                                             
                                                                        
           PERFORM 0110-GET-JOB-PARM-DETAILS    THRU 0110-EXIT.         
           PERFORM 0120-OPEN-FILES              THRU 0120-EXIT.         
           PERFORM 0130-PROCESS-FOR-RESTART     THRU 0130-EXIT.         
           PERFORM 0140-GET-DELINQ-VALUES       THRU 0140-EXIT.         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0110-GET-JOB-PARM-DETAILS.                                     *        
      *    1. SELECT RUN-DATE                                          *        
      *    2. SELECT REVENUE-MONTH                                     *        
      ******************************************************************        
       0110-GET-JOB-PARM-DETAILS.                                       
                                                                        
           PERFORM 6251-GET-FJC01-DATE          THRU 6251-EXIT.         
           IF COMMON-DATE-NEEDED                                        
               PERFORM 0111-GET-COMMON-JP       THRU 0111-EXIT          
           END-IF.                                                      
P00505                                                                  
P00505     MOVE SPACES                   TO WS-SYSIPT.                  
P00505     MOVE 'PCSCA296'               TO WS-PROGRAM.                 
P00505     MOVE WS-PARM                  TO WS-COMMAND.                 
P00505     MOVE ZEROS                    TO WS-SEQUENCE.                
P00505     MOVE WS-KEY-AREA              TO E-FJC01-KEY.                
P00505                                                                  
P00505     PERFORM 7600-START-FCSJC01           THRU  7600-EXIT.        
P00505                                                                  
P00505     PERFORM 7610-READ-FCSJC01            THRU  7610-EXIT         
P00505         UNTIL (WS-INPUT-DATA-BREAKDOWN (1:11) = 'DSM-PGM-CD=')   
P00505            OR  END-OF-SYSIPT.                                    
P00505                                                                  
P00505     IF WS-INPUT-DATA-BREAKDOWN(1:11) = 'DSM-PGM-CD='             
P00505        IF INPUT-ACTIVE                                           
P00505           MOVE G6-PARM-DATA(12:6)    TO WS-DSM-PGM-CD            
P00505           DISPLAY 'DSM-PGM-CD   : '    WS-DSM-PGM-CD             
P00505           PERFORM 7611-CLOSE             THRU 7611-EXIT          
P00505        ELSE                                                      
P00505           DISPLAY 'JOB PARM NOT ACTIVE FOR DSM PGM CD'           
P00505           DISPLAY 'NO RECORDS ARE PROCESSED'                     
P00505           PERFORM 9900-ABEND          THRU 9900-EXIT             
P00505        END-IF                                                    
P00505     ELSE                                                         
P00505        DISPLAY '       '                                         
P00505        DISPLAY 'DSM PGM CD NOT  PRESENT '                        
P00505        DISPLAY 'NO RECS ARE PROCESSED FOR DSM PGM CD'            
P00505        PERFORM 9900-ABEND          THRU 9900-EXIT                
P00505     END-IF.                                                      
P00505                                                                  
P00505     MOVE WS-DSM-PGM-CD               TO PN-DSM-PGM-CD.           
P00505                                                                  
P00505 0110-EXIT.                                                       
P00505     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    GET COMMON FROM CSS_JOB_PARM, NOT COMMONDATE                *        
      ******************************************************************        
       0111-GET-COMMON-JP.                                              
                                                                        
           MOVE SPACES                       TO WS-SYSIPT.              
           MOVE 'COMMON'                     TO WS-PROGRAM.             
           MOVE WS-DATE                      TO WS-COMMAND.             
           MOVE ZEROS                        TO WS-SEQUENCE.            
           MOVE WS-KEY-AREA                  TO E-FJC01-KEY.            
                                                                        
           PERFORM 7600-START-FCSJC01           THRU  7600-EXIT.        
                                                                        
           PERFORM 7610-READ-FCSJC01            THRU  7610-EXIT         
               UNTIL (RUN-DATE AND INPUT-ACTIVE)                        
                  OR  END-OF-SYSIPT.                                    
                                                                        
           EVALUATE TRUE                                                
              WHEN END-OF-SYSIPT                                        
                 DISPLAY ' '                                            
                 DISPLAY '**  PCSCA296 PROCESSING ERROR  **'            
                 DISPLAY '**    NO ACTIVE COMMON DATE FOUND'            
                 DISPLAY '**  PROCESSING TERMINATED **'                 
                 PERFORM 9900-ABEND             THRU 9900-EXIT          
              WHEN OTHER                                                
                 PERFORM 7611-CLOSE             THRU 7611-EXIT          
           END-EVALUATE.                                                
                                                                        
           MOVE WS-INPUT-RUN-DATE            TO WS-INPUT-DATE.          
                                                                        
       0111-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0120-OPEN-FILES.                                               *        
      ******************************************************************        
       0120-OPEN-FILES.                                                 
                                                                        
           OPEN INPUT FCSBE22-FILE.                                     
           IF FCSBE22-SUCCESSFUL                                        
              PERFORM 0500-PROCESS-BEGIN-REC    THRU  0500-EXIT         
                UNTIL E-FBE22-KEY-BREC NOT EQUAL LOW-VALUES             
           ELSE                                                         
              DISPLAY '********** PCSCA296 ABORT **************'        
              DISPLAY '*       0120-OPEN-FILES                *'        
              DISPLAY '*    ERROR OPENING FCSBE22 FILE        *'        
              DISPLAY '* FILE STATUS    : ' WS-FBE22-STATUS             
              DISPLAY '*      PROCESSING TERMINATED           *'        
              DISPLAY '********** PCSCA296 ABORT **************'        
              PERFORM 9900-ABEND                THRU  9900-EXIT         
           END-IF.                                                      
                                                                        
       0120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0130-PROCESS-FOR-RESTART.                                      *        
      ******************************************************************        
       0130-PROCESS-FOR-RESTART.                                        
                                                                        
           INITIALIZE WS-SYSIPT.                                        
           PERFORM 6253-GET-FJC01-CHKP-LIMIT    THRU 6253-EXIT.         
                                                                        
           INITIALIZE WS-SYSIPT                                         
           PERFORM 6235-GET-FJC01-RESTART-REQ   THRU 6235-EXIT.         
                                                                        
           IF WS-CHKP-LUW-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS       
             AND WS-CHKP-UPD-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS    
                 DISPLAY '****PCSCA296 INFORMATIONAL MESSAGE******'     
                 DISPLAY '*     CHKP-LUW AND CHKP-UPD PARMS      *'     
                 DISPLAY '* BOTH SET TO ' WS-FLAG-TO-TURN-OFF-COMMITS   
                 DISPLAY '* , INTERPRETED TO INDICATE THAT       *'     
                 DISPLAY '* INTERIM COMMIT POINTS SHOULD NOT BE  *'     
                 DISPLAY '* TAKEN. COMPLETE RE-RUN REQUIRED UPON *'     
                 DISPLAY '*    UNSUCCESSFUL COMPLETION.          *'     
                 DISPLAY '* PROCESSING CONTINUING...             *'     
                 DISPLAY '****************************************'     
           END-IF.                                                      
                                                                        
           PERFORM 0200-CHECK-RESTART           THRU 0200-EXIT.         
                                                                        
           IF WS-THIS-IS-A-RESTART                                      
              PERFORM 0300-PREPARE-RESTART      THRU 0300-EXIT          
           END-IF.                                                      
                                                                        
       0130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0140-GET-DELINQ-VALUES.                                        *        
      *     1. GET DATABASE DELINQUENCY                                *        
      ******************************************************************        
       0140-GET-DELINQ-VALUES.                                          
                                                                        
           MOVE 'DATABASE'                   TO C8-DELINQ-CD.           
           MOVE '01'                         TO C8-COMPANY-NO.          
           PERFORM 7010-SELECT-DELINQ-VALUE     THRU 7010-EXIT.         
           MOVE C8-DELINQ-VALUE              TO WS-DATABASE.            
                                                                        
       0140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0200-CHECK-RESTART.                                            *        
      ******************************************************************        
       0200-CHECK-RESTART.                                              
                                                                        
           MOVE PROGRAM-NAME                 TO RF-NAME-PROGRAM.        
           MOVE WS-PART-NO                   TO RF-PARTITION-NO         
                                                WS-CHKP-PART-NO.        
           MOVE 1                            TO RF-DUP-CNTRL-NO.        
                                                                        
           PERFORM 7900-SELECT-RESTART          THRU 7900-EXIT.         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE RF-RESTART-DATA-TEXT     TO WS-RESTART-DATA         
               IF WS-RESTART-PROCESS-TYPE NUMERIC                       
                  MOVE WS-Y                  TO WS-IS-THIS-A-RESTART    
               END-IF                                                   
           END-IF.                                                      
                                                                        
           PERFORM 0605-VALIDATE-RESTART-REQ    THRU 0605-EXIT.         
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0300-PREPARE-RESTART.                                          *        
      ******************************************************************        
       0300-PREPARE-RESTART.                                            
                                                                        
           DISPLAY '*******************************************'        
           DISPLAY '*       THIS IS A RESTART OF PCSCA296     *'        
           DISPLAY '*******************************************'        
                                                                        
           MOVE WS-RESTART-CHKP-SEQ-NO       TO WS-CHKP-SEQ-NO.         
           MOVE WS-CHKP-PART-NO              TO WS-PART-NO.             
           IF WS-RESTART-COMMON-DATE NOT EQUAL WS-INPUT-DATE            
                          AND WS-RESTART-COMMON-DATE NOT EQUAL SPACES   
              DISPLAY '********** PCSCA296 ABORT **************'        
              DISPLAY '*       0300-PREPARE-RESTART           *'        
              DISPLAY '* COMMON DATE CHANGED PRIOR TO RESTART *'        
              DISPLAY '* COMMON  DATE   : ' WS-INPUT-DATE               
              DISPLAY '* RESTART DATE   : ' WS-RESTART-COMMON-DATE      
              DISPLAY '*      PROCESSING TERMINATED           *'        
              DISPLAY '********** PCSCA296 ABORT **************'        
              PERFORM 9900-ABEND                THRU  9900-EXIT         
           END-IF.                                                      
                                                                        
           PERFORM 7200-READ-INPUT              THRU  7200-EXIT         
             UNTIL WS-FCSBE22-REC-CNTR = WS-RESTART-BE22-CNT.           
                                                                        
           IF E-FBE22-ACCOUNT-NO EQUAL WS-RESTART-ACCOUNT-NO            
              PERFORM 7200-READ-INPUT           THRU 7200-EXIT          
           ELSE                                                         
              DISPLAY '********** PCSCA296 ABORT **************'        
              DISPLAY '*       0300-PREPARE-RESTART           *'        
              DISPLAY '* ACCOUNT FROM RESTART TABLE DOES NOT  *'        
              DISPLAY '* MATCH WITH BE22 FILE ACCOUNT         *'        
              DISPLAY '* RESTART ACCOUNT : ' WS-RESTART-ACCOUNT-NO      
              DISPLAY '* BE22 ACCOUNT    : ' E-FBE22-ACCOUNT-NO         
              DISPLAY '*      PROCESSING TERMINATED           *'        
              DISPLAY '********** PCSCA296 ABORT **************'        
              PERFORM 9900-ABEND                THRU  9900-EXIT         
           END-IF.                                                      
                                                                        
           MOVE ZEROES                 TO WS-RESTART-COMMIT-COUNTER.    
                                                                        
       0300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0400-PREPARE-PRECOMMIT.                                        *        
      *     MOVE ALL THE REQUIRED RESTART RECORD VALUES PRIOR TO UPDATE*        
      ******************************************************************        
       0400-PREPARE-PRECOMMIT.                                          
                                                                        
            ADD  1                           TO WS-CHKP-SEQ-NO.         
            MOVE 1                           TO WS-RESTART-PROCESS-TYPE.
            MOVE WS-C                        TO WS-RESTART-JOB-STATUS.  
            MOVE WS-INPUT-DATE               TO WS-RESTART-COMMON-DATE. 
            MOVE WS-CHKP-SEQ-NO              TO WS-RESTART-CHKP-SEQ-NO. 
            MOVE WS-ACCOUNT-NO-AT            TO WS-RESTART-ACCOUNT-NO.  
            COMPUTE WS-RESTART-BE22-CNT = WS-FCSBE22-REC-CNTR - 1.      
                                                                        
       0400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0500-PROCESS-BEGIN-REC.                                        *        
      ******************************************************************        
       0500-PROCESS-BEGIN-REC.                                          
                                                                        
           PERFORM 7200-READ-INPUT              THRU 7200-EXIT.         
                                                                        
           EVALUATE TRUE                                                
              WHEN END-OF-FCSBE22                                       
                 DISPLAY '********** PCSCA296 ABORT **************'     
                 DISPLAY '*       0500-PROCESS-BEGIN-REC         *'     
                 DISPLAY '*        FCSBE22 FILE IS EMPTY         *'     
                 DISPLAY '*      PROCESSING TERMINATED           *'     
                 DISPLAY '********** PCSCA296 ABORT **************'     
                 PERFORM 9900-ABEND            THRU  9900-EXIT          
              WHEN E-FBE22-KEY-BREC EQUAL LOW-VALUES                    
                 IF E-FBE22-CREATE-DATE-BREC NOT = WS-INPUT-DATE        
                    DISPLAY '********** PCSCA296 ABORT **************'  
                    DISPLAY '*       0500-PROCESS-BEGIN-REC         *'  
                    DISPLAY '* FCSBE22 CREATE DATE NOT = RUN DATE   *'  
                    DISPLAY '* BE22 CREATE DATE: '                      
                                      E-FBE22-CREATE-DATE-BREC          
                    DISPLAY '* RUN  DATE: ' WS-INPUT-DATE               
                    DISPLAY '*      PROCESSING TERMINATED           *'  
                    DISPLAY '********** PCSCA296 ABORT **************'  
                    PERFORM 9900-ABEND         THRU 9900-EXIT           
                 END-IF                                                 
                 IF E-FBE22-DB-PART-BREC GREATER THAN ZERO              
                    MOVE E-FBE22-DB-PART-BREC TO WS-PART-NO             
                 ELSE                                                   
                    DISPLAY '*********** PCSCA296 ABORT *************'  
                    DISPLAY '*        0500-PROCESS-BEGIN-REC        *'  
                    DISPLAY '*   FCSBE22 PART NO NOT GREATER THAN 0 *'  
                    DISPLAY '*         PROCESSING TERMINATED        *'  
                    DISPLAY '*********** PCSCA296 ABORT *************'  
                    PERFORM 9900-ABEND          THRU 9900-EXIT          
                 END-IF                                                 
                                                                        
                 SET WS-BEGIN-RECS-PROCESSED TO TRUE                    
              WHEN WS-BEGIN-RECS-PROCESSED                              
                 IF E-FBE22-KEY-BREC EQUAL HIGH-VALUES OR LOW-VALUES    
                    IF E-FBE22-KEY-BREC EQUAL HIGH-VALUES               
                      AND NO-DATA-RECORD-FOUND                          
                      AND E-FBE22-RECORD-COUNT-EREC EQUAL ZERO          
                       DISPLAY '******* PCSCA296 MESSAGE*********'      
                       DISPLAY '*   0500-PROCESS-BEGIN-REC      *'      
                       DISPLAY '*    FCSBE22 FILE IS EMPTY      *'      
                       DISPLAY '*    PROCESSING CONTINUING...   *'      
                       DISPLAY '******* PCSCA296 ABORT **********'      
                       PERFORM 9900-ABEND       THRU 9900-EXIT          
                    END-IF                                              
                 ELSE                                                   
                    SET DATA-RECORD-FOUND    TO TRUE                    
                    ADD 1                    TO WS-FCSBE22-REC-CNTR     
                 END-IF                                                 
              WHEN OTHER                                                
                 DISPLAY '********** PCSCA296 ABORT **************'     
                 DISPLAY '*       0500-PROCESS-BEGIN-REC         *'     
                 DISPLAY '*   FIRST RECORD IS NOT A CNTL REC     *'     
                 DISPLAY '*      PROCESSING TERMINATED           *'     
                 DISPLAY '********** PCSCA296 ABORT **************'     
                 PERFORM 9900-ABEND             THRU  9900-EXIT         
           END-EVALUATE.                                                
                                                                        
       0500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT.                                            *        
      *  1. PROCESS ALL BE22 ACCOUNTS                                  *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1010-PROCESS-FCSBE22         THRU 1010-EXIT          
              UNTIL END-OF-BE22.                                        
                                                                        
           PERFORM 0400-PREPARE-PRECOMMIT       THRU 0400-EXIT.         
                                                                        
           MOVE SPACES                       TO WS-RESTART-JOB-COMPLETE.
           IF WS-THIS-IS-A-RESTART                                      
              MOVE WS-B                      TO WS-RESTART-JOB-STATUS   
           ELSE                                                         
              MOVE WS-A                      TO WS-RESTART-JOB-STATUS   
           END-IF.                                                      
                                                                        
           PERFORM 8888-COMMIT                  THRU 8888-EXIT.         
                                                                        
           IF WS-RESTART-REQ EQUAL WS-Y                                 
              PERFORM 8893-RESET-RESTART-REQ-PARM                       
                                                THRU 8893-EXIT          
           END-IF.                                                      
                                                                        
           IF WS-THIS-IS-A-RESTART                                      
              DISPLAY 'PCSCA296 RERUN COMPLETED'                        
           ELSE                                                         
              DISPLAY 'PCSCA296 COMPLETED SUCCESSFULLY'                 
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1010-PROCESS-FCSBE22.                                          *        
      ******************************************************************        
       1010-PROCESS-FCSBE22.                                            
                                                                        
           IF E-FBE22-KEY-BREC EQUAL HIGH-VALUES OR LOW-VALUES          
              CONTINUE                                                  
           ELSE                                                         
              MOVE E-FBE22-ACCOUNT-NO        TO AT-ACCOUNT-NO           
P00505        MOVE E-FBE22-COMPANY-NO        TO AT-COMPANY-NO           
              PERFORM 7100-GET-ACCOUNT-DET      THRU 7100-EXIT          
              PERFORM 1100-LOAD-BE22-ACCT-TO-WS THRU 1100-EXIT          
                                                                        
              IF AT-CODE-ACCT-BILLED = WS-EXCLUDE-FROM-POST-BILLING     
A04860           INITIALIZE CWS00077-FIELDS                             
A04860           MOVE 17                       TO WS-77-CATEGORY-ID     
A04860           MOVE 4                        TO WS-77-ROUTE-CATEGORY  
A04860           MOVE WS-WQ-COMMENTS           TO WS-77-COMMENTS-TEXT   
A04860           MOVE LENGTH OF WS-WQ-COMMENTS TO WS-77-COMMENTS-LEN    
                 PERFORM 5500-CREATE-WQ         THRU 5500-EXIT          
              ELSE                                                      
                 PERFORM 2000-PROCESS-ACCOUNT   THRU 2000-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
           ADD 1                       TO WS-RESTART-COMMIT-COUNTER.    
           IF WS-RESTART-COMMIT-COUNTER = WS-CHKP-LUW-LIMIT OR          
              WS-RESTART-COMMIT-COUNTER = WS-CHKP-UPD-LIMIT             
              PERFORM 0400-PREPARE-PRECOMMIT    THRU 0400-EXIT          
              PERFORM 8888-COMMIT               THRU 8888-EXIT          
              MOVE ZEROES              TO WS-RESTART-COMMIT-COUNTER     
           END-IF.                                                      
                                                                        
           IF WS-END-OF-BE22-SW NOT = 'Y'                               
             AND E-FBE22-ACCOUNT-NO IS NOT NUMERIC                      
              PERFORM 7200-READ-INPUT           THRU 7200-EXIT          
           END-IF.                                                      
                                                                        
       1010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-LOAD-BE22-ACCT-TO-WS.                                     *        
      *   1. LOAD ALL BE22 RECORDS OF AN ACCOUNT TO CWS10000 VARIABLES *        
      *      AND READ THROUGH TILL IT FINDS A DIFFERENT ACCOUNT        *        
      ******************************************************************        
       1100-LOAD-BE22-ACCT-TO-WS.                                       
                                                                        
           PERFORM 0609-INITIALIZE-FBE00-WS-AREA THRU 0609-EXIT.        
           PERFORM 0640-INITIALIZE-FBE01-WS-AREA THRU 0640-EXIT.        
           PERFORM 0690-INITIALIZE-FBE02-WS-AREA THRU 0690-EXIT.        
                                                                        
           MOVE E-FBE22-ACCOUNT-NO     TO WS-PREVIOUS-ACCT-NO.          
                                                                        
           PERFORM 1110-LOAD-ACCT-TO-WS          THRU 1110-EXIT         
             UNTIL END-OF-BE22                                          
                 OR E-FBE22-ACCOUNT-NO NOT = WS-PREVIOUS-ACCT-NO.       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1110-LOAD-ACCT-TO-WS.                                          *        
      ******************************************************************        
       1110-LOAD-ACCT-TO-WS.                                            
                                                                        
           MOVE FIOBE22                      TO FIOBE02.                
           MOVE E-FBE02-SORT-KEY             TO E-FBE01-SORT-KEY.       
           MOVE E-FBE02-TABLE-ID             TO WS-CWS-TABLE-ID.        
           IF WS-CWS10000-TABLE-ID                                      
              PERFORM 0800-LOAD-FBE02-WS-AREA   THRU 0800-EXIT          
           END-IF.                                                      
           IF WS-CWS10001-TABLE-ID                                      
              MOVE E-FBE02-SORT-KEY          TO E-FBE01-SORT-KEY        
              MOVE E-FBE02-DATA(1:250)       TO E-FBE01-DATA            
              PERFORM 0850-LOAD-FBE01-WS-AREA   THRU 0850-EXIT          
           END-IF.                                                      
           PERFORM 7200-READ-INPUT              THRU 7200-EXIT.         
                                                                        
       1110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-ACCOUNT.                                          *        
      *  1. PROCESS EACH ACCOUNT WITH WS VALUES                        *        
      ******************************************************************        
       2000-PROCESS-ACCOUNT.                                            
                                                                        
           IF SEB-DATABASE                                              
              PERFORM 2100-RTPKG-RENEWAL-PROCESS THRU 2100-EXIT         
P00505     ELSE                                                         
P00505        IF AT-COMPANY-NO = '01'                                   
P00505           PERFORM 2300-DSM-ACCT-PROCESS   THRU 2300-EXIT         
P00505        END-IF                                                    
P00505     END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2100-RTPKG-RENEWAL-PROCESS.                                    *        
      *  1. PROCESS EACH ACCOUNT WITH WS VALUES                        *        
      ******************************************************************        
       2100-RTPKG-RENEWAL-PROCESS.                                      
                                                                        
           MOVE SPACES                       TO WS-RATE-TYPE            
                                                WS-BILL-PRT-MSG-CD.     
           MOVE 'N'                          TO WS-SKIP-ACCT-SW.        
           MOVE ZEROS                        TO WS-CURR-DUR-REM-NO.     
                                                                        
           PERFORM 5100-CHECK-ACCT-TO-SKIP      THRU 5100-EXIT.         
                                                                        
P00172     IF FIXED-RATE                                                
P00172        PERFORM 5110-CHECK-PENDING-OPT    THRU 5110-EXIT          
P00172     END-IF                                                       
P00172                                                                  
           IF FIXED-RATE AND PENDING-OPT-EXIST                          
             AND NOT SKIP-ACCT                                          
              PERFORM 2105-GET-CURR-OPT-DUR-REM THRU 2105-EXIT          
              PERFORM 2110-SET-PEND-OPTN-ACTIVE THRU 2110-EXIT          
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2105-GET-CURR-OPT-DUR-REM.                                     *        
      ******************************************************************        
       2105-GET-CURR-OPT-DUR-REM.                                       
                                                                        
           PERFORM VARYING WS-CNTR-FH FROM 1 BY 1                       
             UNTIL WS-CNTR-FH > WS-FH-MAX-ENTRY                         
                OR WS-ACCOUNT-NO-FH(WS-CNTR-FH) = ZEROS                 
                                                                        
             IF WS-BILLING-KEY-FH(WS-CNTR-FH) =                         
                                       WS-BILLING-KEY(WS-BG-ROW)        
                MOVE WS-BILL-PRT-MSG-PL-CD-FH(WS-CNTR-FH)               
                                             TO WS-BILL-PRT-MSG-CD      
                IF FIXED-PRICE                                          
                   MOVE WS-DURATION-REMAIN-NO-FH(WS-CNTR-FH)            
                                             TO WS-CURR-DUR-REM-NO      
                END-IF                                                  
             END-IF                                                     
           END-PERFORM.                                                 
                                                                        
       2105-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2110-SET-PEND-OPTN-ACTIVE.                                     *        
      ******************************************************************        
       2110-SET-PEND-OPTN-ACTIVE.                                       
                                                                        
           IF WS-CURR-DUR-REM-NO = 1                                    
              MOVE WS-PENDING-BATCH-CD       TO WS-PROCESS-CD-O         
              MOVE PROGRAM-NAME              TO WS-APPL-PGMID           
              CALL SCSCA326 USING  ABEND-FILE                           
                                  ,WS-WARNING-DATA-ELEMENTS             
                                  ,LS-MCSCB326-CALL-TYPE                
                                  ,LS-MCSCB326-ONLINE-CALL              
                                  ,LS-MCSCB326-RET-FIELDS               
                                                                        
              IF WS-ACTIVE-RETURN-CODE EQUAL ZEROES                     
                 DISPLAY 'PENDING OPT SET TO ACTIVE: ' WS-ACCOUNT-NO-O  
              ELSE                                                      
                 DISPLAY '********** PCSCA296 ABORT **************'     
                 DISPLAY '*       2110-SET-PEND-OPTN-ACTIVE      *'     
                 DISPLAY '* SUB-PROGRAM SCSCA326 FAILED WITH     *'     
                 DISPLAY '* RETURN CODE       : ' WS-ACTIVE-RETURN-CODE 
                 DISPLAY '* ABEND PROGRAM     : ' ABEND-PROGRAM         
                 DISPLAY '* ACTIVE PARAGRAPH  : ' ACTIVE-PARAGRAPH      
                 DISPLAY '* ABEND-FUNCTION    : ' ABEND-FUNCTION        
                 DISPLAY '* TABLE-1           : ' TABLE-1               
                 DISPLAY '* TABLE-ELEMENT-1   : ' TABLE-ELEMENT-1       
                 DISPLAY '* TABLE-ELEMENT-2   : ' TABLE-ELEMENT-2       
                 DISPLAY '* TABLE-ELEMENT-3   : ' TABLE-ELEMENT-3       
                 DISPLAY '* TABLE-ELEMENT-4   : ' TABLE-ELEMENT-4       
                 DISPLAY '* HOSTVAR-ELEMENT-1 : ' HOSTVAR-ELEMENT-1     
                 DISPLAY '* HOSTVAR-ELEMENT-2 : ' HOSTVAR-ELEMENT-2     
                 DISPLAY '* HOSTVAR-ELEMENT-3 : ' HOSTVAR-ELEMENT-3     
                 DISPLAY '* HOSTVAR-ELEMENT-4 : ' HOSTVAR-ELEMENT-4     
                 DISPLAY '* ACCOUNT NO        : ' WS-ACCOUNT-NO-O       
                 DISPLAY '* CODE UTIL TYPE    : ' WS-CODE-UTIL-TYPE-O   
                 DISPLAY '* IC NO             : ' WS-IC-NO-O            
                 DISPLAY '* OPTION CODE       : ' WS-OPTION-CD-O        
                 DISPLAY '* AGR EFF DATE      : ' WS-OPT-AGRMT-EFF-DT-O 
                 DISPLAY '*       PROCESSING TERMINATED          *'     
                 DISPLAY '********** PCSCA296 ABORT **************'     
                 PERFORM 9900-ABEND                THRU 9900-EXIT       
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00505******************************************************************        
P00505* 2300-DSM-ACCT-PROCESS.                                         *        
P00505******************************************************************        
P00505 2300-DSM-ACCT-PROCESS.                                           
P00505                                                                  
P00505* CHECK FOR FINAL BILL                                                    
P00505     MOVE AT-ACCOUNT-NO               TO PN-ACCOUNT-NO            
P00505     IF WS-CODE-ACCT-STAT-AT = 'B'                                
P00505        MOVE 'N'                      TO WS-EXISTS                
P00505        PERFORM 7000-DSM-PGM-ACCT-EXISTS  THRU 7000-EXIT          
P00505        IF WS-EXISTS = 'Y'                                        
P00505           PERFORM 8000-UPDATE-DSM-PGM-ACCT THRU 8000-EXIT        
P00505        END-IF                                                    
P00505     END-IF.                                                      
P00505                                                                  
P00505 2300-EXIT.                                                       
P00505     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5100-CHECK-ACCT-TO-SKIP.                                       *        
      *   1. SET THE SKIP FLAG TO TRUE WHEN THE ACCOUNT TO BE          *        
      *      EXCLUDED FROM THE RATE PAKAGE RENEWAL PROCESS.            *        
      ******************************************************************        
       5100-CHECK-ACCT-TO-SKIP.                                         
                                                                        
           MOVE 0                            TO WS-BG-ROW.              
           MOVE SPACES                       TO WS-RT-CALC-TYP-CD.      
P00172     MOVE 'N'                          TO WS-ROW-FOUND-SW.        
                                                                        
      * CHECK FOR FINAL BILL                                                    
           IF WS-CODE-ACCT-STAT-AT = 'B'                                
              SET SKIP-ACCT                  TO TRUE                    
           END-IF                                                       
                                                                        
      * CHECK FOR CANCEL REBILL                                                 
           PERFORM VARYING WS-CNTR-BG FROM 1 BY 1                       
SCA006       UNTIL SKIP-ACCT OR 
SCA006             ROW-FOUND OR 
                   WS-CNTR-BG > WS-BG-MAX-ENTRY OR 
                   WS-ACCOUNT-NO-BG(WS-CNTR-BG) EQUAL ZEROES                    
             IF WS-CODE-BILL-ITM-TYPE-BG(WS-CNTR-BG) = 'C'              
                AND WS-CODE-BILL-ITM-IND-BG(WS-CNTR-BG) = 'A'           
                    AND WS-CODE-BILL-CALC-BG (WS-CNTR-BG) = 'A'         
                     AND ( WS-DATE-ORIG-BILL-BG (WS-CNTR-BG) = SPACES   
                                                        OR LOW-VALUES ) 
                MOVE WS-CNTR-BG              TO WS-BG-ROW               
                SET ROW-FOUND                TO TRUE                    
             END-IF                                                     
           END-PERFORM.                                                 
                                                                        
           IF WS-BG-ROW = 0                                             
              SET SKIP-ACCT                  TO TRUE                    
           END-IF.                                                      
                                                                        
      * CHECK RATE CALCULATION TYPE                                             
           MOVE 'N'                          TO WS-ROW-FOUND-SW.        
           PERFORM VARYING WS-CNTR-BT FROM 1 BY 1                       
SCA006       UNTIL SKIP-ACCT OR 
SCA006             ROW-FOUND OR 
                   WS-CNTR-BT > 30 OR 
                   WS-ACCOUNT-NO-BT(WS-CNTR-BT) = 0                             
              IF WS-BILL-DET-KEY-BT(WS-CNTR-BT)                         
                                        EQUAL WS-BILLING-KEY(WS-BG-ROW) 
                 MOVE WS-CNTR-BT             TO WS-BT-CNT               
                 MOVE WS-RATE-CALC-TYPE-CD-BT(WS-BT-CNT)                
                                             TO WS-RT-CALC-TYP-CD       
                 SET ROW-FOUND               TO TRUE                    
               END-IF                                                   
           END-PERFORM.                                                 
                                                                        
           IF SKIP-ACCT                                                 
              CONTINUE                                                  
           ELSE                                                         
              EVALUATE WS-RT-CALC-TYP-CD                                
              WHEN '02'                                                 
                  SET FIXED-RATE             TO TRUE                    
              WHEN OTHER                                                
                  SET VARIABLE-RATE          TO TRUE                    
              END-EVALUATE                                              
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5110-CHECK-PENDING-OPT.                                        *        
      ******************************************************************        
       5110-CHECK-PENDING-OPT.                                          
                                                                        
           INITIALIZE LS-MCSCB326-ONLINE-CALL.                          
P00172     MOVE 'N'                          TO WS-PENDING-FLAG.        
                                                                        
           PERFORM VARYING WS-CNTR-DF FROM 1 BY 1                       
             UNTIL WS-CNTR-DF > WS-DF-MAX-ENTRY                         
                OR WS-ACCOUNT-NO-DF(WS-CNTR-DF) = 0                     
                                                                        
             IF WS-STATUS-CD-DF(WS-CNTR-DF) = WS-PENDING                
                SET PENDING-OPT-EXIST        TO TRUE                    
                MOVE WS-ACCOUNT-NO-DF(WS-CNTR-DF)                       
                                             TO WS-ACCOUNT-NO-O         
                MOVE WS-CODE-UTIL-TYPE-DF(WS-CNTR-DF)                   
                                             TO WS-CODE-UTIL-TYPE-O     
                MOVE WS-IC-NO-DF(WS-CNTR-DF) TO WS-IC-NO-O              
                MOVE WS-OPTION-CD-DF(WS-CNTR-DF)                        
                                             TO WS-OPTION-CD-O          
                MOVE WS-OFFER-CD-DF(WS-CNTR-DF)                         
                                             TO WS-OFFER-CD-O           
                MOVE WS-TRANS-SEQ-ID-DF(WS-CNTR-DF)                     
                                             TO WS-TRANS-SEQ-ID-O       
                MOVE WS-PROMO-CD-DF(WS-CNTR-DF)                         
                                             TO WS-PROMO-CD-O           
                MOVE WS-COMM-CHANNEL-DF(WS-CNTR-DF)                     
                                             TO WS-COMM-CHANNEL-O       
                MOVE WS-CREATED-USERID-DF(WS-CNTR-DF)                   
                                             TO WS-CREATED-USER-ID-O    
                MOVE WS-OPT-AGRMT-EFF-DT-DF(WS-CNTR-DF)                 
                                             TO WS-OPT-AGRMT-EFF-DT-O   
                MOVE WS-OPT-AGRMT-EFF-TM-DF(WS-CNTR-DF)                 
                                             TO WS-OPT-AGRMT-EFF-TM-O   
                MOVE WS-RT-PKG-OPT-SEQ-NO-DF(WS-CNTR-DF)                
                                             TO WS-RT-PKG-OPT-SEQ-NO-O  
             END-IF                                                     
           END-PERFORM.                                                 
                                                                        
       5110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5500-CREATE-WQ.                                                *        
      ******************************************************************        
       5500-CREATE-WQ.                                                  
                                                                        
A04860     MOVE 'N'                          TO WS-77-PRIORITY.         
A04860     MOVE ZEROS                        TO WS-77-SERV-ORDER-NO.    
A04860     MOVE SPACES                       TO WS-77-RESP-AREA-ID.     
A04860     MOVE WS-INPUT-DATE                TO WS-INPUT-DATE-PT.       
A04860     MOVE WS-INPUT-DATE                TO WS-77-DATE-REQUIRED.    
A04860     MOVE WS-INPUT-TS                  TO WS-77-DATE-CREATED.     
A04860     MOVE WS-ACCOUNT-NO-AT             TO WS-77-ACCOUNT-NO.       
A04860     MOVE WS-PREMISE-NO-AT             TO WS-77-PREMISE-NO.       
A04860     MOVE WS-CUSTOMER-NO-AT            TO WS-77-CUSTOMER-NO.      
A04860     MOVE WS-LOCAL-OFFICE-AT           TO WS-77-LOCAL-OFFICE.     
A04860     MOVE ZEROS                        TO WS-77-FREE-FORM-LEN.    
A04860     MOVE LOW-VALUES                   TO WS-77-FREE-FORM-TXT.    
A04860     MOVE PROGRAM-NAME                 TO WS-77-CREATED-BY.       
           PERFORM 8895-INSERT-WORK-QUEUE       THRU 8895-EXIT.         
                                                                        
       5500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0605-VALIDATE-RESTART-REQ.                                     *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00030                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 6251-GET-FJC01-DATE                                            *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD00037                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 6253-GET-FJC01-CHKP-LIMIT.                                     *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00034                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   0609-INITIALIZE-FBE00-WS-AREA                                *        
      ******************************************************************        
       COPY CPD00052.                                                           
                                                                        
      ******************************************************************        
      *   0640-INITIALIZE-FBE01-WS-AREA                                *        
      ******************************************************************        
       COPY CPD00049.                                                           
                                                                        
      ******************************************************************        
      *   0690-INITIALIZE-FBE02-WS-AREA                                *        
      ******************************************************************        
       COPY CPD00101.                                                           
                                                                        
      ******************************************************************        
      *   6235-GET-FJC01-RESTART-REQ.                                  *        
      ******************************************************************        
       COPY CPD00035.                                                           
      *                                                                         
P00505******************************************************************        
P00505* 7000-DSM-PGM-ACCT-EXISTS.                                    *          
P00505******************************************************************        
P00505 7000-DSM-PGM-ACCT-EXISTS.                                        
P00505*                                                                         
P00505     EXEC SQL                                                     
P00505        SELECT TOP(1) 'Y'                                                
P00505          INTO :WS-EXISTS                                         
P00505          FROM CSS_DSM_PGM_ACCT PN WITH(READUNCOMMITTED)                  
P00505         WHERE PN.ACCOUNT_NO = :PN-ACCOUNT-NO                     
P00505           AND PN.DSM_PGM_CD = :PN-DSM-PGM-CD                     
P00505           AND PN.COMPANY_NO = '01'                               
P00505           AND PN.DSM_ACCT_STATUS_CD  = 'A'                       
P00505                                              
P00505                                                           
P00505                                                      
P00505     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-EXISTS                                                 
MFA-TR*         FROM CSS_DSM_PGM_ACCT PN                                        
MFA-TR*        WHERE PN.ACCOUNT_NO = :PN-ACCOUNT-NO                             
MFA-TR*          AND PN.DSM_PGM_CD = :PN-DSM-PGM-CD                             
MFA-TR*          AND PN.COMPANY_NO = '01'                                       
MFA-TR*          AND PN.DSM_ACCT_STATUS_CD  = 'A'                               
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00505                                                                  
P00505     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
P00505                                                                  
P00505     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00505        CONTINUE                                                  
P00505     ELSE                                                         
P00505         DISPLAY '********** PCSCA296  ABORT **************'      
P00505         DISPLAY '* 7000-DSM-PGM-ACCT-EXISTS              *'      
P00505         DISPLAY '* SQLCODE IS   ' WS-ACTIVE-RETURN-CODE          
P00505         DISPLAY '* ACCOUNT_NO : ' PN-ACCOUNT-NO                  
P00505         DISPLAY '* PROGRAM ABORTING...                   *'      
P00505         DISPLAY '********** PCSCA296  ABORT **************'      
P00505         PERFORM 9900-ABEND THRU 9900-EXIT                        
P00505     END-IF.                                                      
P00505                                                                  
P00505 7000-EXIT.                                                       
P00505     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7010-SELECT-DELINQ-VALUE                                       *        
      ******************************************************************        
       7010-SELECT-DELINQ-VALUE.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD    = :C8-DELINQ-CD                       
                 AND COMPANY_NO   = :C8-COMPANY-NO                      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD    = :C8-DELINQ-CD                               
MFA-TR*          AND COMPANY_NO   = :C8-COMPANY-NO                              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '********** PCSCA296  ABORT **************'      
               DISPLAY '* 7010-SELECT-DELINQ-VALUE              *'      
               DISPLAY '* SQLCODE IS   ' WS-ACTIVE-RETURN-CODE          
               DISPLAY '* DELINQ_CD  : ' C8-DELINQ-CD                   
               DISPLAY '* COMPANY_NO : ' C8-COMPANY-NO                  
               DISPLAY '* PROGRAM ABORTING...                   *'      
               DISPLAY '********** PCSCA296  ABORT **************'      
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-GET-ACCOUNT-DET                                           *        
      ******************************************************************        
       7100-GET-ACCOUNT-DET.                                            
                                                                        
           EXEC SQL                                                     
               SELECT AT.CODE_ACCT_BILLED                               
                 INTO :AT-CODE-ACCT-BILLED                              
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AT.CODE_ACCT_BILLED                                       
MFA-TR*          INTO :AT-CODE-ACCT-BILLED                                      
MFA-TR*          FROM CSS_ACCOUNT AT                                            
MFA-TR*         WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '********** PCSCA296  ABORT **************'      
               DISPLAY '* 7100-GET-ACCOUNT-DET                  *'      
               DISPLAY '* SQLCODE IS   ' WS-ACTIVE-RETURN-CODE          
               DISPLAY '* ACCOUN NO  : ' AT-ACCOUNT-NO                  
               DISPLAY '* PROGRAM ABORTING...                   *'      
               DISPLAY '********** PCSCA296  ABORT **************'      
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *      READS FCSBE22 FILE FOR INPUT                              *        
      ******************************************************************        
       7200-READ-INPUT.                                                 
                                                                        
           READ FCSBE22-FILE AT END                                     
               MOVE 'Y' TO WS-END-OF-BE22-SW                            
               GO TO 7200-EXIT.                                         
                                                                        
           IF FCSBE22-SUCCESSFUL                                        
               IF E-FBE22-KEY-BREC NOT EQUAL HIGH-VALUES                
                OR E-FBE22-KEY-BREC NOT EQUAL LOW-VALUES                
                  IF DATA-RECORD-FOUND                                  
                     ADD 1 TO WS-FCSBE22-REC-CNTR                       
                  END-IF                                                
               END-IF                                                   
           ELSE                                                         
              DISPLAY '********** PCSCA296 ABORT **************'        
              DISPLAY '*     READ ERROR : BE22 FILE           *'        
              DISPLAY '* CURRENT PARA   : 7200                *'        
              DISPLAY '* FILE-STATUS    : ' WS-FBE22-STATUS             
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA296 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CPD00038                                                       *        
      * 7600-START-FCSJC01                                             *        
      * 7610-READ-FCSJC01                                              *        
      * 7611-CLOSE                                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7900-SELECT-RESTART.                                           *        
      ******************************************************************        
       7900-SELECT-RESTART.                                             
           EXEC SQL                                                     
               SELECT RF.RESTART_DATA                                   
                 INTO :RF-RESTART-DATA                                  
                 FROM CSS_RESTART RF WITH(READUNCOMMITTED)                      
                WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                
                  AND RF.PARTITION_NO = :RF-PARTITION-NO                
                  AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RF.RESTART_DATA                                           
MFA-TR*          INTO :RF-RESTART-DATA                                          
MFA-TR*          FROM CSS_RESTART RF                                            
MFA-TR*         WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                        
MFA-TR*           AND RF.PARTITION_NO = :RF-PARTITION-NO                        
MFA-TR*           AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                        
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA296 ABORT **************'        
              DISPLAY '**   ERROR ON 7900-SELECT-RESTART     **'        
              DISPLAY '**   PROGRAM NAME = ' RF-NAME-PROGRAM            
              DISPLAY '**   PARTITION NO = ' RF-PARTITION-NO            
              DISPLAY '**   DUP CNTRL NO = ' RF-DUP-CNTRL-NO            
              DISPLAY '**   RETURN CODE  = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**       PROCESSING TERMINATED        **'        
              DISPLAY '********** PCSCA296 ABORT **************'        
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   0800-LOAD-FBE02-WS-AREA                                      *        
      ******************************************************************        
       COPY CPD00050.                                                           
                                                                        
      ******************************************************************        
      *   0850-LOAD-FBE01-WS-AREA                                      *        
      ******************************************************************        
       COPY CPD00051.                                                           
                                                                        
P00505*****************************************************************         
P00505* 8000-UPDATE-DSM-PGM-ACCT.                                     *         
P00505*****************************************************************         
P00505 8000-UPDATE-DSM-PGM-ACCT.                                        
P00505                                                                  
P00505     EXEC SQL                                                     
P00505         UPDATE PN                                
P00505            SET DSM_ACCT_STATUS_CD = 'O'                          
               FROM CSS_DSM_PGM_ACCT PN
P00505          WHERE PN.ACCOUNT_NO = :PN-ACCOUNT-NO                    
P00505            AND PN.DSM_ACCT_STATUS_CD = 'A'                       
P00505     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_DSM_PGM_ACCT PN                                       
MFA-TR*           SET DSM_ACCT_STATUS_CD = 'O'                                  
MFA-TR*         WHERE PN.ACCOUNT_NO = :PN-ACCOUNT-NO                            
MFA-TR*           AND PN.DSM_ACCT_STATUS_CD = 'A'                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00505                                                                  
P00505     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00505                                                                  
P00505     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00505        CONTINUE                                                  
P00505     ELSE                                                         
P00505        DISPLAY '********** PCSCA296 ABORT **************'        
P00505        DISPLAY '*       8000-UPDATE-DSM-PGM-ACCT       *'        
P00505        DISPLAY '* ACCOUNT_NO     : ' PN-ACCOUNT-NO               
P00505        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
P00505        DISPLAY '*     PROCESSING TERMINATED            *'        
P00505        DISPLAY '********** PCSCA296 ABORT **************'        
P00505        PERFORM 9900-ABEND                     THRU 9900-EXIT     
P00505     END-IF.                                                      
P00505                                                                  
P00505 8000-EXIT.                                                       
P00505     EXIT.                                                        
P00505*                                                                         
      ******************************************************************        
      *                                                                *        
      * 8800-WRITE-RESTART                                             *        
      ******************************************************************        
       8800-WRITE-RESTART.                                              
                                                                        
           MOVE WS-PGRMNAME                 TO RF-NAME-PROGRAM.         
           MOVE WS-PART-NO                  TO RF-PARTITION-NO.         
           MOVE 1                           TO RF-DUP-CNTRL-NO.         
           MOVE WS-RESTART-DATA             TO RF-RESTART-DATA-TEXT.    
           MOVE WS-RESTART-DATA-LENGTH      TO RF-RESTART-DATA-LEN.     
                                                                        
           PERFORM 8850-UPDATE-RESTART          THRU 8850-EXIT.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 8860-INSERT-RESTART       THRU 8860-EXIT          
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8850-UPDATE-RESTART.                                           *        
      ******************************************************************        
       8850-UPDATE-RESTART.                                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_RESTART                                       
                  SET RESTART_DATA = :RF-RESTART-DATA                   
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                   
                  AND PARTITION_NO = :RF-PARTITION-NO                   
                  AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO  WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA296 ABORT **************'        
              DISPLAY '*        8850-UPDATE-RESTART           *'        
              DISPLAY '* NAME_PROGRAM   : ' RF-NAME-PROGRAM             
              DISPLAY '* DUP_CNTRL_NO   : ' RF-DUP-CNTRL-NO             
              DISPLAY '* PARTITION_NO   : ' RF-PARTITION-NO             
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA296 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8860-INSERT-RESTART.                                           *        
      ******************************************************************        
       8860-INSERT-RESTART.                                             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_RESTART                                  
                     ( NAME_PROGRAM                                     
                      ,PARTITION_NO                                     
                      ,DUP_CNTRL_NO                                     
                      ,RESTART_DATA)                                    
               VALUES(:RF-NAME-PROGRAM                                  
                     ,:RF-PARTITION-NO                                  
                     ,:RF-DUP-CNTRL-NO                                  
                     ,:RF-RESTART-DATA)                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO  WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA296 ABORT **************'        
              DISPLAY '*       8860-INSERT-RESTART            *'        
              DISPLAY '* NAME_PROGRAM   : ' RF-NAME-PROGRAM             
              DISPLAY '* DUP_CNTRL_NO   : ' RF-DUP-CNTRL-NO             
              DISPLAY '* PARTITION_NO   : ' RF-PARTITION-NO             
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA296 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8860-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8888-COMMIT.                                                   *        
      ******************************************************************        
       8888-COMMIT.                                                     
                                                                        
           IF WS-CHKP-LUW-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS       
              AND WS-CHKP-UPD-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS   
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 8800-WRITE-RESTART        THRU 8800-EXIT          
                                                                        
              EXEC SQL                                                  
                  COMMIT                                                
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              DISPLAY 'COMMIT POINT # ' WS-CHKP-SEQ-NO ' TAKEN.'        
           END-IF.                                                      
                                                                        
       8888-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *  8895-INSERT-WORK-QUEUE                                        *        
      ******************************************************************        
A04860*                                                                         
A04860 8895-INSERT-WORK-QUEUE.                                          
A04860*                                                                         
A04860     CALL SCSCB077 USING CWS00077-FIELDS,                         
A04860                         ABEND-FILE,                              
A04860                         RS-RETURN-CODE                           
A04860     MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE                 
A04860                                                                  
A04860     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
A04860        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A04860        DISPLAY '8895-INSERT-WORK-QUEUE'                          
A04860        DISPLAY 'CALL SCSCB077         '                          
A04860        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
A04860        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
A04860        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
A04860        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A04860        PERFORM 9900-ABEND    THRU 9900-EXIT                      
A04860     END-IF.                                                      
A04860*                                                                         
A04860 8895-EXIT.                                                       
A04860     EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * 8893-RESET-RESTART-REQ-PARM                                    *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00029                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9000-TERMINATE.                                                *        
      ******************************************************************        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSBE22-FILE.                                          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  9700-PROCESS-ABEND.                                           *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD0023B                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9900-ABEND                                                     *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
