       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   PCSCA293.                                          
      ***************************************************************** 00030000
      *                SOUTH CAROLINA ELECTRIC & GAS                  * 00040000
      *                       PRICE WATERHOUSE                        * 00050000
      *                                                               * 00060000
      *                 CUSTOMER INFORMATION SYSTEM                   * 00070000
      *                                                               * 00080000
      ***************************************************************** 00090000
      *                 P R O G R A M   S U M M A R Y                 * 00100000
      *                                                               * 00110000
      **  THIS PROGRAM IS A DAILY JOB THAT WILL GET 24 MONTH DATA    ** 00120000
      **  WHICH WILL INCLUDE THE BILLING PERIOD, NUMBER OF DAYS      ** 00130000
      **  DURING A BILLING CYCLE, KWH/THERMS CONSUMED DURING THE     ** 00140000
      **  CYCLE, AND THE AMOUNT BILLED FOR THE CYCLE GETTING THE     ** 00150000
      **  IC_NO, PREMISE_NO, CODE_UTIL_TYPE_ACCOUNT_NO, PAYMENTS,    ** 00160000
      **  SINCE BILLING TRANSACTIONS.                                ** 00170000
      **                                                             ** 00180000
      *   THIS PROGRAM USES SOME OF CODE FROM CSR02101                * 00190000
      ***************************************************************** 00200000
      ***************************************************************** 00210000
      *                                                               * 00220000
      *         -----    BASIC SEQUENCE STRUCTURE   -----             * 00230000
      * 0000         MODULE CONTROL                                   * 00240000
      * 0100 - 0999  INITIALIZATION                                   * 00250000
      * 1000 - 1999  FUNCTIONAL CONTROL                               * 00260000
      * 2000 - 4999  DETAIL LOGIC                                     * 00270000
      * 5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES               * 00280000
      * 6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)     * 00290000
      * 7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.    * 00300000
      * 8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC    * 00310000
      * 9000 - 9999  ABEND / ERROR ROUTINES.                          * 00320000
      *                                                               * 00330000
      ***************************************************************** 00340000
      ***************************************************************** 00350000
      **                                                             ** 00360000
      **              PROGRAM  MODIFICATION  LOG                     ** 00370000
      *                                                               * 00380000
      **    DATE       INITIALS      REASON                          ** 00390000
      **    ----       --------      ------                          ** 00400000
      *  08/01/11    SV82012      NEW PROGRAM FOR CUSTOMER BILLING    * 00410000
      *                           STATEMENT.                          * 00420000
ACT059** 09/29/11    BD09555      Initalize working-storage          ** 00430000
ACT059**  A03967                  variables                          ** 00440000
P00641** 06/29/12    EM19682      Get GL account name desc from      ** 00450000
P00641**                          CSS_GL_ACCT_NO table               ** 00460000
A04149** 10/10/13    MR7E794      REMOVED DUPLICATE LOGIC AND        ** 00470000
A04149**             ACT003       CUSTOMIZE THE LOGIC TO BE SHARED   ** 00480000
A04149**                          B/W THE COMPONENTS (PCSCA293 &     ** 00490000
A04149**                          SCSCA167) BY ADDING IT TO A NEW    ** 00500000
A04149**                          COPYBOOK CPDCA167.                 ** 00510000
A04127**  01/16/15  SV95326       ADD WS-ALOC-ITPA-PROCESS PARAMETER ** 00520000
      **                          WHILE CALLING SCSCA184             ** 00530000
P00837**  09/21/15  SV95326   PASS COMM_TYPE AND COMM_SUB_TYPE TO    ** 00570000
P00837**                      DIALOG.                                ** 00580000
P00821**  04/27/15  HA7A338   CHANGE THE LOGIC TO FETCH EITHER 12 MNT** 00580100
P00821**                      OR 24 MNTHS BILL BASED ON THE SPCL CODE** 00580200
P00821**                      PASSED IN THE INPUT FILE.              ** 00580300
P00836**  10/05/15  MS7M727   INSERT DATA INTO CSS_BATCH_EMAIL       ** 00581000
P00836**                      AND CSS_BTCH_EMAIL_DET TABLE WHEN      ** 00583000
P00836**                      STATEMENT  GENERATED FROM WEB.         ** 00584000
ACT070**  02/25/16  MC95456   USE NEXT VALUE FOR BATCH_EMAIL_ID      ** 00585000
ACT070**  APPL5460            IN CSS_BATCH_EMAIL TABLE.              ** 00585100
ACT060**  11/06/16  SV95326   STATEMENTS W/ XFOOT ERRORS IN 12 MONTHS** 00585200
ACT060**            A*5462    STATEMENT.                             ** 00585300
      **                                                             ** 00586000
      ***************************************************************** 00590000
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *** CA293 IS THE INPUT FILE FOR CUSTOMER BILLING STATEMENT        00630000
       COPY CSSCA293.                                                   00640000
      *** BE293 IS THE OUTPUT FILE FOR CUSTOMER BILLING STATEMENT       00650000
       COPY CSSBE293.                                                   00660000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                 00690000
       COPY CFDCA293.                                                   00700000
       COPY FIOCA293.                                                   00710000
      *                                                                 00720000
       COPY CFDBE293.                                                   00730000
       COPY FIOBE293.                                                   00740000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA293'.
MSQ017     COPY MFASQLM.
      *                                                                 00760000
       01  WS-MISC-VAR.                                                 
           05  WS-FCA293-STATUS            PIC  X(02).                  
               88 FCA293-SUCCESSFUL                  VALUE '00'.        
           05  WS-FBE293-STATUS            PIC  X(02).                  
               88 FBE293-SUCCESSFUL                  VALUE '00'.        
           05  WS-END-OF-CA293             PIC X     VALUE 'N'.         
               88  END-OF-CA293                      VALUE 'Y'.         
           05 WS-UNIQ-GEN-SW               PIC X(01) VALUE 'N'.         
               88  UNIQ-GENERATED                    VALUE 'Y'.         
           05  WS-END-OF-AR-RECS-SW        PIC X(01).                   
               88  WS-END-OF-AR-RECS                 VALUE 'Y'.         
           05  WS-OLDEST-TRAN-SW           PIC X(01).                   
               88  OLDEST-TRANSACTION                VALUE 'Y'.         
           05  SEND-DONE-SW                PIC X(01) VALUE 'Y'.         
               88 SEND-DONE-ERROR                    VALUE 'N'.         
               88 SEND-DONE-OK                       VALUE 'Y'.         
           05 WS-LOAD-STMT-CHRG-SW         PIC X(01) VALUE 'N'.         
           05  WS-OK-TO-PROCESS-FL         PIC X(1)  VALUE 'N'.         
               88 PROCESS-OK-YES                     VALUE 'Y'.         
           05  WS-PL-MATCH-FOUND           PIC X(1)  VALUE 'N'.         
           05  WS-HOLD-STMT-SUB            PIC 9(3)  VALUE 0.           
A04149     05  WS-CA158-SUB                PIC 9(3)  VALUE 0.           
A04149     05  WS-BILL-NO                  PIC S9(09) VALUE 0 COMP-3.   
           05  WS-PL-SUB                   PIC 9(3)  VALUE 0.           
           05  WS-SUB                      PIC 9(3)  VALUE 0.           
           05  WS-SUB1                     PIC 9(3)  VALUE 0.           
           05  WS-NULL-IND-1               PIC S9(04) COMP.             
           05  WS-NULL-IND-2               PIC S9(04) COMP.             
           05  WS-END-NULL-IND             PIC S9(04) COMP.             
           05  WS-RED-FL-NULL-IND          PIC S9(04) COMP.             
           05  WS-ROW-COUNT                PIC S9(09) COMP.             
           05  WS-TRAN-APPL-NO             PIC S9(02)  VALUE +1.        
           05  WS-AR-ACTIVE-RETURN-CODE    PIC S9(4)  COMP.             
           05  WS-PREMISE-NO               PIC X(10).                   
           05  WS-COMPANY-NO               PIC 9(02).                   
           05  WS-ACCOUNT-NO               PIC 9(13) VALUE ZERO.        
           05  WS-ACCOUNT-NO-CHAR REDEFINES WS-ACCOUNT-NO               
                                           PIC X(13).                   
           05  WS-BILL-NO-CHAR             PIC X(04).                   
P00821     05  WS-BILL-NUM                 PIC 9(04) VALUE 0.           
P00821     05  WS-CUTOFF-CNT               PIC 9(03) VALUE ZERO.        
P00821     05  WS-BILL-MSG-ID              PIC X(05) VALUE SPACES.      
           05  WS-FORMAT-MESSAGE           PIC X(26).                   
           05  WS-FORMAT-USAGE             PIC -Z(8)9.                  
           05  WS-FORMAT-TYPE              PIC X(06).                   
           05  WS-FORMAT-DAYS              PIC Z(2)9.                   
           05  WS-DISPLAY-SCSCA            PIC X(08).                   
           05  WS-DISPLAY-SQLCODE          PIC -ZZZZZZZZ9.              
           05  S-RETURN-CODE               PIC S9(9) COMP VALUE 0.      
ACT059     05  WS-END-FLAG                 PIC X(01) VALUE 'Y'.         
ACT059     05  WS-START-FLAG               PIC X(01) VALUE 'Y'.         
ACT059     05  WS-DEFAULT-SEQ-NO           PIC X(26) VALUE              
               '0001-01-01-00.00.00.000000'.                            
           05  SW-FETCH                    PIC X(01) VALUE 'Y'.         
               88 NO-MORE-ROWS                       VALUE 'N'.         
               88 MORE-ROWS                          VALUE 'Y'.         
           05  WS-CURRENT-DATE             PIC X(10).                   
A04149     05  WS-CURR-SEQ-NO              PIC  X(26).                  
COB305     05 WS-AMT-EPP-ADJ-HOLD        PIC S9(09)V99 COMP-3 VALUE 0.        
COB305     05 WS-AMT-EPP-CIA-HOLD        PIC S9(09)V99 COMP-3 VALUE 0.        
A04149     05  WS-EPP-ANNIV-MTH-SW         PIC X(01) VALUE 'N'.         
A04149         88 EPP-ANNIV-MTH            VALUE 'Y'.                   
A04149     05  WS-HOLD-GL-ACCOUNT          PIC  9(03)V9(4).             
A04149     05  WS-HOLD-PROCESS-FLAG        PIC X  VALUE 'N'.            
A04149     05  WS-HOLD-TRANS-TYPE          PIC X VALUE SPACES.          
A04149     05  WS-HOLD-CONTRACT-MSG        PIC X(50) VALUE SPACES.      
A04149     05  WS-DISPLAY-ACCOUNT          PIC 9(13).                   
A04149     05  WS-DISPLAY-ACCOUNT-D        PIC 9/9999/9999/9999.        
COB305     05 WS-ACCOUNT-NO-SEARCH        PIC S9(13) COMP-3 VALUE 0.           
A04149     05  WS-CNT-SUB                  PIC S9(04) VALUE ZERO.       
COB305     05 WS-XFER-DFA        PIC S9(9)V99 COMP-3 VALUE 0.         
A04149     05  WS-DATE-CAN-BILL            PIC X(10).                   
A04149     05  WS-HOLD-APPL-PGM-ID         PIC X(09).                   
COB305     05 WS-BILL-MESSAGE        PIC S9(05) COMP-3 VALUE 0.           
COB305     05 WS-MSG-INDX        PIC S9(05) COMP-3 VALUE 0.          
A04149     05  WS-HOLD-CNT-ITEM-ID-CT      PIC S9(09) VALUE ZERO.       
A04149     05  WS-CA167-CALL-SW            PIC X(1).                    
A04149         88  CA167-CALL               VALUE 'Y'.                  
A04557     05  WS-CNT-NAME-DESC            PIC X(30).                   
A04557         88 SUBORDINATE-FEE          VALUE                        
A04557            'Subordination Fee             '.                     
A04557     05  WS-SUBORD-FEE-SW            PIC X(01) VALUE 'N'.         
A04557         88 SUBORD-FEE               VALUE 'Y'.                   
           05  WS-HOLD-BILL-LITERAL        PIC X(50).                   
           05  WS-HOLD-DATE-BILLED         PIC X(10).                   
           05  FILLER REDEFINES WS-HOLD-DATE-BILLED.                    
               10 WS-HOLD-DATE-CCYY        PIC X(4).                    
               10 WS-HOLD-DASH1            PIC X(1).                    
               10 WS-HOLD-DATE-MM          PIC X(2).                    
               10 WS-HOLD-DASH2            PIC X(1).                    
               10 WS-HOLD-DATE-DD          PIC X(2).                    
           05  WS-HOLD-STMT-BILL-DATE      PIC X(10).                   
           05  FILLER REDEFINES WS-HOLD-STMT-BILL-DATE.                 
               10 WS-HOLD-STMT-DATE-MM     PIC X(2).                    
               10 FILLER                   PIC X(1).                    
               10 WS-HOLD-STMT-DATE-DD     PIC X(2).                    
               10 FILLER                   PIC X(1).                    
               10 WS-HOLD-STMT-DATE-CCYY   PIC X(4).                    
           05  WS-HOLD-DATE.                                            
               10 WS-HOLD-YY               PIC X(2).                    
               10 WS-HOLD-MM               PIC X(2).                    
               10 WS-HOLD-DD               PIC X(2).                    
           05 WS-ENGLISH-DATE.                                          
              10  WS-ENGLISH-MM            PIC X(9).                    
              10  WS-ENGLISH-DD            PIC X(2).                    
              10  F                        PIC X(2) VALUE ', '.         
              10  WS-ENGLISH-YY            PIC X(4).                    
           05 WS-INITIAL-COMM-TX.                                       
              10 WS-INITIAL-COMM-TX-LEN    PIC S9(4) USAGE COMP.        
              10 WS-INITIAL-COMM-TX-TEXT   PIC X(255).                  
           05  WS-INIT-COMMENTS-LEN      PIC S9(4) USAGE COMP VALUE +78.
           05  WS-INIT-COMMENTS-TEXT.                                   
               10 FILLER                   PIC X(42) VALUE              
                  'Statement generated. Statement dates from '.         
               10 WS-INIT-COMM-ENG-MTH     PIC X(9).                    
               10 FILLER                   PIC X(01) VALUE SPACES.      
               10 WS-INIT-COMM-CCYY        PIC X(4).                    
               10 FILLER                   PIC X(22) VALUE              
                  ' thru last bill date. '.                             
A04127     05 WS-ALOC-ITPA-PROCESS         PIC X(01).                   
      *                                                                 01970000
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME                PIC X(08) VALUE 'PCSCA293'.  
           05  SCSCA165                    PIC  X(08) VALUE 'SCSCA165'. 
A04149     05  SCSCA158                    PIC  X(08) VALUE 'SCSCA158'. 
           05  WS-COMMON-DATE              PIC X(10) VALUE 'COMMONDATE'.
P00836     05  WS-FORMAT-DATE.                                          
P00836         10 WS-MONTH                 PIC X(02) VALUE SPACES.      
P00836         10 FILLER                   PIC X(01) VALUE '/'.         
P00836         10 WS-DATE                  PIC X(02) VALUE SPACES.      
P00836         10 FILLER                   PIC X(01) VALUE '/'.         
P00836         10 WS-YEAR                  PIC X(04) VALUE SPACES.      
           05  WS-Y                        PIC X(01) VALUE 'Y'.         
           05  WS-HOLD-PREV-BILL           PIC X(25) VALUE              
               'Previous Bill Amount     '.                             
           05  WS-HOLD-PAYMENT-RECVD       PIC X(25) VALUE              
               'Payment(s) Received      '.                             
           05  WS-HOLD-ELEC-CHARGES        PIC X(25) VALUE              
               'Electric Charges         '.                             
           05  WS-HOLD-GAS-CHARGES         PIC X(25) VALUE              
               'Gas Charges              '.                             
           05  WS-HOLD-UNMTR-CHARGES       PIC X(25) VALUE              
               'Lighting Charges         '.                             
A04149     05  WS-DATABASE-EXCEPTION.                                   
A04149         10  FILLER                  PIC S9(04) COMP VALUE +121.  
A04149         10  FILLER                  PIC  X(01) VALUE 'N'.        
A04149         10  FILLER                  PIC  X(01) VALUE '4'.        
A04149         10  FILLER                  PIC S9(04) COMP VALUE +29.   
A04149         10  FILLER                  PIC  X(30) VALUE             
A04149             'A DATABASE EXCEPTION OCCURRED'.                     
ACT060     05  WS-DFLT-NO-OF-BILLS         PIC 9(02) VALUE 13.          
P00821     05  WS-12                       PIC 9(02) VALUE 12.          
P00821     05  WS-12MNTH-STMNT             PIC X(05) VALUE 'STM12'.     
P00821     05  WS-12MNTH-E-STMNT           PIC X(05) VALUE 'ST12E'.     
P00836     05  WS-24MNTH-E-STMNT           PIC X(05) VALUE 'ST24E'.     
      *                                                                 02250000
P00821 01  WS-REVENUE-MONTH-FIELDS.                                     
P00821     05  WS-CUTOF-REV-MNTH           PIC S9(6).                   
P00821     05  WS-CUTOF-REV-MNTH-RED  REDEFINES WS-CUTOF-REV-MNTH.      
P00821         10  WS-CUTOF-REV-MNTH-YY    PIC 9(04).                   
P00821         10  WS-CUTOF-REV-MNTH-MM    PIC 9(02).                   
      *                                                                 02310000
       01  WS-MAILING-ADDR.                                             
         03 WS-MAILING-ENTRY OCCURS 6 TIMES.                            
           05  WS-MAILING-TYPE             PIC X(02).                   
           05  WS-MAILING-ADDRESS          PIC X(50).                   
      *                                                                 02360000
       01  WS-MISC-VARIABLES.                                           
           05  WS-SCSCA-RETURN-CODE        PIC S9(4) COMP.              
           05  WS-YEAR-FLAG                PIC X(01) VALUE SPACES.      
               88 CURRENT-YR                         VALUE 'Y'.         
               88 PREVOUS-YR                         VALUE 'N'.         
           05  WS-START-DATE               PIC X(10).                   
           05  WS-END-DATE                 PIC X(10).                   
           05  WS-ENDING-DATE              PIC X(10).                   
           05  WS-STARTING-DATE            PIC X(10).                   
           05  WS-DATE-TRANS-SEARCH        PIC X(10).                   
           05  WS-PREV-DATE-TRANS          PIC X(10).                   
           05  WS-CURR-HST-SEQ-NO          PIC X(26).                   
           05  WS-PREV-HST-SEQ-NO          PIC X(26).                   
COB305     05 WS-PREV-BILL-UNPAID        PIC S9(09)V99 COMP-3 VALUE 0.        
           05  WS-START-POS                PIC S9(4) COMP.              
           05  WS-PULL-CODE-FL             PIC X(01) VALUE SPACES.      
           05  WS-HOLD-PULL-CODE           PIC X(01) VALUE SPACES.      
COB305     05 WS-HOLD-SUM-AMT        PIC S9(09)V99 COMP-3 VALUE 0.        
           05  WS-HOLD-CUST-NAME           PIC X(50) VALUE SPACES.      
           05  WS-HOLD-CHG-MSG             PIC X(50).                   
COB305     05 WS-HOLD-CHG-AMT        PIC S9(09)V99 COMP-3 VALUE 0.        
           05  WS-DEBIT-GL-NAME            PIC X(10).                   
           05  WS-CREDIT-GL-NAME           PIC X(10).                   
           05  WS-CREDIT-AR-SW             PIC X(01) VALUE ' '.         
           05  WS-DEBIT-AR-SW              PIC X(01) VALUE ' '.         
A04149     05  WS-AR-TRAN-EXCESS-MSG       PIC X(01) VALUE 'N'.         
           05  WS-PROCESS-FURTHER-SW       PIC X(01) VALUE ' '.         
COB305     05 WS-HOLD-GL-ACCT        PIC S9(3)V9(4) USAGE COMP-3 
COB305       VALUE 0. 
           05  WS-HOLD-GL-NAME             PIC X(10).                   
           05  WS-HOLD-GL-CLASS            PIC X(01).                   
           05  WS-GL-CREDIT-NAME           PIC X(10).                   
           05  WS-GL-CREDIT-CLASS          PIC X(01).                   
           05  WS-GL-DEBIT-NAME            PIC X(10).                   
           05  WS-GL-DEBIT-CLASS           PIC X(01).                   
           05  WS-END-ON-CYCLE-SW          PIC X(01).                   
               88  WS-END-ON-CYCLE           VALUE 'Y'.                 
           05  WS-AMOUNT-PREPAY            PIC S9(9)V99 VALUE ZERO.     
COB305     05 WS-PJS-PREPAY        PIC S9(9)V99 COMP-3 VALUE 0.         
COB305     05 WS-DEPOSIT-PREPAY        PIC S9(9)V99 COMP-3 VALUE 0.         
COB305     05 WS-CONTRACT-PREPAY        PIC S9(9)V99 COMP-3 VALUE 0.         
           05  WS-CONTRACT-CREDIT          PIC S9(9)V99 VALUE ZERO.     
COB305     05 WS-GAS-SERVICE-CHARGE        PIC S9(9)V99 COMP-3 VALUE 0.         
COB305     05 WS-PNC-SERVICE-CHARGE        PIC S9(9)V99 COMP-3 VALUE 0.         
COB305     05 WS-CONTRACT-INTEREST        PIC S9(9)V99 COMP-3 VALUE 0.         
COB305     05 WS-CONTRACT-PRINCIPAL        PIC S9(9)V99 COMP-3 VALUE 0.         
COB305     05 WS-XFER-REFUND-AMT        PIC S9(9)V99 COMP-3 VALUE 0.         
COB305     05 WS-XFER-CONTRACT        PIC S9(9)V99 COMP-3 VALUE 0.         
COB305     05 WS-XFER-CIA        PIC S9(9)V99 COMP-3 VALUE 0.         
COB305     05 WS-XFER-DEP        PIC S9(9)V99 COMP-3 VALUE 0.         
           05  WS-HOLD-GL-ACCOUNT-CREDIT   PIC  9(03)V9(4).             
           05  WS-HOLD-GL-ACCOUNT-DEBIT    PIC  9(03)V9(4).             
           05  WS-HOLD-AR-AMT-ORIG-ENTERED PIC S9(9)V9(2) VALUE ZERO.   
COB305     05 WS-RECONNECT        PIC S9(9)V99 COMP-3 VALUE 0.         
           05  WS-RETURN-CHECK-FIELDS.                                  
               10  WS-CHECK-OR-DRAFT       PIC X.                       
               10  WS-RETURN-CHECK         PIC X.                       
               10  WS-RETURN-CHECK-CHARGE  PIC X.                       
COB305         10 WS-CHECK-AMT        PIC S9(9)V99 COMP-3 VALUE 0.         
COB305         10 WS-CHARGE-AMT        PIC S9(9)V99 COMP-3 VALUE 0.         
           05  WS-CHECK-GL-ACCT            PIC X(10).                   
               88  WS-AR-ACCOUNT             VALUES ARE 'AR-LPC'        
                                  'AR-LPN' 'AR-PJS' 'AR-UTE' 'AR-UTG'   
                                  'AR-BUD' 'AR-CCC' 'AR-DFA' 'AR-CIA'   
                                  'AR-DEP' 'AR-CNT' 'AR-NSA' 'AR-NSN'   
                                  'AR-NSC'.                             
               88  WS-AR-ACCOUNT-LESS-DEP    VALUES ARE 'AR-LPC'        
                                  'AR-LPN' 'AR-PJS' 'AR-UTE' 'AR-UTG'   
                                  'AR-BUD' 'AR-CCC' 'AR-DFA' 'AR-CIA'   
                                  'AR-CNT' 'AR-NSA' 'AR-NSN' 'AR-NSC'.  
               88  WS-TAX-ACCOUNT            VALUES ARE 'TAX-SCGAS'     
                               'TAX-SCCNG' 'TAX-FEDCNG' 'TAX-STAT'      
                               'TAX-OTHER'.                             
               88  WS-PREPAY-ACCOUNT         VALUES ARE 'AR-CNT'        
                               'AR-CCC' 'AR-NSC' 'AR-NSN' 'AR-NSA'.     
               88  WS-RETURN-CHECK-ACCOUNT   VALUES ARE 'AR-NSA'        
                                                        'AR-NSN'.       
               88  WS-CHECK-CHARGE-ACCOUNT   VALUE IS 'AR-NSC'.         
           05  WS-STMT-HDR-TIE-BRKR       PIC 9(04).                    
           05  WS-STMT-DET-TIE-BRKR        PIC 9(04).                   
           05  WS-STMT-CHG-TIE-BRKR        PIC 9(04).                   
      *                                                                 03170000
       01  WS-PROGRAM-LITERAL-TABLE.                                    
           05  F                        PIC X(45) VALUE                 
           'APANEL102BContract Set Up                    '.             
           05  F                        PIC X(45) VALUE                 
           'IPANEL102BApply Contract Rebate              '.             
           05  F                        PIC X(45) VALUE                 
           'SPANEL102FCancel Contract Rebate             '.             
           05  F                        PIC X(45) VALUE                 
           'APANEL102FCancel Contract                    '.             
           05  F                        PIC X(45) VALUE                 
           'DPANEL147 Budget Billing Setup Adjustment    '.             
           05  F                        PIC X(45) VALUE                 
           'APANEL147 Budget Billing Amount              '.             
           05  F                        PIC X(45) VALUE                 
           'APANEL147BBudget Billing Deletion            '.             
           05  F                        PIC X(45) VALUE                 
           'DPANEL147BBal After Budget Billing Deletion  '.             
           05  F                        PIC X(45) VALUE                 
           'APANEL163DRemoval from Installment Plan      '.             
           05  F                        PIC X(45) VALUE                 
           'DPANEL163DInstallment Plan Balance           '.             
           05  F                        PIC X(45) VALUE                 
           'DPANEL164SDPP Contract Amount                '.             
           05  F                        PIC X(45) VALUE                 
           'APANEL164SEarnest Amount Due                 '.             
           05  F                        PIC X(45) VALUE                 
           'CPANEL373 Payment Reversal                   '.             
           05  F                        PIC X(45) VALUE                 
           'PPANEL373 Payment Correction                 '.             
           05  F                        PIC X(45) VALUE                 
           'APCSSO62C Budget Billing Adjustment          '.             
           05  F                        PIC X(45) VALUE                 
           'DPCSSO62C Budget Billing Balance Forward     '.             
           05 F                         PIC X(45) VALUE                 
           'PCIGPAYMNTPayment Thank You                  '.             
           05 F                         PIC X(45) VALUE                 
           'SCIGPAYMNTMiscellaneous Debit                '.             
           05 F                         PIC X(45) VALUE                 
           'ICIGCSHREFRefund Credit                      '.             
           05 F                         PIC X(45) VALUE                 
           'SCIGCSHREFRefund Charge                      '.             
A04149     05  WS-BAD-AR-TRN-MSG.                                       
A04149         10  F                       PIC X(70) VALUE              
A04149             'TOO MANY AR TRANS TO PRINT ON BILL PLEASE CHECK BILL03610000
A04149-    ' ACCURACY-ACCOUNT '.                                        03620000
A04149         10  WS-BAD-TRN-ACCOUNT      PIC 9(13).                   
T21495     05  WS-BAD-CNT-DESC-MSG.                                     
T21495         10  F                       PIC X(47) VALUE              
T21495             'CONTRACT DESCRIPTION NOT FOUND FOR CNT-NAME-CD '.   
T21495         10  WS-BAD-CNT-NAMECD       PIC 9(03).                   
       01  WS-PROGRAM-LITERALS REDEFINES WS-PROGRAM-LITERAL-TABLE.      
           05  WS-PL-LINE OCCURS 20.                                    
               10  WS-PL-TRANS-TYPE         PIC X.                      
               10  WS-PL-PROGRAM-ID         PIC X(9).                   
               10  WS-PL-BILL-LITERAL       PIC X(35).                  
      *                                                                 03730000
       01 WS-APPL-PGM-DESC-TABLE.                                       
           05  WS-APPL-PGM-DESC-LINE OCCURS 1000.                       
               10  WS-APPL-PROGRAM-ID        PIC X(09).                 
               10  WS-APPL-PROGRAM-DESC      PIC X(20).                 
               10  WS-BILL-PRINT-DESC        PIC X(50).                 
           05  WS-APPL-SUB                   PIC 9999.                  
           05  WS-APPL-MATCH                 PIC X.                     
      *                                                                 03810000
       01  WS-EXT-IO-AREA.                                              
           05  SORT-KEY.                                                
               10  LEVEL-1-SORT-FLDS.                                   
                   15  KEY-L1-COMP-NO              PIC 9(2).            
               10  LEVEL-2-SORT-FLDS.                                   
                   15  KEY-L2-ACCOUNT-NO           PIC X(13).           
                   15  KEY-L2-DATE-BILLED          PIC X(10).           
               10  LEVEL-3-SORT-FLDS.                                   
                   15  KEY-L3-REC-SEQ              PIC X(3).            
                   15  KEY-L3-RECORD-ID            PIC X(10).           
                   15  KEY-L3-TIE-BREAKER          PIC 9(4).            
               10  LEVEL-4-SORT-FLDS.                                   
                   15  KEY-L4-SUB-ACCOUNT          PIC X(13).           
                   15  KEY-L4-SUB-SORT-FIELDS      PIC X(10).           
                   15  FILLER                      REDEFINES            
                       KEY-L4-SUB-SORT-FIELDS.                          
                       20  KEY-L4-SUB-DATE-BILLED  PIC X(06).           
                       20  KEY-L4-TIE-BREAKER      PIC 9(04).           
           05  WS-BILL-DATA                        PIC X(1135).         
A04149 01  WS-WQ-CREATED-SW            PIC X(01).                       
A04149*                                                                 04020000
A04149 COPY CWS00158.                                                   04030000
      *                                                                 04040000
       01  WS-BILL-WORK-AREA.                                           
       COPY FIOEXT01.                                                   04060000
       COPY FIOEXT02.                                                   04070000
       COPY FIOEXT80.                                                   04080000
       COPY FIOEXT81.                                                   04090000
       COPY FIOEXT82.                                                   04100000
       COPY FIOEXT83.                                                   04110000
       COPY FIOEXTID.                                                   04120000
      *  COPY BOOK FIELDS TO REDUCE EMBEDDED BLANKS                     04130000
       COPY CWS00023.                                                   04140000
      *  DCLGEN FOR SQL COMM AREA                                       04150000
           EXEC SQL                                                     04160000
                INCLUDE SQLCA                                           04170000
           END-EXEC.                                                    04180000
      *  DCLGEN FOR CSS_ACCOUNT                                         04190000
           EXEC SQL                                                     04200000
               INCLUDE TBACCT                                           04210000
           END-EXEC.                                                    04220000
      *  DCLGEN FOR CSS_JOB_PARM                                        04230000
           EXEC SQL                                                     04240000
               INCLUDE TBJBPARM                                         04250000
           END-EXEC.                                                    04260000
      *  DCLGEN FOR CSS_GL_ACCT_NO                                      04270000
           EXEC SQL                                                     04280000
               INCLUDE TBGLATNO                                         04290000
           END-EXEC.                                                    04300000
      *  DCLGEN FOR CSS_APPL_PGM_DESC                                   04310000
           EXEC SQL                                                     04320000
               INCLUDE TBPGMDSC                                         04330000
           END-EXEC.                                                    04340000
      *  DCLGEN FOR CSS_AR_TRANS_HIST                                   04350000
           EXEC SQL                                                     04360000
               INCLUDE TBARHIST                                         04370000
           END-EXEC.                                                    04380000
      *  DCLGEN FOR CSS_AR_TRN_HST_DET                                  04390000
           EXEC SQL                                                     04400000
               INCLUDE TBARHDT                                          04410000
           END-EXEC.                                                    04420000
      *  DCLGEN FOR CSS_BILLING_DET                                     04430000
           EXEC SQL                                                     04440000
               INCLUDE TBBLLDET                                         04450000
           END-EXEC.                                                    04460000
      * CSS_COMM_DATA - KO                                              04600000
      *                                                                 04610000
           EXEC SQL                                                     04620000
              INCLUDE TBCOMDAT                                          04630000
           END-EXEC.                                                    04640000
      *                                                                 04650000
      *                                                                 04650100
      * DCLGEN TABLE CSS_CORR_MAIL_STAT - MW                            04650200
      *                                                                 04650300
           EXEC SQL                                                     04650400
              INCLUDE TBMAILST                                          04650500
           END-EXEC.                                                    04650600
                                                                        
      * DCLGEN TABLE CSS_DELINQUENCY                                    04720000
           EXEC SQL                                                     04730000
                INCLUDE TBDELQ                                          04740000
           END-EXEC.                                                    04750000
A04149* DECLARE CSS_CONTRACT - CT                                       04760000
A04149     EXEC SQL                                                     04770000
A04149          INCLUDE TBCNTRCT                                        04780000
A04149     END-EXEC.                                                    04790000
A04149* DECLARE CSS_CONTRACT_INFO - K6                                  04800000
A04149     EXEC SQL                                                     04810000
A04149          INCLUDE TBCNTINF                                        04820000
A04149     END-EXEC.                                                    04830000
      * CSS_MNT_TRANS_HIST - MH                                       * 04840000
      *                                                                 04850000
           EXEC SQL                                                     04860000
             INCLUDE TBMNHIST                                           04870000
           END-EXEC.                                                    04880000
      *                                                                 04890000
P00836*  CSS_BATCH_EMAIL - AE                                           04900000
P00836*                                                                 04901000
P00836     EXEC SQL                                                     04910000
P00836         INCLUDE TBBEMAIL                                         04920000
P00836     END-EXEC.                                                    04930000
P00836*                                                                 04940000
P00836* CSS_BTCH_EMAIL_DET - JK                                         04950000
P00836*                                                                 04960000
P00836     EXEC SQL                                                     04970000
P00836         INCLUDE TBBTEDET                                         04980000
P00836     END-EXEC.                                                    04990000
      *                                                                 05000000
      ***************************************************************** 05010000
      * CSS_MT_TRN_HST_DET - MI                                       * 05020000
      ***************************************************************** 05030000
      *                                                                 05040000
           EXEC SQL                                                     05050000
             INCLUDE TBMNHDT                                            05060000
           END-EXEC.                                                    05070000
      *                                                                 05080000
      *    COPYBOOK FOR SCSCA165 PARAMETERS                             05090000
           EXEC SQL                                                     05100000
               INCLUDE CWSCA165                                         05110000
           END-EXEC.                                                    05120000
      *                                                                 05130000
      * SCSCA184 PARMS                                                  05140000
           COPY CWSCA184.                                               05150000
           COPY CWS00010.                                               05160000
      * COPY BOOK TO FORMAT DATA FOR STREAMLINE CUSTOMER STATEMENT.     05170000
           COPY CWS00293.                                               05180000
      *                                                                 05190000
      * SUPPORTS DB2 AND SQL ERROR CHECKING                             05200000
           COPY CWS00303.                                               05210000
      *                                                                 05220000
      ***************************************************************** 05230000
      *  THIS COPYBOOK IS USED WITH THE CPD09900 INCLUDE MEMBER       * 05240000
      *  WHICH INVOKES THE ABEND ROUTINE                              * 05250000
      ***************************************************************** 05260000
       COPY CWS09900.                                                   05270000
      *   COPYBOOK TO LOAD GL NUMBER/NAME/DESCRIPTION                 * 05280000
       COPY CWS00096.                                                   05290000
      ***************************************************************** 05300000
      *   SUPPLEMENTAL WQ TEXT                                        * 05310000
      ***************************************************************** 05320000
       COPY CWS0070B.                                                   05330000
A04149 COPY CWS1000B.                                                   05340000
A04149 COPY CWS1000C.                                                   05350000
A04149 COPY CWS10017.                                                   05360000
A04149 COPY CWS0024B.                                                   05370000
A04149 COPY CWS1000A.                                                   05380000
A04149 COPY CWS1001A.                                                   05390000
A04149 COPY CWS1001B.                                                   05400000
      *                                                                 05410000
       01  WS-END                         PIC X(40)                     
           VALUE 'WORKING STORAGE FOR PCSCA293 ENDS HERE  '.            
HPCCDM*    EJECT                                                        05440000
      *                                                                 05450000
           EXEC SQL                                                     
               DECLARE GL_NAME CURSOR FOR                               
P00641             SELECT GL_ACCT_NAME,                                 
P00641                    GL_ACCT_NAME_DESC,                            
P00641                    GL_ACCT_NO,                                   
P00641                    GL_ACCT_CLASS                                 
P00641             FROM CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                    
                   ORDER BY GL_ACCT_NO                                  
A04149                                                           
A04149                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05460000
MFA-TR*        DECLARE GL_NAME CURSOR FOR                               05470000
MFA-TR*            SELECT GL_ACCT_NAME,                                 05480000
MFA-TR*                   GL_ACCT_NAME_DESC,                            05490000
MFA-TR*                   GL_ACCT_NO,                                   05500000
MFA-TR*                   GL_ACCT_CLASS                                 05510000
MFA-TR*            FROM CSS_GL_ACCT_NO                                  05520000
MFA-TR*            ORDER BY GL_ACCT_NO                                  05530000
MFA-TR*            WITH UR                                              05540000
MFA-TR*            QUERYNO 7000                                         05550000
MFA-TR*    END-EXEC.                                                    05560000
      *                                                                 05570000
           EXEC SQL                                                     
               DECLARE APPL_PGM_DESC CURSOR FOR                         
                   SELECT APPL_PROGRAM_ID,                              
                          APPL_PROGRAM_DESC,                            
                          BILL_PRINT_DESC                               
                     FROM CSS_APPL_PGM_DESC WITH(READUNCOMMITTED)               
                    WHERE BILL_PRINT_DESC > ' '                         
A04149                                                           
A04149                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05580000
MFA-TR*        DECLARE APPL_PGM_DESC CURSOR FOR                         05590000
MFA-TR*            SELECT APPL_PROGRAM_ID,                              05600000
MFA-TR*                   APPL_PROGRAM_DESC,                            05610000
MFA-TR*                   BILL_PRINT_DESC                               05620000
MFA-TR*              FROM CSS_APPL_PGM_DESC                             05630000
MFA-TR*             WHERE BILL_PRINT_DESC > ' '                         05640000
MFA-TR*             WITH UR                                             05650000
MFA-TR*             QUERYNO 7600                                        05660000
MFA-TR*    END-EXEC.                                                    05670000
      *                                                                 05680000
A04149******   CURSOR DECLARATION FOR COPY BOOK CPDCA167.               05690000
A04149     EXEC SQL                                                     05700000
A04149          INCLUDE CWSCA167                                        05710000
A04149     END-EXEC.                                                    05720000
                                                                        
       PROCEDURE DIVISION.                                              
      *================================================================*05750000
       0000-MAINLINE.                                                   
      *================================================================*05770000
      *                                                                 05780000
           DISPLAY 'PCSCA293 - STREAMLINE CUSTOMER STATEMENT'.          
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 0150-GET-COMMON-DATE       THRU 0150-EXIT.           
           MOVE G6-PARM-DATA             TO WS-CURRENT-DATE.            
      *                                                                 05830000
           PERFORM 7900-READ-INPUT            THRU 7900-EXIT.           
           INITIALIZE WS-CA165-CALLING-FIELDS.                          
      ***  OBTAIN BG ROWS FOR 25 MONTHS                           ****  05860000
           PERFORM 1000-PROCESS-CONS-STMT     THRU 1000-EXIT UNTIL      
                   END-OF-CA293.                                        
      *******UPDATE CSS_JOB_PARM WITH LATEST SEQUENCE NBR GENERATED     05890000
           IF UNIQ-GENERATED AND                                        
              WS-CA165IN-OK-TO-PROCESS = 'Y'                            
              MOVE    'Y'                    TO                         
                                             WS-CA165IN-END-OF-PROG-FL  
              PERFORM 5100-CALL-SCSCA165     THRU 5100-EXIT             
           END-IF.                                                      
           PERFORM 9000-TERMINATE             THRU 9000-EXIT.           
           STOP RUN.                                                    
      *                                                                 05980000
       0000-EXIT.                                                       
            GOBACK.                                                     
HPCCDM*     EJECT                                                       06010000
      *                                                                 06020000
      ******************************************************************06030000
      * INITIALIZATION                                                 *06040000
      ******************************************************************06050000
       0100-INITIALIZE.                                                 
      *                                                                 06070000
ACT059     INITIALIZE WS-MISC-VARIABLES                                 
A04149                WS-ACCOUNT-AT.                                    
           MOVE 1                      TO WS-STMT-SUB                   
A04149                                    WS-BILL-NO                    
                                          WS-STMT-IC-SUB                
                                          WS-STMT-CHG-SUB.              
A04149     MOVE 'N'                    TO WS-CA167-CALL-SW.             
                                                                        
           OPEN INPUT FCSCA293-FILE.                                    
           IF NOT FCA293-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR OPENING FCSCA293          **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA293-STATUS            
               DISPLAY '**************************************'         
A04149         PERFORM 9905-ABEND THRU 9905-EXIT
           END-IF.                       
                                                                        
           OPEN OUTPUT FCSBE293-FILE.                                   
           IF NOT FBE293-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR OPENING FCSBE293          **'         
               DISPLAY '**  FILE STATUS = ' WS-FBE293-STATUS            
               DISPLAY '**************************************'         
A04149         PERFORM 9905-ABEND THRU 9905-EXIT                        
           END-IF.                                                      
                                                                        
           PERFORM 0110-GET-GL-ACCT       THRU 0110-EXIT.               
           PERFORM 0125-GET-APPL-PGM-DESC THRU 0125-EXIT.               
      *                                                                 06370000
   ******GET WHICH DATABASE WE ARE DEALING WITH                         06380000
                                                                        
           MOVE 'DATABASE'                     TO C8-DELINQ-CD.         
           MOVE '01'                           TO C8-COMPANY-NO.        
           PERFORM 7030-GET-DATABASE           THRU 7030-EXIT.          
           MOVE C8-DELINQ-VALUE                TO LS-DATABASE.          
                                                                        
      *                                                                 06450000
       0100-EXIT.                                                       
            EXIT.                                                       
      *                                                                 06480000
       0110-GET-GL-ACCT.                                                
      *                                                                 06500000
           INITIALIZE WS-GL-NAME-TABLE.                                 
           PERFORM 7000-OPEN-GL-NAME   THRU 7000-EXIT.                  
           MOVE 1                      TO WS-GL-SUB1.                   
           PERFORM 0120-GET-GL-DATA THRU 0120-EXIT UNTIL                
                   WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
           PERFORM 7020-CLOSE-GL-NAME  THRU 7020-EXIT.                  
      *                                                                 06570000
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06600000
       0120-GET-GL-DATA.                                                
           PERFORM 7010-FETCH-GL-NAME  THRU 7010-EXIT.                  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00641        MOVE GO-GL-ACCT-NAME      TO WS-GL-NAME (WS-GL-SUB1)      
P00641        MOVE GO-GL-ACCT-NAME-DESC TO WS-GL-DESC (WS-GL-SUB1)      
              MOVE GO-GL-ACCT-NO        TO WS-GL-ACCT (WS-GL-SUB1)      
              MOVE GO-GL-ACCT-CLASS     TO WS-GL-ACCT-CLASS(WS-GL-SUB1) 
              ADD 1                     TO WS-GL-SUB1                   
           END-IF.                                                      
       0120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06720000
       0125-GET-APPL-PGM-DESC.                                          
      *                                                                 06740000
           INITIALIZE WS-APPL-PGM-DESC-TABLE.                           
           PERFORM 7600-OPEN-APPL-PGM-DESC THRU 7600-EXIT.              
           MOVE 1                      TO WS-APPL-SUB.                  
           PERFORM 0130-APPL-PGM-DESC-DATA THRU 0130-EXIT UNTIL         
                   WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
           PERFORM 7620-CLOSE-APPL-PGM-DESC THRU 7620-EXIT.             
      *                                                                 06810000
       0125-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06840000
       0130-APPL-PGM-DESC-DATA.                                         
           PERFORM 7610-FETCH-APPL-PGM-DESC  THRU 7610-EXIT.            
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE K9-APPL-PROGRAM-ID   TO                              
                   WS-APPL-PROGRAM-ID(WS-APPL-SUB)                      
              MOVE K9-APPL-PROGRAM-DESC TO                              
                   WS-APPL-PROGRAM-DESC(WS-APPL-SUB)                    
              MOVE K9-BILL-PRINT-DESC   TO                              
                   WS-BILL-PRINT-DESC(WS-APPL-SUB)                      
              ADD 1                     TO WS-APPL-SUB                  
           END-IF.                                                      
       0130-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06980000
       0150-GET-COMMON-DATE.                                            
      *                                                                 07000000
           MOVE WS-COMMON-DATE        TO G6-PROGRAM-NAME.               
                                                                        
           EXEC SQL                                                     
              SELECT PARM_DATA                                          
                INTO :G6-PARM-DATA                                      
                FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
              WHERE  PROGRAM_NAME = :G6-PROGRAM-NAME                    
                                                                
A04149                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07030000
MFA-TR*       SELECT PARM_DATA                                          07040000
MFA-TR*         INTO :G6-PARM-DATA                                      07050000
MFA-TR*         FROM CSS_JOB_PARM                                       07060000
MFA-TR*       WHERE  PROGRAM_NAME = :G6-PROGRAM-NAME                    07070000
MFA-TR*       WITH  UR                                                  07080000
MFA-TR*       QUERYNO 0150                                              07090000
MFA-TR*    END-EXEC.                                                    07100000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE            
                                       WS-DISPLAY-SQLCODE.              
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                    DISPLAY '*** PCSCA293:0150          ***'            
                    DISPLAY '*** 0150-GET-COMMON-DATE   ***'            
                    DISPLAY '*** DB2 FUNCTION -  SELECT *** '           
                    DISPLAY '*** SQLCODE      - ' WS-DISPLAY-SQLCODE    
A04149              PERFORM 9905-ABEND     THRU 9905-EXIT               
           END-EVALUATE.                                                
      *                                                                 07240000
       0150-EXIT.                                                       
            EXIT.                                                       
      *                                                                 07270000
       1000-PROCESS-CONS-STMT.                                          
      *                                                                 07290000
           INITIALIZE WS-STREAM-LINE-CUST-BILL                          
                      WS-HOLD-PULL-CODE                                 
                      WS-PULL-CODE-FL                                   
                      WS-HOLD-SUM-AMT                                   
                      WS-TRAN-APPL-NO                                   
                      WS-HOLD-STMT-SUB.                                 
           MOVE  E-FCA293-ACCOUNT-NO           TO WS-ACCOUNT-NO         
                                                  AT-ACCOUNT-NO         
P00821                                            BG-ACCOUNT-NO         
                                                  AR-ACCOUNT-NO         
                                                  AU-ACCOUNT-NO         
A04149                                            WS-STMT-ACCOUNT-NO    
A04149                                            WS-ACCOUNT-NO-AT      
A04149                                            WS-ACCOUNT-NO-SEARCH. 
P00821     MOVE  E-FCA293-BILL-MSG-ID          TO WS-BILL-MSG-ID.       
           MOVE '9999'                         TO WS-BILL-NO-CHAR.      
           MOVE 1                              TO WS-STMT-SUB           
                                                  WS-STMT-IC-SUB.       
           MOVE 1                              TO WS-STMT-SUB           
                                                  WS-STMT-IC-SUB        
                                                  WS-STMT-CHG-SUB.      
           PERFORM 7050-ACCOUNT-DETAILS      THRU 7050-EXIT.            
           MOVE AT-PREMISE-NO                  TO WS-PREMISE-NO.        
           MOVE AT-COMPANY-NO                  TO WS-COMPANY-NO.        
P00821                                                                  
P00821     IF WS-BILL-MSG-ID = WS-12MNTH-STMNT OR WS-12MNTH-E-STMNT     
P00821     AND AT-REV-MTH-LST-NRML > ZERO                               
P00821        MOVE AT-REV-MTH-LST-NRML         TO WS-CUTOF-REV-MNTH     
P00821        MOVE WS-DFLT-NO-OF-BILLS         TO WS-CUTOFF-CNT         
P00821        PERFORM 1320-GET-CUTOFF-REV-MNTH                          
P00821                                       THRU 1320-EXIT             
P00821                UNTIL WS-CUTOFF-CNT = 0                           
P00821        MOVE WS-CUTOF-REV-MNTH           TO BG-REVENUE-MONTH      
P00821        PERFORM 7100-GET-CUTOFF-BILL-NO                           
P00821                                       THRU 7100-EXIT             
P00821     END-IF.                                                      
P00821                                                                  
A04149     PERFORM 2000-CALL-SCSCA158        THRU 2000-EXIT.            
           IF WS-HOLD-STMT-SUB > 24                                     
              COMPUTE WS-HOLD-STMT-SUB = WS-HOLD-STMT-SUB - 1           
           END-IF.                                                      
A04149     PERFORM 1101-GET-BILLED-AR        THRU 1101-EXIT.            
           PERFORM 1200-GET-NAME-ADDRESS     THRU 1200-EXIT.            
           PERFORM 1300-GET-UNIQUE-ID        THRU 1300-EXIT.            
           PERFORM 1350-WRITE-MNT-TRANS      THRU 1350-EXIT.            
A04149     PERFORM 1401-WRITE-COMM-AREA      THRU 1401-EXIT.            
           PERFORM 1500-WRITE-BE293          THRU 1500-EXIT.            
P00836     IF WS-BILL-MSG-ID = WS-24MNTH-E-STMNT OR WS-12MNTH-E-STMNT   
P00836        PERFORM 2400-MOVE-CSS-BATCH-EMAIL      THRU 2400-EXIT     
ACT070        PERFORM 7150-SET-NEXT-VALUE            THRU 7150-EXIT     
P00836        PERFORM 8400-INSERT-CSS-BATCH-EMAIL    THRU 8400-EXIT     
P00836        PERFORM 7200-SELECT-BATCH-EMAIL-ID     THRU 7200-EXIT     
P00836        PERFORM 2600-MOVE-CSS-BTCH-EMAIL-DET   THRU 2600-EXIT     
P00836        PERFORM 8500-INSERT-CSS-BTCH-EMAIL-DET THRU 8500-EXIT     
P00836     END-IF.                                                      
           PERFORM 7900-READ-INPUT           THRU 7900-EXIT.            
      *                                                                 07850000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07880000
      ************************************************************      07890000
      *  1001-INITIALIZE-EXT                                     *      07900000
      ************************************************************      07910000
       1001-INITIALIZE-EXT.                                             
                                                                        
           MOVE LOW-VALUES                 TO LEVEL-4-SORT-FLDS.        
           MOVE SPACE TO  EXT-ACCT-REC                                  
                          EXT-BILL-REC                                  
                          EXT-STMT-HDR-REC                              
                          EXT-STMT-DET-REC                              
                          EXT-CHRG-HDR-REC                              
                          EXT-CHRG-DET-REC.                             
           INITIALIZE     EXT-ACCT-REC                                  
                          EXT-BILL-REC                                  
                          EXT-STMT-HDR-REC                              
                          EXT-STMT-DET-REC                              
                          EXT-CHRG-HDR-REC                              
                          EXT-CHRG-DET-REC.                             
       1001-EXIT.                                                       
           EXIT.                                                        
      *===============================================================* 08090000
      *THIS PARA WILL FETCH THE AR TRANSACTIONS FOR THE BILLED ROW.     08100000
      *===============================================================* 08110000
A04149 1101-GET-BILLED-AR.                                              
      *                                                                 08130000
           PERFORM VARYING WS-STMT-SUB FROM 1 BY 1 UNTIL                
                WS-STMT-SUB = (WS-HOLD-STMT-SUB + 1) OR                 
                WS-STMT-BILL-DATE(WS-STMT-SUB) = SPACES                 
             IF (WS-STMT-TOTAL (WS-STMT-SUB) =                          
                WS-STMT-TOT-BILL-AMT (WS-STMT-SUB)) AND                 
                WS-STMT-OTHR-CHRG (WS-STMT-SUB) = 0 AND                 
                WS-STMT-ARREARS (WS-STMT-SUB) = 0 AND                   
                (WS-STMT-PREV-BILL-AMT (WS-STMT-SUB) -                  
                 WS-STMT-PAYMENTS (WS-STMT-SUB)) = 0                    
                CONTINUE                                                
             ELSE                                                       
                MOVE WS-STMT-ACCOUNT-NO       TO AR-ACCOUNT-NO          
                MOVE WS-STMT-BILL-DATE(WS-STMT-SUB) TO                  
                                                WS-HOLD-STMT-BILL-DATE  
                MOVE WS-HOLD-STMT-DATE-MM     TO WS-HOLD-DATE-MM        
                MOVE WS-HOLD-STMT-DATE-DD     TO WS-HOLD-DATE-DD        
                MOVE WS-HOLD-STMT-DATE-CCYY   TO WS-HOLD-DATE-CCYY      
                MOVE '-'                      TO WS-HOLD-DASH1          
                                                 WS-HOLD-DASH2          
                MOVE WS-HOLD-DATE-BILLED      TO AR-DATE-TRANS          
                                                 WS-DATE-TRANS-SEARCH   
                MOVE 'B'                      TO AR-CODE-TRAN-TYPE      
A04149          PERFORM 6100-GET-BILL-AR-TRANS   THRU 6100-EXIT         
                PERFORM 2500-GET-SINCE-BILL-TRANS THRU 2500-EXIT        
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                 08400000
A04149 1101-EXIT.                                                       
           EXIT.                                                        
      *===============================================================* 08430000
      *THIS PARA WILL FETCH THE NAME AND ADDRESS FROM SCSCA184          08440000
      *===============================================================* 08450000
       1200-GET-NAME-ADDRESS.                                           
      *                                                                 08470000
           INITIALIZE WS-NAME-ADDR-TABLE                                
                      WS-HOLD-CUST-NAME                                 
                      WS-PREMISE-ADDR.                                  
           MOVE E-FCA293-ACCOUNT-NO      TO WS-ACCOUNT-NO-AS.           
           MOVE 'A'                      TO WS-ADDRESS-FLAG.            
           MOVE AT-CUSTOMER-NO           TO WS-CUSTOMER-NO-AS.          
           MOVE AT-ADDRESS-ID            TO WS-ADDRESS-ID-AS.           
           MOVE AT-ADDRESS-FORMAT        TO WS-ADDRESS-FORMAT-AS.       
                                                                        
           DISPLAY 'CALLING SCSCA184 FROM PCSCA293 FOR 'AT-ACCOUNT-NO.  
                                                                        
           CALL 'SCSCA184' USING WS-SCSCA184-PARMS                      
                               WS-MST-SUB-ACCT-IND-AT                   
                               WS-CODE-PRNT-BLL-MST-AT                  
                               WS-CODE-TEMP-BILL-AT                     
                               WS-SCSCA-RETURN-CODE                     
                               LS-CURR-WQ-ITEM                          
                               WS-BILLING-WQ-ITEMS-WF                   
A04127                         WS-ALOC-ITPA-PROCESS.                    
                                                                        
           MOVE 'SCSCA184'               TO WS-DISPLAY-SCSCA.           
                                                                        
           IF WS-SCSCA-RETURN-CODE NOT = 0                              
              PERFORM 9200-SCSCA-ERROR          THRU 9200-EXIT          
           END-IF.                                                      
                                                                        
           MOVE WS-NAME-ADDRESS-TABLE     TO WS-NAME-ADDR-TABLE.        
           MOVE WS-PREMISE-ADDRESS        TO WS-PREMISE-ADDR.           
                                                                        
           PERFORM VARYING WS-SUB FROM 1 BY 1 UNTIL WS-SUB > 6          
              MOVE WS-NAME-ADDR-TYPE (WS-SUB)    TO                     
                   WS-MAILING-TYPE (WS-SUB)                             
              MOVE WS-NAME-ADDR-LINE (WS-SUB)    TO                     
                   WS-MAILING-ADDRESS (WS-SUB)                          
              IF WS-NAME-ADDR-TYPE (WS-SUB) = ('CN' OR 'AN' OR 'AC')    
                 MOVE WS-NAME-ADDR-LINE (WS-SUB) TO WS-HOLD-CUST-NAME   
             END-IF                                                     
           END-PERFORM.                                                 
                                                                        
           PERFORM VARYING WS-SUB FROM 1 BY 1 UNTIL WS-SUB > 6          
             IF WS-MAILING-ADDRESS(WS-SUB) EQUAL TO SPACES              
                COMPUTE WS-SUB1 = WS-SUB + 1                            
                PERFORM VARYING WS-SUB1 FROM WS-SUB1 BY 1               
                                        UNTIL WS-SUB1 > 6               
                   IF WS-MAILING-ADDRESS(WS-SUB1) NOT                   
                                      EQUAL TO SPACES                   
                        MOVE WS-MAILING-TYPE(WS-SUB1) TO                
                             WS-MAILING-TYPE(WS-SUB)                    
                        MOVE WS-MAILING-ADDRESS(WS-SUB1) TO             
                             WS-MAILING-ADDRESS(WS-SUB)                 
                        MOVE SPACES                      TO             
                             WS-MAILING-TYPE(WS-SUB1)                   
                             WS-MAILING-ADDRESS(WS-SUB1)                
                        ADD  +1                   TO WS-SUB             
                   END-IF                                               
                END-PERFORM                                             
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                 09060000
       1200-EXIT.                                                       
           EXIT.                                                        
      *===============================================================* 09090000
      *THIS PARA GET THE UNIQUE ID FOR STATEMENTS PROCESSED.            09100000
      *===============================================================* 09110000
       1300-GET-UNIQUE-ID.                                              
      *                                                                 09130000
           MOVE  ' '                     TO WS-CA165IN-TP-MEMO-PROCESS. 
           MOVE 'BLLPRT'                 TO WS-CA165IN-CORR-TYPE.       
           MOVE AT-ACCOUNT-NO            TO WS-CA165IN-ACCOUNT-NO       
                                            MW-ACCOUNT-NO.              
           MOVE AT-CUSTOMER-NO           TO WS-CA165IN-CUSTOMER-NO.     
           MOVE WS-CURRENT-DATE          TO MW-CREATE-DT                
                                            WS-CA165IN-PROCESS-DATE.    
           MOVE AT-COMPANY-NO            TO WS-CA165IN-COMPANY-NO.      
           MOVE C8-DELINQ-VALUE          TO WS-CA165IN-DATABASE.        
           MOVE SPACES                   TO WS-CA165IN-REG-GROUP-CD.    
           MOVE AT-LOCAL-OFFICE          TO WS-CA165IN-LOCAL-OFFICE.    
           MOVE PROGRAM-NAME             TO WS-CA165IN-APPL-PROGRAM-ID. 
           MOVE  'N'                     TO WS-CA165IN-UPDATE-SEQ-FL    
                                            WS-CA165IN-END-OF-PROG-FL.  
           MOVE  'Y'                     TO WS-UNIQ-GEN-SW.             
           PERFORM 5100-CALL-SCSCA165    THRU 5100-EXIT.                
           MOVE WS-CA165OUT-UNIQ-ID      TO MW-BARCODE-UNIQUE-ID.       
           MOVE WS-CA165OUT-CUR-STATUS   TO MW-TRACKING-STATUS-CD.      
                                                                        
       1300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09350000
P00821******************************************************************09360000
P00821*   THIS ROUTINE WILL GET THE CUTOFF REVENUE MONTH               *09370000
P00821******************************************************************09380000
P00821 1320-GET-CUTOFF-REV-MNTH.                                        
P00821*                                                                 09400000
P00821     SUBTRACT +1     FROM WS-CUTOF-REV-MNTH-MM                    
P00821                          WS-CUTOFF-CNT.                          
P00821                                                                  
P00821     IF WS-CUTOF-REV-MNTH-MM = ZERO                               
P00821        MOVE WS-12                     TO WS-CUTOF-REV-MNTH-MM    
P00821        SUBTRACT +1  FROM WS-CUTOF-REV-MNTH-YY                    
P00821     END-IF.                                                      
P00821*                                                                 09480000
P00821 1320-EXIT.                                                       
P00821     EXIT.                                                        
P00821*                                                                 09510000
       1350-WRITE-MNT-TRANS.                                            
           PERFORM 5200-MOVE-TRAN-HEAD       THRU 5200-EXIT.            
           PERFORM 5300-INSERT-TRAN-HDR-DET  THRU 5300-EXIT.            
       1350-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09570000
A04149 1401-WRITE-COMM-AREA.                                            
           MOVE WS-STMT-BILL-DATE (WS-HOLD-STMT-SUB)                    
                                       TO WS-HOLD-STMT-BILL-DATE.       
           PERFORM 1410-ENGLISH-MONTH  THRU 1410-EXIT.                  
           MOVE 77                     TO WS-EMB-LENG.                  
           MOVE SPACES                 TO WS-EMB-INPUT                  
                                          WS-CMP-TABLE.                 
           MOVE WS-INIT-COMMENTS-TEXT  TO WS-EMB-INPUT.                 
           PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT.          
           MOVE WS-INIT-COMMENTS-LEN   TO WS-INITIAL-COMM-TX-LEN.       
           MOVE WS-CMP-TABLE           TO WS-INITIAL-COMM-TX-TEXT.      
           MOVE AT-ACCOUNT-NO          TO KO-ACCOUNT-NO.                
           MOVE AT-CUSTOMER-NO         TO KO-CUSTOMER-NO.               
           MOVE AT-PREMISE-NO          TO KO-PREMISE-NO.                
           MOVE AT-COMPANY-NO          TO KO-COMPANY-NO.                
           MOVE 'N'                    TO KO-RED-FLAG-IND.              
           MOVE SPACES                 TO KO-RED-FLAG-EXPIRE-DT.        
           MOVE -1                     TO WS-RED-FL-NULL-IND.           
           MOVE 'O'                    TO KO-COMM-METHOD.               
           MOVE 'O'                    TO KO-COMM-DIRECTION.            
           MOVE '46'                   TO KO-COMM-TYPE-CD.              
           MOVE '27'                   TO KO-COMM-SUBTYPE-CODE.         
           MOVE 'SYSTEM'               TO KO-USER-ID-ORIG.              
           MOVE SPACES                 TO KO-CONTACT-NAME.              
           MOVE SPACES                 TO KO-PROMOTION-ID.              
           MOVE 'N'                    TO KO-PSC-COMPLIANCE-IND.        
           MOVE 0                      TO KO-CALL-ORIGIN-ID.            
           MOVE SPACES                 TO KO-CALL-END-TIME.             
           MOVE -1                     TO WS-END-NULL-IND.              
           MOVE 0                      TO KO-NUMBER-TRANSFERS.          
           MOVE 0                      TO KO-HOLD-TIME.                 
           MOVE 0                      TO KO-QUEUE-TIME.                
           MOVE 'N'                    TO KO-SCREEN-POP-IND.            
           MOVE 0                      TO KO-TOTAL-CALL-TIME.           
           MOVE WS-INITIAL-COMM-TX     TO KO-INITIAL-COMMENT-TX.        
           MOVE SPACES                 TO KO-RESPONSE-REASON-CD.        
           MOVE SPACES                 TO KO-RESPONSE-TYPE-CD.          
           MOVE SPACES                 TO KO-SOLICITATION-CD.           
           MOVE SPACES                 TO KO-COMM-ASSOC-CD.             
           MOVE SPACES                 TO KO-COMPLAINT-FL.              
           MOVE SPACES                 TO KO-DISCOVERY-MTHD-CD.         
           MOVE SPACES                 TO KO-PREV-MARKETER-CD.          
      *                                                                 10020000
           PERFORM 8300-INSERT-COMM-DATA         THRU 8300-EXIT.        
      *                                                                 10040000
A04149 1401-EXIT.                                                       
           EXIT.                                                        
      * THIS PARA WILL GET THE ENGLISH MONTH                            10070000
       1410-ENGLISH-MONTH.                                              
      *                                                                 10090000
           EVALUATE WS-HOLD-STMT-DATE-MM                                
               WHEN '01'                                                
                   MOVE 'January  ' TO WS-ENGLISH-MM                    
               WHEN '02'                                                
                   MOVE 'February ' TO WS-ENGLISH-MM                    
               WHEN '03'                                                
                   MOVE 'March    ' TO WS-ENGLISH-MM                    
               WHEN '04'                                                
                   MOVE 'April    ' TO WS-ENGLISH-MM                    
               WHEN '05'                                                
                   MOVE 'May      ' TO WS-ENGLISH-MM                    
               WHEN '06'                                                
                   MOVE 'June     ' TO WS-ENGLISH-MM                    
               WHEN '07'                                                
                   MOVE 'July     ' TO WS-ENGLISH-MM                    
               WHEN '08'                                                
                   MOVE 'August   ' TO WS-ENGLISH-MM                    
               WHEN '09'                                                
                   MOVE 'September' TO WS-ENGLISH-MM                    
               WHEN '10'                                                
                   MOVE 'October  ' TO WS-ENGLISH-MM                    
               WHEN '11'                                                
                   MOVE 'November ' TO WS-ENGLISH-MM                    
               WHEN '12'                                                
                   MOVE 'December ' TO WS-ENGLISH-MM                    
               WHEN OTHER                                               
                   MOVE SPACES      TO WS-ENGLISH-MM                    
           END-EVALUATE.                                                
           MOVE WS-ENGLISH-MM       TO WS-INIT-COMM-ENG-MTH.            
           MOVE WS-HOLD-STMT-DATE-CCYY   TO WS-INIT-COMM-CCYY           
                                            WS-ENGLISH-YY.              
           MOVE WS-HOLD-STMT-DATE-DD     TO WS-ENGLISH-DD.              
      *                                                                 10420000
       1410-EXIT.                                                       
           EXIT.                                                        
      *===============================================================* 10450000
      *THIS PARA WILL WRITE THE RECORDS TO BE293 FILE                   10460000
      *===============================================================* 10470000
       1500-WRITE-BE293.                                                
      *                                                                 10490000
           PERFORM 1001-INITIALIZE-EXT    THRU 1001-EXIT.               
           PERFORM 1510-WRITE-STMTHDR-REC THRU 1510-EXIT.               
           PERFORM 1550-WRITE-BILL-REC    THRU 1550-EXIT.               
           PERFORM 1560-WRITE-ACCOUNT-REC THRU 1560-EXIT.               
      *                                                                 10540000
       1500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10570000
       1510-WRITE-STMTHDR-REC.                                          
      *                                                                 10590000
           INITIALIZE KEY-L3-TIE-BREAKER                                
                      WS-STMT-HDR-TIE-BRKR                              
                      WS-STMT-DET-TIE-BRKR.                             
                                                                        
ACT060     IF WS-BILL-NO-CHAR NOT = '9999'                              
ACT060        COMPUTE WS-HOLD-STMT-SUB = WS-HOLD-STMT-SUB - 1           
ACT060     END-IF.                                                      
           PERFORM VARYING WS-STMT-SUB FROM WS-HOLD-STMT-SUB BY -1 UNTIL
             WS-STMT-SUB = 0                                            
             IF WS-STMT-BILL-DATE (WS-STMT-SUB) > SPACES                
                INITIALIZE EXT-STMT-HDR-REC                             
                MOVE WS-STMT-BILL-DATE (WS-STMT-SUB)                    
                                              TO EXT-STMT-HDR-DATE      
                                                 WS-HOLD-STMT-BILL-DATE 
                MOVE WS-HOLD-STMT-DATE-MM     TO WS-HOLD-DATE-MM        
                                                 WS-HOLD-MM             
                MOVE WS-HOLD-STMT-DATE-DD     TO WS-HOLD-DATE-DD        
                                                 WS-HOLD-DD             
                MOVE WS-HOLD-STMT-DATE-CCYY   TO WS-HOLD-DATE-CCYY      
                MOVE WS-HOLD-STMT-DATE-CCYY(3:2) TO WS-HOLD-YY          
                MOVE '-'                      TO WS-HOLD-DASH1          
                                                 WS-HOLD-DASH2          
                COMPUTE EXT-STMT-HDR-TOTAL-CHARGES =                    
                        WS-STMT-PREV-BILL-AMT (WS-STMT-SUB) -           
                        WS-STMT-PAYMENTS (WS-STMT-SUB)                  
                MOVE EXT-STMT-HDR-TOTAL-CHARGES TO WS-HOLD-SUM-AMT      
                ADD 1                          TO WS-STMT-HDR-TIE-BRKR  
                PERFORM 1520-WRITE-STMTDET-REC THRU 1520-EXIT           
                IF WS-STMT-TOT-BILL-AMT (WS-STMT-SUB) = WS-HOLD-SUM-AMT 
                   MOVE ' '                    TO WS-HOLD-PULL-CODE     
                ELSE                                                    
                   MOVE 'Y'                    TO WS-PULL-CODE-FL       
                   MOVE 'X'                    TO WS-HOLD-PULL-CODE     
                                                  EXT-STMT-HDR-PULL-CODE
                END-IF                                                  
                MOVE WS-STMT-HDR-TIE-BRKR      TO KEY-L4-TIE-BREAKER    
                                                  KEY-L3-TIE-BREAKER    
                MOVE WS-HOLD-DATE              TO KEY-L4-SUB-DATE-BILLED
                MOVE WS-CSTMT-HDR-REC          TO KEY-L3-REC-SEQ        
                MOVE WS-CSTMT-HDR-ID           TO KEY-L3-RECORD-ID      
                MOVE SPACES                    TO WS-BILL-DATA          
                MOVE EXT-STMT-HDR-REC          TO WS-BILL-DATA          
                PERFORM 8000-WRITE-STMT  THRU 8000-EXIT                 
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                 11020000
       1510-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11050000
       1520-WRITE-STMTDET-REC.                                          
      *                                                                 11070000
           INITIALIZE WS-STMT-DET-TIE-BRKR                              
                      EXT-STMT-DET-REC.                                 
      * WRITE PREVIOUS BILL AMOUNT ROW.                                 11100000
           IF WS-STMT-PREV-BILL-AMT (WS-STMT-SUB) NOT = 0.00            
              MOVE WS-STMT-PREV-BILL-AMT (WS-STMT-SUB) TO               
                   EXT-STMT-DET-CHARGE                                  
           ELSE                                                         
              MOVE ZERO TO  EXT-STMT-DET-CHARGE                         
           END-IF                                                       
           MOVE '$'                          TO EXT-STMT-DOLLAR-SIGN.   
           MOVE WS-HOLD-PREV-BILL            TO EXT-STMT-DET-DESC.      
           MOVE WS-CSTMT-DET-REC             TO KEY-L3-REC-SEQ.         
           MOVE WS-CSTMT-DET-REC-ID          TO KEY-L3-RECORD-ID.       
           ADD 1                             TO WS-STMT-DET-TIE-BRKR.   
           MOVE WS-STMT-DET-TIE-BRKR         TO KEY-L3-TIE-BREAKER.     
           MOVE WS-HOLD-DATE                 TO KEY-L4-SUB-DATE-BILLED  
           MOVE SPACES                       TO WS-BILL-DATA.           
           MOVE EXT-STMT-DET-REC             TO WS-BILL-DATA.           
           PERFORM 8000-WRITE-STMT  THRU 8000-EXIT.                     
      *                                                                 11280000
      * WRITE PAYMENTS ROW.                                             11290000
           INITIALIZE EXT-STMT-DET-REC.                                 
           IF WS-STMT-PAYMENTS (WS-STMT-SUB) >= 0.00                    
              MOVE WS-HOLD-PAYMENT-RECVD     TO EXT-STMT-DET-DESC       
              COMPUTE WS-STMT-PAYMENTS (WS-STMT-SUB) =                  
                      WS-STMT-PAYMENTS (WS-STMT-SUB) * -1               
              MOVE WS-STMT-PAYMENTS (WS-STMT-SUB) TO                    
                         EXT-STMT-DET-CHARGE                            
           END-IF.                                                      
           MOVE WS-CSTMT-DET-REC             TO KEY-L3-REC-SEQ.         
           MOVE WS-CSTMT-DET-REC-ID          TO KEY-L3-RECORD-ID.       
           ADD 1                             TO WS-STMT-DET-TIE-BRKR.   
           MOVE WS-STMT-DET-TIE-BRKR         TO KEY-L3-TIE-BREAKER.     
           MOVE WS-HOLD-DATE                 TO KEY-L4-SUB-DATE-BILLED  
           MOVE SPACES                       TO WS-BILL-DATA.           
           MOVE EXT-STMT-DET-REC             TO WS-BILL-DATA.           
           PERFORM 8000-WRITE-STMT  THRU 8000-EXIT.                     
      *                                                                 11460000
           PERFORM 1530-WRITE-CHRGHDR-REC THRU 1530-EXIT.               
       1520-EXIT.                                                       
           EXIT.                                                        
      * CHARGES HEADER                                                  11500000
       1530-WRITE-CHRGHDR-REC.                                          
      *                                                                 11520000
           INITIALIZE EXT-CHRG-HDR-REC.                                 
           MOVE WS-STMT-TOT-BILL-AMT (WS-STMT-SUB)                      
                                             TO EXT-CHRG-HDR-TOTAL-AMT. 
           MOVE WS-CSTMT-CHG-HDR-REC         TO KEY-L3-REC-SEQ.         
           MOVE WS-CSTMT-CHG-HDR-ID          TO KEY-L3-RECORD-ID.       
           MOVE WS-STMT-HDR-TIE-BRKR         TO KEY-L4-TIE-BREAKER.     
           MOVE WS-HOLD-DATE                 TO KEY-L4-SUB-DATE-BILLED  
           MOVE SPACES                       TO WS-BILL-DATA.           
           MOVE EXT-CHRG-HDR-REC             TO WS-BILL-DATA.           
           PERFORM 8000-WRITE-STMT  THRU 8000-EXIT.                     
           PERFORM 1540-WRITE-CHRGDET-REC THRU 1540-EXIT.               
      *                                                                 11640000
       1530-EXIT.                                                       
           EXIT.                                                        
      * CHARGES DETAIL                                                  11670000
       1540-WRITE-CHRGDET-REC.                                          
      *                                                                 11690000
           INITIALIZE WS-STMT-CHG-TIE-BRKR.                             
           PERFORM VARYING WS-STMT-IC-SUB FROM 1 BY 1 UNTIL             
                WS-STMT-PLAN(WS-STMT-SUB WS-STMT-IC-SUB) = SPACES       
            INITIALIZE EXT-CHRG-DET-REC   WS-FORMAT-TYPE                
                       WS-FORMAT-USAGE    WS-FORMAT-DAYS                
                       WS-FORMAT-MESSAGE                                
            EVALUATE  WS-STMT-CODE-UTIL-TYPE(WS-STMT-SUB WS-STMT-IC-SUB)
                WHEN 'E'                                                
                     MOVE WS-HOLD-ELEC-CHARGES   TO EXT-CHRG-DET-DESC   
                     EVALUATE WS-STMT-CODE-USAGE-TYPE                   
                              (WS-STMT-SUB WS-STMT-IC-SUB)              
                        WHEN 'B'                                        
                          MOVE 'kWh   '          TO WS-FORMAT-TYPE      
                        WHEN 'E'                                        
                          MOVE 'kVA   '          TO WS-FORMAT-TYPE      
                        WHEN 'J'                                        
                          MOVE 'kW    '          TO WS-FORMAT-TYPE      
                     END-EVALUATE                                       
                WHEN 'G'                                                
                     MOVE WS-HOLD-GAS-CHARGES    TO EXT-CHRG-DET-DESC   
                     MOVE 'Therms'               TO WS-FORMAT-TYPE      
                WHEN 'U'                                                
                     MOVE WS-HOLD-UNMTR-CHARGES  TO EXT-CHRG-DET-DESC   
                     MOVE '      '               TO WS-FORMAT-TYPE      
            END-EVALUATE                                                
            MOVE WS-STMT-BILL-AMT (WS-STMT-SUB, WS-STMT-IC-SUB)         
                                              TO EXT-CHRG-DET-CHARGE    
            ADD  WS-STMT-BILL-AMT (WS-STMT-SUB, WS-STMT-IC-SUB)         
                                              TO WS-HOLD-SUM-AMT        
            MOVE WS-STMT-USAGE (WS-STMT-SUB, WS-STMT-IC-SUB)            
                                              TO WS-FORMAT-USAGE        
            MOVE WS-STMT-NO-CONS-DAYS (WS-STMT-SUB, WS-STMT-IC-SUB)     
                                              TO WS-FORMAT-DAYS         
            EVALUATE  WS-STMT-CODE-UTIL-TYPE(WS-STMT-SUB WS-STMT-IC-SUB)
                WHEN 'E'                                                
                WHEN 'G'                                                
                     STRING WS-FORMAT-USAGE                             
                            ' '                                         
                            WS-FORMAT-TYPE                              
                            ' '                                         
                            WS-FORMAT-DAYS                              
                            ' Days'                                     
                            DELIMITED BY SIZE                           
                       INTO WS-FORMAT-MESSAGE                           
                WHEN 'U'                                                
                     STRING WS-FORMAT-DAYS                              
                            ' Days'                                     
                            DELIMITED BY SIZE                           
                       INTO WS-FORMAT-MESSAGE                           
            END-EVALUATE                                                
            MOVE 26                           TO WS-EMB-LENG            
            MOVE SPACES                       TO WS-EMB-INPUT           
                                                 WS-CMP-TABLE           
            MOVE WS-FORMAT-MESSAGE            TO WS-EMB-INPUT           
            PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT          
            MOVE WS-CMP-TABLE                 TO EXT-CHRG-DET-DESC-DTL  
            MOVE WS-CSTMT-CHG-DET-REC         TO KEY-L3-REC-SEQ         
            MOVE WS-CSTMT-CHG-DET-ID          TO KEY-L3-RECORD-ID       
            MOVE WS-HOLD-DATE                 TO KEY-L4-SUB-DATE-BILLED 
            ADD 1                             TO WS-STMT-CHG-TIE-BRKR   
            IF WS-STMT-CHG-TIE-BRKR = 1                                 
               MOVE '$'                       TO                        
                                               EXT-CHRG-DET-DOLLAR-SIGN 
            END-IF                                                      
            MOVE WS-STMT-CHG-TIE-BRKR         TO KEY-L3-TIE-BREAKER     
            MOVE SPACES                       TO WS-BILL-DATA           
            MOVE EXT-CHRG-DET-REC             TO WS-BILL-DATA           
            PERFORM 8000-WRITE-STMT  THRU 8000-EXIT                     
           END-PERFORM.                                                 
           PERFORM VARYING WS-STMT-CHG-SUB FROM 1 BY 1 UNTIL            
              WS-STMT-CHG-MSG (WS-STMT-SUB WS-STMT-CHG-SUB) = SPACES    
            INITIALIZE EXT-CHRG-DET-REC                                 
            MOVE WS-STMT-CHG-MSG (WS-STMT-SUB WS-STMT-CHG-SUB)          
                                              TO EXT-CHRG-DET-DESC      
            MOVE WS-STMT-CHG-AMT (WS-STMT-SUB, WS-STMT-CHG-SUB)         
                                              TO EXT-CHRG-DET-CHARGE    
            ADD  WS-STMT-CHG-AMT (WS-STMT-SUB, WS-STMT-CHG-SUB)         
                                              TO WS-HOLD-SUM-AMT        
            MOVE WS-CSTMT-CHG-DET-REC         TO KEY-L3-REC-SEQ         
            MOVE WS-CSTMT-CHG-DET-ID          TO KEY-L3-RECORD-ID       
            ADD 1                             TO WS-STMT-CHG-TIE-BRKR   
            IF WS-STMT-CHG-TIE-BRKR = 1                                 
               MOVE '$'                       TO                        
                                               EXT-CHRG-DET-DOLLAR-SIGN 
            END-IF                                                      
            MOVE WS-STMT-CHG-TIE-BRKR         TO KEY-L3-TIE-BREAKER     
            MOVE WS-HOLD-DATE                 TO KEY-L4-SUB-DATE-BILLED 
            MOVE SPACES                       TO WS-BILL-DATA           
            MOVE EXT-CHRG-DET-REC             TO WS-BILL-DATA           
            PERFORM 8000-WRITE-STMT  THRU 8000-EXIT                     
           END-PERFORM.                                                 
       1540-EXIT.                                                       
           EXIT.                                                        
      *BILL RECORD                                                      12630000
       1550-WRITE-BILL-REC.                                             
      *                                                                 12650000
           INITIALIZE EXT-BILL-REC.                                     
           MOVE LOW-VALUES                 TO LEVEL-4-SORT-FLDS.        
           MOVE WS-BILL-REC                TO KEY-L3-REC-SEQ.           
           MOVE WS-BILL-ID                 TO KEY-L3-RECORD-ID.         
           MOVE 1                          TO KEY-L3-TIE-BREAKER.       
           MOVE WS-ACCOUNT-NO              TO EXT-BILL-ACCOUNT-NO.      
           MOVE AT-CUSTOMER-NO             TO EXT-BILL-CUSTOMER-NO.     
           MOVE ' '                        TO EXT-BILL-BILL-DEST-CODE.  
           IF WS-PULL-CODE-FL = 'Y'                                     
              MOVE 'X'                     TO EXT-BILL-PULL-CODE        
           END-IF.                                                      
           MOVE WS-CURRENT-DATE            TO EXT-BILL-BILL-DATE.       
           MOVE WS-HOLD-CUST-NAME          TO EXT-BILL-CUST-NAME.       
           MOVE WS-PR-STREET               TO EXT-BILL-SERVICE-LINE-1.  
           IF WS-PR-ADDR-OVERFLOW > SPACES                              
              MOVE WS-PR-ADDR-OVERFLOW        TO EXT-BILL-SERVICE-LINE-2
              MOVE WS-PR-ADDR-CITY-STATE-ZIP  TO EXT-BILL-SERVICE-LINE-3
           ELSE                                                         
              MOVE WS-PR-ADDR-CITY-STATE-ZIP  TO EXT-BILL-SERVICE-LINE-2
           END-IF.                                                      
           MOVE MW-BARCODE-UNIQUE-ID       TO                           
                                        EXT-BILL-BARCODE-UNIQUE-ID.     
           MOVE MW-TRACKING-STATUS-CD      TO                           
                                        EXT-BILL-TRACKING-STATUS-CD.    
P00837     MOVE '46'                       TO EXT-BILL-COMM-TYPE-CD.    
P00837     MOVE '27'                       TO                           
P00837                                  EXT-BILL-COMM-SUB-TYPE-CODE.    
P00821     IF WS-BILL-MSG-ID = ('STMNT' OR 'STM12')                     
P00821        MOVE 1                       TO EXT-BILL-NO-BILL-COPIES   
P00821     ELSE                                                         
P00821        MOVE 0                       TO EXT-BILL-NO-BILL-COPIES   
P00821     END-IF.                                                      
           MOVE SPACES                     TO WS-BILL-DATA.             
           MOVE EXT-BILL-REC               TO WS-BILL-DATA.             
           PERFORM 8000-WRITE-STMT  THRU 8000-EXIT.                     
       1550-EXIT.                                                       
           EXIT.                                                        
      * ACCOUNT RECORDS                                                 13000000
       1560-WRITE-ACCOUNT-REC.                                          
      *                                                                 13020000
           INITIALIZE EXT-ACCT-REC.                                     
           MOVE LOW-VALUES                 TO LEVEL-4-SORT-FLDS.        
           MOVE WS-ACCOUNT-REC             TO KEY-L3-REC-SEQ.           
           MOVE WS-ACCOUNT-ID              TO KEY-L3-RECORD-ID.         
           MOVE 1                          TO KEY-L3-TIE-BREAKER.       
      *                                                                 13080000
           MOVE 'Y'                        TO EXT-ACCT-BILL-STMT-FLAG.  
           MOVE WS-ACCOUNT-NO              TO EXT-ACCT-ACCOUNT-NO.      
           MOVE WS-MAILING-ADDRESS(1)      TO EXT-ACCT-MAIL-LINE-1.     
           MOVE WS-MAILING-TYPE (1)        TO EXT-ACCT-MAIL-TYPE-1.     
           MOVE WS-MAILING-ADDRESS (2)     TO EXT-ACCT-MAIL-LINE-2.     
           MOVE WS-MAILING-TYPE (2)        TO EXT-ACCT-MAIL-TYPE-2.     
           MOVE WS-MAILING-ADDRESS (3)     TO EXT-ACCT-MAIL-LINE-3.     
           MOVE WS-MAILING-TYPE (3)        TO EXT-ACCT-MAIL-TYPE-3.     
           MOVE WS-MAILING-ADDRESS (4)     TO EXT-ACCT-MAIL-LINE-4.     
           MOVE WS-MAILING-TYPE (4)        TO EXT-ACCT-MAIL-TYPE-4.     
           MOVE WS-MAILING-ADDRESS (5)     TO EXT-ACCT-MAIL-LINE-5.     
           MOVE WS-MAILING-TYPE (5)        TO EXT-ACCT-MAIL-TYPE-5.     
           MOVE WS-MAILING-ADDRESS (6)     TO EXT-ACCT-MAIL-LINE-6.     
           MOVE WS-MAILING-TYPE (6)        TO EXT-ACCT-MAIL-TYPE-6.     
           MOVE WS-BARCODE-ZIP             TO EXT-ACCT-BARCODE-ZIP.     
      *  OMR MARKS, turn 1 just omr mark 1 and set remaining as 0.      13240000
           MOVE '1'                        TO EXT-ACCT-OMR-MARK-1.      
           MOVE '0'                        TO EXT-ACCT-OMR-MARK-2       
                                              EXT-ACCT-OMR-MARK-3       
                                              EXT-ACCT-OMR-MARK-4       
                                              EXT-ACCT-OMR-MARK-5       
                                              EXT-ACCT-OMR-MARK-6       
                                              EXT-ACCT-OMR-MARK-7       
                                              EXT-ACCT-OMR-MARK-8       
                                              EXT-ACCT-OMR-MARK-9       
                                              EXT-ACCT-OMR-MARK-10      
                                              EXT-ACCT-OMR-MARK-11      
                                              EXT-ACCT-OMR-MARK-12.     
           MOVE WS-PREMISE-NO              TO EXT-ACCT-PREMISE-NO.      
           MOVE SPACES                     TO WS-BILL-DATA.             
           MOVE EXT-ACCT-REC               TO WS-BILL-DATA.             
           PERFORM 8000-WRITE-STMT  THRU 8000-EXIT.                     
                                                                        
       1560-EXIT.                                                       
           EXIT.                                                        
      *===============================================================* 13440000
      * THIS WILL EXTARCT THE DETAILS FOR LAST 24 MONTHS FROM PANEL091* 13450000
      * TABLES BI, BG, AR, BH, AT.                                    * 13460000
      *===============================================================* 13470000
       2000-CALL-SCSCA158.                                              
      *                                                                 13490000
A04149     INITIALIZE WS-CA158-BILLSTMT-INFO.                           
A04149     DISPLAY ' ACCOUNT NUMBER CALLING SCSCA158 ' WS-ACCOUNT-NO.   
A04149     CALL SCSCA158 USING WS-ACCOUNT-NO-CHAR                       
A04149                         WS-BILL-NO-CHAR                          
A04149                         WS-SCSCA-RETURN-CODE                     
A04149                         WS-CA158-BILLSTMT-INFO                   
                                                                        
A04149     IF WS-SCSCA-RETURN-CODE = 0                                  
A04149        PERFORM 2100-PROCESS-DATA       THRU 2100-EXIT            
A04149     ELSE                                                         
A04149        MOVE 'SCSCA158'                 TO WS-DISPLAY-SCSCA       
A04149        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
A04149     END-IF.                                                      
      *                                                                 13630000
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13660000
      *================================================================*13670000
A04149* PROCESS THE DATA RETRIEVED FROM SCSCA158 AND WRITE IT TO TABLE *13680000
      *================================================================*13690000
      *                                                                 13700000
       2100-PROCESS-DATA.                                               
      *                                                                 13720000
A04149     PERFORM VARYING WS-CA158-SUB FROM 1 BY 1 UNTIL               
A04149       WS-CA158-SUB > 999 OR                                      
A04149       WS-CA158-RECORD-ID (WS-CA158-SUB) <= SPACES                
A04149       IF WS-CA158-DATE-BILLED(WS-CA158-SUB) > SPACES AND         
A04149          WS-CA158-REVENUE-MONTH(WS-CA158-SUB) > 0                
A04149          EVALUATE WS-CA158-RECORD-ID (WS-CA158-SUB)              
A04149              WHEN 'H'                                            
A04149                   PERFORM 2200-LOAD-HEADER   THRU 2200-EXIT      
A04149                   ADD 1             TO WS-STMT-SUB               
A04149                   MOVE 1            TO WS-STMT-IC-SUB            
A04149              WHEN 'D'                                            
A04149                   PERFORM 2300-LOAD-DETAIL   THRU 2300-EXIT      
A04149                   ADD 1             TO WS-STMT-IC-SUB            
A04149          END-EVALUATE                                            
A04149       END-IF                                                     
A04149     END-PERFORM.                                                 
      *                                                                 13890000
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13920000
      *================================================================*13930000
      * PROCESS AND LOAD THE HEADER RECORDS                             13940000
      *================================================================*13950000
       2200-LOAD-HEADER.                                                
      *                                                                 13970000
           MOVE WS-CA158-DATE-BILLED(WS-CA158-SUB)                      
                                     TO WS-STMT-BILL-DATE (WS-STMT-SUB).
           MOVE WS-CA158-BILL-NO (WS-CA158-SUB)                         
                                     TO WS-STMT-BILL-NO (WS-STMT-SUB)   
                                        WS-BILL-NO.                     
           MOVE WS-CA158-BILL-AMOUNT(WS-CA158-SUB)                      
                                     TO WS-STMT-TOTAL (WS-STMT-SUB).    
           MOVE WS-CA158-REVENUE-MONTH (WS-CA158-SUB)                   
                                     TO WS-STMT-REV-MONTH (WS-STMT-SUB).
           MOVE WS-CA158-PAYMENTS (WS-CA158-SUB)                        
                                     TO WS-STMT-PAYMENTS (WS-STMT-SUB). 
           MOVE WS-CA158-TOT-OTHER-CHARGES (WS-CA158-SUB)               
                                     TO WS-STMT-OTHR-CHRG (WS-STMT-SUB).
           MOVE WS-CA158-TOTAL-ARREARS (WS-CA158-SUB)                   
                                     TO WS-STMT-ARREARS (WS-STMT-SUB).  
           MOVE WS-CA158-TOTAL-BILL-AMOUNT(WS-CA158-SUB)                
             TO WS-STMT-TOT-BILL-AMT (WS-STMT-SUB).                     
           IF WS-STMT-SUB > 1                                           
              MOVE WS-CA158-TOTAL-BILL-AMOUNT(WS-CA158-SUB)             
                TO WS-STMT-PREV-BILL-AMT (WS-STMT-SUB - 1)              
           END-IF.                                                      
      *                                                                 14190000
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14220000
      *================================================================*14230000
      * PROCESS AND LOAD THE IC DETAILS                                 14240000
      *================================================================*14250000
       2300-LOAD-DETAIL.                                                
      *                                                                 14270000
           IF WS-CA158-CODE-BILL-ITM-IND(WS-CA158-SUB) = 'A' OR 'R'     
              MOVE WS-STMT-SUB       TO WS-HOLD-STMT-SUB                
           END-IF.                                                      
           MOVE WS-CA158-CODE-UTIL-TYPE (WS-CA158-SUB)  TO              
                WS-STMT-CODE-UTIL-TYPE(WS-STMT-SUB, WS-STMT-IC-SUB).    
           MOVE WS-CA158-CODE-USAGE-TYPE (WS-CA158-SUB) TO              
                WS-STMT-CODE-USAGE-TYPE(WS-STMT-SUB, WS-STMT-IC-SUB).   
           MOVE WS-CA158-RATE-PLAN-NO (WS-CA158-SUB)    TO              
                WS-STMT-PLAN (WS-STMT-SUB, WS-STMT-IC-SUB).             
           MOVE WS-CA158-IC-NO  (WS-CA158-SUB)          TO              
                WS-STMT-IC-NO (WS-STMT-SUB, WS-STMT-IC-SUB).            
           MOVE WS-CA158-NO-UNITS (WS-CA158-SUB)        TO              
                WS-STMT-USAGE (WS-STMT-SUB, WS-STMT-IC-SUB).            
           MOVE WS-CA158-DATE-READ (WS-CA158-SUB)       TO              
                WS-STMT-END-DATE  (WS-STMT-SUB, WS-STMT-IC-SUB).        
           MOVE WS-CA158-NO-DAYS (WS-CA158-SUB)         TO              
                WS-STMT-NO-CONS-DAYS (WS-STMT-SUB, WS-STMT-IC-SUB).     
           COMPUTE WS-STMT-BILL-AMT (WS-STMT-SUB, WS-STMT-IC-SUB) =     
                   WS-CA158-AMT-BILL-ITEM(WS-CA158-SUB) +               
                   WS-CA158-AMT-TAXES(WS-CA158-SUB).                    
      *                                                                 14480000
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14510000
P00836****************************************************************  14511000
P00836*   2400-MOVE-CSS-BATCH-EMAIL                                  *  14512000
P00836****************************************************************  14513000
P00836 2400-MOVE-CSS-BATCH-EMAIL.                                       
P00836*                                                                 14515000
P00836        MOVE AT-ACCOUNT-NO         TO AE-ACCOUNT-NO.              
P00836        MOVE AT-COMPANY-NO         TO AE-COMPANY-NO.              
P00836        MOVE AT-CUSTOMER-NO        TO AE-CUSTOMER-NO.             
P00836        MOVE 'CIS03'               TO AE-EMAIL-EVENT-CD.          
P00836        MOVE WS-CURRENT-DATE       TO AE-EMAIL-EVENT-DT.          
P00836*                                                                 14519200
P00836 2400-EXIT.                                                       
P00836     EXIT.                                                        
P00836*                                                                 14519500
      *================================================================*14520000
      * EXTRACT SINCE BILLING TRANSACTIONS                              14530000
      *================================================================*14540000
      *                                                                 14550000
       2500-GET-SINCE-BILL-TRANS.                                       
      *                                                                 14570000
           INITIALIZE WS-END-OF-AR-RECS-SW.                             
A04149     PERFORM 6150-GET-PREV-AR-TRANS     THRU 6150-EXIT.           
      *  THERE IS NO PREVIOUS BILL ON TRANSACTION HISTORY               14600000
           IF WS-END-OF-AR-RECS                                         
               MOVE 'Y'               TO WS-OLDEST-TRAN-SW              
               MOVE WS-DEFAULT-SEQ-NO TO WS-PREV-HST-SEQ-NO             
               MOVE 0.00              TO WS-PREV-BILL-UNPAID            
A04149         MOVE WS-HOLD-DATE-BILLED TO WS-DATE-BILLED-BI            
A04149         PERFORM 6175-GET-OLDEST-AR-TRANS THRU 6175-EXIT          
           ELSE                                                         
               MOVE 'N'               TO WS-OLDEST-TRAN-SW              
               MOVE AR-DATE-TRANS     TO WS-PREV-DATE-TRANS             
           END-IF.                                                      
A04149     PERFORM 6200-PROCESS-AR-DETAIL-RECORDS  THRU 6200-EXIT.      
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14740000
P00836****************************************************************  14741000
P00836*   2600-MOVE-CSS-BATCH-EMAIL-DETAIL                           *  14742000
P00836****************************************************************  14743000
P00836 2600-MOVE-CSS-BTCH-EMAIL-DET.                                    
P00836*                                                                 14745000
P00836        MOVE AE-BATCH-EMAIL-ID       TO JK-BATCH-EMAIL-ID.        
P00836        MOVE 'BILLD-DT'              TO JK-FIELD-NAME-TX.         
P00836        MOVE WS-CURRENT-DATE(6:2)    TO WS-MONTH.                 
P00836        MOVE WS-CURRENT-DATE(9:2)    TO WS-DATE.                  
P00836        MOVE WS-CURRENT-DATE(1:4)    TO WS-YEAR.                  
P00836        MOVE WS-FORMAT-DATE          TO JK-FIELD-VALUE-TX-TEXT.   
P00836        MOVE LENGTH OF JK-FIELD-VALUE-TX-TEXT                     
P00836                                     TO JK-FIELD-VALUE-TX-LEN.    
P00836*                                                                 14749500
P00836 2600-EXIT.                                                       
P00836     EXIT.                                                        
P00836*                                                                 14749800
      ************************************************************      14750000
      *  CALL SCSCA165 TO GET UNIQUE IDENTIFIER                  *      14760000
      ************************************************************      14770000
       5100-CALL-SCSCA165.                                              
      *                                                                 14790000
           DISPLAY 'CALL SCSCA165 FROM PCSCA293'.                       
                                                                        
           CALL  SCSCA165                 USING WS-SCSCA165-PARMS,      
                                                WS-CA165-MISC,          
                                                ABEND-FILE,             
                                                WS-SCSCA-RETURN-CODE    
                                                                        
           MOVE 'SCSCA165'                TO WS-DISPLAY-SCSCA.          
                                                                        
           IF WS-SCSCA-RETURN-CODE        NOT = 0                       
              PERFORM 9200-SCSCA-ERROR    THRU   9200-EXIT              
           END-IF.                                                      
      *                                                                 14920000
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14950000
       5200-MOVE-TRAN-HEAD.                                             
      *                                                                 14970000
           MOVE WS-CURRENT-DATE               TO MH-DATE-TRANS.         
           PERFORM 7075-CURRENT-TIMESTMP      THRU 7075-EXIT.           
           MOVE 'F'                           TO MH-CODE-TRAN-TYPE.     
           MOVE SPACES                        TO MH-RESP-AREA-ID.       
           MOVE WS-ACCOUNT-NO                 TO MH-ACCOUNT-NO.         
           MOVE ZEROS                         TO MH-CUSTOMER-NO         
                                                 MH-PREMISE-NO.         
           MOVE 'SYSTEM'                      TO MH-USER-ID.            
           MOVE 'PANEL091'                    TO MH-APPL-PROGRAM-ID.    
           MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                          
                                              TO MH-TRAN-COMMENT-LEN.   
           MOVE 'Statement Generated.'        TO MH-TRAN-COMMENT-TEXT.  
           MOVE 1                             TO WS-TRAN-APPL-NO.       
                                                                        
       5200-EXIT.                                                       
                                                                        
      ***************************************************************   15140000
      * MOVE FIELDS TO THE MAINTENANCE TRANSACTION DETAIL AND       *   15150000
      * CALL COMMON PARAGRAPH TO INSERT THE DATA.                   *   15160000
      ***************************************************************   15170000
      *                                                                 15180000
       5300-INSERT-TRAN-HDR-DET.                                        
      *                                                                 15200000
           MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO.      
           MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.           
           MOVE WS-STMT-BILL-DATE (WS-HOLD-STMT-SUB)                    
                                          TO WS-HOLD-STMT-BILL-DATE.    
           PERFORM 1410-ENGLISH-MONTH  THRU 1410-EXIT.                  
           MOVE WS-ENGLISH-DATE           TO MI-CHG-COLUMN-VALUE-TEXT.  
           MOVE '**INSERTED**'            TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE 'STMT BEGIN DATE '        TO MI-COLUMN-DESC.            
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                          TO MI-PRV-COLUMN-VALUE-LEN.   
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                          TO MI-CHG-COLUMN-VALUE-LEN.   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1                          TO WS-TRAN-APPL-NO.           
      *                                                                 15350000
           MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO.      
           MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.           
           MOVE WS-STMT-BILL-DATE (1)     TO WS-HOLD-STMT-BILL-DATE.    
           PERFORM 1410-ENGLISH-MONTH  THRU 1410-EXIT.                  
           MOVE WS-ENGLISH-DATE           TO MI-CHG-COLUMN-VALUE-TEXT.  
           MOVE '**INSERTED**'            TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE 'STMT END DATE '          TO MI-COLUMN-DESC.            
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                          TO MI-PRV-COLUMN-VALUE-LEN.   
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                          TO MI-CHG-COLUMN-VALUE-LEN.   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1                          TO WS-TRAN-APPL-NO.           
      *                                                                 15490000
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      15530000
      *  6010-REDUCE-EMBEDDED-SPACES                             *      15540000
      ************************************************************      15550000
                                                                        
       COPY CPD00004.                                                   15570000
      *                                                                 15580000
      ***************************************************************** 15590000
      * JOURNALLING COPYBOOK.                                         * 15600000
      * 6530-LOAD-MNT-TRANS-HIST.                                     * 15610000
      ***************************************************************** 15620000
                                                                        
           EXEC SQL                                                     15640000
              INCLUDE CPD00067                                          15650000
           END-EXEC.                                                    15660000
                                                                        
A04149*================================================================*15680000
A04149* THIS COPY BOOK HAVING COMMON LOGIC PART OF SCSCA167 & PCSCA293. 15690000
A04149* MAIN PROCESS PARA:                                              15700000
A04149* 6100-GET-BILL-AR-TRANS.                                         15710000
A04149* 6150-GET-PREV-AR-TRANS.                                         15720000
A04149* 6175-GET-OLDEST-AR-TRANS.                                       15730000
A04149* 6200-PROCESS-AR-DETAIL-RECORDS.                                 15740000
A04149*================================================================*15750000
A04149                                                                  
A04149     EXEC SQL                                                     15770000
A04149         INCLUDE CPDCA167                                         15780000
A04149     END-EXEC.                                                    15790000
A04149                                                                  
      *================================================================*15810000
      * EXTRACT ROWS FOR GL ACCTS                                       15820000
      *================================================================*15830000
      *                                                                 15840000
       7000-OPEN-GL-NAME.                                               
      *                                                                 15860000
           EXEC SQL                                                     
               OPEN GL_NAME                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
P00641         MOVE 'GO'            TO WS-DB2-TABLE-ID                  
               MOVE 'OPEN'          TO WS-DB2-FUNCTION                  
               MOVE SQLCODE         TO WS-DB2-RETURN-CODE               
               MOVE '293'           TO WS-DB2-MODULE-ID                 
               MOVE '7000'          TO WS-DB2-PARAGRAPH                 
               DISPLAY '*** IN 7000-OPEN-GL-NAME    ******'             
               DISPLAY '*** CURSOR OPEN GL_NAME     ******'             
               DISPLAY '*** SQLCODE     = ' SQLCODE                     
               MOVE 12              TO RETURN-CODE                      
A04149         PERFORM 9905-ABEND THRU 9905-EXIT                        
           END-IF.                                                      
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16050000
       7010-FETCH-GL-NAME.                                              
           EXEC SQL                                                     
               FETCH GL_NAME                                            
P00641          INTO :GO-GL-ACCT-NAME,                                  
P00641               :GO-GL-ACCT-NAME-DESC,                             
                     :GO-GL-ACCT-NO,                                    
                     :GO-GL-ACCT-CLASS                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
P00641             MOVE 'GO'         TO WS-DB2-TABLE-ID                 
                   MOVE 'FETCH'      TO WS-DB2-FUNCTION                 
                   MOVE SQLCODE      TO WS-DB2-RETURN-CODE              
P00641             MOVE '293'        TO WS-DB2-MODULE-ID                
A04149             MOVE '7010'       TO WS-DB2-PARAGRAPH                
                   MOVE 12           TO RETURN-CODE                     
A04149             DISPLAY '*** IN 7010 FETCH GL ***'                   
                   DISPLAY '*** SQL CODE = ' SQLCODE                    
A04149             PERFORM 9905-ABEND THRU 9905-EXIT                    
           END-EVALUATE.                                                
      *                                                                 16300000
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16330000
       7020-CLOSE-GL-NAME.                                              
      *                                                                 16350000
           EXEC SQL                                                     
               CLOSE GL_NAME                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
P00641         MOVE 'GO'            TO WS-DB2-TABLE-ID                  
               MOVE 'CLOSE'         TO WS-DB2-FUNCTION                  
               MOVE SQLCODE         TO WS-DB2-RETURN-CODE               
               MOVE '293'           TO WS-DB2-MODULE-ID                 
               MOVE '7020'          TO WS-DB2-PARAGRAPH                 
               DISPLAY '*** IN 7020-CLOSE-GL-NAME   ******'             
               DISPLAY '*** CURSOR OPEN GL_NAME     ******'             
               DISPLAY '*** SQLCODE     = ' SQLCODE                     
               MOVE 12              TO RETURN-CODE                      
A04149         PERFORM 9905-ABEND THRU 9905-EXIT                        
           END-IF.                                                      
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************16550000
      *   GET DATABASE, WHETHER CSR OR SEB.                            *16560000
      ******************************************************************16570000
       7030-GET-DATABASE.                                               
                                                                        
           EXEC SQL                                                     
                SELECT DELINQ_VALUE                                     
                  INTO :C8-DELINQ-VALUE                                 
                  FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                    
                 WHERE DELINQ_CD  = :C8-DELINQ-CD                       
                   AND COMPANY_NO = :C8-COMPANY-NO                      
                                                                 
A04149                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     16600000
MFA-TR*         SELECT DELINQ_VALUE                                     16610000
MFA-TR*           INTO :C8-DELINQ-VALUE                                 16620000
MFA-TR*           FROM CSS_DELINQUENCY                                  16630000
MFA-TR*          WHERE DELINQ_CD  = :C8-DELINQ-CD                       16640000
MFA-TR*            AND COMPANY_NO = :C8-COMPANY-NO                      16650000
MFA-TR*          WITH UR                                                16660000
MFA-TR*          QUERYNO 7030                                           16670000
MFA-TR*    END-EXEC.                                                    16680000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
               MOVE 'C8'              TO WS-DB2-TABLE-ID                
               MOVE 'SELECT'          TO WS-DB2-FUNCTION                
               MOVE SQLCODE           TO WS-DB2-RETURN-CODE             
               MOVE '293'             TO WS-DB2-MODULE-ID               
               MOVE '7030'            TO WS-DB2-PARAGRAPH               
               MOVE 12                TO RETURN-CODE                    
               DISPLAY '*** IN 7030 CHECK DATABASE ***'                 
               DISPLAY '*** SQL CODE    = ' SQLCODE                     
               DISPLAY '*** DELINQ CODE = ' C8-DELINQ-CD                
               DISPLAY '*** COMPANY NO  = ' C8-COMPANY-NO               
A04149         PERFORM 9905-ABEND             THRU 9905-EXIT            
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*16870000
      * EXTRACT FROM CSS_ACCOUNT TABLE.                                 16880000
      *================================================================*16890000
      *                                                                 16900000
       7050-ACCOUNT-DETAILS.                                            
      *                                                                 16920000
           EXEC SQL                                                     
               SELECT ADDRESS_ID                                        
                     ,ADDRESS_FORMAT                                    
                     ,CUSTOMER_NO                                       
                     ,PREMISE_NO                                        
                     ,COMPANY_NO                                        
                     ,LOCAL_OFFICE                                      
P00821               ,REV_MTH_LST_NRML                                  
                 INTO :AT-ADDRESS-ID                                    
                     ,:AT-ADDRESS-FORMAT                                
                     ,:AT-CUSTOMER-NO                                   
                     ,:AT-PREMISE-NO                                    
                     ,:AT-COMPANY-NO                                    
                     ,:AT-LOCAL-OFFICE                                  
P00821               ,:AT-REV-MTH-LST-NRML                              
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
A04149                                                           
A04149                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     16930000
MFA-TR*        SELECT ADDRESS_ID                                        16940000
MFA-TR*              ,ADDRESS_FORMAT                                    16950000
MFA-TR*              ,CUSTOMER_NO                                       16960000
MFA-TR*              ,PREMISE_NO                                        16970000
MFA-TR*              ,COMPANY_NO                                        16980000
MFA-TR*              ,LOCAL_OFFICE                                      16990000
MFA-TR*              ,REV_MTH_LST_NRML                                  17000000
MFA-TR*          INTO :AT-ADDRESS-ID                                    17010000
MFA-TR*              ,:AT-ADDRESS-FORMAT                                17020000
MFA-TR*              ,:AT-CUSTOMER-NO                                   17030000
MFA-TR*              ,:AT-PREMISE-NO                                    17040000
MFA-TR*              ,:AT-COMPANY-NO                                    17050000
MFA-TR*              ,:AT-LOCAL-OFFICE                                  17060000
MFA-TR*              ,:AT-REV-MTH-LST-NRML                              17070000
MFA-TR*          FROM CSS_ACCOUNT AT                                    17080000
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       17090000
MFA-TR*         WITH UR                                                 17100000
MFA-TR*         QUERYNO 7050                                            17110000
MFA-TR*    END-EXEC.                                                    17120000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '**    PCSCA293 - PARA: 7050    **'               
              DISPLAY '**    CSS_ACCOUNT              **'               
              DISPLAY '**    SQL CODE =  ' SQLCODE                      
A04149        DISPLAY '**    ACCT NO  =  ' AT-ACCOUNT-NO                
              DISPLAY '**    PROCESSING TERMINATED    **'               
              MOVE 'CSS_ACCOUNT          '    TO TABLE-1                
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE '7050'                     TO ACTIVE-PARAGRAPH       
A04149        PERFORM 9905-ABEND THRU 9905-EXIT                         
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17310000
       7075-CURRENT-TIMESTMP.                                           
      *                                                                 17330000
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :MH-TRANS-HIST-SEQ-NO            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     17340000
MFA-TR*       SET  :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP            17350000
MFA-TR*    END-EXEC.                                                    17360000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '**    PCSCA293 - PARA: 7075    **'               
              DISPLAY '**    SELECT CURRENT TIME STAMP**'               
              DISPLAY '**    SQL CODE =  ' SQLCODE                      
              DISPLAY '**    PROCESSING TERMINATED    **'               
              MOVE 'SET   '                   TO ABEND-FUNCTION         
              MOVE '7075'                     TO ACTIVE-PARAGRAPH       
A04149        PERFORM 9905-ABEND THRU 9905-EXIT                         
           END-IF.                                                      
                                                                        
       7075-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17510000
P00821*================================================================*17520000
P00821* GET CUTOFF BILL NO DETAILS FROM CSS_BILLING_DET TABLE.          17530000
P00821*================================================================*17540000
P00821*                                                                 17550000
P00821 7100-GET-CUTOFF-BILL-NO.                                         
P00821*                                                                 17570000
P00821     EXEC SQL                                                     
P00821         SELECT TOP(1) BILL_NO                                           
P00821           INTO :BG-BILL-NO                                       
P00821           FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                  
P00821          WHERE ACCOUNT_NO    = :BG-ACCOUNT-NO                    
P00821            AND REVENUE_MONTH = :BG-REVENUE-MONTH                 
P00821          ORDER BY BILL_NO                                        
P00821                                              
P00821                                                           
P00821                                                      
P00821     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     17580000
MFA-TR*        SELECT BILL_NO                                           17590000
MFA-TR*          INTO :BG-BILL-NO                                       17600000
MFA-TR*          FROM CSS_BILLING_DET BG                                17610000
MFA-TR*         WHERE ACCOUNT_NO    = :BG-ACCOUNT-NO                    17620000
MFA-TR*           AND REVENUE_MONTH = :BG-REVENUE-MONTH                 17630000
MFA-TR*         ORDER BY BILL_NO                                        17640000
MFA-TR*         FETCH FIRST ROW ONLY                                    17650000
MFA-TR*         WITH UR                                                 17660000
MFA-TR*         QUERYNO 7100                                            17670000
MFA-TR*    END-EXEC.                                                    17680000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00821                                                                  
P00821     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
P00821     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00821        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
P00821           MOVE BG-BILL-NO               TO WS-BILL-NUM           
P00821           MOVE WS-BILL-NUM              TO WS-BILL-NO-CHAR       
P00821        END-IF                                                    
P00821     ELSE                                                         
P00821        DISPLAY '**    PCSCA293 - PARA: 7100    **'               
P00821        DISPLAY '**    CSS_BILLING_DET          **'               
P00821        DISPLAY '**    SQL CODE =  ' SQLCODE                      
P00821        DISPLAY '**    ACCT NO  =  ' BG-ACCOUNT-NO                
P00821        DISPLAY '**    PROCESSING TERMINATED    **'               
P00821        MOVE 'CSS_BILLING_DET      '    TO TABLE-1                
P00821        MOVE 'SELECT'                   TO ABEND-FUNCTION         
P00821        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
P00821        MOVE BG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
P00821        MOVE 'REVENUE_MONTH'            TO TABLE-ELEMENT-2        
P00821        MOVE BG-REVENUE-MONTH           TO HOSTVAR-ELEMENT-2      
P00821        MOVE '7100'                     TO ACTIVE-PARAGRAPH       
P00821        PERFORM 9905-ABEND THRU 9905-EXIT                         
P00821     END-IF.                                                      
P00821                                                                  
P00821 7100-EXIT.                                                       
P00821     EXIT.                                                        
P00821*                                                                 17940000
ACT070***************************************************************** 17940100
ACT070* 7150-SET-NEXT-VALUE.                                          * 17940200
ACT070***************************************************************** 17940300
ACT070 7150-SET-NEXT-VALUE.                                             
      *                                                                 17940500
ACT070     EXEC SQL                                                     
ACT070        SELECT
              NEXT VALUE FOR SEQ_AE_BATCH_EMAIL_ID
            INTO
              :AE-BATCH-EMAIL-ID
ACT070     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ048
MFA-TR*    EXEC SQL                                                     17940600
MFA-TR*       SET :AE-BATCH-EMAIL-ID = NEXTVAL FOR SEQ_AE_BATCH_EMAIL_ID17940700
MFA-TR*    END-EXEC.                                                    17940800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 17940900
ACT070     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
ACT070     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT070        CONTINUE                                                  
ACT070     ELSE                                                         
ACT070        DISPLAY '***********************************'             
ACT070        DISPLAY '**  PROCESSING ERROR             **'             
ACT070        DISPLAY '**  PARAGRAPH    = 7150-SET-NEXT-VALUE    '      
ACT070        DISPLAY '**  SET CSS_BATCH_EMAIL'                         
ACT070        DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
ACT070        DISPLAY '**  PROCESSING TERMINATED        **'             
ACT070        DISPLAY '***********************************'             
ACT070        PERFORM 9905-ABEND                THRU 9905-EXIT          
ACT070     END-IF.                                                      
                                                                        
      *                                                                 17942500
ACT070 7150-EXIT.                                                       
ACT070     EXIT.                                                        
      *                                                                 17942800
P00836****************************************************************  17942900
P00836* 7200-SELECT-BATCH-EMAIL-ID                                   *  17943000
P00836****************************************************************  17943100
P00836*                                                                 17944000
P00836 7200-SELECT-BATCH-EMAIL-ID.                                      
P00836*                                                                 17946000
P00836     MOVE '7200'                     TO WS-ACTIVE-PARAGRAPH.      
P00836                                                                  
P00836     EXEC SQL                                                     
P00836       SELECT TOP(1) BATCH_EMAIL_ID                                      
P00836         INTO :AE-BATCH-EMAIL-ID                                  
P00836         FROM CSS_BATCH_EMAIL                                     
P00836        WHERE COMPANY_NO     = :AE-COMPANY-NO                     
P00836          AND ACCOUNT_NO     = :AE-ACCOUNT-NO                     
P00836          AND CUSTOMER_NO    = :AE-CUSTOMER-NO                    
P00836          AND EMAIL_EVENT_CD = :AE-EMAIL-EVENT-CD                 
P00836          AND EMAIL_EVENT_DT = IIF(TRY_CONVERT(DATE, 
                                                     :AE-EMAIL-EVENT-DT
              ) IS NULL OR (PATINDEX('%.%', :AE-EMAIL-EVENT-DT
              ) <> 0) OR (LEN(:AE-EMAIL-EVENT-DT
              ) <> 10), CIS.CHAR2DATE(:AE-EMAIL-EVENT-DT
              ), CONVERT(DATE, :AE-EMAIL-EVENT-DT) )                 
P00836          ORDER BY BATCH_EMAIL_ID  DESC                           
P00836                                              
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     17949000
MFA-TR*      SELECT BATCH_EMAIL_ID                                      17949100
MFA-TR*        INTO :AE-BATCH-EMAIL-ID                                  17949200
MFA-TR*        FROM CSS_BATCH_EMAIL                                     17949300
MFA-TR*       WHERE COMPANY_NO     = :AE-COMPANY-NO                     17949400
MFA-TR*         AND ACCOUNT_NO     = :AE-ACCOUNT-NO                     17949500
MFA-TR*         AND CUSTOMER_NO    = :AE-CUSTOMER-NO                    17949600
MFA-TR*         AND EMAIL_EVENT_CD = :AE-EMAIL-EVENT-CD                 17949700
MFA-TR*         AND EMAIL_EVENT_DT = :AE-EMAIL-EVENT-DT                 17949800
MFA-TR*         ORDER BY BATCH_EMAIL_ID  DESC                           17949900
MFA-TR*         FETCH FIRST ROW ONLY                                    17950000
MFA-TR*    END-EXEC.                                                    17950100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00836                                                                  
P00836     IF SQLCODE = SUCCESSFUL-CALL                                 
P00836        CONTINUE                                                  
P00836     ELSE                                                         
P00836        DISPLAY '*********PCSCA293 ABORT ***********'             
P00836        DISPLAY '7200-SELECT-BATCH-EMAIL-ID'                      
P00836        DISPLAY 'RETURN CODE ='  WS-ACTIVE-RETURN-CODE            
P00836        DISPLAY 'ACCOUNT_NO  ='  AE-ACCOUNT-NO                    
P00836        DISPLAY '******** PROCESSING TERMINATED ****'             
P00836        PERFORM 9905-ABEND                     THRU 9905-EXIT     
P00836     END-IF.                                                      
P00836                                                                  
P00836 7200-EXIT.                                                       
P00836     EXIT.                                                        
P00836*                                                                 17952200
      *================================================================*17953000
      * EXTRACT ROWS FOR APPL PROGRAM ID'S.                             17960000
      *================================================================*17970000
      *                                                                 17980000
       7600-OPEN-APPL-PGM-DESC.                                         
      *                                                                 18000000
           EXEC SQL                                                     
               OPEN APPL_PGM_DESC                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
               MOVE 'K9'            TO WS-DB2-TABLE-ID                  
               MOVE 'OPEN'          TO WS-DB2-FUNCTION                  
               MOVE SQLCODE         TO WS-DB2-RETURN-CODE               
               MOVE '293'           TO WS-DB2-MODULE-ID                 
               MOVE '7600'          TO WS-DB2-PARAGRAPH                 
               DISPLAY '*** IN 7600-OPEN-APPL-PGM-DESC ***'             
               DISPLAY '*** CURSOR OPEN APPL_PGM_DESC  ***'             
               DISPLAY '*** SQLCODE     = ' SQLCODE                     
               MOVE 12              TO RETURN-CODE                      
A04149         PERFORM 9905-ABEND THRU 9905-EXIT                        
           END-IF.                                                      
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18190000
       7610-FETCH-APPL-PGM-DESC.                                        
           EXEC SQL                                                     
               FETCH APPL_PGM_DESC                                      
                INTO :K9-APPL-PROGRAM-ID,                               
                     :K9-APPL-PROGRAM-DESC,                             
                     :K9-BILL-PRINT-DESC                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE 'K9'         TO WS-DB2-TABLE-ID                 
                   MOVE 'FETCH'      TO WS-DB2-FUNCTION                 
                   MOVE SQLCODE      TO WS-DB2-RETURN-CODE              
                   MOVE '293'        TO WS-DB2-MODULE-ID                
                   MOVE '7610'       TO WS-DB2-PARAGRAPH                
                   MOVE 12           TO RETURN-CODE                     
                   DISPLAY '*** IN 7610-FETCH-APPL-PGM-DESC ***'        
                   DISPLAY '*** CURSOR OPEN APPL_PGM_DESC  ***'         
                   DISPLAY '*** SQL CODE = ' SQLCODE                    
A04149             PERFORM 9905-ABEND THRU 9905-EXIT                    
           END-EVALUATE.                                                
      *                                                                 18440000
       7610-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18470000
       7620-CLOSE-APPL-PGM-DESC.                                        
      *                                                                 18490000
           EXEC SQL                                                     
               CLOSE APPL_PGM_DESC                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
               MOVE 'K9'            TO WS-DB2-TABLE-ID                  
               MOVE 'CLOSE'         TO WS-DB2-FUNCTION                  
               MOVE SQLCODE         TO WS-DB2-RETURN-CODE               
               MOVE '293'           TO WS-DB2-MODULE-ID                 
               MOVE '7620'          TO WS-DB2-PARAGRAPH                 
               DISPLAY '*** IN 7620-CLOSE-APPL-PGM-DESC ***'            
               DISPLAY '*** CURSOR OPEN APPL_PGM_DESC   ***'            
               DISPLAY '*** SQLCODE     = ' SQLCODE                     
               MOVE 12              TO RETURN-CODE                      
A04149         PERFORM 9905-ABEND THRU 9905-EXIT                        
           END-IF.                                                      
       7620-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18680000
      ************************************************************      18690000
      *  READ THE REGULAR BILL FILE                              *      18700000
      ************************************************************      18710000
                                                                        
       7900-READ-INPUT.                                                 
                                                                        
           READ FCSCA293-FILE AT END                                    
               MOVE WS-Y TO WS-END-OF-CA293.                            
           IF FCA293-SUCCESSFUL OR END-OF-CA293                         
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA293 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR READING FCSCA293       **'       
               DISPLAY '**     FILE STATUS = ' WS-FCA293-STATUS         
               DISPLAY '****************************************'       
A04149         PERFORM 9905-ABEND THRU 9905-EXIT                        
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18910000
       8000-WRITE-STMT.                                                 
      *                                                                 18930000
           MOVE WS-COMPANY-NO              TO KEY-L1-COMP-NO.           
           MOVE WS-STMT-ACCOUNT-NO         TO KEY-L2-ACCOUNT-NO.        
           MOVE WS-CURRENT-DATE            TO KEY-L2-DATE-BILLED.       
           MOVE SPACES                     TO FIOBE293-DATA-REC.        
           MOVE WS-EXT-IO-AREA             TO FIOBE293-DATA-REC.        
           WRITE FIOBE293.                                              
                                                                        
           IF FBE293-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '8000-ERROR ON FCSBE293 WRITE.  STATUS IS '      
                        WS-FBE293-STATUS                                
A04149         PERFORM 9905-ABEND          THRU 9905-EXIT               
           END-IF.                                                      
      *                                                                 19080000
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  19120000
      *   8300-INSERT-COMM-DATA                                      *  19130000
      ****************************************************************  19140000
       8300-INSERT-COMM-DATA.                                           
      *                                                                 19160000
           EXEC SQL                                                     
                INSERT INTO CSS_COMM_DATA                               
                        (COMMUNICATION_ID,                              
                         ACCOUNT_NO,                                    
                         CUSTOMER_NO,                                   
                         PREMISE_NO,                                    
                         COMPANY_NO,                                    
                         RED_FLAG_IND,                                  
                         RED_FLAG_EXPIRE_DT,                            
                         COMM_METHOD,                                   
                         COMM_DIRECTION,                                
                         COMM_TYPE_CD,                                  
                         COMM_SUBTYPE_CODE,                             
                         USER_ID_ORIG,                                  
                         CONTACT_NAME,                                  
                         PROMOTION_ID,                                  
                         PSC_COMPLIANCE_IND,                            
                         CALL_ORIGIN_ID,                                
                         CALL_END_TIME,                                 
                         NUMBER_TRANSFERS,                              
                         HOLD_TIME,                                     
                         QUEUE_TIME,                                    
                         SCREEN_POP_IND,                                
                         TOTAL_CALL_TIME,                               
                         INITIAL_COMMENT_TX,                            
                         RESPONSE_REASON_CD,                            
                         RESPONSE_TYPE_CD,                              
                         SOLICITATION_CD,                               
                         COMM_ASSOC_CD,                                 
                         COMPLAINT_FL,                                  
                         DISCOVERY_MTHD_CD,                             
                         PREV_MARKETER_CD)                              
                VALUES   (CIS.CURRENT$TIMESTAMP(),                            
                         :KO-ACCOUNT-NO,                                
                         :KO-CUSTOMER-NO,                               
                         :KO-PREMISE-NO,                                
                         :KO-COMPANY-NO,                                
                         :KO-RED-FLAG-IND,                              
                         CIS.CHAR2TIMESTAMP(:KO-RED-FLAG-EXPIRE-DT 
                                            :WS-RED-FL-NULL-IND),     
                         :KO-COMM-METHOD,                               
                         :KO-COMM-DIRECTION,                            
                         :KO-COMM-TYPE-CD,                              
                         :KO-COMM-SUBTYPE-CODE,                         
                         :KO-USER-ID-ORIG,                              
                         :KO-CONTACT-NAME,                              
                         :KO-PROMOTION-ID,                              
                         :KO-PSC-COMPLIANCE-IND,                        
                         :KO-CALL-ORIGIN-ID,                            
                         CIS.CHAR2TIMESTAMP(:KO-CALL-END-TIME 
                                            :WS-END-NULL-IND),             
                         :KO-NUMBER-TRANSFERS,                          
                         :KO-HOLD-TIME,                                 
                         :KO-QUEUE-TIME,                                
                         :KO-SCREEN-POP-IND,                            
                         :KO-TOTAL-CALL-TIME,                           
                         :KO-INITIAL-COMMENT-TX,                        
                         :KO-RESPONSE-REASON-CD,                        
                         :KO-RESPONSE-TYPE-CD,                          
                         :KO-SOLICITATION-CD,                           
                         :KO-COMM-ASSOC-CD,                             
                         :KO-COMPLAINT-FL,                              
                         :KO-DISCOVERY-MTHD-CD,                         
                         :KO-PREV-MARKETER-CD)                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     19170000
MFA-TR*         INSERT INTO CSS_COMM_DATA                               19180000
MFA-TR*                 (COMMUNICATION_ID,                              19190000
MFA-TR*                  ACCOUNT_NO,                                    19200000
MFA-TR*                  CUSTOMER_NO,                                   19210000
MFA-TR*                  PREMISE_NO,                                    19220000
MFA-TR*                  COMPANY_NO,                                    19230000
MFA-TR*                  RED_FLAG_IND,                                  19240000
MFA-TR*                  RED_FLAG_EXPIRE_DT,                            19250000
MFA-TR*                  COMM_METHOD,                                   19260000
MFA-TR*                  COMM_DIRECTION,                                19270000
MFA-TR*                  COMM_TYPE_CD,                                  19280000
MFA-TR*                  COMM_SUBTYPE_CODE,                             19290000
MFA-TR*                  USER_ID_ORIG,                                  19300000
MFA-TR*                  CONTACT_NAME,                                  19310000
MFA-TR*                  PROMOTION_ID,                                  19320000
MFA-TR*                  PSC_COMPLIANCE_IND,                            19330000
MFA-TR*                  CALL_ORIGIN_ID,                                19340000
MFA-TR*                  CALL_END_TIME,                                 19350000
MFA-TR*                  NUMBER_TRANSFERS,                              19360000
MFA-TR*                  HOLD_TIME,                                     19370000
MFA-TR*                  QUEUE_TIME,                                    19380000
MFA-TR*                  SCREEN_POP_IND,                                19390000
MFA-TR*                  TOTAL_CALL_TIME,                               19400000
MFA-TR*                  INITIAL_COMMENT_TX,                            19410000
MFA-TR*                  RESPONSE_REASON_CD,                            19420000
MFA-TR*                  RESPONSE_TYPE_CD,                              19430000
MFA-TR*                  SOLICITATION_CD,                               19440000
MFA-TR*                  COMM_ASSOC_CD,                                 19450000
MFA-TR*                  COMPLAINT_FL,                                  19460000
MFA-TR*                  DISCOVERY_MTHD_CD,                             19470000
MFA-TR*                  PREV_MARKETER_CD)                              19480000
MFA-TR*         VALUES   (CURRENT TIMESTAMP,                            19490000
MFA-TR*                  :KO-ACCOUNT-NO,                                19500000
MFA-TR*                  :KO-CUSTOMER-NO,                               19510000
MFA-TR*                  :KO-PREMISE-NO,                                19520000
MFA-TR*                  :KO-COMPANY-NO,                                19530000
MFA-TR*                  :KO-RED-FLAG-IND,                              19540000
MFA-TR*                  :KO-RED-FLAG-EXPIRE-DT:WS-RED-FL-NULL-IND,     19550000
MFA-TR*                  :KO-COMM-METHOD,                               19560000
MFA-TR*                  :KO-COMM-DIRECTION,                            19570000
MFA-TR*                  :KO-COMM-TYPE-CD,                              19580000
MFA-TR*                  :KO-COMM-SUBTYPE-CODE,                         19590000
MFA-TR*                  :KO-USER-ID-ORIG,                              19600000
MFA-TR*                  :KO-CONTACT-NAME,                              19610000
MFA-TR*                  :KO-PROMOTION-ID,                              19620000
MFA-TR*                  :KO-PSC-COMPLIANCE-IND,                        19630000
MFA-TR*                  :KO-CALL-ORIGIN-ID,                            19640000
MFA-TR*                  :KO-CALL-END-TIME:WS-END-NULL-IND,             19650000
MFA-TR*                  :KO-NUMBER-TRANSFERS,                          19660000
MFA-TR*                  :KO-HOLD-TIME,                                 19670000
MFA-TR*                  :KO-QUEUE-TIME,                                19680000
MFA-TR*                  :KO-SCREEN-POP-IND,                            19690000
MFA-TR*                  :KO-TOTAL-CALL-TIME,                           19700000
MFA-TR*                  :KO-INITIAL-COMMENT-TX,                        19710000
MFA-TR*                  :KO-RESPONSE-REASON-CD,                        19720000
MFA-TR*                  :KO-RESPONSE-TYPE-CD,                          19730000
MFA-TR*                  :KO-SOLICITATION-CD,                           19740000
MFA-TR*                  :KO-COMM-ASSOC-CD,                             19750000
MFA-TR*                  :KO-COMPLAINT-FL,                              19760000
MFA-TR*                  :KO-DISCOVERY-MTHD-CD,                         19770000
MFA-TR*                  :KO-PREV-MARKETER-CD)                          19780000
MFA-TR*    END-EXEC.                                                    19790000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 19800000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 19820000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE 'KO'                  TO WS-DB2-TABLE-ID             
              MOVE 'INSERT'              TO WS-DB2-FUNCTION             
              MOVE SQLCODE               TO WS-DB2-RETURN-CODE          
              MOVE '293'                 TO WS-DB2-MODULE-ID            
              MOVE '8300'                TO WS-DB2-PARAGRAPH            
              DISPLAY '*** IN 8300-INSERT-COMM-DATA    ***'             
              DISPLAY '*** INSERT CSS_COMM_DATA        ***'             
              DISPLAY '*** SQLCODE     = ' SQLCODE                      
              MOVE 'CSS_COMM_DATA'       TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE KO-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE KO-CUSTOMER-NO        TO HOSTVAR-ELEMENT-2           
              MOVE 12                    TO RETURN-CODE                 
A04149        PERFORM 9905-ABEND THRU 9905-EXIT                         
           END-IF.                                                      
      *                                                                 20020000
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20050000
P00836****************************************************************  20190000
P00836*   8400-INSERT-CSS-BATCH-EMAIL                                *  20200000
P00836****************************************************************  20210000
P00836 8400-INSERT-CSS-BATCH-EMAIL.                                     
P00836*                                                                 20230000
P00836     EXEC SQL                                                     
P00836          INSERT INTO CSS_BATCH_EMAIL                             
P00836                 (ACCOUNT_NO                                      
P00836                 ,CUSTOMER_NO                                     
P00836                 ,EMAIL_EVENT_CD                                  
P00836                 ,EMAIL_EVENT_DT                                  
ACT070                 ,BATCH_EMAIL_ID                                  
P00836                 ,COMPANY_NO)                                     
P00836          VALUES                                                  
P00836                 (:AE-ACCOUNT-NO                                  
P00836                 ,:AE-CUSTOMER-NO                                 
P00836                 ,:AE-EMAIL-EVENT-CD                              
P00836                 ,IIF(TRY_CONVERT(DATE, :AE-EMAIL-EVENT-DT
              ) IS NULL OR (PATINDEX('%.%', :AE-EMAIL-EVENT-DT
              ) <> 0) OR (LEN(:AE-EMAIL-EVENT-DT
              ) <> 10), CIS.CHAR2DATE(:AE-EMAIL-EVENT-DT
              ), CONVERT(DATE, :AE-EMAIL-EVENT-DT) )                           
ACT070                 ,:AE-BATCH-EMAIL-ID                              
P00836                 ,:AE-COMPANY-NO)                                 
P00836     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     20240000
MFA-TR*         INSERT INTO CSS_BATCH_EMAIL                             20250000
MFA-TR*                (ACCOUNT_NO                                      20260000
MFA-TR*                ,CUSTOMER_NO                                     20270000
MFA-TR*                ,EMAIL_EVENT_CD                                  20280000
MFA-TR*                ,EMAIL_EVENT_DT                                  20290000
MFA-TR*                ,BATCH_EMAIL_ID                                  20291000
MFA-TR*                ,COMPANY_NO)                                     20300000
MFA-TR*         VALUES                                                  20310000
MFA-TR*                (:AE-ACCOUNT-NO                                  20320000
MFA-TR*                ,:AE-CUSTOMER-NO                                 20330000
MFA-TR*                ,:AE-EMAIL-EVENT-CD                              20340000
MFA-TR*                ,:AE-EMAIL-EVENT-DT                              20350000
MFA-TR*                ,:AE-BATCH-EMAIL-ID                              20351000
MFA-TR*                ,:AE-COMPANY-NO)                                 20360000
MFA-TR*    END-EXEC                                                     20370000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836*                                                                 20380000
P00836     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00836*                                                                 20400000
P00836     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00836         CONTINUE                                                 
P00836     ELSE                                                         
P00836        DISPLAY '*********PCSCA293 ABORT ***********'             
P00836        DISPLAY '8400-INSERT-CSS-BATCH-EMAIL'                     
P00836        DISPLAY 'RETURN CODE ='  WS-ACTIVE-RETURN-CODE            
P00836        DISPLAY 'ACCOUNT_NO  ='  AE-ACCOUNT-NO                    
P00836        DISPLAY '******** PROCESSING TERMINATED ****'             
P00836        PERFORM 9905-ABEND             THRU 9905-EXIT             
P00836     END-IF.                                                      
P00836                                                                  
P00836 8400-EXIT.                                                       
P00836     EXIT.                                                        
P00836*                                                                 20570000
P00836****************************************************************  20980000
P00836*  8500-INSERT-CSS-BTCH-EMAIL-DET                              *  20990000
P00836****************************************************************  21000000
P00836*                                                                 21010000
P00836 8500-INSERT-CSS-BTCH-EMAIL-DET.                                  
P00836*                                                                 21030000
P00836     MOVE '8500'                     TO WS-ACTIVE-PARAGRAPH.      
P00836                                                                  
P00836     EXEC SQL                                                     
P00836       INSERT INTO CSS_BTCH_EMAIL_DET                             
P00836              (BATCH_EMAIL_ID                                     
P00836              ,FIELD_NAME_TX                                      
P00836              ,FIELD_VALUE_TX)                                    
P00836       VALUES                                                     
P00836              (:JK-BATCH-EMAIL-ID                                 
P00836              ,:JK-FIELD-NAME-TX                                  
P00836              ,:JK-FIELD-VALUE-TX)                                
P00836     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00836                                                                  
P00836     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00836        CONTINUE                                                  
P00836     ELSE                                                         
P00836        DISPLAY '*********PCSCA293 ABORT ***********'             
P00836        DISPLAY '8500-INSERT-CSS-BTCH-EMAIL-DET'                  
P00836        DISPLAY 'RETURN CODE ='  WS-ACTIVE-RETURN-CODE            
P00836        DISPLAY 'ACCOUNT_NO  ='  AE-ACCOUNT-NO                    
P00836        DISPLAY '******** PROCESSING TERMINATED ****'             
P00836        PERFORM 9905-ABEND                     THRU 9905-EXIT     
P00836     END-IF.                                                      
P00836                                                                  
P00836 8500-EXIT.                                                       
P00836     EXIT.                                                        
      *                                                                 21390000
       9000-SEND-ERROR-RESULT.                                          
           GO TO 9000-EXIT.                                             
      *                                                                 21420000
                                                                        
       9000-TERMINATE.                                                  
      *                                                                 21450000
           CLOSE FCSCA293-FILE                                          
                 FCSBE293-FILE.                                         
      *                                                                 21480000
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9200-SCSCA-ERROR.                                                
                                                                        
           MOVE 12 TO RETURN-CODE.                                      
           DISPLAY ' '.                                                 
           DISPLAY '********************************************'.      
           DISPLAY '**  CALLED PGM  = ' WS-DISPLAY-SCSCA.               
           DISPLAY '**  RETURN CODE = ' WS-SCSCA-RETURN-CODE.           
           DISPLAY '**  ACCOUNT     = ' WS-ACCOUNT-NO.                  
           DISPLAY '********************************************'.      
           DISPLAY ' '.                                                 
A04149     PERFORM 9905-ABEND THRU 9905-EXIT.                           
                                                                        
       9200-EXIT.                                                       
           EXIT.                                                        
                                                                        
A04149 9700-PROCESS-ABEND.                                              
A04149     MOVE RS-RETURN-CODE           TO RS-RETURN-CODE-DISP.        
A04149*                                                                 21690000
A04149     DISPLAY '*********************************************'      
A04149     DISPLAY '** COMPONENT ABEND   ' ABEND-PROGRAM                
A04149     DISPLAY '** ERROR IN PARA     ' ACTIVE-PARAGRAPH             
A04149     DISPLAY '** DB2 RETURN CODE   ' RS-RETURN-CODE-DISP          
A04149     DISPLAY '** ABEND FUNCTION    ' ABEND-FUNCTION               
A04149     DISPLAY '** TABLE 1           ' TABLE-1                      
A04149     DISPLAY '** TABLE ELEMENT 1   ' TABLE-ELEMENT-1              
A04149     DISPLAY '** HOSTVAR ELEMENT 1 ' HOSTVAR-ELEMENT-1            
A04149     DISPLAY '** TABLE 2           ' TABLE-2                      
A04149     DISPLAY '** TABLE ELEMENT 2   ' TABLE-ELEMENT-2              
A04149     DISPLAY '** HOSTVAR ELEMENT 2 ' HOSTVAR-ELEMENT-2            
A04149     DISPLAY '** TABLE 3           ' TABLE-3                      
A04149     DISPLAY '** TABLE ELEMENT 3   ' TABLE-ELEMENT-3              
A04149     DISPLAY '** HOSTVAR ELEMENT 3 ' HOSTVAR-ELEMENT-3            
A04149     DISPLAY '** TABLE 4           ' TABLE-4                      
A04149     DISPLAY '** TABLE ELEMENT 4   ' TABLE-ELEMENT-4              
A04149     DISPLAY '** HOSTVAR ELEMENT 4 ' HOSTVAR-ELEMENT-4            
A04149     DISPLAY '*********************************************'      
A04149     PERFORM 9905-ABEND                THRU 9905-EXIT.            
A04149                                                                  
A04149 9700-EXIT.                                                       
A04149     EXIT.                                                        
      *                                                                 21920000
       9900-SQL-ERROR-ROUTINE.                                          
A04149     GO TO 9905-EXIT.                                             
      ******************************************************************21950000
      * RETURNS TO CALLING PROGRAM UNDER ABNORMAL CONDITIONS WITH A    *21960000
      * APPROPRIATE MESG AND RETURN-CODE                               *21970000
      ******************************************************************21980000
A04149 9905-ABEND.                                                      
      *                                                                 22000000
           MOVE TABLE-1                       TO WS-DB2-TABLE-ID.       
           MOVE ABEND-FUNCTION                TO WS-DB2-FUNCTION.       
           MOVE RS-RETURN-CODE                TO WS-DB2-RETURN-CODE.    
A04149     MOVE '293'                         TO WS-DB2-MODULE-ID.      
           MOVE ACTIVE-PARAGRAPH              TO WS-DB2-PARAGRAPH.      
           MOVE HOSTVAR-ELEMENT-1             TO WS-DB2-KEY-1.          
           MOVE HOSTVAR-ELEMENT-2             TO WS-DB2-KEY-2.          
           MOVE HOSTVAR-ELEMENT-3             TO WS-DB2-KEY-3.          
           MOVE HOSTVAR-ELEMENT-4             TO WS-DB2-KEY-4.          
           MOVE 12                            TO RETURN-CODE.           
           PERFORM 9999-BAIL-OUT THRU 9999-EXIT.                        
      *                                                                 22120000
A04149 9905-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22150000
       9910-MISC-ERROR.                                                 
      *                                                                 22170000
           IF LS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16 TO RETURN-CODE                                    
           ELSE                                                         
              DISPLAY WS-MISCELLANEOUS-MESSAGE                          
      *       ADD 1 TO LS-CURR-WQ-ITEM                                  22240000
      *       SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    22250000
      *                                                                 22260000
      *       MOVE WS-MISCELLANEOUS-MESSAGE                             22270000
      *         TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)        22280000
      *                                                                 22290000
      *       MOVE ZEROES        TO WS-BILL-NO-WQ                       22300000
      *       MOVE SPACES TO WS-CODE-UTIL-TYPE-WQ                       22310000
      *                      WS-RATE-PLAN-NO-WQ                         22320000
      *       MOVE ZEROES TO WS-IC-NO-WQ                                22330000
      *                                                                 22340000
      *       COMPUTE WS-START-POS                                      22350000
      *         = WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX) + 1              22360000
      *       MOVE WS-SUPPLEMENTAL-TXT-WQ                               22370000
      *         TO WS-COMMENTS-TEXT-WF (WS-BILL-WQ-INDX) (WS-START-POS:)22380000
      *       ADD WS-SUPPLEMENTAL-TXT-LEN-WQ                            22390000
      *         TO WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX)                 22400000
           END-IF.                                                      
      *                                                                 22420000
       9910-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22450000
       9998-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                         TO SEND-DONE-SW.            
           MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE.          
                                                                        
       9998-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-BAIL-OUT.                                                   
      *                                                                 22550000
           MOVE RETURN-CODE              TO WS-SCSCA-RETURN-CODE.       
           STOP RUN.                                                    
      *                                                                 22580000
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22610000
