       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSCA291.                                         
       AUTHOR.        VIJAY VEMULA.                                     
       DATE-WRITTEN.  SEPTEMBER 2012.                                   
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *-                SOUTH CAROLINA ELECTRIC & GAS                -*         
      *-                                                             -*         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *-                      PROGRAM NARRATIVE                      -*         
      *-  PURPOSE--#                                                 -*         
      *-                                                             -*         
      *-  PRE-BILLING PROGRAM FOR BILLING MICHELIN TWIN ACCOUNTS.    -*         
      *-                                                             -*         
      *-  PROGRAM INPUT--#                                           -*         
      *-    1. COMBINED DB07 FILE (ALL PARTITIONS).                  -*         
      *-    2. CSS_UTL_BILL_REL.                                     -*         
      *-                                                             -*         
      *-  SUMMARY--#                                                 -*         
      *-                                                             -*         
      *-  PROGRAM RUN IN NIGHTLY BATCH AFTER PCSCA099 USING DB07.    -*         
      *-  MASTER DEPENDANT RELATION WILL BE USED TO LINK THE ACTUAL  -*         
      *-  MICHELIN ACCOUNTS WITH THE DUMMY MASTER ACCOUNT. USING     -*         
      *-  THE COMBINED IDR DATA FOR THE SUB ACCOUNTS PROGRAM WILL    -*         
      *-  CALCULATE THE PENALTY/CREDIT FACTORS AND UPDATE FF/FH FOR  -*         
      *-  SUB ACCOUNTS. MASTER ACCOUNT WILL GO THRU NORMAL BILLING   -*         
      *-  AND GENERATE A $0.00 BILL (NON-UTILITY COMPONENT) AND SUB  -*         
      *-  ACCOUNTS WILL BILL INDIVIDUALLY WITH THE CREDIT/PENALTY    -*         
      *-  FACTORS CREATED BY THIS PROGRAM.                           -*         
      *-                                                             -*         
      *-  FOLLOWING FACTORS WOULD BE CALCULATED FOR THE SUB ACCOUNTS -*         
      *-  A. COINCIDENTAL DEMAND CREDIT (MICHCODMD)                  -*         
      *-                  SPECIAL CALC CODE = 'CN'                   -*         
      *-  B. COINCIDENTAL CONTRACT DEMAND ADJUSTMENT (MICHCTDEM)     -*         
      *-                  SPECIAL CALC CODE = 'CC'                   -*         
      *-  C. COINCIDENTAL POWER FACTOR DEMAND ADJUSTMENT (MICHPFDEM) -*         
      *-                  SPECIAL CALC CODE = 'CP'                   -*         
      *-  D. COINCIDENTAL RATCHET DEMAND ADJUSTMENT (MICHRTDEM)      -*         
      *-                  SPECIAL CALC CODE = 'CR'                   -*         
      *-  E. ECONONOMIC DEVELOPMENT/EXPANSION CREDIT (MICHLNEDC)     -*         
      *-                  SPECIAL CALC CODE = 'CB'                   -*         
      *-                                                             -*         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      *-              PROGRAM  MODIFICATION  LOG                     -*         
      *-                                                             -*         
      *-   DATE     INITIALS   REASON                                -*         
      *- --------   --------   ---------------------------------     -*         
A03956*- 09/11/12   VIJAY      INITIAL IMPLEMENTATION.               -*         
      *-                       AUTOMATE BILLING FOR MICHELIN ACCOUNTS-*         
      *-                                                             -*         
ACT021*- 03/01/13   VIJAY      SUPPORT EXTRACTION OF MASTER AND SUB  -*         
      *- A04527                ACCOUNTS ON THE SAME DAY(REMOVED CODE- *         
      *-                       ACCT-BILLED CHECK).                   -*         
ACT079** 06/06/13   VIJAY      EXCLUDE BACKUP METERS.                -*         
ACT079** A04527                                                      -*         
ACT184** 10/31/13   VIJAY      FIX -811 ISSUE IN GETTING BASE LINE   -*         
ACT184** A04527                UNITS(7080-GET-BASELINE-UNITS)        -*         
A04860** 12/06/14   AS7C117    REPLACE CSS_WQ_ITEMS_MF WITH          **         
A04860**            ACT047     CSS_WQ_ITEMS.                         **         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
       ENVIRONMENT DIVISION.                                            
                                                                        
       CONFIGURATION SECTION.                                           
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
       COPY CSSDB07.                                                            
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDDB07.                                                            
       COPY FIODB07.                                                            
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA291'.
MSQ017     COPY MFASQLM.
                                                                        
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE               PIC S9(04) COMP VALUE 0.    
           05  RS-RETURN-CODE-DISP          PIC +Z(04).                 
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05  WS-FCSDB07-REC-CNTR          PIC S9(07) VALUE 0 COMP-3.  
           05  WS-PARTITION-NO              PIC 9(02)  VALUE ZEROES.    
           05  WS-ACCOUNT-NO                PIC 9(13)  VALUE ZEROES.    
           05  WS-COMPANY-NO                PIC X(02)  VALUE SPACES.    
           05  WS-BILL-CYCLE                PIC X(02)  VALUE SPACES.    
           05  WS-CODE-BILL-OFF-CYCL        PIC X(01)  VALUE SPACES.    
           05  WS-UTLBILLREL-COUNT          PIC 9(05)  VALUE 0.         
           05  WS-MASTER-ACCOUNTS-COUNT     PIC 9(05)  VALUE 0.         
           05  WS-WORK-DATE.                                            
               10  WS-WORK-DATE-YR          PIC 9999   VALUE ZEROS.     
               10  WS-WORK-DATE-FIL1        PIC X(01)  VALUE SPACES.    
               10  WS-WORK-DATE-MM          PIC 99     VALUE ZEROS.     
               10  WS-WORK-DATE-FIL2        PIC X(01)  VALUE SPACES.    
               10  WS-WORK-DATE-DD          PIC 99     VALUE ZEROS.     
           05  WS-REVENUE-MONTH             PIC 9(06)  VALUE ZEROES.    
           05  WS-REVENUE-MONTH-JP          PIC 9(06)  VALUE ZEROES.    
           05  WS-REV-MTH-LST-NRML          PIC S9(06)V  COMP-3         
                                                       VALUE ZEROES.    
           05  WS-PREV-REVENUE-MONTH        PIC S9(06)V  COMP-3         
                                                       VALUE ZEROES.    
           05  WS-OLDEST-REV-MONTH          PIC S9(06)V  COMP-3         
                                                       VALUE ZEROES.    
           05  WS-REV-COUNT                 PIC 9(02)  VALUE ZEROES.    
           05  WS-INDEX                     PIC 9(02)  VALUE ZEROES.    
           05  WS-EDC-DEMAND-PRICE          PIC S9(5)V9(2) COMP-3       
                                                       VALUE ZEROES.    
           05  WS-DEMAND-PRICE              PIC S9(5)V9(2) COMP-3       
                                                       VALUE ZEROES.    
           05  WS-CALC-COIN-KW              PIC S9(9)  COMP-3 VALUE +0. 
           05  WS-CALC-COIN-KVAR            PIC S9(9)  COMP-3 VALUE +0. 
           05  WS-ACTUAL-MAX-KW             PIC S9(9)  COMP-3 VALUE +0. 
           05  WS-NULL-IND-1                PIC S9(04) COMP VALUE +0.   
           05  WS-NULL-IND-2                PIC S9(04) COMP VALUE +0.   
                                                                        
                                                                        
       01  WS-MASTER-ACCOUNTS-TABLE.                                    
           05  WS-MASTER-ACCOUNT-DATA OCCURS 10 TIMES                   
                                INDEXED BY WS-MAST-TBL-INDX.            
COB305         10 WS-MASTER-ACCOUNT        PIC S9(13)V COMP-3 VALUE 0.        
                                                                        
       01  WS-UR-TABLE.                                                 
           05  WS-UR-TABLE-DATA OCCURS 10 TIMES                         
                                INDEXED BY WS-UR-TBL-INDX.              
COB305         10 WS-UR-ACCOUNT-NO-DEP        PIC S9(13)V COMP-3 
COB305           VALUE 0.        
               10  WS-UR-CODE-UTIL-TYPE-DEP PIC X(01).                  
               10  WS-UR-IC-NO-DEP          PIC S9(04)   COMP.          
               10  WS-UR-MTR-REF-NO-DEP     PIC S9(04)   COMP.          
               10  WS-UR-DEP-REL-START-DT   PIC X(10).                  
COB305         10 WS-UR-ACCOUNT-NO-MST        PIC S9(13)V COMP-3 
COB305           VALUE 0.        
               10  WS-UR-CODE-UTIL-TYPE-MST PIC X(01).                  
               10  WS-UR-IC-NO-MST          PIC S9(04)   COMP.          
               10  WS-UR-MTR-REF-NO-MST     PIC S9(04)   COMP.          
               10  WS-UR-CODE-RELATION-TYPE PIC X(01).                  
               10  WS-UR-METER-NO-DEP       PIC X(09).                  
                                                                        
                                                                        
       01  WS-MAST-DATA.                                                
COB305     05 WS-MAST-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.        
           05  WS-MAST-BILL-ITEM-TIMESTMP   PIC X(26).                  
           05  WS-MAST-BILL-NO              PIC S9(09)   COMP.          
           05  WS-MAST-CODE-UTIL-TYPE       PIC X(01).                  
           05  WS-MAST-IC-NO                PIC S9(04)   COMP.          
           05  WS-MAST-REVENUE-MONTH        PIC 9(06)    VALUE ZEROS.   
COB305     05 WS-MAST-REV-MTH-ORIG-BILL        PIC S9(06)V COMP-3 
COB305       VALUE 0.        
           05  WS-MAST-NET-UNIT-SEL-RSN     PIC X(01).                  
COB305     05 WS-MAST-NET-UNITS        PIC S9(9) COMP-3 VALUE 0.        
COB305     05 WS-MAST-READ-UNITS        PIC S9(9)V99 COMP-3 VALUE 0.        
COB305     05 WS-MAST-MIN-PF        PIC S99V999 COMP-3 VALUE 0.        
COB305     05 WS-MAST-PF-PENALTY-KW        PIC S9(9) COMP-3 VALUE 0.        
COB305     05 WS-MAST-EXP-LOAD-KW        PIC S9(9) COMP-3 VALUE 0.        
           05  WS-MAST-PEAK-DATE-READ       PIC X(10).                  
           05  WS-MAST-PEAK-TIME-READ       PIC X(08).                  
COB305     05 WS-COIN-TOT-PENALTY-KW        PIC S9(9) COMP-3 VALUE 0.        
COB305     05 WS-TOT-COIN-EXP-LOAD-KW        PIC S9(9) COMP-3 VALUE 0.        
COB305     05 WS-TOT-POS-EXP-LOAD-KW        PIC S9(9) COMP-3 VALUE 0.        
COB305     05 WS-TOT-COIN-EDC-AMT        PIC S9(9)V99 COMP-3 VALUE 0.        
COB305     05 WS-MAST-EDC-DSCNT-FCTR        PIC S9(9)V9(4) USAGE COMP-3 
COB305       VALUE 0.
                                                                        
       01  WS-COIN-SUB-ACCT-TABLE.                                      
           05  WS-COIN-SUB-ACCT-DATA OCCURS 10 TIMES                    
                                     INDEXED BY WS-COIN-SUB-INDX.       
COB305         10 WS-COIN-ACCT-NO        PIC S9(13)V COMP-3 VALUE 0.      
               10  WS-COIN-BILL-NO          PIC S9(09)     COMP.        
               10  WS-COIN-CODE-UTIL-TYPE   PIC X(01).                  
               10  WS-COIN-IC-NO            PIC S9(04)     COMP.        
               10  WS-COIN-REBILL-IND       PIC X(01).                  
               10  WS-COIN-BILL-ITEM-TIMESTMP                           
                                            PIC X(26).                  
               10  WS-COIN-METER-NO         PIC X(09).                  
COB305         10 WS-COIN-KW-UNITS        PIC S9(09) COMP-3 VALUE 0.      
COB305         10 WS-COIN-KVA-UNITS        PIC S9(09) COMP-3 VALUE 0.      
COB305         10 WS-COIN-PF        PIC S9V99 COMP-3 VALUE 0.      
COB305         10 WS-COIN-PF-PENALTY-KW        PIC S9(09) COMP-3 
COB305           VALUE 0.      
COB305         10 WS-COIN-PF-PENALTY-KW-ADJ        PIC S9(09) COMP-3 
COB305           VALUE 0.      
COB305         10 WS-COIN-KW-CREDIT        PIC S9(09) COMP-3 VALUE 0.      
COB305         10 WS-COIN-CNTRCT-KW-ADJ        PIC S9(09) COMP-3 
COB305           VALUE 0.      
COB305         10 WS-COIN-RATCHET-KW-ADJ        PIC S9(09) COMP-3 
COB305           VALUE 0.      
COB305         10 WS-COIN-EXP-LOAD-KW        PIC S9(09) COMP-3 VALUE 0.      
COB305         10 WS-COIN-EXP-PCT-ALLOC        PIC S9(1)V9(2) COMP-3 
COB305           VALUE 0.      
COB305         10 WS-COIN-EXP-LOAD-EDC        PIC S9(9)V9(2) COMP-3 
COB305           VALUE 0.      
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-BEGIN-REC-SW              PIC X(01) VALUE 'N'.        
               88  WS-BEGIN-RECS-PROCESSED            VALUE 'Y'.        
           05  WS-FDB07-STATUS              PIC X(02).                  
               88  FDB07-SUCCESSFUL                   VALUE '00'.       
               88  FDB07-END-OF-FILE                  VALUE '10'.       
           05  WS-RECORD-FOUND              PIC X(01) VALUE 'N'.        
               88  DATA-RECORD-FOUND                  VALUE 'Y'.        
               88  NO-DATA-RECORD-FOUND               VALUE 'N'.        
           05  WS-NOMORE-ACCTS-FL           PIC X(01) VALUE 'N'.        
               88  WS-NOMORE-ACCTS                    VALUE 'Y'.        
           05  WS-NO-MORE-UTL-DATA-FL       PIC X(01) VALUE 'N'.        
               88  NO-MORE-UTL-DATA                   VALUE 'Y'.        
           05  WS-NO-MORE-BG-DATA-FL        PIC X(01) VALUE 'N'.        
               88  NO-MORE-BG-DATA                    VALUE 'Y'.        
           05  WS-DATABASE                  PIC 9(01) VALUE ZERO.       
               88  CSR-DATABASE                       VALUE 1.          
               88  SEB-DATABASE                       VALUE 2.          
           05  WS-COINCIDENTAL-PEAK-SW      PIC X(01) VALUE SPACES.     
               88  COINCIDENTAL-PEAK-FOUND            VALUE 'Y'.        
               88  COINCIDENTAL-PEAK-NOT-FOUND        VALUE 'N'.        
           05  WS-BASLINE-SW                PIC X(01) VALUE SPACES.     
               88  BASELINE-LOCATED                   VALUE 'Y'.        
               88  BASELINE-NOT-LOCATED               VALUE 'N'.        
           05  WS-BILL-CALL-SW              PIC X(01) VALUE SPACES.     
               88  BILL-CALL-TO-SUB                   VALUE 'Y'.        
               88  NO-BILL-CALL-TO-SUB                VALUE 'N'.        
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-Y                         PIC X(01) VALUE 'Y'.        
           05  WS-N                         PIC X(01) VALUE 'N'.        
           05  WS-ACTIVE                    PIC X(01) VALUE 'A'.        
           05  WS-OFF-CYCLE-BILL-CODE       PIC X(01) VALUE SPACES.     
           05  FINAL-BILL                   PIC X(01) VALUE 'B'.        
           05  OFF-CYC-REBILL               PIC X(01) VALUE 'O'.        
           05  WS-PGRMNAME                  PIC X(08) VALUE 'PCSCA291'. 
           05  PROGRAM-NAME                 PIC X(08) VALUE 'PCSCA291'. 
A04860     05  SCSCB077                     PIC X(08) VALUE 'SCSCB077'. 
A04860     05  WS-INPUT-TS.                                             
A04860         10 WS-INPUT-DATE-PT          PIC X(10).                  
A04860         10 WS-INPUT-TIME-PT          PIC X(16) VALUE             
A04860                                      '-00.00.00.000000'.         
                                                                        
      *****************************************************************         
      *  CWS00010  CONTAINS DB2 ABEND VARIABLES                       *         
      *****************************************************************         
       COPY CWS00010.                                                           
                                                                        
      *****************************************************************         
      *  CWS00038  JOB PARM ROUTINE                                   *         
      *****************************************************************         
       COPY CWS00038.                                                           
                                                                        
      *****************************************************************         
      *  IO AREA FOR GETTING THE REVENUE MONTH FROM CSS_JOB_PARM      *         
      *****************************************************************         
       COPY FIOJC01.                                                            
                                                                        
       COPY CWS0070B.                                                           
                                                                        
      *****************************************************************         
      *  WORKING STORAGE FOR CPD09900                                 *         
      *****************************************************************         
       COPY CWS09900.                                                           
                                                                        
      *****************************************************************         
      *  COPYBOOK WITH COMMON SQL VARIABLES                           *         
      *****************************************************************         
       COPY CWS00303.                                                           
                                                                        
      *****************************************************************         
      *  COPYBOOK FOR CPD00039                                        *         
      *****************************************************************         
       COPY CWS00039.                                                           
                                                                        
      *****************************************************************         
      *  COPYBOOK WITH JOBS FILE/TABLE DEFINITIONS                    *         
      *****************************************************************         
       COPY FIOCA00.                                                            
                                                                        
      *****************************************************************         
      *  CONTAINS COMMON SUBROUTINE DATA                              *         
      *****************************************************************         
       COPY CWS0024B.                                                           
                                                                        
      *****************************************************************         
      *  COPYBOOKS NEEDED TO CALL BILL CALCULATION ROUTINE            *         
      *****************************************************************         
                                                                        
       COPY CWS1001A.                                                           
       COPY CWS1001B.                                                           
                                                                        
       COPY CWS1000A.                                                           
       COPY CWS1000B.                                                           
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS0022B                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    DECLARATION FOR SQL COMMAND AREA                           *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_ACCOUNT, AT                                    *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_DELINQUENCY, C8                                *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_BILLING_DET, BG                                *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_BILL_ADJUSTMNT, BP                             *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBBILADJ                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_DEMAND_INSTR , DI                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBDMDINS                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_FIXED_FCTR , FF                                *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBFXDFCT                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_FIXED_FCT_HIST , FH                            *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBFXHST                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_BILL_BSLN_CNTR , LN                            *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBBLCNTB                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_JOB_PARM , JP                                  *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_CNSMPTN_HIST , CX                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBCNSMP                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_UM_CNSMPT_HIST , UC                            *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBUMCNSM                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_CUST_PLAN , CP                                 *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBCSTPLN                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_MTRD_ENVRNMT , MN                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_UTIL_ENVRNMT , UT                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_BILLING_HDR , BI                               *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_UTL_BILL_REL , UR                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBUTLREL                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_SPCL_FCTR , SF                                 *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBSPLFTR                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_INTERVAL_READ , IV                             *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBINTVRD                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSSS_READ_WINDOW , RW                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBBILWDW                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *  COPYBOOK TO CALL SCSCA107 SUB-ROUTINE                        *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CWS04517                                                  
           END-EXEC.                                                            
                                                                        
A04860*                                                                         
A04860******* FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077             
A04860      EXEC SQL                                                            
A04860           INCLUDE CWS00077                                               
A04860      END-EXEC.                                                           
      *****************************************************************         
      *  CURSOR DECLARATIONS.                                         *         
      *****************************************************************         
      **** GET MASTER ACCOUNTS                                                  
           EXEC SQL                                                     
              DECLARE MASTER_ACCT CURSOR WITH HOLD FOR                  
                 SELECT DISTINCT TOP(1) UR.ACCOUNT_NO_MST,
              UR.DEP_REL_START_DT,
              AT.BILL_CYCLE                                  
                   FROM  CSS_UTL_BILL_REL UR                            
                       , CSS_ACCOUNT      AT                            
                  WHERE  UR.CODE_RELATION_TYPE = 'C'                    
                    AND  UR.ACCOUNT_NO_MST     = AT.ACCOUNT_NO          
                  ORDER  BY UR.DEP_REL_START_DT DESC                    
                                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MASTER_ACCT CURSOR WITH HOLD FOR                          
MFA-TR*          SELECT  DISTINCT UR.ACCOUNT_NO_MST                             
MFA-TR*                , UR.DEP_REL_START_DT                                    
MFA-TR*                , AT.BILL_CYCLE                                          
MFA-TR*            FROM  CSS_UTL_BILL_REL UR                                    
MFA-TR*                , CSS_ACCOUNT      AT                                    
MFA-TR*           WHERE  UR.CODE_RELATION_TYPE = 'C'                            
MFA-TR*             AND  UR.ACCOUNT_NO_MST     = AT.ACCOUNT_NO                  
MFA-TR*           ORDER  BY UR.DEP_REL_START_DT DESC                            
MFA-TR*           FETCH FIRST ROW ONLY                                          
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
      **** GET BILLING_DET_MAST DATA                                            
           EXEC SQL                                                     
              DECLARE BILLING_DET_MAST CURSOR WITH HOLD FOR             
                 SELECT  BILL_NO                                        
                       , REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                             
                       , CODE_UTIL_TYPE                                 
                       , IC_NO                                          
                       , REVENUE_MONTH                                  
                       , REV_MTH_ORIG_BILL                              
                   FROM  CSS_BILLING_DET BG WITH(READUNCOMMITTED)               
                  WHERE  ACCOUNT_NO         = :BG-ACCOUNT-NO            
                    AND  BILL_NO            = :BG-BILL-NO               
                    AND  CODE_BILL_CALC     = 'A'                       
                    AND  CODE_BILL_ITM_TYPE = 'C'                       
                    AND  CODE_BILL_ITM_IND  = 'A'                       
                    FOR READ ONLY                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE BILLING_DET_MAST CURSOR WITH HOLD FOR                     
MFA-TR*          SELECT  BILL_NO                                                
MFA-TR*                , BILL_ITEM_TIMESTMP                                     
MFA-TR*                , CODE_UTIL_TYPE                                         
MFA-TR*                , IC_NO                                                  
MFA-TR*                , REVENUE_MONTH                                          
MFA-TR*                , REV_MTH_ORIG_BILL                                      
MFA-TR*            FROM  CSS_BILLING_DET BG                                     
MFA-TR*           WHERE  ACCOUNT_NO         = :BG-ACCOUNT-NO                    
MFA-TR*             AND  BILL_NO            = :BG-BILL-NO                       
MFA-TR*             AND  CODE_BILL_CALC     = 'A'                               
MFA-TR*             AND  CODE_BILL_ITM_TYPE = 'C'                               
MFA-TR*             AND  CODE_BILL_ITM_IND  = 'A'                               
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*         QUERYNO 7004                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
      **** GET MICHELIN MASTER DEPENDENT RELATION DATA                          
           EXEC SQL                                                     
              DECLARE UTL_BILL_REL CURSOR WITH HOLD FOR                 
               SELECT  UR.ACCOUNT_NO_DEP                                
                     , UR.CODE_UTIL_TYPE_DEP                            
                     , UR.IC_NO_DEP                                     
                     , UR.MTR_REF_NO_DEP                                
                     , UR.DEP_REL_START_DT                              
                     , UR.ACCOUNT_NO_MST                                
                     , UR.CODE_UTIL_TYPE_MST                            
                     , UR.IC_NO_MST                                     
                     , UR.MTR_REF_NO_MST                                
                     , UR.CODE_RELATION_TYPE                            
                     , MN.METER_NO                                      
                 FROM  CSS_UTL_BILL_REL   UR WITH(READUNCOMMITTED)              
                     , CSS_MTRD_ENVRNMT   MN WITH(READUNCOMMITTED)              
                WHERE  UR.CODE_RELATION_TYPE ='C'                       
                  AND  MN.ACCOUNT_NO         =  UR.ACCOUNT_NO_DEP       
                  AND  MN.CODE_UTIL_TYPE     =  UR.CODE_UTIL_TYPE_DEP   
                  AND  MN.IC_NO              =  UR.IC_NO_DEP            
                  AND  MN.MTR_REF_NO         =  UR.MTR_REF_NO_DEP       
                  AND  UR.DEP_REL_START_DT  <= IIF(TRY_CONVERT(DATE, 
                                                   :UR-DEP-REL-START-DT
              ) IS NULL OR (PATINDEX('%.%', :UR-DEP-REL-START-DT
              ) <> 0) OR (LEN(:UR-DEP-REL-START-DT
              ) <> 10), CIS.CHAR2DATE(:UR-DEP-REL-START-DT
              ), CONVERT(DATE, :UR-DEP-REL-START-DT) )     
                  AND  UR.DEP_REL_END_DT    >= IIF(TRY_CONVERT(DATE, 
                                                     :UR-DEP-REL-END-DT
              ) IS NULL OR (PATINDEX('%.%', :UR-DEP-REL-END-DT
              ) <> 0) OR (LEN(:UR-DEP-REL-END-DT
              ) <> 10), CIS.CHAR2DATE(:UR-DEP-REL-END-DT
              ), CONVERT(DATE, :UR-DEP-REL-END-DT) )       
ACT079            AND  MN.CODE_METER_STATUS <> 'B'                      
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE UTL_BILL_REL CURSOR WITH HOLD FOR                         
MFA-TR*        SELECT  UR.ACCOUNT_NO_DEP                                        
MFA-TR*              , UR.CODE_UTIL_TYPE_DEP                                    
MFA-TR*              , UR.IC_NO_DEP                                             
MFA-TR*              , UR.MTR_REF_NO_DEP                                        
MFA-TR*              , UR.DEP_REL_START_DT                                      
MFA-TR*              , UR.ACCOUNT_NO_MST                                        
MFA-TR*              , UR.CODE_UTIL_TYPE_MST                                    
MFA-TR*              , UR.IC_NO_MST                                             
MFA-TR*              , UR.MTR_REF_NO_MST                                        
MFA-TR*              , UR.CODE_RELATION_TYPE                                    
MFA-TR*              , MN.METER_NO                                              
MFA-TR*          FROM  CSS_UTL_BILL_REL   UR                                    
MFA-TR*              , CSS_MTRD_ENVRNMT   MN                                    
MFA-TR*         WHERE  UR.CODE_RELATION_TYPE ='C'                               
MFA-TR*           AND  MN.ACCOUNT_NO         =  UR.ACCOUNT_NO_DEP               
MFA-TR*           AND  MN.CODE_UTIL_TYPE     =  UR.CODE_UTIL_TYPE_DEP           
MFA-TR*           AND  MN.IC_NO              =  UR.IC_NO_DEP                    
MFA-TR*           AND  MN.MTR_REF_NO         =  UR.MTR_REF_NO_DEP               
MFA-TR*           AND  UR.DEP_REL_START_DT  <= :UR-DEP-REL-START-DT             
MFA-TR*           AND  UR.DEP_REL_END_DT    >= :UR-DEP-REL-END-DT               
MFA-TR*           AND  MN.CODE_METER_STATUS <> 'B'                              
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION          THRU 0100-EXIT.         
           PERFORM 0600-LOAD-MASTER-ACCOUNTS    THRU 0600-EXIT.         
           PERFORM 1000-PROCESS-ACCOUNTS        THRU 1000-EXIT.         
           PERFORM 9000-TERMINATE               THRU 9000-EXIT.         
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 0100-INITIALIZATION.                                          *         
      *****************************************************************         
       0100-INITIALIZATION.                                             
                                                                        
           MOVE WS-PGRMNAME                  TO G6-PROGRAM-NAME.        
           MOVE 'DATE'                       TO G6-CMND-CODE.           
                                                                        
      **** GET RUN DATE                                                         
           PERFORM 6251-GET-FJC01-DATE          THRU 6251-EXIT.         
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE                        
                                                THRU 6240-EXIT          
              MOVE WS-FCA00-COMMON-DATE      TO WS-INPUT-DATE           
           END-IF.                                                      
                                                                        
      **** GET BILL CYCLES DATA                                                 
           PERFORM 6241-GET-FCA00-BILL-CYCLES   THRU 6241-EXIT.         
                                                                        
      **** GET REVENUE-MONTH USING PROGRAM NAME                                 
           INITIALIZE WS-SYSIPT.                                        
           MOVE WS-PGRMNAME                  TO WS-PROGRAM.             
           MOVE WS-DATE                      TO WS-COMMAND.             
           MOVE ZEROS                        TO WS-SEQUENCE.            
           MOVE WS-KEY-AREA                  TO E-FJC01-KEY.            
           PERFORM 7600-START-FCSJC01           THRU 7600-EXIT.         
           PERFORM 7610-READ-FCSJC01            THRU 7610-EXIT          
                               UNTIL (REVENUE-MONTH AND INPUT-ACTIVE)   
                                                    OR END-OF-SYSIPT.   
           IF END-OF-SYSIPT                                             
      **** GET REVENUE-MONTH USING COMMON FROM JOB PARM TABLE                   
              INITIALIZE WS-SYSIPT                                      
              MOVE 'COMMON'                  TO WS-PROGRAM              
              MOVE WS-DATE                   TO WS-COMMAND              
              MOVE ZEROS                     TO WS-SEQUENCE             
              MOVE WS-KEY-AREA               TO E-FJC01-KEY             
              PERFORM 7600-START-FCSJC01        THRU 7600-EXIT          
              PERFORM 7610-READ-FCSJC01         THRU  7610-EXIT         
                               UNTIL (REVENUE-MONTH AND INPUT-ACTIVE)   
                                                       OR END-OF-SYSIPT 
              EVALUATE TRUE                                             
                 WHEN END-OF-SYSIPT                                     
                    DISPLAY '********** PCSCA291 ABORT **************'  
                    DISPLAY '*       0100-INITIALIZATION            *'  
                    DISPLAY '*  NO ACTIVE REVENUE MONTH IN COMMON   *'  
                    DISPLAY '*     PROCESSING TERMINATED            *'  
                    DISPLAY '********** PCSCA291 ABORT **************'  
                    PERFORM 9900-ABEND          THRU 9900-EXIT          
                 WHEN WS-REVENUE-MONTH-PARM NOT NUMERIC                 
                    DISPLAY '********** PCSCA291 ABORT **************'  
                    DISPLAY '*       0100-INITIALIZATION            *'  
                    DISPLAY '*    REVENUE MONTH PARM NOT NUMERIC    *'  
                    DISPLAY '*                KEY = ' E-FJC01-KEY       
                    DISPLAY '*     PROCESSING TERMINATED            *'  
                    DISPLAY '********** PCSCA291 ABORT **************'  
                    PERFORM 9900-ABEND          THRU 9900-EXIT          
                 WHEN OTHER                                             
                    PERFORM 7611-CLOSE          THRU 7611-EXIT          
                    MOVE WS-REVENUE-MONTH-PARM                          
                                             TO WS-REVENUE-MONTH-JP     
              END-EVALUATE                                              
           ELSE                                                         
              MOVE WS-REVENUE-MONTH-PARM     TO WS-REVENUE-MONTH-JP     
           END-IF.                                                      
                                                                        
           OPEN INPUT FCSDB07-FILE.                                     
                                                                        
           IF FDB07-SUCCESSFUL                                          
      **** SKIP ALL THE HEADER RECORDS                                          
              PERFORM 0500-PROCESS-BEGIN-REC    THRU 0500-EXIT          
                UNTIL E-FDB07-KEY-BREC NOT EQUAL LOW-VALUES             
           ELSE                                                         
              DISPLAY '********** PCSCA291 ABORT **************'        
              DISPLAY '*       0100-INITIALIZATION            *'        
              DISPLAY '*    ERROR OPENING FCSDB07 FILE        *'        
              DISPLAY '* FILE STATUS    : ' WS-FDB07-STATUS             
              DISPLAY '*      PROCESSING TERMINATED           *'        
              DISPLAY '********** PCSCA291 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * PROCESS BEGIN RECORD.                                          *        
      ******************************************************************        
       0500-PROCESS-BEGIN-REC.                                          
                                                                        
           PERFORM 7560-READ-FCSDB07            THRU 7560-EXIT          
                                                                        
           EVALUATE TRUE                                                
              WHEN FDB07-END-OF-FILE                                    
                 DISPLAY '********** PCSCA291 ABORT **************'     
                 DISPLAY '*       0500-PROCESS-BEGIN-REC         *'     
                 DISPLAY '*        FCSDB07 FILE IS EMPTY         *'     
                 DISPLAY '*      PROCESSING TERMINATED           *'     
                 DISPLAY '********** PCSCA291 ABORT **************'     
                 PERFORM 9900-ABEND             THRU 9900-EXIT          
                                                                        
              WHEN E-FDB07-KEY-BREC EQUAL LOW-VALUES                    
                 IF E-FDB07-CREATE-DATE-BREC NOT = WS-INPUT-DATE        
                    DISPLAY '********** PCSCA291 ABORT **************'  
                    DISPLAY '*       0500-PROCESS-BEGIN-REC         *'  
                    DISPLAY '* FCSDB07 CREATE DATE NOT = RUN DATE   *'  
                    DISPLAY '* DB07 DATE: ' E-FDB07-CREATE-DATE-BREC    
                    DISPLAY '* RUN  DATE: ' WS-INPUT-DATE               
                    DISPLAY '*      PROCESSING TERMINATED           *'  
                    DISPLAY '********** PCSCA291 ABORT **************'  
                    PERFORM 9900-ABEND          THRU 9900-EXIT          
                 END-IF                                                 
                 IF E-FDB07-DB-PART-BREC GREATER THAN ZERO              
                     MOVE  E-FDB07-DB-PART-BREC TO WS-PARTITION-NO      
                 ELSE                                                   
                    DISPLAY '*********** PCSCA291 ABORT *************'  
                    DISPLAY '*        0500-PROCESS-BEGIN-REC        *'  
                    DISPLAY '*   FCSDB07 PART NO NOT GREATER THAN 0 *'  
                    DISPLAY '*         PROCESSING TERMINATED        *'  
                    DISPLAY '*********** PCSCA291 ABORT *************'  
                    PERFORM 9900-ABEND          THRU 9900-EXIT          
                 END-IF                                                 
                                                                        
                 SET WS-BEGIN-RECS-PROCESSED TO TRUE                    
                                                                        
              WHEN WS-BEGIN-RECS-PROCESSED                              
                 IF E-FDB07-KEY-BREC EQUAL HIGH-VALUES OR LOW-VALUES    
                    IF E-FDB07-KEY-BREC EQUAL HIGH-VALUES               
                      AND NO-DATA-RECORD-FOUND                          
                      AND E-FDB07-RECORD-COUNT-EREC EQUAL ZERO          
                       DISPLAY '******* PCSCA291 MESSAGE*********'      
                       DISPLAY '*   0500-PROCESS-BEGIN-REC      *'      
                       DISPLAY '*    FCSDB07 FILE IS EMPTY      *'      
                       DISPLAY '*    PROCESSING CONTINUING...   *'      
                       DISPLAY '******* PCSCA291 ABORT **********'      
                    END-IF                                              
                 ELSE                                                   
                    SET DATA-RECORD-FOUND    TO TRUE                    
                 END-IF                                                 
                                                                        
              WHEN OTHER                                                
                 DISPLAY '********** PCSCA291 ABORT **************'     
                 DISPLAY '*       0500-PROCESS-BEGIN-REC         *'     
                 DISPLAY '*   FIRST RECORD IS NOT A CNTL REC     *'     
                 DISPLAY '*      PROCESSING TERMINATED           *'     
                 DISPLAY '********** PCSCA291 ABORT **************'     
                 PERFORM 9900-ABEND             THRU 9900-EXIT          
           END-EVALUATE.                                                
                                                                        
       0500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * LOAD MASTER ACCOUNT WS ARRAY                                  *         
      *****************************************************************         
       0600-LOAD-MASTER-ACCOUNTS.                                       
                                                                        
           INITIALIZE WS-MASTER-ACCOUNTS-TABLE.                         
           SET WS-MAST-TBL-INDX              TO 1.                      
                                                                        
           PERFORM 7000-OPEN-MASTER-ACCT        THRU 7000-EXIT.         
                                                                        
           PERFORM 7001-FETCH-MASTER-ACCT       THRU 7001-EXIT.         
                                                                        
           PERFORM UNTIL WS-NOMORE-ACCTS                                
              MOVE AT-ACCOUNT-NO             TO WS-MASTER-ACCOUNT       
                                                  (WS-MAST-TBL-INDX)    
              SET  WS-MAST-TBL-INDX UP BY 1                             
              PERFORM 7001-FETCH-MASTER-ACCT    THRU 7001-EXIT          
           END-PERFORM                                                  
                                                                        
           PERFORM 7002-CLOSE-MASTER-ACCT       THRU 7002-EXIT.         
                                                                        
       0600-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * PROCESS ACCOUNTS.                                             *         
      *****************************************************************         
       1000-PROCESS-ACCOUNTS.                                           
                                                                        
           INITIALIZE WS-MAST-DATA                                      
                      WS-COIN-SUB-ACCT-TABLE.                           
                                                                        
           IF WS-MASTER-ACCOUNTS-COUNT > 0                              
              PERFORM 1100-PROCESS-MAST-ACCTS   THRU 1100-EXIT          
                UNTIL FDB07-END-OF-FILE                                 
           END-IF.                                                      
                                                                        
           DISPLAY 'PCSCA291 COMPLETED SUCCESSFULLY'.                   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  PROCESS ALL MASTER ACCOUNTS COMPARING FROM INPUT RECORD      *         
      *****************************************************************         
       1100-PROCESS-MAST-ACCTS.                                         
                                                                        
           IF E-FDB07-KEY-BREC EQUAL HIGH-VALUES OR LOW-VALUES          
              CONTINUE                                                  
           ELSE                                                         
              PERFORM VARYING WS-MAST-TBL-INDX FROM 1 BY 1              
                UNTIL WS-MAST-TBL-INDX > WS-MASTER-ACCOUNTS-COUNT       
                   OR WS-MAST-TBL-INDX > 10                             
                 IF WS-MASTER-ACCOUNT (WS-MAST-TBL-INDX)                
                        EQUAL E-FDB07-ACCT-NO                           
                    PERFORM 1150-PROCESS-MAST-ACCTS-DET                 
                                                THRU 1150-EXIT          
                    INITIALIZE WS-MAST-DATA                             
                               WS-COIN-SUB-ACCT-TABLE                   
                 END-IF                                                 
              END-PERFORM                                               
           END-IF.                                                      
                                                                        
           PERFORM 7560-READ-FCSDB07            THRU 7560-EXIT.         
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  PROCESS DETAILS OF EACH MASTER ACCOUNT                        *        
      ******************************************************************        
       1150-PROCESS-MAST-ACCTS-DET.                                     
                                                                        
           MOVE E-FDB07-ACCT-NO              TO WS-ACCOUNT-NO           
                                                BI-ACCOUNT-NO           
                                                BG-ACCOUNT-NO           
                                                WS-MAST-ACCOUNT-NO.     
                                                                        
           MOVE AT-BILL-CYCLE                TO WS-BILL-CYCLE.          
           MOVE 'N'                          TO WS-NO-MORE-BG-DATA-FL.  
                                                                        
           MOVE E-FDB07-OFF-CYCLE-BILL-CODE  TO WS-CODE-BILL-OFF-CYCL.  
                                                                        
           PERFORM 7003-SELECT-BILL-HDR         THRU 7003-EXIT.         
                                                                        
           MOVE BI-BILL-NO                   TO BG-BILL-NO.             
                                                                        
           PERFORM 7004-OPEN-BILLING-DET-MAST   THRU 7004-EXIT.         
           PERFORM 7005-FETCH-BILLING-DET-MAST  THRU 7005-EXIT.         
                                                                        
           PERFORM UNTIL NO-MORE-BG-DATA                                
              MOVE ZEROS  TO WS-MAST-IC-NO                              
                             WS-MAST-MIN-PF                             
                             WS-MAST-BILL-NO                            
                             WS-MAST-NET-UNITS                          
                             WS-MAST-READ-UNITS                         
                             WS-MAST-EXP-LOAD-KW                        
                             WS-TOT-COIN-EDC-AMT                        
                             WS-MAST-PF-PENALTY-KW                      
                             WS-MAST-REVENUE-MONTH                      
                             WS-COIN-TOT-PENALTY-KW                     
                             WS-TOT-POS-EXP-LOAD-KW                     
                             WS-MAST-EDC-DSCNT-FCTR                     
                             WS-TOT-COIN-EXP-LOAD-KW                    
                             WS-MAST-REV-MTH-ORIG-BILL                  
                                                                        
              MOVE SPACES TO WS-MAST-CODE-UTIL-TYPE                     
                             WS-MAST-PEAK-DATE-READ                     
                             WS-MAST-PEAK-TIME-READ                     
                             WS-MAST-NET-UNIT-SEL-RSN                   
                             WS-MAST-BILL-ITEM-TIMESTMP                 
                                                                        
              MOVE BG-IC-NO                TO WS-MAST-IC-NO             
              MOVE BG-BILL-NO              TO WS-MAST-BILL-NO           
              MOVE BG-CODE-UTIL-TYPE       TO WS-MAST-CODE-UTIL-TYPE    
                                                                        
              MOVE BG-BILL-ITEM-TIMESTMP                                
                   TO WS-MAST-BILL-ITEM-TIMESTMP                        
              MOVE BG-REV-MTH-ORIG-BILL                                 
                   TO WS-MAST-REV-MTH-ORIG-BILL                         
              IF BG-REV-MTH-ORIG-BILL > 0                               
                 MOVE BG-REV-MTH-ORIG-BILL TO WS-MAST-REVENUE-MONTH     
              ELSE                                                      
                 PERFORM 5700-FIND-REVENUE-MONTH                        
                                                THRU 5700-EXIT          
                 MOVE WS-REVENUE-MONTH     TO WS-MAST-REVENUE-MONTH     
              END-IF                                                    
                                                                        
              PERFORM 2000-LOAD-UTLBILLREL-DATA THRU 2000-EXIT          
              PERFORM 2100-GET-EDC-FACTOR       THRU 2100-EXIT          
              PERFORM 2200-LOAD-COIN-DATA       THRU 2200-EXIT          
              PERFORM 2300-CALL-BILL-CALC       THRU 2300-EXIT          
              PERFORM 7005-FETCH-BILLING-DET-MAST                       
                                                THRU 7005-EXIT          
           END-PERFORM.                                                 
                                                                        
           PERFORM 7006-CLOSE-BILLING-DET-MAST  THRU 7006-EXIT.         
                                                                        
       1150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  LOAD UTL BILL REL DATA                                        *        
      ******************************************************************        
       2000-LOAD-UTLBILLREL-DATA.                                       
                                                                        
           INITIALIZE WS-UR-TABLE.                                      
           MOVE 'N'                          TO WS-NO-MORE-UTL-DATA-FL. 
                                                                        
           MOVE WS-MAST-REVENUE-MONTH (1:4)  TO WS-WORK-DATE-YR         
           MOVE WS-MAST-REVENUE-MONTH (5:2)  TO WS-WORK-DATE-MM         
           MOVE '01'                         TO WS-WORK-DATE-DD         
           MOVE '-'                          TO WS-WORK-DATE-FIL1       
                                                WS-WORK-DATE-FIL2.      
                                                                        
           MOVE WS-WORK-DATE                 TO UR-DEP-REL-START-DT     
                                                UR-DEP-REL-END-DT.      
                                                                        
           PERFORM 7200-OPEN-UTLBILLREL-CURSOR  THRU 7200-EXIT.         
                                                                        
           PERFORM 7300-FETCH-UTLBILLREL-CURSOR THRU 7300-EXIT.         
                                                                        
           SET  WS-UR-TBL-INDX               TO 1.                      
           PERFORM UNTIL NO-MORE-UTL-DATA                               
              MOVE UR-ACCOUNT-NO-DEP                                    
                TO WS-UR-ACCOUNT-NO-DEP     (WS-UR-TBL-INDX)            
              MOVE UR-CODE-UTIL-TYPE-DEP                                
                TO WS-UR-CODE-UTIL-TYPE-DEP (WS-UR-TBL-INDX)            
              MOVE UR-IC-NO-DEP                                         
                TO WS-UR-IC-NO-DEP          (WS-UR-TBL-INDX)            
              MOVE UR-MTR-REF-NO-DEP                                    
                TO WS-UR-MTR-REF-NO-DEP     (WS-UR-TBL-INDX)            
              MOVE UR-DEP-REL-START-DT                                  
                TO WS-UR-DEP-REL-START-DT   (WS-UR-TBL-INDX)            
              MOVE UR-ACCOUNT-NO-MST                                    
                TO WS-UR-ACCOUNT-NO-MST     (WS-UR-TBL-INDX)            
              MOVE UR-CODE-UTIL-TYPE-MST                                
                TO WS-UR-CODE-UTIL-TYPE-MST (WS-UR-TBL-INDX)            
              MOVE UR-IC-NO-MST                                         
                TO WS-UR-IC-NO-MST          (WS-UR-TBL-INDX)            
              MOVE UR-MTR-REF-NO-MST                                    
                TO WS-UR-MTR-REF-NO-MST     (WS-UR-TBL-INDX)            
              MOVE UR-CODE-RELATION-TYPE                                
                TO WS-UR-CODE-RELATION-TYPE (WS-UR-TBL-INDX)            
              MOVE MN-METER-NO                                          
                TO WS-UR-METER-NO-DEP       (WS-UR-TBL-INDX)            
                                                                        
              PERFORM 7300-FETCH-UTLBILLREL-CURSOR                      
                                                THRU 7300-EXIT          
              SET  WS-UR-TBL-INDX UP BY 1                               
           END-PERFORM.                                                 
                                                                        
           PERFORM 7400-CLOSE-UTLBILLREL-CURSOR THRU 7400-EXIT.         
                                                                        
           DISPLAY 'UTL BILL REL ROW COUNT : ' WS-UTLBILLREL-COUNT.     
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  GET EDC DISCOUNT FACTOR FROM FF OR FH                         *        
      ******************************************************************        
       2100-GET-EDC-FACTOR.                                             
                                                                        
           IF WS-MAST-REV-MTH-ORIG-BILL > 0                             
              MOVE WS-MAST-ACCOUNT-NO        TO FH-ACCOUNT-NO           
              MOVE WS-MAST-BILL-NO           TO FH-BILL-NO              
              MOVE WS-MAST-CODE-UTIL-TYPE    TO FH-CODE-UTIL-TYPE       
              MOVE WS-MAST-IC-NO             TO FH-IC-NO                
              MOVE WS-MAST-BILL-ITEM-TIMESTMP                           
                                             TO FH-BILL-ITEM-TIMESTMP   
              PERFORM 7020-GET-EDC-DISCOUNT-FCTR-FH                     
                                                THRU 7020-EXIT          
              IF FH-CODE-DEBIT-CREDIT = 'C'                             
                 COMPUTE WS-MAST-EDC-DSCNT-FCTR EQUAL                   
                         WS-MAST-EDC-DSCNT-FCTR  * -1                   
                 END-COMPUTE                                            
              END-IF                                                    
           ELSE                                                         
              MOVE WS-WORK-DATE              TO FF-EFF-DATE-FROM        
                                                FF-EFF-DATE-TO          
              MOVE WS-MAST-ACCOUNT-NO        TO FF-ACCOUNT-NO           
              MOVE WS-MAST-CODE-UTIL-TYPE    TO FF-CODE-UTIL-TYPE       
              MOVE WS-MAST-IC-NO             TO FF-IC-NO                
              PERFORM 7010-GET-EDC-DISCOUNT-FCTR-FF                     
                                                THRU 7010-EXIT          
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * LOAD COINCIDENTAL DATA IN WS ARRAY.                            *        
      ******************************************************************        
       2200-LOAD-COIN-DATA.                                             
                                                                        
           INITIALIZE WS-COIN-SUB-ACCT-TABLE.                           
                                                                        
           PERFORM VARYING WS-UR-TBL-INDX FROM 1 BY 1                   
                   UNTIL WS-UR-TBL-INDX > 10 OR                         
                         WS-UR-ACCOUNT-NO-DEP(WS-UR-TBL-INDX) = 0       
              SET  WS-COIN-SUB-INDX          TO WS-UR-TBL-INDX          
                                                                        
              MOVE WS-UR-ACCOUNT-NO-DEP(WS-UR-TBL-INDX)                 
                TO BG-ACCOUNT-NO                                        
                   WS-COIN-ACCT-NO (WS-COIN-SUB-INDX)                   
                                                                        
              MOVE WS-UR-CODE-UTIL-TYPE-DEP(WS-UR-TBL-INDX)             
                TO BG-CODE-UTIL-TYPE                                    
                   WS-COIN-CODE-UTIL-TYPE (WS-COIN-SUB-INDX)            
                                                                        
              MOVE WS-UR-IC-NO-DEP (WS-UR-TBL-INDX)                     
                TO BG-IC-NO                                             
                   WS-COIN-IC-NO (WS-COIN-SUB-INDX)                     
                                                                        
              MOVE WS-UR-METER-NO-DEP (WS-UR-TBL-INDX)                  
                TO WS-COIN-METER-NO (WS-COIN-SUB-INDX)                  
                                                                        
              IF WS-MAST-REV-MTH-ORIG-BILL = 0 AND                      
                   WS-MAST-REVENUE-MONTH   > 0                          
                 PERFORM 7030-GET-DEP-BG-FUTURE-DATA                    
                                                THRU 7030-EXIT          
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                    MOVE 'N'                                            
                      TO WS-COIN-REBILL-IND (WS-COIN-SUB-INDX)          
                    MOVE BG-BILL-NO                                     
                      TO WS-COIN-BILL-NO (WS-COIN-SUB-INDX)             
                    MOVE BG-BILL-ITEM-TIMESTMP                          
                      TO WS-COIN-BILL-ITEM-TIMESTMP (WS-COIN-SUB-INDX)  
                 ELSE                                                   
                    MOVE 'DEP ACCOUNT REGULAR BILL BG DATA NOT FOUND '  
A04860                TO WS-77-COMMENTS-TEXT                            
A04860              MOVE LENGTH OF WS-77-COMMENTS-TEXT                  
A04860                TO WS-77-COMMENTS-LEN                             
                    MOVE BG-ACCOUNT-NO       TO AT-ACCOUNT-NO           
                    PERFORM 7100-SEL-ACCOUNT-DET                        
                                                THRU  7100-EXIT         
                    PERFORM 5000-CREATE-WQ      THRU 5000-EXIT          
                    PERFORM 9900-ABEND          THRU 9900-EXIT          
                 END-IF                                                 
              ELSE                                                      
                 PERFORM 7040-GET-DEP-BG-REBILL-DATA                    
                                                THRU 7040-EXIT          
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                    MOVE 'Y'                                            
                      TO WS-COIN-REBILL-IND (WS-COIN-SUB-INDX)          
                    MOVE BG-BILL-NO                                     
                      TO WS-COIN-BILL-NO (WS-COIN-SUB-INDX)             
                    MOVE BG-BILL-ITEM-TIMESTMP                          
                      TO WS-COIN-BILL-ITEM-TIMESTMP (WS-COIN-SUB-INDX)  
                 ELSE                                                   
                    MOVE 'DEP ACCOUNT REBILL BG DATA NOT FOUND '        
A04860                TO WS-77-COMMENTS-TEXT                            
A04860              MOVE LENGTH OF WS-77-COMMENTS-TEXT                  
A04860                TO WS-77-COMMENTS-LEN                             
                    MOVE BG-ACCOUNT-NO       TO AT-ACCOUNT-NO           
                    PERFORM 7100-SEL-ACCOUNT-DET                        
                                                THRU 7100-EXIT          
                    PERFORM 5000-CREATE-WQ      THRU 5000-EXIT          
                    PERFORM 9900-ABEND          THRU 9900-EXIT          
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
       2200-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * CALL BILL CALC PROGRAM SCSCA107 FOR MASTER ACCOUNT             *        
      ******************************************************************        
       2300-CALL-BILL-CALC.                                             
                                                                        
           MOVE 'B'                        TO WS-CPD4517-CALL-TYPE.     
           MOVE WS-MAST-ACCOUNT-NO         TO WS-CPD4517-ACCOUNT-NO.    
           MOVE WS-MAST-CODE-UTIL-TYPE     TO WS-CPD4517-CODE-UTIL-TYPE.
           MOVE WS-MAST-IC-NO              TO WS-CPD4517-IC-NO.         
           MOVE WS-MAST-BILL-NO            TO WS-CPD4517-BILL-NO.       
           MOVE WS-MAST-BILL-ITEM-TIMESTMP TO WS-CPD4517-BILL-TIMESTMP. 
           MOVE WS-MAST-REVENUE-MONTH      TO WS-CPD4517-REVENUE-MONTH. 
           MOVE WS-INPUT-DATE              TO WS-CPD4517-COMMON-DATE.   
                                                                        
      **** TO AVOID WRITING THE WK05 FILE IN SCSCA118 FOR BILL-CALC-CALL        
           MOVE 'R'                        TO WS-ACCOUNT-TYPE-CODE-AT.  
                                                                        
      **** PROCESS SCSCA107 CALL                                                
           PERFORM 6000-CPD4517-MAIN-PROCESS  THRU                      
                   6000-CPD4517-EXIT.                                   
                                                                        
      **** STORE KW UNITS                                                       
           SET BC-INDX TO 1                                             
           SEARCH WS-BC-COMPONENT                                       
              AT END                                                    
                 CONTINUE                                               
                                                                        
              WHEN WS-BC-COMPONENT-ID (BC-INDX) = SPACES                
                 CONTINUE                                               
                                                                        
              WHEN WS-BC-CONSUMPTION-TYPE (BC-INDX) = 'J'               
                 MOVE WS-BC-NET-UNIT-SEL-RSN (BC-INDX)                  
                   TO WS-MAST-NET-UNIT-SEL-RSN                          
                 MOVE WS-BC-NET-UNITS (BC-INDX)                         
                   TO WS-MAST-NET-UNITS                                 
                 MOVE WS-BC-READ-UNITS (BC-INDX)                        
                   TO WS-MAST-READ-UNITS                                
                                                                        
      **** E - NET-IS-FROM-PWR-FCTR                                             
                 IF WS-MAST-NET-UNIT-SEL-RSN = 'E'                      
                    COMPUTE WS-MAST-PF-PENALTY-KW     =                 
                            WS-BC-NET-UNITS (BC-INDX) -                 
                            WS-BC-READ-UNITS (BC-INDX)                  
                    END-COMPUTE                                         
                 END-IF                                                 
                                                                        
      **** GET EXPANSION LOAD KW                                                
                 PERFORM 2310-GET-MAST-EXP-LOAD-KW                      
                                                THRU 2310-EXIT          
                                                                        
      **** GET MASTER MINIMUM POWER FACTOR                                      
                 MOVE WS-BC-RATE-PLAN-NO-BG  TO DI-RATE-PLAN-NO         
                 MOVE WS-BC-RATE-VERSION (BC-INDX)                      
                                             TO DI-VERSION-NO-CNTRL     
                 MOVE WS-BC-COMPONENT-ID (BC-INDX)                      
                                             TO DI-CMPNT-ID-CD          
                 MOVE WS-MAST-CODE-UTIL-TYPE TO DI-CODE-UTIL-TYPE       
                 PERFORM 7050-GET-MASTER-MIN-PF THRU 7050-EXIT          
           END-SEARCH.                                                  
                                                                        
      **** GET COINCIDENTAL PEAK DATE AND TIME OF SUB ACCOUNTS.                 
           SET COINCIDENTAL-PEAK-NOT-FOUND   TO TRUE                    
           PERFORM VARYING CX-INDX FROM 1 BY 1                          
SCA006               UNTIL COINCIDENTAL-PEAK-FOUND OR 
                           WS-BC-ACCOUNT-NO-CX (CX-INDX) EQUAL ZERO             
              IF WS-BC-CODE-USAGE-TYPE-CX (CX-INDX)   = 'J' AND         
                 WS-BC-CODE-USAGE-ID-CX (CX-INDX)     = 'A' AND         
                 WS-BC-CODE-USAGE-SOURCE-CX (CX-INDX) = 'B'             
                 IF WS-BC-DATE-PEAK-DEMAND-CX (CX-INDX) > SPACES AND    
                    WS-BC-PRV-MTR-READ-DT-CALC-CX (CX-INDX) > SPACES    
                    MOVE WS-BC-DATE-PEAK-DEMAND-CX (CX-INDX)            
                      TO WS-MAST-PEAK-DATE-READ                         
                    MOVE WS-BC-PRV-MTR-READ-DT-CALC-CX (CX-INDX)        
                      TO WS-MAST-PEAK-TIME-READ                         
                     SET COINCIDENTAL-PEAK-FOUND                        
                                             TO TRUE                    
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           IF COINCIDENTAL-PEAK-NOT-FOUND                               
              DISPLAY 'COINCIDENTAL PEAK DATE AND TIME NOT FOUND'       
              DISPLAY 'ACCOUNT-NO        : ' WS-MAST-ACCOUNT-NO         
              DISPLAY 'CODE-UTIL-TYPE    : ' WS-MAST-CODE-UTIL-TYPE     
              DISPLAY 'IC-NO             : ' WS-MAST-IC-NO              
              DISPLAY 'BILL-NO           : ' WS-MAST-BILL-NO            
              DISPLAY 'BILL-ITEM-TIMESTMP: ' WS-MAST-BILL-ITEM-TIMESTMP 
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
      **** BUILD COINCIDENTAL DATA OF SUB ACCOUNTS                              
           PERFORM 2320-BUILD-COIN-DATA         THRU 2320-EXIT.         
                                                                        
      **** BUILD COINCIDENTAL DATA OF SUB ACCOUNTS                              
           PERFORM 2330-SUB-ACCT-CALCS          THRU 2330-EXIT.         
                                                                        
      **** UPDATE SUB ACCOUNT FACTORS                                           
           PERFORM 2350-UPDATE-SUBACT-FACTORS   THRU 2350-EXIT.         
                                                                        
       2300-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * SAVE MASTER EXPANSION LOAD KW                                  *        
      ******************************************************************        
       2310-GET-MAST-EXP-LOAD-KW.                                       
                                                                        
           SET BASELINE-NOT-LOCATED          TO TRUE.                   
           SET WS-LO-INDEX                   TO +1.                     
                                                                        
           SEARCH WS-BILL-BSLN-HIST-DATA                                
              AT END                                                    
                 CONTINUE                                               
                                                                        
              WHEN WS-ACCOUNT-NO-LO (WS-LO-INDEX) = ZERO                
                 CONTINUE                                               
                                                                        
              WHEN WS-BILLING-KEY-LO (WS-LO-INDEX) = WS-BC-BG-KEY       
                 PERFORM VARYING WS-LO-UNITS-INDX FROM 1 BY 1           
SCA006             UNTIL WS-LO-UNITS-INDX > 30 OR 
                         BASELINE-LOCATED OR 
                         WS-CMPNT-ID-CD-LO                              
                           (WS-LO-INDEX WS-LO-UNITS-INDX) = SPACES              
                                                                        
                    IF WS-CMPNT-ID-CD-LO                                
                                  (WS-LO-INDEX WS-LO-UNITS-INDX) =      
                            WS-BC-COMPONENT-ID (BC-INDX)                
                       AND WS-CODE-TIME-PERIOD-LO                       
                                  (WS-LO-INDEX WS-LO-UNITS-INDX) =      
                            WS-BC-CODE-TOU (BC-INDX)                    
                       AND WS-INSTR-USE-TYPE-CD-LO                      
                                  (WS-LO-INDEX WS-LO-UNITS-INDX) = 'D'  
                       AND DEMAND-COMPONENT (BC-INDX)                   
                       SET BASELINE-LOCATED  TO TRUE                    
      **** SAVE MASTER EXPANSION LOAD KW                                        
                        IF WS-BASELINE-UNITS-LO                         
                               (WS-LO-INDEX WS-LO-UNITS-INDX) <         
                                          WS-BC-NET-UNITS (BC-INDX)     
                           COMPUTE WS-MAST-EXP-LOAD-KW                  
                                 = WS-BC-NET-UNITS (BC-INDX) -          
                                   WS-BASELINE-UNITS-LO                 
                                         (WS-LO-INDEX WS-LO-UNITS-INDX) 
                           END-COMPUTE                                  
                        END-IF                                          
                    END-IF                                              
                 END-PERFORM                                            
           END-SEARCH.                                                  
                                                                        
       2310-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * BUILD COINCIDENTAL DATA OF SUB ACCOUNTS                        *        
      ******************************************************************        
       2320-BUILD-COIN-DATA.                                            
                                                                        
           INITIALIZE WS-CALC-COIN-KW                                   
                      WS-CALC-COIN-KVAR                                 
                      WS-ACTUAL-MAX-KW.                                 
                                                                        
           PERFORM VARYING WS-COIN-SUB-INDX FROM 1 BY 1                 
SCA006               UNTIL WS-COIN-SUB-INDX > 10 OR 
                           WS-COIN-ACCT-NO (WS-COIN-SUB-INDX) = 0               
              MOVE WS-COIN-ACCT-NO (WS-COIN-SUB-INDX)                   
                TO CX-ACCOUNT-NO                                        
                   LN-ACCOUNT-NO                                        
              MOVE WS-COIN-BILL-NO (WS-COIN-SUB-INDX)                   
                TO CX-BILL-NO                                           
              MOVE WS-COIN-CODE-UTIL-TYPE (WS-COIN-SUB-INDX)            
                TO CX-CODE-UTIL-TYPE                                    
                   LN-CODE-UTIL-TYPE                                    
              MOVE WS-COIN-IC-NO (WS-COIN-SUB-INDX)                     
                TO CX-IC-NO                                             
                   LN-IC-NO                                             
              MOVE WS-COIN-BILL-ITEM-TIMESTMP (WS-COIN-SUB-INDX)        
                TO CX-BILL-ITEM-TIMESTMP                                
              MOVE WS-COIN-METER-NO (WS-COIN-SUB-INDX)                  
                TO CX-METER-NO                                          
                                                                        
              PERFORM 7060-GET-KW-KVAR-OF-PEAK-READ                     
                                                THRU 7060-EXIT          
              MOVE WS-CALC-COIN-KW                                      
                TO WS-COIN-KW-UNITS (WS-COIN-SUB-INDX)                  
                                                                        
              COMPUTE WS-COIN-KVA-UNITS (WS-COIN-SUB-INDX) ROUNDED      
                   = (WS-CALC-COIN-KW   ** 2 +                          
                      WS-CALC-COIN-KVAR ** 2) ** 0.5                    
              END-COMPUTE                                               
                                                                        
              COMPUTE WS-COIN-PF (WS-COIN-SUB-INDX) ROUNDED             
                   =  WS-COIN-KW-UNITS  (WS-COIN-SUB-INDX)/             
                      WS-COIN-KVA-UNITS (WS-COIN-SUB-INDX)              
              END-COMPUTE                                               
                                                                        
      **** GET NON-COINCIDENTAL ACTUAL PEAK KW                                  
              PERFORM 7070-GET-NON-COIN-ACTUAL-PEAK                     
                                                THRU 7070-EXIT          
                                                                        
      **** CALCULATE COINCIDENTAL KW CREDIT FOR SUB ACCOUNT                     
              COMPUTE WS-COIN-KW-CREDIT (WS-COIN-SUB-INDX) =            
                      WS-COIN-KW-UNITS  (WS-COIN-SUB-INDX) -            
                      WS-ACTUAL-MAX-KW                                  
              END-COMPUTE                                               
                                                                        
              EVALUATE WS-MAST-NET-UNIT-SEL-RSN                         
                                                                        
      **** CALCULATE POWER FACTOR PENALTY KW FOR SUB ACCOUNT                    
      **** NET-IS-FROM-PWR-FCTR                                                 
                 WHEN 'E'                                               
                    IF WS-COIN-PF (WS-COIN-SUB-INDX) < WS-MAST-MIN-PF   
                       COMPUTE WS-COIN-PF-PENALTY-KW                    
                                         (WS-COIN-SUB-INDX) ROUNDED =   
                              (WS-COIN-KVA-UNITS                        
                                 (WS-COIN-SUB-INDX) * WS-MAST-MIN-PF)   
                            -  WS-COIN-KW-UNITS (WS-COIN-SUB-INDX)      
                       END-COMPUTE                                      
                                                                        
                       COMPUTE WS-COIN-TOT-PENALTY-KW =                 
                               WS-COIN-TOT-PENALTY-KW +                 
                               WS-COIN-PF-PENALTY-KW (WS-COIN-SUB-INDX) 
                       END-COMPUTE                                      
                    END-IF                                              
                                                                        
      **** CALCULATE PRO-RATA RATCHET DEMAND ADJ FOR SUB ACT.                   
      **** NET-IS-RATCHET                                                       
                 WHEN 'D'                                               
                    COMPUTE WS-COIN-RATCHET-KW-ADJ                      
                                         (WS-COIN-SUB-INDX) ROUNDED =   
                      ((WS-MAST-NET-UNITS - WS-MAST-READ-UNITS) *       
                                   WS-COIN-KW-UNITS (WS-COIN-SUB-INDX)) 
                         / WS-MAST-READ-UNITS                           
                    END-COMPUTE                                         
                                                                        
      **** CALCULATE PRO-RATA CONTRACT DEMAND ADJ FOR SUB ACT.                  
      **** NET-IS-CNTR-MIN-BC                                                   
                 WHEN 'C'                                               
                    COMPUTE WS-COIN-CNTRCT-KW-ADJ                       
                                         (WS-COIN-SUB-INDX) ROUNDED =   
                      ((WS-MAST-NET-UNITS - WS-MAST-READ-UNITS) *       
                                   WS-COIN-KW-UNITS (WS-COIN-SUB-INDX)) 
                         / WS-MAST-READ-UNITS                           
                    END-COMPUTE                                         
              END-EVALUATE                                              
                                                                        
      **** GET BASELINE UNITS FOR SUB ACCOUNT                                   
              MOVE WS-WORK-DATE              TO LN-CNTRCT-START-DT      
              MOVE WS-WORK-DATE-MM           TO LN-BASELINE-MONTH       
              PERFORM 7080-GET-BASELINE-UNITS   THRU 7080-EXIT          
                                                                        
      **** CALCULATE EXPANSION LOAD OF EDC BASELINE                             
              IF WS-MAST-EXP-LOAD-KW > 0 AND                            
                 LN-BASELINE-UNITS                                      
                               < WS-COIN-KW-UNITS (WS-COIN-SUB-INDX)    
                 COMPUTE WS-COIN-EXP-LOAD-KW (WS-COIN-SUB-INDX)         
                      =  WS-COIN-KW-UNITS (WS-COIN-SUB-INDX) -          
                         LN-BASELINE-UNITS                              
                 END-COMPUTE                                            
                 COMPUTE WS-TOT-COIN-EXP-LOAD-KW =                      
                         WS-TOT-COIN-EXP-LOAD-KW +                      
                         WS-COIN-EXP-LOAD-KW (WS-COIN-SUB-INDX)         
                 END-COMPUTE                                            
                 IF WS-COIN-EXP-LOAD-KW (WS-COIN-SUB-INDX) > 0          
                    COMPUTE WS-TOT-POS-EXP-LOAD-KW =                    
                            WS-TOT-POS-EXP-LOAD-KW +                    
                            WS-COIN-EXP-LOAD-KW (WS-COIN-SUB-INDX)      
                    END-COMPUTE                                         
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
       2320-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * CALCULATIONS OF EACH SUB ACCT FROM COINCIDENTAL DATA.          *        
      ******************************************************************        
       2330-SUB-ACCT-CALCS.                                             
                                                                        
            SET BILL-CALL-TO-SUB TO TRUE.                               
            PERFORM VARYING WS-COIN-SUB-INDX FROM 1 BY 1                
SCA006                UNTIL WS-COIN-SUB-INDX > 10 OR 
                            WS-COIN-ACCT-NO (WS-COIN-SUB-INDX) = 0              
               IF WS-BC-POWER-FACTOR-CALC < WS-MAST-MIN-PF AND          
                  WS-COIN-PF (WS-COIN-SUB-INDX) < WS-MAST-MIN-PF        
                  COMPUTE WS-COIN-PF-PENALTY-KW-ADJ                     
                                 (WS-COIN-SUB-INDX) ROUNDED =           
                         (WS-MAST-PF-PENALTY-KW *                       
                          WS-COIN-PF-PENALTY-KW (WS-COIN-SUB-INDX))/    
                          WS-COIN-TOT-PENALTY-KW                        
                  END-COMPUTE                                           
               END-IF                                                   
               IF BILL-CALL-TO-SUB                                      
                  PERFORM 2340-GET-EDC-DEMAND-PRICE                     
                                                THRU 2340-EXIT          
                  SET NO-BILL-CALL-TO-SUB TO TRUE                       
              END-IF                                                    
                                                                        
      **** CALCULATE PRO-RATA EDC DOLLAR AMOUNT. CREDIT AMOUNT CANNOT           
      **** BE FOR MORE THAN THE AGGREGATE LOAD EXPANSION. IF MORE THAN 1        
      **** PLANT HAD POSITIVE LOAD INCREASE, ALLOCATE PRO-RATA DISCOUNT.        
                                                                        
              IF WS-TOT-COIN-EXP-LOAD-KW > 0                            
                                                                        
      **** CALCULATE THE TOTAL EDC.                                             
                 COMPUTE WS-EDC-DEMAND-PRICE ROUNDED =                  
                         WS-DEMAND-PRICE * WS-MAST-EDC-DSCNT-FCTR       
                 END-COMPUTE                                            
                                                                        
                 COMPUTE WS-TOT-COIN-EDC-AMT ROUNDED =                  
                         WS-TOT-COIN-EXP-LOAD-KW     *                  
                         WS-EDC-DEMAND-PRICE                            
                 END-COMPUTE                                            
                                                                        
                 IF WS-COIN-EXP-LOAD-KW (WS-COIN-SUB-INDX) > 0          
                                                                        
      **** CALCULATE THE PERCENTAGE CONTRIBUTION BASED ON INDIVIDUAL            
      **** EXPANSION AND NET POSITIVE EXPANSION                                 
                    COMPUTE WS-COIN-EXP-PCT-ALLOC                       
                                (WS-COIN-SUB-INDX) ROUNDED =            
                           (WS-COIN-EXP-LOAD-KW (WS-COIN-SUB-INDX) /    
                            WS-TOT-POS-EXP-LOAD-KW)                     
                    END-COMPUTE                                         
                                                                        
                    IF WS-COIN-EXP-PCT-ALLOC (WS-COIN-SUB-INDX) > 0     
                                                                        
      **** CALCULATE THE PRO-RATA EDC BASED ON THE PERCENTAGE ALLOCATION        
      **** FOR EACH PLANT.                                                      
                       COMPUTE WS-COIN-EXP-LOAD-EDC                     
                                      (WS-COIN-SUB-INDX) ROUNDED =      
                              (WS-TOT-COIN-EDC-AMT *                    
                               WS-COIN-EXP-PCT-ALLOC                    
                                      (WS-COIN-SUB-INDX))               
                       END-COMPUTE                                      
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
            END-PERFORM.                                                
                                                                        
       2330-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * CALL SCSCA107 FOR ONE SUB ACCOUNT TO GET DEMAND PRICE          *        
      ******************************************************************        
       2340-GET-EDC-DEMAND-PRICE.                                       
                                                                        
           MOVE 'B'                        TO WS-CPD4517-CALL-TYPE.     
           MOVE WS-MAST-REVENUE-MONTH      TO WS-CPD4517-REVENUE-MONTH. 
           MOVE WS-COIN-ACCT-NO (WS-COIN-SUB-INDX)                      
                                           TO WS-CPD4517-ACCOUNT-NO.    
           MOVE WS-COIN-BILL-NO (WS-COIN-SUB-INDX)                      
                                           TO WS-CPD4517-BILL-NO.       
           MOVE WS-COIN-CODE-UTIL-TYPE (WS-COIN-SUB-INDX)               
                                           TO WS-CPD4517-CODE-UTIL-TYPE.
           MOVE WS-COIN-IC-NO (WS-COIN-SUB-INDX)                        
                                           TO WS-CPD4517-IC-NO.         
           MOVE WS-COIN-BILL-ITEM-TIMESTMP (WS-COIN-SUB-INDX)           
                                           TO WS-CPD4517-BILL-TIMESTMP. 
                                                                        
      **** TO AVOID WRITING THE WK05 FILE IN SCSCA118 FOR BILL-CALC-CALL        
           MOVE 'R'                        TO WS-ACCOUNT-TYPE-CODE-AT.  
                                                                        
      **** PROCESS SCSCA107 CALL                                                
           PERFORM 6000-CPD4517-MAIN-PROCESS  THRU                      
                   6000-CPD4517-EXIT.                                   
                                                                        
      **** STORE WS-BC-AMT-NET-RATE (BC-INDX 1)                                 
           INITIALIZE WS-EDC-DEMAND-PRICE.                              
                                                                        
           SET BC-INDX TO 1                                             
           SEARCH WS-BC-COMPONENT                                       
              AT END                                                    
                 CONTINUE                                               
                                                                        
              WHEN WS-BC-COMPONENT-ID (BC-INDX) = SPACES                
                 CONTINUE                                               
                                                                        
              WHEN WS-BC-CONSUMPTION-TYPE (BC-INDX) = 'J'               
                 MOVE WS-BC-AMT-NET-RATE  (BC-INDX 1)                   
                   TO WS-DEMAND-PRICE                                   
                                                                        
           END-SEARCH.                                                  
                                                                        
       2340-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * UPDATE SUB ACCOUNT FACTORS.                                    *        
      ******************************************************************        
       2350-UPDATE-SUBACT-FACTORS.                                      
                                                                        
           PERFORM VARYING WS-COIN-SUB-INDX FROM 1 BY 1                 
SCA006               UNTIL WS-COIN-SUB-INDX > 10 OR 
                           WS-COIN-ACCT-NO (WS-COIN-SUB-INDX) = 0               
      **** REGULAR BILL UPDATES                                                 
              IF WS-COIN-REBILL-IND (WS-COIN-SUB-INDX) = 'N'            
                 MOVE WS-COIN-ACCT-NO (WS-COIN-SUB-INDX)                
                                             TO FF-ACCOUNT-NO           
                 MOVE WS-COIN-CODE-UTIL-TYPE (WS-COIN-SUB-INDX)         
                                             TO FF-CODE-UTIL-TYPE       
                 MOVE WS-COIN-IC-NO (WS-COIN-SUB-INDX)                  
                                             TO FF-IC-NO                
                 MOVE WS-WORK-DATE           TO FF-EFF-DATE-FROM        
                                                FF-EFF-DATE-TO          
      **** COINCIDENTAL CONTRACT DEMAND ADJ                                     
                 MOVE 'CC'                   TO SF-SPECIAL-CALC-CD      
                 MOVE WS-COIN-CNTRCT-KW-ADJ (WS-COIN-SUB-INDX)          
                                             TO FF-FACTOR               
                 PERFORM 7500-GET-FACTOR-ID-FF  THRU 7500-EXIT          
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                    IF FF-FACTOR NOT EQUAL 0                            
                       DISPLAY 'COINCIDENTAL CONTRACT DEMAND ADJ '      
                                FF-FACTOR ' CALCULATED FOR '            
                                FF-ACCOUNT-NO                           
                    END-IF                                              
                    PERFORM 8050-UPDATE-FACTOR-FF                       
                                                THRU 8050-EXIT          
                 END-IF                                                 
                                                                        
      **** MICHELIN COINCIDENTAL DEMAND                                         
                 MOVE 'CN'                   TO SF-SPECIAL-CALC-CD      
                 MOVE WS-COIN-KW-CREDIT (WS-COIN-SUB-INDX)              
                                             TO FF-FACTOR               
                 PERFORM 7500-GET-FACTOR-ID-FF  THRU 7500-EXIT          
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                    IF FF-FACTOR NOT EQUAL 0                            
                       DISPLAY 'COINCIDENTAL DEMAND ADJ '               
                                FF-FACTOR ' CALCULATED FOR '            
                                FF-ACCOUNT-NO                           
                    END-IF                                              
                    PERFORM 8050-UPDATE-FACTOR-FF                       
                                                THRU 8050-EXIT          
                 END-IF                                                 
                                                                        
      **** COINCIDENTAL POWER FACTOR DEMAND ADJ                                 
                 MOVE 'CP'                   TO SF-SPECIAL-CALC-CD      
                 MOVE WS-COIN-PF-PENALTY-KW-ADJ (WS-COIN-SUB-INDX)      
                                             TO FF-FACTOR               
                 PERFORM 7500-GET-FACTOR-ID-FF  THRU 7500-EXIT          
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                    IF FF-FACTOR NOT EQUAL 0                            
                       DISPLAY 'COINCIDENTAL POWER FACTOR ADJ '         
                                FF-FACTOR ' CALCULATED FOR '            
                                FF-ACCOUNT-NO                           
                    END-IF                                              
                    PERFORM 8050-UPDATE-FACTOR-FF                       
                                                THRU 8050-EXIT          
                 END-IF                                                 
                                                                        
      **** COINCIDENTAL RATCHET DEMAND ADJ                                      
                 MOVE 'CR'                   TO SF-SPECIAL-CALC-CD      
                 MOVE WS-COIN-RATCHET-KW-ADJ (WS-COIN-SUB-INDX)         
                                             TO FF-FACTOR               
                 PERFORM 7500-GET-FACTOR-ID-FF  THRU 7500-EXIT          
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                    IF FF-FACTOR NOT EQUAL 0                            
                       DISPLAY 'COINCIDENTAL RATCHET DEMAND ADJ '       
                                FF-FACTOR ' CALCULATED FOR '            
                                FF-ACCOUNT-NO                           
                    END-IF                                              
                    PERFORM 8050-UPDATE-FACTOR-FF                       
                                                THRU 8050-EXIT          
                 END-IF                                                 
                                                                        
      **** ECONOMIC DEVELOPMENT CREDIT                                          
                 MOVE 'CB'                   TO SF-SPECIAL-CALC-CD      
                 MOVE WS-COIN-EXP-LOAD-EDC (WS-COIN-SUB-INDX)           
                                             TO FF-FACTOR               
                 PERFORM 7500-GET-FACTOR-ID-FF  THRU 7500-EXIT          
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                    IF FF-FACTOR NOT EQUAL 0                            
                       DISPLAY 'ECONOMIC DEVELOPMENT CREDIT '           
                                FF-FACTOR ' CALCULATED FOR '            
                                FF-ACCOUNT-NO                           
                    END-IF                                              
                    PERFORM 8050-UPDATE-FACTOR-FF                       
                                                THRU 8050-EXIT          
                 END-IF                                                 
              ELSE                                                      
      **** CANCEL/REBILL UPDATES                                                
                 MOVE WS-COIN-ACCT-NO (WS-COIN-SUB-INDX)                
                                             TO FH-ACCOUNT-NO           
                 MOVE WS-COIN-CODE-UTIL-TYPE (WS-COIN-SUB-INDX)         
                                             TO FH-CODE-UTIL-TYPE       
                 MOVE WS-COIN-IC-NO (WS-COIN-SUB-INDX)                  
                                             TO FH-IC-NO                
                 MOVE WS-COIN-BILL-ITEM-TIMESTMP (WS-COIN-SUB-INDX)     
                                             TO FH-BILL-ITEM-TIMESTMP   
                 MOVE WS-WORK-DATE           TO FH-EFF-DATE-FROM        
                                                FH-EFF-DATE-TO          
      **** COINCIDENTAL CONTRACT DEMAND ADJ                                     
                 MOVE 'CC'                   TO SF-SPECIAL-CALC-CD      
                 MOVE WS-COIN-CNTRCT-KW-ADJ (WS-COIN-SUB-INDX)          
                                             TO FH-FACTOR               
                 PERFORM 7550-GET-FACTOR-ID-FH  THRU 7550-EXIT          
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                    IF FH-FACTOR NOT EQUAL 0                            
                       DISPLAY 'COINCIDENTAL CONTRACT DEMAND ADJ '      
                                FH-FACTOR ' CALCULATED FOR '            
                                FH-ACCOUNT-NO                           
                    END-IF                                              
                    IF FH-FACTOR < 0                                    
                       MOVE 'C'              TO FH-CODE-DEBIT-CREDIT    
                       COMPUTE FH-FACTOR EQUAL                          
                               FH-FACTOR * -1                           
                       END-COMPUTE                                      
                    ELSE                                                
                       IF FH-FACTOR > 0                                 
                          MOVE 'D'           TO FH-CODE-DEBIT-CREDIT    
                       END-IF                                           
                    END-IF                                              
                    PERFORM 8100-UPDATE-FACTOR-FH                       
                                                THRU 8100-EXIT          
                 END-IF                                                 
                                                                        
      **** MICHELIN COINCIDENTAL DEMAND NEW                                     
                 MOVE 'CN'                   TO SF-SPECIAL-CALC-CD      
                 MOVE WS-COIN-KW-CREDIT (WS-COIN-SUB-INDX)              
                                             TO FH-FACTOR               
                 PERFORM 7550-GET-FACTOR-ID-FH  THRU 7550-EXIT          
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                    IF FH-FACTOR NOT EQUAL 0                            
                       DISPLAY 'COINCIDENTAL DEMAND ADJ '               
                                FH-FACTOR ' CALCULATED FOR '            
                                FH-ACCOUNT-NO                           
                    END-IF                                              
                    IF FH-FACTOR < 0                                    
                       MOVE 'C'              TO FH-CODE-DEBIT-CREDIT    
                       COMPUTE FH-FACTOR EQUAL                          
                               FH-FACTOR * -1                           
                       END-COMPUTE                                      
                    ELSE                                                
                       IF FH-FACTOR > 0                                 
                          MOVE 'D'           TO FH-CODE-DEBIT-CREDIT    
                       END-IF                                           
                    END-IF                                              
                    PERFORM 8100-UPDATE-FACTOR-FH                       
                                                THRU 8100-EXIT          
                 END-IF                                                 
                                                                        
      **** COINCIDENTAL POWER FACTOR DEMAND ADJ                                 
                 MOVE 'CP'                   TO SF-SPECIAL-CALC-CD      
                 MOVE WS-COIN-PF-PENALTY-KW-ADJ (WS-COIN-SUB-INDX)      
                                             TO FH-FACTOR               
                 PERFORM 7550-GET-FACTOR-ID-FH  THRU 7550-EXIT          
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                    IF FH-FACTOR NOT EQUAL 0                            
                       DISPLAY 'COINCIDENTAL POWER FACTOR ADJ '         
                                FH-FACTOR ' CALCULATED FOR '            
                                FH-ACCOUNT-NO                           
                    END-IF                                              
                    IF FH-FACTOR < 0                                    
                       MOVE 'C'              TO FH-CODE-DEBIT-CREDIT    
                       COMPUTE FH-FACTOR EQUAL                          
                               FH-FACTOR * -1                           
                       END-COMPUTE                                      
                    ELSE                                                
                       IF FH-FACTOR > 0                                 
                          MOVE 'D'           TO FH-CODE-DEBIT-CREDIT    
                       END-IF                                           
                    END-IF                                              
                    PERFORM 8100-UPDATE-FACTOR-FH                       
                                                THRU 8100-EXIT          
                 END-IF                                                 
                                                                        
      **** COINCIDENTAL RATCHET DEMAND ADJ                                      
                 MOVE 'CR'                   TO SF-SPECIAL-CALC-CD      
                 MOVE WS-COIN-RATCHET-KW-ADJ (WS-COIN-SUB-INDX)         
                                             TO FH-FACTOR               
                 PERFORM 7550-GET-FACTOR-ID-FH  THRU 7550-EXIT          
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                    IF FH-FACTOR NOT EQUAL 0                            
                       DISPLAY 'COINCIDENTAL RATCHET DEMAND ADJ '       
                                FH-FACTOR ' CALCULATED FOR '            
                                FH-ACCOUNT-NO                           
                    END-IF                                              
                    IF FH-FACTOR < 0                                    
                       MOVE 'C'              TO FH-CODE-DEBIT-CREDIT    
                       COMPUTE FH-FACTOR EQUAL                          
                               FH-FACTOR * -1                           
                       END-COMPUTE                                      
                    ELSE                                                
                       IF FH-FACTOR > 0                                 
                          MOVE 'D'           TO FH-CODE-DEBIT-CREDIT    
                       END-IF                                           
                    END-IF                                              
                    PERFORM 8100-UPDATE-FACTOR-FH                       
                                                THRU 8100-EXIT          
                 END-IF                                                 
                                                                        
      **** ECONOMIC DEVELOPMENT CREDIT                                          
                 MOVE 'CB'                   TO SF-SPECIAL-CALC-CD      
                 MOVE WS-COIN-EXP-LOAD-EDC (WS-COIN-SUB-INDX)           
                                             TO FH-FACTOR               
                 PERFORM 7550-GET-FACTOR-ID-FH  THRU 7550-EXIT          
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                    IF FH-FACTOR NOT EQUAL 0                            
                       DISPLAY 'ECONOMIC DEVELOPMENT CREDIT '           
                                FH-FACTOR ' CALCULATED FOR '            
                                FH-ACCOUNT-NO                           
                    END-IF                                              
                    IF FH-FACTOR < 0                                    
                       MOVE 'C'              TO FH-CODE-DEBIT-CREDIT    
                       COMPUTE FH-FACTOR EQUAL                          
                               FH-FACTOR * -1                           
                       END-COMPUTE                                      
                    ELSE                                                
                       IF FH-FACTOR > 0                                 
                          MOVE 'D'           TO FH-CODE-DEBIT-CREDIT    
                       END-IF                                           
                    END-IF                                              
                    PERFORM 8100-UPDATE-FACTOR-FH                       
                                                THRU 8100-EXIT          
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
       2350-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 5700-FIND-REVENUE-MONTH.                                       *        
      ******************************************************************        
       5700-FIND-REVENUE-MONTH.                                         
                                                                        
           MOVE ZEROES                       TO WS-REV-COUNT            
                                                WS-OLDEST-REV-MONTH     
                                                WS-PREV-REVENUE-MONTH.  
                                                                        
           MOVE 1                            TO WS-INDEX                
           PERFORM 5750-GET-OLDEST-REV-MONTH    THRU 5750-EXIT          
                   UNTIL WS-FCA00-BLCYC-NUMBER(WS-INDEX) = '00'         
                                                OR WS-INDEX >= 8.       
           PERFORM 5800-LOAD-REVENUE-MONTH      THRU 5800-EXIT.         
                                                                        
       5700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5750-GET-OLDEST-REV-MONTH.                                     *        
      ******************************************************************        
       5750-GET-OLDEST-REV-MONTH.                                       
                                                                        
           IF WS-FCA00-REV-MONTH (WS-INDEX) = WS-PREV-REVENUE-MONTH     
              CONTINUE                                                  
           ELSE                                                         
              ADD 1                          TO WS-REV-COUNT            
              IF WS-PREV-REVENUE-MONTH = ZEROES                         
                 MOVE WS-FCA00-REV-MONTH(WS-INDEX)                      
                                             TO WS-OLDEST-REV-MONTH     
              END-IF                                                    
              IF WS-FCA00-REV-MONTH (WS-INDEX)                          
                                      <=  WS-PREV-REVENUE-MONTH         
                  AND WS-FCA00-REV-MONTH (WS-INDEX) NOT = ZEROES        
                 MOVE WS-FCA00-REV-MONTH(WS-INDEX)                      
                                             TO WS-OLDEST-REV-MONTH     
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE WS-FCA00-REV-MONTH(WS-INDEX) TO WS-PREV-REVENUE-MONTH.  
           ADD 1                             TO WS-INDEX.               
                                                                        
       5750-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5800-LOAD-REVENUE-MONTH.                                       *        
      ******************************************************************        
       5800-LOAD-REVENUE-MONTH.                                         
                                                                        
           IF WS-REV-COUNT = 1                                          
              PERFORM 5850-LOAD-ONE-REVENUE-MONTH                       
                                                THRU 5850-EXIT          
           ELSE                                                         
              IF WS-OFF-CYCLE-BILL-CODE EQUAL                           
                                   FINAL-BILL OR OFF-CYC-REBILL         
                 INITIALIZE WS-REV-MTH-LST-NRML                         
                 MOVE AT-REV-MTH-LST-NRML    TO WS-REV-MTH-LST-NRML     
                 SET WS-BILL-CYC-INDX        TO 1                       
                 SEARCH WS-FCA00-BILLING-CYCLES                         
                     AT END                                             
                       MOVE WS-OLDEST-REV-MONTH                         
                                             TO WS-REVENUE-MONTH        
                   WHEN (WS-FCA00-REV-MONTH (WS-BILL-CYC-INDX) EQUAL    
                         WS-REV-MTH-LST-NRML) AND                       
                        (WS-REV-MTH-LST-NRML NOT = ZERO)                
                       MOVE WS-FCA00-REV-MONTH (WS-BILL-CYC-INDX)       
                                             TO WS-REVENUE-MONTH        
                                                                        
                 END-SEARCH                                             
              ELSE                                                      
                 SET WS-BILL-CYC-INDX        TO 1                       
                 SEARCH WS-FCA00-BILLING-CYCLES                         
                     AT END                                             
                       MOVE WS-OLDEST-REV-MONTH                         
                                             TO WS-REVENUE-MONTH        
                   WHEN WS-FCA00-BLCYC-NUMBER (WS-BILL-CYC-INDX) EQUAL  
                        WS-BILL-CYCLE                                   
                       MOVE WS-FCA00-REV-MONTH (WS-BILL-CYC-INDX)       
                                             TO WS-REVENUE-MONTH        
                 END-SEARCH                                             
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5850-LOAD-ONE-REVENUE-MONTH.                                   *        
      ******************************************************************        
       5850-LOAD-ONE-REVENUE-MONTH.                                     
                                                                        
           SET WS-BILL-CYC-INDX              TO 1.                      
           SEARCH WS-FCA00-BILLING-CYCLES                               
               AT END                                                   
                 MOVE WS-REVENUE-MONTH-JP    TO WS-REVENUE-MONTH        
             WHEN WS-FCA00-BLCYC-NUMBER (WS-BILL-CYC-INDX) EQUAL        
                  WS-BILL-CYCLE                                         
                 MOVE WS-FCA00-REV-MONTH (WS-BILL-CYC-INDX)             
                                             TO WS-REVENUE-MONTH        
           END-SEARCH.                                                  
                                                                        
       5850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5000-CREATE-WQ.                                                *        
      ******************************************************************        
       5000-CREATE-WQ.                                                  
                                                                        
A04860     MOVE WS-INPUT-DATE                TO WS-INPUT-DATE-PT.       
A04860     MOVE WS-INPUT-DATE                TO WS-77-DATE-REQUIRED     
A04860     MOVE WS-INPUT-TS                  TO WS-77-DATE-CREATED.     
                                                                        
A04860     MOVE 17                           TO WS-77-CATEGORY-ID       
A04860     MOVE 'N'                          TO WS-77-PRIORITY          
A04860     MOVE 4                            TO WS-77-ROUTE-CATEGORY    
                                                                        
A04860     INITIALIZE WS-77-SERV-ORDER-NO                               
A04860                WS-77-RESP-AREA-ID                                
A04860                WS-77-FREE-FORM-TXT                               
A04860                WS-77-FREE-FORM-LEN.                              
                                                                        
A04860     MOVE AT-ACCOUNT-NO                TO WS-77-ACCOUNT-NO        
                                                WS-ACCOUNT-NO.          
                                                                        
A04860     MOVE AT-PREMISE-NO                TO WS-77-PREMISE-NO.       
A04860     MOVE AT-CUSTOMER-NO               TO WS-77-CUSTOMER-NO.      
A04860     MOVE AT-LOCAL-OFFICE              TO WS-77-LOCAL-OFFICE.     
A04860     MOVE PROGRAM-NAME                 TO WS-77-CREATED-BY.       
           PERFORM 8895-INSERT-WORK-QUEUE       THRU  8895-EXIT.        
           MOVE 'X'                          TO AT-CODE-ACCT-BILLED.    
           PERFORM 8000-UPDATE-ACCOUNT          THRU  8000-EXIT.        
                                                                        
A04860     DISPLAY ' ' WS-ACCOUNT-NO '  '  WS-77-COMMENTS.              
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  6000-CPD4517-MAIN-PROCESS  THRU 6000-CPD4517-EXIT             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD04517                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  ERROR ROUTINE FOR COPYBOOK CPD04517                           *        
      ******************************************************************        
       6999-CPD4517-ERROR-PROCESS.                                      
                                                                        
           IF WS-CPD4517-RETURN-CODE NOT = 0                            
              DISPLAY '********************************'                
              DISPLAY 'BILL CALC ERROR : ' WS-CPD4517-RETURN-CODE       
              DISPLAY '********************************'                
                                                                        
      **** DISPLAY REJECT/WARNING WQ FROM SCSCA107 CALL                         
              IF WS-CPD4517-RETURN-CODE  = 9999                         
                 MOVE WS-CPD4517-ACCOUNT-NO  TO WS-ACCOUNT-NO           
                 PERFORM VARYING WS-BILL-WQ-INDX FROM 1 BY 1            
                   UNTIL WS-BILL-WQ-INDX   > 50  OR                     
                         WS-CATEGORY-ID-WF (WS-BILL-WQ-INDX) = 0        
                    DISPLAY '  ' WS-ACCOUNT-NO '  '                     
                                 WS-COMMENTS-TEXT-WF (WS-BILL-WQ-INDX)  
                 END-PERFORM                                            
              END-IF                                                    
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       6999-CPD4517-EXIT.                                               
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-OPEN-MASTER-ACCT                                          *        
      ******************************************************************        
       7000-OPEN-MASTER-ACCT.                                           
                                                                        
           EXEC SQL                                                     
              OPEN  MASTER_ACCT                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA291 ABORT **************'        
              DISPLAY '*     7000-OPEN-MASTER-ACCT            *'        
              DISPLAY '* SQLCODE       : ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA291 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7001-FETCH-MASTER-ACCT                                         *        
      ******************************************************************        
       7001-FETCH-MASTER-ACCT.                                          
                                                                        
           EXEC SQL                                                     
              FETCH  MASTER_ACCT                                        
               INTO :AT-ACCOUNT-NO                                      
                   ,:UR-DEP-REL-START-DT :WS-NULL-IND-1                 
                   ,:AT-BILL-CYCLE                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                  ADD  +1                    TO WS-MASTER-ACCOUNTS-COUNT
               WHEN NOT-FOUND                                           
                  SET  WS-NOMORE-ACCTS       TO TRUE                    
               WHEN OTHER                                               
                  DISPLAY '********** PCSCA291 ABORT **************'    
                  DISPLAY '*     7001-FETCH-MASTER-ACCT           *'    
                  DISPLAY '* SQLCODE       : ' WS-ACTIVE-RETURN-CODE    
                  DISPLAY '*     PROCESSING TERMINATED            *'    
                  DISPLAY '********** PCSCA291 ABORT **************'    
                  PERFORM 9900-ABEND            THRU 9900-EXIT          
           END-EVALUATE.                                                
                                                                        
       7001-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7002-CLOSE-MASTER-ACCT                                         *        
      ******************************************************************        
       7002-CLOSE-MASTER-ACCT.                                          
                                                                        
           EXEC SQL                                                     
              CLOSE  MASTER_ACCT                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA291 ABORT **************'        
              DISPLAY '*     7002-CLOSE-MASTER-ACCT           *'        
              DISPLAY '* SQLCODE       : ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA291 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7002-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7003-SELECT-BILL-HDR                                           *        
      ******************************************************************        
       7003-SELECT-BILL-HDR.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) BILL_NO,
              DATE_BILLED                                       
                INTO :BI-BILL-NO                                        
                    ,:BI-DATE-BILLED :WS-NULL-IND-2                     
                FROM  CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                  
               WHERE  BI.ACCOUNT_NO  = :BI-ACCOUNT-NO                   
                 AND  BI.DATE_BILLED IS NULL                            
               ORDER  BY BILL_NO ASC                                    
                                                   
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  BILL_NO                                                   
MFA-TR*             , DATE_BILLED                                               
MFA-TR*         INTO :BI-BILL-NO                                                
MFA-TR*             ,:BI-DATE-BILLED :WS-NULL-IND-2                             
MFA-TR*         FROM  CSS_BILLING_HDR BI                                        
MFA-TR*        WHERE  BI.ACCOUNT_NO  = :BI-ACCOUNT-NO                           
MFA-TR*          AND  BI.DATE_BILLED IS NULL                                    
MFA-TR*        ORDER  BY BILL_NO ASC                                            
MFA-TR*        FETCH  FIRST ROW ONLY                                            
MFA-TR*      QUERYNO 7003                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA291 ABORT **************'        
              DISPLAY '*     7003-SELECT-HILL-HDR             *'        
              DISPLAY '* BI-ACCOUNT-NO : ' BI-ACCOUNT-NO                
              DISPLAY '* SQLCODE       : ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA291 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7003-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7004-OPEN-BILLING-DET-MAST                                     *        
      ******************************************************************        
       7004-OPEN-BILLING-DET-MAST.                                      
                                                                        
           EXEC SQL                                                     
              OPEN  BILLING_DET_MAST                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA291 ABORT **************'        
              DISPLAY '*     7004-OPEN-BILLING-DET-MAST        *'       
              DISPLAY '* BG-ACCOUNT-NO : ' BG-ACCOUNT-NO                
              DISPLAY '* BG-BILL-NO    : ' BG-BILL-NO                   
              DISPLAY '* SQLCODE       : ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA291 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7004-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7005-FETCH-BILLING-DET                                         *        
      ******************************************************************        
       7005-FETCH-BILLING-DET-MAST.                                     
                                                                        
           EXEC SQL                                                     
              FETCH  BILLING_DET_MAST                                   
               INTO :BG-BILL-NO                                         
                   ,:BG-BILL-ITEM-TIMESTMP                              
                   ,:BG-CODE-UTIL-TYPE                                  
                   ,:BG-IC-NO                                           
                   ,:BG-REVENUE-MONTH                                   
                   ,:BG-REV-MTH-ORIG-BILL                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 SET NO-MORE-BG-DATA         TO TRUE                    
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSCA291 ABORT **************'        
              DISPLAY '*     7005-FETCH-BILLING-DET-MAST       *'       
              DISPLAY '* BG-ACCOUNT-NO : ' BG-ACCOUNT-NO                
              DISPLAY '* BG-BILL-NO    : ' BG-BILL-NO                   
              DISPLAY '* SQLCODE       : ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA291 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7006-CLOSE-BILLING-DET-MAST                                    *        
      ******************************************************************        
       7006-CLOSE-BILLING-DET-MAST.                                     
                                                                        
           EXEC SQL                                                     
              CLOSE  BILLING_DET_MAST                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA291 ABORT **************'        
              DISPLAY '*     7006-CLOSE-BILLING-DET-MAST       *'       
              DISPLAY '* SQLCODE       : ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA291 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7006-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * GET EDC DISCOUNT FACTOR FROM FF                               *         
      *****************************************************************         
       7010-GET-EDC-DISCOUNT-FCTR-FF.                                   
                                                                        
           EXEC SQL                                                     
              SELECT  FF.FACTOR                                         
                INTO :WS-MAST-EDC-DSCNT-FCTR                            
                FROM  CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                   
                    , CSS_SPCL_FCTR  SF WITH(READUNCOMMITTED)                   
               WHERE  FF.ACCOUNT_NO      = :FF-ACCOUNT-NO               
                 AND  FF.CODE_UTIL_TYPE  = :FF-CODE-UTIL-TYPE           
                 AND  FF.IC_NO           = :FF-IC-NO                    
                 AND  FF.FACTOR_ID       = SF.FACTOR_ID                 
                 AND  FF.EFF_DATE_FROM  <= IIF(TRY_CONVERT(DATE, 
                                                      :FF-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FF-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FF-EFF-DATE-FROM
              ), CONVERT(DATE, :FF-EFF-DATE-FROM) )            
                 AND  FF.EFF_DATE_TO    >= IIF(TRY_CONVERT(DATE, 
                                                        :FF-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FF-EFF-DATE-TO
              ), CONVERT(DATE, :FF-EFF-DATE-TO) )              
                 AND  SF.SPECIAL_CALC_CD = 'CB'                         
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  FF.FACTOR                                                 
MFA-TR*         INTO :WS-MAST-EDC-DSCNT-FCTR                                    
MFA-TR*         FROM  CSS_FIXED_FCTR FF                                         
MFA-TR*             , CSS_SPCL_FCTR  SF                                         
MFA-TR*        WHERE  FF.ACCOUNT_NO      = :FF-ACCOUNT-NO                       
MFA-TR*          AND  FF.CODE_UTIL_TYPE  = :FF-CODE-UTIL-TYPE                   
MFA-TR*          AND  FF.IC_NO           = :FF-IC-NO                            
MFA-TR*          AND  FF.FACTOR_ID       = SF.FACTOR_ID                         
MFA-TR*          AND  FF.EFF_DATE_FROM  <= :FF-EFF-DATE-FROM                    
MFA-TR*          AND  FF.EFF_DATE_TO    >= :FF-EFF-DATE-TO                      
MFA-TR*          AND  SF.SPECIAL_CALC_CD = 'CB'                                 
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE ZEROS                  TO WS-MAST-EDC-DSCNT-FCTR  
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSCA291 ABORT **************'        
              DISPLAY '*     7010-GET-EDC-DISCOUNT-FCTR-FF    *'        
              DISPLAY '* ACCOUNT NO       : ' FF-ACCOUNT-NO             
              DISPLAY '* CODE-UTIL-TYPE   : ' FF-CODE-UTIL-TYPE         
              DISPLAY '* IC-NO            : ' FF-IC-NO                  
              DISPLAY '* FF-EFF-DATE-FROM : ' FF-EFF-DATE-FROM          
              DISPLAY '* FF-EFF-DATE-TO   : ' FF-EFF-DATE-TO            
              DISPLAY '* SQLCODE          : ' WS-ACTIVE-RETURN-CODE     
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA291 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * GET EDC DISCOUNT FACTOR FROM FH                               *         
      *****************************************************************         
       7020-GET-EDC-DISCOUNT-FCTR-FH.                                   
                                                                        
           EXEC SQL                                                     
              SELECT  FH.FACTOR                                         
                    , FH.CODE_DEBIT_CREDIT                              
                INTO :WS-MAST-EDC-DSCNT-FCTR                            
                    ,:FH-CODE-DEBIT-CREDIT                              
                FROM  CSS_FIXED_FCT_HIST FH WITH(READUNCOMMITTED)               
                    , CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)               
               WHERE  FH.ACCOUNT_NO          = :FH-ACCOUNT-NO           
                 AND  FH.CODE_UTIL_TYPE      = :FH-CODE-UTIL-TYPE       
                 AND  FH.IC_NO               = :FH-IC-NO                
                 AND  FH.BILL_NO             = :FH-BILL-NO              
                 AND  FH.BILL_ITEM_TIMESTMP  = CIS.CHAR2TIMESTAMP(
                                                 :FH-BILL-ITEM-TIMESTMP
              )   
                 AND  SF.FACTOR_ID           = FH.FACTOR_ID             
                 AND  SF.SPECIAL_CALC_CD     = 'CB'                     
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  FH.FACTOR                                                 
MFA-TR*             , FH.CODE_DEBIT_CREDIT                                      
MFA-TR*         INTO :WS-MAST-EDC-DSCNT-FCTR                                    
MFA-TR*             ,:FH-CODE-DEBIT-CREDIT                                      
MFA-TR*         FROM  CSS_FIXED_FCT_HIST FH                                     
MFA-TR*             , CSS_SPCL_FCTR      SF                                     
MFA-TR*        WHERE  FH.ACCOUNT_NO          = :FH-ACCOUNT-NO                   
MFA-TR*          AND  FH.CODE_UTIL_TYPE      = :FH-CODE-UTIL-TYPE               
MFA-TR*          AND  FH.IC_NO               = :FH-IC-NO                        
MFA-TR*          AND  FH.BILL_NO             = :FH-BILL-NO                      
MFA-TR*          AND  FH.BILL_ITEM_TIMESTMP  = :FH-BILL-ITEM-TIMESTMP           
MFA-TR*          AND  SF.FACTOR_ID           = FH.FACTOR_ID                     
MFA-TR*          AND  SF.SPECIAL_CALC_CD     = 'CB'                             
MFA-TR*      QUERYNO 7020                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE ZEROS TO WS-MAST-EDC-DSCNT-FCTR                   
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSCA291 ABORT **************'        
              DISPLAY '*     7020-GET-EDC-DISCOUNT-FCTR-FH    *'        
              DISPLAY '* ACCOUNT NO         : ' FH-ACCOUNT-NO           
              DISPLAY '* BILL-NO            : ' FH-BILL-NO              
              DISPLAY '* CODE-UTIL-TYPE     : ' FH-CODE-UTIL-TYPE       
              DISPLAY '* IC-NO              : ' FH-IC-NO                
              DISPLAY '* BILL-ITEM-TIMESTMP : ' FH-BILL-ITEM-TIMESTMP   
              DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA291 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * GET DEPENDENT BG FUTURE BILL DATA                             *         
      *****************************************************************         
       7030-GET-DEP-BG-FUTURE-DATA.                                     
                                                                        
           EXEC SQL                                                     
              SELECT  BG.BILL_NO                                        
                    , REPLACE(REPLACE(CONVERT(CHAR(26), 
           BG.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                             
                INTO :BG-BILL-NO                                        
                    ,:BG-BILL-ITEM-TIMESTMP                             
                FROM  CSS_ACCOUNT     AT WITH(READUNCOMMITTED)                  
                    , CSS_BILLING_DET BG WITH(READUNCOMMITTED)                  
                    , CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                  
               WHERE  AT.ACCOUNT_NO         = :BG-ACCOUNT-NO            
                 AND  BI.ACCOUNT_NO         = AT.ACCOUNT_NO             
                 AND  BG.ACCOUNT_NO         = BI.ACCOUNT_NO             
                 AND  BG.IC_NO              = :BG-IC-NO                 
                 AND  BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE        
                 AND  BG.REVENUE_MONTH      = 0                         
                 AND  BG.REV_MTH_ORIG_BILL  = 0                         
                 AND  BG.DATE_ORIG_BILL     IS NULL                     
                 AND  BG.CODE_BILL_CALC     = 'A'                       
                 AND  BG.CODE_BILL_ITM_TYPE = 'C'                       
                 AND  BG.CODE_BILL_ITM_IND  = 'A'                       
                 AND  BI.BILL_NO            = BG.BILL_NO                
                 AND  BI.DATE_BILLED        IS NULL                     
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  BG.BILL_NO                                                
MFA-TR*             , BG.BILL_ITEM_TIMESTMP                                     
MFA-TR*         INTO :BG-BILL-NO                                                
MFA-TR*             ,:BG-BILL-ITEM-TIMESTMP                                     
MFA-TR*         FROM  CSS_ACCOUNT     AT                                        
MFA-TR*             , CSS_BILLING_DET BG                                        
MFA-TR*             , CSS_BILLING_HDR BI                                        
MFA-TR*        WHERE  AT.ACCOUNT_NO         = :BG-ACCOUNT-NO                    
MFA-TR*          AND  BI.ACCOUNT_NO         = AT.ACCOUNT_NO                     
MFA-TR*          AND  BG.ACCOUNT_NO         = BI.ACCOUNT_NO                     
MFA-TR*          AND  BG.IC_NO              = :BG-IC-NO                         
MFA-TR*          AND  BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                
MFA-TR*          AND  BG.REVENUE_MONTH      = 0                                 
MFA-TR*          AND  BG.REV_MTH_ORIG_BILL  = 0                                 
MFA-TR*          AND  BG.DATE_ORIG_BILL     IS NULL                             
MFA-TR*          AND  BG.CODE_BILL_CALC     = 'A'                               
MFA-TR*          AND  BG.CODE_BILL_ITM_TYPE = 'C'                               
MFA-TR*          AND  BG.CODE_BILL_ITM_IND  = 'A'                               
MFA-TR*          AND  BI.BILL_NO            = BG.BILL_NO                        
MFA-TR*          AND  BI.DATE_BILLED        IS NULL                             
MFA-TR*      QUERYNO 7030                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA291 ABORT **************'        
              DISPLAY '*     7030-GET-DEP-BG-FUTURE-DATA      *'        
              DISPLAY '* ACCOUNT NO         : ' BG-ACCOUNT-NO           
              DISPLAY '* CODE-UTIL-TYPE     : ' BG-CODE-UTIL-TYPE       
              DISPLAY '* IC-NO              : ' BG-IC-NO                
              DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA291 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * GET DEPENDENT BG REBILL DATA                                  *         
      *****************************************************************         
       7040-GET-DEP-BG-REBILL-DATA.                                     
                                                                        
           EXEC SQL                                                     
              SELECT  BG.BILL_NO                                        
                    , REPLACE(REPLACE(CONVERT(CHAR(26), 
           BG.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                             
                INTO :BG-BILL-NO                                        
                    ,:BG-BILL-ITEM-TIMESTMP                             
                FROM  CSS_BILLING_DET BG WITH(READUNCOMMITTED)                  
               WHERE  BG.ACCOUNT_NO         = :BG-ACCOUNT-NO            
                 AND  BG.IC_NO              = :BG-IC-NO                 
                 AND  BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE        
                 AND  BG.REV_MTH_ORIG_BILL  = :WS-MAST-REV-MTH-ORIG-BILL
                 AND  BG.REVENUE_MONTH      = 0                         
                 AND  BG.CODE_BILL_CALC     = 'A'                       
                 AND  BG.CODE_BILL_ITM_TYPE = 'C'                       
                 AND  BG.CODE_BILL_ITM_IND  = 'A'                       
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  BG.BILL_NO                                                
MFA-TR*             , BG.BILL_ITEM_TIMESTMP                                     
MFA-TR*         INTO :BG-BILL-NO                                                
MFA-TR*             ,:BG-BILL-ITEM-TIMESTMP                                     
MFA-TR*         FROM  CSS_BILLING_DET BG                                        
MFA-TR*        WHERE  BG.ACCOUNT_NO         = :BG-ACCOUNT-NO                    
MFA-TR*          AND  BG.IC_NO              = :BG-IC-NO                         
MFA-TR*          AND  BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                
MFA-TR*          AND  BG.REV_MTH_ORIG_BILL  = :WS-MAST-REV-MTH-ORIG-BILL        
MFA-TR*          AND  BG.REVENUE_MONTH      = 0                                 
MFA-TR*          AND  BG.CODE_BILL_CALC     = 'A'                               
MFA-TR*          AND  BG.CODE_BILL_ITM_TYPE = 'C'                               
MFA-TR*          AND  BG.CODE_BILL_ITM_IND  = 'A'                               
MFA-TR*      QUERYNO 7040                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA291 ABORT **************'        
              DISPLAY '*     7040-GET-DEP-BG-REBILL-DATA      *'        
              DISPLAY '* ACCOUNT NO        : ' BG-ACCOUNT-NO            
              DISPLAY '* CODE-UTIL-TYPE    : ' BG-CODE-UTIL-TYPE        
              DISPLAY '* IC-NO             : ' BG-IC-NO                 
              DISPLAY '* REV-MTH-ORIG-BILL : ' WS-MAST-REV-MTH-ORIG-BILL
              DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA291 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * GET MASTER MIN PF.                                            *         
      *****************************************************************         
       7050-GET-MASTER-MIN-PF.                                          
                                                                        
           EXEC SQL                                                     
              SELECT  PWR_FCTR_MIN_PCT                                  
                INTO :WS-MAST-MIN-PF                                    
                FROM  CSS_DEMAND_INSTR WITH(READUNCOMMITTED)                    
               WHERE  CODE_UTIL_TYPE   = :DI-CODE-UTIL-TYPE             
                 AND  RATE_PLAN_NO     = :DI-RATE-PLAN-NO               
                 AND  VERSION_NO_CNTRL = :DI-VERSION-NO-CNTRL           
                 AND  CMPNT_ID_CD      = :DI-CMPNT-ID-CD                
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  PWR_FCTR_MIN_PCT                                          
MFA-TR*         INTO :WS-MAST-MIN-PF                                            
MFA-TR*         FROM  CSS_DEMAND_INSTR                                          
MFA-TR*        WHERE  CODE_UTIL_TYPE   = :DI-CODE-UTIL-TYPE                     
MFA-TR*          AND  RATE_PLAN_NO     = :DI-RATE-PLAN-NO                       
MFA-TR*          AND  VERSION_NO_CNTRL = :DI-VERSION-NO-CNTRL                   
MFA-TR*          AND  CMPNT_ID_CD      = :DI-CMPNT-ID-CD                        
MFA-TR*      QUERYNO 7040                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              COMPUTE WS-MAST-MIN-PF EQUAL                              
                      WS-MAST-MIN-PF / 100                              
              END-COMPUTE                                               
           ELSE                                                         
              DISPLAY '********** PCSCA291 ABORT **************'        
              DISPLAY '*     7050-GET-MASTER-MIN-PF           *'        
              DISPLAY '* CODE-UTIL-TYPE  : ' DI-CODE-UTIL-TYPE          
              DISPLAY '* RATE-PLAN-NO    : ' DI-RATE-PLAN-NO            
              DISPLAY '* VERSION-NO-CNTRL: ' DI-VERSION-NO-CNTRL        
              DISPLAY '* CMPNT-ID-CD     : ' DI-CMPNT-ID-CD             
              DISPLAY '* SQLCODE         : ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA291 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * GET KW/KVAR AT PEAK READ                                      *         
      ******************************************************************        
       7060-GET-KW-KVAR-OF-PEAK-READ.                                   
                                                                        
           EXEC SQL                                                     
              SELECT  COALESCE((ROUND(((IR.CHANNEL_A_PULSES)*(((
           CX.CONSTANT)*(4)))),0)),0) 
                    , COALESCE((ROUND(((IR.CHANNEL_B_PULSES)*(((
           CX.CONSTANT)*(4)))),0)),0) 
                INTO :WS-CALC-COIN-KW                                   
                    ,:WS-CALC-COIN-KVAR                                 
                FROM  CSS_INTERVAL_READ IR WITH(READUNCOMMITTED)                
                    , CSS_CNSMPTN_HIST  CX WITH(READUNCOMMITTED)                
               WHERE  CX.CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE        
                 AND  CX.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )    
                 AND  CX.ACCOUNT_NO         = :CX-ACCOUNT-NO            
                 AND  CX.IC_NO              = :CX-IC-NO                 
                 AND  CX.BILL_NO            = :CX-BILL-NO               
                 AND  CX.METER_NO           = :CX-METER-NO              
                 AND  CX.CODE_UTIL_TYPE     = IR.CODE_UTIL_TYPE         
                 AND  CX.BILL_ITEM_TIMESTMP = IR.BILL_ITEM_TIMESTMP     
                 AND  CX.METER_NO           = IR.METER_NO               
                 AND  CX.CODE_USAGE_ID      = '1'                       
                 AND  IR.DATE_READ          = IIF(TRY_CONVERT(DATE, 
                                                :WS-MAST-PEAK-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :WS-MAST-PEAK-DATE-READ
              ) <> 0) OR (LEN(:WS-MAST-PEAK-DATE-READ
              ) <> 10), CIS.CHAR2DATE(:WS-MAST-PEAK-DATE-READ
              ), CONVERT(DATE, :WS-MAST-PEAK-DATE-READ) )   
                 AND  IR.TIME_READ          = CIS.CHAR2TIME(
                                                :WS-MAST-PEAK-TIME-READ
              )   
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  IFNULL((ROUND(MULTIPLY_ALT(IR.CHANNEL_A_PULSES,           
MFA-TR*                             MULTIPLY_ALT(CX.CONSTANT,4)),0)),0)         
MFA-TR*             , IFNULL((ROUND(MULTIPLY_ALT(IR.CHANNEL_B_PULSES,           
MFA-TR*                             MULTIPLY_ALT(CX.CONSTANT,4)),0)),0)         
MFA-TR*         INTO :WS-CALC-COIN-KW                                           
MFA-TR*             ,:WS-CALC-COIN-KVAR                                         
MFA-TR*         FROM  CSS_INTERVAL_READ IR                                      
MFA-TR*             , CSS_CNSMPTN_HIST  CX                                      
MFA-TR*        WHERE  CX.CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE                
MFA-TR*          AND  CX.BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP            
MFA-TR*          AND  CX.ACCOUNT_NO         = :CX-ACCOUNT-NO                    
MFA-TR*          AND  CX.IC_NO              = :CX-IC-NO                         
MFA-TR*          AND  CX.BILL_NO            = :CX-BILL-NO                       
MFA-TR*          AND  CX.METER_NO           = :CX-METER-NO                      
MFA-TR*          AND  CX.CODE_UTIL_TYPE     = IR.CODE_UTIL_TYPE                 
MFA-TR*          AND  CX.BILL_ITEM_TIMESTMP = IR.BILL_ITEM_TIMESTMP             
MFA-TR*          AND  CX.METER_NO           = IR.METER_NO                       
MFA-TR*          AND  CX.CODE_USAGE_ID      = '1'                               
MFA-TR*          AND  IR.DATE_READ          = :WS-MAST-PEAK-DATE-READ           
MFA-TR*          AND  IR.TIME_READ          = :WS-MAST-PEAK-TIME-READ           
MFA-TR*      QUERYNO 7060                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA291 ABORT **************'        
              DISPLAY '*     7060-GET-KW-KVAR-OF-PEAK-READ    *'        
              DISPLAY '* ACCOUNT_NO         : ' CX-ACCOUNT-NO           
              DISPLAY '* BILL_NO            : ' CX-BILL-NO              
              DISPLAY '* CODE_UTIL_TYPE     : ' CX-CODE-UTIL-TYPE       
              DISPLAY '* BILL_ITEM_TIMESTMP : ' CX-BILL-ITEM-TIMESTMP   
              DISPLAY '* IC_NO              : ' CX-IC-NO                
              DISPLAY '* METER_NO           : ' CX-METER-NO             
              DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA291 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * GET NON-COINCIDENTAL ACTUAL PEAK KW                                     
      ******************************************************************        
       7070-GET-NON-COIN-ACTUAL-PEAK.                                   
                                                                        
           EXEC SQL                                                     
              SELECT  COALESCE(MAX(ROUND(((IR.CHANNEL_A_PULSES)*(((
           CX.CONSTANT)*(4)))),0)),0)
                INTO :WS-ACTUAL-MAX-KW                                  
                FROM  CSS_INTERVAL_READ IR WITH(READUNCOMMITTED)                
                    , CSS_CNSMPTN_HIST  CX WITH(READUNCOMMITTED)                
               WHERE  CX.CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE        
                 AND  CX.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )    
                 AND  CX.ACCOUNT_NO         = :CX-ACCOUNT-NO            
                 AND  CX.IC_NO              = :CX-IC-NO                 
                 AND  CX.BILL_NO            = :CX-BILL-NO               
                 AND  CX.METER_NO           = :CX-METER-NO              
                 AND  CX.CODE_UTIL_TYPE     = IR.CODE_UTIL_TYPE         
                 AND  CX.BILL_ITEM_TIMESTMP = IR.BILL_ITEM_TIMESTMP     
                 AND  CX.METER_NO           = IR.METER_NO               
                 AND  CX.CODE_USAGE_ID      = '1'                       
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  IFNULL(MAX(ROUND(MULTIPLY_ALT(IR.CHANNEL_A_PULSES,        
MFA-TR*                              MULTIPLY_ALT(CX.CONSTANT,4)),0)),0)        
MFA-TR*         INTO :WS-ACTUAL-MAX-KW                                          
MFA-TR*         FROM  CSS_INTERVAL_READ IR                                      
MFA-TR*             , CSS_CNSMPTN_HIST  CX                                      
MFA-TR*        WHERE  CX.CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE                
MFA-TR*          AND  CX.BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP            
MFA-TR*          AND  CX.ACCOUNT_NO         = :CX-ACCOUNT-NO                    
MFA-TR*          AND  CX.IC_NO              = :CX-IC-NO                         
MFA-TR*          AND  CX.BILL_NO            = :CX-BILL-NO                       
MFA-TR*          AND  CX.METER_NO           = :CX-METER-NO                      
MFA-TR*          AND  CX.CODE_UTIL_TYPE     = IR.CODE_UTIL_TYPE                 
MFA-TR*          AND  CX.BILL_ITEM_TIMESTMP = IR.BILL_ITEM_TIMESTMP             
MFA-TR*          AND  CX.METER_NO           = IR.METER_NO                       
MFA-TR*          AND  CX.CODE_USAGE_ID      = '1'                               
MFA-TR*      QUERYNO 7070                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA291 ABORT **************'        
              DISPLAY '*   7070-GET-NON-COIN-ACTUAL-PEAK      *'        
              DISPLAY '* ACCOUNT_NO         : ' CX-ACCOUNT-NO           
              DISPLAY '* BILL_NO            : ' CX-BILL-NO              
              DISPLAY '* CODE_UTIL_TYPE     : ' CX-CODE-UTIL-TYPE       
              DISPLAY '* BILL_ITEM_TIMESTMP : ' CX-BILL-ITEM-TIMESTMP   
              DISPLAY '* IC_NO              : ' CX-IC-NO                
              DISPLAY '* METER_NO           : ' CX-METER-NO             
              DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA291 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7070-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * GET EDC BASELINE UNITS FOR SUB ACCOUNT                        *         
      *****************************************************************         
       7080-GET-BASELINE-UNITS.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) BASELINE_UNITS                                    
                INTO :LN-BASELINE-UNITS                                 
                FROM  CSS_BILL_BSLN_CNTR LN WITH(READUNCOMMITTED)               
               WHERE  ACCOUNT_NO       = :LN-ACCOUNT-NO                 
                 AND  CODE_UTIL_TYPE   = :LN-CODE-UTIL-TYPE             
                 AND  IC_NO            = :LN-IC-NO                      
                 AND  CNTRCT_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                    :LN-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :LN-CNTRCT-START-DT
              ) <> 0) OR (LEN(:LN-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:LN-CNTRCT-START-DT
              ), CONVERT(DATE, :LN-CNTRCT-START-DT) )            
                 AND  BASELINE_MONTH   = :LN-BASELINE-MONTH             
ACT184       ORDER BY CNTRCT_START_DT DESC                              
ACT184                                              
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  BASELINE_UNITS                                            
MFA-TR*         INTO :LN-BASELINE-UNITS                                         
MFA-TR*         FROM  CSS_BILL_BSLN_CNTR LN                                     
MFA-TR*        WHERE  ACCOUNT_NO       = :LN-ACCOUNT-NO                         
MFA-TR*          AND  CODE_UTIL_TYPE   = :LN-CODE-UTIL-TYPE                     
MFA-TR*          AND  IC_NO            = :LN-IC-NO                              
MFA-TR*          AND  CNTRCT_START_DT <= :LN-CNTRCT-START-DT                    
MFA-TR*          AND  BASELINE_MONTH   = :LN-BASELINE-MONTH                     
MFA-TR*      ORDER BY CNTRCT_START_DT DESC                                      
MFA-TR*      FETCH FIRST ROW ONLY                                               
MFA-TR*      QUERYNO 7080                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE ZEROS                  TO LN-BASELINE-UNITS       
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSCA291 ABORT **************'        
              DISPLAY '*     7080-GET-BASELINE-UNITS          *'        
              DISPLAY '* ACCOUNT_NO         : ' LN-ACCOUNT-NO           
              DISPLAY '* CODE_UTIL_TYPE     : ' LN-CODE-UTIL-TYPE       
              DISPLAY '* IC_NO              : ' LN-IC-NO                
              DISPLAY '* CNTRCT_START_DT    : ' LN-CNTRCT-START-DT      
              DISPLAY '* BASELINE_MONTH     : ' LN-BASELINE-MONTH       
              DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA291 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * GET ACCOUNT DETAILS                                           *         
      *****************************************************************         
       7100-SEL-ACCOUNT-DET.                                            
                                                                        
           EXEC SQL                                                     
              SELECT  AT.CODE_ACCT_STAT                                 
                    , AT.REV_MTH_LST_NRML                               
                    , AT.BILL_CYCLE                                     
                    , AT.CODE_ACCT_BILLED                               
                    , AT.CUSTOMER_NO                                    
                    , AT.LOCAL_OFFICE                                   
                    , AT.PREMISE_NO                                     
                    , AT.COMPANY_NO                                     
                INTO :AT-CODE-ACCT-STAT                                 
                    ,:AT-REV-MTH-LST-NRML                               
                    ,:AT-BILL-CYCLE                                     
                    ,:AT-CODE-ACCT-BILLED                               
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-LOCAL-OFFICE                                   
                    ,:AT-PREMISE-NO                                     
                    ,:AT-COMPANY-NO                                     
                FROM  CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
               WHERE  AT.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  AT.CODE_ACCT_STAT                                         
MFA-TR*             , AT.REV_MTH_LST_NRML                                       
MFA-TR*             , AT.BILL_CYCLE                                             
MFA-TR*             , AT.CODE_ACCT_BILLED                                       
MFA-TR*             , AT.CUSTOMER_NO                                            
MFA-TR*             , AT.LOCAL_OFFICE                                           
MFA-TR*             , AT.PREMISE_NO                                             
MFA-TR*             , AT.COMPANY_NO                                             
MFA-TR*         INTO :AT-CODE-ACCT-STAT                                         
MFA-TR*             ,:AT-REV-MTH-LST-NRML                                       
MFA-TR*             ,:AT-BILL-CYCLE                                             
MFA-TR*             ,:AT-CODE-ACCT-BILLED                                       
MFA-TR*             ,:AT-CUSTOMER-NO                                            
MFA-TR*             ,:AT-LOCAL-OFFICE                                           
MFA-TR*             ,:AT-PREMISE-NO                                             
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*         FROM  CSS_ACCOUNT AT                                            
MFA-TR*        WHERE  AT.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA291 ABORT **************'        
              DISPLAY '*     7100-SELECT-ACCOUNT-DET          *'        
              DISPLAY '* ACCOUNT NO     : ' AT-ACCOUNT-NO               
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA291 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** OPEN UTL_BILL_REL CURSOR                                    **         
      *****************************************************************         
       7200-OPEN-UTLBILLREL-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
              OPEN  UTL_BILL_REL                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA291 ABORT **************'        
              DISPLAY '*  7200-OPEN-UTLBILLREL-CURSOR         *'        
              DISPLAY '* DEP_REL_START_DT  : ' UR-DEP-REL-START-DT      
              DISPLAY '* DEP_REL_END_DT    : ' UR-DEP-REL-END-DT        
              DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA291 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** FETCH UTL_BILL_REL CURSOR                                   **         
      *****************************************************************         
       7300-FETCH-UTLBILLREL-CURSOR.                                    
                                                                        
           EXEC SQL                                                     
              FETCH  UTL_BILL_REL                                       
               INTO :UR-ACCOUNT-NO-DEP                                  
                   ,:UR-CODE-UTIL-TYPE-DEP                              
                   ,:UR-IC-NO-DEP                                       
                   ,:UR-MTR-REF-NO-DEP                                  
                   ,:UR-DEP-REL-START-DT                                
                   ,:UR-ACCOUNT-NO-MST                                  
                   ,:UR-CODE-UTIL-TYPE-MST                              
                   ,:UR-IC-NO-MST                                       
                   ,:UR-MTR-REF-NO-MST                                  
                   ,:UR-CODE-RELATION-TYPE                              
                   ,:MN-METER-NO                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                  ADD +1                     TO WS-UTLBILLREL-COUNT     
                  IF WS-UTLBILLREL-COUNT > 10                           
                     DISPLAY '********** PCSCA291 ABORT **************' 
                     DISPLAY '*  7300-FETCH-UTLBILLREL-CURSOR        *' 
                     DISPLAY '* WS-UTLBILLREL-COUNT : '                 
                                                WS-UTLBILLREL-COUNT     
                     DISPLAY '* CSS_UTL_BILL_REL  : ARRAY OVERFLOW   *' 
                     DISPLAY '* EXPECTED ROWS ARE 10                 *' 
                     DISPLAY '****************************************' 
                     PERFORM 9900-ABEND         THRU 9900-EXIT          
                  END-IF                                                
              WHEN NOT-FOUND                                            
                  SET NO-MORE-UTL-DATA       TO TRUE                    
              WHEN OTHER                                                
                  DISPLAY '********** PCSCA291 ABORT **************'    
                  DISPLAY '*  7300-FETCH-UTLBILLREL-CURSOR        *'    
                  DISPLAY '* DEP_REL_START_DT  : ' UR-DEP-REL-START-DT  
                  DISPLAY '* DEP_REL_END_DT    : ' UR-DEP-REL-END-DT    
                  DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE
                  DISPLAY '*     PROCESSING TERMINATED            *'    
                  DISPLAY '********** PCSCA291 ABORT **************'    
                  PERFORM 9900-ABEND            THRU 9900-EXIT          
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  CLOSE UTL_BILL_REL CURSOR                                    *         
      *****************************************************************         
       7400-CLOSE-UTLBILLREL-CURSOR.                                    
                                                                        
           EXEC SQL                                                     
              CLOSE  UTL_BILL_REL                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA291 ABORT **************'        
              DISPLAY '*  7400-CLOSE-UTLBILLREL-CURSOR        *'        
              DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA291 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * GET FF FACTOR ID OF SUB ACCOUT                                 *        
      ******************************************************************        
       7500-GET-FACTOR-ID-FF.                                           
                                                                        
           EXEC SQL                                                     
              SELECT  FF.FACTOR_ID                                      
                INTO :FF-FACTOR-ID                                      
                FROM  CSS_SPCL_FCTR  SF WITH(READUNCOMMITTED)                   
                    , CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                   
               WHERE  SF.SPECIAL_CALC_CD = :SF-SPECIAL-CALC-CD          
                 AND  SF.CODE_STATUS     = 'A'                          
                 AND  SF.FACTOR_ID       = FF.FACTOR_ID                 
                 AND  FF.EFF_DATE_FROM  <= IIF(TRY_CONVERT(DATE, 
                                                      :FF-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FF-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FF-EFF-DATE-FROM
              ), CONVERT(DATE, :FF-EFF-DATE-FROM) )            
                 AND  FF.EFF_DATE_TO    >= IIF(TRY_CONVERT(DATE, 
                                                        :FF-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FF-EFF-DATE-TO
              ), CONVERT(DATE, :FF-EFF-DATE-TO) )              
                 AND  FF.ACCOUNT_NO      = :FF-ACCOUNT-NO               
                 AND  FF.IC_NO           = :FF-IC-NO                    
                 AND  FF.CODE_UTIL_TYPE  = :FF-CODE-UTIL-TYPE           
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  FF.FACTOR_ID                                              
MFA-TR*         INTO :FF-FACTOR-ID                                              
MFA-TR*         FROM  CSS_SPCL_FCTR  SF                                         
MFA-TR*             , CSS_FIXED_FCTR FF                                         
MFA-TR*        WHERE  SF.SPECIAL_CALC_CD = :SF-SPECIAL-CALC-CD                  
MFA-TR*          AND  SF.CODE_STATUS     = 'A'                                  
MFA-TR*          AND  SF.FACTOR_ID       = FF.FACTOR_ID                         
MFA-TR*          AND  FF.EFF_DATE_FROM  <= :FF-EFF-DATE-FROM                    
MFA-TR*          AND  FF.EFF_DATE_TO    >= :FF-EFF-DATE-TO                      
MFA-TR*          AND  FF.ACCOUNT_NO      = :FF-ACCOUNT-NO                       
MFA-TR*          AND  FF.IC_NO           = :FF-IC-NO                            
MFA-TR*          AND  FF.CODE_UTIL_TYPE  = :FF-CODE-UTIL-TYPE                   
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA291 ABORT **************'        
              DISPLAY '*     7500-GET-FACTOR-ID-FF               *'     
              DISPLAY '* ACCOUNT_NO     : ' FF-ACCOUNT-NO               
              DISPLAY '* IC_NO          : ' FF-IC-NO                    
              DISPLAY '* CODE_UTIL_TYPE : ' FF-CODE-UTIL-TYPE           
              DISPLAY '* EFF_DATE_FROM  : ' FF-EFF-DATE-FROM            
              DISPLAY '* EFF_DATE_TO    : ' FF-EFF-DATE-TO              
              DISPLAY '* SPECIAL_CALC_CD: ' SF-SPECIAL-CALC-CD          
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA291 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * GET FH FACTOR ID OF SUB ACCOUT                                 *        
      ******************************************************************        
       7550-GET-FACTOR-ID-FH.                                           
                                                                        
           EXEC SQL                                                     
              SELECT  FH.FACTOR_ID                                      
                INTO :FH-FACTOR-ID                                      
                FROM  CSS_SPCL_FCTR       SF WITH(READUNCOMMITTED)              
                    , CSS_FIXED_FCT_HIST  FH WITH(READUNCOMMITTED)              
               WHERE  SF.SPECIAL_CALC_CD    = :SF-SPECIAL-CALC-CD       
                 AND  SF.CODE_STATUS        = 'A'                       
                 AND  SF.FACTOR_ID          = FH.FACTOR_ID              
                 AND  FH.EFF_DATE_FROM     <= IIF(TRY_CONVERT(DATE, 
                                                      :FH-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FH-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FH-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FH-EFF-DATE-FROM
              ), CONVERT(DATE, :FH-EFF-DATE-FROM) )         
                 AND  FH.EFF_DATE_TO       >= IIF(TRY_CONVERT(DATE, 
                                                        :FH-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FH-EFF-DATE-TO
              ) <> 0) OR (LEN(:FH-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FH-EFF-DATE-TO
              ), CONVERT(DATE, :FH-EFF-DATE-TO) )           
                 AND  FH.ACCOUNT_NO         = :FH-ACCOUNT-NO            
                 AND  FH.IC_NO              = :FH-IC-NO                 
                 AND  FH.CODE_UTIL_TYPE     = :FH-CODE-UTIL-TYPE        
                 AND  FH.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :FH-BILL-ITEM-TIMESTMP
              )    
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  FH.FACTOR_ID                                              
MFA-TR*         INTO :FH-FACTOR-ID                                              
MFA-TR*         FROM  CSS_SPCL_FCTR       SF                                    
MFA-TR*             , CSS_FIXED_FCT_HIST  FH                                    
MFA-TR*        WHERE  SF.SPECIAL_CALC_CD    = :SF-SPECIAL-CALC-CD               
MFA-TR*          AND  SF.CODE_STATUS        = 'A'                               
MFA-TR*          AND  SF.FACTOR_ID          = FH.FACTOR_ID                      
MFA-TR*          AND  FH.EFF_DATE_FROM     <= :FH-EFF-DATE-FROM                 
MFA-TR*          AND  FH.EFF_DATE_TO       >= :FH-EFF-DATE-TO                   
MFA-TR*          AND  FH.ACCOUNT_NO         = :FH-ACCOUNT-NO                    
MFA-TR*          AND  FH.IC_NO              = :FH-IC-NO                         
MFA-TR*          AND  FH.CODE_UTIL_TYPE     = :FH-CODE-UTIL-TYPE                
MFA-TR*          AND  FH.BILL_ITEM_TIMESTMP = :FH-BILL-ITEM-TIMESTMP            
MFA-TR*      QUERYNO 7550                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA291 ABORT **************'        
              DISPLAY '*     7550-GET-FACTOR-ID-FH               *'     
              DISPLAY '* ACCOUNT_NO        : ' FH-ACCOUNT-NO            
              DISPLAY '* IC_NO             : ' FH-IC-NO                 
              DISPLAY '* CODE_UTIL_TYPE    : ' FH-CODE-UTIL-TYPE        
              DISPLAY '* EFF_DATE_FROM     : ' FH-EFF-DATE-FROM         
              DISPLAY '* EFF_DATE_TO       : ' FH-EFF-DATE-TO           
              DISPLAY '* BILL_ITEM_TIMESTMP: ' FH-BILL-ITEM-TIMESTMP    
              DISPLAY '* SPECIAL_CALC_CD   : ' SF-SPECIAL-CALC-CD       
              DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA291 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * READ FCSDB07                                                   *        
      ******************************************************************        
       7560-READ-FCSDB07.                                               
                                                                        
           READ FCSDB07-FILE.                                           
                                                                        
           IF FDB07-END-OF-FILE                                         
              GO TO 7560-EXIT                                           
           END-IF.                                                      
                                                                        
           IF FDB07-SUCCESSFUL                                          
              IF E-FDB07-KEY-BREC NOT EQUAL HIGH-VALUES                 
                         OR E-FDB07-KEY-BREC NOT EQUAL LOW-VALUES       
                 IF DATA-RECORD-FOUND                                   
                    ADD +01                  TO WS-FCSDB07-REC-CNTR     
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSCA291 ABORT **************'        
              DISPLAY '*     READ ERROR : DB07 FILE           *'        
              DISPLAY '*     7560-READ-FCSDB07                *'        
              DISPLAY '* FILE-STATUS    : ' WS-FDB07-STATUS             
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA291 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7560-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * UPDATE ACCOUNT TABLE                                           *        
      ******************************************************************        
                                                                        
       8000-UPDATE-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE  CSS_ACCOUNT                                       
                 SET  CODE_ACCT_BILLED  =  :AT-CODE-ACCT-BILLED         
               WHERE  ACCOUNT_NO        =  :AT-ACCOUNT-NO               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA291 ABORT **************'        
              DISPLAY '*      8000-UPDATE-ACCOUNT             *'        
              DISPLAY '* ACCOUNT NO         : ' AT-ACCOUNT-NO           
              DISPLAY '* CODE ACCT BILLED   : ' AT-CODE-ACCT-BILLED     
              DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA291 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * UPDATE FIXED FACTOR                                            *        
      ******************************************************************        
       8050-UPDATE-FACTOR-FF.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE  FF                                  
                 SET  FF.FACTOR           = :FF-FACTOR                  
                    , FF.LAST_UPDATE_TS   = CIS.CURRENT$TIMESTAMP()           
              FROM CSS_FIXED_FCTR FF
               WHERE  FF.ACCOUNT_NO       = :FF-ACCOUNT-NO              
                 AND  FF.CODE_UTIL_TYPE   = :FF-CODE-UTIL-TYPE          
                 AND  FF.IC_NO            = :FF-IC-NO                   
                 AND  FF.EFF_DATE_FROM   <= IIF(TRY_CONVERT(DATE, 
                                                      :FF-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FF-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FF-EFF-DATE-FROM
              ), CONVERT(DATE, :FF-EFF-DATE-FROM) )           
                 AND  FF.EFF_DATE_TO     >= IIF(TRY_CONVERT(DATE, 
                                                        :FF-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FF-EFF-DATE-TO
              ), CONVERT(DATE, :FF-EFF-DATE-TO) )             
                 AND  FF.FACTOR_ID        = :FF-FACTOR-ID               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE  CSS_FIXED_FCTR FF                                         
MFA-TR*          SET  FF.FACTOR           = :FF-FACTOR                          
MFA-TR*             , FF.LAST_UPDATE_TS   = CURRENT TIMESTAMP                   
MFA-TR*        WHERE  FF.ACCOUNT_NO       = :FF-ACCOUNT-NO                      
MFA-TR*          AND  FF.CODE_UTIL_TYPE   = :FF-CODE-UTIL-TYPE                  
MFA-TR*          AND  FF.IC_NO            = :FF-IC-NO                           
MFA-TR*          AND  FF.EFF_DATE_FROM   <= :FF-EFF-DATE-FROM                   
MFA-TR*          AND  FF.EFF_DATE_TO     >= :FF-EFF-DATE-TO                     
MFA-TR*          AND  FF.FACTOR_ID        = :FF-FACTOR-ID                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA291 ABORT **************'        
              DISPLAY '*      8050-UPDATE-FACTOR-FF           *'        
              DISPLAY '* ACCOUNT_NO           : ' FF-ACCOUNT-NO         
              DISPLAY '* CODE_UTIL_TYPE       : ' FF-CODE-UTIL-TYPE     
              DISPLAY '* IC_NO                : ' FF-IC-NO              
              DISPLAY '* FACTOR_ID            : ' FF-FACTOR-ID          
              DISPLAY '* EFF_DATE_FROM        : ' FF-EFF-DATE-FROM      
              DISPLAY '* EFF_DATE_TO          : ' FF-EFF-DATE-TO        
              DISPLAY '* SQLCODE              : ' WS-ACTIVE-RETURN-CODE 
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA291 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * UPDATE FIXED FACTOR HISTORY                                    *        
      ******************************************************************        
       8100-UPDATE-FACTOR-FH.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE  FH                              
                 SET  FH.FACTOR             = :FH-FACTOR                
                    , FH.CODE_DEBIT_CREDIT  = :FH-CODE-DEBIT-CREDIT     
              FROM CSS_FIXED_FCT_HIST FH
               WHERE  FH.ACCOUNT_NO         = :FH-ACCOUNT-NO            
                 AND  FH.CODE_UTIL_TYPE     = :FH-CODE-UTIL-TYPE        
                 AND  FH.IC_NO              = :FH-IC-NO                 
                 AND  FH.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :FH-BILL-ITEM-TIMESTMP
              )    
                 AND  FH.FACTOR_ID          = :FH-FACTOR-ID             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE  CSS_FIXED_FCT_HIST FH                                     
MFA-TR*          SET  FH.FACTOR             = :FH-FACTOR                        
MFA-TR*             , FH.CODE_DEBIT_CREDIT  = :FH-CODE-DEBIT-CREDIT             
MFA-TR*        WHERE  FH.ACCOUNT_NO         = :FH-ACCOUNT-NO                    
MFA-TR*          AND  FH.CODE_UTIL_TYPE     = :FH-CODE-UTIL-TYPE                
MFA-TR*          AND  FH.IC_NO              = :FH-IC-NO                         
MFA-TR*          AND  FH.BILL_ITEM_TIMESTMP = :FH-BILL-ITEM-TIMESTMP            
MFA-TR*          AND  FH.FACTOR_ID          = :FH-FACTOR-ID                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA291 ABORT **************'        
              DISPLAY '*      8100-UPDATE-FACTOR-FH           *'        
              DISPLAY '* ACCOUNT_NO           : ' FH-ACCOUNT-NO         
              DISPLAY '* CODE_UTIL_TYPE       : ' FH-CODE-UTIL-TYPE     
              DISPLAY '* IC_NO                : ' FH-IC-NO              
              DISPLAY '* BILL_ITEM_TIMESTMP   : ' FH-BILL-ITEM-TIMESTMP 
              DISPLAY '* FACTOR_ID            : ' FH-FACTOR-ID          
              DISPLAY '* SQLCODE              : ' WS-ACTIVE-RETURN-CODE 
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA291 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8895-INSERT-WORK-QUEUE                                        *         
      *****************************************************************         
A04860*                                                                         
A04860 8895-INSERT-WORK-QUEUE.                                          
A04860*                                                                         
A04860     CALL SCSCB077 USING CWS00077-FIELDS,                         
A04860                         ABEND-FILE,                              
A04860                         RS-RETURN-CODE                           
A04860     MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE                 
A04860                                                                  
A04860     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
A04860        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A04860        DISPLAY '8895-INSERT-WORK-QUEUE'                          
A04860        DISPLAY 'CALL SCSCB077         '                          
A04860        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
A04860        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
A04860        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
A04860        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A04860        PERFORM 9900-ABEND    THRU 9900-EXIT                      
A04860     END-IF.                                                      
A04860*                                                                         
A04860 8895-EXIT.                                                       
A04860     EXIT.                                                        
      *****************************************************************         
      * 9000-TERMINATE.                                               *         
      *****************************************************************         
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSDB07-FILE.                                          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6240-GET-FCA00-COMMON-DATE.                                   *         
      *****************************************************************         
           COPY CPD00040.                                                       
                                                                        
      *****************************************************************         
      * 6241-GET-FCA00-BILL-CYCLES.                                   *         
      *****************************************************************         
           COPY CPD00041.                                                       
                                                                        
      *****************************************************************         
      * 6251-GET-FJC01-DATE.                                          *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE CPD00037                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * 7600-START-FCSJC01                                            *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * 7620-START-FCSCA00                                            *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * 9900-ABEND                                                    *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPD09900                                                  
           END-EXEC.                                                            
