       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA290.                                        
       AUTHOR.         JIJU CHOVVA.                                     
       DATE-WRITTEN.   MAR 2009.                                        
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRIC & GAS                 **          
      **                                                            **          
      ****************************************************************          
      **                  P R O G R A M S U M M A R Y               **          
      **                                                            **          
      **                                                            **          
      **  PURPOSE :                                                 **          
      **                                                            **          
      **  THIS PROGRAM RUNS AFTER EXTRACT AND PRIOR TO BILLING AND  **          
      **  ANY INTERIM PROCESS CAN BE INCLUDED IN THIS PROGRAM.      **          
      **                                                            **          
      **  THIS PROGRAM RUNS EVERY DAY RIGHT AFTER PCSCA107 AND RUNS **          
      **  IN PARTITION. HAS BUILT-IN COMMIT-RESTART LOGIC.          **          
      **                                                            **          
      **  PROCESSING INCLUDES                                       **          
      **                                                            **          
      **   (A) INSERTS SPECIAL BILL MESSAGES FOR INTIAL AND FINAL   **          
      **       BILL ACCOUNTS. SPECIAL BILL MESSAGES ARE INSERTED    **          
      **       BY CALLING THE MESSAGING SUB PROGRAM SCSCA626.       **          
      **                                                            **          
      ****************************************************************          
      **                                                            **          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      **   DATE     INITIALS   REASON                               **          
      ** --------   --------   ---------------------------------    **          
P00147** 03/28/09   JC91900    NEW PROGRAM.                         **          
I00251** 05/20/09   VY95550    SEB RATE RE-ENGINEERING & GROUP 1 SR **          
I00251**                       CHANGES ARE PULLED OUT FROM PCSCA107 **          
I00484** 10/23/09   MN90523    CHANGES MADE TO DROP THE CONTRACT    **          
I00484**                       ONLY WHEN DURATION REMAINING IS ZERO **          
A37741** 11/16/09   VY95550    S-RETURN-CODE ADDED AS PER CPD00067  **          
A37741**                       CHANGES.                             **          
P00211** 11/16/09   VY95550    CHANGES MADE TO EXTEND THE PENDING   **          
P00211**                       OPTION'S FACTOR TIME PERIOD WHEN THE **          
P00211**                       THE CURRENT CONTRACT HAS GREATER THEN**          
P00211**                       0 DURATION REMAINING NUMBER.         **          
P00211** 12/28/09   JC91900    Adjust start date for factors attchd **          
P00211**                       to a current option code, when acct  **          
P00211**                       final bill on same revenue month.    **          
A00388** 12/30/09   GD97441    ADDED SEASONAL BLOCK FACTORS CALC    **          
A00388**                       LOGIC FROM PCSCA099.                 **          
P00269** 03/03/10   MN90523    INCLUDED OFFER_OPT_START_DT IN DF    **          
P00269**                       INSERT.                              **          
I01119** 12/01/10   VY95550    Changes made to get new drop option  **          
I01119**                       details from SCSCA328                **          
P00496** 12/19/11   GD97441    IND BILLING PROJ - MICHELIN CHANGES  **          
P00496** 02/07/12   GD97441    1.BILL CYCLES ARRAY PROD FIX         **          
P00496**                       2.EXECUTE MICHELIN LOGIC ONLY ONE    **          
P00496**                         TIME                               **          
P00473** 05/17/2011 SB93596    CHGS INCLUDED TO PULL APPROVED       **          
P00473**                       OPTION/OPT ATTR INCTV RECORDS        **          
P00680** 07/17/2012 SS97726    CUSTOMER RETENTION AND ACQUISITION.  **          
A04091** 07/31/2012 VIJAY      SEB CSC CHANGES.                     **          
PRJ680** 08/16/2012 SS97726    Customer Retention, Discounted Rates **          
PRJ680**                       changes.                             **          
ACT092** 08/28/2012 MC95456    Get override revenue month through   **          
ACT092**   APPL3967-ACT92      Job parm.                            **          
A03970** 06/17/2013 AS7C117    ADD JOB PARM FOR COMMONDATE AND      **          
A03970**            ACT016     REVENUE MONTH.THE VALUES             **          
A03970**                       ARE SUPPLIED FROM JCL THROUGH PARM.  **          
A04727** 07/10/2013 MS93554    1.SHOULD STOP DROPPING THE CUSTOMER  **          
A04727**            ACT001     FROM FIXED RATE TO VARIABLE RATE WHEN**          
      **                       CUSTOMER APPLY FINAL BILL WITH MRKT  **          
      **                       SWTCH.                                           
      **                       2.INSERT A NEW ROW IN CSS_FIXED_FCTR **          
      **                       TABLE WITH THE RIGHT DATES AND THE   **          
      **                       SAME PRICE.                          **          
      **                       3.WRITE A TRANSACTION HISTORY.       **          
PRDFIX** 05/12/2014 SS97726    Populate bill cycle regardless.      **          
PRDFIX**                       1st Bill Drop Message missing when 2 **          
PRDFIX**                       billing revenue months are open.     **          
ACT068** 02/24/2015 SS7F226    WORK QUEUE CHANGE TO REPLACE THE     **          
ACT068** A04860                CSS_WQ_ITEMS_MF WITH CSS_WQ_ITEM     **          
ACT068**                       AND REMOVED THE UNUSED CODE.         **          
P00892** 01/05/2015 MC95456    CREATE PENDING OPTION THRU SCSCA326  **          
P00892**                       WHEN AUTO-REN-OPT-IN-FL = 'I'        **          
ACT120** 04/12/2016 VIJAY      MOVE RENWAL OFFER/OPTION IN CREATING **          
ACT120** A05460                AUTO RENEWAL OPTION.                             
ACT211** 10/26/2015 VIJAY      ADD ADDITIONAL INFORMATION IN WQ.    **          
ACT211** A05136                                                     **          
P805CS** 04/05/2016 SS45236    APPLY/EXPIRE CSC DISCOUNTS BASED ON  **          
P805CS**                       CURRENT ELIGIBILITY.                 **          
ACT132** 04/21/2016 VIJAY      PRE-BILLING AUTO RENEWAL CHANGES.    **          
ACT132** A05460                                                     **          
ACT176** 05/23/16   MC95456    INITIALIZE CWS00077-FIELDS TO AVOID  **          
ACT176** A05460                PROBLEM WITH WS-77-USER-ID-ASGN.     **          
I02262** 09/07/16   SS45239    OUTER POOL GROUP VARIABLE DROP.      **          
ACT361** 11/25/16   RS7V450    REMOVE ALL CODE WITH TAG/COMMENTS    **          
ACT361** A05460                P00496.                              **          
      ****************************************************************          
                                                                        
       ENVIRONMENT DIVISION.                                            
                                                                        
       CONFIGURATION SECTION.                                           
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
       COPY CSSDB07.                                                            
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDDB07.                                                            
       COPY FIODB07.                                                            
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA290'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05 WS-ACCOUNT-NO           PIC 9(13)  VALUE ZEROES.          
           05 WS-COMPANY-NO           PIC X(02)  VALUE SPACES.          
           05 WS-BILL-CYCLE           PIC X(02)  VALUE SPACES.          
ACT361     05 WS-PARTITION-NO         PIC 9(02)  VALUE ZEROES.          
           05 WS-CODE-ACCT-STAT       PIC X(01)  VALUE SPACES.          
           05 WS-COMMON-DATE          PIC X(10)  VALUE SPACES.          
I00251     05 WS-RUN-DATE             PIC X(10)  VALUE SPACES.          
           05 WS-REVENUE-MONTH        PIC 9(06)  VALUE ZEROES.          
           05 WS-REVENUE-MONTH-JP     PIC 9(06)  VALUE ZEROES.          
           05 WS-RECORD-CNT           PIC S9(07) COMP-3 VALUE ZEROES.   
COB305     05 WS-REV-MTH-LST-NRML        PIC S9(06)V COMP-3 VALUE 0.            
           05 WS-COUNT-UNSUCCESSFUL-ROWS                                
                                      PIC S9(04) VALUE ZEROES COMP.     
           05 WS-NO-BILL-CYCLES       PIC S9(04) COMP VALUE +0.         
           05 WS-FLAG-TO-TURN-OFF-COMMITS                               
                                      PIC S9(04) COMP VALUE +0.         
COB305     05 WS-PREV-REVENUE-MONTH        PIC S9(06)V COMP-3 VALUE 0.          
COB305     05 WS-OLDEST-REV-MONTH        PIC S9(06)V COMP-3 VALUE 0.            
           05 WS-REV-COUNT            PIC 9(02)  VALUE ZEROES.          
           05 WS-INDEX                PIC 9(02)  VALUE ZEROES.          
           05 WS-HOLD-MESSAGING.                                        
              10 FILLER               PIC X(13)  VALUE SPACES.          
              10 WS-HOLD-COMPANY      PIC X(02)  VALUE SPACES.          
           05 WS-SPCL-MSG-INS-FLAG.                                     
              10 FILLER               PIC X(24)  VALUE SPACES.          
              10 WS-SPCL-MSG-FLAG     PIC X(01)  VALUE SPACES.          
P00211     05 WS-PRV-EFF-DATE-TO      PIC X(10)  VALUE SPACES.          
P00211     05 WS-NEW-EFF-DATE-TO      PIC X(10)  VALUE SPACES.          
P00211     05 WS-PRV-EFF-DATE-FROM    PIC X(10)  VALUE SPACES.          
P00211     05 WS-NEW-EFF-DATE-FROM    PIC X(10)  VALUE SPACES.          
P00211     05 WS-PRV-EFF-REV-MTH      PIC S9(9)  USAGE COMP.            
P00211     05 WS-NEW-EFF-REV-MTH      PIC S9(9)  USAGE COMP.            
P00211     05 WS-CURR-DURATION-REM-NO   PIC S9(4) USAGE COMP.           
P00211     05 WS-CURR-RT-PKG-OPT-SEQ-NO PIC S9(4) USAGE COMP.           
P00211     05 WS-PEND-RT-PKG-OPT-SEQ-NO PIC S9(4) USAGE COMP.           
P00211     05 WS-SKIP-FCTR1             PIC X(09) VALUE SPACES.         
P00211     05 WS-SKIP-FCTR2             PIC X(09) VALUE SPACES.         
P00211     05 WS-REV-MONTH-TMP          PIC 9(06) VALUE ZEROES.         
P00211     05 WS-TEMP-DATE-N REDEFINES WS-REV-MONTH-TMP.                
P00211         10 WS-TEMP-YR-N        PIC 9(4).                         
P00211         10 WS-TEMP-MT-N        PIC 9(2).                         
P00211     05 WS-HOLD-REV-MTH         PIC X(6).                         
P00211     05 WS-HOLD-REV-MTH-N       PIC 9(6).                         
P00211     05 WS-MONTHS-TO-ADD        PIC S9(9)  COMP VALUE 0.          
ACT068     05  WS-INPUT-ZERO          PIC X(16)                         
ACT068                                VALUE '-00.00.00.000000'.         
ACT068     05  WS-INPUT-DATE-26       PIC X(26) VALUE SPACES.           
P00211     05 WS-START-DATE.                                            
P00211         10 WS-START-YR         PIC X(04).                        
P00211         10 FILLER              PIC X(01) VALUE '-'.              
P00211         10 WS-START-MT         PIC X(02).                        
P00211         10 FILLER              PIC X(01) VALUE '-'.              
P00211         10 WS-START-DY         PIC X(02).                        
P00211     05  WS-TEMP-DATE.                                            
P00211         10 WS-TEMP-YR          PIC X(04).                        
P00211         10 FILLER              PIC X(01) VALUE '-'.              
P00211         10 WS-TEMP-MT          PIC X(02).                        
P00211         10 FILLER              PIC X(01) VALUE '-'.              
P00211         10 WS-TEMP-DY          PIC X(02).                        
P00680     05  WS-PRV-MONTHS-REMAIN   PIC S9(4) USAGE COMP VALUE ZEROS. 
P00680     05  WS-PRV-FCTR-EFF-DT     PIC X(10) VALUE SPACES.           
P00680     05  WS-HOLD-DUR-REM        PIC 9(04) VALUE ZEROS.            
P00680     05  WS-HOLD-DUR-REM-X  REDEFINES                             
P00680            WS-HOLD-DUR-REM     PIC Z(04).                        
A04727     05  WS-MRKT-SWTCH          PIC X(01) VALUE 'N'.              
A04727     05  WS-FACT-VAL-Z          PIC -Z(09).9(06).                 
A04727     05  WS-FACTOR-TEXT         PIC 9(9).9(6).                    
A04727     05  WS-DURATION-NO-Z       PIC Z(04).                        
                                                                        
I00251 01  WS-MISC.                                                     
I00251     05 WS-SUB3                 PIC S9(04) VALUE +0.              
I00251     05  WS-TRANS-HIST-CMNT-SF   PIC X(35) VALUE                  
I00251         'GROUP 1 FIXED DROP TO SENIOR RATE  '.                   
I00251     05  WS-TRANS-HIST-CMNT-SV   PIC X(35) VALUE                  
I00251         'GROUP1 VARIABLE DROP TO SENIOR RATE'.                   
I00251     05  WS-TRANS-HIST-CMNT-F    PIC X(35) VALUE                  
I00251         'ACCT DROPPED FROM FIXED RATE.      '.                   
I00251     05  WS-TRANS-HIST-CMNT-V    PIC X(35) VALUE                  
I00251         'ACCT DROPPED FROM VARIABLE RATE.   '.                   
I00251     05  WS-TRANS-HIST-CMNT-FDH  PIC X(35) VALUE                  
I00251         'GROUP 2 FIXED DROP TO HIGH CSC.    '.                   
I00251     05  WS-TRANS-HIST-CMNT-FDM  PIC X(35) VALUE                  
I00251         'GROUP 2 FIXED DROP TO MED CSC.     '.                   
I00251     05  WS-TRANS-HIST-CMNT-FDL  PIC X(35) VALUE                  
I00251         'GROUP 2 FIXED DROP TO LOW CSC.     '.                   
I00251     05  WS-TRANS-HIST-CMNT-VDH  PIC X(35) VALUE                  
I00251         'GROUP 2 VARIABLE DROP TO HIGH CSC. '.                   
I00251     05  WS-TRANS-HIST-CMNT-VDM  PIC X(35) VALUE                  
I00251         'GROUP 2 VARIABLE DROP TO MED CSC.  '.                   
I00251     05  WS-TRANS-HIST-CMNT-VDL  PIC X(35) VALUE                  
I00251         'GROUP 2 VARIABLE DROP TO LOW CSC.  '.                   
I00251     05  WS-TRANS-HIST-CMNT-FDN  PIC X(35) VALUE                  
I00251         'FIXED PRICE DROP NORMAL.           '.                   
I00251     05  WS-TRANS-HIST-CMNT-FD2  PIC X(35) VALUE                  
I00251         'GROUP 2 FIXED DROP NO CSC ADJ.     '.                   
P00211     05  WS-TRANS-HIST-CMNT-FCTR PIC X(35) VALUE                  
P00211         'CURRENT/PENDING FACTORS UPDATED.   '.                   
P00211     05  WS-TRANS-HIST-CMNT-EXPR PIC X(36) VALUE                  
P00211         '          FACTOR EXPIRED DURING DROP'.                  
I00251     05  WS-WQ-COMMENTS          PIC X(55) VALUE                  
I00251         'RATE DROP/PRE-BILL : NO RENEWAL OFFER CODE RETURNED'.   
P00211     05  WS-WQ-COMMENT1.                                          
P00211         10 WS-WQ-CMNT-LINE1     PIC X(39) VALUE                  
P00211            'CURRENT PRICE FACTOR END DATE EXTENDED '.            
P00211         10 WS-WQ-CMNT-LINE2     PIC X(30) VALUE                  
P00211            'DUE TO PENDING RATE ON ACCOUNT'.                     
P00211     05  WS-FINAL-WQ-CMNTS.                                       
P00211         10 WS-FINAL-WQ-CMNTS-01 PIC X(40) VALUE                  
P00211            'Adjusted factor dates due to final bill.'.           
P00211         10 WS-FINAL-WQ-CMNTS-02 PIC X(16) VALUE                  
P00211            ' Verify factors'.                                    
A00388     05  WS-SEASBLK-WQ-COMMENTS.                                  
A00388         10  FILLER                      PIC X(43)  VALUE         
A00388             'WARNING: SEASONAL BLOCK FACTOR AMOUNT = 0. '.       
A00388         10  FILLER                      PIC X(39)  VALUE         
A00388             'PLEASE REVIEW AND CORRECT IT IF NEEDED.'.           
A04727     05  WS-TRANS-COMMENT                PIC X(68)  VALUE         
A04727         'Inserted Fixed Factor to bill Fixed Rate for Switch Away        
A04727-    ' Final Bill.'.                                                      
A04727                                                                  
P00892     05  WS-AUTO-REN-COMMENT-1           PIC X(53)  VALUE         
P00892         'RENEWAL OPTION TERM NOT MATCHED WITH CURR OPTION TERM'. 
ACT211     05  WS-AUTO-REN-COMMENT-2.                                   
ACT211         10  FILLER                      PIC X(44)  VALUE         
ACT211             'RENEWAL OPTON NOT ELIGIBLE FOR AUTO RENEWAL.' .     
ACT211         10  FILLER                      PIC X(23)  VALUE         
ACT211             ' CURRENT OPTION CODE : ' .                          
ACT211         10  WS-CURR-OPTION-CD-WQ        PIC X(12)  VALUE SPACES. 
ACT211         10  FILLER                      PIC X(01)  VALUE SPACES. 
ACT211         10  WS-CURR-OPTION-DESC-WQ      PIC X(50)  VALUE SPACES. 
ACT211         10  FILLER                      PIC X(22)  VALUE         
ACT211             ' RENEWAL OFFER CODE : ' .                           
ACT211         10  WS-REN-OFFER-CD-WQ          PIC X(12)  VALUE SPACES. 
ACT211         10  FILLER                      PIC X(23)  VALUE         
ACT211             ' RENEWAL OPTION CODE : ' .                          
ACT211         10  WS-REN-OPTION-CD-WQ         PIC X(12)  VALUE SPACES. 
ACT211         10  FILLER                      PIC X(01)  VALUE SPACES. 
ACT211         10  WS-REN-OPTION-DESC-WQ       PIC X(50)  VALUE SPACES. 
P00892                                                                  
I00251     05  WS-RT-PKG-OPT-SEQ-NO    PIC S9(04) USAGE COMP VALUE 0.   
I00251     05  WS-TEMP-HOLD.                                            
I00251         10 WS-FIXED-RATE         PIC X(01) VALUE SPACES.         
I00251         10 WS-OFFER-CD-OLD       PIC X(12) VALUE SPACES.         
I00251         10 WS-OFFER-CD-NEW       PIC X(12) VALUE SPACES.         
I00251         10 WS-OPTION-CD-OLD      PIC X(12) VALUE SPACES.         
I00251         10 WS-OPTION-CD-NEW      PIC X(12) VALUE SPACES.         
I00251         10 WS-OPTION-DESC-OLD    PIC X(50) VALUE SPACES.         
I00251         10 WS-OPTION-DESC-NEW    PIC X(50) VALUE SPACES.         
I00251         10 WS-CA328-OFFER-CD     PIC X(12) VALUE SPACES.         
I00251         10 WS-CA328-OPTION-CD    PIC X(12) VALUE SPACES.         
I00251         10 WS-OVR-RT-CALC-TYP-CD PIC X(02) VALUE SPACES.         
I00251         10 WS-TRANS-HIST-CMNT    PIC X(35) VALUE SPACES.         
I00251         10 WS-UPD-STATUS-CD      PIC X(01) VALUE SPACES.         
                                                                        
A00388*** SEABLK FACTORS CALCULATION RELATED WS- VARIABLES                      
A00388     05 WS-SEABLK-VARIABLES.                                      
A00388        10 WS-WINTER-START-MTH  PIC 9(02).                        
A00388        10 WS-CX-MAX-DATE-READ  PIC X(10) VALUE SPACES.           
A00388        10 WS-CX-SUM-NO-DAYS    PIC S9(04) USAGE COMP VALUE 0.    
A00388        10 WS-SEABLK-BEG-DT     PIC X(10) VALUE SPACES.           
A00388        10 WS-SEABLK-END-DT     PIC X(10) VALUE SPACES.           
A00388        10 WS-SEABLK-BEG-REVMTH  PIC 9(06).                       
A00388        10 WS-SEABLK-END-REVMTH  PIC 9(06).                       
A00388        10 WS-WORK-SEABLK-REVMTH PIC 9(06).                       
A00388        10 WS-WORK-SEABLK-DT    PIC X(10) VALUE SPACES.           
COB305        10 WS-TOTAL-BFC-AMT        PIC S9(9)V9(4) USAGE COMP-3 
COB305           VALUE 0.      
COB305        10 WS-BFC-AMT        PIC S9(4)V9(2) USAGE COMP-3 VALUE 0.      
A00388        10 WS-WORK-DATE-FROM    PIC 9(04).                        
A00388        10 WS-WORK-DATE-TO      PIC 9(04).                        
A00388        10 WS-OLD-ACCOUNT-NO    PIC S9(13) USAGE COMP-3 VALUE 0.  
A00388        10 WS-OLD-IC-NO         PIC S9(04) USAGE COMP VALUE 0.    
A00388*                                                                         
I00251 01  RS-RPC-RETURN-CODE.                                          
I00251     05  RS-RETURN-CODE         PIC S9(04) COMP VALUE 0.          
I00251     05  RS-RETURN-CODE-DISP    PIC +Z(04).                       
A37741     05  S-RETURN-CODE          PIC S9(04) COMP VALUE 0.          
I00251                                                                  
       01  WS-NULL-INDICATORS.                                          
           05 WS-NULL-IND-01          PIC S9(04) COMP VALUE +0.         
           05 WS-NULL-IND-02          PIC S9(04) COMP VALUE +0.         
I00251     05 WS-NULL-IND-03          PIC S9(04) COMP VALUE +0.         
I00484     05 WS-NULL-IND-04          PIC S9(04) COMP VALUE +0.         
P00211     05 WS-NULL-IND-05          PIC S9(04) COMP VALUE +0.         
A04019     05 WS-NULL-IND-06          PIC S9(04) COMP VALUE +0.         
A04727     05 WS-NULL-IND-07          PIC S9(04) COMP VALUE +0.         
A04727     05 WS-NULL-IND-08          PIC S9(04) COMP VALUE +0.         
A04727     05 WS-NULL-IND-09          PIC S9(04) COMP VALUE +0.         
                                                                        
       01  WS-SWITCHES.                                                 
I00251     05 WS-NO-MORE-ROWS-01      PIC X(01)  VALUE 'N'.             
I00251        88 NO-MORE-ROWS-01                 VALUE 'Y'.             
           05 WS-FDB07-STATUS         PIC X(02).                        
              88 FDB07-SUCCESSFUL                VALUE '00'.            
              88 FDB07-END-OF-FILE               VALUE '10'.            
           05 WS-COMPANY-STATUS       PIC X(01)  VALUE 'N'.             
              88 COMPANY-ON-HOLD                 VALUE 'Y'.             
           05 WS-DATABASE             PIC 9(01)  VALUE ZERO.            
ACT361        88 WS-CSR-DATABASE                 VALUE 1.               
ACT361        88 WS-SEB-DATABASE                 VALUE 2.               
           05 WS-INS-SPCL-BILL-MSG    PIC X(01)  VALUE 'N'.             
              88 INS-SPCL-BILL-MSG               VALUE 'Y'.             
           05 WS-BEGIN-REC-SW         PIC X(01).                        
              88 WS-BEGIN-RECS-PROCESSED         VALUE 'Y'.             
              88 WS-BEGIN-REC-NOT-PROCESSED      VALUE 'N'.             
              88 WS-START-INPUT-DATA             VALUE 'X'.             
           05 WS-RECORD-FOUND        PIC X(01)   VALUE 'N'.             
              88 DATA-RECORD-FOUND               VALUE 'Y'.             
              88 NO-DATA-RECORD-FOUND            VALUE 'N'.             
I00251     05 WS-SEB-REG-FLAG        PIC X(01)   VALUE 'N'.             
I00251        88 SEB-REGULATED                   VALUE 'Y'.             
I00251     05 WS-CUSTOMER-GROUP      PIC X(03)   VALUE SPACES.          
I00251        88 GROUP1-CUSTOMER                 VALUE '100'.           
I00251        88 GROUP2-CUSTOMER                 VALUE '200'.           
I00251     05 WS-RTPK-AGR-ROW        PIC X(01)   VALUE SPACES.          
I00251        88 EXISTS-IN-RTPK-AGR              VALUE 'Y'.             
I00251        88 NOT-EXISTS-IN-RTPK-AGR          VALUE 'N'.             
I00251     05 WS-CUSTOMER-ON-SR-TIER PIC X(01)   VALUE 'N'.             
I00251        88 CUSTOMER-ON-SR-TIER             VALUE 'S'.             
P00211     05 WS-PEND-OPTION-SW      PIC X(01)   VALUE SPACES.          
P00211        88 PEND-OPTION-EXIST               VALUE 'Y'.             
P00211        88 NOT-EXISTS-PEND-OPTION          VALUE 'N'.             
P00211     05 WS-FCTR-CUSRSOR-SW     PIC X(01)   VALUE 'N'.             
P00211        88 CURR-FCTR-CURSOR                VALUE 'C'.             
P00211        88 PEND-FCTR-CURSOR                VALUE 'P'.             
P00211     05 WS-FCTR-UPDATE-SW      PIC X(01)   VALUE 'N'.             
P00211        88 CURR-FCTR-UPDATED               VALUE 'C'.             
P00211     05 WS-EFF-REV-MTH-SW      PIC X(01)   VALUE 'N'.             
P00211        88 EFF-REV-MTH-UPDATE              VALUE 'Y'.             
A04727     05 WS-FB-AND-MKT-SWITCH   PIC X(01)   VALUE 'N'.             
A04727        88 FB-AND-MKT-SWITCH               VALUE 'Y'.             
A04727        88 NOT-A-FB-AND-MKT-SWITCH         VALUE 'N'.             
                                                                        
       01  WS-RESTART-MISC.                                             
           05  WS-RESTART-DATA-LENGTH    PIC S9(04)  COMP VALUE +45.    
           05  WS-IS-THIS-A-RESTART      PIC X(01)   VALUE 'N'.         
               88  WS-THIS-IS-A-RESTART              VALUE 'Y'.         
               88  WS-THIS-IS-NOT-A-RESTART          VALUE 'N'.         
           05  WS-RESTART-COMMIT-COUNTER PIC 9(04)   VALUE ZERO.        
           05  WS-RESTART-REQ            PIC X(01).                     
           05  WS-DEFAULT-RESTART-REQ    PIC X(01)   VALUE 'N'.         
           05  WS-DEFAULT-CHKP-LUW-LIMIT PIC 9(04)   VALUE 100.         
           05  WS-CHKP-LUW-LIMIT         PIC 9(04)   VALUE ZERO.        
           05  WS-CHKP-LUW-COUNTER       PIC 9(04)   VALUE ZERO COMP-3. 
           05  WS-DEFAULT-CHKP-UPD-LIMIT PIC 9(04)   VALUE 100.         
           05  WS-CHKP-UPD-LIMIT         PIC 9(04)   VALUE ZERO.        
           05  WS-CHKP-UPD-COUNTER       PIC 9(04)   VALUE ZERO COMP-3. 
           05  WS-CHKP-ID.                                              
               10  WS-CHKP-PART-NO       PIC 9(01)   VALUE 1.           
               10  WS-CHKP-SEQ-NO        PIC 9(08)   VALUE ZERO.        
           05  WS-FCSDB07-REC-CNTR       PIC S9(07)  VALUE ZERO COMP-3. 
                                                                        
       01  WS-RESTART-DATA.                                             
           05  WS-RESTART-PROCESS-TYPE   PIC 9(01).                     
           05  WS-RESTART-JOB-COMPLETE   REDEFINES                      
               WS-RESTART-PROCESS-TYPE   PIC X(01).                     
           05  WS-RESTART-JOB-STATUS     PIC X(01).                     
               88  WS-RUN-COMPLETED-NO-PROBLEMS   VALUE 'A'.            
               88  WS-RERUN-COMPLETED             VALUE 'B'.            
               88  WS-RERUN-PENDING               VALUE 'C'.            
           05  WS-RESTART-COMMON-DATE PIC X(10) VALUE SPACES.           
           05  WS-RESTART-CHKP-SEQ-NO PIC 9(08) VALUE 0.                
           05  WS-RESTART-ACCOUNT-NO  PIC 9(13) VALUE 0.                
           05  WS-RESTART-DB07-CNT    PIC 9(09) VALUE 0.                
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-Y                   PIC X(01) VALUE 'Y'.              
           05  WS-N                   PIC X(01) VALUE 'N'.              
           05  WS-I                   PIC X(01) VALUE 'I'.              
           05  WS-ACTIVE              PIC X(01) VALUE 'A'.              
           05  WS-SPACE               PIC X(01) VALUE SPACES.           
           05  RATE                   PIC X(01) VALUE 'R'.              
           05  FINAL-BILL             PIC X(01) VALUE 'B'.              
ACT361     05  OFF-CYC-REBILL         PIC X(01) VALUE 'O'.              
           05  WS-PGRMNAME            PIC X(08) VALUE 'PCSCA290'.       
ACT068     05  SCSCB077               PIC X(08) VALUE 'SCSCB077'.       
           05  SCSCA626               PIC X(08) VALUE 'SCSCA626'.       
           05  PROGRAM-NAME           PIC X(08) VALUE 'PCSCA290'.       
I00251     05  SCSCA328               PIC X(08) VALUE 'SCSCA328'.       
P00892     05  SCSCA326               PIC X(08) VALUE 'SCSCA326'.       
P805CS     05  SCSCA444               PIC X(08) VALUE 'SCSCA444'.       
I00251     05  WS-DROPPED             PIC X(01) VALUE 'D'.              
I00251     05  WS-EXPIRED             PIC X(01) VALUE 'E'.              
I00251     05  WS-NORMAL-BILL         PIC X(01) VALUE 'A'.              
I00251     05  WS-CURRENT             PIC X(01) VALUE 'C'.              
I00251     05  WS-F                   PIC X(01) VALUE 'F'.              
I00251     05  WS-OPTION              PIC X(01) VALUE 'O'.              
P00211     05  WS-PENDING-OPT         PIC X(01) VALUE 'P'.              
A04727     05  WS-ONE                 PIC S9(4) VALUE 1 COMP-3.         
                                                                        
      *****************************************************************         
      *  CWS00010  CONTAINS DB2 ABEND VARIABLES                       *         
      *****************************************************************         
       COPY CWS00010.                                                           
                                                                        
      *****************************************************************         
      *  CWS00038  JOB PARM ROUTINE                                   *         
      *****************************************************************         
       COPY CWS00038.                                                           
                                                                        
      *****************************************************************         
      * IO AREA FOR GETTING THE REVENUE MONTH FROM CSS_JOB_PARM       *         
      *****************************************************************         
       COPY FIOJC01.                                                            
                                                                        
I00251 COPY CWS0070B.                                                   07940000
                                                                        
      *****************************************************************         
      * WORKING STORAGE FOR CPD09900                                  *         
      *****************************************************************         
       COPY CWS09900.                                                           
                                                                        
      *****************************************************************         
      *  COPYBOOK WITH COMMON SQL VARIABLES                           *         
      *****************************************************************         
       COPY CWS00303.                                                           
                                                                        
      *****************************************************************         
      *  COPYBOOK FOR CPD00039                                        *         
      *****************************************************************         
       COPY CWS00039.                                                           
                                                                        
      *****************************************************************         
      *  COPYBOOK WITH JOBS FILE/TABLE DEFINITIONS                    *         
      *****************************************************************         
       COPY FIOCA00.                                                            
                                                                        
      ******************************************************************        
      *    WORKING STORAGE SUPPORT FOR MESSAGING SUBPROGRAM - SCACA626 *        
      ******************************************************************        
       COPY CWS00626.                                                           
                                                                        
ACT068******************************************************************        
ACT068* FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077                   
ACT068**************************************************************            
ACT068*                                                                         
ACT068     EXEC SQL                                                             
ACT068        INCLUDE CWS00077                                                  
ACT068     END-EXEC.                                                            
ACT068*                                                                         
I00251******************************************************************        
P00892******************************************************************        
P00892* WORKING STORAGE COPYBOOK FOR SCSCB326                          *        
P00892******************************************************************        
P00892*                                                                         
P00892     EXEC SQL                                                             
P00892        INCLUDE CWS00326                                                  
P00892     END-EXEC.                                                            
      *                                                                         
I00251*    WORKING STORAGE SUPPORT FOR RENEWAL OFFER CODE   - SCACA328 *        
I00251******************************************************************        
I00251 COPY CWS00328.                                                           
I00251                                                                  
P805CS**** COPYBOOK TO SUPPORT SCSCA444 SUB-ROUTINE CALL                        
P805CS     COPY CWS00444.                                                       
P805CS*                                                                         
      *****************************************************************         
      *    DECLARATION FOR SQL COMMAND AREA                           *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_ACCOUNT, AT                                    *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
I00251*****************************************************************         
I00251*    TABLE : CSS_ACCT_RTPK_AGR, DF                              *         
I00251*****************************************************************         
I00251     EXEC SQL                                                             
I00251         INCLUDE TBACCTRG                                                 
I00251     END-EXEC.                                                            
I00251                                                                  
I00251*****************************************************************         
I00251*    TABLE : CSS_BILLING_DET, BG                                *         
I00251*****************************************************************         
I00251     EXEC SQL                                                             
I00251         INCLUDE TBBLLDET                                                 
I00251     END-EXEC.                                                            
I00251                                                                  
      *****************************************************************         
      * CSS_DELINQUENCY, C8                                           *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
                                                                        
I00251*****************************************************************         
I00251* CSS_FIXED_FCTR, FF                                            *         
I00251*****************************************************************         
I00251     EXEC SQL                                                             
I00251         INCLUDE TBFXDFCT                                                 
I00251     END-EXEC.                                                            
I00251                                                                  
      *****************************************************************         
      *    DCLGEN FOR CSS_JOB_PARM                                    *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
                                                                        
I00251*****************************************************************         
I00251*    TABLE : CSS_ACCT_MKT_TIER, DD                              *         
I00251*****************************************************************         
I00251     EXEC SQL                                                             
I00251         INCLUDE TBMKTIER                                                 
I00251     END-EXEC.                                                            
I00251                                                                  
I00251*****************************************************************         
I00251*    TABLE : CRM_MKT_TIER_ADJ, 1B                               *         
I00251*****************************************************************         
I00251     EXEC SQL                                                             
I00251         INCLUDE TBMKTTAD                                                 
I00251     END-EXEC.                                                            
I00251                                                                  
I00251*****************************************************************         
I00251*    TABLE : CRM_MKT_TIER, IG                                   *         
I00251*****************************************************************         
I00251     EXEC SQL                                                             
I00251         INCLUDE TBMKTTER                                                 
I00251     END-EXEC.                                                            
I00251                                                                  
I00251*****************************************************************         
I00251*    TABLE : CSS_MT_TRN_HST_DET, MI                             *         
I00251*****************************************************************         
I00251     EXEC SQL                                                             
I00251         INCLUDE TBMNHDT                                                  
I00251     END-EXEC.                                                            
I00251                                                                  
I00251*****************************************************************         
I00251*    TABLE : CSS_MNT_TRANS_HIST, MH                             *         
I00251*****************************************************************         
I00251     EXEC SQL                                                             
I00251         INCLUDE TBMNHIST                                                 
I00251     END-EXEC.                                                            
I00251                                                                  
I00251*****************************************************************         
I00251*    TABLE : CRM_OPT_ATTR_INCTV, HQ                             *         
I00251*****************************************************************         
I00251     EXEC SQL                                                             
I00251         INCLUDE TBOPTATT                                                 
I00251     END-EXEC.                                                            
I00251                                                                  
I00251*****************************************************************         
I00251*    TABLE : CSS_REG_PROFILE, LR                                *         
I00251*****************************************************************         
I00251     EXEC SQL                                                             
I00251         INCLUDE TBREGPRF                                                 
I00251     END-EXEC.                                                            
I00251                                                                  
I00251*****************************************************************         
I00251*    TABLE : CRM_RT_PKG_OPTION, FI                              *         
I00251*****************************************************************         
I00251     EXEC SQL                                                             
I00251         INCLUDE TBRTPKGO                                                 
I00251     END-EXEC.                                                            
I00251                                                                  
P00269*****************************************************************         
P00269*    TABLE : CRM_OFFER_OPTION,  E9                              *         
P00269*****************************************************************         
P00269     EXEC SQL                                                             
P00269         INCLUDE TBOFFOPT                                                 
P00269     END-EXEC.                                                            
P00269                                                                  
I00251*****************************************************************         
I00251*    TABLE : CSS_SPCL_FCTR, SF                                  *         
I00251*****************************************************************         
I00251     EXEC SQL                                                             
I00251         INCLUDE TBSPLFTR                                                 
I00251     END-EXEC.                                                            
I00251                                                                  
      *****************************************************************         
      *    TABLE : CSS_UTIL_ENVRNMT, UT                               *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_RESTART, RF                                    *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBRESTRT                                                 
           END-EXEC.                                                            
                                                                        
A00388***************************************************************** 06730000
A00388** CSS_CNSMPTN_HIST, CX                                        ** 06740000
A00388***************************************************************** 06750000
A00388*                                                                 06760000
A00388     EXEC SQL                                                     06770000
A00388        INCLUDE TBCNSMP                                           06780000
A00388     END-EXEC.                                                    06790000
A00388*                                                                 06800000
A00388*****************************************************************         
A00388** CSS_MTRD_ENVRNMT, MN                                        **         
A00388*****************************************************************         
A00388*                                                                 06760000
A00388     EXEC SQL                                                             
A00388         INCLUDE TBMTRENV                                                 
A00388     END-EXEC.                                                            
A00388*                                                                         
A00388***************************************************************** 05150000
A00388** CSS_CUST_PREM_HIST, CH                                      ** 05160000
A00388***************************************************************** 05170000
A00388*                                                                 05180000
A00388     EXEC SQL                                                     05190000
A00388        INCLUDE TBCSTPRM                                          05200000
A00388     END-EXEC.                                                    05210000
A00388*                                                                 05220000
A00388***************************************************************** 04200000
A00388** CSS_BTU_WNA_RANGE, BR                                       ** 04210000
A00388***************************************************************** 04220000
A00388     EXEC SQL                                                     04230000
A00388       INCLUDE TBBTUWNA                                           04240000
A00388     END-EXEC.                                                    04250000
A00388*                                                                 04260000
A00388***************************************************************** 06960000
A00388** CSS_RATE_CREATOR, RT                                        ** 06970000
A00388***************************************************************** 06971000
A00388*                                                                 06972000
A00388     EXEC SQL                                                     06973000
A00388        INCLUDE TBRTCRTR                                          06974000
A00388     END-EXEC.                                                    06975000
A00388*                                                                 06976000
A00388***************************************************************** 06880000
A00388** CSS_RATE_VRSN_DEF, J4                                       ** 06890000
A00388***************************************************************** 06900000
A00388*                                                                 06910000
A00388     EXEC SQL                                                     06920000
A00388        INCLUDE TBRTVRSN                                          06930000
A00388     END-EXEC.                                                    06940000
A00388*                                                                 06950000
A00388***************************************************************** 06977000
A00388** CSS_RATE_USE_SEASN, RS                                      ** 06978000
A00388***************************************************************** 06979000
A00388*                                                                 06980000
A00388     EXEC SQL                                                     06990000
A00388        INCLUDE TBRTUSES                                          07000000
A00388     END-EXEC.                                                    07010000
A00388*                                                                 07020000
A00388***************************************************************** 07110000
A00388** CSS_SPCL_FCTR_APPL, SA                                      ** 07120000
A00388***************************************************************** 07121000
A00388*                                                                 07122000
A00388     EXEC SQL                                                     07123000
A00388        INCLUDE TBSPLAPL                                          07124000
A00388     END-EXEC.                                                    07125000
A00388*                                                                 07126000
A04727**** CSS_ACCT_ATTRIBUTE, YP                                               
A04727     EXEC SQL                                                             
A04727         INCLUDE TBACTATT                                                 
A04727     END-EXEC.                                                            
A04727*                                                                         
      *****************************************************************         
      *    CURSOR DECLARATIONS.                                       *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE UTIL_ENVRNMT_CSR CURSOR WITH HOLD FOR             
                 SELECT UT.RATE_PLAN_NO                                 
                       ,UT.CODE_UTIL_TYPE                               
                   FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                  WHERE UT.ACCOUNT_NO = :UT-ACCOUNT-NO                  
                  GROUP BY UT.RATE_PLAN_NO                              
                          ,UT.CODE_UTIL_TYPE                            
                    FOR READ ONLY                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE UTIL_ENVRNMT_CSR CURSOR WITH HOLD FOR                     
MFA-TR*          SELECT UT.RATE_PLAN_NO                                         
MFA-TR*                ,UT.CODE_UTIL_TYPE                                       
MFA-TR*            FROM CSS_UTIL_ENVRNMT UT                                     
MFA-TR*           WHERE UT.ACCOUNT_NO = :UT-ACCOUNT-NO                          
MFA-TR*           GROUP BY UT.RATE_PLAN_NO                                      
MFA-TR*                   ,UT.CODE_UTIL_TYPE                                    
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
P00211*****************************************************************         
P00211*    CURSOR DECLARATIONS FOR OPTION FACTORS                     *         
P00211*****************************************************************         
P00211     EXEC SQL                                                     
P00211        DECLARE OPTION_FCTR_CSR CURSOR WITH HOLD FOR              
P00211          SELECT FF.FACTOR_ID                                     
P00211                ,FF.EFF_DATE_FROM                                 
P00211                ,FF.EFF_DATE_TO                                   
P00211                ,FF.FIXED_FCTR_SEQ_NO                             
P00211            FROM CSS_FIXED_FCTR     FF                            
P00211           WHERE FF.ACCOUNT_NO           = :FF-ACCOUNT-NO         
P00211             AND FF.CODE_UTIL_TYPE       = :FF-CODE-UTIL-TYPE     
P00211             AND FF.RT_PKG_OPT_SEQ_NO    = :FF-RT-PKG-OPT-SEQ-NO  
P00211             AND FF.IC_NO                = :FF-IC-NO              
P00211             AND FF.DURATION_REMAIN_NO   > 0                      
P00211             AND EXISTS (                                         
P00211              SELECT 1                                            
P00211                FROM CRM_OPT_ATTR_INCTV HQ                        
P00211               WHERE HQ.OPTION_CD = :HQ-OPTION-CD                 
P00211                 AND HQ.FACTOR_ID = FF.FACTOR_ID                  
P00211                 AND HQ.FACTOR_ID  NOT IN (:WS-SKIP-FCTR1,        
P00211                                           :WS-SKIP-FCTR2)        
P00211                 AND HQ.ATTR_INCTV_STRT_DT  <=                    
P00211                                        IIF(TRY_CONVERT(DATE, 
                                                 :HQ-ATTR-INCTV-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-STRT-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-STRT-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-STRT-DT) )    
P00211                 AND HQ.ATTR_INCTV_END_DT   >=                    
P00211                                        IIF(TRY_CONVERT(DATE, 
                                                  :HQ-ATTR-INCTV-END-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-END-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-END-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-END-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-END-DT) )     
P00473                 AND HQ.OPT_ATTR_VSTART_TS  <=                    
P00473                                        CIS.CURRENT$TIMESTAMP()         
P00473                 AND HQ.OPT_ATTR_VEND_TS    >=                    
P00473                                        CIS.CURRENT$TIMESTAMP()         
P00473                 AND HQ.PROC_STATUS_CD       = 'AC'               
P00211                        )                                         
P00211     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE OPTION_FCTR_CSR CURSOR WITH HOLD FOR                      
MFA-TR*         SELECT FF.FACTOR_ID                                             
MFA-TR*               ,FF.EFF_DATE_FROM                                         
MFA-TR*               ,FF.EFF_DATE_TO                                           
MFA-TR*               ,FF.FIXED_FCTR_SEQ_NO                                     
MFA-TR*           FROM CSS_FIXED_FCTR     FF                                    
MFA-TR*          WHERE FF.ACCOUNT_NO           = :FF-ACCOUNT-NO                 
MFA-TR*            AND FF.CODE_UTIL_TYPE       = :FF-CODE-UTIL-TYPE             
MFA-TR*            AND FF.RT_PKG_OPT_SEQ_NO    = :FF-RT-PKG-OPT-SEQ-NO          
MFA-TR*            AND FF.IC_NO                = :FF-IC-NO                      
MFA-TR*            AND FF.DURATION_REMAIN_NO   > 0                              
MFA-TR*            AND EXISTS (                                                 
MFA-TR*             SELECT 1                                                    
MFA-TR*               FROM CRM_OPT_ATTR_INCTV HQ                                
MFA-TR*              WHERE HQ.OPTION_CD = :HQ-OPTION-CD                         
MFA-TR*                AND HQ.FACTOR_ID = FF.FACTOR_ID                          
MFA-TR*                AND HQ.FACTOR_ID  NOT IN (:WS-SKIP-FCTR1,                
MFA-TR*                                          :WS-SKIP-FCTR2)                
MFA-TR*                AND HQ.ATTR_INCTV_STRT_DT  <=                            
MFA-TR*                                       :HQ-ATTR-INCTV-STRT-DT            
MFA-TR*                AND HQ.ATTR_INCTV_END_DT   >=                            
MFA-TR*                                       :HQ-ATTR-INCTV-END-DT             
MFA-TR*                AND HQ.OPT_ATTR_VSTART_TS  <=                            
MFA-TR*                                       CURRENT TIMESTAMP                 
MFA-TR*                AND HQ.OPT_ATTR_VEND_TS    >=                            
MFA-TR*                                       CURRENT TIMESTAMP                 
MFA-TR*                AND HQ.PROC_STATUS_CD       = 'AC'                       
MFA-TR*                       )                                                 
MFA-TR*    END-EXEC.                                                            
                                                                        
P00680* WHEN DROPPING ACCOUNT FROM FIXED RATE TO VARIABLE EXPIRE ANY    52133001
P00680* UNUSED FIXED FACTORS FOR THE CURRENT OPTION.                            
P00680     EXEC SQL                                                     
P00680        DECLARE UNUSED_FACTOR CURSOR WITH HOLD FOR                
P00680         SELECT FF.FACTOR_ID                                      
P00680               ,FF.DURATION_REMAIN_NO                             
P00680               ,FF.EFF_DATE_TO                                    
P00680               ,FF.FIXED_FCTR_SEQ_NO                              
A04019               ,SF.RT_ATTR_INCTV_TYPE                             
P00680           FROM CSS_FIXED_FCTR FF                                 
P00680               ,CSS_SPCL_FCTR  SF                                 
P00680          WHERE FF.ACCOUNT_NO         =  :DF-ACCOUNT-NO           
P00680            AND FF.CODE_UTIL_TYPE     =  :DF-CODE-UTIL-TYPE       
P00680            AND FF.IC_NO              =  :DF-IC-NO                
P00680            AND FF.RT_PKG_OPT_SEQ_NO  =  :DF-RT-PKG-OPT-SEQ-NO    
P00680            AND FF.FACTOR_ID          =  SF.FACTOR_ID             
P00680            AND ((FF.DURATION_REMAIN_NO >  0                      
PRJ680              AND SF.RT_ATTR_INCTV_TYPE IN ('ADJUSTABLE RATE',    
PRJ680                                             'PRICE DISCOUNT',    
PRJ680                                               'CSC DISCOUNT',    
PRJ680                                                'PRICE ADDER',    
PRJ680                                                  'CSC ADDER'))   
P00680                 OR SF.RT_ATTR_INCTV_TYPE  = 'CSC ADJUSTMENT')    
P00680     END-EXEC.                                                    
P00680*                                                                 52133001
                                                                        
A00388* GET SEABLKRES/SEABLKGEN FACTORS WITH FACTOR = 0 & DURATION > 0  52133001
A00388*                                                                 52133001
A00388     EXEC SQL                                                     
A00388        DECLARE SEABLK_CURSOR CURSOR FOR                          
A00388         SELECT FF.IC_NO                                          
A00388               ,FF.FACTOR_ID                                      
A00388               ,FF.FAC_CHRG_BASE_AM                               
A00388               ,FF.FIXED_FCTR_SEQ_NO                              
A00388           FROM CSS_FIXED_FCTR  FF WITH(READUNCOMMITTED)                  
A00388          WHERE FF.ACCOUNT_NO         =  :FF-ACCOUNT-NO           
A00388            AND FF.CODE_UTIL_TYPE     =  'G'                      
A00388            AND FF.FACTOR_ID          IN ('SEABLKRES','SEABLKGEN')
A00388            AND FF.CMPNT_ID_CD        =  '10'                     
A00388            AND FF.CODE_SEASON        =  'B'                      
A00388            AND FF.INSTR_USE_TYPE_CD  =  'R'                      
A00388            AND FF.FACTOR             =  0                        
A00388            AND FF.DURATION_REMAIN_NO >  0                        
A00388         FOR READ ONLY                                    
A00388     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     52133001
MFA-TR*       DECLARE SEABLK_CURSOR CURSOR FOR                                  
MFA-TR*        SELECT FF.IC_NO                                                  
MFA-TR*              ,FF.FACTOR_ID                                              
MFA-TR*              ,FF.FAC_CHRG_BASE_AM                                       
MFA-TR*              ,FF.FIXED_FCTR_SEQ_NO                                      
MFA-TR*          FROM CSS_FIXED_FCTR  FF                                        
MFA-TR*         WHERE FF.ACCOUNT_NO         =  :FF-ACCOUNT-NO                   
MFA-TR*           AND FF.CODE_UTIL_TYPE     =  'G'                              
MFA-TR*           AND FF.FACTOR_ID          IN ('SEABLKRES','SEABLKGEN')        
MFA-TR*           AND FF.CMPNT_ID_CD        =  '10'                             
MFA-TR*           AND FF.CODE_SEASON        =  'B'                              
MFA-TR*           AND FF.INSTR_USE_TYPE_CD  =  'R'                              
MFA-TR*           AND FF.FACTOR             =  0                                
MFA-TR*           AND FF.DURATION_REMAIN_NO >  0                                
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                    52134701
A00388*                                                                 52133001
A03970 LINKAGE SECTION.                                                 
A03970 01  PARMIN.                                                      
A03970     05  PARM-LENGTH                  PIC S9(04) COMP.            
A03970     05  PARM-COMMON-DATE             PIC X(10).                  
A03970     05  PARM-REVENUE-MONTH           PIC X(06).                  
A03970 PROCEDURE DIVISION USING PARMIN.                                 
      ******************************************************************        
      *                                                                *        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
I00251     PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 9000-TERMINATE              THRU 9000-EXIT           
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 0100-INITIALIZATION.                                          *         
      *****************************************************************         
       0100-INITIALIZATION.                                             
                                                                        
           MOVE WS-PGRMNAME                  TO G6-PROGRAM-NAME         
           MOVE 'DATE'                       TO G6-CMND-CODE            
                                                                        
A03970     IF PARM-LENGTH > 0 AND                                       
A03970        PARM-COMMON-DATE  > SPACES                                
A03970        MOVE PARM-COMMON-DATE                 TO   WS-INPUT-DATE  
A03970     ELSE                                                         
A03970        PERFORM 6251-GET-FJC01-DATE           THRU 6251-EXIT      
A03970        IF COMMON-DATE-NEEDED                                     
A03970           PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT      
A03970           MOVE WS-FCA00-COMMON-DATE          TO   WS-INPUT-DATE  
A03970        END-IF                                                    
A03970     END-IF.                                                      
                                                                        
           OPEN INPUT FCSDB07-FILE.                                     
           IF FDB07-SUCCESSFUL                                          
      *       SKIP ALL THE HEADER RECORDS                                       
              PERFORM 0500-PROCESS-BEGIN-REC            THRU  0500-EXIT 
                        UNTIL E-FDB07-KEY-BREC NOT EQUAL LOW-VALUES     
           ELSE                                                         
              DISPLAY '********** PCSCA290 ABORT **************'        
              DISPLAY '*       0100-INITIALIZATION            *'        
              DISPLAY '*    ERROR OPENING FCSDB07 FILE        *'        
              DISPLAY '* FILE STATUS    : ' WS-FDB07-STATUS             
              DISPLAY '*      PROCESSING TERMINATED           *'        
              DISPLAY '********** PCSCA290 ABORT **************'        
              PERFORM 9900-ABEND                THRU  9900-EXIT         
           END-IF                                                       
                                                                        
A03970     IF PARM-LENGTH > 0 AND                                       
A03970        PARM-REVENUE-MONTH > 0                                    
A03970        MOVE PARM-REVENUE-MONTH     TO WS-REVENUE-MONTH-JP        
A03970     ELSE                                                         
A03970        PERFORM 6241-GET-FCA00-BILL-CYCLES THRU 6241-EXIT         
A03970                                                                  
A03970        INITIALIZE WS-SYSIPT                                      
A03970        MOVE WS-PGRMNAME            TO WS-PROGRAM                 
A03970        MOVE WS-DATE                TO WS-COMMAND                 
A03970        MOVE ZEROS                  TO WS-SEQUENCE                
A03970        MOVE WS-KEY-AREA            TO E-FJC01-KEY                
A03970        PERFORM 7600-START-FCSJC01  THRU 7600-EXIt                
A03970        PERFORM 7610-READ-FCSJC01   THRU 7610-EXIT                
A03970                        UNTIL (REVENUE-MONTH AND INPUT-ACTIVE)    
A03970                                              OR END-OF-SYSIPT    
A03970        IF END-OF-SYSIPT                                          
A03970           INITIALIZE WS-SYSIPT                                   
A03970           MOVE 'COMMON'               TO WS-PROGRAM              
A03970           MOVE WS-DATE                TO WS-COMMAND              
A03970           MOVE ZEROS                  TO WS-SEQUENCE             
A03970           MOVE WS-KEY-AREA            TO E-FJC01-KEY             
A03970           PERFORM 7600-START-FCSJC01  THRU 7600-EXIT             
A03970           PERFORM 7610-READ-FCSJC01   THRU 7610-EXIT             
A03970                         UNTIL (REVENUE-MONTH AND INPUT-ACTIVE)   
A03970                                              OR END-OF-SYSIPT    
A03970           EVALUATE TRUE                                          
A03970              WHEN END-OF-SYSIPT                                  
A03970                 DISPLAY '********** PCSCA290 ABORT ********'     
A03970                 DISPLAY '*       0100-INITIALIZATION      *'     
A03970                 DISPLAY '*NO ACTIVE REVENUE MONTH IN COMMON'     
A03970                 DISPLAY '*     PROCESSING TERMINATED      *'     
A03970                 DISPLAY '********** PCSCA290 ABORT ********'     
A03970                 PERFORM 9900-ABEND         THRU  9900-EXIT       
A03970              WHEN WS-REVENUE-MONTH-PARM NOT NUMERIC              
A03970                 DISPLAY '******** PCSCA290 ABORT **********'     
A03970                 DISPLAY '*     0100-INITIALIZATION        *'     
A03970                 DISPLAY '*  REVENUE MONTH PARM NOT NUMERIC*'     
A03970                 DISPLAY '*          KEY = ' E-FJC01-KEY          
A03970                 DISPLAY '*   PROCESSING TERMINATED        *'     
A03970                 DISPLAY '******** PCSCA290 ABORT **********'     
A03970                 PERFORM 9900-ABEND         THRU  9900-EXIT       
A03970              WHEN OTHER                                          
A03970                 PERFORM 7611-CLOSE THRU 7611-EXIT                
A03970                 MOVE WS-REVENUE-MONTH-PARM                       
A03970                                         TO WS-REVENUE-MONTH-JP   
A03970           END-EVALUATE                                           
A03970        ELSE                                                      
A03970           MOVE WS-REVENUE-MONTH-PARM TO WS-REVENUE-MONTH-JP      
A03970        END-IF                                                    
A03970     END-IF.                                                      
A03970                                                                  
           INITIALIZE WS-SYSIPT                                         
           PERFORM 6235-GET-FJC01-RESTART-REQ           THRU 6235-EXIT  
                                                                        
           INITIALIZE WS-SYSIPT                                         
           PERFORM 6253-GET-FJC01-CHKP-LIMIT            THRU 6253-EXIT  
                                                                        
           IF WS-CHKP-LUW-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS       
             AND WS-CHKP-UPD-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS    
                 DISPLAY '****PCSCA290 INFORMATIONAL MESSAGE******'     
                 DISPLAY '*     CHKP-LUW AND CHKP-UPD PARMS      *'     
                 DISPLAY '* BOTH SET TO ' WS-FLAG-TO-TURN-OFF-COMMITS   
                 DISPLAY '* , INTERPRETED TO INDICATE THAT       *'     
                 DISPLAY '* INTERIM COMMIT POINTS SHOULD NOT BE  *'     
                 DISPLAY '* TAKEN. COMPLETE RE-RUN REQUIRED UPON *'     
                 DISPLAY '*    UNSUCCESSFUL COMPLETION.          *'     
                 DISPLAY '* PROCESSING CONTINUING...             *'     
                 DISPLAY '****************************************'     
           END-IF.                                                      
                                                                        
           PERFORM 0200-CHECK-RESTART                   THRU 0200-EXIT. 
                                                                        
           IF WS-THIS-IS-A-RESTART                                      
              PERFORM 0300-PREPARE-RESTART              THRU 0300-EXIT  
           END-IF.                                                      
                                                                        
      *    JOB PARM SWITCH TO DETERMINE SPECAIL BILL MESSAGE INSERT             
      *    FUCNTIONALITY TO SET ACTIVE.                                         
                                                                        
           MOVE SPACES                       TO WS-SYSIPT.              
           MOVE WS-PGRMNAME                  TO WS-PROGRAM.             
           MOVE WS-OPTN                      TO WS-COMMAND.             
           MOVE ZEROS                        TO WS-SEQUENCE.            
           MOVE WS-KEY-AREA                  TO E-FJC01-KEY.            
           PERFORM 7600-START-FCSJC01           THRU 7600-EXIT.         
           PERFORM 7610-READ-FCSJC01            THRU 7610-EXIT          
                        UNTIL (WS-INPUT-DATA-BREAKDOWN(1:24) =          
                        'INSERT SPECIAL BILL MSG=' AND INPUT-ACTIVE)    
                         OR END-OF-SYSIPT.                              
                                                                        
           IF  END-OF-SYSIPT                                            
              DISPLAY '****PCSCA290 INFORMATIONAL MESSAGE******'        
              DISPLAY '*   SPECIAL BILL MESSAGE INSERT JOB    *'        
              DISPLAY '*   NOT FOUND. SPECIAL BILL MESSAGE    *'        
              DISPLAY '*         INSERTS SKIPPED.             *'        
              DISPLAY '* PROCESSING CONTINUING...             *'        
              DISPLAY '****************************************'        
           ELSE                                                         
               MOVE G6-PARM-DATA             TO WS-SPCL-MSG-INS-FLAG    
               IF WS-SPCL-MSG-FLAG EQUAL 'Y'                            
                  SET INS-SPCL-BILL-MSG TO TRUE                         
               ELSE                                                     
                  DISPLAY '****PCSCA290 INFORMATIONAL MESSAGE******'    
                  DISPLAY '*   SPECIAL BILL MESSAGE INSERT JOB    *'    
                  DISPLAY '*   NOT SET TO INACTIVE. SPECIAL BILL  *'    
                  DISPLAY '*      MSG INSERTS WILL BE SKIPPED.    *'    
                  DISPLAY '* PROCESSING CONTINUING...             *'    
                  DISPLAY '****************************************'    
               END-IF                                                   
               PERFORM 7611-CLOSE               THRU 7611-EXIT          
           END-IF.                                                      
                                                                        
I00251     MOVE 'DATABASE'                   TO C8-DELINQ-CD            
I00251     MOVE '01'                         TO C8-COMPANY-NO           
I00251     PERFORM 7010-SELECT-DELINQ-VALUE     THRU 7010-EXIT          
I00251     MOVE C8-DELINQ-VALUE              TO WS-DATABASE             
A00388** GET DELINQUENCY VALUE OF NON-SUMMER-START-MTH                  14090000
ACT361     IF WS-CSR-DATABASE                                           
A00388        MOVE 'NON-SUMMER-START-MTH'    TO C8-DELINQ-CD            
A00388        MOVE '01'                      TO C8-COMPANY-NO           
A00388        PERFORM 7010-SELECT-DELINQ-VALUE THRU 7010-EXIT           
A00388        MOVE C8-DELINQ-VALUE           TO WS-WINTER-START-MTH     
A00388     END-IF.                                                      
                                                                        
           IF INS-SPCL-BILL-MSG                                         
              PERFORM 0600-GET-HOLD-MSG-CMPNY   THRU 0600-EXIT          
           END-IF.                                                      
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0200-CHECK-RESTART.                                            *        
      ******************************************************************        
       0200-CHECK-RESTART.                                              
                                                                        
           MOVE PROGRAM-NAME                 TO RF-NAME-PROGRAM.        
                                                                        
ACT361     MOVE WS-PARTITION-NO              TO RF-PARTITION-NO         
                                                WS-CHKP-PART-NO.        
           MOVE 1                            TO RF-DUP-CNTRL-NO.        
                                                                        
           PERFORM 7900-SELECT-RESTART         THRU 7900-EXIT           
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE RF-RESTART-DATA-TEXT     TO WS-RESTART-DATA         
               IF WS-RESTART-PROCESS-TYPE NUMERIC                       
                  MOVE WS-Y                  TO WS-IS-THIS-A-RESTART    
               END-IF                                                   
           END-IF                                                       
                                                                        
           PERFORM 0605-VALIDATE-RESTART-REQ   THRU 0605-EXIT.          
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0300-PREPARE-RESTART.                                          *        
      ******************************************************************        
       0300-PREPARE-RESTART.                                            
                                                                        
           DISPLAY '*******************************************'        
           DISPLAY '*       THIS IS A RESTART OF PCSCA290     *'        
           DISPLAY '*******************************************'        
                                                                        
           MOVE WS-RESTART-CHKP-SEQ-NO TO WS-CHKP-SEQ-NO                
ACT361     MOVE WS-CHKP-PART-NO        TO WS-PARTITION-NO               
           IF WS-RESTART-COMMON-DATE NOT EQUAL WS-INPUT-DATE            
                          AND WS-RESTART-COMMON-DATE NOT EQUAL SPACES   
              DISPLAY '********** PCSCA290 ABORT **************'        
              DISPLAY '*       0300-PREPARE-RESTART           *'        
              DISPLAY '* COMMON DATE CHANGED PRIOR TO RESTART *'        
              DISPLAY '* COMMON  DATE   : ' WS-INPUT-DATE               
              DISPLAY '* RESTART DATE   : ' WS-RESTART-COMMON-DATE      
              DISPLAY '*      PROCESSING TERMINATED           *'        
              DISPLAY '********** PCSCA290 ABORT **************'        
              PERFORM 9900-ABEND                THRU  9900-EXIT         
           END-IF.                                                      
                                                                        
           PERFORM 7000-READ-FCSDB07            THRU  7000-EXIT         
                       WS-RESTART-DB07-CNT TIMES.                       
I00251                                                                  
I00251     IF E-FDB07-ACCT-NO EQUAL WS-RESTART-ACCOUNT-NO               
I00251        PERFORM 7000-READ-FCSDB07         THRU 7000-EXIT          
I00251     ELSE                                                         
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        DISPLAY '*       0300-PREPARE-RESTART           *'        
I00251        DISPLAY '* ACCOUNT FROM RESTART TABLE DOES NOT  *'        
I00251        DISPLAY '* MATCH WITH DB07 FILE ACCOUNT         *'        
I00251        DISPLAY '* RESTART ACCOUNT : ' WS-RESTART-ACCOUNT-NO      
I00251        DISPLAY '* DB07 ACCOUNT    : ' E-FDB07-ACCT-NO            
I00251        DISPLAY '*      PROCESSING TERMINATED           *'        
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        PERFORM 9900-ABEND                THRU  9900-EXIT         
I00251     END-IF.                                                      
I00251                                                                  
           MOVE ZEROES                 TO WS-RESTART-COMMIT-COUNTER.    
                                                                        
       0300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0400-PREPARE-PRECOMMIT.                                        *        
      *     MOVE ALL THE REQUIRED RESTART RECORD VALUES PRIOR TO UPDATE*        
      ******************************************************************        
       0400-PREPARE-PRECOMMIT.                                          
                                                                        
            ADD  1                           TO WS-CHKP-SEQ-NO.         
            MOVE 1                           TO WS-RESTART-PROCESS-TYPE.
            MOVE WS-C                        TO WS-RESTART-JOB-STATUS.  
            MOVE WS-INPUT-DATE               TO WS-RESTART-COMMON-DATE. 
            MOVE WS-CHKP-SEQ-NO              TO WS-RESTART-CHKP-SEQ-NO. 
            MOVE WS-ACCOUNT-NO               TO WS-RESTART-ACCOUNT-NO.  
            MOVE WS-FCSDB07-REC-CNTR         TO WS-RESTART-DB07-CNT.    
                                                                        
       0400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0500-PROCESS-BEGIN-REC.                                        *        
      ******************************************************************        
       0500-PROCESS-BEGIN-REC.                                          
                                                                        
           PERFORM 7000-READ-FCSDB07           THRU 7000-EXIT           
                                                                        
           EVALUATE TRUE                                                
              WHEN FDB07-END-OF-FILE                                    
                 DISPLAY '********** PCSCA290 ABORT **************'     
                 DISPLAY '*       0500-PROCESS-BEGIN-REC         *'     
                 DISPLAY '*        FCSDB07 FILE IS EMPTY         *'     
                 DISPLAY '*      PROCESSING TERMINATED           *'     
                 DISPLAY '********** PCSCA290 ABORT **************'     
                 PERFORM 9900-ABEND            THRU  9900-EXIT          
              WHEN E-FDB07-KEY-BREC EQUAL LOW-VALUES                    
                 IF E-FDB07-CREATE-DATE-BREC NOT = WS-INPUT-DATE        
                    DISPLAY '********** PCSCA290 ABORT **************'  
                    DISPLAY '*       0500-PROCESS-BEGIN-REC         *'  
                    DISPLAY '* FCSDB07 CREATE DATE NOT = RUN DATE   *'  
                    DISPLAY '* DB07 DATE: ' E-FDB07-CREATE-DATE-BREC    
                    DISPLAY '* RUN  DATE: ' WS-INPUT-DATE               
                    DISPLAY '*      PROCESSING TERMINATED           *'  
                    DISPLAY '********** PCSCA290 ABORT **************'  
                    PERFORM 9900-ABEND         THRU 9900-EXIT           
                 END-IF                                                 
                 IF E-FDB07-DB-PART-BREC  GREATER THAN ZERO             
ACT361               MOVE  E-FDB07-DB-PART-BREC TO WS-PARTITION-NO      
                 ELSE                                                   
                    DISPLAY '*********** PCSCA290 ABORT *************'  
                    DISPLAY '*        0500-PROCESS-BEGIN-REC        *'  
                    DISPLAY '*   FCSDB07 PART NO NOT GREATER THAN 0 *'  
                    DISPLAY '*         PROCESSING TERMINATED        *'  
                    DISPLAY '*********** PCSCA290 ABORT *************'  
                    PERFORM 9900-ABEND          THRU 9900-EXIT          
                 END-IF                                                 
                                                                        
                 SET WS-BEGIN-RECS-PROCESSED   TO TRUE                  
                                                                        
              WHEN WS-BEGIN-RECS-PROCESSED                              
                 IF E-FDB07-KEY-BREC EQUAL HIGH-VALUES OR LOW-VALUES    
                    IF E-FDB07-KEY-BREC EQUAL HIGH-VALUES               
                      AND NO-DATA-RECORD-FOUND                          
                      AND E-FDB07-RECORD-COUNT-EREC EQUAL ZERO          
                       DISPLAY '******* PCSCA290 MESSAGE*********'      
                       DISPLAY '*   0500-PROCESS-BEGIN-REC      *'      
                       DISPLAY '*    FCSDB07 FILE IS EMPTY      *'      
                       DISPLAY '*    PROCESSING CONTINUING...   *'      
                       DISPLAY '******* PCSCA290 ABORT **********'      
                    END-IF                                              
                 ELSE                                                   
                    SET DATA-RECORD-FOUND      TO TRUE                  
                 END-IF                                                 
              WHEN OTHER                                                
                 DISPLAY '********** PCSCA290 ABORT **************'     
                 DISPLAY '*       0500-PROCESS-BEGIN-REC         *'     
                 DISPLAY '*   FIRST RECORD IS NOT A CNTL REC     *'     
                 DISPLAY '*      PROCESSING TERMINATED           *'     
                 DISPLAY '********** PCSCA290 ABORT **************'     
                 PERFORM 9900-ABEND            THRU  9900-EXIT          
           END-EVALUATE.                                                
                                                                        
       0500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0600-GET-HOLD-MSG-CMPNY.                                       *        
      ******************************************************************        
       0600-GET-HOLD-MSG-CMPNY.                                         
                                                                        
           MOVE SPACES                       TO WS-SYSIPT.              
           MOVE WS-PGRMNAME                  TO WS-PROGRAM.             
           MOVE WS-OPTN                      TO WS-COMMAND.             
           MOVE ZEROS                        TO WS-SEQUENCE.            
           MOVE WS-KEY-AREA                  TO E-FJC01-KEY.            
           PERFORM 7600-START-FCSJC01           THRU 7600-EXIT.         
           PERFORM 7610-READ-FCSJC01            THRU 7610-EXIT          
                          UNTIL (WS-INPUT-DATA-BREAKDOWN(1:13) =        
                                    'HOLD COMPANY=' AND INPUT-ACTIVE)   
                          OR END-OF-SYSIPT.                             
                                                                        
           IF  END-OF-SYSIPT                                            
               CONTINUE                                                 
           ELSE                                                         
               MOVE G6-PARM-DATA             TO WS-HOLD-MESSAGING       
               PERFORM 7611-CLOSE               THRU 7611-EXIT          
           END-IF.                                                      
                                                                        
       0600-EXIT.                                                       
           EXIT.                                                        
                                                                        
I00251*****************************************************************         
I00251*                                                               *         
I00251* 1000-PROCESS-INPUT.                                           *         
I00251*  1. PROCESS ALL DB07 ACCOUNTS                                 *         
I00251*  2. UPDATE COMPLETION DETAILS OF RESTART AND RESTART-REQ PARM *         
I00251*****************************************************************         
I00251 1000-PROCESS-INPUT.                                              
I00251                                                                  
I00251     PERFORM 1100-PROCESS-ACCTS           THRU 1100-EXIT          
I00251                                          UNTIL FDB07-END-OF-FILE 
I00251                                                                  
I00251     PERFORM 0400-PREPARE-PRECOMMIT       THRU 0400-EXIT          
I00251                                                                  
I00251     MOVE SPACES                       TO WS-RESTART-JOB-COMPLETE 
I00251     IF WS-THIS-IS-A-RESTART                                      
I00251        MOVE WS-B                      TO WS-RESTART-JOB-STATUS   
I00251     ELSE                                                         
I00251        MOVE WS-A                      TO WS-RESTART-JOB-STATUS   
I00251     END-IF                                                       
I00251                                                                  
I00251     PERFORM 8888-COMMIT                  THRU 8888-EXIT          
I00251                                                                  
I00251     IF WS-RESTART-REQ EQUAL WS-Y                                 
I00251        PERFORM 8893-RESET-RESTART-REQ-PARM                       
I00251                                          THRU 8893-EXIT          
I00251     END-IF.                                                      
I00251                                                                  
I00251     IF WS-THIS-IS-A-RESTART                                      
I00251        DISPLAY 'PCSCA290 RERUN COMPLETED'                        
I00251     ELSE                                                         
I00251        DISPLAY 'PCSCA290 COMPLETED SUCCESSFULLY'                 
I00251     END-IF.                                                      
I00251                                                                  
I00251 1000-EXIT.                                                       
I00251     EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 1100-PROCESS-ACCTS.                                           *         
      *****************************************************************         
       1100-PROCESS-ACCTS.                                              
                                                                        
           IF E-FDB07-KEY-BREC EQUAL HIGH-VALUES OR LOW-VALUES          
               CONTINUE                                                 
           ELSE                                                         
             MOVE E-FDB07-COMPANY-NO        TO WS-COMPANY-NO            
             MOVE E-FDB07-ACCT-NO           TO WS-ACCOUNT-NO            
                                               AT-ACCOUNT-NO            
                                               UT-ACCOUNT-NO            
                                                                        
I00251       PERFORM 7100-SEL-ACCOUNT-DET       THRU 7100-EXIT          
PRDFIX       MOVE AT-BILL-CYCLE             TO WS-BILL-CYCLE            
I00251                                                                  
I00251       IF AT-CODE-ACCT-BILLED = 'X'                               
I00251          PERFORM 7000-READ-FCSDB07       THRU 7000-EXIT          
I00251          GO TO 1100-EXIT                                         
I00251       END-IF                                                     
I00251                                                                  
I00251       PERFORM 5700-FIND-REVENUE-MONTH THRU 5700-EXIT             
I00251                                                                  
ACT361       IF INS-SPCL-BILL-MSG AND WS-CSR-DATABASE                   
                PERFORM 5000-PROCESS-SPCL-BILL-MSGS THRU 5000-EXIT      
             END-IF                                                     
I00251                                                                  
ACT361       IF WS-SEB-DATABASE AND                                     
P805CS         (E-FDB07-OFF-CYCLE-BILL-CODE EQUAL SPACES OR FINAL-BILL) 
I00251                                                                  
I00251          INITIALIZE                     DCLCSS-ACCT-RTPK-AGR     
I00251          MOVE E-FDB07-ACCT-NO        TO DF-ACCOUNT-NO            
I00251          PERFORM 5010-GET-CURR-OFFR-AND-OPTN THRU 5010-EXIT      
I00251                                                                  
I00251          IF EXISTS-IN-RTPK-AGR                                   
I00251             PERFORM 5020-CHECK-IF-DROP-REQUIRED                  
I00251                                              THRU 5020-EXIT      
P00211             IF WS-OVR-RT-CALC-TYP-CD = '02'                      
P00211                IF E-FDB07-OFF-CYCLE-BILL-CODE EQUAL FINAL-BILL   
P00211                   PERFORM 5150-CHECK-FINAL-BILLS                 
P00211                                              THRU 5150-EXIT      
P00211                ELSE                                              
P00211                   PERFORM 5050-CHECK-TO-EXTEND-PEND              
P00211                                              THRU 5050-EXIT      
P00211                END-IF                                            
P00211             END-IF                                               
I00251          END-IF                                                  
P805CS****APPLY/EXPIRE CSC DISCOUNTS BASED ON ELIGIBILITY                       
P805CS          IF AT-ACCOUNT-TYPE-CODE = 'C' OR 'I' OR 'R'             
P805CS             PERFORM 6100-APPLY-DISCOUNTS  THRU 6100-EXIT         
P805CS          END-IF                                                  
I00251       END-IF                                                     
ACT361       IF WS-CSR-DATABASE                                         
A00388          PERFORM 5500-CALC-SEABLK-FCTR THRU 5500-EXIT            
A00388       END-IF                                                     
           END-IF                                                       
           IF WS-RESTART-COMMIT-COUNTER = WS-CHKP-LUW-LIMIT             
                       OR WS-RESTART-COMMIT-COUNTER = WS-CHKP-UPD-LIMIT 
              PERFORM 0400-PREPARE-PRECOMMIT    THRU 0400-EXIT          
              PERFORM 8888-COMMIT               THRU 8888-EXIT          
              MOVE ZEROES                   TO WS-RESTART-COMMIT-COUNTER
           END-IF.                                                      
                                                                        
           PERFORM 7000-READ-FCSDB07            THRU 7000-EXIT.         
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5000-PROCESS-SPCL-BILL-MSGS.                                   *        
      ******************************************************************        
       5000-PROCESS-SPCL-BILL-MSGS.                                     
                                                                        
           IF ( WS-HOLD-COMPANY EQUAL SPACES )                          
              OR ( WS-HOLD-COMPANY GREATER THAN SPACES                  
                    AND WS-COMPANY-NO NOT EQUAL WS-HOLD-COMPANY )       
              MOVE AT-REV-MTH-LST-NRML    TO WS-REV-MTH-LST-NRML        
              MOVE AT-BILL-CYCLE          TO WS-BILL-CYCLE              
              MOVE AT-CODE-ACCT-STAT      TO WS-CODE-ACCT-STAT          
                                                                        
              IF WS-REV-MTH-LST-NRML EQUAL ZEROES                       
                      OR E-FDB07-OFF-CYCLE-BILL-CODE EQUAL FINAL-BILL   
I00251           MOVE 'N'               TO WS-NO-MORE-ROWS-01           
                 PERFORM 7500-OPEN-UTL-ENVRNMT  THRU 7500-EXIT          
                 PERFORM 7510-FETCH-UTL-ENVRNMT THRU 7510-EXIT          
                 PERFORM 5600-PROCESS-UTL-CSR   THRU 5600-EXIT          
I00251                                          UNTIL NO-MORE-ROWS-01   
                 PERFORM 7520-CLOSE-UTL-ENVRNMT THRU 7520-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
I00251*****************************************************************         
I00251*                                                               *         
I00251* 5010-GET-CURR-OFFR-AND-OPTN.                                  *         
I00251*     PERFORMED FOR REGULAR AND OFF CYCLE ACCOUNTS              *         
I00251*****************************************************************         
I00251 5010-GET-CURR-OFFR-AND-OPTN.                                     
I00251*                                                                         
I00251     INITIALIZE                           WS-RT-PKG-OPT-SEQ-NO    
I00251                                          SF-OVR-RT-CALC-TYP-CD   
I00251                                          FF-DURATION-REMAIN-NO   
I00251                                          LR-ACCOUNT-NO           
I00251                                          DCLCSS-BILLING-DET      
I00251                                          DCLCRM-MKT-TIER-ADJ     
I00251                                          DCLCSS-ACCT-MKT-TIER    
I00251                                          DCLCSS-MNT-TRANS-HIST   
I00251                                          DCLCSS-MT-TRN-HST-DET   
I00251                                                                  
I00251     MOVE SPACES                       TO WS-TEMP-HOLD            
I00251                                          WS-CUSTOMER-GROUP       
I00251                                                                  
I00251     MOVE WS-INPUT-DATE                TO WS-RUN-DATE             
I00251     MOVE 'N'                          TO WS-SEB-REG-FLAG         
I00251                                          WS-RTPK-AGR-ROW         
I00251                                                                  
I00251     MOVE DF-ACCOUNT-NO                TO LR-ACCOUNT-NO           
I00251     PERFORM 7110-SELECT-REG-PROFILE      THRU 7110-EXIT          
I00251*                                                                         
I00251* TO GET THE CURRENT OFFER AND OPTION CODE                                
I00251*                                                                         
I00251     PERFORM 7120-SELECT-ACCT-RTPK-AGR    THRU 7120-EXIT          
I00251     MOVE DF-OPTION-CD                 TO WS-OPTION-CD-OLD        
I00251     MOVE DF-OFFER-CD                  TO WS-OFFER-CD-OLD         
I00251*                                                                         
I00251* DETERMINE IF IT'S A FIXED RATE OR VARIABLE RATE CUSTOMER                
I00251*                                                                         
I00251     MOVE DF-COMPANY-NO                TO HQ-COMPANY-NO           
I00251     MOVE DF-OPTION-CD                 TO HQ-OPTION-CD            
I00251     PERFORM 7130-GET-RATE-CALC-TYP-CD    THRU 7130-EXIT          
I00251     MOVE SF-OVR-RT-CALC-TYP-CD        TO WS-OVR-RT-CALC-TYP-CD.  
I00251                                                                  
I00251 5010-EXIT.                                                       
I00251     EXIT.                                                        
I00251                                                                  
I00251*****************************************************************         
I00251*                                                               *         
I00251* 5020-CHECK-IF-DROP-REQUIRED.                                  *         
I00251* ACCOUNTS ARE DROPPED BASED ON THE FOLLOWING                   *         
I00251* FIXED RATE STATUS SHOULD BE 'O' OPEN FOR RENEWAL              *         
I00251* FIXED RATES WILL DROP TO STATUS 'D'                           *         
I00251* VARIABLE RATES WILL EXPIRE  STATUS 'E'                        *         
I00251*****************************************************************         
I00251 5020-CHECK-IF-DROP-REQUIRED.                                     
I00251                                                                  
I00484     MOVE DF-ACCOUNT-NO          TO FF-ACCOUNT-NO                 
A04727                                    YP-ACCOUNT-NO.                
I00484     MOVE DF-CODE-UTIL-TYPE      TO FF-CODE-UTIL-TYPE             
I00484     MOVE DF-IC-NO               TO FF-IC-NO                      
P00211     MOVE DF-RT-PKG-OPT-SEQ-NO   TO FF-RT-PKG-OPT-SEQ-NO          
P00211                                    WS-CURR-RT-PKG-OPT-SEQ-NO.    
I00484     MOVE WS-OPTION-CD-OLD       TO HQ-OPTION-CD.                 
I00484                                                                  
I00484     IF WS-OVR-RT-CALC-TYP-CD = '02'                              
I00484        PERFORM 7155-GET-ACCT-FCTR-DURA-REMAIN                    
I00484                                          THRU 7155-EXIT          
P00211        MOVE FF-DURATION-REMAIN-NO     TO WS-CURR-DURATION-REM-NO 
I00484     END-IF.                                                      
I00484                                                                  
A04727     MOVE WS-N                         TO WS-FB-AND-MKT-SWITCH.   
ACT132     MOVE 'PCSC290D'                   TO WS-CPD00328-CALLING-PGM.
I00251     IF SEB-REGULATED                                             
I00251        PERFORM 7140-CHECK-SEQ-NO         THRU 7140-EXIT          
I00251        IF WS-OVR-RT-CALC-TYP-CD = '02'                           
I00251           IF DF-STATUS-CD = 'O'                                  
I00484              AND FF-DURATION-REMAIN-NO = 0                       
A04727              PERFORM 5022-IS-FB-AND-MKT-SWITCH                   
A04727                                          THRU 5022-EXIT          
A04727              IF NOT-A-FB-AND-MKT-SWITCH                          
I00251                 MOVE WS-DROPPED       TO WS-UPD-STATUS-CD        
I00251                 PERFORM 5030-GET-REN-OFFER                       
                                                THRU 5030-EXIT          
A04727              END-IF                                              
I00251           END-IF                                                 
I00251        ELSE                                                      
I00251           IF DF-ADJ-TIER-SEQ-NO NOT = DD-ADJ-TIER-SEQ-NO         
I00251              MOVE WS-EXPIRED          TO WS-UPD-STATUS-CD        
I00251              PERFORM 5030-GET-REN-OFFER  THRU 5030-EXIT          
I00251           END-IF                                                 
I00251        END-IF                                                    
I00251     ELSE                                                         
I00251        IF WS-OVR-RT-CALC-TYP-CD = '02'                           
I00251           IF DF-STATUS-CD = 'O'                                  
I00484              AND FF-DURATION-REMAIN-NO = 0                       
A04727              PERFORM 5022-IS-FB-AND-MKT-SWITCH                   
A04727                                          THRU 5022-EXIT          
A04727              IF NOT-A-FB-AND-MKT-SWITCH                          
I00251                 MOVE WS-DROPPED       TO WS-UPD-STATUS-CD        
I00251                 PERFORM 5030-GET-REN-OFFER                       
                                                THRU 5030-EXIT          
A04727              END-IF                                              
I00251           END-IF                                                 
P00892           IF DF-STATUS-CD = 'O'                                  
P00892              AND FF-DURATION-REMAIN-NO = 2                       
P00892              AND DF-AUTO-REN-OPT-IN-FL = 'I'                     
ACT120              AND AT-CODE-ACCT-STAT     = 'A'                     
P00892              PERFORM 5300-CREATE-PENDING-OPTION THRU 5300-EXIT   
P00892              GO TO 5020-EXIT                                     
P00892           END-IF                                                 
I00251        ELSE                                                      
I00251           MOVE DF-ACCOUNT-NO          TO FF-ACCOUNT-NO           
I00251           MOVE DF-CODE-UTIL-TYPE      TO FF-CODE-UTIL-TYPE       
I00251           MOVE DF-IC-NO               TO FF-IC-NO                
I00251           MOVE DF-OPTION-CD           TO HQ-OPTION-CD            
I00251           MOVE DF-COMPANY-NO          TO HQ-COMPANY-NO           
I00251           MOVE DF-RT-PKG-OPT-SEQ-NO   TO FF-RT-PKG-OPT-SEQ-NO    
I00251           PERFORM 7150-GET-DURATION-REMAIN THRU 7150-EXIT        
I00251           IF FF-DURATION-REMAIN-NO = 0                           
I00251              MOVE WS-EXPIRED          TO WS-UPD-STATUS-CD        
I00251              PERFORM 5030-GET-REN-OFFER  THRU 5030-EXIT          
I00251           END-IF                                                 
I00251        END-IF                                                    
I00251     END-IF                                                       
I00251                                                                  
A04727*    IF THE CUSTOMER IS APPLIED FINAL BILL AND SWITCH AWAY TO             
A04727*    DIFFERENT MARKET, WE SHOULD NOT DROP HIM TO VARIABLE PRICE.          
I00251     IF FB-AND-MKT-SWITCH                                         
A04727        PERFORM 5025-INSRT-FIXED-FCTR     THRU 5025-EXIT          
A04727     ELSE                                                         
I00251        IF WS-CA328-OFFER-CD > SPACES                             
I00251           PERFORM 5100-DROP-RATE         THRU 5100-EXIT          
A04727        END-IF                                                    
I00251     END-IF.                                                      
I00251                                                                  
I00251 5020-EXIT.                                                       
I00251     EXIT.                                                        
I00251                                                                  
A04727*****************************************************************         
A04727*                                                               *         
A04727* 5022-IS-FB-AND-MKT-SWITCH.                                    *         
A04727*****************************************************************         
A04727 5022-IS-FB-AND-MKT-SWITCH.                                       
A04727                                                                  
A04727     IF E-FDB07-OFF-CYCLE-BILL-CODE EQUAL FINAL-BILL              
A04727        MOVE WS-REVENUE-MONTH          TO WS-REV-MONTH-TMP        
A04727        MOVE WS-TEMP-YR-N              TO WS-START-YR             
A04727        MOVE WS-TEMP-MT-N              TO WS-START-MT             
A04727        MOVE '01'                      TO WS-START-DY             
A04727        MOVE 'EFF_SWITCH_DT'           TO YP-ATTRIBUTE-DESC       
A04727        MOVE WS-START-DATE             TO YP-ATTRIBUTE-VALUE-DT   
A04727        PERFORM 7050-CHK-ACCT-ATTRIBUTE-STAT                      
A04727                                          THRU 7050-EXIT          
A04727     END-IF.                                                      
A04727                                                                  
A04727 5022-EXIT.                                                       
A04727     EXIT.                                                        
A04727                                                                  
A04727*****************************************************************         
A04727*                                                               *         
A04727* 5025-INSRT-FIXED-FCTR.                                        *         
A04727*****************************************************************         
A04727 5025-INSRT-FIXED-FCTR.                                           
A04727                                                                  
A04727     MOVE WS-REVENUE-MONTH              TO WS-REV-MONTH-TMP.      
A04727     MOVE WS-TEMP-YR-N                  TO WS-START-YR.           
A04727     MOVE WS-TEMP-MT-N                  TO WS-START-MT.           
A04727     MOVE '01'                          TO WS-START-DY.           
A04727                                                                  
A04727*    FETCH CURRENT ACTIVE FIXED FACTOR ROW AND INSERT WITH SAME           
A04727*    PRICE WITH THE RIGHT DATE RANGE FOR FINAL BILLED CUSTOMER.           
A04727     PERFORM 7060-GET-CURR-FIXED-FCTR      THRU 7060-EXIT.        
A04727                                                                  
A04727     MOVE WS-START-DATE                 TO FF-EFF-DATE-FROM.      
A04727     MOVE '2999-12-31'                  TO FF-EFF-DATE-TO.        
A04727     PERFORM 7070-GET-MAX-FF-SEQ-NO        THRU 7070-EXIT.        
A04727     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A04727        ADD  WS-ONE                     TO FF-FIXED-FCTR-SEQ-NO   
A04727     ELSE                                                         
A04727        MOVE WS-ONE                     TO FF-FIXED-FCTR-SEQ-NO   
A04727     END-IF.                                                      
A04727     MOVE WS-ONE                        TO FF-DURATION-REMAIN-NO. 
A04727     PERFORM 8200-INSRT-FIXED-FCTR         THRU 8200-EXIT.        
A04727     DISPLAY '### FINAL BILL & MRKT SWTCH ACCT : ' YP-ACCOUNT-NO. 
A04727                                                                  
A04727     PERFORM 5125-WRITE-TRANS-HIST         THRU 5125-EXIT.        
A04727                                                                  
A04727 5025-EXIT.                                                       
A04727     EXIT.                                                        
A04727                                                                  
I00251*****************************************************************         
I00251*                                                               *         
I00251* 5030-GET-REN-OFFER.                                           *         
I00251* CALL SUBROUTINE SCSCA328 TO GET THE NEW RENEWAL OFFER CODE    *         
I00251* GET THE LAST OFFER AND OPTION CODE                            *         
I00251*****************************************************************         
I00251 5030-GET-REN-OFFER.                                              
I00251                                                                  
I00251     MOVE DF-ACCOUNT-NO                TO WS-IN-ACCOUNT-NO        
I00251     MOVE DF-CODE-UTIL-TYPE            TO WS-IN-CODE-UTIL-TYPE    
I00251     MOVE DF-IC-NO                     TO WS-IN-IC-NO             
I00251     MOVE DF-OPTION-CD                 TO WS-IN-OPTION-CD         
ACT132**** MOVE WS-PGRMNAME                  TO WS-CPD00328-CALLING-PGM         
I00251     MOVE SPACES                       TO ABEND-FILE              
I00251     MOVE ZERO                         TO RS-RETURN-CODE          
I00251                                                                  
I00251     CALL SCSCA328 USING                   CWS00328-FIELDS        
I00251                                           WS-RESULT-TABLE        
I00251                                           ABEND-FILE             
I00251                                           RS-RETURN-CODE         
I00251                                                                  
I00251     MOVE RS-RETURN-CODE               TO RS-RETURN-CODE-DISP     
I00251     IF RS-RETURN-CODE NOT EQUAL +0                               
I00251        DISPLAY '********** PCSCA290 ABORT *********'             
I00251        DISPLAY '**  5030-GET-REN-OFFER           **'             
I00251        DISPLAY '*   ERROR ON CALLING SCSCA328     *'             
I00251        DISPLAY 'RETURN CODE  = ' RS-RETURN-CODE-DISP             
I00251        DISPLAY 'ACCOUNT_NO   = ' DF-ACCOUNT-NO                   
I00251        DISPLAY 'CODE_UTIL_TYP= ' DF-CODE-UTIL-TYPE               
I00251        DISPLAY 'IC_NO        = ' DF-IC-NO                        
I00251        DISPLAY 'OPTION_CD    = ' DF-OPTION-CD                    
I00251        DISPLAY 'PGRMNAME     = ' WS-PGRMNAME                     
I00251        DISPLAY 'SCSCA328 - ABEND PARA = ' ACTIVE-PARAGRAPH       
I00251        DISPLAY '*     PROCESSING TERMINATED            *'        
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        PERFORM 9900-ABEND                THRU 9900-EXIT          
I00251     END-IF                                                       
I00251                                                                  
I00251     IF WS-SUB-CTR > 0                                            
I01119        MOVE WS-DROP-OFFER-CD          TO WS-CA328-OFFER-CD       
I01119        MOVE WS-DROP-OPTION            TO WS-CA328-OPTION-CD      
I00251     ELSE                                                         
ACT176         INITIALIZE CWS00077-FIELDS                               
ACT068         MOVE 17                       TO WS-77-CATEGORY-ID       
ACT068         MOVE WS-WQ-COMMENTS           TO WS-77-COMMENTS-TEXT     
ACT068         MOVE LENGTH OF WS-WQ-COMMENTS TO WS-77-COMMENTS-LEN      
I00251         PERFORM 5040-PROCESS-WQ          THRU 5040-EXIT          
I00251     END-IF.                                                      
I00251                                                                  
I00251 5030-EXIT.                                                       
I00251     EXIT.                                                        
I00251                                                                  
P00892*****************************************************************         
P00892*                                                               *         
P00892* 5300-CREATE-PENDING-OPTION.                                   *         
P00892*****************************************************************         
P00892 5300-CREATE-PENDING-OPTION.                                      
P00892                                                                  
ACT132     MOVE 'PCSC290A'                  TO WS-CPD00328-CALLING-PGM. 
P00892     PERFORM 5030-GET-REN-OFFER       THRU 5030-EXIT.             
P00892     PERFORM 7060-GET-CURR-FIXED-FCTR THRU 7060-EXIT.             
P00892     MOVE FF-FACTOR-ID                TO HQ-FACTOR-ID.            
P00892     PERFORM 7250-GET-DURATION-NO     THRU 7250-EXIT.             
P00892     MOVE WS-N                        TO FI-AUTO-RENEWAL-FL.      
P00892     MOVE DF-OPTION-CD                TO FI-OPTION-CD.            
P00892     PERFORM 7255-CHK-AUTO-RENEWAL-FL THRU 7255-EXIT.             
P00892     IF WS-RET-OPTN-VALID-MNTHS(1) NOT EQUAL HQ-DURATION-NO       
ACT176        INITIALIZE CWS00077-FIELDS                                
P00892        MOVE 579                      TO WS-77-CATEGORY-ID        
P00892        MOVE WS-AUTO-REN-COMMENT-1    TO WS-77-COMMENTS-TEXT      
P00892        MOVE LENGTH OF WS-AUTO-REN-COMMENT-1                      
P00892                                      TO WS-77-COMMENTS-LEN       
P00892        PERFORM 5040-PROCESS-WQ       THRU 5040-EXIT              
P00892        MOVE 'X'                      TO AT-CODE-ACCT-BILLED      
P00892        PERFORM 8000-UPDATE-ACCOUNT   THRU  8000-EXIT             
P00892     ELSE                                                         
P00892        IF FI-AUTO-RENEWAL-FL  NOT EQUAL WS-Y                     
ACT176           INITIALIZE CWS00077-FIELDS                             
P00892           MOVE 579                   TO WS-77-CATEGORY-ID        
ACT211           MOVE DF-OPTION-CD          TO FI-OPTION-CD             
ACT211                                         WS-CURR-OPTION-CD-WQ     
ACT211           MOVE DF-COMPANY-NO         TO FI-COMPANY-NO            
ACT211           PERFORM 7200-GET-OPTION-DESC  THRU 7200-EXIT           
ACT211           MOVE FI-OPT-DESC-INT       TO WS-CURR-OPTION-DESC-WQ   
ACT211           MOVE WS-RET-OPTION-CD(1)   TO FI-OPTION-CD             
ACT211                                         WS-REN-OPTION-CD-WQ      
ACT211           MOVE DF-COMPANY-NO         TO FI-COMPANY-NO            
ACT211           PERFORM 7200-GET-OPTION-DESC  THRU 7200-EXIT           
ACT211           MOVE FI-OPT-DESC-INT       TO WS-REN-OPTION-DESC-WQ    
ACT211           MOVE WS-RET-RENEWAL-OFFER-CD(1)                        
ACT211             TO WS-REN-OFFER-CD-WQ                                
P00892           MOVE WS-AUTO-REN-COMMENT-2 TO WS-77-COMMENTS-TEXT      
P00892           MOVE LENGTH OF WS-AUTO-REN-COMMENT-2                   
P00892                                         TO WS-77-COMMENTS-LEN    
P00892           PERFORM 5040-PROCESS-WQ       THRU 5040-EXIT           
P00892           MOVE 'X'                      TO AT-CODE-ACCT-BILLED   
P00892           PERFORM 8000-UPDATE-ACCOUNT   THRU  8000-EXIT          
P00892        ELSE                                                      
P00892           PERFORM 5310-CALL-SCSCA326    THRU 5310-EXIT           
P00892     END-IF
           END-IF.                                                      
P00892                                                                  
P00892  5300-EXIT.                                                      
P00892       EXIT.                                                      
P00892                                                                  
P00892*****************************************************************         
P00892*                                                               *         
P00892* 5310-CALL-SCSCA326.                                           *         
P00892*****************************************************************         
P00892  5310-CALL-SCSCA326.                                             
P00892                                                                  
P00892     MOVE DF-ACCOUNT-NO                TO WS-ACCOUNT-NO-O.        
P00892     MOVE DF-CODE-UTIL-TYPE            TO WS-CODE-UTIL-TYPE-O.    
P00892     MOVE DF-IC-NO                     TO WS-IC-NO-O.             
ACT120     MOVE WS-RET-RENEWAL-OFFER-CD(1)   TO WS-OFFER-CD-O.          
ACT120     MOVE WS-RET-OPTION-CD(1)          TO WS-OPTION-CD-O.         
P00892     MOVE 'A'                          TO WS-COMM-CHANNEL-O.      
P00892     MOVE 'SYSTEM'                     TO WS-CREATED-USER-ID-O.   
P00892     MOVE WS-PENDING-OPT               TO WS-PROCESS-CD-O.        
P00892     MOVE PROGRAM-NAME                 TO WS-APPL-PGMID.          
P00892     MOVE DF-AUTO-REN-OPT-IN-FL        TO WS-AUTO-REN-OPT-IN-FL-O.
P00892     MOVE 'N'                          TO WS-EXIT-FEE-FLAG-O.     
P00892     MOVE ZEROS                        TO WS-EXIT-FEE-AMT-O.      
P00892     MOVE SPACES                       TO WS-PROMO-CD-O.          
P00892     MOVE DF-RT-PKG-OPT-SEQ-NO         TO WS-RT-PKG-OPT-SEQ-NO-O. 
P00892     PERFORM 7190-GET-CURR-TIMESTAMP   THRU 7190-EXIT.            
P00892     MOVE MH-TRANS-HIST-SEQ-NO(1:10)                              
P00892                                       TO WS-OPT-AGRMT-EFF-DT-O.  
P00892     MOVE MH-TRANS-HIST-SEQ-NO(12:8)                              
P00892                                       TO WS-OPT-AGRMT-EFF-TM-O.  
P00892                                                                  
P00892     CALL SCSCA326 USING  ABEND-FILE                              
P00892                         ,WS-WARNING-DATA-ELEMENTS                
P00892                         ,LS-MCSCB326-CALL-TYPE                   
P00892                         ,LS-MCSCB326-ONLINE-CALL                 
P00892                         ,LS-MCSCB326-RET-FIELDS                  
P00892                                                                  
P00892     MOVE RS-RETURN-CODE               TO RS-RETURN-CODE-DISP     
P00892     IF RS-RETURN-CODE NOT EQUAL +0                               
P00892        DISPLAY '********** PCSCA290 ABORT *********'             
P00892        DISPLAY '**  5030-CALL-SCSCA326           **'             
P00892        DISPLAY '*   ERROR ON CALLING SCSCA326     *'             
P00892        DISPLAY 'RETURN CODE  = ' RS-RETURN-CODE-DISP             
P00892        DISPLAY 'ACCOUNT_NO   = ' DF-ACCOUNT-NO                   
P00892        DISPLAY 'CODE_UTIL_TYP= ' DF-CODE-UTIL-TYPE               
P00892        DISPLAY 'IC_NO        = ' DF-IC-NO                        
P00892        DISPLAY 'OPTION_CD    = ' DF-OPTION-CD                    
P00892        DISPLAY 'PGRMNAME     = ' WS-PGRMNAME                     
P00892        DISPLAY 'SCSCA328 - ABEND PARA = ' ACTIVE-PARAGRAPH       
P00892        DISPLAY '*     PROCESSING TERMINATED            *'        
P00892        DISPLAY '********** PCSCA290 ABORT **************'        
P00892        PERFORM 9900-ABEND                THRU 9900-EXIT          
P00892     END-IF.                                                      
P00892                                                                  
P00892 5310-EXIT.                                                       
P00892     EXIT.                                                        
P00892                                                                  
I00251*****************************************************************         
I00251*                                                               *         
I00251* 5040-PROCESS-WQ.                                              *         
I00251*****************************************************************         
I00251 5040-PROCESS-WQ.                                                 
I00251                                                                  
ACT068     MOVE 'N'                          TO WS-77-PRIORITY          
ACT068     MOVE ZEROS                        TO WS-77-SERV-ORDER-NO     
ACT068     MOVE SPACES                       TO WS-77-RESP-AREA-ID      
I00251     MOVE WS-INPUT-DATE                TO WS-77-DATE-REQUIRED     
ACT068                                          WS-INPUT-DATE-26(1:10)  
ACT068     MOVE WS-INPUT-ZERO                TO WS-INPUT-DATE-26(11:16) 
ACT068     MOVE WS-INPUT-DATE-26             TO WS-77-DATE-CREATED      
ACT068     MOVE AT-ACCOUNT-NO                TO WS-77-ACCOUNT-NO        
ACT068     MOVE AT-PREMISE-NO                TO WS-77-PREMISE-NO        
ACT068     MOVE AT-CUSTOMER-NO               TO WS-77-CUSTOMER-NO       
ACT068     MOVE AT-LOCAL-OFFICE              TO WS-77-LOCAL-OFFICE      
ACT068     MOVE 4                            TO WS-77-ROUTE-CATEGORY    
ACT068     MOVE ZEROS                        TO WS-77-FREE-FORM-LEN     
ACT068     MOVE LOW-VALUES                   TO WS-77-FREE-FORM-TXT     
ACT361     MOVE WS-PGRMNAME           TO WS-77-CREATED-BY               
I00251     PERFORM 8895-INSERT-WORK-QUEUE       THRU 8895-EXIT.         
I00251                                                                  
I00251 5040-EXIT.                                                       
I00251     EXIT.                                                        
I00251                                                                  
P00211*****************************************************************         
P00211*                                                               *         
P00211* 5050-CHECK-TO-EXTEND-PEND.                                    *         
P00211* EXTEND THE PENDING OPTION FACTORS WHEN THE CURRENT CONTRACT   *         
P00211* HAS > 0 DURATION REMAINING MONTHS AND THE PENDING OPTION'S    *         
P00211* STATUS EFFECTIVE REVENUE MONTH EQUALS CURRNENT REVENUE MONTH  *         
P00211*****************************************************************         
P00211 5050-CHECK-TO-EXTEND-PEND.                                       
P00211                                                                  
P00211     MOVE 'N'                           TO WS-PEND-OPTION-SW      
P00211                                           WS-FCTR-UPDATE-SW      
P00211                                           WS-FCTR-CUSRSOR-SW.    
P00211     MOVE WS-INPUT-DATE                 TO HQ-ATTR-INCTV-STRT-DT  
P00211                                           HQ-ATTR-INCTV-END-DT.  
P00211     MOVE WS-PENDING-OPT                TO DF-STATUS-CD.          
P00211     PERFORM 7210-CHECK-PEND-OPTION       THRU 7210-EXIT.         
P00211     IF PEND-OPTION-EXIST                                         
P00211        AND DF-STATUS-EFF-REV-MTH = WS-REVENUE-MONTH              
P00211        AND WS-CURR-DURATION-REM-NO > 0                           
P00211        AND E-FDB07-OFF-CYCLE-BILL-CODE NOT EQUAL FINAL-BILL      
P00211                                                                  
P00211        MOVE WS-REVENUE-MONTH           TO WS-REV-MONTH-TMP       
P00211        MOVE WS-TEMP-YR-N               TO WS-START-YR            
P00211        MOVE WS-TEMP-MT-N               TO WS-START-MT            
P00211        MOVE '01'                       TO WS-START-DY            
P00211        MOVE 0                          TO MI-TRAN-APPL-NO        
P00211        MOVE DF-RT-PKG-OPT-SEQ-NO       TO                        
P00211                                      WS-PEND-RT-PKG-OPT-SEQ-NO   
P00211        PERFORM 7190-GET-CURR-TIMESTAMP   THRU 7190-EXIT          
P00211        PERFORM 5055-CALC-NEW-EFF-REV-MTH THRU 5055-EXIT          
P00211        PERFORM 5060-PROCESS-CURR-FCTR    THRU 5060-EXIT          
P00211                                                                  
P00211        IF CURR-FCTR-UPDATED                                      
P00211           MOVE WS-CURR-RT-PKG-OPT-SEQ-NO TO DF-RT-PKG-OPT-SEQ-NO 
P00211           PERFORM 5056-PROCESS-EFF-REV-MTH THRU 5056-EXIT        
P00211                                                                  
P00211           PERFORM 5070-PROCESS-PEND-FCTR THRU 5070-EXIT          
P00211           MOVE WS-PEND-RT-PKG-OPT-SEQ-NO TO DF-RT-PKG-OPT-SEQ-NO 
P00211           PERFORM 5056-PROCESS-EFF-REV-MTH THRU 5056-EXIT        
P00211                                                                  
ACT176           INITIALIZE CWS00077-FIELDS                             
P00211           MOVE 17                      TO WS-77-CATEGORY-ID      
P00211           MOVE WS-WQ-COMMENT1          TO WS-77-COMMENTS-TEXT    
P00211           MOVE LENGTH OF WS-WQ-COMMENT1                          
P00211                                        TO WS-77-COMMENTS-LEN     
P00211           PERFORM 5040-PROCESS-WQ        THRU 5040-EXIT          
P00211           DISPLAY 'Adjusted factor dates, WQ generated: '        
P00211                                           AT-ACCOUNT-NO          
P00211        END-IF                                                    
P00211     END-IF.                                                      
P00211                                                                  
P00211 5050-EXIT.                                                       
P00211     EXIT.                                                        
P00211                                                                  
P00211*****************************************************************         
P00211*                                                               *         
P00211* 5055-CALC-NEW-EFF-REV-MTH.                                    *         
P00211*****************************************************************         
P00211 5055-CALC-NEW-EFF-REV-MTH.                                       
P00211                                                                  
P00211     MOVE WS-REVENUE-MONTH              TO WS-REV-MONTH-TMP       
P00211                                           WS-PRV-EFF-REV-MTH.    
P00211     MOVE WS-TEMP-YR-N                  TO WS-TEMP-YR.            
P00211     MOVE WS-TEMP-MT-N                  TO WS-TEMP-MT.            
P00211     MOVE WS-CURR-DURATION-REM-NO       TO WS-MONTHS-TO-ADD.      
P00211                                                                  
P00211     PERFORM 5130-STEP-UP-MONTHS          THRU 5130-EXIT.         
P00211                                                                  
P00211     MOVE WS-REV-MONTH-TMP              TO WS-NEW-EFF-REV-MTH.    
P00211                                                                  
P00211 5055-EXIT.                                                       
P00211     EXIT.                                                        
P00211                                                                  
P00211*****************************************************************         
P00211*                                                               *         
P00211* 5056-PROCESS-EFF-REV-MTH.                                     *         
P00211*****************************************************************         
P00211 5056-PROCESS-EFF-REV-MTH.                                        
P00211                                                                  
P00211     SET EFF-REV-MTH-UPDATE             TO TRUE.                  
P00211     MOVE WS-NEW-EFF-REV-MTH            TO DF-STATUS-EFF-REV-MTH. 
P00211                                                                  
P00211     PERFORM 8045-UPDATE-DF-EFF-REV-MTH   THRU 8045-EXIT.         
P00211     PERFORM 5140-WRITE-TRANS-HIST        THRU 5140-EXIT.         
P00211     MOVE 'N'                           TO WS-EFF-REV-MTH-SW.     
P00211                                                                  
P00211 5056-EXIT.                                                       
P00211     EXIT.                                                        
P00211                                                                  
P00211*****************************************************************         
P00211*                                                               *         
P00211* 5060-PROCESS-CURR-FCTR.                                       *         
P00211*****************************************************************         
P00211 5060-PROCESS-CURR-FCTR.                                          
P00211                                                                  
P00211     MOVE 'CSCCREDIT'                   TO WS-SKIP-FCTR1.         
P00211     MOVE 'EXIT FEE'                    TO WS-SKIP-FCTR2.         
P00211     MOVE WS-CURR-RT-PKG-OPT-SEQ-NO     TO FF-RT-PKG-OPT-SEQ-NO.  
P00211     MOVE WS-OPTION-CD-OLD              TO HQ-OPTION-CD.          
P00211                                                                  
P00211     MOVE 'N'                           TO WS-NO-MORE-ROWS-01.    
P00211     COMPUTE WS-MONTHS-TO-ADD = WS-CURR-DURATION-REM-NO - 1.      
P00211                                                                  
P00211     PERFORM 7700-OPEN-OPTION-FCTR        THRU 7700-EXIT.         
P00211     PERFORM 7710-FETCH-OPTION-FCTR       THRU 7710-EXIT.         
P00211     PERFORM 5080-EXTEND-CURR-FCTR        THRU 5080-EXIT          
P00211       UNTIL NO-MORE-ROWS-01                                      
P00211     PERFORM 7720-CLOSE-OPTION-FCTR       THRU 7720-EXIT.         
P00211                                                                  
P00211 5060-EXIT.                                                       
P00211     EXIT.                                                        
P00211                                                                  
P00211*****************************************************************         
P00211*                                                               *         
P00211* 5070-PROCESS-PEND-FCTR.                                       *         
P00211*****************************************************************         
P00211 5070-PROCESS-PEND-FCTR.                                          
P00211                                                                  
P00211     MOVE 'EXIT FEE'                    TO WS-SKIP-FCTR1.         
P00211     MOVE SPACES                        TO WS-SKIP-FCTR2.         
P00211     MOVE WS-PEND-RT-PKG-OPT-SEQ-NO     TO FF-RT-PKG-OPT-SEQ-NO.  
P00211     MOVE DF-OPTION-CD                  TO HQ-OPTION-CD.          
P00211     MOVE 'N'                           TO WS-NO-MORE-ROWS-01.    
P00211                                                                  
P00211     PERFORM 7700-OPEN-OPTION-FCTR        THRU 7700-EXIT.         
P00211     PERFORM 7710-FETCH-OPTION-FCTR       THRU 7710-EXIT.         
P00211     PERFORM 5090-EXTEND-PEND-FCTR        THRU 5090-EXIT          
P00211       UNTIL NO-MORE-ROWS-01                                      
P00211     PERFORM 7720-CLOSE-OPTION-FCTR       THRU 7720-EXIT.         
P00211                                                                  
P00211 5070-EXIT.                                                       
P00211     EXIT.                                                        
P00211                                                                  
P00211*****************************************************************         
P00211*                                                               *         
P00211* 5080-EXTEND-CURR-FCTR.                                        *         
P00211*     EXTEND THE CURRENT CONTRACT FACTOR'S END DATE BY DURATION *         
P00211*  REMAINING MONTHS                                             *         
P00211*****************************************************************         
P00211 5080-EXTEND-CURR-FCTR.                                           
P00211                                                                  
P00211* STEP UP CURRENT FIXED FACTOR'S END DATE                                 
P00211     IF FF-EFF-DATE-TO < WS-START-DATE                            
P00211        MOVE FF-EFF-DATE-TO             TO WS-PRV-EFF-DATE-TO     
P00211        SET CURR-FCTR-CURSOR            TO TRUE                   
P00211                                                                  
P00211        MOVE WS-START-DATE              TO WS-TEMP-DATE           
P00211        PERFORM 5130-STEP-UP-MONTHS       THRU 5130-EXIT          
P00211        MOVE '28'                       TO WS-TEMP-DY             
P00211        MOVE WS-TEMP-DATE               TO WS-NEW-EFF-DATE-TO     
P00211                                                                  
P00211        PERFORM 5140-WRITE-TRANS-HIST     THRU 5140-EXIT          
P00211                                                                  
P00211        MOVE WS-NEW-EFF-DATE-TO         TO FF-EFF-DATE-TO         
P00211        PERFORM 8060-UPDATE-FF-DATE-TO    THRU 8060-EXIT          
P00211                                                                  
P00211        SET CURR-FCTR-UPDATED           TO TRUE                   
P00211     END-IF.                                                      
P00211                                                                  
P00211     PERFORM 7710-FETCH-OPTION-FCTR       THRU 7710-EXIT.         
P00211                                                                  
P00211 5080-EXIT.                                                       
P00211     EXIT.                                                        
P00211                                                                  
P00211*****************************************************************         
P00211*                                                               *         
P00211* 5090-EXTEND-PEND-FCTR.                                        *         
P00211*     EXTEND THE PENDING CONTRACT FACTORS END DATE BY DURATION  *         
P00211*  REMAINING MONTHS                                             *         
P00211*****************************************************************         
P00211 5090-EXTEND-PEND-FCTR.                                           
P00211                                                                  
P00211     SET PEND-FCTR-CURSOR               TO TRUE.                  
P00211     MOVE FF-EFF-DATE-FROM              TO WS-PRV-EFF-DATE-FROM.  
P00211                                                                  
P00211* STEP UP PENDING FIXED FACTOR'S START DATE                               
P00211     MOVE 1                             TO WS-MONTHS-TO-ADD.      
P00211     MOVE WS-NEW-EFF-DATE-TO            TO WS-TEMP-DATE.          
P00211     PERFORM 5130-STEP-UP-MONTHS          THRU 5130-EXIT.         
P00211     MOVE '01'                          TO WS-TEMP-DY.            
P00211     MOVE WS-TEMP-DATE                  TO WS-NEW-EFF-DATE-FROM.  
P00211                                                                  
P00211     PERFORM 5140-WRITE-TRANS-HIST        THRU 5140-EXIT.         
P00211                                                                  
P00211     MOVE WS-NEW-EFF-DATE-FROM          TO FF-EFF-DATE-FROM.      
P00211     PERFORM 8050-UPDATE-FF-DATE-FROM     THRU 8050-EXIT.         
P00211                                                                  
P00211     PERFORM 7710-FETCH-OPTION-FCTR       THRU 7710-EXIT.         
P00211                                                                  
P00211 5090-EXIT.                                                       
P00211     EXIT.                                                        
P00211                                                                  
P00211*****************************************************************         
P00211*                                                               *         
P00211* 5095-SET-NEW-DATES.                                           *         
P00211*****************************************************************         
P00211 5095-SET-NEW-DATES.                                              
P00211                                                                  
P00211* STEP UP CURRENT FIXED FACTOR'S END DATE                                 
P00211     IF FF-EFF-DATE-FROM > WS-START-DATE                          
P00211        MOVE FF-EFF-DATE-FROM          TO WS-PRV-EFF-DATE-FROM    
P00211                                                                  
P00211        MOVE WS-START-DATE             TO FF-EFF-DATE-FROM        
P00211                                                                  
P00211        PERFORM 5160-WRITE-FINAL-TRANS    THRU 5160-EXIT          
P00211                                                                  
P00211        PERFORM 8050-UPDATE-FF-DATE-FROM  THRU 8050-EXIT          
P00211        SET CURR-FCTR-UPDATED TO TRUE                             
P00211     END-IF.                                                      
P00211                                                                  
P00211     PERFORM 7710-FETCH-OPTION-FCTR       THRU 7710-EXIT.         
P00211                                                                  
P00211 5095-EXIT.                                                       
P00211     EXIT.                                                        
P00211                                                                  
I00251*****************************************************************         
I00251*                                                               *         
I00251* 5100-DROP-RATE.                                               *         
I00251*                                                               *         
I00251* DROP LOGIC : INSERT NEW OFFER IN CSS_ACCT_RTPK_AG             *         
I00251*              UPDATE STATUS IN CSS_ACCT_RTPK-AGR               *         
I00251*              UPDATE NEW RTPK-SEQ-NO IN CSS_UTIL_ENVRNMT       *         
I00251*              UPDATE NEW RTPK-SEQ-NO IN CSS_BILLING_DET        *         
I00251*              WRITE  CSS_MNT_TRANS_HIST                        *         
I00251*              WRITE  CSS_MT_TRN_HST_DET                        *         
I00251*              UPDATE SENIOR_FL IN CSS_REG_PROFILE  FOR GRP1 SR *         
I00251*              INSERT BILL MSG IN CSS_SPCL_BILL_MSG FOR GRP1 SR *         
P00680*              EXPIRE UNUSED FIXED FACTORS FOR CURRENT OPTION.  *         
I00251*****************************************************************         
I00251 5100-DROP-RATE.                                                  
I00251*                                                                         
I00251** DATA FOR CSS_ACCT_RTPK_AGR                                             
I00251                                                                  
I00251     MOVE SPACES                       TO DF-AGREEMNT-SOURCE-CD   
I00251     IF GROUP2-CUSTOMER                                           
I00251        MOVE DD-TIER-CUST-STAT-CD      TO 1B-TIER-CUST-STAT-CD    
I00251        MOVE DD-TIER-ACCT-TYPE-CD      TO 1B-TIER-ACCT-TYPE-CD    
I00251        MOVE DD-MKT-TIER-RANKING       TO 1B-MKT-TIER-RANKING     
I00251        MOVE DD-MKT-TIER-START-DT      TO 1B-MKT-TIER-START-DT    
I00251        MOVE DD-ADJ-TIER-SEQ-NO        TO 1B-ADJ-TIER-SEQ-NO      
I00251        MOVE DD-COMPANY-NO             TO 1B-COMPANY-NO           
I00251        PERFORM 7160-GET-ADJ-SOURCE-CD    THRU 7160-EXIT          
I00251                                                                  
I00251        IF WS-OVR-RT-CALC-TYP-CD = '02'                           
I00251           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND OR            
I00251              (DF-ADJ-TIER-SEQ-NO = DD-ADJ-TIER-SEQ-NO)           
I00251              MOVE 'FD2'                  TO DF-AGREEMNT-SOURCE-CD
I00251              MOVE WS-TRANS-HIST-CMNT-FD2 TO WS-TRANS-HIST-CMNT   
I00251           ELSE                                                   
I00251              IF DD-TIER-SOURCE-CD = '2F'                         
I00251                 EVALUATE  1B-ADJ-SOURCE-CD                       
I00251                    WHEN 'H'                                      
I00251                      MOVE 'FDH'          TO DF-AGREEMNT-SOURCE-CD
I00251                      MOVE WS-TRANS-HIST-CMNT-FDH                 
I00251                                          TO WS-TRANS-HIST-CMNT   
I00251                    WHEN 'M'                                      
I00251                      MOVE 'FDM'        TO DF-AGREEMNT-SOURCE-CD  
I00251                      MOVE WS-TRANS-HIST-CMNT-FDM                 
I00251                                          TO WS-TRANS-HIST-CMNT   
I00251                    WHEN 'L'                                      
I00251                      MOVE 'FDL'          TO DF-AGREEMNT-SOURCE-CD
I00251                      MOVE WS-TRANS-HIST-CMNT-FDL                 
I00251                                          TO WS-TRANS-HIST-CMNT   
I00251                 END-EVALUATE                                     
I00251              END-IF                                              
I00251           END-IF                                                 
I00251        END-IF                                                    
I00251                                                                  
I00251                                                                  
I00251        IF DD-TIER-SOURCE-CD = '2V'                               
I00251           EVALUATE  1B-ADJ-SOURCE-CD                             
I00251            WHEN 'H'                                              
I00251             MOVE 'VDH'                  TO DF-AGREEMNT-SOURCE-CD 
I00251             MOVE WS-TRANS-HIST-CMNT-VDH TO WS-TRANS-HIST-CMNT    
I00251            WHEN 'M'                                              
I00251             MOVE 'VDM'                  TO DF-AGREEMNT-SOURCE-CD 
I00251             MOVE WS-TRANS-HIST-CMNT-VDM TO WS-TRANS-HIST-CMNT    
I00251            WHEN 'L'                                              
I00251             MOVE 'VDL'                  TO DF-AGREEMNT-SOURCE-CD 
I00251             MOVE WS-TRANS-HIST-CMNT-VDL TO WS-TRANS-HIST-CMNT    
I00251           END-EVALUATE                                           
I00251        END-IF                                                    
I00251     ELSE                                                         
I00251        MOVE 'N'                      TO WS-CUSTOMER-ON-SR-TIER   
I00251                                         IG-CUST-ACCT-DEFLT-FL    
I00251        MOVE DF-ACCOUNT-NO            TO DD-ACCOUNT-NO            
I00251                                         LR-ACCOUNT-NO            
I00251        PERFORM 7170-CHECK-SCANA-SR       THRU 7170-EXIT          
I00251        MOVE IG-CUST-ACCT-DEFLT-FL    TO WS-CUSTOMER-ON-SR-TIER   
I00251                                                                  
I00251        IF CUSTOMER-ON-SR-TIER                                    
I00251           MOVE 'Y'                   TO LR-SENIOR-FL             
I00251                                                                  
I00251           PERFORM 8040-UPD-SR-FLAG       THRU 8040-EXIT          
I00251                                                                  
I00251           IF WS-OVR-RT-CALC-TYP-CD NOT EQUAL '02'                
I00251             AND INS-SPCL-BILL-MSG                                
I00251              PERFORM 5105-PROCESS-SPCL-BILL-MSGS                 
I00251                                          THRU 5105-EXIT          
I00251           END-IF                                                 
I00251        END-IF                                                    
I00251                                                                  
I00251        IF WS-OVR-RT-CALC-TYP-CD = '02'                           
I02262           IF WS-POOL-GROUP-FLAG = 'Y'                            
I02262              MOVE 'VRN'                 TO DF-AGREEMNT-SOURCE-CD 
I02262           ELSE                                                   
I00251              MOVE 'FDN'                 TO DF-AGREEMNT-SOURCE-CD 
I02262           END-IF                                                 
I00251           IF CUSTOMER-ON-SR-TIER                                 
I00251              MOVE WS-TRANS-HIST-CMNT-SF TO WS-TRANS-HIST-CMNT    
I00251           ELSE                                                   
I00251              MOVE WS-TRANS-HIST-CMNT-F  TO WS-TRANS-HIST-CMNT    
I00251           END-IF                                                 
I00251        ELSE                                                      
I00251           MOVE 'VDN'                    TO DF-AGREEMNT-SOURCE-CD 
I00251           IF CUSTOMER-ON-SR-TIER                                 
I00251              MOVE WS-TRANS-HIST-CMNT-SV TO WS-TRANS-HIST-CMNT    
I00251           ELSE                                                   
I00251              MOVE WS-TRANS-HIST-CMNT-V  TO WS-TRANS-HIST-CMNT    
I00251           END-IF                                                 
I00251        END-IF                                                    
I00251     END-IF                                                       
I00251                                                                  
P00680* WHEN DROPPING ACCOUNT FROM FIXED RATE TO VARIABLE EXPIRE ANY    52133001
P00680* UNUSED FIXED FACTORS FOR THE CURRENT OPTION.                            
P00680     IF WS-OVR-RT-CALC-TYP-CD = '02' AND NOT SEB-REGULATED        
P00680                                                                  
P00680        PERFORM 7430-OPEN-UNUSED-FACTOR     THRU 7430-EXIT        
P00680                                                                  
P00680        MOVE ZEROS                       TO WS-PRV-MONTHS-REMAIN  
P00680        MOVE SPACES                      TO WS-PRV-FCTR-EFF-DT    
P00680        PERFORM 7440-FETCH-UNUSED-FACTOR    THRU 7440-EXIT        
P00680                                                                  
P00680        PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
P00680                                                                  
P00680           IF AT-REV-MTH-LST-NRML > 0                             
P00680              MOVE AT-REV-MTH-LST-NRML   TO WS-REV-MONTH-TMP      
P00680           ELSE                                                   
P00680              MOVE WS-REVENUE-MONTH      TO WS-REV-MONTH-TMP      
P00680           END-IF                                                 
P00680                                                                  
P00680           MOVE DF-ACCOUNT-NO            TO FF-ACCOUNT-NO         
P00680           MOVE DF-CODE-UTIL-TYPE        TO FF-CODE-UTIL-TYPE     
P00680           MOVE DF-IC-NO                 TO FF-IC-NO              
P00680           MOVE DF-RT-PKG-OPT-SEQ-NO     TO FF-RT-PKG-OPT-SEQ-NO  
P00680                                                                  
P00680           MOVE WS-TEMP-YR-N             TO WS-TEMP-YR            
P00680           MOVE WS-TEMP-MT-N             TO WS-TEMP-MT            
P00680           MOVE '28'                     TO WS-TEMP-DY            
P00680           MOVE WS-TEMP-DATE             TO FF-EFF-DATE-TO        
A04019           IF SF-RT-ATTR-INCTV-TYPE NOT = 'CSC ADJUSTMENT'        
P00680              MOVE ZEROS                 TO FF-DURATION-REMAIN-NO 
A04019           END-IF                                                 
P00680                                                                  
P00680           PERFORM 8070-EXPIRE-UNUSED-FCTR  THRU 8070-EXIT        
P00680                                                                  
P00680           PERFORM 5120-WRITE-TRANS-HIST    THRU 5120-EXIT        
P00680                                                                  
P00680           MOVE ZEROS                    TO WS-PRV-MONTHS-REMAIN  
P00680           MOVE SPACES                   TO WS-PRV-FCTR-EFF-DT    
P00680           PERFORM 7440-FETCH-UNUSED-FACTOR THRU 7440-EXIT        
P00680                                                                  
P00680        END-PERFORM                                               
P00680                                                                  
P00680        PERFORM 7450-CLOSE-UNUSED-FACTOR    THRU 7450-EXIT        
P00680     END-IF                                                       
      *                                                                         
I00251     MOVE DF-RT-PKG-OPT-SEQ-NO        TO WS-RT-PKG-OPT-SEQ-NO     
I00251     COMPUTE DF-RT-PKG-OPT-SEQ-NO  =  DF-RT-PKG-OPT-SEQ-NO + 1    
I00251                                                                  
I00251     MOVE WS-CA328-OFFER-CD           TO DF-OFFER-CD              
I00251                                         WS-OFFER-CD-NEW          
P00269                                         E9-OFFER-CD              
I00251     MOVE WS-CA328-OPTION-CD          TO DF-OPTION-CD             
I00251                                         WS-OPTION-CD-NEW         
P00269                                         E9-OPTION-CD             
I00251     MOVE 'A'                         TO DF-STATUS-CD             
I00251     MOVE 'SYSTEM'                    TO DF-CREATED-USERID        
I00251                                         DF-LAST-UPDATE-USERID    
I00251     MOVE WS-REVENUE-MONTH            TO DF-STATUS-EFF-REV-MTH    
I00251     MOVE SPACES                      TO DF-COMM-CHANNEL          
I00251                                         DF-PROMO-CD              
I00251     MOVE DD-ADJ-TIER-SEQ-NO          TO DF-ADJ-TIER-SEQ-NO       
I00251                                                                  
P00269     PERFORM 7880-GET-OFFR-OPT-START-DT   THRU 7880-EXIT          
P00269                                                                  
I00251     PERFORM 8025-INS-ACCT-RTPK-AGR       THRU 8025-EXIT          
I00251                                                                  
I00251     MOVE DF-OPTION-CD                TO FI-OPTION-CD             
I00251     MOVE DF-COMPANY-NO               TO FI-COMPANY-NO            
I00251     PERFORM 7180-SELECT-RATE-PLAN        THRU 7180-EXIT          
I00251                                                                  
I00251     MOVE FI-RATE-PLAN-NO             TO UT-RATE-PLAN-NO          
I00251                                         BG-RATE-PLAN-NO          
I00251     MOVE DF-RT-PKG-OPT-SEQ-NO        TO UT-RT-PKG-OPT-SEQ-NO     
I00251                                         BG-RT-PKG-OPT-SEQ-NO     
I00251     MOVE DF-ACCOUNT-NO               TO UT-ACCOUNT-NO            
I00251                                         BG-ACCOUNT-NO            
I00251     MOVE DF-CODE-UTIL-TYPE           TO UT-CODE-UTIL-TYPE        
I00251                                         BG-CODE-UTIL-TYPE        
I00251     MOVE DF-IC-NO                    TO UT-IC-NO                 
I00251                                         BG-IC-NO                 
I00251     PERFORM 8030-UPD-UTIL-ENVRNMT        THRU 8030-EXIT          
I00251     PERFORM 8035-UPD-BILLING-DET         THRU 8035-EXIT          
I00251     PERFORM 5110-WRITE-TRANS-HIST        THRU 5110-EXIT          
I00251*                                                                         
I00251     DISPLAY '### DROP ACCOUNT : ' DF-ACCOUNT-NO.                 
I00251                                                                  
I00251 5100-EXIT.                                                       
I00251     EXIT.                                                        
I00251*                                                                         
I00251******************************************************************        
I00251*                                                                *        
I00251* 5105-PROCESS-SPCL-BILL-MSGS.                                   *        
I00251******************************************************************        
I00251 5105-PROCESS-SPCL-BILL-MSGS.                                     
I00251                                                                  
I00251     IF ( WS-HOLD-COMPANY EQUAL SPACES )                          
I00251        OR ( WS-HOLD-COMPANY GREATER THAN SPACES                  
I00251              AND WS-COMPANY-NO NOT EQUAL WS-HOLD-COMPANY )       
I00251                                                                  
I00251        PERFORM 5605-INSERT-SPCL-BILL-MSGS THRU 5605-EXIT         
I00251                                                                  
I00251     END-IF.                                                      
I00251                                                                  
I00251 5105-EXIT.                                                       
I00251     EXIT.                                                        
I00251                                                                  
I00251*****************************************************************         
I00251*                                                               *         
I00251* 5110-WRITE-TRANS-HIST.                                        *         
I00251*     WRITE TRANSACTION HISTORY                                 *         
I00251*****************************************************************         
I00251 5110-WRITE-TRANS-HIST.                                           
I00251                                                                  
I00251** DATA FOR CSS_MNT_TRANS_HIST                                            
I00251     PERFORM 7190-GET-CURR-TIMESTAMP      THRU 7190-EXIT          
I00251                                                                  
I00251     MOVE WS-INPUT-DATE                TO MH-DATE-TRANS           
I00251     MOVE WS-F                         TO MH-CODE-TRAN-TYPE       
I00251     MOVE SPACES                       TO MH-RESP-AREA-ID         
I00251     MOVE DF-ACCOUNT-NO                TO MH-ACCOUNT-NO           
I00251     MOVE ZEROS                        TO MH-CUSTOMER-NO          
I00251     MOVE AT-PREMISE-NO                TO MH-PREMISE-NO           
I00251     MOVE 'SYSTEM'                     TO MH-USER-ID              
I00251     MOVE WS-PROGRAM                   TO MH-APPL-PROGRAM-ID      
I00251     MOVE +35                          TO MH-TRAN-COMMENT-LEN     
I00251     MOVE WS-TRANS-HIST-CMNT           TO MH-TRAN-COMMENT-TEXT    
I00251*                                                                         
I00251** GET THE CURRENT OPTION DESCRIPTION                                     
I00251     MOVE DF-COMPANY-NO                TO FI-COMPANY-NO           
I00251     MOVE WS-OPTION-CD-OLD             TO FI-OPTION-CD            
I00251     PERFORM 7200-GET-OPTION-DESC         THRU 7200-EXIT          
I00251     MOVE FI-OPT-DESC-INT              TO WS-OPTION-DESC-OLD      
I00251*                                                                         
I00251** GET THE NEW OPTION DESCRIPTION                                         
I00251     MOVE WS-OPTION-CD-NEW             TO FI-OPTION-CD            
I00251     PERFORM 7200-GET-OPTION-DESC         THRU 7200-EXIT          
I00251     MOVE FI-OPT-DESC-INT              TO WS-OPTION-DESC-NEW      
I00251*                                                                         
I00251** DATA FOR CSS_MT_TRN_HST_DET                                            
I00251     MOVE MH-TRANS-HIST-SEQ-NO         TO MI-TRANS-HIST-SEQ-NO    
I00251     MOVE SPACES                       TO MI-TABLE-ID             
I00251     MOVE 1                            TO MI-TRAN-APPL-NO         
I00251     MOVE 'OPTION'                     TO MI-COLUMN-DESC          
I00251     MOVE +12                          TO MI-PRV-COLUMN-VALUE-LEN 
I00251     MOVE WS-OPTION-CD-OLD             TO MI-PRV-COLUMN-VALUE-TEXT
I00251     MOVE +12                          TO MI-CHG-COLUMN-VALUE-LEN 
I00251     MOVE WS-OPTION-CD-NEW             TO MI-CHG-COLUMN-VALUE-TEXT
I00251     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT          
I00251*                                                                         
I00251     ADD  1                            TO MI-TRAN-APPL-NO         
I00251     MOVE 'OPTION DESC'                TO MI-COLUMN-DESC          
I00251     MOVE +50                          TO MI-PRV-COLUMN-VALUE-LEN 
I00251     MOVE SPACES                       TO MI-PRV-COLUMN-VALUE-TEXT
I00251     MOVE WS-OPTION-DESC-OLD           TO MI-PRV-COLUMN-VALUE-TEXT
I00251     MOVE +50                          TO MI-CHG-COLUMN-VALUE-LEN 
I00251     MOVE SPACES                       TO MI-CHG-COLUMN-VALUE-TEXT
I00251     MOVE WS-OPTION-DESC-NEW           TO MI-CHG-COLUMN-VALUE-TEXT
I00251     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT          
I00251*                                                                         
I00251     ADD  1                            TO MI-TRAN-APPL-NO         
I00251     MOVE 'OFFER'                      TO MI-COLUMN-DESC          
I00251     MOVE +12                          TO MI-PRV-COLUMN-VALUE-LEN 
I00251     MOVE SPACES                       TO MI-PRV-COLUMN-VALUE-TEXT
I00251     MOVE WS-OFFER-CD-OLD              TO MI-PRV-COLUMN-VALUE-TEXT
I00251     MOVE +12                          TO MI-CHG-COLUMN-VALUE-LEN 
I00251     MOVE SPACES                       TO MI-CHG-COLUMN-VALUE-TEXT
I00251     MOVE WS-OFFER-CD-NEW              TO MI-CHG-COLUMN-VALUE-TEXT
I00251     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT          
I00251*                                                                         
I00251     MOVE WS-UPD-STATUS-CD             TO DF-STATUS-CD            
I00251     MOVE WS-RT-PKG-OPT-SEQ-NO         TO DF-RT-PKG-OPT-SEQ-NO    
I00251     PERFORM 8020-UPD-ACCT-RTPKG-AGR      THRU 8020-EXIT.         
I00251                                                                  
I00251 5110-EXIT.                                                       
I00251     EXIT.                                                        
I00251*                                                                         
P00680*****************************************************************         
P00680*                                                               *         
P00680* 5120-WRITE-TRANS-HIST.                                        *         
P00680*     WRITE TRANSACTION HISTORY                                 *         
P00680*****************************************************************         
P00680 5120-WRITE-TRANS-HIST.                                           
P00680                                                                  
P00680** DATA FOR CSS_MNT_TRANS_HIST                                            
P00680     PERFORM 7190-GET-CURR-TIMESTAMP    THRU 7190-EXIT            
P00680                                                                  
P00680     MOVE WS-INPUT-DATE              TO MH-DATE-TRANS             
P00680     MOVE WS-F                       TO MH-CODE-TRAN-TYPE         
P00680     MOVE SPACES                     TO MH-RESP-AREA-ID           
P00680     MOVE DF-ACCOUNT-NO              TO MH-ACCOUNT-NO             
P00680     MOVE ZEROS                      TO MH-CUSTOMER-NO            
P00680     MOVE AT-PREMISE-NO              TO MH-PREMISE-NO             
P00680     MOVE 'SYSTEM'                   TO MH-USER-ID                
P00680     MOVE WS-PROGRAM                 TO MH-APPL-PROGRAM-ID        
P00680     MOVE +36                        TO MH-TRAN-COMMENT-LEN       
P00680     MOVE WS-TRANS-HIST-CMNT-EXPR    TO MH-TRAN-COMMENT-TEXT      
P00680     MOVE FF-FACTOR-ID               TO MH-TRAN-COMMENT-TEXT (1:9)
P00680*                                                                         
P00680     MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO      
P00680     MOVE 1                          TO MI-TRAN-APPL-NO           
P00680     MOVE 'EFF DATE TO'              TO MI-COLUMN-DESC            
P00680     MOVE +10                        TO MI-PRV-COLUMN-VALUE-LEN   
P00680     MOVE SPACES                     TO MI-PRV-COLUMN-VALUE-TEXT  
P00680     MOVE WS-PRV-FCTR-EFF-DT         TO MI-PRV-COLUMN-VALUE-TEXT  
P00680     MOVE +10                        TO MI-CHG-COLUMN-VALUE-LEN   
P00680     MOVE SPACES                     TO MI-CHG-COLUMN-VALUE-TEXT  
P00680     MOVE FF-EFF-DATE-TO             TO MI-CHG-COLUMN-VALUE-TEXT  
P00680     PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT.           
P00680*                                                                         
P00680** DATA FOR CSS_MT_TRN_HST_DET                                            
A04019     IF SF-RT-ATTR-INCTV-TYPE NOT = 'CSC ADJUSTMENT'              
P00680        MOVE SPACES                  TO MI-TABLE-ID               
P00680        ADD  1                       TO MI-TRAN-APPL-NO           
P00680        MOVE 'DURATION'              TO MI-COLUMN-DESC            
P00680        MOVE +4                      TO MI-PRV-COLUMN-VALUE-LEN   
P00680        MOVE WS-PRV-MONTHS-REMAIN    TO WS-HOLD-DUR-REM           
P00680        MOVE WS-HOLD-DUR-REM-X       TO MI-PRV-COLUMN-VALUE-TEXT  
P00680        MOVE +4                      TO MI-CHG-COLUMN-VALUE-LEN   
P00680        MOVE FF-DURATION-REMAIN-NO   TO WS-HOLD-DUR-REM           
P00680        MOVE WS-HOLD-DUR-REM-X       TO MI-CHG-COLUMN-VALUE-TEXT  
P00680        PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
A04019     END-IF.                                                      
P00680*                                                                         
P00680 5120-EXIT.                                                       
P00680     EXIT.                                                        
P00680*                                                                         
A04727*****************************************************************         
A04727*                                                               *         
A04727* 5125-WRITE-TRANS-HIST.                                        *         
A04727*****************************************************************         
A04727 5125-WRITE-TRANS-HIST.                                           
A04727                                                                  
A04727     PERFORM 7190-GET-CURR-TIMESTAMP      THRU 7190-EXIT          
A04727                                                                  
A04727*    WRITE TRANSACTION HEADER.                                            
A04727     MOVE WS-INPUT-DATE                TO MH-DATE-TRANS.          
A04727     MOVE WS-F                         TO MH-CODE-TRAN-TYPE.      
A04727     MOVE SPACES                       TO MH-RESP-AREA-ID.        
A04727     MOVE DF-ACCOUNT-NO                TO MH-ACCOUNT-NO.          
A04727     MOVE ZEROS                        TO MH-CUSTOMER-NO.         
A04727     MOVE AT-PREMISE-NO                TO MH-PREMISE-NO.          
A04727     MOVE 'SYSTEM'                     TO MH-USER-ID.             
A04727     MOVE WS-PROGRAM                   TO MH-APPL-PROGRAM-ID.     
A04727     MOVE +68                          TO MH-TRAN-COMMENT-LEN.    
A04727     MOVE WS-TRANS-COMMENT             TO MH-TRAN-COMMENT-TEXT.   
A04727                                                                  
A04727                                                                  
A04727*    WRITE TRANSACTION DETAILS.                                           
A04727     MOVE 1                            TO MI-TRAN-APPL-NO.        
A04727     MOVE SPACES                       TO MI-TABLE-ID.            
A04727     MOVE MH-TRANS-HIST-SEQ-NO         TO MI-TRANS-HIST-SEQ-NO.   
A04727     MOVE '**NEW**'                    TO MI-PRV-COLUMN-VALUE-TEXT
A04727     MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
A04727                                       TO MI-PRV-COLUMN-VALUE-LEN.
A04727                                                                  
A04727     MOVE FF-FACTOR-ID                 TO MI-CHG-COLUMN-VALUE-TEXT
A04727     MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
A04727                                       TO MI-CHG-COLUMN-VALUE-LEN.
A04727     MOVE 'FACTOR ID  '                TO MI-COLUMN-DESC.         
A04727     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
A04727     ADD 1                             TO MI-TRAN-APPL-NO.        
A04727                                                                  
A04727     MOVE FF-FACTOR                    TO WS-FACTOR-TEXT.         
A04727     MOVE WS-FACTOR-TEXT               TO WS-FACT-VAL-Z.          
A04727     MOVE WS-FACT-VAL-Z                TO MI-CHG-COLUMN-VALUE-TEXT
A04727     MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
A04727                                       TO MI-CHG-COLUMN-VALUE-LEN.
A04727     MOVE 'FACTOR VALUE   '            TO MI-COLUMN-DESC.         
A04727     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
A04727     ADD 1                             TO MI-TRAN-APPL-NO.        
A04727                                                                  
A04727     MOVE FF-EFF-DATE-FROM             TO MI-CHG-COLUMN-VALUE-TEXT
A04727     MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
A04727                                       TO MI-CHG-COLUMN-VALUE-LEN.
A04727     MOVE 'DATE FROM      '            TO MI-COLUMN-DESC.         
A04727     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
A04727     ADD 1                             TO MI-TRAN-APPL-NO.        
A04727                                                                  
A04727     MOVE FF-EFF-DATE-TO               TO MI-CHG-COLUMN-VALUE-TEXT
A04727     MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
A04727                                       TO MI-CHG-COLUMN-VALUE-LEN.
A04727     MOVE 'DATE TO        '            TO MI-COLUMN-DESC.         
A04727     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
A04727     ADD 1                             TO MI-TRAN-APPL-NO.        
A04727                                                                  
A04727     MOVE FF-CODE-SEASON               TO MI-CHG-COLUMN-VALUE-TEXT
A04727     MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
A04727                                       TO MI-CHG-COLUMN-VALUE-LEN.
A04727     MOVE 'SEASON CODE    '            TO MI-COLUMN-DESC.         
A04727     MOVE '42'                         TO MI-TABLE-ID.            
A04727     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
A04727     ADD 1                             TO MI-TRAN-APPL-NO.        
A04727                                                                  
A04727     MOVE FF-INSTR-USE-TYPE-CD         TO MI-CHG-COLUMN-VALUE-TEXT
A04727     MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
A04727                                       TO MI-CHG-COLUMN-VALUE-LEN.
A04727     MOVE 'INSTR USE    '              TO MI-COLUMN-DESC.         
A04727     MOVE '43'                         TO MI-TABLE-ID.            
A04727     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
A04727     ADD 1                             TO MI-TRAN-APPL-NO.        
A04727                                                                  
A04727     MOVE FF-CODE-TIME-PERIOD          TO MI-CHG-COLUMN-VALUE-TEXT
A04727     MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
A04727                                       TO MI-CHG-COLUMN-VALUE-LEN 
A04727     MOVE 'TIME PERIOD  '              TO MI-COLUMN-DESC.         
A04727     MOVE '44'                         TO MI-TABLE-ID.            
A04727     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
A04727     ADD 1                             TO MI-TRAN-APPL-NO.        
A04727                                                                  
A04727     MOVE FF-CMPNT-ID-CD               TO MI-CHG-COLUMN-VALUE-TEXT
A04727     MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
A04727                                       TO MI-CHG-COLUMN-VALUE-LEN.
A04727     MOVE 'COMPONENT ID '              TO MI-COLUMN-DESC.         
A04727     MOVE 'N6'                         TO MI-TABLE-ID.            
A04727     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
A04727     ADD 1                             TO MI-TRAN-APPL-NO.        
A04727                                                                  
A04727     MOVE FF-DURATION-REMAIN-NO        TO WS-DURATION-NO-Z.       
A04727     MOVE WS-DURATION-NO-Z             TO MI-CHG-COLUMN-VALUE-TEXT
A04727     MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
A04727                                       TO MI-CHG-COLUMN-VALUE-LEN 
A04727     MOVE 'DURATION '                  TO MI-COLUMN-DESC.         
A04727     MOVE SPACES                       TO MI-TABLE-ID.            
A04727     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
A04727     ADD 1                             TO MI-TRAN-APPL-NO.        
A04727                                                                  
A04727 5125-EXIT.                                                       
A04727     EXIT.                                                        
A04727                                                                  
P00211*****************************************************************         
P00211* 5130-STEP-UP-MONTHS.                                         **         
P00211*                                                              **         
P00211*****************************************************************         
P00211 5130-STEP-UP-MONTHS.                                             
P00211                                                                  
P00211     MOVE WS-TEMP-YR                     TO WS-TEMP-YR-N.         
P00211     MOVE WS-TEMP-MT                     TO WS-TEMP-MT-N.         
P00211                                                                  
P00211     PERFORM WS-MONTHS-TO-ADD TIMES                               
P00211       COMPUTE WS-TEMP-MT-N = WS-TEMP-MT-N + 1                    
P00211       IF WS-TEMP-MT-N > 12                                       
P00211          COMPUTE WS-TEMP-YR-N = WS-TEMP-YR-N + 1                 
P00211          MOVE 01                        TO WS-TEMP-MT-N          
P00211       END-IF                                                     
P00211     END-PERFORM.                                                 
P00211                                                                  
P00211     MOVE WS-TEMP-YR-N                   TO WS-TEMP-YR.           
P00211     MOVE WS-TEMP-MT-N                   TO WS-TEMP-MT.           
P00211*                                                                         
P00211 5130-EXIT.                                                       
P00211     EXIT.                                                        
P00211*                                                                         
P00211*****************************************************************         
P00211*                                                               *         
P00211* 5140-WRITE-TRANS-HIST.                                        *         
P00211*     WRITE TRANSACTION HISTORY                                 *         
P00211*****************************************************************         
P00211 5140-WRITE-TRANS-HIST.                                           
P00211                                                                  
P00211** DATA FOR CSS_MNT_TRANS_HIST                                            
P00211     MOVE WS-INPUT-DATE                TO MH-DATE-TRANS.          
P00211     MOVE WS-F                         TO MH-CODE-TRAN-TYPE.      
P00211     MOVE SPACES                       TO MH-RESP-AREA-ID.        
P00211     MOVE DF-ACCOUNT-NO                TO MH-ACCOUNT-NO.          
P00211     MOVE ZEROS                        TO MH-CUSTOMER-NO.         
P00211     MOVE AT-PREMISE-NO                TO MH-PREMISE-NO.          
P00211     MOVE 'SYSTEM'                     TO MH-USER-ID.             
P00211     MOVE WS-PROGRAM                   TO MH-APPL-PROGRAM-ID.     
P00211     MOVE +35                          TO MH-TRAN-COMMENT-LEN.    
P00211     MOVE WS-TRANS-HIST-CMNT-FCTR      TO MH-TRAN-COMMENT-TEXT.   
P00211*                                                                         
P00211** DATA FOR CSS_MT_TRN_HST_DET                                            
P00211* WRITE CURRENT FACTORS TRANSACTION HISTORY                               
P00211     IF CURR-FCTR-CURSOR                                          
P00211        IF EFF-REV-MTH-UPDATE                                     
P00211           ADD 1                      TO MI-TRAN-APPL-NO          
P00211           MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO     
P00211           MOVE SPACES                TO MI-TABLE-ID              
P00211           MOVE 'CURR OPTION'         TO MI-COLUMN-DESC           
P00211           MOVE +13                   TO MI-PRV-COLUMN-VALUE-LEN  
P00211           MOVE 'EFF REV MONTH'       TO MI-PRV-COLUMN-VALUE-TEXT 
P00211           MOVE +09                   TO MI-CHG-COLUMN-VALUE-LEN  
P00211           MOVE '*UPDATED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
P00211           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
P00211*                                                                         
P00211           ADD  1                      TO MI-TRAN-APPL-NO         
P00211           MOVE MH-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO    
P00211           MOVE SPACES                 TO MI-TABLE-ID             
P00211           MOVE 'EFF REV MONTH'        TO MI-COLUMN-DESC          
P00211           MOVE +06                    TO MI-PRV-COLUMN-VALUE-LEN 
P00211           MOVE WS-PRV-EFF-REV-MTH     TO WS-HOLD-REV-MTH-N       
P00211           MOVE WS-HOLD-REV-MTH-N      TO WS-HOLD-REV-MTH         
P00211           MOVE WS-HOLD-REV-MTH        TO MI-PRV-COLUMN-VALUE-TEXT
P00211           MOVE +06                    TO MI-CHG-COLUMN-VALUE-LEN 
P00211           MOVE WS-NEW-EFF-REV-MTH     TO WS-HOLD-REV-MTH-N       
P00211           MOVE WS-HOLD-REV-MTH-N      TO WS-HOLD-REV-MTH         
P00211           MOVE WS-HOLD-REV-MTH        TO MI-CHG-COLUMN-VALUE-TEXT
P00211           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
P00211        ELSE                                                      
P00211           ADD 1                       TO MI-TRAN-APPL-NO         
P00211           MOVE MH-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO    
P00211           MOVE SPACES                 TO MI-TABLE-ID             
P00211           MOVE 'CURR FACTOR'          TO MI-COLUMN-DESC          
P00211           MOVE +09                    TO MI-PRV-COLUMN-VALUE-LEN 
P00211           MOVE FF-FACTOR-ID           TO MI-PRV-COLUMN-VALUE-TEXT
P00211           MOVE +09                    TO MI-CHG-COLUMN-VALUE-LEN 
P00211           MOVE '*UPDATED*'            TO MI-CHG-COLUMN-VALUE-TEXT
P00211           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
P00211*                                                                         
P00211           ADD 1                       TO MI-TRAN-APPL-NO         
P00211           MOVE MH-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO    
P00211           MOVE SPACES                 TO MI-TABLE-ID             
P00211           MOVE 'TO DATE'              TO MI-COLUMN-DESC          
P00211           MOVE +10                    TO MI-PRV-COLUMN-VALUE-LEN 
P00211           MOVE WS-PRV-EFF-DATE-TO     TO MI-PRV-COLUMN-VALUE-TEXT
P00211           MOVE +10                    TO MI-CHG-COLUMN-VALUE-LEN 
P00211           MOVE WS-NEW-EFF-DATE-TO     TO MI-CHG-COLUMN-VALUE-TEXT
P00211           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
P00211        END-IF                                                    
P00211     END-IF.                                                      
P00211                                                                  
P00211* WRITE PENDING FACTORS TRANSACTION HISTORY                               
P00211     IF PEND-FCTR-CURSOR                                          
P00211        IF EFF-REV-MTH-UPDATE                                     
P00211           ADD 1                      TO MI-TRAN-APPL-NO          
P00211           MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO     
P00211           MOVE SPACES                TO MI-TABLE-ID              
P00211           MOVE 'PEND OPTION'         TO MI-COLUMN-DESC           
P00211           MOVE +13                   TO MI-PRV-COLUMN-VALUE-LEN  
P00211           MOVE 'EFF REV MONTH'       TO MI-PRV-COLUMN-VALUE-TEXT 
P00211           MOVE +09                   TO MI-CHG-COLUMN-VALUE-LEN  
P00211           MOVE '*UPDATED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
P00211           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
P00211*                                                                         
P00211           ADD  1                      TO MI-TRAN-APPL-NO         
P00211           MOVE MH-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO    
P00211           MOVE SPACES                 TO MI-TABLE-ID             
P00211           MOVE 'EFF REV MONTH'        TO MI-COLUMN-DESC          
P00211           MOVE +06                    TO MI-PRV-COLUMN-VALUE-LEN 
P00211           MOVE WS-PRV-EFF-REV-MTH     TO WS-HOLD-REV-MTH-N       
P00211           MOVE WS-HOLD-REV-MTH-N      TO WS-HOLD-REV-MTH         
P00211           MOVE WS-HOLD-REV-MTH        TO MI-PRV-COLUMN-VALUE-TEXT
P00211           MOVE +06                    TO MI-CHG-COLUMN-VALUE-LEN 
P00211           MOVE WS-NEW-EFF-REV-MTH     TO WS-HOLD-REV-MTH-N       
P00211           MOVE WS-HOLD-REV-MTH-N      TO WS-HOLD-REV-MTH         
P00211           MOVE WS-HOLD-REV-MTH        TO MI-CHG-COLUMN-VALUE-TEXT
P00211           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
P00211        ELSE                                                      
P00211           ADD 1                       TO MI-TRAN-APPL-NO         
P00211           MOVE MH-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO    
P00211           MOVE SPACES                 TO MI-TABLE-ID             
P00211           MOVE 'PEND FACTOR'          TO MI-COLUMN-DESC          
P00211           MOVE +09                    TO MI-PRV-COLUMN-VALUE-LEN 
P00211           MOVE FF-FACTOR-ID           TO MI-PRV-COLUMN-VALUE-TEXT
P00211           MOVE +09                    TO MI-CHG-COLUMN-VALUE-LEN 
P00211           MOVE '*UPDATED*'            TO MI-CHG-COLUMN-VALUE-TEXT
P00211           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
P00211*                                                                         
P00211           ADD  1                      TO MI-TRAN-APPL-NO         
P00211           MOVE MH-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO    
P00211           MOVE SPACES                 TO MI-TABLE-ID             
P00211           MOVE 'FROM DATE'            TO MI-COLUMN-DESC          
P00211           MOVE +10                    TO MI-PRV-COLUMN-VALUE-LEN 
P00211           MOVE WS-PRV-EFF-DATE-FROM   TO MI-PRV-COLUMN-VALUE-TEXT
P00211           MOVE +10                    TO MI-CHG-COLUMN-VALUE-LEN 
P00211           MOVE WS-NEW-EFF-DATE-FROM   TO MI-CHG-COLUMN-VALUE-TEXT
P00211           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
P00211        END-IF                                                    
P00211     END-IF.                                                      
P00211                                                                  
P00211 5140-EXIT.                                                       
P00211     EXIT.                                                        
P00211*                                                                         
P00211*****************************************************************         
P00211*                                                               *         
P00211* 5150-CHECK-FINAL-BILLS.                                       *         
P00211*****************************************************************         
P00211 5150-CHECK-FINAL-BILLS.                                          
P00211                                                                  
P00211     MOVE 'N'                           TO WS-FCTR-UPDATE-SW      
P00211                                           WS-FCTR-CUSRSOR-SW.    
P00211     MOVE WS-INPUT-DATE                 TO HQ-ATTR-INCTV-STRT-DT  
P00211                                           HQ-ATTR-INCTV-END-DT.  
P00211                                                                  
P00211     MOVE WS-REVENUE-MONTH              TO WS-REV-MONTH-TMP       
P00211     MOVE WS-TEMP-YR-N                  TO WS-START-YR            
P00211     MOVE WS-TEMP-MT-N                  TO WS-START-MT            
P00211     MOVE '01'                          TO WS-START-DY            
P00211     MOVE 0                             TO MI-TRAN-APPL-NO        
P00211     PERFORM 7190-GET-CURR-TIMESTAMP       THRU 7190-EXIT         
P00211                                                                  
P00211     MOVE 'EXIT FEE'                    TO WS-SKIP-FCTR1.         
P00211     MOVE SPACES                        TO WS-SKIP-FCTR2.         
P00211     MOVE WS-CURR-RT-PKG-OPT-SEQ-NO     TO FF-RT-PKG-OPT-SEQ-NO.  
P00211     MOVE WS-OPTION-CD-OLD              TO HQ-OPTION-CD.          
P00211                                                                  
P00211     MOVE 'N'                           TO WS-NO-MORE-ROWS-01.    
P00211     PERFORM 7700-OPEN-OPTION-FCTR        THRU 7700-EXIT.         
P00211     PERFORM 7710-FETCH-OPTION-FCTR       THRU 7710-EXIT.         
P00211     PERFORM 5095-SET-NEW-DATES           THRU 5095-EXIT          
P00211                                          UNTIL NO-MORE-ROWS-01.  
P00211     PERFORM 7720-CLOSE-OPTION-FCTR       THRU 7720-EXIT.         
P00211     IF CURR-FCTR-UPDATED                                         
ACT176        INITIALIZE CWS00077-FIELDS                                
P00211        MOVE 17                         TO WS-77-CATEGORY-ID      
P00211        MOVE WS-FINAL-WQ-CMNTS          TO WS-77-COMMENTS-TEXT    
P00211        MOVE LENGTH OF WS-FINAL-WQ-CMNTS                          
P00211                                        TO WS-77-COMMENTS-LEN     
P00211        PERFORM 5040-PROCESS-WQ            THRU 5040-EXIT         
P00211        DISPLAY 'Final bill, factor date adjusted: ' AT-ACCOUNT-NO
P00211     END-IF.                                                      
P00211                                                                  
P00211 5150-EXIT.                                                       
P00211     EXIT.                                                        
P00211                                                                  
P00211*****************************************************************         
P00211*                                                               *         
P00211* 5160-WRITE-FINAL-TRANS.                                       *         
P00211*****************************************************************         
P00211 5160-WRITE-FINAL-TRANS.                                          
P00211                                                                  
P00211** DATA FOR CSS_MNT_TRANS_HIST                                            
P00211     MOVE WS-INPUT-DATE                TO MH-DATE-TRANS.          
P00211     MOVE WS-F                         TO MH-CODE-TRAN-TYPE.      
P00211     MOVE SPACES                       TO MH-RESP-AREA-ID.        
P00211     MOVE DF-ACCOUNT-NO                TO MH-ACCOUNT-NO.          
P00211     MOVE ZEROS                        TO MH-CUSTOMER-NO.         
P00211     MOVE AT-PREMISE-NO                TO MH-PREMISE-NO.          
P00211     MOVE 'SYSTEM'                     TO MH-USER-ID.             
P00211     MOVE WS-PROGRAM                   TO MH-APPL-PROGRAM-ID.     
P00211     MOVE +35                          TO MH-TRAN-COMMENT-LEN.    
P00211     MOVE WS-TRANS-HIST-CMNT-FCTR      TO MH-TRAN-COMMENT-TEXT.   
P00211*                                                                         
P00211     ADD 1                             TO MI-TRAN-APPL-NO.        
P00211     MOVE MH-TRANS-HIST-SEQ-NO         TO MI-TRANS-HIST-SEQ-NO.   
P00211     MOVE SPACES                       TO MI-TABLE-ID.            
P00211     MOVE 'CURR FACTOR'                TO MI-COLUMN-DESC.         
P00211     MOVE +09                          TO MI-PRV-COLUMN-VALUE-LEN.
P00211     MOVE FF-FACTOR-ID                 TO MI-PRV-COLUMN-VALUE-TEXT
P00211     MOVE +09                          TO MI-CHG-COLUMN-VALUE-LEN.
P00211     MOVE '*UPDATED*'                  TO MI-CHG-COLUMN-VALUE-TEXT
P00211     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
P00211*                                                                         
P00211     ADD 1                             TO MI-TRAN-APPL-NO.        
P00211     MOVE MH-TRANS-HIST-SEQ-NO         TO MI-TRANS-HIST-SEQ-NO.   
P00211     MOVE SPACES                       TO MI-TABLE-ID.            
P00211     MOVE 'START DATE'                 TO MI-COLUMN-DESC.         
P00211     MOVE +10                          TO MI-PRV-COLUMN-VALUE-LEN.
P00211     MOVE WS-PRV-EFF-DATE-FROM         TO MI-PRV-COLUMN-VALUE-TEXT
P00211     MOVE +10                          TO MI-CHG-COLUMN-VALUE-LEN.
P00211     MOVE FF-EFF-DATE-FROM             TO MI-CHG-COLUMN-VALUE-TEXT
P00211     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
P00211                                                                  
P00211 5160-EXIT.                                                       
P00211     EXIT.                                                        
P00211*                                                                         
A00388*****************************************************************         
A00388* CALCULATE FACTOR VALUE FOR SEABLKRES/SEABLKGEN FACTORS        *         
A00388*****************************************************************         
A00388 5500-CALC-SEABLK-FCTR.                                           
A00388*                                                                         
A00388     MOVE AT-ACCOUNT-NO                TO FF-ACCOUNT-NO.          
A00388     PERFORM 7300-OPEN-SEABLK-CURSOR   THRU 7300-EXIT.            
A00388     PERFORM 7310-FETCH-SEABLK-CURSOR  THRU 7310-EXIT.            
A00388     PERFORM 5550-PROCESS-SEABLK-FCTR  THRU 5550-EXIT             
A00388       UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
A00388     PERFORM 7320-CLOSE-SEABLK-CURSOR  THRU 7320-EXIT.            
A00388*                                                                         
A00388 5500-EXIT.                                                       
A00388     EXIT.                                                        
A00388*                                                                         
A00388******************************************************************13829000
A00388* VALIDATE ALL THE PARAMETERS & COMPUTE FACTOR AMOUNT            *13830000
A00388******************************************************************13840000
A00388*                                                                 13850000
A00388 5550-PROCESS-SEABLK-FCTR.                                        
A00388*                                                                 13870000
A00388     MOVE AT-ACCOUNT-NO                TO UT-ACCOUNT-NO           
A00388                                          CX-ACCOUNT-NO           
A00388                                          MN-ACCOUNT-NO           
A00388                                          BG-ACCOUNT-NO.          
A00388     MOVE FF-IC-NO                     TO UT-IC-NO                
A00388                                          CX-IC-NO                
A00388                                          MN-IC-NO                
A00388                                          BG-IC-NO.               
A00388     PERFORM 7330-SELECT-UTIL-DATA     THRU 7330-EXIT.            
A00388** GET BEGIN & END REVENUE MONTH RANGE                                    
A00388     PERFORM 7340-GET-CNSMPTN-DATA     THRU 7340-EXIT.            
A00388     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL  AND          
A00388        WS-CX-MAX-DATE-READ > '0001-01-01'                        
A00388        PERFORM 7350-CALC-SEABLK-DATES-CX THRU 7350-EXIT          
A00388     ELSE                                                         
A00388        PERFORM 7345-GET-LAST-REG-READ-DT THRU 7345-EXIT          
A00388        MOVE MN-LAST-REG-READ-DATE     TO WS-SEABLK-END-DT        
A00388        PERFORM 7355-CALC-SEABLK-DATES-MN THRU 7355-EXIT          
A00388     END-IF.                                                      
A00388     MOVE WS-SEABLK-BEG-DT(1:4) TO WS-SEABLK-BEG-REVMTH(1:4).     
A00388     MOVE WS-SEABLK-BEG-DT(6:2) TO WS-SEABLK-BEG-REVMTH(5:2).     
A00388     MOVE WS-SEABLK-END-DT(1:4) TO WS-SEABLK-END-REVMTH(1:4).     
A00388     MOVE WS-SEABLK-END-DT(6:2) TO WS-SEABLK-END-REVMTH(5:2).     
A00388** GET RATE PLAN OF LATEST BILLED REVENUE MONTH                   14090000
A00388     MOVE WS-SEABLK-BEG-REVMTH         TO BG-REVENUE-MONTH.       
A00388     PERFORM 7360-GET-LAST-BILLED-RATE THRU 7360-EXIT.            
A00388     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A00388        MOVE BG-RATE-PLAN-NO           TO BR-RATE-PLAN-NO         
A00388     ELSE                                                         
A00388        MOVE AT-PREMISE-NO             TO CH-PREMISE-NO           
A00388        PERFORM 7370-GET-PREV-ACCT-ON-PREMISE THRU 7370-EXIT      
A00388        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
A00388*** GET THE BG RATE PLAN USING OLD ACCT & OLD IC                  14140000
A00388           MOVE WS-OLD-ACCOUNT-NO      TO BG-ACCOUNT-NO           
A00388           MOVE WS-OLD-IC-NO           TO BG-IC-NO                
A00388           MOVE WS-SEABLK-BEG-REVMTH   TO BG-REVENUE-MONTH        
A00388           PERFORM 7360-GET-LAST-BILLED-RATE THRU 7360-EXIT       
A00388           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
A00388              MOVE BG-RATE-PLAN-NO     TO BR-RATE-PLAN-NO         
A00388           ELSE                                                   
A00388              MOVE UT-RATE-PLAN-NO     TO BR-RATE-PLAN-NO         
A00388           END-IF                                                 
A00388*** REFRESH BG- ACCT & IC WITH CURRENT ACCT..                     14140000
A00388           MOVE AT-ACCOUNT-NO          TO BG-ACCOUNT-NO           
A00388           MOVE FF-IC-NO               TO UT-IC-NO                
A00388           MOVE WS-SEABLK-BEG-REVMTH   TO BG-REVENUE-MONTH        
A00388        ELSE                                                      
A00388           MOVE UT-RATE-PLAN-NO        TO BR-RATE-PLAN-NO         
A00388        END-IF                                                    
A00388     END-IF.                                                      
A00388** GET LATEST BTU WNA RANGES FOR SEABLK RATE PLAN                 14090000
A00388     PERFORM 7380-GET-BTU-WNA-RANGES   THRU 7380-EXIT.            
A00388** COMPUTE SEABLK FACTOR AMOUNT                                   14180000
A00388     MOVE ZEROES                       TO WS-TOTAL-BFC-AMT.       
A00388     MOVE WS-SEABLK-BEG-REVMTH         TO WS-WORK-SEABLK-REVMTH.  
A00388     MOVE WS-SEABLK-BEG-DT             TO WS-WORK-SEABLK-DT.      
A00388     PERFORM 5575-COMPUTE-SEABLK-FCTR  THRU 5575-EXIT             
A00388       UNTIL WS-WORK-SEABLK-REVMTH > WS-SEABLK-END-REVMTH.        
A00388** IF WS-TOTAL-BFC-AMT > 0, UPDATE FACTOR IN CSS_FIXED_FCTR       14330000
A00388** OTHERWISE CREATE WARNING WQ..                                  14330000
A00388     IF WS-TOTAL-BFC-AMT  >  0                                    
A00388        MOVE 'G'                       TO FF-CODE-UTIL-TYPE       
A00388        MOVE WS-TOTAL-BFC-AMT          TO FF-FACTOR               
A00388        PERFORM 8100-UPDATE-FIXED-FCTR THRU 8100-EXIT             
A00388     ELSE                                                         
ACT176        INITIALIZE CWS00077-FIELDS                                
A00388        MOVE 17                        TO WS-77-CATEGORY-ID       
A00388        MOVE WS-SEASBLK-WQ-COMMENTS    TO WS-77-COMMENTS-TEXT     
A00388        MOVE LENGTH OF WS-SEASBLK-WQ-COMMENTS                     
A00388                                       TO WS-77-COMMENTS-LEN      
A00388        PERFORM 5040-PROCESS-WQ        THRU 5040-EXIT             
A00388        DISPLAY 'SEASONAL BLOCK FACTOR WQ CREATED: '              
A00388                                          AT-ACCOUNT-NO           
A00388     END-IF.                                                      
A00388*                                                                 14360000
A00388     PERFORM 7310-FETCH-SEABLK-CURSOR  THRU 7310-EXIT.            
A00388*                                                                 14390000
A00388 5550-EXIT.                                                       
A00388     EXIT.                                                        
A00388*                                                                 14420000
A00388******************************************************************13829000
A00388* COMPUTE SEASONAL BLOCK CHARGE                                  *13830000
A00388* BFC ADJUSTMENTS ARE APPLIED VIA RATE FACTORS ONLY. CURRENTLY   *13830000
A00388* FIXED FACTOR RELATED BFC ADJUSTMENTS ARE NOT HANDLED.          *13830000
A00388******************************************************************13840000
A00388*                                                                 13850000
A00388 5575-COMPUTE-SEABLK-FCTR.                                        
A00388*                                                                 13870000
A00388     MOVE BR-RATE-PLAN-NO              TO RT-RATE-PLAN-NO.        
A00388     IF WS-WORK-SEABLK-REVMTH(5:2) = WS-WINTER-START-MTH AND      
A00388        BR-GAS-BASE-USE-MIN > 0                                   
A00388        IF UT-GAS-BASE-USE >= BR-GAS-BASE-USE-MIN                 
A00388           IF BR-GAS-BASE-HIGH-RATE NOT EQUAL BR-RATE-PLAN-NO     
A00388              MOVE BR-GAS-BASE-HIGH-RATE TO RT-RATE-PLAN-NO       
A00388           END-IF                                                 
A00388        ELSE                                                      
A00388           IF BR-GAS-BASE-LOW-RATE NOT EQUAL BR-RATE-PLAN-NO      
A00388              MOVE BR-GAS-BASE-LOW-RATE TO RT-RATE-PLAN-NO        
A00388           END-IF                                                 
A00388        END-IF                                                    
A00388     END-IF.                                                      
A00388*                                                                 13870000
A00388     MOVE ZERO                         TO J4-AMT-CUST-CHRG        
A00388                                          WS-BFC-AMT.             
A00388     MOVE WS-WORK-SEABLK-DT            TO RT-FROM-EFFECTIVE-DT.   
A00388     PERFORM 7390-GET-BFC              THRU 7390-EXIT.            
A00388     MOVE J4-AMT-CUST-CHRG             TO WS-BFC-AMT.             
A00388*                                                                         
A00388     MOVE RT-RATE-PLAN-NO              TO RS-RATE-PLAN-NO.        
A00388     MOVE J4-VERSION-NO-CNTRL          TO RS-VERSION-NO-CNTRL.    
A00388     PERFORM 7400-GET-SEASONS          THRU 7400-EXIT.            
A00388*                                                                         
A00388     MOVE RS-RATE-PLAN-NO              TO SA-RATE-PLAN-NO.        
A00388     MOVE WS-WORK-SEABLK-DT            TO SA-DATE-FROM            
A00388                                          SA-DATE-TO.             
A00388     MOVE RS-DATE-FROM                 TO WS-WORK-DATE-FROM.      
A00388     MOVE RS-DATE-TO                   TO WS-WORK-DATE-TO.        
A00388     IF WS-WORK-DATE-FROM = ZERO                                  
A00388        MOVE 'S'                       TO SA-CODE-SEASON          
A00388     ELSE                                                         
A00388        IF (WS-WORK-DATE-FROM(1:2) <= WS-WORK-SEABLK-REVMTH(5:2)) 
A00388                                   AND                            
A00388           (WS-WORK-DATE-TO(1:2)   >= WS-WORK-SEABLK-REVMTH(5:2)) 
A00388           MOVE 'S'                    TO SA-CODE-SEASON          
A00388        ELSE                                                      
A00388           MOVE 'N'                    TO SA-CODE-SEASON          
A00388        END-IF                                                    
A00388     END-IF.                                                      
A00388     PERFORM 7410-GET-BFC-ADJUST       THRU 7410-EXIT.            
A00388     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A00388        IF SF-ADJUST-ELEMENT = 'L'                                
A00388           COMPUTE WS-BFC-AMT = WS-BFC-AMT + SA-FACTOR            
A00388        ELSE                                                      
A00388           COMPUTE WS-BFC-AMT = WS-BFC-AMT - SA-FACTOR            
A00388        END-IF                                                    
A00388     END-IF.                                                      
A00388     COMPUTE WS-TOTAL-BFC-AMT = WS-TOTAL-BFC-AMT + WS-BFC-AMT.    
A00388*                                                                         
A00388     PERFORM 7420-ADD-ONE-MONTH        THRU 7420-EXIT.            
A00388     MOVE WS-WORK-SEABLK-DT(1:4) TO WS-WORK-SEABLK-REVMTH(1:4).   
A00388     MOVE WS-WORK-SEABLK-DT(6:2) TO WS-WORK-SEABLK-REVMTH(5:2).   
A00388*                                                                 13870000
A00388 5575-EXIT.                                                       
A00388     EXIT.                                                        
A00388*                                                                 14420000
      *****************************************************************         
      *                                                               *         
      * 5600-PROCESS-UTL-CSR.                                         *         
      *****************************************************************         
       5600-PROCESS-UTL-CSR.                                            
                                                                        
           INITIALIZE LS-626-INPUT-FIELDS                               
                      LS-626-OUTPUT-FIELDS.                             
                                                                        
           MOVE WS-PGRMNAME                  TO WS-626-CALLING-PGM      
           MOVE WS-ACCOUNT-NO                TO WS-626-ACCOUNT-NO       
           MOVE WS-COMPANY-NO                TO WS-626-COMPANY-NO       
           MOVE UT-CODE-UTIL-TYPE            TO WS-626-CODE-UTIL-TYPE   
           MOVE UT-RATE-PLAN-NO              TO WS-626-VALUE-CD         
           MOVE SPACES                       TO WS-626-PREV-VALUE-CD    
                                                WS-626-USER-ID          
           MOVE RATE                         TO WS-626-VALUE-SOURCE-CD  
           MOVE WS-REVENUE-MONTH             TO WS-626-MSG-REV-MONTH    
           MOVE AT-CODE-ACCT-STAT            TO WS-626-CODE-ACCT-STAT   
           MOVE 'Y'                          TO WS-626-DB2-UPDATE-FLAG  
                                                                        
I00251     PERFORM 5610-CALL-SCSCA626           THRU 5610-EXIT          
                                                                        
           PERFORM 7510-FETCH-UTL-ENVRNMT       THRU 7510-EXIT.         
                                                                        
       5600-EXIT.                                                       
           EXIT.                                                        
                                                                        
I00251*****************************************************************         
I00251*                                                               *         
I00251* 5605-INSERT-SPCL-BILL-MSGS.                                   *         
I00251*****************************************************************         
I00251 5605-INSERT-SPCL-BILL-MSGS.                                      
I00251                                                                  
I00251     INITIALIZE LS-626-INPUT-FIELDS                               
I00251                LS-626-OUTPUT-FIELDS.                             
I00251                                                                  
I00251     MOVE WS-PGRMNAME                  TO WS-626-CALLING-PGM      
I00251     MOVE WS-ACCOUNT-NO                TO WS-626-ACCOUNT-NO       
I00251     MOVE WS-COMPANY-NO                TO WS-626-COMPANY-NO       
I00251     MOVE 'G'                          TO WS-626-CODE-UTIL-TYPE   
I00251     MOVE WS-CA328-OPTION-CD           TO WS-626-VALUE-CD         
I00251     MOVE SPACES                       TO WS-626-PREV-VALUE-CD    
I00251                                          WS-626-USER-ID          
I00251     MOVE WS-OPTION                    TO WS-626-VALUE-SOURCE-CD  
I00251     MOVE WS-REVENUE-MONTH             TO WS-626-MSG-REV-MONTH    
I00251     MOVE AT-CODE-ACCT-STAT            TO WS-626-CODE-ACCT-STAT   
I00251     MOVE 'Y'                          TO WS-626-DB2-UPDATE-FLAG  
I00251                                                                  
I00251     PERFORM 5610-CALL-SCSCA626           THRU 5610-EXIT.         
I00251                                                                  
I00251 5605-EXIT.                                                       
I00251     EXIT.                                                        
                                                                        
I00251******************************************************************        
I00251*                                                                *        
I00251* 5610-CALL-SCSCA626.                                            *        
I00251******************************************************************        
I00251 5610-CALL-SCSCA626.                                              
I00251                                                                  
I00251     CALL SCSCA626  USING  ABEND-FILE                             
I00251                          ,WS-WARNING-DATA-ELEMENTS               
I00251                          ,LS-626-INPUT-FIELDS                    
I00251                          ,LS-626-OUTPUT-FIELDS.                  
I00251                                                                  
I00251     IF WS-626-RETURN-CODE NOT EQUAL ZEROES                       
I00251       DISPLAY '********** PCSCA290 ABORT **************'         
I00251       DISPLAY '*       5610-CALL-SCSCA626             *'         
I00251       DISPLAY 'RETURN CODE  = ' WS-626-RETURN-CODE               
I00251       DISPLAY 'ACCOUNT NO   = ' WS-626-ACCOUNT-NO                
I00251       DISPLAY 'UTIL TYPE    = ' WS-626-CODE-UTIL-TYPE            
I00251       DISPLAY 'OPTION CODE  = ' WS-626-VALUE-SOURCE-CD           
I00251       DISPLAY 'MSG REV MTH  = ' WS-626-MSG-REV-MONTH             
I00251       DISPLAY '      PROCESSING TERMINATED            *'         
I00251       DISPLAY '********** PCSCA290 ABORT **************'         
I00251       PERFORM 9900-ABEND                 THRU 9900-EXIT          
I00251     END-IF                                                       
I00251                                                                  
I00251     IF WS-626-RETURN-ROW-COUNT GREATER THAN ZEROES               
I00251        DISPLAY 'SPECIAL MESSAGE INSERTED: ' WS-ACCOUNT-NO        
I00251     END-IF                                                       
I00251                                                                  
I00251     IF WS-626-MSG-DEL-COUNT GREATER THAN ZEROES                  
I00251        DISPLAY 'SPECIAL MESSAGE DELETED: '  WS-ACCOUNT-NO        
I00251     END-IF.                                                      
I00251                                                                  
I00251 5610-EXIT.                                                       
I00251     EXIT.                                                        
I00251                                                                  
      ******************************************************************        
      *                                                                *        
      * 5700-FIND-REVENUE-MONTH.                                       *        
      ******************************************************************        
       5700-FIND-REVENUE-MONTH.                                         
                                                                        
           MOVE ZEROES                       TO WS-REV-COUNT            
                                                WS-OLDEST-REV-MONTH     
                                                WS-PREV-REVENUE-MONTH.  
                                                                        
           MOVE 1                            TO WS-INDEX                
           PERFORM 5750-GET-OLDEST-REV-MONTH    THRU 5750-EXIT          
                   UNTIL WS-FCA00-BLCYC-NUMBER(WS-INDEX) = '00'         
                                                OR WS-INDEX >= 8.       
           PERFORM 5800-LOAD-REVENUE-MONTH      THRU 5800-EXIT.         
                                                                        
       5700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5750-GET-OLDEST-REV-MONTH.                                     *        
      ******************************************************************        
       5750-GET-OLDEST-REV-MONTH.                                       
                                                                        
            IF WS-FCA00-REV-MONTH (WS-INDEX) =                          
                  WS-PREV-REVENUE-MONTH                                 
                CONTINUE                                                
            ELSE                                                        
                ADD 1 TO WS-REV-COUNT                                   
              IF WS-PREV-REVENUE-MONTH = ZEROES                         
                  MOVE WS-FCA00-REV-MONTH(WS-INDEX) TO                  
                        WS-OLDEST-REV-MONTH                             
              END-IF                                                    
              IF WS-FCA00-REV-MONTH (WS-INDEX) <=  WS-PREV-REVENUE-MONTH
                 AND WS-FCA00-REV-MONTH (WS-INDEX) NOT = ZEROES         
                    MOVE WS-FCA00-REV-MONTH(WS-INDEX) TO                
                         WS-OLDEST-REV-MONTH                            
              END-IF                                                    
            END-IF                                                      
                                                                        
            MOVE WS-FCA00-REV-MONTH(WS-INDEX)                           
                                             TO WS-PREV-REVENUE-MONTH.  
            ADD 1                            TO WS-INDEX.               
                                                                        
       5750-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5800-LOAD-REVENUE-MONTH.                                       *        
      ******************************************************************        
       5800-LOAD-REVENUE-MONTH.                                         
                                                                        
            IF WS-REV-COUNT = 1                                         
               PERFORM 5850-LOAD-ONE-REVENUE-MONTH THRU 5850-EXIT       
            ELSE                                                        
ACT361         IF E-FDB07-OFF-CYCLE-BILL-CODE EQUAL                     
ACT361                             FINAL-BILL OR OFF-CYC-REBILL         
ACT361            INITIALIZE                   WS-REV-MTH-LST-NRML      
ACT361            MOVE AT-REV-MTH-LST-NRML  TO WS-REV-MTH-LST-NRML      
                  SET WS-BILL-CYC-INDX TO 1                             
                  SEARCH WS-FCA00-BILLING-CYCLES                        
                     AT END                                             
                       MOVE WS-OLDEST-REV-MONTH TO WS-REVENUE-MONTH     
                  WHEN (WS-FCA00-REV-MONTH (WS-BILL-CYC-INDX) EQUAL     
                        WS-REV-MTH-LST-NRML)  AND                       
                        (WS-REV-MTH-LST-NRML NOT = ZERO)                
                        MOVE WS-FCA00-REV-MONTH (WS-BILL-CYC-INDX)      
                                            TO WS-REVENUE-MONTH         
                                                                        
                  END-SEARCH                                            
               ELSE                                                     
                  SET WS-BILL-CYC-INDX TO 1                             
                  SEARCH WS-FCA00-BILLING-CYCLES                        
                     AT END                                             
                     MOVE WS-OLDEST-REV-MONTH TO WS-REVENUE-MONTH       
                  WHEN WS-FCA00-BLCYC-NUMBER (WS-BILL-CYC-INDX) EQUAL   
                        WS-BILL-CYCLE                                   
                  MOVE WS-FCA00-REV-MONTH (WS-BILL-CYC-INDX)            
                                                TO WS-REVENUE-MONTH     
                  END-SEARCH                                            
               END-IF                                                   
            END-IF.                                                     
                                                                        
       5800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5850-LOAD-ONE-REVENUE-MONTH.                                   *        
      ******************************************************************        
       5850-LOAD-ONE-REVENUE-MONTH.                                     
                                                                        
           SET WS-BILL-CYC-INDX TO 1                                    
           SEARCH WS-FCA00-BILLING-CYCLES                               
              AT END                                                    
                MOVE WS-REVENUE-MONTH-JP     TO WS-REVENUE-MONTH        
              WHEN WS-FCA00-BLCYC-NUMBER (WS-BILL-CYC-INDX) EQUAL       
                   WS-BILL-CYCLE                                        
                 MOVE WS-FCA00-REV-MONTH (WS-BILL-CYC-INDX)             
                                             TO WS-REVENUE-MONTH        
           END-SEARCH.                                                  
                                                                        
       5850-EXIT.                                                       
           EXIT.                                                        
                                                                        
P805CS*****************************************************************         
P805CS*                                                               *         
P805CS* 6100-APPLY-DISCOUNTS.                                         *         
P805CS* CALL SUBROUTINE SCSCA444 TO APPLY CSC DISCOUNTS ON ACCOUNT    *         
P805CS* BASED ON THE CURRENT ELIGIBILITY.                             *         
P805CS*****************************************************************         
P805CS 6100-APPLY-DISCOUNTS.                                            
P805CS                                                                  
P805CS     INITIALIZE ABEND-FILE                                        
P805CS                LS-MCSCB444-COMM-AREA.                            
P805CS                                                                  
P805CS     MOVE E-FDB07-ACCT-NO              TO WS-444-I-ACCT-NO.       
P805CS     MOVE WS-PGRMNAME                  TO WS-444-I-PGM-ID.        
P805CS     MOVE 'SYSTEM'                     TO WS-444-I-USER-ID.       
P805CS                                                                  
P805CS     CALL SCSCA444 USING ABEND-FILE                               
P805CS                        ,WS-WARNING-DATA-ELEMENTS                 
P805CS                        ,LS-MCSCB444-COMM-AREA.                   
P805CS                                                                  
P805CS     MOVE WS-ACTIVE-RETURN-CODE        TO RS-RETURN-CODE-DISP.    
P805CS                                                                  
P805CS     IF WS-ACTIVE-RETURN-CODE NOT EQUAL +0                        
P805CS        DISPLAY '********** PCSCA290 ABORT *********'             
P805CS        DISPLAY '**      6100-APPLY-DISCOUNTS     **'             
P805CS        DISPLAY '**    ERROR ON CALLING SCSCA444  **'             
P805CS        DISPLAY 'RETURN CODE  = ' RS-RETURN-CODE-DISP             
P805CS        DISPLAY 'ACCOUNT_NO   = ' E-FDB07-ACCT-NO                 
P805CS        DISPLAY 'ABEND PARA   = ' ACTIVE-PARAGRAPH                
P805CS        DISPLAY '**     PROCESSING TERMINATED     **'             
P805CS        DISPLAY '********** PCSCA290 ABORT *********'             
P805CS        PERFORM 9900-ABEND                THRU 9900-EXIT          
P805CS     END-IF.                                                      
P805CS                                                                  
P805CS 6100-EXIT.                                                       
ACT361     EXIT.                                                        
ACT361*                                                                         
      ******************************************************************        
      *                                                                *        
      * 7000-READ-FCSDB07.                                             *        
      ******************************************************************        
       7000-READ-FCSDB07.                                               
                                                                        
           READ FCSDB07-FILE                                            
           IF FDB07-END-OF-FILE                                         
              GO TO 7000-EXIT                                           
           END-IF.                                                      
                                                                        
           IF FDB07-SUCCESSFUL                                          
               IF E-FDB07-KEY-BREC NOT EQUAL HIGH-VALUES                
                           OR E-FDB07-KEY-BREC NOT EQUAL LOW-VALUES     
                  IF DATA-RECORD-FOUND                                  
                     ADD +01                TO WS-FCSDB07-REC-CNTR      
                                               WS-RESTART-COMMIT-COUNTER
                  END-IF                                                
               END-IF                                                   
           ELSE                                                         
             DISPLAY '********** PCSCA290 ABORT **************'         
             DISPLAY '*     READ ERROR : DB07 FILE           *'         
             DISPLAY '* CURRENT PARA   : 7000                *'         
             DISPLAY '* FILE-STATUS    : ' WS-FDB07-STATUS              
             DISPLAY '*     PROCESSING TERMINATED            *'         
             DISPLAY '********** PCSCA290 ABORT **************'         
             PERFORM 9900-ABEND               THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
I00251******************************************************************        
I00251*                                                                *        
I00251* 7010-SELECT-DELINQ-VALUE.                                      *        
I00251******************************************************************        
I00251 7010-SELECT-DELINQ-VALUE.                                        
I00251                                                                  
I00251     EXEC SQL                                                     
I00251        SELECT DELINQ_VALUE                                       
I00251          INTO :C8-DELINQ-VALUE                                   
I00251          FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
I00251         WHERE DELINQ_CD  = :C8-DELINQ-CD                         
I00251           AND COMPANY_NO = :C8-COMPANY-NO                        
I00251                                                           
I00251     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     29980000
MFA-TR*       SELECT DELINQ_VALUE                                       29990000
MFA-TR*         INTO :C8-DELINQ-VALUE                                   30000000
MFA-TR*         FROM CSS_DELINQUENCY                                    30010000
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                         30020000
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                        30030000
MFA-TR*        WITH UR                                                  30040000
MFA-TR*    END-EXEC.                                                    30050000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00251                                                                  
I00251     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
I00251                                                                  
I00251     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
I00251        CONTINUE                                                  
I00251     ELSE                                                         
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        DISPLAY '*    7010-SELECT-DELINQ-VALUE          *'        
I00251        DISPLAY '* DELINQ_CD     : ' C8-DELINQ-CD                 
I00251        DISPLAY '* COMPANY_NO    : ' C8-COMPANY-NO                
I00251        DISPLAY '* SQLCODE       : ' WS-ACTIVE-RETURN-CODE        
I00251        DISPLAY '*     PROCESSING TERMINATED            *'        
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        PERFORM 9900-ABEND               THRU 9900-EXIT           
I00251     END-IF.                                                      
I00251                                                                  
I00251 7010-EXIT.                                                       
I00251     EXIT.                                                        
A04727                                                                  
A04727******************************************************************        
A04727*                                                                *        
A04727* 7050-CHK-ACCT-ATTRIBUTE-STAT.                                  *        
A04727******************************************************************        
A04727 7050-CHK-ACCT-ATTRIBUTE-STAT.                                    
A04727                                                                  
A04727     EXEC SQL                                                     
A04727        SELECT TOP(1) 'Y'                                                
A04727          INTO :WS-FB-AND-MKT-SWITCH                              
A04727          FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)                
A04727         WHERE YP.ACCOUNT_NO          = :YP-ACCOUNT-NO            
A04727           AND YP.ATTRIBUTE_DESC      = :YP-ATTRIBUTE-DESC        
A04727           AND YP.ATTRIBUTE_VALUE_DT >= IIF(TRY_CONVERT(DATE, 
                                                 :YP-ATTRIBUTE-VALUE-DT
              ) IS NULL OR (PATINDEX('%.%', :YP-ATTRIBUTE-VALUE-DT
              ) <> 0) OR (LEN(:YP-ATTRIBUTE-VALUE-DT
              ) <> 10), CIS.CHAR2DATE(:YP-ATTRIBUTE-VALUE-DT
              ), CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT) )    
A04727                                       
A04727                                                      
A04727     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     29980000
MFA-TR*       SELECT 'Y'                                                29990000
MFA-TR*         INTO :WS-FB-AND-MKT-SWITCH                              30000000
MFA-TR*         FROM CSS_ACCT_ATTRIBUTE YP                              30010000
MFA-TR*        WHERE YP.ACCOUNT_NO          = :YP-ACCOUNT-NO            30020000
MFA-TR*          AND YP.ATTRIBUTE_DESC      = :YP-ATTRIBUTE-DESC                
MFA-TR*          AND YP.ATTRIBUTE_VALUE_DT >= :YP-ATTRIBUTE-VALUE-DT    30030000
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                             30040000
MFA-TR*      QUERYNO 7050                                               30040000
MFA-TR*    END-EXEC.                                                    30050000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04727                                                                  
A04727     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
A04727                                                                  
A04727     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A04727        CONTINUE                                                  
A04727     ELSE                                                         
A04727        DISPLAY '********** PCSCA290 ABORT **************'        
A04727        DISPLAY '*    7050-CHK-ACCT-ATTRABUTE-STAT      *'        
A04727        DISPLAY '* ACCOUNT_NO    : ' YP-ACCOUNT-NO                
A04727        DISPLAY '* INPUT_DATE    : ' WS-INPUT-DATE                
A04727        DISPLAY '* SQLCODE       : ' WS-ACTIVE-RETURN-CODE        
A04727        DISPLAY '*     PROCESSING TERMINATED            *'        
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
A04727        PERFORM 9900-ABEND               THRU 9900-EXIT           
A04727     END-IF.                                                      
A04727                                                                  
A04727 7050-EXIT.                                                       
A04727     EXIT.                                                        
A04727                                                                  
A04727****************************************************************          
A04727* 7060-GET-CURR-FIXED-FCTR.                                    *          
A04727****************************************************************          
A04727 7060-GET-CURR-FIXED-FCTR.                                        
A04727                                                                  
A04727     EXEC SQL                                                     
A04727        SELECT TOP(1) FF.ACCOUNT_NO,
              FF.CODE_UTIL_TYPE,
              FF.IC_NO,
              FF.FACTOR_ID,
              FF.EFF_DATE_FROM,
              FF.CMPNT_ID_CD,
              FF.CODE_SEASON,
              FF.INSTR_USE_TYPE_CD,
              FF.CODE_TIME_PERIOD,
              FF.EFF_DATE_TO,
              FF.FIXED_FCTR_TYP_CD,
              FF.FACTOR,
              FF.FAC_CHRG_BASE_AM,
              REPLACE(REPLACE(CONVERT(CHAR(26), FF.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,
              FF.RT_PKG_OPT_SEQ_NO,
              FF.BLOCK_NO                                       
A04727          INTO :FF-ACCOUNT-NO                                     
A04727              ,:FF-CODE-UTIL-TYPE                                 
A04727              ,:FF-IC-NO                                          
A04727              ,:FF-FACTOR-ID                                      
A04727              ,:FF-EFF-DATE-FROM                                  
A04727              ,:FF-CMPNT-ID-CD                                    
A04727              ,:FF-CODE-SEASON                                    
A04727              ,:FF-INSTR-USE-TYPE-CD                              
A04727              ,:FF-CODE-TIME-PERIOD                               
A04727              ,:FF-EFF-DATE-TO :WS-NULL-IND-08                     
A04727              ,:FF-FIXED-FCTR-TYP-CD                              
A04727              ,:FF-FACTOR                                         
A04727              ,:FF-FAC-CHRG-BASE-AM                               
A04727              ,:FF-LAST-UPDATE-TS                                 
A04727              ,:FF-RT-PKG-OPT-SEQ-NO                              
A04727              ,:FF-BLOCK-NO                                       
A04727          FROM CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)                
A04727              ,CSS_FIXED_FCTR     FF WITH(READUNCOMMITTED)                
A04727         WHERE FF.ACCOUNT_NO           = :FF-ACCOUNT-NO           
A04727           AND FF.CODE_UTIL_TYPE       = :FF-CODE-UTIL-TYPE       
A04727           AND FF.IC_NO                = :FF-IC-NO                
A04727           AND FF.RT_PKG_OPT_SEQ_NO    = :FF-RT-PKG-OPT-SEQ-NO    
A04727           AND HQ.OPTION_CD            = :HQ-OPTION-CD            
A04727           AND HQ.FACTOR_ID            = FF.FACTOR_ID             
A04727           AND HQ.PRIMRY_OPT_ATTR_FL   = 'Y'                      
A04727           AND HQ.RT_ATTR_INCTV_TYPE   = 'FIXED PRICE'            
A04727           AND HQ.ATTR_INCTV_STRT_DT   <= 
           CAST(SYSDATETIMEOFFSET() AS DATE)            
A04727           AND HQ.ATTR_INCTV_END_DT    >= 
           CAST(SYSDATETIMEOFFSET() AS DATE)            
A04727           AND HQ.OPT_ATTR_VSTART_TS   <= CIS.CURRENT$TIMESTAMP()       
A04727           AND HQ.OPT_ATTR_VEND_TS     >= CIS.CURRENT$TIMESTAMP()       
A04727           AND HQ.PROC_STATUS_CD        = 'AC'                    
A04727         ORDER BY HQ.OPT_ATTR_VSTART_TS DESC                      
A04727                 ,FF.EFF_DATE_FROM DESC                           
A04727                                       
A04727     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  FF.ACCOUNT_NO                                             
MFA-TR*              ,FF.CODE_UTIL_TYPE                                         
MFA-TR*              ,FF.IC_NO                                                  
MFA-TR*              ,FF.FACTOR_ID                                              
MFA-TR*              ,FF.EFF_DATE_FROM                                          
MFA-TR*              ,FF.CMPNT_ID_CD                                            
MFA-TR*              ,FF.CODE_SEASON                                            
MFA-TR*              ,FF.INSTR_USE_TYPE_CD                                      
MFA-TR*              ,FF.CODE_TIME_PERIOD                                       
MFA-TR*              ,FF.EFF_DATE_TO                                            
MFA-TR*              ,FF.FIXED_FCTR_TYP_CD                                      
MFA-TR*              ,FF.FACTOR                                                 
MFA-TR*              ,FF.FAC_CHRG_BASE_AM                                       
MFA-TR*              ,FF.LAST_UPDATE_TS                                         
MFA-TR*              ,FF.RT_PKG_OPT_SEQ_NO                                      
MFA-TR*              ,FF.BLOCK_NO                                               
MFA-TR*         INTO :FF-ACCOUNT-NO                                             
MFA-TR*             ,:FF-CODE-UTIL-TYPE                                         
MFA-TR*             ,:FF-IC-NO                                                  
MFA-TR*             ,:FF-FACTOR-ID                                              
MFA-TR*             ,:FF-EFF-DATE-FROM                                          
MFA-TR*             ,:FF-CMPNT-ID-CD                                            
MFA-TR*             ,:FF-CODE-SEASON                                            
MFA-TR*             ,:FF-INSTR-USE-TYPE-CD                                      
MFA-TR*             ,:FF-CODE-TIME-PERIOD                                       
MFA-TR*             ,:FF-EFF-DATE-TO:WS-NULL-IND-08                             
MFA-TR*             ,:FF-FIXED-FCTR-TYP-CD                                      
MFA-TR*             ,:FF-FACTOR                                                 
MFA-TR*             ,:FF-FAC-CHRG-BASE-AM                                       
MFA-TR*             ,:FF-LAST-UPDATE-TS                                         
MFA-TR*             ,:FF-RT-PKG-OPT-SEQ-NO                                      
MFA-TR*             ,:FF-BLOCK-NO                                               
MFA-TR*         FROM CRM_OPT_ATTR_INCTV HQ                                      
MFA-TR*             ,CSS_FIXED_FCTR     FF                                      
MFA-TR*        WHERE FF.ACCOUNT_NO           = :FF-ACCOUNT-NO                   
MFA-TR*          AND FF.CODE_UTIL_TYPE       = :FF-CODE-UTIL-TYPE               
MFA-TR*          AND FF.IC_NO                = :FF-IC-NO                        
MFA-TR*          AND FF.RT_PKG_OPT_SEQ_NO    = :FF-RT-PKG-OPT-SEQ-NO            
MFA-TR*          AND HQ.OPTION_CD            = :HQ-OPTION-CD                    
MFA-TR*          AND HQ.FACTOR_ID            = FF.FACTOR_ID                     
MFA-TR*          AND HQ.PRIMRY_OPT_ATTR_FL   = 'Y'                              
MFA-TR*          AND HQ.RT_ATTR_INCTV_TYPE   = 'FIXED PRICE'                    
MFA-TR*          AND HQ.ATTR_INCTV_STRT_DT   <= CURRENT DATE                    
MFA-TR*          AND HQ.ATTR_INCTV_END_DT    >= CURRENT DATE                    
MFA-TR*          AND HQ.OPT_ATTR_VSTART_TS   <= CURRENT TIMESTAMP               
MFA-TR*          AND HQ.OPT_ATTR_VEND_TS     >= CURRENT TIMESTAMP               
MFA-TR*          AND HQ.PROC_STATUS_CD        = 'AC'                            
MFA-TR*        ORDER BY HQ.OPT_ATTR_VSTART_TS DESC                              
MFA-TR*                ,FF.EFF_DATE_FROM DESC                                   
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*    END-EXEC                                                     52134701

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04727                                                                  
A04727     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
A04727                                                                  
A04727     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A04727        IF WS-NULL-IND-08 = -1                                    
A04727           MOVE SPACES                TO FF-EFF-DATE-TO           
A04727        END-IF                                                    
A04727     ELSE                                                         
A04727        DISPLAY '********** PCSCA290 ABORT **************'        
A04727        DISPLAY '*  7060-GET-CURR-FIXED-FCTR            *'        
A04727        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
A04727        DISPLAY '* ACCOUNT NO        : ' FF-ACCOUNT-NO            
A04727        DISPLAY '* CODE UTIL TYPE    : ' FF-CODE-UTIL-TYPE        
A04727        DISPLAY '* IC NO             : ' FF-IC-NO                 
A04727        DISPLAY '* OPTION CD         : ' HQ-OPTION-CD             
A04727        DISPLAY '*     PROCESSING TERMINATED            *'        
A04727        DISPLAY '********** PCSCA290 ABORT **************'        
A04727        PERFORM 9900-ABEND                THRU 9900-EXIT          
A04727     END-IF.                                                      
A04727                                                                  
A04727 7060-EXIT.                                                       
A04727     EXIT.                                                        
                                                                        
A04727*****************************************************************         
A04727*                                                               *         
A04727* 7070-GET-MAX-FF-SEQ-NO.                                       *         
A04727*****************************************************************         
A04727 7070-GET-MAX-FF-SEQ-NO.                                          
A04727                                                                  
A04727     EXEC SQL                                                     
A04727        SELECT MAX(FIXED_FCTR_SEQ_NO)                             
A04727          INTO :FF-FIXED-FCTR-SEQ-NO :WS-NULL-IND-07               
A04727          FROM CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                    
A04727         WHERE FF.ACCOUNT_NO     = :FF-ACCOUNT-NO                 
A04727           AND FF.CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE             
A04727           AND FF.IC_NO          = :FF-IC-NO                      
A04727                                                           
A04727                                                      
A04727     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(FIXED_FCTR_SEQ_NO)                                     
MFA-TR*         INTO :FF-FIXED-FCTR-SEQ-NO:WS-NULL-IND-07                       
MFA-TR*         FROM CSS_FIXED_FCTR FF                                          
MFA-TR*        WHERE FF.ACCOUNT_NO     = :FF-ACCOUNT-NO                         
MFA-TR*          AND FF.CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE                     
MFA-TR*          AND FF.IC_NO          = :FF-IC-NO                              
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7070                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04727                                                                  
A04727     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
A04727                                                                  
A04727     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A04727        IF WS-NULL-IND-07 EQUAL -1                                
A04727           MOVE ZEROES                 TO FF-FIXED-FCTR-SEQ-NO    
A04727        END-IF                                                    
A04727     ELSE                                                         
A04727        DISPLAY '********** PCSCA290 ABORT **************'        
A04727        DISPLAY '*  7070-GET-MAX-FF-SEQ-NO              *'        
A04727        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
A04727        DISPLAY '* ACCOUNT NO        : ' FF-ACCOUNT-NO            
A04727        DISPLAY '* CODE UTIL TYPE    : ' FF-CODE-UTIL-TYPE        
A04727        DISPLAY '* IC NO             : ' FF-IC-NO                 
A04727        DISPLAY '* OPTION CD         : ' HQ-OPTION-CD             
A04727        DISPLAY '*     PROCESSING TERMINATED            *'        
A04727        DISPLAY '********** PCSCA290 ABORT **************'        
A04727        PERFORM 9900-ABEND                THRU 9900-EXIT          
A04727     END-IF.                                                      
A04727                                                                  
A04727 7070-EXIT.                                                       
A04727     EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7100-SEL-ACCOUNT-DET.                                         *         
      *****************************************************************         
       7100-SEL-ACCOUNT-DET.                                            
                                                                        
           EXEC SQL                                                     
               SELECT AT.CODE_ACCT_STAT                                 
                     ,AT.REV_MTH_LST_NRML                               
                     ,AT.BILL_CYCLE                                     
                     ,AT.CODE_ACCT_BILLED                               
I00251               ,AT.CUSTOMER_NO                                    
I00251               ,AT.LOCAL_OFFICE                                   
I00251               ,AT.PREMISE_NO                                     
I00251               ,AT.COMPANY_NO                                     
P805CS               ,AT.ACCOUNT_TYPE_CODE                              
                 INTO :AT-CODE-ACCT-STAT                                
                     ,:AT-REV-MTH-LST-NRML                              
                     ,:AT-BILL-CYCLE                                    
                     ,:AT-CODE-ACCT-BILLED                              
I00251               ,:AT-CUSTOMER-NO                                   
I00251               ,:AT-LOCAL-OFFICE                                  
I00251               ,:AT-PREMISE-NO                                    
I00251               ,:AT-COMPANY-NO                                    
P805CS               ,:AT-ACCOUNT-TYPE-CODE                             
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AT.CODE_ACCT_STAT                                         
MFA-TR*              ,AT.REV_MTH_LST_NRML                                       
MFA-TR*              ,AT.BILL_CYCLE                                             
MFA-TR*              ,AT.CODE_ACCT_BILLED                                       
MFA-TR*              ,AT.CUSTOMER_NO                                            
MFA-TR*              ,AT.LOCAL_OFFICE                                           
MFA-TR*              ,AT.PREMISE_NO                                             
MFA-TR*              ,AT.COMPANY_NO                                             
MFA-TR*              ,AT.ACCOUNT_TYPE_CODE                                      
MFA-TR*          INTO :AT-CODE-ACCT-STAT                                        
MFA-TR*              ,:AT-REV-MTH-LST-NRML                                      
MFA-TR*              ,:AT-BILL-CYCLE                                            
MFA-TR*              ,:AT-CODE-ACCT-BILLED                                      
MFA-TR*              ,:AT-CUSTOMER-NO                                           
MFA-TR*              ,:AT-LOCAL-OFFICE                                          
MFA-TR*              ,:AT-PREMISE-NO                                            
MFA-TR*              ,:AT-COMPANY-NO                                            
MFA-TR*              ,:AT-ACCOUNT-TYPE-CODE                                     
MFA-TR*          FROM CSS_ACCOUNT AT                                            
MFA-TR*         WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA290 ABORT **************'        
              DISPLAY '*     7100-SELECT-ACCOUNT-DET          *'        
              DISPLAY '* ACCOUNT NO     : ' AT-ACCOUNT-NO               
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA290 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
I00251*****************************************************************         
I00251*                                                               *         
I00251* 7110-SELECT-REG-PROFILE.                                      *         
I00251*****************************************************************         
I00251 7110-SELECT-REG-PROFILE.                                         
I00251*                                                                 52132201
I00251     EXEC SQL                                                     
I00251         SELECT LR.REG_GROUP_CD                                   
I00251           INTO :LR-REG-GROUP-CD                                  
I00251           FROM CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                  
I00251          WHERE LR.ACCOUNT_NO     = :LR-ACCOUNT-NO                
I00251                                                           
I00251     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     52133001
MFA-TR*        SELECT LR.REG_GROUP_CD                                   52134001
MFA-TR*          INTO :LR-REG-GROUP-CD                                  52134101
MFA-TR*          FROM CSS_REG_PROFILE LR                                52134201
MFA-TR*         WHERE LR.ACCOUNT_NO     = :LR-ACCOUNT-NO                52134301
MFA-TR*          WITH UR                                                52134601
MFA-TR*    END-EXEC                                                     52134701

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00251                                                                  
I00251     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
I00251                                                                  
I00251     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
I00251        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
I00251           SET SEB-REGULATED           TO TRUE                    
I00251           MOVE LR-REG-GROUP-CD        TO WS-CUSTOMER-GROUP       
I00251        END-IF                                                    
I00251     ELSE                                                         
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        DISPLAY '*      7110-SELECT-REG-PROFILE         *'        
I00251        DISPLAY '* ACCOUNT NO     : ' LR-ACCOUNT-NO               
I00251        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
I00251        DISPLAY '*     PROCESSING TERMINATED            *'        
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        PERFORM 9900-ABEND         THRU 9900-EXIT                 
I00251     END-IF.                                                      
I00251                                                                  
I00251 7110-EXIT.                                                       
I00251     EXIT.                                                        
I00251                                                                  
I00251*****************************************************************         
I00251*                                                               *         
I00251* 7120-SELECT-ACCT-RTPK-AGR.                                    *         
I00251*****************************************************************         
I00251 7120-SELECT-ACCT-RTPK-AGR.                                       
I00251*                                                                         
I00251     EXEC SQL                                                     
I00251          SELECT TOP(1) DF.ACCOUNT_NO,
              DF.CODE_UTIL_TYPE,
              DF.IC_NO,
              DF.RT_PKG_OPT_SEQ_NO,
              DF.TRANS_SEQ_ID,
              DF.OFFER_CD,
              DF.OPTION_CD,
              DF.PROMO_CD,
              DF.STATUS_CD,
              DF.COMM_CHANNEL,
              DF.CREATED_USERID,
              DF.LAST_UPDATE_USERID,
              DF.OPT_AGRMT_EFF_DT,
              REPLACE(CONVERT(CHAR(8), DF.OPT_AGRMT_EFF_TM, 108), ':', 
           '.') OPT_AGRMT_EFF_TM,
              REPLACE(REPLACE(CONVERT(CHAR(26), DF.CREATED_TS, 121), 
           ' ', '-'), ':', '.') CREATED_TS,
              REPLACE(REPLACE(CONVERT(CHAR(26), DF.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,
              DF.COMPANY_NO,
              DF.STATUS_EFF_REV_MTH,
              DF.AGREEMNT_SOURCE_CD,
              DF.ADJ_TIER_SEQ_NO,
              DF.OFF_OPT_VRSN_NO,
              DF.AUTO_REN_OPT_IN_FL                            
I00251            INTO :DF-ACCOUNT-NO                                   
I00251                ,:DF-CODE-UTIL-TYPE                               
I00251                ,:DF-IC-NO                                        
I00251                ,:DF-RT-PKG-OPT-SEQ-NO                            
I00251                ,:DF-TRANS-SEQ-ID                                 
I00251                ,:DF-OFFER-CD                                     
I00251                ,:DF-OPTION-CD                                    
I00251                ,:DF-PROMO-CD                                     
I00251                ,:DF-STATUS-CD                                    
I00251                ,:DF-COMM-CHANNEL                                 
I00251                ,:DF-CREATED-USERID                               
I00251                ,:DF-LAST-UPDATE-USERID                           
I00251                ,:DF-OPT-AGRMT-EFF-DT                             
I00251                ,:DF-OPT-AGRMT-EFF-TM                             
I00251                ,:DF-CREATED-TS                                   
I00251                ,:DF-LAST-UPDATE-TS                               
I00251                ,:DF-COMPANY-NO                                   
I00251                ,:DF-STATUS-EFF-REV-MTH                           
I00251                ,:DF-AGREEMNT-SOURCE-CD                           
I00251                ,:DF-ADJ-TIER-SEQ-NO                              
P00892                ,:DF-OFF-OPT-VRSN-NO                              
P00892                ,:DF-AUTO-REN-OPT-IN-FL                           
I00251            FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)               
I00251                ,CSS_UTIL_ENVRNMT  UT WITH(READUNCOMMITTED)               
I00251           WHERE DF.ACCOUNT_NO        = :DF-ACCOUNT-NO            
I00251             AND DF.ACCOUNT_NO        = UT.ACCOUNT_NO             
I00251             AND DF.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE         
I00251             AND DF.IC_NO             = UT.IC_NO                  
I00251             AND DF.RT_PKG_OPT_SEQ_NO = UT.RT_PKG_OPT_SEQ_NO      
I00251                                       
I00251     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT DF.ACCOUNT_NO                                            
MFA-TR*               ,DF.CODE_UTIL_TYPE                                        
MFA-TR*               ,DF.IC_NO                                                 
MFA-TR*               ,DF.RT_PKG_OPT_SEQ_NO                                     
MFA-TR*               ,DF.TRANS_SEQ_ID                                          
MFA-TR*               ,DF.OFFER_CD                                              
MFA-TR*               ,DF.OPTION_CD                                             
MFA-TR*               ,DF.PROMO_CD                                              
MFA-TR*               ,DF.STATUS_CD                                             
MFA-TR*               ,DF.COMM_CHANNEL                                          
MFA-TR*               ,DF.CREATED_USERID                                        
MFA-TR*               ,DF.LAST_UPDATE_USERID                                    
MFA-TR*               ,DF.OPT_AGRMT_EFF_DT                                      
MFA-TR*               ,DF.OPT_AGRMT_EFF_TM                                      
MFA-TR*               ,DF.CREATED_TS                                            
MFA-TR*               ,DF.LAST_UPDATE_TS                                        
MFA-TR*               ,DF.COMPANY_NO                                            
MFA-TR*               ,DF.STATUS_EFF_REV_MTH                                    
MFA-TR*               ,DF.AGREEMNT_SOURCE_CD                                    
MFA-TR*               ,DF.ADJ_TIER_SEQ_NO                                       
MFA-TR*               ,DF.OFF_OPT_VRSN_NO                                       
MFA-TR*               ,DF.AUTO_REN_OPT_IN_FL                                    
MFA-TR*           INTO :DF-ACCOUNT-NO                                           
MFA-TR*               ,:DF-CODE-UTIL-TYPE                                       
MFA-TR*               ,:DF-IC-NO                                                
MFA-TR*               ,:DF-RT-PKG-OPT-SEQ-NO                                    
MFA-TR*               ,:DF-TRANS-SEQ-ID                                         
MFA-TR*               ,:DF-OFFER-CD                                             
MFA-TR*               ,:DF-OPTION-CD                                            
MFA-TR*               ,:DF-PROMO-CD                                             
MFA-TR*               ,:DF-STATUS-CD                                            
MFA-TR*               ,:DF-COMM-CHANNEL                                         
MFA-TR*               ,:DF-CREATED-USERID                                       
MFA-TR*               ,:DF-LAST-UPDATE-USERID                                   
MFA-TR*               ,:DF-OPT-AGRMT-EFF-DT                                     
MFA-TR*               ,:DF-OPT-AGRMT-EFF-TM                                     
MFA-TR*               ,:DF-CREATED-TS                                           
MFA-TR*               ,:DF-LAST-UPDATE-TS                                       
MFA-TR*               ,:DF-COMPANY-NO                                           
MFA-TR*               ,:DF-STATUS-EFF-REV-MTH                                   
MFA-TR*               ,:DF-AGREEMNT-SOURCE-CD                                   
MFA-TR*               ,:DF-ADJ-TIER-SEQ-NO                                      
MFA-TR*               ,:DF-OFF-OPT-VRSN-NO                                      
MFA-TR*               ,:DF-AUTO-REN-OPT-IN-FL                                   
MFA-TR*           FROM CSS_ACCT_RTPK_AGR DF                                     
MFA-TR*               ,CSS_UTIL_ENVRNMT  UT                                     
MFA-TR*          WHERE DF.ACCOUNT_NO        = :DF-ACCOUNT-NO                    
MFA-TR*            AND DF.ACCOUNT_NO        = UT.ACCOUNT_NO                     
MFA-TR*            AND DF.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE                 
MFA-TR*            AND DF.IC_NO             = UT.IC_NO                          
MFA-TR*            AND DF.RT_PKG_OPT_SEQ_NO = UT.RT_PKG_OPT_SEQ_NO              
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00251                                                                  
I00251     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
I00251     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
I00251        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
I00251           SET EXISTS-IN-RTPK-AGR TO TRUE                         
I00251        END-IF                                                    
I00251     ELSE                                                         
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        DISPLAY '*     7120-SELECT-ACCT-RTPK-AGR        *'        
I00251        DISPLAY '* ACCOUNT NO     : ' DF-ACCOUNT-NO               
I00251        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
I00251        DISPLAY '*     PROCESSING TERMINATED            *'        
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        PERFORM 9900-ABEND        THRU 9900-EXIT                  
I00251     END-IF.                                                      
I00251                                                                  
I00251 7120-EXIT.                                                       
I00251     EXIT.                                                        
I00251                                                                  
I00251*****************************************************************         
I00251*                                                               *         
I00251* 7130-GET-RATE-CALC-TYP-CD.                                    *         
I00251*****************************************************************         
I00251 7130-GET-RATE-CALC-TYP-CD.                                       
I00251*                                                                 52132201
I00251     EXEC SQL                                                     
I00251         SELECT TOP(1) 'Y'                                               
I00251           INTO :WS-FIXED-RATE                                    
I00251           FROM CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)               
I00251               ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)               
I00251          WHERE SF.FACTOR_ID          =  HQ.FACTOR_ID             
I00251            AND HQ.COMPANY_NO         = :HQ-COMPANY-NO            
I00251            AND HQ.OPTION_CD          = :HQ-OPTION-CD             
I00251            AND HQ.ATTR_INCTV_STRT_DT <= IIF(TRY_CONVERT(DATE, 
                                                           :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) )             
I00251            AND HQ.ATTR_INCTV_END_DT  >= IIF(TRY_CONVERT(DATE, 
                                                           :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) )             
P00473            AND CAST(HQ.OPT_ATTR_VSTART_TS AS DATE) <= 
              IIF(TRY_CONVERT(DATE, :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) )       
P00473            AND CAST(HQ.OPT_ATTR_VEND_TS AS DATE)   >= 
              IIF(TRY_CONVERT(DATE, :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) )       
P00473            AND HQ.PROC_STATUS_CD      = 'AC'                     
I00251            AND SF.OVR_RT_CALC_TYP_CD = '02'                      
P00473          ORDER BY HQ.OPT_ATTR_VSTART_TS DESC                     
I00251                                       
I00251     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     52133001
MFA-TR*        SELECT 'Y'                                               52134001
MFA-TR*          INTO :WS-FIXED-RATE                                    52134101
MFA-TR*          FROM CSS_SPCL_FCTR      SF                             52134001
MFA-TR*              ,CRM_OPT_ATTR_INCTV HQ                             52134001
MFA-TR*         WHERE SF.FACTOR_ID          =  HQ.FACTOR_ID             52134001
MFA-TR*           AND HQ.COMPANY_NO         = :HQ-COMPANY-NO            52134001
MFA-TR*           AND HQ.OPTION_CD          = :HQ-OPTION-CD             52134001
MFA-TR*           AND HQ.ATTR_INCTV_STRT_DT <= :WS-RUN-DATE                     
MFA-TR*           AND HQ.ATTR_INCTV_END_DT  >= :WS-RUN-DATE                     
MFA-TR*           AND DATE(HQ.OPT_ATTR_VSTART_TS) <= :WS-RUN-DATE               
MFA-TR*           AND DATE(HQ.OPT_ATTR_VEND_TS)   >= :WS-RUN-DATE               
MFA-TR*           AND HQ.PROC_STATUS_CD      = 'AC'                             
MFA-TR*           AND SF.OVR_RT_CALC_TYP_CD = '02'                      52134001
MFA-TR*         ORDER BY HQ.OPT_ATTR_VSTART_TS DESC                             
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC                                                     52134701

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00251                                                                  
I00251     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
I00251     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
I00251        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
I00251           MOVE '02'   TO SF-OVR-RT-CALC-TYP-CD                   
I00251        ELSE                                                      
I00251           MOVE SPACES TO SF-OVR-RT-CALC-TYP-CD                   
I00251        END-IF                                                    
I00251     ELSE                                                         
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        DISPLAY '*     7120-SELECT-ACCT-RTPK-AGR        *'        
I00251        DISPLAY '* ACCOUNT_NO     : ' WS-ACCOUNT-NO               
I00251        DISPLAY '* OPTION_CD      : ' HQ-OPTION-CD                
I00251        DISPLAY '* COMPANY_NO     : ' HQ-COMPANY-NO               
I00251        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
I00251        DISPLAY '*     PROCESSING TERMINATED            *'        
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        PERFORM 9900-ABEND         THRU 9900-EXIT                 
I00251     END-IF.                                                      
I00251                                                                  
I00251 7130-EXIT.                                                       
I00251     EXIT.                                                        
I00251                                                                  
I00251*****************************************************************         
I00251*                                                               *         
I00251* 7140-CHECK-SEQ-NO.                                            *         
I00251*****************************************************************         
I00251 7140-CHECK-SEQ-NO.                                               
I00251*                                                                 52132201
I00251     EXEC SQL                                                     
I00251         SELECT DF.ADJ_TIER_SEQ_NO                                
I00251               ,DD.ADJ_TIER_SEQ_NO                                
I00251               ,DD.TIER_CUST_STAT_CD                              
I00251               ,DD.TIER_ACCT_TYPE_CD                              
I00251               ,DD.MKT_TIER_RANKING                               
I00251               ,DD.MKT_TIER_START_DT                              
I00251               ,DD.COMPANY_NO                                     
I00251               ,DD.TIER_SOURCE_CD                                 
I00251           INTO :DF-ADJ-TIER-SEQ-NO                               
I00251               ,:DD-ADJ-TIER-SEQ-NO                               
I00251               ,:DD-TIER-CUST-STAT-CD                             
I00251               ,:DD-TIER-ACCT-TYPE-CD                             
I00251               ,:DD-MKT-TIER-RANKING                              
I00251               ,:DD-MKT-TIER-START-DT                             
I00251               ,:DD-COMPANY-NO                                    
I00251               ,:DD-TIER-SOURCE-CD                                
I00251           FROM CSS_ACCT_RTPK_AGR  DF WITH(READUNCOMMITTED)               
I00251               ,CSS_ACCT_MKT_TIER  DD WITH(READUNCOMMITTED)               
I00251               ,CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)               
I00251          WHERE DF.ACCOUNT_NO        = DD.ACCOUNT_NO              
I00251            AND DD.ACCOUNT_NO        = UT.ACCOUNT_NO              
I00251            AND DF.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE          
I00251            AND DF.IC_NO             = UT.IC_NO                   
I00251            AND DF.RT_PKG_OPT_SEQ_NO = UT.RT_PKG_OPT_SEQ_NO       
I00251            AND DF.ACCOUNT_NO        = :DF-ACCOUNT-NO             
I00251            AND DD.EFF_START_DT      =                            
I00251                 (SELECT MAX(A.EFF_START_DT)                      
I00251                  FROM   CSS_ACCT_MKT_TIER A WITH(READUNCOMMITTED)        
I00251                  WHERE  A.ACCOUNT_NO = :DF-ACCOUNT-NO)           
I00251                                                           
I00251     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     52133001
MFA-TR*        SELECT DF.ADJ_TIER_SEQ_NO                                52134001
MFA-TR*              ,DD.ADJ_TIER_SEQ_NO                                        
MFA-TR*              ,DD.TIER_CUST_STAT_CD                                      
MFA-TR*              ,DD.TIER_ACCT_TYPE_CD                                      
MFA-TR*              ,DD.MKT_TIER_RANKING                                       
MFA-TR*              ,DD.MKT_TIER_START_DT                                      
MFA-TR*              ,DD.COMPANY_NO                                             
MFA-TR*              ,DD.TIER_SOURCE_CD                                         
MFA-TR*          INTO :DF-ADJ-TIER-SEQ-NO                               52134101
MFA-TR*              ,:DD-ADJ-TIER-SEQ-NO                               52134101
MFA-TR*              ,:DD-TIER-CUST-STAT-CD                                     
MFA-TR*              ,:DD-TIER-ACCT-TYPE-CD                                     
MFA-TR*              ,:DD-MKT-TIER-RANKING                                      
MFA-TR*              ,:DD-MKT-TIER-START-DT                                     
MFA-TR*              ,:DD-COMPANY-NO                                            
MFA-TR*              ,:DD-TIER-SOURCE-CD                                        
MFA-TR*          FROM CSS_ACCT_RTPK_AGR  DF                             52134201
MFA-TR*              ,CSS_ACCT_MKT_TIER  DD                             52134201
MFA-TR*              ,CSS_UTIL_ENVRNMT   UT                             52134201
MFA-TR*         WHERE DF.ACCOUNT_NO        = DD.ACCOUNT_NO              52134301
MFA-TR*           AND DD.ACCOUNT_NO        = UT.ACCOUNT_NO              52134301
MFA-TR*           AND DF.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE          52134301
MFA-TR*           AND DF.IC_NO             = UT.IC_NO                   52134301
MFA-TR*           AND DF.RT_PKG_OPT_SEQ_NO = UT.RT_PKG_OPT_SEQ_NO       52134301
MFA-TR*           AND DF.ACCOUNT_NO        = :DF-ACCOUNT-NO             52134301
MFA-TR*           AND DD.EFF_START_DT      =                            52134301
MFA-TR*                (SELECT MAX(A.EFF_START_DT)                              
MFA-TR*                 FROM   CSS_ACCT_MKT_TIER A                              
MFA-TR*                 WHERE  A.ACCOUNT_NO = :DF-ACCOUNT-NO)                   
MFA-TR*          WITH UR                                                52134601
MFA-TR*    END-EXEC                                                     52134701

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00251                                                                  
I00251     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
I00251     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
I00251        CONTINUE                                                  
I00251     ELSE                                                         
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        DISPLAY '*        7140-CHECK-SEQ-NO             *'        
I00251        DISPLAY '* ACCOUNT NO     : ' DF-ACCOUNT-NO               
I00251        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
I00251        DISPLAY '*     PROCESSING TERMINATED            *'        
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        PERFORM 9900-ABEND                THRU 9900-EXIT          
I00251     END-IF.                                                      
I00251                                                                  
I00251 7140-EXIT.                                                       
I00251     EXIT.                                                        
I00251*                                                                         
I00251*****************************************************************         
I00251*                                                               *         
I00251* 7150-GET-DURATION-REMAIN.                                     *         
I00251*****************************************************************         
I00251 7150-GET-DURATION-REMAIN.                                        
I00251*                                                                 52132201
I00251     EXEC SQL                                                     
I00251         SELECT TOP(1) FF.DURATION_REMAIN_NO                             
I00251           INTO :FF-DURATION-REMAIN-NO :WS-NULL-IND-03            
I00251           FROM CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)               
I00251               ,CSS_FIXED_FCTR     FF WITH(READUNCOMMITTED)               
I00251          WHERE FF.ACCOUNT_NO         = :FF-ACCOUNT-NO            
I00251            AND FF.CODE_UTIL_TYPE     = :FF-CODE-UTIL-TYPE        
I00251            AND FF.IC_NO              = :FF-IC-NO                 
I00251            AND HQ.OPTION_CD          = :HQ-OPTION-CD             
I00251            AND HQ.COMPANY_NO         = :HQ-COMPANY-NO            
I00251            AND HQ.PRIMRY_OPT_ATTR_FL = 'Y'                       
P00473            AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()        
P00473            AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()        
P00473            AND HQ.PROC_STATUS_CD      = 'AC'                     
I00251            AND FF.FACTOR_ID          = HQ.FACTOR_ID              
I00251            AND FF.RT_PKG_OPT_SEQ_NO  = :FF-RT-PKG-OPT-SEQ-NO     
P00473          ORDER BY HQ.OPT_ATTR_VSTART_TS DESC                     
P00680                  ,FF.EFF_DATE_FROM DESC                          
I00251                                       
I00251     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     52133001
MFA-TR*        SELECT FF.DURATION_REMAIN_NO                             52134001
MFA-TR*          INTO :FF-DURATION-REMAIN-NO :WS-NULL-IND-03            52134101
MFA-TR*          FROM CRM_OPT_ATTR_INCTV HQ                             52134201
MFA-TR*              ,CSS_FIXED_FCTR     FF                             52134201
MFA-TR*         WHERE FF.ACCOUNT_NO         = :FF-ACCOUNT-NO            52134301
MFA-TR*           AND FF.CODE_UTIL_TYPE     = :FF-CODE-UTIL-TYPE        52134301
MFA-TR*           AND FF.IC_NO              = :FF-IC-NO                 52134301
MFA-TR*           AND HQ.OPTION_CD          = :HQ-OPTION-CD             52134301
MFA-TR*           AND HQ.COMPANY_NO         = :HQ-COMPANY-NO            52134301
MFA-TR*           AND HQ.PRIMRY_OPT_ATTR_FL = 'Y'                       52134301
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP                
MFA-TR*           AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP                
MFA-TR*           AND HQ.PROC_STATUS_CD      = 'AC'                             
MFA-TR*           AND FF.FACTOR_ID          = HQ.FACTOR_ID              52134301
MFA-TR*           AND FF.RT_PKG_OPT_SEQ_NO  = :FF-RT-PKG-OPT-SEQ-NO             
MFA-TR*         ORDER BY HQ.OPT_ATTR_VSTART_TS DESC                             
MFA-TR*                 ,FF.EFF_DATE_FROM DESC                                  
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                            52134601
MFA-TR*    END-EXEC                                                     52134701

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00251                                                                  
I00251     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
I00251                                                                  
I00251     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
I00251        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
I00251           IF WS-NULL-IND-03 = -1                                 
I00251              MOVE -1               TO FF-DURATION-REMAIN-NO      
I00251           END-IF                                                 
I00251        ELSE                                                      
I00251              MOVE -1               TO FF-DURATION-REMAIN-NO      
I00251        END-IF                                                    
I00251     ELSE                                                         
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        DISPLAY '*      7150-GET-DURATION-REMAIN        *'        
I00251        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
I00251        DISPLAY '* ACCOUNT NO        : ' FF-ACCOUNT-NO            
I00251        DISPLAY '* CODE UTIL TYPE    : ' FF-CODE-UTIL-TYPE        
I00251        DISPLAY '* IC NO             : ' FF-IC-NO                 
I00251        DISPLAY '* OPTION CD         : ' HQ-OPTION-CD             
I00251        DISPLAY '* COMPANY NO        : ' HQ-COMPANY-NO            
I00251        DISPLAY '* RT-PKG-OPT-SEQ-NO : ' FF-RT-PKG-OPT-SEQ-NO     
I00251        DISPLAY '*     PROCESSING TERMINATED            *'        
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        PERFORM 9900-ABEND                THRU 9900-EXIT          
I00251     END-IF.                                                      
I00251                                                                  
I00251 7150-EXIT.                                                       
I00251     EXIT.                                                        
I00251                                                                  
I00484*                                                                         
I00484*****************************************************************         
I00484*                                                               *         
I00484* 7155-GET-ACCT-FCTR-DURA-REMAIN.                               *         
I00484*****************************************************************         
I00484 7155-GET-ACCT-FCTR-DURA-REMAIN.                                  
I00484*                                                                 52132201
I00484     EXEC SQL                                                     
I00484        SELECT TOP(1) FF.DURATION_REMAIN_NO                              
I00484          INTO :FF-DURATION-REMAIN-NO :WS-NULL-IND-04              
I00484          FROM CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)                
I00484              ,CSS_FIXED_FCTR     FF WITH(READUNCOMMITTED)                
I00484         WHERE FF.ACCOUNT_NO           = :FF-ACCOUNT-NO           
I00484           AND FF.CODE_UTIL_TYPE       = :FF-CODE-UTIL-TYPE       
I00484           AND FF.IC_NO                = :FF-IC-NO                
I00484           AND HQ.OPTION_CD            = :HQ-OPTION-CD            
I00484           AND HQ.FACTOR_ID            = FF.FACTOR_ID             
I00484           AND HQ.PRIMRY_OPT_ATTR_FL   = 'Y'                      
I00484           AND HQ.RT_ATTR_INCTV_TYPE   = 'FIXED PRICE'            
I00484           AND HQ.ATTR_INCTV_STRT_DT   <= 
           CAST(SYSDATETIMEOFFSET() AS DATE)            
I00484           AND HQ.ATTR_INCTV_END_DT    >= 
           CAST(SYSDATETIMEOFFSET() AS DATE)            
P00473           AND HQ.OPT_ATTR_VSTART_TS   <= CIS.CURRENT$TIMESTAMP()       
P00473           AND HQ.OPT_ATTR_VEND_TS     >= CIS.CURRENT$TIMESTAMP()       
P00473           AND HQ.PROC_STATUS_CD       = 'AC'                     
I00484           AND FF.RT_PKG_OPT_SEQ_NO    = :FF-RT-PKG-OPT-SEQ-NO    
P00473         ORDER BY HQ.OPT_ATTR_VSTART_TS DESC                      
P00680                 ,FF.EFF_DATE_FROM DESC                           
I00484                                       
I00484     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     52133001
MFA-TR*       SELECT FF.DURATION_REMAIN_NO                                      
MFA-TR*         INTO :FF-DURATION-REMAIN-NO:WS-NULL-IND-04                      
MFA-TR*         FROM CRM_OPT_ATTR_INCTV HQ                                      
MFA-TR*             ,CSS_FIXED_FCTR     FF                                      
MFA-TR*        WHERE FF.ACCOUNT_NO           = :FF-ACCOUNT-NO                   
MFA-TR*          AND FF.CODE_UTIL_TYPE       = :FF-CODE-UTIL-TYPE               
MFA-TR*          AND FF.IC_NO                = :FF-IC-NO                        
MFA-TR*          AND HQ.OPTION_CD            = :HQ-OPTION-CD                    
MFA-TR*          AND HQ.FACTOR_ID            = FF.FACTOR_ID                     
MFA-TR*          AND HQ.PRIMRY_OPT_ATTR_FL   = 'Y'                              
MFA-TR*          AND HQ.RT_ATTR_INCTV_TYPE   = 'FIXED PRICE'                    
MFA-TR*          AND HQ.ATTR_INCTV_STRT_DT   <= CURRENT DATE                    
MFA-TR*          AND HQ.ATTR_INCTV_END_DT    >= CURRENT DATE                    
MFA-TR*          AND HQ.OPT_ATTR_VSTART_TS   <= CURRENT TIMESTAMP               
MFA-TR*          AND HQ.OPT_ATTR_VEND_TS     >= CURRENT TIMESTAMP               
MFA-TR*          AND HQ.PROC_STATUS_CD       = 'AC'                             
MFA-TR*          AND FF.RT_PKG_OPT_SEQ_NO    = :FF-RT-PKG-OPT-SEQ-NO            
MFA-TR*        ORDER BY HQ.OPT_ATTR_VSTART_TS DESC                              
MFA-TR*                ,FF.EFF_DATE_FROM DESC                                   
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*    END-EXEC                                                     52134701

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00484                                                                  
I00484     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
I00484                                                                  
I00484     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
I00484        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
I00484           IF WS-NULL-IND-04 = -1                                 
I00484              MOVE -1               TO FF-DURATION-REMAIN-NO      
I00484           END-IF                                                 
I00484        ELSE                                                      
I00484              MOVE -1               TO FF-DURATION-REMAIN-NO      
I00484        END-IF                                                    
I00484     ELSE                                                         
I00484        DISPLAY '********** PCSCA290 ABORT **************'        
I00484        DISPLAY '*  7155-GET-ACCT-FCTR-DURA-REMAIN      *'        
I00484        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
I00484        DISPLAY '* ACCOUNT NO        : ' FF-ACCOUNT-NO            
I00484        DISPLAY '* CODE UTIL TYPE    : ' FF-CODE-UTIL-TYPE        
I00484        DISPLAY '* IC NO             : ' FF-IC-NO                 
I00484        DISPLAY '* OPTION CD         : ' HQ-OPTION-CD             
I00484        DISPLAY '*     PROCESSING TERMINATED            *'        
I00484        DISPLAY '********** PCSCA290 ABORT **************'        
I00484        PERFORM 9900-ABEND                THRU 9900-EXIT          
I00484     END-IF.                                                      
I00484                                                                  
I00484 7155-EXIT.                                                       
I00484     EXIT.                                                        
I00484                                                                  
I00251*****************************************************************         
I00251*                                                               *         
I00251* 7160-GET-ADJ-SOURCE-CD.                                       *         
I00251*****************************************************************         
I00251 7160-GET-ADJ-SOURCE-CD.                                          
I00251*                                                                 52132201
I00251     EXEC SQL                                                     
I00251         SELECT [1B].ADJ_SOURCE_CD                                  
I00251           INTO :1B-ADJ-SOURCE-CD                                 
I00251           FROM CRM_MKT_TIER_ADJ [1B] WITH(READUNCOMMITTED)               
I00251          WHERE [1B].TIER_CUST_STAT_CD = :1B-TIER-CUST-STAT-CD      
I00251            AND [1B].TIER_ACCT_TYPE_CD = :1B-TIER-ACCT-TYPE-CD      
I00251            AND [1B].ADJ_TIER_RANKING  = :1B-MKT-TIER-RANKING       
I00251            AND [1B].ADJ_TIER_START_DT = IIF(TRY_CONVERT(DATE, 
                                                  :1B-MKT-TIER-START-DT
              ) IS NULL OR (PATINDEX('%.%', :1B-MKT-TIER-START-DT
              ) <> 0) OR (LEN(:1B-MKT-TIER-START-DT
              ) <> 10), CIS.CHAR2DATE(:1B-MKT-TIER-START-DT
              ), CONVERT(DATE, :1B-MKT-TIER-START-DT) )      
I00251            AND [1B].ADJ_TIER_SEQ_NO   = :1B-ADJ-TIER-SEQ-NO        
I00251            AND [1B].COMPANY_NO        = :1B-COMPANY-NO             
I00251                                                           
I00251     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     52133001
MFA-TR*        SELECT 1B.ADJ_SOURCE_CD                                  52134001
MFA-TR*          INTO :1B-ADJ-SOURCE-CD                                 52134101
MFA-TR*          FROM CRM_MKT_TIER_ADJ 1B                               52134201
MFA-TR*         WHERE 1B.TIER_CUST_STAT_CD = :1B-TIER-CUST-STAT-CD      52134301
MFA-TR*           AND 1B.TIER_ACCT_TYPE_CD = :1B-TIER-ACCT-TYPE-CD      52134301
MFA-TR*           AND 1B.ADJ_TIER_RANKING  = :1B-MKT-TIER-RANKING       52134301
MFA-TR*           AND 1B.ADJ_TIER_START_DT = :1B-MKT-TIER-START-DT      52134301
MFA-TR*           AND 1B.ADJ_TIER_SEQ_NO   = :1B-ADJ-TIER-SEQ-NO        52134301
MFA-TR*           AND 1B.COMPANY_NO        = :1B-COMPANY-NO             52134301
MFA-TR*          WITH UR                                                52134601
MFA-TR*    END-EXEC                                                     52134701

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00251                                                                  
I00251     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
I00251     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
I00251        CONTINUE                                                  
I00251     ELSE                                                         
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        DISPLAY '*      7160-GET-ADJ-SOURCE-CD          *'        
I00251        DISPLAY '* ACCOUNT NO        : ' WS-ACCOUNT-NO            
I00251        DISPLAY '* TIER CUST STAT CD : ' 1B-TIER-CUST-STAT-CD     
I00251        DISPLAY '* TIER ACCT TYPE CD : ' 1B-TIER-ACCT-TYPE-CD     
I00251        DISPLAY '* ADJ TIER RANKING  : ' 1B-MKT-TIER-RANKING      
I00251        DISPLAY '* ADJ TIER START DT : ' 1B-MKT-TIER-START-DT     
I00251        DISPLAY '* ADJ TIER SEQ NO   : ' 1B-ADJ-TIER-SEQ-NO       
I00251        DISPLAY '* COMPANY NO        : ' 1B-COMPANY-NO            
I00251        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
I00251        DISPLAY '*     PROCESSING TERMINATED            *'        
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        PERFORM 9900-ABEND                THRU 9900-EXIT          
I00251     END-IF.                                                      
I00251                                                                  
I00251 7160-EXIT.                                                       
I00251     EXIT.                                                        
I00251*                                                                 52137001
I00251******************************************************************        
I00251*                                                                *        
I00251* 7170-CHECK-SCANA-SR                                            *        
I00251******************************************************************        
I00251 7170-CHECK-SCANA-SR.                                             
I00251*                                                                 52132201
I00251     EXEC SQL                                                     
I00251         SELECT TOP(1) IG.CUST_ACCT_DEFLT_FL                             
I00251           INTO :IG-CUST-ACCT-DEFLT-FL                            
I00251           FROM CRM_MKT_TIER IG WITH(READUNCOMMITTED)                     
I00251               ,CSS_ACCT_MKT_TIER DD WITH(READUNCOMMITTED)                
I00251          WHERE DD.ACCOUNT_NO        = :DD-ACCOUNT-NO             
I00251            AND DD.TIER_CUST_STAT_CD = IG.TIER_CUST_STAT_CD       
I00251            AND DD.TIER_ACCT_TYPE_CD = IG.TIER_ACCT_TYPE_CD       
I00251            AND DD.MKT_TIER_RANKING  = IG.MKT_TIER_RANKING        
I00251            AND DD.MKT_TIER_START_DT = IG.MKT_TIER_START_DT       
I00251            AND DD.COMPANY_NO        = IG.COMPANY_NO              
I00251          ORDER BY DD.EFF_START_DT DESC                           
I00251                                              
I00251                                                           
I00251     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     52133001
MFA-TR*        SELECT IG.CUST_ACCT_DEFLT_FL                                     
MFA-TR*          INTO :IG-CUST-ACCT-DEFLT-FL                                    
MFA-TR*          FROM CRM_MKT_TIER IG                                           
MFA-TR*              ,CSS_ACCT_MKT_TIER DD                                      
MFA-TR*         WHERE DD.ACCOUNT_NO        = :DD-ACCOUNT-NO                     
MFA-TR*           AND DD.TIER_CUST_STAT_CD = IG.TIER_CUST_STAT_CD               
MFA-TR*           AND DD.TIER_ACCT_TYPE_CD = IG.TIER_ACCT_TYPE_CD               
MFA-TR*           AND DD.MKT_TIER_RANKING  = IG.MKT_TIER_RANKING                
MFA-TR*           AND DD.MKT_TIER_START_DT = IG.MKT_TIER_START_DT               
MFA-TR*           AND DD.COMPANY_NO        = IG.COMPANY_NO                      
MFA-TR*         ORDER BY DD.EFF_START_DT DESC                                   
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC                                                     52134701

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00251                                                                  
I00251     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
I00251     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
I00251        CONTINUE                                                  
I00251     ELSE                                                         
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        DISPLAY '*       7170-CHECK-SCANA-SR            *'        
I00251        DISPLAY '* ACCOUNT NO     : ' DD-ACCOUNT-NO               
I00251        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
I00251        DISPLAY '*     PROCESSING TERMINATED            *'        
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        PERFORM 9900-ABEND                THRU 9900-EXIT          
I00251     END-IF.                                                      
I00251                                                                  
I00251 7170-EXIT.                                                       
I00251     EXIT.                                                        
I00251*                                                                 52137001
I00251*****************************************************************         
I00251*                                                               *         
I00251* 7180-SELECT-RATE-PLAN.                                        *         
I00251*****************************************************************         
I00251 7180-SELECT-RATE-PLAN.                                           
I00251                                                                  
I00251     EXEC SQL                                                     
I00251         SELECT TOP(1) FI.RATE_PLAN_NO                                   
I00251           INTO :FI-RATE-PLAN-NO                                  
I00251           FROM CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                
I00251          WHERE FI.OPTION_CD  = :FI-OPTION-CD                     
I00251            AND FI.COMPANY_NO = :FI-COMPANY-NO                    
P00473            AND FI.OPT_VSTART_TS  <= CIS.CURRENT$TIMESTAMP()            
P00473            AND FI.OPT_VEND_TS    >= CIS.CURRENT$TIMESTAMP()            
P00473            AND FI.PROC_STATUS_CD  = 'AC'                         
P00473          ORDER BY FI.OPT_VSTART_TS DESC                          
P00473                                       
I00251     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     52133001
MFA-TR*        SELECT FI.RATE_PLAN_NO                                   52134001
MFA-TR*          INTO :FI-RATE-PLAN-NO                                  52134101
MFA-TR*          FROM CRM_RT_PKG_OPTION FI                              52134201
MFA-TR*         WHERE FI.OPTION_CD  = :FI-OPTION-CD                     52134301
MFA-TR*           AND FI.COMPANY_NO = :FI-COMPANY-NO                    52134601
MFA-TR*           AND FI.OPT_VSTART_TS  <= CURRENT TIMESTAMP                    
MFA-TR*           AND FI.OPT_VEND_TS    >= CURRENT TIMESTAMP                    
MFA-TR*           AND FI.PROC_STATUS_CD  = 'AC'                                 
MFA-TR*         ORDER BY FI.OPT_VSTART_TS DESC                                  
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC                                                     52134701

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00251                                                                  
I00251     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
I00251     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
I00251        CONTINUE                                                  
I00251     ELSE                                                         
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        DISPLAY '*     7120-SELECT-ACCT-RTPK-AGR        *'        
I00251        DISPLAY '* ACCOUNT NO     : ' WS-ACCOUNT-NO               
I00251        DISPLAY '* OPTION_CD      : ' FI-OPTION-CD                
I00251        DISPLAY '* COMPANY_NO     : ' FI-COMPANY-NO               
I00251        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
I00251        DISPLAY '*     PROCESSING TERMINATED            *'        
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        PERFORM 9900-ABEND         THRU 9900-EXIT                 
I00251     END-IF.                                                      
I00251                                                                  
I00251 7180-EXIT.                                                       
I00251     EXIT.                                                        
I00251                                                                  
I00251*****************************************************************         
I00251*                                                               *         
I00251* 7190-GET-CURR-TIMESTAMP.                                      *         
I00251*****************************************************************         
I00251 7190-GET-CURR-TIMESTAMP.                                         
I00251*                                                                         
I00251     EXEC SQL                                                     
I00251         SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :MH-TRANS-HIST-SEQ-NO                    
I00251     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :MH-TRANS-HIST-SEQ-NO  =                                     
MFA-TR*                            CURRENT TIMESTAMP                            
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00251                                                                  
I00251     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
I00251     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
I00251        CONTINUE                                                  
I00251     ELSE                                                         
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        DISPLAY '*      7190-GET-CURR-TIMESTAMP         *'        
I00251        DISPLAY '* ACCOUNT NO     : ' WS-ACCOUNT-NO               
I00251        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
I00251        DISPLAY '*     PROCESSING TERMINATED            *'        
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        PERFORM 9900-ABEND        THRU 9900-EXIT                  
I00251     END-IF.                                                      
I00251                                                                  
I00251 7190-EXIT.                                                       
I00251     EXIT.                                                        
I00251                                                                  
I00251*****************************************************************         
I00251*                                                               *         
I00251* 7200-GET-OPTION-DESC.                                         *         
I00251*****************************************************************         
I00251 7200-GET-OPTION-DESC.                                            
I00251*                                                                 52132201
I00251     EXEC SQL                                                     
I00251         SELECT TOP(1) FI.OPT_DESC_INT                                   
I00251           INTO :FI-OPT-DESC-INT                                  
I00251           FROM CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                
I00251          WHERE FI.OPTION_CD   = :FI-OPTION-CD                    
I00251            AND FI.COMPANY_NO  = :FI-COMPANY-NO                   
P00473            AND FI.OPT_VSTART_TS <= CIS.CURRENT$TIMESTAMP()             
P00473            AND FI.OPT_VEND_TS   >= CIS.CURRENT$TIMESTAMP()             
P00473            AND FI.PROC_STATUS_CD = 'AC'                          
P00473          ORDER BY FI.OPT_VSTART_TS DESC                          
P00473                                       
I00251     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     52133001
MFA-TR*        SELECT FI.OPT_DESC_INT                                   52134001
MFA-TR*          INTO :FI-OPT-DESC-INT                                  52134101
MFA-TR*          FROM CRM_RT_PKG_OPTION FI                              52134201
MFA-TR*         WHERE FI.OPTION_CD   = :FI-OPTION-CD                    52134301
MFA-TR*           AND FI.COMPANY_NO  = :FI-COMPANY-NO                   52134301
MFA-TR*           AND FI.OPT_VSTART_TS <= CURRENT TIMESTAMP                     
MFA-TR*           AND FI.OPT_VEND_TS   >= CURRENT TIMESTAMP                     
MFA-TR*           AND FI.PROC_STATUS_CD = 'AC'                                  
MFA-TR*         ORDER BY FI.OPT_VSTART_TS DESC                                  
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                            52134601
MFA-TR*    END-EXEC                                                     52134701

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00251                                                                  
I00251     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
I00251     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
I00251        CONTINUE                                                  
I00251     ELSE                                                         
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        DISPLAY '*      7200-GET-OPTION-DESC            *'        
I00251        DISPLAY '* ACCOUNT NO     : ' WS-ACCOUNT-NO               
I00251        DISPLAY '* OPTION_CD      : ' FI-OPTION-CD                
I00251        DISPLAY '* COMPANY_NO     : ' FI-COMPANY-NO               
I00251        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
I00251        DISPLAY '*     PROCESSING TERMINATED            *'        
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        PERFORM 9900-ABEND                THRU 9900-EXIT          
I00251     END-IF.                                                      
I00251                                                                  
I00251 7200-EXIT.                                                       
I00251     EXIT.                                                        
I00251                                                                  
P00211                                                                  
P00211*****************************************************************         
P00211*                                                               *         
P00211* 7210-CHECK-PEND-OPTION.                                       *         
P00211*****************************************************************         
P00211 7210-CHECK-PEND-OPTION.                                          
P00211*                                                                 52132201
P00211     EXEC SQL                                                     
P00211         SELECT DF.STATUS_EFF_REV_MTH                             
P00211               ,DF.RT_PKG_OPT_SEQ_NO                              
P00211               ,DF.OPTION_CD                                      
P00211           INTO :DF-STATUS-EFF-REV-MTH                            
P00211               ,:DF-RT-PKG-OPT-SEQ-NO                             
P00211               ,:DF-OPTION-CD                                     
P00211           FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                
P00211          WHERE DF.ACCOUNT_NO        = :DF-ACCOUNT-NO             
P00211            AND DF.CODE_UTIL_TYPE    = :DF-CODE-UTIL-TYPE         
P00211            AND DF.IC_NO             = :DF-IC-NO                  
P00211            AND DF.STATUS_CD         = :DF-STATUS-CD              
P00211                                                           
P00211     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     52133001
MFA-TR*        SELECT DF.STATUS_EFF_REV_MTH                             52134001
MFA-TR*              ,DF.RT_PKG_OPT_SEQ_NO                                      
MFA-TR*              ,DF.OPTION_CD                                              
MFA-TR*          INTO :DF-STATUS-EFF-REV-MTH                            52134101
MFA-TR*              ,:DF-RT-PKG-OPT-SEQ-NO                                     
MFA-TR*              ,:DF-OPTION-CD                                             
MFA-TR*          FROM CSS_ACCT_RTPK_AGR DF                              52134201
MFA-TR*         WHERE DF.ACCOUNT_NO        = :DF-ACCOUNT-NO             52134801
MFA-TR*           AND DF.CODE_UTIL_TYPE    = :DF-CODE-UTIL-TYPE         52134801
MFA-TR*           AND DF.IC_NO             = :DF-IC-NO                  52134801
MFA-TR*           AND DF.STATUS_CD         = :DF-STATUS-CD              52134801
MFA-TR*          WITH UR                                                52134601
MFA-TR*    END-EXEC.                                                    52134701

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00211                                                                  
P00211     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
P00211     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00211        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
P00211           SET PEND-OPTION-EXIST    TO TRUE                       
P00211        END-IF                                                    
P00211     ELSE                                                         
P00211        DISPLAY '********** PCSCA290 ABORT **************'        
P00211        DISPLAY '*     7210-CHECK-PEND-OPTION           *'        
P00211        DISPLAY '* ACCOUNT NO     : ' DF-ACCOUNT-NO               
P00211        DISPLAY '* CODE_UTIL_TYPE : ' DF-CODE-UTIL-TYPE           
P00211        DISPLAY '* IC_NO          : ' DF-IC-NO                    
P00211        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
P00211        DISPLAY '*     PROCESSING TERMINATED            *'        
P00211        DISPLAY '********** PCSCA290 ABORT **************'        
P00211        PERFORM 9900-ABEND                THRU 9900-EXIT          
P00211     END-IF.                                                      
P00211                                                                  
P00211 7210-EXIT.                                                       
P00211     EXIT.                                                        
P00211                                                                  
P00892*****************************************************************         
P00892*                                                               *         
P00892* 7250-GET-DURATION-NO.                                         *         
P00892*****************************************************************         
P00892 7250-GET-DURATION-NO.                                            
P00892*                                                                 52132201
P00892      EXEC SQL                                                    
P00892        SELECT TOP(1) HQ.DURATION_NO                                     
P00892          INTO :HQ-DURATION-NO                                    
P00892          FROM CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)                
P00892         WHERE HQ.FACTOR_ID          = :HQ-FACTOR-ID              
P00892           AND HQ.OPTION_CD          = :HQ-OPTION-CD              
P00892           AND HQ.ATTR_INCTV_STRT_DT <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
P00892           AND HQ.ATTR_INCTV_END_DT  >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
P00892           AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()         
P00892           AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()         
P00892           AND HQ.PROC_STATUS_CD      = 'AC'                      
P00892         ORDER BY HQ.ATTR_INCTV_STRT_DT                           
P00892                                              
P00892                                                           
P00892     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*     EXEC SQL                                                            
MFA-TR*       SELECT HQ.DURATION_NO                                             
MFA-TR*         INTO :HQ-DURATION-NO                                            
MFA-TR*         FROM CRM_OPT_ATTR_INCTV HQ                                      
MFA-TR*        WHERE HQ.FACTOR_ID          = :HQ-FACTOR-ID                      
MFA-TR*          AND HQ.OPTION_CD          = :HQ-OPTION-CD                      
MFA-TR*          AND HQ.ATTR_INCTV_STRT_DT <= CURRENT DATE                      
MFA-TR*          AND HQ.ATTR_INCTV_END_DT  >= CURRENT DATE                      
MFA-TR*          AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP                 
MFA-TR*          AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP                 
MFA-TR*          AND HQ.PROC_STATUS_CD      = 'AC'                              
MFA-TR*        ORDER BY HQ.ATTR_INCTV_STRT_DT                                   
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00892                                                                  
P00892     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
P00892                                                                  
P00892     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00892        CONTINUE                                                  
P00892     ELSE                                                         
P00892        DISPLAY '********** PCSCA290 ABORT **************'        
P00892        DISPLAY '*      7250-GET-DURATION-NO            *'        
P00892        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
P00892        DISPLAY '* HQ-OPTION-CD      : ' HQ-OPTION-CD             
P00892        DISPLAY '* HQ-FACTOR-ID      : ' HQ-FACTOR-ID             
P00892        DISPLAY '*     PROCESSING TERMINATED            *'        
P00892        DISPLAY '********** PCSCA290 ABORT **************'        
P00892        PERFORM 9900-ABEND                THRU 9900-EXIT          
P00892     END-IF.                                                      
P00892                                                                  
P00892 7250-EXIT.                                                       
P00892     EXIT.                                                        
P00892                                                                  
P00892*                                                                         
P00892*****************************************************************         
P00892*                                                               *         
P00892* 7255-CHK-AUTO-RENEWAL-FL.                                     *         
P00892*****************************************************************         
P00892 7255-CHK-AUTO-RENEWAL-FL.                                        
P00892*                                                                 52132201
P00892      EXEC SQL                                                    
P00892        SELECT FI.AUTO_RENEWAL_FL                                 
P00892          INTO :FI-AUTO-RENEWAL-FL                                
P00892          FROM CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                 
P00892         WHERE FI.OPTION_CD         = :FI-OPTION-CD               
P00892           AND FI.OPT_VSTART_TS    <= CIS.CURRENT$TIMESTAMP()           
P00892           AND FI.OPT_VEND_TS      >= CIS.CURRENT$TIMESTAMP()           
P00892           AND FI.PROC_STATUS_CD    = 'AC'                        
P00892                                                           
P00892     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*     EXEC SQL                                                            
MFA-TR*       SELECT FI.AUTO_RENEWAL_FL                                         
MFA-TR*         INTO :FI-AUTO-RENEWAL-FL                                        
MFA-TR*         FROM CRM_RT_PKG_OPTION FI                                       
MFA-TR*        WHERE FI.OPTION_CD         = :FI-OPTION-CD                       
MFA-TR*          AND FI.OPT_VSTART_TS    <= CURRENT TIMESTAMP                   
MFA-TR*          AND FI.OPT_VEND_TS      >= CURRENT TIMESTAMP                   
MFA-TR*          AND FI.PROC_STATUS_CD    = 'AC'                                
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00892                                                                  
P00892     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
P00892                                                                  
P00892     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00892        CONTINUE                                                  
P00892     ELSE                                                         
P00892        DISPLAY '********** PCSCA290 ABORT **************'        
P00892        DISPLAY '*      7255-CHK-AUTO-RENEWAL-FL        *'        
P00892        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
P00892        DISPLAY '* COMPANY NO        : ' FI-COMPANY-NO            
P00892        DISPLAY '* OPTION CODE       : ' FI-OPTION-CD             
P00892        DISPLAY '* OFF OPT VRSN NO   : ' FI-OPT-VRSN-NO           
P00892        DISPLAY '*     PROCESSING TERMINATED            *'        
P00892        DISPLAY '********** PCSCA290 ABORT **************'        
P00892        PERFORM 9900-ABEND                THRU 9900-EXIT          
P00892     END-IF.                                                      
P00892                                                                  
P00892 7255-EXIT.                                                       
P00892     EXIT.                                                        
P00892                                                                  
P00892*                                                                         
A00388*****************************************************************         
A00388** OPEN SEABLK_CURSOR                                          **         
A00388*****************************************************************         
A00388*                                                                         
A00388 7300-OPEN-SEABLK-CURSOR.                                         
A00388*                                                                 52132201
A00388     EXEC SQL                                                     
A00388         OPEN  SEABLK_CURSOR                                      
A00388     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00388                                                                  
A00388     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
A00388                                                                  
A00388     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A00388        CONTINUE                                                  
A00388     ELSE                                                         
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        DISPLAY '*  7300-OPEN-SEABLK-CURSOR             *'        
A00388        DISPLAY '* ACCOUNT NO        : ' FF-ACCOUNT-NO            
A00388        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
A00388        DISPLAY '*     PROCESSING TERMINATED            *'        
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        PERFORM 9900-ABEND                THRU 9900-EXIT          
A00388     END-IF.                                                      
A00388*                                                                 52136701
A00388 7300-EXIT.                                                       
A00388     EXIT.                                                        
A00388*                                                                         
A00388*****************************************************************         
A00388** FETCH SEABLK_CURSOR                                         **         
A00388*****************************************************************         
A00388*                                                                         
A00388 7310-FETCH-SEABLK-CURSOR.                                        
A00388*                                                                 52132201
A00388     EXEC SQL                                                     
A00388        FETCH  SEABLK_CURSOR                                      
A00388         INTO  :FF-IC-NO                                          
A00388              ,:FF-FACTOR-ID                                      
A00388              ,:FF-FAC-CHRG-BASE-AM                               
A00388              ,:FF-FIXED-FCTR-SEQ-NO                              
A00388     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00388                                                                  
A00388     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
A00388                                                                  
A00388     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A00388        CONTINUE                                                  
A00388     ELSE                                                         
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        DISPLAY '*  7310-FETCH-SEABLK-CURSOR            *'        
A00388        DISPLAY '* ACCOUNT NO        : ' FF-ACCOUNT-NO            
A00388        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
A00388        DISPLAY '*     PROCESSING TERMINATED            *'        
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        PERFORM 9900-ABEND                THRU 9900-EXIT          
A00388     END-IF.                                                      
A00388*                                                                 52136701
A00388 7310-EXIT.                                                       
A00388     EXIT.                                                        
A00388*                                                                         
A00388*****************************************************************         
A00388** CLOSE SEABLK_CURSOR                                         **         
A00388*****************************************************************         
A00388*                                                                         
A00388 7320-CLOSE-SEABLK-CURSOR.                                        
A00388*                                                                 52132201
A00388     EXEC SQL                                                     
A00388        CLOSE  SEABLK_CURSOR                                      
A00388     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00388                                                                  
A00388     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
A00388                                                                  
A00388     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A00388        CONTINUE                                                  
A00388     ELSE                                                         
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        DISPLAY '*  7320-CLOSE-SEABLK-CURSOR            *'        
A00388        DISPLAY '* ACCOUNT NO        : ' FF-ACCOUNT-NO            
A00388        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
A00388        DISPLAY '*     PROCESSING TERMINATED            *'        
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        PERFORM 9900-ABEND                THRU 9900-EXIT          
A00388     END-IF.                                                      
A00388*                                                                 52136701
A00388 7320-EXIT.                                                       
A00388     EXIT.                                                        
A00388*                                                                         
A00388*****************************************************************         
A00388** SELECT DATA FROM UT                                         **         
A00388*****************************************************************         
A00388*                                                                         
A00388 7330-SELECT-UTIL-DATA.                                           
A00388*                                                                 52132201
A00388     EXEC SQL                                                     
A00388       SELECT  GAS_BASE_USE                                       
A00388              ,RATE_PLAN_NO                                       
A00388         INTO  :UT-GAS-BASE-USE                                   
A00388              ,:UT-RATE-PLAN-NO                                   
A00388         FROM CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)                 
A00388        WHERE  UT.ACCOUNT_NO      =  :UT-ACCOUNT-NO               
A00388          AND  UT.IC_NO           =  :UT-IC-NO                    
A00388          AND  UT.CODE_UTIL_TYPE  =  'G'                          
A00388                                                           
A00388     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     52133001
MFA-TR*      SELECT  GAS_BASE_USE                                               
MFA-TR*             ,RATE_PLAN_NO                                               
MFA-TR*        INTO  :UT-GAS-BASE-USE                                           
MFA-TR*             ,:UT-RATE-PLAN-NO                                           
MFA-TR*        FROM CSS_UTIL_ENVRNMT   UT                                       
MFA-TR*       WHERE  UT.ACCOUNT_NO      =  :UT-ACCOUNT-NO                       
MFA-TR*         AND  UT.IC_NO           =  :UT-IC-NO                            
MFA-TR*         AND  UT.CODE_UTIL_TYPE  =  'G'                                  
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00388                                                                  
A00388     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
A00388                                                                  
A00388     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A00388        CONTINUE                                                  
A00388     ELSE                                                         
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        DISPLAY '*  7330-SELECT-UTIL-DATA               *'        
A00388        DISPLAY '* ACCOUNT NO        : ' UT-ACCOUNT-NO            
A00388        DISPLAY '* IC NO             : ' UT-IC-NO                 
A00388        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
A00388        DISPLAY '*     PROCESSING TERMINATED            *'        
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        PERFORM 9900-ABEND                THRU 9900-EXIT          
A00388     END-IF.                                                      
A00388*                                                                 52136701
A00388 7330-EXIT.                                                       
A00388     EXIT.                                                        
A00388*                                                                         
A00388*****************************************************************         
A00388** SELECT CONSUMPTION DATA FOR FUTURE BILLHOOK                 **         
A00388*****************************************************************         
A00388*                                                                         
A00388 7340-GET-CNSMPTN-DATA.                                           
A00388*                                                                 52132201
A00388     EXEC SQL                                                     
A00388       SELECT TOP(1) COALESCE(SUM(CX.NO_DAYS),0),
              COALESCE(MAX(CX.DATE_READ),IIF(TRY_CONVERT(DATE, 
              '0001-01-01') IS NULL OR (PATINDEX('%.%', '0001-01-01'
              ) <> 0) OR (LEN('0001-01-01') <> 10), CIS.CHAR2DATE(
              '0001-01-01'), CONVERT(DATE, '0001-01-01') ))             
A00388         INTO  :WS-CX-SUM-NO-DAYS                                 
A00388              ,:WS-CX-MAX-DATE-READ                               
A00388         FROM  CSS_CNSMPTN_HIST   CX WITH(READUNCOMMITTED)                
A00388              ,CSS_BILLING_DET    BG WITH(READUNCOMMITTED)                
A00388        WHERE  CX.ACCOUNT_NO         =  :CX-ACCOUNT-NO            
A00388          AND  CX.IC_NO              =  :CX-IC-NO                 
A00388          AND  CX.CODE_UTIL_TYPE     =  'G'                       
A00388          AND  CX.CODE_USAGE_TYPE    =  'C'                       
A00388          AND  BG.ACCOUNT_NO         =  CX.ACCOUNT_NO             
A00388          AND  BG.IC_NO              =  CX.IC_NO                  
A00388          AND  BG.CODE_UTIL_TYPE     =  CX.CODE_UTIL_TYPE         
A00388          AND  BG.BILL_NO            =  CX.BILL_NO                
A00388          AND  BG.BILL_ITEM_TIMESTMP =  CX.BILL_ITEM_TIMESTMP     
A00388          AND  BG.REBILL_IND         <> 'Y'                       
A00388          AND  BG.DATE_ORIG_BILL     IS NULL                      
A00388          AND  BG.REVENUE_MONTH      =  0                         
A00388          AND  BG.CODE_BILL_CALC     =  'A'                       
A00388          AND  BG.CODE_BILL_ITM_TYPE =  'C'                       
A00388          AND  BG.CODE_BILL_ITM_IND  =  'A'                       
A00388       GROUP BY CX.MTR_REF_NO,CX.REG_ID_NO,CX.CODE_TIME_PERIOD    
A00388       ORDER BY 1 DESC                                            
A00388                                       
A00388     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     52133001
MFA-TR*      SELECT  IFNULL(SUM(CX.NO_DAYS),0)                                  
MFA-TR*             ,IFNULL(MAX(CX.DATE_READ),'0001-01-01')                     
MFA-TR*        INTO  :WS-CX-SUM-NO-DAYS                                         
MFA-TR*             ,:WS-CX-MAX-DATE-READ                                       
MFA-TR*        FROM  CSS_CNSMPTN_HIST   CX                                      
MFA-TR*             ,CSS_BILLING_DET    BG                                      
MFA-TR*       WHERE  CX.ACCOUNT_NO         =  :CX-ACCOUNT-NO                    
MFA-TR*         AND  CX.IC_NO              =  :CX-IC-NO                         
MFA-TR*         AND  CX.CODE_UTIL_TYPE     =  'G'                               
MFA-TR*         AND  CX.CODE_USAGE_TYPE    =  'C'                               
MFA-TR*         AND  BG.ACCOUNT_NO         =  CX.ACCOUNT_NO                     
MFA-TR*         AND  BG.IC_NO              =  CX.IC_NO                          
MFA-TR*         AND  BG.CODE_UTIL_TYPE     =  CX.CODE_UTIL_TYPE                 
MFA-TR*         AND  BG.BILL_NO            =  CX.BILL_NO                        
MFA-TR*         AND  BG.BILL_ITEM_TIMESTMP =  CX.BILL_ITEM_TIMESTMP             
MFA-TR*         AND  BG.REBILL_IND         <> 'Y'                               
MFA-TR*         AND  BG.DATE_ORIG_BILL     IS NULL                              
MFA-TR*         AND  BG.REVENUE_MONTH      =  0                                 
MFA-TR*         AND  BG.CODE_BILL_CALC     =  'A'                               
MFA-TR*         AND  BG.CODE_BILL_ITM_TYPE =  'C'                               
MFA-TR*         AND  BG.CODE_BILL_ITM_IND  =  'A'                               
MFA-TR*      GROUP BY CX.MTR_REF_NO,CX.REG_ID_NO,CX.CODE_TIME_PERIOD            
MFA-TR*      ORDER BY 1 DESC                                                    
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00388                                                                  
A00388     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
A00388                                                                  
A00388     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A00388        CONTINUE                                                  
A00388     ELSE                                                         
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        DISPLAY '*  7340-GET-CNSMPTN-DATA               *'        
A00388        DISPLAY '* ACCOUNT NO        : ' CX-ACCOUNT-NO            
A00388        DISPLAY '* IC NO             : ' CX-IC-NO                 
A00388        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
A00388        DISPLAY '*     PROCESSING TERMINATED            *'        
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        PERFORM 9900-ABEND                THRU 9900-EXIT          
A00388     END-IF.                                                      
A00388*                                                                 52136701
A00388 7340-EXIT.                                                       
A00388     EXIT.                                                        
A00388*                                                                         
A00388*****************************************************************         
A00388** SELECT LAST_REG_READ_DATE FROM CSS_MTRD_ENVRNMT             **         
A00388*****************************************************************         
A00388*                                                                         
A00388 7345-GET-LAST-REG-READ-DT.                                       
A00388*                                                                 52132201
A00388     EXEC SQL                                                     
A00388       SELECT  MIN(MN.LAST_REG_READ_DATE)                         
A00388         INTO :MN-LAST-REG-READ-DATE                              
A00388         FROM  CSS_MTRD_ENVRNMT   MN WITH(READUNCOMMITTED)                
A00388        WHERE  MN.ACCOUNT_NO         =  :MN-ACCOUNT-NO            
A00388          AND  MN.IC_NO              =  :MN-IC-NO                 
A00388          AND  MN.CODE_UTIL_TYPE     =  'G'                       
A00388          AND  MN.CODE_METER_STATUS  <> 'K'                       
A00388                                                           
A00388     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     52133001
MFA-TR*      SELECT  MIN(MN.LAST_REG_READ_DATE)                                 
MFA-TR*        INTO :MN-LAST-REG-READ-DATE                                      
MFA-TR*        FROM  CSS_MTRD_ENVRNMT   MN                                      
MFA-TR*       WHERE  MN.ACCOUNT_NO         =  :MN-ACCOUNT-NO                    
MFA-TR*         AND  MN.IC_NO              =  :MN-IC-NO                         
MFA-TR*         AND  MN.CODE_UTIL_TYPE     =  'G'                               
MFA-TR*         AND  MN.CODE_METER_STATUS  <> 'K'                               
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00388                                                                  
A00388     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
A00388                                                                  
A00388     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A00388        CONTINUE                                                  
A00388     ELSE                                                         
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        DISPLAY '*  7345-GET-LAST-REG-READ-DT           *'        
A00388        DISPLAY '* ACCOUNT NO        : ' MN-ACCOUNT-NO            
A00388        DISPLAY '* IC NO             : ' MN-IC-NO                 
A00388        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
A00388        DISPLAY '*     PROCESSING TERMINATED            *'        
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        PERFORM 9900-ABEND                THRU 9900-EXIT          
A00388     END-IF.                                                      
A00388*                                                                 52136701
A00388 7345-EXIT.                                                       
A00388     EXIT.                                                        
A00388*                                                                         
A00388*****************************************************************         
A00388** GET DATE RANGE(BEGIN/END DATE) FOR COMPUTING SEABLK FACTORS **         
A00388*****************************************************************         
A00388*                                                                         
A00388 7350-CALC-SEABLK-DATES-CX.                                       
A00388*                                                                 52132201
A00388     EXEC SQL                                                     
A00388          SELECT
              DATEADD( DAY, -:WS-CX-SUM-NO-DAYS, IIF(TRY_CONVERT(DATE, 
                                                   :WS-CX-MAX-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :WS-CX-MAX-DATE-READ
              ) <> 0) OR (LEN(:WS-CX-MAX-DATE-READ
              ) <> 10), CIS.CHAR2DATE(:WS-CX-MAX-DATE-READ
              ), CONVERT(DATE, :WS-CX-MAX-DATE-READ) ) ),
              DATEADD( MONTH, 1, DATEADD( MONTH, -:FF-FAC-CHRG-BASE-AM, 
              DATEADD( DAY, -:WS-CX-SUM-NO-DAYS, IIF(TRY_CONVERT(DATE, 
                                                   :WS-CX-MAX-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :WS-CX-MAX-DATE-READ
              ) <> 0) OR (LEN(:WS-CX-MAX-DATE-READ
              ) <> 10), CIS.CHAR2DATE(:WS-CX-MAX-DATE-READ
              ), CONVERT(DATE, :WS-CX-MAX-DATE-READ) ) ) ) )
            INTO
              :WS-SEABLK-END-DT,
              :WS-SEABLK-BEG-DT                      
A00388     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     52133001
MFA-TR*         SET  :WS-SEABLK-END-DT = DATE(:WS-CX-MAX-DATE-READ)             
MFA-TR*                                  -    :WS-CX-SUM-NO-DAYS DAYS           
MFA-TR*             ,:WS-SEABLK-BEG-DT = DATE(:WS-CX-MAX-DATE-READ)             
MFA-TR*                                  - :WS-CX-SUM-NO-DAYS DAYS              
MFA-TR*                                  - :FF-FAC-CHRG-BASE-AM MONTHS          
MFA-TR*                                  + 1 MONTH                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00388                                                                  
A00388     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
A00388                                                                  
A00388     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A00388        CONTINUE                                                  
A00388     ELSE                                                         
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        DISPLAY '*  7350-CALC-SEABLK-DATES-CX           *'        
A00388        DISPLAY '* ACCOUNT NO          : ' CX-ACCOUNT-NO          
A00388        DISPLAY '* WS-CX-MAX-DATE-READ : ' WS-CX-MAX-DATE-READ    
A00388        DISPLAY '* WS-CX-SUM-NO-DAYS   : ' WS-CX-SUM-NO-DAYS      
A00388        DISPLAY '* FF-FAC-CHRG-BASE-AM : ' FF-FAC-CHRG-BASE-AM    
A00388        DISPLAY '* SQLCODE             : ' WS-ACTIVE-RETURN-CODE  
A00388        DISPLAY '*     PROCESSING TERMINATED            *'        
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        PERFORM 9900-ABEND                THRU 9900-EXIT          
A00388     END-IF.                                                      
A00388*                                                                 52136701
A00388 7350-EXIT.                                                       
A00388     EXIT.                                                        
A00388*                                                                         
A00388*****************************************************************         
A00388** GET BEGIN DATE RANGE FOR COMPUTING SEABLK FACTORS           **         
A00388*****************************************************************         
A00388*                                                                         
A00388 7355-CALC-SEABLK-DATES-MN.                                       
A00388*                                                                 52132201
A00388     EXEC SQL                                                     
A00388          SELECT
              DATEADD( MONTH, 1, DATEADD( MONTH, -:FF-FAC-CHRG-BASE-AM, 
              IIF(TRY_CONVERT(DATE, :MN-LAST-REG-READ-DATE
              ) IS NULL OR (PATINDEX('%.%', :MN-LAST-REG-READ-DATE
              ) <> 0) OR (LEN(:MN-LAST-REG-READ-DATE
              ) <> 10), CIS.CHAR2DATE(:MN-LAST-REG-READ-DATE
              ), CONVERT(DATE, :MN-LAST-REG-READ-DATE) ) ) )
            INTO
              :WS-SEABLK-BEG-DT                      
A00388     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     52133001
MFA-TR*         SET  :WS-SEABLK-BEG-DT = DATE(:MN-LAST-REG-READ-DATE)           
MFA-TR*                                  - :FF-FAC-CHRG-BASE-AM MONTHS          
MFA-TR*                                  + 1 MONTH                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00388                                                                  
A00388     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
A00388                                                                  
A00388     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A00388        CONTINUE                                                  
A00388     ELSE                                                         
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        DISPLAY '*  7355-CALC-SEABLK-DATES-MN           *'        
A00388        DISPLAY '* ACCOUNT NO          : ' MN-ACCOUNT-NO          
A00388        DISPLAY '* LAST_REG_READ_DATE  : ' MN-LAST-REG-READ-DATE  
A00388        DISPLAY '* SQLCODE             : ' WS-ACTIVE-RETURN-CODE  
A00388        DISPLAY '*     PROCESSING TERMINATED            *'        
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        PERFORM 9900-ABEND                THRU 9900-EXIT          
A00388     END-IF.                                                      
A00388*                                                                 52136701
A00388 7355-EXIT.                                                       
A00388     EXIT.                                                        
A00388*                                                                         
A00388*****************************************************************         
A00388** GET RATE PLAN OF LATEST BILLED REVENUE MONTH                **         
A00388*****************************************************************         
A00388*                                                                         
A00388 7360-GET-LAST-BILLED-RATE.                                       
A00388*                                                                 52132201
A00388     EXEC SQL                                                     
A00388       SELECT TOP(1) BG.RATE_PLAN_NO,
              CASE WHEN BG.REV_MTH_ORIG_BILL > 0                 
A00388                    THEN BG.REV_MTH_ORIG_BILL                     
A00388                    ELSE BG.REVENUE_MONTH                         
A00388               END AS REVENUE_MONTH                               
A00388         INTO  :BG-RATE-PLAN-NO                                   
A00388              ,:BG-REVENUE-MONTH                                  
A00388         FROM  CSS_BILLING_DET    BG WITH(READUNCOMMITTED)                
A00388        WHERE  BG.ACCOUNT_NO          =  :BG-ACCOUNT-NO           
A00388          AND  BG.IC_NO               =  :BG-IC-NO                
A00388          AND  BG.CODE_UTIL_TYPE      =  'G'                      
A00388          AND  ((BG.REV_MTH_ORIG_BILL =  0 AND                    
A00388                 BG.REVENUE_MONTH     <= :BG-REVENUE-MONTH)       
A00388                              OR                                  
A00388                (BG.REV_MTH_ORIG_BILL <= :BG-REVENUE-MONTH))      
A00388          AND  BG.CODE_BILL_CALC      =  'A'                      
A00388          AND  BG.CODE_BILL_ITM_TYPE  =  'C'                      
A00388          AND  BG.CODE_BILL_ITM_IND   =  'A'                      
A00388       ORDER BY 2 DESC                                            
A00388                                       
A00388     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     52133001
MFA-TR*      SELECT  BG.RATE_PLAN_NO                                            
MFA-TR*             ,CASE WHEN BG.REV_MTH_ORIG_BILL > 0                         
MFA-TR*                   THEN BG.REV_MTH_ORIG_BILL                             
MFA-TR*                   ELSE BG.REVENUE_MONTH                                 
MFA-TR*              END AS REVENUE_MONTH                                       
MFA-TR*        INTO  :BG-RATE-PLAN-NO                                           
MFA-TR*             ,:BG-REVENUE-MONTH                                          
MFA-TR*        FROM  CSS_BILLING_DET    BG                                      
MFA-TR*       WHERE  BG.ACCOUNT_NO          =  :BG-ACCOUNT-NO                   
MFA-TR*         AND  BG.IC_NO               =  :BG-IC-NO                        
MFA-TR*         AND  BG.CODE_UTIL_TYPE      =  'G'                              
MFA-TR*         AND  ((BG.REV_MTH_ORIG_BILL =  0 AND                            
MFA-TR*                BG.REVENUE_MONTH     <= :BG-REVENUE-MONTH)               
MFA-TR*                             OR                                          
MFA-TR*               (BG.REV_MTH_ORIG_BILL <= :BG-REVENUE-MONTH))              
MFA-TR*         AND  BG.CODE_BILL_CALC      =  'A'                              
MFA-TR*         AND  BG.CODE_BILL_ITM_TYPE  =  'C'                              
MFA-TR*         AND  BG.CODE_BILL_ITM_IND   =  'A'                              
MFA-TR*      ORDER BY 2 DESC                                                    
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00388                                                                  
A00388     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
A00388                                                                  
A00388     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A00388        CONTINUE                                                  
A00388     ELSE                                                         
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        DISPLAY '*  7360-GET-LAST-BILLED-RATE           *'        
A00388        DISPLAY '* ACCOUNT NO        : ' BG-ACCOUNT-NO            
A00388        DISPLAY '* IC NO             : ' BG-IC-NO                 
A00388        DISPLAY '* REVENUE MONTH     : ' BG-REVENUE-MONTH         
A00388        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
A00388        DISPLAY '*     PROCESSING TERMINATED            *'        
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        PERFORM 9900-ABEND                THRU 9900-EXIT          
A00388     END-IF.                                                      
A00388*                                                                 52136701
A00388 7360-EXIT.                                                       
A00388     EXIT.                                                        
A00388*                                                                         
A00388*****************************************************************         
A00388** GET LATEST ACCOUNT & CORRESPONDING IC FOR THE PREMISE       **         
A00388*****************************************************************         
A00388*                                                                         
A00388 7370-GET-PREV-ACCT-ON-PREMISE.                                   
A00388*                                                                 52132201
A00388     EXEC SQL                                                     
A00388       SELECT TOP(1) CH.ACCOUNT_NO,
              UT.IC_NO                                           
A00388         INTO  :WS-OLD-ACCOUNT-NO                                 
A00388              ,:WS-OLD-IC-NO                                      
A00388         FROM  CSS_CUST_PREM_HIST CH WITH(READUNCOMMITTED)                
A00388              ,CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)                
A00388        WHERE  CH.PREMISE_NO         =  :CH-PREMISE-NO            
A00388          AND  UT.ACCOUNT_NO         =  CH.ACCOUNT_NO             
A00388          AND  UT.CODE_UTIL_TYPE     =  'G'                       
A00388          AND  CH.DATE_UTIL_SVC_END  IS NOT NULL                  
A00388       ORDER BY CH.DATE_UTIL_SVC_END DESC                         
A00388               ,CH.ACCOUNT_NO, UT.IC_NO ASC                       
A00388                                       
A00388     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     52133001
MFA-TR*      SELECT  CH.ACCOUNT_NO                                              
MFA-TR*             ,UT.IC_NO                                                   
MFA-TR*        INTO  :WS-OLD-ACCOUNT-NO                                         
MFA-TR*             ,:WS-OLD-IC-NO                                              
MFA-TR*        FROM  CSS_CUST_PREM_HIST CH                                      
MFA-TR*             ,CSS_UTIL_ENVRNMT   UT                                      
MFA-TR*       WHERE  CH.PREMISE_NO         =  :CH-PREMISE-NO                    
MFA-TR*         AND  UT.ACCOUNT_NO         =  CH.ACCOUNT_NO                     
MFA-TR*         AND  UT.CODE_UTIL_TYPE     =  'G'                               
MFA-TR*         AND  CH.DATE_UTIL_SVC_END  IS NOT NULL                          
MFA-TR*      ORDER BY CH.DATE_UTIL_SVC_END DESC                                 
MFA-TR*              ,CH.ACCOUNT_NO, UT.IC_NO ASC                               
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00388                                                                  
A00388     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
A00388                                                                  
A00388     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A00388        CONTINUE                                                  
A00388     ELSE                                                         
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        DISPLAY '*  7370-GET-PREV-ACCT-ON-PREMISE     *'          
A00388        DISPLAY '* ACCOUNT NO        : ' AT-ACCOUNT-NO            
A00388        DISPLAY '* PREMISE NO        : ' CH-PREMISE-NO            
A00388        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
A00388        DISPLAY '*     PROCESSING TERMINATED            *'        
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        PERFORM 9900-ABEND                THRU 9900-EXIT          
A00388     END-IF.                                                      
A00388*                                                                 52136701
A00388 7370-EXIT.                                                       
A00388     EXIT.                                                        
A00388*                                                                         
A00388*****************************************************************         
A00388** GET LATEST BTU WNA RANGES FOR SEABLK RATE PLAN              **         
A00388*****************************************************************         
A00388*                                                                         
A00388 7380-GET-BTU-WNA-RANGES.                                         
A00388*                                                                 52132201
A00388     EXEC SQL                                                     
A00388       SELECT TOP(1) BR.GAS_BASE_HIGH_RATE,
              BR.GAS_BASE_LOW_RATE,
              BR.GAS_BASE_USE_MIN                                
A00388         INTO  :BR-GAS-BASE-HIGH-RATE                             
A00388              ,:BR-GAS-BASE-LOW-RATE                              
A00388              ,:BR-GAS-BASE-USE-MIN                               
A00388         FROM  CSS_BTU_WNA_RANGE BR WITH(READUNCOMMITTED)                 
A00388        WHERE  BR.RATE_PLAN_NO       =  :BR-RATE-PLAN-NO          
A00388          AND  BR.CODE_UTIL_TYPE     =  'G'                       
A00388       ORDER BY BR.EFFECTIVE_DT DESC                              
A00388                                       
A00388     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     52133001
MFA-TR*      SELECT  BR.GAS_BASE_HIGH_RATE                                      
MFA-TR*             ,BR.GAS_BASE_LOW_RATE                                       
MFA-TR*             ,BR.GAS_BASE_USE_MIN                                        
MFA-TR*        INTO  :BR-GAS-BASE-HIGH-RATE                                     
MFA-TR*             ,:BR-GAS-BASE-LOW-RATE                                      
MFA-TR*             ,:BR-GAS-BASE-USE-MIN                                       
MFA-TR*        FROM  CSS_BTU_WNA_RANGE BR                                       
MFA-TR*       WHERE  BR.RATE_PLAN_NO       =  :BR-RATE-PLAN-NO                  
MFA-TR*         AND  BR.CODE_UTIL_TYPE     =  'G'                               
MFA-TR*      ORDER BY BR.EFFECTIVE_DT DESC                                      
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00388                                                                  
A00388     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
A00388                                                                  
A00388     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A00388        CONTINUE                                                  
A00388     ELSE                                                         
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        DISPLAY '*  7380-GET-BTU-WNA-RANGES             *'        
A00388        DISPLAY '* ACCOUNT NO        : ' AT-ACCOUNT-NO            
A00388        DISPLAY '* RATE PLAN NO      : ' BR-RATE-PLAN-NO          
A00388        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
A00388        DISPLAY '*     PROCESSING TERMINATED            *'        
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        PERFORM 9900-ABEND                THRU 9900-EXIT          
A00388     END-IF.                                                      
A00388*                                                                 52136701
A00388 7380-EXIT.                                                       
A00388     EXIT.                                                        
A00388*                                                                         
A00388*****************************************************************         
A00388** GET BFC AMOUNT FOR EACH MONTH TURNED OFF                    **         
A00388*****************************************************************         
A00388*                                                                         
A00388 7390-GET-BFC.                                                    
A00388*                                                                 52132201
A00388     EXEC SQL                                                     
A00388       SELECT TOP(1) J4.AMT_CUST_CHRG,
              J4.VERSION_NO_CNTRL                                
A00388         INTO  :J4-AMT-CUST-CHRG                                  
A00388              ,:J4-VERSION-NO-CNTRL                               
A00388         FROM  CSS_RATE_CREATOR  RT WITH(READUNCOMMITTED)                 
A00388              ,CSS_RATE_VRSN_DEF J4 WITH(READUNCOMMITTED)                 
A00388        WHERE  RT.RATE_PLAN_NO       =  :RT-RATE-PLAN-NO          
A00388          AND  RT.CODE_UTIL_TYPE     =  'G'                       
A00388          AND  RT.CODE_STATUS        IN ('A','I','F')             
A00388          AND  RT.FROM_EFFECTIVE_DT  <= IIF(TRY_CONVERT(DATE, 
                                                  :RT-FROM-EFFECTIVE-DT
              ) IS NULL OR (PATINDEX('%.%', :RT-FROM-EFFECTIVE-DT
              ) <> 0) OR (LEN(:RT-FROM-EFFECTIVE-DT
              ) <> 10), CIS.CHAR2DATE(:RT-FROM-EFFECTIVE-DT
              ), CONVERT(DATE, :RT-FROM-EFFECTIVE-DT) )     
A00388          AND  RT.RATE_PLAN_NO       =  J4.RATE_PLAN_NO           
A00388          AND  RT.CODE_UTIL_TYPE     =  J4.CODE_UTIL_TYPE         
A00388          AND  RT.VERSION_NO_CNTRL   =  J4.VERSION_NO_CNTRL       
A00388       ORDER BY RT.FROM_EFFECTIVE_DT DESC                         
A00388                                       
A00388     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     52133001
MFA-TR*      SELECT  J4.AMT_CUST_CHRG                                           
MFA-TR*             ,J4.VERSION_NO_CNTRL                                        
MFA-TR*        INTO  :J4-AMT-CUST-CHRG                                          
MFA-TR*             ,:J4-VERSION-NO-CNTRL                                       
MFA-TR*        FROM  CSS_RATE_CREATOR  RT                                       
MFA-TR*             ,CSS_RATE_VRSN_DEF J4                                       
MFA-TR*       WHERE  RT.RATE_PLAN_NO       =  :RT-RATE-PLAN-NO                  
MFA-TR*         AND  RT.CODE_UTIL_TYPE     =  'G'                               
MFA-TR*         AND  RT.CODE_STATUS        IN ('A','I','F')                     
MFA-TR*         AND  RT.FROM_EFFECTIVE_DT  <= :RT-FROM-EFFECTIVE-DT             
MFA-TR*         AND  RT.RATE_PLAN_NO       =  J4.RATE_PLAN_NO                   
MFA-TR*         AND  RT.CODE_UTIL_TYPE     =  J4.CODE_UTIL_TYPE                 
MFA-TR*         AND  RT.VERSION_NO_CNTRL   =  J4.VERSION_NO_CNTRL               
MFA-TR*      ORDER BY RT.FROM_EFFECTIVE_DT DESC                                 
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00388                                                                  
A00388     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
A00388                                                                  
A00388     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A00388        CONTINUE                                                  
A00388     ELSE                                                         
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        DISPLAY '*  7390-GET-BFC                        *'        
A00388        DISPLAY '* ACCOUNT NO        : ' AT-ACCOUNT-NO            
A00388        DISPLAY '* RATE PLAN NO      : ' RT-RATE-PLAN-NO          
A00388        DISPLAY '* FROM EFFECTIVE DT : ' RT-FROM-EFFECTIVE-DT     
A00388        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
A00388        DISPLAY '*     PROCESSING TERMINATED            *'        
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        PERFORM 9900-ABEND                THRU 9900-EXIT          
A00388     END-IF.                                                      
A00388*                                                                 52136701
A00388 7390-EXIT.                                                       
A00388     EXIT.                                                        
A00388*                                                                         
A00388*****************************************************************         
A00388** SELECT THE DATES FOR THE RATE SEASON                        **         
A00388*****************************************************************         
A00388*                                                                         
A00388 7400-GET-SEASONS.                                                
A00388*                                                                 52132201
A00388     EXEC SQL                                                     
A00388       SELECT  RS.DATE_FROM                                       
A00388              ,RS.DATE_TO                                         
A00388         INTO  :RS-DATE-FROM                                      
A00388              ,:RS-DATE-TO                                        
A00388         FROM  CSS_RATE_USE_SEASN RS WITH(READUNCOMMITTED)                
A00388        WHERE  RS.RATE_PLAN_NO       =  :RS-RATE-PLAN-NO          
A00388          AND  RS.CODE_UTIL_TYPE     =  'G'                       
A00388          AND  RS.VERSION_NO_CNTRL   =  :RS-VERSION-NO-CNTRL      
A00388                                                           
A00388     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     52133001
MFA-TR*      SELECT  RS.DATE_FROM                                               
MFA-TR*             ,RS.DATE_TO                                                 
MFA-TR*        INTO  :RS-DATE-FROM                                              
MFA-TR*             ,:RS-DATE-TO                                                
MFA-TR*        FROM  CSS_RATE_USE_SEASN RS                                      
MFA-TR*       WHERE  RS.RATE_PLAN_NO       =  :RS-RATE-PLAN-NO                  
MFA-TR*         AND  RS.CODE_UTIL_TYPE     =  'G'                               
MFA-TR*         AND  RS.VERSION_NO_CNTRL   =  :RS-VERSION-NO-CNTRL              
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00388                                                                  
A00388     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
A00388                                                                  
A00388     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A00388        CONTINUE                                                  
A00388     ELSE                                                         
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        DISPLAY '*  7400-GET-SEASONS                    *'        
A00388        DISPLAY '* ACCOUNT NO        : ' AT-ACCOUNT-NO            
A00388        DISPLAY '* RATE PLAN NO      : ' RS-RATE-PLAN-NO          
A00388        DISPLAY '* VERSION NO CNTRL  : ' RS-VERSION-NO-CNTRL      
A00388        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
A00388        DISPLAY '*     PROCESSING TERMINATED            *'        
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        PERFORM 9900-ABEND                THRU 9900-EXIT          
A00388     END-IF.                                                      
A00388*                                                                 52136701
A00388 7400-EXIT.                                                       
A00388     EXIT.                                                        
A00388*                                                                         
A00388*****************************************************************         
A00388** GET THE BFC ADJUSTMENT FACTOR IF ONE EXISTS                 **         
A00388*****************************************************************         
A00388*                                                                         
A00388 7410-GET-BFC-ADJUST.                                             
A00388*                                                                 52132201
A00388     EXEC SQL                                                     
A00388       SELECT  SA.FACTOR                                          
A00388              ,SF.ADJUST_ELEMENT                                  
A00388         INTO  :SA-FACTOR                                         
A00388              ,:SF-ADJUST-ELEMENT                                 
A00388         FROM  CSS_SPCL_FCTR_APPL   SA WITH(READUNCOMMITTED)              
A00388              ,CSS_SPCL_FCTR        SF WITH(READUNCOMMITTED)              
A00388        WHERE  SA.RATE_PLAN_NO       =  :SA-RATE-PLAN-NO          
A00388          AND  SA.CODE_UTIL_TYPE     =  'G'                       
A00388          AND  SA.CMPNT_ID_CD        =  '10'                      
A00388          AND  SA.INSTR_USE_TYPE_CD  =  'R'                       
A00388          AND  SA.CODE_STATUS        =  'A'                       
A00388          AND  SA.DATE_FROM          <= IIF(TRY_CONVERT(DATE, 
                                                          :SA-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :SA-DATE-FROM
              ) <> 0) OR (LEN(:SA-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :SA-DATE-FROM
              ), CONVERT(DATE, :SA-DATE-FROM) )             
A00388          AND  SA.DATE_TO            >= IIF(TRY_CONVERT(DATE, 
                                                            :SA-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :SA-DATE-TO) <> 0) OR (LEN(
                                                            :SA-DATE-TO
              ) <> 10), CIS.CHAR2DATE(:SA-DATE-TO), CONVERT(DATE, 
                                                            :SA-DATE-TO
              ) )               
A00388          AND  SA.CODE_SEASON        =  :SA-CODE-SEASON           
A00388          AND  SF.FACTOR_ID          =  SA.FACTOR_ID              
A00388          AND  SF.ADJUST_ELEMENT     IN ('L','O')                 
A00388                                                           
A00388     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     52133001
MFA-TR*      SELECT  SA.FACTOR                                                  
MFA-TR*             ,SF.ADJUST_ELEMENT                                          
MFA-TR*        INTO  :SA-FACTOR                                                 
MFA-TR*             ,:SF-ADJUST-ELEMENT                                         
MFA-TR*        FROM  CSS_SPCL_FCTR_APPL   SA                                    
MFA-TR*             ,CSS_SPCL_FCTR        SF                                    
MFA-TR*       WHERE  SA.RATE_PLAN_NO       =  :SA-RATE-PLAN-NO                  
MFA-TR*         AND  SA.CODE_UTIL_TYPE     =  'G'                               
MFA-TR*         AND  SA.CMPNT_ID_CD        =  '10'                              
MFA-TR*         AND  SA.INSTR_USE_TYPE_CD  =  'R'                               
MFA-TR*         AND  SA.CODE_STATUS        =  'A'                               
MFA-TR*         AND  SA.DATE_FROM          <= :SA-DATE-FROM                     
MFA-TR*         AND  SA.DATE_TO            >= :SA-DATE-TO                       
MFA-TR*         AND  SA.CODE_SEASON        =  :SA-CODE-SEASON                   
MFA-TR*         AND  SF.FACTOR_ID          =  SA.FACTOR_ID                      
MFA-TR*         AND  SF.ADJUST_ELEMENT     IN ('L','O')                         
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00388*                                                                 52134801
A00388     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
A00388*                                                                 52134801
A00388     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A00388        CONTINUE                                                  
A00388     ELSE                                                         
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        DISPLAY '*  7410-GET-BFC-ADJUST                 *'        
A00388        DISPLAY '* ACCOUNT NO        : ' AT-ACCOUNT-NO            
A00388        DISPLAY '* RATE PLAN NO      : ' SA-RATE-PLAN-NO          
A00388        DISPLAY '* DATE FROM         : ' SA-DATE-FROM             
A00388        DISPLAY '* DATE TO           : ' SA-DATE-TO               
A00388        DISPLAY '* CODE SEASON       : ' SA-CODE-SEASON           
A00388        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
A00388        DISPLAY '*     PROCESSING TERMINATED            *'        
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        PERFORM 9900-ABEND                THRU 9900-EXIT          
A00388     END-IF.                                                      
A00388*                                                                 52136701
A00388 7410-EXIT.                                                       
A00388     EXIT.                                                        
A00388*                                                                         
A00388*****************************************************************         
A00388** ADD ONE MONTH                                               **         
A00388*****************************************************************         
A00388*                                                                         
A00388 7420-ADD-ONE-MONTH.                                              
A00388*                                                                 52132201
A00388     EXEC SQL                                                     
A00388          SELECT
              DATEADD( MONTH, 1, IIF(TRY_CONVERT(DATE, 
                                                     :WS-WORK-SEABLK-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-SEABLK-DT
              ) <> 0) OR (LEN(:WS-WORK-SEABLK-DT
              ) <> 10), CIS.CHAR2DATE(:WS-WORK-SEABLK-DT
              ), CONVERT(DATE, :WS-WORK-SEABLK-DT) ) )
            INTO
              :WS-WORK-SEABLK-DT                      
A00388     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     52133001
MFA-TR*         SET :WS-WORK-SEABLK-DT = DATE(:WS-WORK-SEABLK-DT)               
MFA-TR*                                  + 1 MONTH                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00388*                                                                 52134801
A00388     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
A00388*                                                                 52134801
A00388     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A00388        CONTINUE                                                  
A00388     ELSE                                                         
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        DISPLAY '*  7420-ADD-ONE-MONTH                  *'        
A00388        DISPLAY '* ACCOUNT NO        : ' AT-ACCOUNT-NO            
A00388        DISPLAY '* WS-WORK-SEABLK-DT : ' WS-WORK-SEABLK-DT        
A00388        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
A00388        DISPLAY '*     PROCESSING TERMINATED            *'        
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        PERFORM 9900-ABEND                THRU 9900-EXIT          
A00388     END-IF.                                                      
A00388*                                                                 52136701
A00388 7420-EXIT.                                                       
A00388     EXIT.                                                        
A00388*                                                                         
P00680*****************************************************************         
P00680** OPEN UNUSED_FACTOR                                          **         
P00680*****************************************************************         
P00680*                                                                         
P00680 7430-OPEN-UNUSED-FACTOR.                                         
P00680*                                                                 52132201
P00680     EXEC SQL                                                     
P00680         OPEN  UNUSED_FACTOR                                      
P00680     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00680                                                                  
P00680     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
P00680                                                                  
P00680     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00680        CONTINUE                                                  
P00680     ELSE                                                         
P00680        DISPLAY '********** PCSCA290 ABORT **************'        
P00680        DISPLAY '*  7430-OPEN-UNUSED-FACTOR             *'        
P00680        DISPLAY '* ACCOUNT NO        : ' FF-ACCOUNT-NO            
P00680        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
P00680        DISPLAY '*     PROCESSING TERMINATED            *'        
P00680        DISPLAY '********** PCSCA290 ABORT **************'        
P00680        PERFORM 9900-ABEND                THRU 9900-EXIT          
P00680     END-IF.                                                      
P00680*                                                                 52136701
P00680 7430-EXIT.                                                       
P00680     EXIT.                                                        
P00680*                                                                         
P00680*****************************************************************         
P00680** FETCH UNUSED_FACTOR                                         **         
P00680*****************************************************************         
P00680*                                                                         
P00680 7440-FETCH-UNUSED-FACTOR.                                        
P00680*                                                                 52132201
P00680     EXEC SQL                                                     
P00680        FETCH  UNUSED_FACTOR                                      
P00680         INTO  :FF-FACTOR-ID                                      
P00680              ,:WS-PRV-MONTHS-REMAIN :WS-NULL-IND-06               
P00680              ,:WS-PRV-FCTR-EFF-DT                                
P00680              ,:FF-FIXED-FCTR-SEQ-NO                              
A04019              ,:SF-RT-ATTR-INCTV-TYPE                             
P00680     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00680                                                                  
P00680     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
P00680                                                                  
P00680     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00680        CONTINUE                                                  
P00680     ELSE                                                         
P00680        DISPLAY '********** PCSCA290 ABORT **************'        
P00680        DISPLAY '*  7440-FETCH-UNUSED-FACTOR            *'        
P00680        DISPLAY '* ACCOUNT NO        : ' FF-ACCOUNT-NO            
P00680        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
P00680        DISPLAY '*     PROCESSING TERMINATED            *'        
P00680        DISPLAY '********** PCSCA290 ABORT **************'        
P00680        PERFORM 9900-ABEND                THRU 9900-EXIT          
P00680     END-IF.                                                      
P00680*                                                                 52136701
P00680 7440-EXIT.                                                       
P00680     EXIT.                                                        
P00680*                                                                         
P00680*****************************************************************         
P00680** CLOSE UNUSED_FACTOR                                         **         
P00680*****************************************************************         
P00680*                                                                         
P00680 7450-CLOSE-UNUSED-FACTOR.                                        
P00680*                                                                 52132201
P00680     EXEC SQL                                                     
P00680        CLOSE  UNUSED_FACTOR                                      
P00680     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00680                                                                  
P00680     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
P00680                                                                  
P00680     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00680        CONTINUE                                                  
P00680     ELSE                                                         
P00680        DISPLAY '********** PCSCA290 ABORT **************'        
P00680        DISPLAY '*  7450-CLOSE-UNUSED-FACTOR            *'        
P00680        DISPLAY '* ACCOUNT NO        : ' FF-ACCOUNT-NO            
P00680        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
P00680        DISPLAY '*     PROCESSING TERMINATED            *'        
P00680        DISPLAY '********** PCSCA290 ABORT **************'        
P00680        PERFORM 9900-ABEND                THRU 9900-EXIT          
P00680     END-IF.                                                      
P00680*                                                                 52136701
P00680 7450-EXIT.                                                       
P00680     EXIT.                                                        
P00680*                                                                         
      *****************************************************************         
      *                                                               *         
      * 7500-OPEN-UTL-ENVRNMT.                                        *         
      *****************************************************************         
       7500-OPEN-UTL-ENVRNMT.                                           
                                                                        
           EXEC SQL                                                     
                OPEN UTIL_ENVRNMT_CSR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA290 ABORT **************'        
              DISPLAY '*     7500-OPEN-UTL-ENVRNMT          *'          
              DISPLAY '* ACCOUNT NO     : ' UT-ACCOUNT-NO               
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA290 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7510-FETCH-UTL-ENVRNMT.                                       *         
      *****************************************************************         
       7510-FETCH-UTL-ENVRNMT.                                          
                                                                        
           EXEC SQL                                                     
                FETCH UTIL_ENVRNMT_CSR                                  
                 INTO :UT-RATE-PLAN-NO                                  
                     ,:UT-CODE-UTIL-TYPE                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
I00251           MOVE 'Y'                    TO WS-NO-MORE-ROWS-01      
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSCA290 ABORT **************'        
              DISPLAY '*     7510-FETCH-UTL-ENVRNMT         *'          
              DISPLAY '* ACCOUNT NO     : ' UT-ACCOUNT-NO               
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA290 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7520-CLOSE-UTL-ENVRNMT.                                       *         
      *****************************************************************         
       7520-CLOSE-UTL-ENVRNMT.                                          
                                                                        
           EXEC SQL                                                     
                CLOSE UTIL_ENVRNMT_CSR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA290 ABORT **************'        
              DISPLAY '*      7520-CLOSE-UTL-ENVRNMT        *'          
              DISPLAY '* ACCOUNT NO     : ' UT-ACCOUNT-NO               
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA290 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00211*****************************************************************         
P00211*                                                               *         
P00211* 7700-OPEN-OPTION-FCTR.                                        *         
P00211*****************************************************************         
P00211 7700-OPEN-OPTION-FCTR.                                           
P00211                                                                  
P00211     EXEC SQL                                                     
P00211          OPEN OPTION_FCTR_CSR                                    
P00211     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00211                                                                  
P00211     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00211                                                                  
P00211     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00211        CONTINUE                                                  
P00211     ELSE                                                         
P00211        DISPLAY '********** PCSCA290 ABORT **************'        
P00211        DISPLAY '*       7700-OPEN-OPTION-FCTR          *'        
P00211        DISPLAY '* ACCOUNT_NO        : ' FF-ACCOUNT-NO            
P00211        DISPLAY '* CODE_UTIL_TYPE    : ' FF-CODE-UTIL-TYPE        
P00211        DISPLAY '* IC_NO             : ' FF-IC-NO                 
P00211        DISPLAY '* RT_PKG_OPT_SEQ_NO : ' FF-RT-PKG-OPT-SEQ-NO     
P00211        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
P00211        DISPLAY '*       PROCESSING TERMINATED          *'        
P00211        DISPLAY '********** PCSCA290 ABORT **************'        
P00211        PERFORM 9900-ABEND               THRU 9900-EXIT           
P00211     END-IF.                                                      
P00211                                                                  
P00211 7700-EXIT.                                                       
P00211     EXIT.                                                        
P00211                                                                  
P00211*****************************************************************         
P00211*                                                               *         
P00211* 7710-FETCH-OPTION-FCTR.                                       *         
P00211*****************************************************************         
P00211 7710-FETCH-OPTION-FCTR.                                          
P00211                                                                  
P00211     EXEC SQL                                                     
P00211          FETCH OPTION_FCTR_CSR                                   
P00211           INTO :FF-FACTOR-ID                                     
P00211               ,:FF-EFF-DATE-FROM                                 
P00211               ,:FF-EFF-DATE-TO :WS-NULL-IND-05                    
P00211               ,:FF-FIXED-FCTR-SEQ-NO                             
P00211     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00211                                                                  
P00211     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00211                                                                  
P00211     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00211       WHEN SUCCESSFUL-CALL                                       
P00211           CONTINUE                                               
P00211       WHEN NOT-FOUND                                             
P00211           MOVE 'Y'                    TO WS-NO-MORE-ROWS-01      
P00211       WHEN OTHER                                                 
P00211           DISPLAY '********** PCSCA290 ABORT **************'     
P00211           DISPLAY '*      7710-FETCH-OPTION-FCTR          *'     
P00211           DISPLAY '* ACCOUNT_NO        : ' FF-ACCOUNT-NO         
P00211           DISPLAY '* CODE_UTIL_TYPE    : ' FF-CODE-UTIL-TYPE     
P00211           DISPLAY '* IC_NO             : ' FF-IC-NO              
P00211           DISPLAY '* RT_PKG_OPT_SEQ_NO : ' FF-RT-PKG-OPT-SEQ-NO  
P00211           DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE 
P00211           DISPLAY '*       PROCESSING TERMINATED          *'     
P00211           DISPLAY '********** PCSCA290 ABORT **************'     
P00211           PERFORM 9900-ABEND               THRU 9900-EXIT        
P00211     END-EVALUATE.                                                
P00211                                                                  
P00211 7710-EXIT.                                                       
P00211     EXIT.                                                        
P00211                                                                  
P00211*****************************************************************         
P00211*                                                               *         
P00211* 7720-CLOSE-OPTION-FCTR.                                       *         
P00211*****************************************************************         
P00211 7720-CLOSE-OPTION-FCTR.                                          
P00211                                                                  
P00211     EXEC SQL                                                     
P00211          CLOSE OPTION_FCTR_CSR                                   
P00211     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00211                                                                  
P00211     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00211                                                                  
P00211     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00211        CONTINUE                                                  
P00211     ELSE                                                         
P00211        DISPLAY '********** PCSCA290 ABORT **************'        
P00211        DISPLAY '*      7720-CLOSE-OPTION-FCTR          *'        
P00211        DISPLAY '* ACCOUNT_NO        : ' FF-ACCOUNT-NO            
P00211        DISPLAY '* CODE_UTIL_TYPE    : ' FF-CODE-UTIL-TYPE        
P00211        DISPLAY '* IC_NO             : ' FF-IC-NO                 
P00211        DISPLAY '* RT_PKG_OPT_SEQ_NO : ' FF-RT-PKG-OPT-SEQ-NO     
P00211        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
P00211        DISPLAY '*     PROCESSING TERMINATED            *'        
P00211        DISPLAY '********** PCSCA290 ABORT **************'        
P00211        PERFORM 9900-ABEND               THRU 9900-EXIT           
P00211     END-IF.                                                      
P00211                                                                  
P00211 7720-EXIT.                                                       
P00211     EXIT.                                                        
P00211                                                                  
P00269*****************************************************************         
P00269*                                                               *         
P00269* 7880-GET-OFFR-OPT-START-DT                                    *         
P00269*****************************************************************         
P00269 7880-GET-OFFR-OPT-START-DT.                                      
P00269                                                                  
P00269     EXEC SQL                                                     
P00269        SELECT TOP(1) E9.OFFER_OPT_START_DT,
              E9.OFF_OPT_VRSN_NO                                 
P00269          INTO :DF-OFFER-OPT-START-DT                             
P00473              ,:DF-OFF-OPT-VRSN-NO                                
P00269          FROM CRM_OFFER_OPTION E9 WITH(READUNCOMMITTED)                  
P00269         WHERE E9.OFFER_CD  = :E9-OFFER-CD                        
P00269           AND E9.OPTION_CD = :E9-OPTION-CD                       
P00473           AND E9.PROC_STATUS_CD      = 'AC'                      
P00473         ORDER BY E9.OFF_OPT_VSTART_TS DESC                       
P00269                                       
P00269     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT E9.OFFER_OPT_START_DT                                      
MFA-TR*             ,E9.OFF_OPT_VRSN_NO                                         
MFA-TR*         INTO :DF-OFFER-OPT-START-DT                                     
MFA-TR*             ,:DF-OFF-OPT-VRSN-NO                                        
MFA-TR*         FROM CRM_OFFER_OPTION E9                                        
MFA-TR*        WHERE E9.OFFER_CD  = :E9-OFFER-CD                                
MFA-TR*          AND E9.OPTION_CD = :E9-OPTION-CD                               
MFA-TR*          AND E9.PROC_STATUS_CD      = 'AC'                              
MFA-TR*        ORDER BY E9.OFF_OPT_VSTART_TS DESC                               
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00269                                                                  
P00269     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00269                                                                  
P00269     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00269        CONTINUE                                                  
P00269     ELSE                                                         
P00269        DISPLAY '********** PCSCA290 ABORT ****************'      
P00269        DISPLAY '**   ERROR ON 7880-GET-OFFR-OPT-START-DT'        
P00269        DISPLAY '**   OFFER_CD     = ' E9-OFFER-CD                
P00269        DISPLAY '**   OPTION_CD    = ' E9-OPTION-CD               
A04727        DISPLAY '**   SQL CODE     = ' WS-ACTIVE-RETURN-CODE      
A04727        DISPLAY '**   ACCT NO      = ' DF-ACCOUNT-NO              
P00269        DISPLAY '**       PROCESSING TERMINATED        **'        
P00269        DISPLAY '********** PCSCA290 ABORT **************'        
P00269        PERFORM 9900-ABEND                 THRU 9900-EXIT         
P00269     END-IF.                                                      
P00269                                                                  
P00269 7880-EXIT.                                                       
P00269     EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * 7900-SELECT-RESTART.                                           *        
      ******************************************************************        
       7900-SELECT-RESTART.                                             
           EXEC SQL                                                     
               SELECT RF.RESTART_DATA                                   
                 INTO :RF-RESTART-DATA                                  
                 FROM CSS_RESTART RF WITH(READUNCOMMITTED)                      
                WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                
                  AND RF.PARTITION_NO = :RF-PARTITION-NO                
                  AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RF.RESTART_DATA                                           
MFA-TR*          INTO :RF-RESTART-DATA                                          
MFA-TR*          FROM CSS_RESTART RF                                            
MFA-TR*         WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                        
MFA-TR*           AND RF.PARTITION_NO = :RF-PARTITION-NO                        
MFA-TR*           AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                        
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA290 ABORT **************'        
              DISPLAY '**   ERROR ON 7900-SELECT-RESTART     **'        
              DISPLAY '**   PROGRAM NAME = ' RF-NAME-PROGRAM            
              DISPLAY '**   PARTITION NO = ' RF-PARTITION-NO            
              DISPLAY '**   DUP CNTRL NO = ' RF-DUP-CNTRL-NO            
              DISPLAY '**   RETURN CODE  = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**       PROCESSING TERMINATED        **'        
              DISPLAY '********** PCSCA290 ABORT **************'        
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT361******************************************************************        
ACT361** UPDATE ACCOUNT TABLE                                         **        
ACT361******************************************************************        
ACT361*                                                                         
ACT361 8000-UPDATE-ACCOUNT.                                             
ACT361*                                                                         
ACT361     EXEC SQL                                                     
ACT361       UPDATE  CSS_ACCOUNT                                        
ACT361          SET  CODE_ACCT_BILLED  =  :AT-CODE-ACCT-BILLED          
ACT361        WHERE  ACCOUNT_NO        =  :AT-ACCOUNT-NO                
ACT361     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT361*                                                                         
ACT361     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
ACT361*                                                                         
ACT361     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT361        CONTINUE                                                  
ACT361     ELSE                                                         
ACT361        DISPLAY '********** PCSCA290 ABORT **************'        
ACT361        DISPLAY '*      8000-UPDATE-ACCOUNT             *'        
ACT361        DISPLAY '* ACCOUNT NO         : ' AT-ACCOUNT-NO           
ACT361        DISPLAY '* CODE ACCT BILLED   : ' AT-CODE-ACCT-BILLED     
ACT361        DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
ACT361        DISPLAY '*     PROCESSING TERMINATED            *'        
ACT361        DISPLAY '********** PCSCA290 ABORT **************'        
ACT361        PERFORM 9900-ABEND         THRU 9900-EXIT                 
ACT361     END-IF.                                                      
ACT361*                                                                         
ACT361 8000-EXIT.                                                       
ACT361     EXIT.                                                        
ACT361*                                                                         
ACT361******************************************************************        
I00251*                                                                *        
I00251* 8020-UPD-ACCT-RTPKG-AGR.                                       *        
I00251* UPDATE STATUS TO 'DROPPED / EXPIRED'                           *        
I00251******************************************************************        
I00251 8020-UPD-ACCT-RTPKG-AGR.                                         
I00251*                                                                         
I00251     EXEC SQL                                                     
I00251          UPDATE DF                              
I00251             SET DF.STATUS_CD          = :DF-STATUS-CD            
I00251                ,DF.STATUS_EFF_REV_MTH = :DF-STATUS-EFF-REV-MTH   
I00251                ,DF.LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()        
                FROM CSS_ACCT_RTPK_AGR DF
I00251           WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO           
I00251             AND DF.CODE_UTIL_TYPE     = :DF-CODE-UTIL-TYPE       
I00251             AND DF.IC_NO              = :DF-IC-NO                
I00251             AND DF.RT_PKG_OPT_SEQ_NO  = :DF-RT-PKG-OPT-SEQ-NO    
I00251     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_ACCT_RTPK_AGR DF                                     
MFA-TR*            SET DF.STATUS_CD          = :DF-STATUS-CD                    
MFA-TR*               ,DF.STATUS_EFF_REV_MTH = :DF-STATUS-EFF-REV-MTH           
MFA-TR*               ,DF.LAST_UPDATE_TS     = CURRENT TIMESTAMP                
MFA-TR*          WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO                   
MFA-TR*            AND DF.CODE_UTIL_TYPE     = :DF-CODE-UTIL-TYPE               
MFA-TR*            AND DF.IC_NO              = :DF-IC-NO                        
MFA-TR*            AND DF.RT_PKG_OPT_SEQ_NO  = :DF-RT-PKG-OPT-SEQ-NO            
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00251                                                                  
I00251     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE            
I00251     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
I00251        CONTINUE                                                  
I00251     ELSE                                                         
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        DISPLAY '*       8020-UPD-ACCT-RTPKG-AGR        *'        
I00251        DISPLAY '* ACCOUNT NO         : ' DF-ACCOUNT-NO           
I00251        DISPLAY '* CODE UTIL TYPE     : ' DF-CODE-UTIL-TYPE       
I00251        DISPLAY '* IC NO              : ' DF-IC-NO                
I00251        DISPLAY '* RT PKG OPT SEQ NO  : ' DF-RT-PKG-OPT-SEQ-NO    
I00251        DISPLAY '* STATUS CD          : ' DF-STATUS-CD            
I00251        DISPLAY '* STATUS EFF REV MTH : ' DF-STATUS-EFF-REV-MTH   
I00251        DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
I00251        DISPLAY '*     PROCESSING TERMINATED            *'        
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        PERFORM 9900-ABEND         THRU 9900-EXIT                 
I00251     END-IF.                                                      
I00251                                                                  
I00251 8020-EXIT.                                                       
I00251     EXIT.                                                        
I00251                                                                  
I00251******************************************************************        
I00251*                                                                *        
I00251* 8025-INS-ACCT-RTPK-AGR.                                        *        
I00251* INSERT A ROW IN CSS_ACCT_RTPK_AGR TABLE FOR NEW RT-PKG-SEQ-NO  *        
I00251******************************************************************        
I00251 8025-INS-ACCT-RTPK-AGR.                                          
I00251*                                                                         
I00251     EXEC SQL                                                     
I00251          INSERT INTO CSS_ACCT_RTPK_AGR                           
I00251               ( ACCOUNT_NO                                       
I00251                ,CODE_UTIL_TYPE                                   
I00251                ,IC_NO                                            
I00251                ,RT_PKG_OPT_SEQ_NO                                
I00251                ,TRANS_SEQ_ID                                     
I00251                ,OFFER_CD                                         
I00251                ,OPTION_CD                                        
I00251                ,PROMO_CD                                         
I00251                ,STATUS_CD                                        
I00251                ,COMM_CHANNEL                                     
I00251                ,CREATED_USERID                                   
I00251                ,LAST_UPDATE_USERID                               
I00251                ,OPT_AGRMT_EFF_DT                                 
I00251                ,OPT_AGRMT_EFF_TM                                 
I00251                ,CREATED_TS                                       
I00251                ,LAST_UPDATE_TS                                   
I00251                ,COMPANY_NO                                       
I00251                ,STATUS_EFF_REV_MTH                               
I00251                ,AGREEMNT_SOURCE_CD                               
I00251                ,ADJ_TIER_SEQ_NO                                  
P00473                ,OFFER_OPT_START_DT                               
P00473                ,OFF_OPT_VRSN_NO   )                              
I00251          VALUES                                                  
I00251               ( :DF-ACCOUNT-NO                                   
I00251                ,:DF-CODE-UTIL-TYPE                               
I00251                ,:DF-IC-NO                                        
I00251                ,:DF-RT-PKG-OPT-SEQ-NO                            
I00251                ,:DF-TRANS-SEQ-ID                                 
I00251                ,:DF-OFFER-CD                                     
I00251                ,:DF-OPTION-CD                                    
I00251                ,:DF-PROMO-CD                                     
I00251                ,:DF-STATUS-CD                                    
I00251                ,:DF-COMM-CHANNEL                                 
I00251                ,:DF-CREATED-USERID                               
I00251                ,:DF-LAST-UPDATE-USERID                           
I00251                , CAST(SYSDATETIMEOFFSET() AS DATE)                       
I00251                , CIS.CURRENT$TIME()                                    
I00251                , CIS.CURRENT$TIMESTAMP()                               
I00251                , CIS.CURRENT$TIMESTAMP()                               
I00251                ,:DF-COMPANY-NO                                   
I00251                ,:DF-STATUS-EFF-REV-MTH                           
I00251                ,:DF-AGREEMNT-SOURCE-CD                           
I00251                ,:DF-ADJ-TIER-SEQ-NO                              
P00473                ,IIF(TRY_CONVERT(DATE, :DF-OFFER-OPT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OFFER-OPT-START-DT
              ) <> 0) OR (LEN(:DF-OFFER-OPT-START-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OFFER-OPT-START-DT
              ), CONVERT(DATE, :DF-OFFER-OPT-START-DT) )                       
P00473                ,:DF-OFF-OPT-VRSN-NO    )                         
I00251     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_ACCT_RTPK_AGR                                   
MFA-TR*              ( ACCOUNT_NO                                               
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,IC_NO                                                    
MFA-TR*               ,RT_PKG_OPT_SEQ_NO                                        
MFA-TR*               ,TRANS_SEQ_ID                                             
MFA-TR*               ,OFFER_CD                                                 
MFA-TR*               ,OPTION_CD                                                
MFA-TR*               ,PROMO_CD                                                 
MFA-TR*               ,STATUS_CD                                                
MFA-TR*               ,COMM_CHANNEL                                             
MFA-TR*               ,CREATED_USERID                                           
MFA-TR*               ,LAST_UPDATE_USERID                                       
MFA-TR*               ,OPT_AGRMT_EFF_DT                                         
MFA-TR*               ,OPT_AGRMT_EFF_TM                                         
MFA-TR*               ,CREATED_TS                                               
MFA-TR*               ,LAST_UPDATE_TS                                           
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,STATUS_EFF_REV_MTH                                       
MFA-TR*               ,AGREEMNT_SOURCE_CD                                       
MFA-TR*               ,ADJ_TIER_SEQ_NO                                          
MFA-TR*               ,OFFER_OPT_START_DT                                       
MFA-TR*               ,OFF_OPT_VRSN_NO   )                                      
MFA-TR*         VALUES                                                          
MFA-TR*              ( :DF-ACCOUNT-NO                                           
MFA-TR*               ,:DF-CODE-UTIL-TYPE                                       
MFA-TR*               ,:DF-IC-NO                                                
MFA-TR*               ,:DF-RT-PKG-OPT-SEQ-NO                                    
MFA-TR*               ,:DF-TRANS-SEQ-ID                                         
MFA-TR*               ,:DF-OFFER-CD                                             
MFA-TR*               ,:DF-OPTION-CD                                            
MFA-TR*               ,:DF-PROMO-CD                                             
MFA-TR*               ,:DF-STATUS-CD                                            
MFA-TR*               ,:DF-COMM-CHANNEL                                         
MFA-TR*               ,:DF-CREATED-USERID                                       
MFA-TR*               ,:DF-LAST-UPDATE-USERID                                   
MFA-TR*               , CURRENT DATE                                            
MFA-TR*               , CURRENT TIME                                            
MFA-TR*               , CURRENT TIMESTAMP                                       
MFA-TR*               , CURRENT TIMESTAMP                                       
MFA-TR*               ,:DF-COMPANY-NO                                           
MFA-TR*               ,:DF-STATUS-EFF-REV-MTH                                   
MFA-TR*               ,:DF-AGREEMNT-SOURCE-CD                                   
MFA-TR*               ,:DF-ADJ-TIER-SEQ-NO                                      
MFA-TR*               ,:DF-OFFER-OPT-START-DT                                   
MFA-TR*               ,:DF-OFF-OPT-VRSN-NO    )                                 
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00251                                                                  
I00251     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE            
I00251     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
I00251        CONTINUE                                                  
I00251     ELSE                                                         
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        DISPLAY '*       8025-INS-ACCT-RTPK-AGR         *'        
I00251        DISPLAY '* ACCOUNT_NO        : ' DF-ACCOUNT-NO            
I00251        DISPLAY '* CODE_UTIL_TYPE    : ' DF-CODE-UTIL-TYPE        
I00251        DISPLAY '* IC_NO             : ' DF-IC-NO                 
I00251        DISPLAY '* RT_PKG_OPT_SEQ_NO : ' DF-RT-PKG-OPT-SEQ-NO     
I00251        DISPLAY '* OFFER_CD          : ' DF-OFFER-CD              
I00251        DISPLAY '* OPTION_CD         : ' DF-OPTION-CD             
I00251        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
I00251        DISPLAY '*     PROCESSING TERMINATED            *'        
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        PERFORM 9900-ABEND         THRU 9900-EXIT                 
I00251     END-IF.                                                      
I00251                                                                  
I00251 8025-EXIT.                                                       
I00251     EXIT.                                                        
I00251                                                                  
I00251******************************************************************        
I00251*                                                                *        
I00251* 8030-UPD-UTIL-ENVRNMT.                                         *        
I00251* UPDATE NEW RT-PKG-SEQ-NO IN CSS_UTIL_ENVRNMT TABLE             *        
I00251******************************************************************        
I00251 8030-UPD-UTIL-ENVRNMT.                                           
I00251*                                                                         
I00251     EXEC SQL                                                     
I00251          UPDATE UT                               
I00251             SET UT.RT_PKG_OPT_SEQ_NO = :UT-RT-PKG-OPT-SEQ-NO     
I00251                ,UT.RATE_PLAN_NO      = :UT-RATE-PLAN-NO          
                FROM CSS_UTIL_ENVRNMT UT
I00251           WHERE UT.ACCOUNT_NO        = :UT-ACCOUNT-NO            
I00251             AND UT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE        
I00251             AND UT.IC_NO             = :UT-IC-NO                 
I00251     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_UTIL_ENVRNMT UT                                      
MFA-TR*            SET UT.RT_PKG_OPT_SEQ_NO = :UT-RT-PKG-OPT-SEQ-NO             
MFA-TR*               ,UT.RATE_PLAN_NO      = :UT-RATE-PLAN-NO                  
MFA-TR*          WHERE UT.ACCOUNT_NO        = :UT-ACCOUNT-NO                    
MFA-TR*            AND UT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE                
MFA-TR*            AND UT.IC_NO             = :UT-IC-NO                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00251                                                                  
I00251     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE            
I00251     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
I00251         CONTINUE                                                 
I00251     ELSE                                                         
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        DISPLAY '*        8030-UPD-UTIL-ENVRNMT         *'        
I00251        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
I00251        DISPLAY '* ACCOUNT_NO        : ' UT-ACCOUNT-NO            
I00251        DISPLAY '* CODE_UTIL_TYPE    : ' UT-CODE-UTIL-TYPE        
I00251        DISPLAY '* IC_NO             : ' UT-IC-NO                 
I00251        DISPLAY '* RATE_PLAN_NO      : ' UT-RATE-PLAN-NO          
I00251        DISPLAY '* RT_PKG_OPT_SEQ_NO : ' UT-RT-PKG-OPT-SEQ-NO     
I00251        DISPLAY '*     PROCESSING TERMINATED            *'        
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        PERFORM 9900-ABEND         THRU 9900-EXIT                 
I00251     END-IF.                                                      
I00251                                                                  
I00251 8030-EXIT.                                                       
I00251     EXIT.                                                        
I00251                                                                  
I00251******************************************************************        
I00251*                                                                *        
I00251* 8035-UPD-BILLING-DET.                                          *        
I00251* UPDATE RATE PLAN AND NEW RT-PKG-SEQ-NO IN CSS_BILLING_DET      *        
I00251******************************************************************        
I00251 8035-UPD-BILLING-DET.                                            
I00251*                                                                         
I00251     EXEC SQL                                                     
I00251          UPDATE BG                                
I00251             SET BG.RT_PKG_OPT_SEQ_NO  = :BG-RT-PKG-OPT-SEQ-NO    
I00251                ,BG.RATE_PLAN_NO       = :BG-RATE-PLAN-NO         
                FROM CSS_BILLING_DET BG
I00251           WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO           
I00251             AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE       
I00251             AND BG.IC_NO              = :BG-IC-NO                
I00251             AND BG.CODE_BILL_CALC     = :WS-NORMAL-BILL          
I00251             AND BG.CODE_BILL_ITM_TYPE = :WS-CURRENT              
I00251             AND BG.CODE_BILL_ITM_IND  = :WS-ACTIVE               
I00251             AND BG.REVENUE_MONTH      = 0                        
I00251             AND BG.DATE_ORIG_BILL     IS NULL                    
I00251     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_BILLING_DET BG                                       
MFA-TR*            SET BG.RT_PKG_OPT_SEQ_NO  = :BG-RT-PKG-OPT-SEQ-NO            
MFA-TR*               ,BG.RATE_PLAN_NO       = :BG-RATE-PLAN-NO                 
MFA-TR*          WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO                   
MFA-TR*            AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE               
MFA-TR*            AND BG.IC_NO              = :BG-IC-NO                        
MFA-TR*            AND BG.CODE_BILL_CALC     = :WS-NORMAL-BILL                  
MFA-TR*            AND BG.CODE_BILL_ITM_TYPE = :WS-CURRENT                      
MFA-TR*            AND BG.CODE_BILL_ITM_IND  = :WS-ACTIVE                       
MFA-TR*            AND BG.REVENUE_MONTH      = 0                                
MFA-TR*            AND BG.DATE_ORIG_BILL     IS NULL                            
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00251                                                                  
I00251     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE            
I00251     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
I00251                                 OR NOT-FOUND                     
I00251        CONTINUE                                                  
I00251     ELSE                                                         
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        DISPLAY '*       8035-UPD-BILLING-DET           *'        
I00251        DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
I00251        DISPLAY '* ACCOUNT_NO         : ' BG-ACCOUNT-NO           
I00251        DISPLAY '* CODE_UTIL_TYPE     : ' BG-CODE-UTIL-TYPE       
I00251        DISPLAY '* IC_NO              : ' BG-IC-NO                
I00251        DISPLAY '* CODE_BILL_CALC     : ' WS-NORMAL-BILL          
I00251        DISPLAY '* CODE_BILL_ITM_TYPE : ' WS-CURRENT              
I00251        DISPLAY '* CODE_BILL_ITM_IND  : ' WS-ACTIVE               
I00251        DISPLAY '* RT_PKG_OPT_SEQ_NO  : ' BG-RT-PKG-OPT-SEQ-NO    
I00251        DISPLAY '* RATE_PLAN_NO       : ' BG-RATE-PLAN-NO         
I00251        DISPLAY '*     PROCESSING TERMINATED            *'        
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        PERFORM 9900-ABEND         THRU 9900-EXIT                 
I00251     END-IF.                                                      
I00251                                                                  
I00251 8035-EXIT.                                                       
I00251     EXIT.                                                        
I00251                                                                  
I00251******************************************************************        
I00251*                                                                *        
I00251* 8040-UPD-SR-FLAG.                                              *        
I00251* UPDATE SENIOR FLAG IN CSS_REG_PROFILE                          *        
I00251******************************************************************        
I00251 8040-UPD-SR-FLAG.                                                
I00251*                                                                         
I00251     EXEC SQL                                                     
I00251        UPDATE CSS_REG_PROFILE                                    
I00251           SET SENIOR_FL      = :LR-SENIOR-FL                     
I00251              ,LAST_UPDATE_TS = CIS.CURRENT$TIMESTAMP()                 
I00251         WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                        
I00251     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_REG_PROFILE                                            
MFA-TR*          SET SENIOR_FL      = :LR-SENIOR-FL                             
MFA-TR*             ,LAST_UPDATE_TS = CURRENT TIMESTAMP                         
MFA-TR*        WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00251                                                                  
I00251     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE            
I00251                                                                  
I00251     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
I00251                                 OR NOT-FOUND                     
I00251        CONTINUE                                                  
I00251     ELSE                                                         
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        DISPLAY '*         8040-UPD-SR-FLAG             *'        
I00251        DISPLAY '* ACCOUNT_NO     : ' LR-ACCOUNT-NO               
I00251        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
I00251        DISPLAY '*     PROCESSING TERMINATED            *'        
I00251        DISPLAY '********** PCSCA290 ABORT **************'        
I00251        PERFORM 9900-ABEND         THRU 9900-EXIT                 
I00251     END-IF.                                                      
I00251                                                                  
I00251 8040-EXIT.                                                       
I00251     EXIT.                                                        
I00251                                                                  
P00211******************************************************************        
P00211*                                                                *        
P00211* 8045-UPDATE-DF-EFF-REV-MTH.                                    *        
P00211* UPDATE STATUS EFFECTIVE REVENUE MONTH OF PENDING OPTION        *        
P00211******************************************************************        
P00211 8045-UPDATE-DF-EFF-REV-MTH.                                      
P00211*                                                                         
P00211     EXEC SQL                                                     
P00211          UPDATE DF                              
P00211             SET DF.STATUS_EFF_REV_MTH = :DF-STATUS-EFF-REV-MTH   
P00211                ,DF.LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()        
                FROM CSS_ACCT_RTPK_AGR DF
P00211           WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO           
P00211             AND DF.CODE_UTIL_TYPE     = :DF-CODE-UTIL-TYPE       
P00211             AND DF.IC_NO              = :DF-IC-NO                
P00211             AND DF.RT_PKG_OPT_SEQ_NO  = :DF-RT-PKG-OPT-SEQ-NO    
P00211     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_ACCT_RTPK_AGR DF                                     
MFA-TR*            SET DF.STATUS_EFF_REV_MTH = :DF-STATUS-EFF-REV-MTH           
MFA-TR*               ,DF.LAST_UPDATE_TS     = CURRENT TIMESTAMP                
MFA-TR*          WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO                   
MFA-TR*            AND DF.CODE_UTIL_TYPE     = :DF-CODE-UTIL-TYPE               
MFA-TR*            AND DF.IC_NO              = :DF-IC-NO                        
MFA-TR*            AND DF.RT_PKG_OPT_SEQ_NO  = :DF-RT-PKG-OPT-SEQ-NO            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00211                                                                  
P00211     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
P00211     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00211        CONTINUE                                                  
P00211     ELSE                                                         
P00211        DISPLAY '********** PCSCA290 ABORT **************'        
P00211        DISPLAY '*       8045-UPD-ACCT-RTPKG-AGR        *'        
P00211        DISPLAY '* ACCOUNT NO         : ' DF-ACCOUNT-NO           
P00211        DISPLAY '* CODE UTIL TYPE     : ' DF-CODE-UTIL-TYPE       
P00211        DISPLAY '* IC NO              : ' DF-IC-NO                
P00211        DISPLAY '* RT PKG OPT SEQ NO  : ' DF-RT-PKG-OPT-SEQ-NO    
P00211        DISPLAY '* STATUS EFF REV MTH : ' DF-STATUS-EFF-REV-MTH   
P00211        DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
P00211        DISPLAY '*     PROCESSING TERMINATED            *'        
P00211        DISPLAY '********** PCSCA290 ABORT **************'        
P00211        PERFORM 9900-ABEND         THRU 9900-EXIT                 
P00211     END-IF.                                                      
P00211                                                                  
P00211 8045-EXIT.                                                       
P00211     EXIT.                                                        
P00211                                                                  
P00211******************************************************************        
P00211*                                                                *        
P00211* 8050-UPDATE-FF-DATE-FROM.                                      *        
P00211* UPDATE EFFECTIVE DATE FROM OF THE PENDING OPTION FACTOR        *        
P00211******************************************************************        
P00211 8050-UPDATE-FF-DATE-FROM.                                        
P00211*                                                                         
P00211     EXEC SQL                                                     
P00211        UPDATE FF                                   
P00211           SET FF.EFF_DATE_FROM    = IIF(TRY_CONVERT(DATE, 
                                                      :FF-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FF-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FF-EFF-DATE-FROM
              ), CONVERT(DATE, :FF-EFF-DATE-FROM) )            
P00211              ,FF.LAST_UPDATE_TS   = CIS.CURRENT$TIMESTAMP()            
              FROM CSS_FIXED_FCTR FF
P00211         WHERE FF.ACCOUNT_NO           = :FF-ACCOUNT-NO           
P00211           AND FF.CODE_UTIL_TYPE       = :FF-CODE-UTIL-TYPE       
P00211           AND FF.IC_NO                = :FF-IC-NO                
P00211           AND FF.FACTOR_ID            = :FF-FACTOR-ID            
P00211           AND FF.FIXED_FCTR_SEQ_NO    = :FF-FIXED-FCTR-SEQ-NO    
P00211           AND FF.RT_PKG_OPT_SEQ_NO    = :FF-RT-PKG-OPT-SEQ-NO    
P00211     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_FIXED_FCTR FF                                          
MFA-TR*          SET FF.EFF_DATE_FROM    = :FF-EFF-DATE-FROM                    
MFA-TR*             ,FF.LAST_UPDATE_TS   = CURRENT TIMESTAMP                    
MFA-TR*        WHERE FF.ACCOUNT_NO           = :FF-ACCOUNT-NO                   
MFA-TR*          AND FF.CODE_UTIL_TYPE       = :FF-CODE-UTIL-TYPE               
MFA-TR*          AND FF.IC_NO                = :FF-IC-NO                        
MFA-TR*          AND FF.FACTOR_ID            = :FF-FACTOR-ID                    
MFA-TR*          AND FF.FIXED_FCTR_SEQ_NO    = :FF-FIXED-FCTR-SEQ-NO            
MFA-TR*          AND FF.RT_PKG_OPT_SEQ_NO    = :FF-RT-PKG-OPT-SEQ-NO            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00211                                                                  
P00211     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE            
P00211                                                                  
P00211     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00211        CONTINUE                                                  
P00211     ELSE                                                         
P00211        DISPLAY '********** PCSCA290 ABORT **************'        
P00211        DISPLAY '*      8050-UPDATE-FIXED-FCTR          *'        
P00211        DISPLAY '* ACCOUNT_NO           : ' FF-ACCOUNT-NO         
P00211        DISPLAY '* CODE_UTIL_TYPE       : ' FF-CODE-UTIL-TYPE     
P00211        DISPLAY '* IC_NO                : ' FF-IC-NO              
P00211        DISPLAY '* FF-FIXED-FCTR-SEQ-NO : ' FF-FIXED-FCTR-SEQ-NO  
P00211        DISPLAY '* FF-RT-PKG-OPT-SEQ-NO : ' FF-RT-PKG-OPT-SEQ-NO  
P00211        DISPLAY '* FACTOR_ID            : ' FF-FACTOR-ID          
P00211        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
P00211        DISPLAY '*     PROCESSING TERMINATED            *'        
P00211        DISPLAY '********** PCSCA290 ABORT **************'        
P00211        PERFORM 9900-ABEND         THRU 9900-EXIT                 
P00211     END-IF.                                                      
P00211                                                                  
P00211 8050-EXIT.                                                       
P00211     EXIT.                                                        
P00211                                                                  
P00211******************************************************************        
P00211*                                                                *        
P00211* 8060-UPDATE-FF-DATE-TO.                                        *        
P00211* UPDATE EFFECTIVE DATE TO OF THE CURRENT OPTION FACTOR          *        
P00211******************************************************************        
P00211 8060-UPDATE-FF-DATE-TO.                                          
P00211*                                                                         
P00211     EXEC SQL                                                     
P00211        UPDATE FF                                   
P00211           SET FF.EFF_DATE_TO      = IIF(TRY_CONVERT(DATE, 
                                                        :FF-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FF-EFF-DATE-TO
              ), CONVERT(DATE, :FF-EFF-DATE-TO) )              
P00211              ,FF.LAST_UPDATE_TS   = CIS.CURRENT$TIMESTAMP()            
              FROM CSS_FIXED_FCTR FF
P00211         WHERE FF.ACCOUNT_NO           = :FF-ACCOUNT-NO           
P00211           AND FF.CODE_UTIL_TYPE       = :FF-CODE-UTIL-TYPE       
P00211           AND FF.IC_NO                = :FF-IC-NO                
P00211           AND FF.FACTOR_ID            = :FF-FACTOR-ID            
P00211           AND FF.FIXED_FCTR_SEQ_NO    = :FF-FIXED-FCTR-SEQ-NO    
P00211           AND FF.RT_PKG_OPT_SEQ_NO    = :FF-RT-PKG-OPT-SEQ-NO    
P00211     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_FIXED_FCTR FF                                          
MFA-TR*          SET FF.EFF_DATE_TO      = :FF-EFF-DATE-TO                      
MFA-TR*             ,FF.LAST_UPDATE_TS   = CURRENT TIMESTAMP                    
MFA-TR*        WHERE FF.ACCOUNT_NO           = :FF-ACCOUNT-NO                   
MFA-TR*          AND FF.CODE_UTIL_TYPE       = :FF-CODE-UTIL-TYPE               
MFA-TR*          AND FF.IC_NO                = :FF-IC-NO                        
MFA-TR*          AND FF.FACTOR_ID            = :FF-FACTOR-ID                    
MFA-TR*          AND FF.FIXED_FCTR_SEQ_NO    = :FF-FIXED-FCTR-SEQ-NO            
MFA-TR*          AND FF.RT_PKG_OPT_SEQ_NO    = :FF-RT-PKG-OPT-SEQ-NO            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00211                                                                  
P00211     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
P00211                                                                  
P00211     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00211        CONTINUE                                                  
P00211     ELSE                                                         
P00211        DISPLAY '********** PCSCA290 ABORT **************'        
P00211        DISPLAY '*       8060-UPDATE-FF-DATE-TO         *'        
P00211        DISPLAY '* ACCOUNT_NO           : ' FF-ACCOUNT-NO         
P00211        DISPLAY '* CODE_UTIL_TYPE       : ' FF-CODE-UTIL-TYPE     
P00211        DISPLAY '* IC_NO                : ' FF-IC-NO              
P00211        DISPLAY '* FF-FIXED-FCTR-SEQ-NO : ' FF-FIXED-FCTR-SEQ-NO  
P00211        DISPLAY '* FF-RT-PKG-OPT-SEQ-NO : ' FF-RT-PKG-OPT-SEQ-NO  
P00211        DISPLAY '* FACTOR_ID            : ' FF-FACTOR-ID          
P00211        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
P00211        DISPLAY '*     PROCESSING TERMINATED            *'        
P00211        DISPLAY '********** PCSCA290 ABORT **************'        
P00211        PERFORM 9900-ABEND         THRU 9900-EXIT                 
P00211     END-IF.                                                      
P00211                                                                  
P00211 8060-EXIT.                                                       
P00211     EXIT.                                                        
P00211                                                                  
P00680******************************************************************        
P00680*                                                                *        
P00680* 8070-EXPIRE-UNUSED-FCTR.                                       *        
P00680* EXPIRE UNSED FIXED FACTORS FOR CURRENT OPTION.                 *        
P00680******************************************************************        
P00680 8070-EXPIRE-UNUSED-FCTR.                                         
P00680*                                                                         
P00680     EXEC SQL                                                     
P00680        UPDATE FF                                   
P00680           SET FF.EFF_DATE_TO        = IIF(TRY_CONVERT(DATE, 
                                                        :FF-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FF-EFF-DATE-TO
              ), CONVERT(DATE, :FF-EFF-DATE-TO) )            
P00680              ,FF.DURATION_REMAIN_NO = :FF-DURATION-REMAIN-NO 
                                             :WS-NULL-IND-06            
P00680              ,FF.LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()          
              FROM CSS_FIXED_FCTR FF
P00680         WHERE FF.ACCOUNT_NO         = :FF-ACCOUNT-NO             
P00680           AND FF.CODE_UTIL_TYPE     = :FF-CODE-UTIL-TYPE         
P00680           AND FF.IC_NO              = :FF-IC-NO                  
P00680           AND FF.FACTOR_ID          = :FF-FACTOR-ID              
P00680           AND FF.FIXED_FCTR_SEQ_NO  = :FF-FIXED-FCTR-SEQ-NO      
P00680           AND FF.RT_PKG_OPT_SEQ_NO  = :FF-RT-PKG-OPT-SEQ-NO      
P00680     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_FIXED_FCTR FF                                          
MFA-TR*          SET FF.EFF_DATE_TO        = :FF-EFF-DATE-TO                    
MFA-TR*             ,FF.DURATION_REMAIN_NO = :FF-DURATION-REMAIN-NO             
MFA-TR*                                      :WS-NULL-IND-06                    
MFA-TR*             ,FF.LAST_UPDATE_TS     = CURRENT TIMESTAMP                  
MFA-TR*        WHERE FF.ACCOUNT_NO         = :FF-ACCOUNT-NO                     
MFA-TR*          AND FF.CODE_UTIL_TYPE     = :FF-CODE-UTIL-TYPE                 
MFA-TR*          AND FF.IC_NO              = :FF-IC-NO                          
MFA-TR*          AND FF.FACTOR_ID          = :FF-FACTOR-ID                      
MFA-TR*          AND FF.FIXED_FCTR_SEQ_NO  = :FF-FIXED-FCTR-SEQ-NO              
MFA-TR*          AND FF.RT_PKG_OPT_SEQ_NO  = :FF-RT-PKG-OPT-SEQ-NO              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00680                                                                  
P00680     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
P00680                                                                  
P00680     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00680        CONTINUE                                                  
P00680     ELSE                                                         
P00680        DISPLAY '********** PCSCA290 ABORT **************'        
P00680        DISPLAY '*       8070-EXPIRE-UNUSED-FCTR.       *'        
P00680        DISPLAY '* ACCOUNT_NO           : ' FF-ACCOUNT-NO         
P00680        DISPLAY '* CODE_UTIL_TYPE       : ' FF-CODE-UTIL-TYPE     
P00680        DISPLAY '* IC_NO                : ' FF-IC-NO              
P00680        DISPLAY '* FF-FIXED-FCTR-SEQ-NO : ' FF-FIXED-FCTR-SEQ-NO  
P00680        DISPLAY '* FF-RT-PKG-OPT-SEQ-NO : ' FF-RT-PKG-OPT-SEQ-NO  
P00680        DISPLAY '* FACTOR_ID            : ' FF-FACTOR-ID          
P00680        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
P00680        DISPLAY '*     PROCESSING TERMINATED            *'        
P00680        DISPLAY '********** PCSCA290 ABORT **************'        
P00680        PERFORM 9900-ABEND         THRU 9900-EXIT                 
P00680     END-IF.                                                      
P00680                                                                  
P00680 8070-EXIT.                                                       
P00680     EXIT.                                                        
P00680                                                                  
A00388******************************************************************        
A00388** UPDATE CSS_FIXED_FCTR WITH CALCULATED SEABLK FACTOR          **        
A00388******************************************************************        
A00388*                                                                         
A00388 8100-UPDATE-FIXED-FCTR.                                          
A00388*                                                                         
A00388     EXEC SQL                                                     
A00388       UPDATE  FF                                   
A00388          SET  FF.FACTOR             =  :FF-FACTOR                
             FROM CSS_FIXED_FCTR FF
A00388        WHERE  FF.ACCOUNT_NO         =  :FF-ACCOUNT-NO            
A00388          AND  FF.CODE_UTIL_TYPE     =  :FF-CODE-UTIL-TYPE        
A00388          AND  FF.IC_NO              =  :FF-IC-NO                 
A00388          AND  FF.FIXED_FCTR_SEQ_NO  =  :FF-FIXED-FCTR-SEQ-NO     
A00388          AND  FF.FACTOR_ID          =  :FF-FACTOR-ID             
A00388     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE  CSS_FIXED_FCTR  FF                                         
MFA-TR*         SET  FF.FACTOR             =  :FF-FACTOR                        
MFA-TR*       WHERE  FF.ACCOUNT_NO         =  :FF-ACCOUNT-NO                    
MFA-TR*         AND  FF.CODE_UTIL_TYPE     =  :FF-CODE-UTIL-TYPE                
MFA-TR*         AND  FF.IC_NO              =  :FF-IC-NO                         
MFA-TR*         AND  FF.FIXED_FCTR_SEQ_NO  =  :FF-FIXED-FCTR-SEQ-NO             
MFA-TR*         AND  FF.FACTOR_ID          =  :FF-FACTOR-ID                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00388*                                                                         
A00388     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
A00388*                                                                         
A00388     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A00388        CONTINUE                                                  
A00388     ELSE                                                         
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        DISPLAY '*      8100-UPDATE-FIXED-FCTR          *'        
A00388        DISPLAY '* ACCOUNT NO         : ' FF-ACCOUNT-NO           
A00388        DISPLAY '* CODE UTIL TYPE     : ' FF-CODE-UTIL-TYPE       
A00388        DISPLAY '* IC NO              : ' FF-IC-NO                
A00388        DISPLAY '* FIXED FCTR SEQ NO  : ' FF-FIXED-FCTR-SEQ-NO    
A00388        DISPLAY '* FACTOR ID          : ' FF-FACTOR-ID            
A00388        DISPLAY '* FACTOR             : ' FF-FACTOR               
A00388        DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
A00388        DISPLAY '*     PROCESSING TERMINATED            *'        
A00388        DISPLAY '********** PCSCA290 ABORT **************'        
A00388        PERFORM 9900-ABEND         THRU 9900-EXIT                 
A00388     END-IF.                                                      
A00388*                                                                         
A00388 8100-EXIT.                                                       
A00388     EXIT.                                                        
A00388*                                                                         
A04727******************************************************************        
A04727*                                                                *        
A04727* 8200-INSRT-FIXED-FCTR.                                      *           
A04727******************************************************************        
A04727 8200-INSRT-FIXED-FCTR.                                           
A04727                                                                  
A04727     EXEC SQL                                                     
A04727          INSERT INTO CSS_FIXED_FCTR                              
A04727               ( ACCOUNT_NO                                       
A04727                ,CODE_UTIL_TYPE                                   
A04727                ,IC_NO                                            
A04727                ,FIXED_FCTR_SEQ_NO                                
A04727                ,FACTOR_ID                                        
A04727                ,EFF_DATE_FROM                                    
A04727                ,CMPNT_ID_CD                                      
A04727                ,CODE_SEASON                                      
A04727                ,INSTR_USE_TYPE_CD                                
A04727                ,CODE_TIME_PERIOD                                 
A04727                ,EFF_DATE_TO                                      
A04727                ,FIXED_FCTR_TYP_CD                                
A04727                ,FACTOR                                           
A04727                ,FAC_CHRG_BASE_AM                                 
A04727                ,LAST_UPDATE_TS                                   
A04727                ,DURATION_REMAIN_NO                               
A04727                ,RT_PKG_OPT_SEQ_NO                                
A04727                ,BLOCK_NO )                                       
A04727          VALUES                                                  
A04727               ( :FF-ACCOUNT-NO                                   
A04727                ,:FF-CODE-UTIL-TYPE                               
A04727                ,:FF-IC-NO                                        
A04727                ,:FF-FIXED-FCTR-SEQ-NO                            
A04727                ,:FF-FACTOR-ID                                    
A04727                ,IIF(TRY_CONVERT(DATE, :FF-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FF-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FF-EFF-DATE-FROM
              ), CONVERT(DATE, :FF-EFF-DATE-FROM) )                            
A04727                ,:FF-CMPNT-ID-CD                                  
A04727                ,:FF-CODE-SEASON                                  
A04727                ,:FF-INSTR-USE-TYPE-CD                            
A04727                ,:FF-CODE-TIME-PERIOD                             
A04727                ,IIF(TRY_CONVERT(DATE, :FF-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FF-EFF-DATE-TO
              ), CONVERT(DATE, :FF-EFF-DATE-TO) )                              
A04727                ,:FF-FIXED-FCTR-TYP-CD                            
A04727                ,:FF-FACTOR                                       
A04727                ,:FF-FAC-CHRG-BASE-AM                             
A04727                ,CIS.CURRENT$TIMESTAMP()                                
A04727                ,:FF-DURATION-REMAIN-NO                           
A04727                ,:FF-RT-PKG-OPT-SEQ-NO                            
A04727                ,:FF-BLOCK-NO )                                   
A04727     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_FIXED_FCTR                                      
MFA-TR*              ( ACCOUNT_NO                                               
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,IC_NO                                                    
MFA-TR*               ,FIXED_FCTR_SEQ_NO                                        
MFA-TR*               ,FACTOR_ID                                                
MFA-TR*               ,EFF_DATE_FROM                                            
MFA-TR*               ,CMPNT_ID_CD                                              
MFA-TR*               ,CODE_SEASON                                              
MFA-TR*               ,INSTR_USE_TYPE_CD                                        
MFA-TR*               ,CODE_TIME_PERIOD                                         
MFA-TR*               ,EFF_DATE_TO                                              
MFA-TR*               ,FIXED_FCTR_TYP_CD                                        
MFA-TR*               ,FACTOR                                                   
MFA-TR*               ,FAC_CHRG_BASE_AM                                         
MFA-TR*               ,LAST_UPDATE_TS                                           
MFA-TR*               ,DURATION_REMAIN_NO                                       
MFA-TR*               ,RT_PKG_OPT_SEQ_NO                                        
MFA-TR*               ,BLOCK_NO )                                               
MFA-TR*         VALUES                                                          
MFA-TR*              ( :FF-ACCOUNT-NO                                           
MFA-TR*               ,:FF-CODE-UTIL-TYPE                                       
MFA-TR*               ,:FF-IC-NO                                                
MFA-TR*               ,:FF-FIXED-FCTR-SEQ-NO                                    
MFA-TR*               ,:FF-FACTOR-ID                                            
MFA-TR*               ,:FF-EFF-DATE-FROM                                        
MFA-TR*               ,:FF-CMPNT-ID-CD                                          
MFA-TR*               ,:FF-CODE-SEASON                                          
MFA-TR*               ,:FF-INSTR-USE-TYPE-CD                                    
MFA-TR*               ,:FF-CODE-TIME-PERIOD                                     
MFA-TR*               ,:FF-EFF-DATE-TO                                          
MFA-TR*               ,:FF-FIXED-FCTR-TYP-CD                                    
MFA-TR*               ,:FF-FACTOR                                               
MFA-TR*               ,:FF-FAC-CHRG-BASE-AM                                     
MFA-TR*               ,CURRENT TIMESTAMP                                        
MFA-TR*               ,:FF-DURATION-REMAIN-NO                                   
MFA-TR*               ,:FF-RT-PKG-OPT-SEQ-NO                                    
MFA-TR*               ,:FF-BLOCK-NO )                                           
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04727                                                                  
A04727     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
A04727                                                                  
A04727     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A04727        CONTINUE                                                  
A04727     ELSE                                                         
A04727        DISPLAY '********** PCSCA290 ABORT **************'        
A04727        DISPLAY '*       8200-INSRT-NW-FIXED-FCTR.      *'        
A04727        DISPLAY '* ACCOUNT_NO        : ' FF-ACCOUNT-NO            
A04727        DISPLAY '* CODE_UTIL_TYPE    : ' FF-CODE-UTIL-TYPE        
A04727        DISPLAY '* IC_NO             : ' FF-IC-NO                 
A04727        DISPLAY '* RT_PKG_OPT_SEQ_NO : ' FF-RT-PKG-OPT-SEQ-NO     
A04727        DISPLAY '* OPTION_CD         : ' HQ-OPTION-CD             
A04727        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
A04727        DISPLAY '*     PROCESSING TERMINATED            *'        
A04727        DISPLAY '********** PCSCA290 ABORT **************'        
A04727        PERFORM 9900-ABEND         THRU 9900-EXIT                 
A04727     END-IF.                                                      
A04727                                                                  
A04727 8200-EXIT.                                                       
A04727     EXIT.                                                        
A04727                                                                  
      ******************************************************************        
      *                                                                *        
      * 8800-WRITE-RESTART                                             *        
      ******************************************************************        
       8800-WRITE-RESTART.                                              
                                                                        
           MOVE WS-PGRMNAME                      TO RF-NAME-PROGRAM     
ACT361     MOVE WS-PARTITION-NO                  TO RF-PARTITION-NO     
           MOVE 1                                TO RF-DUP-CNTRL-NO     
           MOVE WS-RESTART-DATA                  TO                     
                                                 RF-RESTART-DATA-TEXT   
           MOVE WS-RESTART-DATA-LENGTH           TO RF-RESTART-DATA-LEN 
                                                                        
           PERFORM 8850-UPDATE-RESTART           THRU 8850-EXIT         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 8860-INSERT-RESTART        THRU 8860-EXIT         
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8850-UPDATE-RESTART.                                           *        
      ******************************************************************        
       8850-UPDATE-RESTART.                                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_RESTART                                       
                  SET RESTART_DATA = :RF-RESTART-DATA                   
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                   
                  AND PARTITION_NO = :RF-PARTITION-NO                   
                  AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO  WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA290 ABORT **************'        
              DISPLAY '*        8850-UPDATE-RESTART           *'        
              DISPLAY '* NAME_PROGRAM   : ' RF-NAME-PROGRAM             
              DISPLAY '* DUP_CNTRL_NO   : ' RF-DUP-CNTRL-NO             
              DISPLAY '* PARTITION_NO   : ' RF-PARTITION-NO             
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA290 ABORT **************'        
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF.                                                      
                                                                        
       8850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8860-INSERT-RESTART.                                           *        
      ******************************************************************        
       8860-INSERT-RESTART.                                             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_RESTART                                  
                     ( NAME_PROGRAM                                     
                      ,PARTITION_NO                                     
                      ,DUP_CNTRL_NO                                     
                      ,RESTART_DATA)                                    
               VALUES(:RF-NAME-PROGRAM                                  
                     ,:RF-PARTITION-NO                                  
                     ,:RF-DUP-CNTRL-NO                                  
                     ,:RF-RESTART-DATA)                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO  WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA290 ABORT **************'        
              DISPLAY '*       8860-INSERT-RESTART            *'        
              DISPLAY '* NAME_PROGRAM   : ' RF-NAME-PROGRAM             
              DISPLAY '* DUP_CNTRL_NO   : ' RF-DUP-CNTRL-NO             
              DISPLAY '* PARTITION_NO   : ' RF-PARTITION-NO             
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA290 ABORT **************'        
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF.                                                      
                                                                        
       8860-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8888-COMMIT.                                                   *        
      ******************************************************************        
       8888-COMMIT.                                                     
                                                                        
           IF WS-CHKP-LUW-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS       
              AND WS-CHKP-UPD-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS   
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 8800-WRITE-RESTART         THRU 8800-EXIT         
                                                                        
              EXEC SQL                                                  
                  COMMIT                                                
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              DISPLAY 'COMMIT POINT # ' WS-CHKP-SEQ-NO ' TAKEN.'        
           END-IF.                                                      
                                                                        
       8888-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8893-RESET-RESTART-REQ-PARM                                    *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00029                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *                                                                *        
      *  8895-INSERT-WORK-QUEUE                                        *        
      ******************************************************************        
ACT068 8895-INSERT-WORK-QUEUE.                                          
ACT068*                                                                *        
ACT068     MOVE SPACES                       TO ABEND-FUNCTION.         
ACT068     CALL SCSCB077  USING   CWS00077-FIELDS,                      
ACT068                            ABEND-FILE,                           
ACT068                            RS-RETURN-CODE.                       
ACT068                                                                  
ACT068      MOVE RS-RETURN-CODE              TO WS-ACTIVE-RETURN-CODE.  
ACT068                                                                  
ACT068      IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0        
ACT068         MOVE PROGRAM-NAME             TO   ABEND-PROGRAM         
ACT068         DISPLAY '8895-INSERT-WORK-QUEUE'                         
ACT068         DISPLAY 'CALL SCSCB077         '                         
ACT068         DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO              
ACT068         DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO              
ACT068         DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO           
ACT068         DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE         
ACT068         PERFORM 9900-ABEND             THRU 9900-EXIT            
ACT068     END-IF.                                                      
ACT068*                                                                         
ACT068 8895-EXIT.                                                       
ACT068     EXIT.                                                        
      *****************************************************************         
      * APPL 765 - ADD DUMMY STATEMENT TO FIX ISSUE TRANS HIST CPYC   *         
      * 9000-TERMINATE.                                               *         
      *****************************************************************         
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           GO TO 9000-EXIT.                                             
                                                                        
      *****************************************************************         
      *                                                               *         
      * 9000-TERMINATE.                                               *         
      *****************************************************************         
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSDB07-FILE.                                          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6240-GET-FCA00-COMMON-DATE.                                   *         
      *****************************************************************         
           COPY CPD00040.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6241-GET-FCA00-BILL-CYCLES.                                   *         
      *****************************************************************         
       COPY CPD00041.                                                           
                                                                        
      *****************************************************************         
      *                                                               *         
      *  6251-GET-FJC01-DATE.                                         *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE CPD00037                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *                                                               *         
      * 6253-GET-FJC01-CHKP-LIMIT.                                     *        
      ******************************************************************        
            EXEC SQL                                                            
                INCLUDE CPD00034                                                
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      *                                                               *         
      *  7600-START-FCSJC01                                           *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE CPD00038                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *                                                               *         
      *  7620-START-FCSCA00                                           *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *                                                               *         
      * 0605-VALIDATE-RESTART-REQ.                                    *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CPD00030                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6235-GET-FJC01-RESTART-REQ.                                   *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CPD00035                                                 
           END-EXEC.                                                            
                                                                        
I00251******************************************************************        
I00251* 6530-LOAD-MNT-TRANS-HIST.                                      *        
I00251******************************************************************        
I00251     EXEC SQL                                                             
I00251        INCLUDE CPD00067                                                  
I00251     END-EXEC.                                                            
I00251                                                                  
I00251*****************************************************************         
I00251*                                                               *         
I00251* 9900-SQL-ERROR-ROUTINE.                                       *         
I00251*****************************************************************         
I00251 9900-SQL-ERROR-ROUTINE.                                          
I00251*                                                                 55740000
I00251     MOVE SQLCODE                TO RS-RETURN-CODE-DISP.          
I00251     DISPLAY ' '                                                  
I00251     DISPLAY '**********************************************'     
I00251     DISPLAY '***** 9900-SQL-ERROR-ROUTINE            ******'     
I00251     DISPLAY '**********************************************'     
I00251     DISPLAY ' '                                                  
I00251     DISPLAY 'ACCOUNT_NO = ' WS-ACCOUNT-NO                        
I00251     DISPLAY 'SQLCODE    = ' RS-RETURN-CODE-DISP                  
I00251     DISPLAY ABEND-RECORD-1-DATA                                  
I00251     DISPLAY ABEND-RECORD-2-DATA                                  
I00251     DISPLAY ABEND-RECORD-3-DATA                                  
I00251     DISPLAY '**********************************************'.    
I00251                                                                  
I00251*                                                                 56040000
I00251******************************************************************        
I00251*  9700-PROCESS-ABEND.                                           *        
I00251******************************************************************        
I00251     EXEC SQL                                                             
I00251         INCLUDE CPD0023B                                                 
I00251     END-EXEC.                                                            
I00251                                                                  
      *****************************************************************         
      *                                                               *         
      * 9900-ABEND                                                    *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
