       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA289.                                        
       AUTHOR.         SAKTHI.                                          
       DATE-WRITTEN.   04/01/2011.                                      
       DATE-COMPILED.                                                   
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRIC & GAS                 **          
      **                                                            **          
      ****************************************************************          
      **                  P R O G R A M S U M M A R Y               **          
      **                                                            **          
      ** NEW BATCH PROCESS TO MOVE ACTIVE ACCOUNTS ON  INVALID      **          
      ** RATE/REVENUE CLASS TO A VALID RATE/REVENUE CLASS.          **          
      **                                                            **          
      ** THE PROGRAM GETS ALL INACTIVE RATE/REVENUE CLASS FOR THE   **          
      ** THE COMMONDATE FROM JOB PARM. ALL ACTIVE ACCOUNTS ARE      **          
      ** UPDATED WITH CORRESPONDING REPLACEMENT RATE/REVENUE CLASS. **          
      ****************************************************************          
      **                                                            **          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      **   DATE     INITIALS   REASON                               **          
      ** --------   --------   ---------------------------------    **          
      ** 04/01/11   MS93554    NEW PROGRAM WRITTEN FOR #P00450      **          
      **                       SAVE AS, RATES AND REVENUE CLASS     **          
      **                                                            **          
      ****************************************************************          
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER. IBM-370.                                        
       OBJECT-COMPUTER. IBM-370.                                        
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA289'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05  WS-UPDATE-COUNT              PIC 9(06) VALUE ZERO.       
           05  WS-RECORD-COUNT              PIC 9(06) VALUE ZERO.       
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-Y                         PIC X(01) VALUE 'Y'.        
           05  WS-N                         PIC X(01) VALUE 'N'.        
           05  WS-I                         PIC X(01) VALUE 'I'.        
           05  WS-PGRMNAME                  PIC X(08) VALUE 'PCSCA289'. 
           05  PROGRAM-NAME                 PIC X(08) VALUE 'PCSCA289'. 
           05  WS-COMMIT-COUNT              PIC 9(06) VALUE 500.        
           05  WS-RESP-AREA-ID              PIC X(03) VALUE SPACES.     
           05  WS-TRAN-APPL-NO              PIC S9(4) COMP VALUE 0.     
           05  WS-REPL-RATE-PLAN-NO         PIC X(3).                   
           05  WS-REPL-REVENUE-CLASS        PIC X(3).                   
           05  WS-ACCOUNT-NO-NUM            PIC 9(13).                  
           05  WS-IC-NO-NUM                 PIC 9(04).                  
                                                                        
       01  WS-DISPLAY-RESULT.                                           
           05  WS-ORIG-RATE-PLAN-NO-DISP    PIC X(3).                   
           05  WS-PIPE                      PIC X(01) VALUE '|'.        
           05  WS-ORIG-REVENUE-CLASS-DISP   PIC X(3).                   
           05  WS-PIPE1                     PIC X(01) VALUE '|'.        
           05  WS-ACCOUNT-NO-DISP           PIC X(13).                  
           05  WS-PIPE2                     PIC X(01) VALUE '|'.        
           05  WS-COMPANY-NO-DISP           PIC X(02).                  
           05  WS-PIPE3                     PIC X(01) VALUE '|'.        
           05  WS-CODE-UTIL-TYPE-DISP       PIC X(01).                  
           05  WS-PIPE4                     PIC X(01) VALUE '|'.        
           05  WS-REPL-RATE-PLAN-NO-DISP    PIC X(3).                   
           05  WS-PIPE5                     PIC X(01) VALUE '|'.        
           05  WS-REPL-REVENUE-CLASS-DISP   PIC X(3).                   
                                                                        
       01  WS-TRANS-COMMENT-TEXT-E.                                     
           05  WS-UTIL-TYPE                 PIC X(25) VALUE             
               'UTIL TYPE: Electric; IC: '.                             
           05  WS-IC-NO-MH-E                PIC X(04).                  
           05  WS-FILLER                    PIC X(181) VALUE SPACES.    
                                                                        
       01  WS-TRANS-COMMENT-TEXT-G.                                     
           05  WS-UTIL-TYPE                 PIC X(20) VALUE             
               'UTIL TYPE: Gas; IC: '.                                  
           05  WS-IC-NO-MH-G                PIC X(04).                  
           05  WS-FILLER                    PIC X(186) VALUE SPACES.    
                                                                        
       01  WS-TRANS-COMMENT-TEXT-U.                                     
           05  WS-UTIL-TYPE                 PIC X(27) VALUE             
               'UTIL TYPE: Un-metered; IC: '.                           
           05  WS-IC-NO-MH-U                PIC X(04).                  
           05  WS-FILLER                    PIC X(179) VALUE SPACES.    
                                                                        
       01  WS-RATE-PLAN-NO-DESC.                                        
           05  WS-RATE-PLAN-NO              PIC X(03).                  
           05  WS-FILLER                    PIC X(01) VALUE '-'.        
           05  WS-RATE-PLAN-DESC            PIC X(71).                  
                                                                        
       01  WS-REVENUE-CLASS-DESC.                                       
           05  WS-CODE-REVENUE-CLASS        PIC X(03).                  
           05  WS-FILLER                    PIC X(01) VALUE '-'.        
           05  WS-CODE-REV-CLASS-DESC       PIC X(71).                  
                                                                        
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE               PIC S9(04) COMP VALUE 0.    
           05  RS-RETURN-CODE-DISP          PIC +Z(04).                 
           05  S-RETURN-CODE                PIC S9(04) COMP VALUE 0.    
                                                                        
       01  WS-PARM-DATA.                                                
           05 FILLER                        PIC X(14) VALUE             
                                                     'LAST RUN DATE='.  
           05 WS-LAST-RUN-DATE              PIC X(10).                  
           05 FILLER                        PIC X(56).                  
      *                                                                         
      *****************************************************************         
      *  COPYBOOK FOR DB2 ABEND VARIABLES                             *         
      *****************************************************************         
       COPY CWS00010.                                                           
                                                                        
      *****************************************************************         
      *  COPYBOOK FOR SQL ERROR CHECKING                              *         
      *****************************************************************         
       COPY CWS00303.                                                           
                                                                        
      *****************************************************************         
      * COPYBOOK FOR ABEND-SWITCH - CPD09900                          *         
      *****************************************************************         
       COPY CWS09900.                                                           
                                                                        
      *****************************************************************         
      *  COPYBOOK FOR JOB PARM ROUTINE                                *         
      *****************************************************************         
       COPY FIOCA00.                                                            
       COPY FIOJC01.                                                            
       COPY CWS00038.                                                           
       COPY CWS00039.                                                           
                                                                        
      *****************************************************************         
      *    DECLARATION FOR SQL COMMAND AREA                           *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_REV_CLS_RATE, Q8                               *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBRVCLS                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_ACCOUNT, AT                                    *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_UTIL_ENVRNMT, UT                               *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_BILLING_DET, BG                                *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBBLLDET                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_BILLING_HDR, BI                                *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBBLLHDR                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_JOB_PARM, G6                                   *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *****************************************************************         
      *    TABLE : CSS_MT_TRN_HST_DET, MI                             *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBMNHDT                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_MNT_TRANS_HIST, MH                             *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBMNHIST                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_REVENUE_CLASS, F3                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBREVCLS                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_RATE_PLAN_DESC, RD                             *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBRTDESC                                                 
           END-EXEC.                                                            
                                                                        
      ****************************************************************          
      * GET ACTIVE ACCOUNTS WITH INACTIVE RATE/REV CLASS             *  52133001
      ****************************************************************          
           EXEC SQL                                                     
              DECLARE ACCOUNT_CSR CURSOR WITH HOLD FOR                  
               SELECT AT.ACCOUNT_NO                                     
                     ,AT.CUSTOMER_NO                                    
                     ,AT.COMPANY_NO                                     
                     ,AT.CODE_ACCT_STAT                                 
                     ,UT.PREMISE_NO                                     
                     ,UT.CODE_UTIL_TYPE                                 
                     ,UT.RATE_PLAN_NO                                   
                     ,UT.CODE_REVENUE_CLASS                             
                     ,UT.IC_NO                                          
                     ,Q8.REPL_RATE_PLAN_NO                              
                     ,Q8.REPL_REVENUE_CLASS                             
                 FROM CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                 
                     ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
                     ,CSS_REV_CLS_RATE Q8 WITH(READUNCOMMITTED)                 
                WHERE AT.ACCOUNT_NO         = UT.ACCOUNT_NO             
                  AND UT.RATE_PLAN_NO       = Q8.RATE_PLAN_NO           
                  AND UT.CODE_REVENUE_CLASS = Q8.CODE_REVENUE_CLASS     
                  AND UT.CODE_UTIL_TYPE     = Q8.CODE_UTIL_TYPE         
                  AND Q8.COMPANY_NO         = AT.COMPANY_NO             
                  AND Q8.STATUS_CHANGE_DT  >  IIF(TRY_CONVERT(DATE, 
                                                      :WS-LAST-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-RUN-DATE
              ) <> 0) OR (LEN(:WS-LAST-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-LAST-RUN-DATE
              ), CONVERT(DATE, :WS-LAST-RUN-DATE) )         
                  AND Q8.STATUS_CHANGE_DT  <= IIF(TRY_CONVERT(DATE, 
                                                   :Q8-STATUS-CHANGE-DT
              ) IS NULL OR (PATINDEX('%.%', :Q8-STATUS-CHANGE-DT
              ) <> 0) OR (LEN(:Q8-STATUS-CHANGE-DT
              ) <> 10), CIS.CHAR2DATE(:Q8-STATUS-CHANGE-DT
              ), CONVERT(DATE, :Q8-STATUS-CHANGE-DT) )      
                  AND Q8.STATUS_CD          = 'I'                       
                  AND AT.CODE_ACCT_STAT     = 'A'                       
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ACCOUNT_CSR CURSOR WITH HOLD FOR                          
MFA-TR*        SELECT AT.ACCOUNT_NO                                             
MFA-TR*              ,AT.CUSTOMER_NO                                            
MFA-TR*              ,AT.COMPANY_NO                                             
MFA-TR*              ,AT.CODE_ACCT_STAT                                         
MFA-TR*              ,UT.PREMISE_NO                                             
MFA-TR*              ,UT.CODE_UTIL_TYPE                                         
MFA-TR*              ,UT.RATE_PLAN_NO                                           
MFA-TR*              ,UT.CODE_REVENUE_CLASS                                     
MFA-TR*              ,UT.IC_NO                                                  
MFA-TR*              ,Q8.REPL_RATE_PLAN_NO                                      
MFA-TR*              ,Q8.REPL_REVENUE_CLASS                                     
MFA-TR*          FROM CSS_ACCOUNT      AT                                       
MFA-TR*              ,CSS_UTIL_ENVRNMT UT                                       
MFA-TR*              ,CSS_REV_CLS_RATE Q8                                       
MFA-TR*         WHERE AT.ACCOUNT_NO         = UT.ACCOUNT_NO                     
MFA-TR*           AND UT.RATE_PLAN_NO       = Q8.RATE_PLAN_NO                   
MFA-TR*           AND UT.CODE_REVENUE_CLASS = Q8.CODE_REVENUE_CLASS             
MFA-TR*           AND UT.CODE_UTIL_TYPE     = Q8.CODE_UTIL_TYPE                 
MFA-TR*           AND Q8.COMPANY_NO         = AT.COMPANY_NO                     
MFA-TR*           AND Q8.STATUS_CHANGE_DT  >  :WS-LAST-RUN-DATE                 
MFA-TR*           AND Q8.STATUS_CHANGE_DT  <= :Q8-STATUS-CHANGE-DT              
MFA-TR*           AND Q8.STATUS_CD          = 'I'                               
MFA-TR*           AND AT.CODE_ACCT_STAT     = 'A'                               
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*           QUERYNO 7100                                                  
MFA-TR*    END-EXEC.                                                            
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 0100-INITIALIZATION.                                          *         
      *     Get COMMONDATE from Job Parm table if no Override RUN DATE*         
      *****************************************************************         
       0100-INITIALIZATION.                                             
                                                                        
           MOVE WS-PGRMNAME                 TO G6-PROGRAM-NAME.         
           MOVE WS-DATE                     TO G6-CMND-CODE.            
                                                                        
           PERFORM 6251-GET-FJC01-DATE         THRU 6251-EXIT.          
                                                                        
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE                        
                                               THRU 6240-EXIT           
              MOVE WS-FCA00-COMMON-DATE     TO WS-INPUT-DATE            
              DISPLAY '   ***   COMMON DATE USED   ***  '               
           END-IF.                                                      
                                                                        
           DISPLAY ' RUN DATE        : ' WS-INPUT-DATE.                 
           DISPLAY ' '.                                                 
           DISPLAY ' COMMIT COUNT    : ' WS-COMMIT-COUNT.               
                                                                        
      *   GET LAST RUN DATE FROM JON PARM TABLE                                 
           INITIALIZE   G6-PARM-DATA                                    
                        WS-INPUT-DATA-BREAKDOWN.                        
                                                                        
           MOVE SPACES                      TO WS-SYSIPT.               
           MOVE PROGRAM-NAME                TO WS-PROGRAM.              
           MOVE WS-DATE                     TO WS-COMMAND.              
           MOVE ZEROS                       TO WS-SEQUENCE.             
                                                                        
           PERFORM 7600-START-FCSJC01          THRU  7600-EXIT.         
           PERFORM 7610-READ-FCSJC01           THRU  7610-EXIT          
             UNTIL (WS-INPUT-DATA-BREAKDOWN(1:14) = 'LAST RUN DATE=')   
                OR END-OF-SYSIPT.                                       
                                                                        
           EVALUATE TRUE                                                
             WHEN END-OF-SYSIPT                                         
                DISPLAY '************** PCSCA289 ********************'  
                DISPLAY '** ABEND IN 0100-INITIALIZATION           **'  
                DISPLAY '**  PCSCA289 LAST RUN DATE PARM NOT FOUND **'  
                DISPLAY '************** PCSCA289 ********************'  
                PERFORM 9900-ABEND   THRU 9900-EXIT                     
                DISPLAY ' '                                             
             WHEN OTHER                                                 
                MOVE G6-PARM-DATA    TO WS-PARM-DATA                    
                DISPLAY ' '                                             
                DISPLAY '************** PCSCA289 *******************'   
                DISPLAY '**  LAST RUN DATE = ' WS-LAST-RUN-DATE         
                DISPLAY '************** PCSCA289 *******************'   
           END-EVALUATE.                                                
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 1000-PROCESS-INPUT.                                           *         
      * PROCESS TO MOVE CUSTOMERS ON INVALID RATE/REVENUE CLASS       *         
      * TO A VALID RATE/REVENUE CLASS.                                *         
      *****************************************************************         
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE WS-INPUT-DATE               TO Q8-STATUS-CHANGE-DT.     
                                                                        
           PERFORM 7000-OPEN-MAIN-CURSOR       THRU 7000-EXIT.          
           PERFORM 7100-FETCH-MAIN-CURSOR      THRU 7100-EXIT.          
           PERFORM 1100-GET-ACCOUNT-DETAILS    THRU 1100-EXIT           
             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.               
           PERFORM 7200-CLOSE-MAIN-CURSOR      THRU 7200-EXIT.          
                                                                        
           PERFORM 8250-UPDATE-JOB-PARM        THRU 8250-EXIT.          
                                                                        
           DISPLAY 'TOTAL REC UPDATED : ' WS-RECORD-COUNT.              
           DISPLAY ' '.                                                 
           DISPLAY ' *** PROGRAM SUCCESSFULLY COMPLETED ***'.           
           DISPLAY ' '.                                                 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      *  GET ACCOUNT DETAILS FOR THE INACTIVE RATE/REVENUE CLASS AND  *         
      *  UPDATE THE RATE/REVENUE CLASS IN UT AND BG TABLES.           *         
      *  1100-GET-ACCOUNT-DETAILS.                                    *         
      *****************************************************************         
       1100-GET-ACCOUNT-DETAILS.                                        
                                                                        
           MOVE 1                         TO WS-TRAN-APPL-NO            
                                             MI-TRAN-APPL-NO.           
                                                                        
           MOVE AT-ACCOUNT-NO             TO UT-ACCOUNT-NO              
                                             BG-ACCOUNT-NO              
                                             WS-ACCOUNT-NO-NUM          
                                             BI-ACCOUNT-NO.             
                                                                        
           MOVE AT-COMPANY-NO             TO F3-COMPANY-NO              
                                             WS-COMPANY-NO-DISP.        
                                                                        
           MOVE WS-ACCOUNT-NO-NUM         TO WS-ACCOUNT-NO-DISP.        
                                                                        
           MOVE UT-RATE-PLAN-NO           TO WS-ORIG-RATE-PLAN-NO-DISP  
                                             BG-RATE-PLAN-NO.           
                                                                        
           MOVE UT-CODE-UTIL-TYPE         TO BG-CODE-UTIL-TYPE          
                                             RD-CODE-UTIL-TYPE          
                                             F3-CODE-UTIL-TYPE          
                                             WS-CODE-UTIL-TYPE-DISP.    
                                                                        
           MOVE UT-IC-NO                  TO BG-IC-NO                   
                                             WS-IC-NO-NUM.              
                                                                        
           MOVE WS-IC-NO-NUM              TO WS-IC-NO-MH-E              
                                             WS-IC-NO-MH-G              
                                             WS-IC-NO-MH-U.             
                                                                        
           MOVE UT-CODE-REVENUE-CLASS     TO BG-CODE-REVENUE-CLASS      
                                             WS-ORIG-REVENUE-CLASS-DISP.
                                                                        
           PERFORM 5000-UPDAT-TRANS-HIST     THRU 5000-EXIT.            
                                                                        
           MOVE Q8-REPL-RATE-PLAN-NO      TO WS-REPL-RATE-PLAN-NO       
                                             WS-REPL-RATE-PLAN-NO-DISP. 
                                                                        
           MOVE Q8-REPL-REVENUE-CLASS     TO WS-REPL-REVENUE-CLASS      
                                             WS-REPL-REVENUE-CLASS-DISP.
                                                                        
           PERFORM 8100-UPDATE-UT-REVCLAS    THRU 8100-EXIT.            
           PERFORM 8200-UPDATE-BG-REVCLAS    THRU 8200-EXIT.            
                                                                        
           COMPUTE WS-UPDATE-COUNT = WS-UPDATE-COUNT + 1                
           COMPUTE WS-RECORD-COUNT = WS-RECORD-COUNT + 1                
                                                                        
           DISPLAY 'UPDATED RECORDS  : ' WS-DISPLAY-RESULT.             
                                                                        
           IF WS-UPDATE-COUNT >= WS-COMMIT-COUNT                        
              MOVE ZERO                   TO WS-UPDATE-COUNT            
              PERFORM 8300-COMMIT            THRU 8300-EXIT             
           END-IF.                                                      
                                                                        
           PERFORM 7100-FETCH-MAIN-CURSOR    THRU 7100-EXIT.            
                                                                        
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  TRANSACTION HIST PROCESS                                      *        
      ******************************************************************        
       5000-UPDAT-TRANS-HIST.                                           
                                                                        
           PERFORM 5100-FORMAT-JRNL-HEAD     THRU 5100-EXIT.            
           PERFORM 5200-JRNL-UPDATE          THRU 5200-EXIT.            
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5100-FORMAT-JRNL-HEAD.                                         *        
      *     1. MOVE FIELDS TO THE MAINTENANCE TRANSACTION HEADER.      *        
      *        THE FIRST TIME THE TRANSACTION DETAILS ROW IS WRITTEN,  *        
      *        THIS ROW WILL ALSO BE WRITTEN (SEE CPD00067).           *        
      ******************************************************************        
       5100-FORMAT-JRNL-HEAD.                                           
                                                                        
           PERFORM 7300-GET-CURRENT-TIMESTAMP  THRU 7300-EXIT.          
                                                                        
           MOVE 'F'                         TO MH-CODE-TRAN-TYPE.       
           MOVE WS-RESP-AREA-ID             TO MH-RESP-AREA-ID.         
           MOVE AT-ACCOUNT-NO               TO MH-ACCOUNT-NO.           
           MOVE AT-CUSTOMER-NO              TO MH-CUSTOMER-NO.          
           MOVE UT-PREMISE-NO               TO MH-PREMISE-NO.           
           MOVE 'SYSTEM'                    TO MH-USER-ID.              
           MOVE 'PCSCA289'                  TO MH-APPL-PROGRAM-ID.      
                                                                        
           EVALUATE UT-CODE-UTIL-TYPE                                   
             WHEN 'E'                                                   
                 MOVE +29                     TO MH-TRAN-COMMENT-LEN    
                 MOVE WS-TRANS-COMMENT-TEXT-E TO MH-TRAN-COMMENT-TEXT   
             WHEN 'G'                                                   
                 MOVE +24                     TO MH-TRAN-COMMENT-LEN    
                 MOVE WS-TRANS-COMMENT-TEXT-G TO MH-TRAN-COMMENT-TEXT   
             WHEN 'U'                                                   
                 MOVE +31                     TO MH-TRAN-COMMENT-LEN    
                 MOVE WS-TRANS-COMMENT-TEXT-U TO MH-TRAN-COMMENT-TEXT   
           END-EVALUATE.                                                
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5200-JRNL-UPDATE.                                              *        
      ******************************************************************        
       5200-JRNL-UPDATE.                                                
                                                                        
           MOVE '5200' TO ACTIVE-PARAGRAPH.                             
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
                                                                        
           IF UT-CODE-REVENUE-CLASS NOT = Q8-REPL-REVENUE-CLASS         
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
                                                                        
      *    TO GET CHANGED COLUMN VALUE FOR CODE REVENUE CLASS.                  
              INITIALIZE  WS-CODE-REV-CLASS-DESC                        
              MOVE Q8-REPL-REVENUE-CLASS    TO F3-CODE-REVENUE-CLASS    
                                               WS-CODE-REVENUE-CLASS    
              PERFORM 7400-GET-REV-CLS-DESC    THRU 7400-EXIT           
              MOVE F3-REVENUE-CLS-DESC      TO WS-CODE-REV-CLASS-DESC   
              MOVE WS-REVENUE-CLASS-DESC    TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-REVENUE-CLASS-DESC                      
                                            TO MI-CHG-COLUMN-VALUE-LEN  
                                                                        
      *    TO GET PREVIOUS COLUMN VALUE FOR FOR CODE REVENUE CLASS.             
              INITIALIZE  WS-CODE-REV-CLASS-DESC                        
              MOVE UT-CODE-REVENUE-CLASS    TO F3-CODE-REVENUE-CLASS    
                                               WS-CODE-REVENUE-CLASS    
              PERFORM 7400-GET-REV-CLS-DESC    THRU 7400-EXIT           
              MOVE F3-REVENUE-CLS-DESC      TO WS-CODE-REV-CLASS-DESC   
              MOVE WS-REVENUE-CLASS-DESC    TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-REVENUE-CLASS-DESC                      
                                            TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE 'REVENUE CLASS'          TO MI-COLUMN-DESC           
                                                                        
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF UT-RATE-PLAN-NO NOT = Q8-REPL-RATE-PLAN-NO                
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
                                                                        
      *    TO GET CHANGED COLUMN VALUE FOR RATE PLAN NO                         
              INITIALIZE     WS-RATE-PLAN-DESC                          
              MOVE Q8-REPL-RATE-PLAN-NO     TO RD-RATE-PLAN-NO          
                                               WS-RATE-PLAN-NO          
              PERFORM 7500-GET-RATE-DESC       THRU 7500-EXIT           
              MOVE RD-RATE-DESC             TO WS-RATE-PLAN-DESC        
              MOVE WS-RATE-PLAN-NO-DESC     TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-RATE-PLAN-NO-DESC                       
                                            TO MI-CHG-COLUMN-VALUE-LEN  
                                                                        
      *    TO GET PREVIOUS COLUMN VALUE FOR RATE PLAN NO.                       
              INITIALIZE    WS-RATE-PLAN-DESC                           
              MOVE UT-RATE-PLAN-NO          TO RD-RATE-PLAN-NO          
                                               WS-RATE-PLAN-NO          
              PERFORM 7500-GET-RATE-DESC       THRU 7500-EXIT           
              MOVE RD-RATE-DESC             TO WS-RATE-PLAN-DESC        
              MOVE WS-RATE-PLAN-NO-DESC     TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-RATE-PLAN-NO-DESC                       
                                            TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE 'RATE PLAN'              TO MI-COLUMN-DESC           
                                                                        
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      * 6240-GET-FCA00-COMMON-DATE.                                   *         
      *     To Fetch the COMMONDATE from JOB Parm table               *         
      *****************************************************************         
                                                                        
           COPY CPD00040.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      *  6251-GET-FJC01-DATE.                                         *         
      *     To Fetch the OVER RIDE Date from JOB Parm table           *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
                INCLUDE CPD00037                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  JOURNALING COPYBOOK.                                          *        
      *  6530-LOAD-MNT-TRANS-HIST                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7000-OPEN-MAIN-CURSOR.                                        *         
      *****************************************************************         
       7000-OPEN-MAIN-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
                OPEN ACCOUNT_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA289 ABORT **************'        
              DISPLAY '*       7000-OPEN-MAIN-CURSOR          *'        
              DISPLAY '* CURSOR            :   ACCOUNT_CSR      '       
              DISPLAY '* STATUS_CHANGE_DT  : ' Q8-STATUS-CHANGE-DT      
              DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '*       PROCESSING TERMINATED          *'        
              DISPLAY '********** PCSCA289 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7100-FETCH-MAIN-CURSOR.                                       *         
      *****************************************************************         
       7100-FETCH-MAIN-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
                FETCH ACCOUNT_CSR                                       
                 INTO :AT-ACCOUNT-NO                                    
                     ,:AT-CUSTOMER-NO                                   
                     ,:AT-COMPANY-NO                                    
                     ,:AT-CODE-ACCT-STAT                                
                     ,:UT-PREMISE-NO                                    
                     ,:UT-CODE-UTIL-TYPE                                
                     ,:UT-RATE-PLAN-NO                                  
                     ,:UT-CODE-REVENUE-CLASS                            
                     ,:UT-IC-NO                                         
                     ,:Q8-REPL-RATE-PLAN-NO                             
                     ,:Q8-REPL-REVENUE-CLASS                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              OR NOT-FOUND                                              
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA289 ABORT **************'        
              DISPLAY '*      7100-FETCH-MAIN-CURSOR          *'        
              DISPLAY '* CURSOR            :   ACCOUNT_CSR      '       
              DISPLAY '* STATUS_CHANGE_DT  : ' Q8-STATUS-CHANGE-DT      
              DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '*       PROCESSING TERMINATED          *'        
              DISPLAY '********** PCSCA289 ABORT **************'        
              PERFORM 9900-ABEND                  THRU 9900-EXIT        
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7200-CLOSE-MAIN-CURSOR.                                       *         
      *****************************************************************         
       7200-CLOSE-MAIN-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
                CLOSE ACCOUNT_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA289 ABORT **************'        
              DISPLAY '*      7200-CLOSE-MAIN-CURSOR          *'        
              DISPLAY '* CURSOR            :   ACCOUNT_CSR      '       
              DISPLAY '* STATUS_CHANGE_DT  : ' Q8-STATUS-CHANGE-DT      
              DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA289 ABORT **************'        
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7300-GET-CURRENT-TIMESTAMP.                                   *         
      *****************************************************************         
       7300-GET-CURRENT-TIMESTAMP.                                      
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-TRANS-HIST-SEQ-NO,
              :MH-DATE-TRANS                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :MH-TRANS-HIST-SEQ-NO =   CURRENT TIMESTAMP                   
MFA-TR*          ,:MH-DATE-TRANS        =   CURRENT DATE                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA289 ABORT **************'        
              DISPLAY '*      7300-GET-CURRENT-TIMESTAMP      *'        
              DISPLAY '* CURSOR            :   ACCOUNT_CSR      '       
              DISPLAY '* STATUS_CHANGE_DT  : ' Q8-STATUS-CHANGE-DT      
              DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA289 ABORT **************'        
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      *   SELECTING THE REV CLASS DESCRIPTION FOR CODE-REV-CLAS       *         
      * 7400-GET-REV-CLS-DESC.                                        *         
      *****************************************************************         
       7400-GET-REV-CLS-DESC.                                           
                                                                        
           EXEC SQL                                                     
             SELECT REVENUE_CLS_DESC                                    
               INTO :F3-REVENUE-CLS-DESC                                
               FROM CSS_REVENUE_CLASS WITH(READUNCOMMITTED)                     
              WHERE COMPANY_NO         = :F3-COMPANY-NO                 
                AND CODE_UTIL_TYPE     = :F3-CODE-UTIL-TYPE             
                AND CODE_REVENUE_CLASS = :F3-CODE-REVENUE-CLASS         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT REVENUE_CLS_DESC                                            
MFA-TR*        INTO :F3-REVENUE-CLS-DESC                                        
MFA-TR*        FROM CSS_REVENUE_CLASS                                           
MFA-TR*       WHERE COMPANY_NO         = :F3-COMPANY-NO                         
MFA-TR*         AND CODE_UTIL_TYPE     = :F3-CODE-UTIL-TYPE                     
MFA-TR*         AND CODE_REVENUE_CLASS = :F3-CODE-REVENUE-CLASS                 
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7400                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA289 ABORT **************'        
              DISPLAY '*      7400-GET-REV-CLS-DESC           *'        
              DISPLAY '* SELECT            :   CODE_REVENUE_CLAS'       
              DISPLAY '* ACCOUNT NO        : ' AT-ACCOUNT-NO            
              DISPLAY '* COMPANY_NO        : ' F3-COMPANY-NO            
              DISPLAY '* CODE_UTIL_TYPE    : ' F3-CODE-UTIL-TYPE        
              DISPLAY '* CODE_REVEN_CLASS  : ' F3-CODE-REVENUE-CLASS    
              DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA289 ABORT **************'        
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * SELECTING THE RATE PLAN DESCRIPTION FOR RATE PLAN NO.         *         
      * 7500-GET-RATE-DESC.                                           *         
      *****************************************************************         
       7500-GET-RATE-DESC.                                              
                                                                        
           EXEC SQL                                                     
             SELECT RATE_DESC                                           
               INTO :RD-RATE-DESC                                       
               FROM CSS_RATE_PLAN_DESC WITH(READUNCOMMITTED)                    
              WHERE RATE_PLAN_NO    = :RD-RATE-PLAN-NO                  
                AND CODE_UTIL_TYPE  = :RD-CODE-UTIL-TYPE                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT RATE_DESC                                                   
MFA-TR*        INTO :RD-RATE-DESC                                               
MFA-TR*        FROM CSS_RATE_PLAN_DESC                                          
MFA-TR*       WHERE RATE_PLAN_NO    = :RD-RATE-PLAN-NO                          
MFA-TR*         AND CODE_UTIL_TYPE  = :RD-CODE-UTIL-TYPE                        
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7500                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA289 ABORT **************'        
              DISPLAY '*      7500-GET-RATE-DESC              *'        
              DISPLAY '* SELECT            :   RATE_DESC        '       
              DISPLAY '* ACCOUNT_NO        : ' AT-ACCOUNT-NO            
              DISPLAY '* CODE_UTIL_TYPE    : ' RD-CODE-UTIL-TYPE        
              DISPLAY '* RATE_PLAN_NO      : ' RD-RATE-PLAN-NO          
              DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA289 ABORT **************'        
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      *  7600-START-FCSJC01                                           *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
                INCLUDE CPD00038                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7620-START-FCSCA00.                                           *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
                INCLUDE CPD00039                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8100-UPDATE-UT-REVCLAS.                                       *         
      *****************************************************************         
       8100-UPDATE-UT-REVCLAS.                                          
                                                                        
           EXEC SQL                                                     
             UPDATE UT                                  
                SET UT.RATE_PLAN_NO       =  :WS-REPL-RATE-PLAN-NO      
                   ,UT.CODE_REVENUE_CLASS =  :WS-REPL-REVENUE-CLASS     
             FROM CSS_UTIL_ENVRNMT UT
              WHERE UT.ACCOUNT_NO         =  :UT-ACCOUNT-NO             
                AND UT.CODE_UTIL_TYPE     =  :UT-CODE-UTIL-TYPE         
                AND UT.IC_NO              =  :UT-IC-NO                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_UTIL_ENVRNMT  UT                                        
MFA-TR*         SET UT.RATE_PLAN_NO       =  :WS-REPL-RATE-PLAN-NO              
MFA-TR*            ,UT.CODE_REVENUE_CLASS =  :WS-REPL-REVENUE-CLASS             
MFA-TR*       WHERE UT.ACCOUNT_NO         =  :UT-ACCOUNT-NO                     
MFA-TR*         AND UT.CODE_UTIL_TYPE     =  :UT-CODE-UTIL-TYPE                 
MFA-TR*         AND UT.IC_NO              =  :UT-IC-NO                          
MFA-TR*     QUERYNO 8100                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA289 ABORT **************'        
              DISPLAY '*      8100-UPDATE-UT-REVCLAS          *'        
              DISPLAY '* UT-ACCOUNT-NO        ' UT-ACCOUNT-NO           
              DISPLAY '* UT-CODE-UTIL-TYPE    ' UT-CODE-UTIL-TYPE       
              DISPLAY '* UT-IC-NO             ' UT-IC-NO                
              DISPLAY '* UT-RATE-PLAN-NO      ' UT-RATE-PLAN-NO         
              DISPLAY '*UT-CODE-REVENUE-CLASS ' UT-CODE-REVENUE-CLASS   
              DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA289 ABORT **************'        
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8200-UPDATE-BG-REVCLAS.                                       *         
      *****************************************************************         
       8200-UPDATE-BG-REVCLAS.                                          
                                                                        
           EXEC SQL                                                     
             UPDATE BG                                   
                SET BG.RATE_PLAN_NO       =  :WS-REPL-RATE-PLAN-NO      
                   ,BG.CODE_REVENUE_CLASS =  :WS-REPL-REVENUE-CLASS     
             FROM CSS_BILLING_DET BG
              WHERE BG.ACCOUNT_NO         =  :BG-ACCOUNT-NO             
                AND BG.CODE_UTIL_TYPE     =  :BG-CODE-UTIL-TYPE         
                AND BG.CODE_REVENUE_CLASS =  :BG-CODE-REVENUE-CLASS     
                AND BG.IC_NO              =  :BG-IC-NO                  
                AND BG.REV_MTH_ORIG_BILL  =  0                          
                AND BG.CODE_BILL_ITM_TYPE <> 'B'                        
                AND BG.REBILL_IND         <> 'Y'                        
                AND BG.BILL_NO            IN                            
                   ( SELECT BI.BILL_NO                                  
                       FROM CSS_BILLING_HDR BI                          
                      WHERE BI.ACCOUNT_NO  = :BI-ACCOUNT-NO             
                        AND BI.DATE_BILLED IS NULL )                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_BILLING_DET   BG                                        
MFA-TR*         SET BG.RATE_PLAN_NO       =  :WS-REPL-RATE-PLAN-NO              
MFA-TR*            ,BG.CODE_REVENUE_CLASS =  :WS-REPL-REVENUE-CLASS             
MFA-TR*       WHERE BG.ACCOUNT_NO         =  :BG-ACCOUNT-NO                     
MFA-TR*         AND BG.CODE_UTIL_TYPE     =  :BG-CODE-UTIL-TYPE                 
MFA-TR*         AND BG.CODE_REVENUE_CLASS =  :BG-CODE-REVENUE-CLASS             
MFA-TR*         AND BG.IC_NO              =  :BG-IC-NO                          
MFA-TR*         AND BG.REV_MTH_ORIG_BILL  =  0                                  
MFA-TR*         AND BG.CODE_BILL_ITM_TYPE <> 'B'                                
MFA-TR*         AND BG.REBILL_IND         <> 'Y'                                
MFA-TR*         AND BG.BILL_NO            IN                                    
MFA-TR*            ( SELECT BI.BILL_NO                                          
MFA-TR*                FROM CSS_BILLING_HDR BI                                  
MFA-TR*               WHERE BI.ACCOUNT_NO  = :BI-ACCOUNT-NO                     
MFA-TR*                 AND BI.DATE_BILLED IS NULL )                            
MFA-TR*      QUERYNO 8200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA289 ABORT **************'        
              DISPLAY '*      8200-UPDATE-BG-REVCLAS          *'        
              DISPLAY '* BG-ACCOUNT-NO        ' BG-ACCOUNT-NO           
              DISPLAY '* BG-CODE-UTIL-TYPE    ' BG-CODE-UTIL-TYPE       
              DISPLAY '* BG-IC-NO             ' BG-IC-NO                
              DISPLAY '* BG-RATE-PLAN-NO      ' BG-RATE-PLAN-NO         
              DISPLAY '*BG-CODE-REVENUE-CLASS ' BG-CODE-REVENUE-CLASS   
              DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA289 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *8250-UPDATE-JOB-PARM.                                                    
      ******************************************************************        
       8250-UPDATE-JOB-PARM.                                            
                                                                        
           MOVE WS-INPUT-DATE               TO WS-LAST-RUN-DATE.        
           MOVE WS-PARM-DATA                TO G6-PARM-DATA.            
           MOVE WS-PGRMNAME                 TO G6-PROGRAM-NAME.         
           MOVE '01'                        TO G6-COMPANY-NO.           
           MOVE 'DATE'                      TO G6-CMND-CODE.            
           MOVE 'A'                         TO G6-STATUS.               
           MOVE 2                           TO G6-SEQ-NO.               
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_JOB_PARM                                       
                 SET PARM_DATA      = :G6-PARM-DATA                     
               WHERE PROGRAM_NAME   = :G6-PROGRAM-NAME                  
                 AND COMPANY_NO     = :G6-COMPANY-NO                    
                 AND CMND_CODE      = :G6-CMND-CODE                     
                 AND SEQ_NO         = :G6-SEQ-NO                        
                 AND STATUS         = :G6-STATUS                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
             DISPLAY '********** PCSCA289 ABORT **************'         
             DISPLAY '*      8250-UPDATE-JOB-PARM            *'         
             DISPLAY 'SQLCODE ', SQLCODE                                
             DISPLAY 'PROGRAM_NAME  =', G6-PROGRAM-NAME                 
             DISPLAY 'COMPANY_NO    =', G6-COMPANY-NO                   
             DISPLAY 'CMND_CODE     =', G6-CMND-CODE                    
             DISPLAY 'SEQ_NO        =', G6-SEQ-NO                       
             DISPLAY 'STATUS        =', G6-STATUS                       
             DISPLAY '*     PROCESSING TERMINATED            *'         
             DISPLAY '********** PCSCA289 ABORT **************'         
             PERFORM 9900-ABEND                 THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8300-COMMIT.                                                  *         
      *     Copybook for SQL COMMIT                                   *         
      *****************************************************************         
                                                                        
       8300-COMMIT.                                                     
                                                                        
           EXEC SQL                                                             
                INCLUDE CPD00047                                                
           END-EXEC.                                                            
                                                    
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * ADD DUMMY STATEMENT TO FIX ISSUE TRANS HIST CPYC              *         
      * 9000-TERMINATE.                                               *         
      *****************************************************************         
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           GO TO 9000-EXIT.                                             
      ******************************************************************        
      *                                                                *        
      * 9000-TERMINATE.                                                *        
      ******************************************************************        
       9000-TERMINATE.                                                  
                                                                        
           GO TO 9000-EXIT.                                             
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      * 9900-SQL-ERROR-ROUTINE.                                       *         
      *****************************************************************         
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                 55740000
           MOVE SQLCODE                TO RS-RETURN-CODE-DISP.          
           DISPLAY ' '                                                  
           DISPLAY '**********************************************'     
           DISPLAY '***** 9900-SQL-ERROR-ROUTINE            ******'     
           DISPLAY '**********************************************'     
           DISPLAY ' '                                                  
           DISPLAY 'ACCOUNT_NO = ' AT-ACCOUNT-NO                        
           DISPLAY 'SQLCODE    = ' RS-RETURN-CODE-DISP                  
           DISPLAY ABEND-RECORD-1-DATA                                  
           DISPLAY ABEND-RECORD-2-DATA                                  
           DISPLAY ABEND-RECORD-3-DATA                                  
           DISPLAY '**********************************************'.    
                                                                        
      ******************************************************************        
      *  9900-ABEND.                                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
