       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA280.                                        
       DATE-WRITTEN.   OCT 2007.                                        
      *****************************************************************         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      *****************************************************************         
      *              P R O G R A M  S U M M A R Y                     *         
      *****************************************************************         
      **    1) CHECKS FOR GOOD PAYMENTS AND MOVES TO NEW TIER BASED  **         
      ** ON MINIMUM GOOD PAYMENTS OF REGULATED CUSTOMERS             **         
      **                                                             **         
      **    2) MOVES UNBILLED DEREGULATED PROSPECTIVE CUSTOMERS IN TO**         
      **       EXISTING CUSTOMERS WITH DEFAULT TIER RANKING          **         
      **                                                             **         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **  --------  --------     ----------------------------------  **         
      **  10/2007   VY95550      INITIAL VERSION OF PROGRAM          **         
      **                                                             **         
C34569**  06/2008   VY95550      ADD PAYMENT HISTORY ON TRANSACTION  **         
C34569**                         COMMENT                             **         
T35434**  09/2008   SP94986      ADDED FOR FETCH ONLY TO CURSOR TO   **         
T35434**                         AVOID -911S ABEND.                  **         
I00113**  01/2009   VY95550      GROUP 1 SR. MOVEMENT.               **         
I00113**                                                             **         
P00141**  04/2009   SS97726      ADD START/END DATE TO OPT_ATTR_INCTV**         
P00172**  06/2009   VY95550      REGULATED TRANSITION CHANGES        **         
P00172**                         TO ADJUST CUSTOMER'S TIER RANKING   **         
P00172**                         AS PER THE PSC NORMS FOR 2009       **         
P00172**  08/2009   VY95550      REMOVED CSS_DHR_HIST TABLE REFERENCE**         
P00172**                         AND MODIFIED THE CODE TO CHECK      **         
P00172**                         DHR_FL OF CSS_CUSTOMER TABLE        **         
P00172**                         & MODIFIED FOR SEPTEMBER TRANSITION **         
PRDFIX**  01/2010   VY95550      MODIFIED TO MOVE SPACES ON          **         
PRDFIX**                         UT-GAS-BASE-LAST-UPDT FOR NULL      **         
P00453**  06/2011   MN90523      SKIP ACCT MKT TIER INSERTION IF     **         
P00453**                         PRP ACCOUNT IS IN FIRST INITAL BILL **         
P00453**  02/2011   JC91900      Set to PRP accounts to correct tier.**         
P00473*   08/12/11  JC91900      Add CRM versioning changes.         **         
P00677**  07/31/12  GD43988      REGULATED PROVIDER 2012 TIER        **         
P00677**                         ADJUSTMENT CHANGES                  **         
A04860*  29/01/14   MR7E794      LOAD DIRECTLY CSS_WQ_ITEMS INSTEAD  **         
A04860*             ACT001       OF CSS_WQ_ITEMS_MF BY CALLING SUB   **         
A04860*                          PROGRAM SCSCB077                    **         
P805AP*  04/19/16   SV95326      EXPIRE THE STATUS CD FROM CSS_ACCT_ **         
P805AP*                          ATTRIBUTE TABLE WHEN WE BILL SECOND **         
P805AP*                          TIME.                               **         
OTPOOL*  08/11/16   SS45239      OUTER POOL GROUP.                   **         
      *****************************************************************         
      *                                                                *00993000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00993100
      *                                                                *00993200
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00993300
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00993400
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00993500
      *  3000 - 4999  NOT USED                                         *00993600
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00993700
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00993800
      *  7000 - 7999  INPUT MODULES                                    *00993900
      *  8000 - 8999  OUTPUT MODULES                                   *00994000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00994100
      *                                                                *00994200
      ******************************************************************00994300
      *                                                                         
           REMARKS.                                                     
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA280'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                     PIC X(40)     VALUE              
             'WORKING STORAGE FOR PCSCA280 STARTS HERE'.                
      *                                                                         
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME            PIC X(08) VALUE 'PCSCA280'.      
           05  WS-PGRMNAME             PIC X(08) VALUE 'PCSCA280'.      
A04860     05  SCSCB077                PIC X(08) VALUE 'SCSCB077'.      
           05  WS-Y                    PIC X(01) VALUE 'Y'.             
           05  WS-N                    PIC X(01) VALUE 'N'.             
           05  WS-803                  PIC S9(9) VALUE -803 COMP.       
           05  WS-HOLD-ACT-FRM-BILNG   PIC X(01) VALUE 'H'.             
C34569     05  WS-DROP-L-COMMENTS      PIC X(39) VALUE                  
C34569         'GROUP 2 MOVEMENT BASED ON GOOD PAYMENT.'.               
C34569     05  WS-DROP-H-COMMENTS      PIC X(42) VALUE                  
C34569         'GROUP 2 MOVEMENT BASED ON MISSED PAYMENT.'.             
I00113     05  WS-SCANA-SR-DELINQ-CD   PIC X(17)                        
I00113                                      VALUE 'SCANA SENIOR AGE'.   
I00113     05  REG-GRP1-CUST           PIC X(01) VALUE '1'.             
P00677     05  REG-GRP2-CUST           PIC X(01) VALUE '2'.             
P00453     05  WS-ACTIVE               PIC X(01) VALUE 'A'.             
      *                                                                         
       01  WS-SUB-1B                   PIC 9(02) VALUE 0.               
       01  WS-SUB-1B-MAX               PIC 9(02) VALUE 0.               
       01  WS-MKT-TIER-ADJ-TABLE.                                       
P00677   02  WS-MKT-TIER-ADJ-ROW OCCURS 25 TIMES.                       
           05  WS-TIER-CUST-STAT-CD    PIC X(01).                       
           05  WS-TIER-ACCT-TYPE-CD    PIC X(01).                       
           05  WS-MKT-TIER-RANKING     PIC 9(04).                       
           05  WS-MKT-TIER-START-DT    PIC X(10).                       
           05  WS-ADJ-TIER-SEQ-NO      PIC 9(04).                       
           05  WS-AGL-LOW-INCM-SR-FL   PIC X(01).                       
           05  WS-MIN-GOOD-PAY-QTY-NULL-IND                             
                                       PIC X(01).                       
           05  WS-MIN-GOOD-PAY-QTY     PIC 9(04).                       
           05  WS-MISSED-PYMT-QTY      PIC 9(04).                       
           05  WS-APPLICATION-CD       PIC X(02).                       
           05  WS-ADJ-TIER-ACCT-TYPE   PIC X(01).                       
           05  WS-ADJ-TIER-RANKING     PIC 9(04).                       
           05  WS-ADJ-TIER-START-DT    PIC X(10).                       
           05  WS-ADJ-START-DT         PIC X(10).                       
           05  WS-ADJ-END-DT           PIC X(10).                       
           05  WS-ADJ-SOURCE-CD        PIC X(01).                       
           05  WS-DHR-QUALIFIED-FL     PIC X(01).                       
P00172     05  WS-EVAL-MONTHS-QTY      PIC 9(04).                       
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-CYC1                 PIC X(2)  VALUE SPACES.          
           05  WS-CYC2                 PIC X(2)  VALUE SPACES.          
           05  WS-BILL-CYCLE1          PIC X(02) VALUE SPACES.          
           05  WS-BILL-CYCLE2          PIC X(02) VALUE SPACES.          
           05  WS-PARM-CYCLE           PIC X(02) VALUE SPACES.          
P00453     05  WS-PREPAY-COUNT         PIC S9(04) COMP VALUE 0.         
P00453     05  WS-PREPAY-COUNT-NULL    PIC S9(04) COMP VALUE 0.         
           05  WS-COMPANY-NO           PIC X(02) VALUE '01'.            
           05  WS-PREV-MKT-TIER-RANKING                                 
                                       PIC S9(4) USAGE COMP.            
           05  WS-PREV-MKT-TIER-START-DT                                
                                       PIC X(10) VALUE SPACES.          
P00453     05 WS-SKIP-PRP-ACCOUNT-SW   PIC X(01) VALUE 'N'.             
P00453         88 SKIP-PRP-ACCOUNT               VALUE 'Y'.             
P00677     05  WS-ROW-FOUND            PIC X(01) VALUE SPACES.          
P00677         88  TIER-ADJ-REQUIRED             VALUE 'Y'.             
P00677         88  TIER-ADJ-NOT-REQUIRED         VALUE 'N'.             
P00677         88  TIER-ADJ-COMPLETED            VALUE 'C'.             
           05  WS-NO-REGULATED-ROWS    PIC X(01) VALUE 'N'.             
               88  NO-REGULATED-ROWS             VALUE 'Y'.             
           05  WS-MKT-TIER-ROWS        PIC X(01) VALUE 'N'.             
               88  NO-MKT-TIER-ADJ               VALUE 'Y'.             
           05  WS-NO-DREG-ROWS         PIC X(01) VALUE 'N'.             
               88  NO-DREG-ROWS                  VALUE 'Y'.             
           05  WS-RATE-TYPE-FLAG       PIC X(01) VALUE 'N'.             
               88 FIXED-RATE-CUSTOMER            VALUE 'Y'.             
P00172         88 VARIABLE-RATE-CUSTOMER         VALUE 'V'.             
           05  WS-AGL-DISCOUNT         PIC X(01) VALUE 'N'.             
               88 ON-PENDING-STATUS              VALUE 'Y'.             
I00113     05  WS-SENIOR-TIER          PIC X(01) VALUE 'N'.             
I00113         88 SENIOR-TIER                    VALUE 'S'.             
I00113     05  WS-GRP1-ADJ             PIC X(01) VALUE 'N'.             
I00113         88 GRP1-SR-ADJ                    VALUE 'Y'.             
           05  WS-CURRENT-TIMESTAMP    PIC X(26) VALUE SPACES.          
           05  WS-CURRENT-DATE         PIC X(10) VALUE SPACES.          
           05  WS-HOLD-DATE            PIC X(10) VALUE SPACES.          
           05  WS-EFF-START-DT         PIC X(10) VALUE SPACES.          
           05  WS-EXEMPT-COMMENT       PIC X(50) VALUE SPACES.          
           05  WS-CHKP-NO              PIC 9(05) VALUE ZERO.            
           05  WS-REVENUE-MONTH-JP     PIC X(06).                       
I00113     05  WS-INPUT-REV-MONTH      PIC X(06).                       
I00113     05  WS-START-DATE.                                           
I00113         10 WS-START-YR          PIC X(04).                       
I00113         10 FILLER               PIC X(01) VALUE '-'.             
I00113         10 WS-START-MT          PIC X(02).                       
I00113         10 FILLER               PIC X(01) VALUE '-'.             
I00113         10 WS-START-DY          PIC X(02).                       
I00113     05  WS-START-DATE-N.                                         
I00113         10 WS-START-YR-N        PIC S9(4) USAGE COMP.            
I00113         10 WS-START-MT-N        PIC S9(2) USAGE COMP.            
I00113     05  WS-REV-CLOSE-OUT-60     PIC X(10) VALUE SPACES.          
I00113     05  WS-REV-CLOSE-OUT-30     PIC X(10) VALUE SPACES.          
I00113     05  WS-REV-CLOSE-OUT-00     PIC X(10) VALUE SPACES.          
I00113     05  WS-SUB-R                PIC 9(02) VALUE 0.               
I00113     05  WS-MONTHS-TO-ADD        PIC 9(02) VALUE 0.               
           05  WS-EXPIRE-DELINQ-VALUE  PIC S9(4) USAGE COMP VALUE +0.   
           05  WS-EXPIRE-DELINQ-CD     PIC X(15) VALUE                  
                                           'RATE-PKG-EXPIRE'.           
I00113     05  WS-SCANA-SR-DELINQ-VAL  PIC S9(4) USAGE COMP VALUE +0.   
I00113     05  WS-SCANA-SR-60-DAY-VAL  PIC S9(4) USAGE COMP VALUE +0.   
I00113     05  WS-SCANA-SR-30-DAY-VAL  PIC S9(4) USAGE COMP VALUE +0.   
I00113     05  WS-SCANA-SR-RENEWAL-DAY PIC S9(4) USAGE COMP VALUE +0.   
I00113     05  WS-RESULT-YEAR          PIC S9(04) COMP.                 
I00113     05  WS-DUMMY-DATE-ST        PIC X(10) VALUE SPACES.          
I00113     05  WS-DUMMY-DATE-END       PIC X(10) VALUE SPACES.          
I00113     05  WS-EXPECTED-DATE        PIC X(10) VALUE SPACES.          
           05  WS-INSERT-REC-CNTR      PIC S9(07)  VALUE ZERO COMP-3.   
           05  WS-TANS-COMM-TMP        PIC X(110).                      
           05  WS-GROUP2-MOVE          PIC 9(6)  VALUE 0.               
           05  WS-GROUP2-RED REDEFINES WS-GROUP2-MOVE.                  
               10  WS-GROUP2-YYYY      PIC 9(4).                        
               10  WS-GROUP2-MM        PIC 9(2).                        
           05  WS-GRP2-MOVE-DATE.                                       
               10  WS-GRP2-YYYY        PIC X(04) VALUE SPACE.           
               10  FILLER              PIC X(01) VALUE '-'.             
               10  WS-GRP2-MM          PIC X(02) VALUE SPACE.           
               10  FILLER              PIC X(01) VALUE '-'.             
               10  WS-GRP2-DD          PIC X(02) VALUE SPACE.           
P00172     05  WS-SKIP-FOR-TRANSITION  PIC X(01) VALUE SPACE.           
P00453     05  WS-PRP-DEFAULT-TIER     PIC X(20) VALUE                  
P00453                                           'PRP-DEFAULT-TIER'.    
P00453     05  WS-PRP-MKT-TIER-RANK    PIC S9(4) USAGE COMP VALUE +0.   
OTPOOL     05  WS-DRG-RES-OTP-MKT-TIER PIC S9(4) USAGE COMP VALUE +0.   
OTPOOL     05  WS-DRG-SCM-OTP-TIER-AUG PIC S9(4) USAGE COMP VALUE +0.   
OTPOOL     05  WS-DRG-SCM-OTP-TIER-SAV PIC S9(4) USAGE COMP VALUE +0.   
OTPOOL     05  WS-DRG-SCM-OTP-TIER-ROM PIC S9(4) USAGE COMP VALUE +0.   
OTPOOL     05  WS-DRG-SCM-OTP-TIER-MAC PIC S9(4) USAGE COMP VALUE +0.   
OTPOOL     05  WS-DRG-SCM-OTP-TIER-BRU PIC S9(4) USAGE COMP VALUE +0.   
OTPOOL     05  WS-DRG-SCM-OTP-TIER-VAL PIC S9(4) USAGE COMP VALUE +0.   
OTPOOL     05  WS-OUTER-POOL-TIER-RANK PIC S9(4) USAGE COMP VALUE +0.   
A04860     05  WS-ITEM-ID              PIC S9(10)V COMP-3 VALUE +0.     
P805AP     05  WS-ACCT-ATTRIBUTE-EXIST PIC X(01) VALUE 'N'.             
      *                                                                         
       01  WS-WQ-COMMENTS.                                              
           05  WS-GROUP2-DHR-WQ.                                        
               10  FILLER                  PIC X(50)  VALUE             
                   "MOVE GROUP 2 DHR CUST TO GROUP 1 FOR GOOD PAYMENT ".
               10  FILLER                  PIC X(28)  VALUE             
                   "HISTORY. ACCOUNT IS ON-HOLD.".                      
      *                                                                         
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE          PIC S9(04) COMP VALUE 0.         
           05  S-RETURN-CODE          PIC S9(04) COMP VALUE 0.          
           05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
      *                                                                         
       01  WS-RESTART-MISC.                                             
           05  WS-CHKP-LUW-LIMIT         PIC 9(04)   VALUE ZERO.        
           05  WS-CHKP-UPD-LIMIT         PIC 9(04)   VALUE ZERO.        
           05  WS-DEFAULT-CHKP-LUW-LIMIT PIC 9(04)   VALUE 100.         
           05  WS-DEFAULT-CHKP-UPD-LIMIT PIC 9(04)   VALUE 100.         
      *                                                                         
       01  WS-NULL-IND-VARS.                                            
           05 WS-NULL-IND              PIC S9(04) COMP.                 
           05 WS-NULL-IND1             PIC S9(04) COMP.                 
           05 WS-NULL-IND2             PIC S9(04) COMP.                 
           05 WS-NULL-IND3             PIC S9(04) COMP.                 
I00113     05 WS-NULL-IND4             PIC S9(04) COMP.                 
P00172     05 WS-NULL-IND5             PIC S9(04) COMP.                 
      *                                                                         
           COPY FIOCA00.                                                        
           COPY FIOJC01.                                                        
                                                                        
           COPY CWS0070B.                                               07940000
                                                                        
      ***************************************************************** 04691123
      * WORKING STORAGE COPYBOOK FOR GOOD PAYMENT CRITERIA CHECKING     04692023
      ***************************************************************** 04693023
           COPY CWS00329.                                               04694023
      *                                                                         
      ***************************************************************** 04640000
      * WORKING STORAGE COPYBOOK FOR CODES DATA PRESENT.                04650000
      ***************************************************************** 04660000
           EXEC SQL                                                     04670000
                INCLUDE CWS00056                                        04680000
           END-EXEC.                                                    04690000
                                                                        
           EXEC SQL                                                             
                INCLUDE CWS00038                                                
           END-EXEC.                                                            
P00172*** BEWARE OF BELOW REDIFINITIONS, WHICH ARE LINK TO CWS00038             
P00172 01  WS-BILL-CYCLE-PARM REDEFINES WS-INPUT-DATA-BREAKDOWN.        
P00172     10  WS-PARM-BILL-CYCLE-TEXT PIC X(11).                       
P00172         88  WS-PARM-BILL-CYCLE        VALUE 'BILL-CYCLE-'.       
P00172     10  WS-BILL-CYCLE-NO        PIC X(02).                       
P00172     10  FILLER                  PIC X(01).                       
P00172     10  WS-PARM-CYCLE-VALUE     PIC X(02).                       
P00172     10  FILLER                  PIC X(64).                       
P00172*                                                                         
                                                                        
           EXEC SQL                                                             
                INCLUDE CWS00039                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *  CWS00010  CONTAINS DB2 ABEND VARIABLES                       *         
      *****************************************************************         
       COPY CWS00010.                                                           
                                                                        
      *****************************************************************         
      * WORKING STORAGE FOR CPD09900                                  *         
      *****************************************************************         
       COPY CWS09900.                                                           
                                                                        
      *****************************************************************         
      *  COPYBOOK WITH COMMON SQL VARIABLES                           *         
      *****************************************************************         
       COPY CWS00303.                                                           
                                                                        
A04860******************************************************************        
A04860* WORKING STORAGE COPYBOOK FOR SCSCB077                          *        
A04860******************************************************************        
A04860*                                                                         
A04860     EXEC SQL                                                             
A04860        INCLUDE CWS00077                                                  
A04860     END-EXEC.                                                            
A04860*                                                                         
      *****************************************************************         
      *    DECLARATION FOR SQL COMMAND AREA                           *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_BILL_WINDOW, BN                                *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBBILWDW                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_ACCOUNT, AT                                    *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
P00172*****************************************************************         
P00172*    TABLE : CSS_CUSTOMER, CU                                   *         
P00172*****************************************************************         
P00172     EXEC SQL                                                             
P00172         INCLUDE TBCUST                                                   
P00172     END-EXEC.                                                            
P00172                                                                  
      *****************************************************************         
      *    TABLE : CSS_UTIL_ENVRNMT, UT                               *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_ACCT_ATTRIBUTE, YP                             *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBACTATT                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_ACCT_MKT_TIER, DD                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBMKTIER                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CRM_MKT_TIER, IG                                   *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBMKTTER                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CRM_MKT_TIER_ADJ, 1B                               *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBMKTTAD                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE :  CSS_CREDIT_PROFILE, CZ                            *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBCRPROF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_ACCT_RTPK_AGR ,DF                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCTRG                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_FIXED_FCTR.                                                      
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBFXDFCT                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CRM_OPT_ATTR_INCTV, HQ                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBOPTATT                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_JOB_PARM, G6                                   *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 07613000
      * CSS_MNT_TRANS_HIST                                              07620000
      ***************************************************************** 07630000
           EXEC SQL                                                     07640000
              INCLUDE TBMNHIST                                          07650000
           END-EXEC.                                                    07660000
                                                                        
      ***************************************************************** 07680000
      * CSS_MT_TRN_HST_DET                                              07690000
      ***************************************************************** 07700000
           EXEC SQL                                                     07710000
              INCLUDE TBMNHDT                                           07720000
           END-EXEC.                                                    07730000
                                                                        
      *****************************************************************         
      *    TABLE : CSS_DELINQUENCY, C8                                *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 04770000
      *    CSS_CODE_VALUE,  UV                                          04780000
      ***************************************************************** 04790000
           EXEC SQL                                                     04800000
               INCLUDE TBCDVALU                                         04810000
           END-EXEC.                                                    04820000
                                                                        
      ***************************************************************** 04770000
      *    CRM_TIER_ACCT_TYPE, TT                                       04780000
      ***************************************************************** 04790000
           EXEC SQL                                                     04800000
               INCLUDE TBTIACTP                                         04810000
           END-EXEC.                                                    04820000
      *                                                                 07740000
P00453***************************************************************** 04770000
P00453*    CSS_PREPAY_HIST PK                                           04780000
P00453***************************************************************** 04790000
P00453     EXEC SQL                                                             
P00453       INCLUDE TBPREHST                                                   
P00453     END-EXEC.                                                            
      ***************************************************************** 07165001
      *    TABLE : CSS_REG_PROFILE, LR                                * 07166001
      ***************************************************************** 07167001
           EXEC SQL                                                     07168001
               INCLUDE TBREGPRF                                         07169001
           END-EXEC.                                                    07169101
      *                                                                 07169208
      ***************************************************************** 03230000
      *    TABLE : CRM_RT_PKG_OPTION, FI                              * 07166001
      ***************************************************************** 07167001
           EXEC SQL                                                     07168001
               INCLUDE TBRTPKGO                                         07169001
           END-EXEC.                                                    07169101
      *                                                                 07169208
I00113*****************************************************************         
I00113* CSS_CUST_STATS, CE                                            *         
I00113*****************************************************************         
I00113      EXEC SQL                                                            
I00113           INCLUDE TBCSTSTS                                               
I00113      END-EXEC.                                                           
I00113*                                                                 07169208
OTPOOL***************************************************************** 02620000
OTPOOL*    CSS_LOCAL_OFFICE - B1                                      * 02630000
OTPOOL***************************************************************** 02640000
OTPOOL*                                                                 02650000
OTPOOL     EXEC SQL                                                     02660000
OTPOOL          INCLUDE TBLOCOFC                                        02670000
OTPOOL     END-EXEC.                                                    02680000
OTPOOL*                                                                 02690000
      ***************************************************************** 03230000
      **   SQL DECLARE STATEMENTS                                    ** 03240000
      ***************************************************************** 03250000
      *----------------------------------------------------------------*03260000
      * CURSOR TO GET REGULATED CUSTOMERS                              *        
      *----------------------------------------------------------------*03260000
      *                                                                         
           EXEC SQL                                                     
            DECLARE REGULATED_ACCT CURSOR WITH HOLD FOR                 
             SELECT AT.ACCOUNT_NO                                       
I00113             ,AT.CUSTOMER_NO                                      
                   ,AT.BILL_CYCLE                                       
                   ,AT.REV_MTH_LST_NRML                                 
                   ,AT.CODES_DATA_PRESENT                               
                   ,UT.GAS_BASE_LAST_UPDT                               
                   ,UT.IC_NO                                            
                   ,UT.RT_PKG_OPT_SEQ_NO                                
                   ,DD.TIER_CUST_STAT_CD                                
                   ,DD.TIER_ACCT_TYPE_CD                                
                   ,DD.MKT_TIER_RANKING                                 
                   ,DD.MKT_TIER_START_DT                                
                   ,LR.SENIOR_FL                                        
               FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                        
                   ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                   
                   ,CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                    
                   ,CSS_ACCT_MKT_TIER DD WITH(READUNCOMMITTED)                  
              WHERE AT.CODE_ACCT_STAT    = 'A'                          
                AND AT.BILL_CYCLE  IN (:WS-CYC1,:WS-CYC2                
                                       ,:WS-BILL-CYCLE1,:WS-BILL-CYCLE2)
                AND AT.ACCOUNT_NO        = UT.ACCOUNT_NO                
                AND UT.CODE_UTIL_TYPE    = 'G'                          
                AND LR.ACCOUNT_NO        = AT.ACCOUNT_NO                
                AND DD.ACCOUNT_NO        = AT.ACCOUNT_NO                
                AND DD.EFF_START_DT <> IIF(TRY_CONVERT(DATE, 
                                                       :WS-EFF-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-EFF-START-DT
              ) <> 0) OR (LEN(:WS-EFF-START-DT) <> 10), CIS.CHAR2DATE(
                                                       :WS-EFF-START-DT
              ), CONVERT(DATE, :WS-EFF-START-DT) )                 
                AND DD.EFF_START_DT = ( SELECT MAX(DD1.EFF_START_DT)    
                                   FROM CSS_ACCT_MKT_TIER DD1
                           WITH(READUNCOMMITTED)           
                                  WHERE DD1.ACCOUNT_NO = AT.ACCOUNT_NO )
             ORDER BY AT.ACCOUNT_NO                                     
T35434       FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE REGULATED_ACCT CURSOR WITH HOLD FOR                         
MFA-TR*      SELECT AT.ACCOUNT_NO                                               
MFA-TR*            ,AT.CUSTOMER_NO                                              
MFA-TR*            ,AT.BILL_CYCLE                                               
MFA-TR*            ,AT.REV_MTH_LST_NRML                                         
MFA-TR*            ,AT.CODES_DATA_PRESENT                                       
MFA-TR*            ,UT.GAS_BASE_LAST_UPDT                                       
MFA-TR*            ,UT.IC_NO                                                    
MFA-TR*            ,UT.RT_PKG_OPT_SEQ_NO                                        
MFA-TR*            ,DD.TIER_CUST_STAT_CD                                        
MFA-TR*            ,DD.TIER_ACCT_TYPE_CD                                        
MFA-TR*            ,DD.MKT_TIER_RANKING                                         
MFA-TR*            ,DD.MKT_TIER_START_DT                                        
MFA-TR*            ,LR.SENIOR_FL                                                
MFA-TR*        FROM CSS_ACCOUNT AT                                              
MFA-TR*            ,CSS_UTIL_ENVRNMT UT                                         
MFA-TR*            ,CSS_REG_PROFILE LR                                          
MFA-TR*            ,CSS_ACCT_MKT_TIER DD                                        
MFA-TR*       WHERE AT.CODE_ACCT_STAT    = 'A'                                  
MFA-TR*         AND AT.BILL_CYCLE  IN (:WS-CYC1,:WS-CYC2                        
MFA-TR*                                ,:WS-BILL-CYCLE1,:WS-BILL-CYCLE2)        
MFA-TR*         AND AT.ACCOUNT_NO        = UT.ACCOUNT_NO                        
MFA-TR*         AND UT.CODE_UTIL_TYPE    = 'G'                                  
MFA-TR*         AND LR.ACCOUNT_NO        = AT.ACCOUNT_NO                        
MFA-TR*         AND DD.ACCOUNT_NO        = AT.ACCOUNT_NO                        
MFA-TR*         AND DD.EFF_START_DT <> :WS-EFF-START-DT                         
MFA-TR*         AND DD.EFF_START_DT = ( SELECT MAX(DD1.EFF_START_DT)            
MFA-TR*                            FROM CSS_ACCT_MKT_TIER DD1                   
MFA-TR*                           WHERE DD1.ACCOUNT_NO = AT.ACCOUNT_NO )        
MFA-TR*      ORDER BY AT.ACCOUNT_NO                                             
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *----------------------------------------------------------------*03260000
      * CURSOR TO GET NON BILLED PROSPECTIVE DREGULATED CUSTOMERS      *03260000
      *----------------------------------------------------------------*03260000
      *                                                                         
           EXEC SQL                                                     
            DECLARE DREG_PROSPECT_CUR  CURSOR WITH HOLD FOR             
             SELECT AT.ACCOUNT_NO                                       
P00453             ,AT.CODES_DATA_PRESENT                               
OTPOOL             ,AT.LOCAL_OFFICE                                     
OTPOOL             ,COALESCE(B1.DIVISION_NO,'   ')                        
                   ,DD.TIER_CUST_STAT_CD                                
                   ,DD.TIER_ACCT_TYPE_CD                                
                   ,DD.MKT_TIER_RANKING                                 
                   ,DD.MKT_TIER_START_DT                                
               FROM CSS_ACCOUNT        AT WITH(READUNCOMMITTED)                 
OTPOOL             ,CSS_LOCAL_OFFICE   B1 WITH(READUNCOMMITTED)                 
                   ,CSS_ACCT_MKT_TIER  DD WITH(READUNCOMMITTED)                 
              WHERE AT.CODE_ACCT_STAT   = 'A'                           
                AND AT.BILL_CYCLE IN (:WS-CYC1,:WS-CYC2                 
                                     ,:WS-BILL-CYCLE1,:WS-BILL-CYCLE2)  
                AND AT.REV_MTH_LST_NRML > 0                             
OTPOOL          AND B1.LOCAL_OFFICE = AT.LOCAL_OFFICE                   
OTPOOL          AND B1.COMPANY_NO   = AT.COMPANY_NO                     
                AND AT.ACCOUNT_NO   = DD.ACCOUNT_NO                     
                AND DD.EFF_START_DT = (                                 
                              SELECT MAX(EFF_START_DT)                  
                                FROM CSS_ACCT_MKT_TIER DD1
                           WITH(READUNCOMMITTED)              
                               WHERE DD1.ACCOUNT_NO = AT.ACCOUNT_NO)    
                AND DD.TIER_CUST_STAT_CD = 'P'                          
T35434          FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE DREG_PROSPECT_CUR  CURSOR WITH HOLD FOR                     
MFA-TR*      SELECT AT.ACCOUNT_NO                                               
MFA-TR*            ,AT.CODES_DATA_PRESENT                                       
MFA-TR*            ,AT.LOCAL_OFFICE                                             
MFA-TR*            ,IFNULL(B1.DIVISION_NO,'   ')                                
MFA-TR*            ,DD.TIER_CUST_STAT_CD                                        
MFA-TR*            ,DD.TIER_ACCT_TYPE_CD                                        
MFA-TR*            ,DD.MKT_TIER_RANKING                                         
MFA-TR*            ,DD.MKT_TIER_START_DT                                        
MFA-TR*        FROM CSS_ACCOUNT        AT                                       
MFA-TR*            ,CSS_LOCAL_OFFICE   B1                                       
MFA-TR*            ,CSS_ACCT_MKT_TIER  DD                                       
MFA-TR*       WHERE AT.CODE_ACCT_STAT   = 'A'                                   
MFA-TR*         AND AT.BILL_CYCLE IN (:WS-CYC1,:WS-CYC2                         
MFA-TR*                              ,:WS-BILL-CYCLE1,:WS-BILL-CYCLE2)          
MFA-TR*         AND AT.REV_MTH_LST_NRML > 0                                     
MFA-TR*         AND B1.LOCAL_OFFICE = AT.LOCAL_OFFICE                           
MFA-TR*         AND B1.COMPANY_NO   = AT.COMPANY_NO                             
MFA-TR*         AND AT.ACCOUNT_NO   = DD.ACCOUNT_NO                             
MFA-TR*         AND DD.EFF_START_DT = (                                         
MFA-TR*                       SELECT MAX(EFF_START_DT)                          
MFA-TR*                         FROM CSS_ACCT_MKT_TIER DD1                      
MFA-TR*                        WHERE DD1.ACCOUNT_NO = AT.ACCOUNT_NO)            
MFA-TR*         AND DD.TIER_CUST_STAT_CD = 'P'                                  
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *----------------------------------------------------------------*03260000
      * CURSOR TO GET CURRENT AND ADJUSTMENT TIER RANKING              *03260000
      *----------------------------------------------------------------*03260000
      *                                                                         
           EXEC SQL                                                     
            DECLARE MKT_TIER_ADJ_CUR CURSOR FOR                         
             SELECT [1B].TIER_CUST_STAT_CD                                
                   ,[1B].TIER_ACCT_TYPE_CD                                
                   ,[1B].MKT_TIER_RANKING                                 
                   ,[1B].MKT_TIER_START_DT                                
                   ,[1B].ADJ_TIER_SEQ_NO                                  
                   ,[1B].AGL_LOW_INCM_SR_FL                               
                   ,[1B].MIN_GOOD_PAY_QTY                                 
                   ,[1B].MISSED_PYMT_QTY                                  
                   ,[1B].APPLICATION_CD                                   
                   ,[1B].ADJ_TIER_ACCT_TYPE                               
                   ,[1B].ADJ_TIER_RANKING                                 
                   ,[1B].ADJ_TIER_START_DT                                
                   ,[1B].ADJ_START_DT                                     
                   ,[1B].ADJ_END_DT                                       
                   ,[1B].ADJ_SOURCE_CD                                    
                   ,[1B].DHR_QUALIFIED_FL                                 
P00172             ,[1B].EVAL_MONTHS_QTY                                  
               FROM CRM_MKT_TIER_ADJ [1B] WITH(READUNCOMMITTED)                 
              WHERE [1B].APPLICATION_CD <> 'IG'                           
P00172          AND [1B].ADJ_START_DT      <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )              
P00172          AND [1B].ADJ_END_DT        >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )              
P00677        ORDER BY [1B].MKT_TIER_RANKING    ASC                       
P00677                ,[1B].MISSED_PYMT_QTY     DESC                      
P00677                ,[1B].MIN_GOOD_PAY_QTY    DESC                      
P00677                ,[1B].AGL_LOW_INCM_SR_FL  ASC                       
P00677                ,[1B].DHR_QUALIFIED_FL    DESC                      
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE MKT_TIER_ADJ_CUR CURSOR FOR                                 
MFA-TR*      SELECT 1B.TIER_CUST_STAT_CD                                        
MFA-TR*            ,1B.TIER_ACCT_TYPE_CD                                        
MFA-TR*            ,1B.MKT_TIER_RANKING                                         
MFA-TR*            ,1B.MKT_TIER_START_DT                                        
MFA-TR*            ,1B.ADJ_TIER_SEQ_NO                                          
MFA-TR*            ,1B.AGL_LOW_INCM_SR_FL                                       
MFA-TR*            ,1B.MIN_GOOD_PAY_QTY                                         
MFA-TR*            ,1B.MISSED_PYMT_QTY                                          
MFA-TR*            ,1B.APPLICATION_CD                                           
MFA-TR*            ,1B.ADJ_TIER_ACCT_TYPE                                       
MFA-TR*            ,1B.ADJ_TIER_RANKING                                         
MFA-TR*            ,1B.ADJ_TIER_START_DT                                        
MFA-TR*            ,1B.ADJ_START_DT                                             
MFA-TR*            ,1B.ADJ_END_DT                                               
MFA-TR*            ,1B.ADJ_SOURCE_CD                                            
MFA-TR*            ,1B.DHR_QUALIFIED_FL                                         
MFA-TR*            ,1B.EVAL_MONTHS_QTY                                          
MFA-TR*        FROM CRM_MKT_TIER_ADJ 1B                                         
MFA-TR*       WHERE 1B.APPLICATION_CD <> 'IG'                                   
MFA-TR*         AND 1B.ADJ_START_DT      <= :WS-INPUT-DATE                      
MFA-TR*         AND 1B.ADJ_END_DT        >= :WS-INPUT-DATE                      
MFA-TR*       ORDER BY 1B.MKT_TIER_RANKING    ASC                               
MFA-TR*               ,1B.MISSED_PYMT_QTY     DESC                              
MFA-TR*               ,1B.MIN_GOOD_PAY_QTY    DESC                              
MFA-TR*               ,1B.AGL_LOW_INCM_SR_FL  ASC                               
MFA-TR*               ,1B.DHR_QUALIFIED_FL    DESC                              
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *----------------------------------------------------------------*03260000
      * CURSOR TO GET OPEN BILL CYCLE ON A GIVEN DATE                  *03260000
      *----------------------------------------------------------------*03260000
      *                                                                         
           EXEC SQL                                                     
            DECLARE BILL_CYC_CUR  CURSOR FOR                            
             SELECT BN.BILL_CYCLE                                       
               FROM CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                    
              WHERE BN.DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                          :WS-HOLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE
              ) <> 0) OR (LEN(:WS-HOLD-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-HOLD-DATE
              ), CONVERT(DATE, :WS-HOLD-DATE) )                     
                AND BN.DATE_EXTRACT =                                   
             (SELECT MIN(B1.DATE_EXTRACT)                               
               FROM CSS_BILL_WINDOW B1 WITH(READUNCOMMITTED)                    
              WHERE B1.BILL_CYCLE   = BN.BILL_CYCLE                     
                AND B1.REVENUE_MONTH = BN.REVENUE_MONTH)                
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE BILL_CYC_CUR  CURSOR FOR                                    
MFA-TR*      SELECT BN.BILL_CYCLE                                               
MFA-TR*        FROM CSS_BILL_WINDOW BN                                          
MFA-TR*       WHERE BN.DATE_EXTRACT = :WS-HOLD-DATE                             
MFA-TR*         AND BN.DATE_EXTRACT =                                           
MFA-TR*      (SELECT MIN(B1.DATE_EXTRACT)                                       
MFA-TR*        FROM CSS_BILL_WINDOW B1                                          
MFA-TR*       WHERE B1.BILL_CYCLE   = BN.BILL_CYCLE                             
MFA-TR*         AND B1.REVENUE_MONTH = BN.REVENUE_MONTH)                        
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
      ***                                                                       
       01  WS-END                          PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSCA280 ENDS HERE  '.            
      *                                                                         
      **************************                                                
       PROCEDURE DIVISION.                                              
      ******************************************************************PCS03300
      **                                                              **PCS03310
      **    0000-MAINLINE                                             **PCS03320
      **                                                              **PCS03330
      ******************************************************************PCS03340
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT         
                                                                        
P00172     PERFORM 1000-PROCESS-INPUT            THRU 1000-EXIT         
                                                                        
           PERFORM 9000-TERMINATE                THRU 9000-EXIT         
                                                                        
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS03300
      **                                                              **PCS03310
      **    0100-INITIALIZATION                                       **PCS03320
      **                                                              **PCS03330
      ******************************************************************PCS03340
       0100-INITIALIZATION.                                             
      *                                                                         
           INITIALIZE WS-SYSIPT                                         
           PERFORM 6253-GET-FJC01-CHKP-LIMIT                            
                                               THRU 6253-EXIT           
                                                                        
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT                   
           IF COMMON-DATE-NEEDED                                        
               PERFORM 0101-GET-COMMON-JP      THRU 0101-EXIT           
           END-IF                                                       
                                                                        
           MOVE WS-INPUT-DATE            TO WS-HOLD-DATE                
                                            WS-EFF-START-DT             
                                                                        
P00172     INITIALIZE WS-MKT-TIER-ADJ-TABLE                             
P00172                                                                  
P00172     PERFORM 0105-LOAD-MKT-TIER-ADJ         THRU 0105-EXIT        
P00172                                                                  
P00172     MOVE WS-SUB-1B                TO WS-SUB-1B-MAX               
P00172                                                                  
P00172     PERFORM 0106-GET-JOB-PARM-DATA      THRU 0106-EXIT           
                                                                        
I00113* ADD CLOSE OUT DATE FOR CURRENT REVENUE MONTH                            
I00113     MOVE WS-REVENUE-MONTH-JP          TO WS-INPUT-REV-MONTH      
I00113                                          BN-REVENUE-MONTH        
I00113     PERFORM 7780-MAX-REV-MTH-DATE        THRU 7780-EXIT          
I00113     MOVE BN-DATE-EXTRACT              TO WS-REV-CLOSE-OUT-00     
I00113                                                                  
I00113* ADD CLOSE OUT DATE FOR CURRENT REVENUE MONTH + 1                        
I00113     MOVE +01                          TO WS-MONTHS-TO-ADD        
I00113     PERFORM 0410-ADD-REVENUE-MONTHS      THRU 0410-EXIT          
I00113     MOVE BN-DATE-EXTRACT              TO WS-REV-CLOSE-OUT-30     
I00113                                                                  
I00113* ADD CLOSE OUT DATE FOR CURRENT REVENUE MONTH + 1                        
I00113     MOVE WS-REVENUE-MONTH-JP          TO WS-INPUT-REV-MONTH      
I00113     MOVE +02                          TO WS-MONTHS-TO-ADD        
I00113     PERFORM 0410-ADD-REVENUE-MONTHS      THRU 0410-EXIT          
I00113     MOVE BN-DATE-EXTRACT              TO WS-REV-CLOSE-OUT-60     
I00113                                                                  
      * GET CURRENT BILLING CYLCE                                               
           PERFORM 0210-GET-CURR-BILL-CYCLE     THRU 0210-EXIT          
                                                                        
      * GET THE RATE PKG EXPIRE VALUE + 1                                       
           MOVE '01'                   TO C8-COMPANY-NO                 
           MOVE WS-EXPIRE-DELINQ-CD    TO C8-DELINQ-CD                  
           PERFORM 7010-SELECT-DELINQ-VALUE     THRU 7010-EXIT          
           MOVE C8-DELINQ-VALUE        TO WS-EXPIRE-DELINQ-VALUE        
I00113                                    WS-SCANA-SR-RENEWAL-DAY       
           ADD 1                       TO WS-EXPIRE-DELINQ-VALUE        
I00113     MOVE WS-EXPIRE-DELINQ-VALUE TO WS-SCANA-SR-30-DAY-VAL        
I00113     COMPUTE WS-SCANA-SR-60-DAY-VAL = C8-DELINQ-VALUE + 2         
I00113                                                                  
I00113* GET SCANA SENIOR AGE                                                    
I00113     MOVE '01'                   TO C8-COMPANY-NO.                
I00113     MOVE WS-SCANA-SR-DELINQ-CD  TO C8-DELINQ-CD.                 
I00113     PERFORM 7010-SELECT-DELINQ-VALUE     THRU 7010-EXIT.         
I00113     MOVE C8-DELINQ-VALUE        TO WS-SCANA-SR-DELINQ-VAL.       
                                                                        
P00453     MOVE WS-PRP-DEFAULT-TIER    TO C8-DELINQ-CD                  
P00453     PERFORM 7010-SELECT-DELINQ-VALUE     THRU 7010-EXIT.         
P00453     MOVE C8-DELINQ-VALUE        TO WS-PRP-MKT-TIER-RANK.         
                                                                        
OTPOOL     MOVE 'DRG-RES-OTP-MKT-TIER' TO C8-DELINQ-CD                  
OTPOOL     PERFORM 7010-SELECT-DELINQ-VALUE     THRU 7010-EXIT.         
OTPOOL     MOVE C8-DELINQ-VALUE        TO WS-DRG-RES-OTP-MKT-TIER.      
                                                                        
OTPOOL     MOVE 'DRG-SCM-OTP-TIER-AUG' TO C8-DELINQ-CD                  
OTPOOL     PERFORM 7010-SELECT-DELINQ-VALUE     THRU 7010-EXIT.         
OTPOOL     MOVE C8-DELINQ-VALUE        TO WS-DRG-SCM-OTP-TIER-AUG.      
                                                                        
OTPOOL     MOVE 'DRG-SCM-OTP-TIER-SAV' TO C8-DELINQ-CD                  
OTPOOL     PERFORM 7010-SELECT-DELINQ-VALUE     THRU 7010-EXIT.         
OTPOOL     MOVE C8-DELINQ-VALUE        TO WS-DRG-SCM-OTP-TIER-SAV.      
                                                                        
OTPOOL     MOVE 'DRG-SCM-OTP-TIER-ROM' TO C8-DELINQ-CD                  
OTPOOL     PERFORM 7010-SELECT-DELINQ-VALUE     THRU 7010-EXIT.         
OTPOOL     MOVE C8-DELINQ-VALUE        TO WS-DRG-SCM-OTP-TIER-ROM.      
                                                                        
OTPOOL     MOVE 'DRG-SCM-OTP-TIER-MAC' TO C8-DELINQ-CD                  
OTPOOL     PERFORM 7010-SELECT-DELINQ-VALUE     THRU 7010-EXIT.         
OTPOOL     MOVE C8-DELINQ-VALUE        TO WS-DRG-SCM-OTP-TIER-MAC.      
                                                                        
OTPOOL     MOVE 'DRG-SCM-OTP-TIER-BRU' TO C8-DELINQ-CD                  
OTPOOL     PERFORM 7010-SELECT-DELINQ-VALUE     THRU 7010-EXIT.         
OTPOOL     MOVE C8-DELINQ-VALUE        TO WS-DRG-SCM-OTP-TIER-BRU.      
                                                                        
OTPOOL     MOVE 'DRG-SCM-OTP-TIER-VAL' TO C8-DELINQ-CD                  
OTPOOL     PERFORM 7010-SELECT-DELINQ-VALUE     THRU 7010-EXIT.         
OTPOOL     MOVE C8-DELINQ-VALUE        TO WS-DRG-SCM-OTP-TIER-VAL.      
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *    GET COMMON FROM CSS_JOB_PARM, NOT COMMONDATE          *              
      ************************************************************              
       0101-GET-COMMON-JP.                                              
                                                                        
           MOVE SPACES                   TO WS-SYSIPT.                  
           MOVE 'COMMON'                 TO WS-PROGRAM.                 
           MOVE WS-DATE                  TO WS-COMMAND.                 
           MOVE ZEROS                    TO WS-SEQUENCE.                
           MOVE WS-KEY-AREA              TO E-FJC01-KEY.                
                                                                        
           PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
                                                                        
           PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
               UNTIL (RUN-DATE AND INPUT-ACTIVE)                        
                  OR  END-OF-SYSIPT.                                    
                                                                        
           EVALUATE TRUE                                                
              WHEN END-OF-SYSIPT                                        
                 DISPLAY ' '                                            
                 DISPLAY '**  PCSCA280 PROCESSING ERROR  **'            
                 DISPLAY '**    NO ACTIVE COMMON DATE FOUND'            
                 DISPLAY '**  PROCESSING TERMINATED **'                 
                 PERFORM 9900-ABEND  THRU  9900-EXIT                    
              WHEN OTHER                                                
                 PERFORM 7611-CLOSE THRU 7611-EXIT                      
           END-EVALUATE.                                                
                                                                        
           MOVE WS-INPUT-RUN-DATE        TO WS-INPUT-DATE.              
                                                                        
       0101-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *    LOADS CRM_MKT_TIER_ADJ TABLE                          *              
      ************************************************************              
       0105-LOAD-MKT-TIER-ADJ.                                          
                                                                        
           PERFORM 7400-OPEN-MKT-TIER-ADJ-CUR  THRU 7400-EXIT           
           PERFORM 7410-FETCH-MKT-TIER-ADJ-CUR THRU 7410-EXIT           
                                                                        
           PERFORM 0400-MOVE-MKT-TIER-ADJ      THRU 0400-EXIT           
             UNTIL NO-MKT-TIER-ADJ                                      
                                                                        
           PERFORM 7420-CLOSE-MKT-TIER-ADJ-CUR THRU 7420-EXIT           
                                                                        
           .                                                            
       0105-EXIT.                                                       
           EXIT.                                                        
P00172*                                                                         
P00172******************************************************************        
P00172*   RETRIEVES REVENUE MONTH AND BILL CYCLES FROM CSS_JOB_PARM    *11460000
P00172******************************************************************11470000
P00172 0106-GET-JOB-PARM-DATA.                                          
P00172*                                                                 11500000
P00172* GET COMMON REVENUE MONTH                                        11500000
P00172     MOVE SPACES                   TO WS-SYSIPT.                  
P00172     MOVE 'COMMON'                 TO WS-PROGRAM.                 
P00172     MOVE WS-DATE                  TO WS-COMMAND.                 
P00172     MOVE ZEROS                    TO WS-SEQUENCE.                
P00172     MOVE WS-KEY-AREA              TO E-FJC01-KEY.                
P00172                                                                  
P00172     PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
P00172                                                                  
P00172     PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
P00172         UNTIL (REVENUE-MONTH AND INPUT-ACTIVE)                   
P00172            OR  END-OF-SYSIPT.                                    
P00172                                                                  
P00172     EVALUATE TRUE                                                
P00172        WHEN END-OF-SYSIPT                                        
P00172           DISPLAY '*********************************'            
P00172           DISPLAY '**   0106-GET-REVENUE-MONTH    **'            
P00172           DISPLAY '**  PCSCA280 PROCESSING ERROR  **'            
P00172           DISPLAY '**    NO ACTIVE REVENUE MONTH  **'            
P00172           DISPLAY '**     PROCESSING TERMINATED   **'            
P00172           DISPLAY '*********************************'            
P00172           PERFORM 9900-ABEND  THRU  9900-EXIT                    
P00172        WHEN OTHER                                                
P00172           PERFORM 7611-CLOSE THRU 7611-EXIT                      
P00172     END-EVALUATE.                                                
P00172                                                                  
P00172     MOVE WS-REVENUE-MONTH-PARM    TO WS-REVENUE-MONTH-JP.        
P00172                                                                  
P00172* GET JOB_PARM CYLCES IF PRESENT                                          
P00172     MOVE SPACES                 TO WS-SYSIPT                     
P00172     MOVE WS-PGRMNAME            TO WS-PROGRAM                    
P00172     MOVE WS-PARM                TO WS-COMMAND                    
P00172     MOVE ZEROES                 TO WS-SEQUENCE                   
P00172     MOVE WS-KEY-AREA            TO E-FJC01-KEY                   
P00172     PERFORM 7600-START-FCSJC01           THRU 7600-EXIT          
P00172     PERFORM 7610-READ-FCSJC01            THRU 7610-EXIT          
P00172     PERFORM 0110-GET-PARM-DATA           THRU 0110-EXIT.         
P00172                                                                  
P00172*                                                                 11710000
P00172 0106-EXIT.                                                       
P00172     EXIT.                                                        
P00172                                                                  
      ************************************************************              
P00172*    CHECK FOR JOB_PARM DATA                               *              
      ************************************************************              
P00172 0110-GET-PARM-DATA.                                              
      *                                                                         
P00172     PERFORM UNTIL END-OF-SYSIPT                                  
P00172        IF INPUT-ACTIVE                                           
P00172           EVALUATE TRUE                                          
P00172              WHEN WS-PARM-BILL-CYCLE                             
P00172                IF WS-BILL-CYCLE-NO = '01'                        
P00172                   MOVE WS-PARM-CYCLE-VALUE   TO WS-BILL-CYCLE1   
P00172                   DISPLAY 'PCSCA280 HAS TAKEN PARM CYC1 : '      
P00172                                                 WS-BILL-CYCLE1   
P00172                END-IF                                            
P00172                                                                  
P00172                IF WS-BILL-CYCLE-NO = '02'                        
P00172                   MOVE WS-PARM-CYCLE-VALUE   TO WS-BILL-CYCLE2   
P00172                   DISPLAY 'PCSCA280 HAS TAKEN PARM CYC2 : '      
P00172                                                 WS-BILL-CYCLE2   
P00172                END-IF                                            
P00172                                                                  
P00172                MOVE SPACES                   TO                  
P00172                                         WS-PARM-BILL-CYCLE-TEXT  
P00172           END-EVALUATE                                           
P00172        END-IF                                                    
P00172        PERFORM 7610-READ-FCSJC01        THRU 7610-EXIT           
P00172     END-PERFORM.                                                 
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  0210-GET-CURR-BILL-CYCLE                                  **          
      **  GETS THE OPEN BILL CYCLE OF A GIVEN DATE                  **          
      ****************************************************************          
       0210-GET-CURR-BILL-CYCLE.                                        
                                                                        
           MOVE WS-INPUT-DATE          TO   WS-HOLD-DATE                
                                                                        
           PERFORM 7200-OPEN-BILL-CYC-CUR      THRU 7200-EXIT           
                                                                        
           PERFORM 7210-FETCH-BILL-CYC-CUR     THRU 7210-EXIT           
           MOVE BN-BILL-CYCLE          TO   WS-CYC1                     
           DISPLAY 'BILL CYCLE #  : ' WS-CYC1                           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              PERFORM 7210-FETCH-BILL-CYC-CUR  THRU 7210-EXIT           
              MOVE BN-BILL-CYCLE       TO   WS-CYC2                     
              DISPLAY 'BILL CYCLE #  : ' WS-CYC2                        
           END-IF                                                       
                                                                        
           PERFORM 7220-CLOSE-BILL-CYC-CUR     THRU 7220-EXIT           
           .                                                            
       0210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                 11740000
       0400-MOVE-MKT-TIER-ADJ.                                          
      *                                                                         
           ADD 1                       TO WS-SUB-1B                     
                                                                        
           MOVE 1B-TIER-CUST-STAT-CD TO WS-TIER-CUST-STAT-CD (WS-SUB-1B)
           MOVE 1B-TIER-ACCT-TYPE-CD TO WS-TIER-ACCT-TYPE-CD (WS-SUB-1B)
           MOVE 1B-MKT-TIER-RANKING  TO WS-MKT-TIER-RANKING (WS-SUB-1B) 
           MOVE 1B-MKT-TIER-START-DT TO WS-MKT-TIER-START-DT (WS-SUB-1B)
           MOVE 1B-ADJ-TIER-SEQ-NO   TO WS-ADJ-TIER-SEQ-NO (WS-SUB-1B)  
           MOVE 1B-AGL-LOW-INCM-SR-FL                                   
                                   TO WS-AGL-LOW-INCM-SR-FL (WS-SUB-1B) 
           IF WS-NULL-IND1 < 0                                          
              MOVE 'Y'       TO WS-MIN-GOOD-PAY-QTY-NULL-IND (WS-SUB-1B)
              MOVE 0         TO WS-MIN-GOOD-PAY-QTY (WS-SUB-1B)         
           ELSE                                                         
              MOVE 'N'       TO WS-MIN-GOOD-PAY-QTY-NULL-IND (WS-SUB-1B)
              MOVE 1B-MIN-GOOD-PAY-QTY                                  
                             TO WS-MIN-GOOD-PAY-QTY (WS-SUB-1B)         
           END-IF                                                       
                                                                        
P00172     IF WS-NULL-IND5 < 0                                          
P00172        MOVE 0                  TO WS-MISSED-PYMT-QTY (WS-SUB-1B) 
P00172     ELSE                                                         
P00172        MOVE 1B-MISSED-PYMT-QTY TO WS-MISSED-PYMT-QTY (WS-SUB-1B) 
P00172     END-IF                                                       
P00172                                                                  
           MOVE 1B-APPLICATION-CD    TO WS-APPLICATION-CD (WS-SUB-1B)   
           MOVE 1B-ADJ-TIER-ACCT-TYPE                                   
                                   TO WS-ADJ-TIER-ACCT-TYPE (WS-SUB-1B) 
           MOVE 1B-ADJ-TIER-RANKING  TO WS-ADJ-TIER-RANKING (WS-SUB-1B) 
           MOVE 1B-ADJ-TIER-START-DT TO WS-ADJ-TIER-START-DT (WS-SUB-1B)
           MOVE 1B-ADJ-START-DT      TO WS-ADJ-START-DT (WS-SUB-1B)     
           MOVE 1B-ADJ-END-DT        TO WS-ADJ-END-DT (WS-SUB-1B)       
           MOVE 1B-ADJ-SOURCE-CD     TO WS-ADJ-SOURCE-CD (WS-SUB-1B)    
           MOVE 1B-DHR-QUALIFIED-FL  TO WS-DHR-QUALIFIED-FL (WS-SUB-1B) 
P00172     MOVE 1B-EVAL-MONTHS-QTY   TO WS-EVAL-MONTHS-QTY (WS-SUB-1B)  
                                                                        
           PERFORM 7410-FETCH-MKT-TIER-ADJ-CUR THRU 7410-EXIT           
                                                                        
           .                                                            
       0400-EXIT.                                                       
           EXIT.                                                        
I00113                                                                  
I00113******************************************************************        
I00113* 0410-ADD-REVENUE-MONTHS.                                       *        
I00113*     ADD REVENUE MONTHS.                                        *        
I00113******************************************************************        
I00113 0410-ADD-REVENUE-MONTHS.                                         
I00113                                                                  
I00113     MOVE 1                      TO WS-SUB-R                      
I00113     PERFORM 0450-GET-NEXT-REV-MONTH     THRU 0450-EXIT           
I00113       UNTIL WS-SUB-R > WS-MONTHS-TO-ADD                          
I00113                                                                  
I00113     MOVE WS-INPUT-REV-MONTH     TO BN-REVENUE-MONTH              
I00113     PERFORM 7780-MAX-REV-MTH-DATE       THRU 7780-EXIT           
I00113     .                                                            
I00113 0410-EXIT.                                                       
I00113     EXIT.                                                        
I00113                                                                  
I00113******************************************************************        
I00113* 0450-GET-NEXT-REV-MONTH.                                       *        
I00113*     STEP UP ONE MONTH FROM THE INPUT REVENUE MONTH             *        
I00113******************************************************************        
I00113 0450-GET-NEXT-REV-MONTH.                                         
I00113                                                                  
I00113     ADD 1                             TO WS-SUB-R                
I00113     MOVE WS-INPUT-REV-MONTH(1:4)      TO WS-START-YR             
I00113     MOVE WS-INPUT-REV-MONTH(5:2)      TO WS-START-MT             
I00113     MOVE WS-START-YR                  TO WS-START-YR-N           
I00113     MOVE WS-START-MT                  TO WS-START-MT-N           
I00113     COMPUTE WS-START-MT-N = WS-START-MT-N + 1                    
I00113     IF WS-START-MT-N > 12                                        
I00113        COMPUTE WS-START-YR-N = WS-START-YR-N + 1                 
I00113        MOVE 01                        TO WS-START-MT-N           
I00113     END-IF                                                       
I00113     MOVE WS-START-YR-N                TO WS-INPUT-REV-MONTH(1:4) 
I00113     MOVE WS-START-MT-N                TO WS-INPUT-REV-MONTH(5:2) 
I00113     .                                                            
I00113 0450-EXIT.                                                       
I00113     EXIT.                                                        
      ******************************************************************        
      *                                                                *        
P00172* 1000-PROCESS-INPUT.                                            *        
      ******************************************************************        
P00172 1000-PROCESS-INPUT.                                              
                                                                        
P00172     PERFORM 1100-PROCESS-REG-CUST       THRU 1100-EXIT           
P00172     PERFORM 1200-PROCESS-DREG-CUST      THRU 1200-EXIT           
P00172                                                                  
P00172     DISPLAY 'PCSCA280 COMPLETED SUCCESSFULLY'.                   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
P00172*                                                                         
P00172******************************************************************        
P00172*                                                                *        
P00172* 1100-PROCESS-REG-CUST.                                         *        
P00172******************************************************************        
P00172 1100-PROCESS-REG-CUST.                                           
                                                                        
           PERFORM 7500-OPEN-REGULATED-CUR     THRU 7500-EXIT           
           PERFORM 7510-FETCH-REGULATED-CUR    THRU 7510-EXIT           
                                                                        
           PERFORM 2010-PROCESS-REGULATED      THRU 2010-EXIT           
             UNTIL NO-REGULATED-ROWS                                    
                                                                        
P00172     PERFORM 7520-CLOSE-REGULATED-CUR    THRU 7520-EXIT.          
P00172                                                                  
P00172 1100-EXIT.                                                       
P00172     EXIT.                                                        
P00172*                                                                         
P00172******************************************************************        
P00172*                                                                *        
P00172* 1200-PROCESS-DREG-CUST.                                        *        
P00172******************************************************************        
P00172 1200-PROCESS-DREG-CUST.                                          
                                                                        
           PERFORM 7750-OPEN-DREG-PROSPECT-CUR THRU 7750-EXIT           
           PERFORM 7760-FETCH-DREG-PROSPECT-CUR                         
                                               THRU 7760-EXIT           
           PERFORM 2025-PROCESS-DREG-CUST      THRU 2025-EXIT           
             UNTIL NO-DREG-ROWS                                         
                                                                        
           PERFORM 7770-CLOSE-DREG-PROSPECT-CUR                         
P00172                                         THRU 7770-EXIT.          
P00172                                                                  
P00172 1200-EXIT.                                                       
P00172     EXIT.                                                        
P00172*                                                                         
P00677******************************************************************        
P00677** TIER ADJUSTMENT PROCESS IS BASED ON PRIORITY OF CHECKS.      **        
P00677** IF A GIVEN CHECK IS TRUE THEN WE WILL NOT EVALUATE FURTHER.  **        
P00677** 1.Initial Bill(AGL Senior)                                   **        
P00677** 2.Bad Payments                                               **        
P00677** 3.Good Payments, DHR_FL and SENIOR_FL                        **        
P00677** 4.Good Payments and DHR Senior Qualification                 **        
P00677** 5.DHR Senior Qualification(No Pymt Check)                    **        
P00677******************************************************************        
P00677*                                                                         
P00677 2010-PROCESS-REGULATED.                                          
P00677*                                                                         
P00677     MOVE  AT-ACCOUNT-NO               TO DD-ACCOUNT-NO           
P00677                                          DF-ACCOUNT-NO           
P00677                                          FF-ACCOUNT-NO           
P00677                                          UT-ACCOUNT-NO.          
P00677     MOVE  AT-CODES-DATA-PRESENT       TO WS-CODES-DATA-PRESENT.  
P00677     MOVE UT-IC-NO                     TO FF-IC-NO                
P00677                                          DF-IC-NO.               
P00677     MOVE '01'                         TO DF-COMPANY-NO.          
P00677     INITIALIZE                           HQ-OPTION-CD            
P00677                                          DF-STATUS-CD            
P00677                                          FI-OPT-CALC-TYPE-CD     
P00677                                          FF-DURATION-REMAIN-NO   
P00677                                          WS-NBR-GOOD-PAYMENT     
P00677                                          WS-NBR-MISSED-PAYMENT   
P00677                                          WS-HIST-EVAL-MONTHS.    
P00677*                                                                         
P00677*** GET DHR FLAG                                                          
P00677     MOVE 'N'                          TO CU-DHR-FL.              
P00677     MOVE AT-CUSTOMER-NO               TO CU-CUSTOMER-NO.         
P00677     PERFORM 7120-CHECK-DHR-STATUS     THRU  7120-EXIT.           
P00677     IF CU-DHR-FL = 'Y' OR 'N'                                    
P00677        CONTINUE                                                  
P00677     ELSE                                                         
P00677        MOVE 'N'                       TO CU-DHR-FL               
P00677     END-IF.                                                      
P00677*                                                                         
P00677*** GET CURRENT OPTION TO CHECK FIXED / VARIABLE RATE ACCT                
P00677     MOVE 'N'                          TO WS-RATE-TYPE-FLAG.      
P00677     PERFORM 7260-SELECT-OPTION-CD  THRU  7260-EXIT.              
P00677     IF FI-OPT-CALC-TYPE-CD = 'FP'                                
P00677        SET FIXED-RATE-CUSTOMER        TO TRUE                    
P00677     ELSE                                                         
P00677        SET VARIABLE-RATE-CUSTOMER     TO TRUE                    
P00677     END-IF.                                                      
P00677*                                                                         
P00677     SET TIER-ADJ-NOT-REQUIRED         TO TRUE.                   
P00677*                                                                         
P00677*** TIER ADJUSTMENT AT INITIAL BILL (100->90/500->490)                    
P00677     IF AT-REV-MTH-LST-NRML = 0                                   
P00677        PERFORM 2110-ADJTIER-INITIAL-BILL  THRU  2110-EXIT        
P00677        VARYING WS-SUB-1B FROM 1 BY 1                             
P00677          UNTIL WS-SUB-1B > WS-SUB-1B-MAX                         
P00677             OR TIER-ADJ-COMPLETED                                
P00677     END-IF.                                                      
P00677*                                                                         
P00677*** GRP2-TIER ADJ CHECK:VARIABLE RATE/DROP(DURATION=0)/DURATION=2         
P00677     IF DD-TIER-ACCT-TYPE-CD    = REG-GRP2-CUST                   
P00677        AND AT-REV-MTH-LST-NRML > 0                               
P00677        IF FIXED-RATE-CUSTOMER                                    
P00677           MOVE DF-OPTION-CD           TO HQ-OPTION-CD            
P00677           PERFORM 7150-SELECT-DURATION-NO  THRU  7150-EXIT       
P00677           EVALUATE TRUE                                          
P00677             WHEN (WS-ACTIVE-RETURN-CODE     =  SUCCESSFUL-CALL   
P00677                   AND FF-DURATION-REMAIN-NO =  0                 
P00677                   AND DF-STATUS-CD          = 'O')               
P00677                  SET TIER-ADJ-REQUIRED     TO TRUE               
P00677             WHEN FF-DURATION-REMAIN-NO = WS-EXPIRE-DELINQ-VALUE  
P00677                  SET TIER-ADJ-REQUIRED     TO TRUE               
P00677             WHEN OTHER                                           
P00677                  SET TIER-ADJ-NOT-REQUIRED TO TRUE               
P00677           END-EVALUATE                                           
P00677        ELSE                                                      
P00677           SET TIER-ADJ-REQUIRED            TO TRUE               
P00677        END-IF                                                    
P00677     END-IF.                                                      
P00677*                                                                         
P00677*** TIER ADJUSTMENT BASED ON BAD PAYMENTS (300->500/290->490)             
P00677     IF TIER-ADJ-REQUIRED                                         
P00677        PERFORM 2120-ADJTIER-BAD-PAYMENTS  THRU  2120-EXIT        
P00677        VARYING WS-SUB-1B FROM 1 BY 1                             
P00677          UNTIL WS-SUB-1B > WS-SUB-1B-MAX                         
P00677             OR TIER-ADJ-COMPLETED                                
P00677     END-IF.                                                      
P00677*                                                                         
P00677*** TIER ADJUSTMENT BASED ON GOOD PAYMENTS, DHR_FL & SENIOR_FL            
P00677*** 300->100/500->100/500->300/290-> 90/490-> 90/490->290                 
P00677     IF TIER-ADJ-REQUIRED                                         
P00677        PERFORM 2130-ADJTIER-GOODPYMT-FLAGS  THRU  2130-EXIT      
P00677        VARYING WS-SUB-1B FROM 1 BY 1                             
P00677          UNTIL WS-SUB-1B > WS-SUB-1B-MAX                         
P00677             OR TIER-ADJ-COMPLETED                                
P00677     END-IF.                                                      
P00677*                                                                         
P00677*** TIER ADJUSTMENT BASED ON GOOD PAYMENTS & DHR SENIOR CHECKS            
P00677*** 290->90/490->90                                                       
P00677     IF TIER-ADJ-REQUIRED                                         
P00677        PERFORM 2140-ADJTIER-GOODPYMT-DHR-SR  THRU  2140-EXIT     
P00677        VARYING WS-SUB-1B FROM 1 BY 1                             
P00677          UNTIL WS-SUB-1B > WS-SUB-1B-MAX                         
P00677             OR TIER-ADJ-COMPLETED                                
P00677     END-IF.                                                      
P00677*                                                                         
P00677*** TIER ADJUSTMENT BASED ON DHR SENIOR CHECKS (EXISTING CUST)            
P00677*** 100 -> 90, 300 -> 290 & 500-> 490                                     
P00677     IF TIER-ADJ-COMPLETED                                        
P00677        CONTINUE                                                  
P00677     ELSE                                                         
P00677        IF AT-REV-MTH-LST-NRML  > 0                               
P00677           IF DD-TIER-ACCT-TYPE-CD = REG-GRP1-CUST                
P00677              MOVE DF-OPTION-CD                TO HQ-OPTION-CD    
P00677              PERFORM 7150-SELECT-DURATION-NO  THRU  7150-EXIT    
P00677           END-IF                                                 
P00677           PERFORM 2150-ADJTIER-DHR-SENIOR-ONLY  THRU  2150-EXIT  
P00677           VARYING WS-SUB-1B FROM 1 BY 1                          
P00677             UNTIL WS-SUB-1B > WS-SUB-1B-MAX                      
P00677                OR TIER-ADJ-COMPLETED                             
P00677        END-IF                                                    
P00677     END-IF.                                                      
P00677*                                                                         
P00677     PERFORM 7510-FETCH-REGULATED-CUR  THRU  7510-EXIT.           
P00677*                                                                         
       2010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 2025-PROCESS-DREG-CUST                                         *        
      ******************************************************************        
       2025-PROCESS-DREG-CUST.                                          
                                                                        
P00453     MOVE 'N'                       TO WS-SKIP-PRP-ACCOUNT-SW.    
P00453     MOVE AT-CODES-DATA-PRESENT     TO WS-CODES-DATA-PRESENT.     
P00453                                                                  
P00453     IF WS-CODE-PRE-PAY-PLAN = WS-ACTIVE                          
P00453        MOVE AT-ACCOUNT-NO          TO PK-ACCOUNT-NO              
P00453        PERFORM 7290-GET-PREPAY-HIST-ROWCOUNT                     
P00453                                    THRU 7290-EXIT                
P00453        IF WS-PREPAY-COUNT = 1 THEN                               
P00453           SET SKIP-PRP-ACCOUNT     TO TRUE                       
P00453        END-IF                                                    
P00453     END-IF.                                                      
P00453                                                                  
P00453     IF SKIP-PRP-ACCOUNT THEN                                     
P00453        CONTINUE                                                  
P00453     ELSE                                                         
              MOVE DD-MKT-TIER-RANKING    TO WS-PREV-MKT-TIER-RANKING   
              MOVE DD-MKT-TIER-START-DT   TO WS-PREV-MKT-TIER-START-DT  
              MOVE DD-TIER-ACCT-TYPE-CD   TO IG-TIER-ACCT-TYPE-CD       
                                                                        
P00453        IF WS-CODE-PRE-PAY-PLAN = WS-ACTIVE                       
P00453           PERFORM 7370-GET-DEFAULT-PRP-TIER   THRU 7370-EXIT     
P00453        ELSE                                                      
OTPOOL           IF B1-DIVISION-NO = 'OUT' AND                          
OTPOOL             (DD-TIER-ACCT-TYPE-CD = 'D' OR 'A' OR 'B' OR 'S')    
OTPOOL              MOVE ZEROS            TO WS-OUTER-POOL-TIER-RANK    
OTPOOL              EVALUATE DD-TIER-ACCT-TYPE-CD                       
OTPOOL                  WHEN 'D'                                        
OTPOOL                  WHEN 'A'                                        
OTPOOL                  WHEN 'B'                                        
OTPOOL                       MOVE WS-DRG-RES-OTP-MKT-TIER               
OTPOOL                                    TO WS-OUTER-POOL-TIER-RANK    
OTPOOL                  WHEN 'S'                                        
OTPOOL                       EVALUATE AT-LOCAL-OFFICE                   
OTPOOL                           WHEN '004'                             
OTPOOL                                MOVE WS-DRG-SCM-OTP-TIER-AUG      
OTPOOL                                    TO WS-OUTER-POOL-TIER-RANK    
OTPOOL                           WHEN '005'                             
OTPOOL                                MOVE WS-DRG-SCM-OTP-TIER-SAV      
OTPOOL                                    TO WS-OUTER-POOL-TIER-RANK    
OTPOOL                           WHEN '006'                             
OTPOOL                                MOVE WS-DRG-SCM-OTP-TIER-ROM      
OTPOOL                                    TO WS-OUTER-POOL-TIER-RANK    
OTPOOL                           WHEN '007'                             
OTPOOL                                MOVE WS-DRG-SCM-OTP-TIER-MAC      
OTPOOL                                    TO WS-OUTER-POOL-TIER-RANK    
OTPOOL                           WHEN '008'                             
OTPOOL                                MOVE WS-DRG-SCM-OTP-TIER-BRU      
OTPOOL                                    TO WS-OUTER-POOL-TIER-RANK    
OTPOOL                           WHEN '009'                             
OTPOOL                                MOVE WS-DRG-SCM-OTP-TIER-VAL      
OTPOOL                                    TO WS-OUTER-POOL-TIER-RANK    
OTPOOL                           WHEN OTHER                             
OTPOOL                                CONTINUE                          
OTPOOL                       END-EVALUATE                               
OTPOOL                  WHEN OTHER                                      
OTPOOL                       CONTINUE                                   
OTPOOL              END-EVALUATE                                        
OTPOOL                                                                  
OTPOOL              IF WS-OUTER-POOL-TIER-RANK > 0                      
OTPOOL                 PERFORM 7380-GET-OUTER-POOL-TIER-DTLS            
OTPOOL                                               THRU 7380-EXIT     
OTPOOL              ELSE                                                
OTPOOL                 PERFORM 7360-GET-DEFAULT-TIER-RANK               
OTPOOL                                               THRU 7360-EXIT     
OTPOOL              END-IF                                              
OTPOOL           ELSE                                                   
                    PERFORM 7360-GET-DEFAULT-TIER-RANK                  
                                                     THRU 7360-EXIT     
OTPOOL           END-IF                                                 
P00453        END-IF                                                    
                                                                        
              MOVE AT-ACCOUNT-NO          TO DD-ACCOUNT-NO              
              MOVE IG-TIER-CUST-STAT-CD   TO DD-TIER-CUST-STAT-CD       
              MOVE IG-MKT-TIER-RANKING    TO DD-MKT-TIER-RANKING        
              MOVE IG-MKT-TIER-START-DT   TO DD-MKT-TIER-START-DT       
              MOVE '01'                   TO DD-COMPANY-NO              
              MOVE 'SYSTEM'               TO DD-LAST-UPDATE-USERID      
              MOVE WS-INPUT-DATE          TO DD-EFF-START-DT            
                                             DD-LAST-EVALUATED-DT       
                                                                        
              MOVE 'DA'                   TO DD-TIER-SOURCE-CD          
              MOVE 0                      TO DD-ADJ-TIER-SEQ-NO         
                                                                        
              PERFORM 8100-INSERT-CIS-DATA  THRU 8100-EXIT              
              DISPLAY 'ACCOUNT INSERTED : ' DD-ACCOUNT-NO               
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 PERFORM 6620-INSERT-TRANS-HIST-ROW                     
                                          THRU 6620-EXIT                
              END-IF                                                    
                                                                        
P805AP        IF DD-TIER-ACCT-TYPE-CD = 'S'                             
P805AP           MOVE 'ADVANCED PRICE'    TO YP-ATTRIBUTE-DESC          
P805AP           MOVE AT-ACCOUNT-NO       TO YP-ACCOUNT-NO              
P805AP           PERFORM 7790-GET-ACCOUNT-ATTRIBUTE  THRU 7790-EXIT     
P805AP           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
P805AP              MOVE 'I'              TO YP-STATUS-CD               
P805AP              MOVE 'NO'             TO YP-ATTRIBUTE-VALUE-CD      
P805AP              PERFORM 8906-UPDATE-ACCOUNT-ATTRIBUTE THRU 8906-EXIT
P805AP             PERFORM 8907-ADV-PRICE-TRAN-DET-EXPIRE THRU 8907-EXIT
P805AP           END-IF                                                 
P805AP        END-IF                                                    
C34569        IF WS-INSERT-REC-CNTR >= WS-CHKP-LUW-LIMIT OR             
C34569           WS-INSERT-REC-CNTR >= WS-CHKP-UPD-LIMIT                
C34569           MOVE 0                   TO WS-INSERT-REC-CNTR         
C34569           PERFORM 8889-COMMIT              THRU 8889-EXIT        
C34569        END-IF                                                    
                                                                        
P00453     END-IF.                                                      
                                                                        
           PERFORM 7760-FETCH-DREG-PROSPECT-CUR                         
                                               THRU 7760-EXIT           
           .                                                            
       2025-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00677******************************************************************        
P00677** TIER ADJUSTMENT AT INITIAL BILL (100->90/500->490)           **        
P00677******************************************************************        
P00677*                                                                         
P00677 2110-ADJTIER-INITIAL-BILL.                                       
P00677*                                                                         
P00677     IF WS-TIER-CUST-STAT-CD(WS-SUB-1B)    = DD-TIER-CUST-STAT-CD 
P00677      AND WS-TIER-ACCT-TYPE-CD(WS-SUB-1B)  = DD-TIER-ACCT-TYPE-CD 
P00677      AND WS-MKT-TIER-RANKING(WS-SUB-1B)   = DD-MKT-TIER-RANKING  
P00677      AND WS-MKT-TIER-START-DT(WS-SUB-1B)  = DD-MKT-TIER-START-DT 
P00677      AND WS-AGL-LOW-INCM-SR-FL(WS-SUB-1B) = LR-SENIOR-FL         
P00677      AND ((WS-DHR-QUALIFIED-FL(WS-SUB-1B) = CU-DHR-FL)           
P00677                               OR                                 
P00677           (WS-DHR-QUALIFIED-FL(WS-SUB-1B) = 'X')     )           
P00677      AND WS-ADJ-SOURCE-CD(WS-SUB-1B)      = 'S'                  
P00677      AND WS-EVAL-MONTHS-QTY(WS-SUB-1B)    =  0                   
P00677      AND WS-MISSED-PYMT-QTY(WS-SUB-1B)    =  0                   
P00677      AND WS-MIN-GOOD-PAY-QTY(WS-SUB-1B)   =  0                   
P00677        MOVE 'N'                       TO WS-AGL-DISCOUNT         
P00677        PERFORM 7160-CHECK-SENIOR-ATTR  THRU  7160-EXIT           
P00677        IF ON-PENDING-STATUS                                      
P00677           PERFORM 8200-UPDATE-AGL-STATUS  THRU  8200-EXIT        
P00677        END-IF                                                    
P00677        PERFORM 2201-PROCESS-ADJ  THRU  2201-EXIT                 
P00677        SET TIER-ADJ-COMPLETED      TO  TRUE                      
P00677     END-IF.                                                      
P00677*                                                                         
P00677 2110-EXIT.                                                       
P00677     EXIT.                                                        
P00677*                                                                         
P00677******************************************************************        
P00677** TIER ADJUSTMENT BASED ON BAD PAYMENTS (300->500/290->490)    **        
P00677******************************************************************        
P00677*                                                                         
P00677 2120-ADJTIER-BAD-PAYMENTS.                                       
P00677*                                                                         
P00677     IF WS-TIER-CUST-STAT-CD(WS-SUB-1B)    = DD-TIER-CUST-STAT-CD 
P00677      AND WS-TIER-ACCT-TYPE-CD(WS-SUB-1B)  = DD-TIER-ACCT-TYPE-CD 
P00677      AND WS-MKT-TIER-RANKING(WS-SUB-1B)   = DD-MKT-TIER-RANKING  
P00677      AND WS-MKT-TIER-START-DT(WS-SUB-1B)  = DD-MKT-TIER-START-DT 
P00677      AND WS-AGL-LOW-INCM-SR-FL(WS-SUB-1B) = 'X'                  
P00677      AND WS-DHR-QUALIFIED-FL(WS-SUB-1B)   = 'X'                  
P00677      AND WS-ADJ-SOURCE-CD(WS-SUB-1B)  NOT = 'S'                  
P00677      AND WS-EVAL-MONTHS-QTY(WS-SUB-1B)    >  0                   
P00677      AND WS-MISSED-PYMT-QTY(WS-SUB-1B)    >  0                   
P00677      AND WS-MIN-GOOD-PAY-QTY(WS-SUB-1B)   =  0                   
P00677        MOVE ZEROES                    TO WS-NBR-GOOD-PAYMENT     
P00677                                          WS-NBR-MISSED-PAYMENT   
P00677        MOVE WS-EVAL-MONTHS-QTY(WS-SUB-1B)                        
P00677                                       TO WS-HIST-EVAL-MONTHS     
P00677        PERFORM 5300-CHECK-CUST-CREDIT-HST  THRU  5300-EXIT       
P00677        IF WS-NBR-MISSED-PAYMENT >= WS-MISSED-PYMT-QTY(WS-SUB-1B) 
P00677           PERFORM 2201-PROCESS-ADJ  THRU  2201-EXIT              
P00677           SET TIER-ADJ-COMPLETED      TO  TRUE                   
P00677        END-IF                                                    
P00677     END-IF.                                                      
P00677*                                                                         
P00677 2120-EXIT.                                                       
P00677     EXIT.                                                        
P00677*                                                                         
P00677******************************************************************        
P00677** TIER ADJUSTMENT BASED ON GOOD PAYMENTS, DHR_FL & SENIOR_FL   **        
P00677** 300->100/500->100/500->300/290-> 90/490-> 90/490->290        **        
P00677******************************************************************        
P00677*                                                                         
P00677 2130-ADJTIER-GOODPYMT-FLAGS.                                     
P00677*                                                                         
P00677     IF WS-TIER-CUST-STAT-CD(WS-SUB-1B)    = DD-TIER-CUST-STAT-CD 
P00677      AND WS-TIER-ACCT-TYPE-CD(WS-SUB-1B)  = DD-TIER-ACCT-TYPE-CD 
P00677      AND WS-MKT-TIER-RANKING(WS-SUB-1B)   = DD-MKT-TIER-RANKING  
P00677      AND WS-MKT-TIER-START-DT(WS-SUB-1B)  = DD-MKT-TIER-START-DT 
P00677      AND ((WS-AGL-LOW-INCM-SR-FL(WS-SUB-1B) = LR-SENIOR-FL)      
P00677                                    OR                            
P00677           (WS-AGL-LOW-INCM-SR-FL(WS-SUB-1B) = 'X'))              
P00677      AND WS-DHR-QUALIFIED-FL(WS-SUB-1B)   = CU-DHR-FL            
P00677      AND WS-ADJ-SOURCE-CD(WS-SUB-1B)  NOT = 'S'                  
P00677      AND WS-EVAL-MONTHS-QTY(WS-SUB-1B)    >  0                   
P00677      AND WS-MISSED-PYMT-QTY(WS-SUB-1B)    =  0                   
P00677      AND WS-MIN-GOOD-PAY-QTY(WS-SUB-1B)   >  0                   
P00677        MOVE ZEROES                    TO WS-NBR-GOOD-PAYMENT     
P00677                                          WS-NBR-MISSED-PAYMENT   
P00677        MOVE WS-EVAL-MONTHS-QTY(WS-SUB-1B)                        
P00677                                       TO WS-HIST-EVAL-MONTHS     
P00677        PERFORM 5300-CHECK-CUST-CREDIT-HST  THRU  5300-EXIT       
P00677        IF (FIXED-RATE-CUSTOMER    AND                            
P00677            WS-NBR-GOOD-PAYMENT    >=                             
P00677            WS-MIN-GOOD-PAY-QTY(WS-SUB-1B) - 1)                   
P00677                    OR                                            
P00677           (VARIABLE-RATE-CUSTOMER AND                            
P00677            WS-NBR-GOOD-PAYMENT    >=                             
P00677            WS-MIN-GOOD-PAY-QTY(WS-SUB-1B))                       
P00677           PERFORM 2201-PROCESS-ADJ  THRU  2201-EXIT              
P00677           SET TIER-ADJ-COMPLETED      TO  TRUE                   
P00677        END-IF                                                    
P00677     END-IF.                                                      
P00677*                                                                         
P00677 2130-EXIT.                                                       
P00677     EXIT.                                                        
P00677*                                                                         
P00677******************************************************************        
P00677** TIER ADJUSTMENT BASED ON GOOD PAYMENTS & DHR SENIOR CHECKS   **        
P00677** 290->90/490->90                                              **        
P00677******************************************************************        
P00677*                                                                         
P00677 2140-ADJTIER-GOODPYMT-DHR-SR.                                    
P00677*                                                                         
P00677     IF WS-TIER-CUST-STAT-CD(WS-SUB-1B)    = DD-TIER-CUST-STAT-CD 
P00677      AND WS-TIER-ACCT-TYPE-CD(WS-SUB-1B)  = DD-TIER-ACCT-TYPE-CD 
P00677      AND WS-MKT-TIER-RANKING(WS-SUB-1B)   = DD-MKT-TIER-RANKING  
P00677      AND WS-MKT-TIER-START-DT(WS-SUB-1B)  = DD-MKT-TIER-START-DT 
P00677      AND WS-AGL-LOW-INCM-SR-FL(WS-SUB-1B) = 'S'                  
P00677      AND WS-DHR-QUALIFIED-FL(WS-SUB-1B)   = CU-DHR-FL            
P00677      AND WS-ADJ-SOURCE-CD(WS-SUB-1B)  NOT = 'S'                  
P00677      AND WS-EVAL-MONTHS-QTY(WS-SUB-1B)    >  0                   
P00677      AND WS-MISSED-PYMT-QTY(WS-SUB-1B)    =  0                   
P00677      AND WS-MIN-GOOD-PAY-QTY(WS-SUB-1B)   >  0                   
P00677        MOVE ZEROES                    TO WS-NBR-GOOD-PAYMENT     
P00677                                          WS-NBR-MISSED-PAYMENT   
P00677        MOVE WS-EVAL-MONTHS-QTY(WS-SUB-1B)                        
P00677                                       TO WS-HIST-EVAL-MONTHS     
P00677        PERFORM 5300-CHECK-CUST-CREDIT-HST  THRU  5300-EXIT       
P00677        IF (FIXED-RATE-CUSTOMER    AND                            
P00677            WS-NBR-GOOD-PAYMENT    >=                             
P00677            WS-MIN-GOOD-PAY-QTY(WS-SUB-1B) - 1)                   
P00677                    OR                                            
P00677           (VARIABLE-RATE-CUSTOMER AND                            
P00677            WS-NBR-GOOD-PAYMENT    >=                             
P00677            WS-MIN-GOOD-PAY-QTY(WS-SUB-1B))                       
P00677           PERFORM 2160-CHK-DHR-SENIOR-AGE  THRU  2160-EXIT       
P00677           IF WS-RESULT-YEAR >= WS-SCANA-SR-DELINQ-VAL            
P00677              PERFORM 2201-PROCESS-ADJ  THRU  2201-EXIT           
P00677              SET TIER-ADJ-COMPLETED      TO  TRUE                
P00677           END-IF                                                 
P00677        END-IF                                                    
P00677     END-IF.                                                      
P00677*                                                                         
P00677 2140-EXIT.                                                       
P00677     EXIT.                                                        
P00677*                                                                         
P00677******************************************************************        
P00677** TIER ADJUSTMENT BASED ON DHR SENIOR CHECKS (EXISTING CUST)   **        
P00677** 100 -> 90, 300 -> 290 & 500-> 490                            **        
P00677******************************************************************        
P00677*                                                                         
P00677 2150-ADJTIER-DHR-SENIOR-ONLY.                                    
P00677*                                                                         
P00677     IF WS-TIER-CUST-STAT-CD(WS-SUB-1B)    = DD-TIER-CUST-STAT-CD 
P00677      AND WS-TIER-ACCT-TYPE-CD(WS-SUB-1B)  = DD-TIER-ACCT-TYPE-CD 
P00677      AND WS-MKT-TIER-RANKING(WS-SUB-1B)   = DD-MKT-TIER-RANKING  
P00677      AND WS-MKT-TIER-START-DT(WS-SUB-1B)  = DD-MKT-TIER-START-DT 
P00677      AND WS-AGL-LOW-INCM-SR-FL(WS-SUB-1B) = 'S'                  
P00677      AND WS-DHR-QUALIFIED-FL(WS-SUB-1B)   = CU-DHR-FL            
P00677      AND WS-ADJ-SOURCE-CD(WS-SUB-1B)  NOT = 'S'                  
P00677      AND WS-EVAL-MONTHS-QTY(WS-SUB-1B)    =  0                   
P00677      AND WS-MISSED-PYMT-QTY(WS-SUB-1B)    =  0                   
P00677      AND WS-MIN-GOOD-PAY-QTY(WS-SUB-1B)   =  0                   
P00677      AND WS-APPLICATION-CD(WS-SUB-1B)     = 'SS'                 
P00677        PERFORM 2160-CHK-DHR-SENIOR-AGE  THRU  2160-EXIT          
P00677        IF WS-RESULT-YEAR >= WS-SCANA-SR-DELINQ-VAL               
P00677           PERFORM 2201-PROCESS-ADJ  THRU  2201-EXIT              
P00677           SET TIER-ADJ-COMPLETED      TO  TRUE                   
P00677        END-IF                                                    
P00677     END-IF.                                                      
P00677*                                                                         
P00677 2150-EXIT.                                                       
P00677     EXIT.                                                        
P00677*                                                                         
P00677******************************************************************        
P00677** CHECK FOR DHR SENIOR AGE AND DOB VERIFIED CD                 **        
P00677******************************************************************        
P00677*                                                                         
P00677 2160-CHK-DHR-SENIOR-AGE.                                         
P00677*                                                                         
P00677     INITIALIZE                           WS-RESULT-YEAR          
P00677                                          CE-DOB-VERIFIED-CD      
P00677                                          CE-DATE-OF-BIRTH.       
P00677     MOVE AT-CUSTOMER-NO               TO CE-CUSTOMER-NO.         
P00677     MOVE 'C'                          TO CE-CUSTOMER-TYPE.       
P00677     PERFORM 7080-SELECT-CUST-STATS  THRU  7080-EXIT.             
P00677*                                                                         
P00677     EVALUATE TRUE                                                
P00677       WHEN (FIXED-RATE-CUSTOMER                                  
P00677             AND FF-DURATION-REMAIN-NO = WS-SCANA-SR-60-DAY-VAL)  
P00677             IF AT-REV-MTH-LST-NRML > 0                           
P00677                MOVE AT-REV-MTH-LST-NRML TO WS-INPUT-REV-MONTH    
P00677                MOVE +03                 TO WS-MONTHS-TO-ADD      
P00677                PERFORM 0410-ADD-REVENUE-MONTHS  THRU 0410-EXIT   
P00677                MOVE BN-DATE-EXTRACT     TO WS-EXPECTED-DATE      
P00677             ELSE                                                 
P00677                MOVE WS-REV-CLOSE-OUT-60 TO WS-EXPECTED-DATE      
P00677             END-IF                                               
P00677       WHEN (FIXED-RATE-CUSTOMER                                  
P00677             AND FF-DURATION-REMAIN-NO = WS-SCANA-SR-30-DAY-VAL)  
P00677             IF AT-REV-MTH-LST-NRML > 0                           
P00677                MOVE AT-REV-MTH-LST-NRML TO WS-INPUT-REV-MONTH    
P00677                MOVE +02                 TO WS-MONTHS-TO-ADD      
P00677                PERFORM 0410-ADD-REVENUE-MONTHS  THRU 0410-EXIT   
P00677                MOVE BN-DATE-EXTRACT     TO WS-EXPECTED-DATE      
P00677             ELSE                                                 
P00677                MOVE WS-REV-CLOSE-OUT-30 TO WS-EXPECTED-DATE      
P00677             END-IF                                               
P00677       WHEN (FIXED-RATE-CUSTOMER                                  
P00677             AND FF-DURATION-REMAIN-NO = WS-SCANA-SR-RENEWAL-DAY) 
P00677             IF AT-REV-MTH-LST-NRML > 0                           
P00677                MOVE AT-REV-MTH-LST-NRML TO WS-INPUT-REV-MONTH    
P00677                MOVE +01                 TO WS-MONTHS-TO-ADD      
P00677                PERFORM 0410-ADD-REVENUE-MONTHS  THRU 0410-EXIT   
P00677                MOVE BN-DATE-EXTRACT     TO WS-EXPECTED-DATE      
P00677             ELSE                                                 
P00677                MOVE WS-REV-CLOSE-OUT-00 TO WS-EXPECTED-DATE      
P00677             END-IF                                               
P00677       WHEN OTHER                                                 
P00677             MOVE WS-INPUT-DATE          TO WS-EXPECTED-DATE      
P00677     END-EVALUATE.                                                
P00677*                                                                         
P00677     IF CE-DOB-VERIFIED-CD   NOT EQUAL SPACES                     
P00677        AND CE-DATE-OF-BIRTH NOT EQUAL SPACES                     
P00677        MOVE WS-EXPECTED-DATE          TO WS-DUMMY-DATE-ST        
P00677        MOVE CE-DATE-OF-BIRTH          TO WS-DUMMY-DATE-END       
P00677        PERFORM 7090-CALCULATE-AGE  THRU  7090-EXIT               
P00677     END-IF.                                                      
P00677*                                                                         
P00677 2160-EXIT.                                                       
P00677     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 2201-PROCESS-ADJ.                                              *        
      ******************************************************************        
       2201-PROCESS-ADJ.                                                
                                                                        
P00172     IF WS-APPLICATION-CD (WS-SUB-1B) = 'BM'                      
P00172                                                                  
P00172        PERFORM 5350-CREATE-GROUP1-MOVE-WQ                        
P00172                                         THRU 5350-EXIT           
P00172        MOVE WS-HOLD-ACT-FRM-BILNG   TO AT-CODE-ACCT-BILLED       
P00172        PERFORM 8896-UPDATE-ACCOUNT-X    THRU 8896-EXIT           
           ELSE                                                         
P00172        PERFORM 2210-INSERT-MKT-TIER-ROW THRU 2210-EXIT           
           END-IF                                                       
                                                                        
           .                                                            
       2201-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 2210-INSERT-MKT-TIER-ROW.                                      *        
      ******************************************************************        
       2210-INSERT-MKT-TIER-ROW.                                        
                                                                        
           IF (WS-MKT-TIER-RANKING (WS-SUB-1B) NOT EQUAL                
                      WS-ADJ-TIER-RANKING (WS-SUB-1B) )                 
                                                                        
              MOVE AT-ACCOUNT-NO            TO DD-ACCOUNT-NO            
              MOVE WS-TIER-CUST-STAT-CD (WS-SUB-1B)                     
                                            TO DD-TIER-CUST-STAT-CD     
              MOVE WS-ADJ-TIER-ACCT-TYPE (WS-SUB-1B)                    
                                            TO DD-TIER-ACCT-TYPE-CD     
              MOVE WS-ADJ-TIER-RANKING (WS-SUB-1B)                      
                                            TO DD-MKT-TIER-RANKING      
              MOVE WS-ADJ-TIER-START-DT (WS-SUB-1B)                     
                                            TO DD-MKT-TIER-START-DT     
              MOVE '01'                     TO DD-COMPANY-NO            
              MOVE 'SYSTEM'                 TO DD-LAST-UPDATE-USERID    
              MOVE WS-INPUT-DATE            TO DD-EFF-START-DT          
                                               DD-LAST-EVALUATED-DT     
              IF FIXED-RATE-CUSTOMER                                    
I00113          IF WS-APPLICATION-CD (WS-SUB-1B) = 'SA' OR 'SS'         
I00113             IF WS-APPLICATION-CD (WS-SUB-1B) = 'SA'              
I00113                MOVE '1S'             TO DD-TIER-SOURCE-CD        
I00113             ELSE                                                 
I00113                MOVE '1A'             TO DD-TIER-SOURCE-CD        
I00113             END-IF                                               
                ELSE                                                    
                   IF DD-TIER-ACCT-TYPE-CD = '1'                        
                      MOVE '1F'             TO DD-TIER-SOURCE-CD        
                   ELSE                                                 
                      MOVE '2F'             TO DD-TIER-SOURCE-CD        
                   END-IF                                               
                END-IF                                                  
              ELSE                                                      
I00113          IF WS-APPLICATION-CD (WS-SUB-1B) = 'SA' OR 'SS'         
I00113             IF WS-APPLICATION-CD (WS-SUB-1B) = 'SA'              
I00113                MOVE '1S'             TO DD-TIER-SOURCE-CD        
I00113             ELSE                                                 
I00113                MOVE '1A'             TO DD-TIER-SOURCE-CD        
I00113             END-IF                                               
                ELSE                                                    
                   IF DD-TIER-ACCT-TYPE-CD = '1'                        
                      MOVE '1V'             TO DD-TIER-SOURCE-CD        
                   ELSE                                                 
                      MOVE '2V'             TO DD-TIER-SOURCE-CD        
                   END-IF                                               
                END-IF                                                  
              END-IF                                                    
                                                                        
              MOVE WS-ADJ-TIER-SEQ-NO (WS-SUB-1B)                       
                                            TO DD-ADJ-TIER-SEQ-NO       
                                                                        
              PERFORM 8100-INSERT-CIS-DATA  THRU 8100-EXIT              
P00677        IF WS-ADJ-SOURCE-CD(WS-SUB-1B) = 'S'                      
P00677           DISPLAY 'ADJ TIER-INITIAL BILL-ACCT:' DD-ACCOUNT-NO    
P00677                   ' OLD TIER:' WS-MKT-TIER-RANKING(WS-SUB-1B)    
P00677                   ' NEW TIER:' DD-MKT-TIER-RANKING               
P00677        ELSE                                                      
P00677           IF FIXED-RATE-CUSTOMER                                 
P00677              DISPLAY 'ACCT:'      DD-ACCOUNT-NO                  
P00677                      ' OLD TIER:' WS-MKT-TIER-RANKING(WS-SUB-1B) 
P00677                      ' NEW TIER:' DD-MKT-TIER-RANKING            
P00677                      ' OPT TYPE:' FI-OPT-CALC-TYPE-CD            
P00677                      ' DURATION:' FF-DURATION-REMAIN-NO          
P00677           ELSE                                                   
P00677              DISPLAY 'ACCT:'      DD-ACCOUNT-NO                  
P00677                      ' OLD TIER:' WS-MKT-TIER-RANKING(WS-SUB-1B) 
P00677                      ' NEW TIER:' DD-MKT-TIER-RANKING            
P00677                      ' OPT TYPE:' FI-OPT-CALC-TYPE-CD            
P00677           END-IF                                                 
P00677        END-IF                                                    
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                                                                        
                 IF AT-REV-MTH-LST-NRML > 0                             
                    MOVE AT-REV-MTH-LST-NRML       TO WS-GROUP2-MOVE    
                    IF WS-GROUP2-MM = 12                                
                       MOVE 01             TO WS-GROUP2-MM              
                       COMPUTE WS-GROUP2-YYYY = WS-GROUP2-YYYY + 1      
                    ELSE                                                
                       COMPUTE WS-GROUP2-MM   = WS-GROUP2-MM + 1        
                    END-IF                                              
                    MOVE WS-GROUP2-YYYY    TO WS-GRP2-YYYY              
                    MOVE WS-GROUP2-MM      TO WS-GRP2-MM                
                    MOVE '01'              TO WS-GRP2-DD                
                 ELSE                                                   
                    MOVE '01'                      TO WS-GRP2-DD        
                    MOVE WS-REVENUE-MONTH-JP(1:4)  TO WS-GRP2-YYYY      
                    MOVE WS-REVENUE-MONTH-JP(5:2)  TO WS-GRP2-MM        
                 END-IF                                                 
                 MOVE WS-GRP2-MOVE-DATE    TO UT-GAS-BASE-LAST-UPDT     
                                                                        
P00677          IF DD-TIER-ACCT-TYPE-CD = REG-GRP1-CUST                 
I00113           PERFORM 6610-INSERT-TRANS-HIST-ROW THRU 6610-EXIT      
I00113          ELSE                                                    
                 PERFORM 8550-UPDATE-MOVE-DATE      THRU 8550-EXIT      
                 PERFORM 6610-INSERT-TRANS-HIST-ROW THRU 6610-EXIT      
I00113          END-IF                                                  
              END-IF                                                    
                                                                        
C34569        IF WS-INSERT-REC-CNTR >= WS-CHKP-LUW-LIMIT OR             
C34569           WS-INSERT-REC-CNTR >= WS-CHKP-UPD-LIMIT                
C34569           MOVE 0                     TO WS-INSERT-REC-CNTR       
C34569           PERFORM 8889-COMMIT        THRU 8889-EXIT              
C34569        END-IF                                                    
                                                                        
           END-IF                                                       
                                                                        
           .                                                            
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 32696857
      *                                                               * 32696957
      * 5300-CHECK-CUST-CREDIT-HST.                                   * 32697057
      ***************************************************************** 32697157
       5300-CHECK-CUST-CREDIT-HST.                                      
                                                                        
           MOVE AT-ACCOUNT-NO             TO CZ-ACCOUNT-NO              
                                             DF-ACCOUNT-NO              
           MOVE UT-IC-NO                  TO DF-IC-NO                   
                                                                        
           PERFORM 7350-SELECT-ARR-HIST        THRU 7350-EXIT           
                                                                        
           IF AT-REV-MTH-LST-NRML EQUAL ZEROES                          
              MOVE WS-REVENUE-MONTH-JP    TO WS-REV-YR-MM               
           ELSE                                                         
              MOVE AT-REV-MTH-LST-NRML    TO WS-REV-YR-MM               
           END-IF                                                       
                                                                        
           MOVE CZ-DISCONNECT-HIST        TO WS-UTL-CR-HST              
           MOVE CZ-DISC-EXCEPTN-HIST      TO WS-UTL-EXP-HST             
           MOVE CZ-ARREARS-HIST           TO WS-UTL-ARRS-HST            
           MOVE CZ-NON-UTL-CR-HST         TO WS-NON-UTL-CR-HST          
           MOVE CZ-NON-UTL-CR-HST-EX      TO WS-NON-UTL-EXP-HST         
           MOVE CZ-NON-UTL-ARRER-HIST     TO WS-NON-UTL-ARRS-HST        
           MOVE UT-GAS-BASE-LAST-UPDT     TO WS-GAS-BASE-LAST-UPDT      
           PERFORM 6896-CHECK-PAYMENT-HISTORY  THRU 6896-EXIT           
                                                                        
           .                                                            
       5300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14994000
      ***************************************************************** 32700157
      *                                                               * 32700257
      * 5350-CREATE-GROUP1-MOVE-WQ.                                   * 32700357
      ***************************************************************** 32700457
       5350-CREATE-GROUP1-MOVE-WQ.                                      
                                                                        
           PERFORM 7050-SELECT-TIMESTAMP THRU 7050-EXIT                 
           PERFORM 7270-SELECT-ACCT-INFO THRU 7270-EXIT                 
                                                                        
A04860     INITIALIZE CWS00077-FIELDS.                                  
A04860     MOVE ZERO                         TO WS-77-SERV-ORDER-NO.    
A04860     MOVE WS-CURRENT-TIMESTAMP         TO WS-77-DATE-REQUIRED     
A04860                                          WS-77-DATE-CREATED.     
A04860     MOVE 440                          TO WS-77-CATEGORY-ID.      
A04860     MOVE SPACES                       TO WS-77-COMMENTS-TEXT.    
P00677*                                                                         
P00677     EVALUATE TRUE                                                
P00677       WHEN (DD-TIER-ACCT-TYPE-CD = REG-GRP2-CUST                 
P00677             AND WS-MISSED-PYMT-QTY(WS-SUB-1B)  = 0               
P00677             AND WS-MIN-GOOD-PAY-QTY(WS-SUB-1B) > 0)              
P00677             STRING WS-GROUP2-DHR-WQ         DELIMITED BY '  '    
P00677                    'NO. OF GOOD PAYMENTS: ' DELIMITED BY SIZE    
P00677                    WS-NBR-GOOD-PAYMENT      DELIMITED BY SIZE    
A04860               INTO WS-77-COMMENTS-TEXT                           
P00677             END-STRING                                           
P00677       WHEN OTHER                                                 
A04860            MOVE WS-GROUP2-DHR-WQ      TO WS-77-COMMENTS-TEXT     
P00677     END-EVALUATE.                                                
P00677*                                                                         
A04860     MOVE LENGTH OF WS-77-COMMENTS-TEXT TO WS-77-COMMENTS-LEN.    
A04860     MOVE AT-ACCOUNT-NO                TO WS-77-ACCOUNT-NO.       
A04860     MOVE AT-PREMISE-NO                TO WS-77-PREMISE-NO.       
A04860     MOVE AT-CUSTOMER-NO               TO WS-77-CUSTOMER-NO.      
A04860     MOVE 'SYSTEM'                     TO WS-77-USER-ID-ORIG.     
A04860     MOVE SPACES                       TO WS-77-RESP-AREA-ID.     
A04860     MOVE AT-LOCAL-OFFICE              TO WS-77-LOCAL-OFFICE.     
A04860     MOVE '4'                          TO WS-77-ROUTE-CATEGORY.   
A04860     MOVE 'N'                          TO WS-77-PRIORITY.         
A04860     MOVE ZERO                         TO WS-77-FREE-FORM-LEN.    
A04860     MOVE LOW-VALUES                   TO WS-77-FREE-FORM-TXT.    
A04860     MOVE PROGRAM-NAME                 TO WS-77-CREATED-BY.       
                                                                        
A04860     PERFORM 8905-INSERT-WQ               THRU 8905-EXIT.         
P00677     IF FIXED-RATE-CUSTOMER                                       
P00677        DISPLAY 'TIER ADJ WQ-ACCT:' DD-ACCOUNT-NO                 
P00677                ' OLD TIER:' WS-MKT-TIER-RANKING(WS-SUB-1B)       
P00677                ' NEW TIER:' WS-ADJ-TIER-RANKING(WS-SUB-1B)       
P00677*****           ' OPT TYPE:' FI-OPT-CALC-TYPE-CD                          
P00677                ' DURATION:' FF-DURATION-REMAIN-NO                
P00677     ELSE                                                         
P00677        DISPLAY 'TIER ADJ WQ-ACCT:' DD-ACCOUNT-NO                 
P00677                ' OLD TIER:' WS-MKT-TIER-RANKING(WS-SUB-1B)       
P00677                ' NEW TIER:' WS-ADJ-TIER-RANKING(WS-SUB-1B)       
P00677                ' OPT TYPE:' FI-OPT-CALC-TYPE-CD                  
P00677     END-IF.                                                      
                                                                        
       5350-EXIT.                                                       
           EXIT.                                                        
      *                                                                 32705457
      ******************************************************************        
      *                                                                *        
      * 6610-INSERT-TRANS-HIST-ROW.                                    *        
      ******************************************************************        
       6610-INSERT-TRANS-HIST-ROW.                                      
                                                                        
           PERFORM 7050-SELECT-TIMESTAMP THRU 7050-EXIT                 
                                                                        
C34569     MOVE SPACES                    TO WS-TANS-COMM-TMP           
                                                                        
           EVALUATE WS-ADJ-SOURCE-CD (WS-SUB-1B)                        
                                                                        
             WHEN 'L'                                                   
             WHEN 'M'                                                   
C34569         MOVE WS-DROP-L-COMMENTS    TO WS-TANS-COMM-TMP           
             WHEN 'H'                                                   
C34569         MOVE WS-DROP-H-COMMENTS    TO WS-TANS-COMM-TMP           
             WHEN 'S'                                                   
C34569         MOVE 'INITIAL BILL RATE CHANGE' TO WS-TANS-COMM-TMP      
I00113       WHEN 'A'                                                   
P00677         IF DD-TIER-ACCT-TYPE-CD = REG-GRP1-CUST                  
P00677            MOVE 'GROUP 1 SCANA SR ADJUSTMENT' TO WS-TANS-COMM-TMP
P00677         ELSE                                                     
P00677            MOVE 'GROUP 2 SCANA SR ADJUSTMENT' TO WS-TANS-COMM-TMP
P00677         END-IF                                                   
           END-EVALUATE                                                 
                                                                        
P00677*                                                                         
P00677     EVALUATE TRUE                                                
P00677       WHEN (WS-MISSED-PYMT-QTY(WS-SUB-1B)      > 0               
P00677             AND WS-MIN-GOOD-PAY-QTY(WS-SUB-1B) > 0)              
P00677             STRING WS-TANS-COMM-TMP           DELIMITED BY '  '  
P00677                    'NO. OF MISSED PAYMENTS: ' DELIMITED BY SIZE  
P00677                    WS-NBR-MISSED-PAYMENT      DELIMITED BY SIZE  
P00677                    ' NO. OF GOOD PAYMENTS: '  DELIMITED BY SIZE  
P00677                    WS-NBR-GOOD-PAYMENT        DELIMITED BY SIZE  
P00677               INTO MH-TRAN-COMMENT-TEXT                          
P00677             END-STRING                                           
P00677       WHEN (WS-MISSED-PYMT-QTY(WS-SUB-1B)      > 0               
P00677             AND WS-MIN-GOOD-PAY-QTY(WS-SUB-1B) = 0)              
P00677             STRING WS-TANS-COMM-TMP           DELIMITED BY '  '  
P00677                    'NO. OF MISSED PAYMENTS: ' DELIMITED BY SIZE  
P00677                    WS-NBR-MISSED-PAYMENT      DELIMITED BY SIZE  
P00677               INTO MH-TRAN-COMMENT-TEXT                          
P00677       WHEN (WS-MISSED-PYMT-QTY(WS-SUB-1B)      = 0               
P00677             AND WS-MIN-GOOD-PAY-QTY(WS-SUB-1B) > 0)              
P00677             STRING WS-TANS-COMM-TMP         DELIMITED BY '  '    
P00677                    'NO. OF GOOD PAYMENTS: ' DELIMITED BY SIZE    
P00677                    WS-NBR-GOOD-PAYMENT      DELIMITED BY SIZE    
P00677               INTO MH-TRAN-COMMENT-TEXT                          
P00677             END-STRING                                           
P00677       WHEN OTHER                                                 
P00677            MOVE WS-TANS-COMM-TMP      TO MH-TRAN-COMMENT-TEXT    
P00677     END-EVALUATE                                                 
P00677*                                                                         
C34569     MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                          
C34569                                    TO MH-TRAN-COMMENT-LEN        
      ** DATA FOR CSS_MNT_TRANS_HIST                                    17730000
           MOVE WS-CURRENT-TIMESTAMP      TO MH-TRANS-HIST-SEQ-NO       
           MOVE WS-CURRENT-DATE           TO MH-DATE-TRANS              
           MOVE 'F'                       TO MH-CODE-TRAN-TYPE          
           MOVE SPACES                    TO MH-RESP-AREA-ID            
           MOVE AT-ACCOUNT-NO             TO MH-ACCOUNT-NO              
           MOVE +0                        TO MH-CUSTOMER-NO             
           MOVE +0                        TO MH-PREMISE-NO              
           MOVE 'SYSTEM'                  TO MH-USER-ID                 
           MOVE 'PCSCA280'                TO MH-APPL-PROGRAM-ID         
           MOVE +0                        TO MH-ENTITY-KEY-DESC-LEN     
           MOVE SPACES                    TO MH-ENTITY-KEY-DESC-TEXT    
                                                                        
      ** DATA FOR CSS_MT_TRN_HST_DET                                    17564000
           MOVE DD-TIER-CUST-STAT-CD      TO IG-TIER-CUST-STAT-CD       
           MOVE DD-TIER-ACCT-TYPE-CD      TO IG-TIER-ACCT-TYPE-CD       
           MOVE WS-MKT-TIER-RANKING (WS-SUB-1B)                         
                                          TO IG-MKT-TIER-RANKING        
           MOVE '01'                      TO IG-COMPANY-NO              
           MOVE WS-MKT-TIER-START-DT (WS-SUB-1B)                        
                                          TO IG-MKT-TIER-START-DT       
                                                                        
           PERFORM 7310-SEL-MKT-TIER-DESC   THRU 7310-EXIT              
                                                                        
           MOVE WS-CURRENT-TIMESTAMP      TO MI-TRANS-HIST-SEQ-NO       
           MOVE 1                         TO MI-TRAN-APPL-NO            
           MOVE 'TIER RANKING'            TO MI-COLUMN-DESC             
           MOVE SPACES                    TO MI-TABLE-ID                
           MOVE IG-MKT-TIER-DESC          TO MI-PRV-COLUMN-VALUE-TEXT   
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                          TO MI-PRV-COLUMN-VALUE-LEN    
                                                                        
           MOVE DD-TIER-ACCT-TYPE-CD      TO IG-TIER-ACCT-TYPE-CD       
           MOVE DD-MKT-TIER-RANKING       TO IG-MKT-TIER-RANKING        
P00677     MOVE DD-MKT-TIER-START-DT      TO IG-MKT-TIER-START-DT       
                                                                        
           PERFORM 7310-SEL-MKT-TIER-DESC   THRU 7310-EXIT              
                                                                        
           MOVE IG-MKT-TIER-DESC          TO MI-CHG-COLUMN-VALUE-TEXT   
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                          TO MI-CHG-COLUMN-VALUE-LEN    
                                                                        
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT              
      *                                                                 17600000
           MOVE DD-TIER-CUST-STAT-CD      TO UV-CODE-VALUE-TEXT         
           MOVE LENGTH OF UV-CODE-VALUE-TEXT                            
                                          TO UV-CODE-VALUE-LEN          
           MOVE 'TIER_CUST_STAT_CD'       TO UV-COLUMN-NA-TEXT          
           MOVE LENGTH OF UV-COLUMN-NA-TEXT                             
                                          TO UV-COLUMN-NA-LEN           
           MOVE 'CRM_MKT_TIER'            TO UV-TABLE-NA-TEXT           
           MOVE LENGTH OF UV-TABLE-NA-TEXT                              
                                          TO UV-TABLE-NA-LEN            
           MOVE 'ALL'                     TO UV-PROGRAM-ID              
           MOVE '01'                      TO UV-COMPANY-NO              
           PERFORM 7320-SEL-CODE-VALUE-DESC THRU 7320-EXIT              
                                                                        
           MOVE WS-CURRENT-TIMESTAMP      TO MI-TRANS-HIST-SEQ-NO       
           MOVE 2                         TO MI-TRAN-APPL-NO            
           MOVE 'TIER CUST STAT CD'       TO MI-COLUMN-DESC             
           MOVE SPACES                    TO MI-TABLE-ID                
           MOVE +14                       TO MI-PRV-COLUMN-VALUE-LEN    
           MOVE '** INSERTED **'          TO MI-PRV-COLUMN-VALUE-TEXT   
           MOVE UV-CODE-SHORT-DESC-TEXT   TO MI-CHG-COLUMN-VALUE-TEXT   
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                          TO MI-CHG-COLUMN-VALUE-LEN    
                                                                        
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT              
      *                                                                 17600000
           MOVE DD-TIER-ACCT-TYPE-CD      TO TT-TIER-ACCT-TYPE-CD       
           PERFORM 7330-SEL-TIER-ACCT-TYPE-CD THRU 7330-EXIT            
                                                                        
           MOVE WS-CURRENT-TIMESTAMP      TO MI-TRANS-HIST-SEQ-NO       
           MOVE 3                         TO MI-TRAN-APPL-NO            
           MOVE 'TIER ACCT TYPE CD'       TO MI-COLUMN-DESC             
           MOVE SPACES                    TO MI-TABLE-ID                
           MOVE +14                       TO MI-PRV-COLUMN-VALUE-LEN    
           MOVE '** INSERTED **'          TO MI-PRV-COLUMN-VALUE-TEXT   
           MOVE TT-TIER-ACCT-DESC         TO MI-CHG-COLUMN-VALUE-TEXT   
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                          TO MI-CHG-COLUMN-VALUE-LEN    
                                                                        
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT              
      *                                                                 17600000
           MOVE WS-CURRENT-TIMESTAMP      TO MI-TRANS-HIST-SEQ-NO       
           MOVE 4                         TO MI-TRAN-APPL-NO            
           MOVE 'MKT TIER START DT'       TO MI-COLUMN-DESC             
           MOVE SPACES                    TO MI-TABLE-ID                
           MOVE +14                       TO MI-PRV-COLUMN-VALUE-LEN    
           MOVE '** INSERTED **'          TO MI-PRV-COLUMN-VALUE-TEXT   
           MOVE +10                       TO MI-CHG-COLUMN-VALUE-LEN    
           MOVE DD-MKT-TIER-START-DT      TO MI-CHG-COLUMN-VALUE-TEXT   
                                                                        
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT              
      *                                                                 17600000
           .                                                            
       6610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 6620-INSERT-TRANS-HIST-ROW.                                    *        
      ******************************************************************        
       6620-INSERT-TRANS-HIST-ROW.                                      
                                                                        
           PERFORM 7050-SELECT-TIMESTAMP THRU 7050-EXIT                 
           MOVE 'MOVED DREG PROSPECTIVE TO EXIST WITH DEFAULT TIER'     
                                           TO WS-EXEMPT-COMMENT         
      ** DATA FOR CSS_MNT_TRANS_HIST                                    17730000
           MOVE WS-CURRENT-TIMESTAMP      TO MH-TRANS-HIST-SEQ-NO       
           MOVE WS-CURRENT-DATE           TO MH-DATE-TRANS              
           MOVE 'F'                       TO MH-CODE-TRAN-TYPE          
           MOVE SPACES                    TO MH-RESP-AREA-ID            
           MOVE AT-ACCOUNT-NO             TO MH-ACCOUNT-NO              
           MOVE +0                        TO MH-CUSTOMER-NO             
           MOVE +0                        TO MH-PREMISE-NO              
           MOVE 'SYSTEM'                  TO MH-USER-ID                 
           MOVE +49                       TO MH-TRAN-COMMENT-LEN        
           MOVE WS-EXEMPT-COMMENT         TO MH-TRAN-COMMENT-TEXT       
           MOVE 'PCSCA280'                TO MH-APPL-PROGRAM-ID         
           MOVE +0                        TO MH-ENTITY-KEY-DESC-LEN     
           MOVE SPACES                    TO MH-ENTITY-KEY-DESC-TEXT    
                                                                        
      ** DATA FOR CSS_MT_TRN_HST_DET                                    17564000
           MOVE 'P'                       TO IG-TIER-CUST-STAT-CD       
           MOVE DD-TIER-ACCT-TYPE-CD      TO IG-TIER-ACCT-TYPE-CD       
           MOVE WS-PREV-MKT-TIER-RANKING  TO IG-MKT-TIER-RANKING        
           MOVE '01'                      TO IG-COMPANY-NO              
           MOVE WS-PREV-MKT-TIER-START-DT TO IG-MKT-TIER-START-DT       
                                                                        
           PERFORM 7310-SEL-MKT-TIER-DESC   THRU 7310-EXIT              
                                                                        
           MOVE WS-CURRENT-TIMESTAMP      TO MI-TRANS-HIST-SEQ-NO       
           MOVE 1                         TO MI-TRAN-APPL-NO            
           MOVE 'TIER RANKING'            TO MI-COLUMN-DESC             
           MOVE SPACES                    TO MI-TABLE-ID                
           MOVE IG-MKT-TIER-DESC          TO MI-PRV-COLUMN-VALUE-TEXT   
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                          TO MI-PRV-COLUMN-VALUE-LEN    
                                                                        
           MOVE DD-TIER-CUST-STAT-CD      TO IG-TIER-CUST-STAT-CD       
           MOVE DD-TIER-ACCT-TYPE-CD      TO IG-TIER-ACCT-TYPE-CD       
           MOVE DD-MKT-TIER-RANKING       TO IG-MKT-TIER-RANKING        
           MOVE DD-MKT-TIER-START-DT      TO IG-MKT-TIER-START-DT       
                                                                        
           PERFORM 7310-SEL-MKT-TIER-DESC   THRU 7310-EXIT              
                                                                        
           MOVE IG-MKT-TIER-DESC          TO MI-CHG-COLUMN-VALUE-TEXT   
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                          TO MI-CHG-COLUMN-VALUE-LEN    
                                                                        
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT              
      *                                                                 17600000
           MOVE DD-TIER-CUST-STAT-CD      TO UV-CODE-VALUE-TEXT         
           MOVE LENGTH OF UV-CODE-VALUE-TEXT                            
                                          TO UV-CODE-VALUE-LEN          
           MOVE 'TIER_CUST_STAT_CD'       TO UV-COLUMN-NA-TEXT          
           MOVE LENGTH OF UV-COLUMN-NA-TEXT                             
                                          TO UV-COLUMN-NA-LEN           
           MOVE 'CRM_MKT_TIER'            TO UV-TABLE-NA-TEXT           
           MOVE LENGTH OF UV-TABLE-NA-TEXT                              
                                          TO UV-TABLE-NA-LEN            
           MOVE 'ALL'                     TO UV-PROGRAM-ID              
           MOVE '01'                      TO UV-COMPANY-NO              
           PERFORM 7320-SEL-CODE-VALUE-DESC THRU 7320-EXIT              
                                                                        
           MOVE WS-CURRENT-TIMESTAMP      TO MI-TRANS-HIST-SEQ-NO       
           MOVE 2                         TO MI-TRAN-APPL-NO            
           MOVE 'TIER CUST STAT CD'       TO MI-COLUMN-DESC             
           MOVE SPACES                    TO MI-TABLE-ID                
           MOVE +14                       TO MI-PRV-COLUMN-VALUE-LEN    
           MOVE '** INSERTED **'          TO MI-PRV-COLUMN-VALUE-TEXT   
           MOVE UV-CODE-SHORT-DESC-TEXT   TO MI-CHG-COLUMN-VALUE-TEXT   
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                          TO MI-CHG-COLUMN-VALUE-LEN    
                                                                        
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT              
      *                                                                 17600000
           MOVE DD-TIER-ACCT-TYPE-CD      TO TT-TIER-ACCT-TYPE-CD       
           PERFORM 7330-SEL-TIER-ACCT-TYPE-CD THRU 7330-EXIT            
                                                                        
           MOVE WS-CURRENT-TIMESTAMP      TO MI-TRANS-HIST-SEQ-NO       
           MOVE 3                         TO MI-TRAN-APPL-NO            
           MOVE 'TIER ACCT TYPE CD'       TO MI-COLUMN-DESC             
           MOVE SPACES                    TO MI-TABLE-ID                
           MOVE +14                       TO MI-PRV-COLUMN-VALUE-LEN    
           MOVE '** INSERTED **'          TO MI-PRV-COLUMN-VALUE-TEXT   
           MOVE TT-TIER-ACCT-DESC         TO MI-CHG-COLUMN-VALUE-TEXT   
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                          TO MI-CHG-COLUMN-VALUE-LEN    
                                                                        
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT              
      *                                                                 17600000
           MOVE WS-CURRENT-TIMESTAMP      TO MI-TRANS-HIST-SEQ-NO       
           MOVE 4                         TO MI-TRAN-APPL-NO            
           MOVE 'MKT TIER START DT'       TO MI-COLUMN-DESC             
           MOVE SPACES                    TO MI-TABLE-ID                
           MOVE +14                       TO MI-PRV-COLUMN-VALUE-LEN    
           MOVE '** INSERTED **'          TO MI-PRV-COLUMN-VALUE-TEXT   
           MOVE +10                       TO MI-CHG-COLUMN-VALUE-LEN    
           MOVE DD-MKT-TIER-START-DT      TO MI-CHG-COLUMN-VALUE-TEXT   
                                                                        
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT              
      *                                                                 17600000
           .                                                            
       6620-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6251-GET-FJC01-DATE                                            *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD00037                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 6253-GET-FJC01-CHKP-LIMIT.                                     *        
      ******************************************************************        
            EXEC SQL                                                            
                INCLUDE CPD00034                                                
            END-EXEC.                                                           
                                                                        
      ******************************************************************        
      * 6530-LOAD-MNT-TRANS-HIST.                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************56120023
      * COPYBOOK FOR GOOD PAYMENT CRITERIA CHECKING                    *56130023
      ******************************************************************56140023
            COPY CPD00329.                                              56150023
                                                                        
      *                                                                         
      ***************************************************************** 03832700
      * 7010-SELECT-DELINQ-VALUE                                      * 03832900
      ***************************************************************** 03833000
       7010-SELECT-DELINQ-VALUE.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD    = :C8-DELINQ-CD                       
                 AND COMPANY_NO   = :C8-COMPANY-NO                      
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD    = :C8-DELINQ-CD                               
MFA-TR*          AND COMPANY_NO   = :C8-COMPANY-NO                              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '********** PCSCA280  ABORT **************'      
               DISPLAY '* 7010-SELECT-DELINQ-VALUE              *'      
               DISPLAY '* SQLCODE IS   ' WS-ACTIVE-RETURN-CODE          
               DISPLAY '* DELINQ_CD  : ' C8-DELINQ-CD                   
               DISPLAY '* COMPANY_NO : ' C8-COMPANY-NO                  
               DISPLAY '* PROGRAM ABORTING...                   *'      
               DISPLAY '********** PCSCA280  ABORT **************'      
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF                                                       
      *                                                                         
           .                                                            
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * SELECT CURRENT TIMESTAMP                                       *        
      ******************************************************************        
       7050-SELECT-TIMESTAMP.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*          ,:WS-CURRENT-DATE      = CURRENT DATE                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '********** PCSCA280  ABORT **************'      
               DISPLAY '* 7050-SELECT-TIMESTAMP                 *'      
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                   *'      
               DISPLAY '********** PCSCA280  ABORT **************'      
               PERFORM 9900-ABEND          THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
I00113*                                                                         
I00113******************************************************************        
I00113* 7080-SELECT-CUST-STATS.                                        *        
I00113******************************************************************        
I00113 7080-SELECT-CUST-STATS.                                          
I00113                                                                  
I00113     EXEC SQL                                                     
I00113         SELECT CE.DOB_VERIFIED_CD                                
I00113               ,CE.DATE_OF_BIRTH                                  
I00113           INTO :CE-DOB-VERIFIED-CD                               
I00113               ,:CE-DATE-OF-BIRTH :WS-NULL-IND4                    
I00113           FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED)                   
I00113          WHERE CE.CUSTOMER_NO   = :CE-CUSTOMER-NO                
I00113            AND CE.CUSTOMER_TYPE = :CE-CUSTOMER-TYPE              
I00113                                                           
I00113     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CE.DOB_VERIFIED_CD                                        
MFA-TR*              ,CE.DATE_OF_BIRTH                                          
MFA-TR*          INTO :CE-DOB-VERIFIED-CD                                       
MFA-TR*              ,:CE-DATE-OF-BIRTH:WS-NULL-IND4                            
MFA-TR*          FROM CSS_CUST_STATS CE                                         
MFA-TR*         WHERE CE.CUSTOMER_NO   = :CE-CUSTOMER-NO                        
MFA-TR*           AND CE.CUSTOMER_TYPE = :CE-CUSTOMER-TYPE                      
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00113                                                                  
I00113     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
I00113                                                                  
I00113     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
I00113        IF WS-NULL-IND4 < 0 OR WS-ACTIVE-RETURN-CODE = NOT-FOUND  
I00113           MOVE SPACES           TO CE-DATE-OF-BIRTH              
I00113        END-IF                                                    
I00113     ELSE                                                         
I00113        DISPLAY '********** PCSCA280 ABORT **************'        
I00113        DISPLAY '*      7080-SELECT-CUST-STATS          *'        
I00113        DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
I00113        DISPLAY '* TABLE              : ' 'CSS_CUST_STATS'        
I00113        DISPLAY '* CUSTOMER_NO        : ' CE-CUSTOMER-NO          
I00113        DISPLAY '* CUSTOMER_TYPE      : ' CE-CUSTOMER-TYPE        
I00113        DISPLAY '* PROGRAM ABORTING...                  *'        
I00113        DISPLAY '********** PCSCA280 ABORT **************'        
I00113        PERFORM 9900-ABEND               THRU 9900-EXIT           
I00113     END-IF.                                                      
I00113                                                                  
I00113 7080-EXIT.                                                       
I00113     EXIT.                                                        
I00113*                                                                         
I00113******************************************************************        
I00113* 7090-CALCULATE-AGE                                             *        
I00113******************************************************************        
I00113 7090-CALCULATE-AGE.                                              
I00113                                                                  
I00113     EXEC SQL                                                     
I00113        SELECT
              ( 12 * CIS.DECIMAL2YEAR(CIS.DIFFDATE( 
              IIF(TRY_CONVERT(DATE, :WS-DUMMY-DATE-ST
              ) IS NULL OR (PATINDEX('%.%', :WS-DUMMY-DATE-ST
              ) <> 0) OR (LEN(:WS-DUMMY-DATE-ST) <> 10), CIS.CHAR2DATE(
                                                      :WS-DUMMY-DATE-ST
              ), CONVERT(DATE, :WS-DUMMY-DATE-ST) ), 
              IIF(TRY_CONVERT(DATE, :WS-DUMMY-DATE-END
              ) IS NULL OR (PATINDEX('%.%', :WS-DUMMY-DATE-END
              ) <> 0) OR (LEN(:WS-DUMMY-DATE-END
              ) <> 10), CIS.CHAR2DATE(:WS-DUMMY-DATE-END
              ), CONVERT(DATE, :WS-DUMMY-DATE-END) ) ))    
I00113                                   + 
           CIS.DECIMAL2MONTH(CIS.DIFFDATE( IIF(TRY_CONVERT(DATE, 
                                                      :WS-DUMMY-DATE-ST
              ) IS NULL OR (PATINDEX('%.%', :WS-DUMMY-DATE-ST
              ) <> 0) OR (LEN(:WS-DUMMY-DATE-ST) <> 10), CIS.CHAR2DATE(
                                                      :WS-DUMMY-DATE-ST
              ), CONVERT(DATE, :WS-DUMMY-DATE-ST) ), 
              IIF(TRY_CONVERT(DATE, :WS-DUMMY-DATE-END
              ) IS NULL OR (PATINDEX('%.%', :WS-DUMMY-DATE-END
              ) <> 0) OR (LEN(:WS-DUMMY-DATE-END
              ) <> 10), CIS.CHAR2DATE(:WS-DUMMY-DATE-END
              ), CONVERT(DATE, :WS-DUMMY-DATE-END) ) )))   
I00113                                   / 12
            INTO
              :WS-RESULT-YEAR                           
I00113     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ050
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-RESULT-YEAR = ( 12 * YEAR(DATE(:WS-DUMMY-DATE-ST)         
MFA-TR*                                  - DATE(:WS-DUMMY-DATE-END))            
MFA-TR*                                  + MONTH(DATE(:WS-DUMMY-DATE-ST)        
MFA-TR*                                  - DATE(:WS-DUMMY-DATE-END)))           
MFA-TR*                                  / 12                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00113                                                                  
I00113     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
I00113                                                                  
I00113     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
I00113        NEXT SENTENCE                                             
I00113     ELSE                                                         
I00113        DISPLAY '********** PCSCA280 ABORT **************'        
I00113        DISPLAY '*      7090-CALCULATE-AGE              *'        
I00113        DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
I00113        DISPLAY '* COMMAND            : ' 'SET'                   
I00113        DISPLAY '* ACCOUNT_NO         : ' AT-ACCOUNT-NO           
I00113        DISPLAY '* WS-DUMMY-DATE-ST   : ' WS-DUMMY-DATE-ST        
I00113        DISPLAY '* WS-DUMMY-DATE-END  : ' WS-DUMMY-DATE-END       
I00113        DISPLAY '* PROGRAM ABORTING...                  *'        
I00113        DISPLAY '********** PCSCA280 ABORT **************'        
I00113        PERFORM 9900-ABEND               THRU 9900-EXIT           
I00113     END-IF.                                                      
I00113                                                                  
I00113 7090-EXIT.                                                       
I00113     EXIT.                                                        
I00113*                                                                         
       7120-CHECK-DHR-STATUS.                                           
                                                                        
           EXEC SQL                                                     
P00172         SELECT CU.DHR_FL                                         
P00172           INTO :CU-DHR-FL                                        
P00172           FROM CSS_CUSTOMER CU WITH(READUNCOMMITTED)                     
P00172          WHERE CU.CUSTOMER_NO  = :CU-CUSTOMER-NO                 
P00172                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     52137706
MFA-TR*        SELECT CU.DHR_FL                                         52137806
MFA-TR*          INTO :CU-DHR-FL                                        52137906
MFA-TR*          FROM CSS_CUSTOMER CU                                   52138006
MFA-TR*         WHERE CU.CUSTOMER_NO  = :CU-CUSTOMER-NO                 52138106
MFA-TR*          WITH UR                                                52138306
MFA-TR*    END-EXEC.                                                    52138406

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
P00172     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00172        CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA280 ABORT **************'        
              DISPLAY '*     7120-CHECK-DHR-STATUS            *'        
P00172        DISPLAY '* CUSTOMER NO    : ' CU-CUSTOMER-NO              
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA280 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * SELECT DURATION REMAINING NUMBER                               *        
      ******************************************************************        
       7150-SELECT-DURATION-NO.                                         
      *                                                                         
           EXEC SQL                                                     
               SELECT FF.DURATION_REMAIN_NO                             
P00677           INTO :FF-DURATION-REMAIN-NO                            
                 FROM CSS_FIXED_FCTR     FF WITH(READUNCOMMITTED)               
                     ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)               
                WHERE FF.ACCOUNT_NO         = :FF-ACCOUNT-NO            
                  AND FF.CODE_UTIL_TYPE     = 'G'                       
                  AND FF.IC_NO              = :FF-IC-NO                 
                  AND FF.FACTOR_ID          = HQ.FACTOR_ID              
                  AND HQ.PRIMRY_OPT_ATTR_FL = 'Y'                       
                  AND HQ.OPTION_CD          = :HQ-OPTION-CD             
P00141            AND HQ.ATTR_INCTV_STRT_DT <= IIF(TRY_CONVERT(DATE, 
                                                          :WS-HOLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE
              ) <> 0) OR (LEN(:WS-HOLD-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-HOLD-DATE
              ), CONVERT(DATE, :WS-HOLD-DATE) )            
P00141            AND HQ.ATTR_INCTV_END_DT  >= IIF(TRY_CONVERT(DATE, 
                                                          :WS-HOLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE
              ) <> 0) OR (LEN(:WS-HOLD-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-HOLD-DATE
              ), CONVERT(DATE, :WS-HOLD-DATE) )            
P00677            AND HQ.RT_ATTR_INCTV_TYPE =  'FIXED PRICE'            
                  AND FF.RT_PKG_OPT_SEQ_NO  = :UT-RT-PKG-OPT-SEQ-NO     
P00677            AND FF.DURATION_REMAIN_NO >= 0                        
P00473            AND HQ.PROC_STATUS_CD     = 'AC'                      
P00473            AND HQ.OPT_ATTR_VSTART_TS = (                         
P00473               SELECT MAX(H1.OPT_ATTR_VSTART_TS)                  
P00473                 FROM CRM_OPT_ATTR_INCTV H1 WITH(READUNCOMMITTED)         
P00473                WHERE H1.OPTION_CD    = HQ.OPTION_CD              
P00473                  AND H1.RT_ATTR_INCTV_TYPE                       
P00473                                      = HQ.RT_ATTR_INCTV_TYPE     
P00473                  AND H1.ATTR_INCTV_STRT_DT                       
P00473                                     <= IIF(TRY_CONVERT(DATE, 
                                                          :WS-HOLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE
              ) <> 0) OR (LEN(:WS-HOLD-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-HOLD-DATE
              ), CONVERT(DATE, :WS-HOLD-DATE) )             
P00473                  AND H1.ATTR_INCTV_END_DT                        
P00473                                     >= IIF(TRY_CONVERT(DATE, 
                                                          :WS-HOLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE
              ) <> 0) OR (LEN(:WS-HOLD-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-HOLD-DATE
              ), CONVERT(DATE, :WS-HOLD-DATE) )             
P00473                  AND CAST(H1.OPT_ATTR_VSTART_TS AS DATE)                 
P00473                                     <= IIF(TRY_CONVERT(DATE, 
                                                          :WS-HOLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE
              ) <> 0) OR (LEN(:WS-HOLD-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-HOLD-DATE
              ), CONVERT(DATE, :WS-HOLD-DATE) )             
P00473                  AND CAST(H1.OPT_ATTR_VEND_TS AS DATE)                   
P00473                                     >= IIF(TRY_CONVERT(DATE, 
                                                          :WS-HOLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE
              ) <> 0) OR (LEN(:WS-HOLD-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-HOLD-DATE
              ), CONVERT(DATE, :WS-HOLD-DATE) )             
P00473                  AND H1.PROC_STATUS_CD      = 'AC')              
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FF.DURATION_REMAIN_NO                                     
MFA-TR*          INTO :FF-DURATION-REMAIN-NO                                    
MFA-TR*          FROM CSS_FIXED_FCTR     FF                                     
MFA-TR*              ,CRM_OPT_ATTR_INCTV HQ                                     
MFA-TR*         WHERE FF.ACCOUNT_NO         = :FF-ACCOUNT-NO                    
MFA-TR*           AND FF.CODE_UTIL_TYPE     = 'G'                               
MFA-TR*           AND FF.IC_NO              = :FF-IC-NO                         
MFA-TR*           AND FF.FACTOR_ID          = HQ.FACTOR_ID                      
MFA-TR*           AND HQ.PRIMRY_OPT_ATTR_FL = 'Y'                               
MFA-TR*           AND HQ.OPTION_CD          = :HQ-OPTION-CD                     
MFA-TR*           AND HQ.ATTR_INCTV_STRT_DT <= :WS-HOLD-DATE                    
MFA-TR*           AND HQ.ATTR_INCTV_END_DT  >= :WS-HOLD-DATE                    
MFA-TR*           AND HQ.RT_ATTR_INCTV_TYPE =  'FIXED PRICE'                    
MFA-TR*           AND FF.RT_PKG_OPT_SEQ_NO  = :UT-RT-PKG-OPT-SEQ-NO             
MFA-TR*           AND FF.DURATION_REMAIN_NO >= 0                                
MFA-TR*           AND HQ.PROC_STATUS_CD     = 'AC'                              
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS = (                                 
MFA-TR*              SELECT MAX(H1.OPT_ATTR_VSTART_TS)                          
MFA-TR*                FROM CRM_OPT_ATTR_INCTV H1                               
MFA-TR*               WHERE H1.OPTION_CD    = HQ.OPTION_CD                      
MFA-TR*                 AND H1.RT_ATTR_INCTV_TYPE                               
MFA-TR*                                     = HQ.RT_ATTR_INCTV_TYPE             
MFA-TR*                 AND H1.ATTR_INCTV_STRT_DT                               
MFA-TR*                                    <= :WS-HOLD-DATE                     
MFA-TR*                 AND H1.ATTR_INCTV_END_DT                                
MFA-TR*                                    >= :WS-HOLD-DATE                     
MFA-TR*                 AND DATE(H1.OPT_ATTR_VSTART_TS)                         
MFA-TR*                                    <= :WS-HOLD-DATE                     
MFA-TR*                 AND DATE(H1.OPT_ATTR_VEND_TS)                           
MFA-TR*                                    >= :WS-HOLD-DATE                     
MFA-TR*                 AND H1.PROC_STATUS_CD      = 'AC')                      
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00677        CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA280 ABORT **************'        
              DISPLAY '*     7150-SELECT-DURATION-NO          *'        
              DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '* ACCOUNT_NO        : ' FF-ACCOUNT-NO            
              DISPLAY '* IC-NO             : ' FF-IC-NO                 
              DISPLAY '* OPTION_CD         : ' HQ-OPTION-CD             
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA280 ABORT **************'        
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF                                                       
           .                                                            
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7160-CHECK-SENIOR-ATTR.                                        *        
      * CHECK FOR PENDING STATUS ON AGL DISCOUNT                       *        
      ******************************************************************        
       7160-CHECK-SENIOR-ATTR.                                          
      *                                                                         
           EXEC SQL                                                     
               SELECT 'Y'                                               
                 INTO :WS-AGL-DISCOUNT                                  
                 FROM CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                  
                WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO               
                  AND ATTRIBUTE_DESC     = 'AGL DISCOUNT SR'            
                  AND STATUS_CD          = 'P'                          
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-AGL-DISCOUNT                                          
MFA-TR*          FROM CSS_ACCT_ATTRIBUTE                                        
MFA-TR*         WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                       
MFA-TR*           AND ATTRIBUTE_DESC     = 'AGL DISCOUNT SR'                    
MFA-TR*           AND STATUS_CD          = 'P'                                  
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA280 ABORT **************'        
              DISPLAY '*       7160-CHECK-SENIOR-ATTR         *'        
              DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '* ACCOUNT_NO        : ' AT-ACCOUNT-NO            
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA280 ABORT **************'        
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF                                                       
           .                                                            
      *                                                                         
       7160-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * OPEN BILL_CYC_CUR CURSOR                                       *        
      ******************************************************************        
       7200-OPEN-BILL-CYC-CUR.                                          
                                                                        
           EXEC SQL                                                     
                OPEN BILL_CYC_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA280 ABORT **************'        
              DISPLAY '*    7200-OPEN-BILL-CYC-CUR            *'        
              DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '* HOLD-DATE          : ' WS-HOLD-DATE            
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA280 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 03832700
      * 7210-FETCH-BILL-CYC-CUR                                      *  03832900
      ***************************************************************** 03833000
       7210-FETCH-BILL-CYC-CUR.                                         
      *                                                                         
           EXEC SQL                                                     
                FETCH BILL_CYC_CUR                                      
                 INTO :BN-BILL-CYCLE :WS-NULL-IND                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
                                                                        
              IF (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR                  
                  WS-NULL-IND  = -1 )                                   
                 MOVE SPACES           TO BN-BILL-CYCLE                 
              END-IF                                                    
                                                                        
           ELSE                                                         
              DISPLAY '********** PCSCA280 ABORT **************'        
              DISPLAY '*     7210-FETCH-BILL-CYC-CUR          *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* HOLD DATE      : ' WS-HOLD-DATE                
              DISPLAY '* BILL CYCLE     : ' BN-BILL-CYCLE               
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA280 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 03832700
      * 7220-CLOSE-BILL-CYC-CUR                                       * 03832900
      ***************************************************************** 03833000
       7220-CLOSE-BILL-CYC-CUR.                                         
                                                                        
           EXEC SQL                                                     
                CLOSE BILL_CYC_CUR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA280 ABORT **************'        
              DISPLAY '*     7220-CLOSE-BILL-CYC-CUR          *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* HOLD DATE      : ' WS-HOLD-DATE                
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA280 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7260-SELECT-OPTION-CD.                                         *        
      ******************************************************************        
       7260-SELECT-OPTION-CD.                                           
                                                                        
           EXEC SQL                                                     
               SELECT DF.OPTION_CD                                      
P00677               ,DF.STATUS_CD                                      
                     ,FI.OPT_CALC_TYPE_CD                               
                 INTO :DF-OPTION-CD                                     
P00677               ,:DF-STATUS-CD                                     
                     ,:FI-OPT-CALC-TYPE-CD                              
                 FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                
                     ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                
                WHERE DF.CODE_UTIL_TYPE = 'G'                           
                  AND DF.IC_NO             = :DF-IC-NO                  
                  AND DF.ACCOUNT_NO        = :DF-ACCOUNT-NO             
                  AND DF.OPTION_CD         = FI.OPTION_CD               
                  AND DF.RT_PKG_OPT_SEQ_NO = :UT-RT-PKG-OPT-SEQ-NO      
P00473            AND FI.OPT_VSTART_TS     <= CIS.CURRENT$TIMESTAMP()         
P00473            AND FI.OPT_VEND_TS       >= CIS.CURRENT$TIMESTAMP()         
P00473            AND FI.PROC_STATUS_CD    = 'AC'                       
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DF.OPTION_CD                                              
MFA-TR*              ,DF.STATUS_CD                                              
MFA-TR*              ,FI.OPT_CALC_TYPE_CD                                       
MFA-TR*          INTO :DF-OPTION-CD                                             
MFA-TR*              ,:DF-STATUS-CD                                             
MFA-TR*              ,:FI-OPT-CALC-TYPE-CD                                      
MFA-TR*          FROM CSS_ACCT_RTPK_AGR DF                                      
MFA-TR*              ,CRM_RT_PKG_OPTION FI                                      
MFA-TR*         WHERE DF.CODE_UTIL_TYPE = 'G'                                   
MFA-TR*           AND DF.IC_NO             = :DF-IC-NO                          
MFA-TR*           AND DF.ACCOUNT_NO        = :DF-ACCOUNT-NO                     
MFA-TR*           AND DF.OPTION_CD         = FI.OPTION_CD                       
MFA-TR*           AND DF.RT_PKG_OPT_SEQ_NO = :UT-RT-PKG-OPT-SEQ-NO              
MFA-TR*           AND FI.OPT_VSTART_TS     <= CURRENT TIMESTAMP                 
MFA-TR*           AND FI.OPT_VEND_TS       >= CURRENT TIMESTAMP                 
MFA-TR*           AND FI.PROC_STATUS_CD    = 'AC'                               
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA280 ABORT **************'        
              DISPLAY '*      7260-SELECT-OPTION-CD           *'        
              DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '* ACCOUNT_NO        : ' DF-ACCOUNT-NO            
              DISPLAY '* IC_NO             : ' DF-IC-NO                 
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA280 ABORT **************'        
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF                                                       
           .                                                            
      *                                                                         
       7260-EXIT.                                                       
           EXIT.                                                        
      *                                                                 46350000
      ******************************************************************        
      *                                                                *        
      * 7270-SELECT-ACCT-INFO.                                         *        
      ******************************************************************        
       7270-SELECT-ACCT-INFO.                                           
                                                                        
           EXEC SQL                                                     
               SELECT AT.CUSTOMER_NO                                    
                     ,AT.LOCAL_OFFICE                                   
                     ,AT.PREMISE_NO                                     
                     ,AT.COMPANY_NO                                     
                 INTO :AT-CUSTOMER-NO                                   
                     ,:AT-LOCAL-OFFICE                                  
                     ,:AT-PREMISE-NO                                    
                     ,:AT-COMPANY-NO                                    
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AT.CUSTOMER_NO                                            
MFA-TR*              ,AT.LOCAL_OFFICE                                           
MFA-TR*              ,AT.PREMISE_NO                                             
MFA-TR*              ,AT.COMPANY_NO                                             
MFA-TR*          INTO :AT-CUSTOMER-NO                                           
MFA-TR*              ,:AT-LOCAL-OFFICE                                          
MFA-TR*              ,:AT-PREMISE-NO                                            
MFA-TR*              ,:AT-COMPANY-NO                                            
MFA-TR*          FROM CSS_ACCOUNT AT                                            
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA280 ABORT **************'        
              DISPLAY '*     7270-SELECT-ACCT-INFO            *'        
              DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '* ACCOUNT_NO        : ' AT-ACCOUNT-NO            
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA280 ABORT **************'        
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF                                                       
           .                                                            
      *                                                                         
       7270-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00453******************************************************************        
P00453*7290-GET-PREPAY-HIST-ROWCOUNT                                  *         
P00453******************************************************************        
P00453*                                                                         
P00453 7290-GET-PREPAY-HIST-ROWCOUNT.                                   
P00453*                                                                         
P00453      MOVE '7290'                   TO ACTIVE-PARAGRAPH.          
P00453                                                                  
P00453      EXEC SQL                                                    
P00453           SELECT COUNT(1)                                        
P00453             INTO :WS-PREPAY-COUNT :WS-PREPAY-COUNT-NULL           
P00453             FROM CSS_PREPAY_HIST PK WITH(READUNCOMMITTED)                
P00453            WHERE PK.ACCOUNT_NO     = :PK-ACCOUNT-NO              
P00453                                                           
P00453                                                      
P00453      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*          SELECT COUNT(1)                                                
MFA-TR*            INTO :WS-PREPAY-COUNT:WS-PREPAY-COUNT-NULL                   
MFA-TR*            FROM CSS_PREPAY_HIST PK                                      
MFA-TR*           WHERE PK.ACCOUNT_NO     = :PK-ACCOUNT-NO                      
MFA-TR*            WITH UR                                                      
MFA-TR*       QUERYNO 7290                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00453                                                                  
P00453      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
P00453                                                                  
P00453      IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
P00453         IF WS-PREPAY-COUNT-NULL = -1                             
P00453            MOVE ZERO            TO WS-PREPAY-COUNT               
P00453         END-IF                                                   
P00453      ELSE                                                        
P00453         DISPLAY '********** PCSCA280 ABORT **************'       
P00453         DISPLAY '*    7290-GET-PREPAY-HIST-ROWCOUNT     *'       
P00453         DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE   
P00453         DISPLAY '* ACCOUNT_NO        : ' PK-ACCOUNT-NO           
P00453         DISPLAY '* PROGRAM ABORTING...                  *'       
P00453         DISPLAY '********** PCSCA280 ABORT **************'       
P00453         PERFORM 9900-ABEND                     THRU 9900-EXIT    
P00453      END-IF.                                                     
P00453                                                                  
P00453 7290-EXIT.                                                       
P00453     EXIT.                                                        
P00453*                                                                         
      ******************************************************************        
      *                                                                *        
      * 7310-SEL-MKT-TIER-DESC.                                        *        
      ******************************************************************        
       7310-SEL-MKT-TIER-DESC.                                          
                                                                        
           EXEC SQL                                                     
               SELECT IG.MKT_TIER_DESC                                  
                 INTO :IG-MKT-TIER-DESC                                 
                 FROM CRM_MKT_TIER IG WITH(READUNCOMMITTED)                     
                WHERE IG.TIER_CUST_STAT_CD  = :IG-TIER-CUST-STAT-CD     
                  AND IG.TIER_ACCT_TYPE_CD  = :IG-TIER-ACCT-TYPE-CD     
                  AND IG.MKT_TIER_RANKING   = :IG-MKT-TIER-RANKING      
                  AND IG.COMPANY_NO         = :IG-COMPANY-NO            
                  AND IG.MKT_TIER_START_DT  = IIF(TRY_CONVERT(DATE, 
                                                  :IG-MKT-TIER-START-DT
              ) IS NULL OR (PATINDEX('%.%', :IG-MKT-TIER-START-DT
              ) <> 0) OR (LEN(:IG-MKT-TIER-START-DT
              ) <> 10), CIS.CHAR2DATE(:IG-MKT-TIER-START-DT
              ), CONVERT(DATE, :IG-MKT-TIER-START-DT) )     
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT IG.MKT_TIER_DESC                                          
MFA-TR*          INTO :IG-MKT-TIER-DESC                                         
MFA-TR*          FROM CRM_MKT_TIER IG                                           
MFA-TR*         WHERE IG.TIER_CUST_STAT_CD  = :IG-TIER-CUST-STAT-CD             
MFA-TR*           AND IG.TIER_ACCT_TYPE_CD  = :IG-TIER-ACCT-TYPE-CD             
MFA-TR*           AND IG.MKT_TIER_RANKING   = :IG-MKT-TIER-RANKING              
MFA-TR*           AND IG.COMPANY_NO         = :IG-COMPANY-NO                    
MFA-TR*           AND IG.MKT_TIER_START_DT  = :IG-MKT-TIER-START-DT             
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '********** PCSCA280 ABORT **************'        
              DISPLAY '*        7310-SEL-MKT-TIER-DESC        *'        
              DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '* TIER_CUST_STAT_CD : ' IG-TIER-CUST-STAT-CD     
              DISPLAY '* TIER_ACCT_TYPE_CD : ' IG-TIER-ACCT-TYPE-CD     
              DISPLAY '* MKT_TIER_RANKING  : ' IG-MKT-TIER-RANKING      
              DISPLAY '* MKT_TIER_START_DT : ' IG-MKT-TIER-START-DT     
              DISPLAY '* COMPANY_NO        : ' IG-COMPANY-NO            
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA280 ABORT **************'        
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7320-SEL-CODE-VALUE-DESC                                       *        
      ******************************************************************        
       7320-SEL-CODE-VALUE-DESC.                                        
                                                                        
           EXEC SQL                                                     
              SELECT CODE_SHORT_DESC                                    
               INTO :UV-CODE-SHORT-DESC                                 
               FROM CSS_CODE_VALUE WITH(READUNCOMMITTED)                        
              WHERE CODE_VALUE     = :UV-CODE-VALUE                     
                AND COLUMN_NA      = :UV-COLUMN-NA                      
                AND COMPANY_NO     = :UV-COMPANY-NO                     
                AND PROGRAM_ID     = :UV-PROGRAM-ID                     
                AND TABLE_NA       = :UV-TABLE-NA                       
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_SHORT_DESC                                            
MFA-TR*        INTO :UV-CODE-SHORT-DESC                                         
MFA-TR*        FROM CSS_CODE_VALUE                                              
MFA-TR*       WHERE CODE_VALUE     = :UV-CODE-VALUE                             
MFA-TR*         AND COLUMN_NA      = :UV-COLUMN-NA                              
MFA-TR*         AND COMPANY_NO     = :UV-COMPANY-NO                             
MFA-TR*         AND PROGRAM_ID     = :UV-PROGRAM-ID                             
MFA-TR*         AND TABLE_NA       = :UV-TABLE-NA                               
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA280 ABORT **************'        
              DISPLAY '*        7320-SEL-CODE-VALUE-DESC      *'        
              DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '* CODE_VALUE        : ' UV-CODE-VALUE            
              DISPLAY '* COLUMN_NA         : ' UV-COLUMN-NA             
              DISPLAY '* COMPANY_NO        : ' UV-COMPANY-NO            
              DISPLAY '* PROGRAM_ID        : ' UV-PROGRAM-ID            
              DISPLAY '* TABLE_NA          : ' UV-TABLE-NA              
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA280 ABORT **************'        
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7330-SEL-TIER-ACCT-TYPE-CD                                     *        
      ******************************************************************        
       7330-SEL-TIER-ACCT-TYPE-CD.                                      
                                                                        
           EXEC SQL                                                     
              SELECT TT.TIER_ACCT_DESC                                  
               INTO :TT-TIER-ACCT-DESC                                  
               FROM CRM_TIER_ACCT_TYPE TT WITH(READUNCOMMITTED)                 
              WHERE TT.COMPANY_NO        = '01'                         
                AND TT.TIER_ACCT_TYPE_CD = :TT-TIER-ACCT-TYPE-CD        
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT TT.TIER_ACCT_DESC                                          
MFA-TR*        INTO :TT-TIER-ACCT-DESC                                          
MFA-TR*        FROM CRM_TIER_ACCT_TYPE TT                                       
MFA-TR*       WHERE TT.COMPANY_NO        = '01'                                 
MFA-TR*         AND TT.TIER_ACCT_TYPE_CD = :TT-TIER-ACCT-TYPE-CD                
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA280 ABORT **************'        
              DISPLAY '*      7330-SEL-TIER-ACCT-TYPE-CD      *'        
              DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '* TIER_ACCT_TYPE_CD : ' TT-TIER-ACCT-TYPE-CD     
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA280 ABORT **************'        
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF.                                                      
                                                                        
       7330-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************46060000
      * SELECT ARREARS HIST FROM CSS_CREDIT_PROFILE                    *46070000
      ******************************************************************46080000
      *                                                                 46090000
       7350-SELECT-ARR-HIST.                                            
      *                                                                 46110000
           EXEC SQL                                                     
              SELECT ARREARS_HIST                                       
                    ,DISCONNECT_HIST                                    
                    ,DISC_EXCEPTN_HIST                                  
                    ,NON_UTL_CR_HST                                     
                    ,NON_UTL_CR_HST_EX                                  
                    ,NON_UTL_ARRER_HIST                                 
                INTO :CZ-ARREARS-HIST                                   
                    ,:CZ-DISCONNECT-HIST                                
                    ,:CZ-DISC-EXCEPTN-HIST                              
                    ,:CZ-NON-UTL-CR-HST                                 
                    ,:CZ-NON-UTL-CR-HST-EX                              
                    ,:CZ-NON-UTL-ARRER-HIST                             
                FROM CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     46120000
MFA-TR*       SELECT ARREARS_HIST                                       46130000
MFA-TR*             ,DISCONNECT_HIST                                    46131022
MFA-TR*             ,DISC_EXCEPTN_HIST                                  46132022
MFA-TR*             ,NON_UTL_CR_HST                                     46133022
MFA-TR*             ,NON_UTL_CR_HST_EX                                  46134022
MFA-TR*             ,NON_UTL_ARRER_HIST                                 46138022
MFA-TR*         INTO :CZ-ARREARS-HIST                                   46140000
MFA-TR*             ,:CZ-DISCONNECT-HIST                                46141022
MFA-TR*             ,:CZ-DISC-EXCEPTN-HIST                              46142022
MFA-TR*             ,:CZ-NON-UTL-CR-HST                                 46143022
MFA-TR*             ,:CZ-NON-UTL-CR-HST-EX                              46144022
MFA-TR*             ,:CZ-NON-UTL-ARRER-HIST                             46145022
MFA-TR*         FROM CSS_CREDIT_PROFILE                                 46150000
MFA-TR*        WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                        46160000
MFA-TR*        WITH UR                                                  46170000
MFA-TR*    END-EXEC.                                                    46180000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 46190000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA280 ABORT **************'       
               DISPLAY '* 7350-SELECT-ARR-HIST                 *'       
               DISPLAY '* ACCOUNT NO ', CZ-ACCOUNT-NO                   
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA280 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 46320000
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************46060000
      * SELECT DEFAULT TIER RANK FROM CRM_MKT_TIER                     *46070000
      ******************************************************************46080000
      *                                                                 46090000
       7360-GET-DEFAULT-TIER-RANK.                                      
      *                                                                 46110000
           EXEC SQL                                                     
              SELECT IG.TIER_CUST_STAT_CD                               
                    ,IG.MKT_TIER_RANKING                                
                    ,IG.MKT_TIER_START_DT                               
                INTO :IG-TIER-CUST-STAT-CD                              
                    ,:IG-MKT-TIER-RANKING                               
                    ,:IG-MKT-TIER-START-DT                              
                FROM CRM_MKT_TIER   IG WITH(READUNCOMMITTED)                    
               WHERE TIER_CUST_STAT_CD  = 'E'                           
                 AND TIER_ACCT_TYPE_CD  = :IG-TIER-ACCT-TYPE-CD         
                 AND CUST_ACCT_DEFLT_FL = 'Y'                           
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     46120000
MFA-TR*       SELECT IG.TIER_CUST_STAT_CD                               46130000
MFA-TR*             ,IG.MKT_TIER_RANKING                                46130000
MFA-TR*             ,IG.MKT_TIER_START_DT                                       
MFA-TR*         INTO :IG-TIER-CUST-STAT-CD                                      
MFA-TR*             ,:IG-MKT-TIER-RANKING                                       
MFA-TR*             ,:IG-MKT-TIER-START-DT                                      
MFA-TR*         FROM CRM_MKT_TIER   IG                                          
MFA-TR*        WHERE TIER_CUST_STAT_CD  = 'E'                                   
MFA-TR*          AND TIER_ACCT_TYPE_CD  = :IG-TIER-ACCT-TYPE-CD                 
MFA-TR*          AND CUST_ACCT_DEFLT_FL = 'Y'                                   
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 46110000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA280 ABORT **************'       
               DISPLAY '* 7360-GET-DEFAULT-TIER-RANK           *'       
               DISPLAY '* TIER_CUST_STAT_CD ',IG-TIER-CUST-STAT-CD      
               DISPLAY '* TIER_ACCT_TYPE_CD ',IG-TIER-ACCT-TYPE-CD      
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA280 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 46320000
       7360-EXIT.                                                       
           EXIT.                                                        
      *                                                                 46320000
P00453******************************************************************46060000
P00453* SELECT DEFAULT TIER RANK FOR PRP CUSTOMER.                     *46070000
P00453******************************************************************46080000
P00453 7370-GET-DEFAULT-PRP-TIER.                                       
P00453*                                                                 46110000
P00453     EXEC SQL                                                     
P00453        SELECT IG.TIER_CUST_STAT_CD                               
P00453              ,IG.MKT_TIER_RANKING                                
P00453              ,IG.MKT_TIER_START_DT                               
P00453          INTO :IG-TIER-CUST-STAT-CD                              
P00453              ,:IG-MKT-TIER-RANKING                               
P00453              ,:IG-MKT-TIER-START-DT                              
P00453          FROM CRM_MKT_TIER   IG WITH(READUNCOMMITTED)                    
P00453         WHERE TIER_CUST_STAT_CD   = 'E'                          
P00453           AND TIER_ACCT_TYPE_CD   = :IG-TIER-ACCT-TYPE-CD        
P00453           AND IG.MKT_TIER_RANKING = :WS-PRP-MKT-TIER-RANK        
P00453                                                           
P00453     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     46120000
MFA-TR*       SELECT IG.TIER_CUST_STAT_CD                               46130000
MFA-TR*             ,IG.MKT_TIER_RANKING                                46130000
MFA-TR*             ,IG.MKT_TIER_START_DT                               46320000
MFA-TR*         INTO :IG-TIER-CUST-STAT-CD                              46320000
MFA-TR*             ,:IG-MKT-TIER-RANKING                               46320000
MFA-TR*             ,:IG-MKT-TIER-START-DT                              46320000
MFA-TR*         FROM CRM_MKT_TIER   IG                                  46320000
MFA-TR*        WHERE TIER_CUST_STAT_CD   = 'E'                          46320000
MFA-TR*          AND TIER_ACCT_TYPE_CD   = :IG-TIER-ACCT-TYPE-CD        46320000
MFA-TR*          AND IG.MKT_TIER_RANKING = :WS-PRP-MKT-TIER-RANK        46320000
MFA-TR*         WITH UR                                                 46320000
MFA-TR*    END-EXEC.                                                    46320000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00453*                                                                 46110000
P00453     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P00453     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
P00453         CONTINUE                                                 
P00453     ELSE                                                         
P00453         DISPLAY '********** PCSCA280 ABORT **************'       
P00453         DISPLAY '* 7370-GET-DEF-PRP-TIER-RANK           *'       
P00453         DISPLAY '* TIER_CUST_STAT_CD ',IG-TIER-CUST-STAT-CD      
P00453         DISPLAY '* TIER_ACCT_TYPE_CD ',IG-TIER-ACCT-TYPE-CD      
P00453         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
P00453         DISPLAY '* PROGRAM ABORTING...                  *'       
P00453         DISPLAY '********** PCSCA280 ABORT **************'       
P00453         PERFORM 9900-ABEND              THRU 9900-EXIT           
P00453     END-IF.                                                      
P00453*                                                                 46320000
P00453 7370-EXIT.                                                       
P00453     EXIT.                                                        
                                                                        
OTPOOL******************************************************************46060000
OTPOOL* SELECT MARKET TIER RANKING DETAILS FOR OUTER POOL CUSTOMERS    *46070000
OTPOOL******************************************************************46080000
OTPOOL 7380-GET-OUTER-POOL-TIER-DTLS.                                   
OTPOOL*                                                                 46110000
OTPOOL     EXEC SQL                                                     
OTPOOL        SELECT TOP(1) IG.TIER_CUST_STAT_CD,
              IG.MKT_TIER_RANKING,
              IG.MKT_TIER_START_DT                              
OTPOOL          INTO :IG-TIER-CUST-STAT-CD                              
OTPOOL              ,:IG-MKT-TIER-RANKING                               
OTPOOL              ,:IG-MKT-TIER-START-DT                              
OTPOOL          FROM  CRM_MKT_TIER   IG WITH(READUNCOMMITTED)                   
OTPOOL         WHERE  TIER_CUST_STAT_CD   = 'E'                         
OTPOOL           AND  TIER_ACCT_TYPE_CD   = :IG-TIER-ACCT-TYPE-CD       
OTPOOL           AND  IG.MKT_TIER_RANKING = :WS-OUTER-POOL-TIER-RANK    
OTPOOL         ORDER BY IG.MKT_TIER_START_DT DESC                       
OTPOOL                                              
OTPOOL                                                           
OTPOOL     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     46120000
MFA-TR*       SELECT  IG.TIER_CUST_STAT_CD                              46130000
MFA-TR*             , IG.MKT_TIER_RANKING                               46130000
MFA-TR*             , IG.MKT_TIER_START_DT                              46320000
MFA-TR*         INTO :IG-TIER-CUST-STAT-CD                              46320000
MFA-TR*             ,:IG-MKT-TIER-RANKING                               46320000
MFA-TR*             ,:IG-MKT-TIER-START-DT                              46320000
MFA-TR*         FROM  CRM_MKT_TIER   IG                                 46320000
MFA-TR*        WHERE  TIER_CUST_STAT_CD   = 'E'                         46320000
MFA-TR*          AND  TIER_ACCT_TYPE_CD   = :IG-TIER-ACCT-TYPE-CD       46320000
MFA-TR*          AND  IG.MKT_TIER_RANKING = :WS-OUTER-POOL-TIER-RANK    46320000
MFA-TR*        ORDER BY IG.MKT_TIER_START_DT DESC                               
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                 46320000
MFA-TR*    END-EXEC.                                                    46320000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

OTPOOL*                                                                 46110000
OTPOOL     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
OTPOOL     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
OTPOOL         CONTINUE                                                 
OTPOOL     ELSE                                                         
OTPOOL         DISPLAY '********** PCSCA280 ABORT **************'       
OTPOOL         DISPLAY '* 7380-GET-OUTER-POOL-TIER-DTLS        *'       
OTPOOL         DISPLAY '* TIER_CUST_STAT_CD ',IG-TIER-CUST-STAT-CD      
OTPOOL         DISPLAY '* MKT_TIER_RANKING  ',WS-OUTER-POOL-TIER-RANK   
OTPOOL         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
OTPOOL         DISPLAY '* PROGRAM ABORTING...                  *'       
OTPOOL         DISPLAY '********** PCSCA280 ABORT **************'       
OTPOOL         PERFORM 9900-ABEND              THRU 9900-EXIT           
OTPOOL     END-IF.                                                      
OTPOOL*                                                                 46320000
OTPOOL 7380-EXIT.                                                       
OTPOOL     EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7400-OPEN-MKT-TIER-ADJ-CUR.                                    *        
      ******************************************************************        
       7400-OPEN-MKT-TIER-ADJ-CUR.                                      
                                                                        
           EXEC SQL                                                     
                OPEN MKT_TIER_ADJ_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA280 ABORT **************'        
              DISPLAY '*     7400-OPEN-MKT-TIER-ADJ-CUR       *'        
              DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA280 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF                                                       
                                                                        
           .                                                            
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7410-FETCH-MKT-TIER-ADJ-CUR.                                   *        
      ******************************************************************        
       7410-FETCH-MKT-TIER-ADJ-CUR.                                     
                                                                        
           EXEC SQL                                                     
                FETCH MKT_TIER_ADJ_CUR                                  
                 INTO :1B-TIER-CUST-STAT-CD                             
                     ,:1B-TIER-ACCT-TYPE-CD                             
                     ,:1B-MKT-TIER-RANKING                              
                     ,:1B-MKT-TIER-START-DT                             
                     ,:1B-ADJ-TIER-SEQ-NO                               
                     ,:1B-AGL-LOW-INCM-SR-FL                            
                     ,:1B-MIN-GOOD-PAY-QTY :WS-NULL-IND1                 
P00172               ,:1B-MISSED-PYMT-QTY :WS-NULL-IND5                  
                     ,:1B-APPLICATION-CD                                
                     ,:1B-ADJ-TIER-ACCT-TYPE                            
                     ,:1B-ADJ-TIER-RANKING                              
                     ,:1B-ADJ-TIER-START-DT                             
                     ,:1B-ADJ-START-DT                                  
                     ,:1B-ADJ-END-DT                                    
                     ,:1B-ADJ-SOURCE-CD                                 
                     ,:1B-DHR-QUALIFIED-FL                              
P00172               ,:1B-EVAL-MONTHS-QTY                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 'Y'              TO WS-MKT-TIER-ROWS              
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSCA280 ABORT **************'        
              DISPLAY '*     7410-FETCH-MKT-TIER-ADJ-CUR      *'        
              DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA280 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF                                                       
                                                                        
           .                                                            
       7410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7420-CLOSE-MKT-TIER-ADJ-CUR.                                   *        
      ******************************************************************        
       7420-CLOSE-MKT-TIER-ADJ-CUR.                                     
      *                                                                         
           EXEC SQL                                                     
                CLOSE MKT_TIER_ADJ_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA280 ABORT **************'        
              DISPLAY '*    7420-CLOSE-MKT-TIER-ADJ-CUR       *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA280 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF                                                       
                                                                        
           .                                                            
       7420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7500-OPEN-REGULATED-CUR.                                       *        
      ******************************************************************        
       7500-OPEN-REGULATED-CUR.                                         
                                                                        
           EXEC SQL                                                     
                OPEN REGULATED_ACCT                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA280 ABORT **************'        
              DISPLAY '*     7500-OPEN-REGULATED-CUR          *'        
              DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '* CURR BILL_CYCLE IN : ' WS-CYC1, WS-CYC2,       
                                       WS-BILL-CYCLE1, WS-BILL-CYCLE2   
              DISPLAY '* EFF_START_DT       : ' WS-EFF-START-DT         
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA280 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF                                                       
                                                                        
           .                                                            
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7510-FETCH-REGULATED-CUR.                                      *        
      ******************************************************************        
       7510-FETCH-REGULATED-CUR.                                        
                                                                        
           EXEC SQL                                                     
                FETCH REGULATED_ACCT                                    
                 INTO :AT-ACCOUNT-NO                                    
I00113               ,:AT-CUSTOMER-NO                                   
                     ,:AT-BILL-CYCLE                                    
                     ,:AT-REV-MTH-LST-NRML                              
                     ,:AT-CODES-DATA-PRESENT                            
                     ,:UT-GAS-BASE-LAST-UPDT :WS-NULL-IND3               
                     ,:UT-IC-NO                                         
                     ,:UT-RT-PKG-OPT-SEQ-NO                             
                     ,:DD-TIER-CUST-STAT-CD                             
                     ,:DD-TIER-ACCT-TYPE-CD                             
                     ,:DD-MKT-TIER-RANKING                              
                     ,:DD-MKT-TIER-START-DT                             
                     ,:LR-SENIOR-FL                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
PRDFIX        IF WS-NULL-IND3 < 0                                       
PRDFIX           MOVE SPACES           TO UT-GAS-BASE-LAST-UPDT         
PRDFIX        END-IF                                                    
PRDFIX                                                                  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 'Y'              TO WS-NO-REGULATED-ROWS          
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSCA280 ABORT **************'        
              DISPLAY '*       7510-FETCH-REGULATED-CUR       *'        
              DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '* CURR BILL_CYCLE IN : ' WS-CYC1, WS-CYC2,       
                                       WS-BILL-CYCLE1, WS-BILL-CYCLE2   
              DISPLAY '* EFF_START_DT       : ' WS-EFF-START-DT         
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA280 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF                                                       
                                                                        
           .                                                            
       7510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7520-CLOSE-REGULATED-CUR.                                      *        
      ******************************************************************        
       7520-CLOSE-REGULATED-CUR.                                        
                                                                        
           EXEC SQL                                                     
                CLOSE REGULATED_ACCT                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA280 ABORT **************'        
              DISPLAY '*     7520-CLOSE-REGULATED-CUR         *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA280 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF                                                       
                                                                        
           .                                                            
       7520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7750-OPEN-DREG-PROSPECT-CUR.                                   *        
      ******************************************************************        
       7750-OPEN-DREG-PROSPECT-CUR.                                     
                                                                        
           EXEC SQL                                                     
                OPEN DREG_PROSPECT_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA280 ABORT **************'        
              DISPLAY '*    7750-OPEN-DREG-PROSPECT-CUR       *'        
              DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '* CURR BILL_CYCLE IN : ' WS-CYC1, WS-CYC2        
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA280 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF                                                       
                                                                        
           .                                                            
       7750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7760-FETCH-DREG-PROSPECT-CUR                                   *        
      ******************************************************************        
       7760-FETCH-DREG-PROSPECT-CUR.                                    
                                                                        
           EXEC SQL                                                     
                FETCH DREG_PROSPECT_CUR                                 
                 INTO :AT-ACCOUNT-NO                                    
P00453               ,:AT-CODES-DATA-PRESENT                            
OTPOOL               ,:AT-LOCAL-OFFICE                                  
OTPOOL               ,:B1-DIVISION-NO                                   
                     ,:DD-TIER-CUST-STAT-CD                             
                     ,:DD-TIER-ACCT-TYPE-CD                             
                     ,:DD-MKT-TIER-RANKING                              
                     ,:DD-MKT-TIER-START-DT                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 'Y'              TO WS-NO-DREG-ROWS               
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSCA280 ABORT **************'        
              DISPLAY '*  7760-FETCH-DREG-PROSPECT-CUR        *'        
              DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '* CURR BILL_CYCLE IN : ' WS-CYC1, WS-CYC2        
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA280 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF                                                       
                                                                        
           .                                                            
       7760-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7770-CLOSE-DREG-PROSPECT-CUR                                   *        
      ******************************************************************        
       7770-CLOSE-DREG-PROSPECT-CUR.                                    
                                                                        
           EXEC SQL                                                     
                CLOSE DREG_PROSPECT_CUR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA280 ABORT **************'        
              DISPLAY '*   7770-CLOSE-DREG-PROSPECT-CUR       *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA280 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF                                                       
                                                                        
           .                                                            
       7770-EXIT.                                                       
           EXIT.                                                        
I00113                                                                  
I00113******************************************************************        
I00113* 7780-MAX-REV-MTH-DATE.                                         *        
I00113*   GET THE MAXIMUM EXTRACT DATE OF A REVENUE MONTH              *        
I00113******************************************************************        
I00113 7780-MAX-REV-MTH-DATE.                                           
I00113*                                                                 46190000
I00113     EXEC SQL                                                     
I00113        SELECT MAX(DATE_EXTRACT)                                  
I00113          INTO :BN-DATE-EXTRACT                                   
I00113          FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                      
I00113         WHERE REVENUE_MONTH = :BN-REVENUE-MONTH                  
I00113                                                           
I00113     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     46120000
MFA-TR*       SELECT MAX(DATE_EXTRACT)                                  46130000
MFA-TR*         INTO :BN-DATE-EXTRACT                                   46140000
MFA-TR*         FROM CSS_BILL_WINDOW                                    46150000
MFA-TR*        WHERE REVENUE_MONTH = :BN-REVENUE-MONTH                  46160000
MFA-TR*        WITH UR                                                  46170000
MFA-TR*    END-EXEC.                                                    46180000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00113*                                                                 46190000
I00113     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
I00113     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
I00113         CONTINUE                                                 
I00113     ELSE                                                         
I00113         DISPLAY '********** PCSCA280 ABORT **************'       
I00113         DISPLAY '* 7780-MAX-REV-MTH-DATE                *'       
I00113         DISPLAY '* REVENUE_MONTH', BN-REVENUE-MONTH              
I00113         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
I00113         DISPLAY '* PROGRAM ABORTING...                  *'       
I00113         DISPLAY '********** PCSCA280 ABORT **************'       
I00113         PERFORM 9900-ABEND              THRU 9900-EXIT           
I00113     END-IF.                                                      
I00113     .                                                            
I00113 7780-EXIT.                                                       
I00113     EXIT.                                                        
      *                                                                         
P805AP*****************************************************************         
P805AP* 7790-GET-ACCOUNT-ATTRIBUTE.                                    *        
P805AP*****************************************************************         
P805AP 7790-GET-ACCOUNT-ATTRIBUTE.                                      
P805AP                                                                  
P805AP     EXEC SQL                                                     
P805AP        SELECT 'Y'                                                
P805AP          INTO :WS-ACCT-ATTRIBUTE-EXIST                           
P805AP          FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)                
P805AP         WHERE YP.ACCOUNT_NO      = :YP-ACCOUNT-NO                
P805AP           AND YP.ATTRIBUTE_DESC  = :YP-ATTRIBUTE-DESC            
P805AP           AND YP.STATUS_CD       = 'A'                           
P805AP                                                           
P805AP     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-ACCT-ATTRIBUTE-EXIST                                   
MFA-TR*         FROM CSS_ACCT_ATTRIBUTE YP                                      
MFA-TR*        WHERE YP.ACCOUNT_NO      = :YP-ACCOUNT-NO                        
MFA-TR*          AND YP.ATTRIBUTE_DESC  = :YP-ATTRIBUTE-DESC                    
MFA-TR*          AND YP.STATUS_CD       = 'A'                                   
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P805AP                                                                  
P805AP     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P805AP                                                                  
P805AP     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P805AP         NEXT SENTENCE                                            
P805AP     ELSE                                                         
P805AP         DISPLAY '********** PCSCA280 ABORT **************'       
P805AP         DISPLAY '* 7790-GET-ACCOUNT-ATTRIBUTE           *'       
P805AP         DISPLAY '* ACCOUNT NO     ', YP-ACCOUNT-NO               
P805AP         DISPLAY '* ATTRIBUTE DESC ', YP-ATTRIBUTE-DESC           
P805AP         DISPLAY '* SQLCODE IS     ', WS-ACTIVE-RETURN-CODE       
P805AP         DISPLAY '* PROGRAM ABORTING...                  *'       
P805AP         DISPLAY '********** PCSCA280 ABORT **************'       
P805AP     END-IF.                                                      
P805AP                                                                  
P805AP 7790-EXIT.                                                       
P805AP     EXIT.                                                        
P805AP                                                                  
      **************************************************************            
      * CPD00038                                                   *            
      * 7600-START-FCSJC01                                         *            
      * 7610-READ-FCSJC01                                          *            
      * 7611-CLOSE                                                 *            
      **************************************************************            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 8100-INSERT-CIS-DATA.                                          *        
      ******************************************************************        
       8100-INSERT-CIS-DATA.                                            
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_ACCT_MKT_TIER                            
                      ( ACCOUNT_NO                                      
                       ,TIER_CUST_STAT_CD                               
                       ,TIER_ACCT_TYPE_CD                               
                       ,MKT_TIER_RANKING                                
                       ,MKT_TIER_START_DT                               
                       ,COMPANY_NO                                      
                       ,CREATED_TS                                      
                       ,LAST_UPDATE_USERID                              
                       ,EFF_START_DT                                    
                       ,LAST_UPDATE_TS                                  
                       ,LAST_EVALUATED_DT                               
                       ,TIER_SOURCE_CD                                  
                       ,ADJ_TIER_SEQ_NO)                                
               VALUES ( :DD-ACCOUNT-NO                                  
                       ,:DD-TIER-CUST-STAT-CD                           
                       ,:DD-TIER-ACCT-TYPE-CD                           
                       ,:DD-MKT-TIER-RANKING                            
                       ,IIF(TRY_CONVERT(DATE, :DD-MKT-TIER-START-DT
              ) IS NULL OR (PATINDEX('%.%', :DD-MKT-TIER-START-DT
              ) <> 0) OR (LEN(:DD-MKT-TIER-START-DT
              ) <> 10), CIS.CHAR2DATE(:DD-MKT-TIER-START-DT
              ), CONVERT(DATE, :DD-MKT-TIER-START-DT) )                        
                       ,:DD-COMPANY-NO                                  
                       , CIS.CURRENT$TIMESTAMP()                              
                       ,:DD-LAST-UPDATE-USERID                          
                       ,IIF(TRY_CONVERT(DATE, :DD-EFF-START-DT
              ) IS NULL OR (PATINDEX('%.%', :DD-EFF-START-DT
              ) <> 0) OR (LEN(:DD-EFF-START-DT) <> 10), CIS.CHAR2DATE(
                                                       :DD-EFF-START-DT
              ), CONVERT(DATE, :DD-EFF-START-DT) )                             
                       , CIS.CURRENT$TIMESTAMP()                              
                       ,IIF(TRY_CONVERT(DATE, :DD-LAST-EVALUATED-DT
              ) IS NULL OR (PATINDEX('%.%', :DD-LAST-EVALUATED-DT
              ) <> 0) OR (LEN(:DD-LAST-EVALUATED-DT
              ) <> 10), CIS.CHAR2DATE(:DD-LAST-EVALUATED-DT
              ), CONVERT(DATE, :DD-LAST-EVALUATED-DT) )                        
                       ,:DD-TIER-SOURCE-CD                              
                       ,:DD-ADJ-TIER-SEQ-NO)                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_ACCT_MKT_TIER                                    
MFA-TR*               ( ACCOUNT_NO                                              
MFA-TR*                ,TIER_CUST_STAT_CD                                       
MFA-TR*                ,TIER_ACCT_TYPE_CD                                       
MFA-TR*                ,MKT_TIER_RANKING                                        
MFA-TR*                ,MKT_TIER_START_DT                                       
MFA-TR*                ,COMPANY_NO                                              
MFA-TR*                ,CREATED_TS                                              
MFA-TR*                ,LAST_UPDATE_USERID                                      
MFA-TR*                ,EFF_START_DT                                            
MFA-TR*                ,LAST_UPDATE_TS                                          
MFA-TR*                ,LAST_EVALUATED_DT                                       
MFA-TR*                ,TIER_SOURCE_CD                                          
MFA-TR*                ,ADJ_TIER_SEQ_NO)                                        
MFA-TR*        VALUES ( :DD-ACCOUNT-NO                                          
MFA-TR*                ,:DD-TIER-CUST-STAT-CD                                   
MFA-TR*                ,:DD-TIER-ACCT-TYPE-CD                                   
MFA-TR*                ,:DD-MKT-TIER-RANKING                                    
MFA-TR*                ,:DD-MKT-TIER-START-DT                                   
MFA-TR*                ,:DD-COMPANY-NO                                          
MFA-TR*                , CURRENT TIMESTAMP                                      
MFA-TR*                ,:DD-LAST-UPDATE-USERID                                  
MFA-TR*                ,:DD-EFF-START-DT                                        
MFA-TR*                , CURRENT TIMESTAMP                                      
MFA-TR*                ,:DD-LAST-EVALUATED-DT                                   
MFA-TR*                ,:DD-TIER-SOURCE-CD                                      
MFA-TR*                ,:DD-ADJ-TIER-SEQ-NO)                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO  WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1                          TO WS-INSERT-REC-CNTR      
           ELSE                                                         
              DISPLAY '********** PCSCA280 ABORT **************'        
              DISPLAY '*     8100-INSERT-CIS-DATA             *'        
              DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '* ACCOUNT_NO        : ' DD-ACCOUNT-NO            
              DISPLAY '* TIER_CUST_STAT_CD : ' DD-TIER-CUST-STAT-CD     
              DISPLAY '* TIER_ACCT_TYPE_CD : ' DD-TIER-ACCT-TYPE-CD     
              DISPLAY '* MKT_TIER_RANKING  : ' DD-MKT-TIER-RANKING      
              DISPLAY '* MKT_TIER_START_DT : ' DD-MKT-TIER-START-DT     
              DISPLAY '* COMPANY_NO        : ' DD-COMPANY-NO            
              DISPLAY '* EFF_START_DT      : ' DD-EFF-START-DT          
              DISPLAY '* LAST_EVALUATED_DT : ' DD-LAST-EVALUATED-DT     
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA280 ABORT **************'        
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF                                                       
           .                                                            
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 55351103
      * 8200-UPDATE-AGL-STATUS                                        * 55353009
      * UPDATE TO ACTIVE STATUS                                       * 55352003
      ***************************************************************** 55354003
       8200-UPDATE-AGL-STATUS.                                          
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCT_ATTRIBUTE                                
                  SET STATUS_CD = 'A'                                   
                WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                   
                  AND ATTRIBUTE_DESC = 'AGL DISCOUNT SR'                
                  AND STATUS_CD      = 'P'                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA280 ABORT **************'        
              DISPLAY '*      8200-UPDATE-AGL-STATUS          *'        
              DISPLAY '* ACCOUNT NO      : ' AT-ACCOUNT-NO              
              DISPLAY '* SQLCODE         : ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA280 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 55351103
      *                                                               * 55352003
      * 8550-UPDATE-MOVE-DATE.                                        * 55353009
      ***************************************************************** 55354003
       8550-UPDATE-MOVE-DATE.                                           
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_UTIL_ENVRNMT                                  
                  SET GAS_BASE_LAST_UPDT = IIF(TRY_CONVERT(DATE, 
                                                 :UT-GAS-BASE-LAST-UPDT
              ) IS NULL OR (PATINDEX('%.%', :UT-GAS-BASE-LAST-UPDT
              ) <> 0) OR (LEN(:UT-GAS-BASE-LAST-UPDT
              ) <> 10), CIS.CHAR2DATE(:UT-GAS-BASE-LAST-UPDT
              ), CONVERT(DATE, :UT-GAS-BASE-LAST-UPDT) )       
                WHERE ACCOUNT_NO         = :UT-ACCOUNT-NO               
                  AND CODE_UTIL_TYPE     = 'G'                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     55357003
MFA-TR*        UPDATE CSS_UTIL_ENVRNMT                                  55358003
MFA-TR*           SET GAS_BASE_LAST_UPDT = :UT-GAS-BASE-LAST-UPDT               
MFA-TR*         WHERE ACCOUNT_NO         = :UT-ACCOUNT-NO               55359457
MFA-TR*           AND CODE_UTIL_TYPE     = 'G'                          55359557
MFA-TR*    END-EXEC.                                                    55359638

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA280 ABORT **************'        
              DISPLAY '*       8550-UPDATE-MOVE-DATE          *'        
              DISPLAY '* ACCOUNT NO      : ' UT-ACCOUNT-NO              
              DISPLAY '* GAS BASE UPD DT : ' UT-GAS-BASE-LAST-UPDT      
              DISPLAY '* SQLCODE         : ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA280 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8550-EXIT.                                                       
           EXIT.                                                        
      *                                                                 55363000
      ******************************************************************        
      *                                                                *        
      * 8889-COMMIT.                                                   *        
      ******************************************************************        
       8889-COMMIT.                                                     
      *                                                                         
              EXEC SQL                                                          
                  INCLUDE CPD00047                                              
              END-EXEC.                                                         
                                                                        
              ADD +1                           TO WS-CHKP-NO            
              DISPLAY 'COMMIT POINT # ' WS-CHKP-NO ' TAKEN.'            
           .                                                            
                                                                        
       8889-EXIT.                                                       
           EXIT.                                                        
      *                                                                 55450000
      ******************************************************************55451000
      *                                                                 55453000
      *8896-UPDATE-ACCOUNT-X.                                           55452000
      ******************************************************************55453100
       8896-UPDATE-ACCOUNT-X.                                           
      *                                                                 55450000
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET CODE_ACCT_BILLED = :AT-CODE-ACCT-BILLED            
                 WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '********** PCSCA280 ABORT **************'        
              DISPLAY '*  8896-UPDATE-ACCOUNT-X               *'        
              DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                    
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA280 ABORT **************'        
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 55460500
       8896-EXIT.                                                       
           EXIT.                                                        
      *                                                                 55460500
      ***************************************************************** 55460940
      *                                                               * 55461040
A04860* 8905-INSERT-WQ.                                               * 55461140
      ***************************************************************** 55461240
A04860 8905-INSERT-WQ.                                                  
                                                                        
A04860     CALL SCSCB077  USING   CWS00077-FIELDS,                      
A04860                            ABEND-FILE,                           
A04860                            RS-RETURN-CODE.                       
A04860*                                                                         
A04860     MOVE RS-RETURN-CODE              TO WS-ACTIVE-RETURN-CODE.   
A04860                                                                  
A04860     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
A04860        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
A04860        DISPLAY '8905-INSERT-WQ'                                  
A04860        DISPLAY 'CALL SCSCB077         '                          
A04860        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
A04860        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
A04860        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
A04860        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A04860        PERFORM 9900-ABEND    THRU 9900-EXIT                      
A04860     ELSE                                                         
A04860        MOVE WS-77-WQ-ITEM-ID         TO WS-ITEM-ID               
A04860     END-IF.                                                      
                                                                        
       8905-EXIT.                                                       
           EXIT.                                                        
P805AP*****************************************************************         
P805AP* 8906-UPDATE-ACCOUNT-ATTRIBUTE.                                *         
P805AP*****************************************************************         
P805AP 8906-UPDATE-ACCOUNT-ATTRIBUTE.                                   
P805AP                                                                  
P805AP     EXEC SQL                                                     
P805AP        UPDATE CSS_ACCT_ATTRIBUTE                                 
P805AP           SET STATUS_CD          = :YP-STATUS-CD                 
P805AP              ,ATTRIBUTE_VALUE_CD = :YP-ATTRIBUTE-VALUE-CD        
P805AP         WHERE ACCOUNT_NO         = :YP-ACCOUNT-NO                
P805AP           AND ATTRIBUTE_DESC     = :YP-ATTRIBUTE-DESC            
P805AP           AND STATUS_CD          = 'A'                           
P805AP     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P805AP                                                                  
P805AP     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P805AP                                                                  
P805AP     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P805AP        NEXT SENTENCE                                             
P805AP     ELSE                                                         
P805AP        DISPLAY '********** PCSCA280 ABORT **************'        
P805AP        DISPLAY '*  8906-UPDATE-ACCOUNT-ATTRIBUTE       *'        
P805AP        DISPLAY '* ACCOUNT NO     ', YP-ACCOUNT-NO                
P805AP        DISPLAY '*  ATTRIBUTE_DESC', YP-ATTRIBUTE-DESC            
P805AP        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
P805AP        DISPLAY '* PROGRAM ABORTING...                  *'        
P805AP        DISPLAY '********** PCSCA280 ABORT **************'        
P805AP        PERFORM 9900-ABEND              THRU 9900-EXIT            
P805AP     END-IF.                                                      
P805AP                                                                  
P805AP 8906-EXIT.                                                       
P805AP     EXIT.                                                        
P805AP                                                                  
P805AP*****************************************************************         
P805AP* 8907-ADV-PRICE-TRAN-DET-EXPIRE.                               *         
P805AP*****************************************************************         
P805AP 8907-ADV-PRICE-TRAN-DET-EXPIRE.                                  
P805AP                                                                  
P805AP** DATA FOR CSS_MNT_TRANS_HIST                                    17730000
P805AP     INITIALIZE                         DCLCSS-MNT-TRANS-HIST.    
P805AP     PERFORM 7050-SELECT-TIMESTAMP THRU 7050-EXIT                 
P805AP     MOVE WS-CURRENT-TIMESTAMP      TO MH-TRANS-HIST-SEQ-NO       
P805AP     MOVE WS-CURRENT-DATE           TO MH-DATE-TRANS              
P805AP     MOVE 'F'                       TO MH-CODE-TRAN-TYPE          
P805AP     MOVE SPACES                    TO MH-RESP-AREA-ID            
P805AP     MOVE AT-ACCOUNT-NO             TO MH-ACCOUNT-NO              
P805AP     MOVE +0                        TO MH-CUSTOMER-NO             
P805AP     MOVE +0                        TO MH-PREMISE-NO              
P805AP     MOVE 'SYSTEM'                  TO MH-USER-ID                 
P805AP     MOVE 'ADVANCED PRICING OPTION EXPIRED' TO                    
P805AP                                       MH-TRAN-COMMENT-TEXT.      
P805AP     MOVE LENGTH OF MH-TRAN-COMMENT-TEXT TO                       
P805AP                                       MH-TRAN-COMMENT-LEN.       
P805AP     MOVE 'PCSCA280'                TO MH-APPL-PROGRAM-ID         
P805AP     MOVE +0                        TO MH-ENTITY-KEY-DESC-LEN     
P805AP     MOVE SPACES                    TO MH-ENTITY-KEY-DESC-TEXT    
P805AP                                                                  
P805AP** DATA FOR CSS_MT_TRN_HST_DET                                    17730000
P805AP     INITIALIZE                         DCLCSS-MT-TRN-HST-DET.    
P805AP     MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO.      
P805AP     MOVE 1                         TO MI-TRAN-APPL-NO.           
P805AP     MOVE 'STATUS CD      '         TO MI-COLUMN-DESC.            
P805AP     MOVE SPACES                    TO MI-TABLE-ID.               
P805AP     MOVE 'ACTIVE'                  TO MI-PRV-COLUMN-VALUE-TEXT.  
P805AP     MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
P805AP                                    TO MI-PRV-COLUMN-VALUE-LEN.   
P805AP     MOVE 'INACTIVE'                TO MI-CHG-COLUMN-VALUE-TEXT.  
P805AP     MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
P805AP                                        TO MI-CHG-COLUMN-VALUE-LEN
P805AP     PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT.        
P805AP                                                                  
P805AP 8907-EXIT.                                                       
P805AP     EXIT.                                                        
P805AP                                                                  
I00113*                                                                         
I00113**************************************************************            
I00113* 9000-SEND-ERROR-RESULT. REQUIRED BY THE COPYBOOK                        
I00113**************************************************************            
I00113 9000-SEND-ERROR-RESULT.                                          
I00113                                                                  
I00113     GO TO 9000-EXIT.                                             
I00113*                                                                         
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9000-TERMINATE.                                                *        
      ******************************************************************        
       9000-TERMINATE.                                                  
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  55700000
      * 9900-SQL-ERROR-ROUTINE. REQUIRED BY THE COPYBOOK             *  55710000
      ****************************************************************  55720000
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                 55740000
           DISPLAY '**************************************'.            
           DISPLAY '**  PROCESSING ERROR'.                              
           DISPLAY '**  PROGRAM    = ' ABEND-PROGRAM.                   
                                                                        
           IF  WS-DB2-PARAGRAPH > SPACES                                
               DISPLAY '**  PARAGRAPH  = ' WS-DB2-PARAGRAPH
           END-IF.            
                                                                        
           IF  WS-DB2-FUNCTION > SPACES                                 
               DISPLAY '**  FUNCTION   = ' WS-DB2-FUNCTION
           END-IF.             
                                                                        
           IF  ACTIVE-PARAGRAPH > SPACES                                
               DISPLAY '**  PARAGRAPH  = ' ACTIVE-PARAGRAPH
           END-IF.            
                                                                        
           IF  ABEND-FUNCTION > SPACES                                  
               DISPLAY '**  FUNCTION   = ' ABEND-FUNCTION
           END-IF.              
                                                                        
           IF  TABLE-1 > SPACES                                         
               DISPLAY '**  TABLE/FILE = ' TABLE-1
           END-IF.                     
                                                                        
           IF HOSTVAR-ELEMENT-1 > SPACES                                
               DISPLAY '**  ' HOSTVAR-ELEMENT-1
           END-IF.                        
                                                                        
           IF HOSTVAR-ELEMENT-2 > SPACES                                
               DISPLAY '**  ' HOSTVAR-ELEMENT-2
           END-IF.                        
                                                                        
           IF HOSTVAR-ELEMENT-3 > SPACES                                
               DISPLAY '**  ' HOSTVAR-ELEMENT-3
           END-IF.                        
                                                                        
           DISPLAY '**************************************'.            
      *                                                                 56040000
      ******************************************************************        
      *  9900-ABEND.                                                   *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
