       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA276.                                        
       AUTHOR.         PRIYA.                                           
       DATE-WRITTEN.   AUG 2007.                                        
      ******************************************************************00050000
      ******************************************************************00080000
      *                                                               **00090000
      *              PROGRAM  MODIFICATION  LOG                       **00100000
      *    DATE    INITIALS     REASON                                **00110000
      *    ----    --------     ------                                **00120000
PECS12* 06/09/09   VD41351      Added new eventID's and corresponding **00120000
PECS12*                         comm-type and comm-subtypes for WEBSST**00120000
PECS12* 06/29/09   VD41351      Added Event ID description for WEBSST **        
PECS12*                         events While populating comments-text.**        
PRJ526* 10/14/09   cb18344      Added Event ID description for recur- **        
PRJ526*                         ring credit card project.             **        
A02477* 21/05/10   SB93596      HANDLING OF -803 ABEND,ADDING QUERYNO **        
      ******************************************************************00270000
      *                                                                *00280003
      *      PURPOSE.                                                  *00290003
      *      THIS PROGRAM DOES INSERTIONS FOR COMMUNICATION RECORDS    *00300003
      *      INTO COMM_DATA TABLE FROM BATCH EMAIL TBL.                *00310003
      *                                                                *00320003
      ***************************************************************** 00330000
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4381.                                    
       OBJECT-COMPUTER.    IBM-4381.                                    
       INPUT-OUTPUT SECTION.                                            
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA276'.
MSQ017     COPY MFASQLM.
       01  WS-START                        PIC X(45)                    
           VALUE 'WORKING STORAGE FOR PCSCA276 STARTS HERE'.            
       01  WS-PROG-MISC.                                                
           05  WS-PGRMNAME                 PIC X(08) VALUE 'PCSCA276'.  
           05  WS-RED-FL-NULL-IND          PIC S9(4) COMP  VALUE 0.     
           05  WS-END-NULL-IND             PIC S9(4) COMP  VALUE 0.     
           05  WS-NAME                     PIC X(76).                   
           05  WS-UPD-CNTR                 PIC 9(04) VALUE 0.           
A02477     05  WS-803-CTR                  PIC 9(01) VALUE 0.           
A02477     05  WS-INSERTED                 PIC X(01) VALUE ' '.         
A02477        88 INSERTED                     VALUE    'Y'.             
A02477        88 NOT-INSERTED                 VALUE    'N'.             
A02477     05  WS-803                      PIC S9(9) VALUE -803 COMP.   
           05  WS-COMMIT-CNT               PIC 9(04) VALUE 0.           
           05  WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(04) VALUE 4.           
           05  WS-CHKP-LUW-LIMIT           PIC 9(04) VALUE ZERO.        
           05  WS-DEFAULT-CHKP-UPD-LIMIT   PIC 9(04) VALUE 20.          
           05  WS-CHKP-UPD-LIMIT           PIC 9(04) VALUE ZERO.        
PECS12     05  WS-EVENT-DESC-TEXT          PIC X(42) VALUE SPACES.      
           05  WS-INITIAL-TEXT             PIC X(100) VALUE SPACES.     
PECS12     05  WS-INITIAL-COMMENT-TEXT     PIC X(250) VALUE SPACES.     
           05  WS-INITIAL-TEXT-S.                                       
               10 WS-INITIAL-TEXT-1        PIC X(16) VALUE              
                                           'ECS Batch email '.          
               10 WS-EVENT-CD-S            PIC X(05) VALUE SPACES.      
PECS12         10 WS-EVENT-DESC-S          PIC X(42) VALUE SPACES.      
               10 WS-INITIAL-TEXT-2        PIC X(09) VALUE              
                                           ' sent on '.                 
               10 WS-PROCESSED-DT-S        PIC X(10) VALUE SPACES.      
PECS12         10 WS-INITIAL-TEXT-3        PIC X(05) VALUE              
PECS12                                     ' to #'.                     
PECS12     05  WS-EMAIL-ADDR-S             PIC X(107) VALUE SPACES.     
           05  WS-INITIAL-TEXT-R.                                       
               10 WS-INITIAL-TEXT-1R       PIC X(23) VALUE              
                                'RESEND ECS batch email '.              
               10 WS-EVENT-CD-R            PIC X(05) VALUE SPACES.      
PECS12         10 WS-EVENT-DESC-R          PIC X(42) VALUE SPACES.      
               10 WS-INITIAL-TEXT-2R       PIC X(09) VALUE              
                                           ' sent on '.                 
               10 WS-PROCESSED-DT-R        PIC X(10) VALUE SPACES.      
PECS12         10 WS-INITIAL-TEXT-3R       PIC X(05) VALUE              
PECS12                                     ' to #'.                     
PECS12     05  WS-EMAIL-ADDR-R             PIC X(100) VALUE SPACES.     
           05  WS-FROM.                                                 
               10  WS-FROM-X               OCCURS 51 TIMES PIC X.       
                                                                        
       01  WS-SUB                          PIC S9(8) COMP VALUE ZERO.   
      *                                                                 01650000
       01  WS-LITERALS.                                                 
           05  WS-N                        PIC X(01) VALUE 'N'.         
           05  WS-Y                        PIC X(01) VALUE 'Y'.         
       01  CN-CONSTANTS.                                                
           05  CN-DELIMITER                 PIC X VALUE ';'.            
HPCCDM*EJECT                                                            01940000
                                                                        
      ******* WS FOR DB2 & CICS ERROR PROCESSING ****************       02020000
       COPY CWS00303.                                                   02030000
                                                                        
      ******* WS-ABEND WORK AREA  ****************                      02050000
       COPY CWS00010.                                                   02060000
                                                                        
      ******* CWS00038 IS JC01 WORK DATA                                        
       COPY CWS00038.                                                           
                                                                        
      ******* WS-FCA00-MISC       ****************                      02080000
       COPY CWS00039.                                                   02090000
                                                                        
      ******* WS-ABEND-SWITCH     ****************                      02110000
       COPY CWS09900.                                                   02120000
                                                                        
      ******* FIOJC01 WORKING STORAGE ************                      02140000
       COPY FIOJC01.                                                    02150000
                                                                        
      ******* FCA00-KEY           ****************                      02170000
       COPY FIOCA00.                                                    02180000
                                                                        
      **************************************************************            
      *    WS FOR 6010-REDUCE-EMBEDDED SPACES                                   
      **************************************************************            
PECS12 COPY CWS00011.                                                           
                                                                        
      ******* TABLE DECLARATION FOR SQLCA ****************************  02190000
           EXEC SQL                                                     02200000
                INCLUDE SQLCA                                           02210000
           END-EXEC.                                                    02220000
                                                                        
      ******* TABLE DECLARATION FOR CSS_BATCH_EMAIL ******************  02240003
                                                                        
           EXEC SQL                                                     02260000
                INCLUDE TBBEMAIL                                        02270003
           END-EXEC.                                                    02280000
      *                                                                 02290000
      ******* TABLE DECLARATION FOR CSS_CUST_EMAIL ******************   02290100
                                                                        
           EXEC SQL                                                     02290300
                INCLUDE TBCSTEML                                        02290400
           END-EXEC.                                                    02290500
      *                                                                 02290600
      ******* TABLE DECLARATION FOR CSS_CUSTOMER   *******************  02360000
                                                                        
           EXEC SQL                                                     02380000
               INCLUDE TBCUST                                           02390000
           END-EXEC.                                                    02400000
      *                                                                 02410000
      ******* TABLE DECLARATION FOR CSS_COMM_DATA     ****************  02530000
      *                                                                 02540000
           EXEC SQL                                                     02550000
              INCLUDE TBCOMDAT                                          02560000
           END-EXEC.                                                    02570000
      *                                                                 02580000
      ******* TABLE DECLARATION FOR CSS_NAME          ****************  02760000
      *                                                                 02770000
           EXEC SQL                                                     02780000
               INCLUDE TBNAME                                           02790000
           END-EXEC.                                                    02800000
      *                                                                 03480003
      ******* TABLE DECLARATION FOR CSS_JOB_PARM      ******************01550000
      *                                                                 01560000
           EXEC SQL                                                     01570000
               INCLUDE TBJBPARM                                         01580000
           END-EXEC.                                                    01590000
                                                                        
      ******* CURSOR DECLARATION FOR CSS_BATCH_EMAIL                    03530001
           EXEC SQL                                                     
              DECLARE BATCH_EMAIL CURSOR WITH HOLD FOR                  
              SELECT  BATCH_EMAIL_ID                                    
                     ,ACCOUNT_NO                                        
                     ,CUSTOMER_NO                                       
                     ,COMPANY_NO                                        
                     ,EMAIL_EVENT_CD                                    
                     ,PROCESSED_CD                                      
                     ,PROCESSED_DT                                      
                     ,COMM_DATA_CD                                      
               FROM CSS_BATCH_EMAIL AE                                  
              WHERE COMM_DATA_CD =  'N'                                 
                AND PROCESSED_CD IN ('R','S')                           
              FOR UPDATE OF COMM_DATA_CD                                
A02477                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     03540000
MFA-TR*       DECLARE BATCH_EMAIL CURSOR WITH HOLD FOR                  03550003
MFA-TR*       SELECT  BATCH_EMAIL_ID                                    03560002
MFA-TR*              ,ACCOUNT_NO                                        03570002
MFA-TR*              ,CUSTOMER_NO                                       03580002
MFA-TR*              ,COMPANY_NO                                        03590002
MFA-TR*              ,EMAIL_EVENT_CD                                    03590003
MFA-TR*              ,PROCESSED_CD                                      03590004
MFA-TR*              ,PROCESSED_DT                                      03590005
MFA-TR*              ,COMM_DATA_CD                                      03620011
MFA-TR*        FROM CSS_BATCH_EMAIL AE                                  03610002
MFA-TR*       WHERE COMM_DATA_CD =  'N'                                 03620011
MFA-TR*         AND PROCESSED_CD IN ('R','S')                           03620011
MFA-TR*       FOR UPDATE OF COMM_DATA_CD                                03640001
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                    03650000
      **                                                                03660000
       01  WS-END                       PIC X(40)                       
           VALUE 'WORKING STORAGE FOR PCSCA276 ENDS HERE  '.            
HPCCDM*    EJECT                                                        03690000
                                                                        
       PROCEDURE DIVISION.                                              
      ******************************************************************03750000
      *                                                                *03760000
      *   0000-MAINLINE.                                               *03770000
      *        CONTROLS THE MAIN PROCESS OF PROGRAM                    *03780000
      *                                                                *03790000
      ******************************************************************03800000
       0000-MAINLINE.                                                   
      *                                                                 03820000
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
           PERFORM 1000-MAIN-PROCESS-PARA      THRU 1000-EXIT.          
      *                                                                 04070000
           DISPLAY 'PCSCA276 COMPLETED SUCCESSFULLY.'.                  
      *                                                                 04070000
           STOP RUN.                                                    
      *                                                                 04070000
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04130000
      *                                                                *04140000
      *   0100-INITIALIZATION                                          *04150000
      *        COMMON INITIALIZATION ROUTINE                           *04160000
      *                                                                *04170000
      ***************************************************************** 04180000
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           INITIALIZE WS-SYSIPT                                         
              PERFORM 6253-GET-FJC01-CHKP-LIMIT  THRU 6253-EXIT.        
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05320000
      * 1000-MAIN-PROCESS-PARA                                         *05360000
      * OPEN, FETCH, PROCESS THE RECORDS AND CLOSE THE BATCH EMAIL CSR.*05340000
      ******************************************************************05350000
       1000-MAIN-PROCESS-PARA.                                          
           PERFORM 7000-OPEN-BATCH-EMAIL-CSR    THRU 7000-EXIT          
           PERFORM 7010-FETCH-BATCH-EMAIL-CSR   THRU 7010-EXIT          
           PERFORM 2100-PROCESS-BATCH-EMAIL     THRU 2100-EXIT          
                     UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.           
           PERFORM 7050-CLOSE-BATCH-EMAIL-CSR   THRU 7050-EXIT.         
       1000-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************06110000
      *       2100-PROCESS-BATCH-EMAIL.                                *06130003
      ******************************************************************06170000
       2100-PROCESS-BATCH-EMAIL.                                        
           INITIALIZE DCLCSS-NAME                                       
                      WS-NAME                                           
                      WS-INITIAL-TEXT                                   
PECS12                WS-EVENT-DESC-TEXT                                
PECS12                WS-INITIAL-COMMENT-TEXT                           
PECS12                WS-EMB-INPUT                                      
                      WS-EMAIL-ADDR-S                                   
                      WS-EMAIL-ADDR-R.                                  
             PERFORM 7200-SELECT-EMAIL-ADDR     THRU 7200-EXIT.         
             PERFORM 2300-PROCESS-INSERT-COMM   THRU 2300-EXIT.         
             PERFORM 7010-FETCH-BATCH-EMAIL-CSR THRU 7010-EXIT.         
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06110000
      *       2300-PROCESS-INSERT-COMM.                                *06130003
      *  PROCESSES BATCH EMAIL RECORD TO INSERT INTO COMMUNICATION DATA*06150000
      *  TABLE.                                                        *06150000
      ******************************************************************06170000
       2300-PROCESS-INSERT-COMM.                                        
           PERFORM 7300-GET-NAME-PARA         THRU 7300-EXIT.           
           PERFORM 2500-CHK-NAME-PARA         THRU 2500-EXIT.           
           PERFORM 2600-GET-COMM-CD-PARA      THRU 2600-EXIT.           
           PERFORM 5000-MOVE-CUST-COMM-PARA   THRU 5000-EXIT.           
A02477     MOVE ZEROS TO WS-803-CTR.                                    
A02477     INITIALIZE WS-INSERTED.                                      
A02477     PERFORM 8400-INSERT-CUST-COMM-DATA THRU 8400-EXIT            
A02477       UNTIL INSERTED.                                            
           PERFORM 8500-UPDATE-BATCH-EMAIL-TB THRU 8500-EXIT.           
           IF WS-UPD-CNTR >= WS-CHKP-UPD-LIMIT                          
              PERFORM 8888-COMMIT             THRU 8888-EXIT            
              DISPLAY 'BATCH-EMAIL ID: '  AE-BATCH-EMAIL-ID             
              DISPLAY 'COMMIT POINT #  '  WS-COMMIT-CNT  ' TAKEN.'      
              MOVE ZEROES                     TO WS-UPD-CNTR            
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                            06449217
                                                                        
      ******************************************************************06449317
      *       2500-CHK-NAME-PARA.                                      *06449517
      ******************************************************************06449917
       2500-CHK-NAME-PARA.                                              
                                                                        
           IF DQ-NAME-FORMAT = 'I'                                      
               MOVE DQ-LAST-NAME TO WS-FROM                             
               PERFORM 2510-PROCESS-FROM-STRING                         
               MOVE WS-FROM TO DQ-LAST-NAME                             
                                                                        
               MOVE DQ-FIRST-NAME TO WS-FROM                            
               PERFORM 2510-PROCESS-FROM-STRING                         
               MOVE WS-FROM TO DQ-FIRST-NAME                            
                                                                        
               IF DQ-MIDDLE-NAME NOT = SPACE                            
                   MOVE DQ-MIDDLE-NAME TO WS-FROM                       
                   PERFORM 2510-PROCESS-FROM-STRING                     
                   MOVE WS-FROM TO DQ-MIDDLE-NAME                       
               END-IF                                                   
                                                                        
               MOVE DQ-TITLE-SUFFIX-1 TO WS-FROM                        
               PERFORM 2510-PROCESS-FROM-STRING                         
               MOVE WS-FROM TO DQ-TITLE-SUFFIX-1                        
                                                                        
               IF DQ-MIDDLE-NAME = SPACE                                
                   STRING DQ-LAST-NAME DELIMITED CN-DELIMITER           
                          ', ' DELIMITED SIZE                           
                          DQ-FIRST-NAME DELIMITED CN-DELIMITER          
                          ' ' DELIMITED SIZE                            
                          DQ-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER      
                     INTO WS-NAME                                       
                   END-STRING                                           
               ELSE                                                     
                   STRING DQ-LAST-NAME DELIMITED CN-DELIMITER           
                          ', ' DELIMITED SIZE                           
                          DQ-FIRST-NAME DELIMITED CN-DELIMITER          
                          ' ' DELIMITED SIZE                            
                          DQ-MIDDLE-NAME DELIMITED CN-DELIMITER         
                          ' ' DELIMITED SIZE                            
                          DQ-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER      
                     INTO WS-NAME                                       
                   END-STRING                                           
               END-IF                                                   
           ELSE                                                         
               MOVE DQ-FULL-NAME     TO WS-NAME                         
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06920007
      * 2510-PROCESS-FROM-STRING                                       *06930007
      * DETERMINE LENGTH OF FIELD. PLACE DELIMITER AFTER THE LAST      *06940007
      * NON-SPACE CHARACTER TO BE USED LATER IN STRING STATEMENT.      *06950007
      ******************************************************************06960007
                                                                        
       2510-PROCESS-FROM-STRING.                                        
                                                                        
           PERFORM                                                      
               VARYING WS-SUB FROM 51 BY -1                             
                 UNTIL WS-SUB < 1                                       
                    OR WS-FROM-X (WS-SUB) NOT = SPACE                   
           END-PERFORM.                                                 
           ADD 1             TO WS-SUB.                                 
           MOVE CN-DELIMITER TO WS-FROM-X (WS-SUB).                     
                                                                        
       2510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06449317
      * 2600-GET-COMM-CD-PARA.                                         *06449517
      ******************************************************************06449917
       2600-GET-COMM-CD-PARA.                                           
                                                                        
            EVALUATE AE-EMAIL-EVENT-CD                                  
              WHEN 'ECS02'                                              
              WHEN 'ECS03'                                              
              WHEN 'ECS04'                                              
              WHEN 'ECS07'                                              
              WHEN 'ECS08'                                              
              WHEN 'ECS11'                                              
              WHEN 'ECS12'                                              
              WHEN 'ECS14'                                              
              WHEN 'ECS15'                                              
              WHEN 'ECS17'                                              
              WHEN 'ECS18'                                              
              WHEN 'ECS20'                                              
              WHEN 'ECS21'                                              
PRJ526        WHEN 'ECS27'                                              
PRJ526        WHEN 'ECS28'                                              
                 MOVE '06'          TO KO-COMM-TYPE-CD                  
                 MOVE '42'          TO KO-COMM-SUBTYPE-CODE             
              WHEN 'ECS05'                                              
                 MOVE '01'          TO KO-COMM-TYPE-CD                  
                 MOVE '20'          TO KO-COMM-SUBTYPE-CODE             
              WHEN 'ECS22'                                              
                 MOVE '40'          TO KO-COMM-TYPE-CD                  
                 MOVE '23'          TO KO-COMM-SUBTYPE-CODE             
              WHEN 'ECS16'                                              
                 MOVE '49'          TO KO-COMM-TYPE-CD                  
                 MOVE '05'          TO KO-COMM-SUBTYPE-CODE             
              WHEN 'ECS23'                                              
PECS12           MOVE ': Pay Deposit Reminder'                          
PECS12                              TO WS-EVENT-DESC-TEXT               
                 MOVE '41'          TO KO-COMM-TYPE-CD                  
                 MOVE '01'          TO KO-COMM-SUBTYPE-CODE             
              WHEN 'ECS24'                                              
PECS12           MOVE ': Start Service Reminder'                        
PECS12                              TO WS-EVENT-DESC-TEXT               
                 MOVE '41'          TO KO-COMM-TYPE-CD                  
                 MOVE '01'          TO KO-COMM-SUBTYPE-CODE             
              WHEN 'ECS25'                                              
PECS12           MOVE ': Unable to Complete Your Service Request'       
PECS12                              TO WS-EVENT-DESC-TEXT               
                 MOVE '41'          TO KO-COMM-TYPE-CD                  
                 MOVE '01'          TO KO-COMM-SUBTYPE-CODE             
              WHEN 'ECS26'                                              
PECS12           MOVE ': Stop Service Reminder'                         
PECS12                              TO WS-EVENT-DESC-TEXT               
                 MOVE '41'          TO KO-COMM-TYPE-CD                  
                 MOVE '01'          TO KO-COMM-SUBTYPE-CODE             
PRJ526        WHEN 'ECS29'                                              
PRJ526           MOVE '49'          TO KO-COMM-TYPE-CD                  
PRJ526           MOVE '14'          TO KO-COMM-SUBTYPE-CODE             
              WHEN OTHER                                                
                 MOVE '06'          TO KO-COMM-TYPE-CD                  
                 MOVE '42'          TO KO-COMM-SUBTYPE-CODE             
            END-EVALUATE.                                               
                                                                        
       2600-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************06920007
      * 5000-MOVE-CUST-COMM-PARA.                                   *   06930007
      ******************************************************************06960007
                                                                        
       5000-MOVE-CUST-COMM-PARA.                                        
                                                                        
           MOVE AE-ACCOUNT-NO            TO KO-ACCOUNT-NO.              
           MOVE AE-CUSTOMER-NO           TO KO-CUSTOMER-NO.             
           MOVE ZEROS                    TO KO-PREMISE-NO.              
           MOVE AE-COMPANY-NO            TO KO-COMPANY-NO.              
           MOVE SPACES                   TO KO-RED-FLAG-IND.            
           MOVE SPACES                   TO KO-RED-FLAG-EXPIRE-DT.      
           MOVE -1                       TO WS-RED-FL-NULL-IND.         
           MOVE 'E'                      TO KO-COMM-METHOD.             
           MOVE 'O'                      TO KO-COMM-DIRECTION.          
           MOVE SPACES                   TO KO-PROMOTION-ID.            
           MOVE SPACES                   TO KO-PSC-COMPLIANCE-IND.      
           MOVE 'ECSPRD1'                TO KO-USER-ID-ORIG.            
           MOVE 0                        TO KO-CALL-ORIGIN-ID.          
           MOVE SPACES                   TO KO-CALL-END-TIME.           
           MOVE -1                       TO WS-END-NULL-IND.            
           MOVE 0                        TO KO-NUMBER-TRANSFERS.        
           MOVE 0                        TO KO-HOLD-TIME.               
           MOVE 0                        TO KO-QUEUE-TIME.              
           MOVE WS-N                     TO KO-SCREEN-POP-IND.          
           MOVE 0                        TO KO-TOTAL-CALL-TIME.         
           MOVE SPACES                   TO KO-RESPONSE-REASON-CD.      
           MOVE SPACES                   TO KO-RESPONSE-TYPE-CD.        
           MOVE SPACES                   TO KO-SOLICITATION-CD.         
           MOVE WS-N                     TO KO-COMPLAINT-FL.            
           MOVE SPACES                   TO KO-DISCOVERY-MTHD-CD.       
           MOVE SPACES                   TO KO-PREV-MARKETER-CD.        
           IF AE-ACCOUNT-NO > 0                                         
              MOVE 'A'                   TO KO-COMM-ASSOC-CD            
           ELSE                                                         
             IF AE-CUSTOMER-NO > 0                                      
                MOVE 'C'                 TO KO-COMM-ASSOC-CD            
             ELSE                                                       
                MOVE 'P'                 TO KO-COMM-ASSOC-CD            
             END-IF                                                     
           END-IF.                                                      
           IF AE-PROCESSED-CD = 'S'                                     
              MOVE AE-EMAIL-EVENT-CD     TO WS-EVENT-CD-S               
              MOVE AE-PROCESSED-DT       TO WS-PROCESSED-DT-S           
              MOVE WS-INITIAL-TEXT       TO WS-EMAIL-ADDR-S             
PECS12        MOVE WS-EVENT-DESC-TEXT    TO WS-EVENT-DESC-S             
PECS12        MOVE WS-INITIAL-TEXT-S     TO WS-EMB-INPUT                
PECS12        PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT        
PECS12        STRING WS-CMP-TABLE, WS-EMAIL-ADDR-S                      
PECS12               DELIMITED BY '#' INTO WS-INITIAL-COMMENT-TEXT      
              MOVE SPACES                TO WS-EMAIL-ADDR-S             
           ELSE                                                         
              MOVE AE-EMAIL-EVENT-CD     TO WS-EVENT-CD-R               
              MOVE AE-PROCESSED-DT       TO WS-PROCESSED-DT-R           
              MOVE WS-INITIAL-TEXT       TO WS-EMAIL-ADDR-R             
PECS12        MOVE WS-EVENT-DESC-TEXT    TO WS-EVENT-DESC-R             
PECS12        MOVE WS-INITIAL-TEXT-R     TO WS-EMB-INPUT                
PECS12        PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT        
PECS12        STRING WS-CMP-TABLE, WS-EMAIL-ADDR-R                      
PECS12               DELIMITED BY '#' INTO WS-INITIAL-COMMENT-TEXT      
              MOVE SPACES                TO WS-EMAIL-ADDR-R             
           END-IF.                                                      
                                                                        
PECS12     MOVE LENGTH OF WS-INITIAL-COMMENT-TEXT                       
PECS12                                   TO KO-INITIAL-COMMENT-TX-LEN.  
PECS12     MOVE WS-INITIAL-COMMENT-TEXT  TO KO-INITIAL-COMMENT-TX-TEXT. 
           MOVE WS-NAME                  TO KO-CONTACT-NAME.            
PECS12     MOVE SPACES                   TO WS-EVENT-DESC-TEXT          
PECS12                                      WS-EMB-INPUT                
PECS12                                      WS-INITIAL-COMMENT-TEXT.    
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05220000
      ****************************************************************  05160000
      **  6253-GET-FJC01-CHKP-LIMIT.                                 *  05170000
      ****************************************************************  05180000
            EXEC SQL                                                    05190000
                INCLUDE CPD00034                                        05200000
            END-EXEC.                                                   05210000
      *                                                                 05220000
      ***************************************************************** 07890000
      * 7000-OPEN-BATCH-EMAIL-CSR                                      *08380003
      *  OPENS THE BATCH EMAIL CURSOR.                                 *08390000
      ******************************************************************08410000
       7000-OPEN-BATCH-EMAIL-CSR.                                       
      *                                                                 08430000
           EXEC SQL                                                     
               OPEN BATCH_EMAIL                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7000-OPEN-BATCH-EMAIL-CSR'                      
                       ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY 'BATCH EMAIL ID : ' AE-BATCH-EMAIL-ID            
               DISPLAY 'ACCOUNT NO     : ' AE-ACCOUNT-NO                
               DISPLAY 'EVENT MAIL DT  : ' AE-EMAIL-EVENT-DT            
               DISPLAY 'EVENT MAIL CODE: ' AE-EMAIL-EVENT-CD            
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 08690000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08720000
      ******************************************************************08730000
      *                                                                *08740000
      *   7010-FETCH-BATCH-EMAIL-CSR.                                  *08750000
      *        FETCHES THE RECORD FROM THE BATCH_EMAIL CURSOR.         *08760000
      *                                                                *08770000
      ******************************************************************08780000
       7010-FETCH-BATCH-EMAIL-CSR.                                      
                                                                        
           EXEC SQL                                                     
               FETCH BATCH_EMAIL                                        
               INTO :AE-BATCH-EMAIL-ID                                  
                   ,:AE-ACCOUNT-NO                                      
                   ,:AE-CUSTOMER-NO                                     
                   ,:AE-COMPANY-NO                                      
                   ,:AE-EMAIL-EVENT-CD                                  
                   ,:AE-PROCESSED-CD                                    
                   ,:AE-PROCESSED-DT                                    
                   ,:AE-COMM-DATA-CD                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                  NEXT SENTENCE                                         
               ELSE                                                     
                 DISPLAY '7010-FETCH-BATCH-EMAIL-CSR'                   
                         ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
                 DISPLAY 'BATCH EMAIL ID : ' AE-BATCH-EMAIL-ID          
                 DISPLAY 'ACCOUNT NO     : ' AE-ACCOUNT-NO              
                 DISPLAY 'EVENT MAIL DT  : ' AE-EMAIL-EVENT-DT          
                 DISPLAY 'EVENT MAIL CODE: ' AE-EMAIL-EVENT-CD          
                 MOVE 12 TO RETURN-CODE                                 
                 STOP RUN                                               
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
               END-IF                                                   
           END-IF.                                                      
      *                                                                 09030000
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09060000
      ******************************************************************09070000
      *   7050-CLOSE-BATCH-EMAIL-CSR.                                 * 09080000
      *   CLOSES THE BATCH EMAIL CURSOR.                               *09090000
      ******************************************************************09100000
       7050-CLOSE-BATCH-EMAIL-CSR.                                      
                                                                        
           EXEC SQL                                                     
               CLOSE BATCH_EMAIL                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7050-CLOSE-BATCH-EMAIL-CSR'                     
                       ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY 'BATCH EMAIL ID : ' AE-BATCH-EMAIL-ID            
               DISPLAY 'ACCOUNT NO     : ' AE-ACCOUNT-NO                
               DISPLAY 'EVENT MAIL DT  : ' AE-EMAIL-EVENT-DT            
               DISPLAY 'EVENT MAIL CODE: ' AE-EMAIL-EVENT-CD            
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06920007
      * 7200-SELECT-EMAIL-ADDR.                                      *  06930007
      ******************************************************************06960007
                                                                        
       7200-SELECT-EMAIL-ADDR.                                          
                                                                        
           EXEC SQL                                                     
              SELECT NE.EMAIL_ADDRESS_TX                                
               INTO                                                     
                    :NE-EMAIL-ADDRESS-TX                                
               FROM CSS_CUST_EMAIL NE WITH(READUNCOMMITTED)                     
               WHERE                                                    
                  NE.CUSTOMER_NO = :AE-CUSTOMER-NO                      
                                                                 
A02477                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07100010
MFA-TR*       SELECT NE.EMAIL_ADDRESS_TX                                07100020
MFA-TR*        INTO                                                     07100300
MFA-TR*             :NE-EMAIL-ADDRESS-TX                                07100400
MFA-TR*        FROM CSS_CUST_EMAIL NE                                   07101400
MFA-TR*        WHERE                                                    07101600
MFA-TR*           NE.CUSTOMER_NO = :AE-CUSTOMER-NO                      07101700
MFA-TR*        WITH UR                                                  07101900
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                    07102000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE LENGTH OF NE-EMAIL-ADDRESS-TX-TEXT TO                
                             NE-EMAIL-ADDRESS-TX-LEN                    
              MOVE NE-EMAIL-ADDRESS-TX-TEXT TO WS-INITIAL-TEXT          
              MOVE SPACES                   TO NE-EMAIL-ADDRESS-TX-TEXT 
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE SPACES                TO WS-INITIAL-TEXT          
              ELSE                                                      
                 DISPLAY '*******************************************'  
                 DISPLAY 'PARA -7200 ,SELECT EMAIL-ADDRESS-TX  '        
                 DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE      
                 DISPLAY '** CUSTOMER NO '   AE-CUSTOMER-NO             
                 DISPLAY '** ACCOUNT NO  '   AE-ACCOUNT-NO              
                 DISPLAY 'TABLE NAME :       CSS_CUST_EMAIL'            
                 DISPLAY '** PROCESSING IS TERMINATED **'               
                 DISPLAY '*****************************************'    
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09860007
      * 7300-GET-NAME-PARA.                                            *09870007
      * GET CUSTOMER'S NAME.                                           *09880007
      ******************************************************************09890007
                                                                        
       7300-GET-NAME-PARA.                                              
                                                                        
           EXEC SQL                                                     
              SELECT CU.NAME_ID                                         
                    ,DQ.NAME_FORMAT                                     
                    ,DQ.FIRST_NAME                                      
                    ,DQ.MIDDLE_NAME                                     
                    ,DQ.LAST_NAME                                       
                    ,DQ.NAME_TYPE                                       
                    ,DQ.FULL_NAME                                       
                    ,DQ.TITLE_PREFIX                                    
                    ,DQ.TITLE_SUFFIX_1                                  
                    ,DQ.TITLE_SUFFIX_2                                  
               INTO                                                     
                     :CU-NAME-ID                                        
                    ,:DQ-NAME-FORMAT                                    
                    ,:DQ-FIRST-NAME                                     
                    ,:DQ-MIDDLE-NAME                                    
                    ,:DQ-LAST-NAME                                      
                    ,:DQ-NAME-TYPE                                      
                    ,:DQ-FULL-NAME                                      
                    ,:DQ-TITLE-PREFIX                                   
                    ,:DQ-TITLE-SUFFIX-1                                 
                    ,:DQ-TITLE-SUFFIX-2                                 
               FROM CSS_CUSTOMER CU WITH(READUNCOMMITTED)                       
                   ,CSS_NAME     DQ WITH(READUNCOMMITTED)                       
               WHERE                                                    
                  CU.CUSTOMER_NO = :AE-CUSTOMER-NO AND                  
                  DQ.NAME_ID     = CU.NAME_ID                           
                                                                 
A02477                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     09930007
MFA-TR*       SELECT CU.NAME_ID                                         09931007
MFA-TR*             ,DQ.NAME_FORMAT                                     09932007
MFA-TR*             ,DQ.FIRST_NAME                                      09932107
MFA-TR*             ,DQ.MIDDLE_NAME                                     09933007
MFA-TR*             ,DQ.LAST_NAME                                       09934007
MFA-TR*             ,DQ.NAME_TYPE                                       09935007
MFA-TR*             ,DQ.FULL_NAME                                       09936007
MFA-TR*             ,DQ.TITLE_PREFIX                                    09937007
MFA-TR*             ,DQ.TITLE_SUFFIX_1                                  09938007
MFA-TR*             ,DQ.TITLE_SUFFIX_2                                  09939007
MFA-TR*        INTO                                                     09939109
MFA-TR*              :CU-NAME-ID                                        09939212
MFA-TR*             ,:DQ-NAME-FORMAT                                    09939309
MFA-TR*             ,:DQ-FIRST-NAME                                     09939409
MFA-TR*             ,:DQ-MIDDLE-NAME                                    09939509
MFA-TR*             ,:DQ-LAST-NAME                                      09939609
MFA-TR*             ,:DQ-NAME-TYPE                                      09939709
MFA-TR*             ,:DQ-FULL-NAME                                      09939809
MFA-TR*             ,:DQ-TITLE-PREFIX                                   09939909
MFA-TR*             ,:DQ-TITLE-SUFFIX-1                                 09940009
MFA-TR*             ,:DQ-TITLE-SUFFIX-2                                 09940109
MFA-TR*        FROM CSS_CUSTOMER CU                                     09940207
MFA-TR*            ,CSS_NAME     DQ                                     09940307
MFA-TR*        WHERE                                                    09940407
MFA-TR*           CU.CUSTOMER_NO = :AE-CUSTOMER-NO AND                  09940507
MFA-TR*           DQ.NAME_ID     = CU.NAME_ID                           09941007
MFA-TR*        WITH UR                                                  09950007
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                    10150007

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
                 DISPLAY '*******************************************'  
                 DISPLAY 'PARA -7300 ,SELECT CSS_NAME          '        
                 DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE      
                 DISPLAY '** PROCESSING IS TERMINATED       **'         
                 DISPLAY '** ACCOUNT NO  ' AE-ACCOUNT-NO                
                 DISPLAY '** CUSTOMER NO ' AE-CUSTOMER-NO               
                 DISPLAY '** NAME ID     ' CU-NAME-ID                   
                 DISPLAY 'TABLE NAME : CSS_NAME  '                      
                 DISPLAY '*******************************************'  
                 PERFORM 9900-ABEND                THRU 9900-EXIT       
            END-IF.                                                     
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  05230000
      **  7600-START-FCSJC01                                            05170000
      **  *RETRIEVE PARM DETAILS FROM JOB PARM TABLE.                   05170000
      ****************************************************************  05180000
           EXEC SQL                                                     05240000
                INCLUDE CPD00038                                        05250000
           END-EXEC.                                                    05260000
                                                                        
      ******************************************************************13010000
      *   8400-INSERT-CUST-COMM-DATA.                                  *13030000
      ******************************************************************13040000
       8400-INSERT-CUST-COMM-DATA.                                      
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_COMM_DATA                               
                        (COMMUNICATION_ID,                              
                         ACCOUNT_NO,                                    
                         CUSTOMER_NO,                                   
                         PREMISE_NO,                                    
                         COMPANY_NO,                                    
                         RED_FLAG_IND,                                  
                         RED_FLAG_EXPIRE_DT,                            
                         COMM_METHOD,                                   
                         COMM_DIRECTION,                                
                         COMM_TYPE_CD,                                  
                         COMM_SUBTYPE_CODE,                             
                         USER_ID_ORIG,                                  
                         CONTACT_NAME,                                  
                         PROMOTION_ID,                                  
                         PSC_COMPLIANCE_IND,                            
                         CALL_ORIGIN_ID,                                
                         CALL_END_TIME,                                 
                         NUMBER_TRANSFERS,                              
                         HOLD_TIME,                                     
                         QUEUE_TIME,                                    
                         SCREEN_POP_IND,                                
                         TOTAL_CALL_TIME,                               
                         INITIAL_COMMENT_TX,                            
                         RESPONSE_REASON_CD,                            
                         RESPONSE_TYPE_CD,                              
                         SOLICITATION_CD,                               
                         COMM_ASSOC_CD,                                 
                         COMPLAINT_FL,                                  
                         DISCOVERY_MTHD_CD,                             
                         PREV_MARKETER_CD)                              
                VALUES   (CIS.CURRENT$TIMESTAMP(),                            
                         :KO-ACCOUNT-NO,                                
                         :KO-CUSTOMER-NO,                               
                         :KO-PREMISE-NO,                                
                         :KO-COMPANY-NO,                                
                         :KO-RED-FLAG-IND,                              
                         CIS.CHAR2TIMESTAMP(:KO-RED-FLAG-EXPIRE-DT 
                                            :WS-RED-FL-NULL-IND),     
                         :KO-COMM-METHOD,                               
                         :KO-COMM-DIRECTION,                            
                         :KO-COMM-TYPE-CD,                              
                         :KO-COMM-SUBTYPE-CODE,                         
                         :KO-USER-ID-ORIG,                              
                         :KO-CONTACT-NAME,                              
                         :KO-PROMOTION-ID,                              
                         :KO-PSC-COMPLIANCE-IND,                        
                         :KO-CALL-ORIGIN-ID,                            
                         CIS.CHAR2TIMESTAMP(:KO-CALL-END-TIME 
                                            :WS-END-NULL-IND),             
                         :KO-NUMBER-TRANSFERS,                          
                         :KO-HOLD-TIME,                                 
                         :KO-QUEUE-TIME,                                
                         :KO-SCREEN-POP-IND,                            
                         :KO-TOTAL-CALL-TIME,                           
                         :KO-INITIAL-COMMENT-TX,                        
                         :KO-RESPONSE-REASON-CD,                        
                         :KO-RESPONSE-TYPE-CD,                          
                         :KO-SOLICITATION-CD,                           
                         :KO-COMM-ASSOC-CD,                             
                         :KO-COMPLAINT-FL,                              
                         :KO-DISCOVERY-MTHD-CD,                         
                         :KO-PREV-MARKETER-CD)                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     13410000
MFA-TR*         INSERT INTO CSS_COMM_DATA                               13420000
MFA-TR*                 (COMMUNICATION_ID,                              13430000
MFA-TR*                  ACCOUNT_NO,                                    13440000
MFA-TR*                  CUSTOMER_NO,                                   13450000
MFA-TR*                  PREMISE_NO,                                    13460000
MFA-TR*                  COMPANY_NO,                                    13470000
MFA-TR*                  RED_FLAG_IND,                                  13480000
MFA-TR*                  RED_FLAG_EXPIRE_DT,                            13490000
MFA-TR*                  COMM_METHOD,                                   13500000
MFA-TR*                  COMM_DIRECTION,                                13510000
MFA-TR*                  COMM_TYPE_CD,                                  13520000
MFA-TR*                  COMM_SUBTYPE_CODE,                             13530000
MFA-TR*                  USER_ID_ORIG,                                  13540000
MFA-TR*                  CONTACT_NAME,                                  13550000
MFA-TR*                  PROMOTION_ID,                                  13560000
MFA-TR*                  PSC_COMPLIANCE_IND,                            13570000
MFA-TR*                  CALL_ORIGIN_ID,                                13580000
MFA-TR*                  CALL_END_TIME,                                 13590000
MFA-TR*                  NUMBER_TRANSFERS,                              13600000
MFA-TR*                  HOLD_TIME,                                     13610000
MFA-TR*                  QUEUE_TIME,                                    13620000
MFA-TR*                  SCREEN_POP_IND,                                13630000
MFA-TR*                  TOTAL_CALL_TIME,                               13640000
MFA-TR*                  INITIAL_COMMENT_TX,                            13650000
MFA-TR*                  RESPONSE_REASON_CD,                            13660000
MFA-TR*                  RESPONSE_TYPE_CD,                              13670000
MFA-TR*                  SOLICITATION_CD,                               13680000
MFA-TR*                  COMM_ASSOC_CD,                                 13690000
MFA-TR*                  COMPLAINT_FL,                                  13700000
MFA-TR*                  DISCOVERY_MTHD_CD,                             13710000
MFA-TR*                  PREV_MARKETER_CD)                              13720000
MFA-TR*         VALUES   (CURRENT TIMESTAMP,                            13730000
MFA-TR*                  :KO-ACCOUNT-NO,                                13740000
MFA-TR*                  :KO-CUSTOMER-NO,                               13750000
MFA-TR*                  :KO-PREMISE-NO,                                13760000
MFA-TR*                  :KO-COMPANY-NO,                                13770000
MFA-TR*                  :KO-RED-FLAG-IND,                              13780000
MFA-TR*                  :KO-RED-FLAG-EXPIRE-DT:WS-RED-FL-NULL-IND,     13790000
MFA-TR*                  :KO-COMM-METHOD,                               13800000
MFA-TR*                  :KO-COMM-DIRECTION,                            13810000
MFA-TR*                  :KO-COMM-TYPE-CD,                              13820000
MFA-TR*                  :KO-COMM-SUBTYPE-CODE,                         13830000
MFA-TR*                  :KO-USER-ID-ORIG,                              13840000
MFA-TR*                  :KO-CONTACT-NAME,                              13850000
MFA-TR*                  :KO-PROMOTION-ID,                              13860000
MFA-TR*                  :KO-PSC-COMPLIANCE-IND,                        13870000
MFA-TR*                  :KO-CALL-ORIGIN-ID,                            13880000
MFA-TR*                  :KO-CALL-END-TIME:WS-END-NULL-IND,             13890000
MFA-TR*                  :KO-NUMBER-TRANSFERS,                          13900000
MFA-TR*                  :KO-HOLD-TIME,                                 13910000
MFA-TR*                  :KO-QUEUE-TIME,                                13920000
MFA-TR*                  :KO-SCREEN-POP-IND,                            13930000
MFA-TR*                  :KO-TOTAL-CALL-TIME,                           13940000
MFA-TR*                  :KO-INITIAL-COMMENT-TX,                        13950000
MFA-TR*                  :KO-RESPONSE-REASON-CD,                        13960000
MFA-TR*                  :KO-RESPONSE-TYPE-CD,                          13970000
MFA-TR*                  :KO-SOLICITATION-CD,                           13980000
MFA-TR*                  :KO-COMM-ASSOC-CD,                             13990000
MFA-TR*                  :KO-COMPLAINT-FL,                              14000000
MFA-TR*                  :KO-DISCOVERY-MTHD-CD,                         14010000
MFA-TR*                  :KO-PREV-MARKETER-CD)                          14020000
MFA-TR*    END-EXEC.                                                    14030000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 14040000
                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
A02477     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A02477        MOVE 'Y' TO WS-INSERTED                                   
A02477     ELSE                                                         
A02477       IF WS-ACTIVE-RETURN-CODE  = WS-803                         
A02477          ADD 1 TO WS-803-CTR                                     
A02477          MOVE 'N' TO WS-INSERTED                                 
A02477          IF WS-803-CTR > 5                                       
A02477             DISPLAY '*************************************'      
A02477             DISPLAY '* 8400-INSERT-CUST-COMM-DATA'               
A02477             DISPLAY '* CUSTOMER_NO = ' KO-CUSTOMER-NO            
A02477             DISPLAY '* ACCOUNT_NO  = ' KO-ACCOUNT-NO             
A02477             DISPLAY '* PREMISE_NO  = ' KO-PREMISE-NO             
A02477             DISPLAY '* COMM TYPE   = ' KO-COMM-TYPE-CD           
A02477             DISPLAY '* COMM SUBTYP = ' KO-COMM-SUBTYPE-CODE      
A02477             DISPLAY '* SQL RETURN CODE = ' SQLCODE               
A02477             DISPLAY '* -803 EXCEEDED 5 TIMES *'                  
A02477             DISPLAY '*************************************'      
A02477             PERFORM 9900-ABEND                THRU 9900-EXIT     
A02477          END-IF                                                  
             ELSE                                                       
               DISPLAY '*************************************'          
               DISPLAY '* 8400-INSERT-CUST-COMM-DATA'                   
               DISPLAY '* CUSTOMER_NO = ' KO-CUSTOMER-NO                
               DISPLAY '* ACCOUNT_NO  = ' KO-ACCOUNT-NO                 
               DISPLAY '* PREMISE_NO  = ' KO-PREMISE-NO                 
               DISPLAY '* COMM TYPE   = ' KO-COMM-TYPE-CD               
               DISPLAY '* COMM SUBTYP = ' KO-COMM-SUBTYPE-CODE          
               DISPLAY '* SQL RETURN CODE = ' SQLCODE                   
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND                THRU 9900-EXIT         
A02477       END-IF                                                     
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************13010000
      *   8500-UPDATE-BATCH-EMAIL-TB.                                  *13030000
      ******************************************************************13040000
       8500-UPDATE-BATCH-EMAIL-TB.                                      
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_BATCH_EMAIL                                    
                SET COMM_DATA_CD = 'Y'                                  
              WHERE CURRENT OF BATCH_EMAIL                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD +1                   TO  WS-UPD-CNTR                  
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '* 8500-UPDATE-BATCH-EMAIL-TB'                   
               DISPLAY '* ACCOUNT_NO   = ' AE-ACCOUNT-NO                
               DISPLAY '* BATCH-EMAIL-ID = ' AE-BATCH-EMAIL-ID          
               DISPLAY '* SQL RETURN CODE = ' SQLCODE                   
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 15100000
      *    8888-COMMIT                                               ** 15110000
      ***************************************************************** 15130000
       8888-COMMIT.                                                     
              EXEC SQL                                                  15170000
                  INCLUDE CPD00047                                      15180000
              END-EXEC.                                                 15190000
            MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE. 
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               ADD +1 TO WS-COMMIT-CNT                                  
            ELSE                                                        
               DISPLAY '****************************************'       
               DISPLAY '*       8888-COMMIT                    *'       
               DISPLAY '*     ERROR COMMITING RECORDS          *'       
               DISPLAY '* BATCH-EMAIL-ID : ' AE-BATCH-EMAIL-ID          
               DISPLAY '*       PROGRAM ABORTING...            *'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND               THRU 9900-EXIT          
            END-IF.                                                     
      *                                                                 15210000
       8888-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15240000
      **************************************************************            
      *  REDUCE-EMBEDDED SPACES                                                 
      **************************************************************            
      *                                                                         
PECS12 COPY CPD00004.                                                           
      *                                                                         
      ***************************************************************** 16270000
      ** 9000-TERMINATE                                                 16280000
      ***************************************************************** 16290000
       9000-TERMINATE.                                                  
             DISPLAY 'PCSCA276 ABEND INITIATED'.                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 16270000
      ** 9900-ABEND.                                                 ** 16280000
      ***************************************************************** 16290000
                                                                        
           EXEC SQL                                                     16310000
               INCLUDE CPD09900                                         16320000
           END-EXEC.                                                    16330000
