       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA275.                                        
      ***************************************************************** 00030000
      **              SOUTH CAROLINA ELECTRIC & GAS                  ** 00040000
      **                     PRICE WATERHOUSE                        ** 00050000
      **                                                             ** 00060000
      **               CUSTOMER INFORMATION SYSTEM                   ** 00070000
      **                                                             ** 00080000
      ***************************************************************** 00090000
      **               P R O G R A M  S U M M A R Y                  ** 00100000
      **                                                             ** 00110000
      **                                                             ** 00120000
      **                                                             ** 00130000
      **     F U N C T I O N A L    D E S C R I P T I O N            ** 00140000
      **                                                             ** 00150000
      **             O F   M O D U L E                               ** 00160000
      **                                                             ** 00170000
      **                                                             ** 00180000
      **                                                             ** 00190000
      **                                                             ** 00200000
      ***************************************************************** 00210000
      **                                                             ** 00220000
      **              PROGRAM  MODIFICATION  LOG                     ** 00230000
      **                                                             ** 00240000
      **    DATE    INITIALS  REASON                                 ** 00250000
      **  ________  ________  ______                                 ** 00260000
TP8965**  01/30/97    RAH     ADD HELPFUL AND MEANINGFUL ERROR       ** 00271000
      **                      MESSAGES FOR WHEN THE PROGRAM ABENDS   ** 00272000
T10120**  06/25/97    MKN     LOGIC IN PCSCA204 ADDED                ** 00273000
T12705**  08/12/97    EMS     CHANGED THE DATE OF PAYMENT TO COME    ** 00274000
      **                      FROM AR-DATE-TRANS. CHANGED CHRG-OFF   ** 00275000
      **                      CURSOR-2.                              ** 00276000
      **                      CHANGED HOW ADJUSTMENTS ARE UPDATED    ** 00277000
      **                      ADJUSTMENTS ARE CORRECTIONS.           ** 00278000
T12770**  08/15/97    EMS     SUPPRESSED ADJUSTMENTS FROM PRINTING   ** 00279000
T13759**  11/15/97    EMS     RESTRUCTURED THE PROGRAM               ** 00279100
T13740**                                                             ** 00279200
T13742**  11/17/97    EMS     FOR CHARGE AND CORRECTON UPDATE THE    ** 00279300
      **                      PLACED AMOUNT -- THE COLLECTION        ** 00279400
      **                      AGENCY IS REQUIRED TO COLLECT THE NEW  ** 00279500
      **                      CHARGE OR CORRECTION.                  ** 00279600
T13806**  11/21/97    EMS     UPDATE CURRENT COMMISSIONS PAID ON     ** 00279700
      **                      THE MONTHLY COLLECTION AGENCY TABLE.   ** 00279800
T13894**  11/24/97    EMS     WITHDRAWS ACCOUNTS SINCE THE LAST RUN  ** 00279900
      **                      DATE.                                  ** 00280000
T13899**  11/25/97    EMS     BACKS OUT THE AGENCY FEES PAID AND     ** 00280100
      **                      COLLECTION AMOUNTS FOR RETURNED CHECKS ** 00280200
      **                      AND PAYMENT CORRECTIONS.               ** 00280300
T14223**  01/07/98   EMS      TEMPORARY FIX TO WORK AROUND           ** 00280500
      **                      THE LACK OF INFO IN                    ** 00280600
      **                      CSS_CHG_OFF_AMT FOR ACCOUNTS           ** 00280700
      **                      SENT TO THE COLLECTION AGENCY          ** 00280800
      **                      IN THE LEGACY SYSTEM.                  ** 00280900
T14758**  02/13/98   EMS      REMOVE THE CHANGES FROM T14223.        ** 00281000
T15579**  03/24/98   KP       TO RETRIEVE RECDS FROM MNT_TRAN_HIST   ** 00281101
      **                      WITH TRANS-DATE GREATER THAN LAST RUN  ** 00281201
      **                      DATE AND LESS THAN OR EQUAL TO CURRENT ** 00281301
      **                      DATE                                   ** 00281401
T15769**  04/08/98    EMS     FIXED TRANSACTIONS TO INCLUDE CREDIT   ** 00281511
      **                      TRANSACTIONS, DEBIT TRANSACTIONS,      ** 00281611
      **                      ADDED THE REASON FOR NON-COMMISSION    ** 00281711
T23230**  03/26/01   VD88125  CHANGE THE PROGRAM TO ADD NEW JUDGEMENT**         
T23230**                      AND OTHER AS WITHDRAW REASONS FOR PSNC.**         
T23230**                      ADDED MUTIL-COMPANY AND PSNC CHANGES.  **         
T23230**  09/26/01   VD88125  FOR PSNC,ADDED LAST RUN DATE PARM ENTRY**         
T23230**                      TO CSS_JOB_PARM AND MULTI-COMPANY CHANGE*         
T24436**  10/04/01   COVANSYS COPYBOOK CPD00061 CHANGED TO SUB       **         
T24436**             CHENNAI  PROGRAM  SCSCB061.                     **         
C23972**  12/03/01   LAT      TO SET PROPER REASON CODES AND TOTALS  **         
C23972**                      THE RESTORING SERVICE CRITERIA OF 90   **         
C23972**                      DAYS IS CHANGED TO A DELINQUENCY VALUE.**         
C23972**                      HENCE ALL THE RELATED VARIABLE NAMES   **         
C23972**                      ARE CHANGED.                           **         
C23973**  01/29/01   LAT      REPORT PCSRP292 CORRECTIONS. PCSCA204  **         
C23973**                      MERGED ALONG WITH THIS PROGRAM.        **         
C26208**  03/26/02   LAT      ADD COMMIT/RESTART LOGIC.              **         
T26954**  10/08/02   RICK     ADD REG-GROUP-CD FOR SEBR TO OUTPUT    **         
T26954**  11/13/02   RICK     ADD REG-GROUP-CD FOR CSS_CHG_OFF_AMT   **         
T26954**                      KEY WHEN WRITING TO DATABASE.          **         
C27888**  02/21/03   LAT      1. CHANGE MADE TO CALCULATE CORRECT    **         
C27888**                      COMMISSION WHEN THE PAYMENT MADE IS    **         
C27888**                      GREATER THAN THE BALANCE.              **         
C27888**                      2. CHANGE MADE TO LIST THE ACCOUNTS IN **         
C27888**                      PCSRP275 THAT ARE WITHDRAWN IN PCSRP292**         
T33185**  03/12/07   PRIYA    PERFORMANCE TUNING (AVOID -911'S).     **         
C30169**  04/14/08   SS42021  WO RECOVERY PROJECT                    **         
      **                      1. WITHDRAWS TO BE WRITTEN TO A FILE   **         
      **                      2. USE FORECASTED WITHDRAW DT FOR      **         
      **                         WITHDRAWING ACCTS.                  **         
      **                      3. USE LIST DATE, WITHDRAW REASON FROM **         
      **                         CSS_FIN_WO_ACTION INSTEAD OF CHRG_OFF**        
      **                      3. NEW CURSOR TO WITHDRAW ACCTS FROM   **         
      **                         CSS_FIN_WO_COL_HST WHICH WERE REVERSD**        
      **                         FROM WO TO FB AND CANX RE-BILLED.   **         
F30169** 10/09/08    SS42021  1. PASS COMPANY-NO TO WITHDRAW FILE    **         
      **                         WHEN ACCT IS PROCESSED FROM HST TABLE**        
      **                      2. PASS CORRECT WITHDRAW DT TO FILE.    **        
F30169** 10/21/08    SS42021  ATTORNEY PLACED  ACCTS WERE NOT INCLUDED**        
      **                      IN RECOVERY PROCESSING. ADD WITHDRAW-DT **        
      **                      EQUAL NULL IN CURSOR2.                  **        
A00653** 02/10/09    SS42021  REMOVED THE CHECK FOR PLACEMENT DATE TO **        
      **                      BE GREATER THAN PSNC CONVERSION DATE    **        
A00765*  02/18/09     CVNS       ADDED 9000-SEND-ERROR-RESULT PARA.   **        
A00765*               CHENNAI                                         **        
A01618** 09/21/09    VV94890  ADDED BYPASS LOGIC FOR ABENDED ACCOUNTS.**        
A01618**                      IF ACCOUNT ISSUES, WRITE A RECORD TO    **        
A01618**                      EMAIL FILE AND READ NEXT RECORD.        **        
A02191** 05/24/10    RB19957  ADDED BYPASS LOGIC FOR ABENDED ACCOUNTS.**        
A02191**         RICK BLACK   IF ACCOUNT ISSUES, WRITE A RECORD TO    **        
A02191**                      EMAIL FILE AND READ NEXT RECORD.        **        
A02036** 07/16/10    DB41297  FIX TIMING ISSUE WITH TRAN HIST.        **        
      ******************************************************************00282000
      **          ---- BASIC SEQUENCE STRUCTURE ----                 ** 00290000
      **                                                             ** 00300000
      **  0000         MODULE CONTROL                                ** 00310000
      **  0100 - 0999  INITIALIZATION (OPTIONAL)                     ** 00320000
      **  1000 - 1999  FUNCTIONAL CONTROL                            ** 00330000
      **  2000 - 4999  DETAIL LOGIC                                  ** 00340000
      **  5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES            ** 00350000
      **  6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)  ** 00360000
      **  7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.)** 00370000
      **  8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC.)* 00380000
      **                                                             ** 00390000
      ***************************************************************** 00400000
      *  REMARKS                                                        00410000
      *                                                                 00420000
      * THIS WEEKLY PROGRAM CREATES TWO EXTRACT FILES FIORP275 AND      00430000
      * FCRP275.                                                        00440000
      *                                                                 00450000
      * PCSCA275 EXTRACTS CHARGE OFF ACCOUNTS THAT HAVE A WITHDRAW      00460000
      * COLLECTION STATUS AND A NULL WITHDRAW DATE. IT WRITES TO        00470000
      * FCSRP292 AND UPDATES THE WITHDRAW DATE WITH THE CURRENT DATE.   00480000
      *                                                                 00490000
      * THESE RECORDS WERE NOT WRITTEN TO THE FILE FIORP275 BECAUSE     00500000
      * USERS COULD NOT DEFINE THE PURPOSE FOR APPENDING WITHDRAWN      00510000
      * ASSIGNED CHARGE OFF ACCOUNTS TO THE COLLECTION AGENCY RECOVERY  00520000
      * DETAILS FILE FIORP275.                                          00530000
      *                                                                 00540000
      * PCSCA275 EXTRACTS FINANCIAL TRANSACTIONS THAT HAVE OCCURRED     00550000
      * ON CHARGE OFF ACCOUNTS SINCE THE LAST TIME THE PROGRAM WAS      00560000
      * RUN AND WRITES IT TO FIORP275.                                  00570000
      *                                                                 00580000
      * THE REASON CODES FOR NON-COMMISSION TRANSACTIONS ARE AS         00572004
      * FOLLOWS:                                                        00573004
      * A - PAYMENT IN FULL, SOLELY FOR PURPOSE OF HAVING SERVICE       00574004
      *     RESTORED, MADE DIRECTLY TO COMPANY.                         00575004
      * B - TRANSFERRED TO AN ACCOUNT                                   00576004
      * C - RETURNED CHECK                                              00577004
      * D - MISCELLANEOUS DEBIT                                         00578004
      * E - MISCELLANEOUS CREDIT                                        00579004
      * F - CORRECTION OF PAYMENT                                       00579104
      *                                                                 00585000
      *                                                                 00585000
      ***************************************************************** 00590000
       ENVIRONMENT DIVISION.                                            
      *                                                                 00610000
       CONFIGURATION SECTION.                                           
      *                                                                 00630000
       SOURCE-COMPUTER.    IBM-4381.                                    
       OBJECT-COMPUTER.    IBM-4381.                                    
      *                                                                 00660000
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                 00690000
       COPY CSSRP275.                                                   00700000
C26208     SELECT FRP275R-FILE                                          
C26208        ASSIGN TO UT-S-FRP275R                                    
C26208        FILE STATUS IS WS-FRP275R-STATUS.                         
C26208*                                                                         
       COPY CSSRP292.                                                   00710000
C26208     SELECT FRP292R-FILE                                          
C26208        ASSIGN TO UT-S-FRP292R                                    
C26208        FILE STATUS IS WS-FRP292R-STATUS.                         
      *                                                                 00720000
C30169 COPY CSSCA292.                                                   00710000
C30169     SELECT FCA292R-FILE                                          
C30169        ASSIGN TO UT-S-FCA292R                                    
C30169        FILE STATUS IS WS-FCA292R-STATUS.                         
      *                                                                 00720000
A01618 COPY CSSCM275.                                                   00720000
      *                                                                 00720000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                 00750000
       COPY CFDRP275.                                                   00760000
       COPY FIORP275.                                                   00770000
C26208 FD  FRP275R-FILE                                                 
C26208     BLOCK CONTAINS 0 RECORDS                                     
T26954     RECORD CONTAINS 127 CHARACTERS                               
C26208     RECORDING MODE IS F                                          
C26208     LABEL RECORDS ARE STANDARD.                                  
C26208                                                                  
T26954 01  FCSRP275R-REC                PIC X(127).                     
C26208*                                                                         
       COPY CFDRP292.                                                   00780000
       COPY FIORP292.                                                   00790000
C26208 FD  FRP292R-FILE                                                 
C26208     BLOCK CONTAINS 0 RECORDS                                     
C30169     RECORD CONTAINS 126 CHARACTERS                               
C26208     RECORDING MODE IS F                                          
C26208     LABEL RECORDS ARE STANDARD.                                  
C26208                                                                  
C30169 01 FRP292R-REC                   PIC X(126).                     
C30169*                                                                         
C30169 COPY CFDCA292.                                                   00780000
C30169 COPY FIOCA292.                                                   00790000
A01618 COPY CFDCM275.                                                           
A01618 COPY FIOCM275.                                                           
C30169 FD  FCA292R-FILE                                                 
C30169     BLOCK CONTAINS 0 RECORDS                                     
C30169     RECORD CONTAINS 223 CHARACTERS                               
C30169     RECORDING MODE IS F                                          
C30169     LABEL RECORDS ARE STANDARD.                                  
                                                                        
C30169 01 FCA292R-REC                   PIC X(223).                     
      *                                                                 00800000
       WORKING-STORAGE SECTION.                                         

MSQ012      EXEC SQL INCLUDE MFADIAG END-EXEC
MSQ008  01 MSQ008-WDRAW-RSN-CSR  PIC S9(9) COMP-5.
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA275'.
MSQ017     COPY MFASQLM.
       01  WS-START                     PIC X(40)                       
           VALUE 'WORKING STORAGE FOR PCSCA275 STARTS HERE'.            
      *                                                                 00840000
       01  WS-ABEND-AREA.                                               
           05  WS-ABEND-SPACE           PIC X VALUE SPACE.              
           05  WS-ABEND-NUMERIC REDEFINES WS-ABEND-SPACE                
                                        PIC 9.                          
      *                                                                 00890000
       01  WS-LITERALS.                                                 
           05  WS-PCSCA275              PIC X(08)   VALUE 'PCSCA275'.   
           05  PROGRAM-NAME             PIC X(08)   VALUE 'PCSCA275'.   
           05  WS-PGRMNAME              PIC X(10)   VALUE 'PCSCA275  '. 
T24436     05  SCSCB061                 PIC X(08)   VALUE 'SCSCB061'.   
           05  WS-DISPLAY-SQLCODE       PIC -ZZZZZZZZ9.                 
           05  WS-SCEG                  PIC X(05)   VALUE 'SCE&G'.      
T23230     05  WS-SCANA                 PIC X(05)   VALUE 'SCANA'.      
T23230     05  WS-PSNC                  PIC X(05)   VALUE 'PSNC '.      
           05  WS-SYSTEM                PIC X(06)   VALUE 'SYSTEM'.     
           05  WS-Y                     PIC X(01)   VALUE 'Y'.          
           05  WS-N                     PIC X(01)   VALUE 'N'.          
           05  WS-PAYMENT-STATUS        PIC X(01)   VALUE 'P'.          
T15769     05  WS-CREDIT-STATUS         PIC X(01)   VALUE 'I'.          
           05  WS-TRANSFER-STATUS       PIC X(01)   VALUE 'T'.          
           05  WS-CORRECTION-STATUS     PIC X(01)   VALUE 'C'.          
           05  WS-CHARGE-STATUS         PIC X(01)   VALUE 'S'.          
           05  WS-COLLECTION-AGNCY-CD   PIC X(01)   VALUE 'E'.          
           05  WS-WITHDRAWN-CD          PIC X(01)   VALUE 'F'.          
C23973     05  WS-D                     PIC X(01)   VALUE 'D'.          
C23973     05  WS-F                     PIC X(01)   VALUE 'F'.          
C23973     05  WS-I                     PIC X(01)   VALUE 'I'.          
C23973     05  WS-PSNC-CONVRSN-DT       PIC X(10)   VALUE '2001-10-08'. 
C26208     05  WS-DUP-CNTRL-NO          PIC S9(04)  USAGE COMP.         
C26208     05  WS-RESTART-ACCOUNT       PIC S9(13)V USAGE COMP-3        
C26208                                              VALUE 0.            
C26208     05  WS-PREV-ROW-ACCT         PIC S9(13)V USAGE COMP-3        
C26208                                              VALUE 0.            
C26208     05  WS-FCSRP292-END-OF-FILE  PIC X(01)   VALUE SPACES.       
C26208         88 FCSRP292-END                      VALUE 'Y'.          
C30169     05  WS-FCSCA292-END-OF-FILE  PIC X(01)   VALUE SPACES.       
C30169         88 FCSCA292-END                      VALUE 'Y'.          
      *                                                                 01022000
       01  WS-MH-MESSAGE.                                               
           05  FILLER                   PIC X(23)   VALUE               
               'COMMISSIONS ON PYMT OF '.                               
           05  WS-PYMT-AMT              PIC $$$$$$$$9.99.               
           05  FILLER                   PIC X(12)     VALUE             
               ';  TOTALING '.                                          
           05  WS-COMMISSION-AMT        PIC $$$$$$$$9.99.               
           05  FILLER                   PIC X(01)   VALUE '.'.          
      *                                                                 01080000
       01  WS-FLAGS.                                                    
           05  FLG-FRP275                  PIC X(01)   VALUE 'N'.       
           05  FLG-EMPTY-FILE              PIC X(01)   VALUE 'N'.       
           05  FLG-FIRST-ITERATION         PIC X(01)   VALUE 'Y'.       
           05  FLG-END-CHRG-OFF-ACT        PIC X(01)   VALUE 'N'.       
           05  FLG-NEXT-CHRG-OFF-ACT       PIC X(01)   VALUE 'N'.       
           05  FLG-END-TRN-ACT             PIC X(01)   VALUE 'N'.       
           05  FLG-END-OF-DET              PIC X(01)   VALUE 'N'.       
           05  FLG-MORE-TRNS               PIC X(01)   VALUE 'Y'.       
           05  FLG-PYMT-WAS-NONCOM         PIC X(01)   VALUE 'N'.       
T12705     05  WS-WO-MONTH-EXISTS          PIC X(01)   VALUE 'N'.       
T12705     05  WS-PROCESS-ACCOUNT          PIC X(01)   VALUE 'N'.       
C23972     05  WS-VOUCHER-PYMT-EXISTS      PIC X(01)   VALUE 'N'.       
C23972     05  WS-FINANCIAL-TRANS-EXISTS   PIC X(01)   VALUE 'Y'.       
C23973     05  WS-NO-ACTIVITY-FLAG         PIC X(01)   VALUE 'N'.       
C30169     05  WS-UPDT-WDRAW-DT-FL         PIC X(01)   VALUE SPACES.    
C26208*                                                                         
C26208 01  WS-RESTART-DATA.                                             
C26208     05  WS-RESTART-PROCESS-TYPE     PIC 9(01).                   
C26208     05  WS-RESTART-JOB-COMPLETE     REDEFINES                    
C26208           WS-RESTART-PROCESS-TYPE   PIC X(01).                   
C26208     05  WS-RESTART-JOB-STATUS       PIC X(01).                   
C26208         88  WS-RP292-COMPLETED                  VALUE 'B'.       
C26208         88  WS-PGM-ABENDED                      VALUE 'C'.       
C26208     05  WS-RESTART-COMMON-DATE      PIC X(10).                   
C26208     05  WS-RESTART-PROG-ID          PIC X(05).                   
C26208     05  WS-RESTART-CHKP-SEQ-NO      PIC 9(05).                   
C26208     05  WS-RESTART-ROW-CNT          PIC 9(06).                   
C26208     05  WS-RESTART-ACCT-NO          PIC 9(13)   VALUE 0.         
C26208     05  WS-RESTART-TIMESTAMP        PIC X(26)   VALUE            
C26208                                    '1900-01-01-00.00.00.000000'. 
      *                                                                 01190000
C26208 01  WS-RESTART-MISC.                                             
C26208     05  WS-RESTART-DATA-LENGTH      PIC S9(04)  COMP VALUE +67.  
C26208     05  WS-IS-THIS-A-RESTART        PIC X(01)   VALUE 'N'.       
C26208         88  WS-THIS-IS-A-RESTART                VALUE 'Y'.       
C26208     05  WS-RESTART-COMMIT-COUNTER   PIC 9(04)   VALUE 0.         
C26208     05  WS-DEFAULT-RESTART-REQ      PIC X(01)   VALUE 'N'.       
C26208     05  WS-RESTART-REQ              PIC X(01).                   
C26208     05  WS-SEQ-NO                   PIC 9(04)   VALUE 0.         
C26208     05  WS-CHKP-LUW-LIMIT           PIC 9(04)   VALUE 0.         
C26208     05  WS-CHKP-UPD-LIMIT           PIC 9(04)   VALUE 0.         
C26208     05  WS-CHKP-SEQ-NO              PIC 9(05)   VALUE 0.         
C26208     05  WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(04)   VALUE 4.         
C26208     05  WS-DEFAULT-CHKP-UPD-LIMIT  PIC 9(04)   VALUE 20.         
C26208     05  WS-TOT-RECS-WRTN            PIC 9(06)   VALUE 0.         
C26208*                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-FRP275-READ-COUNT        PIC 9(07)   VALUE ZERO.      
C26208     05  WS-FRP275R-READ-COUNT       PIC 9(07)   VALUE ZERO.      
           05  WS-FRP275-STATUS            PIC X(02).                   
               88  FRP275-SUCCESSFUL                   VALUE ZERO.      
C26208     05  WS-FRP275R-STATUS           PIC X(02).                   
C26208         88  FRP275R-SUCCESSFUL                  VALUE ZERO.      
           05  WS-FRP292-READ-COUNT        PIC 9(07)   VALUE ZERO.      
C26208     05  WS-FRP292R-READ-COUNT       PIC 9(07)   VALUE ZERO.      
           05  WS-FRP292-STATUS            PIC X(02).                   
               88  FRP292-SUCCESSFUL                   VALUE ZERO.      
C26208     05  WS-FRP292R-STATUS           PIC X(02).                   
C26208         88  FRP292R-SUCCESSFUL                  VALUE ZERO.      
C30169     05  WS-FCA292-READ-COUNT        PIC 9(07)   VALUE ZERO.      
C30169     05  WS-FCA292R-READ-COUNT       PIC 9(07)   VALUE ZERO.      
C30169     05  WS-FCA292-STATUS            PIC X(02).                   
C30169         88  FCA292-SUCCESSFUL                   VALUE ZERO.      
C30169     05  WS-FCA292R-STATUS           PIC X(02).                   
C30169         88  FCA292R-SUCCESSFUL                  VALUE ZERO.      
A01618     05  WS-FCM275-STATUS            PIC X(02).                   
A01618         88  FCM275-SUCCESSFUL                   VALUE '00'.      
A01618     05  WS-ACCT-ISSUE-CUR           PIC X(04)   VALUE SPACES.    
A01618     05  WS-ISSUE-INDEX              PIC 9(04)   VALUE ZERO.      
A01618     05  WS-CO-AMTS-EXISTS           PIC X(01)   VALUE 'Y'.       
           05  WS-PAYMENT-FOUND            PIC X(01)   VALUE 'N'.       
           05  WS-COMMISSIONS-EXIST        PIC X(01)   VALUE 'N'.       
C30169     05  WS-WDRAW-RSN-TBL-LOADED     PIC X(01)   VALUE 'N'.       
C30169         88 WDRAW-RSN-TBL-LOADED     VALUE 'Y'.                   
      *                                                                 01270000
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE          PIC S9(04) COMP VALUE 0.         
           05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
A01618     05  WS-RETURN-CODE-03       PIC S9(04) COMP VALUE 0.         
A01618     05  S-RETURN-CODE           PIC S9(04) COMP VALUE 0.         
      *                                                                 01290000
       01  WS-PARM-DATA.                                                
           05  FILLER                      PIC X(14) VALUE              
                                           'LAST RUN DATE=' .           
           05  WS-LAST-RUN-DATE            PIC X(10).                   
C30169     05  WS-LAST-RUN-DT              PIC X(26) VALUE SPACES.      
A02036     05  WS-LAST-TRN-DT              PIC X(26) VALUE SPACES.      
           05  FILLER                      PIC X(30).                   
      *                                                                 01340000
       01  WS-JOB-PARM.                                                 
T23230*    05  WS-P-COMPANY-NO             PIC X(02) VALUE '01'.        01360000
T23230     05  WS-P-COMPANY-NO             PIC X(02) VALUE SPACES.      
           05  WS-P-CMD-CODE               PIC X(04) VALUE 'PARM'.      
           05  WS-P-SEQ-NO                 PIC S9(04)V COMP-3 VALUE +1. 
      *                                                                 01390000
C30169 01  WS-MISC-HOST-VARIABLES.                                      
           05  WS-FW-ATTR-VALUE-CD         PIC X(05) OCCURS 50 TIMES    
                                                     VALUE SPACES.      
           05  WS-FW-ATTR-VALUE-DESC       PIC X(75) OCCURS 50 TIMES.   
                                                                        
C30169 01  WS-WITHDRAW-RSN-DATA.                                        
           03  WS-WDRAW-RSN-DESC                                        
                  OCCURS 75 TIMES                                       
                  ASCENDING KEY WS-WITHDRAW-RSN-CD                      
                  INDEXED BY WS-RANGE-INDEX.                            
               05  WS-WITHDRAW-RSN-CD        PIC X(05) VALUE SPACES.    
               05  WS-WITHDRAW-RSN-DESC      PIC X(75) VALUE SPACES.    
                                                                        
       01  WS-REASON-CD-DESC.                                           
           05  WS-COLLECTION-PROCESS       PIC X(01) VALUE 'J'.         
           05  WS-BANKRUPT-STATUS          PIC X(01) VALUE 'A'.         
           05  WS-A-BANKRUPT               PIC X(16) VALUE              
               'BANKRUPT        '.                                      
           05  WS-DECEASED-STATUS          PIC X(01) VALUE 'B'.         
           05  WS-B-DECEASED               PIC X(16) VALUE              
               'DECEASED        '.                                      
C23973     05  WS-PAID-STATUS              PIC X(01) VALUE 'C'.         
C23973     05  WS-C-PAID                   PIC X(16) VALUE              
C23973         'PAID            '.                                      
C23973     05  WS-TRANSFERRED-STATUS       PIC X(01) VALUE 'D'.         
C23973     05  WS-D-TRANSFERRED            PIC X(16) VALUE              
C23973         'TRANSFERRED     '.                                      
           05  WS-ARRANGEMENT-STATUS       PIC X(01) VALUE 'E'.         
           05  WS-E-ARRANGEMENT            PIC X(16) VALUE              
               'ARRANGEMENT     '.                                      
C23973     05  WS-NO-ACTIVITY-STATUS       PIC X(01) VALUE 'N'.         
           05  WS-N-NO-ACTIVITY            PIC X(16) VALUE              
               'NO ACTIVITY     '.                                      
T23230     05  WS-JUDGEMENT-STATUS         PIC X(01) VALUE 'J'.         
T23230     05  WS-A-JUDGEMENT              PIC X(16) VALUE              
T23230         'JUDGEMENT       '.                                      
C23973     05  WS-EXPIRED-STATUS           PIC X(01) VALUE 'F'.         
C23973     05  WS-F-EXPIRED                PIC X(16) VALUE              
C23973         'EXPIRED         '.                                      
C23973     05  WS-OTHER-STATUS             PIC X(01) VALUE 'G'.         
C23973     05  WS-G-OTHER                  PIC X(16) VALUE              
T23230         'OTHER           '.                                      
T23230     05  WS-COMPANY-NO               PIC X(02) VALUE SPACES.      
T23230     05  WS-COMPANY-NO-FLAG          PIC X(04) VALUE SPACES.      
T23230         88 SCEG                               VALUE 'SCEG'.      
T23230         88 SEB                                VALUE 'SEB'.       
T23230         88 PSNC                               VALUE 'PSNC'.      
      *                                                                 01490000
       01  WS-SYSTEM-DATE.                                              
           05  WS-SYS-DATE.                                             
               10  WS-SYS-YEAR             PIC 9(02).                   
               10  WS-SYS-MONTH            PIC 9(02).                   
               10  WS-SYS-DAY              PIC 9(02).                   
           05  WS-SYSTEM-DATE-X REDEFINES WS-SYS-DATE.                  
               10  WS-SYS-YEAR-X           PIC X(02).                   
               10  WS-SYS-MONTH-X          PIC X(02).                   
               10  WS-SYS-DAY-X            PIC X(02).                   
      *                                                                 01590000
       01  WS-CALC-DATES.                                               
C23972     05  WS-RES-DAYS-FROM-PLACEMENT  PIC X(10).                   
           05  WS-YEAR-FROM-LAST-PYMT      PIC X(10).                   
           05  WS-PREV-PYMT-DATE-TRANS     PIC X(10).                   
C23973     05  WS-1-MONTH-AGO              PIC X(10).                   
C23972     05  WS-NO-DAYS                  PIC S9(04) COMP VALUE 0.     
      *                                                                 01640000
       01  WS-ACCT-GEN-LED-BREAKDOWN       PIC 9(03)V9(04).             
       01  WS-ACCT-GEN-LED-BREAKDOWN-RED                                
           REDEFINES WS-ACCT-GEN-LED-BREAKDOWN.                         
           05  WS-ACCT-GEN-LED-MAJOR       PIC 9(03).                   
           05  WS-ACCT-GEN-LED-MINOR       PIC 9(04).                   
      *                                                                 01820000
       01  WS-HOLD-VARIABLES.                                           
           05  WS-WITHDRAWN-BAL         PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-CURR-MTH-ADJ-AMT      PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-CURR-MTH-COLL-AMT     PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-CURR-PAID-COLL-AMT    PIC S9(09)V99 COMP-3 VALUE +0.  
T13742     05  WS-AGNCY-PLACED-AMT      PIC S9(09)V99 COMP-3 VALUE +0.  
T13806     05  WS-AGNCY-FEES-PD-AMT     PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-PLACED-AMOUNT         PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-WRITE-OFF-BAL         PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-BAL-W-TRANSACTION     PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-BAL-WO-TRANSACTION    PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-UNUSED-CREDIT         PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-COMMISSION            PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-AMT-ORIG-ENTERED      PIC S9(09)V99 COMP-3 VALUE +0.  
C27888     05  WS-BALANCE-AMT           PIC S9(09)V99 COMP-3 VALUE +0.  
T13899     05  WS-PYMT-FACILITY-CD      PIC X(01)     VALUE SPACES.     
T13899     05  WS-CORRECTED-PAYMENT     PIC S9(09)V99 COMP-3 VALUE +0.  
T13899     05  WS-CORRECTED-COMM        PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-CORRECTED-FEE         PIC S9(09)V99 COMP-3 VALUE +0.  
T13899     05  WS-TRANSACTION-AMT       PIC S9(09)V99 COMP-3 VALUE +0.  
T13899     05  WS-RETURNED-CHECK        PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-ADJUSTMENT-AMOUNT     PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-AR-DATE-ORIG-PYMT-NI  PIC S9(04)    COMP   VALUE +0.  
           05  WS-PREV-AMT-BILLED-UNPAID                                
                                        PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-SN-WRITE-OFF-MONTH-YR PIC X(06).                      
           05  WS-TRANS-HIST-SEQ-NO     PIC X(26)   VALUE SPACES.       
C23973     05  WS-PREVIOUS-DATA-REC     PIC X(112)  VALUE SPACES.       
C30169     05  WS-WDRAW-ROW-COUNT       PIC S9(04) COMP   VALUE +0.     
C30169     05  WS-INDEX                 PIC S9(04) COMP-3 VALUE +0.     
C30169     05  WS-NUM-COND              PIC S9(04) COMP   VALUE +0.     
COB305     05 WS-DELINQ-DAYS-FPLMT        PIC S9(4)V9(5) USAGE COMP-3 
COB305       VALUE 0.    
COB305     05 WS-DELINQ-DAYS-NO-FA        PIC S9(4)V9(5) USAGE COMP-3 
COB305       VALUE 0.    
C30169     05  WS-KD-WRITE-OFF-DT       PIC X(10)     VALUE SPACES.     
      *                                                                 01960000
       01  WS-CONSTANTS.                                                
           05  WS-ACCT-GEN-ACCTS-REC    PIC 9(03)   VALUE 142.          
           05  WS-VALUE-50              PIC 9(02)   VALUE 50.           
           05  WS-VALUE-ZERO            PIC S9(09)V COMP-3 VALUE 0.     
           05  WS-VALUE-19TH-CEN        PIC 9(02)   VALUE 19.           
           05  WS-VALUE-20TH-CEN        PIC 9(02)   VALUE 20.           
C23973     05  WS-NULL-DATE-LSTD        PIC S9(04)  COMP.               
C23973     05  WS-NULL-LAST-PYMT-DT     PIC S9(04)  COMP.               
C30169     05  WS-NULL-WDRAW-DT         PIC S9(04)  COMP.               
C30169     05  WS-NULL-WOB              PIC S9(04)  COMP VALUE 0.       
C30169     05  WS-DELIMITER1            PIC X(01)   VALUE ';'.          
      *                                                                 02030000
       01  WS-LAST-RUN-DATE-TS          PIC X(26).                      
       01  WS-TS-RUN-DATE.                                              
           05  WS-TS-LST-RUN-DATE       PIC X(10).                      
           05  FILLER                   PIC X(16)     VALUE             
           '-00.00.00.000000'.                                          
      *                                                                 02090000
C23972 01  WS-RES-DAYS-FROM-PLACEMENT-TS PIC X(26).                     
C23972 01  WS-TS-RES-DAYS-FROM-PLACEMENT.                               
C23972     05  WS-TS-RES-DAYS           PIC X(10).                      
           05  FILLER                   PIC X(16)     VALUE             
           '-00.00.00.000000'.                                          
      *                                                                 02150000
       01  WS-DATE-LISTED               PIC X(10).                      
      *                                                                 02152000
COB305 01 WS-WO-MONTH-YR        PIC S9(06)V COMP-3 VALUE 0.           
       01  WS-WO-DATE                   PIC 9(6).                       
       01  WS-WO-DATE-FORMAT  REDEFINES WS-WO-DATE.                     
           05  WS-WO-YEAR               PIC 9(04).                      
           05  WS-WO-MONTH              PIC 9(02).                      
      *                                                                 02220000
       01  WS-H-VARIABLES.                                              
           05  WS-H-COMPANY-NO          PIC X(02)      VALUE SPACES.    
           05  WS-H-LOCAL-OFFICE        PIC X(03)      VALUE SPACES.    
           05  WS-H-CODE-COLLEC-AGNCY   PIC X(03)      VALUE SPACES.    
C30169*    05  WS-H-COLL-AGY-SUB-CD     PIC X(03)      VALUE SPACES.    02260000
           05  WS-H-COLLECTED-BY        PIC X(05)      VALUE SPACES.    
           05  WS-H-ACCOUNT-NO          PIC X(13)      VALUE SPACES.    
COB305     05 WS-H-ACCOUNT-NO-PIC9        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.       
           05  WS-H-FULL-NAME           PIC X(43)      VALUE SPACES.    
           05  WS-H-DATE-OF-CHG-OFF     PIC X(10)      VALUE SPACES.    
           05  WS-H-DATE-LSTD-COLL-AGY  PIC X(10)      VALUE SPACES.    
           05  WS-H-CHG-WITHDRAW-REASN  PIC X(01)      VALUE SPACES.    
           05  WS-H-CODE-CHG-OFF-REAS   PIC X(01)      VALUE SPACES.    
           05  WS-H-DATE-ORIG-PYMT      PIC X(10)      VALUE SPACES.    
           05  WS-H-CODE-TRAN-TYPE      PIC X(04)      VALUE SPACES.    
           05  WS-H-AMT-REMAIN-BAL      PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-H-AMT-ORIG-ENTERED    PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-H-NON-COM             PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-H-WRITE-OFF-AMOUNT    PIC S9(09)V99 COMP-3 VALUE +0.  
      *                                                                 02390000
      ***********************************************************       02400000
      ******   SQL WORK VARIABLES                                       02410000
       COPY CWS00303.                                                   02420000
      *                                                                 02430000
       COPY CWS00061.                                                   02431000
      *                                                                 02432000
       COPY CWS09900.                                                   02440000
      *                                                                 02450000
       COPY CWS00010.                                                   02460000
      *                                                                 02470000
       COPY CWS00011.                                                   02480000
      *                                                                 02490000
           EXEC SQL                                                     02500000
               INCLUDE CWS00038                                         02510000
           END-EXEC.                                                    02520000
      *                                                                 02520100
TPR        EXEC SQL                                                     02521000
               INCLUDE CWS00074                                         02522000
           END-EXEC.                                                    02523000
      *                                                                 02530000
       COPY CWS00039.                                                   02540000
      *                                                                 02550000
       COPY CWS00104.                                                   02560000
      *                                                                 02570000
       COPY FIOCA00.                                                    02580000
      *                                                                 02590000
       COPY FIOJC01.                                                    02600000
      *                                                                 02610000
       01  WS-END                          PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSCA275 ENDS HERE  '.            
      ******************************************************************02640000
      **  DB2 TABLES USED IN THIS PROGRAM.                            **02650000
      **                                                              **02660000
      ******************************************************************02670000
      *                                                                 02680000
           EXEC SQL                                                     02690000
               INCLUDE SQLCA                                            02700000
           END-EXEC.                                                    02710000
      *                                                                 02720000
      ****** TABLE DECLARATION FOR CSS_ACCOUNT *************************02730000
           EXEC SQL                                                     02740000
               INCLUDE TBACCT                                           02750000
           END-EXEC.                                                    02760000
      *                                                                 02770000
      ****** TABLE DECLARATION FOR CSS_AR_CNTL *************************02780000
           EXEC SQL                                                     02790000
               INCLUDE TBARCNTL                                         02800000
           END-EXEC.                                                    02810000
      *                                                                 02820000
      ****** TABLE DECLARATION FOR CSS_AR_TRANS_HIST *******************02830000
           EXEC SQL                                                     02840000
               INCLUDE TBARHIST                                         02850000
           END-EXEC.                                                    02860000
      *                                                                 02870000
      ****** TABLE DECLARATION FOR CSS_AR_TRN_HST_DET ******************02880000
           EXEC SQL                                                     02890000
               INCLUDE TBARHDT                                          02900000
           END-EXEC.                                                    02910000
      *                                                                 02920000
      ****** TABLE DECLARATION FOR CSS_CHG_OFF_AMT *********************02930000
           EXEC SQL                                                     02940000
               INCLUDE TBCHGAMT                                         02950000
           END-EXEC.                                                    02960000
      *                                                                 02970000
      ****** TABLE DECLARATION FOR CSS_CHRG_OFF ************************02980000
           EXEC SQL                                                     02990000
               INCLUDE TBCHGOFF                                         03000000
           END-EXEC.                                                    03010000
      *                                                                 03020000
      ****** TABLE DECLARATION FOR CSS_CUSTOMER ************************03030000
           EXEC SQL                                                     03040000
               INCLUDE TBCUST                                           03050000
           END-EXEC.                                                    03060000
      *                                                                 03070000
      ****** TABLE DECLARATION FOR CSS_COLLECT_AGENCY ******************03080000
           EXEC SQL                                                     03090000
               INCLUDE TBCLAGNY                                         03100000
           END-EXEC.                                                    03110000
      *                                                                 03120000
      ****** TABLE DECLARATION FOR CSS_COLL_AGNCY_COM ******************03130000
           EXEC SQL                                                     03140000
               INCLUDE TBCLAGCM                                         03150000
           END-EXEC.                                                    03160000
      *                                                                 03170000
      ****** TABLE DECLARATION FOR CSS_JOB_PARM ************************03180000
           EXEC SQL                                                     03190000
               INCLUDE TBJBPARM                                         03200000
           END-EXEC.                                                    03210000
      *                                                                 03220000
      ****** TABLE DECLARATION FOR CSS_NAME ****************************03230000
           EXEC SQL                                                     03240000
               INCLUDE TBNAME                                           03250000
           END-EXEC.                                                    03260000
      *                                                                 03270000
      ****** TABLE DECLARATION FOR CSS_NAME_ACCT_XREF  *****************03272000
           EXEC SQL                                                     03273000
               INCLUDE TBNMACTX                                         03274000
           END-EXEC.                                                    03275000
      *                                                                 03276000
      ****** TABLE DECLARATION FOR CSS_ACCT_MISC_INFO  *****************03312000
           EXEC SQL                                                     03313000
               INCLUDE TBATMISC                                         03314000
           END-EXEC.                                                    03315000
      *                                                                 03320000
      ****** TABLE DECLARATION FOR CSS_ADDR_FORMATTED  *****************03321000
           EXEC SQL                                                     03322000
               INCLUDE TBADRFMT                                         03323000
           END-EXEC.                                                    03324000
      *                                                                 03324100
      ****** TABLE DECLARATION FOR CSS_ADDR_FREEFORM   *****************03324200
           EXEC SQL                                                     03324300
               INCLUDE TBADRFRE                                         03324400
           END-EXEC.                                                    03324500
      *                                                                 03324600
      ****** TABLE DECLARATION FOR CSS_ZIP_CODE        *****************03324700
           EXEC SQL                                                     03324800
               INCLUDE TBZIPCD                                          03324900
           END-EXEC.                                                    03325000
      *                                                                 03325100
      ****** TABLE DECLARATION FOR CSS_CUST_ADDR_XREF  *****************03325200
           EXEC SQL                                                     03325300
               INCLUDE TBCSADRX                                         03325400
           END-EXEC.                                                    03325500
      *                                                                 03325600
      ****** TABLE DECLARATION FOR CSS_GL_ACCT_NO  *********************03325700
           EXEC SQL                                                     03325800
               INCLUDE TBGLATNO                                         03325900
           END-EXEC.                                                    03326000
      *                                                                 03327000
      ****** TABLE DECLARATION FOR CSS_MNT_TRANS_HIST  *****************03332000
           EXEC SQL                                                     03333000
               INCLUDE TBMNHIST                                         03334000
           END-EXEC.                                                    03335000
      *                                                                 03336000
      ****** TABLE DECLARATION FOR CSS_MT_TRN_HST_DET  *****************03337000
           EXEC SQL                                                     03338000
               INCLUDE TBMNHDT                                          03339000
           END-EXEC.                                                    03339100
C23972*                                                                 03337000
C23972****** TABLE DECLARATION FOR CSS_FINAL_WO        *****************03337000
C23972     EXEC SQL                                                             
C23972         INCLUDE TBFINLWO                                                 
C23972     END-EXEC.                                                            
C23972*                                                                 03337000
C23972****** TABLE DECLARATION FOR CSS_DELINQUENCY     *****************03337000
C23972     EXEC SQL                                                             
C23972         INCLUDE TBDELQ                                                   
C23972     END-EXEC.                                                            
C26208*                                                                         
C26208****** TABLE DECLARATION FOR CSS_RESTART                                  
C26208     EXEC SQL                                                             
C26208         INCLUDE TBRESTRT                                                 
C26208     END-EXEC.                                                            
T26954****** TABLE DECLARATION FOR CSS_REG_PROFILE                              
T26954     EXEC SQL                                                             
T26954         INCLUDE TBREGPRF                                                 
T26954     END-EXEC.                                                            
      *                                                                 03339300
C30169****** TABLE DECLARATION FOR CSS_FIN_WO_ACTION (KD)                       
C30169     EXEC SQL                                                             
C30169         INCLUDE TBFWACTN                                                 
C30169     END-EXEC.                                                            
      *                                                                 03339300
C30169****** TABLE DECLARATION FOR CSS_FIN_WO_COLLECT (IZ)                      
C30169     EXEC SQL                                                             
C30169         INCLUDE TBFWCLAG                                                 
C30169     END-EXEC.                                                            
      *                                                                 03339300
C30169****** TABLE DECLARATION FOR CSS_FW_ATTRIB_DESC (KV)                      
C30169     EXEC SQL                                                             
C30169         INCLUDE TBATTDES                                                 
C30169     END-EXEC.                                                            
      *                                                                 03339300
C30169****** TABLE DECLARATION FOR CSS_COLL_AGY_SUB (L2)                        
C30169     EXEC SQL                                                             
C30169         INCLUDE TBCASUB                                                  
C30169     END-EXEC.                                                            
      *                                                                         
C30169****** TABLE DECLARATION FOR CSS_FIN_WO_COL_HST (FM)                      
C30169     EXEC SQL                                                             
C30169         INCLUDE TBFWAHST                                                 
C30169     END-EXEC.                                                            
      **  CURSOR DECLARATIONS                                          *03340000
      ******************************************************************03350000
      *                                                                 03360000
           EXEC SQL                                                     
C26208       DECLARE CHRG_OFF_CURSOR1 CURSOR WITH HOLD FOR              
             SELECT DISTINCT                                            
C30169              IZ.CODE_COLLEC_AGNCY,                               
C30169              IZ.COLL_AGY_SUB_CD,                                 
C30169              IZ.ACCOUNT_NO,                                      
C30169              COALESCE(CO.DATE_OF_CHG_OFF,IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )),            
C30169              KD.FW_ACTION_DT,                                    
C30169              KD.FW_ACTION_AM,                                    
C30169              IZ.FW_COLL_SEQ_NO,                                  
C30169              IZ.FW_ACTION_TYPE_CD,                               
C30169              IZ.WITHDRAW_REASON_CD,                              
C30169              IZ.WITHDRAW_AM,                                     
C30169              IZ.WITHDRAW_DT,                                     
C30169              COALESCE(CO.WO_STATUS,' '),                           
T10120              AT.COMPANY_NO,                                      
T10120              AT.LOCAL_OFFICE,                                    
T10120              AT.CUSTOMER_NO,                                     
                    AT.PREMISE_NO,                                      
C23973              AT.LAST_PYMT_DATE                                   
T10120       FROM CSS_ACCOUNT  AT WITH(READUNCOMMITTED)                         
C30169           ,CSS_FIN_WO_ACTION KD WITH(READUNCOMMITTED)                    
C30169           ,CSS_FIN_WO_COLLECT IZ WITH(READUNCOMMITTED)                   
C30169            LEFT OUTER JOIN CSS_CHRG_OFF CO WITH(READUNCOMMITTED)         
C30169             ON CO.ACCOUNT_NO = IZ.ACCOUNT_NO                     
T10120       WHERE                                                      
C30169          KD.ACCOUNT_NO = AT.ACCOUNT_NO                           
C30169      AND IZ.ACCOUNT_NO = KD.ACCOUNT_NO                           
C30169      AND IZ.ACCOUNT_NO > :WS-RESTART-ACCOUNT                     
T23230      AND AT.COMPANY_NO = :WS-COMPANY-NO                          
C30169      AND KD.FW_ACTION_TYPE_CD = IZ.FW_ACTION_TYPE_CD             
C30169      AND KD.FW_SEQ_NO         = IZ.FW_COLL_SEQ_NO                
C30169      AND KD.FW_ACTION_TYPE_CD IN ('1PLMT','2PLMT','3PLMT','ATY') 
C23973      AND ((CO.WO_STATUS  = :WS-D                                 
C30169            AND KD.FW_ACTION_DT <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-LAST-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-RUN-DATE
              ) <> 0) OR (LEN(:WS-LAST-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-LAST-RUN-DATE
              ), CONVERT(DATE, :WS-LAST-RUN-DATE) )              
C30169            AND KD.FW_ACTION_AM > 0                               
C30169            AND IZ.WITHDRAW_DT > IIF(TRY_CONVERT(DATE, 
                                                      :WS-LAST-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-RUN-DATE
              ) <> 0) OR (LEN(:WS-LAST-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-LAST-RUN-DATE
              ), CONVERT(DATE, :WS-LAST-RUN-DATE) ))               
C23973          OR                                                      
C30169           (((IZ.WITHDRAW_DT       > IIF(TRY_CONVERT(DATE, 
                                                      :WS-LAST-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-RUN-DATE
              ) <> 0) OR (LEN(:WS-LAST-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-LAST-RUN-DATE
              ), CONVERT(DATE, :WS-LAST-RUN-DATE) )            
C30169              AND IZ.WITHDRAW_REASON_CD <> ' ')                   
T10120                  OR                                              
C30169             (IZ.WITHDRAW_DT > IIF(TRY_CONVERT(DATE, 
                                                      :WS-LAST-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-RUN-DATE
              ) <> 0) OR (LEN(:WS-LAST-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-LAST-RUN-DATE
              ), CONVERT(DATE, :WS-LAST-RUN-DATE) )                  
C30169              AND IZ.WITHDRAW_DT <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )                
C30169              AND IZ.WITHDRAW_REASON_CD = ' '                     
C30169              AND KD.FW_ACTION_DT <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-LAST-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-RUN-DATE
              ) <> 0) OR (LEN(:WS-LAST-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-LAST-RUN-DATE
              ), CONVERT(DATE, :WS-LAST-RUN-DATE) )            
C30169              AND KD.FW_ACTION_AM > 0)                            
C23973                  OR                                              
C30169             (KD.FW_ACTION_DT <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-LAST-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-RUN-DATE
              ) <> 0) OR (LEN(:WS-LAST-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-LAST-RUN-DATE
              ), CONVERT(DATE, :WS-LAST-RUN-DATE) )                
C30169              AND KD.FW_ACTION_AM > 0                             
C30169              AND IZ.WITHDRAW_DT >= IIF(TRY_CONVERT(DATE, 
                                                      :WS-LAST-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-RUN-DATE
              ) <> 0) OR (LEN(:WS-LAST-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-LAST-RUN-DATE
              ), CONVERT(DATE, :WS-LAST-RUN-DATE) )             
C30169              AND IZ.WITHDRAW_REASON_CD = ' '                     
C30169              AND AT.LAST_PYMT_DATE >= KD.FW_ACTION_DT            
C30169              AND AT.LAST_PYMT_DATE <  IIF(TRY_CONVERT(DATE, 
                                                        :WS-1-MONTH-AGO
              ) IS NULL OR (PATINDEX('%.%', :WS-1-MONTH-AGO
              ) <> 0) OR (LEN(:WS-1-MONTH-AGO) <> 10), CIS.CHAR2DATE(
                                                        :WS-1-MONTH-AGO
              ), CONVERT(DATE, :WS-1-MONTH-AGO) ))           
C23973            ))                                                    
C23973         )                                                        
             ORDER BY ACCOUNT_NO                                        
T33185       FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ053
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     03370000
MFA-TR*      DECLARE CHRG_OFF_CURSOR1 CURSOR WITH HOLD FOR              03380000
MFA-TR*      SELECT DISTINCT                                            03390000
MFA-TR*             IZ.CODE_COLLEC_AGNCY,                               03391000
MFA-TR*             IZ.COLL_AGY_SUB_CD,                                 03391000
MFA-TR*             IZ.ACCOUNT_NO,                                      03400000
MFA-TR*             IFNULL(CO.DATE_OF_CHG_OFF,'1900-01-01'),            03420000
MFA-TR*             KD.FW_ACTION_DT,                                    03420000
MFA-TR*             KD.FW_ACTION_AM,                                    03420000
MFA-TR*             IZ.FW_COLL_SEQ_NO,                                  03420000
MFA-TR*             IZ.FW_ACTION_TYPE_CD,                               03420000
MFA-TR*             IZ.WITHDRAW_REASON_CD,                              03440000
MFA-TR*             IZ.WITHDRAW_AM,                                     03440000
MFA-TR*             IZ.WITHDRAW_DT,                                     03440000
MFA-TR*             IFNULL(CO.WO_STATUS,' '),                           03440000
MFA-TR*             AT.COMPANY_NO,                                      03471000
MFA-TR*             AT.LOCAL_OFFICE,                                    03472000
MFA-TR*             AT.CUSTOMER_NO,                                     03473000
MFA-TR*             AT.PREMISE_NO,                                      03474000
MFA-TR*             AT.LAST_PYMT_DATE                                   03474000
MFA-TR*      FROM CSS_ACCOUNT  AT                                       03481000
MFA-TR*          ,CSS_FIN_WO_ACTION KD                                  03481000
MFA-TR*          ,CSS_FIN_WO_COLLECT IZ                                 03481000
MFA-TR*           LEFT OUTER JOIN CSS_CHRG_OFF CO                       03480000
MFA-TR*            ON CO.ACCOUNT_NO = IZ.ACCOUNT_NO                     03490100
MFA-TR*      WHERE                                                      03490000
MFA-TR*         KD.ACCOUNT_NO = AT.ACCOUNT_NO                           03490100
MFA-TR*     AND IZ.ACCOUNT_NO = KD.ACCOUNT_NO                           03490100
MFA-TR*     AND IZ.ACCOUNT_NO > :WS-RESTART-ACCOUNT                     03490100
MFA-TR*     AND AT.COMPANY_NO = :WS-COMPANY-NO                                  
MFA-TR*     AND KD.FW_ACTION_TYPE_CD = IZ.FW_ACTION_TYPE_CD                     
MFA-TR*     AND KD.FW_SEQ_NO         = IZ.FW_COLL_SEQ_NO                        
MFA-TR*     AND KD.FW_ACTION_TYPE_CD IN ('1PLMT','2PLMT','3PLMT','ATY')         
MFA-TR*     AND ((CO.WO_STATUS  = :WS-D                                 03491000
MFA-TR*           AND KD.FW_ACTION_DT <= :WS-LAST-RUN-DATE              03491000
MFA-TR*           AND KD.FW_ACTION_AM > 0                               03491000
MFA-TR*           AND IZ.WITHDRAW_DT > :WS-LAST-RUN-DATE)               03491000
MFA-TR*         OR                                                      03491000
MFA-TR*          (((IZ.WITHDRAW_DT       > :WS-LAST-RUN-DATE            03501000
MFA-TR*             AND IZ.WITHDRAW_REASON_CD = ' ')                   03502000
MFA-TR*                 OR                                              03503000
MFA-TR*            (IZ.WITHDRAW_DT > :WS-LAST-RUN-DATE                  03505000
MFA-TR*             AND IZ.WITHDRAW_DT <= :WS-INPUT-DATE                03508000
MFA-TR*             AND IZ.WITHDRAW_REASON_CD = ' '                     03506000
MFA-TR*             AND KD.FW_ACTION_DT <= :WS-LAST-RUN-DATE                    
MFA-TR*             AND KD.FW_ACTION_AM > 0)                                    
MFA-TR*                 OR                                                      
MFA-TR*            (KD.FW_ACTION_DT <= :WS-LAST-RUN-DATE                        
MFA-TR*             AND KD.FW_ACTION_AM > 0                                     
MFA-TR*             AND IZ.WITHDRAW_DT >= :WS-LAST-RUN-DATE                     
MFA-TR*             AND IZ.WITHDRAW_REASON_CD = ' '                             
MFA-TR*             AND AT.LAST_PYMT_DATE >= KD.FW_ACTION_DT                    
MFA-TR*             AND AT.LAST_PYMT_DATE <  :WS-1-MONTH-AGO)                   
MFA-TR*           ))                                                            
MFA-TR*        )                                                        03509000
MFA-TR*      ORDER BY ACCOUNT_NO                                        03510000
MFA-TR*      FOR FETCH ONLY WITH UR                                     03510000
MFA-TR*    END-EXEC.                                                    03520000
      *                                                                 03530000
           EXEC SQL                                                     
             DECLARE CHRG_OFF_CURSOR2 CURSOR WITH HOLD FOR              
C30169         SELECT                                                   
C30169           IZ.CODE_COLLEC_AGNCY                                   
C30169          ,IZ.COLL_AGY_SUB_CD                                     
C30169          ,IZ.COMPANY_NO                                          
F30169          ,COALESCE(IZ.REG_GROUP_CD,' ')                            
C30169          ,IZ.ACCOUNT_NO                                          
C30169          ,KD.FW_ACTION_DT                                        
C30169          ,KD.FW_ACTION_AM                                        
                ,AT.COMPANY_NO,                                         
                 AT.LOCAL_OFFICE,                                       
                 AT.CUSTOMER_NO,                                        
                 AT.PREMISE_NO                                          
C30169          ,AT.TOTAL_AR_BALANCE                                    
C30169          ,AT.CODE_ACCT_STAT                                      
               FROM                                                     
C30169              CSS_FIN_WO_COLLECT IZ WITH(READUNCOMMITTED)                 
C30169             ,CSS_FIN_WO_ACTION KD WITH(READUNCOMMITTED)                  
C30169             ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                        
               WHERE                                                    
C30169              IZ.ACCOUNT_NO = AT.ACCOUNT_NO                       
C30169          AND IZ.ACCOUNT_NO = KD.ACCOUNT_NO                       
C30169          AND IZ.ACCOUNT_NO > :WS-RESTART-ACCOUNT                 
T23230          AND AT.COMPANY_NO = :WS-COMPANY-NO                      
C30169          AND IZ.FW_ACTION_TYPE_CD IN                             
C30169                            ('1PLMT','2PLMT','3PLMT','ATY')       
C30169          AND IZ.FW_ACTION_TYPE_CD = KD.FW_ACTION_TYPE_CD         
C30169          AND IZ.FW_COLL_SEQ_NO = KD.FW_SEQ_NO                    
C30169          AND (IZ.WITHDRAW_DT = IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )                    
C30169            OR (IZ.WITHDRAW_DT > IIF(TRY_CONVERT(DATE, 
                                                      :WS-LAST-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-RUN-DATE
              ) <> 0) OR (LEN(:WS-LAST-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-LAST-RUN-DATE
              ), CONVERT(DATE, :WS-LAST-RUN-DATE) ))               
F30169            OR (IZ.WITHDRAW_DT IS NULL))                          
C30169          AND KD.FW_ACTION_AM > 0                                 
C30169          AND KD.FW_ACTION_DT <> IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )                   
C26208         ORDER BY IZ.ACCOUNT_NO                                   
T33185       FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     03540000
MFA-TR*      DECLARE CHRG_OFF_CURSOR2 CURSOR WITH HOLD FOR              03550000
MFA-TR*        SELECT                                                   03570000
MFA-TR*          IZ.CODE_COLLEC_AGNCY                                   03570000
MFA-TR*         ,IZ.COLL_AGY_SUB_CD                                     03570000
MFA-TR*         ,IZ.COMPANY_NO                                          03570000
MFA-TR*         ,IFNULL(IZ.REG_GROUP_CD,' ')                            03570000
MFA-TR*         ,IZ.ACCOUNT_NO                                          03580000
MFA-TR*         ,KD.FW_ACTION_DT                                        03590000
MFA-TR*         ,KD.FW_ACTION_AM                                        03590000
MFA-TR*         ,AT.COMPANY_NO,                                         03601000
MFA-TR*          AT.LOCAL_OFFICE,                                       03602000
MFA-TR*          AT.CUSTOMER_NO,                                        03603000
MFA-TR*          AT.PREMISE_NO                                          03604000
MFA-TR*         ,AT.TOTAL_AR_BALANCE                                            
MFA-TR*         ,AT.CODE_ACCT_STAT                                              
MFA-TR*        FROM                                                     03610000
MFA-TR*             CSS_FIN_WO_COLLECT IZ                               03610100
MFA-TR*            ,CSS_FIN_WO_ACTION KD                                03610100
MFA-TR*            ,CSS_ACCOUNT AT                                      03610100
MFA-TR*        WHERE                                                    03611000
MFA-TR*             IZ.ACCOUNT_NO = AT.ACCOUNT_NO                       03611100
MFA-TR*         AND IZ.ACCOUNT_NO = KD.ACCOUNT_NO                       03611100
MFA-TR*         AND IZ.ACCOUNT_NO > :WS-RESTART-ACCOUNT                 03611100
MFA-TR*         AND AT.COMPANY_NO = :WS-COMPANY-NO                              
MFA-TR*         AND IZ.FW_ACTION_TYPE_CD IN                                     
MFA-TR*                           ('1PLMT','2PLMT','3PLMT','ATY')               
MFA-TR*         AND IZ.FW_ACTION_TYPE_CD = KD.FW_ACTION_TYPE_CD                 
MFA-TR*         AND IZ.FW_COLL_SEQ_NO = KD.FW_SEQ_NO                            
MFA-TR*         AND (IZ.WITHDRAW_DT = :WS-INPUT-DATE                    03611300
MFA-TR*           OR (IZ.WITHDRAW_DT > :WS-LAST-RUN-DATE)                       
MFA-TR*           OR (IZ.WITHDRAW_DT IS NULL))                                  
MFA-TR*         AND KD.FW_ACTION_AM > 0                                         
MFA-TR*         AND KD.FW_ACTION_DT <> :WS-INPUT-DATE                   03613000
MFA-TR*        ORDER BY IZ.ACCOUNT_NO                                   03613000
MFA-TR*      FOR FETCH ONLY WITH UR                                     03510000
MFA-TR*    END-EXEC.                                                    03650000
      *                                                                 03660000
           EXEC SQL                                                     
              DECLARE TRN_HST_CURSOR CURSOR WITH HOLD FOR               
               SELECT AMT_ORIG_ENTERED,                                 
                      CODE_TRAN_TYPE,                                   
                      DATE_ORIG_PYMT,                                   
                      AMT_BILLED_UNPAID,                                
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO,                                
                      DATE_TRANS,                                       
                      PYMT_FACILITY_CD                                  
                 FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                   
                WHERE ACCOUNT_NO        = :CO-ACCOUNT-NO                
A02036          AND   TRANS_HIST_SEQ_NO > CIS.CHAR2TIMESTAMP(
                                                        :WS-LAST-TRN-DT
              )               
T15579          AND   DATE_TRANS       <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )                
T15769          AND   CODE_TRAN_TYPE IN ('C', 'P', 'S', 'T', 'I')       
             ORDER BY TRANS_HIST_SEQ_NO ASC                             
T33185       FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     03760000
MFA-TR*       DECLARE TRN_HST_CURSOR CURSOR WITH HOLD FOR               03770000
MFA-TR*        SELECT AMT_ORIG_ENTERED,                                 03780000
MFA-TR*               CODE_TRAN_TYPE,                                   03790000
MFA-TR*               DATE_ORIG_PYMT,                                   03800000
MFA-TR*               AMT_BILLED_UNPAID,                                03820000
MFA-TR*               TRANS_HIST_SEQ_NO,                                03830000
MFA-TR*               DATE_TRANS,                                       03840000
MFA-TR*               PYMT_FACILITY_CD                                  03850000
MFA-TR*          FROM CSS_AR_TRANS_HIST                                 03860000
MFA-TR*         WHERE ACCOUNT_NO        = :CO-ACCOUNT-NO                03870000
MFA-TR*         AND   TRANS_HIST_SEQ_NO > :WS-LAST-TRN-DT               03880000
MFA-TR*         AND   DATE_TRANS       <= :WS-INPUT-DATE                03880101
MFA-TR*         AND   CODE_TRAN_TYPE IN ('C', 'P', 'S', 'T', 'I')       03881011
MFA-TR*      ORDER BY TRANS_HIST_SEQ_NO ASC                             03890000
MFA-TR*      FOR FETCH ONLY WITH UR                                     03510000
MFA-TR*    END-EXEC.                                                    03900000
      *                                                                 03910000
           EXEC SQL                                                     
              DECLARE TRN_HST_DET_CURSOR CURSOR FOR                     
               SELECT AMT_POSTED,                                       
                      GL_ACCT_DEBIT                                     
                 FROM CSS_AR_TRN_HST_DET WITH(READUNCOMMITTED)                  
                WHERE ACCOUNT_NO        = :CO-ACCOUNT-NO                
                AND   TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )         
T33185       FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     03912000
MFA-TR*       DECLARE TRN_HST_DET_CURSOR CURSOR FOR                     03913000
MFA-TR*        SELECT AMT_POSTED,                                       03914000
MFA-TR*               GL_ACCT_DEBIT                                     03915000
MFA-TR*          FROM CSS_AR_TRN_HST_DET                                03919200
MFA-TR*         WHERE ACCOUNT_NO        = :CO-ACCOUNT-NO                03919300
MFA-TR*         AND   TRANS_HIST_SEQ_NO = :AR-TRANS-HIST-SEQ-NO         03919500
MFA-TR*      FOR FETCH ONLY WITH UR                                     03510000
MFA-TR*    END-EXEC.                                                    03919700
      *                                                                 03919800
           EXEC SQL                                                     
              DECLARE RESTORED_ACCT_CSR CURSOR FOR                      
               SELECT ACCOUNT_NO                                        
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE CUSTOMER_NO     = :AT-CUSTOMER-NO                 
                AND   ACCT_CREATE_DT  > CIS.CHAR2TIMESTAMP(
                                                   :WS-LAST-RUN-DATE-TS
              )            
C23972          AND ACCT_CREATE_DT   <= CIS.CHAR2TIMESTAMP(
                                         :WS-RES-DAYS-FROM-PLACEMENT-TS
              )  
T33185       FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     03920000
MFA-TR*       DECLARE RESTORED_ACCT_CSR CURSOR FOR                      03930000
MFA-TR*        SELECT ACCOUNT_NO                                        03940000
MFA-TR*          FROM CSS_ACCOUNT                                       03950000
MFA-TR*         WHERE CUSTOMER_NO     = :AT-CUSTOMER-NO                 03960000
MFA-TR*         AND   ACCT_CREATE_DT  > :WS-LAST-RUN-DATE-TS            03970000
MFA-TR*         AND ACCT_CREATE_DT   <= :WS-RES-DAYS-FROM-PLACEMENT-TS  03980000
MFA-TR*      FOR FETCH ONLY WITH UR                                     03510000
MFA-TR*    END-EXEC.                                                    03990000
      *                                                                 03990100
           EXEC SQL                                                     
              DECLARE PAYMENT_CURSOR CURSOR FOR                         
               SELECT                                                   
                  AMT_ORIG_ENTERED,                                     
                  REPLACE(REPLACE(CONVERT(CHAR(26), TRANS_HIST_SEQ_NO
           , 121), ' ', '-'), ':', '.') TRANS_HIST_SEQ_NO,                     
                  PYMT_FACILITY_CD                                      
               FROM                                                     
                  CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                       
               WHERE ACCOUNT_NO        = :CO-ACCOUNT-NO                 
               AND   DATE_TRANS        = IIF(TRY_CONVERT(DATE, 
                                                     :AR-DATE-ORIG-PYMT
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-ORIG-PYMT
              ) <> 0) OR (LEN(:AR-DATE-ORIG-PYMT
              ) <> 10), CIS.CHAR2DATE(:AR-DATE-ORIG-PYMT
              ), CONVERT(DATE, :AR-DATE-ORIG-PYMT) )             
                AND  CODE_TRAN_TYPE    = 'P'                            
             ORDER BY TRANS_HIST_SEQ_NO ASC                             
T33185       FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     03991000
MFA-TR*       DECLARE PAYMENT_CURSOR CURSOR FOR                         03992000
MFA-TR*        SELECT                                                   03993000
MFA-TR*           AMT_ORIG_ENTERED,                                     03994000
MFA-TR*           TRANS_HIST_SEQ_NO,                                    03995000
MFA-TR*           PYMT_FACILITY_CD                                      03996000
MFA-TR*        FROM                                                     03999100
MFA-TR*           CSS_AR_TRANS_HIST                                     03999200
MFA-TR*        WHERE ACCOUNT_NO        = :CO-ACCOUNT-NO                 03999300
MFA-TR*        AND   DATE_TRANS        = :AR-DATE-ORIG-PYMT             03999400
MFA-TR*         AND  CODE_TRAN_TYPE    = 'P'                            03999500
MFA-TR*      ORDER BY TRANS_HIST_SEQ_NO ASC                             03999600
MFA-TR*      FOR FETCH ONLY WITH UR                                     03510000
MFA-TR*    END-EXEC.                                                    03999700
      *                                                                 04000000
C30169* NEW CURSOR TO LOAD WITHDRAW REASON DESCRIPTIONS                         
C30169     EXEC SQL                                                     
C30169       DECLARE WDRAW-RSN-CSR CURSOR WITH ROWSET POSITIONING FOR   
C30169       SELECT KV.FW_ATTR_VALUE_CD                                 
                   ,KV.FW_ATTR_VALUE_DESC                               
               FROM CSS_FW_ATTRIB_DESC KV WITH(READUNCOMMITTED)                 
               WHERE KV.FW_ATTRIB_TYPE_CD =:KV-FW-ATTRIB-TYPE-CD        
               FOR READ ONLY                                    
C30169     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     03991000
MFA-TR*      DECLARE WDRAW-RSN-CSR CURSOR WITH ROWSET POSITIONING FOR           
MFA-TR*      SELECT KV.FW_ATTR_VALUE_CD                                         
MFA-TR*            ,KV.FW_ATTR_VALUE_DESC                                       
MFA-TR*        FROM CSS_FW_ATTRIB_DESC KV                                       
MFA-TR*        WHERE KV.FW_ATTRIB_TYPE_CD =:KV-FW-ATTRIB-TYPE-CD                
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                    03999700
      *                                                                         
C30169     EXEC SQL                                                     
C30169       DECLARE FIN_COL_HST CURSOR WITH HOLD FOR                   
C30169       SELECT AT.COMPANY_NO,                                      
C30169              AT.LOCAL_OFFICE,                                    
C30169              FM.FW_ACTION_DT,                                    
C30169              FM.FW_ACTION_AM,                                    
C30169              FM.CODE_COLLEC_AGNCY,                               
C30169              FM.FW_ACTION_TYPE_CD,                               
C30169              FM.ACCOUNT_NO,                                      
C30169              FM.WITHDRAW_AM,                                     
F30169              FM.WITHDRAW_DT,                                     
C30169              FM.WITHDRAW_REASON_CD                               
C30169         FROM CSS_FIN_WO_COL_HST FM WITH(READUNCOMMITTED)                 
C30169              ,CSS_ACCOUNT  AT WITH(READUNCOMMITTED)                      
C30169        WHERE FM.ACCOUNT_NO = AT.ACCOUNT_NO                       
C26208          AND AT.COMPANY_NO = :WS-COMPANY-NO                      
C26208          AND FM.ACCOUNT_NO > :WS-RESTART-ACCOUNT                 
C30169          AND FM.FW_HIST_SEQ_TS >= CIS.CHAR2TIMESTAMP(
                                                        :WS-LAST-RUN-DT
              )                
C30169          AND FM.FW_ACTION_TYPE_CD IN ('1PLMT','2PLMT','3PLMT'    
C30169                                       ,'ATY')                    
C30169          AND FM.WITHDRAW_DT BETWEEN IIF(TRY_CONVERT(DATE, 
                                                      :WS-LAST-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-RUN-DATE
              ) <> 0) OR (LEN(:WS-LAST-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-LAST-RUN-DATE
              ), CONVERT(DATE, :WS-LAST-RUN-DATE) ) AND        
C30169                                     IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )               
C30169        ORDER BY FM.ACCOUNT_NO                                    
C30169          FOR READ ONLY                                   
C30169     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE FIN_COL_HST CURSOR WITH HOLD FOR                           
MFA-TR*      SELECT AT.COMPANY_NO,                                      03471000
MFA-TR*             AT.LOCAL_OFFICE,                                    03472000
MFA-TR*             FM.FW_ACTION_DT,                                    03420000
MFA-TR*             FM.FW_ACTION_AM,                                    03420000
MFA-TR*             FM.CODE_COLLEC_AGNCY,                               03391000
MFA-TR*             FM.FW_ACTION_TYPE_CD,                               03420000
MFA-TR*             FM.ACCOUNT_NO,                                              
MFA-TR*             FM.WITHDRAW_AM,                                             
MFA-TR*             FM.WITHDRAW_DT,                                             
MFA-TR*             FM.WITHDRAW_REASON_CD                                       
MFA-TR*        FROM CSS_FIN_WO_COL_HST FM                               03480000
MFA-TR*             ,CSS_ACCOUNT  AT                                    03481000
MFA-TR*       WHERE FM.ACCOUNT_NO = AT.ACCOUNT_NO                               
MFA-TR*         AND AT.COMPANY_NO = :WS-COMPANY-NO                      03490100
MFA-TR*         AND FM.ACCOUNT_NO > :WS-RESTART-ACCOUNT                 03490100
MFA-TR*         AND FM.FW_HIST_SEQ_TS >= :WS-LAST-RUN-DT                        
MFA-TR*         AND FM.FW_ACTION_TYPE_CD IN ('1PLMT','2PLMT','3PLMT'            
MFA-TR*                                      ,'ATY')                            
MFA-TR*         AND FM.WITHDRAW_DT BETWEEN :WS-LAST-RUN-DATE AND                
MFA-TR*                                    :WS-INPUT-DATE                       
MFA-TR*       ORDER BY FM.ACCOUNT_NO                                    03510000
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
HPCCDM*    EJECT                                                                
T23230 LINKAGE SECTION.                                                 
T23230*                                                                         
T23230  01 WS-PARM-VALUE.                                               
T23230     03 WS-PARM-LENGTH                  PIC S9(04) COMP.          
T23230     03 WS-PARMVAL                      PIC X(04).                
T23230*                                                                 04000000
HPCCDM*    EJECT                                                                
      *                                                                 04000000
T23230*PROCEDURE DIVISION.                                              04010000
T23230 PROCEDURE DIVISION USING WS-PARM-VALUE.                          

SCA006        SET WS-GL-SUB TO 1.
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **04020000
      **                                                              **04030000
      **    0000-MAINLINE                                             **04040000
      **                                                              **04050000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **04060000
       0000-MAINLINE.                                                   
      *                                                                 04080000
T10120*    PERFORM 0050-GET-DATES                     THRU 0050-EXIT.   04081000
      *                                                                 04082000
           PERFORM 0200-OPEN-OUTPUT-FILES             THRU 0200-EXIT.   
      *                                                                 04100000
T23230     PERFORM 0300-VALIDATE-PARM                 THRU 0300-EXIT.   
T23230*                                                                 04100000
T23230     PERFORM 0050-GET-DATES                     THRU 0050-EXIT.   
T23230*                                                                 04100000
C26208     PERFORM 6253-GET-FJC01-CHKP-LIMIT          THRU 6253-EXIT.   
C26208     PERFORM 0400-CHECK-RESTART                 THRU 0400-EXIT.   
C30169     PERFORM 0500-GET-DELINQ-VALUES             THRU 0500-EXIT.   
C26208*                                                                         
C26208     IF WS-THIS-IS-A-RESTART AND (((WS-RESTART-PROG-ID = 'RP292'  
C30169                             OR     WS-RESTART-PROG-ID = 'HS292') 
C26208                             AND   WS-RESTART-JOB-STATUS = 'B')   
C26208                                              OR                  
C26208                                  (WS-RESTART-PROG-ID = 'RP275'   
C26208                             AND   WS-RESTART-JOB-STATUS = 'C'))  
C26208        PERFORM 4310-COPY-TO-NEWRP292           THRU 4310-EXIT    
C30169        PERFORM 2030-COPY-TO-NEWCA292           THRU 2030-EXIT    
C26208     END-IF.                                                      
C26208*                                                                 04180000
           PERFORM 1000-CREATE-FRP292                 THRU 1000-EXIT.   
C30169     PERFORM 1100-CREATE-HST-FRP292             THRU 1100-EXIT.   
      *                                                                 04160000
C26208     MOVE 0                     TO WS-CHKP-SEQ-NO                 
C26208                                   WS-RESTART-COMMIT-COUNTER      
C26208                                   WS-TOT-RECS-WRTN               
C26208                                   WS-PREV-ROW-ACCT.              
C26208     PERFORM 0400-CHECK-RESTART                 THRU 0400-EXIT.   
C26208*                                                                         
           PERFORM 1005-CREATE-FRP275                 THRU 1005-EXIT.   
      *                                                                 04280000
           PERFORM 8820-WRITE-CO-END-REC              THRU 8820-EXIT.   
           PERFORM 4300-WRITE-END-CONTROLS            THRU 4300-EXIT.   
      *                                                                 04320100
           PERFORM 8100-UPDATE-JOB-PARM               THRU 8100-EXIT.   
C26208     MOVE WS-SEQ-NO             TO G6-SEQ-NO.                     
C26208     MOVE WS-I                  TO G6-STATUS.                     
C26208     MOVE 'RESTART-REQ=Y'       TO G6-PARM-DATA.                  
C26208     PERFORM 8238-RESET-JOB-PARM                THRU 8238-EXIT.   
C26208     PERFORM 8237-DELETE-RESTART-ROW            THRU 8237-EXIT.   
      *                                                                 04322000
           PERFORM 9000-TERMINATE                     THRU 9000-EXIT.   
      *                                                                 04340000
A01618     IF WS-RETURN-CODE-03 > 0                                     
A01618        MOVE WS-RETURN-CODE-03             TO RETURN-CODE         
A01618     END-IF.                                                      
      *                                                                 04340000
           STOP RUN.                                                    
      *                                                                 04360000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04390000
T10120******************************************************************04391000
      ** 0050-GET-DATES                                               **04392000
      **      OBTAINS RUN-DATE, LAST-RUN-DATE, SYSTEM-DATE            **04393000
      ******************************************************************04393100
       0050-GET-DATES.                                                  
      *                                                                 04394100
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
      *                                                                 04394300
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT         
              MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE                
           END-IF.                                                      
      *                                                                 04394800
           MOVE SPACES      TO WS-SYSIPT.                               
           MOVE WS-PGRMNAME TO WS-PROGRAM.                              
           MOVE WS-PARM     TO WS-COMMAND.                              
           MOVE ZEROS       TO WS-SEQUENCE.                             
T23230     MOVE WS-COMPANY-NO TO G6-COMPANY-NO.                         
C23972     MOVE WS-COMPANY-NO TO C8-COMPANY-NO.                         
                                                                        
           PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
                                                                        
           PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
              UNTIL (WS-INPUT-DATA-BREAKDOWN(1:14) = 'LAST RUN DATE=')  
                  OR  END-OF-SYSIPT.                                    
                                                                        
           EVALUATE TRUE                                                
              WHEN END-OF-SYSIPT                                        
                 DISPLAY '** ABEND IN 0050-GET-DATES              **'   
                 DISPLAY '**  PCSCA275 LAST RUN DATE PARM NOT FOUND **' 
                 PERFORM 9900-ABEND                  THRU 9900-EXIT     
                 DISPLAY ' '                                            
              WHEN OTHER                                                
                 MOVE G6-PARM-DATA       TO WS-PARM-DATA                
                 DISPLAY ' '                                            
                 DISPLAY '**  PCSCA275                              **' 
                 DISPLAY '**  LAST RUN DATE = ' WS-LAST-RUN-DATE        
           END-EVALUATE.                                                
      *                                                                 04397900
C26208     PERFORM 7611-CLOSE                        THRU 7611-EXIT.    
           EXEC SQL                                                     
T33185       SELECT
              DATEADD( MONTH, -1, IIF(TRY_CONVERT(DATE, :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) ) )
            INTO
              :WS-1-MONTH-AGO     
T33185     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     04399900
MFA-TR*      SET :WS-1-MONTH-AGO = (DATE(:WS-INPUT-DATE) - 1 MONTH)     04400100
MFA-TR*    END-EXEC.                                                    04400400

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 04400500
T33185     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T33185*                                                                 04400500
T33185     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T33185         CONTINUE                                                 
T33185     ELSE                                                         
T33185         DISPLAY '*** ABEND IN ABEND IN 0050-GET-DATES ***'       
T33185         DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
C30169         DISPLAY 'INPUT DATE = ' WS-INPUT-DATE                    
T33185         PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 04400500
       0050-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04400800
      ******************************************************************05050000
      **  0200-OPEN-OUTPUT-FILES ..                                   **05060000
      **       OPENS OUTPUT FILES FIORP275 FCSRP292                   **05070000
      **                                                              **05080000
      ******************************************************************05090000
       0200-OPEN-OUTPUT-FILES.                                          
      *                                                                 05110000
           OPEN OUTPUT FCSRP275-FILE.                                   
      *                                                                 05130000
           IF FRP275-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '0200-ERROR ON FIORP275 OPEN.  STATUS IS '       
                        WS-FRP275-STATUS                                
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 05210000
C30169     OPEN OUTPUT FCSCA292-FILE.                                   
C30169*                                                                 05130000
C30169     IF FCA292-SUCCESSFUL                                         
C30169         CONTINUE                                                 
C30169     ELSE                                                         
C30169         DISPLAY '0200-ERROR ON FIOCA292 OPEN.  STATUS IS '       
C30169                  WS-FCA292-STATUS                                
C30169         PERFORM 9900-ABEND THRU 9900-EXIT                        
C30169     END-IF.                                                      
           OPEN OUTPUT FCSRP292-FILE.                                   
      *                                                                 05230000
           IF FRP292-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '0200-ERROR ON FCSRP292 OPEN.  STATUS IS '       
                        WS-FRP292-STATUS                                
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 05400000
A01618     OPEN OUTPUT FCSCM275-FILE.                                   
A01618     IF FCM275-SUCCESSFUL                                         
A01618         NEXT SENTENCE                                            
A01618     ELSE                                                         
A01618         DISPLAY ' '                                              
A01618         DISPLAY '**  PCSCA275 PROCESSING ERROR             **'   
A01618         DISPLAY '**    OPEN ERROR OF FCSCM275 - OUTPUT FILE'     
A01618         DISPLAY '**    FILE STATUS = ' WS-FCM275-STATUS          
A01618         DISPLAY '**  PROCESSING TERMINATED                 **'   
A01618         PERFORM 9900-ABEND           THRU 9900-EXIT              
A01618     END-IF.                                                      
      *                                                                 05400000
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05430000
T23230******************************************************************05431000
T23230*                                                                 05433000
T23230* 0300-VALIDATE-PARM                                              05432000
T23230*                                                                 05433000
T23230******************************************************************05434000
T23230 0300-VALIDATE-PARM.                                              
T23230*                                                                         
T23230     IF WS-PARM-LENGTH = 0                                        
T23230       DISPLAY '************* PCSCA275 *********************'     
T23230       DISPLAY '* NO PARM VALUE FOUND                      *'     
T23230      DISPLAY '* VALID PARM VALUES ARE ''SCEG'',''PSNC''&''SEB''*'
T23230       DISPLAY '************* PCSCA275 *********************'     
T23230        PERFORM 9900-ABEND                   THRU 9900-EXIT       
T23230     END-IF.                                                      
T23230*                                                                 05435000
T23230     INSPECT WS-PARMVAL REPLACING ALL LOW-VALUES BY SPACES.       
T23230     IF WS-PARMVAL = 'SCEG'                                       
T23230           SET SCEG               TO TRUE                         
T23230           MOVE '01'              TO WS-COMPANY-NO                
T23230                                     WS-P-COMPANY-NO              
T23230     ELSE                                                         
T23230        IF WS-PARMVAL = 'SEB ' OR 'SEB'                           
T23230              SET SEB             TO TRUE                         
T23230              MOVE '01'           TO WS-COMPANY-NO                
T23230                                     WS-P-COMPANY-NO              
T23230        ELSE                                                      
T23230           IF WS-PARMVAL = 'PSNC'                                 
T23230                 SET PSNC         TO TRUE                         
T23230                 MOVE '26'        TO WS-COMPANY-NO                
T23230                                     WS-P-COMPANY-NO              
T23230           ELSE                                                   
T23230            DISPLAY '************* PCSCA275 *********************'
T23230            DISPLAY '* NOT A VALID PARM                         *'
T23230            DISPLAY '* VALID PARM VALUES ARE ''SCEG'','                   
T23230-           '''PSNC''&''SEB''*'                                           
T23230            DISPLAY '************* PCSCA275 *********************'
T23230            PERFORM 9900-ABEND                   THRU 9900-EXIT   
T23230           END-IF                                                 
T23230        END-IF                                                    
T23230     END-IF.                                                      
T23230*                                                                 05435000
T23230 0300-EXIT.                                                       
T23230     EXIT.                                                        
T23230*                                                                 05435000
C26208******************************************************************05431000
C26208* 0400-CHECK-RESTART                                             *05431000
C26208******************************************************************05431000
C26208 0400-CHECK-RESTART.                                              
C26208*                                                                 05431000
C26208     MOVE PROGRAM-NAME               TO RF-NAME-PROGRAM.          
C26208     MOVE 1                          TO RF-PARTITION-NO           
C26208                                        RF-DUP-CNTRL-NO.          
C26208     PERFORM 7050-SELECT-RESTART               THRU 7050-EXIT.    
C26208     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C26208        MOVE RF-RESTART-DATA-TEXT    TO WS-RESTART-DATA           
C26208        IF WS-RESTART-PROCESS-TYPE NUMERIC                        
C26208           MOVE WS-Y                 TO WS-IS-THIS-A-RESTART      
C26208        END-IF                                                    
C26208     END-IF.                                                      
C26208*                                                                 05431000
C26208 0400-EXIT.                                                       
C26208     EXIT.                                                        
C26208*                                                                 05431000
C30169*                                                                         
C30169  0500-GET-DELINQ-VALUES.                                         
C30169*                                                                         
           MOVE 'NO-FIN-ACTIVITY'            TO C8-DELINQ-CD.           
           PERFORM 7920-GET-DELINQ-VALUE     THRU 7920-EXIT.            
           MOVE C8-DELINQ-VALUE              TO WS-DELINQ-DAYS-NO-FA.   
           MOVE 'FULL-PYMT-DAYS'             TO C8-DELINQ-CD.           
           PERFORM 7920-GET-DELINQ-VALUE     THRU 7920-EXIT.            
           MOVE C8-DELINQ-VALUE              TO WS-DELINQ-DAYS-FPLMT.   
C30169*                                                                         
C30169 0500-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
      ******************************************************************05431000
      * 0700-LOAD-GL-NO-VALUES                                          05432000
      *                                                                 05433000
      ******************************************************************05434000
      *                                                                 05435000
T24436*COPY CPD00061.                                                   05436000
      *                                                                 05437000
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **05440000
      **                                                              **05450000
      **    1000-CREATE-FRP292                                        **05460000
      **                                                              **05470000
      ** EXTRACTS CHARGE OFF ACCOUNTS THAT HAVE A WRITE-OFF STATUS    **05480000
      ** OF 'WITHDRAW' AND A NULL WITHDRAW DATE.                      **05490000
      **                                                              **05500000
      ** EACH ACCOUNT CAN HAVE MULTIPLE ROWS AND THE VALUES           **05510000
      ** PLACED AMOUNT AND WITHDRAWN BALANCE ARE SUMMED FOR EACH      **05520000
      ** ACCOUNT.                                                     **05530000
      **                                                              **05540000
      ** EACH ACCOUNT NO CAN ONLY BE ASSIGNED TO ONE COLLECTION       **05550000
      ** AGENCY.                                                      **05560000
      **                                                              **05570000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **05580000
      *                                                                 05581000
       1000-CREATE-FRP292.                                              
      *                                                                 05590100
           INITIALIZE COMPANY-END-REC-DATA.                             
      *                                                                 05590300
T24436     MOVE PROGRAM-NAME                  TO                        
T24436                                        WS-CPD00061-CALLING-PGM.  
T24436     MOVE SPACES                        TO  ABEND-FUNCTION.       
T24436     CALL SCSCB061  USING   WS-GL-ACCT-NAME,                      
T24436                            WS-GL-ACCT-MAJOR-FIELDS,              
T24436                            WS-VALID-COMPANY-NOS,                 
T24436                            WS-GL-NAME-INFO,                      
T24436                            WS-GL-ACCT-NO-TABLE,                  
T24436                            WS-CPD00061-CALLING-PGM,              
T24436                            ABEND-FILE,                           
T24436                            RS-RETURN-CODE.                       
T24436                                                                  
T24436     IF ABEND-FUNCTION  > SPACES                                  
T24436        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
T24436     END-IF.                                                      
C26208     INITIALIZE WS-SYSIPT                                         
C26208     PERFORM 6235-GET-FJC01-RESTART-REQ         THRU 6235-EXIT    
C26208     MOVE G6-SEQ-NO                     TO WS-SEQ-NO              
C26208     INITIALIZE WS-SYSIPT                                         
C26208     MOVE WS-RESTART-ACCT-NO            TO WS-RESTART-ACCOUNT     
C26208*                                                                         
C26208*    IF RP292 HAS ABENDED, IT'S NAMED AS RP292R IN THE RESTART            
C26208*    RP292R IS COPIED TO RP292.                                           
C26208     IF WS-THIS-IS-A-RESTART AND WS-RESTART-PROG-ID NOT = 'RP292' 
C26208        GO TO 1000-EXIT                                           
C26208     END-IF.                                                      
C26208*    TO CHECK IF RP292 HAS COMPLETED                                      
C26208     IF WS-THIS-IS-A-RESTART AND WS-RESTART-JOB-STATUS = 'B'      
C26208        GO TO 1000-EXIT                                           
C26208     END-IF.                                                      
C26208     IF WS-THIS-IS-A-RESTART AND WS-RESTART-PROG-ID = 'RP292'     
C26208        DISPLAY '** THIS IS A RESTART OF PCSCA275 - FCSRP292 **'  
C26208        DISPLAY '**********************************************'  
C26208        PERFORM 4100-WRITE-BEGIN-CONTROLS       THRU 4100-EXIT    
C26208        PERFORM 4110-PROCESS-FCSRP292           THRU 4110-EXIT    
C30169        PERFORM 2050-PROCESS-FCSCA292           THRU 2050-EXIT    
C26208     ELSE                                                         
C26208        PERFORM 4100-WRITE-BEGIN-CONTROLS       THRU 4100-EXIT    
C26208     END-IF.                                                      
      *                                                                 05590600
           PERFORM 7000-OPEN-CHRG-OFF-CURSOR1         THRU 7000-EXIT.   
      *                                                                 05591400
           PERFORM 7010-FETCH-CHRG-OFF-CURSOR1        THRU 7010-EXIT.   
      *                                                                 05591600
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
               DISPLAY '*** NO CHARGE OFF ACCOUNTS MEET THE ***'        
               DISPLAY '*** EXTRACTION CRITERIA FOR FCSRP292 ***'       
               MOVE 'Y'       TO FLG-EMPTY-FILE                         
           END-IF.                                                      
      *                                                                 05592200
C26208     MOVE 'RP292'                    TO WS-RESTART-PROG-ID        
C26208     DISPLAY '***  COMMITS FOR FCSRP292  ***'                     
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
C23973*      DO NOT PROCESS PSNC ACCTS LISTED PRIOR TO CONVERSION               
C30169       MOVE IZ-ACCOUNT-NO            TO CO-ACCOUNT-NO             
                PERFORM 3510-MOVE-DAT-TO-HOLD          THRU 3510-EXIT   
      *                                                                 05592600
                MOVE KD-FW-ACTION-DT       TO  WS-DATE-LISTED           
      *                                                                 05592800
                MOVE WS-DATE-LISTED(6:2)   TO  WS-WO-MONTH              
                MOVE WS-DATE-LISTED(1:4)   TO  WS-WO-YEAR               
      *                                                                 05593100
                MOVE WS-WO-DATE            TO WS-WO-MONTH-YR            
      *                                                                 05593300
                PERFORM 7700-SELECT-WRITE-OFF-BAL      THRU 7700-EXIT   
C30169          MOVE KD-FW-ACTION-AM       TO WS-PLACED-AMOUNT          
      *                                                                 05593500
C30169          MOVE KD-FW-ACTION-AM       TO WS-PLACED-AMOUNT          
                MOVE WS-WRITE-OFF-BAL      TO WS-WITHDRAWN-BAL          
C30169* IF THE ACCT WAS MANUALLY WITHDRAWN USE AMT ON THAT DAY AS               
C30169* WITHDRAW BALANCE                                                        
C30169          IF IZ-WITHDRAW-REASON-CD > SPACES                       
C30169             MOVE IZ-WITHDRAW-AM     TO WS-WITHDRAWN-BAL          
C30169             MOVE 'N'                TO WS-UPDT-WDRAW-DT-FL       
C30169          ELSE                                                    
C30169             MOVE WS-WITHDRAWN-BAL   TO IZ-WITHDRAW-AM            
C30169             MOVE 'Y'                TO WS-UPDT-WDRAW-DT-FL       
C30169          END-IF                                                  
C30169          IF  IZ-WITHDRAW-DT > WS-LAST-RUN-DATE                   
C30169              AND IZ-WITHDRAW-DT <=  WS-INPUT-DATE                
C30169             IF WS-WITHDRAWN-BAL NOT EQUAL WS-PLACED-AMOUNT       
C30169                IF WS-WITHDRAWN-BAL > 0                           
C30169                   IF IZ-WITHDRAW-REASON-CD = SPACES              
C30169                       MOVE WS-EXPIRED-STATUS TO                  
C30169                            IZ-WITHDRAW-REASON-CD                 
C30169                   END-IF                                         
C30169                ELSE                                              
C30169                  IF IZ-WITHDRAW-REASON-CD = SPACES               
C30169                     MOVE WS-PAID-STATUS  TO IZ-WITHDRAW-REASON-CD
C30169                  END-IF                                          
C30169                END-IF                                            
C23973             ELSE                                                 
C23973                IF WS-WITHDRAWN-BAL = WS-PLACED-AMOUNT            
C30169                   IF IZ-WITHDRAW-REASON-CD = SPACES              
C23973                      MOVE WS-NO-ACTIVITY-STATUS TO               
C30169                                   IZ-WITHDRAW-REASON-CD          
C30169                   END-IF                                         
C23973                   MOVE 'Y'             TO WS-NO-ACTIVITY-FLAG    
C23973                END-IF                                            
C23973             END-IF                                               
C23973          END-IF                                                  
C23973          IF   (IZ-WITHDRAW-REASON-CD = ' '        AND            
C23973                AT-LAST-PYMT-DATE >= KD-FW-ACTION-DT AND          
C23973                AT-LAST-PYMT-DATE <  WS-1-MONTH-AGO        AND    
C23973                WS-WITHDRAWN-BAL = 0)                             
C30169             MOVE WS-PAID-STATUS  TO IZ-WITHDRAW-REASON-CD        
C23973          END-IF                                                  
C23973*                                                                         
C23973          IF CO-WO-STATUS EQUAL WS-TRANSFERRED-STATUS             
C30169          AND IZ-WITHDRAW-REASON-CD = SPACES                      
C30169             MOVE WS-TRANSFERRED-STATUS TO IZ-WITHDRAW-REASON-CD  
C23973          END-IF                                                  
C23973*                                                                         
C30169          MOVE IZ-WITHDRAW-REASON-CD TO  WS-H-CHG-WITHDRAW-REASN  
C30169          IF WS-NO-ACTIVITY-FLAG = 'Y' OR IZ-WITHDRAW-REASON-CD   
C23973                                                 > ' '            
C23973             IF CO-WO-STATUS EQUAL WS-TRANSFERRED-STATUS          
C30169                CONTINUE                                          
C23973             ELSE                                                 
C30169                IF CO-DATE-OF-CHG-OFF > SPACES                    
                         PERFORM 8000-UPDATE-CHRG-OFF  THRU 8000-EXIT   
C30169                END-IF                                            
C23973             END-IF                                               
C30169             IF WS-UPDT-WDRAW-DT-FL = 'Y'                         
C30169                MOVE WS-INPUT-DATE               TO IZ-WITHDRAW-DT
C30169             END-IF                                               
C30169             PERFORM 8020-UPDATE-FIN-WO-COLLECT  THRU 8020-EXIT   
                   PERFORM 3500-MOVE-TO-PRINT          THRU 3500-EXIT   
C30169             MOVE CO-ACCOUNT-NO      TO FW-ACCOUNT-NO             
C30169             PERFORM 2000-CREATE-WITHDRAW-FILE   THRU 2000-EXIT   
C26208*                                                                         
C26208             ADD 1                   TO WS-RESTART-COMMIT-COUNTER 
C26208             ADD 1                   TO WS-TOT-RECS-WRTN          
C26208*  COMMIT IS TAKEN WHEN THE COUNTER = CHKP LOWER/UPPER LIMIT              
C26208*  OR WHENT THE ACCT HAS MULTIPLE ROWS TO BE WRITTEN TO THE FILE          
C26208             IF WS-RESTART-COMMIT-COUNTER = WS-CHKP-LUW-LIMIT     
C26208                 OR WS-RESTART-COMMIT-COUNTER = WS-CHKP-UPD-LIMIT 
C26208                 OR CO-ACCOUNT-NO = WS-PREV-ROW-ACCT              
C26208                ADD  1               TO WS-CHKP-SEQ-NO            
C26208                PERFORM 8915-COMMIT              THRU 8915-EXIT   
C26208                MOVE 0               TO WS-RESTART-COMMIT-COUNTER 
C26208             END-IF                                               
C23973          END-IF                                                  
C23973       MOVE 'N'                      TO WS-NO-ACTIVITY-FLAG       
C26208       MOVE CO-ACCOUNT-NO            TO WS-PREV-ROW-ACCT          
      *                                                                 05594200
             PERFORM 7010-FETCH-CHRG-OFF-CURSOR1       THRU 7010-EXIT   
      *                                                                 05594400
           END-PERFORM.                                                 
C26208     MOVE WS-B                       TO WS-RESTART-JOB-STATUS.    
C26208     MOVE WS-RESTART-DATA            TO RF-RESTART-DATA-TEXT.     
C26208     MOVE WS-RESTART-DATA-LENGTH     TO RF-RESTART-DATA-LEN.      
C26208     PERFORM 8235-WRITE-RESTART                 THRU 8235-EXIT.   
C26208     PERFORM 8917-ISSUE-CHKP                    THRU 8917-EXIT.   
C26208     DISPLAY '*** EXTRACT FOR FCSRP292 COMPLETED ***'.            
C26208     DISPLAY '                  '.                                
      *                                                                 05750000
           PERFORM 7020-CLOSE-CHRG-OFF-CURSOR1        THRU 7020-EXIT.   
      *                                                                 05770000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05840000
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **05850000
      **                                                              **05860000
      **    1005-CREATE-FRP275                                        **05870000
      **                                                              **05880000
      ** EXTRACTS TRANSACTIONS ON CHARGE OFF ACCOUNTS THAT HAVE BEEN  **05890000
      ** ASSIGNED TO A COLLECTION AGENCY SINCE THE LAST PROGRAM RUN   **05900000
      **                                                              **05910000
      ** COMMISSION AND NON-COMMISSION AMOUNTS ARE DETERMINED FOR     **05920000
      ** EACH TRANSACTION AND WRITTEN TO THE FILE.                    **05930000
      ** SINCE THE LAST PROGRAM RUN DATE.                             **05940000
      **                                                              **05950000
      ** MULTIPLE ROWS CAN EXIST FOR EACH CHARGE OFF ACCOUNT IN THE   **05960000
      ** CHARGE OFF TABLE.                                            **05970000
      **                                                              **05980000
      ** MULTIPLE TRANSACTIONS CAN EXIST FOR EACH CHARGE OFF ACCOUNT  **05990000
      ** IN THE CSS_AR_TRANS_HIST TABLE.                              **06000000
      **                                                              **06010000
      ** MULTIPLE TRANSACTION DETAIL ROWS CAN EXIST FOR EACH          **06020000
      ** TRANSACTION IN THE CSS_AR_TRANS_HIST TABLE.                  **06030000
      **                                                              **06040000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **06050000
      *                                                                 06051000
       1005-CREATE-FRP275.                                              
      *                                                                 06070000
           MOVE 'Y'           TO FLG-FRP275.                            
      *                                                                 06071100
           INITIALIZE COMPANY-END-REC-DATA.                             
      *                                                                 06073000
C26208     IF WS-THIS-IS-A-RESTART AND WS-RESTART-PROG-ID = 'RP275'     
C26208                             AND WS-RESTART-JOB-STATUS = 'C'      
C26208        DISPLAY '** THIS IS A RESTART OF PCSCA275 - FCSRP275 **'  
C26208        DISPLAY '**********************************************'  
C26208        PERFORM 4105-WRITE-BEGIN-CONTROLS       THRU 4105-EXIT    
C26208        PERFORM 4555-PROCESS-FCSRP275           THRU 4555-EXIT    
C26208        MOVE WS-RESTART-ACCT-NO TO WS-RESTART-ACCOUNT             
C26208     ELSE                                                         
C26208        MOVE 0                  TO WS-RESTART-CHKP-SEQ-NO         
C26208                                   WS-RESTART-ROW-CNT             
C26208                                   WS-RESTART-ACCT-NO             
C26208                                   WS-RESTART-ACCOUNT             
C26208        PERFORM 4105-WRITE-BEGIN-CONTROLS       THRU 4105-EXIT    
C26208     END-IF.                                                      
C26208     DISPLAY '***  COMMITS FOR FCSRP275  ***'                     
C26208     MOVE 'RP275'               TO WS-RESTART-PROG-ID             
      *                                                                 06075000
           PERFORM 7300-OPEN-CHRG-OFF-CURSOR2         THRU 7300-EXIT.   
      *                                                                 06077000
           PERFORM 7400-FETCH-CHRG-OFF-CURSOR2        THRU 7400-EXIT.   
      *                                                                 06079000
           PERFORM 4350-PROCESS-CHRG-OFF-ACT          THRU 4350-EXIT    
               UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.             
      *                                                                 06100000
           PERFORM 7500-CLOSE-CHRG-OFF-CURSOR2        THRU 7500-EXIT.   
C26208     DISPLAY '*** EXTRACT FOR FCSRP275 COMPLETED ***'.            
      *                                                                 06360000
       1005-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06390000
C30169*                                                                         
C30169******************************************************************05431000
C30169* 1100-CREATE-HST-FRP292                                         *05432000
C30169******************************************************************05434000
C30169 1100-CREATE-HST-FRP292.                                          
C30169*                                                                 05590100
C30169     INITIALIZE COMPANY-END-REC-DATA.                             
C30169*                                                                 05590300
C30169     INITIALIZE WS-SYSIPT                                         
C30169     PERFORM 6235-GET-FJC01-RESTART-REQ         THRU 6235-EXIT    
C30169     MOVE G6-SEQ-NO                     TO WS-SEQ-NO              
C30169     INITIALIZE WS-SYSIPT                                         
C30169     MOVE WS-RESTART-ACCT-NO            TO WS-RESTART-ACCOUNT     
C30169*                                                                         
C30169*    IF RP292 HAS ABENDED, IT'S NAMED AS RP292R IN THE RESTART            
C30169*    RP292R IS COPIED TO RP292.                                           
C30169     IF WS-THIS-IS-A-RESTART AND WS-RESTART-PROG-ID NOT = 'HS292' 
C30169        GO TO 1100-EXIT                                           
C30169     END-IF.                                                      
C30169*    TO CHECK IF RP292 HAS COMPLETED                                      
C30169     IF WS-THIS-IS-A-RESTART AND WS-RESTART-JOB-STATUS = 'B'      
C30169        GO TO 1100-EXIT                                           
C30169     END-IF.                                                      
C30169     IF WS-THIS-IS-A-RESTART AND WS-RESTART-PROG-ID = 'HS292'     
C30169        DISPLAY '** THIS IS A RESTART OF PCSCA275 - FCSRP292 **'  
C30169        DISPLAY '**********************************************'  
C30169        PERFORM 4110-PROCESS-FCSRP292           THRU 4110-EXIT    
C30169        PERFORM 2050-PROCESS-FCSCA292           THRU 2050-EXIT    
C30169     ELSE                                                         
C30169        INITIALIZE WS-RESTART-ACCOUNT                             
C30169     END-IF.                                                      
C30169*                                                                 05590600
C30169     PERFORM 5100-CALC-LAST-RUN-DT              THRU 5100-EXIT.   
C30169*                                                                         
C30169     PERFORM 7060-OPEN-FIN-COL-HST              THRU 7060-EXIT.   
C30169*                                                                 05591400
C30169     PERFORM 7070-FETCH-FIN-COL-HST             THRU 7070-EXIT.   
C30169*                                                                 05591600
C30169     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
C30169         DISPLAY '*** NO CHARGE OFF ACCOUNTS MEET THE ***'        
C30169         DISPLAY '*** EXTRACTION CRITERIA FROM ****'              
C30169         DISPLAY '*** CSS_FIN_WO_COL_HST FOR FCSRP292 ***'        
C30169         MOVE 'Y'       TO FLG-EMPTY-FILE                         
C30169     END-IF.                                                      
C30169*                                                                 05592200
C30169     MOVE 'HS292'                    TO WS-RESTART-PROG-ID        
C30169     DISPLAY '***  COMMITS FOR FCSRP292  ***'                     
C30169*                                                                         
C30169     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
C30169          PERFORM 3550-MOVE-DAT-TO-HOLD         THRU 3550-EXIT    
C30169          MOVE FM-FW-ACTION-AM       TO WS-PLACED-AMOUNT          
C30169          MOVE FM-WITHDRAW-AM        TO WS-WRITE-OFF-BAL          
C30169          MOVE WS-WRITE-OFF-BAL      TO WS-WITHDRAWN-BAL          
C30169          MOVE FM-WITHDRAW-REASON-CD TO WS-H-CHG-WITHDRAW-REASN   
C30169          PERFORM 3560-MOVE-TO-PRINT            THRU 3560-EXIT    
C30169          PERFORM 2005-CREATE-HST-WITHDRAW-FILE THRU 2005-EXIT    
C30169*                                                                         
C30169             ADD 1                   TO WS-RESTART-COMMIT-COUNTER 
C30169             ADD 1                   TO WS-TOT-RECS-WRTN          
C30169*  COMMIT IS TAKEN WHEN THE COUNTER = CHKP LOWER/UPPER LIMIT              
C30169*  OR WHENT THE ACCT HAS MULTIPLE ROWS TO BE WRITTEN TO THE FILE          
C30169             IF WS-RESTART-COMMIT-COUNTER = WS-CHKP-LUW-LIMIT     
C30169                 OR WS-RESTART-COMMIT-COUNTER = WS-CHKP-UPD-LIMIT 
C30169                 OR FM-ACCOUNT-NO = WS-PREV-ROW-ACCT              
C30169                ADD  1               TO WS-CHKP-SEQ-NO            
C30169                MOVE FM-ACCOUNT-NO   TO CO-ACCOUNT-NO             
C30169                PERFORM 8915-COMMIT             THRU 8915-EXIT    
C30169                MOVE 0               TO WS-RESTART-COMMIT-COUNTER 
C30169             END-IF                                               
C30169          MOVE FM-ACCOUNT-NO            TO WS-PREV-ROW-ACCT       
C30169          PERFORM 7070-FETCH-FIN-COL-HST        THRU 7070-EXIT    
C30169     END-PERFORM.                                                 
C30169*                                                                         
C30169     MOVE WS-B                       TO WS-RESTART-JOB-STATUS.    
C30169     MOVE WS-RESTART-DATA            TO RF-RESTART-DATA-TEXT.     
C30169     MOVE WS-RESTART-DATA-LENGTH     TO RF-RESTART-DATA-LEN.      
C30169     PERFORM 8235-WRITE-RESTART                 THRU 8235-EXIT.   
C30169     PERFORM 8917-ISSUE-CHKP                    THRU 8917-EXIT.   
C30169     DISPLAY '*** EXTRACT FOR FCSRP292 FROM CSS_FIN_WO_COL_HST *' 
C30169     DISPLAY '*** COMPLETE  ************************************' 
C30169     DISPLAY '                  '.                                
C30169*                                                                 05750000
C30169     PERFORM 7080-CLOSE-FIN-COL-HST             THRU 7080-EXIT.   
C30169                                                                  
C30169     PERFORM 8820-WRITE-CO-END-REC              THRU 8820-EXIT.   
C30169     PERFORM 4200-WRITE-END-CONTROLS            THRU 4200-EXIT.   
C30169*                                                                         
C30169 1100-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
C30169******************************************************************06390000
C30169**  2000-CREATE-WITHDRAW-FILE.                                  **        
C30169**  PRODUCES OUTPUT FILE TO BE SENT TO AGENCY.                  **        
C30169******************************************************************06390000
       2000-CREATE-WITHDRAW-FILE.                                       
C30169*                                                                         
C30169     MOVE 'W'        TO E-FCA292-REC-TYPE                         
C30169     PERFORM 8920-WRITE-FCSCA292                                  
C30169        THRU 8920-EXIT                                            
C30169     EVALUATE IZ-FW-ACTION-TYPE-CD                                
C30169         WHEN '1PLMT'                                             
C30169             MOVE 'G'       TO FW-COLLECT-STATUS-CD               
C30169         WHEN '2PLMT'                                             
C30169             MOVE 'I'       TO FW-COLLECT-STATUS-CD               
C30169         WHEN '3PLMT'                                             
C30169             MOVE 'K'       TO FW-COLLECT-STATUS-CD               
C30169         WHEN 'ATY'                                               
C30169             MOVE 'E'       TO FW-COLLECT-STATUS-CD               
C30169     END-EVALUATE                                                 
C30169     PERFORM 8030-UPDATE-FW-COLLECT-STATUS                        
C30169        THRU 8030-EXIT.                                           
C30169*                                                                         
C30169 2000-EXIT.                                                       
C30169     EXIT.                                                        
C30169******************************************************************06390000
C30169**  2005-CREATE-HST-WITHDRAW-FILE                               **        
C30169**  PRODUCES OUTPUT FILE TO BE SENT TO AGENCY.                  **        
C30169******************************************************************06390000
C30169 2005-CREATE-HST-WITHDRAW-FILE.                                   
C30169*                                                                         
C30169     MOVE 'W'        TO E-FCA292-REC-TYPE.                        
C30169     PERFORM 8920-WRITE-FCSCA292                                  
C30169        THRU 8920-EXIT.                                           
C30169*                                                                         
C30169 2005-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
       2010-LOAD-WITHDRAW-REASON.                                       
      *                                                                         
           MOVE 'WD' TO KV-FW-ATTRIB-TYPE-CD                            
           PERFORM 7030-OPEN-WDRAW-RSN-CSR           THRU 7030-EXIT.    
           PERFORM 7035-FETCH-WDRAW-RSN-CSR          THRU 7035-EXIT.    
           SET WS-RANGE-INDEX     TO 1.                                 
           MOVE   1               TO WS-INDEX                           
           PERFORM 2020-LOAD-WITHDRAW-RSN-TBL        THRU 2020-EXIT     
             UNTIL WS-INDEX > WS-WDRAW-ROW-COUNT                        
                OR WS-FW-ATTR-VALUE-CD (WS-INDEX) = SPACES              
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               INITIALIZE WS-MISC-HOST-VARIABLES                        
               PERFORM 7035-FETCH-WDRAW-RSN-CSR      THRU 7035-EXIT     
               MOVE   1           TO WS-INDEX                           
               PERFORM 2020-LOAD-WITHDRAW-RSN-TBL    THRU 2020-EXIT     
                 UNTIL WS-INDEX > WS-WDRAW-ROW-COUNT                    
                    OR WS-FW-ATTR-VALUE-CD(WS-INDEX) = SPACES           
           END-IF.                                                      
           PERFORM 7040-CLOSE-WDRAW-RSN-CSR          THRU 7040-EXIT.    
      *                                                                         
       2010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C30169 2020-LOAD-WITHDRAW-RSN-TBL.                                      
      *                                                                         
           MOVE WS-FW-ATTR-VALUE-CD(WS-INDEX)  TO                       
                               WS-WITHDRAW-RSN-CD(WS-RANGE-INDEX)       
           MOVE WS-FW-ATTR-VALUE-DESC(WS-INDEX) TO                      
                               WS-WITHDRAW-RSN-DESC(WS-RANGE-INDEX)     
           ADD 1           TO WS-INDEX.                                 
           SET WS-RANGE-INDEX UP BY 1.                                  
      *                                                                         
C30169 2020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C30169* RESTART FOR WITHDRAW FILE                                               
C30169******************************************************************08440000
C30169* 2030-COPY-TO-NEWCA292                                           08440000
C30169* DURING RESTART RUN, COPY THE ENTIRE DATA FROM FILE FCSCA292     08440000
C30169* TO FILE NEWCA292.                                               08440000
C30169******************************************************************08440000
C30169 2030-COPY-TO-NEWCA292.                                           
      *                                                                 08440000
           OPEN INPUT FCA292R-FILE.                                     
           IF FCA292R-SUCCESSFUL                                        
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*** 2030-ERROR IN FCA292R OPEN ***'              
              DISPLAY '*** FILE STATUS = ' WS-FCA292R-STATUS            
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
           PERFORM 2040-READ-WRITE-CA292              THRU 2040-EXIT    
               UNTIL FCSCA292-END.                                      
           CLOSE FCA292R-FILE.                                          
      *                                                                         
C30169 2030-EXIT.                                                       
C30169     EXIT.                                                        
      *                                                                         
C30169******************************************************************08440000
C30169* 2040-READ-WRITE-CA292                                           08440000
C30169* READ THE RECORDS FROM FCSCA292 AND WRITE INTO NEWCA292          08440000
C30169******************************************************************08440000
C30169 2040-READ-WRITE-CA292.                                           
           READ FCA292R-FILE INTO FIOCA292                              
              AT END                                                    
                 SET FCSCA292-END         TO TRUE                       
              NOT AT END                                                
                 IF FCA292R-SUCCESSFUL                                  
                    WRITE FIOCA292                                      
                    IF FCA292-SUCCESSFUL                                
                       CONTINUE                                         
                    ELSE                                                
                       DISPLAY '*** 2040-ERROR ON FCSCA292 WRITE ***'   
                       DISPLAY '*** FILE STATUS = ' WS-FCA292-STATUS    
                       PERFORM 9900-ABEND   THRU 9900-EXIT              
                    END-IF                                              
                 ELSE                                                   
                    DISPLAY '*** 2040-ERROR IN FCA292R READ ***'        
                    DISPLAY '*** FILE STATUS = ' WS-FCA292R-STATUS      
                 END-IF                                                 
           END-READ.                                                    
C30169*                                                                         
C30169 2040-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
C30169******************************************************************        
C30169*  2050-PROCESS-FCSCA292                                                  
C30169******************************************************************        
C30169 2050-PROCESS-FCSCA292.                                           
      *                                                                         
           OPEN INPUT FCA292R-FILE.                                     
           IF FCA292R-SUCCESSFUL                                        
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*** 2050-ERROR IN FCA292R OPEN ***'              
              DISPLAY '*** FILE STATUS = ' WS-FCA292R-STATUS            
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
           PERFORM WS-RESTART-ROW-CNT TIMES                             
              READ FCA292R-FILE INTO FIOCA292                           
              IF FCA292R-SUCCESSFUL                                     
                 ADD 1                  TO WS-TOT-RECS-WRTN             
                 PERFORM 8920-WRITE-FCSCA292         THRU 8920-EXIT     
              ELSE                                                      
                 DISPLAY '*** PREMATURE EOF ON FCA292R RESTART ***'     
                 DISPLAY '*** PROCESSING TERMINATED ***'                
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-PERFORM.                                                 
           CLOSE FCA292R-FILE.                                          
      *                                                                         
C30169 2050-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
      ******************************************************************PCS13800
A01618**  2400-WRITE-EMAIL-FILE.                                      **19080000
A01618**            WRITES OUT DATA TO FIOCM275 FILE                  **19090000
A01618******************************************************************PCS13950
A01618*                                                                         
A01618 2400-WRITE-EMAIL-FILE.                                           
A01618*                                                                         
A01618     IF WS-RETURN-CODE-03 NOT = 03                                
A01618*                                                                         
A01618        MOVE 'HELO DOMAIN:     SCANA                         '    
A01618                                         TO E-FCM275-DATA-REC     
A01618        WRITE FIOCM275                                            
A01618*                                                                         
A01618        MOVE 'MAIL FROM:   <'            TO E-FCM275-DATA-PARTA   
A01618        EVALUATE TRUE                                             
A01618        WHEN SCEG                                                 
A01618           MOVE 'CSRC275@SCEGJES2.SCANA.COM> '                    
A01618                                         TO E-FCM275-DATA-PARTB   
A01618        WHEN SEB                                                  
A01618           MOVE 'SEBC275@SCEGJES2.SCANA.COM> '                    
A01618                                         TO E-FCM275-DATA-PARTB   
A01618        WHEN PSNC                                                 
A01618           MOVE 'PNCC275@SCEGJES2.SCANA.COM> '                    
A01618                                         TO E-FCM275-DATA-PARTB   
A01618        END-EVALUATE                                              
A01618        MOVE SPACES                      TO E-FCM275-DATA-PARTC   
A01618        WRITE FIOCM275                                            
A01618*                                                                         
A01618        MOVE 'RCPT TO:   <CSSOCREDIT@SCANA.COM>              '    
A01618                                         TO E-FCM275-DATA-REC     
A01618        WRITE FIOCM275                                            
A01618        MOVE 'RCPT TO:   <ISTCSRCAPSSUPPORT@SCANA.COM>'           
A01618                                         TO E-FCM275-DATA-REC     
A01618        WRITE FIOCM275                                            
A01618        MOVE 'DATA                                           '    
A01618                                         TO E-FCM275-DATA-REC     
A01618        WRITE FIOCM275                                            
A01618*                                                                         
A01618        MOVE 'FROM: CIS PAGING <'        TO E-FCM275-DATA-PARTAA  
A01618        EVALUATE TRUE                                             
A01618        WHEN SCEG                                                 
A01618           MOVE 'CSRC275@SCEGJES2.SCANA.COM> '                    
A01618                                         TO E-FCM275-DATA-PARTBB  
A01618        WHEN SEB                                                  
A01618           MOVE 'SEBC275@SCEGJES2.SCANA.COM> '                    
A01618                                         TO E-FCM275-DATA-PARTBB  
A01618        WHEN PSNC                                                 
A01618           MOVE 'PNCC275@SCEGJES2.SCANA.COM> '                    
A01618                                         TO E-FCM275-DATA-PARTBB  
A01618        END-EVALUATE                                              
A01618        MOVE SPACES                      TO E-FCM275-DATA-PARTCC  
A01618        WRITE FIOCM275                                            
A01618*                                                                         
A01618        MOVE 'TO:  <CSSOCREDIT@SCANA.COM>                    '    
A01618                                         TO E-FCM275-DATA-REC     
A01618        WRITE FIOCM275                                            
A01618        MOVE 'TO:  <ISTCSRCAPSSUPPORT@SCANA.COM>      '           
A01618                                         TO E-FCM275-DATA-REC     
A01618        WRITE FIOCM275                                            
A01618*                                                                         
A01618        MOVE 'SUBJECT: WEEKLY JOB '                               
A01618                                         TO E-FCM275-DATA-PARTAAA 
A01618        EVALUATE TRUE                                             
A01618        WHEN SCEG                                                 
A01618           MOVE 'CSRC275 '               TO E-FCM275-DATA-PARTBBB 
A01618        WHEN SEB                                                  
A01618           MOVE 'SEBC275 '               TO E-FCM275-DATA-PARTBBB 
A01618        WHEN PSNC                                                 
A01618           MOVE 'PNCC275 '               TO E-FCM275-DATA-PARTBBB 
A01618        END-EVALUATE                                              
A01618        MOVE SPACES                      TO E-FCM275-DATA-PARTCCC 
A01618        MOVE ' HAD PROBLEM'              TO E-FCM275-DATA-PARTCCC 
A01618        WRITE FIOCM275                                            
A01618*                                                                         
A01618        MOVE SPACES                      TO E-FCM275-DATA-REC     
A01618        WRITE FIOCM275                                            
A01618        MOVE  '*****************PCSCA275******************'       
A01618                                         TO E-FCM275-DATA-REC     
A01618        WRITE FIOCM275                                            
A01618        MOVE 03                          TO RETURN-CODE           
A01618                                            WS-RETURN-CODE-03     
A01618     END-IF.                                                      
A01618*                                                                         
A01618     EVALUATE WS-ACCT-ISSUE-CUR                                   
A01618         WHEN '7010'                                              
A01618           MOVE  '* ERROR IN 7010-FETCH-CHRG-OFF-CURSOR1    *'    
A01618                                         TO E-FCM275-DATA-REC     
A01618           WRITE FIOCM275                                         
A01618*                                                                         
A01618           MOVE '* RETURN CODE       : ' TO E-FCM275-DATA-PART1   
A01618           MOVE SPACES                   TO E-FCM275-DATA-PART2   
A01618           MOVE WS-ACTIVE-RETURN-CODE    TO E-FCM275-DATA-PART2   
A01618           MOVE SPACES                   TO E-FCM275-DATA-PART3   
A01618           WRITE FIOCM275                                         
A01618*                                                                         
A01618           MOVE SPACES                   TO E-FCM275-DATA-REC     
A01618           WRITE FIOCM275                                         
A01618           MOVE  '*******************************************'    
A01618                                         TO E-FCM275-DATA-REC     
A01618           WRITE FIOCM275                                         
A01618*                                                                         
A01618         WHEN '7400'                                              
A01618           MOVE  '* ERROR IN 7400-FETCH-CHRG-OFF-CURSOR2    *'    
A01618                                         TO E-FCM275-DATA-REC     
A01618           WRITE FIOCM275                                         
A01618*                                                                         
A01618           MOVE '* RETURN CODE       : ' TO E-FCM275-DATA-PART1   
A01618           MOVE SPACES                   TO E-FCM275-DATA-PART2   
A01618           MOVE WS-ACTIVE-RETURN-CODE    TO E-FCM275-DATA-PART2   
A01618           MOVE SPACES                   TO E-FCM275-DATA-PART3   
A01618           WRITE FIOCM275                                         
A01618*                                                                         
A01618           MOVE SPACES                   TO E-FCM275-DATA-REC     
A01618           WRITE FIOCM275                                         
A01618           MOVE  '*******************************************'    
A01618                                         TO E-FCM275-DATA-REC     
A01618           WRITE FIOCM275                                         
A01618*                                                                         
A01618         WHEN '7730'                                              
A01618           MOVE  '* ERROR IN 7730-SELECT-MONTHLY-CO-AMTS    *'    
A01618                                         TO E-FCM275-DATA-REC     
A01618           WRITE FIOCM275                                         
A01618*                                                                         
A01618           MOVE  '* ROW NOT FOUND IN CSS_CHG_OFF_AMT TABLE  *'    
A01618                                          TO E-FCM275-DATA-REC    
A01618           WRITE FIOCM275                                         
A01618*                                                                         
A01618           MOVE '* RETURN CODE       : ' TO E-FCM275-DATA-PART1   
A01618           MOVE SPACES                   TO E-FCM275-DATA-PART2   
A01618           MOVE WS-ACTIVE-RETURN-CODE    TO E-FCM275-DATA-PART2   
A01618           MOVE SPACES                   TO E-FCM275-DATA-PART3   
A01618           WRITE FIOCM275                                         
A01618*                                                                         
A01618           MOVE '* ACCOUNT NO        : ' TO E-FCM275-DATA-PART1   
A01618           MOVE SPACES                   TO E-FCM275-DATA-PART2   
A01618           MOVE CO-ACCOUNT-NO            TO E-FCM275-DATA-PART2   
A01618           MOVE SPACES                   TO E-FCM275-DATA-PART3   
A01618           WRITE FIOCM275                                         
A01618*                                                                         
A01618           MOVE '*COLLECTION AGY CODE: ' TO E-FCM275-DATA-PART1   
A01618           MOVE SPACES                   TO E-FCM275-DATA-PART2   
A01618           MOVE WS-H-CODE-COLLEC-AGNCY   TO E-FCM275-DATA-PART2   
A01618           MOVE SPACES                   TO E-FCM275-DATA-PART3   
A01618           WRITE FIOCM275                                         
A01618*                                                                         
A01618           MOVE '*WRITEOFF MONTH YEAR: ' TO E-FCM275-DATA-PART1   
A01618           MOVE SPACES                   TO E-FCM275-DATA-PART2   
A01618           MOVE WS-WO-MONTH-YR           TO E-FCM275-DATA-PART2   
A01618           MOVE SPACES                   TO E-FCM275-DATA-PART3   
A01618           WRITE FIOCM275                                         
A01618*                                                                         
A01618           MOVE '*REG GROUP CODE     : ' TO E-FCM275-DATA-PART1   
A01618           MOVE SPACES                   TO E-FCM275-DATA-PART2   
A01618           MOVE LR-REG-GROUP-CD          TO E-FCM275-DATA-PART2   
A01618           MOVE SPACES                   TO E-FCM275-DATA-PART3   
A01618           WRITE FIOCM275                                         
A01618*                                                                         
A01618           MOVE '*COMPANY NO         : ' TO E-FCM275-DATA-PART1   
A01618           MOVE SPACES                   TO E-FCM275-DATA-PART2   
A01618           MOVE WS-H-COMPANY-NO          TO E-FCM275-DATA-PART2   
A01618           MOVE SPACES                   TO E-FCM275-DATA-PART3   
A01618           WRITE FIOCM275                                         
A01618*                                                                         
A01618           MOVE SPACES                   TO E-FCM275-DATA-REC     
A01618           WRITE FIOCM275                                         
A01618           MOVE  '*******************************************'    
A01618                                         TO E-FCM275-DATA-REC     
A01618           WRITE FIOCM275                                         
A01618*                                                                         
A01618     END-EVALUATE.                                                
A01618*                                                                         
A01618     MOVE SPACES  TO WS-ACCT-ISSUE-CUR.                           
A01618     ADD  1       TO WS-ISSUE-INDEX.                              
A01618*                                                                         
A01618 2400-EXIT.                                                       
A01618     EXIT.                                                        
      *                                                                         
      ******************************************************************06690000
      **  3500-MOVE-DATA ..                                           **06700000
      **           MOVES DATA TO OUTPUT                               **06710000
      **           WRITES TO OUTPUT FILE FIORP292                     **06720000
      ******************************************************************06730000
       3500-MOVE-TO-PRINT.                                              
      *                                                                 06750000
T26954     IF SEB                                                       
T26954         PERFORM 7530-SELECT-REG-GROUP-CD THRU 7530-EXIT          
T26954     ELSE                                                         
T26954         MOVE '   ' TO LR-REG-GROUP-CD                            
T26954     END-IF.                                                      
T26954*                                                                 06751000
TPR        PERFORM 8050-UPDATE-CHRG-OFF-AMT THRU 8050-EXIT.             
      *                                                                 06752000
T26954     MOVE LR-REG-GROUP-CD         TO E-FRP292-REG-GROUP-CD        
C30169                                     E-FCA292-REG-GROUP-CD.       
           MOVE WS-H-COMPANY-NO         TO E-FRP292-COMPANY-NO          
C30169                                     E-FCA292-COMPANY-NO.         
           MOVE WS-H-LOCAL-OFFICE       TO E-FRP292-LOCAL-OFF-CODE.     
           MOVE WS-H-CODE-COLLEC-AGNCY  TO E-FRP292-AGENCY-CODE         
C30169                                     E-FCA292-AGENCY-CODE.        
           MOVE WS-H-ACCOUNT-NO         TO E-FRP292-ACCOUNT-NO          
C30169                                     E-FCA292-ACCOUNT-NO.         
           MOVE WS-H-FULL-NAME          TO E-FRP292-NAME                
C30169     MOVE WS-CUSTOMER-NAME        TO E-FCA292-CUSTOMER-NAME       
C30169     MOVE WS-ACCOUNT-NAME         TO E-FCA292-ACCOUNT-NAME        
           MOVE WS-H-DATE-OF-CHG-OFF    TO E-FRP292-WRITE-OFF-DATE.     
           MOVE WS-H-DATE-LSTD-COLL-AGY TO E-FRP292-PLACED-DATE         
C30169                                     E-FCA292-PLACED-DATE.        
           MOVE WS-PLACED-AMOUNT        TO E-FRP292-PLACED-AMOUNT       
C30169                                     E-FCA292-PLACED-AMOUNT.      
           MOVE WS-WITHDRAWN-BAL        TO E-FRP292-WITHDRAWN-BALANCE   
C30169                                     E-FCA292-WITHDRAWN-AMOUNT.   
C30169     MOVE IZ-FW-ACTION-TYPE-CD    TO E-FCA292-PLMT-TYPE.          
C30169     MOVE IZ-WITHDRAW-DT          TO E-FCA292-WITHDRAW-DATE.      
      *                                                                 06850000
C30169* LOAD DIFFERENT WITHDRAW REASON CODE DESCRIPTIONS FROM USER TABLE        
C30169     IF  WDRAW-RSN-TBL-LOADED                                     
C30169         CONTINUE                                                 
C30169     ELSE                                                         
C30169         PERFORM 2010-LOAD-WITHDRAW-REASON                        
C30169            THRU 2010-EXIT                                        
C30169         SET WDRAW-RSN-TBL-LOADED TO TRUE                         
C30169     END-IF                                                       
C30169     SET WS-RANGE-INDEX TO 1                                      
C30169     SEARCH WS-WDRAW-RSN-DESC                                     
C30169         AT END                                                   
C30169              MOVE WS-H-CHG-WITHDRAW-REASN                        
C30169                TO E-FRP292-WITHDRAWN-REASON                      
C30169                   E-FCA292-WITHDRAWN-REASON                      
C30169         WHEN WS-WITHDRAW-RSN-CD (WS-RANGE-INDEX) =               
C30169                WS-H-CHG-WITHDRAW-REASN                           
C30169              MOVE WS-WITHDRAW-RSN-DESC (WS-RANGE-INDEX)          
C30169                TO E-FRP292-WITHDRAWN-REASON                      
C30169                   E-FCA292-WITHDRAWN-REASON                      
C30169     END-SEARCH                                                   
C30169*                                                                         
C23973     IF E-FRP292-DATA-REC NOT EQUAL WS-PREVIOUS-DATA-REC          
C30169        MOVE WS-DELIMITER1        TO E-FRP292-DELIM1              
C30169                                     E-FRP292-DELIM2              
C30169                                     E-FRP292-DELIM3              
C30169                                     E-FRP292-DELIM4              
C30169                                     E-FRP292-DELIM5              
C30169                                     E-FRP292-DELIM6              
C30169                                     E-FRP292-DELIM7              
C30169                                     E-FRP292-DELIM8              
C30169                                     E-FRP292-DELIM9              
C30169                                     E-FRP292-DELIM10             
C30169                                     E-FRP292-DELIM11             
C23973        MOVE E-FRP292-DATA-REC    TO WS-PREVIOUS-DATA-REC         
              PERFORM 8900-WRITE-FCSRP292  THRU 8900-EXIT               
C23973     ELSE                                                         
C23973        MOVE E-FRP292-DATA-REC    TO WS-PREVIOUS-DATA-REC         
C23973     END-IF.                                                      
      *                                                                 06980000
           MOVE WS-H-COMPANY-NO         TO CMP-COMPANY-NO.              
           PERFORM 8800-PROCESS-END-REC-TBL            THRU 8800-EXIT.  
      *                                                                 07010000
           INITIALIZE WS-H-VARIABLES.                                   
      *                                                                 07030000
           MOVE SPACES                  TO AT-COMPANY-NO.               
           MOVE SPACES                  TO AT-LOCAL-OFFICE.             
      *                                                                 07070000
       3500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07100000
      ******************************************************************07110000
      **  3510-MOVE-DATA ..                                           **07120000
      **           MOVES DATA TO TEMPORARY HOLD VARIABLES FOR FRP292  **07130000
      **                                                              **07140000
      ******************************************************************07150000
       3510-MOVE-DAT-TO-HOLD.                                           
      *                                                                 07170000
           MOVE CO-ACCOUNT-NO           TO AT-ACCOUNT-NO                
                                           IZ-ACCOUNT-NO.               
      *                                                                 07172000
           INITIALIZE WS-NAME-TABLE.                                    
           MOVE 'Y'       TO WS-NAME-ONLY-SW.                           
           PERFORM 4000-MAIL-NAME-ADDRESS            THRU 4000-EXIT.    
      *                                                                 07176000
           MOVE WS-CUSTOMER-NAME        TO  WS-H-FULL-NAME.             
      *                                                                 07178000
           MOVE AT-COMPANY-NO           TO  WS-H-COMPANY-NO.            
           MOVE AT-LOCAL-OFFICE         TO  WS-H-LOCAL-OFFICE.          
C30169     MOVE IZ-CODE-COLLEC-AGNCY    TO  WS-H-CODE-COLLEC-AGNCY.     
           MOVE CO-ACCOUNT-NO           TO  WS-H-ACCOUNT-NO.            
T26954     MOVE CO-ACCOUNT-NO           TO  WS-H-ACCOUNT-NO-PIC9.       
           MOVE CO-DATE-OF-CHG-OFF      TO  WS-H-DATE-OF-CHG-OFF.       
C30169     IF CO-DATE-OF-CHG-OFF = SPACES                               
C30169        PERFORM 7590-GET-KD-WRITE-OFF-DT                          
C30169           THRU 7590-EXIT                                         
C30169        MOVE WS-KD-WRITE-OFF-DT   TO  WS-H-DATE-OF-CHG-OFF        
C30169     END-IF                                                       
C30169     MOVE KD-FW-ACTION-DT         TO  WS-H-DATE-LSTD-COLL-AGY.    
      *                                                                 07240100
       3510-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07281000
C30169******************************************************************07110000
C30169**  3550-MOVE-DATA ..                                           **07120000
C30169**           MOVES DATA TO TEMPORARY HOLD VARIABLES FOR FRP292  **07130000
C30169**                                                              **07140000
C30169******************************************************************07150000
C30169 3550-MOVE-DAT-TO-HOLD.                                           
C30169                                                                  
C30169     MOVE FM-ACCOUNT-NO           TO AT-ACCOUNT-NO                
C30169                                     IZ-ACCOUNT-NO.               
C30169*                                                                 07170000
C30169     INITIALIZE WS-NAME-TABLE.                                    
C30169     MOVE 'Y'       TO WS-NAME-ONLY-SW.                           
C30169     PERFORM 4000-MAIL-NAME-ADDRESS            THRU 4000-EXIT.    
C30169*                                                                 07176000
C30169     MOVE WS-CUSTOMER-NAME        TO  WS-H-FULL-NAME.             
C30169*                                                                 07178000
C30169     MOVE AT-COMPANY-NO           TO  WS-H-COMPANY-NO.            
C30169     MOVE AT-LOCAL-OFFICE         TO  WS-H-LOCAL-OFFICE.          
C30169     MOVE FM-CODE-COLLEC-AGNCY    TO  WS-H-CODE-COLLEC-AGNCY.     
C30169     MOVE FM-ACCOUNT-NO           TO  WS-H-ACCOUNT-NO.            
C30169     MOVE FM-ACCOUNT-NO           TO  WS-H-ACCOUNT-NO-PIC9.       
C30169     MOVE SPACES                  TO  CO-DATE-OF-CHG-OFF.         
C30169     MOVE CO-DATE-OF-CHG-OFF      TO  WS-H-DATE-OF-CHG-OFF.       
C30169     MOVE FM-FW-ACTION-DT         TO  WS-H-DATE-LSTD-COLL-AGY.    
C30169*                                                                 07240100
C30169 3550-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                 07281000
C30169******************************************************************06690000
C30169**  3560-MOVE-DATA ..                                           **06700000
C30169**           MOVES DATA TO OUTPUT                               **06710000
C30169**           WRITES TO OUTPUT FILE FIORP292                     **06720000
C30169******************************************************************06730000
C30169 3560-MOVE-TO-PRINT.                                              
C30169*                                                                 06750000
C30169     IF SEB                                                       
C30169         PERFORM 7530-SELECT-REG-GROUP-CD THRU 7530-EXIT          
C30169     ELSE                                                         
C30169         MOVE '   ' TO LR-REG-GROUP-CD                            
C30169     END-IF.                                                      
C30169*                                                                 06751000
C30169     MOVE LR-REG-GROUP-CD         TO E-FRP292-REG-GROUP-CD        
C30169                                     E-FCA292-REG-GROUP-CD.       
C30169     MOVE WS-H-COMPANY-NO         TO E-FRP292-COMPANY-NO          
C30169                                     E-FCA292-COMPANY-NO.         
C30169     MOVE WS-H-LOCAL-OFFICE       TO E-FRP292-LOCAL-OFF-CODE.     
C30169     MOVE WS-H-CODE-COLLEC-AGNCY  TO E-FRP292-AGENCY-CODE         
C30169                                     E-FCA292-AGENCY-CODE.        
C30169     MOVE WS-H-ACCOUNT-NO         TO E-FRP292-ACCOUNT-NO          
C30169                                     E-FCA292-ACCOUNT-NO.         
C30169     MOVE WS-H-FULL-NAME          TO E-FRP292-NAME                
C30169     MOVE WS-CUSTOMER-NAME        TO E-FCA292-CUSTOMER-NAME       
C30169     MOVE WS-ACCOUNT-NAME         TO E-FCA292-ACCOUNT-NAME        
C30169     MOVE WS-H-DATE-OF-CHG-OFF    TO E-FRP292-WRITE-OFF-DATE.     
C30169     MOVE WS-H-DATE-LSTD-COLL-AGY TO E-FRP292-PLACED-DATE         
C30169                                     E-FCA292-PLACED-DATE.        
C30169     MOVE WS-PLACED-AMOUNT        TO E-FRP292-PLACED-AMOUNT       
C30169                                     E-FCA292-PLACED-AMOUNT.      
C30169     MOVE WS-WITHDRAWN-BAL        TO E-FRP292-WITHDRAWN-BALANCE   
C30169                                     E-FCA292-WITHDRAWN-AMOUNT.   
C30169     MOVE FM-FW-ACTION-TYPE-CD    TO E-FCA292-PLMT-TYPE.          
C30169     MOVE FM-WITHDRAW-DT          TO E-FCA292-WITHDRAW-DATE.      
C30169     MOVE WS-H-CHG-WITHDRAW-REASN TO E-FRP292-WITHDRAWN-REASON    
C30169                                     E-FCA292-WITHDRAWN-REASON.   
C30169*                                                                         
C30169     IF E-FRP292-DATA-REC NOT EQUAL WS-PREVIOUS-DATA-REC          
C30169        MOVE WS-DELIMITER1        TO E-FRP292-DELIM1              
C30169                                     E-FRP292-DELIM2              
C30169                                     E-FRP292-DELIM3              
C30169                                     E-FRP292-DELIM4              
C30169                                     E-FRP292-DELIM5              
C30169                                     E-FRP292-DELIM6              
C30169                                     E-FRP292-DELIM7              
C30169                                     E-FRP292-DELIM8              
C30169                                     E-FRP292-DELIM9              
C30169                                     E-FRP292-DELIM10             
C30169                                     E-FRP292-DELIM11             
C30169        MOVE E-FRP292-DATA-REC    TO WS-PREVIOUS-DATA-REC         
C30169        PERFORM 8900-WRITE-FCSRP292  THRU 8900-EXIT               
C30169     ELSE                                                         
C30169        MOVE E-FRP292-DATA-REC    TO WS-PREVIOUS-DATA-REC         
C30169     END-IF.                                                      
C30169*                                                                 06980000
C30169     MOVE WS-H-COMPANY-NO         TO CMP-COMPANY-NO.              
C30169     PERFORM 8800-PROCESS-END-REC-TBL            THRU 8800-EXIT.  
C30169*                                                                 07010000
C30169     INITIALIZE WS-H-VARIABLES.                                   
C30169*                                                                 07030000
C30169     MOVE SPACES                  TO AT-COMPANY-NO.               
C30169     MOVE SPACES                  TO AT-LOCAL-OFFICE.             
C30169*                                                                 07070000
C30169 3560-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                 07100000
      ******************************************************************07290000
      **  3600-CREATE-RECORD.                                         **07300000
      **           MOVES DATA TO OUTPUT AND WRITES TO FIORP275        **07310000
      **                                                              **07320000
      ******************************************************************07330000
       3600-CREATE-RECORD.                                              
      *                                                                 07350000
T26954     MOVE LR-REG-GROUP-CD         TO E-FRP275-REG-GROUP-CD.       
           MOVE WS-H-COMPANY-NO         TO E-FRP275-COMPANY-NO.         
           MOVE WS-H-CODE-COLLEC-AGNCY  TO E-FRP275-COLLEC-AGENCY-CODE. 
           MOVE WS-H-ACCOUNT-NO         TO E-FRP275-ACCOUNT-NO.         
           MOVE WS-H-FULL-NAME          TO E-FRP275-NAME.               
           MOVE WS-H-DATE-LSTD-COLL-AGY TO E-FRP275-PLACEMENT-DATE.     
           MOVE WS-H-COLLECTED-BY       TO E-FRP275-COLLECTED-BY.       
           MOVE WS-H-DATE-ORIG-PYMT     TO E-FRP275-PAYMENT-DATE.       
           MOVE WS-H-CODE-TRAN-TYPE     TO E-FRP275-TRANS-TYPE.         
           MOVE WS-H-AMT-ORIG-ENTERED   TO E-FRP275-PAYMENT-AMOUNT.     
           MOVE WS-COMMISSION           TO E-FRP275-COMMISSION.         
           MOVE WS-H-NON-COM            TO E-FRP275-NON-COMMISSION.     
           MOVE WS-H-AMT-REMAIN-BAL     TO E-FRP275-REM-BALANCE.        
           MOVE WS-H-CODE-CHG-OFF-REAS  TO E-FRP275-REASON-CODE.        
      *                                                                 07500000
           PERFORM 8910-WRITE-FCSRP275  THRU 8910-EXIT.                 
      *                                                                 07520000
           MOVE ZERO                    TO WS-COMMISSION                
                                           WS-H-NON-COM                 
                                           WS-H-AMT-ORIG-ENTERED.       
      *                                                                 07522000
           MOVE WS-H-COMPANY-NO         TO CMP-COMPANY-NO.              
           PERFORM 8800-PROCESS-END-REC-TBL            THRU 8800-EXIT.  
      *                                                                 07550000
       3600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07580000
      ******************************************************************07590000
      **  3610-MOVE-DAT-HOLD ..                                       **07600000
      **           MOVES DATA TO HOLD VARIABLE FIELDS FOR FRP275      **07610000
      **                                                              **07620000
      ******************************************************************07630000
       3610-MOVE-DAT-TO-HOLD.                                           
      *                                                                 07650000
C30169     MOVE IZ-ACCOUNT-NO              TO AT-ACCOUNT-NO             
           PERFORM 7045-GET-CHG-OFF-RSN    THRU 7045-EXIT               
           INITIALIZE WS-NAME-TABLE.                                    
           MOVE 'Y'       TO WS-NAME-ONLY-SW.                           
           PERFORM 4000-MAIL-NAME-ADDRESS            THRU 4000-EXIT.    
      *                                                                 07701000
           MOVE WS-CUSTOMER-NAME       TO  WS-H-FULL-NAME.              
      *                                                                 07703000
           MOVE AT-COMPANY-NO          TO  WS-H-COMPANY-NO.             
           MOVE CO-ACCOUNT-NO          TO  WS-H-ACCOUNT-NO.             
T26954     MOVE CO-ACCOUNT-NO          TO  WS-H-ACCOUNT-NO-PIC9.        
C30169     MOVE IZ-CODE-COLLEC-AGNCY   TO  WS-H-CODE-COLLEC-AGNCY.      
C30169     MOVE KD-FW-ACTION-DT        TO  WS-H-DATE-LSTD-COLL-AGY.     
      *                                                                 07710000
       3610-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07740000
      ******************************************************************07740100
      *                                                                 07740200
      *  4000-MAIL-NAME-ADDRESS                                         07740300
      *                                                                 07740400
      ******************************************************************07740500
      *                                                                 07740600
TPR        EXEC SQL                                                     07741000
               INCLUDE CPD00074                                         07742000
           END-EXEC.                                                    07743000
      *                                                                 07744000
      ******************************************************************07750000
      **  4100-WRITE-BEGIN-CONTROLS ..                                **07760000
      **            WRITES BEGINNING CONTROL RECORD FOR FRP292        **07770000
      **                                                              **07780000
      ******************************************************************07790000
       4100-WRITE-BEGIN-CONTROLS.                                       
      *                                                                 07810000
T26954     MOVE LOW-VALUES              TO E-FRP292-BEGIN-REC.          
           MOVE ZEROES                  TO E-FRP292-DB-PART-BREC.       
           MOVE WS-INPUT-DATE           TO E-FRP292-CREATE-DATE-BREC.   
      *                                                                 07850000
           PERFORM 8900-WRITE-FCSRP292  THRU 8900-EXIT.                 
           SUBTRACT 1 FROM WS-FRP292-READ-COUNT.                        
           MOVE SPACES                  TO E-FRP292-DATA-REC.           
      *                                                                 07890000
       4100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07920000
      ******************************************************************07930000
      **  4105-WRITE-BEGIN-CONTROLS ..                                **07940000
      **            WRITES BEGINNING CONTROL RECORD FOR FRP275        **07950000
      **                                                              **07960000
      ******************************************************************07970000
       4105-WRITE-BEGIN-CONTROLS.                                       
      *                                                                 07990000
T26954*    MOVE LOW-VALUES              TO E-FRP275-KEY-BREC.           08000000
T26954     MOVE LOW-VALUES              TO E-FRP275-BEGIN-REC.          
           MOVE ZEROES                  TO E-FRP275-DB-PART-BREC.       
           MOVE WS-INPUT-DATE           TO E-FRP275-CREATE-DATE-BREC.   
      *                                                                 08030000
           PERFORM 8910-WRITE-FCSRP275  THRU 8910-EXIT.                 
           SUBTRACT 1 FROM WS-FRP275-READ-COUNT.                        
           MOVE SPACES                  TO E-FRP275-DATA-REC.           
      *                                                                 08070000
       4105-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08100000
C26208******************************************************************        
C26208*  4110-PROCESS-FCSRP292                                                  
C26208******************************************************************        
C26208 4110-PROCESS-FCSRP292.                                           
C26208*                                                                         
C26208     OPEN INPUT FRP292R-FILE.                                     
C26208     IF FRP292R-SUCCESSFUL                                        
C26208        CONTINUE                                                  
C26208     ELSE                                                         
C26208        DISPLAY '*** 4110-ERROR IN FRP292R OPEN ***'              
C26208        DISPLAY '*** FILE STATUS = ' WS-FRP292R-STATUS            
C26208        PERFORM 9900-ABEND THRU 9900-EXIT                         
C26208     END-IF.                                                      
C26208*    READ HEADER RECORD AND SKIP                                          
C26208     READ FRP292R-FILE INTO FIORP292                              
C26208     PERFORM WS-RESTART-ROW-CNT TIMES                             
C26208        READ FRP292R-FILE INTO FIORP292                           
C26208        IF FRP292R-SUCCESSFUL                                     
C26208           ADD 1                  TO WS-TOT-RECS-WRTN             
C26208           PERFORM 8900-WRITE-FCSRP292         THRU 8900-EXIT     
C26208        ELSE                                                      
C26208           DISPLAY '*** PREMATURE EOF ON FRP292R RESTART ***'     
C26208           DISPLAY '*** PROCESSING TERMINATED ***'                
C26208           PERFORM 9900-ABEND THRU 9900-EXIT                      
C26208        END-IF                                                    
C26208     END-PERFORM.                                                 
C26208     CLOSE FRP292R-FILE.                                          
C26208*                                                                         
C26208 4110-EXIT.                                                       
C26208     EXIT.                                                        
C26208*                                                                         
      ******************************************************************08110000
      **  4200-WRITE-END-CONTROLS ..                                  **08120000
      **                WRITES ENDING CONTROL RECORD FOR E-FRP292     **08130000
      **                                                              **08140000
      ******************************************************************08150000
       4200-WRITE-END-CONTROLS.                                         
      *                                                                 08170000
           MOVE SPACES                  TO E-FRP292-DATA-REC.           
T26954     MOVE HIGH-VALUES             TO E-FRP292-END-REC.            
           MOVE ZERO                    TO E-FRP292-DB-PART-EREC.       
           MOVE WS-FRP292-READ-COUNT    TO E-FRP292-RECORD-COUNT-EREC.  
      *                                                                 08220000
           PERFORM 8900-WRITE-FCSRP292  THRU 8900-EXIT.                 
      *                                                                 08240000
       4200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08270000
      ******************************************************************08280000
      **  4300-WRITE-END-CONTROLS ..                                  **08290000
      **                WRITES ENDING CONTROL RECORD FOR E-FRP-275    **08300000
      **                                                              **08310000
      ******************************************************************08320000
       4300-WRITE-END-CONTROLS.                                         
      *                                                                 08340000
           MOVE SPACES                  TO E-FRP275-DATA-REC.           
T26954     MOVE HIGH-VALUES             TO E-FRP275-END-REC.            
           MOVE ZERO                    TO E-FRP275-DB-PART-EREC.       
           MOVE WS-FRP275-READ-COUNT    TO E-FRP275-RECORD-COUNT-EREC.  
      *                                                                 08390000
           PERFORM 8910-WRITE-FCSRP275  THRU 8910-EXIT.                 
      *                                                                 08410000
       4300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08440000
C26208******************************************************************08440000
C26208* 4310-COPY-TO-NEWRP292                                           08440000
C26208* DURING RESTART RUN, COPY THE ENTIRE DATA FROM FILE FCSRP292     08440000
C26208* TO FILE NEWRP292.                                               08440000
C26208******************************************************************08440000
C26208 4310-COPY-TO-NEWRP292.                                           
C26208*                                                                 08440000
C26208     OPEN INPUT FRP292R-FILE.                                     
C26208     IF FRP292R-SUCCESSFUL                                        
C26208        CONTINUE                                                  
C26208     ELSE                                                         
C26208        DISPLAY '*** 4310-ERROR IN FRP292R OPEN ***'              
C26208        DISPLAY '*** FILE STATUS = ' WS-FRP292R-STATUS            
C26208        PERFORM 9900-ABEND THRU 9900-EXIT                         
C26208     END-IF.                                                      
C26208     PERFORM 4315-READ-WRITE-RP292              THRU 4315-EXIT    
C26208         UNTIL FCSRP292-END.                                      
C26208     CLOSE FRP292R-FILE.                                          
C26208*                                                                         
C26208 4310-EXIT.                                                       
C26208     EXIT.                                                        
C26208******************************************************************08440000
C26208* 4315-READ-WRITE-RP292                                           08440000
C26208* READ THE RECORDS FROM FCSRP292 AND WRITE INTO NEWRP292          08440000
C26208******************************************************************08440000
C26208 4315-READ-WRITE-RP292.                                           
C26208     READ FRP292R-FILE INTO FIORP292                              
C26208        AT END                                                    
C26208           SET FCSRP292-END         TO TRUE                       
C26208        NOT AT END                                                
C26208           IF FRP292R-SUCCESSFUL                                  
C26208              WRITE FIORP292                                      
C26208              IF FRP292-SUCCESSFUL                                
C26208                 CONTINUE                                         
C26208              ELSE                                                
C26208                 DISPLAY '*** 4315-ERROR ON FCSRP292 WRITE ***'   
C26208                 DISPLAY '*** FILE STATUS = ' WS-FRP292-STATUS    
C26208                 PERFORM 9900-ABEND   THRU 9900-EXIT              
C26208              END-IF                                              
C26208           ELSE                                                   
C26208              DISPLAY '*** 4315-ERROR IN FRP292R READ ***'        
C26208              DISPLAY '*** FILE STATUS = ' WS-FRP292R-STATUS      
C26208           END-IF                                                 
C26208     END-READ.                                                    
C26208*                                                                         
C26208 4315-EXIT.                                                       
C26208     EXIT.                                                        
      ******************************************************************08450000
      **  4350-PROCESS-CHRG-OFF-ACT                                   **08460000
      **           SUMS UP TOTAL CHRG-OFF FOR MULTIPLE ROWS OF AN     **08470000
      **           ACCOUNT                                            **08480000
      **                                                              **08490000
      ******************************************************************08500000
      *                                                                 08510000
       4350-PROCESS-CHRG-OFF-ACT.                                       
      *                                                                 08530000
C30169     MOVE IZ-ACCOUNT-NO         TO CO-ACCOUNT-NO.                 
      *                                                                         
C30169     IF AT-CODE-ACCT-STAT = 'S'                                   
              PERFORM 7700-SELECT-WRITE-OFF-BAL       THRU 7700-EXIT    
C30169     ELSE                                                         
C30169        MOVE AT-TOTAL-AR-BALANCE TO WS-WRITE-OFF-BAL              
C30169     END-IF                                                       
      *                                                                 08541000
           PERFORM 7705-SELECT-UNUSED-CREDIT          THRU 7705-EXIT.   
           ADD WS-UNUSED-CREDIT       TO WS-WRITE-OFF-BAL.              
      *                                                                 08570000
           PERFORM 7710-OPEN-TRN-HST-CURSOR           THRU 7710-EXIT.   
      *                                                                 08600000
           PERFORM 7715-FETCH-TRN-HST-CURSOR          THRU 7715-EXIT.   
      *                                                                 08620000
           PERFORM 4400-GET-BEGINNING-ACCT-BAL        THRU 4400-EXIT    
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                  
      *                                                                 08661000
           PERFORM 7720-CLOSE-TRN-HST-CURSOR          THRU 7720-EXIT.   
      *                                                                 08665100
           IF WS-PROCESS-ACCOUNT = 'Y'                                  
      *                                                                 08665300
               PERFORM 3610-MOVE-DAT-TO-HOLD          THRU 3610-EXIT    
      *                                                                 08665500
C30169         MOVE KD-FW-ACTION-DT           TO WS-DATE-LISTED         
               MOVE WS-DATE-LISTED(6:2)       TO WS-WO-MONTH            
               MOVE WS-DATE-LISTED(1:4)       TO WS-WO-YEAR             
      *                                                                 08665900
               MOVE WS-WO-DATE                TO WS-WO-MONTH-YR         
      *                                                                 08666100
               PERFORM 7710-OPEN-TRN-HST-CURSOR       THRU 7710-EXIT    
      *                                                                 08666300
               PERFORM 7715-FETCH-TRN-HST-CURSOR      THRU 7715-EXIT    
      *                                                                 08666500
               PERFORM 4410-PROCESS-TRANSACTIONS      THRU 4410-EXIT    
                 UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                
      *                                                                 08666800
               PERFORM 7720-CLOSE-TRN-HST-CURSOR      THRU 7720-EXIT    
           END-IF.                                                      
      *                                                                 08667100
           MOVE 'N'         TO WS-PROCESS-ACCOUNT.                      
      *                                                                 08667300
           INITIALIZE WS-H-VARIABLES.                                   
      *                                                                 08667500
           PERFORM 7400-FETCH-CHRG-OFF-CURSOR2    THRU 7400-EXIT.       
      *                                                                 08672000
       4350-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08700000
      ******************************************************************08710000
      **                                                              **08711000
      **  4400-GET-BEGINNING-ACCT-BAL                                 **08720000
      **                                                              **08721000
      **  REVERSES THE ACCOUNT TRANSACTIONS THAT OCCURED DURING THE   **08730000
      **  WEEK TO GET A STARTING BALANCE.  PROCESS NEEDED TO GET      **08740000
      **  AN ACCURATE REMAINING BALANCE ON THE ACCOUNT AFTER EACH     **08750000
      **  TRANSACTION.                                                **08751000
      ******************************************************************08760000
      *                                                                 08761000
       4400-GET-BEGINNING-ACCT-BAL.                                     
      *                                                                 08780000
           MOVE 'Y'                       TO WS-PROCESS-ACCOUNT.        
      *                                                                 08782000
TPR        EVALUATE TRUE                                                
              WHEN AR-CODE-TRAN-TYPE = WS-PAYMENT-STATUS                
                  ADD AR-AMT-ORIG-ENTERED                               
                                      TO WS-WRITE-OFF-BAL               
      *                                                                 08804000
T15769        WHEN AR-CODE-TRAN-TYPE = WS-CREDIT-STATUS                 
                  ADD AR-AMT-ORIG-ENTERED                               
                                      TO WS-WRITE-OFF-BAL               
      *                                                                 08804409
              WHEN AR-CODE-TRAN-TYPE = WS-TRANSFER-STATUS               
                  ADD AR-AMT-ORIG-ENTERED                               
                                      TO WS-WRITE-OFF-BAL               
      *                                                                 08805300
              WHEN AR-CODE-TRAN-TYPE = WS-CORRECTION-STATUS             
                  SUBTRACT AR-AMT-ORIG-ENTERED                          
                                   FROM  WS-WRITE-OFF-BAL               
      *                                                                 08806300
              WHEN AR-CODE-TRAN-TYPE = WS-CHARGE-STATUS                 
                  SUBTRACT AR-AMT-ORIG-ENTERED                          
                                   FROM  WS-WRITE-OFF-BAL               
           END-EVALUATE.                                                
      *                                                                 08808000
           PERFORM 7715-FETCH-TRN-HST-CURSOR          THRU 7715-EXIT.   
      *                                                                 09110000
       4400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09130100
      ******************************************************************09131000
      **                                                              **09132000
      **  4410-PROCESS-TRANSACTIONS                                   **09133000
      **                                                              **09134000
      **  PROCESS EACH TRANSACTION ON THE ACCOUNT SINCE THE LAST      **09135000
      **  TIME THE PROGRAM RAN.  FOR EACH VALID TRANSACTION, A ROW    **09135100
      **  RECORD IS WRITTEN TO THE FRP275 FILE FOR THE REPORT WRITER. **09135200
      **                                                              **09135300
      ******************************************************************09139000
      *                                                                 09139100
       4410-PROCESS-TRANSACTIONS.                                       
      *                                                                 09139300
T26954     IF SEB                                                       
T26954         PERFORM 7530-SELECT-REG-GROUP-CD     THRU 7530-EXIT      
T26954     ELSE                                                         
T26954         MOVE '   ' TO LR-REG-GROUP-CD                            
T26954     END-IF.                                                      
T26954*                                                                 06751000
           PERFORM 7730-SELECT-MONTHLY-CO-AMTS        THRU 7730-EXIT.   
      *                                                                 09140600
A01618     IF WS-CO-AMTS-EXISTS = 'N'                                   
A01618        GO TO 4410-EXIT                                           
A01618     ELSE                                                         
T13742      EVALUATE TRUE                                               
             WHEN AR-CODE-TRAN-TYPE = WS-PAYMENT-STATUS                 
                PERFORM 4500-PROCESS-PYMT             THRU 4500-EXIT    
                PERFORM 4550-PROCESS-PYMT-STATS       THRU 4550-EXIT    
      *                                                                 09141200
             WHEN AR-CODE-TRAN-TYPE = WS-CREDIT-STATUS                  
                MOVE AR-AMT-ORIG-ENTERED  TO WS-H-NON-COM               
                                             WS-H-AMT-ORIG-ENTERED      
                ADD AR-AMT-ORIG-ENTERED   TO WS-CURR-MTH-ADJ-AMT        
                MOVE 'E'                  TO WS-H-CODE-CHG-OFF-REAS     
                PERFORM 8220-UPDATE-SCEG-ADJ          THRU 8220-EXIT    
      *                                                                 09141909
             WHEN AR-CODE-TRAN-TYPE = WS-TRANSFER-STATUS                
                MOVE AR-AMT-ORIG-ENTERED  TO WS-H-NON-COM               
                                             WS-H-AMT-ORIG-ENTERED      
                ADD AR-AMT-ORIG-ENTERED   TO WS-CURR-MTH-ADJ-AMT        
                MOVE 'B'                  TO WS-H-CODE-CHG-OFF-REAS     
                PERFORM 8220-UPDATE-SCEG-ADJ          THRU 8220-EXIT    
      *                                                                 09141700
             WHEN AR-CODE-TRAN-TYPE = WS-CORRECTION-STATUS              
                MOVE AR-AMT-ORIG-ENTERED  TO WS-H-NON-COM               
                                             WS-H-AMT-ORIG-ENTERED      
                MOVE 'F'                  TO WS-H-CODE-CHG-OFF-REAS     
      *                                                                 09142100
C30169          IF AR-DATE-ORIG-PYMT > KD-FW-ACTION-DT                  
                    MOVE AR-AMT-ORIG-ENTERED                            
                                          TO WS-TRANSACTION-AMT         
T13899              PERFORM 4415-CORRECT-PAYMENT-TOTALS                 
                    THRU 4415-EXIT                                      
                END-IF                                                  
      *                                                                 09142800
T13824       WHEN AR-CODE-TRAN-TYPE = WS-CHARGE-STATUS                  
                MOVE AR-AMT-ORIG-ENTERED     TO WS-H-NON-COM            
                                                WS-H-AMT-ORIG-ENTERED   
                PERFORM 4420-PROCESS-NEW-CHARGE       THRU 4420-EXIT    
      *                                                                 09143200
                IF WS-RETURNED-CHECK > 0                                
C30169             IF AR-DATE-ORIG-PYMT > KD-FW-ACTION-DT               
                      MOVE WS-RETURNED-CHECK    TO WS-TRANSACTION-AMT   
                      PERFORM 4415-CORRECT-PAYMENT-TOTALS               
                      THRU 4415-EXIT                                    
                   END-IF                                               
                   MOVE 'C'          TO WS-H-CODE-CHG-OFF-REAS          
                ELSE                                                    
                   MOVE 'D'          TO WS-H-CODE-CHG-OFF-REAS          
                END-IF                                                  
      *                                                                 09143900
            END-EVALUATE                                                
      *                                                                 09144100
            IF AR-PYMT-FACILITY-CD NOT = WS-COLLECTION-AGNCY-CD         
T23230        IF SCEG                                                   
                 MOVE WS-SCEG               TO WS-H-COLLECTED-BY        
T23230        ELSE                                                      
T23230           IF SEB                                                 
T23230              MOVE WS-SCANA           TO WS-H-COLLECTED-BY        
T23230           ELSE                                                   
T23230              IF PSNC                                             
T23230                 MOVE WS-PSNC         TO WS-H-COLLECTED-BY        
T23230              END-IF                                              
T23230           END-IF                                                 
T23230        END-IF                                                    
            ELSE                                                        
C30169         MOVE IZ-CODE-COLLEC-AGNCY  TO Q7-CODE-COLLEC-AGNCY       
C30169         PERFORM 7560-SELECT-COLL-AGNCY-NAME                      
C30169            THRU 7560-EXIT                                        
               MOVE Q7-COLLEC-AGNCY-NAME  TO WS-H-COLLECTED-BY          
            END-IF                                                      
      *                                                                 09144700
            EVALUATE TRUE                                               
              WHEN AR-CODE-TRAN-TYPE = WS-PAYMENT-STATUS                
                SUBTRACT AR-AMT-ORIG-ENTERED                            
                                  FROM WS-WRITE-OFF-BAL                 
      *                                                                 09145200
              WHEN AR-CODE-TRAN-TYPE = WS-CREDIT-STATUS                 
                SUBTRACT AR-AMT-ORIG-ENTERED                            
                                  FROM WS-WRITE-OFF-BAL                 
      *                                                                 09147209
              WHEN AR-CODE-TRAN-TYPE = WS-TRANSFER-STATUS               
                SUBTRACT AR-AMT-ORIG-ENTERED                            
                                  FROM WS-WRITE-OFF-BAL                 
      *                                                                 09145600
              WHEN AR-CODE-TRAN-TYPE = WS-CORRECTION-STATUS             
                ADD AR-AMT-ORIG-ENTERED                                 
                                  TO WS-WRITE-OFF-BAL                   
      *                                                                 09146000
              WHEN AR-CODE-TRAN-TYPE = WS-CHARGE-STATUS                 
                ADD AR-AMT-ORIG-ENTERED                                 
                                  TO WS-WRITE-OFF-BAL                   
            END-EVALUATE                                                
      *                                                                 09146500
           MOVE WS-WRITE-OFF-BAL          TO WS-H-AMT-REMAIN-BAL        
C30169     IF AT-CODE-ACCT-STAT = 'B'                                   
C30169        MOVE AT-TOTAL-AR-BALANCE    TO WS-H-AMT-REMAIN-BAL        
C30169     END-IF                                                       
      *                                                                 09146700
           MOVE AR-CODE-TRAN-TYPE         TO WS-H-CODE-TRAN-TYPE        
      *                                                                 09146900
T12705     MOVE AR-DATE-TRANS             TO WS-H-DATE-ORIG-PYMT        
      *                                                                 09147100
C26208     ADD 1                          TO WS-RESTART-COMMIT-COUNTER  
C26208     ADD 1                          TO WS-TOT-RECS-WRTN           
C26208     IF WS-RESTART-COMMIT-COUNTER = WS-CHKP-LUW-LIMIT             
C26208           OR WS-RESTART-COMMIT-COUNTER = WS-CHKP-UPD-LIMIT       
C26208           OR CO-ACCOUNT-NO = WS-PREV-ROW-ACCT                    
C26208        ADD  1                      TO WS-CHKP-SEQ-NO             
C26208        PERFORM 8915-COMMIT                     THRU 8915-EXIT    
C26208        MOVE 0                      TO WS-RESTART-COMMIT-COUNTER  
C26208     END-IF                                                       
C26208     MOVE CO-ACCOUNT-NO             TO WS-PREV-ROW-ACCT           
C26208*                                                                         
           PERFORM 3600-CREATE-RECORD                 THRU 3600-EXIT    
      *                                                                 09147300
           PERFORM 7715-FETCH-TRN-HST-CURSOR          THRU 7715-EXIT    
      *                                                                 09147500
A01618     END-IF.                                                      
      *                                                                 09147500
       4410-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09147800
      ******************************************************************09147900
      ** 4415-CORRECT-PAYMENT-TOTALS                                    09148000
      **                                                                09148100
      ** PARAGRAPH CHECKS TO SEE IF COMMISSIONS WERE PAID ON THIS       09148200
      ** CORRECTED PAYMENT.  1ST SELECT THE PAYMENT AND RETRIEVE        09148300
      ** THE TRANS-HIST-SEQ-NO.  USE THE TRANS-HIST-SEQ-NO OF THE       09148400
      ** CORRECTED PAYMENT TO SELECT AGAINST MAINTENANCE TRANS HIST     09148500
      ** IF A ROW IS FOUND WITH THAT TRANS-HIST-SEQ-NO THE COMMISION    09148600
      ** NEEDS TO BE BACKED OUT OF COMMISSIONS PAID.                    09148700
      **                                                                09148800
      ******************************************************************09148900
      *                                                                 09149000
T13899 4415-CORRECT-PAYMENT-TOTALS.                                     
      *                                                                 09149200
           MOVE 'N'             TO WS-PAYMENT-FOUND.                    
      *                                                                 09149400
           PERFORM 7110-OPEN-PAYMENT-CURSOR           THRU 7110-EXIT.   
      *                                                                 09149600
           PERFORM 7120-FETCH-PAYMENT-CURSOR          THRU 7120-EXIT.   
      *                                                                 09149800
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND OR           
                         WS-PAYMENT-FOUND = 'Y'                         
      *                                                                 09150100
               IF WS-TRANSACTION-AMT = WS-CORRECTED-PAYMENT             
                   MOVE 'Y'         TO WS-PAYMENT-FOUND                 
      *                                                                 09150400
                   PERFORM 7100-CHECK-FOR-COMM-PAID      THRU 7100-EXIT 
      *                                                                 09150600
                   IF WS-COMMISSIONS-EXIST = 'Y'                        
C30169                 MOVE IZ-COMPANY-NO        TO L2-COMPANY-NO       
C30169                 MOVE IZ-REG-GROUP-CD      TO L2-REG-GROUP-CD     
C30169                 MOVE IZ-CODE-COLLEC-AGNCY TO L2-CODE-COLLEC-AGNCY
C30169                 MOVE IZ-COLL-AGY-SUB-CD                          
C30169                                         TO  L2-COLL-AGENCY-SUB-CD
C30169                 PERFORM 7545-SELECT-COLL-SUB-RATE-CD             
C30169                 THRU 7545-EXIT                                   
C30169                 MOVE L2-COLL-COMM-RATE-CD                        
C30169                                   TO Q1-COLL-COMM-RATE-CD        
                       PERFORM 7550-SELECT-COLL-RATE                    
                       THRU 7550-EXIT                                   
                       MULTIPLY Q1-COLL-COMM-RATE BY                    
                          WS-CORRECTED-PAYMENT GIVING WS-CORRECTED-COMM 
      *                                                                 09151400
                       SUBTRACT WS-CORRECTED-COMM FROM                  
                          WS-AGNCY-FEES-PD-AMT                          
                       PERFORM 8230-UPDATE-AGNCY-FEES-PD                
                       THRU 8230-EXIT                                   
      *                                                                 09153907
                       MULTIPLY WS-CORRECTED-COMM BY -1                 
                          GIVING WS-CORRECTED-FEE                       
                       MOVE WS-CORRECTED-FEE      TO WS-COMMISSION      
                   END-IF                                               
      *                                                                 09152000
                   IF WS-PYMT-FACILITY-CD EQUAL WS-COLLECTION-AGNCY-CD  
                       SUBTRACT WS-CORRECTED-PAYMENT                    
                         FROM WS-CURR-MTH-COLL-AMT                      
                       PERFORM 8200-UPDATE-AGNCY-COLL THRU 8200-EXIT    
                   ELSE                                                 
                       SUBTRACT WS-CORRECTED-PAYMENT                    
                         FROM WS-CURR-PAID-COLL-AMT                     
                       PERFORM 8210-UPDATE-SCEG-COLL  THRU 8210-EXIT    
                   END-IF                                               
               END-IF                                                   
      *                                                                 09153100
               PERFORM 7120-FETCH-PAYMENT-CURSOR      THRU 7120-EXIT    
           END-PERFORM.                                                 
      *                                                                 09153400
           PERFORM 7130-CLOSE-PAYMENT-CURSOR          THRU 7130-EXIT.   
      *                                                                 09153600
       4415-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09153900
      ******************************************************************09154000
      *                                                                 09154100
      *  4420-PROCESS-NEW-CHARGE                                        09154200
      *                                                                 09154300
      *  ADDS AN NSC CHARGE TO THE AMT PLACED WITH THE COLLECTION       09154400
      * AGENCY.                                                         09154500
      *                                                                 09154600
      ******************************************************************09154700
      *                                                                 09154800
T13824 4420-PROCESS-NEW-CHARGE.                                         
      *                                                                 09155000
           MOVE ZERO                     TO WS-RETURNED-CHECK.          
      *                                                                 09155200
           PERFORM 7750-OPEN-TRN-HST-DET-CRSR         THRU 7750-EXIT.   
           PERFORM 7755-FETCH-TRN-HST-DET-CRSR        THRU 7755-EXIT.   
      *                                                                 09155500
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
      *                                                                 09155700
               IF AU-GL-ACCT-DEBIT EQUAL WS-AR-NSC-GL-NO(WS-GL-SUB)     
                   ADD AU-AMT-POSTED     TO WS-AGNCY-PLACED-AMT         
                   PERFORM 8225-UPD-AGNCY-PLACED-AMT  THRU 8225-EXIT    
               END-IF                                                   
      *                                                                 09156200
               IF AU-GL-ACCT-DEBIT EQUAL WS-AR-NSN-GL-NO(WS-GL-SUB)     
                  OR AU-GL-ACCT-DEBIT EQUAL WS-AR-NSA-GL-NO(WS-GL-SUB)  
                   ADD AU-AMT-POSTED     TO WS-RETURNED-CHECK           
               END-IF                                                   
      *                                                                 09156700
               PERFORM 7755-FETCH-TRN-HST-DET-CRSR    THRU 7755-EXIT    
      *                                                                 09156900
           END-PERFORM.                                                 
      *                                                                 09157100
           PERFORM 7760-CLOSE-TRN-HST-DET-CRSR        THRU 7760-EXIT.   
      *                                                                 09158000
       4420-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09159700
      ******************************************************************09159800
      **  4500-PROCESS-PYMT ..                                        **09160000
      **       CHECKS IF PAYMENT MEETS CRITERIA FOR NONCOMMISSION OR  **09170000
      **       COMMISSION.                                            **09180000
      **                                                              **09190000
      **       COMMISSION CRITERIA:                                   **09200000
      **                                                              **09210000
      **       PAYMENT IS CONSIDERED COMMISSION REGARDLESS OF THE     **09220000
      **       AGENCY (SCE&G, COLLECTION AGENCY) THAT COLLECTED       **09230000
      **       THE PAYMENT UNLESS IT MEETS THE NON-COMMISSION         **09240000
      **       CRITERIA BELOW.                                        **09250000
      **                                                              **09260000
      **       NONCOMMISSION PAYMENT CRITERIA:                        **09270000
      **                                                              **09280000
      **       1.  PAYMENT IN FULL, MADE DIRECTLY TO SCE&G, WITHIN    **09290000
      **       90 DAYS OF PLACEMENT WITH THE COLLECTION AGENCY SOLELY **09300000
      **       FOR THE PURPOSE OF HAVING SERVICE RESTORED.            **09310000
C23972**       90 DAYS IS GIVEN AS THE DELINQ VALUE                   **        
      **                                                              **09320000
      ******************************************************************09410000
      *                                                                 09411000
       4500-PROCESS-PYMT.                                               
      *                                                                 09430000
           MOVE 'N'                     TO FLG-PYMT-WAS-NONCOM.         
      *                                                                 09430202
           MOVE ' '                     TO WS-H-CODE-CHG-OFF-REAS.      
           MOVE WS-WRITE-OFF-BAL        TO WS-BAL-WO-TRANSACTION.       
      *                                                                 09430503
           COMPUTE WS-BAL-W-TRANSACTION = WS-WRITE-OFF-BAL -            
                                          AR-AMT-ORIG-ENTERED.          
      *                                                                 09433000
           IF AR-PYMT-FACILITY-CD NOT = WS-COLLECTION-AGNCY-CD          
      *                                                                 09451000
              IF WS-BAL-W-TRANSACTION <= 0                              
C23972            PERFORM 4510-PROCESS-RES-DAYS-DATE    THRU 4510-EXIT  
C23972            IF AR-DATE-TRANS < WS-RES-DAYS-FROM-PLACEMENT         
C23972               PERFORM 4520-PROCESS-RES-DAYS-NONCOM               
                                                      THRU 4520-EXIT    
                  END-IF                                                
              END-IF                                                    
           END-IF.                                                      
      *                                                                 09560000
           MOVE AR-AMT-ORIG-ENTERED     TO WS-H-AMT-ORIG-ENTERED.       
      *                                                                 09562000
           MOVE AR-AMT-ORIG-ENTERED     TO WS-AMT-ORIG-ENTERED.         
      *                                                                 09564000
           IF FLG-PYMT-WAS-NONCOM = WS-N                                
               IF WS-BAL-WO-TRANSACTION < 0                             
                   MOVE 0               TO WS-AMT-ORIG-ENTERED          
                                           WS-COMMISSION                
                   MOVE AR-AMT-ORIG-ENTERED                             
                                        TO WS-H-NON-COM                 
               ELSE                                                     
                  IF WS-BAL-W-TRANSACTION < 0                           
                      ADD WS-BAL-W-TRANSACTION TO WS-AMT-ORIG-ENTERED   
                      COMPUTE WS-H-NON-COM = WS-BAL-W-TRANSACTION * -1  
                  END-IF                                                
      *                                                                 09577000
C30169            MOVE IZ-CODE-COLLEC-AGNCY TO L2-CODE-COLLEC-AGNCY     
C30169            MOVE IZ-COLL-AGY-SUB-CD   TO L2-COLL-AGENCY-SUB-CD    
C30169            MOVE IZ-COMPANY-NO        TO L2-COMPANY-NO            
C30169            MOVE IZ-REG-GROUP-CD      TO L2-REG-GROUP-CD          
C30169            PERFORM 7545-SELECT-COLL-SUB-RATE-CD                  
C30169               THRU 7545-EXIT                                     
C30169            MOVE L2-COLL-COMM-RATE-CD TO Q1-COLL-COMM-RATE-CD     
                  PERFORM 7550-SELECT-COLL-RATE         THRU 7550-EXIT  
C27888            IF AR-AMT-BILLED-UNPAID >= 0                          
                     MULTIPLY Q1-COLL-COMM-RATE BY WS-AMT-ORIG-ENTERED  
                      GIVING WS-COMMISSION                              
C27888            ELSE                                                  
C27888               COMPUTE WS-BALANCE-AMT = AR-AMT-BILLED-UNPAID +    
C27888                                        AR-AMT-ORIG-ENTERED       
C27888               IF WS-BALANCE-AMT > -1 AND < 1                     
C27888                  CONTINUE                                        
C27888               ELSE                                               
C27888                  IF WS-BALANCE-AMT < 0                           
C27888                     COMPUTE WS-BALANCE-AMT = WS-BALANCE-AMT * -1 
C27888                  END-IF                                          
C27888                  MULTIPLY Q1-COLL-COMM-RATE BY WS-BALANCE-AMT    
C27888                         GIVING WS-COMMISSION                     
C27888               END-IF                                             
C27888               COMPUTE WS-H-NON-COM = AR-AMT-BILLED-UNPAID * -1   
C27888            END-IF                                                
      *                                                                 09610100
T13806            ADD WS-COMMISSION      TO WS-AGNCY-FEES-PD-AMT        
T13806            PERFORM 8230-UPDATE-AGNCY-FEES-PD  THRU 8230-EXIT     
      *                                                                 09611000
                  PERFORM 6500-FMT-MNT-TRANS-HIST    THRU 6500-EXIT     
               END-IF                                                   
           END-IF.                                                      
C23972*                                                                         
C23972* IF THE NO. OF DAYS BET PLACEMENT DATE AND PYMT DATE >= DELINQ           
C23972* VAL, AND IF THERE ARE NO FINANCIAL TRANSACTIONS FOR THESE DAYS,         
C23972* THEN SET REASON CODE= 'Y' FOR PAYMENTS                                  
C23972     PERFORM 7900-CHECK-FOR-TRANS              THRU 7900-EXIT.    
C23972     PERFORM 7910-SELECT-NO-DAYS               THRU 7910-EXIT.    
C23972     IF WS-FINANCIAL-TRANS-EXISTS = 'N' AND WS-NO-DAYS >=         
C30169                                          WS-DELINQ-DAYS-NO-FA    
C23972        MOVE 0                     TO WS-COMMISSION               
C23972        MOVE WS-H-AMT-ORIG-ENTERED TO WS-H-NON-COM                
C23972        MOVE 'Y'                   TO WS-H-CODE-CHG-OFF-REAS      
C23972     END-IF.                                                      
C23972*                                                                         
C23972* IF IT'S A VOUCHER PAYMENT, SET REASON CODE = 'Z'                        
C23972     PERFORM 7800-CHECK-VOUCHER-PYMTS          THRU 7800-EXIT     
C23972     IF WS-VOUCHER-PYMT-EXISTS = 'Y'                              
C23972        MOVE 'Z'                   TO WS-H-CODE-CHG-OFF-REAS      
C23972        MOVE 0                     TO WS-COMMISSION               
C23972        MOVE WS-H-AMT-ORIG-ENTERED TO WS-H-NON-COM                
C23972     END-IF.                                                      
C23972*                                                                 09430310
C23972* TO IDENTIFY PAYMENT REVERSED ROWS                               09430310
C23972* IF THE REASON CODE IS SPACES & IF IT'S A PYMT REVERSED ROW, SET 09430310
C23972* REASON CODE = F, BUT MAKE IT BLANKS IN THE REPORT.              09430310
C23972     IF WS-H-CODE-CHG-OFF-REAS EQUAL SPACES                       
C23972        PERFORM 7810-GET-APPL-PGM-ID           THRU 7810-EXIT     
C23972        IF AR-APPL-PROGRAM-ID EQUAL 'PANEL118A'                   
C23972           MOVE 'F'                TO WS-H-CODE-CHG-OFF-REAS      
C23972        END-IF                                                    
C23972     END-IF.                                                      
      *                                                                 09640000
       4500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09670000
      ******************************************************************09680000
C23972**  4510-PROCESS-RES-DAYS-DATE  ..                              **09690000
      **                CALCULATES DATE THAT IS 90 DAYS FROM PLACEMENT**09700000
C23972**  90 DAYS IS SPECIFIED AS THE DELINQ VALUE FOR BOTH THE COMP  **09710000
      ******************************************************************09720000
       4510-PROCESS-RES-DAYS-DATE.                                      
      *                                                                 09740000
C23972     PERFORM 7740-SEL-RES-DAYS-FRM-PLCMENT     THRU 7740-EXIT.    
C23972     MOVE WS-RES-DAYS-FROM-PLACEMENT    TO WS-TS-RES-DAYS.        
C23972     MOVE WS-TS-RES-DAYS-FROM-PLACEMENT TO                        
C23972                            WS-RES-DAYS-FROM-PLACEMENT-TS.        
           MOVE WS-LAST-RUN-DATE             TO WS-TS-LST-RUN-DATE.     
           MOVE WS-TS-RUN-DATE               TO WS-LAST-RUN-DATE-TS.    
      *                                                                 09810000
       4510-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09840000
      ******************************************************************09850000
C23972**  4520-PROCESS-RES-DAYS-NONCOM..                              **09860000
      **            CHECKS IF PAYMENT MEETS THE RESTORED SERVICE      **09870000
      **  CRITERIA OF THE 90 DAYS WITHIN PLACEMENT NON-COMMISSION     **09880000
      **  RULE.                                                       **09890000
C23972**  IF THE FULL PYMT IS MADE WITHIN 90 DAYS FROM PLACEMENT, THEN**09890000
C23972**  SET THE REASON CODE AS 'A'.                                 **09890000
      **                                                              **09900000
      ******************************************************************09910000
C23972 4520-PROCESS-RES-DAYS-NONCOM.                                    
      *                                                                 09930000
           PERFORM 7570-OPEN-RESTORED-ACCT-CSR         THRU 7570-EXIT.  
           PERFORM 7575-FETCH-RESTORED-ACCT-CSR        THRU 7575-EXIT.  
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C30169        IF AR-AMT-ORIG-ENTERED >= KD-FW-ACTION-AM                 
                 MOVE AR-AMT-ORIG-ENTERED TO WS-H-NON-COM               
C23972           MOVE 0                   TO WS-COMMISSION              
C23972           MOVE 'A'                 TO WS-H-CODE-CHG-OFF-REAS     
                 MOVE WS-Y                TO FLG-PYMT-WAS-NONCOM        
C23972        END-IF                                                    
           END-IF.                                                      
           PERFORM 7580-CLOSE-RESTORED-ACCT-CSR        THRU 7580-EXIT.  
      *                                                                 10010000
       4520-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10040000
      ***************************************************************** 10270000
      ** 4550-PROCESS-PYMT-STATS ..                                  ** 10280000
      **       UPDATES THE COLLECTION TOTALS FOR SCE&G AND THE       ** 10290000
      ** COLLECTION AGENCY.                                          ** 10300000
      **                                                             ** 10310000
      ***************************************************************** 10320000
       4550-PROCESS-PYMT-STATS.                                         
      *                                                                 10340000
           IF AR-PYMT-FACILITY-CD EQUAL WS-COLLECTION-AGNCY-CD          
               ADD WS-AMT-ORIG-ENTERED     TO WS-CURR-MTH-COLL-AMT      
               PERFORM 8200-UPDATE-AGNCY-COLL        THRU 8200-EXIT     
           ELSE                                                         
               ADD WS-AMT-ORIG-ENTERED     TO WS-CURR-PAID-COLL-AMT     
               PERFORM 8210-UPDATE-SCEG-COLL         THRU 8210-EXIT     
           END-IF.                                                      
      *                                                                 10420000
       4550-EXIT.                                                       
           EXIT.                                                        
C26208***************************************************************** 10820000
C26208* 4555-PROCESS-FCSRP275                                        ** 10820000
C26208***************************************************************** 10820000
C26208 4555-PROCESS-FCSRP275.                                           
C26208*                                                                 10820000
C26208     OPEN INPUT FRP275R-FILE.                                     
C26208     IF FRP275R-SUCCESSFUL                                        
C26208        CONTINUE                                                  
C26208     ELSE                                                         
C26208        DISPLAY '*** 4555-ERROR IN FRP275R OPEN ***'              
C26208        DISPLAY '*** FILE STATUS = ' WS-FRP275R-STATUS            
C26208        PERFORM 9900-ABEND THRU 9900-EXIT                         
C26208     END-IF.                                                      
C26208*    TO SKIP THE HEADER RECORD                                            
C26208     READ FRP275R-FILE INTO FIORP275                              
C26208*                                                                         
C26208     PERFORM WS-RESTART-ROW-CNT TIMES                             
C26208        READ FRP275R-FILE INTO FIORP275                           
C26208        IF FRP275R-SUCCESSFUL                                     
C26208           ADD 1                     TO WS-TOT-RECS-WRTN          
C26208           PERFORM 8910-WRITE-FCSRP275         THRU 8910-EXIT     
C26208        ELSE                                                      
C26208           DISPLAY '*** PREMATURE EOF ON FRP275R RESTART ***'     
C26208           DISPLAY '*** PROCESSING TERMINATED ***'                
C26208           PERFORM 9900-ABEND THRU 9900-EXIT                      
C26208        END-IF                                                    
C26208     END-PERFORM.                                                 
C26208     CLOSE FRP275R-FILE.                                          
C26208*                                                                 10820000
C26208 4555-EXIT.                                                       
C26208     EXIT.                                                        
      *                                                                         
C30169******************************************************************        
C30169* 5100-CALC-LAST-RUN-DT                                          *        
C30169******************************************************************        
C30169 5100-CALC-LAST-RUN-DT.                                           
C30169                                                                  
C30169     MOVE WS-LAST-RUN-DATE     TO WS-LAST-RUN-DT(1:10).           
C30169                                                                  
C30169     MOVE '-00.00.00.000000'   TO WS-LAST-RUN-DT(11:16).          
C30169                                                                  
C30169 5100-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                 11200000
      ***************************************************************** 11210000
      ** 6251-GET-FJC01-DATE                                         ** 11220000
      ***************************************************************** 11230000
      *                                                                 11240000
       COPY CPD00037.                                                   11250000
      *                                                                 11260000
       COPY CPD00040.                                                   11270000
      *                                                                 11280000
      ******************************************************************11280100
      *                                                                 11280200
      * 6010-REDUCE-EMBEDDED-SPACES                                     11280300
      *                                                                 11280400
      ******************************************************************11280500
      *                                                                 11280600
TPR    COPY CPD00004.                                                   11281000
      *                                                                 11281100
      ******************************************************************11281200
      * 6500-FMT-MNT-TRANS-HIST                                         11281300
      *                                                                 11281400
      * WRITES MAINTENANCE TRANSACTION HISTORY FOR THE COMMISSION AMOUNT11281500
      * THE TRANS_HIST_SEQ_NO IS EQUAL TO THE TRANS_HIST_SEQ_NO OF      11281600
      * OF THE PAYMENT.  THIS RECORD IS NEEDED FOR FUTURE CORRECTIONS   11281700
      * OF THE PAYMENT.  THE COMMISSION AMOUNT MUST BE BACKED OUT OF    11281800
      * THE MONTHLY TABLE AMOUNT.                                       11281900
      *                                                                 11282000
      ******************************************************************11282100
      *                                                                 11282200
       6500-FMT-MNT-TRANS-HIST.                                         
      *                                                                 11282400
           MOVE CO-ACCOUNT-NO  TO MH-ACCOUNT-NO.                        
           MOVE WS-PGRMNAME    TO MH-APPL-PROGRAM-ID.                   
           MOVE 'H'            TO MH-CODE-TRAN-TYPE.                    
           MOVE AT-CUSTOMER-NO TO MH-CUSTOMER-NO.                       
           MOVE WS-INPUT-DATE  TO MH-DATE-TRANS.                        
           MOVE AT-PREMISE-NO  TO MH-PREMISE-NO.                        
           MOVE SPACES         TO MH-RESP-AREA-ID.                      
           MOVE AR-TRANS-HIST-SEQ-NO                                    
                               TO MH-TRANS-HIST-SEQ-NO.                 
           MOVE WS-SYSTEM      TO MH-USER-ID.                           
      *                                                                 11283500
           MOVE AR-AMT-ORIG-ENTERED                                     
                               TO WS-PYMT-AMT.                          
           MOVE WS-COMMISSION  TO WS-COMMISSION-AMT.                    
           MOVE WS-MH-MESSAGE  TO MH-TRAN-COMMENT-TEXT.                 
           MOVE +60            TO MH-TRAN-COMMENT-LEN.                  
      *                                                                 11284100
           PERFORM 6540-INSERT-MNT-TRANS-HIST         THRU 6540-EXIT.   
      *                                                                 11284300
       6500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11284600
C26208*****************************************************************         
C26208* 6235-GET-FJC01-RESTART-REQ                                              
C26208*****************************************************************         
C26208     EXEC SQL                                                             
C26208         INCLUDE CPD00035                                                 
C26208     END-EXEC.                                                            
C26208*                                                                         
C26208*****************************************************************         
C26208* 6253-GET-FJC01-CHKP-LIMIT.                                              
C26208*****************************************************************         
C26208     EXEC SQL                                                             
C26208         INCLUDE CPD00034                                                 
C26208     END-EXEC.                                                            
C26208*                                                                         
      ******************************************************************11284700
      *                                                                 11284800
      * 6540-INSERT-MNT-TRANS-HIST                                      11284900
      *                                                                 11285000
      ******************************************************************11285100
      *                                                                 11285200
           EXEC SQL                                                     11285300
               INCLUDE CPD00067                                         11285400
           END-EXEC.                                                    11285500
      *                                                                 11285600
      ******************************************************************11290000
      ** 7000-OPEN-CHRG-OFF-CURSOR ..                                 **11300000
      **          OPENS THE CHRG-OFF-CURSOR FOR USE IN FCSRP292       **11310000
      **                                                              **11320000
      ******************************************************************11330000
       7000-OPEN-CHRG-OFF-CURSOR1.                                      
      *                                                                 11350000
           EXEC SQL                                                     
             OPEN CHRG_OFF_CURSOR1                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11390000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
TP8965         DISPLAY '**** ABEND IN 7000-OPEN-CHRG-OFF-CURSOR1 ****'  
TP8965         DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
               PERFORM 9900-ABEND     THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                 11470000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11500000
      ******************************************************************11510000
      **  7010-FETCH-CHRG-OFF-CURSOR1 ..                              **11520000
      **         GETS DATA FROM CSS_CHRG-OFF TABLE                    **11530000
      **                                                              **11540000
      ******************************************************************11550000
       7010-FETCH-CHRG-OFF-CURSOR1.                                     
           MOVE '7010' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                 11580000
           EXEC SQL                                                     
              FETCH CHRG_OFF_CURSOR1                                    
               INTO :IZ-CODE-COLLEC-AGNCY,                              
C30169              :IZ-COLL-AGY-SUB-CD,                                
C30169              :IZ-ACCOUNT-NO,                                     
                    :CO-DATE-OF-CHG-OFF,                                
C30169              :KD-FW-ACTION-DT :WS-NULL-DATE-LSTD,                 
C30169              :KD-FW-ACTION-AM,                                   
C30169              :IZ-FW-COLL-SEQ-NO,                                 
C30169              :IZ-FW-ACTION-TYPE-CD,                              
C30169              :IZ-WITHDRAW-REASON-CD,                             
C30169              :IZ-WITHDRAW-AM,                                    
C30169              :IZ-WITHDRAW-DT :WS-NULL-WDRAW-DT,                   
C23973              :CO-WO-STATUS,                                      
                    :AT-COMPANY-NO,                                     
                    :AT-LOCAL-OFFICE,                                   
                    :AT-CUSTOMER-NO,                                    
                    :AT-PREMISE-NO,                                     
C23973              :AT-LAST-PYMT-DATE :WS-NULL-LAST-PYMT-DT           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11710000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C23973        IF WS-NULL-DATE-LSTD < 0                                  
C30169           MOVE LOW-VALUES     TO KD-FW-ACTION-DT                 
C30169           MOVE ZEROES         TO WS-NULL-DATE-LSTD               
C23973        END-IF                                                    
C23973        IF WS-NULL-LAST-PYMT-DT < 0                               
C23973           MOVE LOW-VALUES     TO AT-LAST-PYMT-DATE               
C30169           MOVE ZEROES         TO WS-NULL-LAST-PYMT-DT            
C23973        END-IF                                                    
C30169        IF WS-NULL-WDRAW-DT < 0                                   
C30169           MOVE LOW-VALUES     TO IZ-WITHDRAW-DT                  
C30169           MOVE ZEROES         TO WS-NULL-WDRAW-DT                
C30169        END-IF                                                    
C30169        IF CO-DATE-OF-CHG-OFF = '1900-01-01'                      
C30169           MOVE SPACES         TO CO-DATE-OF-CHG-OFF              
C30169        END-IF                                                    
C23973     ELSE                                                         
C23973        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 CONTINUE                                               
              ELSE                                                      
A01618           DISPLAY '*** ERROR IN 7010-FETCH-CHRG-OFF-CURSOR1 ***' 
TP8965           DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
C23973           DISPLAY 'LAST PYMT DT= ' AT-LAST-PYMT-DATE             
A01618           IF WS-ACTIVE-RETURN-CODE =  -305 AND                   
A01618                    WS-ISSUE-INDEX <= 10                          
A01618              MOVE '7010'  TO WS-ACCT-ISSUE-CUR                   
A01618              PERFORM 2400-WRITE-EMAIL-FILE       THRU 2400-EXIT  
A01618           ELSE                                                   
                    PERFORM 7020-CLOSE-CHRG-OFF-CURSOR1 THRU 7020-EXIT  
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
A01618           END-IF                                                 
C23973        END-IF                                                    
           END-IF.                                                      
      *                                                                 11810000
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11840000
      ******************************************************************11850000
      **  7020-CLOSE-CHRG-OFF-CURSOR1 ..                              **11860000
      **         CLOSES CHRG_OFF_CURSOR1                              **11870000
      **                                                              **11880000
      ******************************************************************11890000
       7020-CLOSE-CHRG-OFF-CURSOR1.                                     
           MOVE '7020' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                 11920000
           EXEC SQL                                                     
               CLOSE CHRG_OFF_CURSOR1                                   
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
      *                                                                 11920000
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11984800
C30169*                                                                         
C30169*****************************************************************         
C30169* 7030-OPEN-WDRAW-RSN-CURSOR.                                             
C30169* CURSOR TO EXTRACT NEEDED CREDIT FORECST VALUES.                         
C30169*****************************************************************         
C30169*                                                                         
C30169 7030-OPEN-WDRAW-RSN-CSR.                                         
C30169*                                                                         
C30169     EXEC SQL                                                     
C30169         OPEN WDRAW-RSN-CSR                                       
C30169     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C30169     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
C30169     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C30169        NEXT SENTENCE                                             
C30169     ELSE                                                         
C30169        DISPLAY '*** ABEND IN 7030-OPEN-WDRAW-RSN-CSR ***'        
C30169        DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE            
C30169        DISPLAY 'FW_ATTR_TYPE_CD ' KV-FW-ATTRIB-TYPE-CD           
              PERFORM 9900-ABEND THRU 9900-EXIT                         
C30169     END-IF.                                                      
C30169*                                                                         
C30169 7030-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
C30169*****************************************************************         
C30169*  7035-FETCH-WDRAW-RSN-CSR.                                              
C30169*    FETCH WITHDRAW REASON CURSOR.                                        
C30169*****************************************************************         
C30169*                                                                         
C30169  7035-FETCH-WDRAW-RSN-CSR.                                       

MSQ008     MOVE 50 TO MSQ008-WDRAW-RSN-CSR
C30169*                                                                         
C30169     EXEC SQL                                                     
C30169         FOR :MSQ008-WDRAW-RSN-CSR
              FETCH 
              FROM WDRAW-RSN-CSR          
C30169          INTO :WS-FW-ATTR-VALUE-CD                               
C34822              ,:WS-FW-ATTR-VALUE-DESC                             
C30169     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*        FETCH NEXT ROWSET FROM WDRAW-RSN-CSR FOR 50 ROWS                 
MFA-TR*         INTO :WS-FW-ATTR-VALUE-CD                                       
MFA-TR*             ,:WS-FW-ATTR-VALUE-DESC                                     
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-WDRAW-RSN-CSR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C30169     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
C30169      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
C30169        IF  SQLERRD(3) >= 1 OR WS-WDRAW-ROW-COUNT > 0             
C30169            MOVE SQLERRD (3)        TO WS-WDRAW-ROW-COUNT         
C30169        ELSE                                                      
C30169            DISPLAY '*** ABEND IN 7035-FETCH-WITHDRAW-RSN-CSR ***'
C30169            DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
C30169            DISPLAY 'FW_ATTRIB_TYPE_CD ' KV-FW-ATTRIB-TYPE-CD     
C30169            DISPLAY 'ROWCOUNT ' SQLERRD(3)                        
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
C30169        END-IF                                                    
C30169     ELSE                                                         
C30169        IF WS-ACTIVE-RETURN-CODE = +354                           
C30169            EXEC SQL                                              
MSQ012                GET DIAGNOSTICS :MFA-GD-ROW-COUNT =             
C30169                       ROW_COUNT                                  
MSQ012                      ,:MFA-GD-NUMBER = NUMBER                      
C30169            END-EXEC                                              

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*           EXEC SQL                                                      
MFA-TR*               GET DIAGNOSTICS :WS-WDRAW-ROW-COUNT =                     
MFA-TR*                      ROW_COUNT                                          
MFA-TR*                     ,:WS-NUM-COND = NUMBER                              
MFA-TR*           END-EXEC                                                      
MSQ012            MOVE MFA-GD-ROW-COUNT TO WS-WDRAW-ROW-COUNT
MSQ012            MOVE MFA-GD-NUMBER TO WS-NUM-COND
C30169            DISPLAY '*** ABEND IN 7035-FETCH-WDRAW-RSN-CSR ***'   
C30169            DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
C30169            DISPLAY 'FW_ATTRIB_TYPE_CD ' KV-FW-ATTRIB-TYPE-CD     
C30169            DISPLAY 'ROWCOUNT ' SQLERRD(3)                        
C30169            DISPLAY 'NUM_COND '  WS-NUM-COND                      
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
C30169        ELSE                                                      
C30169            DISPLAY '*** ABEND IN 7035-FETCH-WDRAW-RSN-CSR ***'   
C30169            DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
C30169            DISPLAY 'FW_ATTRIB_TYPE_CD ' KV-FW-ATTRIB-TYPE-CD     
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
C30169        END-IF                                                    
C30169     END-IF.                                                      
C30169*                                                                         
C30169 7035-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
C30169*****************************************************************         
C30169* 7040-CLOSE-WDRAW-RSN-CSR                                                
C30169*    CLOSE WDRAW REASON CSR.                                              
C30169*****************************************************************         
C30169*                                                                         
C30169 7040-CLOSE-WDRAW-RSN-CSR.                                        
C30169*                                                                         
C30169     EXEC SQL                                                     
C30169         CLOSE WDRAW-RSN-CSR                                      
C30169     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C30169     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
C30169     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C30169        CONTINUE                                                  
C30169     ELSE                                                         
C30169        DISPLAY '*** ABEND IN 7040-CLOSE-WDRAW-RSN-CSR ***    '   
C30169        DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE            
C30169        DISPLAY 'FW_ATTRIB_TYPE_CD ' KV-FW-ATTRIB-TYPE-CD         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
C30169     END-IF.                                                      
C30169*                                                                         
C30169 7040-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
C30169******************************************************************11984900
      * 7045-GET-CHG-OFF-RSN.                                           11985000
      *                                                                 11985100
      ******************************************************************11985200
      *                                                                 11985300
C30169 7045-GET-CHG-OFF-RSN.                                            
C30169*                                                                 11985500
            MOVE '7045' TO WS-ACTIVE-PARAGRAPH.                         
      *                                                                 11985700
            EXEC SQL                                                    
                SELECT TOP(1) CODE_CHG_OFF_REAS                                
                INTO  :CO-CODE-CHG-OFF-REAS                             
                FROM CSS_CHRG_OFF WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :CO-ACCOUNT-NO                       
                                           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                    11986000
MFA-TR*         SELECT CODE_CHG_OFF_REAS                                11986100
MFA-TR*         INTO  :CO-CODE-CHG-OFF-REAS                             11986400
MFA-TR*         FROM CSS_CHRG_OFF                                       11986500
MFA-TR*         WHERE ACCOUNT_NO = :CO-ACCOUNT-NO                       11986800
MFA-TR*         FETCH FIRST 1 ROW ONLY WITH UR                          11986900
MFA-TR*    END-EXEC                                                     11987000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11987100
           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
      *                                                                 11987300
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**** ABEND IN 7045-GET-CHG-OFF-RSN       ****'  
               DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
               PERFORM 9900-ABEND     THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                 11988100
C30169 7045-EXIT.                                                       
C30169     EXIT.                                                        
      *                                                                 11988400
C26208******************************************************************05431000
C26208* 7050-SELECT-RESTART                                             05431000
C26208* CHECK IF RESTART ROW EXISTS                                     05431000
C26208******************************************************************05431000
C26208 7050-SELECT-RESTART.                                             
C26208     EXEC SQL                                                     
C26208        SELECT RESTART_DATA                                       
C26208          INTO :RF-RESTART-DATA                                   
C26208          FROM CSS_RESTART                                        
C26208         WHERE NAME_PROGRAM = :RF-NAME-PROGRAM AND                
C26208               PARTITION_NO = :RF-PARTITION-NO AND                
C26208               DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                    
C26208     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26208*                                                                         
C26208     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C26208     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C26208        NEXT SENTENCE                                             
C26208     ELSE                                                         
C26208        DISPLAY '***  ERROR IN 7050-SELECT-RESTART  ***'          
C26208        DISPLAY '***  RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
C26208        DISPLAY '***      PROCESSING TERMINATED     ***'          
C26208        PERFORM 9900-ABEND                THRU 9900-EXIT          
C26208     END-IF.                                                      
C26208*                                                                         
C26208 7050-EXIT.                                                       
C26208     EXIT.                                                        
C26208*                                                                 05431000
C30169******************************************************************11290000
C30169** 7060-OPEN-FIN-COL-HST                                        **11300000
C30169**          OPENS THE FIN-COL-HST FOR USE IN FCSRP292           **11310000
C30169******************************************************************11330000
C30169 7060-OPEN-FIN-COL-HST.                                           
C30169*                                                                 11350000
C30169     EXEC SQL                                                     
C30169       OPEN FIN_COL_HST                                           
C30169     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169*                                                                 11390000
C30169     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C30169     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C30169         CONTINUE                                                 
C30169     ELSE                                                         
C30169         DISPLAY '**** ABEND IN 7060-OPEN-FIN-COL-HST ****'       
C30169         DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
C30169         PERFORM 9900-ABEND     THRU 9900-EXIT                    
C30169     END-IF.                                                      
C30169*                                                                 11470000
C30169 7060-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                 11500000
C30169******************************************************************11510000
C30169**  7070-FETCH-FIN-COL-HST                                      **11520000
C30169**         GETS DATA FROM CSS_FIN-WO-COL-HST TABLE.             **11530000
C30169******************************************************************11550000
C30169 7070-FETCH-FIN-COL-HST.                                          
C30169     MOVE '7070' TO WS-ACTIVE-PARAGRAPH.                          
C30169*                                                                 11580000
C30169     EXEC SQL                                                     
C30169        FETCH FIN_COL_HST                                         
C30169         INTO :AT-COMPANY-NO,                                     
C30169              :AT-LOCAL-OFFICE,                                   
C30169              :FM-FW-ACTION-DT :WS-NULL-DATE-LSTD,                 
C30169              :FM-FW-ACTION-AM,                                   
C30169              :FM-CODE-COLLEC-AGNCY,                              
C30169              :FM-FW-ACTION-TYPE-CD,                              
C30169              :FM-ACCOUNT-NO,                                     
C30169              :FM-WITHDRAW-AM,                                    
F30169              :FM-WITHDRAW-DT :WS-NULL-WDRAW-DT,                   
C30169              :FM-WITHDRAW-REASON-CD                              
C30169     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169*                                                                 11710000
C30169     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C30169     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C30169        IF WS-NULL-DATE-LSTD < 0                                  
C30169           MOVE LOW-VALUES     TO KD-FW-ACTION-DT                 
C30169           MOVE ZEROES         TO WS-NULL-DATE-LSTD               
C30169        END-IF                                                    
F30169        IF WS-NULL-WDRAW-DT < 0                                   
F30169           MOVE SPACES         TO FM-WITHDRAW-DT                  
F30169           MOVE ZEROES         TO WS-NULL-WDRAW-DT                
F30169        END-IF                                                    
C30169     ELSE                                                         
C30169        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
C30169           CONTINUE                                               
C30169        ELSE                                                      
C30169           DISPLAY '*** ABEND IN 7070-FETCH-FIN-COL-HST ***'      
C30169           DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
C30169           DISPLAY 'ACCOUNT NO  = ' CO-ACCOUNT-NO                 
C30169           DISPLAY 'LAST PYMT DT= ' AT-LAST-PYMT-DATE             
C30169           PERFORM 7080-CLOSE-FIN-COL-HST THRU 7080-EXIT          
C30169           PERFORM 9900-ABEND THRU 9900-EXIT                      
C30169        END-IF                                                    
C30169     END-IF.                                                      
C30169*                                                                 11810000
C30169 7070-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                 11840000
C30169******************************************************************11850000
C30169**  7080-CLOSE-FIN-COL-HST                                      **11860000
C30169**         CLOSES FIN-COL-HST CURSOR                            **11870000
C30169******************************************************************11890000
C30169 7080-CLOSE-FIN-COL-HST.                                          
C30169     MOVE '7080' TO WS-ACTIVE-PARAGRAPH.                          
C30169*                                                                 11920000
C30169     EXEC SQL                                                     
C30169         CLOSE FIN_COL_HST                                        
C30169     END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
C30169 7080-EXIT.                                                       
C30169     EXIT.                                                        
      ******************************************************************11984900
      * 7100-CHECK-FOR-COMM-PAID.                                       11985000
      *                                                                 11985100
      ******************************************************************11985200
      *                                                                 11985300
       7100-CHECK-FOR-COMM-PAID.                                        
      *                                                                 11985500
            MOVE '7100' TO WS-ACTIVE-PARAGRAPH.                         
      *                                                                 11985700
            MOVE 'N'    TO WS-COMMISSIONS-EXIST.                        
      *                                                                 11985900
            EXEC SQL                                                    
                SELECT DISTINCT                                         
                  'Y'                                                   
                INTO                                                    
                  :WS-COMMISSIONS-EXIST                                 
                FROM                                                    
                   CSS_MNT_TRANS_HIST                                   
                WHERE                                                   
                    ACCOUNT_NO = :CO-ACCOUNT-NO                         
                AND TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :WS-TRANS-HIST-SEQ-NO
              )           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                    11986000
MFA-TR*         SELECT DISTINCT                                         11986100
MFA-TR*           'Y'                                                   11986200
MFA-TR*         INTO                                                    11986300
MFA-TR*           :WS-COMMISSIONS-EXIST                                 11986400
MFA-TR*         FROM                                                    11986500
MFA-TR*            CSS_MNT_TRANS_HIST                                   11986600
MFA-TR*         WHERE                                                   11986700
MFA-TR*             ACCOUNT_NO = :CO-ACCOUNT-NO                         11986800
MFA-TR*         AND TRANS_HIST_SEQ_NO = :WS-TRANS-HIST-SEQ-NO           11986900
MFA-TR*    END-EXEC                                                     11987000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11987100
           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
      *                                                                 11987300
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**** ABEND IN 7100-CHECK-FOR-COMM-PAID   ****'  
               DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
               PERFORM 9900-ABEND     THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                 11988100
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11988400
      ******************************************************************11988500
      ** 7110-OPEN-PAYMENT-CURSOR                                       11988600
      **          OPENS THE PAYMENT CURSOR                              11988700
      **                                                                11988800
      ******************************************************************11988900
      *                                                                 11989000
       7110-OPEN-PAYMENT-CURSOR.                                        
      *                                                                 11989200
           EXEC SQL                                                     
             OPEN PAYMENT_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11989600
           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
      *                                                                 11989800
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**** ABEND IN 7110-OPEN-PAYMENT-CURSOR   ****'  
               DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
               PERFORM 9900-ABEND     THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                 11990600
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11990900
      ******************************************************************11991000
      **  7120-FETCH-PAYMENT-CURSOR                                   **11991100
      **         FETCH PAYMENT CURSOR                                 **11991200
      **                                                              **11991300
      ******************************************************************11991400
      *                                                                 11991500
       7120-FETCH-PAYMENT-CURSOR.                                       
      *                                                                 11991700
           MOVE '7120' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                 11991900
           EXEC SQL                                                     
              FETCH                                                     
                 PAYMENT_CURSOR                                         
              INTO                                                      
                 :WS-CORRECTED-PAYMENT,                                 
                 :WS-TRANS-HIST-SEQ-NO,                                 
                 :WS-PYMT-FACILITY-CD                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11992800
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 11993000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
             OR WS-ACTIVE-RETURN-CODE = NOT-FOUND                       
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**** ABEND IN 7120-FETCH-PAYMENT-CURSOR   ****' 
               DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
               PERFORM 7130-CLOSE-PAYMENT-CURSOR     THRU 7130-EXIT     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 11994000
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11994300
      ******************************************************************11994400
      **  7130-CLOSE-PAYMENT-CURSOR                                   **11994500
      **     CLOSE PAYMENT CURSOR                                     **11994600
      **                                                              **11994700
      ******************************************************************11994800
       7130-CLOSE-PAYMENT-CURSOR.                                       
      *                                                                 11995000
           MOVE '7130' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                 11995200
           EXEC SQL                                                     
               CLOSE PAYMENT_CURSOR                                     
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
      *                                                                 11995600
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11995900
      ******************************************************************11996000
      ******************************************************************11997000
      ** 7300-OPEN-CHRG-OFF-CURSOR2 ..                                **12000000
      **          OPENS THE CHRG-OFF-CURSOR FOR USE IN FIORP275       **12010000
      **                                                              **12020000
      ******************************************************************12030000
       7300-OPEN-CHRG-OFF-CURSOR2.                                      
      *                                                                 12050000
           EXEC SQL                                                     
             OPEN CHRG_OFF_CURSOR2                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12090000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
TP8965         DISPLAY '**** ABEND IN 7300-OPEN-CHRG-OFF-CURSOR2 ****'  
TP8965         DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
               PERFORM 9900-ABEND     THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                 12170000
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12200000
      ******************************************************************12210000
      **  7400-FETCH-CHRG-OFF2 ..                                     **12220000
      **         GETS DATA FROM CSS_CHRG-OFF TABLE                    **12230000
      **                                                              **12240000
      ******************************************************************12250000
       7400-FETCH-CHRG-OFF-CURSOR2.                                     
           MOVE '7400' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                 12280000
           EXEC SQL                                                     
                FETCH CHRG_OFF_CURSOR2                                  
C30169           INTO :IZ-CODE-COLLEC-AGNCY,                            
C30169                :IZ-COLL-AGY-SUB-CD,                              
C30169                :IZ-COMPANY-NO,                                   
C30169                :IZ-REG-GROUP-CD,                                 
C30169                :IZ-ACCOUNT-NO,                                   
C30169                :KD-FW-ACTION-DT :WS-NULL-DATE-LSTD,               
C30169                :KD-FW-ACTION-AM,                                 
TPR                   :AT-COMPANY-NO,                                   
                      :AT-LOCAL-OFFICE,                                 
                      :AT-CUSTOMER-NO,                                  
                      :AT-PREMISE-NO                                    
C30169               ,:AT-TOTAL-AR-BALANCE                              
C30169               ,:AT-CODE-ACCT-STAT                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12370000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C23973        IF WS-NULL-DATE-LSTD < 0                                  
C30169           MOVE LOW-VALUES      TO KD-FW-ACTION-DT                
C23973        END-IF                                                    
C23973     ELSE                                                         
C23973       IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                       
               CONTINUE                                                 
             ELSE                                                       
A01618         DISPLAY '**** ERROR IN 7400-FETCH-CHRG-OFF-CURSOR2 ****' 
TP8965         DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
A01618         IF WS-ACTIVE-RETURN-CODE =  -305 AND                     
A01618                   WS-ISSUE-INDEX <= 10                           
A01618            MOVE '7400'  TO WS-ACCT-ISSUE-CUR                     
A01618            PERFORM 2400-WRITE-EMAIL-FILE       THRU 2400-EXIT    
A01618         ELSE                                                     
                  PERFORM 7500-CLOSE-CHRG-OFF-CURSOR2 THRU 7500-EXIT    
                  PERFORM 9900-ABEND                  THRU 9900-EXIT    
A01618         END-IF                                                   
C23973       END-IF                                                     
           END-IF.                                                      
      *                                                                 12470000
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12500000
      ******************************************************************12510000
      **  7500-CLOSE-CHRG-OFF-CURSOR2 ..                              **12520000
      **         CLOSES CHRG_OFF_CURSOR2                              **12530000
      **                                                              **12540000
      ******************************************************************12550000
       7500-CLOSE-CHRG-OFF-CURSOR2.                                     
           MOVE '7450' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                 12580000
           EXEC SQL                                                     
               CLOSE CHRG_OFF_CURSOR2                                   
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
      *                                                                 12620000
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12950000
      *                                                                 13470000
T26954***************************************************************** 13480000
T26954**  7530-SELECT-REG-GROUP-CD ..                                ** 13490000
T26954**      GETS-DATA FROM CSS_REG-PROFILE                         ** 13500000
T26954**                                                             ** 13510000
T26954***************************************************************** 13520000
T26954 7530-SELECT-REG-GROUP-CD.                                        
T26954     MOVE '7530' TO WS-ACTIVE-PARAGRAPH.                          
T26954*                                                                 13550000
T26954     EXEC SQL                                                     
T26954         SELECT                                                   
T26954            REG_GROUP_CD                                          
T26954         INTO                                                     
T26954            :LR-REG-GROUP-CD                                      
T26954         FROM                                                     
T26954            CSS_REG_PROFILE                                       
T26954         WHERE ACCOUNT_NO = :WS-H-ACCOUNT-NO-PIC9                 
T26954     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T26954*                                                                 13640000
T26954     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T26954     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
T26954         IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
T26954             MOVE '   ' TO LR-REG-GROUP-CD                        
T26954         END-IF                                                   
T26954     ELSE                                                         
T26954         DISPLAY '**** ABEND IN 7530-SELECT-REG-GROUP-CD ****'    
T26954         DISPLAY 'ACCOUNT_NO = ' WS-H-ACCOUNT-NO-PIC9             
T26954         DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
T26954         PERFORM 9900-ABEND THRU 9900-EXIT                        
T26954     END-IF.                                                      
T26954*                                                                 13720000
T26954 7530-EXIT.                                                       
T26954     EXIT.                                                        
T26954*                                                                 13750000
      *                                                                 13470000
      ***************************************************************** 13480000
      **  7545-SELECT-COLL-SUB-RATE-CD.                              ** 13490000
      **      GETS-DATA FROM CSS_COLL_AGY_SUB                        ** 13500000
      **                                                             ** 13510000
      ***************************************************************** 13520000
C30169 7545-SELECT-COLL-SUB-RATE-CD.                                    
           MOVE '7545' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                 13550000
           EXEC SQL                                                     
               SELECT COLL_COMM_RATE_CD                                 
                 INTO :L2-COLL-COMM-RATE-CD                             
                 FROM CSS_COLL_AGY_SUB                                  
                WHERE CODE_COLLEC_AGNCY  = :L2-CODE-COLLEC-AGNCY        
                  AND COLL_AGENCY_SUB_CD = :L2-COLL-AGENCY-SUB-CD       
                  AND COMPANY_NO         = :L2-COMPANY-NO               
                  AND REG_GROUP_CD       = :L2-REG-GROUP-CD             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13640000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**** ABEND IN 7545-SELECT-COLL-SUB-RATE-CD **'  
               DISPLAY 'COLLECTION AGENCY = ' L2-CODE-COLLEC-AGNCY      
               DISPLAY 'COLL AGENCY SUB CD= ' L2-COLL-AGENCY-SUB-CD     
               DISPLAY 'REG GROUP CD      = ' L2-REG-GROUP-CD           
               DISPLAY 'COMPANY_NO        = ' L2-COMPANY-NO             
               DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 13720000
C30169 7545-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13750000
      ***************************************************************** 13760000
      **  7550-SELECT-COLL-COM-RATE ..                               ** 13770000
      **      GETS-DATA FROM CSS_COLL_AGNCY_COM                      ** 13780000
      **                                                             ** 13790000
      ***************************************************************** 13800000
       7550-SELECT-COLL-RATE.                                           
           MOVE '7550' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                 13830000
           EXEC SQL                                                     
               SELECT COLL_COMM_RATE                                    
                 INTO :Q1-COLL-COMM-RATE                                
                 FROM CSS_COLL_AGNCY_COM                                
                WHERE COLL_COMM_RATE_CD = :Q1-COLL-COMM-RATE-CD         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13900000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
TP8965         DISPLAY '**** ABEND IN 7550-SELECT-COLL-RATE ****'       
TP8965         DISPLAY 'COLL COMM RATE CD = ' Q1-COLL-COMM-RATE-CD      
TP8965         DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 13980000
       7550-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14010000
      ***************************************************************** 13760000
C30169**  7560-SELECT-COLL-AGNCY-NAME.                               ** 13770000
      **      GETS-DATA FROM CSS_COLLECT_AGENCY                       **13780000
      **                                                             ** 13790000
      ***************************************************************** 13800000
C30169 7560-SELECT-COLL-AGNCY-NAME.                                     
           MOVE '7560' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                 13830000
           EXEC SQL                                                     
               SELECT COLLEC_AGNCY_NAME                                 
                 INTO :Q7-COLLEC-AGNCY-NAME                             
                 FROM CSS_COLLECT_AGENCY                                
                WHERE CODE_COLLEC_AGNCY = :Q7-CODE-COLLEC-AGNCY         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13900000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**** ABEND IN 7560-SELECT-COLL-AGNCY-NAME ****' 
               DISPLAY 'CODE_COLLEC_AGNCY = ' Q7-CODE-COLLEC-AGNCY      
               DISPLAY 'ACCOUNT_NO = ' IZ-ACCOUNT-NO                    
               DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 13980000
C30169 7560-EXIT.                                                       
C30169     EXIT.                                                        
      *                                                                 14010000
      ******************************************************************14670000
      **  7570-OPEN-RESTORED-ACCT-CSR ..                              **14680000
      **         GETS DATA FROM CSS_ACCOUNT                           **14690000
      **                                                              **14700000
      ******************************************************************14710000
       7570-OPEN-RESTORED-ACCT-CSR.                                     
           MOVE '7570' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                 14740000
           EXEC SQL                                                     
                OPEN  RESTORED_ACCT_CSR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 14780000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
TP8965         DISPLAY '** ABEND IN 7570-OPEN-RESTORED-ACCT-CSR **'     
TP8965         DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
               PERFORM 7580-CLOSE-RESTORED-ACCT-CSR     THRU 7580-EXIT  
               PERFORM 9900-ABEND                       THRU 9900-EXIT  
           END-IF.                                                      
      *                                                                 14870000
       7570-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14900000
      ******************************************************************14910000
      **  7575-FETCH-RESTORED-ACCT-CSR ..                             **14920000
      **         FETCHES DATA FROM CSS_ACCOUNT                        **14930000
      **                                                              **14940000
      ******************************************************************14950000
       7575-FETCH-RESTORED-ACCT-CSR.                                    
           MOVE '7575' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                 14980000
           EXEC SQL                                                     
                FETCH RESTORED_ACCT_CSR                                 
                 INTO :AT-ACCOUNT-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15030000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
TP8965         DISPLAY '** ABEND IN 7575-FETCH-RESTORED-ACCT-CSR **'    
TP8965         DISPLAY 'CUSTOMER NO = ' AT-CUSTOMER-NO                  
TP8965         DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
               PERFORM 7580-CLOSE-RESTORED-ACCT-CSR     THRU 7580-EXIT  
               PERFORM 9900-ABEND                       THRU 9900-EXIT  
           END-IF.                                                      
      *                                                                 15120000
       7575-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15150000
      ******************************************************************15160000
      **  7580-CLOSE-RESTORED-ACCT-CSR ..                             **15170000
      **         CLOSES RESTORED_ACCT_CSR                             **15180000
      **                                                              **15190000
      ******************************************************************15200000
       7580-CLOSE-RESTORED-ACCT-CSR.                                    
           MOVE '7580' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                 15230000
           EXEC SQL                                                     
               CLOSE RESTORED_ACCT_CSR                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
      *                                                                 15270000
       7580-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15300000
      ***************************************************************** 13760000
C30169**  7590-GET-KD-WRITE-OFF-DT.                                  ** 13770000
      **      GETS WRITE OFF DATE FROM CSS_FIN_WO_ACTION              **13780000
      **                                                             ** 13790000
      ***************************************************************** 13800000
C30169 7590-GET-KD-WRITE-OFF-DT.                                        
           MOVE '7590' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                 13830000
           EXEC SQL                                                     
               SELECT TOP(1) FW_ACTION_DT                                      
                 INTO :WS-KD-WRITE-OFF-DT                               
                 FROM CSS_FIN_WO_ACTION WITH(READUNCOMMITTED)                   
                WHERE ACCOUNT_NO = :IZ-ACCOUNT-NO                       
                  AND FW_ACTION_TYPE_CD = 'WO'                          
                  AND FW_ACTION_AM > 0                                  
                ORDER BY FW_SEQ_NO DESC                                 
                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13840000
MFA-TR*        SELECT FW_ACTION_DT                                      13850000
MFA-TR*          INTO :WS-KD-WRITE-OFF-DT                               13860000
MFA-TR*          FROM CSS_FIN_WO_ACTION                                 13870000
MFA-TR*         WHERE ACCOUNT_NO = :IZ-ACCOUNT-NO                       13880000
MFA-TR*           AND FW_ACTION_TYPE_CD = 'WO'                                  
MFA-TR*           AND FW_ACTION_AM > 0                                          
MFA-TR*         ORDER BY FW_SEQ_NO DESC                                         
MFA-TR*         FETCH FIRST 1 ROW ONLY WITH UR                                  
MFA-TR*    END-EXEC.                                                    13890000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13900000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A01618     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**** ABEND IN 7590-GET-KD-WRITE-OFF-DT ****'    
               DISPLAY 'ACCOUNT_NO = ' IZ-ACCOUNT-NO                    
               DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 13980000
C30169 7590-EXIT.                                                       
C30169     EXIT.                                                        
      ***************************************************************** 15310000
      ** 7600-START-FCJ01                                            ** 15320000
      ***************************************************************** 15330000
      *                                                                 15340000
           EXEC SQL                                                     15350000
               INCLUDE CPD00038                                         15360000
           END-EXEC.                                                    15370000
      *                                                                 15380000
      ***************************************************************** 15390000
      ** 7600-START-FCJ01                                            ** 15400000
      ***************************************************************** 15410000
      *                                                                 15420000
           EXEC SQL                                                     15430000
               INCLUDE CPD00039                                         15440000
           END-EXEC.                                                    15450000
      *                                                                 15451000
      ******************************************************************15452000
      *                                                                 15452100
      *  7700-SELECT-WRITE-OFF-BAL                                      15453000
      *                                                                 15454000
      *  SELECTS THE WRITE OFF BALANCE ON THE ACCOUNT.                  15455000
      *                                                                 15455100
      ******************************************************************15456000
      *                                                                 15456100
       7700-SELECT-WRITE-OFF-BAL.                                       
      *                                                                 15458000
           EXEC SQL                                                     
             SELECT                                                     
                SUM(AMT_TRANS)                                          
             INTO                                                       
C30169          :WS-WRITE-OFF-BAL :WS-NULL-WOB                           
             FROM                                                       
                CSS_CHRG_OFF                                            
             WHERE                                                      
                ACCOUNT_NO = :CO-ACCOUNT-NO                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15460000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C30169        IF WS-NULL-WOB = -1                                       
C30169           MOVE ZERO TO WS-NULL-WOB                               
C30169                        WS-WRITE-OFF-BAL                          
              END-IF                                                    
           ELSE                                                         
               DISPLAY '**** ABEND IN 7700-WRITE-OFF-BAL        ****'   
C30169         DISPLAY 'ACCOUNT NO ' CO-ACCOUNT-NO                      
               DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
               PERFORM 9900-ABEND     THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                 15460900
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15462000
      ******************************************************************15464000
      *                                                                 15465000
      *  7705-SELECT-UNUSED-CREDIT                                      15466000
      *                                                                 15467000
      *  SELECTS ANY UNUSED CREDIT ON THE ACCOUNT.                      15468000
      *                                                                 15469000
      ******************************************************************15469100
      *                                                                 15469200
       7705-SELECT-UNUSED-CREDIT.                                       
      *                                                                 15469400
           EXEC SQL                                                     
             SELECT                                                     
                AMT_UNUSED_CR                                           
             INTO                                                       
                :WS-UNUSED-CREDIT                                       
             FROM                                                       
                CSS_AR_CNTL                                             
             WHERE                                                      
                  ACCOUNT_NO = :CO-ACCOUNT-NO                           
             AND PYMT_PRIORITY_LVL = 70                                 
             AND ITEM_ID = 0                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15470700
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = (SUCCESSFUL-CALL OR NOT-FOUND)    
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                   MOVE ZERO        TO WS-UNUSED-CREDIT                 
               END-IF                                                   
           ELSE                                                         
               DISPLAY '**** ABEND IN 7705-SELECT-UNUSED-CREDIT ****'   
               DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
               PERFORM 9900-ABEND     THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                 15471800
       7705-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15472100
      ******************************************************************15473000
      ** 7710-OPEN-TRN-HST-CURSOR ..                                  **15480000
      **          OPENS THE TRN_HST_CURSOR FOR USE IN FCSRP275        **15490000
      **                                                              **15500000
      ******************************************************************15510000
       7710-OPEN-TRN-HST-CURSOR.                                        
      *                                                                 15530000
           EXEC SQL                                                     
             OPEN TRN_HST_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15570000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
TP8965         DISPLAY '**** ABEND IN 7710-OPEN-TRN-HST-CURSOR ****'    
TP8965         DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
               PERFORM 9900-ABEND     THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                 15650000
       7710-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15680000
      ******************************************************************15690000
      **  7715-FETCH-TRN-HST-CURSOR ..                                **15700000
      **         GETS DATA FROM CSS_AR-TRANS-HIST                     **15710000
      **                                                              **15720000
      ******************************************************************15730000
       7715-FETCH-TRN-HST-CURSOR.                                       
           MOVE '7715' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                 15760000
           EXEC SQL                                                     
               FETCH  TRN_HST_CURSOR                                    
                INTO  :AR-AMT-ORIG-ENTERED,                             
                      :AR-CODE-TRAN-TYPE,                               
                      :AR-DATE-ORIG-PYMT :WS-AR-DATE-ORIG-PYMT-NI,      
                      :AR-AMT-BILLED-UNPAID,                            
                      :AR-TRANS-HIST-SEQ-NO,                            
                      :AR-DATE-TRANS,                                   
                      :AR-PYMT-FACILITY-CD                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15880000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL                 
             OR WS-ACTIVE-RETURN-CODE = NOT-FOUND                       
               CONTINUE                                                 
           ELSE                                                         
TP8965         DISPLAY '**** ABEND IN 7715-FETCH-TRN-HST-CURSOR ****'   
TP8965         DISPLAY 'ACCOUNT NO = ' CO-ACCOUNT-NO                    
TP8965         DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
               PERFORM 7720-CLOSE-TRN-HST-CURSOR   THRU 7720-EXIT       
               PERFORM 9900-ABEND                  THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                 15980000
       7715-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16010000
      ******************************************************************16020000
      **  7720-CLOSE-TRN-HST-CURSOR   ..                              **16030000
      **         CLOSES TRN_HST_CURSOR                                **16040000
      **                                                              **16050000
      ******************************************************************16060000
       7720-CLOSE-TRN-HST-CURSOR.                                       
           MOVE '7720' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                 16090000
           EXEC SQL                                                     
               CLOSE TRN_HST_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 16130000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 16131100
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
TP8965         DISPLAY '**** ABEND IN 7720-CLOSE-TRN-HST-CURSOR ****'   
TP8965         DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
               PERFORM 9900-ABEND     THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                 16139000
       7720-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16160000
      ***************************************************************** 16170000
      **  7730-SELECT-MONTHLY-CO-AMTS.                               ** 16180000
      **      GETS DATA FROM CSS_CHG_OFF_AMT                         ** 16190000
      **                                                             ** 16200000
      ***************************************************************** 16210000
      *                                                                 16211000
       7730-SELECT-MONTHLY-CO-AMTS.                                     
      *                                                                 16221000
           MOVE '7730' TO WS-ACTIVE-PARAGRAPH.                          
A01618     MOVE 'Y'    TO WS-CO-AMTS-EXISTS.                            
      *                                                                 16240000
           EXEC SQL                                                     
               SELECT CURR_MTH_ADJ_AMT,                                 
                      CURR_MTH_COLL_AMT,                                
                      CURR_PAID_COLL_AMT,                               
                      AGNCY_PLACED_AMT,                                 
                      AGNCY_FEES_PD_AMT                                 
                 INTO :WS-CURR-MTH-ADJ-AMT,                             
                      :WS-CURR-MTH-COLL-AMT,                            
                      :WS-CURR-PAID-COLL-AMT,                           
T13742                :WS-AGNCY-PLACED-AMT,                             
T13806                :WS-AGNCY-FEES-PD-AMT                             
                 FROM CSS_CHG_OFF_AMT                                   
                WHERE CODE_COLLEC_AGNCY  = :WS-H-CODE-COLLEC-AGNCY      
                 AND  COMPANY_NO         = :WS-H-COMPANY-NO             
                 AND  WRITE_OFF_MONTH_YR = :WS-WO-MONTH-YR              
T26954           AND  REG_GROUP_CD       = :LR-REG-GROUP-CD             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 16370000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 16381000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
TP8965         DISPLAY '**** ERROR IN 7730-SELECT-CHG-OFF-AMTS ****'    
TP8965         DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
A01618         DISPLAY 'ACCOUNT NO  = ' CO-ACCOUNT-NO                   
TP8965         DISPLAY 'COLLECTION AGENCY CODE = '                      
TP8965                    WS-H-CODE-COLLEC-AGNCY                        
               DISPLAY 'WRITE OFF MONTH YEAR = ' WS-WO-MONTH-YR         
T26954         DISPLAY 'LR-REG-GROUP-CD = ' LR-REG-GROUP-CD             
A01618         IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND AND             
A01618                   WS-ISSUE-INDEX <= 10                           
A01618            MOVE 'N'     TO WS-CO-AMTS-EXISTS                     
A01618            MOVE '7730'  TO WS-ACCT-ISSUE-CUR                     
A01618            PERFORM 2400-WRITE-EMAIL-FILE   THRU 2400-EXIT        
A01618         ELSE                                                     
                  PERFORM 9900-ABEND              THRU 9900-EXIT        
A01618         END-IF                                                   
           END-IF.                                                      
      *                                                                 16450000
       7730-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16480000
      ***************************************************************** 16930000
C23972**  7740-SEL-RES-DAYS-FRM-PLCMENT                              ** 16940000
      **      GETS DATE THAT IS 90 DAYS SINCE PLACEMENT WITH AGENCY  ** 16950000
      **                                                             ** 16960000
      ***************************************************************** 16970000
C23972 7740-SEL-RES-DAYS-FRM-PLCMENT.                                   
           MOVE '7740' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                 17000000
           EXEC SQL                                                     
T33185         SELECT
              DATEADD( DAY, (:WS-DELINQ-DAYS-FPLMT), 
              IIF(TRY_CONVERT(DATE, :WS-H-DATE-LSTD-COLL-AGY
              ) IS NULL OR (PATINDEX('%.%', :WS-H-DATE-LSTD-COLL-AGY
              ) <> 0) OR (LEN(:WS-H-DATE-LSTD-COLL-AGY
              ) <> 10), CIS.CHAR2DATE(:WS-H-DATE-LSTD-COLL-AGY
              ), CONVERT(DATE, :WS-H-DATE-LSTD-COLL-AGY) ) )
            INTO
              :WS-RES-DAYS-FROM-PLACEMENT               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     17010000
MFA-TR*        SET    :WS-RES-DAYS-FROM-PLACEMENT =                     17020000
MFA-TR*               DATE(:WS-H-DATE-LSTD-COLL-AGY) +                  17020000
MFA-TR*                      (:WS-DELINQ-DAYS-FPLMT) DAYS               17020000
MFA-TR*    END-EXEC.                                                    17050000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 17060000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
TP8965         DISPLAY '*** ABEND IN 7740-SEL-RES-DAYS-FRM-PLCMENT ***' 
TP8965         DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
TP8965         DISPLAY 'DATE LISTED = ' WS-H-DATE-LSTD-COLL-AGY         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 17140000
       7740-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17170000
      ******************************************************************17190000
      ** 7750-OPEN-TRN-HST-DET-CRSR                                   **17200000
      **          OPENS THE TRN_HST_DET_CURSOR                        **17210000
      **                                                              **17220000
      ******************************************************************17230000
      *                                                                 17231000
       7750-OPEN-TRN-HST-DET-CRSR.                                      
      *                                                                 17250000
           EXEC SQL                                                     
             OPEN TRN_HST_DET_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 17290000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 17301000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**** ABEND IN 7750-OPEN-TRN-HST-DET-CRSR ***'   
               DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
               PERFORM 9900-ABEND     THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                 17380000
       7750-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17410000
      ******************************************************************17420000
      **  7755-FETCH-TRN-HST-DET-CRSR                                 **17430000
      **         GETS DATA FROM CSS_AR_TRN_HST_DET                    **17431000
      **                                                              **17432000
      ******************************************************************17433000
      *                                                                 17433100
       7755-FETCH-TRN-HST-DET-CRSR.                                     
      *                                                                 17434100
           MOVE '7755' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                 17436000
           EXEC SQL                                                     
               FETCH  TRN_HST_DET_CURSOR                                
                INTO  :AU-AMT-POSTED,                                   
                      :AU-GL-ACCT-DEBIT                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 17439900
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 17440100
           IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL                 
             OR WS-ACTIVE-RETURN-CODE = NOT-FOUND                       
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**** ABEND IN 7755-FETCH-TRN-HST-DET-CRSR **'   
               DISPLAY 'ACCOUNT NO = ' CO-ACCOUNT-NO                    
               DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
               PERFORM 7755-FETCH-TRN-HST-DET-CRSR THRU 7755-EXIT       
               PERFORM 9900-ABEND                  THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                 17441300
       7755-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17441600
      ******************************************************************17441700
      **  7760-CLOSE-TRN-HST-DET-CRSR                                 **17441800
      **         CLOSES TRN_HST_DET_CURSOR                            **17441900
      **                                                              **17442000
      ******************************************************************17442100
      *                                                                 17442200
       7760-CLOSE-TRN-HST-DET-CRSR.                                     
      *                                                                 17442400
           MOVE '7760' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                 17442600
           EXEC SQL                                                     
               CLOSE TRN_HST_DET_CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 17443000
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
      *                                                                 17443200
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**** ABEND IN 7760-CLOSE-TRN-HST-DET-CRSR **'   
               DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
               PERFORM 9900-ABEND     THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                 17444000
       7760-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17444300
C23972***************************************************************** 16930000
C23972**  7800-CHECK-VOUCHER-PYMTS                                   ** 16940000
C23972**      CHECK IF THE PAYMENT IS A VOUCHER PAYMENT.             ** 16950000
C23972***************************************************************** 16970000
C23972 7800-CHECK-VOUCHER-PYMTS.                                        
C23972     MOVE '7800'                     TO WS-ACTIVE-PARAGRAPH.      
C23972*                                                                 17000000
C23972     EXEC SQL                                                     
C23972         SELECT 'Y'                                               
C23972           INTO :WS-VOUCHER-PYMT-EXISTS                           
C23972           FROM CSS_AR_TRN_HST_DET                                
C23972          WHERE ACCOUNT_NO        = :CO-ACCOUNT-NO                
C23972            AND TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )         
C23972            AND CURRENCY_TYPE     = 'V'                           
C23972     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     17010000
MFA-TR*        SELECT 'Y'                                               17020000
MFA-TR*          INTO :WS-VOUCHER-PYMT-EXISTS                           17030000
MFA-TR*          FROM CSS_AR_TRN_HST_DET                                17040000
MFA-TR*         WHERE ACCOUNT_NO        = :CO-ACCOUNT-NO                        
MFA-TR*           AND TRANS_HIST_SEQ_NO = :AR-TRANS-HIST-SEQ-NO                 
MFA-TR*           AND CURRENCY_TYPE     = 'V'                                   
MFA-TR*    END-EXEC.                                                    17050000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C23972*                                                                 17060000
C23972     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
C23972     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -811       
C23972         CONTINUE                                                 
C23972     ELSE                                                         
C23972         IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
C23972            MOVE 'N'                 TO WS-VOUCHER-PYMT-EXISTS    
C23972         ELSE                                                     
C23972            DISPLAY '**** 7800-CHECK-VOUCHER-PYMTS ****'          
C23972            DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
C23972            PERFORM 9900-ABEND       THRU 9900-EXIT               
C23972         END-IF                                                   
C23972     END-IF.                                                      
C23972*                                                                 17140000
C23972 7800-EXIT.                                                       
C23972     EXIT.                                                        
C23972***************************************************************** 16930000
C23972**  7810-GET-APPL-PGM-ID                                       ** 16940000
C23972**      GET THE APPL PROGRAM ID FOR THE TRANSACTION.           ** 16950000
C23972***************************************************************** 16970000
C23972 7810-GET-APPL-PGM-ID.                                            
C23972*                                                                 17000000
C23972     MOVE '7810'                     TO WS-ACTIVE-PARAGRAPH.      
C23972     EXEC SQL                                                     
C23972         SELECT APPL_PROGRAM_ID                                   
C23972           INTO :AR-APPL-PROGRAM-ID                               
C23972           FROM CSS_AR_TRANS_HIST                                 
C23972          WHERE ACCOUNT_NO        = :CO-ACCOUNT-NO                
C23972            AND TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )         
C23972     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     17010000
MFA-TR*        SELECT APPL_PROGRAM_ID                                   17020000
MFA-TR*          INTO :AR-APPL-PROGRAM-ID                               17030000
MFA-TR*          FROM CSS_AR_TRANS_HIST                                 17040000
MFA-TR*         WHERE ACCOUNT_NO        = :CO-ACCOUNT-NO                        
MFA-TR*           AND TRANS_HIST_SEQ_NO = :AR-TRANS-HIST-SEQ-NO                 
MFA-TR*    END-EXEC.                                                    17050000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C23972*                                                                 17060000
C23972     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
C23972     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C23972         CONTINUE                                                 
C23972     ELSE                                                         
C23972         DISPLAY '**** 7810-GET-APPL-PGM-ID ****'                 
C23972         DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
C23972         PERFORM 9900-ABEND          THRU 9900-EXIT               
C23972     END-IF.                                                      
C23972*                                                                 17140000
C23972 7810-EXIT.                                                       
C23972     EXIT.                                                        
C23972*                                                                         
C23972***************************************************************** 16930000
C23972** 7900-CHECK-FOR-TRANS                                        ** 16940000
C23972**      CHECK IF THERE ARE ANY FINANCIAL TRANSACTIONS BETWEEN  ** 16950000
C23972**      THE PLACEMENT DATE AND PAYMENT DATE                    ** 16950000
C23972***************************************************************** 16970000
C23972 7900-CHECK-FOR-TRANS.                                            
C23972*                                                                 17000000
C23972     MOVE '7900'                  TO WS-ACTIVE-PARAGRAPH.         
C23972     EXEC SQL                                                     
C23972         SELECT 'Y'                                               
C23972           INTO :WS-FINANCIAL-TRANS-EXISTS                        
C23972           FROM CSS_AR_TRANS_HIST                                 
C23972          WHERE ACCOUNT_NO = :CO-ACCOUNT-NO                       
C30169            AND DATE_TRANS > IIF(TRY_CONVERT(DATE, 
                                                       :KD-FW-ACTION-DT
              ) IS NULL OR (PATINDEX('%.%', :KD-FW-ACTION-DT
              ) <> 0) OR (LEN(:KD-FW-ACTION-DT) <> 10), CIS.CHAR2DATE(
                                                       :KD-FW-ACTION-DT
              ), CONVERT(DATE, :KD-FW-ACTION-DT) )               
C23972            AND DATE_TRANS < IIF(TRY_CONVERT(DATE, :AR-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS
              ) <> 0) OR (LEN(:AR-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :AR-DATE-TRANS
              ), CONVERT(DATE, :AR-DATE-TRANS) )                 
C23972            AND CODE_TRAN_TYPE IN ('P','C','S','I','T','R')       
C23972     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     17010000
MFA-TR*        SELECT 'Y'                                               17020000
MFA-TR*          INTO :WS-FINANCIAL-TRANS-EXISTS                        17030000
MFA-TR*          FROM CSS_AR_TRANS_HIST                                 17040000
MFA-TR*         WHERE ACCOUNT_NO = :CO-ACCOUNT-NO                               
MFA-TR*           AND DATE_TRANS > DATE(:KD-FW-ACTION-DT)                       
MFA-TR*           AND DATE_TRANS < DATE(:AR-DATE-TRANS)                         
MFA-TR*           AND CODE_TRAN_TYPE IN ('P','C','S','I','T','R')               
MFA-TR*    END-EXEC.                                                    17050000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C23972*                                                                 17060000
C23972     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
C23972     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -811       
C23972         CONTINUE                                                 
C23972     ELSE                                                         
C23972         IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
C23972            MOVE 'N'              TO WS-FINANCIAL-TRANS-EXISTS    
C23972         ELSE                                                     
C23972            DISPLAY '**** 7900-CHECK-FOR-TRANS ****'              
C23972            DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
C23972            PERFORM 9900-ABEND    THRU 9900-EXIT                  
C23972         END-IF                                                   
C23972     END-IF.                                                      
C23972*                                                                 17140000
C23972 7900-EXIT.                                                       
C23972     EXIT.                                                        
C23972*                                                                         
C23972***************************************************************** 16930000
C23972** 7910-SELECT-NO-DAYS                                         ** 16940000
C23972**      FIND THE NO. OF DAYS BETWEEN PLACEMENT DATE AND        ** 16950000
C23972**      PAYMENT DATE.                                          ** 16950000
C23972***************************************************************** 16970000
C23972 7910-SELECT-NO-DAYS.                                             
C23972*                                                                 17000000
C23972     MOVE '7910'                  TO WS-ACTIVE-PARAGRAPH.         
C23972     EXEC SQL                                                     
T33185         SELECT
              CIS.DAYS(IIF(TRY_CONVERT(DATE, :AR-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS
              ) <> 0) OR (LEN(:AR-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :AR-DATE-TRANS
              ), CONVERT(DATE, :AR-DATE-TRANS) )) -                      
C30169                       CIS.DAYS(IIF(TRY_CONVERT(DATE, 
                                                       :KD-FW-ACTION-DT
              ) IS NULL OR (PATINDEX('%.%', :KD-FW-ACTION-DT
              ) <> 0) OR (LEN(:KD-FW-ACTION-DT) <> 10), CIS.CHAR2DATE(
                                                       :KD-FW-ACTION-DT
              ), CONVERT(DATE, :KD-FW-ACTION-DT) ))
            INTO
              :WS-NO-DAYS               
C23972     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     17010000
MFA-TR*        SET :WS-NO-DAYS =                                        17020000
MFA-TR*               DAYS(DATE(:AR-DATE-TRANS)) -                      17020000
MFA-TR*                      DAYS(DATE(:KD-FW-ACTION-DT))               17020000
MFA-TR*    END-EXEC.                                                    17050000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C23972*                                                                 17060000
C23972     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
C23972     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C23972         CONTINUE                                                 
C23972     ELSE                                                         
C23972         DISPLAY '**** 7910-SELECT-NO-DAYS ****'                  
C23972         DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
C23972         PERFORM 9900-ABEND       THRU 9900-EXIT                  
C23972     END-IF.                                                      
C23972*                                                                 17140000
C23972 7910-EXIT.                                                       
C23972     EXIT.                                                        
C23972*                                                                 17160000
C23972***************************************************************** 16930000
C23972** 7920-GET-DELINQ-VALUE                                       ** 16940000
C23972**      GET THE DELINQUENCY VALUE FOR THE DELINQ CODE          ** 16950000
C23972***************************************************************** 16970000
C23972 7920-GET-DELINQ-VALUE.                                           
C23972     MOVE '7920'                  TO WS-ACTIVE-PARAGRAPH.         
C23972*                                                                 17000000
C23972     EXEC SQL                                                     
C23972         SELECT DELINQ_VALUE                                      
C23972           INTO :C8-DELINQ-VALUE                                  
C23972           FROM CSS_DELINQUENCY                                   
C23972          WHERE DELINQ_CD  = :C8-DELINQ-CD                        
C23972            AND COMPANY_NO = :C8-COMPANY-NO                       
C23972     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C23972*                                                                 17060000
C23972     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
C23972     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C23972         CONTINUE                                                 
C23972     ELSE                                                         
C23972         DISPLAY '**** 7920-GET-DELINQ-VALUE ****'                
C23972         DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
C23972         PERFORM 9900-ABEND       THRU 9900-EXIT                  
C23972     END-IF.                                                      
C23972*                                                                 17140000
C23972 7920-EXIT.                                                       
C23972     EXIT.                                                        
      ******************************************************************17445000
      **  8000-UPDATE-CHRG-OFF ..                                     **17450000
      **            UPDATES DATE CHARGE WITHDRAW ON THE CSS_CHRG_OFF  **17460000
      **                                                              **17470000
      ******************************************************************17480000
       8000-UPDATE-CHRG-OFF.                                            
      *                                                                 17500000
           EXEC SQL                                                     
             UPDATE CSS_CHRG_OFF                                        
C30169         SET WO_STATUS          = :WS-WITHDRAWN-CD                
             WHERE ACCOUNT_NO         = :CO-ACCOUNT-NO                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 17580000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL                 
               CONTINUE                                                 
           ELSE                                                         
TP8965         DISPLAY '**** ABEND IN 8000-UPDATE-CHRG-OFF ****'        
TP8965         DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
TP8965         DISPLAY 'ACCOUNT NO = ' CO-ACCOUNT-NO                    
TP8965         DISPLAY 'PAYMENT PRIORITY LEVEL = ' CO-PYMT-PRIORITY-LVL 
               PERFORM 9900-ABEND     THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                 17660000
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17690000
C30169******************************************************************17445000
C30169**  8020-UPDATE-FIN-WO-COLLECT.                             **    17450000
C30169**       UPDATES WITHDRAW DT AND REASON ON CSS_FIN_WO_COLLECT   **17460000
C30169**       FOR PAID OFF ACCTS.                                    **17470000
C30169******************************************************************17480000
       8020-UPDATE-FIN-WO-COLLECT.                                      
      *                                                                 17500000
           EXEC SQL                                                     
             UPDATE CSS_FIN_WO_COLLECT                                  
               SET WITHDRAW_DT        = IIF(TRY_CONVERT(DATE, 
                                                        :IZ-WITHDRAW-DT
              ) IS NULL OR (PATINDEX('%.%', :IZ-WITHDRAW-DT
              ) <> 0) OR (LEN(:IZ-WITHDRAW-DT) <> 10), CIS.CHAR2DATE(
                                                        :IZ-WITHDRAW-DT
              ), CONVERT(DATE, :IZ-WITHDRAW-DT) )                 
                  ,WITHDRAW_REASON_CD = :IZ-WITHDRAW-REASON-CD          
                  ,WITHDRAW_AM        = :IZ-WITHDRAW-AM                 
             WHERE ACCOUNT_NO         = :IZ-ACCOUNT-NO                  
               AND FW_ACTION_TYPE_CD  = :IZ-FW-ACTION-TYPE-CD           
               AND FW_COLL_SEQ_NO     = :IZ-FW-COLL-SEQ-NO              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     17510000
MFA-TR*      UPDATE CSS_FIN_WO_COLLECT                                  17520000
MFA-TR*        SET WITHDRAW_DT        = :IZ-WITHDRAW-DT                 17530000
MFA-TR*           ,WITHDRAW_REASON_CD = :IZ-WITHDRAW-REASON-CD          17533000
MFA-TR*           ,WITHDRAW_AM        = :IZ-WITHDRAW-AM                         
MFA-TR*      WHERE ACCOUNT_NO         = :IZ-ACCOUNT-NO                  17540000
MFA-TR*        AND FW_ACTION_TYPE_CD  = :IZ-FW-ACTION-TYPE-CD           17542200
MFA-TR*        AND FW_COLL_SEQ_NO     = :IZ-FW-COLL-SEQ-NO              17542200
MFA-TR*    END-EXEC.                                                    17570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 17580000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL                 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**** 8020-UPDATE-FIN-WO-COLLECT ***'            
               DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
               DISPLAY 'ACCOUNT NO = ' IZ-ACCOUNT-NO                    
               DISPLAY 'FW_ACTION_TYPE = ' IZ-FW-ACTION-TYPE-CD         
               DISPLAY 'FW_COLL_SEQ_NO = ' IZ-FW-COLL-SEQ-NO            
               PERFORM 9900-ABEND     THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                 17660000
C30169 8020-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
C30169******************************************************************17445000
C30169**  8030-UPDATE-FW-COLLECT-STATUS.                              **17450000
C30169**       UPDATES COLLECT STATUS CD BASED ON THE TYPE OF PLACEMENT*17460000
C30169**       THAT IS WITHDRAWN.                                     **17470000
C30169******************************************************************17480000
       8030-UPDATE-FW-COLLECT-STATUS.                                   
      *                                                                 17500000
           EXEC SQL                                                     
             UPDATE CSS_FINAL_WO                                        
               SET COLLECT_STATUS_CD  = :FW-COLLECT-STATUS-CD           
             WHERE ACCOUNT_NO         = :FW-ACCOUNT-NO                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 17580000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL                 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**** 8030-UPDATE-FW-COLLECT-STATUS  ***'        
               DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
               DISPLAY 'ACCOUNT NO = ' FW-ACCOUNT-NO                    
               DISPLAY 'COLLECT STATUS CD = ' FW-COLLECT-STATUS-CD      
               DISPLAY 'FW_ACTION_TYPE = ' IZ-FW-ACTION-TYPE-CD         
               DISPLAY 'FW_COLL_SEQ_NO = ' IZ-FW-COLL-SEQ-NO            
               PERFORM 9900-ABEND     THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                 17660000
C30169 8030-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
T10120******************************************************************17692000
      **  8050-UPDATE-CHRG-OFF-AMT                                    **17693000
      **       UPDATE/ INSERT WITHDRAW COUNT AND AMT FOR COLL AGENCY  **17694000
      **                                                              **17695000
      ******************************************************************17696000
       8050-UPDATE-CHRG-OFF-AMT.                                        
      *                                                                 17698000
           MOVE WS-WO-MONTH-YR       TO SN-WRITE-OFF-MONTH-YR           
C30169     MOVE IZ-CODE-COLLEC-AGNCY TO SN-CODE-COLLEC-AGNCY.           
           MOVE AT-COMPANY-NO        TO SN-COMPANY-NO       .           
T26954     MOVE LR-REG-GROUP-CD      TO SN-REG-GROUP-CD     .           
      *                                                                 17698800
           EXEC SQL                                                     
                SELECT WITHDRAWN_COUNT,                                 
                       WITHDRAWN_AMT                                    
                INTO                                                    
                      :SN-WITHDRAWN-COUNT,                              
                      :SN-WITHDRAWN-AMT                                 
                FROM CSS_CHG_OFF_AMT                                    
                WHERE CODE_COLLEC_AGNCY  = :SN-CODE-COLLEC-AGNCY        
                  AND WRITE_OFF_MONTH_YR = :SN-WRITE-OFF-MONTH-YR       
                  AND COMPANY_NO         = :SN-COMPANY-NO               
T26954            AND REG_GROUP_CD       = :SN-REG-GROUP-CD             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 17700000
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
               DISPLAY '**** ABEND IN 8050-UPDATE-CHRG-OFF-AMT'         
               DISPLAY '**** ON SELECT FROM CSS_CHRG_OFF_AMT   '        
               DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
               DISPLAY 'CODE COLLEC AGNCY  = ' SN-CODE-COLLEC-AGNCY     
               DISPLAY 'WRITE OFF MONTH YR = ' SN-WRITE-OFF-MONTH-YR    
T26954         DISPLAY 'SN-REG-GROUP-CD = ' SN-REG-GROUP-CD             
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 17701400
           IF SQLCODE = SUCCESSFUL-CALL                                 
              ADD  1                  TO SN-WITHDRAWN-COUNT             
              ADD  WS-WITHDRAWN-BAL   TO SN-WITHDRAWN-AMT               
      *                                                                 17701800
              EXEC SQL                                                  
                  UPDATE CSS_CHG_OFF_AMT                                
                     SET WITHDRAWN_COUNT = :SN-WITHDRAWN-COUNT,         
                         WITHDRAWN_AMT   = :SN-WITHDRAWN-AMT            
                  WHERE CODE_COLLEC_AGNCY  = :SN-CODE-COLLEC-AGNCY      
                    AND WRITE_OFF_MONTH_YR = :SN-WRITE-OFF-MONTH-YR     
                    AND COMPANY_NO         = :SN-COMPANY-NO             
T26954              AND REG_GROUP_CD       = :SN-REG-GROUP-CD           
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 17702700
              IF SQLCODE = SUCCESSFUL-CALL                              
                  NEXT SENTENCE                                         
              ELSE                                                      
                 DISPLAY '**** ABEND IN 8050-UPDATE-CHRG-OFF-AMT'       
                 DISPLAY '**** ON UPDATE OF   CSS_CHRG_OFF_AMT   '      
                 DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
                 DISPLAY 'CODE COLLEC AGNCY  = ' SN-CODE-COLLEC-AGNCY   
                 DISPLAY 'WRITE OFF MONTH YR = ' SN-WRITE-OFF-MONTH-YR  
T26954           DISPLAY 'SN-REG-GROUP-CD = ' SN-REG-GROUP-CD           
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
      *                                                                 17704200
           ELSE                                                         
              MOVE 1                  TO SN-WITHDRAWN-COUNT             
              MOVE WS-WITHDRAWN-BAL   TO SN-WITHDRAWN-AMT               
              EXEC SQL                                                  
                  INSERT INTO  CSS_CHG_OFF_AMT                          
                        (WITHDRAWN_COUNT                                
                        ,WITHDRAWN_AMT                                  
T26954                  ,REG_GROUP_CD                                   
                        ,CODE_COLLEC_AGNCY                              
                        ,WRITE_OFF_MONTH_YR                             
                        ,COMPANY_NO)                                    
                  VALUES                                                
                        (:SN-WITHDRAWN-COUNT,                           
                         :SN-WITHDRAWN-AMT,                             
T26954                   :SN-REG-GROUP-CD,                              
                         :SN-CODE-COLLEC-AGNCY,                         
                         :SN-WRITE-OFF-MONTH-YR,                        
                         :SN-COMPANY-NO)                                
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              IF SQLCODE = SUCCESSFUL-CALL                              
                  NEXT SENTENCE                                         
              ELSE                                                      
                 DISPLAY '**** ABEND IN 8050-UPDATE-CHRG-OFF-AMT'       
                 DISPLAY '**** ON INSERT INTO CSS_CHRG_OFF_AMT   '      
                 DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
                 DISPLAY 'CODE COLLEC AGNCY  = ' SN-CODE-COLLEC-AGNCY   
                 DISPLAY 'WRITE OFF MONTH YR = ' SN-WRITE-OFF-MONTH-YR  
T26954           DISPLAY 'SN-REG-GROUP-CD = ' SN-REG-GROUP-CD           
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                 17707600
       8050-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17707900
      ******************************************************************17708000
      **  8100-UPDATE-JOB-PARM ..                                     **17710000
      **            UPDATES RUN DATE IN CSS_JOB_PARM TABLE            **17720000
      **                                                              **17730000
      ******************************************************************17740000
       8100-UPDATE-JOB-PARM.                                            
      *                                                                 17760000
           MOVE WS-INPUT-DATE      TO WS-LAST-RUN-DATE.                 
      *                                                                 12050000
A02036     EXEC SQL                                                     
A02036         SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-LAST-TRN-DT                  
A02036     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     17010000
MFA-TR*        SET :WS-LAST-TRN-DT = CURRENT TIMESTAMP                  17020000
MFA-TR*    END-EXEC.                                                    17050000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE WS-PARM-DATA       TO G6-PARM-DATA.                     
      *                                                                 17790000
           EXEC SQL                                                     
                UPDATE CSS_JOB_PARM                                     
                   SET PARM_DATA         = :G6-PARM-DATA                
                 WHERE PROGRAM_NAME      = :WS-PGRMNAME                 
                 AND   COMPANY_NO        = :WS-P-COMPANY-NO             
                 AND   CMND_CODE         = :WS-P-CMD-CODE               
                 AND   SEQ_NO            = :WS-P-SEQ-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 17880000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL                 
               CONTINUE                                                 
           ELSE                                                         
TP8965         DISPLAY '**** ABEND IN 8100-UPDATE-JOB-PARM ****'        
TP8965         DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
TP8965         DISPLAY 'PROGRAM NAME = ' WS-PGRMNAME                    
TP8965         DISPLAY 'COMPANY NO = ' WS-P-COMPANY-NO                  
TP8965         DISPLAY 'COMMAND CODE = ' WS-P-CMD-CODE                  
TP8965         DISPLAY 'SEQUENCE NO = ' WS-P-SEQ-NO                     
               PERFORM 9900-ABEND     THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                 17960000
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17990000
      ******************************************************************18000000
      **  8200-UPDATE-AGNCY-COLL                                      **18010000
      **            UPDATES CURRENT COLLECT AMOUNT FOR THE AGENCY     **18020000
      **            AGENCY                                            **18030000
      ******************************************************************18040000
      *                                                                 18041000
       8200-UPDATE-AGNCY-COLL.                                          
      *                                                                 18060000
           EXEC SQL                                                     
             UPDATE CSS_CHG_OFF_AMT                                     
               SET CURR_MTH_COLL_AMT       = :WS-CURR-MTH-COLL-AMT      
               WHERE CODE_COLLEC_AGNCY     = :WS-H-CODE-COLLEC-AGNCY    
               AND   COMPANY_NO            = :AT-COMPANY-NO             
               AND   WRITE_OFF_MONTH_YR    = :WS-WO-MONTH-YR            
T26954         AND   REG_GROUP_CD          = :LR-REG-GROUP-CD           
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 18140000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL                 
               CONTINUE                                                 
           ELSE                                                         
TP8965         DISPLAY '**** ABEND IN 8200-UPDATE-AGNCY-COLL ****'      
TP8965         DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
TP8965         DISPLAY 'COLLECTION AGENCY CODE = '                      
TP8965                            WS-H-CODE-COLLEC-AGNCY                
TP8965         DISPLAY 'COMPANY NO = ' AT-COMPANY-NO                    
TP8965         DISPLAY 'WRITE OFF MONTH/YEAR = ' WS-WO-MONTH-YR         
T26954         DISPLAY 'LR-REG-GROUP-CD = ' LR-REG-GROUP-CD             
               PERFORM 9900-ABEND     THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                 18220000
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18250000
      ******************************************************************18260000
      **  8210-UPDATE-SCEG-COLL                                       **18270000
      **   UPDATES CURRENT COLLECT AMOUNT FOR SCEG                    **18280000
      **                                                              **18290000
      ******************************************************************18300000
      *                                                                 18301000
       8210-UPDATE-SCEG-COLL.                                           
      *                                                                 18320000
           EXEC SQL                                                     
             UPDATE CSS_CHG_OFF_AMT                                     
               SET CURR_PAID_COLL_AMT      = :WS-CURR-PAID-COLL-AMT     
             WHERE CODE_COLLEC_AGNCY       = :WS-H-CODE-COLLEC-AGNCY    
               AND   COMPANY_NO            = :AT-COMPANY-NO             
               AND   WRITE_OFF_MONTH_YR    = :WS-WO-MONTH-YR            
T26954         AND   REG_GROUP_CD          = :LR-REG-GROUP-CD           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 18400000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL                 
               CONTINUE                                                 
           ELSE                                                         
TP8965         DISPLAY '**** ABEND IN 8210-UPDATE-SCEG-COLL ****'       
TP8965         DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
TP8965         DISPLAY 'COLLECTION AGENCY CODE = '                      
TP8965                               WS-H-CODE-COLLEC-AGNCY             
TP8965         DISPLAY 'COMPANY NO = ' AT-COMPANY-NO                    
TP8965         DISPLAY 'WRITE OFF MONTH/YEAR = ' WS-WO-MONTH-YR         
T26954         DISPLAY 'LR-REG-GROUP-CD = ' LR-REG-GROUP-CD             
               PERFORM 9900-ABEND     THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                 18480000
       8210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18510000
      ******************************************************************18520000
      **  8220-UPDATE-SCEG-ADJ                                        **18530000
      **            UPDATES/INSERTS ADJUSTMENT AMOUNT FOR SCEG        **18540000
      **                                                              **18550000
      ******************************************************************18560000
       8220-UPDATE-SCEG-ADJ.                                            
      *                                                                 18580000
           EXEC SQL                                                     
             UPDATE CSS_CHG_OFF_AMT                                     
               SET CURR_MTH_ADJ_AMT       = :WS-CURR-MTH-ADJ-AMT        
C30169       WHERE CODE_COLLEC_AGNCY      = :IZ-CODE-COLLEC-AGNCY       
               AND COMPANY_NO             = :AT-COMPANY-NO              
               AND WRITE_OFF_MONTH_YR     = :WS-WO-MONTH-YR             
T26954         AND REG_GROUP_CD           = :LR-REG-GROUP-CD            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 18660000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL                 
               CONTINUE                                                 
           ELSE                                                         
TP8965         DISPLAY '**** ABEND IN 8220-UPDATE-SCEG-ADJ ***'         
TP8965         DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
C30169         DISPLAY 'COLLECTION AGENCY CODE = ' IZ-CODE-COLLEC-AGNCY 
TP8965         DISPLAY 'COMPANY NO = ' AT-COMPANY-NO                    
TP8965         DISPLAY 'WRITE OFF MONTH/YEAR = ' WS-WO-MONTH-YR         
T26954         DISPLAY 'LR-REG-GROUP-CD = ' LR-REG-GROUP-CD             
               PERFORM 9900-ABEND     THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                 18740000
       8220-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18770000
      ******************************************************************18772000
      **  8225-UPD-AGNCY-PLACED-AMT                                   **18773000
      **            UPDATES AGENCY PLACED AMOUNT WITH THE CORRECTION  **18774000
      **            OR NEW CHARGE                                     **18774100
      **                                                              **18775000
      ******************************************************************18776000
      *                                                                 18776100
T13742 8225-UPD-AGNCY-PLACED-AMT.                                       
      *                                                                 18778000
           EXEC SQL                                                     
             UPDATE CSS_CHG_OFF_AMT                                     
               SET AGNCY_PLACED_AMT       = :WS-AGNCY-PLACED-AMT        
             WHERE CODE_COLLEC_AGNCY      = :IZ-CODE-COLLEC-AGNCY       
               AND COMPANY_NO             = :AT-COMPANY-NO              
               AND WRITE_OFF_MONTH_YR     = :WS-WO-MONTH-YR             
T26954         AND REG_GROUP_CD           = :LR-REG-GROUP-CD            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 18779700
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL                 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**** ABEND IN 8225-UPD-AGNCY-PLACED-AMT ***'    
               DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
C30169         DISPLAY 'COLLECTION AGENCY CODE = ' IZ-CODE-COLLEC-AGNCY 
               DISPLAY 'COMPANY NO = ' AT-COMPANY-NO                    
               DISPLAY 'WRITE OFF MONTH/YEAR = ' WS-WO-MONTH-YR         
T26954         DISPLAY 'LR-REG-GROUP-CD = ' LR-REG-GROUP-CD             
               PERFORM 9900-ABEND     THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                 18780900
       8225-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18781200
      ******************************************************************18781300
      **  8230-UPDATE-AGNCY-FEES-PD                                   **18781400
      **            UPDATES CURRENT AGENCY FEES PAID AMOUNT           **18781500
      ******************************************************************18781700
      *                                                                 18781800
T13806 8230-UPDATE-AGNCY-FEES-PD.                                       
      *                                                                 18782000
           EXEC SQL                                                     
             UPDATE CSS_CHG_OFF_AMT                                     
               SET AGNCY_FEES_PD_AMT       = :WS-AGNCY-FEES-PD-AMT      
               WHERE CODE_COLLEC_AGNCY     = :WS-H-CODE-COLLEC-AGNCY    
               AND   COMPANY_NO            = :AT-COMPANY-NO             
               AND   WRITE_OFF_MONTH_YR    = :WS-WO-MONTH-YR            
T26954         AND   REG_GROUP_CD          = :LR-REG-GROUP-CD           
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 18782800
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL                 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**** ABEND IN 8230-UPDATE-AGNCY-FEES-PD **'     
               DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
               DISPLAY 'COLLECTION AGENCY CODE = '                      
                                  WS-H-CODE-COLLEC-AGNCY                
               DISPLAY 'COMPANY NO = ' AT-COMPANY-NO                    
               DISPLAY 'WRITE OFF MONTH/YEAR = ' WS-WO-MONTH-YR         
T26954         DISPLAY 'LR-REG-GROUP-CD = ' LR-REG-GROUP-CD             
               PERFORM 9900-ABEND     THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                 18784100
       8230-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18784400
C26208******************************************************************18785000
C26208*   8235-WRITE-RESTART                                                    
C26208*   UPDATE RESTART TABLE. INSERT IF NO ROW EXISTS.                        
C26208******************************************************************18785000
C26208 8235-WRITE-RESTART.                                              
C26208*                                                                 18785000
C26208     EXEC SQL                                                     
C26208        UPDATE CSS_RESTART                                        
C26208           SET RESTART_DATA = :RF-RESTART-DATA                    
C26208         WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                    
C26208           AND PARTITION_NO = :RF-PARTITION-NO                    
C26208           AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                    
C26208     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26208*                                                                 18785000
C26208     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C26208     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C26208        CONTINUE                                                  
C26208     ELSE                                                         
C26208        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
C26208           PERFORM 8236-INSERT-RESTART         THRU 8236-EXIT     
C26208        ELSE                                                      
C26208           DISPLAY '*** ABEND IN 8235-WRITE-RESTART ***'          
C26208           DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
C26208           DISPLAY 'PROGRAM NAME  ' RF-NAME-PROGRAM               
C26208           DISPLAY 'PARTITION NO  ' RF-PARTITION-NO               
C26208           PERFORM 9900-ABEND                  THRU 9900-EXIT     
C26208        END-IF                                                    
C26208     END-IF.                                                      
C26208*                                                                 18785000
C26208 8235-EXIT.                                                       
C26208     EXIT.                                                        
C26208******************************************************************18785000
C26208* 8236-INSERT-RESTART                                                     
C26208*  INSERT RESTART ROW                                                     
C26208******************************************************************18785000
C26208 8236-INSERT-RESTART.                                             
C26208*                                                                 18785000
C26208     EXEC SQL                                                     
C26208        INSERT INTO CSS_RESTART                                   
C26208               (NAME_PROGRAM,                                     
C26208                PARTITION_NO,                                     
C26208                DUP_CNTRL_NO,                                     
C26208                RESTART_DATA)                                     
C26208        VALUES                                                    
C26208               (:RF-NAME-PROGRAM,                                 
C26208                :RF-PARTITION-NO,                                 
C26208                :RF-DUP-CNTRL-NO,                                 
C26208                :RF-RESTART-DATA)                                 
C26208     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26208*                                                                         
C26208     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C26208     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C26208        CONTINUE                                                  
C26208     ELSE                                                         
C26208        DISPLAY '*** ABEND IN 8236-INSERT-RESTART ***'            
C26208        DISPLAY '*** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
C26208        DISPLAY 'PROGRAM NAME  ' RF-NAME-PROGRAM                  
C26208        DISPLAY 'PARTITION NO  ' RF-PARTITION-NO                  
C26208        PERFORM 9900-ABEND                     THRU 9900-EXIT     
C26208     END-IF.                                                      
C26208                                                                  
C26208 8236-EXIT.                                                       
C26208     EXIT.                                                        
C26208******************************************************************18785000
C26208* 8237-DELETE-RESTART-ROW                                         18785000
C26208******************************************************************18785000
C26208 8237-DELETE-RESTART-ROW.                                         
C26208*                                                                 18785000
C26208     MOVE PROGRAM-NAME           TO RF-NAME-PROGRAM.              
C26208     MOVE 1                      TO RF-PARTITION-NO.              
C26208     MOVE 1                      TO RF-DUP-CNTRL-NO.              
C26208     EXEC SQL                                                     
C26208         DELETE FROM CSS_RESTART                                  
C26208          WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                   
C26208            AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
C26208            AND PARTITION_NO = :RF-PARTITION-NO                   
C26208     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26208                                                                  
C26208     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C26208     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C26208        CONTINUE                                                  
C26208     ELSE                                                         
C26208        DISPLAY '*** ERROR IN 8237-DELETE-RESTART-ROW ***'        
C26208        DISPLAY '*** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
C26208        DISPLAY '***       PROCESSING TERMINATED      ***'        
C26208     END-IF.                                                      
C26208*                                                                 18785000
C26208 8237-EXIT.                                                       
C26208     EXIT.                                                        
C26208******************************************************************18785000
C26208* 8238-RESET-JOB-PARM                                             18785000
C26208******************************************************************18785000
C26208 8238-RESET-JOB-PARM.                                             
C26208                                                                  
C26208     EXEC SQL                                                     
C26208         UPDATE CSS_JOB_PARM                                      
C26208            SET STATUS       = :G6-STATUS,                        
C26208                PARM_DATA    = :G6-PARM-DATA                      
C26208          WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                   
C26208            AND CMND_CODE    = :G6-CMND-CODE                      
C26208            AND COMPANY_NO   = :G6-COMPANY-NO                     
C26208            AND SEQ_NO       = :G6-SEQ-NO                         
C26208     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26208                                                                  
C26208     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
C26208     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C26208        CONTINUE                                                  
C26208     ELSE                                                         
C26208        DISPLAY '*** ERROR IN 8238-RESET-JOB-PARM ***'            
C26208        DISPLAY '*** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
C26208        DISPLAY '***   PROCESSING TERMINATED ***'                 
C26208        PERFORM 9900-ABEND                     THRU 9900-EXIT     
C26208     END-IF.                                                      
C26208*                                                                 18785000
C26208 8238-EXIT.                                                       
C26208     EXIT.                                                        
      *                                                                 18784500
      ******************************************************************18785000
      **  COPYBOOK CPD00104                                           **18790000
      **            LOADS COMPANY END RECORDS TO A TABLE              **18800000
      **                                                              **18810000
      ******************************************************************18820000
       COPY CPD00104.                                                   18830000
      *                                                                 18840000
      ******************************************************************18850000
      **  COPYBOOK CPD00105                                           **18860000
      **            WRITES COMPANY END RECORDS FROM A TABLE           **18870000
      **                                                              **18880000
      ******************************************************************18890000
       COPY CPD00105.                                                   18900000
      *                                                                 18910000
      *                                                                 18920000
      ******************************************************************18930000
      **  8840-WRITE-END-REC.                                         **18940000
      **            WRITES COMPANY END RECORDS TO THE FILE.           **18950000
      **                                                              **18960000
      ******************************************************************18970000
       8840-WRITE-END-REC.                                              
      *                                                                 18990000
           IF FLG-FRP275 EQUAL WS-Y                                     
               MOVE COMPANY-END-REC        TO E-FRP275-COMPANY-END-REC  
C23973         MOVE WS-FRP275-READ-COUNT   TO E-FRP275-CO-REC-COUNT-EREC
T26954         MOVE HIGH-VALUES            TO E-FRP275-CO-REC-REG-GROUP 
               PERFORM 8910-WRITE-FCSRP275             THRU 8910-EXIT   
               SUBTRACT 1 FROM WS-FRP275-READ-COUNT                     
           ELSE                                                         
C23973         MOVE COMPANY-END-REC        TO E-FRP292-COMPANY-END-REC  
C23973         MOVE WS-FRP292-READ-COUNT   TO E-FRP292-CO-REC-COUNT-EREC
T26954         MOVE HIGH-VALUES            TO E-FRP292-CO-REC-REG-GROUP 
               PERFORM 8900-WRITE-FCSRP292             THRU 8900-EXIT   
               SUBTRACT 1 FROM WS-FRP292-READ-COUNT                     
           END-IF.                                                      
      *                                                                 19030000
       8840-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19060000
      ******************************************************************19070000
      **  8900-WRITE-FCSRP292 ..                                      **19080000
      **            WRITES OUT DATA TO FIORP292 FILE                  **19090000
      **                                                              **19100000
      ******************************************************************19110000
       8900-WRITE-FCSRP292.                                             
      *                                                                 19130000
           WRITE FIORP292.                                              
      *                                                                 19150000
           IF FRP292-SUCCESSFUL                                         
              ADD 1                 TO WS-FRP292-READ-COUNT             
           ELSE                                                         
               DISPLAY '8900-ERROR ON FCSRP292 WRITE. STATUS IS '       
                        WS-FRP275-STATUS                                
               PERFORM 9900-ABEND   THRU 9900-EXIT                      
           END-IF.                                                      
      *                                                                 19230000
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19260000
      ******************************************************************19270000
      **  8910-WRITE-FCSRP275 ..                                      **19280000
      **            WRITES OUT DATA TO FIORP275 FILE                  **19290000
      **                                                              **19300000
      ******************************************************************19310000
       8910-WRITE-FCSRP275.                                             
      *                                                                 19330000
           WRITE FIORP275.                                              
      *                                                                 19350000
           IF FRP275-SUCCESSFUL                                         
              ADD 1                 TO WS-FRP275-READ-COUNT             
           ELSE                                                         
               DISPLAY '8910-ERROR ON FCSRP275 WRITE. STATUS IS '       
                        WS-FRP275-STATUS                                
TP8965         DISPLAY 'ACCOUNT NO = ' E-FRP275-ACCOUNT-NO              
               PERFORM 9900-ABEND   THRU 9900-EXIT                      
           END-IF.                                                      
      *                                                                 19430000
       8910-EXIT.                                                       
           EXIT.                                                        
C26208*                                                                         
C26208******************************************************************19470000
C26208*   8915-COMMIT                                                           
C26208******************************************************************19470000
C26208 8915-COMMIT.                                                     
C26208*                                                                         
C26208     PERFORM 8916-PRE-COMMIT                     THRU 8916-EXIT.  
C26208     PERFORM 8235-WRITE-RESTART                  THRU 8235-EXIT.  
C26208     MOVE WS-SEQ-NO            TO G6-SEQ-NO                       
C26208     MOVE WS-A                 TO G6-STATUS                       
C26208     MOVE 'RESTART-REQ=Y'      TO G6-PARM-DATA                    
C26208     PERFORM 8238-RESET-JOB-PARM                 THRU 8238-EXIT.  
C26208*                                                                         
C26208     PERFORM 8917-ISSUE-CHKP                     THRU 8917-EXIT.  
C26208     DISPLAY 'COMMIT POINT # ' WS-CHKP-SEQ-NO ' ' CO-ACCOUNT-NO.  
C26208*                                                                         
C26208 8915-EXIT.                                                       
C26208     EXIT.                                                        
C26208******************************************************************19470000
C26208*   8916-PRE-COMMIT                                                       
C26208*   POPULATES THE VALUES FOR RESTART ROW                                  
C26208******************************************************************19470000
C26208 8916-PRE-COMMIT.                                                 
C26208*                                                                         
C26208     MOVE 1                      TO WS-RESTART-PROCESS-TYPE.      
C26208     MOVE WS-C                   TO WS-RESTART-JOB-STATUS.        
C26208     MOVE WS-INPUT-DATE          TO WS-RESTART-COMMON-DATE.       
C26208     MOVE WS-CHKP-SEQ-NO         TO WS-RESTART-CHKP-SEQ-NO.       
C26208     MOVE WS-TOT-RECS-WRTN       TO WS-RESTART-ROW-CNT.           
C26208     MOVE CO-ACCOUNT-NO          TO WS-RESTART-ACCT-NO            
C26208     MOVE '1900-01-01-00.00.00.000000'                            
C26208                                 TO WS-RESTART-TIMESTAMP          
C26208*                                                                 18785000
C26208     MOVE PROGRAM-NAME           TO RF-NAME-PROGRAM.              
C26208     MOVE 1                      TO RF-PARTITION-NO.              
C26208     MOVE 1                      TO RF-DUP-CNTRL-NO.              
C26208     MOVE WS-RESTART-DATA        TO RF-RESTART-DATA-TEXT.         
C26208     MOVE WS-RESTART-DATA-LENGTH TO RF-RESTART-DATA-LEN.          
C26208*                                                                 18785000
C26208 8916-EXIT.                                                       
C26208     EXIT.                                                        
C26208******************************************************************19470000
C26208*   8917-ISSUE-CHKP.                                                      
C26208******************************************************************19470000
C26208 8917-ISSUE-CHKP.                                                 
C26208*                                                                         
C26208     EXEC SQL                                                     
C26208         COMMIT                                                   
C26208     END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
C26208*                                                                         
C26208 8917-EXIT.                                                       
C26208     EXIT.                                                        
      *                                                                 19460000
C30169******************************************************************19070000
C30169**  8920-WRITE-FCSRP292 ..                                      **19080000
C30169**            WRITES OUT DATA TO FIOCA292 FILE                  **19090000
      **                                                              **19100000
      ******************************************************************19110000
C30169 8920-WRITE-FCSCA292.                                             
      *                                                                 19130000
           WRITE FIOCA292.                                              
      *                                                                 19150000
           IF FCA292-SUCCESSFUL                                         
              ADD 1                 TO WS-FCA292-READ-COUNT             
           ELSE                                                         
               DISPLAY '8920-ERROR ON FCSCA292 WRITE. STATUS IS '       
                        WS-FCA292-STATUS                                
               PERFORM 9900-ABEND   THRU 9900-EXIT                      
           END-IF.                                                      
      *                                                                 19230000
C30169 8920-EXIT.                                                       
           EXIT.                                                        
A00765*                                                                         
A00765****************************************************************          
A00765* 9000-SEND-ERROR-RESULT. REQUIRED BY THE COPYBOOK             *          
A00765****************************************************************          
A00765 9000-SEND-ERROR-RESULT.                                          
A00765                                                                  
A00765     GO TO 9000-EXIT.                                             
A00765*                                                                 12610000
      ******************************************************************19470000
      **  9000-TERMINATE ..                                           **19480000
      **                CLOSES OUTPUT FILES FIORP275, FCSRP292        **19490000
      **                                                              **19500000
      ******************************************************************19510000
       9000-TERMINATE.                                                  
      *                                                                 19530000
           CLOSE FCSRP292-FILE.                                         
           CLOSE FCSRP275-FILE.                                         
      *                                                                 19560000
A01618     CLOSE FCSCM275-FILE.                                         
A01618     IF FCM275-SUCCESSFUL                                         
A01618         NEXT SENTENCE                                            
A01618     ELSE                                                         
A01618         DISPLAY '**  PCSCA275 PROCESSING ERROR              **'  
A01618         DISPLAY '**    CLOSE ERROR OF FCSCM275 - OUTPUT FILE'    
A01618         DISPLAY '**    FILE STATUS = ' WS-FCM275-STATUS          
A01618     END-IF.                                                      
      *                                                                 19560000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19581000
      ******************************************************************19582000
      * 9700-PROCESS-ABEND                                             *19583000
      *                                                                 19583100
           EXEC SQL                                                     19584000
              INCLUDE CPD0023B                                          19585000
           END-EXEC.                                                    19586000
      *                                                                *19587000
      ******************************************************************19600000
      *                                                                 19602700
      ****************************************************************  19602800
      **                                                            **  19602900
      **  9900-SQL-ERROR-ROUTINE                                    **  19603000
      **                                                            **  19603100
      ****************************************************************  19603200
      *                                                                 19603300
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                 19603500
           MOVE SQLCODE                TO WS-DISPLAY-SQLCODE.           
           DISPLAY ' '                                                  
           DISPLAY '**********************************************'     
           DISPLAY '***** 9900-SQL-ERROR-ROUTINE            ******'     
           DISPLAY '**********************************************'     
           DISPLAY ' '                                                  
           DISPLAY 'SQLCODE = ' WS-DISPLAY-SQLCODE                      
           DISPLAY ABEND-RECORD-1-DATA                                  
           DISPLAY ABEND-RECORD-2-DATA                                  
           DISPLAY ABEND-RECORD-3-DATA                                  
           DISPLAY '**********************************************'.    
           PERFORM 9900-ABEND                    THRU 9900-EXIT.        
      *                                                                 19604800
      **************************************************************    19605000
      *                                                                *19610000
           EXEC SQL                                                     19620000
              INCLUDE CPD09900                                          19630000
           END-EXEC.                                                    19640000
      *                                                                *19650000
      ******************************************************************19660000
