       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA274.                                        
       INSTALLATION.                                                    
       DATE-WRITTEN.   FEB 2013.                                        
           DATE-COMPILED.                                               
      *****************************************************************         
      **             SOUTH CAROLINA ELECTRIC & GAS                   **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                 COBOL/DB2                      *********         
      *****************************************************************         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE       INITIALS      REASON                             **         
      ** =====      ========      ======                             **         
      ** 02/01/13   SS95855       P#00585 DEVELOPMENT OF NEW PROGRAM **         
      ** 05/08/13   SS95855       P#00730 PROMOTIONAL EMAIL CHANGES  **         
      **                                                             **         
A05744** 12 MAR 2017 RF10596      ADD TO CURSORS                     **         
A05744**                          AND   2T.EVENT_CHANNEL_CD = 'E'    **         
      **                                                             **         
      *****************************************************************         
           REMARKS.                                                     
                              PCSCA274 NARRATIVE                        
                              ==================                        
      *                                                                         
           This Program is clonde of PCSCA274 for Auditing purpose.     
           Each active events wil be extracted with sample records.     
           This number of records extracted is controlled by Job Parm.  
      *                                                                         
       ENVIRONMENT DIVISION.                                            
                                                                        
       CONFIGURATION SECTION.                                           
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
       COPY CSSCA274.                                                           
       COPY CSSCB274.                                                           
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDCA274.                                                           
       01  FIOCA274-REC                PIC X(700).                      
      *                                                                         
       COPY CFDCB274.                                                           
       01  FIOCB274-REC                PIC X(80).                       
                                                                        
      **************************                                                
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA274'.
MSQ017     COPY MFASQLM.
      **************************                                                
      *                                                                         
       01  WS-START                    PIC X(40)                        
           VALUE 'WORKING STORAGE FOR PCSCA274 STARTS HERE'.            
                                                                        
      *** FIOCA274 FILE LAYOUT                                                  
       01 FIOCA274                     PIC X(700).                      
       01 FIOCA274-LEN                 PIC 9(04).                       
                                                                        
      *** ABEND SWITCH                                                          
       COPY CWS09900.                                                           
                                                                        
      *** WS ABEND WORK AREA                                                    
       COPY CWS00010.                                                           
                                                                        
      *** DB2 ERROR PROCESSING                                                  
       COPY CWS00303.                                                           
                                                                        
      ******************************************************************        
      ***                         DCLGEN'S                           ***        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *    COMMUNICATION AREA                                          *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DCLGEN FOR CSS_BATCH_EMAIL (AE)                             *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBBEMAIL                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DCLGEN FOR CSS_EMAIL_EVENT (2T)                             *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBEMEVNT                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DCLGEN FOR CSS_BTCH_EMAIL_DET (JK)                          *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBBTEDET                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DCLGEN FOR CSS_CUST_EMAIL (NE)                              *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBCSTEML                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DCLGEN FOR CSS_NAME (DQ)                                    *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
      ******************************************************************        
      *    DCLGEN FOR CSS_NAME_ACCT_XREF (NE)                          *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DCLGEN FOR CSS_JOB_PARM (G6)                                *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DCLGEN FOR CSS_DELINQUENCY (C8)                             *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DCLGEN FOR CSS_REG_PROFILE (LR)                             *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBREGPRF                                                 
           END-EXEC.                                                            
      *                                                                         
      * FCA00 MISC INPUT     *                                                  
           EXEC SQL                                                             
              INCLUDE CWS00039                                                  
           END-EXEC.                                                            
      *                                                                         
      * WOKING STORAGE FOR CPDCA099                                             
           EXEC SQL                                                             
              INCLUDE CWS00099                                                  
           END-EXEC.                                                            
      *                                                                         
      * FCA00-KEY                                                               
           EXEC SQL                                                             
              INCLUDE FIOCA00                                                   
           END-EXEC.                                                            
      *                                                                         
      * DELINQUENCY                                                             
           COPY CWS00314.                                                       
      *                                                                         
      * IO AREA FOR PARM INPUT FILE 'A'                                         
           EXEC SQL                                                             
              INCLUDE FIOJC01                                                   
           END-EXEC.                                                            
      *                                                                         
       01 WS-LITERALS.                                                  
          05 WS-Y                      PIC X(01)  VALUE 'Y'.            
          05 WS-N                      PIC X(01)  VALUE 'N'.            
          05 WS-PGRMNAME               PIC X(08)  VALUE 'PCSCA274'.     
          05 WS-COMPANY-NO             PIC X(02)  VALUE '01'.           
          05 PROGRAM-NAME              PIC X(08)  VALUE 'PCSCA274'.     
          05 WS-SYMBOL                 PIC X(01)  VALUE '$'.            
P00730    05 WS-PROMOTIONAL-EVENT      PIC X(05)  VALUE 'CIS01'.        
          05 WS-SEEBILL                PIC X(07)  VALUE 'SEEBILL'.      
          05 WS-NO-PAYMENT-DUE         PIC X(14)  VALUE                 
                                                 'No Payment Due'.      
          05 WS-SEE-BILL-FOR-DTLS      PIC X(20)  VALUE                 
                                                 'See bill for details'.
          05 WS-CUSTOMER-NAME          PIC X(02)  VALUE 'CN'.           
          05 WS-EXTRACTED              PIC X(01)  VALUE 'C'.            
          05 WS-FCS274-STATUS          PIC X(02).                       
             88 FCS274-SUCCESSFUL                 VALUE '00'.           
          05 WS-FCS274B-STATUS         PIC X(02).                       
             88 FCS274B-SUCCESSFUL                VALUE '00'.           
          05 WS-OVR-EMAIL              PIC X(01)  VALUE 'N'.            
             88 OVERRIDE-EMAIL-NOT-USED           VALUE 'N'.            
             88 OVERRIDE-EMAIL-USED               VALUE 'Y'.            
          05 WS-EVENTS-FLAG            PIC X(01).                       
             88 MORE-EVENTS                       VALUE 'Y'.            
             88 NO-MORE-EVENTS                    VALUE 'N'.            
          05 WS-DETAILS-FLAG           PIC X(01).                       
             88 MORE-DETAILS                      VALUE 'Y'.            
             88 NO-MORE-DETAILS                   VALUE 'N'.            
          05 WS-DR-DATE                PIC X(01).                       
             88 DR-DATE-NO                        VALUE 'N'.            
             88 DR-DATE-YES                       VALUE 'Y'.            
          05 WS-BI-DATE                PIC X(01).                       
             88 BI-DATE-NO                        VALUE 'N'.            
             88 BI-DATE-YES                       VALUE 'Y'.            
          05 WS-CH-DATE                PIC X(01).                       
             88 CH-DATE-NO                        VALUE 'N'.            
             88 CH-DATE-YES                       VALUE 'Y'.            
          05 WS-SEEBILL-AMOUNT         PIC X(01).                       
             88 SEEBILL-AMOUNT-YES                VALUE 'N'.            
             88 SEEBILL-AMOUNT-NO                 VALUE 'Y'.            
          05 WS-DATABASE-FL            PIC 9(01)  VALUE 0.              
             88 CSR-DATABASE                      VALUE 1.              
             88 SEB-DATABASE                      VALUE 2.              
          05 WS-SEB-REG-DEREG-FL       PIC X(01)  VALUE 'N'.            
             88 SEB-REGULATED                     VALUE 'Y'.            
             88 SEB-DEREGULATED                   VALUE 'N'.            
          05 WS-RUN-FOR-COMPANY        PIC X(02)  VALUE '  '.           
             88 SCEG-RUN                          VALUE '01'.           
             88 PSNC-RUN                          VALUE '26'.           
             88 SEB-RUN                           VALUE '03'.           
             88 SEBR-RUN                          VALUE '04'.           
      *                                                                         
       01 WS-WORK-AREA.                                                 
          05 RS-RETURN-CODE            PIC S9(09) VALUE +0 COMP.        
          05 RS-RETURN-CODE-DISP       PIC S9(09) VALUE +0 COMP.        
          05 WS-DISPLAY-SQLCODE        PIC ---9.                        
          05 WS-TALLY                  PIC   99.                        
          05 WS-TALLY-SB               PIC   99.                        
          05 WS-BATCH-EMAIL-ID         PIC X(18)  VALUE SPACES.         
          05 WS-TOTAL-RECORDS          PIC 9(08)  VALUE ZERO.           
          05 WS-TOTAL-RECORDS-STR      PIC Z,ZZ,ZZ,ZZ9.                 
          05 WS-MAX-COUNTER            PIC 9(04)  VALUE 10.             
          05 WS-TEMP-COUNT             PIC 9(04)  VALUE 0.              
          05 WS-PREV-EMAIL-EVENT       PIC X(05)  VALUE SPACES.         
          05 WS-NULL-IND-FIELD-VALUE   PIC S9(04) COMP VALUE +0.        
          05 WS-SUB                    PIC 9(02)  VALUE ZERO.           
          05 WS-SUB-1                  PIC 9(02)  VALUE ZERO.           
          05 WS-NULL-IND-1             PIC S9(04) COMP VALUE +0.        
          05 WS-ACCOUNT-NO             PIC 9(13)  VALUE ZERO.           
          05 WS-COMPANY-NUMBER         PIC X(02)  VALUE SPACES.         
          05 WS-OVRERRIDE-EMAIL        PIC X(50)  VALUE SPACES.         
          05 WS-ACCTNO-MASK.                                            
             10 FILLER                 PIC X(09)  VALUE '*********'.    
             10 WS-ACCT-4-DIGITS       PIC X(04).                       
      *                                                                         
          05 WS-FORMAT-AMOUNT-IN       PIC X(20)  VALUE SPACES.         
          05 WS-NUMVAL-AMT             PIC S9(15)V99.                   
          05 WS-FORMAT-AMOUNT-OUT      PIC -$,$$$,$$$,$$9.99.           
          05 WS-TEMP-AMOUNT            PIC X(20).                       
          05 WS-SEND-FMT-AMOUNT        PIC X(20).                       
          05 WS-FORMAT-SIGN-AMOUNT.                                     
             10  WS-FMT-SIGN           PIC X(01).                       
             10  WS-FMT-AMOUNT         PIC X(19).                       
P00730    05 WS-ALT-EMAIL-ID           PIC X(75)  VALUE SPACES.         
      *                                                                         
       01  WS-EVENT-COUNT              PIC S9(8)  USAGE COMP.           
       01  WS-EVENT-CNT-NUM            PIC 9(04)  VALUE 0.              
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CCYY                 PIC 9(04).                       
           05  WS-CM                   PIC 9(02).                       
           05  WS-CD                   PIC 9(02).                       
           05  WS-CHH                  PIC 9(02).                       
           05  WS-CMM                  PIC 9(02).                       
           05  WS-CSS                  PIC 9(02).                       
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                PIC XX.                          
           05  FILLER                  PIC X      VALUE '/'.            
           05  WS-RD-DD                PIC XX.                          
           05  FILLER                  PIC X      VALUE '/'.            
           05  WS-RD-CCYY              PIC XXXX.                        
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                PIC XX.                          
           05  FILLER                  PIC X      VALUE ':'.            
           05  WS-RT-MM                PIC XX.                          
           05  FILLER                  PIC X      VALUE ':'.            
           05  WS-RT-SS                PIC XX.                          
      *                                                                         
       01  WS-REPT-HEADER-1.                                            
           05 WS-REPT-HDR              PIC X(11)  VALUE 'PCSCA274-01'.  
           05 FILLER                   PIC X(14)  VALUE SPACES.         
           05 WS-REPT-TITLE            PIC X(30)  VALUE SPACES.         
           05 FILLER                   PIC X(10)  VALUE SPACES.         
           05 WS-REPT-DT-HDR           PIC X(05)  VALUE 'DATE:'.        
           05 WS-REPT-DATE             PIC X(10)  VALUE SPACES.         
      *                                                                         
       01  WS-REPT-HEADER-2.                                            
           05 WS-REPT-PROG             PIC X(08)  VALUE 'PCSCA274'.     
           05 FILLER                   PIC X(17)  VALUE SPACES.         
           05 FILLER                   PIC X(30)  VALUE                 
              '******************************'.                         
           05 FILLER                   PIC X(12)  VALUE SPACES.         
           05 WS-REPT-TM-HDR           PIC X(05)  VALUE 'TIME:'.        
           05 WS-REPT-TIME             PIC X(08)  VALUE SPACES.         
      *                                                                         
       01  WS-REPT-RECORD.                                              
           05 WS-SL-NO                 PIC 9(02)  VALUE 0.              
           05 FILLER                   PIC X(03)  VALUE SPACES.         
           05 WS-EVENT-CODE            PIC X(05)  VALUE SPACES.         
           05 FILLER                   PIC X(02)  VALUE SPACES.         
           05 WS-EVENT-COUNT-R         PIC 99999.                       
           05 FILLER                   PIC X(03)  VALUE SPACES.         
           05 WS-EVENT-DESC            PIC X(60)  VALUE SPACES.         
      *                                                                         
       01  WS-REPT-RECORD-HDR.                                          
           05 WS-SL-NO-HDR             PIC X(03)  VALUE 'NO.'.          
           05 FILLER                   PIC X(02)  VALUE SPACES.         
           05 WS-EVENT-CODE-HDR        PIC X(05)  VALUE 'EVENT'.        
           05 FILLER                   PIC X(02)  VALUE SPACES.         
           05 WS-EVENT-COUNT-HDR       PIC X(5)   VALUE 'COUNT'.        
           05 FILLER                   PIC X(03)  VALUE SPACES.         
           05 WS-EVENT-DESC-HDR        PIC X(17)  VALUE                 
                                                  'EVENT DESCRIPTION'.  
           05 FILLER                   PIC X(43)  VALUE SPACES.         
      *                                                                         
       01  WS-REPT-END.                                                 
           05 FILLER                   PIC X(30)  VALUE SPACES.         
           05 WS-END-OF-REPT           PIC X(21)  VALUE                 
                                       '*** END OF REPORT ***'.         
           05 FILLER                   PIC X(29)  VALUE SPACES.         
      *                                                                         
       01 WS-HEADER-RECORD.                                             
          05 CustomerNo                PIC X(10)  VALUE 'CustomerNo'.   
          05 Delimiter1                PIC X(01)  VALUE '|'.            
          05 AccountNo                 PIC X(09)  VALUE 'AccountNo'.    
          05 Delimiter2                PIC X(01)  VALUE '|'.            
          05 FirstName                 PIC X(09)  VALUE 'FirstName'.    
          05 Delimiter3                PIC X(01)  VALUE '|'.            
          05 LastName                  PIC X(08)  VALUE 'Lastname'.     
          05 Delimiter4                PIC X(01)  VALUE '|'.            
          05 CustEmailId               PIC X(11)  VALUE 'CustEmailId'.  
          05 Delimiter5                PIC X(01)  VALUE '|'.            
          05 BatchEmailId              PIC X(12)  VALUE 'BatchEmailId'. 
          05 Delimiter6                PIC X(01)  VALUE '|'.            
          05 EmailEventCd              PIC X(12)  VALUE 'EmailEventCd'. 
          05 Delimiter7                PIC X(01)  VALUE '|'.            
          05 EmailEventDt              PIC X(12)  VALUE 'EmailEventDt'. 
          05 Delimiter8                PIC X(01)  VALUE '|'.            
          05 CompanyNo                 PIC X(09)  VALUE 'CompanyNo'.    
          05 Delimiter9                PIC X(01)  VALUE '|'.            
          05 EmailDispCd               PIC X(11)  VALUE 'EmailDispCd'.  
          05 Delimiter10               PIC X(01)  VALUE '|'.            
          05 AccnoMask                 PIC X(09)  VALUE 'AccnoMask'.    
          05 Delimiter11               PIC X(01)  VALUE '|'.            
          05 EventChannlCd             PIC X(13)  VALUE 'EventChannlCd'.
          05 Delimiter12               PIC X(01)  VALUE '|'.            
          05 RegGroupCd                PIC X(10)  VALUE 'RegGroupCd'.   
          05 Delimiter13               PIC X(01)  VALUE '|'.            
          05 ProcessedCd               PIC X(11)  VALUE 'ProcessedCd'.  
          05 Delimiter13A              PIC X(01)  VALUE '|'.            
      *** Below Fields are populated based on the Event              ***        
          05 PremAddr                  PIC X(08)  VALUE 'PremAddr'.     
          05 Delimiter14               PIC X(01)  VALUE '|'.            
          05 BankAcct                  PIC X(08)  VALUE 'BankAcct'.     
          05 Delimiter15               PIC X(01)  VALUE '|'.            
          05 DraftDt                   PIC X(07)  VALUE 'DraftDt'.      
          05 Delimiter16               PIC X(01)  VALUE '|'.            
          05 DraftAmt                  PIC X(08)  VALUE 'DraftAmt'.     
          05 Delimiter17               PIC X(01)  VALUE '|'.            
          05 BilldDt                   PIC X(07)  VALUE 'BilldDt'.      
          05 Delimiter18               PIC X(01)  VALUE '|'.            
          05 BilldAmt                  PIC X(08)  VALUE 'BilldAmt'.     
          05 Delimiter19               PIC X(01)  VALUE '|'.            
          05 ChrgeDt                   PIC X(07)  VALUE 'ChrgeDt'.      
          05 Delimiter20               PIC X(01)  VALUE '|'.            
          05 ChrgeAmt                  PIC X(08)  VALUE 'ChrgeAmt'.     
          05 Delimiter21               PIC X(01)  VALUE '|'.            
          05 SchedDt                   PIC X(07)  VALUE 'SchedDt'.      
          05 Delimiter22               PIC X(01)  VALUE '|'.            
          05 UtilType                  PIC X(08)  VALUE 'UtilType'.     
          05 Delimiter23               PIC X(01)  VALUE '|'.            
          05 ReqType                   PIC X(07)  VALUE 'ReqType'.      
          05 Delimiter24               PIC X(01)  VALUE '|'.            
          05 ContactInfo               PIC X(11)  VALUE 'ContactInfo'.  
          05 Delimiter25               PIC X(01)  VALUE '|'.            
          05 ApptArrg                  PIC X(08)  VALUE 'ApptArrg'.     
          05 Delimiter26               PIC X(01)  VALUE '|'.            
          05 DepAmt                    PIC X(06)  VALUE 'DepAmt'.       
          05 Delimiter27               PIC X(01)  VALUE '|'.            
          05 CustName                  PIC X(08)  VALUE 'CustName'.     
          05 Delimiter28               PIC X(01)  VALUE '|'.            
P00730    05 GuidLink                  PIC X(08)  VALUE 'GuidLink'.     
P00730    05 Delimiter29               PIC X(01)  VALUE '|'.            
      *                                                                         
       01 WS-RECORD-STRING.                                             
          05 S-CUSTOMER-NO.                                             
             10 RS-CUSTOMER-NO         PIC X(10).                       
             10 RS-DELIMITER1          PIC X(03).                       
          05 S-ACCOUNT-NO.                                              
             10 RS-ACCOUNT-NO          PIC X(13).                       
             10 RS-DELIMITER2          PIC X(03).                       
          05 S-FIRST-NAME.                                              
             10 RS-FIRST-NAME          PIC X(15).                       
             10 RS-DELIMITER3          PIC X(03).                       
          05 S-LAST-NAME.                                               
             10 RS-LAST-NAME           PIC X(70).                       
             10 RS-DELIMITER4          PIC X(03).                       
          05 S-CUST-EMAIL-ID.                                           
             10 RS-CUST-EMAIL-ID       PIC X(75).                       
             10 RS-DELIMITER5          PIC X(03).                       
          05 S-BATCH-EMAIL-ID.                                          
             10 RS-BATCH-EMAIL-ID      PIC X(18).                       
             10 RS-DELIMITER6          PIC X(03).                       
          05 S-EMAIL-EVENT-CD.                                          
             10 RS-EMAIL-EVENT-CD      PIC X(05).                       
             10 RS-DELIMITER7          PIC X(03).                       
          05 S-EMAIL-EVENT-DT.                                          
             10 RS-EMAIL-EVENT-DT      PIC X(10).                       
             10 RS-DELIMITER8          PIC X(03).                       
          05 S-COMPANY-NO.                                              
             10 RS-COMPANY-NO          PIC X(02).                       
             10 RS-DELIMITER9          PIC X(03).                       
          05 S-EMAIL-DISP-CD.                                           
             10 RS-EMAIL-DISP-CD       PIC X(01).                       
             10 RS-DELIMITER10         PIC X(03).                       
          05 S-ACCNO-MASK.                                              
             10 RS-ACCNO-MASK          PIC X(13).                       
             10 RS-DELIMITER11         PIC X(03).                       
          05 S-EVENT-CHANNL-CD.                                         
             10 RS-EVENT-CHANNL-CD     PIC X(01).                       
             10 RS-DELIMITER12         PIC X(03).                       
          05 S-REG-GROUP-CD.                                            
             10 RS-REG-GROUP-CD        PIC X(03).                       
             10 RS-DELIMITER13         PIC X(03).                       
          05 S-PROCESSED-CD.                                            
             10 RS-PROCESSED-CD        PIC X(01).                       
             10 RS-DELIMITER13A        PIC X(03).                       
      *** Below Fields are populated based on the Event              ***        
          05 S-PREM-ADDR.                                               
             10 RS-PREM-ADDR           PIC X(75).                       
             10 RS-DELIMITER14         PIC X(03).                       
          05 S-BANK-ACCT.                                               
             10 RS-BANK-ACCT           PIC X(20).                       
             10 RS-DELIMITER15         PIC X(03).                       
          05 S-DRAFT-DT.                                                
             10 RS-DRAFT-DT            PIC X(20).                       
             10 RS-DELIMITER16         PIC X(03).                       
          05 S-DRAFT-SYM.                                               
             10 RS-DRAFT-SYM           PIC X(01).                       
             10 RS-DELIMITER17         PIC X(03).                       
          05 S-DRAFT-DLR.                                               
             10 RS-DRAFT-DLR           PIC X(01).                       
             10 RS-DELIMITER18         PIC X(03).                       
          05 S-DRAFT-AMT.                                               
             10 RS-DRAFT-AMT           PIC X(20).                       
             10 RS-DELIMITER19         PIC X(03).                       
          05 S-BILLD-DT.                                                
             10 RS-BILLD-DT            PIC X(20).                       
             10 RS-DELIMITER20         PIC X(03).                       
          05 S-BILLD-SYM.                                               
             10 RS-BILLD-SYM           PIC X(01).                       
             10 RS-DELIMITER21         PIC X(03).                       
          05 S-BILLD-DLR.                                               
             10 RS-BILLD-DLR           PIC X(01).                       
             10 RS-DELIMITER22         PIC X(03).                       
          05 S-BILLD-AMT.                                               
             10 RS-BILLD-AMT           PIC X(20).                       
             10 RS-DELIMITER23         PIC X(03).                       
          05 S-CHRGE-DT.                                                
             10 RS-CHRGE-DT            PIC X(20).                       
             10 RS-DELIMITER24         PIC X(03).                       
          05 S-CHRGE-SYM.                                               
             10 RS-CHRGE-SYM           PIC X(01).                       
             10 RS-DELIMITER25         PIC X(03).                       
          05 S-CHRGE-DLR.                                               
             10 RS-CHRGE-DLR           PIC X(01).                       
             10 RS-DELIMITER26         PIC X(03).                       
          05 S-CHRGE-AMT.                                               
             10 RS-CHRGE-AMT           PIC X(20).                       
             10 RS-DELIMITER27         PIC X(03).                       
          05 S-SCHED-DT.                                                
             10 RS-SCHED-DT            PIC X(10).                       
             10 RS-DELIMITER28         PIC X(03).                       
          05 S-UTIL-TYPE.                                               
             10 RS-UTIL-TYPE           PIC X(20).                       
             10 RS-DELIMITER29         PIC X(03).                       
          05 S-REQ-TYPE.                                                
             10 RS-REQ-TYPE            PIC X(25).                       
             10 RS-DELIMITER30         PIC X(03).                       
          05 S-CONTACT-INFO.                                            
             10 RS-CONTACT-INFO        PIC X(50).                       
             10 RS-DELIMITER31         PIC X(03).                       
          05 S-APPT-ARRG.                                               
             10 RS-APPT-ARRG           PIC X(70).                       
             10 RS-DELIMITER32         PIC X(03).                       
          05 S-DEP-AMT.                                                 
             10 RS-DEP-AMT             PIC X(15).                       
             10 RS-DELIMITER33         PIC X(03).                       
          05 S-CUST-NAME.                                               
             10 RS-CUST-NAME           PIC X(30).                       
             10 RS-DELIMITER34         PIC X(03).                       
P00730    05 S-GUID-LINK.                                               
P00730       10 RS-GUID-LINK           PIC X(35).                       
P00730       10 RS-DELIMITER35         PIC X(03).                       
      *                                                                         
      * MISC INPUT           *                                                  
           EXEC SQL                                                             
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
      *                                                                         
       01 WS-INPUT-DATA-R8                                              
             REDEFINES WS-INPUT-DATA-BREAKDOWN.                         
          10 WS-SYSIPT-R8              PIC X(10).                       
             88 EXT-COUNT              VALUE 'EXT-COUNT='.              
          10 WS-EXTRACT-COUNT          PIC X(04).                       
          10 FILLER                    PIC X(66).                       
      *                                                                         
       01 WS-INPUT-DATA-R9                                              
             REDEFINES WS-INPUT-DATA-BREAKDOWN.                         
          10 WS-SYSIPT-R9              PIC X(09).                       
             88 EMAIL-ID               VALUE 'EMAIL-ID='.               
          10 WS-EMAIL-ADDRESS          PIC X(50).                       
          10 FILLER                    PIC X(21).                       
      *                                                                         
       01 WS-END                       PIC X(40)                        
           VALUE 'WORKING STORAGE FOR PCSCA274 ENDS HERE  '.            
      *                                                                         
      *****************************************************************         
      **  CURSOR TO GET ROWS FROM CSS_BATCH_EMAIL.                   **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE BATCH_EMAIL_CSR CURSOR FOR                        
                 SELECT AE.BATCH_EMAIL_ID                               
                       ,AE.ACCOUNT_NO                                   
                       ,AE.CUSTOMER_NO                                  
                       ,AE.EMAIL_EVENT_CD                               
                       ,AE.PROCESSED_CD                                 
                       ,CIS.CHAR2$DATE(AE.EMAIL_EVENT_DT, 'USA')                
                       ,AE.COMPANY_NO                                   
                       ,NE.EMAIL_DISP_PREF_CD                           
                       ,NE.EMAIL_ADDRESS_TX                             
                       ,[2T].EVENT_CHANNEL_CD                             
                       ,[2T].REG_GROUP_CD                                 
                 FROM  CSS_BATCH_EMAIL AE WITH(READUNCOMMITTED)                 
                      ,CSS_CUST_EMAIL  NE WITH(READUNCOMMITTED)                 
                      ,CSS_EMAIL_EVENT [2T] WITH(READUNCOMMITTED)               
                 WHERE AE.EMAIL_EVENT_DT  = IIF(TRY_CONVERT(DATE, 
                                                     :AE-EMAIL-EVENT-DT
              ) IS NULL OR (PATINDEX('%.%', :AE-EMAIL-EVENT-DT
              ) <> 0) OR (LEN(:AE-EMAIL-EVENT-DT
              ) <> 10), CIS.CHAR2DATE(:AE-EMAIL-EVENT-DT
              ), CONVERT(DATE, :AE-EMAIL-EVENT-DT) )          
                 AND   AE.COMPANY_NO      = :AE-COMPANY-NO              
                 AND   AE.COMPANY_NO      = [2T].COMPANY_NO               
                 AND   AE.EMAIL_EVENT_CD  = [2T].EMAIL_EVENT_CD           
                 AND   [2T].EVENT_STATUS_CD = 'A'                         
A05744           AND   [2T].EVENT_CHANNEL_CD = 'E'                        
                 AND   AE.CUSTOMER_NO     = NE.CUSTOMER_NO              
                 AND   NE.EMAIL_TYPE_CD   = 'P1'                        
                 AND  (AE.PROCESSED_CD IS NULL                          
                  OR   AE.PROCESSED_CD    = ' ')                        
                 ORDER BY AE.EMAIL_EVENT_CD                             
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE BATCH_EMAIL_CSR CURSOR FOR                                
MFA-TR*          SELECT AE.BATCH_EMAIL_ID                                       
MFA-TR*                ,AE.ACCOUNT_NO                                           
MFA-TR*                ,AE.CUSTOMER_NO                                          
MFA-TR*                ,AE.EMAIL_EVENT_CD                                       
MFA-TR*                ,AE.PROCESSED_CD                                         
MFA-TR*                ,CHAR(AE.EMAIL_EVENT_DT, USA)                            
MFA-TR*                ,AE.COMPANY_NO                                           
MFA-TR*                ,NE.EMAIL_DISP_PREF_CD                                   
MFA-TR*                ,NE.EMAIL_ADDRESS_TX                                     
MFA-TR*                ,2T.EVENT_CHANNEL_CD                                     
MFA-TR*                ,2T.REG_GROUP_CD                                         
MFA-TR*          FROM  CSS_BATCH_EMAIL AE                                       
MFA-TR*               ,CSS_CUST_EMAIL  NE                                       
MFA-TR*               ,CSS_EMAIL_EVENT 2T                                       
MFA-TR*          WHERE AE.EMAIL_EVENT_DT  = :AE-EMAIL-EVENT-DT                  
MFA-TR*          AND   AE.COMPANY_NO      = :AE-COMPANY-NO                      
MFA-TR*          AND   AE.COMPANY_NO      = 2T.COMPANY_NO                       
MFA-TR*          AND   AE.EMAIL_EVENT_CD  = 2T.EMAIL_EVENT_CD                   
MFA-TR*          AND   2T.EVENT_STATUS_CD = 'A'                                 
MFA-TR*          AND   2T.EVENT_CHANNEL_CD = 'E'                                
MFA-TR*          AND   AE.CUSTOMER_NO     = NE.CUSTOMER_NO                      
MFA-TR*          AND   NE.EMAIL_TYPE_CD   = 'P1'                                
MFA-TR*          AND  (AE.PROCESSED_CD IS NULL                                  
MFA-TR*           OR   AE.PROCESSED_CD    = ' ')                                
MFA-TR*          ORDER BY AE.EMAIL_EVENT_CD                                     
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7210                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **  CURSOR TO GET ROWS FROM CSS_BTCH_EMAIL_DET                 **         
      **  GETS ALL EMAIL DETAILS FOR A GIVEN BATCH MAIL ID.          **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE EMAIL_DTL_CSR CURSOR FOR                          
                 SELECT FIELD_NAME_TX                                   
                       ,LTRIM(RTRIM(FIELD_VALUE_TX))                    
                 FROM  CSS_BTCH_EMAIL_DET JK WITH(READUNCOMMITTED)              
                 WHERE BATCH_EMAIL_ID = :JK-BATCH-EMAIL-ID              
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE EMAIL_DTL_CSR CURSOR FOR                                  
MFA-TR*          SELECT FIELD_NAME_TX                                           
MFA-TR*                ,LTRIM(RTRIM(FIELD_VALUE_TX))                            
MFA-TR*          FROM  CSS_BTCH_EMAIL_DET JK                                    
MFA-TR*          WHERE BATCH_EMAIL_ID = :JK-BATCH-EMAIL-ID                      
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7240                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **  CURSOR TO GET EVENT SUMMARY                                **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE EVENT_SUMM_CSR CURSOR FOR                         
                 SELECT AE.EMAIL_EVENT_CD                               
                        ,COUNT(*)                                       
                  FROM  CSS_BATCH_EMAIL AE WITH(READUNCOMMITTED)                
                       ,CSS_CUST_EMAIL  NE WITH(READUNCOMMITTED)                
                       ,CSS_EMAIL_EVENT [2T] WITH(READUNCOMMITTED)              
                 WHERE AE.EMAIL_EVENT_DT  = IIF(TRY_CONVERT(DATE, 
                                                     :AE-EMAIL-EVENT-DT
              ) IS NULL OR (PATINDEX('%.%', :AE-EMAIL-EVENT-DT
              ) <> 0) OR (LEN(:AE-EMAIL-EVENT-DT
              ) <> 10), CIS.CHAR2DATE(:AE-EMAIL-EVENT-DT
              ), CONVERT(DATE, :AE-EMAIL-EVENT-DT) )          
                   AND AE.COMPANY_NO      = :AE-COMPANY-NO              
                   AND AE.COMPANY_NO      = [2T].COMPANY_NO               
                   AND AE.EMAIL_EVENT_CD  = [2T].EMAIL_EVENT_CD           
                   AND [2T].EVENT_STATUS_CD = 'A'                         
A05744             AND [2T].EVENT_CHANNEL_CD = 'E'                        
                   AND AE.CUSTOMER_NO     = NE.CUSTOMER_NO              
                   AND NE.EMAIL_TYPE_CD   = 'P1'                        
                   AND (AE.PROCESSED_CD IS NULL                         
                    OR AE.PROCESSED_CD    = ' ')                        
                 GROUP BY AE.EMAIL_EVENT_CD                             
                 ORDER BY AE.EMAIL_EVENT_CD                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE EVENT_SUMM_CSR CURSOR FOR                                 
MFA-TR*          SELECT AE.EMAIL_EVENT_CD                                       
MFA-TR*                 ,COUNT(*)                                               
MFA-TR*           FROM  CSS_BATCH_EMAIL AE                                      
MFA-TR*                ,CSS_CUST_EMAIL  NE                                      
MFA-TR*                ,CSS_EMAIL_EVENT 2T                                      
MFA-TR*          WHERE AE.EMAIL_EVENT_DT  = :AE-EMAIL-EVENT-DT                  
MFA-TR*            AND AE.COMPANY_NO      = :AE-COMPANY-NO                      
MFA-TR*            AND AE.COMPANY_NO      = 2T.COMPANY_NO                       
MFA-TR*            AND AE.EMAIL_EVENT_CD  = 2T.EMAIL_EVENT_CD                   
MFA-TR*            AND 2T.EVENT_STATUS_CD = 'A'                                 
MFA-TR*            AND 2T.EVENT_CHANNEL_CD = 'E'                                
MFA-TR*            AND AE.CUSTOMER_NO     = NE.CUSTOMER_NO                      
MFA-TR*            AND NE.EMAIL_TYPE_CD   = 'P1'                                
MFA-TR*            AND (AE.PROCESSED_CD IS NULL                                 
MFA-TR*             OR AE.PROCESSED_CD    = ' ')                                
MFA-TR*          GROUP BY AE.EMAIL_EVENT_CD                                     
MFA-TR*          ORDER BY AE.EMAIL_EVENT_CD                                     
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7270                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
       01  LS-PARM.                                                     
           05 LS-PARMLEN               PIC S9(03) COMP.                 
           05 LS-COMPANY-NO            PIC X(02).                       
           05 LS-DLM                   PIC X(01).                       
           05 LS-PARTITION-NO          PIC X(01).                       
      *                                                                         
      ******************************************************************        
       PROCEDURE DIVISION USING LS-PARM.                                
      ******************************************************************        
      *                                                                *        
      *================================================================*        
       0000-MAINLINE.                                                   
      *================================================================*        
      *                                                                         
           PERFORM 0100-INITIALIZATION        THRU 0100-EXIT.           
      *                                                                         
           PERFORM 0400-PROCESS-EVENTS        THRU 0400-EXIT.           
      *                                                                         
           PERFORM 9000-TERMINATE             THRU 9000-EXIT.           
      *                                                                         
           MOVE WS-TOTAL-RECORDS           TO WS-TOTAL-RECORDS-STR.     
                                                                        
           DISPLAY '    ***************************************'        
           DISPLAY '     TOTAL RECORDS EXTRACTED: ' WS-TOTAL-RECORDS-STR
           DISPLAY '    ***************************************'        
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0100-INITIALIZATION.                                             
      *================================================================*        
      *                                                                         
           MOVE FUNCTION CURRENT-DATE(1:14)                             
                                           TO WS-CURRENT-DATE.          
           MOVE WS-CCYY                    TO WS-RD-CCYY.               
           MOVE WS-CM                      TO WS-RD-MM.                 
           MOVE WS-CD                      TO WS-RD-DD.                 
           MOVE WS-RUN-DATE                TO WS-REPT-DATE.             
     *                                                                  
           MOVE WS-CHH                     TO WS-RT-HH.                 
           MOVE WS-CMM                     TO WS-RT-MM.                 
           MOVE WS-CSS                     TO WS-RT-SS.                 
           MOVE WS-RUN-TIME                TO WS-REPT-TIME.             
      *                                                                         
           OPEN OUTPUT FCSCA274-FILE FCSCB274-FILE.                     
                                                                        
           IF  FCS274-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '************ PCSCA274 ERROR ******************'  
              DISPLAY '** ERROR IN  0100-INITIALIZATION            **'  
              DISPLAY '**   FILE FCSCA274 OPEN OUTPUT              **'  
              DISPLAY '** FILE STATUS = ' WS-FCS274-STATUS              
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
           IF  FCS274B-SUCCESSFUL                                       
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '************ PCSCA274 ERROR ******************'  
              DISPLAY '** ERROR IN  0100-INITIALIZATION            **'  
              DISPLAY '**   FILE FCSCB274 OPEN OUTPUT              **'  
              DISPLAY '** FILE STATUS = ' WS-FCS274B-STATUS             
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
      *** GET COMMON DATE IF NO OVERRIDE DATE SPECIFIED                         
           PERFORM 6251-GET-FJC01-DATE        THRU 6251-EXIT.           
           IF  COMMON-DATE-NEEDED                                       
               PERFORM 6240-GET-FCA00-COMMON-DATE                       
                                              THRU 6240-EXIT            
               DISPLAY 'COMMON DATE USED ==> ' WS-FCA00-COMMON-DATE     
               MOVE WS-FCA00-COMMON-DATE   TO WS-INPUT-DATE             
           END-IF.                                                      
      *                                                                         
      *** GET DATABASE FROM DELINQUENCY VALUE                                   
           SET CSR-DATABASE TO TRUE.                                    
                                                                        
           MOVE 'DATABASE'                 TO C8-DELINQ-CD.             
           MOVE WS-COMPANY-NO              TO C8-COMPANY-NO.            
                                                                        
           PERFORM 6520-GET-DELINQ-VALUE      THRU                      
                   6520-GET-DELINQ-VALUE-EXIT.                          
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              MOVE C8-DELINQ-VALUE         TO WS-DATABASE-FL            
           END-IF.                                                      
      *                                                                         
      *** GET OVERRIDES FROM JOB PARM                                           
           PERFORM 0200-LOAD-OVERRIDES        THRU 0200-EXIT.           
      *                                                                         
      *** GET JCLPARM TO DETERMINE WHICH COMPANY THE JOB IS RUNNING FOR         
           IF LS-PARMLEN > ZERO                                         
              MOVE LS-COMPANY-NO           TO WS-RUN-FOR-COMPANY        
           END-IF.                                                      
                                                                        
           EVALUATE TRUE                                                
              WHEN SCEG-RUN                                             
                DISPLAY "RUNNING FOR COMPANY SCE&G "                    
                MOVE 'EVENT SUMMARY REPORT FOR SCE&G'                   
                                           TO WS-REPT-TITLE             
              WHEN PSNC-RUN                                             
                DISPLAY "RUNNING FOR COMPANY PSNC  "                    
                MOVE 'EVENT SUMMARY REPORT FOR PSNC '                   
                                           TO WS-REPT-TITLE             
              WHEN SEB-RUN                                              
                DISPLAY "RUNNING FOR COMPANY SEB(DE-REG)"               
                MOVE 'EVENT SUMMARY REPORT FOR SEB  '                   
                                           TO WS-REPT-TITLE             
              WHEN SEBR-RUN                                             
                DISPLAY "RUNNING FOR COMPANY SEB(REG) "                 
                MOVE 'EVENT SUMMARY REPORT FOR SEBR '                   
                                           TO WS-REPT-TITLE             
              WHEN OTHER                                                
                   DISPLAY " MISSING JCLPARM COMPANY NO " LS-COMPANY-NO 
                   DISPLAY '** PROCESSING TERMINATED                **' 
                   PERFORM 9900-ABEND         THRU 9900-EXIT            
           END-EVALUATE.                                                
      *                                                                         
           IF PSNC-RUN                                                  
              MOVE WS-RUN-FOR-COMPANY      TO WS-COMPANY-NUMBER         
           ELSE                                                         
              MOVE WS-COMPANY-NO           TO WS-COMPANY-NUMBER         
           END-IF.                                                      
      *                                                                         
      *** CREATE A HEADER RECORD FOR THE EXTRACT                                
           MOVE SPACES                     TO FIOCA274.                 
           MOVE WS-HEADER-RECORD           TO FIOCA274.                 
           MOVE LENGTH OF WS-HEADER-RECORD                              
                                           TO FIOCA274-LEN.             
           PERFORM 8000-WRITE-FIOCA274        THRU 8000-EXIT.           
      *                                                                         
      *** CREATE A REPORT HEADER                                                
           MOVE WS-REPT-HEADER-1           TO FIOCB274-REC.             
           PERFORM 8100-WRITE-FIOCB274        THRU 8100-EXIT.           
           MOVE WS-REPT-HEADER-2           TO FIOCB274-REC.             
           PERFORM 8100-WRITE-FIOCB274        THRU 8100-EXIT.           
           MOVE SPACES                     TO FIOCB274-REC.             
           PERFORM 8100-WRITE-FIOCB274        THRU 8100-EXIT.           
      *                                                                         
           DISPLAY '*** NO COMMITS TAKEN, COMPLETE RE-RUN REQUIRED ***'.
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0200-LOAD-OVERRIDES.                                             
      *================================================================*        
      *                                                                         
           MOVE SPACES                     TO WS-SYSIPT.                
           MOVE WS-PARM                    TO WS-COMMAND.               
           SET OVERRIDE-EMAIL-NOT-USED TO TRUE.                         
                                                                        
           PERFORM 7600-START-FCSJC01         THRU 7600-EXIT.           
                                                                        
           PERFORM 7610-READ-FCSJC01          THRU 7610-EXIT.           
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              PERFORM 0300-LOAD-EMAIL-EVENT-OVERRIDE                    
                                              THRU 0300-EXIT            
                                              UNTIL END-OF-SYSIPT       
           END-IF.                                                      
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0300-LOAD-EMAIL-EVENT-OVERRIDE.                                  
      *================================================================*        
      *                                                                         
      *** COUNTER FOR MAX RECORDS TO BE EXTRACTED                               
           IF EXT-COUNT                                                 
              IF INPUT-ACTIVE                                           
                 MOVE WS-EXTRACT-COUNT     TO WS-MAX-COUNTER            
                 DISPLAY 'EXTRACT COUNT USED: ' WS-MAX-COUNTER          
              ELSE                                                      
                 DISPLAY 'DEFAULT COUNT USED: ' WS-MAX-COUNTER          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF EMAIL-ID                                                  
              IF INPUT-ACTIVE                                           
                 MOVE WS-EMAIL-ADDRESS     TO WS-OVRERRIDE-EMAIL        
                 SET OVERRIDE-EMAIL-USED   TO TRUE                      
                 DISPLAY 'OVERRIDE-EMAIL-USED ' WS-OVRERRIDE-EMAIL      
              ELSE                                                      
                 MOVE SPACES               TO WS-OVRERRIDE-EMAIL        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 7610-READ-FCSJC01          THRU 7610-EXIT.           
      *                                                                         
       0300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0400-PROCESS-EVENTS.                                             
      *================================================================*        
      *                                                                         
           SET MORE-EVENTS                 TO TRUE.                     
      *                                                                         
           MOVE WS-INPUT-DATE              TO AE-EMAIL-EVENT-DT.        
           MOVE WS-COMPANY-NUMBER          TO AE-COMPANY-NO.            
      *                                                                         
           PERFORM 7210-OPEN-BATCH-EMAIL-CSR  THRU 7210-EXIT.           
      *                                                                         
           PERFORM 7220-FETCH-BATCH-EMAIL-CSR THRU 7220-EXIT.           
      *                                                                         
           MOVE AE-EMAIL-EVENT-CD          TO WS-PREV-EMAIL-EVENT.      
      *                                                                         
           PERFORM 1000-PROCESS-EMAIL-EVENT   THRU 1000-EXIT            
             UNTIL NO-MORE-EVENTS.                                      
      *                                                                         
           PERFORM 7230-CLOSE-BATCH-EMAIL-CSR THRU 7230-EXIT.           
      *                                                                         
           PERFORM 0500-PROCESS-REPORT        THRU 0500-EXIT.           
      *                                                                         
       0400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0500-PROCESS-REPORT.                                             
      *================================================================*        
      *                                                                         
           MOVE SPACES                     TO FIOCB274-REC.             
           MOVE WS-REPT-RECORD-HDR         TO FIOCB274-REC.             
           PERFORM 8100-WRITE-FIOCB274        THRU 8100-EXIT.           
      *                                                                         
           PERFORM 7270-OPEN-EVENT-SUMM-CSR   THRU 7270-EXIT.           
      *                                                                         
           PERFORM 7280-FETCH-EVENT-SUMM-CSR  THRU 7280-EXIT.           
      *                                                                         
           PERFORM 0510-GENERATE-REPORT       THRU 0510-EXIT            
             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.               
      *                                                                         
           PERFORM 7290-CLOSE-EVENT-SUMM-CSR  THRU 7290-EXIT.           
      *                                                                         
           MOVE SPACES                     TO FIOCB274-REC.             
           MOVE WS-REPT-END                TO FIOCB274-REC.             
           PERFORM 8100-WRITE-FIOCB274        THRU 8100-EXIT.           
      *                                                                         
       0500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0510-GENERATE-REPORT.                                            
      *================================================================*        
      *                                                                         
           MOVE ZEROES                     TO WS-EVENT-CNT-NUM.         
           MOVE SPACES                     TO FIOCB274-REC              
                                              WS-EVENT-CODE             
                                              WS-EVENT-DESC.            
                                                                        
           MOVE AE-EMAIL-EVENT-CD          TO 2T-EMAIL-EVENT-CD.        
           MOVE WS-COMPANY-NUMBER          TO 2T-COMPANY-NO.            
                                                                        
           PERFORM 7000-GET-EVENT-DESC        THRU 7000-EXIT.           
                                                                        
           ADD +1                          TO WS-SL-NO.                 
           MOVE AE-EMAIL-EVENT-CD          TO WS-EVENT-CODE.            
           MOVE WS-EVENT-COUNT             TO WS-EVENT-COUNT-R.         
      *                                                                         
           MOVE WS-REPT-RECORD             TO FIOCB274-REC.             
           PERFORM 8100-WRITE-FIOCB274        THRU 8100-EXIT.           
      *                                                                         
           PERFORM 7280-FETCH-EVENT-SUMM-CSR  THRU 7280-EXIT.           
      *                                                                         
       0510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1000-PROCESS-EMAIL-EVENT.                                        
      *================================================================*        
      *                                                                         
           IF AE-EMAIL-EVENT-CD NOT EQUAL WS-PREV-EMAIL-EVENT           
              MOVE AE-EMAIL-EVENT-CD       TO WS-PREV-EMAIL-EVENT       
              MOVE +0                      TO WS-TEMP-COUNT             
           ELSE                                                         
              IF WS-TEMP-COUNT >= WS-MAX-COUNTER                        
                 PERFORM 7220-FETCH-BATCH-EMAIL-CSR                     
                                              THRU 7220-EXIT            
                 GO TO 1000-EXIT                                        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE ZERO                       TO WS-TALLY                  
                                              HT-ACCOUNT-NO             
                                              WS-NULL-IND-FIELD-VALUE.  
      *                                                                         
           MOVE SPACES                     TO WS-RECORD-STRING          
                                              WS-BATCH-EMAIL-ID         
                                              LR-REG-GROUP-CD           
                                              NE-EMAIL-DISP-PREF-CD     
                                              NE-EMAIL-ADDRESS-TX       
                                              DQ-FIRST-NAME             
                                              DQ-LAST-NAME              
                                              DQ-FULL-NAME.             
      *                                                                         
           MOVE WS-EXTRACTED               TO RS-PROCESSED-CD.          
      *                                                                         
           MOVE AE-ACCOUNT-NO              TO RS-ACCOUNT-NO             
                                              HT-ACCOUNT-NO             
                                              LR-ACCOUNT-NO.            
           MOVE AE-EMAIL-EVENT-CD          TO RS-EMAIL-EVENT-CD.        
           MOVE AE-EMAIL-EVENT-DT          TO RS-EMAIL-EVENT-DT.        
           MOVE AE-COMPANY-NO              TO RS-COMPANY-NO.            
           MOVE AE-CUSTOMER-NO             TO RS-CUSTOMER-NO.           
           MOVE 2T-EVENT-CHANNEL-CD        TO RS-EVENT-CHANNL-CD.       
           MOVE 2T-REG-GROUP-CD            TO RS-REG-GROUP-CD.          
           MOVE NE-EMAIL-DISP-PREF-CD      TO RS-EMAIL-DISP-CD.         
      *                                                                         
           INSPECT NE-EMAIL-ADDRESS-TX-TEXT                             
               REPLACING ALL LOW-VALUES BY SPACES.                      
                                                                        
           IF OVERRIDE-EMAIL-USED                                       
              MOVE WS-OVRERRIDE-EMAIL      TO RS-CUST-EMAIL-ID          
           ELSE                                                         
              IF NE-EMAIL-ADDRESS-TX-TEXT > SPACES                      
                 MOVE NE-EMAIL-ADDRESS-TX-TEXT                          
                                           TO RS-CUST-EMAIL-ID          
              ELSE                                                      
                 PERFORM 7220-FETCH-BATCH-EMAIL-CSR                     
                                              THRU 7220-EXIT            
                 GO TO 1000-EXIT                                        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           INITIALIZE WS-ACCTNO-MASK.                                   
           MOVE RS-ACCOUNT-NO(10:4)        TO WS-ACCT-4-DIGITS.         
           MOVE WS-ACCTNO-MASK             TO RS-ACCNO-MASK.            
      *                                                                         
           MOVE AE-BATCH-EMAIL-ID          TO WS-BATCH-EMAIL-ID.        
           INSPECT WS-BATCH-EMAIL-ID                                    
                   TALLYING WS-TALLY FOR LEADING ZEROES.                
           MOVE WS-BATCH-EMAIL-ID(WS-TALLY + 1 :)                       
                                           TO RS-BATCH-EMAIL-ID.        
      *                                                                         
           PERFORM 7100-GET-CUSTOMER-NAME     THRU 7100-EXIT.           
           IF DQ-FIRST-NAME > SPACES OR DQ-LAST-NAME > SPACES           
              MOVE DQ-FIRST-NAME           TO RS-FIRST-NAME             
              MOVE DQ-LAST-NAME            TO RS-LAST-NAME              
           ELSE                                                         
              MOVE DQ-FULL-NAME            TO RS-LAST-NAME              
           END-IF.                                                      
      *                                                                         
           PERFORM 2000-PROCESS-EMAIL-DETAILS THRU 2000-EXIT.           
      *                                                                         
           PERFORM 2300-REPLACE-SEEBILL       THRU 2300-EXIT.           
      *                                                                         
           IF SEB-DATABASE                                              
              SET SEB-DEREGULATED TO TRUE                               
              PERFORM 7110-SELECT-REG-PROFILE THRU 7110-EXIT            
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 SET SEB-REGULATED TO TRUE                              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF WS-TEMP-COUNT <= WS-MAX-COUNTER                           
              PERFORM 3000-PREP-RECORD-STRING THRU 3000-EXIT            
              PERFORM 3100-WRITE-COMPANY-RECD THRU 3100-EXIT            
              DISPLAY AE-EMAIL-EVENT-CD ' - ' RS-BATCH-EMAIL-ID         
           END-IF.                                                      
      *                                                                         
           PERFORM 7220-FETCH-BATCH-EMAIL-CSR THRU 7220-EXIT.           
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2000-PROCESS-EMAIL-DETAILS.                                      
      *================================================================*        
      *                                                                         
           SET SEEBILL-AMOUNT-NO TO TRUE.                               
           SET MORE-DETAILS TO TRUE.                                    
           SET DR-DATE-NO TO TRUE.                                      
           SET BI-DATE-NO TO TRUE.                                      
           SET CH-DATE-NO TO TRUE.                                      
                                                                        
           MOVE AE-BATCH-EMAIL-ID          TO JK-BATCH-EMAIL-ID.        
      *                                                                         
           PERFORM 7240-OPEN-EMAIL-DTL-CSR    THRU 7240-EXIT.           
      *                                                                         
           PERFORM 7250-FETCH-EMAIL-DTL-CSR   THRU 7250-EXIT.           
      *                                                                         
           PERFORM 2100-POPULATE-DETAILS      THRU 2100-EXIT            
                                              UNTIL NO-MORE-DETAILS.    
      *                                                                         
           PERFORM 7260-CLOSE-EMAIL-DTL-CSR   THRU 7260-EXIT.           
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2100-POPULATE-DETAILS.                                           
      *================================================================*        
      *                                                                         
           MOVE SPACES                     TO WS-FORMAT-AMOUNT-IN.      
                                                                        
           EVALUATE JK-FIELD-NAME-TX                                    
                                                                        
              WHEN 'PREM-ADDR'                                          
                  MOVE JK-FIELD-VALUE-TX-TEXT                           
                                           TO RS-PREM-ADDR              
              WHEN 'BANK-ACCT'                                          
                  MOVE JK-FIELD-VALUE-TX-TEXT                           
                                           TO RS-BANK-ACCT              
              WHEN 'DRAFT-DT'                                           
                  MOVE JK-FIELD-VALUE-TX-TEXT                           
                                           TO RS-DRAFT-DT               
                  SET DR-DATE-YES TO TRUE                               
              WHEN 'BILLD-DT'                                           
                  MOVE JK-FIELD-VALUE-TX-TEXT                           
                                           TO RS-BILLD-DT               
                  SET BI-DATE-YES TO TRUE                               
              WHEN 'CHRGE-DT'                                           
                  MOVE JK-FIELD-VALUE-TX-TEXT                           
                                           TO RS-CHRGE-DT               
                  SET CH-DATE-YES TO TRUE                               
              WHEN 'DRAFT-AMT'                                          
                  PERFORM 2200-FORMAT-AMOUNT  THRU 2200-EXIT            
                  IF WS-TALLY-SB = 0                                    
                     MOVE WS-FMT-SIGN      TO RS-DRAFT-SYM              
                     MOVE WS-SYMBOL        TO RS-DRAFT-DLR              
                  END-IF                                                
                  MOVE WS-FMT-AMOUNT       TO RS-DRAFT-AMT              
                                                                        
              WHEN 'BILLD-AMT'                                          
                  PERFORM 2200-FORMAT-AMOUNT  THRU 2200-EXIT            
                  IF WS-TALLY-SB = 0                                    
                     MOVE WS-FMT-SIGN      TO RS-BILLD-SYM              
                     MOVE WS-SYMBOL        TO RS-BILLD-DLR              
                  END-IF                                                
                  MOVE WS-FMT-AMOUNT       TO RS-BILLD-AMT              
                                                                        
              WHEN 'CHRGE-AMT'                                          
                  PERFORM 2200-FORMAT-AMOUNT  THRU 2200-EXIT            
                  IF WS-TALLY-SB = 0                                    
                     MOVE WS-FMT-SIGN      TO RS-CHRGE-SYM              
                     MOVE WS-SYMBOL        TO RS-CHRGE-DLR              
                  END-IF                                                
                  MOVE WS-FMT-AMOUNT       TO RS-CHRGE-AMT              
                                                                        
              WHEN 'SCHED-DT'                                           
                  MOVE JK-FIELD-VALUE-TX-TEXT                           
                                           TO RS-SCHED-DT               
              WHEN 'DEP-AMT '                                           
                  MOVE JK-FIELD-VALUE-TX-TEXT                           
                                           TO RS-DEP-AMT                
              WHEN 'UTIL-TYPE'                                          
                  MOVE JK-FIELD-VALUE-TX-TEXT                           
                                           TO RS-UTIL-TYPE              
              WHEN 'REQ-TYPE'                                           
                  MOVE JK-FIELD-VALUE-TX-TEXT                           
                                           TO RS-REQ-TYPE               
              WHEN 'CONTACT-INFO'                                       
                  MOVE JK-FIELD-VALUE-TX-TEXT                           
                                           TO RS-CONTACT-INFO           
              WHEN 'APPT-ARRG'                                          
                  MOVE JK-FIELD-VALUE-TX-TEXT                           
                                           TO RS-APPT-ARRG              
              WHEN 'CUST-NAME'                                          
                  MOVE JK-FIELD-VALUE-TX-TEXT                           
                                           TO RS-CUST-NAME              
P00730        WHEN 'GUID-LINK'                                          
P00730            MOVE JK-FIELD-VALUE-TX-TEXT TO RS-GUID-LINK           
P00730                                                                  
P00730        WHEN 'ALT-EMAIL'                                          
P00730            MOVE JK-FIELD-VALUE-TX-TEXT TO WS-ALT-EMAIL-ID        
                                                                        
              WHEN OTHER                                                
                  DISPLAY '*************************'                   
                  DISPLAY 'UNHANDLED EMAIL DTL ' JK-FIELD-VALUE-TX-TEXT 
                  DISPLAY '*************************'                   
                                                                        
           END-EVALUATE.                                                
      *                                                                         
           MOVE SPACES                     TO JK-FIELD-NAME-TX          
                                              JK-FIELD-VALUE-TX.        
                                                                        
           PERFORM 7250-FETCH-EMAIL-DTL-CSR   THRU 7250-EXIT.           
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2200-FORMAT-AMOUNT.                                              
      *================================================================*        
      *                                                                         
           MOVE JK-FIELD-VALUE-TX-TEXT     TO WS-FORMAT-AMOUNT-IN.      
           MOVE ZEROES                     TO WS-NUMVAL-AMT             
                                              WS-TALLY-SB.              
           MOVE SPACES                     TO WS-TEMP-AMOUNT            
                                              WS-SEND-FMT-AMOUNT.       
           INSPECT WS-FORMAT-AMOUNT-IN                                  
              REPLACING ALL LOW-VALUES BY SPACES.                       
                                                                        
           INSPECT WS-FORMAT-AMOUNT-IN                                  
              REPLACING ALL HIGH-VALUES BY SPACES.                      
                                                                        
           INSPECT WS-FORMAT-AMOUNT-IN                                  
                   TALLYING WS-TALLY-SB FOR ALL 'E'.                    
                                                                        
           IF WS-TALLY-SB > 0                                           
              SET SEEBILL-AMOUNT-YES TO TRUE                            
              MOVE WS-FORMAT-AMOUNT-IN     TO WS-FMT-AMOUNT             
              GO TO 2200-EXIT
           END-IF.                                          
                                                                        
           INSPECT WS-FORMAT-AMOUNT-IN                                  
              REPLACING LEADING SPACES BY ZEROES.                       
                                                                        
           COMPUTE WS-NUMVAL-AMT =                                      
                   FUNCTION NUMVAL (WS-FORMAT-AMOUNT-IN)                
                                                                        
           MOVE WS-NUMVAL-AMT              TO WS-FORMAT-AMOUNT-OUT      
           MOVE WS-FORMAT-AMOUNT-OUT       TO WS-TEMP-AMOUNT            
                                                                        
           UNSTRING WS-TEMP-AMOUNT DELIMITED BY WS-SYMBOL               
               INTO WS-FMT-SIGN                                         
                    WS-FMT-AMOUNT                                       
           END-UNSTRING.                                                
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *** Transalates 'SEEBILL' with comments based on the amount.              
      *================================================================*        
       2300-REPLACE-SEEBILL.                                            
      *================================================================*        
      *                                                                         
           IF DR-DATE-YES                                               
              IF RS-DRAFT-DT = WS-SEEBILL                               
                 IF SEEBILL-AMOUNT-YES                                  
                    MOVE WS-SEE-BILL-FOR-DTLS                           
                                           TO RS-DRAFT-DT               
                 ELSE                                                   
                    IF WS-NUMVAL-AMT <= 0                               
                       MOVE WS-NO-PAYMENT-DUE                           
                                           TO RS-DRAFT-DT               
                    ELSE                                                
                       MOVE WS-SEE-BILL-FOR-DTLS                        
                                           TO RS-DRAFT-DT               
                    END-IF                                              
                 END-IF                                                 
              ELSE                                                      
                 IF ( NOT SEEBILL-AMOUNT-YES )                          
                      AND WS-NUMVAL-AMT <= 0                            
                      MOVE WS-NO-PAYMENT-DUE                            
                                           TO RS-DRAFT-DT               
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF BI-DATE-YES                                               
              IF RS-BILLD-DT = WS-SEEBILL                               
                 IF SEEBILL-AMOUNT-YES                                  
                    MOVE WS-SEE-BILL-FOR-DTLS                           
                                           TO RS-BILLD-DT               
                 ELSE                                                   
                    IF WS-NUMVAL-AMT <= 0                               
                       MOVE WS-NO-PAYMENT-DUE                           
                                           TO RS-BILLD-DT               
                    ELSE                                                
                       MOVE WS-SEE-BILL-FOR-DTLS                        
                                           TO RS-BILLD-DT               
                    END-IF                                              
                 END-IF                                                 
              ELSE                                                      
                 IF ( NOT SEEBILL-AMOUNT-YES )                          
                      AND WS-NUMVAL-AMT <= 0                            
                      MOVE WS-NO-PAYMENT-DUE                            
                                           TO RS-BILLD-DT               
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF CH-DATE-YES                                               
              IF RS-CHRGE-DT = WS-SEEBILL                               
                 IF SEEBILL-AMOUNT-YES                                  
                    MOVE WS-SEE-BILL-FOR-DTLS                           
                                           TO RS-CHRGE-DT               
                 ELSE                                                   
                    IF WS-NUMVAL-AMT <= 0                               
                       MOVE WS-NO-PAYMENT-DUE                           
                                           TO RS-CHRGE-DT               
                    ELSE                                                
                       MOVE WS-SEE-BILL-FOR-DTLS                        
                                           TO RS-CHRGE-DT               
                    END-IF                                              
                 END-IF                                                 
              ELSE                                                      
                 IF ( NOT SEEBILL-AMOUNT-YES )                          
                      AND WS-NUMVAL-AMT <= 0                            
                      MOVE WS-NO-PAYMENT-DUE                            
                                           TO RS-CHRGE-DT               
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF RS-BILLD-AMT = WS-SEEBILL                                 
              MOVE WS-SEE-BILL-FOR-DTLS    TO RS-BILLD-AMT              
           END-IF.                                                      
                                                                        
           IF RS-DRAFT-AMT = WS-SEEBILL                                 
              MOVE WS-SEE-BILL-FOR-DTLS    TO RS-DRAFT-AMT              
           END-IF.                                                      
                                                                        
           IF RS-CHRGE-AMT = WS-SEEBILL                                 
              MOVE WS-SEE-BILL-FOR-DTLS    TO RS-CHRGE-AMT              
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      * Prepare the string and write output record based on the Company.        
      * Program creates file for SCEG, PSNC, SEB Reg and SEB DeReg.             
      *================================================================*        
       3000-PREP-RECORD-STRING.                                         
      *================================================================*        
      *                                                                         
           MOVE SPACES                     TO FIOCA274.                 
           MOVE +1                         TO FIOCA274-LEN.             
      *                                                                         
           STRING S-CUSTOMER-NO           DELIMITED BY '   '            
                  '|'                                                   
                  S-ACCOUNT-NO            DELIMITED BY '   '            
                  '|'                                                   
                  S-FIRST-NAME            DELIMITED BY '   '            
                  '|'                                                   
                  S-LAST-NAME             DELIMITED BY '   '            
                  '|'                                                   
                  S-CUST-EMAIL-ID         DELIMITED BY '   '            
                  '|'                                                   
                  S-BATCH-EMAIL-ID        DELIMITED BY '   '            
                  '|'                                                   
                  S-EMAIL-EVENT-CD        DELIMITED BY '   '            
                  '|'                                                   
                  S-EMAIL-EVENT-DT        DELIMITED BY '   '            
                  '|'                                                   
                  S-COMPANY-NO            DELIMITED BY '   '            
                  '|'                                                   
                  S-EMAIL-DISP-CD         DELIMITED BY '   '            
                  '|'                                                   
                  S-ACCNO-MASK            DELIMITED BY '   '            
                  '|'                                                   
                  S-EVENT-CHANNL-CD       DELIMITED BY '   '            
                  '|'                                                   
                  S-REG-GROUP-CD          DELIMITED BY '   '            
                  '|'                                                   
                  S-PROCESSED-CD          DELIMITED BY '   '            
                  '|'                                                   
                  S-PREM-ADDR             DELIMITED BY '   '            
                  '|'                                                   
                  S-BANK-ACCT             DELIMITED BY '   '            
                  '|'                                                   
                  S-DRAFT-DT              DELIMITED BY '   '            
                  '|'                                                   
                  S-DRAFT-SYM             DELIMITED BY ' '              
                  S-DRAFT-DLR             DELIMITED BY ' '              
                  S-DRAFT-AMT             DELIMITED BY '   '            
                  '|'                                                   
                  S-BILLD-DT              DELIMITED BY '   '            
                  '|'                                                   
                  S-BILLD-SYM             DELIMITED BY ' '              
                  S-BILLD-DLR             DELIMITED BY '   '            
                  S-BILLD-AMT             DELIMITED BY '   '            
                  '|'                                                   
                  S-CHRGE-DT              DELIMITED BY '   '            
                  '|'                                                   
                  S-CHRGE-SYM             DELIMITED BY '   '            
                  S-CHRGE-DLR             DELIMITED BY '   '            
                  S-CHRGE-AMT             DELIMITED BY '   '            
                  '|'                                                   
                  S-SCHED-DT              DELIMITED BY '   '            
                  '|'                                                   
                  S-UTIL-TYPE             DELIMITED BY '   '            
                  '|'                                                   
                  S-REQ-TYPE              DELIMITED BY '   '            
                  '|'                                                   
                  S-CONTACT-INFO          DELIMITED BY '   '            
                  '|'                                                   
                  S-APPT-ARRG             DELIMITED BY '   '            
                  '|'                                                   
                  S-DEP-AMT               DELIMITED BY '   '            
                  '|'                                                   
                  S-CUST-NAME             DELIMITED BY '   '            
                  '|  '                   DELIMITED BY '   '            
P00730            S-GUID-LINK             DELIMITED BY '   '            
P00730            '|  '                   DELIMITED BY '   '            
              INTO FIOCA274 WITH POINTER FIOCA274-LEN                   
           END-STRING.                                                  
      *                                                                         
           COMPUTE FIOCA274-LEN = FIOCA274-LEN - 1.                     
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      * Check the Company for which the Job is running and write output         
      * for the corresponding file. Job runs for SCEG/PSNC/SEB/SEBR             
      *================================================================*        
       3100-WRITE-COMPANY-RECD.                                         
      *================================================================*        
      *                                                                         
           IF SEB-DATABASE                                              
              IF SEB-REGULATED   AND SEBR-RUN                           
                 PERFORM 8000-WRITE-FIOCA274  THRU 8000-EXIT            
                 ADD +1                    TO WS-TOTAL-RECORDS          
                                              WS-TEMP-COUNT             
              END-IF                                                    
              IF SEB-DEREGULATED AND SEB-RUN                            
                 PERFORM 8000-WRITE-FIOCA274  THRU 8000-EXIT            
                 ADD +1                    TO WS-TOTAL-RECORDS          
                                              WS-TEMP-COUNT             
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF CSR-DATABASE                                              
              IF AE-COMPANY-NO = WS-RUN-FOR-COMPANY                     
                 PERFORM 8000-WRITE-FIOCA274  THRU 8000-EXIT            
                 ADD +1                    TO WS-TOTAL-RECORDS          
                                              WS-TEMP-COUNT             
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       3100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      * 6500-LOAD-EXCP-LIMITS                                                   
      *================================================================*        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00314                                                 
           END-EXEC.                                                            
      *                                                                         
      *================================================================*        
       7000-GET-EVENT-DESC.                                             
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                SELECT CIS.SUBSTR3([2T].EMAIL_EVENT_DESC,1,60)                 
                  INTO :WS-EVENT-DESC                                   
                  FROM CSS_EMAIL_EVENT [2T] WITH(READUNCOMMITTED)               
                 WHERE [2T].COMPANY_NO       = :2T-COMPANY-NO             
                   AND [2T].EMAIL_EVENT_CD   = :2T-EMAIL-EVENT-CD         
                   AND [2T].EVENT_CHANNEL_CD = 'E'                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT SUBSTR(2T.EMAIL_EVENT_DESC,1,60)                         
MFA-TR*           INTO :WS-EVENT-DESC                                           
MFA-TR*           FROM CSS_EMAIL_EVENT 2T                                       
MFA-TR*          WHERE 2T.COMPANY_NO       = :2T-COMPANY-NO                     
MFA-TR*            AND 2T.EMAIL_EVENT_CD   = :2T-EMAIL-EVENT-CD                 
MFA-TR*            AND 2T.EVENT_CHANNEL_CD = 'E'                                
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7000                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '************ PCSCA274 ERROR ******************'  
              DISPLAY '** ERROR IN  7000-GET-EVENT-DESC            **'  
              DISPLAY '** SELECT ERROR IN CSS_EMAIL_EVENT 2T       **'  
              DISPLAY '** COMPANY_NO     = '  2T-COMPANY-NO             
              DISPLAY '** EMAIL_EVENT_CD = '  2T-EMAIL-EVENT-CD         
              DISPLAY '** SQL CODE       = '  WS-DISPLAY-SQLCODE        
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7100-GET-CUSTOMER-NAME.                                          
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                SELECT DQ.FIRST_NAME                                    
                      ,DQ.LAST_NAME                                     
                      ,LTRIM(RTRIM(DQ.FULL_NAME))                       
                  INTO :DQ-FIRST-NAME                                   
                      ,:DQ-LAST-NAME                                    
                      ,:DQ-FULL-NAME                                    
                  FROM CSS_NAME DQ WITH(READUNCOMMITTED)                        
                      ,CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)              
                 WHERE DQ.NAME_ID = HT.NAME_ID                          
                   AND HT.ACCOUNT_NO = :HT-ACCOUNT-NO                   
                   AND HT.CUSTOMER_ROLE_CD = ' '                        
                   AND DQ.NAME_TYPE = :WS-CUSTOMER-NAME                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT DQ.FIRST_NAME                                            
MFA-TR*               ,DQ.LAST_NAME                                             
MFA-TR*               ,LTRIM(RTRIM(DQ.FULL_NAME))                               
MFA-TR*           INTO :DQ-FIRST-NAME                                           
MFA-TR*               ,:DQ-LAST-NAME                                            
MFA-TR*               ,:DQ-FULL-NAME                                            
MFA-TR*           FROM CSS_NAME DQ                                              
MFA-TR*               ,CSS_NAME_ACCT_XREF HT                                    
MFA-TR*          WHERE DQ.NAME_ID = HT.NAME_ID                                  
MFA-TR*            AND HT.ACCOUNT_NO = :HT-ACCOUNT-NO                           
MFA-TR*            AND HT.CUSTOMER_ROLE_CD = ' '                                
MFA-TR*            AND DQ.NAME_TYPE = :WS-CUSTOMER-NAME                         
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7100                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                       OR NOT-FOUND                     
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '************ PCSCA274 ERROR ******************'  
              DISPLAY '** ERROR IN  7100-GET-CUSTOMER-NAME         **'  
              DISPLAY '** SELECT ERROR IN CSS_NAME_ACCT_XREF       **'  
              DISPLAY '** ACCOUNT NO     = '  HT-ACCOUNT-NO             
              DISPLAY '** SQL CODE       = '  WS-DISPLAY-SQLCODE        
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7110-SELECT-REG-PROFILE.                                         
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT REG_GROUP_CD                                      
                 INTO :LR-REG-GROUP-CD                                  
                 FROM CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                  
                WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT REG_GROUP_CD                                              
MFA-TR*          INTO :LR-REG-GROUP-CD                                          
MFA-TR*          FROM CSS_REG_PROFILE LR                                        
MFA-TR*         WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                               
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7110                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                       OR NOT-FOUND                     
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '************ PCSCA274 ERROR ******************'  
              DISPLAY '** ERROR IN  7110-SELECT-REG-PROFILE        **'  
              DISPLAY '** SELECT ERROR IN CSS_REG_PROFILE          **'  
              DISPLAY '** ACCOUNT NO     = '  LR-ACCOUNT-NO             
              DISPLAY '** SQL CODE       = '  WS-DISPLAY-SQLCODE        
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7210-OPEN-BATCH-EMAIL-CSR.                                       
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                OPEN BATCH_EMAIL_CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '************ PCSCA274 ERROR ******************'  
              DISPLAY '** ERROR IN  7210-OPEN-BATCH-EMAIL-CSR      **'  
              DISPLAY '** OPEN ERROR IN BATCH_EMAIL_CSR            **'  
              DISPLAY '** EMAIL_EVENT_DT = '  AE-EMAIL-EVENT-DT         
              DISPLAY '** SQL CODE       = '  WS-DISPLAY-SQLCODE        
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7220-FETCH-BATCH-EMAIL-CSR.                                      
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               FETCH FROM BATCH_EMAIL_CSR                               
                INTO :AE-BATCH-EMAIL-ID                                 
                    ,:AE-ACCOUNT-NO                                     
                    ,:AE-CUSTOMER-NO                                    
                    ,:AE-EMAIL-EVENT-CD                                 
                    ,:AE-PROCESSED-CD :WS-NULL-IND-1                    
                    ,:AE-EMAIL-EVENT-DT                                 
                    ,:AE-COMPANY-NO                                     
                    ,:NE-EMAIL-DISP-PREF-CD                             
                    ,:NE-EMAIL-ADDRESS-TX                               
                    ,:2T-EVENT-CHANNEL-CD                               
                    ,:2T-REG-GROUP-CD                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 SET NO-MORE-EVENTS TO TRUE                             
              WHEN OTHER                                                
                 MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE      
                 DISPLAY '************ PCSCA274 ERROR ****************' 
                 DISPLAY '** ERROR IN 7220-FETCH-BATCH-EMAIL-CSR    **' 
                 DISPLAY '** FETCH ERROR IN BATCH_EMAIL_CSR         **' 
                 DISPLAY '** EMAIL_EVENT_DT = '  AE-EMAIL-EVENT-DT      
                 DISPLAY '** SQL CODE       = '  WS-DISPLAY-SQLCODE     
                 DISPLAY '** PROCESSING TERMINATED                  **' 
                 DISPLAY '********************************************' 
                 PERFORM 9900-ABEND           THRU 9900-EXIT            
           END-EVALUATE.                                                
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7230-CLOSE-BATCH-EMAIL-CSR.                                      
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                CLOSE BATCH_EMAIL_CSR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '************ PCSCA274 ERROR ******************'  
              DISPLAY '** ERROR IN 7230-CLOSE-BATCH-EMAIL-CSR      **'  
              DISPLAY '** CLOSE ERROR FOR IN BATCH_EMAIL_CSR       **'  
              DISPLAY '** EMAIL_EVENT_DT   = '  AE-EMAIL-EVENT-DT       
              DISPLAY '** SQL CODE         = '  WS-DISPLAY-SQLCODE      
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7240-OPEN-EMAIL-DTL-CSR.                                         
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                OPEN EMAIL_DTL_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '************ PCSCA274 ERROR ******************'  
              DISPLAY '** ERROR IN  7240-OPEN-EMAIL-DTL-CSR        **'  
              DISPLAY '** OPEN ERROR IN EMAIL_DTL_CSR              **'  
              DISPLAY '** BATCH_EMAIL_ID = '  JK-BATCH-EMAIL-ID         
              DISPLAY '** SQL CODE       = '  WS-DISPLAY-SQLCODE        
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7240-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7250-FETCH-EMAIL-DTL-CSR.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               FETCH FROM EMAIL_DTL_CSR                                 
                INTO :JK-FIELD-NAME-TX                                  
                    ,:JK-FIELD-VALUE-TX :WS-NULL-IND-FIELD-VALUE        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 SET NO-MORE-DETAILS TO TRUE                            
              WHEN OTHER                                                
                 MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE      
                 DISPLAY '************ PCSCA274 ERROR ****************' 
                 DISPLAY '** ERROR IN 7250-FETCH-EMAIL-DTL-CSR      **' 
                 DISPLAY '** FETCH ERROR IN EMAIL_DTL_CSR           **' 
                 DISPLAY '** BATCH_EMAIL_ID = '  JK-BATCH-EMAIL-ID      
                 DISPLAY '** SQL CODE       = '  WS-DISPLAY-SQLCODE     
                 DISPLAY '** PROCESSING TERMINATED                  **' 
                 DISPLAY '********************************************' 
                 PERFORM 9900-ABEND           THRU 9900-EXIT            
           END-EVALUATE.                                                
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7260-CLOSE-EMAIL-DTL-CSR.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                CLOSE EMAIL_DTL_CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '************ PCSCA274 ERROR ******************'  
              DISPLAY '** ERROR IN 7260-CLOSE-EMAIL-DTL-CSR        **'  
              DISPLAY '** CLOSE ERROR FOR IN EMAIL_DTL_CSR         **'  
              DISPLAY '** BATCH_EMAIL_ID   = '  JK-BATCH-EMAIL-ID       
              DISPLAY '** SQL CODE         = '  WS-DISPLAY-SQLCODE      
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7270-OPEN-EVENT-SUMM-CSR.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                OPEN EVENT_SUMM_CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '************ PCSCA274 ERROR ******************'  
              DISPLAY '** ERROR IN  7270-OPEN-EVENT-SUMM-CSR       **'  
              DISPLAY '** OPEN ERROR IN EVENT_SUMM_CSR             **'  
              DISPLAY '** EMAIL_EVENT_DT = '  AE-EMAIL-EVENT-DT         
              DISPLAY '** COMPANY_NO     = '  AE-COMPANY-NO             
              DISPLAY '** SQL CODE       = '  WS-DISPLAY-SQLCODE        
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7270-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7280-FETCH-EVENT-SUMM-CSR.                                       
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               FETCH FROM EVENT_SUMM_CSR                                
                INTO :AE-EMAIL-EVENT-CD                                 
                    ,:WS-EVENT-COUNT                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                       OR NOT-FOUND                     
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '************ PCSCA274 ERROR ****************'    
              DISPLAY '** ERROR IN 7280-FETCH-EVENT-SUMM-CSR     **'    
              DISPLAY '** FETCH ERROR IN EVENT_SUMM_CSR          **'    
              DISPLAY '** EMAIL_EVENT_DT = '  AE-EMAIL-EVENT-DT         
              DISPLAY '** COMPANY_NO     = '  AE-COMPANY-NO             
              DISPLAY '** SQL CODE       = '  WS-DISPLAY-SQLCODE        
              DISPLAY '** PROCESSING TERMINATED                  **'    
              DISPLAY '********************************************'    
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7280-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7290-CLOSE-EVENT-SUMM-CSR.                                       
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                CLOSE EVENT_SUMM_CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
              DISPLAY '************ PCSCA274 ERROR ******************'  
              DISPLAY '** ERROR IN 7290-CLOSE-EVENT-SUMM-CSR       **'  
              DISPLAY '** CLOSE ERROR FOR IN EVENT_SUMM_CSR        **'  
              DISPLAY '** EMAIL_EVENT_DT   = '  AE-EMAIL-EVENT-DT       
              DISPLAY '** COMPANY_NO       = '  AE-COMPANY-NO           
              DISPLAY '** SQL CODE         = '  WS-DISPLAY-SQLCODE      
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7290-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      *                                                                         
      *================================================================*        
      * GET FCA00 COMMON DATE - 6240-GET-FCA00-COMMON-DATE *                    
       COPY CPD00040.                                                           
      *================================================================*        
      *                                                                         
      *================================================================*        
      * READ PARM FILE FOR OVERRIDE DATE - 6251-GET-FJC01-DATE *                
       COPY CPD00037.                                                           
      *================================================================*        
      *                                                                         
      *==============================================================*          
      * 7600-START-FCSJC01                    *                                 
      *==============================================================*          
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
      *                                                                         
      *==============================================================*          
      * 7620-START-FCSCA00 VSAM CTRL FILE     *                                 
      *==============================================================*          
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
      *                                                                         
      *================================================================*        
       8000-WRITE-FIOCA274.                                             
      *================================================================*        
      *                                                                         
           MOVE SPACES                     TO FIOCA274-REC.             
           WRITE FIOCA274-REC FROM FIOCA274.                            
      *                                                                         
           IF FCS274-SUCCESSFUL                                         
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '8000-ERROR ON FCSCA274 WRITE.  STATUS IS '      
                        WS-FCS274-STATUS                                
               PERFORM 9900-ABEND             THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8100-WRITE-FIOCB274.                                             
      *================================================================*        
      *                                                                         
           WRITE FIOCB274-REC.                                          
      *                                                                         
           IF FCS274B-SUCCESSFUL                                        
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '8800-WRITE-FIOCB273 WRITE.  STATUS IS '         
                       WS-FCS274B-STATUS                                
               PERFORM 9900-ABEND             THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       9000-TERMINATE.                                                  
      *===============================================================*         
      *                                                                         
           CLOSE FCSCA274-FILE.                                         
      *                                                                         
           IF FCS274-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**  PCSCA274 PROCESSING ERROR           **'     
               DISPLAY '**  CLOSE ERROR  - OUTPUT FILES         **'     
               DISPLAY '**  FILE STATUS = ' WS-FCS274-STATUS            
               DISPLAY '**  UNSUCCESSFUL CLOSE OF FCSCA274 FILE **'     
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      ****************************************************************          
      * 9700-PROCESS-ABEND  (REQUIED BY CPD00040)                    *          
      ****************************************************************          
       COPY CPD0023B.                                                           
      *                                                                         
      ****************************************************************          
      *  COPY BOOK CONTAINING 9900-ABEND INCLUDES SQL ROLLBACK   ****           
      ****************************************************************          
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
