       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA270.                                        
       AUTHOR.         SS95855.                                         
       DATE-WRITTEN.   30 MAY 2013.                                     
           DATE-COMPILED.                                               
                                                                        
      *****************************************************************         
      **             SOUTH CAROLINA ELECTRIC & GAS                   **         
      **                                                             **         
      **                  CUSTOMER SERVICE SYSTEM                    **         
      **                       COBOL/DB2                             **         
      *****************************************************************         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE       INITIALS      REASON                             **         
      ** =====      ========      ======                             **         
      ** 07/01/13   SS95855       A04527 1. HOLD WQ ACCOUNTS         **         
      **                                 2. RELEASE WQ ACCOUNTS      **         
      *****************************************************************         
                                                                        
           REMARKS.                                                     
                              PCSCA270 NARRATIVE                        
                              ==================                        
      *==============================================================*          
      *    HOLD ACCOUNTS THAT HAS ACTIVE WQ FROM SENDING EMAILS TO   *          
      *    CUSTOMER.RELEASE HELD ACCOUNTS AS WQ'S ARE COMPLETED.     *          
      *    THIS IS A REPLACEMENT FOR CSR00546 WHICH IS BEING TURNED  *          
      *    OFF ON THE WEB SIDE.                                      *          
      *==============================================================*          
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       INPUT-OUTPUT SECTION.                                            
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA270'.
MSQ017     COPY MFASQLM.
       01  WS-START                    PIC X(40)                        
           VALUE 'WORKING STORAGE FOR PCSCA270 STARTS HERE'.            
                                                                        
      ******************************************************************        
      *   ABEND SWITCH                                                 *        
      ******************************************************************        
       COPY CWS09900.                                                           
                                                                        
      ******************************************************************        
      *   WS ABEND WORK AREA                                          *         
      ******************************************************************        
       COPY CWS00010.                                                           
                                                                        
      ******************************************************************        
      *   DB2 ERROR PROCESSING                                        *         
      ******************************************************************        
       COPY CWS00303.                                                           
                                                                        
      ******************************************************************        
      *    COMMUNICATION AREA                                          *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BATCH_EMAIL    (AE)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBBEMAIL                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BTCH_EMAIL_DET (JK)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBBTEDET                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_WQ_CATEGORY    (C3)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBWQCAT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_JOB_PARM       (J6)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_WQ_ITEMS       (WQ)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBWQITS                                                  
           END-EXEC.                                                            
                                                                        
      ****************************************************************          
      *    CSS_DELINQUENCY    (C8)                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * MISC INPUT                                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * FCA00 MISC INPUT                                               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWS00039                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * FCA00-KEY                                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE FIOCA00                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * IO AREA FOR PARM INPUT FILE 'A'                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE FIOJC01                                                   
           END-EXEC.                                                            
                                                                        
       01 WS-LITERALS.                                                  
          05 WS-Y                      PIC X(01)  VALUE 'Y'.            
          05 WS-N                      PIC X(01)  VALUE 'N'.            
          05 WS-I                      PIC X(01)  VALUE 'I'.            
          05 WS-PGRMNAME               PIC X(08)  VALUE 'PCSCA270'.     
          05 PROGRAM-NAME              PIC X(08)  VALUE 'PCSCA270'.     
          05 WS-HOLD                   PIC X(01)  VALUE 'Q'.            
          05 WS-COMPANY-NO             PIC X(02)  VALUE '01'.           
          05 WS-SEEBILL                PIC X(07)  VALUE 'SEEBILL'.      
          05 MULTIPLE-ROWS             PIC S9(9)  VALUE -811 COMP.      
          05 WS-COMPLETED              PIC X(01)  VALUE 'C'.            
                                                                        
       01 WS-MISC.                                                      
          05 WS-TOT-UPT-CNT            PIC S9(04) VALUE 0 COMP.         
          05 WS-TOT-RLSE-CNT           PIC S9(04) VALUE 0 COMP.         
          05 WS-DISPLAY-SQLCODE        PIC ---9.                        
          05 WS-COMPANY-NUMBER         PIC X(02)  VALUE SPACES.         
          05 RS-RETURN-CODE            PIC S9(09) VALUE +0 COMP.        
          05 RS-RETURN-CODE-DISP       PIC S9(09) VALUE +0 COMP.        
                                                                        
       01 WS-SWITCHES.                                                  
          05 WS-NO-MORE-ROWS           PIC X(01).                       
             88 NO-MORE-ROWS                      VALUE 'N'.            
          05 WS-DATABASE               PIC 9      VALUE ZERO.           
             88  CSR-DATABASE                     VALUE 1.              
             88  SEB-DATABASE                     VALUE 2.              
          05 WS-SEB-EVENTS             PIC X(05)  VALUE SPACES.         
             88  SKIP-SEB-EVENTS                  VALUE 'ECS16' 'ECS18'.
          05 WS-CSR-EVENTS             PIC X(05)  VALUE SPACES.         
             88  SKIP-CSR-EVENTS                  VALUE 'ECS18'         
                'ECS20' 'ECS23' 'ECS24' 'ECS25' 'ECS26' 'ECS29'.        
                                                                        
       01 WS-END                       PIC X(40)                        
           VALUE 'WORKING STORAGE FOR PCSCA270 ENDS HERE  '.            
                                                                        
      *****************************************************************         
      **  RELEASE ACCOUNTS FOR EXTRACTION AS WQ'S ARE COMPLETED      **         
      **  WILL HOLD ACCOUNT IF THERE'S ANY ACTIVE WQ.                **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE RELEASE_ACCTS_CSR CURSOR FOR                      
                 SELECT DISTINCT AE.BATCH_EMAIL_ID                      
                       ,AE.ACCOUNT_NO                                   
                       ,AE.EMAIL_EVENT_CD                               
                       ,AE.COMPANY_NO                                   
                 FROM   CSS_BATCH_EMAIL AE WITH(READUNCOMMITTED)                
                       ,CSS_WQ_CATEGORY C3 WITH(READUNCOMMITTED)                
                       ,CSS_WQ_ITEMS    WQ WITH(READUNCOMMITTED)                
                 WHERE  AE.ACCOUNT_NO         =  WQ.ACCOUNT_NO          
                   AND  WQ.CATEGORY_ID        =  C3.CATEGORY_ID         
                   AND  C3.EBILL_NO_DISP_IND  =  :WS-Y                  
                   AND  WQ.STATUS             =  :WS-COMPLETED          
                   AND  AE.PROCESSED_CD       =  :WS-HOLD               
                   AND  AE.ACCOUNT_NO NOT IN (                          
                        SELECT  AE.ACCOUNT_NO                           
                          FROM  CSS_BATCH_EMAIL AE WITH(READUNCOMMITTED)        
                               ,CSS_WQ_CATEGORY C3 WITH(READUNCOMMITTED)        
                               ,CSS_WQ_ITEMS    WQ WITH(READUNCOMMITTED)        
                         WHERE  AE.ACCOUNT_NO         =  WQ.ACCOUNT_NO  
                           AND  WQ.CATEGORY_ID        =  C3.CATEGORY_ID 
                           AND  C3.EBILL_NO_DISP_IND  =  :WS-Y          
                           AND  WQ.STATUS IN ('A','I')                  
                           AND  AE.PROCESSED_CD       =  :WS-HOLD)      
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE RELEASE_ACCTS_CSR CURSOR FOR                              
MFA-TR*          SELECT DISTINCT AE.BATCH_EMAIL_ID                              
MFA-TR*                ,AE.ACCOUNT_NO                                           
MFA-TR*                ,AE.EMAIL_EVENT_CD                                       
MFA-TR*                ,AE.COMPANY_NO                                           
MFA-TR*          FROM   CSS_BATCH_EMAIL AE                                      
MFA-TR*                ,CSS_WQ_CATEGORY C3                                      
MFA-TR*                ,CSS_WQ_ITEMS    WQ                                      
MFA-TR*          WHERE  AE.ACCOUNT_NO         =  WQ.ACCOUNT_NO                  
MFA-TR*            AND  WQ.CATEGORY_ID        =  C3.CATEGORY_ID                 
MFA-TR*            AND  C3.EBILL_NO_DISP_IND  =  :WS-Y                          
MFA-TR*            AND  WQ.STATUS             =  :WS-COMPLETED                  
MFA-TR*            AND  AE.PROCESSED_CD       =  :WS-HOLD                       
MFA-TR*            AND  AE.ACCOUNT_NO NOT IN (                                  
MFA-TR*                 SELECT  AE.ACCOUNT_NO                                   
MFA-TR*                   FROM  CSS_BATCH_EMAIL AE                              
MFA-TR*                        ,CSS_WQ_CATEGORY C3                              
MFA-TR*                        ,CSS_WQ_ITEMS    WQ                              
MFA-TR*                  WHERE  AE.ACCOUNT_NO         =  WQ.ACCOUNT_NO          
MFA-TR*                    AND  WQ.CATEGORY_ID        =  C3.CATEGORY_ID         
MFA-TR*                    AND  C3.EBILL_NO_DISP_IND  =  :WS-Y                  
MFA-TR*                    AND  WQ.STATUS IN ('A','I')                          
MFA-TR*                    AND  AE.PROCESSED_CD       =  :WS-HOLD)              
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7400                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      **  CURSOR TO GET WQ ACCOUNTS TO HOLD FROM SENDING EMAIL       **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE WQ_ACCTS_CSR CURSOR FOR                           
                 SELECT DISTINCT AE.BATCH_EMAIL_ID                      
                       ,AE.ACCOUNT_NO                                   
                       ,AE.EMAIL_EVENT_CD                               
                       ,AE.COMPANY_NO                                   
                 FROM   CSS_BATCH_EMAIL AE WITH(READUNCOMMITTED)                
                       ,CSS_WQ_CATEGORY C3 WITH(READUNCOMMITTED)                
                       ,CSS_WQ_ITEMS    WQ WITH(READUNCOMMITTED)                
                 WHERE  AE.EMAIL_EVENT_DT    = IIF(TRY_CONVERT(DATE, 
                                                     :AE-EMAIL-EVENT-DT
              ) IS NULL OR (PATINDEX('%.%', :AE-EMAIL-EVENT-DT
              ) <> 0) OR (LEN(:AE-EMAIL-EVENT-DT
              ) <> 10), CIS.CHAR2DATE(:AE-EMAIL-EVENT-DT
              ), CONVERT(DATE, :AE-EMAIL-EVENT-DT) )       
                   AND  AE.ACCOUNT_NO        = WQ.ACCOUNT_NO            
                   AND  WQ.CATEGORY_ID       = C3.CATEGORY_ID           
                   AND  C3.EBILL_NO_DISP_IND = :WS-Y                    
                   AND  WQ.STATUS            IN ('A','I')               
                   AND  CAST(WQ.DATE_CREATED AS DATE) >= 
              IIF(TRY_CONVERT(DATE, :AE-EMAIL-EVENT-DT
              ) IS NULL OR (PATINDEX('%.%', :AE-EMAIL-EVENT-DT
              ) <> 0) OR (LEN(:AE-EMAIL-EVENT-DT
              ) <> 10), CIS.CHAR2DATE(:AE-EMAIL-EVENT-DT
              ), CONVERT(DATE, :AE-EMAIL-EVENT-DT) )     
                   AND  (AE.PROCESSED_CD IS NULL                        
                    OR   AE.PROCESSED_CD = ' ')                         
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE WQ_ACCTS_CSR CURSOR FOR                                   
MFA-TR*          SELECT DISTINCT AE.BATCH_EMAIL_ID                              
MFA-TR*                ,AE.ACCOUNT_NO                                           
MFA-TR*                ,AE.EMAIL_EVENT_CD                                       
MFA-TR*                ,AE.COMPANY_NO                                           
MFA-TR*          FROM   CSS_BATCH_EMAIL AE                                      
MFA-TR*                ,CSS_WQ_CATEGORY C3                                      
MFA-TR*                ,CSS_WQ_ITEMS    WQ                                      
MFA-TR*          WHERE  AE.EMAIL_EVENT_DT    = :AE-EMAIL-EVENT-DT               
MFA-TR*            AND  AE.ACCOUNT_NO        = WQ.ACCOUNT_NO                    
MFA-TR*            AND  WQ.CATEGORY_ID       = C3.CATEGORY_ID                   
MFA-TR*            AND  C3.EBILL_NO_DISP_IND = :WS-Y                            
MFA-TR*            AND  WQ.STATUS            IN ('A','I')                       
MFA-TR*            AND  DATE(WQ.DATE_CREATED) >= :AE-EMAIL-EVENT-DT             
MFA-TR*            AND  (AE.PROCESSED_CD IS NULL                                
MFA-TR*             OR   AE.PROCESSED_CD = ' ')                                 
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7100                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
      *****************************************************************         
      *                                                               *         
      * 0000-MAINLINE.                                                *         
      *****************************************************************         
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION        THRU 0100-EXIT.           
                                                                        
           PERFORM 2000-MAIN-PROCESS          THRU 2000-EXIT.           
                                                                        
           DISPLAY '  '                                                 
           DISPLAY '  ******************************'                   
           DISPLAY '  TOTAL ACCOUNTS ON HOLD      : ' WS-TOT-UPT-CNT    
           DISPLAY '  TOTAL ACCOUNTS RELEASED     : ' WS-TOT-RLSE-CNT   
           DISPLAY '  ******************************'                   
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZATION.                                           *        
      ******************************************************************        
       0100-INITIALIZATION.                                             
                                                                        
      *    GET COMMON DATE IF NO OVERRIDE DATE SPECIFIED                        
                                                                        
           PERFORM 6251-GET-FJC01-DATE           THRU 6251-EXIT.        
                                                                        
           IF  COMMON-DATE-NEEDED                                       
               PERFORM 6240-GET-FCA00-COMMON-DATE                       
                                                 THRU 6240-EXIT         
               DISPLAY 'COMMON DATE USED ==> '   WS-FCA00-COMMON-DATE   
               DISPLAY ' '                                              
               MOVE WS-FCA00-COMMON-DATE      TO WS-INPUT-DATE          
           END-IF.                                                      
                                                                        
      *    GET DATABASE FLAG TO CHECK EVENTS TO SKIP HOLDING                    
           MOVE ZERO                        TO WS-DATABASE.             
           MOVE '01'                        TO C8-COMPANY-NO.           
           MOVE 'DATABASE'                  TO C8-DELINQ-CD.            
           PERFORM 7900-SELECT-DELINQ-VALUE THRU 7900-EXIT.             
           MOVE C8-DELINQ-VALUE             TO WS-DATABASE.             
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-MAIN-PROCESS.                                             *        
      ******************************************************************        
       2000-MAIN-PROCESS.                                               
                                                                        
      *** CHECK IF WQ'S ARE COMPLETED AND RELEASE THEM FOR EXACT TARGET         
      *** BY UPDATING CSS_BATCH_EMAIL PROCESS CODE TO ' '                       
      *                                                                         
           DISPLAY '  '.                                                
           DISPLAY '*******   ACCOUNTS RELEASED   *******'.             
           DISPLAY '  '.                                                
                                                                        
           PERFORM 7400-OPEN-RELEASE-ACCTS-CSR  THRU 7400-EXIT.         
                                                                        
           PERFORM 7500-FETCH-RELEASE-ACCTS-CSR THRU 7500-EXIT.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              PERFORM 2200-RELEASE-ACCOUNTS    THRU 2200-EXIT           
                UNTIL NO-MORE-ROWS                                      
           END-IF.                                                      
                                                                        
           PERFORM 7550-CLOSE-RELEASE-ACCTS-CSR THRU 7550-EXIT.         
                                                                        
           IF WS-TOT-RLSE-CNT EQUAL ZEROES                              
              DISPLAY '***   NO ACCOUNTS RELEASED   ***'                
           END-IF.                                                      
                                                                        
      *                                                                         
           EXEC SQL                                                     
                COMMIT                                                  
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
      *** CHECK IF ACCOUNTS HAVE A WQ AND HOLD THEM FROM SENDING EMAILS         
      *** BY UPDATING CSS_BATCH_EMAIL PROCESS CODE TO 'Q'                       
      *                                                                         
           DISPLAY '  '.                                                
           DISPLAY '*******   ACCOUNTS HELD       *******'.             
           DISPLAY '  '.                                                
                                                                        
           MOVE WS-Y                        TO WS-NO-MORE-ROWS.         
           MOVE WS-INPUT-DATE               TO AE-EMAIL-EVENT-DT.       
                                                                        
           PERFORM 7100-OPEN-WQ-ACCTS-CSR      THRU 7100-EXIT.          
                                                                        
           PERFORM 7200-FETCH-WQ-ACCTS-CSR     THRU 7200-EXIT.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              PERFORM 2100-PROCESS-ACCOUNTS    THRU 2100-EXIT           
                UNTIL NO-MORE-ROWS                                      
           END-IF.                                                      
                                                                        
           PERFORM 7300-CLOSE-WQ-ACCTS-CSR     THRU 7300-EXIT.          
                                                                        
           IF WS-TOT-UPT-CNT EQUAL ZEROES                               
              DISPLAY '***   NO ACCOUNTS HELD       ***'                
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2100-PROCESS-ACCOUNTS.                                         *        
      ******************************************************************        
       2100-PROCESS-ACCOUNTS.                                           
                                                                        
           IF CSR-DATABASE                                              
              MOVE AE-EMAIL-EVENT-CD        TO WS-CSR-EVENTS            
              IF SKIP-CSR-EVENTS                                        
                 CONTINUE                                               
              ELSE                                                      
                 PERFORM 8000-UPDATE-TO-HOLD   THRU 8000-EXIT           
                 ADD +1                     TO WS-TOT-UPT-CNT           
                 DISPLAY 'HELD : ' AE-ACCOUNT-NO '  ' AE-BATCH-EMAIL-ID 
              END-IF                                                    
           ELSE                                                         
              MOVE AE-EMAIL-EVENT-CD        TO WS-SEB-EVENTS            
              IF SKIP-SEB-EVENTS                                        
                 CONTINUE                                               
              ELSE                                                      
                 PERFORM 8000-UPDATE-TO-HOLD   THRU 8000-EXIT           
                 ADD +1                     TO WS-TOT-UPT-CNT           
                 DISPLAY 'ACCNT: ' AE-ACCOUNT-NO '  ' AE-BATCH-EMAIL-ID 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE SPACES                      TO WS-CSR-EVENTS            
                                               WS-SEB-EVENTS.           
                                                                        
           PERFORM 7200-FETCH-WQ-ACCTS-CSR    THRU 7200-EXIT.           
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2100-RELEASE-ACCOUNTS.                                         *        
      ******************************************************************        
       2200-RELEASE-ACCOUNTS.                                           
                                                                        
           DISPLAY 'RLSE : ' AE-ACCOUNT-NO '  ' AE-BATCH-EMAIL-ID.      
                                                                        
           MOVE WS-INPUT-DATE               TO AE-EMAIL-EVENT-DT.       
                                                                        
           PERFORM 8100-UPDATE-RELEASE-ACCTS   THRU 8100-EXIT.          
                                                                        
           MOVE AE-BATCH-EMAIL-ID           TO JK-BATCH-EMAIL-ID.       
           MOVE +07                         TO JK-FIELD-VALUE-TX-LEN.   
           MOVE WS-SEEBILL                  TO JK-FIELD-VALUE-TX-TEXT.  
                                                                        
           PERFORM 8200-UPDATE-AMOUNT-FIELD    THRU 8200-EXIT.          
                                                                        
           ADD +1                            TO WS-TOT-RLSE-CNT.        
                                                                        
           PERFORM 7500-FETCH-RELEASE-ACCTS-CSR THRU 7500-EXIT.         
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7100-OPEN-WQ-ACCTS-CSR.                                        *        
      ******************************************************************        
       7100-OPEN-WQ-ACCTS-CSR.                                          
                                                                        
           EXEC SQL                                                     
                OPEN WQ_ACCTS_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-DISPLAY-SQLCODE     
              DISPLAY '************ PCSCA270 ERROR ******************'  
              DISPLAY '** ERROR IN  7100-OPEN-WQ-ACCTS-CSR         **'  
              DISPLAY '** OPEN ERROR IN WQ_ACCTS_CSR               **'  
              DISPLAY '** EMAIL_EVENT_DT    = '  AE-EMAIL-EVENT-DT      
              DISPLAY '** SQL CODE          = '  WS-DISPLAY-SQLCODE     
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *7200-FETCH-WQ-ACCTS-CSR.                                        *        
      ******************************************************************        
       7200-FETCH-WQ-ACCTS-CSR.                                         
                                                                        
           EXEC SQL                                                     
               FETCH FROM WQ_ACCTS_CSR                                  
                INTO :AE-BATCH-EMAIL-ID                                 
                    ,:AE-ACCOUNT-NO                                     
                    ,:AE-EMAIL-EVENT-CD                                 
                    ,:AE-COMPANY-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 SET NO-MORE-ROWS             TO TRUE                   
              WHEN OTHER                                                
                 MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE     
                 DISPLAY '************ PCSCA270 ERROR ****************' 
                 DISPLAY '** ERROR IN 7200-FETCH-WQ-ACCTS-CSR       **' 
                 DISPLAY '** FETCH ERROR IN WQ_ACCTS_CSR            **' 
                 DISPLAY '** EMAIL_EVENT_DT    = '  AE-EMAIL-EVENT-DT   
                 DISPLAY '** SQL CODE          = '  WS-DISPLAY-SQLCODE  
                 DISPLAY '** PROCESSING TERMINATED                  **' 
                 DISPLAY '********************************************' 
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *7300-CLOSE-WQ-ACCTS-CSR.                                        *        
      *================================================================*        
       7300-CLOSE-WQ-ACCTS-CSR.                                         
                                                                        
           EXEC SQL                                                     
                CLOSE WQ_ACCTS_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-DISPLAY-SQLCODE     
              DISPLAY '************ PCSCA270 ERROR ******************'  
              DISPLAY '** ERROR IN 7300-CLOSE-WQ-ACCTS-CSR         **'  
              DISPLAY '** CLOSE ERROR FOR IN WQ_ACCTS_CSR          **'  
              DISPLAY '** EMAIL_EVENT_DT    = '  AE-EMAIL-EVENT-DT      
              DISPLAY '** SQL CODE          = '  WS-DISPLAY-SQLCODE     
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7400-OPEN-RELEASE-ACCTS-CSR.                                   *        
      ******************************************************************        
       7400-OPEN-RELEASE-ACCTS-CSR.                                     
                                                                        
           EXEC SQL                                                     
                OPEN RELEASE_ACCTS_CSR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-DISPLAY-SQLCODE     
              DISPLAY '************ PCSCA270 ERROR ******************'  
              DISPLAY '** ERROR IN 7400-OPEN-RELEASE-ACCTS-CSR     **'  
              DISPLAY '** OPEN ERROR IN RELEASE_ACCTS_CSR          **'  
              DISPLAY '** SQL CODE          = '  WS-DISPLAY-SQLCODE     
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *7500-FETCH-RELEASE-ACCTS-CSR.                                   *        
      ******************************************************************        
       7500-FETCH-RELEASE-ACCTS-CSR.                                    
                                                                        
           EXEC SQL                                                     
               FETCH FROM RELEASE_ACCTS_CSR                             
                INTO :AE-BATCH-EMAIL-ID                                 
                    ,:AE-ACCOUNT-NO                                     
                    ,:AE-EMAIL-EVENT-CD                                 
                    ,:AE-COMPANY-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 SET NO-MORE-ROWS           TO TRUE                     
              WHEN OTHER                                                
                 MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE       
                 DISPLAY '************ PCSCA270 ERROR ****************' 
                 DISPLAY '** ERROR IN 7500-FETCH-RELEASE-ACCTS-CSR  **' 
                 DISPLAY '** FETCH ERROR IN RELEASE_ACCTS_CSR       **' 
                 DISPLAY '** SQL CODE          = '  WS-DISPLAY-SQLCODE  
                 DISPLAY '** PROCESSING TERMINATED                  **' 
                 DISPLAY '********************************************' 
                 PERFORM 9900-ABEND            THRU 9900-EXIT           
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *7550-CLOSE-RELEASE-ACCTS-CSR.                                   *        
      *================================================================*        
       7550-CLOSE-RELEASE-ACCTS-CSR.                                    
                                                                        
           EXEC SQL                                                     
                CLOSE RELEASE_ACCTS_CSR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-DISPLAY-SQLCODE     
              DISPLAY '************ PCSCA270 ERROR ******************'  
              DISPLAY '** ERROR IN 7550-CLOSE-RELEASE-ACCTS-CSR    **'  
              DISPLAY '** CLOSE ERROR FOR IN RELEASE_ACCTS_CSR     **'  
              DISPLAY '** SQL CODE          = '  WS-DISPLAY-SQLCODE     
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * GET FCA00 COMMON DATE - 6240-GET-FCA00-COMMON-DATE             *        
      ******************************************************************        
       COPY CPD00040.                                                           
                                                                        
      ******************************************************************        
      * READ PARM FILE FOR OVERRIDE DATE - 6251-GET-FJC01-DATE         *        
      ******************************************************************        
       COPY CPD00037.                                                           
                                                                        
      ******************************************************************        
      * 7600-START-FCSJC01                    * *                               
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 7620-START-FCSCA00 VSAM CTRL FILE                              *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *                                                                *        
      *7900-SELECT-DELINQ-VALUE.                                       *        
      *================================================================*        
       7900-SELECT-DELINQ-VALUE.                                        
                                                                        
           EXEC SQL                                                     
                SELECT  DELINQ_VALUE                                    
                  INTO  :C8-DELINQ-VALUE                                
                  FROM  CSS_DELINQUENCY                                 
                 WHERE  DELINQ_CD   = :C8-DELINQ-CD                     
                   AND  COMPANY_NO  = :C8-COMPANY-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR MULTIPLE-ROWS  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-DISPLAY-SQLCODE     
              DISPLAY '************ PCSCA270 ERROR ******************'  
              DISPLAY '** ERROR IN 7900-SELECT-DELINQ-VALUE        **'  
              DISPLAY '** SELECT ERROR IN CSS_DELINQUENCY          **'  
              DISPLAY '** SQL CODE       = '  WS-DISPLAY-SQLCODE        
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8000-UPDATE-TO-HOLD.                                           *        
      ******************************************************************        
       8000-UPDATE-TO-HOLD.                                             
                                                                        
           EXEC SQL                                                     
                UPDATE CSS_BATCH_EMAIL                                  
                   SET PROCESSED_CD    = :WS-HOLD                       
                      ,PROCESSED_DT    = CAST(SYSDATETIMEOFFSET() 
           AS DATE)                   
                 WHERE BATCH_EMAIL_ID  = :AE-BATCH-EMAIL-ID             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_BATCH_EMAIL                                          
MFA-TR*            SET PROCESSED_CD    = :WS-HOLD                               
MFA-TR*               ,PROCESSED_DT    = CURRENT DATE                           
MFA-TR*          WHERE BATCH_EMAIL_ID  = :AE-BATCH-EMAIL-ID                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO WS-DISPLAY-SQLCODE       
              DISPLAY '************ PCSCA270 ERROR ******************'  
              DISPLAY '** ERROR IN 8000-UPDATE-TO-HOLD             **'  
              DISPLAY '** UPDATE CSS_BATCH_EMAIL                   **'  
              DISPLAY '** SQL CODE       = '  WS-DISPLAY-SQLCODE        
              DISPLAY '** ACCOUNT_NO     = '  AE-ACCOUNT-NO             
              DISPLAY '** BATCH_EMAIL_ID = '  AE-BATCH-EMAIL-ID         
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8100-UPDATE-RELEASE-ACCTS.                                     *        
      ******************************************************************        
       8100-UPDATE-RELEASE-ACCTS.                                       
                                                                        
           EXEC SQL                                                     
                UPDATE CSS_BATCH_EMAIL                                  
                   SET PROCESSED_CD    = NULL                           
                      ,PROCESSED_DT    = NULL                           
                      ,EMAIL_EVENT_DT  = IIF(TRY_CONVERT(DATE, 
                                                     :AE-EMAIL-EVENT-DT
              ) IS NULL OR (PATINDEX('%.%', :AE-EMAIL-EVENT-DT
              ) <> 0) OR (LEN(:AE-EMAIL-EVENT-DT
              ) <> 10), CIS.CHAR2DATE(:AE-EMAIL-EVENT-DT
              ), CONVERT(DATE, :AE-EMAIL-EVENT-DT) )             
                 WHERE BATCH_EMAIL_ID  = :AE-BATCH-EMAIL-ID             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_BATCH_EMAIL                                          
MFA-TR*            SET PROCESSED_CD    = NULL                                   
MFA-TR*               ,PROCESSED_DT    = NULL                                   
MFA-TR*               ,EMAIL_EVENT_DT  = :AE-EMAIL-EVENT-DT                     
MFA-TR*          WHERE BATCH_EMAIL_ID  = :AE-BATCH-EMAIL-ID                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-DISPLAY-SQLCODE     
              DISPLAY '************ PCSCA270 ERROR ******************'  
              DISPLAY '** ERROR IN 8100-UPDATE-RELEASE-ACCTS       **'  
              DISPLAY '** UPDATE PROCESSED CD AS EXTRACTED         **'  
              DISPLAY '** PROCESSED_CD   = '  AE-PROCESSED-CD           
              DISPLAY '** EMAIL_EVENT_DT = '  AE-EMAIL-EVENT-DT         
              DISPLAY '** BATCH_EMAIL_ID = '  AE-BATCH-EMAIL-ID         
              DISPLAY '** ACCOUNT_NO     = '  AE-ACCOUNT-NO             
              DISPLAY '** SQL CODE       = '  WS-DISPLAY-SQLCODE        
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *8200-UPDATE-AMOUNT-FIELD                                        *        
      ******************************************************************        
       8200-UPDATE-AMOUNT-FIELD.                                        
                                                                        
           EXEC SQL                                                     
                UPDATE CSS_BTCH_EMAIL_DET                               
                   SET FIELD_VALUE_TX     = :JK-FIELD-VALUE-TX          
                 WHERE BATCH_EMAIL_ID     = :JK-BATCH-EMAIL-ID          
                   AND FIELD_NAME_TX  IN ('DRAFT-AMT','BILLD-AMT')      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO WS-DISPLAY-SQLCODE       
              DISPLAY '************ PCSCA270 ERROR ******************'  
              DISPLAY '** ERROR IN 8200-UPDATE-AMOUNT-FIELD        **'  
              DISPLAY '** UPDATE SEEBILL FOR AMOUNT                **'  
              DISPLAY '** FIELD_VALUE_TX = '  JK-FIELD-VALUE-TX         
              DISPLAY '** BATCH_EMAIL_ID = '  JK-BATCH-EMAIL-ID         
              DISPLAY '** ACCOUNT_NO     = '  AE-ACCOUNT-NO             
              DISPLAY '** SQL CODE       = '  WS-DISPLAY-SQLCODE        
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *===============================================================*         
       9000-TERMINATE.                                                  
      *===============================================================*         
      *                                                                         
           DISPLAY 'PERFORMING 9000-ABEND'.                             
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      ****************************************************************          
      * 9700-PROCESS-ABEND  (REQUIED BY CPD00040)                    *          
      ****************************************************************          
       COPY CPD0023B.                                                           
      *                                                                         
      ****************************************************************          
      *  COPY BOOK CONTAINING 9900-ABEND INCLUDES SQL ROLLBACK   ****           
      ****************************************************************          
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
