       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA267.                                        
       DATE-WRITTEN.   MAY 2010.                                        
      ******************************************************************        
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL                **        
      **                                                              **        
      ********            CUSTOMER SERVICE SYSTEM             **********        
      ********                      DB2                       **********        
      ******************************************************************        
      **              PROGRAM  MODIFICATION  LOG                      **        
      **                                                              **        
      **   DATE         INITIALS   REASON                             **        
      **   __________   ________   ______________                     **        
P00307**   05/09/2010   AA97148    INITIAL PROGRAM VERSION.           **        
A03866**   01/23/2012   MC95456    MOVED MESSAGE ID TO PROMOTION-ID IN**        
A03866** A03866-ACT005             CSS_COMM_DATA                      **        
P00599**                                                                        
P00599**   09/10/2012   WR19680    CHANGED PROGRAM TO WRITE TO NEW    **        
P00599**                           CORRESPONDENCE TABLES INSTEAD OF   **        
P00599**                           FIORP00 FILE                       **        
A04880**   07/28/2014   AS7C117    made the changes in cursor nserting**        
A04880**                ACT240     BBP_AUTOMATION to avoid multiple   **        
A04880**                           Account                            **        
A04880**                           Remove unused dclgens/paras/       **        
A04880**                           copybooks                          **        
      ******************************************************************        
      **       -------------- PCSCA267 NARRATIVE --------------       **        
      ******************************************************************        
      ******************************************************************        
      ** THIS PROGRAM CREATES A FILE WHICH WILL BE USED TO POPULATE   **        
      ** FCSRP000 DETAILS AND INSERT A ROW INTO CSS_BUDGET_HIST TABLE.**        
      ******************************************************************        
      ******************************************************************        
      **                                                              **        
      **            ---- BASIC SEQUENCE STRUCTURE ----                **        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     INPUT PROCESSING CONTROL PATH         **        
      **        2000 - 2999     OUTPUT PROCESSING CONTROL PATH        **        
      **        3000 - 4999     BATCH PROCESSING MODULES - NOT USED   **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     COMMON SYSTEM MODULES                 **        
      **        7000 - 7999     INPUT MODULES                         **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9799     TERMINATION MODULES                   **        
      **        9900 - 9999     ABEND/ABORT MODULES                   **        
      **                                                              **        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
HPCCDM*EJECT                                                                    
       FILE SECTION.                                                    
      *                                                                         
HPCCDM*EJECT                                                                    
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA267'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-START                    PIC X(40)  VALUE             
               'WORKING STORAGE FOR PCSCA267 STARTS HERE'.              
           05  WS-DISPLAY-SQLCODE          PIC -Z(8)9.                  
           05  WS-RP000-REC-CNTR           PIC 9(08)  VALUE 0.          
           05  WS-DATE-PYMT-STRT-NULL      PIC S9(04) COMP  VALUE +0.   
           05  WS-RED-FL-NULL-IND          PIC S9(04) COMP  VALUE +0.   
           05  WS-END-NULL-IND             PIC S9(04) COMP  VALUE +0.   
           05  WS-DATE-05-DAYS-AGO         PIC X(10)  VALUE SPACES.     
           05  WS-CURRENT-DATE             PIC X(10)  VALUE SPACES.     
           05  WS-WORK-DATE                PIC X(10)  VALUE SPACES.     
           05  WS-ADJ-DAY                  PIC S9(9)  COMP  VALUE +0.   
           05  WS-CURRENT-TIMESTAMP        PIC X(26)  VALUE SPACES.     
P00599     05  S-RETURN-CODE               PIC S9(9) VALUE +000 COMP.   
A03866     05  WS-MESSAGE-NO               PIC 9(05)  VALUE 90703.      
P00599     05  WS-TIMESTAMP                PIC X(26) VALUE SPACES.      
A04880     05  RS-RETURN-CODE              PIC S9(04)     COMP VALUE 0. 
A04880     05  RS-RETURN-CODE-DISP         PIC +Z(04).                  
P00599     05  PROGRAM-NAME                PIC X(08) VALUE 'PCSCA267'.  
P00599     05  SCSKR125                    PIC X(08) VALUE 'SCSKR125'.  
P00599     05  RS-KR125-RETURN-CODE        PIC S9(04) COMP VALUE 0.     
           05  WS-NO-MORE-RECORDS          PIC X(01)  VALUE 'N'.        
               88 NO-MORE-RECORDS                     VALUE 'Y'.        
      *                                                                         
      *                                                                         
           05  WS-JOB-PARM                 PIC X(10)  VALUE SPACES.     
           05  WS-JOB-PARM-R REDEFINES WS-JOB-PARM.                     
               10  FILLER                  PIC X(02).                   
               10  WS-JOB-PARM-YEAR        PIC X(02).                   
               10  FILLER                  PIC X(01).                   
               10  WS-JOB-PARM-MONTH       PIC X(02).                   
               10  FILLER                  PIC X(01).                   
               10  WS-JOB-PARM-DAY         PIC X(02).                   
      *                                                                         
       01  WS-NAME-TABLE.                                               
           05  WS-NAME-FORMAT              PIC X(01).                   
           05  WS-FIRST-NAME               PIC X(15).                   
           05  WS-MIDDLE-NAME              PIC X(15).                   
           05  WS-LAST-NAME                PIC X(40).                   
           05  WS-TITLE-PREFIX             PIC X(09).                   
           05  WS-TITLE-SUFFIX-1           PIC X(03).                   
           05  WS-TITLE-SUFFIX-2           PIC X(03).                   
           05  WS-FULL-NAME                PIC X(70).                   
      *                                                                         
       01  WS-FORMATTED-NAME.                                           
           05  WS-FMT-TITLE-PREFIX         PIC X(09).                   
           05  FILLER                      PIC X(01).                   
           05  WS-FMT-FIRST-NAME           PIC X(15).                   
           05  FILLER                      PIC X(01).                   
           05  WS-FMT-MIDDLE-NAME          PIC X(15).                   
           05  FILLER                      PIC X(01).                   
           05  WS-FMT-LAST-NAME            PIC X(40).                   
           05  FILLER                      PIC X(01).                   
           05  WS-FMT-TITLE-SUFFIX-1       PIC X(03).                   
           05  FILLER                      PIC X(01).                   
           05  WS-FMT-TITLE-SUFFIX-2       PIC X(03).                   
      *                                                                         
       01  WS-WORK-DAY-TABLE.                                           
           05  WS-WORK-DAY-LIST                                         
                  OCCURS 101 TIMES                                      
                  ASCENDING KEY WS-WORK-DAY                             
                  INDEXED BY WD-INDX.                                   
               10 WS-WORK-DAY              PIC X(10).                   
      *                                                                         
P00599 01  WS-HIST-DISP-DATE.                                           
P00599     10  WS-HIST-DISP-MM         PIC X(02).                       
P00599     10  FILLER                  PIC X(01) VALUE '/'.             
P00599     10  WS-HIST-DISP-DD         PIC X(02).                       
P00599     10  FILLER                  PIC X(01) VALUE '/'.             
P00599     10  WS-HIST-DISP-YR         PIC X(04).                       
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME                 PIC X(08)  VALUE 'PCSCA267'. 
           05  WS-FINAL-COMM-TEXT1         PIC X(61)  VALUE SPACES.     
           05  WS-N                        PIC X(01)  VALUE 'N'.        
           05  WS-Y                        PIC X(01)  VALUE 'Y'.        
           05  WS-FINAL-COMM-TEXT.                                      
               10  FILLER                  PIC X(35)  VALUE             
                   'Budget Billing Amount Changed from '.               
               10  WS-OLD-BBP-AMT          PIC $$$$$$$$.$$.             
               10  FILLER                  PIC X(04) VALUE ' TO '.      
               10  WS-NEW-BBP-AMT          PIC $$$$$$$$.$$.             
      *                                                                         
P00599******* CORRESP NOTICE VARIABLES************                              
P00599 COPY CWS00341.                                                           
P00599*                                                                         
P00599******************************************************************        
P00599* WS CWS00350                                                    *        
P00599******************************************************************        
P00599*                                                                         
P00599     EXEC SQL                                                             
P00599         INCLUDE CWS00350                                                 
P00599     END-EXEC.                                                            
P00599*                                                                         
      ******************************************************************        
      * WS FOR DB2 & CICS ERROR PROCESSING                             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00303                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * FCA00-KEY                                                      *        
      ******************************************************************        
      *                                                                         
       COPY FIOCA00.                                                            
      *                                                                         
      ******************************************************************        
      * FIOJC01 WORKING STORAGE                                        *        
      ******************************************************************        
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
      ******************************************************************        
      * COPY BOOK TO READ THE JOB PARM TABLE                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * WS USED FOR CPD00039                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00039                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CWS00315 CONTAINS WS FOR FINDING NEXT BUSINESS DAY            *         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE CWS00322                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * ABEND SWITCH COPYBOOK                                          *        
      ******************************************************************        
       COPY CWS09900.                                                           
       COPY CWS00010.                                                           
                                                                        
      ******************************************************************        
      * DB2 TABLES INCLUDED IN PROGRAM                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_ACCOUNT - AT                                               *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_BUDGET_HIST - BH                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBGTHST                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_BUDGET_PLAN - BU                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBGTPLN                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_JOB_PARM - G6                                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_REG_PROFILE - LR                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBREGPRF                                                 
           END-EXEC.                                                            
      *                                                                         
P00599******************************************************************        
P00599*  CSS_DELINQUENCY   - C8                                        *        
P00599******************************************************************        
P00599*                                                                         
P00599     EXEC SQL                                                             
P00599       INCLUDE TBDELQ                                                     
P00599     END-EXEC.                                                            
P00599*                                                                         
      ******************************************************************        
      * WS USED TO REDUCE EMBEDDED BLANKS                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00011                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * BBP-WQ-AUTOMATION-CURSOR                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE BBP_AUTOMATION CURSOR FOR                         
               SELECT BH.ACCOUNT_NO                                     
                     ,BH.PYMT_PRIORITY_LVL                              
                     ,BH.ITEM_ID                                        
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BH.BUD_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           BUD_HIST_SEQ_NO                                
                     ,BH.AMT_MO_PYMT                                    
                     ,BH.DATE_PYMT_STRT                                 
                     ,BH.UTILITY_BALANCE                                
                     ,BH.BALANCE_FORWARD                                
                     ,BH.EPP_ESTIMATE                                   
                     ,BH.EPP_MTHS_RMNG_QT                               
                     ,BH.METHOD_OF_ESTIMATE                             
                     ,BH.REMARKS                                        
                     ,BH.BUDG_BILL_PREV_AMT                             
                     ,AT.COMPANY_NO                                     
                     ,AT.BILL_CYCLE                                     
                     ,AT.CUSTOMER_NO                                    
                     ,AT.ADDRESS_ID                                     
                     ,AT.LOCAL_OFFICE                                   
                     ,AT.ADDRESS_FORMAT                                 
                     ,AT.PREMISE_NO                                     
                 FROM CSS_BUDGET_HIST BH WITH(READUNCOMMITTED)                  
                     ,CSS_ACCOUNT     AT WITH(READUNCOMMITTED)                  
                     ,CSS_BUDGET_PLAN BU WITH(READUNCOMMITTED)                  
                WHERE AT.ACCOUNT_NO             = BH.ACCOUNT_NO         
                  AND BH.ACCOUNT_NO             = BU.ACCOUNT_NO         
                  AND BH.CHANGE_REASON         IN ('X','Y')             
                  AND CAST(BH.BUD_HIST_SEQ_NO AS DATE) <= 
              IIF(TRY_CONVERT(DATE, :WS-DATE-05-DAYS-AGO
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-05-DAYS-AGO
              ) <> 0) OR (LEN(:WS-DATE-05-DAYS-AGO
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-05-DAYS-AGO
              ), CONVERT(DATE, :WS-DATE-05-DAYS-AGO) )  
A04880            AND BH.BUD_HIST_SEQ_NO        = (                     
A04880                SELECT MAX(C.BUD_HIST_SEQ_NO)                     
A04880                  FROM CSS_BUDGET_HIST C WITH(READUNCOMMITTED)            
A04880                 WHERE C.ACCOUNT_NO       = BH.ACCOUNT_NO         
A04880                   AND C.CHANGE_REASON   IN ('X','Y')             
A04880                   AND BH.BUD_HIST_SEQ_NO > (                     
A04880                          SELECT COALESCE(MAX(A.BUD_HIST_SEQ_NO), 
A04880                                 CIS.CHAR2TIMESTAMP(
              '0001-01-01-00.00.00.000000'))    
A04880                            FROM CSS_BUDGET_HIST A
                           WITH(READUNCOMMITTED)                
A04880                           WHERE A.ACCOUNT_NO = BH.ACCOUNT_NO     
A04880                             AND A.CHANGE_REASON IN ( 'Z','S')))  
                ORDER BY BH.ACCOUNT_NO                                  
                        ,BUD_HIST_SEQ_NO DESC                        
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE BBP_AUTOMATION CURSOR FOR                                 
MFA-TR*        SELECT BH.ACCOUNT_NO                                             
MFA-TR*              ,BH.PYMT_PRIORITY_LVL                                      
MFA-TR*              ,BH.ITEM_ID                                                
MFA-TR*              ,BH.BUD_HIST_SEQ_NO                                        
MFA-TR*              ,BH.AMT_MO_PYMT                                            
MFA-TR*              ,BH.DATE_PYMT_STRT                                         
MFA-TR*              ,BH.UTILITY_BALANCE                                        
MFA-TR*              ,BH.BALANCE_FORWARD                                        
MFA-TR*              ,BH.EPP_ESTIMATE                                           
MFA-TR*              ,BH.EPP_MTHS_RMNG_QT                                       
MFA-TR*              ,BH.METHOD_OF_ESTIMATE                                     
MFA-TR*              ,BH.REMARKS                                                
MFA-TR*              ,BH.BUDG_BILL_PREV_AMT                                     
MFA-TR*              ,AT.COMPANY_NO                                             
MFA-TR*              ,AT.BILL_CYCLE                                             
MFA-TR*              ,AT.CUSTOMER_NO                                            
MFA-TR*              ,AT.ADDRESS_ID                                             
MFA-TR*              ,AT.LOCAL_OFFICE                                           
MFA-TR*              ,AT.ADDRESS_FORMAT                                         
MFA-TR*              ,AT.PREMISE_NO                                             
MFA-TR*          FROM CSS_BUDGET_HIST BH                                        
MFA-TR*              ,CSS_ACCOUNT     AT                                        
MFA-TR*              ,CSS_BUDGET_PLAN BU                                        
MFA-TR*         WHERE AT.ACCOUNT_NO             = BH.ACCOUNT_NO                 
MFA-TR*           AND BH.ACCOUNT_NO             = BU.ACCOUNT_NO                 
MFA-TR*           AND BH.CHANGE_REASON         IN ('X','Y')                     
MFA-TR*           AND DATE(BH.BUD_HIST_SEQ_NO) <= :WS-DATE-05-DAYS-AGO          
MFA-TR*           AND BH.BUD_HIST_SEQ_NO        = (                             
MFA-TR*               SELECT MAX(C.BUD_HIST_SEQ_NO)                             
MFA-TR*                 FROM CSS_BUDGET_HIST C                                  
MFA-TR*                WHERE C.ACCOUNT_NO       = BH.ACCOUNT_NO                 
MFA-TR*                  AND C.CHANGE_REASON   IN ('X','Y')                     
MFA-TR*                  AND BH.BUD_HIST_SEQ_NO > (                             
MFA-TR*                         SELECT COALESCE(MAX(A.BUD_HIST_SEQ_NO),         
MFA-TR*                                '0001-01-01-00.00.00.000000')            
MFA-TR*                           FROM CSS_BUDGET_HIST A                        
MFA-TR*                          WHERE A.ACCOUNT_NO = BH.ACCOUNT_NO             
MFA-TR*                            AND A.CHANGE_REASON IN ( 'Z','S')))          
MFA-TR*         ORDER BY BH.ACCOUNT_NO                                          
MFA-TR*                 ,BH.BUD_HIST_SEQ_NO DESC                                
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION          THRU 0100-EXIT.         
           PERFORM 1000-INPUT-PROCESS           THRU 1000-EXIT.         
      *    PERFORM 9000-TERMINATE               THRU 9000-EXIT.                 
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZATION                                            *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
      * GET COMMON DATE                                                         
           PERFORM 6251-GET-FJC01-DATE          THRU 6251-EXIT.         
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE                        
                                                THRU 6240-EXIT          
              MOVE WS-FCA00-COMMON-DATE     TO WS-INPUT-DATE            
           END-IF.                                                      
      *                                                                         
           MOVE WS-INPUT-DATE               TO WS-JOB-PARM.             
           PERFORM 7530-GET-CUR-TIMESTAMP       THRU 7530-EXIT.         
           PERFORM 0110-LOAD-WORK-DAYS          THRU 0110-EXIT.         
      *                                                                         
P00599* TO IDENTIFY THE DATA BASE                                               
P00599     MOVE ZERO                            TO WS-CWS350-DATABASE.  
P00599     MOVE '01'                            TO C8-COMPANY-NO.       
P00599     MOVE 'DATABASE'                      TO C8-DELINQ-CD.        
P00599     PERFORM 7200-SELECT-DELINQ-VALUE     THRU 7200-EXIT.         
P00599     MOVE C8-DELINQ-VALUE                 TO WS-CWS350-DATABASE.  
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0110-LOAD-WORK-DAYS                                            *        
      * LOAD PREVIOUS 5 DAYS INTO TEMP TABLE. ENTRY 101 IS ALWAYS THE  *        
      * CURRENT DATE; 1-100 ARE PAST; 102-300 ARE FUTURE               *        
      ******************************************************************        
      *                                                                         
       0110-LOAD-WORK-DAYS.                                             
      *                                                                         
           MOVE WS-INPUT-DATE  TO WS-CURRENT-DATE                       
                                  WS-WORK-DAY (101)                     
                                  WS-NEW-BUSINESS-DAY.                  
      *                                                                         
           MOVE 1 TO WS-ADJ-DAY.                                        
           SET WD-INDX TO 100.                                          
           PERFORM UNTIL WD-INDX < 1                                    
                      OR WS-ADJ-DAY > 15                                
              PERFORM 6525-PREV-BUSINESS-DAY                            
                 THRU 6525-PREV-BUSINESS-DAY-EXIT                       
                 MOVE WS-NEW-BUSINESS-DAY TO WS-WORK-DAY(WD-INDX)       
                    ADD 1 TO WS-ADJ-DAY                                 
                    SET WD-INDX DOWN BY 1                               
           END-PERFORM.                                                 
      *                                                                         
           MOVE WS-WORK-DAY (96)            TO WS-DATE-05-DAYS-AGO.     
      *                                                                         
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-INPUT-PROCESS                                             *        
      ******************************************************************        
      *                                                                         
       1000-INPUT-PROCESS.                                              
      *                                                                         
           PERFORM 7000-OPEN-BBP-AUTOMTN-CSR    THRU 7000-EXIT.         
           PERFORM 7010-FETCH-BBP-AUTOMTN-CSR   THRU 7010-EXIT.         
           PERFORM 2000-PROCESS-OUTPUT          THRU 2000-EXIT          
             UNTIL NO-MORE-RECORDS.                                     
           PERFORM 7020-CLOSE-BBP-AUTOMTN-CSR   THRU 7020-EXIT.         
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT                                            *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
      *    IF BH-ACCOUNT-NO NOT EQUAL WS-PREV-ACCOUNT-NO                        
              PERFORM 2100-MOVE-FILE-DETAILS    THRU 2100-EXIT.         
      *                                                                         
              IF WS-DATE-PYMT-STRT-NULL < 0                             
                 MOVE -1                    TO WS-DATE-PYMT-STRT-NULL   
              END-IF.                                                   
              MOVE WS-CURRENT-TIMESTAMP     TO BH-LAST-UPDATE-TS        
                                               BH-BUD-HIST-SEQ-NO.      
              MOVE 'Z'                      TO BH-CHANGE-REASON.        
      *                                                                         
              PERFORM 8200-INSERT-BUDGET-HIST   THRU 8200-EXIT.         
      *    END-IF.                                                              
      *                                                                         
           PERFORM 7010-FETCH-BBP-AUTOMTN-CSR   THRU 7010-EXIT.         
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-MOVE-FILE-DETAILS                                         *        
      ******************************************************************        
      *                                                                         
       2100-MOVE-FILE-DETAILS.                                          
      *                                                                         
           MOVE BH-ACCOUNT-NO               TO AT-ACCOUNT-NO            
                                               LR-ACCOUNT-NO            
P00599     INITIALIZE WS-CORRESP-NOTICE                                 
P00599                WS-CORRESP-VAR                                    
P00599                WS-CORRESP-HDR.                                   
      *                                                                         
      *                                                                         
P00599     MOVE WS-MESSAGE-NO               TO WS-CORRESP-MSG-ID.       
           MOVE AT-COMPANY-NO               TO WS-CORRESP-COMPANY-NO    
                                               WS-PROCESS-COMPANY-NO.   
P00599     MOVE WS-CURRENT-DATE             TO WS-CORRESP-CREATE-DT     
P00599                                         WS-COMMON-DATE           
P00599                                         WS-CORRESP-STMT-DT.      
P00599     MOVE ZEROES                  TO WS-NOTICE-GUARANTOR-ACCT-NO. 
P00599     MOVE SPACES                  TO WS-CORRESP-BARCODE-UNIQUE-ID.
P00599     MOVE BH-ACCOUNT-NO               TO WS-NOTICE-ACCOUNT-NO.    
P00599     MOVE AT-CUSTOMER-NO              TO WS-NOTICE-CUSTOMER-NO.   
P00599     MOVE AT-LOCAL-OFFICE             TO WS-CWS350-LOCAL-OFFICE.  
P00599     MOVE BH-AMT-MO-PYMT              TO WS-BH-AMT-MO-PYMT        
                                               WS-NEW-BBP-AMT.          
P00599     MOVE BH-EPP-MTHS-RMNG-QT         TO WS-BH-EPP-MTHS-RMNG.     
P00599     MOVE BH-BUDG-BILL-PREV-AMT       TO WS-BH-PREV-AMT-MO-PYMT   
                                               WS-OLD-BBP-AMT.          
      *                                                                         
           PERFORM 7510-SELECT-REG-PROFILE      THRU 7510-EXIT.         
P00599     MOVE LR-REG-GROUP-CD             TO WS-NOTICE-REG-GROUP-CD.  
      *                                                                         
P00599     MOVE WS-PGRMNAME                 TO                          
P00599                                    WS-CORRESP-CREATED-BY-PGM-ID  
P00599                                    WS-CORRESP-LAST-UPDATE-PGM-ID.
P00599     MOVE WS-PGRMNAME                 TO WS-CALLING-PGM-NAME.     
P00599* MOVE VALUES TO WS-KR125-COMM-DATA-VARS                                  
P00599     INITIALIZE WS-KR125-COMM-DATA-VARS                           
P00599     MOVE BH-ACCOUNT-NO               TO WS-KR125-COMM-ACCT-NO    
P00599     MOVE AT-PREMISE-NO               TO WS-KR125-PREMISE-NO.     
P00599     MOVE AT-CUSTOMER-NO              TO WS-KR125-CUSTOMER-NO.    
P00599     MOVE 'A'                         TO WS-KR125-COMM-ASSOC-CD.  
P00599     MOVE 'N'                         TO WS-KR125-PSC-COMPL-ID.   
P00599     MOVE SPACES                      TO WS-KR125-CONTACT-NAME    
P00599                                         WS-KR125-RED-FL-EXP-DT   
P00599                                         WS-KR125-CALL-END-TIME.  
P00599*                                                                         
P00599     MOVE SPACES                      TO WS-EMB-INPUT             
P00599                                         WS-CMP-TABLE             
P00599                                         WS-FINAL-COMM-TEXT1.     
P00599     MOVE WS-FINAL-COMM-TEXT          TO WS-FINAL-COMM-TEXT1.     
P00599     MOVE WS-FINAL-COMM-TEXT1         TO WS-EMB-INPUT.            
P00599     MOVE 61                          TO WS-EMB-LENG.             
P00599     PERFORM 6010-REDUCE-EMBEDDED-SPACES  THRU 6011-EXIT.         
P00599     MOVE WS-CMP-TABLE                TO WS-FINAL-COMM-TEXT1.     
P00599     MOVE LENGTH OF WS-FINAL-COMM-TEXT1                           
P00599                                      TO                          
P00599                                       WS-KR125-COMDAT-CMT-LEN.   
P00599     MOVE WS-FINAL-COMM-TEXT1         TO                          
P00599                                       WS-KR125-COMDAT-CMT-TEXT.  
      *                                                                         
P00599* INITIALIZE WS-KR125-MNT-TRANS-VARS...IS NOT USED IN THIS PGM.           
P00599     INITIALIZE WS-KR125-MNT-TRANS-VARS.                          
      *                                                                         
P00599     PERFORM 5000-CALL-NOTICES        THRU 5000-EXIT.             
      *                                                                         
           MOVE ZERO                        TO WS-OLD-BBP-AMT           
                                               WS-NEW-BBP-AMT.          
P00599*                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00599*                                                                         
P00599******************************************************************        
P00599* 5000-CALL-NOTICES                                                       
P00599******************************************************************        
P00599*                                                                         
P00599 5000-CALL-NOTICES.                                               
P00599                                                                  
P00599     CALL SCSKR125 USING   WS-CORRESP-HDR                         
P00599                           WS-CORRESP-NOTICE                      
P00599                           WS-CORRESP-VAR                         
P00599                           WS-MISC-PROCESSING-VARS                
P00599                           WS-KR125-COMM-DATA-VARS                
P00599                           WS-KR125-MNT-TRANS-VARS                
P00599                           ABEND-FILE                             
P00599                           WS-CWS350-MISC                         
P00599                           WS-CORRESP-COMM-VAR                    
P00599                           RS-KR125-RETURN-CODE.                  
P00599                                                                  
P00599     IF RS-RETURN-CODE > 0                                        
P00599         MOVE ABEND-SQLCODE           TO RS-RETURN-CODE           
P00599         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
P00599     END-IF.                                                      
P00599                                                                  
P00599 5000-EXIT.                                                       
P00599     EXIT.                                                        
      ******************************************************************        
      * 6010-REDUCE-EMBEDDED-SPACES                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00004                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6251-GET-FJC01-DATE                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00037                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6240-GET-FCA00-COMMON-DATE                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00040                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    6500-GET-NEXT-BUSINESS-DAY                                **         
      *    COPYBOOK CPD00322 CONTAINS THE LOGIC FOR FINDING          **         
      *    THE NEXT BUSINESS DAY.                                    **         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CPD00322                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7000-OPEN-BBP-AUTOMTN-CSR                                      *        
      ******************************************************************        
      *                                                                         
       7000-OPEN-BBP-AUTOMTN-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
              OPEN BBP_AUTOMATION                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*********************************************'   
              DISPLAY '* PCSCA267 PROCESSING ERROR                 *'   
              DISPLAY '* ABEND IN 7000-OPEN-BBP-AUTOMTN-CSR        *'   
              DISPLAY '* BBP_AUTOMATION OPEN ERROR                 *'   
              DISPLAY '* WS-DATE-05-DAYS-AGO = ' WS-DATE-05-DAYS-AGO    
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                     *'   
              DISPLAY '*********************************************'   
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7010-FETCH-BBP-AUTOMTN-CSR                                     *        
      ******************************************************************        
      *                                                                         
       7010-FETCH-BBP-AUTOMTN-CSR.                                      
      *                                                                         
           EXEC SQL                                                     
              FETCH BBP_AUTOMATION                                      
               INTO :BH-ACCOUNT-NO                                      
                   ,:BH-PYMT-PRIORITY-LVL                               
                   ,:BH-ITEM-ID                                         
                   ,:BH-BUD-HIST-SEQ-NO                                 
                   ,:BH-AMT-MO-PYMT                                     
                   ,:BH-DATE-PYMT-STRT :WS-DATE-PYMT-STRT-NULL          
                   ,:BH-UTILITY-BALANCE                                 
                   ,:BH-BALANCE-FORWARD                                 
                   ,:BH-EPP-ESTIMATE                                    
                   ,:BH-EPP-MTHS-RMNG-QT                                
                   ,:BH-METHOD-OF-ESTIMATE                              
                   ,:BH-REMARKS                                         
                   ,:BH-BUDG-BILL-PREV-AMT                              
                   ,:AT-COMPANY-NO                                      
                   ,:AT-BILL-CYCLE                                      
                   ,:AT-CUSTOMER-NO                                     
                   ,:AT-ADDRESS-ID                                      
                   ,:AT-LOCAL-OFFICE                                    
                   ,:AT-ADDRESS-FORMAT                                  
                   ,:AT-PREMISE-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              IF SQLCODE EQUAL NOT-FOUND                                
                 MOVE 'Y'                   TO   WS-NO-MORE-RECORDS     
              END-IF                                                    
           ELSE                                                         
              DISPLAY '*********************************************'   
              DISPLAY '* PCSCA267 PROCESSING ERROR                 *'   
              DISPLAY '* ABEND IN 7010-FETCH-BBP-AUTOMTN-CSR       *'   
              DISPLAY '* BBP_AUTOMATION FETCH ERROR                *'   
              DISPLAY '* SUCCESSFULLY PROCESSED ACCOUNT PRIOR TO   *'   
              DISPLAY '* THE ABEND.                                *'   
              DISPLAY '* ACCOUNT NO          = ' BH-ACCOUNT-NO          
              DISPLAY '* WS-DATE-05-DAYS-AGO = ' WS-DATE-05-DAYS-AGO    
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                     *'   
              DISPLAY '*********************************************'   
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7020-CLOSE-BBP-AUTOMTN-CSR                                     *        
      ******************************************************************        
      *                                                                         
       7020-CLOSE-BBP-AUTOMTN-CSR.                                      
      *                                                                         
           EXEC SQL                                                     
              CLOSE BBP_AUTOMATION                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*********************************************'   
              DISPLAY '* PCSCA267 PROCESSING ERROR                 *'   
              DISPLAY '* ABEND IN 7020-CLOSE-BBP-AUTOMTN-CSR       *'   
              DISPLAY '* BBP_AUTOMATION CLOSE ERROR                *'   
              DISPLAY '* WS-DATE-05-DAYS-AGO = ' WS-DATE-05-DAYS-AGO    
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                     *'   
              DISPLAY '*********************************************'   
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
P00599******************************************************************        
P00599* 7200-SELECT-DELINQ-VALUE                                       *        
P00599* SELECTS THE DELINQUENCY VALUE FOR THE GIVEN DELINQ CODE        *        
P00599******************************************************************        
P00599 7200-SELECT-DELINQ-VALUE.                                        
P00599*                                                                         
P00599     EXEC SQL                                                     
P00599        SELECT DELINQ_VALUE                                       
P00599          INTO :C8-DELINQ-VALUE                                   
P00599          FROM CSS_DELINQUENCY                                    
P00599         WHERE DELINQ_CD  = :C8-DELINQ-CD                         
P00599           AND COMPANY_NO = :C8-COMPANY-NO                        
P00599                                                      
P00599     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00599*                                                                         
P00599     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00599     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00599        CONTINUE                                                  
P00599     ELSE                                                         
P00599        DISPLAY '********** PCSCA267 ABORT **************'        
P00599        DISPLAY '* 7200-SELECT-DELINQ-VALUE             *'        
P00599        DISPLAY '* DELINQ CD ', C8-DELINQ-CD                      
P00599        DISPLAY '* COMPANY NO', C8-COMPANY-NO                     
P00599        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
P00599        DISPLAY '* PROGRAM ABORTING...                  *'        
P00599        DISPLAY '********** PCSCA267 ABORT **************'        
P00599        PERFORM 9900-ABEND THRU 9900-EXIT                         
P00599     END-IF.                                                      
P00599*                                                                         
P00599 7200-EXIT.                                                       
P00599     EXIT.                                                        
P00599*                                                                         
      ******************************************************************        
      * 7510-SELECT-REG-PROFILE                                        *        
      ******************************************************************        
      *                                                                         
       7510-SELECT-REG-PROFILE.                                         
      *                                                                         
           EXEC SQL                                                     
               SELECT LR.REG_GROUP_CD                                   
                 INTO :LR-REG-GROUP-CD                                  
                 FROM CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                  
                WHERE LR.ACCOUNT_NO = :LR-ACCOUNT-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LR.REG_GROUP_CD                                           
MFA-TR*          INTO :LR-REG-GROUP-CD                                          
MFA-TR*          FROM CSS_REG_PROFILE LR                                        
MFA-TR*         WHERE LR.ACCOUNT_NO = :LR-ACCOUNT-NO                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7510                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
      *                                                                         
           EVALUATE SQLCODE                                             
           WHEN SUCCESSFUL-CALL                                         
              CONTINUE                                                  
           WHEN NOT-FOUND                                               
              MOVE SPACES                   TO LR-REG-GROUP-CD          
           WHEN OTHER                                                   
              DISPLAY '***************************************'         
              DISPLAY '* PCSCA267 PROCESSING ERROR           *'         
              DISPLAY '* ABEND IN 7510-SELECT-REG-PROFILE    *'         
              DISPLAY '* ACCOUNT NO      = ' LR-ACCOUNT-NO              
              DISPLAY '* SQL RETURN CODE = ' WS-DISPLAY-SQLCODE         
              DISPLAY '* PROCESSING TERMINATED               *'         
              DISPLAY '***************************************'         
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-EVALUATE.                                                
      *                                                                         
       7510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7530-GET-CUR-TIMESTAMP                                         *        
      ******************************************************************        
      *                                                                         
       7530-GET-CUR-TIMESTAMP.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP             
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '* PCSCA267 PROCESSING ERROR            *'        
              DISPLAY '* ABEND IN 7530-GET-CUR-TIMESTAMP      *'        
              DISPLAY '* SQL RETURN CODE = ' WS-DISPLAY-SQLCODE         
              DISPLAY '* PROCESSING TERMINATED                *'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7530-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7600-START-FCJ01                                               *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7600-START-FCJ01                                               *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 8200-INSERT-BUDGET-HIST                                        *        
      ******************************************************************        
      *                                                                         
       8200-INSERT-BUDGET-HIST.                                         
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_BUDGET_HIST                               
                    (                                                   
                     ACCOUNT_NO                                         
                    ,PYMT_PRIORITY_LVL                                  
                    ,ITEM_ID                                            
                    ,BUD_HIST_SEQ_NO                                    
                    ,AMT_MO_PYMT                                        
                    ,DATE_PYMT_STRT                                     
                    ,UTILITY_BALANCE                                    
                    ,BALANCE_FORWARD                                    
                    ,EPP_ESTIMATE                                       
                    ,EPP_MTHS_RMNG_QT                                   
                    ,METHOD_OF_ESTIMATE                                 
                    ,CHANGE_REASON                                      
                    ,LAST_UPDATE_TS                                     
                    ,REMARKS                                            
                    ,BUDG_BILL_PREV_AMT                                 
                    )                                                   
               VALUES                                                   
                    (                                                   
                     :BH-ACCOUNT-NO                                     
                    ,:BH-PYMT-PRIORITY-LVL                              
                    ,:BH-ITEM-ID                                        
                    ,CIS.CHAR2TIMESTAMP(:BH-BUD-HIST-SEQ-NO)                    
                    ,:BH-AMT-MO-PYMT                                    
                    ,IIF(TRY_CONVERT(DATE, :BH-DATE-PYMT-STRT 
                                           :WS-DATE-PYMT-STRT-NULL
              ) IS NULL OR (PATINDEX('%.%', :BH-DATE-PYMT-STRT 
                                                :WS-DATE-PYMT-STRT-NULL
              ) <> 0) OR (LEN(:BH-DATE-PYMT-STRT 
                                                :WS-DATE-PYMT-STRT-NULL
              ) <> 10), CIS.CHAR2DATE(:BH-DATE-PYMT-STRT 
                                                :WS-DATE-PYMT-STRT-NULL
              ), CONVERT(DATE, :BH-DATE-PYMT-STRT 
                                                :WS-DATE-PYMT-STRT-NULL
              ) )         
                    ,:BH-UTILITY-BALANCE                                
                    ,:BH-BALANCE-FORWARD                                
                    ,:BH-EPP-ESTIMATE                                   
                    ,:BH-EPP-MTHS-RMNG-QT                               
                    ,:BH-METHOD-OF-ESTIMATE                             
                    ,:BH-CHANGE-REASON                                  
                    ,CIS.CHAR2TIMESTAMP(:BH-LAST-UPDATE-TS)                     
                    ,:BH-REMARKS                                        
                    ,:BH-BUDG-BILL-PREV-AMT                             
                    )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_BUDGET_HIST                                       
MFA-TR*             (                                                           
MFA-TR*              ACCOUNT_NO                                                 
MFA-TR*             ,PYMT_PRIORITY_LVL                                          
MFA-TR*             ,ITEM_ID                                                    
MFA-TR*             ,BUD_HIST_SEQ_NO                                            
MFA-TR*             ,AMT_MO_PYMT                                                
MFA-TR*             ,DATE_PYMT_STRT                                             
MFA-TR*             ,UTILITY_BALANCE                                            
MFA-TR*             ,BALANCE_FORWARD                                            
MFA-TR*             ,EPP_ESTIMATE                                               
MFA-TR*             ,EPP_MTHS_RMNG_QT                                           
MFA-TR*             ,METHOD_OF_ESTIMATE                                         
MFA-TR*             ,CHANGE_REASON                                              
MFA-TR*             ,LAST_UPDATE_TS                                             
MFA-TR*             ,REMARKS                                                    
MFA-TR*             ,BUDG_BILL_PREV_AMT                                         
MFA-TR*             )                                                           
MFA-TR*        VALUES                                                           
MFA-TR*             (                                                           
MFA-TR*              :BH-ACCOUNT-NO                                             
MFA-TR*             ,:BH-PYMT-PRIORITY-LVL                                      
MFA-TR*             ,:BH-ITEM-ID                                                
MFA-TR*             ,:BH-BUD-HIST-SEQ-NO                                        
MFA-TR*             ,:BH-AMT-MO-PYMT                                            
MFA-TR*             ,:BH-DATE-PYMT-STRT :WS-DATE-PYMT-STRT-NULL                 
MFA-TR*             ,:BH-UTILITY-BALANCE                                        
MFA-TR*             ,:BH-BALANCE-FORWARD                                        
MFA-TR*             ,:BH-EPP-ESTIMATE                                           
MFA-TR*             ,:BH-EPP-MTHS-RMNG-QT                                       
MFA-TR*             ,:BH-METHOD-OF-ESTIMATE                                     
MFA-TR*             ,:BH-CHANGE-REASON                                          
MFA-TR*             ,:BH-LAST-UPDATE-TS                                         
MFA-TR*             ,:BH-REMARKS                                                
MFA-TR*             ,:BH-BUDG-BILL-PREV-AMT                                     
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE.      
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********************************************'    
              DISPLAY '* PCSCA267 PROCESSING ERROR                *'    
              DISPLAY '* ABEND IN 8200-INSERT-BUDGET-HIST         *'    
              DISPLAY '* ACCOUNT NO        = ' BH-ACCOUNT-NO            
              DISPLAY '* PYMT PRIORITY LVL = ' BH-PYMT-PRIORITY-LVL     
              DISPLAY '* ITEM ID           = ' BH-ITEM-ID               
              DISPLAY '* BUD HIST SEQ NO   = ' BH-BUD-HIST-SEQ-NO       
              DISPLAY '* SQL RETURN CODE   = ' WS-DISPLAY-SQLCODE       
              DISPLAY '* PROCESSING TERMINATED                    *'    
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9000-TERMINATE                                                 *        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00599******************************************************************        
P00599* 9900-SQL-ERROR-ROUTINE.                                        *        
P00599******************************************************************        
P00599*                                                                         
P00599 9900-SQL-ERROR-ROUTINE.                                          
P00599*                                                                         
P00599*    MOVE '9900'                      TO ACTIVE-PARAGRAPH.                
P00599     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE,   
P00599                                         RS-RETURN-CODE,          
P00599                                         WS-DISPLAY-SQLCODE.      
P00599     DISPLAY ' '                                                  
P00599     DISPLAY '**********************************************'     
P00599     DISPLAY '***** 9900-SQL-ERROR-ROUTINE            ******'     
P00599     DISPLAY '**********************************************'     
P00599     DISPLAY ' '                                                  
P00599     DISPLAY 'ACCT NO           = ' AT-ACCOUNT-NO                 
P00599     DISPLAY 'ACTIVE-PARAGRAPH  = ' ACTIVE-PARAGRAPH              
P00599     DISPLAY 'ABEND FUNCTION    = ' ABEND-FUNCTION                
P00599     DISPLAY 'TABLE-1           = ' TABLE-1                       
P00599     DISPLAY 'TABLE-ELEMENT-1   = ' TABLE-ELEMENT-1               
P00599     DISPLAY 'HOSTVAR-ELEMENT-1 = ' HOSTVAR-ELEMENT-1             
P00599     DISPLAY 'TABLE-ELEMENT-2   = ' TABLE-ELEMENT-2               
P00599     DISPLAY 'HOSTVAR-ELEMENT-2 = ' HOSTVAR-ELEMENT-2             
P00599     DISPLAY 'TABLE-ELEMENT-3   = ' TABLE-ELEMENT-3               
P00599     DISPLAY 'HOSTVAR-ELEMENT-3 = ' HOSTVAR-ELEMENT-3             
P00599     DISPLAY 'TABLE-ELEMENT-4   = ' TABLE-ELEMENT-4               
P00599     DISPLAY 'HOSTVAR-ELEMENT-4 = ' HOSTVAR-ELEMENT-4             
P00599     DISPLAY 'SQLCODE = ' WS-DISPLAY-SQLCODE                      
P00599     DISPLAY '**********************************************'     
P00599     PERFORM 9900-ABEND                    THRU 9900-EXIT.        
P00599*                                                                         
P00599***************************************************************           
P00599*  9700-PROCESS-ABEND.                                                    
P00599***************************************************************           
P00599 COPY CPD0023B.                                                           
P00599*                                                                         
      ******************************************************************        
      * 9900-ABEND                                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD09900                                                  
           END-EXEC.                                                            
      *                                                                         
