       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA262.                                        
       AUTHOR.         VENKAT VUDDANDAPU.                               
       DATE-WRITTEN.   JUNE 2007.                                       
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRIC & GAS                 **          
      **                                                            **          
      ****************************************************************          
      **                  P R O G R A M S U M M A R Y               **          
      **                                                            **          
      **                                                            **          
      **             F U N C T I O N A L   D E S C R I P T I O N    **          
      **                             O F   M O D U LE               **          
      **                                                            **          
      **  PURPOSE : WHITE CROSS PLUS MONTHLY REPORT.                **          
      **                                                            **          
      **                                                            **          
      ****************************************************************          
      **                                                            **          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      **   DATE     INITIALS   REASON                               **          
      ** --------   --------   ---------------------------------    **          
      ** 06/01/07   VV94890    CML#32547 : NEW CODE                 **          
      ** 18/03/08   CVNS       CML#32547 : REMOVED THE DATE CHECK   **          
      **            CHENNAI                FROM MAIN CURSOR TO      **          
      **                                   EXTRACT ALL ROWS W/O ANY **          
      **                                   DATE CONDITION.          **          
      ** 02/02/16   MS7M727    REMOVED UNUSED COPYBOOK AND ADDED    **          
      **                       STATUS_CD = 'A'IN CURSOR             **          
ACT052** 02/15/16   BD09555    CONVERT REPORT TO .CSV FILE          **          
      ****************************************************************          
                                                                        
       ENVIRONMENT DIVISION.                                            
                                                                        
       CONFIGURATION SECTION.                                           
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
       COPY CSSCA262.                                                           
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
ACT052 FD  FCSCA262-FILE                                                
ACT052     BLOCK CONTAINS 0 RECORDS                                     
ACT052     RECORDING MODE IS V                                          
ACT052     LABEL RECORDS ARE STANDARD.                                  
       01  FCSCA262-RECORD.                                             
           05  FILLER                 PIC X                             
                                      OCCURS 1 TO 200 TIMES             
                                      DEPENDING ON WS-RECORD-LENGTH.    
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA262'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05 PROGRAM-NAME            PIC X(08) VALUE 'PCSCA262'.       
           05 WS-PGRMNAME             PIC X(08) VALUE 'PCSCA262'.       
           05 WS-CURRENT-DATE         PIC X(10) VALUE SPACES.           
           05 WS-CURRENT-TS           PIC X(26) VALUE SPACES.           
           05 WS-CUST-NAME            PIC X(35) VALUE SPACES.           
           05 WS-CTY-ST-ZIP           PIC X(32)  VALUE SPACES.          
           05 WS-PATIENT-NAME         PIC X(35) VALUE SPACES.           
           05 WS-HCP-NAME             PIC X(35) VALUE SPACES.           
           05 WS-COMMON-DATE          PIC X(10) VALUE SPACES.           
           05 WS-ACCOUNT-NO           PIC 9B9999B9999B9999.             
           05 WS-PHONE-NO-OUT.                                          
              10 WS-PHONE-NO-EDITED      PIC 999B999B9999.              
           05 WS-PHONE-NO-NUM         PIC 9(10).                        
           05 WS-FRP262-REC-CNTR      PIC S9(07) COMP VALUE ZERO.       
ACT052     05 WS-OUTPUT-RECORD        PIC X(200) VALUE SPACES.          
ACT052     05 WS-RECORD-LENGTH        PIC S9(04) COMP VALUE ZERO.       
ACT052     05 K                       PIC S9(04) COMP VALUE ZERO.       
ACT052     05 WS-HEADER-LINE.                                           
ACT052        10 FILLER               PIC X(52)  VALUE                  
ACT052     'STATUS,ACCOUNT #,CUSTOMER NAME,PATIENT NAME,PHONE #,'.      
ACT052        10 FILLER               PIC X(40)  VALUE                  
ACT052     'RELATION,EXP DATE,HCP NAME,MED COND CODE'.                  
                                                                        
       01  WS-INPUT-DATA-R8.                                            
           05 FILLER                  PIC X(14) VALUE 'LAST RUN DATE='. 
           05 WS-PGM-LAST-RUN-DATE    PIC X(10) VALUE SPACES.           
           05 FILLER                  PIC X(40) VALUE SPACES.           
                                                                        
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE          PIC S9(04) COMP VALUE 0.         
           05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05 WS-NULL-IND             PIC S9(04) COMP VALUE +0.         
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-NO-MORE-RECORDS     PIC X(01) VALUE 'N'.              
               88 NO-MORE-RECORDS               VALUE 'Y'.              
           05  WS-FCSCA262-STATUS     PIC X(02).                        
               88 FCSCA262-SUCCESSFUL           VALUE '00'.             
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-Y                   PIC X(01) VALUE 'Y'.              
           05  WS-N                   PIC X(01) VALUE 'N'.              
           05  WS-811                 PIC S9(9) VALUE -811 COMP.        
                                                                        
                                                                        
       COPY FIOCA262.                                                           
      *****************************************************************         
      *  CWS00038  JOB PARM ROUTINE                                   *         
      *****************************************************************         
       COPY CWS00038.                                                           
                                                                        
      *****************************************************************         
      *  CWS00010  CONTAINS DB2 ABEND VARIABLES                       *         
      *****************************************************************         
       COPY CWS00010.                                                           
      *****************************************************************         
      *  CWS00011  CONTAINS SPACE COMPRESSION VARIABLES               *         
      *****************************************************************         
ACT052*    COPY CWS00011.                                                       
ACT052 01  WS-11-TABLES.                                                
ACT052*                                                                         
ACT052      05  WS-EMB-INPUT.                                           
ACT052          10  WS-EMB-CHAR         PIC X(01)                       
ACT052                                  OCCURS 200 TIMES                
ACT052                                  INDEXED BY WS-EMB-INDX.         
ACT052      05  WS-EMB-TBL-LENG         PIC S9(03) VALUE +200.          
ACT052      05  WS-EMB-LENG             PIC S9(03) VALUE ZERO.          
ACT052      05  WS-EMB-LAST-CHAR        PIC X(01).                      
ACT052      05  WS-CMP-TABLE.                                           
ACT052          10  WS-CMP-CHAR         PIC X(01)                       
ACT052                                  OCCURS 200 TIMES                
ACT052                                  INDEXED BY WS-CMP-INDX.         
                                                                        
      *****************************************************************         
      *  COPY BOOK FOR CPD00074                                       *         
      *****************************************************************         
       COPY CWS00074.                                                           
                                                                        
      *****************************************************************         
      * IO AREA FOR GETTING THE REVENUE MONTH FROM CSS_JOB_PARM       *         
      *****************************************************************         
       COPY FIOJC01.                                                            
                                                                        
      *****************************************************************         
      * WORKING STORAGE FOR CPD09900                                  *         
      *****************************************************************         
       COPY CWS09900.                                                           
                                                                        
      *****************************************************************         
      *  COPYBOOK WITH COMMON SQL VARIABLES                           *         
      *****************************************************************         
       COPY CWS00303.                                                           
                                                                        
      *****************************************************************         
      *  COPYBOOK FOR CPD00039                                        *         
      *****************************************************************         
       COPY CWS00039.                                                           
      *****************************************************************         
      *  COPYBOOK WITH JOBS FILE/TABLE DEFINITIONS                    *         
      *****************************************************************         
       COPY FIOCA00.                                                            
                                                                        
      *****************************************************************         
      *    DECLARATION FOR SQL COMMAND AREA                           *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_ACCOUNT, AT                                    *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    DCLGEN FOR CSS_JOB_PARM                                    *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_NAME, DQ                                       *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_ADDR_FORMATTED, DY                             *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_ZIP_CODE, A4                                   *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_CUST_ADD_XREF, DZ                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBCSADRX                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_ADDR_FREEFORM, DM                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBADRFRE                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_ACCT_MISC_INFO, TA                             *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBATMISC                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_NAME_ACC_XREF, HT                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_WH_CROSS_PLUS, WO                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBWCPLUS                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_PHYSICIAN, PY                                  *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBPHYSN                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CURSOR DECLARATIONS.                                       *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE WCP_ACCT_CSR CURSOR FOR                           
                 SELECT WO.STATUS_CD                                    
                       ,WO.ACCOUNT_NO                                   
                       ,WO.NAME_ID                                      
                       ,WO.PATIENT_PH_NO                                
                       ,WO.PATIENT_RELATION                             
                       ,WO.EXPIRATION_DT                                
                       ,WO.PHYSICIAN_ID                                 
                       ,WO.MED_COND_CODE                                
                   FROM CSS_WH_CROSS_PLUS WO WITH(READUNCOMMITTED)              
                       ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                  WHERE WO.ACCOUNT_NO  =  AT.ACCOUNT_NO                 
                    AND WO.STATUS_CD   =  'A'                           
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE WCP_ACCT_CSR CURSOR FOR                                   
MFA-TR*          SELECT WO.STATUS_CD                                            
MFA-TR*                ,WO.ACCOUNT_NO                                           
MFA-TR*                ,WO.NAME_ID                                              
MFA-TR*                ,WO.PATIENT_PH_NO                                        
MFA-TR*                ,WO.PATIENT_RELATION                                     
MFA-TR*                ,WO.EXPIRATION_DT                                        
MFA-TR*                ,WO.PHYSICIAN_ID                                         
MFA-TR*                ,WO.MED_COND_CODE                                        
MFA-TR*            FROM CSS_WH_CROSS_PLUS WO                                    
MFA-TR*                ,CSS_ACCOUNT AT                                          
MFA-TR*           WHERE WO.ACCOUNT_NO  =  AT.ACCOUNT_NO                         
MFA-TR*             AND WO.STATUS_CD   =  'A'                                   
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       PROCEDURE DIVISION.                                              
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-WCP-RPT        THRU 1000-EXIT.          
           PERFORM 5400-UPDATE-LAST-RUN-TS     THRU 5400-EXIT.          
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 0100-INITIALIZATION.                                          *         
      *****************************************************************         
       0100-INITIALIZATION.                                             
                                                                        
           OPEN OUTPUT FCSCA262-FILE.                                   
                                                                        
           IF FCSCA262-SUCCESSFUL                                       
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '********** PCSCA262 ABORT **************'        
              DISPLAY '*       0100-INITIALIZATION            *'        
              DISPLAY '*    ERROR OPENING FIOCA262 FILE       *'        
              DISPLAY '* FILE STATUS    : ' WS-FCSCA262-STATUS          
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA262 ABORT **************'        
              MOVE 12 TO RETURN-CODE                                    
              STOP RUN                                                  
           END-IF.                                                      
                                                                        
           MOVE WS-PGRMNAME                  TO G6-PROGRAM-NAME.        
           MOVE 'DATE'                       TO G6-CMND-CODE.           
                                                                        
           PERFORM 6251-GET-FJC01-DATE       THRU 6251-EXIT.            
           MOVE WS-INPUT-RUN-DATE            TO WS-COMMON-DATE          
                                                                        
           IF  COMMON-DATE-NEEDED                                       
               PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT        
               MOVE 'PCSCA262'               TO WS-PGRMNAME             
               MOVE WS-FCA00-COMMON-DATE     TO WS-COMMON-DATE          
           END-IF.                                                      
                                                                        
           MOVE PROGRAM-NAME                 TO G6-PROGRAM-NAME.        
           MOVE '01'                         TO G6-COMPANY-NO.          
           MOVE 'PARM'                       TO G6-CMND-CODE.           
           MOVE +10                          TO G6-SEQ-NO.              
                                                                        
           PERFORM 7000-GET-CURRENT-DATE     THRU 7000-EXIT.            
           PERFORM 7050-SELECT-LAST-RUN-DATE THRU 7050-EXIT.            
                                                                        
           MOVE G6-PARM-DATA                 TO WS-INPUT-DATA-R8.       
                                                                        
           IF WS-PGM-LAST-RUN-DATE > WS-CURRENT-DATE                    
              DISPLAY '********** PCSCA262 ABORT **************'        
              DISPLAY '*       0100-INITIALIZATION            *'        
              DISPLAY '* PROGRAM LAST RUN TIMESTAMP SHOULD BE *'        
              DISPLAY '*     LESS THAN CURRENT TIMESTAMP      *'        
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA262 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
ACT052     MOVE SPACES TO FCSCA262-RECORD.                              
ACT052     INITIALIZE WS-OUTPUT-RECORD    WS-EMB-INPUT                  
ACT052                WS-CMP-TABLE        K.                            
ACT052     MOVE WS-HEADER-LINE TO WS-OUTPUT-RECORD.                     
ACT052     INSPECT FUNCTION REVERSE (WS-OUTPUT-RECORD)                  
ACT052         TALLYING K FOR LEADING SPACES                            
ACT052     COMPUTE WS-RECORD-LENGTH = 200 - K.                          
ACT052     MOVE WS-OUTPUT-RECORD TO  FCSCA262-RECORD.                   
           WRITE FCSCA262-RECORD.                                       
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 1000-PROCESS-WCP-RPT.                                         *         
      *****************************************************************         
       1000-PROCESS-WCP-RPT.                                            
                                                                        
           PERFORM 7500-OPEN-WCP-ACCT-CSR      THRU 7500-EXIT.          
           PERFORM 7510-FETCH-WCP-ACCT-CSR     THRU 7510-EXIT.          
           IF NO-MORE-RECORDS                                           
              DISPLAY 'NO OUTPUT TO PROCESS'                            
           ELSE                                                         
              PERFORM 5000-WCP-RPT-DETAILS     THRU  5000-EXIT          
                                               UNTIL NO-MORE-RECORDS    
           END-IF.                                                      
                                                                        
           PERFORM 7520-CLOSE-WCP-ACCT-CSR     THRU 7520-EXIT.          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 5000-WCP-RPT-DETAILS.                                         *         
      *****************************************************************         
       5000-WCP-RPT-DETAILS.                                            
                                                                        
      * CUSTOMER NAME                                                           
           MOVE WO-ACCOUNT-NO             TO   AT-ACCOUNT-NO            
           PERFORM 7200-SELECT-ADDR-ID    THRU 7200-EXIT                
           PERFORM 4000-MAIL-NAME-ADDRESS THRU 4000-EXIT                
           MOVE WS-CUSTOMER-NAME          TO   WS-CUST-NAME             
           MOVE WS-PR-ADDR-CITY-STATE     TO   WS-CTY-ST-ZIP            
      * PATIENT NAME                                                            
           MOVE ZEROES                 TO DQ-NAME-ID                    
           MOVE WO-NAME-ID             TO DQ-NAME-ID                    
           IF DQ-NAME-ID > 0                                            
              PERFORM 7100-SELECT-NAME THRU 7100-EXIT                   
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 STRING DQ-FIRST-NAME  DELIMITED BY SIZE                
                        DQ-LAST-NAME   DELIMITED BY SIZE                
                                       INTO WS-PATIENT-NAME             
              END-IF                                                    
              MOVE SPACES              TO WS-EMB-INPUT                  
              MOVE SPACES              TO WS-CMP-TABLE                  
              MOVE WS-PATIENT-NAME     TO WS-EMB-INPUT                  
              MOVE 35                  TO WS-EMB-LENG                   
              PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT        
              MOVE WS-CMP-TABLE        TO WS-PATIENT-NAME               
           END-IF                                                       
      * HCP NAME                                                                
           MOVE    ZEROES              TO PY-PHYSICIAN-ID               
           MOVE    ZEROES              TO DQ-NAME-ID                    
           MOVE    WO-PHYSICIAN-ID     TO PY-PHYSICIAN-ID               
           IF WO-PHYSICIAN-ID > 0                                       
              PERFORM 7150-PY-SELECT-NAME-ID THRU 7150-EXIT             
              MOVE    PY-NAME-ID       TO DQ-NAME-ID                    
              MOVE    SPACES           TO DQ-FIRST-NAME                 
              MOVE    SPACES           TO DQ-LAST-NAME                  
              PERFORM 7100-SELECT-NAME THRU 7100-EXIT                   
                                                                        
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 STRING DQ-FIRST-NAME DELIMITED BY SIZE                 
                        DQ-LAST-NAME  DELIMITED BY SIZE                 
                                      INTO WS-HCP-NAME                  
              END-IF                                                    
              MOVE SPACES              TO WS-EMB-INPUT                  
              MOVE SPACES              TO WS-CMP-TABLE                  
              MOVE WS-HCP-NAME         TO WS-EMB-INPUT                  
              MOVE 35                  TO WS-EMB-LENG                   
              PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT        
              MOVE WS-CMP-TABLE        TO WS-HCP-NAME                   
           END-IF                                                       
      *                                                                         
           PERFORM 5100-MOVE-FILE-DETAILS THRU 5100-EXIT                
           PERFORM 8900-WRITE-OUTPUT      THRU 8900-EXIT                
           INITIALIZE        WO-ACCOUNT-NO                              
                             AT-ADDRESS-ID                              
           MOVE SPACES                 TO WS-CUST-NAME                  
           MOVE SPACES                 TO WS-PATIENT-NAME               
           MOVE SPACES                 TO WS-HCP-NAME                   
           MOVE SPACES                 TO WS-CTY-ST-ZIP                 
           PERFORM 7510-FETCH-WCP-ACCT-CSR THRU 7510-EXIT.              
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 5100-MOVE-FILE-DETAILS.                                       *         
      *****************************************************************         
       5100-MOVE-FILE-DETAILS.                                          
                                                                        
           INITIALIZE E-FCA262.                                         
                                                                        
           MOVE WO-STATUS-CD               TO E-FCA262-STATUS.          
           MOVE WO-ACCOUNT-NO              TO E-FCA262-ACCOUNT-NO       
                                              WS-ACCOUNT-NO.            
           INSPECT WS-ACCOUNT-NO REPLACING ALL ' ' BY '-'.              
           MOVE WS-CUST-NAME               TO E-FCA262-CUST-NAME.       
                                                                        
           MOVE WS-PATIENT-NAME            TO E-FCA262-PATIENT-NAME.    
           IF WO-PATIENT-PH-NO NUMERIC                                  
               MOVE WO-PATIENT-PH-NO       TO WS-PHONE-NO-NUM           
               MOVE WS-PHONE-NO-NUM        TO WS-PHONE-NO-EDITED        
           ELSE                                                         
               MOVE WO-PATIENT-PH-NO       TO WS-PHONE-NO-OUT           
           END-IF.                                                      
           MOVE WO-PATIENT-RELATION        TO E-FCA262-RELATION.        
                                                                        
           MOVE WO-EXPIRATION-DT           TO E-FCA262-EXPIRATION-DT.   
           MOVE WS-HCP-NAME                TO E-FCA262-HCP-NAME.        
           MOVE WO-MED-COND-CODE           TO E-FCA262-MED-COND-CODE.   
           MOVE WS-CTY-ST-ZIP              TO E-FCA262-CITY-ST.         
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 5400-WRITE-END-CONTROLS.                                      *         
      *****************************************************************         
        5400-UPDATE-LAST-RUN-TS.                                        
            INITIALIZE G6-PARM-DATA.                                    
            MOVE WS-CURRENT-DATE          TO WS-PGM-LAST-RUN-DATE.      
            MOVE WS-INPUT-DATA-R8         TO G6-PARM-DATA.              
                                                                        
            MOVE PROGRAM-NAME             TO G6-PROGRAM-NAME.           
            MOVE 'PARM'                   TO G6-CMND-CODE.              
            MOVE +10                      TO G6-SEQ-NO.                 
            MOVE '01'                     TO G6-COMPANY-NO.             
                                                                        
            PERFORM 8100-UPDATE-LAST-RUN-DATE   THRU 8100-EXIT.         
                                                                        
        5400-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 7000-GET-CURRENT-DATE.                                        *         
      *     TODAYS DATE                                               *         
      *****************************************************************         
       7000-GET-CURRENT-DATE.                                           
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET  :WS-CURRENT-DATE = CURRENT DATE                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA262 ABORT **************'        
              DISPLAY '*       7000-GET-CURRENT-DATE            *'      
              DISPLAY '* CURRENT DATE   : ' WS-CURRENT-DATE             
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA262 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7050-SELECT-LAST-RUN-DATE.                                    *         
      *****************************************************************         
       7050-SELECT-LAST-RUN-DATE.                                       
                                                                        
           EXEC SQL                                                     
               SELECT G6.PROGRAM_NAME                                   
                     ,G6.COMPANY_NO                                     
                     ,G6.CMND_CODE                                      
                     ,G6.SEQ_NO                                         
                     ,G6.STATUS                                         
                     ,G6.PARM_DATA                                      
                 INTO :G6-PROGRAM-NAME                                  
                     ,:G6-COMPANY-NO                                    
                     ,:G6-CMND-CODE                                     
                     ,:G6-SEQ-NO                                        
                     ,:G6-STATUS                                        
                     ,:G6-PARM-DATA                                     
                 FROM CSS_JOB_PARM G6                                   
                WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                
                  AND G6.COMPANY_NO   = :G6-COMPANY-NO                  
                  AND G6.CMND_CODE    = :G6-CMND-CODE                   
                  AND G6.SEQ_NO       = :G6-SEQ-NO                      
                  AND G6.STATUS       = 'A'                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA262 ABORT **************'        
              DISPLAY '*     7050-SELECT-LAST-RUN-DATE        *'        
              DISPLAY '* PROGRAM NAME   : ' G6-PROGRAM-NAME             
              DISPLAY '* COMPANY NO     : ' G6-COMPANY-NO               
              DISPLAY '* CMD CODE       : ' G6-CMND-CODE                
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA262 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-SELECT-NAME.                                              *        
      *    1.  SELECT ALL VALUES FROM CSS_NAME.                        *        
      ******************************************************************        
       7100-SELECT-NAME.                                                
                                                                        
           EXEC SQL                                                     
              SELECT FIRST_NAME                                         
                    ,LAST_NAME                                          
              INTO   :DQ-FIRST-NAME                                     
                    ,:DQ-LAST-NAME                                      
              FROM   CSS_NAME                                           
              WHERE  NAME_ID = :DQ-NAME-ID                              
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA262 ABORT **************'        
              DISPLAY '*     7100-SELECT-NAME        *'                 
              DISPLAY '* NAME ID :' DQ-NAME-ID                          
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA262 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 7150-PY-SELECT-NAME-ID.                                       *         
      *****************************************************************         
       7150-PY-SELECT-NAME-ID.                                          
                                                                        
           EXEC SQL                                                     
               SELECT PY.NAME_ID                                        
                 INTO :PY-NAME-ID                                       
                 FROM CSS_PHYSICIAN PY                                  
                WHERE PY.PHYSICIAN_ID = :PY-PHYSICIAN-ID                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA262 ABORT **************'        
              DISPLAY '*     7150-PY-SELECT-NAME-ID   *'                
              DISPLAY '* PHYSICIAN ID   : ' PY-PHYSICIAN-ID             
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA262 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 7200-SELECT-ADDR-ID.                                          *         
      *****************************************************************         
       7200-SELECT-ADDR-ID.                                             
                                                                        
           EXEC SQL                                                     
               SELECT  ADDRESS_ID                                       
                 INTO  :AT-ADDRESS-ID                                   
                FROM   CSS_ACCOUNT                                      
                WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA262 ABORT **************'        
              DISPLAY '*     7200-SELECT-ADDR-ID  *'                    
              DISPLAY '* ADDRESS ID     : ' AT-ADDRESS-ID               
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA262 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 7500-OPEN-WCP-ACCT-CSR.                                       *         
      *****************************************************************         
       7500-OPEN-WCP-ACCT-CSR.                                          
                                                                        
           EXEC SQL                                                     
                OPEN WCP_ACCT_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA262 ABORT **************'        
              DISPLAY '*     7500-OPEN-WCP-ACCT-CSR           *'        
              DISPLAY '* COMMON DATE    : ' WS-INPUT-DATE               
              DISPLAY '* LAST RUN TS    : ' WS-PGM-LAST-RUN-DATE        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA262 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7510-FETCH-WCP-ACCT-CSR.                                      *         
      *****************************************************************         
       7510-FETCH-WCP-ACCT-CSR.                                         
                                                                        
           EXEC SQL                                                     
                FETCH WCP_ACCT_CSR                                      
                 INTO :WO-STATUS-CD                                     
                     ,:WO-ACCOUNT-NO                                    
                     ,:WO-NAME-ID                                       
                     ,:WO-PATIENT-PH-NO                                 
                     ,:WO-PATIENT-RELATION                              
                     ,:WO-EXPIRATION-DT :WS-NULL-IND                     
                     ,:WO-PHYSICIAN-ID                                  
                     ,:WO-MED-COND-CODE                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO    WS-ACTIVE-RETURN-CODE.   
           EVALUATE TRUE                                                
             WHEN WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL          
                  IF WS-NULL-IND < 0                                    
                     MOVE SPACES         TO    WO-EXPIRATION-DT         
                  END-IF                                                
             WHEN WS-ACTIVE-RETURN-CODE  EQUAL NOT-FOUND                
                  MOVE 'Y'               TO    WS-NO-MORE-RECORDS       
             WHEN OTHER                                                 
                  DISPLAY '********** PCSCA262 ABORT **************'    
                  DISPLAY '*     7510-FETCH-WCP-ACCT-CSR          *'    
                  DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE   
                  DISPLAY '* PROGRAM ABORTING...                  *'    
                  DISPLAY '***********PCSCA262 ABORT ***************'   
                  PERFORM 9900-ABEND               THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7520-CLOSE-WCP-ACCT-CSR.                                      *         
      *****************************************************************         
       7520-CLOSE-WCP-ACCT-CSR.                                         
                                                                        
           EXEC SQL                                                     
                CLOSE WCP_ACCT_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA262 ABORT **************'        
              DISPLAY '*      7520-CLOSE-WCP-ACCT-CSR         *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA262 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8100-UPDATE-LAST-RUN-DATE.                                    *         
      *****************************************************************         
       8100-UPDATE-LAST-RUN-DATE.                                       
                                                                        
           EXEC SQL                                                     
                UPDATE CSS_JOB_PARM                                     
                   SET PARM_DATA     = :G6-PARM-DATA                    
                 WHERE PROGRAM_NAME  = :G6-PROGRAM-NAME                 
                   AND CMND_CODE     = :G6-CMND-CODE                    
                   AND COMPANY_NO    = :G6-COMPANY-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA262 ABORT **************'        
              DISPLAY '*     8100-UPDATE-LAST-RUN-DATE        *'        
              DISPLAY '* PROGRAM NAME   : ' G6-PROGRAM-NAME             
              DISPLAY '* COMPANY NO     : ' G6-COMPANY-NO               
              DISPLAY '* CMD CODE       : ' G6-CMND-CODE                
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA262 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8900-WRITE-OUTPUT.                                            *         
      *****************************************************************         
       8900-WRITE-OUTPUT.                                               
ACT052     MOVE SPACES TO FCSCA262-RECORD.                              
ACT052     INITIALIZE WS-OUTPUT-RECORD    WS-EMB-INPUT                  
ACT052                WS-CMP-TABLE        K.                            
ACT052     INSPECT E-FCA262 REPLACING ALL ',' BY ' '.                   
ACT052     STRING E-FCA262-STATUS        ','                            
ACT052            WS-ACCOUNT-NO          ','                            
ACT052            E-FCA262-CUST-NAME     ','                            
ACT052            E-FCA262-PATIENT-NAME  ','                            
ACT052            WS-PHONE-NO-OUT        ','                            
ACT052            E-FCA262-RELATION      ','                            
ACT052            E-FCA262-EXPIRATION-DT ','                            
ACT052            E-FCA262-HCP-NAME      ','                            
ACT052            E-FCA262-MED-COND-CODE                                
ACT052                DELIMITED BY SIZE INTO WS-OUTPUT-RECORD.          
ACT052     MOVE WS-OUTPUT-RECORD    TO WS-EMB-INPUT                     
ACT052     MOVE 200                 TO WS-EMB-LENG                      
ACT052     PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT           
ACT052     MOVE WS-CMP-TABLE        TO WS-OUTPUT-RECORD.                
      *                                                                         
ACT052     INSPECT FUNCTION REVERSE (WS-OUTPUT-RECORD)                  
ACT052         TALLYING K FOR LEADING SPACES                            
ACT052     COMPUTE WS-RECORD-LENGTH = 200 - K.                          
ACT052     MOVE WS-OUTPUT-RECORD TO  FCSCA262-RECORD.                   
           WRITE FCSCA262-RECORD.                                       
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 9000-TERMINATE.                                               *         
      *****************************************************************         
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSCA262-FILE.                                         
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * CPD09900   THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE      *         
      * 9900-ABEND                                                    *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * 6010-REDUCE-EMBEDDED-SPACES.                                  *         
      *****************************************************************         
           EXEC SQL                                                             
                 INCLUDE CPD00004                                               
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * 4000-MAIL-NAME-ADDRESS.                                       *         
      *****************************************************************         
           EXEC SQL                                                             
                 INCLUDE CPD00074                                               
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * COPY BOOK TO GET COMMON DATE FROM JOB PARM                    *         
      *****************************************************************         
           COPY CPD00040.                                                       
      *****************************************************************         
      *  6251-GET-FJC01-DATE                                          *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE CPD00037                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *  7620-START-FCSJC01                                           *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE CPD00038                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *  7620-START-FCSCA00                                           *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9700-PROCESS-ABEND.                                                     
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD0023B                                                  
           END-EXEC.                                                            
                                                                        
