       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA260.                                        
       AUTHOR.         CVNS, CHENNAI.                                   
       DATE-WRITTEN.   MAY 2006.                                        
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRIC & GAS                 **          
      **                                                            **          
      ****************************************************************          
      **                  P R O G R A M S U M M A R Y               **  00100000
      **                                                            **  00110000
      **                                                            **  00120000
      **             F U N C T I O N A L   D E S C R I P T I O N    **  00130000
      **                             O F   M O D U LE               **  00140000
      **                                                            **  00150000
      **  PURPOSE :                                                 **  00160000
      **                                                            **  00170000
      **                                                            **  00192000
      ****************************************************************          
      **                                                            **          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      **   DATE     INITIALS   REASON                               **          
      ** --------   --------   ---------------------------------    **          
T32832** 01/12/06   CVNS,      NEW PROGRAM.                         **          
T32832**            CHENNAI                                         **          
T35024** 01/05/07   CVNS,      FIXED TO DISPLAY THE COMPANY TOTALS  **          
T35024**            CHENNAI    CORRECTLY.                           **          
T35434** 03/20/07   SP94986    REPLACE THE MODEL_SQL TO SET COMMANDS**          
C35671** 10/05/07   CVNS       NAME AND ADDRESS LENGTH CHG.         **          
      ****************************************************************          
                                                                        
       ENVIRONMENT DIVISION.                                            
                                                                        
       CONFIGURATION SECTION.                                           
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
       COPY CSSCA260.                                                           
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDCA260.                                                           
       COPY FIOCA260.                                                           
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA260'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05 PROGRAM-NAME            PIC X(08) VALUE 'PCSCA260'.       
           05 WS-PGRMNAME             PIC X(08) VALUE 'PCSCA260'.       
           05 WS-CURRENT-TS           PIC X(26) VALUE SPACES.           
C35671*    05 WS-THIRD-PTY-NAME       PIC X(35) VALUE SPACES.                   
C35671     05 WS-THIRD-PTY-NAME       PIC X(70) VALUE SPACES.           
           05 WS-COMMON-DATE          PIC X(10) VALUE SPACES.           
           05 WS-FRP260-REC-CNTR      PIC S9(07) COMP VALUE ZERO.       
T35024     05 WS-ACT-THD-PRTY-COUNT   PIC S9(09)  COMP VALUE ZERO.      
T35024     05 WS-TOTAL-THD-PRTY-ACCT  PIC S9(09)  COMP VALUE ZERO.      
                                                                        
       01  WS-INPUT-DATA-R8.                                            
           05 FILLER                  PIC X(14) VALUE 'LAST RUN DATE='. 
           05 WS-PGM-LAST-RUN-TS      PIC X(26) VALUE SPACES.           
           05 FILLER                  PIC X(40) VALUE SPACES.           
                                                                        
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE          PIC S9(04) COMP VALUE 0.         
           05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
                                                                        
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05 WS-NULL-IND-01          PIC S9(04) COMP VALUE +0.         
           05 WS-NULL-IND-02          PIC S9(04) COMP VALUE +0.         
           05 WS-NULL-IND-03          PIC S9(04) COMP VALUE +0.         
           05 WS-NULL-IND-04          PIC S9(04) COMP VALUE +0.         
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-NO-MORE-RECORDS     PIC X(01) VALUE 'N'.              
               88 NO-MORE-RECORDS               VALUE 'Y'.              
           05  WS-FCSCA260-STATUS     PIC X(02).                        
               88 FCSCA260-SUCCESSFUL           VALUE '00'.             
T35024     05  WS-DATABASE            PIC 9(01) VALUE ZERO.             
T35024         88 CSR-DATABASE                  VALUE 1.                
T35024         88 SEB-DATABASE                  VALUE 2.                
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-Y                   PIC X(01) VALUE 'Y'.              
           05  WS-N                   PIC X(01) VALUE 'N'.              
           05  WS-811                 PIC S9(9) VALUE -811 COMP.        
                                                                        
                                                                        
      *****************************************************************         
      *  CWS00038  JOB PARM ROUTINE                                   *         
      *****************************************************************         
       COPY CWS00038.                                                           
                                                                        
                                                                        
      *****************************************************************         
      *  CWS00010  CONTAINS DB2 ABEND VARIABLES                       *         
      *****************************************************************         
       COPY CWS00010.                                                           
                                                                        
      *****************************************************************         
      *  COPY BOOK FOR CPD00074                                       *         
      *****************************************************************         
       COPY CWS00074.                                                           
                                                                        
      *****************************************************************         
      * IO AREA FOR GETTING THE REVENUE MONTH FROM CSS_JOB_PARM       *         
      *****************************************************************         
       COPY FIOJC01.                                                            
                                                                        
      *****************************************************************         
      * WORKING STORAGE FOR CPD09900                                  *         
      *****************************************************************         
       COPY CWS09900.                                                           
                                                                        
      *****************************************************************         
      *  COPYBOOK WITH COMMON SQL VARIABLES                           *         
      *****************************************************************         
       COPY CWS00303.                                                           
                                                                        
      *****************************************************************         
      *  COPYBOOK FOR CPD00039                                        *         
      *****************************************************************         
       COPY CWS00039.                                                           
                                                                        
      *****************************************************************         
      *  COPYBOOK FOR REDUCING BLANK SPACES.                          *         
      *****************************************************************         
       COPY CWS00011.                                                           
                                                                        
      *****************************************************************         
      *  COPYBOOK WITH JOBS FILE/TABLE DEFINITIONS                    *         
      *****************************************************************         
       COPY FIOCA00.                                                            
                                                                        
      *****************************************************************         
      *    DECLARATION FOR SQL COMMAND AREA                           *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_ACCOUNT, AT                                    *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    DCLGEN FOR CSS_JOB_PARM                                    *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_THD_PRTY, ZW                                   *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBTHDPTY                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_THD_PRTY_HIST, ZX                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBTHDHST                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_NAME, DQ                                       *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_REG_PROFILE, LR                                *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBREGPRF                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_ADDR_FORMATTED, DY                             *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_CUSTOMER, CU                                   *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBCUST                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_CUSTOMER, A4                                   *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_NAME_ACC_XREF, HT                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_CUST_ADD_XREF, DM                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBCSADRX                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_DELINQUENCY, C8                                *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_USER_PROFILE, PF                               *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBUSRPRF                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_ADDR_FREEFORM, DM                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBADRFRE                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_ACCT_MISC_INFO, TA                             *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBATMISC                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CURSOR DECLARATIONS.                                       *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE THD_PRTY_CSR CURSOR FOR                           
                 SELECT ZX.THD_PRTY_ID                                  
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), ZX.DATE_TRANS
           , 121), ' ', '-'), ':', '.') DATE_TRANS                             
                       ,ZX.LETTER_TYPE_CD                               
                       ,ZX.LETTER_STATUS                                
                       ,ZX.DATE_MAILED                                  
                       ,ZX.USER_ID                                      
                       ,ZW.ACCOUNT_NO                                   
                       ,ZW.ADDRESS_ID                                   
                       ,ZW.DATE_CREATED                                 
                       ,ZW.DATE_INACTIVE                                
                       ,ZW.DATE_NEXT_ANNIV                              
                       ,ZW.NAME_ID                                      
                       ,ZW.THD_PRTY_STATUS                              
                   FROM CSS_THD_PRTY_HIST ZX WITH(READUNCOMMITTED)              
                       ,CSS_THD_PRTY ZW WITH(READUNCOMMITTED)                   
                  WHERE ZW.THD_PRTY_ID       = ZX.THD_PRTY_ID           
                    AND CAST(ZX.DATE_TRANS AS DATE) <= 
              IIF(TRY_CONVERT(DATE, :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) )          
                    AND ZX.DATE_TRANS        > CIS.CHAR2TIMESTAMP(
                                                    :WS-PGM-LAST-RUN-TS
              )      
                    AND ZX.LETTER_STATUS    <> 'N'                      
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE THD_PRTY_CSR CURSOR FOR                                   
MFA-TR*          SELECT ZX.THD_PRTY_ID                                          
MFA-TR*                ,ZX.DATE_TRANS                                           
MFA-TR*                ,ZX.LETTER_TYPE_CD                                       
MFA-TR*                ,ZX.LETTER_STATUS                                        
MFA-TR*                ,ZX.DATE_MAILED                                          
MFA-TR*                ,ZX.USER_ID                                              
MFA-TR*                ,ZW.ACCOUNT_NO                                           
MFA-TR*                ,ZW.ADDRESS_ID                                           
MFA-TR*                ,ZW.DATE_CREATED                                         
MFA-TR*                ,ZW.DATE_INACTIVE                                        
MFA-TR*                ,ZW.DATE_NEXT_ANNIV                                      
MFA-TR*                ,ZW.NAME_ID                                              
MFA-TR*                ,ZW.THD_PRTY_STATUS                                      
MFA-TR*            FROM CSS_THD_PRTY_HIST ZX                                    
MFA-TR*                ,CSS_THD_PRTY ZW                                         
MFA-TR*           WHERE ZW.THD_PRTY_ID       = ZX.THD_PRTY_ID                   
MFA-TR*             AND DATE(ZX.DATE_TRANS) <= :WS-COMMON-DATE                  
MFA-TR*             AND ZX.DATE_TRANS        > :WS-PGM-LAST-RUN-TS              
MFA-TR*             AND ZX.LETTER_STATUS    <> 'N'                              
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       PROCEDURE DIVISION.                                              
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
           PERFORM 5200-WRITE-BEGIN-CONTROLS   THRU 5200-EXIT.          
           PERFORM 1000-PROCESS-THRD-PTY       THRU 1000-EXIT.          
           PERFORM 5300-WRITE-END-CONTROLS     THRU 5300-EXIT.          
           PERFORM 5400-UPDATE-LAST-RUN-TS     THRU 5400-EXIT.          
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 0100-INITIALIZATION.                                          *         
      *****************************************************************         
       0100-INITIALIZATION.                                             
                                                                        
           OPEN OUTPUT FCSCA260-FILE.                                   
                                                                        
           IF FCSCA260-SUCCESSFUL                                       
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '********** PCSCA260 ABORT **************'        
              DISPLAY '*       0100-INITIALIZATION            *'        
              DISPLAY '*    ERROR OPENING FIORP260 FILE       *'        
              DISPLAY '* FILE STATUS    : ' WS-FCSCA260-STATUS          
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA260 ABORT **************'        
              MOVE 12 TO RETURN-CODE                                    
              STOP RUN                                                  
           END-IF.                                                      
                                                                        
           MOVE WS-PGRMNAME                  TO G6-PROGRAM-NAME.        
           MOVE 'DATE'                       TO G6-CMND-CODE.           
                                                                        
           PERFORM 6251-GET-FJC01-DATE         THRU 6251-EXIT.          
           MOVE WS-INPUT-RUN-DATE            TO WS-COMMON-DATE          
                                                                        
           IF  COMMON-DATE-NEEDED                                       
               PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT        
               MOVE 'PCSCA260'               TO WS-PGRMNAME             
               MOVE WS-FCA00-COMMON-DATE     TO WS-COMMON-DATE          
           END-IF.                                                      
                                                                        
           MOVE PROGRAM-NAME                 TO G6-PROGRAM-NAME.        
           MOVE '01'                         TO G6-COMPANY-NO.          
           MOVE 'PARM'                       TO G6-CMND-CODE.           
           MOVE +10                          TO G6-SEQ-NO.              
                                                                        
           PERFORM 7000-GET-CURRENT-TS       THRU 7000-EXIT.            
           PERFORM 7050-SELECT-LAST-RUN-DATE THRU 7050-EXIT.            
                                                                        
           MOVE G6-PARM-DATA                 TO WS-INPUT-DATA-R8.       
                                                                        
           IF WS-PGM-LAST-RUN-TS > WS-CURRENT-TS                        
              DISPLAY '********** PCSCA260 ABORT **************'        
              DISPLAY '*       0100-INITIALIZATION            *'        
              DISPLAY '* PROGRAM LAST RUN TIMESTAMP SHOULD BE *'        
              DISPLAY '*     LESS THAN CURRENT TIMESTAMP      *'        
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA260 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
T35024     MOVE 'DATABASE'                   TO C8-DELINQ-CD.           
T35024     MOVE '01'                         TO C8-COMPANY-NO.          
T35024     PERFORM 7700-SELECT-DELINQ          THRU 7700-EXIT.          
T35024     MOVE C8-DELINQ-VALUE              TO WS-DATABASE.            
                                                                        
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 1000-PROCESS-THRD-PTY.                                        *         
      *****************************************************************         
       1000-PROCESS-THRD-PTY.                                           
                                                                        
           PERFORM 7500-OPEN-THIRD-PTY-CSR     THRU 7500-EXIT.          
           PERFORM 7510-FETCH-THIRD-PTY-CSR    THRU 7510-EXIT.          
                                                                        
           PERFORM 5000-ACCUM-THRD-PTY-DETAILS THRU 5000-EXIT           
                                               UNTIL NO-MORE-RECORDS.   
                                                                        
           PERFORM 7520-CLOSE-THIRD-PTY-CSR    THRU 7520-EXIT.          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 5000-ACCUM-THRD-PTY-DETAILS.                                  *         
      *****************************************************************         
       5000-ACCUM-THRD-PTY-DETAILS.                                     
                                                                        
           MOVE ZW-ACCOUNT-NO                TO AT-ACCOUNT-NO           
                                                LR-ACCOUNT-NO.          
           MOVE ZX-USER-ID                   TO PF-USER-ID.             
           MOVE ZW-NAME-ID                   TO DQ-NAME-ID.             
                                                                        
           PERFORM 7100-SELECT-ACCT-DETAILS     THRU 7100-EXIT.         
           PERFORM 7150-SELECT-USER-PROFILE     THRU 7150-EXIT.         
           PERFORM 7200-SELECT-REG-DREG-INFO    THRU 7200-EXIT.         
                                                                        
           PERFORM 4060-GET-NAME                THRU 4060-EXIT.         
                                                                        
           IF WS-NAME-FORMAT (WS-NAME-INDX) = 'B'                       
              MOVE WS-FULL-NAME(WS-NAME-INDX) TO WS-THIRD-PTY-NAME      
           ELSE                                                         
              STRING WS-FMT-FIRST-NAME DELIMITED BY SIZE                
                     WS-FMT-LAST-NAME  DELIMITED BY SIZE                
                                   INTO WS-THIRD-PTY-NAME               
           END-IF.                                                      
                                                                        
           PERFORM 4000-MAIL-NAME-ADDRESS      THRU 4000-EXIT.          
                                                                        
           MOVE ZW-ADDRESS-ID                TO DZ-ADDRESS-ID.          
           PERFORM 7250-SELECT-THRD-PTY-ADDR   THRU 7250-EXIT.          
                                                                        
           PERFORM 5100-MOVE-FILE-DETAILS      THRU 5100-EXIT.          
           PERFORM 8900-WRITE-OUTPUT           THRU 8900-EXIT.          
                                                                        
           PERFORM 7510-FETCH-THIRD-PTY-CSR    THRU 7510-EXIT.          
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 5100-MOVE-FILE-DETAILS.                                       *         
      *****************************************************************         
       5100-MOVE-FILE-DETAILS.                                          
                                                                        
           INITIALIZE E-FCA260.                                         
                                                                        
           MOVE AT-COMPANY-NO              TO E-FCA260-COMPANY-NO.      
           MOVE PF-RESP-AREA-ID            TO E-FCA260-RESP-AREA-ID.    
           MOVE AT-ACCOUNT-NO              TO E-FCA260-ACCOUNT-NO.      
                                                                        
           MOVE WS-CUSTOMER-NAME           TO E-FCA260-CUST-NAME        
           MOVE WS-FMT-ADDR-STREET         TO E-FCA260-CC-ADDR-STREET   
           MOVE WS-FMT-CITY-STATE          TO E-FCA260-CC-CITY-STATE    
           MOVE WS-FMT-ZIP                 TO E-FCA260-CC-ZIP           
                                                                        
           MOVE WS-THIRD-PTY-NAME          TO E-FCA260-TP-NAME.         
           MOVE DZ-ADDR-STREET             TO E-FCA260-TP-ADDR-STREET   
           MOVE DZ-ADDR-CITY-STATE         TO E-FCA260-TP-CITY-STATE    
           MOVE DZ-ADDR-ZIP-CODE           TO E-FCA260-TP-ZIP           
                                                                        
           MOVE ZX-LETTER-TYPE-CD          TO E-FCA260-TP-LETTER-TYPE.  
           MOVE ZX-LETTER-STATUS           TO E-FCA260-TP-LETTER-ST     
           MOVE ZX-DATE-MAILED             TO E-FCA260-TP-ACT-DT.       
           MOVE LR-REG-GROUP-CD            TO E-FCA260-SEB-REG-GOUP.    
           MOVE ZW-THD-PRTY-STATUS         TO E-FCA260-THD-PRTY-STATUS. 
           MOVE ZX-THD-PRTY-ID             TO E-FCA260-THD-PRTY-ID.     
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 5200-WRITE-BEGIN-CONTROLS.                                    *         
      *****************************************************************         
       5200-WRITE-BEGIN-CONTROLS.                                       
                                                                        
           INITIALIZE E-FCA260-END-REC.                                 
           MOVE LOW-VALUES                   TO E-FCA260-SORT-AREA2.    
           MOVE WS-COMMON-DATE               TO E-FCA260-RUN-DATE.      
           MOVE WS-PGM-LAST-RUN-TS           TO E-FCA260-LAST-RUN-DATE. 
           PERFORM 8900-WRITE-OUTPUT           THRU 8900-EXIT.          
           SUBTRACT 1 FROM WS-FRP260-REC-CNTR.                          
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 5300-WRITE-END-CONTROLS.                                      *         
      *****************************************************************         
       5300-WRITE-END-CONTROLS.                                         
                                                                        
           INITIALIZE E-FCA260-END-REC.                                 
           MOVE HIGH-VALUES                  TO E-FCA260-SORT-AREA2.    
           MOVE WS-FRP260-REC-CNTR           TO E-FCA260-RECORD-COUNT.  
T35024     IF CSR-DATABASE                                              
T35024       MOVE '01'                       TO AT-COMPANY-NO           
T35024       PERFORM 7550-TOTAL-ACT-THD-PRTY    THRU 7550-EXIT          
T35024       PERFORM 7750-TOTAL-THD-PRTY-ACCT   THRU 7750-EXIT          
T35024       MOVE WS-ACT-THD-PRTY-COUNT      TO E-FCA260-THD-PRTY-CNT-01
T35024       MOVE WS-TOTAL-THD-PRTY-ACCT     TO E-FCA260-ACT-ACCT-CNT-01
T35024       MOVE '26'                       TO AT-COMPANY-NO           
T35024       MOVE ZEROES                     TO WS-ACT-THD-PRTY-COUNT   
T35024       MOVE ZEROES                     TO WS-TOTAL-THD-PRTY-ACCT  
T35024       PERFORM 7550-TOTAL-ACT-THD-PRTY    THRU 7550-EXIT          
T35024       PERFORM 7750-TOTAL-THD-PRTY-ACCT   THRU 7750-EXIT          
T35024       MOVE WS-ACT-THD-PRTY-COUNT      TO E-FCA260-THD-PRTY-CNT-02
T35024       MOVE WS-TOTAL-THD-PRTY-ACCT     TO E-FCA260-ACT-ACCT-CNT-02
T35024     ELSE                                                         
T35024       MOVE '01'                       TO AT-COMPANY-NO           
T35024       PERFORM 7625-ACT-REGULATED-SEB     THRU 7625-EXIT          
T35024       PERFORM 7800-TOT-REG-THD-PRTY-ACCT THRU 7800-EXIT          
T35024       MOVE WS-ACT-THD-PRTY-COUNT      TO E-FCA260-THD-PRTY-CNT-01
T35024       MOVE WS-TOTAL-THD-PRTY-ACCT     TO E-FCA260-ACT-ACCT-CNT-01
T35024                                                                  
T35024       MOVE ZEROES                     TO WS-ACT-THD-PRTY-COUNT   
T35024       MOVE ZEROES                     TO WS-TOTAL-THD-PRTY-ACCT  
T35024                                                                  
T35024       PERFORM 7650-ACT-DEREGULATED-SEB     THRU 7650-EXIT        
T35024       PERFORM 7850-TOT-DEREG-THD-PRTY-ACCT THRU 7850-EXIT        
T35024       MOVE WS-ACT-THD-PRTY-COUNT      TO E-FCA260-THD-PRTY-CNT-02
T35024       MOVE WS-TOTAL-THD-PRTY-ACCT     TO E-FCA260-ACT-ACCT-CNT-02
T35024     END-IF.                                                      
           PERFORM 8900-WRITE-OUTPUT              THRU 8900-EXIT.       
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 5400-WRITE-END-CONTROLS.                                      *         
      *****************************************************************         
       5400-UPDATE-LAST-RUN-TS.                                         
                                                                        
           INITIALIZE G6-PARM-DATA.                                     
           MOVE WS-CURRENT-TS            TO WS-PGM-LAST-RUN-TS.         
           MOVE WS-INPUT-DATA-R8         TO G6-PARM-DATA.               
                                                                        
           MOVE PROGRAM-NAME             TO G6-PROGRAM-NAME.            
           MOVE 'PARM'                   TO G6-CMND-CODE.               
           MOVE +10                      TO G6-SEQ-NO.                  
           MOVE '01'                     TO G6-COMPANY-NO.              
                                                                        
           PERFORM 8100-UPDATE-LAST-RUN-DATE   THRU 8100-EXIT.          
                                                                        
       5400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7000-GET-CURRENT-TS.                                          *         
      *****************************************************************         
       7000-GET-CURRENT-TS.                                             
                                                                        
           EXEC SQL                                                     
T35434         SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-TS = CURRENT TIMESTAMP                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA260 ABORT **************'        
              DISPLAY '*       7000-GET-CURRENT-TS            *'        
              DISPLAY '* CURRENT TS     : ' WS-CURRENT-TS               
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA260 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7050-SELECT-LAST-RUN-DATE.                                    *         
      *****************************************************************         
       7050-SELECT-LAST-RUN-DATE.                                       
                                                                        
           EXEC SQL                                                     
               SELECT G6.PROGRAM_NAME                                   
                     ,G6.COMPANY_NO                                     
                     ,G6.CMND_CODE                                      
                     ,G6.SEQ_NO                                         
                     ,G6.STATUS                                         
                     ,G6.PARM_DATA                                      
                 INTO :G6-PROGRAM-NAME                                  
                     ,:G6-COMPANY-NO                                    
                     ,:G6-CMND-CODE                                     
                     ,:G6-SEQ-NO                                        
                     ,:G6-STATUS                                        
                     ,:G6-PARM-DATA                                     
                 FROM CSS_JOB_PARM G6                                   
                WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                
                  AND G6.COMPANY_NO   = :G6-COMPANY-NO                  
                  AND G6.CMND_CODE    = :G6-CMND-CODE                   
                  AND G6.SEQ_NO       = :G6-SEQ-NO                      
                  AND G6.STATUS       = 'A'                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA260 ABORT **************'        
              DISPLAY '*     7050-SELECT-LAST-RUN-DATE        *'        
              DISPLAY '* PROGRAM NAME   : ' G6-PROGRAM-NAME             
              DISPLAY '* COMPANY NO     : ' G6-COMPANY-NO               
              DISPLAY '* CMD CODE       : ' G6-CMND-CODE                
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA260 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7100-SELECT-ACCT-DETAILS.                                     *         
      *****************************************************************         
       7100-SELECT-ACCT-DETAILS.                                        
                                                                        
           EXEC SQL                                                     
               SELECT AT.ACCOUNT_NO                                     
                     ,AT.ADDRESS_ID                                     
                     ,AT.COMPANY_NO                                     
                 INTO :AT-ACCOUNT-NO                                    
                     ,:AT-ADDRESS-ID                                    
                     ,:AT-COMPANY-NO                                    
                 FROM CSS_ACCOUNT AT                                    
                WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA260 ABORT **************'        
              DISPLAY '*     7100-SELECT-ACCT-DETAILS         *'        
              DISPLAY '* ACCOUNT NO     : ' AT-ACCOUNT-NO               
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA260 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7150-SELECT-USER-PROFILE.                                     *         
      *****************************************************************         
       7150-SELECT-USER-PROFILE.                                        
                                                                        
           EXEC SQL                                                     
               SELECT PF.RESP_AREA_ID                                   
                     ,PF.FIRST_NAME                                     
                     ,PF.MIDDLE_NAME                                    
                     ,PF.LAST_NAME                                      
                 INTO :PF-RESP-AREA-ID                                  
                     ,:PF-FIRST-NAME                                    
                     ,:PF-MIDDLE-NAME                                   
                     ,:PF-LAST-NAME                                     
                 FROM CSS_USER_PROFILE PF                               
                WHERE PF.USER_ID = :PF-USER-ID                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA260 ABORT **************'        
              DISPLAY '*     7150-SELECT-USER-PROFILE         *'        
              DISPLAY '* USER ID        : ' PF-USER-ID                  
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA260 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7200-SELECT-REG-DREG-INFO.                                    *         
      *****************************************************************         
       7200-SELECT-REG-DREG-INFO.                                       
                                                                        
           EXEC SQL                                                     
               SELECT LR.REG_GROUP_CD                                   
                 INTO :LR-REG-GROUP-CD                                  
                 FROM CSS_REG_PROFILE LR                                
                WHERE LR.ACCOUNT_NO = :LR-ACCOUNT-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
                                                      OR WS-811         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                MOVE SPACES                  TO LR-REG-GROUP-CD         
              END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE EQUAL WS-811                     
                MOVE '100'                   TO LR-REG-GROUP-CD         
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSCA260 ABORT **************'        
              DISPLAY '*     7200-SELECT-REG-DREG-INFO        *'        
              DISPLAY '* ACCOUNT NO     : ' LR-ACCOUNT-NO               
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA260 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7250-SELECT-THRD-PTY-ADDR.                                    *         
      *****************************************************************         
       7250-SELECT-THRD-PTY-ADDR.                                       
                                                                        
           EXEC SQL                                                     
               SELECT DZ.ADDR_STREET                                    
                     ,DZ.ADDR_CITY_STATE                                
                     ,DZ.ADDR_ZIP_CODE                                  
                 INTO :DZ-ADDR-STREET                                   
                     ,:DZ-ADDR-CITY-STATE                               
                     ,:DZ-ADDR-ZIP-CODE                                 
                 FROM CSS_ADDR_FREEFORM DZ                              
                WHERE DZ.ADDRESS_ID = :DZ-ADDRESS-ID                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR NOT-FOUND                                                 
              IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                  MOVE SPACES            TO DZ-ADDR-STREET              
                                            DZ-ADDR-CITY-STATE          
                                            DZ-ADDR-ZIP-CODE            
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSCA260 ABORT **************'        
              DISPLAY '*     7250-SELECT-THRD-PTY-ADDR        *'        
              DISPLAY '* ADDRESS ID     : ' DZ-ADDRESS-ID               
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA260 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7500-OPEN-THIRD-PTY-CSR.                                      *         
      *****************************************************************         
       7500-OPEN-THIRD-PTY-CSR.                                         
                                                                        
           EXEC SQL                                                     
                OPEN THD_PRTY_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA260 ABORT **************'        
              DISPLAY '*     7500-OPEN-THIRD-PTY-CSR          *'        
              DISPLAY '* COMMON DATE    : ' WS-INPUT-DATE               
              DISPLAY '* LAST RUN TS    : ' WS-PGM-LAST-RUN-TS          
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA260 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7510-FETCH-THIRD-PTY-CSR.                                     *         
      *****************************************************************         
       7510-FETCH-THIRD-PTY-CSR.                                        
                                                                        
           EXEC SQL                                                     
                FETCH THD_PRTY_CSR                                      
                 INTO :ZX-THD-PRTY-ID                                   
                     ,:ZX-DATE-TRANS                                    
                     ,:ZX-LETTER-TYPE-CD                                
                     ,:ZX-LETTER-STATUS                                 
                     ,:ZX-DATE-MAILED :WS-NULL-IND-04                    
                     ,:ZX-USER-ID                                       
                     ,:ZW-ACCOUNT-NO                                    
                     ,:ZW-ADDRESS-ID                                    
                     ,:ZW-DATE-CREATED :WS-NULL-IND-01                   
                     ,:ZW-DATE-INACTIVE :WS-NULL-IND-02                  
                     ,:ZW-DATE-NEXT-ANNIV :WS-NULL-IND-03                
                     ,:ZW-NAME-ID                                       
                     ,:ZW-THD-PRTY-STATUS                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 IF WS-NULL-IND-01 = -1                                 
                    MOVE SPACES            TO ZW-DATE-CREATED           
                 END-IF                                                 
                 IF WS-NULL-IND-02 = -1                                 
                    MOVE SPACES            TO ZW-DATE-INACTIVE          
                 END-IF                                                 
                 IF WS-NULL-IND-03 = -1                                 
                    MOVE SPACES            TO ZW-DATE-NEXT-ANNIV        
                 END-IF                                                 
                 IF WS-NULL-IND-04 = -1                                 
                    MOVE SPACES            TO ZX-DATE-MAILED            
                 END-IF                                                 
              ELSE                                                      
                 MOVE 'Y'                    TO WS-NO-MORE-RECORDS      
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSCA260 ABORT **************'        
              DISPLAY '*     7510-FETCH-THIRD-PTY-CSR         *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA260 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7520-CLOSE-THIRD-PTY-CSR.                                     *         
      *****************************************************************         
       7520-CLOSE-THIRD-PTY-CSR.                                        
                                                                        
           EXEC SQL                                                     
                CLOSE THD_PRTY_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA260 ABORT **************'        
              DISPLAY '*      7520-CLOSE-THIRD-PTY-CSR        *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA260 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
T35024*****************************************************************         
T35024*                                                               *         
T35024* 7550-TOTAL-ACT-THD-PRTY.                                      *         
T35024*****************************************************************         
T35024 7550-TOTAL-ACT-THD-PRTY.                                         
T35024                                                                  
T35024     EXEC SQL                                                     
T35024         SELECT COUNT(*)                                          
T35024           INTO :WS-ACT-THD-PRTY-COUNT                            
T35024           FROM CSS_THD_PRTY ZW WITH(READUNCOMMITTED)                     
T35024               ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
T35024          WHERE ZW.ACCOUNT_NO      = AT.ACCOUNT_NO                
T35024            AND AT.COMPANY_NO      = :AT-COMPANY-NO               
T35024            AND ZW.THD_PRTY_STATUS = 'A'                          
T35024                                                           
T35024     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*          INTO :WS-ACT-THD-PRTY-COUNT                                    
MFA-TR*          FROM CSS_THD_PRTY ZW                                           
MFA-TR*              ,CSS_ACCOUNT AT                                            
MFA-TR*         WHERE ZW.ACCOUNT_NO      = AT.ACCOUNT_NO                        
MFA-TR*           AND AT.COMPANY_NO      = :AT-COMPANY-NO                       
MFA-TR*           AND ZW.THD_PRTY_STATUS = 'A'                                  
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35024                                                                  
T35024     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
T35024                                                                  
T35024     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T35024        NEXT SENTENCE                                             
T35024     ELSE                                                         
T35024        DISPLAY '********** PCSCA260 ABORT **************'        
T35024        DISPLAY '*     7550-TOTAL-ACT-THD-PRTY          *'        
T35024        DISPLAY '* COMPANY NO     : ' G6-COMPANY-NO               
T35024        DISPLAY '* ACCOUNT NO     : ' AT-ACCOUNT-NO               
T35024        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
T35024        DISPLAY '* PROGRAM ABORTING...                  *'        
T35024        DISPLAY '********** PCSCA260 ABORT **************'        
T35024        PERFORM 9900-ABEND               THRU 9900-EXIT           
T35024     END-IF.                                                      
T35024                                                                  
T35024 7550-EXIT.                                                       
T35024      EXIT.                                                       
T35024                                                                  
T35024*****************************************************************         
T35024*                                                               *         
T35024* 7625-ACT-REGULATED-SEB.                                       *         
T35024*****************************************************************         
T35024 7625-ACT-REGULATED-SEB.                                          
T35024      EXEC SQL                                                    
T35024         SELECT COUNT(*)                                          
T35024           INTO :WS-ACT-THD-PRTY-COUNT                            
T35024           FROM CSS_THD_PRTY ZW                                   
T35024          WHERE ZW.THD_PRTY_STATUS  = 'A'                         
T35024            AND EXISTS (SELECT 1                                  
T35024                FROM CSS_REG_PROFILE LR                           
T35024                WHERE LR.ACCOUNT_NO = ZW.ACCOUNT_NO)              
T35024      END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35024                                                                  
T35024     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
T35024                                                                  
T35024     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T35024        NEXT SENTENCE                                             
T35024     ELSE                                                         
T35024        DISPLAY '********** PCSCA260 ABORT **************'        
T35024        DISPLAY '*      7625-ACT-REGULATED-SEB          *'        
T35024        DISPLAY '* ACCOUNT NO     : ' ZW-ACCOUNT-NO               
T35024        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
T35024        DISPLAY '* PROGRAM ABORTING...                  *'        
T35024        DISPLAY '********** PCSCA260 ABORT **************'        
T35024        PERFORM 9900-ABEND               THRU 9900-EXIT           
T35024     END-IF.                                                      
T35024                                                                  
T35024 7625-EXIT.                                                       
T35024      EXIT.                                                       
T35024                                                                  
T35024*****************************************************************         
T35024*                                                               *         
T35024* 7650-ACT-DEREGULATED-SEB.                                     *         
T35024*****************************************************************         
T35024 7650-ACT-DEREGULATED-SEB.                                        
T35024      EXEC SQL                                                    
T35024         SELECT COUNT(*)                                          
T35024           INTO :WS-ACT-THD-PRTY-COUNT                            
T35024           FROM CSS_THD_PRTY ZW                                   
T35024          WHERE ZW.THD_PRTY_STATUS  = 'A'                         
T35024            AND NOT EXISTS (SELECT 1                              
T35024                FROM CSS_REG_PROFILE LR                           
T35024                WHERE LR.ACCOUNT_NO = ZW.ACCOUNT_NO)              
T35024      END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35024                                                                  
T35024     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
T35024                                                                  
T35024     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T35024        NEXT SENTENCE                                             
T35024     ELSE                                                         
T35024        DISPLAY '********** PCSCA260 ABORT **************'        
T35024        DISPLAY '*     7650-ACT-DEREGULATED-SEB         *'        
T35024        DISPLAY '* ACCOUNT NO     : ' ZW-ACCOUNT-NO               
T35024        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
T35024        DISPLAY '* PROGRAM ABORTING...                  *'        
T35024        DISPLAY '********** PCSCA260 ABORT **************'        
T35024        PERFORM 9900-ABEND               THRU 9900-EXIT           
T35024     END-IF.                                                      
T35024                                                                  
T35024 7650-EXIT.                                                       
T35024      EXIT.                                                       
                                                                        
T35024******************************************************************        
T35024*                                                               *         
T35024*   7700-SELECT-DELINQ.                                          *        
T35024******************************************************************        
T35024 7700-SELECT-DELINQ.                                              
T35024*                                                                         
T35024     EXEC SQL                                                     
T35024         SELECT DELINQ_VALUE                                      
T35024           INTO :C8-DELINQ-VALUE                                  
T35024           FROM CSS_DELINQUENCY C8                                
T35024          WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                     
T35024            AND C8.COMPANY_NO = :C8-COMPANY-NO                    
T35024     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35024                                                                  
T35024     MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
T35024                                                                  
T35024     IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
T35024         CONTINUE                                                 
T35024     ELSE                                                         
T35024        DISPLAY '********** PCSCA260 ABORT **************'        
T35024        DISPLAY '*        7700-SELECT-DELINQ            *'        
T35024        DISPLAY '* DELINQ-CD      : ' C8-DELINQ-CD                
T35024        DISPLAY '* COMPANY-NO     : ' C8-COMPANY-NO               
T35024        DISPLAY '* PROGRAM ABORTING...                  *'        
T35024        DISPLAY '********** PCSCA260 ABORT **************'        
T35024        PERFORM 9900-ABEND               THRU 9900-EXIT           
T35024     END-IF.                                                      
T35024*                                                                         
T35024 7700-EXIT.                                                       
T35024     EXIT.                                                        
                                                                        
T35024******************************************************************        
T35024*                                                               *         
T35024*  7750-TOTAL-THD-PRTY-ACCT.                                     *        
T35024******************************************************************        
T35024*                                                                         
T35024 7750-TOTAL-THD-PRTY-ACCT.                                        
T35024      EXEC SQL                                                    
T35024           SELECT COUNT (DISTINCT (ZW.ACCOUNT_NO))                
T35024             INTO :WS-TOTAL-THD-PRTY-ACCT                         
T35024             FROM CSS_THD_PRTY ZW                                 
T35024                 ,CSS_ACCOUNT AT                                  
T35024            WHERE ZW.ACCOUNT_NO = AT.ACCOUNT_NO                   
T35024              AND AT.COMPANY_NO = :AT-COMPANY-NO                  
T35024              AND ZW.THD_PRTY_STATUS = 'A'                        
T35024      END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35024                                                                  
T35024     MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
T35024                                                                  
T35024     IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
T35024         CONTINUE                                                 
T35024     ELSE                                                         
T35024        DISPLAY '********** PCSCA260 ABORT **************'        
T35024        DISPLAY '*       7750-TOTAL-THD-PRTY-ACCT       *'        
T35024        DISPLAY '* SQLCODE       =' WS-ACTIVE-RETURN-CODE         
T35024        DISPLAY '* ACCOUNT_NO    =' AT-ACCOUNT-NO                 
T35024        DISPLAY '* COMPANY_NO    =' AT-COMPANY-NO                 
T35024        DISPLAY '* PROGRAM ABORTING...                  *'        
T35024        DISPLAY '********** PCSCA260 ABORT **************'        
T35024        PERFORM 9900-ABEND               THRU 9900-EXIT           
T35024     END-IF.                                                      
T35024*                                                                         
T35024 7750-EXIT.                                                       
T35024      EXIT.                                                       
                                                                        
T35024******************************************************************        
T35024*                                                               *         
T35024*  7800-TOT-REG-THD-PRTY-ACCT                                   *         
T35024******************************************************************        
T35024 7800-TOT-REG-THD-PRTY-ACCT.                                      
T35024*                                                                         
T35024     EXEC SQL                                                     
T35024           SELECT COUNT(DISTINCT(ZW.ACCOUNT_NO))                  
T35024             INTO :WS-TOTAL-THD-PRTY-ACCT                         
T35024             FROM CSS_THD_PRTY ZW                                 
T35024            WHERE ZW.THD_PRTY_STATUS='A'                          
T35024              AND EXISTS (SELECT 1                                
T35024                  FROM  CSS_REG_PROFILE LR                        
T35024                  WHERE LR.ACCOUNT_NO = ZW.ACCOUNT_NO)            
T35024     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35024                                                                  
T35024     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
T35024                                                                  
T35024     IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
T35024         CONTINUE                                                 
T35024     ELSE                                                         
T35024        DISPLAY '********** PCSCA260 ABORT **************'        
T35024        DISPLAY '*     7800-TOT-REG-THD-PRTY-ACCT       *'        
T35024        DISPLAY '* SQLCODE       =' WS-ACTIVE-RETURN-CODE         
T35024        DISPLAY '* ACCOUNT_NO    =' ZW-ACCOUNT-NO                 
T35024        DISPLAY '* PROGRAM ABORTING...                  *'        
T35024        DISPLAY '********** PCSCA260 ABORT **************'        
T35024        PERFORM 9900-ABEND               THRU 9900-EXIT           
T35024     END-IF.                                                      
T35024*                                                                         
T35024 7800-EXIT.                                                       
T35024      EXIT.                                                       
                                                                        
T35024******************************************************************        
T35024*                                                               *         
T35024*  7850-TOT-DEREG-THD-PRTY-ACCT                                 *         
T35024******************************************************************        
T35024*                                                                         
T35024 7850-TOT-DEREG-THD-PRTY-ACCT.                                    
T35024*                                                                         
T35024     EXEC SQL                                                     
T35024           SELECT COUNT(DISTINCT (ZW.ACCOUNT_NO))                 
T35024             INTO :WS-TOTAL-THD-PRTY-ACCT                         
T35024             FROM CSS_THD_PRTY ZW                                 
T35024            WHERE ZW.THD_PRTY_STATUS = 'A'                        
T35024          AND NOT EXISTS (SELECT 1                                
T35024                            FROM CSS_REG_PROFILE LR               
T35024                           WHERE LR.ACCOUNT_NO = ZW.ACCOUNT_NO)   
T35024     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35024                                                                  
T35024     MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
T35024                                                                  
T35024     IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
T35024         CONTINUE                                                 
T35024     ELSE                                                         
T35024        DISPLAY '********** PCSCA260 ABORT **************'        
T35024        DISPLAY '*     7850-TOT-DEREG-THD-PRTY-ACCT     *'        
T35024        DISPLAY '* SQLCODE       =' WS-ACTIVE-RETURN-CODE         
T35024        DISPLAY '* ACCOUNT_NO    =' ZW-ACCOUNT-NO                 
T35024        DISPLAY '* PROGRAM ABORTING...                  *'        
T35024        DISPLAY '********** PCSCA260 ABORT **************'        
T35024        PERFORM 9900-ABEND               THRU 9900-EXIT           
T35024     END-IF.                                                      
T35024*                                                                         
T35024 7850-EXIT.                                                       
T35024      EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8100-UPDATE-LAST-RUN-DATE                                     *         
      *****************************************************************         
       8100-UPDATE-LAST-RUN-DATE.                                       
                                                                        
           EXEC SQL                                                     
                UPDATE CSS_JOB_PARM                                     
                   SET PARM_DATA     = :G6-PARM-DATA                    
                 WHERE PROGRAM_NAME  = :G6-PROGRAM-NAME                 
                   AND CMND_CODE     = :G6-CMND-CODE                    
                   AND COMPANY_NO    = :G6-COMPANY-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA260 ABORT **************'        
              DISPLAY '*     8100-UPDATE-LAST-RUN-DATE        *'        
              DISPLAY '* PROGRAM NAME   : ' G6-PROGRAM-NAME             
              DISPLAY '* COMPANY NO     : ' G6-COMPANY-NO               
              DISPLAY '* CMD CODE       : ' G6-CMND-CODE                
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA260 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8900-WRITE-OUTPUT.                                            *         
      *****************************************************************         
       8900-WRITE-OUTPUT.                                               
                                                                        
           WRITE E-FCA260.                                              
                                                                        
           ADD +1 TO WS-FRP260-REC-CNTR.                                
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 9000-TERMINATE.                                               *         
      *****************************************************************         
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSCA260-FILE.                                         
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * CPD09900   THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE      *         
      * 9900-ABEND                                                    *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * 6010-REDUCE-EMBEDDED-SPACES.                                  *         
      *****************************************************************         
           EXEC SQL                                                             
                 INCLUDE CPD00004                                               
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * 4000-MAIL-NAME-ADDRESS.                                       *         
      *****************************************************************         
           EXEC SQL                                                             
                 INCLUDE CPD00074                                               
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * COPY BOOK TO GET COMMON DATE FROM JOB PARM                    *         
      *****************************************************************         
           COPY CPD00040.                                                       
                                                                        
      *****************************************************************         
      *  6251-GET-FJC01-DATE                                          *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE CPD00037                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *  7620-START-FCSJC01                                           *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE CPD00038                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *  7620-START-FCSCA00                                           *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9700-PROCESS-ABEND.                                                     
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD0023B                                                  
           END-EXEC.                                                            
                                                                        
