       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA244.                                        
       DATE-WRITTEN.   10/06/04.                                        
       DATE-COMPILED.                                                   
       AUTHOR.         RICK BLACK                                       
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRICITY  & GAS              **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                   DB2                          *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE       INITIALS      REASON                             **         
      **                                                             **         
C29932** 10/06/04   RICK          COLLECTION SYSTEM -                **         
C29932**                          PROCESS CSS_CQ_ITEMS_MF            **         
W29932** 04/21/05   RB19957       FIX PROBLEM WITH SONP DATE NOT     **         
W29932**                          BEING CALCULATED.                  **         
C32694** 06/30/05   RB19957       FIX PROBLEM WITH SONP DATE NOT     **         
C32694**            RICK          BEING CALCULATED USING FORMULA     **         
C32694**             BLACK        PROVIDED BY MARCIA LEWIS.          **         
C32694**                          ALSO ADDED TWO NEW FIELDS TO THE   **         
C32694**                          OUTPUT FILE.  THE FIELDS ARE  RTND-**         
C32694**                          CK-DNP-DATE & XCEPTL-DNP-DATE.     **         
C32694**                          LEAVING IN SCSCB068 STUFF EVEN     **         
C32694**                          THOUGH IT IS NO LONGER CALLED.     **         
C33247** 02/21/06  KR19687        ADD BEACON SCORE AND ORIGINATION   **         
      **                          CODE TO COLLECTIONS DIALER         **         
C33247** 03/21/06  RB19957        ADD SENIOR FLAG, REG GROUP CODE,   **         
      **                          AND RATE PLAN TO COLLECTIONS       **         
      **                          DIALER DOWNLOAD FILE.              **         
T35434** 03/20/07  SP94986        REPLACE MODEL_SQL WITH SET COMMANDS *         
T35434**                          AND WITH UR CHANGES TO CURSORS AND  *         
T35434**                          FOR SINGLETON SELECT.               *         
C37304** 6/4/08    MJ13662        REMOVE REFERENCE TO TBCOPHON,       *         
C37304**                          COLL_HIST_DET, COLLECT_HIST AND     *         
C37304**                          COLL_ACCT_INFO.                     *         
A00699** 07/20/09  RC41079        CORRECT PROBLEM WITH SERVICE ADDRESS*         
A00699**                          NOT POPULATING CORRECTLY IN DIALER  *         
A00699**                          RAW FILE.                           *         
A02036** 05/10/10  RB19957        CHANGE SCE&G TO SCEG IN THE OUTPUT  *         
A02036**                          FILE.                               *         
A02068** 06/23/10  RICK BLACK     ADD AGING BUCKET DATE FIELDS        *         
A02036** 07/12/10  RICK BLACK     ADD COLLECTION WORK DATE AND        *         
A02036**                          WRITE OFF DATE FIELDS.              *         
A02036**                          ADDED QUERYNO TO SQL CODE.          *         
A02036** 07/19/10  RICK BLACK     PREVENT -310 FROM OCCURRING.        *         
ACT108** 05/30/14  BD09555        REMOVE SCSCB068 CALL.               *         
ACT108**                          WS-DATE-CREDIT-ACTION-NI WAS        *         
ACT108**                          REPLACED WITH DELETION OF CWS00068  *         
A05198** 01/28/16  MJ13662        SELECT BEACON OR AEP SCORE BASED ON *         
A05198**                          CK-SCORE-MODEL-CD.                  *         
A05460** 06/02/16  MR7E794        REMOVE THE DUPLICATE FILED WS-C AND *         
A05460**           ACT188         REMOVED THE UNUSED CODE.            *         
      *****************************************************************         
      *                   PCSCA244   NARRATIVE                        *         
      *                                                               *         
      * THIS PROGRAM PROCESSES THE CSS_CQ_ITEMS_MF TABLE.  IT READS   *         
      * THE TABLE AND BUILDS AN OUTPUT FILE FROM THE DATA IN IT AND   *         
      * ADDS DATA FROM OTHER TABLES AS WELL.  THIS FILE IS THEN XCOMED*         
      * TO THE CONCERTO DIRECTORY.                                    *         
      *****************************************************************         
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSCA244.                                                           
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDCA244.                                                           
       COPY FIOCA244.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA244'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-LITERALS.                                                 
           05 WS-D                             PIC X(01)  VALUE 'D'.    
           05 WS-S                             PIC X(01)  VALUE 'S'.    
           05 WS-I                             PIC X(01)  VALUE 'I'.    
           05 WS-CUSTOMER                      PIC X(02)  VALUE 'CN'.   
           05 WS-HOME                          PIC X(02)  VALUE 'H1'.   
           05 WS-WORK                          PIC X(02)  VALUE 'W1'.   
           05 WS-BUSINESS                      PIC X(02)  VALUE 'B1'.   
           05 WS-Y                             PIC X(01)  VALUE 'Y'.    
           05 WS-N                             PIC X(01)  VALUE 'N'.    
           05 WS-OTHER                         PIC S9(09) USAGE COMP    
                                                          VALUE +0.     
           05 WS-PGRMNAME                      PIC X(08)  VALUE         
              'PCSCA244'.                                               
      *                                                                         
       01  WS-FILE-STATUS.                                              
           05  WS-FCA244-STATUS         PIC X(02).                      
               88  FCA244-SUCCESSFUL               VALUE '00'.          
      *                                                                         
       01  RS-RETURN-CODE-VARIABLES.                                    
           05  RS-RETURN-CODE           PIC S9(04) COMP VALUE 0.        
           05  RS-RETURN-CODE-DISP      PIC +Z(04).                     
      *                                                                         
       01  WS-VARIABLES.                                                
           05 WS-ROW-EXISTS                    PIC X(01).               
              88  ROW-EXISTS                   VALUE 'Y'.               
           05 WS-PHONE-TYPE                    PIC X(02)  VALUE SPACES. 
           05 WS-PHONE-NO                      PIC X(10)  VALUE SPACES. 
           05 WS-EXTENSION-NO                  PIC X(06)  VALUE SPACES. 
           05 WS-CQITEM-STATUS                 PIC X(02).               
              88  CQITEM-SUCCESSFUL            VALUE '00'.              
           05 WS-AT-END-FLAG                   PIC X(01).               
              88  WS-AT-END                    VALUE 'Y'.               
           05 WS-DATE-FOUND                    PIC X(01) VALUE 'N'.     
              88  DATE-IS-FOUND                VALUE 'Y'.               
           05 WS-CONTINUE-FLAG                 PIC X(01).               
              88  WS-CONTINUE                  VALUE 'Y'.               
           05 PROGRAM-NAME                     PIC X(08)                
                       VALUE 'PCSCA244'.                                
           05 WS-NEW-TIMESTAMP                 PIC X(26).               
           05 WS-SEB-REGULATED-FLAG            PIC X(01) VALUE 'N'.     
              88  SEB-REGULATED                          VALUE 'Y'.     
           05  WS-DATABASE                     PIC 9(01) VALUE 0.       
               88 CSR-DATABASE                           VALUE 1.       
               88 SEB-DATABASE                           VALUE 2.       
           05 WS-NULL-IND1              PIC S9(04)   COMP   VALUE 0.    
           05 WS-DNP-DATE                      PIC X(10) VALUE SPACES.  
           05 WS-DNP-DATE1                     PIC X(10) VALUE SPACES.  
           05 WS-DATE-HOLD                     PIC X(10) VALUE SPACES.  
           05 WS-DATE-HOLD1                    PIC X(10) VALUE SPACES.  
           05 WS-DATE-HOLD2                    PIC X(10) VALUE SPACES.  
           05 WS-DATE-HOLD-USA                 PIC X(10) VALUE SPACES.  
           05 WS-NSF-ITEMS-MOS12             PIC S9(04) COMP VALUE ZERO.
           05 WS-XCEPTL-DNP-DATE               PIC X(10) VALUE SPACES.  
           05 WS-RTND-CK-DNP-DATE              PIC X(10) VALUE SPACES.  
      *                                                                         
COB305 01 WS-TRANS-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.     
      *                                                                         
       01  WS-DAY-COLL                 PIC X(20)                        
                           VALUE 'DAY-COLL            '.                
COB305 01 WS-HOLD-DEL-VALUE        PIC S9(4)V9(5) USAGE COMP-3 VALUE 0.     
       01  WS-ACTIVE-DAYS              PIC 9(02) VALUE ZEROS.           
       01  WS-DAY-COUNTER              PIC 9(02) VALUE ZEROS.           
       01  WS-BEST-TIME-START-NULL     PIC S9(04)    COMP VALUE +0.     
       01  WS-BEST-TIME-STOP-NULL      PIC S9(04)    COMP VALUE +0.     
       01  WS-LAST-PAYMENT-DT-NULL     PIC S9(04)    COMP VALUE +0.     
                                                                        
COB305 01 WS-NAME-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.        
       01  WS-CUST-TYPE                PIC X(01) VALUE SPACES.          
      *                                                                         
       01  WS-NAME-FCA244.                                              
           05  WS-LNAME-FCA244         PIC X(40).                       
           05  WS-FNAME-FCA244         PIC X(40).                       
           05  WS-MNAME-FCA244         PIC X(20).                       
      *                                                                         
       01  WS-SPOUSE-NAME-FCA244.                                       
           05  WS-SNAME-FCA244-USED    PIC X(50).                       
           05  WS-SNAME-FCA244-NUSED   PIC X(50).                       
      *                                                                         
       01  WS-CALL-QUEUE-ID.                                            
           05  WS-CALL-QUEUE-CAT       PIC X(02).                       
           05  FILLER                  PIC X(03).                       
      *                                                                         
A00699 01  WS-CITY1-C                  PIC X(26) VALUE SPACE.           
A00699 01  WS-CITY2-C                  PIC X(26) VALUE SPACE.           
A00699 01  WS-CITY3-C                  PIC X(26) VALUE SPACE.           
A00699 01  WS-SPACE                    PIC X(26) VALUE SPACE.           
A00699 01  WS-STATE-S                  PIC X(02) VALUE SPACE.           
A00699 01  WS-STATE-C                  PIC X(26) VALUE SPACE.           
      *                                                                         
      *****************************************************************         
      **      APPLICATION  TABLE DCLGENS                             **         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      **                                                                        
      *****************************************************************         
      *    CSS_ACCOUNT                                                          
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
      **                                                                        
      *****************************************************************         
      *    CSS_CUST_STATS                                                       
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBCSTSTS                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_CUST_PHONE                                                       
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBCSTPHN                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_CONTACT_PHONE                                                    
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBCNTPHN                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_NAME                                                             
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBNAME                                                     
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_DELINQUENCY                                                      
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_CRED_COLL                                                        
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBCRCOLL                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_CQ_ITEMS_MF                                                      
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBITEMMF                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_NAME_ACCT_XREF                                                   
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_UTIL_ENVRNMT                                                     
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBUTLENV                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *   CSS_REG_PROFILE                                                       
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBREGPRF                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_CUST_ADDR_XREF                                        *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBCSADRX                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_ADDR_FREEFORM                                         *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBADRFRE                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_ADDR_FORMATTED                                        *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_ZIP_CODE                                              *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_ACCT_MISC_INFO                                        *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBATMISC                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_LOCAL_OFFICE                                          *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_CREDIT_PROFILE                                        *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBCRPROF                                                 
           END-EXEC.                                                            
      *                                                                         
C33247****************************************************************          
C33247*    CSS_CREDIT_HIST                                           *          
C33247****************************************************************          
C33247     EXEC SQL                                                             
C33247         INCLUDE TBCRHIST                                                 
C33247     END-EXEC.                                                            
C33247*                                                                         
C33247****************************************************************          
C33247*    CSS_MKT_XREF_ACCT                                         *          
C33247****************************************************************          
C33247     EXEC SQL                                                             
C33247         INCLUDE TBMRKXR                                                  
C33247     END-EXEC.                                                            
C33247*                                                                         
A02036****************************************************************          
A02036*    CSS_COLLECT_HIST - HC                                     *          
A02036****************************************************************          
A02036     EXEC SQL                                                             
A02036         INCLUDE TBCOLHST                                                 
A02036     END-EXEC.                                                            
A02036*                                                                         
       COPY CWS00303.                                                           
      *-- COPY BOOK HAVING SUCCESSFUL-CALL AND NOT-FOUND                        
      *                                                                         
      *  ABEND SWITCH COPYBOOK                                                  
       COPY CWS09900.                                                           
      *                                                                         
      * -- USED BY CPD0303B                                                     
      * WS ABEND WORK AREA                                                      
       COPY CWS00010.                                                           
      *                                                                         
      *-- COPY BOOK THAT CONTAINS VARIABLES REQD TO GET JOB PARM DATE           
       COPY CJF00101.                                                           
       COPY FIOCA01.                                                            
       COPY CWS00038.                                                           
      *                                                                         
      *-- COPY BOOK HAVING WS-EMB-INPUT                                         
       COPY CWS00011.                                                           
      *                                                                         
      *-- COPY BOOK FOR CWS00074                                                
           EXEC SQL                                                             
              INCLUDE CWS00074                                                  
           END-EXEC.                                                            
      *                                                                         
      *-- COPYBOOK FOR WS-CODES-DATA-PRESENT                                    
       COPY CWS00056.                                                           
      *                                                                         
      *****************************************************************         
      ** CURSOR DECLARATION TO GET ALL THE ACCOUNTS THAT NEED TO BE             
      ** PROCESSED FOR CONSIDERATION INTO COLLECTION SYSTEM.                    
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
               DECLARE CQ-ITEMS CURSOR WITH HOLD FOR                    
                 SELECT  ACCOUNT_NO                                     
                        ,RECORD_CREATION_DT                             
                        ,NON_UTIL_ARREARS                               
                        ,UTIL_ARREARS                                   
                        ,AR_TRANS_BALANCE                               
                        ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           LAST_PAYMENT_DT, 121), ' ', '-'), ':', '.') LAST_PAYMENT_DT         
                        ,LAST_PAYMENT_AMT                               
                        ,CALL_QUEUE_ID                                  
                        ,SORT_ORDER                                     
                        ,PHONE_TYPE                                     
                        ,PHONE                                          
                        ,CUST_NAME                                      
                        ,SPOUSE_NAME                                    
                        ,DAILY_FROM                                     
                        ,DAILY_TILL                                     
                        ,LAST_UPDATE_DT                                 
                        ,LAST_UPDATE_USERID                             
                   FROM CSS_CQ_ITEMS_MF WITH(READUNCOMMITTED)                   
               FOR READ ONLY                                           
                                                                 
A02036                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE CQ-ITEMS CURSOR WITH HOLD FOR                            
MFA-TR*          SELECT  ACCOUNT_NO                                             
MFA-TR*                 ,RECORD_CREATION_DT                                     
MFA-TR*                 ,NON_UTIL_ARREARS                                       
MFA-TR*                 ,UTIL_ARREARS                                           
MFA-TR*                 ,AR_TRANS_BALANCE                                       
MFA-TR*                 ,LAST_PAYMENT_DT                                        
MFA-TR*                 ,LAST_PAYMENT_AMT                                       
MFA-TR*                 ,CALL_QUEUE_ID                                          
MFA-TR*                 ,SORT_ORDER                                             
MFA-TR*                 ,PHONE_TYPE                                             
MFA-TR*                 ,PHONE                                                  
MFA-TR*                 ,CUST_NAME                                              
MFA-TR*                 ,SPOUSE_NAME                                            
MFA-TR*                 ,DAILY_FROM                                             
MFA-TR*                 ,DAILY_TILL                                             
MFA-TR*                 ,LAST_UPDATE_DT                                         
MFA-TR*                 ,LAST_UPDATE_USERID                                     
MFA-TR*            FROM CSS_CQ_ITEMS_MF                                         
MFA-TR*        FOR FETCH ONLY                                                   
MFA-TR*        WITH UR                                                          
MFA-TR*    QUERYNO 7010                                                         
MFA-TR*    END-EXEC.                                                    33080000
      *                                                                 15057000
      *****************************************************************         
      ** CURSOR DECLARATION TO GET THE BEACON SCORE FOR EACH CUSTOMER           
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
               DECLARE BEACON-SCORE-CSR CURSOR WITH HOLD FOR            
                 SELECT TOP(1) CK.BEACON_SCORE,
              CK.CR_HIST_TRAN_DT,
              REPLACE(CONVERT(CHAR(8), CK.CR_HIST_TRAN_TM, 108), ':', 
           '.') CR_HIST_TRAN_TM,
              CK.ADDL_CRED_SCORE,
              CK.SCORE_MODEL_CD                              
                   FROM  CSS_CREDIT_HIST CK WITH(READUNCOMMITTED)               
                  WHERE  CK.CUSTOMER_NO = :AT-CUSTOMER-NO               
                  ORDER BY  CK.CR_HIST_TRAN_DT DESC                     
                           ,CR_HIST_TRAN_TM DESC                     
                                                    
                                                                 
A02036                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE BEACON-SCORE-CSR CURSOR WITH HOLD FOR                    
MFA-TR*          SELECT  CK.BEACON_SCORE                                        
MFA-TR*                 ,CK.CR_HIST_TRAN_DT                                     
MFA-TR*                 ,CK.CR_HIST_TRAN_TM                                     
MFA-TR*                 ,CK.ADDL_CRED_SCORE                                     
MFA-TR*                 ,CK.SCORE_MODEL_CD                                      
MFA-TR*            FROM  CSS_CREDIT_HIST CK                                     
MFA-TR*           WHERE  CK.CUSTOMER_NO = :AT-CUSTOMER-NO                       
MFA-TR*           ORDER BY  CK.CR_HIST_TRAN_DT DESC                             
MFA-TR*                    ,CK.CR_HIST_TRAN_TM DESC                             
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*          WITH UR                                                        
MFA-TR*    QUERYNO 7110                                                         
MFA-TR*    END-EXEC.                                                    33080000
      *                                                                 15057000
      ********************************************************                  
      ********************************************************                  
       LINKAGE SECTION.                                                 
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
           PERFORM 2000-PROCESS-INPUT  THRU 2000-EXIT.                  
           PERFORM 9000-TERMINATE      THRU 9000-EXIT.                  
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   OPENS OUTPUT FILE AND GET DATABASE                           *        
      ******************************************************************        
       0100-INITIALIZATION.                                             
      *                                                                         
           OPEN OUTPUT FCSCA244-FILE.                                   
           IF FCA244-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '**  PCSCA244 PROCESSING ERROR             **'   
               DISPLAY '**    OPEN ERROR OF FCSCA244 - OUTPUT FILE'     
               DISPLAY '**    FILE STATUS = ' WS-FCA244-STATUS          
               DISPLAY '**  PROCESSING TERMINATED                 **'   
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
           MOVE 'DATABASE'                     TO C8-DELINQ-CD.         
           MOVE '01'                           TO C8-COMPANY-NO.        
           PERFORM 1900-SELECT-DELINQUENCY     THRU 1900-EXIT.          
           MOVE WS-HOLD-DEL-VALUE              TO WS-DATABASE.          
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 1900-SELECT-DELINQUENCY.                                    *          
      **      LOADS THE VALUES TO DETERMINE THE NUMBER OF DAYS BEFORE*          
      **      THE SECOND NOTICE DATE TO CONSIDER AN ACCOUNT FOR      *          
      **      COLLECTION QUE PROCESSING                              *          
      ****************************************************************          
       1900-SELECT-DELINQUENCY.                                         
           EXEC SQL                                                     
             SELECT DELINQ_VALUE                                        
               INTO :WS-HOLD-DEL-VALUE                                  
               FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                       
              WHERE DELINQ_CD    = :C8-DELINQ-CD                        
                AND COMPANY_NO   = :C8-COMPANY-NO                       
T35434                                                           
A02036                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DELINQ_VALUE                                                
MFA-TR*        INTO :WS-HOLD-DEL-VALUE                                          
MFA-TR*        FROM CSS_DELINQUENCY                                             
MFA-TR*       WHERE DELINQ_CD    = :C8-DELINQ-CD                                
MFA-TR*         AND COMPANY_NO   = :C8-COMPANY-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*    QUERYNO 1900                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '************ PCSCA244 ********************'      
              DISPLAY ' DELINQUENCY CODE ' C8-DELINQ-CD                 
              DISPLAY ' DELINQUENCY COMPANY ' C8-COMPANY-NO             
              DISPLAY '** DELINQUENCY TABLE  '                          
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** 1900 :  RETURN CODE ERROR - SELECT '          
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       1900-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      **  THIS IS THE MAIN PROCESSING PARAGRAPH WHICH GETS THE ACCOUNT *        
      **  NUMBERS AND ALSO ALL THE INFORMATION FOR THE OUTPUT FILE.    *        
      ******************************************************************        
       2000-PROCESS-INPUT.                                              
           MOVE ZEROS TO WS-LAST-PAYMENT-DT-NULL.                       
           PERFORM 7000-OPEN-CQ-ITEMS-CURSOR THRU 7000-EXIT.            
           PERFORM 7010-FETCH-CQ-ITEMS-CURSOR  THRU 7010-EXIT.          
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
               INITIALIZE FIOCA244                                      
               MOVE IQ-ACCOUNT-NO TO AT-ACCOUNT-NO                      
               PERFORM 2200-GET-ACCT-DETAILS  THRU 2200-EXIT            
A02068         MOVE AT-DATE-BILL-DAY-00   TO E-FCA244-DATE-BILL-DAY-00  
A02068         MOVE AT-DATE-BILL-DAY-30   TO E-FCA244-DATE-BILL-DAY-30  
A02068         MOVE AT-DATE-BILL-DAY-60   TO E-FCA244-DATE-BILL-DAY-60  
A02068         MOVE AT-DATE-BILL-DAY-90   TO E-FCA244-DATE-BILL-DAY-90  
A02036         MOVE IQ-ACCOUNT-NO         TO HC-ACCOUNT-NO              
A02036         PERFORM 7700-SEL-CSS-COLLECT-HIST THRU 7700-EXIT         
A02036         MOVE HC-FUTURE-WORK-DT     TO E-FCA244-FUTURE-WORK-DT    
A02036         MOVE HC-WRITE-OFF-DT       TO E-FCA244-WRITE-OFF-DT      
               PERFORM 4000-MAIL-NAME-ADDRESS THRU 4000-EXIT            
               PERFORM 2400-GET-NAME          THRU 2400-EXIT            
               MOVE IQ-ACCOUNT-NO         TO E-FCA244-ACCOUNT-NO        
               MOVE IQ-RECORD-CREATION-DT TO E-FCA244-RECORD-CREATION-DT
               MOVE WS-NAME-FCA244        TO E-FCA244-CUST-NAME         
               MOVE WS-PR-STREET          TO E-FCA244-SERV-STREET       
A00699         UNSTRING WS-PR-ADDR-CITY-STATE                           
A00699          DELIMITED BY ALL " "                                    
A00699                INTO WS-CITY1-C WS-CITY2-C WS-CITY3-C WS-STATE-C  
A00699         END-UNSTRING                                             
A00699          IF WS-STATE-C = SPACES AND WS-CITY3-C = SPACES          
A00699            MOVE WS-CITY1-C TO WS-CITY                            
A00699          ELSE                                                    
A00699            IF WS-STATE-C = SPACES                                
A00699                STRING  WS-CITY1-C DELIMITED BY " "               
A00699                    " " DELIMITED BY SIZE                         
A00699                    WS-CITY2-C DELIMITED BY SPACE                 
A00699                    INTO WS-CITY                                  
A00699            ELSE                                                  
A00699                STRING  WS-CITY1-C DELIMITED BY " "               
A00699                    " " DELIMITED BY SIZE                         
A00699                    WS-CITY2-C DELIMITED BY SPACE                 
A00699                    " " DELIMITED BY SIZE                         
A00699                    WS-CITY3-C DELIMITED BY SPACE                 
A00699                    INTO WS-CITY                                  
A00699            END-IF                                                
A00699          END-IF                                                  
A00699         UNSTRING FUNCTION REVERSE (WS-PR-ADDR-CITY-STATE)        
A00699            DELIMITED BY ALL " "                                  
A00699                INTO WS-SPACE WS-STATE-S                          
A00699         END-UNSTRING                                             
A00699         MOVE FUNCTION REVERSE (WS-STATE-S) TO WS-STATE           
A00699         MOVE SPACES                TO WS-CITY1-C                 
A00699                                       WS-CITY2-C                 
A00699                                       WS-CITY3-C                 
A00699                                       WS-STATE-C                 
               MOVE WS-CITY               TO E-FCA244-SERV-CITY         
               MOVE WS-STATE              TO E-FCA244-SERV-STATE        
               MOVE WS-ZIP-CODE           TO E-FCA244-SERV-ZIP          
               MOVE WS-HOME TO WS-PHONE-TYPE                            
               PERFORM 2500-GET-CUST-PHONE-NO THRU 2500-EXIT            
               IF WS-PHONE-NO = SPACES                                  
                   MOVE WS-BUSINESS TO WS-PHONE-TYPE                    
                   PERFORM 2500-GET-CUST-PHONE-NO THRU 2500-EXIT        
               END-IF                                                   
               MOVE WS-PHONE-NO           TO E-FCA244-CUST-PHONE-H      
               MOVE WS-WORK TO WS-PHONE-TYPE                            
               PERFORM 2500-GET-CUST-PHONE-NO THRU 2500-EXIT            
               MOVE WS-PHONE-NO           TO E-FCA244-CUST-PHONE-W      
               MOVE WS-EXTENSION-NO       TO E-FCA244-CUST-PHONE-W-EXT  
               MOVE WS-HOME TO WS-PHONE-TYPE                            
               PERFORM 2550-GET-CONT-PHONE-NO THRU 2550-EXIT            
               MOVE WS-PHONE-NO           TO E-FCA244-CONT-PHONE-H      
               MOVE WS-WORK TO WS-PHONE-TYPE                            
               PERFORM 2550-GET-CONT-PHONE-NO THRU 2550-EXIT            
               MOVE WS-PHONE-NO           TO E-FCA244-CONT-PHONE-W      
               MOVE WS-EXTENSION-NO       TO E-FCA244-CONT-PHONE-W-EXT  
               MOVE IQ-PHONE-TYPE         TO E-FCA244-PHONE-NO-TYPE     
               MOVE IQ-CALL-QUEUE-ID      TO E-FCA244-CALL-QUEUE-ID     
               MOVE IQ-AR-TRANS-BALANCE   TO E-FCA244-AR-TRANS-BALANCE  
               MOVE IQ-NON-UTIL-ARREARS   TO E-FCA244-NON-UTIL-ARREARS  
               MOVE IQ-UTIL-ARREARS       TO E-FCA244-UTIL-ARREARS      
C32694         MOVE IQ-ACCOUNT-NO TO CL-ACCOUNT-NO                      
               PERFORM 2300-GET-SONP-DATE THRU 2300-EXIT                
               MOVE WS-DNP-DATE           TO E-FCA244-SONP-DATE         
               MOVE SPACES                TO WS-SNAME-FCA244-NUSED      
               MOVE IQ-SPOUSE-NAME-TEXT   TO WS-SNAME-FCA244-USED       
               MOVE WS-SPOUSE-NAME-FCA244 TO E-FCA244-SPOUSE-NAME       
               MOVE IQ-LAST-PAYMENT-DT    TO E-FCA244-LAST-PAYMENT-DT   
               MOVE IQ-LAST-PAYMENT-AMT   TO E-FCA244-LAST-PAYMENT-AMT  
               PERFORM 2600-GET-LOCAL-OFFICE-NAME THRU 2600-EXIT        
               MOVE B1-LOCAL-OFFICE-DESC  TO E-FCA244-LOCAL-OFFICE-NAME 
               MOVE AT-LOCAL-OFFICE       TO E-FCA244-LOCAL-OFFICE-NO   
               PERFORM 2700-GET-NSF-HIST THRU 2700-EXIT                 
               MOVE WS-NSF-ITEMS-MOS12    TO E-FCA244-RTN-CKS-LAST-MOS12
               MOVE ZEROES                TO E-FCA244-CALL-BACK-TIME    
               PERFORM 2800-GET-ACCT-PSWD THRU 2800-EXIT                
               MOVE CE-PASSWORD-TX        TO E-FCA244-ACCT-PASSWORD     
               MOVE AT-CODE-ACCT-STAT     TO E-FCA244-ACCT-STATUS       
               PERFORM 2900-GET-CASH-ONLY-IND THRU 2900-EXIT            
               MOVE CZ-CASH-ONLY-FL       TO E-FCA244-CASH-ONLY-IND     
               MOVE IQ-SORT-ORDER         TO E-FCA244-SORT-ORDER        
               MOVE IQ-DAILY-FROM         TO E-FCA244-DAILY-FROM        
               MOVE IQ-DAILY-TILL         TO E-FCA244-DAILY-TILL        
               MOVE IQ-LAST-UPDATE-DT     TO E-FCA244-LAST-UPDATE-DT    
               MOVE IQ-LAST-UPDATE-USERID-TEXT                          
                                          TO E-FCA244-LAST-UPDATE-USERID
               INSPECT E-FCA244-LAST-UPDATE-USERID REPLACING ALL        
                                          LOW-VALUES BY SPACES          
               MOVE AT-COMPANY-NO         TO E-FCA244-COMPANY-NO        
               MOVE SPACES                TO E-FCA244-COMPANY-NAME      
C33247         MOVE SPACES                TO E-FCA244-SENIOR-FLAG       
C33247         MOVE SPACES                TO E-FCA244-REG-GROUP-CD      
               IF CSR-DATABASE                                          
                   IF AT-COMPANY-NO = '01'                              
                       MOVE 'SCEG  ' TO E-FCA244-COMPANY-NAME           
C33247                 MOVE SPACES   TO E-FCA244-RATE-PLAN              
                   END-IF                                               
                   IF AT-COMPANY-NO = '26'                              
                       MOVE 'PSNC  ' TO E-FCA244-COMPANY-NAME           
C33247                 MOVE IQ-ACCOUNT-NO TO UT-ACCOUNT-NO              
C33247                 MOVE 'G'           TO UT-CODE-UTIL-TYPE          
C33247                 MOVE 1             TO UT-IC-NO                   
C33247                 PERFORM 7440-SELECT-UTIL-ENVRNMT THRU 7440-EXIT  
                   END-IF                                               
               END-IF                                                   
               IF SEB-DATABASE                                          
C33247             MOVE IQ-ACCOUNT-NO TO UT-ACCOUNT-NO                  
C33247             MOVE 'G'           TO UT-CODE-UTIL-TYPE              
C33247             MOVE 1             TO UT-IC-NO                       
C33247             PERFORM 7440-SELECT-UTIL-ENVRNMT THRU 7440-EXIT      
                   MOVE 'N' TO WS-SEB-REGULATED-FLAG                    
                   PERFORM 7430-SELECT-REG-PROFILE THRU 7430-EXIT       
                   IF AT-COMPANY-NO = '01'                              
                       IF SEB-REGULATED                                 
                           MOVE 'SEBR  ' TO E-FCA244-COMPANY-NAME       
C33247                     MOVE LR-SENIOR-FL TO E-FCA244-SENIOR-FLAG    
C33247                     MOVE LR-REG-GROUP-CD TO E-FCA244-REG-GROUP-CD
                       ELSE                                             
                           MOVE 'SEB   ' TO E-FCA244-COMPANY-NAME       
                       END-IF                                           
                   END-IF                                               
               END-IF                                                   
               MOVE AT-BILL-CYCLE         TO E-FCA244-ACCT-BILLING-CYCLE
C33247         PERFORM 7100-OPEN-BEACON-SCORE-CSR   THRU 7100-EXIT      
C33247         PERFORM 7110-FETCH-BEACON-SCORE-CSR  THRU 7110-EXIT      
C33247         PERFORM 7120-CLOSE-BEACON-SCORE-CSR  THRU 7120-EXIT      
C33247         MOVE CK-BEACON-SCORE       TO E-FCA244-BEACON-SCORE      
C33247         PERFORM 2950-GET-ORIGINATION-CD      THRU 2950-EXIT      
               MOVE XM-ORIGINATION-CD     TO E-FCA244-ORIGINATION-CD    
               WRITE FIOCA244                                           
               MOVE ZEROS TO WS-LAST-PAYMENT-DT-NULL                    
               MOVE SPACES TO IQ-LAST-UPDATE-USERID-TEXT                
               PERFORM 7010-FETCH-CQ-ITEMS-CURSOR THRU 7010-EXIT        
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7020-CLOSE-CQ-ITEMS-CURSOR  THRU 7020-EXIT.          
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  GETS CUSTOMER NO, TOTAL AR BALANCE AND OTHER DETAILS FROM    *        
      **  CSS_ACCOUNT                                                  *        
      ******************************************************************        
       2200-GET-ACCT-DETAILS.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT AT.CODES_DATA_PRESENT                             
                     ,AT.COMPANY_NO                                     
                     ,AT.BILL_CYCLE                                     
                     ,AT.CODE_ACCT_STAT                                 
                     ,AT.CREDIT_GROUP                                   
                     ,AT.LOCAL_OFFICE                                   
                     ,AT.PREMISE_NO                                     
                     ,AT.CUSTOMER_NO                                    
                     ,AT.ACCOUNT_TYPE_CODE                              
                     ,AT.ADDRESS_FORMAT                                 
                     ,AT.ADDRESS_ID                                     
                     ,AT.TOTAL_AR_BALANCE                               
                     ,AT.CODE_DISC_OK                                   
A02068               ,AT.DATE_BILL_DAY_00                               
A02068               ,AT.DATE_BILL_DAY_30                               
A02068               ,AT.DATE_BILL_DAY_60                               
A02068               ,AT.DATE_BILL_DAY_90                               
                INTO  :AT-CODES-DATA-PRESENT                            
                     ,:AT-COMPANY-NO                                    
                     ,:AT-BILL-CYCLE                                    
                     ,:AT-CODE-ACCT-STAT                                
                     ,:AT-CREDIT-GROUP                                  
                     ,:AT-LOCAL-OFFICE                                  
                     ,:AT-PREMISE-NO                                    
                     ,:AT-CUSTOMER-NO                                   
                     ,:AT-ACCOUNT-TYPE-CODE                             
                     ,:AT-ADDRESS-FORMAT                                
                     ,:AT-ADDRESS-ID                                    
                     ,:AT-TOTAL-AR-BALANCE                              
                     ,:AT-CODE-DISC-OK                                  
A02068               ,:AT-DATE-BILL-DAY-00                              
A02068               ,:AT-DATE-BILL-DAY-30                              
A02068               ,:AT-DATE-BILL-DAY-60                              
A02068               ,:AT-DATE-BILL-DAY-90                              
                FROM  CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
               WHERE  AT.ACCOUNT_NO = :AT-ACCOUNT-NO                    
T35434                                                           
A02036                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     32960000
MFA-TR*        SELECT AT.CODES_DATA_PRESENT                                     
MFA-TR*              ,AT.COMPANY_NO                                             
MFA-TR*              ,AT.BILL_CYCLE                                             
MFA-TR*              ,AT.CODE_ACCT_STAT                                         
MFA-TR*              ,AT.CREDIT_GROUP                                           
MFA-TR*              ,AT.LOCAL_OFFICE                                           
MFA-TR*              ,AT.PREMISE_NO                                             
MFA-TR*              ,AT.CUSTOMER_NO                                            
MFA-TR*              ,AT.ACCOUNT_TYPE_CODE                                      
MFA-TR*              ,AT.ADDRESS_FORMAT                                         
MFA-TR*              ,AT.ADDRESS_ID                                             
MFA-TR*              ,AT.TOTAL_AR_BALANCE                                       
MFA-TR*              ,AT.CODE_DISC_OK                                           
MFA-TR*              ,AT.DATE_BILL_DAY_00                                       
MFA-TR*              ,AT.DATE_BILL_DAY_30                                       
MFA-TR*              ,AT.DATE_BILL_DAY_60                                       
MFA-TR*              ,AT.DATE_BILL_DAY_90                                       
MFA-TR*         INTO  :AT-CODES-DATA-PRESENT                                    
MFA-TR*              ,:AT-COMPANY-NO                                            
MFA-TR*              ,:AT-BILL-CYCLE                                            
MFA-TR*              ,:AT-CODE-ACCT-STAT                                        
MFA-TR*              ,:AT-CREDIT-GROUP                                          
MFA-TR*              ,:AT-LOCAL-OFFICE                                          
MFA-TR*              ,:AT-PREMISE-NO                                            
MFA-TR*              ,:AT-CUSTOMER-NO                                           
MFA-TR*              ,:AT-ACCOUNT-TYPE-CODE                                     
MFA-TR*              ,:AT-ADDRESS-FORMAT                                        
MFA-TR*              ,:AT-ADDRESS-ID                                            
MFA-TR*              ,:AT-TOTAL-AR-BALANCE                                      
MFA-TR*              ,:AT-CODE-DISC-OK                                          
MFA-TR*              ,:AT-DATE-BILL-DAY-00                                      
MFA-TR*              ,:AT-DATE-BILL-DAY-30                                      
MFA-TR*              ,:AT-DATE-BILL-DAY-60                                      
MFA-TR*              ,:AT-DATE-BILL-DAY-90                                      
MFA-TR*         FROM  CSS_ACCOUNT AT                                            
MFA-TR*        WHERE  AT.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*        WITH UR                                                          
MFA-TR*    QUERYNO 2200                                                         
MFA-TR*    END-EXEC.                                                    33080000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 33090000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT      
           ELSE                                                         
               DISPLAY '********** PCSCA244 ABORT ************'         
               DISPLAY '* 2200-GET-ACCT-DET                  *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA244 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  GETS FUTURE SONP DATE.  THIS DATE CURRENTLY APPEARS ON THE   *        
C32694**  COLLECTIONS PANEL AS THE DNP DATE.  THE LOGIC USED IS DIFFER *        
C32694**  THAN THE PANEL AND WAS APPROVED BY THE USERS.                *        
      ******************************************************************        
       2300-GET-SONP-DATE.                                              
      *                                                                         
C32694     MOVE LOW-VALUES TO WS-DATE-HOLD.                             
C32694     MOVE SPACES TO E-FCA244-SONP-DATE.                           
C32694     MOVE 'D' TO CL-CODE-NOTICE-TYPE.                             
C32694     PERFORM 7460-SELECT-CSS-CRED-COLL THRU 7460-EXIT.            
C32694     IF CL-DATE-CREDIT-ACTION NOT EQUAL LOW-VALUES                
C32694         MOVE CL-DATE-CREDIT-ACTION TO WS-DATE-HOLD               
C32694         PERFORM 2305-REFORMAT-DATE THRU 2305-EXIT                
C32694         MOVE WS-DNP-DATE TO E-FCA244-SONP-DATE                   
C32694     END-IF.                                                      
C32694*                                                                         
C32694     MOVE SPACES TO E-FCA244-RTND-CK-DNP-DATE.                    
C32694     MOVE 'H' TO CL-CODE-NOTICE-TYPE.                             
C32694     PERFORM 7460-SELECT-CSS-CRED-COLL THRU 7460-EXIT.            
C32694     IF CL-DATE-CREDIT-ACTION NOT EQUAL LOW-VALUES                
C32694         MOVE CL-DATE-CREDIT-ACTION TO WS-DATE-HOLD               
C32694         PERFORM 2305-REFORMAT-DATE THRU 2305-EXIT                
C32694         MOVE  WS-RTND-CK-DNP-DATE  TO E-FCA244-RTND-CK-DNP-DATE  
C32694     END-IF.                                                      
C32694*                                                                         
C32694     MOVE SPACES TO E-FCA244-XCEPTL-DNP-DATE.                     
C32694     MOVE 'G' TO CL-CODE-NOTICE-TYPE.                             
C32694     PERFORM 7460-SELECT-CSS-CRED-COLL THRU 7460-EXIT.            
C32694     IF CL-DATE-CREDIT-ACTION NOT EQUAL LOW-VALUES                
C32694         MOVE CL-DATE-CREDIT-ACTION TO WS-DATE-HOLD               
C32694         PERFORM 2305-REFORMAT-DATE THRU 2305-EXIT                
C32694         MOVE WS-XCEPTL-DNP-DATE    TO E-FCA244-XCEPTL-DNP-DATE   
C32694     END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C32694******************************************************************        
C32694**  REFORMATS DATES SUCH AS SONP AND DNP DATES.                  *        
C32694******************************************************************        
C32694 2305-REFORMAT-DATE.                                              
C32694     MOVE SPACES TO WS-DNP-DATE1.                                 
C32694     IF WS-DATE-HOLD = LOW-VALUES                                 
C32694         MOVE SPACES TO WS-DNP-DATE                               
C32694                        WS-RTND-CK-DNP-DATE                       
C32694                        WS-XCEPTL-DNP-DATE                        
C32694     ELSE                                                         
C32694         MOVE WS-DATE-HOLD TO WS-RTND-CK-DNP-DATE                 
C32694                              WS-XCEPTL-DNP-DATE                  
C32694         PERFORM 7802-GET-USA-DATE THRU 7802-EXIT                 
C32694         MOVE WS-DATE-HOLD-USA     TO WS-DNP-DATE                 
C32694     END-IF.                                                      
C32694*                                                                         
C32694 2305-EXIT.                                                       
C32694     EXIT.                                                        
C32694*                                                                         
      *                                                                         
      ******************************************************************        
      **  2400-GET-NAME.                                               *        
      **  GETS CUSTOMER NAME.                                          *        
      ******************************************************************        
       2400-GET-NAME.                                                   
           MOVE SPACES TO WS-NAME-FCA244.                               
      *                                                                         
           EXEC SQL                                                     
             SELECT FIRST_NAME                                          
                   ,LAST_NAME                                           
                   ,MIDDLE_NAME                                         
                   ,FULL_NAME                                           
               INTO :DQ-FIRST-NAME                                      
                   ,:DQ-LAST-NAME                                       
                   ,:DQ-MIDDLE-NAME                                     
                   ,:DQ-FULL-NAME                                       
               FROM CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)                 
                   ,CSS_NAME DQ WITH(READUNCOMMITTED)                           
              WHERE HT.ACCOUNT_NO = :AT-ACCOUNT-NO                      
                AND HT.NAME_ID = DQ.NAME_ID                             
                AND DQ.NAME_TYPE = :WS-CUSTOMER                         
                AND HT.CUSTOMER_ROLE_CD = ' '                           
T35434                                                           
A02036                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT FIRST_NAME                                                  
MFA-TR*            ,LAST_NAME                                                   
MFA-TR*            ,MIDDLE_NAME                                                 
MFA-TR*            ,FULL_NAME                                                   
MFA-TR*        INTO :DQ-FIRST-NAME                                              
MFA-TR*            ,:DQ-LAST-NAME                                               
MFA-TR*            ,:DQ-MIDDLE-NAME                                             
MFA-TR*            ,:DQ-FULL-NAME                                               
MFA-TR*        FROM CSS_NAME_ACCT_XREF HT                                       
MFA-TR*            ,CSS_NAME DQ                                                 
MFA-TR*       WHERE HT.ACCOUNT_NO = :AT-ACCOUNT-NO                              
MFA-TR*         AND HT.NAME_ID = DQ.NAME_ID                                     
MFA-TR*         AND DQ.NAME_TYPE = :WS-CUSTOMER                                 
MFA-TR*         AND HT.CUSTOMER_ROLE_CD = ' '                                   
MFA-TR*         WITH UR                                                         
MFA-TR*    QUERYNO 2400                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              IF DQ-FIRST-NAME > SPACES AND                             
                 DQ-LAST-NAME > SPACES                                  
                   MOVE DQ-LAST-NAME TO WS-LNAME-FCA244                 
                   MOVE DQ-FIRST-NAME TO WS-FNAME-FCA244                
                   MOVE DQ-MIDDLE-NAME TO WS-MNAME-FCA244               
              ELSE                                                      
                   MOVE DQ-FULL-NAME TO WS-NAME-FCA244                  
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL TO NOT-FOUND               
                 MOVE SPACES TO WS-NAME-FCA244                          
              ELSE                                                      
                 DISPLAY '************* PCSCA244 *******************'   
                 DISPLAY ' NAME ID ', AT-ACCOUNT-NO                     
                 DISPLAY '** CSS_NAME_ACCT_XREF  '                      
                 DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO               
                 DISPLAY '** 2400 :  RETURN CODE ERROR - SELECT '       
                 DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE       
                 DISPLAY '******************************************'   
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  2500-GET-CUST-PHONE-NO.                                      *        
      **  GETS CUSTOMER PHONE NUMBER                                   *        
      ******************************************************************        
       2500-GET-CUST-PHONE-NO.                                          
           EXEC SQL                                                     
              SELECT CB.PHONE_NO                                        
                    ,CB.EXTENSION_NO                                    
              INTO  :CB-PHONE-NO                                        
                   ,:CB-EXTENSION-NO                                    
              FROM  CSS_CUST_PHONE CB WITH(READUNCOMMITTED)                     
              WHERE  CB.CUSTOMER_NO     = :AT-CUSTOMER-NO               
ACT188        AND    CB.CUSTOMER_TYPE   = 'C'                           
              AND    CB.PHONE_TYPE      = :WS-PHONE-TYPE                
T35434                                                           
A02036                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CB.PHONE_NO                                                
MFA-TR*             ,CB.EXTENSION_NO                                            
MFA-TR*       INTO  :CB-PHONE-NO                                                
MFA-TR*            ,:CB-EXTENSION-NO                                            
MFA-TR*       FROM  CSS_CUST_PHONE CB                                           
MFA-TR*       WHERE  CB.CUSTOMER_NO     = :AT-CUSTOMER-NO                       
MFA-TR*       AND    CB.CUSTOMER_TYPE   = 'C'                                   
MFA-TR*       AND    CB.PHONE_TYPE      = :WS-PHONE-TYPE                        
MFA-TR*       WITH UR                                                           
MFA-TR*    QUERYNO 2500                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              MOVE CB-PHONE-NO TO WS-PHONE-NO                           
              MOVE CB-EXTENSION-NO TO WS-EXTENSION-NO                   
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE EQUAL TO NOT-FOUND                
                MOVE SPACES TO WS-PHONE-NO                              
                               WS-EXTENSION-NO                          
             ELSE                                                       
                DISPLAY '*********** PCSCA244 *********************'    
                DISPLAY '** 2500 :  RETURN CODE ERROR - SELECT '        
                DISPLAY ' ACCOUNT NO ', AT-ACCOUNT-NO                   
                DISPLAY '** CSS_CUST_PHONE  '                           
                DISPLAY '** CUSTOMER NO = ' AT-CUSTOMER-NO              
                DISPLAY '** PHONE TYPE = ' WS-PHONE-TYPE                
                DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE        
                DISPLAY '******************************************'    
                PERFORM 9900-ABEND THRU 9900-EXIT                       
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  2550-GET-CONT-PHONE-NO.                                      *        
      **  GETS CONTACT PHONE NUMBER                                    *        
      ******************************************************************        
       2550-GET-CONT-PHONE-NO.                                          
           EXEC SQL                                                     
              SELECT LP.PHONE_NO                                        
                    ,LP.EXTENSION_NO                                    
              INTO  :LP-PHONE-NO                                        
                   ,:LP-EXTENSION-NO                                    
              FROM  CSS_CONTACT_CUST DT WITH(READUNCOMMITTED)                   
                   ,CSS_CONTACT_PHONE LP WITH(READUNCOMMITTED)                  
              WHERE  DT.CUSTOMER_NO    = :AT-CUSTOMER-NO                
A02036        AND    LP.CONTACT_ID     = DT.CONTACT_ID                  
              AND    LP.PHONE_TYPE     = :WS-PHONE-TYPE                 
T35434                                                           
A02036                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LP.PHONE_NO                                                
MFA-TR*             ,LP.EXTENSION_NO                                            
MFA-TR*       INTO  :LP-PHONE-NO                                                
MFA-TR*            ,:LP-EXTENSION-NO                                            
MFA-TR*       FROM  CSS_CONTACT_CUST DT                                         
MFA-TR*            ,CSS_CONTACT_PHONE LP                                        
MFA-TR*       WHERE  DT.CUSTOMER_NO    = :AT-CUSTOMER-NO                        
MFA-TR*       AND    LP.CONTACT_ID     = DT.CONTACT_ID                          
MFA-TR*       AND    LP.PHONE_TYPE     = :WS-PHONE-TYPE                         
MFA-TR*       WITH UR                                                           
MFA-TR*    QUERYNO 2550                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL OR -811    
              MOVE LP-PHONE-NO TO WS-PHONE-NO                           
              MOVE LP-EXTENSION-NO TO WS-EXTENSION-NO                   
           ELSE                                                         
A02036       IF WS-ACTIVE-RETURN-CODE EQUAL TO NOT-FOUND                
                MOVE SPACES TO WS-PHONE-NO                              
                               WS-EXTENSION-NO                          
             ELSE                                                       
                DISPLAY '*********** PCSCA244 *********************'    
                DISPLAY '** 2550 :  RETURN CODE ERROR - SELECT '        
                DISPLAY ' CUSTOMER NO ', AT-CUSTOMER-NO                 
                DISPLAY ' CONTACT ID ', LP-CONTACT-ID                   
                DISPLAY '** CSS_CONTACT_PHONE  '                        
                DISPLAY '** PHONE TYPE = ' WS-PHONE-TYPE                
                DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE        
                DISPLAY '******************************************'    
                PERFORM 9900-ABEND THRU 9900-EXIT                       
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       2550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  2600-GET-LOCAL-OFFICE-NAME.                                  *        
      **  GETS LOCAL OFFICE NAME/DESCRIPTION                           *        
      ******************************************************************        
       2600-GET-LOCAL-OFFICE-NAME.                                      
           EXEC SQL                                                     
              SELECT B1.LOCAL_OFFICE_DESC                               
              INTO  :B1-LOCAL-OFFICE-DESC                               
              FROM  CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)                   
              WHERE  B1.COMPANY_NO   = :AT-COMPANY-NO                   
              AND    B1.LOCAL_OFFICE = :AT-LOCAL-OFFICE                 
T35434                                                           
A02036                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT B1.LOCAL_OFFICE_DESC                                       
MFA-TR*       INTO  :B1-LOCAL-OFFICE-DESC                                       
MFA-TR*       FROM  CSS_LOCAL_OFFICE B1                                         
MFA-TR*       WHERE  B1.COMPANY_NO   = :AT-COMPANY-NO                           
MFA-TR*       AND    B1.LOCAL_OFFICE = :AT-LOCAL-OFFICE                         
MFA-TR*       WITH UR                                                           
MFA-TR*    QUERYNO 2600                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE EQUAL TO NOT-FOUND                
                MOVE '* NO LOCAL OFFICE NAME' TO B1-LOCAL-OFFICE-DESC   
             ELSE                                                       
                DISPLAY '*********** PCSCA244 *********************'    
                DISPLAY '** 2600 :  RETURN CODE ERROR - SELECT '        
                DISPLAY ' COMPANY NO ', AT-COMPANY-NO                   
                DISPLAY ' LOCAL OFFICE ', AT-LOCAL-OFFICE               
                DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE        
                DISPLAY '******************************************'    
                PERFORM 9900-ABEND THRU 9900-EXIT                       
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  2700-GET-NSF-HIST.                                           *        
      **  GET COUNT OF NSF ITEMS FOR LAST 12 MONTHS                    *        
      ******************************************************************        
       2700-GET-NSF-HIST.                                               
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
              INTO  :WS-NSF-ITEMS-MOS12                                 
              FROM  CSS_NSF_HIST                                        
              WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                        
                AND DATE_TRAN > (DATEADD( YEAR, -1, 
           CAST(SYSDATETIMEOFFSET() AS DATE) ))                
A02036                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*       INTO  :WS-NSF-ITEMS-MOS12                                         
MFA-TR*       FROM  CSS_NSF_HIST                                                
MFA-TR*       WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                                
MFA-TR*         AND DATE_TRAN > (CURRENT DATE - 1 YEARS)                        
MFA-TR*    QUERYNO 2700                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE EQUAL TO NOT-FOUND                
                MOVE ZEROES TO B1-LOCAL-OFFICE-DESC                     
             ELSE                                                       
                DISPLAY '*********** PCSCA244 *********************'    
                DISPLAY '** 2700 :  RETURN CODE ERROR - SELECT '        
                DISPLAY ' ACCOUNT NO ', AT-ACCOUNT-NO                   
                DISPLAY ' DATE       ', AT-LOCAL-OFFICE                 
                DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE        
                DISPLAY '******************************************'    
                PERFORM 9900-ABEND THRU 9900-EXIT                       
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  2800-GET-ACCT-PSWD.                                          *        
      **  GETS LOCAL OFFICE NAME/DESCRIPTION                           *        
      ******************************************************************        
       2800-GET-ACCT-PSWD.                                              
           EXEC SQL                                                     
              SELECT CE.PASSWORD_TX                                     
              INTO  :CE-PASSWORD-TX                                     
              FROM  CSS_CUST_STATS CE WITH(READUNCOMMITTED)                     
              WHERE  CE.CUSTOMER_NO = :AT-CUSTOMER-NO                   
ACT188          AND  CE.CUSTOMER_TYPE = 'C'                             
T35434                                                           
A02036                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CE.PASSWORD_TX                                             
MFA-TR*       INTO  :CE-PASSWORD-TX                                             
MFA-TR*       FROM  CSS_CUST_STATS CE                                           
MFA-TR*       WHERE  CE.CUSTOMER_NO = :AT-CUSTOMER-NO                           
MFA-TR*         AND  CE.CUSTOMER_TYPE = 'C'                                     
MFA-TR*       WITH UR                                                           
MFA-TR*    QUERYNO 2800                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE EQUAL TO NOT-FOUND                
                MOVE SPACES TO CE-PASSWORD-TX                           
             ELSE                                                       
                DISPLAY '*********** PCSCA244 *********************'    
                DISPLAY '** 2800 :  RETURN CODE ERROR - SELECT '        
                DISPLAY ' CUSTOMER NO ', AT-CUSTOMER-NO                 
                DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE        
                DISPLAY '******************************************'    
                PERFORM 9900-ABEND THRU 9900-EXIT                       
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  2900-GET-CASH-ONLY-IND.                                      *        
      **  GETS CASH ONLY INDICATOR                                     *        
      ******************************************************************        
       2900-GET-CASH-ONLY-IND.                                          
           EXEC SQL                                                     
              SELECT CZ.CASH_ONLY_FL                                    
              INTO  :CZ-CASH-ONLY-FL                                    
              FROM  CSS_CREDIT_PROFILE CZ WITH(READUNCOMMITTED)                 
              WHERE  CZ.ACCOUNT_NO = :AT-ACCOUNT-NO                     
T35434                                                           
A02036                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CZ.CASH_ONLY_FL                                            
MFA-TR*       INTO  :CZ-CASH-ONLY-FL                                            
MFA-TR*       FROM  CSS_CREDIT_PROFILE CZ                                       
MFA-TR*       WHERE  CZ.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*       WITH UR                                                           
MFA-TR*    QUERYNO 2900                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE EQUAL TO NOT-FOUND                
                MOVE SPACES TO CZ-CASH-ONLY-FL                          
             ELSE                                                       
                DISPLAY '*********** PCSCA244 *********************'    
                DISPLAY '** 2900 :  RETURN CODE ERROR - SELECT '        
                DISPLAY ' ACCOUNT NO ', AT-ACCOUNT-NO                   
                DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE        
                DISPLAY '******************************************'    
                PERFORM 9900-ABEND THRU 9900-EXIT                       
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  2950-GET-ORIGINATION-CD.                                     *        
      **  GETS ORIGINATION CODE FROM CSS_MKT_XREF_ACCT TABLE           *        
      ******************************************************************        
       2950-GET-ORIGINATION-CD.                                         
           EXEC SQL                                                     
              SELECT XM.ORIGINATION_CD                                  
              INTO  :XM-ORIGINATION-CD                                  
              FROM  CSS_MKT_XREF_ACCT XM WITH(READUNCOMMITTED)                  
              WHERE  XM.ACCOUNT_NO = :AT-ACCOUNT-NO                     
                AND  XM.COMPANY_NO = :AT-COMPANY-NO                     
T35434                                                           
A02036                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT XM.ORIGINATION_CD                                          
MFA-TR*       INTO  :XM-ORIGINATION-CD                                          
MFA-TR*       FROM  CSS_MKT_XREF_ACCT XM                                        
MFA-TR*       WHERE  XM.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*         AND  XM.COMPANY_NO = :AT-COMPANY-NO                             
MFA-TR*       WITH UR                                                           
MFA-TR*    QUERYNO 2950                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE EQUAL TO NOT-FOUND                
                MOVE SPACES TO XM-ORIGINATION-CD                        
             ELSE                                                       
                DISPLAY '*********** PCSCA244 *********************'    
                DISPLAY '** 2950 :  RETURN CODE ERROR - SELECT '        
                DISPLAY ' ACCOUNT NO ', AT-ACCOUNT-NO                   
                DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE        
                DISPLAY '******************************************'    
                PERFORM 9900-ABEND THRU 9900-EXIT                       
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       2950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS14560
      *     4000-MAIL-NAME-ADDRESS.                                    *PCS14580
      ******************************************************************PCS14650
           EXEC SQL                                                             
              INCLUDE CPD00074                                          PCS42650
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************PCS14560
      *     6010-REDUCE-EMBEDDED-SPACES.                               *PCS14580
      ******************************************************************PCS14650
           EXEC SQL                                                             
              INCLUDE CPD00004                                          PCS42650
           END-EXEC.                                                            
      *                                                                         
      *                                                                 11188900
      ******************************************************************        
      **  OPENS CQ-ITEMS  CURSOR TO GET ACCOUNTS THAT ARE SCHEDULED   **        
      **  TO BE CONTACTED                                             **        
      ******************************************************************        
       7000-OPEN-CQ-ITEMS-CURSOR.                                       
           EXEC SQL                                                     
              OPEN CQ-ITEMS                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA244 ABORT ************'         
               DISPLAY '* 7000-OPEN-CQ-ITEMS-CURSOR         *'          
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROC DATE ' , WS-INPUT-DATE                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA244 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCHES INFO FROM CQ-ITEMS-MF TABLE                         **        
      ******************************************************************        
       7010-FETCH-CQ-ITEMS-CURSOR.                                      
           EXEC SQL                                                     
              FETCH CQ-ITEMS                                            
               INTO :IQ-ACCOUNT-NO                                      
                   ,:IQ-RECORD-CREATION-DT                              
                   ,:IQ-NON-UTIL-ARREARS                                
                   ,:IQ-UTIL-ARREARS                                    
                   ,:IQ-AR-TRANS-BALANCE                                
                   ,:IQ-LAST-PAYMENT-DT :WS-LAST-PAYMENT-DT-NULL        
                   ,:IQ-LAST-PAYMENT-AMT                                
                   ,:IQ-CALL-QUEUE-ID                                   
                   ,:IQ-SORT-ORDER                                      
                   ,:IQ-PHONE-TYPE                                      
                   ,:IQ-PHONE                                           
                   ,:IQ-CUST-NAME                                       
                   ,:IQ-SPOUSE-NAME                                     
                   ,:IQ-DAILY-FROM                                      
                   ,:IQ-DAILY-TILL                                      
                   ,:IQ-LAST-UPDATE-DT                                  
                   ,:IQ-LAST-UPDATE-USERID                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               IF WS-LAST-PAYMENT-DT-NULL < 0                           
                   MOVE SPACES TO IQ-LAST-PAYMENT-DT                    
               END-IF                                                   
           ELSE                                                         
               DISPLAY '********** PCSCA244 ABORT ************'         
               DISPLAY '* 7010-FETCH-CQ-ITEMS                *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROCESS DT ' , WS-INPUT-DATE                  
               DISPLAY '* ACCOUNT NO ', IQ-ACCOUNT-NO                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA244 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSES CQ-ITEMS  CURSOR                                     **        
      ******************************************************************        
       7020-CLOSE-CQ-ITEMS-CURSOR.                                      
           EXEC SQL                                                     
              CLOSE CQ-ITEMS                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA244 ABORT ************'         
               DISPLAY '* 7020-CLOSE-CQ-ITEMS-CURSOR         *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROC DATE ' , WS-INPUT-DATE                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA244 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C33247******************************************************************        
C33247**  7100-OPEN-BEACON-SCORE-CSR                                  **        
C33247**  OPENS BEACON-SCORE-CSR CURSOR TO RETRIEVE THE BEACON        **        
C33247**  SCORE FOR EACH CUSTOMER.                                    **        
C33247******************************************************************        
C33247 7100-OPEN-BEACON-SCORE-CSR.                                      
C33247     EXEC SQL                                                     
C33247        OPEN BEACON-SCORE-CSR                                     
C33247     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33247*                                                                         
C33247     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
C33247     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C33247         CONTINUE                                                 
C33247     ELSE                                                         
C33247         DISPLAY '********** PCSCA244 ABORT ************'         
C33247         DISPLAY '* 7100-OPEN-BEACON-SCORE-CSR        *'          
C33247         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
C33247         DISPLAY '* CUSTOMER NO ' , AT-CUSTOMER-NO                
C33247         DISPLAY '* PROGRAM ABORTING...                *'         
C33247         DISPLAY '********** PCSCA244 ABORT ************'         
C33247         PERFORM 9900-ABEND              THRU 9900-EXIT           
C33247     END-IF.                                                      
C33247*                                                                         
C33247 7100-EXIT.                                                       
C33247     EXIT.                                                        
C33247*                                                                         
C33247******************************************************************        
C33247**  7110-FETCH-BEACON-SCORE-CSR                                 **        
C33247**  FETCHES INFO FROM CSS_CREDIT_HIST TABLE                     **        
C33247******************************************************************        
C33247 7110-FETCH-BEACON-SCORE-CSR.                                     
C33247     EXEC SQL                                                     
C33247        FETCH BEACON-SCORE-CSR                                    
C33247         INTO :CK-BEACON-SCORE                                    
C33247             ,:CK-CR-HIST-TRAN-DT                                 
C33247             ,:CK-CR-HIST-TRAN-TM                                 
A05198             ,:CK-ADDL-CRED-SCORE                                 
A05198             ,:CK-SCORE-MODEL-CD                                  
C33247     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33247*                                                                         
C33247     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C33247     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
C33247         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
A05198            IF CK-SCORE-MODEL-CD   = 'A'                          
A05198               MOVE CK-ADDL-CRED-SCORE  TO CK-BEACON-SCORE        
A05198            END-IF                                                
C33247         ELSE                                                     
C33247            MOVE SPACES                 TO CK-BEACON-SCORE        
C33247         END-IF                                                   
C33247     ELSE                                                         
C33247         DISPLAY '********** PCSCA244 ABORT ************'         
C33247         DISPLAY '* 7110-FETCH-BEACON-SCORE-CSR        *'         
C33247         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
C33247         DISPLAY '* CUSTOMER NO ' , AT-CUSTOMER-NO                
C33247         DISPLAY '* PROGRAM ABORTING...                *'         
C33247         DISPLAY '********** PCSCA244 ABORT ************'         
C33247         PERFORM 9900-ABEND              THRU 9900-EXIT           
C33247     END-IF.                                                      
C33247*                                                                         
C33247 7110-EXIT.                                                       
C33247     EXIT.                                                        
C33247*                                                                         
C33247******************************************************************        
C33247**  7120-CLOSE-BEACON-SCORE-CSR                                 **        
C33247**  CLOSES BEACON-SCORE-CSR CURSOR                              **        
C33247******************************************************************        
C33247 7120-CLOSE-BEACON-SCORE-CSR.                                     
C33247     EXEC SQL                                                     
C33247        CLOSE BEACON-SCORE-CSR                                    
C33247     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33247*                                                                         
C33247     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C33247     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C33247         CONTINUE                                                 
C33247     ELSE                                                         
C33247         DISPLAY '********** PCSCA244 ABORT ************'         
C33247         DISPLAY '* 7120-CLOSE-BEACON-SCORE-CSR        *'         
C33247         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
C33247         DISPLAY '* PROGRAM ABORTING...                *'         
C33247         DISPLAY '********** PCSCA244 ABORT ************'         
C33247         PERFORM 9900-ABEND              THRU 9900-EXIT           
C33247     END-IF.                                                      
C33247*                                                                         
C33247 7120-EXIT.                                                       
C33247     EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7430-SELECT-REG-PROFILE.                                      *         
      *      FIND OUT IF THE ACCOUNT IS REGULATED                     *         
      *****************************************************************         
       7430-SELECT-REG-PROFILE.                                         
           EXEC SQL                                                     
C33274          SELECT REG_GROUP_CD                                     
C33274                ,SENIOR_FL                                        
C33274            INTO :LR-REG-GROUP-CD                                 
C33274                ,:LR-SENIOR-FL                                    
                FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                      
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
T35434                                                           
A02036                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT REG_GROUP_CD                                             
MFA-TR*               ,SENIOR_FL                                                
MFA-TR*           INTO :LR-REG-GROUP-CD                                         
MFA-TR*               ,:LR-SENIOR-FL                                            
MFA-TR*         FROM CSS_REG_PROFILE                                            
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*       WITH UR                                                           
MFA-TR*    QUERYNO 7430                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
C33274         IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
C33274            MOVE 'N' TO WS-SEB-REGULATED-FLAG                     
C33274         ELSE                                                     
C33274            MOVE 'Y' TO WS-SEB-REGULATED-FLAG                     
C33274         END-IF                                                   
C33274         CONTINUE                                                 
           ELSE                                                         
               DISPLAY '************** PCSCA244 ******************'     
               DISPLAY '** 7430 :  RETURN CODE ERROR - SELECT'          
               DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                   
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '************** PCSCA244 ******************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7430-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C33274*****************************************************************         
C33274* 7440-SELECT-UTIL-ENVRNMT                                      *         
C33274*      SELECTS THE RATE PLAN NO FROM CSS_UTIL_ENVRNMT           *         
C33274*****************************************************************         
C33274 7440-SELECT-UTIL-ENVRNMT.                                        
C33274     EXEC SQL                                                     
C33274          SELECT RATE_PLAN_NO                                     
C33274            INTO :UT-RATE-PLAN-NO                                 
C33274          FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                     
C33274          WHERE ACCOUNT_NO = :UT-ACCOUNT-NO                       
C33274            AND CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE               
C33274            AND IC_NO = :UT-IC-NO                                 
T35434                                                           
A02036                                                      
C33274     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT RATE_PLAN_NO                                             
MFA-TR*           INTO :UT-RATE-PLAN-NO                                         
MFA-TR*         FROM CSS_UTIL_ENVRNMT                                           
MFA-TR*         WHERE ACCOUNT_NO = :UT-ACCOUNT-NO                               
MFA-TR*           AND CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                       
MFA-TR*           AND IC_NO = :UT-IC-NO                                         
MFA-TR*       WITH UR                                                           
MFA-TR*    QUERYNO 7440                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33274*                                                                         
C33274     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C33274*                                                                         
C33274     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
C33274         IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL          
C33274            MOVE UT-RATE-PLAN-NO TO E-FCA244-RATE-PLAN            
C33274         ELSE                                                     
C33274            MOVE SPACES          TO E-FCA244-RATE-PLAN            
C33274         END-IF                                                   
C33274         CONTINUE                                                 
C33274     ELSE                                                         
C33274         DISPLAY '************** PCSCA244 ******************'     
C33274         DISPLAY '** 7440 :  RETURN CODE ERROR - SELECT'          
C33274         DISPLAY '* ACCOUNT NO ', UT-ACCOUNT-NO                   
C33274         DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
C33274         DISPLAY '************** PCSCA244 ******************'     
C33274         PERFORM 9900-ABEND                THRU 9900-EXIT         
C33274     END-IF.                                                      
C33274*                                                                         
C33274 7440-EXIT.                                                       
C33274     EXIT.                                                        
C33274*                                                                         
C32694*****************************************************************         
C32694* 7460-SELECT-CSS-CRED-COLL                                     *         
C32694*      GETS DATE-CREDIT-ACTION BASE ON CODE-NOTICE-TYPE         *         
C32694*****************************************************************         
C32694 7460-SELECT-CSS-CRED-COLL.                                       
C32694     EXEC SQL                                                     
C32694          SELECT                                                  
C32694              CL.DATE_CREDIT_ACTION                               
C32694            INTO                                                  
ACT108             :CL-DATE-CREDIT-ACTION :WS-NULL-IND1                 
C32694          FROM CSS_CRED_COLL CL WITH(READUNCOMMITTED)                     
C32694          WHERE CL.ACCOUNT_NO = :CL-ACCOUNT-NO                    
C32694            AND CL.CODE_NOTICE_TYPE = :CL-CODE-NOTICE-TYPE        
T35434                                                           
A02036                                                      
C32694     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*             CL.DATE_CREDIT_ACTION                                       
MFA-TR*           INTO                                                          
MFA-TR*            :CL-DATE-CREDIT-ACTION :WS-NULL-IND1                         
MFA-TR*         FROM CSS_CRED_COLL CL                                           
MFA-TR*         WHERE CL.ACCOUNT_NO = :CL-ACCOUNT-NO                            
MFA-TR*           AND CL.CODE_NOTICE_TYPE = :CL-CODE-NOTICE-TYPE                
MFA-TR*       WITH UR                                                           
MFA-TR*    QUERYNO 7460                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C32694*                                                                         
C32694     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C32694*                                                                         
C32694     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
ACT108         IF WS-NULL-IND1             < ZERO                       
C32694            MOVE LOW-VALUES TO CL-DATE-CREDIT-ACTION              
C32694         END-IF                                                   
C32694     ELSE                                                         
C32694         IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
C32694            MOVE LOW-VALUES TO CL-DATE-CREDIT-ACTION              
C32694         ELSE                                                     
C32694            DISPLAY '************** PCSCA244 ******************'  
C32694            DISPLAY '** 7460 :  RETURN CODE ERROR - SELECT'       
C32694            DISPLAY '* ACCOUNT NO ', CL-ACCOUNT-NO                
C32694            DISPLAY '* NOTICE-TYPE ', CL-CODE-NOTICE-TYPE         
C32694            DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE      
C32694            DISPLAY '************** PCSCA244 ******************'  
C32694            PERFORM 9900-ABEND                THRU 9900-EXIT      
C32694         END-IF                                                   
C32694     END-IF.                                                      
C32694*                                                                         
C32694 7460-EXIT.                                                       
C32694     EXIT.                                                        
C32694*                                                                         
A02036*****************************************************************         
A02036* 7700-SEL-CSS-COLLECT-HIST                                     *         
A02036*      GETS FUTURE-WORK-DT AND HC-WRITE-OFF-DT.                 *         
A02036*****************************************************************         
A02036 7700-SEL-CSS-COLLECT-HIST.                                       
A02036     EXEC SQL                                                     
A02036          SELECT TOP(1) COALESCE(HC.FUTURE_WORK_DT, 
              IIF(TRY_CONVERT(DATE, '1900-01-01'
              ) IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )),
              COALESCE(HC.WRITE_OFF_DT, IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') ))               
A02036            INTO                                                  
A02036             :HC-FUTURE-WORK-DT                                   
A02036            ,:HC-WRITE-OFF-DT                                     
A02036          FROM CSS_COLLECT_HIST HC WITH(READUNCOMMITTED)                  
A02036          WHERE HC.ACCOUNT_NO = :HC-ACCOUNT-NO                    
A02036         ORDER BY HC.COLL_HIST_SEQ_TS DESC                        
A02036                                              
A02036                                                           
A02036                                                      
A02036     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*             IFNULL(HC.FUTURE_WORK_DT, '1900-01-01')                     
MFA-TR*            ,IFNULL(HC.WRITE_OFF_DT, '1900-01-01')                       
MFA-TR*           INTO                                                          
MFA-TR*            :HC-FUTURE-WORK-DT                                           
MFA-TR*           ,:HC-WRITE-OFF-DT                                             
MFA-TR*         FROM CSS_COLLECT_HIST HC                                        
MFA-TR*         WHERE HC.ACCOUNT_NO = :HC-ACCOUNT-NO                            
MFA-TR*        ORDER BY HC.COLL_HIST_SEQ_TS DESC                                
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*    QUERYNO 7700                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02036*                                                                         
A02036     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A02036*                                                                         
A02036     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
A02036         IF HC-FUTURE-WORK-DT = '1900-01-01'                      
A02036            MOVE SPACES TO HC-FUTURE-WORK-DT                      
A02036         END-IF                                                   
A02036         IF HC-WRITE-OFF-DT = '1900-01-01'                        
A02036            MOVE SPACES TO HC-WRITE-OFF-DT                        
A02036         END-IF                                                   
A02036     ELSE                                                         
A02036         IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
A02036            MOVE SPACES TO HC-FUTURE-WORK-DT                      
A02036                           HC-WRITE-OFF-DT                        
A02036         ELSE                                                     
A02036            DISPLAY '************** PCSCA244 ******************'  
A02036            DISPLAY '** 7700 :  RETURN CODE ERROR - SELECT'       
A02036            DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                
A02036            DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE      
A02036            DISPLAY '************** PCSCA244 ******************'  
A02036            PERFORM 9900-ABEND                THRU 9900-EXIT      
A02036         END-IF                                                   
A02036     END-IF.                                                      
A02036*                                                                         
A02036 7700-EXIT.                                                       
A02036     EXIT.                                                        
A02036*                                                                         
      *****************************************************************         
      * 7802-GET-USA-DATE                                             *         
      *      FORMATS THE DATE INTO MM/DD/YYYY                         *         
      *****************************************************************         
       7802-GET-USA-DATE.                                               
           IF WS-DATE-HOLD <= SPACES                                    
              MOVE SPACES TO WS-DATE-HOLD                               
              GO TO 7802-EXIT                                           
           END-IF                                                       
      *                                                                         
           EXEC SQL                                                     
T35434        SELECT
              CIS.CHAR2$DATE(IIF(TRY_CONVERT(DATE, :WS-DATE-HOLD
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-HOLD
              ) <> 0) OR (LEN(:WS-DATE-HOLD) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-HOLD
              ), CONVERT(DATE, :WS-DATE-HOLD) ),'USA')
            INTO
              :WS-DATE-HOLD-USA                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-DATE-HOLD-USA =                                           
MFA-TR*              CHAR(DATE(:WS-DATE-HOLD),USA)                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '********** PCSCA244 ABORT ************'         
               DISPLAY '* 7802-GET-USA-DATE                  *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* WS-DATE-HOLD ', WS-DATE-HOLD                  
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA244 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7802-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      * 9000-TERMINATE.                                                *        
      ******************************************************************        
       9000-TERMINATE.                                                  
           CLOSE FCSCA244-FILE.                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  9700-PROCESS-ABEND.                                           *        
      ******************************************************************        
              EXEC SQL                                                  15309306
                   INCLUDE CPD0023B                                     15309307
              END-EXEC.                                                 15309308
      *                                                                         
      ****************************************************************          
      *  COPY BOOK CONTAINING 9900-ABEND AND 9900-EXIT           ****           
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
