       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA233.                                        
       AUTHOR . ROGER D. FAULK                                          
       DATE-WRITTEN.  JUNE 2011                                         
       DATE-COMPILED.                                                   
      *                                                                         
      ****************************************************************          
      **                SOUTH CAROLINA ELECTRICITY & GAS            **          
      ********            CUSTOMER SERVICE SYSTEM            *********          
      ********                      DB2                      *********          
      ****************************************************************          
      *                                                              *          
      *               PROGRAM  MODIFICATION  LOG                     *          
      *     DATE     INTIALS      REASON                             *          
      *     ____     _______      ______                             *          
      *                                                              *          
      *  JUNE  2011  RF10596      NEW PROGRAM                        *          
      *                                                              *          
A03411*  1 AUG 2011  RF10596      NEW PROGRAM                        *          
      *                                                              *          
A03411* 26 JAN 2011  RF10596      SPACES IN LOCATION CODE FOR PSNC   *          
      *                                                              *          
A03411* 29 JAN 2011  RF10596      SPACES IN LOCATION CODE FOR GLS    *          
      *                           456.0000 AND 495.0000              *          
      *                                                              *          
A03411* 29 JAN 2011  RF10596      FOR 495.0000 MOVE SPACE TO POS 100 *          
      *                                                              *          
A03411* 12 MAR 2011  RF10596      FOR 456.0000 MOVE 0008 TO COST     *          
A03411*                           CENTER.                            *          
      *                                                              *          
A03411* 21 JUN 2011  RF10596      FOR 456.0000 MOVE 0365 TO COST     *          
A03411*                           CENTER.                            *          
      *                                                              *          
A03967* 21 AUG 2012  RF10596      HARD CODE GL'S FOR HEADERS         *          
      *                                                              *          
A04527*  9 SEP 2013  RF10596      ADD RV.REV_POST_STATUS_FL = 'Y'    *          
      *                                                              *          
A04527* 10 SEP 2013  RF10596      HARD CODE BUSINESS UNIT AND        *          
A04527*                           OPERATING UNIT TO OUTPUT FILE      *          
      *                                                              *          
      ****************************************************************          
      *    REMARKS.                                                  *          
      *                    PCSCA233 NARRATIVE                        *          
      *                                                              *          
      * THIS  PROGRAM  READS  THE  REVENUE TAX TABLES TO CREATE      *          
      * MRSCRR03-FILE.  ALSO PRINTS A REPORT BY RV-MNICPLTY-COUNTY-CD*          
      * TYPE SERVICE AND TAX.                                        *          
      ****************************************************************          
      *                                                              *          
      *              ---- BASIC BATCH SEQUENCE STRUCTURE ----        *          
      *             1000 - 1999   INPUT PROCESSING CONTROL PATH      *          
      *             2000 - 2999   OUTPUT PROCESSING CONTROL PATH     *          
      *             6000 - 6999   COMMON SYSTEM MODULES              *          
      *             7000 - 7999   INPUT MODULES                      *          
      *             9000 - 9799   TERMINATION MODULES                *          
      *             9900 - 9999   ABEND/ABORT MODULES                *          
      ****************************************************************          
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSCA233.                                                           
      *                                                                         
           SELECT PRINTER1 ASSIGN TO DA-PRINTER1.                       
      *                                                                         
           SELECT PSNCFILE-RECORD                                       
                   ASSIGN UT-S-PSNCFILE.                                
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDCA233.                                                           
      *                                                                         
       COPY FIOCA233.                                                           
      *                                                                         
       FD  PRINTER1.                                                    
       01  FS-PRINT-REC.                                                
           05  RPT-CNTL                PIC X.                           
           05  RPT-LINE                PIC X(132).                      
      *                                                                         
       FD  PSNCFILE-RECORD.                                             
       01  PSNC-LINE.                                                   
           05 PSNC-DATA.                                                
              10 PSNC-LITERAL-OUT      PIC X(19).                       
              10 PSNC-DEL1             PIC X         VALUE SPACES.      
           05 PSNC-OUT-DATA.                                            
              10 PSNC-DET-SAL-TAX      PIC S9(11)V99 VALUE +0.          
              10 PSNC-DEL2             PIC X         VALUE SPACES.      
              10 PSNC-DET-TOT-TOUR     PIC S9(11)V99 VALUE +0.          
              10 PSNC-DEL3             PIC X         VALUE SPACES.      
              10 PSNC-DET-TOT-LOST     PIC S9(11)V99 VALUE +0.          
              10 PSNC-DEL4             PIC X         VALUE SPACES.      
              10 PSNC-DET-TOT-CAPS     PIC S9(11)V99 VALUE +0.          
              10 PSNC-DEL5             PIC X         VALUE SPACES.      
              10 PSNC-DET-TOT-TRAN     PIC S9(11)V99 VALUE +0.          
              10 PSNC-DEL6             PIC X         VALUE SPACES.      
              10 PSNC-DET-TOT-EDUC     PIC S9(11)V99 VALUE +0.          
              10 PSNC-DEL7             PIC X         VALUE SPACES.      
              10 PSNC-DET-TOT-FRAN     PIC S9(11)V99 VALUE +0.          
              10 PSNC-DEL8             PIC X         VALUE SPACES.      
              10 PSNC-DET-TOT-HALF     PIC S9(11)V99 VALUE +0.          
              10 PSNC-DEL9             PIC X         VALUE SPACES.      
           05 PSNC-LITERAL-DISTRICT    PIC X(3)      VALUE SPACES.      
           05 PSNC-DEL10               PIC X         VALUE SPACES.      
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA233'.
MSQ017     COPY MFASQLM.
      *                                                                         
      ****************************************************************          
      ****  APPLICATION TABLE WORKING STORAGE DECLARATIONS ***********          
      ****************************************************************          
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
       COPY CWS09900.                                                           
      *-- ABEND SWITCH COPYBOOK                                                 
                                                                        
       COPY CWS00303.                                                           
      *-- COPY BOOK HAVING SUCCESSFUL-CALL AND NOT-FOUND                        
                                                                        
       COPY CWS00038.                                                           
      *-- COPY BOOK TO FORMAT PARM DATA                                         
                                                                        
       COPY CWS00114.                                                           
      *-- COPY BOOK TO READ THE JOB PARM TABLE FOR THE REPORT DATE              
      *                                                                         
       01  WS-FILE-STATUS-AREA.                                         
           05 WS-CRR03-STATUS          PIC XX.                          
              88 CRR03-SUCCESSFUL        VALUE '00'.                    
           05 WS-PSNCFILE-STATUS       PIC XX.                          
              88 PSNCFILE-SUCCESSFUL     VALUE '00'.                    
      *                                                                         
       01  WS-PARM-DATA233.                                             
           05 WS-PARM-LITERAL7         PIC X(14).                       
           05 WS-REVENUE-MONTH.                                         
              07 WS-REVENUE-YEAR       PIC 9(4).                        
              07 WS-REVENUE-MM         PIC 99.                          
           05 FILLER                   PIC X(60).                       
      *                                                                         
       01  WS-WORK-REVENUE             PIC 9(6) VALUE 0.                
       01  WS-REVENUE-MONTH-P          PIC S9(6)V COMP-3 VALUE 0.       
      *                                                                         
       01  WS-CURRENT-DATEALL          PIC X(10).                       
       01  WS-CURRENT-DATE.                                             
           05 WS-CURRENT-YEAR          PIC X(4).                        
           05 FILLER                   PIC X.                           
           05 WS-CURRENT-MONTH         PIC XX.                          
           05 FILLER                   PIC X.                           
           05 WS-CURRENT-DAY           PIC XX.                          
      *                                                                         
       01  WS-A8300-DATE.                                               
           05 WS-A8300-YEAR            PIC X(4).                        
           05 FILLER                   PIC X.                           
           05 WS-A8300-MONTH           PIC XX.                          
           05 FILLER                   PIC X.                           
           05 WS-A8300-DAY             PIC XX.                          
      *                                                                         
       01  WS-FIX-DATE                 PIC X(10).                       
       01  WS-FIX-DATE2                PIC X(10).                       
      *                                                                         
       01  WS-PREV-LOC-CODE.                                            
           05 WS-PREV-LOC-ZERO         PIC X.                           
           05 WS-PREV-LOC-PSNC         PIC X(3).                        
      *                                                                         
       01  WS-VARIABLES.                                                
A04527     05 WS-PSNC-OPERUNIT         PIC X(4)   VALUE 'PSNC'.         
A04527     05 WS-PSNC-BUSIUNIT         PIC X(5)   VALUE 'PSNC '.        
A04527     05 WS-SCEG-OPERUNIT         PIC X(4)   VALUE 'EGCO'.         
A04527     05 WS-SCEG-BUSIUNIT         PIC X(5)   VALUE 'EG   '.        
A04527     05 WS-456-OPERUNIT          PIC X(4)   VALUE 'RADM'.         
A04527     05 WS-456-BUSIUNIT          PIC X(5)   VALUE 'RE   '.        
A04527     05 WS-495-OPERUNIT          PIC X(4)   VALUE 'GADM'.         
A04527     05 WS-495-BUSIUNIT          PIC X(5)   VALUE 'GA   '.        
A03411     05 WS-495-FIX               PIC X(4)   VALUE '000 '.         
           05 WS-COMPANY-REV           PIC X(3)   VALUE '999'.          
           05 WS-GAS-REV               PIC X(3)   VALUE '998'.          
           05 WS-CONTROL-AMOUNT        PIC S9(13)V99 COMP-3 VALUE 0.    
           05 WS-SEQ-NO                PIC S9999V COMP-3 VALUE 6.       
           05 WS-END-OF-DATA           PIC X VALUE 'N'.                 
           05 WS-PREV-TYPE-SERV        PIC X.                           
           05 WS-PREV-REV-DIST         PIC X(3).                        
           05 WS-PREV-LOCAL-OFFICE     PIC X(3).                        
           05 WS-PREV-LOC-TAX-PCT      PIC V999.                        
           05 WS-PREV-COMPANY          PIC XX    VALUE SPACES.          
           05 WS-RETURN-CODE-UED       PIC S9(4) VALUE ZEROS.           
           05 WS-ACCT-NO               PIC X(7).                        
           05 WS-ACCT-NO-NUM REDEFINES WS-ACCT-NO                       
                                       PIC 9(3)V9(4).                   
           05 WS-COMPANY               PIC XX.                          
           05 WS-SUB                   PIC 9(3)  VALUE ZEROS.           
           05 WS-TAXABLE-AMT           PIC S9(12)V99 COMP-3 VALUE 0.    
           05 WS-TAX-AMT               PIC S9(7)V9999 COMP-3 VALUE 0.   
           05 WS-LOC-OPT-SALES-TAX     PIC S9(7)V99  COMP-3 VALUE 0.    
      *                                                                         
A03967     05 WS-ELEC-ACCT-SALES       PIC 9(3)V9999 VALUE 241.0107.    
A03967     05 WS-ELEC-ACCT-FRAN        PIC 9(3)V9999 VALUE 456.0000.    
A03967     05 WS-ELEC-ACCT-LOST        PIC 9(3)V9999 VALUE 241.0203.    
A03967     05 WS-ELEC-ACCT-CAPS        PIC 9(3)V9999 VALUE 241.0232.    
A03967     05 WS-ELEC-ACCT-TRAN        PIC 9(3)V9999 VALUE 241.0230.    
A03967     05 WS-ELEC-ACCT-EDUC        PIC 9(3)V9999 VALUE 241.0231.    
A03967     05 WS-ELEC-ACCT-TOUR        PIC 9(3)V9999 VALUE 241.0243.    
      *                                                                         
A03967     05 WS-GAS-ACCT-SALES        PIC 9(3)V9999 VALUE 241.0108.    
A03967     05 WS-GAS-ACCT-FRAN         PIC 9(3)V9999 VALUE 495.0000.    
A03967     05 WS-GAS-ACCT-LOST         PIC 9(3)V9999 VALUE 241.0204.    
A03967     05 WS-GAS-ACCT-CAPS         PIC 9(3)V9999 VALUE 241.0242.    
A03967     05 WS-GAS-ACCT-TRAN         PIC 9(3)V9999 VALUE 241.0240.    
A03967     05 WS-GAS-ACCT-EDUC         PIC 9(3)V9999 VALUE 241.0241.    
A03967     05 WS-GAS-ACCT-TOUR         PIC 9(3)V9999 VALUE 241.0243.    
      *                                                                         
           05 WS-TOTAL-TAX             PIC S9(12)V99 COMP-3 VALUE 0.    
           05 WS-SALES-TAX             PIC S9(7)V99  COMP-3 VALUE 0.    
           05 WS-STAX-CHECK            PIC S9(7)V9999 COMP-3 VALUE 0.   
           05 WS-LTAX-CHECK            PIC S9(7)V99  COMP-3 VALUE 0.    
           05 WS-TOT-LOC-TAX           PIC S9(9)V99  COMP-3 VALUE 0.    
      *                                                                         
       01  WS-LITERALS.                                                 
HEX01      05 WS-PSNC-DELIM            PIC X    VALUE X'09'.            
           05 WS-PSNC                  PIC XX   VALUE '26'.             
           05 WS-PSNC-HDR              PIC X(39)                        
              VALUE '                 PSNC                  '.          
           05 WS-SCEG-HDR              PIC X(39)                        
              VALUE 'SOUTH CAROLINA ELECTRIC AND GAS COMPANY'.          
           05 WS-1ST-SW                PIC X    VALUE 'Y'.              
           05 WS-SALE-GL               PIC X(8) VALUE '241.0107'.       
           05 WS-TOUR-GL               PIC X(8) VALUE '241.0243'.       
           05 WS-LOST-GL               PIC X(8) VALUE '241.0203'.       
           05 WS-CAPS-GL               PIC X(8) VALUE '241.0232'.       
           05 WS-TRAN-GL               PIC X(8) VALUE '241.0230'.       
           05 WS-EDUC-GL               PIC X(8) VALUE '241.0231'.       
           05 WS-FRAN-GL               PIC X(8) VALUE '456.0000'.       
           05 WS-PGM-233               PIC X(8) VALUE 'PCSCA204'.       
           05 WS-PARM-233              PIC X(4) VALUE 'PARM'.           
           05 WS-COMPANY-233           PIC XX   VALUE '01'.             
           05 WS-PGRMNAME              PIC X(8) VALUE 'PCSCA233'.       
           05 WS-ACTIVE                PIC X    VALUE 'A'.              
           05 WS-N                     PIC X    VALUE 'N'.              
           05 WS-Y                     PIC X    VALUE 'Y'.              
           05 WS-E                     PIC X    VALUE 'E'.              
           05 WS-G                     PIC X    VALUE 'G'.              
           05 WS-COMP                  PIC XX   VALUE '01'.             
           05 WS-SOURCE-SYSTEM         PIC X    VALUE 'B'.              
           05 WS-TAX                   PIC X(3) VALUE 'TAX'.            
           05 WS-COST-CENTER           PIC X(4) VALUE '0001'.           
A03411     05 WS-COST-CENTER-495-FIX   PIC X(4) VALUE '0986'.           
A03411     05 WS-COST-CENTER-456-FIX   PIC X(4) VALUE '0365'.           
           05 WS-COST-CENTER-PSNC      PIC X(4) VALUE '0015'.           
           05 WS-FUNCTION-CODE         PIC X(4) VALUE 'ACJV'.           
           05 WS-NOE                   PIC X(3) VALUE '901'.            
           05 WS-TRN-CODE              PIC X(4) VALUE '8300'.           
           05 WS-ONE                   PIC 9    VALUE 1.                
           05 WS-TWO                   PIC 9    VALUE 2.                
           05 WS-TEN                   PIC 99   VALUE 10.               
           05 WS-TWENTY                PIC 99   VALUE 20.               
           05 WS-ZERO                  PIC 99   VALUE 00.               
           05 WS-ELEVEN                PIC 99   VALUE 11.               
           05 WS-THIRTY-TWO            PIC 99   VALUE 32.               
           05 WS-THIRTY-THREE          PIC 99   VALUE 33.               
           05 WS-FORTY-TWO             PIC 99   VALUE 42.               
           05 WS-FORTY-THREE           PIC 99   VALUE 43.               
           05 WS-FIFTY-TWO             PIC 99   VALUE 52.               
           05 WS-FIFTY-THREE           PIC 99   VALUE 53.               
           05 WS-THREE                 PIC 9    VALUE 3.                
           05 WS-FOUR                  PIC 9    VALUE 4.                
           05 WS-FIFTY-SIX             PIC 99   VALUE 56.               
           05 WS-FIFTY-SEVEN           PIC 99   VALUE 57.               
           05 WS-SIXTY-TWO             PIC 99   VALUE 62.               
           05 WS-SIXTY-THREE           PIC 99   VALUE 63.               
           05 WS-EIGHTY-TWO            PIC 99   VALUE 82.               
           05 WS-EIGHTY-THREE          PIC 99   VALUE 83.               
      *                                                                         
       01  WS-SWITCHES.                                                 
           05 WS-FIRST-RECORD-READ     PIC X VALUE 'Y'.                 
           05 WS-FIRST-REC-WRITE       PIC X VALUE 'N'.                 
           05 WS-FIRST-PRINT-RECORD    PIC X VALUE 'Y'.                 
           05 WS-TYPE-SERVICE-INVALID  PIC X VALUE 'N'.                 
      *    05 WS-LOC-OPT-NONZERO       PIC X VALUE 'N'.                         
      *                                                                         
       01  WS-ELE-SALES-GL             PIC 9(3)V9999 VALUE 241.0107.    
       01  WS-GAS-SALES-GL             PIC 9(3)V9999 VALUE 241.0108.    
       01  WS-ELE-FRAN-GL              PIC 9(3)V9999 VALUE 456.0000.    
       01  WS-GAS-FRAN-GL              PIC 9(3)V9999 VALUE 495.0000.    
      *                                                                         
      *  PSNC GLS FOR OUTPUT FILE                                               
      *                                                                         
       01 WS-GL236                     PIC 9(3)V9999 VALUE 236.0005.    
       01 WS-GL-TOUR                   PIC 9(3)V9999 VALUE 241.0243.    
       01 WS-GL-LOST                   PIC 9(3)V9999 VALUE 241.0203.    
       01 WS-GL-CAPS                   PIC 9(3)V9999 VALUE 241.0232.    
       01 WS-GL-TRAN                   PIC 9(3)V9999 VALUE 241.0230.    
       01 WS-GL-EDUC                   PIC 9(3)V9999 VALUE 241.0231.    
       01 WS-GL-FRAN                   PIC 9(3)V9999 VALUE 456.0000.    
      *                                                                         
       01  WS-COMP-VARIABLES.                                           
           05 WS-REP-WRITE             PIC 9(8) VALUE ZEROS.            
           05 WS-8300-CONTROL-AMOUNT   PIC S9(13)V99 COMP-3 VALUE 0.    
           05 WS-TAX-SALES             PIC S9(7)V99 COMP-3 VALUE 0.     
           05 WS-TAX-LOST              PIC S9(7)V99 COMP-3 VALUE 0.     
           05 WS-TAX-CAPS              PIC S9(7)V99 COMP-3 VALUE 0.     
           05 WS-TAX-TRAN              PIC S9(7)V99 COMP-3 VALUE 0.     
           05 WS-TAX-EDUC              PIC S9(7)V99 COMP-3 VALUE 0.     
           05 WS-HALF-TAX              PIC S9(7)V99 COMP-3 VALUE 0.     
           05 WS-TAX-TOUR              PIC S9(7)V99 COMP-3 VALUE 0.     
      *                                                                         
           05 WS-TAX-TOUR-TOTAL        PIC S9(7)V99 COMP-3 VALUE 0.     
           05 WS-TAX-FRAN-TOTAL        PIC S9(7)V99 COMP-3 VALUE 0.     
           05 WS-TAX-SALES-TOTAL       PIC S9(9)V99 COMP-3 VALUE 0.     
           05 WS-SERV-HALF-TAX         PIC S9(7)V99 COMP-3 VALUE 0.     
           05 WS-TAX-LOST-TOTAL        PIC S9(7)V99 COMP-3 VALUE 0.     
           05 WS-TAX-CAPS-TOTAL        PIC S9(7)V99 COMP-3 VALUE 0.     
           05 WS-TAX-TRAN-TOTAL        PIC S9(7)V99 COMP-3 VALUE 0.     
           05 WS-TAX-EDUC-TOTAL        PIC S9(7)V99 COMP-3 VALUE 0.     
      *                                                                         
           05 WS-TAX-SALES-LOC         PIC S9(9)V99 COMP-3 VALUE 0.     
           05 WS-TAX-LOST-LOC          PIC S9(7)V99 COMP-3 VALUE 0.     
           05 WS-TAX-TOUR-LOC          PIC S9(7)V99 COMP-3 VALUE 0.     
           05 WS-TAX-CAPS-LOC          PIC S9(7)V99 COMP-3 VALUE 0.     
           05 WS-TAX-TRAN-LOC          PIC S9(7)V99 COMP-3 VALUE 0.     
           05 WS-TAX-EDUC-LOC          PIC S9(7)V99 COMP-3 VALUE 0.     
           05 WS-TAX-FRAN-LOC          PIC S9(7)V99 COMP-3 VALUE 0.     
      *                                                                         
           05 WS-GND-TOT-SALES-TAX     PIC S9(9)V99 COMP-3 VALUE 0.     
           05 WS-GND-HALF-TAX          PIC S9(9)V99 COMP-3 VALUE 0.     
           05 WS-GND-TOT-TAX-TOUR      PIC S9(9)V99 COMP-3 VALUE 0.     
           05 WS-GND-TOT-FRAN-TAX      PIC S9(9)V99 COMP-3 VALUE 0.     
           05 WS-GND-TOT-TAX-LOST      PIC S9(9)V99 COMP-3 VALUE 0.     
           05 WS-GND-TOT-TAX-CAPS      PIC S9(9)V99 COMP-3 VALUE 0.     
           05 WS-GND-TOT-TAX-TRAN      PIC S9(9)V99 COMP-3 VALUE 0.     
           05 WS-GND-TOT-TAX-EDUC      PIC S9(9)V99 COMP-3 VALUE 0.     
      *                                                                         
           05 WS-TAX-SALES-COMPANY     PIC S9(9)V99 COMP-3 VALUE 0.     
           05 WS-HALF-TAX-COMPANY      PIC S9(7)V99 COMP-3 VALUE 0.     
           05 WS-TAX-TOUR-COMPANY      PIC S9(7)V99 COMP-3 VALUE 0.     
           05 WS-TAX-LOST-COMPANY      PIC S9(7)V99 COMP-3 VALUE 0.     
           05 WS-TAX-CAPS-COMPANY      PIC S9(7)V99 COMP-3 VALUE 0.     
           05 WS-TAX-TRAN-COMPANY      PIC S9(7)V99 COMP-3 VALUE 0.     
           05 WS-TAX-EDUC-COMPANY      PIC S9(7)V99 COMP-3 VALUE 0.     
           05 WS-TAX-FRAN-COMPANY      PIC S9(7)V99 COMP-3 VALUE 0.     
      *                                                                         
       01  WS-COUNTERS.                                                 
           05 WS-LINE-CNTR             PIC 99 VALUE ZEROS.              
           05 WS-PAGE                  PIC 99 VALUE ZEROS.              
           05 WS-LINE-SPACE            PIC 9  VALUE ZERO.               
      *                                                                         
       01  WS-HDR-ONE.                                                  
           05 FILLER                   PIC X(8)  VALUE  'PCSCA233'.     
           05 FILLER                   PIC X(45) VALUE SPACES.          
           05 P-COMPANY                PIC X(39) VALUE                  
              'SOUTH CAROLINA ELECTRIC AND GAS COMPANY'.                
           05 FILLER                   PIC X(30) VALUE SPACES.          
           05 FILLER                   PIC X(8)  VALUE 'PAGE -'.        
           05 WS-DET-PAGE              PIC ZZ    VALUE SPACES.          
      *                                                                         
       01  WS-HDR-TWO.                                                  
           05 FILLER                   PIC X(15) VALUE                  
                     'REVENUE MONTH ='.                                 
           05 FILLER                   PIC XX     VALUE SPACES.         
           05 WS-REVENUE-MTH           PIC X(6)   VALUE SPACES.         
           05 FILLER                   PIC X(16)  VALUE SPACES.         
           05 FILLER                   PIC X(45)  VALUE                 
              'TAXES - SALES, LOST, CAPITAL, TRANSPORTATION,'.          
           05 FILLER                   PIC X(24)  VALUE                 
              ' EDUCATION AND FRANCHISE'.                               
           05 FILLER                   PIC X(14)  VALUE SPACES.         
           05 WS-RPT-H2-DATE           PIC X(10)  VALUE SPACES.         
      *                                                                         
       01  WS-HDR-THREE.                                                
           05 FILLER                   PIC X(15) VALUE                  
              'TYPE SERVICE  ='.                                        
           05 FILLER                   PIC X     VALUE SPACES.          
           05 WS-RPT-SERV              PIC X(8).                        
           05 FILLER                   PIC X(108).                      
      *                                                                         
       01  WS-HDR-FOUR.                                                 
           05 FILLER                   PIC X(8)  VALUE 'LOCATION'.      
           05 FILLER                   PIC X     VALUE SPACES.          
           05 FILLER                   PIC X(12) VALUE 'REVENUE DIST'.  
           05 FILLER                   PIC X(6)  VALUE SPACES.          
           05 FILLER                   PIC X(5)  VALUE 'SALES'.         
           05 FILLER                   PIC X(7)  VALUE SPACES.          
           05 FILLER                   PIC X(11) VALUE 'TOURISM TAX'.   
           05 FILLER                   PIC X(5)  VALUE SPACES.          
           05 FILLER                   PIC X(4)  VALUE 'LOST'.          
           05 FILLER                   PIC X(8)  VALUE SPACES.          
           05 FILLER                   PIC X(7)  VALUE 'CAPITAL'.       
           05 FILLER                   PIC X(4)  VALUE SPACES.          
           05 FILLER                   PIC X(14) VALUE                  
                     'TRANSPORTATION'.                                  
           05 FILLER                   PIC X(3)   VALUE SPACES.         
           05 FILLER                   PIC X(9)   VALUE 'EDUCATION'.    
           05 FILLER                   PIC X(5)   VALUE SPACES.         
           05 FILLER                   PIC X(9)   VALUE 'FRANCHISE'.    
           05 FILLER                   PIC X(4)   VALUE SPACES.         
           05 FILLER                   PIC X(10)  VALUE 'DISTRIBUTE'.   
      *                                                                         
       01  WS-HDR-FIVE.                                                 
           05 FILLER                   PIC X(13) VALUE 'GL ACCOUNT NO'. 
           05 FILLER                   PIC X(11) VALUE SPACES.          
           05 FILLER                   PIC X     VALUE '('.             
           05 WS-HDR5-SALE             PIC 9(3).9(4).                   
           05 WS-HDR5-1 REDEFINES WS-HDR5-SALE PIC X(8).                
           05 FILLER                   PIC X     VALUE ')'.             
           05 FILLER                   PIC X(4)  VALUE SPACES.          
           05 FILLER                   PIC X     VALUE '('.             
           05 WS-HDR5-TOUR             PIC 9(3).9(4).                   
           05 WS-HDR5-2 REDEFINES WS-HDR5-TOUR PIC X(8).                
           05 FILLER                   PIC X     VALUE ')'.             
           05 FILLER                   PIC X(4)  VALUE SPACES.          
           05 FILLER                   PIC X     VALUE '('.             
           05 WS-HDR5-LOST             PIC 9(3).9(4).                   
           05 WS-HDR5-3 REDEFINES WS-HDR5-LOST PIC X(8).                
           05 FILLER                   PIC X     VALUE ')'.             
           05 FILLER                   PIC X(4)  VALUE SPACES.          
           05 FILLER                   PIC X     VALUE '('.             
           05 WS-HDR5-CAPS             PIC 9(3).9(4).                   
           05 WS-HDR5-4 REDEFINES WS-HDR5-CAPS PIC X(8).                
           05 FILLER                   PIC X     VALUE ')'.             
           05 FILLER                   PIC X(4)  VALUE SPACES.          
           05 FILLER                   PIC X     VALUE '('.             
           05 WS-HDR5-TRAN             PIC 9(3).9(4).                   
           05 WS-HDR5-5 REDEFINES WS-HDR5-TRAN PIC X(8).                
           05 FILLER                   PIC X     VALUE ')'.             
           05 FILLER                   PIC X(4)  VALUE SPACES.          
           05 FILLER                   PIC X     VALUE '('.             
           05 WS-HDR5-EDUC             PIC 9(3).9(4).                   
           05 WS-HDR5-6 REDEFINES WS-HDR5-EDUC PIC X(8).                
           05 FILLER                   PIC X     VALUE ')'.             
           05 FILLER                   PIC X(4)  VALUE SPACES.          
           05 FILLER                   PIC X     VALUE '('.             
           05 WS-HDR5-FRAN             PIC 9(3).9(4).                   
           05 WS-HDR5-7 REDEFINES WS-HDR5-FRAN PIC X(8).                
           05 FILLER                   PIC X     VALUE ')'.             
           05 FILLER                   PIC X(14) VALUE SPACES.          
      *                                                                         
      ****************************************************************          
      *  BELOW ARE THE PSNC HEADERS FOR THE OUTPUT FILE              *          
      ****************************************************************          
      *                                                                         
       01  WS-PSNC-HDR-ONE.                                             
           05 FILLER                  PIC X(9)   VALUE  'PCSCA233-'.    
           05 FILLER                  PIC X(8)   VALUE  'PSNC TAX'.     
           05 FILLER                  PIC X(115) VALUE SPACES.          
      *                                                                         
       01  WS-PSNC-HDR-TWO.                                             
           05 FILLER                  PIC X(12)  VALUE 'REV MONTH = '.  
           05 WS-PSNC-REVENUE-MTH     PIC X(6)   VALUE SPACES.          
           05 FILLER                  PIC X(114) VALUE SPACES.          
      *                                                                         
       01  WS-PSNC-HDR-THREE.                                           
           05 FILLER                  PIC X(7)   VALUE 'DATE = '.       
           05 WS-PSNC-DATE            PIC X(10)  VALUE SPACES.          
           05 FILLER                  PIC X(115) VALUE SPACES.          
      *                                                                         
       01  WS-PSNC-HDR-FOUR.                                            
           05 FILLER                  PIC X(27)  VALUE SPACES.          
           05 FILLER                  PIC X(5)   VALUE 'SALES'.         
           05 FILLER                  PIC X(7)   VALUE SPACES.          
           05 FILLER                  PIC X(7)   VALUE 'TOURISM'.       
           05 FILLER                  PIC X(9)   VALUE SPACES.          
           05 FILLER                  PIC X(4)   VALUE 'LOST'.          
           05 FILLER                  PIC X(9)   VALUE SPACES.          
           05 FILLER                  PIC X(7)   VALUE 'CAPITAL'.       
           05 FILLER                  PIC X(7)   VALUE SPACES.          
           05 FILLER                  PIC X(5)   VALUE 'TRANS'.         
           05 FILLER                  PIC X(9)   VALUE SPACES.          
           05 FILLER                  PIC X(4)   VALUE 'EDUC'.          
           05 FILLER                  PIC X(10)  VALUE SPACES.          
           05 FILLER                  PIC X(4)   VALUE 'FRAN'.          
           05 FILLER                  PIC X(10)  VALUE SPACES.          
           05 FILLER                  PIC X(5)   VALUE 'DISTR'.         
           05 FILLER                  PIC X(3)   VALUE SPACES.          
      *                                                                         
       01  WS-PSNC-HDR-FIVE.                                            
           05 FILLER                   PIC X(13) VALUE 'GL ACCOUNT NO'. 
           05 FILLER                   PIC X(12) VALUE SPACES.          
           05 WS-PSNC-HDR5-SALE        PIC 9(3).9(4).                   
           05 FILLER                   PIC X(6)  VALUE SPACES.          
           05 WS-PSNC-HDR5-TOUR        PIC 9(3).9(4).                   
           05 FILLER                   PIC X(6)  VALUE SPACES.          
           05 WS-PSNC-HDR5-LOST        PIC 9(3).9(4).                   
           05 FILLER                   PIC X(6)  VALUE SPACES.          
           05 WS-PSNC-HDR5-CAPS        PIC 9(3).9(4).                   
           05 FILLER                   PIC X(6)  VALUE SPACES.          
           05 WS-PSNC-HDR5-TRAN        PIC 9(3).9(4).                   
           05 FILLER                   PIC X(6)  VALUE SPACES.          
           05 WS-PSNC-HDR5-EDUC        PIC 9(3).9(4).                   
           05 FILLER                   PIC X(6)  VALUE SPACES.          
           05 WS-PSNC-HDR5-FRAN        PIC 9(3).9(4).                   
           05 FILLER                   PIC X(15) VALUE SPACES.          
      *                                                                         
      ****************************************************************          
      *  END OF PSNC HEADERS FOR OUTPUT FILE                         *          
      ****************************************************************          
      *                                                                         
       01  WS-PRT-TOTAL-LINE.                                           
           05 WS-SCEG-DATA.                                             
              10 WS-TOT-TEXT           PIC X(8)   VALUE SPACES.         
              10 FILLER                PIC X      VALUE SPACES.         
              10 WS-DET-REV-DIST       PIC X(8)   VALUE SPACES.         
              10 FILLER                PIC XXX    VALUE SPACES.         
           05 WS-PSNC-DATA REDEFINES WS-SCEG-DATA.                      
              10 WS-PSNC-LITERAL       PIC X(19).                       
              10 FILLER                PIC X.                           
           05 WS-PSNC-FILE-BREAK.                                       
              10 WS-DET-SAL-TAX        PIC --,---,--9.99.               
              10 FILLER                PIC X      VALUE SPACES.         
              10 WS-DET-TOT-TOUR       PIC --,---,--9.99.               
              10 FILLER                PIC X      VALUE SPACES.         
              10 WS-DET-TOT-LOST       PIC --,---,--9.99.               
              10 FILLER                PIC X      VALUE SPACES.         
              10 WS-DET-TOT-CAPS       PIC --,---,--9.99.               
              10 FILLER                PIC X      VALUE SPACES.         
              10 WS-DET-TOT-TRAN       PIC --,---,--9.99.               
              10 FILLER                PIC X      VALUE SPACES.         
              10 WS-DET-TOT-EDUC       PIC --,---,--9.99.               
              10 FILLER                PIC X      VALUE SPACES.         
              10 WS-DET-TOT-FRAN       PIC --,---,--9.99.               
              10 FILLER                PIC X      VALUE SPACES.         
              10 WS-DET-TOT-HALF       PIC --,---,--9.99.               
              10 FILLER                PIC X      VALUE SPACES.         
      *                                                                         
      ****************************************************************          
      * WORKING STORAGE FOOTER VARIABLES                             *          
      ****************************************************************          
      *                                                                         
       01  WS-RECORDS-WRITTEN.                                          
           05 FILLER                   PIC X(5)  VALUE SPACES.          
           05 FILLER                   PIC X(40) VALUE                  
              'NUMBER OF RECORDS REPORTED             :'.               
           05 FILLER                   PIC X     VALUE SPACES.          
           05 WS-REP-WRITTEN           PIC X(8).                        
           05 FILLER                   PIC X(82) VALUE SPACES.          
      *                                                                         
       01  WS-FOOT-LINE.                                                
           05 FILLER                   PIC X(46) VALUE SPACES.          
           05 FILLER                   PIC X(40) VALUE                  
              '*************END OF REPORT**************'.               
           05 FILLER                   PIC X(46) VALUE SPACES.          
      *                                                                         
      ****************************************************************          
      * GENERAL DB2 USE                                              *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_JOB_PARM                                                 *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * REV_BILLING_DET  -  RV                                       *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBREVBLD                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * REV_BILL_TAX  -  R9                                          *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBREVTAX                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_COMPANY  -  C7                                           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCOMPNY                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_REV_DISTRICT  -  A9                                      *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRVDST                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CURSOR TO GET ALL AVAILABLE DATA FROM THE REVENUE TABLES     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
               DECLARE GL_ACCT_CURSOR CURSOR FOR                        
               SELECT RV.ACCOUNT_NO                                     
                     ,RV.REV_DISTRICT_CD                                
                     ,RV.MNICPLTY_COUNTY_CD                             
                     ,RV.CODE_SERVICE_TYPE                              
                     ,RV.CODE_UTIL_TYPE                                 
                     ,RV.COMPANY_NO                                     
                     ,RV.LOCAL_OFFICE                                   
                     ,R9.TAX_CNTRL_NO                                   
                     ,R9.TAX_GL_ACCT_NO                                 
                     ,R9.TAX_AMT                                        
                     ,R9.TAX_TYPE                                       
                FROM  REV_BILL_TAX R9 WITH(READUNCOMMITTED)                     
                     ,REV_BILLING_DET RV WITH(READUNCOMMITTED)                  
                WHERE RV.REVENUE_MONTH  = :WS-REVENUE-MONTH-P           
                  AND RV.BILL_UNIQUE_TS = R9.BILL_UNIQUE_TS             
                  AND R9.TAX_AMT <> 0                                   
P04527            AND RV.REV_POST_STATUS_FL = 'Y'                       
                  ORDER BY RV.COMPANY_NO                                
                          ,RV.CODE_SERVICE_TYPE                         
                          ,RV.MNICPLTY_COUNTY_CD                        
                          ,RV.REV_DISTRICT_CD                           
                  FOR READ ONLY                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE GL_ACCT_CURSOR CURSOR FOR                                
MFA-TR*        SELECT RV.ACCOUNT_NO                                             
MFA-TR*              ,RV.REV_DISTRICT_CD                                        
MFA-TR*              ,RV.MNICPLTY_COUNTY_CD                                     
MFA-TR*              ,RV.CODE_SERVICE_TYPE                                      
MFA-TR*              ,RV.CODE_UTIL_TYPE                                         
MFA-TR*              ,RV.COMPANY_NO                                             
MFA-TR*              ,RV.LOCAL_OFFICE                                           
MFA-TR*              ,R9.TAX_CNTRL_NO                                           
MFA-TR*              ,R9.TAX_GL_ACCT_NO                                         
MFA-TR*              ,R9.TAX_AMT                                                
MFA-TR*              ,R9.TAX_TYPE                                               
MFA-TR*         FROM  REV_BILL_TAX R9                                           
MFA-TR*              ,REV_BILLING_DET RV                                        
MFA-TR*         WHERE RV.REVENUE_MONTH  = :WS-REVENUE-MONTH-P                   
MFA-TR*           AND RV.BILL_UNIQUE_TS = R9.BILL_UNIQUE_TS                     
MFA-TR*           AND R9.TAX_AMT <> 0                                           
MFA-TR*           AND RV.REV_POST_STATUS_FL = 'Y'                               
MFA-TR*           ORDER BY RV.COMPANY_NO                                        
MFA-TR*                   ,RV.CODE_SERVICE_TYPE                                 
MFA-TR*                   ,RV.MNICPLTY_COUNTY_CD                                
MFA-TR*                   ,RV.REV_DISTRICT_CD                                   
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*     END-EXEC.                                                           
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      * MAINLINE                                                     *          
      ****************************************************************          
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 1000-INITIALIZATION THRU 1000-EXIT.                  
      *                                                                         
           PERFORM 2000-PROCESS THRU 2000-EXIT                          
                   UNTIL WS-END-OF-DATA = WS-Y.                         
           PERFORM 2600-LOC-CODE-BREAK  THRU 2600-EXIT.                 
           PERFORM 2650-TYPE-SERV-BREAK THRU 2650-EXIT.                 
           PERFORM 2675-COMP-BREAK      THRU 2675-EXIT.                 
           PERFORM 2800-SUMM-REPORT     THRU 2800-EXIT.                 
      *                                                                         
           PERFORM 7020-CLOSE-GL-ACCT-CURSOR THRU 7020-EXIT.            
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * INITIALIZE                                                   *          
      ****************************************************************          
      *                                                                         
       1000-INITIALIZATION.                                             
      *                                                                         
           PERFORM 1100-OPEN-FILES THRU 1100-EXIT.                      
      *                                                                         
           PERFORM 1200-PROCESS-DATE THRU 1200-EXIT.                    
      *                                                                         
           DISPLAY 'REVENUE MONTH = ' WS-REVENUE-MTH.                   
           DISPLAY 'CURRENT DATE  = ' WS-CURRENT-DATE.                  
      *                                                                         
           PERFORM 7000-OPEN-GL-ACCT-CURSOR  THRU 7000-EXIT.            
      *                                                                         
           PERFORM 7010-FETCH-GL-ACCT-CURSOR THRU 7010-EXIT.            
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * OPENS FILES AND PRINTER                                      *          
      ****************************************************************          
      *                                                                         
       1100-OPEN-FILES.                                                 
      *                                                                         
           OPEN OUTPUT MRSCRR03-FILE                                    
                       PSNCFILE-RECORD                                  
                       PRINTER1.                                        
      *                                                                         
           IF  CRR03-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**      PCSCA233 PROCESSING ERROR        **'    
               DISPLAY '**  OPEN ERROR OF MRSCRR03 - OUTPUT FILE **'    
               DISPLAY '**  PARAGRAPH - 1100-OPEN-FILES          **'    
               DISPLAY '**  FILE STATUS = ' WS-CRR03-STATUS             
               DISPLAY '**        PROCESSING TERMINATED          **'    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * GET THE CURRENT DATE AND THE REVENUE MONTH                   *          
      * AND LAST DAY OF THE MONTH FOR THE 8300 FILE                  *          
      ****************************************************************          
      *                                                                         
       1200-PROCESS-DATE.                                               
      *                                                                         
           PERFORM 7200-GET-CURRENT-DATE THRU 7200-EXIT.                
           MOVE WS-CURRENT-DATE TO WS-RPT-H2-DATE                       
                                   WS-A8300-DATE                        
                                   WS-PSNC-DATE.                        
      *                                                                         
           MOVE WS-PGM-233     TO G6-PROGRAM-NAME.                      
           MOVE WS-PARM-233    TO G6-CMND-CODE.                         
           MOVE WS-COMPANY-233 TO G6-COMPANY-NO.                        
           MOVE WS-SEQ-NO      TO G6-SEQ-NO.                            
           MOVE WS-ACTIVE      TO G6-STATUS.                            
           PERFORM 7400-GET-REVENUE-MONTH THRU 7400-EXIT.               
           MOVE G6-PARM-DATA TO WS-PARM-DATA233.                        
           MOVE WS-REVENUE-MONTH TO WS-WORK-REVENUE.                    
           MOVE WS-WORK-REVENUE  TO WS-REVENUE-MONTH-P                  
                                    WS-REVENUE-MTH                      
                                    WS-PSNC-REVENUE-MTH.                
      *                                                                         
A03411     MOVE WS-REVENUE-YEAR TO WS-A8300-YEAR.                       
A03411     MOVE WS-REVENUE-MM   TO WS-A8300-MONTH.                      
A03411     MOVE '01'            TO WS-A8300-DAY.                        
A03411     MOVE WS-A8300-DATE   TO WS-FIX-DATE                          
A03411                             WS-FIX-DATE2.                        
      *                                                                         
A03411     PERFORM 7500-GET-LAST-DAY THRU 7500-EXIT.                    
A03411     MOVE WS-FIX-DATE2    TO WS-A8300-DATE.                       
A03411     DISPLAY 'WS-A8300-DATE = ' WS-A8300-DATE.                    
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PROCESSES RECORD FOUND BY THE CURSOR                        **          
      ****************************************************************          
      *                                                                         
       2000-PROCESS.                                                    
      *                                                                         
      *    MOVE WS-N TO WS-LOC-OPT-NONZERO.                                     
      *                                                                         
           IF WS-FIRST-RECORD-READ = WS-Y                               
              MOVE RV-CODE-SERVICE-TYPE  TO WS-PREV-TYPE-SERV           
              MOVE RV-MNICPLTY-COUNTY-CD TO WS-PREV-LOC-CODE            
              MOVE RV-REV-DISTRICT-CD    TO WS-PREV-REV-DIST            
              MOVE RV-COMPANY-NO         TO WS-PREV-COMPANY             
              MOVE WS-N TO WS-FIRST-RECORD-READ                         
           END-IF.                                                      
      *                                                                         
           IF RV-COMPANY-NO = WS-PREV-COMPANY                           
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 2600-LOC-CODE-BREAK THRU 2600-EXIT                
              PERFORM 2650-TYPE-SERV-BREAK THRU 2650-EXIT               
              PERFORM 2675-COMP-BREAK THRU 2675-EXIT                    
           END-IF.                                                      
      *                                                                         
           IF RV-CODE-SERVICE-TYPE = WS-PREV-TYPE-SERV                  
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 2600-LOC-CODE-BREAK THRU 2600-EXIT                
              PERFORM 2650-TYPE-SERV-BREAK THRU 2650-EXIT               
           END-IF.                                                      
      *                                                                         
           IF RV-COMPANY-NO = WS-PSNC                                   
              IF RV-REV-DISTRICT-CD = WS-PREV-REV-DIST                  
                 CONTINUE                                               
              ELSE                                                      
                 PERFORM 2600-LOC-CODE-BREAK THRU 2600-EXIT             
              END-IF                                                    
           ELSE                                                         
              IF RV-MNICPLTY-COUNTY-CD = WS-PREV-LOC-CODE               
                 CONTINUE                                               
              ELSE                                                      
                 PERFORM 2600-LOC-CODE-BREAK THRU 2600-EXIT             
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF RV-CODE-SERVICE-TYPE = 'E'                                
              PERFORM 2050-PROCESS-ELECTRIC THRU 2050-EXIT              
              PERFORM 2400-POPULATE-8300-REC THRU 2400-EXIT             
           ELSE                                                         
              IF RV-CODE-SERVICE-TYPE = 'G'                             
                 PERFORM 2075-PROCESS-GAS THRU 2075-EXIT                
                 PERFORM 2400-POPULATE-8300-REC THRU 2400-EXIT          
              ELSE                                                      
                 DISPLAY 'CODE-SERVICE-TYPE ERROR = '                   
                  RV-CODE-SERVICE-TYPE ' ACCT = ' RV-ACCOUNT-NO         
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 2500-PRINT-HEADERS THRU 2500-EXIT.                   
      *                                                                         
           PERFORM 7010-FETCH-GL-ACCT-CURSOR THRU 7010-EXIT.            
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PROCESS ELECTRIC TAXES                                      **          
      *    FRANCHISE FEES ARE TAX CONTROL NUMBER = 20               **          
      *         AND TAX TYPE = 'B'.                                 **          
      *    HOWEVER, SOMETIMES THE TAX TYPE = 'B' WILL HAVE A        **          
      *    CONTROL NUMBER = 0.  IT SI STILL A FRANCHISE FEE.        **          
      *    THEREFORE, I AM LOOKING FOR THE TAX TYPE FOR FRANCHISE   **          
      *    AND THE TAX CONTROL NUMBER FOR ALL OTHERS.               **          
      ****************************************************************          
      *                                                                         
       2050-PROCESS-ELECTRIC.                                           
      *                                                                         
           MOVE R9-TAX-AMT TO WS-8300-CONTROL-AMOUNT.                   
      *                                                                         
           IF R9-TAX-TYPE = 'B'                                         
              MOVE WS-ELE-FRAN-GL TO WS-ACCT-NO-NUM                     
              ADD R9-TAX-AMT TO WS-TAX-FRAN-LOC                         
                                WS-TAX-FRAN-TOTAL                       
                                WS-TAX-FRAN-COMPANY                     
                                WS-GND-TOT-FRAN-TAX                     
           ELSE                                                         
              EVALUATE R9-TAX-CNTRL-NO                                  
                 WHEN WS-TEN                                            
                    MOVE WS-ELE-SALES-GL TO WS-ACCT-NO-NUM              
                    ADD R9-TAX-AMT TO WS-TAX-SALES-LOC                  
                                      WS-TAX-SALES-TOTAL                
                                      WS-TAX-SALES-COMPANY              
                                      WS-GND-TOT-SALES-TAX              
                 WHEN WS-THIRTY-TWO                                     
                    MOVE R9-TAX-GL-ACCT-NO TO WS-ACCT-NO-NUM            
                    ADD R9-TAX-AMT TO WS-TAX-LOST-LOC                   
                                      WS-TAX-LOST-TOTAL                 
                                      WS-TAX-LOST-COMPANY               
                                      WS-GND-TOT-TAX-LOST               
                 WHEN WS-FORTY-TWO                                      
                    MOVE R9-TAX-GL-ACCT-NO TO WS-ACCT-NO-NUM            
                    ADD R9-TAX-AMT TO WS-TAX-CAPS-LOC                   
                                      WS-TAX-CAPS-TOTAL                 
                                      WS-TAX-CAPS-COMPANY               
                                      WS-GND-TOT-TAX-CAPS               
                 WHEN WS-FIFTY-TWO                                      
                    MOVE R9-TAX-GL-ACCT-NO TO WS-ACCT-NO-NUM            
                    ADD R9-TAX-AMT TO WS-TAX-TRAN-LOC                   
                                      WS-TAX-TRAN-TOTAL                 
                                      WS-TAX-TRAN-COMPANY               
                                      WS-GND-TOT-TAX-TRAN               
                 WHEN WS-SIXTY-TWO                                      
                    MOVE R9-TAX-GL-ACCT-NO TO WS-ACCT-NO-NUM            
                    ADD R9-TAX-AMT TO WS-TAX-EDUC-LOC                   
                                      WS-TAX-EDUC-TOTAL                 
                                      WS-TAX-EDUC-COMPANY               
                                      WS-GND-TOT-TAX-EDUC               
                 WHEN WS-EIGHTY-TWO                                     
                    MOVE R9-TAX-GL-ACCT-NO TO WS-ACCT-NO-NUM            
                    ADD R9-TAX-AMT TO WS-TAX-TOUR-LOC                   
                                      WS-TAX-TOUR-TOTAL                 
                                      WS-TAX-TOUR-COMPANY               
                                      WS-GND-TOT-TAX-TOUR               
                 WHEN OTHER                                             
                    DISPLAY 'R9-TAX-CNTRL-NO ERROR = ' R9-TAX-CNTRL-NO  
              END-EVALUATE                                              
           END-IF.                                                      
      *                                                                         
       2050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PROCESS GAS TAXES                                           **          
      *    FRANCHISE FEES ARE TAX CONTROL NUMBER = 20               **          
      *         AND TAX TYPE = 'B'.                                 **          
      *    HOWEVER, SOMETIMES THE TAX TYPE = 'B' WILL HAVE A        **          
      *    CONTROL NUMBER = 0.  IT SI STILL A FRANCHISE FEE.        **          
      *    THEREFORE, I AM LOOKING FOR THE TAX TYPE FOR FRANCHISE   **          
      *    AND THE TAX CONTROL NUMBER FOR ALL OTHERS.               **          
      ****************************************************************          
      *                                                                         
       2075-PROCESS-GAS.                                                
      *                                                                         
           MOVE R9-TAX-AMT TO WS-8300-CONTROL-AMOUNT.                   
      *                                                                         
           IF R9-TAX-TYPE = 'B'                                         
              MOVE WS-GAS-FRAN-GL  TO WS-ACCT-NO-NUM                    
              ADD R9-TAX-AMT TO WS-TAX-FRAN-LOC                         
                                WS-TAX-FRAN-TOTAL                       
                                WS-TAX-FRAN-COMPANY                     
                                WS-GND-TOT-FRAN-TAX                     
           ELSE                                                         
              EVALUATE R9-TAX-CNTRL-NO                                  
                 WHEN WS-TEN                                            
                    MOVE WS-GAS-SALES-GL TO WS-ACCT-NO-NUM              
                    ADD R9-TAX-AMT TO WS-TAX-SALES-LOC                  
                                      WS-TAX-SALES-TOTAL                
                                      WS-TAX-SALES-COMPANY              
                                      WS-GND-TOT-SALES-TAX              
                 WHEN WS-ELEVEN                                         
                    MOVE WS-GAS-SALES-GL TO WS-ACCT-NO-NUM              
                    ADD R9-TAX-AMT TO WS-TAX-SALES-LOC                  
                                      WS-TAX-SALES-TOTAL                
                                      WS-TAX-SALES-COMPANY              
                                      WS-GND-TOT-SALES-TAX              
                 WHEN WS-THIRTY-THREE                                   
                    MOVE R9-TAX-GL-ACCT-NO TO WS-ACCT-NO-NUM            
                    ADD R9-TAX-AMT TO WS-TAX-LOST-LOC                   
                                      WS-TAX-LOST-TOTAL                 
                                      WS-TAX-LOST-COMPANY               
                                      WS-GND-TOT-TAX-LOST               
                 WHEN WS-FORTY-THREE                                    
                    MOVE R9-TAX-GL-ACCT-NO TO WS-ACCT-NO-NUM            
                    ADD R9-TAX-AMT TO WS-TAX-CAPS-LOC                   
                                      WS-TAX-CAPS-TOTAL                 
                                      WS-TAX-CAPS-COMPANY               
                                      WS-GND-TOT-TAX-CAPS               
                 WHEN WS-FIFTY-THREE                                    
                    MOVE R9-TAX-GL-ACCT-NO TO WS-ACCT-NO-NUM            
                    ADD R9-TAX-AMT TO WS-TAX-TRAN-LOC                   
                                      WS-TAX-TRAN-TOTAL                 
                                      WS-TAX-TRAN-COMPANY               
                                      WS-GND-TOT-TAX-TRAN               
                 WHEN WS-SIXTY-THREE                                    
                    MOVE R9-TAX-GL-ACCT-NO TO WS-ACCT-NO-NUM            
                    ADD R9-TAX-AMT TO WS-TAX-EDUC-LOC                   
                                      WS-TAX-EDUC-TOTAL                 
                                      WS-TAX-EDUC-COMPANY               
                                     WS-GND-TOT-TAX-EDUC                
                 WHEN WS-EIGHTY-THREE                                   
                    MOVE R9-TAX-GL-ACCT-NO TO WS-ACCT-NO-NUM            
                    ADD R9-TAX-AMT TO WS-TAX-TOUR-LOC                   
                                      WS-TAX-TOUR-TOTAL                 
                                      WS-TAX-TOUR-COMPANY               
                                      WS-GND-TOT-TAX-TOUR               
                 WHEN OTHER                                             
                    DISPLAY 'R9-TAX-CNTRL-NO ERROR = ' R9-TAX-CNTRL-NO  
              END-EVALUATE                                              
           END-IF.                                                      
      *                                                                         
       2075-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * POPULATES THE OUTPUT FILE                                  ***          
      ****************************************************************          
      *                                                                         
       2400-POPULATE-8300-REC.                                          
      *                                                                         
           INITIALIZE ZIKRT8300.                                        
      *                                                                         
           MOVE ZEROS TO ZIKRT8300-STATUS-CODE                          
                         ZIKRT8300-SOURCE-SYSTEM                        
                         ZIKRT8300-BATCH-NUMBER                         
                         ZIKRT8300-BATCH-DATE                           
                         ZIKRT8300-RECORD-CONTROL-KEY.                  
      *                                                                         
           MOVE RV-COMPANY-NO TO WS-COMPANY.                            
      *                                                                         
           MOVE WS-ACCT-NO-NUM         TO ZIKRT8300-ACCOUNT-NUMBER.     
      *                                                                         
A03411     MOVE WS-COST-CENTER      TO ZIKRT8300-COST-CENTER            
A03411                                 ZIKRT8300-EG-ADMIN-COST-CENTER.  
      *                                                                         
A03411     IF RV-COMPANY-NO = '01'                                      
A03411        IF WS-ACCT-NO-NUM = WS-GAS-FRAN-GL                        
A03411           MOVE WS-495-FIX TO ZIKRT8300-BENEFIT-COST-CENTER       
A03411           MOVE WS-COST-CENTER-495-FIX TO ZIKRT8300-COST-CENTER   
A03411                                 ZIKRT8300-EG-ADMIN-COST-CENTER   
A03411        END-IF                                                    
A03411        IF WS-ACCT-NO-NUM = WS-ELE-FRAN-GL                        
A03411           MOVE WS-COST-CENTER-456-FIX TO ZIKRT8300-COST-CENTER   
A03411                                 ZIKRT8300-EG-ADMIN-COST-CENTER   
A03411        END-IF                                                    
A03411     END-IF.                                                      
           IF RV-COMPANY-NO = '26'                                      
A03411        MOVE WS-COST-CENTER-PSNC TO ZIKRT8300-COST-CENTER         
A03411                                   ZIKRT8300-EG-ADMIN-COST-CENTER 
              IF WS-ACCT-NO-NUM = WS-GAS-SALES-GL                       
                 MOVE WS-GL236         TO ZIKRT8300-ACCOUNT-NUMBER      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE WS-SOURCE-SYSTEM       TO ZIKRT8300-SOURCE-SYSTEM.      
           MOVE WS-TAX                 TO ZIKRT8300-DOCUMENT-NUMBER.    
      *                                                                         
           COMPUTE WS-CONTROL-AMOUNT = (WS-8300-CONTROL-AMOUNT * -1).   
           MOVE WS-CONTROL-AMOUNT      TO ZIKRT8300-CONTROL-AMOUNT.     
      *                                                                         
           MOVE WS-A8300-YEAR          TO ZIKRT8300-EFFECTIVE-YEAR.     
           MOVE WS-A8300-MONTH         TO ZIKRT8300-EFFECTIVE-MONTH.    
           MOVE WS-A8300-DAY           TO ZIKRT8300-EFFECTIVE-DAY.      
      *                                                                         
           MOVE WS-COMPANY             TO ZIKRT8300-COMPANY-CODE.       
      *                                                                         
           MOVE WS-FUNCTION-CODE       TO ZIKRT8300-FUNCTION-CODE.      
           MOVE WS-NOE                 TO ZIKRT8300-NOE-2.              
           MOVE WS-TRN-CODE            TO ZIKRT8300-TRANSACTION-CODE.   
           MOVE RV-LOCAL-OFFICE(1:1)   TO ZIKRT8300-SYSTEM-CODE.        
           MOVE RV-LOCAL-OFFICE(2:2)   TO ZIKRT8300-LOCAL-OFFICE.       
           MOVE ZEROS                  TO ZIKRT8300-LOC-OPT-TAX-PCT.    
      *                                                                         
           IF RV-COMPANY-NO = '26'                                      
              MOVE SPACES TO ZIKRT8300-LOCATION                         
              MOVE WS-PSNC-OPERUNIT TO ZIKRT8300-OPERATING-UNIT         
              MOVE WS-PSNC-BUSIUNIT TO ZIKRT8300-BUSINESS-UNIT          
           ELSE                                                         
              MOVE RV-MNICPLTY-COUNTY-CD TO ZIKRT8300-LOCATION          
A04527        MOVE WS-SCEG-OPERUNIT TO ZIKRT8300-OPERATING-UNIT         
A04527        MOVE WS-SCEG-BUSIUNIT TO ZIKRT8300-BUSINESS-UNIT          
A04527        IF WS-ACCT-NO-NUM = WS-GAS-FRAN-GL                        
A04527           MOVE WS-495-FIX TO ZIKRT8300-BENEFIT-COST-CENTER       
A04527           MOVE WS-COST-CENTER-495-FIX TO ZIKRT8300-COST-CENTER   
A04527                                 ZIKRT8300-EG-ADMIN-COST-CENTER   
A04527           MOVE WS-495-OPERUNIT TO ZIKRT8300-OPERATING-UNIT       
A04527           MOVE WS-495-BUSIUNIT TO ZIKRT8300-BUSINESS-UNIT        
A04527        END-IF                                                    
A04527        IF WS-ACCT-NO-NUM = WS-ELE-FRAN-GL                        
A04527           MOVE WS-COST-CENTER-456-FIX TO ZIKRT8300-COST-CENTER   
A04527                                 ZIKRT8300-EG-ADMIN-COST-CENTER   
A04527           MOVE WS-456-OPERUNIT TO ZIKRT8300-OPERATING-UNIT       
A04527           MOVE WS-456-BUSIUNIT TO ZIKRT8300-BUSINESS-UNIT        
A04527        END-IF                                                    
           END-IF.                                                      
      *                                                                         
      * FOR THE BELOW GLS, ALWAYS MOVE SPACES FOR LOCATION CODE                 
      *                                                                         
           IF WS-ACCT-NO-NUM = WS-ELE-FRAN-GL                           
              MOVE SPACES TO ZIKRT8300-LOCATION                         
           END-IF.                                                      
           IF WS-ACCT-NO-NUM = WS-GAS-FRAN-GL                           
              MOVE SPACES TO ZIKRT8300-LOCATION                         
           END-IF.                                                      
           IF WS-ACCT-NO-NUM = WS-ELE-SALES-GL                          
              MOVE SPACES TO ZIKRT8300-LOCATION                         
           END-IF.                                                      
           IF WS-ACCT-NO-NUM = WS-GAS-SALES-GL                          
              MOVE SPACES TO ZIKRT8300-LOCATION                         
           END-IF.                                                      
      *                                                                         
           PERFORM 8100-WRITE-8300-REC THRU 8100-EXIT.                  
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  PRINTS HEADER COLUMNS                                       *          
      ****************************************************************          
      *                                                                         
       2500-PRINT-HEADERS.                                              
      *                                                                         
           IF WS-FIRST-PRINT-RECORD = WS-Y                              
              IF RV-COMPANY-NO = '26'                                   
                 MOVE RV-COMPANY-NO TO C7-COMPANY-NO                    
                 PERFORM 7300-GET-COMPANY-DESC THRU 7300-EXIT           
                 MOVE C7-COMPANY-NAME TO P-COMPANY                      
              END-IF                                                    
              PERFORM 2700-HEAD-PARA THRU 2700-EXIT                     
              PERFORM 2750-WRITE-COL-HDNG THRU 2750-EXIT                
              MOVE WS-N TO WS-FIRST-PRINT-RECORD                        
           END-IF.                                                      
      *                                                                         
           IF WS-LINE-CNTR  > WS-FIFTY-SIX                              
              PERFORM 2700-HEAD-PARA THRU 2700-EXIT                     
              PERFORM 2750-WRITE-COL-HDNG THRU 2750-EXIT                
           END-IF.                                                      
      *                                                                         
           ADD WS-ONE TO WS-REP-WRITE.                                  
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PRINTS THE TOTALS BY RV-MNICPLTY-COUNTY-CD                   *          
      *                                                              *          
      *    FOR PSNC, DISPLAY THE NAME OF THE REVENUE DISTRICT,       *          
      *    RATHER THAN THE CODE. REVENUE DISTRICT CORRESPONDS TO     *          
      *    TOWN IN THEIR SYSTEM. IF THE REVENUE DISTRICT IS          *          
      *    INSIDE TOWN LIMITS (AS INDICATED BY A 'Y' FOR MUNI-IND),  *          
      *    THEN DIVIDE THE STATE TAX AMOUNT IN HALF.                 *          
      ****************************************************************          
      *                                                                         
       2600-LOC-CODE-BREAK.                                             
      *                                                                         
           MOVE WS-PREV-LOC-CODE TO WS-TOT-TEXT.                        
      *                                                                         
           MOVE WS-N TO A9-MUNICIPALITY-IND.                            
           IF WS-PREV-COMPANY = '26'                                    
              MOVE WS-PREV-REV-DIST     TO A9-REV-DISTRICT-CD           
              PERFORM 7310-GET-REV-DESC THRU 7310-EXIT                  
      *                                                                         
              MOVE A9-REV-DISTRICT-DESC TO WS-PSNC-LITERAL              
              MOVE A9-REV-DISTRICT-CD   TO PSNC-LITERAL-DISTRICT        
      *                                                                         
              IF A9-MUNICIPALITY-IND = WS-Y                             
                 COMPUTE WS-HALF-TAX = WS-TAX-SALES-LOC / 2             
                 ADD WS-HALF-TAX  TO WS-SERV-HALF-TAX                   
                                     WS-HALF-TAX-COMPANY                
                                     WS-GND-HALF-TAX                    
              END-IF                                                    
           ELSE                                                         
               MOVE WS-PREV-REV-DIST TO WS-DET-REV-DIST                 
           END-IF.                                                      
      *                                                                         
           MOVE WS-TAX-SALES-LOC   TO WS-DET-SAL-TAX.                   
           MOVE WS-HALF-TAX        TO WS-DET-TOT-HALF.                  
           MOVE WS-TAX-TOUR-LOC    TO WS-DET-TOT-TOUR.                  
           MOVE WS-TAX-LOST-LOC    TO WS-DET-TOT-LOST.                  
           MOVE WS-TAX-CAPS-LOC    TO WS-DET-TOT-CAPS.                  
           MOVE WS-TAX-TRAN-LOC    TO WS-DET-TOT-TRAN.                  
           MOVE WS-TAX-EDUC-LOC    TO WS-DET-TOT-EDUC.                  
           MOVE WS-TAX-FRAN-LOC    TO WS-DET-TOT-FRAN.                  
           MOVE WS-PRT-TOTAL-LINE  TO RPT-LINE.                         
           MOVE WS-TWO             TO WS-LINE-SPACE.                    
           ADD  WS-TWO             TO WS-LINE-CNTR.                     
           PERFORM 8200-WRITE-PRINT-REC THRU 8200-EXIT.                 
      *                                                                         
           IF WS-PREV-COMPANY = '26'                                    
              PERFORM 4000-INITIALIZE-PSNC-LINE THRU 4000-EXIT          
              PERFORM 8300-WRITE-PSNC-FILE THRU 8300-EXIT               
           END-IF.                                                      
      *                                                                         
           MOVE RV-MNICPLTY-COUNTY-CD TO WS-PREV-LOC-CODE.              
           MOVE RV-REV-DISTRICT-CD    TO WS-PREV-REV-DIST.              
           MOVE RV-LOCAL-OFFICE       TO WS-PREV-LOCAL-OFFICE.          
           MOVE ZEROS                 TO WS-PREV-LOC-TAX-PCT.           
           MOVE ZEROS                 TO WS-TAX-SALES-LOC               
                                         WS-HALF-TAX                    
                                         WS-TAX-LOST-LOC                
                                         WS-TAX-TOUR-LOC                
                                         WS-TAX-LOST-LOC                
                                         WS-TAX-CAPS-LOC                
                                         WS-TAX-TRAN-LOC                
                                         WS-TAX-EDUC-LOC                
                                         WS-TAX-FRAN-LOC.               
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PRINTS THE TOTALS BY TYPE-SERVICE                            *          
      ****************************************************************          
      *                                                                         
       2650-TYPE-SERV-BREAK.                                            
      *                                                                         
           IF  WS-PREV-TYPE-SERV = 'E'                                  
               MOVE SPACES TO WS-SCEG-DATA                              
               MOVE 'ELECTRIC' TO WS-TOT-TEXT                           
               MOVE 'TOTALS :' TO WS-DET-REV-DIST                       
               MOVE RV-CODE-SERVICE-TYPE TO WS-PREV-TYPE-SERV           
           ELSE                                                         
               MOVE SPACES TO WS-SCEG-DATA                              
               MOVE 'GAS' TO WS-TOT-TEXT                                
               MOVE 'TOTALS :' TO WS-DET-REV-DIST                       
               MOVE RV-CODE-SERVICE-TYPE TO WS-PREV-TYPE-SERV           
           END-IF.                                                      
      *                                                                         
           MOVE WS-TAX-SALES-TOTAL   TO WS-DET-SAL-TAX.                 
           MOVE WS-SERV-HALF-TAX     TO WS-DET-TOT-HALF.                
           MOVE WS-TAX-TOUR-TOTAL    TO WS-DET-TOT-TOUR.                
           MOVE WS-TAX-LOST-TOTAL    TO WS-DET-TOT-LOST.                
           MOVE WS-TAX-CAPS-TOTAL    TO WS-DET-TOT-CAPS.                
           MOVE WS-TAX-TRAN-TOTAL    TO WS-DET-TOT-TRAN.                
           MOVE WS-TAX-EDUC-TOTAL    TO WS-DET-TOT-EDUC.                
           MOVE WS-TAX-FRAN-TOTAL    TO WS-DET-TOT-FRAN.                
           MOVE WS-FIFTY-SEVEN       TO WS-LINE-CNTR.                   
           MOVE ZEROS                TO WS-SERV-HALF-TAX                
                                        WS-TAX-SALES-TOTAL              
                                        WS-TAX-TOUR-TOTAL               
                                        WS-TAX-LOST-TOTAL               
                                        WS-TAX-CAPS-TOTAL               
                                        WS-TAX-TRAN-TOTAL               
                                        WS-TAX-EDUC-TOTAL               
                                        WS-TAX-FRAN-TOTAL.              
      *                                                                         
           MOVE WS-PRT-TOTAL-LINE TO RPT-LINE.                          
           MOVE WS-TWO            TO WS-LINE-SPACE.                     
           ADD  WS-TWO            TO WS-LINE-CNTR.                      
           PERFORM 8200-WRITE-PRINT-REC THRU 8200-EXIT.                 
      *                                                                         
           IF WS-PREV-COMPANY = '26'                                    
              MOVE WS-GAS-REV        TO PSNC-LITERAL-DISTRICT           
              PERFORM 4000-INITIALIZE-PSNC-LINE THRU 4000-EXIT          
              PERFORM 8300-WRITE-PSNC-FILE THRU 8300-EXIT               
           END-IF.                                                      
      *                                                                         
       2650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PRINTS THE TOTALS BY COMPANY                                 *          
      ****************************************************************          
      *                                                                         
       2675-COMP-BREAK.                                                 
      *                                                                         
           MOVE SPACES        TO WS-SCEG-DATA.                          
           MOVE 'COMPANY '    TO WS-TOT-TEXT.                           
           MOVE 'TOTALS :'    TO WS-DET-REV-DIST.                       
      *                                                                         
           MOVE WS-TAX-SALES-COMPANY TO WS-DET-SAL-TAX.                 
           MOVE WS-HALF-TAX-COMPANY  TO WS-DET-TOT-HALF.                
           MOVE WS-TAX-TOUR-COMPANY  TO WS-DET-TOT-TOUR.                
           MOVE WS-TAX-LOST-COMPANY  TO WS-DET-TOT-LOST.                
           MOVE WS-TAX-CAPS-COMPANY  TO WS-DET-TOT-CAPS.                
           MOVE WS-TAX-TRAN-COMPANY  TO WS-DET-TOT-TRAN.                
           MOVE WS-TAX-EDUC-COMPANY  TO WS-DET-TOT-EDUC.                
           MOVE WS-TAX-FRAN-COMPANY  TO WS-DET-TOT-FRAN.                
           MOVE ZEROS                TO WS-TAX-SALES-COMPANY            
                                        WS-HALF-TAX-COMPANY             
                                        WS-TAX-TOUR-COMPANY             
                                        WS-TAX-LOST-COMPANY             
                                        WS-TAX-CAPS-COMPANY             
                                        WS-TAX-TRAN-COMPANY             
                                        WS-TAX-EDUC-COMPANY             
                                        WS-TAX-FRAN-COMPANY.            
      *                                                                         
           MOVE WS-PRT-TOTAL-LINE   TO RPT-LINE.                        
           MOVE WS-TWO              TO WS-LINE-SPACE.                   
           ADD  WS-TWO              TO WS-LINE-CNTR.                    
           PERFORM 8200-WRITE-PRINT-REC THRU 8200-EXIT.                 
      *                                                                         
           IF WS-PREV-COMPANY = '26'                                    
              MOVE WS-COMPANY-REV    TO PSNC-LITERAL-DISTRICT           
              PERFORM 4000-INITIALIZE-PSNC-LINE THRU 4000-EXIT          
              PERFORM 8300-WRITE-PSNC-FILE THRU 8300-EXIT               
           END-IF.                                                      
      *                                                                         
           MOVE RV-COMPANY-NO TO WS-PREV-COMPANY.                       
           MOVE RV-COMPANY-NO TO C7-COMPANY-NO.                         
           PERFORM 7300-GET-COMPANY-DESC THRU 7300-EXIT.                
           MOVE C7-COMPANY-NAME TO P-COMPANY.                           
      *                                                                         
       2675-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  PRINTS THE PAGE HEADINGS                                   **          
      ****************************************************************          
      *                                                                         
       2700-HEAD-PARA.                                                  
      *                                                                         
           MOVE 0          TO WS-LINE-CNTR.                             
           ADD WS-ONE      TO WS-PAGE.                                  
           MOVE WS-PAGE    TO WS-DET-PAGE.                              
           MOVE WS-HDR-ONE TO RPT-LINE.                                 
           WRITE FS-PRINT-REC AFTER ADVANCING PAGE.                     
           MOVE WS-HDR-TWO TO RPT-LINE.                                 
           MOVE WS-ONE     TO WS-LINE-SPACE.                            
           PERFORM 8200-WRITE-PRINT-REC THRU 8200-EXIT.                 
           ADD  WS-TWO     TO WS-LINE-CNTR.                             
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * WRITES THE COLUMN HEADINGS ON THE TOP OF EACH PAGE           *          
      ****************************************************************          
      *                                                                         
       2750-WRITE-COL-HDNG.                                             
      *                                                                         
           IF WS-PREV-TYPE-SERV = 'E'                                   
              MOVE 'ELECTRIC'        TO WS-RPT-SERV                     
              MOVE WS-ELE-SALES-GL   TO WS-HDR5-SALE                    
              MOVE WS-ELE-FRAN-GL    TO WS-HDR5-FRAN                    
              MOVE WS-ELEC-ACCT-TOUR TO WS-HDR5-TOUR                    
              MOVE WS-ELEC-ACCT-LOST TO WS-HDR5-LOST                    
              MOVE WS-ELEC-ACCT-CAPS TO WS-HDR5-CAPS                    
              MOVE WS-ELEC-ACCT-TRAN TO WS-HDR5-TRAN                    
              MOVE WS-ELEC-ACCT-EDUC TO WS-HDR5-EDUC                    
           ELSE                                                         
              MOVE 'GAS' TO WS-RPT-SERV                                 
              IF RV-COMPANY-NO = '26'                                   
                 MOVE WS-GL236   TO WS-HDR5-SALE                        
              ELSE                                                      
                 MOVE WS-GAS-SALES-GL TO WS-HDR5-SALE                   
              END-IF                                                    
              MOVE WS-GAS-FRAN-GL    TO WS-HDR5-FRAN                    
              MOVE WS-GAS-ACCT-TOUR  TO WS-HDR5-TOUR                    
              MOVE WS-GAS-ACCT-LOST  TO WS-HDR5-LOST                    
              MOVE WS-GAS-ACCT-CAPS  TO WS-HDR5-CAPS                    
              MOVE WS-GAS-ACCT-TRAN  TO WS-HDR5-TRAN                    
              MOVE WS-GAS-ACCT-EDUC  TO WS-HDR5-EDUC                    
           END-IF.                                                      
      *                                                                         
           MOVE WS-HDR-THREE TO RPT-LINE.                               
           MOVE WS-TWO TO WS-LINE-SPACE.                                
           PERFORM 8200-WRITE-PRINT-REC THRU 8200-EXIT.                 
           ADD WS-TWO TO WS-LINE-CNTR.                                  
      *                                                                         
           MOVE WS-HDR-FOUR TO RPT-LINE.                                
           MOVE WS-ONE TO WS-LINE-SPACE.                                
           PERFORM 8200-WRITE-PRINT-REC THRU 8200-EXIT.                 
      *                                                                         
           IF WS-1ST-SW = WS-Y                                          
              MOVE WS-SALE-GL TO WS-HDR5-1                              
              MOVE WS-TOUR-GL TO WS-HDR5-2                              
              MOVE WS-LOST-GL TO WS-HDR5-3                              
              MOVE WS-CAPS-GL TO WS-HDR5-4                              
              MOVE WS-TRAN-GL TO WS-HDR5-5                              
              MOVE WS-EDUC-GL TO WS-HDR5-6                              
              MOVE WS-FRAN-GL TO WS-HDR5-7                              
              MOVE WS-N TO WS-1ST-SW                                    
      *                                                                         
      * DO THE HEADERS FOR PSNC OUTPUT FILE ONCE.                               
      *                                                                         
              MOVE WS-PSNC-HDR-ONE TO PSNC-LINE                         
              PERFORM 4000-INITIALIZE-PSNC-DELIM THRU 4000-EXIT         
              PERFORM 8300-WRITE-PSNC-FILE THRU 8300-EXIT               
              MOVE WS-SCEG-HDR TO P-COMPANY                             
              MOVE WS-PSNC-HDR-TWO TO PSNC-LINE                         
              PERFORM 4000-INITIALIZE-PSNC-DELIM THRU 4000-EXIT         
              PERFORM 8300-WRITE-PSNC-FILE THRU 8300-EXIT               
              MOVE WS-PSNC-HDR-THREE TO PSNC-LINE                       
              PERFORM 4000-INITIALIZE-PSNC-DELIM THRU 4000-EXIT         
              PERFORM 8300-WRITE-PSNC-FILE THRU 8300-EXIT               
              MOVE WS-PSNC-HDR-FOUR TO PSNC-LINE                        
              MOVE '000'            TO PSNC-LITERAL-DISTRICT            
              PERFORM 4000-INITIALIZE-PSNC-DELIM THRU 4000-EXIT         
              PERFORM 8300-WRITE-PSNC-FILE THRU 8300-EXIT               
              MOVE WS-GL236          TO WS-PSNC-HDR5-SALE               
              MOVE WS-GL-FRAN        TO WS-PSNC-HDR5-FRAN               
              MOVE WS-GL-TOUR        TO WS-PSNC-HDR5-TOUR               
              MOVE WS-GL-LOST        TO WS-PSNC-HDR5-LOST               
              MOVE WS-GL-CAPS        TO WS-PSNC-HDR5-CAPS               
              MOVE WS-GL-TRAN        TO WS-PSNC-HDR5-TRAN               
              MOVE WS-GL-EDUC        TO WS-PSNC-HDR5-EDUC               
              MOVE WS-PSNC-HDR-FIVE  TO PSNC-LINE                       
              MOVE '000'             TO PSNC-LITERAL-DISTRICT           
              PERFORM 4000-INITIALIZE-PSNC-DELIM THRU 4000-EXIT         
              PERFORM 8300-WRITE-PSNC-FILE THRU 8300-EXIT               
           END-IF.                                                      
      *                                                                         
           ADD WS-ONE       TO WS-LINE-CNTR.                            
           MOVE WS-HDR-FIVE TO RPT-LINE.                                
           MOVE WS-ONE      TO WS-LINE-SPACE.                           
           PERFORM 8200-WRITE-PRINT-REC THRU 8200-EXIT.                 
           ADD WS-ONE       TO WS-LINE-CNTR.                            
           MOVE WS-Y        TO WS-FIRST-REC-WRITE.                      
      *                                                                         
       2750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * GRAND TOTALS                                                 *          
      ****************************************************************          
      *                                                                         
       2800-SUMM-REPORT.                                                
      *                                                                         
           MOVE 'GRAND  '               TO WS-TOT-TEXT.                 
           MOVE 'TOTALS :'              TO WS-DET-REV-DIST.             
           MOVE WS-GND-TOT-SALES-TAX    TO WS-DET-SAL-TAX.              
           MOVE WS-GND-HALF-TAX         TO WS-DET-TOT-HALF.             
           MOVE WS-GND-TOT-TAX-TOUR     TO WS-DET-TOT-TOUR.             
           MOVE WS-GND-TOT-TAX-LOST     TO WS-DET-TOT-LOST.             
           MOVE WS-GND-TOT-TAX-CAPS     TO WS-DET-TOT-CAPS.             
           MOVE WS-GND-TOT-TAX-TRAN     TO WS-DET-TOT-TRAN.             
           MOVE WS-GND-TOT-TAX-EDUC     TO WS-DET-TOT-EDUC.             
           MOVE WS-GND-TOT-FRAN-TAX     TO WS-DET-TOT-FRAN.             
           MOVE WS-PRT-TOTAL-LINE       TO RPT-LINE.                    
           MOVE WS-TWO                  TO WS-LINE-SPACE.               
           PERFORM 2850-WRITE-PRINT-REC THRU 2850-EXIT.                 
      *                                                                         
           MOVE WS-TWO                  TO WS-LINE-SPACE.               
           MOVE WS-REP-WRITE            TO WS-REP-WRITTEN.              
           MOVE WS-RECORDS-WRITTEN      TO RPT-LINE.                    
           PERFORM 2850-WRITE-PRINT-REC THRU 2850-EXIT.                 
           MOVE WS-FOOT-LINE            TO RPT-LINE.                    
           MOVE WS-ONE                  TO WS-LINE-SPACE.               
           PERFORM 2850-WRITE-PRINT-REC THRU 2850-EXIT.                 
      *                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * WRITES INTO THE REPORT                                       *          
      ****************************************************************          
      *                                                                         
       2850-WRITE-PRINT-REC.                                            
      *                                                                         
           WRITE FS-PRINT-REC AFTER ADVANCING WS-LINE-SPACE.            
      *                                                                         
       2850-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * FOR PSNC - LOADS THE PRINTED LINE DATA TO THE OUTPUT FILE    *          
      *    AND CONVERTS THE ALPHA NUMBERS TO NUMERIC.  ALSO,         *          
      *    PUTS X'05' TO ALLOW FILE TO BE OPENED AS EXCEL.           *          
      *    ALSO, HAS EXTRA PARAGRAPH NAME TO ALLOW FOR DELIMS ONLY   *          
      *    FOR THE HEADER ROUTINE.                                   *          
      ****************************************************************          
      *                                                                         
       4000-INITIALIZE-PSNC-LINE.                                       
      *                                                                         
           MOVE WS-PSNC-DATA TO PSNC-DATA.                              
           MOVE WS-PSNC-FILE-BREAK TO PSNC-OUT-DATA.                    
      *                                                                         
           COMPUTE PSNC-DET-SAL-TAX = FUNCTION NUMVAL-C                 
                   (WS-DET-SAL-TAX).                                    
           COMPUTE PSNC-DET-TOT-TOUR = FUNCTION NUMVAL-C                
                   (WS-DET-TOT-TOUR).                                   
           COMPUTE PSNC-DET-TOT-LOST = FUNCTION NUMVAL-C                
                   (WS-DET-TOT-LOST).                                   
           COMPUTE PSNC-DET-TOT-CAPS = FUNCTION NUMVAL-C                
                   (WS-DET-TOT-CAPS).                                   
           COMPUTE PSNC-DET-TOT-TRAN = FUNCTION NUMVAL-C                
                   (WS-DET-TOT-TRAN).                                   
           COMPUTE PSNC-DET-TOT-EDUC = FUNCTION NUMVAL-C                
                   (WS-DET-TOT-EDUC).                                   
           COMPUTE PSNC-DET-TOT-FRAN = FUNCTION NUMVAL-C                
                   (WS-DET-TOT-FRAN).                                   
           COMPUTE PSNC-DET-TOT-HALF = FUNCTION NUMVAL-C                
                   (WS-DET-TOT-HALF).                                   
      *                                                                         
       4000-INITIALIZE-PSNC-DELIM.                                      
      *                                                                         
           MOVE WS-PSNC-DELIM TO PSNC-DEL1                              
                                 PSNC-DEL2                              
                                 PSNC-DEL3                              
                                 PSNC-DEL4                              
                                 PSNC-DEL5                              
                                 PSNC-DEL6                              
                                 PSNC-DEL7                              
                                 PSNC-DEL8                              
                                 PSNC-DEL9                              
                                 PSNC-DEL10.                            
      *                                                                         
       4000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** OPENS GL_ACCT_CURSOR                                       **          
      ****************************************************************          
      *                                                                         
       7000-OPEN-GL-ACCT-CURSOR.                                        
      *                                                                         
           EXEC SQL                                                     
              OPEN GL_ACCT_CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA233  ABORT ***************'      
              DISPLAY '* 7000-OPEN-GL-ACCT-CURSOR               *'      
              DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE              
              DISPLAY '* PROGRAM ABORTING...                    *'      
              DISPLAY '********** PCSCA233  ABORT ***************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** FETCHES THE TAX FIELDS                                     **          
      ****************************************************************          
      *                                                                         
       7010-FETCH-GL-ACCT-CURSOR.                                       
      *                                                                         
           EXEC SQL                                                     
              FETCH GL_ACCT_CURSOR                                      
               INTO  :RV-ACCOUNT-NO                                     
                    ,:RV-REV-DISTRICT-CD                                
                    ,:RV-MNICPLTY-COUNTY-CD                             
                    ,:RV-CODE-SERVICE-TYPE                              
                    ,:RV-CODE-UTIL-TYPE                                 
                    ,:RV-COMPANY-NO                                     
                    ,:RV-LOCAL-OFFICE                                   
                    ,:R9-TAX-CNTRL-NO                                   
                    ,:R9-TAX-GL-ACCT-NO                                 
                    ,:R9-TAX-AMT                                        
                    ,:R9-TAX-TYPE                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE WS-Y TO WS-END-OF-DATA                            
              ELSE                                                      
                 DISPLAY '********** PCSCA233 ABORT ***************'    
                 DISPLAY '* 7010-FETCH-GL-ACCT-CURSOR             *'    
                 DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE           
                 DISPLAY '* REVENUE MONTH = ' WS-REVENUE-MONTH-P        
                 DISPLAY '* PROGRAM ABORTING...                   *'    
                 DISPLAY '********** PCSCA233 ABORT ***************'    
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** CLOSES THE GL-ACCT-CURSOR CURSOR                           **          
      ****************************************************************          
      *                                                                         
       7020-CLOSE-GL-ACCT-CURSOR.                                       
      *                                                                         
           EXEC SQL                                                     
              CLOSE GL_ACCT_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA233 ABORT ****************'      
              DISPLAY '* 7020-CLOSE-GL-ACCT-CURSOR              *'      
              DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE              
              DISPLAY '* PROGRAM ABORTING...                    *'      
              DISPLAY '********** PCSCA233 ABORT ****************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  GET THE CURRENT DATE                                      **          
      ****************************************************************          
      *                                                                         
       7200-GET-CURRENT-DATE.                                           
      *                                                                         
            EXEC SQL                                                    
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATEALL                  
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SET :WS-CURRENT-DATEALL = CURRENT DATE                          
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-CURRENT-DATEALL TO WS-CURRENT-DATE                
           ELSE                                                         
              DISPLAY '*****************************************'       
              DISPLAY '**ERROR RETRIEVING CURRENT DATE        **'       
              DISPLAY '**7200-GET-CURRENT-DATE                **'       
              DISPLAY '**SQLCODE = ' WS-ACTIVE-RETURN-CODE              
              DISPLAY '*****************************************'       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  GET THE COMPNAY DESCRIPTION                               **          
      ****************************************************************          
      *                                                                         
       7300-GET-COMPANY-DESC.                                           
      *                                                                         
            EXEC SQL                                                    
                SELECT COMPANY_NAME                                     
                INTO   :C7-COMPANY-NAME                                 
                FROM   CSS_COMPANY WITH(READUNCOMMITTED)                        
                WHERE  COMPANY_NO = :C7-COMPANY-NO                      
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT COMPANY_NAME                                             
MFA-TR*         INTO   :C7-COMPANY-NAME                                         
MFA-TR*         FROM   CSS_COMPANY                                              
MFA-TR*         WHERE  COMPANY_NO = :C7-COMPANY-NO                              
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
            ELSE                                                        
               DISPLAY '*****************************************'      
               DISPLAY '**ERROR RETRIEVING COMPANY NAME        **'      
               DISPLAY '**7300-GET-COMPANY-DESC                **'      
               DISPLAY '**SQLCODE = ' WS-ACTIVE-RETURN-CODE             
               DISPLAY '**COMPANY NO = ' C7-COMPANY-NO                  
               DISPLAY '*****************************************'      
               PERFORM 9900-ABEND THRU 9900-EXIT                        
            END-IF.                                                     
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  GET THE REVENUE DISTRICT DESCRIPTION                      **          
      ****************************************************************          
      *                                                                         
       7310-GET-REV-DESC.                                               
            EXEC SQL                                                    
                SELECT REV_DISTRICT_DESC,                               
                       MUNICIPALITY_IND                                 
                INTO   :A9-REV-DISTRICT-DESC,                           
                       :A9-MUNICIPALITY-IND                             
                FROM   CSS_REV_DISTRICT WITH(READUNCOMMITTED)                   
                WHERE  REV_DISTRICT_CD = :A9-REV-DISTRICT-CD            
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT REV_DISTRICT_DESC,                                       
MFA-TR*                MUNICIPALITY_IND                                         
MFA-TR*         INTO   :A9-REV-DISTRICT-DESC,                                   
MFA-TR*                :A9-MUNICIPALITY-IND                                     
MFA-TR*         FROM   CSS_REV_DISTRICT                                         
MFA-TR*         WHERE  REV_DISTRICT_CD = :A9-REV-DISTRICT-CD                    
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7310                                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
            ELSE                                                        
               DISPLAY '*****************************************'      
               DISPLAY '**     7310-GET-REV-DESC               **'      
               DISPLAY '**ERROR RETRIEVING REVENUE DESC        **'      
               DISPLAY '**SQLCODE = ' WS-ACTIVE-RETURN-CODE             
               DISPLAY '**REV DISTRICT = ' A9-REV-DISTRICT-CD           
               DISPLAY '*****************************************'      
               PERFORM 9900-ABEND THRU 9900-EXIT                        
            END-IF.                                                     
      *                                                                         
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  GET REVENUE MONTH USING PCSCA204 JOB PARM                 **          
      ****************************************************************          
      *                                                                         
       7400-GET-REVENUE-MONTH.                                          
      *                                                                         
           EXEC SQL                                                     
               SELECT  PARM_DATA                                        
                 INTO  :G6-PARM-DATA                                    
               FROM  CSS_JOB_PARM WITH(READUNCOMMITTED)                         
              WHERE  PROGRAM_NAME = :G6-PROGRAM-NAME                    
                AND  CMND_CODE    = :G6-CMND-CODE                       
                AND  COMPANY_NO   = :G6-COMPANY-NO                      
                AND  SEQ_NO       = :G6-SEQ-NO                          
                AND  STATUS       = :G6-STATUS                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  PARM_DATA                                                
MFA-TR*          INTO  :G6-PARM-DATA                                            
MFA-TR*        FROM  CSS_JOB_PARM                                               
MFA-TR*       WHERE  PROGRAM_NAME = :G6-PROGRAM-NAME                            
MFA-TR*         AND  CMND_CODE    = :G6-CMND-CODE                               
MFA-TR*         AND  COMPANY_NO   = :G6-COMPANY-NO                              
MFA-TR*         AND  SEQ_NO       = :G6-SEQ-NO                                  
MFA-TR*         AND  STATUS       = :G6-STATUS                                  
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*****************************************'       
              DISPLAY '**ERROR RETRIEVING REVENUE MONTH       **'       
              DISPLAY '**   FROM JOB PARM - PCSCA204          **'       
              DISPLAY '**7400-GET-REVENUE-MONTH               **'       
              DISPLAY '**SQLCODE = ' WS-ACTIVE-RETURN-CODE              
              DISPLAY '**G6-PROGRAM-NAME = ' G6-PROGRAM-NAME            
              DISPLAY '**G6-CMND-CODE    = ' G6-CMND-CODE               
              DISPLAY '**G6-COMPANY-NO   = ' G6-COMPANY-NO              
              DISPLAY '**G6-SEQ-NO       = ' G6-SEQ-NO                  
              DISPLAY '**G6-STATUS       = ' G6-STATUS                  
              DISPLAY '*****************************************'       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
A03411**  GET DATE WITH THE LAST DAY OF THE CURRENT MONTH           **          
      ****************************************************************          
      *                                                                         
A03411 7500-GET-LAST-DAY.                                               
      *                                                                         
A03411     EXEC SQL                                                     
A03411        SELECT
              DATEADD( DAY, -1, DATEADD( MONTH, 1, 
              IIF(TRY_CONVERT(DATE, :WS-FIX-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-FIX-DATE
              ) <> 0) OR (LEN(:WS-FIX-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-FIX-DATE
              ), CONVERT(DATE, :WS-FIX-DATE) ) ) )
            INTO
              :WS-FIX-DATE2                 
A03411     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-FIX-DATE2 =                                               
MFA-TR*            DATE(:WS-FIX-DATE) + 1 MONTH - 1 DAY                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A03411     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
A03411     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A03411        NEXT SENTENCE                                             
A03411     ELSE                                                         
A03411        DISPLAY '*****************************************'       
A03411        DISPLAY '**ERROR RETRIEVING LAST DAY OF MONTH   **'       
A03411        DISPLAY '**7500-GET-LAST-DAY                    **'       
A03411        DISPLAY '**SQLCODE = ' WS-ACTIVE-RETURN-CODE              
A03411        DISPLAY '**WS-CURRENT-DATEALL = ' WS-CURRENT-DATEALL      
A03411        DISPLAY '*****************************************'       
A03411        PERFORM 9900-ABEND THRU 9900-EXIT                         
A03411     END-IF.                                                      
      *                                                                         
A03411 7500-EXIT.                                                       
A03411     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 7600-START-FCSJC01                                           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * WRITES EACH RECORD RETRIEVED FROM THE CURSOR TO THE FILE     *          
      ****************************************************************          
      *                                                                         
       8100-WRITE-8300-REC.                                             
      *                                                                         
           WRITE ZIKRT8300.                                             
      *                                                                         
           IF CRR03-SUCCESSFUL                                          
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA233  ABORT ***************'      
              DISPLAY '* 8100-WRITE-8300-REC                    *'      
              DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE              
              DISPLAY '* COMPANY CODE   = ' ZIKRT8300-COMPANY-CODE      
              DISPLAY '* ACCOUNT NUMBER = ' ZIKRT8300-ACCOUNT-NUMBER    
              DISPLAY '* COST CENTER    = ' ZIKRT8300-COST-CENTER       
              DISPLAY '* LOCAL OFFICE   = ' ZIKRT8300-LOCAL-OFFICE      
              DISPLAY '********** PCSCA233  ABORT ***************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * WRITES INTO THE REPORT                                       *          
      ****************************************************************          
      *                                                                         
       8200-WRITE-PRINT-REC.                                            
      *                                                                         
           WRITE FS-PRINT-REC AFTER ADVANCING WS-LINE-SPACE.            
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * WRITES OUTPUT RECORD FOR PSNC ACCOUNTS                       *          
      ****************************************************************          
      *                                                                         
       8300-WRITE-PSNC-FILE.                                            
      *                                                                         
           WRITE PSNC-LINE.                                             
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * NORMAL JOB TERMINATION                                       *          
      ****************************************************************          
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE MRSCRR03-FILE                                          
                 PSNCFILE-RECORD                                        
                 PRINTER1.                                              
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  ENDS TASK UNDER ABNORMAL TERMINATION                        *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
