       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA232.                                        
       DATE-WRITTEN.   MAY 2008.                                        
      ***************************************************************** PCS00050
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               ** PCS00060
      **                                                             ** PCS00110
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             ** PCS00150
      **              PROGRAM  MODIFICATION  LOG                     ** PCS00160
      **    DATE      INITIALS      REASON                           ** PCS00170
      **    ____      ________      _______                          ** PCS00180
T30169**    05/05/08  MN90523       INITIAL                          **         
A644  **    01/23/09  CVNS          MAIL ID HAS BEEN CHANGED AS      **         
A644  **              CHENNAI       ISTCSRCAPSSUPPORT@SCANA.COM.     **         
      **                                                             **         
      ***************************************************************** PCS00210
      ***************************************************************** PCS00210
      *                                                                 00240000
      * PROGRAM NARRATIVE                                                       
      *                                                                         
      * PCSCA232 PROCESS FCSCA231, ASSIGNS COLLECTION AGENCY CODE               
      * AND COLLECTION AGENCY SUB CODE BASED ON THE RANDOM NO, ACCOUNT          
      * TYPE, ACTION TYPE AND COLLECTION AGENCY PERCENTAGE AND WRITES           
      * INTO FCSCA232 (FORMAT FIOCA236),                                        
      * REG GROUP CD, ACTION TYPE, ACCOUNT TYPE ARE THE KEY FIELDS FOR          
      * HEADER AND DETAIL RECORD                                                
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                 PCS01190
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSCA231.                                                           
       COPY CSSCA226.                                                           
       COPY CSSCM232.                                                           
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDCA231.                                                           
       COPY FIOCA231.                                                           
       COPY CFDCA226.                                                           
       COPY FIOCA226.                                                           
       COPY CFDCM232.                                                           
       COPY FIOCM232.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA232'.
MSQ017     COPY MFASQLM.
       01  WS-WORK-AREA.                                                
           05  WS-PROGRAM-DATE            PIC X(10).                    
           05  WS-COMPANY-NO              PIC X(02).                    
           05  WS-ACCOUNT-NO              PIC S9(13)V   COMP-3 VALUE 0. 
           05  NULL-VALUE                 PIC S9(4)     COMP VALUE -1.  
           05  NOT-NULL-VALUE             PIC S9(4)     COMP VALUE +0.  
           05  WS-TIMESTAMP               PIC X(26)     VALUE SPACES.   
           05  WS-DISPLAY-SQLCODE         PIC -ZZZZZZZZ9.               
           05  WS-PROGRAM-DATE-XX.                                      
               10  WS-PROGRAM-DATE-CCYYMM PIC X(07).                    
               10  WS-PROGRAM-DATE-DASH2  PIC X(01).                    
               10  WS-PROGRAM-DATE-DA     PIC X(02).                    
           05  WS-CREDBUR-DATE-XX.                                      
               10  WS-CREDBUR-DATE-CCYYMM PIC X(07).                    
               10  WS-CREDBUR-DATE-DASH2  PIC X(01).                    
               10  WS-CREDBUR-DATE-DA     PIC X(02).                    
           05  WS-JOB-PARM-STATUS         PIC X(1)  VALUE 'A'.          
           05  WS-HDR-COUNT               PIC S9(9) COMP VALUE 0.       
           05  WS-HDR-AMT                 PIC S9(9)V9(2) COMP-3 VALUE 0.
           05  WS-HDR-ACTION-TYPE         PIC X(05).                    
           05  WS-HDR-ACCOUNT-TYPE        PIC X(01).                    
           05  WS-HDR-REG-GROUP           PIC X(03).                    
           05  WS-GROUP-COUNT             PIC S9(9) COMP VALUE 0.       
           05  WS-GROUP-AMT               PIC S9(9)V9(2) COMP-3 VALUE 0.
           05  WS-AGENCY-AMT              PIC S9(9)V9(2) COMP-3 VALUE 0.
           05  WS-EXCP-CODE-COLLEC-AGNCY  PIC X(03).                    
           05  WS-EXCP-COLL-AGY-SUB-CD    PIC X(03).                    
                                                                        
       01  WS-FIOCA231-REC.                                             
           05  WS-RAND-NUM-CA231          PIC 9(07).                    
           05  WS-RECORD-TYPE             PIC X(01).                    
           05  WS-REG-GROUP-CD            PIC X(03).                    
           05  WS-ACTION-TYPE-CD          PIC X(05).                    
           05  WS-ACCOUNT-TYPE-CD         PIC X(01).                    
           05  WS-PART1-FIELDS-CA231.                                   
               10 WS-PART1-SUB1           PIC X(12).                    
               10 WS-ACCOUNT-NO-CA231     PIC X(13).                    
               10 WS-PART1-SUB2           PIC X(35).                    
           05  WS-CODE-COLLEC-AGNCY       PIC X(03).                    
           05  WS-COLL-AGY-SUB-CD         PIC X(03).                    
           05  WS-PART2-FIELDS-CA231      PIC X(02).                    
COB305     05 WS-WRITE-OFF-BAL        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.  
           05  WS-PART3-FIELDS-CA231      PIC X(223).                   
           05  WS-PART4-FIELDS-CA231      PIC X(50).                    
                                                                        
       01  WS-FIOCA226-REC.                                             
           05  WS-PART1-FIELDS-CA226      PIC X(60).                    
           05  WS-ACTION-TYPE-CD-CA226    PIC X(05).                    
           05  WS-CODE-COLLEC-AGNCY-CA226 PIC X(03).                    
           05  WS-COLL-AGY-SUB-CD-CA226   PIC X(03).                    
           05  WS-PART2-FIELDS-CA226      PIC X(02).                    
           05  WS-ACCOUNT-TYPE-CD-CA226   PIC X(01).                    
COB305     05 WS-WRITE-OFF-BAL-CA226        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.  
           05  WS-PART3-FIELDS-CA226      PIC X(223).                   
           05  WS-REG-GROUP-CD-CA226      PIC X(03).                    
           05  WS-PART4-FIELDS-CA226      PIC X(50).                    
                                                                        
       01  WS-TABLES.                                                   
           05  WS-COLL-AGY-PCT-DATA.                                    
               10 WS-PCT-MAX                PIC 9(04) COMP VALUE 100.   
               10 WS-PCT-COUNT              PIC 9(04) COMP VALUE 0.     
               10 WS-HOLD-PCT-INDEX         PIC 9(04) COMP VALUE 0.     
               10 WS-PCT-TABLE-RECORD OCCURS 100 TIMES                  
                                      INDEXED BY WS-PCT-INDEX.          
                  20 WS-REG-GROUP-CD-PCT    PIC X(03) VALUE SPACES.     
                  20 WS-ACTION-TYPE-PCT     PIC X(05) VALUE SPACES.     
                  20 WS-ACCT-TYPE-CD-PCT    PIC X(01) VALUE SPACES.     
                  20 WS-CD-COLL-AGY-PCT     PIC X(03) VALUE SPACES.     
                  20 WS-COLL-AGY-SUB-CD-PCT PIC X(03) VALUE SPACES.     
COB305            20 WS-ASSIGN-PERCENT-PCT        PIC S9(3)V9(2) 
COB305               USAGE COMP-3 VALUE 0.
COB305            20 WS-COLL-MAX-AMT-PCT        PIC S9(9)V9(2) 
COB305               USAGE COMP-3 VALUE 0.
COB305            20 WS-COLL-MIN-AMT-PCT        PIC S9(9)V9(2) 
COB305               USAGE COMP-3 VALUE 0.
                                                                        
           05  WS-CA231-EXCEPTION-DATA.                                 
               10 WS-EXCP-MAX               PIC 9(04) COMP VALUE 100.   
               10 WS-EXCP-COUNT             PIC 9(04) COMP VALUE 0.     
               10 WS-EXCP-TABLE-RECORD OCCURS 100 TIMES                 
                                      INDEXED BY WS-EXCP-INDEX.         
                  20 WS-RAND-NUM-CA231-EXCP     PIC 9(07).              
                  20 WS-RECORD-TYPE-EXCP        PIC X(01).              
                  20 WS-REG-GROUP-CD-EXCP       PIC X(03).              
                  20 WS-ACTION-TYPE-CD-EXCP     PIC X(05).              
                  20 WS-ACCOUNT-TYPE-CD-EXCP    PIC X(01).              
                  20 WS-PART1-FIELDS-CA231-EXCP PIC X(60).              
                  20 WS-CODE-COLLEC-AGNCY-EXCP  PIC X(03).              
                  20 WS-COLL-AGY-SUB-CD-EXCP    PIC X(03).              
                  20 WS-PART2-FIELDS-CA231-EXCP PIC X(02).              
COB305            20 WS-WRITE-OFF-BAL-EXCP        PIC S9(9)V9(2) COMP-3 
COB305               VALUE 0.  
                  20 WS-PART3-FIELDS-CA231-EXCP PIC X(223).             
                  20 WS-PART4-FIELDS-CA231-EXCP PIC X(50).              
      *                                                                         
       01  WS-FILE-STATUS.                                              
           05  WS-FCA226-STATUS         PIC X(02).                      
               88  FCA226-SUCCESSFUL                VALUE '00'.         
           05  WS-FCA231-STATUS         PIC X(02).                      
               88  FCA231-SUCCESSFUL                VALUE '00'.         
           05  WS-FCM232-STATUS         PIC X(02).                      
               88  FCM232-SUCCESSFUL                VALUE '00'.         
      *                                                                         
       01  RS-RETURN-CODE-VARIABLES.                                    
           05  WS-RETURN-CODE-03        PIC S9(04) COMP VALUE 0.        
           05  RS-RETURN-CODE           PIC S9(04) COMP VALUE 0.        
           05  RS-RETURN-CODE-DISP      PIC +Z(04).                     
      *                                                                         
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME             PIC X(08)  VALUE 'PCSCA232'.    
           05  WS-SYSTEM                PIC X(06)  VALUE 'SYSTEM'.      
           05  WS-CUSTOMER-TYPE         PIC X(01)  VALUE 'C'.           
           05  WS-Y                     PIC X(01)  VALUE 'Y'.           
           05  WS-N                     PIC X(01)  VALUE 'N'.           
           05  WS-L                     PIC X(01)  VALUE 'L'.           
           05  WS-DISPLAY-RC            PIC ---9.                       
           05  WS-DELINQ-CD             PIC X(20).                      
      *                                                                         
       01  WS-PROGRAM-FLAGS.                                            
           05 WS-COMPANY-FLAG           PIC X(04)  VALUE SPACES.        
               88  SCEG                            VALUE 'SCEG'.        
               88  SEB                             VALUE 'SEB'.         
               88  PSNC                            VALUE 'PSNC'.        
           05 WS-COMPANY-NUM            PIC X(02)  VALUE SPACES.        
           05 WS-MORE-DATA-SW           PIC X(01)   VALUE 'Y'.          
               88  END-OF-FILE                      VALUE 'N'.          
           05 WS-RECORD-GROUP-SW        PIC X(01)   VALUE 'Y'.          
               88  END-OF-REC-GROUP                 VALUE 'N'.          
           05 WS-KEY-FOUND-SW           PIC X(01)   VALUE 'Y'.          
               88  KEY-FOUND                        VALUE 'Y'.          
               88  KEY-NOT-FOUND                    VALUE 'N'.          
      *                                                                         
      *************************************************************             
      * CWS09900 WORK AREA COPY BOOK                              *             
      *************************************************************             
       COPY CWS09900.                                                   PCS01900
      *************************************************************             
      * CWS00303 WORK AREA COPY BOOK                              *             
      *************************************************************             
       COPY CWS00303.                                                   PCS01900
      *************************************************************             
      * CWS00010 WORK AREA COPY BOOK                              *             
      *************************************************************             
       COPY CWS00010.                                                           
      *                                                                 PCS11040
           EXEC SQL                                                             
             INCLUDE SQLCA                                              PCS01900
           END-EXEC.                                                            
      *                                                                 PCS11040
      ************< CSS_COLL_AGY_ASSGN - KU > ********************      PCS11040
           EXEC SQL                                                             
             INCLUDE TBCAASSN                                                   
           END-EXEC.                                                            
      *                                                                 PCS11040
      ************< CSS_COLL_AGY_SUB   - L2 > ********************      PCS11040
           EXEC SQL                                                             
             INCLUDE TBCASUB                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
             DECLARE COLL_AGY_PCT_CUR CURSOR FOR                        
             SELECT                                                     
                  KU.REG_GROUP_CD                                       
                 ,KU.COLL_ACCT_TYPE_CD                                  
                 ,KU.FW_ACTION_TYPE_CD                                  
                 ,KU.CODE_COLLEC_AGNCY                                  
                 ,KU.COLL_AGENCY_SUB_CD                                 
                 ,KU.COLL_ASSIGN_PCT                                    
                 ,L2.WO_MIN_COLLECT_AM                                  
                 ,L2.WO_MAX_COLLECT_AM                                  
             FROM                                                       
                  CSS_COLL_AGY_ASSGN KU                                 
                 ,CSS_COLL_AGY_SUB   L2                                 
             WHERE                                                      
                 KU.COMPANY_NO         = :KU-COMPANY-NO                 
             AND KU.EFFECTIVE_DATE    <= IIF(TRY_CONVERT(DATE, 
                                                     :KU-EFFECTIVE-DATE
              ) IS NULL OR (PATINDEX('%.%', :KU-EFFECTIVE-DATE
              ) <> 0) OR (LEN(:KU-EFFECTIVE-DATE
              ) <> 10), CIS.CHAR2DATE(:KU-EFFECTIVE-DATE
              ), CONVERT(DATE, :KU-EFFECTIVE-DATE) )             
             AND KU.EXPIRATION_DT     >= IIF(TRY_CONVERT(DATE, 
                                                      :KU-EXPIRATION-DT
              ) IS NULL OR (PATINDEX('%.%', :KU-EXPIRATION-DT
              ) <> 0) OR (LEN(:KU-EXPIRATION-DT) <> 10), CIS.CHAR2DATE(
                                                      :KU-EXPIRATION-DT
              ), CONVERT(DATE, :KU-EXPIRATION-DT) )              
             AND KU.COLL_ASSIGN_PCT    > 0                              
             AND L2.COMPANY_NO         = KU.COMPANY_NO                  
             AND L2.REG_GROUP_CD       = KU.REG_GROUP_CD                
             AND L2.CODE_COLLEC_AGNCY  = KU.CODE_COLLEC_AGNCY           
             AND L2.COLL_AGENCY_SUB_CD = KU.COLL_AGENCY_SUB_CD          
             ORDER BY                                                   
                 KU.REG_GROUP_CD                                        
                ,KU.FW_ACTION_TYPE_CD                                   
                ,KU.COLL_ACCT_TYPE_CD                                   
                ,KU.COLL_ASSIGN_PCT DESC                                
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE COLL_AGY_PCT_CUR CURSOR FOR                                
MFA-TR*      SELECT                                                             
MFA-TR*           KU.REG_GROUP_CD                                               
MFA-TR*          ,KU.COLL_ACCT_TYPE_CD                                          
MFA-TR*          ,KU.FW_ACTION_TYPE_CD                                          
MFA-TR*          ,KU.CODE_COLLEC_AGNCY                                          
MFA-TR*          ,KU.COLL_AGENCY_SUB_CD                                         
MFA-TR*          ,KU.COLL_ASSIGN_PCT                                            
MFA-TR*          ,L2.WO_MIN_COLLECT_AM                                          
MFA-TR*          ,L2.WO_MAX_COLLECT_AM                                          
MFA-TR*      FROM                                                               
MFA-TR*           CSS_COLL_AGY_ASSGN KU                                         
MFA-TR*          ,CSS_COLL_AGY_SUB   L2                                         
MFA-TR*      WHERE                                                              
MFA-TR*          KU.COMPANY_NO         = :KU-COMPANY-NO                         
MFA-TR*      AND KU.EFFECTIVE_DATE    <= :KU-EFFECTIVE-DATE                     
MFA-TR*      AND KU.EXPIRATION_DT     >= :KU-EXPIRATION-DT                      
MFA-TR*      AND KU.COLL_ASSIGN_PCT    > 0                                      
MFA-TR*      AND L2.COMPANY_NO         = KU.COMPANY_NO                          
MFA-TR*      AND L2.REG_GROUP_CD       = KU.REG_GROUP_CD                        
MFA-TR*      AND L2.CODE_COLLEC_AGNCY  = KU.CODE_COLLEC_AGNCY                   
MFA-TR*      AND L2.COLL_AGENCY_SUB_CD = KU.COLL_AGENCY_SUB_CD                  
MFA-TR*      ORDER BY                                                           
MFA-TR*          KU.REG_GROUP_CD                                                
MFA-TR*         ,KU.FW_ACTION_TYPE_CD                                           
MFA-TR*         ,KU.COLL_ACCT_TYPE_CD                                           
MFA-TR*         ,KU.COLL_ASSIGN_PCT DESC                                        
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                 PCS11150
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************PCS11170
      *                                                                *PCS11180
      *     0000-MAINLINE                                              *PCS11190
      *                                                                *PCS11200
      *     CONTROLS THE MAIN PROCESSING PATH OF THE PROGRAM           *PCS11210
      *                                                                *PCS11220
      ******************************************************************PCS11230
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
      *                                                                 PCS11320
           PERFORM 1000-PROCESS-COLL-AGNCY-ASSGN THRU 1000-EXIT.        
      *                                                                         
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
                                                                        
           IF WS-RETURN-CODE-03 > 0                                     
              MOVE WS-RETURN-CODE-03             TO RETURN-CODE         
           END-IF.                                                      
                                                                        
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS11880
      *                                                                *PCS11890
      *     0100-INITIALIZATION                                        *PCS11900
      *                                                                *PCS11910
      *     COMMON INITIALIZATION ROUTINE                              *PCS11920
      *                                                                *PCS11940
      ******************************************************************PCS11950
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           OPEN INPUT FCSCA231-FILE.                                    
           IF FCA231-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '**  PCSCA232 PROCESSING ERROR             **'   
               DISPLAY '**    OPEN ERROR OF FCSCA231 - OUTPUT FILE'     
               DISPLAY '**    FILE STATUS = ' WS-FCA231-STATUS          
               DISPLAY '**  PROCESSING TERMINATED                 **'   
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
           OPEN OUTPUT FCSCA226-FILE.                                   
           IF FCA226-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '**  PCSCA232 PROCESSING ERROR             **'   
               DISPLAY '**    OPEN ERROR OF FCSCA232 - OUTPUT FILE'     
               DISPLAY '**    FILE STATUS = ' WS-FCA226-STATUS          
               DISPLAY '**  PROCESSING TERMINATED                 **'   
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
           OPEN OUTPUT FCSCM232-FILE.                                   
           IF FCM232-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '**  PCSCA232 PROCESSING ERROR             **'   
               DISPLAY '**    OPEN ERROR OF FCSCM232 - OUTPUT FILE'     
               DISPLAY '**    FILE STATUS = ' WS-FCM232-STATUS          
               DISPLAY '**  PROCESSING TERMINATED                 **'   
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
           PERFORM 8500-READ-FCA231-RECORD      THRU 8500-EXIT.         
                                                                        
           IF E-FCA231-HEADER-REC-TYPE NOT = LOW-VALUES                 
               DISPLAY '************* PCSCA232 *******************'     
               DISPLAY '* INPUT FILE FCSCA231 HAS NO HEADER REC  *'     
               DISPLAY '************* PCSCA232 *******************'     
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
           MOVE LOW-VALUES                  TO E-FCA226-HEADER-REC-TYPE.
                                                                        
           MOVE E-FCA231-HEADER-CO-NO       TO E-FCA226-HEADER-CO-NO    
                                               KU-COMPANY-NO            
                                               WS-COMPANY-NUM.          
                                                                        
           MOVE E-FCA231-HEADER-CO-NAME     TO E-FCA226-HEADER-CO-NAME. 
           EVALUATE E-FCA231-HEADER-CO-NAME                             
           WHEN 'SCEG'                                                  
              SET SCEG TO TRUE                                          
           WHEN 'SEB '                                                  
              SET SEB  TO TRUE                                          
           WHEN 'PSNC'                                                  
              SET PSNC TO TRUE                                          
           WHEN OTHER                                                   
              DISPLAY '************* PCSCA232 *******************'      
              DISPLAY '* NOT A VALID CO NAME IN INPUT HDR REC.  *'      
              DISPLAY '* HDR CO NAME= ' E-FCA231-HEADER-CO-NAME         
              DISPLAY '* VALID VALUES ARE ''SCEG'', ''PSNC''    *'      
              DISPLAY '* ''SEB ''                               *'      
              DISPLAY '************* PCSCA232 *******************'      
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-EVALUATE.                                                
                                                                        
           MOVE E-FCA231-DATE-CREATED       TO E-FCA226-DATE-CREATED    
                                               WS-PROGRAM-DATE          
                                               KU-EFFECTIVE-DATE        
                                               KU-EXPIRATION-DT.        
                                                                        
           PERFORM 8550-WRITE-FCA226-RECORD THRU 8550-EXIT.             
                                                                        
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS13800
      *                                                                *PCS13810
      * 1000-PROCESS-COLL-AGNCY-ASSGN                                  *PCS13820
      *                                                                *        
      * 1. LOOP THRU PCT TABLE                                         *        
      * 2. PERFORM 2050-PROCESS-HEADER                                 *        
      * 3. PERFORM 2000-PROCESS-DETAILS                                *        
      * 4. IF RECORD IS A HEADER OR REACHED EOF, CHECK IS THERE        *        
      *    ANY EXCEPTION ACCOUNTS IN THE TABLE                         *        
      *       IF SO COMPARE THE KEYS WITH THE PCT TABLE KEY IF MATCHES *        
      *       USE THE CURRENT COLL AGENCY OR ELSE USE THE PREVIOUS     *        
      *       COLL AGENCY AND SET THE INDEX BACK TO CURRENT POSTION    *        
      *                                                                *        
      ******************************************************************PCS13950
      *                                                                         
       1000-PROCESS-COLL-AGNCY-ASSGN.                                   
      *                                                                         
           PERFORM 2100-LOAD-COLL-AGNY-PCT  THRU 2100-EXIT.             
                                                                        
           PERFORM 8500-READ-FCA231-RECORD  THRU 8500-EXIT.             
                                                                        
           IF WS-RECORD-TYPE = 'H'                                      
                                                                        
              PERFORM 2050-PROCESS-HEADER     THRU 2050-EXIT            
                                                                        
              SET WS-PCT-INDEX                TO +1                     
                                                                        
              PERFORM UNTIL WS-PCT-INDEX > WS-PCT-COUNT OR END-OF-FILE  
                                                                        
                 PERFORM 2000-PROCESS-DETAILS THRU 2000-EXIT            
                                                                        
                 SET WS-PCT-INDEX             UP BY +1                  
                                                                        
                 IF WS-RECORD-TYPE = 'H' OR END-OF-FILE                 
                    PERFORM 2050-PROCESS-HEADER                         
                                              THRU 2050-EXIT            
                 END-IF                                                 
                                                                        
              END-PERFORM                                               
                                                                        
           ELSE                                                         
              IF END-OF-FILE                                            
                 CONTINUE                                               
              ELSE                                                      
                 DISPLAY '****************************************'     
                 DISPLAY '**  PCSCA232 PROCESSING ERROR         **'     
                 DISPLAY '**  SUMMARY RECORD MISSING            **'     
                 DISPLAY '****************************************'     
                 PERFORM 9900-ABEND            THRU 9900-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-RETURN-CODE-03 > 0                                     
              MOVE  '*****************PCSCA232******************'       
                                            TO E-FCM232-DATA-REC        
              WRITE FIOCM232                                            
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS40420
      *                                                                *PCS40430
      * 2000-PROCESS-DETAILS                                           *PCS40440
      *                                                                *PCS40450
      * 1. IF KEY MATCHES,COMPUTE THE AGENCY AMOUNT AND LOOP THRU THE  *PCS40450
      *    ACCOUNT UNTIL THE CONDITION SATISFIES.                      *PCS40450
      *    A. ASSIGN THE COLL AGENCY IF BALANCE IS WITHIN THE LIMIT    *PCS40450
      *    B. ELSE MOVE THE RECORD INTO EXCEPTION TABLE                *PCS40450
      * 2. IF KEY DOES NOT MATCH CHECK THE PREVIOUS GROUP HAS ANY      *PCS40450
      *    EXCEPTION ACCOUNT. IF SO ASSIGN PREVIOUS COLL AGENCY        *PCS40450
      *                                                                *PCS40450
      ******************************************************************PCS40480
      *                                                                         
       2000-PROCESS-DETAILS.                                            
      *                                                                         
           IF WS-REG-GROUP-CD    = WS-REG-GROUP-CD-PCT(WS-PCT-INDEX) AND
              WS-ACTION-TYPE-CD  = WS-ACTION-TYPE-PCT(WS-PCT-INDEX) AND 
              WS-ACCOUNT-TYPE-CD = WS-ACCT-TYPE-CD-PCT(WS-PCT-INDEX)    
                                                                        
              COMPUTE WS-AGENCY-AMT =                                   
                WS-ASSIGN-PERCENT-PCT(WS-PCT-INDEX) / 100 * WS-HDR-AMT  
                                                                        
              PERFORM UNTIL WS-AGENCY-AMT <= 0                          
                         OR WS-GROUP-COUNT = WS-HDR-COUNT               
                         OR END-OF-FILE                                 
                         OR WS-RECORD-TYPE = 'H'                        
                                                                        
                 IF WS-WRITE-OFF-BAL >=                                 
                             WS-COLL-MIN-AMT-PCT(WS-PCT-INDEX) AND      
                    WS-WRITE-OFF-BAL <=                                 
                             WS-COLL-MAX-AMT-PCT(WS-PCT-INDEX)          
                                                                        
                    MOVE WS-CD-COLL-AGY-PCT(WS-PCT-INDEX)               
                                            TO WS-CODE-COLLEC-AGNCY     
                    MOVE WS-COLL-AGY-SUB-CD-PCT(WS-PCT-INDEX)           
                                            TO WS-COLL-AGY-SUB-CD       
                                                                        
                    PERFORM 2200-FORMAT-WRITE-CA226                     
                                            THRU 2200-EXIT              
                                                                        
                    SUBTRACT WS-WRITE-OFF-BAL FROM WS-AGENCY-AMT        
                                                                        
                    ADD +1                  TO WS-GROUP-COUNT           
                    ADD WS-WRITE-OFF-BAL    TO WS-GROUP-AMT             
                 ELSE                                                   
                    PERFORM 2250-LOAD-EXCEP-ACCOUNTS                    
                                            THRU 2250-EXIT              
                 END-IF                                                 
                                                                        
                 PERFORM 8500-READ-FCA231-RECORD                        
                                            THRU 8500-EXIT              
              END-PERFORM                                               
           ELSE                                                         
              IF WS-GROUP-COUNT < WS-HDR-COUNT AND                      
                 WS-GROUP-COUNT > 0                                     
                                                                        
                 SET WS-PCT-INDEX           DOWN BY +1                  
                                                                        
                 PERFORM UNTIL END-OF-FILE                              
                            OR WS-RECORD-TYPE = 'H'                     
                            OR WS-GROUP-COUNT = WS-HDR-COUNT            
                                                                        
                    MOVE WS-CD-COLL-AGY-PCT(WS-PCT-INDEX)               
                                            TO WS-CODE-COLLEC-AGNCY     
                    MOVE WS-COLL-AGY-SUB-CD-PCT(WS-PCT-INDEX)           
                                            TO WS-COLL-AGY-SUB-CD       
                    PERFORM 2200-FORMAT-WRITE-CA226                     
                                            THRU 2200-EXIT              
                    PERFORM 8500-READ-FCA231-RECORD                     
                                            THRU 8500-EXIT              
                    ADD +1                  TO WS-GROUP-COUNT           
                    ADD WS-WRITE-OFF-BAL    TO WS-GROUP-AMT             
                 END-PERFORM                                            
              END-IF                                                    
           END-IF.                                                      
                                                                        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS13800
      *                                                                *PCS13810
      * 2050-PROCESS-HEADER                                            *PCS13820
      * 1. CHECK IF THERE IS ANY EXCEPTION ACCOUNT                     *        
      *    A. IF EXIST AND IF THE KEY MATCHES ASSIGN THE CURRENT COLL  *        
      *       AGENCY ELSE ASSIGN THE PREVIOUS COLL AGENCY              *        
      * 2. IF NOT EOF, LOOP THRU 2350 UNTIL THE KEY MATCHES,           *        
      *    UNMATCHED ACCOUNTS ARE MOVED TO FCSCM232 WHICH IS MAILED TO *        
      * 3. IF IT IS A HEADER RECORD INITIALIZE ALL THE COUNTERS, INDEX *        
      *    AND AMOUNT                                                  *        
      *                                                                *        
      ******************************************************************PCS13950
      *                                                                         
       2050-PROCESS-HEADER.                                             
      *                                                                         
           IF WS-EXCP-COUNT > 0                                         
              IF WS-REG-GROUP-CD-PCT(WS-PCT-INDEX) =                    
                               WS-REG-GROUP-CD-EXCP(WS-EXCP-INDEX) AND  
                 WS-ACTION-TYPE-PCT(WS-PCT-INDEX) =                     
                               WS-ACTION-TYPE-CD-EXCP(WS-EXCP-INDEX) AND
                 WS-ACCT-TYPE-CD-PCT(WS-PCT-INDEX) =                    
                               WS-ACCOUNT-TYPE-CD-EXCP(WS-EXCP-INDEX)   
                                                                        
                MOVE WS-CD-COLL-AGY-PCT(WS-PCT-INDEX)                   
                                           TO WS-EXCP-CODE-COLLEC-AGNCY 
                MOVE WS-COLL-AGY-SUB-CD-PCT(WS-PCT-INDEX)               
                                           TO WS-EXCP-COLL-AGY-SUB-CD   
              ELSE                                                      
                                                                        
                SET WS-PCT-INDEX           DOWN BY 1                    
                MOVE WS-CD-COLL-AGY-PCT(WS-PCT-INDEX)                   
                                           TO WS-EXCP-CODE-COLLEC-AGNCY 
                MOVE WS-COLL-AGY-SUB-CD-PCT(WS-PCT-INDEX)               
                                           TO WS-EXCP-COLL-AGY-SUB-CD   
                SET WS-PCT-INDEX           UP BY 1                      
              END-IF                                                    
                                                                        
              PERFORM 2300-WRITE-EXCEP-ACCOUNTS                         
                                           THRU 2300-EXIT               
           END-IF                                                       
                                                                        
           IF NOT END-OF-FILE                                           
              SET WS-HOLD-PCT-INDEX        TO WS-PCT-INDEX              
                                                                        
              SET KEY-NOT-FOUND            TO TRUE                      
                                                                        
              PERFORM 2350-CHECK-KEY-EXIST THRU 2350-EXIT               
              UNTIL KEY-FOUND OR END-OF-FILE                            
                                                                        
              SET WS-PCT-INDEX             TO WS-HOLD-PCT-INDEX         
                                                                        
           END-IF                                                       
                                                                        
           IF WS-RECORD-TYPE = 'H'                                      
                                                                        
              MOVE E-FCA231-TOTAL-ACCT-TYPE  TO WS-HDR-COUNT            
                                                                        
              MOVE E-FCA231-TOTAL-WO-BALANCE TO WS-HDR-AMT              
                                                                        
              MOVE WS-ACTION-TYPE-CD         TO WS-HDR-ACTION-TYPE      
              MOVE WS-ACCOUNT-TYPE-CD        TO WS-HDR-ACCOUNT-TYPE     
              MOVE WS-REG-GROUP-CD           TO WS-HDR-REG-GROUP        
              MOVE ZERO                      TO WS-GROUP-COUNT          
                                                WS-GROUP-AMT            
                                                WS-EXCP-COUNT           
              SET WS-EXCP-INDEX              TO WS-EXCP-COUNT           
                                                                        
              PERFORM 8500-READ-FCA231-RECORD                           
                                             THRU 8500-EXIT             
           END-IF.                                                      
      *                                                                         
       2050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS13800
      *                                                                *PCS13810
      * 2100-LOAD-COLL-AGNY-PCT                                        *PCS13820
      * 1. OPEN COLL-AGY-PCT-CUR                                       *        
      * 2. FETCH AND MOVE TO PCT TABLE                                 *        
      *                                                                *        
      ******************************************************************PCS13950
      *                                                                         
       2100-LOAD-COLL-AGNY-PCT.                                         
      *                                                                         
           PERFORM 7100-OPEN-COLL-AGY-PCT-CUR                           
                                            THRU 7100-EXIT.             
           PERFORM 7110-FETCH-COLL-AGY-PCT-CUR                          
                                            THRU 7110-EXIT.             
                                                                        
           MOVE +0                          TO WS-PCT-COUNT.            
           SET WS-PCT-INDEX                 TO WS-PCT-COUNT.            
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              ADD +1                        TO WS-PCT-COUNT             
                                                                        
              IF WS-PCT-COUNT > WS-PCT-MAX                              
                 DISPLAY '****************************************'     
                 DISPLAY '**  PCSCA232 PROCESSING ERROR         **'     
                 DISPLAY '**  REACHED MAX - WS-PCT-TABLE-RECORD **'     
                 DISPLAY '****************************************'     
                 PERFORM 9900-ABEND         THRU 9900-EXIT              
              END-IF                                                    
                                                                        
              SET WS-PCT-INDEX              TO WS-PCT-COUNT             
                                                                        
              MOVE KU-REG-GROUP-CD          TO                          
                                  WS-REG-GROUP-CD-PCT(WS-PCT-INDEX)     
              MOVE KU-FW-ACTION-TYPE-CD     TO                          
                                  WS-ACTION-TYPE-PCT(WS-PCT-INDEX)      
              MOVE KU-COLL-ACCT-TYPE-CD     TO                          
                                  WS-ACCT-TYPE-CD-PCT(WS-PCT-INDEX)     
              MOVE KU-CODE-COLLEC-AGNCY     TO                          
                                  WS-CD-COLL-AGY-PCT(WS-PCT-INDEX)      
              MOVE KU-COLL-AGENCY-SUB-CD    TO                          
                                   WS-COLL-AGY-SUB-CD-PCT(WS-PCT-INDEX) 
              MOVE KU-COLL-ASSIGN-PCT       TO                          
                                  WS-ASSIGN-PERCENT-PCT(WS-PCT-INDEX)   
              MOVE L2-WO-MIN-COLLECT-AM     TO                          
                                  WS-COLL-MIN-AMT-PCT(WS-PCT-INDEX)     
              MOVE L2-WO-MAX-COLLECT-AM     TO                          
                                  WS-COLL-MAX-AMT-PCT(WS-PCT-INDEX)     
                                                                        
              PERFORM 7110-FETCH-COLL-AGY-PCT-CUR                       
                                            THRU 7110-EXIT              
           END-PERFORM.                                                 
                                                                        
           PERFORM 7120-CLOSE-COLL-AGY-PCT-CUR                          
                                            THRU 7120-EXIT.             
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS13800
      *                                                                *PCS13810
      * 2200-FORMAT-WRITE-CA226                                        *PCS13820
      * MOVE TO CA226 FIELD AND WRITE INTO FCA226 FILE                 *        
      *                                                                *        
      ******************************************************************PCS13950
      *                                                                         
       2200-FORMAT-WRITE-CA226.                                         
      *                                                                         
           MOVE WS-REG-GROUP-CD          TO WS-REG-GROUP-CD-CA226.      
           MOVE WS-ACTION-TYPE-CD        TO WS-ACTION-TYPE-CD-CA226.    
           MOVE WS-ACCOUNT-TYPE-CD       TO WS-ACCOUNT-TYPE-CD-CA226.   
           MOVE WS-PART1-FIELDS-CA231    TO WS-PART1-FIELDS-CA226.      
           MOVE WS-CODE-COLLEC-AGNCY     TO WS-CODE-COLLEC-AGNCY-CA226. 
           MOVE WS-COLL-AGY-SUB-CD       TO WS-COLL-AGY-SUB-CD-CA226.   
           MOVE WS-PART2-FIELDS-CA231    TO WS-PART2-FIELDS-CA226.      
           MOVE WS-WRITE-OFF-BAL         TO WS-WRITE-OFF-BAL-CA226.     
           MOVE WS-PART3-FIELDS-CA231    TO WS-PART3-FIELDS-CA226.      
           MOVE WS-PART4-FIELDS-CA231    TO WS-PART4-FIELDS-CA226.      
                                                                        
           MOVE WS-FIOCA226-REC          TO FIOCA226.                   
                                                                        
           PERFORM 8550-WRITE-FCA226-RECORD THRU 8550-EXIT.             
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS13800
      *                                                                *PCS13810
      * 2250-LOAD-EXCEP-ACCOUNTS                                       *PCS13820
      *                                                                *        
      ******************************************************************PCS13950
      *                                                                         
       2250-LOAD-EXCEP-ACCOUNTS.                                        
      *                                                                         
           ADD +1                        TO WS-EXCP-COUNT.              
                                                                        
           IF WS-EXCP-COUNT > WS-EXCP-MAX                               
              DISPLAY '****************************************'        
              DISPLAY '**  PCSCA232 PROCESSING ERROR         **'        
              DISPLAY '**  REACHED MAX - WS-EXCP-TABLE-RECORD *'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
                                                                        
           SET WS-EXCP-INDEX             TO WS-EXCP-COUNT.              
           MOVE WS-FIOCA231-REC          TO                             
                                    WS-EXCP-TABLE-RECORD(WS-EXCP-INDEX).
      *                                                                         
       2250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS13800
      *                                                                *PCS13810
      * 2300-WRITE-EXCEP-ACCOUNTS                                      *PCS13820
      *                                                                *        
      ******************************************************************PCS13950
      *                                                                         
       2300-WRITE-EXCEP-ACCOUNTS.                                       
      *                                                                         
           PERFORM UNTIL WS-EXCP-COUNT <= 0                             
                                                                        
             MOVE WS-REG-GROUP-CD-EXCP(WS-EXCP-INDEX)                   
                                         TO WS-REG-GROUP-CD-CA226       
             MOVE WS-ACTION-TYPE-CD-EXCP(WS-EXCP-INDEX)                 
                                         TO WS-ACTION-TYPE-CD-CA226     
             MOVE WS-ACCOUNT-TYPE-CD-EXCP(WS-EXCP-INDEX)                
                                         TO WS-ACCOUNT-TYPE-CD-CA226    
             MOVE WS-PART1-FIELDS-CA231-EXCP(WS-EXCP-INDEX)             
                                         TO WS-PART1-FIELDS-CA226       
                                                                        
             MOVE WS-EXCP-CODE-COLLEC-AGNCY                             
                                         TO WS-CODE-COLLEC-AGNCY-CA226  
             MOVE WS-EXCP-COLL-AGY-SUB-CD                               
                                         TO WS-COLL-AGY-SUB-CD-CA226    
                                                                        
             MOVE WS-PART2-FIELDS-CA231-EXCP(WS-EXCP-INDEX)             
                                         TO WS-PART2-FIELDS-CA226       
             MOVE WS-WRITE-OFF-BAL-EXCP(WS-EXCP-INDEX)                  
                                         TO WS-WRITE-OFF-BAL-CA226      
             MOVE WS-PART3-FIELDS-CA231-EXCP(WS-EXCP-INDEX)             
                                         TO WS-PART3-FIELDS-CA226       
             MOVE WS-PART4-FIELDS-CA231-EXCP(WS-EXCP-INDEX)             
                                         TO WS-PART4-FIELDS-CA226       
                                                                        
             MOVE WS-FIOCA226-REC        TO FIOCA226                    
                                                                        
             PERFORM 8550-WRITE-FCA226-RECORD                           
                                         THRU 8550-EXIT                 
                                                                        
             ADD +1                      TO WS-GROUP-COUNT              
             ADD WS-WRITE-OFF-BAL-EXCP(WS-EXCP-INDEX)                   
                                         TO WS-GROUP-AMT                
                                                                        
             SUBTRACT +1                 FROM WS-EXCP-COUNT             
             SET WS-EXCP-INDEX           TO WS-EXCP-COUNT               
                                                                        
           END-PERFORM.                                                 
                                                                        
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS13800
      *                                                                *PCS13810
      * 2350-CHECK-KEY-EXIST                                           *PCS13820
      * SEARCH FOR MATCHED KEY IF NOT FOUND WRITE INTO FCM232 FILE     *        
      *                                                                *        
      ******************************************************************PCS13950
      *                                                                         
       2350-CHECK-KEY-EXIST.                                            
      *                                                                         
           SET WS-PCT-INDEX                 TO +1.                      
                                                                        
           SEARCH WS-PCT-TABLE-RECORD VARYING WS-PCT-INDEX              
            AT END                                                      
               SET KEY-NOT-FOUND            TO TRUE                     
            WHEN WS-REG-GROUP-CD-PCT(WS-PCT-INDEX) = WS-REG-GROUP-CD    
             AND WS-ACTION-TYPE-PCT(WS-PCT-INDEX)  = WS-ACTION-TYPE-CD  
             AND WS-ACCT-TYPE-CD-PCT(WS-PCT-INDEX) = WS-ACCOUNT-TYPE-CD 
               SET KEY-FOUND                TO TRUE.                    
                                                                        
           IF KEY-NOT-FOUND                                             
              PERFORM 2400-WRITE-MISSING-KEY THRU 2400-EXIT             
           END-IF.                                                      
                                                                        
      *                                                                         
       2350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************PCS13800
      *                                                                *PCS13810
      * 2400-WRITE-MISSING-KEY                                         *PCS13820
      *                                                                *        
      ******************************************************************PCS13950
      *                                                                         
       2400-WRITE-MISSING-KEY.                                          
      *                                                                         
           IF WS-RETURN-CODE-03 NOT = 03                                
                                                                        
              MOVE 'HELO DOMAIN:     SCANA                         '    
                                                TO E-FCM232-DATA-REC    
              WRITE FIOCM232                                            
                                                                        
              MOVE 'MAIL FROM:   <'             TO E-FCM232-DATA-PARTA  
              EVALUATE TRUE                                             
              WHEN SCEG                                                 
                 MOVE 'CSRC232@SCEGJES2.SCANA.COM> '                    
                                                TO E-FCM232-DATA-PARTB  
              WHEN SEB                                                  
                 MOVE 'SEBC232@SCEGJES2.SCANA.COM> '                    
                                                TO E-FCM232-DATA-PARTB  
              WHEN PSNC                                                 
                 MOVE 'PNCC232@SCEGJES2.SCANA.COM> '                    
                                                TO E-FCM232-DATA-PARTB  
              END-EVALUATE                                              
              MOVE SPACES                       TO E-FCM232-DATA-PARTC  
              WRITE FIOCM232                                            
                                                                        
              MOVE 'RCPT TO:   <CSSOCREDIT@SCANA.COM>              '    
                                                TO E-FCM232-DATA-REC    
              WRITE FIOCM232                                            
                                                                        
A644          MOVE 'RCPT TO:   <ISTCSRCAPSSUPPORT@SCANA.COM>'           
                                                TO E-FCM232-DATA-REC    
              WRITE FIOCM232                                            
                                                                        
              MOVE 'DATA                                           '    
                                                TO E-FCM232-DATA-REC    
              WRITE FIOCM232                                            
                                                                        
              MOVE 'FROM: CIS PAGING <'         TO E-FCM232-DATA-PARTAA 
              EVALUATE TRUE                                             
              WHEN SCEG                                                 
                 MOVE 'CSRC232@SCEGJES2.SCANA.COM> '                    
                                                TO E-FCM232-DATA-PARTBB 
              WHEN SEB                                                  
                 MOVE 'SEBC232@SCEGJES2.SCANA.COM> '                    
                                                TO E-FCM232-DATA-PARTBB 
              WHEN PSNC                                                 
                 MOVE 'PNCC232@SCEGJES2.SCANA.COM> '                    
                                                TO E-FCM232-DATA-PARTBB 
              END-EVALUATE                                              
              MOVE SPACES                       TO E-FCM232-DATA-PARTCC 
              WRITE FIOCM232                                            
                                                                        
              MOVE 'TO:  <CSSOCREDIT@SCANA.COM>                    '    
                                                TO E-FCM232-DATA-REC    
              WRITE FIOCM232                                            
A644          MOVE 'TO:  <ISTCSRCAPSSUPPORT@SCANA.COM>      '           
                                                TO E-FCM232-DATA-REC    
              WRITE FIOCM232                                            
              MOVE 'SUBJECT: WEEKLY JOB '                               
                                                TO E-FCM232-DATA-PARTAAA
              EVALUATE TRUE                                             
              WHEN SCEG                                                 
                 MOVE 'CSRC232 '                TO E-FCM232-DATA-PARTBBB
              WHEN SEB                                                  
                 MOVE 'SEBC232 '                TO E-FCM232-DATA-PARTBBB
              WHEN PSNC                                                 
                 MOVE 'PNCC232 '                TO E-FCM232-DATA-PARTBBB
              END-EVALUATE                                              
                                                                        
              MOVE SPACES                       TO E-FCM232-DATA-PARTCCC
              MOVE ' HAD PROBLEM'               TO E-FCM232-DATA-PARTCCC
              WRITE FIOCM232                                            
                                                                        
              MOVE SPACES                       TO E-FCM232-DATA-REC    
              WRITE FIOCM232                                            
                                                                        
              MOVE  '*****************PCSCA232******************'       
                                                TO E-FCM232-DATA-REC    
              WRITE FIOCM232                                            
                                                                        
              MOVE  '* 2400 : COLLECTION AGENCY NOT FOUND IN   *'       
                                                TO E-FCM232-DATA-REC    
              WRITE FIOCM232                                            
                                                                        
              MOVE  '* CSS_COLL_AGY_ASSGN FOR                  *'       
                                                TO E-FCM232-DATA-REC    
              WRITE FIOCM232                                            
           END-IF.                                                      
                                                                        
           MOVE  '*     REG GROUP CD  : '       TO E-FCM232-DATA-PART1. 
           MOVE SPACES                          TO E-FCM232-DATA-PART2. 
           MOVE WS-REG-GROUP-CD                 TO E-FCM232-DATA-PART2. 
           MOVE SPACES                          TO E-FCM232-DATA-PART3. 
           WRITE FIOCM232.                                              
                                                                        
           MOVE  '*     ACTION TYPE   : '       TO E-FCM232-DATA-PART1. 
           MOVE SPACES                          TO E-FCM232-DATA-PART2. 
           MOVE WS-ACTION-TYPE-CD               TO E-FCM232-DATA-PART2. 
           MOVE SPACES                          TO E-FCM232-DATA-PART3. 
           WRITE FIOCM232.                                              
                                                                        
           MOVE  '*     ACCOUNT TYPE  : '       TO E-FCM232-DATA-PART1. 
           MOVE SPACES                          TO E-FCM232-DATA-PART2. 
           MOVE WS-ACCOUNT-TYPE-CD              TO E-FCM232-DATA-PART2. 
           MOVE SPACES                          TO E-FCM232-DATA-PART3. 
           WRITE FIOCM232.                                              
                                                                        
           MOVE  '*     ACCOUNT NO(S) : '       TO E-FCM232-DATA-PART1. 
                                                                        
           PERFORM 8500-READ-FCA231-RECORD      THRU 8500-EXIT.         
                                                                        
           PERFORM UNTIL END-OF-FILE                                    
                      OR WS-RECORD-TYPE = 'H'                           
                                                                        
              MOVE SPACE                        TO E-FCM232-DATA-PART2  
              MOVE WS-ACCOUNT-NO-CA231          TO E-FCM232-DATA-PART2  
              MOVE SPACES                       TO E-FCM232-DATA-PART3  
              WRITE FIOCM232                                            
              MOVE  '*                     '    TO E-FCM232-DATA-PART1  
                                                                        
              PERFORM 8500-READ-FCA231-RECORD   THRU 8500-EXIT          
                                                                        
           END-PERFORM.                                                 
                                                                        
           MOVE 03                              TO RETURN-CODE          
                                                   WS-RETURN-CODE-03.   
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS40420
      *                                                                *PCS40430
      * 7100-OPEN-COLL-AGY-PCT-CUR.                                    *PCS40440
      *                                                                *PCS40450
      ******************************************************************PCS40480
      *                                                                         
       7100-OPEN-COLL-AGY-PCT-CUR.                                      
      *                                                                         
           EXEC SQL                                                     
                OPEN COLL_AGY_PCT_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF  SQLCODE EQUAL SUCCESSFUL-CALL                            
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE                 TO WS-DISPLAY-RC            
               DISPLAY '*****************PCSCA232******************'    
               DISPLAY '* 7100 : OPEN ERROR COLL_AGY_PCT_CUR       '    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABEND                           *'    
               DISPLAY '*****************PCSCA232******************'    
               PERFORM 9900-ABEND           THRU  9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS40420
      *                                                                *PCS40430
      *     7110-FETCH-COLL-AGY-PCT-CUR                                *PCS40440
      *                                                                *PCS40450
      *                                                                *PCS40470
      ******************************************************************PCS40480
      *                                                                         
       7110-FETCH-COLL-AGY-PCT-CUR.                                     
      *                                                                         
           EXEC SQL                                                     
              FETCH                                                     
                  COLL_AGY_PCT_CUR                                      
              INTO                                                      
                  :KU-REG-GROUP-CD                                      
                 ,:KU-COLL-ACCT-TYPE-CD                                 
                 ,:KU-FW-ACTION-TYPE-CD                                 
                 ,:KU-CODE-COLLEC-AGNCY                                 
                 ,:KU-COLL-AGENCY-SUB-CD                                
                 ,:KU-COLL-ASSIGN-PCT                                   
                 ,:L2-WO-MIN-COLLECT-AM                                 
                 ,:L2-WO-MAX-COLLECT-AM                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
              MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE    
           ELSE                                                         
               MOVE SQLCODE                 TO WS-DISPLAY-RC            
               DISPLAY '*****************PCSCA232******************'    
               DISPLAY '* 7110 : FETCH COLL_AGY_PCT_CUR  ERROR    *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA232******************'    
               PERFORM 9900-ABEND           THRU  9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS41920
      *                                                                *PCS41930
      * 7120-CLOSE-COLL-AGY-PCT-CUR                                    *PCS41940
      *                                                                *PCS41950
      ******************************************************************PCS41960
      *                                                                         
       7120-CLOSE-COLL-AGY-PCT-CUR.                                     
      *                                                                         
           EXEC SQL                                                     
                CLOSE COLL_AGY_PCT_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF  SQLCODE EQUAL SUCCESSFUL-CALL                            
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE                 TO WS-DISPLAY-RC            
               DISPLAY '*****************PCSCA232******************'    
               DISPLAY '* 7120 : CLOSE COLL_AGY_PCT_CUR  ERROR    *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA232******************'    
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8500-READ-FCA231-RECORD.                                       *        
      ******************************************************************        
      *                                                                         
       8500-READ-FCA231-RECORD.                                         
      *                                                                         
           INITIALIZE WS-FIOCA231-REC.                                  
                                                                        
           READ FCSCA231-FILE                                           
                AT END                                                  
                   SET END-OF-FILE          TO TRUE                     
                   GO TO 8500-EXIT.                                     
                                                                        
           IF FCA231-SUCCESSFUL                                         
              MOVE FIOCA231                 TO WS-FIOCA231-REC          
           ELSE                                                         
               DISPLAY '**  PCSCA232 PROCESSING ERROR    **'            
               DISPLAY '**  ERROR ON FCSCA231 READ       **'            
               DISPLAY '**  STATUS IS ' WS-FCA231-STATUS                
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************PCS40420
      *                                                                *PCS40430
      *      8550-WRITE-FCA226-RECORD.                                 *PCS40440
      ******************************************************************PCS40480
      *                                                                         
       8550-WRITE-FCA226-RECORD.                                        
      *                                                                         
           WRITE FIOCA226.                                              
      *                                                                         
       8550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS44780
      *                                                                *PCS44790
      *     9000-TERMINATE                                             *PCS44800
      *                                                                *PCS44810
      *     CLOSE FILES                                                *PCS44820
      *                                                                *PCS44830
      ******************************************************************PCS44840
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSCA231-FILE.                                         
           IF FCA231-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  PCSCA232 PROCESSING ERROR              **'  
               DISPLAY '**    CLOSE ERROR OF FCSCA231 - INPUT FILE'     
               DISPLAY '**    FILE STATUS = ' WS-FCA231-STATUS          
           END-IF.                                                      
                                                                        
           CLOSE FCSCA226-FILE.                                         
           IF FCA226-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  PCSCA232 PROCESSING ERROR              **'  
               DISPLAY '**    CLOSE ERROR OF FCSCA232 - OUTPUT FILE'    
               DISPLAY '**    FILE STATUS = ' WS-FCA226-STATUS          
           END-IF.                                                      
                                                                        
           CLOSE FCSCM232-FILE.                                         
           IF FCM232-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  PCSCA232 PROCESSING ERROR              **'  
               DISPLAY '**    CLOSE ERROR OF FCSCM232 - OUTPUT FILE'    
               DISPLAY '**    FILE STATUS = ' WS-FCM232-STATUS          
           END-IF.                                                      
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  9700-PROCESS-ABEND.                                           *        
      ******************************************************************        
      *                                                                         
              EXEC SQL                                                  15309306
                   INCLUDE CPD0023B                                     15309307
              END-EXEC.                                                 15309308
      *                                                                         
      ******************************************************************        
      *  9900-ABEND                                                    *        
      ******************************************************************        
      *                                                                         
              EXEC SQL                                                  27290000
                   INCLUDE CPD09900                                     27300000
              END-EXEC.                                                 27310000
