       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA231.                                        
       DATE-WRITTEN.   APRIL 2008.                                      
      *****************************************************************         
      **                                                             ** PCS00150
      **              PROGRAM  MODIFICATION  LOG                     ** PCS00160
      **    DATE      INITIALS      REASON                           ** PCS00170
      **    ____      ________      _______                          ** PCS00180
T30169**    04/03/08   MN90523      INITIAL                          **         
      ***************************************************************** PCS00210
      ***************************************************************** PCS00210
      *                                                                 00240000
      * PROGRAM NARRATIVE                                                       
      *                                                                         
      * PCSCA231 ASSIGNS RANDOM NUMBER BASED ON THE ACTION TYPE AND             
      * ACCOUNT TYPE                                                            
      ******************************************************************        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                 PCS01190
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSCA231.                                                           
       COPY CSSCA227.                                                           
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDCA231.                                                           
       COPY FIOCA231.                                                           
       COPY CFDCA227.                                                           
       COPY FIOCA227.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA231'.
MSQ017     COPY MFASQLM.
       01  WS-WORK-AREA.                                                
           05  WS-PROGRAM-DATE            PIC X(10).                    
           05  WS-COMPANY-NO              PIC X(02).                    
           05  WS-DISPLAY-SQLCODE         PIC -ZZZZZZZZ9.               
           05  WS-TIMESTAMP               PIC X(26) VALUE SPACES.       
           05  WS-TIMESTAMP-CHAR.                                       
               10 FILLER            PIC X(21).                          
               10 WS-SEED-CHAR      PIC X(5).                           
           05  WS-SEED-NUM          PIC 9(5) VALUE 0.                   
           05  WS-RANDOM-NUMBER     PIC V9(7) VALUE 0.                  
           05  WS-RANDOM-NUMBER-F   PIC 9(7) VALUE 0.                   
           05  WS-RAND              PIC S9(9) COMP VALUE 0.             
           05  WS-SEED              PIC S9(9) COMP VALUE 3.             
      *                                                                         
       01  WS-FIOCA231-REC.                                             
           05  WS-RAND-NUM-CA231          PIC 9(07).                    
           05  WS-OTHER-FIELDS-CA231      PIC X(357).                   
      *                                                                         
       01  WS-FILE-STATUS.                                              
           05  WS-FCA231-STATUS          PIC X(02).                     
               88  FCA231-SUCCESSFUL                VALUE '00'.         
           05  WS-FCA227-STATUS          PIC X(02).                     
               88  FCA227-SUCCESSFUL                VALUE '00'.         
      *                                                                         
       01  RS-RETURN-CODE-VARIABLES.                                    
           05  RS-RETURN-CODE           PIC S9(04) COMP VALUE 0.        
           05  RS-RETURN-CODE-DISP      PIC +Z(04).                     
      *                                                                         
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME             PIC X(08)  VALUE 'PCSCA231'.    
           05  WS-SYSTEM                PIC X(06)  VALUE 'SYSTEM'.      
           05  WS-CUSTOMER-TYPE         PIC X(01)  VALUE 'C'.           
           05  WS-Y                     PIC X(01)  VALUE 'Y'.           
           05  WS-N                     PIC X(01)  VALUE 'N'.           
           05  WS-L                     PIC X(01)  VALUE 'L'.           
           05  WS-DISPLAY-RC            PIC ---9.                       
           05  WS-DELINQ-CD             PIC X(20).                      
           05  WS-LAST-R-DATE-LITERAL   PIC X(14)  VALUE                
                  'LAST RUN DATE='.                                     
      *                                                                         
       01  WS-PROGRAM-FLAGS.                                            
           05  WS-COMPANY-FLAG          PIC X(04)  VALUE SPACES.        
               88  SCEG                            VALUE 'SCEG'.        
               88  SEB                             VALUE 'SEB'.         
               88  PSNC                            VALUE 'PSNC'.        
           05  WS-COMPANY-NUM           PIC X(02)  VALUE SPACES.        
                                                                        
           05 WS-MORE-DATA-SW           PIC X(01)   VALUE 'Y'.          
               88  NO-MORE-DATA                     VALUE 'N'.          
      *                                                                         
      ******************************************************************PCS11170
      * CWS09900 WORK AREA COPYBOOK                                     PCS11180
      ******************************************************************PCS11170
       COPY CWS09900.                                                   PCS01900
      ******************************************************************PCS11170
      * CWS00303 WORK AREA COPYBOOK                                     PCS11180
      ******************************************************************PCS11170
       COPY CWS00303.                                                   PCS01900
      ******************************************************************PCS11170
      * CWS00010 WORK AREA COPYBOOK                                     PCS11180
      ******************************************************************PCS11170
       COPY CWS00010.                                                           
      *                                                                 PCS11040
           EXEC SQL                                                             
             INCLUDE SQLCA                                              PCS01900
           END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************PCS11170
      *                                                                *PCS11180
      *     0000-MAINLINE                                              *PCS11190
      *                                                                *PCS11200
      *     CONTROLS THE MAIN PROCESSING PATH OF THE PROGRAM           *PCS11210
      *                                                                *PCS11220
      ******************************************************************PCS11230
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
      *                                                                 PCS11320
           PERFORM 1000-ASSIGN-RANDOM-NUMBER     THRU 1000-EXIT.        
      *                                                                         
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS11880
      *                                                                *PCS11890
      *     0100-INITIALIZATION                                        *PCS11900
      *                                                                *PCS11910
      *     COMMON INITIALIZATION ROUTINE                              *PCS11920
      *                                                                *PCS11940
      ******************************************************************PCS11950
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           OPEN OUTPUT FCSCA231-FILE.                                   
           IF FCA231-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '**  PCSCA231 PROCESSING ERROR             **'   
               DISPLAY '**    OPEN ERROR OF FCSCA231 - OUTPUT FILE'     
               DISPLAY '**    FILE STATUS = ' WS-FCA231-STATUS          
               DISPLAY '**  PROCESSING TERMINATED                 **'   
               PERFORM 9900-ABEND               THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
           OPEN INPUT  FCSCA227-FILE.                                   
           IF FCA227-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '**  PCSCA231 PROCESSING ERROR             **'   
               DISPLAY '**    OPEN ERROR OF FCSCA227 - INPUT  FILE'     
               DISPLAY '**    FILE STATUS = ' WS-FCA227-STATUS          
               DISPLAY '**  PROCESSING TERMINATED                 **'   
               PERFORM 9900-ABEND               THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
           PERFORM 8550-READ-FCA227-RECORD      THRU 8550-EXIT.         
                                                                        
           IF E-FCA227-HEADER-REC-TYPE NOT = LOW-VALUES                 
               DISPLAY '************* PCSCA231 *******************'     
               DISPLAY '* INPUT FILE FCSCA227 HAS NO HEADER REC  *'     
               DISPLAY '************* PCSCA231 *******************'     
               PERFORM 9900-ABEND               THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
           MOVE E-FCA227-HEADER-REC-TYPE    TO E-FCA231-HEADER-REC-TYPE.
           MOVE E-FCA227-HEADER-CO-NO       TO E-FCA231-HEADER-CO-NO.   
           MOVE E-FCA227-HEADER-CO-NAME     TO E-FCA231-HEADER-CO-NAME. 
           MOVE E-FCA227-DATE-CREATED       TO E-FCA231-DATE-CREATED.   
                                                                        
           PERFORM 8500-WRITE-FCA231-RECORD     THRU 8500-EXIT.         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS13800
      *                                                                *PCS13810
      * 1000-ASSIGN-RANDOM-NUMBER                                      *PCS13820
      *                                                                *PCS13830
      * THIS MODULE OPENS INPUT FILE AND ASSIGNE RANDOM NUMBER         *        
      *                                                                *        
      ******************************************************************PCS13950
      *                                                                         
       1000-ASSIGN-RANDOM-NUMBER.                                       
      *                                                                         
           PERFORM 8550-READ-FCA227-RECORD          THRU 8550-EXIT.     
                                                                        
           PERFORM UNTIL NO-MORE-DATA                                   
                                                                        
            INITIALIZE WS-FIOCA231-REC                                  
                                                                        
            EVALUATE E-FCA227-RECORD-TYPE                               
               WHEN 'H'                                                 
                  PERFORM 3000-INIT-RANDOM-NUMBER THRU 3000-EXIT        
               WHEN 'D'                                                 
                  PERFORM 3100-GET-RANDOM-NUMBER   THRU 3100-EXIT       
                  MOVE WS-RANDOM-NUMBER-F          TO WS-RAND-NUM-CA231 
               WHEN OTHER                                               
                  DISPLAY '**  PCSCA231 PROCESSING ERROR     **'        
                  DISPLAY '**  INVALID INPUT RECORD TYPE     **'        
                  DISPLAY '**  REC TYPE = ' E-FCA227-RECORD-TYPE        
                  DISPLAY '**  PROCESSING TERMINATED         **'        
                  PERFORM 9900-ABEND                THRU 9900-EXIT      
               END-EVALUATE                                             
                                                                        
               PERFORM 4000-LOAD-FIOCA231           THRU 4000-EXIT      
               PERFORM 8500-WRITE-FCA231-RECORD     THRU 8500-EXIT      
               PERFORM 8550-READ-FCA227-RECORD      THRU 8550-EXIT      
                                                                        
           END-PERFORM.                                                 
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************PCS14560
      *                                                                *        
      * 3000-INIT-RANDOM-NUMBER                                        *PCS14580
      *                                                                *PCS14590
      * THIS MODULE INITIALIZE RANDOM NUMBER GENERATION WITH NEW SEED  *        
      ******************************************************************PCS14650
      *                                                                         
       3000-INIT-RANDOM-NUMBER.                                         
      *                                                                         
           PERFORM 7000-GET-TIMESTAMP           THRU 7000-EXIT.         
           MOVE WS-TIMESTAMP                    TO WS-TIMESTAMP-CHAR.   
           MOVE WS-SEED-CHAR                    TO WS-SEED-NUM.         
           MOVE WS-SEED-NUM                     TO WS-SEED.             
                                                                        
           COMPUTE                                                      
               WS-RANDOM-NUMBER = FUNCTION RANDOM (WS-SEED)             
           END-COMPUTE.                                                 
                                                                        
           COMPUTE                                                      
               WS-RANDOM-NUMBER-F = WS-RANDOM-NUMBER * 10000000         
           END-COMPUTE.                                                 
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS14560
      *                                                                *        
      * 3100-GET-RANDOM-NUMBER                                         *PCS14580
      *                                                                *PCS14590
      * THIS MODULE GETS THE RANDOM NUMBER                             *        
      ******************************************************************PCS14650
      *                                                                         
       3100-GET-RANDOM-NUMBER.                                          
      *                                                                         
           COMPUTE                                                      
               WS-RANDOM-NUMBER = FUNCTION RANDOM                       
           END-COMPUTE.                                                 
                                                                        
           COMPUTE                                                      
               WS-RANDOM-NUMBER-F = WS-RANDOM-NUMBER * 10000000         
           END-COMPUTE.                                                 
      *                                                                         
       3100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************PCS14560
      *                                                                *        
      * 4000-LOAD-FIOCA231                                             *PCS14580
      *                                                                *        
      * THIS MODULE LOADS RECORDS INTO THE O/P FILE FIOCA231           *        
      *                                                                *        
      ******************************************************************PCS14650
      *                                                                         
       4000-LOAD-FIOCA231.                                              
      *                                                                         
           MOVE FIOCA227              TO WS-OTHER-FIELDS-CA231.         
           MOVE WS-FIOCA231-REC       TO FIOCA231.                      
      *                                                                         
       4000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS40420
      *     7000-GET-TIMESTAMP                                         *PCS40440
      *     GETS THE TIMESTAMP                                         *PCS40450
      ******************************************************************PCS40480
       7000-GET-TIMESTAMP.                                              
      *                                                                 15169400
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TIMESTAMP                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     15169500
MFA-TR*        SET :WS-TIMESTAMP = CURRENT TIMESTAMP                    15169600
MFA-TR*    END-EXEC.                                                    15171200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15171300
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE TO WS-DISPLAY-RC                             
              DISPLAY '*****************PCSCA231******************'     
              DISPLAY '* 7000 : RETURN CODE ERROR                *'     
              DISPLAY '*        RC = ' WS-DISPLAY-RC                    
              DISPLAY '* PROGRAM ABENDING...                     *'     
              DISPLAY '*****************PCSCA231******************'     
              PERFORM 9900-ABEND  THRU  9900-EXIT                       
           END-IF.                                                      
      *                                                                 15172600
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15172600
      ******************************************************************PCS40420
      *      8500-WRITE-FCA231-RECORD.                                 *PCS40440
      ******************************************************************PCS40480
      *                                                                         
       8500-WRITE-FCA231-RECORD.                                        
      *                                                                         
           WRITE FIOCA231.                                              
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************PCS40420
      *      8550-READ-FCA227-RECORD.                                  *PCS40440
      ******************************************************************PCS40480
      *                                                                         
       8550-READ-FCA227-RECORD.                                         
      *                                                                         
           READ FCSCA227-FILE                                           
                AT END                                                  
                   MOVE WS-N  TO WS-MORE-DATA-SW                        
                   GO TO 8550-EXIT.                                     
                                                                        
           IF FCA227-SUCCESSFUL                                         
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '**  PCSCA231 PROCESSING ERROR    **'            
               DISPLAY '**  ERROR ON FCSCA227 READ       **'            
               DISPLAY '**  STATUS IS ' WS-FCA227-STATUS                
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS44780
      *                                                                *PCS44790
      *     9000-TERMINATE                                             *PCS44800
      *                                                                *PCS44810
      *     CLOSE FILES                                                *PCS44820
      *                                                                *PCS44830
      ******************************************************************PCS44840
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSCA231-FILE.                                         
           IF FCA231-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  PCSCA231 PROCESSING ERROR              **'  
               DISPLAY '**    CLOSE ERROR OF FCSCA231 - OUTPUT FILE'    
               DISPLAY '**    FILE STATUS = ' WS-FCA231-STATUS          
           END-IF.                                                      
                                                                        
           CLOSE FCSCA227-FILE.                                         
           IF FCA227-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  PCSCA231 PROCESSING ERROR              **'  
               DISPLAY '**    CLOSE ERROR OF FCSCA227 - INPUT  FILE'    
               DISPLAY '**    FILE STATUS = ' WS-FCA227-STATUS          
           END-IF.                                                      
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  9700-PROCESS-ABEND.                                           *        
      ******************************************************************        
              EXEC SQL                                                  15309306
                   INCLUDE CPD0023B                                     15309307
              END-EXEC.                                                 15309308
      *                                                                         
      ******************************************************************        
      * 9900-ABEND                                                     *        
      ******************************************************************        
              EXEC SQL                                                  27290000
                   INCLUDE CPD09900                                     27300000
              END-EXEC.                                                 27310000
