       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA228.                                        
       DATE-WRITTEN.   NOVEMBER 2007.                                   
      ***************************************************************** PCS00050
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               ** PCS00060
      **                                                             ** PCS00110
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **              PROGRAM  MODIFICATION  LOG                     ** PCS00160
      **    DATE      INITIALS      REASON                           ** PCS00170
      **    ____      ________      _______                          ** PCS00180
T35447**    11/19/07   RB19957      INITIAL CODE                     **         
      **             RICK BLACK                                      **         
A35447**    12/10/08   RB19957    1)FIX PROBLEM WITH CODE NOTICE TYPE**         
      **             RICK BLACK     'G' ACCTS HAVING WRONG DNP BALANCE*         
      **                          2)ADD RUN/COMMIT INFORMATION.      **         
A35447**     2/03/09   RB19957    1)ADD THE DATA NEEDED TO LOAD THE  **         
      **             RICK BLACK     NEW COLUMNS TO CSS_ACCT_CRED.     *         
B35447**     3/30/09   RB19957    FIX PROBLEM WITH PAR 8100 GETTING  **         
      **             RICK BLACK     -310 DB2 ERROR.                   *         
A05136**     3/09/16   MR7E794    REMOVE THE DAILY DNP BALANCE CHECK **         
      **               ACT266     IN PARAM 1000-GET-FUTURE-DNP.       *         
ACT092**     3/17/16   BD09555    REMOVE DNP > 0 CHECK               **         
      **A05460-ACT092  ACT266                                         *         
A05460**    11/07/16   RS7V450    ADD QUERY FROM DSN201A4 JOB INTO   **         
      **               ACT334     PCSCA228 PROGRAM.                   *         
      ***************************************************************** PCS00210
      ***************************************************************** PCS00210
      * PROGRAM NARRATIVE                                                       
      * PCSCA228 IS A DAILY PROCESS THAT READS THE CSS_ACCT_CRED                
      * TABLE AND THEN CALLS CPD00068 TO GET THE FUTURE DNP BALANCE.            
      * AFTER GETTING THE FUTURE DNP BALANCE IT UPDATES THE SAME ROW            
      * ON THE SAME TABLE FOR ALL THE ROWS WITHIN THE TABLE.                    
      ******************************************************************        
      ******************************************************************00300000
      *                                                                *00310000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00320000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00340000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00350000
      *  2000 - 2999  NOT USED                                         *00360000
      *  3000 - 4999  NOT USED                                         *00370000
      *  5000 - 5999  NOT USED                                         *00380000
      *  6000 - 6999  NOT USED                                         *00390000
      *  7000 - 7999  INPUT MODULES                                    *00400000
      *  8000 - 8999  OUTPUT MODULES                                   *00410000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00420000
      *                                                                *00430000
      ******************************************************************00440000
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                 00632401
       DATA DIVISION.                                                   
      *                                                                 00632401
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA228'.
MSQ017     COPY MFASQLM.
      *                                                                 00632401
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'PCSCA228'.     
           05  WS-SCSCB068              PIC X(08) VALUE 'SCSCB068'.     
           05  WS-CURRENT-DATE          PIC  X(10) VALUE SPACES.        
           05  WS-CURRENT-TIMESTAMP     PIC  X(26) VALUE SPACES.        
A35447     05  WS-NULL-INDICATOR        PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-IND1             PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-IND2             PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-IND3             PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-IND4             PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-IND5             PIC S9(04) COMP VALUE +0.       
ACT334     05  WS-NULL-IND6             PIC S9(04) COMP VALUE +0.       
           05  WS-COMMIT-COUNT          PIC 9(04) VALUE ZEROS.          
ACT334     05  WS-COUNT1                PIC 9(09) VALUE ZEROS.          
ACT334     05  WS-COUNT2                PIC 9(09) VALUE ZEROS.          
ACT334     05  WS-COUNT3                PIC 9(09) VALUE ZEROS.          
           05  WS-COMMIT-INTERVAL       PIC 9(03) VALUE 100.            
A35447     05  WS-COMMIT-NUMBER         PIC 9(06) VALUE ZEROES.         
           05  WS-INCREMENTED           PIC 9(01) VALUE 1.              
           05  WS-DATE-CREDIT-ACTION    PIC X(10).                      
           05  WS-CODE-NOTICE-TYPE      PIC X(01).                      
A35447     05  WS-CODE-SPECIAL-TYPE     PIC X(01).                      
A35447     05  WS-AMT-BOND              PIC S9(09)V99 COMP-3 VALUE +0.  
A35447     05  WS-AMT-IRR-LTR           PIC S9(09)V99 COMP-3 VALUE +0.  
A35447     05  WS-AMT-GUARANTEED        PIC S9(09)V99 COMP-3 VALUE +0.  
A35447     05  WS-AMT-DEP-ON-HAND       PIC S9(09)V99 COMP-3 VALUE +0.  
A35447     05  WS-AMT-SEC-BAL           PIC S9(09)V99 COMP-3 VALUE +0.  
A35447*                                                                         
A35447 01  RS-RPC-RETURN-CODE.                                          
A35447     05  RS-RETURN-CODE          PIC S9(04) COMP VALUE 0.         
A35447     05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
      *                                                                 03490000
A35447 01  WS-LITERAL.                                                  
A35447     05  WS-A                     PIC X(01) VALUE 'A'.            
A35447     05  WS-B                     PIC X(01) VALUE 'B'.            
A35447     05  WS-Y                     PIC X(01) VALUE 'Y'.            
A35447     05  WS-N                     PIC X(01) VALUE 'N'.            
A35447*                                                                 00891900
      *****************************************************************         
      **      APPLICATION  TABLE DCLGENS                             **         
      *****************************************************************         
           EXEC SQL                                                     03500000
              INCLUDE SQLCA                                             03510000
           END-EXEC.                                                    03520000
A35447*****************************************************************         
A35447*    CSS_ACCT_BILL_NMES  AB                                               
A35447*****************************************************************         
A35447     EXEC SQL                                                     03980000
A35447        INCLUDE TBATBLNM                                          03990000
A35447     END-EXEC.                                                    04000000
      *****************************************************************         
A35447*    CSS_ACCOUNT  AT                                                      
      *****************************************************************         
           EXEC SQL                                                     03980000
              INCLUDE TBACCT                                            03990000
           END-EXEC.                                                    04000000
      *****************************************************************         
ACT334*    CSS_CRED_COLL  CL                                                    
ACT334*****************************************************************         
ACT334     EXEC SQL                                                     03980000
ACT334        INCLUDE TBCRCOLL                                          03990000
ACT334     END-EXEC.                                                    04000000
      *****************************************************************         
A35447*    CSS_ACCT_CRED  1A                                                    
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBACCCRD                                                 
           END-EXEC.                                                            
A35447*****************************************************************         
A35447*    CSS_UTIL_ENVRNMT  UT                                                 
A35447*****************************************************************         
A35447     EXEC SQL                                                     01232600
A35447        INCLUDE TBUTLENV                                          01232700
A35447     END-EXEC.                                                    01232800
A35447*****************************************************************         
A35447*    CSS_ADDR_FORMATTED  DY                                               
A35447*****************************************************************         
A35447     EXEC SQL                                                     01233000
A35447        INCLUDE TBADRFMT                                          01233100
A35447     END-EXEC.                                                    01233200
A35447*****************************************************************         
A35447*    CSS_NAME  DQ                                                         
A35447*****************************************************************         
A35447     EXEC SQL                                                     01233400
A35447        INCLUDE TBNAME                                            01233500
A35447     END-EXEC.                                                    01233600
A35447*****************************************************************         
A35447*    CSS_NAME_ACCT_XREF  HT                                               
A35447*****************************************************************         
A35447     EXEC SQL                                                     01233800
A35447        INCLUDE TBNMACTX                                          01233900
A35447     END-EXEC.                                                    01234000
A35447*****************************************************************         
A35447*    CSS_SURETY_BOND  SB                                                  
A35447*****************************************************************         
A35447     EXEC SQL                                                     01234200
A35447        INCLUDE TBSTYBND                                          01234300
A35447     END-EXEC.                                                    01234400
A35447*****************************************************************         
A35447*    CSS_GUARANTOR  GU                                                    
A35447*****************************************************************         
A35447     EXEC SQL                                                     01234600
A35447        INCLUDE TBGTNTR                                           01234700
A35447     END-EXEC.                                                    01234800
A35447*****************************************************************         
A35447*    CSS_DEP_ON_HAND  DO                                                  
A35447*****************************************************************         
A35447     EXEC SQL                                                     01235000
A35447        INCLUDE TBDEPHND                                          01235100
A35447     END-EXEC.                                                    01235200
A35447*****************************************************************         
A35447*    CSS_CUST_MISC_INFO  LQ                                               
A35447*****************************************************************         
A35447     EXEC SQL                                                     01235400
A35447        INCLUDE TBCSTMSC                                          01235500
A35447     END-EXEC.                                                    01235600
A35447*****************************************************************         
A35447*    CSS_CUST_ADDR_XREF  DM                                               
A35447*****************************************************************         
A35447     EXEC SQL                                                     01237580
A35447        INCLUDE TBCSADRX                                          01237590
A35447     END-EXEC.                                                    01237591
A35447*****************************************************************         
A35447*    CSS_ADDR_FREEFORM  DZ                                                
A35447*****************************************************************         
A35447     EXEC SQL                                                     01237593
A35447        INCLUDE TBADRFRE                                          01237594
A35447     END-EXEC.                                                    01237595
A35447*****************************************************************         
A35447*    CSS_ZIP_CODE  A4                                                     
A35447*****************************************************************         
A35447     EXEC SQL                                                     01237597
A35447        INCLUDE TBZIPCD                                           01237598
A35447     END-EXEC.                                                    01237599
A35447*****************************************************************         
A35447*    CSS_ACCT_MISC_INFO  TA                                               
A35447*****************************************************************         
A35447     EXEC SQL                                                     01237601
A35447        INCLUDE TBATMISC                                          01237602
A35447     END-EXEC.                                                    01237603
A35447*****************************************************************         
A35447*    CSS_CUST_PLAN  CP                                                    
A35447*****************************************************************         
A35447     EXEC SQL                                                     01237601
A35447        INCLUDE TBCSTPLN                                          01237602
A35447     END-EXEC.                                                    01237603
      *****************************************************************         
      *    WS ABEND WORK AREA                                                   
      *****************************************************************         
           EXEC SQL                                                     05474000
              INCLUDE CWS00010                                          05475000
           END-EXEC.                                                    05476000
A35447*****************************************************************         
A35447*    WORKING STORAGE FOR 6010-REDUCE-EMBEDDED-SPACES.                     
A35447*****************************************************************         
A35447     EXEC SQL                                                     05474000
A35447        INCLUDE CWS00011                                          05475000
A35447     END-EXEC.                                                    05476000
      *****************************************************************         
      *    WORKING STORAGE LAYOUT FOR CODES_DATA_PRESENT ON TABLE               
      *    CSS_ACCOUNT                                                          
      *****************************************************************         
           EXEC SQL                                                     05474000
              INCLUDE CWS00056                                          05475000
           END-EXEC.                                                    05476000
      *****************************************************************         
      *    WORKING STORAGE FOR CPD00068                                         
      *****************************************************************         
           EXEC SQL                                                     05474000
              INCLUDE CWS00068                                          05475000
           END-EXEC.                                                    05476000
A35447*****************************************************************         
A35447*    WORKING STORAGE AREAS FOR NAME AND ADDRESS                           
A35447*****************************************************************         
A35447     EXEC SQL                                                     05474000
A35447        INCLUDE CWS00074                                          05475000
A35447     END-EXEC.                                                    05476000
      *****************************************************************         
      *    USED FOR DB2 AND CICS ERROR PROCESSING                               
      *****************************************************************         
           EXEC SQL                                                     05474000
              INCLUDE CWS00303                                          05475000
           END-EXEC.                                                    05476000
      *****************************************************************         
      *    USED FOR DB2 AND CICS ERROR PROCESSING                               
      *****************************************************************         
           EXEC SQL                                                             
            INCLUDE CWS09900                                                    
           END-EXEC.                                                            
      ********************************************************                  
      ** MAIN DRIVING CURSOR TO GET ALL THE ROWS IN THE     **                  
      ** CSS_ACCT_CRED                                      **                  
      ********************************************************                  
           EXEC SQL                                                     
               DECLARE ACCCRD-TABLE CURSOR WITH HOLD FOR                
ACT334         SELECT                                                   
ACT334            AT.ACCOUNT_NO,                                        
ACT334            AT.CODE_MAJOR_ACCT,                                   
ACT334            AT.CODE_DISC_OK,                                      
ACT334            AT.CREDIT_GROUP,                                      
ACT334            AT.CODES_DATA_PRESENT,                                
ACT334            AT.ACCOUNT_TYPE_CODE,                                 
ACT334            AT.LOCAL_OFFICE,                                      
ACT334            AT.DATE_BILL_DAY_00,                                  
ACT334            AT.DATE_BILL_DAY_30,                                  
ACT334            AT.DATE_BILL_DAY_60,                                  
ACT334            AT.DATE_BILL_DAY_90,                                  
ACT334            AT.NOTICE_EXEMPT_CD,                                  
ACT334            AT.COMPANY_NO,                                        
ACT334            AT.BANKRUPTCY_IND,                                    
ACT334            AT.CODE_ACCT_STAT,                                    
ACT334            AT.IVR_EXEMPT_CD,                                     
ACT334            CL.DATE_CREDIT_ACTION,                                
ACT334            CL.CODE_NOTICE_TYPE,                                  
ACT334            CL.CODE_SPECIAL_TYPE,                                 
ACT334            AT.LAST_PYMT_DATE,                                    
ACT334            AT.TOTAL_AR_BALANCE,                                  
ACT334            AT.CODE_CRIT_OUTAGE,                                  
ACT334            AT.PREMISE_NO,                                        
ACT334            AT.CUSTOMER_NO,                                       
ACT334            AT.ADDRESS_ID                                         
ACT334         FROM  CSS_ACCOUNT AT,                                    
ACT334               CSS_CRED_COLL CL                                   
ACT334         WHERE AT.ACCOUNT_NO = CL.ACCOUNT_NO AND                  
ACT334               AT.CODE_ACCT_STAT = 'A' AND                        
ACT334               CL.CODE_NOTICE_TYPE IN ('D','G','H','I')           
           END-EXEC.                                                    
      *                                                                         
A35447****************************************************************          
A35447**      UTIL-ENV-CSR TO FIND READ ROUTE AND UTIL TYPE         **          
A35447****************************************************************          
A35447*                                                                         
A35447     EXEC SQL                                                     
A35447        DECLARE UTIL_ENV_CSR CURSOR FOR                           
A35447        SELECT                                                    
A35447           CODE_UTIL_TYPE,                                        
A35447           READ_ROUTE,                                            
A35447           IC_NO                                                  
A35447        FROM                                                      
A35447           CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                         
A35447        WHERE                                                     
A35447           ACCOUNT_NO = :UT-ACCOUNT-NO                            
A35447        ORDER BY CODE_UTIL_TYPE                                   
A35447         FOR READ ONLY                                    
A35447     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE UTIL_ENV_CSR CURSOR FOR                                   
MFA-TR*       SELECT                                                            
MFA-TR*          CODE_UTIL_TYPE,                                                
MFA-TR*          READ_ROUTE,                                                    
MFA-TR*          IC_NO                                                          
MFA-TR*       FROM                                                              
MFA-TR*          CSS_UTIL_ENVRNMT                                               
MFA-TR*       WHERE                                                             
MFA-TR*          ACCOUNT_NO = :UT-ACCOUNT-NO                                    
MFA-TR*       ORDER BY CODE_UTIL_TYPE                                           
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
A35447*                                                                         
A35447****************************************************************          
A35447**      GET THE UTIL TYPE OF THE UNMETERED SERVICE --         **          
A35447****************************************************************          
A35447*                                                                         
A35447     EXEC SQL                                                     
A35447       DECLARE UNMTRD_CSR  CURSOR FOR                             
A35447         SELECT                                                   
A35447             CODE_SERVICE_TYPE                                    
A35447         FROM                                                     
A35447             CSS_CUST_PLAN                                        
A35447         WHERE                                                    
A35447             ACCOUNT_NO       = :UT-ACCOUNT-NO                    
A35447         AND CODE_UTIL_TYPE   = :UT-CODE-UTIL-TYPE                
A35447         AND IC_NO            = :UT-IC-NO
            OPTION(FAST 1)
            FOR READ ONLY                        
A35447     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ021
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE UNMTRD_CSR  CURSOR FOR                                     
MFA-TR*        SELECT                                                           
MFA-TR*            CODE_SERVICE_TYPE                                            
MFA-TR*        FROM                                                             
MFA-TR*            CSS_CUST_PLAN                                                
MFA-TR*        WHERE                                                            
MFA-TR*            ACCOUNT_NO       = :UT-ACCOUNT-NO                            
MFA-TR*        AND CODE_UTIL_TYPE   = :UT-CODE-UTIL-TYPE                        
MFA-TR*        AND IC_NO            = :UT-IC-NO                                 
MFA-TR*        OPTIMIZE FOR 1 ROW FOR FETCH ONLY                                
MFA-TR*    END-EXEC.                                                            
A35447*                                                                         
      ********************************************************                  
      ********************************************************                  
       PROCEDURE DIVISION.                                              
       0000-MAIN-PROCESS.                                               
           PERFORM 1000-GET-FUTURE-DNP THRU 1000-EXIT.                  
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           STOP RUN.                                                    
       0000-EXIT.                                                       
           EXIT.                                                        
      ********************************************************                  
      ** THIS PROCEDURE STARTS THE PROCESS GETTING ALL THE  **                  
      ** CSS_ACCT_CRED                                      **                  
      ********************************************************                  
       1000-GET-FUTURE-DNP.                                             
ACT334     PERFORM 6000-DELETE-ACCT-CRED THRU 6000-EXIT.                
           PERFORM 7200-SELECT-CURRENT-DATE THRU 7200-EXIT.             
      *                                                                         
A35447     INITIALIZE WS-COMMIT-NUMBER.                                 
           PERFORM 7000-OPEN-ACCCRD-TABLE THRU 7000-EXIT.               
           PERFORM 7010-FETCH-ACCCRD-TABLE THRU 7010-EXIT.              
           PERFORM UNTIL SQLCODE NOT = 0                                
ACT334         MOVE AT-ACCOUNT-NO TO 1A-ACCOUNT-NO                      
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   MOVE WS-CURRENT-DATE TO WS-HOLD-DATE                 
ACT334             MOVE CL-CODE-NOTICE-TYPE TO WS-CODE-NOTICE-TYPE      
ACT334             MOVE CL-CODE-SPECIAL-TYPE TO WS-CODE-SPECIAL-TYPE    
ACT334             MOVE CL-DATE-CREDIT-ACTION TO WS-DATE-CREDIT-ACTION  
                   MOVE 'Y'  TO CALC-ARREARS-SW                         
                                CALC-BALANCE-SW                         
                                LOAD-WS-AMOUNTS-SW                      
A35447                          CALC-PAST-DUE-SW                        
                   MOVE SPACES TO WS-HOLD-DNP-TYPE                      
                   MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT  
                   MOVE PROGRAM-NAME TO WS-CPD00068-CALLING-PGM         
                   MOVE SPACES TO ABEND-FUNCTION                        
                   CALL WS-SCSCB068 USING  CWS00068-FIELDS,             
                                           WS-CODES-DATA-PRESENT,       
                                           DCLCSS-ACCOUNT,              
                                           ABEND-FILE,                  
                                           RS-RETURN-CODE               
A35447             IF WS-DELINQ-LOAD-FL    = 'N'                        
A35447                MOVE 'Y' TO WS-DELINQ-LOAD-FL                     
A35447             END-IF                                               
                   IF ABEND-FUNCTION > SPACES                           
                      PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT         
                   END-IF                                               
                   EVALUATE WS-CODE-NOTICE-TYPE                         
                       WHEN 'D'                                         
                          MOVE  WS-AMT-NOTICE-D  TO WS-AMT-DNP-BAL      
                       WHEN 'G'                                         
                          MOVE  WS-AMT-NOTICE-G  TO WS-AMT-DNP-BAL      
                       WHEN 'I'                                         
                          MOVE  WS-AMT-NOTICE-I  TO WS-AMT-DNP-BAL      
                       WHEN 'H'                                         
                          MOVE  WS-AMT-NOTICE-H  TO WS-AMT-DNP-BAL      
                       WHEN OTHER                                       
                          MOVE  ZERO             TO WS-AMT-DNP-BAL      
                   END-EVALUATE                                         
                   MOVE WS-AMT-DNP-BAL TO 1A-DAILY-DNP-BALANC           
A35447             MOVE WS-AMT-PAST-DUE-NONUTL                          
A35447                                   TO 1A-NONUTL-PAST-DUE-AM       
B35447             INITIALIZE 1A-TOTAL-SECURITY-AM                      
A35447             PERFORM 3300-CALC-SECURITY     THRU 3300-EXIT        
A35447             PERFORM 3400-DETERMINE-AGING   THRU 3400-EXIT        
A35447             PERFORM 3500-DETERMINE-UTILITY THRU 3500-EXIT        
A35447             MOVE WS-Y              TO 1A-DNP-EXISTS-FL           
A35447             MOVE WS-AMT-SEC-BAL    TO 1A-TOTAL-SECURITY-AM       
A35447             MOVE WS-CODE-DPP-ACCT  TO 1A-DPP-ACCOUNT-FL          
ACT334             MOVE AT-ADDRESS-ID     TO 1A-ADDRESS-ID              
A35447             PERFORM 4000-MAIL-NAME-ADDRESS THRU 4000-EXIT        
A35447             MOVE WS-CUSTOMER-NAME  TO 1A-CUST-NAME               
A35447             MOVE WS-NAME-STREET    TO 1A-STREET-NAME             
A35447             MOVE WS-ZIP-CODE       TO 1A-ZIP-CODE                
A35447             MOVE WS-ZIP-PLUS-4     TO 1A-ZIP-CODE-TOKEN          
A35447             MOVE UT-READ-ROUTE     TO 1A-READ-ROUTE              
ACT334             MOVE AT-CUSTOMER-NO    TO LQ-CUSTOMER-NO             
A35447             PERFORM 7900-SELECT-CUST-MISC-INFO THRU 7900-EXIT    
A35447             IF LQ-KEY-CUSTOMER GREATER THAN SPACES               
A35447                 MOVE WS-Y TO 1A-KEY-CUSTOMER                     
A35447             ELSE                                                 
A35447                 MOVE WS-N TO 1A-KEY-CUSTOMER                     
A35447             END-IF                                               
                   PERFORM 8100-UPDATE-DNP THRU 8100-EXIT               
                   ADD WS-INCREMENTED TO WS-COMMIT-COUNT                
                   IF WS-COMMIT-COUNT = WS-COMMIT-INTERVAL              
                      PERFORM 8900-COMMIT                               
A35447                DISPLAY '*** COMMIT # ' , WS-COMMIT-NUMBER        
A35447                DISPLAY '*** ACCOUNT # ' , 1A-ACCOUNT-NO          
A35447                ADD 1 TO WS-COMMIT-NUMBER                         
                      INITIALIZE WS-COMMIT-COUNT                        
                   END-IF                                               
               END-IF                                                   
               PERFORM 7010-FETCH-ACCCRD-TABLE THRU 7010-EXIT           
           END-PERFORM.                                                 
           PERFORM 7020-CLOSE-ACCCRD-TABLE THRU 7020-EXIT.              
ACT334     DISPLAY 'FETCH-COUNT:'     WS-COUNT1.                        
ACT334     DISPLAY 'INSERT-COUNT:'    WS-COUNT2.                        
ACT334     DISPLAY 'UPDATE-COUNT:'    WS-COUNT3.                        
       1000-EXIT.                                                       
           EXIT.                                                        
A35447*---------------------------------------------------------------*         
A35447* PROCEDURE TO CALCULATE SECURITY AMOUNT                        *         
A35447*---------------------------------------------------------------*         
A35447 3300-CALC-SECURITY.                                              
A35447* CSS_SURETY_BOND TABLE IS USED FOR BOTH SURETY BOND (TYPE A) AND 02338800
A35447* IRREVOCABLE LETTER OF CREDIT (TYPE B)                           02338900
A35447     MOVE AT-ACCOUNT-NO TO SB-ACCOUNT-NO.                         
A35447     MOVE WS-A          TO SB-CODE-BOND-TYPE.                     
A35447     MOVE ZEROES        TO WS-AMT-BOND.                           
A35447     PERFORM 7600-SUM-SURETY-BOND THRU 7600-EXIT.                 
A35447*                                                                 02339400
A35447     MOVE WS-B          TO SB-CODE-BOND-TYPE.                     
A35447     MOVE ZEROES        TO WS-AMT-IRR-LTR.                        
A35447     PERFORM 7605-SUM-IRR-LETTER THRU 7605-EXIT.                  
A35447*                                                                 02339800
A35447     MOVE AT-ACCOUNT-NO TO GU-ACCOUNT-NO.                         
A35447     MOVE ZEROES        TO WS-AMT-GUARANTEED.                     
A35447     PERFORM 7610-SUM-GUARANTOR THRU 7610-EXIT.                   
A35447*                                                                 02340200
A35447     MOVE AT-ACCOUNT-NO TO DO-ACCOUNT-NO.                         
A35447     MOVE ZEROES        TO WS-AMT-DEP-ON-HAND.                    
A35447     PERFORM 7620-SUM-DEP-ON-HAND THRU 7620-EXIT.                 
A35447*                                                                 02340600
A35447     COMPUTE WS-AMT-SEC-BAL = WS-AMT-BOND                         
A35447                            + WS-AMT-IRR-LTR                      
A35447                            + WS-AMT-GUARANTEED                   
A35447                            + WS-AMT-DEP-ON-HAND.                 
A35447 3300-EXIT.                                                       
A35447     EXIT.                                                        
A35447*---------------------------------------------------------------*         
A35447* PROCEDURE TO DETERMINE AGING                                  *         
A35447*---------------------------------------------------------------*         
A35447 3400-DETERMINE-AGING.                                            
A35447     EVALUATE TRUE                                                
A35447         WHEN WS-AMT-90-DAY > 0                                   
A35447            MOVE '9'          TO 1A-OLDEST-ARREARS-CD             
A35447         WHEN WS-AMT-60-DAY > 0                                   
A35447            MOVE '6'          TO 1A-OLDEST-ARREARS-CD             
A35447         WHEN WS-AMT-30-DAY > 0                                   
A35447            MOVE '3'          TO 1A-OLDEST-ARREARS-CD             
A35447         WHEN WS-AMT-00-DAY > 0                                   
A35447            MOVE '0'          TO 1A-OLDEST-ARREARS-CD             
A35447     END-EVALUATE.                                                
A35447                                                                  
A35447 3400-EXIT.                                                       
A35447     EXIT.                                                        
A35447*---------------------------------------------------------------*         
A35447* PROCEDURE TO DETERMINE ACCOUNT TYPE UTILITY                   *         
A35447*---------------------------------------------------------------*         
A35447 3500-DETERMINE-UTILITY.                                          
A35447     MOVE AT-ACCOUNT-NO       TO UT-ACCOUNT-NO.                   
A35447     PERFORM 7300-OPEN-UTIL-ENV-CSR             THRU 7300-EXIT.   
A35447     PERFORM 7310-FETCH-UTIL-ENV-CSR            THRU 7310-EXIT.   
A35447     IF UT-CODE-UTIL-TYPE = 'U'                                   
A35447         PERFORM 7400-OPEN-UNMTRD-CSR           THRU 7400-EXIT    
A35447         PERFORM 7410-FETCH-UNMTRD-CSR          THRU 7410-EXIT    
A35447*                                                                         
A35447         IF CP-CODE-SERVICE-TYPE = 'G'                            
A35447             MOVE 'G' TO 1A-CODE-UTIL-TYPE                        
A35447         ELSE                                                     
A35447             MOVE 'E' TO 1A-CODE-UTIL-TYPE                        
A35447         END-IF                                                   
A35447         PERFORM 7420-CLOSE-UNMTRD-CSR THRU 7420-EXIT             
A35447     ELSE                                                         
A35447         MOVE UT-CODE-UTIL-TYPE TO 1A-CODE-UTIL-TYPE              
A35447     END-IF                                                       
A35447*                                                                         
A35447     PERFORM 7320-CLOSE-UTIL-ENV-CSR THRU 7320-EXIT.              
A35447*                                                                         
A35447 3500-EXIT.                                                       
A35447     EXIT.                                                        
A35447*---------------------------------------------------------------*         
A35447* PROCEDURE 6010-REDUCE-EMBEDDED-SPACES.                        *         
A35447*---------------------------------------------------------------*         
A35447 COPY CPD00004.                                                           
A35447*************************************************************     02429010
A35447*  INCLUDE COPYBOOK CPD00074                                *     02429020
A35447*  CALLING MODULE 4000-MAIL-NAME-ADDRESS                    *     02429030
A35447*************************************************************     02429040
A35447     EXEC SQL                                                     02429050
A35447       INCLUDE CPD00074                                           02429060
A35447     END-EXEC.                                                    02429070
ACT334******************************************************************        
ACT334* 6000-DELETE-ACCT-CRED                                          *        
ACT334******************************************************************        
ACT334 6000-DELETE-ACCT-CRED.                                           
ACT334                                                                  
ACT334     EXEC SQL                                                     
ACT334         DELETE FROM CSS_ACCT_CRED                                
ACT334     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT334     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT334     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT334        NEXT SENTENCE                                             
ACT334     ELSE                                                         
ACT334        MOVE WS-ACTIVE-PARAGRAPH   TO ACTIVE-PARAGRAPH            
ACT334        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
ACT334        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
ACT334        MOVE 'DELETE'              TO ABEND-FUNCTION              
ACT334        MOVE 'CSS_ACCT_CRED'       TO TABLE-1                     
ACT334        MOVE 'ACCOUNT-NO       '   TO TABLE-ELEMENT-1             
ACT334        MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
ACT334        MOVE 'DAILY-DNP-BALANC '   TO TABLE-ELEMENT-2             
ACT334        MOVE 1A-DAILY-DNP-BALANC   TO HOSTVAR-ELEMENT-2-N         
ACT334        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
ACT334     END-IF.                                                      
ACT334 6000-EXIT.                                                       
ACT334     EXIT.                                                        
      *---------------------------------------------------------------*         
      * PROCEDURE TO OPEN ACCCRD-TABLE CURSOR.                        *         
      *---------------------------------------------------------------*         
       7000-OPEN-ACCCRD-TABLE.                                          
           MOVE '7000' TO WS-ACTIVE-PARAGRAPH.                          
           EXEC SQL                                                     
               OPEN ACCCRD-TABLE                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = 0                                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-PARAGRAPH   TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE 'OPEN CURSOR'         TO ABEND-FUNCTION              
              MOVE 'CSS_ACCT_CRED'       TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
       7000-EXIT.                                                       
           EXIT.                                                        
      *---------------------------------------------------------------*         
      * PROCEDURE TO FETCH ACCCRD-TABLE CURSOR VALUES                 *         
      *---------------------------------------------------------------*         
       7010-FETCH-ACCCRD-TABLE.                                         
           MOVE '7010' TO WS-ACTIVE-PARAGRAPH.                          
           EXEC SQL                                                     
               FETCH ACCCRD-TABLE                                       
ACT334         INTO   :AT-ACCOUNT-NO                                    
ACT334               ,:AT-CODE-MAJOR-ACCT                               
ACT334               ,:AT-CODE-DISC-OK                                  
ACT334               ,:AT-CREDIT-GROUP                                  
ACT334               ,:AT-CODES-DATA-PRESENT                            
ACT334               ,:AT-ACCOUNT-TYPE-CODE                             
ACT334               ,:AT-LOCAL-OFFICE                                  
ACT334               ,:AT-DATE-BILL-DAY-00 :WS-NULL-IND1                
ACT334               ,:AT-DATE-BILL-DAY-30 :WS-NULL-IND2                
ACT334               ,:AT-DATE-BILL-DAY-60 :WS-NULL-IND3                
ACT334               ,:AT-DATE-BILL-DAY-90 :WS-NULL-IND4                
ACT334               ,:AT-NOTICE-EXEMPT-CD                              
ACT334               ,:AT-COMPANY-NO                                    
ACT334               ,:AT-BANKRUPTCY-IND                                
ACT334               ,:AT-CODE-ACCT-STAT                                
ACT334               ,:AT-IVR-EXEMPT-CD                                 
ACT334               ,:CL-DATE-CREDIT-ACTION :WS-NULL-IND5              
ACT334               ,:CL-CODE-NOTICE-TYPE                              
ACT334               ,:CL-CODE-SPECIAL-TYPE                             
ACT334               ,:AT-LAST-PYMT-DATE :WS-NULL-IND6                 
ACT334               ,:AT-TOTAL-AR-BALANCE                              
ACT334               ,:AT-CODE-CRIT-OUTAGE                              
ACT334               ,:AT-PREMISE-NO                                    
ACT334               ,:AT-CUSTOMER-NO                                   
ACT334               ,:AT-ADDRESS-ID                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      NOT-FOUND                         
ACT334        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
ACT334           PERFORM 7990-MOVE-1A-VALUES     THRU 7990-EXIT         
ACT334           PERFORM 8000-INSERT-ACCT-CRED   THRU 8000-EXIT         
ACT334           ADD +1 TO WS-COUNT1                                    
ACT334        ELSE                                                      
                 NEXT SENTENCE                                          
ACT334        END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-PARAGRAPH   TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE 'FETCH CURSOR'        TO ABEND-FUNCTION              
              MOVE 'CSS_ACCT_CRED'       TO TABLE-1                     
ACT334        MOVE 'AT-ACCOUNT-NO    '   TO TABLE-ELEMENT-1             
ACT334        MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
       7010-EXIT.                                                       
           EXIT.                                                        
      *---------------------------------------------------------------*         
      * PROCEDURE TO CLOSE ACCCRD-TABLE CURSOR                        *         
      *---------------------------------------------------------------*         
       7020-CLOSE-ACCCRD-TABLE.                                         
           MOVE '7020' TO WS-ACTIVE-PARAGRAPH.                          
           EXEC SQL                                                     
               CLOSE ACCCRD-TABLE                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = 0                                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-PARAGRAPH   TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE 'CLOSE CURSOR'        TO ABEND-FUNCTION              
              MOVE 'CSS_ACCT_CRED'       TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
       7020-EXIT.                                                       
           EXIT.                                                        
      *---------------------------------------------------------------*         
      * PROCEDURE TO GET THE CURRENT DATE                             *         
      *---------------------------------------------------------------*         
       7200-SELECT-CURRENT-DATE.                                        
           MOVE '7200' TO WS-ACTIVE-PARAGRAPH.                          
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-DATE = CURRENT DATE                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-PARAGRAPH   TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE 'CURRENT DATE'        TO ABEND-FUNCTION              
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
       7200-EXIT.                                                       
           EXIT.                                                        
A35447*---------------------------------------------------------------*         
A35447* PROCEDURE TO OPEN UTIL_ENV_CSR CURSOR.                        *         
A35447*---------------------------------------------------------------*         
A35447 7300-OPEN-UTIL-ENV-CSR.                                          
A35447*                                                                         
A35447     EXEC SQL                                                     
A35447          OPEN UTIL_ENV_CSR                                       
A35447     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A35447*                                                                 02369900
A35447     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A35447*                                                                         
A35447     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A35447        NEXT SENTENCE                                             
A35447     ELSE                                                         
A35447        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
A35447        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
A35447        MOVE '7300'                TO ACTIVE-PARAGRAPH            
A35447        MOVE 'OPEN'                TO ABEND-FUNCTION              
A35447        MOVE SPACES                TO ABEND-SQL-PREDICATES        
A35447                                      ABEND-TABLES                
A35447        MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                     
A35447        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
A35447        MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
A35447        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
A35447     END-IF.                                                      
A35447 7300-EXIT.                                                       
A35447     EXIT.                                                        
A35447*---------------------------------------------------------------*         
A35447* PROCEDURE TO FETCH UTIL_ENV_CSR CURSOR.                       *         
A35447*---------------------------------------------------------------*         
A35447 7310-FETCH-UTIL-ENV-CSR.                                         
A35447*                                                                         
A35447     EXEC SQL                                                     
A35447          FETCH UTIL_ENV_CSR                                      
A35447     INTO                                                         
A35447          :UT-CODE-UTIL-TYPE,                                     
A35447          :UT-READ-ROUTE :WS-NULL-INDICATOR,                      
A35447          :UT-IC-NO                                               
A35447     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A35447*                                                                 02373700
A35447     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A35447*                                                                         
A35447     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A35447        IF WS-NULL-INDICATOR < 0 OR                               
A35447           WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
A35447           MOVE ZEROS        TO UT-READ-ROUTE                     
A35447        END-IF                                                    
A35447     ELSE                                                         
A35447        MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE            
A35447        MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
A35447        MOVE '7310'                  TO ACTIVE-PARAGRAPH          
A35447        MOVE 'FETCH'                 TO ABEND-FUNCTION            
A35447        MOVE SPACES                  TO ABEND-SQL-PREDICATES      
A35447                                        ABEND-TABLES              
A35447        MOVE 'CSS_UTIL_ENVRNMT'      TO TABLE-1                   
A35447        MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
A35447        MOVE UT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
A35447        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
A35447     END-IF.                                                      
A35447 7310-EXIT.                                                       
A35447     EXIT.                                                        
A35447*---------------------------------------------------------------*         
A35447* PROCEDURE TO CLOSE UTIL_ENV_CSR CURSOR.                       *         
A35447*---------------------------------------------------------------*         
A35447 7320-CLOSE-UTIL-ENV-CSR.                                         
A35447*                                                                         
A35447     EXEC SQL                                                     
A35447          CLOSE UTIL_ENV_CSR                                      
A35447     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A35447*                                                                 02376100
A35447     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A35447*                                                                         
A35447     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A35447        NEXT SENTENCE                                             
A35447     ELSE                                                         
A35447        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
A35447        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
A35447        MOVE '7320'                TO ACTIVE-PARAGRAPH            
A35447        MOVE 'CLOSE'               TO ABEND-FUNCTION              
A35447        MOVE SPACES                TO ABEND-SQL-PREDICATES        
A35447                                      ABEND-TABLES                
A35447        MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                     
A35447        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
A35447        MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
A35447        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
A35447     END-IF.                                                      
A35447 7320-EXIT.                                                       
A35447     EXIT.                                                        
A35447*---------------------------------------------------------------*         
A35447* PROCEDURE TO OPEN UNMTRD-CSR CURSOR.                          *         
A35447*---------------------------------------------------------------*         
A35447 7400-OPEN-UNMTRD-CSR.                                            
A35447*                                                                         
A35447     EXEC SQL                                                     
A35447          OPEN UNMTRD_CSR                                         
A35447     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A35447*                                                                 02369900
A35447     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A35447*                                                                         
A35447     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A35447        NEXT SENTENCE                                             
A35447     ELSE                                                         
A35447        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
A35447        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
A35447        MOVE '7400'                TO ACTIVE-PARAGRAPH            
A35447        MOVE 'OPEN'                TO ABEND-FUNCTION              
A35447        MOVE SPACES                TO ABEND-SQL-PREDICATES        
A35447                                      ABEND-TABLES                
A35447        MOVE 'CSS_CUST_PLAN'       TO TABLE-1                     
A35447        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
A35447        MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
A35447        MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
A35447        MOVE UT-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
A35447        MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
A35447        MOVE UT-IC-NO              TO HOSTVAR-ELEMENT-3           
A35447        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
A35447     END-IF.                                                      
A35447 7400-EXIT.                                                       
A35447     EXIT.                                                        
A35447*---------------------------------------------------------------*         
A35447* PROCEDURE TO FETCH UNMTRD-CSR CURSOR.                         *         
A35447*---------------------------------------------------------------*         
A35447 7410-FETCH-UNMTRD-CSR.                                           
A35447*                                                                         
A35447     EXEC SQL                                                     
A35447          FETCH UNMTRD_CSR                                        
A35447     INTO                                                         
A35447          :CP-CODE-SERVICE-TYPE                                   
A35447     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A35447*                                                                 02373700
A35447     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A35447*                                                                         
A35447     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A35447        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
A35447            MOVE 'U' TO CP-CODE-SERVICE-TYPE                      
A35447                        1A-CODE-UTIL-TYPE                         
A35447        END-IF                                                    
A35447     ELSE                                                         
A35447        MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE            
A35447        MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
A35447        MOVE '7410'                  TO ACTIVE-PARAGRAPH          
A35447        MOVE 'FETCH'                 TO ABEND-FUNCTION            
A35447        MOVE SPACES                  TO ABEND-SQL-PREDICATES      
A35447                                        ABEND-TABLES              
A35447        MOVE 'CSS_CUST_PLAN'       TO TABLE-1                     
A35447        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
A35447        MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
A35447        MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
A35447        MOVE UT-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
A35447        MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
A35447        MOVE UT-IC-NO              TO HOSTVAR-ELEMENT-3           
A35447        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
A35447     END-IF.                                                      
A35447 7410-EXIT.                                                       
A35447     EXIT.                                                        
A35447*---------------------------------------------------------------*         
A35447* PROCEDURE TO CLOSE UNMTRD-CSR CURSOR.                         *         
A35447*---------------------------------------------------------------*         
A35447 7420-CLOSE-UNMTRD-CSR.                                           
A35447*                                                                         
A35447     EXEC SQL                                                     
A35447          CLOSE UNMTRD_CSR                                        
A35447     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A35447*                                                                 02376100
A35447     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A35447*                                                                         
A35447     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A35447        NEXT SENTENCE                                             
A35447     ELSE                                                         
A35447        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
A35447        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
A35447        MOVE '7420'                TO ACTIVE-PARAGRAPH            
A35447        MOVE 'CLOSE'               TO ABEND-FUNCTION              
A35447        MOVE SPACES                TO ABEND-SQL-PREDICATES        
A35447                                      ABEND-TABLES                
A35447        MOVE 'CSS_CUST_PLAN'       TO TABLE-1                     
A35447        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
A35447        MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
A35447        MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
A35447        MOVE UT-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
A35447        MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
A35447        MOVE UT-IC-NO              TO HOSTVAR-ELEMENT-3           
A35447        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
A35447     END-IF.                                                      
A35447 7420-EXIT.                                                       
A35447     EXIT.                                                        
A35447*---------------------------------------------------------------*         
A35447* PROCEDURE TO GET SURETY BOND TOTAL.                           *         
A35447*---------------------------------------------------------------*         
A35447 7600-SUM-SURETY-BOND.                                            
A35447     EXEC SQL                                                     
A35447        SELECT SUM(AMT_BOND)                                      
A35447          INTO :WS-AMT-BOND :WS-NULL-INDICATOR                     
A35447        FROM CSS_SURETY_BOND WITH(READUNCOMMITTED)                        
A35447        WHERE ACCOUNT_NO = :SB-ACCOUNT-NO                         
A35447          AND CODE_BOND_TYPE = :SB-CODE-BOND-TYPE                 
A35447          AND CODE_STATUS = 'A'                                   
A35447                                                           
A35447     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02402700
MFA-TR*       SELECT SUM(AMT_BOND)                                      02402800
MFA-TR*         INTO :WS-AMT-BOND:WS-NULL-INDICATOR                     02402900
MFA-TR*       FROM CSS_SURETY_BOND                                      02403000
MFA-TR*       WHERE ACCOUNT_NO = :SB-ACCOUNT-NO                         02403100
MFA-TR*         AND CODE_BOND_TYPE = :SB-CODE-BOND-TYPE                 02403200
MFA-TR*         AND CODE_STATUS = 'A'                                   02403300
MFA-TR*         WITH UR                                                 02403300
MFA-TR*    END-EXEC.                                                    02403500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A35447                                                                  
A35447     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A35447     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A35447        NEXT SENTENCE                                             
A35447     ELSE                                                         
A35447        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
A35447        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
A35447        MOVE '7600'                TO ACTIVE-PARAGRAPH            
A35447        MOVE 'SELECT'              TO ABEND-FUNCTION              
A35447        MOVE SPACES                TO ABEND-SQL-PREDICATES        
A35447                                      ABEND-TABLES                
A35447        MOVE 'CSS_SURETY_BOND'     TO TABLE-1                     
A35447        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
A35447        MOVE SB-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
A35447        MOVE 'CODE_BOND_TYPE'      TO TABLE-ELEMENT-2             
A35447        MOVE SB-CODE-BOND-TYPE     TO HOSTVAR-ELEMENT-2           
A35447        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
A35447     END-IF.                                                      
A35447 7600-EXIT.                                                       
A35447     EXIT.                                                        
A35447*---------------------------------------------------------------*         
A35447* PROCEDURE TO GET IRROVOCABLE LETTER OF CREDIT TOTAL           *         
A35447*---------------------------------------------------------------*         
A35447 7605-SUM-IRR-LETTER.                                             
A35447     EXEC SQL                                                     
A35447        SELECT SUM(AMT_BOND)                                      
A35447          INTO :WS-AMT-IRR-LTR :WS-NULL-INDICATOR                  
A35447        FROM CSS_SURETY_BOND WITH(READUNCOMMITTED)                        
A35447        WHERE ACCOUNT_NO = :SB-ACCOUNT-NO                         
A35447          AND CODE_BOND_TYPE = :SB-CODE-BOND-TYPE                 
A35447          AND CODE_STATUS ='A'                                    
A35447                                                           
A35447     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02405600
MFA-TR*       SELECT SUM(AMT_BOND)                                      02405700
MFA-TR*         INTO :WS-AMT-IRR-LTR:WS-NULL-INDICATOR                  02405800
MFA-TR*       FROM CSS_SURETY_BOND                                      02405900
MFA-TR*       WHERE ACCOUNT_NO = :SB-ACCOUNT-NO                         02406000
MFA-TR*         AND CODE_BOND_TYPE = :SB-CODE-BOND-TYPE                 02406100
MFA-TR*         AND CODE_STATUS ='A'                                    02406200
MFA-TR*         WITH UR                                                 02403300
MFA-TR*    END-EXEC.                                                    02406400

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A35447                                                                  
A35447     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A35447     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A35447        NEXT SENTENCE                                             
A35447     ELSE                                                         
A35447        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
A35447        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
A35447        MOVE '7605'                TO ACTIVE-PARAGRAPH            
A35447        MOVE 'SELECT'              TO ABEND-FUNCTION              
A35447        MOVE SPACES                TO ABEND-SQL-PREDICATES        
A35447                                      ABEND-TABLES                
A35447        MOVE 'CSS_SURETY_BOND'     TO TABLE-1                     
A35447        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
A35447        MOVE SB-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
A35447        MOVE 'CODE_BOND_TYPE'      TO TABLE-ELEMENT-2             
A35447        MOVE SB-CODE-BOND-TYPE     TO HOSTVAR-ELEMENT-2           
A35447        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
A35447     END-IF.                                                      
A35447 7605-EXIT.                                                       
A35447     EXIT.                                                        
A35447*---------------------------------------------------------------*         
A35447* PROCEDURE TO GET GUARANTOR TOTAL.                             *         
A35447*---------------------------------------------------------------*         
A35447 7610-SUM-GUARANTOR.                                              
A35447     EXEC SQL                                                     
A35447        SELECT SUM(AMOUNT_GUARANTEED)                             
A35447          INTO :WS-AMT-GUARANTEED :WS-NULL-INDICATOR               
A35447        FROM CSS_GUARANTOR WITH(READUNCOMMITTED)                          
A35447        WHERE ACCOUNT_NO = :GU-ACCOUNT-NO                         
A35447        AND   GUAR_STATUS_CD = 'A'                                
A35447                                                           
A35447     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02408500
MFA-TR*       SELECT SUM(AMOUNT_GUARANTEED)                             02408600
MFA-TR*         INTO :WS-AMT-GUARANTEED:WS-NULL-INDICATOR               02408700
MFA-TR*       FROM CSS_GUARANTOR                                        02408800
MFA-TR*       WHERE ACCOUNT_NO = :GU-ACCOUNT-NO                         02408900
MFA-TR*       AND   GUAR_STATUS_CD = 'A'                                02409000
MFA-TR*         WITH UR                                                 02403300
MFA-TR*    END-EXEC.                                                    02409100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A35447                                                                  
A35447     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A35447     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A35447        NEXT SENTENCE                                             
A35447     ELSE                                                         
A35447        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
A35447        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
A35447        MOVE '7610'                TO ACTIVE-PARAGRAPH            
A35447        MOVE 'SELECT'              TO ABEND-FUNCTION              
A35447        MOVE SPACES                TO ABEND-SQL-PREDICATES        
A35447                                      ABEND-TABLES                
A35447        MOVE 'CSS_GUARANTOR'       TO TABLE-1                     
A35447        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
A35447        MOVE GU-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
A35447        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
A35447     END-IF.                                                      
A35447 7610-EXIT.                                                       
A35447     EXIT.                                                        
A35447*---------------------------------------------------------------*         
A35447* PROCEDURE TO GET DEPOSIT TOTAL.                               *         
A35447*---------------------------------------------------------------*         
A35447 7620-SUM-DEP-ON-HAND.                                            
A35447     EXEC SQL                                                     
A35447        SELECT SUM(AMT_DEPOSIT)                                   
A35447          INTO :WS-AMT-DEP-ON-HAND :WS-NULL-INDICATOR              
A35447        FROM CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                        
A35447        WHERE ACCOUNT_NO = :DO-ACCOUNT-NO                         
A35447          AND DEPOSIT_STATUS_CD IN ('A','P')                      
A35447                                                           
A35447     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02411100
MFA-TR*       SELECT SUM(AMT_DEPOSIT)                                   02411200
MFA-TR*         INTO :WS-AMT-DEP-ON-HAND:WS-NULL-INDICATOR              02411300
MFA-TR*       FROM CSS_DEP_ON_HAND                                      02411400
MFA-TR*       WHERE ACCOUNT_NO = :DO-ACCOUNT-NO                         02411500
MFA-TR*         AND DEPOSIT_STATUS_CD IN ('A','P')                      02411600
MFA-TR*         WITH UR                                                 02403300
MFA-TR*    END-EXEC.                                                    02411700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A35447                                                                  
A35447     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A35447     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A35447        NEXT SENTENCE                                             
A35447     ELSE                                                         
A35447        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
A35447        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
A35447        MOVE '7620'                TO ACTIVE-PARAGRAPH            
A35447        MOVE 'SELECT'              TO ABEND-FUNCTION              
A35447        MOVE SPACES                TO ABEND-SQL-PREDICATES        
A35447                                      ABEND-TABLES                
A35447        MOVE 'CSS_DEP_ON_HAND'     TO TABLE-1                     
A35447        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
A35447        MOVE DO-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
A35447        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
A35447     END-IF.                                                      
A35447 7620-EXIT.                                                       
A35447     EXIT.                                                        
A35447*---------------------------------------------------------------*         
A35447* PROCEDURE TO GET MISC CUSTOMER INFORMATION.                   *         
A35447*---------------------------------------------------------------*         
A35447 7900-SELECT-CUST-MISC-INFO.                                      
A35447     EXEC SQL                                                     
A35447        SELECT KEY_CUSTOMER                                       
A35447        INTO   :LQ-KEY-CUSTOMER                                   
A35447        FROM CSS_CUST_MISC_INFO WITH(READUNCOMMITTED)                     
A35447        WHERE CUSTOMER_NO    = :LQ-CUSTOMER-NO                    
A35447                                                           
A35447     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02419300
MFA-TR*       SELECT KEY_CUSTOMER                                       02419400
MFA-TR*       INTO   :LQ-KEY-CUSTOMER                                   02419500
MFA-TR*       FROM CSS_CUST_MISC_INFO                                   02419600
MFA-TR*       WHERE CUSTOMER_NO    = :LQ-CUSTOMER-NO                    02419700
MFA-TR*         WITH UR                                                 02403300
MFA-TR*    END-EXEC.                                                    02419800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A35447                                                                  
A35447     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A35447     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A35447                           OR   NOT-FOUND                         
A35447        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
A35447            MOVE SPACE      TO LQ-KEY-CUSTOMER                    
A35447        END-IF                                                    
A35447     ELSE                                                         
A35447        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
A35447        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
A35447        MOVE '7900'                TO ACTIVE-PARAGRAPH            
A35447        MOVE 'SELECT'              TO ABEND-FUNCTION              
A35447        MOVE SPACES                TO ABEND-SQL-PREDICATES        
A35447                                      ABEND-TABLES                
A35447        MOVE 'CSS_CUST_MISC_INFO'  TO TABLE-1                     
A35447        MOVE 'CUSOTMER_NO'         TO TABLE-ELEMENT-1             
A35447        MOVE LQ-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1           
A35447        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
A35447     END-IF.                                                      
A35447 7900-EXIT.                                                       
A35447     EXIT.                                                        
A35447*                                                                         
ACT334******************************************************************        
ACT334* 7990-MOVE-1A-VALUES.                                           *        
ACT334******************************************************************        
ACT334 7990-MOVE-1A-VALUES.                                             
ACT334        MOVE AT-ACCOUNT-NO         TO 1A-ACCOUNT-NO.              
ACT334        MOVE AT-CODE-MAJOR-ACCT    TO 1A-CODE-MAJOR-ACCT.         
ACT334        MOVE AT-CODE-DISC-OK       TO 1A-CODE-DISC-OK.            
ACT334        MOVE AT-CREDIT-GROUP       TO 1A-CREDIT-GROUP.            
ACT334        MOVE AT-CODES-DATA-PRESENT TO 1A-CODES-DATA-PRESENT.      
ACT334        MOVE AT-ACCOUNT-TYPE-CODE  TO 1A-ACCOUNT-TYPE-CODE.       
ACT334        MOVE AT-LOCAL-OFFICE       TO 1A-LOCAL-OFFICE.            
ACT334        MOVE AT-DATE-BILL-DAY-00   TO 1A-DATE-BILL-DAY-00.        
ACT334        MOVE AT-DATE-BILL-DAY-30   TO 1A-DATE-BILL-DAY-30.        
ACT334        MOVE AT-DATE-BILL-DAY-60   TO 1A-DATE-BILL-DAY-60.        
ACT334        MOVE AT-DATE-BILL-DAY-90   TO 1A-DATE-BILL-DAY-90.        
ACT334        MOVE AT-NOTICE-EXEMPT-CD   TO 1A-NOTICE-EXEMPT-CD.        
ACT334        MOVE AT-COMPANY-NO         TO 1A-COMPANY-NO.              
ACT334        MOVE AT-BANKRUPTCY-IND     TO 1A-BANKRUPTCY-IND.          
ACT334        MOVE AT-CODE-ACCT-STAT     TO 1A-CODE-ACCT-STAT.          
ACT334        MOVE AT-IVR-EXEMPT-CD      TO 1A-IVR-EXEMPT-CD.           
ACT334        MOVE CL-DATE-CREDIT-ACTION TO 1A-DATE-CREDIT-ACTION.      
ACT334        MOVE CL-CODE-NOTICE-TYPE   TO 1A-CODE-NOTICE-TYPE.        
ACT334        MOVE CL-CODE-SPECIAL-TYPE  TO 1A-CODE-SPECIAL-TYPE.       
ACT334        MOVE AT-LAST-PYMT-DATE     TO 1A-LAST-PYMT-DATE.          
ACT334        MOVE AT-TOTAL-AR-BALANCE   TO 1A-TOTAL-AR-BALANCE.        
ACT334        MOVE AT-CODE-CRIT-OUTAGE   TO 1A-CODE-CRIT-OUTAGE.        
ACT334        MOVE AT-PREMISE-NO         TO 1A-PREMISE-NO.              
ACT334        MOVE AT-CUSTOMER-NO        TO 1A-CUSTOMER-NO.             
ACT334        MOVE AT-ADDRESS-ID         TO 1A-ADDRESS-ID.              
ACT334 7990-EXIT.                                                       
ACT334     EXIT.                                                        
      *                                                                         
ACT334******************************************************************        
ACT334* 8000-INSERT-ACCT-CRED.                                         *        
ACT334******************************************************************        
ACT334 8000-INSERT-ACCT-CRED.                                           
ACT334                                                                  
ACT334     EXEC SQL                                                     
ACT334         INSERT INTO CSS_ACCT_CRED                                
ACT334                (                                                 
ACT334                ACCOUNT_NO                                        
ACT334               ,CODE_MAJOR_ACCT                                   
ACT334               ,CODE_DISC_OK                                      
ACT334               ,CREDIT_GROUP                                      
ACT334               ,CODES_DATA_PRESENT                                
ACT334               ,ACCOUNT_TYPE_CODE                                 
ACT334               ,LOCAL_OFFICE                                      
ACT334               ,DATE_BILL_DAY_00                                  
ACT334               ,DATE_BILL_DAY_30                                  
ACT334               ,DATE_BILL_DAY_60                                  
ACT334               ,DATE_BILL_DAY_90                                  
ACT334               ,NOTICE_EXEMPT_CD                                  
ACT334               ,COMPANY_NO                                        
ACT334               ,BANKRUPTCY_IND                                    
ACT334               ,CODE_ACCT_STAT                                    
ACT334               ,IVR_EXEMPT_CD                                     
ACT334               ,DATE_CREDIT_ACTION                                
ACT334               ,CODE_NOTICE_TYPE                                  
ACT334               ,DAILY_DNP_BALANC                                  
ACT334               ,DNP_EXISTS_FL                                     
ACT334               ,CODE_SPECIAL_TYPE                                 
ACT334               ,TOTAL_SECURITY_AM                                 
ACT334               ,OLDEST_ARREARS_CD                                 
ACT334               ,DPP_ACCOUNT_FL                                    
ACT334               ,CODE_UTIL_TYPE                                    
ACT334               ,LAST_PYMT_DATE                                    
ACT334               ,READ_ROUTE                                        
ACT334               ,TOTAL_AR_BALANCE                                  
ACT334               ,NONUTL_PAST_DUE_AM                                
ACT334               ,CODE_CRIT_OUTAGE                                  
ACT334               ,KEY_CUSTOMER                                      
ACT334               ,CUST_NAME                                         
ACT334               ,STREET_NAME                                       
ACT334               ,ZIP_CODE                                          
ACT334               ,ZIP_CODE_TOKEN                                    
ACT334               ,PREMISE_NO                                        
ACT334               ,CUSTOMER_NO                                       
ACT334               ,ADDRESS_ID                                        
ACT334                )                                                 
ACT334         VALUES                                                   
ACT334                (                                                 
ACT334                :1A-ACCOUNT-NO                                    
ACT334               ,:1A-CODE-MAJOR-ACCT                               
ACT334               ,:1A-CODE-DISC-OK                                  
ACT334               ,:1A-CREDIT-GROUP                                  
ACT334               ,:1A-CODES-DATA-PRESENT                            
ACT334               ,:1A-ACCOUNT-TYPE-CODE                             
ACT334               ,:1A-LOCAL-OFFICE                                  
ACT334               ,IIF(TRY_CONVERT(DATE, :1A-DATE-BILL-DAY-00 
                                            :WS-NULL-IND1
              ) IS NULL OR (PATINDEX('%.%', :1A-DATE-BILL-DAY-00 
                                                          :WS-NULL-IND1
              ) <> 0) OR (LEN(:1A-DATE-BILL-DAY-00 :WS-NULL-IND1
              ) <> 10), CIS.CHAR2DATE(:1A-DATE-BILL-DAY-00 
                                                          :WS-NULL-IND1
              ), CONVERT(DATE, :1A-DATE-BILL-DAY-00 :WS-NULL-IND1) )           
ACT334               ,IIF(TRY_CONVERT(DATE, :1A-DATE-BILL-DAY-30 
                                            :WS-NULL-IND2
              ) IS NULL OR (PATINDEX('%.%', :1A-DATE-BILL-DAY-30 
                                                          :WS-NULL-IND2
              ) <> 0) OR (LEN(:1A-DATE-BILL-DAY-30 :WS-NULL-IND2
              ) <> 10), CIS.CHAR2DATE(:1A-DATE-BILL-DAY-30 
                                                          :WS-NULL-IND2
              ), CONVERT(DATE, :1A-DATE-BILL-DAY-30 :WS-NULL-IND2) )           
ACT334               ,IIF(TRY_CONVERT(DATE, :1A-DATE-BILL-DAY-60 
                                            :WS-NULL-IND3
              ) IS NULL OR (PATINDEX('%.%', :1A-DATE-BILL-DAY-60 
                                                          :WS-NULL-IND3
              ) <> 0) OR (LEN(:1A-DATE-BILL-DAY-60 :WS-NULL-IND3
              ) <> 10), CIS.CHAR2DATE(:1A-DATE-BILL-DAY-60 
                                                          :WS-NULL-IND3
              ), CONVERT(DATE, :1A-DATE-BILL-DAY-60 :WS-NULL-IND3) )           
ACT334               ,IIF(TRY_CONVERT(DATE, :1A-DATE-BILL-DAY-90 
                                            :WS-NULL-IND4
              ) IS NULL OR (PATINDEX('%.%', :1A-DATE-BILL-DAY-90 
                                                          :WS-NULL-IND4
              ) <> 0) OR (LEN(:1A-DATE-BILL-DAY-90 :WS-NULL-IND4
              ) <> 10), CIS.CHAR2DATE(:1A-DATE-BILL-DAY-90 
                                                          :WS-NULL-IND4
              ), CONVERT(DATE, :1A-DATE-BILL-DAY-90 :WS-NULL-IND4) )           
ACT334               ,:1A-NOTICE-EXEMPT-CD                              
ACT334               ,:1A-COMPANY-NO                                    
ACT334               ,:1A-BANKRUPTCY-IND                                
ACT334               ,:1A-CODE-ACCT-STAT                                
ACT334               ,:1A-IVR-EXEMPT-CD                                 
ACT334               ,IIF(TRY_CONVERT(DATE, :1A-DATE-CREDIT-ACTION 
                                            :WS-NULL-IND5
              ) IS NULL OR (PATINDEX('%.%', :1A-DATE-CREDIT-ACTION 
                                                          :WS-NULL-IND5
              ) <> 0) OR (LEN(:1A-DATE-CREDIT-ACTION :WS-NULL-IND5
              ) <> 10), CIS.CHAR2DATE(:1A-DATE-CREDIT-ACTION 
                                                          :WS-NULL-IND5
              ), CONVERT(DATE, :1A-DATE-CREDIT-ACTION :WS-NULL-IND5) )         
ACT334               ,:1A-CODE-NOTICE-TYPE                              
ACT334               ,0                                                 
ACT334               ,'N'                                               
ACT334               ,:1A-CODE-SPECIAL-TYPE                             
ACT334               ,0                                                 
ACT334               ,' '                                               
ACT334               ,' '                                               
ACT334               ,' '                                               
ACT334               ,IIF(TRY_CONVERT(DATE, :1A-LAST-PYMT-DATE 
                                            :WS-NULL-IND6
              ) IS NULL OR (PATINDEX('%.%', :1A-LAST-PYMT-DATE 
                                                          :WS-NULL-IND6
              ) <> 0) OR (LEN(:1A-LAST-PYMT-DATE :WS-NULL-IND6
              ) <> 10), CIS.CHAR2DATE(:1A-LAST-PYMT-DATE :WS-NULL-IND6
              ), CONVERT(DATE, :1A-LAST-PYMT-DATE :WS-NULL-IND6) )             
ACT334               ,0                                                 
ACT334               ,:1A-TOTAL-AR-BALANCE                              
ACT334               ,0                                                 
ACT334               ,:1A-CODE-CRIT-OUTAGE                              
ACT334               ,' '                                               
ACT334               ,' '                                               
ACT334               ,' '                                               
ACT334               ,' '                                               
ACT334               ,' '                                               
ACT334               ,:1A-PREMISE-NO                                    
ACT334               ,:1A-CUSTOMER-NO                                   
ACT334               ,:1A-ADDRESS-ID                                    
ACT334                )                                                 
ACT334     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_ACCT_CRED                                        
MFA-TR*               (                                                         
MFA-TR*               ACCOUNT_NO                                                
MFA-TR*              ,CODE_MAJOR_ACCT                                           
MFA-TR*              ,CODE_DISC_OK                                              
MFA-TR*              ,CREDIT_GROUP                                              
MFA-TR*              ,CODES_DATA_PRESENT                                        
MFA-TR*              ,ACCOUNT_TYPE_CODE                                         
MFA-TR*              ,LOCAL_OFFICE                                              
MFA-TR*              ,DATE_BILL_DAY_00                                          
MFA-TR*              ,DATE_BILL_DAY_30                                          
MFA-TR*              ,DATE_BILL_DAY_60                                          
MFA-TR*              ,DATE_BILL_DAY_90                                          
MFA-TR*              ,NOTICE_EXEMPT_CD                                          
MFA-TR*              ,COMPANY_NO                                                
MFA-TR*              ,BANKRUPTCY_IND                                            
MFA-TR*              ,CODE_ACCT_STAT                                            
MFA-TR*              ,IVR_EXEMPT_CD                                             
MFA-TR*              ,DATE_CREDIT_ACTION                                        
MFA-TR*              ,CODE_NOTICE_TYPE                                          
MFA-TR*              ,DAILY_DNP_BALANC                                          
MFA-TR*              ,DNP_EXISTS_FL                                             
MFA-TR*              ,CODE_SPECIAL_TYPE                                         
MFA-TR*              ,TOTAL_SECURITY_AM                                         
MFA-TR*              ,OLDEST_ARREARS_CD                                         
MFA-TR*              ,DPP_ACCOUNT_FL                                            
MFA-TR*              ,CODE_UTIL_TYPE                                            
MFA-TR*              ,LAST_PYMT_DATE                                            
MFA-TR*              ,READ_ROUTE                                                
MFA-TR*              ,TOTAL_AR_BALANCE                                          
MFA-TR*              ,NONUTL_PAST_DUE_AM                                        
MFA-TR*              ,CODE_CRIT_OUTAGE                                          
MFA-TR*              ,KEY_CUSTOMER                                              
MFA-TR*              ,CUST_NAME                                                 
MFA-TR*              ,STREET_NAME                                               
MFA-TR*              ,ZIP_CODE                                                  
MFA-TR*              ,ZIP_CODE_TOKEN                                            
MFA-TR*              ,PREMISE_NO                                                
MFA-TR*              ,CUSTOMER_NO                                               
MFA-TR*              ,ADDRESS_ID                                                
MFA-TR*               )                                                         
MFA-TR*        VALUES                                                           
MFA-TR*               (                                                         
MFA-TR*               :1A-ACCOUNT-NO                                            
MFA-TR*              ,:1A-CODE-MAJOR-ACCT                                       
MFA-TR*              ,:1A-CODE-DISC-OK                                          
MFA-TR*              ,:1A-CREDIT-GROUP                                          
MFA-TR*              ,:1A-CODES-DATA-PRESENT                                    
MFA-TR*              ,:1A-ACCOUNT-TYPE-CODE                                     
MFA-TR*              ,:1A-LOCAL-OFFICE                                          
MFA-TR*              ,:1A-DATE-BILL-DAY-00 :WS-NULL-IND1                        
MFA-TR*              ,:1A-DATE-BILL-DAY-30 :WS-NULL-IND2                        
MFA-TR*              ,:1A-DATE-BILL-DAY-60 :WS-NULL-IND3                        
MFA-TR*              ,:1A-DATE-BILL-DAY-90 :WS-NULL-IND4                        
MFA-TR*              ,:1A-NOTICE-EXEMPT-CD                                      
MFA-TR*              ,:1A-COMPANY-NO                                            
MFA-TR*              ,:1A-BANKRUPTCY-IND                                        
MFA-TR*              ,:1A-CODE-ACCT-STAT                                        
MFA-TR*              ,:1A-IVR-EXEMPT-CD                                         
MFA-TR*              ,:1A-DATE-CREDIT-ACTION  :WS-NULL-IND5                     
MFA-TR*              ,:1A-CODE-NOTICE-TYPE                                      
MFA-TR*              ,0                                                         
MFA-TR*              ,'N'                                                       
MFA-TR*              ,:1A-CODE-SPECIAL-TYPE                                     
MFA-TR*              ,0                                                         
MFA-TR*              ,' '                                                       
MFA-TR*              ,' '                                                       
MFA-TR*              ,' '                                                       
MFA-TR*              ,:1A-LAST-PYMT-DATE :WS-NULL-IND6                          
MFA-TR*              ,0                                                         
MFA-TR*              ,:1A-TOTAL-AR-BALANCE                                      
MFA-TR*              ,0                                                         
MFA-TR*              ,:1A-CODE-CRIT-OUTAGE                                      
MFA-TR*              ,' '                                                       
MFA-TR*              ,' '                                                       
MFA-TR*              ,' '                                                       
MFA-TR*              ,' '                                                       
MFA-TR*              ,' '                                                       
MFA-TR*              ,:1A-PREMISE-NO                                            
MFA-TR*              ,:1A-CUSTOMER-NO                                           
MFA-TR*              ,:1A-ADDRESS-ID                                            
MFA-TR*               )                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT334     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT334     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT334        ADD +1 TO WS-COUNT2                                       
ACT334*       NEXT SENTENCE                                                     
ACT334     ELSE                                                         
ACT334        MOVE WS-ACTIVE-PARAGRAPH   TO ACTIVE-PARAGRAPH            
ACT334        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
ACT334        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
ACT334        MOVE 'INSERT'              TO ABEND-FUNCTION              
ACT334        MOVE 'CSS_ACCT_CRED'       TO TABLE-1                     
ACT334        MOVE 'ACCOUNT-NO       '   TO TABLE-ELEMENT-1             
ACT334        MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
ACT334        MOVE 'DAILY-DNP-BALANC '   TO TABLE-ELEMENT-2             
ACT334        MOVE 1A-DAILY-DNP-BALANC   TO HOSTVAR-ELEMENT-2-N         
ACT334        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
ACT334     END-IF.                                                      
ACT334 8000-EXIT.                                                       
ACT334     EXIT.                                                        
      *---------------------------------------------------------------*         
      * THIS PROCEDURE UPDATES THE DAILY-DNP-BALANC IN THE            *         
      * CSS_ACCT_CRED                                                 *         
      *---------------------------------------------------------------*         
       8100-UPDATE-DNP.                                                 
           MOVE '8100' TO WS-ACTIVE-PARAGRAPH.                          
           EXEC SQL                                                     
             UPDATE  CSS_ACCT_CRED                                      
                SET  DAILY_DNP_BALANC   = :1A-DAILY-DNP-BALANC          
A35447              ,NONUTL_PAST_DUE_AM = :1A-NONUTL-PAST-DUE-AM        
A35447              ,DNP_EXISTS_FL      = :1A-DNP-EXISTS-FL             
A35447              ,TOTAL_SECURITY_AM  = :1A-TOTAL-SECURITY-AM         
A35447              ,DPP_ACCOUNT_FL     = :1A-DPP-ACCOUNT-FL            
A35447              ,OLDEST_ARREARS_CD  = :1A-OLDEST-ARREARS-CD         
A35447              ,CODE_UTIL_TYPE     = :1A-CODE-UTIL-TYPE            
A35447              ,CUST_NAME          = :1A-CUST-NAME                 
A35447              ,STREET_NAME        = :1A-STREET-NAME               
A35447              ,ZIP_CODE           = :1A-ZIP-CODE                  
A35447              ,ZIP_CODE_TOKEN     = :1A-ZIP-CODE-TOKEN            
A35447              ,READ_ROUTE         = :1A-READ-ROUTE                
A35447              ,KEY_CUSTOMER       = :1A-KEY-CUSTOMER              
ACT334         WHERE ACCOUNT_NO         = :1A-ACCOUNT-NO                
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT334        ADD +1 TO WS-COUNT3                                       
      *       NEXT SENTENCE                                                     
           ELSE                                                         
              MOVE WS-ACTIVE-PARAGRAPH   TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCT_CRED'       TO TABLE-1                     
              MOVE 'ACCOUNT-NO       '   TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'DAILY-DNP-BALANC '   TO TABLE-ELEMENT-2             
              MOVE 1A-DAILY-DNP-BALANC   TO HOSTVAR-ELEMENT-2-N         
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
       8100-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      *  ISSUES A COMMIT POINT                                      **          
      ****************************************************************          
       8900-COMMIT.                                                     
           EXEC SQL                                                             
              INCLUDE CPD00047                                                  
           END-EXEC.                                                            
                                                    
       8900-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      **  9000-TERMINATE                                              **        
      *        NORMAL TERMINATION OF THE PROGRAM                      **        
      ******************************************************************        
       9000-TERMINATE.                                                  
A35447     DISPLAY 'PROGRAM NAME        ' ,  PROGRAM-NAME.              
           DISPLAY 'RETURN CODE         ' ,  RS-RETURN-CODE.            
       9000-EXIT.                                                       
           EXIT.                                                        
      **********************************************************                
      *     9700-ABEND                                                          
      *     PERFORMED IF VSAM OR DB2 PROBLEM OCCURS.                            
      **********************************************************                
           EXEC SQL                                                             
            INCLUDE CPD0023B                                                    
           END-EXEC.                                                            
      **********************************************************                
      *     9700-PROCESS-ABEND                                                  
      *     PERFORMED IF VSAM OR DB2 PROBLEM OCCURS.                            
      **********************************************************                
           EXEC SQL                                                             
            INCLUDE CPD09900                                                    
           END-EXEC.                                                            
