       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA226.                                        
       DATE-WRITTEN.   APRIL 2004.                                      
      ***************************************************************** PCS00050
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               ** PCS00060
      **                     PRICE WATERHOUSE                        ** PCS00070
      **                1410 NORTH WESTSHORE BLVD                    ** PCS00080
      **                   TAMPA, FLORIDA  33607                     ** PCS00090
      **                      (813) 287-9200                         ** PCS00100
      **                                                             ** PCS00110
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             ** PCS00150
      **              PROGRAM  MODIFICATION  LOG                     ** PCS00160
      **    DATE      INITIALS      REASON                           ** PCS00170
      **    ____      ________      _______                          ** PCS00180
T30409**    04/13/04   RB19957      THIS CODE IS THE CURSOR SELECT   **         
T30409**                            PART OF THE ORIGINAL PCSCA206 AND**         
T30409**                            PRODUCES AN EXTRACT FILE FOR     **         
T30409**                            INPUT TO THE NEW REVISED PCSCA206**         
T33184**    03/01/06   RB19957      ADDED CZ.CR_BUR_RPT_DT CHECK TO  **         
T33184**                RICK        THE STEP 3000 CURSOR SELECT.     **         
T32596**    03/17/06   RB19957      ADDED REG-GROUP-CD TO OUTPUT FILE**         
T32596**                RICK        SO IT CAN BE USED IN SORT STEP   **         
T32596**                            PRIOR TO PCSCA206 JOB.  REPLACES **         
T32596**                            REGULATED LOOKUP IN PCSCA206.    **         
T32596**                            REMOVED TRAILER RECORD AS WELL.  **         
T30169**    04/03/08   MN90523      WRITE OFF RECOVERY CHANGES       **         
C30169**    10/17/08   CVNS         DELETE THE CODES REFERENCES TO   **         
C30169**               CHENNAI      CSS_FINAL_WO TABLE FIELDS.       **         
A280  **    11/12/08   CVNS         WHEN PRE-ASSIGNING AGENCY BASED  **         
A280  **               CHENNAI      ON PREVIOUS ASSIGNMENT FOR       **         
A280  **                            DIFFERENT ACCOUNT OF THE SAME    **         
A280  **                            CUSTOMER OR BASED ON THE ACCOUNTS**         
A280  **                            PREVIOUS PLACEMENT ASSIGNMENT,   **         
A280  **                            CHECK IF THE AGENCY IS STILL     **         
A280  **                            ACTIVE.                          **         
SEBOM9**    01/15/09   SS42021      POPULATE REG GROUP CD FIELD FOR  **         
      **                            ALL SEB ACCTS. WARRANTY CHANGE.  **         
P00160**    06/09/09   SS42021      ADD NEW FIELDS FOR METRO 2 FORMAT**         
A01700**    09/11/09   SS42021      FIX CA ASGNMT FOR SAME CUSTOMER  **         
      **                            WITH MULTIPLE ACCOUNTS           **         
A01823**    01/06/10   MJ13662      IF WO BALANCE > WG-WO-MAX-BALANCE *         
A01823**                            MOVE 'N' TO ARRANGEMENT-EXIST FLAG.         
A01823**                            ADDED FOR FETCH ONLY WITH UR TO  **         
A01823**                            CURSOR AND ADDED WITH UR TO SELECT.         
A03116**    03/18/11   SP95538      ALLOW COLLECTION AGENCY ASSIGNMENT*         
A03116**                            ON JUDGMENT ACCOUNTS.             *         
      **                                                              *         
A05154**  29 JAN 2015  RF10596      CLEAN UP UNUSED CODE              *         
      **                                                              *         
      ***************************************************************** PCS00210
      ***************************************************************** PCS00210
      *                                                                 00240000
      * PROGRAM NARRATIVE                                                       
      *                                                                         
      * PCSCA206 IS A WEEKLY PROCESS THAT SENDS WRITTEN OFF UTILITY             
      * AND NON UTILITY ACCOUNTS TO THE COLLECTION AGENCY AND OR CREDIT         
      * BUREAU. IT ALSO SENDS ACTIVE NON UTILITY ACCOUNTS WITH 60 OR            
T30405* 90 DAY ARREARS.  THIS PROGRAM DOES THE EXTRACT/SELECTION FOR            
T30405* PCSCA206.                                                               
      *                                                                         
      * COLLECTION AGENCY PROCESS -- THE ACCOUNT IS EXTRACTED FROM              
T30169* CSS_FIN_WO_ACTION WHEN THE COLLECTION DATE IS BETWEEN THE RUN   PCS01110
      * DATE OF PCSCA206 AND THE LAST RUN DATE OF PCSCA206.                     
      *                                                                         
      * CREDIT BUREAU PROCESS                                                   
      * WRITE OFF ACCOUNT -- THE ACCOUNT IS EXTRACTED FROM                      
T30169* CSS_FIN_WO_ACTION WHEN THE CREDIT BUREAU RPT DATE IS BETWEEN    PCS01110
      * THE RUN DATE OF PCSCA206 AND THE LAST RUN DATE OF PCSCA206.             
      *                                                                         
      * ACTIVE ACCOUNTS -- THE ACCOUNT IS EXTRACTED FROM CSS_CRED_COLL          
      * WHERE CODE NOTICE TYPE EQUALS 'L' AND DATE_CREDIT_ACTION IS             
      * BETWEEN THE RUN DATE OF PCSCA206 AND THE LAST RUN DATE OF               
      * PCSCA206.                                                               
      *                                                                         
PCR499* PROGRAM ALSO SUPPORTS SUBSEQUENT CREDIT BUREAU REPORTING.               
      * THE DRIVING FIELD FOR SUBSEQUENT CREDIT BUREAU REPORTING IS             
      * THE CREDIT BUREAU REPORT DATE ON CSS_CREDIT_PROFILE                     
      * CR_BUR_RPT_DT (SEE I:\CIS\ALL\PCR\DESIGN\PCRD0499.DOC FOR               
      * SPECIFICS OF FUNCTIONALITY.                                             
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                 PCS01190
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
T30405 COPY CSSCA226.                                                           
T30169 COPY CSSCA227.                                                           
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
T30405 COPY CFDCA226.                                                           
T30405 COPY FIOCA226.                                                           
T30169 COPY CFDCA227.                                                           
T30169 COPY FIOCA227.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA226'.
MSQ017     COPY MFASQLM.
       01  WS-WORK-AREA.                                                
           05  WS-PROGRAM-DATE            PIC X(10).                    
           05  WS-COMPANY-NO              PIC X(02).                    
           05  WS-LAST-RUN-DATE           PIC X(10).                    
           05  WS-ACCOUNT-NO              PIC S9(13)V   COMP-3 VALUE 0. 
T16184     05  NULL-VALUE                 PIC S9(4)     COMP VALUE -1.  
T16184     05  NOT-NULL-VALUE             PIC S9(4)     COMP VALUE +0.  
           05  WS-COLLECTION-DT-NULL      PIC S9(04)    COMP VALUE +0.  
T21879     05  WS-FIRST-CR-LTR-DT-NULL    PIC S9(04)    COMP VALUE +0.  
T30169     05  WS-CZ-CR-BUR-RPT-NULL      PIC S9(04)    COMP VALUE +0.  
T30169     05  WS-COLL-AGNCY-CD-NULL      PIC S9(04)    COMP VALUE +0.  
T30169     05  WS-COLL-AGY-SUB-CD-NULL    PIC S9(04)    COMP VALUE +0.  
PCR499     05  CZ-CR-BUR-RPT-DT-NULL      PIC S9(04)    COMP VALUE +0.  
           05  WS-LAST-PYMT-DATE-NULL     PIC S9(04)    COMP VALUE +0.  
           05  WS-ACCT-CREATE-DT-NULL     PIC S9(04)    COMP VALUE +0.  
           05  WS-ACCT-FINALED-DT-NULL    PIC S9(04)    COMP VALUE +0.  
           05  WS-DELINQ-LIMIT            PIC S9(05)    COMP-3 VALUE 0. 
           05  WS-DELINQ-LIMIT-NULL       PIC S9(04)    COMP VALUE +0.  
           05  WS-DATE-LSTD-CRDT-BUR-NULL PIC S9(04)    COMP VALUE +0.  
           05  WS-DATE-BILL-DAY-00-NULL   PIC S9(04)    COMP VALUE +0.  
           05  WS-DATE-BILL-DAY-30-NULL   PIC S9(04)    COMP VALUE +0.  
           05  WS-DATE-BILL-DAY-60-NULL   PIC S9(04)    COMP VALUE +0.  
           05  WS-DATE-BILL-DAY-90-NULL   PIC S9(04)    COMP VALUE +0.  
NUTIL      05  WS-DATE-NOTICE-MAIL-NULL   PIC S9(04)    COMP VALUE +0.  
NUTIL      05  WS-DATE-CREDIT-ACTION-NULL PIC S9(04)    COMP VALUE +0.  
T30169     05  WS-CO-AMT-TRANS-NULL       PIC S9(04)    COMP VALUE +0.  
           05  WS-TIMESTAMP               PIC X(26)     VALUE SPACES.   
T30169     05  WS-COUNTER                 PIC 9(04)     COMP VALUE ZERO.
T30169     05  WS-WRITE-OFF-DT            PIC X(10)     VALUE SPACES.   
COB305     05 WS-WRITE-OFF-AM        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.  
T30169     05  WS-FIRST-CR-LTR-DT         PIC X(10)     VALUE SPACES.   
COB305     05 WS-FIRST-CR-LTR-AM        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.  
T30169     05  WS-CR-BUR-RPT-DT           PIC X(10)     VALUE SPACES.   
T30169     05  WS-CZ-CR-BUR-RPT-DT        PIC X(10)     VALUE SPACES.   
T30169     05  WS-CODE-COLLEC-AGNCY       PIC X(03)     VALUE SPACES.   
T30169     05  WS-COLL-AGY-SUB-CD         PIC X(03)     VALUE SPACES.   
T30169     05  WS-FW-ACTION-DT            PIC X(10)     VALUE SPACES.   
T30169     05  WS-FW-ACTION-TYPE-CD       PIC X(05)     VALUE SPACES.   
COB305     05 WS-FW-ACTION-AM        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.  
COB305     05 WS-WRITE-OFF-BALANCE        PIC S9(11)V9(2) COMP-3 
COB305       VALUE 0.       
T30169     05  WS-LPC-ASSESS-DT           PIC X(10) VALUE SPACES.       
T30169     05  WS-EXCH-INFO-EXIST         PIC X(01) VALUE SPACES.       
T30169     05  WS-ACCOUNT-TYPE-CODE       PIC X(01) VALUE SPACES.       
T30169     05  WS-DATA-REC-TYPE           PIC X(04) VALUE SPACES.       
T30169     05  WS-CA-RANDOM-DELINQ        PIC S9(4)V9(5) COMP-3 VALUE 0.
T30169     05  WS-CA-LIMIT-DELINQ         PIC S9(4)V9(5) COMP-3 VALUE 0.
COB305     05 WS-TRANS-DIFF-AMT        PIC S9(09)V9(02) USAGE COMP-3 
COB305       VALUE 0.
COB305     05 WS-DEBIT-AMT        PIC S9(09)V9(02) USAGE COMP-3 VALUE 0.
COB305     05 WS-CREDIT-AMT        PIC S9(09)V9(02) USAGE COMP-3 
COB305       VALUE 0.
           05  WS-DISPLAY-SQLCODE         PIC -ZZZZZZZZ9.               
T25628     05  WS-PROGRAM-DATE-XX.                                      
T25628         10  WS-PROGRAM-DATE-CCYYMM PIC X(07).                    
T25628         10  WS-PROGRAM-DATE-DASH2  PIC X(01).                    
T25628         10  WS-PROGRAM-DATE-DA     PIC X(02).                    
T25628     05  WS-CREDBUR-DATE-XX.                                      
T25628         10  WS-CREDBUR-DATE-CCYYMM PIC X(07).                    
T25628         10  WS-CREDBUR-DATE-DASH2  PIC X(01).                    
T25628         10  WS-CREDBUR-DATE-DA     PIC X(02).                    
T25628     05  WS-JOB-PARM-STATUS         PIC X(1)  VALUE 'A'.          
T25628     05  WS-RESTART-SW              PIC X(1)  VALUE 'N'.          
                                                                        
T30169 01  WS-TABLES.                                                   
T30169     05  WS-SUMMARY-CA277-DATA.                                   
T30169         10 WS-SMRY-CNTRL           PIC 9(04) COMP VALUE ZERO.    
T30169         10 WS-SMRY-TABLE-RECORD OCCURS 50 TIMES                  
T30169                                INDEXED BY WS-SMRY-INDEX.         
T30169            20 WS-REG-GROUP-CD-SMRY  PIC X(03) VALUE SPACES.      
T30169            20 WS-ACTION-TYPE-SMRY   PIC X(05) VALUE SPACES.      
T30169            20 WS-ACCT-TYPE-CD-SMRY  PIC X(01) VALUE SPACES.      
T30169            20 WS-TOTAL-ACT-TYP-SMRY PIC S9(09) COMP VALUE 0.     
T30169            20 WS-TOTAL-WO-BAL-SMRY                               
                                         PIC S9(11)V9(2) COMP-3 VALUE 0.
      *                                                                         
       01  WS-FILE-STATUS.                                              
T30405     05  WS-FCA226-STATUS          PIC X(02).                     
T30405         88  FCA226-SUCCESSFUL                VALUE '00'.         
T30169     05  WS-FCA227-STATUS          PIC X(02).                     
T30169         88  FCA227-SUCCESSFUL                VALUE '00'.         
      *                                                                         
       01  RS-RETURN-CODE-VARIABLES.                                    
           05  RS-RETURN-CODE           PIC S9(04) COMP VALUE 0.        
           05  RS-RETURN-CODE-DISP      PIC +Z(04).                     
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME              PIC X(08)  VALUE 'PCSCA226'.    
           05  PROGRAM-NAME             PIC X(08)  VALUE 'PCSCA226'.    
           05  WS-SYSTEM                PIC X(06)  VALUE 'SYSTEM'.      
           05  WS-CUSTOMER-TYPE         PIC X(01)  VALUE 'C'.           
           05  WS-Y                     PIC X(01)  VALUE 'Y'.           
           05  WS-N                     PIC X(01)  VALUE 'N'.           
           05  WS-L                     PIC X(01)  VALUE 'L'.           
           05  WS-DISPLAY-RC            PIC ---9.                       
NUTIL      05  WS-DELINQ-CD             PIC X(20).                      
           05  WS-LAST-R-DATE-LITERAL   PIC X(14)  VALUE                
                  'LAST RUN DATE='.                                     
      *                                                                         
       01  WS-PROGRAM-FLAGS.                                            
T22307     05  WS-COMPANY-FLAG          PIC X(04)  VALUE SPACES.        
T22307         88  SCEG                            VALUE 'SCEG'.        
T22307         88  SEB                             VALUE 'SEB'.         
T23230         88  PSNC                            VALUE 'PSNC'.        
T23230     05  WS-COMPANY-NUM           PIC X(02)  VALUE SPACES.        
T30169     05  WS-CA-EXCEMPT-FLAG       PIC X(01)  VALUE 'N'.           
T30169         88  CA-EXCEMPT-EXIST                VALUE 'Y'.           
T30169         88  CA-EXCEMPT-NOT-EXIST            VALUE 'N'.           
T30169     05  WS-CA277-BYPASS-FLAG     PIC X(01)  VALUE 'N'.           
T30169         88  BYPASS-CA277                    VALUE 'Y'.           
T30169         88  CONTINUE-CA277                  VALUE 'N'.           
T30169     05  WS-WRITE-FILES           PIC X(01)  VALUE 'N'.           
T30169         88  WRITE-TO-CA227                  VALUE 'Y'.           
T30169         88  WRITE-TO-CA226                  VALUE 'N'.           
A01823     05  WS-ARRANGEMENT-EXIST     PIC X(01)  VALUE 'N'.           
T30169     05  WS-DECEASED-FLAG         PIC X(01)  VALUE 'N'.           
T30169         88  DECEASED-ACCOUNT                VALUE 'Y'.           
T30169         88  NOT-DECEASED-ACCOUNT            VALUE 'N'.           
      *                                                                         
       COPY FIOJC01.                                                    PCS01330
       COPY FIOCA00.                                                    PCS01330
      *************************************************************             
      * CWS09900 WORK AREA COPYBOOK                              **             
      *************************************************************             
       COPY CWS09900.                                                   PCS01900
      *************************************************************             
      * CWS00303 WORK AREA COPYBOOK                              **             
      *************************************************************             
       COPY CWS00303.                                                   PCS01900
      *************************************************************             
      * CWS00010 WORK AREA COPYBOOK                              **             
      *************************************************************             
       COPY CWS00010.                                                           
      *                                                                         
      *************************************************************             
      * CWS00038 WORK AREA COPYBOOK                              **             
      *************************************************************             
           EXEC SQL                                                             
              INCLUDE CWS00038                                          PCS01900
           END-EXEC.                                                            
      *                                                                 PCS02170
      *************************************************************             
      * CWS00039 WORK AREA COPYBOOK                              **             
      *************************************************************             
           EXEC SQL                                                             
              INCLUDE CWS00039                                          PCS01900
           END-EXEC.                                                            
      *                                                                 PCS02170
      *************************************************************             
      * CWS00074 WORK AREA COPYBOOK                              **             
      *************************************************************             
           EXEC SQL                                                             
              INCLUDE CWS00074                                          PCS01900
           END-EXEC.                                                            
      *                                                                 PCS11040
           EXEC SQL                                                             
             INCLUDE SQLCA                                              PCS01900
           END-EXEC.                                                            
      *                                                                 PCS11040
      *********< CSS_JOB_PARM      - G6 >**************************             
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
      *                                                                 PCS11040
      *********< CSS_ACCOUNT       - AT >**************************             
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
      *                                                                 PCS11040
      *********< CSS_FINAL_WO      - FW >**************************             
           EXEC SQL                                                             
             INCLUDE TBFINLWO                                                   
           END-EXEC.                                                            
      *                                                                         
      *********< CSS_CREDIT_PROFILE- CZ >**************************             
           EXEC SQL                                                             
             INCLUDE TBCRPROF                                                   
           END-EXEC.                                                            
      *                                                                 PCS11040
      *********< CSS_DELINQUENCY   - C8 >**************************             
           EXEC SQL                                                             
             INCLUDE TBDELQ                                                     
           END-EXEC.                                                            
T30169*                                                                         
      *********< CSS_FIN_WO_ACTION - KD >**************************             
           EXEC SQL                                                             
             INCLUDE TBFWACTN                                                   
           END-EXEC.                                                            
T30169*                                                                         
      *********< CSS_FIN_WO_COLLECT- IZ >**************************             
           EXEC SQL                                                             
             INCLUDE TBFWCLAG                                                   
           END-EXEC.                                                            
T30169*                                                                         
      *********< CSS_CHRG_OFF      - CO >**************************             
           EXEC SQL                                                             
             INCLUDE TBCHGOFF                                                   
           END-EXEC.                                                            
T30169*                                                                         
      *********< CSS_FIN_WO_COL_HST- FM >**************************             
           EXEC SQL                                                             
             INCLUDE TBFWAHST                                                   
           END-EXEC.                                                            
T30169*                                                                         
      *********< CSS_ACCT_ATTRIBUTE- YP >**************************             
           EXEC SQL                                                             
             INCLUDE TBACTATT                                                   
           END-EXEC.                                                            
T30169*                                                                         
      *********< CSS_WO_ARRANGEMENT- WG >**************************             
           EXEC SQL                                                             
             INCLUDE TBWOARGM                                                   
           END-EXEC.                                                            
      *                                                                         
T30169*                                                                         
      ************< CSS_EXCH_DATA_RECV - EL > *********************             
           EXEC SQL                                                             
             INCLUDE TBEXCREC                                                   
           END-EXEC.                                                            
      *                                                                         
T30169*                                                                         
      ************< CSS_AR_TRANS_HIST  - AR > *********************             
           EXEC SQL                                                     02000000
             INCLUDE TBARHIST                                           02010000
           END-EXEC.                                                    02020000
      *                                                                         
T30169*                                                                         
      ************< CSS_AR_TRN_HST_DET - AU > *********************             
           EXEC SQL                                                     02030000
             INCLUDE TBARHDT                                            02030000
           END-EXEC                                                     02030000
      *                                                                         
A280  ************< CSS_COLL_AGY_ASSGN - KU > *********************             
A280       EXEC SQL                                                     02030000
A280         INCLUDE TBCAASSN                                           02030000
A280       END-EXEC                                                     02030000
A280  *                                                                         
T32596*************************************************************     PCS11040
T32596*    CSS_REG_PROFILE - LR                                         PCS11040
T32596*************************************************************     PCS11040
T32596     EXEC SQL                                                             
T32596       INCLUDE TBREGPRF                                                   
T32596     END-EXEC.                                                            
T32596*                                                                         
T30169     EXEC SQL                                                     
T30169       DECLARE FW_COLL_CREDB_CUR CURSOR FOR                       
                SELECT                                                  
                      KD.FW_ACTION_TYPE_CD,                             
                      KD.FW_SEQ_NO,                                     
                      KD.FW_ACTION_DT,                                  
                      KD.FW_ACTION_AM,                                  
                      AT.ACCOUNT_NO,                                    
                      AT.COMPANY_NO,                                    
                      AT.LOCAL_OFFICE,                                  
                      AT.PREMISE_NO,                                    
                      AT.CUSTOMER_NO,                                   
                      AT.ACCOUNT_TYPE_CODE,                             
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           AT.ACCT_CREATE_DT, 121), ' ', '-'), ':', '.') 
           ACCT_CREATE_DT,                                
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           AT.ACCT_FINALED_DT, 121), ' ', '-'), ':', '.') 
           ACCT_FINALED_DT,                               
                      AT.ADDRESS_FORMAT,                                
                      AT.ADDRESS_ID,                                    
                      AT.BILL_CYCLE,                                    
                      AT.CODES_DATA_PRESENT,                            
                      AT.LAST_PYMT_DATE,                                
                      AT.LAST_PYMT_AMOUNT,                              
                      AT.TOTAL_AR_BALANCE,                              
                      AT.DATE_BILL_DAY_00,                              
                      AT.DATE_BILL_DAY_30,                              
                      AT.DATE_BILL_DAY_60,                              
                      AT.DATE_BILL_DAY_90,                              
T11937                AT.BANKRUPTCY_IND,                                
                      AT.CODE_DISC_OK,                                  
                      AT.NOTICE_EXEMPT_CD,                              
                      AT.CODE_ACCT_STAT,                                
                      AT.CREDIT_GROUP,                                  
T13565                AT.CODE_STATUS_REASON,                            
T23230                AT.JUDGEMENT_IND,                                 
C28788                AT.IVR_EXEMPT_CD                                  
                FROM                                                    
                      CSS_FIN_WO_ACTION KD
                           WITH(READUNCOMMITTED), CSS_ACCOUNT AT
                           WITH(READUNCOMMITTED)              
                WHERE                                                   
                      KD.ACCOUNT_NO = AT.ACCOUNT_NO                     
T16459            AND AT.CODE_ACCT_STAT = 'S'                           
T23230            AND AT.COMPANY_NO = :WS-COMPANY-NUM                   
                  AND KD.FW_ACTION_DT >  IIF(TRY_CONVERT(DATE, 
                                                      :WS-LAST-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-RUN-DATE
              ) <> 0) OR (LEN(:WS-LAST-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-LAST-RUN-DATE
              ), CONVERT(DATE, :WS-LAST-RUN-DATE) )              
                  AND KD.FW_ACTION_DT <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-PROGRAM-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PROGRAM-DATE
              ) <> 0) OR (LEN(:WS-PROGRAM-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-PROGRAM-DATE
              ), CONVERT(DATE, :WS-PROGRAM-DATE) )               
                  AND KD.FW_ACTION_TYPE_CD                              
                       IN ('1PLMT','2PLMT','3PLMT','ATY','SAL','CREDB') 
A01823          FOR READ ONLY                                          
A01823                                                           
T30169     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE FW_COLL_CREDB_CUR CURSOR FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*               KD.FW_ACTION_TYPE_CD,                                     
MFA-TR*               KD.FW_SEQ_NO,                                             
MFA-TR*               KD.FW_ACTION_DT,                                          
MFA-TR*               KD.FW_ACTION_AM,                                          
MFA-TR*               AT.ACCOUNT_NO,                                            
MFA-TR*               AT.COMPANY_NO,                                            
MFA-TR*               AT.LOCAL_OFFICE,                                          
MFA-TR*               AT.PREMISE_NO,                                            
MFA-TR*               AT.CUSTOMER_NO,                                           
MFA-TR*               AT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               AT.ACCT_CREATE_DT,                                        
MFA-TR*               AT.ACCT_FINALED_DT,                                       
MFA-TR*               AT.ADDRESS_FORMAT,                                        
MFA-TR*               AT.ADDRESS_ID,                                            
MFA-TR*               AT.BILL_CYCLE,                                            
MFA-TR*               AT.CODES_DATA_PRESENT,                                    
MFA-TR*               AT.LAST_PYMT_DATE,                                        
MFA-TR*               AT.LAST_PYMT_AMOUNT,                                      
MFA-TR*               AT.TOTAL_AR_BALANCE,                                      
MFA-TR*               AT.DATE_BILL_DAY_00,                                      
MFA-TR*               AT.DATE_BILL_DAY_30,                                      
MFA-TR*               AT.DATE_BILL_DAY_60,                                      
MFA-TR*               AT.DATE_BILL_DAY_90,                                      
MFA-TR*               AT.BANKRUPTCY_IND,                                        
MFA-TR*               AT.CODE_DISC_OK,                                          
MFA-TR*               AT.NOTICE_EXEMPT_CD,                                      
MFA-TR*               AT.CODE_ACCT_STAT,                                        
MFA-TR*               AT.CREDIT_GROUP,                                          
MFA-TR*               AT.CODE_STATUS_REASON,                                    
MFA-TR*               AT.JUDGEMENT_IND,                                         
MFA-TR*               AT.IVR_EXEMPT_CD                                          
MFA-TR*         FROM                                                            
MFA-TR*               CSS_FIN_WO_ACTION KD, CSS_ACCOUNT AT                      
MFA-TR*         WHERE                                                           
MFA-TR*               KD.ACCOUNT_NO = AT.ACCOUNT_NO                             
MFA-TR*           AND AT.CODE_ACCT_STAT = 'S'                                   
MFA-TR*           AND AT.COMPANY_NO = :WS-COMPANY-NUM                           
MFA-TR*           AND KD.FW_ACTION_DT >  :WS-LAST-RUN-DATE                      
MFA-TR*           AND KD.FW_ACTION_DT <= :WS-PROGRAM-DATE                       
MFA-TR*           AND KD.FW_ACTION_TYPE_CD                                      
MFA-TR*                IN ('1PLMT','2PLMT','3PLMT','ATY','SAL','CREDB')         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
             DECLARE DEL_NON_UTIL_CRSR CURSOR FOR                       
                SELECT                                                  
                  AT.ACCOUNT_NO,                                        
                  AT.COMPANY_NO,                                        
                  AT.LOCAL_OFFICE,                                      
                  AT.PREMISE_NO,                                        
                  AT.CUSTOMER_NO,                                       
                  AT.ACCOUNT_TYPE_CODE,                                 
                  REPLACE(REPLACE(CONVERT(CHAR(26), AT.ACCT_CREATE_DT
           , 121), ' ', '-'), ':', '.') ACCT_CREATE_DT,                        
                  AT.ADDRESS_FORMAT,                                    
                  AT.ADDRESS_ID,                                        
                  AT.BILL_CYCLE,                                        
                  AT.CODES_DATA_PRESENT,                                
                  AT.LAST_PYMT_DATE,                                    
                  AT.LAST_PYMT_AMOUNT,                                  
                  AT.TOTAL_AR_BALANCE,                                  
                  AT.DATE_BILL_DAY_00,                                  
                  AT.DATE_BILL_DAY_30,                                  
                  AT.DATE_BILL_DAY_60,                                  
                  AT.DATE_BILL_DAY_90,                                  
                  AT.BANKRUPTCY_IND,                                    
                  AT.CODE_DISC_OK,                                      
                  AT.NOTICE_EXEMPT_CD,                                  
                  AT.CODE_ACCT_STAT,                                    
                  AT.CREDIT_GROUP,                                      
T13565            AT.CODE_STATUS_REASON,                                
C28788            AT.IVR_EXEMPT_CD,                                     
PCR499            CZ.CR_BUR_RPT_DT                                      
                FROM                                                    
                      CSS_CRED_COLL CL
                           WITH(READUNCOMMITTED), CSS_ACCOUNT AT
                           WITH(READUNCOMMITTED),                 
                      CSS_CREDIT_PROFILE CZ WITH(READUNCOMMITTED)               
                WHERE                                                   
                      CL.ACCOUNT_NO = AT.ACCOUNT_NO                     
                  AND CL.ACCOUNT_NO = CZ.ACCOUNT_NO                     
T23230            AND AT.COMPANY_NO = :WS-COMPANY-NUM                   
                  AND AT.CODE_DISC_OK = ' '                             
T25628            AND AT.NOTICE_EXEMPT_CD IN (' ','1','2','3','4','5',  
T25628                                        '6','7','8','9','A','B')  
                  AND CL.DATE_CREDIT_ACTION >  IIF(TRY_CONVERT(DATE, 
                                                      :WS-LAST-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-RUN-DATE
              ) <> 0) OR (LEN(:WS-LAST-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-LAST-RUN-DATE
              ), CONVERT(DATE, :WS-LAST-RUN-DATE) )        
                  AND CL.DATE_CREDIT_ACTION <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-PROGRAM-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PROGRAM-DATE
              ) <> 0) OR (LEN(:WS-PROGRAM-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-PROGRAM-DATE
              ), CONVERT(DATE, :WS-PROGRAM-DATE) )         
                  AND CL.CODE_NOTICE_TYPE = :WS-L                       
                  AND CL.ITEM_ID = 0                                    
T33184            AND CZ.CR_BUR_RPT_DT IS NULL                          
T20923            AND AT.BANKRUPTCY_IND = ' '                           
                FOR READ ONLY                                          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE DEL_NON_UTIL_CRSR CURSOR FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*           AT.ACCOUNT_NO,                                                
MFA-TR*           AT.COMPANY_NO,                                                
MFA-TR*           AT.LOCAL_OFFICE,                                              
MFA-TR*           AT.PREMISE_NO,                                                
MFA-TR*           AT.CUSTOMER_NO,                                               
MFA-TR*           AT.ACCOUNT_TYPE_CODE,                                         
MFA-TR*           AT.ACCT_CREATE_DT,                                            
MFA-TR*           AT.ADDRESS_FORMAT,                                            
MFA-TR*           AT.ADDRESS_ID,                                                
MFA-TR*           AT.BILL_CYCLE,                                                
MFA-TR*           AT.CODES_DATA_PRESENT,                                        
MFA-TR*           AT.LAST_PYMT_DATE,                                            
MFA-TR*           AT.LAST_PYMT_AMOUNT,                                          
MFA-TR*           AT.TOTAL_AR_BALANCE,                                          
MFA-TR*           AT.DATE_BILL_DAY_00,                                          
MFA-TR*           AT.DATE_BILL_DAY_30,                                          
MFA-TR*           AT.DATE_BILL_DAY_60,                                          
MFA-TR*           AT.DATE_BILL_DAY_90,                                          
MFA-TR*           AT.BANKRUPTCY_IND,                                            
MFA-TR*           AT.CODE_DISC_OK,                                              
MFA-TR*           AT.NOTICE_EXEMPT_CD,                                          
MFA-TR*           AT.CODE_ACCT_STAT,                                            
MFA-TR*           AT.CREDIT_GROUP,                                              
MFA-TR*           AT.CODE_STATUS_REASON,                                        
MFA-TR*           AT.IVR_EXEMPT_CD,                                             
MFA-TR*           CZ.CR_BUR_RPT_DT                                              
MFA-TR*         FROM                                                            
MFA-TR*               CSS_CRED_COLL CL, CSS_ACCOUNT AT,                         
MFA-TR*               CSS_CREDIT_PROFILE CZ                                     
MFA-TR*         WHERE                                                           
MFA-TR*               CL.ACCOUNT_NO = AT.ACCOUNT_NO                             
MFA-TR*           AND CL.ACCOUNT_NO = CZ.ACCOUNT_NO                             
MFA-TR*           AND AT.COMPANY_NO = :WS-COMPANY-NUM                           
MFA-TR*           AND AT.CODE_DISC_OK = ' '                                     
MFA-TR*           AND AT.NOTICE_EXEMPT_CD IN (' ','1','2','3','4','5',          
MFA-TR*                                       '6','7','8','9','A','B')          
MFA-TR*           AND CL.DATE_CREDIT_ACTION >  :WS-LAST-RUN-DATE                
MFA-TR*           AND CL.DATE_CREDIT_ACTION <= :WS-PROGRAM-DATE                 
MFA-TR*           AND CL.CODE_NOTICE_TYPE = :WS-L                               
MFA-TR*           AND CL.ITEM_ID = 0                                            
MFA-TR*           AND CZ.CR_BUR_RPT_DT IS NULL                                  
MFA-TR*           AND AT.BANKRUPTCY_IND = ' '                                   
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
PCR499     EXEC SQL                                                     
             DECLARE SUBSEQ_RPT_N_UTIL CURSOR FOR                       
                SELECT                                                  
                  AT.ACCOUNT_NO,                                        
                  AT.COMPANY_NO,                                        
                  AT.LOCAL_OFFICE,                                      
                  AT.PREMISE_NO,                                        
                  AT.CUSTOMER_NO,                                       
                  AT.ACCOUNT_TYPE_CODE,                                 
                  REPLACE(REPLACE(CONVERT(CHAR(26), AT.ACCT_CREATE_DT
           , 121), ' ', '-'), ':', '.') ACCT_CREATE_DT,                        
                  AT.ADDRESS_FORMAT,                                    
                  AT.ADDRESS_ID,                                        
                  AT.LAST_PYMT_DATE,                                    
                  AT.LAST_PYMT_AMOUNT,                                  
                  AT.DATE_BILL_DAY_00,                                  
                  AT.DATE_BILL_DAY_30,                                  
                  AT.DATE_BILL_DAY_60,                                  
                  AT.DATE_BILL_DAY_90,                                  
                  AT.CODE_ACCT_STAT,                                    
                  AT.CREDIT_GROUP,                                      
T13565            AT.CODE_STATUS_REASON,                                
C28788            AT.IVR_EXEMPT_CD,                                     
                  CZ.CR_BUR_RPT_DT                                      
                FROM                                                    
                      CSS_ACCOUNT AT WITH(READUNCOMMITTED),                     
                      CSS_CREDIT_PROFILE CZ WITH(READUNCOMMITTED)               
                WHERE                                                   
                      AT.ACCOUNT_NO = CZ.ACCOUNT_NO                     
T23230            AND AT.COMPANY_NO = :WS-COMPANY-NUM                   
                  AND AT.CODE_ACCT_STAT = 'A'                           
                  AND AT.CREDIT_GROUP   = 'D'                           
T25628            AND AT.CODE_DISC_OK = ' '                             
T25628            AND AT.NOTICE_EXEMPT_CD IN (' ','1','2','3','4','5',  
T25628                                        '6','7','8','9','A','B')  
                  AND CZ.CR_BUR_RPT_DT  <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-LAST-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-RUN-DATE
              ) <> 0) OR (LEN(:WS-LAST-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-LAST-RUN-DATE
              ), CONVERT(DATE, :WS-LAST-RUN-DATE) )            
                  AND CZ.CR_BUR_RPT_DT IS NOT NULL                      
T20923            AND AT.BANKRUPTCY_IND = ' '                           
                FOR READ ONLY                                          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE SUBSEQ_RPT_N_UTIL CURSOR FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*           AT.ACCOUNT_NO,                                                
MFA-TR*           AT.COMPANY_NO,                                                
MFA-TR*           AT.LOCAL_OFFICE,                                              
MFA-TR*           AT.PREMISE_NO,                                                
MFA-TR*           AT.CUSTOMER_NO,                                               
MFA-TR*           AT.ACCOUNT_TYPE_CODE,                                         
MFA-TR*           AT.ACCT_CREATE_DT,                                            
MFA-TR*           AT.ADDRESS_FORMAT,                                            
MFA-TR*           AT.ADDRESS_ID,                                                
MFA-TR*           AT.LAST_PYMT_DATE,                                            
MFA-TR*           AT.LAST_PYMT_AMOUNT,                                          
MFA-TR*           AT.DATE_BILL_DAY_00,                                          
MFA-TR*           AT.DATE_BILL_DAY_30,                                          
MFA-TR*           AT.DATE_BILL_DAY_60,                                          
MFA-TR*           AT.DATE_BILL_DAY_90,                                          
MFA-TR*           AT.CODE_ACCT_STAT,                                            
MFA-TR*           AT.CREDIT_GROUP,                                              
MFA-TR*           AT.CODE_STATUS_REASON,                                        
MFA-TR*           AT.IVR_EXEMPT_CD,                                             
MFA-TR*           CZ.CR_BUR_RPT_DT                                              
MFA-TR*         FROM                                                            
MFA-TR*               CSS_ACCOUNT AT,                                           
MFA-TR*               CSS_CREDIT_PROFILE CZ                                     
MFA-TR*         WHERE                                                           
MFA-TR*               AT.ACCOUNT_NO = CZ.ACCOUNT_NO                             
MFA-TR*           AND AT.COMPANY_NO = :WS-COMPANY-NUM                           
MFA-TR*           AND AT.CODE_ACCT_STAT = 'A'                                   
MFA-TR*           AND AT.CREDIT_GROUP   = 'D'                                   
MFA-TR*           AND AT.CODE_DISC_OK = ' '                                     
MFA-TR*           AND AT.NOTICE_EXEMPT_CD IN (' ','1','2','3','4','5',          
MFA-TR*                                       '6','7','8','9','A','B')          
MFA-TR*           AND CZ.CR_BUR_RPT_DT  <= :WS-LAST-RUN-DATE                    
MFA-TR*           AND CZ.CR_BUR_RPT_DT IS NOT NULL                              
MFA-TR*           AND AT.BANKRUPTCY_IND = ' '                                   
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
T25628     EXEC SQL                                                     
T25628       DECLARE SUBSEQ_RPT_FB CURSOR FOR                           
T25628          SELECT                                                  
T25628            AT.ACCOUNT_NO,                                        
T25628            AT.COMPANY_NO,                                        
T25628            AT.LOCAL_OFFICE,                                      
T25628            AT.PREMISE_NO,                                        
T25628            AT.CUSTOMER_NO,                                       
T25628            AT.ACCOUNT_TYPE_CODE,                                 
T25628            REPLACE(REPLACE(CONVERT(CHAR(26), AT.ACCT_CREATE_DT
           , 121), ' ', '-'), ':', '.') ACCT_CREATE_DT,                        
T25628            REPLACE(REPLACE(CONVERT(CHAR(26), AT.ACCT_FINALED_DT
           , 121), ' ', '-'), ':', '.') ACCT_FINALED_DT,                       
T25628            AT.ADDRESS_FORMAT,                                    
T25628            AT.ADDRESS_ID,                                        
T25628            AT.BILL_CYCLE,                                        
T25628            AT.CODES_DATA_PRESENT,                                
T25628            AT.LAST_PYMT_DATE,                                    
T30169            AT.LAST_PYMT_AMOUNT,                                  
T25628            AT.TOTAL_AR_BALANCE,                                  
T25628            AT.DATE_BILL_DAY_00,                                  
T25628            AT.DATE_BILL_DAY_30,                                  
T25628            AT.DATE_BILL_DAY_60,                                  
T25628            AT.DATE_BILL_DAY_90,                                  
T25628            AT.BANKRUPTCY_IND,                                    
T25628            AT.CODE_DISC_OK,                                      
T25628            AT.NOTICE_EXEMPT_CD,                                  
T25628            AT.CODE_ACCT_STAT,                                    
T25628            AT.CREDIT_GROUP,                                      
T25628            AT.CODE_STATUS_REASON,                                
C28788            AT.IVR_EXEMPT_CD,                                     
T25628            FW.FINAL_BILL_AM,                                     
T25628            CZ.CR_BUR_RPT_DT                                      
T25628          FROM                                                    
T25628                CSS_ACCOUNT AT WITH(READUNCOMMITTED),                     
T25628                CSS_FINAL_WO FW WITH(READUNCOMMITTED),                    
T25628                CSS_CREDIT_PROFILE CZ WITH(READUNCOMMITTED)               
T25628          WHERE                                                   
T25628                AT.ACCOUNT_NO = CZ.ACCOUNT_NO                     
T25628            AND AT.ACCOUNT_NO = FW.ACCOUNT_NO                     
T25628            AND AT.COMPANY_NO = :WS-COMPANY-NUM                   
T25628            AND AT.CODE_ACCT_STAT = 'B'                           
T25628            AND AT.CODE_DISC_OK = ' '                             
T25628            AND AT.NOTICE_EXEMPT_CD IN (' ','1','2','3','4','5',  
T25628                                        '6','7','8','9','A','B')  
T25628            AND CZ.CR_BUR_RPT_DT  <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-LAST-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-RUN-DATE
              ) <> 0) OR (LEN(:WS-LAST-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-LAST-RUN-DATE
              ), CONVERT(DATE, :WS-LAST-RUN-DATE) )            
T25628            AND CZ.CR_BUR_RPT_DT IS NOT NULL                      
T20923            AND AT.BANKRUPTCY_IND = ' '                           
                FOR READ ONLY                                          
                                                                 
T25628     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE SUBSEQ_RPT_FB CURSOR FOR                                   
MFA-TR*         SELECT                                                          
MFA-TR*           AT.ACCOUNT_NO,                                                
MFA-TR*           AT.COMPANY_NO,                                                
MFA-TR*           AT.LOCAL_OFFICE,                                              
MFA-TR*           AT.PREMISE_NO,                                                
MFA-TR*           AT.CUSTOMER_NO,                                               
MFA-TR*           AT.ACCOUNT_TYPE_CODE,                                         
MFA-TR*           AT.ACCT_CREATE_DT,                                            
MFA-TR*           AT.ACCT_FINALED_DT,                                           
MFA-TR*           AT.ADDRESS_FORMAT,                                            
MFA-TR*           AT.ADDRESS_ID,                                                
MFA-TR*           AT.BILL_CYCLE,                                                
MFA-TR*           AT.CODES_DATA_PRESENT,                                        
MFA-TR*           AT.LAST_PYMT_DATE,                                            
MFA-TR*           AT.LAST_PYMT_AMOUNT,                                          
MFA-TR*           AT.TOTAL_AR_BALANCE,                                          
MFA-TR*           AT.DATE_BILL_DAY_00,                                          
MFA-TR*           AT.DATE_BILL_DAY_30,                                          
MFA-TR*           AT.DATE_BILL_DAY_60,                                          
MFA-TR*           AT.DATE_BILL_DAY_90,                                          
MFA-TR*           AT.BANKRUPTCY_IND,                                            
MFA-TR*           AT.CODE_DISC_OK,                                              
MFA-TR*           AT.NOTICE_EXEMPT_CD,                                          
MFA-TR*           AT.CODE_ACCT_STAT,                                            
MFA-TR*           AT.CREDIT_GROUP,                                              
MFA-TR*           AT.CODE_STATUS_REASON,                                        
MFA-TR*           AT.IVR_EXEMPT_CD,                                             
MFA-TR*           FW.FINAL_BILL_AM,                                             
MFA-TR*           CZ.CR_BUR_RPT_DT                                              
MFA-TR*         FROM                                                            
MFA-TR*               CSS_ACCOUNT AT,                                           
MFA-TR*               CSS_FINAL_WO FW,                                          
MFA-TR*               CSS_CREDIT_PROFILE CZ                                     
MFA-TR*         WHERE                                                           
MFA-TR*               AT.ACCOUNT_NO = CZ.ACCOUNT_NO                             
MFA-TR*           AND AT.ACCOUNT_NO = FW.ACCOUNT_NO                             
MFA-TR*           AND AT.COMPANY_NO = :WS-COMPANY-NUM                           
MFA-TR*           AND AT.CODE_ACCT_STAT = 'B'                                   
MFA-TR*           AND AT.CODE_DISC_OK = ' '                                     
MFA-TR*           AND AT.NOTICE_EXEMPT_CD IN (' ','1','2','3','4','5',          
MFA-TR*                                       '6','7','8','9','A','B')          
MFA-TR*           AND CZ.CR_BUR_RPT_DT  <= :WS-LAST-RUN-DATE                    
MFA-TR*           AND CZ.CR_BUR_RPT_DT IS NOT NULL                              
MFA-TR*           AND AT.BANKRUPTCY_IND = ' '                                   
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
PCR499     EXEC SQL                                                     
             DECLARE SUBSEQ_RPT_WO CURSOR FOR                           
                SELECT                                                  
                  AT.ACCOUNT_NO,                                        
                  AT.COMPANY_NO,                                        
                  AT.LOCAL_OFFICE,                                      
                  AT.PREMISE_NO,                                        
                  AT.CUSTOMER_NO,                                       
                  AT.ACCOUNT_TYPE_CODE,                                 
                  REPLACE(REPLACE(CONVERT(CHAR(26), AT.ACCT_CREATE_DT
           , 121), ' ', '-'), ':', '.') ACCT_CREATE_DT,                        
                  REPLACE(REPLACE(CONVERT(CHAR(26), AT.ACCT_FINALED_DT
           , 121), ' ', '-'), ':', '.') ACCT_FINALED_DT,                       
                  AT.ADDRESS_FORMAT,                                    
                  AT.ADDRESS_ID,                                        
                  AT.BILL_CYCLE,                                        
                  AT.CODES_DATA_PRESENT,                                
                  AT.LAST_PYMT_DATE,                                    
T30169            AT.LAST_PYMT_AMOUNT,                                  
                  AT.TOTAL_AR_BALANCE,                                  
                  AT.DATE_BILL_DAY_00,                                  
                  AT.DATE_BILL_DAY_30,                                  
                  AT.DATE_BILL_DAY_60,                                  
                  AT.DATE_BILL_DAY_90,                                  
T11937            AT.BANKRUPTCY_IND,                                    
                  AT.CODE_DISC_OK,                                      
                  AT.NOTICE_EXEMPT_CD,                                  
                  AT.CODE_ACCT_STAT,                                    
                  AT.CREDIT_GROUP,                                      
T13565            AT.CODE_STATUS_REASON,                                
C28788            AT.IVR_EXEMPT_CD,                                     
T25628            FW.FINAL_BILL_AM,                                     
T30169            KD.FW_ACTION_TYPE_CD,                                 
T30169            KD.FW_SEQ_NO,                                         
T30169            KD.FW_ACTION_DT,                                      
T30169            KD.FW_ACTION_AM,                                      
                  CZ.CR_BUR_RPT_DT                                      
                FROM                                                    
                      CSS_ACCOUNT AT WITH(READUNCOMMITTED),                     
                      CSS_CREDIT_PROFILE CZ WITH(READUNCOMMITTED),              
                      CSS_FINAL_WO FW WITH(READUNCOMMITTED),                    
T30169                CSS_FIN_WO_ACTION KD WITH(READUNCOMMITTED)                
                WHERE                                                   
                      AT.ACCOUNT_NO = CZ.ACCOUNT_NO                     
                  AND AT.ACCOUNT_NO = FW.ACCOUNT_NO                     
                  AND AT.ACCOUNT_NO = KD.ACCOUNT_NO                     
T23230            AND AT.COMPANY_NO = :WS-COMPANY-NUM                   
                  AND AT.CODE_ACCT_STAT = 'S'                           
                  AND CZ.CR_BUR_RPT_DT  <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-LAST-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-RUN-DATE
              ) <> 0) OR (LEN(:WS-LAST-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-LAST-RUN-DATE
              ), CONVERT(DATE, :WS-LAST-RUN-DATE) )            
                  AND CZ.CR_BUR_RPT_DT IS NOT NULL                      
T30169            AND KD.FW_ACTION_TYPE_CD = 'CREDB'                    
T30169            AND KD.FW_ACTION_DT > IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )                    
T20923            AND AT.BANKRUPTCY_IND = ' '                           
                FOR READ ONLY                                          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE SUBSEQ_RPT_WO CURSOR FOR                                   
MFA-TR*         SELECT                                                          
MFA-TR*           AT.ACCOUNT_NO,                                                
MFA-TR*           AT.COMPANY_NO,                                                
MFA-TR*           AT.LOCAL_OFFICE,                                              
MFA-TR*           AT.PREMISE_NO,                                                
MFA-TR*           AT.CUSTOMER_NO,                                               
MFA-TR*           AT.ACCOUNT_TYPE_CODE,                                         
MFA-TR*           AT.ACCT_CREATE_DT,                                            
MFA-TR*           AT.ACCT_FINALED_DT,                                           
MFA-TR*           AT.ADDRESS_FORMAT,                                            
MFA-TR*           AT.ADDRESS_ID,                                                
MFA-TR*           AT.BILL_CYCLE,                                                
MFA-TR*           AT.CODES_DATA_PRESENT,                                        
MFA-TR*           AT.LAST_PYMT_DATE,                                            
MFA-TR*           AT.LAST_PYMT_AMOUNT,                                          
MFA-TR*           AT.TOTAL_AR_BALANCE,                                          
MFA-TR*           AT.DATE_BILL_DAY_00,                                          
MFA-TR*           AT.DATE_BILL_DAY_30,                                          
MFA-TR*           AT.DATE_BILL_DAY_60,                                          
MFA-TR*           AT.DATE_BILL_DAY_90,                                          
MFA-TR*           AT.BANKRUPTCY_IND,                                            
MFA-TR*           AT.CODE_DISC_OK,                                              
MFA-TR*           AT.NOTICE_EXEMPT_CD,                                          
MFA-TR*           AT.CODE_ACCT_STAT,                                            
MFA-TR*           AT.CREDIT_GROUP,                                              
MFA-TR*           AT.CODE_STATUS_REASON,                                        
MFA-TR*           AT.IVR_EXEMPT_CD,                                             
MFA-TR*           FW.FINAL_BILL_AM,                                             
MFA-TR*           KD.FW_ACTION_TYPE_CD,                                         
MFA-TR*           KD.FW_SEQ_NO,                                                 
MFA-TR*           KD.FW_ACTION_DT,                                              
MFA-TR*           KD.FW_ACTION_AM,                                              
MFA-TR*           CZ.CR_BUR_RPT_DT                                              
MFA-TR*         FROM                                                            
MFA-TR*               CSS_ACCOUNT AT,                                           
MFA-TR*               CSS_CREDIT_PROFILE CZ,                                    
MFA-TR*               CSS_FINAL_WO FW,                                          
MFA-TR*               CSS_FIN_WO_ACTION KD                                      
MFA-TR*         WHERE                                                           
MFA-TR*               AT.ACCOUNT_NO = CZ.ACCOUNT_NO                             
MFA-TR*           AND AT.ACCOUNT_NO = FW.ACCOUNT_NO                             
MFA-TR*           AND AT.ACCOUNT_NO = KD.ACCOUNT_NO                             
MFA-TR*           AND AT.COMPANY_NO = :WS-COMPANY-NUM                           
MFA-TR*           AND AT.CODE_ACCT_STAT = 'S'                                   
MFA-TR*           AND CZ.CR_BUR_RPT_DT  <= :WS-LAST-RUN-DATE                    
MFA-TR*           AND CZ.CR_BUR_RPT_DT IS NOT NULL                              
MFA-TR*           AND KD.FW_ACTION_TYPE_CD = 'CREDB'                            
MFA-TR*           AND KD.FW_ACTION_DT > '1900-01-01'                            
MFA-TR*           AND AT.BANKRUPTCY_IND = ' '                                   
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
T30169     EXEC SQL                                                     
T30169       DECLARE SUBSEQ_COLL_AGY_CUR CURSOR FOR                     
                SELECT                                                  
                      KD.FW_ACTION_TYPE_CD,                             
                      KD.FW_SEQ_NO,                                     
                      KD.FW_ACTION_DT,                                  
                      KD.FW_ACTION_AM,                                  
                      IZ.CODE_COLLEC_AGNCY,                             
                      IZ.COLL_AGY_SUB_CD,                               
                      AT.ACCOUNT_NO,                                    
                      AT.COMPANY_NO,                                    
                      AT.LOCAL_OFFICE,                                  
                      AT.PREMISE_NO,                                    
                      AT.CUSTOMER_NO,                                   
                      AT.ACCOUNT_TYPE_CODE,                             
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           AT.ACCT_CREATE_DT, 121), ' ', '-'), ':', '.') 
           ACCT_CREATE_DT,                                
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           AT.ACCT_FINALED_DT, 121), ' ', '-'), ':', '.') 
           ACCT_FINALED_DT,                               
                      AT.ADDRESS_FORMAT,                                
                      AT.ADDRESS_ID,                                    
                      AT.BILL_CYCLE,                                    
                      AT.CODES_DATA_PRESENT,                            
                      AT.LAST_PYMT_DATE,                                
T30169                AT.LAST_PYMT_AMOUNT,                              
                      AT.TOTAL_AR_BALANCE,                              
                      AT.DATE_BILL_DAY_00,                              
                      AT.DATE_BILL_DAY_30,                              
                      AT.DATE_BILL_DAY_60,                              
                      AT.DATE_BILL_DAY_90,                              
                      AT.BANKRUPTCY_IND,                                
                      AT.CODE_DISC_OK,                                  
                      AT.NOTICE_EXEMPT_CD,                              
                      AT.CODE_ACCT_STAT,                                
                      AT.CREDIT_GROUP,                                  
                      AT.CODE_STATUS_REASON,                            
                      AT.IVR_EXEMPT_CD                                  
                FROM                                                    
                      CSS_FIN_WO_ACTION  KD WITH(READUNCOMMITTED),              
                      CSS_ACCOUNT        AT WITH(READUNCOMMITTED),              
                      CSS_FIN_WO_COLLECT IZ WITH(READUNCOMMITTED)               
                WHERE                                                   
                      KD.ACCOUNT_NO        = AT.ACCOUNT_NO              
                  AND AT.CODE_ACCT_STAT    = 'S'                        
                  AND AT.COMPANY_NO        = :WS-COMPANY-NUM            
                  AND IZ.ACCOUNT_NO        = KD.ACCOUNT_NO              
                  AND IZ.FW_COLL_SEQ_NO    = KD.FW_SEQ_NO               
                  AND IZ.FW_ACTION_TYPE_CD = KD.FW_ACTION_TYPE_CD       
                  AND KD.FW_ACTION_DT     <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-LAST-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-RUN-DATE
              ) <> 0) OR (LEN(:WS-LAST-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-LAST-RUN-DATE
              ), CONVERT(DATE, :WS-LAST-RUN-DATE) )          
                  AND KD.FW_ACTION_AM > 0                               
                  AND (( IZ.WITHDRAW_DT    > IIF(TRY_CONVERT(DATE, 
                                                      :WS-LAST-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-RUN-DATE
              ) <> 0) OR (LEN(:WS-LAST-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-LAST-RUN-DATE
              ), CONVERT(DATE, :WS-LAST-RUN-DATE) )          
                      OR IZ.WITHDRAW_DT    IS NULL )                    
                     AND IZ.WITHDRAW_AM    = 0 )                        
                  AND KD.FW_ACTION_TYPE_CD                              
                       IN ('1PLMT','2PLMT','3PLMT','ATY')               
A01823          FOR READ ONLY                                          
A01823                                                           
T30169     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE SUBSEQ_COLL_AGY_CUR CURSOR FOR                             
MFA-TR*         SELECT                                                          
MFA-TR*               KD.FW_ACTION_TYPE_CD,                                     
MFA-TR*               KD.FW_SEQ_NO,                                             
MFA-TR*               KD.FW_ACTION_DT,                                          
MFA-TR*               KD.FW_ACTION_AM,                                          
MFA-TR*               IZ.CODE_COLLEC_AGNCY,                                     
MFA-TR*               IZ.COLL_AGY_SUB_CD,                                       
MFA-TR*               AT.ACCOUNT_NO,                                            
MFA-TR*               AT.COMPANY_NO,                                            
MFA-TR*               AT.LOCAL_OFFICE,                                          
MFA-TR*               AT.PREMISE_NO,                                            
MFA-TR*               AT.CUSTOMER_NO,                                           
MFA-TR*               AT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               AT.ACCT_CREATE_DT,                                        
MFA-TR*               AT.ACCT_FINALED_DT,                                       
MFA-TR*               AT.ADDRESS_FORMAT,                                        
MFA-TR*               AT.ADDRESS_ID,                                            
MFA-TR*               AT.BILL_CYCLE,                                            
MFA-TR*               AT.CODES_DATA_PRESENT,                                    
MFA-TR*               AT.LAST_PYMT_DATE,                                        
MFA-TR*               AT.LAST_PYMT_AMOUNT,                                      
MFA-TR*               AT.TOTAL_AR_BALANCE,                                      
MFA-TR*               AT.DATE_BILL_DAY_00,                                      
MFA-TR*               AT.DATE_BILL_DAY_30,                                      
MFA-TR*               AT.DATE_BILL_DAY_60,                                      
MFA-TR*               AT.DATE_BILL_DAY_90,                                      
MFA-TR*               AT.BANKRUPTCY_IND,                                        
MFA-TR*               AT.CODE_DISC_OK,                                          
MFA-TR*               AT.NOTICE_EXEMPT_CD,                                      
MFA-TR*               AT.CODE_ACCT_STAT,                                        
MFA-TR*               AT.CREDIT_GROUP,                                          
MFA-TR*               AT.CODE_STATUS_REASON,                                    
MFA-TR*               AT.IVR_EXEMPT_CD                                          
MFA-TR*         FROM                                                            
MFA-TR*               CSS_FIN_WO_ACTION  KD,                                    
MFA-TR*               CSS_ACCOUNT        AT,                                    
MFA-TR*               CSS_FIN_WO_COLLECT IZ                                     
MFA-TR*         WHERE                                                           
MFA-TR*               KD.ACCOUNT_NO        = AT.ACCOUNT_NO                      
MFA-TR*           AND AT.CODE_ACCT_STAT    = 'S'                                
MFA-TR*           AND AT.COMPANY_NO        = :WS-COMPANY-NUM                    
MFA-TR*           AND IZ.ACCOUNT_NO        = KD.ACCOUNT_NO                      
MFA-TR*           AND IZ.FW_COLL_SEQ_NO    = KD.FW_SEQ_NO                       
MFA-TR*           AND IZ.FW_ACTION_TYPE_CD = KD.FW_ACTION_TYPE_CD               
MFA-TR*           AND KD.FW_ACTION_DT     <= :WS-LAST-RUN-DATE                  
MFA-TR*           AND KD.FW_ACTION_AM > 0                                       
MFA-TR*           AND (( IZ.WITHDRAW_DT    > :WS-LAST-RUN-DATE                  
MFA-TR*               OR IZ.WITHDRAW_DT    IS NULL )                            
MFA-TR*              AND IZ.WITHDRAW_AM    = 0 )                                
MFA-TR*           AND KD.FW_ACTION_TYPE_CD                                      
MFA-TR*                IN ('1PLMT','2PLMT','3PLMT','ATY')                       
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
T30169     EXEC SQL                                                     
T30169       DECLARE TRNHST_CURSOR CURSOR FOR                           
             SELECT                                                     
                  AR.AMT_ORIG_ENTERED                                   
                 ,AR.CODE_TRAN_TYPE                                     
                 ,AU.GL_ACCT_CREDIT                                     
                 ,AU.GL_ACCT_DEBIT                                      
             FROM                                                       
                  CSS_AR_TRANS_HIST  AR WITH(READUNCOMMITTED)                   
                 ,CSS_AR_TRN_HST_DET AU WITH(READUNCOMMITTED)                   
             WHERE                                                      
                 AR.ACCOUNT_NO        = :AR-ACCOUNT-NO                  
             AND AR.ACCOUNT_NO        = AU.ACCOUNT_NO                   
             AND AR.TRANS_HIST_SEQ_NO = AU.TRANS_HIST_SEQ_NO            
             AND AR.CODE_TRAN_TYPE IN ('I','T','S','R','P')             
             AND AR.DATE_TRANS     >  IIF(TRY_CONVERT(DATE, 
                                                      :WS-LAST-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-RUN-DATE
              ) <> 0) OR (LEN(:WS-LAST-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-LAST-RUN-DATE
              ), CONVERT(DATE, :WS-LAST-RUN-DATE) )                 
             AND AR.DATE_TRANS     <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-PROGRAM-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PROGRAM-DATE
              ) <> 0) OR (LEN(:WS-PROGRAM-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-PROGRAM-DATE
              ), CONVERT(DATE, :WS-PROGRAM-DATE) )                  
             AND AR.RECORD_ONLY_FL <> 'Y'                               
             ORDER BY AR.TRANS_HIST_SEQ_NO DESC                         
             FOR READ ONLY                                      
T30169     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE TRNHST_CURSOR CURSOR FOR                                   
MFA-TR*      SELECT                                                             
MFA-TR*           AR.AMT_ORIG_ENTERED                                           
MFA-TR*          ,AR.CODE_TRAN_TYPE                                             
MFA-TR*          ,AU.GL_ACCT_CREDIT                                             
MFA-TR*          ,AU.GL_ACCT_DEBIT                                              
MFA-TR*      FROM                                                               
MFA-TR*           CSS_AR_TRANS_HIST  AR                                         
MFA-TR*          ,CSS_AR_TRN_HST_DET AU                                         
MFA-TR*      WHERE                                                              
MFA-TR*          AR.ACCOUNT_NO        = :AR-ACCOUNT-NO                          
MFA-TR*      AND AR.ACCOUNT_NO        = AU.ACCOUNT_NO                           
MFA-TR*      AND AR.TRANS_HIST_SEQ_NO = AU.TRANS_HIST_SEQ_NO                    
MFA-TR*      AND AR.CODE_TRAN_TYPE IN ('I','T','S','R','P')                     
MFA-TR*      AND AR.DATE_TRANS     >  :WS-LAST-RUN-DATE                         
MFA-TR*      AND AR.DATE_TRANS     <= :WS-PROGRAM-DATE                          
MFA-TR*      AND AR.RECORD_ONLY_FL <> 'Y'                                       
MFA-TR*      ORDER BY AR.TRANS_HIST_SEQ_NO DESC                                 
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
T22307*                                                                         
T22307  01  WS-PARM-VALUE.                                              
T22307      03  WS-PARMVAL-LENGTH                 PIC S9(04) COMP.      
T22307      03  WS-PARMVAL                        PIC X(04).            
T22307*                                                                         
      *                                                                 PCS11150
T22307 PROCEDURE DIVISION USING WS-PARM-VALUE.                          
      *                                                                         
      ******************************************************************PCS11170
      *                                                                *PCS11180
      *     0000-MAINLINE                                              *PCS11190
      *                                                                *PCS11200
      *     CONTROLS THE MAIN PROCESSING PATH OF THE PROGRAM           *PCS11210
      *                                                                *PCS11220
      ******************************************************************PCS11230
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
      *                                                                 PCS11320
T30169     PERFORM 1000-WO-TO-COLL-AGENCY-CREDB  THRU 1000-EXIT         
           PERFORM 3000-ACT-NON-UTIL-TO-CRED-BUR THRU 3000-EXIT         
PCR499     PERFORM 3500-PROCESS-SUBSEQ-RPT-N-UTL THRU 3500-EXIT         
PCR499     PERFORM 3700-PROCESS-SUBSEQ-RPT-WO    THRU 3700-EXIT         
T25628     PERFORM 3900-PROCESS-SUBSEQ-RPT-FB    THRU 3900-EXIT         
T30169     PERFORM 3950-PROCESS-SUBSEQ-COLL-AGY  THRU 3950-EXIT         
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS11880
      *                                                                *PCS11890
      *     0100-INITIALIZATION                                        *PCS11900
      *                                                                *PCS11910
      *     COMMON INITIALIZATION ROUTINE (ALSO INITIALIZES GS DATA-   *PCS11920
      *     BASE FOR MONTHLY DELINQUENT STATISTICS)                    *PCS11930
      *                                                                *PCS11940
      ******************************************************************PCS11950
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
T30405     OPEN OUTPUT FCSCA226-FILE.                                   
           IF FCA226-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '**  PCSCA226 PROCESSING ERROR             **'   
               DISPLAY '**    OPEN ERROR OF FCSCA226 - OUTPUT FILE'     
               DISPLAY '**    FILE STATUS = ' WS-FCA226-STATUS          
               DISPLAY '**  PROCESSING TERMINATED                 **'   
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
T30169     OPEN OUTPUT FCSCA227-FILE.                                   
T30169     IF FCA227-SUCCESSFUL                                         
T30169         NEXT SENTENCE                                            
T30169     ELSE                                                         
T30169         DISPLAY ' '                                              
T30169         DISPLAY '**  PCSCA226 PROCESSING ERROR             **'   
T30169         DISPLAY '**    OPEN ERROR OF FCSCA227 - OUTPUT FILE'     
T30169         DISPLAY '**    FILE STATUS = ' WS-FCA227-STATUS          
T30169         DISPLAY '**  PROCESSING TERMINATED                 **'   
T30169         PERFORM 9900-ABEND THRU 9900-EXIT                        
T30169     END-IF.                                                      
      *                                                                         
T22307     PERFORM 0170-VALIDATE-PARM         THRU 0170-EXIT.           
           PERFORM 0110-GET-PGM-RUN-DATE      THRU 0110-EXIT.           
           PERFORM 0120-GET-LAST-PGM-RUN-DATE THRU 0120-EXIT.           
           PERFORM 0150-WRITE-BEGIN-CONTROLS  THRU 0150-EXIT.           
T30169     PERFORM 0160-WRITE-BEGIN-REC-CA227 THRU 0160-EXIT.           
                                                                        
T30169     MOVE WS-COMPANY-NUM                TO C8-COMPANY-NO.         
T30169     MOVE 'WO-CA-RANDOM-SW'             TO C8-DELINQ-CD.          
T30169     PERFORM 7580-SELECT-DELINQ-VALUE   THRU 7580-EXIT.           
T30169     MOVE C8-DELINQ-VALUE               TO WS-CA-RANDOM-DELINQ.   
      *                                                                         
T30169     MOVE WS-COMPANY-NUM                TO C8-COMPANY-NO.         
T30169     MOVE 'AMT-COLLECTLIMIT'            TO C8-DELINQ-CD.          
T30169     PERFORM 7580-SELECT-DELINQ-VALUE   THRU 7580-EXIT.           
T30169     MOVE C8-DELINQ-VALUE               TO WS-CA-LIMIT-DELINQ.    
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS11880
      *                                                                *PCS11890
      *     0110-GET-PGM-RUN-DATE.                                     *PCS11900
      *                                                                *PCS11910
      *     MODULE RETRIEVES THE RUN DATE.                             *PCS11920
      *                                                                *PCS11940
      ******************************************************************PCS11950
       0110-GET-PGM-RUN-DATE.                                           
      *                                                                         
           MOVE 'PCSCA206' TO WS-PGRMNAME.                              
           PERFORM 6251-GET-FJC01-DATE        THRU 6251-EXIT.           
           IF COMMON-DATE-NEEDED                                        
               PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT        
               DISPLAY ' '                                              
               DISPLAY '************PCSCA226**************'             
               DISPLAY '* COMMON DATE BEING USED         *'             
               DISPLAY '* DATE IS ', WS-FCA00-COMMON-DATE               
               DISPLAY '* PROCESSING CONTINUES...        *'             
               DISPLAY '************PCSCA226**************'             
               DISPLAY ' '                                              
               MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE               
           END-IF                                                       
           MOVE WS-INPUT-DATE            TO WS-PROGRAM-DATE.            
           MOVE 'PCSCA226'               TO WS-PGRMNAME.                
      *                                                                         
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS11880
      *                                                                *PCS11890
      *     0120-GET-LAST-PGM-RUN-DATE.                                *PCS11900
      *                                                                *PCS11910
      *     MODULE RETRIEVES THE DATE OF THE LAST RUN OF PCSCA226.     *PCS11920
      *                                                                *PCS11940
      ******************************************************************PCS11950
       0120-GET-LAST-PGM-RUN-DATE.                                      
      *                                                                         
           MOVE 'PCSCA206'     TO PROGRAM-NAME.                         
           MOVE SPACES         TO WS-SYSIPT.                            
           MOVE WS-PARM        TO WS-COMMAND.                           
           MOVE PROGRAM-NAME   TO WS-PROGRAM.                           
T23230     MOVE WS-COMPANY-NUM TO G6-COMPANY-NO.                        
T26954     EVALUATE TRUE                                                
T26954         WHEN SCEG                                                
T26954             MOVE +10           TO G6-SEQ-NO                      
T26954         WHEN PSNC                                                
T26954             MOVE +10           TO G6-SEQ-NO                      
T26954         WHEN SEB                                                 
T26954             MOVE +10           TO G6-SEQ-NO                      
T26954     END-EVALUATE.                                                
      *                                                                         
           PERFORM 7600-START-FCSJC01                THRU 7600-EXIT.    
      *                                                                         
T25628     EXEC SQL                                                     
T25628        SELECT  PARM_DATA                                         
T25628                INTO                                              
T25628                :WS-INPUT-DATA-BREAKDOWN                          
T25628        FROM    CSS_JOB_PARM                                      
T25628        WHERE   PROGRAM_NAME   = :G6-PROGRAM-NAME                 
T25628          AND   CMND_CODE      = :G6-CMND-CODE                    
T25628          AND   COMPANY_NO     = :G6-COMPANY-NO                   
T25628          AND   SEQ_NO         = :G6-SEQ-NO                       
T25628     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF END-OF-SYSIPT                                             
               DISPLAY ' '                                              
               DISPLAY '**  PCSCA226 PROCESSING ERROR             **'   
               DISPLAY '**   LAST RUN DATE NOT FOUND IN CSS_JOB_PARM'   
               DISPLAY '**   FOR PROGRAM SERIES PCSCA206.********   '   
               DISPLAY '**  PROCESSING TERMINATED                 **'   
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           ELSE                                                         
               IF    WS-L-RUN-DATE-MM  NUMERIC                          
                 AND WS-L-RUN-DATE-DD  NUMERIC                          
                 AND WS-L-RUN-DATE-CC  NUMERIC                          
                 AND WS-L-RUN-DATE-YY  NUMERIC                          
                   MOVE WS-L-RUN-DATE TO WS-LAST-RUN-DATE               
                                         EL-EXCH-REPORT-DT              
                   PERFORM 7611-CLOSE THRU 7611-EXIT                    
               END-IF                                                   
           END-IF.                                                      
           MOVE 'PCSCA226'     TO PROGRAM-NAME.                         
      *                                                                         
       0120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS11880
      *                                                                *PCS11890
      *     0150-WRITE-BEGIN-CONTROLS.                                 *PCS11900
      *                                                                *PCS11910
      *     MODULE WRITES THE HEADER FOR EACH OUTPUT FILE.             *PCS11920
      *                                                                *PCS11940
      ******************************************************************PCS11950
      *                                                                         
       0150-WRITE-BEGIN-CONTROLS.                                       
      *                                                                         
           INITIALIZE FIOCA226.                                         
           MOVE LOW-VALUES     TO E-FCA226-HEADER-REC-TYPE.             
           MOVE WS-COMPANY-NUM TO E-FCA226-HEADER-CO-NO.                
           MOVE WS-PARMVAL     TO E-FCA226-HEADER-CO-NAME.              
           MOVE WS-INPUT-DATE  TO E-FCA226-DATE-CREATED.                
           PERFORM 8500-WRITE-FCA226-RECORD THRU 8500-EXIT.             
      *                                                                         
       0150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS11880
      *                                                                *PCS11890
      *     0160-WRITE-BEGIN-REC-CA227.                                *PCS11900
      *                                                                *PCS11910
      *     MODULE WRITES THE HEADER FOR EACH OUTPUT FILE.             *PCS11920
      *                                                                *PCS11940
      ******************************************************************PCS11950
      *                                                                         
T30169 0160-WRITE-BEGIN-REC-CA227.                                      
      *                                                                         
           INITIALIZE FIOCA227.                                         
           MOVE LOW-VALUES     TO E-FCA227-HEADER-REC-TYPE.             
           MOVE WS-COMPANY-NUM TO E-FCA227-HEADER-CO-NO.                
           MOVE WS-PARMVAL     TO E-FCA227-HEADER-CO-NAME.              
           MOVE WS-INPUT-DATE  TO E-FCA227-DATE-CREATED.                
           PERFORM 8550-WRITE-FCA227-RECORD THRU 8550-EXIT.             
      *                                                                         
T30169 0160-EXIT.                                                       
T30169     EXIT.                                                        
      *                                                                         
      ******************************************************************PCS13800
      *                                                                *PCS13810
T22307*     0170-VALIDATE-PARM                                         *PCS13820
T22307*                                                                *PCS13830
T22307******************************************************************PCS13950
T22307*                                                                         
T22307 0170-VALIDATE-PARM.                                              
T22307*                                                                         
T22307     IF  WS-PARMVAL-LENGTH = ZERO                                 
T22307         DISPLAY '************* PCSCA226 *******************'     
T22307         DISPLAY '* NO PARM VALUE FOUND                    *'     
T23230         DISPLAY '* VALID PARM VALUES ARE ''SCEG'', '' PSNC''  *' 
T23230         DISPLAY '* OR ''SEB'' *'                                 
T22307         DISPLAY '************* PCSCA226 *******************'     
T22307         PERFORM 9900-ABEND                   THRU 9900-EXIT      
T22307     END-IF.                                                      
T22307     INSPECT WS-PARMVAL REPLACING ALL LOW-VALUES BY SPACES.       
T22307     MOVE WS-PARMVAL TO E-FCA226-HEADER-CO-NAME.                  
T23230     MOVE '01' TO WS-COMPANY-NUM.                                 
T22307     EVALUATE WS-PARMVAL                                          
T22307         WHEN 'SCEG'                                              
T22307             SET SCEG    TO TRUE                                  
T22307         WHEN 'SEB '                                              
T22307             SET SEB     TO TRUE                                  
T22307         WHEN 'SEB'                                               
T22307             MOVE 'SEB ' TO E-FCA226-HEADER-CO-NAME               
T22307             SET SEB     TO TRUE                                  
T22307         WHEN 'PSNC'                                              
T23230             SET PSNC    TO TRUE                                  
T23230             MOVE '26'   TO WS-COMPANY-NUM                        
T26954         WHEN OTHER                                               
T22307             DISPLAY '************* PCSCA226 *******************' 
T22307             DISPLAY '* NOT A VALID PARM.                      *' 
T23230             DISPLAY '* VALID PARM VALUES ARE ''SCEG'', ''PSNC''*'
T23230             DISPLAY '* OR ''SEB'' *'                             
T22307             DISPLAY '************* PCSCA226 *******************' 
T22307             PERFORM 9900-ABEND                 THRU 9900-EXIT    
T22307     END-EVALUATE.                                                
T22307*                                                                         
T22307 0170-EXIT.                                                       
T22307     EXIT.                                                        
      *                                                                         
      ******************************************************************PCS13800
      *                                                                *PCS13810
      * 1000-WO-TO-COLL-AGENCY-CREDB                                   *PCS13820
      *                                                                *PCS13830
      * THIS MODULE OPENS A CURSOR TO EXTRACT FROM CSS_FIN_WO_ACTION   *        
      * ALL ACCOUNTS WITH A ACTION DATE BETWEEN TODAY'S RUN DATE       *        
      * (INCLUSIVE) AND THE LAST RUN DATE OF THIS PROGRAM (NOT         *        
      * INCLUSIVE). EACH ACCOUNT IS SENT FOR FURTHER PROCESSING TO     *        
      * DECIDE WHETHER THE ACCOUNT SHOULD STILL BE SENT TO THE         *        
      * COLLECTION AGENCY OR CRED BUREAU                               *        
      *                                                                *        
      ******************************************************************PCS13950
      *                                                                         
T30169 1000-WO-TO-COLL-AGENCY-CREDB.                                    
      *                                                                         
           PERFORM 7300-OPEN-FW-COLL-CREDB-ACCTS    THRU 7300-EXIT.     
           PERFORM 7310-FETCH-FW-COLL-CREDB-ACCTS   THRU 7310-EXIT.     
                                                                        
           PERFORM UNTIL SQLCODE EQUAL NOT-FOUND                        
                                                                        
               PERFORM 2200-GET-WO-CREDB-LTR-LPC    THRU 2200-EXIT      
                                                                        
               IF KD-FW-ACTION-TYPE-CD = '1PLMT' OR '2PLMT' OR '3PLMT'  
                                        OR 'ATY' OR 'SAL' THEN          
                                                                        
                 PERFORM 2400-GET-WRITE-OFF-BALANCE    THRU 2400-EXIT   
                                                                        
                 IF WS-WRITE-OFF-BALANCE > WS-CA-LIMIT-DELINQ THEN      
                                                                        
                   PERFORM 2300-GET-COLL-AGENCY-DETAILS  THRU 2300-EXIT 
                   PERFORM 1020-CHECK-PREV-ASGNMT        THRU 1020-EXIT 
                   PERFORM 1050-CHECK-TO-BYPASS-CA277    THRU 1050-EXIT 
                                                                        
                   IF WS-CODE-COLLEC-AGNCY = SPACES AND CONTINUE-CA277  
                                                                        
                      PERFORM 1040-CHECK-EXCLUSIONS      THRU 1040-EXIT 
                                                                        
                      IF WRITE-TO-CA226                                 
                         PERFORM 1005-PROCESS-COLLECT-ACCT              
                                                        THRU 1005-EXIT  
                         PERFORM 8500-WRITE-FCA226-RECORD               
                                                        THRU 8500-EXIT  
                      ELSE                                              
                         PERFORM 1010-PROCESS-COLL-ACC-227              
                                                        THRU 1010-EXIT  
                         PERFORM 2500-PROCESS-SUMMARY-227               
                                                        THRU 2500-EXIT  
                         PERFORM 8550-WRITE-FCA227-RECORD               
                                                        THRU 8550-EXIT  
                      END-IF                                            
                   ELSE                                                 
                      PERFORM 1005-PROCESS-COLLECT-ACCT  THRU 1005-EXIT 
                      PERFORM 8500-WRITE-FCA226-RECORD   THRU 8500-EXIT 
                   END-IF                                               
                 END-IF                                                 
                                                                        
               ELSE                                                     
                                                                        
                  PERFORM 7400-GET-CZ-CR-BUR-DT         THRU 7400-EXIT  
                                                                        
                  IF WS-CZ-CR-BUR-RPT-DT = SPACES AND                   
                     AT-BANKRUPTCY-IND = SPACES THEN                    
                                                                        
                     PERFORM 2100-PROCESS-CRED-BUR-ACCT THRU 2100-EXIT  
                     PERFORM 8500-WRITE-FCA226-RECORD   THRU 8500-EXIT  
                                                                        
                  END-IF                                                
               END-IF                                                   
                                                                        
               PERFORM 7310-FETCH-FW-COLL-CREDB-ACCTS THRU 7310-EXIT    
           END-PERFORM.                                                 
                                                                        
           PERFORM 7320-CLOSE-FW-COLL-CREDB-ACCTS   THRU 7320-EXIT.     
           PERFORM 1030-PROCESS-COLL-AGNCY-SMRY     THRU 1030-EXIT.     
      *                                                                         
T30169 1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS13800
      *                                                                *PCS13810
      * 1005-PROCESS-COLLECT-ACCT                                      *PCS13820
      *                                                                *PCS13830
      * THIS MODULE EXTRACTS ACCOUNT INFO FOR THE ACCOUNT AND          *        
      * WRITES THE FILE TO AN EXTRACT FILE.                            *        
      *                                                                *        
      ******************************************************************PCS13950
      *                                                                         
       1005-PROCESS-COLLECT-ACCT.                                       
      *                                                                         
           PERFORM 4000-LOAD-FIOCA226 THRU 4000-EXIT.                   
      *                                                                         
           MOVE '1000'                TO E-FCA226-DATA-REC-TYPE.        
           MOVE AT-TOTAL-AR-BALANCE   TO E-FCA226-TOTAL-AR-BALANCE.     
           MOVE AT-ACCT-FINALED-DT    TO E-FCA226-ACCT-FINALED-DT.      
           MOVE AT-BILL-CYCLE         TO E-FCA226-BILL-CYCLE.           
           MOVE AT-CODES-DATA-PRESENT TO E-FCA226-CODES-DATA-PRESENT.   
           MOVE AT-BANKRUPTCY-IND     TO E-FCA226-BANKRUPTCY-IND.       
           MOVE AT-CODE-DISC-OK       TO E-FCA226-CODE-DISC-OK.         
           MOVE AT-NOTICE-EXEMPT-CD   TO E-FCA226-NOTICE-EXEMPT-CD.     
           MOVE AT-JUDGEMENT-IND      TO E-FCA226-JUDGEMENT-IND.        
T30169     MOVE WS-WRITE-OFF-DT       TO E-FCA226-WRITE-OFF-DT.         
T30169     MOVE WS-WRITE-OFF-AM       TO E-FCA226-WRITE-OFF-AM.         
T30169     MOVE WS-FIRST-CR-LTR-AM    TO E-FCA226-FIRST-CR-LTR-AM.      
T30169     MOVE WS-FIRST-CR-LTR-DT    TO E-FCA226-FIRST-CR-LTR-DT.      
T30169     MOVE KD-FW-ACTION-DT       TO E-FCA226-COLLECTION-DT.        
T30169     MOVE WS-CR-BUR-RPT-DT      TO E-FCA226-CR-BUR-RPT-DT-FW.     
           MOVE SPACES                TO E-FCA226-LPC-ASSESS-DT.        
           MOVE SPACES                TO E-FCA226-CR-BUR-RPT-DT-CZ.     
           MOVE ZEROES                TO E-FCA226-FINAL-BILL-AM.        
           MOVE ZEROES                TO E-FCA226-CR-BUR-RPT-AM-FW.     
T30169     MOVE KD-FW-ACTION-TYPE-CD  TO E-FCA226-ACTION-TYPE-CD.       
T30169     MOVE KD-FW-SEQ-NO          TO E-FCA226-ACTION-SEQ-NO.        
T30169     MOVE WS-CODE-COLLEC-AGNCY  TO E-FCA226-CODE-COLLEC-AGNCY.    
T30169     MOVE WS-COLL-AGY-SUB-CD    TO E-FCA226-COLL-AGY-SUB-CD.      
T30169     MOVE WS-WRITE-OFF-BALANCE  TO E-FCA226-WRITE-OFF-BALANCE.    
      *                                                                         
       1005-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS13800
      *                                                                *PCS13810
      * 1010-PROCESS-COLLECT-ACCT                                      *PCS13820
      *                                                                *PCS13830
      * THIS MODULE EXTRACTS ACCOUNT INFO FOR THE ACCOUNT AND          *        
      * WRITES THE FILE TO AN EXTRACT FILE.                            *        
      *                                                                *        
      ******************************************************************PCS13950
      *                                                                         
T30169 1010-PROCESS-COLL-ACC-227.                                       
      *                                                                         
           PERFORM 4100-LOAD-FIOCA227 THRU 4100-EXIT.                   
      *                                                                         
           MOVE '1000'                TO E-FCA227-DATA-REC-TYPE.        
           MOVE 'D'                   TO E-FCA227-RECORD-TYPE.          
           MOVE AT-TOTAL-AR-BALANCE   TO E-FCA227-TOTAL-AR-BALANCE.     
           MOVE AT-ACCT-FINALED-DT    TO E-FCA227-ACCT-FINALED-DT.      
           MOVE AT-BILL-CYCLE         TO E-FCA227-BILL-CYCLE.           
           MOVE AT-CODES-DATA-PRESENT TO E-FCA227-CODES-DATA-PRESENT.   
           MOVE AT-BANKRUPTCY-IND     TO E-FCA227-BANKRUPTCY-IND.       
           MOVE AT-CODE-DISC-OK       TO E-FCA227-CODE-DISC-OK.         
           MOVE AT-NOTICE-EXEMPT-CD   TO E-FCA227-NOTICE-EXEMPT-CD.     
           MOVE AT-JUDGEMENT-IND      TO E-FCA227-JUDGEMENT-IND.        
           MOVE WS-WRITE-OFF-DT       TO E-FCA227-WRITE-OFF-DT.         
           MOVE WS-WRITE-OFF-AM       TO E-FCA227-WRITE-OFF-AM.         
           MOVE WS-FIRST-CR-LTR-AM    TO E-FCA227-FIRST-CR-LTR-AM.      
           MOVE WS-FIRST-CR-LTR-DT    TO E-FCA227-FIRST-CR-LTR-DT.      
           MOVE KD-FW-ACTION-DT       TO E-FCA227-COLLECTION-DT.        
           MOVE WS-CR-BUR-RPT-DT      TO E-FCA227-CR-BUR-RPT-DT-FW.     
           MOVE SPACES                TO E-FCA227-LPC-ASSESS-DT.        
           MOVE SPACES                TO E-FCA227-CR-BUR-RPT-DT-CZ.     
           MOVE ZEROES                TO E-FCA227-FINAL-BILL-AM.        
           MOVE ZEROES                TO E-FCA227-CR-BUR-RPT-AM-FW.     
           MOVE KD-FW-ACTION-TYPE-CD  TO E-FCA227-ACTION-TYPE-CD.       
           MOVE KD-FW-SEQ-NO          TO E-FCA227-ACTION-SEQ-NO.        
           MOVE WS-CODE-COLLEC-AGNCY  TO E-FCA227-CODE-COLLEC-AGNCY.    
           MOVE WS-COLL-AGY-SUB-CD    TO E-FCA227-COLL-AGY-SUB-CD.      
           MOVE WS-WRITE-OFF-BALANCE  TO E-FCA227-WRITE-OFF-BALANCE.    
      *                                                                         
T30169 1010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS13800
      *                                                                *PCS13810
      * 1020-CHECK-PREV-ASGNMT                                         *PCS13820
      *                                                                *PCS13830
      * THIS MODULE CHECKS THE ACCOUNT HAS ANY PREVIOUS AGENCY ASSIGNMT*        
      *                                                                *        
      ******************************************************************PCS13950
      *                                                                         
T30169 1020-CHECK-PREV-ASGNMT.                                          
      *                                                                         
           IF WS-CODE-COLLEC-AGNCY = SPACES THEN                        
                                                                        
              MOVE AT-ACCOUNT-NO                TO FM-ACCOUNT-NO        
              MOVE KD-FW-ACTION-TYPE-CD         TO FM-FW-ACTION-TYPE-CD 
                                                                        
              PERFORM 7560-GET-COLL-AGENCY-HST  THRU 7560-EXIT          
                                                                        
              IF FM-CODE-COLLEC-AGNCY NOT = SPACES THEN                 
                                                                        
A280             MOVE  WS-COMPANY-NUM          TO  KU-COMPANY-NO        
A280             MOVE  LR-REG-GROUP-CD         TO  KU-REG-GROUP-CD      
A280             MOVE  WS-ACCOUNT-TYPE-CODE    TO  KU-COLL-ACCT-TYPE-CD 
A280             MOVE  FM-FW-ACTION-TYPE-CD    TO  KU-FW-ACTION-TYPE-CD 
A280             MOVE  FM-CODE-COLLEC-AGNCY    TO  KU-CODE-COLLEC-AGNCY 
A280             MOVE  FM-COLL-AGY-SUB-CD      TO  KU-COLL-AGENCY-SUB-CD
A280             PERFORM 7585-GET-COLL-AGNCY-ASSIGN      THRU 7585-EXIT 
A280                                                                    
A280             IF  SQLCODE EQUAL SUCCESSFUL-CALL                      
A280                 MOVE KU-CODE-COLLEC-AGNCY   TO WS-CODE-COLLEC-AGNCY
A280                 MOVE KU-COLL-AGENCY-SUB-CD  TO WS-COLL-AGY-SUB-CD  
A280             ELSE                                                   
A280                CONTINUE                                            
A280             END-IF                                                 
              ELSE                                                      
                 MOVE AT-ACCOUNT-NO             TO IZ-ACCOUNT-NO        
                 MOVE KD-FW-ACTION-TYPE-CD      TO IZ-FW-ACTION-TYPE-CD 
                 MOVE AT-CUSTOMER-NO            TO IZ-CUSTOMER-NO       
                 MOVE WS-PROGRAM-DATE           TO IZ-WITHDRAW-DT       
                                                                        
                 PERFORM 7565-GET-COLL-AGNCY-OTHR-ACCT   THRU 7565-EXIT 
                                                                        
A01700           IF IZ-CODE-COLLEC-AGNCY = SPACES                       
A01700              CONTINUE                                            
A01700           ELSE                                                   
A280                MOVE WS-COMPANY-NUM        TO  KU-COMPANY-NO        
A280                MOVE LR-REG-GROUP-CD       TO  KU-REG-GROUP-CD      
A280                MOVE WS-ACCOUNT-TYPE-CODE  TO  KU-COLL-ACCT-TYPE-CD 
A280                MOVE IZ-FW-ACTION-TYPE-CD  TO  KU-FW-ACTION-TYPE-CD 
A280                MOVE IZ-CODE-COLLEC-AGNCY  TO  KU-CODE-COLLEC-AGNCY 
A280                MOVE IZ-COLL-AGY-SUB-CD    TO  KU-COLL-AGENCY-SUB-CD
A280                PERFORM 7585-GET-COLL-AGNCY-ASSIGN   THRU 7585-EXIT 
A280                                                                    
A280                IF SQLCODE EQUAL SUCCESSFUL-CALL                    
A280                   MOVE KU-CODE-COLLEC-AGNCY TO WS-CODE-COLLEC-AGNCY
A280                   MOVE KU-COLL-AGENCY-SUB-CD TO WS-COLL-AGY-SUB-CD 
A280                ELSE                                                
A280                   CONTINUE                                         
A280                END-IF                                              
A01700           END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
T30169 1020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS13800
      *                                                                *PCS13810
      * 1030-PROCESS-COLL-AGNCY-SMRY                                   *PCS13820
      *                                                                *PCS13830
      * THIS MODULE WRITE THE COLL AGENCY SUMMARY RECORDS              *        
      *                                                                *        
      ******************************************************************PCS13950
      *                                                                         
T30169 1030-PROCESS-COLL-AGNCY-SMRY.                                    
      *                                                                         
           MOVE +1                      TO WS-COUNTER.                  
                                                                        
           SET WS-SMRY-INDEX            TO WS-COUNTER.                  
                                                                        
           PERFORM UNTIL WS-COUNTER    >  WS-SMRY-CNTRL                 
                                                                        
              INITIALIZE FIOCA227                                       
                                                                        
              MOVE 'H'                  TO E-FCA227-RECORD-TYPE-SMRY    
              MOVE WS-REG-GROUP-CD-SMRY(WS-SMRY-INDEX)                  
                                        TO E-FCA227-REG-GROUP-CD-SMRY   
              MOVE WS-ACTION-TYPE-SMRY (WS-SMRY-INDEX)                  
                                        TO E-FCA227-ACTION-TYPE-CD-SMRY 
              MOVE WS-ACCT-TYPE-CD-SMRY (WS-SMRY-INDEX)                 
                                        TO E-FCA227-ACCT-TYPE-CODE-SMRY 
              MOVE WS-TOTAL-ACT-TYP-SMRY (WS-SMRY-INDEX)                
                                        TO E-FCA227-TOTAL-ACCT-TYPE     
              MOVE WS-TOTAL-WO-BAL-SMRY (WS-SMRY-INDEX)                 
                                        TO E-FCA227-TOTAL-WO-BALANCE    
                                                                        
              PERFORM 8550-WRITE-FCA227-RECORD                          
                                        THRU 8550-EXIT                  
                                                                        
              ADD +1                    TO WS-COUNTER                   
              SET WS-SMRY-INDEX         TO WS-COUNTER                   
                                                                        
           END-PERFORM.                                                 
      *                                                                         
T30169 1030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS13800
      *                                                                *PCS13810
      * 1040-CHECK-EXCLUSIONS                                          *PCS13820
      *                                                                *PCS13830
      * THIS MODULE CHECK FOR CA EXCEMPT, ARRANGEMENTS, DECEASED ACCTS *        
      *                                                                *        
      ******************************************************************PCS13950
      *                                                                         
T30169 1040-CHECK-EXCLUSIONS.                                           
      *                                                                         
           MOVE AT-ACCOUNT-NO               TO CO-ACCOUNT-NO            
                                               WG-ACCOUNT-NO            
                                               YP-ACCOUNT-NO.           
                                                                        
           SET CA-EXCEMPT-NOT-EXIST         TO TRUE.                    
           SET NOT-DECEASED-ACCOUNT         TO TRUE.                    
                                                                        
                                                                        
           IF WS-WRITE-OFF-BALANCE > 0                                  
              PERFORM 7200-CHECK-CA-EXEMPT  THRU 7200-EXIT              
           END-IF.                                                      
                                                                        
           IF CA-EXCEMPT-EXIST                                          
              SET WRITE-TO-CA226            TO TRUE                     
           ELSE                                                         
A01823        MOVE WS-N               TO WS-ARRANGEMENT-EXIST           
              PERFORM 7275-CHECK-ARRANGEMENT THRU 7275-EXIT             
              PERFORM 7250-CHECK-DECEASED-ACCOUNT THRU 7250-EXIT        
A01823        IF WS-ARRANGEMENT-EXIST = 'N' AND                         
                 NOT-DECEASED-ACCOUNT       AND                         
A03116           AT-BANKRUPTCY-IND = SPACES                             
                 SET WRITE-TO-CA227         TO TRUE                     
              ELSE                                                      
                 SET WRITE-TO-CA226         TO TRUE                     
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
T30169 1040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS13800
      *                                                                *PCS13810
      * 1050-CHECK-TO-BYPASS-CA277                                     *PCS13820
      *                                                                *PCS13830
      * THIS MODULE CHECKS WO-CA-RANDOM-SW DELINQ VALUE WHETHER TO     *        
      * TO BYPASS RANDOM PROCESS SO THAT ACCOUNTS WILL NOT BE MOVED    *        
      * TO CA277 FILE                                                  *        
      *                                                                *        
      ******************************************************************PCS13950
      *                                                                         
T30169 1050-CHECK-TO-BYPASS-CA277.                                      
      *                                                                         
           MOVE 'N'                          TO WS-CA277-BYPASS-FLAG    
                                                                        
           IF WS-CA-RANDOM-DELINQ = 0                                   
              SET BYPASS-CA277               TO TRUE                    
           ELSE                                                         
              IF SEB AND WS-CA-RANDOM-DELINQ = 2                        
                 AND LR-REG-GROUP-CD > SPACES                           
                 SET BYPASS-CA277            TO TRUE                    
              ELSE                                                      
                 IF SEB AND WS-CA-RANDOM-DELINQ = 1 AND                 
                    LR-REG-GROUP-CD = SPACES                            
                    SET BYPASS-CA277         TO TRUE                    
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
T30169 1050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS14560
      *                                                                *        
      *     2100-PROCESS-CRED-BUR-ACCT                                 *PCS14580
      *                                                                *PCS14590
      * THIS MODULE EXTRACTS ACCOUNT INFO FOR THE ACCOUNT.             *        
      *                                                                *        
      ******************************************************************PCS14650
      *                                                                         
       2100-PROCESS-CRED-BUR-ACCT.                                      
      *                                                                         
           PERFORM 4000-LOAD-FIOCA226 THRU 4000-EXIT.                   
      *                                                                         
           MOVE '2000'                TO E-FCA226-DATA-REC-TYPE.        
           MOVE AT-ACCT-FINALED-DT    TO E-FCA226-ACCT-FINALED-DT.      
           MOVE AT-TOTAL-AR-BALANCE   TO E-FCA226-TOTAL-AR-BALANCE.     
           MOVE AT-BILL-CYCLE         TO E-FCA226-BILL-CYCLE.           
           MOVE AT-CODES-DATA-PRESENT TO E-FCA226-CODES-DATA-PRESENT.   
           MOVE AT-BANKRUPTCY-IND     TO E-FCA226-BANKRUPTCY-IND.       
           MOVE AT-CODE-DISC-OK       TO E-FCA226-CODE-DISC-OK.         
           MOVE AT-NOTICE-EXEMPT-CD   TO E-FCA226-NOTICE-EXEMPT-CD.     
           MOVE SPACE                 TO E-FCA226-JUDGEMENT-IND.        
T30169     MOVE WS-WRITE-OFF-DT       TO E-FCA226-WRITE-OFF-DT.         
T30169     MOVE WS-WRITE-OFF-AM       TO E-FCA226-WRITE-OFF-AM.         
           MOVE ZEROES                TO E-FCA226-FIRST-CR-LTR-AM.      
           MOVE SPACES                TO E-FCA226-FIRST-CR-LTR-DT.      
           MOVE SPACES                TO E-FCA226-COLLECTION-DT.        
T30169     MOVE KD-FW-ACTION-DT       TO E-FCA226-CR-BUR-RPT-DT-FW.     
T30169     MOVE WS-LPC-ASSESS-DT      TO E-FCA226-LPC-ASSESS-DT.        
           MOVE CZ-CR-BUR-RPT-DT      TO E-FCA226-CR-BUR-RPT-DT-CZ.     
           MOVE ZEROES                TO E-FCA226-FINAL-BILL-AM.        
           MOVE ZEROES                TO E-FCA226-CR-BUR-RPT-AM-FW.     
T30169     MOVE KD-FW-ACTION-TYPE-CD  TO E-FCA226-ACTION-TYPE-CD.       
T30169     MOVE KD-FW-SEQ-NO          TO E-FCA226-ACTION-SEQ-NO.        
T30169     MOVE SPACES                TO E-FCA226-CODE-COLLEC-AGNCY.    
T30169     MOVE SPACES                TO E-FCA226-COLL-AGY-SUB-CD.      
T30169     MOVE ZEROS                 TO E-FCA226-WRITE-OFF-BALANCE.    
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS14560
      *                                                                *        
      *     2200-GET-WO-CREDB-LTR-LPC                                  *PCS14580
      *                                                                *PCS14590
      * THIS MODULE EXTRACTS WO CREDB CRED LETTER AND LPC.             *        
      *                                                                *        
      ******************************************************************PCS14650
      *                                                                         
T30169 2200-GET-WO-CREDB-LTR-LPC.                                       
      *                                                                         
           MOVE 'WO'                       TO WS-FW-ACTION-TYPE-CD.     
           PERFORM 7500-GET-FW-ACTION-DETAILS THRU 7500-EXIT.           
           MOVE WS-FW-ACTION-DT            TO WS-WRITE-OFF-DT.          
           MOVE WS-FW-ACTION-AM            TO WS-WRITE-OFF-AM.          
      *                                                                         
           MOVE 'LPC'                      TO WS-FW-ACTION-TYPE-CD.     
           PERFORM 7500-GET-FW-ACTION-DETAILS THRU 7500-EXIT.           
           MOVE WS-FW-ACTION-DT            TO WS-LPC-ASSESS-DT.         
      *                                                                         
           IF KD-FW-ACTION-TYPE-CD NOT = 'CREDB' THEN                   
              MOVE 'CREDB'                 TO WS-FW-ACTION-TYPE-CD      
              PERFORM 7500-GET-FW-ACTION-DETAILS THRU 7500-EXIT         
              MOVE WS-FW-ACTION-DT         TO WS-CR-BUR-RPT-DT          
      *                                                                         
              MOVE '90503'                 TO WS-FW-ACTION-TYPE-CD      
              PERFORM 7500-GET-FW-ACTION-DETAILS THRU 7500-EXIT         
              MOVE WS-FW-ACTION-DT         TO WS-FIRST-CR-LTR-DT        
              MOVE WS-FW-ACTION-AM         TO WS-FIRST-CR-LTR-AM        
           END-IF.                                                      
      *                                                                         
T30169 2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS14560
      *                                                                *        
      *     2300-GET-COLL-AGENCY-DETAILS                               *PCS14580
      *                                                                *PCS14590
      * THIS MODULE EXTRACTS COLLECTION AGENCY CODE AND SUB CODE.      *        
      *                                                                *        
      ******************************************************************PCS14650
      *                                                                         
T30169 2300-GET-COLL-AGENCY-DETAILS.                                    
      *                                                                         
           MOVE AT-ACCOUNT-NO              TO IZ-ACCOUNT-NO.            
           MOVE KD-FW-ACTION-TYPE-CD       TO IZ-FW-ACTION-TYPE-CD.     
           MOVE KD-FW-SEQ-NO               TO IZ-FW-COLL-SEQ-NO.        
           PERFORM 7550-GET-COLL-AGENCY    THRU 7550-EXIT.              
           MOVE IZ-CODE-COLLEC-AGNCY       TO WS-CODE-COLLEC-AGNCY.     
           MOVE IZ-COLL-AGY-SUB-CD         TO WS-COLL-AGY-SUB-CD.       
A280       IF SEB                                                       
A280           MOVE AT-ACCOUNT-NO            TO LR-ACCOUNT-NO           
A280           PERFORM 7110-GET-REG-GROUP-CD THRU 7110-EXIT             
A280       ELSE                                                         
A280           MOVE SPACES                   TO LR-REG-GROUP-CD         
A280       END-IF.                                                      
A280                                                                    
A280       IF AT-ACCOUNT-TYPE-CODE = 'R' OR 'C'                         
A280          MOVE AT-ACCOUNT-TYPE-CODE    TO WS-ACCOUNT-TYPE-CODE      
A280       ELSE                                                         
A280          MOVE 'O'                     TO WS-ACCOUNT-TYPE-CODE      
A280       END-IF.                                                      
                                                                        
T30169 2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS14560
      *     2400-GET-WRITE-OFF-BALANCE                                 *PCS14580
      *                                                                *PCS14590
      * THIS MODULE EXTRACTS WRITE OFF BALANCE                         *        
      *                                                                *        
      ******************************************************************PCS14650
      *                                                                         
T30169 2400-GET-WRITE-OFF-BALANCE.                                      
      *                                                                         
           MOVE AT-ACCOUNT-NO              TO CO-ACCOUNT-NO.            
           PERFORM 7575-GET-WO-BAL         THRU 7575-EXIT.              
           MOVE CO-AMT-TRANS               TO WS-WRITE-OFF-BALANCE.     
      *                                                                         
T30169 2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS14560
      *     2500-PROCESS-SUMMARY-227                                   *PCS14580
      *                                                                *PCS14590
      * THIS MODULE PROCESS THE SUMMARY RECORDS                        *        
      *                                                                *        
      ******************************************************************PCS14650
      *                                                                         
T30169 2500-PROCESS-SUMMARY-227.                                        
      *                                                                         
           SET WS-SMRY-INDEX               TO 1                         
                                                                        
           SEARCH WS-SMRY-TABLE-RECORD VARYING WS-SMRY-INDEX            
             WHEN WS-REG-GROUP-CD-SMRY(WS-SMRY-INDEX)                   
                                              = LR-REG-GROUP-CD         
              AND WS-ACTION-TYPE-SMRY(WS-SMRY-INDEX)                    
                                              = KD-FW-ACTION-TYPE-CD    
              AND WS-ACCT-TYPE-CD-SMRY(WS-SMRY-INDEX)                   
                                              = WS-ACCOUNT-TYPE-CODE    
                  ADD +1         TO WS-TOTAL-ACT-TYP-SMRY(WS-SMRY-INDEX)
                  ADD WS-WRITE-OFF-BALANCE                              
                                 TO WS-TOTAL-WO-BAL-SMRY(WS-SMRY-INDEX) 
                                                                        
             WHEN WS-REG-GROUP-CD-SMRY(WS-SMRY-INDEX) = SPACES          
              AND WS-ACTION-TYPE-SMRY(WS-SMRY-INDEX)  = SPACES          
              AND WS-ACCT-TYPE-CD-SMRY(WS-SMRY-INDEX) = SPACES          
                  ADD +1         TO WS-SMRY-CNTRL                       
                  MOVE LR-REG-GROUP-CD                                  
                                 TO WS-REG-GROUP-CD-SMRY(WS-SMRY-INDEX) 
                  MOVE KD-FW-ACTION-TYPE-CD                             
                                 TO WS-ACTION-TYPE-SMRY(WS-SMRY-INDEX)  
                  MOVE WS-ACCOUNT-TYPE-CODE                             
                                 TO WS-ACCT-TYPE-CD-SMRY(WS-SMRY-INDEX) 
                  ADD +1         TO WS-TOTAL-ACT-TYP-SMRY(WS-SMRY-INDEX)
                  ADD WS-WRITE-OFF-BALANCE                              
                                 TO WS-TOTAL-WO-BAL-SMRY(WS-SMRY-INDEX) 
           END-SEARCH.                                                  
                                                                        
      *                                                                         
T30169 2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS14560
      *     2550-CHECK-AR-TRANS-HIST                                   *PCS14580
      *                                                                *PCS14590
      * THIS MODULE PROCESS THE SUMMARY RECORDS                        *        
      *                                                                *        
      ******************************************************************PCS14650
      *                                                                         
T30169 2550-CHECK-AR-TRANS-HIST.                                        
      *                                                                         
           MOVE AT-ACCOUNT-NO                   TO AR-ACCOUNT-NO.       
                                                                        
           MOVE ZERO                            TO WS-CREDIT-AMT        
                                                   WS-TRANS-DIFF-AMT    
                                                   WS-DEBIT-AMT.        
                                                                        
           PERFORM 7970-OPEN-TRNHST-CSR         THRU 7970-EXIT.         
                                                                        
           PERFORM 7974-FETCH-TRNHST-CSR        THRU 7974-EXIT.         
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              EVALUATE AR-CODE-TRAN-TYPE                                
                 WHEN 'I'                                               
                    MOVE AR-AMT-ORIG-ENTERED    TO WS-CREDIT-AMT        
                 WHEN 'T'                                               
                    PERFORM 2575-CHECK-CR-DB-TRAN THRU 2575-EXIT        
                 WHEN 'P'                                               
                    MOVE AR-AMT-ORIG-ENTERED    TO WS-CREDIT-AMT        
                 WHEN 'S'                                               
                    MOVE AR-AMT-ORIG-ENTERED    TO WS-DEBIT-AMT         
                 WHEN 'R'                                               
                    PERFORM 2575-CHECK-CR-DB-TRAN THRU 2575-EXIT        
              END-EVALUATE                                              
              PERFORM 7974-FETCH-TRNHST-CSR     THRU 7974-EXIT          
           END-PERFORM.                                                 
                                                                        
           PERFORM 7978-CLOSE-TRNHST-CSR        THRU 7978-EXIT.         
                                                                        
           COMPUTE WS-TRANS-DIFF-AMT = WS-DEBIT-AMT - WS-CREDIT-AMT.    
                                                                        
      *                                                                         
T30169 2550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T30169*****************************************************************         
T30169*2575-CHECK-CR-DB-TRAN.                                         *         
T30169*****************************************************************         
T30169 2575-CHECK-CR-DB-TRAN.                                           
      *                                                                         
           IF AR-CODE-TRAN-TYPE = 'T'                                   
              IF AU-GL-ACCT-CREDIT = 184.2201                           
                 MOVE AR-AMT-ORIG-ENTERED  TO WS-DEBIT-AMT              
              ELSE                                                      
                 IF AU-GL-ACCT-DEBIT = 184.2201                         
                    MOVE AR-AMT-ORIG-ENTERED   TO WS-CREDIT-AMT         
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF AR-CODE-TRAN-TYPE = 'R'                                   
              IF AU-GL-ACCT-CREDIT = 184.2000 OR 184.2300               
                 MOVE AR-AMT-ORIG-ENTERED  TO WS-DEBIT-AMT              
              ELSE                                                      
                 MOVE AR-AMT-ORIG-ENTERED  TO WS-CREDIT-AMT             
              END-IF                                                    
           END-IF.                                                      
T30169*                                                                         
T30169 2575-EXIT.                                                       
T30169     EXIT.                                                        
      *                                                                 04620000
      ******************************************************************PCS14560
      *                                                                *        
      * 3000-ACT-NON-UTIL-TO-CRED-BUR                                  *PCS14580
      *                                                                *PCS14590
      * THIS MODULE OPENS A CURSOR TO EXTRACT FROM CSS_CRED_COLL  'L'  *        
      * ROWS (WHICH SIGNIFY DELINQUENT CONTRACT(S) ON A NON-UTIL ACCT) *        
      * WHERE DATE_CREDIT_ACTION IS BETWEEN TODAY'S DATE (INCLUSIVE)   *        
      * AND THE LAST RUN DATE OF THIS PROGRAM (NOT INCLUSIVE).  EACH   *        
      * ACCOUNT IS SENT FOR PROCESSING TO DECIDE IF THE ACCOUNT SHOULD *        
      * STILL BE SENT TO THE CREDIT BUREAUS.                           *        
      *                                                                *        
      * NOTE: ONLY 1 'L' ROW EXISTS PER ACCOUNT.                       *        
T20923* CHECKING ACCOUNT BANKRUPTCY INDICATOR = ' ' WAS ADDED TO CURSOR*        
      ******************************************************************PCS14650
      *                                                                         
       3000-ACT-NON-UTIL-TO-CRED-BUR.                                   
      *                                                                         
           PERFORM 7700-OPEN-DEL-N-UTIL-ACCTS   THRU 7700-EXIT.         
           PERFORM 7710-FETCH-DEL-N-UTIL-ACCT   THRU 7710-EXIT.         
           PERFORM UNTIL SQLCODE EQUAL NOT-FOUND                        
               PERFORM 3010-PROCESS-DEL-N-UTIL-ACCT THRU 3010-EXIT      
               PERFORM 8500-WRITE-FCA226-RECORD     THRU 8500-EXIT      
               PERFORM 7710-FETCH-DEL-N-UTIL-ACCT   THRU 7710-EXIT      
           END-PERFORM.                                                 
           PERFORM 7720-CLOSE-DEL-N-UTIL-ACCTS  THRU 7720-EXIT.         
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS14560
      *                                                                *        
      * 3010-PROCESS-DEL-N-UTIL-ACCT                                   *PCS14580
      *                                                                *        
      * THIS MODULE EXTRACTS ACCOUNT INFO FOR THE DELINQUENT NON-UTIL  *        
      * ACCOUNT, LOADS THE RELEVANT CONTRACT(S) INFORMATION INTO THE   *        
      * WORKING STORAGE THAT WILL BE MOVED INTO THE EXTRACT FILE.      *        
      *                                                                *        
      ******************************************************************PCS14650
      *                                                                         
       3010-PROCESS-DEL-N-UTIL-ACCT.                                    
      *                                                                         
           PERFORM 4000-LOAD-FIOCA226 THRU 4000-EXIT.                   
      *                                                                         
           MOVE '3000'                TO E-FCA226-DATA-REC-TYPE.        
           MOVE SPACES                TO E-FCA226-ACCT-FINALED-DT.      
           MOVE AT-BILL-CYCLE         TO E-FCA226-BILL-CYCLE.           
           MOVE AT-CODES-DATA-PRESENT TO E-FCA226-CODES-DATA-PRESENT.   
           MOVE AT-BANKRUPTCY-IND     TO E-FCA226-BANKRUPTCY-IND.       
           MOVE AT-TOTAL-AR-BALANCE   TO E-FCA226-TOTAL-AR-BALANCE.     
           MOVE AT-CODE-DISC-OK       TO E-FCA226-CODE-DISC-OK.         
           MOVE AT-NOTICE-EXEMPT-CD   TO E-FCA226-NOTICE-EXEMPT-CD.     
           MOVE SPACE                 TO E-FCA226-JUDGEMENT-IND.        
           MOVE SPACES                TO E-FCA226-WRITE-OFF-DT.         
           MOVE ZEROES                TO E-FCA226-WRITE-OFF-AM.         
           MOVE ZEROES                TO E-FCA226-FIRST-CR-LTR-AM.      
           MOVE SPACES                TO E-FCA226-FIRST-CR-LTR-DT.      
           MOVE SPACES                TO E-FCA226-COLLECTION-DT.        
           MOVE SPACES                TO E-FCA226-CR-BUR-RPT-DT-FW.     
           MOVE SPACES                TO E-FCA226-LPC-ASSESS-DT.        
           MOVE CZ-CR-BUR-RPT-DT      TO E-FCA226-CR-BUR-RPT-DT-CZ.     
           MOVE ZEROES                TO E-FCA226-FINAL-BILL-AM.        
           MOVE ZEROES                TO E-FCA226-CR-BUR-RPT-AM-FW.     
T30169     MOVE SPACES                TO E-FCA226-ACTION-TYPE-CD.       
T30169     MOVE ZEROES                TO E-FCA226-ACTION-SEQ-NO.        
T30169     MOVE SPACES                TO E-FCA226-CODE-COLLEC-AGNCY.    
T30169     MOVE SPACES                TO E-FCA226-COLL-AGY-SUB-CD.      
T30169     MOVE ZEROES                TO E-FCA226-WRITE-OFF-BALANCE.    
      *                                                                         
       3010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS14560
      *                                                                         
      *    3500-PROCESS-SUBSEQ-RPT-N-UTL                                        
      *                                                                         
      *    THIS PARAGRAPH PROCESSES ACTIVE NON-UTILITY ACCOUNTS WITH            
      *    FINANCIAL TRANSACTIONS SINCE THE LAST TIME THE ACCOUNT WAS           
      *    REPORTED TO THE CREDIT BUREAU.                                       
T25628*    ACCOUNTS WITH AT.NOTICE_EXEMPT_CD <> '0' OR 'L' ARE BYPASSED         
T25628*    AS WELL AS THOSE ACCOUNTS THAT HAVE AN AT.BANKRUPTCY_IND             
T25628*    THAT IS NOT EQUAL TO SPACES.                                         
T25628*    WRITES MAINTENANCE TRANSACTION HISTORY TO RECORD THE                 
T25628*    SENDING OF THE ACCOUNT TO THE CREDIT BUREAUS.                        
      *                                                                         
      ******************************************************************        
      *                                                                         
PCR499 3500-PROCESS-SUBSEQ-RPT-N-UTL.                                   
      *                                                                         
           PERFORM 7900-OPEN-SUBSEQ-RPT-N-UTIL  THRU 7900-EXIT.         
           PERFORM 7905-FETCH-SUBSEQ-RPT-N-UTIL THRU 7905-EXIT.         
           PERFORM UNTIL SQLCODE = NOT-FOUND                            
               PERFORM 3510-PROCESS-SUBSEQ-RPT-N-UTL THRU 3510-EXIT     
               PERFORM 8500-WRITE-FCA226-RECORD      THRU 8500-EXIT     
               PERFORM 7905-FETCH-SUBSEQ-RPT-N-UTIL  THRU 7905-EXIT     
           END-PERFORM.                                                 
           PERFORM 7910-CLOSE-SUBSEQ-RPT-N-UTIL THRU 7910-EXIT.         
      *                                                                         
       3500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS14560
      *                                                                *        
      * 3510-PROCESS-SUBSEQ-RPT-N-UTL                                  *PCS14580
      *                                                                *        
      * THIS MODULE EXTRACTS ACCOUNT INFO FOR THE SUBSEQUENT NON-UTIL  *        
      * ACCOUNT, LOADS THE RELEVANT CONTRACT(S) INFORMATION INTO THE   *        
      * WORKING STORAGE THAT WILL BE MOVED INTO THE EXTRACT FILE.      *        
      *                                                                *        
      ******************************************************************PCS14650
      *                                                                         
       3510-PROCESS-SUBSEQ-RPT-N-UTL.                                   
      *                                                                         
           PERFORM 4000-LOAD-FIOCA226 THRU 4000-EXIT.                   
      *                                                                         
           MOVE '3500'                TO E-FCA226-DATA-REC-TYPE.        
           MOVE SPACES                TO E-FCA226-ACCT-FINALED-DT.      
           MOVE ZEROES                TO E-FCA226-TOTAL-AR-BALANCE.     
           MOVE SPACES                TO E-FCA226-BILL-CYCLE.           
           MOVE SPACES                TO E-FCA226-CODES-DATA-PRESENT.   
           MOVE SPACE                 TO E-FCA226-BANKRUPTCY-IND.       
           MOVE SPACE                 TO E-FCA226-CODE-DISC-OK.         
           MOVE SPACE                 TO E-FCA226-NOTICE-EXEMPT-CD.     
           MOVE SPACE                 TO E-FCA226-JUDGEMENT-IND.        
           MOVE SPACES                TO E-FCA226-WRITE-OFF-DT.         
           MOVE ZEROES                TO E-FCA226-WRITE-OFF-AM.         
           MOVE ZEROES                TO E-FCA226-FIRST-CR-LTR-AM.      
           MOVE SPACES                TO E-FCA226-FIRST-CR-LTR-DT.      
           MOVE SPACES                TO E-FCA226-COLLECTION-DT.        
           MOVE SPACES                TO E-FCA226-CR-BUR-RPT-DT-FW.     
           MOVE SPACES                TO E-FCA226-LPC-ASSESS-DT.        
           MOVE CZ-CR-BUR-RPT-DT      TO E-FCA226-CR-BUR-RPT-DT-CZ.     
           MOVE ZEROES                TO E-FCA226-FINAL-BILL-AM.        
           MOVE ZEROES                TO E-FCA226-CR-BUR-RPT-AM-FW.     
T30169     MOVE SPACES                TO E-FCA226-ACTION-TYPE-CD.       
T30169     MOVE ZEROES                TO E-FCA226-ACTION-SEQ-NO.        
T30169     MOVE SPACES                TO E-FCA226-CODE-COLLEC-AGNCY.    
T30169     MOVE SPACES                TO E-FCA226-COLL-AGY-SUB-CD.      
T30169     MOVE ZEROES                TO E-FCA226-WRITE-OFF-BALANCE.    
      *                                                                         
       3510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                         
      *    3700-PROCESS-SUBSEQ-RPT-WO                                           
      *                                                                         
      *    THIS PARAGRAPH PROCESSES WRITTEN OFF ACCOUNTS WITH                   
T25628*    FINANCIAL TRANSACTIONS SINCE THE LAST RUN DATE.                      
T25628*    BANKRUPT ACCOUNTS ARE BYPASSED.                                      
T25628*    WRITES MAINTENANCE TRANSACTION HISTORY TO RECORD THE                 
T25628*    SENDING OF THE ACCOUNT TO THE CREDIT BUREAUS.                        
      *                                                                         
      ******************************************************************        
      *                                                                         
PCR499 3700-PROCESS-SUBSEQ-RPT-WO.                                      
      *                                                                         
           PERFORM 7950-OPEN-SUBSEQ-RPT-WO  THRU 7950-EXIT.             
           PERFORM 7955-FETCH-SUBSEQ-RPT-WO THRU 7955-EXIT.             
           PERFORM UNTIL SQLCODE = NOT-FOUND                            
T30169         PERFORM 2200-GET-WO-CREDB-LTR-LPC  THRU 2200-EXIT        
               PERFORM 3710-PROCESS-SUBSEQ-RPT-WO THRU 3710-EXIT        
               PERFORM 8500-WRITE-FCA226-RECORD   THRU 8500-EXIT        
               PERFORM 7955-FETCH-SUBSEQ-RPT-WO   THRU 7955-EXIT        
           END-PERFORM.                                                 
           PERFORM 7960-CLOSE-SUBSEQ-RPT-WO THRU 7960-EXIT.             
      *                                                                         
       3700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS14560
      *                                                                *        
      * 3710-PROCESS-SUBSEQ-RPT-WO                                     *PCS14580
      *                                                                *        
      * THIS MODULE EXTRACTS ACCOUNT INFO FOR THE SUBSEQ-RPT-WO        *        
      * ACCOUNT, LOADS THE RELEVANT CONTRACT(S) INFORMATION INTO THE   *        
      * WORKING STORAGE THAT WILL BE MOVED INTO THE EXTRACT FILE.      *        
      *                                                                *        
      ******************************************************************PCS14650
      *                                                                         
       3710-PROCESS-SUBSEQ-RPT-WO.                                      
      *                                                                         
           PERFORM 4000-LOAD-FIOCA226 THRU 4000-EXIT.                   
      *                                                                         
           MOVE '3700'                TO E-FCA226-DATA-REC-TYPE.        
           MOVE AT-ACCT-FINALED-DT    TO E-FCA226-ACCT-FINALED-DT.      
           MOVE AT-TOTAL-AR-BALANCE   TO E-FCA226-TOTAL-AR-BALANCE.     
           MOVE AT-BILL-CYCLE         TO E-FCA226-BILL-CYCLE.           
           MOVE AT-CODES-DATA-PRESENT TO E-FCA226-CODES-DATA-PRESENT.   
           MOVE AT-BANKRUPTCY-IND     TO E-FCA226-BANKRUPTCY-IND.       
           MOVE AT-CODE-DISC-OK       TO E-FCA226-CODE-DISC-OK.         
           MOVE AT-NOTICE-EXEMPT-CD   TO E-FCA226-NOTICE-EXEMPT-CD.     
           MOVE SPACE                 TO E-FCA226-JUDGEMENT-IND.        
T30169     MOVE WS-WRITE-OFF-DT       TO E-FCA226-WRITE-OFF-DT.         
T30169     MOVE WS-WRITE-OFF-AM       TO E-FCA226-WRITE-OFF-AM.         
           MOVE ZEROES                TO E-FCA226-FIRST-CR-LTR-AM.      
           MOVE SPACES                TO E-FCA226-FIRST-CR-LTR-DT.      
           MOVE SPACES                TO E-FCA226-COLLECTION-DT.        
T30169     MOVE KD-FW-ACTION-DT       TO E-FCA226-CR-BUR-RPT-DT-FW.     
T30169     MOVE WS-LPC-ASSESS-DT      TO E-FCA226-LPC-ASSESS-DT.        
           MOVE CZ-CR-BUR-RPT-DT      TO E-FCA226-CR-BUR-RPT-DT-CZ.     
           MOVE FW-FINAL-BILL-AM      TO E-FCA226-FINAL-BILL-AM.        
T30169     MOVE KD-FW-ACTION-TYPE-CD  TO E-FCA226-ACTION-TYPE-CD.       
T30169     MOVE KD-FW-SEQ-NO          TO E-FCA226-ACTION-SEQ-NO.        
T30169     MOVE KD-FW-ACTION-AM       TO E-FCA226-CR-BUR-RPT-AM-FW.     
T30169     MOVE SPACES                TO E-FCA226-CODE-COLLEC-AGNCY.    
T30169     MOVE SPACES                TO E-FCA226-COLL-AGY-SUB-CD.      
T30169     MOVE ZEROES                TO E-FCA226-WRITE-OFF-BALANCE.    
      *                                                                         
       3710-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T25628******************************************************************        
T25628*                                                                         
T25628*    3900-PROCESS-SUBSEQ-RPT-FB                                           
T25628*                                                                         
T25628*    THIS PARAGRAPH PROCESSES ALL FINAL BILL ACCOUNTS WITH                
T25628*    FINANCIAL TRANSACTIONS SINCE THE LAST RUN DATE.                      
T25628*    ACCOUNTS WITH AT.NOTICE_EXEMPT_CD <> '0' OR 'L' ARE BYPASSED         
T25628*    AS WELL AS THOSE ACCOUNTS THAT HAVE AN AT.BANKRUPTCY_IND             
T25628*    THAT IS NOT EQUAL TO SPACES.                                         
T25628*    WRITES MAINTENANCE TRANSACTION HISTORY TO RECORD THE                 
T25628*    SENDING OF THE ACCOUNT TO THE CREDIT BUREAUS.                        
T25628*                                                                         
T25628******************************************************************        
T25628*                                                                         
T25628 3900-PROCESS-SUBSEQ-RPT-FB.                                      
      *                                                                         
           PERFORM 7980-OPEN-SUBSEQ-RPT-FB  THRU 7980-EXIT.             
           PERFORM 7985-FETCH-SUBSEQ-RPT-FB THRU 7985-EXIT.             
           PERFORM UNTIL SQLCODE = NOT-FOUND                            
               PERFORM 3910-PROCESS-SUBSEQ-RPT-FB THRU 3910-EXIT        
               PERFORM 8500-WRITE-FCA226-RECORD   THRU 8500-EXIT        
               PERFORM 7985-FETCH-SUBSEQ-RPT-FB   THRU 7985-EXIT        
           END-PERFORM.                                                 
           PERFORM 7990-CLOSE-SUBSEQ-RPT-FB THRU 7990-EXIT.             
      *                                                                         
       3900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS14560
      *                                                                *        
      * 3910-PROCESS-SUBSEQ-RPT-FB                                     *PCS14580
      *                                                                *        
      * THIS MODULE EXTRACTS ACCOUNT INFO FOR THE SUBSEQ-RPT-FB        *        
      * ACCOUNT, LOADS THE RELEVANT CONTRACT(S) INFORMATION INTO THE   *        
      * WORKING STORAGE THAT WILL BE MOVED INTO THE EXTRACT FILE.      *        
      *                                                                *        
      ******************************************************************PCS14650
      *                                                                         
       3910-PROCESS-SUBSEQ-RPT-FB.                                      
      *                                                                         
           PERFORM 4000-LOAD-FIOCA226 THRU 4000-EXIT.                   
      *                                                                         
           MOVE '3900'                TO E-FCA226-DATA-REC-TYPE.        
           MOVE AT-ACCT-FINALED-DT    TO E-FCA226-ACCT-FINALED-DT.      
           MOVE AT-TOTAL-AR-BALANCE   TO E-FCA226-TOTAL-AR-BALANCE.     
           MOVE AT-BILL-CYCLE         TO E-FCA226-BILL-CYCLE.           
           MOVE AT-CODES-DATA-PRESENT TO E-FCA226-CODES-DATA-PRESENT.   
           MOVE AT-BANKRUPTCY-IND     TO E-FCA226-BANKRUPTCY-IND.       
           MOVE AT-CODE-DISC-OK       TO E-FCA226-CODE-DISC-OK.         
           MOVE AT-NOTICE-EXEMPT-CD   TO E-FCA226-NOTICE-EXEMPT-CD.     
           MOVE SPACE                 TO E-FCA226-JUDGEMENT-IND.        
           MOVE SPACES                TO E-FCA226-WRITE-OFF-DT.         
           MOVE ZEROES                TO E-FCA226-WRITE-OFF-AM.         
           MOVE ZEROES                TO E-FCA226-FIRST-CR-LTR-AM.      
           MOVE SPACES                TO E-FCA226-FIRST-CR-LTR-DT.      
           MOVE SPACES                TO E-FCA226-COLLECTION-DT.        
           MOVE SPACES                TO E-FCA226-CR-BUR-RPT-DT-FW.     
           MOVE SPACES                TO E-FCA226-LPC-ASSESS-DT.        
           MOVE CZ-CR-BUR-RPT-DT      TO E-FCA226-CR-BUR-RPT-DT-CZ.     
           MOVE FW-FINAL-BILL-AM      TO E-FCA226-FINAL-BILL-AM.        
           MOVE ZEROES                TO E-FCA226-CR-BUR-RPT-AM-FW.     
T30169     MOVE SPACES                TO E-FCA226-ACTION-TYPE-CD.       
T30169     MOVE ZEROES                TO E-FCA226-ACTION-SEQ-NO.        
T30169     MOVE SPACES                TO E-FCA226-CODE-COLLEC-AGNCY.    
T30169     MOVE SPACES                TO E-FCA226-COLL-AGY-SUB-CD.      
T30169     MOVE ZEROES                TO E-FCA226-WRITE-OFF-BALANCE.    
      *                                                                         
       3910-EXIT.                                                       
           EXIT.                                                        
T30169******************************************************************        
T30169*                                                                         
T30169*    3950-PROCESS-SUBSEQ-COLL-AGY                                         
T30169*                                                                         
T30169*    THIS PARAGRAPH PROCESSES ALL PLACED ACCOUNTS WHICH ARE NOT           
T30169*    WITHDRAWN FROM COLLECTION AGENCY TILL LAST RUN DATE AND              
T30169*    CHECKS WHETHER ACCOUNT HAS GOT ANY UPDATES ON EXCHANGE INFO          
T30169*    AND CURRENT BALANACE. IF BOTH UPDATES PRESENT DATA IS MOVED          
T30169*    UNDER DATA REC TYPE - 3952. IF ONLY EXCHANGE INFO UPDATE THEN        
T30169*    IT IS MOVED UNDER DATA REC TYPE - 3950. IF ONLY CURRENT BAL          
T30169*    UPDATE THEN IT IS MOVED UNDER DATA REC TYPE - 3951 ELSE ACCT         
T30169*    IS IGNORED                                                           
T30169*                                                                         
T30169******************************************************************        
T30169*                                                                         
T30169 3950-PROCESS-SUBSEQ-COLL-AGY.                                    
      *                                                                         
           PERFORM 7995-OPEN-SUBSEQ-COLL-AGY      THRU 7995-EXIT.       
           PERFORM 7996-FETCH-SUBSEQ-COLL-AGY     THRU 7996-EXIT.       
           PERFORM UNTIL SQLCODE = NOT-FOUND                            
                                                                        
             MOVE AT-ACCOUNT-NO                   TO EL-ACCOUNT-NO      
                                                                        
             PERFORM 7570-GET-EXCHANGE-INFO-EXIST THRU 7570-EXIT        
             PERFORM 2400-GET-WRITE-OFF-BALANCE   THRU 2400-EXIT        
             PERFORM 2200-GET-WO-CREDB-LTR-LPC    THRU 2200-EXIT        
                                                                        
             MOVE SPACES                          TO WS-DATA-REC-TYPE   
             IF WS-EXCH-INFO-EXIST = 'Y' AND                            
                WS-WRITE-OFF-BALANCE NOT = KD-FW-ACTION-AM              
                PERFORM 2550-CHECK-AR-TRANS-HIST   THRU 2550-EXIT       
                IF WS-TRANS-DIFF-AMT NOT = ZERO                         
                   MOVE '3952'                    TO WS-DATA-REC-TYPE   
                ELSE                                                    
                   MOVE '3950'                    TO WS-DATA-REC-TYPE   
                END-IF                                                  
             ELSE                                                       
                IF WS-EXCH-INFO-EXIST = 'Y'                             
                   MOVE '3950'                    TO WS-DATA-REC-TYPE   
                ELSE                                                    
                   IF WS-WRITE-OFF-BALANCE NOT = KD-FW-ACTION-AM        
                      PERFORM 2550-CHECK-AR-TRANS-HIST   THRU 2550-EXIT 
                      IF WS-TRANS-DIFF-AMT NOT = ZERO                   
                         MOVE '3951'              TO WS-DATA-REC-TYPE   
                      ELSE                                              
                         MOVE SPACES              TO WS-DATA-REC-TYPE   
                      END-IF                                            
                   END-IF                                               
                END-IF                                                  
             END-IF                                                     
             IF WS-DATA-REC-TYPE > SPACES                               
                PERFORM 3951-LOAD-SUBSEQ-COLL-AGY  THRU 3951-EXIT       
                PERFORM 8500-WRITE-FCA226-RECORD   THRU 8500-EXIT       
             END-IF                                                     
                                                                        
             PERFORM 7996-FETCH-SUBSEQ-COLL-AGY THRU 7996-EXIT          
                                                                        
           END-PERFORM.                                                 
           PERFORM 7997-CLOSE-SUBSEQ-COLL-AGY     THRU 7997-EXIT.       
T30169*                                                                         
T30169 3950-EXIT.                                                       
T30169     EXIT.                                                        
T30169*                                                                         
T30169******************************************************************PCS14560
T30169*                                                                *        
T30169* 3951-LOAD-SUBSEQ-COLL-AGY.                                     *PCS14580
T30169*                                                                *        
T30169* THIS MODULE EXTRACTS ACCOUNT INFO FOR THE SUBSEQ-COLL-AGY      *        
T30169* ACCOUNT, LOADS THE RELEVANT INFORMATION INTO THE               *        
T30169* WORKING STORAGE THAT WILL BE MOVED INTO THE EXTRACT FILE.      *        
T30169*                                                                *        
T30169******************************************************************PCS14650
T30169*                                                                         
T30169 3951-LOAD-SUBSEQ-COLL-AGY.                                       
      *                                                                         
           PERFORM 4000-LOAD-FIOCA226 THRU 4000-EXIT.                   
      *                                                                         
                                                                        
           MOVE WS-DATA-REC-TYPE      TO E-FCA226-DATA-REC-TYPE.        
           MOVE AT-TOTAL-AR-BALANCE   TO E-FCA226-TOTAL-AR-BALANCE.     
           MOVE AT-ACCT-FINALED-DT    TO E-FCA226-ACCT-FINALED-DT.      
           MOVE AT-BILL-CYCLE         TO E-FCA226-BILL-CYCLE.           
           MOVE AT-CODES-DATA-PRESENT TO E-FCA226-CODES-DATA-PRESENT.   
           MOVE AT-BANKRUPTCY-IND     TO E-FCA226-BANKRUPTCY-IND.       
           MOVE AT-CODE-DISC-OK       TO E-FCA226-CODE-DISC-OK.         
           MOVE AT-NOTICE-EXEMPT-CD   TO E-FCA226-NOTICE-EXEMPT-CD.     
           MOVE SPACES                TO E-FCA226-JUDGEMENT-IND.        
           MOVE WS-WRITE-OFF-DT       TO E-FCA226-WRITE-OFF-DT.         
           MOVE WS-WRITE-OFF-AM       TO E-FCA226-WRITE-OFF-AM.         
           MOVE ZEROES                TO E-FCA226-FIRST-CR-LTR-AM.      
           MOVE SPACES                TO E-FCA226-FIRST-CR-LTR-DT.      
           MOVE KD-FW-ACTION-DT       TO E-FCA226-COLLECTION-DT.        
           MOVE WS-CR-BUR-RPT-DT      TO E-FCA226-CR-BUR-RPT-DT-FW.     
           MOVE SPACES                TO E-FCA226-LPC-ASSESS-DT.        
           MOVE SPACES                TO E-FCA226-CR-BUR-RPT-DT-CZ.     
           MOVE ZEROES                TO E-FCA226-FINAL-BILL-AM.        
           MOVE ZEROES                TO E-FCA226-CR-BUR-RPT-AM-FW.     
           MOVE KD-FW-ACTION-TYPE-CD  TO E-FCA226-ACTION-TYPE-CD.       
           MOVE KD-FW-SEQ-NO          TO E-FCA226-ACTION-SEQ-NO.        
           MOVE IZ-CODE-COLLEC-AGNCY  TO E-FCA226-CODE-COLLEC-AGNCY.    
           MOVE IZ-COLL-AGY-SUB-CD    TO E-FCA226-COLL-AGY-SUB-CD.      
           MOVE WS-WRITE-OFF-BALANCE  TO E-FCA226-WRITE-OFF-BALANCE.    
T30169*                                                                         
T30169 3951-EXIT.                                                       
T30169     EXIT.                                                        
T30169*                                                                         
      ******************************************************************PCS14560
      *                                                                *        
      * 4000-LOAD-FIOCA226                                             *PCS14580
      *                                                                *        
      * THIS MODULE EXTRACTS ACCOUNT INFO FOR THE OUTPUT FILE FIOCA226 *        
      *                                                                *        
      ******************************************************************PCS14650
      *                                                                         
       4000-LOAD-FIOCA226.                                              
      *                                                                         
T32596*                                                                         
SEBOM9     IF SEB                                                       
SEBOM9         MOVE AT-ACCOUNT-NO            TO LR-ACCOUNT-NO           
SEBOM9         PERFORM 7110-GET-REG-GROUP-CD THRU 7110-EXIT             
SEBOM9     ELSE                                                         
SEBOM9         MOVE SPACES                   TO LR-REG-GROUP-CD         
SEBOM9     END-IF.                                                      
T32596     MOVE LR-REG-GROUP-CD       TO E-FCA226-REG-GROUP-CD.         
           MOVE AT-COMPANY-NO         TO E-FCA226-COMPANY-NO.           
           MOVE AT-CUSTOMER-NO        TO E-FCA226-CUSTOMER-NO.          
           MOVE AT-ACCOUNT-NO         TO E-FCA226-ACCOUNT-NO.           
           MOVE AT-ACCT-CREATE-DT     TO E-FCA226-ACCT-CREATE-DT.       
           MOVE AT-LOCAL-OFFICE       TO E-FCA226-LOCAL-OFFICE.         
           MOVE AT-PREMISE-NO         TO E-FCA226-PREMISE-NO.           
T30169     IF AT-ACCOUNT-TYPE-CODE = 'R' OR 'C'                         
              MOVE AT-ACCOUNT-TYPE-CODE  TO E-FCA226-ACCOUNT-TYPE-CODE  
T30169     ELSE                                                         
T30169        MOVE 'O'                   TO E-FCA226-ACCOUNT-TYPE-CODE  
T30169     END-IF                                                       
           MOVE AT-ADDRESS-ID         TO E-FCA226-ADDRESS-ID.           
           MOVE AT-ADDRESS-FORMAT     TO E-FCA226-ADDRESS-FORMAT.       
           MOVE AT-LAST-PYMT-DATE     TO E-FCA226-LAST-PYMT-DATE.       
T30169     MOVE AT-LAST-PYMT-AMOUNT   TO E-FCA226-LAST-PYMT-AMT.        
           MOVE AT-DATE-BILL-DAY-00   TO E-FCA226-DATE-BILL-DAY-00.     
           MOVE AT-DATE-BILL-DAY-30   TO E-FCA226-DATE-BILL-DAY-30.     
           MOVE AT-DATE-BILL-DAY-60   TO E-FCA226-DATE-BILL-DAY-60.     
           MOVE AT-DATE-BILL-DAY-90   TO E-FCA226-DATE-BILL-DAY-90.     
           MOVE AT-CREDIT-GROUP       TO E-FCA226-CREDIT-GROUP.         
           MOVE AT-CODE-ACCT-STAT     TO E-FCA226-CODE-ACCT-STAT.       
           MOVE AT-CODE-STATUS-REASON TO E-FCA226-CODE-STATUS-REASON.   
           MOVE AT-IVR-EXEMPT-CD      TO E-FCA226-IVR-EXEMPT-CD.        
P00160     PERFORM 2400-GET-WRITE-OFF-BALANCE    THRU 2400-EXIT.        
P00160     MOVE CO-WO-ORIGINAL-AM     TO E-FCA226-WO-ORIGINAL-AM.       
      *                                                                         
       4000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS14560
      *                                                                *        
      * 4100-LOAD-FIOCA227                                             *PCS14580
      *                                                                *        
      * THIS MODULE EXTRACTS ACCOUNT INFO FOR THE OUTPUT FILE FIOCA227 *        
      *                                                                *        
      ******************************************************************PCS14650
      *                                                                         
T30169 4100-LOAD-FIOCA227.                                              
      *                                                                         
           MOVE LR-REG-GROUP-CD       TO E-FCA227-REG-GROUP-CD.         
           MOVE AT-COMPANY-NO         TO E-FCA227-COMPANY-NO.           
           MOVE AT-CUSTOMER-NO        TO E-FCA227-CUSTOMER-NO.          
           MOVE AT-ACCOUNT-NO         TO E-FCA227-ACCOUNT-NO.           
           MOVE AT-ACCT-CREATE-DT     TO E-FCA227-ACCT-CREATE-DT.       
           MOVE AT-LOCAL-OFFICE       TO E-FCA227-LOCAL-OFFICE.         
           MOVE AT-PREMISE-NO         TO E-FCA227-PREMISE-NO.           
           IF AT-ACCOUNT-TYPE-CODE = 'R' OR 'C'                         
              MOVE AT-ACCOUNT-TYPE-CODE  TO E-FCA227-ACCOUNT-TYPE-CODE  
           ELSE                                                         
              MOVE 'O'                   TO E-FCA227-ACCOUNT-TYPE-CODE  
           END-IF                                                       
           MOVE AT-ADDRESS-ID         TO E-FCA227-ADDRESS-ID.           
           MOVE AT-ADDRESS-FORMAT     TO E-FCA227-ADDRESS-FORMAT.       
           MOVE AT-LAST-PYMT-DATE     TO E-FCA227-LAST-PYMT-DATE.       
           MOVE AT-LAST-PYMT-AMOUNT   TO E-FCA227-LAST-PYMT-AMT.        
           MOVE AT-DATE-BILL-DAY-00   TO E-FCA227-DATE-BILL-DAY-00.     
           MOVE AT-DATE-BILL-DAY-30   TO E-FCA227-DATE-BILL-DAY-30.     
           MOVE AT-DATE-BILL-DAY-60   TO E-FCA227-DATE-BILL-DAY-60.     
           MOVE AT-DATE-BILL-DAY-90   TO E-FCA227-DATE-BILL-DAY-90.     
           MOVE AT-CREDIT-GROUP       TO E-FCA227-CREDIT-GROUP.         
           MOVE AT-CODE-ACCT-STAT     TO E-FCA227-CODE-ACCT-STAT.       
           MOVE AT-CODE-STATUS-REASON TO E-FCA227-CODE-STATUS-REASON.   
           MOVE AT-IVR-EXEMPT-CD      TO E-FCA227-IVR-EXEMPT-CD.        
      *                                                                         
T30169 4100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS40420
      *  6240-GET-FCA00-COMMON-DATE                                    *PCS40440
      ******************************************************************PCS40480
       COPY CPD00040.                                                           
      ******************************************************************PCS40420
      *  6251-GET-FJC01-DATE                                           *PCS40440
      ******************************************************************PCS40480
       COPY CPD00037.                                                   PCS40380
      *                                                                         
T32596******************************************************************PCS40420
T32596*     7110-GET-REG-GROUP-CD                                      *PCS40440
T32596*     THIS STEP GOES AND GETS THE REGULATED GROUP CODE.          *PCS40450
T32596******************************************************************PCS40480
T32596 7110-GET-REG-GROUP-CD.                                           
T32596*                                                                 15169400
T32596     EXEC SQL                                                     
T32596         SELECT                                                   
T32596              REG_GROUP_CD                                        
T32596         INTO                                                     
T32596             :LR-REG-GROUP-CD                                     
T32596        FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                        
T32596        WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                         
                                                                 
T32596     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15169500
MFA-TR*        SELECT                                                   15169600
MFA-TR*             REG_GROUP_CD                                        15169700
MFA-TR*        INTO                                                     15170300
MFA-TR*            :LR-REG-GROUP-CD                                     15170400
MFA-TR*       FROM CSS_REG_PROFILE                                      15171000
MFA-TR*       WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                         15171100
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    15171200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T32596*                                                                 15171300
T32596     IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
T32596         IF SQLCODE EQUAL NOT-FOUND                               
T32596             MOVE SPACES      TO LR-REG-GROUP-CD                  
T32596         END-IF                                                   
T32596     ELSE                                                         
T32596         MOVE SQLCODE TO WS-DISPLAY-RC                            
T32596         DISPLAY '*****************PCSCA226******************'    
T32596         DISPLAY '* 7110 : RETURN CODE ERROR                *'    
T32596         DISPLAY '*        RC = ' WS-DISPLAY-RC                   
T32596         DISPLAY '* ACCOUNT NO = ' LR-ACCOUNT-NO                  
T32596         DISPLAY '* PROGRAM ABENDING...                     *'    
T32596         DISPLAY '*****************PCSCA226******************'    
T32596         PERFORM 9900-ABEND  THRU  9900-EXIT                      
T32596     END-IF.                                                      
T32596*                                                                 15172600
T32596 7110-EXIT.                                                       
T32596     EXIT.                                                        
T32596*                                                                         
      ******************************************************************PCS40420
      *                                                                *PCS40430
      *      7200-CHECK-CA-EXEMPT                                      *PCS40440
      *                                                                *PCS40450
      ******************************************************************PCS40480
      *                                                                         
T30169 7200-CHECK-CA-EXEMPT.                                            
                                                                        
           EXEC SQL                                                     
                SELECT                                                  
                     ATTRIBUTE_VALUE_CD                                 
                INTO                                                    
                    :YP-ATTRIBUTE-VALUE-CD                              
                FROM                                                    
                     CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                   
                WHERE                                                   
                    ACCOUNT_NO     = :YP-ACCOUNT-NO                     
                AND ATTRIBUTE_DESC = 'CAEXEMPT'                         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*              ATTRIBUTE_VALUE_CD                                         
MFA-TR*         INTO                                                            
MFA-TR*             :YP-ATTRIBUTE-VALUE-CD                                      
MFA-TR*         FROM                                                            
MFA-TR*              CSS_ACCT_ATTRIBUTE                                         
MFA-TR*         WHERE                                                           
MFA-TR*             ACCOUNT_NO     = :YP-ACCOUNT-NO                             
MFA-TR*         AND ATTRIBUTE_DESC = 'CAEXEMPT'                                 
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
              IF SQLCODE EQUAL SUCCESSFUL-CALL AND                      
                 YP-ATTRIBUTE-VALUE-CD > SPACES                         
                 SET CA-EXCEMPT-EXIST       TO TRUE                     
              END-IF                                                    
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA226******************'    
               DISPLAY '* 7200 : RETURN CODE ERROR                *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* ACCOUNT NO = ' YP-ACCOUNT-NO                  
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA226******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS40420
      *                                                                *PCS40430
      *      7250-CHECK-DECEASED-ACCOUNT                               *PCS40440
      *                                                                *PCS40450
      ******************************************************************PCS40480
      *                                                                         
T30169 7250-CHECK-DECEASED-ACCOUNT.                                     
                                                                        
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                               
                INTO                                                    
                    :CO-CODE-CHG-OFF-REAS                               
                FROM                                                    
                     CSS_CHRG_OFF WITH(READUNCOMMITTED)                         
                WHERE                                                   
                    ACCOUNT_NO        = :CO-ACCOUNT-NO                  
                AND CODE_CHG_OFF_REAS = 'F'                             
                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*             'Y'                                                         
MFA-TR*         INTO                                                            
MFA-TR*             :CO-CODE-CHG-OFF-REAS                                       
MFA-TR*         FROM                                                            
MFA-TR*              CSS_CHRG_OFF                                               
MFA-TR*         WHERE                                                           
MFA-TR*             ACCOUNT_NO        = :CO-ACCOUNT-NO                          
MFA-TR*         AND CODE_CHG_OFF_REAS = 'F'                                     
MFA-TR*         FETCH FIRST 1 ROW ONLY WITH UR                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
              IF SQLCODE EQUAL SUCCESSFUL-CALL                          
                 SET DECEASED-ACCOUNT       TO TRUE                     
              END-IF                                                    
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA226******************'    
               DISPLAY '* 7250 : RETURN CODE ERROR                *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* ACCOUNT NO = ' CO-ACCOUNT-NO                  
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA226******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS40420
      *                                                                *PCS40430
      *      7275-CHECK-ARRANGEMENT                                    *PCS40440
      *                                                                *PCS40450
      ******************************************************************PCS40480
      *                                                                         
T30169 7275-CHECK-ARRANGEMENT.                                          
                                                                        
                                                                        
           EXEC SQL                                                     
                SELECT                                                  
                     WO_MAX_BALANCE                                     
                INTO                                                    
                    :WG-WO-MAX-BALANCE                                  
                FROM                                                    
                     CSS_WO_ARRANGEMENT WITH(READUNCOMMITTED)                   
                WHERE                                                   
                    ACCOUNT_NO        = :WG-ACCOUNT-NO                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*              WO_MAX_BALANCE                                             
MFA-TR*         INTO                                                            
MFA-TR*             :WG-WO-MAX-BALANCE                                          
MFA-TR*         FROM                                                            
MFA-TR*              CSS_WO_ARRANGEMENT                                         
MFA-TR*         WHERE                                                           
MFA-TR*             ACCOUNT_NO        = :WG-ACCOUNT-NO                          
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
A01823        IF SQLCODE EQUAL SUCCESSFUL-CALL                          
A01823           IF WS-WRITE-OFF-BALANCE > WG-WO-MAX-BALANCE            
A01823              MOVE WS-N       TO WS-ARRANGEMENT-EXIST             
A01823           ELSE                                                   
A01823              MOVE WS-Y       TO WS-ARRANGEMENT-EXIST             
A01823           END-IF                                                 
              END-IF                                                    
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA226******************'    
               DISPLAY '* 7275 : RETURN CODE ERROR                *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* ACCOUNT NO = ' WG-ACCOUNT-NO                  
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA226******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7275-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS40420
      *                                                                *PCS40430
      *      7300-OPEN-FW-COLL-CREDB-ACCTS                             *PCS40440
      *                                                                *PCS40450
      ******************************************************************PCS40480
      *                                                                         
       7300-OPEN-FW-COLL-CREDB-ACCTS.                                   
           EXEC SQL                                                     
                OPEN FW_COLL_CREDB_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF  SQLCODE EQUAL SUCCESSFUL-CALL                            
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA226******************'    
               DISPLAY '* 7300 : OPEN ERROR FW_COLL_CREDB_CUR      *'   
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABEND                           *'    
               DISPLAY '*****************PCSCA226******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS40420
      *                                                                *PCS40430
      *     7310-FETCH-FW-COLL-CREDB-ACCTS                             *PCS40440
      *                                                                *PCS40450
      *                                                                *PCS40470
      ******************************************************************PCS40480
      *                                                                         
T30169 7310-FETCH-FW-COLL-CREDB-ACCTS.                                  
           EXEC SQL                                                     
              FETCH                                                     
                  FW_COLL_CREDB_CUR                                     
              INTO                                                      
T30169            :KD-FW-ACTION-TYPE-CD,                                
T30169            :KD-FW-SEQ-NO,                                        
T30169            :KD-FW-ACTION-DT,                                     
T30169            :KD-FW-ACTION-AM,                                     
                  :AT-ACCOUNT-NO,                                       
                  :AT-COMPANY-NO,                                       
                  :AT-LOCAL-OFFICE,                                     
                  :AT-PREMISE-NO,                                       
                  :AT-CUSTOMER-NO,                                      
                  :AT-ACCOUNT-TYPE-CODE,                                
                  :AT-ACCT-CREATE-DT :WS-ACCT-CREATE-DT-NULL,           
                  :AT-ACCT-FINALED-DT :WS-ACCT-FINALED-DT-NULL,         
                  :AT-ADDRESS-FORMAT,                                   
                  :AT-ADDRESS-ID,                                       
                  :AT-BILL-CYCLE,                                       
                  :AT-CODES-DATA-PRESENT,                               
                  :AT-LAST-PYMT-DATE :WS-LAST-PYMT-DATE-NULL,          
T30169            :AT-LAST-PYMT-AMOUNT,                                 
                  :AT-TOTAL-AR-BALANCE,                                 
                  :AT-DATE-BILL-DAY-00 :WS-DATE-BILL-DAY-00-NULL,       
                  :AT-DATE-BILL-DAY-30 :WS-DATE-BILL-DAY-30-NULL,       
                  :AT-DATE-BILL-DAY-60 :WS-DATE-BILL-DAY-60-NULL,       
                  :AT-DATE-BILL-DAY-90 :WS-DATE-BILL-DAY-90-NULL,       
T11937            :AT-BANKRUPTCY-IND,                                   
                  :AT-CODE-DISC-OK,                                     
                  :AT-NOTICE-EXEMPT-CD,                                 
                  :AT-CODE-ACCT-STAT,                                   
                  :AT-CREDIT-GROUP,                                     
T13565            :AT-CODE-STATUS-REASON,                               
T23230            :AT-JUDGEMENT-IND,                                    
C28788            :AT-IVR-EXEMPT-CD                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29891*                                                                         
C29891     IF SQLCODE EQUAL SUCCESSFUL-CALL AND                         
C29891                      (AT-LOCAL-OFFICE = '301' OR                 
C29891                       AT-LOCAL-OFFICE = '302' OR                 
C29891                       AT-LOCAL-OFFICE = '303')                   
C30169         GO TO 7310-FETCH-FW-COLL-CREDB-ACCTS                     
C29891     END-IF                                                       
      *                                                                         
           IF  SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND               
               IF WS-LAST-PYMT-DATE-NULL < 0                            
                   MOVE SPACES      TO AT-LAST-PYMT-DATE                
               END-IF                                                   
               IF WS-ACCT-CREATE-DT-NULL < 0                            
                   MOVE SPACES      TO AT-ACCT-CREATE-DT                
               END-IF                                                   
               IF WS-ACCT-FINALED-DT-NULL < 0                           
                   MOVE SPACES      TO AT-ACCT-FINALED-DT               
               END-IF                                                   
               IF WS-DATE-BILL-DAY-00-NULL < 0                          
                   MOVE SPACES      TO AT-DATE-BILL-DAY-00              
               END-IF                                                   
               IF WS-DATE-BILL-DAY-30-NULL < 0                          
                   MOVE SPACES      TO AT-DATE-BILL-DAY-30              
               END-IF                                                   
               IF WS-DATE-BILL-DAY-60-NULL < 0                          
                   MOVE SPACES      TO AT-DATE-BILL-DAY-60              
               END-IF                                                   
               IF WS-DATE-BILL-DAY-90-NULL < 0                          
                   MOVE SPACES      TO AT-DATE-BILL-DAY-90              
               END-IF                                                   
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA226******************'    
               DISPLAY '* 7310 : FETCH FW_COLL_CREDB_CUR  ERROR    *'   
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA226******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS41920
      *                                                                *PCS41930
      *     7320-CLOSE-FW-COLL-CREDB-ACCTS                             *PCS41940
      *                                                                *PCS41950
      ******************************************************************PCS41960
       7320-CLOSE-FW-COLL-CREDB-ACCTS.                                  
      *                                                                         
           EXEC SQL                                                     
                CLOSE FW_COLL_CREDB_CUR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF  SQLCODE EQUAL SUCCESSFUL-CALL                            
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA226******************'    
               DISPLAY '* 7320 : CLOSE FW_COLL_CREDB_CUR  ERROR    *'   
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA226******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************      P 
      *                                                                *      P 
      *      7400-GET-CZ-CR-BUR-DT                                     *      P 
      *                                                                *      P 
      ******************************************************************      P 
T30169 7400-GET-CZ-CR-BUR-DT.                                           
                                                                        
           EXEC SQL                                                     
                SELECT                                                  
                    CR_BUR_RPT_DT                                       
                INTO                                                    
                    :WS-CZ-CR-BUR-RPT-DT :WS-CZ-CR-BUR-RPT-NULL          
                FROM                                                    
                    CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                    
                WHERE                                                   
                    ACCOUNT_NO        = :AT-ACCOUNT-NO                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*             CR_BUR_RPT_DT                                               
MFA-TR*         INTO                                                            
MFA-TR*             :WS-CZ-CR-BUR-RPT-DT:WS-CZ-CR-BUR-RPT-NULL                  
MFA-TR*         FROM                                                            
MFA-TR*             CSS_CREDIT_PROFILE                                          
MFA-TR*         WHERE                                                           
MFA-TR*             ACCOUNT_NO        = :AT-ACCOUNT-NO                          
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF  SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND               
               IF SQLCODE = NOT-FOUND OR WS-CZ-CR-BUR-RPT-NULL < 0      
                  MOVE SPACES                TO WS-CZ-CR-BUR-RPT-DT     
               END-IF                                                   
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA226******************'    
               DISPLAY '* 7400 : SELECT ERROR CSS_CREDIT_PROFILE  *'    
               DISPLAY '*         RC = ' WS-DISPLAY-RC                  
               DISPLAY '* ACCOUNT NO = ' AT-ACCOUNT-NO                  
               DISPLAY '* PROGRAM ABEND                           *'    
               DISPLAY '*****************PCSCA226******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
                                                                        
T30169 7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************      P 
      *                                                                *      P 
      *      7500-GET-FW-ACTION-DETAILS                                *      P 
      *                                                                *      P 
      ******************************************************************      P 
T30169 7500-GET-FW-ACTION-DETAILS.                                      
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) FW_ACTION_DT,
              FW_ACTION_AM                                        
                INTO                                                    
                    :WS-FW-ACTION-DT                                    
                   ,:WS-FW-ACTION-AM                                    
                FROM                                                    
                    CSS_FIN_WO_ACTION WITH(READUNCOMMITTED)                     
                WHERE                                                   
                    ACCOUNT_NO        = :AT-ACCOUNT-NO                  
                AND FW_ACTION_TYPE_CD = :WS-FW-ACTION-TYPE-CD           
                ORDER BY FW_SEQ_NO DESC                                 
                                          
                                                                        
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*             FW_ACTION_DT                                                
MFA-TR*            ,FW_ACTION_AM                                                
MFA-TR*         INTO                                                            
MFA-TR*             :WS-FW-ACTION-DT                                            
MFA-TR*            ,:WS-FW-ACTION-AM                                            
MFA-TR*         FROM                                                            
MFA-TR*             CSS_FIN_WO_ACTION                                           
MFA-TR*         WHERE                                                           
MFA-TR*             ACCOUNT_NO        = :AT-ACCOUNT-NO                          
MFA-TR*         AND FW_ACTION_TYPE_CD = :WS-FW-ACTION-TYPE-CD                   
MFA-TR*         ORDER BY FW_SEQ_NO DESC                                         
MFA-TR*         FETCH FIRST 1 ROWS ONLY WITH UR                                 
MFA-TR*                                                                         
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF  SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND               
               IF SQLCODE = NOT-FOUND                                   
                  MOVE SPACES                TO WS-FW-ACTION-DT         
                  MOVE ZEROS                 TO WS-FW-ACTION-AM         
               END-IF                                                   
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA226******************'    
               DISPLAY '* 7500 : SELECT ERROR CSS_FIN_WO_ACTION   *'    
               DISPLAY '*         RC = ' WS-DISPLAY-RC                  
               DISPLAY '* ACCOUNT NO = ' AT-ACCOUNT-NO                  
               DISPLAY '* FW SEQ NO  = ' KD-FW-SEQ-NO                   
               DISPLAY '* FW ACTION  = ' WS-FW-ACTION-TYPE-CD           
               DISPLAY '* PROGRAM ABEND                           *'    
               DISPLAY '*****************PCSCA226******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
                                                                        
T30169 7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************      P 
      *                                                                *      P 
      *      7550-GET-COLL-AGENCY                                      *      P 
      *                                                                *      P 
      ******************************************************************      P 
T30169 7550-GET-COLL-AGENCY.                                            
                                                                        
           EXEC SQL                                                     
                SELECT                                                  
                    CODE_COLLEC_AGNCY                                   
                   ,COLL_AGY_SUB_CD                                     
                INTO                                                    
                    :IZ-CODE-COLLEC-AGNCY :WS-COLL-AGNCY-CD-NULL         
                   ,:IZ-COLL-AGY-SUB-CD :WS-COLL-AGY-SUB-CD-NULL         
                FROM                                                    
                    CSS_FIN_WO_COLLECT WITH(READUNCOMMITTED)                    
                WHERE                                                   
                    ACCOUNT_NO        = :IZ-ACCOUNT-NO                  
                AND FW_ACTION_TYPE_CD = :IZ-FW-ACTION-TYPE-CD           
                AND FW_COLL_SEQ_NO    = :IZ-FW-COLL-SEQ-NO              
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*             CODE_COLLEC_AGNCY                                           
MFA-TR*            ,COLL_AGY_SUB_CD                                             
MFA-TR*         INTO                                                            
MFA-TR*             :IZ-CODE-COLLEC-AGNCY:WS-COLL-AGNCY-CD-NULL                 
MFA-TR*            ,:IZ-COLL-AGY-SUB-CD:WS-COLL-AGY-SUB-CD-NULL                 
MFA-TR*         FROM                                                            
MFA-TR*             CSS_FIN_WO_COLLECT                                          
MFA-TR*         WHERE                                                           
MFA-TR*             ACCOUNT_NO        = :IZ-ACCOUNT-NO                          
MFA-TR*         AND FW_ACTION_TYPE_CD = :IZ-FW-ACTION-TYPE-CD                   
MFA-TR*         AND FW_COLL_SEQ_NO    = :IZ-FW-COLL-SEQ-NO                      
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF  SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND               
               IF SQLCODE = NOT-FOUND                                   
                  MOVE SPACES                TO IZ-CODE-COLLEC-AGNCY    
                  MOVE SPACES                TO IZ-COLL-AGY-SUB-CD      
               END-IF                                                   
               IF WS-COLL-AGNCY-CD-NULL < 0                             
                  MOVE +0                    TO WS-COLL-AGNCY-CD-NULL   
                  MOVE SPACES                TO IZ-CODE-COLLEC-AGNCY    
               END-IF                                                   
               IF WS-COLL-AGNCY-CD-NULL < 0                             
                  MOVE +0                    TO WS-COLL-AGY-SUB-CD-NULL 
                  MOVE SPACES                TO IZ-COLL-AGY-SUB-CD      
               END-IF                                                   
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA226******************'    
               DISPLAY '* 7550 : SELECT ERROR CSS_FIN_WO_COLLECT  *'    
               DISPLAY '*         RC = ' WS-DISPLAY-RC                  
               DISPLAY '* ACCOUNT NO = ' IZ-ACCOUNT-NO                  
               DISPLAY '* ACTION CD  = ' IZ-FW-ACTION-TYPE-CD           
               DISPLAY '*   SEQ NO   = ' IZ-FW-COLL-SEQ-NO              
               DISPLAY '* PROGRAM ABEND                           *'    
               DISPLAY '*****************PCSCA226******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
                                                                        
T30169 7550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************      P 
      *                                                                *      P 
      *      7560-GET-COLL-AGENCY-HST                                  *      P 
      *                                                                *      P 
      ******************************************************************      P 
T30169 7560-GET-COLL-AGENCY-HST.                                        
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) CODE_COLLEC_AGNCY,
              COLL_AGY_SUB_CD                                     
                INTO                                                    
                    :FM-CODE-COLLEC-AGNCY                               
                   ,:FM-COLL-AGY-SUB-CD                                 
                FROM                                                    
                    CSS_FIN_WO_COL_HST WITH(READUNCOMMITTED)                    
                WHERE                                                   
                    ACCOUNT_NO        = :FM-ACCOUNT-NO                  
                AND FW_ACTION_TYPE_CD = :FM-FW-ACTION-TYPE-CD           
                ORDER BY FW_HIST_SEQ_TS DESC                            
                                           
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*             CODE_COLLEC_AGNCY                                           
MFA-TR*            ,COLL_AGY_SUB_CD                                             
MFA-TR*         INTO                                                            
MFA-TR*             :FM-CODE-COLLEC-AGNCY                                       
MFA-TR*            ,:FM-COLL-AGY-SUB-CD                                         
MFA-TR*         FROM                                                            
MFA-TR*             CSS_FIN_WO_COL_HST                                          
MFA-TR*         WHERE                                                           
MFA-TR*             ACCOUNT_NO        = :FM-ACCOUNT-NO                          
MFA-TR*         AND FW_ACTION_TYPE_CD = :FM-FW-ACTION-TYPE-CD                   
MFA-TR*         ORDER BY FW_HIST_SEQ_TS DESC                                    
MFA-TR*         FETCH FIRST 1 ROW ONLY WITH UR                                  
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF  SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND               
               IF SQLCODE = NOT-FOUND                                   
                  MOVE SPACES                TO FM-CODE-COLLEC-AGNCY    
                  MOVE SPACES                TO FM-COLL-AGY-SUB-CD      
               END-IF                                                   
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA226******************'    
               DISPLAY '* 7560 : SELECT ERROR CSS_FIN_WO_COL_HST  *'    
               DISPLAY '*         RC = ' WS-DISPLAY-RC                  
               DISPLAY '* ACCOUNT NO = ' FM-ACCOUNT-NO                  
               DISPLAY '* ACTION CD  = ' FM-FW-ACTION-TYPE-CD           
               DISPLAY '* PROGRAM ABEND                           *'    
               DISPLAY '*****************PCSCA226******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
                                                                        
T30169 7560-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************      P 
      *                                                                *      P 
      *      7565-GET-COLL-AGNCY-OTHR-ACCT                             *      P 
      *                                                                *        
      *      GET COLL AGENCY FROM OTHER ACTIVELY PLACED ACCOUNTS FOR   *        
      *      THE SAME CUSTOMER NO                                      *        
      *                                                                *      P 
      ******************************************************************      P 
T30169 7565-GET-COLL-AGNCY-OTHR-ACCT.                                   
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) IZ.CODE_COLLEC_AGNCY,
              IZ.COLL_AGY_SUB_CD                                  
                INTO                                                    
                    :IZ-CODE-COLLEC-AGNCY                               
                   ,:IZ-COLL-AGY-SUB-CD                                 
                FROM                                                    
A01700              CSS_FIN_WO_COLLECT IZ WITH(READUNCOMMITTED)                 
A01700             ,CSS_FIN_WO_ACTION KD WITH(READUNCOMMITTED)                  
                WHERE                                                   
A01700           IZ.ACCOUNT_NO       <> :IZ-ACCOUNT-NO                  
A01700          AND KD.ACCOUNT_NO     = IZ.ACCOUNT_NO                   
A01700          AND KD.FW_SEQ_NO      = IZ.FW_COLL_SEQ_NO               
A01700          AND KD.FW_ACTION_TYPE_CD = IZ.FW_ACTION_TYPE_CD         
A01700          AND KD.FW_ACTION_AM > 0                                 
A01700          AND IZ.FW_ACTION_TYPE_CD = :IZ-FW-ACTION-TYPE-CD        
A01700          AND IZ.CUSTOMER_NO       = :IZ-CUSTOMER-NO              
A01700          AND ( IZ.WITHDRAW_DT     > IIF(TRY_CONVERT(DATE, 
                                                        :IZ-WITHDRAW-DT
              ) IS NULL OR (PATINDEX('%.%', :IZ-WITHDRAW-DT
              ) <> 0) OR (LEN(:IZ-WITHDRAW-DT) <> 10), CIS.CHAR2DATE(
                                                        :IZ-WITHDRAW-DT
              ), CONVERT(DATE, :IZ-WITHDRAW-DT) ) OR           
A01700                IZ.WITHDRAW_DT IS NULL )                          
A01700          ORDER BY KD.FW_ACTION_DT DESC                           
                                           
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*             IZ.CODE_COLLEC_AGNCY                                        
MFA-TR*            ,IZ.COLL_AGY_SUB_CD                                          
MFA-TR*         INTO                                                            
MFA-TR*             :IZ-CODE-COLLEC-AGNCY                                       
MFA-TR*            ,:IZ-COLL-AGY-SUB-CD                                         
MFA-TR*         FROM                                                            
MFA-TR*             CSS_FIN_WO_COLLECT IZ                                       
MFA-TR*            ,CSS_FIN_WO_ACTION KD                                        
MFA-TR*         WHERE                                                           
MFA-TR*          IZ.ACCOUNT_NO       <> :IZ-ACCOUNT-NO                          
MFA-TR*         AND KD.ACCOUNT_NO     = IZ.ACCOUNT_NO                           
MFA-TR*         AND KD.FW_SEQ_NO      = IZ.FW_COLL_SEQ_NO                       
MFA-TR*         AND KD.FW_ACTION_TYPE_CD = IZ.FW_ACTION_TYPE_CD                 
MFA-TR*         AND KD.FW_ACTION_AM > 0                                         
MFA-TR*         AND IZ.FW_ACTION_TYPE_CD = :IZ-FW-ACTION-TYPE-CD                
MFA-TR*         AND IZ.CUSTOMER_NO       = :IZ-CUSTOMER-NO                      
MFA-TR*         AND ( IZ.WITHDRAW_DT     > :IZ-WITHDRAW-DT OR                   
MFA-TR*               IZ.WITHDRAW_DT IS NULL )                                  
MFA-TR*         ORDER BY KD.FW_ACTION_DT DESC                                   
MFA-TR*         FETCH FIRST 1 ROW ONLY WITH UR                                  
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF  SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND               
               IF SQLCODE = NOT-FOUND                                   
A01700            MOVE SPACES                TO IZ-CODE-COLLEC-AGNCY    
A01700            MOVE SPACES                TO IZ-COLL-AGY-SUB-CD      
               END-IF                                                   
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA226******************'    
               DISPLAY '* 7565 : SELECT ERROR CSS_FIN_WO_COLLECT  *'    
               DISPLAY '*         RC = ' WS-DISPLAY-RC                  
               DISPLAY '* ACCOUNT NO = ' IZ-ACCOUNT-NO                  
               DISPLAY '* ACTION CD  = ' IZ-FW-ACTION-TYPE-CD           
               DISPLAY '* CUSTOMER   = ' IZ-CUSTOMER-NO                 
               DISPLAY '* PROGRAM ABEND                           *'    
               DISPLAY '*****************PCSCA226******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
                                                                        
T30169 7565-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************      P 
      *                                                                *      P 
      *      7570-GET-EXCHANGE-INFO-EXIST                              *      P 
      *      CHECK WHETHER EXCHANGE INFO EXISTS                        *        
      *                                                                *      P 
      ******************************************************************      P 
T30169 7570-GET-EXCHANGE-INFO-EXIST.                                    
                                                                        
           MOVE 'N'                        TO WS-EXCH-INFO-EXIST        
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                               
                INTO                                                    
                    :WS-EXCH-INFO-EXIST                                 
                FROM                                                    
                    CSS_EXCH_DATA_RECV WITH(READUNCOMMITTED)                    
                WHERE                                                   
                    ACCOUNT_NO        =  :EL-ACCOUNT-NO                 
                AND EXCH_REPORT_DT    >= IIF(TRY_CONVERT(DATE, 
                                                     :EL-EXCH-REPORT-DT
              ) IS NULL OR (PATINDEX('%.%', :EL-EXCH-REPORT-DT
              ) <> 0) OR (LEN(:EL-EXCH-REPORT-DT
              ) <> 10), CIS.CHAR2DATE(:EL-EXCH-REPORT-DT
              ), CONVERT(DATE, :EL-EXCH-REPORT-DT) )             
                                           
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*             'Y'                                                         
MFA-TR*         INTO                                                            
MFA-TR*             :WS-EXCH-INFO-EXIST                                         
MFA-TR*         FROM                                                            
MFA-TR*             CSS_EXCH_DATA_RECV                                          
MFA-TR*         WHERE                                                           
MFA-TR*             ACCOUNT_NO        =  :EL-ACCOUNT-NO                         
MFA-TR*         AND EXCH_REPORT_DT    >= :EL-EXCH-REPORT-DT                     
MFA-TR*         FETCH FIRST 1 ROW ONLY WITH UR                                  
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF  SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA226******************'    
               DISPLAY '* 7570 : SELECT ERROR CSS_EXCH_DATA_RECV  *'    
               DISPLAY '*         RC = ' WS-DISPLAY-RC                  
               DISPLAY '* ACCOUNT NO = ' AT-ACCOUNT-NO                  
               DISPLAY '* PROGRAM ABEND                           *'    
               DISPLAY '*****************PCSCA226******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
                                                                        
T30169 7570-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************      P 
      *                                                                *      P 
      *      7575-GET-WO-BAL                                           *      P 
      *                                                                *      P 
      ******************************************************************      P 
T30169 7575-GET-WO-BAL.                                                 
                                                                        
           EXEC SQL                                                     
                SELECT                                                  
                    SUM(AMT_TRANS)                                      
P00160             ,COALESCE(SUM(WO_ORIGINAL_AM),0)                       
                INTO                                                    
                    :CO-AMT-TRANS :WS-CO-AMT-TRANS-NULL                  
P00160             ,:CO-WO-ORIGINAL-AM                                  
                FROM                                                    
                    CSS_CHRG_OFF WITH(READUNCOMMITTED)                          
                WHERE                                                   
                    ACCOUNT_NO        = :CO-ACCOUNT-NO                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*             SUM(AMT_TRANS)                                              
MFA-TR*            ,IFNULL(SUM(WO_ORIGINAL_AM),0)                               
MFA-TR*         INTO                                                            
MFA-TR*             :CO-AMT-TRANS:WS-CO-AMT-TRANS-NULL                          
MFA-TR*            ,:CO-WO-ORIGINAL-AM                                          
MFA-TR*         FROM                                                            
MFA-TR*             CSS_CHRG_OFF                                                
MFA-TR*         WHERE                                                           
MFA-TR*             ACCOUNT_NO        = :CO-ACCOUNT-NO                          
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF  SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND               
               IF SQLCODE = NOT-FOUND OR WS-CO-AMT-TRANS-NULL < 0       
                  MOVE ZERO                  TO CO-AMT-TRANS            
                                                WS-CO-AMT-TRANS-NULL    
               END-IF                                                   
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA226******************'    
               DISPLAY '* 7575 : SELECT ERROR CSS_CHRG_OFF        *'    
               DISPLAY '*         RC = ' WS-DISPLAY-RC                  
               DISPLAY '* ACCOUNT NO = ' CO-ACCOUNT-NO                  
               DISPLAY '* PROGRAM ABEND                           *'    
               DISPLAY '*****************PCSCA226******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
                                                                        
T30169 7575-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************      P 
      *                                                                *      P 
      * 7580-SELECT-DELINQ-VALUE                                       *      P 
      *                                                                *      P 
      ******************************************************************      P 
T30169 7580-SELECT-DELINQ-VALUE.                                        
                                                                        
           EXEC SQL                                                     
              SELECT  DELINQ_VALUE                                      
              INTO    :C8-DELINQ-VALUE                                  
              FROM    CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
              WHERE   DELINQ_CD  = :C8-DELINQ-CD                        
              AND     COMPANY_NO = :C8-COMPANY-NO                       
A01823                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DELINQ_VALUE                                              
MFA-TR*       INTO    :C8-DELINQ-VALUE                                          
MFA-TR*       FROM    CSS_DELINQUENCY                                           
MFA-TR*       WHERE   DELINQ_CD  = :C8-DELINQ-CD                                
MFA-TR*       AND     COMPANY_NO = :C8-COMPANY-NO                               
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF  SQLCODE EQUAL SUCCESSFUL-CALL                            
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA226******************'    
               DISPLAY '* 7580 : SELECT ERROR CSS_DELINQUENCY     *'    
               DISPLAY '*         RC = ' WS-DISPLAY-RC                  
               DISPLAY '* DELINQ CD  = ' C8-DELINQ-CD                   
               DISPLAY '* PROGRAM ABEND                           *'    
               DISPLAY '*****************PCSCA226******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
                                                                        
T30169 7580-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A280  ******************************************************************      P 
A280  *                                                                *      P 
A280  *      7585-GET-COLL-AGNCY-ASSIGN                                *      P 
A280  *                                                                *        
A280  *      GET THE ACTIVE COLL AGENCY                                *        
A280  *                                                                *        
A280  ******************************************************************      P 
A280   7585-GET-COLL-AGNCY-ASSIGN.                                      
A280                                                                    
A280       EXEC SQL                                                     
A280            SELECT                                                  
A280                CODE_COLLEC_AGNCY                                   
A280               ,COLL_AGENCY_SUB_CD                                  
A280            INTO                                                    
A280                :KU-CODE-COLLEC-AGNCY                               
A280               ,:KU-COLL-AGENCY-SUB-CD                              
A280            FROM                                                    
A280                CSS_COLL_AGY_ASSGN WITH(READUNCOMMITTED)                    
A280            WHERE                                                   
A280                COMPANY_NO         = :KU-COMPANY-NO                 
A280            AND REG_GROUP_CD       = :KU-REG-GROUP-CD               
A280            AND COLL_ACCT_TYPE_CD  = :KU-COLL-ACCT-TYPE-CD          
A280            AND FW_ACTION_TYPE_CD  = :KU-FW-ACTION-TYPE-CD          
A280            AND CODE_COLLEC_AGNCY  = :KU-CODE-COLLEC-AGNCY          
A280            AND COLL_AGENCY_SUB_CD = :KU-COLL-AGENCY-SUB-CD         
A280            AND EFFECTIVE_DATE    <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )                 
A280            AND EXPIRATION_DT     >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )                 
A280                                                             
A280       END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*             CODE_COLLEC_AGNCY                                           
MFA-TR*            ,COLL_AGENCY_SUB_CD                                          
MFA-TR*         INTO                                                            
MFA-TR*             :KU-CODE-COLLEC-AGNCY                                       
MFA-TR*            ,:KU-COLL-AGENCY-SUB-CD                                      
MFA-TR*         FROM                                                            
MFA-TR*             CSS_COLL_AGY_ASSGN                                          
MFA-TR*         WHERE                                                           
MFA-TR*             COMPANY_NO         = :KU-COMPANY-NO                         
MFA-TR*         AND REG_GROUP_CD       = :KU-REG-GROUP-CD                       
MFA-TR*         AND COLL_ACCT_TYPE_CD  = :KU-COLL-ACCT-TYPE-CD                  
MFA-TR*         AND FW_ACTION_TYPE_CD  = :KU-FW-ACTION-TYPE-CD                  
MFA-TR*         AND CODE_COLLEC_AGNCY  = :KU-CODE-COLLEC-AGNCY                  
MFA-TR*         AND COLL_AGENCY_SUB_CD = :KU-COLL-AGENCY-SUB-CD                 
MFA-TR*         AND EFFECTIVE_DATE    <= :WS-INPUT-DATE                         
MFA-TR*         AND EXPIRATION_DT     >= :WS-INPUT-DATE                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A280                                                                    
A280       IF  SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND               
A280           IF SQLCODE = NOT-FOUND                                   
A280              MOVE SPACES                TO KU-CODE-COLLEC-AGNCY    
A280              MOVE SPACES                TO KU-COLL-AGENCY-SUB-CD   
A280           END-IF                                                   
A280       ELSE                                                         
A280           MOVE SQLCODE TO WS-DISPLAY-RC                            
A280           DISPLAY '*****************PCSCA226******************'    
A280           DISPLAY '* 7585 : SELECT ERROR CSS_COLL_AGY_ASSGN  *'    
A280           DISPLAY '*         RC    = ' WS-DISPLAY-RC               
A280           DISPLAY '* ACCOUNT NO    = ' IZ-ACCOUNT-NO               
A280           DISPLAY '* COLL AGENCY   = ' KU-CODE-COLLEC-AGNCY        
A280           DISPLAY '* AGENCY SUB CD = ' KU-COLL-AGENCY-SUB-CD       
A280           DISPLAY '* CUSTOMER      = ' IZ-CUSTOMER-NO              
A280           DISPLAY '* PROGRAM ABEND                           *'    
A280           DISPLAY '*****************PCSCA226******************'    
A280           PERFORM 9900-ABEND  THRU  9900-EXIT                      
A280       END-IF.                                                      
A280                                                                    
A280   7585-EXIT.                                                       
A280       EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************      P 
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00038                                          PCS42650
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE CPD00039                                          PCS42650
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************PCS40420
      *                                                                *PCS40430
      *     7700-OPEN-DEL-N-UTIL-ACCTS                                 *PCS40440
      *                                                                *PCS40450
      *                                                                *PCS40470
      ******************************************************************PCS40480
      *                                                                         
       7700-OPEN-DEL-N-UTIL-ACCTS.                                      
      *                                                                 15169400
           EXEC SQL                                                     
              OPEN DEL_NON_UTIL_CRSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA226********************'  
               DISPLAY '* 7700 : ERROR ON OPEN OF DEL_NON_UTIL_CRSR *'  
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABENDING...                       *'  
               DISPLAY '*****************PCSCA226********************'  
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS40420
      *                                                                *PCS40430
      *     7710-FETCH-DEL-N-UTIL-ACCT                                 *PCS40440
      *                                                                *PCS40450
      *                                                                *PCS40470
      ******************************************************************PCS40480
      *                                                                         
       7710-FETCH-DEL-N-UTIL-ACCT.                                      
      *                                                                 15169400
           EXEC SQL                                                     
              FETCH                                                     
                  DEL_NON_UTIL_CRSR                                     
              INTO                                                      
                  :AT-ACCOUNT-NO,                                       
                  :AT-COMPANY-NO,                                       
                  :AT-LOCAL-OFFICE,                                     
                  :AT-PREMISE-NO,                                       
                  :AT-CUSTOMER-NO,                                      
                  :AT-ACCOUNT-TYPE-CODE,                                
                  :AT-ACCT-CREATE-DT :WS-ACCT-CREATE-DT-NULL,           
                  :AT-ADDRESS-FORMAT,                                   
                  :AT-ADDRESS-ID,                                       
                  :AT-BILL-CYCLE,                                       
                  :AT-CODES-DATA-PRESENT,                               
                  :AT-LAST-PYMT-DATE :WS-LAST-PYMT-DATE-NULL,           
T30169            :AT-LAST-PYMT-AMOUNT,                                 
                  :AT-TOTAL-AR-BALANCE,                                 
                  :AT-DATE-BILL-DAY-00 :WS-DATE-BILL-DAY-00-NULL,       
                  :AT-DATE-BILL-DAY-30 :WS-DATE-BILL-DAY-30-NULL,       
                  :AT-DATE-BILL-DAY-60 :WS-DATE-BILL-DAY-60-NULL,       
                  :AT-DATE-BILL-DAY-90 :WS-DATE-BILL-DAY-90-NULL,       
                  :AT-BANKRUPTCY-IND,                                   
                  :AT-CODE-DISC-OK,                                     
                  :AT-NOTICE-EXEMPT-CD,                                 
                  :AT-CODE-ACCT-STAT,                                   
                  :AT-CREDIT-GROUP,                                     
T13565            :AT-CODE-STATUS-REASON,                               
C28788            :AT-IVR-EXEMPT-CD,                                    
                  :CZ-CR-BUR-RPT-DT :CZ-CR-BUR-RPT-DT-NULL              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29891*                                                                         
C29891     IF SQLCODE EQUAL SUCCESSFUL-CALL AND                         
C29891                      (AT-LOCAL-OFFICE = '301' OR                 
C29891                       AT-LOCAL-OFFICE = '302' OR                 
C29891                       AT-LOCAL-OFFICE = '303')                   
C29891         GO TO 7710-FETCH-DEL-N-UTIL-ACCT                         
C29891     END-IF                                                       
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
               IF WS-LAST-PYMT-DATE-NULL < 0                            
                   MOVE SPACES      TO AT-LAST-PYMT-DATE                
               END-IF                                                   
               IF WS-ACCT-CREATE-DT-NULL < 0                            
                   MOVE SPACES      TO AT-ACCT-CREATE-DT                
               END-IF                                                   
               IF WS-DATE-BILL-DAY-00-NULL < 0                          
                   MOVE SPACES      TO AT-DATE-BILL-DAY-00              
               END-IF                                                   
               IF WS-DATE-BILL-DAY-30-NULL < 0                          
                   MOVE SPACES      TO AT-DATE-BILL-DAY-30              
               END-IF                                                   
               IF WS-DATE-BILL-DAY-60-NULL < 0                          
                   MOVE SPACES      TO AT-DATE-BILL-DAY-60              
               END-IF                                                   
               IF WS-DATE-BILL-DAY-90-NULL < 0                          
                   MOVE SPACES      TO AT-DATE-BILL-DAY-90              
               END-IF                                                   
PCR499         IF CZ-CR-BUR-RPT-DT-NULL < 0                             
                   MOVE SPACES         TO CZ-CR-BUR-RPT-DT              
               END-IF                                                   
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA226********************'  
               DISPLAY '* 7710 : ERROR ON FETCH  DEL_NON_UTIL_CRSR  *'  
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABENDING...                       *'  
               DISPLAY '*****************PCSCA226********************'  
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
                                                                        
       7710-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS40420
      *                                                                *PCS40430
      *     7720-CLOSE-DEL-N-UTIL-ACCTS.                               *PCS40440
      *                                                                *PCS40450
      *                                                                *PCS40470
      ******************************************************************PCS40480
      *                                                                         
       7720-CLOSE-DEL-N-UTIL-ACCTS.                                     
      *                                                                 15169400
           EXEC SQL                                                     
              CLOSE DEL_NON_UTIL_CRSR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA226*******************'   
               DISPLAY '* 7720 : ERROR ON CLOSE DEL_NON_UTIL_CRSR   *'  
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABENDING...                      *'   
               DISPLAY '*****************PCSCA226*******************'   
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
                                                                        
       7720-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS41920
      *                                                                *PCS41930
      *     7900-OPEN-SUBSEQ-RPT-N-UTIL                                *PCS41940
      *                                                                *PCS41950
      ******************************************************************PCS41960
      *                                                                         
PCR499 7900-OPEN-SUBSEQ-RPT-N-UTIL.                                     
      *                                                                 15173400
           EXEC SQL                                                     
               OPEN SUBSEQ_RPT_N_UTIL                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15173800
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA226******************'    
               DISPLAY '* 7900 : OPEN SUBSEQ_RPT_N_UTIL           *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA226******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                 15175100
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS41920
      *                                                                *PCS41930
      *     7905-FETCH-SUBSEQ-RPT-N-UTIL                               *PCS41940
      *                                                                *PCS41950
      ******************************************************************PCS41960
      *                                                                         
PCR499 7905-FETCH-SUBSEQ-RPT-N-UTIL.                                    
           EXEC SQL                                                     
             FETCH                                                      
                 SUBSEQ_RPT_N_UTIL                                      
             INTO                                                       
                 :AT-ACCOUNT-NO,                                        
                 :AT-COMPANY-NO,                                        
                 :AT-LOCAL-OFFICE,                                      
                 :AT-PREMISE-NO,                                        
                 :AT-CUSTOMER-NO,                                       
                 :AT-ACCOUNT-TYPE-CODE,                                 
                 :AT-ACCT-CREATE-DT :WS-ACCT-CREATE-DT-NULL,            
                 :AT-ADDRESS-FORMAT,                                    
                 :AT-ADDRESS-ID,                                        
                 :AT-LAST-PYMT-DATE :WS-LAST-PYMT-DATE-NULL,            
T30169           :AT-LAST-PYMT-AMOUNT,                                  
                 :AT-DATE-BILL-DAY-00 :WS-DATE-BILL-DAY-00-NULL,        
                 :AT-DATE-BILL-DAY-30 :WS-DATE-BILL-DAY-30-NULL,        
                 :AT-DATE-BILL-DAY-60 :WS-DATE-BILL-DAY-60-NULL,        
                 :AT-DATE-BILL-DAY-90 :WS-DATE-BILL-DAY-90-NULL,        
                 :AT-CODE-ACCT-STAT,                                    
                 :AT-CREDIT-GROUP,                                      
T13565           :AT-CODE-STATUS-REASON,                                
C28788           :AT-IVR-EXEMPT-CD,                                     
                 :CZ-CR-BUR-RPT-DT :CZ-CR-BUR-RPT-DT-NULL               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29891*                                                                         
C29891     IF SQLCODE EQUAL SUCCESSFUL-CALL AND                         
C29891                      (AT-LOCAL-OFFICE = '301' OR                 
C29891                       AT-LOCAL-OFFICE = '302' OR                 
C29891                       AT-LOCAL-OFFICE = '303')                   
C29891         GO TO 7905-FETCH-SUBSEQ-RPT-N-UTIL                       
C29891     END-IF                                                       
      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
               IF WS-LAST-PYMT-DATE-NULL < 0                            
                   MOVE SPACES      TO AT-LAST-PYMT-DATE                
               END-IF                                                   
               IF WS-ACCT-CREATE-DT-NULL < 0                            
                   MOVE SPACES      TO AT-ACCT-CREATE-DT                
               END-IF                                                   
               IF WS-DATE-BILL-DAY-00-NULL < 0                          
                   MOVE SPACES      TO AT-DATE-BILL-DAY-00              
               END-IF                                                   
               IF WS-DATE-BILL-DAY-30-NULL < 0                          
                   MOVE SPACES      TO AT-DATE-BILL-DAY-30              
               END-IF                                                   
               IF WS-DATE-BILL-DAY-60-NULL < 0                          
                   MOVE SPACES      TO AT-DATE-BILL-DAY-60              
               END-IF                                                   
               IF WS-DATE-BILL-DAY-90-NULL < 0                          
                   MOVE SPACES      TO AT-DATE-BILL-DAY-90              
               END-IF                                                   
               IF CZ-CR-BUR-RPT-DT-NULL < 0                             
                   MOVE SPACES         TO CZ-CR-BUR-RPT-DT              
               END-IF                                                   
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA226******************'    
               DISPLAY '* 7905 : FETCH SUBSEQ_RPT_N_UTIL          *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA226******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                 15177600
       7905-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS41920
      *                                                                *PCS41930
      *     7910-CLOSE-SUBSEQ-RPT-N-UTIL                               *PCS41940
      *                                                                *PCS41950
      ******************************************************************PCS41960
      *                                                                         
PCR499 7910-CLOSE-SUBSEQ-RPT-N-UTIL.                                    
      *                                                                 15178100
           EXEC SQL                                                     
              CLOSE SUBSEQ_RPT_N_UTIL                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15178500
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA226******************'    
               DISPLAY '* 7910 : CLOSE SUBSEQ_RPT_N_UTIL          *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA226******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                 15179800
       7910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS41920
      *                                                                *PCS41930
      *     7950-OPEN-SUBSEQ-RPT-WO                                    *PCS41940
      *                                                                *PCS41950
      ******************************************************************PCS41960
      *                                                                         
PCR499 7950-OPEN-SUBSEQ-RPT-WO.                                         
      *                                                                 15173400
           EXEC SQL                                                     
               OPEN SUBSEQ_RPT_WO                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15173800
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA226******************'    
               DISPLAY '* 7950 : OPEN SUBSEQ_RPT_WO               *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA226******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                 15175100
       7950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS41920
      *                                                                *PCS41930
      *     7955-FETCH-SUBSEQ-RPT-WO                                   *PCS41940
      *                                                                *PCS41950
      ******************************************************************PCS41960
      *                                                                         
PCR499 7955-FETCH-SUBSEQ-RPT-WO.                                        
           EXEC SQL                                                     
             FETCH                                                      
                 SUBSEQ_RPT_WO                                          
             INTO                                                       
                 :AT-ACCOUNT-NO,                                        
                 :AT-COMPANY-NO,                                        
                 :AT-LOCAL-OFFICE,                                      
                 :AT-PREMISE-NO,                                        
                 :AT-CUSTOMER-NO,                                       
                 :AT-ACCOUNT-TYPE-CODE,                                 
                 :AT-ACCT-CREATE-DT :WS-ACCT-CREATE-DT-NULL,            
                 :AT-ACCT-FINALED-DT :WS-ACCT-FINALED-DT-NULL,          
                 :AT-ADDRESS-FORMAT,                                    
                 :AT-ADDRESS-ID,                                        
                 :AT-BILL-CYCLE,                                        
                 :AT-CODES-DATA-PRESENT,                                
                 :AT-LAST-PYMT-DATE :WS-LAST-PYMT-DATE-NULL,           
T30169           :AT-LAST-PYMT-AMOUNT,                                  
                 :AT-TOTAL-AR-BALANCE,                                  
                 :AT-DATE-BILL-DAY-00 :WS-DATE-BILL-DAY-00-NULL,        
                 :AT-DATE-BILL-DAY-30 :WS-DATE-BILL-DAY-30-NULL,        
                 :AT-DATE-BILL-DAY-60 :WS-DATE-BILL-DAY-60-NULL,        
                 :AT-DATE-BILL-DAY-90 :WS-DATE-BILL-DAY-90-NULL,        
                 :AT-BANKRUPTCY-IND,                                    
                 :AT-CODE-DISC-OK,                                      
                 :AT-NOTICE-EXEMPT-CD,                                  
                 :AT-CODE-ACCT-STAT,                                    
                 :AT-CREDIT-GROUP,                                      
T13565           :AT-CODE-STATUS-REASON,                                
C28788           :AT-IVR-EXEMPT-CD,                                     
T25628           :FW-FINAL-BILL-AM,                                     
T30169           :KD-FW-ACTION-TYPE-CD,                                 
T30169           :KD-FW-SEQ-NO,                                         
T30169           :KD-FW-ACTION-DT,                                      
T30169           :KD-FW-ACTION-AM,                                      
                 :CZ-CR-BUR-RPT-DT :CZ-CR-BUR-RPT-DT-NULL               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29891*                                                                         
C29891     IF SQLCODE EQUAL SUCCESSFUL-CALL AND                         
C29891                      (AT-LOCAL-OFFICE = '301' OR                 
C29891                       AT-LOCAL-OFFICE = '302' OR                 
C29891                       AT-LOCAL-OFFICE = '303')                   
C29891         GO TO 7955-FETCH-SUBSEQ-RPT-WO                           
C29891     END-IF                                                       
      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
               IF WS-LAST-PYMT-DATE-NULL < 0                            
                   MOVE SPACES      TO AT-LAST-PYMT-DATE                
               END-IF                                                   
               IF WS-ACCT-CREATE-DT-NULL < 0                            
                   MOVE SPACES      TO AT-ACCT-CREATE-DT                
               END-IF                                                   
               IF WS-ACCT-FINALED-DT-NULL < 0                           
                   MOVE SPACES      TO AT-ACCT-FINALED-DT               
               END-IF                                                   
               IF WS-DATE-BILL-DAY-00-NULL < 0                          
                   MOVE SPACES      TO AT-DATE-BILL-DAY-00              
               END-IF                                                   
               IF WS-DATE-BILL-DAY-30-NULL < 0                          
                   MOVE SPACES      TO AT-DATE-BILL-DAY-30              
               END-IF                                                   
               IF WS-DATE-BILL-DAY-60-NULL < 0                          
                   MOVE SPACES      TO AT-DATE-BILL-DAY-60              
               END-IF                                                   
               IF WS-DATE-BILL-DAY-90-NULL < 0                          
                   MOVE SPACES      TO AT-DATE-BILL-DAY-90              
               END-IF                                                   
               IF CZ-CR-BUR-RPT-DT-NULL < 0                             
                   MOVE SPACES         TO CZ-CR-BUR-RPT-DT              
               END-IF                                                   
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA226******************'    
               DISPLAY '* 7955 : FETCH SUBSEQ_RPT_WO              *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA226******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                 15177600
       7955-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS41920
      *                                                                *PCS41930
      *     7960-CLOSE-SUBSEQ-RPT-WO                                   *PCS41940
      *                                                                *PCS41950
      ******************************************************************PCS41960
      *                                                                         
PCR499 7960-CLOSE-SUBSEQ-RPT-WO.                                        
      *                                                                 15178100
           EXEC SQL                                                     
              CLOSE SUBSEQ_RPT_WO                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA226******************'    
               DISPLAY '* 7960 : CLOSE SUBSEQ_RPT_WO              *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA226******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                 15179800
       7960-EXIT.                                                       
           EXIT.                                                        
T30169*                                                                         
T30169******************************************************************05240000
T30169*                                                                *05250000
T30169*       7970-OPEN-TRNHST-CSR                                     *05260000
T30169*                                                                *05270000
T30169******************************************************************05280000
T30169*                                                                 05330000
       7970-OPEN-TRNHST-CSR.                                            
      *                                                                 05330000
           EXEC SQL                                                     
               OPEN TRNHST_CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05330000
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 05350000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSCA226 **'      
              DISPLAY '** PARA 7970-OPEN-TRN-HST-CSR           **'      
              DISPLAY '** ERROR DURING OPEN OF CURSOR          **'      
              DISPLAY '**    TRNHST_CURSOR                     **'      
              DISPLAY '** RC =' WS-ACTIVE-RETURN-CODE                   
              DISPLAY '**  PROCESSING TERMINATED               **'      
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 05470000
       7970-EXIT.                                                       
           EXIT.                                                        
T30169*                                                                 05500000
T30169******************************************************************05510000
T30169*                                                                *05520000
T30169*       7974-FETCH-TRNHST-CSR                                    *05530000
T30169*                                                                *05540000
T30169******************************************************************05550000
T30169*                                                                 05500000
T30169 7974-FETCH-TRNHST-CSR.                                           
T30169*                                                                 05500000
           EXEC SQL                                                     
               FETCH TRNHST_CURSOR                                      
               INTO :AR-AMT-ORIG-ENTERED                                
                   ,:AR-CODE-TRAN-TYPE                                  
                   ,:AU-GL-ACCT-CREDIT                                  
                   ,:AU-GL-ACCT-DEBIT                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05630000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 05650000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSCA226 **'      
              DISPLAY '** PARA 7974-FETCH-TRN-HST-CSR          **'      
              DISPLAY '** ERROR DURING FETCH OF CURSOR         **'      
              DISPLAY '**    TRNHST_CURSOR                     **'      
              DISPLAY '** RC =' WS-ACTIVE-RETURN-CODE                   
              DISPLAY '**  PROCESSING TERMINATED               **'      
              PERFORM 9900-ABEND        THRU 9900-EXIT                  
           END-IF.                                                      
      *                                                                 05810000
       7974-EXIT.                                                       
           EXIT.                                                        
T30169*                                                                 05841712
T30169******************************************************************05850000
T30169*                                                                *05860000
T30169*       7978-CLOSE-TRNHST-CSR                                    *05870000
T30169*                                                                *05880000
T30169******************************************************************05890000
                                                                        
       7978-CLOSE-TRNHST-CSR.                                           
                                                                        
           EXEC SQL                                                     
             CLOSE TRNHST_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05940000
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSCA226 **'      
              DISPLAY '**   PARA 7978-CLOSE-TRNHST-CSR         **'      
              DISPLAY '**  ERROR DURING CLOSE OF CURSOR        **'      
              DISPLAY '**       TRNHST_CURSOR                  **'      
              DISPLAY '** RC=' WS-ACTIVE-RETURN-CODE                    
              DISPLAY '**   PROCESSING TERMINATED              **'      
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
T30169*                                                                 06070000
T30169 7978-EXIT.                                                       
T30169     EXIT.                                                        
T30169*                                                                         
T25628******************************************************************        
T25628*                                                                *        
T25628*     7980-OPEN-SUBSEQ-RPT-FB                                    *        
T25628*                                                                *        
T25628******************************************************************        
T25628*                                                                         
T25628 7980-OPEN-SUBSEQ-RPT-FB.                                         
                                                                        
           EXEC SQL                                                     
               OPEN SUBSEQ_RPT_FB                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA226******************'    
               DISPLAY '* 7980 : OPEN SUBSEQ_RPT_FB               *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA226******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
                                                                        
       7980-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T25628******************************************************************        
T25628*                                                                *        
T25628*     7985-FETCH-SUBSEQ-RPT-FB                                   *        
T25628*                                                                *        
T25628******************************************************************        
T25628*                                                                         
T25628 7985-FETCH-SUBSEQ-RPT-FB.                                        
           EXEC SQL                                                     
             FETCH                                                      
                 SUBSEQ_RPT_FB                                          
             INTO                                                       
                 :AT-ACCOUNT-NO,                                        
                 :AT-COMPANY-NO,                                        
                 :AT-LOCAL-OFFICE,                                      
                 :AT-PREMISE-NO,                                        
                 :AT-CUSTOMER-NO,                                       
                 :AT-ACCOUNT-TYPE-CODE,                                 
                 :AT-ACCT-CREATE-DT :WS-ACCT-CREATE-DT-NULL,            
                 :AT-ACCT-FINALED-DT :WS-ACCT-FINALED-DT-NULL,          
                 :AT-ADDRESS-FORMAT,                                    
                 :AT-ADDRESS-ID,                                        
                 :AT-BILL-CYCLE,                                        
                 :AT-CODES-DATA-PRESENT,                                
                 :AT-LAST-PYMT-DATE :WS-LAST-PYMT-DATE-NULL,           
T30169           :AT-LAST-PYMT-AMOUNT,                                  
                 :AT-TOTAL-AR-BALANCE,                                  
                 :AT-DATE-BILL-DAY-00 :WS-DATE-BILL-DAY-00-NULL,        
                 :AT-DATE-BILL-DAY-30 :WS-DATE-BILL-DAY-30-NULL,        
                 :AT-DATE-BILL-DAY-60 :WS-DATE-BILL-DAY-60-NULL,        
                 :AT-DATE-BILL-DAY-90 :WS-DATE-BILL-DAY-90-NULL,        
                 :AT-BANKRUPTCY-IND,                                    
                 :AT-CODE-DISC-OK,                                      
                 :AT-NOTICE-EXEMPT-CD,                                  
                 :AT-CODE-ACCT-STAT,                                    
                 :AT-CREDIT-GROUP,                                      
                 :AT-CODE-STATUS-REASON,                                
C28788           :AT-IVR-EXEMPT-CD,                                     
T25628           :FW-FINAL-BILL-AM,                                     
                 :CZ-CR-BUR-RPT-DT :CZ-CR-BUR-RPT-DT-NULL               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29891*                                                                         
C29891     IF SQLCODE EQUAL SUCCESSFUL-CALL AND                         
C29891                      (AT-LOCAL-OFFICE = '301' OR                 
C29891                       AT-LOCAL-OFFICE = '302' OR                 
C29891                       AT-LOCAL-OFFICE = '303')                   
C29891         GO TO 7985-FETCH-SUBSEQ-RPT-FB                           
C29891     END-IF                                                       
      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
               IF WS-LAST-PYMT-DATE-NULL < 0                            
                   MOVE SPACES      TO AT-LAST-PYMT-DATE                
               END-IF                                                   
               IF WS-ACCT-CREATE-DT-NULL < 0                            
                   MOVE SPACES      TO AT-ACCT-CREATE-DT                
               END-IF                                                   
               IF WS-ACCT-FINALED-DT-NULL < 0                           
                   MOVE SPACES      TO AT-ACCT-FINALED-DT               
               END-IF                                                   
               IF WS-DATE-BILL-DAY-00-NULL < 0                          
                   MOVE SPACES      TO AT-DATE-BILL-DAY-00              
               END-IF                                                   
               IF WS-DATE-BILL-DAY-30-NULL < 0                          
                   MOVE SPACES      TO AT-DATE-BILL-DAY-30              
               END-IF                                                   
               IF WS-DATE-BILL-DAY-60-NULL < 0                          
                   MOVE SPACES      TO AT-DATE-BILL-DAY-60              
               END-IF                                                   
               IF WS-DATE-BILL-DAY-90-NULL < 0                          
                   MOVE SPACES      TO AT-DATE-BILL-DAY-90              
               END-IF                                                   
               IF CZ-CR-BUR-RPT-DT-NULL < 0                             
                   MOVE SPACES         TO CZ-CR-BUR-RPT-DT              
               END-IF                                                   
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA226******************'    
               DISPLAY '* 7985 : FETCH SUBSEQ_RPT_FB              *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA226******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
                                                                        
       7985-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T25628******************************************************************        
T25628*                                                                *        
T25628*     7960-CLOSE-SUBSEQ-RPT-FB                                   *        
T25628*                                                                *        
T25628******************************************************************        
T25628*                                                                         
T25628 7990-CLOSE-SUBSEQ-RPT-FB.                                        
                                                                        
           EXEC SQL                                                     
              CLOSE SUBSEQ_RPT_FB                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA226******************'    
               DISPLAY '* 7990 : CLOSE SUBSEQ_RPT_FB              *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA226******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
                                                                        
       7990-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T30169******************************************************************        
T30169*                                                                *        
T30169*     7995-OPEN-SUBSEQ-COLL-AGY                                  *        
T30169*                                                                *        
T30169******************************************************************        
T30169*                                                                         
T30169 7995-OPEN-SUBSEQ-COLL-AGY.                                       
                                                                        
           EXEC SQL                                                     
               OPEN SUBSEQ_COLL_AGY_CUR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA226******************'    
               DISPLAY '* 7995 : OPEN SUBSEQ_COLL_AGY_CUR         *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA226******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
                                                                        
       7995-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T30169******************************************************************        
T30169*                                                                *        
T30169*     7996-FETCH-SUBSEQ-COLL-AGY                                 *        
T30169*                                                                *        
T30169******************************************************************        
T30169*                                                                         
T30169 7996-FETCH-SUBSEQ-COLL-AGY.                                      
           EXEC SQL                                                     
             FETCH                                                      
                 SUBSEQ_COLL_AGY_CUR                                    
             INTO                                                       
                 :KD-FW-ACTION-TYPE-CD                                  
                ,:KD-FW-SEQ-NO                                          
                ,:KD-FW-ACTION-DT                                       
                ,:KD-FW-ACTION-AM                                       
                ,:IZ-CODE-COLLEC-AGNCY                                  
                ,:IZ-COLL-AGY-SUB-CD                                    
                ,:AT-ACCOUNT-NO                                         
                ,:AT-COMPANY-NO                                         
                ,:AT-LOCAL-OFFICE                                       
                ,:AT-PREMISE-NO                                         
                ,:AT-CUSTOMER-NO                                        
                ,:AT-ACCOUNT-TYPE-CODE                                  
                ,:AT-ACCT-CREATE-DT :WS-ACCT-CREATE-DT-NULL             
                ,:AT-ACCT-FINALED-DT :WS-ACCT-FINALED-DT-NULL           
                ,:AT-ADDRESS-FORMAT                                     
                ,:AT-ADDRESS-ID                                         
                ,:AT-BILL-CYCLE                                         
                ,:AT-CODES-DATA-PRESENT                                 
                ,:AT-LAST-PYMT-DATE :WS-LAST-PYMT-DATE-NULL            
T30169          ,:AT-LAST-PYMT-AMOUNT                                   
                ,:AT-TOTAL-AR-BALANCE                                   
                ,:AT-DATE-BILL-DAY-00 :WS-DATE-BILL-DAY-00-NULL         
                ,:AT-DATE-BILL-DAY-30 :WS-DATE-BILL-DAY-30-NULL         
                ,:AT-DATE-BILL-DAY-60 :WS-DATE-BILL-DAY-60-NULL         
                ,:AT-DATE-BILL-DAY-90 :WS-DATE-BILL-DAY-90-NULL         
                ,:AT-BANKRUPTCY-IND                                     
                ,:AT-CODE-DISC-OK                                       
                ,:AT-NOTICE-EXEMPT-CD                                   
                ,:AT-CODE-ACCT-STAT                                     
                ,:AT-CREDIT-GROUP                                       
                ,:AT-CODE-STATUS-REASON                                 
                ,:AT-IVR-EXEMPT-CD                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL AND                         
                            (AT-LOCAL-OFFICE = '301' OR                 
                             AT-LOCAL-OFFICE = '302' OR                 
                             AT-LOCAL-OFFICE = '303')                   
               GO TO 7996-FETCH-SUBSEQ-COLL-AGY                         
           END-IF                                                       
      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
               IF WS-LAST-PYMT-DATE-NULL < 0                            
                   MOVE SPACES      TO AT-LAST-PYMT-DATE                
               END-IF                                                   
               IF WS-ACCT-CREATE-DT-NULL < 0                            
                   MOVE SPACES      TO AT-ACCT-CREATE-DT                
               END-IF                                                   
               IF WS-ACCT-FINALED-DT-NULL < 0                           
                   MOVE SPACES      TO AT-ACCT-FINALED-DT               
               END-IF                                                   
               IF WS-DATE-BILL-DAY-00-NULL < 0                          
                   MOVE SPACES      TO AT-DATE-BILL-DAY-00              
               END-IF                                                   
               IF WS-DATE-BILL-DAY-30-NULL < 0                          
                   MOVE SPACES      TO AT-DATE-BILL-DAY-30              
               END-IF                                                   
               IF WS-DATE-BILL-DAY-60-NULL < 0                          
                   MOVE SPACES      TO AT-DATE-BILL-DAY-60              
               END-IF                                                   
               IF WS-DATE-BILL-DAY-90-NULL < 0                          
                   MOVE SPACES      TO AT-DATE-BILL-DAY-90              
               END-IF                                                   
               IF CZ-CR-BUR-RPT-DT-NULL < 0                             
                   MOVE SPACES         TO CZ-CR-BUR-RPT-DT              
               END-IF                                                   
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA226******************'    
               DISPLAY '* 7996 : FETCH SUBSEQ_COLL_AGY_CUR        *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA226******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
                                                                        
       7996-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T30169******************************************************************        
T30169*                                                                *        
T30169*     7997-CLOSE-SUBSEQ-COLL-AGY                                 *        
T30169*                                                                *        
T30169******************************************************************        
T30169*                                                                         
T30169 7997-CLOSE-SUBSEQ-COLL-AGY.                                      
                                                                        
           EXEC SQL                                                     
              CLOSE SUBSEQ_COLL_AGY_CUR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA226******************'    
               DISPLAY '* 7997 : CLOSE SUBSEQ_COLL_AGY_CUR        *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA226******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
                                                                        
       7997-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS40420
      *                                                                *PCS40430
      *      8500-WRITE-FCA226-RECORD.                                 *PCS40440
      ******************************************************************PCS40480
      *                                                                         
       8500-WRITE-FCA226-RECORD.                                        
      *                                                                         
           WRITE FIOCA226.                                              
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************PCS40420
      *                                                                *PCS40430
      *      8550-WRITE-FCA227-RECORD.                                 *PCS40440
      ******************************************************************PCS40480
      *                                                                         
T30169 8550-WRITE-FCA227-RECORD.                                        
      *                                                                         
           WRITE FIOCA227.                                              
      *                                                                         
T30169 8550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS44780
      *                                                                *PCS44790
      *     9000-TERMINATE                                             *PCS44800
      *                                                                *PCS44810
      *     CLOSE FILES                                                *PCS44820
      *                                                                *PCS44830
      ******************************************************************PCS44840
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
T14006     CLOSE FCSCA226-FILE.                                         
           IF FCA226-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  PCSCA226 PROCESSING ERROR              **'  
               DISPLAY '**    CLOSE ERROR OF FCSCA226 - OUTPUT FILE'    
               DISPLAY '**    FILE STATUS = ' WS-FCA226-STATUS          
           END-IF.                                                      
T30169     CLOSE FCSCA227-FILE.                                         
           IF FCA227-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  PCSCA226 PROCESSING ERROR              **'  
               DISPLAY '**    CLOSE ERROR OF FCSCA227 - OUTPUT FILE'    
               DISPLAY '**    FILE STATUS = ' WS-FCA227-STATUS          
           END-IF.                                                      
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T25628******************************************************************        
T25628*   9600-PROCESS-ABEND                                           *        
T25628*                                                                *        
T25628*        THIS ROUTINE IS EXECUTED ONLY FROM 9000-TERMINATE WHEN  *        
T25628*   AN ERROR CONDITION OCCURS.  SINCE 9000-TERMINATE IS          *        
T25628*   EXECUTED FROM 9700-PROCESS-ABEND, THIS PARAGRAPH WAS SETUP   *        
T25628*   TO AVOID LOOP.                                               *        
T25628******************************************************************        
T25628                                                                  
T25628 9600-PROCESS-ABEND.                                              
T25628                                                                  
T25628     MOVE '9600'                   TO ACTIVE-PARAGRAPH.           
T25628     MOVE RS-RETURN-CODE           TO RS-RETURN-CODE-DISP.        
T25628                                                                  
T25628     DISPLAY '*********************************************'      
T25628     DISPLAY '** COMPONENT ABEND   ' ABEND-PROGRAM                
T25628     DISPLAY '** DB2 RETURN CODE   ' RS-RETURN-CODE-DISP          
T25628     DISPLAY '** ABEND FUNCTION    ' ABEND-FUNCTION               
T25628     DISPLAY '** TABLE 1           ' TABLE-1                      
T25628     DISPLAY '** TABLE ELEMENT 1   ' TABLE-ELEMENT-1              
T25628     DISPLAY '** HOSTVAR ELEMENT 1 ' HOSTVAR-ELEMENT-1            
T25628     DISPLAY '** TABLE 2           ' TABLE-2                      
T25628     DISPLAY '** TABLE ELEMENT 2   ' TABLE-ELEMENT-2              
T25628     DISPLAY '** HOSTVAR ELEMENT 2 ' HOSTVAR-ELEMENT-2            
T25628     DISPLAY '** TABLE 3           ' TABLE-3                      
T25628     DISPLAY '** TABLE ELEMENT 3   ' TABLE-ELEMENT-3              
T25628     DISPLAY '** HOSTVAR ELEMENT 3 ' HOSTVAR-ELEMENT-3            
T25628     DISPLAY '** TABLE 4           ' TABLE-4                      
T25628     DISPLAY '** TABLE ELEMENT 4   ' TABLE-ELEMENT-4              
T25628     DISPLAY '** HOSTVAR ELEMENT 4 ' HOSTVAR-ELEMENT-4            
T25628     DISPLAY '*********************************************'      
T25628     DISPLAY 'PERFORMING 9900-ABEND'.                             
T25628                                                                  
SCA003     EXEC SQL
SCA003         ROLLBACK
SCA003     END-EXEC.                                                

SCA003     CALL "MFASQLCA"
SCA003       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
SCA003       BY REFERENCE MFSQLMESSAGETEXT
SCA003     END-CALL

T25628                                                                  
T25628     MOVE 12  TO  RETURN-CODE.                                    
T25628     MOVE 'YES' TO WS-ABEND-SWITCH.                               
T25628                                                                  
T25628 9600-EXIT.                                                       
T25628      IF WS-ABEND-YES                                             
T25628          STOP RUN
            END-IF.                                               
T25628*                                                                         
T25628******************************************************************        
T25628*  9700-PROCESS-ABEND.                                           *        
T25628******************************************************************        
              EXEC SQL                                                  15309306
                   INCLUDE CPD0023B                                     15309307
              END-EXEC.                                                 15309308
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  9900-SQL-ERROR-ROUTINE                                    **          
      **                                                            **          
      ****************************************************************          
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                         
           MOVE SQLCODE                TO WS-DISPLAY-SQLCODE.           
           DISPLAY ' '                                                  
           DISPLAY '**********************************************'     
           DISPLAY '***** 9900-SQL-ERROR-ROUTINE            ******'     
           DISPLAY '**********************************************'     
           DISPLAY ' '                                                  
           DISPLAY 'SQLCODE = ' WS-DISPLAY-SQLCODE                      
           DISPLAY ABEND-RECORD-1-DATA                                  
           DISPLAY ABEND-RECORD-2-DATA                                  
           DISPLAY ABEND-RECORD-3-DATA                                  
           DISPLAY '**********************************************'.    
           PERFORM 9900-ABEND                    THRU 9900-EXIT.        
      *                                                                         
      ****************************************************************          
      ** 9900-ABEND                                                 **          
      ****************************************************************          
              EXEC SQL                                                  27290000
                   INCLUDE CPD09900                                     27300000
              END-EXEC.                                                 27310000
