       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA217.                                        
       AUTHOR.         GOKUL SATHIYAMOORTHY.                            
COB303 DATE-WRITTEN.   JAN 2006.                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      *                SOUTH CAROLINA ELECTRIC & GAS                  *         
      *                                                               *         
      *  PROGRAM:  PCSCA217                                           *         
      *                                                               *         
      *****************************************************************         
      *                 PROGRAM SUMMARY                               *         
      *                                                               *         
      * THIS PROGRAM DELETES THE DATA OF THE PAST REVENUE MONTHS      *         
      * FROM CSS_AUDIT_BILL_ACCT.                                     *         
      *                                                               *         
      *****************************************************************         
      *                     PROGRAM MODIFICATION LOG                  *         
      *                                                               *         
      *    DATE    INITIALS   COMMENTS                                *         
      *  --------  --------   -------------------------------------   *         
      **  01/18/06   GOKUL    INITIAL PROGRAM VERSION                **         
A04527**  06/06/13   MR7E794  REMOVED UNUSED COPYBOOK CWS00056.      **         
      *****************************************************************         
      *                                                               *         
      *                ---- BASIC SEQUENCE STRUCTURE ----             *         
      *                                                               *         
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION            *         
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                   *         
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                  *         
      *  3000 - 4999  NOT USED                                        *         
      *  5000 - 5999  COMMON PROGRAM MODULES                          *         
      *  6000 - 6999  COMMON SYSTEM MODULES                           *         
      *  7000 - 7999  INPUT MODULES                                   *         
      *  8000 - 8999  OUTPUT MODULES                                  *         
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES            *         
      *                                                               *         
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA217'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                      PIC X(40)                      
           VALUE 'WORKING STORAGE FOR PCSCA217 STARTS HERE'.            
                                                                        
      * WORK AREAS                                                    *         
      *****************************************************************         
                                                                        
       01  WS-MISC.                                                     
           05 WS-REVENUE-JOB-PARM        PIC 9(06) VALUE 0.             
           05 WS-PROGRAM-NAME            PIC X(08) VALUE 'PCSCA217'.    
           05 PROGRAM-NAME               PIC X(08) VALUE 'PCSCA217'.    
           05 WS-PGRMNAME                PIC X(08) VALUE 'PCSCA217'.    
      *                                                                         
       COPY FIOJC01.                                                            
       COPY CWS00303.                                                           
       COPY CWS00038.                                                           
       COPY CWS09900.                                                   00010001
       COPY CWS00010.                                                           
       COPY CWS00023.                                                           
      *                                                                         
       01  WS-END                        PIC X(40)                      
           VALUE 'WORKING STORAGE FOR PCSCA217 ENDS HERE  '.            
                                                                        
      *****************************************************************         
      * DB2 INCLUDES                                                  *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADTAT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  PARMIN.                                                      
           05  PARMLENGTH                   PIC S9(04) COMP.            
           05  PARM-REVENUE-MONTH           PIC X(06).                  
                                                                        
       PROCEDURE DIVISION USING PARMIN.                                 
      ******************************************************************        
      **                                                              **        
      **    0000-MAINLINE                                             **        
      **                                                              **        
      **    CONTROLS THE MAIN PATH OF THE PROGRAM                     **        
      **                                                              **        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION   THRU 0100-EXIT.                
           PERFORM 2000-PROCESS-PARA     THRU 2000-EXIT.                
           PERFORM 9000-TERMINATE        THRU 9000-EXIT.                
           DISPLAY 'PROGRAM ENDED SUCCESSFULLY'.                        
           STOP RUN.                                                    
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **    0100-INITIALIZATION                                       **        
      **    PROGRAM EXECUTION BEGINS HERE. GETS THE REVENUE MONTH     **        
      **    FROM JOB PARM TABLE                                       **        
      ******************************************************************        
                                                                        
       0100-INITIALIZATION.                                             
      *                                                                         
           DISPLAY 'PROGRAM EXECUTION STARTED'.                         
           IF PARMLENGTH > 0 AND PARM-REVENUE-MONTH > 0                 
              MOVE PARM-REVENUE-MONTH    TO    WS-REVENUE-JOB-PARM      
                                               K8-REVENUE-MONTH         
              DISPLAY '** OVERRIDE REVENUE MONTH BEING USED **'         
              DISPLAY '** REVENUE MONTH = '                             
                          WS-REVENUE-JOB-PARM  '            **'         
           ELSE                                                         
              MOVE SPACES                   TO    WS-SYSIPT             
              MOVE 'COMMON'                 TO    WS-PROGRAM            
              MOVE WS-DATE                  TO    WS-COMMAND            
              MOVE +1                       TO    WS-SEQUENCE           
                                                                        
              PERFORM 7600-START-FCSJC01    THRU  7600-EXIT             
                                                                        
              PERFORM 7610-READ-FCSJC01     THRU  7610-EXIT             
                 UNTIL  REVENUE-MONTH OR END-OF-SYSIPT                  
                                                                        
              IF END-OF-SYSIPT OR WS-REVENUE-MONTH-PARM  NOT NUMERIC    
                 DISPLAY '** PCSCA217 PROCESSING ERROR        **'       
                 DISPLAY '** REVENUE MONTH IS NOT AVAILABLE   **'       
                 DISPLAY '** PROCESSING TERMINATED            **'       
                 PERFORM 7611-CLOSE         THRU  7611-EXIT             
                 MOVE 'YES'                 TO WS-ABEND-SWITCH          
                 PERFORM 9900-ABEND         THRU  9900-EXIT             
              END-IF                                                    
              MOVE WS-REVENUE-MONTH-PARM    TO WS-REVENUE-JOB-PARM      
                                               K8-REVENUE-MONTH         
              DISPLAY '** REVENUE MONTH = '                             
                          WS-REVENUE-JOB-PARM    '          **'         
           END-IF.                                                      
                                                                        
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **    2000-PROCESS-PARA                                         **        
      **    CALLED FROM 0000-MAINLINE                                 **        
      ******************************************************************        
       2000-PROCESS-PARA.                                               
      *                                                                         
           PERFORM 8000-DELETE-AUDIT-BILL THRU 8000-EXIT.               
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7600- READ THE CSS_JOB_PARM DATABASE TABLE.                  **         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 8000-DELETE-AUDIT-BILL *                                                
      *      DELETE THE ACCOUNTS INSERTED FOR THE PAST REVENUE MONTHS  *        
      ******************************************************************        
       8000-DELETE-AUDIT-BILL.                                          
      *                                                                         
           EXEC SQL                                                     
               DELETE                                                   
               FROM CSS_AUDIT_BLL_ACCT                                  
               WHERE REVENUE_MONTH < :K8-REVENUE-MONTH                  
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '************************************************'
              DISPLAY '****        ERROR OCCURED IN                ****'
              DISPLAY '**** 8000-DELETE-AUDIT-BILL CODE ='              
                                    WS-ACTIVE-RETURN-CODE     ' ****'   
              DISPLAY '************************************************'
              MOVE 'YES'                 TO WS-ABEND-SWITCH             
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
                                                                        
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   9000-TERMINATE                                           **          
      *****         TERMINATES THE PROGRAM                       *****          
      ****************************************************************          
       9000-TERMINATE.                                                  
      *                                                                         
           IF WS-ABEND-SWITCH ='YES'                                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY 'TOTAL NUMBER OF ROWS DELETED : ' SQLERRD(3)      
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  08140000
      **    THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE           **  08150000
      ****************************************************************  08160000
      *                                                                         
           EXEC SQL                                                     08170000
               INCLUDE CPD09900                                         08180001
           END-EXEC.                                                    08190000
                                                                        
