       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA213.                                        
      ***************************************************************** 00000300
      **              SOUTH CAROLINA ELECTRIC & GAS                  ** 00000400
      **               CUSTOMER INFORMATION SYSTEM                   ** 00000700
      **                                                             ** 00000800
      ***************************************************************** 00000900
      **               P R O G R A M  S U M M A R Y                  ** 00001000
      **                                                             ** 00001100
      **  PCSCA213 WILL READ PARM PASSED FROM THE JCL, UPDATE        **         
      **  CSS_SPCL_BILL_MSG WITH A BILL MESSAGE  OR INSERT FOR ALL   **         
      **  ACCOUNTS LISTED ON THE INPUT FILE.  IF THERE ARE NO ERRORS **         
      **  ON THE INSERT, THEN THE PROGRAM WILL DELETE RECORDS THAT   **         
      **  ARE OLDER THAN THREE MONTHS.                               **         
      **                                                                        
      **  NOTE:- ACCOUNT NUMBER MUST ALWAYS BE THIRTEEN DIGITS ONLY. **         
      **                                                             **         
      *****************************************************************         
      *                                                              ** 00002300
      *              PROGRAM  MODIFICATION  LOG                      ** 00002400
      *                                                              ** 00002500
      *    DATE     INITIALS  REASON                                 ** 00002600
      *    ----     --------  ------                                 ** 00002700
A03324**   05/11    SV        INITIAL VERSION.                       ** 00016220
      **                                                             **         
      ***END*********************************************************** 00016300
      **          ---- BASIC SEQUENCE STRUCTURE ----                 ** 00016400
      **                                                             ** 00016500
      **  0000         MODULE CONTROL                                ** 00016600
      **  0100 - 0999  INITIALIZATION (OPTIONAL)                     ** 00016700
      **  1000 - 1999  FUNCTIONAL CONTROL                            ** 00016800
      **  2000 - 4999  DETAIL LOGIC                                  ** 00016900
      **  5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES            ** 00017000
      **  6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)  ** 00017100
      **  7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.)** 00017200
      **  8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC.)* 00017300
      **                                                             ** 00017400
      ***************************************************************** 00017500
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
      *** CA213 IS THE INPUT FILE THAT WILL HAVE ACCOUNTS TO INSERT     00018100
       COPY CSSCA213.                                                           
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
      *** CA213 IS THE INPUT FILE THAT WILL HAVE ACCOUNTS TO INSERT     00018100
       COPY CFDCA213.                                                           
       COPY FIOCA213.                                                           
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA213'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-MISC.                                                     
COB305     05 WS-ACCOUNT-NUMBER        PIC S9(13)V COMP-3 VALUE 0.          
           05  WS-ERROR-COUNT              PIC 9(04).                   
           05  WS-REVENUE-MONTH-START      PIC 9(06).                   
           05  FILLER REDEFINES WS-REVENUE-MONTH-START.                 
               10  WS-REVENUE-CCYY-ST      PIC 9(4).                    
               10  WS-REVENUE-MM-ST        PIC 99.                      
           05  WS-REVENUE-MONTH-END        PIC 9(06).                   
           05  FILLER REDEFINES WS-REVENUE-MONTH-END.                   
               10  WS-REVENUE-CCYY-END     PIC 9(4).                    
               10  WS-REVENUE-MM-END       PIC 99.                      
           05  WS-BILL-CYCLE-START         PIC X(02).                   
           05  WS-RECORDS-READ             PIC 9(09) VALUE ZERO.        
           05  WS-BILL-CYCLE-END           PIC X(02).                   
           05  WS-BILL-MSG-ID              PIC X(05).                   
           05  WS-MSG-TYPE-CD              PIC X(01).                   
           05  WS-PRIOR-DATE               PIC X(10).                   
           05  FILLER REDEFINES WS-PRIOR-DATE.                          
               10  WS-PRIOR-CCYY           PIC X(4).                    
               10  FILLER                  PIC X(01).                   
               10  WS-PRIOR-MONTH          PIC X(2).                    
               10  FILLER                  PIC X(01).                   
               10  WS-PRIOR-DAY            PIC X(2).                    
           05  WS-COMPANY-NO               PIC X(02).                   
           05  WS-COUNTER                  PIC 9(07) VALUE ZERO.        
           05  FILLER REDEFINES WS-COUNTER.                             
               10  WS-CHECK-POINT          PIC 9(4).                    
               10  WS-CNTR-TEST            PIC 9(3).                    
                                                                        
       01  WS-SQL-VARIABLES.                                            
           05  WS-SQL-CURSOR-TEMP          PIC X(25).                   
           05  WS-SQL-CALL-TEMP            PIC X(3).                    
           05  WS-SQL-PARA-TEMP            PIC X(4).                    
           05  RS-RETURN-CODE              PIC S9(4) COMP.              
           05  RS-RETURN-CODE-DISP         PIC -Z(4).                   
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-PARM-ERROR               PIC X(01) VALUE 'N'.         
           05  WS-END-OF-CA213             PIC X(01) VALUE 'N'.         
               88  END-OF-CA213                      VALUE 'Y'.         
           05  WS-FCA213-STATUS            PIC X(02).                   
               88  FCA213-SUCCESSFUL                 VALUE ZERO.        
           05 WS-INSERT-SW                 PIC X(01)   VALUE 'N'.       
               88  INSERT-ACCT                         VALUE 'Y'.       
           05 WS-DELETE-SW                 PIC X(01)   VALUE 'N'.       
               88  DELETE-ACCTS                        VALUE 'Y'.       
                                                                        
       01  WS-CNTRS.                                                    
           05  WS-ACCOUNTS-READ            PIC 9(07)  VALUE ZERO.       
           05  WS-ACCTS-INSERTED           PIC 9(07)  VALUE ZERO.       
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-YES                      PIC X(01) VALUE 'Y'.         
           05  WS-Y                        PIC X(01) VALUE 'Y'.         
           05  WS-NO                       PIC X(01) VALUE 'N'.         
           05  WS-N                        PIC X(01) VALUE 'N'.         
           05  WS-PGRMNAME                 PIC X(08) VALUE 'PCSCA213'.  
                                                                        
       01  WS-DISPLAYS.                                                 
           05  WS-DISPLAY-SQLCODE          PIC -ZZZZZZZZ9.              
           05  WS-DISPLAY-ACCOUNT          PIC ZZZZZZZZZZZZ9.           
                                                                        
      * COPYBOOK ADDED SQL ERROR HANDLING                                       
       COPY CWS00010.                                                   01506000
      * ABEND SWITCH COPYBOOK                                                   
       COPY CWS09900.                                                   01506000
      * FIELDS FOR SQL/DB2 ERROR CHECKING                                       
       COPY CWS00303.                                                   01505000
                                                                        
           EXEC SQL                                                     00056600
                INCLUDE SQLCA                                           00056700
           END-EXEC.                                                    00056800
                                                                        
      *                                                                         
      *   DCLGEN FOR CSS_SPCL_BILL_MSG                                  00048800
           EXEC SQL                                                     00056600
                INCLUDE TBSBLMSG                                        00056700
           END-EXEC.                                                    00056800
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
       01  WS-PARM-VALUE.                                               
           05 WS-PARMVAL-LENGTH             PIC S9(04) COMP.            
           05 WS-PARM-REV-MO-START          PIC 9(06).                  
           05 WS-PARM-CYC-START             PIC 9(02).                  
           05 WS-PARM-REV-MO-END            PIC 9(06).                  
           05 WS-PARM-CYC-END               PIC 9(02).                  
           05 WS-PARM-MSG-TYPE              PIC X(01).                  
           05 WS-PARM-MSG-ID                PIC X(05).                  
           05 WS-PARM-COMP-NO               PIC 9(02).                  
                                                                        
       PROCEDURE DIVISION USING WS-PARM-VALUE.                          
                                                                        
      ***************************************************************** 00065400
      *    0000-MAINLINE                                             ** 00065500
      ***************************************************************** 00065700
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
                                                                        
           PERFORM 2000-PROCESS-ACCOUNTS       THRU 2000-EXIT           
             UNTIL END-OF-CA213.                                        
                                                                        
           IF WS-PARM-ERROR NOT = 'Y'                                   
              PERFORM 2500-DELETE-DATA         THRU 2500-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 00072100
      *    0100-INITIALIZATION                                       ** 00072200
      *    OPEN FILES                                                ** 00072300
      ***************************************************************** 00072500
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           OPEN INPUT FCSCA213-FILE.                                    
           IF NOT FCA213-SUCCESSFUL                                     
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZE                  '         
               DISPLAY '**   ERROR OPENING FCSCA213'                    
               DISPLAY '**   FILE STATUS = ' WS-FCA213-STATUS           
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND             THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           INITIALIZE  WS-MISC.                                         
           PERFORM 0110-VALIDATE-PARM    THRU 0110-EXIT.                
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ** 0110-VALIDATE-PARM                                         **  00122700
      ** VALIDATE THE PARM VALUES ENTERED                           **          
      ****************************************************************  00122600
       0110-VALIDATE-PARM.                                              
                                                                        
            IF WS-PARM-REV-MO-START NUMERIC                             
               MOVE WS-PARM-REV-MO-START     TO WS-REVENUE-MONTH-START  
               IF WS-REVENUE-CCYY-ST < 2000 OR                          
                  WS-REVENUE-MM-ST > 12                                 
                  DISPLAY 'PCSCA213 - ERROR IN PARM STARTING REV-MONTH' 
                  MOVE 'Y'               TO WS-PARM-ERROR               
               END-IF                                                   
            ELSE                                                        
              DISPLAY 'PCSCA213 - PARM STARTING REV MONTH NOT NUMERIC ' 
              MOVE 'Y'                   TO WS-PARM-ERROR               
            END-IF.                                                     
                                                                        
            IF WS-PARM-REV-MO-END NUMERIC                               
               MOVE WS-PARM-REV-MO-END   TO WS-REVENUE-MONTH-END        
               IF WS-REVENUE-CCYY-END < 2000 OR                         
                  WS-REVENUE-MM-END > 12                                
                  DISPLAY 'PCSCA213 - ERROR IN PARM ENDING REV-MONTH'   
                  MOVE 'Y'               TO WS-PARM-ERROR               
               END-IF                                                   
            ELSE                                                        
              DISPLAY 'PCSCA213 - PARM ENDING REV MONTH NOT NUMERIC '   
              MOVE 'Y'                   TO WS-PARM-ERROR               
            END-IF.                                                     
                                                                        
            IF WS-PARM-CYC-START NUMERIC                                
               IF WS-PARM-CYC-START < 01 OR WS-PARM-CYC-START > 21      
                  DISPLAY 'PCSCA213 - PARM START CYCLE OUT OF BOUNDS '  
                  MOVE 'Y'               TO WS-PARM-ERROR               
               END-IF                                                   
            ELSE                                                        
              DISPLAY 'PCSCA213 - PARM START CYCLE NOT NUMERIC '        
              MOVE 'Y'                   TO WS-PARM-ERROR               
            END-IF.                                                     
                                                                        
            IF WS-PARM-CYC-END NUMERIC                                  
               IF WS-PARM-CYC-END < 01 OR WS-PARM-CYC-END > 21          
                  DISPLAY 'PCSCA213 - PARM END CYCLE OUT OF BOUNDS '    
                  MOVE 'Y'               TO WS-PARM-ERROR               
               END-IF                                                   
            ELSE                                                        
              DISPLAY 'PCSCA213 - PARM END CYCLE NOT NUMERIC '          
              MOVE 'Y'                   TO WS-PARM-ERROR               
            END-IF.                                                     
                                                                        
            IF WS-PARM-MSG-TYPE = ('M' OR 'I')                          
               CONTINUE                                                 
            ELSE                                                        
              DISPLAY 'PCSCA213 - INVALID PARM MSG TYPE      '          
              DISPLAY 'PARM MSG TYPE ' WS-PARM-MSG-TYPE                 
              DISPLAY 'VALID PARM TYPES M-MESSAGE, I-INSERTS '          
              MOVE 'Y'                   TO WS-PARM-ERROR               
            END-IF.                                                     
                                                                        
            IF WS-PARM-MSG-TYPE = 'M'                                   
               IF WS-PARM-MSG-ID  NOT NUMERIC                           
                  DISPLAY 'PCSCA213 - PARM MESSAGE ID MUST BE NUMERIC'  
                  MOVE 'Y'               TO WS-PARM-ERROR               
               END-IF                                                   
            END-IF.                                                     
                                                                        
      ******************************************************************        
      * PARM MSG ID FOR INSERT IS THE POCKET NUMBER THAT WILL HAVE THE *        
      * INSERT FOR THE MONTH.                                          *        
      ******************************************************************        
            IF WS-PARM-MSG-TYPE = 'I'                                   
               IF WS-PARM-MSG-ID  NOT = ('    2' AND '    3' AND        
                                         '    4' AND '    5')           
                  DISPLAY 'PCSCA213 - PARM INSERT POCKET-NO NOT NUMERIC'
                  MOVE 'Y'               TO WS-PARM-ERROR               
               END-IF                                                   
            END-IF.                                                     
                                                                        
            IF WS-PARM-COMP-NO NOT NUMERIC                              
               DISPLAY 'PCSCA213 - PARM COMPANY NUMBER IS NOT NUMERIC'  
               MOVE 'Y'                  TO WS-PARM-ERROR               
            END-IF.                                                     
                                                                        
            IF WS-PARM-ERROR = 'Y'                                      
               DISPLAY '***   PLEASE CHECK PARM VALUES   ***'           
               DISPLAY '***   ERROR IN PCSCA213 PARM     ***'           
               MOVE 12                 TO RETURN-CODE                   
               PERFORM 9000-TERMINATE        THRU 9000-EXIT             
            END-IF.                                                     
                                                                        
            MOVE WS-PARM-REV-MO-START  TO U1-REVENUE-MO-ST.             
            MOVE WS-PARM-MSG-ID        TO U1-BILL-MSG-ID.               
            MOVE WS-PARM-MSG-TYPE      TO U1-MSG-TYPE-CD.               
            MOVE WS-PARM-COMP-NO       TO U1-COMPANY-NO.                
            MOVE WS-PARM-CYC-START     TO U1-BILL-CYCLE-ST.             
            MOVE WS-PARM-CYC-END       TO U1-BILL-CYCLE-END.            
            MOVE WS-PARM-REV-MO-END    TO U1-REVENUE-MO-END.            
                                                                        
       0110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 00128700
      *   2000-PROCESS-ACCOUNTS.                                     ** 00128300
      * READS THE DATA FROM INPUT FILE AND LOADS TO WORKING STORAGE  ** 00128400
      * TABLES.                                                      ** 00128500
      ***************************************************************** 00128700
                                                                        
       2000-PROCESS-ACCOUNTS.                                           
                                                                        
           PERFORM 7000-READ-FCSCA213 THRU 7000-EXIT.                   
                                                                        
           IF NOT END-OF-CA213                                          
             MOVE E-FCA213-ACCOUNT-NO      TO WS-ACCOUNT-NUMBER         
             MOVE WS-ACCOUNT-NUMBER        TO WS-DISPLAY-ACCOUNT        
             DISPLAY 'ACCOUNT NUMBER ' WS-DISPLAY-ACCOUNT               
             COMPUTE WS-COUNTER = WS-COUNTER + 1                        
                                                                        
             MOVE E-FCA213-ACCOUNT-NO       TO  U1-ACCOUNT-NO           
                                                                        
             PERFORM 8000-INSERT-BILL-MSG    THRU 8000-EXIT             
           END-IF.                                                      
                                                                        
           IF WS-CNTR-TEST = 0                                          
              DISPLAY 'CHECKPOINT ' WS-CHECK-POINT                      
              PERFORM 8100-ISSUE-COMMIT    THRU 8100-EXIT               
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *********************************************************         11820000
      *   DELETE DATA THAT IS OLD FOR MORE THAN 3 MONTHS.     *         11830000
      *********************************************************         11850000
       2500-DELETE-DATA.                                                
                                                                        
           PERFORM 7100-SELECT-PRIOR-DATE    THRU 7100-EXIT.            
                                                                        
           MOVE WS-PRIOR-CCYY              TO WS-REVENUE-CCYY-ST        
                                              WS-REVENUE-CCYY-END.      
           MOVE WS-PRIOR-MONTH             TO WS-REVENUE-MM-ST          
                                              WS-REVENUE-MM-END.        
           MOVE WS-REVENUE-MONTH-START     TO U1-REVENUE-MO-ST          
           MOVE WS-REVENUE-MONTH-END       TO U1-REVENUE-MO-END.        
                                                                        
           PERFORM 8200-DELETE-SPCL-BILL-MSG THRU 8200-EXIT.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              DISPLAY 'NO ROWS TO DELETE FOR REV DATE OLDER THAN'       
              DISPLAY 'REV MONTH ST  ' U1-REVENUE-MO-ST                 
              DISPLAY 'REV MONTH END ' U1-REVENUE-MO-END                
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  00122600
      ** 7000-READ-FCSCA213.                                        **  00122700
      ** READ THE INPUT FILE FCSCA213.                              **  00122800
      ****************************************************************  00123100
       7000-READ-FCSCA213.                                              
                                                                        
           READ FCSCA213-FILE AT END                                    
                MOVE 'Y'                   TO WS-END-OF-CA213.          
           IF FCA213-SUCCESSFUL OR END-OF-CA213                         
              ADD  +1                      TO WS-RECORDS-READ           
           ELSE                                                         
              MOVE 12                      TO RETURN-CODE               
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA213 PROCESSING ERROR      **'        
              DISPLAY '**       ERROR READING FCSCA213       **'        
              DISPLAY '**     FILE STATUS = ' WS-FCA213-STATUS          
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-SELECT-PRIOR-DATE                                         *        
      *    SELECT 3 MONTHS PRIOR DATE FROM CURRENT DATE                *        
      ******************************************************************        
       7100-SELECT-PRIOR-DATE.                                          
                                                                        
           EXEC SQL                                                     
             SELECT
              DATEADD( MONTH, -3, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-PRIOR-DATE              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     11400000
MFA-TR*      SET :WS-PRIOR-DATE  = CURRENT DATE - 3 MONTHS                      
MFA-TR*    END-EXEC.                                                    11500000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                WS-DISPLAY-SQLCODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -803       
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY 'SQLCODE ' WS-DISPLAY-SQLCODE                     
              MOVE 12                        TO RETURN-CODE             
              MOVE WS-PGRMNAME               TO ABEND-PROGRAM           
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT 3 MNTHS PRIOR DT' TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000-INSERT-BILL-MSG                                           *        
      *    INSERT ROW IN THE  CSS_SPCL_BILL_MSG  TABLE                 *        
      ******************************************************************        
       8000-INSERT-BILL-MSG.                                            
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_SPCL_BILL_MSG                             
                    ( REVENUE_MO_ST                                     
                    , ACCOUNT_NO                                        
                    , BILL_MSG_ID                                       
                    , MSG_TYPE_CD                                       
                    , COMPANY_NO                                        
                    , BILL_CYCLE_ST                                     
                    , BILL_CYCLE_END                                    
                    , REVENUE_MO_END)                                   
              VALUES (:U1-REVENUE-MO-ST                                 
                    , :U1-ACCOUNT-NO                                    
                    , :U1-BILL-MSG-ID                                   
                    , :U1-MSG-TYPE-CD                                   
                    , :U1-COMPANY-NO                                    
                    , :U1-BILL-CYCLE-ST                                 
                    , :U1-BILL-CYCLE-END                                
                    , :U1-REVENUE-MO-END)                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                WS-DISPLAY-SQLCODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -803       
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY 'SQLCODE ' WS-DISPLAY-SQLCODE                     
              MOVE 12                        TO RETURN-CODE             
              MOVE WS-PGRMNAME               TO ABEND-PROGRAM           
              MOVE '8000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_SPCL_BILL_MSG'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL_MSG_ID'             TO TABLE-ELEMENT-2         
              MOVE 'REVENUE_MO_END'          TO TABLE-ELEMENT-3         
              MOVE U1-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE U1-BILL-MSG-ID            TO HOSTVAR-ELEMENT-2       
              MOVE U1-REVENUE-MO-END         TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
      *                                                                         
      ****************************************************************  04850000
      **  8100-ISSUE-COMMIT.                                        **          
      **      GET COMMIT AFTER EVERY 100 RECORDS UPDATED            **  04880000
      ****************************************************************  04900000
      *                                                                         
       8100-ISSUE-COMMIT.                                               
                                                                        
           EXEC SQL                                                     
               COMMIT                                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          WS-DISPLAY-SQLCODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY 'SQLCODE ' WS-DISPLAY-SQLCODE                     
              MOVE 12                        TO RETURN-CODE             
              DISPLAY '*******************************************'     
              DISPLAY ' ERROR IN PCSCA213 8100-ISSUE-COMMIT       '     
              DISPLAY ' RETURN CODE      = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND       THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                         
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8200-DELETE-SPCL-BILL-MSG.                                       
      *                                                                         
           EXEC SQL                                                     
              DELETE FROM CSS_SPCL_BILL_MSG                             
               WHERE REVENUE_MO_ST   <  :U1-REVENUE-MO-ST               
                 AND REVENUE_MO_END  <  :U1-REVENUE-MO-END              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                WS-DISPLAY-SQLCODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY 'SQLCODE ' WS-DISPLAY-SQLCODE                     
              MOVE 12                        TO RETURN-CODE             
              MOVE WS-PGRMNAME               TO ABEND-PROGRAM           
              MOVE '8200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_SPCL_BILL_MSG'       TO TABLE-1                 
              MOVE 'REVENUE_MO_ST'           TO TABLE-ELEMENT-1         
              MOVE U1-REVENUE-MO-ST          TO HOSTVAR-ELEMENT-1       
              MOVE 'REVENUE_MO_END'          TO TABLE-ELEMENT-2         
              MOVE U1-REVENUE-MO-END         TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
           EXIT.                                                        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSCA213-FILE.                                         
           STOP RUN.                                                    
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *************************                                         13900000
      *  9700-PROCESS-ABEND  **                                         13920000
      *************************                                         13940000
      *                                                                 13950000
       COPY CPD0023B.                                                   13960000
      *                                                                 13970000
      ******************************************************************        
      *     9900-ABEND                                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     19620000
              INCLUDE CPD09900                                          19630000
           END-EXEC.                                                    19640000
      *                                                                         
