       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSCA204.                                            
       AUTHOR. SJ94244.                                                 
       DATE-WRITTEN. FEB 2010.                                          
      ******************************************************************        
      **               SOUTH CAROLINA ELECTRIC & GAS                  **        
      **                      COBOL-DB2                               **        
      ******************************************************************        
      **                     PROGRAM SUMMARY                          **        
      ******************************************************************        
      **                                                              **        
      ** PROGRAM TO INSERT DATA IN THE FOLLOWING REVENUE TABLES       **        
      ** USING THE REVENUE FILES GENERATED FROM PCSCA177              **        
      **                                                              **        
      ** FCSCREVD - REV_BILLING_DET                                   **        
      ** FCSCREVC - REV_BILL_COMP_ADJ                                 **        
      ** FCSCREVB - REV_BILL_BLOCK                                    **        
      ** FCSCREVT - REV_BILL_TAX                                      **        
      **                                                              **        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     INPUT PROCESSING CONTROL PATH         **        
      **        2000 - 2999     OUTPUT PROCESS CONTROL PATH           **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     COMMON SYSTEM MODULES                 **        
      **        7000 - 7999     INPUT MODULES                         **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      **              PROGRAM  MODIFICATION  LOG                      **        
      ******************************************************************        
      ** DATE     USERID   REASON                                     **        
      ** -------  -------  ------                                     **        
P00257** 02/2010  SJ94244  INITIAL IMPLEMENTATION.                    **        
P00257** 06/24/10 SJ94244  INCLUDED THE UPDATE FOR JOB PARM TABLE     **        
P00257** 08/02/10 SJ94244  ADDED NEW FIELDS TO REVENUE FILES.         **        
PRJ257** 11/12/10 SB93596  UPDATING THE VALUE OF REV MONTH IN THE     **        
PRJ257**                   JOB PARM TABLE FOR PROGRAM PCSCA204.       **        
PRJ257** 02/2011  SB93596  POPULATE THE BN-DATE-EXTRACT DURING RESTART**        
PRJ257** 04/2011  GOKUL    DELETE THE CSS_RESTART DATA AFTER          **        
PRJ257**                   PROCESSING IS COMPLETE.                    **        
A04581** 02/22/13 SV95326  RETRIEVE E-REVDET-ELEC-WNA-GROUP-NO FROM   **        
A04581**          ACT002   FCSCREVD FILE AND WRITE IT IN              **        
A04581**                   REV_BILLING_DET TABLE.                     **        
A03970** 06/17/13 AS7C117  ADD JOB PARM FOR COMMONDATE TO SUBSTITUTE  **        
A03970**          ACT016   COMMONDATE VALUE FROM CSS_JOB_PARM. VALUE  **        
A03970**                   IS SUPPLIED FROM JCL THROUGH PARM.         **        
      ******************************************************************        
       ENVIRONMENT DIVISION.                                            
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
                                                                        
       COPY CSSREVD.                                                            
       COPY CSSREVB.                                                            
       COPY CSSREVC.                                                            
       COPY CSSREVT.                                                            
      *                                                                         
       DATA DIVISION.                                                   
                                                                        
       FILE SECTION.                                                    
      ******************************************************************        
      *INPUT FILES                                                     *        
      ******************************************************************        
                                                                        
       COPY CFDCREVD.                                                           
       COPY FCSCREVD.                                                           
                                                                        
       COPY CFDCREVC.                                                           
       COPY FCSCREVC.                                                           
                                                                        
       COPY CFDCREVB.                                                           
       COPY FCSCREVB.                                                           
                                                                        
       COPY CFDCREVT.                                                           
       COPY FCSCREVT.                                                           
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ012      EXEC SQL INCLUDE MFADIAG END-EXEC
MSQ009  01 MSQ009-SQLCODE  PIC S9(9) COMP-4.
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA204'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                      PIC X(40) VALUE                 
                        'WORKING STORAGE FOR PCSCA204 STARTS HERE'.     
      *                                                                         
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME               PIC X(08) VALUE 'PCSCA204'.     
          05 WS-PGRMNAME                PIC X(10) VALUE 'PCSCA204'.     
          05 WS-I                       PIC X(01) VALUE 'I'.            
          05 WS-Y                       PIC X(1)  VALUE 'Y'.            
          05 WS-N                       PIC X(01) VALUE 'N'.            
          05 WS-COMMON-DATE             PIC X(10) VALUE 'COMMONDATE'.   
          05 WS-FCSCREVD                PIC X(08) VALUE 'FCSCREVD'.     
          05 WS-FCSCREVC                PIC X(08) VALUE 'FCSCREVC'.     
          05 WS-FCSCREVB                PIC X(08) VALUE 'FCSCREVB'.     
          05 WS-FCSCREVT                PIC X(08) VALUE 'FCSCREVT'.     
      *                                                                         
       01 WS-MISC.                                                      
          05 WS-FLAG-TO-TURN-OFF-COMMITS                                
                                        PIC S9(04) COMP VALUE +9999.    
          05 WS-COUNT-UNSUCCESSFUL-ROWS PIC S9(04) VALUE ZEROES COMP.   
P00257    05 WS-JOB-PARM-DATA           PIC X(80) VALUE SPACES.         
                                                                        
P00257 01 WS-BILL-UNIQUE-TS-DATA.                                       
P00257    10 WS-BILL-UNIQUE-TS-TXT      PIC X(15)                       
P00257                                  VALUE 'BILL-UNIQUE-TS='.        
P00257    10 WS-BILL-UNIQUE-TS          PIC X(26) VALUE SPACES.         
P00257    10 FILLER                     PIC X(39) VALUE SPACES.         
                                                                        
       01 WS-RESTART-MISC.                                              
          05 WS-RESTART-DATA-LENGTH     PIC S9(04) COMP VALUE +54.      
          05 WS-DEFAULT-RESTART-REQ     PIC X(01) VALUE 'N'.            
          05 WS-IS-THIS-A-RESTART       PIC X(01) VALUE 'N'.            
             88 WS-THIS-IS-A-RESTART              VALUE 'Y'.            
             88 WS-THIS-IS-NOT-A-RESTART          VALUE 'N'.            
          05 WS-RESTART-REQ             PIC X(01).                      
          05 WS-CHKP-LUW-LIMIT          PIC 9(04) VALUE 0.              
          05 WS-CHKP-UPD-LIMIT          PIC 9(04) VALUE 0.              
          05 WS-CHKP-SEQ-NO             PIC 9(05) COMP VALUE 0.         
          05 WS-DEFAULT-CHKP-LUW-LIMIT  PIC 9(04) VALUE 5.              
          05 WS-DEFAULT-CHKP-UPD-LIMIT  PIC 9(04) VALUE 5.              
          05 WS-SEQ-NO                  PIC S9(04)V COMP-3 VALUE 0.     
          05 WS-RESTART-COMMIT-COUNTER  PIC S9(9) USAGE COMP VALUE +0.  
          05 WS-ROW-COUNT               PIC S9(09) USAGE COMP VALUE 0.  
          05 WS-ROW-ERRORS              PIC S9(09) USAGE COMP VALUE 0.  
          05 WS-DB2-SQLCODE             PIC S9(09) USAGE COMP VALUE 0.  
          05 WS-DB2-ROW-NUM             PIC S9(09) USAGE COMP VALUE 0.  
          05 WS-DISP-INSERT-COUNT       PIC +Z(9).                      
          05 WS-DISP-ROW-COUNT          PIC +Z(9).                      
          05 WS-DISP-ROW-NUM            PIC +Z(9).                      
          05 WS-DISP-DB2-SQLCODE        PIC +Z(9).                      
          05 WS-DISP-FILE-COUNTER       PIC +Z(9).                      
          05 WS-ROW-NUM                 PIC S9(09) USAGE COMP VALUE 0.  
          05 WS-FILE-NAME               PIC X(08) VALUE SPACES.         
             88 FCSCREVD-FL             VALUE 'FCSCREVD'.               
             88 FCSCREVC-FL             VALUE 'FCSCREVC'.               
             88 FCSCREVB-FL             VALUE 'FCSCREVB'.               
             88 FCSCREVT-FL             VALUE 'FCSCREVT'.               
          05 WS-TIME-STAMP              PIC X(26) VALUE SPACES.         
          05 WS-RECORD-CTR              PIC S9(09) USAGE COMP VALUE +0. 
      *                                                                         
       01 WS-RESTART-DATA.                                              
          05 WS-RESTART-PROCESS-TYPE    PIC 9(01).                      
          05 WS-RESTART-JOB-COMPLETE    REDEFINES                       
             WS-RESTART-PROCESS-TYPE    PIC X(01).                      
          05 WS-RESTART-JOB-STATUS      PIC X(01).                      
             88 WS-RUN-COMPLETED-NO-PROBLEMS VALUE 'A'.                 
             88 WS-RERUN-COMPLETED           VALUE 'B'.                 
             88 WS-RERUN-PENDING             VALUE 'C'.                 
          05 WS-RESTART-COMMON-DATE     PIC X(10) VALUE SPACES.         
          05 WS-RESTART-CHKP-SEQ-NO     PIC S9(09) USAGE COMP VALUE +0. 
          05 WS-RESTART-FILE-NAME       PIC X(08) VALUE SPACES.         
          05 WS-RESTART-TIME-STAMP      PIC X(26) VALUE SPACES.         
          05 WS-RESTART-REC-CTR         PIC S9(09) USAGE COMP VALUE +0. 
      *                                                                         
       01 WS-SUBSCRIPTS.                                                
          05 REVD-INDX                  PIC S9(9) USAGE COMP VALUE +0.  
          05 REVC-INDX                  PIC S9(9) USAGE COMP VALUE +0.  
          05 REVB-INDX                  PIC S9(9) USAGE COMP VALUE +0.  
          05 REVT-INDX                  PIC S9(9) USAGE COMP VALUE +0.  
      *                                                                         
       01 WS-COUNTERS.                                                  
          05 WS-FCSCREVD-REC-COUNTER    PIC S9(9) USAGE COMP VALUE +0.  
          05 WS-FCSCREVC-REC-COUNTER    PIC S9(9) USAGE COMP VALUE +0.  
          05 WS-FCSCREVB-REC-COUNTER    PIC S9(9) USAGE COMP VALUE +0.  
          05 WS-FCSCREVT-REC-COUNTER    PIC S9(9) USAGE COMP VALUE +0.  
          05 WS-READY-TO-INSERT-COUNT   PIC S9(9) USAGE COMP VALUE +0.  
          05 WS-READY-TO-COMMIT-COUNT   PIC S9(9) USAGE COMP VALUE +0.  
          05 WS-INSERT-COUNT            PIC S9(9) USAGE COMP VALUE +0.  
          05 WS-DEFAULT-INSERT-COUNT    PIC S9(9) USAGE COMP VALUE +20. 
      *                                                                         
       01 WS-SWITCHES.                                                  
          05 WS-RECORD-FOUND             PIC X(01) VALUE 'N'.           
             88 DATA-RECORD-FOUND                  VALUE 'Y'.           
             88 NO-DATA-RECORD-FOUND               VALUE 'N'.           
                                                                        
          05 WS-FCSCREVB-STATUS          PIC X(02).                     
             88 FCSCREVB-SUCCESSFUL                VALUE '00'.          
             88 END-OF-FCSCREVB                    VALUE '10'.          
                                                                        
          05 WS-FCSCREVC-STATUS          PIC X(02).                     
             88 FCSCREVC-SUCCESSFUL                VALUE '00'.          
             88 END-OF-FCSCREVC                    VALUE '10'.          
                                                                        
          05 WS-FCSCREVD-STATUS          PIC X(02).                     
             88 FCSCREVD-SUCCESSFUL                VALUE '00'.          
             88 END-OF-FCSCREVD                    VALUE '10'.          
                                                                        
          05 WS-FCSCREVT-STATUS          PIC X(02).                     
             88 FCSCREVT-SUCCESSFUL                VALUE '00'.          
             88 END-OF-FCSCREVT                    VALUE '10'.          
                                                                        
          05 WS-IS-THIS-FCSCREVD-RESTART PIC X(01) VALUE 'N'.           
             88 RESTART-FCSCREVD                   VALUE 'Y'.           
                                                                        
          05 WS-IS-THIS-FCSCREVC-RESTART PIC X(01) VALUE 'N'.           
             88 RESTART-FCSCREVC                   VALUE 'Y'.           
                                                                        
          05 WS-IS-THIS-FCSCREVB-RESTART PIC X(01) VALUE 'N'.           
             88 RESTART-FCSCREVB                   VALUE 'Y'.           
                                                                        
          05 WS-IS-THIS-FCSCREVT-RESTART PIC X(01) VALUE 'N'.           
             88 RESTART-FCSCREVT                   VALUE 'Y'.           
                                                                        
P00257    05 WS-IS-THIS-JOB-PARM-UPD     PIC X(01) VALUE 'N'.           
P00257       88 JOB-PARM-UPD                       VALUE 'Y'.           
P00257       88 NO-JOB-PARM-UPD                    VALUE 'N'.           
      *                                                                         
       01 WS-FCSCREVD-ARRAY.                                            
          05 WS-RV-BILL-UNIQUE-TS       PIC X(26)                       
                                        OCCURS 15000 TIMES.             
          05 WS-RV-REV-COMPANY-NO       PIC X(2)                        
                                        OCCURS 15000 TIMES.             
          05 WS-RV-COMPANY-NO           PIC X(2)                        
                                        OCCURS 15000 TIMES.             
COB305    05 WS-RV-REVENUE-MONTH        PIC S9(6)V USAGE COMP-3 
COB305       OCCURS 15000 TIMES VALUE 0.             
          05 WS-RV-CODE-SERVICE-TYPE    PIC X(1)                        
                                        OCCURS 15000 TIMES.             
COB305    05 WS-RV-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 
COB305       OCCURS 15000 TIMES VALUE 0.             
          05 WS-RV-BILL-NO              PIC S9(9) USAGE COMP            
                                        OCCURS 15000 TIMES.             
          05 WS-RV-CODE-UTIL-TYPE       PIC X(1)                        
                                        OCCURS 15000 TIMES.             
          05 WS-RV-IC-NO                PIC S9(4) USAGE COMP            
                                        OCCURS 15000 TIMES.             
          05 WS-RV-BILL-ITEM-TIMESTMP   PIC X(26)                       
                                        OCCURS 15000 TIMES.             
          05 WS-RV-CUST-CT              PIC S9(9) USAGE COMP            
                                        OCCURS 15000 TIMES.             
          05 WS-RV-CUST-CT-EXCL-LIGHT   PIC S9(9) USAGE COMP            
                                        OCCURS 15000 TIMES.             
          05 WS-RV-USAGE-END-DATE       PIC X(10)                       
                                        OCCURS 15000 TIMES.             
          05 WS-RV-USAGE-END-DATE-NULL-IND PIC S9(4) USAGE COMP         
                                           OCCURS 15000 TIMES.          
          05 WS-RV-NO-OF-CONS-DAYS      PIC S9(4) USAGE COMP            
                                        OCCURS 15000 TIMES.             
          05 WS-RV-PRORATED-DAYS-CD     PIC X(1)                        
                                        OCCURS 15000 TIMES.             
COB305    05 WS-RV-BTU-FACTOR        PIC S9(2)V9(5) USAGE COMP-3 
COB305       OCCURS 15000 TIMES VALUE 0.             
COB305    05 WS-RV-GAS-BASE-USE        PIC S9(9)V USAGE COMP-3 
COB305       OCCURS 15000 TIMES VALUE 0.             
COB305    05 WS-RV-DESIGN-DAY-CAP        PIC S9(5)V9(3) USAGE COMP-3 
COB305       OCCURS 15000 TIMES VALUE 0.             
          05 WS-RV-DATE-BILLED          PIC X(10)                       
                                        OCCURS 15000 TIMES.             
          05 WS-RV-DATE-BILLED-NULL-IND PIC S9(4) USAGE COMP            
                                        OCCURS 15000 TIMES.             
          05 WS-RV-DATE-ORIG-BILL       PIC X(10)                       
                                        OCCURS 15000 TIMES.             
          05 WS-RV-DATE-ORIG-BILL-NULL-IND PIC S9(4) USAGE COMP         
                                           OCCURS 15000 TIMES.          
          05 WS-RV-REV-MTH-ORIG-BILL    PIC S9(9) USAGE COMP            
                                        OCCURS 15000 TIMES.             
          05 WS-RV-ACCT-BILL-CYCLE      PIC X(2)                        
                                        OCCURS 15000 TIMES.             
          05 WS-RV-BILL-CALC-CYCLE      PIC X(2)                        
                                        OCCURS 15000 TIMES.             
          05 WS-RV-CODE-REV-ACCT-TYPE   PIC X(1)                        
                                        OCCURS 15000 TIMES.             
          05 WS-RV-CODE-REVENUE-CLASS   PIC X(3)                        
                                        OCCURS 15000 TIMES.             
          05 WS-RV-RATE-PLAN-NO         PIC X(3)                        
                                        OCCURS 15000 TIMES.             
          05 WS-RV-RATE-DEPT-CD         PIC X(3)                        
                                        OCCURS 15000 TIMES.             
          05 WS-RV-PRTY-SVC-CAT-CD      PIC X(2)                        
                                        OCCURS 15000 TIMES.             
          05 WS-RV-CODE-SIC-NO          PIC X(4)                        
                                        OCCURS 15000 TIMES.             
          05 WS-RV-NAICS-CD             PIC X(6)                        
                                        OCCURS 15000 TIMES.             
          05 WS-RV-TIER-ACCT-TYPE-CD    PIC X(1)                        
                                        OCCURS 15000 TIMES.             
          05 WS-RV-OPTION-CD            PIC X(12)                       
                                        OCCURS 15000 TIMES.             
          05 WS-RV-RATE-CALC-TYPE-CD    PIC X(2)                        
                                        OCCURS 15000 TIMES.             
          05 WS-RV-LOCAL-OFFICE         PIC X(3)                        
                                        OCCURS 15000 TIMES.             
          05 WS-RV-REV-DISTRICT-CD      PIC X(3)                        
                                        OCCURS 15000 TIMES.             
          05 WS-RV-MNICPLTY-COUNTY-CD   PIC X(4)                        
                                        OCCURS 15000 TIMES.             
COB305    05 WS-RV-PREMISE-NO        PIC S9(10)V USAGE COMP-3 
COB305       OCCURS 15000 TIMES VALUE 0.             
          05 WS-RV-CALC-SOURCE-CD       PIC X(1)                        
                                        OCCURS 15000 TIMES.             
A04581    05 WS-RV-ELEC-WNA-GROUP-NO    PIC S9(4) USAGE COMP            
A04581                                  OCCURS 15000 TIMES.             
      *                                                                         
       01 WS-FCSCREVC-ARRAY.                                            
          05 WS-RB-BILL-UNIQUE-TS       PIC X(26)                       
                                        OCCURS 15000 TIMES.             
          05 WS-RB-BILL-COMP-SEQ-NO     PIC S9(4) USAGE COMP            
                                        OCCURS 15000 TIMES.             
          05 WS-RB-CMPNT-ID-CD          PIC X(2)                        
                                        OCCURS 15000 TIMES.             
          05 WS-RB-INSTR-USE-TYPE-CD    PIC X(1)                        
                                        OCCURS 15000 TIMES.             
          05 WS-RB-CONSUMPT-TYPE-CD     PIC X(1)                        
                                        OCCURS 15000 TIMES.             
          05 WS-RB-CODE-TIME-PERIOD     PIC S9(4) USAGE COMP            
                                        OCCURS 15000 TIMES.             
          05 WS-RB-CODE-SEASON          PIC X(1)                        
                                        OCCURS 15000 TIMES.             
          05 WS-RB-RT-VERS-FROM-DT      PIC X(10)                       
                                        OCCURS 15000 TIMES.             
          05 WS-RB-RT-VERS-DT-NULL-IND  PIC S9(4) USAGE COMP            
                                           OCCURS 15000 TIMES.          
          05 WS-RB-RT-VERS-PRO-CD       PIC X(1)                        
                                        OCCURS 15000 TIMES.             
          05 WS-RB-FACTOR-ID            PIC X(9)                        
                                        OCCURS 15000 TIMES.             
          05 WS-RB-FACTOR-BLOCK-NO      PIC S9(9) USAGE COMP            
                                        OCCURS 15000 TIMES.             
          05 WS-RB-RT-FCT-FROM-DT       PIC X(10)                       
                                        OCCURS 15000 TIMES.             
          05 WS-RB-RT-FCTR-DT-NULL-IND  PIC S9(4) USAGE COMP            
                                           OCCURS 15000 TIMES.          
          05 WS-RB-RT-FCT-PRO-CD        PIC X(1)                        
                                        OCCURS 15000 TIMES.             
COB305    05 WS-RB-READ-UNITS        PIC S9(9)V USAGE COMP-3 
COB305       OCCURS 15000 TIMES VALUE 0.             
COB305    05 WS-RB-BILL-USAGE-UNITS        PIC S9(9)V USAGE COMP-3 
COB305       OCCURS 15000 TIMES VALUE 0.             
COB305    05 WS-RB-BILL-DEMAND-UNITS        PIC S9(9)V USAGE COMP-3 
COB305       OCCURS 15000 TIMES VALUE 0.             
COB305    05 WS-RB-CALC-UNITS        PIC S9(9)V USAGE COMP-3 
COB305       OCCURS 15000 TIMES VALUE 0.             
COB305    05 WS-RB-FACTOR        PIC S9(9)V9(6) USAGE COMP-3 
COB305       OCCURS 15000 TIMES VALUE 0.             
COB305    05 WS-RB-BILLED-AMT        PIC S9(9)V9(2) USAGE COMP-3 
COB305       OCCURS 15000 TIMES VALUE 0.             
          05 WS-RB-CODE-STAT-TAX-XMT    PIC X(1)                        
                                        OCCURS 15000 TIMES.             
          05 WS-RB-CODE-CITY-TAX-XMT    PIC X(1)                        
                                        OCCURS 15000 TIMES.             
          05 WS-RB-CODE-OTHR-TAX-XMT    PIC X(1)                        
                                        OCCURS 15000 TIMES.             
          05 WS-RB-UTILITY-REV-CD       PIC X(1)                        
                                        OCCURS 15000 TIMES.             
          05 WS-RB-COMP-ADJ-CD          PIC X(1)                        
                                        OCCURS 15000 TIMES.             
COB305    05 WS-RB-GL-ACCT-NO        PIC S9(3)V9(4) USAGE COMP-3 
COB305       OCCURS 15000 TIMES VALUE 0.             
          05 WS-RB-SPCL-GROUP-CD        PIC X(2)                        
                                        OCCURS 15000 TIMES.             
COB305    05 WS-RB-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 
COB305       OCCURS 15000 TIMES VALUE 0.             
      *                                                                         
       01 WS-FCSCREVB-ARRAY.                                            
          05 WS-R7-BILL-UNIQUE-TS       PIC X(26)                       
                                        OCCURS 15000 TIMES.             
          05 WS-R7-BILL-COMP-SEQ-NO     PIC S9(4) USAGE COMP            
                                        OCCURS 15000 TIMES.             
          05 WS-R7-BLK-NO-RT-ITM-CD     PIC S9(4) USAGE COMP            
                                        OCCURS 15000 TIMES.             
COB305    05 WS-R7-BLK-USE-OR-SVCS        PIC S9(9)V USAGE COMP-3 
COB305       OCCURS 15000 TIMES VALUE 0.             
COB305    05 WS-R7-BLK-BILL-USE-UNITS        PIC S9(9)V USAGE COMP-3 
COB305       OCCURS 15000 TIMES VALUE 0.             
COB305    05 WS-R7-BLK-BILL-DEM-UNITS        PIC S9(7)V USAGE COMP-3 
COB305       OCCURS 15000 TIMES VALUE 0.             
          05 WS-R7-BLK-BILL-LT-POLES    PIC S9(9) USAGE COMP            
                                        OCCURS 15000 TIMES.             
          05 WS-R7-CUST-PER-SERVICE     PIC S9(4) USAGE COMP            
                                        OCCURS 15000 TIMES.             
          05 WS-R7-PRICE-TYPE-CD        PIC X(1)                        
                                        OCCURS 15000 TIMES.             
COB305    05 WS-R7-SCHED-PRICE-AM        PIC S9(5)V9(5) USAGE COMP-3 
COB305       OCCURS 15000 TIMES VALUE 0.             
COB305    05 WS-R7-UNIT-PRICE-AM        PIC S9(5)V9(5) USAGE COMP-3 
COB305       OCCURS 15000 TIMES VALUE 0.             
COB305    05 WS-R7-BLK-REV-AMT        PIC S9(9)V9(2) USAGE COMP-3 
COB305       OCCURS 15000 TIMES VALUE 0.             
          05 WS-R7-NET-UNIT-SEL-RSN     PIC X(1)                        
                                        OCCURS 15000 TIMES.             
          05 WS-R7-KW-MDQ-DT            PIC X(10)                       
                                        OCCURS 15000 TIMES.             
          05 WS-R7-KW-MDQ-DT-NULL-IND   PIC S9(4) USAGE COMP            
                                           OCCURS 15000 TIMES.          
          05 WS-R7-KVA-DT               PIC X(10)                       
                                        OCCURS 15000 TIMES.             
          05 WS-R7-KVA-DT-NULL-IND      PIC S9(4) USAGE COMP            
                                           OCCURS 15000 TIMES.          
COB305    05 WS-R7-CONTRACT-DEMAND        PIC S9(7)V USAGE COMP-3 
COB305       OCCURS 15000 TIMES VALUE 0.             
COB305    05 WS-R7-READ-KW-MDQ-UNITS        PIC S9(7)V USAGE COMP-3 
COB305       OCCURS 15000 TIMES VALUE 0.             
COB305    05 WS-R7-READ-KVA-UNITS        PIC S9(7)V USAGE COMP-3 
COB305       OCCURS 15000 TIMES VALUE 0.             
COB305    05 WS-R7-POWER-FACTOR        PIC S9(1)V9(2) USAGE COMP-3 
COB305       OCCURS 15000 TIMES VALUE 0.             
COB305    05 WS-R7-LOAD-FACTOR        PIC S9(1)V9(2) USAGE COMP-3 
COB305       OCCURS 15000 TIMES VALUE 0.             
COB305    05 WS-R7-RT-VERS-PRO-PCT        PIC S9(1)V9(5) USAGE COMP-3 
COB305       OCCURS 15000 TIMES VALUE 0.             
COB305    05 WS-R7-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 
COB305       OCCURS 15000 TIMES VALUE 0.             
P00257    05 WS-R7-RATE-ITEM-CODE       PIC S9(4) USAGE COMP            
                                        OCCURS 15000 TIMES.             
      *                                                                         
       01 WS-FCSCREVT-ARRAY.                                            
          05 WS-R9-BILL-UNIQUE-TS       PIC X(26)                       
                                        OCCURS 15000 TIMES.             
          05 WS-R9-TAX-TYPE             PIC X(1)                        
                                        OCCURS 15000 TIMES.             
          05 WS-R9-TAX-CNTRL-NO         PIC S9(4) USAGE COMP            
                                        OCCURS 15000 TIMES.             
          05 WS-R9-TAX-FROM-DT          PIC X(10)                       
                                        OCCURS 15000 TIMES.             
          05 WS-R9-FACTOR-ID            PIC X(9)                        
                                        OCCURS 15000 TIMES.             
COB305    05 WS-R9-TAX-GL-ACCT-NO        PIC S9(3)V9(4) USAGE COMP-3 
COB305       OCCURS 15000 TIMES VALUE 0.             
COB305    05 WS-R9-TAX-AMT        PIC S9(7)V9(2) USAGE COMP-3 
COB305       OCCURS 15000 TIMES VALUE 0.             
COB305    05 WS-R9-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 
COB305       OCCURS 15000 TIMES VALUE 0.             
      *                                                                         
       01 WS-PROGRAM-FLAGS.                                             
          05 WS-NO-MORE-DATA             PIC X(01) VALUE 'N'.           
             88 NO-MORE-DATA                       VALUE 'Y'.           
      *                                                                         
      ******************************************************************        
      *  ABEND SWITCH                                                  *        
      ******************************************************************        
      *  CWS00303 JOB PARM ROUTINE CONTAINS WS-WARNING-DATA-ELEMENTS   *        
      ******************************************************************        
       COPY CWS00303.                                                           
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE FOR CPD09900 CONTAINS ABEND WS VARIABLES       *        
      ******************************************************************        
       COPY CWS09900.                                                           
      *                                                                         
       COPY CWS00011.                                                           
      *                                                                         
      ******************************************************************        
      *  CWS00038 IS JC01 WORK DATA FOR RESTART PROCESSING             *        
      ******************************************************************        
       COPY CWS00038.                                                           
      *                                                                         
      *** BEWARE OF BELOW REDIFINITIONS, WHICH ARE LINK TO CWS00038             
                                                                        
       01  WS-INSERT-ROW-COUNT REDEFINES WS-INPUT-DATA-BREAKDOWN.       
           10  WS-PARM-INSERT-ROW-COUNT-TXT PIC X(21).                  
               88 INSERT-ROW-CNT         VALUE 'NO-OF-ROWS-TO-INSERT='. 
PRJ257     10  WS-NO-OF-ROWS-TO-INSERT   PIC X(05).                     
PRJ257     10  FILLER                    PIC X(54).                     
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
       01  WS-END                        PIC X(40)      VALUE           
                       'WORKING STORAGE FOR PCSCA204 ENDS HERE  '.      
      ******************************************************************        
      * DB2 INCLUDES.                                                  *        
      ******************************************************************        
      *    SQLCA                                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
PRJ257******************************************************************        
PRJ257*  CSS_BILL_WINDOW   - BN                                        *        
PRJ257******************************************************************        
PRJ257*                                                                         
PRJ257     EXEC SQL                                                             
PRJ257        INCLUDE TBBILWDW                                                  
PRJ257     END-EXEC.                                                            
PRJ257*                                                                         
      ******************************************************************        
      *  CSS_JOB_PARM      - G6                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_RESTART       - RF                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRESTRT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  REV_BILLING_DET   - RV                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBREVBLD                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  REV_BILL_COMP_ADJ - RB                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBREVCOM                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  REV_BILL_BLOCK    - R7                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBREVBLK                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  REV_BILL_TAX      - R9                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBREVTAX                                                  
           END-EXEC.                                                            
      *                                                                         
P00257 LINKAGE SECTION.                                                 
P00257                                                                  
P00257 01 WS-INPUT-PARM.                                                
P00257    05 PARM-LENGTH         PIC S9(4) COMP.                        
A03970    05 PARM-UPD-FLAG       PIC X(01).                             
A03970    05 PARM-COMMON-DATE    PIC X(10).                             
                                                                        
P00257 PROCEDURE DIVISION USING WS-INPUT-PARM.                          
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      * CONTROLS THE MAIN PATH OF THE PROGRAM                          *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM  0100-INITIALIZATION         THRU  0100-EXIT.        
           PERFORM  1000-PROCESS-INPUT          THRU  1000-EXIT.        
           PERFORM  9000-TERMINATE              THRU  9000-EXIT.        
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZATION                                            *        
      * OPEN OUTPUT FILE                                               *        
      ******************************************************************        
       0100-INITIALIZATION.                                             
                                                                        
           PERFORM 0110-GET-JOB-PARM-DETAILS    THRU 0110-EXIT.         
           PERFORM 0120-OPEN-FILES              THRU 0120-EXIT.         
           PERFORM 0130-PROCESS-FOR-RESTART     THRU 0130-EXIT.         
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0110-GET-JOB-PARM-DETAILS.                                     *        
      *    1. SELECT RUN-DATE                                          *        
      *    2. SELECT REVENUE-MONTH                                     *        
      *    3. GET INSERT ROW COUNT                                     *        
      ******************************************************************        
       0110-GET-JOB-PARM-DETAILS.                                       
      *                                                                         
A03970     IF PARM-LENGTH > 0 AND                                       
A03970        PARM-COMMON-DATE > SPACES                                 
A03970        MOVE PARM-COMMON-DATE                TO   WS-INPUT-DATE   
A03970     ELSE                                                         
A03970        PERFORM 6251-GET-FJC01-DATE          THRU 6251-EXIT       
A03970        IF COMMON-DATE-NEEDED                                     
A03970           PERFORM 0111-GET-COMMON-JP        THRU 0111-EXIT       
A03970        END-IF                                                    
A03970     END-IF.                                                      
                                                                        
           PERFORM 0115-GET-INSERT-ROW-COUNT    THRU 0115-EXIT.         
      *                                                                         
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0111-GET-COMMON-JP.                                            *        
      * GET COMMON FROM CSS_JOB_PARM, NOT COMMONDATE                   *        
      ******************************************************************        
       0111-GET-COMMON-JP.                                              
                                                                        
           MOVE SPACES                   TO WS-SYSIPT.                  
           MOVE 'COMMON'                 TO WS-PROGRAM.                 
           MOVE WS-DATE                  TO WS-COMMAND.                 
           MOVE ZEROS                    TO WS-SEQUENCE.                
           MOVE WS-KEY-AREA              TO E-FJC01-KEY.                
                                                                        
           PERFORM 7600-START-FCSJC01           THRU  7600-EXIT.        
                                                                        
           PERFORM 7610-READ-FCSJC01            THRU  7610-EXIT         
               UNTIL (RUN-DATE AND INPUT-ACTIVE)                        
                  OR  END-OF-SYSIPT.                                    
                                                                        
           EVALUATE TRUE                                                
              WHEN END-OF-SYSIPT                                        
                 DISPLAY ' '                                            
                 DISPLAY '**  PCSCA204 PROCESSING ERROR  **'            
                 DISPLAY '**    NO ACTIVE COMMON DATE FOUND'            
                 DISPLAY '**  PROCESSING TERMINATED **'                 
                 PERFORM 9900-ABEND             THRU 9900-EXIT          
              WHEN OTHER                                                
                 PERFORM 7611-CLOSE             THRU 7611-EXIT          
           END-EVALUATE.                                                
                                                                        
           MOVE WS-INPUT-RUN-DATE        TO WS-INPUT-DATE.              
      *                                                                         
       0111-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0115-GET-INSERT-ROW-COUNT.                                     *        
      * GET THE INSERT ROW COUNT FROM JOB PARM TABLE                   *        
      ******************************************************************        
       0115-GET-INSERT-ROW-COUNT.                                       
                                                                        
           MOVE  WS-PGRMNAME             TO WS-PROGRAM.                 
           MOVE  WS-PARM                 TO WS-COMMAND.                 
           MOVE  ZEROS                   TO WS-SEQUENCE.                
           MOVE  SPACES                  TO WS-SYSIPT.                  
           MOVE  WS-KEY-AREA             TO E-FJC01-KEY.                
                                                                        
           PERFORM 7600-START-FCSJC01      THRU  7600-EXIT.             
           PERFORM 7610-READ-FCSJC01       THRU  7610-EXIT              
              UNTIL (INSERT-ROW-CNT AND INPUT-ACTIVE)                   
              OR  END-OF-SYSIPT.                                        
                                                                        
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '** ' WS-PGRMNAME ' PROCESSING WARNING  **'       
              DISPLAY '**  INSERT-ROW-CNT PARM NOT ACTIVE     **'       
              DISPLAY '**  DEFAULT OF ' WS-DEFAULT-INSERT-COUNT         
                          ' WILL BE USED  **'                           
              DISPLAY '**  PROCESSING CONTINUING        **'             
              MOVE WS-DEFAULT-INSERT-COUNT                              
                                         TO WS-READY-TO-INSERT-COUNT    
                                            WS-INSERT-COUNT             
           ELSE                                                         
              IF WS-NO-OF-ROWS-TO-INSERT  NUMERIC                       
                 MOVE WS-NO-OF-ROWS-TO-INSERT                           
                                         TO WS-READY-TO-INSERT-COUNT    
                                            WS-INSERT-COUNT             
              ELSE                                                      
                 DISPLAY ' '                                            
                 DISPLAY '**  ' WS-PGRMNAME ' PROCESSING WARNING  **'   
                 DISPLAY '**  INSERT-ROW-CNT PARM NOT NUMERIC  **'      
                 DISPLAY '**  DEFAULT OF ' WS-DEFAULT-INSERT-COUNT      
                         ' WILL BE USED  **'                            
                 DISPLAY '**  PROCESSING CONTINUING        **'          
                 MOVE WS-DEFAULT-INSERT-COUNT                           
                                         TO WS-READY-TO-INSERT-COUNT    
                                            WS-INSERT-COUNT             
              END-IF                                                    
PRJ257        PERFORM 7611-CLOSE                 THRU 7611-EXIT         
           END-IF.                                                      
      *                                                                         
       0115-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0120-OPEN-FILES                                                *        
      * OPEN INPUT FILES                                               *        
      ******************************************************************        
       0120-OPEN-FILES.                                                 
      *                                                                         
           OPEN INPUT FCSCREVD-FILE.                                    
           IF NOT FCSCREVD-SUCCESSFUL                                   
              DISPLAY '********** PCSCA204 ABORT **************'        
              DISPLAY '*       0100-INITIALIZATION            *'        
              DISPLAY '*    ERROR OPENING FCSCREVD FILE       *'        
              DISPLAY '* FILE STATUS    : ' WS-FCSCREVD-STATUS          
              DISPLAY '*      PROCESSING TERMINATED           *'        
              DISPLAY '********** PCSCA204 ABORT **************'        
              PERFORM 9900-ABEND                THRU  9900-EXIT         
           END-IF.                                                      
      *                                                                         
           OPEN INPUT FCSCREVC-FILE.                                    
           IF NOT FCSCREVC-SUCCESSFUL                                   
              DISPLAY '********** PCSCA204 ABORT **************'        
              DISPLAY '*       0100-INITIALIZATION            *'        
              DISPLAY '*    ERROR OPENING FCSCREVC FILE       *'        
              DISPLAY '* FILE STATUS    : ' WS-FCSCREVC-STATUS          
              DISPLAY '*      PROCESSING TERMINATED           *'        
              DISPLAY '********** PCSCA204 ABORT **************'        
              PERFORM 9900-ABEND                THRU  9900-EXIT         
           END-IF.                                                      
      *                                                                         
           OPEN INPUT FCSCREVB-FILE.                                    
           IF NOT FCSCREVB-SUCCESSFUL                                   
              DISPLAY '********** PCSCA204 ABORT **************'        
              DISPLAY '*       0100-INITIALIZATION            *'        
              DISPLAY '*    ERROR OPENING FCSCREVB FILE       *'        
              DISPLAY '* FILE STATUS    : ' WS-FCSCREVB-STATUS          
              DISPLAY '*      PROCESSING TERMINATED           *'        
              DISPLAY '********** PCSCA204 ABORT **************'        
              PERFORM 9900-ABEND                THRU  9900-EXIT         
           END-IF.                                                      
      *                                                                         
           OPEN INPUT FCSCREVT-FILE.                                    
           IF NOT FCSCREVT-SUCCESSFUL                                   
              DISPLAY '********** PCSCA204 ABORT **************'        
              DISPLAY '*       0100-INITIALIZATION            *'        
              DISPLAY '*    ERROR OPENING FCSCREVT FILE       *'        
              DISPLAY '* FILE STATUS    : ' WS-FCSCREVT-STATUS          
              DISPLAY '*      PROCESSING TERMINATED           *'        
              DISPLAY '********** PCSCA204 ABORT **************'        
              PERFORM 9900-ABEND                THRU  9900-EXIT         
           END-IF.                                                      
      *                                                                         
       0120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0130-PROCESS-FOR-RESTART.                                      *        
      * PROCESS FOR THE RESTART                                        *        
      ******************************************************************        
       0130-PROCESS-FOR-RESTART.                                        
      *                                                                         
           INITIALIZE WS-SYSIPT.                                        
           PERFORM 6253-GET-FJC01-CHKP-LIMIT    THRU 6253-EXIT.         
                                                                        
           INITIALIZE WS-SYSIPT                                         
           PERFORM 6235-GET-FJC01-RESTART-REQ   THRU 6235-EXIT.         
                                                                        
           IF WS-CHKP-LUW-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS       
             AND WS-CHKP-UPD-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS    
                 DISPLAY '****PCSCA204 INFORMATIONAL MESSAGE******'     
                 DISPLAY '*     CHKP-LUW AND CHKP-UPD PARMS      *'     
                 DISPLAY '* BOTH SET TO ' WS-FLAG-TO-TURN-OFF-COMMITS   
                 DISPLAY '* , INTERPRETED TO INDICATE THAT       *'     
                 DISPLAY '* INTERIM COMMIT POINTS SHOULD NOT BE  *'     
                 DISPLAY '* TAKEN. COMPLETE RE-RUN REQUIRED UPON *'     
                 DISPLAY '*    UNSUCCESSFUL COMPLETION.          *'     
                 DISPLAY '* PROCESSING CONTINUING...             *'     
                 DISPLAY '****************************************'     
           END-IF.                                                      
                                                                        
           PERFORM 0200-CHECK-AND-VALDT-RESTART THRU 0200-EXIT.         
                                                                        
           IF WS-THIS-IS-A-RESTART                                      
              PERFORM 0300-PREPARE-RESTART      THRU 0300-EXIT          
           END-IF.                                                      
      *                                                                         
       0130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0200-CHECK-AND-VALDT-RESTART.                                  *        
      * VALIDATING RESTART                                             *        
      ******************************************************************        
       0200-CHECK-AND-VALDT-RESTART.                                    
      *                                                                         
           MOVE PROGRAM-NAME             TO RF-NAME-PROGRAM.            
           MOVE 1                        TO RF-PARTITION-NO.            
           MOVE 1                        TO RF-DUP-CNTRL-NO.            
                                                                        
           PERFORM 7050-SELECT-RESTART          THRU 7050-EXIT.         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE RF-RESTART-DATA-TEXT TO WS-RESTART-DATA             
               IF WS-RESTART-PROCESS-TYPE NUMERIC                       
                  MOVE WS-Y              TO WS-IS-THIS-A-RESTART        
               END-IF                                                   
           END-IF.                                                      
                                                                        
           PERFORM 0605-VALIDATE-RESTART-REQ    THRU 0605-EXIT.         
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0300-PREPARE-RESTART.                                          *        
      * PREPARE FOR RESTART                                            *        
      ******************************************************************        
       0300-PREPARE-RESTART.                                            
      *                                                                         
           DISPLAY '*******************************************'        
           DISPLAY '*       THIS IS A RESTART OF PCSCA204     *'        
           DISPLAY '*******************************************'        
                                                                        
           MOVE WS-RESTART-CHKP-SEQ-NO   TO WS-CHKP-SEQ-NO.             
           IF WS-RESTART-COMMON-DATE NOT EQUAL WS-INPUT-DATE            
                          AND WS-RESTART-COMMON-DATE NOT EQUAL SPACES   
              DISPLAY '********** PCSCA204 ABORT **************'        
              DISPLAY '*       0300-PREPARE-RESTART           *'        
              DISPLAY '* COMMON DATE CHANGED PRIOR TO RESTART *'        
              DISPLAY '* COMMON  DATE   : ' WS-INPUT-DATE               
              DISPLAY '* RESTART DATE   : ' WS-RESTART-COMMON-DATE      
              DISPLAY '*      PROCESSING TERMINATED           *'        
              DISPLAY '********** PCSCA204 ABORT **************'        
              PERFORM 9900-ABEND                    THRU  9900-EXIT     
           END-IF.                                                      
                                                                        
      * CHECK FOR THE FILE FROM WHICH THE RESTART SHOULD START.                 
                                                                        
           MOVE WS-RESTART-FILE-NAME     TO WS-FILE-NAME.               
           EVALUATE TRUE                                                
              WHEN FCSCREVD-FL                                          
                 PERFORM 0310-RESTART-FCSCREVD-FILE THRU 0310-EXIT      
                                                                        
              WHEN FCSCREVC-FL                                          
                 PERFORM 0320-RESTART-FCSCREVC-FILE THRU 0320-EXIT      
                                                                        
              WHEN FCSCREVB-FL                                          
                 PERFORM 0330-RESTART-FCSCREVB-FILE THRU 0330-EXIT      
                                                                        
              WHEN FCSCREVT-FL                                          
                 PERFORM 0340-RESTART-FCSCREVT-FILE THRU 0340-EXIT      
                                                                        
              WHEN OTHER                                                
                 DISPLAY 'NO FILE NAME MENTIONED IN RESTART DATA'       
           END-EVALUATE.                                                
                                                                        
           MOVE ZEROES                   TO WS-RESTART-COMMIT-COUNTER.  
      *                                                                         
       0300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *0310-RESTART-FCSCREVD-FILE                                      *        
      *RESTART REVENUE DETAIL FILE                                     *        
      ******************************************************************        
       0310-RESTART-FCSCREVD-FILE.                                      
                                                                        
           PERFORM 7100-READ-FCSCREVD          THRU  7100-EXIT          
             UNTIL WS-FCSCREVD-REC-COUNTER = WS-RESTART-REC-CTR         
                                                                        
           IF E-REVDET-BILL-UNIQUE-TS EQUAL WS-RESTART-TIME-STAMP       
              SET RESTART-FCSCREVD       TO TRUE                        
              SET RESTART-FCSCREVC       TO TRUE                        
              SET RESTART-FCSCREVB       TO TRUE                        
              SET RESTART-FCSCREVT       TO TRUE                        
           ELSE                                                         
              DISPLAY '********** PCSCA204 ABORT **************'        
              DISPLAY '*       0310-PREPARE-RESTART           *'        
              DISPLAY '* TMSTMP FROM RESTART TABLE DOES NOT   *'        
              DISPLAY '* MATCH WITH FCSCREVD FILE             *'        
              DISPLAY '* RESTART TMSTMP  : ' WS-RESTART-TIME-STAMP      
              DISPLAY '* FCSCREVD TMSTMP : ' E-REVDET-BILL-UNIQUE-TS    
              DISPLAY '*      PROCESSING TERMINATED           *'        
              DISPLAY '********** PCSCA204 ABORT **************'        
              PERFORM 9900-ABEND               THRU  9900-EXIT          
           END-IF.                                                      
      *                                                                         
       0310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *0320-RESTART-FCSCREVC-FILE                                      *        
      *RESTART REVENUE ADJUSTMENT FILE                                 *        
      ******************************************************************        
       0320-RESTART-FCSCREVC-FILE.                                      
      *                                                                         
           PERFORM 7200-READ-FCSCREVC          THRU  7200-EXIT          
             UNTIL WS-FCSCREVC-REC-COUNTER = WS-RESTART-REC-CTR         
                                                                        
           IF E-REVADJ-BILL-UNIQUE-TS EQUAL WS-RESTART-TIME-STAMP       
              SET RESTART-FCSCREVC       TO TRUE                        
              SET RESTART-FCSCREVB       TO TRUE                        
              SET RESTART-FCSCREVT       TO TRUE                        
           ELSE                                                         
              DISPLAY '********** PCSCA204 ABORT **************'        
              DISPLAY '*       0320-PREPARE-RESTART           *'        
              DISPLAY '* TMSTMP FROM RESTART TABLE DOES NOT   *'        
              DISPLAY '* MATCH WITH FCSCREVC FILE             *'        
              DISPLAY '* RESTART TMSTMP  : ' WS-RESTART-TIME-STAMP      
              DISPLAY '* FCSCREVC TMSTMP : ' E-REVADJ-BILL-UNIQUE-TS    
              DISPLAY '*      PROCESSING TERMINATED           *'        
              DISPLAY '********** PCSCA204 ABORT **************'        
              PERFORM 9900-ABEND               THRU  9900-EXIT          
           END-IF.                                                      
      *                                                                         
       0320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *0330-RESTART-FCSCREVB-FILE                                      *        
      *RESTART REVENUE BLOCK FILE                                      *        
      ******************************************************************        
       0330-RESTART-FCSCREVB-FILE.                                      
                                                                        
           PERFORM 7300-READ-FCSCREVB          THRU  7300-EXIT          
             UNTIL WS-FCSCREVB-REC-COUNTER = WS-RESTART-REC-CTR         
                                                                        
           IF E-REVBLK-BILL-UNIQUE-TS EQUAL WS-RESTART-TIME-STAMP       
              SET RESTART-FCSCREVB       TO TRUE                        
              SET RESTART-FCSCREVT       TO TRUE                        
           ELSE                                                         
              DISPLAY '********** PCSCA204 ABORT **************'        
              DISPLAY '*       0330-PREPARE-RESTART           *'        
              DISPLAY '* TMSTMP FROM RESTART TABLE DOES NOT   *'        
              DISPLAY '* MATCH WITH FCSCREVB FILE             *'        
              DISPLAY '* RESTART TMSTMP  : ' WS-RESTART-TIME-STAMP      
              DISPLAY '* FCSCREVB TMSTMP : ' E-REVBLK-BILL-UNIQUE-TS    
              DISPLAY '*      PROCESSING TERMINATED           *'        
              DISPLAY '********** PCSCA204 ABORT **************'        
              PERFORM 9900-ABEND               THRU  9900-EXIT          
           END-IF.                                                      
      *                                                                         
       0330-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *0340-RESTART-FCSCREVT-FILE                                      *        
      *RESTART REVENUE TAX FILE                                        *        
      ******************************************************************        
       0340-RESTART-FCSCREVT-FILE.                                      
      *                                                                         
           PERFORM 7400-READ-FCSCREVT          THRU  7400-EXIT          
             UNTIL WS-FCSCREVT-REC-COUNTER = WS-RESTART-REC-CTR         
                                                                        
           IF E-REVTAX-BILL-UNIQUE-TS EQUAL WS-RESTART-TIME-STAMP       
              SET RESTART-FCSCREVT       TO TRUE                        
           ELSE                                                         
              DISPLAY '********** PCSCA204 ABORT **************'        
              DISPLAY '*       0340-PREPARE-RESTART           *'        
              DISPLAY '* TMSTMP FROM RESTART TABLE DOES NOT   *'        
              DISPLAY '* MATCH WITH FCSCREVT FILE             *'        
              DISPLAY '* RESTART TMSTMP  : ' WS-RESTART-TIME-STAMP      
              DISPLAY '* FCSCREVT TMSTMP : ' E-REVTAX-BILL-UNIQUE-TS    
              DISPLAY '*      PROCESSING TERMINATED           *'        
              DISPLAY '********** PCSCA204 ABORT **************'        
              PERFORM 9900-ABEND               THRU  9900-EXIT          
           END-IF.                                                      
      *                                                                         
       0340-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0400-PREPARE-PRECOMMIT.                                        *        
      * MOVE ALL THE REQUIRED RESTART RECORD VALUES PRIOR TO UPDATE    *        
      ******************************************************************        
       0400-PREPARE-PRECOMMIT.                                          
      *                                                                         
            MOVE 1                       TO WS-RESTART-PROCESS-TYPE     
            MOVE WS-C                    TO WS-RESTART-JOB-STATUS       
            MOVE WS-INPUT-DATE           TO WS-RESTART-COMMON-DATE      
            MOVE WS-CHKP-SEQ-NO          TO WS-RESTART-CHKP-SEQ-NO      
            MOVE WS-FILE-NAME            TO WS-RESTART-FILE-NAME        
            MOVE WS-TIME-STAMP           TO WS-RESTART-TIME-STAMP       
            MOVE WS-RECORD-CTR           TO WS-RESTART-REC-CTR.         
      *                                                                         
       0400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *VALIDATES RESTART REQUEST.                                      *        
      ******************************************************************        
       COPY CPD00030.                                                           
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      * PROCESS INPUT                                                  *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
                                                                        
A03970     MOVE PARM-UPD-FLAG            TO WS-IS-THIS-JOB-PARM-UPD.    
                                                                        
           MOVE WS-CHKP-UPD-LIMIT        TO WS-READY-TO-COMMIT-COUNT.   
                                                                        
           MOVE 1                        TO REVD-INDX                   
                                            REVC-INDX                   
                                            REVB-INDX                   
                                            REVT-INDX.                  
                                                                        
           MOVE 0                        TO WS-CHKP-SEQ-NO              
                                            WS-RESTART-COMMIT-COUNTER.  
                                                                        
           MOVE WS-READY-TO-INSERT-COUNT TO WS-INSERT-COUNT.            
                                                                        
      *CHECK IF THIS IS NOT THE RESTART OR RESTART FROM SPECIFIC FILE.          
                                                                        
           DISPLAY ' PROCESSING REV_BILLING_DET FILE '                  
           MOVE ZEROES                           TO WS-DISP-FILE-COUNTER
           IF WS-THIS-IS-NOT-A-RESTART OR RESTART-FCSCREVD              
              PERFORM 7100-READ-FCSCREVD         THRU 7100-EXIT         
              PERFORM 1010-LOAD-FCSCREVD         THRU 1010-EXIT         
                UNTIL END-OF-FCSCREVD                                   
           END-IF                                                       
                                                                        
           DISPLAY ' PROCESSING REV_BILL_COMP_ADJ FILE '                
           MOVE ZEROES                           TO WS-DISP-FILE-COUNTER
           IF WS-THIS-IS-NOT-A-RESTART OR RESTART-FCSCREVC              
              PERFORM 7200-READ-FCSCREVC         THRU 7200-EXIT         
              PERFORM 1020-LOAD-FCSCREVC         THRU 1020-EXIT         
                UNTIL END-OF-FCSCREVC                                   
           END-IF                                                       
                                                                        
           DISPLAY ' PROCESSING REV_BILL_BLOCK FILE '                   
           MOVE ZEROES                           TO WS-DISP-FILE-COUNTER
           IF WS-THIS-IS-NOT-A-RESTART OR RESTART-FCSCREVB              
              PERFORM 7300-READ-FCSCREVB         THRU 7300-EXIT         
              PERFORM 1030-LOAD-FCSCREVB         THRU 1030-EXIT         
                UNTIL END-OF-FCSCREVB                                   
           END-IF                                                       
                                                                        
           DISPLAY ' PROCESSING REV_BILL_TAX FILE '                     
           MOVE ZEROES                           TO WS-DISP-FILE-COUNTER
           IF WS-THIS-IS-NOT-A-RESTART OR RESTART-FCSCREVT              
              PERFORM 7400-READ-FCSCREVT         THRU 7400-EXIT         
              PERFORM 1040-LOAD-FCSCREVT         THRU 1040-EXIT         
                UNTIL END-OF-FCSCREVT                                   
           END-IF                                                       
                                                                        
           PERFORM 0400-PREPARE-PRECOMMIT        THRU 0400-EXIT         
           MOVE SPACES                   TO WS-RESTART-JOB-COMPLETE     
                                                                        
           IF WS-THIS-IS-A-RESTART                                      
              MOVE WS-B                  TO WS-RESTART-JOB-STATUS       
           ELSE                                                         
              MOVE WS-A                  TO WS-RESTART-JOB-STATUS       
           END-IF.                                                      
                                                                        
           PERFORM 8888-COMMIT                   THRU 8888-EXIT         
                                                                        
           IF WS-RESTART-REQ EQUAL WS-Y                                 
              PERFORM 8893-RESET-RESTART-REQ-PARM                       
                                                 THRU 8893-EXIT         
              PERFORM 8840-DELETE-RESTART-ROW    THRU 8840-EXIT         
           END-IF.                                                      
                                                                        
      * UPDATE THE BILL UNIQUE TIMESTAMP IN JOB PARM TABLE                      
                                                                        
P00257     IF JOB-PARM-UPD                                              
P00257        MOVE WS-BILL-UNIQUE-TS-DATA   TO WS-JOB-PARM-DATA         
P00257        MOVE WS-PGRMNAME              TO G6-PROGRAM-NAME          
P00257        MOVE WS-PARM                  TO G6-CMND-CODE             
P00257        MOVE '01'                     TO G6-COMPANY-NO            
P00257        MOVE 5                        TO G6-SEQ-NO                
P00257        PERFORM 8600-UPDATE-JOB-PARM       THRU 8600-EXIT         
PRJ257        MOVE 6                        TO G6-SEQ-NO                
PRJ257        MOVE WS-INPUT-DATE            TO BN-DATE-EXTRACT          
PRJ257        PERFORM 8610-UPDATE-JOB-PARM-BN    THRU 8610-EXIT         
P00257     END-IF                                                       
                                                                        
           IF WS-THIS-IS-A-RESTART                                      
              DISPLAY 'PCSCA204 RERUN COMPLETED'                        
           ELSE                                                         
              DISPLAY 'PCSCA204 COMPLETED SUCCESSFULLY'                 
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1010-LOAD-FCSCREVD                                             *        
      * LOAD WORKING STORAGE ARRAY FROM REVENUE DETAIL FILE            *        
      ******************************************************************        
       1010-LOAD-FCSCREVD.                                              
                                                                        
           MOVE E-REVDET-BILL-UNIQUE-TS      TO                         
                                        WS-RV-BILL-UNIQUE-TS(REVD-INDX) 
           MOVE E-REVDET-REV-COMPANY-NO      TO                         
                                        WS-RV-REV-COMPANY-NO(REVD-INDX) 
           MOVE E-REVDET-COMPANY-NO          TO                         
                                        WS-RV-COMPANY-NO(REVD-INDX)     
           MOVE E-REVDET-REVENUE-MONTH       TO                         
                                        WS-RV-REVENUE-MONTH(REVD-INDX)  
           MOVE E-REVDET-CODE-SERVICE-TYPE   TO                         
                                     WS-RV-CODE-SERVICE-TYPE(REVD-INDX) 
           MOVE E-REVDET-ACCOUNT-NO          TO                         
                                        WS-RV-ACCOUNT-NO(REVD-INDX)     
           MOVE E-REVDET-BILL-NO             TO WS-RV-BILL-NO(REVD-INDX)
           MOVE E-REVDET-CODE-UTIL-TYPE      TO                         
                                        WS-RV-CODE-UTIL-TYPE(REVD-INDX) 
           MOVE E-REVDET-IC-NO               TO WS-RV-IC-NO(REVD-INDX)  
           MOVE E-REVDET-BILL-ITEM-TIMESTMP  TO                         
                                   WS-RV-BILL-ITEM-TIMESTMP(REVD-INDX)  
           MOVE E-REVDET-CUST-CT             TO WS-RV-CUST-CT(REVD-INDX)
           MOVE E-REVDET-CUST-CT-EXCL-LIGHTS TO                         
                                    WS-RV-CUST-CT-EXCL-LIGHT(REVD-INDX) 
           MOVE E-REVDET-USAGE-END-DATE      TO                         
                                    WS-RV-USAGE-END-DATE(REVD-INDX)     
                                                                        
           IF E-REVDET-USAGE-END-DATE <= SPACES                         
              MOVE -1 TO WS-RV-USAGE-END-DATE-NULL-IND(REVD-INDX)       
           ELSE                                                         
              MOVE 0  TO WS-RV-USAGE-END-DATE-NULL-IND(REVD-INDX)       
           END-IF                                                       
                                                                        
           MOVE E-REVDET-NO-OF-CONS-DAYS     TO                         
                                    WS-RV-NO-OF-CONS-DAYS(REVD-INDX)    
           MOVE E-REVDET-PRORATED-DAYS-CD    TO                         
                                    WS-RV-PRORATED-DAYS-CD(REVD-INDX)   
           MOVE E-REVDET-BTU-FACTOR          TO                         
                                    WS-RV-BTU-FACTOR(REVD-INDX)         
           MOVE E-REVDET-GAS-BASE-USE        TO                         
                                    WS-RV-GAS-BASE-USE(REVD-INDX)       
           MOVE E-REVDET-DESIGN-DAY-CAP      TO                         
                                    WS-RV-DESIGN-DAY-CAP(REVD-INDX)     
           MOVE E-REVDET-DATE-BILLED         TO                         
                                    WS-RV-DATE-BILLED(REVD-INDX)        
                                                                        
           IF E-REVDET-DATE-BILLED <= SPACES                            
              MOVE -1 TO WS-RV-DATE-BILLED-NULL-IND(REVD-INDX)          
           ELSE                                                         
              MOVE 0  TO WS-RV-DATE-BILLED-NULL-IND(REVD-INDX)          
           END-IF                                                       
                                                                        
           MOVE E-REVDET-DATE-ORIG-BILL      TO                         
                                    WS-RV-DATE-ORIG-BILL(REVD-INDX)     
                                                                        
           IF E-REVDET-DATE-ORIG-BILL <= SPACES                         
              MOVE -1 TO WS-RV-DATE-ORIG-BILL-NULL-IND(REVD-INDX)       
           ELSE                                                         
              MOVE 0  TO WS-RV-DATE-ORIG-BILL-NULL-IND(REVD-INDX)       
           END-IF                                                       
                                                                        
           MOVE E-REVDET-REV-MTH-ORIG-BILL   TO                         
                                    WS-RV-REV-MTH-ORIG-BILL(REVD-INDX)  
           MOVE E-REVDET-ACCT-BILL-CYCLE     TO                         
                                    WS-RV-ACCT-BILL-CYCLE(REVD-INDX)    
           MOVE E-REVDET-BILL-CALC-CYCLE     TO                         
                                    WS-RV-BILL-CALC-CYCLE(REVD-INDX)    
           MOVE E-REVDET-CODE-REV-ACCT-TYPE  TO                         
                                     WS-RV-CODE-REV-ACCT-TYPE(REVD-INDX)
           MOVE E-REVDET-CODE-REVENUE-CLASS  TO                         
                                    WS-RV-CODE-REVENUE-CLASS(REVD-INDX) 
           MOVE E-REVDET-RATE-PLAN-NO        TO                         
                                    WS-RV-RATE-PLAN-NO(REVD-INDX)       
           MOVE E-REVDET-RATE-DEPT-CD        TO                         
                                    WS-RV-RATE-DEPT-CD(REVD-INDX)       
           MOVE E-REVDET-PRTY-SVC-CAT-CD     TO                         
                                    WS-RV-PRTY-SVC-CAT-CD(REVD-INDX)    
           MOVE E-REVDET-CODE-SIC-NO         TO                         
                                    WS-RV-CODE-SIC-NO(REVD-INDX)        
           MOVE E-REVDET-NAICS-CD            TO                         
                                    WS-RV-NAICS-CD(REVD-INDX)           
           MOVE E-REVDET-TIER-ACCT-TYPE-CD   TO                         
                                    WS-RV-TIER-ACCT-TYPE-CD(REVD-INDX)  
           MOVE E-REVDET-OPTION-CD           TO                         
                                    WS-RV-OPTION-CD(REVD-INDX)          
           MOVE E-REVDET-RATE-CALC-TYPE-CD   TO                         
                                    WS-RV-RATE-CALC-TYPE-CD(REVD-INDX)  
           MOVE E-REVDET-LOCAL-OFFICE        TO                         
                                    WS-RV-LOCAL-OFFICE(REVD-INDX)       
           MOVE E-REVDET-REV-DISTRICT-CD     TO                         
                                    WS-RV-REV-DISTRICT-CD(REVD-INDX)    
           MOVE E-REVDET-MNICPLTY-COUNTY-CD  TO                         
                                    WS-RV-MNICPLTY-COUNTY-CD(REVD-INDX) 
           MOVE E-REVDET-PREMISE-NO          TO                         
                                    WS-RV-PREMISE-NO(REVD-INDX)         
           MOVE E-REVDET-CALC-SOURCE-CD      TO                         
                                    WS-RV-CALC-SOURCE-CD(REVD-INDX)     
A04581     MOVE E-REVDET-ELEC-WNA-GROUP-NO   TO                         
A04581                              WS-RV-ELEC-WNA-GROUP-NO(REVD-INDX)  
                                                                        
           IF REVD-INDX = WS-READY-TO-INSERT-COUNT                      
              PERFORM 8200-INSERT-REV-BILL-DET     THRU 8200-EXIT       
              MOVE 0                  TO REVD-INDX                      
              INITIALIZE WS-FCSCREVD-ARRAY                              
              ADD 1                   TO WS-RESTART-COMMIT-COUNTER      
                                                                        
      * WRITE THE RESTART DATA                                                  
      * CHECKS THE NUMBER OF INSERTS WITH THE COMMIT LMT GIVEN IN JPARM         
                                                                        
              IF WS-RESTART-COMMIT-COUNTER = WS-READY-TO-COMMIT-COUNT   
                 MOVE 0               TO WS-RESTART-COMMIT-COUNTER      
                 ADD  1               TO WS-CHKP-SEQ-NO                 
                 MOVE WS-FCSCREVD     TO WS-FILE-NAME                   
                 MOVE WS-FCSCREVD-REC-COUNTER                           
                                      TO WS-RECORD-CTR                  
                 MOVE E-REVDET-BILL-UNIQUE-TS                           
                                      TO WS-TIME-STAMP                  
                 PERFORM 0400-PREPARE-PRECOMMIT    THRU 0400-EXIT       
                 PERFORM 8888-COMMIT               THRU 8888-EXIT       
              END-IF                                                    
           END-IF                                                       
                                                                        
           PERFORM 7100-READ-FCSCREVD              THRU 7100-EXIT.      
                                                                        
           IF END-OF-FCSCREVD                                           
              IF REVD-INDX > 0                                          
                 MOVE REVD-INDX       TO WS-INSERT-COUNT                
                 PERFORM 8200-INSERT-REV-BILL-DET  THRU 8200-EXIT       
      * AFTER INSERT SET THE WS-INSERT-COUNT TO ACTUAL INSERT COUNT             
                 MOVE WS-READY-TO-INSERT-COUNT                          
                                      TO WS-INSERT-COUNT                
                 MOVE 0               TO WS-RESTART-COMMIT-COUNTER      
                 ADD  1               TO WS-CHKP-SEQ-NO                 
                 MOVE WS-FCSCREVD     TO WS-FILE-NAME                   
                 MOVE WS-FCSCREVD-REC-COUNTER                           
                                      TO WS-RECORD-CTR                  
                 MOVE E-REVDET-BILL-UNIQUE-TS                           
                                      TO WS-TIME-STAMP                  
                 PERFORM 0400-PREPARE-PRECOMMIT    THRU 0400-EXIT       
                 PERFORM 8888-COMMIT               THRU 8888-EXIT       
              END-IF                                                    
           ELSE                                                         
              ADD 1                   TO  REVD-INDX                     
           END-IF.                                                      
      *                                                                         
       1010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1020-LOAD-FCSCREVC                                             *        
      * LOAD WORKING STORAGE ARRAY FROM REVENUE ADJUSTMENT FILE        *        
      ******************************************************************        
       1020-LOAD-FCSCREVC.                                              
                                                                        
           MOVE E-REVADJ-BILL-UNIQUE-TS                                 
                               TO WS-RB-BILL-UNIQUE-TS(REVC-INDX)       
           MOVE E-REVADJ-BILL-COMP-SEQ-NO                               
                               TO WS-RB-BILL-COMP-SEQ-NO(REVC-INDX)     
           MOVE E-REVADJ-CMPNT-ID-CD                                    
                               TO WS-RB-CMPNT-ID-CD(REVC-INDX)          
           MOVE E-REVADJ-INSTR-USE-TYPE-CD                              
                               TO WS-RB-INSTR-USE-TYPE-CD(REVC-INDX)    
           MOVE E-REVADJ-CONSUMPT-TYPE-CD                               
                               TO WS-RB-CONSUMPT-TYPE-CD(REVC-INDX)     
           MOVE E-REVADJ-CODE-TIME-PERIOD                               
                               TO WS-RB-CODE-TIME-PERIOD(REVC-INDX)     
           MOVE E-REVADJ-CODE-SEASON                                    
                               TO WS-RB-CODE-SEASON(REVC-INDX)          
           MOVE E-REVADJ-RT-VERS-FROM-DT                                
                               TO WS-RB-RT-VERS-FROM-DT(REVC-INDX)      
                                                                        
           IF E-REVADJ-RT-VERS-FROM-DT <= SPACES                        
              MOVE -1          TO WS-RB-RT-VERS-DT-NULL-IND(REVC-INDX)  
           ELSE                                                         
              MOVE 0           TO WS-RB-RT-VERS-DT-NULL-IND(REVC-INDX)  
           END-IF                                                       
                                                                        
           MOVE E-REVADJ-RT-VERS-PRO-CD                                 
                               TO WS-RB-RT-VERS-PRO-CD(REVC-INDX)       
           MOVE E-REVADJ-FACTOR-ID                                      
                               TO WS-RB-FACTOR-ID(REVC-INDX)            
           MOVE E-REVADJ-FACTOR-BLOCK-NO                                
                               TO WS-RB-FACTOR-BLOCK-NO(REVC-INDX)      
           MOVE E-REVADJ-RT-FCT-FROM-DT                                 
                               TO WS-RB-RT-FCT-FROM-DT(REVC-INDX)       
                                                                        
           IF E-REVADJ-RT-FCT-FROM-DT <= SPACES                         
              MOVE -1          TO WS-RB-RT-FCTR-DT-NULL-IND(REVC-INDX)  
           ELSE                                                         
              MOVE 0           TO WS-RB-RT-FCTR-DT-NULL-IND(REVC-INDX)  
           END-IF                                                       
                                                                        
           MOVE E-REVADJ-RT-FCT-PRO-CD                                  
                               TO WS-RB-RT-FCT-PRO-CD(REVC-INDX)        
           MOVE E-REVADJ-READ-UNITS                                     
                               TO WS-RB-READ-UNITS(REVC-INDX)           
           MOVE E-REVADJ-BILL-USAGE-UNITS                               
                               TO WS-RB-BILL-USAGE-UNITS(REVC-INDX)     
           MOVE E-REVADJ-BILL-DEMAND-UNITS                              
                               TO WS-RB-BILL-DEMAND-UNITS(REVC-INDX)    
           MOVE E-REVADJ-CALC-UNITS                                     
                               TO WS-RB-CALC-UNITS(REVC-INDX)           
           MOVE E-REVADJ-FACTOR                                         
                               TO WS-RB-FACTOR(REVC-INDX)               
           MOVE E-REVADJ-BILLED-AMT                                     
                               TO WS-RB-BILLED-AMT(REVC-INDX)           
           MOVE E-REVADJ-CODE-STAT-TAX-XMT                              
                               TO WS-RB-CODE-STAT-TAX-XMT(REVC-INDX)    
           MOVE E-REVADJ-CODE-CITY-TAX-XMT                              
                               TO WS-RB-CODE-CITY-TAX-XMT(REVC-INDX)    
           MOVE E-REVADJ-CODE-OTHR-TAX-XMT                              
                               TO WS-RB-CODE-OTHR-TAX-XMT(REVC-INDX)    
           MOVE E-REVADJ-UTILITY-REV-CD                                 
                               TO WS-RB-UTILITY-REV-CD(REVC-INDX)       
           MOVE E-REVADJ-COMP-ADJ-CD                                    
                               TO WS-RB-COMP-ADJ-CD(REVC-INDX)          
           MOVE E-REVADJ-GL-ACCT-NO                                     
                               TO WS-RB-GL-ACCT-NO(REVC-INDX)           
           MOVE E-REVADJ-SPCL-GROUP-CD                                  
                               TO WS-RB-SPCL-GROUP-CD(REVC-INDX)        
P00257     MOVE E-REVADJ-ACCOUNT-NO                                     
                               TO WS-RB-ACCOUNT-NO(REVC-INDX)           
                                                                        
                                                                        
      * CHECK FOR THE INSERT LIMIT                                              
           IF REVC-INDX = WS-READY-TO-INSERT-COUNT                      
              PERFORM 8300-INSERT-REV-BILL-COM-ADJ THRU 8300-EXIT       
              MOVE 0           TO REVC-INDX                             
              INITIALIZE WS-FCSCREVC-ARRAY                              
              ADD 1            TO WS-RESTART-COMMIT-COUNTER             
                                                                        
      * WRITE THE RESTART DATA                                                  
      * CHECKS THE NUMBER OF INSERTS WITH THE COMMIT LMT GIVEN IN JPARM         
                                                                        
              IF WS-RESTART-COMMIT-COUNTER = WS-READY-TO-COMMIT-COUNT   
                 MOVE 0        TO WS-RESTART-COMMIT-COUNTER             
                 ADD  1        TO WS-CHKP-SEQ-NO                        
                 MOVE WS-FCSCREVC                                       
                               TO WS-FILE-NAME                          
                 MOVE WS-FCSCREVC-REC-COUNTER                           
                               TO WS-RECORD-CTR                         
                 MOVE E-REVADJ-BILL-UNIQUE-TS                           
                               TO WS-TIME-STAMP                         
                 PERFORM 0400-PREPARE-PRECOMMIT    THRU 0400-EXIT       
                 PERFORM 8888-COMMIT               THRU 8888-EXIT       
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7200-READ-FCSCREVC              THRU 7200-EXIT.      
                                                                        
           IF END-OF-FCSCREVC                                           
              IF REVC-INDX > 0                                          
                 MOVE REVC-INDX       TO WS-INSERT-COUNT                
                 PERFORM 8300-INSERT-REV-BILL-COM-ADJ                   
                                                   THRU 8300-EXIT       
      * AFTER INSERT SET THE WS-INSERT-COUNT TO ACTUAL INSERT COUNT             
                 MOVE WS-READY-TO-INSERT-COUNT                          
                                      TO WS-INSERT-COUNT                
                 MOVE 0               TO WS-RESTART-COMMIT-COUNTER      
                 ADD  1               TO WS-CHKP-SEQ-NO                 
                 MOVE WS-FCSCREVC     TO WS-FILE-NAME                   
                 MOVE WS-FCSCREVC-REC-COUNTER                           
                                      TO WS-RECORD-CTR                  
                 MOVE E-REVADJ-BILL-UNIQUE-TS                           
                                      TO WS-TIME-STAMP                  
                 PERFORM 0400-PREPARE-PRECOMMIT    THRU 0400-EXIT       
                 PERFORM 8888-COMMIT               THRU 8888-EXIT       
              END-IF                                                    
           ELSE                                                         
              ADD 1                   TO  REVC-INDX                     
           END-IF.                                                      
      *                                                                         
       1020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1030-LOAD-FCSCREVB                                             *        
      * LOAD WORKING STORAGE ARRAY FROM REVENUE BLOCK FILE             *        
      ******************************************************************        
       1030-LOAD-FCSCREVB.                                              
      *                                                                         
           MOVE E-REVBLK-BILL-UNIQUE-TS                                 
                                TO WS-R7-BILL-UNIQUE-TS(REVB-INDX)      
           MOVE E-REVBLK-BILL-COMP-SEQ-NO                               
                                TO WS-R7-BILL-COMP-SEQ-NO(REVB-INDX)    
           MOVE E-REVBLK-BLK-NO-RT-ITM-CD                               
                                TO WS-R7-BLK-NO-RT-ITM-CD(REVB-INDX)    
           MOVE E-REVBLK-BLK-USE-OR-SVCS                                
                                TO WS-R7-BLK-USE-OR-SVCS(REVB-INDX)     
           MOVE E-REVBLK-BLK-BILL-USE-UNITS                             
                                TO WS-R7-BLK-BILL-USE-UNITS(REVB-INDX)  
           MOVE E-REVBLK-BLK-BILL-DEM-UNITS                             
                                TO WS-R7-BLK-BILL-DEM-UNITS(REVB-INDX)  
           MOVE E-REVBLK-BLK-BILL-LT-POLES                              
                                TO WS-R7-BLK-BILL-LT-POLES(REVB-INDX)   
           MOVE E-REVBLK-CUST-PER-SERVICE                               
                                TO WS-R7-CUST-PER-SERVICE(REVB-INDX)    
           MOVE E-REVBLK-PRICE-TYPE-CD                                  
                                TO WS-R7-PRICE-TYPE-CD(REVB-INDX)       
           MOVE E-REVBLK-SCHED-PRICE-AM                                 
                                TO WS-R7-SCHED-PRICE-AM(REVB-INDX)      
           MOVE E-REVBLK-UNIT-PRICE-AM                                  
                                TO WS-R7-UNIT-PRICE-AM(REVB-INDX)       
           MOVE E-REVBLK-BLK-REV-AMT                                    
                                TO WS-R7-BLK-REV-AMT(REVB-INDX)         
           MOVE E-REVBLK-NET-UNIT-SEL-RSN                               
                                TO WS-R7-NET-UNIT-SEL-RSN(REVB-INDX)    
           MOVE E-REVBLK-KW-MDQ-DT                                      
                                TO WS-R7-KW-MDQ-DT(REVB-INDX)           
                                                                        
           IF E-REVBLK-KW-MDQ-DT <= SPACES                              
              MOVE -1           TO WS-R7-KW-MDQ-DT-NULL-IND(REVB-INDX)  
           ELSE                                                         
              MOVE 0            TO WS-R7-KW-MDQ-DT-NULL-IND(REVB-INDX)  
           END-IF                                                       
                                                                        
           MOVE E-REVBLK-KVA-DT TO WS-R7-KVA-DT(REVB-INDX)              
                                                                        
           IF E-REVBLK-KVA-DT <= SPACES                                 
              MOVE -1           TO WS-R7-KVA-DT-NULL-IND(REVB-INDX)     
           ELSE                                                         
              MOVE 0            TO WS-R7-KVA-DT-NULL-IND(REVB-INDX)     
           END-IF                                                       
                                                                        
           MOVE E-REVBLK-CONTRACT-DEMAND                                
                                TO WS-R7-CONTRACT-DEMAND(REVB-INDX)     
           MOVE E-REVBLK-READ-KW-MDQ-UNITS                              
                                TO WS-R7-READ-KW-MDQ-UNITS(REVB-INDX)   
           MOVE E-REVBLK-READ-KVA-UNITS                                 
                                TO WS-R7-READ-KVA-UNITS(REVB-INDX)      
           MOVE E-REVBLK-POWER-FACTOR                                   
                                TO WS-R7-POWER-FACTOR(REVB-INDX)        
           MOVE E-REVBLK-LOAD-FACTOR                                    
                                TO WS-R7-LOAD-FACTOR(REVB-INDX)         
           MOVE E-REVBLK-RT-VERS-PRO-PCT                                
                                TO WS-R7-RT-VERS-PRO-PCT(REVB-INDX)     
                                                                        
P00257     MOVE E-REVBLK-ACCOUNT-NO                                     
P00257                          TO WS-R7-ACCOUNT-NO(REVB-INDX)          
P00257     MOVE E-REVBLK-RATE-ITEM-CODE                                 
P00257                          TO WS-R7-RATE-ITEM-CODE(REVB-INDX)      
                                                                        
           IF REVB-INDX = WS-READY-TO-INSERT-COUNT                      
              PERFORM 8400-INSERT-REV-BILL-BLOCK    THRU 8400-EXIT      
              MOVE 0            TO REVB-INDX                            
              INITIALIZE WS-FCSCREVB-ARRAY                              
              ADD 1 TO WS-RESTART-COMMIT-COUNTER                        
                                                                        
      * WRITE THE RESTART DATA                                                  
      * CHECKS THE NUMBER OF INSERTS WITH THE COMMIT LMT GIVEN IN JPARM         
                                                                        
              IF WS-RESTART-COMMIT-COUNTER = WS-READY-TO-COMMIT-COUNT   
                 MOVE 0               TO WS-RESTART-COMMIT-COUNTER      
                 ADD  1               TO WS-CHKP-SEQ-NO                 
                 MOVE WS-FCSCREVB     TO WS-FILE-NAME                   
                 MOVE WS-FCSCREVB-REC-COUNTER                           
                                      TO WS-RECORD-CTR                  
                 MOVE E-REVBLK-BILL-UNIQUE-TS                           
                                      TO WS-TIME-STAMP                  
                 PERFORM 0400-PREPARE-PRECOMMIT     THRU 0400-EXIT      
                 PERFORM 8888-COMMIT                THRU 8888-EXIT      
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7300-READ-FCSCREVB               THRU 7300-EXIT.     
                                                                        
           IF END-OF-FCSCREVB                                           
              IF REVB-INDX > 0                                          
                 MOVE REVB-INDX       TO WS-INSERT-COUNT                
                 PERFORM 8400-INSERT-REV-BILL-BLOCK THRU 8400-EXIT      
      * AFTER INSERT SET THE WS-INSERT-COUNT TO ACTUAL INSERT COUNT             
                 MOVE WS-READY-TO-INSERT-COUNT                          
                                      TO WS-INSERT-COUNT                
                 MOVE 0               TO WS-RESTART-COMMIT-COUNTER      
                 ADD  1               TO WS-CHKP-SEQ-NO                 
                 MOVE WS-FCSCREVB     TO WS-FILE-NAME                   
                 MOVE WS-FCSCREVB-REC-COUNTER                           
                                      TO WS-RECORD-CTR                  
                 MOVE E-REVBLK-BILL-UNIQUE-TS                           
                                      TO WS-TIME-STAMP                  
                 PERFORM 0400-PREPARE-PRECOMMIT     THRU 0400-EXIT      
                 PERFORM 8888-COMMIT                THRU 8888-EXIT      
              END-IF                                                    
           ELSE                                                         
              ADD 1                   TO  REVB-INDX                     
           END-IF.                                                      
      *                                                                         
       1030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1040-LOAD-FCSCREVT                                             *        
      * LOAD WORKING STORAGE ARRAY FROM REVENUE TAX FILE               *        
      ******************************************************************        
       1040-LOAD-FCSCREVT.                                              
                                                                        
           MOVE E-REVTAX-BILL-UNIQUE-TS TO                              
                                       WS-R9-BILL-UNIQUE-TS(REVT-INDX)  
           MOVE E-REVTAX-TAX-TYPE       TO WS-R9-TAX-TYPE(REVT-INDX)    
           MOVE E-REVTAX-TAX-CNTRL-NO   TO WS-R9-TAX-CNTRL-NO(REVT-INDX)
           MOVE E-REVTAX-TAX-FROM-DT    TO WS-R9-TAX-FROM-DT(REVT-INDX) 
                                                                        
           MOVE E-REVTAX-FACTOR-ID      TO WS-R9-FACTOR-ID(REVT-INDX)   
           MOVE E-REVTAX-TAX-GL-ACCT-NO TO                              
                                       WS-R9-TAX-GL-ACCT-NO(REVT-INDX)  
           MOVE E-REVTAX-TAX-AMT        TO WS-R9-TAX-AMT(REVT-INDX)     
                                                                        
P00257     MOVE E-REVTAX-ACCOUNT-NO     TO WS-R9-ACCOUNT-NO(REVT-INDX)  
                                                                        
           IF REVT-INDX = WS-READY-TO-INSERT-COUNT                      
              PERFORM 8500-INSERT-REV-BILL-TAX     THRU 8500-EXIT       
                                                                        
              MOVE 0                    TO REVT-INDX                    
              INITIALIZE WS-FCSCREVT-ARRAY                              
              ADD 1 TO WS-RESTART-COMMIT-COUNTER                        
                                                                        
      * WRITE THE RESTART DATA                                                  
      * CHECKS THE NUMBER OF INSERTS WITH THE COMMIT LMT GIVEN IN JPARM         
                                                                        
              IF WS-RESTART-COMMIT-COUNTER = WS-READY-TO-COMMIT-COUNT   
                 MOVE 0                 TO WS-RESTART-COMMIT-COUNTER    
                 ADD  1                 TO WS-CHKP-SEQ-NO               
                 MOVE WS-FCSCREVT       TO WS-FILE-NAME                 
                 MOVE WS-FCSCREVT-REC-COUNTER                           
                                        TO WS-RECORD-CTR                
                                                                        
                 MOVE E-REVTAX-BILL-UNIQUE-TS                           
                                        TO WS-TIME-STAMP                
                 PERFORM 0400-PREPARE-PRECOMMIT    THRU 0400-EXIT       
                 PERFORM 8888-COMMIT               THRU 8888-EXIT       
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7400-READ-FCSCREVT              THRU 7400-EXIT.      
                                                                        
           IF END-OF-FCSCREVT                                           
              IF REVT-INDX > 0                                          
                 MOVE REVT-INDX       TO WS-INSERT-COUNT                
                 PERFORM 8500-INSERT-REV-BILL-TAX  THRU 8500-EXIT       
      * AFTER INSERT SET THE WS-INSERT-COUNT TO ACTUAL INSERT COUNT             
                 MOVE WS-READY-TO-INSERT-COUNT                          
                                      TO WS-INSERT-COUNT                
                 MOVE 0               TO WS-RESTART-COMMIT-COUNTER      
                 ADD  1               TO WS-CHKP-SEQ-NO                 
                 MOVE WS-FCSCREVT     TO WS-FILE-NAME                   
                 MOVE WS-FCSCREVT-REC-COUNTER                           
                                      TO WS-RECORD-CTR                  
                 MOVE E-REVTAX-BILL-UNIQUE-TS                           
                                      TO WS-TIME-STAMP                  
                 PERFORM 0400-PREPARE-PRECOMMIT    THRU 0400-EXIT       
                 PERFORM 8888-COMMIT               THRU 8888-EXIT       
              END-IF                                                    
           ELSE                                                         
              ADD 1                   TO  REVT-INDX                     
           END-IF.                                                      
      *                                                                         
       1040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 6235-GET-FJC01-RESTART-REQ                                    *        
      ******************************************************************        
      *                                                                         
       COPY CPD00035.                                                           
      *                                                                         
      ******************************************************************        
      * 6251-GET-FJC01-DATE                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00037                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6253-GET-FJC01-CHKP-LIMIT.                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00034                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *7050-SELECT-RESTART.                                            *        
      * THIS PARAGRAPH SELECTS A RESTART RECORD FROM CSS_RESTART       *        
      ******************************************************************        
       7050-SELECT-RESTART.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT RESTART_DATA                                       
                INTO :RF-RESTART-DATA                                   
                FROM CSS_RESTART                                        
               WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                    
                 AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                    
                 AND PARTITION_NO = :RF-PARTITION-NO                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESTART_DATA                                               
MFA-TR*         INTO :RF-RESTART-DATA                                           
MFA-TR*         FROM CSS_RESTART                                                
MFA-TR*        WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                            
MFA-TR*          AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                            
MFA-TR*          AND PARTITION_NO = :RF-PARTITION-NO                            
MFA-TR*      QUERYNO 7050                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '***  ERROR IN 7050-SELECT-RESTART  ***'          
              DISPLAY '***  RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '***      PROCESSING TERMINATED     ***'          
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-READ-FCSCREVD                                             *        
      * READ AND PROCESS DATA IN THE FCSCREVD FILE.                    *        
      ******************************************************************        
       7100-READ-FCSCREVD.                                              
      *                                                                         
           READ FCSCREVD-FILE                                           
               AT END                                                   
               GO TO 7100-EXIT.                                         
           IF FCSCREVD-SUCCESSFUL                                       
              ADD 1 TO WS-FCSCREVD-REC-COUNTER                          
              MOVE WS-FCSCREVD-REC-COUNTER      TO WS-DISP-FILE-COUNTER 
              IF WS-FCSCREVD-REC-COUNTER = 1                            
P00257           MOVE E-REVDET-BILL-UNIQUE-TS   TO WS-BILL-UNIQUE-TS    
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSCA204 ABORT **************'        
              DISPLAY '*     READ ERROR : FCSCREVD FILE       *'        
              DISPLAY '* CURRENT PARA   : 7100                *'        
              DISPLAY '* FILE-STATUS    : ' WS-FCSCREVD-STATUS          
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA204 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-READ-FCSCREVC                                             *        
      * READ AND PROCESS DATA IN THE FCSCREVT FILE.                    *        
      ******************************************************************        
       7200-READ-FCSCREVC.                                              
                                                                        
           READ FCSCREVC-FILE                                           
               AT END                                                   
               GO TO 7200-EXIT.                                         
           IF FCSCREVC-SUCCESSFUL                                       
              ADD  1 TO WS-FCSCREVC-REC-COUNTER                         
              MOVE WS-FCSCREVC-REC-COUNTER      TO WS-DISP-FILE-COUNTER 
           ELSE                                                         
              DISPLAY '********** PCSCA204 ABORT **************'        
              DISPLAY '*     READ ERROR : FCSCREVC FILE       *'        
              DISPLAY '* CURRENT PARA   : 7200                *'        
              DISPLAY '* FILE-STATUS    : ' WS-FCSCREVC-STATUS          
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA204 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-READ-FCSCREVB                                             *        
      * READ AND PROCESS DATA IN THE FCSCREVB FILE.                    *        
      ******************************************************************        
       7300-READ-FCSCREVB.                                              
                                                                        
           READ FCSCREVB-FILE                                           
               AT END                                                   
               GO TO 7300-EXIT.                                         
           IF FCSCREVB-SUCCESSFUL                                       
              ADD 1 TO WS-FCSCREVB-REC-COUNTER                          
              MOVE WS-FCSCREVB-REC-COUNTER      TO WS-DISP-FILE-COUNTER 
           ELSE                                                         
              DISPLAY '********** PCSCA204 ABORT **************'        
              DISPLAY '*     READ ERROR : FCSCREVB FILE       *'        
              DISPLAY '* CURRENT PARA   : 7300                *'        
              DISPLAY '* FILE-STATUS    : ' WS-FCSCREVB-STATUS          
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA204 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7400-READ-FCSCREVT                                             *        
      * READ AND PROCESS DATA IN THE FCSCREVT FILE.                    *        
      ******************************************************************        
       7400-READ-FCSCREVT.                                              
                                                                        
           READ FCSCREVT-FILE                                           
               AT END                                                   
               GO TO 7400-EXIT.                                         
           IF FCSCREVT-SUCCESSFUL                                       
              ADD 1 TO WS-FCSCREVT-REC-COUNTER                          
              MOVE WS-FCSCREVT-REC-COUNTER      TO WS-DISP-FILE-COUNTER 
           ELSE                                                         
              DISPLAY '********** PCSCA204 ABORT **************'        
              DISPLAY '*     READ ERROR : FCSCREVT FILE       *'        
              DISPLAY '* CURRENT PARA   : 7400                *'        
              DISPLAY '* FILE-STATUS    : ' WS-FCSCREVT-STATUS          
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA204 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7500-GET-DB2-DIAGNOSTICS.                                      *        
      * GET DB2 DIAGNOSTIC INFORMATION IN CASE OF AN ERROR.            *        
      ******************************************************************        
       7500-GET-DB2-DIAGNOSTICS.                                        
                                                                        
           MOVE 0                       TO WS-ROW-COUNT                 
                                           WS-ROW-ERRORS                
                                           WS-DB2-SQLCODE               
                                           WS-DB2-ROW-NUM               
                                           WS-DISP-INSERT-COUNT         
                                           WS-DISP-ROW-COUNT            
                                           WS-DISP-DB2-SQLCODE          
                                           WS-DISP-ROW-NUM.             
           MOVE SQLERRD(3)              TO WS-DISP-ROW-COUNT.           
           EXEC SQL GET DIAGNOSTICS                                     
MSQ012           :MFA-GD-ROW-COUNT  = ROW_COUNT,                            
MSQ012           :MFA-GD-NUMBER = NUMBER                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*    EXEC SQL GET DIAGNOSTICS                                             
MFA-TR*          :WS-ROW-COUNT  = ROW_COUNT,                                    
MFA-TR*          :WS-ROW-ERRORS = NUMBER                                        
MFA-TR*    END-EXEC.                                                            
MSQ012     MOVE MFA-GD-ROW-COUNT TO WS-ROW-COUNT
MSQ012     MOVE MFA-GD-NUMBER TO WS-ROW-ERRORS
           MOVE WS-INSERT-COUNT         TO WS-DISP-INSERT-COUNT.        
           DISPLAY '********DB2 DIAGNOSTICS INFORMATION*****'           
           DISPLAY '* TOTAL ROWS PLANNED TO INSERT : '                  
                                             WS-DISP-INSERT-COUNT       
           DISPLAY '* TOTAL ROWS INSERTED : ' WS-DISP-ROW-COUNT         
           DISPLAY '* LAST PROCESSED ROW IN FILE : '                    
                                             WS-DISP-FILE-COUNTER       
           PERFORM VARYING WS-ROW-NUM FROM 1 BY 1 UNTIL                 
           WS-ROW-NUM > WS-ROW-ERRORS                                   
MSQ012        MOVE WS-ROW-NUM TO MFA-GD-CONDITION
MSQ012        EXEC SQL GET DIAGNOSTICS CONDITION :MFA-GD-CONDITION            
MSQ012              :MFA-GD-SQLCODE  = DB2_RETURNED_SQLCODE,            
MSQ012              :MFA-GD-ROW-NUMBER  = DB2_ROW_NUMBER                   
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*       EXEC SQL GET DIAGNOSTICS CONDITION :WS-ROW-NUM                    
MFA-TR*             :WS-DB2-SQLCODE  = DB2_RETURNED_SQLCODE,                    
MFA-TR*             :WS-DB2-ROW-NUM  = DB2_ROW_NUMBER                           
MFA-TR*       END-EXEC                                                          
MSQ012        MOVE MFA-GD-SQLCODE TO WS-DB2-SQLCODE
MSQ012        MOVE MFA-GD-ROW-NUMBER TO WS-DB2-ROW-NUM
              MOVE WS-DB2-SQLCODE       TO WS-DISP-DB2-SQLCODE          
              MOVE WS-DB2-ROW-NUM       TO WS-DISP-ROW-NUM              
              DISPLAY '* SQLCODE       : ' WS-DISP-DB2-SQLCODE          
              DISPLAY '* ROW NUMBER    : ' WS-DISP-ROW-NUM              
           END-PERFORM.                                                 
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CPD00038                                                       *        
      * 7600-START-FCSJC01                                             *        
      * 7610-READ-FCSJC01                                              *        
      * 7611-CLOSE                                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 8200-INSERT-REV-BILL-DET                                       *        
      * INSERTS DATA IN REV_BILLING_DET                                *        
      ******************************************************************        
       8200-INSERT-REV-BILL-DET.                                        

MSQ009     EXEC SQL
MSQ009       SAVE TRANSACTION MSQ009-TRNS
MSQ009     END-EXEC
                                                                        
           EXEC SQL                                                     
              FOR :WS-INSERT-COUNT
              INSERT INTO REV_BILLING_DET
              (BILL_UNIQUE_TS,                                       
                  REV_COMPANY_NO,                                       
                  COMPANY_NO,                                           
                  REVENUE_MONTH,                                        
                  CODE_SERVICE_TYPE,                                    
                  ACCOUNT_NO,                                           
                  BILL_NO,                                              
                  CODE_UTIL_TYPE,                                       
                  IC_NO,                                                
                  BILL_ITEM_TIMESTMP,                                   
                  CUST_CT,                                              
                  CUST_CT_EXCL_LIGHT,                                   
                  USAGE_END_DATE,                                       
                  NO_OF_CONS_DAYS,                                      
                  PRORATED_DAYS_CD,                                     
                  BTU_FACTOR,                                           
                  GAS_BASE_USE,                                         
                  DESIGN_DAY_CAP,                                       
                  DATE_BILLED,                                          
                  DATE_ORIG_BILL,                                       
                  REV_MTH_ORIG_BILL,                                    
                  ACCT_BILL_CYCLE,                                      
                  BILL_CALC_CYCLE,                                      
                  CODE_REV_ACCT_TYPE,                                   
                  CODE_REVENUE_CLASS,                                   
                  RATE_PLAN_NO,                                         
                  RATE_DEPT_CD,                                         
                  PRTY_SVC_CAT_CD,                                      
                  CODE_SIC_NO,                                          
                  NAICS_CD,                                             
                  TIER_ACCT_TYPE_CD,                                    
                  OPTION_CD,                                            
                  RATE_CALC_TYPE_CD,                                    
                  LOCAL_OFFICE,                                         
                  REV_DISTRICT_CD,                                      
                  MNICPLTY_COUNTY_CD,                                   
                  PREMISE_NO,                                           
                  CALC_SOURCE_CD,                                       
A04581            ELEC_WNA_GROUP_NO)
              VALUES                                                   
                 (CIS.CHAR2TIMESTAMP(:WS-RV-BILL-UNIQUE-TS),                    
                  :WS-RV-REV-COMPANY-NO,                                
                  :WS-RV-COMPANY-NO,                                    
                  :WS-RV-REVENUE-MONTH,                                 
                  :WS-RV-CODE-SERVICE-TYPE,                             
                  :WS-RV-ACCOUNT-NO,                                    
                  :WS-RV-BILL-NO,                                       
                  :WS-RV-CODE-UTIL-TYPE,                                
                  :WS-RV-IC-NO,                                         
                  CIS.CHAR2TIMESTAMP(:WS-RV-BILL-ITEM-TIMESTMP),                
                  :WS-RV-CUST-CT,                                       
                  :WS-RV-CUST-CT-EXCL-LIGHT,                            
                  IIF(TRY_CONVERT(DATE, :WS-RV-USAGE-END-DATE 
                                        :WS-RV-USAGE-END-DATE-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :WS-RV-USAGE-END-DATE 
                                         :WS-RV-USAGE-END-DATE-NULL-IND
              ) <> 0) OR (LEN(:WS-RV-USAGE-END-DATE 
                                         :WS-RV-USAGE-END-DATE-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:WS-RV-USAGE-END-DATE 
                                         :WS-RV-USAGE-END-DATE-NULL-IND
              ), CONVERT(DATE, :WS-RV-USAGE-END-DATE 
                                         :WS-RV-USAGE-END-DATE-NULL-IND
              ) ), 
                  :WS-RV-NO-OF-CONS-DAYS,                               
                  :WS-RV-PRORATED-DAYS-CD,                              
                  :WS-RV-BTU-FACTOR,                                    
                  :WS-RV-GAS-BASE-USE,                                  
                  :WS-RV-DESIGN-DAY-CAP,                                
                  IIF(TRY_CONVERT(DATE, :WS-RV-DATE-BILLED 
                                        :WS-RV-DATE-BILLED-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :WS-RV-DATE-BILLED 
                                            :WS-RV-DATE-BILLED-NULL-IND
              ) <> 0) OR (LEN(:WS-RV-DATE-BILLED 
                                            :WS-RV-DATE-BILLED-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:WS-RV-DATE-BILLED 
                                            :WS-RV-DATE-BILLED-NULL-IND
              ), CONVERT(DATE, :WS-RV-DATE-BILLED 
                                            :WS-RV-DATE-BILLED-NULL-IND
              ) ),       
                  IIF(TRY_CONVERT(DATE, :WS-RV-DATE-ORIG-BILL 
                                        :WS-RV-DATE-ORIG-BILL-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :WS-RV-DATE-ORIG-BILL 
                                         :WS-RV-DATE-ORIG-BILL-NULL-IND
              ) <> 0) OR (LEN(:WS-RV-DATE-ORIG-BILL 
                                         :WS-RV-DATE-ORIG-BILL-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:WS-RV-DATE-ORIG-BILL 
                                         :WS-RV-DATE-ORIG-BILL-NULL-IND
              ), CONVERT(DATE, :WS-RV-DATE-ORIG-BILL 
                                         :WS-RV-DATE-ORIG-BILL-NULL-IND
              ) ), 
                  :WS-RV-REV-MTH-ORIG-BILL,                             
                  :WS-RV-ACCT-BILL-CYCLE,                               
                  :WS-RV-BILL-CALC-CYCLE,                               
                  :WS-RV-CODE-REV-ACCT-TYPE,                            
                  :WS-RV-CODE-REVENUE-CLASS,                            
                  :WS-RV-RATE-PLAN-NO,                                  
                  :WS-RV-RATE-DEPT-CD,                                  
                  :WS-RV-PRTY-SVC-CAT-CD,                               
                  :WS-RV-CODE-SIC-NO,                                   
                  :WS-RV-NAICS-CD,                                      
                  :WS-RV-TIER-ACCT-TYPE-CD,                             
                  :WS-RV-OPTION-CD,                                     
                  :WS-RV-RATE-CALC-TYPE-CD,                             
                  :WS-RV-LOCAL-OFFICE,                                  
                  :WS-RV-REV-DISTRICT-CD,                               
                  :WS-RV-MNICPLTY-COUNTY-CD,                            
                  :WS-RV-PREMISE-NO,                                    
                  :WS-RV-CALC-SOURCE-CD,                                
A04581            :WS-RV-ELEC-WNA-GROUP-NO)
              
                                                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ009
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO REV_BILLING_DET                                       
MFA-TR*          (BILL_UNIQUE_TS,                                               
MFA-TR*           REV_COMPANY_NO,                                               
MFA-TR*           COMPANY_NO,                                                   
MFA-TR*           REVENUE_MONTH,                                                
MFA-TR*           CODE_SERVICE_TYPE,                                            
MFA-TR*           ACCOUNT_NO,                                                   
MFA-TR*           BILL_NO,                                                      
MFA-TR*           CODE_UTIL_TYPE,                                               
MFA-TR*           IC_NO,                                                        
MFA-TR*           BILL_ITEM_TIMESTMP,                                           
MFA-TR*           CUST_CT,                                                      
MFA-TR*           CUST_CT_EXCL_LIGHT,                                           
MFA-TR*           USAGE_END_DATE,                                               
MFA-TR*           NO_OF_CONS_DAYS,                                              
MFA-TR*           PRORATED_DAYS_CD,                                             
MFA-TR*           BTU_FACTOR,                                                   
MFA-TR*           GAS_BASE_USE,                                                 
MFA-TR*           DESIGN_DAY_CAP,                                               
MFA-TR*           DATE_BILLED,                                                  
MFA-TR*           DATE_ORIG_BILL,                                               
MFA-TR*           REV_MTH_ORIG_BILL,                                            
MFA-TR*           ACCT_BILL_CYCLE,                                              
MFA-TR*           BILL_CALC_CYCLE,                                              
MFA-TR*           CODE_REV_ACCT_TYPE,                                           
MFA-TR*           CODE_REVENUE_CLASS,                                           
MFA-TR*           RATE_PLAN_NO,                                                 
MFA-TR*           RATE_DEPT_CD,                                                 
MFA-TR*           PRTY_SVC_CAT_CD,                                              
MFA-TR*           CODE_SIC_NO,                                                  
MFA-TR*           NAICS_CD,                                                     
MFA-TR*           TIER_ACCT_TYPE_CD,                                            
MFA-TR*           OPTION_CD,                                                    
MFA-TR*           RATE_CALC_TYPE_CD,                                            
MFA-TR*           LOCAL_OFFICE,                                                 
MFA-TR*           REV_DISTRICT_CD,                                              
MFA-TR*           MNICPLTY_COUNTY_CD,                                           
MFA-TR*           PREMISE_NO,                                                   
MFA-TR*           CALC_SOURCE_CD,                                               
MFA-TR*           ELEC_WNA_GROUP_NO)                                            
MFA-TR*        VALUES                                                           
MFA-TR*          (:WS-RV-BILL-UNIQUE-TS,                                        
MFA-TR*           :WS-RV-REV-COMPANY-NO,                                        
MFA-TR*           :WS-RV-COMPANY-NO,                                            
MFA-TR*           :WS-RV-REVENUE-MONTH,                                         
MFA-TR*           :WS-RV-CODE-SERVICE-TYPE,                                     
MFA-TR*           :WS-RV-ACCOUNT-NO,                                            
MFA-TR*           :WS-RV-BILL-NO,                                               
MFA-TR*           :WS-RV-CODE-UTIL-TYPE,                                        
MFA-TR*           :WS-RV-IC-NO,                                                 
MFA-TR*           :WS-RV-BILL-ITEM-TIMESTMP,                                    
MFA-TR*           :WS-RV-CUST-CT,                                               
MFA-TR*           :WS-RV-CUST-CT-EXCL-LIGHT,                                    
MFA-TR*           :WS-RV-USAGE-END-DATE :WS-RV-USAGE-END-DATE-NULL-IND,         
MFA-TR*           :WS-RV-NO-OF-CONS-DAYS,                                       
MFA-TR*           :WS-RV-PRORATED-DAYS-CD,                                      
MFA-TR*           :WS-RV-BTU-FACTOR,                                            
MFA-TR*           :WS-RV-GAS-BASE-USE,                                          
MFA-TR*           :WS-RV-DESIGN-DAY-CAP,                                        
MFA-TR*           :WS-RV-DATE-BILLED :WS-RV-DATE-BILLED-NULL-IND,               
MFA-TR*           :WS-RV-DATE-ORIG-BILL :WS-RV-DATE-ORIG-BILL-NULL-IND,         
MFA-TR*           :WS-RV-REV-MTH-ORIG-BILL,                                     
MFA-TR*           :WS-RV-ACCT-BILL-CYCLE,                                       
MFA-TR*           :WS-RV-BILL-CALC-CYCLE,                                       
MFA-TR*           :WS-RV-CODE-REV-ACCT-TYPE,                                    
MFA-TR*           :WS-RV-CODE-REVENUE-CLASS,                                    
MFA-TR*           :WS-RV-RATE-PLAN-NO,                                          
MFA-TR*           :WS-RV-RATE-DEPT-CD,                                          
MFA-TR*           :WS-RV-PRTY-SVC-CAT-CD,                                       
MFA-TR*           :WS-RV-CODE-SIC-NO,                                           
MFA-TR*           :WS-RV-NAICS-CD,                                              
MFA-TR*           :WS-RV-TIER-ACCT-TYPE-CD,                                     
MFA-TR*           :WS-RV-OPTION-CD,                                             
MFA-TR*           :WS-RV-RATE-CALC-TYPE-CD,                                     
MFA-TR*           :WS-RV-LOCAL-OFFICE,                                          
MFA-TR*           :WS-RV-REV-DISTRICT-CD,                                       
MFA-TR*           :WS-RV-MNICPLTY-COUNTY-CD,                                    
MFA-TR*           :WS-RV-PREMISE-NO,                                            
MFA-TR*           :WS-RV-CALC-SOURCE-CD,                                        
MFA-TR*           :WS-RV-ELEC-WNA-GROUP-NO)                                     
MFA-TR*           FOR :WS-INSERT-COUNT  ROWS                                    
MFA-TR*           ATOMIC                                                        
MFA-TR*    END-EXEC.                                                            

MSQ009     IF SQLCODE NOT EQUAL 0
MSQ009       MOVE SQLCODE TO MSQ009-SQLCODE
MSQ009       EXEC SQL
MSQ009         CALL CIS.ROLLBACK_SAVEPOINT('MSQ009-TRNS')
MSQ009       END-EXEC
MSQ009       MOVE MSQ009-SQLCODE TO SQLCODE
MSQ009     END-IF
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******PCSCA204 ABORT*****************'           
              DISPLAY '       8200-INSERT-REV-BILL-DET      '           
              DISPLAY ' ** ERROR ON INSERT '                            
              DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE          
              DISPLAY ' ** TABLE REV_BILLING_DET '                      
              DISPLAY '******PCSCA204 ABORT*****************'           
              PERFORM 7500-GET-DB2-DIAGNOSTICS THRU 7500-EXIT           
                                                                        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8300-INSERT-REV-BILL-COM-ADJ                                   *        
      * INSERTS DATA IN REV_BILL_COMP_ADJ                              *        
      ******************************************************************        
       8300-INSERT-REV-BILL-COM-ADJ.                                    

MSQ009     EXEC SQL
MSQ009       SAVE TRANSACTION MSQ009-TRNS
MSQ009     END-EXEC
                                                                        
           EXEC SQL                                                     
               FOR :WS-INSERT-COUNT
              INSERT INTO REV_BILL_COMP_ADJ
              (BILL_UNIQUE_TS,                                      
                   BILL_COMP_SEQ_NO,                                    
                   CMPNT_ID_CD,                                         
                   INSTR_USE_TYPE_CD,                                   
                   CONSUMPT_TYPE_CD,                                    
                   CODE_TIME_PERIOD,                                    
                   CODE_SEASON,                                         
                   RT_VERS_FROM_DT,                                     
                   RT_VERS_PRO_CD,                                      
                   FACTOR_ID,                                           
                   FACTOR_BLOCK_NO,                                     
                   RT_FCT_FROM_DT,                                      
                   RT_FCT_PRO_CD,                                       
                   READ_UNITS,                                          
                   BILL_USAGE_UNITS,                                    
                   BILL_DEMAND_UNITS,                                   
                   CALC_UNITS,                                          
                   FACTOR,                                              
                   BILLED_AMT,                                          
                   CODE_STAT_TAX_XMT,                                   
                   CODE_CITY_TAX_XMT,                                   
                   CODE_OTHR_TAX_XMT,                                   
                   UTILITY_REV_CD,                                      
                   COMP_ADJ_CD,                                         
                   GL_ACCT_NO,                                          
                   SPCL_GROUP_CD,                                       
                   ACCOUNT_NO)
              VALUES                                                   
                  (CIS.CHAR2TIMESTAMP(:WS-RB-BILL-UNIQUE-TS),                   
                   :WS-RB-BILL-COMP-SEQ-NO,                             
                   :WS-RB-CMPNT-ID-CD,                                  
                   :WS-RB-INSTR-USE-TYPE-CD,                            
                   :WS-RB-CONSUMPT-TYPE-CD,                             
                   :WS-RB-CODE-TIME-PERIOD,                             
                   :WS-RB-CODE-SEASON,                                  
                   IIF(TRY_CONVERT(DATE, :WS-RB-RT-VERS-FROM-DT 
                                         :WS-RB-RT-VERS-DT-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :WS-RB-RT-VERS-FROM-DT 
                                             :WS-RB-RT-VERS-DT-NULL-IND
              ) <> 0) OR (LEN(:WS-RB-RT-VERS-FROM-DT 
                                             :WS-RB-RT-VERS-DT-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:WS-RB-RT-VERS-FROM-DT 
                                             :WS-RB-RT-VERS-DT-NULL-IND
              ), CONVERT(DATE, :WS-RB-RT-VERS-FROM-DT 
                                             :WS-RB-RT-VERS-DT-NULL-IND
              ) ),   
                   :WS-RB-RT-VERS-PRO-CD,                               
                   :WS-RB-FACTOR-ID,                                    
                   :WS-RB-FACTOR-BLOCK-NO,                              
                   IIF(TRY_CONVERT(DATE, :WS-RB-RT-FCT-FROM-DT 
                                         :WS-RB-RT-FCTR-DT-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :WS-RB-RT-FCT-FROM-DT 
                                             :WS-RB-RT-FCTR-DT-NULL-IND
              ) <> 0) OR (LEN(:WS-RB-RT-FCT-FROM-DT 
                                             :WS-RB-RT-FCTR-DT-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:WS-RB-RT-FCT-FROM-DT 
                                             :WS-RB-RT-FCTR-DT-NULL-IND
              ), CONVERT(DATE, :WS-RB-RT-FCT-FROM-DT 
                                             :WS-RB-RT-FCTR-DT-NULL-IND
              ) ),   
                   :WS-RB-RT-FCT-PRO-CD,                                
                   :WS-RB-READ-UNITS,                                   
                   :WS-RB-BILL-USAGE-UNITS,                             
                   :WS-RB-BILL-DEMAND-UNITS,                            
                   :WS-RB-CALC-UNITS,                                   
                   :WS-RB-FACTOR,                                       
                   :WS-RB-BILLED-AMT,                                   
                   :WS-RB-CODE-STAT-TAX-XMT,                            
                   :WS-RB-CODE-CITY-TAX-XMT,                            
                   :WS-RB-CODE-OTHR-TAX-XMT,                            
                   :WS-RB-UTILITY-REV-CD,                               
                   :WS-RB-COMP-ADJ-CD,                                  
                   :WS-RB-GL-ACCT-NO,                                   
                   :WS-RB-SPCL-GROUP-CD,                                
                   :WS-RB-ACCOUNT-NO)
              
                                                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ009
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO REV_BILL_COMP_ADJ                                    
MFA-TR*           (BILL_UNIQUE_TS,                                              
MFA-TR*            BILL_COMP_SEQ_NO,                                            
MFA-TR*            CMPNT_ID_CD,                                                 
MFA-TR*            INSTR_USE_TYPE_CD,                                           
MFA-TR*            CONSUMPT_TYPE_CD,                                            
MFA-TR*            CODE_TIME_PERIOD,                                            
MFA-TR*            CODE_SEASON,                                                 
MFA-TR*            RT_VERS_FROM_DT,                                             
MFA-TR*            RT_VERS_PRO_CD,                                              
MFA-TR*            FACTOR_ID,                                                   
MFA-TR*            FACTOR_BLOCK_NO,                                             
MFA-TR*            RT_FCT_FROM_DT,                                              
MFA-TR*            RT_FCT_PRO_CD,                                               
MFA-TR*            READ_UNITS,                                                  
MFA-TR*            BILL_USAGE_UNITS,                                            
MFA-TR*            BILL_DEMAND_UNITS,                                           
MFA-TR*            CALC_UNITS,                                                  
MFA-TR*            FACTOR,                                                      
MFA-TR*            BILLED_AMT,                                                  
MFA-TR*            CODE_STAT_TAX_XMT,                                           
MFA-TR*            CODE_CITY_TAX_XMT,                                           
MFA-TR*            CODE_OTHR_TAX_XMT,                                           
MFA-TR*            UTILITY_REV_CD,                                              
MFA-TR*            COMP_ADJ_CD,                                                 
MFA-TR*            GL_ACCT_NO,                                                  
MFA-TR*            SPCL_GROUP_CD,                                               
MFA-TR*            ACCOUNT_NO)                                                  
MFA-TR*        VALUES                                                           
MFA-TR*           (:WS-RB-BILL-UNIQUE-TS,                                       
MFA-TR*            :WS-RB-BILL-COMP-SEQ-NO,                                     
MFA-TR*            :WS-RB-CMPNT-ID-CD,                                          
MFA-TR*            :WS-RB-INSTR-USE-TYPE-CD,                                    
MFA-TR*            :WS-RB-CONSUMPT-TYPE-CD,                                     
MFA-TR*            :WS-RB-CODE-TIME-PERIOD,                                     
MFA-TR*            :WS-RB-CODE-SEASON,                                          
MFA-TR*            :WS-RB-RT-VERS-FROM-DT :WS-RB-RT-VERS-DT-NULL-IND,           
MFA-TR*            :WS-RB-RT-VERS-PRO-CD,                                       
MFA-TR*            :WS-RB-FACTOR-ID,                                            
MFA-TR*            :WS-RB-FACTOR-BLOCK-NO,                                      
MFA-TR*            :WS-RB-RT-FCT-FROM-DT  :WS-RB-RT-FCTR-DT-NULL-IND,           
MFA-TR*            :WS-RB-RT-FCT-PRO-CD,                                        
MFA-TR*            :WS-RB-READ-UNITS,                                           
MFA-TR*            :WS-RB-BILL-USAGE-UNITS,                                     
MFA-TR*            :WS-RB-BILL-DEMAND-UNITS,                                    
MFA-TR*            :WS-RB-CALC-UNITS,                                           
MFA-TR*            :WS-RB-FACTOR,                                               
MFA-TR*            :WS-RB-BILLED-AMT,                                           
MFA-TR*            :WS-RB-CODE-STAT-TAX-XMT,                                    
MFA-TR*            :WS-RB-CODE-CITY-TAX-XMT,                                    
MFA-TR*            :WS-RB-CODE-OTHR-TAX-XMT,                                    
MFA-TR*            :WS-RB-UTILITY-REV-CD,                                       
MFA-TR*            :WS-RB-COMP-ADJ-CD,                                          
MFA-TR*            :WS-RB-GL-ACCT-NO,                                           
MFA-TR*            :WS-RB-SPCL-GROUP-CD,                                        
MFA-TR*            :WS-RB-ACCOUNT-NO)                                           
MFA-TR*           FOR :WS-INSERT-COUNT  ROWS                                    
MFA-TR*           ATOMIC                                                        
MFA-TR*    END-EXEC.                                                            

MSQ009     IF SQLCODE NOT EQUAL 0
MSQ009       MOVE SQLCODE TO MSQ009-SQLCODE
MSQ009       EXEC SQL
MSQ009         CALL CIS.ROLLBACK_SAVEPOINT('MSQ009-TRNS')
MSQ009       END-EXEC
MSQ009       MOVE MSQ009-SQLCODE TO SQLCODE
MSQ009     END-IF
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******PCSCA204 ABORT*****************'           
              DISPLAY '       8300-INSERT-REV-BILL-COM-ADJ  '           
              DISPLAY ' ** ERROR ON INSERT '                            
              DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE          
              DISPLAY ' ** TABLE REV_BILL_COMP_ADJ'                     
              DISPLAY '******PCSCA204 ABORT*****************'           
              PERFORM 7500-GET-DB2-DIAGNOSTICS THRU 7500-EXIT           
                                                                        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8400-INSERT-REV-BILL-BLOCK                                     *        
      * INSERTS DATA IN REV_BILL_BLOCK                                 *        
      ******************************************************************        
       8400-INSERT-REV-BILL-BLOCK.                                      

MSQ009     EXEC SQL
MSQ009       SAVE TRANSACTION MSQ009-TRNS
MSQ009     END-EXEC
                                                                        
           EXEC SQL                                                     
               FOR :WS-INSERT-COUNT
              INSERT INTO REV_BILL_BLOCK
              (BILL_UNIQUE_TS,                                      
                   BILL_COMP_SEQ_NO,                                    
                   BLK_NO_RT_ITM_CD,                                    
                   BLK_USE_OR_SVCS,                                     
                   BLK_BILL_USE_UNITS,                                  
                   BLK_BILL_DEM_UNITS,                                  
                   BLK_BILL_LT_POLES,                                   
                   CUST_PER_SERVICE,                                    
                   PRICE_TYPE_CD,                                       
                   SCHED_PRICE_AM,                                      
                   UNIT_PRICE_AM,                                       
                   BLK_REV_AMT,                                         
                   NET_UNIT_SEL_RSN,                                    
                   KW_MDQ_DT,                                           
                   KVA_DT,                                              
                   CONTRACT_DEMAND,                                     
                   READ_KW_MDQ_UNITS,                                   
                   READ_KVA_UNITS,                                      
                   POWER_FACTOR,                                        
                   LOAD_FACTOR,                                         
                   RT_VERS_PRO_PCT,                                     
                   ACCOUNT_NO,                                          
                   RATE_ITEM_CODE)
              VALUES                                                   
                  (CIS.CHAR2TIMESTAMP(:WS-R7-BILL-UNIQUE-TS),                   
                   :WS-R7-BILL-COMP-SEQ-NO,                             
                   :WS-R7-BLK-NO-RT-ITM-CD,                             
                   :WS-R7-BLK-USE-OR-SVCS,                              
                   :WS-R7-BLK-BILL-USE-UNITS,                           
                   :WS-R7-BLK-BILL-DEM-UNITS,                           
                   :WS-R7-BLK-BILL-LT-POLES,                            
                   :WS-R7-CUST-PER-SERVICE,                             
                   :WS-R7-PRICE-TYPE-CD,                                
                   :WS-R7-SCHED-PRICE-AM,                               
                   :WS-R7-UNIT-PRICE-AM,                                
                   :WS-R7-BLK-REV-AMT,                                  
                   :WS-R7-NET-UNIT-SEL-RSN,                             
                   IIF(TRY_CONVERT(DATE, :WS-R7-KW-MDQ-DT 
                                         :WS-R7-KW-MDQ-DT-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :WS-R7-KW-MDQ-DT 
                                              :WS-R7-KW-MDQ-DT-NULL-IND
              ) <> 0) OR (LEN(:WS-R7-KW-MDQ-DT 
                                              :WS-R7-KW-MDQ-DT-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:WS-R7-KW-MDQ-DT 
                                              :WS-R7-KW-MDQ-DT-NULL-IND
              ), CONVERT(DATE, :WS-R7-KW-MDQ-DT 
                                              :WS-R7-KW-MDQ-DT-NULL-IND
              ) ),          
                   IIF(TRY_CONVERT(DATE, :WS-R7-KVA-DT 
                                         :WS-R7-KVA-DT-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :WS-R7-KVA-DT 
                                                 :WS-R7-KVA-DT-NULL-IND
              ) <> 0) OR (LEN(:WS-R7-KVA-DT :WS-R7-KVA-DT-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:WS-R7-KVA-DT 
                                                 :WS-R7-KVA-DT-NULL-IND
              ), CONVERT(DATE, :WS-R7-KVA-DT :WS-R7-KVA-DT-NULL-IND) ),        
                   :WS-R7-CONTRACT-DEMAND,                              
                   :WS-R7-READ-KW-MDQ-UNITS,                            
                   :WS-R7-READ-KVA-UNITS,                               
                   :WS-R7-POWER-FACTOR,                                 
                   :WS-R7-LOAD-FACTOR,                                  
                   :WS-R7-RT-VERS-PRO-PCT,                              
                   :WS-R7-ACCOUNT-NO,                                   
                   :WS-R7-RATE-ITEM-CODE)
              
                                                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ009
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO REV_BILL_BLOCK                                       
MFA-TR*           (BILL_UNIQUE_TS,                                              
MFA-TR*            BILL_COMP_SEQ_NO,                                            
MFA-TR*            BLK_NO_RT_ITM_CD,                                            
MFA-TR*            BLK_USE_OR_SVCS,                                             
MFA-TR*            BLK_BILL_USE_UNITS,                                          
MFA-TR*            BLK_BILL_DEM_UNITS,                                          
MFA-TR*            BLK_BILL_LT_POLES,                                           
MFA-TR*            CUST_PER_SERVICE,                                            
MFA-TR*            PRICE_TYPE_CD,                                               
MFA-TR*            SCHED_PRICE_AM,                                              
MFA-TR*            UNIT_PRICE_AM,                                               
MFA-TR*            BLK_REV_AMT,                                                 
MFA-TR*            NET_UNIT_SEL_RSN,                                            
MFA-TR*            KW_MDQ_DT,                                                   
MFA-TR*            KVA_DT,                                                      
MFA-TR*            CONTRACT_DEMAND,                                             
MFA-TR*            READ_KW_MDQ_UNITS,                                           
MFA-TR*            READ_KVA_UNITS,                                              
MFA-TR*            POWER_FACTOR,                                                
MFA-TR*            LOAD_FACTOR,                                                 
MFA-TR*            RT_VERS_PRO_PCT,                                             
MFA-TR*            ACCOUNT_NO,                                                  
MFA-TR*            RATE_ITEM_CODE)                                              
MFA-TR*        VALUES                                                           
MFA-TR*           (:WS-R7-BILL-UNIQUE-TS,                                       
MFA-TR*            :WS-R7-BILL-COMP-SEQ-NO,                                     
MFA-TR*            :WS-R7-BLK-NO-RT-ITM-CD,                                     
MFA-TR*            :WS-R7-BLK-USE-OR-SVCS,                                      
MFA-TR*            :WS-R7-BLK-BILL-USE-UNITS,                                   
MFA-TR*            :WS-R7-BLK-BILL-DEM-UNITS,                                   
MFA-TR*            :WS-R7-BLK-BILL-LT-POLES,                                    
MFA-TR*            :WS-R7-CUST-PER-SERVICE,                                     
MFA-TR*            :WS-R7-PRICE-TYPE-CD,                                        
MFA-TR*            :WS-R7-SCHED-PRICE-AM,                                       
MFA-TR*            :WS-R7-UNIT-PRICE-AM,                                        
MFA-TR*            :WS-R7-BLK-REV-AMT,                                          
MFA-TR*            :WS-R7-NET-UNIT-SEL-RSN,                                     
MFA-TR*            :WS-R7-KW-MDQ-DT :WS-R7-KW-MDQ-DT-NULL-IND,                  
MFA-TR*            :WS-R7-KVA-DT :WS-R7-KVA-DT-NULL-IND,                        
MFA-TR*            :WS-R7-CONTRACT-DEMAND,                                      
MFA-TR*            :WS-R7-READ-KW-MDQ-UNITS,                                    
MFA-TR*            :WS-R7-READ-KVA-UNITS,                                       
MFA-TR*            :WS-R7-POWER-FACTOR,                                         
MFA-TR*            :WS-R7-LOAD-FACTOR,                                          
MFA-TR*            :WS-R7-RT-VERS-PRO-PCT,                                      
MFA-TR*            :WS-R7-ACCOUNT-NO,                                           
MFA-TR*            :WS-R7-RATE-ITEM-CODE)                                       
MFA-TR*           FOR :WS-INSERT-COUNT  ROWS                                    
MFA-TR*           ATOMIC                                                        
MFA-TR*    END-EXEC.                                                            

MSQ009     IF SQLCODE NOT EQUAL 0
MSQ009       MOVE SQLCODE TO MSQ009-SQLCODE
MSQ009       EXEC SQL
MSQ009         CALL CIS.ROLLBACK_SAVEPOINT('MSQ009-TRNS')
MSQ009       END-EXEC
MSQ009       MOVE MSQ009-SQLCODE TO SQLCODE
MSQ009     END-IF
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******PCSCA204 ABORT*****************'           
              DISPLAY '       8400-INSERT-REV-BILL-BLOCK    '           
              DISPLAY ' ** ERROR ON INSERT '                            
              DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE          
              DISPLAY ' ** TABLE REV_BILL_BLOCK'                        
              DISPLAY '******PCSCA204 ABORT*****************'           
              PERFORM 7500-GET-DB2-DIAGNOSTICS THRU 7500-EXIT           
                                                                        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8500-INSERT-REV-BILL-TAX                                       *        
      * INSERTS DATA IN REV_BILL_TAX                                   *        
      ******************************************************************        
       8500-INSERT-REV-BILL-TAX.                                        

MSQ009     EXEC SQL
MSQ009       SAVE TRANSACTION MSQ009-TRNS
MSQ009     END-EXEC
                                                                        
           EXEC SQL                                                     
               FOR :WS-INSERT-COUNT
              INSERT INTO REV_BILL_TAX
              (BILL_UNIQUE_TS,                                      
                   TAX_TYPE,                                            
                   TAX_CNTRL_NO,                                        
                   TAX_FROM_DT,                                         
                   FACTOR_ID,                                           
                   TAX_GL_ACCT_NO,                                      
                   TAX_AMT,                                             
                   ACCOUNT_NO)
              VALUES                                                   
                  (CIS.CHAR2TIMESTAMP(:WS-R9-BILL-UNIQUE-TS),                   
                   :WS-R9-TAX-TYPE,                                     
                   :WS-R9-TAX-CNTRL-NO,                                 
                   IIF(TRY_CONVERT(DATE, :WS-R9-TAX-FROM-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-R9-TAX-FROM-DT
              ) <> 0) OR (LEN(:WS-R9-TAX-FROM-DT
              ) <> 10), CIS.CHAR2DATE(:WS-R9-TAX-FROM-DT
              ), CONVERT(DATE, :WS-R9-TAX-FROM-DT) ),                          
                   :WS-R9-FACTOR-ID,                                    
                   :WS-R9-TAX-GL-ACCT-NO,                               
                   :WS-R9-TAX-AMT,                                      
                   :WS-R9-ACCOUNT-NO)
              
                                                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ009
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO REV_BILL_TAX                                         
MFA-TR*           (BILL_UNIQUE_TS,                                              
MFA-TR*            TAX_TYPE,                                                    
MFA-TR*            TAX_CNTRL_NO,                                                
MFA-TR*            TAX_FROM_DT,                                                 
MFA-TR*            FACTOR_ID,                                                   
MFA-TR*            TAX_GL_ACCT_NO,                                              
MFA-TR*            TAX_AMT,                                                     
MFA-TR*            ACCOUNT_NO)                                                  
MFA-TR*        VALUES                                                           
MFA-TR*           (:WS-R9-BILL-UNIQUE-TS,                                       
MFA-TR*            :WS-R9-TAX-TYPE,                                             
MFA-TR*            :WS-R9-TAX-CNTRL-NO,                                         
MFA-TR*            :WS-R9-TAX-FROM-DT,                                          
MFA-TR*            :WS-R9-FACTOR-ID,                                            
MFA-TR*            :WS-R9-TAX-GL-ACCT-NO,                                       
MFA-TR*            :WS-R9-TAX-AMT,                                              
MFA-TR*            :WS-R9-ACCOUNT-NO)                                           
MFA-TR*           FOR :WS-INSERT-COUNT  ROWS                                    
MFA-TR*           ATOMIC                                                        
MFA-TR*    END-EXEC.                                                            

MSQ009     IF SQLCODE NOT EQUAL 0
MSQ009       MOVE SQLCODE TO MSQ009-SQLCODE
MSQ009       EXEC SQL
MSQ009         CALL CIS.ROLLBACK_SAVEPOINT('MSQ009-TRNS')
MSQ009       END-EXEC
MSQ009       MOVE MSQ009-SQLCODE TO SQLCODE
MSQ009     END-IF
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******PCSCA204 ABORT*****************'           
              DISPLAY '       8500-INSERT-REV-BILL-TAX      '           
              DISPLAY ' ** ERROR ON INSERT '                            
              DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE          
              DISPLAY ' ** TABLE REV_BILL_TAX  '                        
              DISPLAY '******PCSCA204 ABORT*****************'           
              PERFORM 7500-GET-DB2-DIAGNOSTICS THRU 7500-EXIT           
                                                                        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00257******************************************************************        
P00257* 8600-UPDATE-JOB-PARM.                                          *        
P00257* UPDATES THE BILL UNIQUE TIMESTAMP IN JOB PARM TABLE            *        
P00257******************************************************************        
P00257 8600-UPDATE-JOB-PARM.                                            
P00257                                                                  
P00257     EXEC SQL                                                     
P00257        UPDATE CSS_JOB_PARM                                       
P00257           SET PARM_DATA    = :WS-JOB-PARM-DATA                   
P00257         WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                    
P00257           AND COMPANY_NO   = :G6-COMPANY-NO                      
P00257           AND CMND_CODE    = :G6-CMND-CODE                       
P00257           AND SEQ_NO       = :G6-SEQ-NO                          
P00257     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00257                                                                  
P00257     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00257                                                                  
P00257     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00257        CONTINUE                                                  
P00257     ELSE                                                         
P00257        DISPLAY '******PCSCA204 ABORT*****************'           
P00257        DISPLAY '       8600-UPDATE-JOB-PARM          '           
P00257        DISPLAY ' ** ERROR ON UPDATE '                            
P00257        DISPLAY ' ** PROGRAM_NAME: 'G6-PROGRAM-NAME               
P00257        DISPLAY ' ** COMPANY_NO: 'G6-COMPANY-NO                   
P00257        DISPLAY ' ** CMND_CODE: 'G6-CMND-CODE                     
P00257        DISPLAY ' ** SEQ_NO: 'G6-SEQ-NO                           
P00257        DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE          
P00257        DISPLAY ' ** TABLE CSS_JOB_PARM  '                        
P00257        DISPLAY '******PCSCA204 ABORT*****************'           
P00257        PERFORM 9900-ABEND               THRU 9900-EXIT           
P00257     END-IF.                                                      
P00257*                                                                         
P00257 8600-EXIT.                                                       
P00257     EXIT.                                                        
P00257*                                                                         
PRJ257******************************************************************        
PRJ257* 8610-UPDATE-JOB-PARM-BN.                                       *        
PRJ257* UPDATES THE VALUE OF REV MONTH IN THE PARM DATA FIELD FOR      *        
PRJ257* JOB PARM TABLE FOR PROGRAM PCSCA204.                           *        
PRJ257******************************************************************        
PRJ257 8610-UPDATE-JOB-PARM-BN.                                         
PRJ257*                                                                         
PRJ257     EXEC SQL                                                     
PRJ257        UPDATE CSS_JOB_PARM                                       
PRJ257           SET PARM_DATA = (                                      
PRJ257               SELECT LEFT(('REVENUE-MONTH=' + LTRIM(RTRIM(
           CIS.DECIMAL2CHAR(MIN(REVENUE_MONTH))))),20)     
PRJ257                 FROM CSS_BILL_WINDOW                             
PRJ257                WHERE DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) ) )           
PRJ257         WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                    
PRJ257           AND SEQ_NO       = :G6-SEQ-NO                          
PRJ257           AND CMND_CODE    = :G6-CMND-CODE                       
PRJ257     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_JOB_PARM                                               
MFA-TR*          SET PARM_DATA = (                                              
MFA-TR*              SELECT LEFT(('REVENUE-MONTH='                              
MFA-TR*                     || STRIP(CHAR(MIN(REVENUE_MONTH)))),20)             
MFA-TR*                FROM CSS_BILL_WINDOW                                     
MFA-TR*               WHERE DATE_EXTRACT = :BN-DATE-EXTRACT )                   
MFA-TR*        WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                            
MFA-TR*          AND SEQ_NO       = :G6-SEQ-NO                                  
MFA-TR*          AND CMND_CODE    = :G6-CMND-CODE                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ257                                                                  
PRJ257     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
PRJ257                                                                  
PRJ257     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
PRJ257        CONTINUE                                                  
PRJ257     ELSE                                                         
PRJ257        DISPLAY '******PCSCA204 ABORT*****************'           
PRJ257        DISPLAY '       8610-UPDATE-JOB-PARM-BN       '           
PRJ257        DISPLAY ' ** ERROR ON UPDATE '                            
PRJ257        DISPLAY ' ** PROGRAM_NAME: 'G6-PROGRAM-NAME               
PRJ257        DISPLAY ' ** COMPANY_NO: 'G6-COMPANY-NO                   
PRJ257        DISPLAY ' ** CMND_CODE: 'G6-CMND-CODE                     
PRJ257        DISPLAY ' ** SEQ_NO: 'G6-SEQ-NO                           
PRJ257        DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE          
PRJ257        DISPLAY ' ** TABLE CSS_JOB_PARM  '                        
PRJ257        DISPLAY '******PCSCA204 ABORT*****************'           
PRJ257        PERFORM 9900-ABEND                 THRU 9900-EXIT         
PRJ257     END-IF.                                                      
PRJ257*                                                                         
PRJ257 8610-EXIT.                                                       
PRJ257     EXIT.                                                        
PRJ257*                                                                         
      ******************************************************************        
      * 8800-WRITE-RESTART                                             *        
      ******************************************************************        
       8800-WRITE-RESTART.                                              
                                                                        
           MOVE WS-PGRMNAME                 TO RF-NAME-PROGRAM.         
           MOVE 1                           TO RF-PARTITION-NO.         
           MOVE 1                           TO RF-DUP-CNTRL-NO.         
           MOVE WS-RESTART-DATA             TO RF-RESTART-DATA-TEXT.    
           MOVE WS-RESTART-DATA-LENGTH      TO RF-RESTART-DATA-LEN.     
                                                                        
           PERFORM 8850-UPDATE-RESTART          THRU 8850-EXIT.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 8860-INSERT-RESTART       THRU 8860-EXIT          
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
PRJ257*****************************************************************         
PRJ257* 8840-DELETE-RESTART-ROW.                                      *         
PRJ257*****************************************************************         
PRJ257 8840-DELETE-RESTART-ROW.                                         
PRJ257*                                                                         
PRJ257     MOVE WS-PGRMNAME            TO RF-NAME-PROGRAM.              
PRJ257     MOVE 1                      TO RF-PARTITION-NO.              
PRJ257     MOVE 1                      TO RF-DUP-CNTRL-NO.              
PRJ257     EXEC SQL                                                     
PRJ257         DELETE FROM CSS_RESTART                                  
PRJ257          WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                   
PRJ257            AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
PRJ257            AND PARTITION_NO = :RF-PARTITION-NO                   
PRJ257     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ257*                                                                         
PRJ257     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
PRJ257     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
PRJ257        CONTINUE                                                  
PRJ257     ELSE                                                         
PRJ257        DISPLAY '********** PCSCA204 ABORT **************'        
PRJ257        DISPLAY '*** ERROR IN 8840-DELETE-RESTART-ROW ***'        
PRJ257        DISPLAY '* NAME_PROGRAM   : ' RF-NAME-PROGRAM             
PRJ257        DISPLAY '* DUP_CNTRL_NO   : ' RF-DUP-CNTRL-NO             
PRJ257        DISPLAY '* PARTITION_NO   : ' RF-PARTITION-NO             
PRJ257        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
PRJ257        DISPLAY '***       PROCESSING TERMINATED      ***'        
PRJ257        DISPLAY '********** PCSCA204 ABORT **************'        
PRJ257        PERFORM 9900-ABEND                     THRU 9900-EXIT     
PRJ257     END-IF.                                                      
PRJ257*                                                                         
PRJ257 8840-EXIT.                                                       
PRJ257     EXIT.                                                        
PRJ257*                                                                         
      ******************************************************************        
      * 8850-UPDATE-RESTART.                                           *        
      ******************************************************************        
       8850-UPDATE-RESTART.                                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_RESTART                                       
                  SET RESTART_DATA = :RF-RESTART-DATA                   
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                   
                  AND PARTITION_NO = :RF-PARTITION-NO                   
                  AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO  WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA204 ABORT **************'        
              DISPLAY '*        8850-UPDATE-RESTART           *'        
              DISPLAY '* NAME_PROGRAM   : ' RF-NAME-PROGRAM             
              DISPLAY '* DUP_CNTRL_NO   : ' RF-DUP-CNTRL-NO             
              DISPLAY '* PARTITION_NO   : ' RF-PARTITION-NO             
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA204 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8850-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8860-INSERT-RESTART.                                           *        
      ******************************************************************        
       8860-INSERT-RESTART.                                             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_RESTART                                  
                     ( NAME_PROGRAM                                     
                      ,PARTITION_NO                                     
                      ,DUP_CNTRL_NO                                     
                      ,RESTART_DATA)                                    
               VALUES(:RF-NAME-PROGRAM                                  
                     ,:RF-PARTITION-NO                                  
                     ,:RF-DUP-CNTRL-NO                                  
                     ,:RF-RESTART-DATA)                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO  WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA204 ABORT **************'        
              DISPLAY '*       8860-INSERT-RESTART            *'        
              DISPLAY '* NAME_PROGRAM   : ' RF-NAME-PROGRAM             
              DISPLAY '* DUP_CNTRL_NO   : ' RF-DUP-CNTRL-NO             
              DISPLAY '* PARTITION_NO   : ' RF-PARTITION-NO             
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA204 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8860-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8888-COMMIT.                                                   *        
      ******************************************************************        
       8888-COMMIT.                                                     
                                                                        
           IF WS-CHKP-LUW-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS       
              AND WS-CHKP-UPD-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS   
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 8800-WRITE-RESTART        THRU 8800-EXIT          
                                                                        
              EXEC SQL                                                  
                 COMMIT                                                 
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              DISPLAY 'COMMIT POINT # ' WS-CHKP-SEQ-NO ' TAKEN.'        
           END-IF.                                                      
      *                                                                         
       8888-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 8893-RESET-RESTART-REQ-PARM                                    *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00029                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9000-TERMINATE                                                 *        
      * CLOSING INPUT FILES                                            *        
      ******************************************************************        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSCREVB-FILE.                                         
           CLOSE FCSCREVC-FILE.                                         
           CLOSE FCSCREVD-FILE.                                         
           CLOSE FCSCREVT-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 9900-ABEND                                                     *        
      * COPYBOOK FOR ABEND/ERROR PROCESSING                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD09900                                                  
           END-EXEC.                                                            
      *                                                                         
