       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA200.                                        
      ***************************************************************** 00030000
      **              SOUTH CAROLINA ELECTRIC & GAS                  ** 00040000
      **                     PRICE WATERHOUSE                        ** 00050000
      **                                                             ** 00060000
      **               CUSTOMER INFORMATION SYSTEM                   ** 00070000
      **                                                             ** 00080000
      ***************************************************************** 00090000
      **               P R O G R A M  S U M M A R Y                  ** 00100000
      **                                                             ** 00110000
      ** THIS PROCEDURE INITIATES REFUNDS FOR FINAL ACCOUNTS WITH    ** 00120000
      ** CREDIT BALANCES. THIS ALSO CREATES A WORK QUEUE ITEM AND    ** 00130000
      ** SUSPENDS PAYMENT OF THE REFUND FOR 2 BILL DAYS.  WHEN IT    ** 00160000
      ** REACHES ITS RELEASE DATE, THE ACCOUNT IS CHECKED TO CONFIRM ** 00170000
      ** THE CREDIT AND THE REFUND IS RELEASED FOR PRINTING.         ** 00180000
      ***************************************************************** 00190000
      **                                                             ** 00200000
      **              PROGRAM  MODIFICATION  LOG                     ** 00210000
      **                                                             ** 00220000
      **    DATE    INITIALS  REASON                                 ** 00230000
      **  ________  ________  ______                                 ** 00240000
T20558**  10/03/00  CB18344   INITIAL PROGRAM VERSION                ** 00250000
T20558**                                                             **         
C25612**  11/09/01  COVANSYS  COMPANY NO LOGIC IS REMOVED FROM       **         
C25612**            CHENNAI   CSS_HOLIDAY TABLE                      **         
T22962**  01/15/02  CB18344   MADE CHANGES TO PROGRAM TO REMOVE      ** 00250000
T22962**                      COMMENTS, SHOW REFUND REASON ON PANEL, ** 00250000
T22962**                      AND STOP DUPLICATE REFUND CHECKS FROM  ** 00250000
T22962**                      BEING REQUESTED.                       ** 00250000
T22962**                      CHANGES WERE ALSO MADE TO CHECK FOR A  ** 00250000
T22962**                      TRANSFER DONE FROM DATE-BILL-DAY-30 TO ** 00250000
T22962**                      LAST-PYMT-DATE.  IF ONE WAS DONE, THE  ** 00250000
T22962**                      REFUND ROW WILL NOT BE CREATED.        ** 00250000
T30752*   04/21/04  VIJAY     INCREASE OCCURS OF WS-WORK-DAY-TABLE   **         
      *                       FROM 300 TO 500 TO ACCOMMODATE         **         
      *                       INCREASING THE FORECAST OF CREDIT BUREA**         
      *                       DATE TO 345 BUSINESS DAYS FROM FINAL   **         
T30175*   08/18/05  DAS       PREVENT WQS FROM GENERATING IN SEBP    **         
T30175*                       FOR CAT-ID 99                          **         
C36660*   01/14/08  DM94438   ADD DATE FILTERS IN WHERE CLAUSE TO STO**         
C36660*                       OLD < $1.00 REFUNDS DUE TO CHANGE IN   **         
C36660*                       DELINQUENCY VALUE FROM -1 TO 0         **         
C36660*   06/02/08  DM94438   REMOVED DATE FILTERS ABOVE             **         
A00557*   12/31/08  VP94820   CANCEL SYSTEM REQUESTED REFUNDS BEFORE **         
A00557*                       INSERTING NEW REFUND WITH TRAN BAL.    **         
A00557*   11/02/09  VP94820   FIX INITIALIZATION ISSUE IN CALCULATING**         
A00557*                       AR EXCEPTIONS.                         **         
A02034*   10/14/10  BD09555   CORRECT SQL STATEMENT                  **         
A02798*   11/13/10  NC94746   ACT0002: INCLUDE CREDIT CARD PAYMENTS  **         
A02798*                       ALONG WITH CHECK PAYMENTS TO PROCESS   **         
A02798*                       REFUNDS WITH 'HOLD TIME' DELINQUENCY   **         
A02798*                       DAYS FROM DELINQUENCY TABLE.           **         
A02845*   02/28/11  NC94746   ACT0001:REFUND PROCESS SHOULD VALIDATE **         
A02845*                       BILL ROW OF LPC DATE '00-DAY, FB DATE  **         
A02845*                       '30-DAY' AND '60-DAY'.                 **         
A02845*   09/14/11  SV95326   GET THE DATA DATE_CASH_REPORT FROM     **         
A02845*                       CSS_AR_TRANS_HIST AND CHECK THIS VALUE.**         
A03707*   10/10/11  VP43661   CHANGES TO PROCESS ENERGYWISE REBATES  **         
A03707*                       - INSERT REFUNDS WITH 'APPROVED' STATUS**         
A03707*                       - CHANGE CONTRACT STATUS TO 'PAID'     **         
A03707*                       - PCSCA691 WRITES APPROPRIATE JRNLS    **         
A03707*   10/28/11  VP43661   - POPULATING DATE_REFUNDED FOR ENERGY- **         
A03707*                         WISE REBATE REFUNDS.                 **         
A03707*   12/15/11  VP43661   - FIXED ISSUE WITH CDP UPDATE          **         
ACT015*   12/20/13  SS7F226   - REPLACE CSS_WQ_ITEMS_MF WITH         **         
ACT015*             A04860      CSS_WQ_ITEMS BY CALLING SCSCB077     **         
ACT015*             A04860      AND REMOVED UNUSED CODE AND COPYBOOKS**         
ACT015*   03/27/13  MR7E794   - FIXED FOR WQ MESSAGE JUNK ISSUE.     **         
ACT015*             A04860                                           **         
ACT060*   03/11/15  VIJAY     - EXCLUDE SR AGL CREDITS FROM AUTO RE- **         
ACT060*             A05136      FUNDS                                **         
A05460*   03/16/15  DB41297   - REMOVE REFERENCE TO CSS_ACCT_ATTRIBUTE          
ACT092*                                                              **         
      ***************************************************************** 00271000
      **          ---- BASIC SEQUENCE STRUCTURE ----                 ** 00280000
      **                                                             ** 00290000
      **  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION          ** 00300000
      **  1000 - 1999  INPUT PROCESSING CONTROL PATH                 ** 00310000
      **  2000 - 4999  OUTPUT PROCESSING CONTROL PATH                ** 00320000
      **  5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES            ** 00330000
      **  6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)  ** 00340000
      **  7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.)** 00350000
      **  8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC.)* 00360000
      **  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES         ** 00370000
      **                                                             ** 00380000
      ***************************************************************** 00390000
                                                                        
      /                                                                 00410000
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      /                                                                 00510000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA200'.
MSQ017     COPY MFASQLM.
       01  WS-START                   PIC X(40)                         
           VALUE 'WORKING STORAGE FOR PCSCA200 STARTS HERE'.            
       01  WS-ADJ-DAY                 PIC S9(9) COMP.                   
       01  WS-WORK-DATE               PIC X(10).                        
       01  WS-WORK-DAY-TABLE.                                           
           03  WS-WORK-DAY-LIST                                         
T30752            OCCURS 500 TIMES                                      
                  ASCENDING KEY WS-WORK-DAY                             
                  INDEXED BY WD-INDX.                                   
               05  WS-WORK-DAY        PIC X(10).                        
                                                                        
                                                                        
      /*****************************************************************00580000
      *   TABLE DECLARATIONS GO AFTER OTHER WORKING STORAGE ITEMS      *00590000
      *   (IF DIRECT ACCESS TO DB2 TABLES IS ALLOWED). FIRST ITEM      *00600000
      *   WILL ALWAYS BE SQLCA.                                        *00610000
      ******************************************************************00620000
      /***** SQL COMMUNICATIONS AREA                                    00630000
           EXEC SQL                                                     00640000
               INCLUDE SQLCA                                            00650000
           END-EXEC.                                                    00660000
                                                                        
      /***** CSS_ACCOUNT                                                00680000
           EXEC SQL                                                     00690000
               INCLUDE TBACCT                                           00700000
           END-EXEC.                                                    00710000
                                                                        
      /***** CSS_AR_CNTL                                                00730000
           EXEC SQL                                                     00740000
               INCLUDE TBARCNTL                                         00750000
           END-EXEC.                                                    00760000
                                                                        
      /***** CSS_AR_TRANS_HIST                                          00780000
           EXEC SQL                                                     00790000
               INCLUDE TBARHIST                                         00800000
           END-EXEC.                                                    00810000
                                                                        
      /***** CSS_AR_TRN_HST_DET                                         00830000
           EXEC SQL                                                     00840000
               INCLUDE TBARHDT                                          00850000
           END-EXEC.                                                    00860000
                                                                        
      /***** CSS_CHRG_OFF                                                       
           EXEC SQL                                                             
               INCLUDE TBCHGOFF                                                 
           END-EXEC.                                                            
                                                                        
      /***** CSS_CONTRACT - CT                                                  
           EXEC SQL                                                     05310000
              INCLUDE TBCNTRCT                                          05320000
           END-EXEC.                                                    05330000
                                                                        
      /***** CSS_DELINQUENCY                                                    
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
                                                                        
      /***** CSS_JOB_PARM                                               00830000
           EXEC SQL                                                     00840000
               INCLUDE TBJBPARM                                         00850000
           END-EXEC.                                                    00860000
                                                                        
      /***** CSS_MNT_TRANS_HIST                                         00780000
           EXEC SQL                                                             
               INCLUDE TBMNHIST                                                 
           END-EXEC.                                                            
                                                                        
      /***** CSS_MT_TRN_HST_DET                                         00780000
           EXEC SQL                                                             
               INCLUDE TBMNHDT                                                  
           END-EXEC.                                                            
                                                                        
      /***** CSS_MODEL_SQL                                              01480000
           EXEC SQL                                                     01490000
               INCLUDE TBMODEL                                          01500000
           END-EXEC.                                                    01510000
                                                                        
      /***** CSS_REFUND                                                 00930000
           EXEC SQL                                                     00940000
               INCLUDE TBREFUND                                         00950000
           END-EXEC.                                                    00960000
      *                                                                         
       01  WS-CONSTANTS.                                                
           05  WS-PAYMENT                  PIC X(01)   VALUE 'P'.       
           05  WS-CHECK                    PIC X(01)   VALUE 'C'.       
A02798     05  WS-CREDIT-CARD              PIC X(01)   VALUE 'H'.       
A00557     05  WS-CANCEL                   PIC X(01)   VALUE 'C'.       
           05  WS-S                        PIC X(01)   VALUE 'S'.       
           05  WS-811                      PIC S9(9) VALUE -811 COMP.   
ACT015     05  RS-RETURN-CODE              PIC S9(09)  COMP VALUE +0.   
           05  WS-REQUESTED                PIC X(01)   VALUE 'R'.       
A03707     05  WS-APPROVED                 PIC X(01)   VALUE 'A'.       
           05  WS-FINAL                    PIC X(01)   VALUE 'B'.       
           05  WS-CHARGE-OFF               PIC X(01)   VALUE 'S'.       
           05  WS-ACTIVE                   PIC X(01)   VALUE 'A'.       
           05  WS-YES                      PIC X(01)   VALUE 'Y'.       
           05  WS-NO                       PIC X(01)   VALUE 'N'.       
           05  WS-PGRMNAME                 PIC X(08)   VALUE 'PCSCA200'.
           05  WS-LAST-PYMT-DATE           PIC X(04)   VALUE 'LPD '.    
           05  WS-SLASH                    PIC X(01)   VALUE '/'.       
           05  WS-SEMI                     PIC X(02)   VALUE '; '.      
           05  WS-BILL-EXCEPT-Y-MSG        PIC X(17)                    
                                           VALUE 'BILL EXCEPTION: Y'.   
           05  WS-BILL-EXCEPT-N-MSG        PIC X(17)                    
                                           VALUE 'BILL EXCEPTION: N'.   
           05  WS-MULT-ACCT-Y-MSG          PIC X(12)                    
                                           VALUE 'MULT ACCT: Y'.        
           05  WS-MULT-ACCT-N-MSG          PIC X(12)                    
                                           VALUE 'MULT ACCT: N'.        
           05  WS-BANKRUPTCY-Y-MSG         PIC X(13)                    
                                           VALUE 'BANKRUPTCY: Y'.       
           05  WS-BANKRUPTCY-N-MSG         PIC X(13)                    
                                           VALUE 'BANKRUPTCY: N'.       
           05  WS-DOLLARS-IN-AR-MSG        PIC X(46)                    
               VALUE 'ACCT HAS OTHER DOLLARS IN AR.  REVIEW MANUALLY'.  
           05  WS-CIA                      PIC X(01)   VALUE 'N'.       
           05  WS-CANCEL-REBILL            PIC  X(01)  VALUE 'N'.       
           05  WS-AUTOMATE-REFUND-SW       PIC  X(01)  VALUE 'N'.       
               88  AUTOMATE-REFUND                     VALUE 'Y'.       
A03707     05  S-RETURN-CODE               PIC S9(04)  COMP.            
A03707     05  WS-NO-OF-CONTRACTS          PIC S9(9)   COMP VALUE 0.    
A03707     05  WS-NULL-INDICATOR-1         PIC S9(04) USAGE COMP.       
           05  RS-RETURN-CODE-DISP         PIC +Z(04).                  
           05  WS-END-OF-DATA-FLAG         PIC  X(01)  VALUE 'N'.       
               88  END-OF-DATA                         VALUE 'Y'.       
T30175                                                                  
T30175     05  WS-DATABASE                     PIC 9(01) VALUE ZERO.    
T30175         88  CSR-DATABASE                          VALUE 1.       
T30175         88  SEB-DATABASE                          VALUE 2.       
                                                                        
       01  WS-COUNTERS.                                                 
           05  WS-BILL-EXCEPT-COUNT    PIC S9(09) COMP.                 
           05  WS-DEL-WORK-AREA        PIC S9(3)  COMP-3 VALUE ZERO.    
           05  WS-REF-TRANS            PIC S9(3)  COMP-3 VALUE ZERO.    
           05  WS-REF-CTR              PIC S9(3)  COMP-3 VALUE ZERO.    
           05  WS-CHRG-OFF-AMT         PIC S9(11)V9(2) COMP-3 VALUE 0.  
           05  WS-PAR-NULL-IND         PIC S9(04) COMP   VALUE +0.      
                                                                        
       01  WS-FLAGS.                                                    
           05  WS-CODE-MULT-ACCT           PIC X   VALUE 'N'.           
           05  WS-DATE-FLAG                PIC X   VALUE 'N'.           
           05  WS-DOLLARS-IN-AR            PIC X   VALUE 'N'.           
           05  WS-TRANSFER-DONE            PIC X   VALUE 'N'.           
           05  WS-FOUND                    PIC X   VALUE 'N'.           
                                                                        
       01  WS-TEMP-VARIABLES.                                           
           05  WS-AMT-REFUND              PIC $$$$$9.99.                
           05  WS-PYMT-TYPE               PIC X(02).                    
           05  WS-PYMT-DATE              PIC X(10).                     
           05  WS-CURRENT-DATE           PIC X(10).                     
ACT015     05  WS-CURRENT-DATE-REF       PIC X(16)                      
ACT015                                   VALUE '-00.00.00.000000'.      
ACT015     05  WS-CURRENT-DATE-26        PIC X(26) VALUE SPACES.        
A03707     05  WS-CURRENT-TIMESTAMP      PIC X(26).                     
           05  WS-NEXT-DATE              PIC X(10).                     
           05  WS-RELEASE-DATE           PIC X(10).                     
           05  WS-DEL-WORK-DATE          PIC X(10).                     
           05  WS-DELINQUENCY-DATE       PIC X(10).                     
           05  WS-25-DAYS-AGO            PIC X(10).                     
T22962     05  WS-AMT-UNUSED-CR          PIC S9(09)V99 COMP-3 VALUE 0.  
           05  WS-AMT-00-DAY             PIC S9(09)V99 COMP-3 VALUE 0.  
           05  WS-AMT-30-DAY             PIC S9(09)V99 COMP-3 VALUE 0.  
           05  WS-AMT-60-DAY             PIC S9(09)V99 COMP-3 VALUE 0.  
           05  WS-AMT-90-DAY             PIC S9(09)V99 COMP-3 VALUE 0.  
           05  WS-AMT-00-NULL-IND        PIC S9(04) COMP VALUE +0.      
           05  WS-AMT-30-NULL-IND        PIC S9(04) COMP VALUE +0.      
           05  WS-AMT-60-NULL-IND        PIC S9(04) COMP VALUE +0.      
           05  WS-AMT-90-NULL-IND        PIC S9(04) COMP VALUE +0.      
           05  WS-DT-00-NULL-IND         PIC S9(04) COMP VALUE +0.      
           05  WS-DT-30-NULL-IND         PIC S9(04) COMP VALUE +0.      
           05  WS-DT-60-NULL-IND         PIC S9(04) COMP VALUE +0.      
           05  WS-DT-90-NULL-IND         PIC S9(04) COMP VALUE +0.      
           05  WS-REFUND-NULL            PIC S9(04) COMP VALUE +0.      
           05  WS-DATE-TRANS-NI          PIC S9(04) COMP VALUE +0.      
           05  WS-DATE-TRANS-NULL        PIC S9(04) COMP VALUE +0.      
           05  WS-LAST-PYMT-DATE-NI      PIC S9(04) COMP VALUE 0.       
           05  WS-2-CYCLES-FROM-NOW      PIC X(10).                     
           05  WS-ACCOUNT-NO             PIC 9(13).                     
           05  WS-CUSTOMER-NO            PIC 9(10).                     
           05  WS-LOCAL-OFFICE           PIC X(3).                      
           05  WS-BANKRUPTCY-IND         PIC X(1).                      
           05  WS-COMPANY-NO             PIC X(2).                      
A02845     05  WS-DATE-BILL-DAY-00       PIC X(10) VALUE SPACES.        
A02845     05  WS-DATE-BILL-DAY-30       PIC X(10) VALUE SPACES.        
A02845     05  WS-DATE-BILL-DAY-60       PIC X(10) VALUE SPACES.        
A02845     05  WS-MAX-AR-DATE-TRANS      PIC X(10) VALUE SPACES.        
A02845     05  WS-TFR-AR-DATE-TRANS      PIC X(10) VALUE SPACES.        
                                                                        
       01  WS-SWITCHES-AND-INDICATORS.                                  
           05  WS-REVIEW-REQUIRED          PIC X(01).                   
               88  REVIEW-REQUIRED         VALUE 'Y'.                   
               88  REVIEW-NOT-REQUIRED     VALUE 'N'.                   
                                                                        
       01  WS-WQ-MESSAGE-DATA.                                          
           05  WS-MSG-PART-1                PIC X(20) VALUE SPACES.     
           05  WS-MSG-PART-2                PIC X(20) VALUE SPACES.     
           05  WS-MSG-PART-3                PIC X(20) VALUE SPACES.     
           05  WS-MSG-PART-4                PIC X(20) VALUE SPACES.     
           05  WS-MSG-PART-5                PIC X(20) VALUE SPACES.     
           05  WS-MSG-PART-6                PIC X(20) VALUE SPACES.     
           05  WS-MSG-PART-7                PIC X(47) VALUE SPACES.     
           05  WS-MSG-PART-8                PIC X(47) VALUE SPACES.     
           05  WS-FINAL-REVIEW.                                         
               10  WS-WQ-CATEGORY          PIC S9(4)  COMP VALUE +0.    
               10  FILLER                  PIC X(01)  VALUE 'N'.        
               10  FILLER                  PIC X(01)  VALUE '4'.        
               10  WS-REVIEW-TEXT-LENGTH   PIC S9(4)  COMP.             
ACT015         10  WS-REVIEW-TEXT-MSG      PIC X(167) VALUE SPACES.     
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME                PIC X(08)  VALUE 'PCSCA200'. 
ACT015     05  SCSCB077                    PIC X(08)  VALUE 'SCSCB077'. 
           05  WS-SAVE-FWK03-KEY           PIC X(43)  VALUE SPACES.     
           05  WS-SAVE-FWK03-SEQ-NO        PIC 9(04)  VALUE ZERO.       
A00557     05  WS-CANCEL-COMMENTS          PIC X(40)   VALUE            
A00557         'SYSTEM CANCELLED TO ISSUE ANOTHER REFUND'.              
A03707*                                                                 03630000
A03707 01  WS-MNT-TRANS-HIST.                                           
A03707     05 WS-APPL-PROGRAM-ID          PIC X(09)  VALUE SPACES.      
A03707     05 WS-TRAN-COMMENT-TEXT        PIC X(210).                   
A03707     05 WS-TRAN-COMMENT-LEN         PIC S9(04) COMP.              
A03707*                                                                 03630000
A03707 01  WS-MNT-TRANS-DET.                                            
A03707     05  WS-TABLE-ID                PIC X(02).                    
A03707     05  WS-TRAN-APPL-NO            PIC S9(02)  VALUE 0.          
A03707     05  WS-COLUMN-DESC             PIC X(15).                    
A03707     05  WS-CHG-COLUMN-VALUE-TEXT   PIC X(30).                    
A03707     05  WS-CHG-COLUMN-VALUE-LEN    PIC S9(02).                   
A03707     05  WS-PRV-COLUMN-VALUE-TEXT   PIC X(30).                    
A03707     05  WS-PRV-COLUMN-VALUE-LEN    PIC S9(02).                   
A03707*                                                                         
      /*****************************************************************03640000
      *                                                                *03650000
      *  WORKING STORAGE COPY BOOKS FOLLOW ALL PROGRAM WS              *03660000
      *                                                                *03670000
      ******************************************************************03680000
                                                                        
      /*****   SQL WORK VARIABLES                                       03690000
       COPY CWS00303.                                                   03700000
                                                                        
      /*****   WQ WORKING STORAGE                                       03720000
       COPY CWS0070B.                                                   03730000
                                                                        
       COPY CWS00027.                                                   03750000
                                                                        
      /*****   AT-CODES-DATA-PRESENT WORKING STORAGE                    03761000
       COPY CWS00056.                                                   03762000
                                                                        
      /***** WORKING STORAGE FOR PAYMENT JOURNAL                        03790000
       COPY CJF00101.                                                   03800000
       COPY CWS09900.                                                   03763000
       COPY CWS00010.                                                           
                                                                        
       COPY FIOJC01.                                                    03800000
       COPY FIOCA00.                                                    03800000
                                                                        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CWS00038                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CWS00039                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     03820000
               INCLUDE CWS00013                                         03830000
           END-EXEC.                                                    03840000
ACT015*                                                                         
ACT015/***** FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077              
ACT015     EXEC SQL                                                             
ACT015          INCLUDE CWS00077                                                
ACT015     END-EXEC.                                                            
ACT015                                                                  
                                                                        
       01  WS-END                          PIC X(40)                    
           VALUE 'DB2 INCLUDES FOR PCSCA200 START HERE '.               
                                                                        
      ******************************************************************04120000
      **  CURSOR DECLARATIONS                                          *04130000
      ******************************************************************04140000
           EXEC SQL                                                     
                DECLARE FINALED_ACCT CURSOR FOR                         
                 SELECT DISTINCT                                        
                        AT.ACCOUNT_NO,                                  
                        AT.CUSTOMER_NO,                                 
                        AT.BILL_CYCLE,                                  
                        AT.COMPANY_NO,                                  
                        AT.LOCAL_OFFICE,                                
                        AT.ADDRESS_ID,                                  
                        AT.TOTAL_AR_BALANCE,                            
                        REPLACE(REPLACE(CONVERT(CHAR(26), 
           AT.ACCT_FINALED_DT, 121), ' ', '-'), ':', '.') 
           ACCT_FINALED_DT,                             
                        AT.LAST_PYMT_DATE,                              
                        AT.LAST_PYMT_AMOUNT,                            
                        AT.ADDRESS_FORMAT,                              
                        AT.BANKRUPTCY_IND,                              
                        AT.CREDIT_GROUP,                                
T22962                  AT.CODES_DATA_PRESENT,                          
A02845                  COALESCE(AT.DATE_BILL_DAY_00, 
              IIF(TRY_CONVERT(DATE, '2099-12-31'
              ) IS NULL OR (PATINDEX('%.%', '2099-12-31'
              ) <> 0) OR (LEN('2099-12-31') <> 10), CIS.CHAR2DATE(
              '2099-12-31'), CONVERT(DATE, '2099-12-31') )),    
A02845                  COALESCE(AT.DATE_BILL_DAY_30, 
              IIF(TRY_CONVERT(DATE, '2099-12-31'
              ) IS NULL OR (PATINDEX('%.%', '2099-12-31'
              ) <> 0) OR (LEN('2099-12-31') <> 10), CIS.CHAR2DATE(
              '2099-12-31'), CONVERT(DATE, '2099-12-31') )),    
A02845                  COALESCE(AT.DATE_BILL_DAY_60, 
              IIF(TRY_CONVERT(DATE, '2099-12-31'
              ) IS NULL OR (PATINDEX('%.%', '2099-12-31'
              ) <> 0) OR (LEN('2099-12-31') <> 10), CIS.CHAR2DATE(
              '2099-12-31'), CONVERT(DATE, '2099-12-31') ))     
                   FROM CSS_ACCOUNT AT                                  
T22962            WHERE AT.CODE_ACCT_STAT = 'B'                         
                    AND AT.ACCT_FINALED_DT IS NOT NULL                  
                    AND AT.TOTAL_AR_BALANCE < :C8-DELINQ-VALUE          
T22962              AND NOT EXISTS                                      
T22962                  (SELECT 1                                       
T22962                     FROM CSS_REFUND RN                           
T22962                    WHERE RN.ACCOUNT_NO = AT.ACCOUNT_NO           
T22962                      AND AT.TOTAL_AR_BALANCE =                   
T22962                                       RN.AMT_REFUNDED * -1       
T22962                      AND RN.CHECK_STATUS_CD = 'R')               
ACT060         ORDER BY AT.ACCOUNT_NO                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     04150000
MFA-TR*         DECLARE FINALED_ACCT CURSOR FOR                         04160000
MFA-TR*          SELECT DISTINCT                                        04170000
MFA-TR*                 AT.ACCOUNT_NO,                                  04170000
MFA-TR*                 AT.CUSTOMER_NO,                                 12670000
MFA-TR*                 AT.BILL_CYCLE,                                  12670000
MFA-TR*                 AT.COMPANY_NO,                                  04180000
MFA-TR*                 AT.LOCAL_OFFICE,                                04181000
MFA-TR*                 AT.ADDRESS_ID,                                  04190000
MFA-TR*                 AT.TOTAL_AR_BALANCE,                            04200000
MFA-TR*                 AT.ACCT_FINALED_DT,                             04210000
MFA-TR*                 AT.LAST_PYMT_DATE,                              04220000
MFA-TR*                 AT.LAST_PYMT_AMOUNT,                            04220000
MFA-TR*                 AT.ADDRESS_FORMAT,                              04220000
MFA-TR*                 AT.BANKRUPTCY_IND,                              04220000
MFA-TR*                 AT.CREDIT_GROUP,                                04220000
MFA-TR*                 AT.CODES_DATA_PRESENT,                          04220000
MFA-TR*                 COALESCE(AT.DATE_BILL_DAY_00, '2099-12-31'),    04220000
MFA-TR*                 COALESCE(AT.DATE_BILL_DAY_30, '2099-12-31'),    04220000
MFA-TR*                 COALESCE(AT.DATE_BILL_DAY_60, '2099-12-31')     04220000
MFA-TR*            FROM CSS_ACCOUNT AT                                  04230000
MFA-TR*           WHERE AT.CODE_ACCT_STAT = 'B'                         04240000
MFA-TR*             AND AT.ACCT_FINALED_DT IS NOT NULL                  04250000
MFA-TR*             AND AT.TOTAL_AR_BALANCE < :C8-DELINQ-VALUE          04260000
MFA-TR*             AND NOT EXISTS                                      04260000
MFA-TR*                 (SELECT 1                                       04260000
MFA-TR*                    FROM CSS_REFUND RN                           04260000
MFA-TR*                   WHERE RN.ACCOUNT_NO = AT.ACCOUNT_NO           04260000
MFA-TR*                     AND AT.TOTAL_AR_BALANCE =                   04260000
MFA-TR*                                      RN.AMT_REFUNDED * -1       04260000
MFA-TR*                     AND RN.CHECK_STATUS_CD = 'R')               04260000
MFA-TR*        ORDER BY AT.ACCOUNT_NO                                   04240000
MFA-TR*    END-EXEC.                                                    04290000
                                                                        
           EXEC SQL                                                     
                DECLARE ACCOUNT CURSOR FOR                              
                 SELECT ACCOUNT_NO,                                     
                        PREMISE_NO,                                     
                        CUSTOMER_NO,                                    
                        COMPANY_NO,                                     
                        CODE_ACCT_STAT,                                 
                        LOCAL_OFFICE,                                   
                        DATE_BILL_DAY_00,                               
                        DATE_BILL_DAY_30,                               
                        DATE_BILL_DAY_60,                               
                        DATE_BILL_DAY_90                                
                   FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                       
                  WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                   
                    AND ACCOUNT_NO <> :AT-ACCOUNT-NO                    
                    AND (CODE_ACCT_STAT = :WS-CHARGE-OFF                
                     OR  CODE_ACCT_STAT = :WS-ACTIVE                    
                     OR  CODE_ACCT_STAT = :WS-FINAL)                    
A02798            FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04150000
MFA-TR*         DECLARE ACCOUNT CURSOR FOR                              04160000
MFA-TR*          SELECT ACCOUNT_NO,                                     04170000
MFA-TR*                 PREMISE_NO,                                     04170000
MFA-TR*                 CUSTOMER_NO,                                    12670000
MFA-TR*                 COMPANY_NO,                                     12670000
MFA-TR*                 CODE_ACCT_STAT,                                 04180000
MFA-TR*                 LOCAL_OFFICE,                                   04181000
MFA-TR*                 DATE_BILL_DAY_00,                               04190000
MFA-TR*                 DATE_BILL_DAY_30,                               04200000
MFA-TR*                 DATE_BILL_DAY_60,                               04210000
MFA-TR*                 DATE_BILL_DAY_90                                04220000
MFA-TR*            FROM CSS_ACCOUNT                                     04230000
MFA-TR*           WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                   04240000
MFA-TR*             AND ACCOUNT_NO <> :AT-ACCOUNT-NO                    04250000
MFA-TR*             AND (CODE_ACCT_STAT = :WS-CHARGE-OFF                04260000
MFA-TR*              OR  CODE_ACCT_STAT = :WS-ACTIVE                    04280000
MFA-TR*              OR  CODE_ACCT_STAT = :WS-FINAL)                    04281000
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                    04290000
                                                                        
           EXEC SQL                                                     
                DECLARE CANCEL_REBILL CURSOR FOR                        
                 SELECT 'Y'                                             
                   FROM CSS_AR_TRANS_HIST A WITH(READUNCOMMITTED),              
                        CSS_MNT_TRANS_HIST B WITH(READUNCOMMITTED),             
                        CSS_ACCOUNT C WITH(READUNCOMMITTED)                     
                  WHERE A.ACCOUNT_NO = :AT-ACCOUNT-NO                   
                    AND A.ACCOUNT_NO = B.ACCOUNT_NO                     
                    AND A.ACCOUNT_NO = C.ACCOUNT_NO                     
                    AND C.CODE_ACCT_STAT = 'B'                          
                    AND A.CODE_TRAN_TYPE = 'B'                          
                    AND A.APPL_PROGRAM_ID = 'PCSCA10F'                  
                    AND A.DATE_TRANS <                                  
                        (SELECT MAX(DATE_TRANS)                         
                           FROM CSS_MNT_TRANS_HIST D
                           WITH(READUNCOMMITTED)                    
                          WHERE A.ACCOUNT_NO = D.ACCOUNT_NO             
                            AND APPL_PROGRAM_ID = 'PANEL321')           
A02798            FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04150000
MFA-TR*         DECLARE CANCEL_REBILL CURSOR FOR                        04160000
MFA-TR*          SELECT 'Y'                                             04170000
MFA-TR*            FROM CSS_AR_TRANS_HIST A,                            04230000
MFA-TR*                 CSS_MNT_TRANS_HIST B,                           04240000
MFA-TR*                 CSS_ACCOUNT C                                   04250000
MFA-TR*           WHERE A.ACCOUNT_NO = :AT-ACCOUNT-NO                   04260000
MFA-TR*             AND A.ACCOUNT_NO = B.ACCOUNT_NO                     04280000
MFA-TR*             AND A.ACCOUNT_NO = C.ACCOUNT_NO                     04280000
MFA-TR*             AND C.CODE_ACCT_STAT = 'B'                          04281000
MFA-TR*             AND A.CODE_TRAN_TYPE = 'B'                          04281000
MFA-TR*             AND A.APPL_PROGRAM_ID = 'PCSCA10F'                  04281000
MFA-TR*             AND A.DATE_TRANS <                                  04281000
MFA-TR*                 (SELECT MAX(DATE_TRANS)                         04281000
MFA-TR*                    FROM CSS_MNT_TRANS_HIST D                            
MFA-TR*                   WHERE A.ACCOUNT_NO = D.ACCOUNT_NO                     
MFA-TR*                     AND APPL_PROGRAM_ID = 'PANEL321')                   
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                    04290000
                                                                        
           EXEC SQL                                                     
           DECLARE CREDIT_IN_ADVANCE CURSOR FOR                         
           SELECT DISTINCT AMT_UNUSED_CR                                
             FROM CSS_AR_CNTL                                           
            WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                           
              AND PYMT_PRIORITY_LVL = 70                                
              AND ITEM_ID <> 2                                          
           END-EXEC.                                                    
A03707*                                                                         
A03707******************************************************************04120000
A03707* SELECT ACTIVE ONE-TIME ENERGYWISE REBATE CONTRACTS             *04130000
A03707******************************************************************04140000
A03707*                                                                         
A03707     EXEC SQL                                                     
A03707     DECLARE EW_REBATE_CNT CURSOR FOR                             
A03707     SELECT                                                       
A03707            AT.ACCOUNT_NO                                         
A03707           ,AT.LOCAL_OFFICE                                       
A03707           ,AT.CODES_DATA_PRESENT                                 
A03707           ,CT.CNT_ITEM_ID                                        
A03707           ,CT.AMT_ORIG_ENTERED                                   
A03707       FROM                                                       
A03707            CSS_ACCOUNT  AT WITH(READUNCOMMITTED)                         
A03707           ,CSS_CONTRACT CT WITH(READUNCOMMITTED)                         
A03707      WHERE                                                       
A03707            CT.PYMT_PRIORITY_LVL  = 100                           
A03707        AND CT.ACCOUNT_NO         = AT.ACCOUNT_NO                 
A03707        AND CT.CNT_STATUS_CD      = 'B'                           
A03707        AND CT.CODE_CONTRACT_TYPE = 'R'                           
A03707        AND CT.AMT_ORIG_ENTERED   > 0                             
A03707                                                           
A03707                                                      
A03707     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*    DECLARE EW_REBATE_CNT CURSOR FOR                                     
MFA-TR*    SELECT                                                               
MFA-TR*           AT.ACCOUNT_NO                                         04181000
MFA-TR*          ,AT.LOCAL_OFFICE                                       04181000
MFA-TR*          ,AT.CODES_DATA_PRESENT                                 04181000
MFA-TR*          ,CT.CNT_ITEM_ID                                                
MFA-TR*          ,CT.AMT_ORIG_ENTERED                                           
MFA-TR*      FROM                                                               
MFA-TR*           CSS_ACCOUNT  AT                                               
MFA-TR*          ,CSS_CONTRACT CT                                               
MFA-TR*     WHERE                                                               
MFA-TR*           CT.PYMT_PRIORITY_LVL  = 100                                   
MFA-TR*       AND CT.ACCOUNT_NO         = AT.ACCOUNT_NO                 04240000
MFA-TR*       AND CT.CNT_STATUS_CD      = 'B'                                   
MFA-TR*       AND CT.CODE_CONTRACT_TYPE = 'R'                                   
MFA-TR*       AND CT.AMT_ORIG_ENTERED   > 0                                     
MFA-TR*      WITH UR                                                            
MFA-TR*   QUERYNO 7001                                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************04580000
      **                                                              **04590000
      **    0000-MAINLINE                                             **04600000
      **                                                              **04610000
      ******************************************************************04620000
      *                                                                         
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
                                                                        
           PERFORM 1000-CREATE-REFUND THRU 1000-EXIT                    
               UNTIL END-OF-DATA.                                       
                                                                        
           PERFORM 2000-CREATE-EW-REFUND THRU 2000-EXIT.                
                                                                        
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **   0100-INITIALIZATION                                       **         
      **                                                             **         
      **   OPEN FILES AND INITIALIZES FIELDS.                        **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       0100-INITIALIZATION.                                             
                                                                        
           INITIALIZE WS-WORK-DAY-TABLE.                                
           MOVE ZERO TO RETURN-CODE.                                    
           MOVE LOW-VALUES TO AR-DATE-TRANS.                            
           MOVE SPACES TO WS-PYMT-TYPE                                  
           MOVE SPACES TO WS-PYMT-DATE.                                 
           MOVE ZEROS TO WS-DEL-WORK-AREA.                              
                                                                        
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
                                                                        
           IF COMMON-DATE-NEEDED                                        
T22962        MOVE 'COMMON  ' TO WS-PGRMNAME                            
T22962        MOVE SPACES TO WS-INPUT-AREA                              
T22962        MOVE SPACES TO WS-INPUT-DATA-BREAKDOWN                    
T22962        PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT                
T22962*       PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT                 
T22962*       MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE                        
           END-IF.                                                      
                                                                        
           MOVE WS-INPUT-DATE TO WS-CURRENT-DATE.                       
                                                                        
T30175     MOVE ZERO       TO WS-DATABASE.                              
T30175     MOVE 'DATABASE' TO C8-DELINQ-CD.                             
T30175     PERFORM 0110-SELECT-CSS-DELINQUENCY THRU 0110-EXIT.          
T30175     MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
                                                                        
T30175     MOVE 'AMT-RPT-FINALLED-ACC' TO C8-DELINQ-CD.                 
           PERFORM 0110-SELECT-CSS-DELINQUENCY THRU 0110-EXIT.          
                                                                        
           PERFORM 0120-LOAD-WORK-DAYS THRU 0120-EXIT.                  
                                                                        
           PERFORM 0130-OPEN-FINALED-ACCT THRU 0130-EXIT.               
           PERFORM 0140-FETCH-FINALED-ACCT THRU 0140-EXIT.              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              DISPLAY '** PCSCA200  PROCESSING ERROR  **'               
              DISPLAY '** NO FINALED ACCOUNTS WITH    **'               
              DISPLAY '**    CREDIT BALANCE        **'                  
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **   0110-SELECT-CSS-DELINQUENCY.                              **         
      **                                                             **         
      **   SELECT AMT RPT FINALLED ACCT                              **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       0110-SELECT-CSS-DELINQUENCY.                                     
T30175* COMMENTED NEXT LINE AND MOVED IT IN INTIALIZATION PARA                  
T30175* TO MAKE  THIS PARA GENERIC AND RE-USABLE                                
T30175*    MOVE 'AMT-RPT-FINALLED-ACC' TO C8-DELINQ-CD                          
                                                                        
           EXEC SQL                                                     
              SELECT C8.DELINQ_VALUE                                    
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                   
               WHERE C8.DELINQ_CD = :C8-DELINQ-CD                       
                 AND C8.COMPANY_NO = '01'                               
A02798                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT C8.DELINQ_VALUE                                            
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY C8                                         
MFA-TR*        WHERE C8.DELINQ_CD = :C8-DELINQ-CD                               
MFA-TR*          AND C8.COMPANY_NO = '01'                                       
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE 'C8'                TO WS-DB2-TABLE-ID               
              MOVE 'SELECT'            TO WS-DB2-FUNCTION               
              MOVE SQLCODE             TO WS-DB2-RETURN-CODE            
              MOVE '200'               TO WS-DB2-MODULE-ID              
              MOVE '0110'              TO WS-DB2-PARAGRAPH              
              MOVE C8-DELINQ-CD        TO WS-DB2-KEY-1                  
              MOVE 12                  TO RETURN-CODE                   
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **   0120-LOAD-WORK-DAYS.                                      **         
      **                                                             **         
      **   LOADS THE WS-WORK-DAY-TABLE.                              **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       0120-LOAD-WORK-DAYS.                                             
                                                                        
           MOVE WS-CURRENT-DATE TO WS-WORK-DAY(101)                     
           MOVE 1 TO WS-ADJ-DAY                                         
           SET WD-INDX TO 100                                           
           PERFORM UNTIL WD-INDX < 1 OR WS-ADJ-DAY > 180                
              PERFORM 0121-GET-PREV-WORK-DAYS THRU 0121-EXIT            
              EVALUATE SQLCODE                                          
                  WHEN SUCCESSFUL-CALL                                  
                       MOVE WS-WORK-DATE TO WS-WORK-DAY (WD-INDX)       
                       ADD 1 TO WS-ADJ-DAY                              
                       SET WD-INDX DOWN BY 1                            
                  WHEN NOT-FOUND                                        
                       ADD 1 TO WS-ADJ-DAY                              
                  WHEN OTHER                                            
                       DISPLAY 'WORK-DATE ERROR'                        
                       SET WD-INDX TO 1                                 
                       SET WD-INDX DOWN BY 1                            
              END-EVALUATE                                              
           END-PERFORM.                                                 
                                                                        
           SET WD-INDX TO 102                                           
           MOVE 1 TO WS-ADJ-DAY                                         
T30752     PERFORM UNTIL WD-INDX > 500 OR WS-ADJ-DAY > 730              
              PERFORM 0150-GET-NEXT-WORK-DAYS THRU 0150-EXIT            
              EVALUATE SQLCODE                                          
                  WHEN SUCCESSFUL-CALL                                  
                       MOVE WS-WORK-DATE TO WS-WORK-DAY (WD-INDX)       
                       ADD 1 TO WS-ADJ-DAY                              
                       SET WD-INDX UP BY 1                              
                  WHEN NOT-FOUND                                        
                       ADD 1 TO WS-ADJ-DAY                              
                  WHEN OTHER                                            
                       DISPLAY 'WORK-DATE ERROR'                        
                       SET WD-INDX TO 200                               
                       SET WD-INDX UP BY 1                              
              END-EVALUATE                                              
           END-PERFORM.                                                 
                                                                        
           MOVE WS-WORK-DAY (76) TO WS-25-DAYS-AGO.                     
           MOVE WS-WORK-DAY (102) TO WS-NEXT-DATE.                      
           MOVE WS-WORK-DAY (103) TO WS-2-CYCLES-FROM-NOW.              
                                                                        
       0120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **   0121-GET-PREV-WORK-DAYS.                                  **         
      **                                                             **         
      **   GETS THE PREVIOUS WORK DAYS' DATES.                       **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       0121-GET-PREV-WORK-DAYS.                                         
                                                                        
           EXEC SQL                                                     
              SELECT DATEADD( DAY, -:WS-ADJ-DAY, IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )          
                INTO :WS-WORK-DATE                                      
                FROM CSS_MODEL_SQL WITH(READUNCOMMITTED)                        
               WHERE CIS.DAYS(DATEADD( DAY, -:WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )) -                      
                        (CIS.DAYS(DATEADD( DAY, -:WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )
               )) / 7 * 7) BETWEEN 1 AND 5    
                 AND NOT EXISTS                                         
                        (SELECT HOLIDAY_DT                              
                           FROM CSS_HOLIDAY WITH(READUNCOMMITTED)               
                          WHERE HOLIDAY_DT =                            
                                DATEADD( DAY, -:WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) ))                  
C25612*                     AND COMPANY_NO = :J8-COMPANY-NO                     
A02798                                                           
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE(:WS-CURRENT-DATE) - :WS-ADJ-DAY DAYS                  
MFA-TR*         INTO :WS-WORK-DATE                                              
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*        WHERE DAYS(DATE(:WS-CURRENT-DATE)                                
MFA-TR*                      - :WS-ADJ-DAY DAYS) -                              
MFA-TR*                 (INTEGER(DAYS(DATE(:WS-CURRENT-DATE)                    
MFA-TR*                - :WS-ADJ-DAY DAYS) / 7) * 7) BETWEEN 1 AND 5            
MFA-TR*          AND NOT EXISTS                                                 
MFA-TR*                 (SELECT HOLIDAY_DT                                      
MFA-TR*                    FROM CSS_HOLIDAY                                     
MFA-TR*                   WHERE HOLIDAY_DT =                                    
MFA-TR*                         DATE(:WS-CURRENT-DATE) -                        
MFA-TR*                              :WS-ADJ-DAY DAYS)                          
MFA-TR*                     AND COMPANY_NO = :J8-COMPANY-NO                     
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0121-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15540000
      ******************************************************************15550000
      **   0130-OPEN-FINALED-ACCT.                                    **15560000
      **                                                              **15570000
      **   OPEN CURSOR FINALED_ACCT TO GET FINALED ACCTS WITH         **15580000
      **   TOTAL_AR_BALANCE < 0                                       **15590000
      **                                                              **15570000
      ******************************************************************15610000
      *                                                                 15540000
       0130-OPEN-FINALED-ACCT.                                          
                                                                        
           EXEC SQL                                                     
              OPEN FINALED_ACCT                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'AT'             TO  WS-DB2-TABLE-ID                 
              MOVE 'OPEN'           TO  WS-DB2-FUNCTION                 
              MOVE SQLCODE          TO  WS-DB2-RETURN-CODE              
              MOVE '200'            TO  WS-DB2-MODULE-ID                
              MOVE '0130'           TO  WS-DB2-PARAGRAPH                
              MOVE AT-ACCOUNT-NO    TO  WS-DB2-KEY-1N                   
              MOVE 12               TO  RETURN-CODE                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       0130-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15540000
      ******************************************************************15550000
      **   0140-FETCH-FINALED-ACCT.                                   **15560000
      **                                                              **15570000
      **   FETCH ROWS FROM CURSOR FINALED_ACCT                        **15580000
      **                                                              **15570000
      ******************************************************************15610000
      *                                                                 15540000
       0140-FETCH-FINALED-ACCT.                                         
                                                                        
           EXEC SQL                                                     
              FETCH FINALED_ACCT INTO                                   
                   :AT-ACCOUNT-NO,                                      
                   :AT-CUSTOMER-NO,                                     
                   :AT-BILL-CYCLE,                                      
                   :AT-COMPANY-NO,                                      
                   :AT-LOCAL-OFFICE,                                    
                   :AT-ADDRESS-ID,                                      
                   :AT-TOTAL-AR-BALANCE,                                
                   :AT-ACCT-FINALED-DT,                                 
                   :AT-LAST-PYMT-DATE :WS-LAST-PYMT-DATE-NI,             
                   :AT-LAST-PYMT-AMOUNT,                                
                   :AT-ADDRESS-FORMAT,                                  
                   :AT-BANKRUPTCY-IND,                                  
                   :AT-CREDIT-GROUP,                                    
T22962             :AT-CODES-DATA-PRESENT,                              
A02845             :WS-DATE-BILL-DAY-00,                                
A02845             :WS-DATE-BILL-DAY-30,                                
A02845             :WS-DATE-BILL-DAY-60                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE AT-ACCOUNT-NO TO WS-ACCOUNT-NO                    
                 MOVE AT-CUSTOMER-NO TO WS-CUSTOMER-NO                  
                 MOVE AT-LOCAL-OFFICE TO WS-LOCAL-OFFICE                
                 MOVE AT-BANKRUPTCY-IND TO WS-BANKRUPTCY-IND            
                 MOVE AT-COMPANY-NO TO WS-COMPANY-NO                    
                 IF WS-LAST-PYMT-DATE-NI < 0                            
                    MOVE SPACES TO AT-LAST-PYMT-DATE                    
                 END-IF                                                 
A02845           MOVE WS-DATE-BILL-DAY-30 TO AT-DATE-BILL-DAY-30        
              ELSE                                                      
                 MOVE 'Y' TO WS-END-OF-DATA-FLAG                        
              END-IF                                                    
           ELSE                                                         
              MOVE 'AT'             TO  WS-DB2-TABLE-ID                 
              MOVE 'FETCH'          TO  WS-DB2-FUNCTION                 
              MOVE SQLCODE          TO  WS-DB2-RETURN-CODE              
              MOVE '200'            TO  WS-DB2-MODULE-ID                
              MOVE '0140'           TO  WS-DB2-PARAGRAPH                
              MOVE AT-ACCOUNT-NO    TO  WS-DB2-KEY-1N                   
              MOVE 12               TO  RETURN-CODE                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       0140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **   0150-GET-NEXT-WORK-DAYS.                                  **         
      **                                                             **         
      **   GETS THE FUTURE WORK DAYS' DATES.                         **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       0150-GET-NEXT-WORK-DAYS.                                         
                                                                        
           EXEC SQL                                                     
              SELECT DATEADD( DAY, :WS-ADJ-DAY, IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )          
                INTO :WS-WORK-DATE                                      
                FROM CSS_MODEL_SQL WITH(READUNCOMMITTED)                        
               WHERE CIS.DAYS(DATEADD( DAY, :WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )) -                      
                        (CIS.DAYS(DATEADD( DAY, :WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE
              ) ) )) / 7 * 7) BETWEEN 1 AND 5    
                 AND NOT EXISTS                                         
                        (SELECT HOLIDAY_DT                              
                           FROM CSS_HOLIDAY WITH(READUNCOMMITTED)               
                          WHERE HOLIDAY_DT =                            
                                DATEADD( DAY, :WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) ))                  
C25612*                     AND COMPANY_NO = :J8-COMPANY-NO                     
A02798                                                           
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE(:WS-CURRENT-DATE) + :WS-ADJ-DAY DAYS                  
MFA-TR*         INTO :WS-WORK-DATE                                              
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*        WHERE DAYS(DATE(:WS-CURRENT-DATE)                                
MFA-TR*                      + :WS-ADJ-DAY DAYS) -                              
MFA-TR*                 (INTEGER(DAYS(DATE(:WS-CURRENT-DATE)                    
MFA-TR*                + :WS-ADJ-DAY DAYS) / 7) * 7) BETWEEN 1 AND 5            
MFA-TR*          AND NOT EXISTS                                                 
MFA-TR*                 (SELECT HOLIDAY_DT                                      
MFA-TR*                    FROM CSS_HOLIDAY                                     
MFA-TR*                   WHERE HOLIDAY_DT =                                    
MFA-TR*                         DATE(:WS-CURRENT-DATE) +                        
MFA-TR*                              :WS-ADJ-DAY DAYS)                          
MFA-TR*                     AND COMPANY_NO = :J8-COMPANY-NO                     
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************04850000
      **                                                              **04860000
      **   1000-CREATE-REFUND.                                        **04870000
      **                                                              **04880000
      **   EVALUATE FINAL ACCOUNTS WITH CREDIT BALANCES.              **04890000
      **                                                              **04880000
      ******************************************************************04960000
      *                                                                         
       1000-CREATE-REFUND.                                              
                                                                        
                                                                        
           PERFORM 1300-CHECK-CANCEL-REBILL THRU 1300-EXIT.             
                                                                        
           IF AUTOMATE-REFUND                                           
T22962        PERFORM 1356-CHECK-FOR-TRANSFER THRU 1356-EXIT            
              IF WS-TRANSFER-DONE = 'N'                                 
                 MOVE SPACES TO WS-DELINQUENCY-DATE                     
                                                                        
                 PERFORM 1400-SELECT-AR-PYMT-DATE-TYPE THRU 1400-EXIT   
                 PERFORM 1500-DELINQUENCY-TABLE-VALUE THRU 1500-EXIT    
                                                                        
                 PERFORM 1600-PROCESS-MULTIPLE-ACCOUNTS THRU 1600-EXIT  
                                                                        
T22962           MOVE WS-AMT-UNUSED-CR TO RN-AMT-REFUNDED               
                                                                        
A02845*          IF AR-DATE-TRANS > WS-DEL-WORK-DATE                            
A02845           IF AR-DATE-CASH-REPORT > WS-DEL-WORK-DATE              
                    MOVE WS-NO TO WS-REVIEW-REQUIRED                    
                    IF WS-DEL-WORK-DATE > SPACES                        
                       MOVE WS-DELINQUENCY-DATE TO WS-RELEASE-DATE      
                    ELSE                                                
                       MOVE WS-2-CYCLES-FROM-NOW TO WS-RELEASE-DATE     
                    END-IF                                              
                 ELSE                                                   
                    MOVE WS-NO TO WS-REVIEW-REQUIRED                    
                    MOVE WS-CURRENT-DATE TO WS-RELEASE-DATE             
                 END-IF                                                 
                                                                        
                 IF WS-BILL-EXCEPT-COUNT > 0                            
                 OR WS-CODE-MULT-ACCT = WS-YES                          
                 OR WS-BANKRUPTCY-IND = WS-B                            
                 OR WS-DOLLARS-IN-AR = WS-YES                           
                    MOVE WS-YES TO WS-REVIEW-REQUIRED                   
A02845*             IF (AR-DATE-TRANS > WS-DEL-WORK-DATE                        
A02845              IF (AR-DATE-CASH-REPORT > WS-DEL-WORK-DATE          
                    AND WS-DEL-WORK-DATE > SPACES)                      
                        MOVE WS-DELINQUENCY-DATE TO WS-RELEASE-DATE     
                    ELSE                                                
                       MOVE WS-2-CYCLES-FROM-NOW TO WS-RELEASE-DATE     
                    END-IF                                              
                                                                        
T30175              IF CSR-DATABASE                                     
                      PERFORM 1700-CREATE-REVIEW-REQUIRED THRU 1700-EXIT
T30175              END-IF                                              
                 ELSE                                                   
                    MOVE WS-NO TO WS-REVIEW-REQUIRED                    
A02845*             IF (AR-DATE-TRANS > WS-DEL-WORK-DATE                        
A02845              IF (AR-DATE-CASH-REPORT > WS-DEL-WORK-DATE          
                    AND WS-DEL-WORK-DATE > SPACES)                      
                        MOVE WS-DELINQUENCY-DATE TO WS-RELEASE-DATE     
                    ELSE                                                
                        MOVE WS-CURRENT-DATE TO WS-RELEASE-DATE         
                    END-IF                                              
                 END-IF                                                 
                                                                        
                 IF RN-AMT-REFUNDED GREATER THAN ZEROES                 
                    MOVE WS-ACCOUNT-NO TO RN-ACCOUNT-NO                 
                    MOVE SPACES TO RN-RETURNED-REASON                   
                    MOVE SPACES TO RN-USER-ID-APPRVD-BY                 
                    MOVE WS-LOCAL-OFFICE TO RN-LOCAL-OFFICE             
                    MOVE 'SYSTEM' TO RN-USER-ID-RQSTED-BY               
                    MOVE ZEROES TO RN-REFUND-CHECK-NO                   
                    MOVE ZEROES TO RN-ORIGINAL-CHECK-NO                 
                                                                        
                    PERFORM 1800-SELECT-MAX-ITEM-ID THRU 1800-EXIT      
                    MOVE ZERO TO RN-DEPOSIT-CERT-NO                     
                    MOVE ZERO TO RN-ADDRESS-ID                          
                    MOVE WS-CURRENT-DATE TO RN-REFUND-STATUS-DT         
                    MOVE WS-RELEASE-DATE TO RN-REQUEST-DT               
                    MOVE WS-REQUESTED TO RN-CHECK-STATUS-CD             
T22962              MOVE 'F' TO RN-CHECK-ISS-REAS-CD                    
                    MOVE WS-S TO RN-MANUAL-INDICATOR                    
                    MOVE 'BILL' TO RN-PANEL-NO                          
A03707              MOVE -1     TO WS-NULL-INDICATOR-1                  
A03707              MOVE SPACES TO RN-DATE-REFUNDED                     
A00557              PERFORM 1910-CANCEL-CSS-REFUND THRU 1910-EXIT       
                    PERFORM 1900-INSERT-CSS-REFUND THRU 1900-EXIT       
T22962              PERFORM 1950-UPDATE-ACCOUNT THRU 1950-EXIT          
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 0140-FETCH-FINALED-ACCT THRU 0140-EXIT.              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
A03707*                                                                 15540000
A03707******************************************************************15550000
A03707**   2000-CREATE-EW-REFUND                                      **15560000
A03707**   PROCESS ENERGYWISE REBATES                                 **04890000
A03707******************************************************************15610000
A03707*                                                                 15540000
A03707 2000-CREATE-EW-REFUND.                                           
A03707*                                                                 15540000
A03707     MOVE 'N'                         TO WS-END-OF-DATA-FLAG.     
A03707     PERFORM 7001-OPEN-EW-REBATE-CNT  THRU 7001-EXIT.             
A03707     PERFORM 7002-FETCH-EW-REBATE-CNT THRU 7002-EXIT.             
A03707*                                                                         
A03707     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
A03707        GO TO 2000-EXIT                                           
A03707     ELSE                                                         
A03707        PERFORM UNTIL END-OF-DATA                                 
A03707           MOVE CT-CNT-ITEM-ID        TO RN-REFUND-ITEM-ID        
A03707           MOVE ZERO                  TO RN-DEPOSIT-CERT-NO       
A03707           MOVE ZEROES                TO RN-REFUND-CHECK-NO       
A03707           MOVE ZEROES                TO RN-ORIGINAL-CHECK-NO     
A03707           MOVE AT-LOCAL-OFFICE       TO RN-LOCAL-OFFICE          
A03707           MOVE CT-AMT-ORIG-ENTERED   TO RN-AMT-REFUNDED          
A03707           MOVE WS-CURRENT-DATE       TO RN-REQUEST-DT            
A03707           MOVE WS-APPROVED           TO RN-CHECK-STATUS-CD       
A03707           MOVE 'ER'                  TO RN-CHECK-ISS-REAS-CD     
A03707           MOVE WS-S                  TO RN-MANUAL-INDICATOR      
A03707           MOVE SPACES                TO RN-RETURNED-REASON       
A03707           MOVE WS-CURRENT-DATE       TO RN-REFUND-STATUS-DT      
A03707           MOVE 'SYSTEM'              TO RN-USER-ID-RQSTED-BY     
A03707           MOVE AT-ACCOUNT-NO         TO RN-ACCOUNT-NO            
A03707           MOVE 'BILL'                TO RN-PANEL-NO              
A03707           MOVE ZERO                  TO RN-ADDRESS-ID            
A03707           MOVE SPACES                TO RN-USER-ID-APPRVD-BY     
A03707           PERFORM 5000-INSERT-REFUND       THRU 5000-EXIT        
A03707           MOVE ZERO                  TO WS-NO-OF-CONTRACTS       
A03707           PERFORM 5010-UPDATE-CONTRACT     THRU 5010-EXIT        
A03707           IF WS-NO-OF-CONTRACTS = 0                              
A03707              MOVE SPACES                TO WS-CODES-DATA-PRESENT 
A03707              MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT 
A03707              MOVE SPACES                TO WS-CODE-CONTRACT      
A03707              MOVE WS-CODES-DATA-PRESENT TO AT-CODES-DATA-PRESENT 
A03707           END-IF                                                 
A03707           PERFORM 1950-UPDATE-ACCOUNT      THRU 1950-EXIT        
A03707           PERFORM 7002-FETCH-EW-REBATE-CNT THRU 7002-EXIT        
A03707        END-PERFORM                                               
A03707     END-IF.                                                      
A03707*                                                                 15540000
A03707 2000-EXIT.                                                       
A03707     EXIT.                                                        
A03707*                                                                 15540000
      ******************************************************************15550000
      **   1300-CHECK-CANCEL-REBILL.                                  **15560000
      **                                                              **15570000
      **   THIS PARAGRAPH CHECKS TO SEE IF A CANCEL REBILL HAS BEEN   **15580000
      **   DONE ON THE ACCOUNT.  IF ONE HAS BEEN DONE, THE ACCOUNT    **15590000
      **   WILL NOT BE SELECTED FOR AN AUTOMATED REFUND.              **15570000
      ******************************************************************15610000
      *                                                                 15540000
       1300-CHECK-CANCEL-REBILL.                                        
                                                                        
           PERFORM 1310-OPEN-CANCEL-REBILL THRU 1310-EXIT.              
           PERFORM 1320-FETCH-CANCEL-REBILL THRU 1320-EXIT.             
           PERFORM 1330-CLOSE-CANCEL-REBILL THRU 1330-EXIT.             
                                                                        
           IF WS-CANCEL-REBILL = 'N'                                    
              PERFORM 1340-CHECK-PYMTS THRU 1340-EXIT                   
           ELSE                                                         
              MOVE 'N' TO WS-AUTOMATE-REFUND-SW                         
              MOVE 'N' TO WS-CANCEL-REBILL                              
           END-IF.                                                      
                                                                        
       1300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **   1310-OPEN-CANCEL-REBILL.                                  **         
      **                                                             ** 15570000
      **   OPEN THE CANCEL_REBILL CURSOR.                            ** 15580000
      **                                                             ** 15570000
      *****************************************************************         
      *                                                                         
       1310-OPEN-CANCEL-REBILL.                                         
                                                                        
           EXEC SQL                                                     
              OPEN CANCEL_REBILL                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'AR'                TO WS-DB2-TABLE-ID               
              MOVE 'OPEN'              TO WS-DB2-FUNCTION               
              MOVE SQLCODE             TO WS-DB2-RETURN-CODE            
              MOVE '200'               TO WS-DB2-MODULE-ID              
              MOVE '1310'              TO WS-DB2-PARAGRAPH              
              MOVE AR-ACCOUNT-NO       TO WS-DB2-KEY-1                  
              MOVE 12                  TO RETURN-CODE                   
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       1310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **   1320-FETCH-CANCEL-REBILL.                                 **         
      **                                                             ** 15570000
      **   FETCH THE CANCEL_REBILL CURSOR ROWS.                      ** 15580000
      **                                                             ** 15570000
      *****************************************************************         
      *                                                                         
       1320-FETCH-CANCEL-REBILL.                                        
                                                                        
           EXEC SQL                                                     
              FETCH CANCEL_REBILL INTO                                  
                    :WS-CANCEL-REBILL                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'AR'                TO WS-DB2-TABLE-ID               
              MOVE 'FETCH'             TO WS-DB2-FUNCTION               
              MOVE SQLCODE             TO WS-DB2-RETURN-CODE            
              MOVE '200'               TO WS-DB2-MODULE-ID              
              MOVE '1320'              TO WS-DB2-PARAGRAPH              
              MOVE AR-ACCOUNT-NO       TO WS-DB2-KEY-1                  
              MOVE 12                  TO RETURN-CODE                   
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       1320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **   1330-CLOSE-CANCEL-REBILL.                                 **         
      **                                                             ** 15570000
      **   CLOSE THE CANCEL_REBILL CURSOR.                           ** 15580000
      **                                                             ** 15570000
      *****************************************************************         
      *                                                                         
       1330-CLOSE-CANCEL-REBILL.                                        
                                                                        
           EXEC SQL                                                     
              CLOSE CANCEL_REBILL                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'AR'                TO WS-DB2-TABLE-ID               
              MOVE 'CLOSE'             TO WS-DB2-FUNCTION               
              MOVE SQLCODE             TO WS-DB2-RETURN-CODE            
              MOVE '200'               TO WS-DB2-MODULE-ID              
              MOVE '1330'              TO WS-DB2-PARAGRAPH              
              MOVE AR-ACCOUNT-NO       TO WS-DB2-KEY-1                  
              MOVE 12                  TO RETURN-CODE                   
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       1330-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **   1340-CHECK-PYMT                                           **         
      **                                                             **         
      **   THIS PARAGRAPH CHECKS TO SEE IF TOTAL_AR_BALANCE IS EQUAL **         
      **   AMOUNT OF FINAL OR PREVIOUS BILL (NO CANCEL REBILLS).  IF **         
      **   IT IS, THEN THE ACCOUNT IS SELECTED FOR AN AUTOMATED      **         
      **   REFUND.                                                   **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       1340-CHECK-PYMTS.                                                
                                                                        
           MOVE 'N' TO WS-AUTOMATE-REFUND-SW.                           
                                                                        
           PERFORM 1341-OPEN-CIA THRU 1341-EXIT.                        
           PERFORM 1342-FETCH-CIA THRU 1342-EXIT.                       
           PERFORM 1343-CLOSE-CIA THRU 1343-EXIT.                       
                                                                        
           IF WS-CIA = 'Y'                                              
A02845        PERFORM 7100-SELECT-AUTOMATE-PREV-ALL THRU 7100-EXIT      
A02845*                                                                         
A02845        IF WS-AUTOMATE-REFUND-SW = 'Y'                            
A02845           IF WS-MAX-AR-DATE-TRANS    = WS-DATE-BILL-DAY-00       
A02845              OR WS-MAX-AR-DATE-TRANS = WS-DATE-BILL-DAY-30       
A02845              MOVE WS-DATE-BILL-DAY-30 TO WS-TFR-AR-DATE-TRANS    
A02845           ELSE                                                   
A02845***           CHECK LPC CHARGES                                           
A02845              MOVE 'N'        TO WS-AUTOMATE-REFUND-SW            
A02845              PERFORM 7150-SELECT-FIN-WO-LPC THRU 7150-EXIT       
A02845              MOVE WS-DATE-BILL-DAY-60 TO WS-TFR-AR-DATE-TRANS    
A02845           END-IF                                                 
A02845        END-IF                                                    
           END-IF.                                                      
                                                                        
       1340-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **   1341-OPEN-CIA                                             **         
      **                                                             **         
      **   OPENS THE CREDIT_IN_ADVANCE CURSOR.                       **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       1341-OPEN-CIA.                                                   
           EXEC SQL                                                     
              OPEN CREDIT_IN_ADVANCE                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'AC'                TO WS-DB2-TABLE-ID               
              MOVE 'OPEN'              TO WS-DB2-FUNCTION               
              MOVE SQLCODE             TO WS-DB2-RETURN-CODE            
              MOVE '200'               TO WS-DB2-MODULE-ID              
              MOVE '1341'              TO WS-DB2-PARAGRAPH              
              MOVE AC-ACCOUNT-NO       TO WS-DB2-KEY-1                  
              MOVE 12                  TO RETURN-CODE                   
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       1341-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **   1342-FETCH-CIA                                            **         
      **                                                             **         
      **   FETCHED THE CREDIT_IN_ADVANCE CURSOR ROWS.                **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       1342-FETCH-CIA.                                                  
                                                                        
           EXEC SQL                                                     
              FETCH CREDIT_IN_ADVANCE INTO                              
                    :AC-AMT-UNUSED-CR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'AC'                TO WS-DB2-TABLE-ID               
              MOVE 'FETCH'             TO WS-DB2-FUNCTION               
              MOVE SQLCODE             TO WS-DB2-RETURN-CODE            
              MOVE '200'               TO WS-DB2-MODULE-ID              
              MOVE '1342'              TO WS-DB2-PARAGRAPH              
              MOVE AC-ACCOUNT-NO       TO WS-DB2-KEY-1                  
              MOVE 12                  TO RETURN-CODE                   
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T22962        COMPUTE WS-AMT-UNUSED-CR = AC-AMT-UNUSED-CR * -1          
              MOVE 'Y' TO WS-CIA                                        
           ELSE                                                         
              MOVE 'N' TO WS-CIA                                        
           END-IF.                                                      
                                                                        
       1342-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **   1343-CLOSE-CIA                                            **         
      **                                                             **         
      **   CLOSES THE CREDIT_IN_ADVANCE CURSOR.                      **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       1343-CLOSE-CIA.                                                  
           EXEC SQL                                                     
              CLOSE CREDIT_IN_ADVANCE                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'AC'                TO WS-DB2-TABLE-ID               
              MOVE 'CLOSE'             TO WS-DB2-FUNCTION               
              MOVE SQLCODE             TO WS-DB2-RETURN-CODE            
              MOVE '200'               TO WS-DB2-MODULE-ID              
              MOVE '1343'              TO WS-DB2-PARAGRAPH              
              MOVE AC-ACCOUNT-NO       TO WS-DB2-KEY-1                  
              MOVE 12                  TO RETURN-CODE                   
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       1343-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T22962*****************************************************************         
T22962**   1356-CHECK-FOR-TRANSFER.                                  **         
T22962**                                                             **         
T22962**   CHECKS TO SEE IF A TRANSFER HAS BEEN DONE BETWEEN DATE_   **         
T22962**   BILL_DAY_30 AND LAST_PYMT_DATE.  IF ONE HAS BEEN DONE,    **         
T22962**   THE REFUND ROW WILL NOT BE CREATED.                       **         
T22962**                                                             **         
A02842**   IN CASE 00-DAY IS LPC BILL AND 30-DAY IS FB THEN CHECK    **         
A02842**   TRANSFER B/W DATE_BILL_DAY_60 AND LAST_PYMT_DATE.         **         
T22962*****************************************************************         
T22962*                                                                         
T22962 1356-CHECK-FOR-TRANSFER.                                         
T22962                                                                  
T22962     EXEC SQL                                                     
T22962        SELECT 'Y'                                                
T22962        INTO :WS-TRANSFER-DONE                                    
T22962        FROM CSS_AR_TRANS_HIST                                    
T22962       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                          
T22962         AND CODE_TRAN_TYPE = 'T'                                 
A02845         AND DATE_TRANS >= IIF(TRY_CONVERT(DATE, 
                                                  :WS-TFR-AR-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :WS-TFR-AR-DATE-TRANS
              ) <> 0) OR (LEN(:WS-TFR-AR-DATE-TRANS
              ) <> 10), CIS.CHAR2DATE(:WS-TFR-AR-DATE-TRANS
              ), CONVERT(DATE, :WS-TFR-AR-DATE-TRANS) )                  
T22962         AND DATE_TRANS <= IIF(TRY_CONVERT(DATE, 
                                                     :AT-LAST-PYMT-DATE
              ) IS NULL OR (PATINDEX('%.%', :AT-LAST-PYMT-DATE
              ) <> 0) OR (LEN(:AT-LAST-PYMT-DATE
              ) <> 10), CIS.CHAR2DATE(:AT-LAST-PYMT-DATE
              ), CONVERT(DATE, :AT-LAST-PYMT-DATE) )                     
T22962     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                08200000
MFA-TR*       INTO :WS-TRANSFER-DONE                                            
MFA-TR*       FROM CSS_AR_TRANS_HIST                                            
MFA-TR*      WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                  
MFA-TR*        AND CODE_TRAN_TYPE = 'T'                                         
MFA-TR*        AND DATE_TRANS >= :WS-TFR-AR-DATE-TRANS                          
MFA-TR*        AND DATE_TRANS <= :AT-LAST-PYMT-DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22962                                                                  
T22962     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T22962     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T22962        NEXT SENTENCE                                             
T22962     ELSE                                                         
T22962        IF WS-ACTIVE-RETURN-CODE = WS-811                         
T22962           MOVE 'Y' TO WS-TRANSFER-DONE                           
T22962        ELSE                                                      
T22962           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
T22962              MOVE 'N' TO WS-TRANSFER-DONE                        
T22962           ELSE                                                   
T22962              MOVE 'AR'                TO  WS-DB2-TABLE-ID        
T22962              MOVE 'SELECT'            TO  WS-DB2-FUNCTION        
T22962              MOVE SQLCODE             TO  WS-DB2-RETURN-CODE     
T22962              MOVE '200'               TO  WS-DB2-MODULE-ID       
T22962              MOVE '1356'              TO  WS-DB2-PARAGRAPH       
T22962              MOVE AT-ACCOUNT-NO       TO  WS-DB2-KEY-1N          
T22962              MOVE 12                  TO  RETURN-CODE            
T22962              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
T22962           END-IF                                                 
T22962        END-IF                                                    
T22962     END-IF.                                                      
T22962                                                                  
T22962 1356-EXIT.                                                       
T22962     EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **   1400-SELECT-AR-PYMT-DATE-TYPE                             **         
      **                                                             **         
      **   DETERMINE THE LAST PAYMENT DATE AND TYPE OF PAYMENT.      **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       1400-SELECT-AR-PYMT-DATE-TYPE.                                   
                                                                        
           EXEC SQL                                                     
A02798        SELECT TOP(1) AR.DATE_TRANS,
              AU.CURRENCY_TYPE,
              AR.DATE_CASH_REPORT                                
                INTO :AR-DATE-TRANS :WS-DATE-TRANS-NI                    
A02798              ,:AU-CURRENCY-TYPE                                  
A02845              ,:AR-DATE-CASH-REPORT                               
                FROM CSS_AR_TRANS_HIST AR,                              
                     CSS_AR_TRN_HST_DET AU                              
               WHERE AR.ACCOUNT_NO        = :AT-ACCOUNT-NO              
                 AND AR.ACCOUNT_NO        = AU.ACCOUNT_NO               
                 AND AR.CODE_TRAN_TYPE    = :WS-PAYMENT                 
                 AND AR.TRANS_HIST_SEQ_NO = AU.TRANS_HIST_SEQ_NO        
A02798           AND AU.CURRENCY_TYPE IN (:WS-CHECK, :WS-CREDIT-CARD)   
A02798         ORDER BY AR.DATE_TRANS    DESC                           
A02798                 ,AU.CURRENCY_TYPE DESC                           
A02798                                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                     11930000
MFA-TR*       SELECT AR.DATE_TRANS                                      11931000
MFA-TR*             ,AU.CURRENCY_TYPE                                   11931000
MFA-TR*             ,AR.DATE_CASH_REPORT                                        
MFA-TR*         INTO :AR-DATE-TRANS:WS-DATE-TRANS-NI                    11931100
MFA-TR*             ,:AU-CURRENCY-TYPE                                  11931000
MFA-TR*             ,:AR-DATE-CASH-REPORT                                       
MFA-TR*         FROM CSS_AR_TRANS_HIST AR,                              11932000
MFA-TR*              CSS_AR_TRN_HST_DET AU                              11933000
MFA-TR*        WHERE AR.ACCOUNT_NO        = :AT-ACCOUNT-NO              11934000
MFA-TR*          AND AR.ACCOUNT_NO        = AU.ACCOUNT_NO                       
MFA-TR*          AND AR.CODE_TRAN_TYPE    = :WS-PAYMENT                 11935000
MFA-TR*          AND AR.TRANS_HIST_SEQ_NO = AU.TRANS_HIST_SEQ_NO        11936000
MFA-TR*          AND AU.CURRENCY_TYPE IN (:WS-CHECK, :WS-CREDIT-CARD)   11938000
MFA-TR*        ORDER BY AR.DATE_TRANS    DESC                           11938000
MFA-TR*                ,AU.CURRENCY_TYPE DESC                           11938000
MFA-TR*        FETCH FIRST ROW ONLY                                     11938000
MFA-TR*    END-EXEC.                                                    12070000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE SQLCODE                                             
               WHEN SUCCESSFUL-CALL                                     
                    IF WS-DATE-TRANS-NI < 0                             
                       MOVE LOW-VALUES TO AR-DATE-TRANS                 
                    ELSE                                                
                       MOVE WS-YES TO WS-DATE-FLAG                      
                    END-IF                                              
               WHEN NOT-FOUND                                           
                    MOVE LOW-VALUES TO AR-DATE-TRANS                    
               WHEN OTHER                                               
                    MOVE 'AR'                TO WS-DB2-TABLE-ID         
                    MOVE 'SELECT'            TO WS-DB2-FUNCTION         
                    MOVE SQLCODE             TO WS-DB2-RETURN-CODE      
                    MOVE '200'               TO WS-DB2-MODULE-ID        
                    MOVE '1400'              TO WS-DB2-PARAGRAPH        
                    MOVE AR-ACCOUNT-NO       TO WS-DB2-KEY-1N           
                    MOVE AU-ACCOUNT-NO       TO WS-DB2-KEY-2N           
                    MOVE 12                  TO RETURN-CODE             
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT.          
                                                                        
       1400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **   1500-DELINQUENCY-TABLE-VALUE                              **         
      **                                                             **         
      **   GET NUMBER OF DAYS FROM DELINQUENCY TABLE.                **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       1500-DELINQUENCY-TABLE-VALUE.                                    
                                                                        
A02798     IF AU-CURRENCY-TYPE = WS-CREDIT-CARD                         
A02798        MOVE 'DAY-REFUND-CARD' TO C8-DELINQ-CD                    
A02798     ELSE                                                         
A02798        MOVE 'DAY-REFUND-CHECK' TO C8-DELINQ-CD                   
A02798     END-IF                                                       
                                                                        
           PERFORM 1510-SELECT-DELINQUENCY THRU 1510-EXIT.              
                                                                        
           MOVE C8-DELINQ-VALUE TO WS-DEL-WORK-AREA.                    
                                                                        
           MOVE SPACES TO WS-DELINQUENCY-DATE.                          
           COMPUTE WS-REF-TRANS = 101 - WS-DEL-WORK-AREA.               
           MOVE WS-WORK-DAY (WS-REF-TRANS) TO WS-DEL-WORK-DATE.         
                                                                        
A02845*    IF AR-DATE-TRANS > WS-WORK-DAY (101)                                 
A02845     IF AR-DATE-CASH-REPORT  > WS-WORK-DAY (101)                  
T22962*       MOVE WS-WORK-DAY (111) TO WS-DELINQUENCY-DATE                     
T22962        MOVE 'N' TO WS-FOUND                                      
T22962        PERFORM VARYING WS-REF-CTR FROM +102 BY +1                
T22962          UNTIL WS-FOUND = 'Y'                                    
A02845*            IF WS-WORK-DAY (WS-REF-CTR) = AR-DATE-TRANS                  
A02845             IF WS-WORK-DAY (WS-REF-CTR) = AR-DATE-CASH-REPORT    
T22962                COMPUTE WS-REF-TRANS =                            
T22962                        WS-REF-CTR + WS-DEL-WORK-AREA             
T22962                MOVE WS-WORK-DAY (WS-REF-TRANS)                   
T22962                        TO WS-DELINQUENCY-DATE                    
T22962                MOVE 'Y' TO WS-FOUND                              
T22962             END-IF                                               
T22962        END-PERFORM                                               
              GO TO 1500-EXIT                                           
           END-IF.                                                      
                                                                        
A02845*    IF AR-DATE-TRANS > WS-DEL-WORK-DATE                                  
A02845     IF AR-DATE-CASH-REPORT > WS-DEL-WORK-DATE                    
              MOVE 'N' TO WS-FOUND                                      
              PERFORM VARYING WS-REF-CTR FROM WS-REF-TRANS BY +1        
                UNTIL WS-REF-CTR > +101 OR WS-FOUND = 'Y'               
A02845*            IF WS-WORK-DAY (WS-REF-CTR) >= AR-DATE-TRANS                 
A02845             IF WS-WORK-DAY (WS-REF-CTR) >= AR-DATE-CASH-REPORT   
                      COMPUTE WS-REF-TRANS =                            
                              WS-REF-CTR + WS-DEL-WORK-AREA             
                      MOVE WS-WORK-DAY (WS-REF-TRANS)                   
                              TO WS-DELINQUENCY-DATE                    
                      MOVE 'Y' TO WS-FOUND                              
                   END-IF                                               
              END-PERFORM                                               
           END-IF.                                                      
                                                                        
       1500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **   1510-SELECT-DELINQUENCY                                   **         
      **                                                             **         
      **   SELECT THE DELINQUENCY VALUE FROM CSS_DELINQUENCY TABLE.  **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       1510-SELECT-DELINQUENCY.                                         
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = :C8-DELINQ-CD                          
                 AND COMPANY_NO = '01'                                  
A02798                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15320000
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    15360000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'C8'                TO WS-DB2-TABLE-ID               
              MOVE 'SELECT'            TO WS-DB2-FUNCTION               
              MOVE SQLCODE             TO WS-DB2-RETURN-CODE            
              MOVE '200'               TO WS-DB2-MODULE-ID              
              MOVE '1510'              TO WS-DB2-PARAGRAPH              
              MOVE C8-DELINQ-CD        TO WS-DB2-KEY-1                  
              MOVE 12                  TO RETURN-CODE                   
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       1510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **   1600-PROCESS-MULTIPLE-ACCOUNTS                            **         
      **                                                             **         
      **   DETERMINE IF THERE ARE RELATED CUSTOMER ACCOUNTS WITH     **         
      **   FINAL AND CHARGE-OFFS ONLY.                               **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       1600-PROCESS-MULTIPLE-ACCOUNTS.                                  
                                                                        
           PERFORM 1610-OPEN-MULTIPLE-ACCOUNTS THRU 1610-EXIT.          
           MOVE WS-NO TO WS-CODE-MULT-ACCT.                             
A00557     MOVE WS-NO TO WS-DOLLARS-IN-AR.                              
           PERFORM                                                      
             UNTIL SQLCODE EQUAL NOT-FOUND                              
                OR WS-CODE-MULT-ACCT EQUAL WS-YES                       
                   PERFORM 1620-FETCH-MULTIPLE-ACCOUNTS THRU 1620-EXIT  
                   IF SQLCODE = SUCCESSFUL-CALL                         
                      IF AT-CODE-ACCT-STAT EQUAL WS-CHARGE-OFF          
                         MOVE ZEROS TO WS-CHRG-OFF-AMT                  
                         MOVE AT-ACCOUNT-NO TO CO-ACCOUNT-NO            
                         PERFORM 1630-SELECT-CHRG-OFF THRU 1630-EXIT    
                         IF WS-CHRG-OFF-AMT > 0                         
                            MOVE WS-YES TO WS-CODE-MULT-ACCT            
                         END-IF                                         
                      ELSE                                              
                         PERFORM 1640-SELECT-AR-CONTROL THRU 1640-EXIT  
                         IF  AT-DATE-BILL-DAY-00 < WS-25-DAYS-AGO       
                         AND AT-DATE-BILL-DAY-00 NOT EQUAL SPACES       
                         AND WS-AMT-00-DAY > ZEROES                     
                         AND WS-CODE-MULT-ACCT = WS-NO                  
                             MOVE WS-YES TO WS-CODE-MULT-ACCT           
                         END-IF                                         
                         IF  AT-DATE-BILL-DAY-30 < WS-25-DAYS-AGO       
                         AND AT-DATE-BILL-DAY-30 NOT EQUAL SPACES       
                         AND WS-AMT-30-DAY > ZEROES                     
                         AND WS-CODE-MULT-ACCT = WS-NO                  
                             MOVE WS-YES TO WS-CODE-MULT-ACCT           
                         END-IF                                         
                         IF  AT-DATE-BILL-DAY-60 < WS-25-DAYS-AGO       
                         AND AT-DATE-BILL-DAY-60 NOT EQUAL SPACES       
                         AND WS-AMT-60-DAY > ZEROES                     
                         AND WS-CODE-MULT-ACCT = WS-NO                  
                             MOVE WS-YES TO WS-CODE-MULT-ACCT           
                         END-IF                                         
                         IF  AT-DATE-BILL-DAY-90 < WS-25-DAYS-AGO       
                         AND AT-DATE-BILL-DAY-90 NOT EQUAL SPACES       
                         AND WS-AMT-90-DAY > ZEROES                     
                         AND WS-CODE-MULT-ACCT = WS-NO                  
                             MOVE WS-YES TO WS-CODE-MULT-ACCT           
                         END-IF                                         
                      END-IF                                            
                   END-IF                                               
           END-PERFORM.                                                 
                                                                        
           PERFORM 1650-CLOSE-MULTIPLE-ACCOUNTS  THRU 1650-EXIT.        
                                                                        
           IF WS-CODE-MULT-ACCT = WS-YES                                
              PERFORM 1660-CALC-AR-EXCEPTIONS THRU 1660-EXIT            
           END-IF.                                                      
                                                                        
       1600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **   1610-OPEN-MULTIPLE-ACCOUNTS                               **         
      **                                                             **         
      **   OPEN CURSOR FOR CSS_ACCOUNT                               **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       1610-OPEN-MULTIPLE-ACCOUNTS.                                     
                                                                        
           EXEC SQL                                                     
              OPEN ACCOUNT                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'AT'                TO  WS-DB2-TABLE-ID              
              MOVE 'OPEN'              TO  WS-DB2-FUNCTION              
              MOVE SQLCODE             TO  WS-DB2-RETURN-CODE           
              MOVE '200'               TO  WS-DB2-MODULE-ID             
              MOVE '1610'              TO  WS-DB2-PARAGRAPH             
              MOVE AT-CODE-ACCT-STAT   TO  WS-DB2-KEY-1                 
              MOVE AT-ACCOUNT-NO       TO  WS-DB2-KEY-2N                
              MOVE 12                  TO  RETURN-CODE                  
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       1610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **   1620-FETCH-MULTIPLE-ACCOUNTS                              **         
      **                                                             **         
      **   FETCH COLUMNS FROM CSS_ACCOUNT.                           **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       1620-FETCH-MULTIPLE-ACCOUNTS.                                    
                                                                        
           EXEC SQL                                                     
              FETCH ACCOUNT                                             
               INTO :AT-ACCOUNT-NO,                                     
                    :AT-PREMISE-NO,                                     
                    :AT-CUSTOMER-NO,                                    
                    :AT-COMPANY-NO,                                     
                    :AT-CODE-ACCT-STAT,                                 
                    :AT-LOCAL-OFFICE,                                   
                    :AT-DATE-BILL-DAY-00 :WS-DT-00-NULL-IND,             
                    :AT-DATE-BILL-DAY-30 :WS-DT-30-NULL-IND,             
                    :AT-DATE-BILL-DAY-60 :WS-DT-60-NULL-IND,             
                    :AT-DATE-BILL-DAY-90 :WS-DT-90-NULL-IND              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           OR NOT-FOUND                                                 
              IF WS-DT-00-NULL-IND < 0                                  
                 MOVE SPACES TO AT-DATE-BILL-DAY-00                     
              END-IF                                                    
              IF WS-DT-30-NULL-IND < 0                                  
                 MOVE SPACES TO AT-DATE-BILL-DAY-30                     
              END-IF                                                    
              IF WS-DT-60-NULL-IND < 0                                  
                 MOVE SPACES TO AT-DATE-BILL-DAY-60                     
              END-IF                                                    
              IF WS-DT-90-NULL-IND < 0                                  
                 MOVE SPACES TO AT-DATE-BILL-DAY-90                     
              END-IF                                                    
           ELSE                                                         
              MOVE 'AT'                TO  WS-DB2-TABLE-ID              
              MOVE 'FETCH'             TO  WS-DB2-FUNCTION              
              MOVE SQLCODE             TO  WS-DB2-RETURN-CODE           
              MOVE '200'               TO  WS-DB2-MODULE-ID             
              MOVE '1620'              TO  WS-DB2-PARAGRAPH             
              MOVE AT-CODE-ACCT-STAT   TO  WS-DB2-KEY-1                 
              MOVE AT-ACCOUNT-NO       TO  WS-DB2-KEY-2N                
              MOVE 12                  TO  RETURN-CODE                  
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       1620-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **   1630-SELECT-CHRG-OFF                                      **         
      **                                                             **         
      **   FETCH COLUMNS FROM CSS_ACCOUNT.                           **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       1630-SELECT-CHRG-OFF.                                            
                                                                        
           EXEC SQL                                                     
              SELECT SUM (AMT_TRANS)                                    
                INTO :WS-CHRG-OFF-AMT :WS-PAR-NULL-IND                  
                FROM CSS_CHRG_OFF                                       
               WHERE ACCOUNT_NO = :CO-ACCOUNT-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           OR NOT-FOUND                                                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CO'                TO  WS-DB2-TABLE-ID              
              MOVE 'SELECT'            TO  WS-DB2-FUNCTION              
              MOVE SQLCODE             TO  WS-DB2-RETURN-CODE           
              MOVE '200'               TO  WS-DB2-MODULE-ID             
              MOVE '1630'              TO  WS-DB2-PARAGRAPH             
              MOVE CO-ACCOUNT-NO       TO  WS-DB2-KEY-1N                
              MOVE 12                  TO  RETURN-CODE                  
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       1630-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **   1640-SELECT-AR-CONTROL                                    **         
      **                                                             **         
      **   SELECT COLUMN NAMES FROM AR TABLE.                        **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       1640-SELECT-AR-CONTROL.                                          
                                                                        
           EXEC SQL                                                     
              SELECT SUM(AMT_AR_DAY_00),                                
                     SUM(AMT_AR_DAY_30),                                
                     SUM(AMT_AR_DAY_60),                                
                     SUM(AMT_AR_DAY_90)                                 
                INTO :WS-AMT-00-DAY :WS-AMT-00-NULL-IND,                 
                     :WS-AMT-30-DAY :WS-AMT-30-NULL-IND,                 
                     :WS-AMT-60-DAY :WS-AMT-60-NULL-IND,                 
                     :WS-AMT-90-DAY :WS-AMT-90-NULL-IND                  
                FROM CSS_AR_CNTL                                        
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                 AND ITEM_ID = 0                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           OR NOT-FOUND                                                 
              IF WS-AMT-00-NULL-IND < 0                                 
                 MOVE ZEROES TO WS-AMT-00-DAY                           
              END-IF                                                    
              IF WS-AMT-30-NULL-IND < 0                                 
                 MOVE ZEROES TO WS-AMT-30-DAY                           
              END-IF                                                    
              IF WS-AMT-60-NULL-IND < 0                                 
                 MOVE ZEROES TO WS-AMT-60-DAY                           
              END-IF                                                    
              IF WS-AMT-90-NULL-IND < 0                                 
                 MOVE ZEROES TO WS-AMT-90-DAY                           
              END-IF                                                    
           ELSE                                                         
              MOVE 'AC'                    TO  WS-DB2-TABLE-ID          
              MOVE 'SELECT'                TO  WS-DB2-FUNCTION          
              MOVE SQLCODE                 TO  WS-DB2-RETURN-CODE       
              MOVE '200'                   TO  WS-DB2-MODULE-ID         
              MOVE '1640'                  TO  WS-DB2-PARAGRAPH         
              MOVE AT-ACCOUNT-NO           TO  WS-DB2-KEY-1N            
              MOVE 12                      TO  RETURN-CODE              
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       1640-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************12920000
      **    1650-CLOSE-MULTIPLE-ACCOUNTS.                             **12930000
      **                                                              **12940000
      **    CLOSE CURSOR FOR CSS_ACCOUNT.                             **12950000
      ******************************************************************12980000
      *                                                                         
       1650-CLOSE-MULTIPLE-ACCOUNTS.                                    
                                                                        
           EXEC SQL                                                     
              CLOSE ACCOUNT                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'AT'                TO  WS-DB2-TABLE-ID              
              MOVE 'CLOSE'             TO  WS-DB2-FUNCTION              
              MOVE SQLCODE             TO  WS-DB2-RETURN-CODE           
              MOVE '200'               TO  WS-DB2-MODULE-ID             
              MOVE '1650'              TO  WS-DB2-PARAGRAPH             
              MOVE AT-CODE-ACCT-STAT   TO  WS-DB2-KEY-1                 
              MOVE AT-ACCOUNT-NO       TO  WS-DB2-KEY-2N                
              MOVE 12                  TO  RETURN-CODE                  
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       1650-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05642001
      ******************************************************************05642001
      **   1660-CALC-AR-EXCEPTIONS                                    **        
      **                                                              **        
      **        THIS MODULE CALCULATES IF ANY DOLLARS RESIDE IN ANY   **        
      **        OTHER AR_CNTL ROWS. IT CHECKS ALL AGE BUCKETS,        **        
      **        UNUSED_CR, SUM_UNBILLED AND AMT_TRANS_BALANCE FOR ANY **        
      **        AR_CNTL ROW FOUND.  THESE EXCEPTIONS WILL BE HANDLED  **        
      **        MANUALLY.                                             **        
      **                                                              **        
      ******************************************************************05642001
      *                                                                 05642001
       1660-CALC-AR-EXCEPTIONS.                                         
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
              INTO :WS-DOLLARS-IN-AR                                    
              FROM CSS_AR_CNTL                                          
             WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                          
               AND (AMT_AR_DAY_00 <> 0                                  
                OR  AMT_AR_DAY_30 <> 0                                  
                OR  AMT_AR_DAY_60 <> 0                                  
                OR  AMT_AR_DAY_90 <> 0                                  
                OR  AMT_UNUSED_CR <> 0                                  
                OR  AMT_TRAN_BALANCE <> 0                               
                OR  TOT_SUMM_UNBILLED <> 0)                             
               AND PYMT_PRIORITY_LVL <> +0070                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = WS-811                         
                 MOVE 'Y' TO WS-DOLLARS-IN-AR                           
              ELSE                                                      
                 IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                    MOVE 'N' TO WS-DOLLARS-IN-AR                        
                 ELSE                                                   
                    MOVE 'AC'                TO  WS-DB2-TABLE-ID        
                    MOVE 'SELECT'            TO  WS-DB2-FUNCTION        
                    MOVE SQLCODE             TO  WS-DB2-RETURN-CODE     
                    MOVE '200'               TO  WS-DB2-MODULE-ID       
                    MOVE '1660'              TO  WS-DB2-PARAGRAPH       
                    MOVE AT-ACCOUNT-NO       TO  WS-DB2-KEY-1N          
                    MOVE 12                  TO  RETURN-CODE            
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       1660-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06540000
      ******************************************************************06550000
      ** 1700-CREATE-REVIEW-REQUIRED.                                 **06560000
      **                                                              **06570000
      ** BUILD REVIEW TEXT FOR WORK QUEUE.                            **06580000
      **                                                              **06570000
      ******************************************************************06610000
      *                                                                         
       1700-CREATE-REVIEW-REQUIRED.                                     
                                                                        
ACT015     INITIALIZE CWS00077-FIELDS.                                  
ACT015     MOVE +99 TO WS-77-CATEGORY-ID.                               
           MOVE RN-AMT-REFUNDED TO WS-AMT-REFUND.                       
           MOVE WS-AMT-REFUND TO WS-MSG-PART-1.                         
ACT015     MOVE ZERO TO WS-77-SERV-ORDER-NO.                            
ACT015     MOVE WS-RELEASE-DATE TO WS-77-DATE-REQUIRED                  
ACT015     MOVE WS-ACCOUNT-NO TO WS-77-ACCOUNT-NO.                      
ACT015     MOVE ZERO TO WS-77-PREMISE-NO.                               
ACT015     MOVE WS-CUSTOMER-NO TO WS-77-CUSTOMER-NO.                    
ACT015     MOVE 'SYSTEM ' TO WS-77-USER-ID-ORIG.                        
ACT015     MOVE LOW-VALUES TO WS-77-RESP-AREA-ID.                       
ACT015     MOVE WS-LOCAL-OFFICE TO WS-77-LOCAL-OFFICE.                  
ACT015     MOVE '4' TO WS-77-ROUTE-CATEGORY.                            
ACT015     MOVE 'N' TO WS-77-PRIORITY.                                  
ACT015     MOVE WS-CURRENT-DATE          TO WS-CURRENT-DATE-26(1:10).   
ACT015     MOVE WS-CURRENT-DATE-REF      TO WS-CURRENT-DATE-26(11:16).  
ACT015     MOVE WS-CURRENT-DATE-26       TO WS-77-DATE-CREATED.         
ACT015     MOVE PROGRAM-NAME             TO WS-77-CREATED-BY.           
                                                                        
      *                                                                         
      * PAYMENT DATE AND TYPE OF PAYMENT                                06940000
      *                                                                         
           IF WS-DATE-FLAG = WS-YES                                     
              MOVE AR-DATE-TRANS TO WS-PYMT-DATE                        
              MOVE WS-CHECK TO WS-PYMT-TYPE                             
                                                                        
              STRING WS-LAST-PYMT-DATE                                  
                     WS-PYMT-DATE (6:2)                                 
                     WS-SLASH                                           
                     WS-PYMT-DATE (9:2)                                 
                     WS-SLASH                                           
                     WS-PYMT-DATE (3:2)                                 
                     ' '                                                
                     WS-PYMT-TYPE                                       
                     ' ' DELIMITED BY SIZE                              
              INTO WS-MSG-PART-2                                        
           END-IF.                                                      
      *                                                                 06930000
      * BILL EXCEPTION COUNT                                            06940000
      *                                                                 06930000
           IF WS-BILL-EXCEPT-COUNT  >  0                                
              MOVE WS-BILL-EXCEPT-Y-MSG TO WS-MSG-PART-3                
           ELSE                                                         
              MOVE WS-BILL-EXCEPT-N-MSG TO WS-MSG-PART-3                
           END-IF.                                                      
      *                                                                 07000000
      * CUSTOMER WITH MULTIPLE ACCOUNTS                                 07010000
      *                                                                 07000000
           IF WS-CODE-MULT-ACCT EQUAL WS-YES                            
              MOVE WS-MULT-ACCT-Y-MSG TO WS-MSG-PART-4                  
           ELSE                                                         
              MOVE WS-MULT-ACCT-N-MSG TO WS-MSG-PART-4                  
           END-IF.                                                      
      *                                                                 07000000
      * BANKRUPTCY INDICATOR SET TO 'B'                                 07010000
      *                                                                 07000000
                                                                        
           IF WS-BANKRUPTCY-IND EQUAL WS-B                              
              MOVE WS-BANKRUPTCY-Y-MSG TO WS-MSG-PART-5                 
              MOVE +99 TO WS-WQ-CATEGORY                                
           ELSE                                                         
              MOVE WS-BANKRUPTCY-N-MSG TO WS-MSG-PART-5                 
              MOVE +98 TO WS-WQ-CATEGORY                                
           END-IF.                                                      
                                                                        
      *                                                                 07075100
      * DOLLARS IN ANY OTHER AR-CNTL ROW                                        
      *                                                                 07075100
           IF WS-DOLLARS-IN-AR EQUAL WS-YES                             
              MOVE WS-DOLLARS-IN-AR-MSG TO WS-MSG-PART-8                
ACT015        MOVE +98 TO WS-77-CATEGORY-ID                             
           END-IF.                                                      
                                                                        
           MOVE 1 TO WS-REVIEW-TEXT-LENGTH.                             
                                                                        
           STRING WS-MSG-PART-1                                         
                  DELIMITED BY SIZE                                     
                  WS-SEMI DELIMITED BY SIZE                             
                  WS-MSG-PART-2                                         
                  DELIMITED BY '  '                                     
                  WS-SEMI DELIMITED BY SIZE                             
                  WS-MSG-PART-3                                         
                  DELIMITED BY '  '                                     
                  WS-SEMI DELIMITED BY SIZE                             
                  WS-MSG-PART-4                                         
                  DELIMITED BY '  '                                     
                  WS-SEMI DELIMITED BY SIZE                             
                  WS-MSG-PART-5                                         
                  DELIMITED BY '  '                                     
                  WS-SEMI DELIMITED BY SIZE                             
                  WS-MSG-PART-6                                         
                  DELIMITED BY '  '                                     
                  WS-SEMI DELIMITED BY SIZE                             
                  WS-MSG-PART-7                                         
                  DELIMITED BY '  '                                     
                  WS-SEMI DELIMITED BY SIZE                             
                  WS-MSG-PART-8                                         
                  DELIMITED BY '  '                                     
             INTO WS-REVIEW-TEXT-MSG                                    
             POINTER WS-REVIEW-TEXT-LENGTH.                             
                                                                        
ACT015       MOVE WS-REVIEW-TEXT-MSG TO WS-77-COMMENTS-TEXT.            
ACT015       MOVE WS-REVIEW-TEXT-LENGTH TO WS-77-COMMENTS-LEN.          
ACT015       MOVE ZERO TO WS-77-FREE-FORM-LEN.                          
ACT015       MOVE LOW-VALUES TO WS-77-FREE-FORM-TXT.                    
                                                                        
             PERFORM 1710-INSERT-WORK-QUEUE THRU 1710-EXIT.             
                                                                        
       1700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **    1710-INSERT-WORK-QUEUE.                                   **11860000
      **                                                              **11870000
      **  INSERT WORK QUEUE INFORMATION INTO CSS_WQ_ITEMS_MF.         **        
      **                                                              **11870000
      *****************************************************************         
      *                                                                         
       1710-INSERT-WORK-QUEUE.                                          
                                                                        
                                                                        
ACT015     CALL SCSCB077  USING   CWS00077-FIELDS,                      
ACT015                            ABEND-FILE,                           
ACT015                            RS-RETURN-CODE.                       
ACT015                                                                  
ACT015     MOVE RS-RETURN-CODE             TO WS-ACTIVE-RETURN-CODE.    
ACT015     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
ACT015        MOVE PROGRAM-NAME               TO   ABEND-PROGRAM        
ACT015        DISPLAY '1710-INSERT-WORK-QUEUE'                          
ACT015        DISPLAY 'CALL SCSCB077         '                          
ACT015        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
ACT015        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
ACT015        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
ACT015        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
ACT015        PERFORM 9900-ABEND    THRU 9900-EXIT                      
ACT015     END-IF.                                                      
                                                                        
       1710-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      **    1800-SELECT-MAX-ITEM-ID.                                  **11860000
      **                                                              **11870000
      **  GET NUMBER OF DAYS FROM DELINQUENCY TABLE                   **        
      **                                                              **11870000
      ******************************************************************        
      *                                                                         
       1800-SELECT-MAX-ITEM-ID.                                         
                                                                        
           EXEC SQL                                                     
              SELECT MAX(REFUND_ITEM_ID)                                
                INTO :RN-REFUND-ITEM-ID :WS-REFUND-NULL                 
                FROM CSS_REFUND                                         
               WHERE ACCOUNT_NO = :RN-ACCOUNT-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-REFUND-NULL < 0                                     
                 MOVE 0 TO RN-REFUND-ITEM-ID                            
              ELSE                                                      
                 COMPUTE RN-REFUND-ITEM-ID =                            
                                      RN-REFUND-ITEM-ID + 1             
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 0 TO RN-REFUND-ITEM-ID                            
              ELSE                                                      
                 MOVE 'RN'                TO WS-DB2-TABLE-ID            
                 MOVE 'SELECT'            TO WS-DB2-FUNCTION            
                 MOVE SQLCODE             TO WS-DB2-RETURN-CODE         
                 MOVE '200'               TO WS-DB2-MODULE-ID           
                 MOVE '1800'              TO WS-DB2-PARAGRAPH           
                 MOVE RN-ACCOUNT-NO       TO WS-DB2-KEY-1N              
                 MOVE 12                  TO RETURN-CODE                
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
       1800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15540000
      ******************************************************************15550000
      **    1900-INSERT-CSS-REFUND.                                   **15560000
      **                                                              **15570000
      **    INSERT THE CURRENT REFUND TO BE ISSUED.                   **15580000
      **                                                              **15590000
      ******************************************************************15610000
      *                                                                 15540000
       1900-INSERT-CSS-REFUND.                                          
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_REFUND                                    
                  (REFUND_ITEM_ID,                                      
                   REFUND_CHECK_NO,                                     
                   DEPOSIT_CERT_NO,                                     
                   LOCAL_OFFICE,                                        
                   AMT_REFUNDED,                                        
                   REQUEST_DT,                                          
                   CHECK_STATUS_CD,                                     
T22962             CHECK_ISS_REAS_CD,                                   
                   ORIGINAL_CHECK_NO,                                   
                   RETURNED_REASON,                                     
                   MANUAL_INDICATOR,                                    
                   USER_ID_APPRVD_BY,                                   
                   REFUND_STATUS_DT,                                    
                   USER_ID_RQSTED_BY,                                   
                   ACCOUNT_NO,                                          
                   PANEL_NO,                                            
                   ADDRESS_ID,                                          
A03707             DATE_REFUNDED,                                       
                   TRANS_HIST_SEQ_NO)                                   
              VALUES                                                    
                   (:RN-REFUND-ITEM-ID,                                 
                    :RN-REFUND-CHECK-NO,                                
                    :RN-DEPOSIT-CERT-NO,                                
                    :RN-LOCAL-OFFICE,                                   
                    :RN-AMT-REFUNDED,                                   
                    IIF(TRY_CONVERT(DATE, :RN-REQUEST-DT
              ) IS NULL OR (PATINDEX('%.%', :RN-REQUEST-DT
              ) <> 0) OR (LEN(:RN-REQUEST-DT) <> 10), CIS.CHAR2DATE(
                                                         :RN-REQUEST-DT
              ), CONVERT(DATE, :RN-REQUEST-DT) ),                              
                    :RN-CHECK-STATUS-CD,                                
T22962              :RN-CHECK-ISS-REAS-CD,                              
                    :RN-ORIGINAL-CHECK-NO,                              
                    :RN-RETURNED-REASON,                                
                    :RN-MANUAL-INDICATOR,                               
                    :RN-USER-ID-APPRVD-BY,                              
                    IIF(TRY_CONVERT(DATE, :RN-REFUND-STATUS-DT
              ) IS NULL OR (PATINDEX('%.%', :RN-REFUND-STATUS-DT
              ) <> 0) OR (LEN(:RN-REFUND-STATUS-DT
              ) <> 10), CIS.CHAR2DATE(:RN-REFUND-STATUS-DT
              ), CONVERT(DATE, :RN-REFUND-STATUS-DT) ),                        
                    :RN-USER-ID-RQSTED-BY,                              
                    :RN-ACCOUNT-NO,                                     
                    :RN-PANEL-NO,                                       
                    :RN-ADDRESS-ID,                                     
A03707              IIF(TRY_CONVERT(DATE, :RN-DATE-REFUNDED 
                                          :WS-NULL-INDICATOR-1
              ) IS NULL OR (PATINDEX('%.%', :RN-DATE-REFUNDED 
                                                   :WS-NULL-INDICATOR-1
              ) <> 0) OR (LEN(:RN-DATE-REFUNDED :WS-NULL-INDICATOR-1
              ) <> 10), CIS.CHAR2DATE(:RN-DATE-REFUNDED 
                                                   :WS-NULL-INDICATOR-1
              ), CONVERT(DATE, :RN-DATE-REFUNDED :WS-NULL-INDICATOR-1
              ) ),              
                    CIS.CURRENT$TIMESTAMP())                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     15630000
MFA-TR*       INSERT INTO CSS_REFUND                                    15640000
MFA-TR*           (REFUND_ITEM_ID,                                      15650000
MFA-TR*            REFUND_CHECK_NO,                                     15660000
MFA-TR*            DEPOSIT_CERT_NO,                                     15670000
MFA-TR*            LOCAL_OFFICE,                                        15680000
MFA-TR*            AMT_REFUNDED,                                        15710000
MFA-TR*            REQUEST_DT,                                          15740000
MFA-TR*            CHECK_STATUS_CD,                                     15791000
MFA-TR*            CHECK_ISS_REAS_CD,                                   15791000
MFA-TR*            ORIGINAL_CHECK_NO,                                   15810000
MFA-TR*            RETURNED_REASON,                                     15820000
MFA-TR*            MANUAL_INDICATOR,                                    15830000
MFA-TR*            USER_ID_APPRVD_BY,                                   15840000
MFA-TR*            REFUND_STATUS_DT,                                    15850000
MFA-TR*            USER_ID_RQSTED_BY,                                   15860000
MFA-TR*            ACCOUNT_NO,                                          15870000
MFA-TR*            PANEL_NO,                                            15911000
MFA-TR*            ADDRESS_ID,                                          15912000
MFA-TR*            DATE_REFUNDED,                                       15912000
MFA-TR*            TRANS_HIST_SEQ_NO)                                   15913000
MFA-TR*       VALUES                                                    15930000
MFA-TR*            (:RN-REFUND-ITEM-ID,                                 15940000
MFA-TR*             :RN-REFUND-CHECK-NO,                                15950000
MFA-TR*             :RN-DEPOSIT-CERT-NO,                                15960000
MFA-TR*             :RN-LOCAL-OFFICE,                                   15970000
MFA-TR*             :RN-AMT-REFUNDED,                                   16000000
MFA-TR*             :RN-REQUEST-DT,                                     16030000
MFA-TR*             :RN-CHECK-STATUS-CD,                                16081000
MFA-TR*             :RN-CHECK-ISS-REAS-CD,                              04752000
MFA-TR*             :RN-ORIGINAL-CHECK-NO,                              16100000
MFA-TR*             :RN-RETURNED-REASON,                                16110000
MFA-TR*             :RN-MANUAL-INDICATOR,                               16120000
MFA-TR*             :RN-USER-ID-APPRVD-BY,                              16130000
MFA-TR*             :RN-REFUND-STATUS-DT,                               16140000
MFA-TR*             :RN-USER-ID-RQSTED-BY,                              16150000
MFA-TR*             :RN-ACCOUNT-NO,                                     16160000
MFA-TR*             :RN-PANEL-NO,                                       16201000
MFA-TR*             :RN-ADDRESS-ID,                                     16202000
MFA-TR*             :RN-DATE-REFUNDED:WS-NULL-INDICATOR-1,              15912000
MFA-TR*             CURRENT TIMESTAMP)                                  16203000
MFA-TR*    END-EXEC.                                                    16220000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'RN'             TO  WS-DB2-TABLE-ID                 
              MOVE 'INSERT'         TO  WS-DB2-FUNCTION                 
              MOVE SQLCODE          TO  WS-DB2-RETURN-CODE              
              MOVE '200'            TO  WS-DB2-MODULE-ID                
              MOVE '1900'           TO  WS-DB2-PARAGRAPH                
              MOVE RN-ACCOUNT-NO    TO  WS-DB2-KEY-1N                   
              MOVE 16               TO  RETURN-CODE                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       1900-EXIT.                                                       
           EXIT.                                                        
T22962*                                                                 15540000
A00557******************************************************************15550000
A00557**    1910-CANCEL-CSS-REFUND.                                   **15560000
A00557**                                                              **15570000
A00557**    CANCEL ALL EXISTING REFUNDS BEFORE INSERTING NEW REFUND   **15580000
A00557**                                                              **15590000
A00557******************************************************************15610000
A00557*                                                                 15540000
A00557 1910-CANCEL-CSS-REFUND.                                          
A00557*                                                                         
A00557     MOVE 40                  TO RN-COMMENTS-LEN                  
A00557     MOVE WS-CANCEL-COMMENTS  TO RN-COMMENTS-TEXT                 
A00557*                                                                         
A00557     EXEC SQL                                                     
A00557        UPDATE RN                                       
A00557           SET CHECK_STATUS_CD     = :WS-CANCEL                   
A00557              ,REFUND_STATUS_DT    = IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )             
A00557              ,DATE_CANCELLED      = IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )             
A00557              ,TRANS_HIST_SEQ_NO   = CIS.CURRENT$TIMESTAMP()            
A00557              ,COMMENTS            = :RN-COMMENTS                 
              FROM CSS_REFUND RN
A00557         WHERE RN.ACCOUNT_NO       = :RN-ACCOUNT-NO               
A00557           AND RN.CHECK_STATUS_CD  = 'R'                          
A00557           AND RN.MANUAL_INDICATOR = 'S'                          
A00557     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     15630000
MFA-TR*       UPDATE CSS_REFUND RN                                      15640000
MFA-TR*          SET CHECK_STATUS_CD     = :WS-CANCEL                   15650000
MFA-TR*             ,REFUND_STATUS_DT    = :WS-CURRENT-DATE             15850000
MFA-TR*             ,DATE_CANCELLED      = :WS-CURRENT-DATE             15850000
MFA-TR*             ,TRANS_HIST_SEQ_NO   = CURRENT TIMESTAMP            15850000
MFA-TR*             ,COMMENTS            = :RN-COMMENTS                 15850000
MFA-TR*        WHERE RN.ACCOUNT_NO       = :RN-ACCOUNT-NO               15940000
MFA-TR*          AND RN.CHECK_STATUS_CD  = 'R'                                  
MFA-TR*          AND RN.MANUAL_INDICATOR = 'S'                                  
MFA-TR*    END-EXEC.                                                    16220000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00557*                                                                         
A00557     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A00557*                                                                         
A00557     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A00557        NEXT SENTENCE                                             
A00557     ELSE                                                         
A00557        MOVE 'RN'             TO  WS-DB2-TABLE-ID                 
A00557        MOVE 'UPDATE'         TO  WS-DB2-FUNCTION                 
A00557        MOVE SQLCODE          TO  WS-DB2-RETURN-CODE              
A00557        MOVE '200'            TO  WS-DB2-MODULE-ID                
A00557        MOVE '1910'           TO  WS-DB2-PARAGRAPH                
A00557        MOVE RN-ACCOUNT-NO    TO  WS-DB2-KEY-1N                   
A00557        MOVE 16               TO  RETURN-CODE                     
A00557        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
A00557     END-IF.                                                      
A00557*                                                                         
A00557 1910-EXIT.                                                       
A00557     EXIT.                                                        
A00557*                                                                 15540000
T22962******************************************************************15550000
T22962**    1950-UPDATE-ACCOUNT.                                      **15560000
T22962**                                                              **15570000
T22962**    UPDATES CSS_ACCOUNT TABLE TO SHOW 'A' IN WS-CODE-CHECK-   **15580000
T22962**    REFUND.                                                   **15580000
T22962**                                                              **15590000
T22962******************************************************************15610000
T22962*                                                                 15540000
T22962 1950-UPDATE-ACCOUNT.                                             
T22962                                                                  
T22962     MOVE SPACES TO WS-CODES-DATA-PRESENT.                        
T22962     MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT.         
T22962     MOVE WS-A TO WS-CODE-CHECK-REFUND.                           
T22962     MOVE WS-CODES-DATA-PRESENT TO AT-CODES-DATA-PRESENT.         
T22962                                                                  
T22962     EXEC SQL                                                     
T22962        UPDATE CSS_ACCOUNT                                        
T22962           SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT        
T22962         WHERE ACCOUNT_NO = :RN-ACCOUNT-NO                        
T22962     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22962                                                                  
T22962     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T22962     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T22962        NEXT SENTENCE                                             
T22962     ELSE                                                         
T22962        MOVE 'AT'             TO  WS-DB2-TABLE-ID                 
T22962        MOVE 'UPDATE'         TO  WS-DB2-FUNCTION                 
T22962        MOVE SQLCODE          TO  WS-DB2-RETURN-CODE              
T22962        MOVE '200'            TO  WS-DB2-MODULE-ID                
T22962        MOVE '1950'           TO  WS-DB2-PARAGRAPH                
T22962        MOVE RN-ACCOUNT-NO    TO  WS-DB2-KEY-1N                   
T22962        MOVE 16               TO  RETURN-CODE                     
T22962        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
T22962     END-IF.                                                      
T22962                                                                  
T22962 1950-EXIT.                                                       
T22962     EXIT.                                                        
A03707*                                                                         
A03707*****************************************************************         
A03707* 5000-INSERT-REFUND.                                          **         
A03707*****************************************************************         
A03707*                                                                         
A03707 5000-INSERT-REFUND.                                              
A03707*                                                                         
A03707     PERFORM 7010-SET-TIMESTAMP       THRU 7010-EXIT.             
A03707     MOVE 0                           TO WS-TRAN-APPL-NO.         
A03707     MOVE 'PCSCA200A'                 TO WS-APPL-PROGRAM-ID.      
A03707     MOVE 'ENERGYWISE REBATE REFUND'  TO WS-TRAN-COMMENT-TEXT.    
A03707     MOVE 24                          TO WS-TRAN-COMMENT-LEN.     
A03707     MOVE SPACES                      TO WS-TABLE-ID.             
A03707*                                                                         
A03707     MOVE '*INSERTED'                 TO WS-PRV-COLUMN-VALUE-TEXT.
A03707     MOVE 9                           TO WS-PRV-COLUMN-VALUE-LEN. 
A03707*                                                                         
A03707     ADD +1                           TO WS-TRAN-APPL-NO.         
A03707     MOVE 'REQUEST_DT'                TO WS-COLUMN-DESC.          
A03707     MOVE 10                          TO WS-CHG-COLUMN-VALUE-LEN. 
A03707     MOVE WS-CURRENT-DATE             TO WS-CHG-COLUMN-VALUE-TEXT.
A03707     PERFORM 5100-SET-MNT-TRANS-VARS  THRU 5100-EXIT              
A03707     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
A03707*                                                                         
A03707     ADD +1                           TO WS-TRAN-APPL-NO.         
A03707     MOVE 'DATE_REFUNDED'             TO WS-COLUMN-DESC.          
A03707     MOVE 10                          TO WS-CHG-COLUMN-VALUE-LEN. 
A03707     MOVE WS-CURRENT-DATE             TO WS-CHG-COLUMN-VALUE-TEXT 
A03707                                         RN-DATE-REFUNDED.        
A03707     MOVE 0                           TO WS-NULL-INDICATOR-1.     
A03707     PERFORM 5100-SET-MNT-TRANS-VARS  THRU 5100-EXIT              
A03707     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
A03707*                                                                         
A03707     ADD +1                           TO WS-TRAN-APPL-NO.         
A03707     MOVE 'CHECK_STATUS_CD'           TO WS-COLUMN-DESC.          
A03707     MOVE 1                           TO WS-CHG-COLUMN-VALUE-LEN. 
A03707     MOVE RN-CHECK-STATUS-CD          TO WS-CHG-COLUMN-VALUE-TEXT.
A03707     PERFORM 5100-SET-MNT-TRANS-VARS  THRU 5100-EXIT              
A03707     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
A03707*                                                                         
A03707     ADD +1                           TO WS-TRAN-APPL-NO.         
A03707     MOVE 'CHECK_ISS_REAS_CD'         TO WS-COLUMN-DESC.          
A03707     MOVE 2                           TO WS-CHG-COLUMN-VALUE-LEN. 
A03707     MOVE RN-CHECK-ISS-REAS-CD        TO WS-CHG-COLUMN-VALUE-TEXT.
A03707     PERFORM 5100-SET-MNT-TRANS-VARS  THRU 5100-EXIT              
A03707     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
A03707*                                                                         
A03707     PERFORM 1900-INSERT-CSS-REFUND   THRU 1900-EXIT.             
A03707*                                                                         
A03707 5000-EXIT.                                                       
A03707     EXIT.                                                        
A03707*                                                                         
A03707*****************************************************************         
A03707* 5010-UPDATE-CONTRACT.                                        **         
A03707*****************************************************************         
A03707*                                                                         
A03707 5010-UPDATE-CONTRACT.                                            
A03707*                                                                         
A03707     PERFORM 7010-SET-TIMESTAMP       THRU 7010-EXIT.             
A03707     MOVE 0                           TO WS-TRAN-APPL-NO.         
A03707     MOVE 'PCSCA200B'                 TO WS-APPL-PROGRAM-ID.      
A03707     MOVE 'ENERGYWISE REBATE REFUND CREATED'                      
A03707                                      TO WS-TRAN-COMMENT-TEXT.    
A03707     MOVE 32                          TO WS-TRAN-COMMENT-LEN.     
A03707     MOVE '15'                        TO WS-TABLE-ID.             
A03707*                                                                         
A03707     ADD +1                           TO WS-TRAN-APPL-NO.         
A03707     MOVE 'CNT_STATUS_CD'             TO WS-COLUMN-DESC.          
A03707     MOVE 'B'                         TO WS-PRV-COLUMN-VALUE-TEXT.
A03707     MOVE 1                           TO WS-PRV-COLUMN-VALUE-LEN. 
A03707     MOVE 'C'                         TO WS-CHG-COLUMN-VALUE-TEXT.
A03707     MOVE 1                           TO WS-CHG-COLUMN-VALUE-LEN. 
A03707     PERFORM 5100-SET-MNT-TRANS-VARS  THRU 5100-EXIT              
A03707     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
A03707*                                                                         
A03707     ADD +1                           TO WS-TRAN-APPL-NO.         
A03707     MOVE 'STATUS_CHANGE_DT'          TO WS-COLUMN-DESC.          
A03707     MOVE '*INSERTED'                 TO WS-PRV-COLUMN-VALUE-TEXT.
A03707     MOVE 9                           TO WS-PRV-COLUMN-VALUE-LEN. 
A03707     MOVE WS-CURRENT-DATE             TO WS-CHG-COLUMN-VALUE-TEXT.
A03707     MOVE 10                          TO WS-CHG-COLUMN-VALUE-LEN. 
A03707     PERFORM 5100-SET-MNT-TRANS-VARS  THRU 5100-EXIT              
A03707     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
A03707*                                                                         
A03707     PERFORM 8000-UPDATE-CONTRACT     THRU 8000-EXIT.             
A03707     PERFORM 7020-SEL-ACTIVE-CNTS     THRU 7020-EXIT.             
A03707*                                                                         
A03707 5010-EXIT.                                                       
A03707     EXIT.                                                        
A03707*                                                                         
A03707*****************************************************************         
A03707* 5100-SET-MNT-TRANS-VARS                                      **         
A03707*****************************************************************         
A03707*                                                                         
A03707 5100-SET-MNT-TRANS-VARS.                                         
A03707*                                                                         
A03707     MOVE WS-CURRENT-TIMESTAMP        TO MH-TRANS-HIST-SEQ-NO.    
A03707     MOVE WS-CURRENT-DATE             TO MH-DATE-TRANS.           
A03707     MOVE 'F'                         TO MH-CODE-TRAN-TYPE.       
A03707     MOVE '998'                       TO MH-RESP-AREA-ID.         
A03707     MOVE RN-ACCOUNT-NO               TO MH-ACCOUNT-NO.           
A03707     MOVE 0                           TO MH-CUSTOMER-NO.          
A03707     MOVE 0                           TO MH-PREMISE-NO.           
A03707     MOVE 'SYSTEM'                    TO MH-USER-ID.              
A03707     MOVE WS-APPL-PROGRAM-ID          TO MH-APPL-PROGRAM-ID.      
A03707     MOVE WS-TRAN-COMMENT-TEXT        TO MH-TRAN-COMMENT-TEXT.    
A03707     MOVE WS-TRAN-COMMENT-LEN         TO MH-TRAN-COMMENT-LEN.     
A03707*                                                                         
A03707     MOVE WS-TABLE-ID                 TO MI-TABLE-ID.             
A03707     MOVE WS-CURRENT-TIMESTAMP        TO MI-TRANS-HIST-SEQ-NO.    
A03707     MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
A03707     MOVE WS-COLUMN-DESC              TO MI-COLUMN-DESC.          
A03707     MOVE WS-PRV-COLUMN-VALUE-TEXT    TO MI-PRV-COLUMN-VALUE-TEXT.
A03707     MOVE WS-PRV-COLUMN-VALUE-LEN     TO MI-PRV-COLUMN-VALUE-LEN. 
A03707     MOVE WS-CHG-COLUMN-VALUE-TEXT    TO MI-CHG-COLUMN-VALUE-TEXT.
A03707     MOVE WS-CHG-COLUMN-VALUE-LEN     TO MI-CHG-COLUMN-VALUE-LEN. 
A03707                                                                  
A03707 5100-EXIT.                                                       
A03707     EXIT.                                                        
A03707*                                                                         
A03707*****************************************************************         
A03707* 7001-OPEN-EW-REBATE-CNT                                      **         
A03707*****************************************************************         
A03707*                                                                         
A03707 7001-OPEN-EW-REBATE-CNT.                                         
A03707*                                                                         
A03707     EXEC SQL                                                     
A03707        OPEN EW_REBATE_CNT                                        
A03707     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03707*                                                                         
A03707     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A03707*                                                                         
A03707     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A03707        NEXT SENTENCE                                             
A03707     ELSE                                                         
A03707        MOVE 'CT'                TO WS-DB2-TABLE-ID               
A03707        MOVE 'OPEN'              TO WS-DB2-FUNCTION               
A03707        MOVE SQLCODE             TO WS-DB2-RETURN-CODE            
A03707        MOVE '200'               TO WS-DB2-MODULE-ID              
A03707        MOVE '7001'              TO WS-DB2-PARAGRAPH              
A03707        MOVE 12                  TO RETURN-CODE                   
A03707        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
A03707     END-IF.                                                      
A03707*                                                                         
A03707 7001-EXIT.                                                       
A03707     EXIT.                                                        
A03707*                                                                         
A03707*****************************************************************         
A03707* 7002-FETCH-EW-REBATE-CNT                                     **         
A03707*****************************************************************         
A03707*                                                                         
A03707 7002-FETCH-EW-REBATE-CNT.                                        
A03707*                                                                         
A03707     EXEC SQL                                                     
A03707        FETCH                                                     
A03707              EW_REBATE_CNT                                       
A03707         INTO                                                     
A03707              :AT-ACCOUNT-NO                                      
A03707             ,:AT-LOCAL-OFFICE                                    
A03707             ,:AT-CODES-DATA-PRESENT                              
A03707             ,:CT-CNT-ITEM-ID                                     
A03707             ,:CT-AMT-ORIG-ENTERED                                
A03707     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03707*                                                                         
A03707     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A03707*                                                                         
A03707     EVALUATE WS-ACTIVE-RETURN-CODE                               
A03707         WHEN SUCCESSFUL-CALL                                     
A03707              MOVE AT-ACCOUNT-NO TO CT-ACCOUNT-NO                 
A03707         WHEN NOT-FOUND                                           
A03707              MOVE 'Y'           TO WS-END-OF-DATA-FLAG           
A03707         WHEN OTHER                                               
A03707              MOVE 'CT'          TO WS-DB2-TABLE-ID               
A03707              MOVE 'FETCH'       TO WS-DB2-FUNCTION               
A03707              MOVE SQLCODE       TO WS-DB2-RETURN-CODE            
A03707              MOVE '200'         TO WS-DB2-MODULE-ID              
A03707              MOVE '7002'        TO WS-DB2-PARAGRAPH              
A03707              MOVE 12            TO RETURN-CODE                   
A03707              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
A03707     END-EVALUATE.                                                
A03707*                                                                         
A03707 7002-EXIT.                                                       
A03707     EXIT.                                                        
A03707*                                                                         
A03707*****************************************************************         
A03707* 7003-CLOSE-EW-REBATE-CNT                                     **         
A03707*****************************************************************         
A03707*                                                                         
A03707 7003-CLOSE-EW-REBATE-CNT.                                        
A03707*                                                                         
A03707     EXEC SQL                                                     
A03707        CLOSE EW_REBATE_CNT                                       
A03707     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03707*                                                                         
A03707     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A03707*                                                                         
A03707     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A03707        NEXT SENTENCE                                             
A03707     ELSE                                                         
A03707        MOVE 'CT'                TO WS-DB2-TABLE-ID               
A03707        MOVE 'CLOSE'             TO WS-DB2-FUNCTION               
A03707        MOVE SQLCODE             TO WS-DB2-RETURN-CODE            
A03707        MOVE '200'               TO WS-DB2-MODULE-ID              
A03707        MOVE '7003'              TO WS-DB2-PARAGRAPH              
A03707        MOVE 12                  TO RETURN-CODE                   
A03707        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
A03707     END-IF.                                                      
A03707*                                                                         
A03707 7003-EXIT.                                                       
A03707     EXIT.                                                        
A03707*                                                                         
A03707*****************************************************************         
A03707* 7010-SET-TIMESTAMP.                                          **         
A03707*****************************************************************         
A03707*                                                                         
A03707 7010-SET-TIMESTAMP.                                              
A03707*                                                                         
A03707     EXEC SQL                                                     
A03707          SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
A03707     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03707*                                                                         
A03707     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A03707*                                                                         
A03707     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
A03707        MOVE 'SET'               TO WS-DB2-FUNCTION               
A03707        MOVE SQLCODE             TO WS-DB2-RETURN-CODE            
A03707        MOVE '200'               TO WS-DB2-MODULE-ID              
A03707        MOVE '7010'              TO WS-DB2-PARAGRAPH              
A03707        MOVE 12                  TO RETURN-CODE                   
A03707        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
A03707     END-IF.                                                      
A03707*                                                                         
A03707 7010-EXIT.                                                       
A03707     EXIT.                                                        
A03707*                                                                         
A03707*****************************************************************         
A03707* 7020-SEL-ACTIVE-CNTS                                         **         
A03707* SELECTS NO. OF ACTIVE CONTRACTS                              **         
A03707*****************************************************************         
A03707*                                                                         
A03707 7020-SEL-ACTIVE-CNTS.                                            
A03707*                                                                         
A03707     EXEC SQL                                                     
A03707         SELECT COUNT(*)                                          
A03707           INTO :WS-NO-OF-CONTRACTS                               
A03707           FROM CSS_CONTRACT CT WITH(READUNCOMMITTED)                     
A03707          WHERE CT.ACCOUNT_NO        = :CT-ACCOUNT-NO             
A03707            AND CT.PYMT_PRIORITY_LVL = 100                        
A03707            AND CT.CNT_STATUS_CD     IN ('B','E')                 
A03707                                                           
A03707                                                      
A03707     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*          INTO :WS-NO-OF-CONTRACTS                                       
MFA-TR*          FROM CSS_CONTRACT CT                                           
MFA-TR*         WHERE CT.ACCOUNT_NO        = :CT-ACCOUNT-NO                     
MFA-TR*           AND CT.PYMT_PRIORITY_LVL = 100                                
MFA-TR*           AND CT.CNT_STATUS_CD     IN ('B','E')                         
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7020                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03707*                                                                         
A03707     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A03707*                                                                         
A03707     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
A03707        MOVE 'CT'                TO WS-DB2-TABLE-ID               
A03707        MOVE 'SELECT'            TO WS-DB2-FUNCTION               
A03707        MOVE SQLCODE             TO WS-DB2-RETURN-CODE            
A03707        MOVE '200'               TO WS-DB2-MODULE-ID              
A03707        MOVE '7020'              TO WS-DB2-PARAGRAPH              
A03707        MOVE CT-ACCOUNT-NO       TO WS-DB2-KEY-1                  
A03707        MOVE 12                  TO RETURN-CODE                   
A03707        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
A03707     END-IF.                                                      
A03707*                                                                         
A03707 7020-EXIT.                                                       
A03707     EXIT.                                                        
A02845*                                                                         
A02845*===============================================================*         
A02845 7100-SELECT-AUTOMATE-PREV-ALL.                                   
A02845*===============================================================*         
A02845                                                                  
A02845     EXEC SQL                                                     
A02845        SELECT MAX(AR1.DATE_TRANS)                                
A02845          INTO :WS-MAX-AR-DATE-TRANS :WS-DATE-TRANS-NULL           
A02845          FROM CSS_AR_TRANS_HIST AR1 WITH(READUNCOMMITTED),               
A02845               CSS_AR_TRANS_HIST AR2 WITH(READUNCOMMITTED)                
A02845        WHERE AR1.ACCOUNT_NO = :AT-ACCOUNT-NO                     
A02845          AND AR1.ACCOUNT_NO = AR2.ACCOUNT_NO                     
A02845          AND AR1.DATE_TRANS IN (IIF(TRY_CONVERT(DATE, 
                                                   :WS-DATE-BILL-DAY-00
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-BILL-DAY-00
              ) <> 0) OR (LEN(:WS-DATE-BILL-DAY-00
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-BILL-DAY-00
              ), CONVERT(DATE, :WS-DATE-BILL-DAY-00) ),            
A02845                                 IIF(TRY_CONVERT(DATE, 
                                                   :WS-DATE-BILL-DAY-30
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-BILL-DAY-30
              ) <> 0) OR (LEN(:WS-DATE-BILL-DAY-30
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-BILL-DAY-30
              ), CONVERT(DATE, :WS-DATE-BILL-DAY-30) ),            
A02845                                 IIF(TRY_CONVERT(DATE, 
                                                   :WS-DATE-BILL-DAY-60
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-BILL-DAY-60
              ) <> 0) OR (LEN(:WS-DATE-BILL-DAY-60
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-BILL-DAY-60
              ), CONVERT(DATE, :WS-DATE-BILL-DAY-60) ))            
A02845          AND AR2.DATE_TRANS > IIF(TRY_CONVERT(DATE, 
                                                   :WS-DATE-BILL-DAY-00
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-BILL-DAY-00
              ) <> 0) OR (LEN(:WS-DATE-BILL-DAY-00
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-BILL-DAY-00
              ), CONVERT(DATE, :WS-DATE-BILL-DAY-00) )               
A02845          AND AR1.CODE_TRAN_TYPE    = 'B'                         
A02845          AND AR2.CODE_TRAN_TYPE    = 'P'                         
A02845          AND AR2.AMT_BILLED_UNPAID < 0                           
A02845          AND (AR1.AMT_ORIG_ENTERED IN (:WS-AMT-UNUSED-CR,        
A02845                                        :AC-AMT-UNUSED-CR)        
A02845           OR AR1.AMT_BILLED_UNPAID IN (:WS-AMT-UNUSED-CR,        
A02845                                        :AC-AMT-UNUSED-CR) )      
A02845                                                           
A02845                                                      
A02845     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(AR1.DATE_TRANS)                                        
MFA-TR*         INTO :WS-MAX-AR-DATE-TRANS:WS-DATE-TRANS-NULL                   
MFA-TR*         FROM CSS_AR_TRANS_HIST AR1,                                     
MFA-TR*              CSS_AR_TRANS_HIST AR2                                      
MFA-TR*       WHERE AR1.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*         AND AR1.ACCOUNT_NO = AR2.ACCOUNT_NO                             
MFA-TR*         AND AR1.DATE_TRANS IN (:WS-DATE-BILL-DAY-00,                    
MFA-TR*                                :WS-DATE-BILL-DAY-30,                    
MFA-TR*                                :WS-DATE-BILL-DAY-60)                    
MFA-TR*         AND AR2.DATE_TRANS > :WS-DATE-BILL-DAY-00                       
MFA-TR*         AND AR1.CODE_TRAN_TYPE    = 'B'                                 
MFA-TR*         AND AR2.CODE_TRAN_TYPE    = 'P'                                 
MFA-TR*         AND AR2.AMT_BILLED_UNPAID < 0                                   
MFA-TR*         AND (AR1.AMT_ORIG_ENTERED IN (:WS-AMT-UNUSED-CR,                
MFA-TR*                                       :AC-AMT-UNUSED-CR)                
MFA-TR*          OR AR1.AMT_BILLED_UNPAID IN (:WS-AMT-UNUSED-CR,                
MFA-TR*                                       :AC-AMT-UNUSED-CR) )              
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02845                                                                  
A02845     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A02845                                                                  
A02845     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A02845        IF WS-DATE-TRANS-NULL < ZERO                              
A02845           MOVE 'N' TO WS-AUTOMATE-REFUND-SW                      
A02845           MOVE SPACES     TO  WS-MAX-AR-DATE-TRANS               
A02845        ELSE                                                      
A02845           MOVE 'Y' TO WS-AUTOMATE-REFUND-SW                      
A02845        END-IF                                                    
A02845     ELSE                                                         
A02845        MOVE 'AR'                TO WS-DB2-TABLE-ID               
A02845        MOVE 'SELECT'            TO WS-DB2-FUNCTION               
A02845        MOVE SQLCODE             TO WS-DB2-RETURN-CODE            
A02845        MOVE '200'               TO WS-DB2-MODULE-ID              
A02845        MOVE '7100'              TO WS-DB2-PARAGRAPH              
A02845        MOVE AT-ACCOUNT-NO       TO WS-DB2-KEY-1                  
A02845        MOVE 12                  TO RETURN-CODE                   
A02845        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
A02845     END-IF.                                                      
A02845                                                                  
A02845 7100-EXIT.                                                       
A02845     EXIT.                                                        
A02845*                                                                         
A02845*================================================================*        
A02845 7150-SELECT-FIN-WO-LPC.                                          
A02845*================================================================*        
A02845                                                                  
A02845     EXEC SQL                                                     
A02845        SELECT TOP(1) 'Y'                                                
A02845          INTO :WS-AUTOMATE-REFUND-SW                             
A02845          FROM CSS_FIN_WO_ACTION WITH(READUNCOMMITTED)                    
A02845         WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                 
A02845           AND FW_ACTION_TYPE_CD = 'LPC'                          
A02845           AND FW_ACTION_AM      > 0                              
A02845                                       
A02845                                                      
A02845     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15320000
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-AUTOMATE-REFUND-SW                                     
MFA-TR*         FROM CSS_FIN_WO_ACTION                                          
MFA-TR*        WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                         
MFA-TR*          AND FW_ACTION_TYPE_CD = 'LPC'                                  
MFA-TR*          AND FW_ACTION_AM      > 0                                      
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*        QUERYNO 7150                                                     
MFA-TR*    END-EXEC.                                                    15360000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02845                                                                  
A02845     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A02845                                                                  
A02845     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A02845        CONTINUE                                                  
A02845     ELSE                                                         
A02845        MOVE 'KD'                TO WS-DB2-TABLE-ID               
A02845        MOVE 'SELECT'            TO WS-DB2-FUNCTION               
A02845        MOVE SQLCODE             TO WS-DB2-RETURN-CODE            
A02845        MOVE '200'               TO WS-DB2-MODULE-ID              
A02845        MOVE '7150'              TO WS-DB2-PARAGRAPH              
A02845        MOVE AT-ACCOUNT-NO       TO WS-DB2-KEY-1                  
A02845        MOVE 12                  TO RETURN-CODE                   
A02845        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
A02845     END-IF.                                                      
A02845                                                                  
A02845 7150-EXIT.                                                       
A02845     EXIT.                                                        
A02845*                                                                         
      *****************************************************************         
      **    6240-GET-FCA00-COMMON-DATE                               **         
      **                                                             **         
      **      IF NECESSARY, COPYBOOK CPD00040 RETRIEVES THE COMMON   **         
      **      DATE FROM TABLE CSS_JOB_PARM.                          **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00040                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **    6251-GET-FJC01-DATE                                      **         
      **                                                             **         
      **      THIS COPYBOOK, CPD00037, CONTAINS THE DB2 STATEMENTS   **         
      **      NECESSARY TO RETRIEVE PARAMETERS FROM TABLE CSS_JOB_   **         
      **      PARM.                                                  **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00037                                                   
           END-EXEC.                                                            
      *                                                                         
A03707*****************************************************************         
A03707**    6530-LOAD-MNT-TRANS-HIST                                 **         
A03707*****************************************************************         
A03707*                                                                         
A03707     EXEC SQL                                                             
A03707        INCLUDE CPD00067                                                  
A03707     END-EXEC.                                                            
A03707*                                                                         
      *****************************************************************         
      **    7600-START-FCSJC01                                       **         
      **                                                             **         
      **      COPYBOOK CPD00038 IS UTILIZED IN THE PARAMETER         **         
      **      RETRIEVAL FROM CSS_JOB_PARM.                           **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00038                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **    7620-START-FCSCA00                                       **         
      **                                                             **         
      **      COPYBOOK CPD00039 IS UTILIZED IN THE PARAMETER         **         
      **      RETRIEVAL FROM CSS_JOB_PARM.                           **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00039                                                   
           END-EXEC.                                                            
      *                                                                         
A03707******************************************************************15550000
A03707**    8000-UPDATE-CONTRACT                                      **15560000
A03707**    CLOSE THE ONE-TIME CONTRACT.                              **15580000
A03707******************************************************************15610000
A03707*                                                                 15540000
A03707 8000-UPDATE-CONTRACT.                                            
A03707*                                                                         
A03707     EXEC SQL                                                     
A03707        UPDATE CSS_CONTRACT                                       
A03707           SET CNT_STATUS_CD = 'C'                                
A03707              ,STATUS_CHANGE_DT = IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )                
A03707              ,LAST_UPDATE_TS   = CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              )           
A03707         WHERE ACCOUNT_NO        = :CT-ACCOUNT-NO                 
A03707           AND PYMT_PRIORITY_LVL = 100                            
A03707           AND CNT_ITEM_ID       = :CT-CNT-ITEM-ID                
A03707     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     15630000
MFA-TR*       UPDATE CSS_CONTRACT                                       15640000
MFA-TR*          SET CNT_STATUS_CD = 'C'                                15650000
MFA-TR*             ,STATUS_CHANGE_DT = :WS-CURRENT-DATE                15650000
MFA-TR*             ,LAST_UPDATE_TS   = :WS-CURRENT-TIMESTAMP           15650000
MFA-TR*        WHERE ACCOUNT_NO        = :CT-ACCOUNT-NO                 15660000
MFA-TR*          AND PYMT_PRIORITY_LVL = 100                            15660000
MFA-TR*          AND CNT_ITEM_ID       = :CT-CNT-ITEM-ID                15660000
MFA-TR*    END-EXEC.                                                    16220000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03707*                                                                         
A03707     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A03707*                                                                         
A03707     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A03707        NEXT SENTENCE                                             
A03707     ELSE                                                         
A03707        MOVE 'CT'             TO  WS-DB2-TABLE-ID                 
A03707        MOVE 'UPDATE'         TO  WS-DB2-FUNCTION                 
A03707        MOVE SQLCODE          TO  WS-DB2-RETURN-CODE              
A03707        MOVE '200'            TO  WS-DB2-MODULE-ID                
A03707        MOVE '8000'           TO  WS-DB2-PARAGRAPH                
A03707        MOVE RN-ACCOUNT-NO    TO  WS-DB2-KEY-1N                   
A03707        MOVE 16               TO  RETURN-CODE                     
A03707        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
A03707     END-IF.                                                      
A03707*                                                                         
A03707 8000-EXIT.                                                       
A03707     EXIT.                                                        
A03707*                                                                         
      ******************************************************************30860000
      *    BYPASS ONLINE ERROR PROCESSING                            ** 30870000
      *     -NOTE:  THIS PARAGRAPH NEEDED BY CPD0023C                **         
      ******************************************************************30880000
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           GO TO 9000-EXIT.                                             
      *                                                                         
      ****************************************************************          
      **   9000-TERMINATE                                           **          
      **                                                            **          
      **       CLOSES ALL OPEN FILES.                               **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           PERFORM 9100-CLOSE-FINALED-ACCT THRU 9100-EXIT.              
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15540000
      ******************************************************************15550000
      **    9100-CLOSE-FINALED-ACCT.                                  **15560000
      **                                                              **15570000
      **    CLOSE CURSOR FINALED_ACCT                                 **15580000
      **                                                              **15570000
      ******************************************************************15610000
      *                                                                 15540000
       9100-CLOSE-FINALED-ACCT.                                         
                                                                        
           EXEC SQL                                                     
              CLOSE FINALED_ACCT                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND OR -501            
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*************************************'           
              DISPLAY '**    PCSCA200 PROCESSING ERROR    **'           
              DISPLAY '*************************************'           
              DISPLAY '** DB2 PARAGRAPH = 9100'                         
              DISPLAY '**  DB2 FUNCTION = CLOSE'                        
              DISPLAY '**  DB2 TABLE-ID = AT'                           
              DISPLAY '**       SQLCODE = ' SQLCODE                     
              DISPLAY '**     DB2 KEY 1 = ' AT-ACCOUNT-NO               
              DISPLAY '**     DB2 KEY 2 = '                             
              MOVE 12                  TO  RETURN-CODE                  
           END-IF.                                                      
                                                                        
       9100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 00926800
      **  - - - >   W A R N I N G           W A R N I N G   < - - -  ** 01010000
      **  - - - >                                           < - - -  ** 01010000
      **  - - - >         DON'T MOVE THIS PARAGRAPH.        < - - -  ** 01010000
      **  - - - >         THIS PROGRAM REQUIRES THAT        < - - -  ** 01010000
      **  - - - >         9900-SQL-ERROR-ROUTINE            < - - -  ** 01010000
      **  - - - >         BE POSITIONED RIGHT BEFORE        < - - -  ** 01010000
      **  - - - >         9900-ABEND                        < - - -  ** 01010000
      **                                                             ** 00926900
      **    9900-SQL-ERROR-ROUTINE                                   ** 00993000
      **  MODULE FOR PROCESSING SQL ERRORS ENCOUNTERED DURING        ** 00993100
      **  PROGRAM EXECUTION                                          ** 00993200
      **                                                             ** 00994000
      ***************************************************************** 00995000
       9900-SQL-ERROR-ROUTINE.                                          
                                                                        
           DISPLAY '*************************************'.             
           DISPLAY '**    PCSCA200 PROCESSING ERROR    **'.             
           DISPLAY '*************************************'.             
                                                                        
           IF WS-DB2-PARAGRAPH > SPACES                                 
               DISPLAY '** DB2 PARAGRAPH = ' WS-DB2-PARAGRAPH           
           ELSE                                                         
             IF ACTIVE-PARAGRAPH > SPACES                               
                 DISPLAY '**     PARAGRAPH = ' ACTIVE-PARAGRAPH         
             END-IF                                                     
           END-IF.                                                      
                                                                        
           IF WS-DB2-FUNCTION > SPACES                                  
               DISPLAY '**  DB2 FUNCTION = ' WS-DB2-FUNCTION            
           ELSE                                                         
             IF ABEND-FUNCTION > SPACES                                 
                 DISPLAY '**      FUNCTION = ' ABEND-FUNCTION           
             END-IF                                                     
           END-IF.                                                      
                                                                        
           IF WS-DB2-TABLE-ID > SPACES                                  
               DISPLAY '**  DB2 TABLE-ID = ' WS-DB2-TABLE-ID            
           ELSE                                                         
             IF TABLE-1 > SPACES                                        
                 DISPLAY '**      TABLE-ID = ' TABLE-1                  
             END-IF                                                     
           END-IF.                                                      
                                                                        
           DISPLAY '**       SQLCODE = ' WS-DB2-RETURN-CODE             
           DISPLAY '**     DB2 KEY 1 = ' WS-DB2-KEY-1                   
           DISPLAY '**     DB2 KEY 2 = ' WS-DB2-KEY-2                   
           DISPLAY '**     DB2 KEY 3 = ' WS-DB2-KEY-3                   
           DISPLAY '**     DB2 KEY 4 = ' WS-DB2-KEY-4                   
                                                                        
           DISPLAY '*************************************'.             
                                                                        
      ***************************************************************** 01002000
      **  - - - >   W A R N I N G           W A R N I N G   < - - -  ** 01010000
      **  - - - >                                           < - - -  ** 01010000
      **  - - - >         DON'T MOVE THIS PARAGRAPH.        < - - -  ** 01010000
      **  - - - >         THIS PROGRAM REQUIRES THAT        < - - -  ** 01010000
      **  - - - >         9900-SQL-ERROR-ROUTINE            < - - -  ** 01010000
      **  - - - >         BE POSITIONED RIGHT BEFORE        < - - -  ** 01010000
      **  - - - >         9900-ABEND                        < - - -  ** 01010000
      **                                                             ** 01010000
      **                                                             ** 01010000
      **    9900-ABEND                                               ** 01020000
      **  COMMON PROCEDURE DIVISION FOR ABEND PROCESSING             ** 01021000
      **                                                             ** 01030000
      ***************************************************************** 01040000
           EXEC SQL                                                     01060000
             INCLUDE CPD09900                                           01070000
           END-EXEC.                                                    01080000
                                                                        
      *                                                                         
      ****************************************************************          
      **   9700-PROCESS-ABEND.                                      **          
      ****************************************************************          
           EXEC SQL                                                     01100005
             INCLUDE CPD0023C                                           01110005
           END-EXEC.                                                    01120005
      *                                                                 01130005
