       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA195.                                        
       DATE-WRITTEN.   JAN, 2009.                                       
       DATE-COMPILED.                                                   
      ***************************************************************** 00050000
      ********            CUSTOMER SERVICE SYSTEM             ********* 00120000
      ********                      DB2                       ********* 00130000
      ***************************************************************** 00140000
      **                                                             ** 00150000
      **              PROGRAM  MODIFICATION  LOG                     ** 00160000
      **    DATE    INITIALS     REASON                              ** 00170000
      **    ____    ________     ______                              ** 00180000
PRJ526** 01/30/09    AP40911     INITIAL REQUEST.                    ** 00190000
PRJ526** 10/22/09    AP40911     DATE LOGIC IS CHANGED TO PICK THE   **         
PRJ526**                         ACCOUNTS THAT ARE TO BE DRAFTED THE **         
PRJ526**                         NEXT DAY.                           **         
PRJ526** 12/22/09    AP40911     CHANGE DATE BILL DATE 00 TO 90      **         
      ***************************************************************** 00400000
                                                                        
      *================================================================*00420000
      ******************************************************************00430000
      *               P R O G R A M  S U M M A R Y                     *        
      *                                                                *00440000
      *   PCSCA195 WILL RETRIEVE BANKDRAFT/EDRAFT ACCOUNTS FROM        *00450000
      *   PENDING BANK DRAFT TABLE WHERE THE DRATF AMOUNT IS GREATER   *00460000
      *   THAN THE TOTAL AR BALANCE.THEN THE DRAFT AMOUNT WILL BE      *00470000
      *   UPDATED TO AR BALANCE.IF THE AR BALANCE IS LESS THAN OR EQUAL*00480000
      *   TO ZERO THE DRAFT WILL BE PREVENTED AND REPORT IS GENERATED. *        
      *   NO ACTION WILL BE TAKEN IF A VOUCHER PAYMENT CAME IN AFTER   *        
      *   THE DATE BILL DAY 90.                                        *        
      *================================================================*00500000
                                                                        
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT FCSPT33-FILE                                          
             ASSIGN TO UT-S-FCSPT33                                     
             FILE STATUS IS WS-FCSPT33-STATUS.                          
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
      ******************************************************************        
      *  CFDPT33 - FD SECTION & LAYOUT FOR REPORT OUTPUT FILE          *        
      ******************************************************************        
       COPY CFDPT33.                                                            
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA195'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-CURRENT-DATE.                                             
           05  WS-CURRENT-YY                 PIC 9(02).                 
           05  WS-CURRENT-MM                 PIC 9(02).                 
           05  WS-CURRENT-DD                 PIC 9(02).                 
                                                                        
       01  WS-CURRENT-TIME                   PIC 9(08).                 
       01  WS-MISC.                                                     
PRJ526*    05 WS-NEXT-BUSINES-DATE    PIC X(10).                                
           05 WS-CURRENT-TS           PIC X(26)      VALUE SPACES.      
           05 WS-ABEND-PARAGRAPH      PIC XXXX       VALUE SPACES.      
           05 WS-SQLCODE              PIC --------9.                    
           05 WS-DELINQ-CODE          PIC X(10) VALUE 'REP-OR-UPD'.     
COB305     05 WS-DELINQ-VALUE        PIC S9(9)V9(5) USAGE COMP-3 
COB305       VALUE 0.      
           05 WS-FCSPT33-STATUS       PIC X(02).                        
               88  FCSPT33-SUCCESSFUL             VALUE '00'.           
           05 WS-RPT1-PAGE-NO         PIC 9(04)    VALUE 0.             
           05 WS-RPT1-LINE-NO         PIC 9(02)       VALUE 0.          
COB305     05 WS-UPDATE-AMT        PIC S9(11)V9(2) USAGE COMP-3 VALUE 0.     
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-Y                    PIC X(01)  VALUE 'Y'.            
           05  WS-N                    PIC X(01)  VALUE 'N'.            
           05  WS-YES                  PIC X(01)  VALUE 'Y'.            
           05  WS-NO                   PIC X(01)  VALUE 'N'.            
           05  WS-PGRMNAME             PIC X(10)  VALUE 'PCSCA195  '.   
           05  PROGRAM-NAME            PIC X(08)  VALUE 'PCSCA195'.     
           05  WS-DRFT-AMT-COMMENT     PIC X(29)  VALUE                 
              'AUTOMATIC DRAFT AMOUNT UPDATE'.                          
           05  WS-APPL-PRG-ID          PIC X(08)     VALUE 'PCSCA195'.  
           05  WS-F                    PIC X(01)     VALUE 'F'.         
COB305     05 WS-PB-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.        
COB305     05 WS-PB-DRAFT-AMT        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.     
           05  WS-PB-DRAFT-DATE        PIC X(10)    VALUE SPACES.       
COB305     05 WS-AT-TOTAL-AR-BALANCE        PIC S9(11)V9(2) 
COB305       USAGE COMP-3 VALUE 0.    
COB305     05 WS-DRAFT-AMOUNT        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.     
           05  WS-PRE-DRFT-AMT         PIC  -ZZZ,ZZZ,ZZ9.99.            
           05  WS-CUR-DRFT-AMT         PIC  -ZZZ,ZZZ,ZZ9.99.            
                                                                        
       01 WS-SWITCHES.                                                  
           05  WS-OPEN-CUR              PIC X(01)    VALUE 'N'.         
           05  WS-NOT-FIRST-TIME        PIC X(01)    VALUE 'N'.         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADERS        **          
      ****************************************************************          
      *                                                                         
       01  WS-HEADER-LINES.                                             
           05  WS-RPT-HEADER-1.                                         
               10  FILLER                    PIC X(02)  VALUE SPACES.   
               10  P-RPT-TITLE-PGNM          PIC X(08)  VALUE           
                                                         'PCSCA195'.    
               10  FILLER                    PIC X(40)  VALUE SPACES.   
               10  P-RPT-COMP-NAME           PIC X(39)  VALUE SPACES.   
               10  FILLER                    PIC X(26)  VALUE SPACES.   
               10  FILLER                    PIC X(09)  VALUE           
                                                       'RUN-DATE:'.     
               10  P-RPT-RUN-MM              PIC X(02).                 
               10  FILLER                    PIC X(01)  VALUE '/'.      
               10  P-RPT-RUN-DD              PIC X(02).                 
               10  FILLER                    PIC X(01)  VALUE '/'.      
               10  P-RPT-RUN-YY              PIC X(02).                 
           05  WS-RPT-HEADER-2.                                         
               10  FILLER                    PIC X(02)  VALUE SPACES.   
               10  FILLER                    PIC X(05)  VALUE 'DATE:'.  
               10  P-REP-MM                  PIC X(02).                 
               10  FILLER                    PIC X(01)     VALUE '/'.   
               10  P-REP-DD                  PIC X(02).                 
               10  FILLER                    PIC X(01)     VALUE '/'.   
               10  P-REP-YY                  PIC X(02).                 
               10  FILLER                    PIC X(35)  VALUE SPACES.   
               10  FILLER                    PIC X(61)  VALUE           
                    'AUTOMATIC DRAFT AMOUNT UPDATE REPORT'.             
               10  FILLER                    PIC X(04)  VALUE SPACES.   
               10  FILLER                    PIC X(09)  VALUE           
                                                      'RUN-TIME:'.      
               10  WS-REP-HH                 PIC X(02).                 
               10  FILLER                    PIC X(01)  VALUE ':'.      
               10  WS-REP-MIN                PIC X(02).                 
               10  FILLER                    PIC X(01)  VALUE ':'.      
               10  WS-REP-SS                 PIC X(02).                 
                                                                        
           05  WS-RPT-HEADER-3.                                         
               10  FILLER              PIC X(113)   VALUE SPACES.       
               10  FILLER              PIC X(06)    VALUE 'PAGE: '.     
               10  P-RPT-PAGE-NO       PIC ZZ,ZZZ.                      
               10  FILLER              PIC X(07)    VALUE SPACES.       
      *                                                                         
       01  WS-PRINT-REP-HDR-1.                                          
           05  FILLER                  PIC X(02)  VALUE SPACES.         
           05  FILLER                  PIC X(09)    VALUE               
                                       'ACCNT NBR'.                     
           05  FILLER                  PIC X(10)    VALUE SPACES.       
           05  FILLER                  PIC X(10)    VALUE               
                                       'DRAFT DATE'.                    
           05  FILLER                  PIC X(07)    VALUE SPACES.       
           05  FILLER                  PIC X(12)    VALUE               
                                       'DRAFT AMOUNT'.                  
           05  FILLER                  PIC X(08)    VALUE SPACES.       
           05  FILLER                  PIC X(10)    VALUE               
                                       'AR BALANCE'.                    
           05  FILLER                  PIC X(08)    VALUE SPACES.       
           05  FILLER                  PIC X(13)    VALUE               
                                       'UPDATE AMOUNT'.                 
           05  FILLER                  PIC X(13)    VALUE SPACES.       
           05  FILLER                  PIC X(31)    VALUE SPACES.       
      *                                                                         
       01  WS-PRINT-REP-HDR-2.                                          
           05  FILLER                  PIC X(132)   VALUE '*'.          
                                                                        
      *                                                                         
       01  WS-PRINT-REP-DET-1.                                          
           05  FILLER                  PIC X(02)    VALUE SPACES.       
           05  P-RPT1-ACC-NUMB         PIC X(13)    VALUE SPACES.       
           05  FILLER                  PIC X(08)    VALUE SPACES.       
           05  P-RPT1-DRF-DATE         PIC X(10)    VALUE SPACES.       
           05  FILLER                  PIC X(01)    VALUE SPACES.       
           05  P-RPT1-DRF-AMT          PIC ZZZ,ZZ9.99   VALUE ZEROES.   
           05  FILLER                  PIC X(10)      VALUE SPACES.     
           05  P-RPT1-AR-BALANCE       PIC Z(09).99-.                   
           05  FILLER                  PIC X(08)       VALUE SPACES.    
           05  P-RPT1-UPDATE-AMT       PIC Z(09).99-.                   
           05  FILLER                  PIC X(05)    VALUE SPACES.       
           05  FILLER                  PIC X(40)    VALUE SPACES.       
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '** NO DATA THIS RUN **'.                          
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  WS-END-DATA-LINE.                                            
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                    '*** END OF REPORT ***'.                            
           05  FILLER                  PIC X(55)    VALUE SPACES.       
                                                                        
                                                                        
                                                                        
       COPY CWS00010.                                                           
           COPY FIOCA00.                                                03009000
           COPY FIOJC01.                                                03010000
       COPY CWS00303.                                                           
       COPY CWS00039.                                                   01300000
       COPY CWS00038.                                                   01320000
       COPY CWS09900.                                                   01260000
PRJ526****** CWS00315 CONTAINS WS FOR FINDING NEXT BUSINESS DAY ****    02960000
PRJ526     EXEC SQL                                                     02970000
PRJ526         INCLUDE CWS00315                                         02980000
PRJ526     END-EXEC.                                                    02990000
                                                                        
                                                                        
      ****************************************************************          
      *     SQL COMMUNICATION AREA                                   *          
      ****************************************************************          
           EXEC SQL                                                     03130000
               INCLUDE SQLCA                                            03140000
           END-EXEC.                                                    03150000
                                                                        
      ****************************************************************          
      *    CSS_JOB_PARM - G6                                         *          
      ****************************************************************          
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
                                                                        
PRJ526******************************************************************        
PRJ526**   CSS_HOLIDAY - J8                                           **        
PRJ526******************************************************************        
PRJ526*                                                                         
           EXEC SQL                                                     03210000
               INCLUDE TBHLDAY                                          03220000
           END-EXEC.                                                    03230000
                                                                        
      ****************************************************************          
      * CSS_COMPANY - C7                                            *   05370000
      ****************************************************************          
                                                                        
           EXEC SQL                                                     05390000
             INCLUDE TBCOMPNY                                           05400000
           END-EXEC.                                                    05410000
                                                                        
      ****************************************************************          
      *     CSS_ACCOUNT - AT                                         *          
      ****************************************************************          
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_MT_TRN_HST_DET - MI                                    *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBMNHDT                                                     
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_MNT_TRANS_HIST - MH                                    *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBMNHIST                                                    
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_DELINQUENCY -C8                                                  
      *===============================================================*         
             EXEC SQL                                                           
                INCLUDE TBDELQ                                                  
             END-EXEC.                                                          
                                                                        
      *===============================================================*         
      *    CSS_LIEAP - LI                                             *         
      *===============================================================*         
             EXEC SQL                                                           
                INCLUDE TBLIEAP                                                 
             END-EXEC.                                                          
                                                                        
      ****************************************************************          
      *     CSS_PNDNG_BNK_DRFT - PB                                  *          
      ****************************************************************          
           EXEC SQL                                                             
             INCLUDE TBPDBKDF                                                   
           END-EXEC.                                                            
                                                                        
                                                                        
           EXEC SQL                                                     
                DECLARE PNDNG_DRAFT_CUR CURSOR WITH HOLD FOR            
                SELECT   PB.DRAFT_AMT                                   
                        ,PB.ACCOUNT_NO                                  
                        ,PB.DRAFT_DATE                                  
                        ,PB.TRANSACTION_CD                              
                        ,PB.CODE_SOURCE_ID                              
                        ,PB.PYMT_POSTED_FL                              
                        ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           PB.PYMT_TRANS_TS, 121), ' ', '-'), ':', '.') PYMT_TRANS_TS          
                        ,PB.CUST_BANK_SEQ_NO                            
                        ,AT.ACCOUNT_NO                                  
                        ,AT.TOTAL_AR_BALANCE                            
                        ,AT.COMPANY_NO                                  
              FROM CSS_PNDNG_BNK_DRFT PB WITH(READUNCOMMITTED)                  
                  ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                         
             WHERE PB.ACCOUNT_NO = AT.ACCOUNT_NO                        
PRJ526         AND PB.DRAFT_DATE <= IIF(TRY_CONVERT(DATE, 
                                                   :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) )                
               AND PB.CODE_SOURCE_ID IN ('I','S')                       
               AND PB.DRAFT_AMT > AT.TOTAL_AR_BALANCE                   
               AND PB.ACCOUNT_NO NOT IN                                 
PRJ526            (SELECT DISTINCT(LI.ACCOUNT_NO)                       
                   FROM CSS_LIEAP LI WITH(READUNCOMMITTED)                      
                   WHERE LI.ACCOUNT_NO = PB.ACCOUNT_NO                  
PRJ526               AND CAST(LI.VOUCHER_PAY_DT AS DATE) >= 
           AT.DATE_BILL_DAY_90)
               FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     03890000
MFA-TR*         DECLARE PNDNG_DRAFT_CUR CURSOR WITH HOLD FOR            03900000
MFA-TR*         SELECT   PB.DRAFT_AMT                                           
MFA-TR*                 ,PB.ACCOUNT_NO                                          
MFA-TR*                 ,PB.DRAFT_DATE                                          
MFA-TR*                 ,PB.TRANSACTION_CD                                      
MFA-TR*                 ,PB.CODE_SOURCE_ID                                      
MFA-TR*                 ,PB.PYMT_POSTED_FL                                      
MFA-TR*                 ,PB.PYMT_TRANS_TS                                       
MFA-TR*                 ,PB.CUST_BANK_SEQ_NO                                    
MFA-TR*                 ,AT.ACCOUNT_NO                                          
MFA-TR*                 ,AT.TOTAL_AR_BALANCE                                    
MFA-TR*                 ,AT.COMPANY_NO                                          
MFA-TR*       FROM CSS_PNDNG_BNK_DRFT PB                                        
MFA-TR*           ,CSS_ACCOUNT AT                                               
MFA-TR*      WHERE PB.ACCOUNT_NO = AT.ACCOUNT_NO                                
MFA-TR*        AND PB.DRAFT_DATE <= :WS-NEW-BUSINESS-DAY                        
MFA-TR*        AND PB.CODE_SOURCE_ID IN ('I','S')                               
MFA-TR*        AND PB.DRAFT_AMT > AT.TOTAL_AR_BALANCE                           
MFA-TR*        AND PB.ACCOUNT_NO NOT IN                                         
MFA-TR*           (SELECT DISTINCT(LI.ACCOUNT_NO)                               
MFA-TR*            FROM CSS_LIEAP LI                                            
MFA-TR*            WHERE LI.ACCOUNT_NO = PB.ACCOUNT_NO                          
MFA-TR*              AND DATE(LI.VOUCHER_PAY_DT) >= AT.DATE_BILL_DAY_90)        
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                    04020000
                                                                        
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
      *****************************************************************         
      * 0000-MAINLINE                                                 *         
      *    THE MAIN PROCESSING OF PROGRAM                             *         
      *****************************************************************         
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE              THRU 0100-EXIT.         
           PERFORM 7000-OPEN-PNDNG-DRAFT-CUR    THRU 7000-EXIT.         
           PERFORM 7100-FETCH-PNDNG-DRAFT-CUR   THRU 7100-EXIT          
                       UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.         
           PERFORM 7200-CLOSE-PNDNG-DRAFT-CUR THRU 7200-EXIT.           
           IF WS-NOT-FIRST-TIME = 'N'                                   
              PERFORM 8300-NO-DATA-PARA THRU 8300-EXIT                  
           END-IF                                                       
           PERFORM 8500-END-DATA-PARA THRU 8500-EXIT.                   
             STOP RUN.                                                  
       0000-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 0100-INITIALIZE                                               *         
      *  THIS PROCEDURE OPENS THE FILES, ACCEPTS SYSTEM DATE & TIME   *         
      *****************************************************************         
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'  TO WS-ABEND-PARAGRAPH.                          
              OPEN OUTPUT FCSPT33-FILE.                                 
              IF FCSPT33-SUCCESSFUL                                     
                NEXT SENTENCE                                           
              ELSE                                                      
              MOVE WS-FCSPT33-STATUS         TO  WS-SQLCODE             
              DISPLAY '*============================================*'  
              DISPLAY '*==========      PCSCA195       =============*'  
              DISPLAY '*============================================*'  
              DISPLAY '*  PARAGRAPH: ' WS-ABEND-PARAGRAPH               
                      '                           *'                    
              DISPLAY '*  SQLCODE..: ' WS-SQLCODE                       
                      '                     *'                          
              DISPLAY '*  ERROR IN OPENING FCSPT33 FILE.'               
                      '                     *'                          
              DISPLAY '*============================================*'  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
      * GET CURRENT DATE                                                        
                                                                        
           ACCEPT WS-CURRENT-DATE          FROM DATE.                   
           MOVE   WS-CURRENT-YY            TO   P-RPT-RUN-YY.           
           MOVE   WS-CURRENT-MM            TO   P-RPT-RUN-MM.           
           MOVE   WS-CURRENT-DD            TO   P-RPT-RUN-DD.           
                                                                        
      * GET CURRENT TIME                                                        
                                                                        
           ACCEPT WS-CURRENT-TIME          FROM TIME.                   
           MOVE   WS-CURRENT-TIME(1:2)     TO   WS-REP-HH.              
           MOVE   WS-CURRENT-TIME(3:2)     TO   WS-REP-MIN.             
           MOVE   WS-CURRENT-TIME(5:2)     TO   WS-REP-SS.              
              PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.               
                                                                        
              IF COMMON-DATE-NEEDED                                     
                 MOVE 'COMMONDATE'         TO WS-PGRMNAME               
                 MOVE SPACES               TO WS-INPUT-AREA             
                 MOVE SPACES               TO                           
                                              WS-INPUT-DATA-BREAKDOWN   
                 PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT      
                 DISPLAY 'FCA00-COMMON-DATE = ' WS-FCA00-COMMON-DATE    
                 MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE             
                 MOVE PROGRAM-NAME         TO WS-PGRMNAME               
              END-IF                                                    
                                                                        
PRJ526*       MOVE WS-INPUT-DATE TO WS-TODAYS-DATE.                     05270000
PRJ526        MOVE WS-INPUT-DATE TO WS-NEW-BUSINESS-DAY.                
              MOVE WS-INPUT-DATE(3:2)      TO P-REP-YY.                 
              MOVE WS-INPUT-DATE(6:2)      TO P-REP-MM.                 
              MOVE WS-INPUT-DATE(9:2)      TO P-REP-DD.                 
PRJ526        PERFORM 6500-GET-NEXT-BUSINESS-DAY                        
PRJ526                     THRU 6500-NEXT-BUSINESS-DAY-EXIT             
PRJ526               UNTIL NEXT-BUSINESS-DAY-FOUND                      
PRJ526*       MOVE WS-NEW-BUSINESS-DAY TO WS-NEXT-BUSINES-DATE.                 
PRJ526        DISPLAY 'NEXT BUSINESS DAY=' WS-NEW-BUSINESS-DAY.         
              PERFORM 7225-SELECT-COMPANY-NAME THRU 7225-EXIT.          
                MOVE  C7-COMPANY-NAME  TO P-RPT-COMP-NAME.              
              PERFORM 7250-GET-DELINQUENCY THRU 7250-EXIT.              
       0100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 5000-PROCESS-ACCOUNT                                           *        
      ******************************************************************        
       5000-PROCESS-ACCOUNT.                                            
                                                                        
           MOVE '5000'  TO WS-ABEND-PARAGRAPH.                          
               MOVE PB-ACCOUNT-NO        TO WS-PB-ACCOUNT-NO.           
               MOVE PB-DRAFT-AMT         TO WS-PB-DRAFT-AMT             
                                          , WS-PRE-DRFT-AMT.            
               MOVE PB-DRAFT-DATE        TO WS-PB-DRAFT-DATE.           
               MOVE AT-TOTAL-AR-BALANCE  TO WS-AT-TOTAL-AR-BALANCE      
                                          , WS-CUR-DRFT-AMT.            
               IF WS-DELINQ-VALUE = 1                                   
                  IF AT-TOTAL-AR-BALANCE <= 0                           
                     PERFORM 7500-DELETE-PNDNG-DRAFT-ROW  THRU 7500-EXIT
                  ELSE                                                  
                     PERFORM 7300-UPDATE-DRAFT-AMOUNT     THRU 7300-EXIT
                  END-IF                                                
               ELSE                                                     
                  NEXT SENTENCE                                         
               END-IF.                                                  
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 08880000
      *    6240-GET-FCA00-COMMON-DATE.                               ** 08890000
      *                                                              ** 08900000
      *    COPYBOOK CPD00040 CONTAINS THE LOGIC FOR FINDING          ** 08910000
      *    THE COMMON DATE.                                          ** 08920000
      ***************************************************************** 08930000
                                                                        
       COPY CPD00040.                                                   08850000
                                                                        
      ***************************************************************** 08880000
      *    6251-GET-FJC01-DATE                                       ** 08890000
      *                                                              ** 08900000
      *    COPYBOOK CPD00037 CONTAINS THE LOGIC FOR FINDING THE      ** 08910000
      *    OVERRIDE DATE.                                            ** 08920000
      ***************************************************************** 08930000
                                                                        
       COPY CPD00037.                                                   08860000
                                                                        
PRJ526***************************************************************** 08880000
PRJ526*    6500-GET-NEXT-BUSINESS-DAY                                ** 08890000
PRJ526*                                                              ** 08900000
PRJ526*    COPYBOOK CPD00315 CONTAINS THE LOGIC FOR FINDING          ** 08910000
PRJ526*    THE NEXT BUSINESS DAY.                                    ** 08920000
PRJ526***************************************************************** 08930000
PRJ526*                                                                 08940000
PRJ526     EXEC SQL                                                     08950000
PRJ526         INCLUDE CPD00315                                         08960000
PRJ526     END-EXEC.                                                    08970000
                                                                        
      *****************************************************************         
      * 7000-OPEN-PNDNG-DRAFT-CUR                                     *         
      *****************************************************************         
       7000-OPEN-PNDNG-DRAFT-CUR.                                       
                                                                        
           MOVE '7000'  TO WS-ABEND-PARAGRAPH.                          
                                                                        
           EXEC SQL                                                     
                OPEN PNDNG_DRAFT_CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-Y               TO  WS-OPEN-CUR                   
           ELSE                                                         
              MOVE SQLCODE TO WS-SQLCODE                                
              DISPLAY '*============================================*'  
              DISPLAY '*==========      PCSCA195       =============*'  
              DISPLAY '*============================================*'  
              DISPLAY '*  PARAGRAPH: ' WS-ABEND-PARAGRAPH               
                      '                           *'                    
              DISPLAY '*  SQLCODE..: ' WS-SQLCODE                       
                      '                     *'                          
              DISPLAY '*  ERROR WHEN OPENING PNDNG_DRAFT_CUR '          
                      '                     *'                          
              DISPLAY '*============================================*'  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-FETCH-PNDNG-DRAFT-CUR                                     *        
      ******************************************************************        
       7100-FETCH-PNDNG-DRAFT-CUR.                                      
                                                                        
           MOVE '7100'  TO WS-ABEND-PARAGRAPH.                          
                                                                        
           EXEC SQL                                                     
                FETCH PNDNG_DRAFT_CUR INTO                              
                      :PB-DRAFT-AMT,                                    
                      :PB-ACCOUNT-NO,                                   
                      :PB-DRAFT-DATE,                                   
                      :PB-TRANSACTION-CD,                               
                      :PB-CODE-SOURCE-ID,                               
                      :PB-PYMT-POSTED-FL,                               
                      :PB-PYMT-TRANS-TS,                                
                      :PB-CUST-BANK-SEQ-NO,                             
                      :AT-ACCOUNT-NO,                                   
                      :AT-TOTAL-AR-BALANCE,                             
                      :AT-COMPANY-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                PERFORM 5000-PROCESS-ACCOUNT THRU 5000-EXIT             
                PERFORM  8900-WRITE-FCSPT33 THRU 8900-EXIT              
             ELSE                                                       
                NEXT SENTENCE                                           
             END-IF                                                     
           ELSE                                                         
              MOVE SQLCODE TO WS-SQLCODE                                
              DISPLAY '*============================================*'  
              DISPLAY '*==========      PCSCA195       =============*'  
              DISPLAY '*============================================*'  
              DISPLAY '*  PARAGRAPH: ' WS-ABEND-PARAGRAPH               
                      '                           *'                    
              DISPLAY '*  SQLCODE..: ' WS-SQLCODE                       
                      '                     *'                          
              DISPLAY '*  DRAFT-AMOUNT: ' WS-PB-DRAFT-AMT               
                      '                     *'                          
              DISPLAY '*  ACCOUNT-NO: ' WS-PB-ACCOUNT-NO                
                      '                     *'                          
              DISPLAY '*  ERROR WHEN FETCHING PNDNG_DRAFT_CUR '         
                      '                     *'                          
              DISPLAY '*============================================*'  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-CLOSE-PNDNG-DRAFT-CUR                                     *        
      ******************************************************************        
       7200-CLOSE-PNDNG-DRAFT-CUR.                                      
                                                                        
           MOVE '7200'  TO WS-ABEND-PARAGRAPH.                          
                                                                        
           EXEC SQL                                                     
                CLOSE PNDNG_DRAFT_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE TO WS-SQLCODE                                
              DISPLAY '*============================================*'  
              DISPLAY '*==========      PCSCA195       =============*'  
              DISPLAY '*============================================*'  
              DISPLAY '*  PARAGRAPH: ' WS-ABEND-PARAGRAPH               
                      '                           *'                    
              DISPLAY '*  SQLCODE..: ' WS-SQLCODE                       
                      '                     *'                          
              DISPLAY '*  ERROR WHEN CLOSING THE PNDNG_DRAFT_CUR'       
                      '                     *'                          
              DISPLAY '*============================================*'  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 7225-SELECT-COMPANY-NAME                                                
      * READ COMPANY USER TABLE TO GET COMPANY NAME                   *         
      *****************************************************************         
       7225-SELECT-COMPANY-NAME.                                        
           MOVE '7225'  TO WS-ABEND-PARAGRAPH.                          
           EXEC SQL                                                     
              SELECT COMPANY_NAME                                       
              INTO :C7-COMPANY-NAME                                     
              FROM CSS_COMPANY                                          
              WHERE COMPANY_NO ='01'                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
                OR NOT-FOUND                                            
              NEXT SENTENCE                                             
            ELSE                                                        
              MOVE SQLCODE TO WS-SQLCODE                                
              DISPLAY '*============================================*'  
              DISPLAY '*==========      PCSCA195       =============*'  
              DISPLAY '*============================================*'  
              DISPLAY '*  PARAGRAPH: ' WS-ABEND-PARAGRAPH               
                      '                           *'                    
              DISPLAY '*  SQLCODE..: ' WS-SQLCODE                       
                      '                     *'                          
              DISPLAY '*  ERROR WHEN SELECTING CSS_COMPANY '            
                      '               *'                                
              DISPLAY '*============================================*'  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
       7225-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 7250-GET-DELINQUENCY                                          *         
      *     SELECT DELINQUENCY VALUE TO DETERMINE ONLY REPORT OR      *         
      *          REPORT AND UPDATE CSS_PNDNG_BNK_DRAFT TABLE          *         
      *****************************************************************         
       7250-GET-DELINQUENCY.                                            
      *                                                                         
           MOVE '7250'  TO WS-ABEND-PARAGRAPH.                          
           MOVE WS-DELINQ-CODE TO  C8-DELINQ-CD.                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
                 WHERE DELINQ_CD  = :C8-DELINQ-CD                       
                  AND  COMPANY_NO ='01'                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*          WHERE DELINQ_CD  = :C8-DELINQ-CD                               
MFA-TR*           AND  COMPANY_NO ='01'                                         
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               MOVE C8-DELINQ-VALUE TO WS-DELINQ-VALUE                  
           ELSE                                                         
              MOVE SQLCODE TO WS-SQLCODE                                
              DISPLAY '*============================================*'  
              DISPLAY '*==========      PCSCA195       =============*'  
              DISPLAY '*============================================*'  
              DISPLAY '*  PARAGRAPH: ' WS-ABEND-PARAGRAPH               
                      '                           *'                    
              DISPLAY '*  SQLCODE..: ' WS-SQLCODE                       
                      '                     *'                          
              DISPLAY '*  ERROR WHEN SELECTING CSS_DELINQUENCY '        
                      '               *'                                
              DISPLAY '*============================================*'  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  16690000
      *  7300-UPDATE-DRAFT-AMOUNT.                                   *  16700000
      ****************************************************************  16710000
       7300-UPDATE-DRAFT-AMOUNT.                                        
           MOVE '7300'  TO WS-ABEND-PARAGRAPH.                          
              EXEC SQL                                                  
                 UPDATE CSS_PNDNG_BNK_DRFT                              
                 SET DRAFT_AMT      = :WS-AT-TOTAL-AR-BALANCE           
                 WHERE ACCOUNT_NO   = :WS-PB-ACCOUNT-NO                 
                 AND DRAFT_DATE     = IIF(TRY_CONVERT(DATE, 
                                                         :PB-DRAFT-DATE
              ) IS NULL OR (PATINDEX('%.%', :PB-DRAFT-DATE
              ) <> 0) OR (LEN(:PB-DRAFT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :PB-DRAFT-DATE
              ), CONVERT(DATE, :PB-DRAFT-DATE) )                    
                 AND DRAFT_AMT      = :PB-DRAFT-AMT                     
                 AND TRANSACTION_CD = :PB-TRANSACTION-CD                
                 AND PYMT_TRANS_TS  = CIS.CHAR2TIMESTAMP(
                                                      :PB-PYMT-TRANS-TS
              )                 
              END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*       EXEC SQL                                                          
MFA-TR*          UPDATE CSS_PNDNG_BNK_DRFT                                      
MFA-TR*          SET DRAFT_AMT      = :WS-AT-TOTAL-AR-BALANCE                   
MFA-TR*          WHERE ACCOUNT_NO   = :WS-PB-ACCOUNT-NO                         
MFA-TR*          AND DRAFT_DATE     = :PB-DRAFT-DATE                    12190000
MFA-TR*          AND DRAFT_AMT      = :PB-DRAFT-AMT                     12200000
MFA-TR*          AND TRANSACTION_CD = :PB-TRANSACTION-CD                12210000
MFA-TR*          AND PYMT_TRANS_TS  = :PB-PYMT-TRANS-TS                 12210000
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              MOVE SQLCODE    TO WS-ACTIVE-RETURN-CODE.                 
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                PERFORM 7400-INSERT-DRFT-UPD-TRNS-HIST THRU 7400-EXIT   
             ELSE                                                       
               MOVE SQLCODE TO WS-SQLCODE                               
               DISPLAY '*============================================*' 
               DISPLAY '*==========      PCSCA195       =============*' 
               DISPLAY '*============================================*' 
               DISPLAY '*  PARAGRAPH: ' WS-ABEND-PARAGRAPH              
                       '                           *'                   
               DISPLAY '*  SQLCODE..: ' WS-SQLCODE                      
                        '                     *'                        
               DISPLAY '*  ACCOUNT-NO: ' WS-PB-ACCOUNT-NO               
                        '                     *'                        
               DISPLAY '*  DRAFT-AMOUNT: ' WS-PB-DRAFT-AMT              
                        '                     *'                        
               DISPLAY '*  ERROR WHEN UPDATING CSS_PNDNG_BNK_DRFT'      
                        '                     *'                        
               DISPLAY '*============================================*' 
               PERFORM 9900-ABEND THRU 9900-EXIT                        
             END-IF.                                                    
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  16690000
      *  7400-INSERT-DRFT-UPD-TRNS-HIST.                                16700000
      ****************************************************************  16710000
       7400-INSERT-DRFT-UPD-TRNS-HIST.                                  
           MOVE '7400'  TO WS-ABEND-PARAGRAPH.                          
           PERFORM 7410-SELECT-TIMESTAMP THRU 7410-EXIT.                
      ** DATA FOR CSS_MNT_TRANS_HIST                                            
           MOVE WS-CURRENT-TS             TO MH-TRANS-HIST-SEQ-NO.      
           MOVE WS-F                      TO MH-CODE-TRAN-TYPE.         
           MOVE SPACES                    TO MH-RESP-AREA-ID.           
           MOVE WS-PB-ACCOUNT-NO          TO MH-ACCOUNT-NO.             
           MOVE 0                         TO MH-CUSTOMER-NO.            
           MOVE 0                         TO MH-PREMISE-NO.             
           MOVE 'SYSTEM'                  TO MH-USER-ID.                
           MOVE +37                       TO MH-TRAN-COMMENT-LEN.       
           MOVE WS-DRFT-AMT-COMMENT       TO MH-TRAN-COMMENT-TEXT.      
           MOVE WS-APPL-PRG-ID            TO MH-APPL-PROGRAM-ID.        
                                                                        
      ** DATA FOR CSS_MT_TRN_HST_DET                                            
           MOVE WS-CURRENT-TS             TO MI-TRANS-HIST-SEQ-NO.      
           MOVE 1                         TO MI-TRAN-APPL-NO.           
           MOVE 'DRAFT AMOUNT'            TO MI-COLUMN-DESC.            
           MOVE SPACES                    TO MI-TABLE-ID.               
           MOVE +20                       TO MI-PRV-COLUMN-VALUE-LEN.   
           MOVE WS-PRE-DRFT-AMT           TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE +20                       TO MI-CHG-COLUMN-VALUE-LEN.   
           MOVE WS-CUR-DRFT-AMT           TO MI-CHG-COLUMN-VALUE-TEXT.  
      *                                                                         
           PERFORM 7420-INSERT-MN-TRANS-HIST  THRU 7420-EXIT.           
           PERFORM 7430-INSERT-MN-TRN-HST-DET THRU 7430-EXIT.           
      *                                                                         
           MOVE 2                         TO MI-TRAN-APPL-NO.           
           MOVE 'DRAFT DATE'              TO MI-COLUMN-DESC.            
           MOVE SPACES                    TO MI-TABLE-ID.               
           MOVE +10                       TO MI-PRV-COLUMN-VALUE-LEN.   
           MOVE WS-PB-DRAFT-DATE          TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE +10                       TO MI-CHG-COLUMN-VALUE-LEN.   
           MOVE WS-PB-DRAFT-DATE          TO MI-CHG-COLUMN-VALUE-TEXT.  
           PERFORM 7430-INSERT-MN-TRN-HST-DET THRU 7430-EXIT.           
      *                                                                         
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  16690000
      *  7405-INSERT-DRFT-DEL-TRNS-HIST.                                16700000
      ****************************************************************  16710000
       7405-INSERT-DRFT-DEL-TRNS-HIST.                                  
           MOVE '7405'  TO WS-ABEND-PARAGRAPH.                          
           PERFORM 7410-SELECT-TIMESTAMP THRU 7410-EXIT.                
      ** DATA FOR CSS_MNT_TRANS_HIST                                            
           MOVE WS-CURRENT-TS             TO MH-TRANS-HIST-SEQ-NO.      
           MOVE WS-F                      TO MH-CODE-TRAN-TYPE.         
           MOVE SPACES                    TO MH-RESP-AREA-ID.           
           MOVE WS-PB-ACCOUNT-NO          TO MH-ACCOUNT-NO.             
           MOVE 0                         TO MH-CUSTOMER-NO.            
           MOVE 0                         TO MH-PREMISE-NO.             
           MOVE 'SYSTEM'                  TO MH-USER-ID.                
           MOVE +37                       TO MH-TRAN-COMMENT-LEN.       
           MOVE WS-DRFT-AMT-COMMENT       TO MH-TRAN-COMMENT-TEXT.      
           MOVE WS-APPL-PRG-ID            TO MH-APPL-PROGRAM-ID.        
                                                                        
      ** DATA FOR CSS_MT_TRN_HST_DET                                            
           MOVE WS-CURRENT-TS             TO MI-TRANS-HIST-SEQ-NO.      
           MOVE 1                         TO MI-TRAN-APPL-NO.           
           MOVE 'PREVENT DRAFT'           TO MI-COLUMN-DESC.            
           MOVE SPACES                    TO MI-TABLE-ID.               
           MOVE +2                        TO MI-PRV-COLUMN-VALUE-LEN.   
           MOVE 'NO'                      TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE +3                        TO MI-CHG-COLUMN-VALUE-LEN.   
           MOVE 'YES'                     TO MI-CHG-COLUMN-VALUE-TEXT.  
      *                                                                         
           PERFORM 7420-INSERT-MN-TRANS-HIST  THRU 7420-EXIT.           
           PERFORM 7430-INSERT-MN-TRN-HST-DET THRU 7430-EXIT.           
                                                                        
       7405-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  16690000
      *  7410-SELECT-TIMESTAMP.                                  *      16700000
      ****************************************************************  16710000
       7410-SELECT-TIMESTAMP.                                           
           MOVE '7410'  TO WS-ABEND-PARAGRAPH.                          
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TS   = CURRENT TIMESTAMP                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE SQLCODE TO WS-SQLCODE                                
              DISPLAY '*============================================*'  
              DISPLAY '*==========      PCSCA195       =============*'  
              DISPLAY '*============================================*'  
              DISPLAY '*  PARAGRAPH: ' WS-ABEND-PARAGRAPH               
                      '                           *'                    
              DISPLAY '*  SQLCODE..: ' WS-SQLCODE                       
                      '                     *'                          
              DISPLAY '*  ERROR WHEN SELECTING TIMESTAMP'               
                      '                     *'                          
              DISPLAY '*============================================*'  
               PERFORM 9900-ABEND          THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7420 INSERT A ROW INTO CSS_MNT_TRANS_HIST                      *        
      ******************************************************************        
       7420-INSERT-MN-TRANS-HIST.                                       
           MOVE '7420'  TO WS-ABEND-PARAGRAPH.                          
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_MNT_TRANS_HIST                          
                     ( TRANS_HIST_SEQ_NO,                               
                       DATE_TRANS,                                      
                       CODE_TRAN_TYPE,                                  
                       RESP_AREA_ID,                                    
                       ACCOUNT_NO,                                      
                       CUSTOMER_NO,                                     
                       PREMISE_NO,                                      
                       USER_ID,                                         
                       APPL_PROGRAM_ID,                                 
                       TRAN_COMMENT,                                    
                       ENTITY_KEY_DESC)                                 
                VALUES                                                  
                     ( CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO),               
                       CAST(SYSDATETIMEOFFSET() AS DATE),                       
                       :MH-CODE-TRAN-TYPE,                              
                       :MH-RESP-AREA-ID,                                
                       :MH-ACCOUNT-NO,                                  
                       :MH-CUSTOMER-NO,                                 
                       :MH-PREMISE-NO,                                  
                       :MH-USER-ID,                                     
                       :MH-APPL-PROGRAM-ID,                             
                       :MH-TRAN-COMMENT,                                
                       :MH-ENTITY-KEY-DESC)                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_MNT_TRANS_HIST                                  
MFA-TR*              ( TRANS_HIST_SEQ_NO,                                       
MFA-TR*                DATE_TRANS,                                              
MFA-TR*                CODE_TRAN_TYPE,                                          
MFA-TR*                RESP_AREA_ID,                                            
MFA-TR*                ACCOUNT_NO,                                              
MFA-TR*                CUSTOMER_NO,                                             
MFA-TR*                PREMISE_NO,                                              
MFA-TR*                USER_ID,                                                 
MFA-TR*                APPL_PROGRAM_ID,                                         
MFA-TR*                TRAN_COMMENT,                                            
MFA-TR*                ENTITY_KEY_DESC)                                         
MFA-TR*         VALUES                                                          
MFA-TR*              ( :MH-TRANS-HIST-SEQ-NO,                                   
MFA-TR*                CURRENT DATE,                                            
MFA-TR*                :MH-CODE-TRAN-TYPE,                                      
MFA-TR*                :MH-RESP-AREA-ID,                                        
MFA-TR*                :MH-ACCOUNT-NO,                                          
MFA-TR*                :MH-CUSTOMER-NO,                                         
MFA-TR*                :MH-PREMISE-NO,                                          
MFA-TR*                :MH-USER-ID,                                             
MFA-TR*                :MH-APPL-PROGRAM-ID,                                     
MFA-TR*                :MH-TRAN-COMMENT,                                        
MFA-TR*                :MH-ENTITY-KEY-DESC)                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE SQLCODE TO WS-SQLCODE                                
              DISPLAY '*============================================*'  
              DISPLAY '*==========      PCSCA195       =============*'  
              DISPLAY '*============================================*'  
              DISPLAY '*  PARAGRAPH: ' WS-ABEND-PARAGRAPH               
                      '                           *'                    
              DISPLAY '*  SQLCODE..: ' WS-SQLCODE                       
                      '                     *'                          
              DISPLAY '**  ERROR WHEN INSERT IN CSS_MNT_TRANS_HIST **'  
              DISPLAY '**  ACCOUNT-NO     = ' WS-PB-ACCOUNT-NO          
                      '                     *'                          
             DISPLAY  '*============================================*'  
             PERFORM 9900-ABEND                THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7430 INSERT A ROW INTO CSS_MT_TRN_HST_DET                               
      ******************************************************************        
       7430-INSERT-MN-TRN-HST-DET.                                      
           MOVE '7430'  TO WS-ABEND-PARAGRAPH.                          
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_MT_TRN_HST_DET                          
                     ( TRANS_HIST_SEQ_NO,                               
                       TRAN_APPL_NO,                                    
                       COLUMN_DESC,                                     
                       TABLE_ID,                                        
                       PRV_COLUMN_VALUE,                                
                       CHG_COLUMN_VALUE)                                
                VALUES                                                  
                     ( CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO),               
                       :MI-TRAN-APPL-NO,                                
                       :MI-COLUMN-DESC,                                 
                       :MI-TABLE-ID,                                    
                       :MI-PRV-COLUMN-VALUE,                            
                       :MI-CHG-COLUMN-VALUE)                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_MT_TRN_HST_DET                                  
MFA-TR*              ( TRANS_HIST_SEQ_NO,                                       
MFA-TR*                TRAN_APPL_NO,                                            
MFA-TR*                COLUMN_DESC,                                             
MFA-TR*                TABLE_ID,                                                
MFA-TR*                PRV_COLUMN_VALUE,                                        
MFA-TR*                CHG_COLUMN_VALUE)                                        
MFA-TR*         VALUES                                                          
MFA-TR*              ( :MI-TRANS-HIST-SEQ-NO,                                   
MFA-TR*                :MI-TRAN-APPL-NO,                                        
MFA-TR*                :MI-COLUMN-DESC,                                         
MFA-TR*                :MI-TABLE-ID,                                            
MFA-TR*                :MI-PRV-COLUMN-VALUE,                                    
MFA-TR*                :MI-CHG-COLUMN-VALUE)                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE SQLCODE TO WS-SQLCODE                                
              DISPLAY '*============================================*'  
              DISPLAY '*==========      PCSCA195       =============*'  
              DISPLAY '*============================================*'  
              DISPLAY '*  PARAGRAPH: ' WS-ABEND-PARAGRAPH               
                      '                           *'                    
              DISPLAY '*  SQLCODE..: ' WS-SQLCODE                       
                      '                     *'                          
              DISPLAY '** COULD NOT INSERT IN CSS_MT_TRN_HST_DET **'    
              DISPLAY '** ACCOUNT-NO     = ' WS-PB-ACCOUNT-NO           
                      '                     *'                          
              DISPLAY  '*============================================*' 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7430-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  16690000
      *  7500-DELETE-PNDNG-DRAFT-ROW.                                *  16700000
      ****************************************************************  16710000
       7500-DELETE-PNDNG-DRAFT-ROW.                                     
           MOVE '7500'  TO WS-ABEND-PARAGRAPH.                          
           EXEC SQL                                                     
                DELETE FROM CSS_PNDNG_BNK_DRFT                          
                WHERE  ACCOUNT_NO     = :PB-ACCOUNT-NO                  
                AND    DRAFT_DATE     = IIF(TRY_CONVERT(DATE, 
                                                         :PB-DRAFT-DATE
              ) IS NULL OR (PATINDEX('%.%', :PB-DRAFT-DATE
              ) <> 0) OR (LEN(:PB-DRAFT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :PB-DRAFT-DATE
              ), CONVERT(DATE, :PB-DRAFT-DATE) )                  
                AND    DRAFT_AMT      = :PB-DRAFT-AMT                   
                AND    TRANSACTION_CD = :PB-TRANSACTION-CD              
                AND    PYMT_TRANS_TS  = CIS.CHAR2TIMESTAMP(
                                                      :PB-PYMT-TRANS-TS
              )               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_PNDNG_BNK_DRFT                          12170000
MFA-TR*         WHERE  ACCOUNT_NO     = :PB-ACCOUNT-NO                  12180000
MFA-TR*         AND    DRAFT_DATE     = :PB-DRAFT-DATE                  12190000
MFA-TR*         AND    DRAFT_AMT      = :PB-DRAFT-AMT                   12200000
MFA-TR*         AND    TRANSACTION_CD = :PB-TRANSACTION-CD              12210000
MFA-TR*         AND    PYMT_TRANS_TS  = :PB-PYMT-TRANS-TS               12210000
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               PERFORM 7405-INSERT-DRFT-DEL-TRNS-HIST THRU 7405-EXIT    
           ELSE                                                         
              MOVE SQLCODE TO WS-SQLCODE                                
              DISPLAY '*============================================*'  
              DISPLAY '*==========      PCSCA195       =============*'  
              DISPLAY '*============================================*'  
              DISPLAY '*  PARAGRAPH: ' WS-ABEND-PARAGRAPH               
                      '                           *'                    
              DISPLAY '*  SQLCODE..: ' WS-SQLCODE                       
                      '                     *'                          
              DISPLAY '*  ACCOUNT-NO: ' WS-PB-ACCOUNT-NO                
                      '                     *'                          
              DISPLAY '*  DRAFT-AMOUNT: ' WS-PB-DRAFT-AMT               
                      '                     *'                          
              DISPLAY '*  ERROR WHEN DELETING CSS_PNDNG_BNK_DRFT'       
                      '                     *'                          
              DISPLAY '*============================================*'  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 08880000
      *    7600-START-FCSJC01                                        ** 08890000
      *    7610-READ-FCSJC01                                         ** 08890000
      *    7611-CLOSE                                                ** 08890000
      *                                                              ** 08900000
      ***************************************************************** 08930000
      *                                                                 08760000
           EXEC SQL                                                     11960000
               INCLUDE CPD00038                                         11970000
           END-EXEC.                                                    11980000
      *                                                                 08800000
      ***************************************************************** 08880000
      *    7620-START-FCSCA00                                        ** 08890000
      *    7621-READ-FCSCA00                                         ** 08890000
      *    7622-CLOSE-CA00-CSR                                       ** 08890000
      *                                                              ** 08900000
      ***************************************************************** 08930000
                                                                        
           EXEC SQL                                                     12000000
               INCLUDE CPD00039                                         12010000
           END-EXEC.                                                    12020000
                                                                        
      ******************************************************************        
      *                                                                *        
      *   8000-PRINT-REP-HDR.                                          *        
      *   IT WRITES THE REPORT HEADERS                                 *        
      ******************************************************************        
       8000-PRINT-REP-HDR.                                              
                                                                        
           WRITE PRT33-RECORD FROM WS-RPT-HEADER-1                      
                 AFTER ADVANCING TOP-OF-PAGE.                           
           WRITE PRT33-RECORD FROM WS-RPT-HEADER-2                      
                 AFTER ADVANCING 1 LINE.                                
           ADD +1 TO WS-RPT1-PAGE-NO.                                   
           MOVE WS-RPT1-PAGE-NO TO P-RPT-PAGE-NO.                       
           WRITE PRT33-RECORD FROM WS-RPT-HEADER-3                      
                 AFTER ADVANCING 1 LINE.                                
           WRITE PRT33-RECORD FROM WS-PRINT-REP-HDR-1                   
                 AFTER ADVANCING 3 LINE.                                
           WRITE PRT33-RECORD FROM WS-PRINT-REP-HDR-2                   
                 AFTER ADVANCING 1 LINE.                                
           MOVE ZEROES TO WS-RPT1-LINE-NO.                              
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      *    WRITES NO-DATA-LINE IN REPORT IF NO RECORDS ARE FETCHED.             
      ******************************************************************        
      *                                                                         
       8300-NO-DATA-PARA.                                               
      *                                                                         
           PERFORM 8000-PRINT-REP-HDR    THRU 8000-EXIT.                
           WRITE PRT33-RECORD FROM WS-NO-DATA-LINE AFTER                
                 ADVANCING 2 LINES.                                     
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************          
      **   8400-MOVE-PRINT-FIELDS.                                  **          
      **       MOVES THE DETAILS INTO THE PRINT FIELDS.             **          
      ****************************************************************          
      *                                                                         
       8400-MOVE-PRINT-FIELDS.                                          
                                                                        
           MOVE WS-PB-ACCOUNT-NO       TO P-RPT1-ACC-NUMB.              
           MOVE PB-DRAFT-DATE          TO P-RPT1-DRF-DATE.              
           MOVE PB-DRAFT-AMT           TO P-RPT1-DRF-AMT.               
           MOVE WS-AT-TOTAL-AR-BALANCE TO P-RPT1-AR-BALANCE.            
                                                                        
           IF WS-AT-TOTAL-AR-BALANCE < 0                                
              MOVE 0 TO P-RPT1-UPDATE-AMT                               
           ELSE                                                         
              MOVE WS-AT-TOTAL-AR-BALANCE TO P-RPT1-UPDATE-AMT          
           END-IF.                                                      
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   8500-END-DATA-PARA.                                      **          
      **       WRITES END OF THE REPORT LINE.                       **          
      ****************************************************************          
       8500-END-DATA-PARA.                                              
                                                                        
           WRITE PRT33-RECORD FROM WS-END-DATA-LINE AFTER               
                 ADVANCING 3 LINES.                                     
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *   8900-WRITE-FCSPT33                                           *        
      *        WRITES THE RECORD INTO THE REPORT FILE                  *        
      *                                                                *        
      ******************************************************************        
       8900-WRITE-FCSPT33.                                              
      *                                                                         
           IF WS-NOT-FIRST-TIME = 'N'                                   
              PERFORM 8000-PRINT-REP-HDR         THRU 8000-EXIT         
              PERFORM 8400-MOVE-PRINT-FIELDS THRU 8400-EXIT             
              MOVE ZEROES TO WS-RPT1-LINE-NO                            
              MOVE 'Y' TO  WS-NOT-FIRST-TIME                            
           ELSE                                                         
              PERFORM 8400-MOVE-PRINT-FIELDS THRU 8400-EXIT             
           END-IF.                                                      
           IF WS-RPT1-LINE-NO > 50                                      
              PERFORM 8000-PRINT-REP-HDR         THRU 8000-EXIT         
              PERFORM 8400-MOVE-PRINT-FIELDS THRU 8400-EXIT             
              MOVE ZEROES TO WS-RPT1-LINE-NO                            
           END-IF.                                                      
           WRITE PRT33-RECORD FROM WS-PRINT-REP-DET-1                   
                 AFTER  ADVANCING 1 LINE.                               
           ADD 1 TO WS-RPT1-LINE-NO.                                    
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9000-TERMINATE.                                                         
      ******************************************************************        
       9000-TERMINATE.                                                  
           IF WS-OPEN-CUR = 'Y'                                         
              PERFORM 7200-CLOSE-PNDNG-DRAFT-CUR THRU 7200-EXIT         
           END-IF.                                                      
           CLOSE FCSPT33-FILE.                                          
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  16690000
      *  9900-ABEND.                                                 *  16700000
      ****************************************************************  16710000
           EXEC SQL                                                     16740000
               INCLUDE CPD09900                                         16750000
           END-EXEC.                                                    16760000
