       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA182.                                        
       DATE-WRITTEN.   OCT, 2010.                                       
       DATE-COMPILED.                                                   
                                                                        
      ****************************************************************  00050000
      ****************************************************************  00140000
      **                                                            **  00150000
      **              PROGRAM  MODIFICATION  LOG                    **  00160000
      **                                                            **          
      **    DATE      INITIALS     REASON                           **  00170000
      **  ________    ________     ______                           **  00180000
      **  10/26/2010  CARLA BROWN  IDEA418 - NEW PROGRAM WRITTEN TO **  00190000
      **                           CREATE LETTERS FOR PAYMENTS MADE **  00191000
      **                           ON FINALLED TRANSFERRED ACCOUNTS **  00191000
      **                           (PROJ*459)                       **  00191000
PRJ459**  04/05/2011  CARLA BROWN  MADE CHANGES TO USE COMMONDATE   **  00190000
PRJ459**                           INSTEAD OF COMMON.               **  00190000
PRJ459**  06/17/2011  CARLA BROWN  MADE CHANGES TO USE CASH REPORT  **  00190000
PRJ459**                           DATE INSTEAD OF DATE TRANS TO    **  00190000
PRJ459**                           STOP MISSING PAYMENTS MADE DURING**  00190000
PRJ459**                           THE WEEKEND.                     **  00190000
PRJ459**  06/27/2011  CARLA BROWN  MADE CHANGES TO ONLY UPDATE THE  **  00190000
PRJ459**                           CREATED_TS WHEN THE ROW IS       **  00190000
PRJ459**                           CREATED ON THE CSS_ACCT_ATTRIBUTE**  00190000
PRJ459**                           TABLE.                           **  00190000
A03866**  01/19/2012  MC95456      MOVED MESSAGE ID TO PROMOTION ID **          
A03866**A03866-ACT003              IN CSS_COMM_DATA.                **          
P00599**  09/11/2012  GV7A828      INSERT NOTICES INTO DB2 TABLES   **          
P00599**                           INSTEAD OF WRITING TO RP000 FILE **          
P0599A**  02/05/2013  GOKUL        POPULATE OLD ADDRESS FORMAT IN   **          
P0599A**                           CSS_CORRESP_VAR.                 **          
A04527**  06/06/2013  MR7E794      REMOVED UNUSED COPYBOOK CWS00056.**          
      ****************************************************************  00204000
                                                                        
      *==============================================================*  00220000
      *==============================================================*  00230000
      *                                                              *  00240000
      *   PCSCA182 SELECTS FINAL BILLED ACCOUNTS THAT HAVE BEEN      *  00250000
      *   TRANSFERRED, AND CONTINUE TO MAKE PAYMENTS ON THE OLD      *  00250000
      *   ACCOUNT, AND CREATES AN EXTRACT FILE TO BE USED FOR        *  00250000
      *   LETTERS.                                                   *  00270000
      *==============================================================*  00280000
      *==============================================================*  00290000
      *                                                                 00300000
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                 00370000
                                                                        
       DATA DIVISION.                                                   
      *                                                                 00430000
       FILE SECTION.                                                    
      *                                                                 00450000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA182'.
MSQ017     COPY MFASQLM.
      *                                                                 00530000
       COPY FIOCA00.                                                    00540000
       COPY FIOJC01.                                                    00560000
      *                                                                 00570000
       01  WS-MISCELLANEOUS.                                            
           05 WS-START                 PIC X(40)      VALUE             
             'WORKING STORAGE FOR PCSCA182 STARTS HERE'.                
      *                                                                 00601000
           05  S-RETURN-CODE           PIC S9(9)      VALUE 0 COMP.     
           05  WS-ABEND-PARAGRAPH      PIC XXXX       VALUE SPACES.     
           05  WS-SQLCODE              PIC --------9.                   
           05  WS-ZERO-IND             PIC S9999      COMP.             
           05  IND-LO-PHONE            PIC S9(04)     COMP.             
      *                                                                 00649600
           05  WS-MAX-NUM              PIC 9(01)      VALUE ZERO.       
           05  WS-SEB-REG-FLAG         PIC X(01)      VALUE 'N'.        
               88  WS-SEB-REGULATED                   VALUE 'Y'.        
           05  WS-RED-FL-NULL-IND      PIC S9(4) COMP VALUE 0.          
           05  WS-CALL-END-NULL-IND    PIC S9(4) COMP VALUE 0.          
           05  WS-HOLD-ATTR-VALUE-TEXT.                                 
               10  FILLER              PIC X(15).                       
               10  WS-HOLD-LTR-COUNT   PIC 9(01)      VALUE 0.          
           05  WS-ACCT-ATR-COMMENT.                                     
               10  FILLER              PIC X(15)      VALUE             
                                       'LETTER COUNT = '.               
               10  WS-ATR-LTR-COUNT    PIC 9(01)      VALUE 0.          
      *                                                                 00649600
           05  WS-OLD-ACCT-NO          PIC X(13).                       
           05  WS-OLD-ACCT-NUM REDEFINES WS-OLD-ACCT-NO                 
                                       PIC 9(13).                       
COB305     05 WS-OLD-ACCT-COMP3        PIC S9(13)V COMP-3 VALUE 0.           
P00599     05  WS-PREV-ACCOUNT-NO      PIC X(13) VALUE SPACES.          
P00599     05  WS-SEQ-NO-COUNT         PIC S9(4) USAGE COMP VALUE 0.    
      *                                                                 00649600
           05  WS-NEW-ACCT-NO          PIC X(13).                       
A03866     05  WS-MESSAGE-NO           PIC 9(5) VALUE 90210.            
COB305     05 WS-CORRESP-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.        
      *                                                                 00649600
P00599*****************************************************************         
P00599*  CWS00350  - CORRESP_COMM VARIABLES                           *         
P00599*****************************************************************         
P00599                                                                  
P00599     EXEC SQL                                                     01530000
P00599         INCLUDE CWS00350                                                 
P00599     END-EXEC.                                                            
P00599                                                                  
P00599******************************************************************        
P00599* CORRESP MAIL UID CPYC WS VARIABLES.                            *        
P00599******************************************************************        
P00599     EXEC SQL                                                             
P00599         INCLUDE CWSCA165                                                 
P00599     END-EXEC.                                                            
      *                                                                         
       COPY CWS09900.                                                   00650000
       COPY CWS00010.                                                   00660000
       COPY CWS00039.                                                   00670000
       COPY CWS00038.                                                   00690000
       COPY CWS00074.                                                   00720000
       COPY CWS00011.                                                   00721000
      *                                                                 00730000
       01  WS-INPUT-DATE-BREAKDOWN     PIC 9(10)    VALUE ZEROS.        
       01  FILLER REDEFINES WS-INPUT-DATE-BREAKDOWN.                    
           05  WS-INPUT-CC-B           PIC 9(02).                       
           05  WS-INPUT-YY-B           PIC 9(02).                       
           05  FILLER                  PIC X(01).                       
           05  WS-INPUT-MM-B           PIC 9(02).                       
           05  FILLER                  PIC X(01).                       
           05  WS-INPUT-DD-B           PIC 9(02).                       
      *                                                                 00789000
       01  WS-STATEMENT-DATE.                                           
           05  WS-STATEMENT-YY         PIC X(02) VALUE SPACES.          
           05  WS-STATEMENT-MM         PIC X(02) VALUE SPACES.          
           05  WS-STATEMENT-DD         PIC X(02) VALUE SPACES.          
      *                                                                 00789000
PRJ459 01  WS-COMMONDATE               PIC X(10).                       
      *                                                                 01040000
       01  WS-LITERALS.                                                 
           05  WS-L                    PIC X(01)    VALUE 'L'.          
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-O                    PIC X(01)    VALUE 'O'.          
           05  WS-S                    PIC X(01)    VALUE 'S'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
           05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSCA182'.   
           05  PROGRAM-NAME            PIC X(08)    VALUE 'PCSCA182'.   
      *                                                                 01400000
           COPY CWS00303.                                               01380000
      *                                                                 01400000
           EXEC SQL                                                     01450000
               INCLUDE SQLCA                                            01460000
           END-EXEC.                                                    01470000
      *                                                                 01480000
      *************************************************************             
      **   CSS_ACCOUNT - AT                                                     
      *************************************************************             
      *                                                                         
           EXEC SQL                                                     01490000
               INCLUDE TBACCT                                           01500000
           END-EXEC.                                                    01510000
      *                                                                 01480000
      *************************************************************             
      **   CSS_ACCT_ATTRIBUTE - YP                                              
      *************************************************************             
      *                                                                         
           EXEC SQL                                                     01490000
               INCLUDE TBACTATT                                         01500000
           END-EXEC.                                                    01510000
      *                                                                 01810500
      *************************************************************             
      **   CSS_ACCT_MISC_INFO - TA                                              
      *************************************************************             
      *                                                                         
           EXEC SQL                                                     01810600
               INCLUDE TBATMISC                                         01810700
           END-EXEC.                                                    01810800
      *                                                                 01808800
      *************************************************************             
      **   CSS_ADDR_FORMATTED - DY                                              
      *************************************************************             
      *                                                                         
           EXEC SQL                                                     01809000
               INCLUDE TBADRFMT                                         01809100
           END-EXEC.                                                    01809200
      *                                                                 01520000
      *************************************************************             
      **   CSS_ADDR_FREEFORM - DZ                                               
      *************************************************************             
      *                                                                         
           EXEC SQL                                                     01530000
               INCLUDE TBADRFRE                                         01540000
           END-EXEC.                                                    01550000
      *                                                                 01520000
      *************************************************************             
      **   CSS_AR_TRAN_HIST - AR                                                
      *************************************************************             
      *                                                                         
           EXEC SQL                                                     01530000
               INCLUDE TBARHIST                                         01540000
           END-EXEC.                                                    01550000
      *                                                                 01520000
      *************************************************************             
      **   CSS_ATTRIBUTE - WZ                                                   
      *************************************************************             
      *                                                                         
           EXEC SQL                                                     01530000
               INCLUDE TBATTRIB                                         01540000
           END-EXEC.                                                    01550000
      *                                                                 01560000
      *************************************************************             
      **   CSS_BANK_EFT - BE                                                    
      *************************************************************             
      *                                                                         
           EXEC SQL                                                     01570000
               INCLUDE TBBNKEFT                                         01580000
           END-EXEC.                                                    01590000
      *                                                                 01600000
      *************************************************************             
      **   CSS_BTCH_PARTITION - O5                                              
      *************************************************************             
      *                                                                         
           EXEC SQL                                                     01610000
               INCLUDE TBBTHPRT                                         01620000
           END-EXEC.                                                    01630000
      *                                                                 01640000
      *************************************************************             
      **   CSS_COMM_DATA - KO                                                   
      *************************************************************             
      *                                                                         
           EXEC SQL                                                     01641000
               INCLUDE TBCOMDAT                                                 
           END-EXEC.                                                    01643000
      *                                                                 01809700
      *************************************************************             
      **   CSS_CUST_ADDR_XREF - DM                                              
      *************************************************************             
      *                                                                         
           EXEC SQL                                                     01809800
               INCLUDE TBCSADRX                                         01809900
           END-EXEC.                                                    01810000
      *                                                                 01810100
      *************************************************************             
      **   CSS_CUSTOMER - CU                                                    
      *************************************************************             
      *                                                                         
           EXEC SQL                                                     01810200
               INCLUDE TBCUST                                           01810300
           END-EXEC.                                                    01810400
      *                                                                 01810900
      *************************************************************             
      **   CSS_CUSTOMER_BANK - JF                                               
      *************************************************************             
      *                                                                         
           EXEC SQL                                                     01810600
               INCLUDE TBCSTBNK                                         01810700
           END-EXEC.                                                    01810800
      *                                                                 01640000
      *************************************************************             
      **   CSS_DELINQUENCY - C8                                                 
      *************************************************************             
      *                                                                         
           EXEC SQL                                                     01641000
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                    01643000
      *                                                                 01644000
      *************************************************************             
      **   CSS_JOB_PARM - G6                                                    
      *************************************************************             
      *                                                                         
           EXEC SQL                                                     01650000
               INCLUDE TBJBPARM                                         01660000
           END-EXEC.                                                    01670000
      *                                                                 01804000
      *************************************************************             
      **   CSS_LOCAL_OFFICE - B1                                                
      *************************************************************             
      *                                                                         
           EXEC SQL                                                     01805000
               INCLUDE TBLOCOFC                                         01806000
           END-EXEC.                                                    01807000
      *                                                                 01808000
      *************************************************************             
      **   CSS_MNT_TRANS_HIST - MH                                              
      *************************************************************             
      *                                                                         
           EXEC SQL                                                     01808100
              INCLUDE TBMNHIST                                          01808200
           END-EXEC.                                                    01808300
      *                                                                 01808400
      *************************************************************             
      **   CSS_MT_TRN_HST_DET - MI                                              
      *************************************************************             
      *                                                                         
           EXEC SQL                                                     01808500
              INCLUDE TBMNHDT                                           01808600
           END-EXEC.                                                    01808700
      *                                                                 01680000
      *************************************************************             
      **   CSS_NAME - DQ                                                        
      *************************************************************             
      *                                                                         
           EXEC SQL                                                     01730000
               INCLUDE TBNAME                                           01740000
           END-EXEC.                                                    01750000
      *                                                                 01760000
      *************************************************************             
      **   CSS_NAME_ACCT_XREF - HT                                              
      *************************************************************             
      *                                                                         
           EXEC SQL                                                     01770000
               INCLUDE TBNMACTX                                         01780000
           END-EXEC.                                                    01790000
      *                                                                         
      *************************************************************             
      **   CSS_REG_PROFILE - LR                                                 
      *************************************************************             
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBREGPRF                                                   
           END-EXEC.                                                            
      *                                                                 01809300
      *************************************************************             
      **   CSS_ZIP_CODE - A4                                                    
      *************************************************************             
      *                                                                         
           EXEC SQL                                                     01809400
               INCLUDE TBZIPCD                                          01809500
           END-EXEC.                                                    01809600
                                                                        
P00599******************************************************************        
P00599* CSS_CORRESP_COMM  - 1L                                        *         
P00599******************************************************************        
P00599*                                                                         
P00599     EXEC SQL                                                             
P00599         INCLUDE TBCORCOM                                                 
P00599     END-EXEC.                                                            
P00599*                                                                         
P00599******************************************************************        
P00599* CSS_CORRESP_NOTICE- 1M                                        *         
P00599******************************************************************        
P00599*                                                                         
P00599     EXEC SQL                                                             
P00599         INCLUDE TBCORNOT                                                 
P00599     END-EXEC.                                                            
P00599*                                                                         
P00599******************************************************************06330000
P00599* CSS_CORRESP_HDR - 1J                                           *06340000
P00599******************************************************************06350000
P00599*                                                                         
P00599     EXEC SQL                                                             
P00599         INCLUDE TBCORHDR                                                 
P00599     END-EXEC.                                                            
P00599*                                                                         
P00599******************************************************************06330000
P00599* CSS_CORRESP_VAR - 1K                                           *06340000
P00599******************************************************************06350000
P00599*                                                                         
P00599     EXEC SQL                                                             
P00599         INCLUDE TBCORVAR                                                 
P00599     END-EXEC.                                                            
P00599*                                                                         
P00599                                                                  
      *                                                                         
      *************************************************************             
      **   TRN_HST CURSOR                                                       
      *************************************************************             
      *                                                                         
           EXEC SQL                                                     
               DECLARE TRN_HST CURSOR FOR                               
               SELECT ACCOUNT_NO                                        
                     ,AMT_ORIG_ENTERED                                  
PRJ459               ,DATE_CASH_REPORT                                  
                     ,TRAN_COMMENT                                      
               FROM  CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                    
PRJ459         WHERE DATE_CASH_REPORT = IIF(TRY_CONVERT(DATE, 
                                                         :WS-COMMONDATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMONDATE
              ) <> 0) OR (LEN(:WS-COMMONDATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-COMMONDATE
              ), CONVERT(DATE, :WS-COMMONDATE) )                  
                 AND CODE_TRAN_TYPE = 'P'                               
                 AND CIS.SUBSTR3(TRAN_COMMENT,41,10) = 'PYMT ORIG:'          
            ORDER BY ACCOUNT_NO                                         
           FOR READ ONLY                                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     01811000
MFA-TR*        DECLARE TRN_HST CURSOR FOR                               01820000
MFA-TR*        SELECT ACCOUNT_NO                                        01830000
MFA-TR*              ,AMT_ORIG_ENTERED                                  01840000
MFA-TR*              ,DATE_CASH_REPORT                                  01860000
MFA-TR*              ,TRAN_COMMENT                                      01860000
MFA-TR*        FROM  CSS_AR_TRANS_HIST                                  01890000
MFA-TR*        WHERE DATE_CASH_REPORT = :WS-COMMONDATE                  01900001
MFA-TR*          AND CODE_TRAN_TYPE = 'P'                               01940000
MFA-TR*          AND SUBSTR(TRAN_COMMENT,41,10) = 'PYMT ORIG:'                  
MFA-TR*     ORDER BY ACCOUNT_NO                                         01970000
MFA-TR*    FOR FETCH ONLY WITH UR                                               
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                    01980000
      *                                                                 02006000
       PROCEDURE DIVISION.                                              
      *                                                                 02020000
      ****************************************************************  02021000
      **                                                            **  02022000
      **  0000-MAINLINE                                             **  02023000
      **                                                            **  02024000
      ****************************************************************  02025000
      *                                                                 02020000
       0000-MAINLINE.                                                   
      *                                                                 02040000
           PERFORM 0100-INITIALIZE               THRU 0100-EXIT.        
      *                                                                 02081000
           MOVE ZERO                             TO WS-MAX-NUM.         
           MOVE 'NBR-LETTERS-PCSCA182'           TO C8-DELINQ-CD.       
           MOVE '01'                             TO C8-COMPANY-NO.      
           PERFORM 7500-SELECT-MAX-NUM           THRU 7500-EXIT.        
           MOVE C8-DELINQ-VALUE                  TO WS-MAX-NUM.         
      *                                                                 02081000
           PERFORM 1000-PROCESS-ACCOUNTS         THRU 1000-EXIT         
               UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.             
      *                                                                 02110000
           PERFORM 7200-CLOSE-TRN-HST            THRU 7200-EXIT.        
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
           STOP RUN.                                                    
      *                                                                 02150000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02180000
      ****************************************************************  02181000
      **                                                            **  02182000
      **  0100-INITIALIZE                                           **  02183000
      **                                                            **  02184000
      ****************************************************************  02185000
      *                                                                 02180000
       0100-INITIALIZE.                                                 
      *                                                                 02200000
P00599     INITIALIZE WS-CORRESP-COMM-VAR.                              
      *                                                                 02240000
P00599* TO IDENTIFY THE DATA BASE                                               
P00599     MOVE ZERO                            TO WS-CWS350-DATABASE.  
P00599     MOVE '01'                            TO C8-COMPANY-NO.       
P00599     MOVE 'DATABASE'                      TO C8-DELINQ-CD.        
           PERFORM 7500-SELECT-MAX-NUM          THRU 7500-EXIT.         
P00599     MOVE C8-DELINQ-VALUE                 TO WS-CWS350-DATABASE.  
P00599     MOVE SPACES                          TO C8-DELINQ-CD.        
P00599*                                                                         
           PERFORM 6251-GET-FJC01-DATE           THRU 6251-EXIT.        
      *                                                                 02240000
PRJ459     IF COMMON-DATE-NEEDED                                        
PRJ459        MOVE 'COMMONDATE'         TO WS-PGRMNAME                  
PRJ459        MOVE SPACES               TO WS-INPUT-AREA                
PRJ459        MOVE SPACES               TO WS-INPUT-DATA-BREAKDOWN      
PRJ459        PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT         
PRJ459        DISPLAY 'FCA00-COMMON-DATE = ' WS-FCA00-COMMON-DATE       
PRJ459        MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE                
PRJ459        MOVE PROGRAM-NAME         TO WS-PGRMNAME                  
PRJ459     END-IF.                                                      
      *                                                                 02291000
PRJ459     MOVE WS-INPUT-DATE          TO WS-COMMONDATE                 
PRJ459                                    WS-INPUT-DATE-BREAKDOWN.      
           MOVE WS-INPUT-YY-B          TO WS-STATEMENT-YY.              
           MOVE WS-INPUT-MM-B          TO WS-STATEMENT-MM.              
           MOVE WS-INPUT-DD-B          TO WS-STATEMENT-DD               
      *                                                                 02302200
           PERFORM 7000-OPEN-TRN-HST             THRU 7000-EXIT.        
           PERFORM 7100-FETCH-TRN-HST            THRU 7100-EXIT.        
      *                                                                 02605000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02630000
      ****************************************************************  02871000
      **                                                            **  02872000
      **  1000-PROCESS-ACCOUNTS                                     **  02873000
      **                                                            **  02874000
      ****************************************************************  02875000
      *                                                                 02630000
       1000-PROCESS-ACCOUNTS.                                           
      *                                                                 02890000
           MOVE WS-OLD-ACCT-NUM    TO WS-OLD-ACCT-COMP3                 
                                      AT-ACCOUNT-NO.                    
           MOVE +0                 TO WS-ATR-LTR-COUNT.                 
      *                                                                 02890000
           PERFORM 7400-SELECT-ACCOUNT  THRU 7400-EXIT.                 
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 7300-SELECT-ACCT-ATR THRU 7300-EXIT               
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 PERFORM 1200-FORMAT-NEW-ACCT-ATR THRU 1200-EXIT        
                 PERFORM 8000-INSERT-ACCT-ATTR THRU 8000-EXIT           
                 PERFORM 2100-FORMAT-LETTERS THRU 2100-EXIT             
              ELSE                                                      
                 IF YP-STATUS-CD = 'I'                                  
                    CONTINUE                                            
                 ELSE                                                   
                    PERFORM 1300-UPDATE-ACCT-ATR THRU 1300-EXIT         
                    PERFORM 8050-UPDATE-ACCT-ATTR THRU 8050-EXIT        
                    PERFORM 2100-FORMAT-LETTERS THRU 2100-EXIT          
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
           PERFORM 7100-FETCH-TRN-HST            THRU 7100-EXIT.        
      *                                                                 02920000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02920000
      ****************************************************************  02871000
      **                                                            **  02872000
      **  1200-FORMAT-NEW-ACCT-ATR.                                 **  02873000
      **                                                            **  02874000
      ****************************************************************  02875000
      *                                                                 02630000
       1200-FORMAT-NEW-ACCT-ATR.                                        
      *                                                                 02200000
           MOVE WS-OLD-ACCT-COMP3       TO YP-ACCOUNT-NO.               
           MOVE 'FB_PAYMENT_LTR'        TO YP-ATTRIBUTE-DESC.           
           MOVE 'FBLTR'                 TO YP-ATTRIBUTE-VALUE-CD.       
PRJ459     MOVE WS-COMMONDATE           TO YP-ATTRIBUTE-VALUE-DT.       
           MOVE +16                     TO YP-ATTRIBUTE-VALUE-TX-LEN.   
           MOVE +1                      TO WS-ATR-LTR-COUNT.            
           MOVE WS-ACCT-ATR-COMMENT     TO YP-ATTRIBUTE-VALUE-TX-TEXT.  
           MOVE 'A'                     TO YP-STATUS-CD.                
      *                                                                 02200000
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02920000
      ****************************************************************  02871000
      **                                                            **  02872000
      **  1300-UPDATE-ACCT-ATR.                                     **  02873000
      **                                                            **  02874000
      ****************************************************************  02875000
      *                                                                 02630000
       1300-UPDATE-ACCT-ATR.                                            
      *                                                                 02200000
           MOVE WS-OLD-ACCT-COMP3       TO YP-ACCOUNT-NO.               
PRJ459     MOVE WS-COMMONDATE           TO YP-ATTRIBUTE-VALUE-DT.       
           MOVE +16                     TO YP-ATTRIBUTE-VALUE-TX-LEN.   
           ADD  +1                      TO WS-HOLD-LTR-COUNT.           
           MOVE WS-HOLD-ATTR-VALUE-TEXT TO YP-ATTRIBUTE-VALUE-TX-TEXT.  
      *                                                                 02200000
           IF WS-HOLD-LTR-COUNT = WS-MAX-NUM                            
              MOVE 'I'                  TO YP-STATUS-CD                 
           END-IF.                                                      
      *                                                                 02220000
       1300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02920000
      ****************************************************************  02871000
      **                                                            **  02872000
      **  1400-FORMAT-COMM-REC.                                     **  02873000
      **                                                            **  02874000
      ****************************************************************  02875000
      *                                                                 02630000
       1400-FORMAT-COMM-REC.                                            
      *                                                                 02920000
           MOVE AT-ACCOUNT-NO          TO KO-ACCOUNT-NO.                
           MOVE AT-CUSTOMER-NO         TO KO-CUSTOMER-NO.               
           MOVE AT-PREMISE-NO          TO KO-PREMISE-NO.                
           MOVE AT-COMPANY-NO          TO KO-COMPANY-NO.                
           MOVE 'N'                    TO KO-RED-FLAG-IND,              
                                          KO-SCREEN-POP-IND.            
           MOVE WS-L                   TO KO-COMM-METHOD.               
           MOVE WS-O                   TO KO-COMM-DIRECTION.            
P00599     MOVE WS-CURR-COMM-TYP-CD    TO KO-COMM-TYPE-CD.              
P00599     MOVE WS-CURR-COMM-SUBTYP-CD TO KO-COMM-SUBTYPE-CODE.         
A03866     MOVE WS-MESSAGE-NO          TO KO-PROMOTION-ID.              
           MOVE 'SYSTEM'               TO KO-USER-ID-ORIG.              
           MOVE WS-SALUTATION-NAME     TO KO-CONTACT-NAME.              
           MOVE SPACES                 TO KO-RED-FLAG-EXPIRE-DT,        
                                          KO-PSC-COMPLIANCE-IND,        
                                          KO-CALL-END-TIME,             
                                          KO-INITIAL-COMMENT-TX-TEXT,   
                                          KO-RESPONSE-REASON-CD,        
                                          KO-RESPONSE-TYPE-CD,          
                                          KO-SOLICITATION-CD,           
                                          KO-DISCOVERY-MTHD-CD,         
                                          KO-PREV-MARKETER-CD.          
           MOVE ZEROES                 TO KO-CALL-ORIGIN-ID,            
                                          KO-NUMBER-TRANSFERS,          
                                          KO-HOLD-TIME,                 
                                          KO-QUEUE-TIME,                
                                          KO-TOTAL-CALL-TIME,           
                                          KO-INITIAL-COMMENT-TX-LEN.    
           IF AT-ACCOUNT-NO > 0                                         
              MOVE 'A'                 TO KO-COMM-ASSOC-CD              
           ELSE                                                         
              MOVE 'C'                 TO KO-COMM-ASSOC-CD              
           END-IF.                                                      
           MOVE 'N'                    TO KO-COMPLAINT-FL.              
           MOVE -1                     TO WS-RED-FL-NULL-IND,           
                                          WS-CALL-END-NULL-IND.         
      *                                                                 02220000
       1400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02920000
      ****************************************************************  02871000
      **                                                            **  02872000
      **  2100-FORMAT-LETTERS.                                      **  02873000
      **                                                            **  02874000
      ****************************************************************  02875000
      *                                                                 02630000
       2100-FORMAT-LETTERS.                                             
      *                                                                 02630000
           PERFORM 4000-MAIL-NAME-ADDRESS THRU 4000-EXIT.               
      *                                                                 02630000
P00599     IF WS-PREV-ACCOUNT-NO = WS-NEW-ACCT-NO                       
P00599        ADD +1                     TO WS-SEQ-NO-COUNT             
P00599     ELSE                                                         
P00599        MOVE ZERO                  TO WS-SEQ-NO-COUNT             
P00599     END-IF.                                                      
P00599     MOVE WS-SEQ-NO-COUNT          TO 1J-CORRESP-SEQ-NO.          
P00599     MOVE WS-MESSAGE-NO            TO 1J-CORRESP-MSG-ID           
P00599                                      1L-CORRESP-MSG-ID           
P00599                                      WS-MESSAGE-ID.              
P00599     MOVE AT-COMPANY-NO            TO 1J-CORRESP-COMPANY-NO       
P00599                                      1L-COMPANY-NO.              
P00599     MOVE WS-NEW-ACCT-NO           TO 1J-ACCOUNT-NO               
P00599                                      WS-PREV-ACCOUNT-NO.         
P00599     MOVE AT-CUSTOMER-NO           TO 1J-CUSTOMER-NO.             
P00599     MOVE AT-LOCAL-OFFICE          TO WS-CWS350-LOCAL-OFFICE.     
P00599     MOVE SPACES                   TO 1J-REG-GROUP-CD             
P00599     MOVE 'I'                      TO 1J-CORRESP-STATUS-CD        
P00599     MOVE ZEROES                   TO 1J-GUARNTR-ACCT-NO          
P00599                                      1J-THD-PRTY-ID              
P00599     MOVE SPACES                   TO 1J-BARCODE-UNIQUE-ID        
P00599     MOVE WS-PGRMNAME              TO 1J-CREATED-BY-PGM-ID        
P00599                                      1J-LAST-UPDATE-PGM-ID       
P00599     MOVE WS-INPUT-DATE            TO 1J-CORRESP-STMT-DT          
P00599                                      1L-EFF-TO-DT.               
      *                                                                 02630000
P00599     MOVE SPACES                   TO WS-CORRESP-ID-FND           
P00599     PERFORM 5000-CHECK-LOAD-CORRESP-TBL                          
P00599                                      THRU 5000-CPD350-EXIT.      
P00599     MOVE WS-CURR-CORRESP-TYP-CD   TO 1J-CORRESP-TYPE-CD          
P00599     PERFORM 5425-GET-CORRESP-ID-VAL  THRU 5425-CPD350-EXIT.      
P00599     PERFORM 5500-LOAD-CORRESP-VAR    THRU 5500-EXIT.             
      *                                                                 02630000
P00599     IF WS-CURR-COMM-INSERT-FL= 'Y'                               
P00599        PERFORM 1400-FORMAT-COMM-REC  THRU 1400-EXIT              
P00599        PERFORM 8200-INSERT-COMM-DATA THRU 8200-EXIT              
P00599     END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02630000
      ****************************************************************  02871000
      **                                                            **  02872000
      **  4000-NAME-MAIL-ADDRESS.                                   **  02873000
      **                                                            **  02874000
      ****************************************************************  02875000
      *                                                                 02630000
           EXEC SQL                                                     03666000
                INCLUDE CPD00074                                        03667000
           END-EXEC.                                                    03668000
      *                                                                 02630000
P00599******************************************************************        
P00599* 5000-CHECK-LOAD-CORRESP-TBL.                                   *        
P00599******************************************************************        
P00599      EXEC SQL                                                            
P00599           INCLUDE CPD00350                                               
P00599      END-EXEC.                                                           
P00599                                                                  
P00599******************************************************************        
P00599* 5500-LOAD-CORRESP-VAR.                                         *        
P00599******************************************************************        
P00599  5500-LOAD-CORRESP-VAR.                                          
P00599     INITIALIZE DCLCSS-CORRESP-VAR                                
P00599     MOVE WS-CORRESP-ID            TO 1K-CORRESP-ID .             
P00599     MOVE 'NUM-VAR-1'              TO 1K-CORRESP-VAR-NM.          
P00599     MOVE 'AR-AMT-ORIG-ENTERED'    TO 1K-CORRESP-VAR-DATA.        
P00599     MOVE AR-AMT-ORIG-ENTERED      TO 1K-CORRESP-VAR-NUM.         
P00599     PERFORM 8600-INSERT-CORRESP-VAR       THRU 8600-CPD350-EXIT. 
P00599                                                                  
P00599     INITIALIZE DCLCSS-CORRESP-VAR                                
P00599     MOVE WS-CORRESP-ID            TO 1K-CORRESP-ID .             
P00599     MOVE 'ALPHA-VAR-1'            TO 1K-CORRESP-VAR-NM.          
P00599     MOVE 'OLD-ACCOUNT-NO'         TO 1K-CORRESP-VAR-DATA.        
P00599     MOVE WS-OLD-ACCT-NO           TO 1K-CORRESP-VAR-CHAR.        
P00599                                                                  
P00599     PERFORM 8600-INSERT-CORRESP-VAR       THRU 8600-CPD350-EXIT. 
P00599                                                                  
P0599A     INITIALIZE DCLCSS-CORRESP-VAR                                
P0599A     MOVE WS-CORRESP-ID            TO 1K-CORRESP-ID .             
P0599A     MOVE 'ALPHA-VAR-2'            TO 1K-CORRESP-VAR-NM.          
P0599A     MOVE 'OLD-ADDR-FORMAT'        TO 1K-CORRESP-VAR-DATA.        
P0599A     MOVE AT-ADDRESS-FORMAT        TO 1K-CORRESP-VAR-CHAR.        
P0599A     PERFORM 8600-INSERT-CORRESP-VAR       THRU 8600-CPD350-EXIT. 
P00599                                                                  
P00599     INITIALIZE DCLCSS-CORRESP-VAR                                
P00599     MOVE WS-CORRESP-ID            TO 1K-CORRESP-ID .             
P00599     MOVE 'NUM-VAR-2'              TO 1K-CORRESP-VAR-NM.          
P00599     MOVE 'OLD-ADDRESS-ID'         TO 1K-CORRESP-VAR-DATA.        
P00599     MOVE AT-ADDRESS-ID            TO 1K-CORRESP-VAR-NUM.         
P00599     PERFORM 8600-INSERT-CORRESP-VAR       THRU 8600-CPD350-EXIT. 
P00599                                                                  
P00599  5500-EXIT.                                                      
            EXIT.                                                       
      ****************************************************************  02871000
      **                                                            **  02872000
      **  6010-REDUCE-EMBEDDED-SPACES.                              **  02873000
      **                                                            **  02874000
      ****************************************************************  02875000
      *                                                                 02630000
       COPY CPD00004.                                                   03660000
PRJ459*                                                                 02630000
PRJ459****************************************************************  02871000
PRJ459**                                                            **  02872000
PRJ459**  6240-GE-FCA00-COMMON-DATE.                                **  02873000
PRJ459**                                                            **  02874000
PRJ459****************************************************************  02875000
PRJ459*                                                                 02630000
PRJ459 COPY CPD00040.                                                   03660000
      *                                                                 02630000
      ****************************************************************  02871000
      **                                                            **  02872000
      **  6251-GET-FJC01-DATE.                                      **  02873000
      **                                                            **  02874000
      ****************************************************************  02875000
      *                                                                 02630000
       COPY CPD00037.                                                   03660000
      *                                                                 03670000
      ****************************************************************  03671000
      **                                                            **  03672000
      **  7000-OPEN-TRN-HST                                         **  03673000
      **                                                            **  03674000
      ****************************************************************  03675000
      *                                                                 03670000
       7000-OPEN-TRN-HST.                                               
      *                                                                 03690000
           MOVE '7000'                 TO WS-ABEND-PARAGRAPH.           
      *                                                                 03710000
           EXEC SQL                                                     
                OPEN TRN_HST                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 03740100
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 03741100
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE SQLCODE             TO WS-SQLCODE                    
              DISPLAY '*============================================*'  
              DISPLAY '*==========      PCSCA182       =============*'  
              DISPLAY '*============================================*'  
              DISPLAY '*========== BAD SQL RETURN CODE =============*'  
              DISPLAY '*============================================*'  
              DISPLAY '*  ERROR OPENING  TRN_HST CURSOR   *'            
              DISPLAY '*  PARAGRAPH: ' WS-ABEND-PARAGRAPH               
                      '                           *'                    
              DISPLAY '*  SQLCODE..: ' WS-SQLCODE                       
                      '                     *'                          
              DISPLAY '*============================================*'  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 03920000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03950000
      ****************************************************************  03957100
      **                                                            **  03957200
      **  7100-FETCH-HST-TRN                                        **  03957300
      **                                                            **  03957400
      ****************************************************************  03957500
      *                                                                 03950000
       7100-FETCH-TRN-HST.                                              
      *                                                                 03970000
           MOVE '7100'                 TO WS-ABEND-PARAGRAPH.           
      *                                                                 03990000
           EXEC SQL                                                     
                FETCH TRN_HST INTO                                      
                      :AR-ACCOUNT-NO                                    
                     ,:AR-AMT-ORIG-ENTERED                              
PRJ459               ,:AR-DATE-CASH-REPORT                              
                     ,:AR-TRAN-COMMENT                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 04090000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 04091100
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE AR-ACCOUNT-NO               TO WS-NEW-ACCT-NO        
              MOVE AR-TRAN-COMMENT-TEXT(52:13) TO WS-OLD-ACCT-NO        
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 CONTINUE                                               
              ELSE                                                      
                 MOVE SQLCODE            TO WS-SQLCODE                  
                 DISPLAY '*=======================================*'    
                 DISPLAY '*========      PCSCA182       ==========*'    
                 DISPLAY '*=======================================*'    
                 DISPLAY '*======== BAD SQL RETURN CODE ==========*'    
                 DISPLAY '*=======================================*'    
                 DISPLAY '*  ERROR IN FETCH TRN_HST      *'             
                 DISPLAY '*  PARAGRAPH: ' WS-ABEND-PARAGRAPH            
                         '                           *'                 
                 DISPLAY '*  SQLCODE..: ' WS-SQLCODE                    
                         '                     *'                       
                 DISPLAY '*=======================================*'    
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                 04251000
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04280000
      ****************************************************************  04281000
      **                                                            **  04282000
      **  7200-CLOSE-TRN-HST                                        **  04283000
      **                                                            **  04284000
      ****************************************************************  04285000
      *                                                                 04280000
       7200-CLOSE-TRN-HST.                                              
      *                                                                 04300000
           MOVE '7200'                 TO WS-ABEND-PARAGRAPH.           
      *                                                                 04320000
           EXEC SQL                                                     
                CLOSE TRN_HST                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 04360000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 04361100
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE            TO WS-SQLCODE                     
              DISPLAY '*=======================================*'       
              DISPLAY '*========      PCSCA182       ==========*'       
              DISPLAY '*=======================================*'       
              DISPLAY '*======== BAD SQL RETURN CODE ==========*'       
              DISPLAY '*=======================================*'       
              DISPLAY '*  ERROR CLOSING TRN_HST                     *'  
              DISPLAY '*  PARAGRAPH: ' WS-ABEND-PARAGRAPH               
                      '                           *'                    
              DISPLAY '*  SQLCODE..: ' WS-SQLCODE                       
                      '                     *'                          
              DISPLAY '*=======================================*'       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 04521000
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04521000
      ****************************************************************  04551000
      **                                                            **  04552000
      **  7300-SELECT-ACCT-ATR                                      **  04553000
      **                                                            **  04554000
      ****************************************************************  04555000
      *                                                                 04521000
       7300-SELECT-ACCT-ATR.                                            
      *                                                                 04570000
           MOVE '7300'                 TO WS-ABEND-PARAGRAPH.           
           MOVE WS-OLD-ACCT-COMP3      TO YP-ACCOUNT-NO.                
      *                                                                 04590000
           EXEC SQL                                                     
                SELECT  ACCOUNT_NO                                      
                       ,ATTRIBUTE_DESC                                  
                       ,ATTRIBUTE_VALUE_CD                              
                       ,ATTRIBUTE_VALUE_DT                              
                       ,ATTRIBUTE_VALUE_TX                              
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), CREATED_TS
           , 121), ' ', '-'), ':', '.') CREATED_TS                             
                       ,STATUS_CD                                       
                  INTO :YP-ACCOUNT-NO                                   
                      ,:YP-ATTRIBUTE-DESC                               
                      ,:YP-ATTRIBUTE-VALUE-CD                           
                      ,:YP-ATTRIBUTE-VALUE-DT                           
                      ,:YP-ATTRIBUTE-VALUE-TX                           
                      ,:YP-CREATED-TS                                   
                      ,:YP-STATUS-CD                                    
                  FROM CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                 
                 WHERE ACCOUNT_NO = :YP-ACCOUNT-NO                      
                   AND ATTRIBUTE_DESC = 'FB_PAYMENT_LTR'                
                   AND ATTRIBUTE_VALUE_CD = 'FBLTR'                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     04600000
MFA-TR*         SELECT  ACCOUNT_NO                                      04610000
MFA-TR*                ,ATTRIBUTE_DESC                                  04611000
MFA-TR*                ,ATTRIBUTE_VALUE_CD                              04620000
MFA-TR*                ,ATTRIBUTE_VALUE_DT                              04640000
MFA-TR*                ,ATTRIBUTE_VALUE_TX                              04650000
MFA-TR*                ,CREATED_TS                                      04650000
MFA-TR*                ,STATUS_CD                                       04670000
MFA-TR*           INTO :YP-ACCOUNT-NO                                   04690000
MFA-TR*               ,:YP-ATTRIBUTE-DESC                               04691000
MFA-TR*               ,:YP-ATTRIBUTE-VALUE-CD                           04700000
MFA-TR*               ,:YP-ATTRIBUTE-VALUE-DT                           04720000
MFA-TR*               ,:YP-ATTRIBUTE-VALUE-TX                           04730000
MFA-TR*               ,:YP-CREATED-TS                                   04750000
MFA-TR*               ,:YP-STATUS-CD                                    04750000
MFA-TR*           FROM CSS_ACCT_ATTRIBUTE                               04770000
MFA-TR*          WHERE ACCOUNT_NO = :YP-ACCOUNT-NO                      04780000
MFA-TR*            AND ATTRIBUTE_DESC = 'FB_PAYMENT_LTR'                        
MFA-TR*            AND ATTRIBUTE_VALUE_CD = 'FBLTR'                             
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                    04790000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 04800000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 04811000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE YP-ATTRIBUTE-VALUE-TX-TEXT TO WS-HOLD-ATTR-VALUE-TEXT
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 CONTINUE                                               
              ELSE                                                      
                 MOVE SQLCODE            TO WS-SQLCODE                  
                 DISPLAY '*=====================================*'      
                 DISPLAY '*========      PCSCA182       ========*'      
                 DISPLAY '*=====================================*'      
                 DISPLAY '*======== BAD SQL RETURN CODE ========*'      
                 DISPLAY '*=====================================*'      
                 DISPLAY '* SELECT FAILED IN CSS_ACCT_ATTRIBUTE *'      
                 DISPLAY '* PARAGRAPH: ' WS-ABEND-PARAGRAPH             
                         '                          *'                  
                 DISPLAY '* ACCOUNT_NO = ' YP-ACCOUNT-NO                
                 DISPLAY '* SQLCODE..:   ' WS-SQLCODE                   
                         '                     *'                       
                 DISPLAY '*=====================================*'      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                 04962000
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04521000
      ****************************************************************  04551000
      **                                                            **  04552000
      **  7400-SELECT-ACCOUNT                                       **  04553000
      **                                                            **  04554000
      ****************************************************************  04555000
      *                                                                 04521000
       7400-SELECT-ACCOUNT.                                             
      *                                                                 04570000
           MOVE '7400'                 TO WS-ABEND-PARAGRAPH.           
      *                                                                 04590000
           EXEC SQL                                                     
                SELECT  CUSTOMER_NO                                     
                       ,BILL_CYCLE                                      
                       ,TOTAL_AR_BALANCE                                
                       ,PREMISE_NO                                      
                       ,DATE_LAST_ACTION                                
                       ,CODES_DATA_PRESENT                              
                       ,ADDRESS_ID                                      
                       ,COMPANY_NO                                      
                       ,EPP_OFFER_AMOUNT                                
                       ,ADDRESS_FORMAT                                  
                       ,LOCAL_OFFICE                                    
                  INTO :AT-CUSTOMER-NO                                  
                      ,:AT-BILL-CYCLE                                   
                      ,:AT-TOTAL-AR-BALANCE                             
                      ,:AT-PREMISE-NO                                   
                      ,:AT-DATE-LAST-ACTION                             
                      ,:AT-CODES-DATA-PRESENT                           
                      ,:AT-ADDRESS-ID                                   
                      ,:AT-COMPANY-NO                                   
                      ,:AT-EPP-OFFER-AMOUNT                             
                      ,:AT-ADDRESS-FORMAT                               
                      ,:AT-LOCAL-OFFICE                                 
                  FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                        
                 WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                  
                   AND CODE_ACCT_STAT = 'B'                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04600000
MFA-TR*         SELECT  CUSTOMER_NO                                     04610000
MFA-TR*                ,BILL_CYCLE                                      04611000
MFA-TR*                ,TOTAL_AR_BALANCE                                04620000
MFA-TR*                ,PREMISE_NO                                      04640000
MFA-TR*                ,DATE_LAST_ACTION                                04650000
MFA-TR*                ,CODES_DATA_PRESENT                              04660000
MFA-TR*                ,ADDRESS_ID                                      04670000
MFA-TR*                ,COMPANY_NO                                      04670000
MFA-TR*                ,EPP_OFFER_AMOUNT                                04670000
MFA-TR*                ,ADDRESS_FORMAT                                  04670000
MFA-TR*                ,LOCAL_OFFICE                                    04670000
MFA-TR*           INTO :AT-CUSTOMER-NO                                  04690000
MFA-TR*               ,:AT-BILL-CYCLE                                   04691000
MFA-TR*               ,:AT-TOTAL-AR-BALANCE                             04700000
MFA-TR*               ,:AT-PREMISE-NO                                   04720000
MFA-TR*               ,:AT-DATE-LAST-ACTION                             04730000
MFA-TR*               ,:AT-CODES-DATA-PRESENT                           04740000
MFA-TR*               ,:AT-ADDRESS-ID                                   04750000
MFA-TR*               ,:AT-COMPANY-NO                                   04750000
MFA-TR*               ,:AT-EPP-OFFER-AMOUNT                             04750000
MFA-TR*               ,:AT-ADDRESS-FORMAT                               04750000
MFA-TR*               ,:AT-LOCAL-OFFICE                                 04750000
MFA-TR*           FROM CSS_ACCOUNT                                      04770000
MFA-TR*          WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                  04780000
MFA-TR*            AND CODE_ACCT_STAT = 'B'                             04780000
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7400                                                     
MFA-TR*    END-EXEC.                                                    04790000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 04800000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 04811000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE            TO WS-SQLCODE                     
              DISPLAY '*=====================================*'         
              DISPLAY '*========      PCSCA182       ========*'         
              DISPLAY '*=====================================*'         
              DISPLAY '*======== BAD SQL RETURN CODE ========*'         
              DISPLAY '*=====================================*'         
              DISPLAY '* SELECT FAILED IN CSS_ACCOUNT        *'         
              DISPLAY '* PARAGRAPH: ' WS-ABEND-PARAGRAPH                
                      '                          *'                     
              DISPLAY '* ACCOUNT_NO = ' YP-ACCOUNT-NO                   
              DISPLAY '* SQLCODE..:   ' WS-SQLCODE                      
                      '                    *'                           
              DISPLAY '*=====================================*'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 04962000
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02180000
      ****************************************************************  02181000
      **                                                            **  02182000
      **  7500-SELECT-MAX-NUM                                       **  02183000
      **                                                            **  02184000
      ****************************************************************  02185000
      *                                                                 02180000
       7500-SELECT-MAX-NUM.                                             
      *                                                                 02200000
           MOVE '7500'                 TO WS-ABEND-PARAGRAPH.           
      *                                                                 03690000
           EXEC SQL                                                     
               SELECT DELINQ_VALUE                                      
                 INTO :C8-DELINQ-VALUE                                  
                 FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
                WHERE DELINQ_CD  = :C8-DELINQ-CD                        
                  AND COMPANY_NO = :C8-COMPANY-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DELINQ_VALUE                                              
MFA-TR*          INTO :C8-DELINQ-VALUE                                          
MFA-TR*          FROM CSS_DELINQUENCY                                           
MFA-TR*         WHERE DELINQ_CD  = :C8-DELINQ-CD                                
MFA-TR*           AND COMPANY_NO = :C8-COMPANY-NO                               
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE            TO WS-SQLCODE                     
              DISPLAY '*=====================================*'         
              DISPLAY '*========      PCSCA182       ========*'         
              DISPLAY '*=====================================*'         
              DISPLAY '*======== BAD SQL RETURN CODE ========*'         
              DISPLAY '*=====================================*'         
              DISPLAY '* SELECT FAILED IN CSS_DELINQUENCY    *'         
              DISPLAY '* PARAGRAPH: ' WS-ABEND-PARAGRAPH                
                      '                          *'                     
              DISPLAY '* DELINQ_CD = ' C8-DELINQ-CD                     
              DISPLAY '* SQLCODE..:   ' WS-SQLCODE                      
                      '                     *'                          
              DISPLAY '*=====================================*'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06000000
      ****************************************************************  02871000
      **                                                            **  02872000
      **  7600-START-FCSJC01.                                       **  02873000
      **  7610-READ-FCSJC01.                                        **  02873000
      **                                                            **  02874000
      ****************************************************************  02875000
      *                                                                 06040000
           EXEC SQL                                                     05970000
               INCLUDE CPD00038                                         05980000
           END-EXEC.                                                    05990000
      *                                                                 03950000
      ****************************************************************  02871000
      **                                                            **  02872000
      **  7620-START-FCSCA00.                                       **  02873000
      **  7621-START-FCSCA00.                                       **  02873000
      **  7622-CLOSE-CA00-CSR.                                      **  02873000
      **                                                            **  02874000
      ****************************************************************  02875000
      *                                                                 06040000
           EXEC SQL                                                     06010000
               INCLUDE CPD00039                                         06020000
           END-EXEC.                                                    06030000
      *                                                                 06040000
      ****************************************************************  02871000
      **                                                            **  02872000
      **  8000-INSERT-ACCT-ATTR.                                    **  02873000
      **                                                            **  02874000
      ****************************************************************  02875000
      *                                                                 06040000
       8000-INSERT-ACCT-ATTR.                                           
      *                                                                 06040000
           MOVE '8000'                 TO WS-ABEND-PARAGRAPH.           
      *                                                                 06040000
           EXEC SQL                                                     
                INSERT INTO CSS_ACCT_ATTRIBUTE                          
                       (                                                
                        ACCOUNT_NO                                      
                       ,ATTRIBUTE_DESC                                  
                       ,ATTRIBUTE_VALUE_CD                              
                       ,ATTRIBUTE_VALUE_DT                              
                       ,ATTRIBUTE_VALUE_TX                              
                       ,CREATED_TS                                      
                       ,STATUS_CD                                       
                       )                                                
                VALUES                                                  
                       (                                                
                        :YP-ACCOUNT-NO                                  
                       ,:YP-ATTRIBUTE-DESC                              
                       ,:YP-ATTRIBUTE-VALUE-CD                          
                       ,IIF(TRY_CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT
              ) IS NULL OR (PATINDEX('%.%', :YP-ATTRIBUTE-VALUE-DT
              ) <> 0) OR (LEN(:YP-ATTRIBUTE-VALUE-DT
              ) <> 10), CIS.CHAR2DATE(:YP-ATTRIBUTE-VALUE-DT
              ), CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT) )                       
                       ,:YP-ATTRIBUTE-VALUE-TX                          
                       ,CIS.CURRENT$TIMESTAMP()                               
                       ,:YP-STATUS-CD                                   
                       )                                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_ACCT_ATTRIBUTE                                  
MFA-TR*                (                                                        
MFA-TR*                 ACCOUNT_NO                                              
MFA-TR*                ,ATTRIBUTE_DESC                                          
MFA-TR*                ,ATTRIBUTE_VALUE_CD                                      
MFA-TR*                ,ATTRIBUTE_VALUE_DT                                      
MFA-TR*                ,ATTRIBUTE_VALUE_TX                                      
MFA-TR*                ,CREATED_TS                                              
MFA-TR*                ,STATUS_CD                                               
MFA-TR*                )                                                        
MFA-TR*         VALUES                                                          
MFA-TR*                (                                                        
MFA-TR*                 :YP-ACCOUNT-NO                                          
MFA-TR*                ,:YP-ATTRIBUTE-DESC                                      
MFA-TR*                ,:YP-ATTRIBUTE-VALUE-CD                                  
MFA-TR*                ,:YP-ATTRIBUTE-VALUE-DT                                  
MFA-TR*                ,:YP-ATTRIBUTE-VALUE-TX                                  
MFA-TR*                ,CURRENT TIMESTAMP                                       
MFA-TR*                ,:YP-STATUS-CD                                           
MFA-TR*                )                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE TO WS-SQLCODE                                
              DISPLAY '*=====================================*'         
              DISPLAY '*========      PCSCA182       ========*'         
              DISPLAY '*=====================================*'         
              DISPLAY '*======== BAD SQL RETURN CODE ========*'         
              DISPLAY '*=====================================*'         
              DISPLAY '* INSERT FAILED IN CSS_ACCT_ATTRIBUTE *'         
              DISPLAY '* PARAGRAPH: ' WS-ABEND-PARAGRAPH                
                      '                          *'                     
              DISPLAY '* ACCOUNT_NO = ' YP-ACCOUNT-NO                   
              DISPLAY '* SQLCODE..:   ' WS-SQLCODE                      
                      '                    *'                           
              DISPLAY '*=====================================*'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 04962000
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06040000
      ****************************************************************  02871000
      **                                                            **  02872000
      **  8050-UPDATE-ACCT-ATTR.                                    **  02873000
      **                                                            **  02874000
      ****************************************************************  02875000
      *                                                                 06040000
       8050-UPDATE-ACCT-ATTR.                                           
      *                                                                 06040000
           MOVE '8050'                 TO WS-ABEND-PARAGRAPH.           
      *                                                                 06040000
           EXEC SQL                                                     
                UPDATE CSS_ACCT_ATTRIBUTE                               
                   SET ATTRIBUTE_VALUE_DT = IIF(TRY_CONVERT(DATE, 
                                                 :YP-ATTRIBUTE-VALUE-DT
              ) IS NULL OR (PATINDEX('%.%', :YP-ATTRIBUTE-VALUE-DT
              ) <> 0) OR (LEN(:YP-ATTRIBUTE-VALUE-DT
              ) <> 10), CIS.CHAR2DATE(:YP-ATTRIBUTE-VALUE-DT
              ), CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT) )      
                      ,ATTRIBUTE_VALUE_TX = :YP-ATTRIBUTE-VALUE-TX      
PRJ459*               ,CREATED_TS         = CURRENT TIMESTAMP                   
                      ,STATUS_CD          = :YP-STATUS-CD               
                 WHERE ACCOUNT_NO         = :YP-ACCOUNT-NO              
                   AND ATTRIBUTE_DESC     = 'FB_PAYMENT_LTR'            
                   AND ATTRIBUTE_VALUE_CD = 'FBLTR'                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_ACCT_ATTRIBUTE                                       
MFA-TR*            SET ATTRIBUTE_VALUE_DT = :YP-ATTRIBUTE-VALUE-DT              
MFA-TR*               ,ATTRIBUTE_VALUE_TX = :YP-ATTRIBUTE-VALUE-TX              
MFA-TR*               ,CREATED_TS         = CURRENT TIMESTAMP                   
MFA-TR*               ,STATUS_CD          = :YP-STATUS-CD                       
MFA-TR*          WHERE ACCOUNT_NO         = :YP-ACCOUNT-NO                      
MFA-TR*            AND ATTRIBUTE_DESC     = 'FB_PAYMENT_LTR'                    
MFA-TR*            AND ATTRIBUTE_VALUE_CD = 'FBLTR'                             
MFA-TR*        QUERYNO 8050                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE TO WS-SQLCODE                                
              DISPLAY '*=====================================*'         
              DISPLAY '*=========      PCSCA182       =======*'         
              DISPLAY '*=====================================*'         
              DISPLAY '*========= BAD SQL RETURN CODE =======*'         
              DISPLAY '*=====================================*'         
              DISPLAY '* UPDATE FAILED IN CSS_ACCT_ATTRIBUTE *'         
              DISPLAY '* PARAGRAPH: ' WS-ABEND-PARAGRAPH                
                      '                          *'                     
              DISPLAY '* ACCOUNT_NO = ' YP-ACCOUNT-NO                   
              DISPLAY '* SQLCODE..:   ' WS-SQLCODE                      
                      '                    *'                           
              DISPLAY '*=====================================*'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 04962000
       8050-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04962000
      ****************************************************************  06101000
      **                                                            **  06102000
      **  8200-INSERT-COMM-DATA.                                    **  06103000
      **                                                            **  06104000
      ****************************************************************  06105000
      *                                                                 04962000
       8200-INSERT-COMM-DATA.                                           
      *                                                                 06701100
           MOVE '8200'                 TO WS-ABEND-PARAGRAPH.           
      *                                                                 06701100
           EXEC SQL                                                     
              INSERT INTO CSS_COMM_DATA                                 
                    (COMMUNICATION_ID,                                  
                     ACCOUNT_NO,                                        
                     CUSTOMER_NO,                                       
                     PREMISE_NO,                                        
                     COMPANY_NO,                                        
                     RED_FLAG_IND,                                      
                     RED_FLAG_EXPIRE_DT,                                
                     COMM_METHOD,                                       
                     COMM_DIRECTION,                                    
                     COMM_TYPE_CD,                                      
                     COMM_SUBTYPE_CODE,                                 
                     USER_ID_ORIG,                                      
                     CONTACT_NAME,                                      
                     PROMOTION_ID,                                      
                     PSC_COMPLIANCE_IND,                                
                     CALL_ORIGIN_ID,                                    
                     CALL_END_TIME,                                     
                     NUMBER_TRANSFERS,                                  
                     HOLD_TIME,                                         
                     QUEUE_TIME,                                        
                     SCREEN_POP_IND,                                    
                     TOTAL_CALL_TIME,                                   
                     INITIAL_COMMENT_TX,                                
                     RESPONSE_REASON_CD,                                
                     RESPONSE_TYPE_CD,                                  
                     SOLICITATION_CD,                                   
                     COMM_ASSOC_CD,                                     
                     COMPLAINT_FL,                                      
                     DISCOVERY_MTHD_CD,                                 
                     PREV_MARKETER_CD)                                  
              VALUES                                                    
                    (CIS.CURRENT$TIMESTAMP(),                                 
                    :KO-ACCOUNT-NO,                                     
                    :KO-CUSTOMER-NO,                                    
                    :KO-PREMISE-NO,                                     
                    :KO-COMPANY-NO,                                     
                    :KO-RED-FLAG-IND,                                   
                    CIS.CHAR2TIMESTAMP(:KO-RED-FLAG-EXPIRE-DT 
                                       :WS-RED-FL-NULL-IND),          
                    :KO-COMM-METHOD,                                    
                    :KO-COMM-DIRECTION,                                 
                    :KO-COMM-TYPE-CD,                                   
                    :KO-COMM-SUBTYPE-CODE,                              
                    :KO-USER-ID-ORIG,                                   
                    :KO-CONTACT-NAME,                                   
                    :KO-PROMOTION-ID,                                   
                    :KO-PSC-COMPLIANCE-IND,                             
                    :KO-CALL-ORIGIN-ID,                                 
                    CIS.CHAR2TIMESTAMP(:KO-CALL-END-TIME 
                                       :WS-CALL-END-NULL-IND),             
                    :KO-NUMBER-TRANSFERS,                               
                    :KO-HOLD-TIME,                                      
                    :KO-QUEUE-TIME,                                     
                    :KO-SCREEN-POP-IND,                                 
                    :KO-TOTAL-CALL-TIME,                                
                    :KO-INITIAL-COMMENT-TX,                             
                    :KO-RESPONSE-REASON-CD,                             
                    :KO-RESPONSE-TYPE-CD,                               
                    :KO-SOLICITATION-CD,                                
                    :KO-COMM-ASSOC-CD,                                  
                    :KO-COMPLAINT-FL,                                   
                    :KO-DISCOVERY-MTHD-CD,                              
                    :KO-PREV-MARKETER-CD)                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06701400
MFA-TR*       INSERT INTO CSS_COMM_DATA                                 06701500
MFA-TR*             (COMMUNICATION_ID,                                          
MFA-TR*              ACCOUNT_NO,                                                
MFA-TR*              CUSTOMER_NO,                                               
MFA-TR*              PREMISE_NO,                                                
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              RED_FLAG_IND,                                              
MFA-TR*              RED_FLAG_EXPIRE_DT,                                        
MFA-TR*              COMM_METHOD,                                               
MFA-TR*              COMM_DIRECTION,                                            
MFA-TR*              COMM_TYPE_CD,                                              
MFA-TR*              COMM_SUBTYPE_CODE,                                         
MFA-TR*              USER_ID_ORIG,                                              
MFA-TR*              CONTACT_NAME,                                              
MFA-TR*              PROMOTION_ID,                                              
MFA-TR*              PSC_COMPLIANCE_IND,                                        
MFA-TR*              CALL_ORIGIN_ID,                                            
MFA-TR*              CALL_END_TIME,                                             
MFA-TR*              NUMBER_TRANSFERS,                                          
MFA-TR*              HOLD_TIME,                                                 
MFA-TR*              QUEUE_TIME,                                                
MFA-TR*              SCREEN_POP_IND,                                            
MFA-TR*              TOTAL_CALL_TIME,                                           
MFA-TR*              INITIAL_COMMENT_TX,                                        
MFA-TR*              RESPONSE_REASON_CD,                                        
MFA-TR*              RESPONSE_TYPE_CD,                                          
MFA-TR*              SOLICITATION_CD,                                           
MFA-TR*              COMM_ASSOC_CD,                                             
MFA-TR*              COMPLAINT_FL,                                              
MFA-TR*              DISCOVERY_MTHD_CD,                                         
MFA-TR*              PREV_MARKETER_CD)                                          
MFA-TR*       VALUES                                                            
MFA-TR*             (CURRENT TIMESTAMP,                                         
MFA-TR*             :KO-ACCOUNT-NO,                                             
MFA-TR*             :KO-CUSTOMER-NO,                                            
MFA-TR*             :KO-PREMISE-NO,                                             
MFA-TR*             :KO-COMPANY-NO,                                             
MFA-TR*             :KO-RED-FLAG-IND,                                           
MFA-TR*             :KO-RED-FLAG-EXPIRE-DT:WS-RED-FL-NULL-IND,                  
MFA-TR*             :KO-COMM-METHOD,                                            
MFA-TR*             :KO-COMM-DIRECTION,                                         
MFA-TR*             :KO-COMM-TYPE-CD,                                           
MFA-TR*             :KO-COMM-SUBTYPE-CODE,                                      
MFA-TR*             :KO-USER-ID-ORIG,                                           
MFA-TR*             :KO-CONTACT-NAME,                                           
MFA-TR*             :KO-PROMOTION-ID,                                           
MFA-TR*             :KO-PSC-COMPLIANCE-IND,                                     
MFA-TR*             :KO-CALL-ORIGIN-ID,                                         
MFA-TR*             :KO-CALL-END-TIME:WS-CALL-END-NULL-IND,                     
MFA-TR*             :KO-NUMBER-TRANSFERS,                                       
MFA-TR*             :KO-HOLD-TIME,                                              
MFA-TR*             :KO-QUEUE-TIME,                                             
MFA-TR*             :KO-SCREEN-POP-IND,                                         
MFA-TR*             :KO-TOTAL-CALL-TIME,                                        
MFA-TR*             :KO-INITIAL-COMMENT-TX,                                     
MFA-TR*             :KO-RESPONSE-REASON-CD,                                     
MFA-TR*             :KO-RESPONSE-TYPE-CD,                                       
MFA-TR*             :KO-SOLICITATION-CD,                                        
MFA-TR*             :KO-COMM-ASSOC-CD,                                          
MFA-TR*             :KO-COMPLAINT-FL,                                           
MFA-TR*             :KO-DISCOVERY-MTHD-CD,                                      
MFA-TR*             :KO-PREV-MARKETER-CD)                                       
MFA-TR*    END-EXEC.                                                    06703600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 06703700
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 06703900
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE            TO WS-SQLCODE                    
               DISPLAY '*=======================================*'      
               DISPLAY '*========      PCSCA182       ==========*'      
               DISPLAY '*=======================================*'      
               DISPLAY '*======== BAD SQL RETURN CODE ==========*'      
               DISPLAY '*=======================================*'      
               DISPLAY '* ERROR INSERTING INTO CSS_COMM_DATA    *'      
               DISPLAY '* PARAGRAPH: ' WS-ABEND-PARAGRAPH               
                       '                          *'                    
               DISPLAY '* ACCOUNT-NO = ' KO-ACCOUNT-NO                  
               DISPLAY '* SQLCODE..: ' WS-SQLCODE                       
                       '                    *'                          
               DISPLAY '*=======================================*'      
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 06705600
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  06707000
      **                                                            **  06708000
      **  9000-TERMINATE                                            **  06709000
      **                                                            **  06709100
      ****************************************************************  06709200
      *                                                                 06109100
       9000-TERMINATE.                                                  
      *                                                                 06712000
           DISPLAY '<<< PCSCA182 COMPLETED >>>'.                        
      *                                                                 06712000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06770000
      ****************************************************************  06770100
      **                                                            **  06709100
      **  9700-PROCESS-ABEND.                                       **  06771000
      **                                                            **  06709100
      ****************************************************************  06772000
      *                                                                 06773000
       COPY CPD0023B.                                                   06772100
      *                                                                 06773000
      ****************************************************************  06707000
      **                                                            **  06708000
      **  9900-ABEND.                                               **  06709000
      **                                                            **  06709100
      ****************************************************************  06709200
      *                                                                 06109100
           EXEC SQL                                                     06780000
               INCLUDE CPD09900                                         06790000
           END-EXEC.                                                    06800000
      *                                                                 06810000
