       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA181.                                        
      *****************************************************************         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **  --------  --------     ----------------------------------  **         
      **  11-2009   RAJ          INITIAL VERSION OF THE PROGRAM      **         
      *****************************************************************         
                                                                        
      *****************************************************************         
      **                     PCSCA181 NARRATIVE                      **         
      **                                                             **         
      **  THIS PROGRAM GENERATES THE SEQUENCE NUMBERS AND PUTS THE   **         
      **  TOTAL NUMBER OF THE SHEETS IN THE ENVELOPE TO THE FIRST    **         
      **  ACCOUNT IN THE GROUP FOR G5 MULTIPLES.                     **         
      **                     CHANGE SUMMARY                          **         
PRJ166** 11/2009    RAJ      INITIAL VERSION - OUTPUT MANAGEMENT.    **         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           COPY CSSCA911.                                                       
           COPY CSSCA912.                                                       
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
           COPY CFDCA911.                                                       
           COPY SORTINDX.                                                       
           COPY CFDCA912.                                                       
CISOP  01  E-SRT-IDX-REC                     PIC X(802).                
                                                                        
       WORKING-STORAGE SECTION.                                         
                                                                        
           COPY CWS09900.                                                       
                                                                        
       01  WS-MISC.                                                     
           05  WS-PREV-G5-SUB-SEQ            PIC 9(02) VALUE ZEROES.    
           05  WS-SUB1                       PIC S9(7) COMP-3 VALUE +0. 
           05  WS-FIRST-TIME-SW              PIC X  VALUE ' '.          
               88  FIRST-TIME                       VALUE 'Y'.          
           05  WS-HOLD-MULTI-SHEETS          PIC 9(4) VALUE 0.          
           05  WS-SHEETS-IN-THIS-ACCT        PIC 9(4) VALUE 0.          
           05  WS-HOLD-SRT-IDX-TBL.                                     
               10  WS-HOLD-SRT-IDX OCCURS 10 TIMES.                     
                   15  WS-HOLD-SRT-IDX-DATA  PIC X(802) VALUE SPACES.   
                   15  FILLER REDEFINES WS-HOLD-SRT-IDX-DATA.           
                       20 FILLER             PIC X(725).                
                       20 WS-SHEETS-IN-ENV   PIC 9(4).                  
                       20 FILLER             PIC X(73).                 
           05  WS-CA911-STATUS               PIC XX VALUE '  '.         
               88  CA911-SUCCESSFUL                 VALUE '00'.         
           05  WS-CA912-STATUS               PIC XX VALUE '  '.         
               88  CA912-SUCCESSFUL                 VALUE '00'.         
           05  WS-SEQUENCE-NO                PIC S9(13) COMP VALUE 0.   
           05  WS-PREV-MULTIPLE-ID           PIC S9(11) COMP.           
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-END-OF-CA911               PIC X VALUE 'N'.           
               88  END-OF-CA911               VALUE 'Y'.                
           05  WS-ACCOUNT-CHANGE-SW          PIC X VALUE 'N'.           
               88  ACCOUNT-CHANGE             VALUE 'Y'.                
                                                                        
       01  WS-CALLING-PARAGRAPH              PIC X(4).                  
                                                                        
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME            PIC X(08)     VALUE 'PCSCA181'.  
           05  WS-COMMON               PIC X(08)     VALUE 'COMMON  '.  
           05  WS-N                    PIC X(01)     VALUE 'N'.         
           05  WS-Y                    PIC X(01)     VALUE 'Y'.         
           05  WS-1                    PIC X(01)     VALUE '1'.         
           05  WS-YES                  PIC X(01)     VALUE 'Y'.         
           05  WS-NO                   PIC X(01)     VALUE 'N'.         
           05  WS-DASHES               PIC X(10)     VALUE ALL '-'.     
           05  WS-USERABEN             PIC X(08)     VALUE 'USERABEN'.  
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
      *****************************************************************         
      *  MAIN PROCESS AREA.                                           *         
      *****************************************************************         
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION      THRU  0100-EXIT.            
                                                                        
           PERFORM 1000-PROCESS-ACCOUNTS    THRU 1000-EXIT.             
                                                                        
           PERFORM 9000-TERMINATE           THRU 9000-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  OPEN FILES.  GET DATES, TIMES, TITLES FOR REPORT HEADERS.    *         
      *****************************************************************         
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           OPEN INPUT  FCSCA911-FILE                                    
                OUTPUT FCSCA912-FILE.                                   
           IF WS-CA911-STATUS NOT = '00'                                
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZATION              '         
               DISPLAY '**   ERROR OPENING FCSCA911'                    
               DISPLAY '**   FILE STATUS = ' WS-CA911-STATUS            
               DISPLAY '**************************************'         
               MOVE 12                      TO RETURN-CODE              
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
           END-IF.                                                      
                                                                        
           IF WS-CA912-STATUS NOT = '00'                                
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZATION              '         
               DISPLAY '**   ERROR OPENING FCSCA912'                    
               DISPLAY '**   FILE STATUS = ' WS-CA912-STATUS            
               DISPLAY '**************************************'         
               MOVE 12                      TO RETURN-CODE              
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
           END-IF.                                                      
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *   1000-PROCESS-ACCOUNTS.                                 *              
      ************************************************************              
                                                                        
       1000-PROCESS-ACCOUNTS.                                           
                                                                        
           PERFORM 7000-READ-FCSCA911       THRU 7000-EXIT.             
                                                                        
           SET FIRST-TIME                   TO TRUE.                    
           PERFORM 2000-DETAIL-PROCESSING   THRU 2000-EXIT              
                                            UNTIL END-OF-CA911.         
                                                                        
           PERFORM 8000-WRITE-SORT-IDX      THRU 8000-EXIT.             
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  THIS ROUTINE ACCUMULATES THE TOTAL SHEETS IN ENVELOPE AND    *         
      *  WRITES OUTPUT ONLY WHEN SUB SEQUENCE OR MULTI ID CHANGES.    *         
      *****************************************************************         
                                                                        
       2000-DETAIL-PROCESSING.                                          
                                                                        
           IF FIRST-TIME                                                
              MOVE EXT-SRT-MULTIPLE-ID      TO WS-PREV-MULTIPLE-ID      
              MOVE EXT-SRT-G5-SUB-SEQ       TO WS-PREV-G5-SUB-SEQ       
              MOVE 'N'                      TO WS-FIRST-TIME-SW         
           END-IF.                                                      
                                                                        
           IF EXT-SRT-G5-SUB-SEQ = WS-PREV-G5-SUB-SEQ AND               
              EXT-SRT-MULTIPLE-ID = WS-PREV-MULTIPLE-ID                 
              COMPUTE WS-SHEETS-IN-THIS-ACCT = 0.5 +                    
                                             (EXT-SRT-PAGE-TOTAL / 2)   
              ADD WS-SHEETS-IN-THIS-ACCT    TO WS-HOLD-MULTI-SHEETS     
           ELSE                                                         
              PERFORM 8000-WRITE-SORT-IDX   THRU 8000-EXIT              
              COMPUTE WS-SHEETS-IN-THIS-ACCT = 0.5 +                    
                                             (EXT-SRT-PAGE-TOTAL / 2)   
              MOVE WS-SHEETS-IN-THIS-ACCT   TO WS-HOLD-MULTI-SHEETS     
              INITIALIZE WS-HOLD-SRT-IDX-TBL                            
              MOVE ZERO                     TO WS-SUB1                  
           END-IF.                                                      
           ADD +1                           TO WS-SUB1.                 
           MOVE EXT-SORTIDX-FILE            TO                          
                                         WS-HOLD-SRT-IDX-DATA(WS-SUB1). 
           MOVE EXT-SRT-MULTIPLE-ID         TO WS-PREV-MULTIPLE-ID.     
           MOVE EXT-SRT-G5-SUB-SEQ          TO WS-PREV-G5-SUB-SEQ.      
           PERFORM 7000-READ-FCSCA911       THRU 7000-EXIT.             
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  READ THE CA911 INPUT FILE                               *              
      ************************************************************              
                                                                        
       7000-READ-FCSCA911.                                              
                                                                        
           READ FCSCA911-FILE AT END                                    
               MOVE WS-Y TO WS-END-OF-CA911.                            
           IF CA911-SUCCESSFUL OR END-OF-CA911                          
               IF EXT-SRT-GROUP-ID = 'G5'                               
                  ADD 1                        TO WS-SEQUENCE-NO        
                  MOVE WS-SEQUENCE-NO          TO EXT-SRT-SEQUENCE-NO   
               END-IF                                                   
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA181 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR READING FCSCA911       **'       
               DISPLAY '**     FILE STATUS = ' WS-CA911-STATUS          
               DISPLAY '****************************************'       
               PERFORM 9000-TERMINATE       THRU 9000-EXIT              
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      17189000
      *  8000-WRITE-SORT-IDX.                                    *      17190000
      ************************************************************      17191000
                                                                        
       8000-WRITE-SORT-IDX.                                             
                                                                        
           PERFORM VARYING WS-SUB1 FROM 1 BY 1 UNTIL                    
              WS-SUB1 > 10 OR WS-HOLD-SRT-IDX-DATA(WS-SUB1) = SPACES    
               MOVE WS-HOLD-MULTI-SHEETS    TO WS-SHEETS-IN-ENV(WS-SUB1)
               MOVE SPACES                  TO E-SRT-IDX-REC            
               MOVE WS-HOLD-SRT-IDX-DATA(WS-SUB1)                       
                                            TO E-SRT-IDX-REC            
               WRITE E-SRT-IDX-REC                                      
               IF NOT CA912-SUCCESSFUL                                  
                  DISPLAY '8000-ERROR ON FCSCA912 WRITE.  STATUS IS '   
                           WS-CA912-STATUS                              
                  PERFORM 9000-TERMINATE    THRU 9000-EXIT              
               END-IF                                                   
           END-PERFORM.                                                 
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      17189000
      *  9000-TERMINATE.                                         *      17190000
      ************************************************************      17191000
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSCA911-FILE                                          
                 FCSCA912-FILE.                                         
           STOP RUN.                                                    
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *     9900-ABEND                                                 *        
      ******************************************************************        
       9900-ABEND.                                                      
           DISPLAY 'PERFORMING 9900-ABEND'.                             
           MOVE 12                          TO  RETURN-CODE.            
           PERFORM 9000-TERMINATE           THRU 9000-EXIT.             
       9900-EXIT.                                                       
                                                                        
