       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   PCSCA179.                                          
       AUTHOR.       CSC.                                               
       DATE-WRITTEN. JAN 2011.                                          
       DATE-COMPILED.                                                   
      ******************************************************************00060000
      **               SOUTH CAROLINA ELECTRIC & GAS                  **00070000
      **                      COBOL-DB2                               **00080000
      ******************************************************************00090000
      **                     PROGRAM SUMMARY                          **00100000
      ******************************************************************00110000
      **                                                              **00120000
      ** PROGRAM TO CREATE THE REVENUE INTERFACE FILES (FCSCREVD,     **00130000
      ** FCSCREVC) FILES FOR DETECTANT ACCOUNTS.                      **00140000
      **                                                              **00150000
      ******************************************************************00160000
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **00170000
      ******************************************************************00180000
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **00190000
      **        1000 - 1999     INPUT PROCESSING CONTROL PATH         **00200000
      **        2000 - 2999     OUTPUT PROCESS CONTROL PATH           **00210000
      **        3000 - 4999     NOT USED                              **00220000
      **        5000 - 5999     COMMON PROGRAM MODULES                **00230000
      **        6000 - 6999     COMMON SYSTEM MODULES                 **00240000
      **        7000 - 7999     INPUT MODULES                         **00250000
      **        8000 - 8999     OUTPUT MODULES                        **00260000
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **00270000
      ******************************************************************00280000
      **              PROGRAM  MODIFICATION  LOG                      **00290000
      ******************************************************************00300000
      ** DATE     USERID   REASON                                     **00310000
      ** -------  -------  ------                                     **00320000
A02932** 01/2010  SB93596  INITIAL IMPLEMENTATION.                    **00330001
      ******************************************************************00520000
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSREVC.                                                    00580000
       COPY CSSREVD.                                                    00590000
      *                                                                 00620000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                 00660000
       COPY CFDCREVC.                                                   00740000
       COPY FCSCREVC.                                                   00750000
                                                                        
       COPY CFDCREVD.                                                   00770000
       COPY FCSCREVD.                                                   00780000
      *                                                                 00790000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA179'.
MSQ017     COPY MFASQLM.
      *                                                                 00870000
       01 WS-START                       PIC X(40) VALUE                
                        'WORKING STORAGE FOR PCSCA179 STARTS HERE'.     
       01 WS-MISC.                                                      
          05 WS-CURRENT-DATE             PIC X(10) VALUE SPACES.        
          05 WS-CURRENT-TIMESTAMP        PIC X(26) VALUE SPACES.        
          05 WS-PREV-TIMESTAMP           PIC X(26) VALUE SPACES.        
          05 WS-RUNNING-COUNTER          PIC S9(04) COMP VALUE +0.      
          05 RS-RETURN-CODE              PIC S9(04) COMP VALUE 0.       
          05 WS-DISPLAY-SCSCA            PIC X(08) VALUE SPACES.        
          05 WS-CURR-REV-MONTH           PIC 9(06).                     
          05  FILLER REDEFINES WS-CURR-REV-MONTH.                       
              10  WS-CURR-REV-MONTH-CCYY PIC 9(04).                     
              10  WS-CURR-REV-MONTH-MM   PIC 9(02).                     
                                                                        
          05 WS-RUN-DATE                 PIC X(10).                     
                                                                        
       01 WS-HOLD-VARIABLES.                                            
          05 WS-PREVIOUS-ACCT-NO         PIC 9(13) VALUE 0.             
                                                                        
       01 WS-SWITCHES.                                                  
                                                                        
          05 WS-ROW-FOUND-SW               PIC X(01).                   
             88 ROW-FOUND                            VALUE 'Y'.         
             88 ROW-NOT-FOUND                        VALUE 'N'.         
                                                                        
          05 WS-BEGIN-REC-SW               PIC X(01).                   
             88 WS-BEGIN-RECS-PROCESSED              VALUE 'Y'.         
             88 WS-BEGIN-REC-NOT-PROCESSED           VALUE 'N'.         
             88 WS-START-INPUT-DATA                  VALUE 'X'.         
                                                                        
          05 WS-RECORD-FOUND               PIC X(01) VALUE 'N'.         
             88 DATA-RECORD-FOUND                    VALUE 'Y'.         
             88 NO-DATA-RECORD-FOUND                 VALUE 'N'.         
                                                                        
          05 WS-FCSCREVC-STATUS            PIC X(02).                   
             88 FCSCREVC-SUCCESSFUL                  VALUE '00'.        
             88 END-OF-FCSCREVC                      VALUE '10'.        
                                                                        
          05 WS-FCSCREVD-STATUS            PIC X(02).                   
             88 FCSCREVD-SUCCESSFUL                  VALUE '00'.        
             88 END-OF-FCSCREVD                      VALUE '10'.        
                                                                        
                                                                        
          05 WS-SKIP-ACCT-SW               PIC X(01) VALUE SPACE.       
             88 SKIP-ACCT                            VALUE 'Y'.         
                                                                        
          05 WS-PROCESS-FLAG               PIC X(01) VALUE 'N'.         
             88 PROCESS179-ENABLED                   VALUE 'Y'.         
             88 CMNDT-ON-REVCLOSE                    VALUE 'Y'.         
                                                                        
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME                  PIC X(08) VALUE 'PCSCA179'.  
          05 WS-PGRMNAME                   PIC X(08) VALUE 'PCSCA179'.  
          05 WS-Y                          PIC X(1)  VALUE 'Y'.         
          05 WS-N                          PIC X(01) VALUE 'N'.         
          05 WS-COMMON-DATE                PIC X(10) VALUE 'COMMONDATE'.
      *                                                                 05030000
      ******************************************************************05190000
      *  FIOCA00 COPYBOOK TO GET JOB_PARM DATA.                        *05200000
      ******************************************************************05210000
       COPY FIOCA00.                                                    05220000
      *                                                                 05230000
      ******************************************************************05240000
      *  CWS00010  CONTAINS DB2 ABEND VARIABLES                        *05250000
      ******************************************************************05260000
       COPY CWS00010.                                                   05270000
      *                                                                 05430000
      ******************************************************************05440000
      *   CWS10005 CONTAINS INDEX/TABLE ERROR MESSAGES BE02            *05450000
      ******************************************************************05460000
       COPY CWS10005.                                                   05470000
      *                                                                 05480000
      ******************************************************************05490000
      *   CWS10006 CONTAINS INDEX/TABLE ERROR MESSAGES BE13            *05500000
      ******************************************************************05510000
       COPY CWS10006.                                                   05520000
      *                                                                 05530000
      ******************************************************************05540000
      *CWS0024B                                                        *05550000
      ******************************************************************05560000
       COPY CWS0024B.                                                   05570000
      *                                                                 05580000
      ******************************************************************05590000
      *  CWS00038 JOB PARM ROUTINE                                     *05600000
      ******************************************************************05610000
       COPY CWS00038.                                                   05620000
      *                                                                 05630000
      ******************************************************************05640000
      *  CWS00039 JOB PARM ROUTINE                                     *05650000
      ******************************************************************05660000
       COPY CWS00039.                                                   05670000
      *                                                                 05680000
      ******************************************************************05690000
      * WORKING STORAGE FOR CPD09900 CONTAINS ABEND WS VARIABLES       *05700000
      ******************************************************************05710000
       COPY CWS09900.                                                   05720000
      *                                                                 05730000
      ******************************************************************05790000
      * ERROR MESSAGE COPYBOOK.                                        *05800000
      ******************************************************************05810000
       COPY CWS00303.                                                   05820000
      *                                                                 05830000
       COPY FIOJC01.                                                    05840000
      *                                                                 05850000
       01  WS-END                          PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSCA179 ENDS HERE  '.            
      *                                                                 05880000
      ******************************************************************05890000
      * DB2 INCLUDES.                                                  *05900000
      ******************************************************************05910000
      *    SQLCA                                                       *05920000
      ******************************************************************05930000
      *                                                                 05940000
           EXEC SQL                                                     05950000
              INCLUDE SQLCA                                             05960000
           END-EXEC.                                                    05970000
      *                                                                 05980000
      ******************************************************************06000000
      *  CSS_ACCOUNT       - AT                                        *06010000
      ******************************************************************06020000
      *                                                                 06030000
           EXEC SQL                                                     06040000
             INCLUDE TBACCT                                             06050000
           END-EXEC.                                                    06060000
      *                                                                 06070000
      ******************************************************************        
      *  CSS_BILL_WINDOW   - BN                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBBILWDW                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06610000
      *  CSS_DELINQUENCY   - C8                                        *06620000
      ******************************************************************06630000
      *                                                                 06640000
           EXEC SQL                                                     06650000
             INCLUDE TBDELQ                                             06660000
           END-EXEC.                                                    06670000
      *                                                                 06680000
      ******************************************************************06690000
      *  CSS_JOB_PARM      - G6                                        *06700000
      ******************************************************************06710000
      *                                                                 06720000
           EXEC SQL                                                     06730000
             INCLUDE TBJBPARM                                           06740000
           END-EXEC.                                                    06750000
      *                                                                 06760000
      ******************************************************************06690000
      *  CSS_PREMISE       - PR                                        *06700000
      ******************************************************************06710000
      *                                                                 06720000
           EXEC SQL                                                     06730000
             INCLUDE TBPREM                                             06740000
           END-EXEC.                                                    06750000
      *                                                                         
      ******************************************************************06770000
      *  CSS_MNICPLTY_CNTY  - F4                                       *06780000
      ******************************************************************06790000
      *                                                                         
           EXEC SQL                                                     06800000
              INCLUDE TBMNCCTY                                          06810000
           END-EXEC.                                                    06820000
      *                                                                         
      ******************************************************************        
      *  CSS_RATE_PLAN_DESC - RD                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBRTDESC                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06921000
      *  CSS_REV_PROTEC_DET - RL                                       *06922000
      ******************************************************************06923000
      *                                                                 06924000
           EXEC SQL                                                     06925000
              INCLUDE TBREVDET                                          06926000
           END-EXEC.                                                    06927000
      *                                                                 06928000
      ******************************************************************06929000
      *  CSS_REV_PROTEC_HDR - R0                                       *06929100
      ******************************************************************06929200
      *                                                                 06929300
           EXEC SQL                                                     06929400
              INCLUDE TBREVPRT                                          06929500
           END-EXEC.                                                    06929600
      *                                                                 06929700
      ******************************************************************07320000
      *  CSS_RATE_CREATOR   - RT                                       *07330000
      ******************************************************************07340000
      *                                                                 07350000
           EXEC SQL                                                     07360000
             INCLUDE TBRTCRTR                                           07370000
           END-EXEC.                                                    07380000
      *                                                                 07390000
      * DB2 CURSORS.                                                    08090000
      *------------*                                                    08100000
      *                                                                 08110000
      ******************************************************************08110100
      *   CURSOR TO SELECT THE DETECTANT ACCOUNTS.                     *08110200
      ******************************************************************08110300
           EXEC SQL                                                     
               DECLARE REV_DETAIL_ADJ CURSOR FOR                        
                SELECT R0.ACCOUNT_NO                                    
                      ,R0.REV_PROT_CASE_NO                              
                      ,R0.CASE_STATUS_CD                                
                      ,R0.CREATE_DT                                     
                      ,R0.COMPANY_NO                                    
                      ,RL.CASE_TYPE_CD                                  
                      ,RL.RATE_PLAN_NO                                  
                      ,RL.CODE_REVENUE_CLASS                            
                      ,RL.COLLECTIBLE_UNITS                             
                      ,RL.COLLECTIBLE_AM                                
                      ,RL.CONSUMPT_TYPE_CD                              
                      ,RL.AMT_DOWN_PYMT                                 
                      ,RL.GL_ACCT_NO                                    
                      ,RL.CASE_AM                                       
                      ,AT.BILL_CYCLE                                    
                      ,AT.CUSTOMER_NO                                   
                      ,AT.LOCAL_OFFICE                                  
                      ,AT.PREMISE_NO                                    
                  FROM CSS_REV_PROTEC_HDR R0 WITH(READUNCOMMITTED)              
                      ,CSS_REV_PROTEC_DET RL WITH(READUNCOMMITTED)              
                      ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
                 WHERE R0.REVENUE_MONTH    = :R0-REVENUE-MONTH          
                   AND RL.ACCOUNT_NO       = R0.ACCOUNT_NO              
                   AND AT.ACCOUNT_NO       = R0.ACCOUNT_NO              
                   AND RL.REV_PROT_CASE_NO = R0.REV_PROT_CASE_NO        
                   AND R0.CASE_STATUS_CD  IN ('A','C')                  
                   AND RL.CASE_TYPE_CD    IN ('E','G')                  
                   AND (RL.DFA_ITEM_ID     > 0 OR                       
                       RL.DFA_ITEM_ID_DP  > 0)                          
                 ORDER BY R0.ACCOUNT_NO                                 
                      ,R0.REV_PROT_CASE_NO                              
                      ,RL.CASE_TYPE_CD                                  
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08111000
MFA-TR*        DECLARE REV_DETAIL_ADJ CURSOR FOR                        08112000
MFA-TR*         SELECT R0.ACCOUNT_NO                                    08114000
MFA-TR*               ,R0.REV_PROT_CASE_NO                              08115000
MFA-TR*               ,R0.CASE_STATUS_CD                                08116000
MFA-TR*               ,R0.CREATE_DT                                     08117000
MFA-TR*               ,R0.COMPANY_NO                                    08118000
MFA-TR*               ,RL.CASE_TYPE_CD                                  08119000
MFA-TR*               ,RL.RATE_PLAN_NO                                  08119100
MFA-TR*               ,RL.CODE_REVENUE_CLASS                            08119200
MFA-TR*               ,RL.COLLECTIBLE_UNITS                             08119300
MFA-TR*               ,RL.COLLECTIBLE_AM                                08119400
MFA-TR*               ,RL.CONSUMPT_TYPE_CD                              08119500
MFA-TR*               ,RL.AMT_DOWN_PYMT                                 08119600
MFA-TR*               ,RL.GL_ACCT_NO                                    08119700
MFA-TR*               ,RL.CASE_AM                                       08119800
MFA-TR*               ,AT.BILL_CYCLE                                    08119900
MFA-TR*               ,AT.CUSTOMER_NO                                   08120000
MFA-TR*               ,AT.LOCAL_OFFICE                                  08120100
MFA-TR*               ,AT.PREMISE_NO                                    08120200
MFA-TR*           FROM CSS_REV_PROTEC_HDR R0                            08120300
MFA-TR*               ,CSS_REV_PROTEC_DET RL                            08120400
MFA-TR*               ,CSS_ACCOUNT AT                                   08120500
MFA-TR*          WHERE R0.REVENUE_MONTH    = :R0-REVENUE-MONTH          08120600
MFA-TR*            AND RL.ACCOUNT_NO       = R0.ACCOUNT_NO              08120700
MFA-TR*            AND AT.ACCOUNT_NO       = R0.ACCOUNT_NO              08120800
MFA-TR*            AND RL.REV_PROT_CASE_NO = R0.REV_PROT_CASE_NO        08120900
MFA-TR*            AND R0.CASE_STATUS_CD  IN ('A','C')                  08121000
MFA-TR*            AND RL.CASE_TYPE_CD    IN ('E','G')                  08121100
MFA-TR*            AND (RL.DFA_ITEM_ID     > 0 OR                       08121200
MFA-TR*                RL.DFA_ITEM_ID_DP  > 0)                          08121300
MFA-TR*          ORDER BY R0.ACCOUNT_NO                                 08121400
MFA-TR*               ,R0.REV_PROT_CASE_NO                              08121500
MFA-TR*               ,RL.CASE_TYPE_CD                                  08121600
MFA-TR*            FOR FETCH ONLY WITH UR                               08121700
MFA-TR*        QUERYNO 7415                                             08121800
MFA-TR*    END-EXEC.                                                            
      *                                                                 08540000
                                                                        
       01  WS-END                          PIC X(40)      VALUE         
                       'WORKING STORAGE FOR PCSCA179 ENDS HERE  '.      
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       01  PARMIN.                                                      
           05  PARMLENGTH                  PIC S9(04) COMP.             
           05  PARM-COMMON-DATE            PIC X(10).                   
                                                                        
       PROCEDURE DIVISION USING PARMIN.                                 
      *                                                                 10130000
      ******************************************************************10140000
      * 0000-MAINLINE                                                  *10150000
      * CONTROLS THE MAIN PATH OF THE PROGRAM                          *10160000
      ******************************************************************10170000
      *                                                                         
       0000-MAINLINE.                                                   
                                                                        
           PERFORM  0100-INITIALIZATION          THRU  0100-EXIT.       
           PERFORM  1000-PROCESS-DETECTANT       THRU  1000-EXIT.       
           PERFORM  9000-TERMINATE               THRU  9000-EXIT.       
           DISPLAY '** PCSCA179 PROCESSING COMPLETED SUCCESSFULLY **'.  
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10280000
      ******************************************************************10290000
      * 0100-INITIALIZATION                                            *10300000
      * OPEN OUTPUT FILES.                                             *10310000
      ******************************************************************10320000
       0100-INITIALIZATION.                                             
                                                                        
           IF PARMLENGTH > 0                                            
              MOVE PARM-COMMON-DATE             TO WS-INPUT-DATE        
               DISPLAY '** PCSCA179 PROCESSING MESSAGE  **'             
               DISPLAY '** JCL OVERRIDE DATE BEING USED **'             
               DISPLAY '** DATE = ' WS-INPUT-DATE                       
               DISPLAY '**  PROCESSING CONTINUING       **'             
           ELSE                                                         
              PERFORM 0110-GET-JOB-PARM-DETAILS THRU 0110-EXIT          
           END-IF.                                                      
                                                                        
      * OPEN THE O/P FILES                                              10890000
                                                                        
           PERFORM 0120-OPEN-FILES              THRU 0120-EXIT.         
      *                                                                 11398700
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************11395900
      * 0110-GET-JOB-PARM-DETAILS.                                     *11396000
      ******************************************************************11396200
      *                                                                         
       0110-GET-JOB-PARM-DETAILS.                                       
      *                                                                 11396400
           MOVE SPACES                      TO WS-SYSIPT.               
           MOVE 'PCSCA204'                  TO WS-PROGRAM.              
           MOVE WS-PARM                     TO WS-COMMAND.              
           MOVE WS-KEY-AREA                 TO E-FJC01-KEY.             
                                                                        
           PERFORM 7600-START-FCSJC01            THRU  7600-EXIT.       
                                                                        
           PERFORM 7610-READ-FCSJC01             THRU  7610-EXIT        
               UNTIL (REVENUE-MONTH AND INPUT-ACTIVE)                   
                  OR  END-OF-SYSIPT.                                    
                                                                        
           EVALUATE TRUE                                                
              WHEN END-OF-SYSIPT                                        
                 DISPLAY ' '                                            
                 DISPLAY '**  PCSCA179 PROCESSING ERROR  **'            
                 DISPLAY '**    NO ACTIVE REVENUE MONTH FOUND'          
                 DISPLAY '**  PROCESSING TERMINATED **'                 
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              WHEN OTHER                                                
                 PERFORM 7611-CLOSE              THRU 7611-EXIT         
           END-EVALUATE.                                                
           MOVE  WS-REVENUE-MONTH-PARM      TO   R0-REVENUE-MONTH       
                                                 BN-REVENUE-MONTH.      
                                                                        
           PERFORM 7010-SELECT-REVCLOSE-DATE     THRU 7010-EXIT         
      *                                                                 11398700
           MOVE 'COMMON'                    TO WS-PGRMNAME.             
           PERFORM 6251-GET-FJC01-DATE           THRU 6251-EXIT.        
           MOVE WS-INPUT-DATE               TO WS-RUN-DATE.             
      *                                                                         
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11420000
      ******************************************************************11391800
      * 0120-OPEN-FILES                                                *11391900
      * OPEN OUTPUT FILES                                              *11392000
      ******************************************************************11392100
       0120-OPEN-FILES.                                                 
      *                                                                 11392300
           OPEN OUTPUT FCSCREVC-FILE.                                   
           IF NOT FCSCREVC-SUCCESSFUL                                   
               DISPLAY '********** PCSCA179 ABORT  ************'        
               DISPLAY '**  0120-OPEN-FILES                   *'        
               DISPLAY '**  ERROR OPENING FCSCREVC-FILE       *'        
               DISPLAY '**  FILE STATUS = ' WS-FCSCREVC-STATUS          
               DISPLAY '********** PCSCA179 ABORT  ************'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF                                                       
                                                                        
           OPEN OUTPUT FCSCREVD-FILE.                                   
           IF NOT FCSCREVD-SUCCESSFUL                                   
               DISPLAY '********** PCSCA179 ABORT  ************'        
               DISPLAY '**  0120-OPEN-FILES                   *'        
               DISPLAY '**  ERROR OPENING FCSCREVD-FILE       *'        
               DISPLAY '**  FILE STATUS = ' WS-FCSCREVD-STATUS          
               DISPLAY '********** PCSCA179 ABORT  ************'        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 11395500
       0120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11395800
      ******************************************************************16270000
      * 1000-PROCESS-DETECTANT.                                     *   16280001
      * PROCESS THE RECORDS FROM CURSOR REV_DETAIL_ADJ                 *16290001
      ******************************************************************16300000
      *                                                                         
       1000-PROCESS-DETECTANT.                                          
                                                                        
           PERFORM 2000-PROCESS-DETECTANT-ACCT   THRU 2000-EXIT.        
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16380000
      ***************************************************************** 43861000
      *2000-PROCESS-DETECTANT-ACCT.                                   * 43862000
      *PROCESS FOR WRITING FCSCREVD,FCSCREVC FILES.                   * 43863000
      ***************************************************************** 43864000
      *                                                                         
       2000-PROCESS-DETECTANT-ACCT.                                     
                                                                        
           PERFORM 7415-OPEN-REV-PROT-DETAIL-ADJ THRU 7415-EXIT         
           PERFORM 7425-FETCH-REV-PROT-DETAIL-ADJ THRU 7425-EXIT        
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 2600-LOAD-REV-BILL-DET     THRU 2600-EXIT         
              PERFORM 2650-LOAD-REV-BILL-COMP-ADJ                       
                                                 THRU 2650-EXIT         
              PERFORM 7425-FETCH-REV-PROT-DETAIL-ADJ                    
                                                 THRU 7425-EXIT         
           END-PERFORM.                                                 
                                                                        
           PERFORM 7435-CLOSE-REV-PROT-DETAIL-ADJ                       
                                                 THRU 7435-EXIT.        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 50090000
      ******************************************************************21470000
      *2600-LOAD-REV-BILL-DET.                                         *21480000
      *PERFORMS THE REVENUE BILL DETAIL PROCESS                        *21490000
      ******************************************************************21500000
       2600-LOAD-REV-BILL-DET.                                          
                                                                        
           INITIALIZE FCSCREVD                                          
                                                                        
           INITIALIZE WS-RUNNING-COUNTER                                
                                                                        
           PERFORM 7050-GET-CURR-TIMESTAMP       THRU 7050-EXIT         
                   UNTIL WS-PREV-TIMESTAMP NOT = WS-CURRENT-TIMESTAMP.  
                                                                        
           MOVE WS-CURRENT-TIMESTAMP        TO E-REVDET-BILL-UNIQUE-TS  
                                               WS-PREV-TIMESTAMP        
                                             E-REVDET-BILL-ITEM-TIMESTMP
           MOVE R0-COMPANY-NO               TO E-REVDET-COMPANY-NO      
                                               E-REVDET-REV-COMPANY-NO  
           MOVE BN-REVENUE-MONTH            TO E-REVDET-REVENUE-MONTH   
           MOVE RL-CASE-TYPE-CD             TO                          
                                              E-REVDET-CODE-SERVICE-TYPE
                                               E-REVDET-CODE-UTIL-TYPE  
           MOVE R0-ACCOUNT-NO               TO E-REVDET-ACCOUNT-NO      
                                                                        
           DISPLAY '* DETECTANT ACCOUNT =', E-REVDET-ACCOUNT-NO         
           MOVE R0-CREATE-DT                TO E-REVDET-DATE-BILLED     
           MOVE AT-BILL-CYCLE               TO E-REVDET-ACCT-BILL-CYCLE 
           MOVE RL-CODE-REVENUE-CLASS(2:1)  TO                          
                                            E-REVDET-CODE-REV-ACCT-TYPE 
           MOVE RL-CODE-REVENUE-CLASS       TO                          
                                             E-REVDET-CODE-REVENUE-CLASS
                                             RD-CODE-UTIL-TYPE          
           MOVE RL-RATE-PLAN-NO             TO E-REVDET-RATE-PLAN-NO    
                                               RD-RATE-PLAN-NO          
           PERFORM 7020-GET-RATE-DEPT-CD          THRU 7020-EXIT        
                                                                        
           IF WS-ACTIVE-RETURN-CODE =  NOT-FOUND                        
             MOVE SPACES                    TO E-REVDET-RATE-DEPT-CD    
           ELSE                                                         
             MOVE RD-RATE-DEPT-CD           TO E-REVDET-RATE-DEPT-CD    
           END-IF.                                                      
                                                                        
           MOVE AT-LOCAL-OFFICE             TO E-REVDET-LOCAL-OFFICE    
                                               PR-PREMISE-NO            
           PERFORM 7030-GET-REV-DISTRICT-CD      THRU 7030-EXIT         
                                                                        
           IF WS-ACTIVE-RETURN-CODE =  NOT-FOUND                        
             MOVE SPACES                    TO E-REVDET-REV-DISTRICT-CD 
                                               F4-REV-DISTRICT-CD       
           ELSE                                                         
             MOVE PR-REV-DISTRICT-CD        TO E-REVDET-REV-DISTRICT-CD 
                                               F4-REV-DISTRICT-CD       
           END-IF.                                                      
                                                                        
           PERFORM 7040-GET-MNICIPLTY-COUNTY-CD  THRU 7040-EXIT         
                                                                        
           IF WS-ACTIVE-RETURN-CODE =  NOT-FOUND                        
             MOVE SPACES                 TO E-REVDET-MNICPLTY-COUNTY-CD 
           ELSE                                                         
           MOVE F4-MNICPLTY-COUNTY-CD       TO                          
                                            E-REVDET-MNICPLTY-COUNTY-CD 
           END-IF.                                                      
                                                                        
           MOVE AT-PREMISE-NO               TO E-REVDET-PREMISE-NO      
           MOVE 'U'                         TO E-REVDET-CALC-SOURCE-CD  
                                                                        
           MOVE SPACES                      TO E-REVDET-DATE-ORIG-BILL  
                                               E-REVDET-BILL-CALC-CYCLE 
                                               E-REVDET-PRTY-SVC-CAT-CD 
                                               E-REVDET-CODE-SIC-NO     
                                               E-REVDET-NAICS-CD        
                                               E-REVDET-OPTION-CD       
                                              E-REVDET-TIER-ACCT-TYPE-CD
                                              E-REVDET-RATE-CALC-TYPE-CD
                                              E-REVDET-PRORATED-DAYS-CD 
                                                                        
           MOVE ZEROS                       TO E-REVDET-NO-OF-CONS-DAYS 
                                               E-REVDET-BTU-FACTOR      
                                               E-REVDET-GAS-BASE-USE    
                                               E-REVDET-BILL-NO         
                                               E-REVDET-IC-NO           
                                               E-REVDET-CUST-CT         
                                            E-REVDET-CUST-CT-EXCL-LIGHTS
                                            E-REVDET-REV-MTH-ORIG-BILL  
                                                                        
           PERFORM 8000-WRITE-FCSCREVD           THRU 8000-EXIT.        
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22680000
      ***************************************************************** 38940000
      *2650-LOAD-REV-BILL-COMP-ADJ.                                   * 38950000
      *POPULATED DATA ELEMENTS FOR REV_BILL_COMP_ADJ TABLE            * 38960000
      ***************************************************************** 38970000
      *                                                                         
       2650-LOAD-REV-BILL-COMP-ADJ.                                     
                                                                        
           INITIALIZE FCSCREVC                                          
           ADD 1                            TO WS-RUNNING-COUNTER       
           MOVE WS-RUNNING-COUNTER          TO E-REVADJ-BILL-COMP-SEQ-NO
                                                                        
           MOVE WS-CURRENT-TIMESTAMP        TO E-REVADJ-BILL-UNIQUE-TS  
           MOVE 'BC'                        TO E-REVADJ-CMPNT-ID-CD     
                                                                        
      *POPULATE CONSUMPTION TYPE                                        39110000
                                                                        
      * DEMAND COMPONENT                                                39140000
           IF RL-CONSUMPT-TYPE-CD  = 'E' OR 'J' OR 'Q'                  
             MOVE 'D'                       TO                          
                                            E-REVADJ-INSTR-USE-TYPE-CD  
           END-IF.                                                      
      * ENERGY COMPONENT                                                39180000
           IF RL-CONSUMPT-TYPE-CD  = 'B' OR 'C' OR 'D'                  
             MOVE 'R'                       TO                          
                                            E-REVADJ-INSTR-USE-TYPE-CD  
           END-IF.                                                      
                                                                        
           IF RL-CONSUMPT-TYPE-CD  NOT =  'E' OR 'J'                    
             MOVE RL-COLLECTIBLE-UNITS                                  
                                            TO E-REVADJ-BILL-USAGE-UNITS
           ELSE                                                         
             MOVE ZEROS                     TO E-REVADJ-BILL-USAGE-UNITS
           END-IF.                                                      
                                                                        
           IF RL-CASE-TYPE-CD  = 'G'                                    
              COMPUTE E-REVADJ-READ-UNITS ROUNDED                       
                                    = (RL-COLLECTIBLE-UNITS / 1.032)    
           ELSE                                                         
           MOVE RL-COLLECTIBLE-UNITS                                    
                                            TO E-REVADJ-READ-UNITS      
           END-IF.                                                      
                                                                        
           IF RL-CONSUMPT-TYPE-CD  = 'E' OR 'J'                         
             MOVE RL-COLLECTIBLE-UNITS                                  
                                            TO                          
                                              E-REVADJ-BILL-DEMAND-UNITS
           ELSE                                                         
             MOVE ZEROS                     TO                          
                                              E-REVADJ-BILL-DEMAND-UNITS
           END-IF.                                                      
                                                                        
           MOVE E-REVADJ-BILL-USAGE-UNITS                               
                                            TO E-REVADJ-CALC-UNITS      
           COMPUTE E-REVADJ-BILLED-AMT ROUNDED =                        
                                 (RL-COLLECTIBLE-AM + RL-AMT-DOWN-PYMT) 
           MOVE 'U'                         TO E-REVADJ-UTILITY-REV-CD  
           MOVE 'N'                         TO E-REVADJ-COMP-ADJ-CD     
           MOVE RL-GL-ACCT-NO               TO E-REVADJ-GL-ACCT-NO      
           MOVE RL-CONSUMPT-TYPE-CD                                     
                                            TO E-REVADJ-CONSUMPT-TYPE-CD
           MOVE RL-CASE-TYPE-CD             TO RT-CODE-UTIL-TYPE        
                                                                        
           MOVE RL-RATE-PLAN-NO             TO RT-RATE-PLAN-NO          
           PERFORM 7520-SELECT-RT-VERS-FROM-DT   THRU  7520-EXIT        
           MOVE RT-FROM-EFFECTIVE-DT        TO E-REVADJ-RT-VERS-FROM-DT 
                                                                        
           MOVE 'NETREVFCT'                 TO E-REVADJ-FACTOR-ID       
           MOVE E-REVADJ-RT-VERS-FROM-DT                                
                                            TO E-REVADJ-RT-FCT-FROM-DT  
           MOVE R0-ACCOUNT-NO               TO E-REVADJ-ACCOUNT-NO      
                                                                        
           MOVE ZEROS                       TO E-REVADJ-CODE-TIME-PERIOD
                                               E-REVADJ-FACTOR-BLOCK-NO 
                                               E-REVADJ-RT-VERS-PRO-CD  
                                               E-REVADJ-RT-FCT-PRO-CD   
                                               E-REVADJ-FACTOR          
                                                                        
           MOVE SPACES                      TO                          
                                              E-REVADJ-CODE-SEASON      
                                              E-REVADJ-CODE-STAT-TAX-XMT
                                              E-REVADJ-CODE-CITY-TAX-XMT
                                              E-REVADJ-CODE-OTHR-TAX-XMT
                                              E-REVADJ-SPCL-GROUP-CD.   
                                                                        
      * WRITE FCSCREVC - ADJUSTMENT FILE                                39296001
           PERFORM 8010-WRITE-FCSCREVC           THRU 8010-EXIT.        
      *                                                                         
       2650-EXIT.                                                       
           EXIT.                                                        
      *                                                                 39580000
      ******************************************************************50100000
      * 6251-GET-FJC01-DATE                                            *50110000
      ******************************************************************50120000
           EXEC SQL                                                     50130000
                INCLUDE CPD00037                                        50140000
           END-EXEC.                                                    50150000
      *                                                                 50160000
      ******************************************************************50170000
      * 6240-GET-FCA00-COMMON-DATE                                     *50180000
      ******************************************************************50190000
           EXEC SQL                                                     50200000
                INCLUDE CPD00040                                        50210000
           END-EXEC.                                                    50220000
      *                                                                 50230000
      ******************************************************************50310000
      * 7010-SELECT-REVCLOSE-DATE.                                     *50320000
      * SELECTS THE MAX DATE_EXTRACT ABSED ON THE REVENUE MONTH PARM   *50330000
      * FOR PCSCA204 IN CSS_JOB_PARM TABLE.                            *50330000
      ******************************************************************50340000
       7010-SELECT-REVCLOSE-DATE.                                       
      *                                                                 50360000
           EXEC SQL                                                     
              SELECT TOP(1) DATE_EXTRACT                                       
                INTO :BN-DATE-EXTRACT                                   
                FROM CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                   
               WHERE REVENUE_MONTH = :BN-REVENUE-MONTH                  
               ORDER BY DATE_EXTRACT                                    
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     50370000
MFA-TR*       SELECT DATE_EXTRACT                                       50380000
MFA-TR*         INTO :BN-DATE-EXTRACT                                   50390000
MFA-TR*         FROM CSS_BILL_WINDOW BN                                 50400000
MFA-TR*        WHERE REVENUE_MONTH = :BN-REVENUE-MONTH                  50410000
MFA-TR*        ORDER BY DATE_EXTRACT                                            
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7010                                               50430000
MFA-TR*    END-EXEC.                                                    50440000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 50450000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA179 ABORT **************'        
              DISPLAY '* 7010-SELECT-REVCLOSE-DATE            *'        
              DISPLAY '* REVENUE_MONTH =', BN-REVENUE-MONTH             
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA179 ABORT **************'        
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 50590000
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 50620000
      ******************************************************************50310000
      * 7020-GET-RATE-DEPT-CD.                                         *50320000
      * SELECTS THE RATE-DEPT-CD  FROM CSS_RATE_PLAN TABLE.            *50330000
      ******************************************************************50340000
      *                                                                         
       7020-GET-RATE-DEPT-CD.                                           
      *                                                                 50360000
           EXEC SQL                                                     
              SELECT RATE_DEPT_CD                                       
                INTO :RD-RATE-DEPT-CD                                   
                FROM CSS_RATE_PLAN_DESC RD                              
               WHERE CODE_UTIL_TYPE = :RD-CODE-UTIL-TYPE                
                 AND RATE_PLAN_NO   = :RD-RATE-PLAN-NO                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     50370000
MFA-TR*       SELECT RATE_DEPT_CD                                       50380000
MFA-TR*         INTO :RD-RATE-DEPT-CD                                   50390000
MFA-TR*         FROM CSS_RATE_PLAN_DESC RD                              50400000
MFA-TR*        WHERE CODE_UTIL_TYPE = :RD-CODE-UTIL-TYPE                50410000
MFA-TR*          AND RATE_PLAN_NO   = :RD-RATE-PLAN-NO                  50420000
MFA-TR*      QUERYNO 7020                                               50430000
MFA-TR*    END-EXEC.                                                    50440000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 50450000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA179 ABORT **************'        
              DISPLAY '* 7020-GET-RATE-DEPT-CD                *'        
              DISPLAY '* CODE_UTIL_TYPE  ' RD-CODE-UTIL-TYPE            
              DISPLAY '* RATE_PLAN_NO    ' RD-RATE-PLAN-NO              
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA179 ABORT **************'        
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 50590000
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************50310000
      * 7030-GET-REV-DISTRICT-CD.                                      *50320000
      * SELECTS THE REV-DISTRICT-CD FROM CSS_PREMISE TABLE.            *50330000
      ******************************************************************50340000
      *                                                                         
       7030-GET-REV-DISTRICT-CD.                                        
      *                                                                 50360000
           EXEC SQL                                                     
              SELECT REV_DISTRICT_CD                                    
                INTO :PR-REV-DISTRICT-CD                                
                FROM CSS_PREMISE PR                                     
               WHERE PR.PREMISE_NO  = :PR-PREMISE-NO                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     50370000
MFA-TR*       SELECT REV_DISTRICT_CD                                    50380000
MFA-TR*         INTO :PR-REV-DISTRICT-CD                                50390000
MFA-TR*         FROM CSS_PREMISE PR                                     50400000
MFA-TR*        WHERE PR.PREMISE_NO  = :PR-PREMISE-NO                    50410000
MFA-TR*      QUERYNO 7030                                               50430000
MFA-TR*    END-EXEC.                                                    50440000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 50450000
           MOVE SQLCODE    TO WS-ACTIVE-RETURN-CODE.                    
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA179 ABORT **************'        
              DISPLAY '* 7030-GET-REV-DISTRICT-CD             *'        
              DISPLAY '* PREMISE_NO      ' PR-PREMISE-NO                
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA179 ABORT **************'        
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 50590000
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7040-GET-MNICIPLTY-COUNTY-CD.                                  *        
      * GET MUNICIPALITY COUNTY CODE                                   *        
      ******************************************************************        
       7040-GET-MNICIPLTY-COUNTY-CD.                                    
      *                                                                         
           EXEC SQL                                                     
              SELECT MNICPLTY_COUNTY_CD                                 
                INTO :F4-MNICPLTY-COUNTY-CD                             
                FROM CSS_MNICPLTY_CNTY WITH(READUNCOMMITTED)                    
               WHERE REV_DISTRICT_CD   = :F4-REV-DISTRICT-CD            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MNICPLTY_COUNTY_CD                                         
MFA-TR*         INTO :F4-MNICPLTY-COUNTY-CD                                     
MFA-TR*         FROM CSS_MNICPLTY_CNTY                                          
MFA-TR*        WHERE REV_DISTRICT_CD   = :F4-REV-DISTRICT-CD                    
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7040                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA179  ABORT **************'       
              DISPLAY '* 7040-GET-MNICIPLTY-COUNTY-CD          *'       
              DISPLAY '* REV_DISTRICT_CD   = ' F4-REV-DISTRICT-CD       
              DISPLAY '* SQLCODE IS        : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '* PROGRAM ABORTING...                   *'       
              DISPLAY '********** PCSCA179  ABORT **************'       
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************50630000
      * 7050-GET-CURR-TIMESTAMP                                        *50640000
      * GETS CURRENT TIMESTAMP                                         *50650000
      ******************************************************************50660000
       7050-GET-CURR-TIMESTAMP.                                         
      *                                                                 50680000
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     50690000
MFA-TR*       SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP             50700000
MFA-TR*    END-EXEC.                                                    50710000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE '7050'                      TO WS-ACTIVE-PARAGRAPH.     
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA179 ABORT **************'        
              DISPLAY '* 7050-SELCT-CURRENT-TIMESTAMP         *'        
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA179 ABORT **************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 50860000
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                 50890000
      ******************************************************************65571000
      * 7415-OPEN-REV-PROT-DETAIL-ADJ.                                * 65572000
      * OPENE REV-PROT-DETAIL-ADJ                                      *65573000
      ******************************************************************65574000
       7415-OPEN-REV-PROT-DETAIL-ADJ.                                   
                                                                        
           MOVE '7415'                      TO WS-ACTIVE-PARAGRAPH.     
                                                                        
           EXEC SQL                                                     
              OPEN  REV_DETAIL_ADJ                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA179 ABORT  ************'         
              DISPLAY '* 7415-OPEN-REV-PROT-DETAIL-ADJ       *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* REVENUE MONTH ', R0-REVENUE-MONTH              
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA179 ABORT  ************'         
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7415-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************65251000
      * 7425-FETCH-REV-PROT-DETAIL-ADJ.                                *65252000
      * FETCH REV_DETAIL_ADJ DATA.                                     *65253000
      ******************************************************************65254000
      *                                                                         
       7425-FETCH-REV-PROT-DETAIL-ADJ.                                  
                                                                        
           MOVE '7425'                      TO WS-ACTIVE-PARAGRAPH.     
                                                                        
           EXEC SQL                                                     
                FETCH REV_DETAIL_ADJ                                    
                 INTO :R0-ACCOUNT-NO                                    
                     ,:R0-REV-PROT-CASE-NO                              
                     ,:R0-CASE-STATUS-CD                                
                     ,:R0-CREATE-DT                                     
                     ,:R0-COMPANY-NO                                    
                     ,:RL-CASE-TYPE-CD                                  
                     ,:RL-RATE-PLAN-NO                                  
                     ,:RL-CODE-REVENUE-CLASS                            
                     ,:RL-COLLECTIBLE-UNITS                             
                     ,:RL-COLLECTIBLE-AM                                
                     ,:RL-CONSUMPT-TYPE-CD                              
                     ,:RL-AMT-DOWN-PYMT                                 
                     ,:RL-GL-ACCT-NO                                    
                     ,:RL-CASE-AM                                       
                     ,:AT-BILL-CYCLE                                    
                     ,:AT-CUSTOMER-NO                                   
                     ,:AT-LOCAL-OFFICE                                  
                     ,:AT-PREMISE-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA179 ABORT  ************'         
              DISPLAY '* 7425-FETCH-REV-PROT-DETAIL-ADJ  *'             
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* REVENUE MONTH ', R0-REVENUE-MONTH              
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA179 ABORT  ************'         
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7425-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************65571000
      * 7435-CLOSE-REV-PROT-DETAIL-ADJ.                                *65572000
      * CLOSE REV-PROT-DETAIL-ADJ                                      *65573000
      ******************************************************************65574000
       7435-CLOSE-REV-PROT-DETAIL-ADJ.                                  
                                                                        
           MOVE '7435'                      TO WS-ACTIVE-PARAGRAPH.     
                                                                        
           EXEC SQL                                                     
              CLOSE REV_DETAIL_ADJ                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA179 ABORT  ************'         
              DISPLAY '* 7435-CLOSE-REV-PROT-DETAIL-ADJ       *'        
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* REVENUE MONTH ', R0-REVENUE-MONTH              
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA179 ABORT  ************'         
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7435-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  68940000
      *7520-SELECT-RT-VERS-FROM-DT.                                  *  68950000
      *GET RT-VERS-FROM-DT FROM CSS_RATE_CREATOR RT USING THE        *  68960000
      *CODE-UTIL-TYPE AND RATE-PLAN-NO.                              *  68970000
      ****************************************************************  68980000
      *                                                                         
       7520-SELECT-RT-VERS-FROM-DT.                                     
                                                                        
           MOVE '7520'                      TO WS-ACTIVE-PARAGRAPH.     
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) FROM_EFFECTIVE_DT,
              VERSION_NO_CNTRL                                 
                  INTO :RT-FROM-EFFECTIVE-DT                            
                      ,:RT-VERSION-NO-CNTRL                             
                  FROM CSS_RATE_CREATOR RT                              
                 WHERE CODE_UTIL_TYPE = :RT-CODE-UTIL-TYPE              
                   AND RATE_PLAN_NO   = :RT-RATE-PLAN-NO                
                 ORDER BY 2 DESC                                        
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                     69030000
MFA-TR*         SELECT FROM_EFFECTIVE_DT                                69040000
MFA-TR*               ,VERSION_NO_CNTRL                                 69040000
MFA-TR*           INTO :RT-FROM-EFFECTIVE-DT                            69050000
MFA-TR*               ,:RT-VERSION-NO-CNTRL                             69060000
MFA-TR*           FROM CSS_RATE_CREATOR RT                              69070000
MFA-TR*          WHERE CODE_UTIL_TYPE = :RT-CODE-UTIL-TYPE              69080000
MFA-TR*            AND RATE_PLAN_NO   = :RT-RATE-PLAN-NO                69100000
MFA-TR*          ORDER BY 2 DESC                                        69120000
MFA-TR*          FETCH FIRST 1 ROWS ONLY                                69130000
MFA-TR*        QUERYNO 7520                                             69140000
MFA-TR*    END-EXEC.                                                    69150000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 69160000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA179  ABORT **************'       
              DISPLAY '* 7520-SELECT-CMPNT-ID-CD               *'       
              DISPLAY '* CODE_UTIL_TYPE    = ' RT-CODE-UTIL-TYPE        
              DISPLAY '* RATE_PLAN_NO      = ' RT-RATE-PLAN-NO          
              DISPLAY '* SQLCODE IS          ', WS-ACTIVE-RETURN-CODE   
              DISPLAY '* PROGRAM ABORTING...                   *'       
              DISPLAY '********** PCSCA179  ABORT **************'       
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
      *                                                                 69390000
      ******************************************************************50240000
      * 7620-START-FCSCA00                                             *50250000
      ******************************************************************50260000
           EXEC SQL                                                     50270000
                INCLUDE CPD00039                                        50280000
           END-EXEC.                                                    50290000
      *                                                                 50300000
      ******************************************************************69400000
      * CPD00038                                                       *69410000
      * 7600-START-FCSJC01                                             *69420000
      * 7610-READ-FCSJC01                                              *69430000
      * 7611-CLOSE                                                     *69440000
      ******************************************************************69450000
      *                                                                 69460000
           EXEC SQL                                                     69470000
               INCLUDE CPD00038                                         69480000
           END-EXEC.                                                    69490000
      *                                                                 69500000
      ******************************************************************69860000
      * 8000-WRITE-FCSCREVD                                            *69870000
      * WRITES OUTPUT FILE - FCSCREVD                                  *69880000
      ******************************************************************69890000
       8000-WRITE-FCSCREVD.                                             
      *                                                                 69910000
           MOVE '8000'                      TO WS-ACTIVE-PARAGRAPH.     
                                                                        
           WRITE FCSCREVD.                                              
                                                                        
           IF FCSCREVD-SUCCESSFUL                                       
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA179 ABORT **************'        
              DISPLAY '*     WRITE ERROR : FCSCREVD-FILE      *'        
              DISPLAY '* CURRENT PARA   : 8000                *'        
              DISPLAY '* FILE-STATUS    : ' WS-FCSCREVD-STATUS          
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA179 ABORT **************'        
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 70130000
      ******************************************************************70140000
      * 8010-WRITE-FCSCREVC                                            *70150000
      * WRITES OUTPUT FILE - FCSCREVC                                  *70160000
      ******************************************************************70170000
       8010-WRITE-FCSCREVC.                                             
      *                                                                 70190000
           MOVE '8010'                      TO WS-ACTIVE-PARAGRAPH.     
                                                                        
           WRITE FCSCREVC.                                              
           IF FCSCREVC-SUCCESSFUL                                       
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA179 ABORT **************'        
              DISPLAY '*     WRITE ERROR : FCSCREVC-FILE      *'        
              DISPLAY '* CURRENT PARA   : 8010                *'        
              DISPLAY '* FILE-STATUS    : ' WS-FCSCREVC-STATUS          
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA179 ABORT **************'        
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 70400000
      ******************************************************************71590000
      * 9000-TERMINATE.                                                *71600000
      ******************************************************************71610000
      *                                                                         
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSCREVC-FILE.                                         
           CLOSE FCSCREVD-FILE.                                         
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 71730000
      ******************************************************************71960000
      * 9900-ABEND                                                     *71970000
      * COPYBOOK FOR ABEND/ERROR PROCESSING                            *71980000
      ******************************************************************71990000
      *                                                                         
           EXEC SQL                                                     72000000
                INCLUDE CPD09900                                        72010000
           END-EXEC.                                                    72020000
      *                                                                 72040000
