       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA178.                                        
       DATE-WRITTEN.   SEPTEMBER 2013.                                  
       DATE-COMPILED.                                                   
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRIC AND GAS               **          
      ********          CUSTOMER INFORMATION SYSTEM          *********          
      ****************************************************************          
      **               P R O G R A M    S U M M A R Y               **          
      **           F U N C T I O N A L  D E S C R I P T I O N       **          
      **                       O F    M O D U L E                   **          
      **                                                            **          
      **  PURPOSE :                                                 **          
      **  UPDATE RV.REV_POST_STATUS_FL TO 'Y'                       **          
      **                                                            **          
      **  LOGIC :                                                   **          
      **                                                            **          
      **  IF CURRENT REVENUE MONTH (FROM PCSCA204 - JOB_PARM)       **          
      **  AND RV.REV_POST_STATUS_FL = 'N', CHANGE IT TO 'Y'.        **          
      **                                                            **          
      ****************************************************************          
      **                                                            **          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      **    DATE    INITIALS     REASON                             **          
      **  ________  _________    __________________________________ **          
      **   SEP 2013    RDF       INITIAL VERSION.                   **          
      **                                                            **          
      **                                                            **          
      ****************************************************************          
           REMARKS.                                                     
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA178'.
MSQ017     COPY MFASQLM.
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_JOB_PARM                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_REV_BILLING_DET  -  RV                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBREVBLD                                                 
           END-EXEC.                                                            
      *                                                                         
       01  WS-PARM-DATA204.                                             
           05 WS-PARM-LITERAL          PIC X(14).                       
           05 WS-REVENUE-MONTH.                                         
              07 WS-REVENUE-YEAR       PIC 9(4).                        
              07 WS-REVENUE-MM         PIC 99.                          
           05 FILLER                   PIC X(60).                       
      *                                                                         
       01  WS-WORK-REVENUE             PIC 9(6) VALUE 0.                
       01  WS-REVENUE-MONTH-P          PIC S9(6)V COMP-3 VALUE 0.       
      *                                                                         
       01  WS-LITERALS.                                                 
           05 WS-ACTIVE                PIC X     VALUE 'A'.             
           05 WS-PGM-204               PIC X(8)  VALUE 'PCSCA204'.      
           05 WS-PARM-204              PIC X(4)  VALUE 'PARM'.          
           05 WS-COMPANY-204           PIC XX    VALUE '01'.            
           05 WS-SEQ-NO                PIC S9999V COMP-3 VALUE 6.       
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
      ****** JOBS FILE/TABLE DEFINITIONS                                        
      *                                                                         
       COPY FIOCA00.                                                            
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
      ****** CWS00038 IS JC01 WORK DATA                                         
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
       COPY CWS00114.                                                           
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      **       CONTROLS THE MAIN PROCESSING OF THE PROGRAM          **          
      ****************************************************************          
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
      *                                                                         
           PERFORM 7220-UPDATE-REV-BILLING-DET THRU 7220-EXIT.          
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       PERFORMS INITIALIZATION OF INPUT/OUTPUT FILES        **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           MOVE WS-PGM-204     TO G6-PROGRAM-NAME.                      
           MOVE WS-PARM-204    TO G6-CMND-CODE.                         
           MOVE WS-COMPANY-204 TO G6-COMPANY-NO.                        
           MOVE WS-SEQ-NO      TO G6-SEQ-NO.                            
           MOVE WS-ACTIVE      TO G6-STATUS.                            
      *                                                                         
           PERFORM 7400-GET-REVENUE-MONTH THRU 7400-EXIT.               
      *                                                                         
           MOVE G6-PARM-DATA TO WS-PARM-DATA204.                        
           MOVE WS-REVENUE-MONTH TO  WS-WORK-REVENUE.                   
           MOVE WS-WORK-REVENUE  TO WS-REVENUE-MONTH-P.                 
           DISPLAY 'WS-REVENUE-MONTH = '   WS-REVENUE-MONTH.            
           DISPLAY 'WS-WORK-REVENUE = '    WS-WORK-REVENUE.             
           DISPLAY 'WS-REVENUE-MONTH-P = ' WS-REVENUE-MONTH-P.          
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** UPDATE REV_POST_STATUS_FL                                  **          
      ****************************************************************          
      *                                                                         
       7220-UPDATE-REV-BILLING-DET.                                     
      *                                                                         
           MOVE '7220' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
                UPDATE REV_BILLING_DET                                  
                 SET REV_POST_STATUS_FL = 'Y'                           
                 WHERE REVENUE_MONTH = :WS-REVENUE-MONTH-P              
                   AND REV_POST_STATUS_FL = 'N'                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  ERROR IN 7220-UPDATE-REV-BILLING-DET **'     
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING IS TERMINATED          **'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  GET REVENUE MONTH USING PCSCA204 JOB PARM                 **          
      ****************************************************************          
      *                                                                         
       7400-GET-REVENUE-MONTH.                                          
      *                                                                         
           EXEC SQL                                                     
               SELECT  PARM_DATA                                        
                 INTO  :G6-PARM-DATA                                    
               FROM  CSS_JOB_PARM WITH(READUNCOMMITTED)                         
              WHERE  PROGRAM_NAME = :G6-PROGRAM-NAME                    
                AND  CMND_CODE    = :G6-CMND-CODE                       
                AND  COMPANY_NO   = :G6-COMPANY-NO                      
                AND  SEQ_NO       = :G6-SEQ-NO                          
                AND  STATUS       = :G6-STATUS                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  PARM_DATA                                                
MFA-TR*          INTO  :G6-PARM-DATA                                            
MFA-TR*        FROM  CSS_JOB_PARM                                               
MFA-TR*       WHERE  PROGRAM_NAME = :G6-PROGRAM-NAME                            
MFA-TR*         AND  CMND_CODE    = :G6-CMND-CODE                               
MFA-TR*         AND  COMPANY_NO   = :G6-COMPANY-NO                              
MFA-TR*         AND  SEQ_NO       = :G6-SEQ-NO                                  
MFA-TR*         AND  STATUS       = :G6-STATUS                                  
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*****************************************'       
              DISPLAY '**ERROR RETRIEVING REVENUE MONTH       **'       
              DISPLAY '**   FROM JOB PARM - PCSCA204          **'       
              DISPLAY '**7400-GET-REVENUE-MONTH               **'       
              DISPLAY '**SQLCODE = ' WS-ACTIVE-RETURN-CODE              
              DISPLAY '**G6-PROGRAM-NAME = ' G6-PROGRAM-NAME            
              DISPLAY '**G6-CMND-CODE    = ' G6-CMND-CODE               
              DISPLAY '**G6-COMPANY-NO   = ' G6-COMPANY-NO              
              DISPLAY '**G6-SEQ-NO       = ' G6-SEQ-NO                  
              DISPLAY '**G6-STATUS       = ' G6-STATUS                  
              DISPLAY '*****************************************'       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       CLOSES ALL OPEN FILES AND TERMINATES THE PROGRAM     **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           DISPLAY 'WS-REVENUE-MONTH = ' WS-REVENUE-MONTH.              
           DISPLAY 'SQLCODE = ' WS-ACTIVE-RETURN-CODE.                  
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  9900-ABEND                                                **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
