       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   PCSCA177.                                          
       AUTHOR.       CSC.                                               
       DATE-WRITTEN. DEC 2009.                                          
       DATE-COMPILED.                                                   
      ******************************************************************        
      **               SOUTH CAROLINA ELECTRIC & GAS                  **        
      **                      COBOL-DB2                               **        
      ******************************************************************        
      **                     PROGRAM SUMMARY                          **        
      ******************************************************************        
      **                                                              **        
      ** PROGRAM TO CREATE THE REVENUE INTERFACE FILES FROM THE BE22  **        
      ** FILE                                                         **        
      **                                                              **        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     INPUT PROCESSING CONTROL PATH         **        
      **        2000 - 2999     OUTPUT PROCESS CONTROL PATH           **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     COMMON SYSTEM MODULES                 **        
      **        7000 - 7999     INPUT MODULES                         **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      **              PROGRAM  MODIFICATION  LOG                      **        
      ******************************************************************        
      ** DATE     USERID   REASON                                     **        
      ** -------  -------  ------                                     **        
P00257** 12/2009  SJ94244  INITIAL IMPLEMENTATION.                    **        
P00257** 05/2010  GOKUL    ADDITIONAL CHANGES TO MATCH CURRENT REVENUE**        
P00257**                   SYSTEM.                                    **        
P00257** 06/2010  GOKUL    RATE CASE RELATED CHANGES.                 **        
P00257** 08/2010  SJ94244  ADDED NEW FIELDS TO REVENUE FILES.         **        
PRJ257** 11/2010  SB93596  FRAN-TAX-GENERATION CHGS.                  **        
PRJ257** 12/2010  SB93596  ADDING CHGS FOR REV-CUST-CNT-CD SELECTION  **        
PRJ257** 12/2010  SB93596  MONTHLY MINIMUM / ANNUAL MINIMUM CHANGES   **        
T03014** 01/2011  SB93596  CORRECTIONS FOR GAS T78 DISCREPENCY IN     **        
T03014**                   UTILITY_REV_CD.                            **        
PRJ257** 04/2011  GOKUL    POPULATE MISSING TAX DETAILS FOR SEB TAX   **        
PRJ257**                   FACTORS.                                   **        
PRJ257** 04/2011  GOKUL    ADD TAX CONTROL NO FOR TAX FACTORS.        **        
A02932** 06/2011  GOKUL    1. INCLUDE FRANCHISE TAX IN SALES TAX      **        
A02932**                      CALCULATION.                            **        
A02932**                   2. PROCESS THE SPECIAL ANNUAL MINIMUMS     **        
A02932**                      WITH MORE THAN ONE COMPONENT PROPERLY.  **        
A02932** 06/2011  GOKUL    INCLUDE THE ADJ DETAILS TO COMPUTE ANNUAL- **        
A02932**                   MIN-AMT.                                   **        
P00496** 04/2011  ROD      EXPAND EVENT NUMBER TO 2 BYTES.            **        
P00496** 06/2011  SS97726  INDUSTRIAL BILLING ENHANCEMENTS.           **        
A03303*  05/26/11 MC95456  FIXED FACTOR PRECISION CHANGES FROM 4 TO 6 **        
A03303*           ACT034   DECIMAL POINTS FOR INDUSTRIAL BILLING.     **        
      **                                                              **        
A03411** 8-11-11  RF10596  CORRECT ERROR IN TAX CONTROL NUMBER.  ALSO **        
A03411**                   LOCAL OFFICE WHEN A CHANGE HAS BEEN MADE   **        
      **                                                              **        
ACT202*  10/14/11 VIJAY    FIX LOGIC TO GET CORRESPONDING CANCELLED ROW*        
ACT202*  APPL3082          OF A BACK OUT ROW.                         **        
ACT202*                    7300- PARA FIXED AND 7302- DELETED.        **        
P00473*  02/21/12 MS93554  CHGS INCLUDED TO RETRIEVE APPROVED VERSION.**        
A04359*  11/29/12 HA7A338  SALES TAX EXEMPT CHANGES FOR SEB GEORGIA   **        
A04359*                    MANUFACTURE CUSTOMERS.                     **        
A04581*  11/18/13 SV95326  ADD RECCHGTAX FACTOR AMOUNT IN             **        
A04581*           ACT001   WS-TOTAL-AMT-FOR-TAX AND DONT WRITE IT     **        
A04581*                    E-REVTAX-TAX-TYPE AS 'T' IN FCSCREVT FILE. **        
A04581*           ACT002   POPULATE E-REVDET-ELEC-WNA-GROUP-NO IN     **        
A04581*                    FCSCREVD FILE FROM CSS_BILLING_DET TABLE   **        
A04581*                    FOR SCEG ELECTRIC TYPE ACCOUNT.            **        
ACT004*  05/06/13 VIJAY    FIX OOB ISSUES.                            **        
ACT004*   A04581           1.FIXED POPULATION OF REV-COMPANY-NO       **        
ACT004*                    2.FIXED UNMETER CHARGES IN BACK OUT ROW CALC*        
ACT004*                    3.FIXED TO USE PROPER PRORATE-CD TO BUILD  **        
ACT004*                      BY BILL CALC PROGRAM(CPDCA107).          **        
ACT006*  05/28/13 VIJAY    FIX CALC_UNITS FOR 'NETREVFCT'  FACTOR.    **        
ACT006*   A04581           CALC_UNITS SHOULD EQUAL BILL_USAGE_UNITS OR**        
ACT006*                    BILL_DEMAND_UNITS FOR THE NETREVFCT AND     *        
ACT006*                    SHOULD MATCH CSS_BILL_CALC_DET: BILL_UNITS           
ACT154*  09/19/13 VIJAY    WRITE DDC WITH -VE MONEY FOR BACK OUT ROWS  *        
ACT154*   A04527                                                       *        
ACT174*  10/18/13 VIJAY    FOR COMPANY USE ACCOUNTS SET CUST_CT AS     *        
ACT174*   A04527           ZERO.REMOVED WS-NO-OF-CONS-DAYS-BG  CHECK.  *        
ACT011*  01/21/14 VIJAY  1.COUNT WHEN RATE CHANGES IF IT IS FINALED.   *        
ACT011*   A04880         2.DO NOT COUNT PR1,60T AND 23F RATE ACCOUNTS  *        
ACT011*                    (REV-CUST-CNT-CD = 'N').                    *        
P00794*  07/02/14 VIJAY   NC SALES TAX IMPLEMENTTION CHANGES WHICH     *        
P00794*                   WILL BE STARTED CALCULATING FROM '2014-07-01'*        
ACT044*  02/19/15 VIJAY   FIX ABEND WHEN PROCESSING FINALED ACCOUNT    *        
ACT044*   A05136          BILLED IN SAME MONTH AS NORMAL.              *        
I01959*  07/31/15 JC91900 Calculate Incremental Cost Recovery.         *        
I01959*                   Solar Renewables Project.                    *        
I01959*  10/08/15 JC91900 Adding SOLAR usage estimation logic.         *        
I01959*  11/12/15 JC91900 Reduce excess credit from bill wo/solar.     *        
I01959*  12/02/15 JC91900 Recovery amount is not calculated correctly  *        
I01959*                   for a cancel/rebill future.                  *        
ACT077*  03/01/16 VIJAY   POPULATE FUEL_SHIPPER_CD in REV_BILLING_DET. *        
ACT077*  A05460           OPTION_CD field as 'SHIPPER=X' WHERE X IS    *        
ACT077*                   FUEL_SHIPPER_CD.                                      
      ******************************************************************        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSBE22.                                                            
       COPY CSSREVB.                                                            
       COPY CSSREVC.                                                            
       COPY CSSREVD.                                                            
       COPY CSSREVT.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *INPUT FILE                                                               
      *                                                                         
       COPY CFDBE22.                                                            
       COPY FIOBE22.                                                            
      *                                                                         
      *OUTPUT FILES                                                             
       COPY CFDCREVB.                                                           
       COPY FCSCREVB.                                                           
                                                                        
       COPY CFDCREVC.                                                           
       COPY FCSCREVC.                                                           
                                                                        
       COPY CFDCREVD.                                                           
       COPY FCSCREVD.                                                           
                                                                        
       COPY CFDCREVT.                                                           
       COPY FCSCREVT.                                                           
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ012      EXEC SQL INCLUDE MFADIAG END-EXEC
MSQ008  01 MSQ008-CAPACITY-FCTR  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-PRTY-SVC-CSR  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-SEB-REV-COMP-CSR  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-SPCL-FCTR-CSR  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-RATE-COMP-CSR  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-RATE-PL-DESC-CSR  PIC S9(9) COMP-5.
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA177'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                       PIC X(40) VALUE                
                        'WORKING STORAGE FOR PCSCA177 STARTS HERE'.     
       01 WS-MISC.                                                      
A03411    05 WS-FRAN-CNTRL-NO            PIC S9(4) COMP VALUE 20.       
          05 WS-CURRENT-DATE             PIC X(10) VALUE SPACES.        
          05 WS-CURRENT-TIMESTAMP        PIC X(26) VALUE SPACES.        
          05 WS-PREV-TIMESTAMP           PIC X(26) VALUE SPACES.        
          05 WS-COMPANY-NO               PIC X(02) VALUE '01'.          
          05 WS-INDEX                    PIC S9(04) COMP VALUE +0.      
          05 WS-RECORD-COUNT             PIC S9(04) COMP VALUE +0.      
          05 WS-RUNNING-COUNTER          PIC S9(04) COMP VALUE +0.      
          05 WS-DISPLAY-ACCOUNT          PIC 9(13) VALUE 0.             
COB305    05 WS-HOLD-BILL-USAGE-UNITS        PIC S9(9) COMP-3 VALUE 0.          
COB305    05 WS-HOLD-BILL-DEMAND-UNITS        PIC S9(9) COMP-3 VALUE 0.         
COB305    05 WS-HOLD-READ-UNITS        PIC S9(9) COMP-3 VALUE 0.              
COB305    05 WS-HOLD-BC-BILL-UNITS        PIC S9(9) COMP-3 VALUE 0.             
COB305    05 WS-HOLD-BC-READ-UNITS        PIC S9(9) COMP-3 VALUE 0.             
COB305    05 WS-HOLD-BZ-READ-UNITS        PIC S9(9) COMP-3 VALUE 0.             
COB305    05 WS-HOLD-DDC-FACTOR        PIC S9(9)V9(6) COMP-3 VALUE 0.         
          05 WS-HOLD-CNSMPTN-TYPE        PIC X(10) VALUE SPACES.        
          05 WS-HOLD-BILL-DATE           PIC X(10) VALUE SPACES.        
          05 WS-HOLD-EFF-START-DT        PIC X(10) VALUE SPACES.        
          05 WS-REVENUE-CNSMPTN-FL-TEMP  PIC X(01) VALUE SPACES.        
          05 WS-REVENUE-AMOUNT-FL-TEMP   PIC X(01) VALUE SPACES.        
          05 WS-PRORATE-FL-TEMP          PIC X(01) VALUE SPACES.        
          05 WS-HOLD-UNMTR-PROV-FL       PIC X(01) VALUE SPACES.        
PRJ257    05 WS-HOLD-REV-CUST-CNT-CD     PIC X(01) VALUE SPACES.        
          05 WS-HOLD-SERVICE-TYPE        PIC X(01) VALUE SPACES.        
          05 WS-HOLD-RATE-CALC-TYPE-CD   PIC X(02) VALUE SPACES.        
          05 WS-HOLD-SEB-REV-COMP-NO     PIC X(02) VALUE SPACES.        
          05 WS-HOLD-SBR-REV-COMP-NO     PIC X(02) VALUE SPACES.        
          05 WS-ORDER-ROW-COUNT          PIC S9(04) COMP VALUE +0.      
          05 WS-RD-COUNT                 PIC S9(04) COMP VALUE +0.      
          05 WS-SF-COUNT                 PIC S9(04) COMP VALUE +0.      
          05 WS-N6-COUNT                 PIC S9(04) COMP VALUE +0.      
          05 WS-TT-COUNT                 PIC S9(04) COMP VALUE +0.      
I01959    05 WS-CF-COUNT                 PIC S9(04) COMP VALUE +0.      
          05 WS-Z4-COUNT                 PIC S9(04) COMP VALUE +0.      
          05 WS-NUM-COND                 PIC S9(04) COMP VALUE +0.      
          05 WS-HOLD-BA-SEQ-NO           PIC S9(04) COMP VALUE +0.      
A02932    05 WS-TEMP-BC-SEQ-NO           PIC S9(04) COMP VALUE +0.      
A02932    05 WS-TEMP-BC-COUNT            PIC S9(04) COMP VALUE +0.      
          05 WS-FREVD-WRITE-COUNT        PIC S9(04) COMP VALUE +0.      
          05 WS-FREVC-WRITE-COUNT        PIC S9(04) COMP VALUE +0.      
          05 WS-FREVB-WRITE-COUNT        PIC S9(04) COMP VALUE +0.      
          05 WS-FREVT-WRITE-COUNT        PIC S9(04) COMP VALUE +0.      
          05 WS-FACTOR-TYPE-FL           PIC X(01) VALUE SPACES.        
          05 WS-PART-NO                  PIC 9(02).                     
          05 WS-FCSBE22-REC-CNTR         PIC S9(07) VALUE ZERO COMP-3.  
          05 WS-ACCOUNT-BILLED-COUNT     PIC S9(04) COMP VALUE +0.      
COB305    05 WS-UTIL-REV-TRACKED        PIC S9(9)V9(6) COMP-3 VALUE 0.         
COB305    05 WS-NONUTIL-REV-NOT-TRACKED        PIC S9(9)V9(6) COMP-3 
COB305       VALUE 0.         
COB305    05 WS-NON-UTIL-REV-TRACKED        PIC S9(9)V9(6) COMP-3 
COB305       VALUE 0.         
          05 WS-HOLD-RATE-VERSION        PIC X(01).                     
          05 WS-RATE-VERSION-FOUND       PIC X(01).                     
          05 SUB7                        PIC 9(03) VALUE 0.             
          05 WS-SCSCA-RETURN-CODE        PIC S9(4) COMP.                
          05 WS-NI-USAGE-END-DATE        PIC S9(4) COMP.                
          05 WS-NI-DATE-BILLED           PIC S9(4) COMP.                
          05 WS-NI-DATE-ORIG-BILL        PIC S9(4) COMP.                
          05 WS-NI-RT-VERSN-DT           PIC S9(4) COMP.                
          05 WS-NI-RT-FCT-FROM-DT        PIC S9(4) COMP.                
          05 WS-NI-KW-MDQ-DT             PIC S9(4) COMP.                
          05 WS-NI-KVA-DT                PIC S9(4) COMP.                
          05 WS-NI-READ-UNITS            PIC S9(4) COMP.                
          05 WS-NI-BILL-UNITS            PIC S9(4) COMP.                
          05 WS-NI-CONSUMPT-TYPE-CD      PIC S9(4) COMP.                
          05 RS-RETURN-CODE              PIC S9(04) COMP VALUE 0.       
          05 WS-DISPLAY-SCSCA            PIC X(08) VALUE SPACES.        
          05 WS-CURR-REV-MONTH           PIC 9(06).                     
          05  FILLER REDEFINES WS-CURR-REV-MONTH.                       
              10  WS-CURR-REV-MONTH-CCYY PIC 9(04).                     
              10  WS-CURR-REV-MONTH-MM   PIC 9(02).                     
          05 WS-BLOCK-NO                 PIC 9(02).                     
COB305    05 WS-AMT-BILL-ITEM-HOLD        PIC S9(09)V99 COMP-3 VALUE 0.         
COB305    05 WS-AMT-STATE-TAX-HOLD        PIC S9(07)V99 COMP-3 VALUE 0.         
COB305    05 WS-AMT-CITY-TAX-HOLD        PIC S9(07)V99 COMP-3 VALUE 0.          
COB305    05 WS-AMT-OTHER-TAX-HOLD        PIC S9(07)V99 COMP-3 VALUE 0.         
COB305    05 WS-TOTAL-BILL-ITEM-AMT        PIC S9(09)V99 COMP-3 VALUE 0.        
COB305    05 WS-TOTAL-AMT-FOR-TAX        PIC S9(09)V99 COMP-3 VALUE 0.          
COB305    05 WS-HOLD-BLK-REV-AMT        PIC S9(09)V99 COMP-3 VALUE 0.          
COB305    05 WS-TEMP-REV-AMOUNT        PIC S9(09)V99 COMP-3 VALUE 0.          
COB305    05 WS-TAX-AMT        PIC S9(09)V99 COMP-3 VALUE 0.          
COB305    05 WS-HOLD-TAX-AMT        PIC S9(09)V99 COMP-3 VALUE 0.          
          05 WS-HOLD-CX-COUNT            PIC S9(04) COMP VALUE +0.      
          05 WS-HOLD-CX-INDX2            PIC S9(04) COMP VALUE +0.      
          05 WS-REVBLK-BILL-COMP-SEQ-NO  PIC S9(04) COMP VALUE +0.      
PRJ257    05 WS-TEMP-TAX-CNTRL-NO        PIC S9(04) COMP VALUE +0.      
          05 WS-TEMP-COMPONENT-ID        PIC X(02) VALUE SPACES.        
T03014    05 WS-TEMP-COMPONENT-ID-J1     PIC X(02) VALUE SPACES.        
COB305    05 WS-TEMP-RATE-PERCENT        PIC S9(9)V9(6) COMP-3 VALUE 0.         
COB305    05 WS-TEMP-REVADJ-AMT        PIC S9(9)V99 COMP-3 VALUE 0.         
COB305    05 WS-HOLD-ANNUAL-MIN-AMT        PIC S9(9)V99 COMP-3 VALUE 0.         
          05 WS-HOLD-RT-VERS-FROM-DT     PIC X(10) VALUE SPACES.        
          05 WS-HOLD-RT-VERS-PRO-CD      PIC X(01) VALUE SPACES.        
          05 WS-HOLD-BLK-BILL-LT-POLES   PIC S9(9) USAGE COMP.          
          05 WS-HOLD-KW-MDQ-DT           PIC X(10) VALUE SPACES.        
          05 WS-HOLD-KVA-DT              PIC X(10) VALUE SPACES.        
COB305    05 WS-TEMP-READ-UNITS        PIC S9(9)V USAGE COMP-3 VALUE 0.       
COB305    05 WS-TEMP-READ-UNITS-GAS        PIC S9(9)V USAGE COMP-3 
COB305       VALUE 0.       
COB305    05 WS-TEMP-READ-UNITS-ELE        PIC S9(9)V USAGE COMP-3 
COB305       VALUE 0.       
COB305    05 WS-TEMP-READ-UNITS-KVA        PIC S9(9)V USAGE COMP-3 
COB305       VALUE 0.       
COB305    05 WS-TEMP-READ-UNITS-KW        PIC S9(9)V USAGE COMP-3 
COB305       VALUE 0.       
COB305    05 WS-TEMP-CALC-UNITS        PIC S9(9)V USAGE COMP-3 VALUE 0.       
COB305    05 WS-REVADJ-READ-UNITS        PIC S9(9)V USAGE COMP-3 
COB305       VALUE 0.       
COB305    05 WS-REVADJ-BILL-USAGE-UNITS        PIC S9(9)V USAGE COMP-3 
COB305       VALUE 0.       
COB305    05 WS-REVADJ-BILL-DEMAND-UNITS        PIC S9(9)V USAGE COMP-3 
COB305       VALUE 0.       
COB305    05 WS-REVADJ-CALC-UNITS        PIC S9(9)V USAGE COMP-3 
COB305       VALUE 0.       
COB305    05 WS-NONCAL-READ-UNITS        PIC S9(9)V USAGE COMP-3 
COB305       VALUE 0.       
COB305    05 WS-NONCAL-BILL-USAGE-UNITS        PIC S9(9)V USAGE COMP-3 
COB305       VALUE 0.       
COB305    05 WS-NONCAL-BILL-DEMAND-UNITS        PIC S9(9)V USAGE COMP-3 
COB305       VALUE 0.       
COB305    05 WS-NONCAL-CALC-UNITS        PIC S9(9)V USAGE COMP-3 
COB305       VALUE 0.       
COB305    05 WS-REVADJ-GL-ACCT-NO        PIC S9(3)V9(4) USAGE COMP-3 
COB305       VALUE 0.   
          05 WS-RUN-DATE                 PIC X(10).                     
ACT011    05 WS-RATE-PLAN-NO-PREV-BILL   PIC X(03)  VALUE SPACES.       
                                                                        
I01959 01 WS-DER-FACTOR-ID               PIC X(09)  VALUE SPACES.       
I01959 01 WS-DER-SAVINGS-EXIST           PIC X(01)  VALUE SPACES.       
I01959 01 WS-DATE-BILLED                 PIC X(10)  VALUE SPACES.       
COB305 01 WS-TOT-BILL-UNITS        PIC S9(9)V9 COMP-3 VALUE 0.            
COB305 01 WS-BILLED-NON-TOU        PIC S9(9)V9 COMP-3 VALUE 0.            
COB305 01 WS-BILLED-ONPEAK        PIC S9(9)V9 COMP-3 VALUE 0.            
COB305 01 WS-BILLED-OFFPEAK        PIC S9(9)V9 COMP-3 VALUE 0.            
COB305 01 WS-BILLED-SHLDR        PIC S9(9)V9 COMP-3 VALUE 0.            
COB305 01 WS-EXCESS-PRIOR-UNITS        PIC S9(9)V9 COMP-3 VALUE 0.            
COB305 01 WS-DELIVERED-UNITS        PIC S9(9)V9 COMP-3 VALUE 0.            
COB305 01 WS-DER-AMT-WITH-SOLAR        PIC S9(09)V99 COMP-3 VALUE 0.          
COB305 01 WS-INCREMENTAL-COST        PIC S9(09)V99 COMP-3 VALUE 0.          
COB305 01 WS-AVOIDED-COST        PIC S9(09)V99 COMP-3 VALUE 0.          
COB305 01 WS-CAPACITY-COST-RCVRY        PIC S9(09)V99 COMP-3 VALUE 0.          
COB305 01 WS-GEN-UNITS        PIC S9(09)V COMP-3 VALUE 0.          
COB305 01 WS-GEN-UNITS-OFFPEAK        PIC S9(09)V COMP-3 VALUE 0.          
COB305 01 WS-GEN-UNITS-ONPEAK        PIC S9(09)V COMP-3 VALUE 0.          
COB305 01 WS-GEN-UNITS-SHLDR        PIC S9(09)V COMP-3 VALUE 0.          
COB305 01 WS-DER-AMT-WITHOUT-SOLAR        PIC S9(09)V99 COMP-3 VALUE 0.         
COB305 01 WS-TOTAL-GEN-UNITS        PIC S9(09)V COMP-3 VALUE 0.            
COB305 01 WS-ESTIMATED-GEN        PIC S9(09)V COMP-3 VALUE 0.            
I01959 01 WS-NEM-RATE-DEP-CD             PIC X(03) VALUE SPACES.        
COB305 01 WS-CURR-CAPACITY-FACTOR        PIC S9(1)V9(6) USAGE COMP-3 
COB305       VALUE 0.
COB305 01 WS-CURR-ON-PEAK-ALLOC        PIC S9(1)V9(6) USAGE COMP-3 
COB305       VALUE 0.
COB305 01 WS-CURR-OFF-PEAK-ALLOC        PIC S9(1)V9(6) USAGE COMP-3 
COB305       VALUE 0.
COB305 01 WS-HOLD-REVENUE-MONTH        PIC S9(06)V COMP-3 VALUE 0.         
I01959 01 WS-DER-KEYS-TABLE.                                            
I01959    05 WS-HOLD-DER-KEYS OCCURS 30 TIMES                           
I01959                     INDEXED BY DER-KEYS.                         
COB305       10 WS-DER-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.            
COB305       10 WS-DER-REVENUE-MTH        PIC S9(06)V COMP-3 VALUE 0.           
I01959       10 WS-DER-RATE-PLAN         PIC X(03).                     
I01959       10 WS-DER-CODE-TIME-PERIOD  PIC S9(4)   COMP.              
COB305       10 WS-DER-GEN-NONTOU        PIC S9(09)V COMP-3 VALUE 0.            
COB305       10 WS-DER-GEN-ONPEAK        PIC S9(09)V COMP-3 VALUE 0.            
COB305       10 WS-DER-GEN-OFFPEAK        PIC S9(09)V COMP-3 VALUE 0.           
COB305       10 WS-DER-GEN-SHLDR        PIC S9(09)V COMP-3 VALUE 0.            
I01959       10 WS-DER-REBILL-FL         PIC X(01).                     
I01959                                                                  
I01959* Capacity Cost Recovery Factor.                                          
COB305 01 WS-CCR-FCTR        PIC S9(9)V9(6) COMP-3 VALUE 0.         
I01959 01 WS-SHORT-VOS   PIC S9(9)V9(6) COMP-3 VALUE ZEROES.            
I01959 01 WS-LONG-VOS    PIC S9(9)V9(6) COMP-3 VALUE ZEROES.            
       01 WS-HOLD-CX-DATA                PIC X(31000).                  
       01 WS-HOLD-BX-DATA                PIC X(10000).                  
       01 WS-HOLD-BC-DATA                PIC X(100000).                 
P00496 01 WS-HOLD-BA-DATA                PIC X(20400).                  
                                                                        
       01 WS-HOLD-VARIABLES.                                            
          05 WS-PREVIOUS-ACCT-NO         PIC 9(13) VALUE 0.             
                                                                        
       01 WS-MISC-HOST-VARIABLES.                                       
          05 WS-RD-RATE-PLAN-NO          PIC X(03) OCCURS 100 TIMES     
                                                VALUE SPACES.           
          05 WS-RD-CODE-UTIL-TYPE        PIC X(01) OCCURS 100 TIMES     
                                                VALUE SPACES.           
          05 WS-RD-RATE-CALC-TYPE-CD     PIC X(02) OCCURS 100 TIMES     
                                                VALUE SPACES.           
          05 WS-RD-RATE-DEPT-CODE        PIC X(03) OCCURS 100 TIMES     
                                                VALUE SPACES.           
          05 WS-RD-COMPANY-NO            PIC X(02) OCCURS 100 TIMES     
                                                VALUE SPACES.           
          05 WS-RD-UNMTR-PROV-FL         PIC X(01) OCCURS 100 TIMES     
                                                VALUE SPACES.           
PRJ257    05 WS-RD-REV-CUST-COUNT-CD     PIC X(01) OCCURS 100 TIMES     
PRJ257                                          VALUE SPACES.           
          05 WS-N6-RATE-CMPNT-ID         PIC X(02) OCCURS 50 TIMES      
                                                VALUE SPACES.           
          05 WS-N6-REVENUE-CNSMPTN-FL    PIC X(01) OCCURS 50 TIMES      
                                                VALUE SPACES.           
          05 WS-N6-REVENUE-AMOUNT-FL     PIC X(01) OCCURS 50 TIMES      
                                                VALUE SPACES.           
          05 WS-SF-FACTOR-ID             PIC X(09) OCCURS 100 TIMES     
                                                VALUE SPACES.           
          05 WS-SF-PRORATE-FL            PIC X(01) OCCURS 100 TIMES     
                                                VALUE SPACES.           
          05 WS-SF-REV-INTERFACE-FL      PIC X(01) OCCURS 100 TIMES     
                                                VALUE SPACES.           
          05 WS-SF-SPCL-GROUP-CD         PIC X(02) OCCURS 100 TIMES     
                                                VALUE SPACES.           
          05 WS-TT-REV-COMPANY-NO        PIC X(02) OCCURS 50 TIMES      
                                                VALUE SPACES.           
          05 WS-TT-COMPANY-NO            PIC X(02) OCCURS 50 TIMES      
                                                VALUE SPACES.           
          05 WS-TT-TIER-ACCT-TYPE-CD     PIC X(01) OCCURS 50 TIMES      
                                                VALUE SPACES.           
          05 WS-Z4-PRTY-SVC-CAT-CD       PIC X(02) OCCURS 50 TIMES      
                                                VALUE SPACES.           
          05 WS-Z4-COMPANY-NO            PIC X(02) OCCURS 50 TIMES      
                                                VALUE SPACES.           
          05 WS-Z4-CODE-CURTAIL-PRTY     PIC S9(2)V9(1) USAGE COMP-3    
                                                OCCURS 50 TIMES         
                                                VALUE ZEROES.           
I01959    05 WS-ALTERNATE-FUEL-CD        PIC X(01) OCCURS 50 TIMES      
I01959                                          VALUE SPACES.           
I01959    05 WS-CAP-FCTR-MONTH           PIC S9(4) USAGE COMP           
I01959                                          OCCURS 50 TIMES         
I01959                                          VALUE ZEROES.           
I01959    05 WS-CAP-FCTR-START-DT        PIC X(10) OCCURS 50 TIMES      
I01959                                          VALUE SPACES.           
I01959    05 WS-CAPACITY-FACTOR          PIC S9(1)V9(6) USAGE COMP-3    
I01959                                          OCCURS 50 TIMES         
I01959                                          VALUE ZEROES.           
I01959    05 WS-ON-PEAK-ALLOC            PIC S9(1)V9(6) USAGE COMP-3    
I01959                                          OCCURS 50 TIMES         
I01959                                          VALUE ZEROES.           
I01959    05 WS-OFF-PEAK-ALLOC           PIC S9(1)V9(6) USAGE COMP-3    
I01959                                          OCCURS 50 TIMES         
I01959                                          VALUE ZEROES.           
                                                                        
       01 WS-RATE-PLAN-TABLE.                                           
          05 WS-RD-RATE-DATA         OCCURS 0 TO 9999                   
                                     DEPENDING ON WS-RD-COUNT           
                                     INDEXED BY WS-RD-INDX.             
             10 WS-RD-RATE-PLAN-NO-ARR        PIC X(03).                
             10 WS-RD-CODE-UTIL-TYPE-ARR      PIC X(01).                
             10 WS-RD-RATE-CALC-TYPE-CD-ARR   PIC X(02).                
             10 WS-RD-RATE-DEPT-CODE-ARR      PIC X(03).                
             10 WS-RD-COMPANY-NO-ARR          PIC X(02).                
             10 WS-RD-UNMTR-PROV-FL-ARR       PIC X(01).                
PRJ257       10 WS-RD-REV-CUST-CNT-CD-ARR     PIC X(01).                
                                                                        
       01 WS-RATE-CMPNT-TABLE.                                          
          05 WS-N6-RATE-CMPNT-DATA   OCCURS 0 TO 100                    
                                     DEPENDING ON WS-N6-COUNT           
                                     INDEXED BY WS-N6-INDX.             
             10  WS-N6-RATE-CMPNT-ID-ARR      PIC X(02).                
             10  WS-N6-REVENUE-CNSMPTN-FL-ARR PIC X(01).                
             10  WS-N6-REVENUE-AMOUNT-FL-ARR  PIC X(01).                
                                                                        
       01 WS-BC-RATE-VERSION-TBL.                                       
          05 WS-BC-RATE-VERSION-DATA OCCURS 200                         
                                     INDEXED BY WS-RT-VRSN-INDX         
                                                WS-RT-VRSN-IND1.        
             10 WS-BC-COMP-CODE               PIC X(03).                
             10 WS-BC-CNSMPTN-TYPE            PIC X(01).                
             10 WS-BC-REG-TYPE                PIC X(01).                
             10 WS-BC-TOU-CD                  PIC 9(01).                
             10 WS-BC-SEASON-CD               PIC X(01).                
             10 WS-BC-RATE-VER                PIC X(01).                
COB305       10 WS-BC-RATE-PERCENT        PIC S9(9)V9(6) COMP-3 VALUE 0.    
COB305       10 WS-BC-HOLD-READ-UNITS        PIC S9(9) COMP-3 VALUE 0.         
COB305       10 WS-BC-HOLD-BILL-UNITS        PIC S9(9) COMP-3 VALUE 0.         
COB305       10 WS-BC-NET-READ-UNITS        PIC S9(9) COMP-3 VALUE 0.         
COB305       10 WS-BC-NET-BILL-UNITS        PIC S9(9) COMP-3 VALUE 0.         
COB305       10 WS-BC-NET-BILL-DMND-UNITS        PIC S9(9) COMP-3 
COB305          VALUE 0.         
                                                                        
       01 WS-SPCL-FCTR-TABLE.                                           
          05 WS-SF-FCTR-DATA         OCCURS 0 TO 9999                   
                                     DEPENDING ON WS-SF-COUNT           
                                     INDEXED BY WS-SF-INDX.             
             10 WS-SF-FACTOR-ID-ARR           PIC X(09).                
             10 WS-SF-PRORATE-FL-ARR          PIC X(01).                
             10 WS-SF-REV-INTERFACE-FL-ARR    PIC X(01).                
             10 WS-SF-SPCL-GROUP-CD-ARR       PIC X(02).                
                                                                        
       01 WS-CRM-ACCT-TYPE-TABLE.                                       
          05 WS-TT-CRM-TIER-DATA     OCCURS 0 TO 100                    
                                     DEPENDING ON WS-TT-COUNT           
                                     INDEXED BY WS-TT-INDX.             
             10  WS-TT-REV-COMPANY-NO-ARR     PIC X(02).                
             10  WS-TT-COMPANY-NO-ARR         PIC X(02).                
             10  WS-TT-TIER-ACCT-TYPE-CD-ARR  PIC X(01).                
                                                                        
       01 WS-PRTY-SVC-CAT-TABLE.                                        
          05 WS-Z4-SVC-CAT-DATA      OCCURS 0 TO 100                    
                                     DEPENDING ON WS-Z4-COUNT           
                                     INDEXED BY WS-Z4-INDX.             
             10  WS-Z4-PRTY-SVC-CAT-CD-ARR    PIC X(02).                
             10  WS-Z4-COMPANY-NO-ARR         PIC X(02).                
COB305       10 WS-Z4-CODE-CURTAIL-PRTY-ARR        PIC S9(2)V9(1) 
COB305          USAGE COMP-3 VALUE 0.             
       01 WS-CODE-VALUE-TABLE.                                          
          05 WS-UV-CODE-VALUE-DATA   OCCURS 50 TIMES                    
                                     INDEXED BY WS-UV-INDX.             
             10  WS-UV-COLUMN-NAME.                                     
                 15 WS-UV-CODE-UTIL-TYPE      PIC X(01).                
                 15 WS-UV-RATE-PLAN-NO        PIC X(03).                
                 15 FILLER                    PIC X(01).                
                 15 WS-UV-RATE-ITEM-CODE      PIC 9(03).                
                 15 FILLER                    PIC X(01).                
                 15 WS-UV-FACTOR-ID           PIC X(09).                
                                                                        
       01 WS-EQUIP-ID-TABLE.                                            
          05 WS-OLD-EQUIP-ID-DATA.                                      
             10 WS-OLD-EQUIP-ID               PIC X(01)                 
                                     OCCURS 80 TIMES.                   
          05 WS-NEW-EQUIP-ID-DATA.                                      
             10 WS-NEW-EQUIP-ID               PIC X(01)                 
                                     OCCURS 80 TIMES.                   
                                                                        
                                                                        
       01 WS-HOLD-FCTR-DTL.                                             
          05 WS-HOLD-FCTR-DATA       OCCURS 200                         
                                     INDEXED BY WS-HLD-FCTR-INDX        
                                                WS-HLD-FCTR-INDX1.      
             10 WS-HOLD-FACTOR-ID             PIC X(9).                 
             10 WS-HOLD-FCTR-FROM-DT          PIC X(10).                
             10 WS-HOLD-FCTR-CMPNT-ID         PIC X(03).                
             10 WS-HOLD-FCTR-CNSMPTN-TYPE     PIC X(01).                
             10 WS-HOLD-FCTR-REG-TYPE         PIC X(01).                
             10 WS-HOLD-FCTR-TOU-CD           PIC 9(01).                
             10 WS-HOLD-FCTR-SEASON-CD        PIC X(01).                
COB305       10 WS-HOLD-FCTR-REV-AMT        PIC S9(9)V9(6) COMP-3 
COB305          VALUE 0.    
COB305       10 WS-HOLD-FCTR-CALC-UNITS        PIC S9(9)V COMP-3 
COB305          VALUE 0.        
             10 WS-HOLD-FCTR-RATE-VER         PIC X(1).                 
             10 WS-HOLD-FCTR-SEQ-NO           PIC 9(4).                 
                                                                        
       01 WS-TEMP-FCTR-DTL.                                             
          05 WS-TEMP-FCTR-DATA       OCCURS 200                         
                                     INDEXED BY WS-TMP-FCTR-INDX        
                                                WS-TMP-FCTR-INDX1.      
             10 WS-TEMP-FACTOR-ID             PIC X(9).                 
             10 WS-TEMP-FCTR-FROM-DT          PIC X(10).                
             10 WS-TEMP-FCTR-CMPNT-ID         PIC X(03).                
             10 WS-TEMP-FCTR-CNSMPTN-TYPE     PIC X(01).                
             10 WS-TEMP-FCTR-REG-TYPE         PIC X(01).                
             10 WS-TEMP-FCTR-TOU-CD           PIC 9(01).                
             10 WS-TEMP-FCTR-SEASON-CD        PIC X(01).                
COB305       10 WS-TEMP-FCTR-REV-AMT        PIC S9(9)V9(6) COMP-3 
COB305          VALUE 0.    
COB305       10 WS-TEMP-FCTR-CALC-UNITS        PIC S9(9)V COMP-3 
COB305          VALUE 0.        
COB305       10 WS-TEMP-FCTR-ADJ-UNITS        PIC S9(9)V COMP-3 VALUE 0.        
             10 WS-TEMP-FCTR-RATE-VER         PIC X(1).                 
             10 WS-TEMP-FCTR-SEQ-NO           PIC 9(4).                 
                                                                        
       01 WS-HOLD-CX-DATA-TEMP.                                         
          05 WS-HOLD-CX-DMND-DATA    OCCURS 0 TO 999                    
                                     DEPENDING ON WS-CX-MAX-ENTRY       
                                     INDEXED BY WS-HOLD-CX-INDX.        
             10 WS-HOLD-CX-USAGE-TYPE         PIC X(01).                
COB305       10 WS-HOLD-CX-DEMAND-UNITS        PIC S9(09)V COMP-3 
COB305          VALUE 0.       
             10 WS-HOLD-CX-MTR-REF-NO         PIC S9(04)  COMP.         
                                                                        
I01959 01 WS-CAPACITY-FCTR-TABLE.                                       
I01959    05 WS-CAPACITY-FCTR-DATA   OCCURS 0 TO 100                    
I01959                               DEPENDING ON WS-CF-COUNT           
I01959                               INDEXED BY WS-CF-INDX.             
I01959       10  WS-ALTERNATE-FUEL-CD-ARR   PIC X(01).                  
I01959       10  WS-CAP-FCTR-MONTH-ARR      PIC S9(4) USAGE COMP.       
I01959       10  WS-CAP-FCTR-START-DT-ARR   PIC X(10).                  
COB305       10 WS-CAPACITY-FACTOR-ARR        PIC S9(1)V9(6) 
COB305          USAGE COMP-3 VALUE 0.
COB305       10 WS-ON-PEAK-ALLOC-ARR        PIC S9(1)V9(6) USAGE COMP-3 
COB305          VALUE 0.
COB305       10 WS-OFF-PEAK-ALLOC-ARR        PIC S9(1)V9(6) 
COB305          USAGE COMP-3 VALUE 0.
                                                                        
       01 WS-SWITCHES.                                                  
          05 WS-PRORATION-FLAG             PIC X(01) VALUE 'N'.         
             88 PRORATED                             VALUE 'Y'.         
             88 NOT-PRORATED                         VALUE 'N'.         
                                                                        
          05 WS-BILL-TYPE-FLAG             PIC X(01) VALUE 'N'.         
             88 REGULAR-BILL                         VALUE 'Y'.         
             88 MANUAL-BILL                          VALUE 'N'.         
                                                                        
          05 WS-BILL-CALC-FLAG             PIC X(01) VALUE 'N'.         
             88 CALL-BILL-CALC                       VALUE 'Y'.         
             88 DO-NOT-CALL-BILL-CALC                VALUE 'N'.         
                                                                        
          05 WS-PROCESS-BG-FLAG            PIC X(01) VALUE 'N'.         
             88 PROCESS-BG                           VALUE 'Y'.         
             88 DO-NOT-PROCESS-BG                    VALUE 'N'.         
                                                                        
PRJ257    05 WS-FRAN-TAX-GENERATED         PIC X(01) VALUE 'N'.         
PRJ257       88 FRAN-TAX-GENERATED                   VALUE 'Y'.         
                                                                        
PRJ257    05 WS-MONTHLY-MIN                PIC X(01) VALUE 'N'.         
PRJ257       88 MONTHLY-MIN                          VALUE 'Y'.         
                                                                        
          05 WS-END-OF-BE22-SW             PIC X(01).                   
             88 END-OF-BE22                          VALUE 'Y'.         
                                                                        
          05 WS-ROW-FOUND-SW               PIC X(01).                   
             88 ROW-FOUND                            VALUE 'Y'.         
             88 ROW-NOT-FOUND                        VALUE 'N'.         
                                                                        
          05 WS-BEGIN-REC-SW               PIC X(01).                   
             88 WS-BEGIN-RECS-PROCESSED              VALUE 'Y'.         
             88 WS-BEGIN-REC-NOT-PROCESSED           VALUE 'N'.         
             88 WS-START-INPUT-DATA                  VALUE 'X'.         
                                                                        
          05 WS-RECORD-FOUND               PIC X(01) VALUE 'N'.         
             88 DATA-RECORD-FOUND                    VALUE 'Y'.         
             88 NO-DATA-RECORD-FOUND                 VALUE 'N'.         
                                                                        
          05 WS-FBE22-STATUS               PIC X(02).                   
             88 FCSBE22-SUCCESSFUL                   VALUE '00'.        
             88 END-OF-FCSBE22                       VALUE '10'.        
                                                                        
          05 WS-FCSCREVB-STATUS            PIC X(02).                   
             88 FCSCREVB-SUCCESSFUL                  VALUE '00'.        
             88 END-OF-FCSCREVB                      VALUE '10'.        
                                                                        
          05 WS-FCSCREVC-STATUS            PIC X(02).                   
             88 FCSCREVC-SUCCESSFUL                  VALUE '00'.        
             88 END-OF-FCSCREVC                      VALUE '10'.        
                                                                        
          05 WS-FCSCREVD-STATUS            PIC X(02).                   
             88 FCSCREVD-SUCCESSFUL                  VALUE '00'.        
             88 END-OF-FCSCREVD                      VALUE '10'.        
                                                                        
          05 WS-FCSCREVT-STATUS            PIC X(02).                   
             88 FCSCREVT-SUCCESSFUL                  VALUE '00'.        
             88 END-OF-FCSCREVT                      VALUE '10'.        
                                                                        
          05 WS-SKIP-ACCT-SW               PIC X(01) VALUE SPACE.       
             88 SKIP-ACCT                            VALUE 'Y'.         
                                                                        
          05 WS-CWS-TABLE-ID               PIC 9(04).                   
             88 WS-CWS10000-TABLE-ID                 VALUES             
                0300 1910 1920 1930 2100 2200 2300 6310 6450 6750 1940  
I01959          1900 2150.                                              
                                                                        
          05 WS-ELECTRIC-KWH-FL            PIC X(01).                   
             88 ELECT-KWH                            VALUE 'B'.         
          05 WS-ELECTRIC-KW-FL             PIC X(01).                   
             88 ELECT-DEMAND-KW                      VALUE 'J'.         
          05 WS-ELECTRIC-KVA-FL            PIC X(01).                   
             88 ELECT-DEMAND-KVA                     VALUE 'E'.         
                                                                        
I01959    05 WS-DER-RATE-PLAN-NO           PIC X(03).                   
I01959       88 DER-RATE-PLAN-NO                     VALUES             
I01959          'PB4' 'PB3' 'PB2' 'PB1' 'PBI'                           
I01959          'PT4' 'PT3' 'PT2' 'PT1' 'PTI'.                          
I01959    05 WS-DER-REC-RATE-PLAN          PIC X(03).                   
I01959       88 DER-REC-RATE-PLAN                    VALUES             
I01959          '1NE' '2NE' '3NE' '5NE' '6NE' '7NE' '8NE'               
I01959          '9NE' 'N11' 'N12' 'N13' 'N14' 'N16' 'N20'               
I01959          'N21' 'N22' 'N23' 'N24' 'N28' 'S21'.                    
I01959    05 WS-CALC-DER-RECOVERY          PIC X(01) VALUE SPACE.       
I01959       88 CALC-DER-RECOVERY                    VALUE 'Y'.         
I01959    05 WS-DER-RECOVERY-PROCESS       PIC X(01) VALUE SPACE.       
I01959       88 DER-RECOVERY-PROCESS                 VALUE 'Y'.         
I01959    05 WS-ESTIMATE-SOLAR-USAGE       PIC X(01) VALUE SPACE.       
I01959       88 ESTIMATE-SOLAR-USAGE                 VALUE 'Y'.         
I01959       88 DO-NOT-ESTIMATE-SOLAR-USAGE          VALUE 'N'.         
I01959    05 WS-ACCOUNT-ON-TOU-RATE        PIC X(01) VALUE SPACE.       
I01959       88 ACCOUNT-ON-TOU-RATE                  VALUE 'Y'.         
I01959       88 ACCOUNT-ON-NON-TOU-RATE              VALUE 'N'.         
                                                                        
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME                  PIC X(08) VALUE 'PCSCA177'.  
          05 WS-PGRMNAME                   PIC X(08) VALUE 'PCSCA177'.  
          05 WS-COMMON-DATE                PIC X(10) VALUE 'COMMONDATE'.
          05 SCSCA107                      PIC X(08) VALUE 'SCSCA107'.  
          05 SCSCA202                      PIC X(08) VALUE 'SCSCA202'.  
          05 WS-Y                          PIC X(01) VALUE 'Y'.         
          05 WS-N                          PIC X(01) VALUE 'N'.         
          05 WS-I                          PIC X(01) VALUE 'I'.         
A04359    05 WS-GA-MFG-SALES-TAX-XMT       PIC X(01) VALUE 'X'.         
I01959    05 WS-RESIDENTIAL-NM             PIC X(03) VALUE 'E98'.       
I01959    05 WS-SMALL-GENSV-NM             PIC X(03) VALUE 'E97'.       
I01959    05 WS-EXCESS-PRIOR-MTH           PIC X(02) VALUE 'EP'.        
I01959    05 WS-DELIVERED                  PIC X(02) VALUE 'DL'.        
I01959    05 WS-GENERATED                  PIC X(02) VALUE 'RV'.        
I01959    05 WS-BILLED                     PIC X(02) VALUE 'BI'.        
I01959    05 WS-COST-RECOVERY-FCTR         PIC X(09) VALUE 'DERCCRNEM'. 
I01959    05 WS-AVOIDED-COST-FCTR          PIC X(09) VALUE 'DERAVDNEM'. 
I01959    05 WS-INCREMENTAL-COST-FCTR      PIC X(09) VALUE 'DERINCNEM'. 
I01959    05 WS-DER-CALC-PBI-FCTR          PIC X(09) VALUE 'DERCALNEM'. 
I01959    05 WS-LONG-VOS-FCTR              PIC X(09) VALUE 'LONGVOS'.   
I01959    05 WS-SHORT-VOS-FCTR             PIC X(09) VALUE 'SHORTVOS'.  
I01959    05 WS-NM-EXCESS-FCTR             PIC X(09) VALUE 'NMEXCSCR'.  
I01959    05 WS-NON-TOU                    PIC S9(4) COMP VALUE +0.     
I01959    05 WS-ON-PEAK                    PIC S9(4) COMP VALUE +1.     
I01959    05 WS-OFF-PEAK                   PIC S9(4) COMP VALUE +2.     
I01959    05 WS-SHOULDER                   PIC S9(4) COMP VALUE +3.     
      *                                                                         
      ******************************************************************        
      *  FIOBE01 CONTAINS CWS10001 VARIABLES USED IN OTHER             *        
      ******************************************************************        
       COPY FIOBE01.                                                            
      *                                                                         
      ******************************************************************        
      *  FIOBE00 CONTAINS CWS10000 VARIABLES USED IN OTHER             *        
      ******************************************************************        
       COPY FIOBE00.                                                            
      *                                                                         
      ******************************************************************        
      *  FIOBE02 CONTAINS CWS10000 VARIABLES USED IN OTHER             *        
      ******************************************************************        
       COPY FIOBE02.                                                            
      *                                                                         
      ******************************************************************        
      *  FIOCA00 COPYBOOK TO GET JOB_PARM DATA.                        *        
      ******************************************************************        
       COPY FIOCA00.                                                            
      *                                                                         
      ******************************************************************        
      *  CWS00010  CONTAINS DB2 ABEND VARIABLES                        *        
      ******************************************************************        
       COPY CWS00010.                                                           
      *                                                                         
      ******************************************************************        
      *  CWS1000A & CWS1000B CONTAINS BE02 RECORD LAYOUTS              *        
      ******************************************************************        
       COPY CWS1000A.                                                           
       COPY CWS1000B.                                                           
      *COPY CWS1001A.                                                           
       COPY CWS0022B.                                                           
P00496*COPY CWS1001B.                                                           
      *                                                                         
      ******************************************************************        
      *  CWS10009 CONTAINS BE00 AR RECORDS AND MORE                    *        
      ******************************************************************        
       COPY CWS10009.                                                           
      *                                                                         
       COPY CWS10001.                                                           
      *                                                                         
      ******************************************************************        
      *   CWS10005 CONTAINS INDEX/TABLE ERROR MESSAGES BE02            *        
      ******************************************************************        
       COPY CWS10005.                                                           
      *                                                                         
      ******************************************************************        
      *   CWS10006 CONTAINS INDEX/TABLE ERROR MESSAGES BE13            *        
      ******************************************************************        
       COPY CWS10006.                                                           
      *                                                                         
      ******************************************************************        
      *CWS0024B                                                        *        
      ******************************************************************        
       COPY CWS0024B.                                                           
      *                                                                         
      ******************************************************************        
      *  CWS00038 JOB PARM ROUTINE                                     *        
      ******************************************************************        
       COPY CWS00038.                                                           
      *                                                                         
      ******************************************************************        
      *  CWS00039 JOB PARM ROUTINE                                     *        
      ******************************************************************        
       COPY CWS00039.                                                           
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE FOR CPD09900 CONTAINS ABEND WS VARIABLES       *        
      ******************************************************************        
       COPY CWS09900.                                                           
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE FOR INPUT AND OUTPUT VARIABLES FOR SCSCA202    *        
      ******************************************************************        
       COPY CWS00202.                                                           
      *                                                                         
      ******************************************************************        
      * ERROR MESSAGE COPYBOOK.                                        *        
      ******************************************************************        
       COPY CWS00303.                                                           
      *                                                                         
       COPY FIOJC01.                                                            
NONCAL*                                                                         
NONCAL COPY CWS00050.                                                           
NONCAL*                                                                         
NONCAL COPY CWSCB108.                                                           
      *                                                                         
       01  WS-END                          PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSCA177 ENDS HERE  '.            
      *                                                                         
      ******************************************************************        
      * DB2 INCLUDES.                                                  *        
      ******************************************************************        
      *    SQLCA                                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      ******************************************************************        
      *  CSS_ACCOUNT       - AT                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_ACCT_RTPK_AGR - DF                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBACCTRG                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_BILL_WINDOW   - BN                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBBILWDW                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_BILL_CALC_DET  - BZ                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBLCLDT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_BILLING_DET    - BG                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_BILLING_HDR    - BI                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_CODE_VALUE    - UV                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBCDVALU                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_CUST_PLAN     - CP                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBCSTPLN                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_DELINQUENCY   - C8                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBDELQ                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_JOB_PARM      - G6                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_MNICPLTY_CNTY  - F4                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNCCTY                                                  
           END-EXEC.                                                            
      *                                                                         
T03014******************************************************************        
T03014*  CSS_RATE_COMP_DEF  - J1                                       *        
T03014******************************************************************        
T03014*                                                                         
T03014     EXEC SQL                                                             
T03014        INCLUDE TBRTCDEF                                                  
T03014     END-EXEC.                                                            
T03014*                                                                         
      ******************************************************************        
      *  CSS_PRTY_SVC_CAT   - Z4                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBSVCCAT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_RATE_PLAN_DESC - RD                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBRTDESC                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CRM_RT_PKG_OPTION - FI                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBRTPKGO                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_RATE_COMPONENT - N6                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBRTCPNT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_REV_CLS_RATE   - Q8                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRVCLS                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_RATE_CREATOR   - RT                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBRTCRTR                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_SPCL_FCTR  - SF                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBSPLFTR                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_TAX_CNTL       - TC                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBTXCNTL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_TAX_EXMPT_CODE - F1                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBTXMPCD                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CRM_TIER_ACCT_TYPE - TT                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBTIACTP                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_UTIL_ENVRNMT  - UT                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBUTLENV                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  REV_BILLING_DET   - RV                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBREVBLD                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  REV_BILL_COMP_ADJ - RB                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBREVCOM                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  REV_BILL_BLOCK    - R7                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBREVBLK                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  REV_BILL_TAX      - R9                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBREVTAX                                                  
           END-EXEC.                                                            
      *                                                                         
I01959******************************************************************        
I01959*  CSS_PREM_DER_DET - 6B                                         *        
I01959******************************************************************        
I01959     EXEC SQL                                                             
I01959         INCLUDE TBPRDERD                                                 
I01959     END-EXEC.                                                            
      *                                                                         
ACT004******************************************************************        
ACT004*  CSS_ACCT_MKT_TIER - DD                                        *        
ACT004******************************************************************        
ACT004*                                                                         
ACT004     EXEC SQL                                                             
ACT004        INCLUDE TBMKTIER                                                  
ACT004     END-EXEC.                                                            
      *                                                                         
NONCAL******************************************************************        
NONCAL*  CSS_BILL_MANUAL   - NG                                        *        
NONCAL******************************************************************        
NONCAL*                                                                         
NONCAL     EXEC SQL                                                             
NONCAL        INCLUDE TBBILMNL                                                  
NONCAL     END-EXEC.                                                            
NONCAL*                                                                         
NONCAL******************************************************************        
NONCAL*  CSS_BILL_MAN_DET  - NU                                        *        
NONCAL******************************************************************        
NONCAL*                                                                         
NONCAL     EXEC SQL                                                             
NONCAL        INCLUDE TBBILMDE                                                  
NONCAL     END-EXEC.                                                            
NONCAL*                                                                         
NONCAL******************************************************************00165600
NONCAL* WORKING STORAGE COPYBOOK REQUIRED FOR CPDCB107                 *00165700
NONCAL******************************************************************00165800
NONCAL     EXEC SQL                                                             
NONCAL        INCLUDE CWSCB107                                                  
NONCAL     END-EXEC.                                                            
      *                                                                         
      * DB2 CURSORS.                                                            
      *------------*                                                            
      *                                                                         
      ******************************************************************        
      *   CURSOR TO SELECT THE DATA FROM CSS_SPCL_FCTR                 *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE SPCL_FCTR_CSR CURSOR                             
                  WITH ROWSET POSITIONING FOR                           
                SELECT FACTOR_ID                                        
                      ,PRORATE_FL                                       
                      ,REV_INTERFACE_FL                                 
                      ,SPCL_GROUP_CD                                    
                  FROM CSS_SPCL_FCTR WITH(READUNCOMMITTED)                      
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE SPCL_FCTR_CSR CURSOR                                     
MFA-TR*           WITH ROWSET POSITIONING FOR                                   
MFA-TR*         SELECT FACTOR_ID                                                
MFA-TR*               ,PRORATE_FL                                               
MFA-TR*               ,REV_INTERFACE_FL                                         
MFA-TR*               ,SPCL_GROUP_CD                                            
MFA-TR*           FROM CSS_SPCL_FCTR                                            
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*        QUERYNO 7160                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   CURSOR TO SELECT THE DATA FROM CSS_RATE_PLAN_DESC            *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE RATE_PL_DESC_CSR CURSOR                          
                  WITH ROWSET POSITIONING FOR                           
                SELECT RATE_PLAN_NO                                     
                      ,CODE_UTIL_TYPE                                   
                      ,RATE_CALC_TYPE_CD                                
                      ,RATE_DEPT_CD                                     
                      ,COMPANY_NO                                       
                      ,UNMTR_PROV_FL                                    
PRJ257                ,REV_CUST_COUNT_CD                                
                  FROM CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)              
                  WHERE RD.RATE_PLAN_NO IN (                            
                            SELECT RC.RATE_PLAN_NO                      
                            FROM CSS_RATE_CREATOR RC
                           WITH(READUNCOMMITTED)                    
                            WHERE RC.RATE_PLAN_NO = RD.RATE_PLAN_NO     
                            AND RC.CODE_STATUS <> 'Z'                   
                            AND RC.VERSION_NO_CNTRL = (                 
                                SELECT MAX(VERSION_NO_CNTRL)            
                                FROM CSS_RATE_CREATOR R1
                           WITH(READUNCOMMITTED)                
                                WHERE R1.RATE_PLAN_NO = RC.RATE_PLAN_NO 
                                ))                                      
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE RATE_PL_DESC_CSR CURSOR                                  
MFA-TR*           WITH ROWSET POSITIONING FOR                                   
MFA-TR*         SELECT RATE_PLAN_NO                                             
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,RATE_CALC_TYPE_CD                                        
MFA-TR*               ,RATE_DEPT_CD                                             
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,UNMTR_PROV_FL                                            
MFA-TR*               ,REV_CUST_COUNT_CD                                        
MFA-TR*           FROM CSS_RATE_PLAN_DESC RD                                    
MFA-TR*           WHERE RD.RATE_PLAN_NO IN (                                    
MFA-TR*                     SELECT RC.RATE_PLAN_NO                              
MFA-TR*                     FROM CSS_RATE_CREATOR RC                            
MFA-TR*                     WHERE RC.RATE_PLAN_NO = RD.RATE_PLAN_NO             
MFA-TR*                     AND RC.CODE_STATUS <> 'Z'                           
MFA-TR*                     AND RC.VERSION_NO_CNTRL = (                         
MFA-TR*                         SELECT MAX(VERSION_NO_CNTRL)                    
MFA-TR*                         FROM CSS_RATE_CREATOR R1                        
MFA-TR*                         WHERE R1.RATE_PLAN_NO = RC.RATE_PLAN_NO         
MFA-TR*                         ))                                              
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   CURSOR TO SELECT THE DATA FROM CSS_RATE_COMPONENT            *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE RATE_COMP_CSR CURSOR                             
                  WITH ROWSET POSITIONING FOR                           
                SELECT RATE_CMPNT_ID                                    
                      ,REVENUE_CNSMPTN_FL                               
                      ,REVENUE_AMOUNT_FL                                
                  FROM CSS_RATE_COMPONENT WITH(READUNCOMMITTED)                 
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE RATE_COMP_CSR CURSOR                                     
MFA-TR*           WITH ROWSET POSITIONING FOR                                   
MFA-TR*         SELECT RATE_CMPNT_ID                                            
MFA-TR*               ,REVENUE_CNSMPTN_FL                                       
MFA-TR*               ,REVENUE_AMOUNT_FL                                        
MFA-TR*           FROM CSS_RATE_COMPONENT                                       
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*        QUERYNO 7130                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   CURSOR TO SELECT THE DATA FROM CRM_TIER_ACCT_TYPE            *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE SEB_REV_COMP_CSR CURSOR                          
                  WITH ROWSET POSITIONING FOR                           
                SELECT REV_COMPANY_NO                                   
                      ,COMPANY_NO                                       
                      ,TIER_ACCT_TYPE_CD                                
                  FROM CRM_TIER_ACCT_TYPE WITH(READUNCOMMITTED)                 
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE SEB_REV_COMP_CSR CURSOR                                  
MFA-TR*           WITH ROWSET POSITIONING FOR                                   
MFA-TR*         SELECT REV_COMPANY_NO                                           
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,TIER_ACCT_TYPE_CD                                        
MFA-TR*           FROM CRM_TIER_ACCT_TYPE                                       
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*        QUERYNO 7310                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
I01959******************************************************************        
I01959*   Capacity factor for the Renewable energy source.             *        
I01959******************************************************************        
I01959     EXEC SQL                                                     
I01959         DECLARE CAPACITY_FCTR CURSOR                             
I01959            WITH ROWSET POSITIONING FOR                           
I01959          SELECT ALTERNATE_FUEL_CD                                
I01959                ,CAP_FCTR_MONTH                                   
I01959                ,CAP_FCTR_START_DT                                
I01959                ,CAPACITY_FACTOR                                  
I01959                ,ON_PEAK_ALLOC_PCT                                
I01959                ,OFF_PEAK_ALLOC_PCT                               
I01959            FROM CSS_CAPACITY_FCTR WITH(READUNCOMMITTED)                  
I01959           WHERE ALTERNATE_FUEL_CD = 'S'                          
I01959           ORDER BY CAP_FCTR_START_DT DESC                        
I01959                   ,CAP_FCTR_MONTH ASC                            
'01959             FOR READ ONLY                                
I01959                                                      
I01959     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE CAPACITY_FCTR CURSOR                                     
MFA-TR*           WITH ROWSET POSITIONING FOR                                   
MFA-TR*         SELECT ALTERNATE_FUEL_CD                                        
MFA-TR*               ,CAP_FCTR_MONTH                                           
MFA-TR*               ,CAP_FCTR_START_DT                                        
MFA-TR*               ,CAPACITY_FACTOR                                          
MFA-TR*               ,ON_PEAK_ALLOC_PCT                                        
MFA-TR*               ,OFF_PEAK_ALLOC_PCT                                       
MFA-TR*           FROM CSS_CAPACITY_FCTR                                        
MFA-TR*          WHERE ALTERNATE_FUEL_CD = 'S'                                  
MFA-TR*          ORDER BY CAP_FCTR_START_DT DESC                                
MFA-TR*                  ,CAP_FCTR_MONTH ASC                                    
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*        QUERYNO 7600                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   CURSOR TO SELECT THE DATA FROM CSS_PRTY_SVC_CAT              *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE PRTY_SVC_CSR CURSOR                              
                  WITH ROWSET POSITIONING FOR                           
                SELECT PRTY_SVC_CAT_CD                                  
                      ,COMPANY_NO                                       
                      ,CODE_CURTAIL_PRTY                                
                  FROM CSS_PRTY_SVC_CAT WITH(READUNCOMMITTED)                   
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE PRTY_SVC_CSR CURSOR                                      
MFA-TR*           WITH ROWSET POSITIONING FOR                                   
MFA-TR*         SELECT PRTY_SVC_CAT_CD                                          
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,CODE_CURTAIL_PRTY                                        
MFA-TR*           FROM CSS_PRTY_SVC_CAT                                         
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*        QUERYNO 7340                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR TO SELECT THE DATA FROM CSS_CODE_VALUE                *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE CODE_VALUE_CSR CURSOR FOR                        
                SELECT COLUMN_NA                                        
                  FROM CSS_CODE_VALUE WITH(READUNCOMMITTED)                     
               WHERE TABLE_NA   = 'REV RPT FACTOR'                      
                 AND PROGRAM_ID = :UV-PROGRAM-ID                        
                 AND CODE_VALUE = 'EXCLUDE'                             
                 AND COMPANY_NO = '01'                                  
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE CODE_VALUE_CSR CURSOR FOR                                
MFA-TR*         SELECT COLUMN_NA                                                
MFA-TR*           FROM CSS_CODE_VALUE                                           
MFA-TR*        WHERE TABLE_NA   = 'REV RPT FACTOR'                              
MFA-TR*          AND PROGRAM_ID = :UV-PROGRAM-ID                                
MFA-TR*          AND CODE_VALUE = 'EXCLUDE'                                     
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*      QUERYNO 7380                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR TO SELECT THE DATA FROM REV_BILL_COMP_ADJ             *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE REV_ADJ_CSR CURSOR FOR                           
                SELECT REPLACE(REPLACE(CONVERT(CHAR(26), BILL_UNIQUE_TS
           , 121), ' ', '-'), ':', '.') BILL_UNIQUE_TS,                        
                       BILL_COMP_SEQ_NO,                                
                       CMPNT_ID_CD,                                     
                       INSTR_USE_TYPE_CD,                               
                       CONSUMPT_TYPE_CD,                                
                       CODE_TIME_PERIOD,                                
                       CODE_SEASON,                                     
                       RT_VERS_FROM_DT,                                 
                       RT_VERS_PRO_CD,                                  
                       FACTOR_ID,                                       
                       FACTOR_BLOCK_NO,                                 
                       RT_FCT_FROM_DT,                                  
                       RT_FCT_PRO_CD,                                   
                       READ_UNITS,                                      
                       BILL_USAGE_UNITS,                                
                       BILL_DEMAND_UNITS,                               
                       CALC_UNITS,                                      
                       FACTOR,                                          
                       BILLED_AMT,                                      
                       CODE_STAT_TAX_XMT,                               
                       CODE_CITY_TAX_XMT,                               
                       CODE_OTHR_TAX_XMT,                               
                       UTILITY_REV_CD,                                  
                       COMP_ADJ_CD,                                     
                       GL_ACCT_NO,                                      
                       SPCL_GROUP_CD,                                   
                       ACCOUNT_NO                                       
                  FROM REV_BILL_COMP_ADJ WITH(READUNCOMMITTED)                  
               WHERE BILL_UNIQUE_TS = CIS.CHAR2TIMESTAMP(
                                                     :RV-BILL-UNIQUE-TS
              )                
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE REV_ADJ_CSR CURSOR FOR                                   
MFA-TR*         SELECT BILL_UNIQUE_TS,                                          
MFA-TR*                BILL_COMP_SEQ_NO,                                        
MFA-TR*                CMPNT_ID_CD,                                             
MFA-TR*                INSTR_USE_TYPE_CD,                                       
MFA-TR*                CONSUMPT_TYPE_CD,                                        
MFA-TR*                CODE_TIME_PERIOD,                                        
MFA-TR*                CODE_SEASON,                                             
MFA-TR*                RT_VERS_FROM_DT,                                         
MFA-TR*                RT_VERS_PRO_CD,                                          
MFA-TR*                FACTOR_ID,                                               
MFA-TR*                FACTOR_BLOCK_NO,                                         
MFA-TR*                RT_FCT_FROM_DT,                                          
MFA-TR*                RT_FCT_PRO_CD,                                           
MFA-TR*                READ_UNITS,                                              
MFA-TR*                BILL_USAGE_UNITS,                                        
MFA-TR*                BILL_DEMAND_UNITS,                                       
MFA-TR*                CALC_UNITS,                                              
MFA-TR*                FACTOR,                                                  
MFA-TR*                BILLED_AMT,                                              
MFA-TR*                CODE_STAT_TAX_XMT,                                       
MFA-TR*                CODE_CITY_TAX_XMT,                                       
MFA-TR*                CODE_OTHR_TAX_XMT,                                       
MFA-TR*                UTILITY_REV_CD,                                          
MFA-TR*                COMP_ADJ_CD,                                             
MFA-TR*                GL_ACCT_NO,                                              
MFA-TR*                SPCL_GROUP_CD,                                           
MFA-TR*                ACCOUNT_NO                                               
MFA-TR*           FROM REV_BILL_COMP_ADJ                                        
MFA-TR*        WHERE BILL_UNIQUE_TS = :RV-BILL-UNIQUE-TS                        
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*      QUERYNO 7410                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR TO SELECT THE DATA FROM REV_BILL_BLOCK                *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE REV_BLK_CSR CURSOR FOR                           
                SELECT REPLACE(REPLACE(CONVERT(CHAR(26), BILL_UNIQUE_TS
           , 121), ' ', '-'), ':', '.') BILL_UNIQUE_TS,                        
                       BILL_COMP_SEQ_NO,                                
                       BLK_NO_RT_ITM_CD,                                
                       BLK_USE_OR_SVCS,                                 
                       BLK_BILL_USE_UNITS,                              
                       BLK_BILL_DEM_UNITS,                              
                       BLK_BILL_LT_POLES,                               
                       CUST_PER_SERVICE,                                
                       PRICE_TYPE_CD,                                   
                       SCHED_PRICE_AM,                                  
                       UNIT_PRICE_AM,                                   
                       BLK_REV_AMT,                                     
                       NET_UNIT_SEL_RSN,                                
                       KW_MDQ_DT,                                       
                       KVA_DT,                                          
                       CONTRACT_DEMAND,                                 
                       READ_KW_MDQ_UNITS,                               
                       READ_KVA_UNITS,                                  
                       POWER_FACTOR,                                    
                       LOAD_FACTOR,                                     
                       RT_VERS_PRO_PCT,                                 
                       ACCOUNT_NO,                                      
                       RATE_ITEM_CODE                                   
                  FROM REV_BILL_BLOCK WITH(READUNCOMMITTED)                     
               WHERE BILL_UNIQUE_TS = CIS.CHAR2TIMESTAMP(
                                                     :RV-BILL-UNIQUE-TS
              )                
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE REV_BLK_CSR CURSOR FOR                                   
MFA-TR*         SELECT BILL_UNIQUE_TS,                                          
MFA-TR*                BILL_COMP_SEQ_NO,                                        
MFA-TR*                BLK_NO_RT_ITM_CD,                                        
MFA-TR*                BLK_USE_OR_SVCS,                                         
MFA-TR*                BLK_BILL_USE_UNITS,                                      
MFA-TR*                BLK_BILL_DEM_UNITS,                                      
MFA-TR*                BLK_BILL_LT_POLES,                                       
MFA-TR*                CUST_PER_SERVICE,                                        
MFA-TR*                PRICE_TYPE_CD,                                           
MFA-TR*                SCHED_PRICE_AM,                                          
MFA-TR*                UNIT_PRICE_AM,                                           
MFA-TR*                BLK_REV_AMT,                                             
MFA-TR*                NET_UNIT_SEL_RSN,                                        
MFA-TR*                KW_MDQ_DT,                                               
MFA-TR*                KVA_DT,                                                  
MFA-TR*                CONTRACT_DEMAND,                                         
MFA-TR*                READ_KW_MDQ_UNITS,                                       
MFA-TR*                READ_KVA_UNITS,                                          
MFA-TR*                POWER_FACTOR,                                            
MFA-TR*                LOAD_FACTOR,                                             
MFA-TR*                RT_VERS_PRO_PCT,                                         
MFA-TR*                ACCOUNT_NO,                                              
MFA-TR*                RATE_ITEM_CODE                                           
MFA-TR*           FROM REV_BILL_BLOCK                                           
MFA-TR*        WHERE BILL_UNIQUE_TS = :RV-BILL-UNIQUE-TS                        
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*      QUERYNO 7440                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR TO SELECT THE DATA FROM REV_BILL_TAX                  *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE REV_TAX_CSR CURSOR FOR                           
                SELECT REPLACE(REPLACE(CONVERT(CHAR(26), BILL_UNIQUE_TS
           , 121), ' ', '-'), ':', '.') BILL_UNIQUE_TS,                        
                       TAX_TYPE,                                        
                       TAX_CNTRL_NO,                                    
                       TAX_FROM_DT,                                     
                       FACTOR_ID,                                       
                       TAX_GL_ACCT_NO,                                  
                       TAX_AMT,                                         
                       ACCOUNT_NO                                       
                  FROM REV_BILL_TAX WITH(READUNCOMMITTED)                       
               WHERE BILL_UNIQUE_TS = CIS.CHAR2TIMESTAMP(
                                                     :RV-BILL-UNIQUE-TS
              )                
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE REV_TAX_CSR CURSOR FOR                                   
MFA-TR*         SELECT BILL_UNIQUE_TS,                                          
MFA-TR*                TAX_TYPE,                                                
MFA-TR*                TAX_CNTRL_NO,                                            
MFA-TR*                TAX_FROM_DT,                                             
MFA-TR*                FACTOR_ID,                                               
MFA-TR*                TAX_GL_ACCT_NO,                                          
MFA-TR*                TAX_AMT,                                                 
MFA-TR*                ACCOUNT_NO                                               
MFA-TR*           FROM REV_BILL_TAX                                             
MFA-TR*        WHERE BILL_UNIQUE_TS = :RV-BILL-UNIQUE-TS                        
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*      QUERYNO 7470                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       01  WS-END                          PIC X(40)      VALUE         
                       'WORKING STORAGE FOR PCSCA177 ENDS HERE  '.      
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       01  PARMIN.                                                      
           05  PARMLENGTH                  PIC S9(04) COMP.             
           05  PARM-COMMON-DATE            PIC X(10).                   
                                                                        
       PROCEDURE DIVISION USING PARMIN.                                 
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      * CONTROLS THE MAIN PATH OF THE PROGRAM                          *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM  0100-INITIALIZATION         THRU  0100-EXIT.        
           PERFORM  1000-PROCESS-INPUT          THRU  1000-EXIT.        
           PERFORM  9000-TERMINATE              THRU  9000-EXIT.        
           DISPLAY '** PCSCA177 PROCESSING COMPLETED SUCCESSFULLY **'.  
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZATION                                            *        
      * OPEN OUTPUT FILE                                               *        
      ******************************************************************        
       0100-INITIALIZATION.                                             
                                                                        
           INITIALIZE                           WS-MISC-HOST-VARIABLES  
                                                WS-EQUIP-ID-TABLE       
                                                WS-CODE-VALUE-TABLE     
                                                DCLCSS-CODE-VALUE.      
           IF PARMLENGTH > 0                                            
              MOVE PARM-COMMON-DATE             TO WS-INPUT-DATE        
               DISPLAY '** PCSCA177 PROCESSING MESSAGE  **'             
               DISPLAY '** JCL OVERRIDE DATE BEING USED **'             
               DISPLAY '** DATE = ' WS-INPUT-DATE                       
               DISPLAY '**  PROCESSING CONTINUING       **'             
           ELSE                                                         
              PERFORM 0110-GET-JOB-PARM-DETAILS THRU 0110-EXIT          
           END-IF.                                                      
                                                                        
      * OPEN THE INPUT FILE BE22 AND OTHER O/P FILES                            
                                                                        
           PERFORM 0120-OPEN-FILES              THRU 0120-EXIT.         
                                                                        
      * TO IDENTIFY THE DATA BASE                                               
           MOVE ZERO                            TO LS-DATABASE.         
           MOVE '01'                            TO C8-COMPANY-NO.       
           MOVE 'DATABASE'                      TO C8-DELINQ-CD.        
           PERFORM 7000-SELECT-DELINQ-VALUE     THRU 7000-EXIT.         
           MOVE C8-DELINQ-VALUE                 TO LS-DATABASE.         
                                                                        
      * LOAD RATE PLAN DESC DATA TO AN INTERNAL TABLE                           
           PERFORM 0300-LOAD-RATE-PLAN-DESC     THRU 0300-EXIT.         
                                                                        
      * LOAD RATE COMPONENT DATA TO AN INTERNAL TABLE                           
           PERFORM 0400-LOAD-RATE-COMPONENT     THRU 0400-EXIT.         
                                                                        
      * LOAD SPCL FACTOR DATA TO AN INTERNAL TABLE                              
           PERFORM 0600-LOAD-SPCL-FCTR-DATA     THRU 0600-EXIT.         
                                                                        
      * LOAD SERVICE CATEGORY DATA TO AN INTERNAL TABLE                         
           PERFORM 0750-LOAD-PRTY-SVC-CATEGORY  THRU 0750-EXIT.         
                                                                        
           IF CSR-DATABASE                                              
              PERFORM 0780-LOAD-CAPACITY-FACTOR THRU 0780-EXIT          
           END-IF                                                       
                                                                        
      * LOAD CRM TIER ACCT TYPE TABLE TO AN INTERNAL TABLE                      
           IF SEB-DATABASE                                              
              PERFORM 0700-LOAD-SEB-REV-COMPANY THRU 0700-EXIT          
           ELSE                                                         
      * LOAD EQUIP ID CHANGE DATA                                               
              MOVE PROGRAM-NAME                 TO UV-PROGRAM-ID        
              MOVE 'NEW'                        TO UV-CODE-VALUE-TEXT   
              MOVE +3                           TO UV-CODE-VALUE-LEN    
              PERFORM 7370-GET-EQUIP-ID-CHG-DATA                        
                                                THRU 7370-EXIT          
              MOVE UV-CODE-LONG-DESC-TEXT(1:UV-CODE-LONG-DESC-LEN)      
                                                TO WS-NEW-EQUIP-ID-DATA 
                                                                        
              MOVE 'CURRENT'                    TO UV-CODE-VALUE-TEXT   
              MOVE +7                           TO UV-CODE-VALUE-LEN    
              PERFORM 7370-GET-EQUIP-ID-CHG-DATA                        
                                                THRU 7370-EXIT          
              MOVE UV-CODE-LONG-DESC-TEXT(1:UV-CODE-LONG-DESC-LEN)      
                                                TO WS-OLD-EQUIP-ID-DATA 
              PERFORM 0775-LOAD-CODE-VALUE-DATA THRU 0775-EXIT          
                                                                        
           END-IF.                                                      
                                                                        
                                                                        
           MOVE SPACES                          TO WS-PREV-TIMESTAMP.   
           PERFORM 7050-GET-CURR-TIMESTAMP      THRU 7050-EXIT.         
           MOVE WS-CURRENT-TIMESTAMP            TO WS-PREV-TIMESTAMP.   
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0110-GET-JOB-PARM-DETAILS.                                     *        
      *    1. SELECT RUN-DATE                                          *        
      *    2. SELECT REVENUE-MONTH                                     *        
      ******************************************************************        
       0110-GET-JOB-PARM-DETAILS.                                       
                                                                        
           PERFORM 6251-GET-FJC01-DATE          THRU 6251-EXIT.         
                                                                        
           IF COMMON-DATE-NEEDED                                        
               PERFORM 6240-GET-FCA00-COMMON-DATE                       
                                                THRU 6240-EXIT          
               MOVE WS-FCA00-COMMON-DATE        TO WS-INPUT-DATE        
               DISPLAY '** PCSCA177 PROCESSING MESSAGE **'              
               DISPLAY '** COMMON DATE BEING USED      **'              
               DISPLAY '** DATE = ' WS-INPUT-DATE                       
               DISPLAY '**  PROCESSING CONTINUING      **'              
           END-IF.                                                      
                                                                        
           MOVE WS-INPUT-DATE                   TO WS-RUN-DATE.         
                                                                        
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0120-OPEN-FILES.                                               *        
      * OPEN INPUT FILE TO BEGIN PROCESSING.                           *        
      ******************************************************************        
       0120-OPEN-FILES.                                                 
                                                                        
           OPEN INPUT FCSBE22-FILE.                                     
           IF FCSBE22-SUCCESSFUL                                        
              PERFORM 0500-PROCESS-BEGIN-REC    THRU  0500-EXIT         
                UNTIL E-FBE22-KEY-BREC NOT EQUAL LOW-VALUES             
           ELSE                                                         
              DISPLAY '********** PCSCA177 ABORT **************'        
              DISPLAY '*       0120-OPEN-FILES                *'        
              DISPLAY '*    ERROR OPENING FCSBE22 FILE        *'        
              DISPLAY '* FILE STATUS    : ' WS-FBE22-STATUS             
              DISPLAY '*      PROCESSING TERMINATED           *'        
              DISPLAY '********** PCSCA177 ABORT **************'        
              PERFORM 9900-ABEND                THRU  9900-EXIT         
           END-IF                                                       
                                                                        
           OPEN OUTPUT FCSCREVB-FILE.                                   
           IF NOT FCSCREVB-SUCCESSFUL                                   
               DISPLAY '********** PCSCA177 ABORT  ************'        
               DISPLAY '**  0120-OPEN-FILES                   *'        
               DISPLAY '**  ERROR OPENING FCSCREVB            *'        
               DISPLAY '**  FILE STATUS = ' WS-FCSCREVB-STATUS          
               DISPLAY '********** PCSCA177 ABORT  ************'        
               PERFORM 9900-ABEND     THRU 9900-EXIT                    
           END-IF                                                       
                                                                        
           OPEN OUTPUT FCSCREVC-FILE.                                   
           IF NOT FCSCREVC-SUCCESSFUL                                   
               DISPLAY '********** PCSCA177 ABORT  ************'        
               DISPLAY '**  0120-OPEN-FILES                   *'        
               DISPLAY '**  ERROR OPENING FCSCREVC            *'        
               DISPLAY '**  FILE STATUS = ' WS-FCSCREVC-STATUS          
               DISPLAY '********** PCSCA177 ABORT  ************'        
               PERFORM 9900-ABEND     THRU 9900-EXIT                    
           END-IF                                                       
                                                                        
           OPEN OUTPUT FCSCREVD-FILE.                                   
           IF NOT FCSCREVD-SUCCESSFUL                                   
               DISPLAY '********** PCSCA177 ABORT  ************'        
               DISPLAY '**  0120-OPEN-FILES                   *'        
               DISPLAY '**  ERROR OPENING FCSCREVD            *'        
               DISPLAY '**  FILE STATUS = ' WS-FCSCREVD-STATUS          
               DISPLAY '********** PCSCA177 ABORT  ************'        
               PERFORM 9900-ABEND     THRU 9900-EXIT                    
           END-IF                                                       
                                                                        
           OPEN OUTPUT FCSCREVT-FILE.                                   
           IF NOT FCSCREVT-SUCCESSFUL                                   
               DISPLAY '********** PCSCA177 ABORT  ************'        
               DISPLAY '**  0120-OPEN-FILES                   *'        
               DISPLAY '**  ERROR OPENING FCSCREVT            *'        
               DISPLAY '**  FILE STATUS = ' WS-FCSCREVT-STATUS          
               DISPLAY '********** PCSCA177 ABORT  ************'        
               PERFORM 9900-ABEND     THRU 9900-EXIT                    
           END-IF.                                                      
                                                                        
       0120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0300-LOAD-RATE-PLAN-DESC                                       *        
      * PROCESS FOR LOADING RATE PLAN DESC                             *        
      ******************************************************************        
       0300-LOAD-RATE-PLAN-DESC.                                        
                                                                        
           MOVE 1                               TO WS-INDEX             
           MOVE 0                               TO WS-ORDER-ROW-COUNT   
           SET  WS-RD-INDX                      TO 1                    
                                                                        
           PERFORM 7100-OPEN-RATE-PL-DESC-CSR   THRU 7100-EXIT.         
           PERFORM 7110-FETCH-RATE-PL-DESC-CSR  THRU 7110-EXIT.         
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 0310-LOAD-RATE-PLAN-DESC-TBL                      
                                                THRU 0310-EXIT          
                  UNTIL WS-INDEX > WS-ORDER-ROW-COUNT                   
                  OR WS-RD-RATE-PLAN-NO(WS-INDEX) = SPACES              
                                                                        
              MOVE 1             TO WS-INDEX                            
                                                                        
              INITIALIZE WS-MISC-HOST-VARIABLES                         
                                                                        
              PERFORM 7110-FETCH-RATE-PL-DESC-CSR                       
                                                THRU 7110-EXIT          
           END-PERFORM.                                                 
                                                                        
      * IF NOT-FOUND OCCURS WHEN THERE IS A SUBSET ROW                          
           IF SQLERRD(3) > 0                                            
              PERFORM 0310-LOAD-RATE-PLAN-DESC-TBL                      
                                                THRU 0310-EXIT          
                  UNTIL WS-INDEX > WS-ORDER-ROW-COUNT                   
                  OR WS-RD-RATE-PLAN-NO(WS-INDEX) = SPACES              
           END-IF                                                       
                                                                        
           PERFORM 7120-CLOSE-RATE-PL-DESC-CSR  THRU 7120-EXIT.         
                                                                        
       0300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0310-LOAD-RATE-PLAN-DESC-TBL.                                  *        
      * LOAD THE RATE PLAN DESC ARRAY                                  *        
      ******************************************************************        
       0310-LOAD-RATE-PLAN-DESC-TBL.                                    
      *                                                                         
           MOVE WS-RD-RATE-PLAN-NO(WS-INDEX)      TO                    
                               WS-RD-RATE-PLAN-NO-ARR(WS-RD-INDX)       
           MOVE WS-RD-CODE-UTIL-TYPE(WS-INDEX)    TO                    
                               WS-RD-CODE-UTIL-TYPE-ARR(WS-RD-INDX)     
           MOVE WS-RD-RATE-CALC-TYPE-CD(WS-INDEX) TO                    
                               WS-RD-RATE-CALC-TYPE-CD-ARR(WS-RD-INDX)  
           MOVE WS-RD-RATE-DEPT-CODE(WS-INDEX)    TO                    
                               WS-RD-RATE-DEPT-CODE-ARR(WS-RD-INDX)     
           MOVE WS-RD-COMPANY-NO(WS-INDEX)        TO                    
                               WS-RD-COMPANY-NO-ARR(WS-RD-INDX)         
           MOVE WS-RD-UNMTR-PROV-FL(WS-INDEX)     TO                    
                               WS-RD-UNMTR-PROV-FL-ARR(WS-RD-INDX)      
PRJ257     MOVE WS-RD-REV-CUST-COUNT-CD(WS-INDEX)     TO                
PRJ257                         WS-RD-REV-CUST-CNT-CD-ARR(WS-RD-INDX)    
           SET WS-RD-INDX UP BY 1.                                      
           ADD 1           TO WS-INDEX.                                 
      *                                                                         
       0310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0400-LOAD-RATE-COMPONENT                                       *        
      * PROCESS FOR LOADING RATE COMPONENT                             *        
      ******************************************************************        
       0400-LOAD-RATE-COMPONENT.                                        
      *                                                                         
           MOVE 1                               TO WS-INDEX             
           MOVE 0                               TO WS-ORDER-ROW-COUNT   
           SET WS-N6-INDX                       TO 1                    
                                                                        
           PERFORM 7130-OPEN-RATE-COMP-CSR      THRU 7130-EXIT.         
           PERFORM 7140-FETCH-RATE-COMP-CSR     THRU 7140-EXIT.         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 0410-LOAD-RATE-COMPONENT-TBL                      
                                                THRU 0410-EXIT          
                  UNTIL WS-INDEX > WS-ORDER-ROW-COUNT                   
                  OR WS-N6-RATE-CMPNT-ID(WS-INDEX) = SPACES             
                                                                        
              MOVE 1          TO WS-INDEX                               
                                                                        
              INITIALIZE WS-MISC-HOST-VARIABLES                         
                                                                        
              PERFORM 7140-FETCH-RATE-COMP-CSR  THRU 7140-EXIT          
           END-PERFORM.                                                 
                                                                        
      * IF NOT-FOUND OCCURS WHEN THERE IS A SUBSET ROW                          
           IF SQLERRD(3) > 0                                            
              PERFORM 0410-LOAD-RATE-COMPONENT-TBL                      
                                                THRU 0410-EXIT          
                  UNTIL WS-INDEX > WS-ORDER-ROW-COUNT                   
                  OR WS-N6-RATE-CMPNT-ID(WS-INDEX) = SPACES             
           END-IF                                                       
                                                                        
           PERFORM 7150-CLOSE-RATE-COMP-CSR     THRU 7150-EXIT.         
                                                                        
       0400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0410-LOAD-RATE-COMPONENT-TBL.                                  *        
      * LOAD THE RATE COMPONENT TABLE                                  *        
      ******************************************************************        
       0410-LOAD-RATE-COMPONENT-TBL.                                    
      *                                                                         
           MOVE WS-N6-RATE-CMPNT-ID(WS-INDEX)       TO                  
                               WS-N6-RATE-CMPNT-ID-ARR(WS-N6-INDX)      
           MOVE WS-N6-REVENUE-CNSMPTN-FL(WS-INDEX)  TO                  
                               WS-N6-REVENUE-CNSMPTN-FL-ARR(WS-N6-INDX) 
           MOVE WS-N6-REVENUE-AMOUNT-FL(WS-INDEX)   TO                  
                               WS-N6-REVENUE-AMOUNT-FL-ARR(WS-N6-INDX)  
           SET WS-N6-INDX UP BY 1.                                      
           ADD 1                                    TO WS-INDEX.        
      *                                                                         
       0410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0500-PROCESS-BEGIN-REC.                                        *        
      ******************************************************************        
       0500-PROCESS-BEGIN-REC.                                          
                                                                        
           PERFORM 7700-READ-INPUT              THRU 7700-EXIT.         
                                                                        
           EVALUATE TRUE                                                
              WHEN END-OF-FCSBE22                                       
                 DISPLAY '********** PCSCA177 ABORT **************'     
                 DISPLAY '*       0500-PROCESS-BEGIN-REC         *'     
                 DISPLAY '*        FCSBE22 FILE IS EMPTY         *'     
                 DISPLAY '*      PROCESSING TERMINATED           *'     
                 DISPLAY '********** PCSCA177 ABORT **************'     
                 PERFORM 9900-ABEND            THRU  9900-EXIT          
              WHEN E-FBE22-KEY-BREC EQUAL LOW-VALUES                    
                 IF E-FBE22-CREATE-DATE-BREC NOT = WS-INPUT-DATE        
                    DISPLAY '********** PCSCA177 ABORT **************'  
                    DISPLAY '*       0500-PROCESS-BEGIN-REC         *'  
                    DISPLAY '* FCSBE22 CREATE DATE NOT = RUN DATE   *'  
                    DISPLAY '* BE22 CREATE DATE: '                      
                                      E-FBE22-CREATE-DATE-BREC          
                    DISPLAY '* RUN  DATE: ' WS-INPUT-DATE               
                    DISPLAY '*      PROCESSING TERMINATED           *'  
                    DISPLAY '********** PCSCA177 ABORT **************'  
                    PERFORM 9900-ABEND         THRU 9900-EXIT           
                 END-IF                                                 
                                                                        
                 SET WS-BEGIN-RECS-PROCESSED TO TRUE                    
              WHEN WS-BEGIN-RECS-PROCESSED                              
                 IF E-FBE22-KEY-BREC EQUAL HIGH-VALUES OR LOW-VALUES    
                    IF E-FBE22-KEY-BREC EQUAL HIGH-VALUES               
                      AND NO-DATA-RECORD-FOUND                          
                      AND E-FBE22-RECORD-COUNT-EREC EQUAL ZERO          
                       DISPLAY '******* PCSCA177 MESSAGE*********'      
                       DISPLAY '*   0500-PROCESS-BEGIN-REC      *'      
                       DISPLAY '*    FCSBE22 FILE IS EMPTY      *'      
                       DISPLAY '*    PROCESSING TERMINATED      *'      
                       DISPLAY '******* PCSCA177 ABORT **********'      
                       PERFORM 9900-ABEND       THRU  9900-EXIT         
                    END-IF                                              
                 ELSE                                                   
                    SET DATA-RECORD-FOUND    TO TRUE                    
                    ADD 1                    TO WS-FCSBE22-REC-CNTR     
                 END-IF                                                 
              WHEN OTHER                                                
                 DISPLAY '********** PCSCA177 ABORT **************'     
                 DISPLAY '*       0500-PROCESS-BEGIN-REC         *'     
                 DISPLAY '*   FIRST RECORD IS NOT A CNTL REC     *'     
                 DISPLAY '*      PROCESSING TERMINATED           *'     
                 DISPLAY '********** PCSCA177 ABORT **************'     
                 PERFORM 9900-ABEND             THRU  9900-EXIT         
           END-EVALUATE.                                                
      *                                                                         
       0500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0600-LOAD-SPCL-FCTR-DATA                                       *        
      * PROCESS FOR LOADING SPCL FCTR DATA                             *        
      ******************************************************************        
       0600-LOAD-SPCL-FCTR-DATA.                                        
                                                                        
           MOVE 1                               TO WS-INDEX             
           MOVE 0                               TO WS-ORDER-ROW-COUNT   
           SET  WS-SF-INDX                      TO 1                    
                                                                        
           PERFORM 7160-OPEN-SPCL-FCTR-CSR      THRU 7160-EXIT.         
           PERFORM 7170-FETCH-SPCL-FCTR-CSR     THRU 7170-EXIT.         
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 0610-LOAD-SPCL-FCTR-TBL   THRU 0610-EXIT          
                  UNTIL WS-INDEX > WS-ORDER-ROW-COUNT                   
                  OR WS-SF-FACTOR-ID(WS-INDEX) = SPACES                 
                                                                        
              MOVE 1             TO WS-INDEX                            
                                                                        
              INITIALIZE WS-MISC-HOST-VARIABLES                         
                                                                        
              PERFORM 7170-FETCH-SPCL-FCTR-CSR  THRU 7170-EXIT          
           END-PERFORM.                                                 
                                                                        
      * IF NOT-FOUND OCCURS WHEN THERE IS A SUBSET ROW                          
           IF SQLERRD(3) > 0                                            
              PERFORM 0610-LOAD-SPCL-FCTR-TBL   THRU 0610-EXIT          
                  UNTIL WS-INDEX > WS-ORDER-ROW-COUNT                   
                  OR WS-SF-FACTOR-ID(WS-INDEX) = SPACES                 
           END-IF                                                       
                                                                        
           PERFORM 7180-CLOSE-SPCL-FCTR-CSR     THRU 7180-EXIT.         
                                                                        
       0600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0610-LOAD-SPCL-FCTR-TBL.                                       *        
      * LOAD THE SPCL FCTR ARRAY                                       *        
      ******************************************************************        
       0610-LOAD-SPCL-FCTR-TBL.                                         
      *                                                                         
           MOVE WS-SF-FACTOR-ID(WS-INDEX)         TO                    
                               WS-SF-FACTOR-ID-ARR(WS-SF-INDX)          
           MOVE WS-SF-PRORATE-FL(WS-INDEX)        TO                    
                               WS-SF-PRORATE-FL-ARR(WS-SF-INDX)         
           MOVE WS-SF-REV-INTERFACE-FL(WS-INDEX)  TO                    
                               WS-SF-REV-INTERFACE-FL-ARR(WS-SF-INDX)   
           MOVE WS-SF-SPCL-GROUP-CD(WS-INDEX)     TO                    
                               WS-SF-SPCL-GROUP-CD-ARR(WS-SF-INDX)      
           SET WS-SF-INDX UP BY 1.                                      
           ADD 1           TO WS-INDEX.                                 
      *                                                                         
       0610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0700-LOAD-SEB-REV-COMPANY                                      *        
      * PROCESS FOR LOADING SEB REVENUE COMPANY NO                     *        
      ******************************************************************        
       0700-LOAD-SEB-REV-COMPANY.                                       
                                                                        
           MOVE 1                               TO WS-INDEX             
           MOVE 0                               TO WS-ORDER-ROW-COUNT   
           SET  WS-TT-INDX                      TO 1                    
                                                                        
           PERFORM 7310-OPEN-SEB-REV-COMPANY-CSR                        
                                                THRU 7310-EXIT.         
           PERFORM 7320-FETCH-SEB-REV-COMPANY-CSR                       
                                                THRU 7320-EXIT.         
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 0710-LOAD-CRM-TIER-TBL    THRU 0710-EXIT          
                  UNTIL WS-INDEX > WS-ORDER-ROW-COUNT                   
                  OR WS-TT-COMPANY-NO(WS-INDEX) = SPACES                
                                                                        
              MOVE 1             TO WS-INDEX                            
                                                                        
              INITIALIZE WS-MISC-HOST-VARIABLES                         
                                                                        
              PERFORM 7320-FETCH-SEB-REV-COMPANY-CSR                    
                                                THRU 7320-EXIT          
           END-PERFORM.                                                 
                                                                        
      * IF NOT-FOUND OCCURS WHEN THERE IS A SUBSET ROW                          
           IF SQLERRD(3) > 0                                            
              PERFORM 0710-LOAD-CRM-TIER-TBL    THRU 0710-EXIT          
                  UNTIL WS-INDEX > WS-ORDER-ROW-COUNT                   
                  OR WS-TT-COMPANY-NO(WS-INDEX) = SPACES                
           END-IF                                                       
                                                                        
           PERFORM 7330-CLOSE-SEB-REV-COMP-CSR  THRU 7330-EXIT.         
                                                                        
       0700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0710-LOAD-CRM-TIER-TBL.                                        *        
      * LOAD THE CRM TIER ACCT TYPE ARRAY                              *        
      ******************************************************************        
       0710-LOAD-CRM-TIER-TBL.                                          
      *                                                                         
           MOVE WS-TT-REV-COMPANY-NO(WS-INDEX)    TO                    
                               WS-TT-REV-COMPANY-NO-ARR(WS-TT-INDX)     
           MOVE WS-TT-COMPANY-NO(WS-INDEX)        TO                    
                               WS-TT-COMPANY-NO-ARR(WS-TT-INDX)         
           MOVE WS-TT-TIER-ACCT-TYPE-CD(WS-INDEX) TO                    
                               WS-TT-TIER-ACCT-TYPE-CD-ARR(WS-TT-INDX)  
           SET WS-TT-INDX UP BY 1.                                      
           ADD 1           TO WS-INDEX.                                 
      *                                                                         
       0710-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
I01959******************************************************************        
I01959*                                                                *        
I01959* 0720-LOAD-CAP-FACTOR-TBL.                                      *        
I01959******************************************************************        
I01959 0720-LOAD-CAP-FACTOR-TBL.                                        
I01959*                                                                         
I01959     MOVE WS-ALTERNATE-FUEL-CD(WS-INDEX)    TO                    
I01959                         WS-ALTERNATE-FUEL-CD-ARR(WS-CF-INDX).    
I01959     MOVE WS-CAP-FCTR-MONTH(WS-INDEX)       TO                    
I01959                         WS-CAP-FCTR-MONTH-ARR(WS-CF-INDX).       
I01959     MOVE WS-CAP-FCTR-START-DT(WS-INDEX) TO                       
I01959                         WS-CAP-FCTR-START-DT-ARR(WS-CF-INDX).    
I01959     MOVE WS-CAPACITY-FACTOR(WS-INDEX) TO                         
I01959                         WS-CAPACITY-FACTOR-ARR(WS-CF-INDX).      
I01959     MOVE WS-ON-PEAK-ALLOC(WS-INDEX) TO                           
I01959                         WS-ON-PEAK-ALLOC-ARR(WS-CF-INDX).        
I01959     MOVE WS-OFF-PEAK-ALLOC(WS-INDEX) TO                          
I01959                         WS-OFF-PEAK-ALLOC-ARR(WS-CF-INDX).       
I01959     SET WS-CF-INDX UP BY 1.                                      
I01959     ADD 1           TO WS-INDEX.                                 
I01959*                                                                         
I01959 0720-EXIT.                                                       
I01959     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0750-LOAD-PRTY-SVC-CATEGORY                                    *        
      * PROCESS FOR LOADING PRIORITY SERVICE CATEGORY                  *        
      ******************************************************************        
       0750-LOAD-PRTY-SVC-CATEGORY.                                     
                                                                        
           MOVE 1                               TO WS-INDEX             
           MOVE 0                               TO WS-ORDER-ROW-COUNT   
           SET  WS-Z4-INDX                      TO 1                    
                                                                        
           PERFORM 7340-OPEN-PRTY-SVC-CSR       THRU 7340-EXIT.         
           PERFORM 7350-FETCH-PRTY-SVC-CSR      THRU 7350-EXIT.         
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 0760-LOAD-PRTY-SVC-TBL    THRU 0760-EXIT          
                  UNTIL WS-INDEX > WS-ORDER-ROW-COUNT                   
                  OR WS-Z4-COMPANY-NO(WS-INDEX) = SPACES                
                                                                        
              MOVE 1             TO WS-INDEX                            
                                                                        
              INITIALIZE WS-MISC-HOST-VARIABLES                         
                                                                        
              PERFORM 7350-FETCH-PRTY-SVC-CSR   THRU 7350-EXIT          
           END-PERFORM.                                                 
                                                                        
      * IF NOT-FOUND OCCURS WHEN THERE IS A SUBSET ROW                          
           IF SQLERRD(3) > 0                                            
              PERFORM 0760-LOAD-PRTY-SVC-TBL    THRU 0760-EXIT          
                  UNTIL WS-INDEX > WS-ORDER-ROW-COUNT                   
                  OR WS-Z4-COMPANY-NO(WS-INDEX) = SPACES                
           END-IF                                                       
                                                                        
           PERFORM 7360-CLOSE-PRTY-SVC-CSR      THRU 7360-EXIT.         
                                                                        
       0750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0760-LOAD-PRTY-SVC-TBL.                                        *        
      * LOAD THE CRM TIER ACCT TYPE ARRAY                              *        
      ******************************************************************        
       0760-LOAD-PRTY-SVC-TBL.                                          
      *                                                                         
           MOVE WS-Z4-PRTY-SVC-CAT-CD(WS-INDEX)   TO                    
                               WS-Z4-PRTY-SVC-CAT-CD-ARR(WS-Z4-INDX)    
           MOVE WS-Z4-COMPANY-NO(WS-INDEX)        TO                    
                               WS-Z4-COMPANY-NO-ARR(WS-Z4-INDX)         
           MOVE WS-Z4-CODE-CURTAIL-PRTY(WS-INDEX) TO                    
                               WS-Z4-CODE-CURTAIL-PRTY-ARR(WS-Z4-INDX)  
           SET WS-Z4-INDX UP BY 1.                                      
           ADD 1           TO WS-INDEX.                                 
      *                                                                         
       0760-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0775-LOAD-CODE-VALUE-DATA.                                     *        
      * PROCESS FOR LOADING DATA FROM CSS_CODE_VALUE                   *        
      ******************************************************************        
       0775-LOAD-CODE-VALUE-DATA.                                       
                                                                        
           SET  WS-UV-INDX                      TO 1.                   
                                                                        
           PERFORM 7380-OPEN-CODE-VALUE-CSR     THRU 7380-EXIT.         
           PERFORM 7385-FETCH-CODE-VALUE-CSR    THRU 7385-EXIT.         
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              MOVE UV-COLUMN-NA-TEXT            TO                      
                                      WS-UV-COLUMN-NAME(WS-UV-INDX)     
              SET WS-UV-INDX                    UP BY 1                 
              PERFORM 7385-FETCH-CODE-VALUE-CSR THRU 7385-EXIT          
           END-PERFORM.                                                 
                                                                        
           PERFORM 7390-CLOSE-CODE-VALUE-CSR    THRU 7390-EXIT.         
                                                                        
       0775-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
I01959******************************************************************        
I01959*                                                                *        
I01959* 0780-LOAD-CAPACITY-FACTOR.                                     *        
I01959******************************************************************        
I01959 0780-LOAD-CAPACITY-FACTOR.                                       
I01959                                                                  
I01959     MOVE 1                               TO WS-INDEX             
I01959     MOVE 0                               TO WS-ORDER-ROW-COUNT   
I01959     SET  WS-CF-INDX                      TO 1                    
I01959                                                                  
I01959     PERFORM 7650-OPEN-CAPACITY-FCTR      THRU 7650-EXIT.         
I01959     PERFORM 7660-FETCH-CAPACITY-FCTR     THRU 7660-EXIT.         
I01959     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
I01959        PERFORM 0720-LOAD-CAP-FACTOR-TBL  THRU 0720-EXIT          
I01959            UNTIL WS-INDEX > WS-ORDER-ROW-COUNT                   
I01959            OR WS-ALTERNATE-FUEL-CD(WS-INDEX) = SPACES            
I01959                                                                  
I01959        MOVE 1             TO WS-INDEX                            
I01959        INITIALIZE WS-MISC-HOST-VARIABLES                         
I01959        PERFORM 7660-FETCH-CAPACITY-FCTR  THRU 7660-EXIT          
I01959     END-PERFORM.                                                 
I01959                                                                  
I01959     IF SQLERRD(3) > 0                                            
I01959        PERFORM 0720-LOAD-CAP-FACTOR-TBL  THRU 0720-EXIT          
I01959            UNTIL WS-INDEX > WS-ORDER-ROW-COUNT                   
I01959            OR WS-ALTERNATE-FUEL-CD(WS-INDEX) = SPACES            
I01959     END-IF                                                       
I01959     PERFORM 7670-CLOSE-CAPACITY-FCTR     THRU 7670-EXIT.         
I01959                                                                  
I01959 0780-EXIT.                                                       
I01959     EXIT.                                                        
                                                                        
      ******************************************************************        
      *   0609-INITIALIZE-FBE00-WS-AREA                                *        
      ******************************************************************        
       COPY CPD00052.                                                           
                                                                        
      ******************************************************************        
      *   0640-INITIALIZE-FBE01-WS-AREA                                *        
      ******************************************************************        
       COPY CPD00049.                                                           
                                                                        
      ******************************************************************        
      *   0690-INITIALIZE-FBE02-WS-AREA                                *        
      ******************************************************************        
       COPY CPD00101.                                                           
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      * PROCESS ALL BE22 ACCOUNTS                                      *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1010-PROCESS-FCSBE22         THRU 1010-EXIT          
              UNTIL END-OF-BE22.                                        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1010-PROCESS-FCSBE22.                                          *        
      ******************************************************************        
       1010-PROCESS-FCSBE22.                                            
                                                                        
           IF E-FBE22-KEY-BREC EQUAL HIGH-VALUES OR LOW-VALUES          
              CONTINUE                                                  
           ELSE                                                         
              MOVE E-FBE22-ACCOUNT-NO           TO AT-ACCOUNT-NO        
              PERFORM 1100-LOAD-BE22-ACCT-TO-WS THRU 1100-EXIT          
      * PROCESSING FOR EACH ACCOUNT STARTS HERE                                 
              MOVE WS-ACCOUNT-NO-AT             TO WS-DISPLAY-ACCOUNT   
I01959        MOVE WS-PREMISE-NO-AT             TO AT-PREMISE-NO        
              DISPLAY 'PROCESSING ACCOUNT NO: ' WS-DISPLAY-ACCOUNT      
              PERFORM 2000-PROCESS-ACCOUNT      THRU 2000-EXIT          
           END-IF.                                                      
                                                                        
           IF WS-END-OF-BE22-SW NOT = 'Y'                               
              AND E-FBE22-ACCOUNT-NO IS NOT NUMERIC                     
              PERFORM 7700-READ-INPUT           THRU 7700-EXIT          
           END-IF.                                                      
                                                                        
       1010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1100-LOAD-BE22-ACCT-TO-WS.                                     *        
      *   1. LOAD ALL BE22 RECORDS OF AN ACCOUNT TO CWS10000 VARIABLES *        
      *      AND READ THROUGH TILL IT FINDS A DIFFERENT ACCOUNT        *        
      ******************************************************************        
       1100-LOAD-BE22-ACCT-TO-WS.                                       
                                                                        
           PERFORM 0609-INITIALIZE-FBE00-WS-AREA THRU 0609-EXIT.        
           PERFORM 0640-INITIALIZE-FBE01-WS-AREA THRU 0640-EXIT.        
           PERFORM 0690-INITIALIZE-FBE02-WS-AREA THRU 0690-EXIT.        
                                                                        
           MOVE E-FBE22-ACCOUNT-NO               TO WS-PREVIOUS-ACCT-NO.
                                                                        
           PERFORM 1110-LOAD-ACCT-TO-WS          THRU 1110-EXIT         
             UNTIL END-OF-BE22                                          
                 OR E-FBE22-ACCOUNT-NO NOT = WS-PREVIOUS-ACCT-NO.       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1110-LOAD-ACCT-TO-WS.                                          *        
      * LOADS THE DATA INTO WORKING STORAGE TABLES BASED ON TABLE ID   *        
      ******************************************************************        
       1110-LOAD-ACCT-TO-WS.                                            
                                                                        
           MOVE FIOBE22                         TO FIOBE02.             
           MOVE E-FBE02-SORT-KEY                TO E-FBE01-SORT-KEY.    
           MOVE E-FBE02-TABLE-ID                TO WS-CWS-TABLE-ID.     
           IF WS-CWS10000-TABLE-ID                                      
              PERFORM 0800-LOAD-FBE02-WS-AREA   THRU 0800-EXIT          
           END-IF.                                                      
           PERFORM 7700-READ-INPUT              THRU 7700-EXIT.         
                                                                        
       1110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-ACCOUNT                                           *        
      * PROCESS FOR EACH ACCOUNT                                       *        
      ******************************************************************        
       2000-PROCESS-ACCOUNT.                                            
                                                                        
I01959     MOVE 'N'                          TO WS-CALC-DER-RECOVERY.   
I01959     MOVE 'N'                          TO WS-DER-RECOVERY-PROCESS.
I01959     INITIALIZE WS-DER-KEYS-TABLE.                                
I01959     SET DER-KEYS                      TO 1.                      
I01959     PERFORM 2940-CALC-CUST-GEN-UNITS     THRU 2940-EXIT.         
                                                                        
           PERFORM VARYING WS-BILLING-INDX FROM 1 BY 1 UNTIL            
              WS-BILLING-INDX  > WS-BG-MAX-ENTRY OR                     
              WS-ACCOUNT-NO-BG (WS-BILLING-INDX) = +0                   
                                                                        
              PERFORM 2010-INITIALIZE-BG-DATA    THRU 2010-EXIT         
                                                                        
                                                                        
      *GET DDC FACTOR VALUE FOR SEB                                             
              IF SEB-DATABASE                                           
                 PERFORM 2100-DDC-PROCESS        THRU 2100-EXIT         
              END-IF                                                    
                                                                        
      *REBILL PROCESS                                                           
                                                                        
              IF WS-CODE-BILL-ITM-TYPE-BG(WS-BILLING-INDX) = 'B'        
NONCAL           PERFORM 2005-CHECK-MANUAL-BILL-DETAILS                 
NONCAL                                            THRU 2005-EXIT        
NONCAL           IF CPD107B-HAS-BILL-MAN                                
NONCAL              SET PROCESS-BG                TO TRUE               
NONCAL           ELSE                                                   
                    PERFORM 2150-GET-BACKOUT-DETAILS THRU 2150-EXIT     
                    PERFORM 2900-GET-PREV-REV-DTLS   THRU 2900-EXIT     
      *DO NOT CALL BILL CALC IF THE ORIGINAL BILL WAS A NONE-CALC               
                    IF BG-CODE-BILL-CALC NOT = 'S' AND CALL-BILL-CALC   
                       AND WS-AMT-BILL-ITEM-BG(WS-BILLING-INDX) NOT = 0 
                       PERFORM 2300-REBILL-PROCESS   THRU 2300-EXIT     
                    END-IF                                              
NONCAL           END-IF                                                 
              END-IF                                                    
                                                                        
            IF PROCESS-BG                                               
      *BASED ON WS-CODE-DR-CR-CNSMPTN-BG MULTIPLY BILL AMOUNT BY -1             
              IF WS-CODE-DR-CR-CNSMPTN-BG(WS-BILLING-INDX) = 'C'        
                 MULTIPLY -1 BY WS-AMT-BILL-ITEM-BG(WS-BILLING-INDX)    
                 MULTIPLY -1 BY WS-AMT-STATE-TAX-BG(WS-BILLING-INDX)    
                 MULTIPLY -1 BY WS-AMT-CITY-TAX-BG(WS-BILLING-INDX)     
                 MULTIPLY -1 BY WS-AMT-OTHER-TAX-BG(WS-BILLING-INDX)    
              END-IF                                                    
                                                                        
      *BASED ON WS-CODE-DEBIT-CREDIT-CX MULTIPLY USAGE BY -1                    
              PERFORM 2610-PROCESS-CNSMPTN-HIST   THRU 2610-EXIT        
                                                                        
      *UPDATE THE EQUIP_ID FOR NEW RATE VERSIONS TO MATCH WITH OLD ONES         
              PERFORM 2040-PROCESS-EQUIP-ID-CHANGE                      
                                                  THRU 2040-EXIT        
                                                                        
      *THERE'S SOME CODE IN 2250- AND 2260- RELATED TO CODE-DR-CR-BG            
      *WHICH HAS BEEN ADDED TO MATCH PCSCA379. IT NEEDS TO BE REVISITED.        
                                                                        
      *CHECK FOR RATE PRORATION AND LOADING THE WS TABLE FOR RT VERSION         
                                                                        
              PERFORM 2250-CHECK-RATE-PRORATION   THRU 2250-EXIT        
                      VARYING WS-BILL-ADJ-INDX FROM 1 BY 1              
                      UNTIL WS-BILL-ADJ-INDX > WS-BA-MAX-ENTRY OR       
                            WS-ACCOUNT-NO-BA (WS-BILL-ADJ-INDX) = ZERO  
                                                                        
      *CHECK FOR CONSUMPTION TYPE                                               
                                                                        
              PERFORM 2260-CHECK-CONSUMPTION-TYPE THRU 2260-EXIT        
                      VARYING WS-CALC-INDX FROM 1 BY 1                  
                      UNTIL WS-CALC-INDX > WS-BZ-MAX-ENTRY OR           
                            WS-ACCOUNT-NO-BC(WS-CALC-INDX) = +0         
                                                                        
      *POPULATE THE REV_BILLING_DET FILE.                                       
              PERFORM 2200-REV-BILL-DET-PROCESS   THRU 2200-EXIT        
                                                                        
      *PROCESS THE BILL CALC AND BILL ADJ ROWS ASSOCIATED WITH THE BG           
                                                                        
              PERFORM VARYING WS-CALC-INDX FROM 1 BY 1 UNTIL            
                 WS-CALC-INDX > WS-BZ-MAX-ENTRY OR                      
                 WS-ACCOUNT-NO-BC(WS-CALC-INDX) = +0                    
                                                                        
                 PERFORM 2020-INITIALIZE-BC-DATA THRU 2020-EXIT         
                                                                        
                 IF WS-BILLING-KEY(WS-BILLING-INDX)                     
                            = WS-BILLING-KEY-BC(WS-CALC-INDX)           
                                                                        
                    PERFORM 2270-GET-ADDT-BILL-CALC-DET                 
                                          THRU 2270-EXIT                
                    PERFORM 2570-GET-PRORATION-PCT                      
                                          THRU 2570-EXIT                
                    PERFORM 2590-GET-NO-OF-RATE-VERS-USAGE              
                                          THRU 2590-EXIT                
                                                                        
                    PERFORM VARYING WS-BILL-ADJ-INDX FROM 1 BY 1 UNTIL  
                       WS-BILL-ADJ-INDX > WS-BA-MAX-ENTRY OR            
                       WS-ACCOUNT-NO-BA(WS-BILL-ADJ-INDX) = +0          
                                                                        
                       PERFORM 2030-INITIALIZE-BA-DATA                  
                                                 THRU 2030-EXIT         
                                                                        
                       MOVE WS-FACTOR-ID-BA(WS-BILL-ADJ-INDX)           
                                                 TO                     
                                                SF-FACTOR-ID            
                                                                        
I01959                 IF WS-FACTOR-ID-BA(WS-BILL-ADJ-INDX)             
I01959                                         EQUAL WS-SHORT-VOS-FCTR  
I01959                    MOVE WS-FACTOR-BA(WS-BILL-ADJ-INDX)           
I01959                                                TO WS-SHORT-VOS   
I01959                 END-IF                                           
I01959                 IF WS-FACTOR-ID-BA(WS-BILL-ADJ-INDX)             
I01959                                         EQUAL WS-LONG-VOS-FCTR   
I01959                    MOVE WS-FACTOR-BA(WS-BILL-ADJ-INDX)           
I01959                                                TO WS-LONG-VOS    
I01959                 END-IF                                           
                       PERFORM 2800-GET-PRORATE-FL                      
                                                 THRU 2800-EXIT         
                                                                        
                       IF WS-BILLING-KEY-BC(WS-CALC-INDX)               
                           = WS-BILLING-KEY-BA(WS-BILL-ADJ-INDX)        
                       AND (WS-FACTOR-COMPONENT-BA(WS-BILL-ADJ-INDX)    
                            = WS-COMPONENT-KEY-BC(WS-CALC-INDX)         
                       OR                                               
                            (                                           
                          PRORATED                                      
                          AND WS-PRORATE-FL-TEMP NOT = 'R'              
                          AND WS-COMPONENT-CODE-BC(WS-CALC-INDX)        
                             = WS-FCT-CMPNT-ID-BA(WS-BILL-ADJ-INDX)     
                          AND WS-CONSUMPTION-TYPE-BC(WS-CALC-INDX)      
                             = WS-FCT-CNSMPT-TYPE-BA(WS-BILL-ADJ-INDX)  
                          AND WS-REGISTER-TYPE-BC(WS-CALC-INDX)         
                             = WS-FCT-REGISTER-TYPE-BA(WS-BILL-ADJ-INDX)
                          AND WS-CODE-TOU-BC(WS-CALC-INDX)              
                             = WS-FCT-TOU-BA(WS-BILL-ADJ-INDX)          
                          AND WS-CODE-SEASON-BC(WS-CALC-INDX)           
                             = WS-FCT-SEASON-BA(WS-BILL-ADJ-INDX)       
                          AND WS-RATE-VERSION-BC(WS-CALC-INDX) NOT =    
                             WS-FCT-RATE-VERSION-BA(WS-BILL-ADJ-INDX))) 
                                                                        
                          PERFORM 2400-BILL-ADJUSTMENT-PROCESS          
                                                 THRU 2400-EXIT         
                                                                        
                       END-IF                                           
                    END-PERFORM                                         
                                                                        
                    PERFORM 2500-BILL-CALC-PROCESS                      
                                                 THRU 2500-EXIT         
                                                                        
                    SET WS-RT-VRSN-INDX UP BY 1                         
                                                                        
                 END-IF                                                 
              END-PERFORM                                               
                                                                        
              IF WS-AMT-STATE-TAX-BG(WS-BILLING-INDX) NOT = 0 OR        
                 WS-AMT-CITY-TAX-BG(WS-BILLING-INDX) NOT = 0            
                 PERFORM 2600-TAX-CALCULATION-PROCESS                   
                                                 THRU 2600-EXIT         
              END-IF                                                    
                                                                        
              IF MANUAL-BILL                                            
                 PERFORM 2850-PROCESS-MANUAL-BILLS                      
                                                 THRU 2850-EXIT         
              END-IF                                                    
                                                                        
I01959        IF CSR-DATABASE                                           
I01959           MOVE WS-RATE-PLAN-NO-BG(WS-BILLING-INDX) TO            
I01959                                             WS-DER-REC-RATE-PLAN 
I01959           IF DER-REC-RATE-PLAN                                   
I01959              MOVE 'Y'                TO WS-DER-RECOVERY-PROCESS  
I01959              IF WS-CODE-BILL-ITM-TYPE-BG(WS-BILLING-INDX)        
I01959                                                  NOT EQUAL 'B'   
I01959                 PERFORM 5910-CALC-DER-RECOVERY THRU 5910-EXIT    
I01959              END-IF                                              
I01959           END-IF                                                 
I01959        END-IF                                                    
                                                                        
            END-IF                                                      
           END-PERFORM.                                                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2005-CHECK-MANUAL-BILL-DETAILS.                                 *        
      *CHECK IF MANUAL BILL CALCULATIONS ARE PRESENT FOR THE IC        *        
      ******************************************************************        
NONCAL 2005-CHECK-MANUAL-BILL-DETAILS.                                  
NONCAL                                                                  
NONCAL     MOVE WS-ACCOUNT-NO-BG (WS-BILLING-INDX)                      
NONCAL                                     TO WS-CPD107B-ACCOUNT-NO.    
NONCAL     MOVE WS-BILL-NO-BG (WS-BILLING-INDX)                         
NONCAL                                     TO WS-CPD107B-BILL-NO.       
NONCAL     MOVE WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)                  
NONCAL                                     TO WS-CPD107B-CODE-UTIL-TYPE.
NONCAL     MOVE WS-IC-NO-BG (WS-BILLING-INDX)                           
NONCAL                                     TO WS-CPD107B-IC-NO.         
NONCAL     MOVE WS-BILL-ITEM-TIMESTMP-BG (WS-BILLING-INDX)              
NONCAL                                     TO WS-CPD107B-BILL-TIMESTMP. 
NONCAL                                                                  
NONCAL     PERFORM 6005-CPD107B-INPUT-PROCESS   THRU 6005-CPD107B-EXIT. 
NONCAL     PERFORM 6060-CPD107B-GET-MANBILL-HDR THRU 6060-CPD107B-EXIT. 
NONCAL                                                                  
NONCAL     IF CPD107B-HAS-BILL-MAN                                      
NONCAL        AND WS-CPD107B-RETURN-CODE EQUAL SUCCESSFUL-CALL          
NONCAL        CONTINUE                                                  
NONCAL     ELSE                                                         
NONCAL        IF WS-CPD107B-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL       
NONCAL           DISPLAY '********** PCSCA177  ABORT **************'    
NONCAL           DISPLAY '*2005-CHECK-MANUAL-BILL-DETAILS        *'     
NONCAL           DISPLAY '*ACCOUNT-NO      = ' WS-CPD107B-ACCOUNT-NO    
NONCAL           DISPLAY '*CODE_UTIL_TYPE  = ' WS-CPD107B-CODE-UTIL-TYPE
NONCAL           DISPLAY '*IC_NO           = ' WS-CPD107B-IC-NO         
NONCAL           DISPLAY '*BILL_NO         = ' WS-CPD107B-BILL-NO       
NONCAL           DISPLAY '*BILL_ITEM_TSTM  = ' WS-CPD107B-BILL-TIMESTMP 
NONCAL           DISPLAY '*SQLCODE IS        ',WS-CPD107B-RETURN-CODE   
NONCAL           DISPLAY '*CB107 PARAGRAPH = ' WS-CPD107B-DB2-PARAGRAPH 
NONCAL           DISPLAY '*PROGRAM ABORTING...                   *'     
NONCAL           DISPLAY '********** PCSCA177  ABORT **************'    
NONCAL           PERFORM 9900-ABEND             THRU 9900-EXIT          
NONCAL        ELSE                                                      
NONCAL           CONTINUE                                               
NONCAL        END-IF                                                    
NONCAL     END-IF.                                                      
NONCAL                                                                  
NONCAL 2005-EXIT.                                                       
NONCAL     EXIT.                                                        
NONCAL*                                                                         
      ******************************************************************        
      *2010-INITIALIZE-BG-DATA                                         *        
      *INITIALIZE THE VARIABLES                                        *        
      ******************************************************************        
       2010-INITIALIZE-BG-DATA.                                         
                                                                        
           MOVE 0                        TO WS-RUNNING-COUNTER          
                                            WS-REVBLK-BILL-COMP-SEQ-NO  
I01959     PERFORM 2015-INITIALIZE-BG-WS    THRU 2015-EXIT.             
       2010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
I01959*****************************************************************         
I01959*                                                               *         
I01959* 2015-INITIALIZE-BG-WS.                                        *         
I01959*****************************************************************         
I01959 2015-INITIALIZE-BG-WS.                                           
I01959                                                                  
I01959     INITIALIZE WS-HOLD-BILL-USAGE-UNITS                          
I01959                WS-HOLD-BILL-DEMAND-UNITS                         
I01959                WS-HOLD-READ-UNITS                                
I01959                WS-BC-RATE-VERSION-TBL                            
I01959                WS-HOLD-FCTR-DTL                                  
I01959                WS-TEMP-FCTR-DTL                                  
I01959                WS-UTIL-REV-TRACKED                               
I01959                WS-NONUTIL-REV-NOT-TRACKED                        
I01959                WS-NON-UTIL-REV-TRACKED                           
I01959                WS-TOTAL-BILL-ITEM-AMT                            
A02932                WS-TOTAL-AMT-FOR-TAX                              
A02932                WS-HOLD-ANNUAL-MIN-AMT                            
I01959                WS-HOLD-RATE-CALC-TYPE-CD                         
I01959                WS-HOLD-BILL-DATE                                 
I01959                WS-HOLD-EFF-START-DT                              
I01959                WS-TAX-AMT                                        
I01959                WS-HOLD-BA-SEQ-NO                                 
A02932                WS-TEMP-BC-SEQ-NO                                 
A02932                WS-TEMP-BC-COUNT                                  
I01959                WS-REVADJ-GL-ACCT-NO                              
I01959                WS-TEMP-REVADJ-AMT                                
I01959                WS-TEMP-READ-UNITS                                
I01959                WS-TEMP-READ-UNITS-GAS                            
I01959                WS-TEMP-READ-UNITS-ELE                            
I01959                WS-TEMP-READ-UNITS-KVA                            
I01959                WS-TEMP-READ-UNITS-KW                             
I01959                WS-NONCAL-READ-UNITS                              
I01959                WS-NONCAL-BILL-USAGE-UNITS                        
I01959                WS-NONCAL-BILL-DEMAND-UNITS                       
I01959                WS-NI-USAGE-END-DATE                              
I01959                WS-NI-DATE-BILLED                                 
I01959                WS-NI-DATE-ORIG-BILL                              
I01959                WS-NI-RT-VERSN-DT                                 
I01959                WS-NI-RT-FCT-FROM-DT                              
I01959                WS-NI-KW-MDQ-DT                                   
I01959                WS-NI-KVA-DT                                      
I01959                WS-NI-READ-UNITS                                  
I01959                WS-NI-BILL-UNITS                                  
I01959                WS-NI-CONSUMPT-TYPE-CD                            
I01959                WS-NONCAL-CALC-UNITS                              
I01959                WS-HOLD-RT-VERS-FROM-DT                           
I01959                WS-HOLD-RT-VERS-PRO-CD                            
I01959                WS-HOLD-SERVICE-TYPE                              
I01959                WS-HOLD-BLK-REV-AMT                               
I01959                WS-HOLD-BC-BILL-UNITS                             
I01959                WS-HOLD-BC-READ-UNITS                             
I01959                WS-HOLD-BZ-READ-UNITS                             
PRJ257                WS-TEMP-TAX-CNTRL-NO                              
I01959                WS-HOLD-FCTR-DTL                                  
I01959                WS-HOLD-DDC-FACTOR.                               
I01959                                                                  
I01959     SET WS-BILL-ADJ-INDX          TO 1                           
I01959     SET WS-RT-VRSN-INDX           TO 1                           
I01959     SET WS-RT-VRSN-IND1           TO 1                           
I01959     SET WS-HLD-FCTR-INDX          TO 1                           
I01959     SET WS-HLD-FCTR-INDX1         TO 1                           
I01959     SET WS-TMP-FCTR-INDX          TO 1                           
I01959     SET WS-TMP-FCTR-INDX1         TO 1                           
I01959     SET MANUAL-BILL               TO TRUE                        
I01959     SET CALL-BILL-CALC            TO TRUE                        
I01959     SET PROCESS-BG                TO TRUE                        
I01959                                                                  
I01959     MOVE '0'                      TO WS-HOLD-RATE-VERSION        
I01959     MOVE 'N'                      TO WS-PRORATION-FLAG           
I01959                                                                  
I01959     MOVE SPACES                   TO WS-ELECTRIC-KWH-FL          
I01959                                      WS-ELECTRIC-KW-FL           
I01959                                      WS-ELECTRIC-KVA-FL          
I01959                                                                  
I01959*OUTPUT FILE INITIALIZATION                                               
I01959     INITIALIZE FCSCREVD                                          
I01959                FCSCREVC                                          
I01959                FCSCREVB                                          
I01959                FCSCREVT.                                         
I01959 2015-EXIT.                                                       
I01959     EXIT.                                                        
I01959*                                                                         
      ******************************************************************        
      *2020-INITIALIZE-BC-DATA                                         *        
      *INITIALIZE THE VARIABLES                                        *        
      ******************************************************************        
       2020-INITIALIZE-BC-DATA.                                         
                                                                        
           INITIALIZE WS-UTIL-REV-TRACKED                               
                      WS-NONUTIL-REV-NOT-TRACKED                        
                      WS-NON-UTIL-REV-TRACKED                           
                      WS-BLOCK-NO                                       
                      WS-TEMP-COMPONENT-ID                              
                      WS-REVENUE-AMOUNT-FL-TEMP                         
                      WS-HOLD-RT-VERS-FROM-DT                           
                      WS-HOLD-RT-VERS-PRO-CD                            
                      WS-HOLD-READ-UNITS                                
                      WS-HOLD-BILL-USAGE-UNITS                          
                      WS-HOLD-BILL-DEMAND-UNITS                         
                      WS-HOLD-BC-READ-UNITS                             
                      WS-HOLD-BZ-READ-UNITS                             
                      WS-HOLD-BC-BILL-UNITS                             
                      WS-REVENUE-CNSMPTN-FL-TEMP.                       
                                                                        
           SET WS-BILL-ADJ-INDX          TO 1                           
                                                                        
      *OUTPUT FILE INITIALIZATION                                               
           INITIALIZE FCSCREVC                                          
                      FCSCREVB.                                         
                                                                        
       2020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2030-INITIALIZE-BA-DATA                                         *        
      *INITIALIZE THE VARIABLES                                        *        
      ******************************************************************        
       2030-INITIALIZE-BA-DATA.                                         
                                                                        
      *OUTPUT FILE INITIALIZATION                                               
           INITIALIZE FCSCREVC                                          
                      WS-TEMP-READ-UNITS                                
                      WS-TEMP-REVADJ-AMT.                               
                                                                        
       2030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2040-PROCESS-EQUIP-ID-CHANGE                                    *        
      *TO UPDATE THE EQUIP ID FOR LIGHTS FOR ALL RATE VERSIONS         *        
      ******************************************************************        
       2040-PROCESS-EQUIP-ID-CHANGE.                                    
                                                                        
           PERFORM VARYING WS-BILL-ADJ-INDX FROM 1 BY 1 UNTIL           
              WS-BILL-ADJ-INDX > WS-BA-MAX-ENTRY OR                     
              WS-ACCOUNT-NO-BA(WS-BILL-ADJ-INDX) = +0                   
                                                                        
              IF WS-BILLING-KEY (WS-BILLING-INDX) =                     
                 WS-BILLING-KEY-BA (WS-BILL-ADJ-INDX) AND               
                 WS-FCT-CMPNT-ID-BA(WS-BILL-ADJ-INDX) (1:1) = 'U'       
                                                                        
                 PERFORM VARYING SUB7 FROM 1 BY 1 UNTIL                 
                 SUB7 > 80 OR WS-NEW-EQUIP-ID(SUB7) <= SPACES           
                                                                        
                    IF WS-FCT-CMPNT-ID-BA(WS-BILL-ADJ-INDX) (2:1) =     
                       WS-OLD-EQUIP-ID(SUB7)                            
                       MOVE WS-NEW-EQUIP-ID(SUB7)                       
                                             TO                         
                            WS-FCT-CMPNT-ID-BA(WS-BILL-ADJ-INDX) (2:1)  
                       MOVE 81               TO SUB7                    
                    END-IF                                              
                 END-PERFORM                                            
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           PERFORM VARYING WS-CALC-INDX FROM 1 BY 1 UNTIL               
              WS-CALC-INDX > WS-BZ-MAX-ENTRY OR                         
              WS-ACCOUNT-NO-BC(WS-CALC-INDX) = +0                       
                                                                        
              IF WS-BILLING-KEY (WS-BILLING-INDX) =                     
                 WS-BILLING-KEY-BC (WS-CALC-INDX)  AND                  
                 WS-COMPONENT-CODE-BC(WS-CALC-INDX) (1:1) = 'U'         
                                                                        
                 PERFORM VARYING SUB7 FROM 1 BY 1 UNTIL                 
                 SUB7 > 80 OR WS-NEW-EQUIP-ID(SUB7) <= SPACES           
                                                                        
                    IF WS-COMPONENT-CODE-BC(WS-CALC-INDX) (2:1) =       
                       WS-OLD-EQUIP-ID(SUB7)                            
                       MOVE WS-NEW-EQUIP-ID(SUB7)                       
                                             TO                         
                            WS-COMPONENT-CODE-BC(WS-CALC-INDX) (2:1)    
                       MOVE 81               TO SUB7                    
                    END-IF                                              
                 END-PERFORM                                            
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           PERFORM VARYING WS-CALC-X-INDX FROM 1 BY 1 UNTIL             
              WS-CALC-X-INDX > WS-BZ-MAX-ENTRY OR                       
              WS-ACCOUNT-NO-XD(WS-CALC-X-INDX) = +0                     
                                                                        
              IF WS-BILLING-KEY (WS-BILLING-INDX) =                     
                 WS-BILLING-KEY-XD (WS-CALC-X-INDX)  AND                
                 WS-COMPONENT-CODE-XD(WS-CALC-X-INDX) (1:1) = 'U'       
                                                                        
                 PERFORM VARYING SUB7 FROM 1 BY 1 UNTIL                 
                 SUB7 > 80 OR WS-NEW-EQUIP-ID(SUB7) <= SPACES           
                                                                        
                    IF WS-COMPONENT-CODE-XD(WS-CALC-X-INDX) (2:1) =     
                       WS-OLD-EQUIP-ID(SUB7)                            
                       MOVE WS-NEW-EQUIP-ID(SUB7)                       
                                             TO                         
                            WS-COMPONENT-CODE-XD(WS-CALC-X-INDX) (2:1)  
                       MOVE 81               TO SUB7                    
                    END-IF                                              
                 END-PERFORM                                            
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
       2040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2060-GET-UNMTR-PROV-FL.                                         *        
      *PROCESS TO GET THE UNMTR PROVISION FLAG                         *        
      ******************************************************************        
       2060-GET-UNMTR-PROV-FL.                                          
                                                                        
           SET WS-RD-INDX                TO 1                           
           MOVE SPACES                   TO WS-HOLD-UNMTR-PROV-FL       
           SEARCH WS-RD-RATE-DATA AT END                                
                  MOVE SPACES            TO WS-HOLD-UNMTR-PROV-FL       
              WHEN WS-RD-RATE-PLAN-NO-ARR(WS-RD-INDX)   =               
                              WS-RATE-PLAN-NO-BG(WS-BILLING-INDX)       
               AND WS-RD-CODE-UTIL-TYPE-ARR(WS-RD-INDX) =               
                              WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX)     
               AND WS-RD-COMPANY-NO-ARR(WS-RD-INDX)     =               
                              WS-COMPANY-NO-BG(WS-BILLING-INDX)         
                   MOVE WS-RD-UNMTR-PROV-FL-ARR(WS-RD-INDX)             
                                         TO WS-HOLD-UNMTR-PROV-FL       
PRJ257             MOVE WS-RD-REV-CUST-CNT-CD-ARR(WS-RD-INDX)           
PRJ257                                   TO WS-HOLD-REV-CUST-CNT-CD     
           END-SEARCH.                                                  
                                                                        
       2060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2100-DDC-PROCESS                                                *        
      *PERFORMS THE DDC PROCESS                                        *        
      ******************************************************************        
       2100-DDC-PROCESS.                                                
                                                                        
           SET WS-FH-HIST-INDX           TO 1                           
           MOVE 0                        TO WS-HOLD-DDC-FACTOR.         
           SEARCH WS-FIXED-FACTR-DATA-HIST AT END                       
              MOVE 0                     TO WS-HOLD-DDC-FACTOR          
ACT154        WHEN WS-ACCOUNT-NO-FH(WS-FH-HIST-INDX) = 0                
ACT154             CONTINUE                                             
              WHEN WS-BILLING-KEY-FH(WS-FH-HIST-INDX) =                 
                   WS-BILLING-KEY(WS-BILLING-INDX)                      
               AND WS-FACTOR-ID-FH(WS-FH-HIST-INDX) = 'DDC'             
A03303        IF WS-FCTR-POWER-10-FH(WS-FH-HIST-INDX) = 0               
A03303           MOVE WS-FACTOR-FH(WS-FH-HIST-INDX)                     
A03303                                   TO WS-HOLD-DDC-FACTOR          
A03303        ELSE                                                      
A03303           MOVE WS-LONG-FACTOR-FH(WS-FH-HIST-INDX)                
A03303                                   TO WS-HOLD-DDC-FACTOR          
A03303        END-IF                                                    
           END-SEARCH.                                                  
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2150-GET-BACKOUT-DETAILS.                                       *        
      *GETS THE ORIGINAL BILL DETAILS FOR A BACKOUT ROW                         
      ******************************************************************        
       2150-GET-BACKOUT-DETAILS.                                        
                                                                        
           MOVE WS-ACCOUNT-NO-BG (WS-BILLING-INDX)                      
                                        TO BI-ACCOUNT-NO                
                                           BG-ACCOUNT-NO.               
           MOVE WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX)                   
                                        TO BG-CODE-UTIL-TYPE            
           MOVE WS-IC-NO-BG(WS-BILLING-INDX)                            
                                        TO BG-IC-NO.                    
ACT202     MOVE WS-BILL-NO-BG(WS-BILLING-INDX)                          
ACT202                                  TO BG-BILL-NO.                  
           MOVE WS-BILL-ITEM-TIMESTMP-BG (WS-BILLING-INDX)              
                                        TO BG-BILL-ITEM-TIMESTMP        
                                                                        
           PERFORM 7300-GET-ORIG-BILL-DTL                               
                                        THRU 7300-EXIT.                 
                                                                        
       2150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2200-REV-BILL-DET-PROCESS                                       *        
      *PERFORMS THE REVENUE BILL DETAIL PROCESS                        *        
      ******************************************************************        
       2200-REV-BILL-DET-PROCESS.                                       
                                                                        
           COMPUTE WS-TOTAL-BILL-ITEM-AMT =                             
                   WS-AMT-BILL-ITEM-BG(WS-BILLING-INDX) -               
                   WS-AMT-CITY-TAX-BG(WS-BILLING-INDX)  -               
                   WS-AMT-STATE-TAX-BG(WS-BILLING-INDX).                
                                                                        
A02932     COMPUTE WS-TOTAL-AMT-FOR-TAX   =                             
A02932             WS-AMT-BILL-ITEM-BG(WS-BILLING-INDX) -               
A02932             WS-AMT-STATE-TAX-BG(WS-BILLING-INDX).                
                                                                        
           PERFORM 7050-GET-CURR-TIMESTAMP     THRU 7050-EXIT           
                   UNTIL WS-PREV-TIMESTAMP NOT = WS-CURRENT-TIMESTAMP.  
                                                                        
           MOVE WS-CURRENT-TIMESTAMP     TO E-REVDET-BILL-UNIQUE-TS     
                                            WS-PREV-TIMESTAMP           
                                                                        
           MOVE WS-COMPANY-NO-AT         TO E-REVDET-COMPANY-NO         
                                            E-REVDET-REV-COMPANY-NO     
                                            Q8-COMPANY-NO               
                                                                        
           MOVE WS-REVENUE-MONTH-BG(WS-BILLING-INDX)                    
                                         TO E-REVDET-REVENUE-MONTH      
           IF WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX) = 'U'               
              PERFORM 2450-GET-SERVICE-TYPE THRU 2450-EXIT              
           ELSE                                                         
              MOVE WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX)                
                                         TO WS-HOLD-SERVICE-TYPE        
           END-IF.                                                      
           MOVE WS-HOLD-SERVICE-TYPE     TO E-REVDET-CODE-SERVICE-TYPE  
           MOVE WS-ACCOUNT-NO-BG(WS-BILLING-INDX)                       
                                         TO E-REVDET-ACCOUNT-NO         
           MOVE WS-BILL-NO-BG(WS-BILLING-INDX)                          
                                         TO E-REVDET-BILL-NO            
           MOVE WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX)                   
                                         TO E-REVDET-CODE-UTIL-TYPE     
                                            Q8-CODE-UTIL-TYPE           
           MOVE WS-IC-NO-BG(WS-BILLING-INDX)                            
                                         TO E-REVDET-IC-NO              
           MOVE WS-BILL-ITEM-TIMESTMP-BG(WS-BILLING-INDX)               
                                         TO E-REVDET-BILL-ITEM-TIMESTMP 
                                                                        
           PERFORM 2430-CUSTOMER-COUNT-PROCESS THRU 2430-EXIT           
                                                                        
           MOVE WS-USAGE-END-DATE-CALC(WS-BILLING-INDX)                 
                                         TO E-REVDET-USAGE-END-DATE     
           MOVE WS-NO-OF-CONS-DAYS-BG(WS-BILLING-INDX)                  
                                         TO E-REVDET-NO-OF-CONS-DAYS    
                                                                        
           MOVE WS-PRORATED-ON-NBR-DAYS-BG(WS-BILLING-INDX)             
                                         TO E-REVDET-PRORATED-DAYS-CD   
                                                                        
           MOVE WS-BTU-FACTOR-BG(WS-BILLING-INDX)                       
                                         TO  E-REVDET-BTU-FACTOR        
                                                                        
           MOVE WS-GAS-BASE-USE-BG(WS-BILLING-INDX)                     
                                         TO E-REVDET-GAS-BASE-USE       
ACT154     IF WS-CODE-DR-CR-CNSMPTN-BG(WS-BILLING-INDX) = 'C'           
ACT154        AND SEB-DATABASE                                          
ACT154        PERFORM 2205-GET-DDC-FACTOR THRU 2205-EXIT                
ACT154        MULTIPLY -1 BY WS-HOLD-DDC-FACTOR                         
ACT154     END-IF                                                       
           MOVE WS-HOLD-DDC-FACTOR       TO E-REVDET-DESIGN-DAY-CAP     
                                                                        
           MOVE WS-DATE-BILLED-BI        TO E-REVDET-DATE-BILLED        
                                                                        
           IF WS-DATE-ORIG-BILL-BG(WS-BILLING-INDX) <= SPACES           
              MOVE SPACES                TO E-REVDET-DATE-ORIG-BILL     
           ELSE                                                         
              MOVE WS-DATE-ORIG-BILL-BG(WS-BILLING-INDX)                
                                         TO E-REVDET-DATE-ORIG-BILL     
           END-IF                                                       
                                                                        
           MOVE WS-REV-MTH-ORIG-BILL-BG(WS-BILLING-INDX)                
                                         TO E-REVDET-REV-MTH-ORIG-BILL  
           MOVE WS-BILL-CYCLE-AT         TO E-REVDET-ACCT-BILL-CYCLE    
           MOVE WS-BILL-CALC-CYCLE-BG(WS-BILLING-INDX)                  
                                         TO E-REVDET-BILL-CALC-CYCLE    
           MOVE WS-CODE-REVENUE-CLASS-BG(WS-BILLING-INDX)(2:1)          
                                         TO E-REVDET-CODE-REV-ACCT-TYPE 
           MOVE WS-CODE-REVENUE-CLASS-BG(WS-BILLING-INDX)               
                                         TO E-REVDET-CODE-REVENUE-CLASS 
                                            Q8-CODE-REVENUE-CLASS       
           MOVE WS-RATE-PLAN-NO-BG(WS-BILLING-INDX)                     
                                         TO E-REVDET-RATE-PLAN-NO       
                                            Q8-RATE-PLAN-NO             
                                                                        
I01959     MOVE SPACES                   TO WS-NEM-RATE-DEP-CD          
           PERFORM 2210-GET-RATE-DEPT-CODE                              
                                         THRU 2210-EXIT                 
                                                                        
           IF WS-CODE-CURTAIL-PRTY-BG(WS-BILLING-INDX) NOT = 0          
              PERFORM 2220-GET-PRTY-SERV-CATEGORY                       
                                         THRU 2220-EXIT                 
           END-IF                                                       
                                                                        
           MOVE WS-CODE-SIC-NO-BG(WS-BILLING-INDX)                      
                                         TO E-REVDET-CODE-SIC-NO        
           MOVE WS-NAICS-CD-BG(WS-BILLING-INDX)                         
                                         TO E-REVDET-NAICS-CD           
           IF SEB-DATABASE                                              
              PERFORM 2640-GET-SEB-REVENUE-DATA                         
                                         THRU 2640-EXIT                 
           ELSE                                                         
              MOVE SPACES                TO E-REVDET-TIER-ACCT-TYPE-CD  
                                            E-REVDET-OPTION-CD          
                                            E-REVDET-RATE-CALC-TYPE-CD  
           END-IF                                                       
                                                                        
ACT077     IF CSR-DATABASE                                              
ACT077        IF WS-FUEL-SHIPPER-CD-BG(WS-BILLING-INDX) > SPACES        
ACT077           STRING 'SHIPPER='                 DELIMITED BY SIZE    
ACT077                   WS-FUEL-SHIPPER-CD-BG(WS-BILLING-INDX)         
ACT077                                             DELIMITED BY SIZE    
ACT077             INTO  E-REVDET-OPTION-CD                             
ACT077           END-STRING                                             
ACT077        END-IF                                                    
ACT077     END-IF                                                       
                                                                        
           MOVE WS-LOCAL-OFFICE-AT       TO E-REVDET-LOCAL-OFFICE       
           MOVE WS-REV-DISTRICT-CD-BG(WS-BILLING-INDX)                  
                                         TO E-REVDET-REV-DISTRICT-CD    
                                            F4-REV-DISTRICT-CD          
                                                                        
           PERFORM 2230-GET-MNICIPLTY-COUNTY-CD THRU 2230-EXIT          
                                                                        
           MOVE WS-PREMISE-NO-AT         TO E-REVDET-PREMISE-NO         
                                                                        
           PERFORM 2435-GET-CALC-SOURCE-CODE    THRU 2435-EXIT          
                                                                        
A04581     IF WS-COMPANY-NO-BG (WS-BILLING-INDX)     = '01' AND         
A04581        WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) = 'E'              
A04581        MOVE WS-RT-PKG-OPT-SEQ-NO-BG (WS-BILLING-INDX) TO         
A04581             E-REVDET-ELEC-WNA-GROUP-NO                           
A04581     END-IF                                                       
                                                                        
           PERFORM 8000-WRITE-FCSCREVD          THRU 8000-EXIT.         
                                                                        
           PERFORM 7230-GET-GL-ACCOUNT-NUMBER   THRU 7230-EXIT.         
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
ACT154******************************************************************        
ACT154*2205-GET-DDC-FACTOR                                             *        
ACT154*GET DDC FACTOR FROM BILL CALC FH (WHEN REV HISTORY NOT AVAILABLE*        
ACT154*BILL CALC PROGRAM CALLED FOR DETAILS)                           *        
ACT154******************************************************************        
ACT154 2205-GET-DDC-FACTOR.                                             
ACT154                                                                  
ACT154     SET  FH-INDX          TO 1                                   
ACT154     MOVE 0                TO WS-HOLD-DDC-FACTOR                  
ACT154     SEARCH WS-BC-FIXED-FACTR-DATA-HIST                           
ACT154            AT END                                                
ACT154              MOVE 0               TO WS-HOLD-DDC-FACTOR          
ACT154        WHEN WS-BC-ACCOUNT-NO-FH(FH-INDX) NOT NUMERIC             
ACT154             CONTINUE                                             
ACT154        WHEN WS-BC-ACCOUNT-NO-FH(FH-INDX) = 0                     
ACT154             CONTINUE                                             
ACT154        WHEN WS-BC-ACCOUNT-NO-FH (FH-INDX)                        
ACT154                 = WS-ACCOUNT-NO-BG (WS-BILLING-INDX)             
ACT154         AND WS-BC-CODE-UTIL-TYPE-FH (FH-INDX)                    
ACT154                 = WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)         
ACT154         AND WS-BC-IC-NO-FH (FH-INDX)                             
ACT154                 = WS-IC-NO-BG (WS-BILLING-INDX)                  
ACT154         AND WS-BC-BILL-ITEM-TIMESTMP-FH (FH-INDX)                
ACT154                 = WS-BILL-ITEM-TIMESTMP-BG (WS-BILLING-INDX)     
ACT154         AND WS-BC-FACTOR-ID-FH(FH-INDX) = 'DDC'                  
ACT154            IF WS-BC-FCTR-POWER-10-FH(FH-INDX) = 0                
ACT154               MOVE WS-BC-FACTOR-FH(FH-INDX)                      
ACT154                                   TO WS-HOLD-DDC-FACTOR          
ACT154            ELSE                                                  
ACT154               MOVE WS-BC-LONG-FACTOR-FH(FH-INDX)                 
ACT154                                   TO WS-HOLD-DDC-FACTOR          
ACT154            END-IF                                                
ACT154     END-SEARCH.                                                  
ACT154                                                                  
ACT154 2205-EXIT.                                                       
ACT154     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2210-GET-RATE-DEPT-CODE                                         *        
      *PROCESS TO GET THE RATE DEPARTMENT CODE                         *        
      ******************************************************************        
       2210-GET-RATE-DEPT-CODE.                                         
                                                                        
           SET WS-RD-INDX                TO 1                           
           SEARCH WS-RD-RATE-DATA AT END                                
                  MOVE SPACES            TO E-REVDET-RATE-DEPT-CD       
              WHEN WS-RD-RATE-PLAN-NO-ARR(WS-RD-INDX)   =               
                              WS-RATE-PLAN-NO-BG(WS-BILLING-INDX)       
               AND WS-RD-CODE-UTIL-TYPE-ARR(WS-RD-INDX) =               
                              WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX)     
               AND WS-RD-COMPANY-NO-ARR(WS-RD-INDX)     =               
                              WS-COMPANY-NO-BG(WS-BILLING-INDX)         
                   MOVE WS-RD-RATE-DEPT-CODE-ARR(WS-RD-INDX)            
                                         TO E-REVDET-RATE-DEPT-CD       
                                            WS-NEM-RATE-DEP-CD          
                   MOVE WS-RD-RATE-CALC-TYPE-CD-ARR(WS-RD-INDX)         
                                         TO WS-HOLD-RATE-CALC-TYPE-CD   
           END-SEARCH.                                                  
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2220-GET-PRTY-SERV-CATEGORY.                                    *        
      *PROCESS TO GET THE PRIORITY SERVICE CATEGORY                    *        
      ******************************************************************        
       2220-GET-PRTY-SERV-CATEGORY.                                     
                                                                        
           SET WS-Z4-INDX                TO 1.                          
           SEARCH WS-Z4-SVC-CAT-DATA    AT END                          
                  MOVE SPACES            TO E-REVDET-PRTY-SVC-CAT-CD    
              WHEN WS-Z4-CODE-CURTAIL-PRTY-ARR(WS-Z4-INDX) =            
                   WS-CODE-CURTAIL-PRTY-BG(WS-BILLING-INDX)             
               AND WS-Z4-COMPANY-NO-ARR(WS-Z4-INDX) =                   
                   WS-COMPANY-NO-AT                                     
                   MOVE WS-Z4-PRTY-SVC-CAT-CD-ARR(WS-Z4-INDX)           
                                         TO E-REVDET-PRTY-SVC-CAT-CD    
           END-SEARCH.                                                  
                                                                        
       2220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2230-GET-MNICIPLTY-COUNTY-CD.                                   *        
      *PROCESS TO GET THE MUNICIPALITY COUNTY CODE.                    *        
      ******************************************************************        
       2230-GET-MNICIPLTY-COUNTY-CD.                                    
                                                                        
           MOVE SPACES                   TO F4-MNICPLTY-COUNTY-CD.      
           PERFORM 7210-GET-MNICIPLTY-COUNTY-CD THRU 7210-EXIT.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE SPACES                TO F4-MNICPLTY-COUNTY-CD       
           END-IF.                                                      
                                                                        
           MOVE F4-MNICPLTY-COUNTY-CD    TO E-REVDET-MNICPLTY-COUNTY-CD.
                                                                        
       2230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2250-CHECK-RATE-PRORATION                                       *        
      *PROCESS TO CHECK THE RATE PRORATION                             *        
      ******************************************************************        
       2250-CHECK-RATE-PRORATION.                                       
      *                                                                         
           MOVE SPACES           TO SF-FACTOR-ID                        
      *                                                                         
           IF WS-BILLING-KEY (WS-BILLING-INDX) =                        
              WS-BILLING-KEY-BA (WS-BILL-ADJ-INDX)                      
                                                                        
              MOVE WS-FACTOR-ID-BA(WS-BILL-ADJ-INDX)                    
                                 TO SF-FACTOR-ID                        
                                                                        
              PERFORM 2800-GET-PRORATE-FL                               
                                 THRU 2800-EXIT                         
                                                                        
      * LOADING THE RATE VERSION AND PERCENTAGE INTO WS ARRAY                   
PRJ257                                                                  
PRJ257        IF WS-SPCL-GROUP-CD-BA(WS-BILL-ADJ-INDX) = 'MN'           
PRJ257           SET MONTHLY-MIN TO  TRUE                               
PRJ257        END-IF                                                    
PRJ257                                                                  
              ADD 1              TO WS-HOLD-BA-SEQ-NO                   
              MOVE WS-HOLD-BA-SEQ-NO                                    
                                 TO WS-ITEM-SEQ-NO-BA(WS-BILL-ADJ-INDX) 
              IF WS-FACTOR-ID-BA(WS-BILL-ADJ-INDX) = 'RTPROPCT'         
                 SET PRORATED    TO TRUE                                
                 MOVE WS-FCT-RATE-VERSION-BA(WS-BILL-ADJ-INDX)          
                                 TO WS-BC-RATE-VER(WS-RT-VRSN-INDX)     
                 MOVE WS-FACTOR-BA(WS-BILL-ADJ-INDX)                    
                                 TO WS-BC-RATE-PERCENT(WS-RT-VRSN-INDX) 
                 MOVE WS-FCT-CMPNT-ID-BA(WS-BILL-ADJ-INDX)              
                                 TO                                     
                                 WS-BC-COMP-CODE(WS-RT-VRSN-INDX)       
                 MOVE WS-FCT-CNSMPT-TYPE-BA(WS-BILL-ADJ-INDX)           
                                 TO                                     
                                 WS-BC-CNSMPTN-TYPE(WS-RT-VRSN-INDX)    
                 MOVE WS-FCT-REGISTER-TYPE-BA(WS-BILL-ADJ-INDX)         
                                 TO                                     
                                 WS-BC-REG-TYPE(WS-RT-VRSN-INDX)        
                 MOVE WS-FCT-TOU-BA(WS-BILL-ADJ-INDX)                   
                                 TO                                     
                                 WS-BC-TOU-CD(WS-RT-VRSN-INDX)          
                 MOVE WS-FCT-SEASON-BA(WS-BILL-ADJ-INDX)                
                                 TO                                     
                                 WS-BC-SEASON-CD(WS-RT-VRSN-INDX)       
                 SET WS-RT-VRSN-INDX UP BY 1                            
              END-IF                                                    
                                                                        
              IF WS-AMT-ADJUSTMENT-BA(WS-BILL-ADJ-INDX) NOT NUMERIC     
                 MOVE ZEROES     TO                                     
                                 WS-AMT-ADJUSTMENT-BA(WS-BILL-ADJ-INDX) 
              END-IF                                                    
                                                                        
              IF WS-ADJ-UNITS-BA(WS-BILL-ADJ-INDX) NOT NUMERIC          
                 MOVE ZEROES     TO                                     
                                 WS-ADJ-UNITS-BA(WS-BILL-ADJ-INDX)      
              END-IF                                                    
      * FOR BACKOUT BG'S MULTIPLY USAGE AND BILL AMOUNTS FOR BA BY -1           
              IF WS-CODE-BILL-ITM-TYPE-BG(WS-BILLING-INDX) = 'B'        
      * THE OR CONDITION NEEDS TO BE REMOVED THIS HAS BEEN ADDED TO             
      * MATCH THE CURRENT REVENUE REPORTS.                                      
              OR WS-CODE-DR-CR-CNSMPTN-BG(WS-BILLING-INDX) = 'C'        
                 MULTIPLY -1 BY WS-AMT-ADJUSTMENT-BA(WS-BILL-ADJ-INDX)  
                 MULTIPLY -1 BY WS-ADJ-UNITS-BA(WS-BILL-ADJ-INDX)       
              END-IF                                                    
      * FOR SUBTRACTIVE FACTORS MULTIPLY USAGE AND ADJUSTMENT AMT BY -1         
              IF WS-CODE-ADJUST-TYPE-BA(WS-BILL-ADJ-INDX) =             
                 'H' OR 'I' OR 'J' OR 'K' OR 'O'                        
                 MULTIPLY -1 BY WS-AMT-ADJUSTMENT-BA(WS-BILL-ADJ-INDX)  
                 MULTIPLY -1 BY WS-ADJ-UNITS-BA(WS-BILL-ADJ-INDX)       
              END-IF                                                    
                                                                        
           END-IF.                                                      
                                                                        
       2250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2260-CHECK-CONSUMPTION-TYPE                                     *        
      *PROCESS TO CHECK THE CONSUMPTION TYPE                           *        
      ******************************************************************        
       2260-CHECK-CONSUMPTION-TYPE.                                     
      *                                                                         
           IF WS-BILLING-KEY (WS-BILLING-INDX) =                        
              WS-BILLING-KEY-BC (WS-CALC-INDX)                          
                                                                        
              EVALUATE WS-CONSUMPTION-TYPE-BC(WS-CALC-INDX)             
                 WHEN 'B'                                               
                    SET ELECT-KWH        TO TRUE                        
                    ADD WS-READ-UNITS-BC(WS-CALC-INDX)                  
                                         TO WS-TEMP-READ-UNITS-ELE      
                 WHEN 'J'                                               
                    SET ELECT-DEMAND-KW  TO TRUE                        
                    ADD WS-READ-UNITS-BC(WS-CALC-INDX)                  
                                         TO WS-TEMP-READ-UNITS-KW       
                 WHEN 'E'                                               
                    SET ELECT-DEMAND-KVA TO TRUE                        
                    ADD WS-READ-UNITS-BC(WS-CALC-INDX)                  
                                         TO WS-TEMP-READ-UNITS-KVA      
                 WHEN 'C'                                               
                    ADD WS-READ-UNITS-BC(WS-CALC-INDX)                  
                                         TO WS-TEMP-READ-UNITS-GAS      
                 WHEN 'D'                                               
                    COMPUTE WS-TEMP-READ-UNITS-GAS =                    
                            WS-READ-UNITS-BC(WS-CALC-INDX) * 10 +       
                            WS-TEMP-READ-UNITS-GAS                      
                 WHEN OTHER                                             
                    CONTINUE                                            
              END-EVALUATE                                              
A02932        ADD 1                      TO WS-TEMP-BC-SEQ-NO           
      * FOR BACKOUT BG'S MULTIPLY USAGE AND BILL AMOUNTS FOR BC BY -1           
                                                                        
              IF WS-CODE-BILL-ITM-TYPE-BG(WS-BILLING-INDX) = 'B'        
      * THE OR CONDITION NEEDS TO BE REMOVED THIS HAS BEEN ADDED TO             
      * MATCH THE CURRENT REVENUE REPORTS.                                      
              OR WS-CODE-DR-CR-CNSMPTN-BG(WS-BILLING-INDX) = 'C'        
                 PERFORM 2620-PROCESS-BACKOUT-BC-DTL                    
                                         THRU 2620-EXIT                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *PROCESS ADDITIONAL BILL CALC DETAILS.                          *         
      *2270-GET-ADDT-BILL-CALC-DET                                    *         
      *****************************************************************         
       2270-GET-ADDT-BILL-CALC-DET.                                     
                                                                        
           SET REGULAR-BILL             TO TRUE.                        
           SET WS-CALC-X-INDX           TO 1                            
               SEARCH WS-BILL-CALC-X-DATA                               
                   WHEN WS-BILLING-KEY-XD(WS-CALC-X-INDX)               
                         = WS-BILLING-KEY-BC(WS-CALC-INDX)              
                    AND WS-COMPONENT-KEY-XD(WS-CALC-X-INDX)             
                         = WS-COMPONENT-KEY-BC(WS-CALC-INDX)            
P00496              AND WS-EVENT-NUMBER-XD(WS-CALC-X-INDX)              
P00496                   = WS-EVENT-NUMBER-BC(WS-CALC-INDX)             
                   MOVE WS-RATE-FROM-DATE-XD(WS-CALC-X-INDX)            
                                        TO WS-HOLD-RT-VERS-FROM-DT      
                   MOVE WS-VERS-PRO-CD-XD(WS-CALC-X-INDX)               
                                        TO WS-HOLD-RT-VERS-PRO-CD       
                   MOVE WS-NO-LIGHT-POLE-UNITS-XD(WS-CALC-X-INDX)       
                                        TO WS-HOLD-BLK-BILL-LT-POLES    
                   MOVE WS-KW-MDQ-DT-XD(WS-CALC-X-INDX)                 
                                        TO WS-HOLD-KW-MDQ-DT            
                   MOVE WS-KVA-DT-XD(WS-CALC-X-INDX)                    
                                        TO WS-HOLD-KVA-DT               
               END-SEARCH.                                              
                                                                        
       2270-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2280-EXCLUDE-FACTOR-PROCESS.                                    *        
      *PROCESS TO EXCLUDE ANY FACTORS FROM THE REVENUE PROCESS         *        
      ******************************************************************        
       2280-EXCLUDE-FACTOR-PROCESS.                                     
      *                                                                         
           PERFORM VARYING WS-UV-INDX FROM 1 BY 1                       
                   UNTIL WS-UV-INDX > 50 OR                             
                   WS-UV-RATE-PLAN-NO(WS-UV-INDX) = SPACES              
                                                                        
              IF WS-UV-RATE-PLAN-NO(WS-UV-INDX) =                       
                 WS-RATE-PLAN-NO-BG(WS-BILLING-INDX) AND                
                 WS-UV-FACTOR-ID(WS-UV-INDX)    =                       
                 WS-FACTOR-ID-BA(WS-BILL-ADJ-INDX)   AND                
                 WS-UV-RATE-ITEM-CODE(WS-UV-INDX) =                     
                 WS-RATE-ITEM-CODE-BC(WS-CALC-INDX)                     
                                                                        
      * BASED ON THE REVENUE TYPE CHANGE THE REVENUE-INTERFACE-FL TO            
      * NOT TRACK THIS FACTOR.                                                  
                                                                        
                 IF WS-REV-INTERFACE-FL-BA(WS-BILL-ADJ-INDX) = 'S'      
                    MOVE 'Y'                TO                          
                               WS-REV-INTERFACE-FL-BA(WS-BILL-ADJ-INDX) 
                 ELSE                                                   
                    IF WS-REV-INTERFACE-FL-BA(WS-BILL-ADJ-INDX) = 'M'   
                       MOVE 'N'             TO                          
                               WS-REV-INTERFACE-FL-BA(WS-BILL-ADJ-INDX) 
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
       2280-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2300-REBILL-PROCESS                                             *        
      *REBILL PROCESS                                                  *        
      ******************************************************************        
       2300-REBILL-PROCESS.                                             
                                                                        
           PERFORM 5500-SETUP-FOR-CALC          THRU 5500-EXIT.         
           PERFORM 5800-CALL-BILL-CALC          THRU 5800-EXIT.         
                                                                        
           IF WS-CALC-ERROR   NOT = SPACES                              
              PERFORM 9200-SCSCA-ERROR          THRU 9200-EXIT          
           END-IF                                                       
                                                                        
      * USAGE END DATE IN THE BG RECORD IS SOMETIMES NOT POPULATED FOR          
      * BACKOUT ROWS.                                                           
                                                                        
           IF WS-USAGE-END-DATE-CALC(WS-BILLING-INDX) = SPACES AND      
              WS-BC-CNSMPTN-END-DATE > SPACES                           
              MOVE WS-BC-CNSMPTN-END-DATE       TO                      
                   WS-USAGE-END-DATE-CALC(WS-BILLING-INDX)              
           END-IF                                                       
                                                                        
      * LOADING THE ADDITIONAL BILL CALC ROWS                                   
                                                                        
           PERFORM 2310-LOAD-ADDNL-BILL-CALC-ROWS                       
                                                THRU 2310-EXIT          
                                                                        
      * LOADING THE ADDITIONAL XD BILL CALC ROWS                                
                                                                        
           PERFORM 2330-LOAD-XD-BILL-CALC-ROWS  THRU 2330-EXIT          
                                                                        
      * LOADING THE ADDITIONAL BILL ADJUSTMENT ROWS                             
                                                                        
           PERFORM 2320-LOAD-ADDNL-BILL-ADJT-ROWS                       
                                                THRU 2320-EXIT.         
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2310-LOAD-ADDNL-BILL-CALC-ROWS                                  *        
      *LOADING THE ADDITIONAL BILL CALC ROWS                           *        
      ******************************************************************        
       2310-LOAD-ADDNL-BILL-CALC-ROWS.                                  
                                                                        
           PERFORM VARYING BC-INDX FROM 1 BY 1 UNTIL                    
              BC-INDX > WS-BZ-MAX-ENTRY OR                              
              WS-BC-COMPONENT-ID(BC-INDX) = SPACE                       
      *                                                                         
              SET WS-CALC-INDX   TO 1                                   
                                                                        
              SEARCH WS-BILL-CALC-DATA                                  
                 WHEN WS-ACCOUNT-NO-BC(WS-CALC-INDX) = ZERO             
                    MOVE WS-BILLING-KEY (WS-BILLING-INDX)               
                                 TO WS-BILLING-KEY-BC (WS-CALC-INDX)    
                    MOVE WS-BC-COMPONENT (BC-INDX)                      
                                 TO WS-COMPONENT-DATA-BC (WS-CALC-INDX) 
              END-SEARCH                                                
           END-PERFORM.                                                 
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2320-LOAD-ADDNL-BILL-ADJT-ROWS                                  *        
      *LOADING THE ADDITIONAL BILL ADJUSTMENT ROWS                     *        
      ******************************************************************        
       2320-LOAD-ADDNL-BILL-ADJT-ROWS.                                  
                                                                        
           PERFORM VARYING BA-INDX FROM 1 BY 1 UNTIL                    
              BA-INDX > WS-BA-MAX-ENTRY OR                              
              WS-BC-FACTOR-ID(BA-INDX) = SPACE                          
      *                                                                         
              SET WS-BILL-ADJ-INDX TO 1                                 
                                                                        
              SEARCH WS-BILL-ADJ-DATA                                   
                 WHEN WS-ACCOUNT-NO-BA(WS-BILL-ADJ-INDX) = ZERO         
                    IF WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX) = 'E' AND  
P00496*COMMENTED HARD-CODED FACTOR LIST. USE MULTI-VRSN-BA-CD INSTEAD           
P00496*                WS-BC-FACTOR-ID(BA-INDX) NOT = 'BFACCHRG'   AND          
P00496*                WS-BC-FACTOR-ID(BA-INDX) NOT = 'RTPROPCT'   AND          
P00496*                WS-BC-FACTOR-ID(BA-INDX) NOT = 'WNA-AMT'    AND          
P00496                 WS-BC-FCT-RATE-VERSION(BA-INDX) NOT = '1'   AND  
P00496                 WS-BC-MULTI-VRSN-BA-CD(BA-INDX) NOT = 'A'        
                       CONTINUE                                         
                    ELSE                                                
                       MOVE WS-BILLING-KEY (WS-BILLING-INDX)            
                             TO WS-BILLING-KEY-BA (WS-BILL-ADJ-INDX)    
                       MOVE WS-BC-ADJUSTMENT(BA-INDX)                   
                             TO WS-ADJUSTMENT-DATA-BA(WS-BILL-ADJ-INDX) 
                    END-IF                                              
              END-SEARCH                                                
           END-PERFORM.                                                 
                                                                        
       2320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2330-LOAD-XD-BILL-CALC-ROWS                                     *        
      *LOADING THE ADDITIONAL XD BILL CALC ROWS                        *        
      ******************************************************************        
       2330-LOAD-XD-BILL-CALC-ROWS.                                     
                                                                        
           PERFORM VARYING WS-CALC-INDX-X FROM 1 BY 1 UNTIL             
              WS-CALC-INDX-X > WS-BZ-MAX-ENTRY OR                       
              WS-BC-COMPONENT-ID-XD(WS-CALC-INDX-X) = SPACE             
      *                                                                         
              SET WS-CALC-X-INDX TO 1                                   
                                                                        
              SEARCH WS-BILL-CALC-X-DATA                                
                 WHEN WS-ACCOUNT-NO-XD(WS-CALC-X-INDX) = ZERO           
                   IF WS-BILL-CALC-DATA-X(WS-CALC-INDX-X) > SPACES      
                      MOVE WS-BILLING-KEY (WS-BILLING-INDX)             
                                 TO WS-BILLING-KEY-XD (WS-CALC-X-INDX)  
                      MOVE WS-BILL-CALC-DATA-X(WS-CALC-INDX-X)          
                                 TO WS-COMPONENT-DATA-XD(WS-CALC-X-INDX)
                   END-IF                                               
              END-SEARCH                                                
           END-PERFORM.                                                 
                                                                        
       2330-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2400-BILL-ADJUSTMENT-PROCESS                                    *        
      *BILL ADJUSTMENT PROCESS                                         *        
      ******************************************************************        
       2400-BILL-ADJUSTMENT-PROCESS.                                    
                                                                        
           PERFORM 2280-EXCLUDE-FACTOR-PROCESS                          
                                      THRU 2280-EXIT.                   
                                                                        
           IF WS-REV-INTERFACE-FL-BA(WS-BILL-ADJ-INDX) = 'N' AND        
              WS-FACTOR-COMPONENT-BA(WS-BILL-ADJ-INDX)                  
                            = WS-COMPONENT-KEY-BC(WS-CALC-INDX)         
                 COMPUTE WS-TEMP-REVADJ-AMT ROUNDED =                   
                         WS-AMT-ADJUSTMENT-BA (WS-BILL-ADJ-INDX)        
                 COMPUTE WS-NONUTIL-REV-NOT-TRACKED ROUNDED =           
                         WS-TEMP-REVADJ-AMT +                           
                         WS-NONUTIL-REV-NOT-TRACKED                     
           END-IF.                                                      
           IF WS-REV-INTERFACE-FL-BA(WS-BILL-ADJ-INDX) = 'S' OR 'M'     
              AND WS-CODE-ADJUST-TYPE-BA(WS-BILL-ADJ-INDX) NOT = 'T'    
                                                                        
              ADD 1                   TO WS-RUNNING-COUNTER             
      *POPULATING REVENUE DETAIL ADJUSTMENT FILE                                
                                                                        
              MOVE WS-CURRENT-TIMESTAMP                                 
                                      TO E-REVADJ-BILL-UNIQUE-TS        
                                                                        
              MOVE WS-RUNNING-COUNTER TO E-REVADJ-BILL-COMP-SEQ-NO      
                                                                        
              MOVE WS-CONSUMPTION-TYPE-BC(WS-CALC-INDX)                 
                                      TO WS-HOLD-CNSMPTN-TYPE           
                                                                        
              PERFORM 2650-LOAD-REV-BILL-COMP-ADJ                       
                                      THRU 2650-EXIT                    
                                                                        
      *FACTOR ID IS STORED IN WORKING STORAGE ARRAY                             
              PERFORM VARYING WS-HLD-FCTR-INDX FROM 1 BY 1 UNTIL        
              WS-HLD-FCTR-INDX > 200 OR                                 
              WS-HOLD-FACTOR-ID(WS-HLD-FCTR-INDX) <= SPACES             
                                                                        
              IF WS-HOLD-FACTOR-ID(WS-HLD-FCTR-INDX) =                  
                 WS-FACTOR-ID-BA(WS-BILL-ADJ-INDX) AND                  
                 WS-HOLD-FCTR-RATE-VER(WS-HLD-FCTR-INDX) =              
                 WS-FCT-RATE-VERSION-BA(WS-BILL-ADJ-INDX) AND           
                 WS-HOLD-FCTR-FROM-DT(WS-HLD-FCTR-INDX) =               
                 WS-RATE-FROM-DATE-BA(WS-BILL-ADJ-INDX) AND             
                 WS-HOLD-FCTR-CMPNT-ID(WS-HLD-FCTR-INDX) =              
                 WS-FCT-CMPNT-ID-BA(WS-BILL-ADJ-INDX)     AND           
                 WS-HOLD-FCTR-CNSMPTN-TYPE(WS-HLD-FCTR-INDX) =          
                 WS-FCT-CNSMPT-TYPE-BA(WS-BILL-ADJ-INDX)  AND           
                 WS-HOLD-FCTR-REG-TYPE(WS-HLD-FCTR-INDX) =              
                 WS-FCT-REGISTER-TYPE-BA(WS-BILL-ADJ-INDX) AND          
                 WS-HOLD-FCTR-TOU-CD(WS-HLD-FCTR-INDX) =                
                 WS-FCT-TOU-BA(WS-BILL-ADJ-INDX)          AND           
                 WS-HOLD-FCTR-SEASON-CD(WS-HLD-FCTR-INDX) =             
                 WS-FCT-SEASON-BA(WS-BILL-ADJ-INDX)       AND           
                 WS-ITEM-SEQ-NO-BA(WS-BILL-ADJ-INDX)      =             
                 WS-HOLD-FCTR-SEQ-NO(WS-HLD-FCTR-INDX)    AND           
                 WS-PRORATE-FL-TEMP NOT = 'R'                           
                 SET WS-HLD-FCTR-INDX1 TO WS-HLD-FCTR-INDX              
              END-IF                                                    
              END-PERFORM                                               
                                                                        
      *SOME FACTORS LIKE WNA NEED SPECIAL PROCESSING TO GET THE PROPER          
      *PRORATED USAGE.                                                          
              IF PRORATED AND                                           
                 WS-PRORATE-FL-TEMP  = 'R'                              
                 PERFORM 2410-PROCESS-BC-PRORATED-FCTR                  
                                      THRU 2410-EXIT                    
              END-IF                                                    
                                                                        
              SET WS-TMP-FCTR-INDX    TO WS-TMP-FCTR-INDX1              
              SET WS-HLD-FCTR-INDX    TO WS-HLD-FCTR-INDX1              
              SET WS-HLD-FCTR-INDX1 UP BY 1                             
              MOVE WS-FCT-CMPNT-ID-BA(WS-BILL-ADJ-INDX)                 
                                      TO                                
                          WS-HOLD-FCTR-CMPNT-ID(WS-HLD-FCTR-INDX)       
                          WS-TEMP-FCTR-CMPNT-ID(WS-TMP-FCTR-INDX)       
              MOVE WS-FCT-CNSMPT-TYPE-BA(WS-BILL-ADJ-INDX)              
                                      TO                                
                          WS-HOLD-FCTR-CNSMPTN-TYPE(WS-HLD-FCTR-INDX)   
                          WS-TEMP-FCTR-CNSMPTN-TYPE(WS-TMP-FCTR-INDX)   
              MOVE WS-FCT-REGISTER-TYPE-BA(WS-BILL-ADJ-INDX)            
                                      TO                                
                          WS-HOLD-FCTR-REG-TYPE(WS-HLD-FCTR-INDX)       
                          WS-TEMP-FCTR-REG-TYPE(WS-TMP-FCTR-INDX)       
              MOVE WS-FCT-TOU-BA(WS-BILL-ADJ-INDX)                      
                                      TO                                
                          WS-HOLD-FCTR-TOU-CD(WS-HLD-FCTR-INDX)         
                          WS-TEMP-FCTR-TOU-CD(WS-TMP-FCTR-INDX)         
              MOVE WS-FCT-SEASON-BA(WS-BILL-ADJ-INDX)                   
                                      TO                                
                          WS-HOLD-FCTR-SEASON-CD(WS-HLD-FCTR-INDX)      
                          WS-TEMP-FCTR-SEASON-CD(WS-TMP-FCTR-INDX)      
              MOVE WS-FCT-RATE-VERSION-BA(WS-BILL-ADJ-INDX)             
                                      TO                                
                          WS-HOLD-FCTR-RATE-VER(WS-HLD-FCTR-INDX)       
                          WS-TEMP-FCTR-RATE-VER(WS-TMP-FCTR-INDX)       
              MOVE WS-FACTOR-ID-BA(WS-BILL-ADJ-INDX)                    
                                      TO                                
                                     E-REVADJ-FACTOR-ID                 
                                     WS-HOLD-FACTOR-ID(WS-HLD-FCTR-INDX)
                                     WS-TEMP-FACTOR-ID(WS-TMP-FCTR-INDX)
                                                                        
              MOVE WS-BLOCK-NO-BA(WS-BILL-ADJ-INDX)                     
                                      TO E-REVADJ-FACTOR-BLOCK-NO       
                                                                        
              MOVE WS-RATE-FROM-DATE-BA(WS-BILL-ADJ-INDX)               
                                      TO E-REVADJ-RT-FCT-FROM-DT        
                          WS-HOLD-FCTR-FROM-DT(WS-HLD-FCTR-INDX)        
                          WS-TEMP-FCTR-FROM-DT(WS-TMP-FCTR-INDX)        
                                                                        
              MOVE WS-ITEM-SEQ-NO-BA(WS-BILL-ADJ-INDX)                  
                                      TO                                
                          WS-HOLD-FCTR-SEQ-NO(WS-HLD-FCTR-INDX)         
                          WS-TEMP-FCTR-SEQ-NO(WS-TMP-FCTR-INDX)         
                                                                        
              MOVE WS-PRORATE-CD-BA(WS-BILL-ADJ-INDX)                   
                                      TO E-REVADJ-RT-FCT-PRO-CD         
              MOVE ZEROES             TO WS-TEMP-REVADJ-AMT             
                                                                        
      *GET THE CORRECT READ UNITS FOR FIXED USAGE LIGHTS AND                    
      *THE CORRECT ADJUSTMENT AMOUNT                                            
              IF WS-FIXED-UM-KWH-BC(WS-CALC-INDX) > 0   AND             
                 WS-RATE-VERSION-BC(WS-CALC-INDX) > 1   AND             
                 WS-CODE-CALC-TYPE-BA(WS-BILL-ADJ-INDX) = 'D'           
                 COMPUTE WS-TEMP-READ-UNITS ROUNDED =                   
                              (WS-FIXED-UM-KWH-BC(WS-CALC-INDX) *       
                               WS-UNITS-BILLED-BC(WS-CALC-INDX 1)) /    
                               WS-CUST-PER-SERVICE-BC(WS-CALC-INDX)     
ACT004           IF WS-CODE-BILL-ITM-TYPE-BG                            
ACT004                                (WS-BILLING-INDX) = 'B'           
ACT004              MULTIPLY -1 BY WS-TEMP-READ-UNITS                   
ACT004           END-IF                                                 
                 IF WS-TEMP-READ-UNITS NOT =                            
                                  WS-ADJ-UNITS-BA (WS-BILL-ADJ-INDX)    
                    COMPUTE WS-TEMP-REVADJ-AMT ROUNDED =                
                              WS-TEMP-READ-UNITS *                      
                              WS-FACTOR-BA(WS-BILL-ADJ-INDX)            
                    COMPUTE WS-TEMP-REVADJ-AMT ROUNDED =                
                              WS-TEMP-REVADJ-AMT *                      
                              WS-TEMP-RATE-PERCENT                      
                    COMPUTE WS-TEMP-READ-UNITS ROUNDED =                
                              WS-TEMP-READ-UNITS *                      
                              WS-TEMP-RATE-PERCENT                      
                    MOVE WS-TEMP-READ-UNITS                             
                                      TO                                
                                WS-ADJ-UNITS-BA (WS-BILL-ADJ-INDX)      
                    MOVE ZEROES       TO                                
                          WS-HOLD-FCTR-REV-AMT(WS-HLD-FCTR-INDX)        
                          WS-HOLD-FCTR-CALC-UNITS(WS-HLD-FCTR-INDX)     
                 ELSE                                                   
                    COMPUTE WS-TEMP-REVADJ-AMT ROUNDED =                
                         WS-AMT-ADJUSTMENT-BA (WS-BILL-ADJ-INDX)        
                 END-IF                                                 
              ELSE                                                      
                 COMPUTE WS-TEMP-REVADJ-AMT ROUNDED =                   
                      WS-AMT-ADJUSTMENT-BA (WS-BILL-ADJ-INDX)           
              END-IF                                                    
                                                                        
      *FACTOR REVENUE AMOUNT LOGIC SPECIFIC TO EACH FACTOR                      
                                                                        
              IF PRORATED AND                                           
                 WS-PRORATE-FL-TEMP NOT = 'R'                           
                 IF (WS-FCT-RATE-VERSION-BA(WS-BILL-ADJ-INDX) =         
                     WS-HOLD-RATE-VERSION  AND                          
                     WS-RATE-VERSION-BC(WS-CALC-INDX)     =             
                     WS-HOLD-RATE-VERSION) OR                           
                    (WS-RATE-VERSION-BC(WS-CALC-INDX) NOT =             
                       WS-FCT-RATE-VERSION-BA(WS-BILL-ADJ-INDX) AND     
                     WS-RATE-VERSION-BC(WS-CALC-INDX)     =             
                     WS-HOLD-RATE-VERSION)                              
                                                                        
                    COMPUTE E-REVADJ-BILLED-AMT ROUNDED =               
                      WS-TEMP-REVADJ-AMT -                              
                     WS-HOLD-FCTR-REV-AMT(WS-HLD-FCTR-INDX)             
                    COMPUTE E-REVADJ-CALC-UNITS ROUNDED =               
                          WS-ADJ-UNITS-BA (WS-BILL-ADJ-INDX) -          
                          WS-HOLD-FCTR-CALC-UNITS(WS-HLD-FCTR-INDX)     
                 ELSE                                                   
                    COMPUTE E-REVADJ-BILLED-AMT ROUNDED =               
                          WS-TEMP-REVADJ-AMT *                          
                          WS-TEMP-RATE-PERCENT                          
                    COMPUTE WS-HOLD-FCTR-REV-AMT(WS-HLD-FCTR-INDX)      
                    ROUNDED = E-REVADJ-BILLED-AMT +                     
                              WS-HOLD-FCTR-REV-AMT(WS-HLD-FCTR-INDX)    
                    COMPUTE E-REVADJ-CALC-UNITS ROUNDED =               
                          WS-ADJ-UNITS-BA(WS-BILL-ADJ-INDX) *           
                          WS-TEMP-RATE-PERCENT                          
                    ADD E-REVADJ-CALC-UNITS                             
                                   TO                                   
                        WS-HOLD-FCTR-CALC-UNITS(WS-HLD-FCTR-INDX)       
                 END-IF                                                 
              ELSE                                                      
                 COMPUTE E-REVADJ-BILLED-AMT ROUNDED =                  
                      WS-AMT-ADJUSTMENT-BA (WS-BILL-ADJ-INDX)           
      * FACTORS WITH PRORATE FLAG = 'R' AND CONSUMPTION (LIKE WNA)              
      * NEED TO BE TREATED DIFFERENTLY TO GET THE CORRECT CALC UNITS.           
                                                                        
                 IF PRORATED AND                                        
                    WS-ADJ-UNITS-BA(WS-BILL-ADJ-INDX) > 0   AND         
                    WS-PRORATE-FL-TEMP = 'R'                            
                    IF WS-FCT-RATE-VERSION-BA(WS-BILL-ADJ-INDX) > '1'   
                       AND WS-TEMP-FCTR-ADJ-UNITS(WS-TMP-FCTR-INDX) =   
                           WS-ADJ-UNITS-BA(WS-BILL-ADJ-INDX)            
                                                                        
                       COMPUTE E-REVADJ-CALC-UNITS =                    
                          WS-ADJ-UNITS-BA(WS-BILL-ADJ-INDX) -           
                          WS-TEMP-FCTR-CALC-UNITS(WS-TMP-FCTR-INDX)     
                    ELSE                                                
                       COMPUTE E-REVADJ-CALC-UNITS ROUNDED =            
                          WS-ADJ-UNITS-BA(WS-BILL-ADJ-INDX) *           
                          WS-TEMP-RATE-PERCENT                          
                       ADD  E-REVADJ-CALC-UNITS                         
                                      TO                                
                          WS-TEMP-FCTR-CALC-UNITS(WS-TMP-FCTR-INDX)     
                      IF WS-FCT-RATE-VERSION-BA(WS-BILL-ADJ-INDX) = '1' 
                         MOVE WS-ADJ-UNITS-BA(WS-BILL-ADJ-INDX)         
                                      TO                                
                          WS-TEMP-FCTR-ADJ-UNITS(WS-TMP-FCTR-INDX)      
                      END-IF                                            
                    END-IF                                              
                    SET WS-TMP-FCTR-INDX1 UP BY 1                       
                 ELSE                                                   
                    MOVE WS-ADJ-UNITS-BA(WS-BILL-ADJ-INDX)              
                                      TO E-REVADJ-CALC-UNITS            
                 END-IF                                                 
              END-IF                                                    
                                                                        
              MOVE WS-FACTOR-BA(WS-BILL-ADJ-INDX)                       
                                      TO E-REVADJ-FACTOR                
              IF WS-FACTOR-BA(WS-BILL-ADJ-INDX) = 0                     
                 COMPUTE E-REVADJ-FACTOR ROUNDED =                      
                      WS-R-FACTOR-BA(WS-BILL-ADJ-INDX)                  
              END-IF                                                    
      *SPECIFIC TO THE BILL ADJUSTMENT                                          
                                                                        
              MOVE WS-STATE-TAX-XMPT-ADJ-BA(WS-BILL-ADJ-INDX)           
                                      TO E-REVADJ-CODE-STAT-TAX-XMT     
                                                                        
              MOVE WS-CITY-TAX-XMPT-ADJ-BA(WS-BILL-ADJ-INDX)            
                                      TO E-REVADJ-CODE-CITY-TAX-XMT     
                                                                        
              MOVE WS-OTHER-TAX-XMPT-ADJ-BA(WS-BILL-ADJ-INDX)           
                                      TO E-REVADJ-CODE-OTHR-TAX-XMT     
                                                                        
              EVALUATE WS-REV-INTERFACE-FL-BA(WS-BILL-ADJ-INDX)         
                 WHEN 'S'                                               
                    COMPUTE WS-UTIL-REV-TRACKED ROUNDED =               
                            E-REVADJ-BILLED-AMT +                       
                            WS-UTIL-REV-TRACKED                         
                    MOVE 'U'          TO E-REVADJ-UTILITY-REV-CD        
                                                                        
                 WHEN 'M'                                               
                    COMPUTE WS-NON-UTIL-REV-TRACKED ROUNDED =           
                            E-REVADJ-BILLED-AMT +                       
                            WS-NON-UTIL-REV-TRACKED                     
                    MOVE 'N'          TO E-REVADJ-UTILITY-REV-CD        
              END-EVALUATE                                              
                                                                        
              MOVE 'A'                TO E-REVADJ-COMP-ADJ-CD           
                                                                        
              IF WS-GL-ACCOUNT-NO-BA(WS-BILL-ADJ-INDX) > 0              
                 MOVE WS-GL-ACCOUNT-NO-BA(WS-BILL-ADJ-INDX)             
                                      TO E-REVADJ-GL-ACCT-NO            
              ELSE                                                      
                 MOVE WS-REVADJ-GL-ACCT-NO                              
                                      TO E-REVADJ-GL-ACCT-NO            
              END-IF                                                    
                                                                        
              MOVE WS-SPCL-GROUP-CD-BA(WS-BILL-ADJ-INDX)                
                                      TO E-REVADJ-SPCL-GROUP-CD         
P00257        MOVE WS-ACCOUNT-NO-AT   TO E-REVADJ-ACCOUNT-NO            
                                                                        
      * WRITE FCSCREVC - ADJUSTMENT FILE                                        
              PERFORM 8010-WRITE-FCSCREVC           THRU 8010-EXIT      
                                                                        
           END-IF.                                                      
                                                                        
      * CHECK FOR TAX ONLY FACTORS                                              
                                                                        
           IF WS-CODE-ADJUST-TYPE-BA(WS-BILL-ADJ-INDX) = 'T'            
A04581         COMPUTE WS-TOTAL-AMT-FOR-TAX =                           
A04581                 WS-AMT-ADJUSTMENT-BA (WS-BILL-ADJ-INDX) +        
A04581                 WS-TOTAL-AMT-FOR-TAX                             
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *2410-PROCESS-BC-PRORATED-FCTR.                                 *         
      *PROCESS ANY FACTORS WHICH ARE PRORATED BY BILL CALC.           *         
      *****************************************************************         
       2410-PROCESS-BC-PRORATED-FCTR.                                   
                                                                        
      * FACTORS LIKE WNA DO NOT HAVE THE PRORATED USAGE IN THE BA RECORD        
      * IN THIS CASE, REVENUE PROCESS PRORATES ONLY THE USAGE AND               
      * NOT THE ADJ-AMOUNT.                                                     
                                                                        
           PERFORM VARYING WS-TMP-FCTR-INDX FROM 1 BY 1 UNTIL           
           WS-TMP-FCTR-INDX > 200 OR                                    
           WS-TEMP-FACTOR-ID(WS-TMP-FCTR-INDX) <= SPACES                
                                                                        
           IF WS-TEMP-FACTOR-ID(WS-TMP-FCTR-INDX) =                     
              WS-FACTOR-ID-BA(WS-BILL-ADJ-INDX)         AND             
              WS-TEMP-FCTR-RATE-VER(WS-TMP-FCTR-INDX) NOT =             
              WS-FCT-RATE-VERSION-BA(WS-BILL-ADJ-INDX)  AND             
              WS-TEMP-FCTR-CMPNT-ID(WS-TMP-FCTR-INDX) =                 
              WS-FCT-CMPNT-ID-BA(WS-BILL-ADJ-INDX)      AND             
              WS-TEMP-FCTR-CNSMPTN-TYPE(WS-TMP-FCTR-INDX) =             
              WS-FCT-CNSMPT-TYPE-BA(WS-BILL-ADJ-INDX)   AND             
              WS-TEMP-FCTR-REG-TYPE(WS-TMP-FCTR-INDX) =                 
              WS-FCT-REGISTER-TYPE-BA(WS-BILL-ADJ-INDX) AND             
              WS-TEMP-FCTR-TOU-CD(WS-TMP-FCTR-INDX) =                   
              WS-FCT-TOU-BA(WS-BILL-ADJ-INDX)           AND             
              WS-TEMP-FCTR-SEASON-CD(WS-TMP-FCTR-INDX) =                
              WS-FCT-SEASON-BA(WS-BILL-ADJ-INDX)        AND             
              WS-ITEM-SEQ-NO-BA(WS-BILL-ADJ-INDX)     NOT =             
              WS-TEMP-FCTR-SEQ-NO(WS-TMP-FCTR-INDX)     AND             
              WS-PRORATE-FL-TEMP = 'R'                  AND             
              WS-ADJ-UNITS-BA(WS-BILL-ADJ-INDX) > 0                     
              SET WS-TMP-FCTR-INDX1 TO WS-TMP-FCTR-INDX                 
           END-IF                                                       
                                                                        
           END-PERFORM.                                                 
                                                                        
       2410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *2430-CUSTOMER-COUNT-PROCESS.                                   *         
      *PROCESS TO GET THE REVENUE DETAIL CUSTOMER COUNT               *         
      *****************************************************************         
       2430-CUSTOMER-COUNT-PROCESS.                                     
                                                                        
      * THE CUSTOMER COUNT IS CURRENTLY FOLLOWING THE SAME PROCESS AS           
      * PCSCA379. THIS NEEDS TO BE REVISITED, AS THE COUNTS WILL NOT            
      * MATCH FOR SOME CANCEL/REBILL SCENARIOS.                                 
                                                                        
PRJ257     PERFORM 2060-GET-UNMTR-PROV-FL        THRU 2060-EXIT         
                                                                        
           MOVE 0                        TO E-REVDET-CUST-CT.           
                                                                        
      * FOR 0 DAY, 0 USE BILLS SET THE COUNT TO ZERO.                           
ACT174* FOR COMPANY USE ACCOUNTS SET THE COUNT AS ZERO.                         
ACT011* WS-HOLD-REV-CUST-CNT-CD = 'N' - DO NOT COUNT                            
                                                                        
ACT011     IF (WS-TOTAL-BILL-ITEM-AMT = 0 AND                           
               WS-TEMP-READ-UNITS-GAS = 0 AND                           
ACT011         WS-TEMP-READ-UNITS-ELE = 0 )                             
ACT011                 OR                                               
ACT011        (WS-HOLD-REV-CUST-CNT-CD = 'N' )                          
                  MOVE 0                TO E-REVDET-CUST-CT             
           ELSE                                                         
              EVALUATE TRUE                                             
                                                                        
      * NOT A FINAL BILL, NOT A NONE-CALC AND NOT A CANCEL/REBILL.              
ACT011                                                                  
ACT011          WHEN WS-CODE-ACCT-STAT-AT NOT = 'B'                     
                 AND WS-CODE-BILL-CALC-BG(WS-BILLING-INDX) NOT = 'S'    
                 AND WS-DATE-ORIG-BILL-BG(WS-BILLING-INDX) NOT > SPACES 
                                                                        
                  MOVE 1                 TO E-REVDET-CUST-CT            
                                                                        
      * FINAL BILL, NOT A NONE-CALC AND NOT A CANCEL/REBILL.                    
                WHEN WS-CODE-ACCT-STAT-AT = 'B'                         
                 AND WS-CODE-BILL-CALC-BG(WS-BILLING-INDX) NOT = 'S'    
                 AND WS-DATE-ORIG-BILL-BG(WS-BILLING-INDX) NOT > SPACES 
                 AND WS-ACCT-FINALED-DT-AT > SPACES                     
      * TO CHECK TO SEE IF THE ACCOUNT HAS ALREADY BILLED FOR THE               
      * CURRENT MONTH                                                           
                  MOVE WS-ACCOUNT-NO-BG(WS-BILLING-INDX)                
                                         TO BI-ACCOUNT-NO               
                  MOVE WS-ACCNTING-REV-MONTH-CALC(WS-BILLING-INDX)      
                                         TO BG-REVENUE-MONTH            
ACT011            MOVE WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX)            
ACT011                                   TO BG-CODE-UTIL-TYPE           
ACT011            MOVE WS-IC-NO-BG         (WS-BILLING-INDX)            
ACT011                                   TO BG-IC-NO                    
ACT044            MOVE WS-RATE-PLAN-NO-BG  (WS-BILLING-INDX)            
ACT044                                   TO BG-RATE-PLAN-NO             
ACT011            MOVE SPACES TO WS-RATE-PLAN-NO-PREV-BILL              
                  PERFORM 7220-CHECK-ACCT-ALREADY-BILLED THRU 7220-EXIT 
                                                                        
ACT011            IF (WS-ACCOUNT-BILLED-COUNT = 0                       
ACT011                      OR                                          
ACT011                WS-RATE-PLAN-NO-BG(WS-BILLING-INDX) NOT =         
ACT011                   WS-RATE-PLAN-NO-PREV-BILL )                    
                     MOVE 1              TO E-REVDET-CUST-CT            
                  END-IF                                                
                                                                        
                END-EVALUATE                                            
           END-IF.                                                      
                                                                        
      *FOR UNMETERED ONLY ACCOUNT THE CUST-CT SHOULD MATCH                      
      *CUST-CT-EXCL-LIGHTS.                                                     
PRJ257     IF WS-HOLD-REV-CUST-CNT-CD= 'P'                              
              MOVE E-REVDET-CUST-CT      TO                             
                   E-REVDET-CUST-CT-EXCL-LIGHTS                         
           ELSE                                                         
              MOVE 0                     TO E-REVDET-CUST-CT-EXCL-LIGHTS
           END-IF.                                                      
                                                                        
      *FOR BACKOUTS MULTIPLY THE CUST-CT BY -1                                  
           IF WS-CODE-BILL-ITM-TYPE-BG(WS-BILLING-INDX) = 'B'           
              MULTIPLY -1 BY  E-REVDET-CUST-CT                          
              MULTIPLY -1 BY  E-REVDET-CUST-CT-EXCL-LIGHTS              
           END-IF.                                                      
                                                                        
                                                                        
       2430-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *2435-GET-CALC-SOURCE-CODE.                                     *         
      *PROCESS TO GET CALC-SOURCE-CD.                                 *         
      *****************************************************************         
       2435-GET-CALC-SOURCE-CODE.                                       
                                                                        
           EVALUATE WS-CODE-BILL-ITM-TYPE-BG(WS-BILLING-INDX)           
      * BACKOUT BILL                                                            
             WHEN 'B'                                                   
      * FOR BACKOUT'S USE THE ORIGINAL CODE-BILL-CALC.                          
                IF BG-CODE-BILL-CALC = 'S'                              
      * BACKOUT NONE-CALC                                                       
                   MOVE 'M'              TO E-REVDET-CALC-SOURCE-CD     
                ELSE                                                    
      * BACKOUT, NORMAL BILL                                                    
                   MOVE 'B'              TO E-REVDET-CALC-SOURCE-CD     
                END-IF                                                  
                                                                        
             WHEN OTHER                                                 
                IF WS-CODE-BILL-CALC-BG(WS-BILLING-INDX) = 'S'          
      * NONE-CALC                                                               
                   MOVE 'N'              TO E-REVDET-CALC-SOURCE-CD     
                ELSE                                                    
      * NORMAL BILL                                                             
                   MOVE SPACES           TO E-REVDET-CALC-SOURCE-CD     
                END-IF                                                  
           END-EVALUATE.                                                
                                                                        
                                                                        
       2435-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *2450-GET-SERVICE-TYPE.                                         *         
      *GET SERVICE TYPE FOR UNMETERED SERVICES.                       *         
      *****************************************************************         
       2450-GET-SERVICE-TYPE.                                           
                                                                        
           INITIALIZE                          WS-HOLD-SERVICE-TYPE.    
           PERFORM VARYING SUB7 FROM 1 BY 1 UNTIL SUB7 > WS-UM-MAX-ENTRY
              IF WS-BILLING-KEY-UC(SUB7) =                              
                             WS-BILLING-KEY (WS-BILLING-INDX)           
                MOVE WS-CODE-SERVICE-TYPE-UC (SUB7)                     
                                            TO WS-HOLD-SERVICE-TYPE     
                MOVE WS-UM-MAX-ENTRY        TO SUB7                     
              END-IF                                                    
           END-PERFORM.                                                 
           IF WS-HOLD-SERVICE-TYPE <= SPACES                            
              MOVE WS-ACCOUNT-NO-BG(WS-BILLING-INDX)                    
                                            TO CP-ACCOUNT-NO            
              MOVE WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX)                
                                            TO CP-CODE-UTIL-TYPE        
              MOVE WS-IC-NO-BG(WS-BILLING-INDX)                         
                                            TO CP-IC-NO                 
              PERFORM 7375-GET-SERVICE-TYPE THRU 7375-EXIT              
              MOVE CP-CODE-SERVICE-TYPE     TO WS-HOLD-SERVICE-TYPE     
           END-IF.                                                      
                                                                        
       2450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *2500-BILL-CALC-PROCESS                                         *         
      *BILL CALCULATION PROCESS                                       *         
      *****************************************************************         
       2500-BILL-CALC-PROCESS.                                          
                                                                        
A02932     ADD 1                                TO WS-TEMP-BC-COUNT.    
                                                                        
           PERFORM 2700-GENERATE-NETNONREV-RECORD                       
                                                THRU 2700-EXIT.         
           PERFORM 2750-GENERATE-NETREVFCT-RECORD                       
                                                THRU 2750-EXIT.         
      * BLOCK DETAILS PROCESS                                                   
                                                                        
           PERFORM 2550-BLOCK-DETAIL-PROCESS    THRU 2550-EXIT          
              VARYING WS-BLK-INDX FROM 1 BY 1 UNTIL                     
              WS-BLK-INDX > 9  OR                                       
              WS-BLK-INDX > WS-BLOCKS-USED-BC(WS-CALC-INDX).            
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *2510-SEARCH-RATE-COMPONENT-TBL.                                *         
      *SEARCH THE RATE COMPONENT TABLE TO GET THE REVENUE CONSUMPTION *         
      *****************************************************************         
       2510-SEARCH-RATE-COMPONENT-TBL.                                  
                                                                        
           SET WS-N6-INDX                TO 1.                          
           SEARCH WS-N6-RATE-CMPNT-DATA AT END                          
                  MOVE SPACES            TO WS-REVENUE-CNSMPTN-FL-TEMP  
              WHEN WS-N6-RATE-CMPNT-ID-ARR(WS-N6-INDX) =                
                   WS-TEMP-COMPONENT-ID                                 
                   MOVE WS-N6-REVENUE-CNSMPTN-FL-ARR(WS-N6-INDX)        
                                         TO WS-REVENUE-CNSMPTN-FL-TEMP  
                   MOVE WS-N6-REVENUE-AMOUNT-FL-ARR(WS-N6-INDX)         
                                         TO WS-REVENUE-AMOUNT-FL-TEMP   
           END-SEARCH.                                                  
                                                                        
       2510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *2520-NON-PRORATION-PROCESS.                                    *         
      *PROCESS WHEN THERE IS NO PRORATION                             *         
      *****************************************************************         
       2520-NON-PRORATION-PROCESS.                                      
                                                                        
           INITIALIZE                  WS-REVADJ-BILL-USAGE-UNITS       
                                       WS-REVADJ-BILL-DEMAND-UNITS      
                                       WS-REVADJ-READ-UNITS             
                                       WS-REVADJ-CALC-UNITS.            
           IF WS-CODE-BILL-ITM-TYPE-BG(WS-BILLING-INDX) = 'B' AND       
              WS-HOLD-SERVICE-TYPE = 'G'                                
              MOVE WS-HOLD-BZ-READ-UNITS                                
                                      TO WS-REVADJ-READ-UNITS           
           ELSE                                                         
              MOVE  WS-READ-UNITS-BC(WS-CALC-INDX)                      
                                      TO WS-REVADJ-READ-UNITS           
           END-IF                                                       
                                                                        
           IF WS-CONSUMPTION-TYPE-BC(WS-CALC-INDX) =                    
                                         ('B' OR 'C' OR 'D')            
              MOVE WS-NET-UNITS-BC(WS-CALC-INDX)                        
                                      TO WS-REVADJ-BILL-USAGE-UNITS     
ACT006                                   WS-REVADJ-CALC-UNITS           
           ELSE                                                         
              MOVE WS-NET-UNITS-BC(WS-CALC-INDX)                        
                                      TO WS-REVADJ-BILL-DEMAND-UNITS    
ACT006                                   WS-REVADJ-CALC-UNITS           
ACT006     END-IF.                                                      
                                                                        
      *                                                                         
       2520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *2530-PROCESS-PRORATION-USAGE.                                  *         
      *PROCESS WHEN THERE IS PRORATION                                *         
      *****************************************************************         
       2530-PROCESS-PRORATION-USAGE.                                    
                                                                        
           IF WS-RATE-VERSION-BC(WS-CALC-INDX) = 1                      
              MOVE WS-NET-UNITS-BC(WS-CALC-INDX)                        
                                      TO WS-HOLD-BC-BILL-UNITS          
              MOVE WS-READ-UNITS-BC(WS-CALC-INDX)                       
                                      TO WS-HOLD-BC-READ-UNITS          
              IF WS-CODE-BILL-ITM-TYPE-BG(WS-BILLING-INDX) = 'B' AND    
                 WS-HOLD-SERVICE-TYPE = 'G'                             
                 MOVE WS-REVADJ-READ-UNITS                              
                                      TO WS-HOLD-BC-READ-UNITS          
              END-IF                                                    
           END-IF                                                       
                                                                        
           INITIALIZE                  WS-REVADJ-BILL-USAGE-UNITS       
                                       WS-REVADJ-BILL-DEMAND-UNITS      
                                       WS-REVADJ-READ-UNITS             
                                       WS-REVADJ-CALC-UNITS.            
                                                                        
           PERFORM 2570-GET-PRORATION-PCT                               
                                      THRU 2570-EXIT                    
           MOVE WS-HOLD-BC-BILL-UNITS TO WS-REVADJ-CALC-UNITS           
                                                                        
      *THIS PROCESS POPULATES THE USAGE DETAILS FOR ALL RATE VERSION            
      *(IF PRORATED) EXCEPT THE OLDEST VERSION                                  
                                                                        
           IF WS-HOLD-RATE-VERSION NOT =                                
              WS-RATE-VERSION-BC(WS-CALC-INDX)                          
                                                                        
              IF WS-CONSUMPTION-TYPE-BC(WS-CALC-INDX)                   
                                       = ('B' OR 'C' OR 'D')            
                 COMPUTE WS-REVADJ-BILL-USAGE-UNITS ROUNDED =           
                         WS-HOLD-BC-BILL-UNITS * WS-TEMP-RATE-PERCENT   
                 ADD WS-REVADJ-BILL-USAGE-UNITS                         
                                      TO WS-HOLD-BILL-USAGE-UNITS       
              ELSE                                                      
                 COMPUTE WS-REVADJ-BILL-DEMAND-UNITS ROUNDED =          
                         WS-HOLD-BC-BILL-UNITS * WS-TEMP-RATE-PERCENT   
                 ADD WS-REVADJ-BILL-DEMAND-UNITS                        
                                      TO WS-HOLD-BILL-DEMAND-UNITS      
              END-IF                                                    
                                                                        
              COMPUTE WS-REVADJ-READ-UNITS ROUNDED =                    
                      WS-HOLD-BC-READ-UNITS * WS-TEMP-RATE-PERCENT      
              ADD WS-REVADJ-READ-UNITS                                  
                                      TO WS-HOLD-READ-UNITS             
           ELSE                                                         
      *THIS PROCESS POPULATES THE USAGE DETAILS FOR OLDEST VERSION              
              IF WS-CONSUMPTION-TYPE-BC(WS-CALC-INDX)                   
                                 = ('B' OR 'C' OR 'D')                  
                 COMPUTE WS-REVADJ-BILL-USAGE-UNITS =                   
                         WS-HOLD-BC-BILL-UNITS         -                
                         WS-HOLD-BILL-USAGE-UNITS                       
              ELSE                                                      
                                                                        
                 COMPUTE WS-REVADJ-BILL-DEMAND-UNITS =                  
                         WS-HOLD-BC-BILL-UNITS         -                
                         WS-HOLD-BILL-DEMAND-UNITS                      
              END-IF                                                    
                                                                        
      *CHECK IF THE LIGHTS HAVE BEEN PRORATED AND THE FIXED USAGE               
      * HAS CHANGED. IF SO, COMPUTE THE CORRECT PRORATED USAGE.                 
              IF WS-FIXED-UM-KWH-BC(WS-CALC-INDX) > 0                   
                 COMPUTE WS-TEMP-READ-UNITS ROUNDED =                   
                              (WS-FIXED-UM-KWH-BC(WS-CALC-INDX) *       
                               WS-UNITS-BILLED-BC(WS-CALC-INDX 1)) /    
                               WS-CUST-PER-SERVICE-BC(WS-CALC-INDX)     
      * FOR BACKOUT BG'S MULTIPLY USAGE AND BILL AMOUNTS FOR BC BY -1           
                                                                        
                 IF WS-CODE-BILL-ITM-TYPE-BG(WS-BILLING-INDX) = 'B'     
                 OR WS-CODE-DR-CR-CNSMPTN-BG(WS-BILLING-INDX) = 'C'     
                    MULTIPLY -1 BY WS-TEMP-READ-UNITS                   
                 END-IF                                                 
                                                                        
                 IF WS-TEMP-READ-UNITS NOT = WS-HOLD-BC-READ-UNITS      
                    COMPUTE WS-REVADJ-READ-UNITS ROUNDED =              
                               WS-TEMP-READ-UNITS   *                   
                               WS-TEMP-RATE-PERCENT                     
                 ELSE                                                   
                    COMPUTE WS-REVADJ-READ-UNITS =                      
                      WS-HOLD-BC-READ-UNITS     - WS-HOLD-READ-UNITS    
                 END-IF                                                 
              ELSE                                                      
                 COMPUTE WS-REVADJ-READ-UNITS =                         
                      WS-HOLD-BC-READ-UNITS     - WS-HOLD-READ-UNITS    
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE WS-REVADJ-READ-UNITS  TO                                
                           WS-BC-NET-READ-UNITS(WS-RT-VRSN-IND1).       
           MOVE WS-REVADJ-BILL-USAGE-UNITS                              
                                      TO                                
                           WS-BC-NET-BILL-UNITS(WS-RT-VRSN-IND1).       
           MOVE WS-REVADJ-BILL-DEMAND-UNITS                             
                                      TO                                
                           WS-BC-NET-BILL-DMND-UNITS(WS-RT-VRSN-IND1).  
           MOVE ZEROES                TO      WS-HOLD-READ-UNITS        
                                              WS-HOLD-BILL-USAGE-UNITS  
                                              WS-HOLD-BILL-DEMAND-UNITS.
      *                                                                         
       2530-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *2540-CALC-BACKOUT-CNSMPTN.                                     *         
      *FOR GAS THE BACKOUT READ UNITS ARE THERMS INSTEAD OF CCF.      *         
      *****************************************************************         
       2540-CALC-BACKOUT-CNSMPTN.                                       
                                                                        
           IF  WS-BTU-FACTOR-BG(WS-BILLING-INDX) NOT = 0                
               COMPUTE WS-REVADJ-READ-UNITS ROUNDED =                   
                           WS-REVADJ-READ-UNITS /                       
                           WS-BTU-FACTOR-BG (WS-BILLING-INDX)           
           ELSE                                                         
               COMPUTE WS-REVADJ-READ-UNITS    ROUNDED =                
                           WS-REVADJ-READ-UNITS / 1.032                 
           END-IF.                                                      
      *                                                                         
       2540-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2550-BLOCK-DETAIL-PROCESS.                                      *        
      *BLOCK DETAIL PROCESS                                            *        
      ******************************************************************        
       2550-BLOCK-DETAIL-PROCESS.                                       
                                                                        
           INITIALIZE FCSCREVB.                                         
                                                                        
           ADD 1                         TO WS-BLOCK-NO.                
           MOVE WS-CURRENT-TIMESTAMP     TO E-REVBLK-BILL-UNIQUE-TS     
                                                                        
           MOVE WS-REVBLK-BILL-COMP-SEQ-NO                              
                                         TO E-REVBLK-BILL-COMP-SEQ-NO   
                                                                        
           MOVE WS-BLOCK-NO              TO E-REVBLK-BLK-NO-RT-ITM-CD   
                                                                        
           MOVE WS-BLOCK-SIZE-BC(WS-CALC-INDX  WS-BLK-INDX)             
                                         TO E-REVBLK-BLK-USE-OR-SVCS    
                                                                        
           IF WS-CONSUMPTION-TYPE-BC(WS-CALC-INDX) = 'B' OR 'C' OR 'D'  
              MOVE WS-UNITS-BILLED-BC(WS-CALC-INDX  WS-BLK-INDX)        
                                         TO E-REVBLK-BLK-BILL-USE-UNITS 
           ELSE                                                         
              MOVE WS-UNITS-BILLED-BC(WS-CALC-INDX  WS-BLK-INDX)        
                                         TO E-REVBLK-BLK-BILL-DEM-UNITS 
           END-IF.                                                      
                                                                        
           MOVE WS-HOLD-BLK-BILL-LT-POLES                               
                                         TO E-REVBLK-BLK-BILL-LT-POLES  
                                                                        
           MOVE WS-CUST-PER-SERVICE-BC(WS-CALC-INDX)                    
                                         TO E-REVBLK-CUST-PER-SERVICE   
                                                                        
           MOVE WS-PRICE-TYPE-CD-BC(WS-CALC-INDX  WS-BLK-INDX)          
                                         TO E-REVBLK-PRICE-TYPE-CD      
                                                                        
           MOVE WS-AMT-BASE-RATE-BC(WS-CALC-INDX  WS-BLK-INDX)          
                                         TO E-REVBLK-SCHED-PRICE-AM     
                                                                        
           MOVE WS-AMT-NET-RATE-BC(WS-CALC-INDX  WS-BLK-INDX)           
                                         TO E-REVBLK-UNIT-PRICE-AM      
                                                                        
           MOVE WS-AMT-BLOCK-BC(WS-CALC-INDX  WS-BLK-INDX)              
                                         TO E-REVBLK-BLK-REV-AMT        
                                                                        
           MOVE WS-NET-UNIT-SEL-RSN-BC(WS-CALC-INDX)                    
                                         TO E-REVBLK-NET-UNIT-SEL-RSN   
                                                                        
           MOVE WS-HOLD-KW-MDQ-DT        TO E-REVBLK-KW-MDQ-DT          
           MOVE WS-HOLD-KVA-DT           TO E-REVBLK-KVA-DT             
                                                                        
           MOVE WS-CONTRACT-DEM-CALC(WS-BILLING-INDX)                   
                                         TO E-REVBLK-CONTRACT-DEMAND    
      * FOR MDQ GET THE READ UNITS FROM BC                                      
           IF WS-CONSUMPTION-TYPE-BC(WS-CALC-INDX)= 'Q'                 
              MOVE WS-READ-UNITS-BC(WS-CALC-INDX)                       
                                         TO E-REVBLK-READ-KW-MDQ-UNITS  
           ELSE                                                         
      * FOR KW AND KVA GET THE READ UNITS FROM CX                               
              IF WS-CONSUMPTION-TYPE-BC(WS-CALC-INDX)= 'E' OR 'J'       
      * READ UNITS LOGIC                                                        
                 PERFORM 2560-READ-UNITS-PROCESS                        
                                         THRU 2560-EXIT                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
                                                                        
           MOVE WS-POWER-FACTOR-CALC(WS-BILLING-INDX)                   
                                         TO E-REVBLK-POWER-FACTOR       
                                                                        
           MOVE WS-LOAD-FACTOR-CALC(WS-BILLING-INDX)                    
                                         TO E-REVBLK-LOAD-FACTOR        
                                                                        
           MOVE WS-TEMP-RATE-PERCENT     TO E-REVBLK-RT-VERS-PRO-PCT    
                                                                        
P00257     MOVE WS-ACCOUNT-NO-BC(WS-CALC-INDX)                          
P00257                                   TO E-REVBLK-ACCOUNT-NO         
                                                                        
P00257     MOVE WS-RATE-ITEM-CODE-BC(WS-CALC-INDX)                      
P00257                                   TO E-REVBLK-RATE-ITEM-CODE     
                                                                        
      * WRITE FCSCREVB-BLOCK DETAILS FILE                                       
           PERFORM 8020-WRITE-FCSCREVB     THRU 8020-EXIT.              
      *                                                                         
       2550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2560-READ-UNITS-PROCESS.                                        *        
      *READ UNITS PROCESS.                                             *        
      ******************************************************************        
       2560-READ-UNITS-PROCESS.                                         
                                                                        
           MOVE SPACES             TO WS-HOLD-CNSMPTN-TYPE.             
           PERFORM VARYING WS-CNSMPTN-INDX FROM 1 BY 1                  
                   UNTIL WS-CNSMPTN-INDX > WS-CX-MAX-ENTRY OR           
                   WS-ACCOUNT-NO-CX(WS-CNSMPTN-INDX) = ZEROES           
                                                                        
              SET WS-HOLD-CX-INDX  TO 1                                 
                                                                        
              IF WS-BILLING-KEY(WS-BILLING-INDX)                        
                 = WS-BILLING-KEY-CX(WS-CNSMPTN-INDX)                   
                                                                        
                 SEARCH WS-HOLD-CX-DMND-DATA                            
                                                                        
                    WHEN WS-HOLD-CX-USAGE-TYPE(WS-HOLD-CX-INDX) =       
                         SPACES AND                                     
                   (WS-CODE-USAGE-TYPE-CX(WS-CNSMPTN-INDX) = 'E' OR     
                    WS-CODE-USAGE-TYPE-CX(WS-CNSMPTN-INDX) = 'J')       
                                                                        
                       MOVE WS-CODE-USAGE-TYPE-CX(WS-CNSMPTN-INDX)      
                          TO WS-HOLD-CX-USAGE-TYPE(WS-HOLD-CX-INDX)     
                       MOVE WS-NO-DEMAND-UNITS-CX(WS-CNSMPTN-INDX)      
                          TO WS-HOLD-CX-DEMAND-UNITS(WS-HOLD-CX-INDX)   
                       MOVE WS-MTR-REF-NO-CX(WS-CNSMPTN-INDX)           
                          TO WS-HOLD-CX-MTR-REF-NO(WS-HOLD-CX-INDX)     
                                                                        
                    WHEN WS-HOLD-CX-MTR-REF-NO(WS-HOLD-CX-INDX) =       
                       WS-MTR-REF-NO-CX(WS-CNSMPTN-INDX) AND            
                       WS-HOLD-CX-USAGE-TYPE(WS-HOLD-CX-INDX) =         
                       WS-CODE-USAGE-TYPE-CX(WS-CNSMPTN-INDX) AND       
                   (WS-CODE-USAGE-TYPE-CX(WS-CNSMPTN-INDX) = 'E' OR     
                    WS-CODE-USAGE-TYPE-CX(WS-CNSMPTN-INDX) = 'J')       
                                                                        
                       IF WS-NO-DEMAND-UNITS-CX(WS-CNSMPTN-INDX) >      
                          WS-HOLD-CX-DEMAND-UNITS(WS-HOLD-CX-INDX)      
                                                                        
                          MOVE WS-NO-DEMAND-UNITS-CX(WS-CNSMPTN-INDX)   
                          TO WS-HOLD-CX-DEMAND-UNITS(WS-HOLD-CX-INDX)   
                       END-IF                                           
                 END-SEARCH                                             
                                                                        
                 EVALUATE WS-CODE-UTIL-TYPE-CX(WS-CNSMPTN-INDX)         
                   WHEN 'G'                                             
                     IF WS-CODE-USAGE-VALUES-CX(WS-CNSMPTN-INDX) = 'CAB'
                        ADD WS-NO-UNITS-CX (WS-CNSMPTN-INDX) TO         
                            WS-NONCAL-BILL-USAGE-UNITS                  
                            WS-NONCAL-READ-UNITS                        
                        MOVE WS-CODE-USAGE-TYPE-CX(WS-CNSMPTN-INDX) TO  
                                             WS-HOLD-CNSMPTN-TYPE       
                     END-IF                                             
                   WHEN 'E'                                             
                     IF  WS-CODE-USAGE-TYPE-CX(WS-CNSMPTN-INDX) = 'B'   
                     AND WS-CODE-ITEM-STATUS-CX(WS-CNSMPTN-INDX) = 'A'  
                     AND WS-CODE-USAGE-ID-CX(WS-CNSMPTN-INDX)           
                                                       NOT NUMERIC      
                        ADD WS-NO-UNITS-CX (WS-CNSMPTN-INDX) TO         
                            WS-NONCAL-BILL-USAGE-UNITS                  
                            WS-NONCAL-READ-UNITS                        
                        MOVE WS-CODE-USAGE-TYPE-CX(WS-CNSMPTN-INDX) TO  
                                             WS-HOLD-CNSMPTN-TYPE       
                     END-IF                                             
                 END-EVALUATE                                           
                                                                        
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           IF ELECT-DEMAND-KVA OR ELECT-DEMAND-KW                       
              PERFORM VARYING WS-HOLD-CX-INDX FROM 1 BY 1 UNTIL         
SCA006           WS-HOLD-CX-INDX > WS-CX-MAX-ENTRY OR 
                 WS-HOLD-CX-USAGE-TYPE(WS-HOLD-CX-INDX) = SPACES                
                 IF WS-HOLD-CX-USAGE-TYPE(WS-HOLD-CX-INDX) = 'E'        
                    ADD WS-HOLD-CX-DEMAND-UNITS(WS-HOLD-CX-INDX)        
                            TO E-REVBLK-READ-KVA-UNITS                  
                 END-IF                                                 
                 IF WS-HOLD-CX-USAGE-TYPE(WS-HOLD-CX-INDX) = 'J'        
                    ADD WS-HOLD-CX-DEMAND-UNITS(WS-HOLD-CX-INDX)        
                            TO E-REVBLK-READ-KW-MDQ-UNITS               
                 END-IF                                                 
              END-PERFORM                                               
           END-IF.                                                      
                                                                        
       2560-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2570-GET-PRORATION-PCT.                                         *        
      *GET PRORATION PERCENT AND CONSUMPTION FOR CURRENT BC            *        
      ******************************************************************        
       2570-GET-PRORATION-PCT.                                          
                                                                        
           INITIALIZE                       WS-TEMP-RATE-PERCENT        
                                            WS-RATE-VERSION-FOUND.      
                                                                        
           PERFORM VARYING WS-RT-VRSN-INDX FROM 1 BY 1 UNTIL            
SCA006     WS-RATE-VERSION-FOUND = 'Y' OR 
           WS-RT-VRSN-INDX > 200 OR 
           WS-BC-RATE-VER(WS-RT-VRSN-INDX) <= SPACES                            
                                                                        
           IF WS-BC-RATE-VER(WS-RT-VRSN-INDX) =                         
              WS-RATE-VERSION-BC(WS-CALC-INDX)       AND                
              WS-BC-COMP-CODE(WS-RT-VRSN-INDX) =                        
              WS-COMPONENT-CODE-BC(WS-CALC-INDX)     AND                
              WS-BC-CNSMPTN-TYPE(WS-RT-VRSN-INDX) =                     
              WS-CONSUMPTION-TYPE-BC(WS-CALC-INDX)   AND                
              WS-BC-REG-TYPE(WS-RT-VRSN-INDX) =                         
              WS-REGISTER-TYPE-BC(WS-CALC-INDX)      AND                
              WS-BC-TOU-CD(WS-RT-VRSN-INDX) =                           
              WS-CODE-TOU-BC(WS-CALC-INDX)           AND                
              WS-BC-SEASON-CD(WS-RT-VRSN-INDX) =                        
              WS-CODE-SEASON-BC(WS-CALC-INDX)                           
               MOVE 'Y'                  TO WS-RATE-VERSION-FOUND       
               MOVE WS-BC-RATE-PERCENT(WS-RT-VRSN-INDX)                 
                                         TO WS-TEMP-RATE-PERCENT        
               SET WS-RT-VRSN-IND1       TO WS-RT-VRSN-INDX             
               IF WS-RATE-VERSION-BC(WS-CALC-INDX) = 1                  
                  MOVE WS-HOLD-BC-BILL-UNITS                            
                                         TO                             
                             WS-BC-HOLD-BILL-UNITS(WS-RT-VRSN-INDX)     
                  MOVE WS-HOLD-BC-READ-UNITS                            
                                         TO                             
                             WS-BC-HOLD-READ-UNITS(WS-RT-VRSN-INDX)     
               END-IF                                                   
           END-IF                                                       
                                                                        
           END-PERFORM.                                                 
                                                                        
       2570-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2590-GET-NO-OF-RATE-VERS-USAGE.                                 *        
      *GET THE LAST RATE VERSION FOR A BC AND CUMULATIVE USAGE.        *        
      ******************************************************************        
       2590-GET-NO-OF-RATE-VERS-USAGE.                                  
                                                                        
           INITIALIZE                       WS-HOLD-RATE-VERSION.       
                                                                        
           PERFORM VARYING WS-RT-VRSN-INDX FROM 1 BY 1 UNTIL            
           WS-RT-VRSN-INDX > 200 OR                                     
           WS-BC-RATE-VER(WS-RT-VRSN-INDX) <= SPACES                    
                                                                        
           IF WS-BC-COMP-CODE(WS-RT-VRSN-INDX) =                        
              WS-COMPONENT-CODE-BC(WS-CALC-INDX)     AND                
              WS-BC-CNSMPTN-TYPE(WS-RT-VRSN-INDX) =                     
              WS-CONSUMPTION-TYPE-BC(WS-CALC-INDX)   AND                
              WS-BC-REG-TYPE(WS-RT-VRSN-INDX) =                         
              WS-REGISTER-TYPE-BC(WS-CALC-INDX)      AND                
              WS-BC-TOU-CD(WS-RT-VRSN-INDX) =                           
              WS-CODE-TOU-BC(WS-CALC-INDX)           AND                
              WS-BC-SEASON-CD(WS-RT-VRSN-INDX) =                        
              WS-CODE-SEASON-BC(WS-CALC-INDX)                           
              IF WS-BC-RATE-VER(WS-RT-VRSN-INDX) >                      
                                     WS-HOLD-RATE-VERSION               
                  MOVE WS-BC-RATE-VER(WS-RT-VRSN-INDX)                  
                                 TO  WS-HOLD-RATE-VERSION               
              END-IF                                                    
              IF WS-BC-RATE-VER(WS-RT-VRSN-INDX) = 1                    
                  MOVE WS-BC-HOLD-BILL-UNITS(WS-RT-VRSN-INDX)           
                                 TO WS-HOLD-BC-BILL-UNITS               
                  MOVE WS-BC-HOLD-READ-UNITS(WS-RT-VRSN-INDX)           
                                 TO WS-HOLD-BC-READ-UNITS               
              END-IF                                                    
              ADD  WS-BC-NET-READ-UNITS(WS-RT-VRSN-INDX)                
                                 TO WS-HOLD-READ-UNITS                  
              ADD  WS-BC-NET-BILL-UNITS(WS-RT-VRSN-INDX)                
                                 TO WS-HOLD-BILL-USAGE-UNITS            
              ADD  WS-BC-NET-BILL-DMND-UNITS(WS-RT-VRSN-INDX)           
                                 TO WS-HOLD-BILL-DEMAND-UNITS           
           END-IF                                                       
           END-PERFORM.                                                 
                                                                        
       2590-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2600-TAX-CALCULATION-PROCESS.                                   *        
      *TAX CALCULATION PROCESS.                                        *        
      ******************************************************************        
       2600-TAX-CALCULATION-PROCESS.                                    
                                                                        
      *SET THE INPUTS FOR SCSCA102                                              
                                                                        
PRJ257     MOVE 'N'                         TO WS-FRAN-TAX-GENERATED    
           MOVE WS-REV-DISTRICT-CD-BG(WS-BILLING-INDX)                  
                                            TO WS-CWS202-REV-DIST-CD    
           MOVE WS-HOLD-SERVICE-TYPE        TO WS-CWS202-ENERGY-FLAG    
      * TAX REVENUE MONTH LOGIC                                                 
                                                                        
           IF WS-RATE-PARM-OVERRIDE-BG(WS-BILLING-INDX) = 'Y'           
              PERFORM VARYING WS-ADJUSTMNT-INDEX FROM 1 BY 1 UNTIL      
                 WS-ADJUSTMNT-INDEX > 20 OR                             
                 WS-ACCOUNT-NO-BP(WS-ADJUSTMNT-INDEX) = ZEROES          
                 IF WS-ACCOUNT-NO-BP(WS-ADJUSTMNT-INDEX)                
                       = WS-ACCOUNT-NO-BG(WS-BILLING-INDX)              
                    AND WS-BILL-NO-BP(WS-ADJUSTMNT-INDEX)               
                       = WS-BILL-NO-BG(WS-BILLING-INDX)                 
                    AND WS-CODE-UTIL-TYPE-BP(WS-ADJUSTMNT-INDEX)        
                       = WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX)          
                    AND WS-IC-NO-BP(WS-ADJUSTMNT-INDEX)                 
                       = WS-IC-NO-BG(WS-BILLING-INDX)                   
                    AND WS-BILL-ITEM-TIMESTMP-BP(WS-ADJUSTMNT-INDEX)    
                       = WS-BILL-ITEM-TIMESTMP-BG(WS-BILLING-INDX)      
                                                                        
                    MOVE WS-OVRRIDE-RT-REV-MTH-BP(WS-ADJUSTMNT-INDEX)   
                                            TO WS-CWS202-REV-MONTH      
                 END-IF                                                 
              END-PERFORM                                               
           ELSE                                                         
              IF WS-CODE-BILL-ITM-TYPE-BG(WS-BILLING-INDX) = 'B'        
                 MOVE WS-REV-MTH-ORIG-BILL-BG(WS-BILLING-INDX)          
                                            TO WS-CWS202-REV-MONTH      
              ELSE                                                      
                 MOVE WS-REVENUE-MONTH-BG(WS-BILLING-INDX)              
                                            TO WS-CWS202-REV-MONTH      
              END-IF                                                    
           END-IF                                                       
                                                                        
P00794     IF WS-DATE-ORIG-BILL-BG(WS-BILLING-INDX) > SPACES            
P00794        MOVE WS-DATE-ORIG-BILL-BG(WS-BILLING-INDX)                
P00794                               TO WS-CWS202-DATE-BILLED           
P00794     ELSE                                                         
P00794        MOVE WS-DATE-BILLED-BI TO WS-CWS202-DATE-BILLED           
P00794     END-IF                                                       
                                                                        
P00794     MOVE WS-COMPANY-NO-AT     TO WS-CWS202-COMPANY-NO            
                                                                        
           IF CSR-DATABASE AND WS-COMPANY-NO-AT = '26'                  
              MOVE WS-CODE-STAT-TAX-XMT-BG(WS-BILLING-INDX)             
                                             TO WS-CWS202-ST-TAX-XMT-CD 
           ELSE                                                         
A04359        IF SEB-DATABASE AND                                       
A04359           WS-CODE-STAT-TAX-XMT-BG(WS-BILLING-INDX) =             
A04359                                          WS-GA-MFG-SALES-TAX-XMT 
A04359           MOVE WS-CODE-STAT-TAX-XMT-BG(WS-BILLING-INDX)          
A04359                                       TO WS-CWS202-ST-TAX-XMT-CD 
              ELSE                                                      
                 MOVE SPACES                 TO WS-CWS202-ST-TAX-XMT-CD 
A04359        END-IF                                                    
           END-IF                                                       
                                                                        
      * CALL SCSCA202                                                           
           PERFORM 5900-CALL-TAX-CALC       THRU 5900-EXIT.             
                                                                        
           IF RS-RETURN-CODE       NOT = 0                              
              PERFORM 9200-SCSCA-ERROR            THRU 9200-EXIT        
           END-IF                                                       
                                                                        
           MOVE  0                          TO  WS-HOLD-TAX-AMT         
                                                                        
           PERFORM VARYING WS-INDEX FROM 1 BY 1 UNTIL                   
                   WS-INDEX > 10 OR                                     
                   WS-CWS202-TAX-TYPE(WS-INDEX) = SPACES                
                                                                        
              INITIALIZE FCSCREVT                                       
                         WS-TAX-AMT                                     
                                                                        
              MOVE WS-CURRENT-TIMESTAMP     TO E-REVTAX-BILL-UNIQUE-TS  
                                                                        
              MOVE WS-CWS202-TAX-TYPE(WS-INDEX)                         
                                            TO E-REVTAX-TAX-TYPE        
              MOVE WS-CWS202-TAX-CNTRL-NO(WS-INDEX)                     
                                            TO E-REVTAX-TAX-CNTRL-NO    
              MOVE WS-CWS202-TAX-FROM-DT(WS-INDEX)                      
                                            TO E-REVTAX-TAX-FROM-DT     
              MOVE WS-CWS202-FCTR-ID(WS-INDEX)                          
                                            TO E-REVTAX-FACTOR-ID       
              MOVE WS-CWS202-TAX-GL-ACCT-NO(WS-INDEX)                   
                                            TO E-REVTAX-TAX-GL-ACCT-NO  
                                                                        
              IF WS-CWS202-TAX-TYPE(WS-INDEX) NOT = 'B' AND             
                 WS-CODE-STAT-TAX-XMT-BG(WS-BILLING-INDX) NOT = 'Y' AND 
                 WS-AMT-STATE-TAX-BG(WS-BILLING-INDX) NOT= ZEROES       
                                                                        
                 IF WS-CWS202-TAX-TYPE(WS-INDEX) = 'A'                  
                                                                        
A02932              COMPUTE WS-TAX-AMT ROUNDED =                        
                         WS-AMT-STATE-TAX-BG(WS-BILLING-INDX) -         
                         WS-HOLD-TAX-AMT                                
                 ELSE                                                   
                                                                        
A02932              COMPUTE WS-TAX-AMT ROUNDED =                        
A02932                                   WS-TOTAL-AMT-FOR-TAX  *        
                                         WS-CWS202-TAX-RATE(WS-INDEX)   
                    ADD WS-TAX-AMT          TO WS-HOLD-TAX-AMT          
                 END-IF                                                 
              ELSE                                                      
                 IF WS-CWS202-TAX-TYPE(WS-INDEX) = 'B' AND              
                    WS-CODE-CITY-TAX-XMT-BG(WS-BILLING-INDX) NOT = 'Y'  
                 AND WS-AMT-CITY-TAX-BG(WS-BILLING-INDX) NOT= ZEROES    
                                                                        
                    MOVE WS-AMT-CITY-TAX-BG(WS-BILLING-INDX)            
                                            TO WS-TAX-AMT               
PRJ257              SET FRAN-TAX-GENERATED  TO TRUE                     
                 END-IF                                                 
              END-IF                                                    
              MOVE WS-TAX-AMT               TO E-REVTAX-TAX-AMT         
                                                                        
P00257        MOVE WS-ACCOUNT-NO-BG(WS-BILLING-INDX)                    
P00257                                      TO E-REVTAX-ACCOUNT-NO      
                                                                        
      *WRITE FCSCREVT FILE - TAX FILE                                           
              IF E-REVTAX-TAX-AMT NOT= ZEROES                           
                 PERFORM 8030-WRITE-FCSCREVT        THRU 8030-EXIT      
              END-IF                                                    
                                                                        
           END-PERFORM.                                                 
                                                                        
PRJ257     IF MANUAL-BILL AND NOT FRAN-TAX-GENERATED AND                
PRJ257        WS-AMT-CITY-TAX-BG(WS-BILLING-INDX) NOT = ZEROES          
PRJ257                                                                  
PRJ257        MOVE WS-CURRENT-TIMESTAMP     TO E-REVTAX-BILL-UNIQUE-TS  
      *                                                                         
A0341 *  IF WE ARE GOING TO FORCE THIS RECORD TO BE A TAX-TYPE = 'B',           
A0341 *     WHICH IS FRANCHISE, WE MAY AS WELL FORCE IT TO HAVE                 
A0341 *     THE FRANCHISE TAX CNTROL NUMBER (20).                               
      *                                                                         
PRJ257        MOVE 'B'                      TO E-REVTAX-TAX-TYPE        
PRJ257*       MOVE 0                        TO E-REVTAX-TAX-CNTRL-NO            
A03411        MOVE WS-FRAN-CNTRL-NO         TO E-REVTAX-TAX-CNTRL-NO    
      *                                                                         
PRJ257        MOVE WS-INPUT-DATE            TO E-REVTAX-TAX-FROM-DT     
PRJ257        MOVE SPACES                   TO E-REVTAX-FACTOR-ID       
PRJ257        MOVE 0.0                      TO E-REVTAX-TAX-GL-ACCT-NO  
PRJ257        MOVE WS-AMT-CITY-TAX-BG(WS-BILLING-INDX)                  
PRJ257                                      TO E-REVTAX-TAX-AMT         
PRJ257        MOVE WS-ACCOUNT-NO-AT         TO E-REVTAX-ACCOUNT-NO      
PRJ257                                                                  
PRJ257        IF E-REVTAX-TAX-AMT NOT           = ZEROES                
PRJ257           PERFORM 8030-WRITE-FCSCREVT     THRU 8030-EXIT         
PRJ257        END-IF                                                    
PRJ257     END-IF.                                                      
PRJ257                                                                  
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2610-PROCESS-CNSMPTN-HIST.                                      *        
      *BASED ON CODE-DEBIT-CREDIT-CX CHANGE THE SIGNS FOR NO-UNITS-CX. *        
      ******************************************************************        
       2610-PROCESS-CNSMPTN-HIST.                                       
                                                                        
           PERFORM VARYING WS-CNSMPTN-INDX FROM 1 BY 1                  
                   UNTIL WS-CNSMPTN-INDX > WS-CX-MAX-ENTRY OR           
                   WS-ACCOUNT-NO-CX(WS-CNSMPTN-INDX) = ZEROES           
                                                                        
              IF WS-BILLING-KEY(WS-BILLING-INDX)                        
                 = WS-BILLING-KEY-CX(WS-CNSMPTN-INDX)                   
                 IF WS-CODE-DEBIT-CREDIT-CX(WS-CNSMPTN-INDX) = 'C'      
                   MULTIPLY -1 BY WS-NO-DEMAND-UNITS-CX(WS-CNSMPTN-INDX)
                   MULTIPLY -1 BY WS-NO-UNITS-CX(WS-CNSMPTN-INDX)       
                 END-IF                                                 
      * THIS HAS BEEN ADDED TO MATCH WITH CURRENT PRODUCTION REPORTS.           
                 IF WS-CODE-DR-CR-CNSMPTN-BG(WS-BILLING-INDX) = 'C'     
                   MULTIPLY -1 BY WS-NO-DEMAND-UNITS-CX(WS-CNSMPTN-INDX)
                   MULTIPLY -1 BY WS-NO-UNITS-CX(WS-CNSMPTN-INDX)       
                 END-IF                                                 
              END-IF                                                    
                                                                        
           END-PERFORM.                                                 
                                                                        
       2610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
I01959******************************************************************        
I01959*2615-PROCESS-GEN-CX.                                            *        
I01959******************************************************************        
I01959 2615-PROCESS-GEN-CX.                                             
I01959                                                                  
I01959     MOVE ZEROES                       TO WS-TOTAL-GEN-UNITS      
I01959                                          WS-GEN-UNITS-ONPEAK     
I01959                                          WS-GEN-UNITS-OFFPEAK    
I01959                                          WS-GEN-UNITS-SHLDR      
I01959                                          WS-GEN-UNITS.           
I01959     PERFORM VARYING WS-CNSMPTN-INDX FROM 1 BY 1                  
I01959             UNTIL WS-CNSMPTN-INDX > WS-CX-MAX-ENTRY OR           
I01959             WS-ACCOUNT-NO-CX(WS-CNSMPTN-INDX) = ZEROES           
I01959      IF WS-BILLING-KEY(WS-BILLING-INDX)                          
I01959        = WS-BILLING-KEY-CX(WS-CNSMPTN-INDX)                      
I01959        IF WS-CODE-USAGE-ID-CX(WS-CNSMPTN-INDX) EQUAL 'F'         
I01959           MOVE WS-NO-UNITS-CX(WS-CNSMPTN-INDX) TO WS-GEN-UNITS   
I01959           IF WS-CODE-DR-CR-CNSMPTN-BG(WS-BILLING-INDX) = 'C'     
I01959              OR WS-CODE-DEBIT-CREDIT-CX(WS-CNSMPTN-INDX) = 'C'   
I01959                 MULTIPLY -1 BY WS-GEN-UNITS                      
I01959           END-IF                                                 
I01959           EVALUATE WS-CODE-TIME-PERIOD-CX(WS-CNSMPTN-INDX)       
I01959               WHEN WS-NON-TOU                                    
I01959                   COMPUTE WS-TOTAL-GEN-UNITS   = WS-GEN-UNITS    
I01959                                            + WS-TOTAL-GEN-UNITS  
I01959               WHEN WS-ON-PEAK                                    
I01959                   COMPUTE WS-GEN-UNITS-ONPEAK = WS-GEN-UNITS     
I01959                                            + WS-GEN-UNITS-ONPEAK 
I01959               WHEN WS-OFF-PEAK                                   
I01959                   COMPUTE WS-GEN-UNITS-OFFPEAK = WS-GEN-UNITS    
I01959                                            + WS-GEN-UNITS-OFFPEAK
I01959               WHEN WS-SHOULDER                                   
I01959                   COMPUTE WS-GEN-UNITS-SHLDR   = WS-GEN-UNITS    
I01959                                            + WS-GEN-UNITS-SHLDR  
I01959           END-EVALUATE                                           
I01959        END-IF                                                    
I01959      END-IF                                                      
I01959     END-PERFORM.                                                 
I01959                                                                  
I01959 2615-EXIT.                                                       
I01959     EXIT.                                                        
                                                                        
      ******************************************************************        
      *2620-PROCESS-BACKOUT-BC-DTL.                                    *        
      *FOR BACKOUT BG'S MULTIPLY USAGE AND BILL AMOUNTS BY -1.         *        
      ******************************************************************        
       2620-PROCESS-BACKOUT-BC-DTL.                                     
                                                                        
      * FOR BACKOUTS, MULTIPLY THE USAGE AND BILL AMOUNT BY -1                  
                                                                        
           MULTIPLY -1 BY WS-NET-COMPONENT-AMT-BC(WS-CALC-INDX)         
           MULTIPLY -1 BY WS-READ-UNITS-BC(WS-CALC-INDX)                
           MULTIPLY -1 BY WS-NET-UNITS-BC(WS-CALC-INDX)                 
      * MULTIPLY THE BILL AMOUNT IN ALL THE BLOCKS BY -1                        
                                                                        
           PERFORM VARYING WS-BLK-INDX FROM 1 BY 1 UNTIL                
           WS-BLK-INDX > 9  OR                                          
           WS-BLK-INDX > WS-BLOCKS-USED-BC(WS-CALC-INDX)                
                                                                        
              MULTIPLY -1 BY WS-AMT-BLOCK-BC(WS-CALC-INDX  WS-BLK-INDX) 
                                                                        
           END-PERFORM.                                                 
                                                                        
       2620-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *2630-GET-REVENUE-COMPANY-NO.                                   *         
      *SEARCH THE CRM TIER ACCT TYPE TABLE TO GET SEB REV COMPANY NO  *         
      *****************************************************************         
       2630-GET-REVENUE-COMPANY-NO.                                     
                                                                        
           SET WS-TT-INDX                TO 1.                          
           SEARCH WS-TT-CRM-TIER-DATA   AT END                          
                  MOVE SPACES            TO WS-HOLD-SEB-REV-COMP-NO     
              WHEN WS-TT-TIER-ACCT-TYPE-CD-ARR(WS-TT-INDX) =            
                   TT-TIER-ACCT-TYPE-CD                                 
               AND WS-TT-COMPANY-NO-ARR(WS-TT-INDX) =                   
                   WS-COMPANY-NO-AT                                     
                   MOVE WS-TT-REV-COMPANY-NO-ARR(WS-TT-INDX)            
                                         TO WS-HOLD-SEB-REV-COMP-NO     
           END-SEARCH.                                                  
                                                                        
       2630-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *2640-GET-SEB-REVENUE-DATA.                                     *         
      *GET SEB SPECIFIC DATA FOR REVENUE TABLES.                      *         
      *****************************************************************         
       2640-GET-SEB-REVENUE-DATA.                                       
                                                                        
           SET WS-TIER-INDX           TO 1                              
                                                                        
      * GET TIER ACCT TYPE CD FOR SEB                                           
           IF WS-CODE-BILL-ITM-TYPE-BG(WS-BILLING-INDX) = 'B'           
              MOVE WS-DATE-ORIG-BILL-BG(WS-BILLING-INDX)                
                                      TO WS-HOLD-BILL-DATE              
           ELSE                                                         
              MOVE WS-DATE-BILLED-BI  TO WS-HOLD-BILL-DATE              
           END-IF                                                       
                                                                        
           MOVE SPACES                TO E-REVDET-TIER-ACCT-TYPE-CD     
                                                                        
ACT004     MOVE WS-ACCOUNT-NO-BG(WS-BILLING-INDX) TO  DD-ACCOUNT-NO.    
ACT004     PERFORM 7260-GET-TIER-ACCT-TYPE-CD THRU 7260-EXIT.           
ACT004                                                                  
ACT004     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT004        MOVE DD-EFF-START-DT    TO WS-HOLD-EFF-START-DT           
ACT004        MOVE DD-TIER-ACCT-TYPE-CD                                 
ACT004                                TO E-REVDET-TIER-ACCT-TYPE-CD     
ACT004     END-IF                                                       
                                                                        
           MOVE E-REVDET-TIER-ACCT-TYPE-CD                              
                                      TO TT-TIER-ACCT-TYPE-CD           
      * GET REVENUE COMPANY NO FOR SEB                                          
           PERFORM 2630-GET-REVENUE-COMPANY-NO                          
                                      THRU 2630-EXIT                    
           MOVE WS-HOLD-SEB-REV-COMP-NO                                 
                                      TO E-REVDET-REV-COMPANY-NO        
                                                                        
      * POPULATE OPTION CODE AND RATE CALC TYPE FOR SEB.                        
                                                                        
           SET WS-BDET-INDX           TO 1                              
                                                                        
           SEARCH WS-BILL-DET-DATA AT END                               
              MOVE SPACES             TO E-REVDET-OPTION-CD             
              WHEN WS-BILL-DET-KEY-BT(WS-BDET-INDX)                     
                            = WS-BILLING-KEY(WS-BILLING-INDX)           
              MOVE WS-OPTION-CD-BT(WS-BDET-INDX)                        
                                      TO E-REVDET-OPTION-CD             
              MOVE WS-RATE-CALC-TYPE-CD-BT(WS-BDET-INDX)                
                                      TO E-REVDET-RATE-CALC-TYPE-CD     
           END-SEARCH                                                   
                                                                        
      * IF OPTION CODE WAS NOT IN THE BILLING FILE GET IT FROM DB2.             
                                                                        
           IF E-REVDET-OPTION-CD = SPACES                               
              MOVE WS-ACCOUNT-NO-BG (WS-BILLING-INDX)                   
                                      TO DF-ACCOUNT-NO                  
              MOVE WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)               
                                      TO DF-CODE-UTIL-TYPE              
                                         FI-CODE-UTIL-TYPE              
              MOVE WS-IC-NO-BG (WS-BILLING-INDX)                        
                                      TO DF-IC-NO                       
              MOVE WS-RT-PKG-OPT-SEQ-NO-BG (WS-BILLING-INDX)            
                                      TO DF-RT-PKG-OPT-SEQ-NO           
              MOVE WS-RATE-PLAN-NO-BG (WS-BILLING-INDX)                 
                                      TO FI-RATE-PLAN-NO                
              MOVE WS-COMPANY-NO-BG (WS-BILLING-INDX)                   
                                      TO FI-COMPANY-NO                  
              MOVE SPACES             TO DF-OPTION-CD                   
                                         FI-OPT-CALC-TYPE-CD            
              PERFORM 7270-GET-OPTION-CODE                              
                                      THRU 7270-EXIT                    
              MOVE DF-OPTION-CD       TO E-REVDET-OPTION-CD             
                                         FI-OPTION-CD                   
              IF FI-OPTION-CD > SPACES                                  
                 PERFORM 7280-GET-OPT-CALC-TYPE-CD                      
                                      THRU 7280-EXIT                    
                 IF FI-OPT-CALC-TYPE-CD > SPACES                        
                    MOVE '02'         TO E-REVDET-RATE-CALC-TYPE-CD     
                 END-IF                                                 
              END-IF                                                    
                                                                        
           END-IF.                                                      
                                                                        
       2640-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *2650-LOAD-REV-BILL-COMP-ADJ.                                   *         
      *POPULATED THE COMMON DATA ELEMENTS FOR REV_BILL_COMP_ADJ TABLE *         
      *****************************************************************         
       2650-LOAD-REV-BILL-COMP-ADJ.                                     
                                                                        
      *WHEN CODE-UTIL-TYPE IS 'U' SET 10 AS THE COMPONENT-ID                    
                                                                        
           IF WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX) = 'U'               
              MOVE '10'               TO E-REVADJ-CMPNT-ID-CD           
                                         WS-TEMP-COMPONENT-ID           
           ELSE                                                         
              MOVE WS-COMPONENT-ID-BC(WS-CALC-INDX)                     
                                      TO E-REVADJ-CMPNT-ID-CD           
                                         WS-TEMP-COMPONENT-ID           
           END-IF                                                       
                                                                        
      *POPULATE CONSUMPTION TYPE                                                
                                                                        
           EVALUATE TRUE                                                
      * DEMAND COMPONENT                                                        
              WHEN WS-HOLD-CNSMPTN-TYPE = 'E' OR 'J' OR 'Q'             
                 MOVE 'D'             TO E-REVADJ-INSTR-USE-TYPE-CD     
                                                                        
      * ENERGY COMPONENT                                                        
              WHEN WS-HOLD-CNSMPTN-TYPE = 'B' OR 'C' OR 'D'             
                 MOVE 'R'             TO E-REVADJ-INSTR-USE-TYPE-CD     
                                                                        
      * UNMETERED POLES                                                         
              WHEN WS-HOLD-CNSMPTN-TYPE = 'P'                           
                 MOVE 'U'             TO E-REVADJ-INSTR-USE-TYPE-CD     
           END-EVALUATE.                                                
                                                                        
           MOVE WS-HOLD-CNSMPTN-TYPE                                    
                                   TO E-REVADJ-CONSUMPT-TYPE-CD         
                                                                        
           MOVE WS-CODE-TOU-BC(WS-CALC-INDX)                            
                                      TO E-REVADJ-CODE-TIME-PERIOD.     
                                                                        
           MOVE WS-CODE-SEASON-BC(WS-CALC-INDX)                         
                                      TO E-REVADJ-CODE-SEASON.          
                                                                        
           MOVE WS-HOLD-RT-VERS-FROM-DT                                 
                                      TO E-REVADJ-RT-VERS-FROM-DT.      
                                                                        
           MOVE WS-HOLD-RT-VERS-PRO-CD                                  
                                      TO E-REVADJ-RT-VERS-PRO-CD.       
T03014                                                                  
T03014     IF MANUAL-BILL                                               
T03014       MOVE WS-TEMP-COMPONENT-ID-J1                               
T03014                                      TO E-REVADJ-CMPNT-ID-CD     
T03014       MOVE ZEROES                    TO E-REVADJ-CODE-TIME-PERIOD
T03014       MOVE SPACES                    TO E-REVADJ-CODE-SEASON     
T03014       MOVE SPACES                    TO E-REVADJ-RT-VERS-PRO-CD  
T03014       MOVE WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX)                 
T03014                                      TO RT-CODE-UTIL-TYPE        
T03014       MOVE WS-RATE-PLAN-NO-BG(WS-BILLING-INDX)                   
T03014                                      TO RT-RATE-PLAN-NO          
T03014       PERFORM 7520-SELECT-RT-VERS-FROM-DT THRU  7520-EXIT        
T03014       MOVE RT-FROM-EFFECTIVE-DT      TO E-REVADJ-RT-VERS-FROM-DT 
T03014     END-IF.                                                      
T03014                                                                  
       2650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *2700-GENERATE-NETNONREV-RECORD.                                *         
      *GENERATE NETNONREV FACTOR.                                     *         
      *****************************************************************         
       2700-GENERATE-NETNONREV-RECORD.                                  
                                                                        
           PERFORM 2650-LOAD-REV-BILL-COMP-ADJ  THRU 2650-EXIT.         
                                                                        
           INITIALIZE FCSCREVC.                                         
                                                                        
           IF WS-CODE-BILL-ITM-TYPE-BG(WS-BILLING-INDX) = 'B' AND       
              WS-HOLD-SERVICE-TYPE = 'G'                                
                                                                        
              MOVE WS-ACCOUNT-NO-BG(WS-BILLING-INDX)                    
                                      TO BZ-ACCOUNT-NO                  
              MOVE WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)               
                                      TO BZ-CODE-UTIL-TYPE              
              MOVE WS-IC-NO-BG (WS-BILLING-INDX)                        
                                      TO BZ-IC-NO                       
              MOVE WS-BILL-ITEM-TIMESTMP-BG(WS-BILLING-INDX)            
                                      TO BZ-BILL-ITEM-TIMESTMP          
              MOVE WS-COMPONENT-ID-BC(WS-CALC-INDX)                     
                                      TO BZ-CMPNT-ID-CD                 
                                                                        
              PERFORM 7500-SELECT-BACKOUT-CNSMPTN                       
                                      THRU 7500-EXIT                    
              COMPUTE WS-REVADJ-READ-UNITS ROUNDED = BZ-READ-UNITS * -1 
              MOVE WS-REVADJ-READ-UNITS                                 
                                      TO WS-HOLD-BZ-READ-UNITS          
                                                                        
           END-IF                                                       
      *GET READ UNITS, BILL UNITS AND CALC UNITS FROM BC.                       
                                                                        
           IF PRORATED                                                  
              PERFORM 2530-PROCESS-PRORATION-USAGE                      
                                                THRU 2530-EXIT          
           ELSE                                                         
              PERFORM 2520-NON-PRORATION-PROCESS                        
                                                THRU 2520-EXIT          
           END-IF                                                       
      *                                                                         
      *****************************************************************         
      *LOGIC TO GENERATE  NETNONREV FACTOR ROW                        *         
      *****************************************************************         
                                                                        
           MOVE WS-CURRENT-TIMESTAMP  TO E-REVADJ-BILL-UNIQUE-TS        
                                                                        
           ADD  1                     TO WS-RUNNING-COUNTER             
                                                                        
           MOVE WS-RUNNING-COUNTER    TO E-REVADJ-BILL-COMP-SEQ-NO      
                                                                        
           MOVE 'NETNONREV'           TO E-REVADJ-FACTOR-ID             
                                                                        
           MOVE 'N'                   TO E-REVADJ-COMP-ADJ-CD           
           MOVE 'N'                   TO E-REVADJ-UTILITY-REV-CD        
                                                                        
           MOVE 0                     TO E-REVADJ-GL-ACCT-NO            
                                                                        
      *SEARCH THE RATE-COMPONENT TABLE - PROCESSING IN BC                       
      * GET THE REVENUE CONSUMPTION FLAG / REVENUE AMOUNT FLAG                  
                                                                        
           PERFORM 2510-SEARCH-RATE-COMPONENT-TBL THRU 2510-EXIT        
                                                                        
           INITIALIZE         WS-TEMP-REV-AMOUNT                        
                                                                        
           IF WS-REVENUE-AMOUNT-FL-TEMP = 'N'                           
              COMPUTE WS-TEMP-REV-AMOUNT                                
                      = WS-UTIL-REV-TRACKED + WS-NON-UTIL-REV-TRACKED   
              MOVE WS-NET-COMPONENT-AMT-BC(WS-CALC-INDX)                
                                      TO E-REVADJ-BILLED-AMT            
              SUBTRACT WS-TEMP-REV-AMOUNT  FROM E-REVADJ-BILLED-AMT     
           ELSE                                                         
              MOVE WS-NONUTIL-REV-NOT-TRACKED                           
                                      TO E-REVADJ-BILLED-AMT            
           END-IF                                                       
                                                                        
      * IF REVENUE-CONSUMPTION-FL = 'N', REPORT CONSUMPTION ONLY IN             
      * NETNONREV ROW.                                                          
           IF WS-REVENUE-CNSMPTN-FL-TEMP = 'N'                          
      *                                                                         
              IF WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX) = 'U'            
                 MOVE WS-REVADJ-READ-UNITS                              
                                   TO E-REVADJ-BILL-USAGE-UNITS         
              ELSE                                                      
                 MOVE WS-REVADJ-BILL-USAGE-UNITS                        
                                   TO E-REVADJ-BILL-USAGE-UNITS         
              END-IF                                                    
              MOVE WS-REVADJ-BILL-DEMAND-UNITS                          
                                   TO E-REVADJ-BILL-DEMAND-UNITS        
              MOVE WS-REVADJ-READ-UNITS                                 
                                   TO E-REVADJ-READ-UNITS               
              MOVE WS-REVADJ-CALC-UNITS                                 
                                   TO E-REVADJ-CALC-UNITS               
           ELSE                                                         
              INITIALIZE              E-REVADJ-BILL-USAGE-UNITS         
                                      E-REVADJ-BILL-DEMAND-UNITS        
                                      E-REVADJ-READ-UNITS               
                                      E-REVADJ-CALC-UNITS               
           END-IF                                                       
                                                                        
P00257     MOVE WS-ACCOUNT-NO-AT   TO E-REVADJ-ACCOUNT-NO               
                                                                        
                                                                        
      * WRITES THE NET NON REVENUE FACTOR(NETNONREV) ROW IN FCSCREVC            
      * (ADJUSTMENT FILE), ONLY WHEN THERE'S SOME DATA TO BE REPORTED.          
           IF E-REVADJ-BILLED-AMT        NOT = 0  OR                    
              E-REVADJ-BILL-USAGE-UNITS  NOT = 0  OR                    
              E-REVADJ-BILL-DEMAND-UNITS NOT = 0  OR                    
              E-REVADJ-READ-UNITS        NOT = 0  OR                    
              E-REVADJ-CALC-UNITS        NOT = 0                        
              PERFORM 8010-WRITE-FCSCREVC     THRU 8010-EXIT            
           END-IF.                                                      
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T03014*****************************************************************         
T03014*2725-GENERATE-NETNONREV-MANUAL.                                *         
T03014*GENERATE THE NET NON REV FACTOR RECORD.                        *         
T03014*****************************************************************         
T03014 2725-GENERATE-NETNONREV-MANUAL.                                  
T03014                                                                  
T03014     MOVE WS-ACCOUNT-NO-AT            TO E-REVADJ-ACCOUNT-NO      
T03014     MOVE WS-CURRENT-TIMESTAMP        TO E-REVADJ-BILL-UNIQUE-TS  
T03014                                                                  
T03014     ADD  1                           TO WS-RUNNING-COUNTER       
T03014                                                                  
T03014     MOVE WS-RUNNING-COUNTER          TO E-REVADJ-BILL-COMP-SEQ-NO
T03014                                                                  
T03014     MOVE 'NETNONREV'                 TO E-REVADJ-FACTOR-ID       
T03014                                                                  
T03014     MOVE 'N'                         TO E-REVADJ-COMP-ADJ-CD     
T03014     MOVE 'N'                         TO E-REVADJ-UTILITY-REV-CD  
T03014                                                                  
T03014     MOVE 0                           TO E-REVADJ-GL-ACCT-NO      
T03014                                                                  
T03014     IF WS-REVENUE-AMOUNT-FL-TEMP = 'N'                           
T03014        MOVE WS-TOTAL-BILL-ITEM-AMT                               
T03014                                      TO E-REVADJ-BILLED-AMT      
T03014     ELSE                                                         
T03014        MOVE 0                        TO E-REVADJ-BILLED-AMT      
T03014     END-IF                                                       
T03014                                                                  
T03014     IF WS-REVENUE-CNSMPTN-FL-TEMP = 'N'                          
T03014        IF WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX) = 'U'            
T03014           MOVE WS-REVADJ-READ-UNITS                              
T03014                                      TO E-REVADJ-BILL-USAGE-UNITS
T03014        ELSE                                                      
T03014           MOVE WS-REVADJ-BILL-USAGE-UNITS                        
T03014                                      TO E-REVADJ-BILL-USAGE-UNITS
T03014        END-IF                                                    
T03014        MOVE WS-REVADJ-BILL-DEMAND-UNITS                          
T03014                                     TO E-REVADJ-BILL-DEMAND-UNITS
T03014        MOVE WS-REVADJ-READ-UNITS                                 
T03014                                      TO E-REVADJ-READ-UNITS      
T03014        MOVE WS-REVADJ-CALC-UNITS                                 
T03014                                      TO E-REVADJ-CALC-UNITS      
T03014     ELSE                                                         
T03014        INITIALIZE              E-REVADJ-BILL-USAGE-UNITS         
T03014                                E-REVADJ-BILL-DEMAND-UNITS        
T03014                                E-REVADJ-READ-UNITS               
T03014                                E-REVADJ-CALC-UNITS               
T03014     END-IF                                                       
T03014                                                                  
T03014     IF E-REVADJ-BILLED-AMT        NOT = 0  OR                    
T03014        E-REVADJ-BILL-USAGE-UNITS  NOT = 0  OR                    
T03014        E-REVADJ-BILL-DEMAND-UNITS NOT = 0  OR                    
T03014        E-REVADJ-READ-UNITS        NOT = 0  OR                    
T03014        E-REVADJ-CALC-UNITS        NOT = 0                        
T03014        PERFORM 8010-WRITE-FCSCREVC     THRU 8010-EXIT            
T03014     END-IF.                                                      
T03014                                                                  
T03014 2725-EXIT.                                                       
T03014     EXIT.                                                        
T03014*                                                                         
      *****************************************************************         
      *2750-GENERATE-NETREVFCT-RECORD.                                *         
      *GENERATE THE NET REVENUE FACTOR RECORD.                        *         
      *****************************************************************         
       2750-GENERATE-NETREVFCT-RECORD.                                  
                                                                        
           INITIALIZE FCSCREVC.                                         
                                                                        
           MOVE WS-CURRENT-TIMESTAMP  TO E-REVADJ-BILL-UNIQUE-TS        
                                                                        
           ADD  1                     TO WS-RUNNING-COUNTER             
                                                                        
           MOVE WS-RUNNING-COUNTER    TO E-REVADJ-BILL-COMP-SEQ-NO      
                                         WS-REVBLK-BILL-COMP-SEQ-NO     
                                                                        
           MOVE 'NETREVFCT'        TO E-REVADJ-FACTOR-ID                
           MOVE 'N'                TO E-REVADJ-COMP-ADJ-CD              
           MOVE 'U'                TO E-REVADJ-UTILITY-REV-CD           
                                                                        
           INITIALIZE         WS-TEMP-REV-AMOUNT                        
                                                                        
           COMPUTE WS-TEMP-REV-AMOUNT = WS-UTIL-REV-TRACKED     +       
                                        WS-NON-UTIL-REV-TRACKED +       
                                        WS-NONUTIL-REV-NOT-TRACKED      
                                                                        
           MOVE WS-NET-COMPONENT-AMT-BC(WS-CALC-INDX)                   
                                   TO E-REVADJ-BILLED-AMT               
PRJ257                                                                  
A02932     IF MONTHLY-MIN AND WS-TEMP-BC-COUNT = WS-TEMP-BC-SEQ-NO      
PRJ257        MOVE WS-TOTAL-BILL-ITEM-AMT   TO E-REVADJ-BILLED-AMT      
PRJ257        SUBTRACT WS-TEMP-REV-AMOUNT   FROM E-REVADJ-BILLED-AMT    
A02932        SUBTRACT WS-HOLD-ANNUAL-MIN-AMT                           
A02932                                      FROM E-REVADJ-BILLED-AMT    
PRJ257        MOVE 'N'                      TO WS-MONTHLY-MIN           
A02932        MOVE ZEROES                   TO WS-HOLD-ANNUAL-MIN-AMT   
PRJ257     ELSE                                                         
PRJ257        SUBTRACT WS-TEMP-REV-AMOUNT   FROM E-REVADJ-BILLED-AMT    
A02932        ADD E-REVADJ-BILLED-AMT       TO WS-HOLD-ANNUAL-MIN-AMT   
A02932        ADD WS-TEMP-REV-AMOUNT        TO WS-HOLD-ANNUAL-MIN-AMT   
PRJ257     END-IF                                                       
PRJ257                                                                  
           IF MANUAL-BILL                                               
              MOVE WS-TOTAL-BILL-ITEM-AMT                               
                                   TO E-REVADJ-BILLED-AMT               
           ELSE                                                         
              MOVE SPACES          TO WS-HOLD-CNSMPTN-TYPE              
              MOVE WS-CONSUMPTION-TYPE-BC(WS-CALC-INDX)                 
                                   TO WS-HOLD-CNSMPTN-TYPE              
           END-IF                                                       
                                                                        
                                                                        
           PERFORM 2650-LOAD-REV-BILL-COMP-ADJ                          
                                   THRU 2650-EXIT                       
           MOVE WS-CODE-STAT-TAX-XMT-BG(WS-BILLING-INDX)                
                                   TO E-REVADJ-CODE-STAT-TAX-XMT        
                                                                        
           MOVE WS-CODE-CITY-TAX-XMT-BG(WS-BILLING-INDX)                
                                   TO E-REVADJ-CODE-CITY-TAX-XMT        
                                                                        
           MOVE WS-HOLD-RT-VERS-FROM-DT                                 
                                      TO E-REVADJ-RT-FCT-FROM-DT        
           MOVE WS-REVADJ-GL-ACCT-NO                                    
                                   TO E-REVADJ-GL-ACCT-NO               
                                                                        
      * IF REVENUE-CONSUMPTION-FL = 'Y', REPORT CONSUMPTION ONLY IN             
      * NETREVFCT ROW.                                                          
           IF WS-REVENUE-CNSMPTN-FL-TEMP = 'N'                          
              INITIALIZE              E-REVADJ-BILL-USAGE-UNITS         
                                      E-REVADJ-BILL-DEMAND-UNITS        
                                      E-REVADJ-READ-UNITS               
                                      E-REVADJ-CALC-UNITS               
           ELSE                                                         
              MOVE WS-REVADJ-READ-UNITS                                 
                                   TO E-REVADJ-READ-UNITS               
              MOVE WS-REVADJ-CALC-UNITS                                 
                                   TO E-REVADJ-CALC-UNITS               
              IF WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX) = 'U'            
                 MOVE WS-REVADJ-READ-UNITS                              
                                   TO E-REVADJ-BILL-USAGE-UNITS         
              ELSE                                                      
                 MOVE WS-REVADJ-BILL-USAGE-UNITS                        
                                   TO E-REVADJ-BILL-USAGE-UNITS         
              END-IF                                                    
              MOVE WS-REVADJ-BILL-DEMAND-UNITS                          
                                   TO E-REVADJ-BILL-DEMAND-UNITS        
           END-IF                                                       
                                                                        
      * IF REVENUE-AMOUNT-FL = 'N', DO NOT REPORT $ AMOUNT IN NETREVFCT.        
           IF WS-REVENUE-AMOUNT-FL-TEMP = 'N'                           
              INITIALIZE              E-REVADJ-BILLED-AMT               
           END-IF                                                       
                                                                        
P00257     MOVE WS-ACCOUNT-NO-AT   TO E-REVADJ-ACCOUNT-NO               
                                                                        
      *****************************************************************         
      * WRITES THE NET REVENUE FACTOR ROW IN FCSCREVC FILE            *         
      *****************************************************************         
           PERFORM 8010-WRITE-FCSCREVC       THRU 8010-EXIT.            
                                                                        
       2750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
I01959*****************************************************************         
I01959*                                                               *         
I01959* 2760-GENERATE-RECOVERY-FACTOR.                                *         
I01959*****************************************************************         
I01959 2760-GENERATE-RECOVERY-FACTOR.                                   
I01959                                                                  
I01959     MOVE WS-ACCOUNT-NO-AT            TO E-REVADJ-ACCOUNT-NO      
I01959     MOVE WS-CURRENT-TIMESTAMP        TO E-REVADJ-BILL-UNIQUE-TS  
I01959                                                                  
I01959     ADD  1                           TO WS-RUNNING-COUNTER       
I01959     MOVE WS-RUNNING-COUNTER          TO E-REVADJ-BILL-COMP-SEQ-NO
I01959     MOVE WS-DER-FACTOR-ID            TO E-REVADJ-FACTOR-ID       
I01959     MOVE 'N'                         TO E-REVADJ-COMP-ADJ-CD     
I01959     MOVE 'N'                         TO E-REVADJ-UTILITY-REV-CD  
I01959     MOVE WS-TOTAL-BILL-ITEM-AMT      TO E-REVADJ-BILLED-AMT      
I01959     INITIALIZE              E-REVADJ-BILL-USAGE-UNITS            
I01959                             E-REVADJ-BILL-DEMAND-UNITS           
I01959                             E-REVADJ-READ-UNITS                  
I01959                             E-REVADJ-CALC-UNITS                  
I01959                             E-REVADJ-GL-ACCT-NO                  
I01959                                                                  
I01959     IF WS-DER-FACTOR-ID EQUAL WS-DER-CALC-PBI-FCTR               
I01959        MOVE WS-TOT-BILL-UNITS        TO E-REVADJ-BILL-USAGE-UNITS
I01959     END-IF                                                       
I01959                                                                  
I01959     PERFORM 8010-WRITE-FCSCREVC         THRU 8010-EXIT.          
I01959                                                                  
I01959 2760-EXIT.                                                       
I01959     EXIT.                                                        
I01959*                                                                         
I01959*                                                                         
      *****************************************************************         
      *2800-GET-PRORATE-FL.                                           *         
      *SEARCH THE SPCL FACTOR TABLE TO GET PRORATE FL FOR THE FACTOR  *         
      *****************************************************************         
       2800-GET-PRORATE-FL.                                             
                                                                        
           SET WS-SF-INDX                TO 1.                          
           MOVE SPACES                   TO WS-PRORATE-FL-TEMP.         
           SEARCH WS-SF-FCTR-DATA       AT END                          
                  MOVE SPACES            TO WS-PRORATE-FL-TEMP          
              WHEN WS-SF-FACTOR-ID-ARR(WS-SF-INDX) =                    
                   SF-FACTOR-ID                                         
                   MOVE WS-SF-PRORATE-FL-ARR(WS-SF-INDX)                
                                         TO WS-PRORATE-FL-TEMP          
                   MOVE WS-SF-REV-INTERFACE-FL-ARR(WS-SF-INDX)          
                                         TO                             
                        WS-REV-INTERFACE-FL-BA(WS-BILL-ADJ-INDX)        
                   MOVE WS-SF-SPCL-GROUP-CD-ARR(WS-SF-INDX)             
                                         TO                             
                        WS-SPCL-GROUP-CD-BA(WS-BILL-ADJ-INDX)           
           END-SEARCH.                                                  
                                                                        
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *2850-PROCESS-MANUAL-BILLS.                                     *         
      *PROCESS TO GENERATE REVENUE DETAILS FOR MANUAL BILLS.          *         
      *****************************************************************         
       2850-PROCESS-MANUAL-BILLS.                                       
                                                                        
           INITIALIZE                     WS-REVADJ-READ-UNITS          
                                          WS-REVADJ-BILL-USAGE-UNITS    
                                          WS-REVADJ-BILL-DEMAND-UNITS   
                                          WS-REVADJ-CALC-UNITS.         
                                                                        
      *GET USAGE FOR A NONE-CALC FROM CX.                                       
           PERFORM 2560-READ-UNITS-PROCESS                              
                                           THRU 2560-EXIT.              
           MOVE WS-NONCAL-READ-UNITS       TO WS-REVADJ-READ-UNITS      
           MOVE WS-NONCAL-BILL-USAGE-UNITS TO                           
                                         WS-REVADJ-BILL-USAGE-UNITS     
      *FOR NONE-CALCS THE USERS ENTER THERMS, CALCULATE THE CCF FOR             
      *READ UNITS                                                               
           IF WS-CODE-BILL-CALC-BG(WS-BILLING-INDX) = 'S'               
           AND WS-CODE-BILL-ITM-TYPE-BG(WS-BILLING-INDX) = 'C'          
           AND WS-HOLD-SERVICE-TYPE = 'G'                               
              PERFORM 2540-CALC-BACKOUT-CNSMPTN                         
                                           THRU 2540-EXIT               
           END-IF.                                                      
                                                                        
T03014*    GENERATE THE NETNONREV RECORD                                        
T03014                                                                  
T03014     MOVE WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX)                   
T03014                                      TO J1-CODE-UTIL-TYPE        
T03014     MOVE WS-RATE-PLAN-NO-BG(WS-BILLING-INDX)                     
T03014                                      TO J1-RATE-PLAN-NO          
T03014     IF WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX) = 'U'               
T03014        MOVE '10'                     TO  WS-TEMP-COMPONENT-ID    
T03014                                          WS-TEMP-COMPONENT-ID-J1 
T03014     ELSE                                                         
T03014        PERFORM 7510-SELECT-CMPNT-ID-CD     THRU 7510-EXIT        
T03014        MOVE J1-CMPNT-ID-CD           TO  WS-TEMP-COMPONENT-ID    
T03014                                          WS-TEMP-COMPONENT-ID-J1 
T03014     END-IF                                                       
T03014     PERFORM 2510-SEARCH-RATE-COMPONENT-TBL THRU 2510-EXIT        
T03014     PERFORM 2650-LOAD-REV-BILL-COMP-ADJ    THRU 2650-EXIT        
T03014     PERFORM 2725-GENERATE-NETNONREV-MANUAL                       
T03014                                            THRU 2725-EXIT        
T03014                                                                  
      *GENERATE THE NETREVFCT RECORD                                            
                                                                        
           PERFORM 2750-GENERATE-NETREVFCT-RECORD                       
                                           THRU 2750-EXIT.              
                                                                        
       2850-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *2900-GET-PREV-REV-DTLS.                                        *         
      *PROCESS TO GET ORIGINAL BILL'S REVENUE DETAILS FOR C/R.        *         
      *****************************************************************         
       2900-GET-PREV-REV-DTLS.                                          
                                                                        
           INITIALIZE                     FCSCREVD                      
                                          FCSCREVC                      
                                          FCSCREVB                      
                                          FCSCREVT.                     
                                                                        
           PERFORM 7050-GET-CURR-TIMESTAMP THRU 7050-EXIT               
                   UNTIL WS-PREV-TIMESTAMP NOT = WS-CURRENT-TIMESTAMP.  
                                                                        
      * CHECK IF THE BACKOUT IS ASSOCIATED TO A CANCEL/REBILL.                  
           IF WS-BILL-ITEM-TIMESTMP-BG (WS-BILLING-INDX) NOT =          
                                           BG-BILL-ITEM-TIMESTMP        
                                                                        
              MOVE WS-BILL-ITEM-TIMESTMP-BG (WS-BILLING-INDX)           
                                           TO BG-BILL-ITEM-TIMESTMP     
                                                                        
              PERFORM 7304-GET-CANCEL-BILL-DTL                          
                                           THRU 7304-EXIT               
           END-IF                                                       
                                                                        
           MOVE WS-CURRENT-TIMESTAMP       TO WS-PREV-TIMESTAMP.        
           MOVE BG-ACCOUNT-NO              TO RV-ACCOUNT-NO.            
           MOVE BG-CODE-UTIL-TYPE          TO RV-CODE-UTIL-TYPE.        
           MOVE BG-IC-NO                   TO RV-IC-NO.                 
           MOVE BG-BILL-NO                 TO RV-BILL-NO.               
           MOVE BG-BILL-ITEM-TIMESTMP      TO RV-BILL-ITEM-TIMESTMP.    
                                                                        
      *GET DATA FROM REV_BILLING_DET FOR THE ORIGINAL BILL.                     
           PERFORM 7400-GET-REV-BILLING-DET                             
                                           THRU 7400-EXIT.              
                                                                        
      *ONCE A MATCH IS FOUND IN REV_* TABLES CREATE THE ORIGINAL DTLS.          
           IF DO-NOT-CALL-BILL-CALC                                     
      *                                                                         
A03411        MOVE WS-LOCAL-OFFICE-AT      TO E-REVDET-LOCAL-OFFICE     
      *                                                                         
              MOVE DCLREV-BILLING-DET      TO FCSCREVD                  
              MOVE WS-CURRENT-TIMESTAMP    TO E-REVDET-BILL-UNIQUE-TS   
ACT154        IF WS-CODE-DR-CR-CNSMPTN-BG(WS-BILLING-INDX) = 'C'        
ACT154           MULTIPLY -1 BY E-REVDET-DESIGN-DAY-CAP                 
ACT154        END-IF                                                    
              MOVE WS-REVENUE-MONTH-BG(WS-BILLING-INDX)                 
                                           TO E-REVDET-REVENUE-MONTH    
              MOVE WS-BILL-NO-BG(WS-BILLING-INDX)                       
                                           TO E-REVDET-BILL-NO          
              MOVE WS-BILL-ITEM-TIMESTMP-BG(WS-BILLING-INDX)            
                                          TO E-REVDET-BILL-ITEM-TIMESTMP
                                                                        
              PERFORM 2430-CUSTOMER-COUNT-PROCESS THRU 2430-EXIT        
                                                                        
              MOVE WS-DATE-BILLED-BI       TO E-REVDET-DATE-BILLED      
                                                                        
              IF WS-DATE-ORIG-BILL-BG(WS-BILLING-INDX) <= SPACES        
                 MOVE SPACES               TO E-REVDET-DATE-ORIG-BILL   
              ELSE                                                      
                 MOVE WS-DATE-ORIG-BILL-BG(WS-BILLING-INDX)             
                                           TO E-REVDET-DATE-ORIG-BILL   
              END-IF                                                    
                                                                        
              MOVE WS-REV-MTH-ORIG-BILL-BG(WS-BILLING-INDX)             
                                           TO E-REVDET-REV-MTH-ORIG-BILL
              PERFORM 2435-GET-CALC-SOURCE-CODE                         
                                           THRU 2435-EXIT               
                                                                        
A04581        IF WS-COMPANY-NO-BG (WS-BILLING-INDX)     = '01' AND      
A04581           WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) = 'E'           
A04581             MOVE WS-RT-PKG-OPT-SEQ-NO-BG (WS-BILLING-INDX)       
A04581               TO E-REVDET-ELEC-WNA-GROUP-NO                      
A04581        END-IF                                                    
                                                                        
              PERFORM 8000-WRITE-FCSCREVD  THRU 8000-EXIT               
                                                                        
      *CREATE REV_ADJ DATA FOR ORIGINAL BILL.                                   
              PERFORM 2910-PROCESS-REV-BILL-COMP-ADJ                    
                                           THRU 2910-EXIT               
                                                                        
      *CREATE REV_BLK DATA FOR ORIGINAL BILL.                                   
              PERFORM 2920-PROCESS-REV-BILL-BLOCK                       
                                           THRU 2920-EXIT               
                                                                        
      *CREATE REV_TAX DATA FOR ORIGINAL BILL.                                   
              PERFORM 2930-PROCESS-REV-BILL-TAX                         
                                           THRU 2930-EXIT               
           END-IF.                                                      
                                                                        
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *2910-PROCESS-REV-BILL-COMP-ADJ.                                *         
      *PROCESS TO WRITE REV-BILL-COMP-ADJ DATA FOR C/R.               *         
      *****************************************************************         
       2910-PROCESS-REV-BILL-COMP-ADJ.                                  
                                                                        
           PERFORM 7410-OPEN-REV-ADJ-CSR   THRU 7410-EXIT.              
           PERFORM 7420-FETCH-REV-ADJ-CSR  THRU 7420-EXIT.              
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              MOVE DCLREV-BILL-COMP-ADJ    TO FCSCREVC                  
              MOVE WS-CURRENT-TIMESTAMP    TO E-REVADJ-BILL-UNIQUE-TS   
              MULTIPLY -1                  BY E-REVADJ-READ-UNITS       
              MULTIPLY -1                  BY E-REVADJ-CALC-UNITS       
              MULTIPLY -1                  BY E-REVADJ-BILL-USAGE-UNITS 
              MULTIPLY -1                  BY E-REVADJ-BILL-DEMAND-UNITS
              MULTIPLY -1                  BY E-REVADJ-BILLED-AMT       
                                                                        
              PERFORM 8010-WRITE-FCSCREVC  THRU 8010-EXIT               
                                                                        
              PERFORM 7420-FETCH-REV-ADJ-CSR                            
                                           THRU 7420-EXIT               
           END-PERFORM.                                                 
                                                                        
           PERFORM 7430-CLOSE-REV-ADJ-CSR  THRU 7430-EXIT.              
                                                                        
       2910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *2920-PROCESS-REV-BILL-BLOCK.                                   *         
      *PROCESS TO WRITE REV-BILL-BLOCK DATA FOR C/R.                  *         
      *****************************************************************         
       2920-PROCESS-REV-BILL-BLOCK.                                     
                                                                        
           PERFORM 7440-OPEN-REV-BLK-CSR   THRU 7440-EXIT.              
           PERFORM 7450-FETCH-REV-BLK-CSR  THRU 7450-EXIT.              
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              MOVE DCLREV-BILL-BLOCK       TO FCSCREVB                  
              MOVE WS-CURRENT-TIMESTAMP    TO E-REVBLK-BILL-UNIQUE-TS   
              MULTIPLY -1                 BY E-REVBLK-BLK-BILL-USE-UNITS
              MULTIPLY -1                 BY E-REVBLK-BLK-BILL-DEM-UNITS
              MULTIPLY -1                 BY E-REVBLK-BLK-BILL-LT-POLES 
              MULTIPLY -1                 BY E-REVBLK-BLK-REV-AMT       
                                                                        
              PERFORM 8020-WRITE-FCSCREVB  THRU 8020-EXIT               
                                                                        
              PERFORM 7450-FETCH-REV-BLK-CSR                            
                                           THRU 7450-EXIT               
           END-PERFORM.                                                 
                                                                        
           PERFORM 7460-CLOSE-REV-BLK-CSR  THRU 7460-EXIT.              
                                                                        
       2920-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *2930-PROCESS-REV-BILL-TAX.                                     *         
      *PROCESS TO WRITE REV-BILL-TAX DATA FOR C/R.                    *         
      *****************************************************************         
       2930-PROCESS-REV-BILL-TAX.                                       
                                                                        
           PERFORM 7470-OPEN-REV-TAX-CSR   THRU 7470-EXIT.              
           PERFORM 7480-FETCH-REV-TAX-CSR  THRU 7480-EXIT.              
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              MOVE DCLREV-BILL-TAX         TO FCSCREVT                  
              MOVE WS-CURRENT-TIMESTAMP    TO E-REVTAX-BILL-UNIQUE-TS   
              MULTIPLY -1                  BY E-REVTAX-TAX-AMT          
                                                                        
A04581        IF R9-TAX-TYPE NOT = 'T' AND R9-FACTOR-ID NOT ='RECCHGTAX'
A04581           PERFORM 8030-WRITE-FCSCREVT  THRU 8030-EXIT            
A04581        END-IF                                                    
                                                                        
              PERFORM 7480-FETCH-REV-TAX-CSR                            
                                           THRU 7480-EXIT               
           END-PERFORM.                                                 
                                                                        
           PERFORM 7490-CLOSE-REV-TAX-CSR  THRU 7490-EXIT.              
                                                                        
       2930-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
I01959*****************************************************************         
I01959*                                                               *         
I01959* 2940-CALC-CUST-GEN-UNITS.                                      *        
I01959*****************************************************************         
I01959 2940-CALC-CUST-GEN-UNITS.                                        
I01959                                                                  
I01959     PERFORM VARYING WS-BILLING-INDX FROM 1 BY 1 UNTIL            
I01959        WS-BILLING-INDX  > WS-BG-MAX-ENTRY OR                     
I01959        WS-ACCOUNT-NO-BG (WS-BILLING-INDX) = +0                   
I01959                                                                  
I01959        MOVE WS-RATE-PLAN-NO-BG(WS-BILLING-INDX) TO               
I01959                                             WS-DER-RATE-PLAN-NO  
I01959        IF WS-CODE-BILL-ITM-TYPE-BG(WS-BILLING-INDX) NOT EQUAL 'B'
I01959                                             AND DER-RATE-PLAN-NO 
I01959           PERFORM 2615-PROCESS-GEN-CX    THRU 2615-EXIT          
I01959           MOVE WS-ACCOUNT-NO-BG(WS-BILLING-INDX)                 
I01959                                   TO WS-DER-ACCOUNT-NO(DER-KEYS) 
I01959           IF WS-REV-MTH-ORIG-BILL-BG(WS-BILLING-INDX)            
I01959                                             GREATER THAN ZEROES  
I01959                MOVE WS-REV-MTH-ORIG-BILL-BG(WS-BILLING-INDX)     
I01959                                   TO WS-DER-REVENUE-MTH(DER-KEYS)
I01959                MOVE 'Y'           TO WS-DER-REBILL-FL(DER-KEYS)  
I01959           ELSE                                                   
I01959                MOVE WS-REVENUE-MONTH-BG(WS-BILLING-INDX)         
I01959                                   TO WS-DER-REVENUE-MTH(DER-KEYS)
I01959           END-IF                                                 
I01959           MOVE  WS-RATE-PLAN-NO-BG(WS-BILLING-INDX)              
I01959                                   TO WS-DER-RATE-PLAN(DER-KEYS)  
I01959           MOVE  WS-TOTAL-GEN-UNITS                               
I01959                                   TO WS-DER-GEN-NONTOU(DER-KEYS) 
I01959           MOVE WS-GEN-UNITS-ONPEAK                               
I01959                                   TO WS-DER-GEN-ONPEAK(DER-KEYS) 
I01959           MOVE WS-GEN-UNITS-OFFPEAK                              
I01959                                   TO WS-DER-GEN-OFFPEAK(DER-KEYS)
I01959           MOVE WS-GEN-UNITS-SHLDR                                
I01959                                   TO WS-DER-GEN-SHLDR(DER-KEYS)  
I01959           SET DER-KEYS UP BY 1                                   
I01959        END-IF                                                    
I01959     END-PERFORM.                                                 
I01959                                                                  
I01959 2940-EXIT.                                                       
I01959     EXIT.                                                        
I01959*                                                                         
I01959*                                                                         
      *****************************************************************         
      *5500-SETUP-FOR-CALC                                            *         
      *SET UP FOR BILL CALCULATION.                                   *         
      *****************************************************************         
       5500-SETUP-FOR-CALC.                                             
                                                                        
           INITIALIZE    WS-BILLING-COMPONENT                           
                         WS-BILLING-CALC-WORK                           
                         WS-BILLING-ADJUSTMENT                          
                         WS-BILL-CALC-BG                                
                         WS-BILL-CALC-CX                                
                         WS-BILL-CALC-UC                                
                         WS-BILL-CALC-FH                                
                         WS-BILL-CALC-DETAIL-X                          
                         WS-BC-VOL-DAILY-ND                             
                         WS-BC-ACCT-RTPK-AGR-DF                         
                         WS-BILL-CONTRACT-BK                            
                         WS-BILL-CNTR-HIST-BX                           
                         WS-BC-FIXED-FCTR-FF                            
                         WS-BC-BILL-DET-BT                              
                         WS-BC-BILL-ADJUSTMNT                           
                         LS-INPUT-DATE                                  
                         LS-CURR-WQ-ITEM                                
                         WS-BILLING-WQ-ITEMS-WF                         
                         WS-BC-AMT-BILL-ITEM-BG                         
P00496                   WS-BILL-BSLN-CNTR-LN                           
P00496                   WS-BILL-BSLN-HIST-LO                           
P00496                   WS-UTL-BILL-REL-TABLE-UR                       
VKSACT                   WS-INTERRUPT-NZ                                
P00496                   WS-CNSMPTN-HOURLY .                            
                                                                        
           MOVE 'COG REPORT'            TO LS-INPUT-DATE.               
           MOVE WS-ACCOUNT-NO-BG (WS-BILLING-INDX)                      
                                        TO WS-BC-ACCOUNT-NO-BG.         
           MOVE WS-BILL-ITEM-TIMESTMP-BG (WS-BILLING-INDX)              
                                        TO WS-BC-BILL-ITEM-TIMESTMP-BG. 
                                                                        
I01959     IF DER-RECOVERY-PROCESS                                      
I01959        MOVE WS-BILL-NO-BG (WS-BILLING-INDX)                      
I01959                                       TO WS-BC-BILL-NO-BG        
I01959        IF WS-REV-MTH-ORIG-BILL-BG (WS-BILLING-INDX) > ZEROES     
I01959           MOVE WS-REV-MTH-ORIG-BILL-BG (WS-BILLING-INDX)         
I01959                                       TO WS-BC-REVENUE-MONTH-BG  
I01959                                          LS-CURR-REVENUE-MONTH   
I01959        ELSE                                                      
I01959           MOVE WS-REVENUE-MONTH-BG (WS-BILLING-INDX)             
I01959                                       TO WS-BC-REVENUE-MONTH-BG  
I01959                                          LS-CURR-REVENUE-MONTH   
I01959        END-IF                                                    
I01959        IF WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX) > SPACES        
I01959           MOVE WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX)            
I01959                                       TO WS-BC-CALC-DATE         
I01959                                          WS-BC-CURRENT-DATE      
I01959        ELSE                                                      
I01959           MOVE WS-DATE-BILLED-BI      TO WS-BC-CALC-DATE         
I01959                                          WS-BC-CURRENT-DATE      
I01959        END-IF                                                    
I01959     ELSE                                                         
      * CHECK IF THE BACKOUT IS ASSOCIATED TO A CANCEL/REBILL.                  
              IF WS-BC-BILL-ITEM-TIMESTMP-BG NOT = BG-BILL-ITEM-TIMESTMP
      * GET THE BILL-NO FROM THE PREVIOUSLY CANCELED ROW.                       
                 MOVE WS-BC-BILL-ITEM-TIMESTMP-BG                       
                                        TO BG-BILL-ITEM-TIMESTMP        
                 PERFORM 7305-GET-PREVIOUS-BILL-NO                      
                                        THRU 7305-EXIT                  
                 IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                    MOVE BG-BILL-NO        TO WS-BC-BILL-NO-BG          
                 ELSE                                                   
                    MOVE BI-BILL-NO        TO WS-BC-BILL-NO-BG          
                 END-IF                                                 
              ELSE                                                      
      * GET THE BILL-NO FROM THE ORIGINAL BILL.                                 
                 MOVE BG-BILL-NO           TO WS-BC-BILL-NO-BG          
              END-IF                                                    
              MOVE WS-REV-MTH-ORIG-BILL-BG (WS-BILLING-INDX)            
                                           TO WS-BC-REVENUE-MONTH-BG    
                                              LS-CURR-REVENUE-MONTH     
              MOVE WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX)               
                                           TO WS-BC-CALC-DATE           
                                              WS-BC-CURRENT-DATE        
I01959     END-IF                                                       
                                                                        
                                                                        
           MOVE WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)                  
                                        TO WS-BC-CODE-UTIL-TYPE-BG.     
           MOVE WS-IC-NO-BG (WS-BILLING-INDX)                           
                                        TO WS-BC-IC-NO-BG.              
           MOVE WS-PREMISE-NO-BG (WS-BILLING-INDX)                      
                                        TO WS-BC-PREMISE-NO-BG.         
           MOVE WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX)                  
                                        TO WS-BC-DATE-ORIG-BILL-BG.     
           MOVE WS-REV-MTH-ORIG-BILL-BG (WS-BILLING-INDX)               
                                        TO WS-BC-REV-MTH-ORIG-BILL-BG.  
           MOVE WS-AMT-BILL-ITEM-BG (WS-BILLING-INDX)                   
                                        TO WS-BC-AMT-BILL-ITEM-BG       
                                           WS-AMT-BILL-ITEM-HOLD.       
           MOVE WS-CODE-BILL-CALC-BG (WS-BILLING-INDX)                  
                                        TO WS-BC-CODE-BILL-CALC-BG.     
           MOVE WS-CODE-BILL-ITM-TYPE-BG (WS-BILLING-INDX)              
                                        TO WS-BC-CODE-BILL-ITM-TYPE-BG. 
           MOVE WS-CODE-BILL-ITM-IND-BG (WS-BILLING-INDX)               
                                        TO WS-BC-CODE-BILL-ITM-IND-BG.  
           MOVE WS-CODE-DR-CR-CNSMPTN-BG (WS-BILLING-INDX)              
                                        TO WS-BC-CODE-DR-CR-CNSMPTN-BG. 
           MOVE WS-AMT-STATE-TAX-BG (WS-BILLING-INDX)                   
                                        TO WS-BC-AMT-STATE-TAX-BG       
                                           WS-AMT-STATE-TAX-HOLD.       
           MOVE WS-AMT-CITY-TAX-BG (WS-BILLING-INDX)                    
                                        TO WS-BC-AMT-CITY-TAX-BG        
                                           WS-AMT-CITY-TAX-HOLD.        
           MOVE WS-AMT-OTHER-TAX-BG (WS-BILLING-INDX)                   
                                        TO WS-BC-AMT-OTHER-TAX-BG       
                                           WS-AMT-OTHER-TAX-HOLD.       
           MOVE WS-CODE-REVENUE-CLASS-BG (WS-BILLING-INDX)              
                                        TO WS-BC-CODE-REVENUE-CLASS-BG. 
           MOVE WS-CODE-SIC-NO-BG (WS-BILLING-INDX)                     
                                        TO WS-BC-CODE-SIC-NO-BG.        
           MOVE WS-RATE-PLAN-NO-BG (WS-BILLING-INDX)                    
                                        TO WS-BC-RATE-PLAN-NO-BG.       
           MOVE WS-CODE-STAT-TAX-XMT-BG (WS-BILLING-INDX)               
                                        TO WS-BC-CODE-STAT-TAX-XMT-BG.  
           MOVE WS-CODE-CITY-TAX-XMT-BG (WS-BILLING-INDX)               
                                        TO WS-BC-CODE-CITY-TAX-XMT-BG.  
           MOVE WS-CODE-OTHR-TAX-XMT-BG (WS-BILLING-INDX)               
                                        TO WS-BC-CODE-OTHR-TAX-XMT-BG.  
           MOVE WS-REV-RPT-CD-BG (WS-BILLING-INDX)                      
                                        TO WS-BC-REV-RPT-CD-BG.         
           MOVE WS-STANDBY-COMPLIED-BG (WS-BILLING-INDX)                
                                        TO WS-BC-STANDBY-COMPLIED-BG.   
           MOVE WS-PRORATE-CD-BG (WS-BILLING-INDX)                      
                                        TO WS-BC-PRORATE-CD-BG.         
           MOVE WS-NEW-RATE-PCT-BG (WS-BILLING-INDX)                    
                                        TO WS-BC-NEW-RATE-PCT-BG.       
           MOVE WS-CODE-SUB-TOTAL-BG (WS-BILLING-INDX)                  
                                        TO WS-BC-CODE-SUB-TOTAL-BG.     
           MOVE WS-TAX-REFUND-CD-BG (WS-BILLING-INDX)                   
                                        TO WS-BC-TAX-REFUND-CD-BG.      
           MOVE WS-COMPANY-NO-BG (WS-BILLING-INDX)                      
                                        TO WS-BC-COMPANY-NO-BG.         
           MOVE WS-DATE-LFTM-HI-DMD-BG (WS-BILLING-INDX)                
                                        TO WS-BC-DATE-LFTM-HI-DMD-BG.   
           MOVE WS-LFTM-HI-PEAK-DMD-BG (WS-BILLING-INDX)                
                                        TO WS-BC-LFTM-HI-PEAK-DMD-BG.   
           MOVE WS-REBILL-IND-BG (WS-BILLING-INDX)                      
                                        TO WS-BC-REBILL-IND-BG.         
           MOVE WS-GAS-BASE-USE-BG (WS-BILLING-INDX)                    
                                        TO WS-BC-GAS-BASE-USE-BG.       
           MOVE WS-WNA-FACTOR-BG (WS-BILLING-INDX)                      
                                        TO WS-BC-WNA-FACTOR-BG.         
           MOVE WS-BTU-FACTOR-BG (WS-BILLING-INDX)                      
                                        TO WS-BC-BTU-FACTOR-BG.         
           MOVE WS-ADJ-REASON-CD-BG (WS-BILLING-INDX)                   
                                        TO WS-BC-ADJ-REASON-CD-BG.      
           MOVE WS-CODE-MTR-READ-FREQ-BG (WS-BILLING-INDX)              
                                        TO WS-BC-CODE-MTR-READ-FREQ-BG. 
           MOVE WS-SPLY-SENSITIVE-IND-BG (WS-BILLING-INDX)              
                                        TO WS-BC-SPLY-SENSITIVE-IND-BG. 
           MOVE ZEROES                  TO WS-BC-ELEC-CONTRACT-DEMAND.  
           MOVE WS-RT-PKG-OPT-SEQ-NO-BG (WS-BILLING-INDX)               
                                        TO WS-BC-RT-PKG-OPT-SEQ-NO-BG.  
ACT004     MOVE ' '                  TO WS-BC-PRORATE-OVERRIDE-IND      
           MOVE 'I'                     TO WS-BC-CODE-BILL-STATUS-BI.   
                                                                        
           INITIALIZE WS-BILL-CALC-CX.                                  
           SET CX-INDX TO 1.                                            
           PERFORM VARYING SUB7 FROM 1 BY 1 UNTIL SUB7 > WS-UC-MAX-ENTRY
                   OR WS-ACCOUNT-NO-CX(SUB7) = +0                       
              IF WS-BILLING-KEY-CX(SUB7) =                              
                             WS-BILLING-KEY (WS-BILLING-INDX)           
                 PERFORM 5600-MOVE-CX-FIELDS THRU 5600-EXIT             
                 SET CX-INDX UP BY 1                                    
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           INITIALIZE WS-BILL-CALC-UC.                                  
           SET UC-INDX TO 1.                                            
           PERFORM VARYING SUB7 FROM 1 BY 1 UNTIL SUB7 > WS-UM-MAX-ENTRY
                   OR WS-ACCOUNT-NO-UC(SUB7) = +0                       
              IF WS-BILLING-KEY-UC(SUB7) =                              
                             WS-BILLING-KEY (WS-BILLING-INDX)           
                PERFORM 5700-MOVE-UC-FIELDS THRU 5700-EXIT              
                SET UC-INDX UP BY 1                                     
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           INITIALIZE WS-BILLING-ADJUSTMENT.                            
           SET WS-BC-ADJUSTMNT-INDEX TO 1.                              
           PERFORM VARYING SUB7 FROM 1 BY 1 UNTIL SUB7 > WS-BP-MAX-ENTRY
                   OR WS-ACCOUNT-NO-BP(SUB7) = +0                       
              IF WS-ACCOUNT-NO-BP(SUB7)                                 
                    = WS-ACCOUNT-NO-BG(WS-BILLING-INDX)                 
                 AND WS-BILL-NO-BP(SUB7)                                
                    = WS-BILL-NO-BG(WS-BILLING-INDX)                    
                 AND WS-CODE-UTIL-TYPE-BP(SUB7)                         
                    = WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX)             
                 AND WS-IC-NO-BP(SUB7)                                  
                    = WS-IC-NO-BG(WS-BILLING-INDX)                      
                 AND WS-BILL-ITEM-TIMESTMP-BP(SUB7)                     
                    = WS-BILL-ITEM-TIMESTMP-BG(WS-BILLING-INDX)         
                                                                        
                PERFORM 5750-MOVE-BP-FIELDS THRU 5750-EXIT              
                SET WS-BC-ADJUSTMNT-INDEX UP BY 1                       
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
I01959     IF DER-RECOVERY-PROCESS                                      
I01959        PERFORM 5520-SET-VOL-BILL-UNITS THRU 5520-EXIT            
I01959     END-IF.                                                      
                                                                        
       5500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
I01959*****************************************************************         
I01959*                                                               *         
I01959* 5510-CALC-VOL-BILL-UNITS.                                     *         
I01959*****************************************************************         
I01959 5510-CALC-VOL-BILL-UNITS.                                        
I01959                                                                  
I01959     MOVE 'N'                          TO WS-ACCOUNT-ON-TOU-RATE  
I01959     INITIALIZE WS-BC-VOL-DAILY-ND                                
I01959                WS-TOT-BILL-UNITS                                 
I01959                WS-EXCESS-PRIOR-UNITS                             
I01959                WS-DELIVERED-UNITS                                
I01959                WS-BILLED-NON-TOU                                 
I01959                WS-BILLED-ONPEAK                                  
I01959                WS-BILLED-OFFPEAK                                 
I01959                WS-BILLED-SHLDR                                   
I01959     SET WS-BC-ND-INDX TO 1                                       
I01959     PERFORM VARYING SUB7 FROM 1 BY 1                             
I01959                   UNTIL SUB7 > WS-ND-MAX-ENTRY                   
I01959                         OR WS-ACCOUNT-NO-ND(SUB7) = +0           
I01959        IF WS-BILLING-KEY-ND(SUB7) =                              
I01959                    WS-BILLING-KEY (WS-BILLING-INDX)              
I01959           EVALUATE WS-VOL-TYPE-CD-ND(SUB7)                       
I01959               WHEN WS-DELIVERED                                  
I01959               WHEN WS-GENERATED                                  
I01959                    IF WS-CODE-TIME-PERIOD-ND(SUB7) = WS-NON-TOU  
I01959                       COMPUTE WS-BILLED-NON-TOU =                
I01959                          WS-BILLED-NON-TOU + WS-NO-UNITS-ND(SUB7)
I01959                    END-IF                                        
I01959                    IF WS-CODE-TIME-PERIOD-ND(SUB7) = WS-ON-PEAK  
I01959                       COMPUTE WS-BILLED-ONPEAK =                 
I01959                           WS-BILLED-ONPEAK + WS-NO-UNITS-ND(SUB7)
I01959                    END-IF                                        
I01959                    IF WS-CODE-TIME-PERIOD-ND(SUB7) = WS-OFF-PEAK 
I01959                       COMPUTE WS-BILLED-OFFPEAK =                
I01959                          WS-BILLED-OFFPEAK + WS-NO-UNITS-ND(SUB7)
I01959                    END-IF                                        
I01959                    IF WS-CODE-TIME-PERIOD-ND(SUB7) = WS-SHOULDER 
I01959                       COMPUTE WS-BILLED-SHLDR  =                 
I01959                            WS-BILLED-SHLDR + WS-NO-UNITS-ND(SUB7)
I01959                    END-IF                                        
I01959                    IF WS-VOL-TYPE-CD-ND(SUB7) EQUAL WS-DELIVERED 
I01959                       COMPUTE WS-DELIVERED-UNITS =               
I01959                        WS-NO-UNITS-ND(SUB7) +  WS-DELIVERED-UNITS
I01959                    END-IF                                        
I01959                    IF WS-CODE-TIME-PERIOD-ND(SUB7) = WS-ON-PEAK  
I01959                     OR WS-CODE-TIME-PERIOD-ND(SUB7) = WS-OFF-PEAK
I01959                     OR WS-CODE-TIME-PERIOD-ND(SUB7) = WS-SHOULDER
I01959                        MOVE 'Y'       TO WS-ACCOUNT-ON-TOU-RATE  
I01959                    END-IF                                        
I01959               WHEN WS-EXCESS-PRIOR-MTH                           
I01959                    COMPUTE WS-EXCESS-PRIOR-UNITS =               
I01959                       WS-NO-UNITS-ND(SUB7)+ WS-EXCESS-PRIOR-UNITS
I01959           END-EVALUATE                                           
I01959        END-IF                                                    
I01959     END-PERFORM.                                                 
I01959                                                                  
I01959     COMPUTE WS-BILLED-NON-TOU   = WS-BILLED-NON-TOU +            
I01959                                   (WS-TOTAL-GEN-UNITS * -1).     
I01959     IF WS-BILLED-NON-TOU < 0                                     
I01959        MOVE ZEROES                    TO WS-BILLED-NON-TOU       
I01959     END-IF                                                       
I01959     COMPUTE WS-BILLED-ONPEAK = WS-BILLED-ONPEAK +                
I01959                               (WS-GEN-UNITS-ONPEAK* -1).         
I01959     IF WS-BILLED-ONPEAK  < 0                                     
I01959        MOVE ZEROES                    TO WS-BILLED-ONPEAK        
I01959     END-IF                                                       
I01959     COMPUTE WS-BILLED-OFFPEAK = WS-BILLED-OFFPEAK +              
I01959                               (WS-GEN-UNITS-OFFPEAK * -1).       
I01959     IF WS-BILLED-OFFPEAK < 0                                     
I01959        MOVE ZEROES                    TO WS-BILLED-OFFPEAK       
I01959     END-IF                                                       
I01959     COMPUTE WS-BILLED-SHLDR   = WS-BILLED-SHLDR +                
I01959                               (WS-GEN-UNITS-SHLDR * -1).         
I01959     IF WS-BILLED-SHLDR   < 0                                     
I01959        MOVE ZEROES                    TO WS-BILLED-SHLDR         
I01959     END-IF                                                       
I01959                                                                  
I01959     IF (WS-BILLED-ONPEAK NOT EQUAL ZEROES                        
I01959           OR WS-BILLED-OFFPEAK NOT EQUAL ZEROES                  
I01959                 OR WS-BILLED-SHLDR NOT EQUAL ZEROES)             
I01959                                   AND ACCOUNT-ON-TOU-RATE        
I01959        COMPUTE WS-TOT-BILL-UNITS = WS-BILLED-ONPEAK +            
I01959                                    WS-BILLED-OFFPEAK +           
I01959                                    WS-BILLED-SHLDR               
I01959     ELSE                                                         
I01959        MOVE WS-BILLED-NON-TOU         TO WS-TOT-BILL-UNITS       
I01959     END-IF.                                                      
I01959                                                                  
I01959 5510-EXIT.                                                       
I01959     EXIT.                                                        
I01959                                                                  
I01959*****************************************************************         
I01959*                                                               *         
I01959* 5520-SET-VOL-BILL-UNITS.                                      *         
I01959*****************************************************************         
I01959 5520-SET-VOL-BILL-UNITS.                                         
I01959                                                                  
I01959     INITIALIZE WS-BC-VOL-DAILY-ND                                
I01959     SET WS-BC-ND-INDX TO 1                                       
I01959     PERFORM VARYING SUB7 FROM 1 BY 1                             
I01959                   UNTIL SUB7 > WS-ND-MAX-ENTRY                   
I01959                         OR WS-ACCOUNT-NO-ND(SUB7) = +0           
I01959        IF WS-BILLING-KEY-ND(SUB7) =                              
I01959                    WS-BILLING-KEY (WS-BILLING-INDX)              
I01959           IF WS-VOL-TYPE-CD-ND(SUB7) EQUAL WS-BILLED             
I01959              EVALUATE WS-CODE-TIME-PERIOD-ND(SUB7)               
I01959                  WHEN WS-NON-TOU                                 
I01959                       MOVE WS-BILLED-NON-TOU  TO                 
I01959                                              WS-NO-UNITS-ND(SUB7)
I01959                  WHEN WS-ON-PEAK                                 
I01959                       MOVE WS-BILLED-ONPEAK TO                   
I01959                                              WS-NO-UNITS-ND(SUB7)
I01959                  WHEN WS-OFF-PEAK                                
I01959                       MOVE WS-BILLED-OFFPEAK TO                  
I01959                                              WS-NO-UNITS-ND(SUB7)
I01959                  WHEN WS-SHOULDER                                
I01959                       MOVE WS-BILLED-SHLDR TO                    
I01959                                              WS-NO-UNITS-ND(SUB7)
I01959              END-EVALUATE                                        
I01959           END-IF                                                 
I01959           PERFORM 5710-MOVE-ND-FIELDS THRU 5710-EXIT             
I01959           SET WS-BC-ND-INDX UP BY 1                              
I01959        END-IF                                                    
I01959     END-PERFORM.                                                 
I01959                                                                  
I01959 5520-EXIT.                                                       
I01959     EXIT.                                                        
I01959                                                                  
I01959*****************************************************************         
I01959*                                                               *         
I01959* 5530-CALC-BILL-WITHOUT-SLR.                                   *         
I01959*****************************************************************         
I01959 5530-CALC-BILL-WITHOUT-SLR.                                      
I01959                                                                  
I01959     MOVE ZEROES                       TO WS-DER-AMT-WITHOUT-SOLAR
I01959     PERFORM 2015-INITIALIZE-BG-WS        THRU 2015-EXIT.         
I01959     PERFORM 5500-SETUP-FOR-CALC          THRU 5500-EXIT.         
I01959     COMPUTE WS-DER-AMT-WITH-SOLAR =                              
I01959                WS-AMT-BILL-ITEM-BG (WS-BILLING-INDX)-            
I01959                WS-AMT-STATE-TAX-BG (WS-BILLING-INDX)-            
I01959                WS-AMT-CITY-TAX-BG (WS-BILLING-INDX).             
I01959     PERFORM 5800-CALL-BILL-CALC          THRU 5800-EXIT.         
I01959                                                                  
I01959     IF WS-CALC-ERROR NOT EQUAL SPACES                            
I01959        PERFORM 9200-SCSCA-ERROR          THRU 9200-EXIT          
I01959     ELSE                                                         
I01959        MOVE 'N'                       TO WS-DER-SAVINGS-EXIST    
I01959        IF WS-BC-AMT-BILL-ITEM-BG NOT EQUAL WS-DER-AMT-WITH-SOLAR 
I01959           MOVE 'Y'                    TO WS-DER-SAVINGS-EXIST    
I01959        END-IF                                                    
I01959        PERFORM 5920-COMPUTE-RECOVERY     THRU 5920-EXIT          
I01959     END-IF.                                                      
I01959                                                                  
I01959 5530-EXIT.                                                       
I01959     EXIT.                                                        
                                                                        
      ****************************************************************          
      *  MOVE DATA FROM THE CX TABLE TO COPYBOOK CWS0022B TO BE      *          
      *  PASSED TO SCSCA107.                                         *          
      ****************************************************************          
       5600-MOVE-CX-FIELDS.                                             
                                                                        
           MOVE WS-ACCOUNT-NO-CX (SUB7)                                 
                              TO WS-BC-ACCOUNT-NO-CX (CX-INDX).         
           MOVE WS-BILL-NO-CX (SUB7)                                    
                              TO WS-BC-BILL-NO-CX (CX-INDX).            
           MOVE WS-CODE-UTIL-TYPE-CX (SUB7)                             
                              TO WS-BC-CODE-UTIL-TYPE-CX (CX-INDX).     
           MOVE WS-IC-NO-CX (SUB7)                                      
                              TO WS-BC-IC-NO-CX (CX-INDX).              
           MOVE WS-BILL-ITEM-TIMESTMP-CX (SUB7)                         
                              TO WS-BC-BILL-ITEM-TIMESTMP-CX (CX-INDX). 
           MOVE WS-MTR-REF-NO-CX (SUB7)                                 
                              TO WS-BC-MTR-REF-NO-CX (CX-INDX).         
           MOVE WS-CODE-USAGE-TYPE-CX (SUB7)                            
                              TO WS-BC-CODE-USAGE-TYPE-CX (CX-INDX).    
           MOVE WS-CODE-USAGE-ID-CX (SUB7)                              
                              TO WS-BC-CODE-USAGE-ID-CX (CX-INDX).      
           MOVE WS-CODE-USAGE-SOURCE-CX (SUB7)                          
                              TO WS-BC-CODE-USAGE-SOURCE-CX (CX-INDX).  
           MOVE WS-CODE-TIME-PERIOD-CX (SUB7)                           
                              TO WS-BC-CODE-TIME-PERIOD-CX (CX-INDX).   
           MOVE WS-ITEM-SEQ-NO-CX (SUB7)                                
                              TO WS-BC-ITEM-SEQ-NO-CX (CX-INDX).        
           MOVE WS-METER-NO-CX (SUB7)                                   
                              TO WS-BC-METER-NO-CX (CX-INDX).           
           MOVE WS-REG-ID-NO-CX (SUB7)                                  
                              TO WS-BC-REG-ID-NO-CX (CX-INDX).          
           MOVE WS-DATE-READ-CX (SUB7)                                  
                              TO WS-BC-DATE-READ-CX (CX-INDX).          
           MOVE WS-CODE-METER-READ-CX (SUB7)                            
                              TO WS-BC-CODE-METER-READ-CX (CX-INDX).    
           MOVE WS-CODE-METER-NO-READ-CX (SUB7)                         
                              TO WS-BC-CODE-METER-NO-READ-CX (CX-INDX). 
           MOVE WS-METER-READING-CX (SUB7)                              
                              TO WS-BC-METER-READING-CX (CX-INDX).      
           MOVE WS-DEMAND-READING-CX (SUB7)                             
                              TO WS-BC-DEMAND-READING-CX (CX-INDX).     
           MOVE WS-EMPLOYEE-NO-CX (SUB7)                                
                              TO WS-BC-EMPLOYEE-NO-CX (CX-INDX).        
           MOVE WS-NO-UNITS-CX (SUB7)                                   
                              TO WS-BC-NO-UNITS-CX (CX-INDX).           
           MOVE WS-NO-DEMAND-UNITS-CX (SUB7)                            
                              TO WS-BC-NO-DEMAND-UNITS-CX (CX-INDX).    
           MOVE WS-NO-DAYS-CX (SUB7)                                    
                              TO WS-BC-NO-DAYS-CX (CX-INDX).            
           MOVE WS-CODE-SOURCE-ID-CX (SUB7)                             
                              TO WS-BC-CODE-SOURCE-ID-CX (CX-INDX).     
           MOVE WS-CODE-DEBIT-CREDIT-CX (SUB7)                          
                              TO WS-BC-CODE-DEBIT-CREDIT-CX (CX-INDX).  
           MOVE WS-CODE-ITEM-STATUS-CX (SUB7)                           
                              TO WS-BC-CODE-ITEM-STATUS-CX (CX-INDX).   
           MOVE WS-CODE-DISCOUNT-CX (SUB7)                              
                              TO WS-BC-CODE-DISCOUNT-CX (CX-INDX).      
           MOVE WS-CONSTANT-CX (SUB7)                                   
                              TO WS-BC-CONSTANT-CX (CX-INDX).           
           MOVE WS-NO-DIALS-CX (SUB7)                                   
                              TO WS-BC-NO-DIALS-CX (CX-INDX).           
           MOVE WS-COMPANY-NO-CX (SUB7)                                 
                              TO WS-BC-COMPANY-NO-CX (CX-INDX).         
           MOVE WS-EXCEPT-OVERRIDE-CD-CX (SUB7)                         
                              TO WS-BC-EXCEPT-OVERRIDE-CD-CX (CX-INDX). 
           MOVE WS-REQUESTED-USAGE-CX (SUB7)                            
                              TO WS-BC-REQUESTED-USAGE-CX (CX-INDX).    
           MOVE WS-DIGTL-INTRL-MTR-NO-CX (SUB7)                         
                              TO WS-BC-DIGTL-INTRL-MTR-NO-CX (CX-INDX). 
           MOVE WS-DIGTL-MTR-TYPE-CX (SUB7)                             
                              TO WS-BC-DIGTL-MTR-TYPE-CX (CX-INDX).     
           MOVE WS-CODE-TOU-SEASN-CX (SUB7)                             
                              TO WS-BC-CODE-TOU-SEASN-CX (CX-INDX).     
           MOVE WS-EXCL-DMD-RCHT-IND-CX (SUB7)                          
                              TO WS-BC-EXCL-DMD-RCHT-IND-CX (CX-INDX).  
           MOVE SPACES        TO WS-BC-UPDATE-ACTION-IND-CX (CX-INDX).  
                                                                        
       5600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ****************************************************************          
      *5700-MOVE-UC-FIELDS.                                          *          
      *LOAD UC FIELDS FOR BILL CALC CALL                             *          
      ****************************************************************          
       5700-MOVE-UC-FIELDS.                                             
                                                                        
           MOVE WS-ACCOUNT-NO-UC (SUB7)                                 
                              TO WS-BC-ACCOUNT-NO-UC (UC-INDX).         
           MOVE WS-BILL-NO-UC (SUB7)                                    
                              TO WS-BC-BILL-NO-UC (UC-INDX).            
           MOVE WS-CODE-UTIL-TYPE-UC (SUB7)                             
                              TO WS-BC-CODE-UTIL-TYPE-UC (UC-INDX).     
           MOVE WS-IC-NO-UC (SUB7)                                      
                              TO WS-BC-IC-NO-UC (UC-INDX).              
           MOVE WS-BILL-ITEM-TIMESTMP-UC (SUB7)                         
                              TO WS-BC-BILL-ITEM-TIMESTMP-UC (UC-INDX). 
           MOVE WS-RATE-ITEM-CODE-UC (SUB7)                             
                              TO WS-BC-RATE-ITEM-CODE-UC (UC-INDX).     
           MOVE WS-ITEM-SEQ-NO-UC (SUB7)                                
                              TO WS-BC-ITEM-SEQ-NO-UC (UC-INDX).        
           MOVE WS-NO-UNITS-UC (SUB7)                                   
                              TO WS-BC-NO-UNITS-UC (UC-INDX).           
           MOVE WS-NO-DAYS-UC (SUB7)                                    
                              TO WS-BC-NO-DAYS-UC (UC-INDX).            
           MOVE WS-CODE-DEBIT-CREDIT-UC (SUB7)                          
                              TO WS-BC-CODE-DEBIT-CREDIT-UC (UC-INDX).  
           MOVE WS-USAGE-FIXED-UC (SUB7)                                
                              TO WS-BC-USAGE-FIXED-UC (UC-INDX).        
           MOVE WS-DATE-USAGE-ENDS-UC (SUB7)                            
                              TO WS-BC-DATE-USAGE-ENDS-UC (UC-INDX).    
           MOVE WS-CODE-SERVICE-TYPE-UC (SUB7)                          
                              TO WS-BC-CODE-SERVICE-TYPE-UC (UC-INDX).  
           MOVE WS-CODE-ITEM-STATUS-UC (SUB7)                           
                              TO WS-BC-CODE-ITEM-STATUS-UC (UC-INDX).   
           MOVE WS-CODE-SOURCE-ID-UC (SUB7)                             
                              TO WS-BC-CODE-SOURCE-ID-UC (UC-INDX).     
           MOVE SPACES        TO WS-BC-UPDATE-ACTION-IND-UC (UC-INDX).  
           MOVE WS-DIST-NO-UC (SUB7)                                    
                              TO WS-BC-DIST-NO-UC (UC-INDX).            
           MOVE WS-LIGHT-NO-UC (SUB7)                                   
                              TO WS-BC-LIGHT-NO-UC (UC-INDX).           
           MOVE WS-POLE-NO-UC (SUB7)                                    
                              TO WS-BC-POLE-NO-UC (UC-INDX).            
           MOVE WS-MTHLY-AMOUNT-FIXED-UC (SUB7)                         
                              TO WS-BC-MTHLY-AMOUNT-FIXED-UC (UC-INDX). 
                                                                        
       5700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
I01959****************************************************************          
I01959*  MOVE DATA FROM THE ND TABLE TO COPYBOOK CWS0022B TO BE      *          
I01959*  PASSED TO SCSCA107.                                         *          
I01959****************************************************************          
I01959 5710-MOVE-ND-FIELDS.                                             
I01959                                                                  
I01959     MOVE WS-ACCOUNT-NO-ND (SUB7)                                 
I01959                        TO WS-BC-ACCOUNT-NO-ND (WS-BC-ND-INDX).   
I01959     MOVE WS-BILL-NO-ND (SUB7)                                    
I01959                        TO WS-BC-BILL-NO-ND (WS-BC-ND-INDX).      
I01959     MOVE WS-CODE-UTIL-TYPE-ND (SUB7)                             
I01959                        TO WS-BC-CODE-UTIL-TYPE-ND (WS-BC-ND-INDX)
I01959     MOVE WS-IC-NO-ND (SUB7)                                      
I01959                        TO WS-BC-IC-NO-ND (WS-BC-ND-INDX).        
I01959     MOVE WS-BILL-ITEM-TIMESTMP-ND (SUB7)                         
I01959                   TO WS-BC-BILL-ITEM-TIMESTMP-ND (WS-BC-ND-INDX).
I01959     MOVE WS-VOL-TYPE-CD-ND (SUB7)                                
I01959                        TO WS-BC-VOL-TYPE-CD-ND (WS-BC-ND-INDX).  
I01959     MOVE WS-ENERGY-UNIT-CD-ND (SUB7)                             
I01959                   TO WS-BC-ENERGY-UNIT-CD-ND (WS-BC-ND-INDX).    
I01959     MOVE WS-DATE-READ-ND (SUB7)                                  
I01959                        TO WS-BC-DATE-READ-ND (WS-BC-ND-INDX).    
I01959     MOVE WS-CODE-TIME-PERIOD-ND (SUB7)                           
I01959                   TO WS-BC-CODE-TIME-PERIOD-ND (WS-BC-ND-INDX).  
I01959     MOVE WS-NO-UNITS-ND (SUB7)                                   
I01959                        TO WS-BC-NO-UNITS-ND (WS-BC-ND-INDX).     
I01959     MOVE WS-FIXED-FCTR-SEQ-NO-ND (SUB7)                          
I01959                   TO WS-BC-FIXED-FCTR-SEQ-NO-ND (WS-BC-ND-INDX). 
I01959     MOVE WS-VOL-GROUP-SEQ-ND (SUB7)                              
I01959                        TO WS-BC-VOL-GROUP-SEQ-ND (WS-BC-ND-INDX).
I01959     MOVE WS-VOL-TYPE-DESC-ND (SUB7)                              
I01959                        TO WS-BC-VOL-TYPE-DESC-ND (WS-BC-ND-INDX).
I01959     MOVE WS-CMPNT-ID-CD-ND (SUB7)                                
I01959                        TO WS-BC-CMPNT-ID-CD-ND (WS-BC-ND-INDX).  
I01959     MOVE WS-BILL-PRINT-FL-ND (SUB7)                              
I01959                        TO WS-BC-BILL-PRINT-FL-ND (WS-BC-ND-INDX).
I01959                                                                  
I01959 5710-EXIT.                                                       
I01959     EXIT.                                                        
                                                                        
      ****************************************************************          
      *5750-MOVE-BP-FIELDS.                                          *          
      *LOAD BILL ADJUSTMENT FIELDS FOR BILL CALC CALL                *          
      ****************************************************************          
       5750-MOVE-BP-FIELDS.                                             
                                                                        
           MOVE WS-ACCOUNT-NO-BP(SUB7)                                  
             TO WS-BC-ACCOUNT-NO-BP(WS-BC-ADJUSTMNT-INDEX)              
           MOVE WS-BILL-NO-BP(SUB7)                                     
             TO WS-BC-BILL-NO-BP(WS-BC-ADJUSTMNT-INDEX)                 
           MOVE WS-CODE-UTIL-TYPE-BP(SUB7)                              
             TO WS-BC-CODE-UTIL-TYPE-BP(WS-BC-ADJUSTMNT-INDEX)          
           MOVE WS-IC-NO-BP(SUB7)                                       
             TO WS-BC-IC-NO-BP(WS-BC-ADJUSTMNT-INDEX)                   
           MOVE WS-BILL-ITEM-TIMESTMP-BP(SUB7)                          
             TO WS-BC-BILL-ITEM-TIMESTMP-BP(WS-BC-ADJUSTMNT-INDEX)      
           MOVE WS-ADJ-TYPE-CD-BP(SUB7)                                 
             TO WS-BC-ADJ-TYPE-CD-BP(WS-BC-ADJUSTMNT-INDEX)             
           MOVE WS-REVENUE-MONTH-BP(SUB7)                               
             TO WS-BC-REVENUE-MONTH-BP(WS-BC-ADJUSTMNT-INDEX)           
           MOVE WS-ADJ-REASON-DESC-LEN-BP(SUB7)                         
             TO WS-BC-ADJ-REASON-DESC-LEN-BP(WS-BC-ADJUSTMNT-INDEX)     
           MOVE WS-ADJ-REASON-DESC-TEXT-BP(SUB7)                        
             TO WS-BC-ADJ-REASON-DESC-TEXT-BP(WS-BC-ADJUSTMNT-INDEX)    
           MOVE WS-OVRRIDE-RT-REV-MTH-BP(SUB7)                          
             TO WS-BC-OVRRIDE-RT-REV-MTH-BP(WS-BC-ADJUSTMNT-INDEX)      
           MOVE WS-OVRRIDE-RT-BILL-DT-BP(SUB7)                          
             TO WS-BC-OVRRIDE-RT-BILL-DT-BP(WS-BC-ADJUSTMNT-INDEX)      
           MOVE WS-OVRRIDE-RT-BILL-CY-BP(SUB7)                          
             TO WS-BC-OVRRIDE-RT-BILL-CY-BP(WS-BC-ADJUSTMNT-INDEX).     
                                                                        
                                                                        
       5750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *5800-CALL-BILL-CALC.                                           *         
      *CALL SCSCA107 FOR BILL CALCULATION.                            *         
      *****************************************************************         
       5800-CALL-BILL-CALC.                                             
                                                                        
           CALL SCSCA107 USING   LS-PCSCA100-COMM-AREA,                 
                                 WS-BILLING-CALC-WORK,                  
                                 WS-BILLING-COMPONENT,                  
                                 WS-BILLING-ADJUSTMENT,                 
                                 WS-BILL-CALC-BG,                       
                                 WS-BILL-CALC-CX,                       
                                 WS-BILL-CALC-UC,                       
                                 WS-BILL-CALC-FH,                       
                                 WS-BILL-CONTRACT-BK,                   
                                 WS-FIXED-FCTR-TABLE-FF,                
                                 WS-BILL-CNTR-HIST-BX,                  
                                 WS-PEAK-HIST-PH,                       
                                 WS-INTERRUPT-ACCT-IP,                  
                                 WS-MTRD-ENVRNMT-TABLE-MN,              
                                 WS-STANDBY-GEN-SE,                     
                                 WS-INTERRUPT-IR,                       
                                 WS-HOLD-CX-DATA,                       
                                 WS-HOLD-BC-DATA,                       
                                 WS-HOLD-BA-DATA,                       
                                 WS-BILLING-WQ-ITEMS-WF,                
                                 WS-REFUND-RN,                          
                                 WS-ACCOUNT-AT,                         
                                 WS-BC-BILL-ADJUSTMNT,                  
                                 WS-BC-ACCT-RTPK-AGR-DF,                
                                 WS-BC-FIXED-FCTR-FF,                   
                                 WS-BC-BILL-DET-BT,                     
                                 WS-CWS22B-MAX-TBL-LIMITS,              
                                 WS-BILL-CALC-DETAIL-X,                 
                                 WS-BC-VOL-DAILY-ND,                    
P00496                           WS-BILL-BSLN-CNTR-LN,                  
P00496                           WS-BILL-BSLN-HIST-LO,                  
P00496                           WS-UTL-BILL-REL-TABLE-UR,              
VKSACT                           WS-INTERRUPT-NZ,                       
P00496                           WS-CNSMPTN-HOURLY .                    
                                                                        
           MOVE 'SCSCA107' TO WS-DISPLAY-SCSCA.                         
                                                                        
       5800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *5900-CALL-TAX-CALC.                                            *         
      *CALL SCSCA202 FOR TAX CALCULATION.                             *         
      *****************************************************************         
       5900-CALL-TAX-CALC.                                              
                                                                        
           INITIALIZE WS-CWS00202-OUT.                                  
           CALL SCSCA202 USING   WS-CWS00202,                           
                                 ABEND-FILE,                            
                                 RS-RETURN-CODE.                        
           MOVE 'SCSCA202' TO WS-DISPLAY-SCSCA.                         
                                                                        
       5900-EXIT.                                                       
           EXIT.                                                        
                                                                        
I01959*****************************************************************         
I01959*                                                               *         
I01959* 5910-CALC-DER-RECOVERY.                                       *         
I01959*****************************************************************         
I01959 5910-CALC-DER-RECOVERY.                                          
I01959                                                                  
I01959     MOVE 'N'                          TO WS-ESTIMATE-SOLAR-USAGE 
I01959     SET DER-KEYS                      TO 1                       
I01959     IF WS-REV-MTH-ORIG-BILL-BG(WS-BILLING-INDX) > ZEROES         
I01959        MOVE WS-REV-MTH-ORIG-BILL-BG(WS-BILLING-INDX)             
I01959                                       TO WS-HOLD-REVENUE-MONTH   
I01959     ELSE                                                         
I01959        MOVE WS-REVENUE-MONTH-BG(WS-BILLING-INDX)                 
I01959                                       TO WS-HOLD-REVENUE-MONTH   
I01959     END-IF                                                       
I01959     SEARCH WS-HOLD-DER-KEYS AT END                               
I01959            MOVE 'Y'            TO WS-ESTIMATE-SOLAR-USAGE        
I01959            MOVE ZEROES         TO WS-TOTAL-GEN-UNITS             
I01959                                   WS-GEN-UNITS-ONPEAK            
I01959                                   WS-GEN-UNITS-OFFPEAK           
I01959                                   WS-GEN-UNITS-SHLDR             
I01959       WHEN WS-DER-REVENUE-MTH(DER-KEYS) IS NOT NUMERIC           
I01959            MOVE 'Y'            TO WS-ESTIMATE-SOLAR-USAGE        
I01959            MOVE ZEROES         TO WS-TOTAL-GEN-UNITS             
I01959                                   WS-GEN-UNITS-ONPEAK            
I01959                                   WS-GEN-UNITS-OFFPEAK           
I01959                                   WS-GEN-UNITS-SHLDR             
I01959       WHEN WS-DER-REVENUE-MTH(DER-KEYS) = WS-HOLD-REVENUE-MONTH  
I01959            MOVE WS-DER-GEN-NONTOU(DER-KEYS)                      
I01959                                TO WS-TOTAL-GEN-UNITS             
I01959            MOVE WS-DER-GEN-ONPEAK(DER-KEYS)                      
I01959                                TO WS-GEN-UNITS-ONPEAK            
I01959            MOVE WS-DER-GEN-OFFPEAK(DER-KEYS)                     
I01959                                TO WS-GEN-UNITS-OFFPEAK           
I01959            MOVE WS-DER-GEN-SHLDR(DER-KEYS)                       
I01959                                TO WS-GEN-UNITS-SHLDR             
I01959     END-SEARCH.                                                  
I01959                                                                  
I01959     IF ESTIMATE-SOLAR-USAGE                                      
I01959        MOVE ZEROES                    TO 6B-INVERTER-SYST-SIZE   
I01959        PERFORM 7530-GET-SOLAR-SYSTEM-SIZE  THRU 7530-EXIT        
I01959        PERFORM 5930-EST-SOLAR-USAGE        THRU 5930-EXIT        
I01959     END-IF                                                       
I01959                                                                  
I01959     PERFORM 5510-CALC-VOL-BILL-UNITS  THRU 5510-EXIT.            
I01959                                                                  
I01959     IF WS-DELIVERED-UNITS GREATER THAN ZEROES                    
I01959        IF WS-EXCESS-PRIOR-UNITS LESS THAN ZEROES                 
I01959               OR WS-TOTAL-GEN-UNITS LESS THAN ZEROES             
I01959            PERFORM 5530-CALC-BILL-WITHOUT-SLR                    
I01959                                             THRU 5530-EXIT       
I01959        END-IF                                                    
I01959     END-IF.                                                      
I01959                                                                  
I01959 5910-EXIT.                                                       
I01959     EXIT.                                                        
I01959                                                                  
I01959*****************************************************************         
I01959*                                                               *         
I01959* 5920-COMPUTE-RECOVERY.                                        *         
I01959*****************************************************************         
I01959 5920-COMPUTE-RECOVERY.                                           
I01959                                                                  
I01959     MOVE WS-BC-AMT-BILL-ITEM-BG     TO WS-DER-AMT-WITHOUT-SOLAR  
I01959                                                                  
I01959                                                                  
I01959     COMPUTE WS-AVOIDED-COST ROUNDED                              
I01959                             = WS-TOTAL-GEN-UNITS * WS-SHORT-VOS  
I01959     COMPUTE WS-CCR-FCTR ROUNDED                                  
I01959                         = WS-LONG-VOS - WS-SHORT-VOS.            
I01959     COMPUTE WS-CAPACITY-COST-RCVRY ROUNDED                       
I01959                         = WS-CCR-FCTR * WS-TOTAL-GEN-UNITS.      
I01959     COMPUTE WS-INCREMENTAL-COST ROUNDED                          
I01959                             = WS-DER-AMT-WITHOUT-SOLAR -         
I01959                               WS-DER-AMT-WITH-SOLAR -            
I01959                               (WS-CAPACITY-COST-RCVRY * -1) -    
I01959                               (WS-AVOIDED-COST * -1).            
I01959                                                                  
I01959     IF WS-INCREMENTAL-COST LESS THAN ZEROES                      
I01959            AND ( WS-NEM-RATE-DEP-CD EQUAL WS-RESIDENTIAL-NM      
I01959                   OR WS-NEM-RATE-DEP-CD EQUAL WS-SMALL-GENSV-NM )
I01959        MOVE ZEROES                    TO WS-INCREMENTAL-COST     
I01959                                          WS-CAPACITY-COST-RCVRY  
I01959     ELSE                                                         
I01959        MULTIPLY -1 BY WS-INCREMENTAL-COST                        
I01959     END-IF                                                       
I01959                                                                  
I01959     IF WS-AVOIDED-COST NOT EQUAL ZEROES                          
I01959        INITIALIZE FCSCREVC                                       
I01959        MOVE WS-AVOIDED-COST           TO WS-TOTAL-BILL-ITEM-AMT  
I01959        MOVE WS-AVOIDED-COST-FCTR      TO WS-DER-FACTOR-ID        
I01959        PERFORM 2760-GENERATE-RECOVERY-FACTOR                     
I01959                                          THRU 2760-EXIT          
I01959     END-IF.                                                      
I01959                                                                  
I01959     IF WS-INCREMENTAL-COST NOT EQUAL ZEROES                      
I01959                                AND WS-DER-SAVINGS-EXIST = 'Y'    
I01959        INITIALIZE FCSCREVC                                       
I01959        MOVE WS-INCREMENTAL-COST       TO WS-TOTAL-BILL-ITEM-AMT  
I01959        MOVE WS-INCREMENTAL-COST-FCTR  TO WS-DER-FACTOR-ID        
I01959        PERFORM 2760-GENERATE-RECOVERY-FACTOR                     
I01959                                          THRU 2760-EXIT          
I01959     END-IF.                                                      
I01959                                                                  
I01959     IF WS-CAPACITY-COST-RCVRY NOT EQUAL ZEROES                   
I01959                                AND WS-DER-SAVINGS-EXIST = 'Y'    
I01959        INITIALIZE FCSCREVC                                       
I01959        MOVE WS-CAPACITY-COST-RCVRY    TO WS-TOTAL-BILL-ITEM-AMT  
I01959        MOVE WS-COST-RECOVERY-FCTR     TO WS-DER-FACTOR-ID        
I01959        PERFORM 2760-GENERATE-RECOVERY-FACTOR                     
I01959                                          THRU 2760-EXIT          
I01959     END-IF.                                                      
I01959                                                                  
I01959*    Subtract Net metering excess credit from bill w/o solar              
I01959     PERFORM VARYING BC-INDX FROM 1 BY 1                          
I01959             UNTIL BC-INDX > WS-BC-MAX-ENTRY                      
I01959                OR WS-BC-COMPONENT-ID (BC-INDX) = SPACE           
I01959       PERFORM VARYING BA-INDX FROM 1 BY 1                        
I01959               UNTIL BA-INDX > 200                                
I01959               OR WS-BC-FACTOR-ID (BA-INDX) NOT > SPACE           
I01959           IF WS-BC-FACTOR-COMPONENT (BA-INDX) =                  
I01959                 WS-BC-COMPONENT-KEY (BC-INDX)                    
I01959            IF WS-BC-FACTOR-ID (BA-INDX) = WS-NM-EXCESS-FCTR      
I01959              AND WS-BC-AMT-ADJUSTMENT (BA-INDX) NOT EQUAL ZEROES 
I01959                COMPUTE WS-DER-AMT-WITHOUT-SOLAR =                
I01959                           WS-DER-AMT-WITHOUT-SOLAR +             
I01959                                   WS-BC-AMT-ADJUSTMENT (BA-INDX) 
I01959            END-IF                                                
I01959           END-IF                                                 
I01959       END-PERFORM                                                
I01959     END-PERFORM                                                  
I01959                                                                  
I01959     INITIALIZE FCSCREVC.                                         
I01959     MOVE WS-DER-AMT-WITHOUT-SOLAR TO WS-TOTAL-BILL-ITEM-AMT.     
I01959     MOVE WS-DER-CALC-PBI-FCTR     TO WS-DER-FACTOR-ID.           
I01959     PERFORM 2760-GENERATE-RECOVERY-FACTOR THRU 2760-EXIT.        
I01959                                                                  
I01959 5920-EXIT.                                                       
I01959     EXIT.                                                        
I01959                                                                  
I01959*****************************************************************         
I01959*                                                               *         
I01959* 5930-EST-SOLAR-USAGE.                                         *         
I01959*****************************************************************         
I01959 5930-EST-SOLAR-USAGE.                                            
I01959                                                                  
I01959     IF WS-REV-MTH-ORIG-BILL-BG(WS-BILLING-INDX) > ZEROES         
I01959        MOVE WS-REV-MTH-ORIG-BILL-BG(WS-BILLING-INDX)             
I01959                                       TO WS-CURR-REV-MONTH       
I01959        MOVE WS-DATE-ORIG-BILL-BG(WS-BILLING-INDX)                
I01959                                       TO WS-DATE-BILLED          
I01959     ELSE                                                         
I01959        MOVE  WS-REVENUE-MONTH-BG(WS-BILLING-INDX)                
I01959                                       TO WS-CURR-REV-MONTH       
I01959        MOVE WS-DATE-BILLED-BI                                    
I01959                                       TO WS-DATE-BILLED          
I01959     END-IF.                                                      
I01959                                                                  
I01959     SET WS-CF-INDX TO 1.                                         
I01959     SEARCH WS-CAPACITY-FCTR-DATA AT END                          
I01959            MOVE ZEROES         TO WS-TOTAL-GEN-UNITS             
I01959       WHEN WS-CURR-REV-MONTH-MM =                                
I01959                                WS-CAP-FCTR-MONTH-ARR(WS-CF-INDX) 
I01959              AND WS-DATE-BILLED >=                               
I01959                             WS-CAP-FCTR-START-DT-ARR(WS-CF-INDX) 
I01959            MOVE WS-CAPACITY-FACTOR-ARR(WS-CF-INDX)               
I01959                                TO WS-CURR-CAPACITY-FACTOR        
I01959            MOVE WS-ON-PEAK-ALLOC-ARR(WS-CF-INDX)                 
I01959                                TO WS-CURR-ON-PEAK-ALLOC          
I01959            MOVE WS-OFF-PEAK-ALLOC-ARR(WS-CF-INDX)                
I01959                                TO WS-CURR-OFF-PEAK-ALLOC         
I01959     END-SEARCH.                                                  
I01959                                                                  
I01959     COMPUTE WS-TOTAL-GEN-UNITS ROUNDED =                         
I01959                     ( 6B-INVERTER-SYST-SIZE * 24 *               
I01959                       WS-NO-OF-CONS-DAYS-BG (WS-BILLING-INDX) *  
I01959                       WS-CURR-CAPACITY-FACTOR ) * -1             
I01959                                                                  
I01959     COMPUTE WS-GEN-UNITS-ONPEAK ROUNDED =                        
I01959                                WS-TOTAL-GEN-UNITS *              
I01959                                WS-CURR-ON-PEAK-ALLOC.            
I01959     COMPUTE WS-GEN-UNITS-OFFPEAK ROUNDED =                       
I01959                                WS-TOTAL-GEN-UNITS *              
I01959                                WS-CURR-OFF-PEAK-ALLOC.           
I01959                                                                  
I01959 5930-EXIT.                                                       
I01959     EXIT.                                                        
I01959                                                                  
NONCAL******************************************************************        
NONCAL* 6000-CPD107B-MAIN-PROCESS.                                     *        
NONCAL* COPYBOOK TO LOAD BILLING DETAILS FROM MANUAL BILL TABLES       *00165700
NONCAL******************************************************************        
NONCAL     EXEC SQL                                                             
NONCAL          INCLUDE CPDCB107                                                
NONCAL     END-EXEC.                                                            
NONCAL*                                                                         
      ******************************************************************        
      * 6251-GET-FJC01-DATE                                            *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD00037                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6240-GET-FCA00-COMMON-DATE                                     *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD00040                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7620-START-FCSCA00                                             *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD00039                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7000-SELECT-DELINQ-VALUE                                       *        
      * SELECTS THE DELINQUENCY VALUE FOR THE GIVEN DELINQ CODE        *        
      ******************************************************************        
       7000-SELECT-DELINQ-VALUE.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY                                    
               WHERE DELINQ_CD  = :C8-DELINQ-CD                         
                 AND COMPANY_NO = :C8-COMPANY-NO                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA177 ABORT **************'        
              DISPLAY '* 7000-SELECT-DELINQ-VALUE             *'        
              DISPLAY '* DELINQ CD ', C8-DELINQ-CD                      
              DISPLAY '* COMPANY NO', C8-COMPANY-NO                     
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA177 ABORT **************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7050-GET-CURR-TIMESTAMP                                        *        
      * GETS CURRENT TIMESTAMP                                         *        
      ******************************************************************        
       7050-GET-CURR-TIMESTAMP.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA177 ABORT **************'        
              DISPLAY '* 7050-SELCT-CURRENT-TIMESTAMP         *'        
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA177 ABORT **************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-OPEN-RATE-PL-DESC-CSR                                     *        
      * OPENS RATE PLAN DESC CURSOR                                    *        
      ******************************************************************        
       7100-OPEN-RATE-PL-DESC-CSR.                                      
                                                                        
           EXEC SQL                                                     
              OPEN RATE_PL_DESC_CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              DISPLAY '* 7100-OPEN-RATE-PL-DESC-CSR          *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7110-FETCH-RATE-PL-DESC-CSR                                    *        
      * FETCH RATE PLAN DESC CURSOR                                    *        
      ******************************************************************        
       7110-FETCH-RATE-PL-DESC-CSR.                                     

MSQ008     MOVE 100 TO MSQ008-RATE-PL-DESC-CSR
                                                                        
           EXEC SQL                                                     
              FOR :MSQ008-RATE-PL-DESC-CSR
              FETCH 
              FROM RATE_PL_DESC_CSR                   
                                                            
               INTO  :WS-RD-RATE-PLAN-NO                                
                    ,:WS-RD-CODE-UTIL-TYPE                              
                    ,:WS-RD-RATE-CALC-TYPE-CD                           
                    ,:WS-RD-RATE-DEPT-CODE                              
                    ,:WS-RD-COMPANY-NO                                  
                    ,:WS-RD-UNMTR-PROV-FL                               
PRJ257              ,:WS-RD-REV-CUST-COUNT-CD                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH NEXT ROWSET FROM RATE_PL_DESC_CSR                           
MFA-TR*         FOR 100 ROWS                                                    
MFA-TR*        INTO  :WS-RD-RATE-PLAN-NO                                        
MFA-TR*             ,:WS-RD-CODE-UTIL-TYPE                                      
MFA-TR*             ,:WS-RD-RATE-CALC-TYPE-CD                                   
MFA-TR*             ,:WS-RD-RATE-DEPT-CODE                                      
MFA-TR*             ,:WS-RD-COMPANY-NO                                          
MFA-TR*             ,:WS-RD-UNMTR-PROV-FL                                       
MFA-TR*             ,:WS-RD-REV-CUST-COUNT-CD                                   
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-RATE-PL-DESC-CSR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF SQLERRD (3) > 0                                        
                 MOVE SQLERRD (3)         TO WS-ORDER-ROW-COUNT         
              ELSE                                                      
                 MOVE 0                   TO WS-ORDER-ROW-COUNT         
              END-IF                                                    
              ADD WS-ORDER-ROW-COUNT      TO WS-RD-COUNT                
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = +354                           
                                                                        
                 EXEC SQL                                               
MSQ012              GET DIAGNOSTICS :MFA-GD-ROW-COUNT = ROW_COUNT     
MSQ012                              ,:MFA-GD-NUMBER        = NUMBER       
                 END-EXEC                                               

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*          EXEC SQL                                                       
MFA-TR*             GET DIAGNOSTICS :WS-ORDER-ROW-COUNT = ROW_COUNT             
MFA-TR*                             ,:WS-NUM-COND        = NUMBER               
MFA-TR*          END-EXEC                                                       
MSQ012           MOVE MFA-GD-ROW-COUNT TO WS-ORDER-ROW-COUNT
MSQ012           MOVE MFA-GD-NUMBER TO WS-NUM-COND
                                                                        
                 DISPLAY '********** PCSCA177 ABORT  ************'      
                 DISPLAY '* 7110-FETCH-RATE-PL-DESC-CSR         *'      
                 DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
                 DISPLAY '* ROWCOUNT ' SQLERRD(3)                       
                 DISPLAY '* NUM_COND '  WS-NUM-COND                     
                 DISPLAY '* PROGRAM ABORTING...                 *'      
                 DISPLAY '********** PCSCA177 ABORT  ************'      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              ELSE                                                      
                 DISPLAY '********** PCSCA177 ABORT  ************'      
                 DISPLAY '* 7110-FETCH-RATE-PL-DESC-CSR         *'      
                 DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
                 DISPLAY '* PROGRAM ABORTING...                 *'      
                 DISPLAY '********** PCSCA177 ABORT  ************'      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7120-CLOSE-RATE-PL-DESC-CSR.                                   *        
      * CLOSE RATE PLAN DESC CURSOR                                    *        
      ******************************************************************        
       7120-CLOSE-RATE-PL-DESC-CSR.                                     
                                                                        
           EXEC SQL                                                     
              CLOSE RATE_PL_DESC_CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              DISPLAY '* 7120-CLOSE-RATE-PL-DESC-CSR         *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7130-OPEN-RATE-COMP-CSR                                        *        
      * OPENS RATE COMPONENT CURSOR                                    *        
      ******************************************************************        
       7130-OPEN-RATE-COMP-CSR.                                         
                                                                        
           EXEC SQL                                                     
                OPEN RATE_COMP_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              DISPLAY '* 7130-OPEN-RATE-COMP-CSR             *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7140-FETCH-RATE-COMP-CSR                                       *        
      * FETCH RATE COMPOENENT CURSOR                                   *        
      ******************************************************************        
       7140-FETCH-RATE-COMP-CSR.                                        

MSQ008     MOVE 50 TO MSQ008-RATE-COMP-CSR
                                                                        
           EXEC SQL                                                     
                FOR :MSQ008-RATE-COMP-CSR
              FETCH 
              FROM RATE_COMP_CSR                    
                                                             
                 INTO :WS-N6-RATE-CMPNT-ID                              
                     ,:WS-N6-REVENUE-CNSMPTN-FL                         
                     ,:WS-N6-REVENUE-AMOUNT-FL                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*         FETCH NEXT ROWSET FROM RATE_COMP_CSR                            
MFA-TR*           FOR 50 ROWS                                                   
MFA-TR*          INTO :WS-N6-RATE-CMPNT-ID                                      
MFA-TR*              ,:WS-N6-REVENUE-CNSMPTN-FL                                 
MFA-TR*              ,:WS-N6-REVENUE-AMOUNT-FL                                  
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-RATE-COMP-CSR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF SQLERRD (3) > 0                                        
                 MOVE SQLERRD (3)         TO WS-ORDER-ROW-COUNT         
              ELSE                                                      
                 MOVE 0                   TO WS-ORDER-ROW-COUNT         
              END-IF                                                    
              ADD WS-ORDER-ROW-COUNT      TO WS-N6-COUNT                
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = +354                           
                 EXEC SQL                                               
MSQ012              GET DIAGNOSTICS :MFA-GD-ROW-COUNT = ROW_COUNT     
MSQ012                              ,:MFA-GD-NUMBER        = NUMBER       
                 END-EXEC                                               

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*          EXEC SQL                                                       
MFA-TR*             GET DIAGNOSTICS :WS-ORDER-ROW-COUNT = ROW_COUNT             
MFA-TR*                             ,:WS-NUM-COND        = NUMBER               
MFA-TR*          END-EXEC                                                       
MSQ012           MOVE MFA-GD-ROW-COUNT TO WS-ORDER-ROW-COUNT
MSQ012           MOVE MFA-GD-NUMBER TO WS-NUM-COND
                 DISPLAY '********** PCSCA177 ABORT  ************'      
                 DISPLAY '* 7140-FETCH-RATE-COMP-CSR            *'      
                 DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
                 DISPLAY '* ROWCOUNT ' SQLERRD(3)                       
                 DISPLAY '* NUM_COND '  WS-NUM-COND                     
                 DISPLAY '* PROGRAM ABORTING...                 *'      
                 DISPLAY '********** PCSCA177 ABORT  ************'      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              ELSE                                                      
                 DISPLAY '********** PCSCA177 ABORT  ************'      
                 DISPLAY '* 7140-FETCH-RATE-COMP-CSR            *'      
                 DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
                 DISPLAY '* PROGRAM ABORTING...                 *'      
                 DISPLAY '********** PCSCA177 ABORT  ************'      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7150-CLOSE-RATE-COMP-CSR.                                      *        
      * CLOSE RATE COMPONENT CURSOR                                    *        
      ******************************************************************        
       7150-CLOSE-RATE-COMP-CSR.                                        
                                                                        
           EXEC SQL                                                     
              CLOSE RATE_COMP_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              DISPLAY '* 7150-CLOSE-RATE-COMP-CSR            *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7160-OPEN-SPCL-FCTR-CSR                                        *        
      * OPENS SPCL_FCTR CURSOR                                         *        
      ******************************************************************        
       7160-OPEN-SPCL-FCTR-CSR.                                         
                                                                        
           EXEC SQL                                                     
              OPEN SPCL_FCTR_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              DISPLAY '* 7160-OPEN-SPCL-FCTR-CSR             *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7170-FETCH-SPCL-FCTR-CSR                                       *        
      * FETCH SPCL FCTR CURSOR                                         *        
      ******************************************************************        
       7170-FETCH-SPCL-FCTR-CSR.                                        

MSQ008     MOVE 100 TO MSQ008-SPCL-FCTR-CSR
                                                                        
           EXEC SQL                                                     
              FOR :MSQ008-SPCL-FCTR-CSR
              FETCH 
              FROM SPCL_FCTR_CSR                      
                                                            
               INTO  :WS-SF-FACTOR-ID                                   
                    ,:WS-SF-PRORATE-FL                                  
                    ,:WS-SF-REV-INTERFACE-FL                            
                    ,:WS-SF-SPCL-GROUP-CD                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH NEXT ROWSET FROM SPCL_FCTR_CSR                              
MFA-TR*         FOR 100 ROWS                                                    
MFA-TR*        INTO  :WS-SF-FACTOR-ID                                           
MFA-TR*             ,:WS-SF-PRORATE-FL                                          
MFA-TR*             ,:WS-SF-REV-INTERFACE-FL                                    
MFA-TR*             ,:WS-SF-SPCL-GROUP-CD                                       
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-SPCL-FCTR-CSR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF SQLERRD (3) > 0                                        
                 MOVE SQLERRD (3)         TO WS-ORDER-ROW-COUNT         
              ELSE                                                      
                 MOVE 0                   TO WS-ORDER-ROW-COUNT         
              END-IF                                                    
              ADD WS-ORDER-ROW-COUNT      TO WS-SF-COUNT                
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = +354                           
                                                                        
                 EXEC SQL                                               
MSQ012              GET DIAGNOSTICS :MFA-GD-ROW-COUNT = ROW_COUNT     
MSQ012                              ,:MFA-GD-NUMBER        = NUMBER       
                 END-EXEC                                               

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*          EXEC SQL                                                       
MFA-TR*             GET DIAGNOSTICS :WS-ORDER-ROW-COUNT = ROW_COUNT             
MFA-TR*                             ,:WS-NUM-COND        = NUMBER               
MFA-TR*          END-EXEC                                                       
MSQ012           MOVE MFA-GD-ROW-COUNT TO WS-ORDER-ROW-COUNT
MSQ012           MOVE MFA-GD-NUMBER TO WS-NUM-COND
                                                                        
                 DISPLAY '********** PCSCA177 ABORT  ************'      
                 DISPLAY '* 7170-FETCH-SPCL-FCTR-CSR            *'      
                 DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
                 DISPLAY '* ROWCOUNT ' SQLERRD(3)                       
                 DISPLAY '* NUM_COND '  WS-NUM-COND                     
                 DISPLAY '* PROGRAM ABORTING...                 *'      
                 DISPLAY '********** PCSCA177 ABORT  ************'      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              ELSE                                                      
                 DISPLAY '********** PCSCA177 ABORT  ************'      
                 DISPLAY '* 7170-FETCH-SPCL-FCTR-CSR            *'      
                 DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
                 DISPLAY '* PROGRAM ABORTING...                 *'      
                 DISPLAY '********** PCSCA177 ABORT  ************'      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7170-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7180-CLOSE-SPCL-FCTR-CSR                                       *        
      * CLOSE SPCL FCTR CURSOR                                         *        
      ******************************************************************        
       7180-CLOSE-SPCL-FCTR-CSR.                                        
                                                                        
           EXEC SQL                                                     
              CLOSE SPCL_FCTR_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              DISPLAY '* 7180-CLOSE-SPCL-FCTR-CSR            *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7180-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-PRTY-SERV-CATEGORY-CD                                     *        
      * GET PRIORITY-SERVICE-CATEGORY-CD                               *        
      ******************************************************************        
       7200-PRTY-SERV-CATEGORY-CD.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT PRTY_SVC_CAT_CD                                    
                INTO :Z4-PRTY-SVC-CAT-CD                                
                FROM CSS_PRTY_SVC_CAT WITH(READUNCOMMITTED)                     
               WHERE CODE_CURTAIL_PRTY = :Z4-CODE-CURTAIL-PRTY          
                 AND COMPANY_NO        = :Z4-COMPANY-NO                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PRTY_SVC_CAT_CD                                            
MFA-TR*         INTO :Z4-PRTY-SVC-CAT-CD                                        
MFA-TR*         FROM CSS_PRTY_SVC_CAT                                           
MFA-TR*        WHERE CODE_CURTAIL_PRTY = :Z4-CODE-CURTAIL-PRTY                  
MFA-TR*          AND COMPANY_NO        = :Z4-COMPANY-NO                         
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA177  ABORT **************'       
              DISPLAY '* 7200-PRTY-SERV-CATEGORY-CD            *'       
              DISPLAY '* CODE_CURTAIL_PRTY = ' Z4-CODE-CURTAIL-PRTY     
              DISPLAY '* SQLCODE IS        : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '* PROGRAM ABORTING...                   *'       
              DISPLAY '********** PCSCA177  ABORT **************'       
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7210-GET-MNICIPLTY-COUNTY-CD.                                  *        
      * GET MUNICIPALITY COUNTY CODE                                   *        
      ******************************************************************        
       7210-GET-MNICIPLTY-COUNTY-CD.                                    
      *                                                                         
           EXEC SQL                                                     
              SELECT MNICPLTY_COUNTY_CD                                 
                INTO :F4-MNICPLTY-COUNTY-CD                             
                FROM CSS_MNICPLTY_CNTY WITH(READUNCOMMITTED)                    
               WHERE REV_DISTRICT_CD   = :F4-REV-DISTRICT-CD            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MNICPLTY_COUNTY_CD                                         
MFA-TR*         INTO :F4-MNICPLTY-COUNTY-CD                                     
MFA-TR*         FROM CSS_MNICPLTY_CNTY                                          
MFA-TR*        WHERE REV_DISTRICT_CD   = :F4-REV-DISTRICT-CD                    
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7210                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA177  ABORT **************'       
              DISPLAY '* 7210-GET-MNICIPLTY-COUNTY-CD          *'       
              DISPLAY '* REV_DISTRICT_CD   = ' F4-REV-DISTRICT-CD       
              DISPLAY '* SQLCODE IS        : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '* PROGRAM ABORTING...                   *'       
              DISPLAY '********** PCSCA177  ABORT **************'       
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7220-CHECK-ACCT-ALREADY-BILLED.                                *        
      * TO CHECK WHETHER THE ACCOUNT IS ALREADY BILLED  FOR THE CURRENT*        
      * MONTH                                                          *        
      ******************************************************************        
       7220-CHECK-ACCT-ALREADY-BILLED.                                  
      *                                                                         
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
ACT011             , BG.RATE_PLAN_NO                                    
                INTO :WS-ACCOUNT-BILLED-COUNT                           
ACT011             , :WS-RATE-PLAN-NO-PREV-BILL                         
                FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                   
                    ,CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                   
               WHERE BI.ACCOUNT_NO         = :BI-ACCOUNT-NO             
                 AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO              
                 AND BI.BILL_NO            = BG.BILL_NO                 
                 AND BI.DATE_BILLED        IS NOT NULL                  
                 AND BI.CODE_BILL_TYPE     <> 'B'                       
                 AND BG.DATE_ORIG_BILL     IS NULL                      
                 AND BG.REVENUE_MONTH      = :BG-REVENUE-MONTH          
                 AND BG.REV_MTH_ORIG_BILL  = 0                          
                 AND BG.CODE_BILL_CALC     = 'A'                        
                 AND BG.CODE_BILL_ITM_TYPE = 'C'                        
                 AND BG.CODE_BILL_ITM_IND  = 'A'                        
ACT044           AND BG.RATE_PLAN_NO       = :BG-RATE-PLAN-NO           
ACT011           AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE         
ACT011           AND BG.IC_NO              = :BG-IC-NO                  
ACT011           GROUP BY BG.RATE_PLAN_NO                               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*            , BG.RATE_PLAN_NO                                            
MFA-TR*         INTO :WS-ACCOUNT-BILLED-COUNT                                   
MFA-TR*            , :WS-RATE-PLAN-NO-PREV-BILL                                 
MFA-TR*         FROM CSS_BILLING_DET BG                                         
MFA-TR*             ,CSS_BILLING_HDR BI                                         
MFA-TR*        WHERE BI.ACCOUNT_NO         = :BI-ACCOUNT-NO                     
MFA-TR*          AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO                      
MFA-TR*          AND BI.BILL_NO            = BG.BILL_NO                         
MFA-TR*          AND BI.DATE_BILLED        IS NOT NULL                          
MFA-TR*          AND BI.CODE_BILL_TYPE     <> 'B'                               
MFA-TR*          AND BG.DATE_ORIG_BILL     IS NULL                              
MFA-TR*          AND BG.REVENUE_MONTH      = :BG-REVENUE-MONTH                  
MFA-TR*          AND BG.REV_MTH_ORIG_BILL  = 0                                  
MFA-TR*          AND BG.CODE_BILL_CALC     = 'A'                                
MFA-TR*          AND BG.CODE_BILL_ITM_TYPE = 'C'                                
MFA-TR*          AND BG.CODE_BILL_ITM_IND  = 'A'                                
MFA-TR*          AND BG.RATE_PLAN_NO       = :BG-RATE-PLAN-NO                   
MFA-TR*          AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                 
MFA-TR*          AND BG.IC_NO              = :BG-IC-NO                          
MFA-TR*          GROUP BY BG.RATE_PLAN_NO                                       
MFA-TR*          WITH UR                                                        
MFA-TR*      QUERYNO 7220                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA177  ABORT **************'       
              DISPLAY '* 7220-CHECK-ACCT-ALREADY-BILLED        *'       
              DISPLAY '* ACCOUNT_NO        = ' BI-ACCOUNT-NO            
              DISPLAY '* REVENUE_MONTH     = ' BG-REVENUE-MONTH         
              DISPLAY '* SQLCODE IS        : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '* PROGRAM ABORTING...                   *'       
              DISPLAY '********** PCSCA177  ABORT **************'       
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *7230-GET-GL-ACCOUNT-NUMBER.                                     *        
      * GET THE GL ACCOUNT NUMBER FOR A REVENUE CLASS                  *        
      ******************************************************************        
       7230-GET-GL-ACCOUNT-NUMBER.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT GL_ACCT_NO                                         
                INTO :Q8-GL-ACCT-NO                                     
                FROM CSS_REV_CLS_RATE WITH(READUNCOMMITTED)                     
               WHERE RATE_PLAN_NO       = :Q8-RATE-PLAN-NO              
                 AND CODE_REVENUE_CLASS = :Q8-CODE-REVENUE-CLASS        
                 AND CODE_UTIL_TYPE     = :Q8-CODE-UTIL-TYPE            
                 AND COMPANY_NO         = :Q8-COMPANY-NO                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT GL_ACCT_NO                                                 
MFA-TR*         INTO :Q8-GL-ACCT-NO                                             
MFA-TR*         FROM CSS_REV_CLS_RATE                                           
MFA-TR*        WHERE RATE_PLAN_NO       = :Q8-RATE-PLAN-NO                      
MFA-TR*          AND CODE_REVENUE_CLASS = :Q8-CODE-REVENUE-CLASS                
MFA-TR*          AND CODE_UTIL_TYPE     = :Q8-CODE-UTIL-TYPE                    
MFA-TR*          AND COMPANY_NO         = :Q8-COMPANY-NO                        
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7230                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE Q8-GL-ACCT-NO     TO WS-REVADJ-GL-ACCT-NO         
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSCA177  ABORT **************'       
              DISPLAY '* 7230-GET-GL-ACCOUNT-NUMBER            *'       
              DISPLAY '* RATE_PLAN_NO       = ' Q8-RATE-PLAN-NO         
              DISPLAY '* CODE_REVENUE_CLASS = ' Q8-CODE-REVENUE-CLASS   
              DISPLAY '* CODE_UTIL_TYPE     = ' Q8-CODE-UTIL-TYPE       
              DISPLAY '* COMPANY_NO         = ' Q8-COMPANY-NO           
              DISPLAY '* SQLCODE IS        : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '* PROGRAM ABORTING...                   *'       
              DISPLAY '********** PCSCA177  ABORT **************'       
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *7250-GET-TAX-CONTROL-NUMBER                                     *        
      *SELECTS THE TAX CONTROL NUMBER                                  *        
      ******************************************************************        
       7250-GET-TAX-CONTROL-NUMBER.                                     
                                                                        
           EXEC SQL                                                     
              SELECT TAX_CNTRL_NO                                       
                INTO :F1-TAX-CNTRL-NO                                   
                FROM CSS_TAX_EXMPT_CODE WITH(READUNCOMMITTED)                   
               WHERE TAX_EXEMPT_CODE = :F1-TAX-EXEMPT-CODE              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT TAX_CNTRL_NO                                               
MFA-TR*         INTO :F1-TAX-CNTRL-NO                                           
MFA-TR*         FROM CSS_TAX_EXMPT_CODE                                         
MFA-TR*        WHERE TAX_EXEMPT_CODE = :F1-TAX-EXEMPT-CODE                      
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7250                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA177  ABORT **************'       
              DISPLAY '* 7250-GET-TAX-CONTROL-NUMBER           *'       
              DISPLAY '* TAX_EXEMPT_CODE = ' F1-TAX-EXEMPT-CODE         
              DISPLAY '* SQLCODE IS : ' WS-ACTIVE-RETURN-CODE           
              DISPLAY '* PROGRAM ABORTING...                   *'       
              DISPLAY '********** PCSCA177  ABORT **************'       
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
ACT004****************************************************************          
ACT004* GET TIER-ACCT-TYPE-CD                                        *          
ACT004****************************************************************          
ACT004*                                                                         
ACT004 7260-GET-TIER-ACCT-TYPE-CD.                                      
ACT004*                                                                         
ACT004     EXEC SQL                                                     
ACT004        SELECT TOP(1) TIER_ACCT_TYPE_CD,
              EFF_START_DT                                       
ACT004          INTO :DD-TIER-ACCT-TYPE-CD                              
ACT004             , :DD-EFF-START-DT                                   
ACT004          FROM CSS_ACCT_MKT_TIER  DD WITH(READUNCOMMITTED)                
ACT004         WHERE ACCOUNT_NO        = :DD-ACCOUNT-NO                 
ACT004           AND EFF_START_DT     <= IIF(TRY_CONVERT(DATE, 
                                                     :WS-HOLD-BILL-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-BILL-DATE
              ) <> 0) OR (LEN(:WS-HOLD-BILL-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-HOLD-BILL-DATE
              ), CONVERT(DATE, :WS-HOLD-BILL-DATE) )             
ACT004         ORDER BY EFF_START_DT DESC                               
ACT004                                              
ACT004                                                           
ACT004                                                      
ACT004     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT TIER_ACCT_TYPE_CD                                          
MFA-TR*            , EFF_START_DT                                               
MFA-TR*         INTO :DD-TIER-ACCT-TYPE-CD                                      
MFA-TR*            , :DD-EFF-START-DT                                           
MFA-TR*         FROM CSS_ACCT_MKT_TIER  DD                                      
MFA-TR*        WHERE ACCOUNT_NO        = :DD-ACCOUNT-NO                         
MFA-TR*          AND EFF_START_DT     <= :WS-HOLD-BILL-DATE                     
MFA-TR*        ORDER BY EFF_START_DT DESC                                       
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7260                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT004*                                                                         
ACT004     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT004*                                                                         
ACT004     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT004       NEXT SENTENCE                                              
ACT004     ELSE                                                         
ACT004        DISPLAY '********** PCSCA177  ABORT **************'       
ACT004        DISPLAY '* 7260-GET-TIER-ACCT-TYPE-CD            *'       
ACT004        DISPLAY '* DD-ACCOUNT-NO = ' DD-ACCOUNT-NO                
ACT004        DISPLAY '* SQLCODE IS : ' WS-ACTIVE-RETURN-CODE           
ACT004        DISPLAY '* PROGRAM ABORTING...                   *'       
ACT004        DISPLAY '********** PCSCA177  ABORT **************'       
ACT004        PERFORM 9900-ABEND THRU 9900-EXIT                         
ACT004     END-IF.                                                      
ACT004*                                                                         
ACT004 7260-EXIT.                                                       
ACT004     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * FETCH OPTION CODE FROM CSS_ACCT_RTPK_AGR                     *          
      ****************************************************************          
      *                                                                         
       7270-GET-OPTION-CODE.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT OPTION_CD                                          
                INTO :DF-OPTION-CD                                      
                FROM CSS_ACCT_RTPK_AGR WITH(READUNCOMMITTED)                    
               WHERE ACCOUNT_NO        = :DF-ACCOUNT-NO                 
                 AND CODE_UTIL_TYPE    = :DF-CODE-UTIL-TYPE             
                 AND IC_NO             = :DF-IC-NO                      
                 AND RT_PKG_OPT_SEQ_NO = :DF-RT-PKG-OPT-SEQ-NO          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT OPTION_CD                                                  
MFA-TR*         INTO :DF-OPTION-CD                                              
MFA-TR*         FROM CSS_ACCT_RTPK_AGR                                          
MFA-TR*        WHERE ACCOUNT_NO        = :DF-ACCOUNT-NO                         
MFA-TR*          AND CODE_UTIL_TYPE    = :DF-CODE-UTIL-TYPE                     
MFA-TR*          AND IC_NO             = :DF-IC-NO                              
MFA-TR*          AND RT_PKG_OPT_SEQ_NO = :DF-RT-PKG-OPT-SEQ-NO                  
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7270                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
             NEXT SENTENCE                                              
           ELSE                                                         
              DISPLAY '********** PCSCA177  ABORT **************'       
              DISPLAY '* 7270-GET-OPTION-CODE                  *'       
              DISPLAY '* DF-ACCOUNT-NO = ' DF-ACCOUNT-NO                
              DISPLAY '* DF-CODE-UTIL-TYPE = ' DF-CODE-UTIL-TYPE        
              DISPLAY '* DF-IC-NO = ' DF-IC-NO                          
              DISPLAY '* DF-RT-PKG-OPT-SEQ-NO = ' DF-RT-PKG-OPT-SEQ-NO  
              DISPLAY '* SQLCODE IS : ' WS-ACTIVE-RETURN-CODE           
              DISPLAY '* PROGRAM ABORTING...                   *'       
              DISPLAY '********** PCSCA177  ABORT **************'       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7270-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * FETCH OPT_CALC_TYPE_CD FROM CRM_RT_PKG_OPTION                *          
      ****************************************************************          
      *                                                                         
       7280-GET-OPT-CALC-TYPE-CD.                                       
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) OPT_CALC_TYPE_CD                                   
                INTO :FI-OPT-CALC-TYPE-CD                               
                FROM CRM_RT_PKG_OPTION WITH(READUNCOMMITTED)                    
               WHERE COMPANY_NO     = :FI-COMPANY-NO                    
                 AND OPT_CALC_TYPE_CD = 'FP'                            
                 AND OPTION_CD      = :FI-OPTION-CD                     
                 AND CODE_UTIL_TYPE = :FI-CODE-UTIL-TYPE                
                 AND RATE_PLAN_NO   = :FI-RATE-PLAN-NO                  
P00473           AND PROC_STATUS_CD = 'AC'                              
P00473         ORDER BY OPT_VSTART_TS DESC                              
P00473                                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT OPT_CALC_TYPE_CD                                           
MFA-TR*         INTO :FI-OPT-CALC-TYPE-CD                                       
MFA-TR*         FROM CRM_RT_PKG_OPTION                                          
MFA-TR*        WHERE COMPANY_NO     = :FI-COMPANY-NO                            
MFA-TR*          AND OPT_CALC_TYPE_CD = 'FP'                                    
MFA-TR*          AND OPTION_CD      = :FI-OPTION-CD                             
MFA-TR*          AND CODE_UTIL_TYPE = :FI-CODE-UTIL-TYPE                        
MFA-TR*          AND RATE_PLAN_NO   = :FI-RATE-PLAN-NO                          
MFA-TR*          AND PROC_STATUS_CD = 'AC'                                      
MFA-TR*        ORDER BY OPT_VSTART_TS DESC                                      
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7280                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
             NEXT SENTENCE                                              
           ELSE                                                         
              DISPLAY '********** PCSCA177  ABORT **************'       
              DISPLAY '* 7280-GET-OPT-CALC-TYPE-CD             *'       
              DISPLAY '* FI-COMPANY-NO = ' FI-COMPANY-NO                
              DISPLAY '* FI-OPTION-CD= ' FI-OPTION-CD                   
              DISPLAY '* FI-CODE-UTIL-TYPE= ' FI-CODE-UTIL-TYPE         
              DISPLAY '* FI-RATE-PLAN-NO = ' FI-RATE-PLAN-NO            
              DISPLAY '* SQLCODE IS : ' WS-ACTIVE-RETURN-CODE           
              DISPLAY '* PROGRAM ABORTING...                   *'       
              DISPLAY '********** PCSCA177  ABORT **************'       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7280-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *7300-GET-ORIG-BILL-DTL                                        *          
      *RETRIEVE BILL NUMBER AND CODE-BILL-CALC FOR BACKOUT ROW       *          
      ****************************************************************          
       7300-GET-ORIG-BILL-DTL.                                          
                                                                        
           EXEC SQL                                                     
              SELECT BG.BILL_NO                                         
                    ,BG.CODE_BILL_CALC                                  
                INTO :BG-BILL-NO                                        
                    ,:BG-CODE-BILL-CALC                                 
                FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                   
                    ,CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                   
               WHERE BI.ACCOUNT_NO         = :BI-ACCOUNT-NO             
                 AND BI.ACCOUNT_NO         =  BG.ACCOUNT_NO             
                 AND BI.BILL_NO            =  BG.BILL_NO                
                 AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE         
                 AND BG.IC_NO              = :BG-IC-NO                  
                 AND BG.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )     
ACT202           AND BG.BILL_NO           <> :BG-BILL-NO                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BG.BILL_NO                                                 
MFA-TR*             ,BG.CODE_BILL_CALC                                          
MFA-TR*         INTO :BG-BILL-NO                                                
MFA-TR*             ,:BG-CODE-BILL-CALC                                         
MFA-TR*         FROM CSS_BILLING_DET BG                                         
MFA-TR*             ,CSS_BILLING_HDR BI                                         
MFA-TR*        WHERE BI.ACCOUNT_NO         = :BI-ACCOUNT-NO                     
MFA-TR*          AND BI.ACCOUNT_NO         =  BG.ACCOUNT_NO                     
MFA-TR*          AND BI.BILL_NO            =  BG.BILL_NO                        
MFA-TR*          AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                 
MFA-TR*          AND BG.IC_NO              = :BG-IC-NO                          
MFA-TR*          AND BG.BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP             
MFA-TR*          AND BG.BILL_NO           <> :BG-BILL-NO                        
MFA-TR*          WITH UR                                                        
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
                                                                        
ACT202     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT202        CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA177  ABORT **************'       
              DISPLAY '* 7300-GET-ORIG-BILL-DTL                *'       
              DISPLAY '* ACCOUNT_NO        = ' BI-ACCOUNT-NO            
              DISPLAY '* REVENUE_MONTH     = ' BG-REVENUE-MONTH         
              DISPLAY '* CODE_UTIL_TYPE    = ' BG-CODE-UTIL-TYPE        
              DISPLAY '* DATE_BILLED       = ' BG-DATE-ORIG-BILL        
              DISPLAY '* IC_NO             = ' BG-IC-NO                 
              DISPLAY '* SQLCODE IS        : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '* PROGRAM ABORTING...                   *'       
              DISPLAY '********** PCSCA177  ABORT **************'       
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************          
      *7304-GET-CANCEL-BILL-DTL.                                     *          
      *RETRIEVE BILL NUMBER AND CODE-BILL-CALC FOR BACKOUT ROW       *          
      ****************************************************************          
       7304-GET-CANCEL-BILL-DTL.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) BG.BILL_NO,
              BG.CODE_BILL_CALC,
              REPLACE(REPLACE(CONVERT(CHAR(26), BG.BILL_ITEM_TIMESTMP
           , 121), ' ', '-'), ':', '.') BILL_ITEM_TIMESTMP                     
                INTO :BG-BILL-NO                                        
                    ,:BG-CODE-BILL-CALC                                 
                    ,:BG-BILL-ITEM-TIMESTMP                             
                FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                   
                    ,CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                   
               WHERE BI.ACCOUNT_NO         = :BI-ACCOUNT-NO             
                 AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO              
                 AND BI.BILL_NO            = BG.BILL_NO                 
                 AND BG.REV_MTH_ORIG_BILL  = :BG-REVENUE-MONTH          
                 AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE         
                 AND BI.DATE_BILLED        IS NOT NULL                  
                 AND BG.IC_NO              = :BG-IC-NO                  
                 AND BG.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )     
                 AND BG.CODE_BILL_CALC     IN ('A','S')                 
                 AND BG.CODE_BILL_ITM_TYPE = 'C'                        
                 AND BG.CODE_BILL_ITM_IND  = 'K'                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BG.BILL_NO                                                 
MFA-TR*             ,BG.CODE_BILL_CALC                                          
MFA-TR*             ,BG.BILL_ITEM_TIMESTMP                                      
MFA-TR*         INTO :BG-BILL-NO                                                
MFA-TR*             ,:BG-CODE-BILL-CALC                                         
MFA-TR*             ,:BG-BILL-ITEM-TIMESTMP                                     
MFA-TR*         FROM CSS_BILLING_DET BG                                         
MFA-TR*             ,CSS_BILLING_HDR BI                                         
MFA-TR*        WHERE BI.ACCOUNT_NO         = :BI-ACCOUNT-NO                     
MFA-TR*          AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO                      
MFA-TR*          AND BI.BILL_NO            = BG.BILL_NO                         
MFA-TR*          AND BG.REV_MTH_ORIG_BILL  = :BG-REVENUE-MONTH                  
MFA-TR*          AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                 
MFA-TR*          AND BI.DATE_BILLED        IS NOT NULL                          
MFA-TR*          AND BG.IC_NO              = :BG-IC-NO                          
MFA-TR*          AND BG.BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP             
MFA-TR*          AND BG.CODE_BILL_CALC     IN ('A','S')                         
MFA-TR*          AND BG.CODE_BILL_ITM_TYPE = 'C'                                
MFA-TR*          AND BG.CODE_BILL_ITM_IND  = 'K'                                
MFA-TR*          FETCH FIRST 1 ROWS ONLY                                        
MFA-TR*          WITH UR                                                        
MFA-TR*      QUERYNO 7304                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA177  ABORT **************'       
              DISPLAY '* 7304-GET-CANCEL-BILL-DTL.             *'       
              DISPLAY '* ACCOUNT_NO        = ' BI-ACCOUNT-NO            
              DISPLAY '* REVENUE_MONTH     = ' BG-REVENUE-MONTH         
              DISPLAY '* CODE_UTIL_TYPE    = ' BG-CODE-UTIL-TYPE        
              DISPLAY '* DATE_BILLED       = ' BG-DATE-ORIG-BILL        
              DISPLAY '* IC_NO             = ' BG-IC-NO                 
              DISPLAY '* SQLCODE IS        : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '* PROGRAM ABORTING...                   *'       
              DISPLAY '********** PCSCA177  ABORT **************'       
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7304-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *7305-GET-PREVIOUS-BILL-NO                                     *          
      *RETRIEVE BILL NUMBER FOR CANCEL OF A CANCEL/REBILL.           *          
      ****************************************************************          
       7305-GET-PREVIOUS-BILL-NO.                                       
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) BI.BILL_NO                                         
                INTO :BI-BILL-NO                                        
                FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                   
                    ,CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                   
               WHERE BI.ACCOUNT_NO         = :BI-ACCOUNT-NO             
                 AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO              
                 AND BI.BILL_NO            = BG.BILL_NO                 
                 AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE         
                 AND BI.DATE_BILLED        IS NOT NULL                  
                 AND BG.REV_MTH_ORIG_BILL  = :BG-REVENUE-MONTH          
                 AND BG.IC_NO              = :BG-IC-NO                  
                 AND BG.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )     
                 AND BG.CODE_BILL_CALC     IN ('A','S')                 
                 AND BG.CODE_BILL_ITM_TYPE = 'C'                        
                 AND BG.CODE_BILL_ITM_IND  = 'K'                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BI.BILL_NO                                                 
MFA-TR*         INTO :BI-BILL-NO                                                
MFA-TR*         FROM CSS_BILLING_DET BG                                         
MFA-TR*             ,CSS_BILLING_HDR BI                                         
MFA-TR*        WHERE BI.ACCOUNT_NO         = :BI-ACCOUNT-NO                     
MFA-TR*          AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO                      
MFA-TR*          AND BI.BILL_NO            = BG.BILL_NO                         
MFA-TR*          AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                 
MFA-TR*          AND BI.DATE_BILLED        IS NOT NULL                          
MFA-TR*          AND BG.REV_MTH_ORIG_BILL  = :BG-REVENUE-MONTH                  
MFA-TR*          AND BG.IC_NO              = :BG-IC-NO                          
MFA-TR*          AND BG.BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP             
MFA-TR*          AND BG.CODE_BILL_CALC     IN ('A','S')                         
MFA-TR*          AND BG.CODE_BILL_ITM_TYPE = 'C'                                
MFA-TR*          AND BG.CODE_BILL_ITM_IND  = 'K'                                
MFA-TR*          FETCH FIRST 1 ROWS ONLY                                        
MFA-TR*          WITH UR                                                        
MFA-TR*      QUERYNO 7305                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA177  ABORT **************'       
              DISPLAY '* 7305-GET-PREVIOUS-BILL-NO             *'       
              DISPLAY '* ACCOUNT_NO        = ' BI-ACCOUNT-NO            
              DISPLAY '* REVENUE_MONTH     = ' BG-REVENUE-MONTH         
              DISPLAY '* CODE_UTIL_TYPE    = ' BG-CODE-UTIL-TYPE        
              DISPLAY '* DATE_BILLED       = ' BG-DATE-ORIG-BILL        
              DISPLAY '* IC_NO             = ' BG-IC-NO                 
              DISPLAY '* SQLCODE IS        : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '* PROGRAM ABORTING...                   *'       
              DISPLAY '********** PCSCA177  ABORT **************'       
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7305-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7310-OPEN-SEB-REV-COMPANY-CSR.                                 *        
      * OPENS SEB REVENUE COMPANY CURSOR                               *        
      ******************************************************************        
       7310-OPEN-SEB-REV-COMPANY-CSR.                                   
                                                                        
           EXEC SQL                                                     
                OPEN SEB_REV_COMP_CSR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              DISPLAY '* 7310-OPEN-SEB-REV-COMPANY-CSR       *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7320-FETCH-SEB-REV-COMPANY-CSR.                                *        
      * FETCH SEB REVENUE COMPANY CURSOR                               *        
      ******************************************************************        
       7320-FETCH-SEB-REV-COMPANY-CSR.                                  

MSQ008     MOVE 50 TO MSQ008-SEB-REV-COMP-CSR
                                                                        
           EXEC SQL                                                     
                FOR :MSQ008-SEB-REV-COMP-CSR
              FETCH 
              FROM SEB_REV_COMP_CSR                 
                                                             
                 INTO :WS-TT-REV-COMPANY-NO                             
                     ,:WS-TT-COMPANY-NO                                 
                     ,:WS-TT-TIER-ACCT-TYPE-CD                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*         FETCH NEXT ROWSET FROM SEB_REV_COMP_CSR                         
MFA-TR*           FOR 50 ROWS                                                   
MFA-TR*          INTO :WS-TT-REV-COMPANY-NO                                     
MFA-TR*              ,:WS-TT-COMPANY-NO                                         
MFA-TR*              ,:WS-TT-TIER-ACCT-TYPE-CD                                  
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-SEB-REV-COMP-CSR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF SQLERRD (3) > 0                                        
                 MOVE SQLERRD (3)         TO WS-ORDER-ROW-COUNT         
              ELSE                                                      
                 MOVE 0                   TO WS-ORDER-ROW-COUNT         
              END-IF                                                    
              ADD WS-ORDER-ROW-COUNT   TO WS-TT-COUNT                   
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = +354                           
                 EXEC SQL                                               
MSQ012              GET DIAGNOSTICS :MFA-GD-ROW-COUNT = ROW_COUNT     
MSQ012                              ,:MFA-GD-NUMBER        = NUMBER       
                 END-EXEC                                               

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*          EXEC SQL                                                       
MFA-TR*             GET DIAGNOSTICS :WS-ORDER-ROW-COUNT = ROW_COUNT             
MFA-TR*                             ,:WS-NUM-COND        = NUMBER               
MFA-TR*          END-EXEC                                                       
MSQ012           MOVE MFA-GD-ROW-COUNT TO WS-ORDER-ROW-COUNT
MSQ012           MOVE MFA-GD-NUMBER TO WS-NUM-COND
                 DISPLAY '********** PCSCA177 ABORT  ************'      
                 DISPLAY '* 7320-FETCH-SEB-REV-COMPANY-CSR      *'      
                 DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
                 DISPLAY '* ROWCOUNT ' SQLERRD(3)                       
                 DISPLAY '* NUM_COND '  WS-NUM-COND                     
                 DISPLAY '* PROGRAM ABORTING...                 *'      
                 DISPLAY '********** PCSCA177 ABORT  ************'      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              ELSE                                                      
                 DISPLAY '********** PCSCA177 ABORT  ************'      
                 DISPLAY '* 7320-FETCH-SEB-REV-COMPANY-CSR      *'      
                 DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
                 DISPLAY '* PROGRAM ABORTING...                 *'      
                 DISPLAY '********** PCSCA177 ABORT  ************'      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7330-CLOSE-SEB-REV-COMP-CSR.                                   *        
      * CLOSE SEB REVENUE COMPANY CURSOR                               *        
      ******************************************************************        
       7330-CLOSE-SEB-REV-COMP-CSR.                                     
                                                                        
           EXEC SQL                                                     
              CLOSE SEB_REV_COMP_CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              DISPLAY '* 7330-CLOSE-SEB-REV-COMP-CSR         *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7330-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7340-OPEN-PRTY-SVC-CSR.                                        *        
      * OPENS PRIORITY SERVICE CATEGORY CODE CURSOR                    *        
      ******************************************************************        
       7340-OPEN-PRTY-SVC-CSR.                                          
                                                                        
           EXEC SQL                                                     
                OPEN PRTY_SVC_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              DISPLAY '* 7340-OPEN-PRTY-SVC-CSR              *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7340-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7350-FETCH-PRTY-SVC-CSR.                                       *        
      * FETCH PRIORITY SERVICE CATEGORY CODE                           *        
      ******************************************************************        
       7350-FETCH-PRTY-SVC-CSR.                                         

MSQ008     MOVE 50 TO MSQ008-PRTY-SVC-CSR
                                                                        
           EXEC SQL                                                     
                FOR :MSQ008-PRTY-SVC-CSR
              FETCH 
              FROM PRTY_SVC_CSR                     
                                                             
                 INTO :WS-Z4-PRTY-SVC-CAT-CD                            
                     ,:WS-Z4-COMPANY-NO                                 
                     ,:WS-Z4-CODE-CURTAIL-PRTY                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*         FETCH NEXT ROWSET FROM PRTY_SVC_CSR                             
MFA-TR*           FOR 50 ROWS                                                   
MFA-TR*          INTO :WS-Z4-PRTY-SVC-CAT-CD                                    
MFA-TR*              ,:WS-Z4-COMPANY-NO                                         
MFA-TR*              ,:WS-Z4-CODE-CURTAIL-PRTY                                  
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-PRTY-SVC-CSR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF SQLERRD (3) > 0                                        
                 MOVE SQLERRD (3)         TO WS-ORDER-ROW-COUNT         
              ELSE                                                      
                 MOVE 0                   TO WS-ORDER-ROW-COUNT         
              END-IF                                                    
              ADD WS-ORDER-ROW-COUNT   TO WS-Z4-COUNT                   
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = +354                           
                 EXEC SQL                                               
MSQ012              GET DIAGNOSTICS :MFA-GD-ROW-COUNT = ROW_COUNT     
MSQ012                              ,:MFA-GD-NUMBER        = NUMBER       
                 END-EXEC                                               

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*          EXEC SQL                                                       
MFA-TR*             GET DIAGNOSTICS :WS-ORDER-ROW-COUNT = ROW_COUNT             
MFA-TR*                             ,:WS-NUM-COND        = NUMBER               
MFA-TR*          END-EXEC                                                       
MSQ012           MOVE MFA-GD-ROW-COUNT TO WS-ORDER-ROW-COUNT
MSQ012           MOVE MFA-GD-NUMBER TO WS-NUM-COND
                 DISPLAY '********** PCSCA177 ABORT  ************'      
                 DISPLAY '* 7350-FETCH-PRTY-SVC-CSR             *'      
                 DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
                 DISPLAY '* ROWCOUNT ' SQLERRD(3)                       
                 DISPLAY '* NUM_COND '  WS-NUM-COND                     
                 DISPLAY '* PROGRAM ABORTING...                 *'      
                 DISPLAY '********** PCSCA177 ABORT  ************'      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              ELSE                                                      
                 DISPLAY '********** PCSCA177 ABORT  ************'      
                 DISPLAY '* 7350-FETCH-PRTY-SVC-CSR             *'      
                 DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
                 DISPLAY '* PROGRAM ABORTING...                 *'      
                 DISPLAY '********** PCSCA177 ABORT  ************'      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7360-CLOSE-PRTY-SVC-CSR.                                       *        
      * CLOSE PRIORITY SERVICE CATEGORY CURSOR                         *        
      ******************************************************************        
       7360-CLOSE-PRTY-SVC-CSR.                                         
                                                                        
           EXEC SQL                                                     
              CLOSE PRTY_SVC_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              DISPLAY '* 7360-CLOSE-PRTY-SVC-CSR             *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7360-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *7370-GET-EQUIP-ID-CHG-DATA.                                   *          
      *GET THE DATA TO IDENTIFY EQUIP ID CHANGES                     *          
      ****************************************************************          
       7370-GET-EQUIP-ID-CHG-DATA.                                      
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CODE_LONG_DESC                                     
                INTO :UV-CODE-LONG-DESC                                 
                FROM CSS_CODE_VALUE WITH(READUNCOMMITTED)                       
               WHERE TABLE_NA   = 'EQUIP_ID_CHG'                        
                 AND PROGRAM_ID = :UV-PROGRAM-ID                        
                 AND CODE_VALUE = :UV-CODE-VALUE                        
                 AND COMPANY_NO = '01'                                  
                 AND COLUMN_NA  = 'EQUIP_ID_CHG'                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_LONG_DESC                                             
MFA-TR*         INTO :UV-CODE-LONG-DESC                                         
MFA-TR*         FROM CSS_CODE_VALUE                                             
MFA-TR*        WHERE TABLE_NA   = 'EQUIP_ID_CHG'                                
MFA-TR*          AND PROGRAM_ID = :UV-PROGRAM-ID                                
MFA-TR*          AND CODE_VALUE = :UV-CODE-VALUE                                
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*          AND COLUMN_NA  = 'EQUIP_ID_CHG'                                
MFA-TR*          FETCH FIRST 1 ROWS ONLY                                        
MFA-TR*          WITH UR                                                        
MFA-TR*      QUERYNO 7370                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA177  ABORT **************'       
              DISPLAY '* 7370-GET-EQUIP-ID-CHG-DATA            *'       
              DISPLAY '* CODE_VALUE        = ' UV-CODE-VALUE            
              DISPLAY '* PROGRAM_ID        = ' UV-PROGRAM-ID            
PRJ257        DISPLAY '* SQLCODE IS          ', WS-ACTIVE-RETURN-CODE   
              DISPLAY '* PROGRAM ABORTING...                   *'       
              DISPLAY '********** PCSCA177  ABORT **************'       
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7370-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *7375-GET-SERVICE-TYPE.                                        *          
      *GET CODE-SERVICE-TYPE IF NOT PRESENT IN BE00 FILE             *          
      ****************************************************************          
       7375-GET-SERVICE-TYPE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CODE_SERVICE_TYPE                                  
                INTO :CP-CODE-SERVICE-TYPE                              
                FROM  CSS_CUST_PLAN WITH(READUNCOMMITTED)                       
               WHERE ACCOUNT_NO     =:CP-ACCOUNT-NO                     
                AND  CODE_UTIL_TYPE =:CP-CODE-UTIL-TYPE                 
                AND  IC_NO          =:CP-IC-NO                          
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_SERVICE_TYPE                                          
MFA-TR*         INTO :CP-CODE-SERVICE-TYPE                                      
MFA-TR*         FROM  CSS_CUST_PLAN                                             
MFA-TR*        WHERE ACCOUNT_NO     =:CP-ACCOUNT-NO                             
MFA-TR*         AND  CODE_UTIL_TYPE =:CP-CODE-UTIL-TYPE                         
MFA-TR*         AND  IC_NO          =:CP-IC-NO                                  
MFA-TR*          FETCH FIRST 1 ROWS ONLY                                        
MFA-TR*          WITH UR                                                        
MFA-TR*      QUERYNO 7375                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA177  ABORT **************'       
              DISPLAY '* 7375-GET-SERVICE-TYPE                 *'       
              DISPLAY '* ACCOUNT-NO        = ' CP-ACCOUNT-NO            
              DISPLAY '* CODE_UTIL_TYPE    = ' CP-CODE-UTIL-TYPE        
              DISPLAY '* IC_NO             = ' CP-IC-NO                 
PRJ257        DISPLAY '* SQLCODE IS          ', WS-ACTIVE-RETURN-CODE   
              DISPLAY '* PROGRAM ABORTING...                   *'       
              DISPLAY '********** PCSCA177  ABORT **************'       
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7375-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7380-OPEN-CODE-VALUE-CSR.                                      *        
      * OPENS CODE_VALUE CURSOR.                                       *        
      ******************************************************************        
       7380-OPEN-CODE-VALUE-CSR.                                        
                                                                        
           EXEC SQL                                                     
                OPEN CODE_VALUE_CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              DISPLAY '* 7380-OPEN-CODE-VALUE-CSR            *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7380-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7385-FETCH-CODE-VALUE-CSR.                                     *        
      * FETCH CODE VALUE DATA.                                         *        
      ******************************************************************        
       7385-FETCH-CODE-VALUE-CSR.                                       
                                                                        
           EXEC SQL                                                     
                FETCH CODE_VALUE_CSR                                    
                 INTO :UV-COLUMN-NA                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              DISPLAY '* 7385-FETCH-CODE-VALUE-CSR           *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7385-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7390-CLOSE-CODE-VALUE-CSR.                                     *        
      * CLOSE CODE VALUE CURSOR.                                       *        
      ******************************************************************        
       7390-CLOSE-CODE-VALUE-CSR.                                       
                                                                        
           EXEC SQL                                                     
              CLOSE CODE_VALUE_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              DISPLAY '* 7390-CLOSE-CODE-VALUE-CSR           *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7390-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *7400-GET-REV-BILLING-DET.                                     *          
      *GET DATA FROM REV-BILLING-DET FOR ORIGINAL BILL.              *          
      ****************************************************************          
       7400-GET-REV-BILLING-DET.                                        
                                                                        
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), BILL_UNIQUE_TS
           , 121), ' ', '-'), ':', '.') BILL_UNIQUE_TS,                        
                     REV_COMPANY_NO,                                    
                     COMPANY_NO,                                        
                     REVENUE_MONTH,                                     
                     CODE_SERVICE_TYPE,                                 
                     ACCOUNT_NO,                                        
                     BILL_NO,                                           
                     CODE_UTIL_TYPE,                                    
                     IC_NO,                                             
                     REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP,                                
                     CUST_CT,                                           
                     CUST_CT_EXCL_LIGHT,                                
                     USAGE_END_DATE,                                    
                     NO_OF_CONS_DAYS,                                   
                     PRORATED_DAYS_CD,                                  
                     BTU_FACTOR,                                        
                     GAS_BASE_USE,                                      
                     DESIGN_DAY_CAP,                                    
                     DATE_BILLED,                                       
                     DATE_ORIG_BILL,                                    
                     REV_MTH_ORIG_BILL,                                 
                     ACCT_BILL_CYCLE,                                   
                     BILL_CALC_CYCLE,                                   
                     CODE_REV_ACCT_TYPE,                                
                     CODE_REVENUE_CLASS,                                
                     RATE_PLAN_NO,                                      
                     RATE_DEPT_CD,                                      
                     PRTY_SVC_CAT_CD,                                   
                     CODE_SIC_NO,                                       
                     NAICS_CD,                                          
                     TIER_ACCT_TYPE_CD,                                 
                     OPTION_CD,                                         
                     RATE_CALC_TYPE_CD,                                 
                     LOCAL_OFFICE,                                      
                     REV_DISTRICT_CD,                                   
                     MNICPLTY_COUNTY_CD,                                
                     PREMISE_NO,                                        
                     CALC_SOURCE_CD                                     
                INTO :RV-BILL-UNIQUE-TS                                 
                    ,:RV-REV-COMPANY-NO                                 
                    ,:RV-COMPANY-NO                                     
                    ,:RV-REVENUE-MONTH                                  
                    ,:RV-CODE-SERVICE-TYPE                              
                    ,:RV-ACCOUNT-NO                                     
                    ,:RV-BILL-NO                                        
                    ,:RV-CODE-UTIL-TYPE                                 
                    ,:RV-IC-NO                                          
                    ,:RV-BILL-ITEM-TIMESTMP                             
                    ,:RV-CUST-CT                                        
                    ,:RV-CUST-CT-EXCL-LIGHT                             
                    ,:RV-USAGE-END-DATE :WS-NI-USAGE-END-DATE           
                    ,:RV-NO-OF-CONS-DAYS                                
                    ,:RV-PRORATED-DAYS-CD                               
                    ,:RV-BTU-FACTOR                                     
                    ,:RV-GAS-BASE-USE                                   
                    ,:RV-DESIGN-DAY-CAP                                 
                    ,:RV-DATE-BILLED :WS-NI-DATE-BILLED                 
                    ,:RV-DATE-ORIG-BILL :WS-NI-DATE-ORIG-BILL           
                    ,:RV-REV-MTH-ORIG-BILL                              
                    ,:RV-ACCT-BILL-CYCLE                                
                    ,:RV-BILL-CALC-CYCLE                                
                    ,:RV-CODE-REV-ACCT-TYPE                             
                    ,:RV-CODE-REVENUE-CLASS                             
                    ,:RV-RATE-PLAN-NO                                   
                    ,:RV-RATE-DEPT-CD                                   
                    ,:RV-PRTY-SVC-CAT-CD                                
                    ,:RV-CODE-SIC-NO                                    
                    ,:RV-NAICS-CD                                       
                    ,:RV-TIER-ACCT-TYPE-CD                              
                    ,:RV-OPTION-CD                                      
                    ,:RV-RATE-CALC-TYPE-CD                              
                    ,:RV-LOCAL-OFFICE                                   
                    ,:RV-REV-DISTRICT-CD                                
                    ,:RV-MNICPLTY-COUNTY-CD                             
                    ,:RV-PREMISE-NO                                     
                    ,:RV-CALC-SOURCE-CD                                 
                FROM  REV_BILLING_DET WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO         =:RV-ACCOUNT-NO                 
                AND  CODE_UTIL_TYPE     =:RV-CODE-UTIL-TYPE             
                AND  IC_NO              =:RV-IC-NO                      
                AND  BILL_NO            =:RV-BILL-NO                    
                AND  BILL_ITEM_TIMESTMP =CIS.CHAR2TIMESTAMP(
                                                 :RV-BILL-ITEM-TIMESTMP
              )         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BILL_UNIQUE_TS,                                            
MFA-TR*              REV_COMPANY_NO,                                            
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              REVENUE_MONTH,                                             
MFA-TR*              CODE_SERVICE_TYPE,                                         
MFA-TR*              ACCOUNT_NO,                                                
MFA-TR*              BILL_NO,                                                   
MFA-TR*              CODE_UTIL_TYPE,                                            
MFA-TR*              IC_NO,                                                     
MFA-TR*              BILL_ITEM_TIMESTMP,                                        
MFA-TR*              CUST_CT,                                                   
MFA-TR*              CUST_CT_EXCL_LIGHT,                                        
MFA-TR*              USAGE_END_DATE,                                            
MFA-TR*              NO_OF_CONS_DAYS,                                           
MFA-TR*              PRORATED_DAYS_CD,                                          
MFA-TR*              BTU_FACTOR,                                                
MFA-TR*              GAS_BASE_USE,                                              
MFA-TR*              DESIGN_DAY_CAP,                                            
MFA-TR*              DATE_BILLED,                                               
MFA-TR*              DATE_ORIG_BILL,                                            
MFA-TR*              REV_MTH_ORIG_BILL,                                         
MFA-TR*              ACCT_BILL_CYCLE,                                           
MFA-TR*              BILL_CALC_CYCLE,                                           
MFA-TR*              CODE_REV_ACCT_TYPE,                                        
MFA-TR*              CODE_REVENUE_CLASS,                                        
MFA-TR*              RATE_PLAN_NO,                                              
MFA-TR*              RATE_DEPT_CD,                                              
MFA-TR*              PRTY_SVC_CAT_CD,                                           
MFA-TR*              CODE_SIC_NO,                                               
MFA-TR*              NAICS_CD,                                                  
MFA-TR*              TIER_ACCT_TYPE_CD,                                         
MFA-TR*              OPTION_CD,                                                 
MFA-TR*              RATE_CALC_TYPE_CD,                                         
MFA-TR*              LOCAL_OFFICE,                                              
MFA-TR*              REV_DISTRICT_CD,                                           
MFA-TR*              MNICPLTY_COUNTY_CD,                                        
MFA-TR*              PREMISE_NO,                                                
MFA-TR*              CALC_SOURCE_CD                                             
MFA-TR*         INTO :RV-BILL-UNIQUE-TS                                         
MFA-TR*             ,:RV-REV-COMPANY-NO                                         
MFA-TR*             ,:RV-COMPANY-NO                                             
MFA-TR*             ,:RV-REVENUE-MONTH                                          
MFA-TR*             ,:RV-CODE-SERVICE-TYPE                                      
MFA-TR*             ,:RV-ACCOUNT-NO                                             
MFA-TR*             ,:RV-BILL-NO                                                
MFA-TR*             ,:RV-CODE-UTIL-TYPE                                         
MFA-TR*             ,:RV-IC-NO                                                  
MFA-TR*             ,:RV-BILL-ITEM-TIMESTMP                                     
MFA-TR*             ,:RV-CUST-CT                                                
MFA-TR*             ,:RV-CUST-CT-EXCL-LIGHT                                     
MFA-TR*             ,:RV-USAGE-END-DATE :WS-NI-USAGE-END-DATE                   
MFA-TR*             ,:RV-NO-OF-CONS-DAYS                                        
MFA-TR*             ,:RV-PRORATED-DAYS-CD                                       
MFA-TR*             ,:RV-BTU-FACTOR                                             
MFA-TR*             ,:RV-GAS-BASE-USE                                           
MFA-TR*             ,:RV-DESIGN-DAY-CAP                                         
MFA-TR*             ,:RV-DATE-BILLED :WS-NI-DATE-BILLED                         
MFA-TR*             ,:RV-DATE-ORIG-BILL :WS-NI-DATE-ORIG-BILL                   
MFA-TR*             ,:RV-REV-MTH-ORIG-BILL                                      
MFA-TR*             ,:RV-ACCT-BILL-CYCLE                                        
MFA-TR*             ,:RV-BILL-CALC-CYCLE                                        
MFA-TR*             ,:RV-CODE-REV-ACCT-TYPE                                     
MFA-TR*             ,:RV-CODE-REVENUE-CLASS                                     
MFA-TR*             ,:RV-RATE-PLAN-NO                                           
MFA-TR*             ,:RV-RATE-DEPT-CD                                           
MFA-TR*             ,:RV-PRTY-SVC-CAT-CD                                        
MFA-TR*             ,:RV-CODE-SIC-NO                                            
MFA-TR*             ,:RV-NAICS-CD                                               
MFA-TR*             ,:RV-TIER-ACCT-TYPE-CD                                      
MFA-TR*             ,:RV-OPTION-CD                                              
MFA-TR*             ,:RV-RATE-CALC-TYPE-CD                                      
MFA-TR*             ,:RV-LOCAL-OFFICE                                           
MFA-TR*             ,:RV-REV-DISTRICT-CD                                        
MFA-TR*             ,:RV-MNICPLTY-COUNTY-CD                                     
MFA-TR*             ,:RV-PREMISE-NO                                             
MFA-TR*             ,:RV-CALC-SOURCE-CD                                         
MFA-TR*         FROM  REV_BILLING_DET                                           
MFA-TR*        WHERE ACCOUNT_NO         =:RV-ACCOUNT-NO                         
MFA-TR*         AND  CODE_UTIL_TYPE     =:RV-CODE-UTIL-TYPE                     
MFA-TR*         AND  IC_NO              =:RV-IC-NO                              
MFA-TR*         AND  BILL_NO            =:RV-BILL-NO                            
MFA-TR*         AND  BILL_ITEM_TIMESTMP =:RV-BILL-ITEM-TIMESTMP                 
MFA-TR*          WITH UR                                                        
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF WS-NI-USAGE-END-DATE = -1                           
                    MOVE SPACES             TO RV-USAGE-END-DATE        
                 END-IF                                                 
                 IF WS-NI-DATE-ORIG-BILL = -1                           
                    MOVE SPACES             TO RV-DATE-ORIG-BILL        
                 END-IF                                                 
                 IF WS-NI-DATE-BILLED = -1                              
                    MOVE SPACES             TO RV-DATE-BILLED           
                 END-IF                                                 
                 SET DO-NOT-CALL-BILL-CALC  TO TRUE                     
                 SET DO-NOT-PROCESS-BG      TO TRUE                     
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSCA177  ABORT **************'       
              DISPLAY '* 7400-GET-REV-BILLING-DET              *'       
              DISPLAY '* ACCOUNT-NO        = ' RV-ACCOUNT-NO            
              DISPLAY '* CODE_UTIL_TYPE    = ' RV-CODE-UTIL-TYPE        
              DISPLAY '* IC_NO             = ' RV-IC-NO                 
              DISPLAY '* BILL_NO           = ' RV-BILL-NO               
              DISPLAY '* BILL_ITEM_TSTMP   = ' RV-BILL-ITEM-TIMESTMP    
PRJ257        DISPLAY '* SQLCODE IS          ', WS-ACTIVE-RETURN-CODE   
              DISPLAY '* PROGRAM ABORTING...                   *'       
              DISPLAY '********** PCSCA177  ABORT **************'       
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7410-OPEN-REV-ADJ-CSR.                                         *        
      * OPENS REV_ADJ CURSOR.                                          *        
      ******************************************************************        
       7410-OPEN-REV-ADJ-CSR.                                           
                                                                        
           EXEC SQL                                                     
                OPEN REV_ADJ_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              DISPLAY '* 7410-OPEN-REV-ADJ-CSR               *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7420-FETCH-REV-ADJ-CSR.                                        *        
      * FETCH REV_BILL_COMP_ADJ DATA                                   *        
      ******************************************************************        
       7420-FETCH-REV-ADJ-CSR.                                          
                                                                        
           EXEC SQL                                                     
                FETCH REV_ADJ_CSR                                       
                 INTO :RB-BILL-UNIQUE-TS                                
                     ,:RB-BILL-COMP-SEQ-NO                              
                     ,:RB-CMPNT-ID-CD                                   
                     ,:RB-INSTR-USE-TYPE-CD                             
                     ,:RB-CONSUMPT-TYPE-CD                              
                     ,:RB-CODE-TIME-PERIOD                              
                     ,:RB-CODE-SEASON                                   
                     ,:RB-RT-VERS-FROM-DT :WS-NI-RT-VERSN-DT            
                     ,:RB-RT-VERS-PRO-CD                                
                     ,:RB-FACTOR-ID                                     
                     ,:RB-FACTOR-BLOCK-NO                               
                     ,:RB-RT-FCT-FROM-DT :WS-NI-RT-FCT-FROM-DT          
                     ,:RB-RT-FCT-PRO-CD                                 
                     ,:RB-READ-UNITS                                    
                     ,:RB-BILL-USAGE-UNITS                              
                     ,:RB-BILL-DEMAND-UNITS                             
                     ,:RB-CALC-UNITS                                    
                     ,:RB-FACTOR                                        
                     ,:RB-BILLED-AMT                                    
                     ,:RB-CODE-STAT-TAX-XMT                             
                     ,:RB-CODE-CITY-TAX-XMT                             
                     ,:RB-CODE-OTHR-TAX-XMT                             
                     ,:RB-UTILITY-REV-CD                                
                     ,:RB-COMP-ADJ-CD                                   
                     ,:RB-GL-ACCT-NO                                    
                     ,:RB-SPCL-GROUP-CD                                 
                     ,:RB-ACCOUNT-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NI-RT-VERSN-DT = -1                                 
                 MOVE SPACES              TO RB-RT-VERS-FROM-DT         
              END-IF                                                    
              IF WS-NI-RT-FCT-FROM-DT = -1                              
                 MOVE SPACES              TO RB-RT-FCT-FROM-DT          
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              DISPLAY '* 7420-FETCH-REV-ADJ-CSR.             *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7430-CLOSE-REV-ADJ-CSR.                                        *        
      * CLOSE REV_ADJ CURSOR.                                          *        
      ******************************************************************        
       7430-CLOSE-REV-ADJ-CSR.                                          
                                                                        
           EXEC SQL                                                     
              CLOSE REV_ADJ_CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              DISPLAY '* 7430-CLOSE-REV-ADJ-CSR.             *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7430-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7440-OPEN-REV-BLK-CSR.                                         *        
      * OPENS REV_BLK CURSOR.                                          *        
      ******************************************************************        
       7440-OPEN-REV-BLK-CSR.                                           
                                                                        
           EXEC SQL                                                     
                OPEN REV_BLK_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              DISPLAY '* 7440-OPEN-REV-BLK-CSR               *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7440-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7450-FETCH-REV-BLK-CSR.                                        *        
      * FETCH REV_BILL_BLOCK DATA                                      *        
      ******************************************************************        
       7450-FETCH-REV-BLK-CSR.                                          
                                                                        
           EXEC SQL                                                     
                FETCH REV_BLK_CSR                                       
                 INTO :R7-BILL-UNIQUE-TS                                
                     ,:R7-BILL-COMP-SEQ-NO                              
                     ,:R7-BLK-NO-RT-ITM-CD                              
                     ,:R7-BLK-USE-OR-SVCS                               
                     ,:R7-BLK-BILL-USE-UNITS                            
                     ,:R7-BLK-BILL-DEM-UNITS                            
                     ,:R7-BLK-BILL-LT-POLES                             
                     ,:R7-CUST-PER-SERVICE                              
                     ,:R7-PRICE-TYPE-CD                                 
                     ,:R7-SCHED-PRICE-AM                                
                     ,:R7-UNIT-PRICE-AM                                 
                     ,:R7-BLK-REV-AMT                                   
                     ,:R7-NET-UNIT-SEL-RSN                              
                     ,:R7-KW-MDQ-DT :WS-NI-KW-MDQ-DT                    
                     ,:R7-KVA-DT :WS-NI-KVA-DT                          
                     ,:R7-CONTRACT-DEMAND                               
                     ,:R7-READ-KW-MDQ-UNITS                             
                     ,:R7-READ-KVA-UNITS                                
                     ,:R7-POWER-FACTOR                                  
                     ,:R7-LOAD-FACTOR                                   
                     ,:R7-RT-VERS-PRO-PCT                               
                     ,:R7-ACCOUNT-NO                                    
                     ,:R7-RATE-ITEM-CODE                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NI-KW-MDQ-DT = -1                                   
                 MOVE SPACES              TO R7-KW-MDQ-DT               
              END-IF                                                    
              IF WS-NI-KVA-DT = -1                                      
                 MOVE SPACES              TO R7-KVA-DT                  
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              DISPLAY '* 7450-FETCH-REV-BLK-CSR.             *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7460-CLOSE-REV-BLK-CSR.                                        *        
      * CLOSE REV_BLK CURSOR.                                          *        
      ******************************************************************        
       7460-CLOSE-REV-BLK-CSR.                                          
                                                                        
           EXEC SQL                                                     
              CLOSE REV_BLK_CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              DISPLAY '* 7460-CLOSE-REV-BLK-CSR.             *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7460-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7470-OPEN-REV-TAX-CSR.                                         *        
      * OPENS REV_TAX CURSOR.                                          *        
      ******************************************************************        
       7470-OPEN-REV-TAX-CSR.                                           
                                                                        
           EXEC SQL                                                     
                OPEN REV_TAX_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              DISPLAY '* 7470-OPEN-REV-TAX-CSR               *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7470-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7480-FETCH-REV-TAX-CSR.                                        *        
      * FETCH REV_BILL_TAX DATA                                        *        
      ******************************************************************        
       7480-FETCH-REV-TAX-CSR.                                          
                                                                        
           EXEC SQL                                                     
                FETCH REV_TAX_CSR                                       
                 INTO :R9-BILL-UNIQUE-TS                                
                     ,:R9-TAX-TYPE                                      
                     ,:R9-TAX-CNTRL-NO                                  
                     ,:R9-TAX-FROM-DT                                   
                     ,:R9-FACTOR-ID                                     
                     ,:R9-TAX-GL-ACCT-NO                                
                     ,:R9-TAX-AMT                                       
                     ,:R9-ACCOUNT-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              DISPLAY '* 7480-FETCH-REV-TAX-CSR.             *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7480-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7490-CLOSE-REV-TAX-CSR.                                        *        
      * CLOSE REV_TAX CURSOR.                                          *        
      ******************************************************************        
       7490-CLOSE-REV-TAX-CSR.                                          
                                                                        
           EXEC SQL                                                     
              CLOSE REV_TAX_CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              DISPLAY '* 7490-CLOSE-REV-TAX-CSR.             *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA177 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7490-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *7500-SELECT-BACKOUT-CNSMPTN                                   *          
      *GET BACKOUT CONSUMPTION, CCF'S ARE NOT PASSED FROM BILL-CALC  *          
      *FOR SOME ACCOUNTS.                                            *          
      ****************************************************************          
       7500-SELECT-BACKOUT-CNSMPTN.                                     
                                                                        
           EXEC SQL                                                     
                SELECT SUM(BILL_UNITS),SUM(READ_UNITS),                 
                       CONSUMPT_TYPE_CD                                 
                INTO  :BZ-BILL-UNITS :WS-NI-BILL-UNITS                  
                     ,:BZ-READ-UNITS :WS-NI-READ-UNITS                  
                     ,:BZ-CONSUMPT-TYPE-CD :WS-NI-CONSUMPT-TYPE-CD       
                FROM CSS_BILL_CALC_DET,                                 
                     CSS_RATE_COMPONENT                                 
                WHERE ACCOUNT_NO         = :BZ-ACCOUNT-NO               
                AND   CODE_UTIL_TYPE     = :BZ-CODE-UTIL-TYPE           
                AND   IC_NO              = :BZ-IC-NO                    
                AND   CONSUMPT_TYPE_CD   IN ('B','C','D')               
                AND   BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BZ-BILL-ITEM-TIMESTMP
              )       
                AND   CMPNT_ID_CD        = :BZ-CMPNT-ID-CD              
                AND   CMPNT_ID_CD        = RATE_CMPNT_ID                
                AND   REVENUE_CNSMPTN_FL = 'Y'                          
                GROUP BY CONSUMPT_TYPE_CD                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT SUM(BILL_UNITS),SUM(READ_UNITS),                         
MFA-TR*                CONSUMPT_TYPE_CD                                         
MFA-TR*         INTO  :BZ-BILL-UNITS :WS-NI-BILL-UNITS                          
MFA-TR*              ,:BZ-READ-UNITS :WS-NI-READ-UNITS                          
MFA-TR*              ,:BZ-CONSUMPT-TYPE-CD:WS-NI-CONSUMPT-TYPE-CD               
MFA-TR*         FROM CSS_BILL_CALC_DET,                                         
MFA-TR*              CSS_RATE_COMPONENT                                         
MFA-TR*         WHERE ACCOUNT_NO         = :BZ-ACCOUNT-NO                       
MFA-TR*         AND   CODE_UTIL_TYPE     = :BZ-CODE-UTIL-TYPE                   
MFA-TR*         AND   IC_NO              = :BZ-IC-NO                            
MFA-TR*         AND   CONSUMPT_TYPE_CD   IN ('B','C','D')                       
MFA-TR*         AND   BILL_ITEM_TIMESTMP = :BZ-BILL-ITEM-TIMESTMP               
MFA-TR*         AND   CMPNT_ID_CD        = :BZ-CMPNT-ID-CD                      
MFA-TR*         AND   CMPNT_ID_CD        = RATE_CMPNT_ID                        
MFA-TR*         AND   REVENUE_CNSMPTN_FL = 'Y'                                  
MFA-TR*         GROUP BY CONSUMPT_TYPE_CD                                       
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF WS-NI-BILL-UNITS < 0                                
                   MOVE 0                   TO BZ-BILL-UNITS            
                 END-IF                                                 
                                                                        
                 IF WS-NI-READ-UNITS < 0                                
                   MOVE 0                   TO BZ-READ-UNITS            
                 END-IF                                                 
              ELSE                                                      
                   MOVE 0                   TO BZ-READ-UNITS            
                                               BZ-BILL-UNITS            
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSCA177  ABORT **************'       
              DISPLAY '* 7500-SELECT-BACKOUT-CNSMPTN           *'       
              DISPLAY '* ACCOUNT-NO        = ' BZ-ACCOUNT-NO            
              DISPLAY '* CODE_UTIL_TYPE    = ' BZ-CODE-UTIL-TYPE        
              DISPLAY '* IC_NO             = ' BZ-IC-NO                 
              DISPLAY '* BILL_ITM_TIMESTMP = ' BZ-BILL-ITEM-TIMESTMP    
PRJ257        DISPLAY '* SQLCODE IS          ', WS-ACTIVE-RETURN-CODE   
              DISPLAY '* PROGRAM ABORTING...                   *'       
              DISPLAY '********** PCSCA177  ABORT **************'       
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T03014****************************************************************          
T03014*7510-SELECT-CMPNT-ID-CD.                                      *          
T03014*GET CMPNT-ID-CD FROM CSS_RATE_COMP-DEF USING THE CODE-UTIL-TYPE          
T03014*AND RATE-PLAN-NO FROM BG RECORD.                              *          
T03014****************************************************************          
T03014 7510-SELECT-CMPNT-ID-CD.                                         
T03014                                                                  
T03014     EXEC SQL                                                     
T03014          SELECT TOP(1) CMPNT_ID_CD,
              VERSION_NO_CNTRL                                 
T03014            INTO :J1-CMPNT-ID-CD                                  
T03014                ,:J1-VERSION-NO-CNTRL                             
T03014            FROM CSS_RATE_COMP_DEF J1                             
T03014           WHERE CODE_UTIL_TYPE = :J1-CODE-UTIL-TYPE              
T03014             AND RATE_PLAN_NO   = :J1-RATE-PLAN-NO                
T03014           ORDER BY 2 DESC                                        
T03014                                           
T03014                                                      
T03014     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT CMPNT_ID_CD                                              
MFA-TR*               ,VERSION_NO_CNTRL                                         
MFA-TR*           INTO :J1-CMPNT-ID-CD                                          
MFA-TR*               ,:J1-VERSION-NO-CNTRL                                     
MFA-TR*           FROM CSS_RATE_COMP_DEF J1                                     
MFA-TR*          WHERE CODE_UTIL_TYPE = :J1-CODE-UTIL-TYPE                      
MFA-TR*            AND RATE_PLAN_NO   = :J1-RATE-PLAN-NO                        
MFA-TR*          ORDER BY 2 DESC                                                
MFA-TR*          FETCH FIRST 1 ROWS ONLY                                        
MFA-TR*        QUERYNO 7510                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T03014*                                                                         
T03014     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
T03014                                                                  
T03014     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T03014        NEXT SENTENCE                                             
T03014     ELSE                                                         
T03014        DISPLAY '********** PCSCA177  ABORT **************'       
T03014        DISPLAY '* 7510-SELECT-CMPNT-ID-CD               *'       
T03014        DISPLAY '* CODE_UTIL_TYPE    = ' J1-CODE-UTIL-TYPE        
T03014        DISPLAY '* RATE_PLAN_NO      = ' J1-RATE-PLAN-NO          
T03014        DISPLAY '* SQLCODE IS          ',WS-ACTIVE-RETURN-CODE    
T03014        DISPLAY '* PROGRAM ABORTING...                   *'       
T03014        DISPLAY '********** PCSCA177  ABORT **************'       
T03014        PERFORM 9900-ABEND           THRU 9900-EXIT               
T03014     END-IF.                                                      
T03014                                                                  
T03014 7510-EXIT.                                                       
T03014     EXIT.                                                        
T03014*                                                                         
T03014****************************************************************          
T03014*7520-SELECT-RT-VERS-FROM-DT.                                  *          
T03014*GET RT-VERS-FROM-DT FROM CSS_RATE_CREATOR RT USING THE        *          
T03014*CODE-UTIL-TYPE AND RATE-PLAN-NO FROM BG RECORD.               *          
T03014****************************************************************          
T03014 7520-SELECT-RT-VERS-FROM-DT.                                     
T03014                                                                  
T03014     EXEC SQL                                                     
T03014          SELECT TOP(1) FROM_EFFECTIVE_DT,
              VERSION_NO_CNTRL                                 
T03014            INTO :RT-FROM-EFFECTIVE-DT                            
T03014                ,:RT-VERSION-NO-CNTRL                             
T03014            FROM CSS_RATE_CREATOR RT                              
T03014           WHERE CODE_UTIL_TYPE  = :RT-CODE-UTIL-TYPE             
T03014             AND RATE_PLAN_NO    = :RT-RATE-PLAN-NO               
T03014           ORDER BY 2 DESC                                        
T03014                                           
T03014                                                      
T03014     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT FROM_EFFECTIVE_DT                                        
MFA-TR*               ,VERSION_NO_CNTRL                                         
MFA-TR*           INTO :RT-FROM-EFFECTIVE-DT                                    
MFA-TR*               ,:RT-VERSION-NO-CNTRL                                     
MFA-TR*           FROM CSS_RATE_CREATOR RT                                      
MFA-TR*          WHERE CODE_UTIL_TYPE  = :RT-CODE-UTIL-TYPE                     
MFA-TR*            AND RATE_PLAN_NO    = :RT-RATE-PLAN-NO                       
MFA-TR*          ORDER BY 2 DESC                                                
MFA-TR*          FETCH FIRST 1 ROWS ONLY                                        
MFA-TR*        QUERYNO 7520                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T03014*                                                                         
T03014     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
T03014                                                                  
T03014     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T03014        NEXT SENTENCE                                             
T03014     ELSE                                                         
T03014        DISPLAY '********** PCSCA177  ABORT **************'       
T03014        DISPLAY '* 7520-SELECT-CMPNT-ID-CD               *'       
T03014        DISPLAY '* CODE_UTIL_TYPE = ' RT-CODE-UTIL-TYPE           
T03014        DISPLAY '* RATE_PLAN_NO   = ' RT-RATE-PLAN-NO             
T03014        DISPLAY '* SQLCODE IS       ', WS-ACTIVE-RETURN-CODE      
T03014        DISPLAY '* PROGRAM ABORTING...                   *'       
T03014        DISPLAY '********** PCSCA177  ABORT **************'       
T03014        PERFORM 9900-ABEND           THRU 9900-EXIT               
T03014     END-IF.                                                      
T03014                                                                  
T03014 7520-EXIT.                                                       
T03014     EXIT.                                                        
                                                                        
I01959****************************************************************          
I01959*                                                              *          
I01959*7530-GET-SOLAR-SYSTEM-SIZE.                                   *          
I01959****************************************************************          
I01959 7530-GET-SOLAR-SYSTEM-SIZE.                                      
I01959                                                                  
I01959     EXEC SQL                                                     
I01959        SELECT TOP(1) INVERTER_SYST_SIZE                                 
I01959          INTO :6B-INVERTER-SYST-SIZE                             
I01959          FROM CSS_PREM_DER_DET WITH(READUNCOMMITTED)                     
I01959         WHERE PREMISE_NO    = :AT-PREMISE-NO                     
I01959           AND DER_STATUS_CD = 'A'                                
I01959         ORDER BY DER_SEQ_NO DESC                                 
I01959                                       
I01959                                                      
I01959     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT INVERTER_SYST_SIZE                                         
MFA-TR*         INTO :6B-INVERTER-SYST-SIZE                                     
MFA-TR*         FROM CSS_PREM_DER_DET                                           
MFA-TR*        WHERE PREMISE_NO    = :AT-PREMISE-NO                             
MFA-TR*          AND DER_STATUS_CD = 'A'                                        
MFA-TR*        ORDER BY DER_SEQ_NO DESC                                         
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*        QUERYNO 7530                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I01959*                                                                         
I01959     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
I01959                                                                  
I01959     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
I01959        NEXT SENTENCE                                             
I01959     ELSE                                                         
I01959        DISPLAY '********** PCSCA177  ABORT **************'       
I01959        DISPLAY '* 7530-GET-SOLAR-SYSTEM-SIZE            *'       
I01959        DISPLAY '* PREMISE NUMBER = ' AT-PREMISE-NO               
I01959        DISPLAY '* SQLCODE IS       ', WS-ACTIVE-RETURN-CODE      
I01959        DISPLAY '* PROGRAM ABORTING...                   *'       
I01959        DISPLAY '********** PCSCA177  ABORT **************'       
I01959        PERFORM 9900-ABEND           THRU 9900-EXIT               
I01959     END-IF.                                                      
I01959                                                                  
I01959 7530-EXIT.                                                       
I01959     EXIT.                                                        
I01959*                                                                         
      ******************************************************************        
      * CPD00038                                                       *        
      * 7600-START-FCSJC01                                             *        
      * 7610-READ-FCSJC01                                              *        
      * 7611-CLOSE                                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
I01959******************************************************************        
I01959*                                                                *        
I01959* 7650-OPEN-CAPACITY-FCTR.                                       *        
I01959******************************************************************        
I01959 7650-OPEN-CAPACITY-FCTR.                                         
I01959                                                                  
I01959     EXEC SQL                                                     
I01959          OPEN CAPACITY_FCTR                                      
I01959     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I01959                                                                  
I01959     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
I01959                                                                  
I01959     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
I01959        NEXT SENTENCE                                             
I01959     ELSE                                                         
I01959        DISPLAY '********** PCSCA177 ABORT  ************'         
I01959        DISPLAY '* 7650-OPEN-CAPACITY-FCTR             *'         
I01959        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
I01959        DISPLAY '* PROGRAM ABORTING...                 *'         
I01959        DISPLAY '********** PCSCA177 ABORT  ************'         
I01959        PERFORM 9900-ABEND            THRU 9900-EXIT              
I01959     END-IF.                                                      
I01959                                                                  
I01959 7650-EXIT.                                                       
I01959     EXIT.                                                        
I01959*                                                                         
I01959******************************************************************        
I01959*                                                                *        
I01959* 7660-FETCH-CAPACITY-FCTR.                                      *        
I01959******************************************************************        
I01959 7660-FETCH-CAPACITY-FCTR.                                        

MSQ008     MOVE 50 TO MSQ008-CAPACITY-FCTR
I01959                                                                  
I01959     EXEC SQL                                                     
I01959          FOR :MSQ008-CAPACITY-FCTR
              FETCH 
              FROM CAPACITY_FCTR                    
I01959                                                       
I01959           INTO :WS-ALTERNATE-FUEL-CD                             
I01959               ,:WS-CAP-FCTR-MONTH                                
I01959               ,:WS-CAP-FCTR-START-DT                             
I01959               ,:WS-CAPACITY-FACTOR                               
I01959               ,:WS-ON-PEAK-ALLOC                                 
I01959               ,:WS-OFF-PEAK-ALLOC                                
I01959     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*         FETCH NEXT ROWSET FROM CAPACITY_FCTR                            
MFA-TR*           FOR 50 ROWS                                                   
MFA-TR*          INTO :WS-ALTERNATE-FUEL-CD                                     
MFA-TR*              ,:WS-CAP-FCTR-MONTH                                        
MFA-TR*              ,:WS-CAP-FCTR-START-DT                                     
MFA-TR*              ,:WS-CAPACITY-FACTOR                                       
MFA-TR*              ,:WS-ON-PEAK-ALLOC                                         
MFA-TR*              ,:WS-OFF-PEAK-ALLOC                                        
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-CAPACITY-FCTR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I01959                                                                  
I01959     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
I01959     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
I01959        IF SQLERRD (3) > 0                                        
I01959           MOVE SQLERRD (3)         TO WS-ORDER-ROW-COUNT         
I01959        ELSE                                                      
I01959           MOVE 0                   TO WS-ORDER-ROW-COUNT         
I01959        END-IF                                                    
I01959        ADD WS-ORDER-ROW-COUNT   TO WS-CF-COUNT                   
I01959     ELSE                                                         
I01959        IF WS-ACTIVE-RETURN-CODE = +354                           
I01959           EXEC SQL                                               
MSQ012              GET DIAGNOSTICS :MFA-GD-ROW-COUNT = ROW_COUNT     
MSQ012                              ,:MFA-GD-NUMBER        = NUMBER       
I01959           END-EXEC                                               

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*          EXEC SQL                                                       
MFA-TR*             GET DIAGNOSTICS :WS-ORDER-ROW-COUNT = ROW_COUNT             
MFA-TR*                             ,:WS-NUM-COND        = NUMBER               
MFA-TR*          END-EXEC                                                       
MSQ012           MOVE MFA-GD-ROW-COUNT TO WS-ORDER-ROW-COUNT
MSQ012           MOVE MFA-GD-NUMBER TO WS-NUM-COND
I01959           DISPLAY '********** PCSCA177 ABORT  ************'      
I01959           DISPLAY '* 7660-FETCH-CAPACITY-FCTR            *'      
I01959           DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
I01959           DISPLAY '* ROWCOUNT ' SQLERRD(3)                       
I01959           DISPLAY '* NUM_COND '  WS-NUM-COND                     
I01959           DISPLAY '* PROGRAM ABORTING...                 *'      
I01959           DISPLAY '********** PCSCA177 ABORT  ************'      
I01959           PERFORM 9900-ABEND THRU 9900-EXIT                      
I01959        ELSE                                                      
I01959           DISPLAY '********** PCSCA177 ABORT  ************'      
I01959           DISPLAY '* 7660-FETCH-CAPACITY-FCTR            *'      
I01959           DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
I01959           DISPLAY '* PROGRAM ABORTING...                 *'      
I01959           DISPLAY '********** PCSCA177 ABORT  ************'      
I01959           PERFORM 9900-ABEND THRU 9900-EXIT                      
I01959        END-IF                                                    
I01959     END-IF.                                                      
I01959                                                                  
I01959 7660-EXIT.                                                       
I01959     EXIT.                                                        
I01959*                                                                         
I01959******************************************************************        
I01959*                                                                *        
I01959* 7670-CLOSE-CAPACITY-FCTR.                                      *        
I01959******************************************************************        
I01959 7670-CLOSE-CAPACITY-FCTR.                                        
I01959                                                                  
I01959     EXEC SQL                                                     
I01959        CLOSE CAPACITY_FCTR                                       
I01959     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I01959                                                                  
I01959     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
I01959                                                                  
I01959     IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
I01959        NEXT SENTENCE                                             
I01959     ELSE                                                         
I01959        DISPLAY '********** PCSCA177 ABORT  ************'         
I01959        DISPLAY '* 7670-CLOSE-CAPACITY-FCTR            *'         
I01959        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
I01959        DISPLAY '* PROGRAM ABORTING...                 *'         
I01959        DISPLAY '********** PCSCA177 ABORT  ************'         
I01959        PERFORM 9900-ABEND            THRU 9900-EXIT              
I01959     END-IF.                                                      
I01959                                                                  
I01959 7670-EXIT.                                                       
I01959     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *      READS FCSBE22 FILE FOR INPUT                              *        
      ******************************************************************        
       7700-READ-INPUT.                                                 
                                                                        
           READ FCSBE22-FILE AT END                                     
               MOVE 'Y' TO WS-END-OF-BE22-SW                            
               GO TO 7700-EXIT.                                         
                                                                        
           IF FCSBE22-SUCCESSFUL                                        
              IF E-FBE22-KEY-BREC NOT EQUAL HIGH-VALUES                 
               OR E-FBE22-KEY-BREC NOT EQUAL LOW-VALUES                 
                 IF DATA-RECORD-FOUND                                   
                    ADD 1 TO WS-FCSBE22-REC-CNTR                        
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSCA177 ABORT **************'        
              DISPLAY '*     READ ERROR : BE22 FILE           *'        
              DISPLAY '* CURRENT PARA   : 7700                *'        
              DISPLAY '* FILE-STATUS    : ' WS-FBE22-STATUS             
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA177 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   0800-LOAD-FBE02-WS-AREA                                      *        
      ******************************************************************        
        COPY CPD00050.                                                          
                                                                        
      ******************************************************************        
      * 8000-WRITE-FCSCREVD                                            *        
      * WRITES OUTPUT FILE - FCSCREVD                                  *        
      ******************************************************************        
       8000-WRITE-FCSCREVD.                                             
                                                                        
           WRITE FCSCREVD.                                              
                                                                        
           IF FCSCREVD-SUCCESSFUL                                       
              ADD 1  TO WS-FREVD-WRITE-COUNT                            
           ELSE                                                         
              DISPLAY '********** PCSCA177 ABORT **************'        
              DISPLAY '*     WRITE ERROR : FCSCREVD-FILE      *'        
              DISPLAY '* CURRENT PARA   : 8000                *'        
              DISPLAY '* FILE-STATUS    : ' WS-FCSCREVD-STATUS          
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA177 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8010-WRITE-FCSCREVC                                            *        
      * WRITES OUTPUT FILE - FCSCREVC                                  *        
      ******************************************************************        
       8010-WRITE-FCSCREVC.                                             
                                                                        
           WRITE FCSCREVC.                                              
           IF FCSCREVC-SUCCESSFUL                                       
              ADD 1  TO WS-FREVC-WRITE-COUNT                            
           ELSE                                                         
              DISPLAY '********** PCSCA177 ABORT **************'        
              DISPLAY '*     WRITE ERROR : FCSCREVC-FILE      *'        
              DISPLAY '* CURRENT PARA   : 8010                *'        
              DISPLAY '* FILE-STATUS    : ' WS-FCSCREVC-STATUS          
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA177 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8020-WRITE-FCSCREVB                                            *        
      * WRITES OUTPUT FILE - FCSCREVB                                  *        
      ******************************************************************        
       8020-WRITE-FCSCREVB.                                             
                                                                        
           WRITE FCSCREVB.                                              
           IF FCSCREVB-SUCCESSFUL                                       
              ADD 1  TO WS-FREVB-WRITE-COUNT                            
           ELSE                                                         
              DISPLAY '********** PCSCA177 ABORT **************'        
              DISPLAY '*     WRITE ERROR : FCSCREVB-FILE      *'        
              DISPLAY '* CURRENT PARA   : 8020                *'        
              DISPLAY '* FILE-STATUS    : ' WS-FCSCREVB-STATUS          
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA177 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8030-WRITE-FCSCREVT                                            *        
      * WRITES OUTPUT FILE - FCSCREVT                                  *        
      ******************************************************************        
       8030-WRITE-FCSCREVT.                                             
                                                                        
           WRITE FCSCREVT.                                              
           IF FCSCREVT-SUCCESSFUL                                       
              ADD 1  TO WS-FREVT-WRITE-COUNT                            
           ELSE                                                         
              DISPLAY '********** PCSCA177 ABORT **************'        
              DISPLAY '*     WRITE ERROR : FCSCREVT-FILE      *'        
              DISPLAY '* CURRENT PARA   : 8030                *'        
              DISPLAY '* FILE-STATUS    : ' WS-FCSCREVT-STATUS          
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA177 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9000-TERMINATE.                                                *        
      ******************************************************************        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSBE22-FILE.                                          
           CLOSE FCSCREVB-FILE.                                         
           CLOSE FCSCREVC-FILE.                                         
           CLOSE FCSCREVD-FILE.                                         
           CLOSE FCSCREVT-FILE.                                         
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9200-SCSCA-ERROR                                               *        
      * ERROR PROCESSING FOR SUBROUTINE                                *        
      ******************************************************************        
       9200-SCSCA-ERROR.                                                
                                                                        
           MOVE 12 TO RETURN-CODE.                                      
           DISPLAY '********** PCSCA177 ABORT **************'           
           DISPLAY '* ERROR CALLING ' WS-DISPLAY-SCSCA.                 
           IF WS-DISPLAY-SCSCA = SCSCA107                               
              DISPLAY '* RETURN CODE = ' WS-CALC-ERROR                  
           ELSE                                                         
              DISPLAY '* RETURN CODE = ' RS-RETURN-CODE                 
           END-IF.                                                      
           DISPLAY '* ACCOUNT NO:   ' WS-DISPLAY-ACCOUNT                
           DISPLAY '*     PROCESSING TERMINATED            *'           
           DISPLAY '********** PCSCA177 ABORT **************'.          
           PERFORM 9900-ABEND THRU 9900-EXIT.                           
                                                                        
       9200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-ABEND                                                     *        
      * COPYBOOK FOR ABEND/ERROR PROCESSING                            *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD09900                                                
           END-EXEC.                                                            
                                                                        
      *                                                                         
