       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA172.                                        
      ***************************************************************** 00003000
      **              SOUTH CAROLINA ELECTRIC & GAS                  ** 00004000
      **               CUSTOMER INFORMATION SYSTEM                   ** 00007000
      **                                                             ** 00008000
      ***************************************************************** 00009000
      **               P R O G R A M  S U M M A R Y                  ** 00010000
      **                                                             ** 00011000
      ** PCSCA172 PULLS EDI ACCOUNTS FROM BE28 FILES.                ** 00012000
      **                                                             ** 00013000
      ***************************************************************** 00014000
      *                                                              ** 00015000
      *              PROGRAM  MODIFICATION  LOG                      ** 00016000
      *                                                              ** 00017000
      *    DATE     INITIALS  REASON                                 ** 00018000
      *    ----     --------  ------                                 ** 00019000
A02774** 09/2010    SV82012   PULL EDI ACCOUNTS                      ** 00705310
      ***************************************************************** 00705400
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
           SELECT FCSCA172-FILE                                         
               ASSIGN UT-S-FCSCA172                                     
               FILE STATUS IS WS-CA172-STATUS.                          
                                                                        
           SELECT FCSBE28-FILE                                          
               ASSIGN UT-S-FCSBE28                                      
               FILE STATUS IS WS-FBE28-STATUS.                          
                                                                        
           SELECT OUTPUT-FILE                                           
               ASSIGN UT-S-OUTPUT                                       
               FILE STATUS IS WS-OTPUT-STATUS.                          
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       FD  FCSCA172-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
       COPY SORTINDX.                                                           
                                                                        
       FD  FCSBE28-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
       01  FIOBE28.                                                     
           02  FIOBE28-DATA-REC.                                        
               05  E-FBE28-SORT-KEY              PIC X(65).             
               05  E-FBE28-DATA                  PIC X(1135).           
                                                                        
       FD  OUTPUT-FILE                                                  
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
       01  OUTPUT-R.                                                    
           02  OUTPUT-REC.                                              
               05  FILLER                        PIC X(1200).           
                                                                        
       WORKING-STORAGE SECTION.                                         
                                                                        
       01  WS-EXT-IO-AREA.                                              
           05  SORT-KEY.                                                
               10  LEVEL-1-SORT-FLDS.                                   
                   15  KEY-L1-COMP-NO              PIC 9(2).            
               10  LEVEL-2-SORT-FLDS.                                   
                   15  KEY-L2-ACCOUNT-NO           PIC X(13).           
                   15  KEY-L2-DATE-BILLED          PIC X(10).           
               10  LEVEL-3-SORT-FLDS.                                   
                   15  KEY-L3-REC-SEQ              PIC X(3).            
                   15  KEY-L3-RECORD-ID            PIC X(10).           
                   15  KEY-L3-TIE-BREAKER          PIC 9(4).            
               10  LEVEL-4-SORT-FLDS.                                   
                   15  KEY-L4-SUB-ACCOUNT          PIC X(13).           
                   15  KEY-L4-SUB-SORT-FIELDS      PIC X(10).           
                   15  FILLER                      REDEFINES            
                       KEY-L4-SUB-SORT-FIELDS.                          
                       20  KEY-L4-SUB-DATE-BILLED  PIC X(06).           
                       20  KEY-L4-TIE-BREAKER      PIC 9(04).           
           05  WS-BILL-DATA                        PIC X(1135).         
                                                                        
       01  WS-MISC.                                                     
           05  WS-FBE28-STATUS              PIC  X(02).                 
               88 FBE28-SUCCESSFUL                      VALUE '00'.     
           05  WS-CA172-STATUS               PIC XX VALUE '  '.         
               88  CA172-SUCCESSFUL                 VALUE '00'.         
           05  WS-OTPUT-STATUS               PIC XX VALUE '  '.         
               88  OTPUT-SUCCESSFUL                 VALUE '00'.         
           05  WS-END-OF-CA172               PIC X VALUE 'N'.           
               88  END-OF-CA172                    VALUE 'Y'.           
           05  WS-END-OF-BE28                PIC X VALUE 'N'.           
               88  END-OF-BE28                     VALUE 'Y'.           
           05  SUB1                          PIC S9(7) COMP-3 VALUE +0. 
           05  WS-REC-COUNT                  PIC S9(7) COMP-3 VALUE +0. 
           05 WS-PREV-ACCT-NO                PIC X(13) VALUE SPACES.    
           05 WS-FOUND-FLAG                  PIC X(01) VALUE 'N'.       
           05 WS-Y                           PIC X(01) VALUE 'Y'.       
           05 WS-ACCOUNT-TABLE.                                         
              10  WS-ACCOUNT           PIC X(13) OCCURS 5000 TIMES.     
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
      ***********************************************************       02405000
      *  PERFORM THE PROCESSING ROUTINE FOR EACH INPUT FILE:    *       02406000
      *  BE26 (REGULAR BILLS),                                  *       02407000
      *  BE32 (CONSOLIDATED BILLS)                              *       02408000
      ***********************************************************       02409000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
                                                                        
           PERFORM 7000-READ-FCSCA172           THRU 7000-EXIT          
                                                UNTIL END-OF-CA172.     
                                                                        
           PERFORM 7100-READ-FCSBE28            THRU 7100-EXIT          
                                                UNTIL END-OF-BE28.      
                                                                        
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************       02537000
      *  OPEN INPUT AND OUTPUT FILES.                           *       02538000
      ***********************************************************       02540000
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           OPEN INPUT FCSCA172-FILE.                                    
           IF NOT CA172-SUCCESSFUL                                      
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR OPENING FCSCA172          **'         
               DISPLAY '**  FILE STATUS = ' WS-CA172-STATUS             
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
                                                                        
           OPEN INPUT FCSBE28-FILE.                                     
           IF NOT FBE28-SUCCESSFUL                                      
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR OPENING FCSBE28           **'         
               DISPLAY '**  FILE STATUS = ' WS-FBE28-STATUS             
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
           OPEN OUTPUT OUTPUT-FILE.                                     
           IF NOT OTPUT-SUCCESSFUL                                      
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR OPENING FCSBE28           **'         
               DISPLAY '**  FILE STATUS = ' WS-OTPUT-STATUS             
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
           INITIALIZE WS-ACCOUNT-TABLE.                                 
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      ************************************************************      03854000
      *  READ THE INPUT FILE                                     *              
      ************************************************************      03856000
                                                                        
       7000-READ-FCSCA172.                                              
                                                                        
           READ FCSCA172-FILE AT END                                    
               MOVE WS-Y TO WS-END-OF-CA172.                            
           IF CA172-SUCCESSFUL                                          
               ADD  +1                          TO SUB1                 
                                                   WS-REC-COUNT         
               IF SUB1 > 5000                                           
                 MOVE 12 TO RETURN-CODE                                 
                 DISPLAY '****************************************'     
                 DISPLAY '**     PCSCA172 PROCESSING ERROR      **'     
                 DISPLAY '**       MORE THAN 5000 ACCOUNTS      **'     
                 DISPLAY '**     PULLED FOR REPRINTS            **'     
                 DISPLAY '****************************************'     
                 PERFORM 9000-TERMINATE THRU 9000-EXIT                  
               ELSE                                                     
                   MOVE EXT-ACCT-ACCOUNT-NO         TO WS-ACCOUNT(SUB1) 
               END-IF                                                   
           ELSE                                                         
               IF END-OF-CA172                                          
                  CONTINUE                                              
               ELSE                                                     
                 MOVE 12 TO RETURN-CODE                                 
                 DISPLAY '****************************************'     
                 DISPLAY '**     PCSCA172 PROCESSING ERROR      **'     
                 DISPLAY '**       ERROR READING FCSCA172       **'     
                 DISPLAY '**     FILE STATUS = ' WS-CA172-STATUS        
                 DISPLAY '****************************************'     
                 PERFORM 9000-TERMINATE THRU 9000-EXIT                  
               END-IF                                                   
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-READ-FCSBE28.                                               
                                                                        
           READ FCSBE28-FILE AT END                                     
               MOVE WS-Y                    TO WS-END-OF-BE28.          
           IF FBE28-SUCCESSFUL OR END-OF-BE28                           
               MOVE FIOBE28                 TO WS-EXT-IO-AREA           
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA172 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR READING FCSBE28        **'       
               DISPLAY '**     FILE STATUS = ' WS-FBE28-STATUS          
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
           IF FBE28-SUCCESSFUL                                          
              MOVE 'N'                      TO WS-FOUND-FLAG            
              PERFORM VARYING SUB1 FROM 1 BY 1 UNTIL                    
                      (SUB1 > WS-REC-COUNT) OR WS-FOUND-FLAG='Y'        
                   IF WS-ACCOUNT(SUB1) = KEY-L2-ACCOUNT-NO              
                      MOVE 'Y'                 TO WS-FOUND-FLAG         
                      PERFORM 8000-WRITE-OUTPUT-FILE THRU 8000-EXIT     
                   END-IF                                               
              END-PERFORM                                               
           END-IF.                                                      
           MOVE KEY-L2-ACCOUNT-NO              TO WS-PREV-ACCT-NO.      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000-WRITE-OUTPUT-FILE.                                          
                                                                        
           MOVE  FIOBE28                       TO   OUTPUT-R.           
           WRITE OUTPUT-R.                                              
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
       9000-TERMINATE.                                                  
                                                                        
                                                                        
           CLOSE FCSCA172-FILE                                          
                 OUTPUT-FILE                                            
                 FCSBE28-FILE.                                          
                                                                        
           STOP RUN.                                                    
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *     9900-ABEND                                                 *        
      *                                                                *        
      ******************************************************************        
       9900-ABEND.                                                      
           DISPLAY 'PERFORMING 9900-ABEND'.                             
           MOVE 12  TO  RETURN-CODE.                                    
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
       9900-EXIT.                                                       
                                                                        
                                                                        
