       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA170.                                        
      ***************************************************************** 00000300
      **               CUSTOMER INFORMATION SYSTEM                   ** 00000700
      **                                                             ** 00000800
      ***************************************************************** 00000900
      **               P R O G R A M  S U M M A R Y                  ** 00001000
      **                                                             ** 00001100
      ** THIS PROGRAM INSERTS A PRINT GENERATED ROW TO THE           ** 00001400
      ** CSS_PRINT_JOB_SCAN TABLE.                                   ** 00001100
      **                                                             ** 00001100
      ** IF RE-RUNNING WITH A DATE OTHER THAN THE COMMON DATE THE    **         
      ** DATE SHOULD BE ADDED TO DATA MEMBER PCSC170A IN THE FORMAT  **         
      ** 'YYYY-MM-DD'.                                               **         
      ***************************************************************** 00002200
      *                                                              ** 00002300
      *              PROGRAM  MODIFICATION  LOG                      ** 00002400
      *                                                              ** 00002500
      *    DATE     INITIALS  REASON                                 ** 00002600
      *    ----     --------  ------                                 ** 00002700
A04723**   06/13    DMS       INITIAL VERSION.                       ** 00016220
ACT231**   11/15    BD09555   TREAT STMT THE SAME AS BILL            ** 00016220
ACT231**  A05136-ACT231                                                 00016220
      ***END*********************************************************** 00016300
      **          ---- BASIC SEQUENCE STRUCTURE ----                 ** 00016400
      **                                                             ** 00016500
      **  0000         MODULE CONTROL                                ** 00016600
      **  0100 - 0999  INITIALIZATION (OPTIONAL)                     ** 00016700
      **  1000 - 1999  FUNCTIONAL CONTROL                            ** 00016800
      **  2000 - 4999  DETAIL LOGIC                                  ** 00016900
      **  5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES            ** 00017000
      **  6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)  ** 00017100
      **  7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.)** 00017200
      **  8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC.)* 00017300
      **                                                             ** 00017400
      ***************************************************************** 00017500
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
      *** INPUT FILE DECLARATION                                        00018100
       COPY CSSCA170.                                                           
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
      *** INPUT FILE  STRUCTURE.                                        00018100
       COPY CFDCA170.                                                           
       01  FIOCA170.                                                    
           05 FIOCA170-DATA                 PIC X(436).                 
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA170'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-FCA170-STATUS             PIC  X(02).                 
               88  FCA170-SUCCESSFUL                   VALUE ZERO.      
           05  WS-FCSCA170-FLAG             PIC  X(01) VALUE 'N'.       
               88  END-OF-FCSCA170                     VALUE 'Y'.       
           05  WS-WRITE-JOB-SW              PIC  X(01) VALUE 'N'.       
               88  WRITE-JOB                           VALUE 'Y'.       
                                                                        
       01  WS-CNTRS.                                                    
           05  WS-ACCOUNTS-READ             PIC 9(07)  VALUE ZERO.      
           05  WS-JOBNMS-INSERTED           PIC 9(07)  VALUE ZERO.      
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-Y                         PIC X(01) VALUE 'Y'.        
           05  WS-N                         PIC X(01) VALUE 'N'.        
           05  WS-I                         PIC X(01) VALUE 'I'.        
           05  WS-PGRMNAME                 PIC X(10) VALUE 'PCSCA170  '.
                                                                        
       01  WS-MISC.                                                     
           05  WS-FORMAT-DATE.                                          
               10  WS-FORMAT-YY             PIC 9(4).                   
               10  FILLER                   PIC X(01) VALUE '-'.        
               10  WS-FORMAT-MM             PIC 9(2).                   
               10  FILLER                   PIC X(01) VALUE '-'.        
               10  WS-FORMAT-DD             PIC 9(2).                   
           05  RS-RETURN-CODE               PIC S9(04) COMP VALUE 0.    
           05  RS-RETURN-CODE-DISP          PIC +Z(04).                 
           05  WS-DELIMITER                 PIC X     VALUE '~'.        
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.          
           05  WS-JOB-NAME              PIC X(7)       VALUE SPACES.    
           05  WS-JOB-DATE              PIC X(10)      VALUE SPACES.    
           05  WS-PREV-JOB-NAME         PIC X(7)       VALUE SPACES.    
           05  WS-VERIFY-DATE           PIC X(10)      VALUE SPACES.    
                                                                        
       01  WS-NOOPS-STRUCTURE.                                          
           05  WS-NOOP-IDX-DATA.                                        
               10  FILLER                   PIC X(2)   VALUE SPACES.    
               10  WS-NOOP-IDX              PIC X(6)   VALUE SPACES.    
                   88  NOOP-AFP                        VALUE 'IDX@@@'.  
           05  FILLER                       PIC X      VALUE '~'.       
           05  WS-NOOP-DATE                 PIC X(10)  VALUE SPACES.    
           05  FILLER                       PIC X      VALUE '~'.       
           05  WS-NOOP-CORRES-TYPE          PIC X(4)   VALUE SPACES.    
               88  NOOP-BILL                           VALUE 'BILL'.    
               88  NOOP-PAPERLESS                      VALUE 'PRLS'.    
               88  NOOP-EXCP                           VALUE 'EXCP'.    
               88  NOOP-CLFN                           VALUE 'CLFN'.    
               88  NOOP-MKTG                           VALUE 'MKTG'.    
           05  FILLER                       PIC X      VALUE '~'.       
           05  WS-NOOP-CUST-NO              PIC X(10)  VALUE SPACES.    
           05  FILLER                       PIC X      VALUE '~'.       
           05  WS-NOOP-ACCT-NO              PIC X(13)  VALUE SPACES.    
           05  FILLER                       PIC X      VALUE '~'.       
           05  WS-NOOP-DATA                 PIC X(391).                 
      *                                                                 00053600
      ****LAYOUT OF BILLS                                               00053600
           05  WS-NOOP-BILL-DATA            REDEFINES  WS-NOOP-DATA.    
               10  WS-NOOP-BILL-NO          PIC 9(9).                   
               10  FILLER                   PIC X.                      
               10  WS-NOOP-BILL-DEST-CD     PIC X.                      
               10  FILLER                   PIC X.                      
               10  WS-NOOP-BILL-PULL-CD     PIC X.                      
               10  FILLER                   PIC X.                      
               10  WS-NOOP-BILL-PAGES       PIC 9(9).                   
               10  FILLER                   PIC X.                      
               10  WS-NOOP-BILL-IMAGE-FL    PIC X.                      
               10  FILLER                   PIC X.                      
               10  WS-NOOP-BILL-COMPANY-NO  PIC X(2).                   
               10  FILLER                   PIC X.                      
               10  WS-NOOP-BILL-TYPE        PIC X(2).                   
               10  FILLER                   PIC X.                      
               10  WS-NOOP-BILL-MAIL-ADDR   PIC X(312).                 
               10  FILLER                   PIC X.                      
               10  WS-NOOP-BILL-POSTNET-BC  PIC X(11).                  
               10  FILLER                   PIC X.                      
               10  WS-NOOP-BILL-BARCODE     PIC X(9).                   
               10  FILLER                   PIC X.                      
               10  WS-NOOP-BILL-UNIQUE-ID   PIC X(9).                   
               10  FILLER                   PIC X.                      
               10  WS-NOOP-BILL-TRACK-ST    PIC X(2).                   
               10  FILLER                   PIC X.                      
               10  WS-NOOP-BILL-EDI-DEST    PIC X.                      
               10  FILLER                   PIC X.                      
               10  WS-NOOP-BILL-NO-COPIES   PIC X.                      
               10  FILLER                   PIC X.                      
               10  WS-NOOP-BILL-JOB         PIC X(7).                   
      *                                                                 00053600
      ****LAYOUT OF NON-MARKETING AND MARKETING LETTERS                 00053600
           05  WS-NOOP-CLFN-DATA            REDEFINES  WS-NOOP-DATA.    
               10  WS-NOOP-CLFN-COMM-TYPE   PIC X(2).                   
               10  FILLER                   PIC X.                      
               10  WS-NOOP-CLFN-COMM-SUB    PIC X(2).                   
               10  FILLER                   PIC X.                      
               10  WS-NOOP-CLFN-GUARANTOR   PIC X(13).                  
               10  FILLER                   PIC X.                      
               10  WS-NOOP-CLFN-PAGES       PIC 9(9).                   
               10  FILLER                   PIC X.                      
               10  WS-NOOP-CLFN-IMAGE-FL    PIC X.                      
               10  FILLER                   PIC X.                      
               10  WS-NOOP-CLFN-COMPANY-NO  PIC X(2).                   
               10  FILLER                   PIC X.                      
               10  WS-NOOP-CLFN-UNIQUE-ID   PIC X(9).                   
               10  FILLER                   PIC X.                      
               10  WS-NOOP-CLFN-TRACK-ST    PIC X(2).                   
               10  FILLER                   PIC X.                      
               10  WS-NOOP-CLFN-JOB         PIC X(7).                   
                                                                        
      ****JOB NAME TABLE                                                        
       01  WS-JOBNM-TBL.                                                
           05  WS-JOB-CNT                  PIC S9(2) COMP-3 VALUE +0.   
           05  WS-JOBNM-TABLE OCCURS 0 TO 99                            
               DEPENDING ON WS-JOB-CNT                                  
               INDEXED BY WS-JOB-IND.                                   
               10  WS-JOB-NM               PIC X(7).                    
               10  WS-JOB-DT               PIC X(10).                   
                                                                        
      *                                                                 00053600
      *********************************************************                 
      *COPYBOOK TO SUPPORT DB2 SQL ERROR CHECKING.            *                 
      *********************************************************                 
       COPY CWS00303.                                                   00055700
                                                                        
      *********************************************************                 
      * COPYBOOK ADDED FOR ERROR HANDLING.                    *                 
      *********************************************************                 
       COPY CWS00010.                                                   02700000
                                                                        
      *********************************************************                 
      *  CWS09900  ABEND SWITCH COPYBOOK                      *                 
      *********************************************************                 
       COPY CWS09900.                                                   02700000
                                                                        
      *********************************************************                 
      *   WS-VARIABLES FOR CPD00038                           *                 
      *********************************************************                 
       COPY CWS00038.                                                           
       COPY FIOJC01.                                                            
                                                                        
      *********************************************************                 
      *   JOBS FILE/TABLE DEFINITIONS                         *                 
      *********************************************************                 
           COPY FIOCA00.                                                        
                                                                        
      *********************************************************                 
      *   CA00 WORK DATA                                      *                 
      *********************************************************                 
       COPY CWS00039.                                                           
                                                                        
           EXEC SQL                                                     00056600
                INCLUDE SQLCA                                           00056700
           END-EXEC.                                                    00056800
                                                                        
      ***********************************************************               
      * DCLGEN TABLE(CSS_PRINT_JOB_SCAN)                        *               
      ***********************************************************               
             EXEC SQL                                                           
                 INCLUDE TBPRTSCN                                               
             END-EXEC.                                                          
                                                                        
      *************************************************************             
      *    CSS_JOB_PARM                                                         
      *************************************************************             
           EXEC SQL                                                             
                INCLUDE TBJBPARM                                                
           END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  WS-PARM-VALUE.                                               
           03  WS-PARMVAL-LENGTH            PIC S9(04) COMP.            
           03  WS-PARM-DATE                 PIC X(10).                  
                                                                        
       PROCEDURE DIVISION USING WS-PARM-VALUE.                          
                                                                        
      ***************************************************************** 00065400
      *    0000-MAINLINE                                             ** 00065500
      ***************************************************************** 00065700
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
                                                                        
           PERFORM 7000-READ-FCSCA170          THRU 7000-EXIT.          
                                                                        
           PERFORM 1000-PROCESS-NOOPS          THRU 1000-EXIT           
             UNTIL END-OF-FCSCA170.                                     
                                                                        
           PERFORM 2600-DISPLAY-ACCT-TOTALS    THRU 2600-EXIT.          
                                                                        
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 00072100
      *    0100-INITIALIZATION                                       ** 00072200
      *    OPEN FILE                                                 ** 00072300
      ***************************************************************** 00072500
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           OPEN INPUT FCSCA170-FILE.                                    
           IF NOT FCA170-SUCCESSFUL                                     
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZE                  '         
               DISPLAY '**   ERROR OPENING FCSCA170'                    
               DISPLAY '**   FILE STATUS = ' WS-FCA170-STATUS           
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
           MOVE SPACES                         TO WS-PREV-JOB-NAME      
                                                  WS-JOB-DATE.          
                                                                        
           PERFORM 6251-GET-FJC01-DATE         THRU 6251-EXIT.          
      *                                                                         
           IF COMMON-DATE-NEEDED                                        
               PERFORM 6240-GET-FCA00-COMMON-DATE                       
                                               THRU 6240-EXIT           
               MOVE WS-FCA00-COMMON-DATE       TO WS-JOB-DATE           
           END-IF.                                                      
                                                                        
      **** DATE PASSED FROM JCL THROUGH PARM TO OVERRIDE 'COMMONDATE'           
           IF WS-PARM-DATE NOT = 'YYYY-MM-DD'                           
              PERFORM 7500-VERIFY-PARM-DATE-IS-VALID THRU 7500-EXIT     
              MOVE WS-PARM-DATE TO WS-JOB-DATE                          
           END-IF.                                                      
      *                                                                         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 00128700
      *    1000-PROCESS-NOOPS.                                       ** 00128300
      * THIS WILL LOAD THE NOOPS RECORDS AND GET THE JOB NAME        ** 00128400
      ***************************************************************** 00128700
                                                                        
       1000-PROCESS-NOOPS.                                              
                                                                        
           PERFORM 2000-DETAIL-PROCESSING      THRU 2000-EXIT.          
                                                                        
           MOVE WS-NOOP-ACCT-NO                TO WS-ACCOUNT-NO.        
                                                                        
           IF WS-JOB-NAME > SPACES                                      
           AND WS-PREV-JOB-NAME NOT = WS-JOB-NAME                       
              PERFORM 3000-PROCESS-JOB-NAME    THRU 3000-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM 7000-READ-FCSCA170          THRU 7000-EXIT.          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 00128700
      *    2000-DETAIL-PROCESSING.                                   ** 00128300
      * GET THE DETAILS FROM THE NOOPS RECORDS                       ** 00128400
      ***************************************************************** 00128700
                                                                        
       2000-DETAIL-PROCESSING.                                          
                                                                        
           INITIALIZE                       WS-NOOPS-STRUCTURE.         
                                                                        
           UNSTRING            FIOCA170-DATA                            
           DELIMITED BY        WS-DELIMITER                             
           INTO                WS-NOOP-IDX-DATA                         
                               WS-NOOP-DATE                             
                               WS-NOOP-CORRES-TYPE                      
                               WS-NOOP-CUST-NO                          
                               WS-NOOP-ACCT-NO.                         
                                                                        
           EVALUATE WS-NOOP-CORRES-TYPE                                 
               WHEN 'BILL'                                              
ACT231         WHEN 'STMT'                                              
                    PERFORM 2100-PROCESS-BILL-DATA      THRU 2100-EXIT  
               WHEN 'CLFN'                                              
               WHEN 'MKTG'                                              
                    PERFORM 2200-PROCESS-CLFN-DATA      THRU 2200-EXIT  
               WHEN 'PRLS'                                              
               WHEN 'EXCP'                                              
                    CONTINUE                                            
               WHEN OTHER                                               
                    MOVE 12                             TO RETURN-CODE  
                    DISPLAY '****************************************'  
                    DISPLAY '**     PCSCA170 PROCESSING ERROR      **'  
                    DISPLAY '**       INVALID RECORD FOUND.        **'  
                    DISPLAY '**  LAST ACCOUNT PROCESSED ', WS-ACCOUNT-NO
                    DISPLAY '****************************************'  
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
           END-EVALUATE.                                                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 00128700
      *    2100-PROCESS-BILL-DATA.                                   ** 00128300
      * DELIMIT BILL AFP DATA AND GET THE JOB NAME.                  ** 00128400
      ***************************************************************** 00128700
                                                                        
       2100-PROCESS-BILL-DATA.                                          
                                                                        
           INITIALIZE                       WS-NOOPS-STRUCTURE          
                                            WS-JOB-NAME.                
                                                                        
           UNSTRING FIOCA170-DATA DELIMITED BY                          
                               WS-DELIMITER INTO                        
                                            WS-NOOP-IDX-DATA            
                                            WS-NOOP-DATE                
                                            WS-NOOP-CORRES-TYPE         
                                            WS-NOOP-CUST-NO             
                                            WS-NOOP-ACCT-NO             
                                            WS-NOOP-BILL-NO             
                                            WS-NOOP-BILL-DEST-CD        
                                            WS-NOOP-BILL-PULL-CD        
                                            WS-NOOP-BILL-PAGES          
                                            WS-NOOP-BILL-IMAGE-FL       
                                            WS-NOOP-BILL-COMPANY-NO     
                                            WS-NOOP-BILL-TYPE           
                                            WS-NOOP-BILL-MAIL-ADDR      
                                            WS-NOOP-BILL-POSTNET-BC     
                                            WS-NOOP-BILL-BARCODE        
                                            WS-NOOP-BILL-UNIQUE-ID      
                                            WS-NOOP-BILL-TRACK-ST       
                                            WS-NOOP-BILL-EDI-DEST       
                                            WS-NOOP-BILL-NO-COPIES      
                                            WS-NOOP-BILL-JOB.           
                                                                        
           MOVE WS-NOOP-BILL-JOB TO WS-JOB-NAME.                        
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 00128700
      *    2200-PROCESS-CLFN-DATA.                                   ** 00128300
      * DELIMIT INPUT DATA AND GET THE JOB NAME.                     ** 00128400
      ***************************************************************** 00128700
                                                                        
       2200-PROCESS-CLFN-DATA.                                          
                                                                        
           INITIALIZE                       WS-NOOPS-STRUCTURE          
                                            WS-JOB-NAME.                
                                                                        
           UNSTRING FIOCA170-DATA DELIMITED BY                          
                               WS-DELIMITER INTO                        
                                            WS-NOOP-IDX-DATA            
                                            WS-NOOP-DATE                
                                            WS-NOOP-CORRES-TYPE         
                                            WS-NOOP-CUST-NO             
                                            WS-NOOP-ACCT-NO             
                                            WS-NOOP-CLFN-COMM-TYPE      
                                            WS-NOOP-CLFN-COMM-SUB       
                                            WS-NOOP-CLFN-GUARANTOR      
                                            WS-NOOP-CLFN-PAGES          
                                            WS-NOOP-CLFN-IMAGE-FL       
                                            WS-NOOP-CLFN-COMPANY-NO     
                                            WS-NOOP-CLFN-UNIQUE-ID      
                                            WS-NOOP-CLFN-TRACK-ST       
                                            WS-NOOP-CLFN-JOB.           
                                                                        
           MOVE WS-NOOP-CLFN-JOB TO WS-JOB-NAME.                        
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2600-DISPLAY-ACCT-TOTALS.                                        
                                                                        
           DISPLAY '*******************************************'.       
           DISPLAY '*****     PCSCA170 TOTALS            ******'.       
           DISPLAY '*******************************************'.       
           DISPLAY '*****BILLED DATE:        ', WS-JOB-DATE             
           DISPLAY '*****ACCOUNTS READ:      ', WS-ACCOUNTS-READ        
           DISPLAY '*****JOB NAMES INSERTED: ', WS-JOBNMS-INSERTED      
           DISPLAY '*******************************************'.       
           DISPLAY '*******************************************'.       
      *                                                                         
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 00128700
      *    3000-PROCESS-JOB-NAME                                     ** 00128300
      * SEARCH TABLE FOR THE JOB NAME AND ADD IF NOT ALREADY THERE.  ** 00128400
      ***************************************************************** 00128700
                                                                        
       3000-PROCESS-JOB-NAME.                                           
                                                                        
           MOVE WS-JOB-NAME TO WS-PREV-JOB-NAME.                        
           SET WS-JOB-IND TO 1.                                         
      **IF THE JOB IS GRP4 SKIP INSERTING IF CREG IS IN THE TABLE               
           IF WS-JOB-NAME(4:4) = 'GRP4'                                 
              SEARCH WS-JOBNM-TABLE VARYING WS-JOB-IND                  
                AT END                                                  
                   ADD 1            TO WS-JOB-CNT                       
                   SET WRITE-JOB TO TRUE                                
                   MOVE WS-JOB-NAME TO WS-JOB-NM(WS-JOB-CNT)            
                   MOVE WS-JOB-DATE TO WS-JOB-DT(WS-JOB-CNT)            
              WHEN WS-JOB-NM(WS-JOB-IND)(4:4) = 'CREG' OR               
                   WS-JOB-NM(WS-JOB-IND) = WS-JOB-NAME                  
                   MOVE SPACES TO WS-WRITE-JOB-SW                       
              END-SEARCH                                                
           ELSE                                                         
             SEARCH WS-JOBNM-TABLE VARYING WS-JOB-IND                   
               AT END                                                   
                  ADD 1            TO WS-JOB-CNT                        
                  SET WRITE-JOB TO TRUE                                 
                  MOVE WS-JOB-NAME TO WS-JOB-NM(WS-JOB-CNT)             
                  MOVE WS-JOB-DATE TO WS-JOB-DT(WS-JOB-CNT)             
             WHEN WS-JOB-NM(WS-JOB-IND) = WS-JOB-NAME                   
                  MOVE SPACES TO WS-WRITE-JOB-SW                        
             END-SEARCH                                                 
           END-IF.                                                      
                                                                        
           IF WRITE-JOB                                                 
             PERFORM 8300-INSERT-JOB   THRU 8300-EXIT                   
           END-IF.                                                      
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 6251-GET-FJC01-DATE                                           *         
      *****************************************************************         
        COPY CPD00037.                                                          
                                                                        
      *****************************************************************         
      * 6240-GET-FCA00-COMMON-DATE                                    *         
      *****************************************************************         
        COPY CPD00040.                                                          
                                                                        
           EXEC SQL                                                             
             INCLUDE CPD00038                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
             INCLUDE CPD00039                                                   
           END-EXEC.                                                            
                                                                        
      ****************************************************************  00122600
      ** 7000-READ-FCSCA170.                                        **  00122700
      ** READ THE INPUT FILE FCSCA170.                              **  00122800
      ****************************************************************  00123100
       7000-READ-FCSCA170.                                              
                                                                        
           READ FCSCA170-FILE                                           
               AT END                                                   
                  MOVE WS-Y                    TO WS-FCSCA170-FLAG.     
           IF FCA170-SUCCESSFUL                                         
              ADD  +1                       TO WS-ACCOUNTS-READ         
           ELSE                                                         
              IF END-OF-FCSCA170                                        
                 CONTINUE                                               
              ELSE                                                      
                 DISPLAY '7000-ERROR ON FCSCA170 READ'                  
                 DISPLAY 'PROCESSING TERMINATED'                        
                 PERFORM 9900-ABEND               THRU 9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      **************************************************************            
      *    VERIFY THE WS-PARM-DATE IS VALID                        *            
      **************************************************************            
      *                                                                         
       7500-VERIFY-PARM-DATE-IS-VALID.                                  
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, :WS-PARM-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PARM-DATE
              ) <> 0) OR (LEN(:WS-PARM-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-PARM-DATE
              ), CONVERT(DATE, :WS-PARM-DATE) ) )
            INTO
              :WS-VERIFY-DATE                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-VERIFY-DATE =                                             
MFA-TR*           DATE(:WS-PARM-DATE) - 1 DAYS                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
                 DISPLAY ' '                                            
                 DISPLAY '*************************************'        
                 DISPLAY '** ' WS-PGRMNAME '                 **'        
                 DISPLAY '** 7500-VERIFY-PARM-DATE-IS-VALID  **'        
                 DISPLAY '**  INVALID WS-PARM-DATE           **'        
                 DISPLAY '**  DATE MUST BE VALID             **'        
                 DISPLAY '**  FORMAT YYYY-MM-DD              **'        
                 DISPLAY '**  PROCESSING TERMINATED          **'        
                 DISPLAY '*************************************'        
                 DISPLAY ' '                                            
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 1100-WRITE-OUTPUT.                                            *         
      * WRITE DATA IN HOLD JOB TABLE TO OUTPUT FILE                   *         
      *****************************************************************         
                                                                        
       8300-INSERT-JOB.                                                 
                                                                        
           DISPLAY WS-NOOP-CORRES-TYPE':'WS-NOOP-ACCT-NO':'WS-JOB-NAME  
           MOVE WS-JOB-NAME TO UD-PRINT-JOB-NM.                         
           MOVE 1           TO UD-PRINT-SEQ-NUM.                        
           MOVE WS-JOB-DATE TO UD-BILLED-DT.                            
           MOVE 'PRTGEN'    TO UD-PRINT-JOB-STATUS.                     
           MOVE 'SYSTEM'    TO UD-SCAN-USER-ID.                         
           MOVE ZEROS       TO UD-SCAN-COMMENTS-LEN.                    
           MOVE SPACES      TO UD-SCAN-COMMENTS-TEXT.                   
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_PRINT_JOB_SCAN                           
                     (PRINT_JOB_NM,                                     
                      PRINT_SEQ_NUM,                                    
                      BILLED_DT,                                        
                      PRINT_JOB_STATUS,                                 
                      SCAN_USER_ID,                                     
                      SCAN_COMMENTS,                                    
                      SCAN_TS,                                          
                      LAST_UPDATE_TS)                                   
               VALUES                                                   
                     (:UD-PRINT-JOB-NM,                                 
                      :UD-PRINT-SEQ-NUM,                                
                      IIF(TRY_CONVERT(DATE, :UD-BILLED-DT
              ) IS NULL OR (PATINDEX('%.%', :UD-BILLED-DT
              ) <> 0) OR (LEN(:UD-BILLED-DT) <> 10), CIS.CHAR2DATE(
                                                          :UD-BILLED-DT
              ), CONVERT(DATE, :UD-BILLED-DT) ),                               
                      :UD-PRINT-JOB-STATUS,                             
                      :UD-SCAN-USER-ID,                                 
                      :UD-SCAN-COMMENTS,                                
                       CIS.CURRENT$TIMESTAMP(),                               
                       CIS.CURRENT$TIMESTAMP())                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_PRINT_JOB_SCAN                                   
MFA-TR*              (PRINT_JOB_NM,                                             
MFA-TR*               PRINT_SEQ_NUM,                                            
MFA-TR*               BILLED_DT,                                                
MFA-TR*               PRINT_JOB_STATUS,                                         
MFA-TR*               SCAN_USER_ID,                                             
MFA-TR*               SCAN_COMMENTS,                                            
MFA-TR*               SCAN_TS,                                                  
MFA-TR*               LAST_UPDATE_TS)                                           
MFA-TR*        VALUES                                                           
MFA-TR*              (:UD-PRINT-JOB-NM,                                         
MFA-TR*               :UD-PRINT-SEQ-NUM,                                        
MFA-TR*               :UD-BILLED-DT,                                            
MFA-TR*               :UD-PRINT-JOB-STATUS,                                     
MFA-TR*               :UD-SCAN-USER-ID,                                         
MFA-TR*               :UD-SCAN-COMMENTS,                                        
MFA-TR*                CURRENT TIMESTAMP,                                       
MFA-TR*                CURRENT TIMESTAMP)                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF NOT (WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL          
                                            OR ALREADY-EXISTS)          
              DISPLAY '**   ERROR ON 8300-INSERT-JOB       **'          
              DISPLAY '**   INSERT INTO CSS_PRINT_JOB_SCAN **'          
              DISPLAY '**   RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**       PROCESSING TERMINATED      **'          
              MOVE 12               TO RETURN-CODE                      
              PERFORM 9900-ABEND    THRU 9900-EXIT                      
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD +1 TO WS-JOBNMS-INSERTED                              
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************00300400
      *     9000-TERMINATE                                             *00300500
      *     CLOSE FILES. IF WORK QUEUE CREATED SET THE RETURN CODE TO 1*00300600
      ******************************************************************00300700
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSCA170-FILE.                                         
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      *************************                                         13900000
      *  9700-PROCESS-ABEND  **                                         13920000
      *************************                                         13940000
      *                                                                 13950000
       COPY CPD0023B.                                                   13960000
      *                                                                 13970000
      ******************************************************************        
      *     9900-ABEND                                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     19620000
              INCLUDE CPD09900                                          19630000
           END-EXEC.                                                    19640000
      *                                                                         
