       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA168.                                        
      ***************************************************************** 00003000
      **              SOUTH CAROLINA ELECTRIC & GAS                  ** 00004000
      **                     PRICE WATERHOUSE                        ** 00005000
      **                                                             ** 00006000
      **               CUSTOMER INFORMATION SYSTEM                   ** 00007000
      **                                                             ** 00008000
      ***************************************************************** 00009000
      **               P R O G R A M  S U M M A R Y                  ** 00010000
      **                                                             ** 00011000
      ** PULL ACCOUNTS FOR REPRINT - SEB MARKETING LETTER & NOTICES  ** 00012000
      **                                                             ** 00013000
      ***************************************************************** 00014000
      *                                                              ** 00015000
      *              PROGRAM  MODIFICATION  LOG                      ** 00016000
      *                                                              ** 00017000
      *    DATE     INITIALS  REASON                                 ** 00018000
      *    ----     --------  ------                                 ** 00019000
PRJ166** 01/2010    SV        PULL ACCOUNTS FOR REPRINT FOR SEB      ** 00705310
PRJ166**                      MARKETING - INITIAL VERSION.           **         
      ***************************************************************** 00705400
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       COPY CSSCA118.                                                           
       COPY CSSCA901.                                                           
                                                                        
           SELECT FCSCA168-FILE                                         
               ASSIGN UT-S-OUTPUT                                       
               FILE STATUS IS WS-FCA168-STATUS.                         
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       COPY CFDCA118.                                                           
       COPY FIOCA118.                                                           
                                                                        
       COPY CFDCA901.                                                           
       COPY FIOCA901.                                                           
                                                                        
       FD  FCSCA168-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
       01  FCSCA168-R.                                                  
           02  FCSCA168-REC.                                            
               05  FILLER                        PIC X(3500).           
                                                                        
       WORKING-STORAGE SECTION.                                         
                                                                        
       01  WS-MISC.                                                     
           05  WS-FCA901-STATUS             PIC  X(02).                 
               88 FCA901-SUCCESSFUL                     VALUE '00'.     
           05  WS-FCA118-STATUS               PIC XX VALUE '  '.        
               88  CA118-SUCCESSFUL                 VALUE '00'.         
           05  WS-FCA168-STATUS              PIC XX VALUE '  '.         
               88  FCA168-SUCCESSFUL                VALUE '00'.         
           05  WS-END-OF-CA118               PIC X VALUE 'N'.           
               88  END-OF-CA118                    VALUE 'Y'.           
           05  WS-END-OF-CA901               PIC X VALUE 'N'.           
               88  END-OF-CA901                    VALUE 'Y'.           
           05  SUB1                          PIC S9(7) COMP-3 VALUE +0. 
           05 WS-REC-COUNT                   PIC S9(7) COMP-3 VALUE +0. 
           05 WS-PREV-ACCT-NO                PIC X(13) VALUE SPACES.    
           05 WS-FOUND-FLAG                  PIC X(01) VALUE 'N'.       
           05 WS-Y                           PIC X(01) VALUE 'Y'.       
           05 WS-UNIQUE-ID-TABLE.                                       
              10  WS-UNIQUE-ID         PIC X(09) OCCURS 5000 TIMES.     
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
      **************************************************************    02405000
      *  PERFORM THE PROCESSING ROUTINE FOR EACH INPUT FILE:       *    02406000
      *  CA118 - FILE WITH TRACKING_STATUS_CD PM & DM FROM PCSCA118*    02407000
      *  CA901 - ZERO VERSION OF FCSCA901 FILE.                    *    02408000
      **************************************************************    02409000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION          THRU 0100-EXIT.         
                                                                        
           PERFORM 7000-READ-FCSCA118           THRU 7000-EXIT          
                                                UNTIL END-OF-CA118.     
                                                                        
           PERFORM 7100-READ-FCSCA901           THRU 7100-EXIT          
                                                UNTIL END-OF-CA901.     
                                                                        
           PERFORM 9000-TERMINATE               THRU 9000-EXIT.         
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************       02537000
      *  OPEN INPUT AND OUTPUT FILES.                           *       02538000
      ***********************************************************       02540000
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           OPEN INPUT FCSCA118-FILE.                                    
           IF NOT CA118-SUCCESSFUL                                      
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR OPENING FCSCA118          **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA118-STATUS            
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
           OPEN INPUT FCSCA901-FILE.                                    
           IF NOT FCA901-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR OPENING FCSCA901           **'        
               DISPLAY '**  FILE STATUS = ' WS-FCA901-STATUS            
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
           OPEN OUTPUT FCSCA168-FILE.                                   
           IF NOT FCA168-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR OPENING FCSCA901           **'        
               DISPLAY '**  FILE STATUS = ' WS-FCA168-STATUS            
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
           INITIALIZE WS-UNIQUE-ID-TABLE.                               
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      03854000
      *  READ THE INPUT FILE                                     *              
      ************************************************************      03856000
                                                                        
       7000-READ-FCSCA118.                                              
                                                                        
           READ FCSCA118-FILE AT END                                    
               MOVE WS-Y TO WS-END-OF-CA118.                            
                                                                        
           IF CA118-SUCCESSFUL                                          
               ADD  +1                          TO SUB1                 
                                                   WS-REC-COUNT         
               IF SUB1 > 5000                                           
                 MOVE 12 TO RETURN-CODE                                 
                 DISPLAY '****************************************'     
                 DISPLAY '**     PCSCA168 PROCESSING ERROR      **'     
                 DISPLAY '**       MORE THAN 5000 ACCOUNTS      **'     
                 DISPLAY '**     PULLED FOR REPRINTS            **'     
                 DISPLAY '****************************************'     
                 PERFORM 9000-TERMINATE THRU 9000-EXIT                  
               ELSE                                                     
                   MOVE E-CA118-BARCODE-UNIQUE-ID TO WS-UNIQUE-ID(SUB1) 
               END-IF                                                   
           ELSE                                                         
               IF END-OF-CA118                                          
                  CONTINUE                                              
               ELSE                                                     
                 MOVE 12 TO RETURN-CODE                                 
                 DISPLAY '****************************************'     
                 DISPLAY '**     PCSCA168 PROCESSING ERROR      **'     
                 DISPLAY '**       ERROR READING FCSCA118       **'     
                 DISPLAY '**     FILE STATUS = ' WS-FCA118-STATUS       
                 DISPLAY '****************************************'     
                 PERFORM 9000-TERMINATE THRU 9000-EXIT                  
               END-IF                                                   
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-READ-FCSCA901.                                              
                                                                        
           READ FCSCA901-FILE AT END                                    
               MOVE WS-Y TO WS-END-OF-CA901.                            
                                                                        
           IF FCA901-SUCCESSFUL OR END-OF-CA901                         
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP910 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR READING FCSCA901        **'      
               DISPLAY '**     FILE STATUS = ' WS-FCA901-STATUS         
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
           IF FCA901-SUCCESSFUL                                         
              MOVE 'N'                      TO WS-FOUND-FLAG            
              PERFORM VARYING SUB1 FROM 1 BY 1 UNTIL                    
                      (SUB1 > WS-REC-COUNT) OR WS-FOUND-FLAG='Y'        
                   IF WS-UNIQUE-ID(SUB1) = EXT-MKTG-BARCODE-UNIQUE-ID   
                      MOVE 'Y'                 TO WS-FOUND-FLAG         
                      PERFORM 8000-WRITE-FCSCA168-FILE THRU 8000-EXIT   
                   END-IF                                               
              END-PERFORM                                               
           END-IF.                                                      
                                                                        
           MOVE EXT-MKTG-ACCOUNT-NO TO WS-PREV-ACCT-NO.                 
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000-WRITE-FCSCA168-FILE.                                        
                                                                        
           MOVE  FIOCA901     TO   FCSCA168-R.                          
           WRITE FCSCA168-R.                                            
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       9000-TERMINATE.                                                  
                                                                        
                                                                        
           CLOSE FCSCA118-FILE                                          
                 FCSCA168-FILE                                          
                 FCSCA901-FILE.                                         
                                                                        
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *     9900-ABEND                                                 *        
      *                                                                *        
      ******************************************************************        
       9900-ABEND.                                                      
           DISPLAY 'PERFORMING 9900-ABEND'.                             
           MOVE 12  TO  RETURN-CODE.                                    
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           STOP RUN.                                                    
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
