       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA167.                                        
      ***************************************************************** 00000300
      **               CUSTOMER INFORMATION SYSTEM                   ** 00000700
      **                                                             ** 00000800
      ***************************************************************** 00000900
      **               P R O G R A M  S U M M A R Y                  ** 00001000
      **                                                             ** 00001100
      ** THIS PROGRAM UPDATES CSS_CORR_MAIL_STAT STATUS AFTER THE    ** 00001400
      ** PRINTS ARE GENERATED BASED ON THE EXISTING STATUS AND THE   ** 00001100
      ** EXCEPTION CODES.                                            ** 00001100
      **                                                             ** 00001100
      ***************************************************************** 00002200
      *                                                              ** 00002300
      *              PROGRAM  MODIFICATION  LOG                      ** 00002400
      *                                                              ** 00002500
      *    DATE     INITIALS  REASON                                 ** 00002600
      *    ----     --------  ------                                 ** 00002700
PRJ166**   09/09    RAJ       INITIAL VERSION.                       ** 00016220
A02119**   03/10    SV        RECONCILE SUBS WHEN MASTER IS PAPERLESS**         
A02283**   04/10    SV        IDENTIFY BILLED EXCEPTION CIG/SECURED  **         
A02283**                      ACCOUNTS IN OM UN-RECONCILED REPORTS   **         
P00533**   03/12    DMS       IDENTIFY JOB NAME FROM NOOPS RECORD    **         
P00533**   04/12    DMS       USE COMMON DATE FOR JOB DATE           **         
P0533A**   03/13    DMS       INSERT JOB NAME TO CSS_PRINT_JOB_SCAN  **         
A04723**   06/13    DMS       MOVED CODE TO INSERT PRTGEN ROW TO NEW **         
A04723**                      PROGRAM PCSCA170                       **         
ACT231**   06/13    BD09555   TREAT TYPE STMT THE SAME AS TYPE BILL  **         
ACT231**A05136-ACT231                                                **         
      ***END*********************************************************** 00016300
      **          ---- BASIC SEQUENCE STRUCTURE ----                 ** 00016400
      **                                                             ** 00016500
      **  0000         MODULE CONTROL                                ** 00016600
      **  0100 - 0999  INITIALIZATION (OPTIONAL)                     ** 00016700
      **  1000 - 1999  FUNCTIONAL CONTROL                            ** 00016800
      **  2000 - 4999  DETAIL LOGIC                                  ** 00016900
      **  5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES            ** 00017000
      **  6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)  ** 00017100
      **  7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.)** 00017200
      **  8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC.)* 00017300
      **                                                             ** 00017400
      ***************************************************************** 00017500
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
      *** INPUT FILE DECLARATION                                        00018100
       COPY CSSCA167.                                                           
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
      *** INPUT FILE  STRUCTURE.                                        00018100
       COPY CFDCA167.                                                           
       01  FIOCA167.                                                    
P00533     05 FIOCA167-DATA                 PIC X(436).                 
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ012      EXEC SQL INCLUDE MFADIAG END-EXEC
MSQ008  01 MSQ008-MSTSUB  PIC S9(9) COMP-5.
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA167'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-FCA167-STATUS             PIC  X(02).                 
               88  FCA167-SUCCESSFUL                   VALUE ZERO.      
           05  WS-FCSCA167-FLAG             PIC  X(01) VALUE 'N'.       
               88  END-OF-FCSCA167                     VALUE 'Y'.       
           05  WS-COMMIT-REQ-SW             PIC X(1)   VALUE 'Y'.       
               88 WS-COMMITS-REQUIRE                   VALUE 'Y'.       
               88 WS-COMMITS-NOT-REQUIRE               VALUE 'N'.       
                                                                        
       01  WS-CNTRS.                                                    
           05  WS-ACCOUNTS-READ             PIC 9(07)  VALUE ZERO.      
           05  WS-ACCTS-UPDATED             PIC 9(07)  VALUE ZERO.      
A02119     05  WS-SUBS-UPDATED              PIC 9(07)  VALUE ZERO.      
           05  WS-COMMIT-ACCTS-CNT          PIC 9(07)  VALUE ZERO.      
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-Y                         PIC X(01) VALUE 'Y'.        
           05  WS-N                         PIC X(01) VALUE 'N'.        
           05  WS-I                         PIC X(01) VALUE 'I'.        
           05  WS-PGRMNAME                 PIC X(10) VALUE 'PCSCA167  '.
                                                                        
       01  WS-MISC.                                                     
           05  WS-FORMAT-DATE.                                          
               10  WS-FORMAT-YY             PIC 9(4).                   
               10  FILLER                   PIC X(01) VALUE '-'.        
               10  WS-FORMAT-MM             PIC 9(2).                   
               10  FILLER                   PIC X(01) VALUE '-'.        
               10  WS-FORMAT-DD             PIC 9(2).                   
           05  WS-TRACKING-STATUS-CODE.                                 
               10  WS-TRACKING-STATUS-C1    PIC X(01) VALUE SPACES.     
               10  WS-TRACKING-STATUS-C2    PIC X(01) VALUE SPACES.     
           05  WS-CHKP-LUW-LIMIT            PIC 9(04).                  
           05  WS-CHKP-UPD-LIMIT            PIC 9(04).                  
           05  WS-DEFAULT-CHKP-LUW-LIMIT    PIC 9(04) VALUE 1000.       
           05  WS-DEFAULT-CHKP-UPD-LIMIT    PIC 9(04) VALUE 1000.       
           05  WS-FLAG-TO-TURN-OFF-COMMITS  PIC 9(04) VALUE 9999.       
           05  WS-CHKP-SEQ-NO               PIC 9(05) VALUE ZERO.       
           05  WS-RESTART-DATA-LENGTH       PIC S9(04) COMP VALUE +34.  
           05  WS-DEFAULT-RESTART-REQ       PIC X(01) VALUE 'N'.        
           05  WS-RESTART-REQ               PIC X(01).                  
           05  WS-COUNT-UNSUCCESSFUL-ROWS   PIC S9(04)                  
                                                VALUE ZEROES COMP.      
           05  WS-IS-THIS-A-RESTART         PIC X(01) VALUE 'N'.        
               88 WS-THIS-IS-A-RESTART                VALUE 'Y'.        
           05  RS-RETURN-CODE               PIC S9(04) COMP VALUE 0.    
           05  RS-RETURN-CODE-DISP          PIC +Z(04).                 
           05  WS-NOOP-UNIQUE-ID            PIC X(09) VALUE SPACES.     
           05  WS-EXCEPTION-CODE            PIC X(02) VALUE SPACES.     
           05  WS-DELIMITER                 PIC X     VALUE '~'.        
           05  WS-CTRL-PARM-STR.                                        
               10  FILLER                   PIC X(08).                  
               10  WS-CONTROL-FLAG          PIC X(01).                  
A02119     05  WS-TRACK-MS-STATUS-CODE.                                 
A02119         10  WS-TRACK-MS-STATUS-C1    PIC X(01) VALUE SPACES.     
A02119         10  WS-TRACK-MS-STATUS-C2    PIC X(01) VALUE SPACES.     
A02119     05  WS-MISC-IDX                  PIC 9(09) COMP-3 VALUE 0.   
A02119     05  WS-SUB-ROW-COUNT            PIC S9(9) USAGE COMP VALUE 0.
A02119     05  WS-SUB-FOUND-FLAG            PIC  X(01) VALUE 'N'.       
A02119         88  SUB-FOUND                           VALUE 'Y'.       
A02119     05  WS-CURSOR-STATUS         PIC X(01)      VALUE SPACE.     
A02119         88 WS-C1-EOC                            VALUE 'Y'.       
                                                                        
A02119*********************************************************         00053200
A02119*   TABLE TO HOLD SUBS FOR THE CURRENT MASTER PROCESSING*         00053200
A02119*********************************************************         00053200
A02119 01 WS-SUB-COUNT                     PIC S9(5) COMP-3 VALUE +0.   
A02119 01 WS-SUB-ACCTS-HOLD-TABLE.                                      
A02119     05  WS-SUB-ACCTS-TBL  OCCURS 999999.                         
COB305         10 WS-SUB-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.         
      *                                                                 00053600
A02119 01 WS-HOLD-MST-SUB-HV.                                           
COB305    05 WS-SUB-ACCOUNT-HV        PIC S9(13)V USAGE COMP-3 
COB305       OCCURS 100 TIMES VALUE 0.   
       01  WS-RESTART-DATA.                                             
           05 WS-RESTART-PROCESS-TYPE       PIC 9(01).                  
           05 WS-RESTART-JOB-COMPLETE       REDEFINES                   
              WS-RESTART-PROCESS-TYPE       PIC X(01).                  
           05 WS-RESTART-JOB-STATUS         PIC X(01).                  
              88  WS-RUN-COMPLETED-NO-PROBLEMS       VALUE 'A'.         
              88  WS-RERUN-COMPLETED                 VALUE 'B'.         
              88  WS-RERUN-PENDING                   VALUE 'C'.         
           05 WS-RESTART-COMMON-DATE        PIC X(10).                  
           05 WS-RESTART-CHKP-SEQ-NO        PIC 9(05).                  
           05 WS-RESTART-ACCOUNT-NO         PIC X(13).                  
           05 WS-RESTART-FCSCA167-REC-CNTR  PIC S9(07) COMP-3 VALUE 0.  
      *                                                                 00053600
       01  WS-NOOPS-STRUCTURE.                                          
           05  WS-NOOP-IDX-DATA.                                        
               10  FILLER                   PIC X(2)   VALUE SPACES.    
               10  WS-NOOP-IDX              PIC X(6)   VALUE SPACES.    
                   88  NOOP-AFP                        VALUE 'IDX@@@'.  
           05  FILLER                       PIC X      VALUE '~'.       
           05  WS-NOOP-DATE                 PIC X(10)  VALUE SPACES.    
           05  FILLER                       PIC X      VALUE '~'.       
           05  WS-NOOP-CORRES-TYPE          PIC X(4)   VALUE SPACES.    
               88  NOOP-BILL                           VALUE 'BILL'     
ACT231                                                       'STMT'.    
               88  NOOP-PAPERLESS                      VALUE 'PRLS'.    
               88  NOOP-EXCP                           VALUE 'EXCP'.    
               88  NOOP-CLFN                           VALUE 'CLFN'.    
               88  NOOP-MKTG                           VALUE 'MKTG'.    
           05  FILLER                       PIC X      VALUE '~'.       
           05  WS-NOOP-CUST-NO              PIC X(10)  VALUE SPACES.    
           05  FILLER                       PIC X      VALUE '~'.       
           05  WS-NOOP-ACCT-NO              PIC X(13)  VALUE SPACES.    
           05  FILLER                       PIC X      VALUE '~'.       
P00533     05  WS-NOOP-DATA                 PIC X(391).                 
      *                                                                 00053600
      ****LAYOUT OF BILLS                                               00053600
           05  WS-NOOP-BILL-DATA            REDEFINES  WS-NOOP-DATA.    
               10  WS-NOOP-BILL-NO          PIC 9(9).                   
               10  FILLER                   PIC X.                      
               10  WS-NOOP-BILL-DEST-CD     PIC X.                      
               10  FILLER                   PIC X.                      
               10  WS-NOOP-BILL-PULL-CD     PIC X.                      
               10  FILLER                   PIC X.                      
               10  WS-NOOP-BILL-PAGES       PIC 9(9).                   
               10  FILLER                   PIC X.                      
               10  WS-NOOP-BILL-IMAGE-FL    PIC X.                      
               10  FILLER                   PIC X.                      
               10  WS-NOOP-BILL-COMPANY-NO  PIC X(2).                   
               10  FILLER                   PIC X.                      
               10  WS-NOOP-BILL-TYPE        PIC X(2).                   
               10  FILLER                   PIC X.                      
               10  WS-NOOP-BILL-MAIL-ADDR   PIC X(312).                 
               10  FILLER                   PIC X.                      
               10  WS-NOOP-BILL-POSTNET-BC  PIC X(11).                  
               10  FILLER                   PIC X.                      
               10  WS-NOOP-BILL-BARCODE     PIC X(9).                   
               10  FILLER                   PIC X.                      
               10  WS-NOOP-BILL-UNIQUE-ID   PIC X(9).                   
               10  FILLER                   PIC X.                      
               10  WS-NOOP-BILL-TRACK-ST    PIC X(2).                   
P00533         10  FILLER                   PIC X.                      
P00533         10  WS-NOOP-BILL-EDI-DEST    PIC X.                      
P00533         10  FILLER                   PIC X.                      
P00533         10  WS-NOOP-BILL-NO-COPIES   PIC X.                      
P00533         10  FILLER                   PIC X.                      
P00533         10  WS-NOOP-BILL-JOB         PIC X(7).                   
      *                                                                 00053600
      ****LAYOUT OF SORTINDEX FILE FOR PAPERLESS CUSTOMERS              00053600
           05  WS-NOOP-PRLS-DATA            REDEFINES  WS-NOOP-DATA.    
               10  WS-NOOP-PRLS-DEST-CD     PIC X.                      
               10  FILLER                   PIC X.                      
               10  WS-NOOP-PRLS-PULL-CD     PIC X.                      
               10  FILLER                   PIC X.                      
               10  WS-NOOP-PRLS-UNIQUE-ID   PIC X(9).                   
               10  FILLER                   PIC X.                      
               10  WS-NOOP-PRLS-TRACK-ST    PIC X(2).                   
A02119         10  FILLER                   PIC X.                      
A02119         10  WS-NOOP-MST-SUB-IND      PIC X(01).                  
      *                                                                 00053600
      ****LAYOUT OF SORTINDEX FILE FOR ONLINE BILL VIEW                 00053600
           05  WS-NOOP-EXCP-DATA            REDEFINES  WS-NOOP-DATA.    
               10  WS-NOOP-EXCP-DEST-CD     PIC X.                      
               10  FILLER                   PIC X.                      
               10  WS-NOOP-EXCP-PULL-CD     PIC X.                      
               10  FILLER                   PIC X.                      
               10  WS-NOOP-EXCP-UNIQUE-ID   PIC X(9).                   
               10  FILLER                   PIC X.                      
               10  WS-NOOP-EXCP-TRACK-ST    PIC X(2).                   
      *                                                                 00053600
      ****LAYOUT OF NON-MARKETING AND MARKETING LETTERS                 00053600
           05  WS-NOOP-CLFN-DATA            REDEFINES  WS-NOOP-DATA.    
               10  WS-NOOP-CLFN-COMM-TYPE   PIC X(2).                   
               10  FILLER                   PIC X.                      
               10  WS-NOOP-CLFN-COMM-SUB    PIC X(2).                   
               10  FILLER                   PIC X.                      
               10  WS-NOOP-CLFN-GUARANTOR   PIC X(13).                  
               10  FILLER                   PIC X.                      
               10  WS-NOOP-CLFN-PAGES       PIC 9(9).                   
               10  FILLER                   PIC X.                      
               10  WS-NOOP-CLFN-IMAGE-FL    PIC X.                      
               10  FILLER                   PIC X.                      
               10  WS-NOOP-CLFN-COMPANY-NO  PIC X(2).                   
               10  FILLER                   PIC X.                      
               10  WS-NOOP-CLFN-UNIQUE-ID   PIC X(9).                   
               10  FILLER                   PIC X.                      
               10  WS-NOOP-CLFN-TRACK-ST    PIC X(2).                   
P00533         10  FILLER                   PIC X.                      
P00533         10  WS-NOOP-CLFN-JOB         PIC X(7).                   
P00533                                                                  
      *                                                                 00053600
      *********************************************************                 
      *COPYBOOK TO SUPPORT DB2 SQL ERROR CHECKING.            *                 
      *********************************************************                 
       COPY CWS00303.                                                   00055700
                                                                        
      *********************************************************                 
      * COPYBOOK ADDED FOR ERROR HANDLING.                    *                 
      *********************************************************                 
       COPY CWS00010.                                                   02700000
                                                                        
      *********************************************************                 
      *  CWS09900  ABEND SWITCH COPYBOOK                      *       *         
      *********************************************************                 
       COPY CWS09900.                                                   02700000
                                                                        
      *********************************************************                 
      *   WS-VARIABLES FOR CPD00038                           *                 
      *********************************************************                 
       COPY CWS00038.                                                           
       COPY FIOJC01.                                                            
                                                                        
      *********************************************************                 
      *   JOBS FILE/TABLE DEFINITIONS                         *                 
      *********************************************************                 
           COPY FIOCA00.                                                        
                                                                        
      *********************************************************                 
      *   CA00 WORK DATA                                      *                 
      *********************************************************                 
       COPY CWS00039.                                                           
                                                                        
           EXEC SQL                                                     00056600
                INCLUDE SQLCA                                           00056700
           END-EXEC.                                                    00056800
                                                                        
      ***********************************************************               
      * DCLGEN TABLE(CSS_CORR_MAIL_STAT)                        *               
      ***********************************************************               
             EXEC SQL                                                           
                 INCLUDE TBMAILST                                               
             END-EXEC.                                                          
                                                                        
      ***********************************************************               
      * DCLGEN TABLE(CSS_PRINT_JOB_SCAN)                        *               
      ***********************************************************               
             EXEC SQL                                                           
                 INCLUDE TBPRTSCN                                               
             END-EXEC.                                                          
                                                                        
      *************************************************************     02853000
      *    CSS_RESTART                                                  02854000
      *************************************************************     02855000
           EXEC SQL                                                     02856000
              INCLUDE TBRESTRT                                          02857000
           END-EXEC.                                                    02858000
      *                                                                 02859000
      *************************************************************             
      *    CSS_JOB_PARM                                                         
      *************************************************************             
           EXEC SQL                                                             
                INCLUDE TBJBPARM                                                
           END-EXEC.                                                            
A02119*                                                                         
A02119***********************************************************               
A02119* DCLGEN TABLE(CSS_MSTSUB_ACCT)                           *               
A02119***********************************************************               
A02119     EXEC SQL                                                     03190000
A02119         INCLUDE TBMSTSUB                                         03200000
A02119     END-EXEC.                                                    03210000
A02119***********************************************************       03490000
A02119*  CURSOR TO FETCH SUB ACCOUNTS FOR THE MASTER            *       03500000
A02119***********************************************************       03510000
A02119                                                                  
A02119     EXEC SQL                                                     
A02119          DECLARE MSTSUB CURSOR WITH ROWSET POSITIONING FOR       
A02119          SELECT SUB_ACCT_NO                                      
A02119          FROM CSS_MSTSUB_ACCT WITH(READUNCOMMITTED)                      
A02119          WHERE MST_ACCT_NO      = :MU-MST-ACCT-NO                
A02119        ORDER BY SUB_ACCT_NO                                      
A02119        FOR READ ONLY                                     
A02119     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     03020000
MFA-TR*         DECLARE MSTSUB CURSOR WITH ROWSET POSITIONING FOR       03031000
MFA-TR*         SELECT SUB_ACCT_NO                                      03040000
MFA-TR*         FROM CSS_MSTSUB_ACCT                                    03050000
MFA-TR*         WHERE MST_ACCT_NO      = :MU-MST-ACCT-NO                03060000
MFA-TR*       ORDER BY SUB_ACCT_NO                                              
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                    03080000
A02119                                                                  
A02119*                                                                         
A02119***********************************************************       03490000
A02119*  CURSOR TO FETCH SUB ACCOUNTS FROM CSS_CORR_MAIL_STAT   *       03500000
A02119***********************************************************       03510000
A02119                                                                  
A02119     EXEC SQL                                                     
A02119          DECLARE SUB_MAIL_STAT CURSOR FOR                        
A02119          SELECT TRACKING_STATUS_CD,                              
A02119                 COMM_TYPE_CODE,                                  
A02119                 BARCODE_UNIQUE_ID                                
A02119           FROM CSS_CORR_MAIL_STAT WITH(READUNCOMMITTED)                  
A02119          WHERE ACCOUNT_NO = :MW-ACCOUNT-NO                       
A02119            AND CREATE_DT = IIF(TRY_CONVERT(DATE, :MW-CREATE-DT
              ) IS NULL OR (PATINDEX('%.%', :MW-CREATE-DT
              ) <> 0) OR (LEN(:MW-CREATE-DT) <> 10), CIS.CHAR2DATE(
                                                          :MW-CREATE-DT
              ), CONVERT(DATE, :MW-CREATE-DT) )                         
A02119            AND TRACKING_STATUS_CD = 'EH'                         
A02119          FOR READ ONLY                                   
A02119     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     03020000
MFA-TR*         DECLARE SUB_MAIL_STAT CURSOR FOR                        03031000
MFA-TR*         SELECT TRACKING_STATUS_CD,                                      
MFA-TR*                COMM_TYPE_CODE,                                          
MFA-TR*                BARCODE_UNIQUE_ID                                        
MFA-TR*          FROM CSS_CORR_MAIL_STAT                                        
MFA-TR*         WHERE ACCOUNT_NO = :MW-ACCOUNT-NO                               
MFA-TR*           AND CREATE_DT = :MW-CREATE-DT                                 
MFA-TR*           AND TRACKING_STATUS_CD = 'EH'                                 
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                    03080000
A02119                                                                  
A02119*                                                                         
                                                                        
       LINKAGE SECTION.                                                 
       01  WS-PARM-VALUE.                                               
           03  WS-PARMVAL-LENGTH            PIC S9(04) COMP.            
                                                                        
       PROCEDURE DIVISION USING WS-PARM-VALUE.                          
                                                                        
      ***************************************************************** 00065400
      *    0000-MAINLINE                                             ** 00065500
      ***************************************************************** 00065700
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
                                                                        
           IF WS-THIS-IS-A-RESTART                                      
              PERFORM 7100-REPOSITON-REC       THRU 7100-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM 7000-READ-FCSCA167          THRU 7000-EXIT.          
                                                                        
           PERFORM 1000-PROCESS-ACCOUNTS       THRU 1000-EXIT           
             UNTIL END-OF-FCSCA167.                                     
                                                                        
           PERFORM 2500-RESET-RESTART-DATA     THRU 2500-EXIT.          
                                                                        
           PERFORM 2600-DISPLAY-ACCT-TOTALS    THRU 2600-EXIT.          
                                                                        
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 00072100
      *    0100-INITIALIZATION                                       ** 00072200
      *    OPEN FILE                                                 ** 00072300
      ***************************************************************** 00072500
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           PERFORM 7200-GET-PROCESS-FLAG       THRU 7200-EXIT.          
                                                                        
           OPEN INPUT FCSCA167-FILE.                                    
           IF NOT FCA167-SUCCESSFUL                                     
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZE                  '         
               DISPLAY '**   ERROR OPENING FCSCA167'                    
               DISPLAY '**   FILE STATUS = ' WS-FCA167-STATUS           
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
           MOVE ZERO                           TO RF-PARTITION-NO.      
           MOVE WS-PGRMNAME                    TO RF-NAME-PROGRAM.      
                                                                        
           PERFORM 6251-GET-FJC01-DATE         THRU 6251-EXIT.          
      *                                                                         
           IF COMMON-DATE-NEEDED                                        
               PERFORM 6240-GET-FCA00-COMMON-DATE                       
                                               THRU 6240-EXIT           
               MOVE WS-FCA00-COMMON-DATE       TO WS-INPUT-DATE         
           END-IF.                                                      
      *                                                                         
           PERFORM 6253-GET-FJC01-CHKP-LIMIT   THRU 6253-EXIT.          
      *                                                                         
           IF WS-CHKP-LUW-LIMIT    = WS-FLAG-TO-TURN-OFF-COMMITS        
             AND WS-CHKP-UPD-LIMIT = WS-FLAG-TO-TURN-OFF-COMMITS        
               SET WS-COMMITS-NOT-REQUIRE      TO TRUE                  
               DISPLAY '********************************************'   
               DISPLAY '**   ' WS-PGRMNAME ' INFORMATIONAL MSG    **'   
               DISPLAY '** JOB PARM INPUTS CHKP-LUW AND CHKP-UPD  **'   
               DISPLAY '** BOTH SET TO ' WS-FLAG-TO-TURN-OFF-COMMITS    
               DISPLAY '** THIS INDICATES THAT INTERIM COMMIT     **'   
               DISPLAY '** POINTS SHOULD NOT BE TAKEN.            **'   
               DISPLAY '********************************************'   
           END-IF.                                                      
      *                                                                         
           PERFORM 6235-GET-FJC01-RESTART-REQ  THRU 6235-EXIT.          
      *                                                                         
           PERFORM 0600-PREPARE-FOR-RESTART    THRU 0600-EXIT.          
      *                                                                         
           PERFORM 0605-VALIDATE-RESTART-REQ   THRU 0605-EXIT.          
      *                                                                         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **      0600-PREPARE-FOR-RESTART                              **          
      ****************************************************************          
                                                                        
       0600-PREPARE-FOR-RESTART.                                        
      *                                                                         
           MOVE WS-PGRMNAME                    TO RF-NAME-PROGRAM.      
      *                                                                         
           PERFORM 8230-SELECT-RESTART         THRU 8230-EXIT           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE RF-RESTART-DATA-TEXT       TO WS-RESTART-DATA       
               IF WS-RESTART-PROCESS-TYPE NUMERIC                       
                   MOVE WS-Y                   TO WS-IS-THIS-A-RESTART  
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           IF WS-THIS-IS-A-RESTART                                      
              DISPLAY '*********************************************'   
              DISPLAY '*****   THIS IS A RESTART OF PCSCA167   *****'   
              DISPLAY '*********************************************'   
              MOVE WS-RESTART-CHKP-SEQ-NO      TO WS-CHKP-SEQ-NO        
              MOVE WS-RESTART-FCSCA167-REC-CNTR                         
                                               TO WS-ACCOUNTS-READ      
      *                                                                         
              IF WS-RESTART-COMMON-DATE EQUAL WS-INPUT-DATE OR          
                 WS-RESTART-COMMON-DATE EQUAL SPACES                    
                 CONTINUE                                               
              ELSE                                                      
                 DISPLAY '********************************************' 
                 DISPLAY '**COMMON DATE WAS CHANGED PRIOR TO RESTART**' 
                 DISPLAY '********************************************' 
                 DISPLAY '** OLD COMMON DATE = ' WS-RESTART-COMMON-DATE 
                 DISPLAY '** NEW COMMON DATE = ' WS-INPUT-DATE          
                 PERFORM 9900-ABEND            THRU 9900-EXIT           
              END-IF                                                    
P00533     END-IF.                                                      
                                                                        
       0600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *********************************************************                 
      *   0605-VALIDATE-RESTART-REQ                           *                 
      *********************************************************                 
       COPY CPD00030.                                                           
      *                                                                         
                                                                        
      ***************************************************************** 00128700
      *    1000-PROCESS-ACCOUNTS.                                    ** 00128300
      * THIS WILL LOAD THE ACCOUNTS AND PERFOMRS THE DETAIL LOGIC    ** 00128400
      ***************************************************************** 00128700
                                                                        
       1000-PROCESS-ACCOUNTS.                                           
                                                                        
           PERFORM 2000-DETAIL-PROCESSING      THRU 2000-EXIT.          
                                                                        
           MOVE WS-NOOP-ACCT-NO                TO MW-ACCOUNT-NO.        
           MOVE WS-NOOP-UNIQUE-ID              TO MW-BARCODE-UNIQUE-ID. 
           MOVE WS-TRACKING-STATUS-CODE        TO MW-TRACKING-STATUS-CD.
           PERFORM 8000-UPDATE-STATUS-CODE     THRU 8000-EXIT.          
A02119     ADD +1                              TO WS-ACCTS-UPDATED.     
                                                                        
           IF WS-COMMITS-REQUIRE                                        
              IF WS-COMMIT-ACCTS-CNT  = WS-CHKP-LUW-LIMIT               
                 PERFORM 8100-ISSUE-COMMIT     THRU 8100-EXIT           
                 MOVE ZERO                     TO WS-COMMIT-ACCTS-CNT   
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7000-READ-FCSCA167          THRU 7000-EXIT.          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 00128700
      *    2000-FORMAT-DATE.                                         ** 00128300
      * DATES FROM INPUT FILE COMES IN DIFFERENT FORMAT. THIS PARA   ** 00128400
      * FORMATS THE DATE TO MATCH WITH TABLE FORMAT.                 ** 00128400
      ***************************************************************** 00128700
                                                                        
       2000-DETAIL-PROCESSING.                                          
                                                                        
           INITIALIZE                       WS-NOOPS-STRUCTURE.         
                                                                        
           UNSTRING            FIOCA167-DATA                            
           DELIMITED BY        WS-DELIMITER                             
           INTO                WS-NOOP-IDX-DATA                         
                               WS-NOOP-DATE                             
                               WS-NOOP-CORRES-TYPE                      
                               WS-NOOP-CUST-NO                          
                               WS-NOOP-ACCT-NO.                         
                                                                        
           DISPLAY WS-NOOP-CORRES-TYPE ':'  WS-NOOP-ACCT-NO             
                                                                        
           EVALUATE WS-NOOP-CORRES-TYPE                                 
               WHEN 'BILL'                                              
ACT231         WHEN 'STMT'                                              
                    PERFORM 2100-PROCESS-BILL-DATA      THRU 2100-EXIT  
               WHEN 'PRLS'                                              
                    PERFORM 2200-PROCESS-PAPERLESS-DATA THRU 2200-EXIT  
               WHEN 'EXCP'                                              
                    PERFORM 2400-PROCESS-EXCEPTION-DATA THRU 2400-EXIT  
               WHEN 'CLFN'                                              
               WHEN 'MKTG'                                              
                    PERFORM 2300-PROCESS-CLFN-DATA      THRU 2300-EXIT  
               WHEN OTHER                                               
                    MOVE 12                             TO RETURN-CODE  
                    DISPLAY '****************************************'  
                    DISPLAY '**     PCSCA167 PROCESSING ERROR      **'  
                    DISPLAY '**       INVALID RECORD FOUND.        **'  
                    DISPLAY '**  LAST ACCOUNT PROCESSED', MW-ACCOUNT-NO 
                    DISPLAY '****************************************'  
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
           END-EVALUATE.                                                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 00128700
      *    2100-PROCESS-BILL-DATA.                                   ** 00128300
      * DELIMIT BILL AFP DATA AND DECIDE THE STATUS TO BE SET.       ** 00128400
      ***************************************************************** 00128700
                                                                        
       2100-PROCESS-BILL-DATA.                                          
                                                                        
           INITIALIZE                       WS-NOOPS-STRUCTURE          
                                            WS-EXCEPTION-CODE           
                                            WS-NOOP-UNIQUE-ID           
A04723                                      WS-TRACKING-STATUS-CODE.    
                                                                        
           UNSTRING FIOCA167-DATA DELIMITED BY                          
                               WS-DELIMITER INTO                        
                                            WS-NOOP-IDX-DATA            
                                            WS-NOOP-DATE                
                                            WS-NOOP-CORRES-TYPE         
                                            WS-NOOP-CUST-NO             
                                            WS-NOOP-ACCT-NO             
                                            WS-NOOP-BILL-NO             
                                            WS-NOOP-BILL-DEST-CD        
                                            WS-NOOP-BILL-PULL-CD        
                                            WS-NOOP-BILL-PAGES          
                                            WS-NOOP-BILL-IMAGE-FL       
                                            WS-NOOP-BILL-COMPANY-NO     
                                            WS-NOOP-BILL-TYPE           
                                            WS-NOOP-BILL-MAIL-ADDR      
                                            WS-NOOP-BILL-POSTNET-BC     
                                            WS-NOOP-BILL-BARCODE        
                                            WS-NOOP-BILL-UNIQUE-ID      
P00533                                      WS-NOOP-BILL-TRACK-ST       
P00533                                      WS-NOOP-BILL-EDI-DEST       
P00533                                      WS-NOOP-BILL-NO-COPIES      
P00533                                      WS-NOOP-BILL-JOB.           
                                                                        
           MOVE WS-NOOP-BILL-UNIQUE-ID      TO WS-NOOP-UNIQUE-ID        
           MOVE WS-NOOP-BILL-DEST-CD        TO WS-EXCEPTION-CODE(1:1)   
           MOVE WS-NOOP-BILL-PULL-CD        TO WS-EXCEPTION-CODE(2:1)   
           MOVE 'P'                         TO WS-TRACKING-STATUS-C1    
                                                                        
           IF WS-EXCEPTION-CODE = SPACES OR                             
              WS-EXCEPTION-CODE = 'CD' OR                               
              WS-EXCEPTION-CODE = 'S1' OR                               
              WS-EXCEPTION-CODE = 'G1' OR                               
              WS-NOOP-BILL-DEST-CD = 'P' OR                             
              WS-NOOP-BILL-PULL-CD = 'I'                                
                 MOVE WS-NOOP-BILL-TRACK-ST(2:1)                        
                                            TO WS-TRACKING-STATUS-C2    
           ELSE                                                         
                 MOVE 'X'                   TO WS-TRACKING-STATUS-C2    
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 00128700
      *    2200-PROCESS-PAPERLESS-DATA.                              ** 00128300
      * DELIMIT INPUT DATA AND DECIDE THE STATUS TO BE SET.          ** 00128400
      ***************************************************************** 00128700
                                                                        
       2200-PROCESS-PAPERLESS-DATA.                                     
                                                                        
           INITIALIZE                       WS-NOOPS-STRUCTURE          
                                            WS-EXCEPTION-CODE           
                                            WS-NOOP-UNIQUE-ID           
                                            WS-TRACKING-STATUS-CODE.    
                                                                        
           UNSTRING FIOCA167-DATA DELIMITED BY                          
                               WS-DELIMITER INTO                        
                                            WS-NOOP-IDX-DATA            
                                            WS-NOOP-DATE                
                                            WS-NOOP-CORRES-TYPE         
                                            WS-NOOP-CUST-NO             
                                            WS-NOOP-ACCT-NO             
                                            WS-NOOP-PRLS-DEST-CD        
                                            WS-NOOP-PRLS-PULL-CD        
                                            WS-NOOP-PRLS-UNIQUE-ID      
                                            WS-NOOP-PRLS-TRACK-ST       
A02119                                      WS-NOOP-MST-SUB-IND.        
                                                                        
           MOVE WS-NOOP-PRLS-UNIQUE-ID      TO WS-NOOP-UNIQUE-ID        
           MOVE WS-NOOP-PRLS-DEST-CD        TO WS-EXCEPTION-CODE(1:1)   
           MOVE WS-NOOP-PRLS-PULL-CD        TO WS-EXCEPTION-CODE(2:1)   
           MOVE '0'                         TO WS-TRACKING-STATUS-C1    
                                                                        
           IF WS-EXCEPTION-CODE = SPACES OR                             
              WS-EXCEPTION-CODE = 'CD' OR                               
              WS-EXCEPTION-CODE = 'S1' OR                               
              WS-EXCEPTION-CODE = 'G1' OR                               
              WS-NOOP-PRLS-DEST-CD = 'P' OR                             
              WS-NOOP-PRLS-PULL-CD = 'I'                                
                 MOVE WS-NOOP-PRLS-TRACK-ST(2:1)                        
                                            TO WS-TRACKING-STATUS-C2    
           ELSE                                                         
                 MOVE 'X'                   TO WS-TRACKING-STATUS-C2    
           END-IF.                                                      
                                                                        
A02119     IF WS-NOOP-MST-SUB-IND = 'M'                                 
A02119        MOVE WS-NOOP-ACCT-NO       TO MU-MST-ACCT-NO              
A02119        PERFORM 2250-RECONCILE-SUBS  THRU 2250-EXIT               
A02119     END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
A02119                                                                  
A02119 2250-RECONCILE-SUBS.                                             
A02119*PULL ALL THE SUB ACCOUNTS FOR THE MASTER FROM CSS_MSTSUB_ACCT.   04730000
A02119     INITIALIZE WS-SUB-ACCTS-HOLD-TABLE                           
A02119     MOVE ZERO                             TO WS-SUB-COUNT.       
A02119     PERFORM 7300-OPEN-MSTSUB-CURSOR     THRU 7300-EXIT.          
A02119                                                                  
A02119     PERFORM 7310-FETCH-MSTSUB-CURSOR    THRU 7310-EXIT           
A02119                      UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.    
A02119                                                                  
A02119     PERFORM 7320-CLOSE-MSTSUB-CURSOR    THRU 7320-EXIT.          
A02119                                                                  
A02119     PERFORM VARYING WS-MISC-IDX FROM 1 BY 1                      
SCA006               UNTIL WS-MISC-IDX > WS-SUB-COUNT OR 
                           WS-SUB-ACCOUNT-NO(WS-MISC-IDX) = ZEROES              
A02119         MOVE WS-SUB-ACCOUNT-NO(WS-MISC-IDX) TO MW-ACCOUNT-NO     
A02119         MOVE WS-NOOP-DATE                   TO MW-CREATE-DT      
A02119         MOVE WS-N                           TO WS-SUB-FOUND-FLAG 
A02119                                                WS-CURSOR-STATUS  
A02119         PERFORM 7400-OPEN-SUBMAIL-CURSOR    THRU 7400-EXIT       
A02119         PERFORM 7410-FETCH-SUBMAIL-CURSOR   THRU 7410-EXIT       
A02119         PERFORM UNTIL WS-C1-EOC                                  
A02119           IF SUB-FOUND                                           
A02119              MOVE MW-TRACKING-STATUS-CD          TO              
A02119                                        WS-TRACK-MS-STATUS-CODE   
A02119              MOVE '0'                TO WS-TRACK-MS-STATUS-C1    
A02119              MOVE WS-TRACK-MS-STATUS-CODE        TO              
A02119                                         MW-TRACKING-STATUS-CD    
A02119              PERFORM 8000-UPDATE-STATUS-CODE  THRU 8000-EXIT     
A02119              ADD +1                     TO WS-SUBS-UPDATED       
A02119           END-IF                                                 
A02119           PERFORM 7410-FETCH-SUBMAIL-CURSOR THRU 7410-EXIT       
A02119         END-PERFORM                                              
A02119         PERFORM 7420-CLOSE-SUBMAIL-CURSOR   THRU 7420-EXIT       
A02119     END-PERFORM.                                                 
A02119     MOVE WS-N                           TO WS-SUB-FOUND-FLAG.    
A02119                                                                  
A02119 2250-EXIT.                                                       
A02119     EXIT.                                                        
                                                                        
      ***************************************************************** 00128700
      *    2300-PROCESS-CLFN-DATA.                                   ** 00128300
      * DELIMIT INPUT DATA AND DECIDE THE STATUS TO BE SET.          ** 00128400
      ***************************************************************** 00128700
                                                                        
       2300-PROCESS-CLFN-DATA.                                          
                                                                        
           INITIALIZE                       WS-NOOPS-STRUCTURE          
                                            WS-NOOP-UNIQUE-ID           
A04723                                      WS-TRACKING-STATUS-CODE.    
                                                                        
           UNSTRING FIOCA167-DATA DELIMITED BY                          
                               WS-DELIMITER INTO                        
                                            WS-NOOP-IDX-DATA            
                                            WS-NOOP-DATE                
                                            WS-NOOP-CORRES-TYPE         
                                            WS-NOOP-CUST-NO             
                                            WS-NOOP-ACCT-NO             
                                            WS-NOOP-CLFN-COMM-TYPE      
                                            WS-NOOP-CLFN-COMM-SUB       
                                            WS-NOOP-CLFN-GUARANTOR      
                                            WS-NOOP-CLFN-PAGES          
                                            WS-NOOP-CLFN-IMAGE-FL       
                                            WS-NOOP-CLFN-COMPANY-NO     
                                            WS-NOOP-CLFN-UNIQUE-ID      
P00533                                      WS-NOOP-CLFN-TRACK-ST       
P00533                                      WS-NOOP-CLFN-JOB.           
                                                                        
           MOVE WS-NOOP-CLFN-UNIQUE-ID      TO WS-NOOP-UNIQUE-ID.       
           MOVE 'P'                         TO WS-TRACKING-STATUS-C1.   
           IF NOOP-MKTG                                                 
              MOVE 'M'                         TO WS-TRACKING-STATUS-C2 
           ELSE                                                         
              MOVE 'D'                         TO WS-TRACKING-STATUS-C2 
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 00128700
      *    2400-PROCESS-EXCEPTION-DATA.                              ** 00128300
      * DELIMIT INPUT DATA AND DECIDE THE STATUS TO BE SET.          ** 00128400
      ***************************************************************** 00128700
                                                                        
       2400-PROCESS-EXCEPTION-DATA.                                     
                                                                        
           INITIALIZE                       WS-NOOPS-STRUCTURE          
                                            WS-EXCEPTION-CODE           
                                            WS-NOOP-UNIQUE-ID           
                                            WS-TRACKING-STATUS-CODE.    
                                                                        
           UNSTRING FIOCA167-DATA DELIMITED BY                          
                               WS-DELIMITER INTO                        
                                            WS-NOOP-IDX-DATA            
                                            WS-NOOP-DATE                
                                            WS-NOOP-CORRES-TYPE         
                                            WS-NOOP-CUST-NO             
                                            WS-NOOP-ACCT-NO             
                                            WS-NOOP-EXCP-DEST-CD        
                                            WS-NOOP-EXCP-PULL-CD        
                                            WS-NOOP-EXCP-UNIQUE-ID      
                                            WS-NOOP-EXCP-TRACK-ST.      
                                                                        
           MOVE WS-NOOP-EXCP-UNIQUE-ID      TO WS-NOOP-UNIQUE-ID.       
           MOVE WS-NOOP-EXCP-DEST-CD        TO WS-EXCEPTION-CODE(1:1).  
           MOVE WS-NOOP-EXCP-PULL-CD        TO WS-EXCEPTION-CODE(2:1).  
A02283     MOVE 'X'                         TO WS-TRACKING-STATUS-C1.   
A02283     EVALUATE WS-NOOP-EXCP-DEST-CD                                
A02283         WHEN 'G'                                                 
A02283              MOVE 'C'                TO WS-TRACKING-STATUS-C2    
A02283         WHEN 'S'                                                 
A02283              MOVE 'S'                TO WS-TRACKING-STATUS-C2    
A02283         WHEN OTHER                                               
A02283              MOVE 'B'                TO WS-TRACKING-STATUS-C2    
A02283     END-EVALUATE.                                                
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * UPGRADE THE JOB-COMPLETE FIELD TO INDICATE SUCCESSFUL COMPLETION        
      ****************************************************************          
                                                                        
       2500-RESET-RESTART-DATA.                                         
                                                                        
           MOVE SPACES                      TO WS-RESTART-JOB-COMPLETE. 
           IF WS-THIS-IS-A-RESTART                                      
               MOVE WS-B                       TO WS-RESTART-JOB-STATUS 
           ELSE                                                         
               MOVE WS-A                       TO WS-RESTART-JOB-STATUS 
           END-IF.                                                      
      *                                                                         
           MOVE LENGTH OF WS-RESTART-DATA      TO WS-RESTART-DATA-LENGTH
           MOVE WS-RESTART-DATA                TO RF-RESTART-DATA-TEXT. 
           MOVE WS-RESTART-DATA-LENGTH         TO RF-RESTART-DATA-LEN.  
      *                                                                         
           PERFORM 8200-UPDATE-RESTART         THRU 8200-EXIT.          
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               PERFORM 8210-INSERT-RESTART     THRU 8210-EXIT           
           END-IF.                                                      
                                                                        
           IF WS-RESTART-REQ = WS-Y                                     
              PERFORM 8893-RESET-RESTART-REQ-PARM THRU 8893-EXIT        
           END-IF.                                                      
      *                                                                         
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2600-DISPLAY-ACCT-TOTALS.                                        
                                                                        
           DISPLAY '*******************************************'.       
           DISPLAY '*****     PCSCA167 TOTALS            ******'.       
           DISPLAY '*******************************************'.       
           DISPLAY '*****ACCOUNTS READ:    ', WS-ACCOUNTS-READ          
           DISPLAY '*****ACCOUNTS UPDATED: ', WS-ACCTS-UPDATED          
A02119     DISPLAY '*****SUB ACCTS UPDATED: ', WS-SUBS-UPDATED          
           DISPLAY '*******************************************'.       
           DISPLAY '*******************************************'.       
      *                                                                         
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6253-GET-FJC01-CHKP-LIMIT                                     *         
      *****************************************************************         
            EXEC SQL                                                            
                INCLUDE CPD00034                                                
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * 6251-GET-FJC01-DATE                                           *         
      *****************************************************************         
        COPY CPD00037.                                                          
                                                                        
      *****************************************************************         
      * 6240-GET-FCA00-COMMON-DATE                                    *         
      *****************************************************************         
              COPY CPD00040.                                                    
                                                                        
      *****************************************************************         
      * 6235-GET-FJC01-RESTART-REQ.                                   *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPD00035                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00038                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00039                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************  00122600
      ** 7000-READ-FCSCA167.                                        **  00122700
      ** READ THE INPUT FILE FCSCA167.                              **  00122800
      ****************************************************************  00123100
       7000-READ-FCSCA167.                                              
                                                                        
           READ FCSCA167-FILE                                           
               AT END                                                   
                  MOVE WS-Y                    TO WS-FCSCA167-FLAG.     
           IF FCA167-SUCCESSFUL                                         
              ADD  +1                       TO WS-ACCOUNTS-READ         
           ELSE                                                         
              IF END-OF-FCSCA167                                        
                 CONTINUE                                               
              ELSE                                                      
                 DISPLAY '7000-ERROR ON FCSCA167 READ'                  
                 DISPLAY 'PROCESSING TERMINATED'                        
                 PERFORM 9900-ABEND               THRU 9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7100-REPOSITON-REC                                                      
      *****************************************************************         
                                                                        
       7100-REPOSITON-REC.                                              
                                                                        
           PERFORM WS-ACCOUNTS-READ TIMES                               
              READ FCSCA167-FILE                                        
              IF FCA167-SUCCESSFUL                                      
                 ADD  +1                       TO WS-ACCTS-UPDATED      
              ELSE                                                      
                 DISPLAY '7100-ERROR ON FIOBE24 RESTART READ'           
                 DISPLAY 'PROCESSING TERMINATED'                        
                 PERFORM 9900-ABEND            THRU 9900-EXIT           
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7200-GET-PROCESS-FLAG                                                   
      *****************************************************************         
                                                                        
       7200-GET-PROCESS-FLAG.                                           
                                                                        
T12753     EXEC SQL                                                     
                SELECT                                                  
                      G6.PARM_DATA                                      
                  INTO :G6-PARM-DATA                                    
                  FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                    
                 WHERE G6.PROGRAM_NAME = 'SCSCA165'                     
                   AND G6.COMPANY_NO   = '01'                           
                   AND G6.CMND_CODE    = 'PARM'                         
                   AND G6.STATUS       = 'A'                            
                                                                 
T12753     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02642000
MFA-TR*         SELECT                                                  01176000
MFA-TR*               G6.PARM_DATA                                      01177100
MFA-TR*           INTO :G6-PARM-DATA                                            
MFA-TR*           FROM CSS_JOB_PARM G6                                  01178000
MFA-TR*          WHERE G6.PROGRAM_NAME = 'SCSCA165'                     01179000
MFA-TR*            AND G6.COMPANY_NO   = '01'                           01179100
MFA-TR*            AND G6.CMND_CODE    = 'PARM'                         01179200
MFA-TR*            AND G6.STATUS       = 'A'                            01179400
MFA-TR*           WITH UR                                               01179500
MFA-TR*    END-EXEC.                                                    02647000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE G6-PARM-DATA             TO WS-CTRL-PARM-STR         
              IF WS-CONTROL-FLAG = 'N'                                  
                 DISPLAY '******************************************'   
                 DISPLAY '****PROCESS FLAG IS N, STOP PROCESSING****'   
                 DISPLAY '******************************************'   
                 STOP RUN                                               
              ELSE                                                      
                 CONTINUE                                               
              END-IF                                                    
           ELSE                                                         
               DISPLAY '*** IN 7200 GET PROCESS FLAG *****'             
               DISPLAY '*** SQL CODE    = ' WS-ACTIVE-RETURN-CODE       
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
A02119                                                                  
A02119******************************************************************        
A02119*   OPET MSTSUB CURSOR TO PULL ALL THE SUBS FOR MASTER           *        
A02119******************************************************************        
A02119                                                                  
A02119 7300-OPEN-MSTSUB-CURSOR.                                         
A02119                                                                  
A02119     EXEC SQL                                                     
A02119          OPEN MSTSUB                                             
A02119     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02119                                                                  
A02119     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
A02119                                                                  
A02119     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
A02119        DISPLAY '****** 7300-OPEN-MSTSUB-CURSOR  '                
A02119        DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'            
A02119        DISPLAY ' ** ERROR ON OPEN   '                            
A02119        DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A02119        DISPLAY ' ** TABLE CSS_MSTSUB_ACCT  '                     
A02119        DISPLAY ' ** ACCOUNT_NO     '  MU-MST-ACCT-NO             
A02119        PERFORM 9900-ABEND THRU 9900-EXIT                         
A02119     END-IF.                                                      
A02119                                                                  
A02119 7300-EXIT.                                                       
A02119     EXIT.                                                        
A02119                                                                  
A02119******************************************************************        
A02119*   FETCH FROM MSTSUB CURSOR AND STORE IT IN ARRAY               *        
A02119******************************************************************        
A02119                                                                  
A02119 7310-FETCH-MSTSUB-CURSOR.                                        
A02119                                                                  
A02119     INITIALIZE                             WS-HOLD-MST-SUB-HV.   
A02119     MOVE 0                              TO WS-SUB-ROW-COUNT.     

MSQ008     MOVE 100 TO MSQ008-MSTSUB
A02119     EXEC SQL                                                     
A02119         FOR :MSQ008-MSTSUB
              FETCH 
              FROM MSTSUB  INTO          
A02119               :WS-SUB-ACCOUNT-HV                                 
A02119     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*        FETCH NEXT ROWSET FROM MSTSUB FOR 100 ROWS INTO                  
MFA-TR*              :WS-SUB-ACCOUNT-HV                                         
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-MSTSUB
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02119                                                                  
A02119     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
A02119     EVALUATE WS-ACTIVE-RETURN-CODE                               
A02119         WHEN SUCCESSFUL-CALL                                     
A02119         WHEN NOT-FOUND                                           
A02119         WHEN 354                                                 
A02119             EXEC SQL GET DIAGNOSTICS                             
MSQ012                   :MFA-GD-ROW-COUNT = ROW_COUNT                  
A02119             END-EXEC                                             

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*            EXEC SQL GET DIAGNOSTICS                                     
MFA-TR*                  :WS-SUB-ROW-COUNT = ROW_COUNT                          
MFA-TR*            END-EXEC                                                     
MSQ012             MOVE MFA-GD-ROW-COUNT TO WS-SUB-ROW-COUNT
A02119             MOVE 1 TO WS-MISC-IDX                                
A02119             PERFORM UNTIL WS-MISC-IDX > 100                      
A02119                        OR WS-MISC-IDX > WS-SUB-ROW-COUNT         
A02119                ADD 1                      TO WS-SUB-COUNT        
A02119                MOVE WS-SUB-ACCOUNT-HV(WS-MISC-IDX)   TO          
A02119                     WS-SUB-ACCOUNT-NO(WS-SUB-COUNT)              
A02119                ADD 1                      TO WS-MISC-IDX         
A02119             END-PERFORM                                          
A02119             IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
A02119                CONTINUE                                          
A02119             END-IF                                               
A02119         WHEN OTHER                                               
A02119              DISPLAY '****** 7310-FETCH-MSTSUB-CURSOR   '        
A02119              DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'      
A02119              DISPLAY ' ** ERROR ON FETCH  '                      
A02119              DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE    
A02119              DISPLAY ' ** TABLE CSS_MSTSUB_ACCT '                
A02119              DISPLAY ' ** ACCOUNT_NO     '  MU-MST-ACCT-NO       
A02119              PERFORM 9900-ABEND         THRU 9900-EXIT           
A02119     END-EVALUATE.                                                
A02119                                                                  
A02119 7310-EXIT.                                                       
A02119     EXIT.                                                        
A02119                                                                  
A02119******************************************************************        
A02119*   CLOSE MSTSUB                                                 *        
A02119******************************************************************        
A02119                                                                  
A02119 7320-CLOSE-MSTSUB-CURSOR.                                        
A02119                                                                  
A02119*                                                                 05330000
A02119     EXEC SQL                                                     
A02119          CLOSE MSTSUB                                            
A02119     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02119*                                                                 05330000
A02119     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
A02119                                                                  
A02119     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
A02119        DISPLAY '****** 7320-CLOSE-MSTSUB-CURSOR  '               
A02119        DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'            
A02119        DISPLAY ' ** ERROR ON CLOSE  '                            
A02119        DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A02119        DISPLAY ' ** TABLE CSS_MSTSUB_ACCT '                      
A02119        DISPLAY ' ** ACCOUNT_NO     '  MU-MST-ACCT-NO             
A02119        PERFORM 9900-ABEND               THRU 9900-EXIT           
A02119     END-IF.                                                      
A02119                                                                  
A02119 7320-EXIT.                                                       
A02119     EXIT.                                                        
A02119                                                                  
A02119******************************************************************05520000
A02119*   OPET SUB_MAIL_ST CURSOR                                      *05520000
A02119******************************************************************05520000
A02119                                                                  
A02119 7400-OPEN-SUBMAIL-CURSOR.                                        
A02119                                                                  
A02119     EXEC SQL                                                     
A02119          OPEN SUB_MAIL_STAT                                      
A02119     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02119                                                                  
A02119     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
A02119                                                                  
A02119     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
A02119        DISPLAY '****** 7400-OPEN-SUBMAIL-CURSOR    *****'        
A02119        DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'            
A02119        DISPLAY ' ** ERROR ON OPEN   '                            
A02119        DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A02119        DISPLAY ' ** TABLE CSS_CORR_MAIL_STAT '                   
A02119        DISPLAY ' ** ACCOUNT_NO     '  MW-ACCOUNT-NO              
A02119        PERFORM 9900-ABEND THRU 9900-EXIT                         
A02119     END-IF.                                                      
A02119                                                                  
A02119 7400-EXIT.                                                       
A02119     EXIT.                                                        
A02119                                                                  
A02119******************************************************************02801000
A02119* FETCH  JOBPARM-C1  CURSOR                                      *02801100
A02119******************************************************************02801200
A02119 7410-FETCH-SUBMAIL-CURSOR.                                       
A02119                                                                  
A02119     EXEC SQL                                                     
A02119          FETCH                                                   
A02119                 SUB_MAIL_STAT                                    
A02119           INTO                                                   
A02119                :MW-TRACKING-STATUS-CD                            
A02119               ,:MW-COMM-TYPE-CODE                                
A02119               ,:MW-BARCODE-UNIQUE-ID                             
A02119     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02119                                                                  
A02119     MOVE SQLCODE                         TO                      
A02119                                          WS-ACTIVE-RETURN-CODE.  
A02119     EVALUATE TRUE                                                
A02119         WHEN WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
A02119              MOVE WS-Y                       TO WS-SUB-FOUND-FLAG
A02119         WHEN WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
A02119              SET  WS-C1-EOC              TO    TRUE              
A02119         WHEN OTHER                                               
A02119              DISPLAY '********** PCSCA166 ABORT  ************'   
A02119              DISPLAY '* 7410-FETCH-SUBMAIL.          *'          
A02119              DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'      
A02119              DISPLAY ' ** ERROR ON OPEN   '                      
A02119              DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE    
A02119              DISPLAY ' ** TABLE CSS_CORR_MAIL_STAT '             
A02119              DISPLAY ' ** ACCOUNT_NO     '  MW-ACCOUNT-NO        
A02119              PERFORM 9900-ABEND          THRU 9900-EXIT          
A02119     END-EVALUATE.                                                
A02119                                                                  
A02119 7410-EXIT.                                                       
A02119     EXIT.                                                        
A02119*                                                                 02804500
A02119******************************************************************05520000
A02119*   CLOSE SUB_MAIL_STAT                                          *05520000
A02119******************************************************************05520000
A02119                                                                  
A02119 7420-CLOSE-SUBMAIL-CURSOR.                                       
A02119                                                                  
A02119*                                                                 05330000
A02119     EXEC SQL                                                     
A02119          CLOSE SUB_MAIL_STAT                                     
A02119     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02119*                                                                 05330000
A02119     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
A02119                                                                  
A02119     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
A02119        DISPLAY '****** 7420-CLOSE-SUBMAIL-CURSOR '               
A02119        DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'            
A02119        DISPLAY ' ** ERROR ON CLOSE  '                            
A02119        DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A02119        DISPLAY ' ** TABLE CSS_CORR_MAIL_STAT '                   
A02119        DISPLAY ' ** ACCOUNT_NO     '  MW-ACCOUNT-NO              
A02119        PERFORM 9900-ABEND               THRU 9900-EXIT           
A02119     END-IF.                                                      
A02119                                                                  
A02119 7420-EXIT.                                                       
A02119     EXIT.                                                        
A02119                                                                  
      *                                                                         
      ****************************************************************  00122600
      ** 8000-UPDATE-STATUS-CODE.                                   **  00122700
      ** UPDATE TRACKING STATUS CODE IN CSS_CORR_MAIL_STAT          **  00122800
      ****************************************************************  00123100
                                                                        
       8000-UPDATE-STATUS-CODE.                                         
                                                                        
           MOVE WS-PGRMNAME(1:9)               TO MW-APPL-PROGRAM-ID.   
                                                                        
           IF NOOP-CLFN                                                 
              EXEC SQL                                                  
                   UPDATE CSS_CORR_MAIL_STAT                            
                      SET TRACKING_STATUS_CD  = :MW-TRACKING-STATUS-CD  
                     ,APPL_PROGRAM_ID         = :MW-APPL-PROGRAM-ID     
                     ,LAST_UPDATE_TS          = CIS.CURRENT$TIMESTAMP()       
                  WHERE BARCODE_UNIQUE_ID     = :MW-BARCODE-UNIQUE-ID   
              END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*       EXEC SQL                                                          
MFA-TR*            UPDATE CSS_CORR_MAIL_STAT                                    
MFA-TR*               SET TRACKING_STATUS_CD  = :MW-TRACKING-STATUS-CD          
MFA-TR*              ,APPL_PROGRAM_ID         = :MW-APPL-PROGRAM-ID             
MFA-TR*              ,LAST_UPDATE_TS          = CURRENT TIMESTAMP               
MFA-TR*           WHERE BARCODE_UNIQUE_ID     = :MW-BARCODE-UNIQUE-ID           
MFA-TR*       END-EXEC                                                          
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
           ELSE                                                         
              EXEC SQL                                                  
                   UPDATE CSS_CORR_MAIL_STAT                            
                      SET TRACKING_STATUS_CD  = :MW-TRACKING-STATUS-CD  
                     ,APPL_PROGRAM_ID         = :MW-APPL-PROGRAM-ID     
                     ,LAST_UPDATE_TS          = CIS.CURRENT$TIMESTAMP()       
                  WHERE BARCODE_UNIQUE_ID     = :MW-BARCODE-UNIQUE-ID   
                    AND ACCOUNT_NO            = :MW-ACCOUNT-NO          
              END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*       EXEC SQL                                                          
MFA-TR*            UPDATE CSS_CORR_MAIL_STAT                                    
MFA-TR*               SET TRACKING_STATUS_CD  = :MW-TRACKING-STATUS-CD          
MFA-TR*              ,APPL_PROGRAM_ID         = :MW-APPL-PROGRAM-ID             
MFA-TR*              ,LAST_UPDATE_TS          = CURRENT TIMESTAMP               
MFA-TR*           WHERE BARCODE_UNIQUE_ID     = :MW-BARCODE-UNIQUE-ID           
MFA-TR*             AND ACCOUNT_NO            = :MW-ACCOUNT-NO                  
MFA-TR*       END-EXEC                                                          
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
           END-IF.                                                      
                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
A02119         DISPLAY '*** IN 8000 UPDATE CORR MAIL STAT*****'         
               DISPLAY '*** SQL CODE    = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '*** ACCOUNT #   = ' MW-ACCOUNT-NO               
               DISPLAY '*** UNIQUE ID   = ' MW-BARCODE-UNIQUE-ID        
               DISPLAY '*** STATUS      = ' MW-TRACKING-STATUS-CD       
               DISPLAY '*** LAST UPD TS = ' MW-LAST-UPDATE-TS           
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
A02119     ADD  +1                             TO WS-COMMIT-ACCTS-CNT.  
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8100-ISSUE-COMMIT.                                            *         
      *****************************************************************         
      *                                                                         
       8100-ISSUE-COMMIT.                                               
      *                                                                         
           MOVE 1                           TO WS-RESTART-PROCESS-TYPE. 
           ADD 1                            TO WS-CHKP-SEQ-NO.          
           MOVE WS-CHKP-SEQ-NO              TO WS-RESTART-CHKP-SEQ-NO.  
           MOVE WS-C                        TO WS-RESTART-JOB-STATUS.   
           MOVE WS-INPUT-DATE               TO WS-RESTART-COMMON-DATE.  
           MOVE WS-ACCOUNTS-READ            TO                          
                                           WS-RESTART-FCSCA167-REC-CNTR.
           MOVE WS-NOOP-ACCT-NO             TO WS-RESTART-ACCOUNT-NO.   
           MOVE LENGTH OF WS-RESTART-DATA   TO WS-RESTART-DATA-LENGTH.  
      *                                                                         
           MOVE WS-RESTART-DATA             TO RF-RESTART-DATA-TEXT.    
           MOVE WS-RESTART-DATA-LENGTH      TO RF-RESTART-DATA-LEN.     
      *                                                                         
           PERFORM 8200-UPDATE-RESTART      THRU 8200-EXIT.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               PERFORM 8210-INSERT-RESTART  THRU 8210-EXIT              
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00047                                                
           END-EXEC                                                             
      *                                                                         
           DISPLAY 'COMMIT POINT # ' WS-CHKP-SEQ-NO ' TAKEN.' .         
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8200-UPDATE-RESTART.                                          *         
      *****************************************************************         
      *                                                                         
       8200-UPDATE-RESTART.                                             
      *                                                                         
            MOVE '8200'                        TO WS-ACTIVE-PARAGRAPH.  
      *                                                                         
            EXEC SQL                                                    
               UPDATE CSS_RESTART                                       
                  SET RESTART_DATA = :RF-RESTART-DATA                   
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                   
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
                CONTINUE                                                
            ELSE                                                        
                DISPLAY '**   ERROR ON 8200-UPDATE-RESTART   **'        
                DISPLAY '**   RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
                DISPLAY '**       PROCESSING TERMINATED      **'        
                PERFORM 9900-ABEND             THRU 9900-EXIT           
            END-IF.                                                     
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8210-INSERT-RESTART.                                          *         
      *****************************************************************         
      *                                                                         
       8210-INSERT-RESTART.                                             
      *                                                                         
            MOVE '8210'                        TO WS-ACTIVE-PARAGRAPH.  
      *                                                                         
            EXEC SQL                                                    
               INSERT INTO CSS_RESTART                                  
                           (NAME_PROGRAM,                               
                            PARTITION_NO,                               
                            DUP_CNTRL_NO,                               
                            RESTART_DATA)                               
               VALUES      (:RF-NAME-PROGRAM,                           
                            :RF-PARTITION-NO,                           
                            :RF-DUP-CNTRL-NO,                           
                            :RF-RESTART-DATA)                           
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
                CONTINUE                                                
            ELSE                                                        
                DISPLAY '**   ERROR ON 8210-INSERT-RESTART   **'        
                DISPLAY '**   RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
                DISPLAY '**       PROCESSING TERMINATED      **'        
                PERFORM 9900-ABEND             THRU 9900-EXIT           
            END-IF.                                                     
      *                                                                         
       8210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8230-SELECT-RESTART.                                          *         
      *****************************************************************         
      *                                                                         
       8230-SELECT-RESTART.                                             
      *                                                                         
            MOVE '8230'                        TO WS-ACTIVE-PARAGRAPH.  
      *                                                                         
            EXEC SQL                                                    
               SELECT RESTART_DATA                                      
                 INTO :RF-RESTART-DATA                                  
                 FROM CSS_RESTART                                       
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                   
                  AND PARTITION_NO = :RF-PARTITION-NO                   
                  AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
                CONTINUE                                                
            ELSE                                                        
                DISPLAY '**   ERROR ON 8230-SELECT-RESTART   **'        
                DISPLAY '**   RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
                DISPLAY '**       PROCESSING TERMINATED      **'        
                PERFORM 9900-ABEND             THRU 9900-EXIT           
            END-IF.                                                     
      *                                                                         
       8230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 8893-RESET-RESTART-REQ-PARM                                  *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD00029                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************00300400
      *     9000-TERMINATE                                             *00300500
      *     CLOSE FILES. IF WORK QUEUE CREATED SET THE RETURN CODE TO 1*00300600
      ******************************************************************00300700
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSCA167-FILE.                                         
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      *************************                                         13900000
      *  9700-PROCESS-ABEND  **                                         13920000
      *************************                                         13940000
      *                                                                 13950000
       COPY CPD0023B.                                                   13960000
      *                                                                 13970000
      ******************************************************************        
      *     9900-ABEND                                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     19620000
              INCLUDE CPD09900                                          19630000
           END-EXEC.                                                    19640000
      *                                                                         
