       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA166.                                        
      ***************************************************************** 00030000
      **               CUSTOMER INFORMATION SYSTEM                   ** 00040000
      **                                                             ** 00050000
      ***************************************************************** 00060000
      **               P R O G R A M  S U M M A R Y                  ** 00070000
      **                                                             ** 00080000
      ** RECONCILIATION PROGRAM.                                     ** 00090000
      ** THIS PROGRAM UPDATES CSS_CORR_MAIL_STAT STATUS AFTER THE    ** 00100000
      ** CORRESPONDENCES ARE MAILED OUT.                             ** 00110000
      **                                                             ** 00120000
      ***************************************************************** 00130000
      *                                                              ** 00140000
      *              PROGRAM  MODIFICATION  LOG                      ** 00150000
      *                                                              ** 00160000
      *    DATE     INITIALS  REASON                                 ** 00170000
      *    ----     --------  ------                                 ** 00180000
PRJ166**   11/09    RAJ       INITIAL VERSION.                       ** 00190000
P00166**   01/10    DMS       CHANGE RECORD LENGTH OF REPORTS TO 80. ** 00200000
A02119**   02/10    SV ACT 7  ADD CORRESPONDENCE TYPE TO OM E-REPORTS** 00210000
A02119**            ACT-17    ADD UI TO TRANS HIST ROW.              ** 00220000
A02318**   04/21    SP94986   NOT HARD-ABEND WHEN THE RECORD IS      ** 00230000
A02318**            ACT-01    NOT-FOUND FOR CSS_CORR_MAIL_STAT TABLE ** 00240000
A02003**   08/05    SV82012   RECONCILE SUBS WHEN MASTER IS RECONCILED* 00250000
A03019**   03/11    BD09555   DO NOT ABEND ON SQL UPDATE              * 00260000
A03019**   01/12    DMS       ADD NEW JOB NAMES                       * 00270000
P00533**   02/12    DMS       ADD NEW JOB NAMES FOR SCAN HEADER PRJ   * 00280000
P00527**   02/12    SV        CHANGES TO CUSTOMER STATEMENT          ** 00290000
P00533**   03/12    DMS       ADD NEW JOB NAME SEBCEXP                * 00300000
A03361**   04/12    ESM       CHG COMMENT ON MNT TRN HST FOR LTR/NOT  * 00310000
A04495**   02/13    GD43988   ADDED JOB_NAME/SEQ_NO TO "ANV DUPLICATE** 00320000
A04495**                      ACCTS" REPORT & "MISSING PAGE1" REPORT ** 00330000
A04494**   04/13    SV        ADD RETRY LOGIC TO INSERT MNT TRANS HIST* 00340000
A04494**   ACT 21             TABLE                                  ** 00350000
A04444**   05/13/13 RAJ       CONSOLIDATED PROCESS CHANGE.           ** 00360000
A04494**   06/13              ADD CODE NOT TO UPDATE THE STATUS FOR  ** 00361000
A04494**                      CORR THAT HAVE BEEN SCANNED WITH THE   ** 00362000
A04494**                      LIVE UPDATE APP.                       ** 00363000
      ***END*********************************************************** 00370000
      **          ---- BASIC SEQUENCE STRUCTURE ----                 ** 00380000
      **                                                             ** 00390000
      **  0000         MODULE CONTROL                                ** 00400000
      **  0100 - 0999  INITIALIZATION (OPTIONAL)                     ** 00410000
      **  1000 - 1999  FUNCTIONAL CONTROL                            ** 00420000
      **  2000 - 4999  DETAIL LOGIC                                  ** 00430000
      **  5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES            ** 00440000
      **  6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)  ** 00450000
      **  7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.)** 00460000
      **  8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC.)* 00470000
      **                                                             ** 00480000
      ***************************************************************** 00490000
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
      *** INPUT FILE DECLARATION                                        00550000
       COPY CSSCA166.                                                   00560000
      *** REPORT FILE DECLARATION                                       00570000
       COPY CSSP1661.                                                   00580000
       COPY CSSP1662.                                                   00590000
A02318 COPY CSSP1663.                                                   00600000
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
      *** INPUT FILE  STRUCTURE.                                        00650000
       COPY CFDCA166.                                                   00660000
       COPY FIOCA166.                                                   00670000
      *** REPORT FILE STRUCTURE.                                        00680000
       COPY CFDP1661.                                                   00690000
       COPY CFDP1662.                                                   00700000
A02318 COPY CFDP1663.                                                   00710000
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ012      EXEC SQL INCLUDE MFADIAG END-EXEC
MSQ008  01 MSQ008-MSTSUB  PIC S9(9) COMP-5.
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA166'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-FCA166-STATUS             PIC  X(02).                 
               88  FCA166-SUCCESSFUL                   VALUE ZERO.      
           05  WS-F1661-STATUS              PIC  X(02).                 
               88  FC1661-SUCCESSFUL                   VALUE ZERO.      
           05  WS-F1662-STATUS              PIC  X(02).                 
               88  FC1662-SUCCESSFUL                   VALUE ZERO.      
A02318     05  WS-F1663-STATUS              PIC  X(02).                 
A02318         88  FC1663-SUCCESSFUL                   VALUE ZERO.      
                                                                        
           05  WS-FCSCA166-FLAG             PIC  X(01) VALUE 'N'.       
               88  END-OF-FCSCA166                     VALUE 'Y'.       
           05  WS-COMMIT-REQ-SW             PIC X(1)   VALUE 'Y'.       
               88 WS-COMMITS-REQUIRE                   VALUE 'Y'.       
               88 WS-COMMITS-NOT-REQUIRE               VALUE 'N'.       
           05  WS-FIRST-ACCT-REP1-SW        PIC  X(01) VALUE 'Y'.       
               88 FIRST-ACCT-REP1                      VALUE 'Y'.       
           05  WS-FIRST-ACCT-REP2-SW        PIC  X(01) VALUE 'Y'.       
               88 FIRST-ACCT-REP2                      VALUE 'Y'.       
           05  WS-PAGE1-MISSING-SW          PIC  X(01) VALUE 'N'.       
               88  PAGE1-MISSING                       VALUE 'Y'.       
           05  WS-SUB-FOUND-FLAG            PIC  X(01) VALUE 'N'.       
               88  SUB-FOUND                           VALUE 'Y'.       
           05  WS-CURSOR-STATUS             PIC X(01)  VALUE SPACE.     
               88 WS-C1-EOC                            VALUE 'Y'.       
           05  WS-CORR-TYPE-CODE            PIC X(01)  VALUE SPACE.     
A02119         88 BILLS                                VALUE '1'.       
A02119         88 NON-MKTG                             VALUE '2'.       
A02119         88 MKTG-BP-LETTER                       VALUE '3'.       
A02119         88 OTHERS                               VALUE '4'.       
A02318     05  WS-ACCT-FOUND-FLAG           PIC X(01)  VALUE SPACE.     
A02318         88 ACCT-FOUND                           VALUE 'Y'.       
A02318         88 ACCT-NOT-FOUND                       VALUE 'N'.       
A02318     05  WS-FIRST-ACCT-NOTFOU-SW      PIC  X(01) VALUE 'Y'.       
A02318         88 FIRST-ACCT-NF-REP                    VALUE 'Y'.       
                                                                        
       01  WS-CNTRS.                                                    
           05  WS-ACCOUNTS-READ             PIC 9(07)  VALUE ZERO.      
           05  WS-ACCTS-UPDATED             PIC 9(07)  VALUE ZERO.      
           05  WS-COMMIT-ACCTS-CNT          PIC 9(07)  VALUE ZERO.      
A02318     05  WS-ACCTS-NOTFOUND-CNT        PIC 9(07)  VALUE ZERO.      
A02318     05  WS-IST-ACCOUNT-NF            PIC X(01)  VALUE 'Y'.       
A04494     05  WS-COMM-RETRY-COUNT          PIC S9(04) COMP VALUE 3.    
A04494     05  WS-COMM-SUB                  PIC S9(04) COMP VALUE 0.    
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-Y                         PIC X(01) VALUE 'Y'.        
           05  WS-N                         PIC X(01) VALUE 'N'.        
           05  WS-I                         PIC X(01) VALUE 'I'.        
           05  WS-PGRMNAME                 PIC X(10) VALUE 'PCSCA166  '.
P00166     05  WS-RPT1-HEAD                 PIC X(38) VALUE             
P00166         '     NO PAGE 1 DATA FROM ANV FILE     '.                
P00166     05  WS-RPT2-HEAD                 PIC X(38) VALUE             
P00166         '     ACCOUNTS DUPLICATED IN ANV FILE  '.                
P00166     05  WS-RPT1-SCEG-TITLE           PIC X(38)     VALUE         
P00166         '     SOUTH CAROLINA ELECTRIC AND GAS  '.                
P00166     05  WS-RPT1-PSNC-TITLE           PIC X(38)     VALUE         
P00166         '                   PSNC ENERGY        '.                
P00166     05  WS-RPT1-SEB-TITLE            PIC X(38)     VALUE         
P00166         '                   SCANA ENERGY       '.                
P00166     05  WS-RPT1-SEBR-TITLE           PIC X(38)     VALUE         
P00166         '     SCANA ENERGY REGULATED DIVISION  '.                
P00166     05  WS-RPT1-SVC-TITLE            PIC X(38)     VALUE         
P00166         '                    SERVICECARE       '.                
A02318     05  WS-RPT3-HEAD                 PIC X(50) VALUE             
A02318         '  ACCOUNTS NOT FOUND IN CSS_CORR_MAIL_STAT TABLE '.     
                                                                        
P00166 01  WS-BLANK-LINE                    PIC X(80)  VALUE SPACES.    
                                                                        
       01  WS-MISC.                                                     
           05  WS-TRACKING-STATUS-CODE.                                 
               10  WS-TRACKING-STATUS-C1    PIC X(01) VALUE SPACES.     
               10  WS-TRACKING-STATUS-C2    PIC X(01) VALUE SPACES.     
           05  WS-TRACK-MS-STATUS-CODE.                                 
               10  WS-TRACK-MS-STATUS-C1    PIC X(01) VALUE SPACES.     
               10  WS-TRACK-MS-STATUS-C2    PIC X(01) VALUE SPACES.     
           05  WS-CREATE-DATE               PIC X(10) VALUE SPACES.     
           05  WS-PREV-ACCT-NO              PIC X(13) VALUE SPACES.     
A02318     05  WS-PREV-UNIQ-ID              PIC X(09) VALUE SPACES.     
           05  WS-CHKP-LUW-LIMIT            PIC 9(04).                  
           05  WS-CHKP-UPD-LIMIT            PIC 9(04).                  
           05  WS-DEFAULT-CHKP-LUW-LIMIT    PIC 9(04) VALUE 1000.       
           05  WS-DEFAULT-CHKP-UPD-LIMIT    PIC 9(04) VALUE 1000.       
           05  WS-FLAG-TO-TURN-OFF-COMMITS  PIC 9(04) VALUE 9999.       
           05  WS-CHKP-SEQ-NO               PIC 9(05) VALUE ZERO.       
           05  WS-RESTART-DATA-LENGTH       PIC S9(04) COMP VALUE +34.  
           05  WS-DEFAULT-RESTART-REQ       PIC X(01) VALUE 'N'.        
           05  WS-RESTART-REQ               PIC X(01).                  
           05  WS-COUNT-UNSUCCESSFUL-ROWS   PIC S9(04)                  
                                                VALUE ZEROES COMP.      
           05  WS-IS-THIS-A-RESTART         PIC X(01) VALUE 'N'.        
               88 WS-THIS-IS-A-RESTART                VALUE 'Y'.        
           05  RS-RETURN-CODE               PIC S9(04) COMP VALUE 0.    
           05  S-RETURN-CODE                PIC S9(04) COMP VALUE 0.    
           05  RS-RETURN-CODE-DISP          PIC +Z(04).                 
           05  WS-DISPLAY-SQLCODE           PIC -ZZZZZZZZ9.             
           05  WS-RUN-DATE                  PIC X(10).                  
           05  WS-RUN-DATE-1                PIC X(10).                  
           05  WS-JOB-NAME                  PIC X(03).                  
           05  WS-CUSTOMER-NO               PIC 9(10).                  
A02318     05  WS-BARCODE-UNIQUE-ID         PIC X(09).                  
A02318     05  WS-MIN-BAR-UNIQUE-ID         PIC X(03).                  
A02318     05  WS-FIRST-THREE-DIGIT         PIC X(03).                  
           05  WS-MISC-IDX                 PIC 9(09) COMP-3 VALUE 0.    
           05  WS-SUB-ROW-COUNT            PIC S9(9) USAGE COMP VALUE 0.
           05  WS-HIST-DISP-DATE.                                       
               10  WS-HIST-DISP-MM         PIC X(02).                   
               10  FILLER                  PIC X(01) VALUE '/'.         
               10  WS-HIST-DISP-DD         PIC X(02).                   
               10  FILLER                  PIC X(01) VALUE '/'.         
               10  WS-HIST-DISP-YR         PIC X(04).                   
           05  WS-TIMESTAMP                PIC X(26) VALUE SPACES.      
           05  WS-HOLD-MAIL-TYPE           PIC X(08) VALUE SPACES.      
           05  WS-HOLD-JOB-NAME            PIC X(07).                   
               88 MULTIPLE-JOB             VALUES ARE                   
                              'SEBGRP4','SEBGRP5','SBRGRP4','SBRGRP5',  
                              'SVCGRP4','SVCGRP5','CSRGRP4','CSRGRP5',  
                                                  'PNCGRP4','PNCGRP5'.  
               88 REPRINT-JOB               VALUES ARE                  
                              'SEBRPRT','SBRRPRT','SVCRPRT','CSRRPRT',  
                                                            'PNCRPRT'.  
               88 BILL-JOB                  VALUES ARE                  
                                        'SEBCREG','SEBGRP4','SEBRPRT',  
                             'SEBGRP5', 'SEBEXCP','SEBCCON','SEBSCRT',  
                                        'SBRCREG','SBRGRP4','SBRRPRT',  
                             'SBRGRP5', 'SBREXCP','SBRCCON','SBRSCRT',  
                                        'SVCCREG','SVCGRP4','SVCRPRT',  
                             'SVCGRP5', 'SVCEXCP','SVCCCON','SVCSCRT',  
                                        'CSRCREG','CSRGRP4','CSRRPRT',  
                             'CSRGRP5', 'CSREXCP','CSRCCON','CSRSCRT',  
                                        'PNCCREG','PNCGRP4','PNCRPRT',  
P00533                       'PNCGRP5', 'PNCEXCP','PNCCCON','PNCSCRT',  
P00533                       'CSRCINT', 'PNCCINT','SBRCINT','SEBCINT',  
P00533                       'CSRCEXP', 'PNCCEXP','CSRSTRG','CSRSTEX',  
A00444                       'PNCSTRG', 'PNCSTEX','SEBCEXP','CSRCNRP',  
A04444                       'PNCCNRP', 'SEBCNRP'.                      
               88 CREDIT-JOB                VALUES ARE                  
                                                   'SEB0002','SBR0002', 
A03019                                  'SVC0002', 'CSR0002','PNC0005', 
A03019                       'CSRWP02', 'CSRNP02', 'CSRSV02','PNCFN05', 
A03019                       'PNCWP05', 'PNCNP05', 'SVCWP02','SVCNP02', 
A03019                       'SEBFN02', 'SEBWP02', 'SEBNP02','SBRFN02', 
P00533                       'SBRWP02', 'SBRNP02', 'SBRC325','CSR0003', 
P00533                       'CSRC502', 'CSR621Q', 'CSR635Q','CSRC694', 
P00533                       'PNC621Q', 'PNCC694', 'SEB635Q','SEBC694'. 
A03361         88 LETTER-JOB                VALUES 'CSRSV02','CSR0003', 
A03361                       'CSRC502', 'CSR621Q', 'CSRC694','CSR635Q', 
A03361                       'PNC621Q', 'PNCC694', 'SEBRTCH','SEBRPRC', 
A03361                       'SEB635Q', 'SEBC694', 'SBRC325','SBRRPRC', 
A03361                       'SBRRTCH'.                                 
A03361         88 MKTLTR-JOB                VALUES 'SEBWPMK','SEBNPMK', 
A03361                       'SEBWKIT', 'SEBRPWK', 'SBRWPMK','SBRNPMK', 
A03361                       'SBRWKIT', 'SBRRPWK', 'SEBRPWP','SEBRPNP', 
A03361                       'SBRRPWP', 'SBRRPNP'.                      
A03361         88 NOTICE-JOB                VALUES 'SEBWP02','SEBNP02', 
A03361                       'SEBFN02', 'SBRWP02', 'SBRNP02','SBRFN02', 
A03361                       'SVCWP02', 'SVCNP02', 'CSRWP02','CSRNP02', 
A03361                       'PNCWP05', 'PNCNP05', 'PNCFN05'.           
           05  WS-CURRENT-DATE.                                         
               10  WS-CURRENT-CCYY          PIC 9(04).                  
               10  WS-CURRENT-MM            PIC 9(02).                  
               10  WS-CURRENT-DD            PIC 9(02).                  
               10  WS-CURRENT-HH            PIC 9(02).                  
               10  WS-CURRENT-MS            PIC 9(02).                  
               10  WS-CURRENT-SS            PIC 9(02).                  
           05  WS-CTRL-PARM-STR.                                        
               10  FILLER                   PIC X(08).                  
               10  WS-CONTROL-FLAG          PIC X(01).                  
      *                                                                 02430000
       01  WS-RESTART-DATA.                                             
           05 WS-RESTART-PROCESS-TYPE       PIC 9(01).                  
           05 WS-RESTART-JOB-COMPLETE       REDEFINES                   
              WS-RESTART-PROCESS-TYPE       PIC X(01).                  
           05 WS-RESTART-JOB-STATUS         PIC X(01).                  
              88  WS-RUN-COMPLETED-NO-PROBLEMS       VALUE 'A'.         
              88  WS-RERUN-COMPLETED                 VALUE 'B'.         
              88  WS-RERUN-PENDING                   VALUE 'C'.         
           05 WS-RESTART-COMMON-DATE        PIC X(10).                  
           05 WS-RESTART-CHKP-SEQ-NO        PIC 9(05).                  
           05 WS-RESTART-ACCOUNT-NO         PIC X(13).                  
           05 WS-RESTART-FCSCA166-REC-CNTR  PIC S9(07) COMP-3 VALUE 0.  
      *                                                                 02560000
       01  WS-RPT-HEADER-LINE-1.                                        
           05  FILLER                   PIC X(03)  VALUE SPACES.        
           05  FILLER                   PIC X(07)  VALUE 'DATE: '.      
           05  WS-RPT-DATE              PIC X(10).                      
           05  FILLER                   PIC X(03)  VALUE SPACES.        
           05  FILLER                   PIC X(11)  VALUE 'RUN TIME:  '. 
           05  WS-RPT-RUN-TIME          PIC X(08).                      
P00166     05  WS-RPT-TITLE             PIC X(38).                      
      *                                                                 02650000
       01  WS-RPT-HEADER-LINE-2.                                        
           05  FILLER                   PIC X(02) VALUE SPACES.         
           05  WS-RPT-NAME              PIC X(12) VALUE 'PCSCA166-001'. 
           05  FILLER                   PIC X(20) VALUE SPACES.         
P00166     05  WS-RPT-HEAD              PIC X(38).                      
P00166     05  FILLER                   PIC X(08) VALUE SPACES.         
      *                                                                 02720000
       01  WS-RPT-HEADER-LINE-2A.                                       
           05  FILLER                   PIC X(02) VALUE SPACES.         
           05  WS-RPT-NAME-2A           PIC X(12) VALUE 'PCSCA166-002'. 
           05  FILLER                   PIC X(20) VALUE SPACES.         
P00166     05  WS-RPT-HEAD-2A           PIC X(38).                      
P00166     05  FILLER                   PIC X(08) VALUE SPACES.         
      *                                                                 02790000
A02318 01  WS-RPT-HEADER-LINE-2B.                                       
A02318     05  FILLER                   PIC X(02) VALUE SPACES.         
A02318     05  WS-RPT-NAME-2A           PIC X(12) VALUE 'PCSCA166-003'. 
A02318     05  FILLER                   PIC X(15) VALUE SPACES.         
A02318     05  WS-RPT-HEAD-2B           PIC X(50).                      
A02318     05  FILLER                   PIC X(08) VALUE SPACES.         
      *                                                                 02860000
       01  WS-RPT-HEADER-LINE-3.                                        
A04495     05  FILLER                PIC X(08) VALUE 'JOB_NAME'.        
A04495     05  FILLER                PIC X(02) VALUE SPACES.            
A04495     05  FILLER                PIC X(06) VALUE 'SEQ_NO'.          
A04495     05  FILLER                PIC X(06) VALUE SPACES.            
A04495     05  FILLER                PIC X(10) VALUE 'ACCOUNT_NO'.      
A04495     05  FILLER                PIC X(09) VALUE SPACES.            
A04495     05  FILLER                PIC X(03) VALUE 'UID'.             
A04495     05  FILLER                PIC X(06) VALUE SPACES.            
A04495     05  FILLER                PIC X(09) VALUE 'CORR_TYPE'.       
A04495     05  FILLER                PIC X(21) VALUE SPACES.            
      *                                                                 02980000
       01  WS-RPT-HEADER-LINE-4.                                        
P00166     05  FILLER                   PIC X(80) VALUE ALL '-'.        
      *                                                                 03010000
A02318 01  WS-RPT-HEADER-LINE-5.                                        
A02318     05  FILLER                      PIC X(08) VALUE SPACES.      
A02318     05  FILLER                      PIC X(14)                    
A02318                                     VALUE 'ACCOUNT NUMBER'.      
A02318     05  FILLER                      PIC X(10) VALUE SPACES.      
A02318     05  FILLER                      PIC X(17)                    
A02318                                     VALUE 'UNIQUE IDENTIFIER'.   
A02318     05  FILLER                      PIC X(06) VALUE SPACES.      
A02318     05  FILLER                      PIC X(09)                    
A02318                                     VALUE 'CORR DATE'.           
A02318     05  FILLER                      PIC X(06) VALUE SPACES.      
A02318     05  FILLER                      PIC X(08)                    
A02318                                     VALUE 'JOB NAME'.            
      *                                                                 03150000
       01  WS-RPT-DETAIL-LINE-1.                                        
A04495     05  WS-RPT-JOB-NAME-1           PIC X(07).                   
A04495     05  FILLER                      PIC X(03)  VALUE SPACES.     
A04495     05  WS-RPT-SEQ-NO               PIC X(09).                   
A04495     05  FILLER                      PIC X(03)  VALUE SPACES.     
A04495     05  WS-RPT-ACCOUNT-NBR          PIC X(13).                   
A04495     05  FILLER                      PIC X(03)  VALUE SPACES.     
A04495     05  WS-RPT-UNIQ-ID              PIC X(09).                   
A04495     05  FILLER                      PIC X(03)  VALUE SPACES.     
A04495     05  WS-RPT-CORR-TYPE            PIC X(25).                   
A04495     05  FILLER                      PIC X(05)  VALUE SPACES.     
      *                                                                 03270000
A02318 01  WS-RPT-DETAIL-LINE-NOTFOU.                                   
A02318     05  FILLER                      PIC X(08)  VALUE SPACES.     
A02318     05  WS-RPT-ACCOUNT-NO           PIC X(13).                   
A02318     05  FILLER                      PIC X(14)  VALUE SPACE.      
A02318     05  WS-RPT-BARCODE-UNIQUE-ID    PIC X(09).                   
A02318     05  FILLER                      PIC X(11)  VALUE SPACE.      
A02318     05  WS-RPT-CORR-DATE            PIC X(07)  VALUE SPACES.     
A02318     05  FILLER                      PIC X(08)  VALUE SPACES.     
A02318     05  WS-RPT-JOB-NAME             PIC X(07)  VALUE SPACES.     
      *                                                                 03370000
      *********************************************************         03380000
      *   TABLE TO HOLD SUBS FOR THE CURRENT MASTER PROCESSING*         03390000
      *********************************************************         03400000
       01 WS-SUB-COUNT                     PIC S9(5) COMP-3 VALUE +0.   
       01 WS-SUB-ACCTS-HOLD-TABLE.                                      
           05  WS-SUB-ACCTS-TBL  OCCURS 999999.                         
COB305         10 WS-SUB-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.         
      *                                                                 03450000
     *****************************************************************  03460000
     ** HOST VARIABLE ARRAYS TO DO MULTI FETCH                       *  03470000
     *****************************************************************  03480000
                                                                        
       01 WS-HOLD-MST-SUB-HV.                                           
COB305    05 WS-SUB-ACCOUNT-HV        PIC S9(13)V USAGE COMP-3 
COB305       OCCURS 100 TIMES VALUE 0.   
                                                                        
      *********************************************************         03540000
      *COPYBOOK TO SUPPORT DB2 SQL ERROR CHECKING.            *         03550000
      *********************************************************         03560000
       COPY CWS00303.                                                   03570000
                                                                        
      *********************************************************         03590000
      * COPYBOOK ADDED FOR ERROR HANDLING.                    *         03600000
      *********************************************************         03610000
       COPY CWS00010.                                                   03620000
                                                                        
A02119*********************************************************         03640000
A02119* COPYBOOK ADDED FOR REDUCE EMBEDDED BLANKS             *         03650000
A02119*********************************************************         03660000
A02119 COPY CWS00023.                                                   03670000
                                                                        
      *********************************************************         03690000
      *  CWS09900  ABEND SWITCH COPYBOOK                      *       * 03700000
      *********************************************************         03710000
       COPY CWS09900.                                                   03720000
                                                                        
      *********************************************************         03740000
      *   WS-VARIABLES FOR CPD00038                           *         03750000
      *********************************************************         03760000
       COPY CWS00038.                                                   03770000
       COPY FIOJC01.                                                    03780000
                                                                        
      *********************************************************         03800000
      *   JOBS FILE/TABLE DEFINITIONS                         *         03810000
      *********************************************************         03820000
           COPY FIOCA00.                                                03830000
                                                                        
      *********************************************************         03850000
      *   CA00 WORK DATA                                      *         03860000
      *********************************************************         03870000
       COPY CWS00039.                                                   03880000
                                                                        
           EXEC SQL                                                     03900000
                INCLUDE SQLCA                                           03910000
           END-EXEC.                                                    03920000
                                                                        
      ***********************************************************       03940000
A02318*    CSS_CORR_MAIL_STAT MW                                *       03950000
      ***********************************************************       03960000
             EXEC SQL                                                   03970000
                 INCLUDE TBMAILST                                       03980000
             END-EXEC.                                                  03990000
                                                                        
      *************************************************************     04010000
A02318*    CSS_RESTART RF                                         *     04020000
      *************************************************************     04030000
           EXEC SQL                                                     04040000
              INCLUDE TBRESTRT                                          04050000
           END-EXEC.                                                    04060000
      *                                                                 04070000
      *************************************************************     04080000
A02318*    CSS_JOB_PARM  G6                                       *     04090000
      *************************************************************     04100000
           EXEC SQL                                                     04110000
                INCLUDE TBJBPARM                                        04120000
           END-EXEC.                                                    04130000
      *                                                                 04140000
      *************************************************************     04150000
A02318*    CSS_MNT_TRANS_HIST MH                                  *     04160000
      *************************************************************     04170000
           EXEC SQL                                                     04180000
               INCLUDE TBMNHIST                                         04190000
           END-EXEC.                                                    04200000
      *************************************************************     04210000
A02318*    CSS_MT_TRN_HST_DET   MI                                *     04220000
      *************************************************************     04230000
           EXEC SQL                                                     04240000
               INCLUDE TBMNHDT                                          04250000
           END-EXEC.                                                    04260000
      *************************************************************     04270000
A02318*    CSS_MSTSUB_ACCT  MU                                    *     04280000
      *************************************************************     04290000
           EXEC SQL                                                     04300000
               INCLUDE TBMSTSUB                                         04310000
           END-EXEC.                                                    04320000
      ***********************************************************       04330000
      *  CURSOR TO FETCH SUB ACCOUNTS FOR THE MASTER            *       04340000
      ***********************************************************       04350000
A02318*                                                                 04360000
           EXEC SQL                                                     
                DECLARE MSTSUB CURSOR WITH ROWSET POSITIONING FOR       
                SELECT SUB_ACCT_NO                                      
                FROM CSS_MSTSUB_ACCT WITH(READUNCOMMITTED)                      
                WHERE MST_ACCT_NO      = :MU-MST-ACCT-NO                
              ORDER BY SUB_ACCT_NO                                      
              FOR READ ONLY                                     
A02318                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04370000
MFA-TR*         DECLARE MSTSUB CURSOR WITH ROWSET POSITIONING FOR       04380000
MFA-TR*         SELECT SUB_ACCT_NO                                      04390000
MFA-TR*         FROM CSS_MSTSUB_ACCT                                    04400000
MFA-TR*         WHERE MST_ACCT_NO      = :MU-MST-ACCT-NO                04410000
MFA-TR*       ORDER BY SUB_ACCT_NO                                      04420000
MFA-TR*       FOR FETCH ONLY WITH UR                                    04430000
MFA-TR*       QUERYNO 7500                                              04440000
MFA-TR*    END-EXEC.                                                    04450000
                                                                        
      *                                                                 04470000
      ***********************************************************       04480000
      *  CURSOR TO FETCH SUB ACCOUNTS FROM CSS_CORR_MAIL_STAT   *       04490000
      ***********************************************************       04500000
                                                                        
           EXEC SQL                                                     
                DECLARE SUB_MAIL_STAT CURSOR FOR                        
                SELECT TRACKING_STATUS_CD,                              
A02119                 COMM_TYPE_CODE,                                  
                       BARCODE_UNIQUE_ID                                
                 FROM CSS_CORR_MAIL_STAT WITH(READUNCOMMITTED)                  
                WHERE ACCOUNT_NO = :MW-ACCOUNT-NO                       
                  AND CREATE_DT = IIF(TRY_CONVERT(DATE, :MW-CREATE-DT
              ) IS NULL OR (PATINDEX('%.%', :MW-CREATE-DT
              ) <> 0) OR (LEN(:MW-CREATE-DT) <> 10), CIS.CHAR2DATE(
                                                          :MW-CREATE-DT
              ), CONVERT(DATE, :MW-CREATE-DT) )                         
                  AND (TRACKING_STATUS_CD = 'EH' OR                     
A02003                 TRACKING_STATUS_CD = 'XB' OR                     
                       TRACKING_STATUS_CD LIKE 'P%')                    
                FOR READ ONLY                                   
A02318                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     04520000
MFA-TR*         DECLARE SUB_MAIL_STAT CURSOR FOR                        04530000
MFA-TR*         SELECT TRACKING_STATUS_CD,                              04540000
MFA-TR*                COMM_TYPE_CODE,                                  04550000
MFA-TR*                BARCODE_UNIQUE_ID                                04560000
MFA-TR*          FROM CSS_CORR_MAIL_STAT                                04570000
MFA-TR*         WHERE ACCOUNT_NO = :MW-ACCOUNT-NO                       04580000
MFA-TR*           AND CREATE_DT = :MW-CREATE-DT                         04590000
MFA-TR*           AND (TRACKING_STATUS_CD = 'EH' OR                     04600000
MFA-TR*                TRACKING_STATUS_CD = 'XB' OR                     04610000
MFA-TR*                TRACKING_STATUS_CD LIKE 'P%')                    04620000
MFA-TR*         FOR FETCH ONLY WITH UR                                  04630000
MFA-TR*         QUERYNO 7310                                            04640000
MFA-TR*    END-EXEC.                                                    04650000
                                                                        
      *                                                                 04670000
       LINKAGE SECTION.                                                 
       01  WS-PARM-VALUE.                                               
           03  WS-PARMVAL-LENGTH            PIC S9(04) COMP.            
           03  WS-WQ-INS-SW                 PIC X(01).                  
                                                                        
       PROCEDURE DIVISION USING WS-PARM-VALUE.                          
                                                                        
      ***************************************************************** 04750000
      *    0000-MAINLINE                                             ** 04760000
      ***************************************************************** 04770000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
                                                                        
           IF WS-THIS-IS-A-RESTART                                      
              PERFORM 7100-REPOSITON-REC       THRU 7100-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM 7000-READ-FCSCA166          THRU 7000-EXIT.          
           PERFORM 2100-GET-COMP-DETAIL        THRU 2100-EXIT.          
                                                                        
           PERFORM 1000-PROCESS-ACCOUNTS       THRU 1000-EXIT           
             UNTIL END-OF-FCSCA166.                                     
                                                                        
           PERFORM 2500-RESET-RESTART-DATA     THRU 2500-EXIT.          
           PERFORM 2600-DISPLAY-ACCT-TOTALS    THRU 2600-EXIT.          
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 05020000
      *    0100-INITIALIZATION                                       ** 05030000
      *    OPEN FILE                                                 ** 05040000
      *    CHECK FOR RESTART                                         ** 05050000
      ***************************************************************** 05060000
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           PERFORM 7700-GET-PROCESS-FLAG       THRU 7700-EXIT.          
                                                                        
           OPEN INPUT FCSCA166-FILE.                                    
           IF NOT FCA166-SUCCESSFUL                                     
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZE                  '         
               DISPLAY '**   ERROR OPENING FCSCA166'                    
               DISPLAY '**   FILE STATUS = ' WS-FCA166-STATUS           
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
           OPEN OUTPUT FCSP1661-FILE.                                   
           IF NOT FC1661-SUCCESSFUL                                     
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZE                  '         
               DISPLAY '**   ERROR OPENING FCSC1661'                    
A02318         DISPLAY '**   FILE STATUS = ' WS-F1661-STATUS            
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
           OPEN OUTPUT FCSP1662-FILE.                                   
           IF NOT FC1662-SUCCESSFUL                                     
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZE                  '         
               DISPLAY '**   ERROR OPENING FCSC1662'                    
A02318         DISPLAY '**   FILE STATUS = ' WS-F1662-STATUS            
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
A02318     OPEN OUTPUT FCSP1663-FILE.                                   
A02318     IF NOT FC1663-SUCCESSFUL                                     
A02318         DISPLAY '**************************************'         
A02318         DISPLAY '**   0100-INITIALIZE                  '         
A02318         DISPLAY '**   ERROR OPENING FCSC1663'                    
A02318         DISPLAY '**   FILE STATUS = ' WS-F1663-STATUS            
A02318         DISPLAY '**************************************'         
A02318         PERFORM 9900-ABEND              THRU 9900-EXIT           
A02318     END-IF.                                                      
A02318*                                                                 05510000
    *******GENERATE DATA FOR REPORT HEADING                             05520000
           MOVE FUNCTION CURRENT-DATE(1:14)                             
                                       TO WS-CURRENT-DATE.              
           STRING    WS-CURRENT-MM                                      
                     '-'                                                
                     WS-CURRENT-DD                                      
                     '-'                                                
                     WS-CURRENT-CCYY                                    
                     DELIMITED BY SIZE                                  
                                       INTO WS-RUN-DATE.                
           STRING    WS-CURRENT-CCYY                                    
                     '-'                                                
                     WS-CURRENT-MM                                      
                     '-'                                                
                     WS-CURRENT-DD                                      
                     DELIMITED BY SIZE                                  
                                       INTO WS-RUN-DATE-1.              
           MOVE WS-RUN-DATE            TO WS-RPT-DATE.                  
           STRING    WS-CURRENT-HH                                      
                     ':'                                                
                     WS-CURRENT-MS                                      
                     ':'                                                
                     WS-CURRENT-SS                                      
                     DELIMITED BY SIZE                                  
                                       INTO WS-RPT-RUN-TIME.            
    *******                                                             05770000
                                                                        
           MOVE ZERO                           TO RF-PARTITION-NO       
                                                  RF-DUP-CNTRL-NO.      
           MOVE WS-PGRMNAME                    TO RF-NAME-PROGRAM.      
                                                                        
           PERFORM 6251-GET-FJC01-DATE         THRU 6251-EXIT.          
      *                                                                 05840000
           IF COMMON-DATE-NEEDED                                        
               PERFORM 6240-GET-FCA00-COMMON-DATE                       
                                               THRU 6240-EXIT           
               MOVE WS-FCA00-COMMON-DATE       TO WS-INPUT-DATE         
           END-IF.                                                      
      *                                                                 05900000
           PERFORM 6253-GET-FJC01-CHKP-LIMIT   THRU 6253-EXIT.          
      *                                                                 05920000
           IF WS-CHKP-LUW-LIMIT    = WS-FLAG-TO-TURN-OFF-COMMITS        
             AND WS-CHKP-UPD-LIMIT = WS-FLAG-TO-TURN-OFF-COMMITS        
               SET WS-COMMITS-NOT-REQUIRE      TO TRUE                  
               DISPLAY '********************************************'   
               DISPLAY '**   ' WS-PGRMNAME ' INFORMATIONAL MSG    **'   
               DISPLAY '** JOB PARM INPUTS CHKP-LUW AND CHKP-UPD  **'   
               DISPLAY '** BOTH SET TO ' WS-FLAG-TO-TURN-OFF-COMMITS    
               DISPLAY '** THIS INDICATES THAT INTERIM COMMIT     **'   
               DISPLAY '** POINTS SHOULD NOT BE TAKEN.            **'   
               DISPLAY '********************************************'   
           END-IF.                                                      
      *                                                                 06040000
           PERFORM 6235-GET-FJC01-RESTART-REQ  THRU 6235-EXIT.          
      *                                                                 06060000
           PERFORM 0600-PREPARE-FOR-RESTART    THRU 0600-EXIT.          
      *                                                                 06080000
           PERFORM 0605-VALIDATE-RESTART-REQ   THRU 0605-EXIT.          
      *                                                                 06100000
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  06150000
      **      0600-PREPARE-FOR-RESTART                              **  06160000
      ****************************************************************  06170000
                                                                        
       0600-PREPARE-FOR-RESTART.                                        
      *                                                                 06200000
           MOVE WS-PGRMNAME                    TO RF-NAME-PROGRAM.      
      *                                                                 06220000
           PERFORM 7200-SELECT-RESTART         THRU 7200-EXIT           
      *                                                                 06240000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE RF-RESTART-DATA-TEXT       TO WS-RESTART-DATA       
               IF WS-RESTART-PROCESS-TYPE NUMERIC                       
                   MOVE WS-Y                   TO WS-IS-THIS-A-RESTART  
               END-IF                                                   
           END-IF.                                                      
      *                                                                 06310000
           IF WS-THIS-IS-A-RESTART                                      
              DISPLAY '*********************************************'   
              DISPLAY '*****   THIS IS A RESTART OF PCSCA166   *****'   
              DISPLAY '*********************************************'   
              MOVE WS-RESTART-CHKP-SEQ-NO      TO WS-CHKP-SEQ-NO        
              MOVE WS-RESTART-FCSCA166-REC-CNTR                         
                                               TO WS-ACCOUNTS-READ      
      *                                                                 06390000
              IF WS-RESTART-COMMON-DATE EQUAL WS-INPUT-DATE OR          
                 WS-RESTART-COMMON-DATE EQUAL SPACES                    
                 CONTINUE                                               
              ELSE                                                      
                 DISPLAY '********************************************' 
                 DISPLAY '**COMMON DATE WAS CHANGED PRIOR TO RESTART**' 
                 DISPLAY '********************************************' 
                 DISPLAY '** OLD COMMON DATE = ' WS-RESTART-COMMON-DATE 
                 DISPLAY '** NEW COMMON DATE = ' WS-INPUT-DATE          
                 PERFORM 9900-ABEND            THRU 9900-EXIT           
              END-IF                                                    
           END-IF.                                                      
      *                                                                 06520000
       0600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06550000
      *********************************************************         06560000
      *   0605-VALIDATE-RESTART-REQ                           *         06570000
      *********************************************************         06580000
       COPY CPD00030.                                                   06590000
      *                                                                 06600000
                                                                        
      ***************************************************************** 06620000
      *    1000-PROCESS-ACCOUNTS.                                    ** 06630000
      * THIS WILL LOAD THE ACCOUNTS AND PERFOMRS THE DETAIL LOGIC    ** 06640000
      ***************************************************************** 06650000
                                                                        
       1000-PROCESS-ACCOUNTS.                                           
                                                                        
           MOVE E-FCA166-JOB-NAME        TO WS-HOLD-JOB-NAME.           
           MOVE WS-N                     TO WS-PAGE1-MISSING-SW         
                                            WS-SUB-FOUND-FLAG.          
           MOVE E-FCA166-ACCT-NO(1:10)   TO WS-CUSTOMER-NO              
                                                                        
           INITIALIZE                          MW-TRACKING-STATUS-CD    
                                               MW-BARCODE-UNIQUE-ID     
A04494                                         MW-APPL-PROGRAM-ID       
                                               WS-HOLD-MAIL-TYPE        
A02318                                         WS-ACCT-FOUND-FLAG       
A02318                                         WS-FIRST-THREE-DIGIT     
A02318     MOVE E-FCA166-BARCODE-UNIQUE-ID     TO MW-BARCODE-UNIQUE-ID  
A02318     MOVE MW-BARCODE-UNIQUE-ID(1:3)      TO WS-FIRST-THREE-DIGIT  
           PERFORM 7300-SELECT-CORR-MAIL-STAT  THRU 7300-EXIT           
A02318     IF ACCT-NOT-FOUND                                            
A02318        ADD  +1                          TO WS-ACCTS-NOTFOUND-CNT 
A02318        IF WS-IST-ACCOUNT-NF = 'Y'                                
A02318           PERFORM 7800-GET-MIN-DIGIT    THRU 7800-EXIT           
A02318           MOVE WS-BARCODE-UNIQUE-ID(1:3)                         
A02318                                         TO WS-MIN-BAR-UNIQUE-ID  
A02318        END-IF                                                    
A02318        IF WS-FIRST-THREE-DIGIT >= WS-MIN-BAR-UNIQUE-ID AND       
A02318           E-FCA166-BARCODE-UNIQUE-ID NOT = WS-PREV-UNIQ-ID       
A02318           PERFORM 8450-WRITE-NOTFOU-ACCT  THRU 8450-EXIT         
A02318        END-IF                                                    
A02318     ELSE                                                         
A02318        MOVE MW-TRACKING-STATUS-CD          TO                    
A02318                                           WS-TRACKING-STATUS-CODE
A02318        MOVE MW-CREATE-DT                   TO                    
A02318                                           WS-CREATE-DATE         
A02318        PERFORM 1050-VALIDATE-ANV           THRU 1050-EXIT        
A02318     END-IF.                                                      
                                                                        
           IF WS-COMMITS-REQUIRE                                        
              IF WS-COMMIT-ACCTS-CNT  = WS-CHKP-LUW-LIMIT               
                 PERFORM 8100-ISSUE-COMMIT     THRU 8100-EXIT           
                 MOVE ZERO                     TO WS-COMMIT-ACCTS-CNT   
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE E-FCA166-ACCT-NO               TO WS-PREV-ACCT-NO       
A02318     MOVE E-FCA166-BARCODE-UNIQUE-ID     TO WS-PREV-UNIQ-ID       
           PERFORM 7000-READ-FCSCA166          THRU 7000-EXIT.          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
A02318***************************************************************** 07150000
A02318*    1050-VALIDATE-ANV.                                        ** 07160000
A02318***************************************************************** 07170000
A02318                                                                  
A02318 1050-VALIDATE-ANV.                                               
A02318                                                                  
           IF E-FCA166-ACCT-NO NOT EQUAL TO ZEROES AND                  
              (E-FCA166-ACCT-NO IS NUMERIC OR                           
               WS-CUSTOMER-NO   IS NUMERIC)                             
              IF E-FCA166-ACCT-NO EQUAL TO WS-PREV-ACCT-NO              
                 IF E-FCA166-OMR-MARK = 'C0' AND                        
A04444              (NOT MULTIPLE-JOB OR                                
A04444              E-FCA166-MST-SUB-ID = 'M')                          
                    CONTINUE                                            
                  ELSE                                                  
                    PERFORM 2000-DETAIL-PROCESSING      THRU 2000-EXIT  
                 END-IF                                                 
              ELSE                                                      
                 IF E-FCA166-OMR-MARK = 'C0' AND                        
                    NOT MULTIPLE-JOB                                    
      ****          WRITE FIRST PAGE MISSING REPORT                     07350000
                    PERFORM 8300-WRITE-PAGE1-MISSING-R  THRU 8300-EXIT  
                    SET  PAGE1-MISSING                  TO   TRUE       
                 END-IF                                                 
                 PERFORM 2000-DETAIL-PROCESSING         THRU 2000-EXIT  
              END-IF                                                    
           END-IF.                                                      
                                                                        
A02318 1050-EXIT.                                                       
A02318     EXIT.                                                        
                                                                        
      ***************************************************************** 07460000
      *    2000-DETAIL-PROCESSING.                                   ** 07470000
      * GETS THE STATUS FROM CSS_CORR_MAIL_STAT AND SETS THE         ** 07480000
      * RECONCILED STATUS. IF ALREADY PROCESSED REPORTS AS DUPLICATE.** 07490000
      ***************************************************************** 07500000
                                                                        
       2000-DETAIL-PROCESSING.                                          
                                                                        
           IF WS-TRACKING-STATUS-C1 EQUAL TO 'I' OR 'M' OR 'D'          
*********     WRITE DUPLICATE REPORT                                    07550000
A04494        IF WS-TRACKING-STATUS-C1 = 'M'                            
A04494        AND MW-APPL-PROGRAM-ID = 'CSR04342 '                      
A04494           NEXT SENTENCE                                          
A04494        END-IF                                                    
              IF NOT MULTIPLE-JOB AND                                   
P00166           WS-TRACKING-STATUS-C1 NOT = 'D'                        
A05462           DISPLAY '*******************'                          
A05462           DISPLAY '*** TRACK STATUS = ' MW-TRACKING-STATUS-CD    
A05462           DISPLAY '*** UNIQUE ID    = ' MW-BARCODE-UNIQUE-ID     
A05462           DISPLAY '*** APPL PGM ID  = ' MW-APPL-PROGRAM-ID       
A05462           DISPLAY '*** COMM TYPE CD = ' MW-COMM-TYPE-CODE        
A05462           DISPLAY '*** CREATE DT    = ' MW-CREATE-DT             
A05462           DISPLAY '                   '                          
                 PERFORM 8400-WRITE-ANV-DUPS-R     THRU 8400-EXIT       
              END-IF                                                    
              IF WS-TRACKING-STATUS-C1 = 'D'                            
                 PERFORM 2050-SET-STATUS-CODE      THRU 2050-EXIT       
              END-IF                                                    
           ELSE                                                         
              PERFORM 2050-SET-STATUS-CODE         THRU 2050-EXIT       
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 07700000
      *    2050-SET-STATUS-CODE.                                     ** 07710000
      ***************************************************************** 07720000
                                                                        
       2050-SET-STATUS-CODE.                                            
                                                                        
           IF E-FCA166-RECON-DATA EQUAL TO SPACES                       
              IF E-FCA166-MST-SUB-ID = 'M'                              
                 PERFORM 2200-RECONCILE-MST-SUBS THRU 2200-EXIT         
                 MOVE E-FCA166-BARCODE-UNIQUE-ID TO MW-BARCODE-UNIQUE-ID
              END-IF                                                    
              MOVE 'M'                  TO WS-TRACKING-STATUS-C1        
              MOVE 'MANUALLY'           TO WS-HOLD-MAIL-TYPE            
           ELSE                                                         
              IF E-FCA166-PROCESS-STATE EQUAL TO '0' AND                
                        (NOT PAGE1-MISSING OR MULTIPLE-JOB)             
A04444           IF E-FCA166-MST-SUB-ID = 'M'                           
A04444              PERFORM 2200-RECONCILE-MST-SUBS THRU 2200-EXIT      
A04444              MOVE E-FCA166-BARCODE-UNIQUE-ID                     
A04444                                           TO MW-BARCODE-UNIQUE-ID
A04444           END-IF                                                 
                 MOVE 'I'               TO WS-TRACKING-STATUS-C1        
              ELSE                                                      
                 MOVE 'D'               TO WS-TRACKING-STATUS-C1        
              END-IF                                                    
           END-IF                                                       
           MOVE E-FCA166-ACCT-NO        TO MW-ACCOUNT-NO                
           MOVE WS-TRACKING-STATUS-CODE TO MW-TRACKING-STATUS-CD        
           PERFORM 8000-UPDATE-STATUS-CODE     THRU 8000-EXIT           
                                                                        
           IF WS-TRACKING-STATUS-C1 = ('M' OR 'I')                      
              PERFORM 8500-UPD-TRANS-HIST    THRU 8500-EXIT             
           END-IF.                                                      
                                                                        
       2050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 08070000
      * 2100-GET-COMP-DETAIL.                                         * 08080000
      ***************************************************************** 08090000
                                                                        
       2100-GET-COMP-DETAIL.                                            
                                                                        
           MOVE E-FCA166-JOB-NAME(1:3)         TO WS-JOB-NAME           
           EVALUATE WS-JOB-NAME                                         
              WHEN 'CSR'                                                
              MOVE WS-RPT1-SCEG-TITLE          TO WS-RPT-TITLE          
              WHEN 'PNC'                                                
              MOVE WS-RPT1-PSNC-TITLE          TO WS-RPT-TITLE          
              WHEN 'SEB'                                                
              MOVE WS-RPT1-SEB-TITLE           TO WS-RPT-TITLE          
              WHEN 'SBR'                                                
              MOVE WS-RPT1-SEBR-TITLE          TO WS-RPT-TITLE          
              WHEN 'SVC'                                                
              MOVE WS-RPT1-SVC-TITLE           TO WS-RPT-TITLE          
              WHEN OTHER                                                
              DISPLAY E-FCA166-JOB-NAME                                 
           END-EVALUATE.                                                
      *                                                                 08280000
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08310000
      ***************************************************************** 08320000
      * 2200-RECONCILE-MST-SUBS.                                       *08330000
      ***************************************************************** 08340000
                                                                        
       2200-RECONCILE-MST-SUBS.                                         
      *                                                                 08370000
           MOVE E-FCA166-ACCT-NO               TO MU-MST-ACCT-NO.       
   ****PULL ALL THE SUB ACCOUNTS FOR THE MASTER FROM CSS_MSTSUB_ACCT.   08390000
           INITIALIZE WS-SUB-ACCTS-HOLD-TABLE.                          
           MOVE ZERO                             TO WS-SUB-COUNT.       
           PERFORM 7500-OPEN-MSTSUB-CURSOR     THRU 7500-EXIT.          
                                                                        
           PERFORM 7510-FETCH-MSTSUB-CURSOR    THRU 7510-EXIT           
                            UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.    
                                                                        
           PERFORM 7520-CLOSE-MSTSUB-CURSOR    THRU 7520-EXIT.          
                                                                        
            PERFORM VARYING WS-MISC-IDX FROM 1 BY 1                     
SCA006               UNTIL WS-MISC-IDX > WS-SUB-COUNT OR 
                           WS-SUB-ACCOUNT-NO(WS-MISC-IDX) = ZEROES              
               MOVE WS-SUB-ACCOUNT-NO(WS-MISC-IDX) TO MW-ACCOUNT-NO     
               MOVE WS-CREATE-DATE                 TO MW-CREATE-DT      
               MOVE WS-N                           TO WS-SUB-FOUND-FLAG 
                                                      WS-CURSOR-STATUS  
               PERFORM 7310-OPEN-SUBMAIL-CURSOR    THRU 7310-EXIT       
               PERFORM 7311-FETCH-SUBMAIL-CURSOR   THRU 7311-EXIT       
               PERFORM UNTIL WS-C1-EOC                                  
                 IF SUB-FOUND                                           
                    MOVE MW-TRACKING-STATUS-CD          TO              
                                              WS-TRACK-MS-STATUS-CODE   
                    IF WS-TRACK-MS-STATUS-C1 EQUAL TO 'I' OR 'M'        
                       PERFORM 8400-WRITE-ANV-DUPS-R     THRU 8400-EXIT 
                    ELSE                                                
A04444                 IF E-FCA166-RECON-DATA EQUAL TO SPACES           
A04444                  MOVE 'M'                TO WS-TRACK-MS-STATUS-C1
A04444                  MOVE 'MANUALLY'         TO WS-HOLD-MAIL-TYPE    
A04444                 ELSE                                             
A04444                  MOVE 'I'                TO WS-TRACK-MS-STATUS-C1
A04444                 END-IF                                           
                       MOVE WS-TRACK-MS-STATUS-CODE        TO           
                                               MW-TRACKING-STATUS-CD    
                       PERFORM 8000-UPDATE-STATUS-CODE THRU 8000-EXIT   
                       PERFORM 8500-UPD-TRANS-HIST      THRU 8500-EXIT  
                    END-IF                                              
                 END-IF                                                 
                 PERFORM 7311-FETCH-SUBMAIL-CURSOR THRU 7311-EXIT       
               END-PERFORM                                              
               PERFORM 7312-CLOSE-SUBMAIL-CURSOR   THRU 7312-EXIT       
            END-PERFORM.                                                
           MOVE WS-N                           TO WS-SUB-FOUND-FLAG.    
                                                                        
      *                                                                 08830000
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08860000
A02119* SECOND LETTER IN TRACKING STATUS CODE IS 'S' SAY SECURED BILL   08870000
A02119* SECOND LETTER IN TRACKING STATUS CODE IS 'C' - CIG BILL IN      08880000
A02119* REPORT                                                          08890000
A02119*                                                                 08900000
A02119 2300-GET-SECURED-CIG.                                            
A02119     IF MW-COMM-TYPE-CODE = '11' OR '21' OR '14' OR '24' OR '34'  
P00527                         OR '44' OR '54' OR '15' OR '25'          
A02119        EVALUATE  MW-TRACKING-STATUS-CD(2:1)                      
A02119            WHEN 'A'                                              
A02119              MOVE 'DUPLICATE BILL   '   TO WS-RPT-CORR-TYPE      
A02119            WHEN 'C'                                              
A02119              MOVE 'CIG BILL        '    TO WS-RPT-CORR-TYPE      
A02119            WHEN 'D'                                              
A02119              MOVE 'CREDIT LETTER/NOTICE' TO WS-RPT-CORR-TYPE     
A02119            WHEN 'H'                                              
A02119              MOVE 'SUB BILL '           TO WS-RPT-CORR-TYPE      
A02119            WHEN 'I'                                              
A02119              MOVE 'C/R IMMEDIATE BILL'  TO WS-RPT-CORR-TYPE      
A02119            WHEN 'M'                                              
A02119              MOVE 'MARKETING LETTER  '  TO WS-RPT-CORR-TYPE      
A02119            WHEN 'N'                                              
A02119              MOVE 'REGULAR BILL      '  TO WS-RPT-CORR-TYPE      
A02119            WHEN 'O'                                              
A02119              MOVE 'MEMO BILL         '  TO WS-RPT-CORR-TYPE      
A02119            WHEN 'S'                                              
A02119              MOVE 'SECURED BILL   '     TO WS-RPT-CORR-TYPE      
A02119            WHEN 'T'                                              
A02119              MOVE 'THIRD PARTY BILL '   TO WS-RPT-CORR-TYPE      
A02119            WHEN 'X'                                              
A02119              MOVE 'EXCEPTION BILL   '   TO WS-RPT-CORR-TYPE      
P00527            WHEN 'Z'                                              
P00527              MOVE 'CUSTOMER STATEMENT'  TO WS-RPT-CORR-TYPE      
A02119            WHEN OTHER                                            
A02119              IF MW-COMM-TYPE-CODE = '11' OR '21'                 
A02119                 MOVE 'BILL  '           TO WS-RPT-CORR-TYPE      
A02119              ELSE                                                
A02119                 MOVE 'OTHER  '          TO WS-RPT-CORR-TYPE      
A02119              END-IF                                              
A02119        END-EVALUATE                                              
A02119     ELSE                                                         
A02119        IF WS-CORR-TYPE-CODE  = '1'                               
A02119           MOVE 'BILL  '                 TO WS-RPT-CORR-TYPE      
A02119        ELSE                                                      
A02119           MOVE 'OTHER  '                TO WS-RPT-CORR-TYPE      
A02119        END-IF                                                    
A02119     END-IF.                                                      
A02119                                                                  
A02119 2300-EXIT.                                                       
A02119     EXIT.                                                        
      *                                                                 09360000
      ***************************************************************** 09370000
      * UPGRADE THE JOB-COMPLETE FIELD TO INDICATE SUCCESSFUL COMPLETE* 09380000
      ***************************************************************** 09390000
                                                                        
       2500-RESET-RESTART-DATA.                                         
                                                                        
           MOVE SPACES                      TO WS-RESTART-JOB-COMPLETE. 
           IF WS-THIS-IS-A-RESTART                                      
               MOVE WS-B                       TO WS-RESTART-JOB-STATUS 
           ELSE                                                         
               MOVE WS-A                       TO WS-RESTART-JOB-STATUS 
           END-IF.                                                      
      *                                                                 09490000
           MOVE LENGTH OF WS-RESTART-DATA      TO WS-RESTART-DATA-LENGTH
           MOVE WS-RESTART-DATA                TO RF-RESTART-DATA-TEXT. 
           MOVE WS-RESTART-DATA-LENGTH         TO RF-RESTART-DATA-LEN.  
      *                                                                 09530000
           PERFORM 8200-UPDATE-RESTART         THRU 8200-EXIT.          
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               PERFORM 8210-INSERT-RESTART     THRU 8210-EXIT           
           END-IF.                                                      
                                                                        
           IF WS-RESTART-REQ = WS-Y                                     
              PERFORM 8893-RESET-RESTART-REQ-PARM THRU 8893-EXIT        
           END-IF.                                                      
      *                                                                 09620000
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 09670000
      * DISPLAY ACCT TOTALS.                                          * 09680000
      ***************************************************************** 09690000
                                                                        
       2600-DISPLAY-ACCT-TOTALS.                                        
                                                                        
           DISPLAY '*******************************************'.       
           DISPLAY '*****     PCSCA166 TOTALS            ******'.       
           DISPLAY '*******************************************'.       
           DISPLAY '**ACCOUNTS READ:    ', WS-ACCOUNTS-READ             
           DISPLAY '**ACCOUNTS UPDATED: ', WS-ACCTS-UPDATED             
A02318     DISPLAY '**ACCOUNTS NOTFOUND:', WS-ACCTS-NOTFOUND-CNT        
           DISPLAY '*******************************************'.       
           DISPLAY '*******************************************'.       
      *                                                                 09810000
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09840000
A02318****************************************************************  09850000
A02318*  5000-MOVE-NOTFOUND-ACCTS.                                   *  09860000
A02318****************************************************************  09870000
A02318 5000-MOVE-NOTFOUND-ACCTS.                                        
A02318*                                                                 09890000
A02318     MOVE E-FCA166-ACCT-NO           TO WS-RPT-ACCOUNT-NO         
A02318     MOVE E-FCA166-BARCODE-UNIQUE-ID TO WS-RPT-BARCODE-UNIQUE-ID  
A02318     MOVE E-FCA166-CORR-DATE         TO WS-RPT-CORR-DATE          
A02318     MOVE E-FCA166-JOB-NAME          TO WS-RPT-JOB-NAME.          
A02318*                                                                 09940000
A02318 5000-EXIT.                                                       
A02318     EXIT.                                                        
      *                                                                 09970000
A02119************************************************************      09980000
A02119*  6010-REDUCE-EMBEDDED-SPACES                             *      09990000
A02119************************************************************      10000000
A02119                                                                  
A02119 COPY CPD00004.                                                   10020000
                                                                        
      ***************************************************************** 10040000
      * 6253-GET-FJC01-CHKP-LIMIT                                     * 10050000
      ***************************************************************** 10060000
            EXEC SQL                                                    10070000
                INCLUDE CPD00034                                        10080000
            END-EXEC.                                                   10090000
                                                                        
      ***************************************************************** 10110000
      * 6251-GET-FJC01-DATE                                           * 10120000
      ***************************************************************** 10130000
        COPY CPD00037.                                                  10140000
                                                                        
      ***************************************************************** 10160000
      * 6240-GET-FCA00-COMMON-DATE                                    * 10170000
      ***************************************************************** 10180000
              COPY CPD00040.                                            10190000
                                                                        
      ***************************************************************** 10210000
      * 6235-GET-FJC01-RESTART-REQ.                                   * 10220000
      ***************************************************************** 10230000
           EXEC SQL                                                     10240000
              INCLUDE CPD00035                                          10250000
           END-EXEC.                                                    10260000
      *                                                                 10270000
           EXEC SQL                                                     10280000
             INCLUDE CPD00038                                           10290000
           END-EXEC.                                                    10300000
      *                                                                 10310000
           EXEC SQL                                                     10320000
             INCLUDE CPD00039                                           10330000
           END-EXEC.                                                    10340000
      *                                                                 10350000
      ****************************************************************  10360000
      ** 7000-READ-FCSCA166.                                        **  10370000
      ** READ THE INPUT FILE FCSCA166.                              **  10380000
      ****************************************************************  10390000
      *                                                                 10400000
       7000-READ-FCSCA166.                                              
                                                                        
           READ FCSCA166-FILE                                           
               AT END                                                   
                  MOVE WS-Y                       TO WS-FCSCA166-FLAG.  
           IF FCA166-SUCCESSFUL                                         
              ADD  +1                             TO WS-ACCOUNTS-READ   
           ELSE                                                         
              IF END-OF-FCSCA166                                        
                 CONTINUE                                               
              ELSE                                                      
                 DISPLAY '7000-ERROR ON FCSCA166 READ'                  
                 DISPLAY 'PROCESSING TERMINATED'                        
                 PERFORM 9900-ABEND               THRU 9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 10610000
      * 7100-REPOSITON-REC                                              10620000
      ***************************************************************** 10630000
                                                                        
       7100-REPOSITON-REC.                                              
                                                                        
           PERFORM WS-ACCOUNTS-READ TIMES                               
              READ FCSCA166-FILE                                        
              IF FCA166-SUCCESSFUL                                      
                 ADD  +1                       TO WS-ACCTS-UPDATED      
              ELSE                                                      
                 DISPLAY '7100-ERROR ON FIOBE24 RESTART READ'           
                 DISPLAY 'PROCESSING TERMINATED'                        
                 PERFORM 9900-ABEND            THRU 9900-EXIT           
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                 10770000
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10800000
      ***************************************************************** 10810000
      * 7200-SELECT-RESTART.                                          * 10820000
      ***************************************************************** 10830000
      *                                                                 10840000
       7200-SELECT-RESTART.                                             
      *                                                                 10860000
            MOVE '7200'                        TO WS-ACTIVE-PARAGRAPH.  
      *                                                                 10880000
            EXEC SQL                                                    
               SELECT RESTART_DATA                                      
                 INTO :RF-RESTART-DATA                                  
                 FROM CSS_RESTART WITH(READUNCOMMITTED)                         
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                   
                  AND PARTITION_NO = :RF-PARTITION-NO                   
                  AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
                                                                 
A02318                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                    10890000
MFA-TR*        SELECT RESTART_DATA                                      10900000
MFA-TR*          INTO :RF-RESTART-DATA                                  10910000
MFA-TR*          FROM CSS_RESTART                                       10920000
MFA-TR*         WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                   10930000
MFA-TR*           AND PARTITION_NO = :RF-PARTITION-NO                   10940000
MFA-TR*           AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   10950000
MFA-TR*           WITH UR                                               10960000
MFA-TR*           QUERYNO 7200                                          10970000
MFA-TR*     END-EXEC.                                                   10980000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 10990000
            MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE.
      *                                                                 11010000
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
                CONTINUE                                                
            ELSE                                                        
                DISPLAY '**   ERROR ON 7200-SELECT-RESTART   **'        
                DISPLAY '**   RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
A02318          DISPLAY 'NAME PROGRAM = ' RF-NAME-PROGRAM               
A02318          DISPLAY 'PARTITION NO = ' RF-PARTITION-NO               
A02318          DISPLAY 'DUP CNTRL NO = ' RF-DUP-CNTRL-NO               
                DISPLAY '**       PROCESSING TERMINATED      **'        
                PERFORM 9900-ABEND             THRU 9900-EXIT           
            END-IF.                                                     
      *                                                                 11130000
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11160000
      ***************************************************************** 11170000
      * 7300-SELECT-CORR-MAIL-STAT.                                   * 11180000
      ***************************************************************** 11190000
      *                                                                 11200000
       7300-SELECT-CORR-MAIL-STAT.                                      
      *                                                                 11220000
            MOVE '7300'                        TO WS-ACTIVE-PARAGRAPH.  
      *                                                                 11240000
            EXEC SQL                                                    
               SELECT TRACKING_STATUS_CD,                               
A02119                COMM_TYPE_CODE,                                   
A04494                CREATE_DT,                                        
                      APPL_PROGRAM_ID                                   
                 INTO :MW-TRACKING-STATUS-CD,                           
A02119                :MW-COMM-TYPE-CODE,                               
                      :MW-CREATE-DT,                                    
A04494                :MW-APPL-PROGRAM-ID                               
                 FROM CSS_CORR_MAIL_STAT WITH(READUNCOMMITTED)                  
                WHERE BARCODE_UNIQUE_ID = :MW-BARCODE-UNIQUE-ID         
                                                                 
A02318                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                    11250000
MFA-TR*        SELECT TRACKING_STATUS_CD,                               11260000
MFA-TR*               COMM_TYPE_CODE,                                   11270000
MFA-TR*               CREATE_DT,                                        11280000
MFA-TR*               APPL_PROGRAM_ID                                   11281000
MFA-TR*          INTO :MW-TRACKING-STATUS-CD,                           11290000
MFA-TR*               :MW-COMM-TYPE-CODE,                               11300000
MFA-TR*               :MW-CREATE-DT,                                    11310000
MFA-TR*               :MW-APPL-PROGRAM-ID                               11311000
MFA-TR*          FROM CSS_CORR_MAIL_STAT                                11320000
MFA-TR*         WHERE BARCODE_UNIQUE_ID = :MW-BARCODE-UNIQUE-ID         11330000
MFA-TR*         WITH UR                                                 11340000
MFA-TR*         QUERYNO 7300                                            11350000
MFA-TR*     END-EXEC.                                                   11360000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11370000
A02318      MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.       
                                                                        
A02318      IF WS-ACTIVE-RETURN-CODE    EQUAL SUCCESSFUL-CALL           
A02318         MOVE 'Y'                 TO WS-ACCT-FOUND-FLAG           
A02318      ELSE                                                        
A02318         IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
A02318            MOVE 'N'              TO WS-ACCT-FOUND-FLAG           
A02318         ELSE                                                     
A02318            DISPLAY '**   ERROR ON 7300-SELECT-CORR-MAIL-STAT **' 
A02318            DISPLAY '**   RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
A02318            DISPLAY '**   UNIQ ID     = ' MW-BARCODE-UNIQUE-ID    
A02318            DISPLAY '**       PROCESSING TERMINATED           **' 
A02318            PERFORM 9900-ABEND             THRU 9900-EXIT         
A02318         END-IF                                                   
A02318      END-IF.                                                     
      *                                                                 11530000
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11560000
      ******************************************************************11570000
      *   OPEN SUB_MAIL_ST CURSOR                                      *11580000
      ******************************************************************11590000
                                                                        
       7310-OPEN-SUBMAIL-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
                OPEN SUB_MAIL_STAT                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '****** 7310-OPEN-SUBMAIL-CURSOR    *****'        
              DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'            
              DISPLAY ' ** ERROR ON OPEN   '                            
              DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE          
              DISPLAY ' ** TABLE CSS_CORR_MAIL_STAT '                   
              DISPLAY ' ** ACCOUNT_NO     '  MW-ACCOUNT-NO              
A02318        DISPLAY ' ** CREATE DATE    '  MW-CREATE-DT               
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11830000
      * FETCH  JOBPARM-C1  CURSOR                                      *11840000
      ******************************************************************11850000
       7311-FETCH-SUBMAIL-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
                FETCH                                                   
                       SUB_MAIL_STAT                                    
                 INTO                                                   
                      :MW-TRACKING-STATUS-CD                            
A02119               ,:MW-COMM-TYPE-CODE                                
                     ,:MW-BARCODE-UNIQUE-ID                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO                      
                                                WS-ACTIVE-RETURN-CODE.  
           EVALUATE TRUE                                                
               WHEN WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    MOVE WS-Y                       TO WS-SUB-FOUND-FLAG
               WHEN WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                    SET  WS-C1-EOC              TO    TRUE              
               WHEN OTHER                                               
                    DISPLAY '********** PCSCA166 ABORT  ************'   
                    DISPLAY '* 7311-FETCH-SUBMAIL.          *'          
                    DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'      
                    DISPLAY ' ** ERROR ON OPEN   '                      
                    DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE    
                    DISPLAY ' ** TABLE CSS_CORR_MAIL_STAT '             
                    DISPLAY ' ** ACCOUNT_NO     '  MW-ACCOUNT-NO        
A02318              DISPLAY ' ** CREATE_DATE    '  MW-CREATE-DT         
                    PERFORM 9900-ABEND          THRU 9900-EXIT          
           END-EVALUATE.                                                
                                                                        
       7311-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12180000
      ******************************************************************12190000
      *   CLOSE SUB_MAIL_STAT                                          *12200000
      ******************************************************************12210000
                                                                        
       7312-CLOSE-SUBMAIL-CURSOR.                                       
                                                                        
      *                                                                 12250000
           EXEC SQL                                                     
                CLOSE SUB_MAIL_STAT                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12290000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '****** 7312-CLOSE-SUBMAIL-CURSOR '               
              DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'            
              DISPLAY ' ** ERROR ON CLOSE  '                            
              DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE          
              DISPLAY ' ** TABLE CSS_CORR_MAIL_STAT '                   
              DISPLAY ' ** ACCOUNT_NO     '  MW-ACCOUNT-NO              
A02318        DISPLAY ' ** CREATE_DATE    '  MW-CREATE-DT               
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7312-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************12460000
      *      GET CURRENT TIMESTAMP                                     *12470000
      ******************************************************************12480000
       7400-GET-TIMESTAMP.                                              
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TIMESTAMP                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     12510000
MFA-TR*        SET: WS-TIMESTAMP = CURRENT TIMESTAMP                    12520000
MFA-TR*    END-EXEC.                                                    12530000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
A02318        DISPLAY '** ERROR IN 7400-GET-TIMESTAMP           **'     
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '**        PROCESSING IS TERMINATED       **'     
              DISPLAY '** ACCOUNT NO ' E-FCA166-ACCT-NO                 
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12710000
      ******************************************************************12720000
      *   OPEN MSTSUB CURSOR TO PULL ALL THE SUBS FOR MASTER           *12730000
      ******************************************************************12740000
                                                                        
       7500-OPEN-MSTSUB-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
                OPEN MSTSUB                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '****** 7500-OPEN-MSTSUB-CURSOR  '                
              DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'            
              DISPLAY ' ** ERROR ON OPEN   '                            
              DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE          
              DISPLAY ' ** TABLE CSS_MSTSUB_ACCT  '                     
              DISPLAY ' ** ACCOUNT_NO     '  MU-MST-ACCT-NO             
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************12970000
      *   FETCH FROM MSTSUB CURSOR AND STORE IT IN ARRAY               *12980000
      ******************************************************************12990000
                                                                        
       7510-FETCH-MSTSUB-CURSOR.                                        
                                                                        
           INITIALIZE                             WS-HOLD-MST-SUB-HV.   
           MOVE 0                              TO WS-SUB-ROW-COUNT      

MSQ008     MOVE 100 TO MSQ008-MSTSUB
           EXEC SQL                                                     
               FOR :MSQ008-MSTSUB
              FETCH 
              FROM MSTSUB  INTO          
                     :WS-SUB-ACCOUNT-HV                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                     13050000
MFA-TR*        FETCH NEXT ROWSET FROM MSTSUB FOR 100 ROWS INTO          13060000
MFA-TR*              :WS-SUB-ACCOUNT-HV                                 13070000
MFA-TR*    END-EXEC.                                                    13080000

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-MSTSUB
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
               WHEN 354                                                 
                   EXEC SQL GET DIAGNOSTICS                             
MSQ012                   :MFA-GD-ROW-COUNT = ROW_COUNT                  
                   END-EXEC                                             

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*            EXEC SQL GET DIAGNOSTICS                             13150000
MFA-TR*                  :WS-SUB-ROW-COUNT = ROW_COUNT                  13160000
MFA-TR*            END-EXEC                                             13170000
MSQ012             MOVE MFA-GD-ROW-COUNT TO WS-SUB-ROW-COUNT
                   MOVE 1 TO WS-MISC-IDX                                
                   PERFORM UNTIL WS-MISC-IDX > 100                      
                              OR WS-MISC-IDX > WS-SUB-ROW-COUNT         
                      ADD 1                      TO WS-SUB-COUNT        
                      MOVE WS-SUB-ACCOUNT-HV(WS-MISC-IDX)   TO          
                           WS-SUB-ACCOUNT-NO(WS-SUB-COUNT)              
                      ADD 1                      TO WS-MISC-IDX         
                   END-PERFORM                                          
                   IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
                      CONTINUE                                          
                   END-IF                                               
               WHEN OTHER                                               
                    DISPLAY '****** 7510-FETCH-MSTSUB-CURSOR   '        
                    DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'      
                    DISPLAY ' ** ERROR ON FETCH  '                      
                    DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE    
                    DISPLAY ' ** TABLE CSS_MSTSUB_ACCT '                
                    DISPLAY ' ** ACCOUNT_NO     '  MU-MST-ACCT-NO       
                    PERFORM 9900-ABEND         THRU 9900-EXIT           
           END-EVALUATE.                                                
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************13420000
      *   CLOSE MSTSUB                                                 *13430000
      ******************************************************************13440000
                                                                        
       7520-CLOSE-MSTSUB-CURSOR.                                        
                                                                        
      *                                                                 13480000
           EXEC SQL                                                     
                CLOSE MSTSUB                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13520000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '****** 7520-CLOSE-MSTSUB-CURSOR  '               
              DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'            
              DISPLAY ' ** ERROR ON CLOSE  '                            
              DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE          
              DISPLAY ' ** TABLE CSS_MSTSUB_ACCT '                      
              DISPLAY ' ** ACCOUNT_NO     '  MU-MST-ACCT-NO             
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13670000
      ***************************************************************** 13680000
      * 7700-GET-PROCESS-FLAG                                           13690000
      ***************************************************************** 13700000
                                                                        
       7700-GET-PROCESS-FLAG.                                           
                                                                        
           EXEC SQL                                                     
                SELECT                                                  
                      G6.PARM_DATA                                      
                  INTO :G6-PARM-DATA                                    
                  FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                    
                 WHERE G6.PROGRAM_NAME = 'SCSCA165'                     
                   AND G6.COMPANY_NO   = '01'                           
                   AND G6.CMND_CODE    = 'PARM'                         
                   AND G6.STATUS       = 'A'                            
                                                                 
A02318                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13740000
MFA-TR*         SELECT                                                  13750000
MFA-TR*               G6.PARM_DATA                                      13760000
MFA-TR*           INTO :G6-PARM-DATA                                    13770000
MFA-TR*           FROM CSS_JOB_PARM G6                                  13780000
MFA-TR*          WHERE G6.PROGRAM_NAME = 'SCSCA165'                     13790000
MFA-TR*            AND G6.COMPANY_NO   = '01'                           13800000
MFA-TR*            AND G6.CMND_CODE    = 'PARM'                         13810000
MFA-TR*            AND G6.STATUS       = 'A'                            13820000
MFA-TR*           WITH UR                                               13830000
MFA-TR*           QUERYNO 7700                                          13840000
MFA-TR*    END-EXEC.                                                    13850000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE G6-PARM-DATA             TO WS-CTRL-PARM-STR         
              IF WS-CONTROL-FLAG = 'N'                                  
                 DISPLAY '******************************************'   
                 DISPLAY '****PROCESS FLAG IS N, STOP PROCESSING****'   
                 DISPLAY '******************************************'   
                 STOP RUN                                               
              ELSE                                                      
                 CONTINUE                                               
              END-IF                                                    
           ELSE                                                         
               DISPLAY '*** IN 7700 GET PROCESS FLAG *****'             
               DISPLAY '*** SQL CODE    = ' WS-ACTIVE-RETURN-CODE       
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 14040000
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14070000
A02318***************************************************************** 14080000
A02318* 7800-GET-MIN-DIGIT                                              14090000
A02318***************************************************************** 14100000
A02318 7800-GET-MIN-DIGIT.                                              
A02318                                                                  
A02318      EXEC SQL                                                    
A02318          SELECT MIN(MW.BARCODE_UNIQUE_ID)                        
A02318            INTO :WS-BARCODE-UNIQUE-ID                            
A02318          FROM   CSS_CORR_MAIL_STAT MW WITH(READUNCOMMITTED)              
A02318                                                           
A02318                                                      
A02318      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                    14130000
MFA-TR*         SELECT MIN(MW.BARCODE_UNIQUE_ID)                        14140000
MFA-TR*           INTO :WS-BARCODE-UNIQUE-ID                            14150000
MFA-TR*         FROM   CSS_CORR_MAIL_STAT MW                            14160000
MFA-TR*         WITH UR                                                 14170000
MFA-TR*         QUERYNO 7800                                            14180000
MFA-TR*     END-EXEC.                                                   14190000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02318                                                                  
A02318      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
A02318*                                                                 14220000
A02318      IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
A02318          MOVE 'N' TO WS-IST-ACCOUNT-NF                           
A02318      ELSE                                                        
A02318          DISPLAY '**   ERROR ON 7800-GET-MIN-DIGIT    **'        
A02318          DISPLAY '**   RETURN CODE   = ' WS-ACTIVE-RETURN-CODE   
A02318          DISPLAY '**   BAR-UNIQUE-ID = ' WS-BARCODE-UNIQUE-ID    
A02318          DISPLAY '**       PROCESSING TERMINATED      **'        
A02318          PERFORM 9900-ABEND             THRU 9900-EXIT           
A02318      END-IF.                                                     
A02318*                                                                 14320000
A02318 7800-EXIT.                                                       
A02318     EXIT.                                                        
      ****************************************************************  14350000
      ** 8000-UPDATE-STATUS-CODE.                                   **  14360000
      ** UPDATE TRACKING STATUS CODE IN CSS_CORR_MAIL_STAT          **  14370000
      ****************************************************************  14380000
                                                                        
       8000-UPDATE-STATUS-CODE.                                         
                                                                        
           MOVE WS-PGRMNAME(1:9)               TO MW-APPL-PROGRAM-ID.   
                                                                        
           IF CREDIT-JOB                                                
              EXEC SQL                                                  
                   UPDATE CSS_CORR_MAIL_STAT                            
                     SET TRACKING_STATUS_CD  = :MW-TRACKING-STATUS-CD   
                        ,APPL_PROGRAM_ID     = :MW-APPL-PROGRAM-ID      
                        ,LAST_UPDATE_TS      = CIS.CURRENT$TIMESTAMP()        
                   WHERE BARCODE_UNIQUE_ID = :MW-BARCODE-UNIQUE-ID      
              END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*       EXEC SQL                                                  14450000
MFA-TR*            UPDATE CSS_CORR_MAIL_STAT                            14460000
MFA-TR*              SET TRACKING_STATUS_CD  = :MW-TRACKING-STATUS-CD   14470000
MFA-TR*                 ,APPL_PROGRAM_ID     = :MW-APPL-PROGRAM-ID      14480000
MFA-TR*                 ,LAST_UPDATE_TS      = CURRENT TIMESTAMP        14490000
MFA-TR*            WHERE BARCODE_UNIQUE_ID = :MW-BARCODE-UNIQUE-ID      14500000
MFA-TR*       END-EXEC                                                  14510000
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
           ELSE                                                         
              EXEC SQL                                                  
                   UPDATE CSS_CORR_MAIL_STAT                            
                     SET TRACKING_STATUS_CD  = :MW-TRACKING-STATUS-CD   
                        ,APPL_PROGRAM_ID     = :MW-APPL-PROGRAM-ID      
                        ,LAST_UPDATE_TS      = CIS.CURRENT$TIMESTAMP()        
                   WHERE BARCODE_UNIQUE_ID = :MW-BARCODE-UNIQUE-ID      
                     AND ACCOUNT_NO        = :MW-ACCOUNT-NO             
              END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*       EXEC SQL                                                  14530000
MFA-TR*            UPDATE CSS_CORR_MAIL_STAT                            14540000
MFA-TR*              SET TRACKING_STATUS_CD  = :MW-TRACKING-STATUS-CD   14550000
MFA-TR*                 ,APPL_PROGRAM_ID     = :MW-APPL-PROGRAM-ID      14560000
MFA-TR*                 ,LAST_UPDATE_TS      = CURRENT TIMESTAMP        14570000
MFA-TR*            WHERE BARCODE_UNIQUE_ID = :MW-BARCODE-UNIQUE-ID      14580000
MFA-TR*              AND ACCOUNT_NO        = :MW-ACCOUNT-NO             14590000
MFA-TR*       END-EXEC                                                  14600000
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
           END-IF.                                                      
                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
A03019         IF SQLCODE = 100                                         
A03019            PERFORM 8450-WRITE-NOTFOU-ACCT  THRU 8450-EXIT        
A03019       ELSE                                                       
                  DISPLAY '*** IN 8000 UPDATE CORR MAIL STAT*****'      
                  DISPLAY '*** SQL CODE    = ' WS-ACTIVE-RETURN-CODE    
                  DISPLAY '*** ACCOUNT #   = ' MW-ACCOUNT-NO            
                  DISPLAY '*** UNIQUE ID   = ' MW-BARCODE-UNIQUE-ID     
                  DISPLAY '*** STATUS      = ' MW-TRACKING-STATUS-CD    
                  DISPLAY '*** LAST UPD TS = ' MW-LAST-UPDATE-TS        
                  PERFORM 9900-ABEND               THRU 9900-EXIT       
                END-IF                                                  
           END-IF.                                                      
                                                                        
           ADD  +1                             TO WS-ACCTS-UPDATED      
                                                  WS-COMMIT-ACCTS-CNT.  
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14840000
      ***************************************************************** 14850000
      * 8100-ISSUE-COMMIT.                                            * 14860000
      ***************************************************************** 14870000
      *                                                                 14880000
       8100-ISSUE-COMMIT.                                               
      *                                                                 14900000
           MOVE 1                           TO WS-RESTART-PROCESS-TYPE. 
           ADD 1                            TO WS-CHKP-SEQ-NO.          
           MOVE WS-CHKP-SEQ-NO              TO WS-RESTART-CHKP-SEQ-NO.  
           MOVE WS-C                        TO WS-RESTART-JOB-STATUS.   
           MOVE WS-INPUT-DATE               TO WS-RESTART-COMMON-DATE.  
           MOVE WS-ACCOUNTS-READ            TO                          
                                           WS-RESTART-FCSCA166-REC-CNTR.
           MOVE E-FCA166-ACCT-NO            TO WS-RESTART-ACCOUNT-NO.   
           MOVE LENGTH OF WS-RESTART-DATA   TO WS-RESTART-DATA-LENGTH.  
      *                                                                 15000000
           MOVE WS-RESTART-DATA             TO RF-RESTART-DATA-TEXT.    
           MOVE WS-RESTART-DATA-LENGTH      TO RF-RESTART-DATA-LEN.     
      *                                                                 15030000
           PERFORM 8200-UPDATE-RESTART      THRU 8200-EXIT.             
      *                                                                 15050000
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               PERFORM 8210-INSERT-RESTART  THRU 8210-EXIT              
           END-IF.                                                      
      *                                                                 15090000
           EXEC SQL                                                     15100000
                INCLUDE CPD00047                                        15110000
           END-EXEC                                                     15120000
      *                                                                 15130000
           DISPLAY 'COMMIT POINT # ' WS-CHKP-SEQ-NO ' TAKEN.' .         
      *                                                                 15150000
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15180000
      ***************************************************************** 15190000
      * 8200-UPDATE-RESTART.                                          * 15200000
      ***************************************************************** 15210000
      *                                                                 15220000
       8200-UPDATE-RESTART.                                             
      *                                                                 15240000
            MOVE '8200'                        TO WS-ACTIVE-PARAGRAPH.  
      *                                                                 15260000
            EXEC SQL                                                    
               UPDATE CSS_RESTART                                       
                  SET RESTART_DATA = :RF-RESTART-DATA                   
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                   
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15320000
            MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE.
      *                                                                 15340000
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
                CONTINUE                                                
            ELSE                                                        
                DISPLAY '**   ERROR ON 8200-UPDATE-RESTART   **'        
                DISPLAY '**   RETURN CODE  = ' WS-ACTIVE-RETURN-CODE    
A02318          DISPLAY '**   NAME PROGRAM = ' RF-NAME-PROGRAM          
                DISPLAY '**       PROCESSING TERMINATED      **'        
                PERFORM 9900-ABEND             THRU 9900-EXIT           
            END-IF.                                                     
      *                                                                 15440000
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15470000
      ***************************************************************** 15480000
      * 8210-INSERT-RESTART.                                          * 15490000
      ***************************************************************** 15500000
      *                                                                 15510000
       8210-INSERT-RESTART.                                             
      *                                                                 15530000
            MOVE '8210'                        TO WS-ACTIVE-PARAGRAPH.  
      *                                                                 15550000
            EXEC SQL                                                    
               INSERT INTO CSS_RESTART                                  
                           (NAME_PROGRAM,                               
                            PARTITION_NO,                               
                            DUP_CNTRL_NO,                               
                            RESTART_DATA)                               
               VALUES      (:RF-NAME-PROGRAM,                           
                            :RF-PARTITION-NO,                           
                            :RF-DUP-CNTRL-NO,                           
                            :RF-RESTART-DATA)                           
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15670000
            MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE.
      *                                                                 15690000
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
                CONTINUE                                                
            ELSE                                                        
                DISPLAY '**   ERROR ON 8210-INSERT-RESTART   **'        
                DISPLAY '**   RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
                DISPLAY '**       PROCESSING TERMINATED      **'        
                PERFORM 9900-ABEND             THRU 9900-EXIT           
            END-IF.                                                     
      *                                                                 15780000
       8210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15810000
      ***************************************************************** 15820000
      ** 8300-WRITE-PAGE1-MISSING-R.                                  * 15830000
      ***************************************************************** 15840000
       8300-WRITE-PAGE1-MISSING-R.                                      
      *                                                                 15860000
           IF FIRST-ACCT-REP1                                           
              MOVE WS-RPT1-HEAD                TO WS-RPT-HEAD           
              WRITE WS-PRT1661-RECORD          FROM WS-RPT-HEADER-LINE-1
              WRITE WS-PRT1661-RECORD          FROM WS-BLANK-LINE       
              WRITE WS-PRT1661-RECORD          FROM WS-RPT-HEADER-LINE-2
              WRITE WS-PRT1661-RECORD          FROM WS-BLANK-LINE       
              WRITE WS-PRT1661-RECORD          FROM WS-RPT-HEADER-LINE-3
              WRITE WS-PRT1661-RECORD          FROM WS-RPT-HEADER-LINE-4
              MOVE  WS-N                       TO WS-FIRST-ACCT-REP1-SW 
           END-IF                                                       
                                                                        
A02119     INITIALIZE WS-RPT-CORR-TYPE.                                 
                                                                        
           MOVE E-FCA166-ACCT-NO               TO WS-RPT-ACCOUNT-NBR    
           MOVE E-FCA166-BARCODE-UNIQUE-ID     TO WS-RPT-UNIQ-ID        
A04495     MOVE E-FCA166-JOB-NAME              TO WS-RPT-JOB-NAME-1     
A04495     MOVE E-FCA166-SEQ-NO                TO WS-RPT-SEQ-NO         
A02119     MOVE MW-COMM-TYPE-CODE(2:1)         TO WS-CORR-TYPE-CODE     
A02119     EVALUATE WS-CORR-TYPE-CODE                                   
A02119         WHEN '1'                                                 
A02119              PERFORM 2300-GET-SECURED-CIG  THRU 2300-EXIT        
A02119         WHEN '2'                                                 
A02119              MOVE 'NON-MARKETING '      TO WS-RPT-CORR-TYPE      
A02119         WHEN '3'                                                 
A02119              MOVE 'MKTG/BP LETTERS'     TO WS-RPT-CORR-TYPE      
A02119         WHEN '4'                                                 
A02119              PERFORM 2300-GET-SECURED-CIG  THRU 2300-EXIT        
P00527         WHEN '5'                                                 
P00527              MOVE 'CUSTOMER STATEMENT'  TO WS-RPT-CORR-TYPE      
A02119     END-EVALUATE.                                                
           WRITE WS-PRT1661-RECORD            FROM WS-RPT-DETAIL-LINE-1.
      *                                                                 16180000
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16210000
      ***************************************************************** 16220000
      ** 8400-WRITE-ANV-DUPS-R.                                       * 16230000
      ***************************************************************** 16240000
       8400-WRITE-ANV-DUPS-R.                                           
      *                                                                 16260000
           IF FIRST-ACCT-REP2                                           
              MOVE WS-RPT2-HEAD                TO WS-RPT-HEAD-2A        
              WRITE WS-PRT1662-RECORD          FROM WS-RPT-HEADER-LINE-1
              WRITE WS-PRT1662-RECORD          FROM WS-BLANK-LINE       
              WRITE WS-PRT1662-RECORD         FROM WS-RPT-HEADER-LINE-2A
              WRITE WS-PRT1662-RECORD          FROM WS-BLANK-LINE       
              WRITE WS-PRT1662-RECORD          FROM WS-RPT-HEADER-LINE-3
              WRITE WS-PRT1662-RECORD          FROM WS-RPT-HEADER-LINE-4
              MOVE  WS-N                       TO WS-FIRST-ACCT-REP2-SW 
           END-IF                                                       
                                                                        
A02119     INITIALIZE WS-RPT-CORR-TYPE.                                 
A02119     MOVE MW-COMM-TYPE-CODE(2:1)         TO WS-CORR-TYPE-CODE     
A02119     EVALUATE WS-CORR-TYPE-CODE                                   
A02119         WHEN '1'                                                 
A02119              PERFORM 2300-GET-SECURED-CIG  THRU 2300-EXIT        
A02119         WHEN '2'                                                 
A02119              MOVE 'NON-MARKETING '      TO WS-RPT-CORR-TYPE      
A02119         WHEN '3'                                                 
A02119              MOVE 'MKTG/BP LETTERS'     TO WS-RPT-CORR-TYPE      
A02119         WHEN '4'                                                 
A02119              PERFORM 2300-GET-SECURED-CIG  THRU 2300-EXIT        
P00527         WHEN '5'                                                 
P00527              MOVE 'CUSTOMER STATEMENT'  TO WS-RPT-CORR-TYPE      
A02119     END-EVALUATE.                                                
           IF SUB-FOUND                                                 
              MOVE MW-ACCOUNT-NO                  TO WS-RPT-ACCOUNT-NBR 
              MOVE MW-BARCODE-UNIQUE-ID           TO WS-RPT-UNIQ-ID     
           ELSE                                                         
              MOVE E-FCA166-ACCT-NO               TO WS-RPT-ACCOUNT-NBR 
              MOVE E-FCA166-BARCODE-UNIQUE-ID     TO WS-RPT-UNIQ-ID     
           END-IF                                                       
A04495     MOVE E-FCA166-JOB-NAME                 TO WS-RPT-JOB-NAME-1  
A04495     MOVE E-FCA166-SEQ-NO                   TO WS-RPT-SEQ-NO      
           WRITE WS-PRT1662-RECORD            FROM WS-RPT-DETAIL-LINE-1.
      *                                                                 16620000
       8400-EXIT.                                                       
           EXIT.                                                        
A02318***************************************************************** 16650000
A02318*8450-WRITE-NOTFOU-ACCT.                                        * 16660000
A02318***************************************************************** 16670000
A02318 8450-WRITE-NOTFOU-ACCT.                                          
A02318*                                                                 16690000
A02318     IF FIRST-ACCT-NF-REP                                         
A02318        MOVE WS-RPT3-HEAD              TO WS-RPT-HEAD-2B          
A02318        WRITE WS-PRT1663-RECORD        FROM WS-BLANK-LINE         
A02318        WRITE WS-PRT1663-RECORD        FROM WS-RPT-HEADER-LINE-1  
A02318        WRITE WS-PRT1663-RECORD        FROM WS-BLANK-LINE         
A02318        WRITE WS-PRT1663-RECORD        FROM WS-RPT-HEADER-LINE-2B 
A02318        WRITE WS-PRT1663-RECORD        FROM WS-BLANK-LINE         
A02318        WRITE WS-PRT1663-RECORD        FROM WS-RPT-HEADER-LINE-5  
A02318        WRITE WS-PRT1663-RECORD        FROM WS-RPT-HEADER-LINE-4  
A02318        MOVE  WS-N                     TO WS-FIRST-ACCT-NOTFOU-SW 
A02318     END-IF.                                                      
A02318                                                                  
A02318     INITIALIZE WS-RPT-DETAIL-LINE-NOTFOU.                        
A02318     PERFORM 5000-MOVE-NOTFOUND-ACCTS  THRU 5000-EXIT.            
A02318     WRITE WS-PRT1663-RECORD   FROM WS-RPT-DETAIL-LINE-NOTFOU.    
A02318                                                                  
A02318 8450-EXIT.                                                       
A02318     EXIT.                                                        
      *                                                                 16880000
      ********************************************************          16890000
      *  WRITE ROW TO TRANS HISTORY.                         *          16900000
      ********************************************************          16910000
       8500-UPD-TRANS-HIST.                                             
      *                                                                 16930000
           MOVE WS-RUN-DATE-1                  TO MH-DATE-TRANS.        
           MOVE 'F'                            TO MH-CODE-TRAN-TYPE.    
           MOVE ZEROS                          TO MH-PREMISE-NO.        
           MOVE SPACES                         TO MH-RESP-AREA-ID.      
           IF SUB-FOUND                                                 
              MOVE MW-ACCOUNT-NO               TO MH-ACCOUNT-NO         
              MOVE ZEROES                      TO MH-CUSTOMER-NO        
           ELSE                                                         
              IF E-FCA166-ACCT-NO IS NOT NUMERIC                        
                 MOVE ZEROES                   TO MH-ACCOUNT-NO         
                 MOVE WS-CUSTOMER-NO           TO MH-CUSTOMER-NO        
              ELSE                                                      
                 MOVE E-FCA166-ACCT-NO         TO MH-ACCOUNT-NO         
                 MOVE ZEROES                   TO MH-CUSTOMER-NO        
              END-IF                                                    
           END-IF.                                                      
           MOVE 'SYSTEM'                       TO MH-USER-ID.           
           MOVE 'PCSCA166'                     TO MH-APPL-PROGRAM-ID.   
           MOVE WS-CURRENT-DATE(6:2)           TO WS-HIST-DISP-MM.      
           MOVE WS-CURRENT-DATE(9:2)           TO WS-HIST-DISP-DD.      
           MOVE WS-CURRENT-DATE(1:4)           TO WS-HIST-DISP-YR.      
A02119     INITIALIZE MH-TRAN-COMMENT-TEXT.                             
           IF BILL-JOB                                                  
              STRING 'BILL MAILED ' WS-HOLD-MAIL-TYPE                   
A02119               ' (UI:' MW-BARCODE-UNIQUE-ID ')'                   
                             DELIMITED BY SIZE INTO MH-TRAN-COMMENT-TEXT
A02119        MOVE +35                        TO MH-TRAN-COMMENT-LEN    
           END-IF                                                       
A03361     IF NOTICE-JOB                                                
A03361        STRING 'NOTICE MAILED '                                   
A03361                       WS-HOLD-MAIL-TYPE                          
A03361               ' (UI:'  MW-BARCODE-UNIQUE-ID ')'                  
A03361                       DELIMITED BY SIZE INTO MH-TRAN-COMMENT-TEXT
A03361        MOVE +40                        TO MH-TRAN-COMMENT-LEN    
A03361     END-IF                                                       
A03361     IF LETTER-JOB                                                
A03361        STRING 'LETTER MAILED '                                   
A03361                       WS-HOLD-MAIL-TYPE                          
A03361               ' (UI:'  MW-BARCODE-UNIQUE-ID ')'                  
A03361                       DELIMITED BY SIZE INTO MH-TRAN-COMMENT-TEXT
A03361        MOVE +40                        TO MH-TRAN-COMMENT-LEN    
A03361     END-IF                                                       
A03361     IF MKTLTR-JOB                                                
              STRING 'MARKETING LETTER MAILED '                         
                             WS-HOLD-MAIL-TYPE                          
A02119               ' (UI:'  MW-BARCODE-UNIQUE-ID ')'                  
                             DELIMITED BY SIZE INTO MH-TRAN-COMMENT-TEXT
A02119        MOVE +47                        TO MH-TRAN-COMMENT-LEN    
           END-IF                                                       
A02119                                                                  
A02119     MOVE MH-TRAN-COMMENT-LEN     TO WS-EMB-LENG                  
A02119     MOVE SPACES                  TO WS-EMB-INPUT                 
A02119                                     WS-CMP-TABLE                 
A02119     MOVE MH-TRAN-COMMENT-TEXT    TO WS-EMB-INPUT                 
A02119     PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT           
A02119     MOVE WS-CMP-TABLE            TO MH-TRAN-COMMENT-TEXT         
                                                                        
A04494     MOVE ZEROS                  TO WS-COMM-SUB.                  
A04494     PERFORM 8600-INSERT-MNT-TRANS-HIST THRU 8600-EXIT            
A04494            UNTIL WS-COMM-SUB >= WS-COMM-RETRY-COUNT.             
A04494     IF WS-ACTIVE-RETURN-CODE = (-911 OR -803)                    
A04494        DISPLAY '*** IN 8600-INSERT-MNT-TRANS-HIST*****'          
A04494        DISPLAY '*** SQL CODE    = ' WS-ACTIVE-RETURN-CODE        
A04494        DISPLAY '*** ACCOUNT #   = ' MH-ACCOUNT-NO                
A04494        DISPLAY '*** CUSTOMER NO = ' MH-CUSTOMER-NO               
A04494        DISPLAY '*** PREMISE NO  = ' MH-PREMISE-NO                
A04494        DISPLAY '*** DATE TRANS  = ' MH-DATE-TRANS                
A04494        PERFORM 9900-ABEND               THRU 9900-EXIT           
A04494     END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17660000
A04494 8600-INSERT-MNT-TRANS-HIST.                                      
           MOVE '8600'                      TO ACTIVE-PARAGRAPH.        
           EXEC SQL                                                     
               INSERT INTO CSS_MNT_TRANS_HIST                           
                 ( TRANS_HIST_SEQ_NO, DATE_TRANS,                       
                   CODE_TRAN_TYPE,    RESP_AREA_ID,                     
                   ACCOUNT_NO,                                          
                   CUSTOMER_NO,       PREMISE_NO,                       
                   USER_ID,           APPL_PROGRAM_ID,                  
                   TRAN_COMMENT)                                        
               VALUES                                                   
                 ( CIS.CURRENT$TIMESTAMP(),     IIF(TRY_CONVERT(DATE, 
                                                         :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) ),               
                   :MH-CODE-TRAN-TYPE,    :MH-RESP-AREA-ID,             
                   :MH-ACCOUNT-NO,                                      
                   :MH-CUSTOMER-NO,       :MH-PREMISE-NO,               
                   :MH-USER-ID,           :MH-APPL-PROGRAM-ID,          
                   :MH-TRAN-COMMENT)                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     17690000
MFA-TR*        INSERT INTO CSS_MNT_TRANS_HIST                           17700000
MFA-TR*          ( TRANS_HIST_SEQ_NO, DATE_TRANS,                       17710000
MFA-TR*            CODE_TRAN_TYPE,    RESP_AREA_ID,                     17720000
MFA-TR*            ACCOUNT_NO,                                          17730000
MFA-TR*            CUSTOMER_NO,       PREMISE_NO,                       17740000
MFA-TR*            USER_ID,           APPL_PROGRAM_ID,                  17750000
MFA-TR*            TRAN_COMMENT)                                        17760000
MFA-TR*        VALUES                                                   17770000
MFA-TR*          ( CURRENT TIMESTAMP,     :MH-DATE-TRANS,               17780000
MFA-TR*            :MH-CODE-TRAN-TYPE,    :MH-RESP-AREA-ID,             17790000
MFA-TR*            :MH-ACCOUNT-NO,                                      17800000
MFA-TR*            :MH-CUSTOMER-NO,       :MH-PREMISE-NO,               17810000
MFA-TR*            :MH-USER-ID,           :MH-APPL-PROGRAM-ID,          17820000
MFA-TR*            :MH-TRAN-COMMENT)                                    17830000
MFA-TR*    END-EXEC.                                                    17840000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                  MOVE WS-COMM-RETRY-COUNT  TO WS-COMM-SUB              
              WHEN -911                                                 
              WHEN -803                                                 
                 COMPUTE WS-COMM-SUB = WS-COMM-SUB + 1                  
              WHEN OTHER                                                
                 MOVE MH-APPL-PROGRAM-ID TO ABEND-PROGRAM               
                 MOVE '8600'         TO ACTIVE-PARAGRAPH                
                 MOVE 'INSERT'       TO ABEND-FUNCTION                  
                 MOVE 'CSS_MNT_TRANS_HIST' TO TABLE-1                   
                 MOVE MH-ACCOUNT-NO  TO HOSTVAR-ELEMENT-1               
                 MOVE MH-CUSTOMER-NO TO HOSTVAR-ELEMENT-2               
                 MOVE MH-PREMISE-NO  TO HOSTVAR-ELEMENT-3               
                 MOVE MH-DATE-TRANS  TO HOSTVAR-ELEMENT-4               
                 MOVE 'ACCOUNT-NO'   TO TABLE-ELEMENT-1                 
                 MOVE 'CUSTOMER-NO'  TO TABLE-ELEMENT-2                 
                 MOVE 'PREMISE-NO'   TO TABLE-ELEMENT-3                 
                 MOVE 'DATE-TRANS'   TO TABLE-ELEMENT-4                 
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
           END-EVALUATE.                                                
A04494 8600-EXIT.                                                       
A04494     EXIT.                                                        
      *                                                                 18100000
      ****************************************************************  18110000
      * 8893-RESET-RESTART-REQ-PARM                                  *  18120000
      ****************************************************************  18130000
           EXEC SQL                                                     18140000
               INCLUDE CPD00029                                         18150000
           END-EXEC.                                                    18160000
                                                                        
      ****************************************************************  18180000
      * 9000-SEND-ERROR-RESULT. REQUIRED BY THE COPYBOOK             *  18190000
      ****************************************************************  18200000
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           GO TO 9000-EXIT.                                             
      *                                                                 18240000
      ******************************************************************18250000
      *     9000-TERMINATE                                             *18260000
      *     CLOSE FILES. IF WORK QUEUE CREATED SET THE RETURN CODE TO 1*18270000
      ******************************************************************18280000
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSCA166-FILE                                          
                 FCSP1661-FILE                                          
A02318           FCSP1662-FILE                                          
A02318           FCSP1663-FILE.                                         
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18390000
      *************************                                         18400000
      *  9700-PROCESS-ABEND  **                                         18410000
      *************************                                         18420000
      *                                                                 18430000
       COPY CPD0023B.                                                   18440000
      *                                                                 18450000
      ****************************************************************  18460000
      **  9900-SQL-ERROR-ROUTINE                                    **  18470000
      ****************************************************************  18480000
       9900-SQL-ERROR-ROUTINE.                                          
           MOVE SQLCODE                TO WS-DISPLAY-SQLCODE.           
           DISPLAY ' '                                                  
           DISPLAY '**********************************************'     
           DISPLAY '***** 9900-SQL-ERROR-ROUTINE            ******'     
           DISPLAY '**********************************************'     
           DISPLAY ' '                                                  
           DISPLAY 'SQLCODE = ' WS-DISPLAY-SQLCODE                      
           DISPLAY ABEND-RECORD-1-DATA                                  
           DISPLAY ABEND-RECORD-2-DATA                                  
           DISPLAY ABEND-RECORD-3-DATA                                  
           DISPLAY '**********************************************'.    
           PERFORM 9900-ABEND                    THRU 9900-EXIT.        
      *                                                                 18620000
      ******************************************************************18630000
      *     9900-ABEND                                                 *18640000
      ******************************************************************18650000
      *                                                                 18660000
           EXEC SQL                                                     18670000
              INCLUDE CPD09900                                          18680000
           END-EXEC.                                                    18690000
      *                                                                 18700000
