       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA165.                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **                                                             **         
      **                                                             **         
      **     F U N C T I O N A L    D E S C R I P T I O N            **         
      **             O F   M O D U L E                               **         
      **                                                             **         
TP8156**  IT WILL SELECT ALL THE ACCOUNTS THAT HAVE A CIA(CREDIT IN  **         
TP8156**  ADVANCE,ITEM_ID=1 IN UNUSED CREDIT) AND/OR LIHEAP CREDIT   **         
TP8156**  (ITEM_ID=2).FROM THIS,THE PROGRAM WILL TRY AND DISTRIBUTE  **         
TP8156**  MONEY TO ANY CHARGES AND/OR RECEIVABLES THAT IT CAN. IT    **         
TP8156**  SHOULD APPLY FROM ITEM_ID 2 FIRST, IF BOTH ON THE ACCOUNT. **         
      **                                                             **         
      *****************************************************************         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS  REASON                                 **         
      **   _______  ________  ______                                 **         
      **   0796       ADA     INITIAL PROGRAM VERSION                **         
TP6057**   1196     RAO JADA  TPR 6057 CHANGES                       **         
TP9728**   0397       PD       ADD DCLGEN TBWOARGM FOR CPD73 CHANGES.**         
NONUTL**   7/11/97    CHANDRA  ADDED CPD00312, CWS10016, TBHLDAY     **         
      **  ________  ________  _____________________________________  **         
T15071**  02/26/98    AMG     CHANGED WS-CASH-REPORT-NO FROM 996     **         
T15071**                      TO 998                                 **         
T15297**  03/18/98    KP      REMOVE CIA DEBIT FROM DISTRIBUTION TO  **         
T15297**                      TO ANY CHARGES AND/OR RECEIVABLES      **         
T15301**  03/18/98    KP      GENERATE WORK QUEUE FOR ACCOUNTS WITH  **         
T15301**                      CIA DEBIT                              **         
PCR640** PCR640 07/01/98    KLP  ADDED LOGIC TO CHECK FOR AR-LOCKOUT **         
T17819**  09/30/98    VB      ADDED LOGIC TO CHECK THE AMOUNT IN     **         
T17819**                      CSS_CHRG_OFF TABLE.                    **         
T18233**  10/27/98    YU      INITIALIZED VARIABLE                   **         
T18233**                      'WS-PAR-TRAN-APPL-NO-WO1' IN PARA 3000 **         
T18050**  11/02/98    PD      UPDATE CIA 0 ROW AFTER CIA APPLICATION.**         
T18050**                      MOVE 70 TO AC-PYMT-PRIORITY-LVL BEFORE **         
T18050**                      UPDATE OF CSS_AR_CNTL AFTER CIA APPL.  **         
T18024**  11/11/98    CBSI    REMOVE THE WINDOWING TECHNIQUE AND GET **         
T18024**               MDS    THE DATE FROM JOB_PARM_TABLE           **         
T19546**  03/26/99    VB      CIA IS NOT GETTING APPLIED AGAINST     **         
T19546**                      TOT SUMM UNBILLED.                     **         
      **  04/24/01    WR      MCR310 PSNC.  CSS_GL_ACCT_NO CHANGES   **         
C23235**  07/14/01    MDJ     ADDED DCLGEN TBUTLENV FOR CPD0010S.    **         
      **  10/09/01    NVM     ADDED COMMIT LOGIC TO THE PROGRAM USING**         
      **                      PARM                                   **         
T24436**  10/18/01   COVANSYS    COPYBOOK CPD00061 CHANGED TO SUB    **         
T24436**             CHENNAI     PROGRAM  SCSCB061.                  **         
C26130**  06/28/02    SRIDEVI INCLUDED TBMNHIST & TBMNHDT INORDER TO **         
C26130**                      WRITE INTO MNT TRANSACTION HISTORY     **         
C26130**                      TABLES AT THE TIME OF AUTOMATIC EPP SETUP         
T25584**  06/01/04    GOKUL   IMPLEMENT RESTART LOGIC.               **         
C30083**  09/08/04    SS82048 APPLY CIA ON PENDING SEB ACCTS WITH    **         
      **                      CHARGED DEPOSITS                       **         
C30083**  11/08/04    GOKUL   FIX PRODUCTION ABEND WHEN PROCESSING   **         
      **                      ACCOUNTS WITH MORE THAN 1 DEPOSITS.    **         
T33431** 03/16/06   SK88120        COG PROJECT CHANGES -             **         
T33431**                           A- ADD NEW COPYBOOKS              **         
T33431**                           B- CHANGE IN CPD00073             **         
T35434** 03/01/07     PRIYA   REPLACED MODEL_SQL TO SET COMMANDS.    **         
C36956** 11/14/08   SK42147   EPP CHAGES TO BBP.                     **         
A37302** 09/09/09   RC41079   REMOVED REFERENCE TO CSS_RVC_ACCT.     **         
A04880** 07/11/14   DB41297   DELETE RESTART LOGIC. OPTIMIZE TABLES. **         
A04860** 09/02/14   MC95456   REPLACE CSS_WQ_ITEMS_MF WITH CSS_WQ_ITEMS.        
P00851** 02/27/15   VENKAT.P  DISTRIBUTE ADVANCE COLLECTION CONTRACTS**         
P00851**                    - WHEN ACTIVE/CLOSED INSTALLEMNT CNT FOUND*         
P00851**                      - AMOUNT MATCHES THEN DISTRIBUTE       **         
P00851**                      - ELSE GENERATE 574/575 WQ             **         
P00851**                      - REMOVED TDS/RS/UNUSED WS FILEDS      **         
A05136** 04/17/15   MUTHU     TO FIX THE PAYMENT ISSUE.              **         
A05136**                                                             **         
A05136** 05/05/15   BD09555   ADD CONTRACT TYPE 'F'                  **         
A05136**A05136-ACT095                                                **         
ACT150** 05/05/15   BD09555   ADD ADDITIONAL INITIALIZATION FOR      **         
ACT150**A05136-ACT150         PAYMENT PRIORITY LEVELS                **         
A05460**  01/22/16  MS7M727   REMOVED USUSED COPYBOOK                **         
A05460**            ACT015                                           **         
ACT092** 02/26/2016 MS7M727   REPLACE CSS_WQ_ITEMS_MF WITH           **         
ACT092**            A04860    CSS_WQ_ITEMS                           **         
ACT149** 05/04/2016 MS7M727   TO CHANGE SUSAGE AS USAGE              **         
ACT149**            A05460                                           **         
ACT403** 01/05/2017 VIJAY     INITIALIZE WS-GL-SUB TO SUPPORT MFES.  **         
ACT403** A05460                                                                 
ACT018** 01/31/2017 WR19680   ADD CHANGE FOR CONTRACTS TO ALSO CHECK **         
ACT018** APPL5774             TO SEE IF AN EXISTING DOWN PAYMENT IS  **         
ACT018**                      IS ON THE ACCOUNT AND IF SO DISTRIBUTE **         
ACT018**                      TO THE CONTRACT                        **         
      *****************************************************************         
      **          ---- BASIC SEQUENCE STRUCTURE ----                 **         
      **                                                             **         
      **  0000         MODULE CONTROL                                **         
      **  0100 - 0999  INITIALIZATION (OPTIONAL)                     **         
      **  1000 - 1999  FUNCTIONAL CONTROL                            **         
      **  2000 - 4999  DETAIL LOGIC                                  **         
      **  5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES            **         
      **  6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)  **         
      **  7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.)**         
      **  8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC.)*         
      **                                                             **         
      *****************************************************************         
                                                                        
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA165'.
MSQ017     COPY MFASQLM.
       01  WS-START                       PIC X(40)                     
           VALUE 'WORKING STORAGE FOR PCSCA165 STARTS HERE'.            
                                                                        
      /****************************************************************         
      **     THE WORK VARIABLE AREA IS USED FOR TRANSIENT DATA. IT   **         
      **     IS INITIALIZED ON EACH CALL TO THE SUBROUTINE.          **         
      **     THE OTHER WORK AREAS ARE INITIALIZED UNDER PROGRAM      **         
      **     CONTROL.  ADD ANY NEW DATA FIELDS ACCORDINGLY.          **         
      **                                                             **         
      /****************************************************************         
       01  WS-WORK-VARIABLES.                                           
COB305     05 WS-CIA-CREDIT        PIC S9(09)V9(2) USAGE COMP-3 VALUE 0. 
COB305     05 WS-LIHEAP-CREDIT        PIC S9(09)V9(2) USAGE COMP-3 
COB305       VALUE 0. 
ACT092     05  MCSCB077                   PIC X(08) VALUE 'MCSCB077'.   
ACT092     05  WS-CPD0010S-CALL-TYPE      PIC X(01)  VALUE 'B'.         
ACT092         88 WS-CPD0010S-ONLINE-CALL            VALUE 'O'.         
ACT092         88 WS-CPD0010S-BATCH-CALL             VALUE 'B'.         
ACT092     05  WS-WQ-CALL-PGM             PIC X(08) VALUE 'SCSCB077'.   
           05  WS-CIA-SUM-UNUSED-CR       PIC S9(11)V9(2).              
COB305     05 WS-AMT-ACCT-OWED        PIC S9(11)V9(2) USAGE COMP-3 
COB305       VALUE 0. 
C30083     05  WS-AMT-TRAN-BALANCE        PIC S9(11)V9(2) USAGE COMP-3  
C30083                                                    VALUE 0.      
C30083     05  WS-TOT-AMT-MOVD            PIC S9(11)V9(2) USAGE COMP-3  
C30083                                                    VALUE 0.      
C30083     05  WS-AMT-TO-MOVE             PIC S9(11)V9(2) USAGE COMP-3  
C30083                                                    VALUE 0.      
C30083     05  WS-AC-LAST-UPDATE-TS       PIC X(26) VALUE SPACES.       
C30083     05  WS-AT-LAST-UPDATE-TS       PIC X(26) VALUE SPACES.       
C30083     05  WS-ITEM-ID                 PIC S9(09) USAGE COMP VALUE 0.
C30083     05  WS-NULL-IND1               PIC S9(04) USAGE COMP VALUE 0.
C30083     05  WS-CSR02384-PROCESS        PIC X(01)  VALUE SPACES.      
COB305     05 WS-CHRG-OFF-AMT        PIC S9(11)V9(2) USAGE COMP-3 
COB305       VALUE 0. 
COB305     05 WS-AMT-TOT-UNUSED-CR        PIC S9(11)V9(2) USAGE COMP-3 
COB305       VALUE 0. 
COB305     05 WS-AMT-AR-DAY-00        PIC S9(11)V9(2) USAGE COMP-3 
COB305       VALUE 0. 
           05  WS-DATE-ORIG-PYMT-IND      PIC S9(4) COMP VALUE 0.       
T11466     05  LS-INPUT-DATE              PIC X(10)  VALUE SPACES.      
           05  WS-CURRENT-DATE            PIC X(10).                    
           05  WS-CURRENT-TIMESTAMP       PIC X(26).                    
           05  RS-RETURN-CODE             PIC S9(4) COMP VALUE 0.       
           05  WS-ERROR-MSG-1             PIC X(30) VALUE SPACES.       
           05  WS-ERROR-MSG-2             PIC X(30) VALUE SPACES.       
           05  WS-ERROR-MSG-3             PIC X(30) VALUE SPACES.       
           05  WS-DISPLAY-SQLCODE         PIC -Z(8)9.                   
C30083     05  WS-DATABASE                PIC 9(01) VALUE 0.            
C30083         88  CSR-DATABASE                     VALUE 1.            
C30083         88  SEB-DATABASE                     VALUE 2.            
P00851     05  WS-FROM-ITEM-ID            PIC S9(09) USAGE COMP VALUE 0.
                                                                        
      **                                                             **         
           05  WS-GL-LPC-KEY              PIC X(10) VALUE 'AR-LPC    '. 
           05  WS-GL-LPN-KEY              PIC X(10) VALUE 'AR-LPN    '. 
           05  WS-GL-ELC-KEY              PIC X(10) VALUE 'AR-UTE    '. 
           05  WS-GL-GAS-KEY              PIC X(10) VALUE 'AR-UTG    '. 
           05  WS-GL-EPP-KEY              PIC X(10) VALUE 'AR-BUD    '. 
           05  WS-GL-CCC-KEY              PIC X(10) VALUE 'AR-CCC    '. 
           05  WS-GL-DFA-KEY              PIC X(10) VALUE 'AR-DFA    '. 
           05  WS-GL-DEP-KEY              PIC X(10) VALUE 'AR-DEP    '. 
           05  WS-GL-CNT-KEY              PIC X(10) VALUE 'AR-CNT    '. 
           05  WS-GL-NSA-KEY              PIC X(10) VALUE 'AR-NSA    '. 
           05  WS-GL-NSN-KEY              PIC X(10) VALUE 'AR-NSN    '. 
           05  WS-GL-NSC-KEY              PIC X(10) VALUE 'AR-NSC    '. 
           05  WS-GL-PJS-KEY              PIC X(10) VALUE 'AR-PJS    '. 
           05  WS-GL-CASH-KEY             PIC X(10) VALUE 'ACASH     '. 
      **                                                             **         
           05  WS-SEARCH-KEY.                                           
               10  WS-SK-COMPANY-NO       PIC X(02).                    
               10  WS-SK-LOCAL-OFFICE     PIC X(03).                    
               10  WS-SK-ACCT-NAME        PIC X(10).                    
           05  WS-GL-FOUND                PIC X(01) VALUE SPACE.        
               88  GL-NO-FOUND                      VALUE 'Y'.          
      **                                                             **         
ACT215 01  WS-GL-TABLE.                                                 
ACT215     05  GL-CNT                     PIC S9(5) COMP-3 VALUE +0.    
ACT215     05  WS-GL-TABLE-VALUES OCCURS 0 TO 2000 TIMES                
ACT215         DEPENDING ON GL-CNT                                      
ACT215         ASCENDING KEY WS-GL-KEY                                  
ACT215         INDEXED BY GL-IND.                                       
ACT215         10  WS-GL-KEY.                                           
                   15  WS-GL-COMPANY      PIC X(02).                    
                   15  WS-GL-LOCAL-OFFICE PIC X(03).                    
                   15  WS-GL-ACCOUNT-NAME PIC X(10).                    
               10  WS-GL-ACCOUNT-NO       PIC 9(3)V9(4).                
       01  WS-GL-SUBSCRIPT                PIC S9(8) COMP.               
      **                                                             **         
       01  WS-CONSTANTS.                                                
T15071     05  WS-CASH-REPORT-NO          PIC X(03) VALUE '998'.        
???        05  WS-CASH-DRAWER-ID          PIC S9(04) COMP VALUE 9998.   
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-I                       PIC X(01) VALUE 'I'.          
P00851     05  WS-F                       PIC X(01) VALUE 'F'.          
           05  WS-N                       PIC X(01) VALUE 'N'.          
           05  WS-Y                       PIC X(01) VALUE 'Y'.          
           05  WS-TRUE                    PIC X(01) VALUE '1'.          
           05  PROGRAM-NAME               PIC X(08) VALUE 'PCSCA165'.   
T18024     05  WS-PGRMNAME                PIC X(08) VALUE 'PCSCA165'.   
P00851     05  WS-PCSCA165C               PIC X(09) VALUE 'PCSCA165C'.  
A04860     05  SCSCB077                   PIC X(8)  VALUE 'SCSCB077'.   
           05  WS-A165                    PIC X(04) VALUE 'A165'.       
           05  RS-RETURN-CODE-DISP        PIC +Z(04).                   
T24436     05  SCSCB061                   PIC X(08)  VALUE 'SCSCB061'.  
T33431     05  MCSCB225                 PIC  X(8) VALUE  'SCSCB225'.    
T33431     05  WS-COG-TRAN-TYPE-CD-73   PIC X(1) VALUE  'I'.            
                                                                        
C     *                                                                         
T25584*                                                                         
C      01  WS-COMMIT-VRBLS.                                             
C          05  WS-COMMIT-COUNT            PIC 9(08) VALUE ZERO.         
           05  WS-TOT-COMMIT-CNT          PIC 9(08) VALUE ZERO.         
COB305     05 WS-COMMIT-ACCT-NO        PIC S9(13)V COMP-3 VALUE 0.          
C          05  WS-COMMIT-ITEM-ID          PIC S9(9)    USAGE COMP.      
C          05  WS-COMMIT-AMT-UNUSED-CR    PIC S9(9)V99.                 
C          05  WS-COMMIT-UPD-COUNTER      PIC 9(08) VALUE ZERO.         
C          05  WS-COMMIT-SEQ-NO           PIC 9(05) VALUE ZERO.         
      *                                                                         
       01  WS-SWITCHES-AND-INDICATORS.                                  
           05  WS-NO-MORE-CREDITS-SW      PIC X(01).                    
               88  WS-NO-MORE-CREDITS               VALUE '1'.          
           05  WS-PYMT-PRTY-LOAD-SW       PIC X(01).                    
               88  WS-UNDIRECTED-LOADED             VALUE 'B'.          
               88  WS-LIHEAP-LOADED                 VALUE 'L'.          
P00851     05  WS-GL-NOS-LOADED-SW        PIC X(01) VALUE SPACE.        
P00851         88  WS-GL-NOS-LOADED                 VALUE 'Y'.          
P00851     05  WS-IS-CIA-PROCES-SW        PIC X(01) VALUE 'Y'.          
P00851         88  WS-IS-CIA-PROCES                 VALUE 'Y'.          
P00851     05  WS-IS-CNT-FOUND-SW         PIC X(01) VALUE 'N'.          
P00851         88  WS-IS-CNT-FOUND                  VALUE 'Y'.          
P00851     05  WS-IS-AMT-MATCHED-SW       PIC X(01) VALUE 'N'.          
P00851         88  WS-IS-AMT-MATCHED                VALUE 'Y'.          
P00851     05  WS-WQ-EXISTS-SW            PIC X(01) VALUE 'N'.          
P00851         88  WS-WQ-EXISTS                     VALUE 'Y'.          
C30083     05  WS-SEB-PNDG-CHG-DEP        PIC X(01) VALUE 'N'.          
C30083         88  SEB-PNDG-CHG-DEP                 VALUE 'Y'.          
C30083         88  NO-SEB-PNDG-CHG-DEP              VALUE 'N'.          
C30083     05  WS-END-OF-DEP              PIC X(01) VALUE 'N'.          
C30083         88  END-OF-DEP                       VALUE 'Y'.          
C30083                                                                  
C30083***************************************************************   ****    
C30083*    DB2 COMMUNICATION REQUIREMENT *                                      
C30083***************************************************************   ****    
ACT149*01  LOC1                  USAGE IS SQL TYPE IS                   
C30083*                          RESULT-SET-LOCATOR VARYING.            
C30083* VARIABLES PASSED TO STORED PROCEDURE CSR0384                            
C30083                                                                  
C30083 01  WS-INPUT-PARM.                                               
C30083     05 PARM-ACCOUNT-NO       PIC X(13).                          
C30083     05 PARM-PYMT-PRIORITY-LVL PIC S9(9) COMP.                    
C30083     05 PARM-ITEM-ID          PIC S9(9) COMP.                     
C30083     05 PARM-RECV-TYPE        PIC X(03).                          
COB305     05 PARM-AMT-AR-DAY-00        PIC S9(11)V99 COMP-3 VALUE 0.           
COB305     05 PARM-AMT-AR-DAY-30        PIC S9(11)V99 COMP-3 VALUE 0.           
COB305     05 PARM-AMT-AR-DAY-60        PIC S9(11)V99 COMP-3 VALUE 0.           
COB305     05 PARM-AMT-AR-DAY-90        PIC S9(11)V99 COMP-3 VALUE 0.           
C30083     05 PARM-USER-ID          PIC X(07).                          
C30083     05 PARM-RESP-AREA-ID     PIC X(03).                          
COB305     05 PARM-TOT-SUMM-UNBILLED        PIC S9(11)V99 COMP-3 
COB305       VALUE 0.              
C30083     05 PARM-RECORD-ONLY-FLAG PIC X(01).                          
C30083     05 PARM-COMMENT-LEN      PIC X(4).                           
C30083     05 PARM-COMMENT-LEN-NUM REDEFINES PARM-COMMENT-LEN           
C30083                                  PIC 9(4).                       
C30083     05 PARM-COMMENT-TEXT      PIC X(210).                        
C30083     05 PARM-AC-LAST-UPDATE-TS PIC X(26).                         
C30083     05 PARM-AT-LAST-UPDATE-TS PIC X(26).                         
C30083     05 PARM-PANEL-NO          PIC X(08) VALUE SPACES.            
      *                                                                         
       01  WS-OUTPUT-PARM.                                              
           05 S-RETURN-CODE                  PIC S9(9) COMP VALUE 0.    
           05 S-AR-LOCKOUT-IND               PIC X(01) VALUE SPACES.    
                                                                        
                                                                        
      /*****************************************************************        
      *                                                                *        
      *  WORKING STORAGE COPY BOOKS FOLLOW ALL PROGRAM WS              *        
      *                                                                *        
      ******************************************************************        
      /*****   SQL WORK VARIABLES                                               
       COPY CWS00303.                                                           
      /*****   GL LOADING WORKING STORAGE VARIABLES                             
       COPY CWS00061.                                                           
      /*****   DB2 SQL ERROR HANDLING WORKING STORAGE.                          
       COPY CWS0070B.                                                           
      /*****   DATE BREAKDOWM                                                   
       COPY CWS00004.                                                           
      /*****   CURRENT DATE COMPUTATION WORK FIELD                              
       COPY CWS00007.                                                           
      ******   REBATE CALC WORKING STORAGE VARIABLES                            
T11466     EXEC SQL                                                             
T11466        INCLUDE CWS00008                                                  
T11466     END-EXEC.                                                            
      /*****   ABEND WORKING STORAGE VARIABLES                                  
       COPY CWS00010.                                                           
      /*****   101 JORNALLING                                                   
       COPY CJF00101.                                                           
      ******   102 JORNALLING                                                   
       COPY CJF00102.                                                           
      /*****   105 JORNALLING                                                   
       COPY CJF00105.                                                           
      /*****   CODES DATA PRESENT                                               
       COPY CWS00056.                                                           
      /**** ABENDING ROUTINE WORKING STORAGE.                           05515000
       COPY CWS09900.                                                   05518000
      *                                                                         
T18024 COPY FIOCA00.                                                            
T18024 COPY FIOJC01.                                                            
T18024/****** CWS00038 IS JC01 WORK DATA                                        
T18024 COPY CWS00038.                                                           
T18024*                                                                         
T18024/****** CWS00039 IS CA00 WORK DATA                                        
T18024 COPY CWS00039.                                                           
T33431     COPY CWSCA225.                                                       
T18024*                                                                         
A04860/****** FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077             
A04860      EXEC SQL                                                            
A04860           INCLUDE CWS00077                                               
A04860      END-EXEC.                                                           
A04860*                                                                         
                                                                        
       01  WS-END                          PIC X(40)                    
           VALUE 'DB2 INCLUDES FOR PCSCA165 START HERE '.               
HPCCDM*EJECT                                                                    
      /*****************************************************************        
      *   TABLE DECLARATIONS GO AFTER OTHER WORKING STORAGE ITEMS      *        
      *   (IF DIRECT ACCESS TO DB2 TABLES IS ALLOWED). FIRST ITEM      *        
      *   WILL ALWAYS BE SQLCA.                                        *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      ******************************************************************        
      *    CSS_GL_ACCOUNT                                                       
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBGLACCT                                                 
           END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      ******************************************************************        
T18024*    CSS_JOB_PARM                                                         
T18024******************************************************************        
T18024*                                                                         
T18024     EXEC SQL                                                             
T18024         INCLUDE TBJBPARM                                                 
T18024     END-EXEC.                                                            
T18024*                                                                         
      ******************************************************************        
      *    CSS_CNT_DETAIL                                                       
      ******************************************************************        
      *                                                                         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCNTDET                                                 
           END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      ******************************************************************        
      *    CSS_GL_ACCT_NO                                                       
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBGLATNO                                                 
           END-EXEC.                                                            
PCR640******************************************************************        
PCR640*    CSS_AR_LOCKOUT                                                       
PCR640******************************************************************        
PCR640                                                                  
PCR640     EXEC SQL                                                             
PCR640         INCLUDE TBARLOCK                                                 
PCR640     END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      *****************************************************************         
      *DCLGENS FOR CPD0010S.                                          *         
      *****************************************************************         
      * DCLGEN FOR CSS_ACCOUNT                                        *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      *****************************************************************         
      * DCLGEN FOR CSS_AR_CNTL                                        *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBARCNTL                                                 
           END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      *****************************************************************         
      * DCLGEN FOR CSS_PREMISE                                        *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      *****************************************************************         
      * DCLGEN FOR CSS_AR_PMT_PRTY                                    *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBARPMT                                                  
           END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      *****************************************************************         
      * DCLGEN FOR CSS_CONTRACT                                       *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCNTRCT                                                 
           END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      *****************************************************************         
      * DCLGEN FOR CSS_BUDGET_PLAN                                    *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBGTPLN                                                 
           END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      *****************************************************************         
      * DCLGEN FOR CSS_CUSTOMER                                       *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCUST                                                   
           END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      *****************************************************************         
      * DCLGEN FOR CSS_BUDGET_HIST                                    *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBGTHST                                                 
           END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      *****************************************************************         
      * DCLGEN FOR CSS_DEP_PAY_HIST                                   *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBDEPHST                                                 
           END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      *****************************************************************         
      * DCLGEN FOR CSS_DFA_RECVBLE                                    *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBDFARCV                                                 
           END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      *****************************************************************         
      * DCLGEN FOR CSS_DFA_ACCT                                       *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBDFAACT                                                 
           END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      *****************************************************************         
      * DCLGEN FOR CSS_CREDIT_PROFILE                                 *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCRPROF                                                 
           END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      *****************************************************************         
      * DCLGEN FOR CSS_LIEAP                                          *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBLIEAP                                                  
           END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      *****************************************************************         
      * DCLGEN FOR CSS_RECONNECT                                      *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBRECNCT                                                 
           END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      *****************************************************************         
      * DCLGEN FOR CSS_PROJ_SHARE                                     *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBPRJSHR                                                 
           END-EXEC.                                                            
      *****************************************************************         
      * DCLGEN FOR CSS_MISC_JRNL                                      *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBMSJRNL                                                 
           END-EXEC.                                                            
      *****************************************************************         
      * DCLGEN FOR CSS_BCH_JRNL_CNTL                                  *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBJCNTL                                                 
           END-EXEC.                                                            
      *****************************************************************         
      * DCLGEN FOR CSS_BATCH_JRNL                                     *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBTJRNL                                                 
           END-EXEC.                                                            
      *****************************************************************         
      * DCLGEN FOR CSS_AR_TRANS_HIST                                  *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBARHIST                                                 
           END-EXEC.                                                            
      *****************************************************************         
      * DCLGEN FOR CSS_AR_TRN_HST_DET                                 *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBARHDT                                                  
           END-EXEC.                                                            
      *****************************************************************         
      * DCLGEN FOR CSS_DEP_ON_HAND                                    *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBDEPHND                                                 
           END-EXEC.                                                            
                                                                        
P00851*****************************************************************         
P00851* DCLGEN FOR CSS_WQ_ITEMS                                       *         
P00851*****************************************************************         
P00851                                                                  
P00851     EXEC SQL                                                             
P00851         INCLUDE TBWQITS                                                  
P00851     END-EXEC.                                                            
      *****************************************************************         
      * DCLGEN FOR CSS_CHRG_OFF                                       *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCHGOFF                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * DCLGEN FOR CSS_USER_PROFILE                                   *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBUSRPRF                                                 
           END-EXEC.                                                            
      *****************************************************************         
      * DCLGEN FOR CSS_DELINQUENCY                                    *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *****************************************************************         
      * DCLGEN FOR CSS_CONNECT_CHRG                                   *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCCCHRG                                                 
           END-EXEC.                                                            
      *****************************************************************         
      * DCLGEN FOR CSS_RECONNECT_CHRG                                 *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBRCNCHR                                                 
           END-EXEC.                                                            
      *****************************************************************         
      * DCLGEN FOR CSS_LOCAL_OFFICE                                   *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
                                                                        
NONUTL******************************************************************        
NONUTL*    CSS_HOLIDAY                                                          
NONUTL******************************************************************        
NONUTL     EXEC SQL                                                             
NONUTL         INCLUDE TBHLDAY                                                  
NONUTL     END-EXEC.                                                            
HPCCDM*EJECT                                                                    
                                                                        
TP9728******************************************************************07009200
TP9728*    CSS_WO_ARRANGEMENT                                           07009300
TP9728******************************************************************07009400
TP9728                                                                  
TP9728     EXEC SQL                                                     07009600
TP9728         INCLUDE TBWOARGM                                         07009700
TP9728     END-EXEC.                                                    07009800
HPCCDM*EJECT                                                            07009900
                                                                        
C26130******************************************************************07009200
C26130* CSS_MNT_TRANS_HIST                                                      
C26130******************************************************************07009200
C26130     EXEC SQL                                                             
C26130        INCLUDE TBMNHIST                                                  
C26130     END-EXEC.                                                            
C26130                                                                  
C26130******************************************************************07009200
C26130* CSS_MT_TRN_HST_DET                                                      
C26130******************************************************************07009200
C26130     EXEC SQL                                                             
C26130        INCLUDE TBMNHDT                                                   
C26130     END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      *****************************************************************         
      * END OF DCLGENS FOR CPD0010S.                                  *         
      *****************************************************************         
      /*****   JOURNALLING WORKING STORAGE VARIABLES                            
           EXEC SQL                                                             
               INCLUDE CWS00013                                                 
           END-EXEC.                                                            
      /*****   PAYMENT POSTING WORKING STORAGE VARIABLES                        
           EXEC SQL                                                             
               INCLUDE CWS00017                                                 
           END-EXEC.                                                            
      /***** CHARGE-OFF PAYMENT POSTING WORKING STORAGE VARIABLES               
           EXEC SQL                                                             
               INCLUDE CWS00073                                                 
           END-EXEC.                                                            
HPCCDM*EJECT                                                                    
T25584*                                                                         
NONUTL******************************************************************        
NONUTL*    HOLIDAY CHECK                                                        
NONUTL******************************************************************        
NONUTL     EXEC SQL                                                             
NONUTL         INCLUDE CWS10016                                                 
NONUTL     END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      ******************************************************************        
      **  THIS CURSOR IS USED AS THE CONTROLLING LOGIC FOR THE PROGRAM.*        
      **  IT WILL SELECT ALL THE ACCOUNTS THAT HAVE A CIA(CREDIT IN   .*        
      **  ADVANCE,ITEM_ID=1 IN UNUSED CREDIT) AND/OR LIHEAP CREDIT     *        
      **  (ITEM_ID=2).FROM THIS,THE PROGRAM WILL TRY AND DISTRIBUTE THE*        
      **  MONEY TO ANY CHARGES AND/OR RECEIVABLES THAT IT CAN. IT      *        
      **  SHOULD APPLY FROM ITEM_ID 2 FIRST, IF BOTH ON THE ACCOUNT.   *        
      ******************************************************************        
C     * CHANGED CURSOR TO WITH HOLD FOR COMMIT LOGIC                   *        
C     *                                                                *        
           EXEC SQL                                                     
               DECLARE AR_CNTL_CURSOR CURSOR WITH HOLD FOR              
                SELECT ACCOUNT_NO,                                      
                       ITEM_ID,                                         
                       AMT_UNUSED_CR                                    
                  FROM CSS_AR_CNTL                                      
                 WHERE PYMT_PRIORITY_LVL  = :WS-VALUE-70                
T15297             AND ITEM_ID            IN (1,2)                      
                   AND AMT_UNUSED_CR      < 0                           
                 ORDER BY ACCOUNT_NO, ITEM_ID DESC                      
           END-EXEC.                                                    
P00851******************************************************************        
P00851* CURSOR TO SELECT ALL PENDING ADV. COLLECTION CONTRACTS         *        
P00851******************************************************************        
P00851     EXEC SQL                                                     
P00851         DECLARE ADV_CNT_CUR CURSOR WITH HOLD FOR                 
P00851            SELECT                                                
P00851                    AC.ACCOUNT_NO                                 
P00851                   ,AC.ITEM_ID                                    
P00851                   ,AC.AMT_TRAN_BALANCE                           
P00851              FROM                                                
P00851                    CSS_AR_CNTL     AC WITH(READUNCOMMITTED)              
P00851                   ,CSS_CONTRACT CT WITH(READUNCOMMITTED)                 
P00851             WHERE                                                
P00851                   CT.CNT_STATUS_CD      =  'A'                   
P00851               AND CT.CODE_CONTRACT_TYPE =  'B'                   
P00851               AND CT.CNT_NAME_CD        IN (1099, 1199)          
P00851               AND CT.PYMT_PRIORITY_LVL  =  100                   
P00851               AND AC.PYMT_PRIORITY_LVL  =  100                   
P00851               AND AC.ACCOUNT_NO         =  CT.ACCOUNT_NO         
P00851               AND AC.ITEM_ID            =  CT.CNT_ITEM_ID        
P00851         FOR READ ONLY                                           
P00851                                                           
P00851                                                      
P00851     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE ADV_CNT_CUR CURSOR WITH HOLD FOR                         
MFA-TR*           SELECT                                                        
MFA-TR*                   AC.ACCOUNT_NO                                         
MFA-TR*                  ,AC.ITEM_ID                                            
MFA-TR*                  ,AC.AMT_TRAN_BALANCE                                   
MFA-TR*             FROM                                                        
MFA-TR*                   CSS_AR_CNTL     AC                                    
MFA-TR*                  ,CSS_CONTRACT CT                                       
MFA-TR*            WHERE                                                        
MFA-TR*                  CT.CNT_STATUS_CD      =  'A'                           
MFA-TR*              AND CT.CODE_CONTRACT_TYPE =  'B'                           
MFA-TR*              AND CT.CNT_NAME_CD        IN (1099, 1199)                  
MFA-TR*              AND CT.PYMT_PRIORITY_LVL  =  100                           
MFA-TR*              AND AC.PYMT_PRIORITY_LVL  =  100                           
MFA-TR*              AND AC.ACCOUNT_NO         =  CT.ACCOUNT_NO                 
MFA-TR*              AND AC.ITEM_ID            =  CT.CNT_ITEM_ID                
MFA-TR*        FOR FETCH ONLY                                                   
MFA-TR*             WITH UR                                                     
MFA-TR*          QUERYNO 7030                                                   
MFA-TR*    END-EXEC.                                                            
P00851*                                                                         
P00851******************************************************************        
P00851* CURSOR TO SELECT ALL INSTALLMENT CONTRACTS                     *        
P00851* CONTRACT_TYPE-> 'A'-ELEC MARKETING  'B'-GAS MARKETING         *        
P00851* BILL_TYPE    -> 'A'-ONE TIME CHRG   'C'-INSTALLMENT           *        
P00851* STATUS_CD    -> 'B'-ACTIVE          'E'-CLOSED                *        
P00851******************************************************************        
P00851*                                                                         
P00851     EXEC SQL                                                     
P00851         DECLARE INSTALLMENT_CNT_CUR CURSOR WITH HOLD FOR         
P00851            SELECT                                                
P00851                    AC.ITEM_ID                                    
P00851                   ,AC.AMT_TRAN_BALANCE                           
ACT018                   ,CT.AMT_DOWN_PYMT                              
P00851              FROM                                                
P00851                    CSS_AR_CNTL AC WITH(READUNCOMMITTED)                  
P00851                   ,CSS_CONTRACT CT WITH(READUNCOMMITTED)                 
P00851             WHERE                                                
P00851                   AC.ACCOUNT_NO         =  :AC-ACCOUNT-NO        
P00851               AND CT.ACCOUNT_NO         =  AC.ACCOUNT_NO         
P00851               AND AC.PYMT_PRIORITY_LVL  =  100                   
P00851               AND CT.PYMT_PRIORITY_LVL  =  AC.PYMT_PRIORITY_LVL  
P00851               AND AC.ITEM_ID            =  CT.CNT_ITEM_ID        
P00851               AND CT.CODE_BILL_TYPE     IN ('A', 'C')            
P00851               AND CT.CODE_CONTRACT_TYPE IN ('A', 'B', 'F')       
P00851               AND CT.CNT_STATUS_CD      IN ('B', 'E')            
P00851         FOR READ ONLY                                           
P00851                                                           
P00851                                                      
P00851     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE INSTALLMENT_CNT_CUR CURSOR WITH HOLD FOR                 
MFA-TR*           SELECT                                                        
MFA-TR*                   AC.ITEM_ID                                            
MFA-TR*                  ,AC.AMT_TRAN_BALANCE                                   
MFA-TR*                  ,CT.AMT_DOWN_PYMT                                      
MFA-TR*             FROM                                                        
MFA-TR*                   CSS_AR_CNTL AC                                        
MFA-TR*                  ,CSS_CONTRACT CT                                       
MFA-TR*            WHERE                                                        
MFA-TR*                  AC.ACCOUNT_NO         =  :AC-ACCOUNT-NO                
MFA-TR*              AND CT.ACCOUNT_NO         =  AC.ACCOUNT_NO                 
MFA-TR*              AND AC.PYMT_PRIORITY_LVL  =  100                           
MFA-TR*              AND CT.PYMT_PRIORITY_LVL  =  AC.PYMT_PRIORITY_LVL          
MFA-TR*              AND AC.ITEM_ID            =  CT.CNT_ITEM_ID                
MFA-TR*              AND CT.CODE_BILL_TYPE     IN ('A', 'C')                    
MFA-TR*              AND CT.CODE_CONTRACT_TYPE IN ('A', 'B', 'F')               
MFA-TR*              AND CT.CNT_STATUS_CD      IN ('B', 'E')                    
MFA-TR*        FOR FETCH ONLY                                                   
MFA-TR*             WITH UR                                                     
MFA-TR*          QUERYNO 7050                                                   
MFA-TR*    END-EXEC.                                                            
P00851*                                                                         
      ******************************************************************        
      *    DECLARE GL ACCT-NO CURSOR *                                          
      ******************************************************************        
C     * CHANGED CURSOR TO WITH HOLD FOR COMMIT LOGIC                   *        
C     *                                                                *        
           EXEC SQL                                                     
ACT215         DECLARE GL_NBRS CURSOR           FOR                     
                SELECT  A.COMPANY_NO,                                   
                        A.GL_ACCT_NO,                                   
                        B.LOCAL_OFFICE                                  
                FROM    CSS_GL_ACCT_NO A WITH(READUNCOMMITTED),                 
                        CSS_GL_ACCOUNT B WITH(READUNCOMMITTED)                  
                WHERE   A.GL_ACCT_NAME = :GO-GL-ACCT-NAME               
                  AND   A.GL_ACCT_NO   = B.GL_ACCT_NO                   
MCR310            AND   A.COMPANY_NO   = '01'                           
ACT215          ORDER BY A.GL_ACCT_NO                                   
ACT215          FOR READ ONLY                                   
ACT215                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE GL_NBRS CURSOR           FOR                             
MFA-TR*         SELECT  A.COMPANY_NO,                                           
MFA-TR*                 A.GL_ACCT_NO,                                           
MFA-TR*                 B.LOCAL_OFFICE                                          
MFA-TR*         FROM    CSS_GL_ACCT_NO A,                                       
MFA-TR*                 CSS_GL_ACCOUNT B                                        
MFA-TR*         WHERE   A.GL_ACCT_NAME = :GO-GL-ACCT-NAME                       
MFA-TR*           AND   A.GL_ACCT_NO   = B.GL_ACCT_NO                           
MFA-TR*           AND   A.COMPANY_NO   = '01'                                   
MFA-TR*         ORDER BY A.GL_ACCT_NO                                           
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7820                                                    
MFA-TR*    END-EXEC.                                                            
C30083                                                                  
C30083******************************************************************        
C30083*    DECLARE DEPOSIT AR-CNTL CURSOR                              *        
C30083******************************************************************        
C30083*                                                                *        
C30083     EXEC SQL                                                     
C30083         DECLARE DEP-AR-CNTL CURSOR WITH HOLD FOR                 
C30083          SELECT  AC.AMT_TRAN_BALANCE,                            
C30083                  AC.ITEM_ID,                                     
C30083                  REPLACE(REPLACE(CONVERT(CHAR(26), 
           AC.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
C30083          FROM    CSS_AR_CNTL AC                                  
C30083          WHERE   AC.ACCOUNT_NO        = :AC-ACCOUNT-NO           
C30083            AND   AC.PYMT_PRIORITY_LVL = +80                      
C30083            AND   AC.ITEM_ID           > 0                        
C30083            AND   AC.AMT_TRAN_BALANCE  > 0                        
C30083          ORDER BY AC.ITEM_ID                                     
C30083          FOR READ ONLY                                          
C30083     END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE DEP-AR-CNTL CURSOR WITH HOLD FOR                         
MFA-TR*         SELECT  AC.AMT_TRAN_BALANCE,                                    
MFA-TR*                 AC.ITEM_ID,                                             
MFA-TR*                 AC.LAST_UPDATE_TS                                       
MFA-TR*         FROM    CSS_AR_CNTL AC                                          
MFA-TR*         WHERE   AC.ACCOUNT_NO        = :AC-ACCOUNT-NO                   
MFA-TR*           AND   AC.PYMT_PRIORITY_LVL = +80                              
MFA-TR*           AND   AC.ITEM_ID           > 0                                
MFA-TR*           AND   AC.AMT_TRAN_BALANCE  > 0                                
MFA-TR*         ORDER BY AC.ITEM_ID                                             
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE C1 CURSOR
MSQ001          FOR CALL CSR02384                                      
C30083      ( :PARM-ACCOUNT-NO
                  , :PARM-PYMT-PRIORITY-LVL
                  , :PARM-ITEM-ID
                  , :PARM-RECV-TYPE
                  , :PARM-AMT-AR-DAY-00
                  , :PARM-AMT-AR-DAY-30
                  , :PARM-AMT-AR-DAY-60
                  , :PARM-AMT-AR-DAY-90
                  , :PARM-USER-ID
                  , :PARM-RESP-AREA-ID
                  , :PARM-TOT-SUMM-UNBILLED
                  , :PARM-RECORD-ONLY-FLAG
                  , :PARM-COMMENT-LEN
                  , :PARM-COMMENT-TEXT
                  , :PARM-AC-LAST-UPDATE-TS
                  , :PARM-AT-LAST-UPDATE-TS
                  , :PARM-PANEL-NO
                  )
MSQ001        END-EXEC.
                                                    
HPCCDM*EJECT                                                                    
      /                                                                         
      *                                                                         
       PROCEDURE DIVISION.                                              

SCA006        SET GL-IND TO 1.
SCA006        SET WS-GL-SUB TO 1.
                                                                        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
      **                                                              **        
      **    0000-MAINLINE                                             **        
      **                                                              **        
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                                                        
             PERFORM 1200-LOAD-GL-NUMBERS     THRU 1200-EXIT            
                                                                        
             PERFORM 1300-LOAD-GL-ACCTS       THRU 1300-EXIT            
                                                                        
             PERFORM 2000-PROCESS-ACCOUNT     THRU 2000-EXIT            
               UNTIL WS-NO-MORE-CREDITS                                 
                                                                        
             PERFORM 7020-CLOSE-AR-CNTL         THRU 7020-EXIT          
C            PERFORM 8898-ISSUE-COMMIT          THRU 8898-EXIT          
C            DISPLAY 'TOTAL NO OF COMMITS' WS-TOT-COMMIT-CNT            
                                                                        
           END-IF.                                                      
P00851*                                                                         
P00851     IF CSR-DATABASE                                              
P00851        DISPLAY '*** ADV. COLL CONTRACTS PROCESSING STARTED ***'  
P00851        MOVE SPACES                     TO WS-NO-MORE-CREDITS-SW  
P00851                                           WS-IS-CIA-PROCES-SW    
P00851        PERFORM 7030-OPEN-ADV-CNT-CUR      THRU 7030-EXIT         
P00851        PERFORM 7031-FETCH-ADV-CNT-CUR     THRU 7031-EXIT         
P00851        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
P00851           PERFORM 2010-PROCESS-ADV-CNT    THRU 2010-EXIT         
P00851             UNTIL WS-NO-MORE-CREDITS                             
P00851        END-IF                                                    
P00851        PERFORM 7032-CLOSE-ADV-CNT-CUR     THRU 7032-EXIT         
P00851        PERFORM 8898-ISSUE-COMMIT          THRU 8898-EXIT         
P00851        DISPLAY 'TOTAL NO OF COMMITS' WS-TOT-COMMIT-CNT           
P00851     END-IF.                                                      
P00851*                                                                         
           PERFORM 9000-TERMINATE             THRU 9000-EXIT.           
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 0100-INITIALIZE.                                           **          
      **  PERFORMS OPEN FILES, WRITE BEGIN RECORD, INITIALIZE CODE1 **          
      **  CALL AREA OPENS CURSOR1 & FETCHES 1ST RECORD FROM CSR1    **          
T18024**  AND ALSO FETCHES THE DATE FROM CSS_JOB_PARM TABLE         **          
      ****************************************************************          
       0100-INITIALIZE.                                                 
      *                                                                         
ACT403     SET WS-GL-SUB TO 1.                                          
C          MOVE WS-PGRMNAME                  TO G6-PROGRAM-NAME.        
C                                                                       
C          PERFORM 7400-SELECT-JOB-PARM-COUNT                           
C                                            THRU 7400-EXIT.            
C          MOVE G6-PARM-DATA(1:8)            TO WS-COMMIT-UPD-COUNTER.  
C     *                                                                         
T18024     PERFORM 6251-GET-FJC01-DATE       THRU 6251-EXIT.            
T18024*                                                                         
T18024     IF COMMON-DATE-NEEDED                                        
T18024        PERFORM 6240-GET-FCA00-COMMON-DATE                        
T18024                                       THRU 6240-EXIT             
T18024        MOVE WS-FCA00-COMMON-DATE      TO WS-INPUT-DATE           
T18024     END-IF.                                                      
T18024*                                                                         
T18024     MOVE WS-INPUT-DATE                TO WS-CURRENT-DATE.        
T18024*                                                                         
      *                                                                         
           MOVE SPACES                TO WS-NO-MORE-CREDITS-SW          
P00851                                   WS-GL-NOS-LOADED-SW            
                                         WS-PYMT-PRTY-LOAD-SW.          
      *                                                                         
      *  CHECK AR LOCKOUT                                                       
PCR640     PERFORM 7999-SELECT-AL THRU 7999-SELECT-AL-EXIT              
PCR640     IF AL-AR-LOCKOUT-IND = 'Y'                                   
PCR640        DISPLAY ' '                                               
PCR640        DISPLAY '**  PCSCA130 PROCESSING ERROR  **'               
PCR640        DISPLAY '**  AR LOCKOUT IN EFFECT       **'               
PCR640        DISPLAY '**  PROCESSING TERMINATED      **'               
PCR640        PERFORM 9900-ABEND           THRU 9900-EXIT
           END-IF.              
T11466     PERFORM 7960-GET-CURRENT-DATE THRU 7960-EXIT.                
C30083*                                                                         
C30083* GET CURRENT DATABASE                                            03151109
C30083     MOVE '01'                     TO C8-COMPANY-NO.              
C30083     MOVE 'DATABASE'               TO C8-DELINQ-CD.               
C30083     PERFORM 7410-GET-DATABASE     THRU 7410-EXIT.                
C30083     MOVE C8-DELINQ-VALUE          TO WS-DATABASE.                
      *                                                                         
           PERFORM 7000-OPEN-AR-CNTL          THRU 7000-EXIT.           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
            PERFORM 7010-FETCH-AR-CNTL        THRU 7010-EXIT
           END-IF.           
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *    LOAD GL NUMBER VALUES OF DESIRED GL NUMBERS.*                        
      *****************************************************************         
       1200-LOAD-GL-NUMBERS.                                            
      ***  LOAD GL NUMBERS FROM TBGLATNO                                        
T24436     MOVE PROGRAM-NAME               TO  WS-CPD00061-CALLING-PGM. 
T24436     MOVE SPACES                     TO  ABEND-FUNCTION.          
T24436     CALL SCSCB061  USING   WS-GL-ACCT-NAME,                      
T24436                            WS-GL-ACCT-MAJOR-FIELDS,              
T24436                            WS-VALID-COMPANY-NOS,                 
T24436                            WS-GL-NAME-INFO,                      
T24436                            WS-GL-ACCT-NO-TABLE,                  
T24436                            WS-CPD00061-CALLING-PGM,              
T24436                            ABEND-FILE,                           
T24436                            RS-RETURN-CODE.                       
T24436                                                                  
T24436     IF ABEND-FUNCTION  > SPACES                                  
T24436        PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
T24436     END-IF.                                                      
                                                                        
      ** SUBTRACT 1 BECAUSE INDEX IS 1 MORE THAN LAST OCCURENCE LOADED          
           SUBTRACT 1 FROM WS-VALID-CO-SUB.                             
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
      *                                                                         
      *****************************************************************         
      *    LOAD GL ACCOUNT NUMBERS FOR DESIRED GL ACCOUNT VALUES.     *         
      *****************************************************************         
       1300-LOAD-GL-ACCTS.                                              
                                                                        
ACT215     MOVE 0 TO GL-CNT.                                            
           MOVE 0 TO WS-GL-SUBSCRIPT.                                   
                                                                        
           MOVE WS-GL-CASH-KEY TO GO-GL-ACCT-NAME.                      
           PERFORM 1305-GL-LOAD-ROUTINE THRU 1305-EXIT.                 
                                                                        
           MOVE WS-GL-LPC-KEY TO GO-GL-ACCT-NAME.                       
           PERFORM 1305-GL-LOAD-ROUTINE THRU 1305-EXIT.                 
                                                                        
           MOVE WS-GL-LPN-KEY TO GO-GL-ACCT-NAME.                       
           PERFORM 1305-GL-LOAD-ROUTINE THRU 1305-EXIT.                 
                                                                        
           MOVE WS-GL-ELC-KEY TO GO-GL-ACCT-NAME.                       
           PERFORM 1305-GL-LOAD-ROUTINE THRU 1305-EXIT.                 
                                                                        
           MOVE WS-GL-GAS-KEY TO GO-GL-ACCT-NAME.                       
           PERFORM 1305-GL-LOAD-ROUTINE THRU 1305-EXIT.                 
                                                                        
           MOVE WS-GL-EPP-KEY TO GO-GL-ACCT-NAME.                       
           PERFORM 1305-GL-LOAD-ROUTINE THRU 1305-EXIT.                 
                                                                        
           MOVE WS-GL-CCC-KEY TO GO-GL-ACCT-NAME.                       
           PERFORM 1305-GL-LOAD-ROUTINE THRU 1305-EXIT.                 
                                                                        
           MOVE WS-GL-DFA-KEY TO GO-GL-ACCT-NAME.                       
           PERFORM 1305-GL-LOAD-ROUTINE THRU 1305-EXIT.                 
                                                                        
           MOVE WS-GL-DEP-KEY TO GO-GL-ACCT-NAME.                       
           PERFORM 1305-GL-LOAD-ROUTINE THRU 1305-EXIT.                 
                                                                        
           MOVE WS-GL-CNT-KEY TO GO-GL-ACCT-NAME.                       
           PERFORM 1305-GL-LOAD-ROUTINE THRU 1305-EXIT.                 
                                                                        
           MOVE WS-GL-NSA-KEY TO GO-GL-ACCT-NAME.                       
           PERFORM 1305-GL-LOAD-ROUTINE THRU 1305-EXIT.                 
                                                                        
           MOVE WS-GL-NSC-KEY TO GO-GL-ACCT-NAME.                       
           PERFORM 1305-GL-LOAD-ROUTINE THRU 1305-EXIT.                 
                                                                        
           MOVE WS-GL-NSN-KEY TO GO-GL-ACCT-NAME.                       
           PERFORM 1305-GL-LOAD-ROUTINE THRU 1305-EXIT.                 
                                                                        
           MOVE WS-GL-PJS-KEY TO GO-GL-ACCT-NAME.                       
           PERFORM 1305-GL-LOAD-ROUTINE THRU 1305-EXIT.                 
                                                                        
       1300-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
      *****************************************************************         
      * OPEN, LOOP, AND CLOSE FOR LOADING EACH GL NUMBER                        
      *****************************************************************         
       1305-GL-LOAD-ROUTINE.                                            
                                                                        
           PERFORM 7800-OPEN-GL-NBRS THRU 7800-EXIT.                    
           PERFORM 1350-LOOP-GL-NBRS THRU 1350-EXIT                     
                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
                   OR WS-GL-SUBSCRIPT GREATER THAN 2000.                
           PERFORM 7850-CLOSE-GL-NBRS THRU 7850-EXIT.                   
                                                                        
       1305-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
      *****************************************************************         
      *    LOOP GL NUMBERS                                                      
      *****************************************************************         
       1350-LOOP-GL-NBRS.                                               
                                                                        
           PERFORM 7820-FETCH-GL-NBRS THRU 7820-EXIT.                   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT215         ADD 1 TO GL-CNT                                          
               MOVE GO-COMPANY-NO                                       
                     TO WS-GL-COMPANY (WS-GL-SUBSCRIPT)                 
               MOVE GO-GL-ACCT-NO                                       
                     TO WS-GL-ACCOUNT-NO (WS-GL-SUBSCRIPT)              
               MOVE GL-LOCAL-OFFICE                                     
                     TO WS-GL-LOCAL-OFFICE (WS-GL-SUBSCRIPT)            
               MOVE GO-GL-ACCT-NAME                                     
                     TO WS-GL-ACCOUNT-NAME (WS-GL-SUBSCRIPT)
           END-IF.           
                                                                        
        1350-EXIT.                                                      
            EXIT.                                                       
HPCCDM* EJECT                                                                   
      *                                                                         
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
      **                                                              **        
      ** DO INITIAL CHECK OF AR_CNTL ROWS TO SEE IF THERE IS ANYTHING           
      ** TO APPLY THE CREDIT TO BEFORE DOING ANY MORE WORK FOR THIS             
      ** ACCOUNT.                                                               
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
       2000-PROCESS-ACCOUNT.                                            
                                                                        
           MOVE ZEROES                TO WS-CIA-SUM-UNUSED-CR           
                                         WS-CIA-CREDIT                  
                                         WS-LIHEAP-CREDIT.              
C          MOVE AC-ACCOUNT-NO         TO AT-ACCOUNT-NO                  
                                         WS-COMMIT-ACCT-NO.             
C          MOVE AC-ITEM-ID            TO WS-COMMIT-ITEM-ID.             
C          MOVE AC-AMT-UNUSED-CR      TO WS-COMMIT-AMT-UNUSED-CR.       
T15301     PERFORM 7100-SELECT-ACCT           THRU 7100-EXIT.           
T15301     PERFORM 7250-SELECT-CIA-DEBIT      THRU 7250-EXIT.           
T15301     IF WS-AMT-AR-DAY-00 > 0                                      
P00851        INITIALIZE CWS00077-FIELDS                                
P00851        MOVE +46                TO WS-77-COMMENTS-LEN             
P00851        MOVE 124                TO WS-77-CATEGORY-ID              
P00851        MOVE 'H'                TO WS-77-PRIORITY                 
P00851        MOVE '4'                TO WS-77-ROUTE-CATEGORY           
P00851        MOVE 'DISPERSE CIA DEBIT TO APPROPRIATE RECEIVABLES '     
P00851                                TO WS-77-COMMENTS-TEXT            
T15301        PERFORM 3300-GENERATE-WORK-QUEUE THRU 3300-EXIT           
T15301     ELSE                                                         
C30083         IF  SEB-DATABASE                                         
C30083         AND AT-CODE-ACCT-STAT = 'P'                              
C30083            PERFORM 7210-CHECK-CHARGED-DEP       THRU 7210-EXIT   
C30083            IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL           
C30083            AND WS-AMT-TRAN-BALANCE > 0                           
C30083                MOVE 'Y'  TO WS-SEB-PNDG-CHG-DEP                  
C30083                PERFORM 2050-PROCEED-WITH-ACCT   THRU 2050-EXIT   
C30083            ELSE                                                  
C30083                MOVE 'N'  TO WS-SEB-PNDG-CHG-DEP                  
C30083                PERFORM 7200-SELECT-ALL-OWED THRU 7200-EXIT       
C30083                IF WS-AMT-ACCT-OWED > 0                           
C30083                   PERFORM 2050-PROCEED-WITH-ACCT THRU 2050-EXIT  
C30083                ELSE                                              
C30083                   MOVE 0       TO WS-CHRG-OFF-AMT                
C30083                   MOVE AC-ACCOUNT-NO TO CO-ACCOUNT-NO            
C30083                   PERFORM 7200A-SELECT-CHRG-OFF THRU 7200A-EXIT  
C30083                   IF WS-CHRG-OFF-AMT > 0                         
C30083                     PERFORM 2050-PROCEED-WITH-ACCT THRU 2050-EXIT
C30083                   END-IF                                         
C30083                END-IF                                            
C30083            END-IF                                                
C30083         ELSE                                                     
C30083            MOVE 'N'      TO WS-SEB-PNDG-CHG-DEP                  
                  PERFORM 7200-SELECT-ALL-OWED THRU 7200-EXIT           
                  IF WS-AMT-ACCT-OWED > 0                               
                     PERFORM 2050-PROCEED-WITH-ACCT THRU 2050-EXIT      
T17819            ELSE                                                  
T17819               MOVE 0           TO WS-CHRG-OFF-AMT                
T17819               MOVE AC-ACCOUNT-NO TO CO-ACCOUNT-NO                
T17819               PERFORM 7200A-SELECT-CHRG-OFF THRU 7200A-EXIT      
T17819               IF WS-CHRG-OFF-AMT > 0                             
T17819                 PERFORM 2050-PROCEED-WITH-ACCT THRU 2050-EXIT    
T17819               END-IF                                             
                  END-IF                                                
C30083         END-IF                                                   
T15301     END-IF                                                       
C          PERFORM 8898-ISSUE-COMMIT          THRU 8898-EXIT            
           PERFORM 7010-FETCH-AR-CNTL         THRU 7010-EXIT.           
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
             MOVE WS-TRUE             TO WS-NO-MORE-CREDITS-SW          
           END-IF.                                                      
      *                                                                         
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
P00851*                                                                         
P00851******************************************************************        
P00851*  PROCESS ADV. COLLECTION CONTRACTS                             *        
P00851******************************************************************        
P00851*                                                                         
P00851 2010-PROCESS-ADV-CNT.                                            
P00851*                                                                         
P00851     MOVE AC-ACCOUNT-NO         TO AT-ACCOUNT-NO                  
P00851                                   CT-ACCOUNT-NO                  
P00851                                   WS-COMMIT-ACCT-NO.             
P00851     MOVE AC-ITEM-ID            TO WS-COMMIT-ITEM-ID              
P00851                                   WS-FROM-ITEM-ID.               
P00851     MOVE AC-AMT-TRAN-BALANCE   TO WS-COMMIT-AMT-UNUSED-CR.       
P00851     COMPUTE WS-AMT-TO-MOVE    = AC-AMT-TRAN-BALANCE * -1.        
P00851     PERFORM 7100-SELECT-ACCT            THRU 7100-EXIT.          
P00851*                                                                         
P00851     PERFORM 2011-CHK-INSTALLMENT-CNT    THRU 2011-EXIT.          
P00851*                                                                         
P00851     IF WS-IS-CNT-FOUND                                           
P00851        IF WS-IS-AMT-MATCHED                                      
P00851           PERFORM 2300-DISTRIBUTE-CNT   THRU 2300-EXIT           
P00851        ELSE                                                      
P00851           INITIALIZE CWS00077-FIELDS                             
P00851           IF AT-COMPANY-NO = '01'                                
P00851              MOVE 574          TO WS-77-CATEGORY-ID              
P00851                                   WQ-CATEGORY-ID                 
P00851           ELSE                                                   
P00851              MOVE 575          TO WS-77-CATEGORY-ID              
P00851                                   WQ-CATEGORY-ID                 
P00851           END-IF                                                 
P00851           MOVE 'N'             TO WS-WQ-EXISTS-SW                
P00851           MOVE AT-ACCOUNT-NO   TO WQ-ACCOUNT-NO                  
P00851           PERFORM 7060-SEL-WQ-ITEMS     THRU 7060-EXIT           
P00851           IF NOT WS-WQ-EXISTS                                    
P00851                                                                  
P00851              MOVE 'H'          TO WS-77-PRIORITY                 
P00851              MOVE '4'          TO WS-77-ROUTE-CATEGORY           
P00851              MOVE +43          TO WS-77-COMMENTS-LEN             
P00851              MOVE 'ADVANCE COLLECTED DOES NOT MATCH CHARGE AMT'  
P00851                                TO WS-77-COMMENTS-TEXT            
P00851              PERFORM 3300-GENERATE-WORK-QUEUE                    
P00851                                         THRU 3300-EXIT           
P00851           END-IF                                                 
P00851        END-IF                                                    
P00851     END-IF.                                                      
P00851*                                                                         
P00851     PERFORM 8898-ISSUE-COMMIT           THRU 8898-EXIT.          
P00851     PERFORM 7031-FETCH-ADV-CNT-CUR      THRU 7031-EXIT.          
P00851     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
P00851       MOVE WS-TRUE             TO WS-NO-MORE-CREDITS-SW          
P00851     END-IF.                                                      
P00851*                                                                         
P00851 2010-EXIT.                                                       
P00851     EXIT.                                                        
P00851*                                                                         
P00851******************************************************************        
P00851*  CHECK WHETHER INSTALLMENT CNT EXISTS & AMT MATCHES            *        
P00851******************************************************************        
P00851*                                                                         
P00851 2011-CHK-INSTALLMENT-CNT.                                        
P00851*                                                                         
P00851     MOVE WS-N                  TO WS-IS-CNT-FOUND-SW             
P00851                                   WS-IS-AMT-MATCHED-SW.          
P00851*                                                                         
P00851     PERFORM 7050-OPEN-INSTALLMENT-CNT-CUR     THRU 7050-EXIT.    
P00851     PERFORM 7051-FETCH-INSTALLMENT-CNT-CUR    THRU 7051-EXIT.    
P00851*                                                                         
P00851     PERFORM UNTIL WS-IS-AMT-MATCHED                              
P00851                OR WS-ACTIVE-RETURN-CODE = NOT-FOUND              
P00851        MOVE WS-Y               TO WS-IS-CNT-FOUND-SW             
P00851        IF (AC-AMT-TRAN-BALANCE  =  WS-AMT-TO-MOVE)  OR           
ACT018           (CT-AMT-DOWN-PYMT     =  WS-AMT-TO-MOVE)               
P00851           MOVE WS-Y            TO WS-IS-AMT-MATCHED-SW           
P00851        ELSE                                                      
P00851           PERFORM 7051-FETCH-INSTALLMENT-CNT-CUR                 
P00851                                               THRU 7051-EXIT     
P00851        END-IF                                                    
P00851     END-PERFORM.                                                 
P00851*                                                                         
P00851     PERFORM 7052-CLOSE-INSTALLMENT-CNT-CUR    THRU 7052-EXIT.    
P00851*                                                                         
P00851 2011-EXIT.                                                       
P00851     EXIT.                                                        
      *                                                                         
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
      **                                                              **        
      ** GET ACCOUNT INFO TO LOAD GL NUMBERS AND TO CALL CPD00010.              
      ** IF THERE IS A CIA CREDIT DISTRIBUTE THE CREDIT AND/OR IF THERE*        
      ** IS A LIHEAP CREDIT DISTRIBUTE IT ALSO, IF POSSIBLE. DISTRIBUTE*        
      ** THE LIHEAP CREDIT FIRST IF BOTH ON THE ACCOUNT.               *        
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
       2050-PROCEED-WITH-ACCT.                                          
                                                                        
           MOVE AC-ACCOUNT-NO         TO AT-ACCOUNT-NO.                 
           PERFORM 7100-SELECT-ACCT           THRU 7100-EXIT.           
           PERFORM 2700-LOAD-GL-NBRS          THRU 2700-EXIT.           
                                                                        
           MOVE ZEROES                TO WS-CIA-SUM-UNUSED-CR.          
                                                                        
           IF AC-ITEM-ID = 2                                            
           AND AC-AMT-UNUSED-CR < 0                                     
              PERFORM 2200-DISTRIBUTE-LIHEAP  THRU 2200-EXIT            
           END-IF.                                                      
           IF AC-ITEM-ID = 1                                            
           AND AC-AMT-UNUSED-CR < 0                                     
              PERFORM 2100-DISTRIBUTE-CIA     THRU 2100-EXIT            
           END-IF.                                                      
                                                                        
           MOVE ZEROES                TO WS-AMT-TOT-UNUSED-CR.          
           PERFORM 7300-SUM-CIA-DETAIL        THRU 7300-EXIT.           
           MOVE WS-VALUE-70           TO AC-PYMT-PRIORITY-LVL.          
           MOVE ZEROES                TO AC-ITEM-ID                     
T19546                                   WS-SUMM-AMT-AR-DAY-30          
T19546                                   WS-SUMM-AMT-AR-DAY-60          
T19546                                   WS-SUMM-AMT-AR-DAY-90          
T19546                                   WS-SUMM-TOT-SUMM-UNBILLED.     
T15297     IF WS-AMT-TOT-UNUSED-CR < 0 OR WS-AMT-AR-DAY-00 > 0          
              MOVE WS-AMT-TOT-UNUSED-CR TO WS-SUMM-AMT-UNUSED-CR        
T15297        MOVE WS-AMT-AR-DAY-00     TO WS-SUMM-AMT-AR-DAY-00        
              PERFORM 6706-UPDATE-AR-SUMMARY  THRU 6706-EXIT            
           ELSE                                                         
              PERFORM 7100-SELECT-ACCT        THRU 7100-EXIT            
              MOVE AT-CODES-DATA-PRESENT                                
                                      TO WS-CODES-DATA-PRESENT          
              MOVE SPACES             TO WS-CODE-CIA                    
              MOVE WS-CODES-DATA-PRESENT                                
                                      TO AT-CODES-DATA-PRESENT          
              PERFORM 8000-UPDATE-ACCOUNT     THRU 8000-EXIT            
              PERFORM 6797-DELETE-CSS-AR-ACCT THRU 6797-EXIT            
           END-IF.                                                      
     *** UPDATE OR DELETE DETAIL ROWS.                                          
       2050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
      **                                                              **        
      ** APPLY CIA CREDIT TO ANY CHARGES AND RECEIVABLES WITH AN OUT- **        
      ** STANDING BALANCE IN THE AGING BUCKETS.                       **        
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
       2100-DISTRIBUTE-CIA.                                             
           COMPUTE WS-CIA-CREDIT = AC-AMT-UNUSED-CR * -1.               
                                                                        
      **INITIALIZE THEN LOAD THE TABLE WITH THE BILLED BALANCE OR THE           
      ** UNDIRECTED PAYMENT SCHEDULE IF LIHEAP WAS LOADED.                      
           IF NOT WS-UNDIRECTED-LOADED                                  
              MOVE WS-PAR-B           TO WS-PAR-UPDATE-TYPE             
                                         WS-PYMT-PRTY-LOAD-SW           
              PERFORM 2500-LOAD-PYMT-PRTY-TABLE THRU 2500-EXIT          
           END-IF.                                                      
                                                                        
C30083     IF  SEB-PNDG-CHG-DEP                                         
C30083         PERFORM 2110-APPLY-CIA-ON-DEP THRU 2110-EXIT             
C30083     END-IF                                                       
C30083     MOVE WS-CIA-CREDIT         TO WS-PAYMENT-AMOUNT              
                                         WS-PAYMENT-AMOUNT-TOTAL        
                                         WS-AMT-CASH.                   
           PERFORM 3000-CALL-CPD00010         THRU 3000-EXIT.           
      **WHEN WE COME BACK FROM CPD00010 CHECK THE WS-PAYMENT-AMOUNT             
      **AND UPDATE AR_CNTL WITH THAT AMOUNT IN PPL 70, ITEM-ID 1.               
                                                                        
           MOVE ZEROES                TO AC-AMT-UNUSED-CR.              
           IF WS-REMAINING-PYMT-AMT NOT EQUAL WS-CIA-CREDIT             
TEST          DISPLAY 'ACCOUNT NUMBER PROCESSED : ' AT-ACCOUNT-NO       
              COMPUTE AC-AMT-UNUSED-CR = WS-REMAINING-PYMT-AMT          
                                       * -1                             
              MOVE ZEROES             TO AC-AMT-AR-DAY-00               
                                         AC-AMT-AR-DAY-30               
                                         AC-AMT-AR-DAY-60               
                                         AC-AMT-AR-DAY-90               
T19546                                   AC-TOT-SUMM-UNBILLED           
              MOVE AC-AMT-UNUSED-CR   TO AC-AMT-TRAN-BALANCE            
              MOVE AT-ACCOUNT-NO      TO AC-ACCOUNT-NO                  
              MOVE WS-VALUE-70        TO AC-PYMT-PRIORITY-LVL           
              MOVE +1                 TO AC-ITEM-ID                     
                                                                        
              COMPUTE WS-CIA-SUM-UNUSED-CR =                            
                         WS-CIA-SUM-UNUSED-CR + AC-AMT-UNUSED-CR        
                                                                        
              IF AC-AMT-UNUSED-CR < 0                                   
                PERFORM 6707-UPDATE-AR-DETAIL   THRU 6707-EXIT          
              ELSE                                                      
                PERFORM 6797-DELETE-CSS-AR-ACCT THRU 6797-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
C30083*                                                                         
C30083 2110-APPLY-CIA-ON-DEP.                                           
C30083*                                                                         
C30083     MOVE 'N'                      TO WS-END-OF-DEP               
C30083     MOVE WS-CIA-CREDIT            TO WS-TOT-AMT-MOVD             
C30083     PERFORM 7220-OPEN-DEP-CURSOR  THRU 7220-EXIT                 
C30083     PERFORM 7230-FETCH-DEP-CURSOR THRU 7230-EXIT                 
C30083     PERFORM UNTIL END-OF-DEP                                     
C30083         OR  WS-TOT-AMT-MOVD = 0                                  
C30083         MOVE AC-ACCOUNT-NO        TO AT-ACCOUNT-NO               
C30083         PERFORM 7100-SELECT-ACCT  THRU 7100-EXIT                 
C30083         IF  WS-AMT-TRAN-BALANCE > WS-TOT-AMT-MOVD                
C30083             MOVE WS-TOT-AMT-MOVD  TO WS-AMT-TO-MOVE              
C30083         ELSE                                                     
C30083             MOVE WS-AMT-TRAN-BALANCE TO WS-AMT-TO-MOVE           
C30083         END-IF                                                   
C30083         PERFORM 2120-CORR-BILL-BAL   THRU 2120-EXIT              
C30083         IF  WS-CSR02384-PROCESS = 'Y'                            
C30083             SUBTRACT WS-AMT-TO-MOVE FROM WS-TOT-AMT-MOVD         
C30083         END-IF                                                   
C30083         PERFORM 7230-FETCH-DEP-CURSOR THRU 7230-EXIT             
C30083     END-PERFORM.                                                 
C30083     PERFORM 7240-CLOSE-DEP-CURSOR THRU 7240-EXIT.                
C30083*                                                                         
C30083 2110-EXIT.                                                       
           EXIT.                                                        
C30083*                                                                         
C30083 2120-CORR-BILL-BAL.                                              
C30083*                                                                         
C30083     INITIALIZE WS-INPUT-PARM.                                    
C30083     MOVE 'PCSCA165'             TO PARM-PANEL-NO                 
C30083     MOVE AT-ACCOUNT-NO          TO PARM-ACCOUNT-NO               
C30083     MOVE +80                    TO PARM-PYMT-PRIORITY-LVL        
C30083     MOVE WS-ITEM-ID             TO PARM-ITEM-ID                  
C30083     MOVE 'DEP'                  TO PARM-RECV-TYPE                
C30083     MOVE WS-AMT-TO-MOVE         TO PARM-AMT-AR-DAY-00            
C30083     MOVE ZEROES                 TO PARM-AMT-AR-DAY-30            
C30083                                    PARM-AMT-AR-DAY-60            
C30083                                    PARM-AMT-AR-DAY-90            
C30083                                    PARM-TOT-SUMM-UNBILLED        
C30083     MOVE 'SYSTEM'               TO PARM-USER-ID                  
C30083     MOVE SPACES                 TO PARM-RESP-AREA-ID             
C30083     MOVE SPACES                 TO PARM-RECORD-ONLY-FLAG         
C30083     MOVE '0000'                 TO PARM-COMMENT-LEN              
C30083     MOVE SPACES                 TO PARM-COMMENT-TEXT             
C30083     MOVE WS-AC-LAST-UPDATE-TS   TO PARM-AC-LAST-UPDATE-TS        
C30083     MOVE WS-AT-LAST-UPDATE-TS   TO PARM-AT-LAST-UPDATE-TS        
C30083     PERFORM 7260-SELECT-AT-TIME-STMP                             
C30083                                 THRU 7260-EXIT.                  
C30083     MOVE 'N'                    TO WS-CSR02384-PROCESS.          
C30083     IF WS-AT-LAST-UPDATE-TS = AT-LAST-UPDATE-TS                  
C30083        PERFORM 2130-CALL-CSR02384  THRU 2130-EXIT                
C30083     ELSE                                                         
C30083        DISPLAY 'PCSCA165 WARNING MESSAGE '                       
C30083        DISPLAY 'ACCOUNT_NO : ' AC-ACCOUNT-NO                     
C30083        DISPLAY 'ACCOUNT HAS CHANGED '                            
C30083     END-IF.                                                      
C30083                                                                  
C30083*                                                                         
C30083 2120-EXIT.                                                       
C30083     EXIT.                                                        
C30083*                                                                         
C30083 2130-CALL-CSR02384.                                              
C30083*                                                                         
C30083     INITIALIZE WS-OUTPUT-PARM.                                   
C30083     MOVE 'N' TO WS-CSR02384-PROCESS.                             
C30083*     EXEC SQL CALL CSR02384                                      
C30083*     (:PARM-ACCOUNT-NO                                           
C30083*     ,:PARM-PYMT-PRIORITY-LVL                                    
C30083*     ,:PARM-ITEM-ID                                              
C30083*     ,:PARM-RECV-TYPE                                            
C30083*     ,:PARM-AMT-AR-DAY-00                                        
C30083*     ,:PARM-AMT-AR-DAY-30                                        
C30083*     ,:PARM-AMT-AR-DAY-60                                        
C30083*     ,:PARM-AMT-AR-DAY-90                                        
C30083*     ,:PARM-USER-ID                                              
C30083*     ,:PARM-RESP-AREA-ID                                         
C30083*     ,:PARM-TOT-SUMM-UNBILLED                                    
C30083*     ,:PARM-RECORD-ONLY-FLAG                                     
C30083*     ,:PARM-COMMENT-LEN                                          
C30083*     ,:PARM-COMMENT-TEXT                                         
C30083*     ,:PARM-AC-LAST-UPDATE-TS                                    
C30083*     ,:PARM-AT-LAST-UPDATE-TS                                    
C30083*     ,:PARM-PANEL-NO                                             
C30083*      )                                                          
C30083*     END-EXEC                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE C1
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C1
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C1 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
C30083*     EXEC SQL ASSOCIATE LOCATORS(:LOC1) WITH PROCEDURE           
C30083*        CSR02384                                                 
C30083*     END-EXEC                                                    
C30083*     EXEC SQL                                                    
C30083*       ALLOCATE C1 CURSOR FOR RESULT SET :LOC1                   
C30083*     END-EXEC                                                    
C30083                                                                  
C30083      EXEC SQL                                                    
C30083        FETCH C1 INTO :S-RETURN-CODE                              
C30083                     ,:S-AR-LOCKOUT-IND                           
C30083      END-EXEC                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30083     EVALUATE TRUE                                                
C30083        WHEN S-AR-LOCKOUT-IND = 'Y' AND S-RETURN-CODE = 5000      
C30083            DISPLAY 'PCSCA165 WARNING MESSAGE '                   
C30083            DISPLAY 'ACCOUNT_NO : ' AC-ACCOUNT-NO                 
C30083            DISPLAY 'A/R LOCKOUT IS IN EFFECT'                    
C30083        WHEN S-RETURN-CODE = 200                                  
C30083            DISPLAY 'PCSCA165 WARNING MESSAGE '                   
C30083            DISPLAY 'ACCOUNT_NO : ' AC-ACCOUNT-NO                 
C30083            DISPLAY 'SUMMARY TABLE ENTRY DOES NOT EXIST FOR THE'  
C30083                                         ' RECEIVABLE'            
C30083        WHEN S-RETURN-CODE = -2                                   
C30083            DISPLAY 'PCSCA165 WARNING MESSAGE '                   
C30083            DISPLAY 'ACCOUNT_NO : ' AC-ACCOUNT-NO                 
C30083            DISPLAY 'RECORD HAS BEEN UPDATED SINCE THE'           
C30083                'SELECTION OF THIS ACCOUNT '                      
C30083        WHEN S-RETURN-CODE = -1                                   
C30083            DISPLAY 'PCSCA165 WARNING MESSAGE '                   
C30083            DISPLAY 'ACCOUNT_NO : ' AC-ACCOUNT-NO                 
C30083            DISPLAY 'ACCOUNT HAD A ERROR WHEN CORRECTING BILLED'  
C30083            DISPLAY 'BALANCE FOR DEPOSIT '                        
C30083        WHEN S-RETURN-CODE = 5272                                 
C30083            DISPLAY 'PCSCA165 WARNING MESSAGE '                   
C30083            DISPLAY 'ACCOUNT_NO : ' AC-ACCOUNT-NO                 
C30083            DISPLAY 'ACCOUNT HAS CHANGED '                        
C30083        WHEN S-RETURN-CODE = 0                                    
C30083            MOVE 'Y' TO WS-CSR02384-PROCESS                       
C30083            DISPLAY 'PCSCA165 PROCESSING MESSAGE '                
C30083            DISPLAY 'ACCOUNT_NO : ' AC-ACCOUNT-NO                 
C30083            DISPLAY 'CSR02384 MOVED DEPOSIT ' WS-ITEM-ID          
C30083            DISPLAY 'TO BILLED BALANCE '                          
C30083     END-EVALUATE.                                                
C30083*                                                                         
C30083 2130-EXIT.                                                       
C30083     EXIT.                                                        
C30083*                                                                         
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
      **                                                              **        
      ** APPLY LIHEAP CREDIT TO ANY CHARGES AND RECEIVABLES WITH AN   **        
      ** OUTSTANDING BALANCE IN THE AGING BUCKETS.                    **        
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
       2200-DISTRIBUTE-LIHEAP.                                          
           COMPUTE WS-LIHEAP-CREDIT = AC-AMT-UNUSED-CR * -1.            
                                                                        
      **INITIALIZE THEN LOAD THE TABLE WITH THE LIHEAP PAYMENT                  
      ** SCHEDULE IF UNDIRECTED WAS ALREADY LOADED.                             
           IF NOT WS-LIHEAP-LOADED                                      
              MOVE WS-PAR-L           TO WS-PAR-UPDATE-TYPE             
                                         WS-PYMT-PRTY-LOAD-SW           
              PERFORM 2500-LOAD-PYMT-PRTY-TABLE THRU 2500-EXIT          
           END-IF.                                                      
                                                                        
           MOVE WS-LIHEAP-CREDIT      TO WS-PAYMENT-AMOUNT              
                                         WS-PAYMENT-AMOUNT-TOTAL        
                                         WS-AMT-CASH.                   
                                                                        
           PERFORM 3000-CALL-CPD00010         THRU 3000-EXIT.           
      **WHEN WE COME BACK FROM CPD00010 CHECK THE WS-PAYMENT-AMOUNT             
      **AND UPDATE AR_CNTL WITH THAT AMOUNT IN PPL 70, ITEM-ID 2.               
                                                                        
           MOVE ZEROES                TO AC-AMT-UNUSED-CR.              
           IF WS-REMAINING-PYMT-AMT NOT EQUAL WS-LIHEAP-CREDIT          
              COMPUTE AC-AMT-UNUSED-CR = WS-REMAINING-PYMT-AMT          
                                       * -1                             
              MOVE ZEROES             TO AC-AMT-AR-DAY-00               
                                         AC-AMT-AR-DAY-30               
                                         AC-AMT-AR-DAY-60               
                                         AC-AMT-AR-DAY-90               
T19546                                   AC-TOT-SUMM-UNBILLED           
              MOVE AC-AMT-UNUSED-CR   TO AC-AMT-TRAN-BALANCE            
              MOVE AT-ACCOUNT-NO      TO AC-ACCOUNT-NO                  
              MOVE WS-VALUE-70        TO AC-PYMT-PRIORITY-LVL           
              MOVE +2                 TO AC-ITEM-ID                     
                                                                        
              COMPUTE WS-CIA-SUM-UNUSED-CR =                            
                         WS-CIA-SUM-UNUSED-CR + AC-AMT-UNUSED-CR        
                                                                        
              IF AC-AMT-UNUSED-CR < 0                                   
                PERFORM 6707-UPDATE-AR-DETAIL   THRU 6707-EXIT          
              ELSE                                                      
                PERFORM 6797-DELETE-CSS-AR-ACCT THRU 6797-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00851*                                                                         
P00851******************************************************************        
P00851*  OPEN ADVANCE COLLECTION CONTRACT CURSOR                       *        
P00851******************************************************************        
P00851                                                                  
P00851 2300-DISTRIBUTE-CNT.                                             
P00851*                                                                         
P00851     MOVE WS-AMT-TO-MOVE          TO WS-PAYMENT-AMOUNT            
P00851                                     WS-PAYMENT-AMOUNT-TOTAL      
P00851                                     WS-AMT-CASH.                 
P00851     IF NOT WS-GL-NOS-LOADED                                      
P00851        PERFORM 1200-LOAD-GL-NUMBERS  THRU 1200-EXIT              
P00851        PERFORM 1300-LOAD-GL-ACCTS    THRU 1300-EXIT              
P00851        PERFORM 2700-LOAD-GL-NBRS     THRU 2700-EXIT              
P00851     END-IF.                                                      
P00851*                                                                         
P00851     PERFORM 3000-CALL-CPD00010       THRU 3000-EXIT.             
P00851*                                                                         
P00851     MOVE ZEROES                  TO AC-AMT-AR-DAY-00             
P00851                                     AC-AMT-AR-DAY-30             
P00851                                     AC-AMT-AR-DAY-60             
P00851                                     AC-AMT-AR-DAY-90             
P00851                                     AC-AMT-UNUSED-CR             
P00851                                     AC-AMT-TRAN-BALANCE          
P00851                                     AC-TOT-SUMM-UNBILLED.        
P00851     MOVE AT-ACCOUNT-NO           TO AC-ACCOUNT-NO                
P00851                                     CT-ACCOUNT-NO.               
P00851     MOVE WS-VALUE-100            TO AC-PYMT-PRIORITY-LVL         
P00851                                     CT-PYMT-PRIORITY-LVL.        
P00851     MOVE WS-FROM-ITEM-ID         TO AC-ITEM-ID                   
P00851                                     CT-CNT-ITEM-ID.              
P00851     PERFORM 6707-UPDATE-AR-DETAIL    THRU 6707-EXIT.             
P00851*    DELETE AR _CNTL DTLS/SUMMARY                                         
P00851     PERFORM 6793-CHECK-AR-CNTRL-FOR-DLET THRU 6793-EXIT.         
P00851*    CLOSE CONTRACT                                                       
ACT150     MOVE WS-VALUE-100            TO AC-PYMT-PRIORITY-LVL         
ACT150                                     CT-PYMT-PRIORITY-LVL.        
P00851     PERFORM 6738B-GET-CONTRACT-INFO  THRU 6738B-EXIT.            
P00851     PERFORM 2800-FORMAT-MNT-HST      THRU 2800-EXIT.             
P00851     MOVE WS-FROM-ITEM-ID         TO AC-ITEM-ID.                  
P00851     MOVE WS-PAR-E                TO CT-CNT-STATUS-CD.            
P00851     PERFORM 6797C-UPDATE-CNT         THRU 6797C-EXIT.            
P00851     PERFORM 6540A-INSERT-MNT-TRANS-HIST  THRU 6540A-EXIT.        
P00851     PERFORM 6550A-INSERT-MT-TRN-HST-DET  THRU 6550A-EXIT.        
P00851     MOVE WS-CURRENT-TIMESTAMP    TO AT-LAST-UPDATE-TS.           
P00851     MOVE WS-CODES-DATA-PRESENT   TO AT-CODES-DATA-PRESENT.       
P00851     PERFORM 6705-UPDATE-ACCOUNT      THRU 6705-EXIT.             
P00851*                                                                         
P00851     DISPLAY 'ACCOUNT NUMBER PROCESSED : ' AT-ACCOUNT-NO.         
P00851*                                                                         
P00851 2300-EXIT.                                                       
P00851     EXIT.                                                        
P00851*                                                                         
       2500-LOAD-PYMT-PRTY-TABLE.                                       
           PERFORM 6721-INITIALIZE-PYMT-TBL THRU 6721-EXIT              
              VARYING WS-PAR-SUB FROM 1 BY 1                            
              UNTIL WS-PAR-SUB GREATER THAN 52.                         
           PERFORM 6722A-LOAD-PYMT-TABLE THRU 6722A-EXIT.               
       2500-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      * LOAD GL NUMBERS IN PROGRAM W-S TO CWS00017 VARIABLES.        *          
      ****************************************************************          
       2700-LOAD-GL-NBRS.                                               
           MOVE AT-COMPANY-NO   TO WS-SK-COMPANY-NO.                    
           MOVE AT-LOCAL-OFFICE TO WS-SK-LOCAL-OFFICE.                  
                                                                        
           MOVE WS-GL-CASH-KEY  TO WS-SK-ACCT-NAME.                     
           PERFORM 2710-GL-SEARCH-ROUTINE  THRU 2710-EXIT.              
           IF GL-NO-FOUND                                               
ACT215         MOVE WS-GL-ACCOUNT-NO (GL-IND)                           
                     TO WS-GEN-LED-NO-CASH                              
           ELSE                                                         
               MOVE ZEROES TO WS-GEN-LED-NO-CASH
           END-IF.                       
                                                                        
           MOVE WS-GL-LPC-KEY TO WS-SK-ACCT-NAME.                       
           PERFORM 2710-GL-SEARCH-ROUTINE  THRU 2710-EXIT.              
           IF GL-NO-FOUND                                               
ACT215         MOVE WS-GL-ACCOUNT-NO (GL-IND)                           
                     TO WS-GEN-LED-NO-LPC                               
           ELSE                                                         
               MOVE ZEROES TO WS-GEN-LED-NO-LPC
           END-IF.                        
                                                                        
           MOVE WS-GL-ELC-KEY TO WS-SK-ACCT-NAME.                       
           PERFORM 2710-GL-SEARCH-ROUTINE  THRU 2710-EXIT.              
           IF GL-NO-FOUND                                               
ACT215         MOVE WS-GL-ACCOUNT-NO (GL-IND)                           
                     TO WS-GEN-LED-NO-UTE                               
           ELSE                                                         
               MOVE ZEROES TO WS-GEN-LED-NO-UTE
           END-IF.                        
                                                                        
           MOVE WS-GL-GAS-KEY TO WS-SK-ACCT-NAME.                       
           PERFORM 2710-GL-SEARCH-ROUTINE  THRU 2710-EXIT.              
           IF GL-NO-FOUND                                               
ACT215         MOVE WS-GL-ACCOUNT-NO (GL-IND)                           
                     TO WS-GEN-LED-NO-UTG                               
           ELSE                                                         
               MOVE ZEROES TO WS-GEN-LED-NO-UTG
           END-IF.                        
                                                                        
           MOVE WS-GL-EPP-KEY TO WS-SK-ACCT-NAME.                       
           PERFORM 2710-GL-SEARCH-ROUTINE  THRU 2710-EXIT.              
           IF GL-NO-FOUND                                               
ACT215         MOVE WS-GL-ACCOUNT-NO (GL-IND)                           
                     TO WS-GEN-LED-NO-EPP                               
           ELSE                                                         
               MOVE ZEROES TO WS-GEN-LED-NO-EPP
           END-IF.                        
                                                                        
           MOVE WS-GL-CCC-KEY TO WS-SK-ACCT-NAME.                       
           PERFORM 2710-GL-SEARCH-ROUTINE  THRU 2710-EXIT.              
           IF GL-NO-FOUND                                               
ACT215         MOVE WS-GL-ACCOUNT-NO (GL-IND)                           
                     TO WS-GEN-LED-NO-CCC                               
           ELSE                                                         
               MOVE ZEROES TO WS-GEN-LED-NO-CCC
           END-IF.                        
                                                                        
           MOVE WS-GL-DFA-KEY TO WS-SK-ACCT-NAME.                       
           PERFORM 2710-GL-SEARCH-ROUTINE  THRU 2710-EXIT.              
           IF GL-NO-FOUND                                               
ACT215         MOVE WS-GL-ACCOUNT-NO (GL-IND)                           
                     TO WS-GEN-LED-NO-DFA                               
           ELSE                                                         
               MOVE ZEROES TO WS-GEN-LED-NO-DFA
           END-IF.                        
                                                                        
           MOVE WS-GL-DEP-KEY TO WS-SK-ACCT-NAME.                       
           PERFORM 2710-GL-SEARCH-ROUTINE  THRU 2710-EXIT.              
           IF GL-NO-FOUND                                               
ACT215         MOVE WS-GL-ACCOUNT-NO (GL-IND)                           
                     TO WS-GEN-LED-NO-DEP                               
           ELSE                                                         
               MOVE ZEROES TO WS-GEN-LED-NO-DEP
           END-IF.                        
                                                                        
           MOVE WS-GL-CNT-KEY TO WS-SK-ACCT-NAME.                       
           PERFORM 2710-GL-SEARCH-ROUTINE  THRU 2710-EXIT.              
           IF GL-NO-FOUND                                               
ACT215         MOVE WS-GL-ACCOUNT-NO (GL-IND)                           
                     TO WS-GEN-LED-NO-CNT                               
           ELSE                                                         
               MOVE ZEROES TO WS-GEN-LED-NO-CNT
           END-IF.                        
                                                                        
           MOVE WS-GL-NSA-KEY TO WS-SK-ACCT-NAME.                       
           PERFORM 2710-GL-SEARCH-ROUTINE  THRU 2710-EXIT.              
           IF GL-NO-FOUND                                               
ACT215         MOVE WS-GL-ACCOUNT-NO (GL-IND)                           
                     TO WS-GEN-LED-NO-NSA                               
           ELSE                                                         
               MOVE ZEROES TO WS-GEN-LED-NO-NSA
           END-IF.                        
                                                                        
           MOVE WS-GL-NSC-KEY TO WS-SK-ACCT-NAME.                       
           PERFORM 2710-GL-SEARCH-ROUTINE  THRU 2710-EXIT.              
           IF GL-NO-FOUND                                               
ACT215         MOVE WS-GL-ACCOUNT-NO (GL-IND)                           
                     TO WS-GEN-LED-NO-NSC                               
           ELSE                                                         
               MOVE ZEROES TO WS-GEN-LED-NO-NSC
           END-IF.                        
                                                                        
           MOVE WS-GL-PJS-KEY TO WS-SK-ACCT-NAME.                       
           PERFORM 2710-GL-SEARCH-ROUTINE  THRU 2710-EXIT.              
           IF GL-NO-FOUND                                               
ACT215         MOVE WS-GL-ACCOUNT-NO (GL-IND)                           
                     TO WS-GEN-LED-NO-PJS                               
           ELSE                                                         
               MOVE ZEROES TO WS-GEN-LED-NO-PJS
           END-IF.                        
P00851     MOVE WS-Y          TO WS-GL-NOS-LOADED-SW.                   
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
      ******************************************************************        
      *    SEARCH ROUTINE OF THE GL TABLE                              *        
      ******************************************************************        
       2710-GL-SEARCH-ROUTINE.                                          
                                                                        
ACT215     MOVE WS-N TO WS-GL-FOUND.                                    
ACT215     SEARCH ALL WS-GL-TABLE-VALUES                                
ACT215     WHEN                                                         
ACT215        WS-GL-KEY (GL-IND) EQUAL WS-SEARCH-KEY                    
ACT215         MOVE WS-Y TO WS-GL-FOUND                                 
ACT215     END-SEARCH.                                                  
                                                                        
       2710-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
P00851*                                                                         
P00851******************************************************************        
P00851* FORMAT MNT HIST/DETAIL                                         *        
P00851******************************************************************        
P00851*                                                                         
P00851 2800-FORMAT-MNT-HST.                                             
P00851*                                                                         
P00851     MOVE WS-PCSCA165C          TO MH-APPL-PROGRAM-ID.            
P00851     MOVE +19                   TO MH-TRAN-COMMENT-LEN.           
P00851     MOVE 'ITEM ID# '           TO MH-TRAN-COMMENT-TEXT(1:9).     
P00851     MOVE CT-CNT-ITEM-ID        TO MH-TRAN-COMMENT-TEXT(10:18).   
P00851     MOVE WS-F                  TO MH-CODE-TRAN-TYPE.             
P00851     MOVE SPACES                TO MH-RESP-AREA-ID.               
P00851     MOVE AT-ACCOUNT-NO         TO MH-ACCOUNT-NO.                 
P00851     MOVE 0                     TO MH-CUSTOMER-NO.                
P00851     MOVE 0                     TO MH-PREMISE-NO.                 
P00851     MOVE 'SYSTEM'              TO MH-USER-ID.                    
P00851     MOVE WS-CURRENT-DATE       TO MH-DATE-TRANS.                 
P00851     MOVE WS-CURRENT-TIMESTAMP  TO MH-TRANS-HIST-SEQ-NO           
P00851                                   MI-TRANS-HIST-SEQ-NO.          
P00851* DTLS                                                                    
P00851     MOVE 'STATUS CODE'         TO MI-COLUMN-DESC.                
P00851     MOVE +1                    TO MI-PRV-COLUMN-VALUE-LEN.       
P00851     MOVE WS-PAR-A              TO MI-PRV-COLUMN-VALUE-TEXT.      
P00851     MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN.       
P00851     MOVE WS-PAR-E              TO MI-CHG-COLUMN-VALUE-TEXT.      
P00851     MOVE '15'                  TO MI-TABLE-ID.                   
P00851     MOVE +1                    TO MI-TRAN-APPL-NO.               
P00851*                                                                         
P00851 2800-EXIT.                                                       
P00851     EXIT.                                                        
P00851*                                                                         
      ******************************************************************        
      *    SEARCH GL TABLE                                             *        
      ******************************************************************        
       3000-CALL-CPD00010.                                              
                                                                        
      ***  POST RECORDS USING PAR ROUTINE                                       
                                                                        
                                                                        
           MOVE AT-ACCOUNT-NO         TO WS-100-ACCT-NO.                
           MOVE AT-COMPANY-NO         TO WS-100-COMPANY-NO.             
           MOVE AT-PREMISE-NO         TO WS-100-PREMISE-NO.             
           MOVE AT-LOCAL-OFFICE       TO WS-100-LOCAL-OFFICE-CD.        
           MOVE AT-CUSTOMER-NO        TO WS-100-CUSTOMER-NO.            
                                                                        
           MOVE AT-ACCOUNT-NO         TO AC-ACCOUNT-NO.                 
           MOVE AT-LOCAL-OFFICE       TO WS-PAR-ACCESS-LOC.             
TP6057     MOVE 'SYSTEM'              TO WS-PAR-OPERATOR-ID.            
           MOVE SPACES                TO WS-PAR-PYMT-FACILITY-CD.       
TP6057     MOVE SPACES                TO PF-RESP-AREA-ID.               
                                                                        
           MOVE SPACES                TO WS-HOLD-CURRENCY-TYPE.         
           MOVE SPACES                TO WS-JRNL-OL-PERM-ID.            
P00851     MOVE ZEROS                 TO WS-PAR-TRAN-APPL-NO            
T18233                                   WS-PAR-TRAN-APPL-NO-WO1        
                                         WS-100-JRNL-TRAN-APPL-NO       
                                         AU-TRAN-APPL-NO.               
           MOVE AT-COMPANY-NO         TO WS-PAR-COMPANY-NO.             
           MOVE AT-LOCAL-OFFICE       TO WS-PAR-LOCAL-OFFICE.           
?????      MOVE WS-CASH-REPORT-NO     TO WS-PAR-REPORT-NO.              
           MOVE WS-CURRENT-DATE       TO WS-PAR-REPORT-DATE.            
?????      MOVE WS-CASH-DRAWER-ID     TO WS-PAR-CASH-DRAWER.            
           MOVE WS-B                  TO WS-PAR-CODE-SOURCE.            
      ** APPLYING CREDIT SHOULD BE AN ADJUSTMENT TRANSACTION.                   
      ** PCR 404 HAS CHANGED IT TO TYPE CRT                                     
PCR404     MOVE WS-I                  TO WS-PAR-CODE-TRAN-TYPE.         
           MOVE WS-A165               TO WS-100-CODE-TERMINAL-TRAN      
                                         WS-PAR-EIBTRNID.               
           MOVE ZEROES                TO AR-AMT-ORIG-ENTERED.           
P00851*                                                                         
P00851     EVALUATE TRUE                                                
P00851*       APPLYING CREDIT AS UNDIRECTED.                                    
P00851        WHEN WS-IS-CIA-PROCES                                     
                   MOVE PROGRAM-NAME  TO WS-PAR-APPL-PROG-ID            
                   MOVE WS-PAR-YES    TO WS-PAR-APPLYING-CREDIT-SW      
                   MOVE WS-AR-CIA-GL-NO(WS-GL-SUB)                      
                                      TO WS-PAR-GEN-LEDG-DB             
                   MOVE ZEROS         TO WS-PAR-TYPE                    
                                         WS-PAR-TYPE-NO                 
A05136             MOVE WS-PAR-NO     TO WS-IS-THIS-DIRECTED-PYMT       
A05136             MOVE SPACES        TO WS-DIRECTED-PYMT-HOLD-SW       
P00851        WHEN OTHER                                                
P00851*       DISTRUBUTE ADV. COLL CNT AS DIRECTED                              
P00851             MOVE WS-PCSCA165C  TO WS-PAR-APPL-PROG-ID            
P00851             MOVE WS-PAR-YES    TO WS-IS-THIS-DIRECTED-PYMT       
P00851             MOVE WS-PAR-N      TO WS-PAR-APPLYING-CREDIT-SW      
P00851             MOVE WS-AR-CNT-GL-NO(WS-GL-SUB)                      
P00851                                TO WS-PAR-GEN-LEDG-DB             
P00851             MOVE WS-VALUE-100  TO WS-PAR-TYPE                    
P00851             MOVE AC-ITEM-ID    TO WS-PAR-TYPE-NO                 
P00851             MOVE WS-PAR-P      TO WS-PAR-PAY-AHEAD               
P00851             MOVE WS-PAR-N      TO WS-PAR-PAY-CHRG-OFF            
P00851     END-EVALUATE.                                                
P00851*                                                                         
           PERFORM 6700-APPLY-PAYMENT THRU 6700-EXIT.                   
                                                                        
           IF PYMT-WAS-SUCCESSFUL                                       
               IF AR-AMT-ORIG-ENTERED > 0                               
                  PERFORM 8100-UPDATE-AMT-ORIG-ENT THRU 8100-EXIT       
               END-IF                                                   
           ELSE                                                         
               PERFORM 9900-SQL-ERROR-ROUTINE                           
           END-IF.                                                      
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
T15301                                                                  
T15301 3300-GENERATE-WORK-QUEUE.                                        
A04860     MOVE ZERO                  TO WS-77-SERV-ORDER-NO            
A04860     MOVE WS-CURRENT-DATE       TO WS-77-DATE-REQUIRED            
A04860     MOVE AC-ACCOUNT-NO         TO WS-77-ACCOUNT-NO               
A04860     MOVE AT-PREMISE-NO         TO WS-77-PREMISE-NO               
A04860     MOVE AT-CUSTOMER-NO        TO WS-77-CUSTOMER-NO              
A04860     MOVE AT-LOCAL-OFFICE       TO WS-77-LOCAL-OFFICE             
A04860     MOVE SPACES                TO WS-77-RESP-AREA-ID             
A04860     MOVE ZERO                  TO WS-77-FREE-FORM-LEN            
A04860     MOVE LOW-VALUES            TO WS-77-FREE-FORM-TXT            
A04860     MOVE PROGRAM-NAME          TO WS-77-CREATED-BY               
T15301                                                                  
A04860     PERFORM 8895-INSERT-WORK-QUEUE     THRU 8895-EXIT.           
T15301                                                                  
T15301 3300-EXIT.                                                       
T15301     EXIT.                                                        
HPCCDM*EJECT                                                                    
T18024*****************************************************************         
T18024** 6251-GET-FJC01-DATE                                         **         
T18024*****************************************************************         
T18024*                                                                         
T18024     EXEC SQL                                                             
T18024         INCLUDE CPD00037                                                 
T18024     END-EXEC.                                                            
T18024*                                                                         
T18024     EXEC SQL                                                             
T18024         INCLUDE CPD00040                                                 
T18024     END-EXEC.                                                            
T18024*                                                                         
T18024*****************************************************************         
T18024** 7600-START-FCJ01                                            **         
T18024*****************************************************************         
T18024*                                                                         
T18024     EXEC SQL                                                             
T18024         INCLUDE CPD00038                                                 
T18024     END-EXEC.                                                            
T18024*                                                                         
T18024     EXEC SQL                                                             
T18024         INCLUDE CPD00039                                                 
T18024     END-EXEC.                                                            
T18024*                                                                         
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
      ** 5000 SERIES PARAGRAPHS ARE "COMMON" OR "UTILITY" PARAGRAPHS  **        
      **                                                              **        
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
                                                                        
      *************************************************************             
      * COMPUTE THE AMOUNT TO BE REBATED WHEN PAYING OFF AN ADD ON*             
      * INTEREST RECEIVABLE. 6100-COMPUTE REBATE-AMOUNT.          *             
      *************************************************************             
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD0003B                                                 
           END-EXEC.                                                            
                                                                        
       6400-ONLINE-JRNL-ROUTINE.                                        
                                                                        
           GO TO 6400-BATCH-JRNL-ROUTINE.                               
                                                                        
HPCCDM*EJECT                                                                    
      *************************************************************             
      * BATCH JOURNAL ROUTINE. 6400-BATCH-JRNL-ROUTINE.           *             
      *************************************************************             
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00007                                                 
           END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
      *************************************************************             
      * 6500-ONLINE-LOAD-AR-TRAN-HIST. ROUITNE TO LOAD THE AR     *             
      * TRANSACTION HEADER AND DETAIL DATABASE ROWS.              *             
      *************************************************************             
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00008                                                 
           END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
      *************************************************************             
      * PAYMENT APPLICATION ROUTINE 6700-APPLY-PAYMENT.           *             
      *************************************************************             
                                                                        
       COPY CPD00010.                                                           
                                                                        
HPCCDM*EJECT                                                                    
      *************************************************************             
      * THE SQL STATEMENTS NEEDED FOR THE PAYMENT APPLICATION     *             
      * ROUTINE ORIGINALLY IN CPD00010. 6701- ,...                *             
      *************************************************************             
           EXEC SQL                                                             
              INCLUDE CPD0010S                                                  
           END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
      *************************************************************             
      * POST PAYMENT TO CHARGED OFF RECORD 6800-APPLY-PYMNT-CO.   *             
      *************************************************************             
      *        INCLUDE CPD00073 - USED FOR CICS PROGS                           
      *        INCLUDE CPD0073B - USED FOR BATCH(CWS10000) PROGS                
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00073                                                 
           END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
      *************************************************************             
      * RETRIEVE GL ACCOUNT NUMBERS 7910-SELECT-GL-NO.            *             
      *************************************************************             
                                                                        
NONUTL     EXEC SQL                                                             
NONUTL        INCLUDE CPD00312                                                  
NONUTL     END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
      /*** ALL SQL SELECTS, OPENS, FETCHES, AND CLOSES GO IN THE                
      **** 7000- RANGE OF PARAGRAPHS                                            
       7000-OPEN-AR-CNTL.                                               
                                                                        
           EXEC SQL                                                     
                OPEN AR_CNTL_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 7000                  TO ACTIVE-PARAGRAPH           
               MOVE 'OPEN'                TO ABEND-FUNCTION             
               MOVE 'CSS_AR_CNTL'         TO TABLE-1                    
               MOVE 'RETURN CODE IS'      TO WS-ERROR-MSG-1             
               MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1          
               MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2-N        
               MOVE AC-ITEM-ID            TO HOSTVAR-ELEMENT-3-N        
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-FETCH-AR-CNTL.                                              
                                                                        
           EXEC SQL                                                     
               FETCH AR_CNTL_CURSOR                                     
               INTO :AC-ACCOUNT-NO,                                     
                    :AC-ITEM-ID,                                        
                    :AC-AMT-UNUSED-CR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 7010                  TO ACTIVE-PARAGRAPH           
               MOVE 'FETCH'               TO ABEND-FUNCTION             
               MOVE 'CSS_AR_CNTL'         TO TABLE-1                    
               MOVE 'RETURN CODE IS'      TO WS-ERROR-MSG-1             
               MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1          
               MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2-N        
               MOVE AC-ITEM-ID            TO HOSTVAR-ELEMENT-3-N        
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-CLOSE-AR-CNTL.                                              
                                                                        
           EXEC SQL                                                     
               CLOSE AR_CNTL_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 7020                  TO ACTIVE-PARAGRAPH           
               MOVE 'CLOSE'               TO ABEND-FUNCTION             
               MOVE 'CSS_AR_CNTL'         TO TABLE-1                    
               MOVE 'RETURN CODE IS'      TO WS-ERROR-MSG-1             
               MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1          
               MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2-N        
               MOVE AC-ITEM-ID            TO HOSTVAR-ELEMENT-3-N        
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
P00851*                                                                         
P00851******************************************************************        
P00851*  OPEN ADVANCE COLLECTION CONTRACT CURSOR                       *        
P00851******************************************************************        
P00851*                                                                         
P00851 7030-OPEN-ADV-CNT-CUR.                                           
P00851*                                                                         
P00851     EXEC SQL                                                     
P00851          OPEN ADV_CNT_CUR                                        
P00851     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00851*                                                                         
P00851     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
P00851*                                                                         
P00851     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00851        CONTINUE                                                  
P00851     ELSE                                                         
P00851         MOVE 7030                  TO ACTIVE-PARAGRAPH           
P00851         MOVE 'OPEN'                TO ABEND-FUNCTION             
P00851         MOVE 'ADV_CNT_CUR'         TO TABLE-1                    
P00851         MOVE 'RETURN CODE IS'      TO WS-ERROR-MSG-1             
P00851         MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1          
P00851         PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
P00851     END-IF.                                                      
P00851*                                                                         
P00851 7030-EXIT.                                                       
P00851     EXIT.                                                        
P00851*                                                                         
P00851******************************************************************        
P00851* FETCH ADVANCE COLLECTION CONTRACT CURSOR                       *        
P00851******************************************************************        
P00851*                                                                         
P00851 7031-FETCH-ADV-CNT-CUR.                                          
P00851*                                                                         
P00851     EXEC SQL                                                     
P00851         FETCH ADV_CNT_CUR                                        
P00851         INTO  :AC-ACCOUNT-NO                                     
P00851              ,:AC-ITEM-ID                                        
P00851              ,:AC-AMT-TRAN-BALANCE                               
P00851     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00851*                                                                         
P00851     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
P00851*                                                                         
P00851     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00851        CONTINUE                                                  
P00851     ELSE                                                         
P00851         MOVE 7031                  TO ACTIVE-PARAGRAPH           
P00851         MOVE 'FETCH'               TO ABEND-FUNCTION             
P00851         MOVE 'ADV_CNT_CUR'         TO TABLE-1                    
P00851         MOVE 'RETURN CODE IS'      TO WS-ERROR-MSG-1             
P00851         MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1          
P00851         MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2-N        
P00851         MOVE AC-ITEM-ID            TO HOSTVAR-ELEMENT-3-N        
P00851         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
P00851     END-IF.                                                      
P00851*                                                                         
P00851 7031-EXIT.                                                       
P00851     EXIT.                                                        
P00851*                                                                         
P00851******************************************************************        
P00851* CLOSE ADVANCE COLLECTION CONTRACT CURSOR                       *        
P00851******************************************************************        
P00851*                                                                         
P00851 7032-CLOSE-ADV-CNT-CUR.                                          
P00851*                                                                         
P00851     EXEC SQL                                                     
P00851         CLOSE ADV_CNT_CUR                                        
P00851     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00851*                                                                         
P00851     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
P00851*                                                                         
P00851     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00851        CONTINUE                                                  
P00851     ELSE                                                         
P00851         MOVE 7032                  TO ACTIVE-PARAGRAPH           
P00851         MOVE 'CLOSE'               TO ABEND-FUNCTION             
P00851         MOVE 'ADV_CNT_CUR'         TO TABLE-1                    
P00851         MOVE 'RETURN CODE IS'      TO WS-ERROR-MSG-1             
P00851         MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1          
P00851         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
P00851     END-IF.                                                      
P00851*                                                                         
P00851 7032-EXIT.                                                       
P00851     EXIT.                                                        
P00851*                                                                         
P00851******************************************************************        
P00851* OPEN INSTALLMENT-CNT-CUR.                                      *        
P00851******************************************************************        
P00851*                                                                         
P00851 7050-OPEN-INSTALLMENT-CNT-CUR.                                   
P00851*                                                                         
P00851     EXEC SQL                                                     
P00851         OPEN INSTALLMENT_CNT_CUR                                 
P00851     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00851*                                                                         
P00851     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P00851*                                                                         
P00851     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00851        CONTINUE                                                  
P00851     ELSE                                                         
P00851       MOVE PROGRAM-NAME              TO ABEND-PROGRAM            
P00851       MOVE '7050'                    TO ACTIVE-PARAGRAPH         
P00851       MOVE 'OPEN'                    TO ABEND-FUNCTION           
P00851       MOVE SPACES                    TO ABEND-SQL-PREDICATES     
P00851                                         ABEND-TABLES             
P00851       MOVE 'INSTALLMENT_CNT_CUR'     TO TABLE-1                  
P00851       MOVE AC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1        
P00851       PERFORM 9900-SQL-ERROR-ROUTINE          THRU 9900-EXIT     
P00851     END-IF.                                                      
P00851*                                                                         
P00851 7050-EXIT.                                                       
P00851     EXIT.                                                        
P00851*                                                                         
P00851******************************************************************        
P00851*FETCH INSTALLMENT-CNT-CUR.                                      *        
P00851******************************************************************        
P00851*                                                                         
P00851 7051-FETCH-INSTALLMENT-CNT-CUR.                                  
P00851*                                                                         
P00851     EXEC SQL                                                     
P00851         FETCH INSTALLMENT_CNT_CUR                                
P00851         INTO   :AC-ITEM-ID                                       
P00851               ,:AC-AMT-TRAN-BALANCE                              
ACT018               ,:CT-AMT-DOWN-PYMT                                 
P00851     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00851*                                                                         
P00851     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P00851*                                                                         
P00851     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00851        CONTINUE                                                  
P00851     ELSE                                                         
P00851       MOVE PROGRAM-NAME              TO ABEND-PROGRAM            
P00851       MOVE '7051'                    TO ACTIVE-PARAGRAPH         
P00851       MOVE 'FETCH'                   TO ABEND-FUNCTION           
P00851       MOVE SPACES                    TO ABEND-SQL-PREDICATES     
P00851                                         ABEND-TABLES             
P00851       MOVE 'INSTALLMENT_CNT_CUR'     TO TABLE-1                  
P00851       MOVE AC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1        
P00851       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT              
P00851     END-IF.                                                      
P00851*                                                                         
P00851 7051-EXIT.                                                       
P00851     EXIT.                                                        
P00851*                                                                         
P00851******************************************************************        
P00851*CLOSE INSTALLMENT-CNT-CUR.                                      *        
P00851******************************************************************        
P00851*                                                                         
P00851 7052-CLOSE-INSTALLMENT-CNT-CUR.                                  
P00851*                                                                         
P00851     EXEC SQL                                                     
P00851         CLOSE INSTALLMENT_CNT_CUR                                
P00851     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00851*                                                                         
P00851     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P00851*                                                                         
P00851     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00851        CONTINUE                                                  
P00851     ELSE                                                         
P00851       MOVE PROGRAM-NAME              TO ABEND-PROGRAM            
P00851       MOVE '7052'                    TO ACTIVE-PARAGRAPH         
P00851       MOVE 'CLOSE'                   TO ABEND-FUNCTION           
P00851       MOVE SPACES                    TO ABEND-SQL-PREDICATES     
P00851                                         ABEND-TABLES             
P00851       MOVE 'INSTALLMENT_CNT_CUR'     TO TABLE-1                  
P00851       MOVE AC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1        
P00851       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT              
P00851     END-IF.                                                      
P00851*                                                                         
P00851 7052-EXIT.                                                       
P00851     EXIT.                                                        
P00851*                                                                         
P00851******************************************************************        
P00851* 7060-SEL-WQ-ITEMS                                              *        
P00851******************************************************************        
P00851*                                                                         
P00851 7060-SEL-WQ-ITEMS.                                               
P00851*                                                                         
P00851     EXEC SQL                                                     
P00851          SELECT TOP(1) 'Y'                                              
P00851          INTO                                                    
P00851                :WS-WQ-EXISTS-SW                                  
P00851          FROM                                                    
P00851                 CSS_WQ_ITEMS WQ WITH(READUNCOMMITTED)                    
P00851          WHERE                                                   
P00851                 ACCOUNT_NO  = :WQ-ACCOUNT-NO                     
P00851            AND  CATEGORY_ID = :WQ-CATEGORY-ID                    
P00851            AND  STATUS      IN ('A','I')                         
P00851                                                           
P00851                                              
P00851                                                      
P00851     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                'Y'                                                      
MFA-TR*         INTO                                                            
MFA-TR*               :WS-WQ-EXISTS-SW                                          
MFA-TR*         FROM                                                            
MFA-TR*                CSS_WQ_ITEMS WQ                                          
MFA-TR*         WHERE                                                           
MFA-TR*                ACCOUNT_NO  = :WQ-ACCOUNT-NO                             
MFA-TR*           AND  CATEGORY_ID = :WQ-CATEGORY-ID                            
MFA-TR*           AND  STATUS      IN ('A','I')                                 
MFA-TR*      WITH UR                                                            
MFA-TR*     FETCH FIRST ROW ONLY                                                
MFA-TR*   QUERYNO 7060                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00851*                                                                         
P00851     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00851*                                                                         
P00851     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00851         NEXT SENTENCE                                            
P00851     ELSE                                                         
P00851         MOVE 7060                  TO ACTIVE-PARAGRAPH           
P00851         MOVE 'SELECT'              TO ABEND-FUNCTION             
P00851         MOVE 'CSS_WQ_ITEMS'        TO TABLE-1                    
P00851         MOVE 'RETURN CODE IS'      TO WS-ERROR-MSG-1             
P00851         MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1          
P00851         MOVE WQ-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2-N        
P00851         MOVE WQ-CATEGORY-ID        TO HOSTVAR-ELEMENT-3-N        
P00851         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
P00851                                                                  
P00851*                                                                         
P00851 7060-EXIT.                                                       
P00851     EXIT.                                                        
P00851*                                                                         
      ******************************************************************        
      *    SELECT ACCOUNT-NUMBER                                                
      ******************************************************************        
       7100-SELECT-ACCT.                                                
                                                                        
           EXEC SQL                                                     
                SELECT CUSTOMER_NO,                                     
                       LOCAL_OFFICE,                                    
                       TOTAL_AR_BALANCE,                                
                       COMPANY_NO,                                      
                       AR_XFER_IND,                                     
                       ACCT_XFER_TO,                                    
                       CODE_ACCT_STAT,                                  
                       CODES_DATA_PRESENT,                              
                       PREMISE_NO                                       
C30083                ,REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                INTO  :AT-CUSTOMER-NO,                                  
                      :AT-LOCAL-OFFICE,                                 
                      :AT-TOTAL-AR-BALANCE,                             
                      :AT-COMPANY-NO,                                   
                      :AT-AR-XFER-IND,                                  
                      :AT-ACCT-XFER-TO,                                 
                      :AT-CODE-ACCT-STAT,                               
                      :AT-CODES-DATA-PRESENT,                           
                      :AT-PREMISE-NO                                    
C30083               ,:WS-AT-LAST-UPDATE-TS                             
                FROM   CSS_ACCOUNT WITH(READUNCOMMITTED)                        
                WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                      
ACT215                                                           
ACT215                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT CUSTOMER_NO,                                             
MFA-TR*                LOCAL_OFFICE,                                            
MFA-TR*                TOTAL_AR_BALANCE,                                        
MFA-TR*                COMPANY_NO,                                              
MFA-TR*                AR_XFER_IND,                                             
MFA-TR*                ACCT_XFER_TO,                                            
MFA-TR*                CODE_ACCT_STAT,                                          
MFA-TR*                CODES_DATA_PRESENT,                                      
MFA-TR*                PREMISE_NO                                               
MFA-TR*               ,LAST_UPDATE_TS                                           
MFA-TR*         INTO  :AT-CUSTOMER-NO,                                          
MFA-TR*               :AT-LOCAL-OFFICE,                                         
MFA-TR*               :AT-TOTAL-AR-BALANCE,                                     
MFA-TR*               :AT-COMPANY-NO,                                           
MFA-TR*               :AT-AR-XFER-IND,                                          
MFA-TR*               :AT-ACCT-XFER-TO,                                         
MFA-TR*               :AT-CODE-ACCT-STAT,                                       
MFA-TR*               :AT-CODES-DATA-PRESENT,                                   
MFA-TR*               :AT-PREMISE-NO                                            
MFA-TR*              ,:WS-AT-LAST-UPDATE-TS                                     
MFA-TR*         FROM   CSS_ACCOUNT                                              
MFA-TR*         WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                              
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 7100                  TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_ACCOUNT'         TO TABLE-1                    
               MOVE 'RETURN CODE IS'      TO WS-ERROR-MSG-1             
               MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1          
               MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2-N        
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
      *                                                                         
      ******************************************************************        
      * SUM ALL AR_CNTL BILLED FIELDS FOR A CERTAIN ACCOUNT.                    
      ******************************************************************        
       7200-SELECT-ALL-OWED.                                            
                                                                        
           EXEC SQL                                                     
               SELECT SUM(AMT_AR_DAY_00 +                               
                          AMT_AR_DAY_30 +                               
                          AMT_AR_DAY_60 +                               
                          AMT_AR_DAY_90)                                
                 INTO :WS-AMT-ACCT-OWED :WS-PAR-NULL-IND                
                 FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                
                  AND ITEM_ID           = 0                             
ACT215                                                           
ACT215                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_AR_DAY_00 +                                       
MFA-TR*                   AMT_AR_DAY_30 +                                       
MFA-TR*                   AMT_AR_DAY_60 +                                       
MFA-TR*                   AMT_AR_DAY_90)                                        
MFA-TR*          INTO :WS-AMT-ACCT-OWED :WS-PAR-NULL-IND                        
MFA-TR*          FROM CSS_AR_CNTL                                               
MFA-TR*         WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                        
MFA-TR*           AND ITEM_ID           = 0                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C30083       IF  WS-PAR-NULL-IND < ZEROES                               
C30083           MOVE ZEROES                TO WS-PAR-NULL-IND          
C30083                                         WS-AMT-ACCT-OWED         
C30083       END-IF                                                     
           ELSE                                                         
             MOVE PROGRAM-NAME              TO ABEND-PROGRAM            
             MOVE '7200'                    TO ACTIVE-PARAGRAPH         
             MOVE 'SELECT'                  TO ABEND-FUNCTION           
             MOVE SPACES                    TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
             MOVE 'CSS_AR_CNTL'             TO TABLE-1                  
             MOVE AC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1        
             MOVE AC-PYMT-PRIORITY-LVL      TO HOSTVAR-ELEMENT-2        
             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.             
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
T17819 7200A-SELECT-CHRG-OFF.                                           
                                                                        
           EXEC SQL                                                     
               SELECT SUM (AMT_TRANS)                                   
                 INTO :WS-CHRG-OFF-AMT :WS-PAR-NULL-IND                 
                 FROM CSS_CHRG_OFF WITH(READUNCOMMITTED)                        
                WHERE ACCOUNT_NO = :CO-ACCOUNT-NO                       
ACT215                                                           
ACT215                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM (AMT_TRANS)                                           
MFA-TR*          INTO :WS-CHRG-OFF-AMT :WS-PAR-NULL-IND                         
MFA-TR*          FROM CSS_CHRG_OFF                                              
MFA-TR*         WHERE ACCOUNT_NO = :CO-ACCOUNT-NO                               
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7201                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
             NEXT SENTENCE                                              
           ELSE                                                         
             MOVE PROGRAM-NAME              TO ABEND-PROGRAM            
             MOVE '7200A'                   TO ACTIVE-PARAGRAPH         
             MOVE 'SELECT'                  TO ABEND-FUNCTION           
             MOVE SPACES                    TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
             MOVE 'CSS_CHRG_OFF'            TO TABLE-1                  
             MOVE 'ACCOUNT NO'              TO TABLE-ELEMENT-1          
             MOVE AC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1        
             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.             
                                                                        
T17819 7200A-EXIT.                                                      
           EXIT.                                                        
C30083*                                                                         
C30083******************************************************************        
C30083* SUM ALL AR_CNTL BILLED FIELDS FOR A CERTAIN ACCOUNT.                    
C30083******************************************************************        
C30083 7210-CHECK-CHARGED-DEP.                                          
C30083                                                                  
C30083     EXEC SQL                                                     
C30083         SELECT SUM(AMT_TRAN_BALANCE)                             
C30083           INTO :WS-AMT-TRAN-BALANCE :WS-NULL-IND1                 
C30083           FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                         
C30083          WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                
C30083            AND PYMT_PRIORITY_LVL = +80                           
C30083            AND ITEM_ID           > 0                             
ACT215                                                           
ACT215                                                      
C30083     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_TRAN_BALANCE)                                     
MFA-TR*          INTO :WS-AMT-TRAN-BALANCE:WS-NULL-IND1                         
MFA-TR*          FROM CSS_AR_CNTL                                               
MFA-TR*         WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                        
MFA-TR*           AND PYMT_PRIORITY_LVL = +80                                   
MFA-TR*           AND ITEM_ID           > 0                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7210                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30083                                                                  
C30083     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C30083     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
C30083         IF  WS-NULL-IND1 < 0                                     
C30083             MOVE ZEROES              TO WS-NULL-IND1             
C30083                                         WS-AMT-TRAN-BALANCE      
C30083         END-IF                                                   
C30083     ELSE                                                         
C30083         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
C30083         MOVE '7210'                  TO ACTIVE-PARAGRAPH         
C30083         MOVE 'SELECT'                TO ABEND-FUNCTION           
C30083         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
C30083                                           ABEND-TABLES           
C30083         MOVE 'CSS_AR_CNTL'           TO TABLE-1                  
C30083         MOVE AC-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
C30083         MOVE +80                     TO HOSTVAR-ELEMENT-2        
C30083         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
C30083     END-IF.                                                      
C30083                                                                  
C30083 7210-EXIT.                                                       
C30083     EXIT.                                                        
C30083                                                                  
C30083 7220-OPEN-DEP-CURSOR.                                            
C30083                                                                  
C30083     EXEC SQL                                                     
C30083          OPEN DEP-AR-CNTL                                        
C30083     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30083                                                                  
C30083     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C30083                                                                  
C30083     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C30083         NEXT SENTENCE                                            
C30083     ELSE                                                         
C30083         MOVE '7220'                TO ACTIVE-PARAGRAPH           
C30083         MOVE 'OPEN'                TO ABEND-FUNCTION             
C30083         MOVE 'CSS_AR_CNTL'         TO TABLE-1                    
C30083         MOVE 'RETURN CODE IS'      TO WS-ERROR-MSG-1             
C30083         MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1          
C30083         MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2-N        
C30083         MOVE +80                   TO HOSTVAR-ELEMENT-3-N        
C30083         MOVE WS-ITEM-ID            TO HOSTVAR-ELEMENT-4-N        
C30083         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
C30083                                                                  
C30083 7220-EXIT.                                                       
C30083     EXIT.                                                        
C30083                                                                  
C30083 7230-FETCH-DEP-CURSOR.                                           
C30083                                                                  
C30083     EXEC SQL                                                     
C30083         FETCH DEP-AR-CNTL                                        
C30083         INTO :WS-AMT-TRAN-BALANCE                                
C30083             ,:WS-ITEM-ID                                         
C30083             ,:WS-AC-LAST-UPDATE-TS                               
C30083     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30083                                                                  
C30083     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C30083                                                                  
C30083     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
C30083         IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
C30083             MOVE 'Y'               TO WS-END-OF-DEP              
C30083         END-IF                                                   
C30083     ELSE                                                         
C30083         MOVE '7230'                TO ACTIVE-PARAGRAPH           
C30083         MOVE 'FETCH'               TO ABEND-FUNCTION             
C30083         MOVE 'CSS_AR_CNTL'         TO TABLE-1                    
C30083         MOVE 'RETURN CODE IS'      TO WS-ERROR-MSG-1             
C30083         MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1          
C30083         MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2-N        
C30083         MOVE +80                   TO HOSTVAR-ELEMENT-3-N        
C30083         MOVE WS-ITEM-ID            TO HOSTVAR-ELEMENT-4-N        
C30083         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
C30083                                                                  
C30083 7230-EXIT.                                                       
C30083     EXIT.                                                        
C30083                                                                  
C30083 7240-CLOSE-DEP-CURSOR.                                           
C30083                                                                  
C30083     EXEC SQL                                                     
C30083         CLOSE DEP-AR-CNTL                                        
C30083     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30083                                                                  
C30083     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C30083                                                                  
C30083     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C30083         NEXT SENTENCE                                            
C30083     ELSE                                                         
C30083         MOVE '7240'                TO ACTIVE-PARAGRAPH           
C30083         MOVE 'CLOSE'               TO ABEND-FUNCTION             
C30083         MOVE 'CSS_AR_CNTL'         TO TABLE-1                    
C30083         MOVE 'RETURN CODE IS'      TO WS-ERROR-MSG-1             
C30083         MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1          
C30083         MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2-N        
C30083         MOVE +80                   TO HOSTVAR-ELEMENT-3-N        
C30083         MOVE WS-ITEM-ID            TO HOSTVAR-ELEMENT-4-N        
C30083         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
C30083                                                                  
C30083 7240-EXIT.                                                       
C30083     EXIT.                                                        
C30083                                                                  
      ******************************************************************        
T15301* CHECK IF THERE IS A CIA DEBIT FOR THE ACCOUNT                           
T15301******************************************************************        
T15301 7250-SELECT-CIA-DEBIT.                                           
T15301                                                                  
T15301     EXEC SQL                                                     
T15301         SELECT AMT_AR_DAY_00                                     
T15301           INTO :WS-AMT-AR-DAY-00 :WS-PAR-NULL-IND                
T15301           FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                         
T15301          WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                
T15301            AND ITEM_ID           = 3                             
T15301            AND PYMT_PRIORITY_LVL = :WS-VALUE-70                  
ACT215                                                           
ACT215                                                      
T15301     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AMT_AR_DAY_00                                             
MFA-TR*          INTO :WS-AMT-AR-DAY-00 :WS-PAR-NULL-IND                        
MFA-TR*          FROM CSS_AR_CNTL                                               
MFA-TR*         WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                        
MFA-TR*           AND ITEM_ID           = 3                                     
MFA-TR*           AND PYMT_PRIORITY_LVL = :WS-VALUE-70                          
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7250                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T15301                                                                  
T15301     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T15301     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T15301        IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
T15301            MOVE 0                    TO WS-AMT-AR-DAY-00         
T15301        END-IF                                                    
T15301     ELSE                                                         
T15301       MOVE PROGRAM-NAME              TO ABEND-PROGRAM            
T15301       MOVE '7250'                    TO ACTIVE-PARAGRAPH         
T15301       MOVE 'SELECT'                  TO ABEND-FUNCTION           
T15301       MOVE SPACES                    TO ABEND-SQL-PREDICATES     
T15301                                         ABEND-TABLES             
T15301       MOVE 'CSS_AR_CNTL'             TO TABLE-1                  
T15301       MOVE AC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1        
T15301       MOVE WS-VALUE-70               TO HOSTVAR-ELEMENT-2        
T15301       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.             
T15301                                                                  
T15301 7250-EXIT.                                                       
T15301     EXIT.                                                        
C30083******************************************************************        
C30083* SELECT THE LAST UPDATED TIME STAMP FOR AN ACCOUNT                       
C30083******************************************************************        
C30083 7260-SELECT-AT-TIME-STMP.                                        
C30083                                                                  
C30083     EXEC SQL                                                     
C30083         SELECT REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
C30083           INTO :AT-LAST-UPDATE-TS                                
C30083           FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
C30083          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
ACT215                                                           
ACT215                                                      
C30083     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LAST_UPDATE_TS                                            
MFA-TR*          INTO :AT-LAST-UPDATE-TS                                        
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7260                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30083                                                                  
C30083     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C30083     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C30083        CONTINUE                                                  
C30083     ELSE                                                         
C30083       MOVE PROGRAM-NAME              TO ABEND-PROGRAM            
C30083       MOVE '7260'                    TO ACTIVE-PARAGRAPH         
C30083       MOVE 'SELECT'                  TO ABEND-FUNCTION           
C30083       MOVE SPACES                    TO ABEND-SQL-PREDICATES     
C30083                                         ABEND-TABLES             
C30083                                         HOSTVAR-ELEMENT-2        
C30083       MOVE 'CSS_ACCOUNT'             TO TABLE-1                  
C30083       MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1        
C30083       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.             
C30083                                                                  
C30083 7260-EXIT.                                                       
C30083     EXIT.                                                        
      ******************************************************************        
      * SUM ALL AR_CNTL FOR CIA DETAILS.                                        
      ******************************************************************        
       7300-SUM-CIA-DETAIL.                                             
                                                                        
           EXEC SQL                                                     
T15377         SELECT SUM(AMT_UNUSED_CR), SUM(AMT_AR_DAY_00)            
                 INTO :WS-AMT-TOT-UNUSED-CR :WS-PAR-NULL-IND,            
T15377                :WS-AMT-AR-DAY-00 :WS-PAR-NULL-IND-2              
                 FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                
                  AND PYMT_PRIORITY_LVL = :WS-VALUE-70                  
                  AND ITEM_ID           > 0                             
ACT215                                                           
ACT215                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_UNUSED_CR), SUM(AMT_AR_DAY_00)                    
MFA-TR*          INTO :WS-AMT-TOT-UNUSED-CR:WS-PAR-NULL-IND,                    
MFA-TR*               :WS-AMT-AR-DAY-00 :WS-PAR-NULL-IND-2                      
MFA-TR*          FROM CSS_AR_CNTL                                               
MFA-TR*         WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                        
MFA-TR*           AND PYMT_PRIORITY_LVL = :WS-VALUE-70                          
MFA-TR*           AND ITEM_ID           > 0                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
             NEXT SENTENCE                                              
           ELSE                                                         
             MOVE PROGRAM-NAME              TO ABEND-PROGRAM            
             MOVE '7300'                    TO ACTIVE-PARAGRAPH         
             MOVE 'SELECT'                  TO ABEND-FUNCTION           
             MOVE SPACES                    TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
             MOVE 'CSS_AR_CNTL'             TO TABLE-1                  
             MOVE AC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1        
             MOVE AC-PYMT-PRIORITY-LVL      TO HOSTVAR-ELEMENT-2        
             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.             
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************31740000
      * SELECTS NO OF UPDATES  FROM CSS_JOB_PARM TABLE.                *31740000
      ******************************************************************31740000
      *                                                                 31740000
       7400-SELECT-JOB-PARM-COUNT.                                      
      *                                                                 32011000
           EXEC SQL                                                     
              SELECT PARM_DATA                                          
                INTO :G6-PARM-DATA                                      
                FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
               WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                    
               AND   SEQ_NO       = 20                                  
ACT215                                                           
ACT215                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PARM_DATA                                                  
MFA-TR*         INTO :G6-PARM-DATA                                              
MFA-TR*         FROM CSS_JOB_PARM                                               
MFA-TR*        WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                            
MFA-TR*        AND   SEQ_NO       = 20                                          
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 31880000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA165 ABORT  *************'       
ACT215         DISPLAY '*7400-SELECT-JOB-PARM-COUNT            *'       
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA165  ABORT *************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C30083                                                                  
C30083****************************************************************  05222007
C30083**                                                            **  05223007
C30083** 7410-GET-DATABASE.                                         **  05224007
C30083** DETERMINE WHETHER WE'RE IN SEB OR CSR.                     **  05225007
C30083**                                                            **  05226007
C30083****************************************************************  05227007
C30083*                                                                 05228007
C30083 7410-GET-DATABASE.                                               
C30083*                                                                 05229107
C30083     EXEC SQL                                                     
C30083        SELECT  DELINQ_VALUE                                      
C30083        INTO    :C8-DELINQ-VALUE                                  
C30083        FROM    CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
C30083        WHERE   DELINQ_CD  = :C8-DELINQ-CD                        
C30083        AND     COMPANY_NO = :C8-COMPANY-NO                       
ACT215                                                           
ACT215                                                      
C30083     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05229207
MFA-TR*       SELECT  DELINQ_VALUE                                      05229307
MFA-TR*       INTO    :C8-DELINQ-VALUE                                  05229407
MFA-TR*       FROM    CSS_DELINQUENCY                                   05229507
MFA-TR*       WHERE   DELINQ_CD  = :C8-DELINQ-CD                        05229607
MFA-TR*       AND     COMPANY_NO = :C8-COMPANY-NO                       05229707
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7410                                                       
MFA-TR*    END-EXEC.                                                    05229807

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30083*                                                                 05229907
C30083     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
C30083*                                                                 05230107
C30083     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C30083           NEXT SENTENCE                                          
C30083     ELSE                                                         
C30083         DISPLAY '*************************************'          
C30083         DISPLAY '* 7410-GET-DATABASE'                            
C30083         DISPLAY '* DELINQ_CD  = ' C8-DELINQ-CD                   
C30083         DISPLAY '* COMPANY_NO = ' C8-COMPANY-NO                  
C30083         DISPLAY '* SQL RETURN CODE = ' SQLCODE                   
C30083         DISPLAY '*************************************'          
C30083         PERFORM 9900-ABEND   THRU 9900-EXIT                      
C30083     END-IF.                                                      
C30083*                                                                 05231307
C30083 7410-EXIT.                                                       
C30083     EXIT.                                                        
C30083*                                                                 05221007
HPCCDM*EJECT                                                                    
      ******************************************************************        
      *    OPEN CURSOR TO GET GL NUMBERS.                              *        
      ******************************************************************        
       7800-OPEN-GL-NBRS.                                               
                                                                        
           EXEC SQL                                                     
                OPEN GL_NBRS                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 7800                  TO ACTIVE-PARAGRAPH           
               MOVE 'OPEN    '            TO ABEND-FUNCTION             
               MOVE 'CSS_GL_ACCOUNT'      TO TABLE-1                    
               MOVE 'RETURN CODE IS'      TO WS-ERROR-MSG-1             
               MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1          
               MOVE SPACES                TO WS-ERROR-MSG-2             
               MOVE SPACES                TO HOSTVAR-ELEMENT-2          
               MOVE SPACES                TO WS-ERROR-MSG-3             
               MOVE SPACES                TO HOSTVAR-ELEMENT-3          
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
      ******************************************************************        
      *    FETCH GL NUMBERS *                                                   
      ******************************************************************        
       7820-FETCH-GL-NBRS.                                              
                                                                        
           EXEC SQL                                                     
                FETCH GL_NBRS                                           
                INTO :GO-COMPANY-NO,                                    
                     :GO-GL-ACCT-NO,                                    
                     :GL-LOCAL-OFFICE                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               ADD 1 TO  WS-GL-SUBSCRIPT                                
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 7820                  TO ACTIVE-PARAGRAPH           
               MOVE 'FETCH   '            TO ABEND-FUNCTION             
               MOVE 'CSS_GL_ACCOUNT'      TO TABLE-1                    
               MOVE 'RETURN CODE IS'      TO WS-ERROR-MSG-1             
               MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1          
               MOVE SPACES                TO WS-ERROR-MSG-2             
               MOVE SPACES                TO HOSTVAR-ELEMENT-2          
               MOVE SPACES                TO WS-ERROR-MSG-3             
               MOVE SPACES                TO HOSTVAR-ELEMENT-3          
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF
           END-IF.           
                                                                        
       7820-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
      ******************************************************************        
      *    CLOSE GL NUMBERS *                                                   
      ******************************************************************        
       7850-CLOSE-GL-NBRS.                                              
                                                                        
           EXEC SQL                                                     
             CLOSE GL_NBRS                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 7850                  TO ACTIVE-PARAGRAPH           
               MOVE 'CLOSE   '            TO ABEND-FUNCTION             
               MOVE 'CSS_GL_ACCOUNT'      TO TABLE-1                    
               MOVE 'RETURN CODE IS'      TO WS-ERROR-MSG-1             
               MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1          
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
           IF WS-GL-SUBSCRIPT GREATER THAN 2000                         
               MOVE 7850             TO ACTIVE-PARAGRAPH                
               MOVE 'BUILD   '       TO ABEND-FUNCTION                  
               MOVE 'CSS_GL_ACCOUNT' TO TABLE-1                         
               MOVE 'GL TABLE ENTRIES EXCEED 2000 - POSSIBLE'           
                     TO WS-ERROR-MSG-1                                  
               MOVE 'PROGRAM CHANGE REQUIRED' TO WS-ERROR-MSG-2         
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7850-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
T11466******************************************************************27925000
T11466*    RETRIEVE THE CURRENT DATE                                    27925100
T11466******************************************************************27925200
T11466 7960-GET-CURRENT-DATE.                                           
T11466                                                                  
T11466     EXEC SQL                                                     
T35434          SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :LS-INPUT-DATE                       
T11466     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     27925600
MFA-TR*         SET :LS-INPUT-DATE = CURRENT DATE                       27925700
MFA-TR*    END-EXEC.                                                    27926000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T11466                                                                  
T11466     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T11466                                                                  
T11466     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T11466         NEXT SENTENCE                                            
T11466     ELSE                                                         
T11466         MOVE 7960                  TO ACTIVE-PARAGRAPH           
T35434         MOVE 'SET  '               TO ABEND-FUNCTION             
T11466         MOVE 'RETURN CODE IS'      TO WS-ERROR-MSG-1             
T11466         MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1          
T11466         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
T11466                                                                  
T11466 7960-EXIT.                                                       
T11466     EXIT.                                                        
      * CHECK AR LOCKOUT ***                                                    
PCR640*7999-SELECT-AL                                                           
PCR640     EXEC SQL                                                             
PCR640         INCLUDE CPD00075                                                 
PCR640     END-EXEC.                                                            
      *                                                                         
      **** ALL SQL INSERTS, UPDATES, AND DELETES GO IN THE 8000-                
      **** RANGE OF PARAGRAPHS                                                  
      ******************************************************************        
      *    UPDATE CSS_ACCOUNT'S CODES-DATA-PRESENT FOR CODE-CIA.                
      ******************************************************************        
       8000-UPDATE-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
                UPDATE CSS_ACCOUNT                                      
                   SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT      
                 WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 8000                  TO ACTIVE-PARAGRAPH           
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE 'CSS_ACCOUNT'         TO TABLE-1                    
               MOVE 'RETURN CODE IS'      TO WS-ERROR-MSG-1             
               MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1          
               MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2-N        
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8100-UPDATE-AMT-ORIG-ENT.                                        
           MOVE '8100' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               UPDATE CSS_AR_TRANS_HIST                                 
                  SET AMT_ORIG_ENTERED  = :AR-AMT-ORIG-ENTERED          
                WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                
                  AND TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_AR_TRANS_HIST                                         
MFA-TR*           SET AMT_ORIG_ENTERED  = :AR-AMT-ORIG-ENTERED                  
MFA-TR*         WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                        
MFA-TR*           AND TRANS_HIST_SEQ_NO = :AR-TRANS-HIST-SEQ-NO                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                    OR NOT-FOUND                        
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
              MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AR-TRANS-HIST-SEQ-NO      TO HOSTVAR-ELEMENT-2       
              MOVE AR-DATE-TRANS             TO HOSTVAR-ELEMENT-3       
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C      8898-ISSUE-COMMIT.                                               
C     *                                                                         
C          ADD +1                         TO WS-COMMIT-COUNT.           
C          ADD +1                         TO WS-COMMIT-SEQ-NO.          
C          IF WS-COMMIT-COUNT = WS-COMMIT-UPD-COUNTER                   
              ADD +1                         TO WS-TOT-COMMIT-CNT       
C             EXEC SQL                                                  
C                 COMMIT                                                
C             END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C             DISPLAY '*********************'                           
C             DISPLAY 'COMMIT POINT # ' WS-COMMIT-SEQ-NO ' TAKEN.'      
C             DISPLAY 'ACCOUNT NO PROCESSED ' WS-COMMIT-ACCT-NO         
C             DISPLAY 'ITEM ID              ' WS-COMMIT-ITEM-ID         
C             DISPLAY 'AMNT UNUSED CREDIT   ' WS-COMMIT-AMT-UNUSED-CR   
C             DISPLAY '*********************'                           
C             MOVE +0 TO WS-COMMIT-COUNT                                
C          END-IF.                                                      
C     *                                                                         
C      8898-EXIT.                                                       
C          EXIT.                                                        
C     *                                                                         
T15301*****************************************************************         
T15301*   8895-INSERT-WORK-QUEUE                                      *         
T15301*****************************************************************         
A04860 8895-INSERT-WORK-QUEUE.                                          
A04860*                                                                         
A04860     CALL SCSCB077 USING CWS00077-FIELDS,                         
A04860                         ABEND-FILE,                              
A04860                         RS-RETURN-CODE.                          
A04860                                                                  
A04860     MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE                 
A04860                                                                  
A04860     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
A04860        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A04860        DISPLAY '8895-INSERT-WORK-QUEUE'                          
A04860        DISPLAY 'CALL SCSCB077         '                          
A04860        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
A04860        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
A04860        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
A04860        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A04860        PERFORM 9900-ABEND    THRU 9900-EXIT                      
A04860     END-IF.                                                      
                                                                        
A04860 8895-EXIT.                                                       
A04860     EXIT.                                                        
PCR640*****************************************************************         
PCR640 9000-SEND-ERROR-RESULT.                                          
PCR640                                                                  
PCR640     GO TO 9000-EXIT.                                             
      *                                                                         
       9000-TERMINATE.                                                  
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               GO TO 9000-EXIT                                          
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-SQLCODE                       
               DISPLAY '                                      '         
               DISPLAY '**************************************'         
               DISPLAY '****  PCSAC165  PROCESSING ERROR  ****'         
               DISPLAY '**************************************'         
               DISPLAY '                                      '         
               DISPLAY 'SQLCODE =  ' WS-DISPLAY-SQLCODE
           END-IF.                
       9000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************34344400
      *    ABEND ROUTINE                                                34344500
      ******************************************************************34344600
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          
                                                                        
                                                                        
           DISPLAY '**************************************'.            
           DISPLAY '**  PROCESSING ERROR'.                              
           DISPLAY '**  PROGRAM    = ' ABEND-PROGRAM.                   
                                                                        
           IF WS-DB2-PARAGRAPH > SPACES                                 
               DISPLAY '**  PARAGRAPH  = ' WS-DB2-PARAGRAPH
           END-IF.            
                                                                        
           IF WS-DB2-FUNCTION > SPACES                                  
               DISPLAY '**  FUNCTION   = ' WS-DB2-FUNCTION
           END-IF.             
                                                                        
           IF ACTIVE-PARAGRAPH > SPACES                                 
               DISPLAY '**  PARAGRAPH  = ' ACTIVE-PARAGRAPH
           END-IF.            
                                                                        
           IF ABEND-FUNCTION > SPACES                                   
               DISPLAY '**  FUNCTION   = ' ABEND-FUNCTION
           END-IF.              
                                                                        
           IF TABLE-1 > SPACES                                          
               DISPLAY '**  TABLE/FILE = ' TABLE-1
           END-IF.                     
                                                                        
           IF WS-ERROR-MSG-1 > SPACES                                   
               DISPLAY '**  ' WS-ERROR-MSG-1
           END-IF.                           
                                                                        
           IF HOSTVAR-ELEMENT-1 > SPACES                                
               DISPLAY '**  ' HOSTVAR-ELEMENT-1
           END-IF.                        
                                                                        
           IF WS-ERROR-MSG-2 > SPACES                                   
               DISPLAY '**  ' WS-ERROR-MSG-2
           END-IF.                           
                                                                        
           IF HOSTVAR-ELEMENT-2 > SPACES                                
               DISPLAY '**  ' HOSTVAR-ELEMENT-2
           END-IF.                        
                                                                        
           IF WS-ERROR-MSG-3 > SPACES                                   
               DISPLAY '**  ' WS-ERROR-MSG-3
           END-IF.                           
                                                                        
           IF HOSTVAR-ELEMENT-3 > SPACES                                
               DISPLAY '**  ' HOSTVAR-ELEMENT-3
           END-IF.                        
                                                                        
           DISPLAY '**************************************'.            
      *************************************************************     34344400
      * ABEND ROUTINE PERFORMED IF VSAM OR DB2 PROBLEM OCCURS. *                
      * 9900-ABEND                                                *     34344500
      *************************************************************     34344600
           EXEC SQL                                                     34730000
               INCLUDE CPD09900                                         34740000
           END-EXEC.                                                    34750000
                                                                        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD0023B                                                   
           END-EXEC.                                                            
      *                                                                         
