       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   PCSCA162.                                          
       AUTHOR.       SIDDHARTHA SARKAR (COVANSYS).                      
       DATE-WRITTEN. MAR 2008.                                          
       DATE-COMPILED.                                                   
      ******************************************************************        
      **                       SCANA ENERGY                           **        
      **             SEB GROUP2 MOVEMENT REPORT EXTRACT               **        
      **                        COBOL-DB2                             **        
      ******************************************************************        
      **                     PROGRAM SUMMARY                          **        
      ******************************************************************        
      **   THIS PROGRAM CREATES A EXTRACT FILE TO GENERATE MONTHLY    **        
      **   GROUP2 MOVEMENT REPORT FOR SEB ACCOUNTS BASED ON CSC AMT   **        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     INPUT PROCESSING CONTROL PATH         **        
      **        2000 - 2999     OUTPUT PROCESS CONTROL PATH           **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     COMMON SYSTEM MODULES                 **        
      **        7000 - 7999     INPUT MODULES                         **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      **                PROGRAM  MODIFICATION  LOG                    **        
      ******************************************************************        
      ** DATE     USER ID  REASON                                     **        
      ** -------  -------  ------                                     **        
      ** 03/2008  SS97726  INITIAL IMPLEMENTATION.                    **        
P00473** 05/2011  SB93596  CHGS INCLUDED TO PULL APPROVED OPTION **             
P00473**                   RECORDS.                                   **        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT FCSCA162-FILE                                         
               ASSIGN TO UT-S-FCSCA162                                  
               FILE STATUS IS WS-FCA162-STATUS.                         
      *                                                                         
           SELECT GRPMVMNT-FILE                                         
               ASSIGN TO UT-S-GRPMVMNT                                  
               FILE STATUS IS WS-GRPMNT-STATUS.                         
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       FD  FCSCA162-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORD CONTAINS 79 CHARACTERS                                
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
      ****************************************************************          
      *        RECORD DESCRIPTION FOR OUTPUT FILE FCSCA162           *          
      ****************************************************************          
      *                                                                         
       01  FCSCA162.                                                    
         02  E-FCA162-DATA-REC.                                         
           05  E-FCA162-ACCOUNT-NO          PIC 9(13).                  
           05  E-FCA162-OPTION-CODE         PIC X(12).                  
           05  E-FCA162-OPT-DESC            PIC X(50).                  
           05  E-FCA162-SORT-GRP-CD         PIC X(01).                  
           05  E-FCA162-SORT-GRP-ORD-CD     PIC X(03).                  
      *                                                                         
      ****************************************************************          
      *                      END OF LAYOUT                           *          
      ****************************************************************          
       FD  GRPMVMNT-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORD CONTAINS 78 CHARACTERS                                
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
      ****************************************************************          
      *        RECORD DESCRIPTION FOR OUTPUT FILE GRPMVMNT           *          
      ****************************************************************          
      *                                                                         
       01  GRPMVMNT.                                                    
         02  E-GRPMNT-DATA-REC.                                         
           05  E-GRPMNT-ACCOUNT-NO          PIC 9(13).                  
           05  E-GRPMNT-OPTION-CODE         PIC X(12).                  
           05  E-GRPMNT-OPT-DESC            PIC X(50).                  
           05  E-GRPMNT-AGR-SRC-CD          PIC X(03).                  
      *                                                                         
      ****************************************************************          
      *                      END OF LAYOUT                           *          
      ****************************************************************          
HPCCDM*EJECT                                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA162'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                          PIC X(40) VALUE             
               'WORKING STORAGE FOR PCSCA162 STARTS HERE'.              
      *                                                                         
       01 WORK-AREAS.                                                   
          05 PROGRAM-NAME                   PIC X(08) VALUE 'PCSCA162'. 
          05 WS-RT-PKG-OPT-SEQ-NO           PIC S9(4) USAGE COMP.       
          05 WS-HLD-ACCOUNT-NO              PIC 9(13) VALUE ZEROES.     
          05 WS-HLD-AGR-SRC-CD              PIC X(03) VALUE SPACES.     
          05 FILLER REDEFINES WS-HLD-AGR-SRC-CD.                        
             10 WS-AUTOMATED-SRC-CD         PIC X(03).                  
                88 WS-AUTO   VALUE 'FDL' 'FDM' 'FDH' 'VDL' 'VDM' 'VDH'. 
          05 FILLER REDEFINES WS-HLD-AGR-SRC-CD.                        
             10 WS-FP-RNW-SRC-CD            PIC X(03).                  
                88 WS-FP-RNW VALUE 'FRL' 'FRM' 'FRH'.                   
          05 FILLER REDEFINES WS-HLD-AGR-SRC-CD.                        
             10 WS-MANUAL-SRC-CD            PIC X(03).                  
                88 WS-MANUAL VALUE '1T2' '12S' '2T1' '21S'.             
          05 WS-HLD-OPT-CD                  PIC X(12) VALUE SPACES.     
          05 WS-HLD-OPT-CD-DSC              PIC X(50) VALUE SPACES.     
          05 WS-SORT-GRP-CD                 PIC X(01) VALUE SPACES.     
          05 WS-SORT-GRP-ORD-CD             PIC X(03) VALUE SPACES.     
          05 WS-PROCESS-REV-MNTH            PIC X(06) VALUE SPACES.     
          05 WS-REVENUE-MNTH-CCYYMM.                                    
             10 WS-REVENUE-MNTH-CCYY        PIC X(04) VALUE SPACES.     
             10 WS-REVENUE-MNTH-DASH1       PIC X(01) VALUE '-'.        
             10 WS-REVENUE-MNTH-MM          PIC X(02) VALUE SPACES.     
             10 WS-REVENUE-MNTH-DASH2       PIC X(01) VALUE '-'.        
             10 WS-REVENUE-MNTH-DD          PIC X(02) VALUE SPACES.     
          05 WS-MNTH-STRT-DATE              PIC X(10) VALUE SPACES.     
          05 WS-MNTH-END-DATE               PIC X(10) VALUE SPACES.     
          05 WS-REV-MNTH-YR-NUM             PIC 9(04) VALUE ZEROS.      
          05 WS-QUOTIENT                    PIC 9(04) VALUE ZEROS.      
          05 WS-REMAINDER                   PIC 9(02) VALUE ZEROS.      
      *                                                                         
       01 WS-FCA162-STATUS                  PIC X(2)    VALUE '00'.     
       01 WS-GRPMNT-STATUS                  PIC X(2)    VALUE '00'.     
      *                                                                         
       01 WS-SWITCHES-AND-INDICATORS.                                   
          05 WS-END-ACCOUNT-CUR-SW          PIC X(1)  VALUE 'N'.        
             88 WS-END-ACCOUNT-CUR                    VALUE 'Y'.        
             88 WS-NOT-END-ACCOUNT-CUR                VALUE 'N'.        
          05 WS-PRV-RTPK-AGR-SW             PIC X(1)  VALUE 'N'.        
             88 WS-PRV-RTPK-AGR                       VALUE 'Y'.        
             88 WS-NO-PRV-RTPK-AGR                    VALUE 'N'.        
          05 WS-SKIP-ACCOUNT-SW             PIC X(1)  VALUE 'N'.        
             88 SKIP-ACCOUNT                          VALUE 'Y'.        
             88 DONT-SKIP-ACCOUNT                     VALUE 'N'.        
          05 WS-OVER-RIDE-DATE-SW           PIC X(1)  VALUE 'N'.        
             88 OVER-RIDE-DATE                        VALUE 'Y'.        
             88 NO-OVER-RIDE-DATE                     VALUE 'N'.        
      *                                                                         
       01 WS-COUNTERS.                                                  
          05 WS-CA162-RECS-WRITE            PIC 9(7)  VALUE ZEROS.      
          05 WS-GRPMNT-RECS-WRITE           PIC 9(7)  VALUE ZEROS.      
      *                                                                         
      ******************************************************************        
      **                                                              **        
      ** WORKING STORAGE COPY BOOKS FOLLOW ALL PROGRAM WS             **        
      **                                                              **        
      ******************************************************************        
      /*****   SQL WORK VARIABLES.                                              
       COPY CWS00303.                                                           
                                                                        
      /*****   WS AREA FOR ABEND SWITCH.                                        
       COPY CWS09900.                                                           
                                                                        
      /*****   WS AREA FOR ABEND WORK.                                          
       COPY CWS00010.                                                           
                                                                        
      /*****   WS AREA FOR MISC. INPUT.                                         
       COPY CWS00038.                                                           
                                                                        
       01  WS-END                           PIC X(40) VALUE             
                 'DB2 INCLUDES FOR PCSCA162 START HERE '.               
      ******************************************************************        
      **                                                              **        
      **  TABLE DECLARATIONS GO AFTER OTHER WORKING STORAGE ITEMS     **        
      **  (IF DIRECT ACCESS TO DB2 TABLES IS ALLOWED). FIRST ITEM     **        
      **  WILL ALWAYS BE SQLCA.                                       **        
      **                                                              **        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      /                                                                         
      / IO AREA FOR PARM INPUT FILE 'A'                                         
      /                                                                         
           EXEC SQL                                                             
              INCLUDE FIOJC01                                                   
           END-EXEC.                                                            
      /                                                                         
      / CSS_JOB_PARM DCLGEN                                                     
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      /                                                                         
      / CSS_ACCOUNT DCLGEN                                                      
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      /                                                                         
      / CSS_ACCT_RTPK_AGR DCLGEN                                                
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCTRG                                                 
           END-EXEC.                                                            
      /                                                                         
      / CRM_RT_PKG_OPTION DCLGEN                                                
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBRTPKGO                                                 
           END-EXEC.                                                            
      /                                                                         
      / CSS_RATE_PLAN_DESC DCLGEN                                               
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBRTDESC                                                 
           END-EXEC.                                                            
      /                                                                         
      / CSS_UTIL_ENVRNMT DCLGEN                                                 
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      /                                                                         
      ******************************************************************        
      **                                                              **        
      **  CURSOR DECLARATIONS (IF ANY) GO LAST                        **        
      **                                                              **        
      ******************************************************************        
      **BASE CURSOR TO EXTRACT THE OPTION CODES FOR THE SEB ACCOUNTS            
           EXEC SQL                                                     
              DECLARE ACCOUNT_CUR CURSOR FOR                            
               SELECT DF.ACCOUNT_NO                                     
                     ,DF.CODE_UTIL_TYPE                                 
                     ,DF.IC_NO                                          
                     ,DF.RT_PKG_OPT_SEQ_NO                              
                     ,DF.AGREEMNT_SOURCE_CD                             
                     ,FI.OPTION_CD                                      
                     ,FI.OPT_DESC_INT                                   
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                     ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
                     ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                
                     ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                
                WHERE AT.ACCOUNT_NO           = UT.ACCOUNT_NO           
                  AND AT.CODE_ACCT_STAT       = 'A'                     
                  AND UT.CODE_UTIL_TYPE       = 'G'                     
                  AND UT.IC_NO                = 1                       
                  AND DF.ACCOUNT_NO           = UT.ACCOUNT_NO           
                  AND DF.IC_NO                = UT.IC_NO                
                  AND DF.CODE_UTIL_TYPE       = UT.CODE_UTIL_TYPE       
                  AND DF.RT_PKG_OPT_SEQ_NO    = UT.RT_PKG_OPT_SEQ_NO    
                  AND DF.OPT_AGRMT_EFF_DT     >= IIF(TRY_CONVERT(DATE, 
                                                     :WS-MNTH-STRT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-MNTH-STRT-DATE
              ) <> 0) OR (LEN(:WS-MNTH-STRT-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-MNTH-STRT-DATE
              ), CONVERT(DATE, :WS-MNTH-STRT-DATE) )     
                  AND DF.OPT_AGRMT_EFF_DT     <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-MNTH-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-MNTH-END-DATE
              ) <> 0) OR (LEN(:WS-MNTH-END-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-MNTH-END-DATE
              ), CONVERT(DATE, :WS-MNTH-END-DATE) )      
                  AND DF.AGREEMNT_SOURCE_CD IN ('FDL','FDM','FDH',      
                                                'FRL','FRM','FRH',      
                                                'VDL','VDM','VDH',      
                                                '1T2','12S','2T1','21S')
                  AND FI.OPTION_CD            = DF.OPTION_CD            
                  AND FI.COMPANY_NO           = '01'                    
P00473            AND FI.OPT_VSTART_TS       <= CIS.CURRENT$TIMESTAMP()       
P00473            AND FI.OPT_VEND_TS         >= CIS.CURRENT$TIMESTAMP()       
P00473            AND FI.PROC_STATUS_CD       = 'AC'                    
                  FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ACCOUNT_CUR CURSOR FOR                                    
MFA-TR*        SELECT DF.ACCOUNT_NO                                             
MFA-TR*              ,DF.CODE_UTIL_TYPE                                         
MFA-TR*              ,DF.IC_NO                                                  
MFA-TR*              ,DF.RT_PKG_OPT_SEQ_NO                                      
MFA-TR*              ,DF.AGREEMNT_SOURCE_CD                                     
MFA-TR*              ,FI.OPTION_CD                                              
MFA-TR*              ,FI.OPT_DESC_INT                                           
MFA-TR*          FROM CSS_ACCOUNT AT                                            
MFA-TR*              ,CSS_UTIL_ENVRNMT UT                                       
MFA-TR*              ,CSS_ACCT_RTPK_AGR DF                                      
MFA-TR*              ,CRM_RT_PKG_OPTION FI                                      
MFA-TR*         WHERE AT.ACCOUNT_NO           = UT.ACCOUNT_NO                   
MFA-TR*           AND AT.CODE_ACCT_STAT       = 'A'                             
MFA-TR*           AND UT.CODE_UTIL_TYPE       = 'G'                             
MFA-TR*           AND UT.IC_NO                = 1                               
MFA-TR*           AND DF.ACCOUNT_NO           = UT.ACCOUNT_NO                   
MFA-TR*           AND DF.IC_NO                = UT.IC_NO                        
MFA-TR*           AND DF.CODE_UTIL_TYPE       = UT.CODE_UTIL_TYPE               
MFA-TR*           AND DF.RT_PKG_OPT_SEQ_NO    = UT.RT_PKG_OPT_SEQ_NO            
MFA-TR*           AND DF.OPT_AGRMT_EFF_DT     >= :WS-MNTH-STRT-DATE             
MFA-TR*           AND DF.OPT_AGRMT_EFF_DT     <= :WS-MNTH-END-DATE              
MFA-TR*           AND DF.AGREEMNT_SOURCE_CD IN ('FDL','FDM','FDH',              
MFA-TR*                                         'FRL','FRM','FRH',              
MFA-TR*                                         'VDL','VDM','VDH',              
MFA-TR*                                         '1T2','12S','2T1','21S')        
MFA-TR*           AND FI.OPTION_CD            = DF.OPTION_CD                    
MFA-TR*           AND FI.COMPANY_NO           = '01'                            
MFA-TR*           AND FI.OPT_VSTART_TS       <= CURRENT TIMESTAMP               
MFA-TR*           AND FI.OPT_VEND_TS         >= CURRENT TIMESTAMP               
MFA-TR*           AND FI.PROC_STATUS_CD       = 'AC'                            
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      **  0000-MAINLINE.                                              **        
      **  CONTROLS THE MAIN PROCESSING OF THE PROGRAM.                **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE.                                     
           PERFORM 1000-PROCESS-ACCOUNTS  THRU 1000-EXIT                
             UNTIL WS-END-ACCOUNT-CUR.                                  
           PERFORM 7020-CLOSE-ACCOUNT     THRU 7020-EXIT.               
           PERFORM 9000-TERMINATE         THRU 9000-EXIT.               
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  0100-INITIALIZE.                                            **        
      **       PROGRAM INITIALIZATION.                                **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           MOVE 'N'                        TO WS-END-ACCOUNT-CUR-SW.    
           MOVE ZEROS                      TO WS-CA162-RECS-WRITE       
                                              WS-GRPMNT-RECS-WRITE.     
           SET WS-NO-PRV-RTPK-AGR          TO TRUE.                     
                                                                        
      ** OPEN THE OUTPUT FILES                                                  
           OPEN OUTPUT FCSCA162-FILE                                    
                       GRPMVMNT-FILE.                                   
      ** GET REVENUE MONTH                                                      
           PERFORM 0200-GET-PARM-DATA      THRU 0200-EXIT.              
      ** OPEN THE BASE CURSOR                                                   
           PERFORM 7000-OPEN-ACCOUNT       THRU 7000-EXIT.              
      ** FETCH FIRST RECORD                                                     
           PERFORM 7010-FETCH-ACCOUNT      THRU 7010-EXIT.              
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *   0200-GET-PARM-DATA                                          *         
      *        ACCESS OF COMMON DATE RECORD TO GET REVENUE MONTH      *         
      *****************************************************************         
       0200-GET-PARM-DATA.                                              
      *                                                                         
           SET NO-OVER-RIDE-DATE       TO TRUE.                         
           MOVE SPACES                 TO WS-SYSIPT.                    
           MOVE SPACES                 TO WS-INPUT-DATA-BREAKDOWN       
           MOVE PROGRAM-NAME           TO WS-PROGRAM.                   
           MOVE WS-DATE                TO WS-COMMAND.                   
           MOVE ZEROS                  TO WS-SEQUENCE.                  
           MOVE WS-KEY-AREA            TO E-FJC01-KEY.                  
                                                                        
           PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
                                                                        
           PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
               UNTIL (REVENUE-MONTH AND INPUT-ACTIVE)                   
                  OR  END-OF-SYSIPT.                                    
                                                                        
           EVALUATE TRUE                                                
              WHEN END-OF-SYSIPT                                        
                 CONTINUE                                               
              WHEN OTHER                                                
                 MOVE G6-PARM-DATA (15:6)                               
                                       TO WS-PROCESS-REV-MNTH           
                 DISPLAY '** PROGRAM OVERRIDE REVENUE MNTH USED **'     
                 SET OVER-RIDE-DATE    TO TRUE                          
                 PERFORM 7611-CLOSE    THRU 7611-EXIT                   
           END-EVALUATE.                                                
      *                                                                         
           IF NO-OVER-RIDE-DATE                                         
              MOVE SPACES              TO WS-SYSIPT                     
              MOVE SPACES              TO WS-INPUT-DATA-BREAKDOWN       
              MOVE 'REPORTDATE'        TO WS-PROGRAM                    
              MOVE WS-DATE             TO WS-COMMAND                    
              MOVE ZEROS               TO WS-SEQUENCE                   
              MOVE WS-KEY-AREA         TO E-FJC01-KEY                   
                                                                        
              PERFORM 7600-START-FCSJC01 THRU 7600-EXIT                 
                                                                        
              PERFORM 7610-READ-FCSJC01  THRU 7610-EXIT                 
               UNTIL INPUT-ACTIVE                                       
                  OR END-OF-SYSIPT                                      
                                                                        
              EVALUATE TRUE                                             
                 WHEN END-OF-SYSIPT                                     
                    DISPLAY '**      PCSCA162 PROCESSING ERROR  **'     
                    DISPLAY '**  NO ACTIVE REPORTDATE REVENUE MNTH'     
                    DISPLAY '**        PROCESSING TERMINATED    **'     
                    PERFORM 9900-ABEND    THRU  9900-EXIT               
                 WHEN OTHER                                             
                    MOVE G6-PARM-DATA (13:6)                            
                                          TO WS-PROCESS-REV-MNTH        
                    PERFORM 7611-CLOSE    THRU 7611-EXIT                
              END-EVALUATE                                              
           END-IF.                                                      
      *                                                                         
           IF WS-PROCESS-REV-MNTH NUMERIC                               
              MOVE SPACES                  TO WS-REVENUE-MNTH-CCYY      
                                              WS-REVENUE-MNTH-MM        
                                              WS-REVENUE-MNTH-DD        
                                              WS-MNTH-STRT-DATE         
                                              WS-MNTH-END-DATE          
              MOVE ZEROS                   TO WS-REV-MNTH-YR-NUM        
                                              WS-QUOTIENT               
                                              WS-REMAINDER              
              MOVE WS-PROCESS-REV-MNTH (1:4)                            
                                           TO WS-REVENUE-MNTH-CCYY      
              MOVE WS-PROCESS-REV-MNTH (5:2)                            
                                           TO WS-REVENUE-MNTH-MM        
              MOVE '-'                     TO WS-REVENUE-MNTH-DASH1     
                                              WS-REVENUE-MNTH-DASH2     
              MOVE WS-REVENUE-MNTH-CCYY    TO WS-REV-MNTH-YR-NUM        
      *DETERMINE WHETHER A LEAP YEAR                                            
              DIVIDE WS-REV-MNTH-YR-NUM BY 4                            
                     GIVING WS-QUOTIENT                                 
                     REMAINDER WS-REMAINDER                             
              IF WS-REMAINDER = 0                                       
                 IF WS-REVENUE-MNTH-MM = '02'                           
                    MOVE '29'              TO WS-REVENUE-MNTH-DD        
                 END-IF                                                 
              ELSE                                                      
                 IF WS-REVENUE-MNTH-MM = '02'                           
                    MOVE '28'              TO WS-REVENUE-MNTH-DD        
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF WS-REVENUE-MNTH-MM = '01' OR '03' OR '05' OR '07' OR   
                                      '08' OR '10' OR '12'              
                 MOVE '31'                 TO WS-REVENUE-MNTH-DD        
              ELSE                                                      
                 IF WS-REVENUE-MNTH-MM = '04' OR '06' OR '09' OR '11'   
                    MOVE '30'              TO WS-REVENUE-MNTH-DD        
                 END-IF                                                 
              END-IF                                                    
              MOVE WS-REVENUE-MNTH-CCYYMM  TO WS-MNTH-END-DATE          
              DISPLAY 'PROCESS MONTH END DATE   : ' WS-MNTH-END-DATE    
              MOVE '01'                    TO WS-REVENUE-MNTH-DD        
              MOVE WS-REVENUE-MNTH-CCYYMM  TO WS-MNTH-STRT-DATE         
              DISPLAY 'PROCESS MONTH START DATE : ' WS-MNTH-STRT-DATE   
           ELSE                                                         
              DISPLAY ' '                                               
              DISPLAY '** ' PROGRAM-NAME ' PROCESSING ERROR  **'        
              DISPLAY '**  REPORTDATE IS NOT ACTIVE'                    
              DISPLAY '**    KEY = ' E-FJC01-KEY                        
              DISPLAY '**   PROCESSING TERMINATED  **'                  
              PERFORM 9900-ABEND           THRU  9900-EXIT              
           END-IF.                                                      
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  1000-PROCESS-ACCOUNTS.                                      **        
      **       MAIN LOGIC TO EXTRACT THE ACCOUNTS                     **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-ACCOUNTS.                                           
      *                                                                         
           MOVE SPACES                    TO WS-HLD-AGR-SRC-CD          
                                             WS-HLD-OPT-CD-DSC          
                                             WS-HLD-OPT-CD.             
           MOVE ZEROS                     TO WS-RT-PKG-OPT-SEQ-NO       
                                             WS-HLD-ACCOUNT-NO.         
                                                                        
           MOVE DF-ACCOUNT-NO             TO WS-HLD-ACCOUNT-NO.         
           MOVE DF-AGREEMNT-SOURCE-CD     TO WS-HLD-AGR-SRC-CD.         
           MOVE FI-OPT-DESC-INT           TO WS-HLD-OPT-CD-DSC.         
           MOVE FI-OPTION-CD              TO WS-HLD-OPT-CD.             
                                                                        
           IF WS-AUTO OR WS-FP-RNW                                      
              COMPUTE WS-RT-PKG-OPT-SEQ-NO = DF-RT-PKG-OPT-SEQ-NO - 1   
                                                                        
              IF WS-RT-PKG-OPT-SEQ-NO > 0                               
                 SET WS-NO-PRV-RTPK-AGR   TO TRUE                       
                 PERFORM 7100-VERIFY-PRV-RTPK-AGR THRU 7100-EXIT        
                                                                        
                 IF WS-PRV-RTPK-AGR                                     
                    SET DONT-SKIP-ACCOUNT TO TRUE                       
                    PERFORM 1100-CHK-OPTN-CHG-CD THRU 1100-EXIT         
                    IF DONT-SKIP-ACCOUNT                                
                       PERFORM 1200-POPULATE-DETAILS THRU 1200-EXIT     
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
             IF WS-MANUAL                                               
                INITIALIZE                   E-GRPMNT-DATA-REC          
                MOVE WS-HLD-ACCOUNT-NO    TO E-GRPMNT-ACCOUNT-NO        
                MOVE WS-HLD-OPT-CD        TO E-GRPMNT-OPTION-CODE       
                MOVE WS-HLD-OPT-CD-DSC    TO E-GRPMNT-OPT-DESC          
                MOVE WS-HLD-AGR-SRC-CD    TO E-GRPMNT-AGR-SRC-CD        
                PERFORM 8100-WRITE-RECORD THRU 8100-EXIT                
             END-IF                                                     
           END-IF.                                                      
                                                                        
           PERFORM 7010-FETCH-ACCOUNT     THRU 7010-EXIT.               
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  1100-CHK-OPTN-CHG-CD.                                     **          
      **      DETERMINE THE OPTION CHANGE CODE FOR REPORT DISPLAY   **          
      ****************************************************************          
      *                                                                         
       1100-CHK-OPTN-CHG-CD.                                            
      *                                                                         
           MOVE SPACES                      TO WS-SORT-GRP-CD           
                                               WS-SORT-GRP-ORD-CD.      
           IF WS-AUTO                                                   
              MOVE 'A'                      TO WS-SORT-GRP-CD           
              EVALUATE WS-HLD-AGR-SRC-CD ALSO RD-MKT-PROGRAM-CD         
                  WHEN 'FDM' ALSO '2H'                                  
                    MOVE 'A1P'              TO WS-SORT-GRP-ORD-CD       
                  WHEN 'VDM' ALSO '2H'                                  
                    MOVE 'A2P'              TO WS-SORT-GRP-ORD-CD       
                  WHEN 'FDL' ALSO '2H'                                  
                    MOVE 'A3Q'              TO WS-SORT-GRP-ORD-CD       
                  WHEN 'VDL' ALSO '2H'                                  
                    MOVE 'A4Q'              TO WS-SORT-GRP-ORD-CD       
                  WHEN 'FDH' ALSO '2M'                                  
                    MOVE 'B1R'              TO WS-SORT-GRP-ORD-CD       
                  WHEN 'VDH' ALSO '2M'                                  
                    MOVE 'B2R'              TO WS-SORT-GRP-ORD-CD       
                  WHEN 'FDL' ALSO '2M'                                  
                    MOVE 'B3S'              TO WS-SORT-GRP-ORD-CD       
                  WHEN 'VDL' ALSO '2M'                                  
                    MOVE 'B4S'              TO WS-SORT-GRP-ORD-CD       
                  WHEN 'FDH' ALSO '2L'                                  
                    MOVE 'C1T'              TO WS-SORT-GRP-ORD-CD       
                  WHEN 'VDH' ALSO '2L'                                  
                    MOVE 'C2T'              TO WS-SORT-GRP-ORD-CD       
                  WHEN 'FDM' ALSO '2L'                                  
                    MOVE 'C3U'              TO WS-SORT-GRP-ORD-CD       
                  WHEN 'VDM' ALSO '2L'                                  
                    MOVE 'C4U'              TO WS-SORT-GRP-ORD-CD       
                  WHEN OTHER                                            
                    MOVE SPACES             TO WS-SORT-GRP-ORD-CD       
              END-EVALUATE                                              
           ELSE                                                         
              IF WS-FP-RNW                                              
                 MOVE 'R'                   TO WS-SORT-GRP-CD           
                 EVALUATE WS-HLD-AGR-SRC-CD ALSO RD-MKT-PROGRAM-CD      
                     WHEN 'FRM' ALSO '2H'                               
                       MOVE 'A1P'           TO WS-SORT-GRP-ORD-CD       
                     WHEN 'FRL' ALSO '2H'                               
                       MOVE 'A2Q'           TO WS-SORT-GRP-ORD-CD       
                     WHEN 'FRH' ALSO '2M'                               
                       MOVE 'B1R'           TO WS-SORT-GRP-ORD-CD       
                     WHEN 'FRL' ALSO '2M'                               
                       MOVE 'B2S'           TO WS-SORT-GRP-ORD-CD       
                     WHEN 'FRH' ALSO '2L'                               
                       MOVE 'C1T'           TO WS-SORT-GRP-ORD-CD       
                     WHEN 'FRM' ALSO '2L'                               
                       MOVE 'C2U'           TO WS-SORT-GRP-ORD-CD       
                     WHEN OTHER                                         
                       MOVE SPACES          TO WS-SORT-GRP-ORD-CD       
                 END-EVALUATE                                           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-SORT-GRP-CD     = SPACES OR                            
              WS-SORT-GRP-ORD-CD = SPACES                               
              SET SKIP-ACCOUNT              TO TRUE                     
           END-IF.                                                      
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  1200-POPULATE-DETAILS.                                    **          
      **      POPULATE THE EXTRACT FILE WITH THE RETREIVED VALUES   **          
      ****************************************************************          
      *                                                                         
       1200-POPULATE-DETAILS.                                           
      *                                                                         
           INITIALIZE                          E-FCA162-DATA-REC.       
           MOVE WS-HLD-ACCOUNT-NO           TO E-FCA162-ACCOUNT-NO.     
           MOVE WS-HLD-OPT-CD               TO E-FCA162-OPTION-CODE.    
           MOVE WS-HLD-OPT-CD-DSC           TO E-FCA162-OPT-DESC.       
           MOVE WS-SORT-GRP-CD              TO E-FCA162-SORT-GRP-CD.    
           MOVE WS-SORT-GRP-ORD-CD          TO E-FCA162-SORT-GRP-ORD-CD.
           PERFORM 8000-WRITE-RECORD        THRU 8000-EXIT.             
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7000-OPEN-ACCOUNT                                         **          
      **      OPEN THE MAIN CURSOR ACCOUNT_CUR                      **          
      ****************************************************************          
      *                                                                         
       7000-OPEN-ACCOUNT.                                               
      *                                                                         
           EXEC SQL                                                     
               OPEN ACCOUNT_CUR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '       OPEN ACCOUNT_CUR '                       
               DISPLAY '       7000-OPEN-ACCOUNT '                      
               DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY ' ACCOUNT NO     = ' DF-ACCOUNT-NO               
               DISPLAY ' REVENUE MONTH  = ' DF-STATUS-EFF-REV-MTH       
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7010-FETCH-ACCOUNT                                        **          
      **      FETCH THE ACCOUNTS FOR PROCESSING                     **          
      ****************************************************************          
      *                                                                         
       7010-FETCH-ACCOUNT.                                              
      *                                                                         
           EXEC SQL                                                     
               FETCH ACCOUNT_CUR                                        
                INTO :DF-ACCOUNT-NO                                     
                    ,:DF-CODE-UTIL-TYPE                                 
                    ,:DF-IC-NO                                          
                    ,:DF-RT-PKG-OPT-SEQ-NO                              
                    ,:DF-AGREEMNT-SOURCE-CD                             
                    ,:FI-OPTION-CD                                      
                    ,:FI-OPT-DESC-INT                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 SET WS-END-ACCOUNT-CUR TO TRUE                         
              ELSE                                                      
                 DISPLAY '*******************************************'  
                 DISPLAY '       ABENDING PROGRAM '                     
                 DISPLAY '       FETCH ACCOUNT_CUR '                    
                 DISPLAY '       7010-FETCH-ACCOUNT '                   
                 DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE     
                 DISPLAY ' ACCOUNT NO     = ' DF-ACCOUNT-NO             
                 DISPLAY '*******************************************'  
                 PERFORM 9900-ABEND      THRU 9900-EXIT                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7020-CLOSE-ACCOUNT                                        **          
      **      CLOSE THE MAIN CURSOR ACCOUNT_CUR                     **          
      ****************************************************************          
      *                                                                         
       7020-CLOSE-ACCOUNT.                                              
      *                                                                         
           EXEC SQL                                                     
               CLOSE ACCOUNT_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '*******************************************'     
              DISPLAY '       ABENDING PROGRAM '                        
              DISPLAY '      CLOSE ACCOUNT_CUR '                        
              DISPLAY '      7020-CLOSE-ACCOUNT '                       
              DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND       THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7100-VERIFY-PRV-RTPK-AGR.                                   **        
      **  CHECK WHETHER ACCOUNT HAS A RATE CHANGE                     **        
      ******************************************************************        
      *                                                                         
       7100-VERIFY-PRV-RTPK-AGR.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT RD.MKT_PROGRAM_CD                                  
                INTO :RD-MKT-PROGRAM-CD                                 
                FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                 
                    ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                 
                    ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                
               WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO             
                 AND DF.CODE_UTIL_TYPE     = :DF-CODE-UTIL-TYPE         
                 AND DF.IC_NO              = :DF-IC-NO                  
                 AND DF.RT_PKG_OPT_SEQ_NO  =                            
                   (SELECT MAX(D1.RT_PKG_OPT_SEQ_NO)                    
                      FROM CSS_ACCT_RTPK_AGR D1 WITH(READUNCOMMITTED)           
                     WHERE D1.ACCOUNT_NO        = DF.ACCOUNT_NO         
                       AND D1.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE     
                       AND D1.IC_NO             = DF.IC_NO              
                       AND D1.RT_PKG_OPT_SEQ_NO < :DF-RT-PKG-OPT-SEQ-NO 
                       AND D1.STATUS_CD         <> 'C')                 
                 AND FI.OPTION_CD          = DF.OPTION_CD               
                 AND FI.COMPANY_NO         = '01'                       
P00473           AND FI.OPT_VSTART_TS     <= CIS.CURRENT$TIMESTAMP()          
P00473           AND FI.OPT_VEND_TS       >= CIS.CURRENT$TIMESTAMP()          
P00473           AND FI.PROC_STATUS_CD     = 'AC'                       
                 AND RD.CODE_UTIL_TYPE     = DF.CODE_UTIL_TYPE          
                 AND RD.RATE_PLAN_NO       = FI.RATE_PLAN_NO            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RD.MKT_PROGRAM_CD                                          
MFA-TR*         INTO :RD-MKT-PROGRAM-CD                                         
MFA-TR*         FROM CSS_ACCT_RTPK_AGR DF                                       
MFA-TR*             ,CRM_RT_PKG_OPTION FI                                       
MFA-TR*             ,CSS_RATE_PLAN_DESC RD                                      
MFA-TR*        WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO                     
MFA-TR*          AND DF.CODE_UTIL_TYPE     = :DF-CODE-UTIL-TYPE                 
MFA-TR*          AND DF.IC_NO              = :DF-IC-NO                          
MFA-TR*          AND DF.RT_PKG_OPT_SEQ_NO  =                                    
MFA-TR*            (SELECT MAX(D1.RT_PKG_OPT_SEQ_NO)                            
MFA-TR*               FROM CSS_ACCT_RTPK_AGR D1                                 
MFA-TR*              WHERE D1.ACCOUNT_NO        = DF.ACCOUNT_NO                 
MFA-TR*                AND D1.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE             
MFA-TR*                AND D1.IC_NO             = DF.IC_NO                      
MFA-TR*                AND D1.RT_PKG_OPT_SEQ_NO < :DF-RT-PKG-OPT-SEQ-NO         
MFA-TR*                AND D1.STATUS_CD         <> 'C')                         
MFA-TR*          AND FI.OPTION_CD          = DF.OPTION_CD                       
MFA-TR*          AND FI.COMPANY_NO         = '01'                               
MFA-TR*          AND FI.OPT_VSTART_TS     <= CURRENT TIMESTAMP                  
MFA-TR*          AND FI.OPT_VEND_TS       >= CURRENT TIMESTAMP                  
MFA-TR*          AND FI.PROC_STATUS_CD     = 'AC'                               
MFA-TR*          AND RD.CODE_UTIL_TYPE     = DF.CODE_UTIL_TYPE                  
MFA-TR*          AND RD.RATE_PLAN_NO       = FI.RATE_PLAN_NO                    
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                  SET WS-PRV-RTPK-AGR      TO TRUE                      
               WHEN NOT-FOUND                                           
                  SET WS-NO-PRV-RTPK-AGR   TO TRUE                      
               WHEN OTHER                                               
                  DISPLAY '******************************************'  
                  DISPLAY '** PROCESSING ERROR IN PROGRAM PCSCA162 **'  
                  DISPLAY '**    PARA 7100-VERIFY-PRV-RTPK-AGR     **'  
                  DISPLAY '**             RC =' WS-ACTIVE-RETURN-CODE   
                  DISPLAY '**        PROCESSING TERMINATED         **'  
                  DISPLAY '******************************************'  
                  PERFORM 9900-ABEND           THRU 9900-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7600-START-FCSJC01                                       **         
      *****************************************************************         
      *                                                                         
            EXEC SQL                                                            
              INCLUDE CPD00038                                                  
            END-EXEC.                                                           
      *                                                                         
      *****************************************************************         
      **  8000-WRITE-RECORD.                                         **         
      **  WRITE OUTPUT FILE.                                         **         
      *****************************************************************         
      *                                                                         
       8000-WRITE-RECORD.                                               
      *                                                                         
           WRITE FCSCA162.                                              
                                                                        
           IF WS-FCA162-STATUS = '00'                                   
              ADD +1                   TO WS-CA162-RECS-WRITE           
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  8100-WRITE-RECORD.                                         **         
      **  WRITE OUTPUT GRPMVMNT FILE                                 **         
      *****************************************************************         
      *                                                                         
       8100-WRITE-RECORD.                                               
      *                                                                         
           WRITE GRPMVMNT.                                              
                                                                        
           IF WS-GRPMNT-STATUS = '00'                                   
              ADD +1                   TO WS-GRPMNT-RECS-WRITE          
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  9000-TERMINATE.                                             **        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSCA162-FILE                                          
                 GRPMVMNT-FILE.                                         
                                                                        
           DISPLAY '*******************************************'.       
           DISPLAY '           PCSCA162 ENDING '.                       
           DISPLAY '*******************************************'.       
           DISPLAY '           PROGRAM SUMMARY'.                        
           DISPLAY '*******************************************'.       
           DISPLAY ' ACCTS FOR FCSCA162 : ' WS-CA162-RECS-WRITE.        
           DISPLAY ' ACCTS FOR GRPMVMNT : ' WS-GRPMNT-RECS-WRITE.       
           DISPLAY '*******************************************'.       
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  9900-ABEND INCLUDES SQL ROLLBACK                          **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
      ***********************END OF PROGRAM***************************          
