       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   PCSCA155.                                          
       AUTHOR.       SIDDHARTHA SARKAR (COVANSYS).                      
       DATE-WRITTEN. JAN 2008.                                          
       DATE-COMPILED.                                                   
      ******************************************************************        
      **                       SCANA ENERGY                           **        
      **          NON-STANDARD RATE REPORT EXTRACT PROGRAM            **        
      **                        COBOL-DB2                             **        
      ******************************************************************        
      **                     PROGRAM SUMMARY                          **        
      ******************************************************************        
      **   THIS PROGRAM CREATES A EXTRACT FILE TO GENERATE THE 729/751**        
      **   NON-STANDARD RATE REPORTS. THIS IS THE MODIFIED DESIGN OF  **        
      **   EZTRIEVE SEB729 TO ACCOMODATE THE NEW RATE STRUCTURE IN    **        
      **   THE SEB RATE RE-ENGINEERING PROJECT.                       **        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     INPUT PROCESSING CONTROL PATH         **        
      **        2000 - 2999     OUTPUT PROCESS CONTROL PATH           **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     COMMON SYSTEM MODULES                 **        
      **        7000 - 7999     INPUT MODULES                         **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      **                PROGRAM  MODIFICATION  LOG                    **        
      ******************************************************************        
      ** DATE     USER ID  REASON                                     **        
      ** -------  -------  ------                                     **        
      ** 01/2008  SS97726  INITIAL IMPLEMENTATION.                    **        
PRDFIX** 07/2008  SS97726  FIX ANNV MONTH LOGIC                       **        
P00141** 04/2009  SS97726  ADD START/END DATE TO OPT_ATTR_INCTV       **        
      **                                                              **        
A01673** 17 SEP 09 RF10596 ADD CSC FACTGOR TO OUTPUT FILE             **        
P00211** 11/2009  VY95550  TREAT INTRO/PROMOTIONAL OPTIONS AS SAME AS **        
P00211**                   VP - VARIABLE PRICE OPTIONS                **        
A02842** 29 OCT 10 GD97441 1.USE "VARPRICE" FACTOR AS THERM PRICE FOR **        
A02842**                     VARIABLE RATES.                          **        
A02842**                   2.HARDCODED IC = 1 CHECK WAS REMOVED.      **        
A02842**                   3.REMOVED 7100- PARA & ADDED ACCT_RTPK_AGR,**        
A02842**                     RT_PKG_OPTION TABLES TO MAIN CURSOR.     **        
A02842**                   4.ABEND HANDLING HAS BEEN UPDATED.         **        
A02842**                   5.MERGED 7410 / 7510 PARA SQL STATEMENTS   **        
A02842**                   6.SKIP/DONT-SKIP HANDLING WAS REMOVED.     **        
A02842**                   7.ADDED QUERYNO TO ALL THE SQL STATEMENTS. **        
A03303** 05 MAY 11 SV95326 FIXED FACTOR PRECISION CHANGES FROM 4 TO   **        
A03303**                   6 DECIMAL POINTS FOR INDUSTRIAL BILLING.   **        
P00473** 12 MAY 11 SB93596 CHGS INCLUDED TO PULL APPROVED             **        
P00473**                   OPT ATTR INCTV/OPTION RECORDS.             **        
A04019** 29 MAY 12 VIJAY   SEB CSC CHANGES                            **        
P00680** 17 JUL 12 SS97726 CUSTOMER RETENTION AND ACQUISITION.        **        
ACT128** 10 AUG 13 DB41297 OPTIMIZE PROGRAM.                          **        
A04527** 18 DEC 13 MS93554 1.GET PRICE DISCOUNT & CSC DISCOUNT DETAILS**        
A04527**           ACT-245   AND ADD INTO FIOCA155 FILE.              **        
A04527**                   2.ADDED THE COMMONDATE LOGIC.              **        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT FCSCA155-FILE                                         
               ASSIGN TO UT-S-FCSCA155                                  
               FILE STATUS IS WS-FCA155-STATUS.                         
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD  FCSCA155-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
A04527     RECORD CONTAINS 155 CHARACTERS                               
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
      *                                                                         
      ****************************************************************          
      *        RECORD DESCRIPTION FOR OUTPUT FILE FCSCA155           *          
      ****************************************************************          
      *                                                                         
       01  FIOCA155.                                                    
         02  E-FCA155-DATA-REC.                                         
           05  E-FCA155-OPTION-CODE        PIC X(12).                   
           05  E-FCA155-ACCT-STAT-CODE     PIC X(01).                   
           05  E-FCA155-THERM-PRICE        PIC 9(05)V9(06).             
           05  E-FCA155-ACCOUNT-NO         PIC 9(13).                   
           05  E-FCA155-ANNV-MONTH         PIC X(06).                   
A04527     05  E-FCA155-TIER-ACCT-TYPE-CD  PIC X(01).                   
           05  E-FCS155-RATE-TYP-FLAG      PIC X(01).                   
           05  E-FCA155-CORE-RT-PLAN       PIC X(03).                   
           05  E-FCA155-OPT-DESC           PIC X(50).                   
A01673     05  E-FCA155-CSC-AMT            PIC 999.9999.                
A01673     05  E-FCA155-REAL-ACCT-TYP-CODE PIC X.                       
A04527     05  E-FCA155-THRM-PRC-DSCNT     PIC S9(05)V9(06) VALUE 0.    
A04527     05  E-FCA155-NET-THRM-PRC       PIC S9(05)V9(06) VALUE 0.    
A04527     05  E-FCA155-CSC-DSCNT          PIC S9(05)V9(06) VALUE 0.    
A04527     05  E-FCA155-NET-CSC            PIC S9(05)V9(06) VALUE 0.    
A04527     05  E-DURATION-NO               PIC S9(04) VALUE 0.          
      *                                                                         
      ****************************************************************          
      *                      END OF LAYOUT                           *          
      ****************************************************************          
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA155'.
MSQ017     COPY MFASQLM.
       01  WS-START                        PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSCA155 STARTS HERE'.            
                                                                        
       01  WS-WORK-VARIABLES.                                           
A02842     05  WS-THERM-PRICE              PIC 9(05)V9(06) VALUE 0.     
A04527     05  WS-CSC-AMT                  PIC 9(05)V9(06).             
           05  WS-PRIOR-PND-DATE           PIC X(10)  VALUE SPACES.     
           05  WS-PRIOR-FNL-DATE           PIC X(10)  VALUE SPACES.     
           05  WS-HOLD-REV-MNTH            PIC 9(6)   VALUE ZEROS.      
           05  WS-RESULT-DT.                                            
               10 WS-RESULT-DT-YYYY        PIC X(4)   VALUE SPACES.     
               10 WS-RESULT-DT-MM          PIC X(2)   VALUE SPACES.     
           05  WS-DUMMY-DATE.                                           
               10 WS-DUMMY-DT-YYYY         PIC X(4)   VALUE SPACES.     
               10 WS-DUMMY-DT-F1           PIC X(1)   VALUE '-'.        
               10 WS-DUMMY-DT-MM           PIC X(2)   VALUE SPACES.     
               10 WS-DUMMY-DT-F2           PIC X(1)   VALUE '-'.        
               10 WS-DUMMY-DT-DD           PIC X(2)   VALUE SPACES.     
           05  WS-HOLD-REV-MNTH-RED.                                    
               10 WS-HOLD-REV-MNTH-YR      PIC X(4)   VALUE ZEROS.      
               10 WS-HOLD-REV-MNTH-MM      PIC X(2)   VALUE ZEROS.      
           05  WS-COMMON-REV-MNTH          PIC 9(6)   VALUE ZEROS.      
           05  WS-NULL-IND-FF              PIC S9(4)  COMP VALUE 0.     
A01673     05  WS-NULL-IND-01              PIC S9(4)  COMP VALUE 0.     
A03303     05  WS-FACTOR-FF                PIC S9(09)V9(06)             
A03303                                     USAGE COMP-3 VALUE 0.        
A04527     05  WS-NET-THERM-PRICE          PIC S9(05)V9(06).            
A04527     05  WS-NET-CSC                  PIC S9(05)V9(06).            
A04527     05  WS-TOT-THRM-PRC-DSCNT       PIC S9(05)V9(06).            
A04527     05  WS-TOT-CSC-DSCNT            PIC S9(05)V9(06).            
A04527     05  WS-COMMON-DATE              PIC X(10).                   
      *                                                                         
       01  WS-HOLD-DURATION-REM            PIC S9(4)  USAGE COMP.       
       01  WS-RESULT-DATE                  PIC X(10)  VALUE SPACES.     
       01  WS-DUMMY-DATE-TEMP              PIC X(10)  VALUE SPACES.     
                                                                        
       01  WS-COUNTERS.                                                 
           05  WS-CA155-RECS-WRITE         PIC 9(7)   VALUE ZEROS.      
                                                                        
       01  WS-811                          PIC S9(4)  COMP VALUE -811.  
       01  WS-DAYS                         PIC 9(04)  VALUE ZEROS.      
       01  WS-P-DAYS                       PIC S9(4)  COMP VALUE +0.    
       01  WS-F-DAYS                       PIC S9(4)  COMP VALUE +0.    
A04019 01  WS-CSC-AMT-DESC                 PIC $Z9.99 .                 
A04019 01  WS-CSC-LIT-DESC                 PIC X(04)  VALUE ' CSC'.     
A04527 01  WS-Y                            PIC X(01)  VALUE 'Y'.        
A04527 01  WS-N                            PIC X(01)  VALUE 'N'.        
                                                                        
       01  WS-FCA155-STATUS                PIC X(2)   VALUE '00'.       
                                                                        
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE              PIC S9(04) COMP VALUE 0.     
           05  RS-RETURN-CODE-DISP         PIC +Z(04).                  
                                                                        
       01  WS-CONSTANTS.                                                
           05  WS-PGRMNAME                 PIC X(8)   VALUE 'PCSCA155'. 
           05  PROGRAM-NAME                PIC X(8)   VALUE 'PCSCA155'. 
ACT128                                                                  
ACT128 01  WS-INCTV-TABLE.                                              
ACT128     05 WS-INCTV-CNT                  PIC S9(5) COMP-3 VALUE +0.  
ACT128     05 WS-FACTOR-CNT                 PIC S9(5) COMP-3 VALUE +0.  
ACT128     05 WS-RATE-CNT                   PIC S9(5) COMP-3 VALUE +0.  
ACT128     05 WS-SPCL-CNT                   PIC S9(5) COMP-3 VALUE +0.  
ACT128     05 WS-FACTOR-ID-HOLD             PIC X(10).                  
ACT128     05 WS-OPTION-CD-HOLD             PIC X(12).                  
A04527     05 WS-DURATION-NO-HOLD           PIC S9(4) COMP VALUE 0.     
ACT128     05 WS-INCTV-TBL OCCURS 0 TO 9999 DEPENDING ON WS-INCTV-CNT   
ACT128                    ASCENDING KEY WS-OPTION-CD                    
ACT128                    INDEXED BY INCTV-IND.                         
ACT128        10 WS-OPTION-CD               PIC X(12).                  
ACT128        10 WS-FACTOR-ID               PIC X(10).                  
A04527        10 WS-DURATION-NO             PIC S9(04).                 
ACT128                                                                  
ACT128 01  WS-FACTOR-TABLE.                                             
ACT128     05 WS-RATE-PLAN-HOLD             PIC X(3).                   
COB305     05 WS-FACTOR-HOLD        PIC S9(3)V9(6) USAGE COMP-3 VALUE 0.
ACT128     05 WS-FACTOR-TBL OCCURS 0 TO 9999 DEPENDING ON WS-FACTOR-CNT 
ACT128                    ASCENDING KEY WS-RATE-PLAN                    
ACT128                    INDEXED BY FACTOR-IND.                        
ACT128        10 WS-RATE-PLAN               PIC X(3).                   
COB305        10 WS-FACTOR        PIC S9(3)V9(6) USAGE COMP-3 VALUE 0.
ACT128                                                                  
ACT128 01  WS-RATE-TABLE.                                               
ACT128     05 WS-RATE-TBL OCCURS 0 TO 9999 DEPENDING ON WS-RATE-CNT     
ACT128                    ASCENDING KEY WS-RATE-PLAN-NO                 
ACT128                    INDEXED BY RATE-IND.                          
ACT128        10 WS-RATE-PLAN-NO            PIC X(3).                   
COB305        10 WS-FACTOR-NO        PIC S9(3)V9(6) USAGE COMP-3 
COB305           VALUE 0.
ACT128                                                                  
ACT128 01  WS-SPCL-TABLE.                                               
ACT128     05 CM-SPCL-KEY.                                              
ACT128        10 CM-SPCL-ID                 PIC X(10).                  
ACT128        10 CM-SPCL-GROUP              PIC X(02).                  
ACT128     05 WS-FCTR-POWER-HOLD            PIC S9(4) USAGE COMP.       
ACT128     05 WS-SPCL-TBL OCCURS 0 TO 9999 DEPENDING ON WS-SPCL-CNT     
ACT128                    ASCENDING KEY WS-SPCL-ID                      
ACT128                    INDEXED BY SPCL-IND.                          
ACT128        10 WS-SPCL-ID                 PIC X(10).                  
ACT128        10 WS-SPCL-GROUP              PIC X(02).                  
ACT128        10 WS-FCTR-POWER-10           PIC S9(4) USAGE COMP.       
      *                                                                         
      ******************************************************************        
      **                                                              **        
      ** WORKING STORAGE COPY BOOKS FOLLOW ALL PROGRAM WS             **        
      **                                                              **        
      ******************************************************************        
      ******   SQL WORK VARIABLES.                                              
       COPY CWS00303.                                                           
                                                                        
      ******   WS AREA FOR ABEND SWITCH.                                        
       COPY CWS09900.                                                           
                                                                        
      ******   WS AREA FOR ABEND WORK.                                          
       COPY CWS00010.                                                           
                                                                        
      ******   WS AREA FOR MISC. INPUT.                                         
       COPY CWS00038.                                                           
                                                                        
       01  WS-END                          PIC X(40)                    
           VALUE 'DB2 INCLUDES FOR PCSCA155 START HERE '.               
      ******************************************************************        
      **                                                              **        
      **  TABLE DECLARATIONS GO AFTER OTHER WORKING STORAGE ITEMS     **        
      **  (IF DIRECT ACCESS TO DB2 TABLES IS ALLOWED). FIRST ITEM     **        
      **  WILL ALWAYS BE SQLCA.                                       **        
      **                                                              **        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      * IO AREA FOR PARM INPUT FILE 'A'                                         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE FIOJC01                                                   
           END-EXEC.                                                            
      *                                                                         
A04527     EXEC SQL                                                             
A04527        INCLUDE FIOCA00                                                   
A04527     END-EXEC.                                                            
      *                                                                         
      * FCA00 MISC INPUT                                                        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00039                                                  
           END-EXEC.                                                            
      *                                                                         
      * CSS_JOB_PARM DCLGEN                                                     
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      * CSS_ACCOUNT DCLGEN                                                      
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      * CSS_ACCT_MKT_TIER DCLGEN                                                
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMKTIER                                                 
           END-EXEC.                                                            
      *                                                                         
      * CSS_ACCT_RTPK_AGR DCLGEN                                                
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCTRG                                                 
           END-EXEC.                                                            
      *                                                                         
      * CRM_RT_PKG_OPTION DCLGEN                                                
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRTPKGO                                                 
           END-EXEC.                                                            
      *                                                                         
      * CRM_OPT_ATTR_INCTV DCLGEN                                               
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBOPTATT                                                 
           END-EXEC.                                                            
      *                                                                         
      * CSS_UTIL_ENVRNMT DCLGEN                                                 
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
      * CSS_FIXED_FCTR DCLGEN                                                   
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBFXDFCT                                                 
           END-EXEC.                                                            
      *                                                              *          
      ****************************************************************          
      * CSS_SPCL_FCTR_APPL DCLGEN - SA                               *          
      ****************************************************************          
      *                                                              *          
           EXEC SQL                                                             
               INCLUDE TBSPLAPL                                                 
           END-EXEC.                                                            
      *                                                              *          
      ****************************************************************          
      * CSS_SPCL_FCTR DCLGEN - SF                                    *          
      ****************************************************************          
      *                                                              *          
           EXEC SQL                                                             
               INCLUDE TBSPLFTR                                                 
           END-EXEC.                                                            
      *                                                              *          
      ****************************************************************          
      * CSS_RATE_CREATOR DCLGEN - RT                                 *          
      ****************************************************************          
      *                                                              *          
           EXEC SQL                                                             
               INCLUDE TBRTCRTR                                                 
           END-EXEC.                                                            
      *                                                              *          
      ****************************************************************          
      * CSS_RATE_VRSN_DEF DCLGEN - J4                                *          
      ****************************************************************          
      *                                                              *          
           EXEC SQL                                                             
               INCLUDE TBRTVRSN                                                 
           END-EXEC.                                                            
      *                                                              *          
      ******************************************************************        
      **                                                              **        
      **  CURSOR DECLARATIONS (IF ANY) GO LAST                        **        
      **                                                              **        
      ******************************************************************        
      **BASE CURSOR TO EXTRACT THE OPTION CODE FOR THE SEB ACCOUNTS             
           EXEC SQL                                                     
              DECLARE ACCOUNT_CUR CURSOR FOR                            
               SELECT AT.ACCOUNT_NO                                     
                     ,AT.CODE_ACCT_STAT                                 
                     ,AT.REV_MTH_LST_NRML                               
                     ,UT.RATE_PLAN_NO                                   
                     ,UT.IC_NO                                          
                     ,UT.RT_PKG_OPT_SEQ_NO                              
A02842               ,DF.OPTION_CD                                      
A02842               ,FI.OPT_CALC_TYPE_CD                               
A02842               ,FI.OPT_DESC_INT                                   
                     ,DD.TIER_ACCT_TYPE_CD                              
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                     ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
A02842               ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                
A02842               ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                
                     ,CSS_ACCT_MKT_TIER DD WITH(READUNCOMMITTED)                
                WHERE AT.ACCOUNT_NO       = UT.ACCOUNT_NO               
                  AND (AT.CODE_ACCT_STAT  = 'A'                   OR    
                      (AT.CODE_ACCT_STAT  = 'P' AND                     
                       CAST(AT.ACCT_CREATE_DT AS DATE)  > 
              IIF(TRY_CONVERT(DATE, :WS-PRIOR-PND-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PRIOR-PND-DATE
              ) <> 0) OR (LEN(:WS-PRIOR-PND-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-PRIOR-PND-DATE
              ), CONVERT(DATE, :WS-PRIOR-PND-DATE) )) OR
                      (AT.CODE_ACCT_STAT  = 'B' AND                     
                       CAST(AT.ACCT_FINALED_DT AS DATE) > 
              IIF(TRY_CONVERT(DATE, :WS-PRIOR-FNL-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PRIOR-FNL-DATE
              ) <> 0) OR (LEN(:WS-PRIOR-FNL-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-PRIOR-FNL-DATE
              ), CONVERT(DATE, :WS-PRIOR-FNL-DATE) )))  
                  AND UT.CODE_UTIL_TYPE   = 'G'                         
A02842            AND DF.ACCOUNT_NO         =  UT.ACCOUNT_NO            
A02842            AND DF.CODE_UTIL_TYPE     =  UT.CODE_UTIL_TYPE        
A02842            AND DF.IC_NO              =  UT.IC_NO                 
A02842            AND DF.RT_PKG_OPT_SEQ_NO  =  UT.RT_PKG_OPT_SEQ_NO     
A02842            AND FI.OPTION_CD          =  DF.OPTION_CD             
A02842            AND FI.CODE_UTIL_TYPE     =  DF.CODE_UTIL_TYPE        
A02842            AND FI.COMPANY_NO         =  '01'                     
P00473            AND FI.OPT_VSTART_TS   <= CIS.CURRENT$TIMESTAMP()           
P00473            AND FI.OPT_VEND_TS     >= CIS.CURRENT$TIMESTAMP()           
P00473            AND FI.PROC_STATUS_CD   = 'AC'                        
                  AND DD.ACCOUNT_NO       = AT.ACCOUNT_NO               
                  AND DD.TIER_ACCT_TYPE_CD NOT IN ('L','I')             
                  AND DD.EFF_START_DT =                                 
                         (SELECT MAX(D1.EFF_START_DT)                   
                            FROM CSS_ACCT_MKT_TIER D1
                           WITH(READUNCOMMITTED)                   
                           WHERE D1.ACCOUNT_NO = AT.ACCOUNT_NO)         
                  ORDER BY AT.ACCOUNT_NO                                
                  FOR READ ONLY                                 
A02842                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ACCOUNT_CUR CURSOR FOR                                    
MFA-TR*        SELECT AT.ACCOUNT_NO                                             
MFA-TR*              ,AT.CODE_ACCT_STAT                                         
MFA-TR*              ,AT.REV_MTH_LST_NRML                                       
MFA-TR*              ,UT.RATE_PLAN_NO                                           
MFA-TR*              ,UT.IC_NO                                                  
MFA-TR*              ,UT.RT_PKG_OPT_SEQ_NO                                      
MFA-TR*              ,DF.OPTION_CD                                              
MFA-TR*              ,FI.OPT_CALC_TYPE_CD                                       
MFA-TR*              ,FI.OPT_DESC_INT                                           
MFA-TR*              ,DD.TIER_ACCT_TYPE_CD                                      
MFA-TR*          FROM CSS_ACCOUNT AT                                            
MFA-TR*              ,CSS_UTIL_ENVRNMT UT                                       
MFA-TR*              ,CSS_ACCT_RTPK_AGR DF                                      
MFA-TR*              ,CRM_RT_PKG_OPTION FI                                      
MFA-TR*              ,CSS_ACCT_MKT_TIER DD                                      
MFA-TR*         WHERE AT.ACCOUNT_NO       = UT.ACCOUNT_NO                       
MFA-TR*           AND (AT.CODE_ACCT_STAT  = 'A'                   OR            
MFA-TR*               (AT.CODE_ACCT_STAT  = 'P' AND                             
MFA-TR*                DATE(AT.ACCT_CREATE_DT)  > :WS-PRIOR-PND-DATE) OR        
MFA-TR*               (AT.CODE_ACCT_STAT  = 'B' AND                             
MFA-TR*                DATE(AT.ACCT_FINALED_DT) > :WS-PRIOR-FNL-DATE))          
MFA-TR*           AND UT.CODE_UTIL_TYPE   = 'G'                                 
MFA-TR*           AND DF.ACCOUNT_NO         =  UT.ACCOUNT_NO                    
MFA-TR*           AND DF.CODE_UTIL_TYPE     =  UT.CODE_UTIL_TYPE                
MFA-TR*           AND DF.IC_NO              =  UT.IC_NO                         
MFA-TR*           AND DF.RT_PKG_OPT_SEQ_NO  =  UT.RT_PKG_OPT_SEQ_NO             
MFA-TR*           AND FI.OPTION_CD          =  DF.OPTION_CD                     
MFA-TR*           AND FI.CODE_UTIL_TYPE     =  DF.CODE_UTIL_TYPE                
MFA-TR*           AND FI.COMPANY_NO         =  '01'                             
MFA-TR*           AND FI.OPT_VSTART_TS   <= CURRENT TIMESTAMP                   
MFA-TR*           AND FI.OPT_VEND_TS     >= CURRENT TIMESTAMP                   
MFA-TR*           AND FI.PROC_STATUS_CD   = 'AC'                                
MFA-TR*           AND DD.ACCOUNT_NO       = AT.ACCOUNT_NO                       
MFA-TR*           AND DD.TIER_ACCT_TYPE_CD NOT IN ('L','I')                     
MFA-TR*           AND DD.EFF_START_DT =                                         
MFA-TR*                  (SELECT MAX(D1.EFF_START_DT)                           
MFA-TR*                     FROM CSS_ACCT_MKT_TIER D1                           
MFA-TR*                    WHERE D1.ACCOUNT_NO = AT.ACCOUNT_NO)                 
MFA-TR*           ORDER BY AT.ACCOUNT_NO                                        
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            
ACT128                                                                  
ACT128     EXEC SQL                                                     
ACT128        DECLARE INCTV_CUR CURSOR FOR                              
ACT128        SELECT FACTOR_ID                                          
ACT128              ,OPTION_CD                                          
A04527              ,DURATION_NO                                        
ACT128          FROM CRM_OPT_ATTR_INCTV WITH(READUNCOMMITTED)                   
ACT128         WHERE RT_ATTR_INCTV_TYPE  = 'FIXED PRICE'                
ACT128           AND ATTR_INCTV_STRT_DT <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                 
ACT128           AND ATTR_INCTV_END_DT  >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                 
ACT128           AND OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()            
ACT128           AND OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()            
ACT128           AND PROC_STATUS_CD      = 'AC'                         
ACT128         ORDER BY OPTION_CD                                       
ACT128            FOR READ ONLY                                 
ACT128                                                      
ACT128     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE INCTV_CUR CURSOR FOR                                      
MFA-TR*       SELECT FACTOR_ID                                                  
MFA-TR*             ,OPTION_CD                                                  
MFA-TR*             ,DURATION_NO                                                
MFA-TR*         FROM CRM_OPT_ATTR_INCTV                                         
MFA-TR*        WHERE RT_ATTR_INCTV_TYPE  = 'FIXED PRICE'                        
MFA-TR*          AND ATTR_INCTV_STRT_DT <= CURRENT DATE                         
MFA-TR*          AND ATTR_INCTV_END_DT  >= CURRENT DATE                         
MFA-TR*          AND OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP                    
MFA-TR*          AND OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP                    
MFA-TR*          AND PROC_STATUS_CD      = 'AC'                                 
MFA-TR*        ORDER BY OPTION_CD                                               
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            
ACT128                                                                  
ACT128     EXEC SQL                                                     
ACT128        DECLARE FACTOR_CUR CURSOR FOR                             
ACT128         SELECT SA.FACTOR                                         
ACT128               ,SA.RATE_PLAN_NO                                   
ACT128           FROM CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)               
ACT128               ,CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)               
ACT128          WHERE SA.CODE_UTIL_TYPE = 'G'                           
ACT128            AND SA.FACTOR_ID      = SF.FACTOR_ID                  
ACT128            AND SF.FACTOR_TYPE    IN ('A')                        
ACT128            AND SA.CODE_STATUS    IN ('A')                        
ACT128            AND SF.ADJUST_ELEMENT =  ('N')                        
ACT128            AND SA.DATE_FROM      <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                 
ACT128            AND SA.DATE_TO        >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                 
ACT128         ORDER BY SA.RATE_PLAN_NO                                 
ACT128         FOR READ ONLY                                    
ACT128                                                      
ACT128     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE FACTOR_CUR CURSOR FOR                                     
MFA-TR*        SELECT SA.FACTOR                                                 
MFA-TR*              ,SA.RATE_PLAN_NO                                           
MFA-TR*          FROM CSS_SPCL_FCTR_APPL SA                                     
MFA-TR*              ,CSS_SPCL_FCTR      SF                                     
MFA-TR*         WHERE SA.CODE_UTIL_TYPE = 'G'                                   
MFA-TR*           AND SA.FACTOR_ID      = SF.FACTOR_ID                          
MFA-TR*           AND SF.FACTOR_TYPE    IN ('A')                                
MFA-TR*           AND SA.CODE_STATUS    IN ('A')                                
MFA-TR*           AND SF.ADJUST_ELEMENT =  ('N')                                
MFA-TR*           AND SA.DATE_FROM      <= CURRENT DATE                         
MFA-TR*           AND SA.DATE_TO        >= CURRENT DATE                         
MFA-TR*        ORDER BY SA.RATE_PLAN_NO                                         
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7320                                                     
MFA-TR*    END-EXEC.                                                            
ACT128                                                                  
ACT128     EXEC SQL                                                     
ACT128        DECLARE RATE_CUR CURSOR FOR                               
ACT128        SELECT  SA.FACTOR                                         
ACT128               ,SA.RATE_PLAN_NO                                   
ACT128          FROM  CSS_SPCL_FCTR_APPL  SA WITH(READUNCOMMITTED)              
ACT128               ,CSS_SPCL_FCTR       SF WITH(READUNCOMMITTED)              
ACT128         WHERE  SA.FACTOR_ID         =  SF.FACTOR_ID              
ACT128           AND  SA.FACTOR_ID         =  'VARPRICE'                
ACT128           AND  SA.CODE_UTIL_TYPE    =  'G'                       
ACT128           AND  SA.CODE_STATUS       =  'A'                       
ACT128           AND  SF.FACTOR_TYPE       =  'A'                       
ACT128           AND  SF.ADJUST_ELEMENT    =  'C'                       
ACT128           AND  SA.INT_DISP_START_TS <= CIS.CURRENT$TIMESTAMP()         
ACT128           AND  SA.DATE_FROM         <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
ACT128           AND  SA.DATE_TO           >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
ACT128          ORDER BY SA.RATE_PLAN_NO                                
ACT128         FOR READ ONLY                                    
ACT128                                                      
ACT128     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE RATE_CUR CURSOR FOR                                       
MFA-TR*       SELECT  SA.FACTOR                                                 
MFA-TR*              ,SA.RATE_PLAN_NO                                           
MFA-TR*         FROM  CSS_SPCL_FCTR_APPL  SA                                    
MFA-TR*              ,CSS_SPCL_FCTR       SF                                    
MFA-TR*        WHERE  SA.FACTOR_ID         =  SF.FACTOR_ID                      
MFA-TR*          AND  SA.FACTOR_ID         =  'VARPRICE'                        
MFA-TR*          AND  SA.CODE_UTIL_TYPE    =  'G'                               
MFA-TR*          AND  SA.CODE_STATUS       =  'A'                               
MFA-TR*          AND  SF.FACTOR_TYPE       =  'A'                               
MFA-TR*          AND  SF.ADJUST_ELEMENT    =  'C'                               
MFA-TR*          AND  SA.INT_DISP_START_TS <= CURRENT TIMESTAMP                 
MFA-TR*          AND  SA.DATE_FROM         <= CURRENT DATE                      
MFA-TR*          AND  SA.DATE_TO           >= CURRENT DATE                      
MFA-TR*         ORDER BY SA.RATE_PLAN_NO                                        
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*       QUERYNO 7400                                                      
MFA-TR*    END-EXEC.                                                            
ACT128                                                                  
ACT128     EXEC SQL                                                     
ACT128        DECLARE SPCL_CUR CURSOR FOR                               
ACT128        SELECT SF.FCTR_POWER_10                                   
ACT128              ,SF.FACTOR_ID                                       
ACT128              ,SF.SPCL_GROUP_CD                                   
ACT128          FROM CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                     
ACT128         ORDER BY SF.FACTOR_ID                                    
ACT128                                                           
ACT128                                                      
ACT128     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE SPCL_CUR CURSOR FOR                                       
MFA-TR*       SELECT SF.FCTR_POWER_10                                           
MFA-TR*             ,SF.FACTOR_ID                                               
MFA-TR*             ,SF.SPCL_GROUP_CD                                           
MFA-TR*         FROM CSS_SPCL_FCTR SF                                           
MFA-TR*        ORDER BY SF.FACTOR_ID                                            
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7340                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
A04527****************************************************************          
A04527*    CURSOR TO FETCH ALL THE FCTR BASED ON THE PRC & CSC DSCNT.*          
A04527****************************************************************          
A04527     EXEC SQL                                                     
A04527        DECLARE DSCNT_CUR CURSOR FOR                              
A04527        SELECT FF.FACTOR                                          
A04527              ,SF.RT_ATTR_INCTV_TYPE                              
A04527          FROM CSS_FIXED_FCTR  FF WITH(READUNCOMMITTED)                   
A04527              ,CSS_SPCL_FCTR   SF WITH(READUNCOMMITTED)                   
A04527         WHERE FF.ACCOUNT_NO         =  :FF-ACCOUNT-NO            
A04527           AND FF.CODE_UTIL_TYPE     =  'G'                       
A04527           AND FF.IC_NO              =  :FF-IC-NO                 
A04527           AND FF.RT_PKG_OPT_SEQ_NO  =  :FF-RT-PKG-OPT-SEQ-NO     
A04527           AND FF.FACTOR_ID          =  SF.FACTOR_ID              
A04527           AND ((FF.DURATION_REMAIN_NO IS NULL                    
A04527           AND   FF.EFF_DATE_TO      >  IIF(TRY_CONVERT(DATE, 
                                                        :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) ))          
A04527            OR FF.DURATION_REMAIN_NO >  0 )                       
A04527           AND SF.RT_ATTR_INCTV_TYPE IN ( 'PRICE DISCOUNT',       
A04527                                            'CSC DISCOUNT',       
A04527                                             'PRICE ADDER',       
A04527                                               'CSC ADDER')       
A04527                                                           
A04527                                                      
A04527     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DSCNT_CUR CURSOR FOR                                      
MFA-TR*       SELECT FF.FACTOR                                                  
MFA-TR*             ,SF.RT_ATTR_INCTV_TYPE                                      
MFA-TR*         FROM CSS_FIXED_FCTR  FF                                         
MFA-TR*             ,CSS_SPCL_FCTR   SF                                         
MFA-TR*        WHERE FF.ACCOUNT_NO         =  :FF-ACCOUNT-NO                    
MFA-TR*          AND FF.CODE_UTIL_TYPE     =  'G'                               
MFA-TR*          AND FF.IC_NO              =  :FF-IC-NO                         
MFA-TR*          AND FF.RT_PKG_OPT_SEQ_NO  =  :FF-RT-PKG-OPT-SEQ-NO             
MFA-TR*          AND FF.FACTOR_ID          =  SF.FACTOR_ID                      
MFA-TR*          AND ((FF.DURATION_REMAIN_NO IS NULL                            
MFA-TR*          AND   FF.EFF_DATE_TO      >  :WS-COMMON-DATE)                  
MFA-TR*           OR FF.DURATION_REMAIN_NO >  0 )                               
MFA-TR*          AND SF.RT_ATTR_INCTV_TYPE IN ( 'PRICE DISCOUNT',               
MFA-TR*                                           'CSC DISCOUNT',               
MFA-TR*                                            'PRICE ADDER',               
MFA-TR*                                              'CSC ADDER')               
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7700                                                      
MFA-TR*    END-EXEC.                                                            
      /                                                                         
       PROCEDURE DIVISION.                                              

SCA006        SET FACTOR-IND TO 1.
SCA006        SET INCTV-IND TO 1.
SCA006        SET RATE-IND TO 1.
SCA006        SET SPCL-IND TO 1.
      ****************************************************************          
      **                                                            **          
      **  0000-MAINLINE                                             **          
      **      CONTROLS MAIN PROCESSING OF PROGRAM                   **          
      **                                                            **          
      ****************************************************************          
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION  THRU 0100-EXIT.                 
A02842** OPEN THE BASE CURSOR                                                   
A02842     PERFORM 7000-OPEN-ACCOUNT    THRU 7000-EXIT.                 
A02842     PERFORM 7010-FETCH-ACCOUNT   THRU 7010-EXIT.                 
A02842     PERFORM 1000-PROCESS-ACCOUNT THRU 1000-EXIT                  
A02842       UNTIL WS-ACTIVE-RETURN-CODE =  NOT-FOUND.                  
A02842     PERFORM 7020-CLOSE-ACCOUNT   THRU 7020-EXIT.                 
A02842*                                                                         
           PERFORM 9000-TERMINATE       THRU 9000-EXIT.                 
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  0100-INITIALIZATION                                       **          
      **      COMMON INITIALIZATION ROUTINE                         **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           INITIALIZE WS-WORK-VARIABLES.                                
           MOVE ZEROS                  TO WS-CA155-RECS-WRITE.          
A03303     MOVE ZEROS                  TO SF-FCTR-POWER-10.             
                                                                        
      ** GETS THE COMMON DATE FROM JOB_PARM_TABLE                               
A04527     PERFORM 6251-GET-FJC01-DATE         THRU 6251-EXIT.          
A04527     MOVE WS-INPUT-RUN-DATE            TO WS-COMMON-DATE.         
A04527                                                                  
A04527     IF  COMMON-DATE-NEEDED                                       
A04527         PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT        
A04527         MOVE 'PCSCA155'               TO WS-PGRMNAME             
A04527         MOVE WS-FCA00-COMMON-DATE     TO WS-COMMON-DATE          
A04527     END-IF.                                                      
                                                                        
      ** GETS THE COMMON REVENUE MONTH FROM JOB_PARM_TABLE                      
           PERFORM 0200-SELECT-COMMON-PARM THRU 0200-EXIT.              
                                                                        
      ** CALCULATE THE DATE PARM DAYS PRIOR TO CURRENT DATE                     
           PERFORM 7500-GET-PND-PRIOR-DATE THRU 7500-EXIT.              
           PERFORM 7550-GET-FNL-PRIOR-DATE THRU 7550-EXIT.              
                                                                        
      ** OPEN THE EXTRACT FILE IN O/P MODE                                      
           OPEN OUTPUT FCSCA155-FILE.                                   
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  0200-SELECT-COMMON-PARM                                   **          
      **      GETS THE COMMON REVENUE MONTH                         **          
      ****************************************************************          
      *                                                                         
       0200-SELECT-COMMON-PARM.                                         
      *                                                                         
           MOVE SPACES                 TO WS-SYSIPT.                    
           MOVE 'COMMON'               TO WS-PROGRAM.                   
           MOVE WS-DATE                TO WS-COMMAND.                   
           MOVE ZEROS                  TO WS-SEQUENCE.                  
           MOVE WS-KEY-AREA            TO E-FJC01-KEY.                  
                                                                        
           PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
                                                                        
           PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
               UNTIL (REVENUE-MONTH AND INPUT-ACTIVE)                   
                  OR  END-OF-SYSIPT.                                    
                                                                        
           EVALUATE TRUE                                                
              WHEN END-OF-SYSIPT                                        
                 DISPLAY '**     PCSCA155 PROCESSING ERROR   **'        
                 DISPLAY '**  NO ACTIVE REVENUE MONTH IN COMMON'        
                 DISPLAY '**       PROCESSING TERMINATED     **'        
                 PERFORM 9900-ABEND    THRU  9900-EXIT                  
              WHEN OTHER                                                
                 PERFORM 7611-CLOSE    THRU 7611-EXIT                   
           END-EVALUATE.                                                
           MOVE WS-REVENUE-MONTH-PARM  TO WS-COMMON-REV-MNTH.           
      *                                                                         
           MOVE SPACES                 TO WS-SYSIPT.                    
           MOVE PROGRAM-NAME           TO WS-PROGRAM.                   
           MOVE WS-PARM                TO WS-COMMAND.                   
           MOVE ZEROS                  TO WS-SEQUENCE.                  
           MOVE WS-KEY-AREA            TO E-FJC01-KEY.                  
                                                                        
           PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
                                                                        
           PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
               UNTIL (G6-PARM-DATA (1:7) = 'PENDING' AND INPUT-ACTIVE)  
                  OR  END-OF-SYSIPT.                                    
                                                                        
           EVALUATE TRUE                                                
              WHEN END-OF-SYSIPT                                        
                 DISPLAY '**     PCSCA155 PROCESSING ERROR   **'        
                 DISPLAY '**   NO PENDING ACCOUNT DAYS LIMIT'           
                 DISPLAY '**       PROCESSING TERMINATED     **'        
                 PERFORM 9900-ABEND    THRU  9900-EXIT                  
              WHEN OTHER                                                
                 PERFORM 7611-CLOSE    THRU 7611-EXIT                   
           END-EVALUATE.                                                
                                                                        
           MOVE ZEROS                  TO WS-DAYS.                      
           MOVE G6-PARM-DATA (15:4)    TO WS-DAYS.                      
           MOVE WS-DAYS                TO WS-P-DAYS.                    
      *                                                                         
           MOVE SPACES                 TO WS-SYSIPT.                    
           MOVE PROGRAM-NAME           TO WS-PROGRAM.                   
           MOVE WS-PARM                TO WS-COMMAND.                   
           MOVE ZEROS                  TO WS-SEQUENCE.                  
           MOVE WS-KEY-AREA            TO E-FJC01-KEY.                  
                                                                        
           PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
                                                                        
           PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
               UNTIL (G6-PARM-DATA (1:7) = 'FINALED' AND INPUT-ACTIVE)  
                  OR  END-OF-SYSIPT.                                    
                                                                        
           EVALUATE TRUE                                                
              WHEN END-OF-SYSIPT                                        
                 DISPLAY '**     PCSCA155 PROCESSING ERROR   **'        
                 DISPLAY '**   NO FINALED ACCOUNT DAYS LIMIT'           
                 DISPLAY '**       PROCESSING TERMINATED     **'        
                 PERFORM 9900-ABEND    THRU  9900-EXIT                  
              WHEN OTHER                                                
                 PERFORM 7611-CLOSE    THRU 7611-EXIT                   
           END-EVALUATE.                                                
                                                                        
           MOVE ZEROS                  TO WS-DAYS.                      
           MOVE G6-PARM-DATA (15:4)    TO WS-DAYS.                      
           MOVE WS-DAYS                TO WS-F-DAYS.                    
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  1000-PROCESS-ACCOUNT                                      **          
      **      GETS THE ACCOUNT OPTION CODE DETAILS AND WRITE THEM   **          
      **      IN THE OUTPUT EXTRACT FILE                            **          
      ****************************************************************          
       1000-PROCESS-ACCOUNT.                                            
A02842*                                                                         
A02842     PERFORM 1100-GET-THERM-PRICE         THRU 1100-EXIT.         
A02842     PERFORM 1110-GET-CURR-CSC-AMT        THRU 1110-EXIT.         
A04527     PERFORM 1120-GET-THRM-N-CSC-DSCNT    THRU 1120-EXIT.         
A02842     PERFORM 1200-POPULATE-DETAILS        THRU 1200-EXIT.         
A02842*                                                                         
A02842     PERFORM 7010-FETCH-ACCOUNT           THRU 7010-EXIT.         
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  1100-GET-THERM-PRICE                                      **          
      **      GET THE UNIT PRICE FOR THE ACCOUNTS BASED ON WHETHER  **          
      **      THEY ARE FIXED OR VARIABLE                            **          
      ****************************************************************          
      *                                                                         
       1100-GET-THERM-PRICE.                                            
      *                                                                         
A02842     MOVE 0                      TO WS-THERM-PRICE.               
A02842*                                                                         
A02842     IF FI-OPT-CALC-TYPE-CD = 'FP' OR 'IV'                        
              MOVE DF-OPTION-CD            TO HQ-OPTION-CD              
ACT128        MOVE SPACES                  TO HQ-FACTOR-ID              
              PERFORM 7200-GET-FACTOR-ID   THRU 7200-EXIT               
A02842        IF HQ-FACTOR-ID > ' '                                     
                 MOVE AT-ACCOUNT-NO        TO FF-ACCOUNT-NO             
                 MOVE UT-IC-NO             TO FF-IC-NO                  
                 MOVE HQ-FACTOR-ID         TO FF-FACTOR-ID              
                 MOVE UT-RT-PKG-OPT-SEQ-NO TO FF-RT-PKG-OPT-SEQ-NO      
ACT128           MOVE ZEROS                TO SF-FCTR-POWER-10          
                 PERFORM 7300-GET-FIXED-PRICE THRU 7300-EXIT            
ACT128           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
ACT128             SEARCH ALL WS-SPCL-TBL                               
ACT128             WHEN                                                 
ACT128               WS-SPCL-ID(SPCL-IND) = FF-FACTOR-ID                
ACT128                 MOVE WS-FCTR-POWER-10(SPCL-IND) TO               
ACT128                      SF-FCTR-POWER-10                            
ACT128             END-SEARCH                                           
ACT128             IF SF-FCTR-POWER-10  NOT EQUAL 0                     
A03303               COMPUTE WS-FACTOR-FF = FF-FACTOR*                  
A03303                                   10** SF-FCTR-POWER-10          
A03303               MOVE WS-FACTOR-FF   TO WS-THERM-PRICE              
A03303             ELSE                                                 
A02842               MOVE FF-FACTOR      TO WS-THERM-PRICE              
A03303             END-IF                                               
ACT128           END-IF                                                 
A02842        END-IF                                                    
           ELSE                                                         
A02842        IF FI-OPT-CALC-TYPE-CD = 'VP'                             
A02842           MOVE UT-RATE-PLAN-NO      TO SA-RATE-PLAN-NO           
ACT128           MOVE 0                    TO SA-FACTOR                 
A02842           PERFORM 7400-GET-VARPRICE-FCTR  THRU  7400-EXIT        
ACT128           IF SA-FACTOR > 0                                       
A02842              MOVE SA-FACTOR         TO WS-THERM-PRICE            
A02842           END-IF                                                 
A02842        END-IF                                                    
           END-IF.                                                      
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  GET THE ADJUSTED CSC AMOUNT FOR THE ACCOUNT, IF ANY       **          
      ****************************************************************          
      *                                                                         
A01673 1110-GET-CURR-CSC-AMT.                                           
      *                                                                         
A01673     MOVE ZEROS                  TO WS-CSC-AMT.                   
A01673     MOVE AT-ACCOUNT-NO          TO FF-ACCOUNT-NO.                
A02842     MOVE UT-IC-NO               TO FF-IC-NO.                     
A02842     MOVE UT-RATE-PLAN-NO        TO SA-RATE-PLAN-NO               
A02842                                    J4-RATE-PLAN-NO.              
A01673     PERFORM 7310-GET-ADJ-CSC-AMT THRU 7310-EXIT.                 
      *                                                                         
A01673     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A01673        MOVE SA-FACTOR           TO WS-CSC-AMT                    
           ELSE                                                         
A04019**----- GET RATE FACTOR CSC IF IT IS PRESENT                              
ACT128        MOVE 0                    TO SA-FACTOR                    
A04019        PERFORM 7320-GET-REPLACE-CSC-AMT THRU 7320-EXIT           
ACT128        IF SA-FACTOR > 0                                          
A04019           MOVE SA-FACTOR         TO WS-CSC-AMT                   
A04019        ELSE                                                      
      **------- GET CORE RATE CSC AMOUNT                                        
A01673          PERFORM 7510-GET-NRML-CSC-AMT THRU 7510-EXIT            
A01673          IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
A01673             MOVE J4-AMT-CUST-CHRG TO WS-CSC-AMT                  
A01673          END-IF                                                  
A04019        END-IF                                                    
A01673     END-IF.                                                      
      *                                                                         
A01673 1110-EXIT.                                                       
A01673     EXIT.                                                        
                                                                        
A04527****************************************************************          
A04527**                                                            **          
A04527** 1120-GET-THRM-N-CSC-DSCNT.                                 **          
A04527****************************************************************          
A04527 1120-GET-THRM-N-CSC-DSCNT.                                       
A04527                                                                  
A04527     MOVE AT-ACCOUNT-NO              TO FF-ACCOUNT-NO             
A04527     MOVE UT-IC-NO                   TO FF-IC-NO                  
A04527     MOVE UT-RT-PKG-OPT-SEQ-NO       TO FF-RT-PKG-OPT-SEQ-NO      
A04527     PERFORM 7700-OPEN-DSCNT-CURSOR     THRU 7700-EXIT.           
A04527     PERFORM 7710-FETCH-DSCNT-CURSOR    THRU 7710-EXIT.           
A04527     PERFORM 1400-GET-DISCOUNT-PRICE    THRU 1400-EXIT            
A04527       UNTIL WS-ACTIVE-RETURN-CODE     EQUAL  NOT-FOUND.          
A04527     PERFORM 7720-CLOSE-DSCNT-CURSOR    THRU 7720-EXIT.           
A04527                                                                  
A04527                                                                  
A04527     COMPUTE WS-NET-THERM-PRICE        EQUAL                      
A04527             WS-TOT-THRM-PRC-DSCNT + WS-THERM-PRICE.              
A04527                                                                  
A04527     COMPUTE WS-NET-CSC                EQUAL                      
A04527             WS-TOT-CSC-DSCNT      + WS-CSC-AMT.                  
A04527                                                                  
A04527 1120-EXIT.                                                       
A04527     EXIT.                                                        
A04527                                                                  
      ****************************************************************          
      **  1200-POPULATE-DETAILS                                     **          
      **      POPULATE THE CA155 FIELDS WITH THE VALUES RETREIVED   **          
      ****************************************************************          
      *                                                                         
       1200-POPULATE-DETAILS.                                           
      *                                                                         
           INITIALIZE E-FCA155-DATA-REC.                                
                                                                        
           MOVE DF-OPTION-CD         TO E-FCA155-OPTION-CODE.           
           MOVE AT-CODE-ACCT-STAT    TO E-FCA155-ACCT-STAT-CODE.        
           MOVE UT-RATE-PLAN-NO      TO E-FCA155-CORE-RT-PLAN.          
           MOVE AT-ACCOUNT-NO        TO E-FCA155-ACCOUNT-NO.            
A01673     MOVE WS-CSC-AMT           TO E-FCA155-CSC-AMT                
A04019                                  WS-CSC-AMT-DESC .               
A04019     STRING FI-OPT-DESC-INT DELIMITED BY '   '                    
A04019            ' with '                                              
A04019            WS-CSC-AMT-DESC DELIMITED BY SIZE                     
A04019            WS-CSC-LIT-DESC DELIMITED BY SIZE                     
A04019     INTO E-FCA155-OPT-DESC.                                      
A02842     MOVE WS-THERM-PRICE       TO E-FCA155-THERM-PRICE.           
      *                                                                         
A02842     IF FI-OPT-CALC-TYPE-CD  = 'FP'                               
A02842        MOVE 'F'               TO E-FCS155-RATE-TYP-FLAG          
A02842     ELSE                                                         
A02842        MOVE 'V'               TO E-FCS155-RATE-TYP-FLAG          
A02842     END-IF.                                                      
      *                                                                         
A01673     MOVE DD-TIER-ACCT-TYPE-CD TO E-FCA155-REAL-ACCT-TYP-CODE.    
      *                                                                         
           EVALUATE DD-TIER-ACCT-TYPE-CD                                
               WHEN 'D'                                                 
                  MOVE '1'            TO E-FCA155-TIER-ACCT-TYPE-CD     
               WHEN 'A'                                                 
                  MOVE '2'            TO E-FCA155-TIER-ACCT-TYPE-CD     
               WHEN 'B'                                                 
                  MOVE '3'            TO E-FCA155-TIER-ACCT-TYPE-CD     
               WHEN 'S'                                                 
                  MOVE '4'            TO E-FCA155-TIER-ACCT-TYPE-CD     
               WHEN '1'                                                 
                  MOVE '5'            TO E-FCA155-TIER-ACCT-TYPE-CD     
               WHEN '2'                                                 
                  MOVE '6'            TO E-FCA155-TIER-ACCT-TYPE-CD     
               WHEN OTHER                                               
A02842            GO TO 1200-EXIT                                       
           END-EVALUATE.                                                
                                                                        
A02842     IF E-FCS155-RATE-TYP-FLAG = 'F'                              
              PERFORM 1300-GET-ANNV-MONTH   THRU 1300-EXIT              
           END-IF.                                                      
A04527                                                                  
A04527     MOVE WS-NET-THERM-PRICE         TO E-FCA155-NET-THRM-PRC     
A04527     MOVE WS-NET-CSC                 TO E-FCA155-NET-CSC          
A04527     MOVE WS-TOT-THRM-PRC-DSCNT      TO E-FCA155-THRM-PRC-DSCNT   
A04527     MOVE WS-TOT-CSC-DSCNT           TO E-FCA155-CSC-DSCNT        
A04527     MOVE WS-DURATION-NO-HOLD        TO E-DURATION-NO.            
A02842*                                                                         
A02842     PERFORM 8000-WRITE-FCA155-RECORD THRU 8000-EXIT.             
                                                                        
A04527     MOVE ZERO                 TO WS-NET-THERM-PRICE              
A04527                                  WS-NET-CSC                      
A04527                                  WS-TOT-THRM-PRC-DSCNT           
A04527                                  WS-TOT-CSC-DSCNT                
A04527                                  WS-DURATION-NO-HOLD.            
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  1300-GET-ANNV-MONTH.                                      **          
      **      GET THE ANNIVERSARY MONTH FOR THE FIXED RATE ACCOUNT  **          
      ****************************************************************          
      *                                                                         
       1300-GET-ANNV-MONTH.                                             
      *                                                                         
           MOVE ZEROS                    TO WS-HOLD-REV-MNTH            
                                            WS-DUMMY-DATE               
                                            WS-DUMMY-DATE-TEMP          
                                            WS-RESULT-DATE              
                                            WS-RESULT-DT                
                                            WS-HOLD-REV-MNTH-RED        
                                            WS-HOLD-DURATION-REM.       
                                                                        
PRDFIX     MOVE FF-DURATION-REMAIN-NO    TO WS-HOLD-DURATION-REM.       
                                                                        
           IF AT-REV-MTH-LST-NRML > 0                                   
              MOVE AT-REV-MTH-LST-NRML   TO WS-HOLD-REV-MNTH            
           ELSE                                                         
              MOVE WS-COMMON-REV-MNTH    TO WS-HOLD-REV-MNTH            
PRDFIX        IF WS-HOLD-DURATION-REM > 0                               
PRDFIX           COMPUTE WS-HOLD-DURATION-REM = WS-HOLD-DURATION-REM - 1
PRDFIX        END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE WS-HOLD-REV-MNTH         TO WS-HOLD-REV-MNTH-RED.       
           MOVE WS-HOLD-REV-MNTH-YR      TO WS-DUMMY-DT-YYYY.           
           MOVE WS-HOLD-REV-MNTH-MM      TO WS-DUMMY-DT-MM.             
           MOVE '01'                     TO WS-DUMMY-DT-DD.             
           MOVE '-'                      TO WS-DUMMY-DT-F1              
                                            WS-DUMMY-DT-F2.             
           MOVE WS-DUMMY-DATE            TO WS-DUMMY-DATE-TEMP.         
                                                                        
           EXEC SQL                                                     
               SELECT
              DATEADD( MONTH, :WS-HOLD-DURATION-REM, 
              IIF(TRY_CONVERT(DATE, :WS-DUMMY-DATE-TEMP
              ) IS NULL OR (PATINDEX('%.%', :WS-DUMMY-DATE-TEMP
              ) <> 0) OR (LEN(:WS-DUMMY-DATE-TEMP
              ) <> 10), CIS.CHAR2DATE(:WS-DUMMY-DATE-TEMP
              ), CONVERT(DATE, :WS-DUMMY-DATE-TEMP) ) )
            INTO
              :WS-RESULT-DATE       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-RESULT-DATE = DATE(DATE(:WS-DUMMY-DATE-TEMP) +           
MFA-TR*                             :WS-HOLD-DURATION-REM MONTHS)               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**         1300-GET-ANNV-MONTH           **'     
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '**        PROCESSING IS TERMINATED       **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND       THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
           MOVE WS-RESULT-DATE (1:4)   TO WS-RESULT-DT-YYYY.            
           MOVE WS-RESULT-DATE (6:2)   TO WS-RESULT-DT-MM.              
                                                                        
           MOVE WS-RESULT-DT           TO E-FCA155-ANNV-MONTH.          
      *                                                                         
       1300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A04527****************************************************************          
A04527**                                                            **          
A04527**  1400-GET-DISCOUNT-PRICE.                                  **          
A04527****************************************************************          
A04527 1400-GET-DISCOUNT-PRICE.                                         
A04527                                                                  
A04527     EVALUATE SF-RT-ATTR-INCTV-TYPE                               
A04527                                                                  
A04527         WHEN 'PRICE DISCOUNT'                                    
A04527         WHEN    'PRICE ADDER'                                    
A04527                                                                  
A04527           COMPUTE WS-TOT-THRM-PRC-DSCNT    EQUAL                 
A04527                   WS-TOT-THRM-PRC-DSCNT + FF-FACTOR              
A04527                                                                  
A04527         WHEN 'CSC DISCOUNT'                                      
A04527         WHEN    'CSC ADDER'                                      
A04527                                                                  
A04527           COMPUTE WS-TOT-CSC-DSCNT         EQUAL                 
A04527                   WS-TOT-CSC-DSCNT      + FF-FACTOR              
A04527                                                                  
A04527     END-EVALUATE.                                                
A04527                                                                  
A04527     PERFORM 7710-FETCH-DSCNT-CURSOR      THRU 7710-EXIT.         
A04527                                                                  
A04527 1400-EXIT.                                                       
A04527     EXIT.                                                        
A04527                                                                  
                                                                        
      ****************************************************************          
      **  7000-OPEN-ACCOUNT                                         **          
      **      OPEN THE MAIN CURSOR ACCOUNT_CUR                      **          
      ****************************************************************          
      *                                                                         
       7000-OPEN-ACCOUNT.                                               
      *                                                                         
           EXEC SQL                                                     
               OPEN ACCOUNT_CUR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '       OPEN ACCOUNT_CUR '                       
               DISPLAY '       7000-OPEN-ACCOUNT '                      
A02842         DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
A02842         DISPLAY ' WS-PRIOR-PND-DATE = ' WS-PRIOR-PND-DATE        
A02842         DISPLAY ' WS-PRIOR-FNL-DATE = ' WS-PRIOR-FNL-DATE        
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7010-FETCH-ACCOUNT                                        **          
      **      FETCH THE ACCOUNTS FOR PROCESSING                     **          
      ****************************************************************          
      *                                                                         
       7010-FETCH-ACCOUNT.                                              
      *                                                                         
           EXEC SQL                                                     
               FETCH ACCOUNT_CUR                                        
                INTO :AT-ACCOUNT-NO                                     
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-REV-MTH-LST-NRML                               
                    ,:UT-RATE-PLAN-NO                                   
                    ,:UT-IC-NO                                          
                    ,:UT-RT-PKG-OPT-SEQ-NO                              
A02842              ,:DF-OPTION-CD                                      
A02842              ,:FI-OPT-CALC-TYPE-CD                               
A02842              ,:FI-OPT-DESC-INT                                   
                    ,:DD-TIER-ACCT-TYPE-CD                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
A02842     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR  NOT-FOUND    
A02842        CONTINUE                                                  
A02842     ELSE                                                         
A02842        DISPLAY '*******************************************'     
A02842        DISPLAY '       ABENDING PROGRAM '                        
A02842        DISPLAY '       FETCH ACCOUNT_CUR '                       
A02842        DISPLAY '       7010-FETCH-ACCOUNT '                      
A02842        DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE     
A02842        DISPLAY ' WS-PRIOR-PND-DATE = ' WS-PRIOR-PND-DATE         
A02842        DISPLAY ' WS-PRIOR-FNL-DATE = ' WS-PRIOR-FNL-DATE         
A02842        DISPLAY '*******************************************'     
A02842        PERFORM 9900-ABEND      THRU 9900-EXIT                    
A02842     END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7020-CLOSE-ACCOUNT                                        **          
      **      CLOSE THE MAIN CURSOR ACCOUNT_CUR                     **          
      ****************************************************************          
      *                                                                         
       7020-CLOSE-ACCOUNT.                                              
      *                                                                         
           EXEC SQL                                                     
               CLOSE ACCOUNT_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '*******************************************'     
              DISPLAY '       ABENDING PROGRAM '                        
              DISPLAY '      CLOSE ACCOUNT_CUR '                        
              DISPLAY '      7020-CLOSE-ACCOUNT '                       
A02842        DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE     
A02842        DISPLAY ' WS-PRIOR-PND-DATE = ' WS-PRIOR-PND-DATE         
A02842        DISPLAY ' WS-PRIOR-FNL-DATE = ' WS-PRIOR-FNL-DATE         
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND       THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
ACT128****************************************************************          
ACT128**  7200-GET-FACTOR-ID.                                       **          
ACT128**      GET THE FACTOR ID FOR A FIXED RATE ACCOUNT            **          
ACT128****************************************************************          
ACT128*                                                                         
ACT128 7200-GET-FACTOR-ID.                                              
ACT128                                                                  
ACT128     IF WS-INCTV-CNT = 0                                          
ACT128        PERFORM 7210-LOAD-FACTOR THRU 7210-EXIT                   
ACT128     END-IF.                                                      
ACT128                                                                  
ACT128     SEARCH ALL WS-INCTV-TBL                                      
ACT128       WHEN WS-OPTION-CD(INCTV-IND) = HQ-OPTION-CD                
ACT128          MOVE WS-FACTOR-ID(INCTV-IND) TO HQ-FACTOR-ID            
A04527          MOVE WS-DURATION-NO(INCTV-IND) TO WS-DURATION-NO-HOLD   
ACT128     END-SEARCH.                                                  
ACT128                                                                  
ACT128 7200-EXIT.                                                       
ACT128     EXIT.                                                        
ACT128                                                                  
ACT128****************************************************************          
ACT128**  7210-LOAD-FACTOR.                                         **          
ACT128**    LOAD THE FACTOR ID TABLE                                            
ACT128****************************************************************          
ACT128 7210-LOAD-FACTOR.                                                
ACT128                                                                  
ACT128     PERFORM 7211-OPEN-FACTOR THRU 7211-EXIT.                     
ACT128                                                                  
ACT128     PERFORM 7212-FETCH-FACTOR THRU 7212-EXIT.                    
ACT128                                                                  
ACT128     PERFORM UNTIL WS-ACTIVE-RETURN-CODE NOT = 0                  
ACT128        IF WS-INCTV-CNT > 9999                                    
ACT128          DISPLAY '*******************************************'   
ACT128          DISPLAY '       ABENDING PROGRAM '                      
ACT128          DISPLAY '       INCTV TABLE OVERFLOW'                   
ACT128          DISPLAY '       7210-LOAD-FACTOR  '                     
ACT128          DISPLAY '*******************************************'   
ACT128          PERFORM 9900-ABEND      THRU 9900-EXIT                  
ACT128        END-IF                                                    
ACT128        ADD 1 TO WS-INCTV-CNT                                     
ACT128        MOVE WS-FACTOR-ID-HOLD TO WS-FACTOR-ID(WS-INCTV-CNT)      
ACT128        MOVE WS-OPTION-CD-HOLD TO WS-OPTION-CD(WS-INCTV-CNT)      
A04527        MOVE HQ-DURATION-NO      TO WS-DURATION-NO(WS-INCTV-CNT)  
ACT128        PERFORM 7212-FETCH-FACTOR THRU 7212-EXIT                  
ACT128     END-PERFORM.                                                 
ACT128                                                                  
ACT128     PERFORM 7213-CLOSE-FACTOR THRU 7213-EXIT.                    
ACT128                                                                  
ACT128 7210-EXIT.                                                       
ACT128     EXIT.                                                        
ACT128                                                                  
ACT128****************************************************************          
ACT128**  7211-OPEN-FACTOR.                                         **          
ACT128**    OPEN THE FACTOR ID TABLE                                            
ACT128****************************************************************          
ACT128 7211-OPEN-FACTOR.                                                
ACT128                                                                  
ACT128     EXEC SQL                                                     
ACT128         OPEN INCTV_CUR                                           
ACT128     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT128                                                                  
ACT128     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
ACT128                                                                  
ACT128     IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
ACT128         DISPLAY '*******************************************'    
ACT128         DISPLAY '       ABENDING PROGRAM '                       
ACT128         DISPLAY '       OPEN INCTV_CUR '                         
ACT128         DISPLAY '       7211-OPEN-FACTOR  '                      
ACT128         DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
ACT128         DISPLAY '*******************************************'    
ACT128         PERFORM 9900-ABEND      THRU 9900-EXIT                   
ACT128     END-IF.                                                      
ACT128                                                                  
ACT128 7211-EXIT.                                                       
ACT128     EXIT.                                                        
ACT128                                                                  
ACT128****************************************************************          
ACT128**  7212-FETCH-FACTOR.                                        **          
ACT128**    FETCH THE FACTOR ID TABLE                                           
ACT128****************************************************************          
ACT128 7212-FETCH-FACTOR.                                               
ACT128                                                                  
ACT128     EXEC SQL                                                     
ACT128         FETCH INCTV_CUR                                          
ACT128          INTO :WS-FACTOR-ID-HOLD                                 
ACT128              ,:WS-OPTION-CD-HOLD                                 
A04527              ,:HQ-DURATION-NO                                    
ACT128     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT128                                                                  
ACT128     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
ACT128                                                                  
ACT128     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT128         CONTINUE                                                 
ACT128     ELSE                                                         
ACT128         DISPLAY '*******************************************'    
ACT128         DISPLAY '       ABENDING PROGRAM '                       
ACT128         DISPLAY '       FETCH INCTV_CUR '                        
ACT128         DISPLAY '       7212-FETCH-FACTOR  '                     
ACT128         DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
ACT128         DISPLAY '*******************************************'    
ACT128         PERFORM 9900-ABEND      THRU 9900-EXIT                   
ACT128     END-IF.                                                      
ACT128                                                                  
ACT128 7212-EXIT.                                                       
ACT128     EXIT.                                                        
ACT128                                                                  
ACT128****************************************************************          
ACT128**  7213-CLOSE-FACTOR.                                        **          
ACT128**    CLOSE THE FACTOR ID TABLE                                           
ACT128****************************************************************          
ACT128 7213-CLOSE-FACTOR.                                               
ACT128                                                                  
ACT128     EXEC SQL                                                     
ACT128         CLOSE INCTV_CUR                                          
ACT128     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT128                                                                  
ACT128     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
ACT128                                                                  
ACT128     IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
ACT128         DISPLAY '*******************************************'    
ACT128         DISPLAY '       ABENDING PROGRAM '                       
ACT128         DISPLAY '       CLOSE INCTV_CUR '                        
ACT128         DISPLAY '       7213-CLOSE-FACTOR  '                     
ACT128         DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
ACT128         DISPLAY '*******************************************'    
ACT128         PERFORM 9900-ABEND      THRU 9900-EXIT                   
ACT128     END-IF.                                                      
ACT128                                                                  
ACT128 7213-EXIT.                                                       
ACT128     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7300-GET-FIXED-PRICE.                                     **          
      **      GET THE THERM PRICE AND DURATION NO FOR FIXED PRICE   **          
      **      ACCOUNTS                                              **          
      ****************************************************************          
      *                                                                         
       7300-GET-FIXED-PRICE.                                            
      *                                                                         
ACT128      IF WS-SPCL-CNT = 0                                          
ACT128         PERFORM 7340-LOAD-SPCL THRU 7340-EXIT                    
ACT128      END-IF.                                                     
ACT128                                                                  
           EXEC SQL                                                     
              SELECT TOP(1) FACTOR,
              DURATION_REMAIN_NO                                 
                INTO :FF-FACTOR                                         
                    ,:FF-DURATION-REMAIN-NO :WS-NULL-IND-FF             
                FROM CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                    
               WHERE FF.ACCOUNT_NO        = :FF-ACCOUNT-NO              
                 AND FF.CODE_UTIL_TYPE    = 'G'                         
                 AND FF.IC_NO             = :FF-IC-NO                   
                 AND FF.FACTOR_ID         = :FF-FACTOR-ID               
                 AND FF.RT_PKG_OPT_SEQ_NO = :FF-RT-PKG-OPT-SEQ-NO       
P00680         ORDER BY FF.EFF_DATE_FROM DESC                           
P00680                                              
                                                                 
A02842                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FACTOR                                                     
MFA-TR*             ,DURATION_REMAIN_NO                                         
MFA-TR*         INTO :FF-FACTOR                                                 
MFA-TR*             ,:FF-DURATION-REMAIN-NO :WS-NULL-IND-FF                     
MFA-TR*         FROM CSS_FIXED_FCTR FF                                          
MFA-TR*        WHERE FF.ACCOUNT_NO        = :FF-ACCOUNT-NO                      
MFA-TR*          AND FF.CODE_UTIL_TYPE    = 'G'                                 
MFA-TR*          AND FF.IC_NO             = :FF-IC-NO                           
MFA-TR*          AND FF.FACTOR_ID         = :FF-FACTOR-ID                       
MFA-TR*          AND FF.RT_PKG_OPT_SEQ_NO = :FF-RT-PKG-OPT-SEQ-NO               
MFA-TR*        ORDER BY FF.EFF_DATE_FROM DESC                                   
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
A02842     IF WS-NULL-IND-FF < 0                                        
A02842        MOVE 0                   TO FF-DURATION-REMAIN-NO         
A02842     END-IF.                                                      
A02842                                                                  
A02842     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR  NOT-FOUND    
A02842        CONTINUE                                                  
A02842     ELSE                                                         
A02842        DISPLAY '*******************************************'     
A02842        DISPLAY '       ABENDING PROGRAM '                        
A02842        DISPLAY '       7300-GET-FIXED-PRICE '                    
A02842        DISPLAY ' RETURN CODE          = ' WS-ACTIVE-RETURN-CODE  
A02842        DISPLAY ' FF-ACCOUNT-NO        = ' FF-ACCOUNT-NO          
A02842        DISPLAY ' FF-IC-NO             = ' FF-IC-NO               
A02842        DISPLAY ' FF-FACTOR-ID         = ' FF-FACTOR-ID           
A02842        DISPLAY ' FF-RT-PKG-OPT-SEQ-NO = ' FF-RT-PKG-OPT-SEQ-NO   
A02842        DISPLAY '*******************************************'     
A02842        PERFORM 9900-ABEND      THRU 9900-EXIT                    
A02842     END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **      CHK IF THE ACCOUNT HAS ANY ADJUSTED CSC AMOUNT        **          
      ****************************************************************          
      *                                                                         
A01673 7310-GET-ADJ-CSC-AMT.                                            
      *                                                                         
A01673     EXEC SQL                                                     
A01673         SELECT TOP(1) SA.FACTOR                                         
A01673           INTO :SA-FACTOR                                        
A01673           FROM CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                   
A01673               ,CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)               
A01673               ,CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                    
A01673          WHERE FF.ACCOUNT_NO     = :FF-ACCOUNT-NO                
A01673            AND FF.CODE_UTIL_TYPE = 'G'                           
A01673            AND FF.IC_NO          = :FF-IC-NO                     
A01673            AND FF.EFF_DATE_TO    > CAST(SYSDATETIMEOFFSET() 
           AS DATE)                  
A01673            AND SA.RATE_PLAN_NO   = :SA-RATE-PLAN-NO              
A01673            AND SA.CODE_UTIL_TYPE = FF.CODE_UTIL_TYPE             
A01673            AND SA.FACTOR_ID      = FF.FACTOR_ID                  
A01673            AND SF.SPCL_GROUP_CD  = 'BS'                          
A01673            AND SF.FACTOR_ID      = FF.FACTOR_ID                  
ACT128                                              
A01673                                                           
A02842                                                      
A01673     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SA.FACTOR                                                 
MFA-TR*          INTO :SA-FACTOR                                                
MFA-TR*          FROM CSS_FIXED_FCTR FF                                         
MFA-TR*              ,CSS_SPCL_FCTR_APPL SA                                     
MFA-TR*              ,CSS_SPCL_FCTR SF                                          
MFA-TR*         WHERE FF.ACCOUNT_NO     = :FF-ACCOUNT-NO                        
MFA-TR*           AND FF.CODE_UTIL_TYPE = 'G'                                   
MFA-TR*           AND FF.IC_NO          = :FF-IC-NO                             
MFA-TR*           AND FF.EFF_DATE_TO    > CURRENT DATE                          
MFA-TR*           AND SA.RATE_PLAN_NO   = :SA-RATE-PLAN-NO                      
MFA-TR*           AND SA.CODE_UTIL_TYPE = FF.CODE_UTIL_TYPE                     
MFA-TR*           AND SA.FACTOR_ID      = FF.FACTOR_ID                          
MFA-TR*           AND SF.SPCL_GROUP_CD  = 'BS'                                  
MFA-TR*           AND SF.FACTOR_ID      = FF.FACTOR_ID                          
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7310                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A01673     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
A02842     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
A02842        CONTINUE                                                  
A02842     ELSE                                                         
A02842        DISPLAY '******************************************'      
A02842        DISPLAY '** PROCESSING ERROR IN PROGRAM PCSCA155 **'      
A02842        DISPLAY '**      PARA 7310-GET-ADJ-CSC-AMT       **'      
A02842        DISPLAY '**  RETURN CODE     = ' WS-ACTIVE-RETURN-CODE    
A02842        DISPLAY '**  FF-ACCOUNT-NO   = ' FF-ACCOUNT-NO            
A02842        DISPLAY '**  FF-IC-NO        = ' FF-IC-NO                 
A02842        DISPLAY '**  SA-RATE-PLAN-NO = ' SA-RATE-PLAN-NO          
A02842        DISPLAY '**        PROCESSING TERMINATED         **'      
A02842        DISPLAY '******************************************'      
A02842        PERFORM 9900-ABEND THRU 9900-EXIT                         
A02842     END-IF.                                                      
      *                                                                         
A01673 7310-EXIT.                                                       
A01673     EXIT.                                                        
      *                                                                         
ACT128****************************************************************          
ACT128**CHK IF THE ACCOUNT HAS ANY CSC TO BE REPLACED BY RATE FACTOR *          
ACT128****************************************************************          
ACT128 7320-GET-REPLACE-CSC-AMT.                                        
ACT128                                                                  
ACT128     IF WS-FACTOR-CNT = 0                                         
ACT128        PERFORM 7330-LOAD-RATE-PLAN THRU 7330-EXIT                
ACT128     END-IF.                                                      
ACT128                                                                  
ACT128     SEARCH ALL WS-FACTOR-TBL                                     
ACT128       WHEN WS-RATE-PLAN(FACTOR-IND) = SA-RATE-PLAN-NO            
ACT128          MOVE WS-FACTOR(FACTOR-IND) TO SA-FACTOR                 
ACT128     END-SEARCH.                                                  
ACT128                                                                  
ACT128 7320-EXIT.                                                       
ACT128     EXIT.                                                        
ACT128****************************************************************          
ACT128**LOAD ALL THE RATE PLANS FOR THIS ACCOUNT.                    *          
ACT128****************************************************************          
ACT128 7330-LOAD-RATE-PLAN.                                             
ACT128                                                                  
ACT128     PERFORM 7331-OPEN-FACTOR THRU 7331-EXIT.                     
ACT128                                                                  
ACT128     PERFORM 7332-FETCH-FACTOR THRU 7332-EXIT.                    
ACT128                                                                  
ACT128     PERFORM UNTIL WS-ACTIVE-RETURN-CODE NOT = 0                  
ACT128        IF WS-FACTOR-CNT > 9999                                   
ACT128          DISPLAY '*******************************************'   
ACT128          DISPLAY '       ABENDING PROGRAM '                      
ACT128          DISPLAY '       FACTOR TABLE OVERFLOW'                  
ACT128          DISPLAY '       7330-LOAD-RATE-PLAN'                    
ACT128          DISPLAY '*******************************************'   
ACT128          PERFORM 9900-ABEND      THRU 9900-EXIT                  
ACT128        END-IF                                                    
ACT128        ADD 1 TO WS-FACTOR-CNT                                    
ACT128        MOVE WS-FACTOR-HOLD  TO WS-FACTOR(WS-FACTOR-CNT)          
ACT128        MOVE WS-RATE-PLAN-HOLD TO WS-RATE-PLAN(WS-FACTOR-CNT)     
ACT128        PERFORM 7332-FETCH-FACTOR THRU 7332-EXIT                  
ACT128     END-PERFORM.                                                 
ACT128                                                                  
ACT128     PERFORM 7333-CLOSE-FACTOR THRU 7333-EXIT.                    
ACT128                                                                  
ACT128 7330-EXIT.                                                       
ACT128     EXIT.                                                        
ACT128****************************************************************          
ACT128**OPEN THE FACTOR CURSOR                                       *          
ACT128****************************************************************          
ACT128 7331-OPEN-FACTOR.                                                
ACT128                                                                  
ACT128     EXEC SQL                                                     
ACT128         OPEN FACTOR_CUR                                          
ACT128     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT128                                                                  
ACT128     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
ACT128                                                                  
ACT128     IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
ACT128         DISPLAY '*******************************************'    
ACT128         DISPLAY '       ABENDING PROGRAM '                       
ACT128         DISPLAY '       OPEN FACTOR_CUR '                        
ACT128         DISPLAY '       7331-OPEN-FACTOR'                        
ACT128         DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
ACT128         DISPLAY '*******************************************'    
ACT128         PERFORM 9900-ABEND      THRU 9900-EXIT                   
ACT128     END-IF.                                                      
ACT128                                                                  
ACT128 7331-EXIT.                                                       
ACT128     EXIT.                                                        
ACT128****************************************************************          
ACT128**FETCH THE FACTOR CURSOR                                      *          
ACT128****************************************************************          
ACT128 7332-FETCH-FACTOR.                                               
ACT128                                                                  
ACT128     EXEC SQL                                                     
ACT128        FETCH FACTOR_CUR                                          
ACT128           INTO :WS-FACTOR-HOLD                                   
ACT128               ,:WS-RATE-PLAN-HOLD                                
ACT128     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT128                                                                  
ACT128     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT128                                                                  
ACT128     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT128         CONTINUE                                                 
ACT128     ELSE                                                         
ACT128         DISPLAY '*******************************************'    
ACT128         DISPLAY '       ABENDING PROGRAM '                       
ACT128         DISPLAY '       FETCH FACTOR_CUR '                       
ACT128         DISPLAY '       7332-FETCH-FACTOR'                       
ACT128         DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
ACT128         DISPLAY '*******************************************'    
ACT128         PERFORM 9900-ABEND      THRU 9900-EXIT                   
ACT128     END-IF.                                                      
ACT128                                                                  
ACT128 7332-EXIT.                                                       
ACT128     EXIT.                                                        
ACT128****************************************************************          
ACT128**CLOSE THE FACTOR CURSOR                                      *          
ACT128****************************************************************          
ACT128 7333-CLOSE-FACTOR.                                               
ACT128                                                                  
ACT128     EXEC SQL                                                     
ACT128         CLOSE FACTOR_CUR                                         
ACT128     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT128                                                                  
ACT128     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
ACT128                                                                  
ACT128     IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
ACT128         DISPLAY '*******************************************'    
ACT128         DISPLAY '       ABENDING PROGRAM '                       
ACT128         DISPLAY '       CLOSE FACTOR_CUR '                       
ACT128         DISPLAY '       7333-CLOSE-FACTOR'                       
ACT128         DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
ACT128         DISPLAY '*******************************************'    
ACT128         PERFORM 9900-ABEND      THRU 9900-EXIT                   
ACT128     END-IF.                                                      
ACT128                                                                  
ACT128 7333-EXIT.                                                       
ACT128     EXIT.                                                        
ACT128****************************************************************          
ACT128**LOAD ALL THE SPCL FACTORS FOR THIS ACCOUNT.                  *          
ACT128****************************************************************          
ACT128 7340-LOAD-SPCL.                                                  
ACT128                                                                  
ACT128     PERFORM 7341-OPEN-SPCL-FACT THRU 7341-EXIT.                  
ACT128                                                                  
ACT128     PERFORM 7342-FETCH-SPCL-FACT THRU 7342-EXIT.                 
ACT128                                                                  
ACT128     PERFORM UNTIL WS-ACTIVE-RETURN-CODE NOT = 0                  
ACT128        IF WS-SPCL-CNT > 9999                                     
ACT128          DISPLAY '*******************************************'   
ACT128          DISPLAY '       ABENDING PROGRAM '                      
ACT128          DISPLAY '       SPCL TABLE OVERFLOW'                    
ACT128          DISPLAY '       7340-LOAD-SPCL     '                    
ACT128          DISPLAY '*******************************************'   
ACT128          PERFORM 9900-ABEND      THRU 9900-EXIT                  
ACT128        END-IF                                                    
ACT128        ADD 1 TO WS-SPCL-CNT                                      
ACT128        MOVE WS-FACTOR-ID-HOLD  TO WS-SPCL-ID(WS-SPCL-CNT)        
ACT128        MOVE WS-FCTR-POWER-HOLD TO WS-FCTR-POWER-10(WS-SPCL-CNT)  
ACT128        MOVE CM-SPCL-GROUP      TO WS-SPCL-GROUP(WS-SPCL-CNT)     
ACT128        PERFORM 7342-FETCH-SPCL-FACT THRU 7342-EXIT               
ACT128     END-PERFORM.                                                 
ACT128                                                                  
ACT128     PERFORM 7343-CLOSE-SPCL-FACT THRU 7343-EXIT.                 
ACT128                                                                  
ACT128 7340-EXIT.                                                       
ACT128     EXIT.                                                        
ACT128****************************************************************          
ACT128**OPEN THE SPCL FACT CURSOR                                    *          
ACT128****************************************************************          
ACT128 7341-OPEN-SPCL-FACT.                                             
ACT128                                                                  
ACT128     EXEC SQL                                                     
ACT128         OPEN SPCL_CUR                                            
ACT128     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT128                                                                  
ACT128     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
ACT128                                                                  
ACT128     IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
ACT128         DISPLAY '*******************************************'    
ACT128         DISPLAY '       ABENDING PROGRAM '                       
ACT128         DISPLAY '       OPEN SPCL_CUR '                          
ACT128         DISPLAY '       7341-OPEN-SPCL-FCTR'                     
ACT128         DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
ACT128         DISPLAY '*******************************************'    
ACT128         PERFORM 9900-ABEND      THRU 9900-EXIT                   
ACT128     END-IF.                                                      
ACT128                                                                  
ACT128 7341-EXIT.                                                       
ACT128     EXIT.                                                        
ACT128****************************************************************          
ACT128**FETCH THE SPCL FACT CURSOR                                   *          
ACT128****************************************************************          
ACT128 7342-FETCH-SPCL-FACT.                                            
ACT128                                                                  
ACT128     EXEC SQL                                                     
ACT128        FETCH SPCL_CUR                                            
ACT128           INTO :WS-FCTR-POWER-HOLD                               
ACT128               ,:WS-FACTOR-ID-HOLD                                
ACT128               ,:CM-SPCL-GROUP                                    
ACT128     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT128                                                                  
ACT128     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT128                                                                  
ACT128     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT128         CONTINUE                                                 
ACT128     ELSE                                                         
ACT128         DISPLAY '*******************************************'    
ACT128         DISPLAY '       ABENDING PROGRAM '                       
ACT128         DISPLAY '       FETCH SPCL_CUR '                         
ACT128         DISPLAY '       7342-FETCH-SPCL-FACT'                    
ACT128         DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
ACT128         DISPLAY '*******************************************'    
ACT128         PERFORM 9900-ABEND      THRU 9900-EXIT                   
ACT128     END-IF.                                                      
ACT128                                                                  
ACT128 7342-EXIT.                                                       
ACT128     EXIT.                                                        
ACT128****************************************************************          
ACT128**CLOSE THE SPCL FACT CURSOR                                   *          
ACT128****************************************************************          
ACT128 7343-CLOSE-SPCL-FACT.                                            
ACT128                                                                  
ACT128     EXEC SQL                                                     
ACT128         CLOSE SPCL_CUR                                           
ACT128     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT128                                                                  
ACT128     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
ACT128                                                                  
ACT128     IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
ACT128         DISPLAY '*******************************************'    
ACT128         DISPLAY '       ABENDING PROGRAM '                       
ACT128         DISPLAY '       CLOSE SPCL_CUR '                         
ACT128         DISPLAY '       7343-CLOSE-SPCL-FACT'                    
ACT128         DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
ACT128         DISPLAY '*******************************************'    
ACT128         PERFORM 9900-ABEND      THRU 9900-EXIT                   
ACT128     END-IF.                                                      
ACT128                                                                  
ACT128 7343-EXIT.                                                       
ACT128     EXIT.                                                        
ACT128****************************************************************          
ACT128**  7400-GET-VARPRICE-FCTR.                                   **          
ACT128**      GET THE THERM PRICE FOR VARIABLE RATE ACCOUNTS        **          
ACT128****************************************************************          
ACT128 7400-GET-VARPRICE-FCTR.                                          
ACT128                                                                  
ACT128     IF WS-RATE-CNT = 0                                           
ACT128        PERFORM 7450-LOAD-VARPRICE THRU 7450-EXIT                 
ACT128     END-IF.                                                      
ACT128                                                                  
ACT128     SEARCH ALL WS-RATE-TBL                                       
ACT128       WHEN WS-RATE-PLAN-NO(RATE-IND) = SA-RATE-PLAN-NO           
ACT128          MOVE WS-FACTOR-NO(RATE-IND) TO SA-FACTOR                
ACT128     END-SEARCH.                                                  
ACT128                                                                  
ACT128 7400-EXIT.                                                       
ACT128     EXIT.                                                        
ACT128****************************************************************          
ACT128**  7450-LOAD-VARPRICE                                        **          
ACT128**    LOAD THE THERM PRICE FOR VARIABLE RATE ACCOUNTS         **          
ACT128****************************************************************          
ACT128 7450-LOAD-VARPRICE.                                              
ACT128                                                                  
ACT128     PERFORM 7451-OPEN-RATE-PLAN THRU 7451-EXIT.                  
ACT128                                                                  
ACT128     PERFORM 7452-FETCH-RATE-PLAN THRU 7452-EXIT.                 
ACT128                                                                  
ACT128     PERFORM UNTIL WS-ACTIVE-RETURN-CODE NOT = 0                  
ACT128        IF WS-RATE-CNT > 9999                                     
ACT128          DISPLAY '*******************************************'   
ACT128          DISPLAY '       ABENDING PROGRAM '                      
ACT128          DISPLAY '       RATE TABLE OVERFLOW'                    
ACT128          DISPLAY '       7450-LOAD-VARPRICE '                    
ACT128          DISPLAY '*******************************************'   
ACT128          PERFORM 9900-ABEND      THRU 9900-EXIT                  
ACT128        END-IF                                                    
ACT128        ADD 1 TO WS-RATE-CNT                                      
ACT128        MOVE WS-FACTOR-HOLD  TO WS-FACTOR-NO(WS-RATE-CNT)         
ACT128        MOVE WS-RATE-PLAN-HOLD TO WS-RATE-PLAN-NO(WS-RATE-CNT)    
ACT128        PERFORM 7452-FETCH-RATE-PLAN THRU 7452-EXIT               
ACT128     END-PERFORM.                                                 
ACT128                                                                  
ACT128     PERFORM 7453-CLOSE-RATE-PLAN THRU 7453-EXIT.                 
ACT128                                                                  
ACT128 7450-EXIT.                                                       
ACT128     EXIT.                                                        
ACT128****************************************************************          
ACT128**OPEN THE RATE PLAN CURSOR                                    *          
ACT128****************************************************************          
ACT128 7451-OPEN-RATE-PLAN.                                             
ACT128                                                                  
ACT128     EXEC SQL                                                     
ACT128         OPEN RATE_CUR                                            
ACT128     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT128                                                                  
ACT128     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
ACT128                                                                  
ACT128     IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
ACT128         DISPLAY '*******************************************'    
ACT128         DISPLAY '       ABENDING PROGRAM '                       
ACT128         DISPLAY '       OPEN RATE_CUR '                          
ACT128         DISPLAY '       7451-OPEN-RATE-PLAN'                     
ACT128         DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
ACT128         DISPLAY '*******************************************'    
ACT128         PERFORM 9900-ABEND      THRU 9900-EXIT                   
ACT128     END-IF.                                                      
ACT128                                                                  
ACT128 7451-EXIT.                                                       
ACT128     EXIT.                                                        
ACT128****************************************************************          
ACT128**FETCH THE RATE PLAN CURSOR                                   *          
ACT128****************************************************************          
ACT128 7452-FETCH-RATE-PLAN.                                            
ACT128                                                                  
ACT128     EXEC SQL                                                     
ACT128         FETCH RATE_CUR                                           
ACT128          INTO  :WS-FACTOR-HOLD                                   
ACT128               ,:WS-RATE-PLAN-HOLD                                
ACT128     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT128                                                                  
ACT128     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
ACT128                                                                  
ACT128     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT128         CONTINUE                                                 
ACT128     ELSE                                                         
ACT128         DISPLAY '*******************************************'    
ACT128         DISPLAY '       ABENDING PROGRAM '                       
ACT128         DISPLAY '       FETCH RATE_CUR '                         
ACT128         DISPLAY '       7452-FETCH-RATE-PLAN'                    
ACT128         DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
ACT128         DISPLAY '*******************************************'    
ACT128         PERFORM 9900-ABEND      THRU 9900-EXIT                   
ACT128     END-IF.                                                      
ACT128                                                                  
ACT128 7452-EXIT.                                                       
ACT128     EXIT.                                                        
ACT128****************************************************************          
ACT128**CLOSE THE RATE PLAN CURSOR                                   *          
ACT128****************************************************************          
ACT128 7453-CLOSE-RATE-PLAN.                                            
ACT128                                                                  
ACT128     EXEC SQL                                                     
ACT128         CLOSE RATE_CUR                                           
ACT128     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT128                                                                  
ACT128     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
ACT128                                                                  
ACT128     IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
ACT128         DISPLAY '*******************************************'    
ACT128         DISPLAY '       ABENDING PROGRAM '                       
ACT128         DISPLAY '       CLOSE RATE_CUR '                         
ACT128         DISPLAY '       7453-CLOSE-RATE-PLAN'                    
ACT128         DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
ACT128         DISPLAY '*******************************************'    
ACT128         PERFORM 9900-ABEND      THRU 9900-EXIT                   
ACT128     END-IF.                                                      
ACT128                                                                  
ACT128 7453-EXIT.                                                       
ACT128     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   7500-GET-PND-PRIOR-DATE.                                 **          
      **      GET THE DATE PARM PRIOR TO CURRENT DATE TO FILTER     **          
      **      THE PENDING ACCOUNTS IN MAIN CURSOR                   **          
      ****************************************************************          
      *                                                                         
       7500-GET-PND-PRIOR-DATE.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT
              DATEADD(D, (CIS.DAYS(CAST(SYSDATETIMEOFFSET() AS DATE))          
                                     - :WS-P-DAYS)-1, 
              CAST('00010101' AS DATE))
            INTO
              :WS-PRIOR-PND-DATE                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-PRIOR-PND-DATE = DATE(DAYS(CURRENT DATE)                  
MFA-TR*                              - :WS-P-DAYS)                              
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '*******************************************'     
              DISPLAY '       ABENDING PROGRAM '                        
              DISPLAY '   7500-GET-PND-PRIOR-DATE'                      
              DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND       THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **      GET THE NORMAL CSC AMOUNT FOR THE CUSTOMER            **          
      ****************************************************************          
      *                                                                         
A01673 7510-GET-NRML-CSC-AMT.                                           
      *                                                                         
A01673     EXEC SQL                                                     
A01673         SELECT J4.AMT_CUST_CHRG                                  
A01673           INTO :J4-AMT-CUST-CHRG                                 
A01673           FROM CSS_RATE_VRSN_DEF J4 WITH(READUNCOMMITTED)                
A02842          WHERE J4.CODE_UTIL_TYPE   = 'G'                         
A02842            AND J4.RATE_PLAN_NO     = :J4-RATE-PLAN-NO            
A02842            AND J4.VERSION_NO_CNTRL =                             
A02842            (SELECT MAX(RT.VERSION_NO_CNTRL)                      
A02842               FROM CSS_RATE_CREATOR RT WITH(READUNCOMMITTED)             
A02842              WHERE RT.RATE_PLAN_NO      = J4.RATE_PLAN_NO        
A02842                AND RT.CODE_UTIL_TYPE    = J4.CODE_UTIL_TYPE      
A02842                AND RT.CODE_STATUS       = 'A'                    
A02842                AND RT.DISPLAY_START_TS <= 
           CIS.CURRENT$TIMESTAMP())     
A02842                                                           
A02842                                                      
A01673     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT J4.AMT_CUST_CHRG                                          
MFA-TR*          INTO :J4-AMT-CUST-CHRG                                         
MFA-TR*          FROM CSS_RATE_VRSN_DEF J4                                      
MFA-TR*         WHERE J4.CODE_UTIL_TYPE   = 'G'                                 
MFA-TR*           AND J4.RATE_PLAN_NO     = :J4-RATE-PLAN-NO                    
MFA-TR*           AND J4.VERSION_NO_CNTRL =                                     
MFA-TR*           (SELECT MAX(RT.VERSION_NO_CNTRL)                              
MFA-TR*              FROM CSS_RATE_CREATOR RT                                   
MFA-TR*             WHERE RT.RATE_PLAN_NO      = J4.RATE_PLAN_NO                
MFA-TR*               AND RT.CODE_UTIL_TYPE    = J4.CODE_UTIL_TYPE              
MFA-TR*               AND RT.CODE_STATUS       = 'A'                            
MFA-TR*               AND RT.DISPLAY_START_TS <= CURRENT TIMESTAMP)             
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7510                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A01673     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
A02842     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR  NOT-FOUND    
A02842        CONTINUE                                                  
A02842     ELSE                                                         
A02842        DISPLAY '******************************************'      
A02842        DISPLAY '** PROCESSING ERROR IN PROGRAM PCSCA155 **'      
A02842        DISPLAY '**      PARA 7510-GET-NRML-CSC-AMT      **'      
A02842        DISPLAY '**  ACCOUNT NO   = ' AT-ACCOUNT-NO               
A02842        DISPLAY '**  RATE PLAN NO = ' J4-RATE-PLAN-NO             
A02842        DISPLAY '**        PROCESSING TERMINATED         **'      
A02842        DISPLAY '******************************************'      
A02842        PERFORM 9900-ABEND THRU 9900-EXIT                         
A02842     END-IF.                                                      
      *                                                                         
A01673 7510-EXIT.                                                       
A01673     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   7550-GET-FNL-PRIOR-DATE.                                 **          
      **      GET THE DATE PARM PRIOR TO CURRENT DATE TO FILTER     **          
      **      THE FINALED ACCOUNTS IN MAIN CURSOR                   **          
      ****************************************************************          
      *                                                                         
       7550-GET-FNL-PRIOR-DATE.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT
              DATEADD(D, (CIS.DAYS(CAST(SYSDATETIMEOFFSET() AS DATE))          
                                     - :WS-F-DAYS)-1, 
              CAST('00010101' AS DATE))
            INTO
              :WS-PRIOR-FNL-DATE                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-PRIOR-FNL-DATE = DATE(DAYS(CURRENT DATE)                  
MFA-TR*                              - :WS-F-DAYS)                              
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '*******************************************'     
              DISPLAY '       ABENDING PROGRAM '                        
              DISPLAY '   7550-GET-FNL-PRIOR-DATE'                      
              DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND       THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       7550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A04527******************************************************************        
A04527*  6251-GET-FJC01-DATE                                           *        
A04527******************************************************************        
A04527     EXEC SQL                                                             
A04527          INCLUDE CPD00037                                                
A04527     END-EXEC.                                                            
A04527                                                                  
      ******************************************************************        
      **    7600-START-FCSJC01                                        **        
      ******************************************************************        
      *                                                                         
            EXEC SQL                                                            
              INCLUDE CPD00038                                                  
            END-EXEC.                                                           
                                                                        
A04527******************************************************************        
A04527*  7620-START-FCSCA00                                            *        
A04527******************************************************************        
A04527     EXEC SQL                                                             
A04527        INCLUDE CPD00039                                                  
A04527     END-EXEC.                                                            
A04527                                                                  
A04527******************************************************************        
A04527* COPY BOOK TO GET COMMON DATE FROM JOB PARM                     *        
A04527******************************************************************        
A04527     COPY CPD00040.                                                       
                                                                        
A04527****************************************************************          
A04527**                                                            **          
A04527** 7700-OPEN-DSCNT-CURSOR.                                    **          
A04527****************************************************************          
A04527 7700-OPEN-DSCNT-CURSOR.                                          
A04527                                                                  
A04527     EXEC SQL                                                     
A04527         OPEN DSCNT_CUR                                           
A04527     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04527                                                                  
A04527     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A04527                                                                  
A04527     IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
A04527         DISPLAY '*******************************************'    
A04527         DISPLAY '       ABENDING PROGRAM '                       
A04527         DISPLAY '       OPEN DSCNT_CUR   '                       
A04527         DISPLAY '       7700-OPEN-DSCNT-CURSOR'                  
A04527         DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE    
A04527         DISPLAY ' ACCOUNT-NO        = ' FF-ACCOUNT-NO            
A04527         DISPLAY ' UTIL-TYPE         = ' FF-CODE-UTIL-TYPE        
A04527         DISPLAY ' IC-NO             = ' FF-IC-NO                 
A04527         DISPLAY ' RT-PKG-OPT-SEQ-NO = ' FF-RT-PKG-OPT-SEQ-NO     
A04527         DISPLAY '*******************************************'    
A04527         PERFORM 9900-ABEND      THRU 9900-EXIT                   
A04527     END-IF.                                                      
A04527                                                                  
A04527 7700-EXIT.                                                       
A04527     EXIT.                                                        
A04527*                                                                         
A04527****************************************************************          
A04527**                                                            **          
A04527** 7710-FETCH-DSCNT-CURSOR.                                   **          
A04527****************************************************************          
A04527 7710-FETCH-DSCNT-CURSOR.                                         
A04527                                                                  
A04527     EXEC SQL                                                     
A04527         FETCH DSCNT_CUR                                          
A04527          INTO :FF-FACTOR                                         
A04527              ,:SF-RT-ATTR-INCTV-TYPE                             
A04527     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04527                                                                  
A04527     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
A04527                                                                  
A04527     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR  NOT-FOUND    
A04527        CONTINUE                                                  
A04527     ELSE                                                         
A04527        DISPLAY '*******************************************'     
A04527        DISPLAY '       ABENDING PROGRAM '                        
A04527        DISPLAY '       FETCH DSCNT_CUR   '                       
A04527        DISPLAY '       7710-FETCH-DSCNT-CURSOR '                 
A04527        DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE     
A04527        DISPLAY ' ACCOUNT-NO        = ' FF-ACCOUNT-NO             
A04527        DISPLAY ' UTIL-TYPE         = ' FF-CODE-UTIL-TYPE         
A04527        DISPLAY ' IC-NO             = ' FF-IC-NO                  
A04527        DISPLAY ' RT-PKG-OPT-SEQ-NO = ' FF-RT-PKG-OPT-SEQ-NO      
A04527        DISPLAY '*******************************************'     
A04527        PERFORM 9900-ABEND      THRU 9900-EXIT                    
A04527     END-IF.                                                      
A04527                                                                  
A04527 7710-EXIT.                                                       
A04527     EXIT.                                                        
A04527*                                                                         
A04527****************************************************************          
A04527**                                                            **          
A04527** 7720-CLOSE-DSCNT-CURSOR.                                   **          
A04527****************************************************************          
A04527 7720-CLOSE-DSCNT-CURSOR.                                         
A04527                                                                  
A04527     EXEC SQL                                                     
A04527         CLOSE DSCNT_CUR                                          
A04527     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04527                                                                  
A04527     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
A04527                                                                  
A04527     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
A04527        DISPLAY '*******************************************'     
A04527        DISPLAY '       ABENDING PROGRAM '                        
A04527        DISPLAY '      CLOSE DSCNT_CUR   '                        
A04527        DISPLAY '      7720-CLOSE-DSCNT-CURSOR '                  
A04527        DISPLAY ' RETURN CODE       = ' WS-ACTIVE-RETURN-CODE     
A04527        DISPLAY ' ACCOUNT-NO        = ' FF-ACCOUNT-NO             
A04527        DISPLAY ' UTIL-TYPE         = ' FF-CODE-UTIL-TYPE         
A04527        DISPLAY ' IC-NO             = ' FF-IC-NO                  
A04527        DISPLAY ' RT-PKG-OPT-SEQ-NO = ' FF-RT-PKG-OPT-SEQ-NO      
A04527        DISPLAY '*******************************************'     
A04527        PERFORM 9900-ABEND       THRU 9900-EXIT                   
A04527     END-IF.                                                      
A04527*                                                                         
A04527 7720-EXIT.                                                       
A04527     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **     8000-WRITE-FCA155-RECORD.                                **        
      ******************************************************************        
      *                                                                         
       8000-WRITE-FCA155-RECORD.                                        
      *                                                                         
           WRITE FIOCA155.                                              
                                                                        
           IF WS-FCA155-STATUS = '00'                                   
              ADD +1                        TO WS-CA155-RECS-WRITE      
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  9000-TERMINATE                                            **          
      **       PROGRAM WRAP UP                                      **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSCA155-FILE.                                         
                                                                        
           DISPLAY '*******************************************'.       
           DISPLAY '           PCSCA155 ENDING '.                       
           DISPLAY '*******************************************'.       
           DISPLAY '           PROGRAM SUMMARY'.                        
           DISPLAY '*******************************************'.       
           DISPLAY ' ACCOUNTS EXTRACTED : '  WS-CA155-RECS-WRITE.       
           DISPLAY '*******************************************'.       
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  9900-ABEND INCLUDES SQL ROLLBACK                          **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
