       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   PCSCA153.                                          
       AUTHOR.       SIDDHARTHA SARKAR (COVANSYS).                      
       DATE-WRITTEN. DEC 2007.                                          
       DATE-COMPILED.                                                   
      ******************************************************************        
      **               SOUTH CAROLINA ELECTRIC & GAS                  **        
      **                         BILLING                              **        
      **                        COBOL-DB2                             **        
      ******************************************************************        
      **                     PROGRAM SUMMARY                          **        
      ******************************************************************        
      ** - THIS PROGRAM CREATES A LIST OF NEW SEB ACCOUNTS WHICH HAVE **        
      **   BEEN ACTIVATED TO SEND A WELCOME KIT. THE OUTPUT FILE IS   **        
      **   USED BY THE BILL PRINT SYSTEM TO GENERATE DISCLOSURE       **        
      **   STATEMENT AND THE PRICING SHEET TO BE SENT AS A COVERING   **        
      **   LETTER WITH THE WELCOME KIT.                               **        
P00245** - ADDITIONALLY THIS PROGRAM WILL ALSO EXTRACT THE ACCOUNTS   **        
P00245**   FOR THE RATE CHANGE LETTER IN FIOCA916 FORMAT.             **        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     INPUT PROCESSING CONTROL PATH         **        
      **        2000 - 2999     OUTPUT PROCESS CONTROL PATH           **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     COMMON SYSTEM MODULES                 **        
      **        7000 - 7999     INPUT MODULES                         **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      **                PROGRAM  MODIFICATION  LOG                    **        
      ******************************************************************        
      ** DATE     USERID   REASON                                     **        
      ** -------  -------  ------                                     **        
      ** 12/2007  SS97726  INITIAL IMPLEMENTATION.                    **        
      ** 03/2007  SS97726  MODIFY DATE RANGE CONDITION FOR SERVICE    **        
      **          CML36209 ORDER QUERY TO INCLUDE CURRENT DATE'S ACTS **        
      ** 04/2007  SS97726  MODIFY PROGRAM FOR SEB RATE RE-ENGINEERING **        
      **          CML34569                                            **        
      ** 06/2008  SS97726  1. RECYCLE THE EXCEPTION REPORT ACCOUNTS   **        
      **          T34569   2. INSERT TRANSACTION HIST AND COMMN ROW   **        
      **                   3. MODIFY FIXED RATE START/END LOGIC       **        
A00765** 02/2009  CVNS     ADDED 9000-SEND-ERROR-RESULT PARA.         **        
A00765**          CHENNAI                                             **        
P00141** 04/2009  SS97726  UPDATE FIXED RATE EXIT FEE FROM $50 TO $100**        
P00141**          P00141                                              **        
PRODFX** 07/2009  SS97726  CORRECT THE START/END DATE LOGIC.          **        
A01339** 07/2009  VY95550  VARCHAR FIELD INITIALIZATION               **        
A37061** 07/2009  VY95550  REPLACED CODE_REV_CLASS MID DIG CHECK WITH **        
A37061**                   ACCOUNT_TYPE_CODE CHANGES.                 **        
A37741** 11/2009  MC95456  DECLARED  S-RETURN-CODE RESPECTIVE  TO     **        
A37741**                   CPD00067 CHANGES.                          **        
P00245** 12/2009  SS97726  1. AUTOMATE RATE CHANGE LETTER.            **        
P00245**                   2. PRICE SHEET LETTER ENHANCEMENTS.        **        
P00245** 06/2010  SJ94244  UPDATE ORIGINATION CD IN CSS_MKT_XREF_ACCT **        
P00245**                   TABLE.                                     **        
A00775** 07/2010  SJ97149  HANDLING OF -803 ABEND,ADDING QUERYNO      **        
A00775**          ACT0016                                             **        
A02672** 10/2010  MC95456  PASS WEB EXTERNAL LONG DESCRIPTION FOR     **        
A02672**                   RATE CHANGE LETTERS                        **        
A02003** 12/2010  SV95326  RENAMING OF VARIABLES FROM FIOCA916.       **        
ACT072** 03/2011  BD09555  APPL 3082 REVMOVE INDUSTRIAL ACCOUNTS      **        
A03280** 04/2011  DM94438  ADD NEW RATE RENEWAL PROGRAM NAME          **        
P00453** 02/2011  MN90523  POPULATE 'P' FOR PRP ACCOUNTS      .       **        
A03692** 10/2011  DB41297  CHECK FOR PENDING STATUS CHANGE DATE       **        
P00581** 12/13/11 NC94746  SEB FEE INCREASE: GET VARIOUS DELINQUECY   **        
P00581**                   CODES RELATED TO FEES FROM JOB PARM USING  **        
P00581**                   EFFECTIVE DATES AND GET DELINQUENCY VALUES **        
P00581**                   AND APPLY TO ACCOUNTS BASED ON ACCOUNT TYPE**        
P00473** 02/21/12 MS93554  CHGS INCLUDED TO RETRIEVE APPROVED VERSION **        
A04132** 04/2012  DB41297  ADD TS TO PREVENT DUPLICATE LETTERS.       **        
P00680** 05/30/12 MS93554  RETRIEVE DF-STAT-ADJUSTABLE-CD FROM ALL THE**        
P00680**                   CURSORS AND PASS THE VALUE IN TO FIOCA916  **        
P00680**                   LAYOUT TO BILL PRINT.                      **        
P00680**          SV95326  PASS FLEX RATE COUNT AND DISCOUNTS.        **        
P00677** 07/24/12 HA7A338  1.MODIFIED ALL_JOB_PARM CURSOR TO INCLUDE  **        
P00677**                     NEWLY ADDED T&C FIELDS                   **        
P00677**                   2.MODIFIED 2200- PARA TO MOVE DELINQ VALUE **        
P00677**                     TO THE WS- VARIABLES                     **        
P00677**                   3.MODIFIED 2000- PARA TO MOVE VALUES TO    **        
P00677**                     NEWLY ADDED 916 LAYOUT FIELDS.           **        
P00677**                   4.MODIFIED PARA 1020- TO SKIP SENDING RATE **        
P00677**                     CHANGE LETTER FOR REGULATED DROP ACCOUNTS**        
P00677**                   5.MODIFIED PARA 2000- TO NOT TO MOVE       **        
P00677**                     AGRMT-EFF-DT TO FEE-EFF-DATE FOR REG CUST**        
P00677**                   6.RENAMED WS-CURRENT-DATE TO WS-COMMON-DATE**        
PRDFIX** 08/09/12 GD43988  P00677:TEMP PROD FIX TO SWAP RATE CHNG WITH**        
PRDFIX**                   WELCOME KIT(REG CUSTOMERS)                 **        
A04347** 09/07/12 HA7A338  ROLLBACK TEMP 2012 TRANSITION CODE.        **        
A04347**                   REMOVED BELOW CODE CHANGES                 **        
A04347**                   1.PARA 1020- TO SKIP SENDING RATE CHANGE   **        
A04347**                     LETTER FOR REGULATED DROP ACCOUNTS       **        
A04347**                   2.PARA 2000- TO NOT TO MOVE AGRMT-EFF-DT TO**        
A04347**                     FEE-EFF-DATE FOR REG CUST                **        
PRJ680** 09/11/12 SS97726  CUSTOMER RETENTION & ACQUISITION DISCOUNTED**        
PRJ680**                   RATES/CSC CHANGES.                         **        
P00805** 02/06/14 SS97726  EXTENDED EARLY RENEWAL - SEND RATE CHANGE  **        
P00805**                   FOR PENDING OPTION WHEN IT'S SET ON ACCOUNT**        
ACT229** 09/12/14 SS97726  SKIP GENERATING WELCOME KIT AND RATE CHANGE**        
ACT229**   A04880          LETTERS WHEN ACCT ATTRIBUTE IS ACTIVE      **        
A05037** 09/25/14 SS97726  INCREASE $8.50 TRANSPORTATION TO $8.70     **        
ACT091** 04/27/15 VIJAY    FIX TO GET DISCOUNT FACTOR IN WELCOME KIT  **        
ACT091** A05136            PROCESS.                                   **        
P00892** 07/15/15 VIJAY    CREATE OPTED IN LETTER PROCESS FOR FRCO    **        
P00892**                   PROJECT.                                   **        
ACT192** 10/01/15 VIJAY    DO NOT GENERATE OPT-IN LETTER IF OPTED IN  **        
ACT192** A05136            DURING RATE CHANGE PROCESS AS OPT-IN MESSAGE         
ACT192** A05136            IS ALREADY INCLUDED IN RATE CHANGE LETTER.           
ACT200** 10/14/15 VIJAY    OPT-IN MESSAGE NOT GENERATED IN WELCOME KIT**        
ACT200** A05136            LETTER.                                              
ACT207** 10/20/15 VIJAY    DO NOT GENERATED RATE CHANGE LTR ON THE DAY**        
ACT207** A05136            WELCOME KIT IS GENERATED.                            
ACT241** 11/23/15 VIJAY    FIX EXPIRATION DATE DISPLAY ON OPTIN LETTER**        
ACT241** A05136                                                                 
ACT208** 10/22/15 VIJAY  1.GENERATE RATE CHANGE LETTER REGARDLESS OF  **        
ACT208** A05136            WHETHER ACCOUNT IS BILLED OR NOT.          **        
ACT208**                 2.PASS RENEWAL OPTION DESCRIPTION.           **        
P805CS** 03/21/16 SS45239  PASS ADDITIONAL INFO FOR CSC DISCOUNTS.    **        
I02262** 10/18/16 SS45239  FIX DDDC PRINT ISSUE.                      **        
PFX001** 01/10/17 SS45239  FIX ISSUE WITH WELCOME KITS FOR TRANSFERS  **        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
C34569 COPY CSSCA916.                                                           
      *                                                                         
C34569     SELECT EXCEP153-FILE   ASSIGN TO UT-S-EXCEP153               
C34569         FILE STATUS IS WS-E153-STATUS.                           
C34569*                                                                         
T34569     SELECT PXCEP153-FILE   ASSIGN TO UT-S-PXCEP153               
T34569         FILE STATUS IS WS-P153-STATUS.                           
T34569*                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
C34569 COPY CFDCA916.                                                           
C34569*                                                                         
C34569 COPY FIOCA916.                                                           
      *                                                                         
C34569 FD  EXCEP153-FILE                                                
C34569     BLOCK CONTAINS  0 RECORDS                                    
P00245     RECORD CONTAINS 110 CHARACTERS                               
C34569     RECORDING MODE  IS F                                         
C34569     LABEL RECORDS   ARE STANDARD.                                
C34569                                                                  
P00245 01  EXCEP153-REC                    PIC X(110).                  
      *                                                                         
T34569 FD  PXCEP153-FILE                                                
T34569     BLOCK CONTAINS  0 RECORDS                                    
P00245     RECORD CONTAINS 110 CHARACTERS                               
T34569     RECORDING MODE  IS F                                         
T34569     LABEL RECORDS   ARE STANDARD.                                
T34569                                                                  
T34569 01  PXCEP153-REC.                                                
T34569     05 HEADER-1.                                                 
T34569        10 HDR1-DATE-TXT             PIC X(6).                    
T34569        10 HDR1-LAST-RUN-DATE        PIC X(10).                   
P00245        10 FILLER                    PIC X(94).                   
T34569     05 DETAIL-LINE REDEFINES HEADER-1.                           
T34569        10 DETAIL-ACCOUNT-NO         PIC 9(13).                   
T34569        10 FILLER                    PIC X(05).                   
T34569        10 DETAIL-CODE-ACCT-STAT     PIC X(01).                   
T34569        10 FILLER                    PIC X(05).                   
T34569        10 DETAIL-RATE-PLAN          PIC X(03).                   
P00245        10 FILLER                    PIC X(08).                   
P00245        10 DETAIL-ORIGINATION-CD     PIC X(01).                   
P00245        10 FILLER                    PIC X(09).                   
P00245        10 DETAIL-SVC-START-DATE     PIC X(10).                   
P00245        10 FILLER                    PIC X(55).                   
T34569     05 NO-DATA-LINE REDEFINES HEADER-1.                          
P00245        10 FILLER                    PIC X(43).                   
T34569        10 NO-DATA-TEXT              PIC X(25).                   
P00245        10 FILLER                    PIC X(42).                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ008  01 MSQ008-ALL-JOB-PARM  PIC S9(9) COMP-5.
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA153'.
MSQ017     COPY MFASQLM.
       01  WS-START                        PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSCA153 STARTS HERE'.            
                                                                        
       01  WS-WORK-VARIABLES.                                           
P00245     05  WS-ONMD-ACCTS-PROCESSED     PIC 9(7).                    
P00245     05  WS-MKSW-ACCTS-PROCESSED     PIC 9(7).                    
P00245     05  WS-RTCHG-ACCTS-PROCESSED    PIC 9(7).                    
P00892     05  WS-OPTIN-ACCTS-PROCESSED    PIC 9(7).                    
P00245     05  WS-PRC-SHT-SKIP-COUNT       PIC 9(7).                    
P00245     05  WS-RTCHG-SKIP-COUNT         PIC 9(7).                    
P00892     05  WS-OPTIN-SKIP-COUNT         PIC 9(7).                    
P00245     05  WS-PRC-SHT-LTR-COUNT        PIC 9(7).                    
P00245     05  WS-RTCHG-LTR-COUNT          PIC 9(7).                    
P00245     05  WS-EXCP-RECS-LTR-COUNT      PIC 9(7).                    
P00245     05  WS-EXCP-RECS-PROCESSED      PIC 9(7).                    
P00245     05  WS-EXCP-RECS-WRITTEN        PIC 9(7).                    
C34569     05  DDC-CNT                     PIC S9(5) COMP-3 VALUE +0.   
P805CS     05  LRATE-CNT                   PIC S9(5) COMP-3 VALUE +0.   
P805CS     05  ORATE-CNT                   PIC S9(5) COMP-3 VALUE +0.   
P805CS     05  WS-SPCL-RATE-PLAN-NO        PIC X(03) VALUE SPACES.      
P805CS     05  WS-SPCL-RATE-PLAN-TYPE      PIC X(12) VALUE SPACES.      
P805CS     05  WS-DISCOUNT-TYPE            PIC X(09) VALUE SPACES.      
P805CS     05  WS-AUTORENEW-DSCNT-AMT      PIC S9(4)V9(5) COMP-3        
P805CS                                               VALUE 0.           
P805CS     05  WS-PAPERLESS-DSCNT-AMT      PIC S9(4)V9(5) COMP-3        
P805CS                                               VALUE 0.           
           05  WS-NULL-DEPOSIT-AMT         PIC S9(4) COMP.              
C34569     05  WS-COMMON-REV-MNTH          PIC 9(6)  VALUE ZEROS.       
C34569     05  WS-NULL-IND-01              PIC S9(4) COMP VALUE 0.      
C34569     05  WS-HOLD-REV-MNTH            PIC 9(6)  VALUE ZEROS.       
P00245     05  WS-HOLD-MKSW-START-DT.                                   
P00245         10 WS-HOLD-MKSW-START-YR    PIC X(4)  VALUE SPACES.      
P00245         10 WS-HOLD-MKSW-START-MM    PIC X(2)  VALUE SPACES.      
P00245     05  WS-HOLD-MKSW-START-RED REDEFINES WS-HOLD-MKSW-START-DT.  
P00245         10 WS-HOLD-MKSW-START-NUM   PIC 9(6).                    
C34569     05  WS-HOLD-REV-MNTH-RED.                                    
C34569         10 WS-HOLD-REV-MNTH-YR      PIC 9(4)  VALUE ZEROS.       
C34569         10 WS-HOLD-REV-MNTH-MM      PIC 9(2)  VALUE ZEROS.       
PRODFX     05  WS-HOLD-DURATION-REM        PIC S9(4) USAGE COMP.        
PRODFX     05  WS-DUMMY-DATE.                                           
PRODFX         10 WS-DUMMY-DT-YYYY         PIC X(4)  VALUE SPACES.      
PRODFX         10 WS-DUMMY-DT-F1           PIC X(1)  VALUE '-'.         
PRODFX         10 WS-DUMMY-DT-MM           PIC X(2)  VALUE SPACES.      
PRODFX         10 WS-DUMMY-DT-F2           PIC X(1)  VALUE '-'.         
PRODFX         10 WS-DUMMY-DT-DD           PIC X(2)  VALUE SPACES.      
PRODFX     05  WS-RESULT-DT.                                            
PRODFX         10 WS-RESULT-DT-YYYY        PIC X(4)   VALUE SPACES.     
PRODFX         10 WS-RESULT-DT-MM          PIC X(2)   VALUE SPACES.     
P00677     05  WS-COMMON-DATE              PIC X(10).                   
P00892     05  WS-OPTIN-60DAY-DATE         PIC X(10).                   
C34569     05  WS-E153-STATUS              PIC X(02) VALUE '  '.        
C34569         88  E153-SUCCESSFUL                   VALUE '00'.        
T34569     05  WS-P153-STATUS              PIC X(02) VALUE '  '.        
T34569         88  P153-SUCCESSFUL                   VALUE '00'.        
T34569         88  P153-END-FILE                     VALUE '10'.        
C34569     05  WS-SUBJECT.                                              
C34569         10  FILLER                  PIC X(13)   VALUE            
C34569                                                 'SEBC 153 FOR '. 
C34569         10  WS-SUB-DATE             PIC X(10).                   
T34569     05  WS-TIMESTAMP                PIC X(26) VALUE SPACES.      
                                                                        
T34569     05  WS-DISPLAY-SQLCODE          PIC -ZZZZZZZZ9.              
T34569     05  WS-RED-FL-NULL-IND          PIC S9(4) COMP  VALUE 0.     
T34569     05  WS-END-NULL-IND             PIC S9(4) COMP  VALUE 0.     
P00245     05  WS-PREV-OPT-CALC-TYPE-CD    PIC X(02) VALUE SPACES.      
P00805     05  WS-TEMP-RT-CALC-TYPE-CD     PIC X(02) VALUE SPACES.      
A05037     05  WS-SEARCH-RATE-PLAN-NO      PIC X(03) VALUE SPACES.      
A04132     05  WS-LAST-RUN-DATE-TS         PIC X(26).                   
A04132     05  WS-COMMON-RUN-DATE-TS       PIC X(26).                   
COB305     05 WS-RECONN-CHRG        PIC S9(4)V9(5) COMP-3 VALUE 0.       
COB305     05 WS-NEW-CONN-CHRG        PIC S9(4)V9(5) COMP-3 VALUE 0.       
COB305     05 WS-RET-CHK-CHRG        PIC S9(4)V9(5) COMP-3 VALUE 0.       
COB305     05 WS-MTR-SET-CHRG        PIC S9(4)V9(5) COMP-3 VALUE 0.       
COB305     05 WS-SEAS-CONN-CHRG        PIC S9(4)V9(5) COMP-3 VALUE 0.       
COB305     05 WS-RESI-EXIT-FEE        PIC S9(4)V9(5) COMP-3 VALUE 0.       
COB305     05 WS-COMM-EXIT-FEE        PIC S9(4)V9(5) COMP-3 VALUE 0.       
COB305     05 WS-MAX-RESI-DEP        PIC S9(4)V9(5) COMP-3 VALUE 0.       
COB305     05 WS-REG-MAX-DEP        PIC S9(4)V9(5) COMP-3 VALUE 0.       
COB305     05 WS-G2SR-MAX-DEP        PIC S9(4)V9(5) COMP-3 VALUE 0.       
COB305     05 WS-REG-SR-DISC        PIC S9(4)V9(5) COMP-3 VALUE 0.       
COB305     05 WS-G2-GOOD-DISC        PIC S9(4)V9(5) COMP-3 VALUE 0.       
COB305     05 WS-REG-FIX-ADJFACT        PIC S9(4)V9(5) COMP-3 VALUE 0.       
COB305     05 WS-G2-FIX-WTAV-FACT        PIC S9(4)V9(5) COMP-3 VALUE 0.       
COB305     05 WS-G1-SR-CSC        PIC S9(4)V9(5) COMP-3 VALUE 0.       
COB305     05 WS-REG-STD-CSC        PIC S9(4)V9(5) COMP-3 VALUE 0.       
COB305     05 WS-G2-GOOD-PYMT-CSC        PIC S9(4)V9(5) COMP-3 VALUE 0.       
P00581     05  WS-FEE-EFF-DATE             PIC X(10) VALUE SPACES.      
P00581     05  WS-RATE-GROUP-DEF           PIC X(03) VALUE SPACES.      
P00581         88 WS-DREG                  VALUE SPACES.                
P00581         88 WS-REG-GROUP1            VALUE '100'.                 
P00581         88 WS-REG-GROUP2            VALUE '200'.                 
P00581     05  WS-ACCOUNT-TYPE-CODE        PIC X(01) VALUE SPACES.      
P00581         88 WS-RESIDENTIAL           VALUE 'R'.                   
P00581         88 WS-COMMERCIAL            VALUE 'C'.                   
P00581         88 WS-OTHER-ACCT-TYPES      VALUE ' '.                   
P00581     05  WS-TIER-ACCT-TYPE-CODE      PIC X(01) VALUE SPACES.      
P00581         88 MKT-REQUIRED-ACCT-TYPES    VALUE                      
P00581                                      'D' 'A' '1' '2' 'S' 'B'.    
P00581         88 MKT-DEREG-RESIDENTIAL        VALUE 'D'.               
P00581         88 MKT-ACN-RESIDENTIAL          VALUE 'A'.               
P00581         88 MKT-GROUP1-RESIDENTIAL       VALUE '1'.               
P00581         88 MKT-GROUP2-RESIDENTIAL       VALUE '2'.               
P00581         88 MKT-SMALL-COMMERCIAL         VALUE 'S'.               
P00581         88 MKT-BUSI-OWNER-RESIDENTIAL   VALUE 'B'.               
       01  WS-811                          PIC S9(4) COMP VALUE -811.   
PRODFX 01  WS-DUMMY-DATE-TEMP              PIC X(10) VALUE SPACES.      
PRODFX 01  WS-RESULT-DATE                  PIC X(10) VALUE SPACES.      
P00245 01  WS-ONMD-SVC-START-DT            PIC X(10) VALUE SPACES.      
A00775 01  WS-803-CTR                      PIC 9(01) VALUE 0.           
A00775 01  WS-INSERTED                     PIC X(01) VALUE ' '.         
A00775     88 INSERTED                               VALUE 'Y'.         
A00775     88 NOT-INSERTED                           VALUE 'N'.         
A00775 01  WS-803                          PIC S9(9) VALUE -803 COMP.   
                                                                        
A37741 01  S-RETURN-CODE                   PIC S9(9) VALUE 0.           
                                                                        
C34569 01  WS-DDDC-TABLE.                                               
C34569     05 WS-DDDC-TBL OCCURS 0 TO 999                               
C34569                    DEPENDING ON DDC-CNT                          
C34569                    ASCENDING KEY DDC-RATE-PLAN-NO                
C34569                    INDEXED BY DDC-IND.                           
C34569        10 DDC-RATE-PLAN-NO          PIC X(3).                    
C34569        10 DDC-FACTOR                PIC S9(3)V99.                
C34569                                                                  
P805CS 01  WS-LEGACY-RATES-TABLE.                                       
P805CS     05 WS-LEGACY-RATES-TBL OCCURS 0 TO 999                       
P805CS                            DEPENDING ON LRATE-CNT                
P805CS                            ASCENDING KEY LEGACY-RATE-PLAN-NO     
P805CS                            INDEXED BY LRATE-INDX.                
P805CS        10 LEGACY-RATE-PLAN-NO       PIC X(3).                    
P805CS                                                                  
P805CS 01  WS-OLD-RATES-TABLE.                                          
P805CS     05 WS-OLD-RATES-TBL OCCURS 0 TO 999                          
P805CS                         DEPENDING ON ORATE-CNT                   
P805CS                         ASCENDING KEY OLD-RATE-PLAN-NO           
P805CS                         INDEXED BY ORATE-INDX.                   
P805CS        10 OLD-RATE-PLAN-NO          PIC X(3).                    
P805CS                                                                  
C34569 01  WS-SUBROUTINE-IDS.                                           
P00245     05  SCSCA328                    PIC X(8)  VALUE 'SCSCA328'.  
                                                                        
       01  WS-CA153-PARM.                                               
           05  WS-CA153-TEXT               PIC X(14).                   
           05  WS-LAST-RUN-DATE            PIC X(10).                   
           05  WS-LAST-RUN-TIME            PIC X(16).                   
                                                                        
       01  WS-LAST-COMMON-PARM.                                         
           05  WS-L-COMMON-TEXT            PIC X(14) VALUE              
               'LAST RUN DATE='.                                        
           05  WS-L-COMMON-RUN-DATE        PIC X(26).                   
                                                                        
       01  WS-COMMON-PARM.                                              
           05  WS-COMMON-TEXT              PIC X(09)                    
                                           VALUE 'RUN DATE='.           
           05  WS-COMMON-RUN-DATE          PIC X(10).                   
                                                                        
C34569 01  WS-FCA916-STATUS                PIC X(2)  VALUE '00'.        
                                                                        
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE              PIC S9(04) COMP VALUE 0.     
           05  RS-RETURN-CODE-DISP         PIC +Z(04).                  
                                                                        
P00581 01  WS-JOB-PARM-TABLE.                                           
P00581     05 WS-JOB-PARM-COUNT        PIC 9(05) VALUE ZERO.            
P00581     05 WS-JP-SUB                PIC 9(05) VALUE ZERO.            
P00581     05 WS-PARSE-PARM-DATA.                                       
P00581        10 WS-PARSE-EFF-DATE            PIC X(10).                
P00581        10 FILLER                       PIC X(01).                
P00581        10 WS-PARSE-NEW-DELINQ-CD       PIC X(20).                
P00581        10 WS-PARSE-OLD-DELINQ-CD       PIC X(20).                
P00677*    CHANGED MAXIMUM LIMIT FROM 25 TO 50 TO ACCOMODATE NEW FIELDS         
P00581     05 WS-ALL-JOB-PARM-ROWS.                                     
P00677        10 TAB-PROGRAM-NAME       OCCURS 50 TIMES  PIC X(10).     
P00677        10 TAB-PARM-DATA          OCCURS 50 TIMES  PIC X(80).     
P00677        10 TAB-PARM-EFF-DATE      OCCURS 50 TIMES  PIC X(10).     
COB305        10 TAB-NEW-DELINQ-VALUE        PIC S9(4)V9(5) 
COB305           OCCURS 50 TIMES COMP-3 VALUE 0.         
COB305        10 TAB-OLD-DELINQ-VALUE        PIC S9(4)V9(5) 
COB305           OCCURS 50 TIMES COMP-3 VALUE 0.         
P00581*                                                                         
       01  WS-CONSTANTS.                                                
           05  WS-PGRMNAME                 PIC X(8)    VALUE 'PCSCA153'.
           05  PROGRAM-NAME                PIC X(8)    VALUE 'PCSCA153'.
C34569     05  WS-EXIT-FEE-CD              PIC X(15)   VALUE 'EXIT FEE'.
           05  WS-INSERT                   PIC X(1)    VALUE 'I'.       
           05  WS-DELETE                   PIC X(1)    VALUE 'D'.       
           05  WS-UPDATE                   PIC X(1)    VALUE 'U'.       
           05  WS-YES                      PIC X(1)    VALUE 'Y'.       
           05  WS-NO                       PIC X(1)    VALUE 'N'.       
           05  WS-Y                        PIC X(1)    VALUE 'Y'.       
P00453     05  WS-ACTIVE                   PIC X(1)    VALUE 'A'.       
           05  WS-N                        PIC X(1)    VALUE 'N'.       
           05  WS-WARNING                  PIC X(1)    VALUE 'W'.       
           05  WS-REJECT                   PIC X(1)    VALUE 'R'.       
P00245     05  WS-BASE-CURSOR-ERR-MSG1     PIC X(52)   VALUE            
P00245          'ONMD ACCOUNT NOT SET UP CORRECTLY IN SEB CRM        '. 
P00245     05  WS-BASE-CURSOR-ERR-MSG2     PIC X(52)   VALUE            
P00245          'MKSW ACCOUNT NOT SET UP CORRECTLY IN SEB CRM        '. 
P00245     05  WS-063-INVL-ERR-MSG         PIC X(52)   VALUE            
P00245          'INVALID RETURN CODE FROM SCSCB063 SUBROUTINE        '. 
P00245     05  WS-328-INVL-ERR-MSG         PIC X(52)   VALUE            
P00245          'INVALID RETURN CODE FROM SCSCA328 SUBROUTINE        '. 
P00245     05  WS-328-NO-RNWL-OPTN-MSG     PIC X(52)   VALUE            
P00245          'NO RENEWAL OPTION CODE RETURNED FROM SCSCA328       '. 
P00245     05  WS-DUR-ZERO-ERR-MSG         PIC X(52)   VALUE            
P00245          'DURATION REMAINING ZERO FOR FIXED RATE ACCOUNT      '. 
P00245     05  WS-TERM-FEE-ERR-MSG         PIC X(52)   VALUE            
P00245          'FIXED RATE TERMINATION FEES NOT FOUND               '. 
P00245     05  WS-MKSW-SVC-START-DT-MSG    PIC X(52)   VALUE            
P00245          'SERVICE START DATE FOR MKSW ACCOUNT NOT FOUND       '. 
T34569*                                                                         
      *****************************************************************         
      **     PUT ANY PROGRAM SWITCH VARIABLES YOU NEED HERE.  IF     **         
      **     POSSIBLE, INCLUDE AT LEAST TWO CONDITION NAMES. IN THE  **         
      **     PROCEDURE DIVISION, USE "SET CONDITION-NAME TO TRUE"    **         
      **     RATHER THAN "MOVE 'Y' TO INDICATOR-VARIABLE-NAME"       **         
      *****************************************************************         
       01  WS-SWITCHES-AND-INDICATORS.                                  
P00245     05  WS-END-ONMD-CURSOR-SW       PIC X(1) VALUE 'N'.          
P00245         88  WS-END-ONMD-CURSOR      VALUE 'Y'.                   
P00245         88  WS-NOT-END-ONMD-CURSOR  VALUE 'N'.                   
P00245     05  WS-END-MKSW-CURSOR-SW       PIC X(1) VALUE 'N'.          
P00245         88  WS-END-MKSW-CURSOR      VALUE 'Y'.                   
P00245         88  WS-NOT-END-MKSW-CURSOR  VALUE 'N'.                   
P00245     05  WS-END-RTCHG-CURSOR-SW      PIC X(1) VALUE 'N'.          
P00245         88  WS-END-RTCHG-CURSOR     VALUE 'Y'.                   
P00245         88  WS-NOT-END-RTCHG-CURSOR VALUE 'N'.                   
P00892     05  WS-END-OPTIN-CURSOR-SW      PIC X(1) VALUE 'N'.          
P00892         88  WS-END-OPTIN-CURSOR     VALUE 'Y'.                   
P00892         88  WS-NOT-END-OPTIN-CURSOR VALUE 'N'.                   
           05  WS-END-GAS-CUR-SW           PIC X(1) VALUE 'N'.          
               88  WS-END-GAS-CUR          VALUE 'Y'.                   
               88  WS-NOT-END-GAS-CUR      VALUE 'N'.                   
C34569     05  WS-END-DDDC-CSR-SW          PIC X(1) VALUE 'N'.          
C34569         88  WS-END-DDDC-CSR         VALUE 'Y'.                   
C34569         88  WS-NOT-END-DDDC-CSR     VALUE 'N'.                   
           05  WS-YES-JOBPARM-UPDATED-SW   PIC X(1) VALUE 'N'.          
               88  WS-YES-JOBPARM-UPDATED  VALUE 'Y'.                   
               88  WS-NO-JOBPARM-UPDATED   VALUE 'N'.                   
           05  WS-FIRST-TIME-SW            PIC X(1) VALUE 'N'.          
               88  FIRST-TIME              VALUE 'Y'.                   
               88  NOT-FIRST-TIME          VALUE 'N'.                   
C34569     05  WS-ACCOUNT-SKIP-SW          PIC X(1) VALUE 'N'.          
C34569         88  SKIP-ACCOUNT            VALUE 'Y'.                   
C34569         88  DONT-SKIP-ACCOUNT       VALUE 'N'.                   
T34569     05  WS-EXCEPTION-PROCESS-SW     PIC X(1) VALUE 'N'.          
T34569         88  PROCESS-EXCEPTION       VALUE 'Y'.                   
T34569         88  DONT-PROCESS-EXCEPTION  VALUE 'N'.                   
T34569     05  WS-EXCEPTION-FLOW           PIC X(1) VALUE 'N'.          
P00245     05  WS-LETTER-TYPE              PIC X(1) VALUE SPACES.       
P00245         88  PRICE-SHEET-LTR-ONMD    VALUE 'A'.                   
P00245         88  PRICE-SHEET-LTR-MKSW    VALUE 'B'.                   
P00245         88  RATE-CHANGE-LTR         VALUE 'C'.                   
P00892         88  OPTED-IN-LTR            VALUE 'I'.                   
P00680     05  WS-END-DISCOUNT-CURSOR-SW   PIC X(1) VALUE 'N'.          
P00680         88  WS-END-DISCOUNT-CURSOR  VALUE 'Y'.                   
P805CS     05  WS-LEGACY-RATE-SW           PIC X(1) VALUE 'N'.          
P805CS         88  LEGACY-RATE             VALUE 'Y'.                   
P805CS         88  NOT-LEGACY-RATE         VALUE 'N'.                   
P805CS     05  WS-OLD-RATE-SW              PIC X(1) VALUE 'N'.          
P805CS         88  OLD-RATE                VALUE 'Y'.                   
P805CS         88  NOT-OLD-RATE            VALUE 'N'.                   
      *                                                                         
C34569 01 WS-HEADING-LINES.                                             
C34569    05 WS-EXC1-HEADER-1.                                          
C34569       10 FILLER                     PIC X(06) VALUE 'DATE: '.    
C34569       10 P-EXC1-DATE                PIC X(10).                   
P00245       10 FILLER                     PIC X(23) VALUE SPACES.      
C34569       10 FILLER                     PIC X(37) VALUE              
C34569                          'PRICE SHEET EXCEPTION ACCOUNTS REPORT'.
P00245       10 FILLER                     PIC X(23) VALUE SPACES.      
C34569       10 FILLER                     PIC X(11) VALUE              
C34569                                         'PCSCA153-01'.           
C34569    05 WS-EXC1-HEADER-2.                                          
C34569       10 FILLER                     PIC X(14) VALUE              
C34569                                         'ACCOUNT NUMBER'.        
P00245       10 FILLER                     PIC X(02) VALUE SPACES.      
T34569       10 FILLER                     PIC X(06) VALUE              
T34569                                         'STATUS'.                
P00245       10 FILLER                     PIC X(02) VALUE SPACES.      
P00245       10 FILLER                     PIC X(04) VALUE              
P00245                                         'RATE'.                  
P00245       10 FILLER                     PIC X(02) VALUE SPACES.      
P00245       10 FILLER                     PIC X(11) VALUE              
P00245                                         'ORIGINATION'.           
P00245       10 FILLER                     PIC X(02) VALUE SPACES.      
P00245       10 FILLER                     PIC X(13) VALUE              
P00245                                         'SERVICE START'.         
P00245       10 FILLER                     PIC X(18) VALUE SPACES.      
C34569       10 FILLER                     PIC X(17) VALUE              
C34569                                         'EXCEPTION MESSAGE'.     
P00245       10 FILLER                     PIC X(19) VALUE SPACES.      
C34569*                                                                         
P00245    05 WS-EXC1-HEADER-3.                                          
P00245       10 FILLER                     PIC X(24) VALUE SPACES.      
P00245       10 FILLER                     PIC X(04) VALUE              
P00245                                         'PLAN'.                  
P00245       10 FILLER                     PIC X(05) VALUE SPACES.      
P00245       10 FILLER                     PIC X(04) VALUE              
P00245                                         'CODE'.                  
P00245       10 FILLER                     PIC X(11) VALUE SPACES.      
P00245       10 FILLER                     PIC X(04) VALUE              
P00245                                         'DATE'.                  
P00245       10 FILLER                     PIC X(58) VALUE SPACES.      
P00245*                                                                         
C34569 01 WS-DETAIL-LINES.                                              
C34569    05 WS-EXCP-LINE.                                              
C34569       10 EL-ACCT-NO                 PIC X(13) VALUE SPACES.      
T34569       10 FILLER                     PIC X(05) VALUE SPACES.      
T34569       10 EL-CODE-ACCT-STAT          PIC X(01) VALUE SPACES.      
T34569       10 FILLER                     PIC X(05) VALUE SPACES.      
T34569       10 EL-RATE-PLAN-NO            PIC X(03) VALUE SPACES.      
P00245       10 FILLER                     PIC X(08) VALUE SPACES.      
P00245       10 EL-ORIGINATION-CD          PIC X(01) VALUE SPACES.      
P00245       10 FILLER                     PIC X(09) VALUE SPACES.      
P00245       10 EL-SVC-START-DATE          PIC X(10) VALUE SPACES.      
P00245       10 FILLER                     PIC X(03) VALUE SPACES.      
P00245       10 EL-MESSAGE                 PIC X(52) VALUE SPACES.      
C34569*                                                                         
P00245 01 WS-LINE-110                      PIC X(110) VALUE ALL '-'.    
C34569*                                                                         
C34569                                                                  
C34569 01 MAILHEAD-1.                                                   
C34569    05 FILLER                        PIC X(22) VALUE              
C34569         'HELO DOMAIN:     SCANA'.                                
C34569*                                                                         
C34569 01 MAILHEAD-2.                                                   
C34569    05 FILLER                        PIC X(14) VALUE              
C34569         'MAIL FROM:   <'.                                        
C34569    05 MAIL2-JOB-NAME                PIC X(07).                   
C34569    05 FILLER                        PIC X(20) VALUE              
C34569         '@SCEGJES2.SCANA.COM>'.                                  
C34569*                                                                         
C34569 01 MAILHEAD-3.                                                   
C34569    05 FILLER                        PIC X(32) VALUE              
C34569         'RCPT TO: <SEBC153EXCP@SCANA.COM>'.                      
C34569*                                                                         
C34569 01 MAILHEAD-4.                                                   
C34569    05 FILLER                        PIC X(04) VALUE              
C34569         'DATA'.                                                  
C34569*                                                                         
C34569 01 MAILHEAD-5.                                                   
C34569    05 FILLER                        PIC X(18) VALUE              
C34569         'FROM: CSR PAGING <'.                                    
C34569    05 MAIL5-JOB-NAME                PIC X(07).                   
C34569    05 FILLER                        PIC X(20) VALUE              
C34569         '@SCEGJES2.SCANA.COM>'.                                  
C34569*                                                                         
C34569 01 MAILHEAD-6.                                                   
C34569    05 FILLER                        PIC X(27) VALUE              
C34569         'TO: <SEBC153EXCP@SCANA.COM>'.                           
C34569*                                                                         
C34569 01 MAILHEAD-7.                                                   
C34569    05 FILLER                        PIC X(10) VALUE              
C34569         'SUBJECT:  '.                                            
C34569    05 MAIL7-SUBJECT                 PIC X(30).                   
C34569*                                                                         
C34569 01 MAILHEAD-8.                                                   
C34569    05 FILLER                        PIC X(80) VALUE SPACES.      
C34569*                                                                         
C34569 01 WS-NO-DATA-LINE.                                              
P00245    05 FILLER                        PIC X(43) VALUE SPACES.      
C34569    05 FILLER                        PIC X(25) VALUE              
P00245              '** NO DATA IN THIS RUN **'.                        
P00245    05 FILLER                        PIC X(42) VALUE SPACES.      
C34569*                                                                         
      ******************************************************************        
      **                                                              **        
      ** WORKING STORAGE COPY BOOKS FOLLOW ALL PROGRAM WS             **        
      **                                                              **        
      ******************************************************************        
      /*****   SQL WORK VARIABLES.                                              
       COPY CWS00303.                                                           
                                                                        
      /*****   WS AREA FOR ABEND SWITCH.                                        
       COPY CWS09900.                                                           
                                                                        
      /*****   WS AREA FOR ABEND WORK.                                          
       COPY CWS00010.                                                           
                                                                        
      /*****   WS AREA FOR MISC. INPUT.                                         
       COPY CWS00038.                                                           
                                                                        
P00453/*****   WS AREA FOR CODES DATA PRESENT.                                  
P00453 COPY CWS00056.                                                           
P00453                                                                  
P00245/*****   WS AREA FOR SCSCA328 SUBROUTINE.                                 
P00245 COPY CWS00328.                                                           
P00245                                                                  
       01  WS-END                          PIC X(40)                    
           VALUE 'DB2 INCLUDES FOR PCSCA153 START HERE '.               
      ******************************************************************        
      **                                                              **        
      **  TABLE DECLARATIONS GO AFTER OTHER WORKING STORAGE ITEMS     **        
      **  (IF DIRECT ACCESS TO DB2 TABLES IS ALLOWED). FIRST ITEM     **        
      **  WILL ALWAYS BE SQLCA.                                       **        
      **                                                              **        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      /                                                                         
      / FCA00-KEY                                                               
      /                                                                         
           EXEC SQL                                                             
              INCLUDE FIOCA00                                                   
           END-EXEC.                                                            
      /                                                                         
      / IO AREA FOR PARM INPUT FILE 'A'                                         
      /                                                                         
           EXEC SQL                                                             
              INCLUDE FIOJC01                                                   
           END-EXEC.                                                            
      /                                                                         
      / FCA00 MISC INPUT                                                        
      /                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00039                                                  
           END-EXEC.                                                            
      /                                                                         
C34569/ SCSCB063 COPYBOOK                                                       
C34569/                                                                         
C34569     EXEC SQL                                                             
C34569        INCLUDE CWS00063                                                  
C34569     END-EXEC.                                                            
      /                                                                         
      / CSS_JOB_PARM DCLGEN                                                     
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      /                                                                         
      / CSS_ACCOUNT DCLGEN                                                      
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      /                                                                         
C34569/ CSS_ACCT_RTPK_AGR DCLGEN                                                
C34569/                                                                         
C34569     EXEC SQL                                                             
C34569         INCLUDE TBACCTRG                                                 
C34569     END-EXEC.                                                            
      /                                                                         
T34569/ CSS_COMM_DATA DCLGEN                                                    
T34569/                                                                         
T34569     EXEC SQL                                                             
T34569        INCLUDE TBCOMDAT                                                  
T34569     END-EXEC.                                                            
T34569/                                                                         
T34569/                                                                         
T34569/ CSS_AR_TRANS_HIST DCLGEN                                                
T34569/                                                                         
T34569     EXEC SQL                                                             
T34569         INCLUDE TBMNHIST                                                 
T34569     END-EXEC.                                                            
T34569/                                                                         
T34569/ CSS_AR_TRANS_HIST DCLGEN                                                
T34569/                                                                         
T34569     EXEC SQL                                                             
T34569         INCLUDE TBMNHDT                                                  
T34569     END-EXEC.                                                            
T34569/                                                                         
T34569/ CSS_BILL_WINDOW DCLGEN                                                  
T34569/                                                                         
T34569     EXEC SQL                                                             
T34569         INCLUDE TBBILWDW                                                 
T34569     END-EXEC.                                                            
T34569/                                                                         
      / CSS_DELINQUENCY DCLGEN                                                  
      /                                                                         
           EXEC SQL                                                             
             INCLUDE TBDELQ                                                     
           END-EXEC.                                                            
      /                                                                         
      / CSS_DEP_ON_HAND DCLGEN                                                  
      /                                                                         
           EXEC SQL                                                             
             INCLUDE TBDEPHND                                                   
           END-EXEC.                                                            
      /                                                                         
      / CSS_MTRD_ENVRNMT DCLGEN                                                 
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
      /                                                                         
C34569/ CSS_ACCT_MKT_TIER DCLGEN                                                
C34569/                                                                         
C34569     EXEC SQL                                                             
C34569         INCLUDE TBMKTIER                                                 
C34569     END-EXEC.                                                            
C34569/                                                                         
C34569/ CRM_OPT_ATTR_INCTV DCLGEN                                               
C34569/                                                                         
C34569     EXEC SQL                                                             
C34569         INCLUDE TBOPTATT                                                 
C34569     END-EXEC.                                                            
C34569/                                                                         
C34569/ CRM_RT_PKG_OPTION DCLGEN                                                
C34569/                                                                         
C34569     EXEC SQL                                                             
C34569         INCLUDE TBRTPKGO                                                 
C34569     END-EXEC.                                                            
C34569/                                                                         
C34569/ CSS_RATE_PLAN_DESC DCLGEN                                               
C34569/                                                                         
C34569     EXEC SQL                                                             
C34569         INCLUDE TBRTDESC                                                 
C34569     END-EXEC.                                                            
C34569/                                                                         
      / CSS_SO_DATA DCLGEN                                                      
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBSODAT                                                  
           END-EXEC.                                                            
      /                                                                         
      / CSS_SO_REQUIREMENT DCLGEN                                               
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBSOREQ                                                  
           END-EXEC.                                                            
      /                                                                         
C34569/ CSS_SPCL_FCTR_APPL DCLGEN                                               
C34569/                                                                         
C34569     EXEC SQL                                                             
C34569         INCLUDE TBSPLAPL                                                 
C34569     END-EXEC.                                                            
C34569/                                                                         
C34569/ CSS_SPCL_FCTR DCLGEN                                                    
C34569/                                                                         
C34569     EXEC SQL                                                             
C34569         INCLUDE TBSPLFTR                                                 
C34569     END-EXEC.                                                            
C34569/                                                                         
      / CSS_UTIL_ENVRNMT DCLGEN                                                 
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      /                                                                         
P00245/ CSS_MKT_XREF_ACCT DCLGEN                                                
P00245/                                                                         
P00245     EXEC SQL                                                             
P00245         INCLUDE TBMRKXR                                                  
P00245     END-EXEC.                                                            
P00245/                                                                         
P00245/ CSS_ACCT_ATTRIBUTE DCLGEN                                               
P00245/                                                                         
P00245     EXEC SQL                                                             
P00245         INCLUDE TBACTATT                                                 
P00245     END-EXEC.                                                            
P00245/                                                                         
P00680/ CSS_FIXED_FCTR     DCLGEN                                               
P00680/                                                                         
P00680     EXEC SQL                                                             
P00680         INCLUDE TBFXDFCT                                                 
P00680     END-EXEC.                                                            
P00680/                                                                         
      ******************************************************************        
      **                                                              **        
      **  CURSOR DECLARATIONS (IF ANY) GO LAST                        **        
      **                                                              **        
      ******************************************************************        
      **CURSOR TO EXTRACT THE SEB ACCOUNTS WHICH HAVE BEEN ACTIVATED            
P00245**WITHIN THE DATE RANGE - ONMD (TRUE TURN ON ACCOUNTS)                    
           EXEC SQL                                                     
P00245        DECLARE PRICE_SHEET_A CURSOR FOR                          
               SELECT VO.ACCOUNT_NO                                     
P00245               ,CAST(VO.COMPLETED_DATETIME AS DATE)                       
P00245               ,XM.ORIGINATION_CD                                 
                 FROM CSS_SO_DATA        VO WITH(READUNCOMMITTED)               
                     ,CSS_SO_REQUIREMENT EG WITH(READUNCOMMITTED)               
P00245               ,CSS_MKT_XREF_ACCT  XM WITH(READUNCOMMITTED)               
ACT072               ,CSS_ACCOUNT        AT WITH(READUNCOMMITTED)               
                WHERE VO.SERV_ORDER_NO        = EG.SERV_ORDER_NO        
                  AND VO.ORDER_STATE_CD       = 'Z'                     
                  AND VO.ORDER_TYPE_CD        = 'FM002'                 
                  AND EG.SERV_ORDER_STATUS    = '50'                    
                  AND EG.REQUIREMENT_CD       = '1'                     
C36209            AND CAST(EG.REQMNT_COMP_DT AS DATE) >  
              IIF(TRY_CONVERT(DATE, :WS-LAST-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-RUN-DATE
              ) <> 0) OR (LEN(:WS-LAST-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-LAST-RUN-DATE
              ), CONVERT(DATE, :WS-LAST-RUN-DATE) )      
C36209            AND CAST(EG.REQMNT_COMP_DT AS DATE) <= 
              IIF(TRY_CONVERT(DATE, :WS-COMMON-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-RUN-DATE
              ) <> 0) OR (LEN(:WS-COMMON-RUN-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-COMMON-RUN-DATE
              ), CONVERT(DATE, :WS-COMMON-RUN-DATE) )    
P00245            AND VO.ACCOUNT_NO           = XM.ACCOUNT_NO           
ACT072            AND VO.ACCOUNT_NO           = AT.ACCOUNT_NO           
ACT072            AND AT.ACCOUNT_TYPE_CODE    IN ('C', 'R')             
P00245            AND XM.ORIGINATION_CD       <> 'M'                    
ACT229            AND NOT EXISTS                                        
ACT229               (SELECT 'Y'                                        
ACT229                  FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)        
ACT229                 WHERE YP.ACCOUNT_NO         =  AT.ACCOUNT_NO     
ACT229                   AND YP.ATTRIBUTE_DESC     = 'NO WELCOME KIT'   
ACT229                   AND YP.ATTRIBUTE_VALUE_CD = 'YES'              
ACT229                   AND YP.STATUS_CD          = 'A')               
                ORDER BY VO.ACCOUNT_NO                                  
                  FOR READ ONLY                                 
A00775                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE PRICE_SHEET_A CURSOR FOR                                  
MFA-TR*        SELECT VO.ACCOUNT_NO                                             
MFA-TR*              ,DATE(VO.COMPLETED_DATETIME)                               
MFA-TR*              ,XM.ORIGINATION_CD                                         
MFA-TR*          FROM CSS_SO_DATA        VO                                     
MFA-TR*              ,CSS_SO_REQUIREMENT EG                                     
MFA-TR*              ,CSS_MKT_XREF_ACCT  XM                                     
MFA-TR*              ,CSS_ACCOUNT        AT                                     
MFA-TR*         WHERE VO.SERV_ORDER_NO        = EG.SERV_ORDER_NO                
MFA-TR*           AND VO.ORDER_STATE_CD       = 'Z'                             
MFA-TR*           AND VO.ORDER_TYPE_CD        = 'FM002'                         
MFA-TR*           AND EG.SERV_ORDER_STATUS    = '50'                            
MFA-TR*           AND EG.REQUIREMENT_CD       = '1'                             
MFA-TR*           AND DATE(EG.REQMNT_COMP_DT) >  :WS-LAST-RUN-DATE              
MFA-TR*           AND DATE(EG.REQMNT_COMP_DT) <= :WS-COMMON-RUN-DATE            
MFA-TR*           AND VO.ACCOUNT_NO           = XM.ACCOUNT_NO                   
MFA-TR*           AND VO.ACCOUNT_NO           = AT.ACCOUNT_NO                   
MFA-TR*           AND AT.ACCOUNT_TYPE_CODE    IN ('C', 'R')                     
MFA-TR*           AND XM.ORIGINATION_CD       <> 'M'                            
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*              (SELECT 'Y'                                                
MFA-TR*                 FROM CSS_ACCT_ATTRIBUTE YP                              
MFA-TR*                WHERE YP.ACCOUNT_NO         =  AT.ACCOUNT_NO             
MFA-TR*                  AND YP.ATTRIBUTE_DESC     = 'NO WELCOME KIT'           
MFA-TR*                  AND YP.ATTRIBUTE_VALUE_CD = 'YES'                      
MFA-TR*                  AND YP.STATUS_CD          = 'A')                       
MFA-TR*         ORDER BY VO.ACCOUNT_NO                                          
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            
      /                                                                         
P00245**CURSOR TO EXTRACT THE SEB ACCOUNTS WHICH HAVE BEEN ACTIVATED            
P00245**WITHIN THE DATE RANGE - MKSW (MARKET SWITCH)                            
P00245     EXEC SQL                                                     
P00245        DECLARE PRICE_SHEET_B CURSOR WITH HOLD FOR                
P00245         SELECT VO.ACCOUNT_NO                                     
P00245               ,XM.ORIGINATION_CD                                 
P00245           FROM CSS_SO_DATA        VO WITH(READUNCOMMITTED)               
P00245               ,CSS_SO_REQUIREMENT EG WITH(READUNCOMMITTED)               
P00245               ,CSS_MKT_XREF_ACCT  XM WITH(READUNCOMMITTED)               
ACT072               ,CSS_ACCOUNT        AT WITH(READUNCOMMITTED)               
P00245          WHERE VO.SERV_ORDER_NO        = EG.SERV_ORDER_NO        
P00453            AND ( ( VO.ORDER_STATE_CD       = 'A' )               
P00453                OR ( VO.ORDER_STATE_CD = 'Z'                      
P00453                  AND CIS.SUBSTR3(
           AT.CODES_DATA_PRESENT,15,1) = 'A')   
P00453                )                                                 
P00245            AND VO.ORDER_TYPE_CD        = 'FM002'                 
P00245            AND EG.SERV_ORDER_STATUS    = '10'                    
P00245            AND EG.REQUIREMENT_CD       = '1'                     
P00245            AND CAST(EG.REQMNT_COMP_DT AS DATE) >  
              IIF(TRY_CONVERT(DATE, :WS-LAST-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-RUN-DATE
              ) <> 0) OR (LEN(:WS-LAST-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-LAST-RUN-DATE
              ), CONVERT(DATE, :WS-LAST-RUN-DATE) )      
P00245            AND CAST(EG.REQMNT_COMP_DT AS DATE) <= 
              IIF(TRY_CONVERT(DATE, :WS-COMMON-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-RUN-DATE
              ) <> 0) OR (LEN(:WS-COMMON-RUN-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-COMMON-RUN-DATE
              ), CONVERT(DATE, :WS-COMMON-RUN-DATE) )    
ACT072            AND VO.ACCOUNT_NO           = AT.ACCOUNT_NO           
ACT072            AND AT.ACCOUNT_TYPE_CODE    IN ('C', 'R')             
P00245            AND VO.ACCOUNT_NO           = XM.ACCOUNT_NO           
P00245            AND XM.ORIGINATION_CD       = 'M'                     
ACT229            AND NOT EXISTS                                        
ACT229               (SELECT 'Y'                                        
ACT229                  FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)        
ACT229                 WHERE YP.ACCOUNT_NO         =  AT.ACCOUNT_NO     
ACT229                   AND YP.ATTRIBUTE_DESC     = 'NO WELCOME KIT'   
ACT229                   AND YP.ATTRIBUTE_VALUE_CD = 'YES'              
ACT229                   AND YP.STATUS_CD          = 'A')               
P00245          ORDER BY VO.ACCOUNT_NO                                  
P00245            FOR READ ONLY                                 
A00775                                                      
P00245     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE PRICE_SHEET_B CURSOR WITH HOLD FOR                        
MFA-TR*        SELECT VO.ACCOUNT_NO                                             
MFA-TR*              ,XM.ORIGINATION_CD                                         
MFA-TR*          FROM CSS_SO_DATA        VO                                     
MFA-TR*              ,CSS_SO_REQUIREMENT EG                                     
MFA-TR*              ,CSS_MKT_XREF_ACCT  XM                                     
MFA-TR*              ,CSS_ACCOUNT        AT                                     
MFA-TR*         WHERE VO.SERV_ORDER_NO        = EG.SERV_ORDER_NO                
MFA-TR*           AND ( ( VO.ORDER_STATE_CD       = 'A' )                       
MFA-TR*               OR ( VO.ORDER_STATE_CD = 'Z'                              
MFA-TR*                 AND SUBSTR(AT.CODES_DATA_PRESENT,15,1) = 'A')           
MFA-TR*               )                                                         
MFA-TR*           AND VO.ORDER_TYPE_CD        = 'FM002'                         
MFA-TR*           AND EG.SERV_ORDER_STATUS    = '10'                            
MFA-TR*           AND EG.REQUIREMENT_CD       = '1'                             
MFA-TR*           AND DATE(EG.REQMNT_COMP_DT) >  :WS-LAST-RUN-DATE              
MFA-TR*           AND DATE(EG.REQMNT_COMP_DT) <= :WS-COMMON-RUN-DATE            
MFA-TR*           AND VO.ACCOUNT_NO           = AT.ACCOUNT_NO                   
MFA-TR*           AND AT.ACCOUNT_TYPE_CODE    IN ('C', 'R')                     
MFA-TR*           AND VO.ACCOUNT_NO           = XM.ACCOUNT_NO                   
MFA-TR*           AND XM.ORIGINATION_CD       = 'M'                             
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*              (SELECT 'Y'                                                
MFA-TR*                 FROM CSS_ACCT_ATTRIBUTE YP                              
MFA-TR*                WHERE YP.ACCOUNT_NO         =  AT.ACCOUNT_NO             
MFA-TR*                  AND YP.ATTRIBUTE_DESC     = 'NO WELCOME KIT'           
MFA-TR*                  AND YP.ATTRIBUTE_VALUE_CD = 'YES'                      
MFA-TR*                  AND YP.STATUS_CD          = 'A')                       
MFA-TR*         ORDER BY VO.ACCOUNT_NO                                          
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*         QUERYNO 7030                                                    
MFA-TR*    END-EXEC.                                                            
P00245/                                                                         
P00245**CURSOR TO GET THE OPTION CD FOR THE ACCOUNTS (ONMD AND RT CHG)          
           EXEC SQL                                                     
              DECLARE GAS_UTIL_CUR CURSOR FOR                           
C34569         SELECT AT.CUSTOMER_NO                                    
T34569               ,AT.BILL_CYCLE                                     
P00581               ,AT.ACCOUNT_TYPE_CODE                              
T34569               ,AT.REV_MTH_LST_NRML                               
C34569               ,AT.ADDRESS_ID                                     
C34569               ,AT.ADDRESS_FORMAT                                 
P00453               ,AT.CODES_DATA_PRESENT                             
C34569               ,UT.IC_NO                                          
P00680               ,UT.ACCOUNT_NO                                     
P00680               ,UT.CODE_UTIL_TYPE                                 
C34569               ,RD.RATE_PLAN_NO                                   
C34569               ,RD.REG_GROUP_CD                                   
P00141               ,DF.OPT_AGRMT_EFF_DT                               
P00680               ,DF.STAT_ADJUSTABLE_CD                             
P00245               ,FI.OPT_CALC_TYPE_CD                               
C34569               ,FI.OPTION_CD                                      
P805CS               ,FI.CURR_EXT_DESC_LONG                             
ACT091               ,DF.RT_PKG_OPT_SEQ_NO                              
ACT208               ,DF.AUTO_REN_OPT_IN_FL                             
ACT208               ,DF.AGREEMNT_SOURCE_CD                             
C34569           FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
C34569               ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
C34569               ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                 
C34569               ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)               
C34569               ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                
C34569               ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                
C34569          WHERE AT.ACCOUNT_NO        = :AT-ACCOUNT-NO             
C34569            AND UT.ACCOUNT_NO        = AT.ACCOUNT_NO              
C34569            AND UT.CODE_UTIL_TYPE    = 'G'                        
C34569            AND UT.ACCOUNT_NO        = MN.ACCOUNT_NO              
C34569            AND UT.CODE_UTIL_TYPE    = MN.CODE_UTIL_TYPE          
C34569            AND UT.IC_NO             = MN.IC_NO                   
C34569            AND MN.CODE_METER_STATUS <> 'K'                       
C34569            AND RD.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE          
C34569            AND RD.RATE_PLAN_NO      = UT.RATE_PLAN_NO            
C34569            AND DF.ACCOUNT_NO        = UT.ACCOUNT_NO              
C34569            AND DF.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE          
C34569            AND DF.IC_NO             = UT.IC_NO                   
C34569            AND DF.RT_PKG_OPT_SEQ_NO = UT.RT_PKG_OPT_SEQ_NO       
C34569            AND FI.OPTION_CD         = DF.OPTION_CD               
P00473            AND FI.OPT_VSTART_TS    <= CIS.CURRENT$TIMESTAMP()          
P00473            AND FI.OPT_VEND_TS      >= CIS.CURRENT$TIMESTAMP()          
P00473            AND FI.PROC_STATUS_CD    = 'AC'                       
                  FOR READ ONLY                                 
A00775                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE GAS_UTIL_CUR CURSOR FOR                                   
MFA-TR*        SELECT AT.CUSTOMER_NO                                            
MFA-TR*              ,AT.BILL_CYCLE                                             
MFA-TR*              ,AT.ACCOUNT_TYPE_CODE                                      
MFA-TR*              ,AT.REV_MTH_LST_NRML                                       
MFA-TR*              ,AT.ADDRESS_ID                                             
MFA-TR*              ,AT.ADDRESS_FORMAT                                         
MFA-TR*              ,AT.CODES_DATA_PRESENT                                     
MFA-TR*              ,UT.IC_NO                                                  
MFA-TR*              ,UT.ACCOUNT_NO                                             
MFA-TR*              ,UT.CODE_UTIL_TYPE                                         
MFA-TR*              ,RD.RATE_PLAN_NO                                           
MFA-TR*              ,RD.REG_GROUP_CD                                           
MFA-TR*              ,DF.OPT_AGRMT_EFF_DT                                       
MFA-TR*              ,DF.STAT_ADJUSTABLE_CD                                     
MFA-TR*              ,FI.OPT_CALC_TYPE_CD                                       
MFA-TR*              ,FI.OPTION_CD                                              
MFA-TR*              ,FI.CURR_EXT_DESC_LONG                                     
MFA-TR*              ,DF.RT_PKG_OPT_SEQ_NO                                      
MFA-TR*              ,DF.AUTO_REN_OPT_IN_FL                                     
MFA-TR*              ,DF.AGREEMNT_SOURCE_CD                                     
MFA-TR*          FROM CSS_ACCOUNT AT                                            
MFA-TR*              ,CSS_UTIL_ENVRNMT UT                                       
MFA-TR*              ,CSS_MTRD_ENVRNMT MN                                       
MFA-TR*              ,CSS_RATE_PLAN_DESC RD                                     
MFA-TR*              ,CSS_ACCT_RTPK_AGR DF                                      
MFA-TR*              ,CRM_RT_PKG_OPTION FI                                      
MFA-TR*         WHERE AT.ACCOUNT_NO        = :AT-ACCOUNT-NO                     
MFA-TR*           AND UT.ACCOUNT_NO        = AT.ACCOUNT_NO                      
MFA-TR*           AND UT.CODE_UTIL_TYPE    = 'G'                                
MFA-TR*           AND UT.ACCOUNT_NO        = MN.ACCOUNT_NO                      
MFA-TR*           AND UT.CODE_UTIL_TYPE    = MN.CODE_UTIL_TYPE                  
MFA-TR*           AND UT.IC_NO             = MN.IC_NO                           
MFA-TR*           AND MN.CODE_METER_STATUS <> 'K'                               
MFA-TR*           AND RD.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE                  
MFA-TR*           AND RD.RATE_PLAN_NO      = UT.RATE_PLAN_NO                    
MFA-TR*           AND DF.ACCOUNT_NO        = UT.ACCOUNT_NO                      
MFA-TR*           AND DF.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE                  
MFA-TR*           AND DF.IC_NO             = UT.IC_NO                           
MFA-TR*           AND DF.RT_PKG_OPT_SEQ_NO = UT.RT_PKG_OPT_SEQ_NO               
MFA-TR*           AND FI.OPTION_CD         = DF.OPTION_CD                       
MFA-TR*           AND FI.OPT_VSTART_TS    <= CURRENT TIMESTAMP                  
MFA-TR*           AND FI.OPT_VEND_TS      >= CURRENT TIMESTAMP                  
MFA-TR*           AND FI.PROC_STATUS_CD    = 'AC'                               
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*           QUERYNO 7200                                                  
MFA-TR*    END-EXEC.                                                            
      /                                                                         
P00245**CURSOR TO GET THE OPTION CD FOR THE ACCOUNTS (MKSW)                     
P00245     EXEC SQL                                                     
P00245        DECLARE GAS_UTIL_CUR_2 CURSOR FOR                         
P00245         SELECT AT.CUSTOMER_NO                                    
P00245               ,AT.BILL_CYCLE                                     
P00581               ,AT.ACCOUNT_TYPE_CODE                              
P00245               ,AT.REV_MTH_LST_NRML                               
P00245               ,AT.ADDRESS_ID                                     
P00245               ,AT.ADDRESS_FORMAT                                 
P00453               ,AT.CODES_DATA_PRESENT                             
P00245               ,UT.IC_NO                                          
P00680               ,UT.ACCOUNT_NO                                     
P00680               ,UT.CODE_UTIL_TYPE                                 
P00245               ,RD.RATE_PLAN_NO                                   
P00245               ,RD.REG_GROUP_CD                                   
P00245               ,DF.OPT_AGRMT_EFF_DT                               
P00680               ,DF.STAT_ADJUSTABLE_CD                             
P00245               ,FI.OPT_CALC_TYPE_CD                               
P00245               ,FI.OPTION_CD                                      
P805CS               ,FI.CURR_EXT_DESC_LONG                             
ACT091               ,DF.RT_PKG_OPT_SEQ_NO                              
ACT208               ,DF.AUTO_REN_OPT_IN_FL                             
ACT208               ,DF.AGREEMNT_SOURCE_CD                             
P00245           FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
P00245               ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
P00245               ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)               
P00245               ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                
P00245               ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                
P00245          WHERE AT.ACCOUNT_NO        = :AT-ACCOUNT-NO             
P00245            AND UT.ACCOUNT_NO        = AT.ACCOUNT_NO              
P00245            AND UT.CODE_UTIL_TYPE    = 'G'                        
P00245            AND RD.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE          
P00245            AND RD.RATE_PLAN_NO      = UT.RATE_PLAN_NO            
P00245            AND DF.ACCOUNT_NO        = UT.ACCOUNT_NO              
P00245            AND DF.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE          
P00245            AND DF.IC_NO             = UT.IC_NO                   
P00245            AND DF.RT_PKG_OPT_SEQ_NO = UT.RT_PKG_OPT_SEQ_NO       
P00245            AND FI.OPTION_CD         = DF.OPTION_CD               
P00473            AND FI.OPT_VSTART_TS    <= CIS.CURRENT$TIMESTAMP()          
P00473            AND FI.OPT_VEND_TS      >= CIS.CURRENT$TIMESTAMP()          
P00473            AND FI.PROC_STATUS_CD    = 'AC'                       
P00245            FOR READ ONLY                                 
A00775                                                      
P00245     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE GAS_UTIL_CUR_2 CURSOR FOR                                 
MFA-TR*        SELECT AT.CUSTOMER_NO                                            
MFA-TR*              ,AT.BILL_CYCLE                                             
MFA-TR*              ,AT.ACCOUNT_TYPE_CODE                                      
MFA-TR*              ,AT.REV_MTH_LST_NRML                                       
MFA-TR*              ,AT.ADDRESS_ID                                             
MFA-TR*              ,AT.ADDRESS_FORMAT                                         
MFA-TR*              ,AT.CODES_DATA_PRESENT                                     
MFA-TR*              ,UT.IC_NO                                                  
MFA-TR*              ,UT.ACCOUNT_NO                                             
MFA-TR*              ,UT.CODE_UTIL_TYPE                                         
MFA-TR*              ,RD.RATE_PLAN_NO                                           
MFA-TR*              ,RD.REG_GROUP_CD                                           
MFA-TR*              ,DF.OPT_AGRMT_EFF_DT                                       
MFA-TR*              ,DF.STAT_ADJUSTABLE_CD                                     
MFA-TR*              ,FI.OPT_CALC_TYPE_CD                                       
MFA-TR*              ,FI.OPTION_CD                                              
MFA-TR*              ,FI.CURR_EXT_DESC_LONG                                     
MFA-TR*              ,DF.RT_PKG_OPT_SEQ_NO                                      
MFA-TR*              ,DF.AUTO_REN_OPT_IN_FL                                     
MFA-TR*              ,DF.AGREEMNT_SOURCE_CD                                     
MFA-TR*          FROM CSS_ACCOUNT AT                                            
MFA-TR*              ,CSS_UTIL_ENVRNMT UT                                       
MFA-TR*              ,CSS_RATE_PLAN_DESC RD                                     
MFA-TR*              ,CSS_ACCT_RTPK_AGR DF                                      
MFA-TR*              ,CRM_RT_PKG_OPTION FI                                      
MFA-TR*         WHERE AT.ACCOUNT_NO        = :AT-ACCOUNT-NO                     
MFA-TR*           AND UT.ACCOUNT_NO        = AT.ACCOUNT_NO                      
MFA-TR*           AND UT.CODE_UTIL_TYPE    = 'G'                                
MFA-TR*           AND RD.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE                  
MFA-TR*           AND RD.RATE_PLAN_NO      = UT.RATE_PLAN_NO                    
MFA-TR*           AND DF.ACCOUNT_NO        = UT.ACCOUNT_NO                      
MFA-TR*           AND DF.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE                  
MFA-TR*           AND DF.IC_NO             = UT.IC_NO                           
MFA-TR*           AND DF.RT_PKG_OPT_SEQ_NO = UT.RT_PKG_OPT_SEQ_NO               
MFA-TR*           AND FI.OPTION_CD         = DF.OPTION_CD                       
MFA-TR*           AND FI.OPT_VSTART_TS    <= CURRENT TIMESTAMP                  
MFA-TR*           AND FI.OPT_VEND_TS      >= CURRENT TIMESTAMP                  
MFA-TR*           AND FI.PROC_STATUS_CD    = 'AC'                               
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*           QUERYNO 7230                                                  
MFA-TR*    END-EXEC.                                                            
P00245/                                                                         
C34569**CURSOR TO GET THE TWO PART RATE PLANS                                   
C34569     EXEC SQL                                                     
C34569      DECLARE SPCL_FCTR_DDDC CURSOR FOR                           
C34569          SELECT DISTINCT(RATE_PLAN_NO)                           
C34569                ,FACTOR                                           
C34569            FROM CSS_SPCL_FCTR_APPL AP WITH(READUNCOMMITTED)              
C34569                ,CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)              
C34569           WHERE AP.CODE_UTIL_TYPE = 'G'                          
C34569             AND AP.CODE_STATUS    = 'A'                          
C34569             AND AP.FACTOR_ID      = SF.FACTOR_ID                 
C34569             AND SF.SPCL_GROUP_CD  = 'DD'                         
C34569             AND AP.DATE_TO       >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                 
C34569             AND AP.DATE_FROM =                                   
C34569                 (SELECT MAX(DC.DATE_FROM)                        
C34569                    FROM CSS_SPCL_FCTR_APPL DC
                           WITH(READUNCOMMITTED)                    
C34569                   WHERE AP.RATE_PLAN_NO   = DC.RATE_PLAN_NO      
C34569                     AND AP.CODE_UTIL_TYPE = DC.CODE_UTIL_TYPE    
C34569                     AND AP.FACTOR_ID      = DC.FACTOR_ID         
C34569                     AND DC.DATE_TO       >= 
           CAST(SYSDATETIMEOFFSET() AS DATE))        
C34569           ORDER BY RATE_PLAN_NO                                  
C34569             FOR READ ONLY                                
A00775                                                      
C34569     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE SPCL_FCTR_DDDC CURSOR FOR                                   
MFA-TR*         SELECT DISTINCT(RATE_PLAN_NO)                                   
MFA-TR*               ,FACTOR                                                   
MFA-TR*           FROM CSS_SPCL_FCTR_APPL AP                                    
MFA-TR*               ,CSS_SPCL_FCTR      SF                                    
MFA-TR*          WHERE AP.CODE_UTIL_TYPE = 'G'                                  
MFA-TR*            AND AP.CODE_STATUS    = 'A'                                  
MFA-TR*            AND AP.FACTOR_ID      = SF.FACTOR_ID                         
MFA-TR*            AND SF.SPCL_GROUP_CD  = 'DD'                                 
MFA-TR*            AND AP.DATE_TO       >= CURRENT DATE                         
MFA-TR*            AND AP.DATE_FROM =                                           
MFA-TR*                (SELECT MAX(DC.DATE_FROM)                                
MFA-TR*                   FROM CSS_SPCL_FCTR_APPL DC                            
MFA-TR*                  WHERE AP.RATE_PLAN_NO   = DC.RATE_PLAN_NO              
MFA-TR*                    AND AP.CODE_UTIL_TYPE = DC.CODE_UTIL_TYPE            
MFA-TR*                    AND AP.FACTOR_ID      = DC.FACTOR_ID                 
MFA-TR*                    AND DC.DATE_TO       >= CURRENT DATE)                
MFA-TR*          ORDER BY RATE_PLAN_NO                                          
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*          QUERYNO 7630                                                   
MFA-TR*    END-EXEC.                                                            
C34569/                                                                         
      *                                                                         
P00245**CURSOR TO EXTRACT THE RATE CHANGE ACCOUNTS                              
P00245     EXEC SQL                                                     
P00245      DECLARE RATE_CHANGE CURSOR FOR                              
P00245       SELECT AT.ACCOUNT_NO                                       
P00245             ,AT.CUSTOMER_NO                                      
P00245             ,AT.ADDRESS_ID                                       
P00245             ,AT.ADDRESS_FORMAT                                   
P00453             ,AT.CODES_DATA_PRESENT                               
P00245             ,AT.BILL_CYCLE                                       
P00581             ,AT.ACCOUNT_TYPE_CODE                                
P00245             ,AT.REV_MTH_LST_NRML                                 
P00245             ,UT.IC_NO                                            
P00245             ,UT.CODE_UTIL_TYPE                                   
P00680             ,UT.ACCOUNT_NO                                       
P00245             ,RD.RATE_PLAN_NO                                     
P00245             ,RD.REG_GROUP_CD                                     
P00245             ,DF.RT_PKG_OPT_SEQ_NO                                
P00245             ,DF.AGREEMNT_SOURCE_CD                               
P00245             ,DF.STATUS_EFF_REV_MTH                               
P00245             ,DF.OPT_AGRMT_EFF_DT                                 
P00680             ,DF.STAT_ADJUSTABLE_CD                               
P00805             ,DF.STATUS_CD                                        
P00245             ,FI.OPTION_CD                                        
P00245             ,FI.OPT_CALC_TYPE_CD                                 
P805CS             ,FI.CURR_EXT_DESC_LONG                               
P00892             ,DF.AUTO_REN_OPT_IN_FL                               
P00245         FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                        
P00245             ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                   
P00245             ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                 
P00245             ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                  
P00245             ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                  
P00245             ,CSS_ACCT_MKT_TIER DD WITH(READUNCOMMITTED)                  
P00245        WHERE AT.ACCOUNT_NO        = UT.ACCOUNT_NO                
ACT208          AND AT.CODE_ACCT_STAT   IN ('A','P')                    
P00245          AND DF.ACCOUNT_NO        = UT.ACCOUNT_NO                
P00245          AND DF.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE            
P00245          AND DF.IC_NO             = UT.IC_NO                     
P00805          AND DF.STATUS_CD        IN ('A','P')                    
P00245          AND RD.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE            
P00245          AND RD.RATE_PLAN_NO      = UT.RATE_PLAN_NO              
P00245          AND FI.OPTION_CD         = DF.OPTION_CD                 
P00245          AND FI.COMPANY_NO        = AT.COMPANY_NO                
P00473          AND FI.OPT_VSTART_TS    <= CIS.CURRENT$TIMESTAMP()            
P00473          AND FI.OPT_VEND_TS      >= CIS.CURRENT$TIMESTAMP()            
P00473          AND FI.PROC_STATUS_CD    = 'AC'                         
P00245          AND DD.ACCOUNT_NO        = AT.ACCOUNT_NO                
P00245          AND DD.TIER_ACCT_TYPE_CD IN ('D','A','B','S','1','2')   
A03692          AND (DF.OPT_AGRMT_EFF_DT  >= IIF(TRY_CONVERT(DATE, 
                                                      :WS-LAST-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-RUN-DATE
              ) <> 0) OR (LEN(:WS-LAST-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-LAST-RUN-DATE
              ), CONVERT(DATE, :WS-LAST-RUN-DATE) )          
A03692          AND  DF.OPT_AGRMT_EFF_DT  <  IIF(TRY_CONVERT(DATE, 
                                                    :WS-COMMON-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-RUN-DATE
              ) <> 0) OR (LEN(:WS-COMMON-RUN-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-COMMON-RUN-DATE
              ), CONVERT(DATE, :WS-COMMON-RUN-DATE) ))       
P00245          AND DD.EFF_START_DT =                                   
P00245                     (SELECT MAX(D1.EFF_START_DT)                 
P00245                        FROM CSS_ACCT_MKT_TIER D1
                           WITH(READUNCOMMITTED)                 
P00245                       WHERE D1.ACCOUNT_NO = AT.ACCOUNT_NO)       
ACT229          AND NOT EXISTS                                          
ACT229               (SELECT 'Y'                                        
ACT229                  FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)        
ACT229                 WHERE YP.ACCOUNT_NO         =  AT.ACCOUNT_NO     
ACT229                   AND YP.ATTRIBUTE_DESC     = 'NO RATE CHG LTR'  
ACT229                   AND YP.ATTRIBUTE_VALUE_CD = 'YES'              
ACT229                   AND YP.STATUS_CD          = 'A')               
ACT207          AND NOT EXISTS                                          
ACT207               (SELECT KO.COMMUNICATION_ID                        
ACT207                  FROM CSS_COMM_DATA KO WITH(READUNCOMMITTED)             
ACT207                 WHERE KO.ACCOUNT_NO        =  AT.ACCOUNT_NO      
ACT207                   AND KO.COMM_TYPE_CD      = '22'                
ACT207                   AND KO.COMM_SUBTYPE_CODE = '10'                
ACT207                   AND CAST(KO.COMMUNICATION_ID AS DATE) = 
           CAST(SYSDATETIMEOFFSET() AS DATE))  
ACT208          AND ( (CAST(AT.ACCT_CREATE_DT AS DATE)                          
ACT208                                   < DATEADD( MONTH, -24, 
           CAST(SYSDATETIMEOFFSET() AS DATE) ))    
ACT208                             OR                                   
ACT208                (EXISTS                                           
ACT208                  (SELECT KO.COMMUNICATION_ID                     
ACT208                     FROM CSS_COMM_DATA KO WITH(READUNCOMMITTED)          
ACT208                    WHERE KO.ACCOUNT_NO        =  AT.ACCOUNT_NO   
ACT208                      AND KO.COMM_TYPE_CD      = '22'             
ACT208                      AND KO.COMM_SUBTYPE_CODE = '10'             
ACT208                      AND CAST(AT.ACCT_CREATE_DT AS DATE)                 
ACT208                                  >= DATEADD( MONTH, -24, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )) ) )
P00245          ORDER BY 1                                              
P00245        FOR READ ONLY                                     
A00775                                                      
P00245     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE RATE_CHANGE CURSOR FOR                                      
MFA-TR*      SELECT AT.ACCOUNT_NO                                               
MFA-TR*            ,AT.CUSTOMER_NO                                              
MFA-TR*            ,AT.ADDRESS_ID                                               
MFA-TR*            ,AT.ADDRESS_FORMAT                                           
MFA-TR*            ,AT.CODES_DATA_PRESENT                                       
MFA-TR*            ,AT.BILL_CYCLE                                               
MFA-TR*            ,AT.ACCOUNT_TYPE_CODE                                        
MFA-TR*            ,AT.REV_MTH_LST_NRML                                         
MFA-TR*            ,UT.IC_NO                                                    
MFA-TR*            ,UT.CODE_UTIL_TYPE                                           
MFA-TR*            ,UT.ACCOUNT_NO                                               
MFA-TR*            ,RD.RATE_PLAN_NO                                             
MFA-TR*            ,RD.REG_GROUP_CD                                             
MFA-TR*            ,DF.RT_PKG_OPT_SEQ_NO                                        
MFA-TR*            ,DF.AGREEMNT_SOURCE_CD                                       
MFA-TR*            ,DF.STATUS_EFF_REV_MTH                                       
MFA-TR*            ,DF.OPT_AGRMT_EFF_DT                                         
MFA-TR*            ,DF.STAT_ADJUSTABLE_CD                                       
MFA-TR*            ,DF.STATUS_CD                                                
MFA-TR*            ,FI.OPTION_CD                                                
MFA-TR*            ,FI.OPT_CALC_TYPE_CD                                         
MFA-TR*            ,FI.CURR_EXT_DESC_LONG                                       
MFA-TR*            ,DF.AUTO_REN_OPT_IN_FL                                       
MFA-TR*        FROM CSS_ACCOUNT AT                                              
MFA-TR*            ,CSS_UTIL_ENVRNMT UT                                         
MFA-TR*            ,CSS_RATE_PLAN_DESC RD                                       
MFA-TR*            ,CSS_ACCT_RTPK_AGR DF                                        
MFA-TR*            ,CRM_RT_PKG_OPTION FI                                        
MFA-TR*            ,CSS_ACCT_MKT_TIER DD                                        
MFA-TR*       WHERE AT.ACCOUNT_NO        = UT.ACCOUNT_NO                        
MFA-TR*         AND AT.CODE_ACCT_STAT   IN ('A','P')                            
MFA-TR*         AND DF.ACCOUNT_NO        = UT.ACCOUNT_NO                        
MFA-TR*         AND DF.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE                    
MFA-TR*         AND DF.IC_NO             = UT.IC_NO                             
MFA-TR*         AND DF.STATUS_CD        IN ('A','P')                            
MFA-TR*         AND RD.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE                    
MFA-TR*         AND RD.RATE_PLAN_NO      = UT.RATE_PLAN_NO                      
MFA-TR*         AND FI.OPTION_CD         = DF.OPTION_CD                         
MFA-TR*         AND FI.COMPANY_NO        = AT.COMPANY_NO                        
MFA-TR*         AND FI.OPT_VSTART_TS    <= CURRENT TIMESTAMP                    
MFA-TR*         AND FI.OPT_VEND_TS      >= CURRENT TIMESTAMP                    
MFA-TR*         AND FI.PROC_STATUS_CD    = 'AC'                                 
MFA-TR*         AND DD.ACCOUNT_NO        = AT.ACCOUNT_NO                        
MFA-TR*         AND DD.TIER_ACCT_TYPE_CD IN ('D','A','B','S','1','2')           
MFA-TR*         AND (DF.OPT_AGRMT_EFF_DT  >= :WS-LAST-RUN-DATE                  
MFA-TR*         AND  DF.OPT_AGRMT_EFF_DT  <  :WS-COMMON-RUN-DATE)               
MFA-TR*         AND DD.EFF_START_DT =                                           
MFA-TR*                    (SELECT MAX(D1.EFF_START_DT)                         
MFA-TR*                       FROM CSS_ACCT_MKT_TIER D1                         
MFA-TR*                      WHERE D1.ACCOUNT_NO = AT.ACCOUNT_NO)               
MFA-TR*         AND NOT EXISTS                                                  
MFA-TR*              (SELECT 'Y'                                                
MFA-TR*                 FROM CSS_ACCT_ATTRIBUTE YP                              
MFA-TR*                WHERE YP.ACCOUNT_NO         =  AT.ACCOUNT_NO             
MFA-TR*                  AND YP.ATTRIBUTE_DESC     = 'NO RATE CHG LTR'          
MFA-TR*                  AND YP.ATTRIBUTE_VALUE_CD = 'YES'                      
MFA-TR*                  AND YP.STATUS_CD          = 'A')                       
MFA-TR*         AND NOT EXISTS                                                  
MFA-TR*              (SELECT KO.COMMUNICATION_ID                                
MFA-TR*                 FROM CSS_COMM_DATA KO                                   
MFA-TR*                WHERE KO.ACCOUNT_NO        =  AT.ACCOUNT_NO              
MFA-TR*                  AND KO.COMM_TYPE_CD      = '22'                        
MFA-TR*                  AND KO.COMM_SUBTYPE_CODE = '10'                        
MFA-TR*                  AND DATE(KO.COMMUNICATION_ID) = CURRENT DATE)          
MFA-TR*         AND ( (DATE(AT.ACCT_CREATE_DT)                                  
MFA-TR*                                  < CURRENT DATE - 24 MONTHS)            
MFA-TR*                            OR                                           
MFA-TR*               (EXISTS                                                   
MFA-TR*                 (SELECT KO.COMMUNICATION_ID                             
MFA-TR*                    FROM CSS_COMM_DATA KO                                
MFA-TR*                   WHERE KO.ACCOUNT_NO        =  AT.ACCOUNT_NO           
MFA-TR*                     AND KO.COMM_TYPE_CD      = '22'                     
MFA-TR*                     AND KO.COMM_SUBTYPE_CODE = '10'                     
MFA-TR*                     AND DATE(AT.ACCT_CREATE_DT)                         
MFA-TR*                                 >= CURRENT DATE - 24 MONTHS) ) )        
MFA-TR*         ORDER BY 1                                                      
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7060                                                      
MFA-TR*    END-EXEC.                                                            
P00245/                                                                         
P00245/                                                                         
P00892**CURSOR TO EXTRACT THE SEB ACCOUNTS TO GENERATE OPTED IN LETTERS         
P00892**WITHIN THE DATE RANGE AND WELCOME KIT OR RATE CHANGE LETTER GEN-        
P00892**RATED.                                                                  
P00892     EXEC SQL                                                     
P00892       DECLARE OPTED_IN CURSOR FOR                                
P00892       SELECT AT.ACCOUNT_NO                                       
P00892             ,AT.CUSTOMER_NO                                      
P00892             ,AT.ADDRESS_ID                                       
P00892             ,AT.ADDRESS_FORMAT                                   
P00892             ,AT.CODES_DATA_PRESENT                               
P00892             ,AT.BILL_CYCLE                                       
P00892             ,AT.ACCOUNT_TYPE_CODE                                
P00892             ,AT.REV_MTH_LST_NRML                                 
P00892             ,UT.IC_NO                                            
P00892             ,UT.CODE_UTIL_TYPE                                   
P00892             ,UT.ACCOUNT_NO                                       
P00892             ,RD.RATE_PLAN_NO                                     
P00892             ,RD.REG_GROUP_CD                                     
P00892             ,DF.RT_PKG_OPT_SEQ_NO                                
P00892             ,DF.AGREEMNT_SOURCE_CD                               
P00892             ,DF.STATUS_EFF_REV_MTH                               
P00892             ,DF.OPT_AGRMT_EFF_DT                                 
P00892             ,DF.STAT_ADJUSTABLE_CD                               
P00892             ,DF.STATUS_CD                                        
P00892             ,FI.OPTION_CD                                        
P00892             ,FI.OPT_CALC_TYPE_CD                                 
P805CS             ,FI.CURR_EXT_DESC_LONG                               
P00892         FROM CSS_ACCOUNT        AT WITH(READUNCOMMITTED)                 
P00892             ,CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)                 
P00892             ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                 
P00892             ,CSS_ACCT_RTPK_AGR  DF WITH(READUNCOMMITTED)                 
P00892             ,CRM_RT_PKG_OPTION  FI WITH(READUNCOMMITTED)                 
P00892             ,CSS_ACCT_MKT_TIER  DD WITH(READUNCOMMITTED)                 
P00892             ,CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)                 
P00892         WHERE YP.ATTRIBUTE_DESC = 'OPTED IN'                     
P00892           AND YP.STATUS_CD      = 'A'                            
P00892           AND (YP.ATTRIBUTE_VALUE_DT     >= 
              IIF(TRY_CONVERT(DATE, :WS-LAST-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-RUN-DATE
              ) <> 0) OR (LEN(:WS-LAST-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-LAST-RUN-DATE
              ), CONVERT(DATE, :WS-LAST-RUN-DATE) )    
P00892                AND YP.ATTRIBUTE_VALUE_DT  <  
              IIF(TRY_CONVERT(DATE, :WS-COMMON-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-RUN-DATE
              ) <> 0) OR (LEN(:WS-COMMON-RUN-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-COMMON-RUN-DATE
              ), CONVERT(DATE, :WS-COMMON-RUN-DATE) ))
P00892           AND YP.ACCOUNT_NO     = AT.ACCOUNT_NO                  
P00892           AND EXISTS                                             
P00892                 (SELECT CAST(COMMUNICATION_ID AS DATE)                   
P00892                    FROM  CSS_COMM_DATA KO WITH(READUNCOMMITTED)          
P00892                   WHERE KO.ACCOUNT_NO        = YP.ACCOUNT_NO     
P00892                     AND YP.ATTRIBUTE_VALUE_DT >                  
P00892                                        CAST(COMMUNICATION_ID
            AS DATE)    
ACT192                     AND COMMUNICATION_ID =                       
ACT192                           (SELECT MAX(K1.COMMUNICATION_ID)       
ACT192                              FROM CSS_COMM_DATA K1
                           WITH(READUNCOMMITTED)               
ACT192                             WHERE K1.ACCOUNT_NO = KO.ACCOUNT_NO  
ACT192                               AND K1.COMM_TYPE_CD IN ('22', '45')
ACT192                               AND K1.COMM_SUBTYPE_CODE = '10'    
ACT192                           )                                      
P00892                 )                                                
P00892           AND AT.ACCOUNT_NO        = UT.ACCOUNT_NO               
P00892           AND DF.ACCOUNT_NO        = UT.ACCOUNT_NO               
P00892           AND DF.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE           
P00892           AND DF.IC_NO             = UT.IC_NO                    
P00892           AND DF.STATUS_CD        IN ('A','P')                   
ACT208           AND YP.ATTRIBUTE_VALUE_DT > DF.OPT_AGRMT_EFF_DT        
P00892           AND RD.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE           
P00892           AND RD.RATE_PLAN_NO      = UT.RATE_PLAN_NO             
P00892           AND FI.OPTION_CD         = DF.OPTION_CD                
P00892           AND FI.COMPANY_NO        = AT.COMPANY_NO               
P00892           AND FI.OPT_VSTART_TS    <= CIS.CURRENT$TIMESTAMP()           
P00892           AND FI.OPT_VEND_TS      >= CIS.CURRENT$TIMESTAMP()           
P00892           AND FI.PROC_STATUS_CD    = 'AC'                        
P00892           AND DD.ACCOUNT_NO        = AT.ACCOUNT_NO               
P00892           AND DD.TIER_ACCT_TYPE_CD IN ('D','A','B','S','1','2')  
P00892           AND DD.EFF_START_DT =                                  
P00892                     (SELECT MAX(D1.EFF_START_DT)                 
P00892                        FROM CSS_ACCT_MKT_TIER D1
                           WITH(READUNCOMMITTED)                 
P00892                       WHERE D1.ACCOUNT_NO = AT.ACCOUNT_NO)       
P00892         ORDER BY 1                                               
P00892         FOR READ ONLY                                    
P00892                                                      
P00892     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE OPTED_IN CURSOR FOR                                        
MFA-TR*      SELECT AT.ACCOUNT_NO                                               
MFA-TR*            ,AT.CUSTOMER_NO                                              
MFA-TR*            ,AT.ADDRESS_ID                                               
MFA-TR*            ,AT.ADDRESS_FORMAT                                           
MFA-TR*            ,AT.CODES_DATA_PRESENT                                       
MFA-TR*            ,AT.BILL_CYCLE                                               
MFA-TR*            ,AT.ACCOUNT_TYPE_CODE                                        
MFA-TR*            ,AT.REV_MTH_LST_NRML                                         
MFA-TR*            ,UT.IC_NO                                                    
MFA-TR*            ,UT.CODE_UTIL_TYPE                                           
MFA-TR*            ,UT.ACCOUNT_NO                                               
MFA-TR*            ,RD.RATE_PLAN_NO                                             
MFA-TR*            ,RD.REG_GROUP_CD                                             
MFA-TR*            ,DF.RT_PKG_OPT_SEQ_NO                                        
MFA-TR*            ,DF.AGREEMNT_SOURCE_CD                                       
MFA-TR*            ,DF.STATUS_EFF_REV_MTH                                       
MFA-TR*            ,DF.OPT_AGRMT_EFF_DT                                         
MFA-TR*            ,DF.STAT_ADJUSTABLE_CD                                       
MFA-TR*            ,DF.STATUS_CD                                                
MFA-TR*            ,FI.OPTION_CD                                                
MFA-TR*            ,FI.OPT_CALC_TYPE_CD                                         
MFA-TR*            ,FI.CURR_EXT_DESC_LONG                                       
MFA-TR*        FROM CSS_ACCOUNT        AT                                       
MFA-TR*            ,CSS_UTIL_ENVRNMT   UT                                       
MFA-TR*            ,CSS_RATE_PLAN_DESC RD                                       
MFA-TR*            ,CSS_ACCT_RTPK_AGR  DF                                       
MFA-TR*            ,CRM_RT_PKG_OPTION  FI                                       
MFA-TR*            ,CSS_ACCT_MKT_TIER  DD                                       
MFA-TR*            ,CSS_ACCT_ATTRIBUTE YP                                       
MFA-TR*        WHERE YP.ATTRIBUTE_DESC = 'OPTED IN'                             
MFA-TR*          AND YP.STATUS_CD      = 'A'                                    
MFA-TR*          AND (YP.ATTRIBUTE_VALUE_DT     >= :WS-LAST-RUN-DATE            
MFA-TR*               AND YP.ATTRIBUTE_VALUE_DT  <  :WS-COMMON-RUN-DATE)        
MFA-TR*          AND YP.ACCOUNT_NO     = AT.ACCOUNT_NO                          
MFA-TR*          AND EXISTS                                                     
MFA-TR*                (SELECT DATE(COMMUNICATION_ID)                           
MFA-TR*                   FROM  CSS_COMM_DATA KO                                
MFA-TR*                  WHERE KO.ACCOUNT_NO        = YP.ACCOUNT_NO             
MFA-TR*                    AND YP.ATTRIBUTE_VALUE_DT >                          
MFA-TR*                                       DATE(COMMUNICATION_ID)            
MFA-TR*                    AND COMMUNICATION_ID =                               
MFA-TR*                          (SELECT MAX(K1.COMMUNICATION_ID)               
MFA-TR*                             FROM CSS_COMM_DATA K1                       
MFA-TR*                            WHERE K1.ACCOUNT_NO = KO.ACCOUNT_NO          
MFA-TR*                              AND K1.COMM_TYPE_CD IN ('22', '45')        
MFA-TR*                              AND K1.COMM_SUBTYPE_CODE = '10'            
MFA-TR*                          )                                              
MFA-TR*                )                                                        
MFA-TR*          AND AT.ACCOUNT_NO        = UT.ACCOUNT_NO                       
MFA-TR*          AND DF.ACCOUNT_NO        = UT.ACCOUNT_NO                       
MFA-TR*          AND DF.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE                   
MFA-TR*          AND DF.IC_NO             = UT.IC_NO                            
MFA-TR*          AND DF.STATUS_CD        IN ('A','P')                           
MFA-TR*          AND YP.ATTRIBUTE_VALUE_DT > DF.OPT_AGRMT_EFF_DT                
MFA-TR*          AND RD.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE                   
MFA-TR*          AND RD.RATE_PLAN_NO      = UT.RATE_PLAN_NO                     
MFA-TR*          AND FI.OPTION_CD         = DF.OPTION_CD                        
MFA-TR*          AND FI.COMPANY_NO        = AT.COMPANY_NO                       
MFA-TR*          AND FI.OPT_VSTART_TS    <= CURRENT TIMESTAMP                   
MFA-TR*          AND FI.OPT_VEND_TS      >= CURRENT TIMESTAMP                   
MFA-TR*          AND FI.PROC_STATUS_CD    = 'AC'                                
MFA-TR*          AND DD.ACCOUNT_NO        = AT.ACCOUNT_NO                       
MFA-TR*          AND DD.TIER_ACCT_TYPE_CD IN ('D','A','B','S','1','2')          
MFA-TR*          AND DD.EFF_START_DT =                                          
MFA-TR*                    (SELECT MAX(D1.EFF_START_DT)                         
MFA-TR*                       FROM CSS_ACCT_MKT_TIER D1                         
MFA-TR*                      WHERE D1.ACCOUNT_NO = AT.ACCOUNT_NO)               
MFA-TR*        ORDER BY 1                                                       
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7090                                                     
MFA-TR*    END-EXEC.                                                            
P00892                                                                  
P00581**CURSOR TO GET JOB PARM DATA FOR RCC, TON, RT CHK CHARGES ETC            
P00581     EXEC SQL                                                     
P00581      DECLARE ALL_JOB_PARM CURSOR WITH ROWSET POSITIONING FOR     
P00581       SELECT G6.PROGRAM_NAME                                     
P00581             ,G6.PARM_DATA                                        
P00581         FROM CSS_JOB_PARM  G6 WITH(READUNCOMMITTED)                      
P00581        WHERE G6.PROGRAM_NAME IN                                  
P00581                 ( 'DEREG-RCC ', 'REG1-RCC  ', 'REG2-RCC  ',      
P00581                   'DEREG-TON ', 'REG1-TON  ', 'REG2-TON  ',      
P00581                   'DEREG-NSC ', 'REG1-NSC  ', 'REG2-NSC  ',      
P00581                   'DEREG-SET ', 'REG1-SET  ', 'REG2-SET  ',      
P00581                   'DEREG-SEAS', 'REG1-SEAS ', 'REG2-SEAS ',      
P00581                   'EXITFEERES', 'EXITFEECOM', 'MAXRES-DEP',      
P00677                   'G1REXITFEE', 'G2REXITFEE', 'REG1MAXDEP',      
P00677                   'REG1STDCSC', 'G1SR-DISC ', 'REG2MAXDEP',      
P00677                   'REG2STDCSC', 'G2SR-DISC ', 'G1SRMAXDEP',      
P00677                   'G1SR-CSC  ', 'G2GOODDISC', 'G2SRMAXDEP',      
P00677                   'G2PYMTCSC ', 'G1FADJFCT ', 'G2FWTAVFCT',      
P00677                                 'G2FADJFCT ')                    
P00581          AND G6.COMPANY_NO   = '01'                              
P00581          AND G6.CMND_CODE    = 'PARM'                            
P00581          AND G6.STATUS       = 'A'                               
P00581        FOR READ ONLY                                     
P00581                                                      
P00581     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE ALL_JOB_PARM CURSOR WITH ROWSET POSITIONING FOR             
MFA-TR*      SELECT G6.PROGRAM_NAME                                             
MFA-TR*            ,G6.PARM_DATA                                                
MFA-TR*        FROM CSS_JOB_PARM  G6                                            
MFA-TR*       WHERE G6.PROGRAM_NAME IN                                          
MFA-TR*                ( 'DEREG-RCC ', 'REG1-RCC  ', 'REG2-RCC  ',              
MFA-TR*                  'DEREG-TON ', 'REG1-TON  ', 'REG2-TON  ',              
MFA-TR*                  'DEREG-NSC ', 'REG1-NSC  ', 'REG2-NSC  ',              
MFA-TR*                  'DEREG-SET ', 'REG1-SET  ', 'REG2-SET  ',              
MFA-TR*                  'DEREG-SEAS', 'REG1-SEAS ', 'REG2-SEAS ',              
MFA-TR*                  'EXITFEERES', 'EXITFEECOM', 'MAXRES-DEP',              
MFA-TR*                  'G1REXITFEE', 'G2REXITFEE', 'REG1MAXDEP',              
MFA-TR*                  'REG1STDCSC', 'G1SR-DISC ', 'REG2MAXDEP',              
MFA-TR*                  'REG2STDCSC', 'G2SR-DISC ', 'G1SRMAXDEP',              
MFA-TR*                  'G1SR-CSC  ', 'G2GOODDISC', 'G2SRMAXDEP',              
MFA-TR*                  'G2PYMTCSC ', 'G1FADJFCT ', 'G2FWTAVFCT',              
MFA-TR*                                'G2FADJFCT ')                            
MFA-TR*         AND G6.COMPANY_NO   = '01'                                      
MFA-TR*         AND G6.CMND_CODE    = 'PARM'                                    
MFA-TR*         AND G6.STATUS       = 'A'                                       
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7510                                                      
MFA-TR*    END-EXEC.                                                            
P00581***                                                                       
      **                                                                        
P00680     EXEC SQL                                                     
P00680      DECLARE DISCOUNT_RATE CURSOR WITH ROWSET POSITIONING FOR    
P00680         SELECT FF.FACTOR                                         
P00680               ,FF.DURATION_REMAIN_NO                             
P00680               ,SF.RT_ATTR_INCTV_TYPE                             
PRJ680               ,SF.FACTOR_DESC                                    
P00680           FROM                                                   
P00680                CSS_ACCT_RTPK_AGR  DF WITH(READUNCOMMITTED)               
P00680               ,CSS_FIXED_FCTR     FF WITH(READUNCOMMITTED)               
P00680               ,CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)               
P00680          WHERE                                                   
P00680                DF.ACCOUNT_NO         = :UT-ACCOUNT-NO            
P00680            AND DF.CODE_UTIL_TYPE     = :UT-CODE-UTIL-TYPE        
P00680            AND DF.IC_NO              = :UT-IC-NO                 
P00805            AND DF.RT_PKG_OPT_SEQ_NO  = :DF-RT-PKG-OPT-SEQ-NO     
P00680            AND FF.ACCOUNT_NO         = DF.ACCOUNT_NO             
P00680            AND FF.CODE_UTIL_TYPE     = DF.CODE_UTIL_TYPE         
P00680            AND FF.IC_NO              = DF.IC_NO                  
P00680            AND FF.RT_PKG_OPT_SEQ_NO  = DF.RT_PKG_OPT_SEQ_NO      
P00680            AND FF.DURATION_REMAIN_NO > 0                         
P00680            AND SF.FACTOR_ID          = FF.FACTOR_ID              
P00680            AND SF.RT_ATTR_INCTV_TYPE IN ('PRICE DISCOUNT'        
P00680                                         ,'CSC DISCOUNT'          
P00680                                         ,'ADJUSTABLE RATE')      
P00680        FOR READ ONLY                                     
P00680                                                      
P00680     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE DISCOUNT_RATE CURSOR WITH ROWSET POSITIONING FOR            
MFA-TR*        SELECT FF.FACTOR                                                 
MFA-TR*              ,FF.DURATION_REMAIN_NO                                     
MFA-TR*              ,SF.RT_ATTR_INCTV_TYPE                                     
MFA-TR*              ,SF.FACTOR_DESC                                            
MFA-TR*          FROM                                                           
MFA-TR*               CSS_ACCT_RTPK_AGR  DF                                     
MFA-TR*              ,CSS_FIXED_FCTR     FF                                     
MFA-TR*              ,CSS_SPCL_FCTR      SF                                     
MFA-TR*         WHERE                                                           
MFA-TR*               DF.ACCOUNT_NO         = :UT-ACCOUNT-NO                    
MFA-TR*           AND DF.CODE_UTIL_TYPE     = :UT-CODE-UTIL-TYPE                
MFA-TR*           AND DF.IC_NO              = :UT-IC-NO                         
MFA-TR*           AND DF.RT_PKG_OPT_SEQ_NO  = :DF-RT-PKG-OPT-SEQ-NO             
MFA-TR*           AND FF.ACCOUNT_NO         = DF.ACCOUNT_NO                     
MFA-TR*           AND FF.CODE_UTIL_TYPE     = DF.CODE_UTIL_TYPE                 
MFA-TR*           AND FF.IC_NO              = DF.IC_NO                          
MFA-TR*           AND FF.RT_PKG_OPT_SEQ_NO  = DF.RT_PKG_OPT_SEQ_NO              
MFA-TR*           AND FF.DURATION_REMAIN_NO > 0                                 
MFA-TR*           AND SF.FACTOR_ID          = FF.FACTOR_ID                      
MFA-TR*           AND SF.RT_ATTR_INCTV_TYPE IN ('PRICE DISCOUNT'                
MFA-TR*                                        ,'CSC DISCOUNT'                  
MFA-TR*                                        ,'ADJUSTABLE RATE')              
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7810                                                      
MFA-TR*    END-EXEC.                                                            
P00680***                                                                       
P805CS***CURSOR TO GET THE CSC DISCOUNT DETAILS. AUTORENEW/PAPERLESS            
P805CS     EXEC SQL                                                     
P805CS        DECLARE CSC_DISCOUNT CURSOR FOR                           
P805CS         SELECT CIS.SUBSTR3(G6.PARM_DATA,15,9)                         
P805CS               ,C8.DELINQ_CD                                      
P805CS               ,C8.DELINQ_VALUE                                   
P805CS           FROM CSS_JOB_PARM    G6 WITH(READUNCOMMITTED)                  
P805CS           JOIN CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                  
P805CS             ON C8.DELINQ_CD    = LTRIM(RTRIM(CIS.SUBSTR3(
           G6.PARM_DATA,35,9))) 
P805CS            AND C8.COMPANY_NO   = G6.COMPANY_NO                   
P805CS          WHERE G6.PROGRAM_NAME = 'CPD00444'                      
P805CS            AND G6.COMPANY_NO   = '01'                            
P805CS            AND G6.CMND_CODE    = 'PARM'                          
P805CS            AND G6.STATUS       = 'A'                             
P805CS            AND CIS.SUBSTR3(G6.PARM_DATA,1,14) = 'DISCOUNT_TYPE='      
P805CS            FOR READ ONLY                                 
P805CS                                                      
P805CS     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CSC_DISCOUNT CURSOR FOR                                   
MFA-TR*        SELECT SUBSTR(G6.PARM_DATA,15,9)                                 
MFA-TR*              ,C8.DELINQ_CD                                              
MFA-TR*              ,C8.DELINQ_VALUE                                           
MFA-TR*          FROM CSS_JOB_PARM    G6                                        
MFA-TR*          JOIN CSS_DELINQUENCY C8                                        
MFA-TR*            ON C8.DELINQ_CD    = TRIM(SUBSTR(G6.PARM_DATA,35,9))         
MFA-TR*           AND C8.COMPANY_NO   = G6.COMPANY_NO                           
MFA-TR*         WHERE G6.PROGRAM_NAME = 'CPD00444'                              
MFA-TR*           AND G6.COMPANY_NO   = '01'                                    
MFA-TR*           AND G6.CMND_CODE    = 'PARM'                                  
MFA-TR*           AND G6.STATUS       = 'A'                                     
MFA-TR*           AND SUBSTR(G6.PARM_DATA,1,14) = 'DISCOUNT_TYPE='              
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7835                                                      
MFA-TR*    END-EXEC.                                                            
P805CS***                                                                       
P805CS***CURSOR TO GET THE SPECIAL CORE RATE PLANS.                             
P805CS     EXEC SQL                                                     
P805CS        DECLARE SPCL_RATES CURSOR FOR                             
P805CS         SELECT CIS.SUBSTR3(G6.PARM_DATA,13,3)                         
P805CS               ,CIS.SUBSTR3(G6.PARM_DATA,1,12)                         
P805CS           FROM CSS_JOB_PARM    G6 WITH(READUNCOMMITTED)                  
P805CS          WHERE G6.PROGRAM_NAME = 'CPD00444'                      
P805CS            AND G6.COMPANY_NO   = '01'                            
P805CS            AND G6.CMND_CODE    = 'OPTN'                          
P805CS            AND G6.STATUS       = 'A'                             
P805CS            AND (CIS.SUBSTR3(G6.PARM_DATA,1,12) = 'LEGACY_RATE='       
P805CS              OR CIS.SUBSTR3(G6.PARM_DATA,1,12) = 'OLDCSC_RATE=')      
P805CS            FOR READ ONLY                                 
P805CS                                                      
P805CS     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE SPCL_RATES CURSOR FOR                                     
MFA-TR*        SELECT SUBSTR(G6.PARM_DATA,13,3)                                 
MFA-TR*              ,SUBSTR(G6.PARM_DATA,1,12)                                 
MFA-TR*          FROM CSS_JOB_PARM    G6                                        
MFA-TR*         WHERE G6.PROGRAM_NAME = 'CPD00444'                              
MFA-TR*           AND G6.COMPANY_NO   = '01'                                    
MFA-TR*           AND G6.CMND_CODE    = 'OPTN'                                  
MFA-TR*           AND G6.STATUS       = 'A'                                     
MFA-TR*           AND (SUBSTR(G6.PARM_DATA,1,12) = 'LEGACY_RATE='               
MFA-TR*             OR SUBSTR(G6.PARM_DATA,1,12) = 'OLDCSC_RATE=')              
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7850                                                      
MFA-TR*    END-EXEC.                                                            
P805CS***                                                                       
       PROCEDURE DIVISION.                                              

SCA006        SET DDC-IND TO 1.
SCA006        SET LRATE-INDX TO 1.
SCA006        SET ORATE-INDX TO 1.
      ****************************************************************          
      **                                                            **          
      **  0000-MAINLINE                                             **          
      **      CONTROLS MAIN PROCESSING OF PROGRAM                   **          
      **                                                            **          
      ****************************************************************          
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION     THRU 0100-EXIT.              
P00245*PROCESS THE ONMD ACCOUNTS TO GENERATE WELCOME LETTER                     
P00245         SET PRICE-SHEET-LTR-ONMD    TO TRUE.                     
P00245     PERFORM 7000-OPEN-ONMD-CURSOR   THRU 7000-EXIT.              
P00245     PERFORM 1000-PROCESS-ONMD-ACCT  THRU 1000-EXIT               
P00245       UNTIL WS-END-ONMD-CURSOR.                                  
P00245     PERFORM 7020-CLOSE-ONMD-CURSOR  THRU 7020-EXIT.              
      *                                                                         
P00245*PROCESS THE MKSW ACCOUNTS TO GENERATE WELCOME LETTER                     
P00245         SET PRICE-SHEET-LTR-MKSW    TO TRUE.                     
P00245     PERFORM 7030-OPEN-MKSW-CURSOR   THRU 7030-EXIT.              
P00245     PERFORM 1010-PROCESS-MKSW-ACCT  THRU 1010-EXIT               
P00245       UNTIL WS-END-MKSW-CURSOR                                   
P00245     PERFORM 7050-CLOSE-MKSW-CURSOR  THRU 7050-EXIT.              
      *                                                                         
P00245*PROCESS THE ACCOUNTS TO GENERATE THE RATE CHANGE LETTER                  
P00245         SET RATE-CHANGE-LTR         TO TRUE.                     
P00245     PERFORM 7060-OPEN-RTCHG-CURSOR  THRU 7060-EXIT.              
P00245     PERFORM 1020-PROCESS-RTCHG-ACCT THRU 1020-EXIT               
P00245       UNTIL WS-END-RTCHG-CURSOR                                  
P00245     PERFORM 7080-CLOSE-RTCHG-CURSOR THRU 7080-EXIT.              
      *                                                                         
P00892*PROCESS THE ACCOUNTS TO GENERATE OPT IN LETTER                           
P00892         SET OPTED-IN-LTR            TO TRUE.                     
P00892     PERFORM 7090-OPEN-OPTIN-CURSOR  THRU 7090-EXIT.              
P00892     PERFORM 1030-PROCESS-OPTIN-ACCT THRU 1030-EXIT               
P00892       UNTIL WS-END-OPTIN-CURSOR                                  
P00892     PERFORM 7100-CLOSE-OPTIN-CURSOR THRU 7100-EXIT.              
                                                                        
T34569     IF PROCESS-EXCEPTION                                         
T34569        PERFORM 3000-RECYCLE-ACCTS THRU 3000-EXIT                 
P00245        COMPUTE WS-EXCP-RECS-PROCESSED =                          
P00245                WS-EXCP-RECS-PROCESSED - 14                       
T34569     END-IF.                                                      
                                                                        
           PERFORM 2500-POP-JOB-PARM    THRU 2500-EXIT.                 
           PERFORM 8000-UPDATE-JOB-PARM THRU 8000-EXIT.                 
                                                                        
P00245     IF WS-EXCP-RECS-WRITTEN = 0                                  
C34569        WRITE EXCEP153-REC        FROM WS-NO-DATA-LINE            
C34569     END-IF.                                                      
                                                                        
           PERFORM 9000-TERMINATE       THRU 9000-EXIT.                 
           PERFORM 9500-DISPLAY-STATS   THRU 9500-EXIT.                 
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  0100-INITIALIZATION                                       **          
      **      COMMON INITIALIZATION ROUTINE                         **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           INITIALIZE WS-WORK-VARIABLES.                                
P00245     MOVE ZEROS                  TO WS-ONMD-ACCTS-PROCESSED       
P00245                                    WS-MKSW-ACCTS-PROCESSED       
P00245                                    WS-RTCHG-ACCTS-PROCESSED      
P00892                                    WS-OPTIN-ACCTS-PROCESSED      
P00245                                    WS-PRC-SHT-SKIP-COUNT         
P00245                                    WS-RTCHG-SKIP-COUNT           
P00892                                    WS-OPTIN-SKIP-COUNT           
P00245                                    WS-PRC-SHT-LTR-COUNT          
P00245                                    WS-RTCHG-LTR-COUNT            
P00245                                    WS-EXCP-RECS-LTR-COUNT        
P00245                                    WS-EXCP-RECS-PROCESSED        
P00245                                    WS-EXCP-RECS-WRITTEN.         
T34569     MOVE 'N'                    TO WS-EXCEPTION-FLOW.            
P00245     MOVE SPACES                 TO WS-LETTER-TYPE.               
                                                                        
      **   SET ALL CONDITION NAMES TO THEIR DEFAULT VALUES                      
P00245     SET WS-NOT-END-ONMD-CURSOR  TO TRUE.                         
P00245     SET WS-NOT-END-MKSW-CURSOR  TO TRUE.                         
P00245     SET WS-NOT-END-RTCHG-CURSOR TO TRUE.                         
P00892     SET WS-NOT-END-OPTIN-CURSOR TO TRUE.                         
           SET WS-NOT-END-GAS-CUR      TO TRUE.                         
           SET WS-NO-JOBPARM-UPDATED   TO TRUE.                         
           SET FIRST-TIME              TO TRUE.                         
C34569     SET DONT-SKIP-ACCOUNT       TO TRUE.                         
                                                                        
      **   GETS THE PARM DATA FROM JOB_PARM_TABLE                               
           PERFORM 0200-GET-PARM-DATA       THRU 0200-EXIT.             
A04132     MOVE WS-LAST-RUN-DATE    TO WS-LAST-RUN-DATE-TS(1:10)        
A04132     MOVE WS-LAST-RUN-TIME    TO WS-LAST-RUN-DATE-TS(11:16)       
A04132     MOVE WS-COMMON-RUN-DATE  TO WS-COMMON-RUN-DATE-TS(1:10)      
A04132     PERFORM 7800-GET-TIMESTAMP   THRU 7800-EXIT.                 
A04132     MOVE WS-TIMESTAMP(11:16)     TO WS-COMMON-RUN-DATE-TS(11:16).
                                                                        
C34569**   LOAD THE WS-TABLE WITH THE DDDC FACTORS                              
C34569     MOVE 0                           TO DDC-CNT.                 
C34569     SET WS-NOT-END-DDDC-CSR          TO TRUE.                    
C34569     PERFORM 7630-OPEN-DDDC-FACTORS   THRU 7630-EXIT.             
C34569     PERFORM 7640-FETCH-DDDC-FACTORS  THRU 7640-EXIT              
C34569       UNTIL WS-END-DDDC-CSR.                                     
C34569     PERFORM 7650-CLOSE-DDDC-FACTORS  THRU 7650-EXIT.             
                                                                        
P805CS**   LOAD CSC DISCOUNT DELINQUENCY VALUES.                                
P805CS     MOVE 0                           TO WS-AUTORENEW-DSCNT-AMT   
P805CS                                         WS-PAPERLESS-DSCNT-AMT.  
P805CS     PERFORM 7835-OPEN-CSC-DISCOUNT   THRU 7835-EXIT.             
P805CS     PERFORM 7840-FETCH-CSC-DISCOUNT  THRU 7840-EXIT              
P805CS       UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.               
P805CS     PERFORM 7845-CLOSE-CSC-DISCOUNT  THRU 7845-EXIT.             
                                                                        
P805CS**   LOAD SPECIAL RATES FROM JOB PARM                                     
P805CS     MOVE 0                           TO LRATE-CNT                
P805CS                                         ORATE-CNT.               
P805CS     PERFORM 7850-OPEN-SPCL-RATES     THRU 7850-EXIT.             
P805CS     PERFORM 7855-FETCH-SPCL-RATES    THRU 7855-EXIT              
P805CS       UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.               
P805CS     PERFORM 7860-CLOSE-SPCL-RATES    THRU 7860-EXIT.             
                                                                        
C34569     OPEN OUTPUT FCSCA916-FILE                                    
C34569                 EXCEP153-FILE.                                   
T34569     OPEN INPUT  PXCEP153-FILE.                                   
      *                                                                         
C34569     MOVE 'SEBC153'                  TO MAIL2-JOB-NAME            
C34569                                        MAIL5-JOB-NAME.           
C34569     MOVE WS-SUBJECT                 TO MAIL7-SUBJECT.            
C34569     WRITE EXCEP153-REC              FROM MAILHEAD-1.             
C34569     WRITE EXCEP153-REC              FROM MAILHEAD-2.             
C34569     WRITE EXCEP153-REC              FROM MAILHEAD-3.             
C34569     WRITE EXCEP153-REC              FROM MAILHEAD-4.             
C34569     WRITE EXCEP153-REC              FROM MAILHEAD-5.             
C34569     WRITE EXCEP153-REC              FROM MAILHEAD-6.             
C34569     WRITE EXCEP153-REC              FROM MAILHEAD-7.             
C34569     WRITE EXCEP153-REC              FROM MAILHEAD-8.             
P00245     WRITE EXCEP153-REC              FROM WS-LINE-110.            
C34569     WRITE EXCEP153-REC              FROM WS-EXC1-HEADER-1.       
P00245     WRITE EXCEP153-REC              FROM WS-LINE-110.            
C34569     WRITE EXCEP153-REC              FROM WS-EXC1-HEADER-2.       
P00245     WRITE EXCEP153-REC              FROM WS-EXC1-HEADER-3.       
P00245     WRITE EXCEP153-REC              FROM WS-LINE-110.            
C34569*                                                                         
T34569     PERFORM 7700-READ-PXCEP153 THRU 7700-EXIT                    
T34569       UNTIL HDR1-DATE-TXT = 'DATE: '                             
T34569          OR P153-END-FILE.                                       
T34569                                                                  
T34569     IF P153-SUCCESSFUL AND                                       
T34569        PROCESS-EXCEPTION AND                                     
T34569        HDR1-LAST-RUN-DATE NOT EQUAL WS-LAST-RUN-DATE             
T34569        DISPLAY '********************************************'    
T34569        DISPLAY '** INCORRECT GENERATION OF EXCEPTION FILE **'    
T34569        DISPLAY '**      PROVIDE CORRECT GENERATION OR     **'    
T34569        DISPLAY '**      TURN OFF EXCEPTION PROCESSING     **'    
T34569        DISPLAY '** LAST RUN DATE : ' WS-LAST-RUN-DATE            
T34569        DISPLAY '** EXCEPTION FILE DATE : ' HDR1-LAST-RUN-DATE    
T34569        DISPLAY '********************************************'    
T34569        PERFORM 9900-ABEND    THRU 9900-EXIT                      
T34569     END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *   0200-GET-PARM-DATA                                          *         
      *        ACCESS OF COMMON-DATE RECORD                           *         
      *        GET RUN DATE OR COMMON RUN DATE                        *         
      *****************************************************************         
       0200-GET-PARM-DATA.                                              
      *                                                                         
           MOVE SPACES                        TO WS-SYSIPT              
           MOVE SPACES                        TO WS-INPUT-DATA-BREAKDOWN
           MOVE WS-PGRMNAME                   TO WS-PROGRAM             
           MOVE WS-DATE                       TO WS-COMMAND             
           MOVE 10                            TO WS-SEQUENCE            
           MOVE WS-KEY-AREA                   TO E-FJC01-KEY            
           PERFORM 7600-START-FCSJC01  THRU  7600-EXIT                  
           PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
                      UNTIL (LAST-RUN-DATE AND INPUT-ACTIVE)            
                                 OR  END-OF-SYSIPT                      
           IF  WS-L-RUN-DATE-MM  NUMERIC AND                            
               WS-L-RUN-DATE-DD  NUMERIC AND                            
               WS-L-RUN-DATE-YY  NUMERIC                                
               PERFORM 7611-CLOSE THRU 7611-EXIT                        
               MOVE  G6-PARM-DATA                  TO WS-CA153-PARM     
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '** ' WS-PGRMNAME ' PROCESSING ERROR  **'        
               DISPLAY '**  LAST RUN DATE IN PCSCA153 IS NOT ACTIVE'    
               DISPLAY '**    KEY = ' E-FJC01-KEY                       
               DISPLAY '**  PROCESSING TERMINATED  **'                  
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
                                                                        
           MOVE SPACES                        TO WS-SYSIPT              
           MOVE SPACES                        TO WS-INPUT-DATA-BREAKDOWN
           PERFORM 6251-GET-FJC01-DATE        THRU 6251-EXIT.           
      *                                                                         
           IF COMMON-DATE-NEEDED                                        
              MOVE SPACES                     TO WS-SYSIPT              
              MOVE SPACES                     TO WS-INPUT-DATA-BREAKDOWN
              MOVE 'COMMON'                   TO WS-PROGRAM             
              MOVE WS-DATE                    TO WS-COMMAND             
              MOVE ZEROS                      TO WS-SEQUENCE            
              MOVE WS-KEY-AREA                TO E-FJC01-KEY            
              PERFORM 7600-START-FCSJC01  THRU  7600-EXIT               
              PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT               
                      UNTIL (RUN-DATE AND INPUT-ACTIVE)                 
                                 OR  END-OF-SYSIPT                      
              IF WS-INPUT-RUN-DATE-MM  NUMERIC AND                      
                 WS-INPUT-RUN-DATE-DD  NUMERIC AND                      
                 WS-INPUT-RUN-DATE-YY  NUMERIC                          
                 PERFORM 7611-CLOSE THRU 7611-EXIT                      
                 MOVE  G6-PARM-DATA           TO WS-COMMON-PARM         
              ELSE                                                      
                 DISPLAY ' '                                            
                 DISPLAY '** ' WS-PGRMNAME ' PROCESSING ERROR  **'      
                 DISPLAY '**  COMMON IS NOT ACTIVE'                     
                 DISPLAY '**    KEY = ' E-FJC01-KEY                     
                 DISPLAY '**  PROCESSING TERMINATED  **'                
                 PERFORM 9900-ABEND  THRU  9900-EXIT                    
              END-IF                                                    
           ELSE                                                         
              MOVE G6-PARM-DATA               TO WS-COMMON-PARM         
           END-IF.                                                      
C34569                                                                  
P00677     MOVE G6-PARM-DATA (10:10)   TO WS-COMMON-DATE                
C34569                                    WS-SUB-DATE                   
C34569                                    P-EXC1-DATE.                  
                                                                        
C34569     MOVE SPACES                 TO WS-SYSIPT.                    
C34569     MOVE 'COMMON'               TO WS-PROGRAM.                   
C34569     MOVE WS-DATE                TO WS-COMMAND.                   
C34569     MOVE ZEROS                  TO WS-SEQUENCE.                  
C34569     MOVE WS-KEY-AREA            TO E-FJC01-KEY.                  
C34569                                                                  
C34569     PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
C34569                                                                  
C34569     PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
C34569         UNTIL (REVENUE-MONTH AND INPUT-ACTIVE)                   
C34569            OR  END-OF-SYSIPT.                                    
C34569                                                                  
C34569     EVALUATE TRUE                                                
C34569        WHEN END-OF-SYSIPT                                        
C34569           DISPLAY '**     PCSCA153 PROCESSING ERROR   **'        
C34569           DISPLAY '**  NO ACTIVE REVENUE MONTH IN COMMON'        
C34569           DISPLAY '**       PROCESSING TERMINATED     **'        
C34569           PERFORM 9900-ABEND    THRU  9900-EXIT                  
C34569        WHEN OTHER                                                
C34569           PERFORM 7611-CLOSE    THRU 7611-EXIT                   
C34569     END-EVALUATE.                                                
T34569                                                                  
T34569     MOVE WS-REVENUE-MONTH-PARM  TO WS-COMMON-REV-MNTH.           
      *                                                                         
T34569     MOVE SPACES                 TO WS-SYSIPT.                    
T34569     MOVE WS-PGRMNAME            TO WS-PROGRAM.                   
T34569     MOVE WS-PARM                TO WS-COMMAND.                   
T34569     MOVE ZEROS                  TO WS-SEQUENCE.                  
T34569     MOVE WS-KEY-AREA            TO E-FJC01-KEY.                  
T34569                                                                  
T34569     PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
T34569                                                                  
T34569     PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
T34569         UNTIL (G6-PARM-DATA (1:9) = 'EXCEPTION' AND INPUT-ACTIVE)
T34569            OR  END-OF-SYSIPT.                                    
T34569                                                                  
T34569     EVALUATE TRUE                                                
T34569        WHEN END-OF-SYSIPT                                        
T34569           DISPLAY '**         PCSCA153 PROCESSING ERROR      **' 
T34569           DISPLAY '**   EXCEPTION PROCESS OPTION NOT PRESENT **' 
T34569           DISPLAY '**           PROCESSING TERMINATED        **' 
T34569           PERFORM 9900-ABEND    THRU  9900-EXIT                  
T34569        WHEN OTHER                                                
T34569           PERFORM 7611-CLOSE    THRU 7611-EXIT                   
T34569     END-EVALUATE.                                                
T34569                                                                  
T34569     SET  DONT-PROCESS-EXCEPTION TO TRUE.                         
T34569     MOVE G6-PARM-DATA (11:1)    TO WS-EXCEPTION-PROCESS-SW.      
      *                                                                         
P00581**   GET JOB PARM DATA FOR RCC, TON, RT CHK CHARGES ETC                   
P00581     PERFORM 0300-GET-OTHER-PARM-DATA       THRU 0300-EXIT.       
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00581*================================================================*        
P00581 0300-GET-OTHER-PARM-DATA.                                        
P00581*================================================================*        
P00581*                                                                         
P00581     INITIALIZE WS-JOB-PARM-TABLE.                                
P00581*                                                                         
P00581     PERFORM 7510-OPEN-JOB-PARM-CURSOR   THRU 7510-EXIT.          
P00581     PERFORM 7520-FETCH-JOB-PARM-CURSOR  THRU 7520-EXIT.          
P00581     PERFORM 7530-CLOSE-JOB-PARM-CURSOR  THRU 7530-EXIT.          
P00581*                                                                         
P00581     IF WS-JOB-PARM-COUNT  = 0                                    
P00581        DISPLAY '*********************************************'   
P00581        DISPLAY '*** ZERO ROWS SELECTED FROM CSS_JOB_PARM   **'   
P00581        DISPLAY '**  PROGRAM ABORTING...                    **'   
P00581        DISPLAY '*********************************************'   
P00581        PERFORM 9900-ABEND            THRU 9900-EXIT              
P00581     END-IF                                                       
P00581*                                                                         
P00677     IF WS-JOB-PARM-COUNT   >= 50                                 
P00581        DISPLAY '*********************************************'   
P00581        DISPLAY '***         ARRAY OVERFLOW:               ***'   
P00677        DISPLAY '** EXPECTED CSS_JOB_PARM ROWS ARE BELOW 50 **'   
P00581        DISPLAY '**  PROGRAM ABORTING...                    **'   
P00677        DISPLAY '**  PROGRAMMING CHANGE REQUIRED.          ***'   
P00581        DISPLAY '*********************************************'   
P00581        PERFORM 9900-ABEND            THRU 9900-EXIT              
P00581     END-IF.                                                      
P00581*                                                                         
P00581     PERFORM VARYING WS-JP-SUB FROM 1 BY 1                        
P00581                           UNTIL WS-JP-SUB > WS-JOB-PARM-COUNT    
P00581        MOVE TAB-PARM-DATA (WS-JP-SUB) TO WS-PARSE-PARM-DATA      
P00581        IF WS-PARSE-NEW-DELINQ-CD > SPACES                        
P00581           AND WS-PARSE-OLD-DELINQ-CD > SPACES                    
P00581           AND WS-PARSE-EFF-DATE      > SPACES                    
P00581           CONTINUE                                               
P00581        ELSE                                                      
P00581           DISPLAY '*******************************************'  
P00581           DISPLAY '** INVALID DATA FROM CSS_JOB_PARM TABLE  **'  
P00581           DISPLAY '**  PROGRAM NAME :'                           
P00581                                   TAB-PROGRAM-NAME (WS-JP-SUB)   
P00581           DISPLAY '**  PARM DATA    :' WS-PARSE-PARM-DATA        
P00581           DISPLAY '**  PROGRAM ABORTING...                  **'  
P00581           DISPLAY '*******************************************'  
P00581           PERFORM 9900-ABEND            THRU 9900-EXIT           
P00581        END-IF                                                    
P00581        MOVE WS-PARSE-EFF-DATE  TO TAB-PARM-EFF-DATE (WS-JP-SUB)  
P00581        MOVE ZEROS   TO TAB-NEW-DELINQ-VALUE (WS-JP-SUB)          
P00581                        TAB-OLD-DELINQ-VALUE (WS-JP-SUB)          
P00581        MOVE '01'                       TO C8-COMPANY-NO          
P00581        MOVE WS-PARSE-NEW-DELINQ-CD TO C8-DELINQ-CD               
P00581        PERFORM 7550-GET-DELINQ-VALUE THRU 7550-EXIT              
P00581        MOVE C8-DELINQ-VALUE TO TAB-NEW-DELINQ-VALUE (WS-JP-SUB)  
P00581*                                                                         
P00581        IF WS-PARSE-OLD-DELINQ-CD = WS-PARSE-NEW-DELINQ-CD        
P00581           MOVE TAB-NEW-DELINQ-VALUE (WS-JP-SUB)                  
P00581                              TO TAB-OLD-DELINQ-VALUE (WS-JP-SUB) 
P00581        ELSE                                                      
P00581           MOVE WS-PARSE-OLD-DELINQ-CD TO C8-DELINQ-CD            
P00581           PERFORM 7550-GET-DELINQ-VALUE THRU 7550-EXIT           
P00581           MOVE C8-DELINQ-VALUE     TO                            
P00581                                TAB-OLD-DELINQ-VALUE (WS-JP-SUB)  
P00581        END-IF                                                    
P00581     END-PERFORM.                                                 
P00581*                                                                         
P00581 0300-EXIT.                                                       
P00581     EXIT.                                                        
P00581*                                                                         
      ****************************************************************          
P00245**  1000-PROCESS-ONMD-ACCT.                                   **          
      **      GETS THE NEW ACTIVATED SEB ACCOUNTS ALONG WITH OTHER  **          
      **      DETAILS LIKE OPTION CD, EARLY TERMINATION FEE, DEPOSIT**          
      **      AND WRITES THEM INTO THE FIOCA916 LAYOUT FILE         **          
      ****************************************************************          
P00245 1000-PROCESS-ONMD-ACCT.                                          
      *                                                                         
P00245     MOVE SPACES                          TO WS-ONMD-SVC-START-DT.
P00245     PERFORM 7010-FETCH-ONMD-CURSOR       THRU 7010-EXIT.         
                                                                        
P00245     IF WS-NOT-END-ONMD-CURSOR                                    
              MOVE VO-ACCOUNT-NO                TO AT-ACCOUNT-NO        
              PERFORM 7200-OPEN-GAS-UTIL        THRU 7200-EXIT          
                  SET WS-NOT-END-GAS-CUR        TO TRUE                 
                  SET FIRST-TIME                TO TRUE                 
              PERFORM 7210-FETCH-GAS-UTIL       THRU 7210-EXIT          
              PERFORM 1100-PROCESS-GAS-UTIL     THRU 1100-EXIT          
                UNTIL WS-END-GAS-CUR                                    
              PERFORM 7220-CLOSE-GAS-UTIL       THRU 7220-EXIT          
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00245****************************************************************          
P00245**  1010-PROCESS-MKSW-ACCT.                                   **          
P00245**      GETS THE MARKET SWITCH SEB ACCOUNTS ALONG WITH OTHER  **          
P00245**      DETAILS LIKE OPTION CD, EARLY TERMINATION FEE, DEPOSIT**          
P00245**      AND WRITES THEM INTO THE FIOCA916 LAYOUT FILE         **          
P00245****************************************************************          
P00245 1010-PROCESS-MKSW-ACCT.                                          
P00245*                                                                         
P00245     PERFORM 7040-FETCH-MKSW-CURSOR        THRU 7040-EXIT.        
P00245                                                                  
P00245     SET DONT-SKIP-ACCOUNT                 TO TRUE.               
P00245     IF WS-NOT-END-MKSW-CURSOR                                    
P00245        MOVE VO-ACCOUNT-NO                 TO AT-ACCOUNT-NO       
P00245                                              YP-ACCOUNT-NO       
P00245        PERFORM 7975-GET-MKSW-SVC-START-DT THRU 7975-EXIT         
P00245        IF DONT-SKIP-ACCOUNT                                      
P00245           PERFORM 7230-OPEN-GAS-UTIL-2    THRU 7230-EXIT         
P00245               SET WS-NOT-END-GAS-CUR      TO TRUE                
P00245               SET FIRST-TIME              TO TRUE                
P00245           PERFORM 7240-FETCH-GAS-UTIL-2   THRU 7240-EXIT         
P00245           PERFORM 1100-PROCESS-GAS-UTIL   THRU 1100-EXIT         
P00245             UNTIL WS-END-GAS-CUR                                 
P00245           PERFORM 7250-CLOSE-GAS-UTIL-2   THRU 7250-EXIT         
P00245        END-IF                                                    
P00245     END-IF.                                                      
P00245*                                                                         
P00245 1010-EXIT.                                                       
P00245     EXIT.                                                        
P00245*                                                                         
P00245****************************************************************          
P00245**  1020-PROCESS-RTCHG-ACCT.                                  **          
P00245**      GETS THE RATE CHANGE LETTER ACCOUNTS ALONG WITH OTHER **          
P00245**      DETAILS LIKE OPTION CD, EARLY TERMINATION FEE, CSC AMT**          
P00245**      AND WRITES THEM INTO THE FIOCA916 LAYOUT FILE         **          
P00245****************************************************************          
P00245 1020-PROCESS-RTCHG-ACCT.                                         
P00245*                                                                         
P805CS     INITIALIZE FI-CURR-EXT-DESC-LONG.                            
P00245     PERFORM 7070-FETCH-RTCHG-CURSOR           THRU 7070-EXIT.    
P00245                                                                  
P00245     SET DONT-SKIP-ACCOUNT                     TO TRUE.           
P00245     IF WS-NOT-END-RTCHG-CURSOR                                   
P00245*CHECK IF RATE CHANGE IS DUE TO INTROVAR DROP TO VARIABLE RATE            
P00245*DO NOT SEND RATE CHANGE LETTER FOR INTROVAR DROP TO VAR RATE.            
P00245        IF DF-AGREEMNT-SOURCE-CD = 'VDN'                          
P00245           MOVE SPACES TO WS-PREV-OPT-CALC-TYPE-CD                
P00245           PERFORM 7660-CHK-PREV-OPTION-CD     THRU 7660-EXIT     
P00245           IF DONT-SKIP-ACCOUNT                                   
P00245              IF WS-PREV-OPT-CALC-TYPE-CD = 'IV'                  
P00245                 DISPLAY 'RATE CHANGE LETTER ACCOUNT'             
P00245                 DISPLAY 'INTRO VARIABLE DROP : ' AT-ACCOUNT-NO   
P00245                 SET SKIP-ACCOUNT     TO TRUE                     
P00245                 ADD +1               TO WS-RTCHG-SKIP-COUNT      
P00245              END-IF                                              
P00245           END-IF                                                 
P00245        END-IF                                                    
P00245        IF DONT-SKIP-ACCOUNT                                      
P00245           MOVE AT-ACCOUNT-NO                  TO VO-ACCOUNT-NO   
P00245           PERFORM 1200-GET-ACCT-DETS          THRU 1200-EXIT     
P00245           IF DONT-SKIP-ACCOUNT                                   
P00581              MOVE VO-ACCOUNT-NO     TO DD-ACCOUNT-NO             
P00581              MOVE SPACES            TO WS-TIER-ACCT-TYPE-CODE    
P00581              PERFORM 7500-CHK-ACCT-MKT-TIER   THRU 7500-EXIT     
P00245              PERFORM 2000-POPULATE-INFO       THRU 2000-EXIT     
P00245              IF DONT-SKIP-ACCOUNT                                
A00775                 INITIALIZE WS-INSERTED                           
A00775                 MOVE ZEROS                    TO WS-803-CTR      
P00245                 PERFORM 8200-INSERT-CUST-COMM THRU 8200-EXIT     
A00775                          UNTIL INSERTED                          
P00245                 PERFORM 8300-UPD-TRANS-HIST   THRU 8300-EXIT     
P00245              END-IF                                              
P00245           END-IF                                                 
P00245        END-IF                                                    
P00245     END-IF.                                                      
P00245*                                                                         
P00245 1020-EXIT.                                                       
P00245     EXIT.                                                        
P00245*                                                                         
P00892****************************************************************          
P00892**  1030-PROCESS-OPTIN-ACCT.                                  **          
P00892**      GETS THE OPTED IN LETTER ACCOUNTS AND DETAILS         **          
P00892****************************************************************          
P00892 1030-PROCESS-OPTIN-ACCT.                                         
P00892*                                                                         
P805CS     INITIALIZE FI-CURR-EXT-DESC-LONG.                            
P00892     PERFORM 7095-FETCH-OPTIN-CURSOR           THRU 7095-EXIT.    
P00892                                                                  
P00892     SET DONT-SKIP-ACCOUNT                     TO TRUE.           
P00892     IF WS-NOT-END-OPTIN-CURSOR                                   
P00892        IF DONT-SKIP-ACCOUNT                                      
P00892           MOVE AT-ACCOUNT-NO                  TO VO-ACCOUNT-NO   
P00892           PERFORM 1200-GET-ACCT-DETS          THRU 1200-EXIT     
P00892           IF DONT-SKIP-ACCOUNT                                   
P00892              MOVE VO-ACCOUNT-NO     TO DD-ACCOUNT-NO             
P00892              MOVE SPACES            TO WS-TIER-ACCT-TYPE-CODE    
P00892              PERFORM 7500-CHK-ACCT-MKT-TIER   THRU 7500-EXIT     
P00892              PERFORM 2000-POPULATE-INFO       THRU 2000-EXIT     
P00892              IF DONT-SKIP-ACCOUNT                                
P00892                 INITIALIZE WS-INSERTED                           
P00892                 MOVE ZEROS                    TO WS-803-CTR      
P00892                 PERFORM 8200-INSERT-CUST-COMM THRU 8200-EXIT     
P00892                          UNTIL INSERTED                          
P00892                 PERFORM 8300-UPD-TRANS-HIST   THRU 8300-EXIT     
P00892              END-IF                                              
P00892           END-IF                                                 
P00892        END-IF                                                    
P00892     END-IF.                                                      
P00892                                                                  
P00892 1030-EXIT.                                                       
P00892     EXIT.                                                        
P00892                                                                  
      ****************************************************************          
      **  1100-PROCESS-GAS-UTIL                                     **          
      **      PROCESS EACH IC FOR THE ACCOUNT WITH ACTIVE METER     **          
      **      IN MTRD_ENVRNMT. FETCH ADDITIONAL INFORMATION.        **          
      ****************************************************************          
      *                                                                         
       1100-PROCESS-GAS-UTIL.                                           
      *                                                                         
C34569     SET DONT-SKIP-ACCOUNT            TO TRUE.                    
C34569     MOVE VO-ACCOUNT-NO               TO DD-ACCOUNT-NO.           
P00581     MOVE SPACES                      TO WS-TIER-ACCT-TYPE-CODE   
C34569     PERFORM 7500-CHK-ACCT-MKT-TIER   THRU 7500-EXIT.             
P00581     IF MKT-REQUIRED-ACCT-TYPES                                   
P00581        CONTINUE                                                  
P00581     ELSE                                                         
P00581        DISPLAY 'TIER_ACCT_TYPE_CD NOT IN D, A, 1, 2, S, B : '    
P00581                                    DD-ACCOUNT-NO                 
P00581        SET SKIP-ACCOUNT         TO TRUE                          
P00581        ADD +1                   TO WS-PRC-SHT-SKIP-COUNT         
P00581     END-IF.                                                      
C34569                                                                  
C34569     IF DONT-SKIP-ACCOUNT                                         
C34569        PERFORM 1200-GET-ACCT-DETS    THRU 1200-EXIT              
C34569        IF DONT-SKIP-ACCOUNT                                      
C34569           MOVE VO-ACCOUNT-NO         TO DO-ACCOUNT-NO            
C34569           PERFORM 7400-SELECT-DEP-ON-HAND THRU 7400-EXIT         
C34569           PERFORM 2000-POPULATE-INFO THRU 2000-EXIT              
A00775           INITIALIZE WS-INSERTED                                 
A00775           MOVE ZEROS                    TO WS-803-CTR            
T34569           PERFORM 8200-INSERT-CUST-COMM THRU 8200-EXIT           
A00775                   UNTIL INSERTED                                 
T34569           PERFORM 8300-UPD-TRANS-HIST THRU 8300-EXIT             
C34569        END-IF                                                    
C34569     END-IF.                                                      
                                                                        
P805CS     INITIALIZE           FI-CURR-EXT-DESC-LONG.                  
P00245     IF PRICE-SHEET-LTR-MKSW                                      
P00245        PERFORM 7240-FETCH-GAS-UTIL-2 THRU 7240-EXIT              
P00245     ELSE                                                         
              PERFORM 7210-FETCH-GAS-UTIL   THRU 7210-EXIT              
P00245     END-IF.                                                      
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C34569****************************************************************          
C34569**  1200-GET-ACCT-DETS.                                       **          
C34569**      CALL THE SUB-ROUTINE SCSCB063 TO GET THE DETAILS BASED**          
C34569**      ON THE OPTION CODE FOR EACH ACCOUNT                   **          
C34569****************************************************************          
C34569*                                                                         
C34569 1200-GET-ACCT-DETS.                                              
C34569*                                                                         
C34569** POPULATE THE LINKAGE VARIABLES                                         
C34569     MOVE FI-OPTION-CD           TO WS-OPTION-CD.                 
C34569     MOVE VO-ACCOUNT-NO          TO WS-ACCOUNT-NO-063.            
C34569     MOVE 'G'                    TO WS-CODE-UTIL-TYPE-063.        
C34569     MOVE UT-IC-NO               TO WS-IC-NO-063.                 
A03280*                                                                         
A03280     IF RATE-CHANGE-LTR                                           
P00805        IF DF-STATUS-CD = 'A'                                     
A03280           MOVE 'PCSC153R'       TO WS-CPD063-CALLING-PGM         
P00805        ELSE                                                      
P00805           MOVE PROGRAM-NAME     TO WS-CPD063-CALLING-PGM         
P00805        END-IF                                                    
A03280     ELSE                                                         
C34569        MOVE PROGRAM-NAME        TO WS-CPD063-CALLING-PGM         
A03280     END-IF.                                                      
A03280*                                                                         
C34569     MOVE 'Y'                    TO WS-THERM-CSC-ACCT-FL.         
P00805     MOVE 'Y'                    TO WS-PENDING-OPTION-FL-063.     
C34569     MOVE ZEROS                  TO RS-RETURN-CODE.               
C34569                                                                  
C34569     CALL SCSCB063               USING CWS00063-FIELDS,           
C34569                                       ABEND-FILE,                
C34569                                       RS-RETURN-CODE.            
C34569                                                                  
C34569     IF RS-RETURN-CODE = SUCCESSFUL-CALL                          
C34569        SET DONT-SKIP-ACCOUNT         TO TRUE                     
C34569     ELSE                                                         
C34569        SET SKIP-ACCOUNT              TO TRUE                     
P00892        IF OPTED-IN-LTR                                           
P00892           DISPLAY 'OPTED IN LETTER ACCOUNT'                      
P00892           ADD +1                     TO WS-OPTIN-SKIP-COUNT      
P00892        ELSE                                                      
P00245          IF RATE-CHANGE-LTR                                      
P00245             DISPLAY 'RATE CHANGE LETTER ACCOUNT'                 
P00245             ADD +1                     TO WS-RTCHG-SKIP-COUNT    
P00245          ELSE                                                    
P00245             DISPLAY 'PRICE SHEET LETTER ACCOUNT'                 
P00245             ADD +1                     TO WS-PRC-SHT-SKIP-COUNT  
T34569             INITIALIZE EXCEP153-REC                              
T34569                      WS-EXCP-LINE                                
T34569             MOVE WS-063-INVL-ERR-MSG   TO EL-MESSAGE             
T34569             PERFORM 4000-PROCESS-EXCEPTION THRU 4000-EXIT        
P00245          END-IF                                                  
P00892        END-IF                                                    
C34569        DISPLAY 'SCSCB063 ACCOUNT NUMBER : ' VO-ACCOUNT-NO        
C34569        DISPLAY 'SCSCB063 CALL INVALID RETURN CODE '              
P00245                                             RS-RETURN-CODE       
C34569     END-IF.                                                      
C34569*                                                                         
C34569 1200-EXIT.                                                       
C34569     EXIT.                                                        
C34569*                                                                         
P00245****************************************************************          
P00245**  1300-GET-REN-OFFER.                                       **          
P00245**  CALL SUBROUTINE SCSCA328 TO GET THE NEW RENEWAL OFFER CODE**          
P00245**  GET THE LAST OFFER AND OPTION CODE                        **          
P00245****************************************************************          
P00245 1300-GET-REN-OFFER.                                              
P00245                                                                  
P00245     MOVE VO-ACCOUNT-NO               TO WS-IN-ACCOUNT-NO.        
P00245     MOVE 'G'                         TO WS-IN-CODE-UTIL-TYPE.    
P00245     MOVE UT-IC-NO                    TO WS-IN-IC-NO.             
P00245     MOVE FI-OPTION-CD                TO WS-IN-OPTION-CD.         
P00245     MOVE PROGRAM-NAME                TO WS-CPD00328-CALLING-PGM. 
P00245     MOVE SPACES                      TO ABEND-FILE.              
P00245     MOVE ZERO                        TO RS-RETURN-CODE.          
P00245                                                                  
P00245     CALL SCSCA328 USING                 CWS00328-FIELDS          
P00245                                         WS-RESULT-TABLE          
P00245                                         ABEND-FILE               
P00245                                         RS-RETURN-CODE.          
P00245                                                                  
P00245     MOVE RS-RETURN-CODE              TO RS-RETURN-CODE-DISP.     
P00245                                                                  
P00245     IF RS-RETURN-CODE = SUCCESSFUL-CALL                          
P00245        IF WS-SUB-CTR > 0                                         
ACT208           MOVE WS-RET-CURR-EXT-DESC-LONG(WS-SUB-CTR)             
P00245                                      TO E-CA916-ALPHA-VARIABLE-10
P00245           MOVE WS-RET-OPTION-CD(WS-SUB-CTR)                      
P00245                                      TO E-CA916-ALPHA-VARIABLE-7 
P00245        ELSE                                                      
P00892           IF OPTED-IN-LTR                                        
P00892              DISPLAY 'OPTED IN LETTER ACCOUNT'                   
P00892              ADD +1                  TO WS-OPTIN-SKIP-COUNT      
P00892           ELSE                                                   
P00245             IF RATE-CHANGE-LTR                                   
P00245                DISPLAY 'RATE CHANGE LETTER ACCOUNT'              
P00245                ADD +1                  TO WS-RTCHG-SKIP-COUNT    
P00245             ELSE                                                 
P00245                DISPLAY 'PRICE SHEET LETTER ACCOUNT'              
P00245                ADD +1                  TO WS-PRC-SHT-SKIP-COUNT  
ACT208             END-IF                                               
P00245             INITIALIZE EXCEP153-REC                              
P00245                        WS-EXCP-LINE                              
P00245             MOVE WS-328-NO-RNWL-OPTN-MSG TO EL-MESSAGE           
P00245             PERFORM 4000-PROCESS-EXCEPTION THRU 4000-EXIT        
P00245             SET SKIP-ACCOUNT        TO TRUE                      
P00892           END-IF                                                 
P00245           DISPLAY 'SCSCA328 CALL ACCOUNT NUMBER : ' VO-ACCOUNT-NO
P00245           DISPLAY 'SCSCA328 CALL OPTION CODE    : ' FI-OPTION-CD 
P00245           DISPLAY 'SCSCA328 RENEWAL OPTION CODE NOT FOUND '      
P00245        END-IF                                                    
P00245     ELSE                                                         
P00892        IF OPTED-IN-LTR                                           
P00892           DISPLAY 'OPTED IN LETTER ACCOUNT'                      
P00892           ADD +1                  TO WS-OPTIN-SKIP-COUNT         
P00892        ELSE                                                      
P00245          IF RATE-CHANGE-LTR                                      
P00245             DISPLAY 'RATE CHANGE LETTER ACCOUNT'                 
P00245             ADD +1                         TO WS-RTCHG-SKIP-COUNT
P00245          ELSE                                                    
P00245             DISPLAY 'PRICE SHEET LETTER ACCOUNT'                 
P00245             ADD +1                       TO WS-PRC-SHT-SKIP-COUNT
ACT208          END-IF                                                  
P00245          INITIALIZE EXCEP153-REC                                 
P00245                     WS-EXCP-LINE                                 
P00245          MOVE WS-328-INVL-ERR-MSG       TO EL-MESSAGE            
P00245          PERFORM 4000-PROCESS-EXCEPTION THRU 4000-EXIT           
P00245          SET SKIP-ACCOUNT               TO TRUE                  
P00892        END-IF                                                    
P00245        DISPLAY 'SCSCA328 CALL ACCOUNT NUMBER : ' VO-ACCOUNT-NO   
P00245        DISPLAY 'SCSCA328 CALL OPTION CODE    : ' FI-OPTION-CD    
P00245        DISPLAY 'SCSCA328 CALL INVALID RETURN CODE '              
P00245                                             RS-RETURN-CODE-DISP  
P00245     END-IF.                                                      
P00245                                                                  
P00245 1300-EXIT.                                                       
P00245     EXIT.                                                        
P00245*                                                                         
      ****************************************************************          
      **  2000-POPULATE-INFO                                        **          
      **      POPULATE THE CA916 FIELDS WITH THE VALUES RETREIVED   **          
      ****************************************************************          
      *                                                                         
       2000-POPULATE-INFO.                                              
      *                                                                         
C34569     INITIALIZE FIOCA916.                                         
C34569     MOVE VO-ACCOUNT-NO               TO E-CA916-ACCOUNT-NO.      
P00892     IF OPTED-IN-LTR                                              
P00892        MOVE 10501                    TO E-CA916-MESSAGE-NO       
P00892        MOVE '45'                     TO E-CA916-COMM-TYPE-CD     
P00892        MOVE '23'                     TO E-CA916-COMM-SUBTYP-CD   
P00892     ELSE                                                         
P00245       IF RATE-CHANGE-LTR                                         
P00245          MOVE 10401                    TO E-CA916-MESSAGE-NO     
P00245          MOVE '45'                     TO E-CA916-COMM-TYPE-CD   
P00245          MOVE '10'                     TO E-CA916-COMM-SUBTYP-CD 
P00245       ELSE                                                       
C34569          MOVE 10301                    TO E-CA916-MESSAGE-NO     
P00245          MOVE '22'                     TO E-CA916-COMM-TYPE-CD   
P00245          MOVE '10'                     TO E-CA916-COMM-SUBTYP-CD 
ACT200          MOVE DF-AGREEMNT-SOURCE-CD TO E-CA916-AGREEMNT-SOURCE-CD
ACT200          MOVE DF-AUTO-REN-OPT-IN-FL                              
ACT200            TO E-CA916-CURR-AUTO-REN-OPT-IN                       
P00245       END-IF                                                     
P00892     END-IF.                                                      
C34569     MOVE '01'                        TO E-CA916-COMPANY-NO.      
A02003     MOVE FI-OPTION-CD                TO E-CA916-REN-OPT-CD(1).   
C34569     MOVE AT-CUSTOMER-NO              TO E-CA916-CUSTOMER-NO.     
C34569     MOVE AT-ADDRESS-ID               TO E-CA916-ADDRESS-ID.      
C34569     MOVE AT-ADDRESS-FORMAT           TO E-CA916-ADDRESS-FORMAT.  
P00453     MOVE AT-CODES-DATA-PRESENT       TO WS-CODES-DATA-PRESENT.   
P00453     IF WS-CODE-PRE-PAY-PLAN = WS-ACTIVE                          
P00453        MOVE 'P'                      TO E-CA916-ACCT-TYPE-FLAG   
P00453     ELSE                                                         
P00453        MOVE SPACES                   TO E-CA916-ACCT-TYPE-FLAG   
P00453     END-IF.                                                      
C34569                                                                  
P00677     MOVE WS-COMMON-DATE(3:2)         TO                          
C34569                                      E-CA916-STATEMENT-DATE(1:2).
P00677     MOVE WS-COMMON-DATE(6:2)         TO                          
C34569                                      E-CA916-STATEMENT-DATE(3:2).
P00677     MOVE WS-COMMON-DATE(9:2)         TO                          
C34569                                      E-CA916-STATEMENT-DATE(5:2).
C34569                                                                  
P00677     MOVE WS-COMMON-DATE              TO E-CA916-PROCESS-DATE     
P00581                                         WS-FEE-EFF-DATE.         
P00892     PERFORM 7105-GET-OPTIN-60DAY-DATE THRU 7105-EXIT             
P00892     MOVE WS-OPTIN-60DAY-DATE  TO E-CA916-ALPHA-VARIABLE-1        
P00581     IF AT-ACCOUNT-TYPE-CODE = 'R' OR AT-ACCOUNT-TYPE-CODE = 'C'  
P00581        MOVE AT-ACCOUNT-TYPE-CODE  TO WS-ACCOUNT-TYPE-CODE        
P00581     ELSE                                                         
P00581        SET WS-OTHER-ACCT-TYPES    TO TRUE                        
P00581     END-IF                                                       
C34569                                                                  
P805CS     MOVE FI-CURR-EXT-DESC-LONG-TEXT (1:FI-CURR-EXT-DESC-LONG-LEN)
A02003                                     TO E-CA916-PRDSC-OPTION-DESC.
C34569                                                                  
P00680     MOVE DF-STAT-ADJUSTABLE-CD      TO E-CA916-OPT-STAT-ADJ-CD.  
P00680                                                                  
P00680     MOVE 'N'                        TO WS-END-DISCOUNT-CURSOR-SW.
                                                                        
PRJ680***INITIALIZE THE PRICE DISCOUNT DETAILS TABLE.                           
PRJ680     PERFORM VARYING WS-PRC-DISC-DET-IDX FROM 1 BY 1              
PRJ680               UNTIL WS-PRC-DISC-DET-IDX > 5                      
PRJ680        MOVE SPACES                                               
PRJ680          TO E-CA916-PRC-DISC-DESC     (WS-PRC-DISC-DET-IDX)      
PRJ680        MOVE ZEROS                                                
PRJ680          TO E-CA916-PRC-DISC-AMOUNT   (WS-PRC-DISC-DET-IDX)      
PRJ680             E-CA916-PRC-DISC-DURATION (WS-PRC-DISC-DET-IDX)      
PRJ680     END-PERFORM.                                                 
PRJ680                                                                  
PRJ680***INITIALIZE THE CSC DISCOUNT DETAILS TABLE.                             
PRJ680     PERFORM VARYING WS-CSC-DISC-DET-IDX FROM 1 BY 1              
PRJ680               UNTIL WS-CSC-DISC-DET-IDX > 5                      
PRJ680        MOVE SPACES                                               
PRJ680          TO E-CA916-CSC-DISC-DESC     (WS-CSC-DISC-DET-IDX)      
PRJ680        MOVE ZEROS                                                
PRJ680          TO E-CA916-CSC-DISC-AMOUNT   (WS-CSC-DISC-DET-IDX)      
PRJ680             E-CA916-CSC-DISC-DURATION (WS-CSC-DISC-DET-IDX)      
PRJ680     END-PERFORM.                                                 
PRJ680                                                                  
P00680     PERFORM 7810-OPEN-DISCOUNT-CURSOR    THRU 7810-EXIT.         
PRJ680                                                                  
PRJ680     SET WS-PRC-DISC-DET-IDX          TO 1.                       
PRJ680     SET WS-CSC-DISC-DET-IDX          TO 1.                       
PRJ680                                                                  
PRJ680     PERFORM 7820-FETCH-DISCOUNT-CURSOR   THRU 7820-EXIT.         
PRJ680                                                                  
P00680     PERFORM 2300-PROCESS-DISCOUNT-CURSOR THRU 2300-EXIT          
P00680             UNTIL WS-END-DISCOUNT-CURSOR.                        
PRJ680                                                                  
P00680     PERFORM 7830-CLOSE-DISCOUNT-CURSOR   THRU 7830-EXIT.         
C34569                                                                  
P00805     IF RATE-CHANGE-LTR                                           
P00805        IF DF-STATUS-CD = 'P'                                     
A05037           MOVE WS-PEND063-CORE-RATE-PLAN                         
A05037                                      TO WS-SEARCH-RATE-PLAN-NO   
P00805           MOVE WS-PEND063-CALC-TYPE-CD                           
P00805                                      TO WS-TEMP-RT-CALC-TYPE-CD  
P00805        ELSE                                                      
A05037           MOVE WS-CORE-RATE-PLAN-NO  TO WS-SEARCH-RATE-PLAN-NO   
P00805           MOVE WS-RATE-CALC-TYPE-CD  TO WS-TEMP-RT-CALC-TYPE-CD  
P00805        END-IF                                                    
P00805     ELSE                                                         
A05037        MOVE WS-CORE-RATE-PLAN-NO     TO WS-SEARCH-RATE-PLAN-NO   
P00805        MOVE WS-RATE-CALC-TYPE-CD     TO WS-TEMP-RT-CALC-TYPE-CD  
P00805     END-IF.                                                      
                                                                        
P00805     IF WS-TEMP-RT-CALC-TYPE-CD = '02'                            
P00581        MOVE DF-OPT-AGRMT-EFF-DT      TO WS-FEE-EFF-DATE          
PFX001        IF RATE-CHANGE-LTR OR OPTED-IN-LTR                        
P00245           SET DONT-SKIP-ACCOUNT      TO TRUE                     
P00245           MOVE FI-OPTION-CD          TO HQ-OPTION-CD             
P00245           PERFORM 7350-GET-DURATION-NO  THRU 7350-EXIT           
P00245           MOVE HQ-DURATION-NO        TO WS-FF-DURATION-REM       
PFX001        END-IF                                                    
P00245        IF DONT-SKIP-ACCOUNT                                      
A02003           MOVE WS-FF-DURATION-REM    TO E-CA916-REN-OPT-MONTHS(1)
C34569           MOVE FI-OPTION-CD          TO HQ-OPTION-CD             
C34569           MOVE '01'                  TO HQ-COMPANY-NO            
C34569           MOVE WS-EXIT-FEE-CD        TO HQ-RT-ATTR-INCTV-TYPE    
C34569           PERFORM 7300-GET-EXIT-FEE     THRU 7300-EXIT           
C34569           IF DONT-SKIP-ACCOUNT                                   
C34569              MOVE HQ-ATTR-INCTV-VALUE                            
P00245                TO E-CA916-FXD-RT-TERM-FEE                        
C34569              PERFORM 2100-GET-EXPR-DATE THRU 2100-EXIT           
C34569           END-IF                                                 
P00245        END-IF                                                    
C34569     END-IF.                                                      
C34569                                                                  
C34569     IF DONT-SKIP-ACCOUNT                                         
C34569        MOVE RD-REG-GROUP-CD          TO E-CA916-SEB-REG-GROUP    
P00581                                         WS-RATE-GROUP-DEF        
P00805        IF RATE-CHANGE-LTR                                        
P00805           MOVE DF-AGREEMNT-SOURCE-CD                             
P00805              TO E-CA916-AGREEMNT-SOURCE-CD                       
P00805           IF DF-STATUS-CD = 'P'                                  
P00805              MOVE WS-PEND063-CALC-TYPE-CD                        
P00805                                      TO E-RATE-CALC-TYPE-CD      
P00805              MOVE WS-PEND063-THERM-PRICE                         
P00805                                      TO E-CA916-REN-OPT-PRICE(1) 
P00805              MOVE WS-PEND063-CSC-REFND-FL                        
P00805                                      TO E-CA916-FREE-CSC-FLAG    
P00805              MOVE WS-PEND063-CSC-AMT TO E-CA916-CURR-CSC         
P00805              MOVE WS-PEND063-CSC-MNTHS                           
P00805                                      TO E-CA916-REN-OPT-MONTHS(2)
P00892              MOVE DF-AUTO-REN-OPT-IN-FL                          
P00892                TO E-CA916-PEND-AUTO-REN-OPT-IN                   
P00805           ELSE                                                   
C34569              MOVE WS-RATE-CALC-TYPE-CD                           
C34569                                      TO E-RATE-CALC-TYPE-CD      
P00805              MOVE WS-THERM-PRICE     TO E-CA916-REN-OPT-PRICE(1) 
A02003              MOVE WS-CSC-REFND-FL    TO E-CA916-FREE-CSC-FLAG    
A02003              MOVE WS-CSC-AMT         TO E-CA916-CURR-CSC         
A02003              MOVE WS-CSC-MNTHS       TO E-CA916-REN-OPT-MONTHS(2)
P00892              MOVE DF-AUTO-REN-OPT-IN-FL                          
P00892                TO E-CA916-CURR-AUTO-REN-OPT-IN                   
P00805           END-IF                                                 
P00805        ELSE                                                      
C34569           MOVE WS-RATE-CALC-TYPE-CD  TO E-RATE-CALC-TYPE-CD      
A02003           MOVE WS-THERM-PRICE        TO E-CA916-REN-OPT-PRICE(1) 
A02003           MOVE WS-CSC-REFND-FL       TO E-CA916-FREE-CSC-FLAG    
A02003           MOVE WS-CSC-AMT            TO E-CA916-CURR-CSC         
A02003           MOVE WS-CSC-MNTHS          TO E-CA916-REN-OPT-MONTHS(2)
P00805        END-IF                                                    
                                                                        
P00245*FOR INTROVAR OPTION CODES GET THE RENEWAL OPTION CODE                    
P00245        IF FI-OPT-CALC-TYPE-CD = 'IV'                             
P00245           MOVE FI-OPT-CALC-TYPE-CD   TO E-CA916-INTRO-RATE-ATTRIB
P00245           PERFORM 1300-GET-REN-OFFER THRU 1300-EXIT              
P00245        END-IF                                                    
C34569                                                                  
P00245        IF (PRICE-SHEET-LTR-ONMD OR PRICE-SHEET-LTR-MKSW) AND     
P00245            DONT-SKIP-ACCOUNT                                     
C34569           IF WS-NULL-DEPOSIT-AMT < ZERO                          
C34569              MOVE ZERO               TO E-CA916-CUST-DEP-AMT     
C34569           ELSE                                                   
C34569              MOVE DO-AMT-DEPOSIT     TO E-CA916-CUST-DEP-AMT     
C34569           END-IF                                                 
P00245           IF WS-EXCEPTION-FLOW = 'Y'                             
P00245              MOVE DETAIL-SVC-START-DATE(3:2)                     
P00245                                  TO E-CA916-ALPHA-VARIABLE-6(1:2)
P00245              MOVE DETAIL-SVC-START-DATE(6:2)                     
P00245                                  TO E-CA916-ALPHA-VARIABLE-6(3:2)
P00245              MOVE DETAIL-SVC-START-DATE(9:2)                     
P00245                                  TO E-CA916-ALPHA-VARIABLE-6(5:2)
P00245           ELSE                                                   
P00245              IF PRICE-SHEET-LTR-ONMD                             
P00245                 MOVE WS-ONMD-SVC-START-DT(3:2)                   
P00245                                  TO E-CA916-ALPHA-VARIABLE-6(1:2)
P00245                 MOVE WS-ONMD-SVC-START-DT(6:2)                   
P00245                                  TO E-CA916-ALPHA-VARIABLE-6(3:2)
P00245                 MOVE WS-ONMD-SVC-START-DT(9:2)                   
P00245                                  TO E-CA916-ALPHA-VARIABLE-6(5:2)
P00245              ELSE                                                
P00245                 MOVE YP-ATTRIBUTE-VALUE-DT(3:2)                  
P00245                                  TO E-CA916-ALPHA-VARIABLE-6(1:2)
P00245                 MOVE YP-ATTRIBUTE-VALUE-DT(6:2)                  
P00245                                  TO E-CA916-ALPHA-VARIABLE-6(3:2)
P00245                 MOVE YP-ATTRIBUTE-VALUE-DT(9:2)                  
P00245                                  TO E-CA916-ALPHA-VARIABLE-6(5:2)
P00245              END-IF                                              
P00245           END-IF                                                 
P00245        END-IF                                                    
C34569                                                                  
P00245        IF DONT-SKIP-ACCOUNT                                      
C34569           SEARCH ALL WS-DDDC-TBL                                 
C34569               AT END                                             
C34569                  CONTINUE                                        
A05037             WHEN DDC-RATE-PLAN-NO(DDC-IND) =                     
A05037                                WS-SEARCH-RATE-PLAN-NO            
I02262                  MOVE '+($  X.XX X DDDC)'                        
A02003                             TO E-CA916-DDC-THERM-DESC            
A02003                  MOVE DDC-FACTOR(DDC-IND)                        
A02003                             TO E-CA916-DDC-FACTOR                
C34569           END-SEARCH                                             
C34569                                                                  
P805CS           SET NOT-LEGACY-RATE TO TRUE                            
P805CS           SET NOT-OLD-RATE    TO TRUE                            
P805CS           MOVE 'N'            TO E-CA916-AUTO-REN-DSC-ELIG-FL    
P805CS                                  E-CA916-PAPERLESS-DSC-ELIG-FL   
P805CS                                  E-CA916-LEGACY-FIX-RT-FL        
P805CS                                  E-CA916-OLD-CSC-RATE-FL         
P805CS           MOVE ZEROS          TO E-CA916-AUTO-RENEW-DSC-AMT      
P805CS                                  E-CA916-PAPERLESS-DSC-AMT       
P805CS           IF MKT-DEREG-RESIDENTIAL                               
P805CS             OR MKT-ACN-RESIDENTIAL                               
P805CS               OR MKT-BUSI-OWNER-RESIDENTIAL                      
P805CS              SEARCH ALL WS-LEGACY-RATES-TBL                      
P805CS                  AT END                                          
P805CS                     CONTINUE                                     
P805CS                WHEN LEGACY-RATE-PLAN-NO(LRATE-INDX) =            
P805CS                                   WS-SEARCH-RATE-PLAN-NO         
P805CS                     SET LEGACY-RATE TO TRUE                      
P805CS              END-SEARCH                                          
P805CS              IF LEGACY-RATE                                      
P805CS                 IF FI-OPT-CALC-TYPE-CD EQUAL 'FP'                
P805CS                    MOVE 'Y'    TO E-CA916-LEGACY-FIX-RT-FL       
P805CS                 ELSE                                             
P805CS                    MOVE 'Y'    TO E-CA916-PAPERLESS-DSC-ELIG-FL  
P805CS                    MOVE WS-PAPERLESS-DSCNT-AMT                   
P805CS                                TO E-CA916-PAPERLESS-DSC-AMT      
P805CS                 END-IF                                           
P805CS              ELSE                                                
P805CS                 SEARCH ALL WS-OLD-RATES-TBL                      
P805CS                     AT END                                       
P805CS                        CONTINUE                                  
P805CS                   WHEN OLD-RATE-PLAN-NO(ORATE-INDX) =            
P805CS                                   WS-SEARCH-RATE-PLAN-NO         
P805CS                        SET OLD-RATE TO TRUE                      
P805CS                 END-SEARCH                                       
P805CS                 IF OLD-RATE                                      
P805CS                    MOVE 'Y'    TO E-CA916-OLD-CSC-RATE-FL        
P805CS                    IF FI-OPT-CALC-TYPE-CD NOT EQUAL 'FP'         
P805CS                       MOVE 'Y' TO E-CA916-PAPERLESS-DSC-ELIG-FL  
P805CS                       MOVE WS-PAPERLESS-DSCNT-AMT                
P805CS                                TO E-CA916-PAPERLESS-DSC-AMT      
P805CS                    END-IF                                        
P805CS                 ELSE                                             
P805CS                    MOVE 'Y'    TO E-CA916-PAPERLESS-DSC-ELIG-FL  
P805CS                    MOVE WS-PAPERLESS-DSCNT-AMT                   
P805CS                                TO E-CA916-PAPERLESS-DSC-AMT      
P805CS                    IF FI-OPT-CALC-TYPE-CD EQUAL 'FP'             
P805CS                       AND DF-AUTO-REN-OPT-IN-FL NOT EQUAL 'N'    
P805CS                       MOVE 'Y' TO E-CA916-AUTO-REN-DSC-ELIG-FL   
P805CS                       MOVE WS-AUTORENEW-DSCNT-AMT                
P805CS                                TO E-CA916-AUTO-RENEW-DSC-AMT     
P805CS                    END-IF                                        
P805CS                 END-IF                                           
P805CS              END-IF                                              
P805CS           END-IF                                                 
P805CS                                                                  
P00581           MOVE ZEROS                   TO WS-RECONN-CHRG         
P00581                                           WS-NEW-CONN-CHRG       
P00581                                           WS-MTR-SET-CHRG        
P00581                                           WS-SEAS-CONN-CHRG      
P00581                                           WS-RET-CHK-CHRG        
P00581                                           WS-RESI-EXIT-FEE       
P00581                                           WS-COMM-EXIT-FEE       
P00581                                           WS-MAX-RESI-DEP        
P00677                                           WS-REG-MAX-DEP         
P00677                                           WS-G2SR-MAX-DEP        
P00677                                           WS-REG-SR-DISC         
P00677                                           WS-G2-GOOD-DISC        
P00677                                           WS-REG-FIX-ADJFACT     
P00677                                           WS-G2-FIX-WTAV-FACT    
P00677                                           WS-G1-SR-CSC           
P00677                                           WS-REG-STD-CSC         
P00677                                           WS-G2-GOOD-PYMT-CSC    
P00581                                                                  
P00581           PERFORM 2200-GET-OTHER-FEE-AMOUNTS THRU 2200-EXIT      
P00581                                                                  
P00581           MOVE WS-RECONN-CHRG          TO E-CA916-RECONN-CHRG    
P00581           MOVE WS-NEW-CONN-CHRG        TO E-CA916-NEW-CONN-CHRG  
P00581           MOVE WS-MTR-SET-CHRG         TO E-CA916-MTR-SET-CHRG   
P00581           MOVE WS-SEAS-CONN-CHRG       TO E-CA916-SEA-CONN-CHRG  
P00581           MOVE WS-RET-CHK-CHRG         TO E-CA916-RET-CHK-CHRG   
P00581           MOVE WS-MAX-RESI-DEP         TO E-CA916-MAX-RESI-DEP   
P00581           MOVE WS-RESI-EXIT-FEE        TO E-CA916-RESI-EXIT-FEE  
P00581           MOVE WS-COMM-EXIT-FEE        TO E-CA916-COMM-EXIT-FEE  
P00677           IF E-CA916-FXD-RT-TERM-FEE > 0  AND WS-DREG            
P00581              IF WS-RESIDENTIAL                                   
P00581                 MOVE E-CA916-FXD-RT-TERM-FEE                     
P00581                                        TO E-CA916-RESI-EXIT-FEE  
P00581              END-IF                                              
P00581              IF WS-COMMERCIAL                                    
P00581                 MOVE E-CA916-FXD-RT-TERM-FEE                     
P00581                                        TO E-CA916-COMM-EXIT-FEE  
P00581              END-IF                                              
P00581           END-IF                                                 
P00581           MOVE WS-TIER-ACCT-TYPE-CODE  TO E-CA916-TIER-ACCT-TYPE 
P00677           IF WS-REG-GROUP1 OR WS-REG-GROUP2                      
P00677              MOVE WS-REG-SR-DISC       TO E-CA916-REG-SR-DISC    
P00677              MOVE WS-G2-GOOD-DISC      TO E-CA916-G2-GOOD-DISC   
P00677              MOVE WS-REG-FIX-ADJFACT   TO E-CA916-REG-FIX-ADJFACT
P00677              MOVE WS-G2-FIX-WTAV-FACT  TO                        
P00677                                        E-CA916-G2-FIX-WTAV-FACT  
P00677              MOVE WS-G1-SR-CSC         TO E-CA916-G1-SR-CSC      
P00677              MOVE WS-REG-STD-CSC       TO E-CA916-REG-STD-CSC    
P00677              MOVE WS-G2-GOOD-PYMT-CSC  TO                        
P00677                                        E-CA916-G2-GOOD-PYMT-CSC  
P00677              MOVE WS-REG-MAX-DEP       TO E-CA916-REG-MAX-DEP    
P00677              MOVE WS-G2SR-MAX-DEP      TO E-CA916-G2SR-MAX-DEP   
P00677           END-IF                                                 
P00581*                                                                         
C34569           PERFORM 8100-WRITE-FCA916-RECORD THRU 8100-EXIT        
P00245        END-IF                                                    
C34569     END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C34569****************************************************************          
C34569**  2100-GET-EXPR-DATE.                                       **          
C34569**      GET THE FIXED RATE EXPIRATION DATE = COMMON-REV-MONTH **          
C34569**                                      +  WS-FF-DURATION-REM **          
C34569****************************************************************          
C34569*                                                                         
C34569 2100-GET-EXPR-DATE.                                              
C34569*                                                                         
C34569     MOVE ZEROS                          TO WS-HOLD-REV-MNTH      
C34569                                            WS-HOLD-REV-MNTH-RED  
C34569                                            WS-HOLD-DURATION-REM  
PRODFX                                            WS-DUMMY-DATE         
PRODFX                                            WS-DUMMY-DATE-TEMP    
PRODFX                                            WS-RESULT-DATE        
PRODFX                                            WS-RESULT-DT.         
C34569                                                                  
PRODFX     IF WS-FF-DURATION-REM > 0                                    
PRODFX        MOVE WS-FF-DURATION-REM          TO WS-HOLD-DURATION-REM  
PRODFX                                                                  
P00245        IF PRICE-SHEET-LTR-MKSW                                   
P00245           MOVE SPACES                   TO WS-HOLD-MKSW-START-YR 
P00245                                            WS-HOLD-MKSW-START-MM 
P00245           IF WS-EXCEPTION-FLOW = 'Y'                             
P00245              MOVE DETAIL-SVC-START-DATE(1:4)                     
P00245                                         TO WS-HOLD-MKSW-START-YR 
P00245              MOVE DETAIL-SVC-START-DATE(6:2)                     
P00245                                         TO WS-HOLD-MKSW-START-MM 
P00245           ELSE                                                   
P00245              MOVE YP-ATTRIBUTE-VALUE-DT(1:4)                     
P00245                                         TO WS-HOLD-MKSW-START-YR 
P00245              MOVE YP-ATTRIBUTE-VALUE-DT(6:2)                     
P00245                                         TO WS-HOLD-MKSW-START-MM 
P00245           END-IF                                                 
P00245           MOVE WS-HOLD-MKSW-START-NUM   TO WS-HOLD-REV-MNTH      
P00245           IF WS-HOLD-DURATION-REM > 0                            
P00245              COMPUTE WS-HOLD-DURATION-REM =                      
P00245                      WS-HOLD-DURATION-REM - 1                    
P00245           END-IF                                                 
P00245        ELSE                                                      
ACT241           IF (RATE-CHANGE-LTR OR OPTED-IN-LTR)                   
P00245              IF DF-STATUS-EFF-REV-MTH > 0                        
P00245                 MOVE DF-STATUS-EFF-REV-MTH TO WS-HOLD-REV-MNTH   
P00245                 COMPUTE WS-HOLD-DURATION-REM =                   
P00245                         WS-HOLD-DURATION-REM - 1                 
P00245              ELSE                                                
P00245                 SET SKIP-ACCOUNT            TO TRUE              
ACT241                 IF RATE-CHANGE-LTR                               
P00245                    DISPLAY 'RATE CHANGE LETTER ACCOUNT'          
P00245                    ADD +1               TO WS-RTCHG-SKIP-COUNT   
ACT241                 ELSE                                             
ACT241                    DISPLAY 'OPTED IN LETTER ACCOUNT'             
ACT241                    ADD +1               TO WS-OPTIN-SKIP-COUNT   
ACT241                 END-IF                                           
P00245                 DISPLAY 'RTPK AGR EFF_REV_MTH IS ZERO: '         
P00245                                             WS-ACCOUNT-NO-063    
P00245              END-IF                                              
P00245           ELSE                                                   
T34569              IF AT-REV-MTH-LST-NRML > 0                          
T34569                 MOVE AT-REV-MTH-LST-NRML  TO WS-HOLD-REV-MNTH    
T34569              ELSE                                                
T34569                 MOVE WS-COMMON-RUN-DATE   TO BN-DATE-EXTRACT     
T34569                 MOVE AT-BILL-CYCLE        TO BN-BILL-CYCLE       
T34569                 PERFORM 7900-GET-BILL-WINDOW THRU 7900-EXIT      
PRODFX                 IF WS-HOLD-DURATION-REM > 0                      
PRODFX                    COMPUTE WS-HOLD-DURATION-REM =                
PRODFX                            WS-HOLD-DURATION-REM - 1              
PRODFX                 END-IF                                           
T34569              END-IF                                              
P00245           END-IF                                                 
P00245        END-IF                                                    
T34569                                                                  
P00245        IF DONT-SKIP-ACCOUNT                                      
C34569           MOVE WS-HOLD-REV-MNTH         TO WS-HOLD-REV-MNTH-RED  
T34569                                            E-PRDSC-START-DATE    
PRODFX           MOVE WS-HOLD-REV-MNTH-YR      TO WS-DUMMY-DT-YYYY      
PRODFX           MOVE WS-HOLD-REV-MNTH-MM      TO WS-DUMMY-DT-MM        
PRODFX           MOVE '01'                     TO WS-DUMMY-DT-DD        
PRODFX           MOVE '-'                      TO WS-DUMMY-DT-F1        
PRODFX                                            WS-DUMMY-DT-F2        
PRODFX           MOVE WS-DUMMY-DATE            TO WS-DUMMY-DATE-TEMP    
PRODFX                                                                  
PRODFX           EXEC SQL                                               
PRODFX              SELECT
              DATEADD( MONTH, :WS-HOLD-DURATION-REM, 
              IIF(TRY_CONVERT(DATE, :WS-DUMMY-DATE-TEMP
              ) IS NULL OR (PATINDEX('%.%', :WS-DUMMY-DATE-TEMP
              ) <> 0) OR (LEN(:WS-DUMMY-DATE-TEMP
              ) <> 10), CIS.CHAR2DATE(:WS-DUMMY-DATE-TEMP
              ), CONVERT(DATE, :WS-DUMMY-DATE-TEMP) ) )
            INTO
              :WS-RESULT-DATE 
PRODFX           END-EXEC                                               

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*          EXEC SQL                                                       
MFA-TR*             SET :WS-RESULT-DATE = DATE(DATE(:WS-DUMMY-DATE-TEMP)        
MFA-TR*                                 + :WS-HOLD-DURATION-REM MONTHS)         
MFA-TR*          END-EXEC                                                       

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRODFX                                                                  
PRODFX           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE 
PRODFX                                                                  
PRODFX           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
PRODFX              CONTINUE                                            
PRODFX           ELSE                                                   
PRODFX              DISPLAY '******************************************'
PRODFX              DISPLAY '**         2100-GET-EXPR-DATE           **'
PRODFX              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
PRODFX              DISPLAY '**        PROCESSING IS TERMINATED      **'
PRODFX              DISPLAY '******************************************'
PRODFX              PERFORM 9900-ABEND         THRU 9900-EXIT           
PRODFX           END-IF                                                 
PRODFX                                                                  
PRODFX           MOVE WS-RESULT-DATE (1:4)     TO WS-RESULT-DT-YYYY     
PRODFX           MOVE WS-RESULT-DATE (6:2)     TO WS-RESULT-DT-MM       
PRODFX                                                                  
PRODFX           MOVE WS-RESULT-DT             TO E-PRDSC-EXPR-DATE     
P00245        END-IF                                                    
C34569     ELSE                                                         
C34569        SET SKIP-ACCOUNT                 TO TRUE                  
P00892        IF OPTED-IN-LTR                                           
P00892           DISPLAY 'OPTED IN LETTER ACCOUNT'                      
P00892           ADD +1                        TO WS-OPTIN-SKIP-COUNT   
P00892        ELSE                                                      
P00245           IF RATE-CHANGE-LTR                                     
P00245              DISPLAY 'RATE CHANGE LETTER ACCOUNT'                
P00245              ADD +1                        TO WS-RTCHG-SKIP-COUNT
P00245           ELSE                                                   
P00245              DISPLAY 'PRICE SHEET LETTER ACCOUNT'                
T34569              INITIALIZE EXCEP153-REC                             
T34569                      WS-EXCP-LINE                                
T34569              MOVE WS-DUR-ZERO-ERR-MSG      TO EL-MESSAGE         
T34569              PERFORM 4000-PROCESS-EXCEPTION THRU 4000-EXIT       
P00245              ADD +1                    TO WS-PRC-SHT-SKIP-COUNT  
P00245           END-IF                                                 
P00892        END-IF                                                    
C34569        DISPLAY 'DURATION REMAINING ZERO : ' WS-ACCOUNT-NO-063    
C34569     END-IF.                                                      
C34569                                                                  
C34569*                                                                         
C34569 2100-EXIT.                                                       
C34569     EXIT.                                                        
C34569*                                                                         
P00581*================================================================*        
P00581 2200-GET-OTHER-FEE-AMOUNTS.                                      
P00581*================================================================*        
P00677*** POPULATE RCC, TON, NSC, EXIT FEE CHARGES ALSO POPULATE DEPOSIT        
P00677*** RATE DISCOUNTS, CSC FOR NEWLY ADDED REGULATED T&C FIELDS              
P00581*  RECONNECT CHARGE (RCC)                                                 
P00581     PERFORM VARYING WS-JP-SUB FROM 1 BY 1                        
P00581                           UNTIL WS-JP-SUB > WS-JOB-PARM-COUNT    
P00581        EVALUATE TRUE ALSO TRUE                                   
P00581** RECONNECT CHARGE (RCC)                                                 
P00581          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'REG1-RCC'           
P00581              ALSO WS-REG-GROUP1                                  
P00581          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'REG2-RCC'           
P00581              ALSO WS-REG-GROUP2                                  
P00581          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'DEREG-RCC'          
P00581              ALSO WS-DREG                                        
P00581            IF TAB-PARM-EFF-DATE (WS-JP-SUB) <= WS-FEE-EFF-DATE   
P00581               MOVE TAB-NEW-DELINQ-VALUE (WS-JP-SUB)              
P00581                                        TO WS-RECONN-CHRG         
P00581            ELSE                                                  
P00581               MOVE TAB-OLD-DELINQ-VALUE (WS-JP-SUB)              
P00581                                        TO WS-RECONN-CHRG         
P00581            END-IF                                                
P00581** SERVICE TURN-ON CHARGE (TON)                                           
P00581          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'REG1-TON'           
P00581              ALSO WS-REG-GROUP1                                  
P00581          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'REG2-TON'           
P00581              ALSO WS-REG-GROUP2                                  
P00581          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'DEREG-TON'          
P00581              ALSO WS-DREG                                        
P00581            IF TAB-PARM-EFF-DATE (WS-JP-SUB) <= WS-FEE-EFF-DATE   
P00581               MOVE TAB-NEW-DELINQ-VALUE (WS-JP-SUB)              
P00581                                        TO WS-NEW-CONN-CHRG       
P00581            ELSE                                                  
P00581               MOVE TAB-OLD-DELINQ-VALUE (WS-JP-SUB)              
P00581                                        TO WS-NEW-CONN-CHRG       
P00581            END-IF                                                
P00581** RETURN CHECK CHARGE (NSC)                                              
P00581          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'REG1-NSC'           
P00581              ALSO WS-REG-GROUP1                                  
P00581          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'REG2-NSC'           
P00581              ALSO WS-REG-GROUP2                                  
P00581          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'DEREG-NSC'          
P00581              ALSO WS-DREG                                        
P00581            IF TAB-PARM-EFF-DATE (WS-JP-SUB) <= WS-FEE-EFF-DATE   
P00581               MOVE TAB-NEW-DELINQ-VALUE (WS-JP-SUB)              
P00581                                        TO WS-RET-CHK-CHRG        
P00581            ELSE                                                  
P00581               MOVE TAB-OLD-DELINQ-VALUE (WS-JP-SUB)              
P00581                                        TO WS-RET-CHK-CHRG        
P00581            END-IF                                                
P00581** NEW METER SET CHARGE                                                   
P00581          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'REG1-SET'           
P00581              ALSO WS-REG-GROUP1                                  
P00581          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'REG2-SET'           
P00581              ALSO WS-REG-GROUP2                                  
P00581          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'DEREG-SET'          
P00581              ALSO WS-DREG                                        
P00581            IF TAB-PARM-EFF-DATE (WS-JP-SUB) <= WS-FEE-EFF-DATE   
P00581               MOVE TAB-NEW-DELINQ-VALUE (WS-JP-SUB)              
P00581                                        TO WS-MTR-SET-CHRG        
P00581            ELSE                                                  
P00581               MOVE TAB-OLD-DELINQ-VALUE (WS-JP-SUB)              
P00581                                        TO WS-MTR-SET-CHRG        
P00581            END-IF                                                
P00581** SERVICE TURN-ON CHARGE (SEASONAL)                                      
P00581          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'REG1-SEAS'          
P00581              ALSO WS-REG-GROUP1                                  
P00581          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'REG2-SEAS'          
P00581              ALSO WS-REG-GROUP2                                  
P00581          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'DEREG-SEAS'         
P00581              ALSO WS-DREG                                        
P00581            IF TAB-PARM-EFF-DATE (WS-JP-SUB) <= WS-FEE-EFF-DATE   
P00581               MOVE TAB-NEW-DELINQ-VALUE (WS-JP-SUB)              
P00581                                        TO WS-SEAS-CONN-CHRG      
P00581            ELSE                                                  
P00581               MOVE TAB-OLD-DELINQ-VALUE (WS-JP-SUB)              
P00581                                        TO WS-SEAS-CONN-CHRG      
P00581            END-IF                                                
P00677** RATE ADJUSTMENT FACTOR                                                 
P00677          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'G1FADJFCT'          
P00677              ALSO WS-REG-GROUP1                                  
P00677          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'G2FADJFCT'          
P00677              ALSO WS-REG-GROUP2                                  
P00677            IF TAB-PARM-EFF-DATE (WS-JP-SUB) <= WS-FEE-EFF-DATE   
P00677               MOVE TAB-NEW-DELINQ-VALUE (WS-JP-SUB)              
P00677                                        TO WS-REG-FIX-ADJFACT     
P00677            ELSE                                                  
P00677               MOVE TAB-OLD-DELINQ-VALUE (WS-JP-SUB)              
P00677                                        TO WS-REG-FIX-ADJFACT     
P00677            END-IF                                                
P00677** WEIGHTED AVERAGE RATE FACTOR                                           
P00677          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'G2FWTAVFCT'         
P00677              ALSO WS-REG-GROUP2                                  
P00677            IF TAB-PARM-EFF-DATE (WS-JP-SUB) <= WS-FEE-EFF-DATE   
P00677               MOVE TAB-NEW-DELINQ-VALUE (WS-JP-SUB)              
P00677                                        TO WS-G2-FIX-WTAV-FACT    
P00677            ELSE                                                  
P00677               MOVE TAB-OLD-DELINQ-VALUE (WS-JP-SUB)              
P00677                                        TO WS-G2-FIX-WTAV-FACT    
P00677            END-IF                                                
P00677** REGULATED SENIOR DISCOUNT                                              
P00677          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'G1SR-DISC'          
P00677              ALSO WS-REG-GROUP1                                  
P00677          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'G2SR-DISC'          
P00677              ALSO WS-REG-GROUP2                                  
P00677            IF TAB-PARM-EFF-DATE (WS-JP-SUB) <= WS-FEE-EFF-DATE   
P00677               MOVE TAB-NEW-DELINQ-VALUE (WS-JP-SUB)              
P00677                                        TO WS-REG-SR-DISC         
P00677            ELSE                                                  
P00677               MOVE TAB-OLD-DELINQ-VALUE (WS-JP-SUB)              
P00677                                        TO WS-REG-SR-DISC         
P00677            END-IF                                                
P00677** REGULATED GOOD PAYMENT DISCOUNT                                        
P00677          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'G2GOODDISC'         
P00677              ALSO WS-REG-GROUP2                                  
P00677            IF TAB-PARM-EFF-DATE (WS-JP-SUB) <= WS-FEE-EFF-DATE   
P00677               MOVE TAB-NEW-DELINQ-VALUE (WS-JP-SUB)              
P00677                                        TO WS-G2-GOOD-DISC        
P00677            ELSE                                                  
P00677               MOVE TAB-OLD-DELINQ-VALUE (WS-JP-SUB)              
P00677                                        TO WS-G2-GOOD-DISC        
P00677            END-IF                                                
P00677** REGULATED STANDARD CSC                                                 
P00677          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'REG1STDCSC'         
P00677              ALSO WS-REG-GROUP1                                  
P00677          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'REG2STDCSC'         
P00677              ALSO WS-REG-GROUP2                                  
P00677            IF TAB-PARM-EFF-DATE (WS-JP-SUB) <= WS-FEE-EFF-DATE   
P00677               MOVE TAB-NEW-DELINQ-VALUE (WS-JP-SUB)              
P00677                                        TO WS-REG-STD-CSC         
P00677            ELSE                                                  
P00677               MOVE TAB-OLD-DELINQ-VALUE (WS-JP-SUB)              
P00677                                        TO WS-REG-STD-CSC         
P00677            END-IF                                                
P00677** REGULATED SENIOR CSC                                                   
P00677          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'G1SR-CSC'           
P00677              ALSO WS-REG-GROUP1                                  
P00677            IF TAB-PARM-EFF-DATE (WS-JP-SUB) <= WS-FEE-EFF-DATE   
P00677               MOVE TAB-NEW-DELINQ-VALUE (WS-JP-SUB)              
P00677                                        TO WS-G1-SR-CSC           
P00677            ELSE                                                  
P00677               MOVE TAB-OLD-DELINQ-VALUE (WS-JP-SUB)              
P00677                                        TO WS-G1-SR-CSC           
P00677            END-IF                                                
P00677** REGULATED GOOD PAYMENT CSC                                             
P00677          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'G2PYMTCSC'          
P00677              ALSO WS-REG-GROUP2                                  
P00677            IF TAB-PARM-EFF-DATE (WS-JP-SUB) <= WS-FEE-EFF-DATE   
P00677               MOVE TAB-NEW-DELINQ-VALUE (WS-JP-SUB)              
P00677                                        TO WS-G2-GOOD-PYMT-CSC    
P00677            ELSE                                                  
P00677               MOVE TAB-OLD-DELINQ-VALUE (WS-JP-SUB)              
P00677                                        TO WS-G2-GOOD-PYMT-CSC    
P00677            END-IF                                                
P00581** EXIT FEE CHARGE (COMMERCIAL)ONLY TO PRINT IN TERMS & CONDITIONS        
P00581** OF WELCOME LETTERS FOR ALL CUSTOMERS                                   
P00581          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'EXITFEECOM'         
P00581              ALSO (WS-RESIDENTIAL OR WS-COMMERCIAL               
P00581                       OR WS-OTHER-ACCT-TYPES)                    
P00581            IF TAB-PARM-EFF-DATE (WS-JP-SUB) <= WS-FEE-EFF-DATE   
P00581               MOVE TAB-NEW-DELINQ-VALUE (WS-JP-SUB)              
P00581                                        TO WS-COMM-EXIT-FEE       
P00581            ELSE                                                  
P00581               MOVE TAB-OLD-DELINQ-VALUE (WS-JP-SUB)              
P00581                                        TO WS-COMM-EXIT-FEE       
P00581            END-IF                                                
P00581** EXIT FEE CHARGE (RESIDENTIL)ONLY TO PRINT IN TERMS & CONDITIONS        
P00581** OF WELCOME LETTERS FOR DEREG                                           
P00581          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'EXITFEERES'         
P00581              ALSO (WS-RESIDENTIAL OR WS-COMMERCIAL               
P00581                       OR WS-OTHER-ACCT-TYPES)                    
P00581            IF TAB-PARM-EFF-DATE (WS-JP-SUB) <= WS-FEE-EFF-DATE   
P00581               MOVE TAB-NEW-DELINQ-VALUE (WS-JP-SUB)              
P00581                                        TO WS-RESI-EXIT-FEE       
P00581            ELSE                                                  
P00581               MOVE TAB-OLD-DELINQ-VALUE (WS-JP-SUB)              
P00581                                        TO WS-RESI-EXIT-FEE       
P00581            END-IF                                                
P00677** EXIT FEE CHARGE (RESIDENTIL)ONLY TO PRINT IN TERMS & CONDITIONS        
P00677** OF WELCOME LETTERS FOR REGULATED GRP-1 & GRP-2 CUSTOMERS               
P00677          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'G1REXITFEE'         
P00677              ALSO (WS-REG-GROUP1 AND WS-RESIDENTIAL)             
P00677          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'G2REXITFEE'         
P00677              ALSO (WS-REG-GROUP2 AND WS-RESIDENTIAL)             
P00677            IF TAB-PARM-EFF-DATE (WS-JP-SUB) <= WS-FEE-EFF-DATE   
P00677               MOVE TAB-NEW-DELINQ-VALUE (WS-JP-SUB)              
P00677                                        TO WS-RESI-EXIT-FEE       
P00677            ELSE                                                  
P00677               MOVE TAB-OLD-DELINQ-VALUE (WS-JP-SUB)              
P00677                                        TO WS-RESI-EXIT-FEE       
P00677            END-IF                                                
P00581** MAX RESIDENTAIL DEPOSIT TO BE PRINTED IN ALL CUSTOMERS                 
P00581** AND COMMERCIAL DEFAULT TO 20% MORE OF RESIDENTAIL DEPOSIT              
P00581          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'MAXRES-DEP'         
P00581              ALSO (WS-RESIDENTIAL OR WS-COMMERCIAL               
P00581                       OR WS-OTHER-ACCT-TYPES)                    
P00581            IF TAB-PARM-EFF-DATE (WS-JP-SUB) <= WS-FEE-EFF-DATE   
P00581               MOVE TAB-NEW-DELINQ-VALUE (WS-JP-SUB)              
P00581                                        TO WS-MAX-RESI-DEP        
P00581            ELSE                                                  
P00581               MOVE TAB-OLD-DELINQ-VALUE (WS-JP-SUB)              
P00581                                        TO WS-MAX-RESI-DEP        
P00581            END-IF                                                
P00677** REGULATED MAXIMUM DEPOSIT                                              
P00677          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'REG1MAXDEP'         
P00677              ALSO WS-REG-GROUP1                                  
P00677          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'REG2MAXDEP'         
P00677              ALSO WS-REG-GROUP2                                  
P00677            IF TAB-PARM-EFF-DATE (WS-JP-SUB) <= WS-FEE-EFF-DATE   
P00677               MOVE TAB-NEW-DELINQ-VALUE (WS-JP-SUB)              
P00677                                        TO WS-REG-MAX-DEP         
P00677            ELSE                                                  
P00677               MOVE TAB-OLD-DELINQ-VALUE (WS-JP-SUB)              
P00677                                        TO WS-REG-MAX-DEP         
P00677            END-IF                                                
P00677** REGULATED SENIOR MAXIMUM DEPOSIT                                       
P00677          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'G1SRMAXDEP'         
P00677              ALSO WS-REG-GROUP1                                  
P00677          WHEN TAB-PROGRAM-NAME(WS-JP-SUB) = 'G2SRMAXDEP'         
P00677              ALSO WS-REG-GROUP2                                  
P00677            IF TAB-PARM-EFF-DATE (WS-JP-SUB) <= WS-FEE-EFF-DATE   
P00677               MOVE TAB-NEW-DELINQ-VALUE (WS-JP-SUB)              
P00677                                        TO WS-G2SR-MAX-DEP        
P00677            ELSE                                                  
P00677               MOVE TAB-OLD-DELINQ-VALUE (WS-JP-SUB)              
P00677                                        TO WS-G2SR-MAX-DEP        
P00677            END-IF                                                
P00581        END-EVALUATE                                              
P00581     END-PERFORM.                                                 
P00581*                                                                         
P00581 2200-EXIT.                                                       
P00581     EXIT.                                                        
P00581*                                                                         
P00680****************************************************************          
P00680**  2300-PROCESS-DISCOUNT-CURSOR.                        **               
P00680****************************************************************          
P00680 2300-PROCESS-DISCOUNT-CURSOR.                                    
P00680*                                                                         
P00680     EVALUATE SF-RT-ATTR-INCTV-TYPE                               
P00680         WHEN 'PRICE DISCOUNT'                                    
PRJ680            IF WS-PRC-DISC-DET-IDX <= 5                           
PRJ680               MOVE SF-FACTOR-DESC                                
PRJ680                 TO E-CA916-PRC-DISC-DESC    (WS-PRC-DISC-DET-IDX)
PRJ680               COMPUTE                                            
PRJ680                    E-CA916-PRC-DISC-AMOUNT  (WS-PRC-DISC-DET-IDX)
PRJ680                    EQUAL FF-FACTOR * -1                          
PRJ680               MOVE FF-DURATION-REMAIN-NO                         
PRJ680                 TO E-CA916-PRC-DISC-DURATION                     
PRJ680                                             (WS-PRC-DISC-DET-IDX)
PRJ680                SET WS-PRC-DISC-DET-IDX UP BY 1                   
PRJ680            END-IF                                                
P00680         WHEN 'CSC DISCOUNT'                                      
PRJ680            IF WS-CSC-DISC-DET-IDX <= 5                           
PRJ680               MOVE SF-FACTOR-DESC                                
PRJ680                 TO E-CA916-CSC-DISC-DESC    (WS-CSC-DISC-DET-IDX)
PRJ680               COMPUTE                                            
PRJ680                    E-CA916-CSC-DISC-AMOUNT  (WS-CSC-DISC-DET-IDX)
PRJ680                    EQUAL FF-FACTOR * -1                          
PRJ680               MOVE FF-DURATION-REMAIN-NO                         
PRJ680                 TO E-CA916-CSC-DISC-DURATION                     
PRJ680                                             (WS-CSC-DISC-DET-IDX)
PRJ680                SET WS-CSC-DISC-DET-IDX UP BY 1                   
PRJ680            END-IF                                                
P00680         WHEN 'ADJUSTABLE RATE'                                   
P00680            MOVE FF-DURATION-REMAIN-NO                            
P00680              TO E-CA916-FLEX-ADJUSTMENT-COUNT                    
P00680     END-EVALUATE.                                                
P00680                                                                  
P00680     PERFORM 7820-FETCH-DISCOUNT-CURSOR     THRU 7820-EXIT.       
P00680*                                                                         
P00680 2300-EXIT.                                                       
P00680     EXIT.                                                        
P00680*                                                                         
      ****************************************************************          
      **  2500-POP-JOB-PARM.                                        **          
      **      POPULATE THE JOB PARM VALUES TO BE UPDATED AFTER THE  **          
      **      PROGRAM SUCCESSFUL EXECUTION                          **          
      ****************************************************************          
      *                                                                         
       2500-POP-JOB-PARM.                                               
      *                                                                         
           MOVE WS-PGRMNAME             TO G6-PROGRAM-NAME.             
           MOVE '01'                    TO G6-COMPANY-NO.               
           MOVE WS-DATE                 TO G6-CMND-CODE.                
           MOVE 'A'                     TO G6-STATUS.                   
           MOVE 10                      TO G6-SEQ-NO.                   
A04132     PERFORM 7800-GET-TIMESTAMP   THRU 7800-EXIT.                 
A04132     MOVE WS-TIMESTAMP(11:16)     TO WS-COMMON-RUN-DATE-TS(11:16).
A04132     MOVE WS-COMMON-RUN-DATE-TS   TO WS-L-COMMON-RUN-DATE.        
           MOVE WS-LAST-COMMON-PARM     TO G6-PARM-DATA.                
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
T34569****************************************************************          
T34569**                                                            **          
T34569**   3000-RECYCLE-ACCTS.                                      **          
T34569**      PROCESS THE EXCEPTION ACCOUNTS FROM LAST RUN.         **          
T34569****************************************************************          
T34569 3000-RECYCLE-ACCTS.                                              
T34569*PRIMARY READ                                                             
T34569     PERFORM 7700-READ-PXCEP153                                   
T34569        THRU 7700-EXIT                                            
P00245           5 TIMES.                                               
T34569*                                                                         
T34569     IF P153-SUCCESSFUL                                           
P00245        IF NO-DATA-TEXT = '** NO DATA IN THIS RUN **'             
P00245           COMPUTE WS-EXCP-RECS-PROCESSED =                       
P00245                   WS-EXCP-RECS-PROCESSED - 1                     
T34569        ELSE                                                      
T34569           MOVE 'Y'                   TO WS-EXCEPTION-FLOW        
T34569           PERFORM 3500-PROCESS-RECYCLE THRU 3500-EXIT            
T34569             UNTIL P153-END-FILE                                  
T34569        END-IF                                                    
T34569     END-IF.                                                      
T34569*                                                                         
T34569 3000-EXIT.                                                       
T34569     EXIT.                                                        
T34569*                                                                         
T34569****************************************************************          
T34569**                                                            **          
T34569**   3500-PROCESS-RECYCLE.                                    **          
T34569**      PROCESS THE EXCEPTION ACCOUNTS FROM LAST RUN.         **          
T34569****************************************************************          
T34569 3500-PROCESS-RECYCLE.                                            
T34569*                                                                         
T34569     MOVE DETAIL-ACCOUNT-NO           TO AT-ACCOUNT-NO            
T34569                                         VO-ACCOUNT-NO.           
P00245     IF DETAIL-ORIGINATION-CD = 'M'                               
P00245        SET PRICE-SHEET-LTR-MKSW      TO TRUE                     
P00245     ELSE                                                         
P00245        SET PRICE-SHEET-LTR-ONMD      TO TRUE                     
P00245     END-IF.                                                      
P00245                                                                  
T34569     IF DETAIL-CODE-ACCT-STAT = 'A' OR 'P'                        
P00245        IF PRICE-SHEET-LTR-ONMD                                   
T34569           PERFORM 7200-OPEN-GAS-UTIL    THRU 7200-EXIT           
T34569               SET WS-NOT-END-GAS-CUR    TO TRUE                  
T34569               SET FIRST-TIME            TO TRUE                  
T34569           PERFORM 7210-FETCH-GAS-UTIL   THRU 7210-EXIT           
T34569           PERFORM 1100-PROCESS-GAS-UTIL THRU 1100-EXIT           
T34569             UNTIL WS-END-GAS-CUR                                 
T34569           PERFORM 7220-CLOSE-GAS-UTIL   THRU 7220-EXIT           
P00245        ELSE                                                      
P00245           SET DONT-SKIP-ACCOUNT         TO TRUE                  
P00245           IF DETAIL-SVC-START-DATE = SPACES                      
P00245              MOVE VO-ACCOUNT-NO         TO YP-ACCOUNT-NO         
P00245              PERFORM 7975-GET-MKSW-SVC-START-DT                  
P00245                 THRU 7975-EXIT                                   
P00245              MOVE YP-ATTRIBUTE-VALUE-DT TO DETAIL-SVC-START-DATE 
P00245           END-IF                                                 
P00245           IF DONT-SKIP-ACCOUNT                                   
P00245              PERFORM 7230-OPEN-GAS-UTIL-2  THRU 7230-EXIT        
P00245                  SET WS-NOT-END-GAS-CUR    TO TRUE               
P00245                  SET FIRST-TIME            TO TRUE               
P00245              PERFORM 7240-FETCH-GAS-UTIL-2 THRU 7240-EXIT        
P00245              PERFORM 1100-PROCESS-GAS-UTIL THRU 1100-EXIT        
P00245                UNTIL WS-END-GAS-CUR                              
P00245              PERFORM 7250-CLOSE-GAS-UTIL-2 THRU 7250-EXIT        
P00245           END-IF                                                 
P00245        END-IF                                                    
T34569     END-IF.                                                      
T34569                                                                  
T34569*READ NEXT EXCEPTION RECORD                                               
T34569     PERFORM 7700-READ-PXCEP153       THRU 7700-EXIT.             
T34569*                                                                         
T34569 3500-EXIT.                                                       
T34569     EXIT.                                                        
T34569*                                                                         
C34569****************************************************************          
C34569**                                                            **          
C34569**   4000-PROCESS-EXCEPTION                                   **          
C34569**      WRITE EXCEPTION ACCOUNTS.                             **          
C34569**      POSSIBLE SCENARIOS                                    **          
C34569**      1. UTIL_ENVRNMT NOT PRESENT FOR ACCOUNT               **          
C34569**      2. MTRD_ENVRNMT NOT HAVING ANY/ACTIVE METER           **          
C34569**      3. ACCT_RTPK_AGR DOES NOT HAVE AN ENTRY               **          
C34569**                                                            **          
C34569****************************************************************          
C34569 4000-PROCESS-EXCEPTION.                                          
C34569*                                                                         
C34569     MOVE VO-ACCOUNT-NO           TO EL-ACCT-NO                   
T34569                                     UT-ACCOUNT-NO                
T34569                                     AT-ACCOUNT-NO.               
T34569     PERFORM 7925-GET-RATE-PLAN   THRU 7925-EXIT.                 
T34569     MOVE UT-RATE-PLAN-NO         TO EL-RATE-PLAN-NO.             
T34569     PERFORM 7950-GET-CODE-ACCT-STAT THRU 7950-EXIT.              
T34569     MOVE AT-CODE-ACCT-STAT       TO EL-CODE-ACCT-STAT.           
P00245     IF WS-EXCEPTION-FLOW = 'Y'                                   
P00245        MOVE DETAIL-ORIGINATION-CD    TO EL-ORIGINATION-CD        
P00245        MOVE DETAIL-SVC-START-DATE    TO EL-SVC-START-DATE        
P00245     ELSE                                                         
P00245        MOVE XM-ORIGINATION-CD        TO EL-ORIGINATION-CD        
P00245        IF PRICE-SHEET-LTR-ONMD                                   
P00245           MOVE WS-ONMD-SVC-START-DT  TO EL-SVC-START-DATE        
P00245        ELSE                                                      
P00245           MOVE YP-ATTRIBUTE-VALUE-DT TO EL-SVC-START-DATE        
P00245        END-IF                                                    
P00245     END-IF.                                                      
C34569     WRITE EXCEP153-REC           FROM WS-EXCP-LINE.              
P00245     ADD +1                       TO WS-EXCP-RECS-WRITTEN.        
C34569*                                                                         
C34569 4000-EXIT.                                                       
C34569     EXIT.                                                        
C34569*                                                                         
      ****6240-GET-FCA00-COMMON-DATE.                                           
       COPY CPD00040.                                                           
      *                                                                         
      ****6251-GET-FJC01-DATE.                                                  
       COPY CPD00037.                                                           
      *                                                                         
T34569****************************************************************          
T34569** 6540-INSERT-MNT-TRANS-HIST.                                **          
T34569****************************************************************          
T34569*                                                                         
T34569     EXEC SQL                                                             
T34569         INCLUDE CPD00067                                                 
T34569     END-EXEC.                                                            
T34569*                                                                         
      /*** ALL SQL SELECTS, OPENS, FETCHES, AND CLOSES GO IN THE                
      **** 7000- RANGE OF PARAGRAPHS                                            
      *                                                                         
      ****************************************************************          
P00245**  7000-OPEN-ONMD-CURSOR.                                    **          
P00245**      OPEN THE ONMD ACCOUNTS CURSOR PRICE_SHEET_A           **          
      ****************************************************************          
      *                                                                         
P00245 7000-OPEN-ONMD-CURSOR.                                           
      *                                                                         
           EXEC SQL                                                     
P00245         OPEN PRICE_SHEET_A                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
P00245         DISPLAY '      OPEN PRICE_SHEET_A '                      
P00245         DISPLAY '     7000-OPEN-ONMD-CURSOR'                     
               DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY ' DATE-RANGE-1   = ' WS-LAST-RUN-DATE            
               DISPLAY ' DATE-RANGE-2   = ' WS-COMMON-RUN-DATE          
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
P00245**  7010-FETCH-ONMD-CURSOR.                                   **          
P00245**      FETCH THE ONMD ACCOUNTS FOR PROCESSING                **          
      ****************************************************************          
      *                                                                         
P00245 7010-FETCH-ONMD-CURSOR.                                          
      *                                                                         
           EXEC SQL                                                     
P00245         FETCH PRICE_SHEET_A                                      
                INTO :VO-ACCOUNT-NO                                     
P00245              ,:WS-ONMD-SVC-START-DT                              
P00245              ,:XM-ORIGINATION-CD                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00245        ADD +1                   TO WS-ONMD-ACCTS-PROCESSED       
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
P00245           SET WS-END-ONMD-CURSOR TO TRUE                         
              ELSE                                                      
                 DISPLAY '*******************************************'  
                 DISPLAY '       ABENDING PROGRAM '                     
P00245           DISPLAY '     FETCH PRICE_SHEET_A '                    
P00245           DISPLAY '    7010-FETCH-ONMD-CURSOR '                  
                 DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE     
                 DISPLAY ' ACCOUNT NO     = ' VO-ACCOUNT-NO             
                 DISPLAY '*******************************************'  
                 PERFORM 9900-ABEND      THRU 9900-EXIT                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
P00245**  7020-CLOSE-ONMD-CURSOR.                                   **          
P00245**      CLOSE THE ONMD ACCOUNTS CURSOR PRICE_SHEET_A.         **          
      ****************************************************************          
      *                                                                         
P00245 7020-CLOSE-ONMD-CURSOR.                                          
      *                                                                         
           EXEC SQL                                                     
P00245         CLOSE PRICE_SHEET_A                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '*******************************************'     
              DISPLAY '       ABENDING PROGRAM '                        
P00245        DISPLAY '     CLOSE PRICE_SHEET_A '                       
P00245        DISPLAY '    7020-CLOSE-ONMD-CURSOR '                     
              DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND       THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00245****************************************************************          
P00245**  7030-OPEN-MKSW-CURSOR.                                    **          
P00245**      OPEN THE MKSW ACCOUNTS CURSOR PRICE_SHEET_B           **          
P00245****************************************************************          
P00245*                                                                         
P00245 7030-OPEN-MKSW-CURSOR.                                           
P00245*                                                                         
P00245     EXEC SQL                                                     
P00245         OPEN PRICE_SHEET_B                                       
P00245     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00245                                                                  
P00245     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00245                                                                  
P00245     IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
P00245         DISPLAY '*******************************************'    
P00245         DISPLAY '       ABENDING PROGRAM '                       
P00245         DISPLAY '      OPEN PRICE_SHEET_B '                      
P00245         DISPLAY '     7030-OPEN-MKSW-CURSOR'                     
P00245         DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE       
P00245         DISPLAY ' DATE-RANGE-1   = ' WS-LAST-RUN-DATE            
P00245         DISPLAY ' DATE-RANGE-2   = ' WS-COMMON-RUN-DATE          
P00245         DISPLAY '*******************************************'    
P00245         PERFORM 9900-ABEND      THRU 9900-EXIT                   
P00245     END-IF.                                                      
P00245*                                                                         
P00245 7030-EXIT.                                                       
P00245     EXIT.                                                        
P00245*                                                                         
P00245****************************************************************          
P00245**  7040-FETCH-MKSW-CURSOR.                                   **          
P00245**      FETCH THE MKSW ACCOUNTS FOR PROCESSING                **          
P00245****************************************************************          
P00245*                                                                         
P00245 7040-FETCH-MKSW-CURSOR.                                          
P00245*                                                                         
P00245     EXEC SQL                                                     
P00245         FETCH PRICE_SHEET_B                                      
P00245          INTO :VO-ACCOUNT-NO                                     
P00245              ,:XM-ORIGINATION-CD                                 
P00245     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00245                                                                  
P00245     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00245                                                                  
P00245     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00245        ADD +1                   TO WS-MKSW-ACCTS-PROCESSED       
P00245     ELSE                                                         
P00245        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
P00245           SET WS-END-MKSW-CURSOR TO TRUE                         
P00245        ELSE                                                      
P00245           DISPLAY '*******************************************'  
P00245           DISPLAY '       ABENDING PROGRAM '                     
P00245           DISPLAY '     FETCH PRICE_SHEET_B '                    
P00245           DISPLAY '    7040-FETCH-MKSW-CURSOR '                  
P00245           DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE     
P00245           DISPLAY ' ACCOUNT NO     = ' VO-ACCOUNT-NO             
P00245           DISPLAY '*******************************************'  
P00245           PERFORM 9900-ABEND      THRU 9900-EXIT                 
P00245        END-IF                                                    
P00245     END-IF.                                                      
P00245*                                                                         
P00245 7040-EXIT.                                                       
P00245     EXIT.                                                        
P00245*                                                                         
P00245****************************************************************          
P00245**  7050-CLOSE-MKSW-CURSOR.                                   **          
P00245**      CLOSE THE MKSW ACCOUNTS CURSOR PRICE_SHEET_B.         **          
P00245****************************************************************          
P00245*                                                                         
P00245 7050-CLOSE-MKSW-CURSOR.                                          
P00245*                                                                         
P00245     EXEC SQL                                                     
P00245         CLOSE PRICE_SHEET_B                                      
P00245     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00245                                                                  
P00245     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00245                                                                  
P00245     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
P00245        DISPLAY '*******************************************'     
P00245        DISPLAY '       ABENDING PROGRAM '                        
P00245        DISPLAY '     CLOSE PRICE_SHEET_B '                       
P00245        DISPLAY '    7050-CLOSE-MKSW-CURSOR '                     
P00245        DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE        
P00245        DISPLAY '*******************************************'     
P00245        PERFORM 9900-ABEND       THRU 9900-EXIT                   
P00245     END-IF.                                                      
P00245*                                                                         
P00245 7050-EXIT.                                                       
P00245     EXIT.                                                        
P00245*                                                                         
P00245****************************************************************          
P00245**  7060-OPEN-RTCHG-CURSOR.                                   **          
P00245**      OPEN THE RATE_CHANGE CURSOR                           **          
P00245****************************************************************          
P00245*                                                                         
P00245 7060-OPEN-RTCHG-CURSOR.                                          
P00245*                                                                         
A04132                                                                  
P00245     EXEC SQL                                                     
P00245         OPEN RATE_CHANGE                                         
P00245     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00245                                                                  
P00245     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00245                                                                  
P00245     IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
P00245         DISPLAY '*******************************************'    
P00245         DISPLAY '       ABENDING PROGRAM '                       
P00245         DISPLAY '       OPEN RATE_CHANGE '                       
P00245         DISPLAY '    7060-OPEN-RTCHG-CURSOR '                    
P00245         DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE       
P00245         DISPLAY ' DATE-RANGE-1   = ' WS-LAST-RUN-DATE            
P00245         DISPLAY ' DATE-RANGE-2   = ' WS-COMMON-RUN-DATE          
P00245         DISPLAY '*******************************************'    
P00245         PERFORM 9900-ABEND      THRU 9900-EXIT                   
P00245     END-IF.                                                      
P00245*                                                                         
P00245 7060-EXIT.                                                       
P00245     EXIT.                                                        
P00245*                                                                         
P00245****************************************************************          
P00245**  7070-FETCH-RTCHG-CURSOR.                                  **          
P00245**      FETCH THE RATE CHANGE ACCOUNTS FOR PROCESSING.        **          
P00245****************************************************************          
P00245*                                                                         
P00245 7070-FETCH-RTCHG-CURSOR.                                         
P00245*                                                                         
P00245     EXEC SQL                                                     
P00245         FETCH RATE_CHANGE                                        
P00245          INTO :AT-ACCOUNT-NO                                     
P00245              ,:AT-CUSTOMER-NO                                    
P00245              ,:AT-ADDRESS-ID                                     
P00245              ,:AT-ADDRESS-FORMAT                                 
P00453              ,:AT-CODES-DATA-PRESENT                             
P00245              ,:AT-BILL-CYCLE                                     
P00581              ,:AT-ACCOUNT-TYPE-CODE                              
P00245              ,:AT-REV-MTH-LST-NRML                               
P00245              ,:UT-IC-NO                                          
P00245              ,:UT-CODE-UTIL-TYPE                                 
P00680              ,:UT-ACCOUNT-NO                                     
P00245              ,:RD-RATE-PLAN-NO                                   
P00245              ,:RD-REG-GROUP-CD                                   
P00245              ,:DF-RT-PKG-OPT-SEQ-NO                              
P00245              ,:DF-AGREEMNT-SOURCE-CD                             
P00245              ,:DF-STATUS-EFF-REV-MTH                             
P00245              ,:DF-OPT-AGRMT-EFF-DT                               
P00680              ,:DF-STAT-ADJUSTABLE-CD                             
P00805              ,:DF-STATUS-CD                                      
P00245              ,:FI-OPTION-CD                                      
P00245              ,:FI-OPT-CALC-TYPE-CD                               
P805CS              ,:FI-CURR-EXT-DESC-LONG                             
P00892              ,:DF-AUTO-REN-OPT-IN-FL                             
P00245     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00245                                                                  
P00245     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00245                                                                  
P00245     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00245        ADD +1                     TO WS-RTCHG-ACCTS-PROCESSED    
P00245     ELSE                                                         
P00245        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
P00245           SET WS-END-RTCHG-CURSOR TO TRUE                        
P00245        ELSE                                                      
P00245           DISPLAY '*******************************************'  
P00245           DISPLAY '       ABENDING PROGRAM '                     
P00245           DISPLAY '       FETCH RATE_CHANGE '                    
P00245           DISPLAY '    7070-FETCH-RTCHG-CURSOR '                 
P00245           DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE     
P00245           DISPLAY ' ACCOUNT NO     = ' AT-ACCOUNT-NO             
P00245           DISPLAY '*******************************************'  
P00245           PERFORM 9900-ABEND      THRU 9900-EXIT                 
P00245        END-IF                                                    
P00245     END-IF.                                                      
P00245*                                                                         
P00245 7070-EXIT.                                                       
P00245     EXIT.                                                        
P00245*                                                                         
P00245****************************************************************          
P00245**  7080-CLOSE-RTCHG-CURSOR.                                  **          
P00245**      CLOSE THE RATE_CHANGE CURSOR.                         **          
P00245****************************************************************          
P00245*                                                                         
P00245 7080-CLOSE-RTCHG-CURSOR.                                         
P00245*                                                                         
P00245     EXEC SQL                                                     
P00245         CLOSE RATE_CHANGE                                        
P00245     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00245                                                                  
P00245     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00245                                                                  
P00245     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
P00245        DISPLAY '*******************************************'     
P00245        DISPLAY '       ABENDING PROGRAM '                        
P00245        DISPLAY '      CLOSE RATE_CHANGE '                        
P00245        DISPLAY '   7080-CLOSE-RTCHG-CURSOR '                     
P00245        DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE        
P00245        DISPLAY '*******************************************'     
P00245        PERFORM 9900-ABEND       THRU 9900-EXIT                   
P00245     END-IF.                                                      
P00245*                                                                         
P00245 7080-EXIT.                                                       
P00245     EXIT.                                                        
P00245*                                                                         
P00892****************************************************************          
P00892**  7090-OPEN-OPTIN-CURSOR.                                   **          
P00892**      OPEN THE OPTED_IN CURSOR                              **          
P00892****************************************************************          
P00892                                                                  
P00892 7090-OPEN-OPTIN-CURSOR.                                          
P00892                                                                  
P00892     EXEC SQL                                                     
P00892         OPEN OPTED_IN                                            
P00892     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00892                                                                  
P00892     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00892                                                                  
P00892     IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
P00892         DISPLAY '*******************************************'    
P00892         DISPLAY '       ABENDING PROGRAM '                       
P00892         DISPLAY '       OPEN RATE_CHANGE '                       
P00892         DISPLAY '    7090-OPEN-OPTIN-CURSOR '                    
P00892         DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE       
P00892         DISPLAY ' DATE-RANGE-1   = ' WS-LAST-RUN-DATE            
P00892         DISPLAY ' DATE-RANGE-2   = ' WS-COMMON-RUN-DATE          
P00892         DISPLAY '*******************************************'    
P00892         PERFORM 9900-ABEND      THRU 9900-EXIT                   
P00892     END-IF.                                                      
P00892                                                                  
P00892 7090-EXIT.                                                       
P00892     EXIT.                                                        
                                                                        
P00892****************************************************************          
P00892**  7095-FETCH-OPTIN-CURSOR.                                  **          
P00892**      FETCH THE OPTED IN ACCOUNTS FOR PROCESSING.           **          
P00892****************************************************************          
P00892                                                                  
P00892 7095-FETCH-OPTIN-CURSOR.                                         
P00892                                                                  
P00892     EXEC SQL                                                     
P00892         FETCH OPTED_IN                                           
P00892          INTO :AT-ACCOUNT-NO                                     
P00892              ,:AT-CUSTOMER-NO                                    
P00892              ,:AT-ADDRESS-ID                                     
P00892              ,:AT-ADDRESS-FORMAT                                 
P00892              ,:AT-CODES-DATA-PRESENT                             
P00892              ,:AT-BILL-CYCLE                                     
P00892              ,:AT-ACCOUNT-TYPE-CODE                              
P00892              ,:AT-REV-MTH-LST-NRML                               
P00892              ,:UT-IC-NO                                          
P00892              ,:UT-CODE-UTIL-TYPE                                 
P00892              ,:UT-ACCOUNT-NO                                     
P00892              ,:RD-RATE-PLAN-NO                                   
P00892              ,:RD-REG-GROUP-CD                                   
P00892              ,:DF-RT-PKG-OPT-SEQ-NO                              
P00892              ,:DF-AGREEMNT-SOURCE-CD                             
P00892              ,:DF-STATUS-EFF-REV-MTH                             
P00892              ,:DF-OPT-AGRMT-EFF-DT                               
P00892              ,:DF-STAT-ADJUSTABLE-CD                             
P00892              ,:DF-STATUS-CD                                      
P00892              ,:FI-OPTION-CD                                      
P00892              ,:FI-OPT-CALC-TYPE-CD                               
P805CS              ,:FI-CURR-EXT-DESC-LONG                             
P00892     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00892                                                                  
P00892     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00892                                                                  
P00892     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00892        ADD +1                     TO WS-OPTIN-ACCTS-PROCESSED    
P00892     ELSE                                                         
P00892        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
P00892           SET WS-END-OPTIN-CURSOR TO TRUE                        
P00892        ELSE                                                      
P00892           DISPLAY '*******************************************'  
P00892           DISPLAY '       ABENDING PROGRAM '                     
P00892           DISPLAY '       FETCH OPTED_IN    '                    
P00892           DISPLAY '    7095-FETCH-OPTIN-CURSOR '                 
P00892           DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE     
P00892           DISPLAY ' ACCOUNT NO     = ' AT-ACCOUNT-NO             
P00892           DISPLAY '*******************************************'  
P00892           PERFORM 9900-ABEND      THRU 9900-EXIT                 
P00892        END-IF                                                    
P00892     END-IF.                                                      
P00892                                                                  
P00892 7095-EXIT.                                                       
P00892     EXIT.                                                        
                                                                        
P00892****************************************************************          
P00892**  7100-CLOSE-OPTIN-CURSOR.                                  **          
P00892**      CLOSE THE OPTED_IN    CURSOR.                         **          
P00892****************************************************************          
P00892                                                                  
P00892 7100-CLOSE-OPTIN-CURSOR.                                         
P00892                                                                  
P00892     EXEC SQL                                                     
P00892         CLOSE OPTED_IN                                           
P00892     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00892                                                                  
P00892     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00892                                                                  
P00892     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
P00892        DISPLAY '*******************************************'     
P00892        DISPLAY '       ABENDING PROGRAM '                        
P00892        DISPLAY '      CLOSE OPTED_IN    '                        
P00892        DISPLAY '   7100-CLOSE-OPTIN-CURSOR '                     
P00892        DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE        
P00892        DISPLAY '*******************************************'     
P00892        PERFORM 9900-ABEND       THRU 9900-EXIT                   
P00892     END-IF.                                                      
P00892                                                                  
P00892 7100-EXIT.                                                       
P00892     EXIT.                                                        
P00892                                                                  
P00892****************************************************************          
P00892**  7105-GET-OPTIN-60DAY-DATE.                                **          
P00892****************************************************************          
P00892                                                                  
P00892 7105-GET-OPTIN-60DAY-DATE.                                       
P00892                                                                  
P00892     EXEC SQL                                                     
P00892        SELECT
              DATEADD( DAY, 60, IIF(TRY_CONVERT(DATE, :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) ) )
            INTO
              :WS-OPTIN-60DAY-DATE 
P00892     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-OPTIN-60DAY-DATE =                                        
MFA-TR*                           DATE(DATE(:WS-COMMON-DATE) + 60 DAYS)         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00892                                                                  
P00892     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00892                                                                  
P00892     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00892        CONTINUE                                                  
P00892     ELSE                                                         
P00892        DISPLAY '******************************************'      
P00892        DISPLAY '**   7105-GET-OPTIN-60DAY-DATE          **'      
P00892        DISPLAY '** RETURN CODE    = ' WS-ACTIVE-RETURN-CODE      
P00892        DISPLAY '** WS-COMMON-DATE = ' WS-COMMON-DATE             
P00892        DISPLAY '******************************************'      
P00892        PERFORM 9900-ABEND         THRU 9900-EXIT                 
P00892     END-IF.                                                      
P00892                                                                  
P00892 7105-EXIT.                                                       
P00892     EXIT.                                                        
P00892                                                                  
      ****************************************************************          
      **  7200-OPEN-GAS-UTIL                                        **          
      **      OPEN THE GAS_UTIL_CUR                                 **          
      ****************************************************************          
      *                                                                         
       7200-OPEN-GAS-UTIL.                                              
      *                                                                         
           EXEC SQL                                                     
               OPEN GAS_UTIL_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '*******************************************'     
              DISPLAY '       ABENDING PROGRAM '                        
              DISPLAY '       OPEN GAS_UTIL_CUR '                       
              DISPLAY '      7200-OPEN-GAS-UTIL '                       
              DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY ' ACCOUNT NO     = ' AT-ACCOUNT-NO                
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7210-FETCH-GAS-UTIL                                       **          
      **      FETCH THE GAS_UTIL_CUR                                **          
      ****************************************************************          
      *                                                                         
       7210-FETCH-GAS-UTIL.                                             
      *                                                                         
           EXEC SQL                                                     
               FETCH GAS_UTIL_CUR                                       
C34569          INTO :AT-CUSTOMER-NO                                    
T34569              ,:AT-BILL-CYCLE                                     
P00581              ,:AT-ACCOUNT-TYPE-CODE                              
T34569              ,:AT-REV-MTH-LST-NRML                               
C34569              ,:AT-ADDRESS-ID                                     
C34569              ,:AT-ADDRESS-FORMAT                                 
P00453              ,:AT-CODES-DATA-PRESENT                             
C34569              ,:UT-IC-NO                                          
P00680              ,:UT-ACCOUNT-NO                                     
P00680              ,:UT-CODE-UTIL-TYPE                                 
C34569              ,:RD-RATE-PLAN-NO                                   
C34569              ,:RD-REG-GROUP-CD                                   
P00141              ,:DF-OPT-AGRMT-EFF-DT                               
P00680              ,:DF-STAT-ADJUSTABLE-CD                             
P00245              ,:FI-OPT-CALC-TYPE-CD                               
C34569              ,:FI-OPTION-CD                                      
P805CS              ,:FI-CURR-EXT-DESC-LONG                             
ACT091              ,:DF-RT-PKG-OPT-SEQ-NO                              
ACT208              ,:DF-AUTO-REN-OPT-IN-FL                             
ACT208              ,:DF-AGREEMNT-SOURCE-CD                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              SET NOT-FIRST-TIME       TO TRUE                          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 IF FIRST-TIME                                          
P00245              ADD +1             TO WS-PRC-SHT-SKIP-COUNT         
                    DISPLAY 'GAS_UTIL_CUR NOT FOUND : ' AT-ACCOUNT-NO   
T34569              INITIALIZE EXCEP153-REC                             
T34569                         WS-EXCP-LINE                             
T34569              MOVE WS-BASE-CURSOR-ERR-MSG1   TO EL-MESSAGE        
C34569              PERFORM 4000-PROCESS-EXCEPTION THRU 4000-EXIT       
                 END-IF                                                 
                 SET WS-END-GAS-CUR    TO TRUE                          
              ELSE                                                      
                 DISPLAY '*******************************************'  
                 DISPLAY '       ABENDING PROGRAM '                     
                 DISPLAY '       FETCH GAS_UTIL_CUR '                   
                 DISPLAY '       7210-FETCH-GAS-UTIL '                  
                 DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE     
                 DISPLAY ' ACCOUNT NO     = ' AT-ACCOUNT-NO             
                 DISPLAY '*******************************************'  
                 PERFORM 9900-ABEND      THRU 9900-EXIT                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7220-CLOSE-GAS-UTIL                                       **          
      **      CLOSE THE GAS_UTIL_CUR                                **          
      ****************************************************************          
      *                                                                         
       7220-CLOSE-GAS-UTIL.                                             
      *                                                                         
           EXEC SQL                                                     
               CLOSE GAS_UTIL_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '*******************************************'     
              DISPLAY '       ABENDING PROGRAM '                        
              DISPLAY '       CLOSE GAS_UTIL_CUR '                      
              DISPLAY '       7220-CLOSE-GAS-UTIL'                      
              DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00245****************************************************************          
P00245**  7230-OPEN-GAS-UTIL-2                                      **          
P00245**      OPEN THE GAS_UTIL_CUR_2                               **          
P00245****************************************************************          
P00245*                                                                         
P00245 7230-OPEN-GAS-UTIL-2.                                            
P00245*                                                                         
P00245     EXEC SQL                                                     
P00245         OPEN GAS_UTIL_CUR_2                                      
P00245     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00245                                                                  
P00245     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00245                                                                  
P00245     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
P00245        DISPLAY '*******************************************'     
P00245        DISPLAY '       ABENDING PROGRAM '                        
P00245        DISPLAY '      OPEN GAS_UTIL_CUR_2 '                      
P00245        DISPLAY '      7230-OPEN-GAS-UTIL-2 '                     
P00245        DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE        
P00245        DISPLAY ' ACCOUNT NO     = ' AT-ACCOUNT-NO                
P00245        DISPLAY '*******************************************'     
P00245        PERFORM 9900-ABEND      THRU 9900-EXIT                    
P00245     END-IF.                                                      
P00245*                                                                         
P00245 7230-EXIT.                                                       
P00245     EXIT.                                                        
P00245*                                                                         
P00245****************************************************************          
P00245**  7240-FETCH-GAS-UTIL-2                                     **          
P00245**      FETCH THE GAS_UTIL_CUR_2                              **          
P00245****************************************************************          
P00245*                                                                         
P00245 7240-FETCH-GAS-UTIL-2.                                           
P00245*                                                                         
P00245     EXEC SQL                                                     
P00245         FETCH GAS_UTIL_CUR_2                                     
P00245          INTO :AT-CUSTOMER-NO                                    
P00245              ,:AT-BILL-CYCLE                                     
P00581              ,:AT-ACCOUNT-TYPE-CODE                              
P00245              ,:AT-REV-MTH-LST-NRML                               
P00245              ,:AT-ADDRESS-ID                                     
P00245              ,:AT-ADDRESS-FORMAT                                 
P00453              ,:AT-CODES-DATA-PRESENT                             
P00245              ,:UT-IC-NO                                          
P00680              ,:UT-ACCOUNT-NO                                     
P00680              ,:UT-CODE-UTIL-TYPE                                 
P00245              ,:RD-RATE-PLAN-NO                                   
P00245              ,:RD-REG-GROUP-CD                                   
P00245              ,:DF-OPT-AGRMT-EFF-DT                               
P00680              ,:DF-STAT-ADJUSTABLE-CD                             
P00245              ,:FI-OPT-CALC-TYPE-CD                               
P00245              ,:FI-OPTION-CD                                      
P805CS              ,:FI-CURR-EXT-DESC-LONG                             
ACT091              ,:DF-RT-PKG-OPT-SEQ-NO                              
ACT208              ,:DF-AUTO-REN-OPT-IN-FL                             
ACT208              ,:DF-AGREEMNT-SOURCE-CD                             
P00245     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00245                                                                  
P00245     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00245                                                                  
P00245     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00245        SET NOT-FIRST-TIME       TO TRUE                          
P00245     ELSE                                                         
P00245        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
P00245           IF FIRST-TIME                                          
P00245              ADD +1             TO WS-PRC-SHT-SKIP-COUNT         
P00245              DISPLAY 'GAS_UTIL_CUR_2 NOT FOUND : ' AT-ACCOUNT-NO 
P00245              INITIALIZE EXCEP153-REC                             
P00245                         WS-EXCP-LINE                             
P00245              MOVE WS-BASE-CURSOR-ERR-MSG2   TO EL-MESSAGE        
P00245              PERFORM 4000-PROCESS-EXCEPTION THRU 4000-EXIT       
P00245           END-IF                                                 
P00245           SET WS-END-GAS-CUR    TO TRUE                          
P00245        ELSE                                                      
P00245           DISPLAY '*******************************************'  
P00245           DISPLAY '       ABENDING PROGRAM '                     
P00245           DISPLAY '      FETCH GAS_UTIL_CUR_2 '                  
P00245           DISPLAY '      7240-FETCH-GAS-UTIL-2 '                 
P00245           DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE     
P00245           DISPLAY ' ACCOUNT NO     = ' AT-ACCOUNT-NO             
P00245           DISPLAY '*******************************************'  
P00245           PERFORM 9900-ABEND      THRU 9900-EXIT                 
P00245        END-IF                                                    
P00245     END-IF.                                                      
P00245*                                                                         
P00245 7240-EXIT.                                                       
P00245     EXIT.                                                        
P00245*                                                                         
P00245****************************************************************          
P00245**  7250-CLOSE-GAS-UTIL-2                                     **          
P00245**      CLOSE THE GAS_UTIL_CUR_2                              **          
P00245****************************************************************          
P00245*                                                                         
P00245 7250-CLOSE-GAS-UTIL-2.                                           
P00245*                                                                         
P00245     EXEC SQL                                                     
P00245         CLOSE GAS_UTIL_CUR_2                                     
P00245     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00245                                                                  
P00245     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
P00245                                                                  
P00245     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
P00245        DISPLAY '*******************************************'     
P00245        DISPLAY '       ABENDING PROGRAM '                        
P00245        DISPLAY '      CLOSE GAS_UTIL_CUR_2 '                     
P00245        DISPLAY '      7250-CLOSE-GAS-UTIL-2 '                    
P00245        DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE        
P00245        DISPLAY '*******************************************'     
P00245        PERFORM 9900-ABEND      THRU 9900-EXIT                    
P00245     END-IF.                                                      
P00245*                                                                         
P00245 7250-EXIT.                                                       
P00245     EXIT.                                                        
P00245*                                                                         
C34569****************************************************************          
C34569**  7300-GET-EXIT-FEE.                                        **          
C34569**      GET THE FIXED RATE EARLY TERMINATION FEE              **          
C34569****************************************************************          
C34569*                                                                         
C34569 7300-GET-EXIT-FEE.                                               
C34569*                                                                         
C34569     EXEC SQL                                                     
C34569        SELECT TOP(1) ATTR_INCTV_VALUE                                   
C34569          INTO :HQ-ATTR-INCTV-VALUE                               
C34569          FROM CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)                
C34569         WHERE HQ.OPTION_CD           = :HQ-OPTION-CD             
C34569           AND HQ.COMPANY_NO          = :HQ-COMPANY-NO            
C34569           AND HQ.RT_ATTR_INCTV_TYPE  = :HQ-RT-ATTR-INCTV-TYPE    
P00141           AND HQ.ATTR_INCTV_STRT_DT <= IIF(TRY_CONVERT(DATE, 
                                                   :DF-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:DF-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT) )      
P00141           AND HQ.ATTR_INCTV_END_DT  >= IIF(TRY_CONVERT(DATE, 
                                                   :DF-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:DF-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT) )      
P00473           AND HQ.PROC_STATUS_CD      = 'AC'                      
P00473           AND HQ.OPT_ATTR_VSTART_TS = (                          
P00473               SELECT MAX(H1.OPT_ATTR_VSTART_TS)                  
P00473                 FROM CRM_OPT_ATTR_INCTV H1 WITH(READUNCOMMITTED)         
P00473                WHERE H1.OPTION_CD    = HQ.OPTION_CD              
P00473                  AND H1.RT_ATTR_INCTV_TYPE                       
P00473                                      = HQ.RT_ATTR_INCTV_TYPE     
P00473                  AND H1.ATTR_INCTV_STRT_DT                       
P00473                                     <= IIF(TRY_CONVERT(DATE, 
                                                   :DF-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:DF-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT) )      
P00473                  AND H1.ATTR_INCTV_END_DT                        
P00473                                     >= IIF(TRY_CONVERT(DATE, 
                                                   :DF-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:DF-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT) )      
P00473                  AND CAST(H1.OPT_ATTR_VSTART_TS AS DATE)                 
P00473                                     <= IIF(TRY_CONVERT(DATE, 
                                                   :DF-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:DF-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT) )      
P00473                  AND CAST(H1.OPT_ATTR_VEND_TS AS DATE)                   
P00473                                     >= IIF(TRY_CONVERT(DATE, 
                                                   :DF-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:DF-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT) )      
P00473                  AND H1.PROC_STATUS_CD      = 'AC')              
P00141         ORDER BY ATTR_INCTV_STRT_DT                              
P00141                                              
C34569                                                           
A00775                                                      
C34569     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ATTR_INCTV_VALUE                                           
MFA-TR*         INTO :HQ-ATTR-INCTV-VALUE                                       
MFA-TR*         FROM CRM_OPT_ATTR_INCTV HQ                                      
MFA-TR*        WHERE HQ.OPTION_CD           = :HQ-OPTION-CD                     
MFA-TR*          AND HQ.COMPANY_NO          = :HQ-COMPANY-NO                    
MFA-TR*          AND HQ.RT_ATTR_INCTV_TYPE  = :HQ-RT-ATTR-INCTV-TYPE            
MFA-TR*          AND HQ.ATTR_INCTV_STRT_DT <= :DF-OPT-AGRMT-EFF-DT              
MFA-TR*          AND HQ.ATTR_INCTV_END_DT  >= :DF-OPT-AGRMT-EFF-DT              
MFA-TR*          AND HQ.PROC_STATUS_CD      = 'AC'                              
MFA-TR*          AND HQ.OPT_ATTR_VSTART_TS = (                                  
MFA-TR*              SELECT MAX(H1.OPT_ATTR_VSTART_TS)                          
MFA-TR*                FROM CRM_OPT_ATTR_INCTV H1                               
MFA-TR*               WHERE H1.OPTION_CD    = HQ.OPTION_CD                      
MFA-TR*                 AND H1.RT_ATTR_INCTV_TYPE                               
MFA-TR*                                     = HQ.RT_ATTR_INCTV_TYPE             
MFA-TR*                 AND H1.ATTR_INCTV_STRT_DT                               
MFA-TR*                                    <= :DF-OPT-AGRMT-EFF-DT              
MFA-TR*                 AND H1.ATTR_INCTV_END_DT                                
MFA-TR*                                    >= :DF-OPT-AGRMT-EFF-DT              
MFA-TR*                 AND DATE(H1.OPT_ATTR_VSTART_TS)                         
MFA-TR*                                    <= :DF-OPT-AGRMT-EFF-DT              
MFA-TR*                 AND DATE(H1.OPT_ATTR_VEND_TS)                           
MFA-TR*                                    >= :DF-OPT-AGRMT-EFF-DT              
MFA-TR*                 AND H1.PROC_STATUS_CD      = 'AC')                      
MFA-TR*        ORDER BY ATTR_INCTV_STRT_DT                                      
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C34569                                                                  
C34569     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
C34569                                                                  
C34569     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C34569        CONTINUE                                                  
C34569     ELSE                                                         
C34569        SET SKIP-ACCOUNT         TO TRUE                          
P00892        IF OPTED-IN-LTR                                           
P00892           DISPLAY 'OPTED IN LETTER ACCOUNT'                      
P00892           ADD +1                        TO WS-OPTIN-SKIP-COUNT   
P00892        ELSE                                                      
P00245          IF RATE-CHANGE-LTR                                      
P00245             DISPLAY 'RATE CHANGE LETTER ACCOUNT'                 
P00245             ADD +1                        TO WS-RTCHG-SKIP-COUNT 
P00245          ELSE                                                    
P00245             DISPLAY 'PRICE SHEET LETTER ACCOUNT'                 
P00245             ADD +1                      TO WS-PRC-SHT-SKIP-COUNT 
T34569             INITIALIZE EXCEP153-REC                              
T34569                      WS-EXCP-LINE                                
T34569             MOVE WS-TERM-FEE-ERR-MSG      TO EL-MESSAGE          
T34569             PERFORM 4000-PROCESS-EXCEPTION THRU 4000-EXIT        
P00245          END-IF                                                  
P00892        END-IF                                                    
C34569        DISPLAY 'ACCT EXIT FEE NOT FOUND : ' VO-ACCOUNT-NO        
C34569        DISPLAY 'ACCT OPTION CODE        : ' HQ-OPTION-CD         
C34569     END-IF.                                                      
C34569*                                                                         
C34569 7300-EXIT.                                                       
C34569     EXIT.                                                        
C34569*                                                                         
P00245****************************************************************          
P00245**  7350-GET-DURATION-NO.                                     **          
P00245**      GET DURATION NO FOR PRIMARY ATTRIBUTE OF OPTION CODE  **          
P00245****************************************************************          
P00245*                                                                         
P00245 7350-GET-DURATION-NO.                                            
P00245*                                                                         
P00245     EXEC SQL                                                     
P00245        SELECT TOP(1) DURATION_NO                                        
P00245          INTO :HQ-DURATION-NO                                    
P00245          FROM CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)                
P00245         WHERE HQ.OPTION_CD           = :HQ-OPTION-CD             
P00245           AND HQ.COMPANY_NO          = '01'                      
P00245           AND HQ.RT_ATTR_INCTV_TYPE  = 'FIXED PRICE'             
P00245           AND HQ.PRIMRY_OPT_ATTR_FL  = 'Y'                       
P00245           AND HQ.ATTR_INCTV_STRT_DT <= IIF(TRY_CONVERT(DATE, 
                                                   :DF-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:DF-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT) )      
P00245           AND HQ.ATTR_INCTV_END_DT  >= IIF(TRY_CONVERT(DATE, 
                                                   :DF-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:DF-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT) )      
P00473           AND HQ.PROC_STATUS_CD      = 'AC'                      
P00473           AND HQ.OPT_ATTR_VSTART_TS = (                          
P00473               SELECT MAX(H1.OPT_ATTR_VSTART_TS)                  
P00473                 FROM CRM_OPT_ATTR_INCTV H1 WITH(READUNCOMMITTED)         
P00473                WHERE H1.OPTION_CD    = HQ.OPTION_CD              
P00473                  AND H1.RT_ATTR_INCTV_TYPE                       
P00473                                      = HQ.RT_ATTR_INCTV_TYPE     
P00473                  AND H1.ATTR_INCTV_STRT_DT                       
P00473                                     <= IIF(TRY_CONVERT(DATE, 
                                                   :DF-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:DF-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT) )      
P00473                  AND H1.ATTR_INCTV_END_DT                        
P00473                                     >= IIF(TRY_CONVERT(DATE, 
                                                   :DF-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:DF-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT) )      
P00473                  AND CAST(H1.OPT_ATTR_VSTART_TS AS DATE)                 
P00473                                     <= IIF(TRY_CONVERT(DATE, 
                                                   :DF-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:DF-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT) )      
P00473                  AND CAST(H1.OPT_ATTR_VEND_TS AS DATE)                   
P00473                                     >= IIF(TRY_CONVERT(DATE, 
                                                   :DF-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:DF-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT) )      
P00473                  AND H1.PROC_STATUS_CD      = 'AC')              
P00245         ORDER BY ATTR_INCTV_STRT_DT                              
P00245                                              
P00245                                                           
A00775                                                      
P00245     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DURATION_NO                                                
MFA-TR*         INTO :HQ-DURATION-NO                                            
MFA-TR*         FROM CRM_OPT_ATTR_INCTV HQ                                      
MFA-TR*        WHERE HQ.OPTION_CD           = :HQ-OPTION-CD                     
MFA-TR*          AND HQ.COMPANY_NO          = '01'                              
MFA-TR*          AND HQ.RT_ATTR_INCTV_TYPE  = 'FIXED PRICE'                     
MFA-TR*          AND HQ.PRIMRY_OPT_ATTR_FL  = 'Y'                               
MFA-TR*          AND HQ.ATTR_INCTV_STRT_DT <= :DF-OPT-AGRMT-EFF-DT              
MFA-TR*          AND HQ.ATTR_INCTV_END_DT  >= :DF-OPT-AGRMT-EFF-DT              
MFA-TR*          AND HQ.PROC_STATUS_CD      = 'AC'                              
MFA-TR*          AND HQ.OPT_ATTR_VSTART_TS = (                                  
MFA-TR*              SELECT MAX(H1.OPT_ATTR_VSTART_TS)                          
MFA-TR*                FROM CRM_OPT_ATTR_INCTV H1                               
MFA-TR*               WHERE H1.OPTION_CD    = HQ.OPTION_CD                      
MFA-TR*                 AND H1.RT_ATTR_INCTV_TYPE                               
MFA-TR*                                     = HQ.RT_ATTR_INCTV_TYPE             
MFA-TR*                 AND H1.ATTR_INCTV_STRT_DT                               
MFA-TR*                                    <= :DF-OPT-AGRMT-EFF-DT              
MFA-TR*                 AND H1.ATTR_INCTV_END_DT                                
MFA-TR*                                    >= :DF-OPT-AGRMT-EFF-DT              
MFA-TR*                 AND DATE(H1.OPT_ATTR_VSTART_TS)                         
MFA-TR*                                    <= :DF-OPT-AGRMT-EFF-DT              
MFA-TR*                 AND DATE(H1.OPT_ATTR_VEND_TS)                           
MFA-TR*                                    >= :DF-OPT-AGRMT-EFF-DT              
MFA-TR*                 AND H1.PROC_STATUS_CD      = 'AC')                      
MFA-TR*        ORDER BY ATTR_INCTV_STRT_DT                                      
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7350                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00245                                                                  
P00245     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00245                                                                  
P00245     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00245        CONTINUE                                                  
P00245     ELSE                                                         
P00245        SET SKIP-ACCOUNT         TO TRUE                          
P00245        ADD +1                   TO WS-RTCHG-SKIP-COUNT           
P00245        DISPLAY 'RATE CHANGE LETTER ACCOUNT'                      
P00245        DISPLAY 'FIXED PRICE DURATION NOT FOUND : ' VO-ACCOUNT-NO 
P00245        DISPLAY 'OPTION CODE                    : ' HQ-OPTION-CD  
P00245     END-IF.                                                      
P00245*                                                                         
P00245 7350-EXIT.                                                       
P00245     EXIT.                                                        
P00245*                                                                         
      ****************************************************************          
      **  7400-SELECT-DEP-ON-HAND                                   **          
      **      GET THE DEPOSIT AMOUNT                                **          
      ****************************************************************          
      *                                                                         
       7400-SELECT-DEP-ON-HAND.                                         
      *                                                                         
           EXEC SQL                                                     
               SELECT SUM(AMT_DEPOSIT)                                  
                 INTO :DO-AMT-DEPOSIT :WS-NULL-DEPOSIT-AMT               
                 FROM CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO        = :DO-ACCOUNT-NO                
                  AND DEPOSIT_STATUS_CD NOT IN ('R','T')                
                                                                 
A00775                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_DEPOSIT)                                          
MFA-TR*          INTO :DO-AMT-DEPOSIT:WS-NULL-DEPOSIT-AMT                       
MFA-TR*          FROM CSS_DEP_ON_HAND                                           
MFA-TR*         WHERE ACCOUNT_NO        = :DO-ACCOUNT-NO                        
MFA-TR*           AND DEPOSIT_STATUS_CD NOT IN ('R','T')                        
MFA-TR*          WITH UR                                                        
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '       ABENDING PROGRAM '                        
              DISPLAY '    7400-SELECT-DEP-ON-HAND '                    
              DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY ' ACCOUNT NO     = ' DO-ACCOUNT-NO                
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C34569****************************************************************          
C34569**  7500-CHK-ACCT-MKT-TIER.                                   **          
C34569**      CHECK THE ACCOUNT MARKET TIER IF THE ACCOUNT IS ONE   **          
C34569**      OF THE FOLLOWING TYPES                                **          
C34569**      D - DE-REGULATED RESIDENTIAL                          **          
C34569**      A - ACN RESIDENTIAL                                   **          
C34569**      1 - GROUP 1 REGULATED                                 **          
C34569**      2 - GROUP 2 REGULATED                                 **          
C34569**      S - SMALL COMMERCIAL                                  **          
C34569**      B - BUSINESS OWNER - RESIDENTIAL                      **          
C34569****************************************************************          
C34569*                                                                         
C34569 7500-CHK-ACCT-MKT-TIER.                                          
C34569*                                                                         
C34569     EXEC SQL                                                     
C34569        SELECT TIER_ACCT_TYPE_CD                                  
P00581          INTO :WS-TIER-ACCT-TYPE-CODE :WS-NULL-IND-01             
C34569          FROM CSS_ACCT_MKT_TIER WITH(READUNCOMMITTED)                    
C34569         WHERE ACCOUNT_NO   = :DD-ACCOUNT-NO                      
C34569           AND EFF_START_DT =                                     
C34569               (SELECT MAX(EFF_START_DT)                          
C34569                  FROM CSS_ACCT_MKT_TIER WITH(READUNCOMMITTED)            
C34569                 WHERE ACCOUNT_NO = :DD-ACCOUNT-NO)               
T34569                                                           
A00775                                                      
C34569     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT TIER_ACCT_TYPE_CD                                          
MFA-TR*         INTO :WS-TIER-ACCT-TYPE-CODE:WS-NULL-IND-01                     
MFA-TR*         FROM CSS_ACCT_MKT_TIER                                          
MFA-TR*        WHERE ACCOUNT_NO   = :DD-ACCOUNT-NO                              
MFA-TR*          AND EFF_START_DT =                                             
MFA-TR*              (SELECT MAX(EFF_START_DT)                                  
MFA-TR*                 FROM CSS_ACCT_MKT_TIER                                  
MFA-TR*                WHERE ACCOUNT_NO = :DD-ACCOUNT-NO)                       
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7500                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C34569                                                                  
C34569     IF WS-NULL-IND-01 < 0                                        
C34569        MOVE NOT-FOUND           TO SQLCODE                       
C34569     END-IF.                                                      
C34569                                                                  
C34569     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
C34569                                                                  
P00581     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C34569        CONTINUE                                                  
C34569     ELSE                                                         
P00581        MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
P00581        DISPLAY '**  PCSCA153 PROCESSING ERROR     **'            
P00581        DISPLAY '**  7500-CHK-ACCT-MKT-TIER        **'            
P00581        DISPLAY '**  ACCOUNT_NO = '  DD-ACCOUNT-NO                
P00581        DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
P00581        DISPLAY '**  PROCESSING TERMINATED         **'            
P00581        PERFORM 9900-ABEND  THRU 9900-EXIT                        
C34569     END-IF.                                                      
C34569*                                                                         
C34569 7500-EXIT.                                                       
C34569     EXIT.                                                        
C34569*                                                                         
P00581*================================================================*        
P00581 7510-OPEN-JOB-PARM-CURSOR.                                       
P00581*================================================================*        
P00581*                                                                         
P00581     EXEC SQL                                                     
P00581          OPEN ALL_JOB_PARM                                       
P00581     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00581*                                                                         
P00581     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00581*                                                                         
P00581     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00581        CONTINUE                                                  
P00581     ELSE                                                         
P00581        MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
P00581        DISPLAY '**  PCSCA153 PROCESSING ERROR     **'            
P00581        DISPLAY '**  7510-OPEN-JOB-PARM-CURSOR     **'            
P00581        DISPLAY '**  OPEN ERROR FOR RD_FMT CURSOR  **'            
P00581        DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
P00581        DISPLAY '**  PROCESSING TERMINATED         **'            
P00581        PERFORM 9900-ABEND  THRU 9900-EXIT                        
P00581     END-IF.                                                      
P00581*                                                                         
P00581 7510-EXIT.                                                       
P00581     EXIT.                                                        
P00581*                                                                         
P00581*================================================================*        
P00581 7520-FETCH-JOB-PARM-CURSOR.                                      

MSQ008     MOVE 50 TO MSQ008-ALL-JOB-PARM
P00581*================================================================*        
P00581*                                                                         
P00581     EXEC SQL                                                     
P00677         FOR :MSQ008-ALL-JOB-PARM
              FETCH 
              FROM ALL_JOB_PARM           
P00581          INTO :TAB-PROGRAM-NAME                                  
P00581              ,:TAB-PARM-DATA                                     
P00581     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*        FETCH NEXT ROWSET FROM ALL_JOB_PARM FOR 50 ROWS                  
MFA-TR*         INTO :TAB-PROGRAM-NAME                                          
MFA-TR*             ,:TAB-PARM-DATA                                             
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-ALL-JOB-PARM
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00581*                                                                         
P00581     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00581*                                                                         
P00581     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00581        MOVE SQLERRD(3)              TO WS-JOB-PARM-COUNT         
P00581     ELSE                                                         
P00581        MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
P00581        DISPLAY '**  PCSCA153 PROCESSING ERROR     **'            
P00581        DISPLAY '**  7520-FETCH-JOB-PARM-CURSOR    **'            
P00581        DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
P00581        DISPLAY '**  PROCESSING TERMINATED         **'            
P00581        PERFORM 9900-ABEND  THRU 9900-EXIT                        
P00581     END-IF.                                                      
P00581*                                                                         
P00581 7520-EXIT.                                                       
P00581     EXIT.                                                        
P00581*                                                                         
P00581*================================================================*        
P00581 7530-CLOSE-JOB-PARM-CURSOR.                                      
P00581*================================================================*        
P00581*                                                                         
P00581     EXEC SQL                                                     
P00581          CLOSE ALL_JOB_PARM                                      
P00581     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00581*                                                                         
P00581     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00581*                                                                         
P00581     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00581        CONTINUE                                                  
P00581     ELSE                                                         
P00581        MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
P00581        DISPLAY '**  PCSCA153 PROCESSING ERROR     **'            
P00581        DISPLAY '**  7530-CLOSE-JOB-PARM-CURSOR    **'            
P00581        DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
P00581        DISPLAY '**  PROCESSING TERMINATED         **'            
P00581        PERFORM 9900-ABEND  THRU 9900-EXIT                        
P00581     END-IF.                                                      
P00581*                                                                         
P00581 7530-EXIT.                                                       
P00581     EXIT.                                                        
P00581*                                                                         
P00581*================================================================*        
P00581 7550-GET-DELINQ-VALUE.                                           
P00581*================================================================*        
P00581* GET PARAMETERS FROM DELINQUENCY TABLE                          *        
P00581*                                                                         
P00581     EXEC SQL                                                     
P00581         SELECT DELINQ_VALUE                                      
P00581           INTO :C8-DELINQ-VALUE                                  
P00581           FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
P00581          WHERE COMPANY_NO = :C8-COMPANY-NO                       
P00581            AND DELINQ_CD  = :C8-DELINQ-CD                        
P00581                                                           
P00581                                                      
P00581     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DELINQ_VALUE                                              
MFA-TR*          INTO :C8-DELINQ-VALUE                                          
MFA-TR*          FROM CSS_DELINQUENCY                                           
MFA-TR*         WHERE COMPANY_NO = :C8-COMPANY-NO                               
MFA-TR*           AND DELINQ_CD  = :C8-DELINQ-CD                                
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7550                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00581*                                                                         
P00581     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
P00581*                                                                         
P00581     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00581        CONTINUE                                                  
P00581     ELSE                                                         
P00581        MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
P00581        DISPLAY '**  PCSCA153 PROCESSING ERROR     **'            
P00581        DISPLAY '**  7550-GET-DELINQ-VALUE         **'            
P00581        DISPLAY '**  COMPANY_NO    = ' C8-COMPANY-NO              
P00581        DISPLAY '**  DELINQ_CD     = ' C8-DELINQ-CD               
P00581        DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE           
P00581        DISPLAY '**  PROCESSING TERMINATED         **'            
P00581        PERFORM 9900-ABEND THRU 9900-EXIT                         
P00581     END-IF.                                                      
P00581*                                                                         
P00581 7550-EXIT.                                                       
P00581     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **    7600-START-FCSJC01                                        **        
      ******************************************************************        
      *                                                                         
            EXEC SQL                                                            
              INCLUDE CPD00038                                                  
            END-EXEC.                                                           
      *                                                                         
      ******************************************************************        
      **    7620-START-FCSCA00                                        **        
      ******************************************************************        
      *                                                                         
            EXEC SQL                                                            
              INCLUDE CPD00039                                                  
            END-EXEC.                                                           
      *                                                                         
C34569****************************************************************          
C34569**  7630-OPEN-DDDC-FACTORS.                                   **          
C34569**      OPEN THE SPCL_FCTR_DDDC CURSOR                        **          
C34569****************************************************************          
C34569*                                                                         
C34569 7630-OPEN-DDDC-FACTORS.                                          
C34569*                                                                         
C34569     EXEC SQL                                                     
C34569         OPEN SPCL_FCTR_DDDC                                      
C34569     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C34569                                                                  
C34569     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C34569                                                                  
C34569     IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
C34569         DISPLAY '*******************************************'    
C34569         DISPLAY '       ABENDING PROGRAM '                       
C34569         DISPLAY '       OPEN ACCOUNT_CUR '                       
C34569         DISPLAY '    7630-OPEN-DDDC-FACTORS '                    
C34569         DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE       
C34569         DISPLAY '*******************************************'    
C34569         PERFORM 9900-ABEND      THRU 9900-EXIT                   
C34569     END-IF.                                                      
C34569*                                                                         
C34569 7630-EXIT.                                                       
C34569     EXIT.                                                        
C34569*                                                                         
C34569****************************************************************          
C34569**  7640-FETCH-DDDC-FACTORS.                                  **          
C34569**      FETCH THE DDDC FACTORS TO LOAD WS-TABLE               **          
C34569****************************************************************          
C34569*                                                                         
C34569 7640-FETCH-DDDC-FACTORS.                                         
C34569*                                                                         
C34569     EXEC SQL                                                     
C34569         FETCH SPCL_FCTR_DDDC                                     
C34569          INTO :SA-RATE-PLAN-NO                                   
C34569              ,:SA-FACTOR                                         
C34569     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C34569                                                                  
C34569     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
C34569                                                                  
C34569     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C34569        ADD 1                    TO DDC-CNT                       
C34569        MOVE SA-RATE-PLAN-NO     TO DDC-RATE-PLAN-NO(DDC-CNT)     
C34569        COMPUTE DDC-FACTOR(DDC-CNT) ROUNDED = SA-FACTOR           
C34569     ELSE                                                         
C34569        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
C34569           SET WS-END-DDDC-CSR   TO TRUE                          
C34569        ELSE                                                      
C34569           DISPLAY '*******************************************'  
C34569           DISPLAY '       ABENDING PROGRAM '                     
C34569           DISPLAY '       FETCH ACCOUNT_CUR '                    
C34569           DISPLAY '    7640-FETCH-DDDC-FACTORS '                 
C34569           DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE     
C34569           DISPLAY '*******************************************'  
C34569           PERFORM 9900-ABEND      THRU 9900-EXIT                 
C34569        END-IF                                                    
C34569     END-IF.                                                      
C34569*                                                                         
C34569 7640-EXIT.                                                       
C34569     EXIT.                                                        
C34569*                                                                         
C34569****************************************************************          
C34569**  7650-CLOSE-DDDC-FACTORS.                                  **          
C34569**      CLOSE THE DDDC FACTORS CURSOR                         **          
C34569****************************************************************          
C34569*                                                                         
C34569 7650-CLOSE-DDDC-FACTORS.                                         
C34569*                                                                         
C34569     EXEC SQL                                                     
C34569         CLOSE SPCL_FCTR_DDDC                                     
C34569     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C34569                                                                  
C34569     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
C34569                                                                  
C34569     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
C34569        DISPLAY '*******************************************'     
C34569        DISPLAY '       ABENDING PROGRAM '                        
C34569        DISPLAY '      CLOSE ACCOUNT_CUR '                        
C34569        DISPLAY '   7650-CLOSE-DDDC-FACTORS '                     
C34569        DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE        
C34569        DISPLAY '*******************************************'     
C34569        PERFORM 9900-ABEND       THRU 9900-EXIT                   
C34569     END-IF.                                                      
C34569*                                                                         
C34569 7650-EXIT.                                                       
C34569     EXIT.                                                        
C34569*                                                                         
P00245****************************************************************          
P00245**  7660-CHK-PREV-OPTION-CD.                                  **          
P00245**      CHECK THE OPT_CALC_TYPE_CD FOR PREVIOUS EXPIRED OPTION**          
P00245****************************************************************          
P00245*                                                                         
P00245 7660-CHK-PREV-OPTION-CD.                                         
P00245*                                                                         
P00245     EXEC SQL                                                     
P00245         SELECT FI.OPT_CALC_TYPE_CD                               
P00245           INTO :WS-PREV-OPT-CALC-TYPE-CD                         
P00245           FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                
P00245               ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                
P00245          WHERE DF.ACCOUNT_NO        = :AT-ACCOUNT-NO             
P00245            AND DF.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE         
P00245            AND DF.IC_NO             = :UT-IC-NO                  
P00245            AND DF.STATUS_CD         = 'E'                        
P00245            AND DF.RT_PKG_OPT_SEQ_NO =                            
P00245             (SELECT MAX(D1.RT_PKG_OPT_SEQ_NO)                    
P00245                FROM CSS_ACCT_RTPK_AGR D1 WITH(READUNCOMMITTED)           
P00245               WHERE D1.ACCOUNT_NO        = DF.ACCOUNT_NO         
P00245                 AND D1.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE     
P00245                 AND D1.IC_NO             = DF.IC_NO              
P00245                 AND D1.RT_PKG_OPT_SEQ_NO < :DF-RT-PKG-OPT-SEQ-NO)
P00245            AND FI.OPTION_CD         = DF.OPTION_CD               
P00473            AND FI.OPT_VSTART_TS     <= CIS.CURRENT$TIMESTAMP()         
P00473            AND FI.OPT_VEND_TS       >= CIS.CURRENT$TIMESTAMP()         
P00473            AND FI.PROC_STATUS_CD     = 'AC'                      
P00245                                                           
A00775                                                      
P00245     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FI.OPT_CALC_TYPE_CD                                       
MFA-TR*          INTO :WS-PREV-OPT-CALC-TYPE-CD                                 
MFA-TR*          FROM CSS_ACCT_RTPK_AGR DF                                      
MFA-TR*              ,CRM_RT_PKG_OPTION FI                                      
MFA-TR*         WHERE DF.ACCOUNT_NO        = :AT-ACCOUNT-NO                     
MFA-TR*           AND DF.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE                 
MFA-TR*           AND DF.IC_NO             = :UT-IC-NO                          
MFA-TR*           AND DF.STATUS_CD         = 'E'                                
MFA-TR*           AND DF.RT_PKG_OPT_SEQ_NO =                                    
MFA-TR*            (SELECT MAX(D1.RT_PKG_OPT_SEQ_NO)                            
MFA-TR*               FROM CSS_ACCT_RTPK_AGR D1                                 
MFA-TR*              WHERE D1.ACCOUNT_NO        = DF.ACCOUNT_NO                 
MFA-TR*                AND D1.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE             
MFA-TR*                AND D1.IC_NO             = DF.IC_NO                      
MFA-TR*                AND D1.RT_PKG_OPT_SEQ_NO < :DF-RT-PKG-OPT-SEQ-NO)        
MFA-TR*           AND FI.OPTION_CD         = DF.OPTION_CD                       
MFA-TR*           AND FI.OPT_VSTART_TS     <= CURRENT TIMESTAMP                 
MFA-TR*           AND FI.OPT_VEND_TS       >= CURRENT TIMESTAMP                 
MFA-TR*           AND FI.PROC_STATUS_CD     = 'AC'                              
MFA-TR*          WITH UR                                                        
MFA-TR*         QUERYNO 7660                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00245                                                                  
P00245     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00245                                                                  
P00245     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00245        CONTINUE                                                  
P00245     ELSE                                                         
P00245        DISPLAY 'RATE CHANGE LETTER ACCOUNT'                      
P00245        DISPLAY 'EXPIRED RT_PKG_AGR NOT FOUND ' AT-ACCOUNT-NO     
P00245        SET SKIP-ACCOUNT         TO TRUE                          
P00245        ADD +1                   TO WS-RTCHG-SKIP-COUNT           
P00245     END-IF.                                                      
P00245*                                                                         
P00245 7660-EXIT.                                                       
P00245     EXIT.                                                        
P00245*                                                                         
T34569******************************************************************        
T34569**  7700-READ-PXCEP153.                                         **        
T34569**  READ THE INPUT EXCEPTION FILE.                              **        
T34569******************************************************************        
T34569*                                                                         
T34569 7700-READ-PXCEP153.                                              
T34569*                                                                         
T34569     READ PXCEP153-FILE AT END                                    
T34569          GO TO 7700-EXIT.                                        
T34569*                                                                         
T34569     IF P153-SUCCESSFUL                                           
P00245        ADD +1                   TO WS-EXCP-RECS-PROCESSED        
T34569     ELSE                                                         
T34569        DISPLAY '******************************************'      
T34569        DISPLAY '**     7700-READ-PXCEP153    **'                 
T34569        DISPLAY '**   ERROR READING PXCEP153  **'                 
T34569        DISPLAY '**        FILE STATUS = ' WS-P153-STATUS         
T34569        DISPLAY '******************************************'      
T34569        MOVE 12                 TO RETURN-CODE                    
T34569        PERFORM 9900-ABEND      THRU 9900-EXIT                    
T34569     END-IF.                                                      
T34569*                                                                         
T34569 7700-EXIT.                                                       
T34569     EXIT.                                                        
T34569*                                                                         
T34569 7800-GET-TIMESTAMP.                                              
T34569                                                                  
T34569     EXEC SQL                                                     
T34569         SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TIMESTAMP                    
T34569     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET: WS-TIMESTAMP = CURRENT TIMESTAMP                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T34569                                                                  
T34569     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
T34569                                                                  
T34569     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T34569        CONTINUE                                                  
T34569     ELSE                                                         
T34569        DISPLAY '*******************************************'     
T34569        DISPLAY '**         7800-GET-TIMESTAMP            **'     
T34569        DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
T34569        DISPLAY '**        PROCESSING IS TERMINATED       **'     
T34569        DISPLAY '** ACCOUNT NO ' VO-ACCOUNT-NO                    
T34569        DISPLAY '*******************************************'     
T34569        PERFORM 9900-ABEND                THRU 9900-EXIT          
T34569     END-IF.                                                      
T34569*                                                                         
T34569 7800-EXIT.                                                       
T34569     EXIT.                                                        
T34569*                                                                         
P00680****************************************************************          
P00680**  7810-OPEN-DISCOUNT-CURSOR                                             
P00680****************************************************************          
P00680*                                                                         
P00680 7810-OPEN-DISCOUNT-CURSOR.                                       
P00680*                                                                         
P00680                                                                  
P00680     EXEC SQL                                                     
P00680         OPEN DISCOUNT_RATE                                       
P00680     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00680                                                                  
P00680     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00680                                                                  
P00680     IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
P00680         DISPLAY '*******************************************'    
P00680         DISPLAY '       ABENDING PROGRAM '                       
P00680         DISPLAY '       OPEN DISCOUNT_RATE '                     
P00680         DISPLAY '    7810-OPEN-DISCOUNT-CURSOR '                 
P00680         DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE       
P00680         DISPLAY ' ACCOUNT_NO     = ' UT-ACCOUNT-NO               
P00680         DISPLAY ' CODE_UTIL_TYPE = ' UT-CODE-UTIL-TYPE           
P00680         DISPLAY ' IC_NO          = ' UT-IC-NO                    
P00680         DISPLAY '*******************************************'    
P00680         PERFORM 9900-ABEND      THRU 9900-EXIT                   
P00680     END-IF.                                                      
P00680*                                                                         
P00680 7810-EXIT.                                                       
P00680     EXIT.                                                        
P00680*                                                                         
P00680****************************************************************          
P00680**  7820-FETCH-DISCOUNT-CURSOR                                            
P00680****************************************************************          
P00680*                                                                         
P00680 7820-FETCH-DISCOUNT-CURSOR.                                      
P00680*                                                                         
P00680     EXEC SQL                                                     
P00680         FETCH DISCOUNT_RATE                                      
P00680          INTO :FF-FACTOR                                         
P00680              ,:FF-DURATION-REMAIN-NO                             
P00680              ,:SF-RT-ATTR-INCTV-TYPE                             
PRJ680              ,:SF-FACTOR-DESC                                    
P00680     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00680                                                                  
P00680     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00680                                                                  
P00680     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00680        CONTINUE                                                  
P00680     ELSE                                                         
P00680        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
P00680           SET WS-END-DISCOUNT-CURSOR   TO TRUE                   
P00680        ELSE                                                      
P00680           DISPLAY '*******************************************'  
P00680           DISPLAY '       ABENDING PROGRAM '                     
P00680           DISPLAY '       FETCH DISCOUNT_RATE '                  
P00680           DISPLAY '    7820-FETCH-DISCOUNT-CURSOR '              
P00680           DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE     
P00680           DISPLAY ' ACCOUNT_NO     = ' UT-ACCOUNT-NO             
P00680           DISPLAY ' CODE_UTIL_TYPE = ' UT-CODE-UTIL-TYPE         
P00680           DISPLAY ' IC_NO          = ' UT-IC-NO                  
P00680           DISPLAY '*******************************************'  
P00680           PERFORM 9900-ABEND      THRU 9900-EXIT                 
P00680        END-IF                                                    
P00680     END-IF.                                                      
P00680*                                                                         
P00680 7820-EXIT.                                                       
P00680     EXIT.                                                        
P00680*                                                                         
P00680****************************************************************          
P00680**  7830-CLOSE-DISCOUNT-CURSOR.                                           
P00680****************************************************************          
P00680*                                                                         
P00680 7830-CLOSE-DISCOUNT-CURSOR.                                      
P00680*                                                                         
P00680     EXEC SQL                                                     
P00680         CLOSE DISCOUNT_RATE                                      
P00680     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00680                                                                  
P00680     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00680                                                                  
P00680     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
P00680        DISPLAY '*******************************************'     
P00680        DISPLAY '       ABENDING PROGRAM '                        
P00680        DISPLAY '      CLOSE DISCOUNT_RATE '                      
P00680        DISPLAY '   7830-CLOSE-DISCOUNT-CURSOR '                  
P00680        DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE        
P00680        DISPLAY ' ACCOUNT_NO     = ' UT-ACCOUNT-NO                
P00680        DISPLAY ' CODE_UTIL_TYPE = ' UT-CODE-UTIL-TYPE            
P00680        DISPLAY ' IC_NO          = ' UT-IC-NO                     
P00680        DISPLAY '*******************************************'     
P00680        PERFORM 9900-ABEND       THRU 9900-EXIT                   
P00680     END-IF.                                                      
P00680*                                                                         
P00680 7830-EXIT.                                                       
P00680     EXIT.                                                        
P00680*                                                                         
P805CS****************************************************************          
P805CS**  7835-OPEN-CSC-DISCOUNT.                                   **          
P805CS**      OPEN THE CSC_DISCOUNT CURSOR                          **          
P805CS****************************************************************          
P805CS*                                                                         
P805CS 7835-OPEN-CSC-DISCOUNT.                                          
P805CS*                                                                         
P805CS     EXEC SQL                                                     
P805CS         OPEN CSC_DISCOUNT                                        
P805CS     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P805CS                                                                  
P805CS     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P805CS                                                                  
P805CS     IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
P805CS         DISPLAY '*******************************************'    
P805CS         DISPLAY '       ABENDING PROGRAM '                       
P805CS         DISPLAY '       OPEN CSC_DISCOUNT'                       
P805CS         DISPLAY '    7835-OPEN-CSC-DISCOUNT '                    
P805CS         DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE       
P805CS         DISPLAY '*******************************************'    
P805CS         PERFORM 9900-ABEND      THRU 9900-EXIT                   
P805CS     END-IF.                                                      
P805CS*                                                                         
P805CS 7835-EXIT.                                                       
P805CS     EXIT.                                                        
P805CS*                                                                         
P805CS****************************************************************          
P805CS**  7840-FETCH-CSC-DISCOUNT.                                  **          
P805CS**      FETCH CSC_DISCOUNT TO LOAD DELINQUENCY VALUES         **          
P805CS****************************************************************          
P805CS*                                                                         
P805CS 7840-FETCH-CSC-DISCOUNT.                                         
P805CS*                                                                         
P805CS     EXEC SQL                                                     
P805CS         FETCH CSC_DISCOUNT                                       
P805CS          INTO :WS-DISCOUNT-TYPE                                  
P805CS              ,:C8-DELINQ-CD                                      
P805CS              ,:C8-DELINQ-VALUE                                   
P805CS     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P805CS                                                                  
P805CS     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P805CS                                                                  
P805CS     EVALUATE WS-ACTIVE-RETURN-CODE                               
P805CS         WHEN SUCCESSFUL-CALL                                     
P805CS            EVALUATE WS-DISCOUNT-TYPE                             
P805CS                WHEN 'AUTORENEW'                                  
P805CS                   MOVE C8-DELINQ-VALUE                           
P805CS                                 TO WS-AUTORENEW-DSCNT-AMT        
P805CS                WHEN 'PAPERLESS'                                  
P805CS                   MOVE C8-DELINQ-VALUE                           
P805CS                                 TO WS-PAPERLESS-DSCNT-AMT        
P805CS                WHEN OTHER                                        
P805CS                   CONTINUE                                       
P805CS            END-EVALUATE                                          
P805CS         WHEN NOT-FOUND                                           
P805CS            CONTINUE                                              
P805CS         WHEN OTHER                                               
P805CS            DISPLAY '*******************************************' 
P805CS            DISPLAY '       ABENDING PROGRAM '                    
P805CS            DISPLAY '       FETCH CSC_DISCOUNT'                   
P805CS            DISPLAY '    7840-FETCH-CSC-DISCOUNT '                
P805CS            DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE    
P805CS            DISPLAY '*******************************************' 
P805CS            PERFORM 9900-ABEND      THRU 9900-EXIT                
P805CS     END-EVALUATE.                                                
P805CS*                                                                         
P805CS 7840-EXIT.                                                       
P805CS     EXIT.                                                        
P805CS*                                                                         
P805CS****************************************************************          
P805CS**  7845-CLOSE-CSC-DISCOUNT.                                  **          
P805CS**      CLOSE CSC_DISCOUNT CURSOR                             **          
P805CS****************************************************************          
P805CS*                                                                         
P805CS 7845-CLOSE-CSC-DISCOUNT.                                         
P805CS*                                                                         
P805CS     EXEC SQL                                                     
P805CS         CLOSE CSC_DISCOUNT                                       
P805CS     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P805CS                                                                  
P805CS     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P805CS                                                                  
P805CS     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
P805CS        DISPLAY '*******************************************'     
P805CS        DISPLAY '       ABENDING PROGRAM '                        
P805CS        DISPLAY '      CLOSE CSC_DISCOUNT'                        
P805CS        DISPLAY '   7845-CLOSE-CSC-DISCOUNT '                     
P805CS        DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE        
P805CS        DISPLAY '*******************************************'     
P805CS        PERFORM 9900-ABEND       THRU 9900-EXIT                   
P805CS     END-IF.                                                      
P805CS*                                                                         
P805CS 7845-EXIT.                                                       
P805CS     EXIT.                                                        
P805CS*                                                                         
P805CS****************************************************************          
P805CS**  7850-OPEN-SPCL-RATES.                                     **          
P805CS**      OPEN THE SPCL_RATES CURSOR                            **          
P805CS****************************************************************          
P805CS*                                                                         
P805CS 7850-OPEN-SPCL-RATES.                                            
P805CS*                                                                         
P805CS     EXEC SQL                                                     
P805CS         OPEN SPCL_RATES                                          
P805CS     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P805CS                                                                  
P805CS     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P805CS                                                                  
P805CS     IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
P805CS         DISPLAY '*******************************************'    
P805CS         DISPLAY '      ABENDING  PROGRAM'                        
P805CS         DISPLAY '       OPEN SPCL_RATES'                         
P805CS         DISPLAY '     7850-OPEN-SPCL-RATES'                      
P805CS         DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE       
P805CS         DISPLAY '*******************************************'    
P805CS         PERFORM 9900-ABEND      THRU 9900-EXIT                   
P805CS     END-IF.                                                      
P805CS*                                                                         
P805CS 7850-EXIT.                                                       
P805CS     EXIT.                                                        
P805CS*                                                                         
P805CS****************************************************************          
P805CS**  7855-FETCH-SPCL-RATES.                                    **          
P805CS**      FETCH SPCL_RATES TO LOAD WS TABLES.                   **          
P805CS****************************************************************          
P805CS*                                                                         
P805CS 7855-FETCH-SPCL-RATES.                                           
P805CS*                                                                         
P805CS     EXEC SQL                                                     
P805CS         FETCH SPCL_RATES                                         
P805CS          INTO :WS-SPCL-RATE-PLAN-NO                              
P805CS              ,:WS-SPCL-RATE-PLAN-TYPE                            
P805CS     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P805CS                                                                  
P805CS     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P805CS                                                                  
P805CS     EVALUATE WS-ACTIVE-RETURN-CODE                               
P805CS         WHEN SUCCESSFUL-CALL                                     
P805CS            EVALUATE WS-SPCL-RATE-PLAN-TYPE                       
P805CS                WHEN 'LEGACY_RATE='                               
P805CS                   ADD 1         TO LRATE-CNT                     
P805CS                   MOVE WS-SPCL-RATE-PLAN-NO                      
P805CS                                 TO LEGACY-RATE-PLAN-NO(LRATE-CNT)
P805CS                WHEN 'OLDCSC_RATE='                               
P805CS                   ADD 1         TO ORATE-CNT                     
P805CS                   MOVE WS-SPCL-RATE-PLAN-NO                      
P805CS                                 TO OLD-RATE-PLAN-NO(ORATE-CNT)   
P805CS            END-EVALUATE                                          
P805CS         WHEN NOT-FOUND                                           
P805CS            CONTINUE                                              
P805CS         WHEN OTHER                                               
P805CS            DISPLAY '*******************************************' 
P805CS            DISPLAY '       ABENDING PROGRAM '                    
P805CS            DISPLAY '       FETCH SPCL_RATES'                     
P805CS            DISPLAY '     7855-FETCH-SPCL-RATES'                  
P805CS            DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE    
P805CS            DISPLAY '*******************************************' 
P805CS            PERFORM 9900-ABEND      THRU 9900-EXIT                
P805CS     END-EVALUATE.                                                
P805CS*                                                                         
P805CS 7855-EXIT.                                                       
P805CS     EXIT.                                                        
P805CS*                                                                         
P805CS****************************************************************          
P805CS**  7860-CLOSE-SPCL-RATES.                                    **          
P805CS**      CLOSE SPCL_RATES CURSOR                               **          
P805CS****************************************************************          
P805CS*                                                                         
P805CS 7860-CLOSE-SPCL-RATES.                                           
P805CS*                                                                         
P805CS     EXEC SQL                                                     
P805CS         CLOSE SPCL_RATES                                         
P805CS     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P805CS                                                                  
P805CS     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P805CS                                                                  
P805CS     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
P805CS        DISPLAY '*******************************************'     
P805CS        DISPLAY '      ABENDING PROGRAM '                         
P805CS        DISPLAY '      CLOSE SPCL_RATES'                          
P805CS        DISPLAY '    7860-CLOSE-SPCL-RATES'                       
P805CS        DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE        
P805CS        DISPLAY '*******************************************'     
P805CS        PERFORM 9900-ABEND       THRU 9900-EXIT                   
P805CS     END-IF.                                                      
P805CS*                                                                         
P805CS 7860-EXIT.                                                       
P805CS     EXIT.                                                        
P805CS*                                                                         
T34569****************************************************************          
T34569**  7900-GET-BILL-WINDOW.                                     **          
T34569**      GET THE BILL WINDOW REVENUE MONTH TO GET THE START    **          
T34569**      DATE FOR THE FIXED FACTOR ACCOUNTS. THIS IS ONLY FOR  **          
T34569**      THE ACCOUNTS WHICH NEVER BILLED IN THE SYSTEM         **          
T34569****************************************************************          
T34569*                                                                         
T34569 7900-GET-BILL-WINDOW.                                            
T34569*                                                                         
T34569     EXEC SQL                                                     
T34569         SELECT TOP(1) REVENUE_MONTH                                     
T34569           INTO :BN-REVENUE-MONTH                                 
T34569           FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                     
T34569          WHERE DATE_EXTRACT > IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )                   
T34569            AND BILL_CYCLE   = :BN-BILL-CYCLE                     
T34569          ORDER BY REVENUE_MONTH                                  
T34569                                              
T34569                                                           
A00775                                                      
T34569     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT REVENUE_MONTH                                             
MFA-TR*          INTO :BN-REVENUE-MONTH                                         
MFA-TR*          FROM CSS_BILL_WINDOW                                           
MFA-TR*         WHERE DATE_EXTRACT > :BN-DATE-EXTRACT                           
MFA-TR*           AND BILL_CYCLE   = :BN-BILL-CYCLE                             
MFA-TR*         ORDER BY REVENUE_MONTH                                          
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*         QUERYNO 7900                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T34569                                                                  
T34569     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
T34569                                                                  
T34569     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T34569        MOVE BN-REVENUE-MONTH    TO WS-HOLD-REV-MNTH              
T34569     ELSE                                                         
T34569        MOVE WS-COMMON-REV-MNTH  TO WS-HOLD-REV-MNTH              
T34569        DISPLAY '*******************************************'     
T34569        DISPLAY '     7900-BILL WINDOW DATA EXCEPTION'            
T34569        DISPLAY 'USING COMMON REVENUE MONTH AS START DATE'        
P00245        DISPLAY '   BILL WINDOW EXTRACT DATE = ' BN-DATE-EXTRACT  
P00245        DISPLAY '   BILL WINDOW BILL CYCLE   = ' BN-BILL-CYCLE    
T34569        DISPLAY '         ACCOUNT NO  = ' VO-ACCOUNT-NO           
T34569        DISPLAY '*******************************************'     
T34569     END-IF.                                                      
T34569*                                                                         
T34569 7900-EXIT.                                                       
T34569     EXIT.                                                        
T34569*                                                                         
T34569****************************************************************          
T34569**  7925-GET-RATE-PLAN.                                       **          
T34569**      GET THE RATE PLAN FOR THE ACCOUNTS IN ERROR. THE ERROR**          
T34569**      REPORT IS WORKED ON BY DART TEAM.                     **          
T34569****************************************************************          
T34569*                                                                         
T34569 7925-GET-RATE-PLAN.                                              
T34569*                                                                         
T34569     EXEC SQL                                                     
T34569         SELECT RATE_PLAN_NO                                      
T34569           INTO :UT-RATE-PLAN-NO                                  
T34569           FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
T34569          WHERE ACCOUNT_NO     = :UT-ACCOUNT-NO                   
T34569            AND CODE_UTIL_TYPE = 'G'                              
T34569            AND IC_NO          = 1                                
T34569                                                           
A00775                                                      
T34569     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RATE_PLAN_NO                                              
MFA-TR*          INTO :UT-RATE-PLAN-NO                                          
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO     = :UT-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = 'G'                                      
MFA-TR*           AND IC_NO          = 1                                        
MFA-TR*          WITH UR                                                        
MFA-TR*         QUERYNO 7925                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T34569                                                                  
T34569     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
T34569                                                                  
T34569     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T34569        CONTINUE                                                  
T34569     ELSE                                                         
T34569        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
T34569           MOVE SPACES           TO UT-RATE-PLAN-NO               
T34569                                    EL-MESSAGE                    
T34569           MOVE 'ACCOUNT DOES NOT HAVE A UTIL ENVRNMT'            
T34569                                 TO EL-MESSAGE                    
T34569        ELSE                                                      
T34569           DISPLAY '*******************************************'  
T34569           DISPLAY '   7925-GET-RATE-PLAN DATA EXCEPTION'         
T34569           DISPLAY '        SQL CODE  = ' WS-ACTIVE-RETURN-CODE   
T34569           DISPLAY '      ACCOUNT NO  = ' VO-ACCOUNT-NO           
T34569           DISPLAY '*******************************************'  
T34569           PERFORM 9900-ABEND    THRU 9900-EXIT                   
T34569        END-IF                                                    
T34569     END-IF.                                                      
T34569*                                                                         
T34569 7925-EXIT.                                                       
T34569     EXIT.                                                        
T34569*                                                                         
T34569****************************************************************          
T34569**  7950-GET-CODE-ACCT-STAT.                                  **          
T34569**      GET THE STATUS CODE FOR THE ACCOUNTS IN ERROR REPORT. **          
T34569**      REPORT IS WORKED ON BY DART TEAM.                     **          
T34569****************************************************************          
T34569*                                                                         
T34569 7950-GET-CODE-ACCT-STAT.                                         
T34569*                                                                         
T34569     EXEC SQL                                                     
T34569         SELECT CODE_ACCT_STAT                                    
T34569           INTO :AT-CODE-ACCT-STAT                                
T34569           FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
T34569          WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                   
T34569                                                           
A00775                                                      
T34569     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_ACCT_STAT                                            
MFA-TR*          INTO :AT-CODE-ACCT-STAT                                        
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                           
MFA-TR*          WITH UR                                                        
MFA-TR*         QUERYNO 7950                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T34569                                                                  
T34569     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
T34569                                                                  
T34569     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T34569        CONTINUE                                                  
T34569     ELSE                                                         
T34569        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
T34569           MOVE SPACES           TO AT-CODE-ACCT-STAT             
T34569                                    EL-MESSAGE                    
T34569           MOVE 'ACCOUNT ENTRY NOT IN CSS_ACCOUNT TBL'            
T34569                                 TO EL-MESSAGE                    
T34569        ELSE                                                      
T34569           DISPLAY '*******************************************'  
T34569           DISPLAY '  7950-GET-CODE-ACCT-STAT DATA EXCEPTION'     
T34569           DISPLAY '        SQL CODE  = ' WS-ACTIVE-RETURN-CODE   
T34569           DISPLAY '      ACCOUNT NO  = ' VO-ACCOUNT-NO           
T34569           DISPLAY '*******************************************'  
T34569           PERFORM 9900-ABEND    THRU 9900-EXIT                   
T34569        END-IF                                                    
T34569     END-IF.                                                      
T34569*                                                                         
T34569 7950-EXIT.                                                       
T34569     EXIT.                                                        
T34569*                                                                         
P00245****************************************************************          
P00245**  7975-GET-MKSW-SVC-START-DT.                               **          
P00245**      GET THE SERVICE START DATE FOR MKSW ACCOUNT           **          
P00245****************************************************************          
P00245*                                                                         
P00245 7975-GET-MKSW-SVC-START-DT.                                      
P00245*                                                                         
P00245     EXEC SQL                                                     
P00245         SELECT ATTRIBUTE_VALUE_DT                                
P00245           INTO :YP-ATTRIBUTE-VALUE-DT                            
P00245           FROM CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                  
P00245          WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                   
P00245            AND ATTRIBUTE_DESC = 'ORDER_EFF_DT'                   
P00245                                                           
A00775                                                      
P00245     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ATTRIBUTE_VALUE_DT                                        
MFA-TR*          INTO :YP-ATTRIBUTE-VALUE-DT                                    
MFA-TR*          FROM CSS_ACCT_ATTRIBUTE                                        
MFA-TR*         WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                           
MFA-TR*           AND ATTRIBUTE_DESC = 'ORDER_EFF_DT'                           
MFA-TR*          WITH UR                                                        
MFA-TR*         QUERYNO 7975                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00245                                                                  
P00245     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00245                                                                  
P00245     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00245        CONTINUE                                                  
P00245     ELSE                                                         
P00245        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
P00245           MOVE SPACES                    TO YP-ATTRIBUTE-VALUE-DT
P00245           SET SKIP-ACCOUNT               TO TRUE                 
P00245           DISPLAY 'PRICE SHEET LETTER ACCOUNT'                   
P00245           DISPLAY 'NO SVC_STRT_DT FOR MKSW ACCT : ' YP-ACCOUNT-NO
P00245           ADD +1                         TO WS-PRC-SHT-SKIP-COUNT
P00245                                                                  
P00245           MOVE YP-ACCOUNT-NO             TO AT-ACCOUNT-NO        
P00245                                                                  
P00245           PERFORM 7950-GET-CODE-ACCT-STAT      THRU 7950-EXIT    
P00245                                                                  
P00245           IF AT-CODE-ACCT-STAT = 'P'                             
P00245              MOVE SPACES                 TO XM-ORIGINATION-CD    
P00245              MOVE AT-ACCOUNT-NO          TO XM-ACCOUNT-NO        
P00245              MOVE '01'                   TO XM-COMPANY-NO        
P00245              PERFORM 8400-UPDATE-MKT-XREF-ACCT THRU 8400-EXIT    
P00245           ELSE                                                   
P00245              IF AT-CODE-ACCT-STAT = 'A'                          
P00245                 INITIALIZE EXCEP153-REC                          
P00245                            WS-EXCP-LINE                          
P00245                 MOVE WS-MKSW-SVC-START-DT-MSG                    
P00245                                          TO EL-MESSAGE           
P00245                 PERFORM 4000-PROCESS-EXCEPTION THRU 4000-EXIT    
P00245              END-IF                                              
P00245           END-IF                                                 
P00245        ELSE                                                      
P00245           DISPLAY '*******************************************'  
P00245           DISPLAY ' 7975-GET-MKSW-SVC-START-DT DATA EXCEPTION '  
P00245           DISPLAY '        SQL CODE  = ' WS-ACTIVE-RETURN-CODE   
P00245           DISPLAY '      ACCOUNT NO  = ' YP-ACCOUNT-NO           
P00245           DISPLAY '*******************************************'  
P00245           PERFORM 9900-ABEND    THRU 9900-EXIT                   
P00245        END-IF                                                    
P00245     END-IF.                                                      
P00245*                                                                         
P00245 7975-EXIT.                                                       
P00245     EXIT.                                                        
P00245*                                                                         
      ****************************************************************          
      **  8000-UPDATE-JOB-PARM                                      **          
      **      UPDATE THE PROGRAM RUN DATE IN JOB_PARM_TABLE         **          
      ****************************************************************          
      *                                                                         
       8000-UPDATE-JOB-PARM.                                            
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_JOB_PARM                                       
                 SET PARM_DATA    = :G6-PARM-DATA                       
               WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                    
                 AND COMPANY_NO   = :G6-COMPANY-NO                      
                 AND CMND_CODE    = :G6-CMND-CODE                       
                 AND STATUS       = :G6-STATUS                          
                 AND SEQ_NO       = :G6-SEQ-NO                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              SET WS-YES-JOBPARM-UPDATED TO TRUE                        
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '       ABENDING PROGRAM '                        
              DISPLAY '     8000-UPDATE-JOB-PARM '                      
              DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY 'PROGRAM_NAME    = ' G6-PROGRAM-NAME              
              DISPLAY 'COMPANY_NO      = ' G6-COMPANY-NO                
              DISPLAY 'CMND_CODE       = ' G6-CMND-CODE                 
              DISPLAY 'SEQ_NO          = ' G6-SEQ-NO                    
              DISPLAY 'STATUS          = ' G6-STATUS                    
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
C34569**     8100-WRITE-FCA916-RECORD.                                **        
      ******************************************************************        
      *                                                                         
C34569 8100-WRITE-FCA916-RECORD.                                        
      *                                                                         
C34569     WRITE FIOCA916.                                              
                                                                        
C34569     IF WS-FCA916-STATUS = '00'                                   
T34569        IF WS-EXCEPTION-FLOW = 'Y'                                
P00245           ADD +1                TO WS-EXCP-RECS-LTR-COUNT        
T34569        ELSE                                                      
P00245           IF RATE-CHANGE-LTR                                     
P00245              ADD +1             TO WS-RTCHG-LTR-COUNT            
P00245           ELSE                                                   
P00245              ADD +1             TO WS-PRC-SHT-LTR-COUNT          
P00245           END-IF                                                 
T34569        END-IF                                                    
C34569     ELSE                                                         
C34569        DISPLAY '*******************************************'     
C34569        DISPLAY '       ABENDING PROGRAM '                        
C34569        DISPLAY '   8100-WRITE-FCA916-RECORD'                     
C34569        DISPLAY 'FILE STATUS     = ' WS-FCA916-STATUS             
C34569        DISPLAY '*******************************************'     
C34569        PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T34569****************************************************************          
T34569**  8200-INSERT-CUST-COMM.                                    **          
T34569**      INSERT A ROW IN THE CUST COMM TABLE                   **          
T34569****************************************************************          
T34569*                                                                         
T34569 8200-INSERT-CUST-COMM.                                           
T34569*                                                                         
T34569     MOVE VO-ACCOUNT-NO          TO KO-ACCOUNT-NO.                
T34569     MOVE 'N'                    TO KO-RED-FLAG-IND.              
T34569     MOVE SPACES                 TO KO-RED-FLAG-EXPIRE-DT.        
T34569     MOVE -1                     TO WS-RED-FL-NULL-IND.           
T34569     MOVE 'L'                    TO KO-COMM-METHOD.               
T34569     MOVE 'O'                    TO KO-COMM-DIRECTION.            
P00892     IF OPTED-IN-LTR                                              
P00892        MOVE '45'                TO KO-COMM-TYPE-CD               
P00892        MOVE '23'                TO KO-COMM-SUBTYPE-CODE          
P00892     ELSE                                                         
P00245       IF RATE-CHANGE-LTR                                         
P00245          MOVE '45'                TO KO-COMM-TYPE-CD             
P00245          MOVE '10'                TO KO-COMM-SUBTYPE-CODE        
P00245       ELSE                                                       
T34569          MOVE '22'                TO KO-COMM-TYPE-CD             
T34569          MOVE '10'                TO KO-COMM-SUBTYPE-CODE        
A00245       END-IF                                                     
P00892     END-IF.                                                      
T34569     MOVE 'SYSTEM'               TO KO-USER-ID-ORIG.              
T34569     MOVE SPACES                 TO KO-PROMOTION-ID.              
T34569     MOVE SPACES                 TO KO-PSC-COMPLIANCE-IND.        
T34569     MOVE 0                      TO KO-CALL-ORIGIN-ID.            
T34569     MOVE SPACES                 TO KO-CALL-END-TIME.             
T34569     MOVE -1                     TO WS-END-NULL-IND.              
T34569     MOVE 0                      TO KO-NUMBER-TRANSFERS.          
T34569     MOVE 0                      TO KO-HOLD-TIME.                 
T34569     MOVE 0                      TO KO-QUEUE-TIME.                
T34569     MOVE 'N'                    TO KO-SCREEN-POP-IND.            
T34569     MOVE 0                      TO KO-TOTAL-CALL-TIME.           
T34569     MOVE SPACES                 TO KO-RESPONSE-REASON-CD.        
T34569     MOVE SPACES                 TO KO-RESPONSE-TYPE-CD.          
T34569     MOVE SPACES                 TO KO-SOLICITATION-CD.           
T34569     MOVE 'A'                    TO KO-COMM-ASSOC-CD.             
T34569     MOVE 'N'                    TO KO-COMPLAINT-FL.              
T34569     MOVE SPACES                 TO KO-DISCOVERY-MTHD-CD.         
T34569     MOVE SPACES                 TO KO-PREV-MARKETER-CD.          
T34569     MOVE 'SYSTEM'               TO KO-CONTACT-NAME.              
T34569     MOVE AT-CUSTOMER-NO         TO KO-CUSTOMER-NO.               
T34569     MOVE ZEROS                  TO KO-PREMISE-NO.                
T34569     MOVE 'SYSTEM'               TO KO-USER-ID-ORIG.              
T34569*                                                                         
T34569     EXEC SQL                                                     
T34569          INSERT INTO CSS_COMM_DATA                               
T34569                  (COMMUNICATION_ID,                              
T34569                   ACCOUNT_NO,                                    
T34569                   CUSTOMER_NO,                                   
T34569                   PREMISE_NO,                                    
T34569                   COMPANY_NO,                                    
T34569                   RED_FLAG_IND,                                  
T34569                   RED_FLAG_EXPIRE_DT,                            
T34569                   COMM_METHOD,                                   
T34569                   COMM_DIRECTION,                                
T34569                   COMM_TYPE_CD,                                  
T34569                   COMM_SUBTYPE_CODE,                             
T34569                   USER_ID_ORIG,                                  
T34569                   CONTACT_NAME,                                  
T34569                   PROMOTION_ID,                                  
T34569                   PSC_COMPLIANCE_IND,                            
T34569                   CALL_ORIGIN_ID,                                
T34569                   CALL_END_TIME,                                 
T34569                   NUMBER_TRANSFERS,                              
T34569                   HOLD_TIME,                                     
T34569                   QUEUE_TIME,                                    
T34569                   SCREEN_POP_IND,                                
T34569                   TOTAL_CALL_TIME,                               
T34569                   INITIAL_COMMENT_TX,                            
T34569                   RESPONSE_REASON_CD,                            
T34569                   RESPONSE_TYPE_CD,                              
T34569                   SOLICITATION_CD,                               
T34569                   COMM_ASSOC_CD,                                 
T34569                   COMPLAINT_FL,                                  
T34569                   DISCOVERY_MTHD_CD,                             
T34569                   PREV_MARKETER_CD)                              
T34569          VALUES   (CIS.CURRENT$TIMESTAMP(),                            
T34569                   :KO-ACCOUNT-NO,                                
T34569                   :KO-CUSTOMER-NO,                               
T34569                   :KO-PREMISE-NO,                                
T34569                   :KO-COMPANY-NO,                                
T34569                   :KO-RED-FLAG-IND,                              
T34569                   CIS.CHAR2TIMESTAMP(:KO-RED-FLAG-EXPIRE-DT 
                                            :WS-RED-FL-NULL-IND),     
T34569                   :KO-COMM-METHOD,                               
T34569                   :KO-COMM-DIRECTION,                            
T34569                   :KO-COMM-TYPE-CD,                              
T34569                   :KO-COMM-SUBTYPE-CODE,                         
T34569                   :KO-USER-ID-ORIG,                              
T34569                   :KO-CONTACT-NAME,                              
T34569                   :KO-PROMOTION-ID,                              
T34569                   :KO-PSC-COMPLIANCE-IND,                        
T34569                   :KO-CALL-ORIGIN-ID,                            
T34569                   CIS.CHAR2TIMESTAMP(:KO-CALL-END-TIME 
                                            :WS-END-NULL-IND),             
T34569                   :KO-NUMBER-TRANSFERS,                          
T34569                   :KO-HOLD-TIME,                                 
T34569                   :KO-QUEUE-TIME,                                
T34569                   :KO-SCREEN-POP-IND,                            
T34569                   :KO-TOTAL-CALL-TIME,                           
T34569                   :KO-INITIAL-COMMENT-TX,                        
T34569                   :KO-RESPONSE-REASON-CD,                        
T34569                   :KO-RESPONSE-TYPE-CD,                          
T34569                   :KO-SOLICITATION-CD,                           
T34569                   :KO-COMM-ASSOC-CD,                             
T34569                   :KO-COMPLAINT-FL,                              
T34569                   :KO-DISCOVERY-MTHD-CD,                         
T34569                   :KO-PREV-MARKETER-CD)                          
T34569     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_COMM_DATA                                       
MFA-TR*                 (COMMUNICATION_ID,                                      
MFA-TR*                  ACCOUNT_NO,                                            
MFA-TR*                  CUSTOMER_NO,                                           
MFA-TR*                  PREMISE_NO,                                            
MFA-TR*                  COMPANY_NO,                                            
MFA-TR*                  RED_FLAG_IND,                                          
MFA-TR*                  RED_FLAG_EXPIRE_DT,                                    
MFA-TR*                  COMM_METHOD,                                           
MFA-TR*                  COMM_DIRECTION,                                        
MFA-TR*                  COMM_TYPE_CD,                                          
MFA-TR*                  COMM_SUBTYPE_CODE,                                     
MFA-TR*                  USER_ID_ORIG,                                          
MFA-TR*                  CONTACT_NAME,                                          
MFA-TR*                  PROMOTION_ID,                                          
MFA-TR*                  PSC_COMPLIANCE_IND,                                    
MFA-TR*                  CALL_ORIGIN_ID,                                        
MFA-TR*                  CALL_END_TIME,                                         
MFA-TR*                  NUMBER_TRANSFERS,                                      
MFA-TR*                  HOLD_TIME,                                             
MFA-TR*                  QUEUE_TIME,                                            
MFA-TR*                  SCREEN_POP_IND,                                        
MFA-TR*                  TOTAL_CALL_TIME,                                       
MFA-TR*                  INITIAL_COMMENT_TX,                                    
MFA-TR*                  RESPONSE_REASON_CD,                                    
MFA-TR*                  RESPONSE_TYPE_CD,                                      
MFA-TR*                  SOLICITATION_CD,                                       
MFA-TR*                  COMM_ASSOC_CD,                                         
MFA-TR*                  COMPLAINT_FL,                                          
MFA-TR*                  DISCOVERY_MTHD_CD,                                     
MFA-TR*                  PREV_MARKETER_CD)                                      
MFA-TR*         VALUES   (CURRENT TIMESTAMP,                                    
MFA-TR*                  :KO-ACCOUNT-NO,                                        
MFA-TR*                  :KO-CUSTOMER-NO,                                       
MFA-TR*                  :KO-PREMISE-NO,                                        
MFA-TR*                  :KO-COMPANY-NO,                                        
MFA-TR*                  :KO-RED-FLAG-IND,                                      
MFA-TR*                  :KO-RED-FLAG-EXPIRE-DT:WS-RED-FL-NULL-IND,             
MFA-TR*                  :KO-COMM-METHOD,                                       
MFA-TR*                  :KO-COMM-DIRECTION,                                    
MFA-TR*                  :KO-COMM-TYPE-CD,                                      
MFA-TR*                  :KO-COMM-SUBTYPE-CODE,                                 
MFA-TR*                  :KO-USER-ID-ORIG,                                      
MFA-TR*                  :KO-CONTACT-NAME,                                      
MFA-TR*                  :KO-PROMOTION-ID,                                      
MFA-TR*                  :KO-PSC-COMPLIANCE-IND,                                
MFA-TR*                  :KO-CALL-ORIGIN-ID,                                    
MFA-TR*                  :KO-CALL-END-TIME:WS-END-NULL-IND,                     
MFA-TR*                  :KO-NUMBER-TRANSFERS,                                  
MFA-TR*                  :KO-HOLD-TIME,                                         
MFA-TR*                  :KO-QUEUE-TIME,                                        
MFA-TR*                  :KO-SCREEN-POP-IND,                                    
MFA-TR*                  :KO-TOTAL-CALL-TIME,                                   
MFA-TR*                  :KO-INITIAL-COMMENT-TX,                                
MFA-TR*                  :KO-RESPONSE-REASON-CD,                                
MFA-TR*                  :KO-RESPONSE-TYPE-CD,                                  
MFA-TR*                  :KO-SOLICITATION-CD,                                   
MFA-TR*                  :KO-COMM-ASSOC-CD,                                     
MFA-TR*                  :KO-COMPLAINT-FL,                                      
MFA-TR*                  :KO-DISCOVERY-MTHD-CD,                                 
MFA-TR*                  :KO-PREV-MARKETER-CD)                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T34569*                                                                         
T34569     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
T34569                                                                  
A00775     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A00775        MOVE 'Y' TO WS-INSERTED                                   
A00775     ELSE                                                         
A00775       IF WS-ACTIVE-RETURN-CODE  = WS-803                         
A00775          ADD 1                                TO WS-803-CTR      
A00775          MOVE 'N'                             TO WS-INSERTED     
A00775          IF WS-803-CTR > 5                                       
A00775             DISPLAY '*************************************'      
A00775             DISPLAY '* 8200-INSERT-CUST-COMM-DATA'               
A00775             DISPLAY '* CUSTOMER_NO = ' AT-CUSTOMER-NO            
A00775             DISPLAY '* ACCOUNT_NO  = ' VO-ACCOUNT-NO             
A00775             DISPLAY '* SQL RETURN CODE = ' SQLCODE               
A00775             DISPLAY '* -803 EXCEEDED 5 TIMES *'                  
A00775             DISPLAY '*************************************'      
A00775             PERFORM 9900-ABEND                THRU 9900-EXIT     
A00775          END-IF                                                  
T34569     ELSE                                                         
T34569        DISPLAY '*************************************'           
T34569        DISPLAY '* 8200-INSERT-CUST-COMM'                         
T34569        DISPLAY '* CUSTOMER_NO = ' AT-CUSTOMER-NO                 
T34569        DISPLAY '* ACCOUNT_NO  = ' VO-ACCOUNT-NO                  
T34569        DISPLAY '* SQL RETURN CODE = ' SQLCODE                    
T34569        DISPLAY '*************************************'           
T34569        PERFORM 9900-ABEND       THRU 9900-EXIT                   
A00775       END-IF                                                     
T34569     END-IF.                                                      
T34569*                                                                         
T34569 8200-EXIT.                                                       
T34569     EXIT.                                                        
T34569*                                                                         
T34569****************************************************************          
T34569**  8300-UPD-TRANS-HIST.                                      **          
T34569**      INSERT A ROW IN TRANSACTION HISTORY                   **          
T34569****************************************************************          
T34569*                                                                         
T34569 8300-UPD-TRANS-HIST.                                             
T34569*                                                                         
T34569     PERFORM 7800-GET-TIMESTAMP  THRU 7800-EXIT.                  
T34569                                                                  
T34569     MOVE WS-TIMESTAMP           TO MH-TRANS-HIST-SEQ-NO.         
P00677     MOVE WS-COMMON-DATE         TO MH-DATE-TRANS.                
T34569     MOVE 'F'                    TO MH-CODE-TRAN-TYPE.            
T34569     MOVE ZEROS                  TO MH-PREMISE-NO.                
T34569     MOVE SPACES                 TO MH-RESP-AREA-ID.              
T34569     MOVE AT-CUSTOMER-NO         TO MH-CUSTOMER-NO.               
T34569     MOVE VO-ACCOUNT-NO          TO MH-ACCOUNT-NO.                
T34569     MOVE 'SYSTEM'               TO MH-USER-ID.                   
T34569     MOVE 'NOTICES'              TO MH-APPL-PROGRAM-ID.           
T34569                                                                  
P00892     IF OPTED-IN-LTR                                              
P00892        STRING 'AUTORENEW OPT IN LTR' DELIMITED BY SIZE           
P00892                               INTO MH-TRAN-COMMENT-TEXT          
P00892        MOVE +20                 TO MH-TRAN-COMMENT-LEN           
P00892     ELSE                                                         
P00245        IF RATE-CHANGE-LTR                                        
P00245           STRING 'RATE CHANGE LETTER' DELIMITED BY SIZE          
P00245                               INTO MH-TRAN-COMMENT-TEXT          
P00245           MOVE +18                 TO MH-TRAN-COMMENT-LEN        
P00245        ELSE                                                      
T34569           STRING 'PRICE SHEET WELCOME KIT' DELIMITED BY SIZE     
T34569                               INTO MH-TRAN-COMMENT-TEXT          
T34569           MOVE +23                 TO MH-TRAN-COMMENT-LEN        
P00245        END-IF                                                    
P00892     END-IF.                                                      
T34569                                                                  
T34569     PERFORM 6540-INSERT-MNT-TRANS-HIST THRU 6540-EXIT.           
T34569*                                                                         
T34569 8300-EXIT.                                                       
T34569     EXIT.                                                        
T34569*                                                                         
P00245****************************************************************          
P00245**8400-UPDATE-MKT-XREF-ACCT.                                  **          
P00245**UPDATE THE ORIGINATION CD IN CSS_MKT_XREF_ACCT TABLE        **          
P00245****************************************************************          
P00245 8400-UPDATE-MKT-XREF-ACCT.                                       
P00245*                                                                         
P00245     EXEC SQL                                                     
P00245        UPDATE CSS_MKT_XREF_ACCT                                  
P00245           SET ORIGINATION_CD = :XM-ORIGINATION-CD                
P00245         WHERE ACCOUNT_NO     = :XM-ACCOUNT-NO                    
P00245           AND COMPANY_NO     = :XM-COMPANY-NO                    
P00245     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00245                                                                  
P00245     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00245                                                                  
P00245     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00245        DISPLAY 'ORIGINATION CODE UPDATED TO SPACES'              
P00245     ELSE                                                         
P00245        DISPLAY '*******************************************'     
P00245        DISPLAY '       ABENDING PROGRAM '                        
P00245        DISPLAY '     8400-UPDATE-MKT-XREF-ACCT '                 
P00245        DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE        
P00245        DISPLAY 'ACCOUNT_NO      = ' XM-ACCOUNT-NO                
P00245        DISPLAY 'COMPANY_NO      = ' XM-COMPANY-NO                
P00245        DISPLAY '*******************************************'     
P00245        PERFORM 9900-ABEND      THRU 9900-EXIT                    
P00245     END-IF.                                                      
P00245*                                                                         
P00245 8400-EXIT.                                                       
P00245     EXIT.                                                        
P00245*                                                                         
A00765****************************************************************          
A00765* 9000-SEND-ERROR-RESULT. REQUIRED BY THE COPYBOOK             *          
A00765****************************************************************          
A00765 9000-SEND-ERROR-RESULT.                                          
A00765                                                                  
A00765     GO TO 9000-EXIT.                                             
A00765*                                                                         
      ****************************************************************          
      **  9000-TERMINATE                                            **          
      **       PROGRAM WRAP UP                                      **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
C34569     CLOSE FCSCA916-FILE                                          
C34569           EXCEP153-FILE                                          
T34569           PXCEP153-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  9500-DISPLAY-STATS.                                       **          
      **       PROGRAM STATISTICS                                   **          
      ****************************************************************          
      *                                                                         
       9500-DISPLAY-STATS.                                              
      *                                                                         
P00245     DISPLAY '*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*'. 
P00245     DISPLAY '          PCSCA153 ENDING SUCCESSFULLY'.            
P00245     DISPLAY '*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*'. 
P00245     DISPLAY '                 PROGRAM SUMMARY'.                  
P00245     DISPLAY '*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*'. 
P00245     DISPLAY 'PROCESSING DATE RANGE 1             : '             
P00245                                         WS-LAST-RUN-DATE.        
P00245     DISPLAY 'PROCESSING DATE RANGE 2             : '             
P00245                                         WS-COMMON-RUN-DATE.      
P00245     DISPLAY 'PRICE SHEET ONMD ACCOUNTS PROCESSED : '             
P00245                                         WS-ONMD-ACCTS-PROCESSED. 
P00245     DISPLAY 'PRICE SHEET MKSW ACCOUNTS PROCESSED : '             
P00245                                         WS-MKSW-ACCTS-PROCESSED. 
P00245     DISPLAY 'RATE CHANGE LTR  ACCOUNTS PROCESSED : '             
P00245                                         WS-RTCHG-ACCTS-PROCESSED.
P00245     DISPLAY 'OPTED IN LTR  ACCOUNTS PROCESSED : '                
P00245                                         WS-OPTIN-ACCTS-PROCESSED.
P00245     DISPLAY 'PRICE SHEET LETTER SKIPPED ACCOUNTS : '             
P00245                                         WS-PRC-SHT-SKIP-COUNT.   
P00245     DISPLAY 'RATE CHANGE LETTER SKIPPED ACCOUNTS : '             
P00245                                         WS-RTCHG-SKIP-COUNT.     
P00245     DISPLAY 'PRICE SHEET LETTERS TO BE PRINTED   : '             
P00245                                         WS-PRC-SHT-LTR-COUNT.    
P00245     DISPLAY 'RATE CHANGE LETTERS TO BE PRINTED   : '             
P00245                                         WS-RTCHG-LTR-COUNT.      
T34569     IF PROCESS-EXCEPTION                                         
P00245        DISPLAY 'PRIOR EXCEPTION ACCOUNTS READ       : '          
P00245                                         WS-EXCP-RECS-PROCESSED   
P00245        DISPLAY 'PRIOR EXCEPTION ACCOUNTS PROCESSED  : '          
P00245                                         WS-EXCP-RECS-LTR-COUNT   
T34569     END-IF.                                                      
           IF WS-YES-JOBPARM-UPDATED                                    
P00245        DISPLAY 'PCSCA153 JOBPARM NEW DATE UPDATED   : '          
P00245                                         WS-COMMON-RUN-DATE       
           END-IF.                                                      
P00245     DISPLAY '*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*'. 
      *                                                                         
       9500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                         
           MOVE SQLCODE                TO WS-DISPLAY-SQLCODE.           
           DISPLAY ' '                                                  
           DISPLAY '**********************************************'     
           DISPLAY '***** 9900-SQL-ERROR-ROUTINE            ******'     
           DISPLAY '**********************************************'     
           DISPLAY ' '                                                  
           DISPLAY 'SQLCODE = ' WS-DISPLAY-SQLCODE                      
           DISPLAY ABEND-RECORD-1-DATA                                  
           DISPLAY ABEND-RECORD-2-DATA                                  
           DISPLAY ABEND-RECORD-3-DATA                                  
           DISPLAY '**********************************************'.    
                                                                        
      ****************************************************************          
      **  9900-ABEND INCLUDES SQL ROLLBACK                          **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
