        IDENTIFICATION DIVISION.                                        
        PROGRAM-ID.     PCSCA152.                                       
        DATE-WRITTEN.   JAN  1995.                                      
            DATE-COMPILED.                                              
      *****************************************************************         
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               **         
      **                     PRICE WATERHOUSE                        **         
      **                1410 NORTH WESTSHORE BLVD                    **         
      **                   TAMPA, FLORIDA  33607                     **         
      **                      (813) 287-9200                         **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  NARRATIVE                             **         
      **                                                             **         
TP8154**  THIS BATCH PROGRAM CREATES BATCH JOURNALS BY INSERTING ROWS**         
TP8154**  IN CSS_BCH_JRNL_CNTL TBL AFTER VALIDATING THE BATCH CONTROL**         
TP8154**  FOR BILL CALC RESULTS .BESIDES THAT IT,CREATES A           **         
TP8154**  GENERAL REPORT EXTRACT FILE FOR REPORT GENERATION.         **         
TP8154**                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **    ____    ________     ______                              **         
      **    JAN 95    GP                                             **         
      **    3/28/95   HC         INCLUDE SQL ERROR PROCESSING        **         
      **                         AND WORK QUEUE PROCESSING           **         
      **    7/24/95   RPM        ADD DISPLAYS                        **         
      **    3/11/96   MJL        FIELD CASH IMPLEMENTATION CHANGES   **         
      **                         CASH REPORT NO = '997'              **         
      **                         CASH DRAWER ID = 9999               **         
      **                         CASH COMPANY NO = '01'              **         
TP8154**   12/18/96   RAO        PROGRAM NARRATIVE ADDED             **         
      **                                                             **         
TESTDS**   04/25/01   DS19153    MAKE FIX SO PROGRAM DOES NOT ABEND  **         
      **                         WHEN A BAD INPUT RECORD IS          **         
      **                         ENCOUNTERED. JUST WRITE TO ERROR    **         
      **                         FILE.                               **         
      **                                                             **         
T25584**   11/15/01   COVANSYS   INCLUDED RESTART AND COMMIT LOGIC   **         
T25584**              INDIA                                          **         
      **                                                             **         
      *****************************************************************         
           REMARKS.                                                     
      *                                                                         
                    ----- BASIC BATCH SEQUENCE STRUCTURE -----          
                    0000 - 0000     MAIN CONTROL PATH                   
                    0100 - 0100     INITIALIZATION                      
                    1000 - 1000     INITIAL READ                        
                    1100 - 1100     MAJOR PROCESSING LOOP               
                    1101 - 4999     PERFORMED PARAGRAPHS OF MAJOR       
                                    PROCESSING LOOPS                    
                    5000 - 5999     COMMON PROGRAM MODULES              
                    6000 - 6999     COMMON SYSTEM MODULES               
                    7000 - 7999     INPUT MODULES                       
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9899     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
      /                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSWK03.                                                            
                                                                        
TESTDS* SELECT STATEMENT FOR OUTPUT PAGE FILE                                   
TESTDS       SELECT PCS15OUT-FILE                                       
TESTDS            ASSIGN TO UT-S-PCS15OUT                               
TESTDS            FILE STATUS IS WS-PCS152OUT-STATUS.                   
                                                                        
      /                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDWK03.                                                            
       COPY FIOWK03.                                                            
                                                                        
TESTDS FD  PCS15OUT-FILE                                                
TESTDS     BLOCK CONTAINS 0 RECORDS                                     
TESTDS     RECORD CONTAINS 80 CHARACTERS                                
TESTDS     RECORDING MODE IS F                                          
TESTDS     LABEL RECORDS ARE STANDARD.                                  
TESTDS 01  PCS152OUT-REC                      PIC X(80).                
                                                                        
      /                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA152'.
MSQ017     COPY MFASQLM.
       COPY FIOJC01.                                                            
      /                                                                         
       COPY FIOCA00.                                                            
      /*****   BILL EXTRACT (BE00)                                              
      ** CWS10000 WAS SPLIT INTO CWS1000A & CWS1000B.                           
      *COPY CWS10000.                                                           
       COPY CWS1000A.                                                           
       COPY CWS1000B.                                                           
      /                                                                         
      *                                                                         
       01  WS-START                    PIC X(40) VALUE                  
           'WORKING STORAGE FOR PCSCA152 STARTS HERE'.                  
       01  WS-ABEND-SWITCH             PIC X(3) VALUE SPACE.            
           88  WS-ABEND-YES            VALUE 'YES'.                     
                                                                        
       01  WS-MISC.                                                     
           05  WS-FWK03-STATUS         PIC X(02).                       
               88  FWK03-SUCCESSFUL                 VALUE '00'.         
TESTDS     05  WS-PCS152OUT-STATUS     PIC X(02).                       
TESTDS         88  PCS152-SUCCESSFUL                VALUE '00'.         
           05  WS-RECORD-COUNT-PIC-9   PIC S9(07)   VALUE ZEROES.       
           05  WS-MORE-DATA-SW         PIC X(01)    VALUE 'Y'.          
               88  WS-NO-MORE-DATA                  VALUE 'N'.          
           05  WS-BEGIN-REC-PROCESSED  PIC X(01)    VALUE 'N'.          
           05  WS-MORE-BEGIN-REC       PIC X(01)    VALUE 'Y'.          
           05  WS-END-REC-PROCESSED    PIC X(01)    VALUE 'N'.          
           05  WS-FWK03-RECORD-COUNT   PIC S9(15)    COMP-3 VALUE ZERO. 
           05  WS-FWK03-REC-CNTR-TOT   PIC S9(15)    COMP-3 VALUE ZERO. 
           05  WS-TIME-OF-DAY          PIC 9(08) VALUE ZERO.            
           05  ACTIVE-PARAGRAPH        PIC 9(04).                       
      *                                                                         
       01  WS-COUNTERS.                                                 
           05  WS-START-POS            PIC S9(04) COMP VALUE ZERO.      
           05  WS-CURRENT-WQ-ITEM      PIC S9(04) COMP VALUE ZERO.      
           05  WS-COUNT-FCSWK03        PIC 9(04)       VALUE ZERO.      
           05  WS-DISPLAY-FCSWK03      PIC ZZZ,ZZZ.                     
           05  WS-FCSBEXT-REC-CNTR     PIC 9(06)       VALUE ZERO.      
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME             PIC X(08)  VALUE 'PCSCA152'.     
           05  WS-PCSCA152             PIC X(08)  VALUE 'PCSCA152'.     
           05  WS-Y                    PIC X(01)  VALUE 'Y'.            
           05  WS-N                    PIC X(01)  VALUE 'N'.            
T25584     05  WS-I                    PIC X(01)  VALUE 'I'.            
T25584     05  WS-13-NINES             PIC 9(13)  VALUE 9999999999999.  
      *                                                                         
       01  WS-LOCAL-OFFICE                 PIC X(03).                   
       01  WS-COMPANY-NO                   PIC X(02).                   
      *                                                                         
       01  WS-INPUT-DATE-BREAKDOWN.                                     
           05  WS-INPUT-DATE-BREAKDOWN-CC    PIC X(02).                 
           05  WS-INPUT-DATE-BREAKDOWN-YY    PIC X(02).                 
           05  FILLER                        PIC X(01).                 
           05  WS-INPUT-DATE-BREAKDOWN-MM    PIC X(02).                 
           05  FILLER                        PIC X(01).                 
           05  WS-INPUT-DATE-BREAKDOWN-DD    PIC X(02).                 
       01  WS-YYMMDD-NO-SLASH-PIC-X.                                    
           05  WS-YYMMDD-NO-SLASH-PIC-X-CC   PIC X(02).                 
           05  WS-YYMMDD-NO-SLASH-PIC-X-YY   PIC X(02).                 
           05  WS-YYMMDD-NO-SLASH-PIC-X-MM   PIC X(02).                 
           05  WS-YYMMDD-NO-SLASH-PIC-X-DD   PIC X(02).                 
       01  WS-YYMMDD-NO-SLASH-PIC-9          PIC S9(08).                
      *                                                                         
TESTDS 01 WS-ERR-INDEX                       PIC 9(04)  VALUE ZERO.     
TESTDS 01 WS-ERROR-TABLE.                                               
TESTDS    05  WS-ERROR-LINE OCCURS 101 TIMES.                           
TESTDS        10  WS-REC-NO              PIC S9(15)  COMP-3 VALUE ZERO. 
TESTDS        10  WS-ACCOUNT-NO          PIC X(13).                     
TESTDS        10  WS-LOC-OFF             PIC X(2).                      
TESTDS        10  WS-COMP-NO             PIC X(2).                      
TESTDS        10  WS-RCV-DEBIT-AMT       PIC S9(09)V99.                 
TESTDS        10  WS-RCV-CREDIT-AMT      PIC S9(09)V99.                 
TESTDS        10  WS-CUSTOMER-NO         PIC S9(10)  COMP-3 VALUE ZERO. 
TESTDS                                                                  
TESTDS 01 MAILHEAD-1.                                                   
TESTDS     05  FILLER                    PIC X(22) VALUE                
TESTDS         'HELO DOMAIN:     SCANA'.                                
TESTDS                                                                  
TESTDS 01  MAILHEAD-2.                                                  
TESTDS     05  FILLER                    PIC X(15) VALUE                
TESTDS         'MAIL FROM:   <T'.                                       
TESTDS     05  MAIL2-JOB-NAME            PIC X(07).                     
TESTDS     05  FILLER                    PIC X(20) VALUE                
TESTDS         '@SCEGJES2.SCANA.COM>'.                                  
TESTDS                                                                  
TESTDS 01 MAILHEAD-3.                                                   
TESTDS     05  FILLER                    PIC X(42) VALUE                
TESTDS         'RCPT TO:     <ISDCSRCAPSSUPPORT@SCANA.COM>'.            
TESTDS                                                                  
TESTDS 01  MAILHEAD-4.                                                  
TESTDS     05  FILLER                    PIC X(04) VALUE                
TESTDS         'DATA'.                                                  
TESTDS                                                                  
TESTDS 01  MAILHEAD-5.                                                  
TESTDS     05  FILLER                    PIC X(19) VALUE                
TESTDS         'FROM: CSR PAGING <T'.                                   
TESTDS     05  MAIL5-JOB-NAME            PIC X(07).                     
TESTDS     05  FILLER                    PIC X(20) VALUE                
TESTDS         '@SCEGJES2.SCANA.COM>'.                                  
TESTDS                                                                  
TESTDS 01 MAILHEAD-6.                                                   
TESTDS     05  FILLER                    PIC X(35) VALUE                
TESTDS         'TO:   <ISDCSRCAPSSUPPORT@SCANA.COM>'.                   
TESTDS                                                                  
TESTDS 01  MAILHEAD-7.                                                  
TESTDS     05  FILLER                    PIC X(10) VALUE                
TESTDS         'SUBJECT:  '.                                            
TESTDS     05  MAIL7-JOB-NAME            PIC X(07).                     
TESTDS                                                                  
TESTDS 01  MAILHEAD-8.                                                  
TESTDS     05  FILLER                    PIC X(44) VALUE                
TESTDS         'NON-CRITICAL ERROR OCCURED DURING PROCESSING'.          
TESTDS                                                                  
TESTDS 01  MAILHEAD-9.                                                  
TESTDS     05  FILLER                    PIC X(80) VALUE SPACES.        
TESTDS                                                                  
TESTDS 01 DETAIL-HEAD-LINE1.                                            
TESTDS     05  FILLER                    PIC X(40) VALUE                
TESTDS         '                          LOC  CO       '.              
TESTDS     05  FILLER                    PIC X(40) VALUE                
TESTDS         '                                        '.              
TESTDS                                                                  
TESTDS 01 DETAIL-HEAD-LINE2.                                            
TESTDS     05  FILLER                    PIC X(40) VALUE                
TESTDS         ' REC-NO     ACCOUNT-NO    OFF  NO  DEBIT'.              
TESTDS     05  FILLER                    PIC X(40) VALUE                
TESTDS         '-AMT    CREDIT-AMT   CUST-NO            '.              
TESTDS                                                                  
TESTDS 01 DETAIL-HEAD-LINE3.                                            
TESTDS     05  FILLER                    PIC X(40) VALUE                
TESTDS         ' ---------  -------------  --  --  -----'.              
TESTDS     05  FILLER                    PIC X(40) VALUE                
TESTDS         '------  -----------  ----------         '.              
TESTDS                                                                  
TESTDS 01 DETAIL-INFO-LINE.                                             
TESTDS     05  FILLER                    PIC X(01) VALUE                
TESTDS         '('.                                                     
TESTDS     05  WS-DET-REC-NO             PIC Z,ZZZ,ZZZ.                 
TESTDS     05  FILLER                    PIC X(02) VALUE                
TESTDS         ')('.                                                    
TESTDS     05  WS-DET-ACCOUNT-NO         PIC X(13).                     
TESTDS     05  FILLER                    PIC X(02) VALUE                
TESTDS         ')('.                                                    
TESTDS     05  WS-DET-LOCAL-OFFICE       PIC X(02).                     
TESTDS     05  FILLER                    PIC X(02) VALUE                
TESTDS         ')('.                                                    
TESTDS     05  WS-DET-COMPANY-NO         PIC X(02).                     
TESTDS     05  FILLER                    PIC X(02) VALUE                
TESTDS         ')('.                                                    
TESTDS     05  WS-DET-RCV-DEBIT-AMT      PIC -ZZZ,ZZZ.99.               
TESTDS     05  FILLER                    PIC X(02) VALUE                
TESTDS         ')('.                                                    
TESTDS     05  WS-DET-RCV-CREDIT-AMT     PIC -ZZZ,ZZZ.99.               
TESTDS     05  FILLER                    PIC X(02) VALUE                
TESTDS         ')('.                                                    
TESTDS     05  WS-DET-CUSTOMER-NO        PIC ZZZZZZZZZZ.                
TESTDS     05  FILLER                    PIC X(01) VALUE                
TESTDS         ')'.                                                     
TESTDS                                                                  
TESTDS 01 WS02-ERROR-LINE.                                              
TESTDS     05  FILLER                    PIC X(01) VALUE SPACES.        
TESTDS     05  WS02-ERROR-DATE           PIC X(10).                     
TESTDS     05  FILLER                    PIC X(02) VALUE SPACES.        
TESTDS     05  WS02-ERROR-DESC           PIC X(35).                     
TESTDS     05  FILLER                    PIC X(02) VALUE SPACES.        
TESTDS     05  WS02-ERROR-DETAIL         PIC X(24).                     
TESTDS                                                                  
TESTDS 01 WS-MESSAGES.                                                  
TESTDS    05 WS02-ERROR-ACCTS          PIC X(35) VALUE                  
TESTDS         'INVALID INPUT RECORDS           '.                      
TESTDS                                                                  
TESTDS 01 WS-DISPLAY-FIELDS.                                            
TESTDS     05  WS-DISP-INVALID-COUNT     PIC ZZZZ9.                     
TESTDS     05  WS-DISP-DET-COUNT         PIC ZZZZZZZZZ9.                
TESTDS     05  WS-DISP-DET-AMOUNT        PIC $$$$$$$9.99.               
TESTDS     05  WS-DISP-HDR-AMOUNT        PIC $$$$$$$9.99.               
TESTDS     05  WS-DISP-HDR-COUNT         PIC ZZZZZZZZZ9.                
TESTDS                                                                  
      *                                                                         
       01  WS-BC-INIT-VALUES.                                           
           05 WS-BC-INIT-LOCAL-OFFICE-ENTRY   PIC X(03) VALUE '000'.    
           05 WS-BC-INIT-DIS-NO-ENTRY         PIC X(01) VALUE '0'.      
           05 WS-BC-INIT-CODE-BATCH-STATUS    PIC X(01) VALUE 'A'.      
           05 WS-BC-INIT-BATCH-SEND-LOC-OFF   PIC X(03) VALUE '000'.    
           05 WS-BC-INIT-CASH-KEY.                                      
              10 WS-BC-INIT-COMPANY-NO        PIC X(02) VALUE '01'.     
              10 WS-BC-INIT-LOCAL-OFFICE      PIC X(03) VALUE SPACES.   
              10 WS-BC-INIT-REPORT-NO         PIC X(03) VALUE '997'.    
              10 WS-BC-INIT-REPORT-DATE       PIC X(10) VALUE SPACES.   
              10 WS-BC-INIT-CASH-DRAWER-ID    PIC S9(04)                
                                              COMP      VALUE 9999.     
           05 WS-BC-INIT-DATE-BATCH-ENTERED   PIC X(10).                
           05 WS-BC-INIT-DATE-LAST-ACTIVITY   PIC X(10).                
           05 WS-BC-INIT-NO-ITEMS-CRNT-CNTL   PIC S9(09)                
                                              COMP     VALUE ZEROES.    
           05 WS-BC-INIT-CASH.                                          
             10 WS-BC-INIT-CASH-DEBIT-AMT    PIC S9(13)V99              
                                             COMP-3     VALUE ZEROES.   
             10 WS-BC-INIT-CASH-CREDIT-AMT   PIC S9(13)V99              
                                             COMP-3     VALUE ZEROES.   
           05 WS-BC-INIT-AR.                                            
             10 WS-BC-INIT-AR-DEBIT-AMT      PIC S9(13)V99              
                                             COMP-3     VALUE ZEROES.   
             10 WS-BC-INIT-AR-CREDIT-AMT     PIC S9(13)V99              
                                             COMP-3     VALUE ZEROES.   
           05 WS-BC-INIT-CHECK-ISSUE.                                   
             10 WS-BC-INIT-CK-ISSUE-DEBIT-AMT PIC S9(13)V99             
                                              COMP-3     VALUE ZEROES.  
             10 WS-BC-INIT-CK-ISSUE-CRED-AMT  PIC S9(13)V99             
                                              COMP-3     VALUE ZEROES.  
           05 WS-BC-INIT-GEN-LED.                                       
             10 WS-BC-INIT-GEN-LED-DEBIT-AMT  PIC S9(13)V99             
                                              COMP-3     VALUE ZEROES.  
             10 WS-BC-INIT-GEN-LED-CREDIT-AMT PIC S9(13)V99             
                                              COMP-3     VALUE ZEROES.  
           05 WS-BC-INIT-NET-BATCH-AMT        PIC S9(13)V99             
                                              COMP-3     VALUE ZEROES.  
           05 WS-BC-INIT-NO-ITEMS-POSTED      PIC S9(9) COMP            
                                              VALUE ZEROES.             
           05 WS-BC-INIT-AMT-BATCH-DEBITS     PIC S9(13)V99             
                                              COMP-3     VALUE ZEROES.  
           05 WS-BC-INIT-AMT-BATCH-CREDITS    PIC S9(13)V99             
                                              COMP-3     VALUE ZEROES.  
      /                                                                         
T25584*                                                                         
T25584 01  WS-RESTART-DATA.                                             
T25584     05  WS-RESTART-PROCESS-TYPE        PIC 9(01).                
T25584     05  WS-RESTART-JOB-COMPLETE    REDEFINES                     
T25584         WS-RESTART-PROCESS-TYPE        PIC X(01).                
T25584     05  WS-RESTART-JOB-STATUS          PIC X(01).                
T25584         88  WS-RUN-COMPLETED-NO-PROBLEMS          VALUE 'A'.     
T25584         88  WS-RERUN-COMPLETED                    VALUE 'B'.     
T25584         88  WS-RERUN-PENDING                      VALUE 'C'.     
T25584     05  WS-RESTART-COMMON-DATE         PIC X(10).                
T25584     05  WS-RESTART-CHKP-SEQ-NO         PIC 9(05).                
T25584*    05  WS-RESTART-RPT-SAVE-ACCT-NO    PIC 9(13)  VALUE ZERO.            
T25584*    05  WS-RESTART-PRINT-SAVE-ACCT-NO  PIC 9(13)  VALUE ZERO.            
T25584*** THE FOLLOWING IS USED FOR DISPLAY PURPOSES ONLY:                      
T25584     05  WS-RESTART-ACCOUNT-NO          PIC 9(13).                
T25584     05  WS-RESTART-REPOSITION-KEY.                               
COB305         10 WS-RESTART-RECORD-COUNT        PIC S9(07) COMP-3 
COB305           VALUE 0.       
COB305     05 WS-RESTART-FCSWK03-REC-CNTR        PIC S9(07) COMP-3 
COB305       VALUE 0.       
COB305     05 WS-RESTART-RF-UPD-CNTR-TOT        PIC S9(07) COMP-3 
COB305       VALUE 0.       
COB305     05 WS-RESTART-RF-ISRT-CNTR-TOT        PIC S9(07) COMP-3 
COB305       VALUE 0.       
T25584*                                                                         
T25584*01  WS-STOP-PARM-BREAKDOWN.                                              
T25584*    05  WS-STOP-PARM-ACCT-NO           PIC 9(13).                        
T25584*    05  FILLER                         PIC X(35).                        
T25584*                                                                         
T25584 01  WS-RESTART-MISC.                                             
T25584     05  WS-RESTART-DATA-LEN            PIC S9(04) VALUE +72 COMP.
T25584     05  WS-IS-THIS-A-RESTART           PIC X(01)  VALUE 'N'.     
T25584         88  WS-THIS-IS-A-RESTART                  VALUE 'Y'.     
T25584     05  WS-PRINT-COUNTERS              PIC X(01)  VALUE 'A'.     
T25584     05  WS-RESTART-REQ                 PIC X(01).                
T25584     05  WS-DEFAULT-RESTART-REQ         PIC X(01)  VALUE 'N'.     
T25584     05  WS-COUNT-UNSUCCESSFUL-ROWS     PIC S9(04) VALUE          
T25584                                                  ZEROS COMP.     
T25584     05  WS-PROCESS-TYPE                PIC 9(01)  VALUE ZERO.    
T25584     05  WS-REPOSITION-NEEDED           PIC X(01)  VALUE 'Y'.     
T25584     05  WS-FLAG-TO-TURN-OFF-COMMITS    PIC 9(04)  VALUE 9999.    
T25584     05  WS-DEFAULT-CHKP-LUW-LIMIT      PIC 9(04)  VALUE 4.       
T25584     05  WS-DEFAULT-CHKP-UPD-LIMIT      PIC 9(04)  VALUE 9999.    
T25584     05  WS-CHKP-LUW-LIMIT              PIC 9(04)  VALUE 200.     
T25584     05  WS-CHKP-UPD-LIMIT              PIC 9(04)  VALUE 200.     
T25584*    05  WS-FCSDB07-REC-CNTR            PIC S9(07) VALUE                  
T25584*                                                   ZERO COMP-3.          
T25584*    05  WS-FCSDB07-REC-CNTR-TOT        PIC S9(07) VALUE                  
T25584*                                                   ZERO COMP-3.          
T25584     05  WS-CHKP-ID.                                              
T25584         10  WS-CHKP-PGM-ID             PIC X(02)  VALUE '00'.    
T25584         10  WS-CHKP-PART-NO            PIC 9(01)  VALUE 1.       
T25584         10  WS-CHKP-SEQ-NO             PIC 9(05)  VALUE ZERO.    
T25584*    05  WS-STOP-ACCT-NO                PIC 9(13).                        
T25584*    05  WS-RPT-SEQ-NO                  PIC S9(05) VALUE                  
T25584*                                                   ZERO COMP-3.          
T25584*    05  WS-RPT-SAVE-ACCT-NO            PIC 9(13)  VALUE ZERO.            
T25584     05  WS-RECORD-COUNT-PIC-9          PIC S9(07) VALUE ZERO.    
T25584     05  WS-RF-UPDATE-CNTR-LUW          PIC S9(07) VALUE          
T25584                                                    ZERO COMP-3.  
T25584     05  WS-RF-INSERT-CNTR-LUW          PIC S9(07) VALUE          
T25584                                                    ZERO COMP-3.  
T25584*    05  WS-LOOP-COUNTER                PIC S9(07) VALUE                  
T25584*                                                   ZERO COMP.            
T25584     05  WS-NO-ROWS-PROCESSED           PIC S9(04) VALUE          
T25584                                                    ZERO COMP-3.  
T25584*    05  WS-PRINT-SAVE-ACCT-NO          PIC S9(13) VALUE ZERO.            
      /                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00013                                                  
           END-EXEC.                                                            
      /                                                                         
       COPY CWS00100.                                                           
      /                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00038                                                 
           END-EXEC.                                                            
                                                                        
      /***** WORKING STORAGE FCA00                                              
           EXEC SQL                                                             
               INCLUDE CWS00039                                                 
           END-EXEC.                                                            
                                                                        
      /***** SQL WORK VARIABLES                                                 
       COPY CWS00303.                                                           
                                                                        
      /****************************************************************         
      **     WORKING STORAGE FOR WQ MESSAGES PERTAINING TO           **         
      **     SQL ERRORS AND OTHER PROGRAM PROBLEMS.                  **         
      **                                                             **         
      *****************************************************************         
       01  WS-EXCEPTION-TEXT.                                           
           05  WS-DATABASE-EXCEPTION       PIC X(30)   VALUE            
                   'A DATABASE EXCEPTION OCCURRED'.                     
           05  WS-MISCELLANEOUS-MESSAGE    PIC X(60).                   
      /***** WORKING STORAGE MESSAGE DETAIL                                     
       COPY CWS0070B.                                                           
                                                                        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE  SQLCA                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE  TBACCT                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE  TBBJCNTL                                               
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE  TBBTJRNL                                               
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE  TBMSJRNL                                               
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE  TBJBPARM                                               
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE  TBMODEL                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE  TBGLATNO                                               
           END-EXEC.                                                            
      *                                                                         
T25584******************************************************************        
T25584*   CSS_RESTART                                                           
T25584******************************************************************        
T25584     EXEC SQL                                                             
T25584            INCLUDE TBRESTRT                                              
T25584     END-EXEC.                                                            
      *                                                                         
       01  WS-END                       PIC X(40) VALUE                 
      *                                                                         
           'WORKING STORAGE FOR PCSCA152 ENDS HERE  '.                  
                                                                        
TESTDS LINKAGE SECTION.                                                 
TESTDS                                                                  
TESTDS 01  PARM.                                                        
TESTDS     05  LNGTH                   PIC S9(04) COMP.                 
TESTDS     05  WS-PASS-JOB             PIC X(07).                       
TESTDS                                                                  
      /                                                                         
TESTDS PROCEDURE DIVISION USING PARM.                                   
TESTDS*PROCEDURE DIVISION.                                                      
      ******************************************************************        
      *                                                                *        
      *   0000-MAINLINE.                                               *        
      *       CONTROLS MAIN PATH OF PROGRAM                            *        
      *                                                                *        
      ******************************************************************        
       0000-MAINLINE.                                                   
T25584     MOVE LENGTH OF WS-RESTART-DATA    TO WS-RESTART-DATA-LEN.    
T25584     INITIALIZE WS-RESTART-DATA.                                  
           PERFORM 0100-INITIALIZATION       THRU 0100-EXIT.            
      *                                                                         
           MOVE WS-Y                         TO WS-MORE-BEGIN-REC       
           PERFORM 1000-PROCESS-BEGIN-REC    THRU 1000-EXIT             
                 UNTIL WS-MORE-BEGIN-REC EQUAL WS-N                     
      *                                                                         
T25584     PERFORM 0600-GET-RESTART-REQUEST  THRU 0600-EXIT             
T25584     IF WS-THIS-IS-A-RESTART                                      
T25584        PERFORM 0602-VALIDATE-REQUEST  THRU 0602-EXIT             
T25584     END-IF                                                       
T25584     PERFORM 0605-VALIDATE-RESTART-REQ THRU 0605-EXIT.            
      *                                                                         
T25584     IF WS-THIS-IS-A-RESTART                                      
T25584        MOVE WS-RESTART-FCSWK03-REC-CNTR TO  WS-FWK03-RECORD-COUNT
T25584        PERFORM WS-FWK03-RECORD-COUNT TIMES                       
T25584          READ FCSWK03-FILE                                       
T25584          IF FWK03-SUCCESSFUL                                     
T25584             CONTINUE                                             
T25584          ELSE                                                    
T25584             DISPLAY '**    PCSCA152 PROCESSING ERROR  ** '       
T25584             DISPLAY '** ERROR READING FCSWK03-FILE    **'        
T25584             DISPLAY '** FILE STATUS IS ' WS-FWK03-STATUS         
T25584             DISPLAY '** ABENDING PROGRAM ...          **'        
T25584             DISPLAY '**      PROCESSING TERMINATED    ** '       
T25584             PERFORM 9900-ABEND        THRU 9900-EXIT             
T25584          END-IF                                                  
T25584        END-PERFORM                                               
T25584     ELSE                                                         
T25584        INITIALIZE WS-RESTART-DATA                                
T25584* MOVE THE COUNT TO RESTART-RECORD-COUNT TO ACCOUNT FOR THE               
T25584* BEGIN RECORDS THAT HAVE BEEN READ                                       
T25584        MOVE WS-COUNT-FCSWK03          TO WS-RESTART-RECORD-COUNT 
T25584        MOVE 1                         TO WS-PROCESS-TYPE         
T25584        MOVE WS-Y                      TO WS-REPOSITION-NEEDED    
T25584        MOVE WS-INPUT-DATE             TO WS-RESTART-COMMON-DATE  
T25584     END-IF.                                                      
      *                                                                         
T25584     IF WS-PROCESS-TYPE = 1                                       
               PERFORM 1100-PROCESS-DAY-BILL-RECS  THRU 1100-EXIT       
                   UNTIL WS-MORE-DATA-SW EQUAL WS-N                     
      *                                                                         
      *****************************************************************         
      *    THE FOLLOWING STATEMENT ISSUES ERROR MESSAGE AND ABENDS THE          
      *    PROGRAM IF THE COUNT FIELD ACCUMULATED DURING READ OF THE            
      *    WORK FILE DOES NOT MATCH THE SUM OF ALL RECORD COUNT FIELDS          
      *    ON ALL ENDING CONTROL RECORDS:                                       
      *****************************************************************         
              IF WS-FWK03-RECORD-COUNT EQUAL WS-FWK03-REC-CNTR-TOT      
                  NEXT SENTENCE                                         
              ELSE                                                      
                  DISPLAY '**         PCSCA152 PROCESSING ERROR       *'
                  DISPLAY '**     TOTAL COUNT OF RECORDS READ FROM    *'
                  DISPLAY '** FCSWK03 WORK FILE DOES NOT MATCH THE SUM*'
                  DISPLAY '**  OF RECORD COUNT FIELDS FROM ALL ENDING *'
                  DISPLAY '**             CONTROL RECORDS             *'
                  DISPLAY '**  WORK FILE READ COUNT = '                 
                          WS-FWK03-RECORD-COUNT                         
                  DISPLAY '**TOT COUNT FROM CNTL RECS = '               
                          WS-FWK03-REC-CNTR-TOT                         
                  DISPLAY '**           PROCESSING TERMINATED         *'
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
              END-IF                                                    
      *                                                                         
TESTDS        IF WS-ERR-INDEX > 0                                       
TESTDS           MOVE 03 TO RETURN-CODE                                 
TESTDS           PERFORM 8300-WRITE-PAGEOUT THRU 8300-EXIT              
TESTDS        END-IF                                                    
      *                                                                         
T25584     END-IF.                                                      
T25584* ISSUE A FINAL CHECK POINT AT THE END OF PROGRAM WHEN ALL                
T25584* RECORDS HAVE BEEN PROCESSED                                             
T25584     IF WS-THIS-IS-A-RESTART                                      
T25584       AND WS-PROCESS-TYPE GREATER THAN 1                         
T25584        NEXT SENTENCE                                             
T25584     ELSE                                                         
T25584        MOVE 2                         TO WS-PROCESS-TYPE         
T25584        MOVE WS-N                      TO WS-REPOSITION-NEEDED    
T25584        PERFORM 8880-ISSUE-CHKP        THRU 8880-EXIT             
T25584        MOVE WS-Y                      TO WS-REPOSITION-NEEDED    
T25584     END-IF.                                                      
T25584*                                                                         
T25584****************************************************************          
T25584* UPGRADE THE JOB-COMPLETE FIELD TO INDICATE SUCCESSFUL COMPLETION        
T25584****************************************************************          
T25584     MOVE SPACES                       TO WS-RESTART-JOB-COMPLETE.
T25584     IF WS-THIS-IS-A-RESTART                                      
T25584         MOVE WS-B                     TO WS-RESTART-JOB-STATUS   
T25584     ELSE                                                         
T25584         MOVE WS-A                     TO WS-RESTART-JOB-STATUS   
T25584     END-IF.                                                      
T25584     PERFORM 8890-MAINTAIN-RESTART     THRU 8890-EXIT.            
T25584*                                                                         
T25584     IF WS-PRINT-COUNTERS EQUAL WS-B OR WS-C                      
T25584        PERFORM 8870-PRINT-COUNTERS    THRU 8870-EXIT             
T25584     END-IF.                                                      
                                                                        
T25584     IF WS-RESTART-REQ = WS-Y                                     
T25584        PERFORM 8893-RESET-RESTART-REQ-PARM                       
T25584                                       THRU 8893-EXIT             
T25584     END-IF.                                                      
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
           DISPLAY '***  PCSCA152 COMPLETED SUCCESSFULLY  ***'.         
           DISPLAY '***  PCSCA152 COMPLETED SUCCESSFULLY  ***'.         
           MOVE WS-COUNT-FCSWK03  TO         WS-DISPLAY-FCSWK03.        
           DISPLAY '*** TOTAL # RECORDS READ FCSWK03 '                  
                                             WS-DISPLAY-FCSWK03.        
      *                                                                         
           STOP RUN.                                                    
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /*****************************************************************        
      *                                                                *        
      *   0100-INITIALIZATION                                          *        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZATION.                                             
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
           IF COMMON-DATE-NEEDED                                        
               PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT        
               MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE               
           END-IF.                                                      
      *                                                                         
           OPEN INPUT  FCSWK03-FILE.                                    
           IF FWK03-SUCCESSFUL                                          
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '0100-ERROR ON FCSWK03 OPEN.  STATUS IS '        
                        WS-FWK03-STATUS                                 
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
TESTDS     INITIALIZE WS-ERR-INDEX.                                     
      *                                                                         
T25584     INITIALIZE WS-SYSIPT.                                        
      *                                                                         
T25584     PERFORM 6255-GET-FJC01-PRT-CNTR   THRU 6255-EXIT.            
T25584     PERFORM 6235-GET-FJC01-RESTART-REQ                           
T25584                                       THRU 6235-EXIT.            
T25584     INITIALIZE WS-SYSIPT                                         
      *                                                                         
T25584     PERFORM 6253-GET-FJC01-CHKP-LIMIT THRU 6253-EXIT.            
T25584*                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T25584 0600-GET-RESTART-REQUEST.                                        
T25584     MOVE WS-PGRMNAME                  TO RF-NAME-PROGRAM.        
T25584     MOVE 1                            TO RF-PARTITION-NO         
T25584                                          WS-CHKP-PART-NO.        
T25584     MOVE 1                            TO RF-DUP-CNTRL-NO.        
T25584     PERFORM 7900-SELECT-RESTART       THRU 7900-EXIT.            
T25584     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T25584        MOVE RF-RESTART-DATA-TEXT      TO WS-RESTART-DATA         
T25584        IF WS-RESTART-PROCESS-TYPE NUMERIC                        
T25584           SET WS-THIS-IS-A-RESTART    TO TRUE                    
T25584        END-IF                                                    
T25584     END-IF.                                                      
T25584 0600-EXIT.                                                       
T25584     EXIT.                                                        
      *                                                                         
T25584 0602-VALIDATE-REQUEST.                                           
T25584     DISPLAY '*********************************************'.     
T25584     DISPLAY '*****   THIS IS A RESTART OF JCSCA152   *****'.     
T25584     DISPLAY '*********************************************'.     
T25584     MOVE WS-RESTART-PROCESS-TYPE      TO WS-PROCESS-TYPE.        
T25584     MOVE WS-RESTART-CHKP-SEQ-NO       TO WS-CHKP-SEQ-NO.         
T25584*    MOVE WS-RESTART-RPT-SAVE-ACCT-NO  TO WS-RPT-SAVE-ACCT-NO.            
T25584*    MOVE WS-RESTART-PRINT-SAVE-ACCT-NO                                   
T25584*                                      TO WS-PRINT-SAVE-ACCT-NO.          
T25584*                                                                         
T25584     IF WS-RESTART-COMMON-DATE NOT = WS-INPUT-DATE                
T25584           AND WS-RESTART-COMMON-DATE NOT EQUAL SPACES            
T25584         DISPLAY '**********************************************' 
T25584         DISPLAY '** COMMON DATE WAS CHANGED PRIOR TO RESTART **' 
T25584         DISPLAY '**********************************************' 
T25584         DISPLAY '** OLD COMMON DATE = ' WS-RESTART-COMMON-DATE   
T25584         DISPLAY '** NEW COMMON DATE = ' WS-INPUT-DATE            
T25584         PERFORM 9900-ABEND            THRU 9900-EXIT             
T25584     END-IF.                                                      
T25584 0602-EXIT.                                                       
T25584     EXIT.                                                        
      *                                                                         
T25584***************************************************************           
T25584*    0605-VALIDATE-RESTART-REQ                               **           
T25584***************************************************************           
T25584 COPY CPD00030.                                                           
      *                                                                         
      /*****************************************************************        
      *                                                                *        
      *   1000-PROCESS-BEGIN-REC                                       *        
      *                                                                *        
      *   READ FIRST FCSWK03 RECORD AND SEND ERROR IF A BEGINNING      *        
      *   CONTROL RECORD IS NOT SUCCESSFULLY RETRIEVED.                *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-BEGIN-REC.                                          
           PERFORM 7000-READ-FCSWK03 THRU 7000-EXIT.                    
           IF FWK03-SUCCESSFUL                                          
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**       PCSCA152 PROCESSING ERROR        **'   
               DISPLAY '**         FCSWK03 FILE IS EMPTY          **'   
               DISPLAY '**         PROCESSING TERMINATED          **'   
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
           IF E-FWK03-KEY-BREC EQUAL LOW-VALUES                         
              MOVE WS-Y TO WS-BEGIN-REC-PROCESSED                       
              PERFORM 1001-VALIDATE-CREATE-DATE THRU 1001-EXIT          
           ELSE                                                         
              IF WS-BEGIN-REC-PROCESSED EQUAL WS-Y                      
                 MOVE WS-N TO WS-MORE-BEGIN-REC                         
              ELSE                                                      
                 DISPLAY '**       PCSCA152 PROCESSING ERROR        **' 
                 DISPLAY '**  FIRST RECORD IS NOT A CONTROL RECORD  **' 
                 DISPLAY '**         PROCESSING TERMINATED          **' 
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /***************************************************************          
      *                                                              *          
      * 1001-VALIDATE-CREATE-DATE                                    *          
      *                                                              *          
      * THE FOLLOWING CODE COMPARES CREATE DATE ON EACH BEGINNING   **          
      * CNTL REC TO RUN DATE FROM JOB CONTROL FILE:                 **          
      *                                                              *          
      ****************************************************************          
       1001-VALIDATE-CREATE-DATE.                                       
           IF E-FWK03-CREATE-DATE-BREC EQUAL WS-INPUT-DATE              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*****************************************'      
               DISPLAY '**   COMMON DATE/OVERRIDING RUN DATE   **'      
               DISPLAY '** DOES NOT MATCH CREATE DATE OF FWK03 **'      
               DISPLAY '**   WORK FILE BEGINNING CONTROL REC   **'      
               DISPLAY '*****************************************'      
               DISPLAY '** COMMON DATE/OVERRIDING RUN DATE = '          
                       WS-INPUT-DATE                                    
               DISPLAY '** WORK FILE CREATE DATE = '                    
                       E-FWK03-CREATE-DATE-BREC                         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
       1001-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /***************************************************************          
      *                                                              *          
      * 1100-PROCESS DAY-BILL-RECS                                   *          
      *                                                              *          
      ****************************************************************          
       1100-PROCESS-DAY-BILL-RECS.                                      
           IF WS-END-REC-PROCESSED EQUAL WS-Y                           
              IF E-FWK03-KEY-EREC EQUAL HIGH-VALUES                     
                 PERFORM 1900-PROCESS-END-REC THRU 1900-EXIT            
                 PERFORM 7000-READ-FCSWK03 THRU 7000-EXIT               
                 GO TO 1100-EXIT                                        
              ELSE                                                      
                 DISPLAY '**       PCSCA152 PROCESSING ERROR       **'  
                 DISPLAY '**  LAST RECORD IS NOT A CONTROL RECORD  **'  
                 DISPLAY '**         PROCESSING TERMINATED         **'  
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           ELSE                                                         
              IF E-FWK03-KEY-EREC EQUAL HIGH-VALUES                     
                 PERFORM 1900-PROCESS-END-REC THRU 1900-EXIT            
                 PERFORM 7000-READ-FCSWK03 THRU 7000-EXIT               
                 GO TO 1100-EXIT                                        
              ELSE                                                      
TESTDS           IF  E-FWK03-COMPANY-NO    EQUAL SPACES                 
TESTDS           AND E-FWK03-LOCAL-OFFICE  EQUAL SPACES                 
TESTDS           AND E-FWK03-ACCT-NO       EQUAL ZEROES                 
TESTDS              IF WS-ERR-INDEX  > 100                              
TESTDS                 PERFORM 9100-DISPLAY-ABEND  THRU 9100-EXIT       
TESTDS              ELSE                                                
TESTDS                 ADD 1  TO  WS-ERR-INDEX                          
TESTDS                 COMPUTE WS-REC-NO (WS-ERR-INDEX) =               
TESTDS                         WS-FWK03-RECORD-COUNT  + 2               
TESTDS                 MOVE E-FWK03-ACCT-NO                             
TESTDS                             TO  WS-ACCOUNT-NO (WS-ERR-INDEX)     
TESTDS                 MOVE E-FWK03-LOCAL-OFFICE                        
TESTDS                             TO  WS-LOC-OFF (WS-ERR-INDEX)        
TESTDS                 MOVE E-FWK03-COMPANY-NO                          
TESTDS                             TO  WS-COMP-NO (WS-ERR-INDEX)        
TESTDS                 MOVE E-FWK03-RCV-DEBIT-AMT                       
TESTDS                             TO  WS-RCV-DEBIT-AMT (WS-ERR-INDEX)  
TESTDS                 MOVE E-FWK03-RCV-CREDIT-AMT                      
TESTDS                             TO  WS-RCV-CREDIT-AMT (WS-ERR-INDEX) 
TESTDS                 MOVE E-FWK03-CUSTOMER-NO                         
TESTDS                             TO  WS-CUSTOMER-NO (WS-ERR-INDEX)    
TESTDS              END-IF                                              
TESTDS           ELSE                                                   
NEWNEW              IF E-FWK03-JRNL-TRAN-APPL-NO = 1                    
                       PERFORM 1200-VALIDATE-JRNL-CNTRL THRU 1200-EXIT  
NEWNEW              END-IF                                              
                    PERFORM 1300-UPDATE-TO-DATABASE    THRU 1300-EXIT   
TESTDS           END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           ADD 1                             TO WS-FWK03-RECORD-COUNT   
T25584                                         ,WS-NO-ROWS-PROCESSED    
T25584                                     ,WS-RESTART-FCSWK03-REC-CNTR.
                                                                        
T25584* ISSUE A CHECKPOINT IF THE RECORDS PROCESSED EQUAL THE CHECK             
T25584* POINT LOWER LIMIT AND RESET THE COUNTER TO ZERO                         
T25584     IF WS-NO-ROWS-PROCESSED = WS-CHKP-LUW-LIMIT                  
T25584        PERFORM 8880-ISSUE-CHKP        THRU 8880-EXIT             
T25584        MOVE ZEROES                    TO WS-NO-ROWS-PROCESSED    
T25584     END-IF.                                                      
                                                                        
           PERFORM 7000-READ-FCSWK03 THRU 7000-EXIT.                    
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /*****************************************************************        
      *                                                                *        
      *   1200-VALIDATE-JRNL-CNTRL.   THIS PARAGRAPH SETS UP CALL TO   *        
      *   TOM.                                                         *        
      *                                                                *        
      ******************************************************************        
       1200-VALIDATE-JRNL-CNTRL.                                        
           MOVE WS-B TO WS-JRNL-SOURCE-CODE.                            
   FCS     MOVE WS-INPUT-DATE             TO WS-BC-INIT-REPORT-DATE.    
   FCS     MOVE E-FWK03-LOCAL-OFFICE      TO WS-BC-INIT-LOCAL-OFFICE.   
   FCS     MOVE SPACES                    TO BC-LOCAL-OFFICE-ENTRY.     
   FCS     MOVE WS-BC-INIT-COMPANY-NO     TO BC-CASH-COMPANY-NO.        
   FCS     MOVE WS-BC-INIT-LOCAL-OFFICE   TO BC-CASH-LOCAL-OFFICE.      
   FCS     MOVE WS-BC-INIT-REPORT-NO      TO BC-CASH-REPORT-NO.         
   FCS     MOVE WS-BC-INIT-REPORT-DATE    TO BC-DATE-CASH-REPORT.       
   FCS     MOVE WS-BC-INIT-CASH-DRAWER-ID TO BC-CASH-DRAWER-ID.         
      ** IF BATCH HEADER NOT FOUND, INSERT IT:                                  
           PERFORM 7200-SELECT-BATCH-JRNL-CNTRL THRU 7200-EXIT.         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 1250-INSERT-BATCH-JRNL-CNTRL THRU 1250-EXIT       
           END-IF.                                                      
PAL        MOVE BC-NO-ITEMS-ENTERED      TO WS-JRNL-NO-ITEMS-CNTRL.     
PAL        ADD 1 TO BC-NO-ITEMS-ENTERED                                 
PAL             GIVING WS-JRNL-ENTRY-NO-HOLD                            
PAL        MOVE 0                        TO WS-100-TRAN-APPL-NO-HOLD.   
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /***************************************************************          
      *                                                              *          
      * 1250-INSERT-BATCH-JRNL-CNTRL                                 *          
      *                                                              *          
      ****************************************************************          
       1250-INSERT-BATCH-JRNL-CNTRL.                                    
           MOVE SPACES TO DCLCSS-BCH-JRNL-CNTL                          
                          WS-BC-INIT-DATE-LAST-ACTIVITY                 
                          WS-BC-INIT-DATE-BATCH-ENTERED.                
   FCS     MOVE WS-INPUT-DATE              TO WS-BC-INIT-REPORT-DATE.   
   FCS     MOVE E-FWK03-LOCAL-OFFICE       TO WS-BC-INIT-LOCAL-OFFICE.  
   FCS     MOVE SPACES                     TO BC-LOCAL-OFFICE-ENTRY.    
   FCS     MOVE SPACES                     TO BC-LOCAL-OFFICE-SEND.     
           MOVE WS-INPUT-DATE              TO BC-DATE-BATCH-ENTERED     
                                              BC-DATE-LAST-ACTIVITY.    
   FCS     MOVE SPACES                        TO BC-BATCH-NO.           
           MOVE WS-BC-INIT-CODE-BATCH-STATUS  TO BC-CODE-BATCH-STATUS.  
   FCS     MOVE WS-BC-INIT-COMPANY-NO         TO BC-CASH-COMPANY-NO.    
   FCS     MOVE WS-BC-INIT-LOCAL-OFFICE       TO BC-CASH-LOCAL-OFFICE.  
   FCS     MOVE WS-BC-INIT-REPORT-NO          TO BC-CASH-REPORT-NO.     
   FCS     MOVE WS-BC-INIT-REPORT-DATE        TO BC-DATE-CASH-REPORT.   
   FCS     MOVE WS-BC-INIT-CASH-DRAWER-ID     TO BC-CASH-DRAWER-ID.     
      *                                                                         
           MOVE WS-BC-INIT-NO-ITEMS-CRNT-CNTL TO BC-NO-ITEMS-ENTERED.   
           MOVE WS-BC-INIT-CASH-DEBIT-AMT     TO BC-AMT-CASH-DEBIT.     
           MOVE WS-BC-INIT-CASH-CREDIT-AMT    TO BC-AMT-CASH-CREDIT.    
           MOVE WS-BC-INIT-AR-DEBIT-AMT       TO BC-AMT-AR-DEBIT.       
           MOVE WS-BC-INIT-AR-CREDIT-AMT      TO BC-AMT-AR-CREDIT.      
           MOVE WS-BC-INIT-CK-ISSUE-DEBIT-AMT TO BC-AMT-CK-ISS-DEBIT.   
           MOVE WS-BC-INIT-CK-ISSUE-CRED-AMT  TO BC-AMT-CK-ISS-CREDIT.  
           MOVE WS-BC-INIT-GEN-LED-DEBIT-AMT  TO BC-AMT-GL-DEBIT.       
           MOVE WS-BC-INIT-GEN-LED-CREDIT-AMT TO BC-AMT-GL-CREDIT.      
           MOVE WS-BC-INIT-NET-BATCH-AMT      TO BC-AMT-NET-BATCH.      
           MOVE WS-BC-INIT-NO-ITEMS-POSTED    TO BC-NO-ITEMS-POSTED.    
           MOVE WS-BC-INIT-AMT-BATCH-DEBITS   TO BC-AMT-BATCH-DEBITS.   
           MOVE WS-BC-INIT-AMT-BATCH-CREDITS  TO BC-AMT-BATCH-CREDITS.  
      *                                                                         
           PERFORM 8200-INSERT-BCH-JRNL-CNTRL THRU 8200-EXIT.           
                                                                        
           DISPLAY '**       PCSCA152 INFORMATIONAL MESSAGE       **'.  
           DISPLAY '** INSERTED BATCH JRNL CNTRL TO "TO" DATABASE **'.  
           DISPLAY '**            PROCESSING CONTINUING           **'.  
                                                                        
       1250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
      /*****************************************************************        
      *                                                                *        
      * 1300-UPDATE-TO-DATABASE                                        *        
      *   UPDATE TO DATABASE FROM DAILY BILLING RECORDS ON WORK FILE   *        
      *                                                                *        
      ******************************************************************        
       1300-UPDATE-TO-DATABASE.                                         
           MOVE E-FWK03-JRNL-SORT-ID       TO WS-100-JRNL-SORT-ID       
                                              BJ-JRNL-SORT-ID.          
           MOVE E-FWK03-ACCT-NO            TO WS-100-ACCT-NO.           
           MOVE E-FWK03-CUSTOMER-NO        TO WS-100-CUSTOMER-NO.       
           MOVE E-FWK03-LOCAL-OFFICE       TO WS-100-LOCAL-OFFICE-CD    
                                              WS-BC-INIT-LOCAL-OFFICE.  
           MOVE E-FWK03-COMPANY-NO         TO WS-100-COMPANY-NO.        
           MOVE WS-INPUT-DATE              TO WS-BC-INIT-REPORT-DATE.   
           MOVE WS-INPUT-DATE              TO WS-JRNL-TRAN-DATE.        
           MOVE ZEROES                     TO BC-NO-ITEMS-ENTERED.      
   FCS     MOVE WS-BC-INIT-COMPANY-NO         TO BC-CASH-COMPANY-NO.    
   FCS     MOVE WS-BC-INIT-LOCAL-OFFICE       TO BC-CASH-LOCAL-OFFICE.  
   FCS     MOVE WS-BC-INIT-REPORT-NO          TO BC-CASH-REPORT-NO.     
   FCS     MOVE WS-BC-INIT-REPORT-DATE        TO BC-DATE-CASH-REPORT.   
   FCS     MOVE WS-BC-INIT-CASH-DRAWER-ID     TO BC-CASH-DRAWER-ID.     
                                                                        
           PERFORM 7200-SELECT-BATCH-JRNL-CNTRL THRU 7200-EXIT.         
                                                                        
           MOVE BC-NO-ITEMS-ENTERED        TO WS-JRNL-NO-ITEMS-CNTRL.   
   FCS     MOVE BC-CASH-COMPANY-NO         TO WS-JRNL-BT-BAT-COMPANY.   
   FCS     MOVE BC-CASH-LOCAL-OFFICE       TO WS-JRNL-BT-BAT-LOC-OFF.   
   FCS     MOVE BC-CASH-REPORT-NO          TO WS-JRNL-BT-BAT-REPORT-NO. 
   FCS     MOVE BC-DATE-CASH-REPORT        TO WS-JRNL-BT-BAT-REPORT-DT. 
   FCS     MOVE BC-CASH-DRAWER-ID          TO WS-JRNL-BT-BAT-CASH-DRWR. 
   FCS     MOVE SPACES                     TO WS-JRNL-CURRENCY-TYPE.    
                                                                        
           PERFORM 6405-GET-CURRENT-JRNL-TIME THRU 6405-EXIT.           
                                                                        
           MOVE WS-100-LOCAL-OFFICE-CD     TO WS-LOCAL-OFFICE.          
           MOVE WS-100-COMPANY-NO          TO WS-COMPANY-NO.            
           MOVE E-FWK03-CODE-TERMINAL-TRAN TO WS-100-CODE-TERMINAL-TRAN.
           MOVE E-FWK03-JRNL-TRAN-APPL-NO  TO WS-100-JRNL-TRAN-APPL-NO. 
           MOVE E-FWK03-DATE-LAST-ACTION   TO WS-100-DATE-LAST-ACTION.  
           MOVE E-FWK03-CODE-ENTRY-SOURCE  TO WS-100-CODE-ENTRY-SOURCE. 
           MOVE E-FWK03-TRAN-ERRORS        TO WS-100-TRANS-ERRORS.      
           MOVE E-FWK03-RCV-DEBIT-AMT      TO WS-JRNL-RCV-DEBIT-AMT.    
           MOVE E-FWK03-RCV-CREDIT-AMT     TO WS-JRNL-RCV-CREDIT-AMT.   
           MOVE E-FWK03-GEN-LEG-DEBIT-AMT  TO WS-JRNL-GEN-LEG-DEBIT-AMT.
           MOVE E-FWK03-GEN-LEG-CREDIT-AMT                              
                                          TO WS-JRNL-GEN-LEG-CREDIT-AMT.
           MOVE E-FWK03-USER-DEFINED-AREA  TO WS-100-USER-DEFINED-AREA. 
           MOVE WS-JRNL-AND-CNTRL          TO WS-JRNL-OPERATION-RQST.   
           MOVE WS-JRNL-CASH-UPDATE        TO WS-JRNL-BT-AUTH-TYPE.     
                                                                        
           PERFORM 6400-BATCH-JRNL-ROUTINE THRU 6400-EXIT.              
      *                                                                         
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY 'JOURNAL INSERT ERROR. JOURNAL RETURN CODE ='     
                      WS-JRNL-RTRN-CODE                                 
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       1300-EXIT.                                                       
           EXIT.                                                        
T25584**************************************************************            
T25584* 6235-GET-FJC01-RESTART-REQ.                                             
T25584**************************************************************            
T25584     EXEC SQL                                                             
T25584         INCLUDE CPD00035                                                 
T25584     END-EXEC.                                                            
T25584*                                                                         
T25584****************************************************************          
T25584**  6253-GET-FJC01-CHKP-LIMIT.                                 *          
T25584****************************************************************          
T25584      EXEC SQL                                                            
T25584          INCLUDE CPD00034                                                
T25584      END-EXEC.                                                           
T25584*                                                                         
T25584***************************************************************           
T25584**  6255-GET-FJC01-PRT-CNTR.                                 **           
T25584***************************************************************           
T25584 COPY CPD00015.                                                           
T25584*                                                                         
      /***************************************************************          
      *                                                              *          
      * 1900-PROCESS-END-REC.                                        *          
      *                                                              *          
      ****************************************************************          
       1900-PROCESS-END-REC.                                            
           ADD E-FWK03-RECORD-COUNT-EREC TO WS-FWK03-REC-CNTR-TOT.      
           MOVE WS-Y TO WS-END-REC-PROCESSED.                           
       1900-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       COPY CPD00040.                                                           
      /                                                                         
       COPY CPD00037.                                                           
      /*** 6400-BATCH-JRNL-ROUTINE                                              
           EXEC SQL                                                             
                INCLUDE CPD00007                                                
           END-EXEC.                                                            
                                                                        
      /***************************************************************          
      *                                                              *          
      * 7000-READ-FCSWK03                                            *          
      *                                                              *          
      ****************************************************************          
       7000-READ-FCSWK03.                                               
           READ FCSWK03-FILE                                            
               AT END                                                   
                   MOVE WS-N TO WS-MORE-DATA-SW                         
                   GO TO 7000-EXIT.                                     
      *                                                                         
           IF FWK03-SUCCESSFUL                                          
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY 'WRITE ERROR ON WK03. STATUS = '                  
                      WS-FWK03-STATUS                                   
              MOVE 16 TO RETURN-CODE                                    
              PERFORM 9900-ABEND                                        
           END-IF.                                                      
                                                                        
              ADD 1 TO WS-COUNT-FCSWK03                                 
T25584                ,WS-RESTART-RECORD-COUNT.                         
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /***************************************************************          
      *                                                              *          
      * 7200-SELECT-BATCH-JRNL-CNTRL.                                *          
      *                                                              *          
      ****************************************************************          
       7200-SELECT-BATCH-JRNL-CNTRL.                                    
           EXEC SQL                                                     
                SELECT                                                  
                       DATE_LAST_ACTIVITY,                              
                       NO_ITEMS_ENTERED,                                
                       AMT_CASH_DEBIT,                                  
                       AMT_CASH_CREDIT,                                 
                       AMT_AR_DEBIT,                                    
                       AMT_AR_CREDIT,                                   
                       AMT_CK_ISS_DEBIT,                                
                       AMT_CK_ISS_CREDIT,                               
                       AMT_GL_DEBIT,                                    
                       AMT_GL_CREDIT                                    
                INTO                                                    
                       :BC-DATE-LAST-ACTIVITY,                          
                       :BC-NO-ITEMS-ENTERED,                            
                       :BC-AMT-CASH-DEBIT,                              
                       :BC-AMT-CASH-CREDIT,                             
                       :BC-AMT-AR-DEBIT,                                
                       :BC-AMT-AR-CREDIT,                               
                       :BC-AMT-CK-ISS-DEBIT,                            
                       :BC-AMT-CK-ISS-CREDIT,                           
                       :BC-AMT-GL-DEBIT,                                
                       :BC-AMT-GL-CREDIT                                
                FROM  CSS_BCH_JRNL_CNTL                                 
                WHERE CASH_COMPANY_NO   = :BC-CASH-COMPANY-NO           
                  AND CASH_LOCAL_OFFICE = :BC-CASH-LOCAL-OFFICE         
                  AND CASH_REPORT_NO    = :BC-CASH-REPORT-NO            
                  AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :BC-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :BC-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:BC-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:BC-DATE-CASH-REPORT
              ), CONVERT(DATE, :BC-DATE-CASH-REPORT) )          
                  AND CASH_DRAWER_ID    = :BC-CASH-DRAWER-ID            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                DATE_LAST_ACTIVITY,                                      
MFA-TR*                NO_ITEMS_ENTERED,                                        
MFA-TR*                AMT_CASH_DEBIT,                                          
MFA-TR*                AMT_CASH_CREDIT,                                         
MFA-TR*                AMT_AR_DEBIT,                                            
MFA-TR*                AMT_AR_CREDIT,                                           
MFA-TR*                AMT_CK_ISS_DEBIT,                                        
MFA-TR*                AMT_CK_ISS_CREDIT,                                       
MFA-TR*                AMT_GL_DEBIT,                                            
MFA-TR*                AMT_GL_CREDIT                                            
MFA-TR*         INTO                                                            
MFA-TR*                :BC-DATE-LAST-ACTIVITY,                                  
MFA-TR*                :BC-NO-ITEMS-ENTERED,                                    
MFA-TR*                :BC-AMT-CASH-DEBIT,                                      
MFA-TR*                :BC-AMT-CASH-CREDIT,                                     
MFA-TR*                :BC-AMT-AR-DEBIT,                                        
MFA-TR*                :BC-AMT-AR-CREDIT,                                       
MFA-TR*                :BC-AMT-CK-ISS-DEBIT,                                    
MFA-TR*                :BC-AMT-CK-ISS-CREDIT,                                   
MFA-TR*                :BC-AMT-GL-DEBIT,                                        
MFA-TR*                :BC-AMT-GL-CREDIT                                        
MFA-TR*         FROM  CSS_BCH_JRNL_CNTL                                         
MFA-TR*         WHERE CASH_COMPANY_NO   = :BC-CASH-COMPANY-NO                   
MFA-TR*           AND CASH_LOCAL_OFFICE = :BC-CASH-LOCAL-OFFICE                 
MFA-TR*           AND CASH_REPORT_NO    = :BC-CASH-REPORT-NO                    
MFA-TR*           AND DATE_CASH_REPORT  = :BC-DATE-CASH-REPORT                  
MFA-TR*           AND CASH_DRAWER_ID    = :BC-CASH-DRAWER-ID                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
                                          OR NOT-FOUND                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'BC'                    TO WS-DB2-TABLE-ID          
               MOVE 'SELECT'                TO WS-DB2-FUNCTION          
               MOVE SQLCODE                 TO WS-DB2-RETURN-CODE       
               MOVE '152'                   TO WS-DB2-MODULE-ID         
               MOVE '7200'                  TO WS-DB2-PARAGRAPH         
               MOVE BC-CASH-COMPANY-NO      TO WS-DB2-KEY-1             
               MOVE BC-CASH-LOCAL-OFFICE    TO WS-DB2-KEY-2             
               MOVE BC-CASH-REPORT-NO       TO WS-DB2-KEY-3             
               MOVE BC-DATE-CASH-REPORT     TO WS-DB2-KEY-4             
               MOVE 12                      TO RETURN-CODE              
               PERFORM 9910-SQL-ERROR THRU 9910-EXIT                    
           END-IF.                                                      
       7200-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
T25584******************************************************************        
T25584*                                                                *        
T25584*     7900-SELECT-RESTART                                        *        
T25584*                                                                *        
T25584******************************************************************        
T25584 7900-SELECT-RESTART.                                             
T25584     EXEC SQL                                                     
T25584          SELECT  RESTART_DATA                                    
T25584            INTO :RF-RESTART-DATA                                 
T25584            FROM  CSS_RESTART                                     
T25584           WHERE  NAME_PROGRAM  = :RF-NAME-PROGRAM                
T25584             AND  PARTITION_NO  = :RF-PARTITION-NO                
T25584             AND  DUP_CNTRL_NO  = :RF-DUP-CNTRL-NO                
T25584     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T25584     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
T25584     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T25584        OR NOT-FOUND                                              
T25584         CONTINUE                                                 
T25584     ELSE                                                         
T25584         MOVE 'RF'                     TO WS-DB2-TABLE-ID         
T25584         MOVE 'SELECT'                 TO WS-DB2-FUNCTION         
T25584         MOVE SQLCODE                  TO WS-DB2-RETURN-CODE      
T25584         MOVE '152'                    TO WS-DB2-MODULE-ID        
T25584         MOVE '7900'                   TO WS-DB2-PARAGRAPH        
T25584         MOVE RF-NAME-PROGRAM          TO WS-DB2-KEY-1            
T25584         MOVE RF-PARTITION-NO          TO WS-DB2-KEY-2            
T25584         MOVE RF-DUP-CNTRL-NO          TO WS-DB2-KEY-3            
T25584         MOVE 12                       TO RETURN-CODE             
T25584         PERFORM 9910-SQL-ERROR        THRU 9910-EXIT             
T25584     END-IF.                                                      
T25584 7900-EXIT.                                                       
T25584      EXIT.                                                       
      *                                                                         
      /***************************************************************          
      *                                                              *          
      * 8200-INSERT-BCH-JRNL-CNTRL                                   *          
      *                                                              *          
      ****************************************************************          
       8200-INSERT-BCH-JRNL-CNTRL.                                      
           EXEC SQL                                                     
                INSERT INTO  CSS_BCH_JRNL_CNTL                          
                (LOCAL_OFFICE_ENTRY,                                    
                 BATCH_NO,                                              
                 CODE_BATCH_STATUS,                                     
                 LOCAL_OFFICE_SEND,                                     
                 DATE_BATCH_ENTERED,                                    
                 DATE_LAST_ACTIVITY,                                    
                 NO_ITEMS_ENTERED,                                      
                 AMT_CASH_DEBIT,                                        
                 AMT_CASH_CREDIT,                                       
                 AMT_AR_DEBIT,                                          
                 AMT_AR_CREDIT,                                         
                 AMT_CK_ISS_DEBIT,                                      
                 AMT_CK_ISS_CREDIT,                                     
                 AMT_GL_DEBIT,                                          
                 AMT_GL_CREDIT,                                         
                 AMT_NET_BATCH,                                         
                 NO_ITEMS_POSTED,                                       
                 AMT_BATCH_DEBITS,                                      
                 AMT_BATCH_CREDITS,                                     
                 CASH_COMPANY_NO,                                       
                 DATE_CASH_REPORT,                                      
                 CASH_REPORT_NO,                                        
                 CASH_LOCAL_OFFICE,                                     
                 CASH_DRAWER_ID)                                        
            VALUES                                                      
                (:BC-LOCAL-OFFICE-ENTRY,                                
                 :BC-BATCH-NO,                                          
                 :BC-CODE-BATCH-STATUS,                                 
                 :BC-LOCAL-OFFICE-SEND,                                 
                 IIF(TRY_CONVERT(DATE, :BC-DATE-BATCH-ENTERED
              ) IS NULL OR (PATINDEX('%.%', :BC-DATE-BATCH-ENTERED
              ) <> 0) OR (LEN(:BC-DATE-BATCH-ENTERED
              ) <> 10), CIS.CHAR2DATE(:BC-DATE-BATCH-ENTERED
              ), CONVERT(DATE, :BC-DATE-BATCH-ENTERED) ),                      
                 IIF(TRY_CONVERT(DATE, :BC-DATE-LAST-ACTIVITY
              ) IS NULL OR (PATINDEX('%.%', :BC-DATE-LAST-ACTIVITY
              ) <> 0) OR (LEN(:BC-DATE-LAST-ACTIVITY
              ) <> 10), CIS.CHAR2DATE(:BC-DATE-LAST-ACTIVITY
              ), CONVERT(DATE, :BC-DATE-LAST-ACTIVITY) ),                      
                 :BC-NO-ITEMS-ENTERED,                                  
                 :BC-AMT-CASH-DEBIT,                                    
                 :BC-AMT-CASH-CREDIT,                                   
                 :BC-AMT-AR-DEBIT,                                      
                 :BC-AMT-AR-CREDIT,                                     
                 :BC-AMT-CK-ISS-DEBIT,                                  
                 :BC-AMT-CK-ISS-CREDIT,                                 
                 :BC-AMT-GL-DEBIT,                                      
                 :BC-AMT-GL-CREDIT,                                     
                 :BC-AMT-NET-BATCH,                                     
                 :BC-NO-ITEMS-POSTED,                                   
                 :BC-AMT-BATCH-DEBITS,                                  
                 :BC-AMT-BATCH-CREDITS,                                 
                 :BC-CASH-COMPANY-NO,                                   
                 IIF(TRY_CONVERT(DATE, :BC-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :BC-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:BC-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:BC-DATE-CASH-REPORT
              ), CONVERT(DATE, :BC-DATE-CASH-REPORT) ),                        
                 :BC-CASH-REPORT-NO,                                    
                 :BC-CASH-LOCAL-OFFICE,                                 
                 :BC-CASH-DRAWER-ID)                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO  CSS_BCH_JRNL_CNTL                                  
MFA-TR*         (LOCAL_OFFICE_ENTRY,                                            
MFA-TR*          BATCH_NO,                                                      
MFA-TR*          CODE_BATCH_STATUS,                                             
MFA-TR*          LOCAL_OFFICE_SEND,                                             
MFA-TR*          DATE_BATCH_ENTERED,                                            
MFA-TR*          DATE_LAST_ACTIVITY,                                            
MFA-TR*          NO_ITEMS_ENTERED,                                              
MFA-TR*          AMT_CASH_DEBIT,                                                
MFA-TR*          AMT_CASH_CREDIT,                                               
MFA-TR*          AMT_AR_DEBIT,                                                  
MFA-TR*          AMT_AR_CREDIT,                                                 
MFA-TR*          AMT_CK_ISS_DEBIT,                                              
MFA-TR*          AMT_CK_ISS_CREDIT,                                             
MFA-TR*          AMT_GL_DEBIT,                                                  
MFA-TR*          AMT_GL_CREDIT,                                                 
MFA-TR*          AMT_NET_BATCH,                                                 
MFA-TR*          NO_ITEMS_POSTED,                                               
MFA-TR*          AMT_BATCH_DEBITS,                                              
MFA-TR*          AMT_BATCH_CREDITS,                                             
MFA-TR*          CASH_COMPANY_NO,                                               
MFA-TR*          DATE_CASH_REPORT,                                              
MFA-TR*          CASH_REPORT_NO,                                                
MFA-TR*          CASH_LOCAL_OFFICE,                                             
MFA-TR*          CASH_DRAWER_ID)                                                
MFA-TR*     VALUES                                                              
MFA-TR*         (:BC-LOCAL-OFFICE-ENTRY,                                        
MFA-TR*          :BC-BATCH-NO,                                                  
MFA-TR*          :BC-CODE-BATCH-STATUS,                                         
MFA-TR*          :BC-LOCAL-OFFICE-SEND,                                         
MFA-TR*          :BC-DATE-BATCH-ENTERED,                                        
MFA-TR*          :BC-DATE-LAST-ACTIVITY,                                        
MFA-TR*          :BC-NO-ITEMS-ENTERED,                                          
MFA-TR*          :BC-AMT-CASH-DEBIT,                                            
MFA-TR*          :BC-AMT-CASH-CREDIT,                                           
MFA-TR*          :BC-AMT-AR-DEBIT,                                              
MFA-TR*          :BC-AMT-AR-CREDIT,                                             
MFA-TR*          :BC-AMT-CK-ISS-DEBIT,                                          
MFA-TR*          :BC-AMT-CK-ISS-CREDIT,                                         
MFA-TR*          :BC-AMT-GL-DEBIT,                                              
MFA-TR*          :BC-AMT-GL-CREDIT,                                             
MFA-TR*          :BC-AMT-NET-BATCH,                                             
MFA-TR*          :BC-NO-ITEMS-POSTED,                                           
MFA-TR*          :BC-AMT-BATCH-DEBITS,                                          
MFA-TR*          :BC-AMT-BATCH-CREDITS,                                         
MFA-TR*          :BC-CASH-COMPANY-NO,                                           
MFA-TR*          :BC-DATE-CASH-REPORT,                                          
MFA-TR*          :BC-CASH-REPORT-NO,                                            
MFA-TR*          :BC-CASH-LOCAL-OFFICE,                                         
MFA-TR*          :BC-CASH-DRAWER-ID)                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE 'BC'                    TO WS-DB2-TABLE-ID          
               MOVE 'INSERT'                TO WS-DB2-FUNCTION          
               MOVE SQLCODE                 TO WS-DB2-RETURN-CODE       
               MOVE '152'                   TO WS-DB2-MODULE-ID         
               MOVE '8200'                  TO WS-DB2-PARAGRAPH         
               MOVE 12                      TO RETURN-CODE              
               PERFORM 9910-SQL-ERROR THRU 9910-EXIT                    
           END-IF.                                                      
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
TESTDS/***************************************************************          
TESTDS*                                                              *          
TESTDS* 8300-WRITE-PAGEOUT         WRITE AN ERROR EMAIL.             *          
TESTDS*                                                              *          
TESTDS****************************************************************          
TESTDS 8300-WRITE-PAGEOUT.                                              
TESTDS                                                                  
TESTDS     OPEN OUTPUT PCS15OUT-FILE.                                   
TESTDS                                                                  
TESTDS     IF PCS152-SUCCESSFUL                                         
TESTDS        NEXT SENTENCE                                             
TESTDS     ELSE                                                         
TESTDS        DISPLAY ' '                                               
TESTDS        DISPLAY '**  PCSCA152 PROCESSING ERROR  **'               
TESTDS        DISPLAY '**    OPEN ERROR OF PCS152OUT REPORT FILE'       
TESTDS        DISPLAY '**    FILE STATUS = ' WS-PCS152OUT-STATUS        
TESTDS        DISPLAY '**  PROCESSING TERMINATED  **'                   
TESTDS        PERFORM 9900-ABEND           THRU 9900-EXIT
           END-IF.              
TESTDS                                                                  
TESTDS     MOVE WS-PASS-JOB TO MAIL2-JOB-NAME,                          
TESTDS                         MAIL5-JOB-NAME,                          
TESTDS                         MAIL7-JOB-NAME.                          
TESTDS     WRITE PCS152OUT-REC FROM MAILHEAD-1.                         
TESTDS     WRITE PCS152OUT-REC FROM MAILHEAD-2.                         
TESTDS     WRITE PCS152OUT-REC FROM MAILHEAD-3.                         
TESTDS     WRITE PCS152OUT-REC FROM MAILHEAD-4.                         
TESTDS     WRITE PCS152OUT-REC FROM MAILHEAD-5.                         
TESTDS     WRITE PCS152OUT-REC FROM MAILHEAD-6.                         
TESTDS     WRITE PCS152OUT-REC FROM MAILHEAD-7.                         
TESTDS     WRITE PCS152OUT-REC FROM MAILHEAD-9.                         
TESTDS     WRITE PCS152OUT-REC FROM MAILHEAD-8.                         
TESTDS     WRITE PCS152OUT-REC FROM MAILHEAD-9.                         
TESTDS                                                                  
TESTDS     INITIALIZE WS02-ERROR-DESC, WS02-ERROR-DETAIL.               
TESTDS                                                                  
TESTDS     MOVE WS-ERR-INDEX            TO  WS-DISP-INVALID-COUNT.      
TESTDS     MOVE WS-FWK03-RECORD-COUNT   TO  WS-DISP-DET-COUNT.          
TESTDS     MOVE WS02-ERROR-ACCTS        TO  WS02-ERROR-DESC.            
TESTDS     MOVE WS-INPUT-DATE           TO  WS02-ERROR-DATE.            
TESTDS     STRING WS-DISP-INVALID-COUNT DELIMITED BY SIZE               
TESTDS            ' OF '                DELIMITED BY SIZE               
TESTDS            WS-DISP-DET-COUNT     DELIMITED BY SIZE               
TESTDS               INTO WS02-ERROR-DETAIL.                            
TESTDS     WRITE PCS152OUT-REC FROM WS02-ERROR-LINE.                    
TESTDS     WRITE PCS152OUT-REC FROM MAILHEAD-9.                         
TESTDS     WRITE PCS152OUT-REC FROM MAILHEAD-9.                         
TESTDS     WRITE PCS152OUT-REC FROM DETAIL-HEAD-LINE1.                  
TESTDS     WRITE PCS152OUT-REC FROM DETAIL-HEAD-LINE2.                  
TESTDS     WRITE PCS152OUT-REC FROM DETAIL-HEAD-LINE3.                  
TESTDS                                                                  
TESTDS     PERFORM VARYING WS-ERR-INDEX FROM 1 BY 1                     
TESTDS       UNTIL WS-ERR-INDEX > 99                                    
TESTDS          OR WS-REC-NO (WS-ERR-INDEX) = ZEROES                    
TESTDS             MOVE WS-REC-NO (WS-ERR-INDEX)                        
TESTDS                                TO  WS-DET-REC-NO                 
TESTDS             MOVE WS-ACCOUNT-NO (WS-ERR-INDEX)                    
TESTDS                                TO  WS-DET-ACCOUNT-NO             
TESTDS             MOVE WS-LOC-OFF (WS-ERR-INDEX)                       
TESTDS                                TO  WS-DET-LOCAL-OFFICE           
TESTDS             MOVE WS-COMP-NO (WS-ERR-INDEX)                       
TESTDS                                TO  WS-DET-COMPANY-NO             
TESTDS             MOVE WS-RCV-DEBIT-AMT (WS-ERR-INDEX)                 
TESTDS                                TO  WS-DET-RCV-DEBIT-AMT          
TESTDS             MOVE WS-RCV-CREDIT-AMT (WS-ERR-INDEX)                
TESTDS                                TO  WS-DET-RCV-CREDIT-AMT         
TESTDS             MOVE WS-CUSTOMER-NO (WS-ERR-INDEX)                   
TESTDS                                TO  WS-DET-CUSTOMER-NO            
TESTDS             WRITE PCS152OUT-REC FROM DETAIL-INFO-LINE            
TESTDS     END-PERFORM.                                                 
TESTDS                                                                  
TESTDS 8300-EXIT.                                                       
TESTDS     EXIT.                                                        
                                                                        
      *                                                                         
T25584 8870-PRINT-COUNTERS.                                             
T25584     DISPLAY ' '.                                                 
T25584     DISPLAY '*****************************************'.         
T25584     DISPLAY '*****   I/O COUNTERS FOR JCSCA152   *****'.         
T25584     DISPLAY '*****************************************'.         
T25584     DISPLAY ' '.                                                 
T25584     DISPLAY '***** TOTAL RF  UPDATE   = '                        
T25584               WS-RESTART-RF-UPD-CNTR-TOT.                        
T25584     DISPLAY '***** TOTAL RF  INSERT   = '                        
T25584               WS-RESTART-RF-ISRT-CNTR-TOT.                       
T25584     DISPLAY ' '.                                                 
T25584     DISPLAY '*****************************************'.         
T25584 8870-EXIT.                                                       
T25584     EXIT.                                                        
T25584                                                                  
T25584 8880-ISSUE-CHKP.                                                 
T25584     MOVE WS-PROCESS-TYPE          TO WS-RESTART-PROCESS-TYPE.    
T25584     ADD 1                         TO WS-CHKP-SEQ-NO.             
T25584     MOVE WS-CHKP-SEQ-NO           TO WS-RESTART-CHKP-SEQ-NO.     
T25584*    MOVE WS-RPT-SAVE-ACCT-NO      TO WS-RESTART-RPT-SAVE-ACCT-NO.        
T25584*    MOVE WS-PRINT-SAVE-ACCT-NO    TO                                     
T25584*                                  WS-RESTART-PRINT-SAVE-ACCT-NO.         
T25584     IF WS-REPOSITION-NEEDED = WS-N                               
T25584       IF WS-PROCESS-TYPE > 1                                     
T25584          MOVE WS-13-NINES         TO WS-RESTART-ACCOUNT-NO       
T25584       ELSE                                                       
T25584************ THIS CHECKPOINT IS THEREFORE THE INITIAL ONE                 
T25584          MOVE ZEROS               TO WS-RESTART-ACCOUNT-NO       
T25584       END-IF                                                     
T25584     ELSE                                                         
T25584        MOVE E-FWK03-ACCT-NO       TO WS-RESTART-ACCOUNT-NO       
T25584     END-IF.                                                      
T25584     PERFORM 8890-MAINTAIN-RESTART THRU 8890-EXIT.                
T25584     EXEC SQL                                                     
T25584         COMMIT                                                   
T25584     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T25584     DISPLAY 'COMMIT POINT # ' WS-CHKP-SEQ-NO ' TAKEN.'           
T25584             'LAST ACCOUNT NO PROCESSED=' WS-RESTART-ACCOUNT-NO.  
T25584 8880-EXIT.                                                       
T25584     EXIT.                                                        
T25584*                                                                         
T25584 8890-MAINTAIN-RESTART.                                           
T25584     MOVE WS-PGRMNAME              TO RF-NAME-PROGRAM.            
T25584     MOVE 1                        TO RF-PARTITION-NO.            
T25584     MOVE 1                        TO RF-DUP-CNTRL-NO.            
T25584     MOVE WS-RESTART-DATA          TO RF-RESTART-DATA-TEXT.       
T25584     MOVE WS-RESTART-DATA-LEN      TO RF-RESTART-DATA-LEN.        
T25584     PERFORM 8910-UPDATE-RESTART   THRU 8910-EXIT.                
T25584     IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
T25584        PERFORM 8911-INSERT-RESTART THRU 8911-EXIT                
T25584     END-IF.                                                      
T25584 8890-EXIT.                                                       
T25584     EXIT.                                                        
                                                                        
T25584*****************************************************************         
T25584*                                                              **         
T25584*   8893-RESET-RESTART-REQ-PARM                                **         
T25584*                                                              **         
T25584*****************************************************************         
T25584     EXEC SQL                                                             
T25584        INCLUDE CPD00029                                                  
T25584     END-EXEC.                                                            
T25584*                                                                         
T25584 8910-UPDATE-RESTART.                                             
T25584     EXEC SQL                                                     
T25584          UPDATE  CSS_RESTART                                     
T25584             SET  RESTART_DATA = :RF-RESTART-DATA                 
T25584           WHERE  NAME_PROGRAM = :RF-NAME-PROGRAM                 
T25584             AND  PARTITION_NO = :RF-PARTITION-NO                 
T25584             AND  DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                 
T25584     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T25584     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
T25584     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T25584        ADD 1                       TO WS-RESTART-RF-UPD-CNTR-TOT 
T25584        ADD 1                       TO WS-RF-UPDATE-CNTR-LUW      
T25584     ELSE                                                         
T25584        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
T25584           NEXT SENTENCE                                          
T25584        ELSE                                                      
T25584           DISPLAY '8910-UPDATE-RESTART'                          
T25584                   ' RETURN CODE=' WS-ACTIVE-RETURN-CODE          
T25584           PERFORM 9900-ABEND         THRU 9900-EXIT              
T25584        END-IF                                                    
T25584     END-IF.                                                      
T25584 8910-EXIT.                                                       
T25584     EXIT.                                                        
T25584/                                                                         
T25584 8911-INSERT-RESTART.                                             
T25584     EXEC SQL                                                     
T25584          INSERT INTO CSS_RESTART                                 
T25584                (NAME_PROGRAM,                                    
T25584                 PARTITION_NO,                                    
T25584                 DUP_CNTRL_NO,                                    
T25584                 RESTART_DATA)                                    
T25584          VALUES                                                  
T25584                (:RF-NAME-PROGRAM,                                
T25584                 :RF-PARTITION-NO,                                
T25584                 :RF-DUP-CNTRL-NO,                                
T25584                 :RF-RESTART-DATA)                                
T25584     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T25584     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
T25584     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T25584        ADD 1                       TO WS-RESTART-RF-ISRT-CNTR-TOT
T25584        ADD 1                       TO WS-RF-INSERT-CNTR-LUW      
T25584     ELSE                                                         
T25584         DISPLAY '8911-INSERT-RESTART'                            
T25584                 ' RETURN CODE=' WS-ACTIVE-RETURN-CODE            
T25584         PERFORM 9900-ABEND         THRU 9900-EXIT                
T25584     END-IF.                                                      
T25584 8911-EXIT.                                                       
T25584     EXIT.                                                        
      *                                                                         
      /*****************************************************************        
      *                                                                *        
      *   9000-TERMINATE                                               *        
      *                                                                *        
      ******************************************************************        
       9000-TERMINATE.                                                  
           CLOSE FCSWK03-FILE.                                          
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
TESTDS/*****************************************************************        
TESTDS*                                                                *        
TESTDS*   9100-DISPLAY-ABEND                                           *        
TESTDS*                                                                *        
TESTDS*   DISPLAY A MESSAGE AND ABEND.                                 *        
TESTDS*                                                                *        
TESTDS******************************************************************        
TESTDS 9100-DISPLAY-ABEND.                                              
TESTDS                                                                  
TESTDS     PERFORM 8300-WRITE-PAGEOUT THRU 8300-EXIT.                   
TESTDS                                                                  
TESTDS     DISPLAY '**                                        **'.      
TESTDS     DISPLAY '**      PCSCA152 PROCESSING ERROR         **'.      
TESTDS     DISPLAY '**                                        **'.      
TESTDS     DISPLAY '**  THRESHOLD OF MORE THAN 100 RECORDS    **'.      
TESTDS     DISPLAY '**  THAT DO NOT NOT CONTAIN ACCOUNT INFO  **'.      
TESTDS     DISPLAY '**  WAS REACHED. PLEASE SEE OUTPUT FILE   **'.      
TESTDS     DISPLAY '**  PCS15OUT.                             **'.      
TESTDS     DISPLAY '**                                        **'.      
TESTDS     DISPLAY '**        PROCESSING TERMINATED           **'.      
TESTDS     DISPLAY '**                                        **'.      
TESTDS     DISPLAY '**                                        **'.      
TESTDS                                                                  
TESTDS     PERFORM 9900-ABEND THRU 9900-EXIT.                           
TESTDS                                                                  
TESTDS 9100-EXIT.                                                       
TESTDS     EXIT.                                                        
                                                                        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
      **                                                              **        
      **    9910-SQL-ERROR                                            **        
      **                                                              **        
      **    SQL ERROR PROCESSING FOR WORK QUEUE                       **        
      **                                                              **        
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
       9910-SQL-ERROR.                                                  
           DISPLAY 'ACCOUNT NO = ' E-FWK03-ACCT-NO.                     
           DISPLAY WS-DATABASE-EXCEPTION.                               
           DISPLAY WS-DB2-PARAGRAPH                                     
           PERFORM 9900-ABEND      THRU 9900-EXIT.                      
       9910-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /*****************************************************************        
      *     9900-ABEND                                                 *55470000
      *                                                                *55480000
      ******************************************************************55500000
       9900-ABEND.                                                      
           PERFORM 9900A-ABEND.                                         
010590     DISPLAY 'PERFORMING 9900-ABEND'.                             
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
SCA003     EXEC SQL
SCA003         ROLLBACK
SCA003     END-EXEC.                                                 

SCA003     CALL "MFASQLCA"
SCA003       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
SCA003       BY REFERENCE MFSQLMESSAGETEXT
SCA003     END-CALL

           MOVE 12  TO  RETURN-CODE.                                    
           STOP RUN.                                                    
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900A-ABEND.                                                     
           EVALUATE ACTIVE-PARAGRAPH                                    
               WHEN '6405'                                              
                   MOVE 'MS'           TO WS-DB2-TABLE-ID               
                   MOVE 'SELECT'       TO WS-DB2-FUNCTION               
                   MOVE SQLCODE        TO WS-DB2-RETURN-CODE            
                   MOVE 'CP7'          TO WS-DB2-MODULE-ID              
                   MOVE '6405'         TO WS-DB2-PARAGRAPH              
                   MOVE 12             TO RETURN-CODE                   
               WHEN '6410'                                              
                   MOVE 'MS'           TO WS-DB2-TABLE-ID               
                   MOVE 'SELECT'       TO WS-DB2-FUNCTION               
                   MOVE SQLCODE        TO WS-DB2-RETURN-CODE            
                   MOVE 'CP7'          TO WS-DB2-MODULE-ID              
                   MOVE '6410'         TO WS-DB2-PARAGRAPH              
                   MOVE 12             TO RETURN-CODE                   
               WHEN '64241'                                             
                   MOVE 'MJ'           TO WS-DB2-TABLE-ID               
                   MOVE 'SELECT'       TO WS-DB2-FUNCTION               
                   MOVE SQLCODE        TO WS-DB2-RETURN-CODE            
                   MOVE 'CP7'          TO WS-DB2-MODULE-ID              
                   MOVE '6424A'        TO WS-DB2-PARAGRAPH              
                   MOVE MJ-DATE-TRAN   TO WS-DB2-KEY-1                  
                   MOVE MJ-CASH-DRAWER-ID                               
                                       TO WS-DB2-KEY-2                  
                   MOVE MJ-LOCAL-OFFICE TO WS-DB2-KEY-3                 
                   MOVE 12             TO RETURN-CODE                   
               WHEN '64242'                                             
                   MOVE 'AT'           TO WS-DB2-TABLE-ID               
                   MOVE 'SELECT'       TO WS-DB2-FUNCTION               
                   MOVE SQLCODE        TO WS-DB2-RETURN-CODE            
                   MOVE 'CP7'          TO WS-DB2-MODULE-ID              
                   MOVE '6424B'        TO WS-DB2-PARAGRAPH              
                   MOVE AT-ACCOUNT-NO  TO WS-DB2-KEY-1N                 
                   MOVE 12             TO RETURN-CODE                   
               WHEN '64243'                                             
                   MOVE 'MJ'           TO WS-DB2-TABLE-ID               
                   MOVE 'INSERT'       TO WS-DB2-FUNCTION               
                   MOVE SQLCODE        TO WS-DB2-RETURN-CODE            
                   MOVE 'CP7'          TO WS-DB2-MODULE-ID              
                   MOVE '6424C'        TO WS-DB2-PARAGRAPH              
                   MOVE 12             TO RETURN-CODE                   
               WHEN '6493'                                              
                   MOVE 'BC'           TO WS-DB2-TABLE-ID               
                   MOVE 'SELECT'       TO WS-DB2-FUNCTION               
                   MOVE SQLCODE        TO WS-DB2-RETURN-CODE            
                   MOVE 'CP7'          TO WS-DB2-MODULE-ID              
                   MOVE '6493'         TO WS-DB2-PARAGRAPH              
                   MOVE BC-CASH-COMPANY-NO   TO WS-DB2-KEY-1            
                   MOVE BC-CASH-LOCAL-OFFICE TO WS-DB2-KEY-2            
                   MOVE BC-CASH-REPORT-NO    TO WS-DB2-KEY-3            
                   MOVE BC-DATE-CASH-REPORT  TO WS-DB2-KEY-4            
                   MOVE 12             TO RETURN-CODE                   
               WHEN '6494'                                              
                   MOVE 'BC'           TO WS-DB2-TABLE-ID               
                   MOVE 'UPDATE'       TO WS-DB2-FUNCTION               
                   MOVE SQLCODE        TO WS-DB2-RETURN-CODE            
                   MOVE 'CP7'          TO WS-DB2-MODULE-ID              
                   MOVE '6494'         TO WS-DB2-PARAGRAPH              
                   MOVE BC-CASH-COMPANY-NO   TO WS-DB2-KEY-1            
                   MOVE BC-CASH-LOCAL-OFFICE TO WS-DB2-KEY-2            
                   MOVE BC-CASH-REPORT-NO    TO WS-DB2-KEY-3            
                   MOVE BC-DATE-CASH-REPORT  TO WS-DB2-KEY-4            
                   MOVE 16             TO RETURN-CODE                   
               WHEN '6495'                                              
                   MOVE 'BC'           TO WS-DB2-TABLE-ID               
                   MOVE 'UPDATE'       TO WS-DB2-FUNCTION               
                   MOVE SQLCODE        TO WS-DB2-RETURN-CODE            
                   MOVE 'CP7'          TO WS-DB2-MODULE-ID              
                   MOVE '6495'         TO WS-DB2-PARAGRAPH              
                   MOVE BC-CASH-COMPANY-NO   TO WS-DB2-KEY-1            
                   MOVE BC-CASH-LOCAL-OFFICE TO WS-DB2-KEY-2            
                   MOVE BC-CASH-REPORT-NO    TO WS-DB2-KEY-3            
                   MOVE BC-DATE-CASH-REPORT  TO WS-DB2-KEY-4            
                   MOVE 16             TO RETURN-CODE                   
               WHEN '6496'                                              
                   MOVE 'BC'           TO WS-DB2-TABLE-ID               
                   MOVE 'INSERT'       TO WS-DB2-FUNCTION               
                   MOVE SQLCODE        TO WS-DB2-RETURN-CODE            
                   MOVE 'CP7'          TO WS-DB2-MODULE-ID              
                   MOVE '6496'         TO WS-DB2-PARAGRAPH              
                   MOVE 12             TO RETURN-CODE                   
           END-EVALUATE.                                                
       9900A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      *                                                                         
