       IDENTIFICATION  DIVISION.                                        
       PROGRAM-ID.     PCSCA150.                                        
       DATE-WRITTEN.   FEB 2002.                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC AND GAS                **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **                  CUSTOMER INFORMATION SYSTEM                **         
      *****************************************************************         
      **                  P R O G R A M S U M M A R Y                **         
      **                                                             **         
      **             F U N C T I O N A L   D E S C R I P T I O N     **         
      **                             O F   M O D U LE                **         
      **  PURPOSE :                                                  **         
      **                                                             **         
      **  THIS PROGRAM SENDS A WQ WHEN A SEB REGULATED ACCOUNT NEEDS **         
      **  TO BE CHANGED TO A DIFFERENT GROUP.                        **         
      **                                                             **         
      **  1) A GROUP 1 ACCOUNT IN WHICH THE DHR HAS EXPIRED NEEDS    **         
      **     TO BE CHANGED TO GROUP 2.                               **         
C30175**     WILL NO LONGER SEND THIS WQ.                            **         
      **                                                             **         
      **  2) A GROUP 2 ACCOUNT WITH A 0 BALANCE AND DHR CERTIFICATION**         
      **     NEEDS TO BE CHANGED TO GROUP 1.                         **         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **   DATE       INITIALS   REASON                              **         
      **   ________   ________   ______                              **         
C26954**   07/23/02   SFH        PROGRAM WRITTEN.                    **         
C27678**   09/30/02   SFH        WQ'S SHOULD BE GENERATED ONLY ON    **         
      **                         ACTIVE AND PENDING ACCOUNTS.        **         
T27821**   06/05/03   JDW        WHEN WQ FOR CATEGORY 243 IS         **         
T27821**                         PROCESSED, ACCOUNT SHOULD BE HELD.  **         
C28788**   07/03/03   MDJ        GET IVR-EXEMPT-CD FOR CPD00068.     **         
C30175**   05/24/2005 MJ13662    STOP GENERATING WQ W/ CATEGORY ID = **         
C30175**                         242.                                **         
      **                                                             **         
35273 **   11 DEC 2007 RF10596   CHANGE THE CREATION OF WQ 243 TO    **         
      **                         ONLY PULL ACTIVE ACCOUNTS WITH THE  **         
      **                         BILL CYCLE THAT IS OPENING ON BILL  **         
      **                         WINDOW 'X' BUSINESS DAYS INTO THE   **         
      **                         FUTURE.  WHERE 'X' IS A VALUE ON    **         
      **                         THE DELINQUENCY TABLE.              **         
      **                         ALSO, IF THERE IS ALREADY A 243 ON  **         
      **                         WQ ITEMS WITH A STATUS OF (A,I,P),  **         
      **                         DO NOT CREATE A NEW ONE.            **         
      **                         ADD CSS_DHR_HIST TO THE MAIN CURSOR **         
      **                         TO GET ONLY DHR ACCOUNTS.           **         
      **                         CURRENTLY CYCLES 20 AND 21 OPEN ON  **         
      **                         THE SAME DAY, SO THEY ARE COMBINED. **         
      **                         IF IN THE FUTURE THEY OPEN ON       **         
      **                         DIFFERENT DAYS, THIS PROGRAM WILL   **         
      **                         NEED TO BE CHANGED.                 **         
      **                         AN OFF CYCLE SITUATION CAUSES NO    **         
      **                         ACCOUNTS TO BE PULLED AND A DISPLAY **         
      **                         IS CREATED.                         **         
      **                                                             **         
T35434**   16 APR 2008 MC95456   ADDED WITH UR TO SELECT STATEMENTS  **         
T35434**                         TO AVOID -911 ABENDS                **         
CSR501**   11 DEC 2008 MJ13662   FOR PERFORMANCE, REMOVED THE FLAG   **         
CSR501**                         TO CALCULATE DNP BALANCE FOR IT IS  **         
CSR501**                         NOT BEING USED.                     **         
P00172**   10 JUN 2009 CVNS      1. DHR INFORMATION HAS BEEN MOVED TO**         
P00172**               CHENNAI      THE CUSTOMER LEVEL AND THE TABLE **         
P00172**                            CSS_DHR_HIST GOT DELETED.A NEW   **         
P00172**                            COLUMN IN CSS_CUSTOMER NAMED     **         
P00172**                            DHR_FL IS USED TO INDICATE THE   **         
P00172**                            PRESENCE OF DHR INFORMATION ON   **         
P00172**                            AN ACCOUNT.                      **         
P00172**                         2. REMOVED CPD00067 COPYBOOK        **         
P00172**                            REFERENCE SINCE IT IS NOT USED.  **         
A02109**   29 JAN 2010 MJ13662   CONTINUE GENERATING THE GROUP 2 TO             
A02109**                         GROUP 1 WQ IF FULL BALANCE < 0 AND:            
A02109**                         1. NO OTHER ACCOUNT IS FOUND.                  
A02109**                         2. ALL OTHER ACCOUNTS FOUND HAVE               
A02109**                         BALANCE <= AMT-ACCT-BALN-MOVMNT - VALUE        
A02109**                         ON CSS_DELINQUENCY.                            
A02109**                         3. OTHER ACCOUNT FOUND IS BANKRUPT.            
A02109**                         4. ALL OTHER ACCOUNTS ARE BANKRUPT.            
A02109**                         IF THE WQ IS NOT GENERATED, WRITE              
A02109**                         CUSTOMER COMMUNICATION ROW.                    
A02109**                                                                        
A04860**  12/10/14 AS7C117       REPLACE CSS_WQ_ITEMS_MF WITH        *          
A04860**           ACT049        CSS_WQ_ITEMS.                       *          
      *****************************************************************         
           REMARKS.                                                     
             AS ABOVE.                                                  
                     - BASIC BATCH SEQUENCE STRUCTURE -                 
                    0000 - 0000     MAIN CONTROL PATH                   
                    0100 - 0100     INITIALIZATION                      
                    1000 - 1000     MAJOR PROCESSING LOOP               
                    1100 - 4999     PERFORMED PARAGRAPHS OF MAJOR       
                                    PROCESSING LOOPS                    
                    5000 - 5999     COMMON PROGRAM MODULES              
                    6000 - 6999     COMMON SYSTEM MODULES               
                    7000 - 7999     INPUT MODULES                       
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9799     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
      *                                                                         
HPCCDM*EJECT                                                                    
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
      *                                                                         
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA150'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-MISC.                                                     
      *                                                                         
           05 WS-START                       PIC X(40) VALUE            
           'WORKING STORAGE FOR PCSCA150 STARTS HERE'.                  
      *                                                                         
35273      05  WS-YES                        PIC X VALUE 'Y'.           
35273      05  WS-NO                         PIC X VALUE 'N'.           
           05  PROGRAM-NAME                  PIC X(8) VALUE 'PCSCA150'. 
           05  WS-PGRMNAME                   PIC X(8) VALUE 'PCSCA150'. 
A04860     05  SCSCB077                      PIC X(8) VALUE 'SCSCB077'. 
A04860     05  WS-CREATED-TS.                                           
A04860         10 WS-CRE-DATE-PT PIC   X(10).                           
A04860         10 WS-CRE-TIME-PT PIC   X(16) VALUE '-00.00.00.000000'.  
      *                                                                         
           05  WS-TRAN-APPL-NO               PIC S9(4) COMP VALUE ZERO. 
COB305     05 WS-ORIGINAL-ACCOUNT        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.  
A02109     05  WS-ORIGINAL-LOCAL-OFFICE      PIC X(03) VALUE SPACES.    
A02109     05  WS-SPEC-COMM-TYPE-CD          PIC X(02) VALUE '44'.      
A02109     05  WS-GRP-COMM-SUBTYPE-CODE      PIC X(02) VALUE '11'.      
A02109     05  WS-COMM-TYPE-CD               PIC X(02) VALUE SPACES.    
A02109     05  WS-COMM-SUBTYPE-CODE          PIC X(02) VALUE SPACES.    
A02109     05  WS-RED-FL-NULL-IND            PIC S9(4) COMP  VALUE 0.   
A02109     05  WS-END-NULL-IND               PIC S9(4) COMP  VALUE 0.   
           05  WS-CURRENT-DT-PLUS1           PIC X(10).                 
           05  WS-CURRENT-DATE               PIC X(10).                 
           05  WS-RECS-TO-COMMIT-COUNT       PIC 9(3)  VALUE ZEROES.    
           05  WS-WQ-EXISTS                  PIC X(01)   VALUE 'N'.     
      *                                                                         
           05  WS-INPUT-DATE-BREAKUP.                                   
               10  WS-BRKUP-DATE-CC          PIC X(02).                 
               10  WS-BRKUP-DATE-YY          PIC X(02).                 
               10  FILLER                    PIC X(01).                 
               10  WS-BRKUP-DATE-MM          PIC X(02).                 
               10  FILLER                    PIC X(01).                 
               10  WS-BRKUP-DATE-DD          PIC X(02).                 
      *                                                                         
           05  WS-DATE-CALC                  PIC X(10).                 
           05  SCSCB068                      PIC X(8) VALUE 'SCSCB068'. 
           05  WS-HOLD-INPUT-DATE            PIC X(10) VALUE SPACES.    
           05  WS-N                          PIC X(01) VALUE 'N'.       
           05  WS-Y                          PIC X(01) VALUE 'Y'.       
      *                                                                         
           05  WS-SWITCHES.                                             
      *                                                                         
               10  WS-ROW-EXISTS             PIC X(01) VALUE 'N'.       
                   88  ROW-DOES-NOT-EXIST              VALUE 'N'.       
                   88  ROW-EXISTS                      VALUE 'Y'.       
      *                                                                         
               10  WS-MORE-DATA-EXISTS       PIC X(01) VALUE 'Y'.       
                   88  NO-MORE-DATA-EXISTS             VALUE 'N'.       
                   88  MORE-DATA-EXISTS                VALUE 'Y'.       
A02109*                                                                         
A02109         10  WS-OTHER-ACCTS-EXIST      PIC X(01) VALUE 'Y'.       
A02109             88  NO-MORE-ACCOUNTS-EXIST          VALUE 'N'.       
A02109             88  MORE-ACCOUNTS-EXIST             VALUE 'Y'.       
A02109*                                                                         
A02109         10  WS-ACCT-WITH-BAL-EXISTS   PIC X(01) VALUE 'N'.       
A02109             88  NO-ACCT-WITH-BAL-EXISTS         VALUE 'N'.       
A02109             88  ACCT-WITH-BAL-EXISTS            VALUE 'Y'.       
           05  WS-ERROR-VARIABLES.                                      
               10  RS-RETURN-CODE            PIC S9(04) COMP.           
               10  RS-RETURN-CODE-DISP       PIC +Z(04).                
               10  WS-DISP-RETURN-CODE       PIC +Z(04).                
      *                                                                         
35273  01  WS-1ST-CYCLE            PIC XX.                              
35273  01  WS-2ND-CYCLE            PIC XX.                              
35273  01  WS-WORK-DATE            PIC X(10).                           
35273  01  WS-CYCLE-DATE           PIC X(10).                           
35273  01  WS-DATE-SUB             PIC S9(3) COMP-3 VALUE 0.            
A02109 01  WS-DELINQ-FIELDS.                                            
35273      05  WS-DEL-VALUE              PIC S9(3) COMP-3 VALUE 0.      
35273      05  WS-DAYS-DELINQ-CD         PIC X(20)                      
35273          VALUE 'DAY-243WQ-PCSCA150'.                              
A02109     05  WS-AMT-ACCT-BALN-VALUE     PIC S9(4)V99999.              
A02109     05  WS-AMT-ACCT-BALN-CD        PIC X(20)                     
A02109         VALUE 'AMT-ACCT-BALN-MOVMNT'.                            
      *                                                                         
       01  WS-COMMENTS.                                                 
           05 WS-COMMENTS-LEN            PIC S9(4) USAGE COMP.          
           05 WS-COMMENTS-TEXT           PIC X(250).                    
           05 WS-WQ-CATEGORY             PIC 9(04) VALUE ZERO.          
      *                                                                         
       01  WS-COMMENTS-LITERALS.                                        
           05 WS-COMMENTS-200.                                          
              10 WS-COMMENTS-200A        PIC X(54) VALUE                
              'CUSTOMER IS SCHEDULED TO MOVE BACK TO GROUP 1 BECAUSE '. 
              10 WS-COMMENTS-200B        PIC X(52) VALUE                
              'FULL BALANCE HAS BEEN PAID. ANY ADDITIONAL DEPOSITS '.   
              10 WS-COMMENTS-200C        PIC X(53) VALUE                
              'THAT MAY HAVE BEEN BILLED AS A RESULT OF MOVEMENT TO '.  
              10 WS-COMMENTS-200D        PIC X(51) VALUE                
              'GROUP 2 ARE NOT ELIGIBLE FOR A REFUND AT THIS TIME.'.    
T27821        10 WS-COMMENTS-200E        PIC X(35) VALUE                
T27821        'THIS WQ HAS PUT THE ACCOUNT ON HOLD'.                    
                                                                        
A02109     05  WS-BANKRUPT-COMMENTS      PIC X(47) VALUE                
A02109         'ACCOUNT NOT MOVED TO GROUP 1 DUE TO BANKRUPTCY.'.       
                                                                        
A02109     05  WS-ACCOUNT-COMMENTS.                                     
A02109         10  FILLER                PIC X(53) VALUE                
A02109         'ACCOUNT NOT MOVED TO GROUP 1 DUE TO BALANCE ON OTHER '. 
A02109         10 FILLER                 PIC X(11) VALUE                
A02109         'ACCOUNT(S).'.                                           
      *                                                                         
      ****************************************************************          
      *  COPYBOOK CONTAINING COMMON ABEND SWITCH                     *          
      ****************************************************************          
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
      ****************************************************************          
      *  COPYBOOK FOR COMMON ABEND WORKING STORAGE VARIABLES         *          
      ****************************************************************          
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
      ****************************************************************          
      *  COPYBOOK FOR VARIABLES TO ACCESS CSS_JOB_PARM               *          
      ****************************************************************          
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
      ****************************************************************          
      *  COPYBOOK FOR VARIABLES TO RETRIEVE COMMONDATE FROM JOB PARM *          
      ****************************************************************          
      *                                                                         
       COPY CWS00039.                                                           
       COPY FIOCA00.                                                            
       COPY FIOJC01.                                                            
      *                                                                         
      ****************************************************************          
      *  COPYBOOK WITH COMMON SQL VARIABLES                          *          
      ****************************************************************          
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
      ****************************************************************          
      *  COPYBOOK WITH CODES DATA PRESENT VALUES                     *          
      ****************************************************************          
      *                                                                         
       COPY CWS00056.                                                           
      *                                                                         
      ****************************************************************          
      *  COPYBOOK WITH VARIABLES USED BY CPD00068                    *          
      ****************************************************************          
      *                                                                         
            EXEC SQL                                                            
              INCLUDE CWS00068                                                  
            END-EXEC.                                                           
      *                                                                         
35273 ****************************************************************          
35273 *  COPYBOOK WITH VARIABLES USED BY CPD00315                    *          
35273 ****************************************************************          
      *                                                                         
35273       EXEC SQL                                                            
35273         INCLUDE CWS00315                                                  
35273       END-EXEC.                                                           
      *                                                                         
      ****************************************************************          
      *   THIS INCLUDES THE DB2 SYTEM ABEND RECORD LAYOUT            *          
      ****************************************************************          
      *                                                                         
            EXEC SQL                                                            
              INCLUDE SQLCA                                                     
            END-EXEC.                                                           
      *                                                                         
      ***************************************************************           
      *   DCLGEN COPYBOOK FOR CSS_JOB_PARM G6                       *           
      ***************************************************************           
      *                                                                         
            EXEC SQL                                                            
              INCLUDE TBJBPARM                                                  
            END-EXEC.                                                           
      *                                                                         
      ***************************************************************           
      *   DCLGEN COPYBOOK FOR CSS_ACCOUNT AT                        *           
      ***************************************************************           
      *                                                                         
            EXEC SQL                                                            
              INCLUDE TBACCT                                                    
            END-EXEC.                                                           
      *                                                                         
      ***************************************************************           
      *   DCLGEN COPYBOOK FOR CSS_DELINQUENCY C8                    *           
      ***************************************************************           
      *                                                                         
            EXEC SQL                                                            
              INCLUDE TBDELQ                                                    
            END-EXEC.                                                           
      *                                                                         
      ***************************************************************           
      *   DCLGEN COPYBOOK FOR CSS_HOLIDAY J8                        *           
      ***************************************************************           
      *                                                                         
            EXEC SQL                                                            
              INCLUDE TBHLDAY                                                   
            END-EXEC.                                                           
      *                                                                         
      ***************************************************************           
      *   DCLGEN COPYBOOK FOR CSS_REG_PROFILE LR                    *           
      ***************************************************************           
           EXEC SQL                                                             
              INCLUDE TBREGPRF                                                  
           END-EXEC.                                                            
      *                                                                         
P00171***************************************************************           
P00172*   DCLGEN COPYBOOK FOR CSS_CUSTOMER CU                       *           
P00172***************************************************************           
      *                                                                         
P00172     EXEC SQL                                                             
P00172        INCLUDE TBCUST                                                    
P00172     END-EXEC.                                                            
      *                                                                         
35273 ***************************************************************           
35273 *   DCLGEN COPYBOOK FOR CSS_BILL_WINDOW BN                    *           
35273 ***************************************************************           
      *                                                                         
35273      EXEC SQL                                                             
35273         INCLUDE TBBILWDW                                                  
35273      END-EXEC.                                                            
      *                                                                         
35273 ***************************************************************           
35273 *   DCLGEN COPYBOOK FOR CSS_WQ_ITEMS WQ                       *           
35273 ***************************************************************           
      *                                                                         
35273      EXEC SQL                                                             
35273         INCLUDE TBWQITS                                                   
35273      END-EXEC.                                                            
      *                                                                         
A02109***************************************************************           
A02109*   DCLGEN COPYBOOK FOR CSS_COMM_DATA  KO                     *           
A02109***************************************************************           
A02109                                                                  
A02109     EXEC SQL                                                             
A02109        INCLUDE TBCOMDAT                                                  
A02109     END-EXEC.                                                            
A04860*                                                                         
A04860/****** FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077             
A04860      EXEC SQL                                                            
A04860           INCLUDE CWS00077                                               
A04860      END-EXEC.                                                           
A04860*                                                                         
A02109*                                                                         
      ***************************************************************           
35273 * RETRIEVES ACTIVE GROUP 2 ACCOUNTS THAT HAVE AN ENTRY ON     *           
35273 * THE DHR_HIST TABLE AND THAT DO NOT HAVE A 243 WQ WITH A     *           
35273 * STATUS = (A,I,P).  THE ACCOUNT ALSO MUST BE FOR THE BILL    *           
35273 * CYCLE THAT IS DETERMINED USING CURRENT DATE AND A VALUE ON  *           
35273 * THE DELINQUENCY TABLE.                                      *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                     
                DECLARE GROUP_CURSOR CURSOR WITH HOLD FOR               
                 SELECT LR.CUSTOMER_NO                                  
                       ,LR.PREMISE_NO                                   
                       ,LR.REG_GROUP_CD                                 
                       ,AT.ACCOUNT_NO                                   
                       ,AT.COMPANY_NO                                   
                       ,AT.LOCAL_OFFICE                                 
                       ,AT.CODES_DATA_PRESENT                           
                       ,AT.NOTICE_EXEMPT_CD                             
                       ,AT.CODE_DISC_OK                                 
                       ,AT.DATE_BILL_DAY_00                             
                       ,AT.DATE_BILL_DAY_30                             
                       ,AT.DATE_BILL_DAY_60                             
                       ,AT.DATE_BILL_DAY_90                             
                       ,AT.BANKRUPTCY_IND                               
                       ,AT.CREDIT_GROUP                                 
                       ,AT.CODE_ACCT_STAT                               
C28788                 ,AT.IVR_EXEMPT_CD                                
                   FROM CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                
                       ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                  WHERE LR.ACCOUNT_NO = AT.ACCOUNT_NO                   
35273               AND AT.CODE_ACCT_STAT = 'A'                         
35273               AND AT.BILL_CYCLE                                   
35273                   BETWEEN :WS-1ST-CYCLE                           
35273                   AND     :WS-2ND-CYCLE                           
C30175              AND LR.REG_GROUP_CD   = '200'                       
35273               AND ( EXISTS                                        
35273                 (SELECT *                                         
P00172             FROM  CSS_CUSTOMER CU WITH(READUNCOMMITTED)                  
P00172            WHERE AT.CUSTOMER_NO = CU.CUSTOMER_NO                 
P00172              AND CU.DHR_FL      = 'Y'))                          
35273               AND ( NOT EXISTS                                    
35273                 (SELECT *                                         
35273              FROM  CSS_WQ_ITEMS WQ WITH(READUNCOMMITTED)                  
35273             WHERE AT.ACCOUNT_NO  = WQ.ACCOUNT_NO                  
35273               AND WQ.STATUS IN ('A', 'I', 'P')                    
35273               AND WQ.CATEGORY_ID = :WQ-CATEGORY-ID))              
T35434            FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE GROUP_CURSOR CURSOR WITH HOLD FOR                       
MFA-TR*          SELECT LR.CUSTOMER_NO                                          
MFA-TR*                ,LR.PREMISE_NO                                           
MFA-TR*                ,LR.REG_GROUP_CD                                         
MFA-TR*                ,AT.ACCOUNT_NO                                           
MFA-TR*                ,AT.COMPANY_NO                                           
MFA-TR*                ,AT.LOCAL_OFFICE                                         
MFA-TR*                ,AT.CODES_DATA_PRESENT                                   
MFA-TR*                ,AT.NOTICE_EXEMPT_CD                                     
MFA-TR*                ,AT.CODE_DISC_OK                                         
MFA-TR*                ,AT.DATE_BILL_DAY_00                                     
MFA-TR*                ,AT.DATE_BILL_DAY_30                                     
MFA-TR*                ,AT.DATE_BILL_DAY_60                                     
MFA-TR*                ,AT.DATE_BILL_DAY_90                                     
MFA-TR*                ,AT.BANKRUPTCY_IND                                       
MFA-TR*                ,AT.CREDIT_GROUP                                         
MFA-TR*                ,AT.CODE_ACCT_STAT                                       
MFA-TR*                ,AT.IVR_EXEMPT_CD                                        
MFA-TR*            FROM CSS_REG_PROFILE LR                                      
MFA-TR*                ,CSS_ACCOUNT AT                                          
MFA-TR*           WHERE LR.ACCOUNT_NO = AT.ACCOUNT_NO                           
MFA-TR*             AND AT.CODE_ACCT_STAT = 'A'                                 
MFA-TR*             AND AT.BILL_CYCLE                                           
MFA-TR*                 BETWEEN :WS-1ST-CYCLE                                   
MFA-TR*                 AND     :WS-2ND-CYCLE                                   
MFA-TR*             AND LR.REG_GROUP_CD   = '200'                               
MFA-TR*             AND ( EXISTS                                                
MFA-TR*               (SELECT *                                                 
MFA-TR*            FROM  CSS_CUSTOMER CU                                        
MFA-TR*           WHERE AT.CUSTOMER_NO = CU.CUSTOMER_NO                         
MFA-TR*             AND CU.DHR_FL      = 'Y'))                                  
MFA-TR*             AND ( NOT EXISTS                                            
MFA-TR*               (SELECT *                                                 
MFA-TR*            FROM  CSS_WQ_ITEMS WQ                                        
MFA-TR*           WHERE AT.ACCOUNT_NO  = WQ.ACCOUNT_NO                          
MFA-TR*             AND WQ.STATUS IN ('A', 'I', 'P')                            
MFA-TR*             AND WQ.CATEGORY_ID = :WQ-CATEGORY-ID))                      
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                            
A02109***************************************************************           
A02109* RETRIEVES ACCOUNTS LINKED TO CUSTOMERS SELECTED IN          *           
A02109* GROUP_CURSOR.                                               *           
A02109***************************************************************           
A02109     EXEC SQL                                                     
A02109          DECLARE OTHER_CURSOR CURSOR WITH HOLD FOR               
A02109           SELECT AT.ACCOUNT_NO                                   
A02109                 ,AT.LOCAL_OFFICE                                 
A02109                 ,AT.CODES_DATA_PRESENT                           
A02109                 ,AT.DATE_BILL_DAY_00                             
A02109                 ,AT.DATE_BILL_DAY_30                             
A02109                 ,AT.DATE_BILL_DAY_60                             
A02109                 ,AT.DATE_BILL_DAY_90                             
A02109                 ,AT.CREDIT_GROUP                                 
A02109                 ,AT.CODE_ACCT_STAT                               
A02109             FROM CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                
A02109                 ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
A02109            WHERE LR.ACCOUNT_NO     = AT.ACCOUNT_NO               
A02109              AND LR.REG_GROUP_CD   IN ('100', '200')             
A02109              AND AT.CUSTOMER_NO    = :LR-CUSTOMER-NO             
A02109              AND AT.ACCOUNT_NO    <> :AT-ACCOUNT-NO              
A02109              AND AT.COMPANY_NO     = '01'                        
A02109              AND AT.BANKRUPTCY_IND = ' '                         
A02109              AND AT.CODE_ACCT_STAT IN ('A', 'B', 'S')            
A02109            FOR READ ONLY                                 
A02109     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE OTHER_CURSOR CURSOR WITH HOLD FOR                       
MFA-TR*          SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,AT.LOCAL_OFFICE                                         
MFA-TR*                ,AT.CODES_DATA_PRESENT                                   
MFA-TR*                ,AT.DATE_BILL_DAY_00                                     
MFA-TR*                ,AT.DATE_BILL_DAY_30                                     
MFA-TR*                ,AT.DATE_BILL_DAY_60                                     
MFA-TR*                ,AT.DATE_BILL_DAY_90                                     
MFA-TR*                ,AT.CREDIT_GROUP                                         
MFA-TR*                ,AT.CODE_ACCT_STAT                                       
MFA-TR*            FROM CSS_REG_PROFILE LR                                      
MFA-TR*                ,CSS_ACCOUNT AT                                          
MFA-TR*           WHERE LR.ACCOUNT_NO     = AT.ACCOUNT_NO                       
MFA-TR*             AND LR.REG_GROUP_CD   IN ('100', '200')                     
MFA-TR*             AND AT.CUSTOMER_NO    = :LR-CUSTOMER-NO                     
MFA-TR*             AND AT.ACCOUNT_NO    = :AT-ACCOUNT-NO                      
MFA-TR*             AND AT.COMPANY_NO     = '01'                                
MFA-TR*             AND AT.BANKRUPTCY_IND = ' '                                 
MFA-TR*             AND AT.CODE_ACCT_STAT IN ('A', 'B', 'S')                    
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       01  WS-END                          PIC X(40) VALUE              
           'WORKING STORAGE FOR PCSCA150 ENDS HERE  '.                  
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      *     CONTROLS THE MAIN PROCESSING PATH OF THE PROGRAM           *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
      *                                                                         
35273      IF WS-1ST-CYCLE = '00' AND WS-2ND-CYCLE = '00'               
35273         DISPLAY '**************************************'          
35273         DISPLAY '**  CURRENT DATE + DELINQUENCY CODE **'          
35273         DISPLAY '**  RESULTED IN AN EXTRACT DATE ON  **'          
35273         DISPLAY '**  BILL WINDOW THAT IS PROBABLY AN **'          
35273         DISPLAY '**  OFF CYCLE SITUATION.  THEREFORE **'          
35273         DISPLAY '**  NO ACCOUNTS ARE BEING PROCESSED **'          
35273         DISPLAY '**  IN TODAYS RUN.                  **'          
35273         DISPLAY '**  CURRENT DATE = ' WS-CURRENT-DATE             
35273         DISPLAY '**  DELINQUENCY  = ' WS-DEL-VALUE                
35273         DISPLAY '**  BN-DATE-EXTRACT = ' BN-DATE-EXTRACT          
35273         DISPLAY '**************************************'          
35273      ELSE                                                         
      *                                                                         
              PERFORM 7000-OPEN-GROUP-CURSOR  THRU 7000-EXIT            
              PERFORM 7010-FETCH-GROUP-CURSOR THRU 7010-EXIT            
      *                                                                         
              PERFORM 1000-PROCESS-GROUP-CURSOR THRU 1000-EXIT          
                UNTIL NO-MORE-DATA-EXISTS                               
      *                                                                         
              PERFORM 7020-CLOSE-GROUP-CURSOR THRU 7020-EXIT            
35273      END-IF.                                                      
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * RETRIEVES COMMON DATE, CALCULATES BUSINESS DATE FROM CURRENT  *         
      * USING A VALUE FROM THE DELINQUENCY TABLE.                     *         
      * OPENS DRIVING CURSOR, PERFORMS FIRST FETCH, ETC.              *         
      *****************************************************************         
       0100-INITIALIZATION.                                             
      *                                                                         
           MOVE '0100' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           MOVE PROGRAM-NAME TO ABEND-PROGRAM.                          
      *                                                                         
A04860     INITIALIZE CWS00077-FIELDS.                                  
                                                                        
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
           IF COMMON-DATE-NEEDED                                        
               PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT        
               MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE-BREAKUP       
           ELSE                                                         
               MOVE WS-INPUT-DATE TO WS-INPUT-DATE-BREAKUP              
           END-IF.                                                      
      *                                                                         
           MOVE WS-INPUT-DATE-BREAKUP TO WS-CURRENT-DATE.               
      *                                                                         
35273 * GET THE NUMBER OF BUSINESS DAYS TO BE USED FOR THE CALCULATION          
35273 * FROM THE DELINQUENCY TABLE.                                             
      *                                                                         
35273      MOVE '01'              TO C8-COMPANY-NO.                     
35273      MOVE WS-DAYS-DELINQ-CD TO C8-DELINQ-CD.                      
35273      PERFORM 7040-SELECT-DELINQ-VALUE THRU 7040-EXIT.             
35273      MOVE C8-DELINQ-VALUE   TO WS-DEL-VALUE.                      
      *                                                                         
A02109* GET THE MINIMUM AMOUNT THAT THE OTHER ACCOUNT'S BALANCE MUST BE         
A02109* > THAN IN ORDER FOR THE CUSTOMER COMMUNICATION TO BE CREATED            
A02109* INSTEAD OF THE WQ.                                                      
A02109*                                                                         
A02109     MOVE WS-AMT-ACCT-BALN-CD TO C8-DELINQ-CD.                    
A02109     PERFORM 7040-SELECT-DELINQ-VALUE THRU 7040-EXIT.             
A02109     MOVE C8-DELINQ-VALUE     TO WS-AMT-ACCT-BALN-VALUE.          
                                                                        
35273      MOVE WS-CURRENT-DATE   TO WS-NEW-BUSINESS-DAY.               
35273      MOVE 1 TO WS-DATE-SUB.                                       
35273      MOVE 'N' TO WS-NEXT-BUSINESS-DAY.                            
      *                                                                         
35273      PERFORM UNTIL WS-DATE-SUB > WS-DEL-VALUE                     
35273         PERFORM 6500-GET-NEXT-BUSINESS-DAY THRU                   
35273                          6500-NEXT-BUSINESS-DAY-EXIT              
35273                    UNTIL NEXT-BUSINESS-DAY-FOUND                  
35273         IF WS-NEXT-BUSINESS-DAY = 'Y'                             
35273            IF WS-DATE-SUB = 1                                     
35273               MOVE WS-NEW-BUSINESS-DAY TO WS-CURRENT-DT-PLUS1     
35273            END-IF                                                 
35273            ADD 1 TO WS-DATE-SUB                                   
35273         END-IF                                                    
35273         MOVE 'N' TO WS-NEXT-BUSINESS-DAY                          
35273      END-PERFORM.                                                 
      *                                                                         
35273      MOVE WS-NEW-BUSINESS-DAY TO BN-DATE-EXTRACT.                 
      *                                                                         
35273      PERFORM 7050-BILL-WINDOW THRU 7050-EXIT.                     
      *                                                                         
35273      IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR -305                 
35273         MOVE '00'          TO WS-1ST-CYCLE                        
35273                               WS-2ND-CYCLE                        
35273      ELSE                                                         
35273         IF BN-BILL-CYCLE = '21'                                   
35273            MOVE '20'          TO WS-1ST-CYCLE                     
35273            MOVE BN-BILL-CYCLE TO WS-2ND-CYCLE                     
35273         ELSE                                                      
35273            MOVE BN-BILL-CYCLE TO WS-1ST-CYCLE                     
35273                                  WS-2ND-CYCLE                     
35273         END-IF                                                    
35273      END-IF.                                                      
      *                                                                         
35273      DISPLAY '**********************************'.                
35273      DISPLAY '** 0100-INITIALIZATION PARAGRAPH '.                 
35273      DISPLAY '** CURRENT DATE        = ' WS-CURRENT-DATE.         
35273      DISPLAY '** WS-NEW-BUSINESS-DAY = ' WS-NEW-BUSINESS-DAY.     
35273      DISPLAY '** WS-DEL-VALUE        = ' WS-DEL-VALUE.            
35273      DISPLAY '** BN-BILL-CYCLE       = ' BN-BILL-CYCLE.           
35273      DISPLAY '** WS-1ST-CYCLE        = ' WS-1ST-CYCLE.            
35273      DISPLAY '** WS-2ND-CYCLE        = ' WS-2ND-CYCLE.            
35273      DISPLAY '**********************************'.                
      *                                                                         
35273      MOVE WS-WQ-CATEGORY TO WQ-CATEGORY-ID.                       
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *   LOOPING MODULE TO PROCESS RECORDS UNTIL THE CURSOR RETURNS  *         
      *   A NOT-FOUND CONDITION (NO-MORE-DATA-EXISTS)                 *         
      *****************************************************************         
       1000-PROCESS-GROUP-CURSOR.                                       
      *                                                                         
           INITIALIZE WS-COMMENTS.                                      
      *    ************************************************************         
      *    *  GROUP 2 CUSTOMERS NEED TO BE SWITCHED TO GROUP 1.      **         
      *    *  WQ CATEGORY 243 (FULL BALANCE PAID) WILL BE SENT.      **         
      *    ************************************************************         
A02109     IF AT-BANKRUPTCY-IND = 'B'                                   
A02109        MOVE WS-SPEC-COMM-TYPE-CD      TO WS-COMM-TYPE-CD         
A02109        MOVE WS-GRP-COMM-SUBTYPE-CODE  TO WS-COMM-SUBTYPE-CODE    
A02109        MOVE WS-BANKRUPT-COMMENTS                                 
A02109                                     TO KO-INITIAL-COMMENT-TX-TEXT
A02109        MOVE LENGTH OF WS-BANKRUPT-COMMENTS                       
A02109                                     TO KO-INITIAL-COMMENT-TX-LEN 
A02109        MOVE AT-ACCOUNT-NO           TO KO-ACCOUNT-NO             
A02109        PERFORM 2100-LOAD-COMM-DATA    THRU 2100-EXIT             
A02109        PERFORM 8300-INSERT-COMM-DATA  THRU 8300-EXIT             
A02109        ADD 1                        TO WS-RECS-TO-COMMIT-COUNT   
A02109     ELSE                                                         
              PERFORM 1700-CALL-CPD00068 THRU 1700-EXIT                 
              IF WS-AMT-FULL-BALANCE <= 0                               
A02109           ADD 1                TO WS-RECS-TO-COMMIT-COUNT        
A02109           MOVE AT-ACCOUNT-NO   TO WS-ORIGINAL-ACCOUNT            
A02109           MOVE AT-LOCAL-OFFICE TO WS-ORIGINAL-LOCAL-OFFICE       
A02109           MOVE 'Y'             TO WS-OTHER-ACCTS-EXIST           
A02109           MOVE 'N'             TO WS-ACCT-WITH-BAL-EXISTS        
A02109           PERFORM 7100-OPEN-OTHER-CURSOR     THRU 7100-EXIT      
A02109           PERFORM 2000-PROCESS-OTHER-CURSOR  THRU 2000-EXIT      
A02109              UNTIL NO-MORE-ACCOUNTS-EXIST OR                     
A02109                    ACCT-WITH-BAL-EXISTS                          
A02109           PERFORM 7300-CLOSE-OTHER-CURSOR    THRU 7300-EXIT      
A02109           IF ACCT-WITH-BAL-EXISTS                                
A02109              MOVE WS-SPEC-COMM-TYPE-CD      TO WS-COMM-TYPE-CD   
A02109              MOVE WS-GRP-COMM-SUBTYPE-CODE  TO                   
A02109                                             WS-COMM-SUBTYPE-CODE 
A02109              MOVE WS-ACCOUNT-COMMENTS       TO                   
A02109                                  KO-INITIAL-COMMENT-TX-TEXT      
A02109              MOVE LENGTH OF      WS-ACCOUNT-COMMENTS TO          
A02109                                  KO-INITIAL-COMMENT-TX-LEN       
A02109              MOVE WS-ORIGINAL-ACCOUNT       TO KO-ACCOUNT-NO     
A02109              PERFORM 2100-LOAD-COMM-DATA    THRU 2100-EXIT       
A02109              PERFORM 8300-INSERT-COMM-DATA  THRU 8300-EXIT       
A02109           ELSE                                                   
A04860              MOVE WS-ORIGINAL-ACCOUNT       TO WS-77-ACCOUNT-NO  
A02109                                                AT-ACCOUNT-NO     
A04860              MOVE WS-ORIGINAL-LOCAL-OFFICE  TO WS-77-LOCAL-OFFICE
A04860              MOVE 243                       TO WS-77-CATEGORY-ID 
A04860              MOVE +245                      TO WS-77-COMMENTS-LEN
A04860              MOVE WS-COMMENTS-200          TO WS-77-COMMENTS-TEXT
                    PERFORM 1409-CREATE-WORK-QUEUE THRU 1409-EXIT       
A02109              PERFORM 8000-UPDATE-ACCOUNT    THRU 8000-EXIT       
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF WS-RECS-TO-COMMIT-COUNT = 100                             
              PERFORM 1200-COMMIT-DB2-UPDATES                           
           END-IF.                                                      
                                                                        
           PERFORM 7010-FETCH-GROUP-CURSOR THRU 7010-EXIT.              
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** DB2 COMMITS ARE PERFORMED AFTER EVERY 100 RECORDS PROCESSED **         
      *****************************************************************         
       1200-COMMIT-DB2-UPDATES.                                         
           EXEC SQL                                                     
               COMMIT                                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE ZEROES TO WS-RECS-TO-COMMIT-COUNT.                      
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** CREATES WQS                                                 **         
      *****************************************************************         
       1409-CREATE-WORK-QUEUE.                                          
      *                                                                         
A04860     MOVE LR-CUSTOMER-NO          TO WS-77-CUSTOMER-NO.           
A04860     MOVE LR-PREMISE-NO           TO WS-77-PREMISE-NO.            
A04860     MOVE 4                       TO WS-77-ROUTE-CATEGORY.        
A04860     MOVE WS-N                    TO WS-77-PRIORITY.              
A04860     MOVE WS-CURRENT-DATE         TO WS-CRE-DATE-PT.              
A04860     MOVE WS-CREATED-TS           TO WS-77-DATE-CREATED.          
A04860     MOVE WS-CURRENT-DT-PLUS1     TO WS-77-DATE-REQUIRED.         
A04860     MOVE PROGRAM-NAME            TO WS-77-CREATED-BY.            
           PERFORM 8895-INSERT-WORK-QUEUE THRU 8895-EXIT.               
      *                                                                         
       1409-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *   UTILIZATION OF CPD00068 FUNCTIONALITY TO CALCULATE FULL     *         
      *   BALANCE AND WRITE OFF BALANCE.                              *         
      *****************************************************************         
       1700-CALL-CPD00068.                                              
      *                                                                         
           MOVE '1700' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           MOVE 'Y' TO CALC-ARREARS-SW.                                 
           MOVE 'Y' TO CALC-BALANCE-SW.                                 
           MOVE 'Y' TO CALC-PAST-DUE-SW.                                
           MOVE 'N' TO LOAD-WS-AMOUNTS-SW.                              
      *                                                                         
           MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT.         
           MOVE WS-INPUT-DATE-BREAKUP TO WS-HOLD-DATE.                  
           MOVE PROGRAM-NAME          TO WS-CPD00068-CALLING-PGM.       
      *                                                                         
           MOVE SPACES TO  ABEND-FUNCTION.                              
           CALL SCSCB068  USING   CWS00068-FIELDS,                      
                                  WS-CODES-DATA-PRESENT,                
                                  DCLCSS-ACCOUNT,                       
                                  ABEND-FILE,                           
                                  RS-RETURN-CODE.                       
           MOVE RS-RETURN-CODE TO  WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF ABEND-FUNCTION > SPACES                                   
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       1700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
35273 ****************************************************************          
35273 *     6500-GET-NEXT-BUSINESS-DAY                               *          
35273 *  TAKES THE CURRENT DATE AND GOES AND GETS THE DATE THAT IS   *          
35273 *  'X' BUSINESS DAYS AFTER TODAY.  WHERE 'X' IS EQUAL TO A     *          
35273 *  VALUE FROM THE DELINQUENCY TABLE.                           *          
35273 ****************************************************************          
      *                                                                         
35273      EXEC SQL                                                             
35273          INCLUDE CPD00315                                                 
35273      END-EXEC.                                                            
      *                                                                         
A02109*****************************************************************         
A02109* 2000-PROCESS-OTHER-CURSOR                                     *         
A02109*   LOOPING MODULE TO PROCESS OTHER ACCOUNTS UNTIL THE CURSOR   *         
A02109*   RETURNS A NOT-FOUND CONDITION OR AN ACCOUNT IS FOUND THAT   *         
A02109*   MEETS THE CONDITIONS.                                       *         
A02109*****************************************************************         
A02109 2000-PROCESS-OTHER-CURSOR.                                       
A02109                                                                  
A02109     PERFORM 7200-FETCH-OTHER-CURSOR    THRU 7200-EXIT.           
A02109     IF MORE-ACCOUNTS-EXIST                                       
A02109        PERFORM 1700-CALL-CPD00068      THRU 1700-EXIT            
A02109        IF (WS-WO-BALANCE       > WS-AMT-ACCT-BALN-VALUE OR       
A02109            WS-AMT-FULL-BALANCE > WS-AMT-ACCT-BALN-VALUE)         
A02109           MOVE 'Y' TO WS-ACCT-WITH-BAL-EXISTS                    
A02109        END-IF                                                    
A02109     END-IF.                                                      
A02109*                                                                         
A02109 2000-EXIT.                                                       
A02109     EXIT.                                                        
A02109*                                                                         
A02109*****************************************************************         
A02109* 2100-LOAD-COMM-DATA                                           *         
A02109*   LOAD COMMUNICATION DATA.                                    *         
A02109*****************************************************************         
A02109 2100-LOAD-COMM-DATA.                                             
A02109*                                                                         
A02109     MOVE AT-COMPANY-NO          TO KO-COMPANY-NO.                
A02109     MOVE WS-N                   TO KO-RED-FLAG-IND.              
A02109     MOVE SPACES                 TO KO-RED-FLAG-EXPIRE-DT.        
A02109     MOVE -1                     TO WS-RED-FL-NULL-IND.           
A02109     MOVE 'O'                    TO KO-COMM-METHOD.               
A02109     MOVE 'O'                    TO KO-COMM-DIRECTION.            
A02109     MOVE WS-COMM-TYPE-CD        TO KO-COMM-TYPE-CD.              
A02109     MOVE WS-COMM-SUBTYPE-CODE   TO KO-COMM-SUBTYPE-CODE.         
A02109     MOVE 'SYSTEM'               TO KO-USER-ID-ORIG.              
A02109     MOVE SPACES                 TO KO-PROMOTION-ID.              
A02109     MOVE SPACES                 TO KO-PSC-COMPLIANCE-IND.        
A02109     MOVE 0                      TO KO-CALL-ORIGIN-ID.            
A02109     MOVE SPACES                 TO KO-CALL-END-TIME.             
A02109     MOVE -1                     TO WS-END-NULL-IND.              
A02109     MOVE 0                      TO KO-NUMBER-TRANSFERS.          
A02109     MOVE 0                      TO KO-HOLD-TIME.                 
A02109     MOVE 0                      TO KO-QUEUE-TIME.                
A02109     MOVE WS-N                   TO KO-SCREEN-POP-IND.            
A02109     MOVE 0                      TO KO-TOTAL-CALL-TIME.           
A02109     MOVE SPACES                 TO KO-RESPONSE-REASON-CD.        
A02109     MOVE SPACES                 TO KO-RESPONSE-TYPE-CD.          
A02109     MOVE SPACES                 TO KO-SOLICITATION-CD.           
A02109     MOVE 'A'                    TO KO-COMM-ASSOC-CD.             
A02109     MOVE WS-N                   TO KO-COMPLAINT-FL.              
A02109     MOVE SPACES                 TO KO-DISCOVERY-MTHD-CD.         
A02109     MOVE SPACES                 TO KO-PREV-MARKETER-CD.          
A02109     MOVE 'SYSTEM'               TO KO-CONTACT-NAME.              
A02109     MOVE LR-CUSTOMER-NO         TO KO-CUSTOMER-NO.               
A02109     MOVE LR-PREMISE-NO          TO KO-PREMISE-NO.                
A02109     MOVE 'SYSTEM'               TO KO-USER-ID-ORIG.              
A02109*                                                                         
A02109 2100-EXIT.                                                       
A02109     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  6240-GET-FCA00-COMMON-DATE                                  *          
      *  COPYBOOK CONTAINING DATE COMMONDATE RETRIEVAL LOGIC         *          
      ****************************************************************          
      *                                                                         
              EXEC SQL                                                          
                   INCLUDE CPD00040                                             
              END-EXEC.                                                         
      ****************************************************************          
      *  6251-GET-FJC01-DATE                                         *          
      *  COPYBOOK CONTAINING DATE PARAMETER RETRIEVAL LOGIC          *          
      ****************************************************************          
      *                                                                         
              EXEC SQL                                                          
                   INCLUDE CPD00037                                             
              END-EXEC.                                                         
      *                                                                         
      *****************************************************************         
      *   OPEN DRIVING CURSOR                                         *         
      *****************************************************************         
      *                                                                         
       7000-OPEN-GROUP-CURSOR.                                          
      *                                                                         
           MOVE '7000' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              OPEN GROUP_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           WS-DISP-RETURN-CODE.                         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***************************************'         
              DISPLAY '**      PCSCA150 PROCESSING ERROR    **'         
              DISPLAY '**   COULD NOT OPEN GROUP_CURSOR     **'         
              DISPLAY '**   SQLCODE WAS: ' WS-DISP-RETURN-CODE          
              DISPLAY '***************************************'         
              MOVE 'OPEN' TO ABEND-FUNCTION                             
              MOVE 'CSS_REG_PROFILE' TO TABLE-1                         
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *   FETCH DRIVING CURSOR INTO HOST VARIABLES WITH NULL          *         
      *   INDICATORS WHERE NECESSARY                                  *         
      *****************************************************************         
       7010-FETCH-GROUP-CURSOR.                                         
      *                                                                         
           MOVE '7010' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              FETCH GROUP_CURSOR                                        
               INTO :LR-CUSTOMER-NO                                     
                   ,:LR-PREMISE-NO                                      
                   ,:LR-REG-GROUP-CD                                    
                   ,:AT-ACCOUNT-NO                                      
                   ,:AT-COMPANY-NO                                      
                   ,:AT-LOCAL-OFFICE                                    
                   ,:AT-CODES-DATA-PRESENT                              
                   ,:AT-NOTICE-EXEMPT-CD                                
                   ,:AT-CODE-DISC-OK                                    
                   ,:AT-DATE-BILL-DAY-00                                
                   ,:AT-DATE-BILL-DAY-30                                
                   ,:AT-DATE-BILL-DAY-60                                
                   ,:AT-DATE-BILL-DAY-90                                
                   ,:AT-BANKRUPTCY-IND                                  
                   ,:AT-CREDIT-GROUP                                    
                   ,:AT-CODE-ACCT-STAT                                  
C28788             ,:AT-IVR-EXEMPT-CD                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           WS-DISP-RETURN-CODE.                         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 SET NO-MORE-DATA-EXISTS TO TRUE                        
              ELSE                                                      
                 DISPLAY '******************************************'   
                 DISPLAY '**      PCSCA150 PROCESSING ERROR       **'   
                 DISPLAY '**            PARAGRAPH                 **'   
                 DISPLAY '**      7010-FETCH-GROUP-CURSOR         **'   
                 DISPLAY '**    FETCH FROM GROUP_CURSOR FAILED    **'   
35273            DISPLAY '**   SQLCODE      = ' WS-DISP-RETURN-CODE     
35273            DISPLAY '**   WS-1ST-CYCLE = ' WS-1ST-CYCLE            
35273            DISPLAY '**   WS-2ND-CYCLE = ' WS-2ND-CYCLE            
                 DISPLAY '******************************************'   
                 MOVE 'FETCH' TO ABEND-FUNCTION                         
                 MOVE 'CSS_REG_PROFILE' TO TABLE-1                      
                 PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT       
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *   CLOSE GROUP CURSOR                                          *         
      *****************************************************************         
       7020-CLOSE-GROUP-CURSOR.                                         
      *                                                                         
           MOVE '7020' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              CLOSE GROUP_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           WS-DISP-RETURN-CODE.                         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**      PCSCA150 PROCESSING ERROR     **'        
              DISPLAY '**    COULD NOT CLOSE GROUP_CURSOR    **'        
              DISPLAY '**   SQLCODE WAS: ' WS-DISP-RETURN-CODE          
              DISPLAY '****************************************'        
              MOVE 'CLOSE' TO ABEND-FUNCTION                            
              MOVE 'CSS_REG_PROFILE' TO TABLE-1                         
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
35273 ****************************************************************          
A02109* 7040-SELECT-DELINQ-VALUE                                     *          
A02109*  GET DELINQUENCY VALUES                                      *          
35273 ****************************************************************          
      *                                                                         
35273  7040-SELECT-DELINQ-VALUE.                                        
      *                                                                         
35273      EXEC SQL                                                     
35273        SELECT DELINQ_VALUE                                        
35273          INTO :C8-DELINQ-VALUE                                    
35273          FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                       
35273         WHERE DELINQ_CD    = :C8-DELINQ-CD                        
35273           AND COMPANY_NO   = :C8-COMPANY-NO                       
T35434                                                           
35273      END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DELINQ_VALUE                                                
MFA-TR*        INTO :C8-DELINQ-VALUE                                            
MFA-TR*        FROM CSS_DELINQUENCY                                             
MFA-TR*       WHERE DELINQ_CD    = :C8-DELINQ-CD                                
MFA-TR*         AND COMPANY_NO   = :C8-COMPANY-NO                               
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
35273      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
A02109                     WS-DISP-RETURN-CODE.                         
      *                                                                         
35273      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
35273         CONTINUE                                                  
35273      ELSE                                                         
35273        DISPLAY '*********************************************'    
35273        DISPLAY '  ERROR IN 7040-SELECT-DELINQ-VALUE '             
A02109       DISPLAY 'RETURN CODE = ' WS-DISP-RETURN-CODE               
35273        DISPLAY 'DELINQ-CD   = ' C8-DELINQ-CD                      
35273        DISPLAY 'COMPANY-NO  = ' C8-COMPANY-NO                     
35273        DISPLAY '*********************************************'    
A02109       PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT           
35273      END-IF.                                                      
      *                                                                         
35273  7040-EXIT.                                                       
35273      EXIT.                                                        
      *                                                                         
35273 ****************************************************************          
35273 *  GET THE MAX CYCLE FOR THE MAX REVENUE MONTH FOR THE         *          
35273 *  PROJECTED EXTRACT DATE                                      *          
35273 ****************************************************************          
      *                                                                         
35273  7050-BILL-WINDOW.                                                
      *                                                                         
35273      EXEC SQL                                                     
35273         SELECT MAX(BN.BILL_CYCLE)                                 
35273           INTO :BN-BILL-CYCLE                                     
35273           FROM CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                   
35273        WHERE BN.DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )                   
35273          AND BN.REVENUE_MONTH  =                                  
35273        (SELECT MAX(B1.REVENUE_MONTH)                              
35273           FROM CSS_BILL_WINDOW B1 WITH(READUNCOMMITTED)                   
35273          WHERE B1.DATE_EXTRACT = BN.DATE_EXTRACT)                 
35273          AND BN.DATE_EXTRACT =                                    
35273        (SELECT MIN(B2.DATE_EXTRACT)                               
35273           FROM CSS_BILL_WINDOW B2 WITH(READUNCOMMITTED)                   
35273          WHERE B2.BILL_CYCLE  = BN.BILL_CYCLE                     
35273            AND B2.REVENUE_MONTH  = BN.REVENUE_MONTH)              
35273                                                            
35273      END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(BN.BILL_CYCLE)                                         
MFA-TR*         INTO :BN-BILL-CYCLE                                             
MFA-TR*         FROM CSS_BILL_WINDOW BN                                         
MFA-TR*      WHERE BN.DATE_EXTRACT = :BN-DATE-EXTRACT                           
MFA-TR*        AND BN.REVENUE_MONTH  =                                          
MFA-TR*      (SELECT MAX(B1.REVENUE_MONTH)                                      
MFA-TR*         FROM CSS_BILL_WINDOW B1                                         
MFA-TR*        WHERE B1.DATE_EXTRACT = BN.DATE_EXTRACT)                         
MFA-TR*        AND BN.DATE_EXTRACT =                                            
MFA-TR*      (SELECT MIN(B2.DATE_EXTRACT)                                       
MFA-TR*         FROM CSS_BILL_WINDOW B2                                         
MFA-TR*        WHERE B2.BILL_CYCLE  = BN.BILL_CYCLE                             
MFA-TR*          AND B2.REVENUE_MONTH  = BN.REVENUE_MONTH)                      
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
35273      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
A02109                     WS-DISP-RETURN-CODE.                         
      *                                                                         
35273      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR -305           
35273         CONTINUE                                                  
35273      ELSE                                                         
35273        DISPLAY '*********************************************'    
35273        DISPLAY '  ERROR IN 7050-BILL-WINDOW  '                    
A02109       DISPLAY 'RETURN CODE = ' WS-DISP-RETURN-CODE               
35273        DISPLAY 'DELINQ-CD   = ' C8-DELINQ-CD                      
35273        DISPLAY 'COMPANY-NO  = ' C8-COMPANY-NO                     
35273        DISPLAY '*********************************************'    
A02109       PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT           
35273      END-IF.                                                      
      *                                                                         
35273  7050-EXIT.                                                       
35273      EXIT.                                                        
      *                                                                         
A02109*****************************************************************         
A02109* 7100-OPEN-OTHER-CURSOR                                        *         
A02109*   OPEN OTHER CURSOR                                           *         
A02109*****************************************************************         
A02109 7100-OPEN-OTHER-CURSOR.                                          
A02109*                                                                         
A02109     EXEC SQL                                                     
A02109        OPEN OTHER_CURSOR                                         
A02109     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02109*                                                                         
A02109     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
A02109                     WS-DISP-RETURN-CODE.                         
A02109*                                                                         
A02109     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A02109        NEXT SENTENCE                                             
A02109     ELSE                                                         
A02109        DISPLAY '***************************************'         
A02109        DISPLAY '**      PCSCA150 PROCESSING ERROR    **'         
A02109        DISPLAY '**   COULD NOT OPEN OTHER_CURSOR     **'         
A02109        DISPLAY '**      7100-OPEN-OTHER-CURSOR       **'         
A02109        DISPLAY '**   SQLCODE WAS: ' WS-DISP-RETURN-CODE          
A02109        DISPLAY '***************************************'         
A02109        MOVE '7100'                   TO ACTIVE-PARAGRAPH         
A02109        MOVE 'OPEN'                   TO ABEND-FUNCTION           
A02109        MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
A02109        MOVE 'CUSTOMER_NO'            TO TABLE-ELEMENT-1          
A02109        MOVE LR-CUSTOMER-NO           TO HOSTVAR-ELEMENT-1        
A02109        PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
A02109     END-IF.                                                      
A02109*                                                                         
A02109 7100-EXIT.                                                       
A02109     EXIT.                                                        
A02109*****************************************************************         
A02109* 7200-FETCH-OTHER-CURSOR                                       *         
A02109*   FETCH OTHER CURSOR - OTHER ACCOUNTS LINKED TO CUSTOMER.     *         
A02109*****************************************************************         
A02109 7200-FETCH-OTHER-CURSOR.                                         
A02109*                                                                         
A02109     EXEC SQL                                                     
A02109        FETCH OTHER_CURSOR                                        
A02109         INTO :AT-ACCOUNT-NO                                      
A02109             ,:AT-LOCAL-OFFICE                                    
A02109             ,:AT-CODES-DATA-PRESENT                              
A02109             ,:AT-DATE-BILL-DAY-00                                
A02109             ,:AT-DATE-BILL-DAY-30                                
A02109             ,:AT-DATE-BILL-DAY-60                                
A02109             ,:AT-DATE-BILL-DAY-90                                
A02109             ,:AT-CREDIT-GROUP                                    
A02109             ,:AT-CODE-ACCT-STAT                                  
A02109     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02109*                                                                         
A02109     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
A02109                     WS-DISP-RETURN-CODE.                         
A02109*                                                                         
A02109     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A02109        NEXT SENTENCE                                             
A02109     ELSE                                                         
A02109        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
A02109           MOVE 'N' TO  WS-OTHER-ACCTS-EXIST                      
A02109        ELSE                                                      
A02109           DISPLAY '******************************************'   
A02109           DISPLAY '**      PCSCA150 PROCESSING ERROR       **'   
A02109           DISPLAY '**            PARAGRAPH                 **'   
A02109           DISPLAY '**      7200-FETCH-OTHER-CURSOR         **'   
A02109           DISPLAY '**    FETCH FROM OTHER_CURSOR FAILED    **'   
A02109           DISPLAY '**   SQLCODE      = ' WS-DISP-RETURN-CODE     
A02109           DISPLAY '**   AT-ACCOUNT-NO  = ' AT-ACCOUNT-NO         
A02109           DISPLAY '**   LR-CUSTOMER-NO = ' LR-CUSTOMER-NO        
A02109           DISPLAY '******************************************'   
A02109           MOVE '7200'                   TO ACTIVE-PARAGRAPH      
A02109           MOVE 'CSS_ACCOUNT'            TO TABLE-1               
A02109           MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1       
A02109           MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1     
A02109           MOVE 'FETCH'                  TO ABEND-FUNCTION        
A02109           PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT       
A02109        END-IF                                                    
A02109     END-IF.                                                      
A02109*                                                                         
A02109 7200-EXIT.                                                       
A02109     EXIT.                                                        
A02109*                                                                         
A02109*****************************************************************         
A02109* 7300-CLOSE-OTHER-CURSOR                                       *         
A02109*   CLOSE OTHER CURSOR                                          *         
A02109*****************************************************************         
A02109 7300-CLOSE-OTHER-CURSOR.                                         
A02109*                                                                         
A02109     EXEC SQL                                                     
A02109        CLOSE OTHER_CURSOR                                        
A02109     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02109*                                                                         
A02109     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
A02109                     WS-DISP-RETURN-CODE.                         
A02109*                                                                         
A02109     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A02109        NEXT SENTENCE                                             
A02109     ELSE                                                         
A02109        DISPLAY '****************************************'        
A02109        DISPLAY '**      PCSCA150 PROCESSING ERROR     **'        
A02109        DISPLAY '**    COULD NOT CLOSE OTHER_CURSOR    **'        
A02109        DISPLAY '**      7300-CLOSE-OTHER-CURSOR       **'        
A02109        DISPLAY '**   SQLCODE WAS: ' WS-DISP-RETURN-CODE          
A02109        DISPLAY '****************************************'        
A02109        MOVE '7300'                TO ACTIVE-PARAGRAPH            
A02109        PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
A02109     END-IF.                                                      
A02109*                                                                         
A02109 7300-EXIT.                                                       
A02109     EXIT.                                                        
      ****************************************************************          
      *  7600-START-FCSJC01                                          *          
      *  COPYBOOK CONTAINING DATE OVERRIDE RETRIEVAL LOGIC           *          
      ****************************************************************          
      *                                                                         
              EXEC SQL                                                          
                   INCLUDE CPD00038                                             
              END-EXEC.                                                         
      *                                                                         
      ****************************************************************          
      *  7620-START-FCSCA00                                          *          
      *  COPYBOOK CONTAINING DATE PARAMETER DATA RETRIEVAL LOGIC     *          
      ****************************************************************          
      *                                                                         
              EXEC SQL                                                          
                   INCLUDE CPD00039                                             
              END-EXEC.                                                         
A02109****************************************************************          
A02109* 8000-UPDATE-ACCOUNT                                          *          
A02109*  UPDATE CSS_ACCOUNT                                          *          
A02109****************************************************************          
A02109 8000-UPDATE-ACCOUNT.                                             
A02109     EXEC SQL                                                     
T27821         UPDATE CSS_ACCOUNT                                       
T27821                SET CODE_ACCT_BILLED = 'H',                       
A02109                    LAST_UPDATE_TS   = CIS.CURRENT$TIMESTAMP()          
T27821                WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO             
T27821     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCOUNT                                               
MFA-TR*               SET CODE_ACCT_BILLED = 'H',                               
MFA-TR*                   LAST_UPDATE_TS   = CURRENT TIMESTAMP                  
MFA-TR*               WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T27821     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
A02109                     WS-DISP-RETURN-CODE.                         
T27821     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T27821        NEXT SENTENCE                                             
T27821     ELSE                                                         
T27821        MOVE SPACES                   TO ABEND-TABLES             
T27821        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
A02109        MOVE '8000'                   TO ACTIVE-PARAGRAPH         
T27821        MOVE 'UPDATE'                 TO ABEND-FUNCTION           
T27821        MOVE SPACES                   TO ABEND-SQL-PREDICATES     
T27821        MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
T27821        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
T27821        MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
A02109        DISPLAY '****************************************'        
A02109        DISPLAY '**      PCSCA150 PROCESSING ERROR     **'        
A02109        DISPLAY '**    COULD NOT UPDATE CSS_ACCOUNT    **'        
A02109        DISPLAY '**      8000-UPDATE-ACCOUNT           **'        
A02109        DISPLAY '**   SQLCODE WAS: ' WS-DISP-RETURN-CODE          
A02109        DISPLAY '****************************************'        
T27821        PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
T27821     END-IF.                                                      
A02109 8000-EXIT.                                                       
A02109     EXIT.                                                        
A02109***************************************************************           
A02109* 8300-INSERT-COMM-DATA                                       *           
A02109***************************************************************           
A02109                                                                  
A02109 8300-INSERT-COMM-DATA.                                           
A02109                                                                  
A02109     EXEC SQL                                                     
A02109          INSERT INTO CSS_COMM_DATA                               
A02109                  (COMMUNICATION_ID,                              
A02109                   ACCOUNT_NO,                                    
A02109                   CUSTOMER_NO,                                   
A02109                   PREMISE_NO,                                    
A02109                   COMPANY_NO,                                    
A02109                   RED_FLAG_IND,                                  
A02109                   RED_FLAG_EXPIRE_DT,                            
A02109                   COMM_METHOD,                                   
A02109                   COMM_DIRECTION,                                
A02109                   COMM_TYPE_CD,                                  
A02109                   COMM_SUBTYPE_CODE,                             
A02109                   USER_ID_ORIG,                                  
A02109                   CONTACT_NAME,                                  
A02109                   PROMOTION_ID,                                  
A02109                   PSC_COMPLIANCE_IND,                            
A02109                   CALL_ORIGIN_ID,                                
A02109                   CALL_END_TIME,                                 
A02109                   NUMBER_TRANSFERS,                              
A02109                   HOLD_TIME,                                     
A02109                   QUEUE_TIME,                                    
A02109                   SCREEN_POP_IND,                                
A02109                   TOTAL_CALL_TIME,                               
A02109                   INITIAL_COMMENT_TX,                            
A02109                   RESPONSE_REASON_CD,                            
A02109                   RESPONSE_TYPE_CD,                              
A02109                   SOLICITATION_CD,                               
A02109                   COMM_ASSOC_CD,                                 
A02109                   COMPLAINT_FL,                                  
A02109                   DISCOVERY_MTHD_CD,                             
A02109                   PREV_MARKETER_CD)                              
A02109          VALUES   (CIS.CURRENT$TIMESTAMP(),                            
A02109                   :KO-ACCOUNT-NO,                                
A02109                   :KO-CUSTOMER-NO,                               
A02109                   :KO-PREMISE-NO,                                
A02109                   :KO-COMPANY-NO,                                
A02109                   :KO-RED-FLAG-IND,                              
A02109                   CIS.CHAR2TIMESTAMP(:KO-RED-FLAG-EXPIRE-DT 
                                            :WS-RED-FL-NULL-IND),     
A02109                   :KO-COMM-METHOD,                               
A02109                   :KO-COMM-DIRECTION,                            
A02109                   :KO-COMM-TYPE-CD,                              
A02109                   :KO-COMM-SUBTYPE-CODE,                         
A02109                   :KO-USER-ID-ORIG,                              
A02109                   :KO-CONTACT-NAME,                              
A02109                   :KO-PROMOTION-ID,                              
A02109                   :KO-PSC-COMPLIANCE-IND,                        
A02109                   :KO-CALL-ORIGIN-ID,                            
A02109                   CIS.CHAR2TIMESTAMP(:KO-CALL-END-TIME 
                                            :WS-END-NULL-IND),             
A02109                   :KO-NUMBER-TRANSFERS,                          
A02109                   :KO-HOLD-TIME,                                 
A02109                   :KO-QUEUE-TIME,                                
A02109                   :KO-SCREEN-POP-IND,                            
A02109                   :KO-TOTAL-CALL-TIME,                           
A02109                   :KO-INITIAL-COMMENT-TX,                        
A02109                   :KO-RESPONSE-REASON-CD,                        
A02109                   :KO-RESPONSE-TYPE-CD,                          
A02109                   :KO-SOLICITATION-CD,                           
A02109                   :KO-COMM-ASSOC-CD,                             
A02109                   :KO-COMPLAINT-FL,                              
A02109                   :KO-DISCOVERY-MTHD-CD,                         
A02109                   :KO-PREV-MARKETER-CD)                          
A02109     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_COMM_DATA                                       
MFA-TR*                 (COMMUNICATION_ID,                                      
MFA-TR*                  ACCOUNT_NO,                                            
MFA-TR*                  CUSTOMER_NO,                                           
MFA-TR*                  PREMISE_NO,                                            
MFA-TR*                  COMPANY_NO,                                            
MFA-TR*                  RED_FLAG_IND,                                          
MFA-TR*                  RED_FLAG_EXPIRE_DT,                                    
MFA-TR*                  COMM_METHOD,                                           
MFA-TR*                  COMM_DIRECTION,                                        
MFA-TR*                  COMM_TYPE_CD,                                          
MFA-TR*                  COMM_SUBTYPE_CODE,                                     
MFA-TR*                  USER_ID_ORIG,                                          
MFA-TR*                  CONTACT_NAME,                                          
MFA-TR*                  PROMOTION_ID,                                          
MFA-TR*                  PSC_COMPLIANCE_IND,                                    
MFA-TR*                  CALL_ORIGIN_ID,                                        
MFA-TR*                  CALL_END_TIME,                                         
MFA-TR*                  NUMBER_TRANSFERS,                                      
MFA-TR*                  HOLD_TIME,                                             
MFA-TR*                  QUEUE_TIME,                                            
MFA-TR*                  SCREEN_POP_IND,                                        
MFA-TR*                  TOTAL_CALL_TIME,                                       
MFA-TR*                  INITIAL_COMMENT_TX,                                    
MFA-TR*                  RESPONSE_REASON_CD,                                    
MFA-TR*                  RESPONSE_TYPE_CD,                                      
MFA-TR*                  SOLICITATION_CD,                                       
MFA-TR*                  COMM_ASSOC_CD,                                         
MFA-TR*                  COMPLAINT_FL,                                          
MFA-TR*                  DISCOVERY_MTHD_CD,                                     
MFA-TR*                  PREV_MARKETER_CD)                                      
MFA-TR*         VALUES   (CURRENT TIMESTAMP,                                    
MFA-TR*                  :KO-ACCOUNT-NO,                                        
MFA-TR*                  :KO-CUSTOMER-NO,                                       
MFA-TR*                  :KO-PREMISE-NO,                                        
MFA-TR*                  :KO-COMPANY-NO,                                        
MFA-TR*                  :KO-RED-FLAG-IND,                                      
MFA-TR*                  :KO-RED-FLAG-EXPIRE-DT:WS-RED-FL-NULL-IND,             
MFA-TR*                  :KO-COMM-METHOD,                                       
MFA-TR*                  :KO-COMM-DIRECTION,                                    
MFA-TR*                  :KO-COMM-TYPE-CD,                                      
MFA-TR*                  :KO-COMM-SUBTYPE-CODE,                                 
MFA-TR*                  :KO-USER-ID-ORIG,                                      
MFA-TR*                  :KO-CONTACT-NAME,                                      
MFA-TR*                  :KO-PROMOTION-ID,                                      
MFA-TR*                  :KO-PSC-COMPLIANCE-IND,                                
MFA-TR*                  :KO-CALL-ORIGIN-ID,                                    
MFA-TR*                  :KO-CALL-END-TIME:WS-END-NULL-IND,                     
MFA-TR*                  :KO-NUMBER-TRANSFERS,                                  
MFA-TR*                  :KO-HOLD-TIME,                                         
MFA-TR*                  :KO-QUEUE-TIME,                                        
MFA-TR*                  :KO-SCREEN-POP-IND,                                    
MFA-TR*                  :KO-TOTAL-CALL-TIME,                                   
MFA-TR*                  :KO-INITIAL-COMMENT-TX,                                
MFA-TR*                  :KO-RESPONSE-REASON-CD,                                
MFA-TR*                  :KO-RESPONSE-TYPE-CD,                                  
MFA-TR*                  :KO-SOLICITATION-CD,                                   
MFA-TR*                  :KO-COMM-ASSOC-CD,                                     
MFA-TR*                  :KO-COMPLAINT-FL,                                      
MFA-TR*                  :KO-DISCOVERY-MTHD-CD,                                 
MFA-TR*                  :KO-PREV-MARKETER-CD)                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02109                                                                  
A02109     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
A02109                                    WS-DISP-RETURN-CODE.          
A02109                                                                  
A02109     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A02109         CONTINUE                                                 
A02109     ELSE                                                         
A02109         DISPLAY '*************************************'          
A02109         DISPLAY '*    PCSCA150 PROCESSING ERROR       '          
A02109         DISPLAY '* 8300-INSERT-COMM-DATA'                        
A02109         DISPLAY '* CUSTOMER_NO = ' KO-CUSTOMER-NO                
A02109         DISPLAY '* ACCOUNT_NO  = ' KO-ACCOUNT-NO                 
A02109         DISPLAY '* SQL RETURN CODE = ' WS-DISP-RETURN-CODE       
A02109         DISPLAY '*************************************'          
A02109         MOVE '8300'                   TO ACTIVE-PARAGRAPH        
A02109         MOVE 'CSS_COMM_DATA'          TO TABLE-1                 
A02109         MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1         
A02109         MOVE KO-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1       
A02109         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
A02109     END-IF.                                                      
A02109                                                                  
A02109 8300-EXIT.                                                       
A02109     EXIT.                                                        
      ******************************************************************        
      *  8895-INSERT-WORK-QUEUE                                        *        
      ******************************************************************        
      *                                                                         
A04860 8895-INSERT-WORK-QUEUE.                                          
A04860*                                                                         
A04860     CALL SCSCB077 USING CWS00077-FIELDS,                         
A04860                         ABEND-FILE,                              
A04860                         RS-RETURN-CODE                           
A04860     MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE                 
A04860                                                                  
A04860     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
A04860        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A04860        DISPLAY '8895-INSERT-WORK-QUEUE'                          
A04860        DISPLAY 'CALL SCSCB077         '                          
A04860        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
A04860        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
A04860        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
A04860        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A04860        PERFORM 9900-ABEND    THRU 9900-EXIT                      
A04860     END-IF.                                                      
A04860 8895-EXIT.                                                       
A04860     EXIT.                                                        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
A02109     MOVE '9000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      *  9700-PROCESS-ABEND                                          *          
      *  COPYBOOK CONTAINING COMMON ABEND FORMATTING ROUTINE         *          
      ****************************************************************          
      *                                                                         
              EXEC SQL                                                          
                   INCLUDE CPD0023B                                             
              END-EXEC.                                                         
      *                                                                         
      ****************************************************************          
      *  9900-ABEND.                                                 *          
      *  COPYBOOK CONTAINING COMMON ABEND LOGIC                      *          
      ****************************************************************          
      *                                                                         
              EXEC SQL                                                          
                   INCLUDE CPD09900                                             
              END-EXEC.                                                         
      *                                                                         
