       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA143.                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                                                             **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      *****************************************************************         
      **                                                             **         
      **                                                             **         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS  REASON                                 **         
      **  ________  ________  ______                                 **         
      **   04/29/99   ADA     INITIAL PROGRAM VERSION                **         
C24086**   05/11/01   GSR     CHANGES MADE TO HANDLE PSNC CUSTOMERS. **         
C30624**   04/13/04  BB18179  ADDED WELCOME EMAIL LOGIC              **         
C36330**   11/17/07  SV82012  FIX DUPLICATE CUSTOMER SERVICE WELCOME **         
C36330**                      KITS.                                             
A01537**   09/16/09  SV82012  DELAY MAILING FOR 2 WEEKS FOR SCEG AND **         
A01537**                      PSNC.                                  **         
A01537**                      SEND WELCOME KIT TO SECOND ACTIVE ACCOUNT         
A01537**                      IF THE CLASS IS DIFFERENT              **         
P00465**   08/28/11  MS93554  SEND EMAIL WELCOME KIT  FOR PSNC, IF   **         
P00465**                      EMAIL ID AND EMAIL OPTION 'E' IS       **         
P00465**                      PRESENT IN CUST TABLE.                 **         
A05146**   08/05/14  SV95326  EXISTING SCE&G CUSTOMER OPENED A PSNC  **         
A05146**             ACT028   ACCOUNT AND IF THE REVENUE CLASS IS    **         
A05146**                      SAME WE NEED TO SEND WELOCME KIT FOR   **         
A05146**                      THAT CUSTOMER.                         **         
ACT070**   02/26/16  MC95456  USE NEXT VALUE FOR BATCH_EMAIL_ID IN   **         
ACT070**                      CSS_BATCH_EMAIL TABLE.                 **         
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT NAFILE  ASSIGN TO NAFILE.                             
 .                                                                      
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD  NAFILE                                                       
           RECORDING MODE IS F                                          
           BLOCK CONTAINS 0 RECORDS                                     
C24086*    RECORD CONTAINS 250 CHARACTERS                                       
C36330     RECORD CONTAINS 260 CHARACTERS                               
           LABEL RECORDS ARE STANDARD                                   
           DATA RECORD IS NA-RECORD.                                    
       01  NA-RECORD.                                                   
C36330     05  CUST-NUMBER             PIC 9(10).                       
           05  CUST-NAME               PIC X(50).                       
           05  CUST-NAME-OVERFLOW      PIC X(22).                       
           05  CUST-ADDRESS            PIC X(50).                       
           05  CUST-ADDRESS-OVERFLOW   PIC X(26).                       
           05  CUST-TOWN               PIC X(41).                       
           05  CUST-ACCOUNT-NO         PIC 9(13).                       
           05  CUST-BILL-DATE          PIC X(04).                       
           05  CUST-CLASS-1.                                            
               10 FILLER               PIC X(01).                       
               10 CUST-CLASS-TYPE-1    PIC X(01).                       
               10 FILLER               PIC X(01).                       
           05  CUST-RATE-1             PIC X(03).                       
           05  CUST-CLASS-2.                                            
               10 FILLER               PIC X(01).                       
               10 CUST-CLASS-TYPE-2    PIC X(01).                       
               10 FILLER               PIC X(01).                       
           05  CUST-RATE-2             PIC X(03).                       
           05  CUST-CLASS-3.                                            
               10 FILLER               PIC X(01).                       
               10 CUST-CLASS-TYPE-3    PIC X(01).                       
               10 FILLER               PIC X(01).                       
           05  CUST-RATE-3             PIC X(03).                       
           05  CUST-DISTRICT           PIC X(02).                       
           05  CUST-CYCLE              PIC X(02).                       
           05  CUST-LOCAL-OFFICE       PIC X(03).                       
           05  CUST-DEPOSIT            PIC 9(11)V99.                    
C24086     05  CUST-COMPANY-NO         PIC X(02).                       
A01537     05  FILLER                  PIC X(04).                       
                                                                        
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA143'.
MSQ017     COPY MFASQLM.
       01  WS-START                   PIC X(40)                         
           VALUE 'WORKING STORAGE FOR PCSCA143 STARTS HERE'.            
                                                                        
       01  WS-ABEND-AREA.                                               
           05  WS-ABEND-SPACE              PIC X(01) VALUE SPACE.       
           05  WS-ABEND-NUMERIC REDEFINES WS-ABEND-SPACE                
                                           PIC 9(01).                   
                                                                        
       01  WS-WORK-VARIABLES.                                           
COB305     05 WS-AT-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.          
           05  WS-CURRENT-DATE             PIC X(10).                   
           05  WS-RUN-DATE                 PIC X(10).                   
A01537     05  WS-SUCCESS-RUN-DATE         PIC X(10).                   
           05  WS-NUMBER-AT-FETCHED        PIC 9(7).                    
           05  WS-NUM-ACCOUNTS-QUAL        PIC 9(7).                    
           05  WS-NUMBER-EU-FETCHED        PIC 9(7).                    
           05  WS-NUMBER-GU-FETCHED        PIC 9(7).                    
           05  WS-NUMBER-LT-FETCHED        PIC 9(7).                    
           05  WS-NUMBER-UPDATED           PIC 9(7).                    
           05  WS-NULL-DEPOSIT-AMT         PIC S9(04) COMP.             
C30624     05  WS-CUST-EMAIL-NULL-IND      PIC S9(04) COMP.             
           05  WS-NUMBER-NA-READ           PIC 9(7).                    
           05  DB2-CP-ACCOUNT-NO           PIC 9(13).                   
A01537     05  WS-DAYS-INDX                PIC 9(02).                   
A01537     05  WS-SAME-CLASS-ACC-EXISTS    PIC S9(04) COMP.             
A01537     05  WS-CODE-REV-CLASS           PIC X(01) VALUE ' '.         
           05  WS-DISP-ACCOUNT-NO          PIC 9(13).                   
           05  DB2-XR-ACCOUNT-NO           PIC 9(13).                   
           05  WS-ACCOUNT-NUM-N            PIC 9(13).                   
           05  WS-ACCOUNT-NUM-CH REDEFINES WS-ACCOUNT-NUM-N.            
               10  WS-ACCOUNT-NUM-1-2      PIC X(02).                   
               10  WS-ACCOUNT-NUM-3-13     PIC X(11).                   
       01  WS-811                        PIC S9(4) COMP VALUE -811.     
                                                                        
A01537 01  WS-TEST-RUN-DATE.                                            
A01537     05 WS-TEST-RUN-DATE-CC          PIC  X(02).                  
A01537     05 WS-TEST-RUN-DATE-YY          PIC  X(02).                  
A01537     05 FILLER                       PIC  X(01).                  
A01537     05 WS-TEST-RUN-DATE-MM          PIC  X(02).                  
A01537     05 FILLER                       PIC  X(01).                  
A01537     05 WS-TEST-RUN-DATE-DD          PIC  X(02).                  
       01  WS-CA143-PARM.                                               
           05  WS-CA143-TEXT               PIC X(14).                   
           05  WS-LAST-RUN-DATE            PIC X(10).                   
C36330 01  WS-LAST-COMMON-PARM.                                         
C36330     05  WS-L-COMMON-TEXT            PIC X(14) VALUE              
C36330         'LAST RUN DATE='.                                        
C36330     05  WS-L-COMMON-RUN-DATE        PIC X(10).                   
A01537 01  WS-CA143-PARM1.                                              
A01537     05  WS-CA143-TEXT1              PIC X(20).                   
A01537     05  WS-MAIL-RUN-DATE1           PIC X(10).                   
A01537 01  WS-LAST-EMAIL-PARM.                                          
A01537     05  WS-L-EMAIL-TEXT             PIC X(20) VALUE              
A01537         'EMAIL LAST RUN DATE='.                                  
A01537     05  WS-L-EMAIL-RUN-DATE         PIC X(10).                   
A01537 01  WS-LAST-PMAIL-PARM.                                          
A01537     05  WS-L-PMAIL-TEXT             PIC X(20) VALUE              
A01537         'PMAIL LAST RUN DATE='.                                  
A01537     05  WS-L-PMAIL-RUN-DATE         PIC X(10).                   
       01  WS-COMMON-PARM.                                              
           05  WS-COMMON-TEXT               PIC X(09).                  
           05  WS-COMMON-RUN-DATE           PIC X(10).                  
       01  WS-CA143-RUN-TEXT               PIC X(09)                    
                                           VALUE 'RUN DATE='.           
       01  WS-EMAIL-ADDRESS-TX-NE.                                      
           05 WS-EMAIL-ADDRESS-TX-LEN      PIC X(04).                   
           05 WS-EMAIL-ADDRESS-TX-TEXT     PIC X(100).                  
                                                                        
       01  NA-STATUS                       PIC X(2)    VALUE '00'.      
P00465 01  WS-NULL-IND-CD                  PIC S9(4)   COMP VALUE 0.    
      *                                                                         
A01537 01  WS-JOBPARM-KEYS.                                             
A01537     05 WS-LAST-EM-KEY.                                           
A01537       10 WS-LAST-EM-PGRM-NAME               PIC X(08).           
A01537       10 WS-LAST-EM-CMND-CODE               PIC X(04).           
A01537       10 WS-LAST-EM-SEQ-NBR                 PIC 9(03).           
A01537     05 WS-LAST-PM-KEY.                                           
A01537       10 WS-LAST-PM-PGRM-NAME               PIC X(08).           
A01537       10 WS-LAST-PM-CMND-CODE               PIC X(04).           
A01537       10 WS-LAST-PM-SEQ-NBR                 PIC 9(03).           
A01537*                                                                         
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE          PIC S9(04) COMP VALUE 0.         
           05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
                                                                        
      /****************************************************************         
      **     THE FOLLOWING ARE A REPRESENTATIVE SAMPLING.  ADD ITEMS **         
      **     AS NECESSARY; DELETE THOSE WHICH YOU DO NOT USE.  DO    **         
      **     ===NOT=== USE DATA NAMES SUCH AS 'WS-A' (VALUE 'A').    **         
      **     USE A NAME THAT IS DESCRIPTIVE.                         **         
      **                                                             **         
       01  WS-CONSTANTS.                                                
           05  WS-INSERT                   PIC X(1)    VALUE 'I'.       
           05  WS-DELETE                   PIC X(1)    VALUE 'D'.       
           05  WS-UPDATE                   PIC X(1)    VALUE 'U'.       
           05  WS-YES                      PIC X(1)    VALUE 'Y'.       
           05  WS-NO                       PIC X(1)    VALUE 'N'.       
           05  WS-Y                        PIC X(1)    VALUE 'Y'.       
           05  WS-N                        PIC X(1)    VALUE 'N'.       
P00465     05  WS-ELECTRIC                 PIC X(1)    VALUE 'E'.       
P00465     05  WS-GAS                      PIC X(1)    VALUE 'G'.       
P00465     05  WS-COMMERCIAL               PIC X(1)    VALUE 'C'.       
P00465     05  WS-SCEG                     PIC X(02)   VALUE '01'.      
P00465     05  WS-PSNC                     PIC X(02)   VALUE '26'.      
P00465     05  WS-EMAIL-ONLY               PIC X(1)    VALUE 'E'.       
           05  WS-WARNING                  PIC X(1)    VALUE 'W'.       
           05  WS-REJECT                   PIC X(1)    VALUE 'R'.       
           05  WS-PGRMNAME               PIC X(08)     VALUE 'PCSCA143'.
           05  PROGRAM-NAME              PIC X(08)     VALUE 'PCSCA143'.
C30624     05  WS-WELCOME-EMAIL-RES        PIC X(05)   VALUE 'ECS20'.   
C30624     05  WS-WELCOME-EMAIL-COM        PIC X(05)   VALUE 'ECS??'.   
C30624     05  WS-WELCOME-EMAIL-IND        PIC X(05)   VALUE 'ECS??'.   
           05  WS-UPDATED-MESSAGE          PIC X(25)                    
                  VALUE 'CUST PLAN UPDATED        '.                    
           05  WS-NOT-UPDATED-MESSAGE      PIC X(25)                    
                  VALUE 'CUST PLAN NOT UPDATED    '.                    
           05  WS-XREF-NOT-FOUND-MESSAGE   PIC X(25)                    
                  VALUE 'XREF NOT FOUND           '.                    
           05  WS-NA-ENTRY-NOT-FOUND-MESS PIC X(25)                     
                  VALUE 'NA FILE ENTRY NOT FOUND '.                     
                                                                        
      /****************************************************************         
      **     PUT ANY PROGRAM SWITCH VARIABLES YOU NEED HERE.  IF     **         
      **     POSSIBLE, INCLUDE AT LEAST TWO CONDITION NAMES. IN THE  **         
      **     PROCEDURE DIVISION, USE "SET CONDITION-NAME TO TRUE"    **         
      **     RATHER THAN "MOVE 'Y' TO INDICATOR-VARIABLE-NAME"       **         
      **                                                             **         
       01  WS-SWITCHES-AND-INDICATORS.                                  
           05  WS-EXCEPTION-INDICATOR      PIC X(1).                    
               88  NO-EXCEPTIONS           VALUE '0'.                   
               88  EXCEPTION-ENCOUNTERED   VALUE '1'.                   
           05  WS-END-PROCESSING-SW        PIC X(1) VALUE 'N'.          
               88  WS-END-PROCESSING       VALUE 'Y'.                   
               88  WS-NOT-END-PROCESSING   VALUE 'N'.                   
           05  WS-END-ELEC-CUR-SW          PIC X(1) VALUE 'N'.          
               88  WS-END-ELEC-CUR         VALUE 'Y'.                   
               88  WS-NOT-END-ELEC-CUR     VALUE 'N'.                   
           05  WS-END-GAS-CUR-SW           PIC X(1) VALUE 'N'.          
               88  WS-END-GAS-CUR          VALUE 'Y'.                   
               88  WS-NOT-END-GAS-CUR      VALUE 'N'.                   
           05  WS-END-LIGHT-CUR-SW         PIC X(1) VALUE 'N'.          
               88  WS-END-LIGHT-CUR        VALUE 'Y'.                   
               88  WS-NOT-END-LIGHT-CUR    VALUE 'N'.                   
C30624     05  WS-CUST-EMAIL-IND           PIC X(01).                   
C30624         88  WS-CUST-EMAIL-PRESENT   VALUE 'Y'.                   
C30624     05  WS-TYPE-ACCT                PIC X(01).                   
C30624         88  WS-RESIDENTIAL-ACCT     VALUE '1'.                   
C30624         88  WS-COMMERCIAL-ACCT      VALUE '2'.                   
C30624         88  WS-INDUSTRIAL-ACCT      VALUE '3'.                   
P00465     05  WS-EMAIL-BOUNCED-IND        PIC X(01).                   
P00465         88  EMAIL-BOUNCED           VALUE 'B'.                   
P00465     05  WS-RATE-SECURED             PIC X(01) VALUE 'Y'.         
P00465         88 RATE-IS-NOT-SECURE       VALUE 'N'.                   
                                                                        
           05  MATCH-SWITCH                PIC X(01)   VALUE 'N'.       
           05  FOUND-OPEN-ERROR            PIC X.                       
      /*****************************************************************        
      *                                                                *        
      *  WORKING STORAGE COPY BOOKS FOLLOW ALL PROGRAM WS              *        
      *                                                                *        
      ******************************************************************        
      /*****   SQL WORK VARIABLES.                                              
       COPY CWS00303.                                                           
                                                                        
                                                                        
      /*****   WS AREA FOR ABEND SWITCH.                                        
       COPY CWS09900.                                                           
                                                                        
      /*****   WS AREA FOR ABEND WORK.                                          
       COPY CWS00010.                                                           
                                                                        
      /*****   WS AREA FOR MISC. INPUT.                                         
       COPY CWS00038.                                                           
                                                                        
      /*****   WS AREA TO REDUCE EMBEDDED SPACES.                               
       COPY CWS00011.                                                           
                                                                        
      /*****   WS AREA FOR CPD00074. CREATE MAIL NAME AND ADDRESS.              
       COPY CWS00074.                                                           
                                                                        
       01  WS-END                          PIC X(40)                    
           VALUE 'DB2 INCLUDES FOR PCSCA143 START HERE '.               
      /*****************************************************************        
      *   TABLE DECLARATIONS GO AFTER OTHER WORKING STORAGE ITEMS      *        
      *   (IF DIRECT ACCESS TO DB2 TABLES IS ALLOWED). FIRST ITEM      *        
      *   WILL ALWAYS BE SQLCA.                                        *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      /                                                                         
      / FCA00-KEY                                                               
      /                                                                         
           EXEC SQL                                                             
              INCLUDE FIOCA00                                                   
           END-EXEC.                                                            
      /                                                                         
      / IO AREA FOR PARM INPUT FILE 'A'                                         
      /                                                                         
           EXEC SQL                                                             
              INCLUDE FIOJC01                                                   
           END-EXEC.                                                            
      /                                                                         
      / FCA00 MISC INPUT                                                        
      /                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00039                                                  
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      / DCLGEN TABLE CSS_HOLIDAY                                                
A01537     EXEC SQL                                                             
A01537         INCLUDE TBHLDAY                                                  
A01537     END-EXEC.                                                            
A01537/                                                                         
A01537/ PREV AND NEXT BUSINESS DAYS.                                            
A01537     EXEC SQL                                                             
A01537         INCLUDE CWS00315                                                 
A01537     END-EXEC.                                                            
A01537/                                                                         
           EXEC SQL                                                             
               INCLUDE TBBILWDW                                                 
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBDEPHND                                                 
           END-EXEC.                                                            
      /                                                                         
      /ADDED FOR CPD00074 TO LOAD NAME AND ADDRESS.                             
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBCSADRX                                                 
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBADRFRE                                                 
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBATMISC                                                 
           END-EXEC.                                                            
      /                                                                         
      /* END OF CPD00074 INCLUDES.                                              
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
                                                                        
C30624*****                                                                     
C30624*  CSS_BATCH_EMAIL (PREFIX = AE)                                          
C30624*****                                                                     
C30624     EXEC SQL                                                             
C30624         INCLUDE TBBEMAIL                                                 
C30624     END-EXEC.                                                            
                                                                        
C30624*****                                                                     
C30624*  CSS_CUST_EMAIL (PREFIX = NE)                                           
C30624*****                                                                     
C30624     EXEC SQL                                                             
C30624         INCLUDE TBCSTEML                                                 
C30624     END-EXEC.                                                            
P00465*****                                                                     
P00465*  CSS_CUSTOMER   (PREFIX = CU)                                           
P00465*****                                                                     
P00465     EXEC SQL                                                             
P00465         INCLUDE TBCUST                                                   
P00465     END-EXEC.                                                            
                                                                        
      /*****************************************************************        
      **  CURSOR DECLARATIONS (IF ANY) GO LAST                         *        
      ******************************************************************        
A01537*                                                                         
A01537*** CURSOR TO SELECT ACCOUNTS FOR WELCOME EMAILS                          
A01537*                                                                         
           EXEC SQL                                                     
            DECLARE ACCOUNT_CUR CURSOR FOR                              
             SELECT AT.ACCOUNT_NO,                                      
                    AT.LOCAL_OFFICE,                                    
C24086              AT.COMPANY_NO,                                      
                    AT.BILL_CYCLE,                                      
                    AT.ADDRESS_ID,                                      
                    AT.ADDRESS_FORMAT,                                  
C30624              AT.CUSTOMER_NO,                                     
P00465              REPLACE(REPLACE(CONVERT(CHAR(26), AT.ACCT_CREATE_DT
           , 121), ' ', '-'), ':', '.') ACCT_CREATE_DT,                        
P00465              AT.ACCOUNT_TYPE_CODE                                
               FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                       
                    CSS_CUST_PREM_HIST CH WITH(READUNCOMMITTED)                 
              WHERE AT.CODE_ACCT_STAT = 'A'                             
                AND AT.ACCOUNT_TYPE_CODE <> 'N'                         
                AND AT.ACCOUNT_NO = CH.ACCOUNT_NO                       
A01537          AND CH.DATE_UTIL_SVC_STRT >= IIF(TRY_CONVERT(DATE, 
                                                   :WS-L-EMAIL-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-L-EMAIL-RUN-DATE
              ) <> 0) OR (LEN(:WS-L-EMAIL-RUN-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-L-EMAIL-RUN-DATE
              ), CONVERT(DATE, :WS-L-EMAIL-RUN-DATE) )       
                AND CH.DATE_UTIL_SVC_STRT <  IIF(TRY_CONVERT(DATE, 
                                                    :WS-COMMON-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-RUN-DATE
              ) <> 0) OR (LEN(:WS-COMMON-RUN-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-COMMON-RUN-DATE
              ), CONVERT(DATE, :WS-COMMON-RUN-DATE) )        
                AND NOT EXISTS                                          
                 (SELECT *                                              
                    FROM CSS_ACCOUNT AT2 WITH(READUNCOMMITTED),                 
                         CSS_CUST_PREM_HIST CH2 WITH(READUNCOMMITTED)           
                   WHERE AT.ACCOUNT_NO <> AT2.ACCOUNT_NO                
                     AND AT.CUSTOMER_NO = AT2.CUSTOMER_NO               
                     AND AT2.ACCOUNT_NO = CH2.ACCOUNT_NO                
                     AND AT2.ACCOUNT_TYPE_CODE <> 'N'                   
                     AND CH2.DATE_UTIL_SVC_STRT < CH.DATE_UTIL_SVC_STRT)
A01537          FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE ACCOUNT_CUR CURSOR FOR                                      
MFA-TR*      SELECT AT.ACCOUNT_NO,                                              
MFA-TR*             AT.LOCAL_OFFICE,                                            
MFA-TR*             AT.COMPANY_NO,                                              
MFA-TR*             AT.BILL_CYCLE,                                              
MFA-TR*             AT.ADDRESS_ID,                                              
MFA-TR*             AT.ADDRESS_FORMAT,                                          
MFA-TR*             AT.CUSTOMER_NO,                                             
MFA-TR*             AT.ACCT_CREATE_DT,                                          
MFA-TR*             AT.ACCOUNT_TYPE_CODE                                        
MFA-TR*        FROM CSS_ACCOUNT AT,                                             
MFA-TR*             CSS_CUST_PREM_HIST CH                                       
MFA-TR*       WHERE AT.CODE_ACCT_STAT = 'A'                                     
MFA-TR*         AND AT.ACCOUNT_TYPE_CODE <> 'N'                                 
MFA-TR*         AND AT.ACCOUNT_NO = CH.ACCOUNT_NO                               
MFA-TR*         AND CH.DATE_UTIL_SVC_STRT >= :WS-L-EMAIL-RUN-DATE               
MFA-TR*         AND CH.DATE_UTIL_SVC_STRT <  :WS-COMMON-RUN-DATE                
MFA-TR*         AND NOT EXISTS                                                  
MFA-TR*          (SELECT *                                                      
MFA-TR*             FROM CSS_ACCOUNT AT2,                                       
MFA-TR*                  CSS_CUST_PREM_HIST CH2                                 
MFA-TR*            WHERE AT.ACCOUNT_NO <> AT2.ACCOUNT_NO                        
MFA-TR*              AND AT.CUSTOMER_NO = AT2.CUSTOMER_NO                       
MFA-TR*              AND AT2.ACCOUNT_NO = CH2.ACCOUNT_NO                        
MFA-TR*              AND AT2.ACCOUNT_TYPE_CODE <> 'N'                           
MFA-TR*              AND CH2.DATE_UTIL_SVC_STRT < CH.DATE_UTIL_SVC_STRT)        
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
A01537*                                                                         
A01537*** CURSOR TO SELECT ACCOUNTS FOR WELCOME KIT MAILS                       
A01537*                                                                         
A01537     EXEC SQL                                                     
A01537      DECLARE WELCOME_KIT_CUR CURSOR FOR                          
A01537       SELECT AT.ACCOUNT_NO                                       
A01537             ,AT.LOCAL_OFFICE                                     
A01537             ,AT.COMPANY_NO                                       
A01537             ,AT.BILL_CYCLE                                       
A01537             ,AT.ADDRESS_ID                                       
A01537             ,AT.ADDRESS_FORMAT                                   
A01537             ,AT.CUSTOMER_NO                                      
A01537             ,REPLACE(REPLACE(CONVERT(CHAR(26), AT.ACCT_CREATE_DT
           , 121), ' ', '-'), ':', '.') ACCT_CREATE_DT                         
P00465             ,AT.ACCOUNT_TYPE_CODE                                
A01537         FROM CSS_ACCOUNT        AT WITH(READUNCOMMITTED)                 
A01537             ,CSS_CUST_PREM_HIST CH WITH(READUNCOMMITTED)                 
A01537        WHERE AT.CODE_ACCT_STAT      = 'A'                        
A01537          AND AT.ACCOUNT_TYPE_CODE  <> 'N'                        
A01537          AND AT.ACCOUNT_NO          = CH.ACCOUNT_NO              
A01537          AND CH.DATE_UTIL_SVC_STRT >= IIF(TRY_CONVERT(DATE, 
                                                   :WS-L-PMAIL-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-L-PMAIL-RUN-DATE
              ) <> 0) OR (LEN(:WS-L-PMAIL-RUN-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-L-PMAIL-RUN-DATE
              ), CONVERT(DATE, :WS-L-PMAIL-RUN-DATE) )       
A01537          AND CH.DATE_UTIL_SVC_STRT <  IIF(TRY_CONVERT(DATE, 
                                                   :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) )       
A01537          FOR READ ONLY                                   
A01537     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE WELCOME_KIT_CUR CURSOR FOR                                  
MFA-TR*      SELECT AT.ACCOUNT_NO                                               
MFA-TR*            ,AT.LOCAL_OFFICE                                             
MFA-TR*            ,AT.COMPANY_NO                                               
MFA-TR*            ,AT.BILL_CYCLE                                               
MFA-TR*            ,AT.ADDRESS_ID                                               
MFA-TR*            ,AT.ADDRESS_FORMAT                                           
MFA-TR*            ,AT.CUSTOMER_NO                                              
MFA-TR*            ,AT.ACCT_CREATE_DT                                           
MFA-TR*            ,AT.ACCOUNT_TYPE_CODE                                        
MFA-TR*        FROM CSS_ACCOUNT        AT                                       
MFA-TR*            ,CSS_CUST_PREM_HIST CH                                       
MFA-TR*       WHERE AT.CODE_ACCT_STAT      = 'A'                                
MFA-TR*         AND AT.ACCOUNT_TYPE_CODE  <> 'N'                                
MFA-TR*         AND AT.ACCOUNT_NO          = CH.ACCOUNT_NO                      
MFA-TR*         AND CH.DATE_UTIL_SVC_STRT >= :WS-L-PMAIL-RUN-DATE               
MFA-TR*         AND CH.DATE_UTIL_SVC_STRT <  :WS-NEW-BUSINESS-DAY               
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
A01537*                                                                         
A01537*** CURSOR TO SELECT RES & COMMERCIAL REV CLASSES                         
A01537*                                                                         
A01537     EXEC SQL                                                     
A01537      DECLARE UTIL_CLASS CURSOR FOR                               
A01537       SELECT DISTINCT CIS.SUBSTR3(CODE_REVENUE_CLASS, 2, 1)           
A01537         FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                   
A01537        WHERE UT.ACCOUNT_NO = :UT-ACCOUNT-NO                      
A01537          AND CIS.SUBSTR3(CODE_REVENUE_CLASS, 2, 1) IN ('1', '2')      
A01537          FOR READ ONLY                                   
A01537     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE UTIL_CLASS CURSOR FOR                                       
MFA-TR*      SELECT DISTINCT SUBSTR(CODE_REVENUE_CLASS, 2, 1)                   
MFA-TR*        FROM CSS_UTIL_ENVRNMT UT                                         
MFA-TR*       WHERE UT.ACCOUNT_NO = :UT-ACCOUNT-NO                              
MFA-TR*         AND SUBSTR(CODE_REVENUE_CLASS, 2, 1) IN ('1', '2')              
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
A01537*                                                                         
      ******************************************************************        
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
      ******************************************************************        
       0000-MAINLINE.                                                   
A01537******************************************************************        
A01537*                                                                         
A01537     PERFORM 0100-INITIALIZATION          THRU 0100-EXIT.         
A01537*                                                                         
A01537     IF WS-COMMON-RUN-DATE > WS-L-EMAIL-RUN-DATE                  
A01537        PERFORM 1000-PROCESS-EMAIL-ACCOUNTS  THRU 1000-EXIT       
A01537     ELSE                                                         
A01537        DISPLAY '***********************************************' 
A01537        DISPLAY '** WELCOME EMAILS ALREADY SENT FOR THIS DATE **' 
A01537        DISPLAY '** DATE: ' WS-COMMON-RUN-DATE                    
A01537        DISPLAY '***********************************************' 
A01537     END-IF.                                                      
A01537*                                                                         
A01537     IF WS-NEW-BUSINESS-DAY > WS-L-PMAIL-RUN-DATE                 
A01537        PERFORM 2000-PROCESS-PMAIL-ACCOUNTS THRU 2000-EXIT        
A01537     ELSE                                                         
A01537        DISPLAY ' '                                               
A01537        DISPLAY '***********************************************' 
A01537        DISPLAY '** WELCOME KITS ALREADY SENT FOR THIS DATE   **' 
A01537        DISPLAY '** DATE: ' WS-NEW-BUSINESS-DAY                   
A01537        DISPLAY '***********************************************' 
A01537     END-IF.                                                      
A01537*                                                                         
A01537     PERFORM 9000-TERMINATE        THRU 9000-EXIT.                
A01537*                                                                         
A01537     STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
       0100-INITIALIZATION.                                             
      *****************************************************************         
      *                                                                         
           INITIALIZE WS-WORK-VARIABLES.                                
      *                                                                         
           OPEN OUTPUT NAFILE.                                          
      *                                                                         
           PERFORM 0200-GET-PARM-DATA    THRU 0200-EXIT.                
A01537*                                                                         
A01537     MOVE WS-COMMON-RUN-DATE       TO WS-NEW-BUSINESS-DAY.        
A01537     PERFORM 0500-GET-10-BUSINESS-DAYS-AGO THRU 0500-EXIT         
A01537        VARYING WS-DAYS-INDX FROM 1 BY 1                          
A01537          UNTIL WS-DAYS-INDX GREATER THAN 10.                     
A01537*                                                                         
A01537     DISPLAY ' '                                                  
A01537     DISPLAY '====== IMPORTENT DATES FOR THIS RUN ======='        
A01537     DISPLAY '*** PGM COMMON RUN DATE ==> ' WS-COMMON-RUN-DATE.   
A01537     DISPLAY '*** LAST EMAIL RUN DATE ==> ' WS-L-EMAIL-RUN-DATE   
A01537     DISPLAY '*** LAST PMAIL RUN DATE ==> ' WS-L-PMAIL-RUN-DATE   
A01537     DISPLAY "*** 10 B`DAYS BACK DATE ==> " WS-NEW-BUSINESS-DAY.  
A01537     DISPLAY '==========================================='.       
A01537     DISPLAY ' '.                                                 
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *   0200-GET-PARM-DATA                                          *         
      *        ACCESS OF COMMON-DATE RECORD                           *         
      *        GET RUN DATE OR COMMON RUN DATE                        *         
      *****************************************************************         
       0200-GET-PARM-DATA.                                              
      *                                                                         
C36330     MOVE SPACES                        TO WS-SYSIPT.             
C36330     MOVE SPACES                        TO WS-INPUT-DATA-BREAKDOWN
C36330     MOVE WS-PGRMNAME                   TO WS-PROGRAM.            
C36330     MOVE WS-DATE                       TO WS-COMMAND.            
C36330     MOVE ZEROS                         TO WS-SEQUENCE.           
C36330     MOVE WS-KEY-AREA                   TO E-FJC01-KEY.           
C36330     PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
C36330     PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT.                 
A01537     PERFORM UNTIL END-OF-SYSIPT                                  
C36330        MOVE  G6-PARM-DATA                  TO WS-CA143-PARM1     
A01537        EVALUATE TRUE                                             
A01537            WHEN WS-CA143-TEXT1 = WS-L-EMAIL-TEXT                 
A01537               AND INPUT-ACTIVE                                   
A01537                MOVE WS-MAIL-RUN-DATE1 TO WS-L-EMAIL-RUN-DATE     
A01537                MOVE E-FJC01-KEY       TO WS-LAST-EM-KEY          
A01537            WHEN WS-CA143-TEXT1 = WS-L-PMAIL-TEXT                 
A01537               AND INPUT-ACTIVE                                   
A01537                MOVE WS-MAIL-RUN-DATE1 TO WS-L-PMAIL-RUN-DATE     
A01537                MOVE E-FJC01-KEY       TO WS-LAST-PM-KEY          
A01537            WHEN OTHER                                            
A01537               CONTINUE                                           
A01537        END-EVALUATE                                              
C36330        PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT               
C36330     END-PERFORM.                                                 
A01537*                                                                         
A01537     IF WS-L-EMAIL-RUN-DATE > SPACES                              
A01537        AND WS-L-PMAIL-RUN-DATE > SPACES                          
A01537        CONTINUE                                                  
A01537     ELSE                                                         
A01537        DISPLAY ' '                                               
A01537        DISPLAY '** ' WS-PGRMNAME ' PROCESSING ERROR  **'         
A01537        DISPLAY '** LAST RUN DATES NOT AVAILABLE      **'         
A01537        DISPLAY '**  PROCESSING TERMINATED  **'                   
A01537        PERFORM 9900-ABEND  THRU  9900-EXIT                       
A01537     END-IF.                                                      
A01537*                                                                         
C36330     MOVE SPACES                        TO WS-SYSIPT              
C36330     MOVE SPACES                        TO WS-INPUT-DATA-BREAKDOWN
           PERFORM 6251-GET-FJC01-DATE               THRU 6251-EXIT.    
      *                                                                         
C36330     IF COMMON-DATE-NEEDED                                        
C36330        MOVE SPACES                     TO WS-SYSIPT              
C36330        MOVE SPACES                     TO WS-INPUT-DATA-BREAKDOWN
C36330        MOVE 'COMMON'                   TO WS-PROGRAM             
C36330        MOVE WS-DATE                    TO WS-COMMAND             
C36330        MOVE ZEROS                      TO WS-SEQUENCE            
C36330        MOVE WS-KEY-AREA                TO E-FJC01-KEY            
C36330        PERFORM 7600-START-FCSJC01  THRU  7600-EXIT               
C36330        PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT               
C36330                UNTIL (RUN-DATE AND INPUT-ACTIVE)                 
C36330                           OR  END-OF-SYSIPT                      
C36330        IF  WS-INPUT-RUN-DATE-MM  NUMERIC AND                     
C36330            WS-INPUT-RUN-DATE-DD  NUMERIC AND                     
C36330            WS-INPUT-RUN-DATE-YY  NUMERIC                         
C36330            PERFORM 7611-CLOSE THRU 7611-EXIT                     
C36330            MOVE  G6-PARM-DATA          TO WS-COMMON-PARM         
C36330        ELSE                                                      
C36330             DISPLAY ' '                                          
C36330             DISPLAY '** ' WS-PGRMNAME ' PROCESSING ERROR  **'    
C36330             DISPLAY '**  COMMON IS NOT ACTIVE'                   
C36330             DISPLAY '**    KEY = ' E-FJC01-KEY                   
C36330             DISPLAY '**  PROCESSING TERMINATED  **'              
C36330             PERFORM 9900-ABEND  THRU  9900-EXIT                  
C36330         END-IF                                                   
C36330     ELSE                                                         
C36330         MOVE G6-PARM-DATA              TO WS-COMMON-PARM         
C36330     END-IF.                                                      
A01537*                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A01537******************************************************************        
A01537 0500-GET-10-BUSINESS-DAYS-AGO.                                   
A01537******************************************************************        
A01537*** GET PREVIOUS 10TH BUSINESS DAY FROM RUN DATE                          
A01537*                                                                         
A01537     MOVE WS-NO                 TO WS-NEXT-BUSINESS-DAY.          
A01537     PERFORM 6525-PREV-BUSINESS-DAY THRU                          
A01537             6525-PREV-BUSINESS-DAY-EXIT UNTIL                    
A01537             NEXT-BUSINESS-DAY-FOUND.                             
A01537*                                                                         
A01537 0500-EXIT.                                                       
A01537     EXIT.                                                        
A01537*                                                                         
A01537*****************************************************************         
A01537 1000-PROCESS-EMAIL-ACCOUNTS.                                     
A01537*****************************************************************         
A01537*                                                                         
A01537     PERFORM 7000-OPEN-ACCOUNT           THRU 7000-EXIT.          
A01537     PERFORM 7010-FETCH-ACCOUNT          THRU 7010-EXIT.          
A01537     PERFORM 1100-PROCESS-WELCOME-EMAIL  THRU 1100-EXIT           
A01537        UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
A01537     PERFORM 7020-CLOSE-ACCOUNT          THRU 7020-EXIT.          
A01537*                                                                         
A01537     PERFORM 8100-UPDATE-EMAIL-JOB-PARM  THRU 8100-EXIT.          
A01537     PERFORM 8898-COMMIT-EMAIL-PROCESS   THRU 8898-EXIT.          
A01537*                                                                         
A01537 1000-EXIT.                                                       
A01537     EXIT.                                                        
A01537*                                                                         
A01537******************************************************************        
A01537*   SEND WELCOME EMAIL FOR RESIDENTIAL CUSTOMER.                          
A01537*   SEND WELCOME EMAIL IF WE HAVE CUSTOMER EMAIL INFO.                    
A01537******************************************************************        
A01537 1100-PROCESS-WELCOME-EMAIL.                                      
      *                                                                         
A01537     COMPUTE WS-NUMBER-AT-FETCHED = WS-NUMBER-AT-FETCHED + 1.     
A01537     MOVE SPACES                   TO WS-TYPE-ACCT                
A01537     MOVE AT-ACCOUNT-NO            TO UT-ACCOUNT-NO               
A01537                                      WS-DISP-ACCOUNT-NO          
A01537     MOVE '1'                         TO WS-CODE-REV-CLASS        
                                                                        
P00465*---------------------------------------------------------------*         
P00465*  SEND WELCOME E-MAIL NOTE FOR SCE&G RESIDENTIAL CUSTOMER      *         
P00465*  AND SCE&G COMMERCIAL CUSTOMER WITH RESIDENTIAL ACCOUNT       *         
P00465*---------------------------------------------------------------*         
                                                                        
P00465     IF AT-COMPANY-NO = WS-SCEG                                   
P00465        MOVE WS-ELECTRIC              TO UT-CODE-UTIL-TYPE        
P00465        PERFORM 7115-CHECK-ELEC-GAS-UTIL    THRU 7115-EXIT        
P00465        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
P00465           SET WS-RESIDENTIAL-ACCT    TO TRUE                     
P00465        ELSE                                                      
P00465           MOVE WS-GAS                TO UT-CODE-UTIL-TYPE        
P00465           PERFORM 7115-CHECK-ELEC-GAS-UTIL THRU 7115-EXIT        
P00465           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
P00465              SET WS-RESIDENTIAL-ACCT TO TRUE                     
P00465           ELSE                                                   
P00465              PERFORM 7117-CHECK-LIGHT-UTIL THRU 7117-EXIT        
P00465              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL          
P00465                 SET WS-RESIDENTIAL-ACCT TO TRUE                  
P00465              END-IF                                              
P00465           END-IF                                                 
P00465        END-IF                                                    
A01537     END-IF.                                                      
                                                                        
      *-----------------------------------------------------------------        
      *  SEND THE E-MAIL WELCOME KIT ONLY FOR PSNC COMMERCIAL CUSTOMERS*        
      *  THAT ARE NOT ON A SECURE RATE AND PSNC RESIDENTIAL CUSTOMER.  *        
      *----------------------------------------------------------------*        
P00465     IF AT-COMPANY-NO = WS-PSNC                                   
P00465        IF AT-ACCOUNT-TYPE-CODE  = WS-COMMERCIAL                  
P00465           MOVE 'N'                   TO WS-RATE-SECURED          
P00465           PERFORM 7100-CHK-SECURED-RATE-FL THRU 7100-EXIT        
P00465           IF RATE-IS-NOT-SECURE                                  
P00465              MOVE '2'                TO WS-CODE-REV-CLASS        
P00465              MOVE WS-GAS                TO UT-CODE-UTIL-TYPE     
P00465              PERFORM 7115-CHECK-ELEC-GAS-UTIL THRU 7115-EXIT     
P00465              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL          
P00465                 SET WS-COMMERCIAL-ACCT TO TRUE                   
P00465              ELSE                                                
P00465                 PERFORM 7117-CHECK-LIGHT-UTIL THRU 7117-EXIT     
P00465                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL       
P00465                    SET WS-COMMERCIAL-ACCT TO TRUE                
P00465                 END-IF                                           
P00465              END-IF                                              
P00465           END-IF                                                 
P00465        ELSE                                                      
P00465           MOVE '1'                TO WS-CODE-REV-CLASS           
P00465           MOVE WS-GAS                TO UT-CODE-UTIL-TYPE        
P00465           PERFORM 7115-CHECK-ELEC-GAS-UTIL THRU 7115-EXIT        
P00465           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
P00465              SET WS-RESIDENTIAL-ACCT TO TRUE                     
P00465           ELSE                                                   
P00465              PERFORM 7117-CHECK-LIGHT-UTIL THRU 7117-EXIT        
P00465              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL          
P00465                 SET WS-RESIDENTIAL-ACCT TO TRUE                  
P00465              END-IF                                              
P00465           END-IF                                                 
P00465        END-IF                                                    
P00465     END-IF.                                                      
      *                                                                         
P00465     IF WS-RESIDENTIAL-ACCT OR (WS-COMMERCIAL-ACCT AND            
P00465                                AT-COMPANY-NO = WS-PSNC)          
C30624        MOVE SPACES                   TO WS-CUST-EMAIL-IND        
C30624        MOVE AT-CUSTOMER-NO           TO NE-CUSTOMER-NO           
C30624        PERFORM 7530-SELECT-CSS-CUST-EMAIL THRU 7530-EXIT         
                                                                        
P00465*     ----------------------------------------------------------          
P00465*      SEND WELCOME EMAIL NOTE IF WE HAVE CUSTOMER EMAIL INFO             
P00465*      FOR SCE&G / PSNC CUSTOMERS                                         
P00465*     ----------------------------------------------------------          
C30624        IF WS-CUST-EMAIL-PRESENT                                  
A01537           DISPLAY 'EMAIL PROCESSING ACC: ' WS-DISP-ACCOUNT-NO    
A01537           COMPUTE WS-NUM-ACCOUNTS-QUAL = WS-NUM-ACCOUNTS-QUAL + 1
C30624           MOVE WS-WELCOME-EMAIL-RES  TO AE-EMAIL-EVENT-CD        
C30624           MOVE AT-ACCOUNT-NO         TO AE-ACCOUNT-NO            
C30624           MOVE AT-COMPANY-NO         TO AE-COMPANY-NO            
C30624           MOVE AT-CUSTOMER-NO        TO AE-CUSTOMER-NO           
C30624           MOVE WS-COMMON-RUN-DATE    TO AE-EMAIL-EVENT-DT        
ACT070           PERFORM 7532-SET-NEXT-VALUE         THRU 7532-EXIT     
C30624           PERFORM 7535-INSERT-CSS-BATCH-EMAIL THRU 7535-EXIT     
C30624        END-IF                                                    
P00465     END-IF.                                                      
A01537*                                                                         
A01537     PERFORM 7010-FETCH-ACCOUNT      THRU 7010-EXIT.              
A01537*                                                                         
C30624 1100-EXIT.                                                       
C30624     EXIT.                                                        
A01537*                                                                         
A01537*****************************************************************         
A01537 2000-PROCESS-PMAIL-ACCOUNTS.                                     
A01537*****************************************************************         
A01537*                                                                         
A01537     PERFORM 7050-OPEN-WELCOME-ACCT   THRU 7050-EXIT              
A01537     PERFORM 7060-FETCH-WELCOME-ACCT  THRU 7060-EXIT              
A01537     PERFORM 2100-PROCESS-WELCOME-KIT THRU 2100-EXIT              
A01537        UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
A01537     PERFORM 7070-CLOSE-WELCOME-ACCT  THRU 7070-EXIT              
A01537     PERFORM 8200-UPDATE-PMAIL-JOB-PARM  THRU 8200-EXIT.          
A01537*                                                                         
A01537     DISPLAY ' '                                                  
A01537     DISPLAY '*********************************************'      
A01537     DISPLAY '** PMAIL PROCESS COMPLETED SUCCESSFULLY.   **'      
A01537     DISPLAY '** WELCOME KITS GENERATED FOR ACCOUNTS THAT**'      
A01537     DISPLAY '** CREATED ON: ' WS-SUCCESS-RUN-DATE                
A01537     DISPLAY '**                                         **'      
A01537     DISPLAY '** ACCOUNTS FETCHED: ' WS-NUMBER-AT-FETCHED         
A01537     DISPLAY '** ACCOUNTS QUALIFY: ' WS-NUM-ACCOUNTS-QUAL         
A01537     DISPLAY '** ELEC UTL QUALIFY: ' WS-NUMBER-EU-FETCHED         
A01537     DISPLAY '** GAS  UTL QUALIFY: ' WS-NUMBER-GU-FETCHED         
A01537     DISPLAY '** LIGHTS   QUALIFY: ' WS-NUMBER-LT-FETCHED         
A01537     DISPLAY '*********************************************'.     
A01537*                                                                         
A01537 2000-EXIT.                                                       
A01537     EXIT.                                                        
A01537*                                                                         
A01537*****************************************************************         
A01537*   GET ONLY RESIDENTIAL & COMMERCIAL SVCS BY CHECKING MIDDLE             
A01537*   DIGIT OF REV CLASS. SEND PAPER WELCOME KITS ONLY FOR SERVICES         
A01537*   ESTABLISHED NEWLY AND NOT EXISTS BEFORE FOR THE CUSTOMER.             
P00465*   THROUGH JCL WE ARE SORTING THE CUSTOMER ACCT TYPE                     
A01537*****************************************************************         
A01537 2100-PROCESS-WELCOME-KIT.                                        
A01537*                                                                         
A01537     COMPUTE WS-NUMBER-AT-FETCHED = WS-NUMBER-AT-FETCHED + 1.     
P00465     MOVE AT-CUSTOMER-NO             TO AE-CUSTOMER-NO            
P00465                                        CU-CUSTOMER-NO            
P00465     MOVE WS-WELCOME-EMAIL-RES       TO AE-EMAIL-EVENT-CD         
A01537     MOVE AT-ACCOUNT-NO              TO UT-ACCOUNT-NO             
                                              AE-ACCOUNT-NO             
A01537                                        WS-DISP-ACCOUNT-NO        
A01537     PERFORM 7410-OPEN-UTIL-ENVRNMT     THRU 7410-EXIT.           
A01537     PERFORM 7420-FETCH-UTIL-ENVRNMT    THRU 7420-EXIT.           
A01537*                                                                         
A01537     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
A01537        MOVE 0                  TO WS-SAME-CLASS-ACC-EXISTS       
A01537        PERFORM 7450-SELECT-SAME-CLASS THRU 7450-EXIT             
A01537        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
A01537           MOVE ZEROS           TO WS-AT-ACCOUNT-NO               
A01537           PERFORM 7460-SELECT-ONE-ACC    THRU 7460-EXIT          
A01537           IF WS-AT-ACCOUNT-NO = AT-ACCOUNT-NO                    
A01537              PERFORM 2200-GET-DETAILS      THRU 2200-EXIT        
A01537           END-IF                                                 
A01537        END-IF                                                    
A01537        PERFORM 7420-FETCH-UTIL-ENVRNMT  THRU 7420-EXIT           
A01537     END-PERFORM.                                                 
A01537*                                                                         
A01537     PERFORM 7430-CLOSE-UTIL-ENVRNMT  THRU 7430-EXIT.             
A01537     PERFORM 7060-FETCH-WELCOME-ACCT  THRU 7060-EXIT.             
A01537*                                                                         
A01537 2100-EXIT.                                                       
A01537     EXIT.                                                        
A01537*                                                                         
A01537*****************************************************************         
A01537 2200-GET-DETAILS.                                                
A01537*****************************************************************         
A01537*                                                                         
A01537     INITIALIZE NA-RECORD                                         
P00465                AE-PROCESSED-CD.                                  
A01537*                                                                         
A01537     MOVE '000'            TO CUST-CLASS-1.                       
A01537     MOVE '000'            TO CUST-CLASS-2.                       
A01537     MOVE '000'            TO CUST-CLASS-3.                       
A01537     MOVE SPACES           TO CUST-RATE-1.                        
A01537     MOVE SPACES           TO CUST-RATE-2.                        
A01537     MOVE SPACES           TO CUST-RATE-3.                        
P00465     MOVE SPACES           TO WS-EMAIL-BOUNCED-IND.               
A01537*                                                                         
P00465     MOVE WS-ELECTRIC                 TO UT-CODE-UTIL-TYPE.       
A01537     PERFORM 7115-CHECK-ELEC-GAS-UTIL THRU 7115-EXIT.             
A01537     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A01537        MOVE UT-CODE-REVENUE-CLASS    TO CUST-CLASS-1             
A01537        MOVE UT-RATE-PLAN-NO          TO CUST-RATE-1              
A01537        ADD +1                        TO WS-NUMBER-EU-FETCHED     
A01537     END-IF.                                                      
A01537                                                                  
P00465     IF AT-COMPANY-NO = WS-SCEG                                   
P00465        MOVE WS-GAS                      TO UT-CODE-UTIL-TYPE     
A01537        PERFORM 7115-CHECK-ELEC-GAS-UTIL THRU 7115-EXIT           
A01537        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
A01537           MOVE UT-CODE-REVENUE-CLASS    TO CUST-CLASS-2          
A01537           MOVE UT-RATE-PLAN-NO          TO CUST-RATE-2           
A01537           ADD +1                        TO WS-NUMBER-GU-FETCHED  
P00465        END-IF                                                    
P00465     ELSE                                                         
P00465*      -----------------------------------------------------------        
P00465*       PAPER WELCOME KIT FOR PSNC CUSTOMER-DIDN'T HAVE EMAIL ID /        
P00465*       DIDN'T OPT EMAIL OPTION AND EMAIL BOUNCED CUSTOMER.               
P00465*      -----------------------------------------------------------        
P00465        INITIALIZE CU-WELCOME-KIT-CD                              
P00465        PERFORM 7550-GET-E-WELCOME-KIT-FL  THRU 7550-EXIT         
P00465        IF CU-WELCOME-KIT-CD = WS-EMAIL-ONLY                      
P00465           PERFORM 7540-CHECK-EMAIL-STATUS  THRU 7540-EXIT        
P00465           MOVE AE-PROCESSED-CD    TO WS-EMAIL-BOUNCED-IND        
P00465        END-IF                                                    
P00465*                                                                         
P00465        IF (EMAIL-BOUNCED AND AT-ACCOUNT-TYPE-CODE                
P00465                                         NOT = WS-COMMERCIAL)     
P00465                 OR CU-WELCOME-KIT-CD NOT EQUAL WS-EMAIL-ONLY     
P00465           MOVE 'G'                   TO UT-CODE-UTIL-TYPE        
P00465           PERFORM 7115-CHECK-ELEC-GAS-UTIL THRU 7115-EXIT        
P00465           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
P00465              MOVE UT-CODE-REVENUE-CLASS                          
P00465                                      TO CUST-CLASS-2             
P00465              MOVE UT-RATE-PLAN-NO    TO CUST-RATE-2              
P00465              ADD +1                  TO WS-NUMBER-GU-FETCHED     
P00465           END-IF                                                 
P00465        END-IF                                                    
P00465     END-IF.                                                      
P00465*                                                                         
A01537     IF CUST-CLASS-TYPE-1 > '0' OR CUST-CLASS-TYPE-2 > 0          
A01537        CONTINUE                                                  
A01537     ELSE                                                         
A01537        PERFORM 7117-CHECK-LIGHT-UTIL      THRU 7117-EXIT         
A01537        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
A01537           MOVE UT-CODE-REVENUE-CLASS    TO CUST-CLASS-3          
A01537           MOVE UT-RATE-PLAN-NO          TO CUST-RATE-3           
A01537           ADD +1                   TO WS-NUMBER-LT-FETCHED       
A01537        END-IF                                                    
A01537     END-IF.                                                      
A01537*                                                                         
A01537     IF CUST-CLASS-TYPE-1 > '0' OR CUST-CLASS-TYPE-2 > 0          
A01537        OR CUST-CLASS-TYPE-3 > 0                                  
A01537        DISPLAY 'PMAIL PROCESSING ACC: ' WS-DISP-ACCOUNT-NO       
A01537        COMPUTE WS-NUM-ACCOUNTS-QUAL                              
A01537                   = WS-NUM-ACCOUNTS-QUAL + 1                     
P00465        PERFORM 2270-WRITE-PMAIL-FILE   THRU 2270-EXIT            
A01537     END-IF.                                                      
A01537*                                                                         
A01537 2200-EXIT.                                                       
A01537     EXIT.                                                        
A01537*                                                                         
P00465*----------------------------------------------------------------         
P00465*  PAPER WELCOME KIT MAIL CUSTOMER INFO WRITE INTO NA-RECORD FILE         
P00465*----------------------------------------------------------------         
P00465  2270-WRITE-PMAIL-FILE.                                          
A01537*                                                                         
A01537     PERFORM 4000-MAIL-NAME-ADDRESS      THRU 4000-EXIT           
A01537     PERFORM 2300-LOAD-NAME-AND-ADDRESS  THRU 2300-EXIT           
A01537*                                                                         
A01537     MOVE AT-LOCAL-OFFICE             TO B1-LOCAL-OFFICE          
A01537     MOVE AT-COMPANY-NO               TO B1-COMPANY-NO            
A01537     PERFORM 7400-SELECT-LOCAL-OFFICE    THRU 7400-EXIT           
A01537     MOVE B1-DISTRICT-NO              TO CUST-DISTRICT            
A01537*                                                                         
A01537     PERFORM 7500-SELECT-BILL-WINDOW     THRU 7500-EXIT           
A01537     MOVE BN-DATE-EXTRACT(6:2)        TO CUST-BILL-DATE(1:2)      
A01537     MOVE BN-DATE-EXTRACT(3:2)        TO CUST-BILL-DATE(3:2)      
A01537*                                                                         
A01537     MOVE AT-ACCOUNT-NO               TO DO-ACCOUNT-NO            
A01537     MOVE ZERO                        TO DO-AMT-DEPOSIT           
A01537                                         WS-NULL-DEPOSIT-AMT      
A01537     PERFORM 7520-SELECT-DEP-ON-HAND     THRU 7520-EXIT           
A01537     MOVE DO-AMT-DEPOSIT              TO CUST-DEPOSIT             
V01537*                                                                         
A01537     WRITE NA-RECORD.                                             
A01537                                                                  
A01537  2270-EXIT.                                                      
A01537      EXIT.                                                       
A01537******************************************************************        
A01537 2300-LOAD-NAME-AND-ADDRESS.                                      
A01537******************************************************************        
A01537*                                                                         
           MOVE WS-CUSTOMER-NAME       TO CUST-NAME.                    
           MOVE SPACES                  TO CUST-NAME-OVERFLOW.          
           IF WS-MAIL-ADDR-STREET NOT EQUAL SPACES                      
              MOVE WS-MAIL-ADDR-STREET         TO CUST-ADDRESS          
              MOVE WS-MAIL-ADDR-OVERFLOW       TO CUST-ADDRESS-OVERFLOW 
              MOVE WS-MAIL-ADDR-CITY-STATE-ZIP TO CUST-TOWN             
           ELSE                                                         
              MOVE WS-PR-STREET              TO CUST-ADDRESS            
              MOVE WS-PR-ADDR-OVERFLOW       TO CUST-ADDRESS-OVERFLOW   
              MOVE WS-PR-ADDR-CITY-STATE-ZIP TO CUST-TOWN               
           END-IF.                                                      
           MOVE AT-ACCOUNT-NO       TO CUST-ACCOUNT-NO.                 
           MOVE AT-BILL-CYCLE       TO CUST-CYCLE.                      
           MOVE AT-LOCAL-OFFICE     TO CUST-LOCAL-OFFICE.               
C24086     MOVE AT-COMPANY-NO       TO CUST-COMPANY-NO.                 
C36330     MOVE AT-CUSTOMER-NO      TO CUST-NUMBER.                     
A01537*                                                                         
A01537 2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      /*** COPYBOOK CPD00074 IS INSERTED HERE TO LOAD NAME AND ADDRESS.         
      **** 4000-MAIL-NAME-ADDRESS                                               
      ******************************                                            
           EXEC SQL                                                             
                INCLUDE CPD00074                                                
           END-EXEC.                                                            
      *                                                                         
                                                                        
      /*** COPYBOOK CPD00074 ENDS HERE.                                         
      **** FROM 4000-MAIL-NAME-ADDRESS TO 4095-.                                
                                                                        
      /*** COPYBOOK CPD00004 IS INSERTED HERE TO REDUCE EMBEDDED SPACES.        
      **** 6010-REDUCE-EMBEDDED-SPACES.                                         
           COPY CPD00004.                                                       
      *                                                                         
      /*** COPYBOOK CPD00004 ENDS HERE.                                         
      **** FROM 6010-REDUCE-EMBEDDED-SPACES TO 6011-.                           
                                                                        
A01537/*** COPYBOOK CPD00315 IS INSERTED HERE TO GET PREV BUSINESS DAY.         
A01537**** 6525-PREV-BUSINESS-DAY.                                              
A01537     EXEC SQL                                                             
A01537          INCLUDE CPD00315                                                
A01537     END-EXEC.                                                            
A01537*                                                                         
A01537/*** COPYBOOK CPD00315 ENDS HERE.                                         
                                                                        
      /*** GET FCA00 COMMON DATE. 6240-GET-FCA00-COMMON-DATE.                   
           COPY CPD00040.                                                       
                                                                        
      /*** READ PARM FILE FOR OVERRIDE DATE. 6251-GET-FJC01-DATE.               
           COPY CPD00037.                                                       
      *                                                                         
      ******************************************************************        
       7000-OPEN-ACCOUNT.                                               
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
                OPEN ACCOUNT_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01537*                                                                         
A01537     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
A01537*                                                                         
A01537     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A01537        CONTINUE                                                  
A01537     ELSE                                                         
A01537        DISPLAY '*****************************************'       
A01537        DISPLAY 'ERROR OPENING ACCOUNT_CUR CURSOR'                
              DISPLAY '7000-OPEN-ACCOUNT PARA'                          
A01537        DISPLAY 'CODE_ACCT_STAT      =  A'                        
A01537        DISPLAY 'DATE_UTIL_SVC_STRT >=' WS-L-EMAIL-RUN-DATE       
A01537        DISPLAY 'DATE_UTIL_SVC_STRT < ' WS-COMMON-RUN-DATE        
A01537        DISPLAY 'SQLCODE ', SQLCODE                               
A01537        DISPLAY '*****************************************'       
              PERFORM 9900-ABEND             THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
       7010-FETCH-ACCOUNT.                                              
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               FETCH ACCOUNT_CUR                                        
                 INTO :AT-ACCOUNT-NO,                                   
                      :AT-LOCAL-OFFICE,                                 
C24086                :AT-COMPANY-NO,                                   
                      :AT-BILL-CYCLE,                                   
                      :AT-ADDRESS-ID,                                   
                      :AT-ADDRESS-FORMAT,                               
C30624                :AT-CUSTOMER-NO,                                  
P00465                :AT-ACCT-CREATE-DT,                               
P00465                :AT-ACCOUNT-TYPE-CODE                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01537*                                                                         
A01537     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
A01537*                                                                         
A01537     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A01537        CONTINUE                                                  
A01537     ELSE                                                         
A01537        DISPLAY '*****************************************'       
A01537        DISPLAY 'ERROR FETCHING ACCOUNT_CUR CURSOR'               
              DISPLAY '7010-FETCH-ACCOUNT PARA'                         
A01537        DISPLAY 'CODE_ACCT_STAT      =  A'                        
A01537        DISPLAY 'DATE_UTIL_SVC_STRT >=' WS-L-EMAIL-RUN-DATE       
A01537        DISPLAY 'DATE_UTIL_SVC_STRT < ' WS-COMMON-RUN-DATE        
A01537        DISPLAY 'SQLCODE ', SQLCODE                               
A01537        DISPLAY '*****************************************'       
              PERFORM 9900-ABEND             THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
       7020-CLOSE-ACCOUNT.                                              
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
                CLOSE ACCOUNT_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01537*                                                                         
A01537     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
A01537*                                                                         
A01537     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A01537        CONTINUE                                                  
A01537     ELSE                                                         
A01537        DISPLAY '*****************************************'       
A01537        DISPLAY 'ERROR CLOSING ACCOUNT_CUR CURSOR'                
              DISPLAY '7020-CLOSE-ACCOUNT PARA'                         
              DISPLAY 'SQLCODE ', SQLCODE                               
A01537        DISPLAY '*****************************************'       
              PERFORM 9900-ABEND             THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
A01537*                                                                         
A01537*****************************************************************         
A01537 7050-OPEN-WELCOME-ACCT.                                          
A01537*****************************************************************         
A01537                                                                  
A01537     EXEC SQL                                                     
A01537          OPEN WELCOME_KIT_CUR                                    
A01537     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01537*                                                                         
A01537     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
A01537*                                                                         
A01537     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A01537        CONTINUE                                                  
A01537     ELSE                                                         
A01537        DISPLAY '*****************************************'       
A01537        DISPLAY 'ERROR OPENING WELCOME_KIT_CUR CURSOR'            
A01537        DISPLAY ' 7050-OPEN-WELCOME-ACCT PARA'                    
A01537        DISPLAY 'DATE_UTIL_SVC_STRT >=' WS-L-PMAIL-RUN-DATE       
A01537        DISPLAY 'DATE_UTIL_SVC_STRT < ' WS-NEW-BUSINESS-DAY       
A01537        DISPLAY 'SQLCODE ', SQLCODE                               
A01537        DISPLAY '*****************************************'       
A01537        PERFORM 9900-ABEND             THRU 9900-EXIT             
A01537     END-IF.                                                      
A01537*                                                                         
A01537 7050-EXIT.                                                       
A01537     EXIT.                                                        
A01537*                                                                         
A01537*****************************************************************         
A01537 7060-FETCH-WELCOME-ACCT.                                         
A01537*****************************************************************         
A01537*                                                                         
A01537     EXEC SQL                                                     
A01537         FETCH WELCOME_KIT_CUR                                    
A01537           INTO :AT-ACCOUNT-NO                                    
A01537               ,:AT-LOCAL-OFFICE                                  
A01537               ,:AT-COMPANY-NO                                    
A01537               ,:AT-BILL-CYCLE                                    
A01537               ,:AT-ADDRESS-ID                                    
A01537               ,:AT-ADDRESS-FORMAT                                
A01537               ,:AT-CUSTOMER-NO                                   
A01537               ,:AT-ACCT-CREATE-DT                                
P00465               ,:AT-ACCOUNT-TYPE-CODE                             
A01537     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01537*                                                                         
A01537     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
A01537*                                                                         
A01537     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A01537        CONTINUE                                                  
A01537     ELSE                                                         
A01537        DISPLAY '*****************************************'       
A01537        DISPLAY 'ERROR FETCHING WELCOME_KIT_CUR CURSOR'           
A01537        DISPLAY ' 7060-FETCH-WELCOME-ACCT PARA'                   
A01537        DISPLAY 'DATE_UTIL_SVC_STRT >=' WS-L-PMAIL-RUN-DATE       
A01537        DISPLAY 'DATE_UTIL_SVC_STRT < ' WS-NEW-BUSINESS-DAY       
A01537        DISPLAY 'SQLCODE ', SQLCODE                               
A01537        DISPLAY '*****************************************'       
A01537        PERFORM 9900-ABEND             THRU 9900-EXIT             
A01537     END-IF.                                                      
A01537*                                                                         
A01537 7060-EXIT.                                                       
A01537     EXIT.                                                        
A01537*                                                                         
A01537*****************************************************************         
A01537 7070-CLOSE-WELCOME-ACCT.                                         
A01537*****************************************************************         
A01537*                                                                         
A01537     EXEC SQL                                                     
A01537          CLOSE WELCOME_KIT_CUR                                   
A01537     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01537*                                                                         
A01537     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
A01537*                                                                         
A01537     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A01537        CONTINUE                                                  
A01537     ELSE                                                         
A01537        DISPLAY '*****************************************'       
A01537        DISPLAY 'ERROR CLOSING WELCOME_KIT_ACC CURSOR     '       
A01537        DISPLAY ' 7070-CLOSE-WELCOME-ACCT PARA'                   
A01537        DISPLAY 'SQLCODE ', SQLCODE                               
A01537        DISPLAY '*****************************************'       
A01537        PERFORM 9900-ABEND             THRU 9900-EXIT             
A01537     END-IF.                                                      
A01537*                                                                         
A01537 7070-EXIT.                                                       
A01537     EXIT.                                                        
A01537*                                                                         
P00465*****************************************************************         
P00465* 7100-CHK-SECURED-RATE-FL.                                     *         
P00465*****************************************************************         
P00465 7100-CHK-SECURED-RATE-FL.                                        
P00465                                                                  
P00465     EXEC SQL                                                     
P00465        SELECT TOP(1) 'Y'                                                
P00465        INTO :WS-RATE-SECURED                                     
P00465        FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                         
P00465            ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                    
P00465            ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                  
P00465        WHERE AT.ACCOUNT_NO      = :AT-ACCOUNT-NO                 
P00465          AND AT.CUSTOMER_NO     = :AT-CUSTOMER-NO                
P00465          AND AT.ACCOUNT_NO      = UT.ACCOUNT_NO                  
P00465          AND UT.CODE_UTIL_TYPE  = RD.CODE_UTIL_TYPE              
P00465          AND UT.RATE_PLAN_NO    = RD.RATE_PLAN_NO                
P00465          AND AT.COMPANY_NO      = :AT-COMPANY-NO                 
P00465          AND RD.SECURED_RATE_FL =  'Y'                           
P00465                                                           
P00465                                           
P00465                                                      
P00465     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*       INTO :WS-RATE-SECURED                                             
MFA-TR*       FROM CSS_ACCOUNT AT                                               
MFA-TR*           ,CSS_UTIL_ENVRNMT UT                                          
MFA-TR*           ,CSS_RATE_PLAN_DESC RD                                        
MFA-TR*       WHERE AT.ACCOUNT_NO      = :AT-ACCOUNT-NO                         
MFA-TR*         AND AT.CUSTOMER_NO     = :AT-CUSTOMER-NO                        
MFA-TR*         AND AT.ACCOUNT_NO      = UT.ACCOUNT_NO                          
MFA-TR*         AND UT.CODE_UTIL_TYPE  = RD.CODE_UTIL_TYPE                      
MFA-TR*         AND UT.RATE_PLAN_NO    = RD.RATE_PLAN_NO                        
MFA-TR*         AND AT.COMPANY_NO      = :AT-COMPANY-NO                         
MFA-TR*         AND RD.SECURED_RATE_FL =  'Y'                                   
MFA-TR*        WITH UR                                                          
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00465*                                                                         
P00465     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00465*                                                                         
P00465     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00465         CONTINUE                                                 
P00465     ELSE                                                         
P00465         DISPLAY '*****************************************'      
P00465         DISPLAY 'ERROR SELECTING SECURED RATE '                  
P00465         DISPLAY '7100-CHK-SECURED-RATE-FL     '                  
P00465         DISPLAY 'SQLCODE ', SQLCODE                              
P00465         DISPLAY 'ACCOUNT_NO     ' AT-ACCOUNT-NO                  
P00465         DISPLAY 'CUSTOMER_NO    ' AT-CUSTOMER-NO                 
P00465         DISPLAY '*****************************************'      
P00465         PERFORM 9900-ABEND          THRU 9900-EXIT               
P00465     END-IF.                                                      
P00465                                                                  
P00465 7100-EXIT.                                                       
P00465     EXIT.                                                        
      *                                                                         
A01537*****************************************************************         
A01537 7115-CHECK-ELEC-GAS-UTIL.                                        
A01537*****************************************************************         
A01537*                                                                         
A01537     EXEC SQL                                                     
A01537        SELECT TOP(1) UT.CODE_REVENUE_CLASS,
              UT.RATE_PLAN_NO                                    
A01537         INTO :UT-CODE-REVENUE-CLASS                              
A01537             ,:UT-RATE-PLAN-NO                                    
A01537        FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                    
A01537            ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                    
A01537        WHERE UT.ACCOUNT_NO      = :UT-ACCOUNT-NO                 
A01537          AND UT.CODE_UTIL_TYPE  = :UT-CODE-UTIL-TYPE             
A01537          AND UT.ACCOUNT_NO      = MN.ACCOUNT_NO                  
A01537          AND UT.CODE_UTIL_TYPE  = MN.CODE_UTIL_TYPE              
A01537          AND UT.IC_NO           = MN.IC_NO                       
A01537          AND CIS.SUBSTR3(UT.CODE_REVENUE_CLASS, 2, 1)                 
A01537                                 = :WS-CODE-REV-CLASS             
A01537          AND MN.CODE_METER_STATUS <> 'K'                         
A01537                                       
A01537     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UT.CODE_REVENUE_CLASS                                      
MFA-TR*             ,UT.RATE_PLAN_NO                                            
MFA-TR*        INTO :UT-CODE-REVENUE-CLASS                                      
MFA-TR*            ,:UT-RATE-PLAN-NO                                            
MFA-TR*       FROM CSS_UTIL_ENVRNMT UT                                          
MFA-TR*           ,CSS_MTRD_ENVRNMT MN                                          
MFA-TR*       WHERE UT.ACCOUNT_NO      = :UT-ACCOUNT-NO                         
MFA-TR*         AND UT.CODE_UTIL_TYPE  = :UT-CODE-UTIL-TYPE                     
MFA-TR*         AND UT.ACCOUNT_NO      = MN.ACCOUNT_NO                          
MFA-TR*         AND UT.CODE_UTIL_TYPE  = MN.CODE_UTIL_TYPE                      
MFA-TR*         AND UT.IC_NO           = MN.IC_NO                               
MFA-TR*         AND SUBSTR(UT.CODE_REVENUE_CLASS, 2, 1)                         
MFA-TR*                                = :WS-CODE-REV-CLASS                     
MFA-TR*         AND MN.CODE_METER_STATUS <> 'K'                                 
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01537*                                                                         
A01537     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
A01537*                                                                         
A01537     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A01537         CONTINUE                                                 
A01537     ELSE                                                         
A01537         DISPLAY '*****************************************'      
A01537         DISPLAY 'ERROR SELECTING MTRD_ENVRNMT '                  
A01537         DISPLAY '7115-CHECK-ELEC-GAS-UTIL     '                  
A01537         DISPLAY 'SQLCODE ', SQLCODE                              
A01537         DISPLAY 'ACCOUNT_NO     ' UT-ACCOUNT-NO                  
A01537         DISPLAY 'CODE_UITL_TYPE ' UT-CODE-UTIL-TYPE              
A01537         DISPLAY '*****************************************'      
A01537         PERFORM 9900-ABEND          THRU 9900-EXIT               
A01537     END-IF.                                                      
A01537                                                                  
A01537 7115-EXIT.                                                       
A01537     EXIT.                                                        
A01537*                                                                         
A01537*****************************************************************         
A01537 7117-CHECK-LIGHT-UTIL.                                           
A01537*****************************************************************         
A01537*                                                                         
A01537     EXEC SQL                                                     
A01537        SELECT TOP(1) UT.CODE_UTIL_TYPE,
              UT.CODE_REVENUE_CLASS,
              UT.RATE_PLAN_NO                                    
A01537         INTO :UT-CODE-UTIL-TYPE                                  
A01537             ,:UT-CODE-REVENUE-CLASS                              
A01537             ,:UT-RATE-PLAN-NO                                    
A01537        FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                    
A01537            ,CSS_CUST_PLAN    CP WITH(READUNCOMMITTED)                    
A01537        WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                  
A01537          AND UT.ACCOUNT_NO     = CP.ACCOUNT_NO                   
A01537          AND UT.IC_NO          = CP.IC_NO                        
A01537          AND UT.CODE_UTIL_TYPE = CP.CODE_UTIL_TYPE               
A01537          AND CIS.SUBSTR3(UT.CODE_REVENUE_CLASS, 2, 1)                 
A01537                                 = :WS-CODE-REV-CLASS             
A01537          AND CP.CODE_PLAN_STATUS  = 'A'                          
A01537                                       
A01537     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UT.CODE_UTIL_TYPE                                          
MFA-TR*             ,UT.CODE_REVENUE_CLASS                                      
MFA-TR*             ,UT.RATE_PLAN_NO                                            
MFA-TR*        INTO :UT-CODE-UTIL-TYPE                                          
MFA-TR*            ,:UT-CODE-REVENUE-CLASS                                      
MFA-TR*            ,:UT-RATE-PLAN-NO                                            
MFA-TR*       FROM CSS_UTIL_ENVRNMT UT                                          
MFA-TR*           ,CSS_CUST_PLAN    CP                                          
MFA-TR*       WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                          
MFA-TR*         AND UT.ACCOUNT_NO     = CP.ACCOUNT_NO                           
MFA-TR*         AND UT.IC_NO          = CP.IC_NO                                
MFA-TR*         AND UT.CODE_UTIL_TYPE = CP.CODE_UTIL_TYPE                       
MFA-TR*         AND SUBSTR(UT.CODE_REVENUE_CLASS, 2, 1)                         
MFA-TR*                                = :WS-CODE-REV-CLASS                     
MFA-TR*         AND CP.CODE_PLAN_STATUS  = 'A'                                  
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01537*                                                                         
A01537     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
A01537*                                                                         
A01537     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A01537         CONTINUE                                                 
A01537     ELSE                                                         
A01537         DISPLAY '*****************************************'      
A01537         DISPLAY 'ERROR SELECTING CUST_PLAN       '               
A01537         DISPLAY '7117-CHECK-LIGHT-UTIL           '               
A01537         DISPLAY 'ACCOUNT_NO     ' UT-ACCOUNT-NO                  
A01537         DISPLAY 'SQLCODE ', SQLCODE                              
A01537         DISPLAY '*****************************************'      
A01537         PERFORM 9900-ABEND          THRU 9900-EXIT               
A01537     END-IF.                                                      
A01537*                                                                         
A01537 7117-EXIT.                                                       
A01537     EXIT.                                                        
A01537*****************************************************************         
       7400-SELECT-LOCAL-OFFICE.                                        
A01537*****************************************************************         
A01537*                                                                         
           EXEC SQL                                                     
               SELECT DISTRICT_NO                                       
                 INTO :B1-DISTRICT-NO                                   
                 FROM CSS_LOCAL_OFFICE WITH(READUNCOMMITTED)                    
C24086           WHERE COMPANY_NO      = :B1-COMPANY-NO                 
                   AND LOCAL_OFFICE    = :B1-LOCAL-OFFICE               
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DISTRICT_NO                                               
MFA-TR*          INTO :B1-DISTRICT-NO                                           
MFA-TR*          FROM CSS_LOCAL_OFFICE                                          
MFA-TR*          WHERE COMPANY_NO      = :B1-COMPANY-NO                         
MFA-TR*            AND LOCAL_OFFICE    = :B1-LOCAL-OFFICE                       
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01537*                                                                         
A01537     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
A01537*                                                                         
A01537     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A01537        CONTINUE                                                  
A01537     ELSE                                                         
A01537        DISPLAY '*****************************************'       
              DISPLAY 'ERROR FOR SELECT FOR CSS_LOCAL_OFFICE'           
              DISPLAY 'SQLCODE ', SQLCODE                               
C24086        DISPLAY 'COMPANY NO  : ', B1-COMPANY-NO                   
              DISPLAY 'LOCAL OFFICE: ', B1-LOCAL-OFFICE                 
A01537        DISPLAY '*****************************************'       
              PERFORM 9900-ABEND             THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
A01537*                                                                         
A01537******************************************************************        
A01537 7410-OPEN-UTIL-ENVRNMT.                                          
A01537******************************************************************        
A01537*                                                                         
A01537     EXEC SQL                                                     
A01537          OPEN UTIL_CLASS                                         
A01537     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01537*                                                                         
A01537     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
A01537*                                                                         
A01537     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A01537        CONTINUE                                                  
A01537     ELSE                                                         
A01537        DISPLAY '*****************************************'       
A01537        DISPLAY 'ERROR OPENING UTIL_CLASS CURSOR'                 
A01537        DISPLAY 'ACCOUNT_NO     ' UT-ACCOUNT-NO                   
A01537        DISPLAY 'SQLCODE ', SQLCODE                               
A01537        DISPLAY '*****************************************'       
A01537        PERFORM 9900-ABEND             THRU 9900-EXIT             
A01537     END-IF.                                                      
A01537*                                                                         
A01537 7410-EXIT.                                                       
A01537     EXIT.                                                        
A01537*                                                                         
A01537******************************************************************        
A01537 7420-FETCH-UTIL-ENVRNMT.                                         
A01537******************************************************************        
A01537*                                                                         
A01537     EXEC SQL                                                     
A01537         FETCH UTIL_CLASS                                         
A01537           INTO :WS-CODE-REV-CLASS                                
A01537     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01537*                                                                         
A01537     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
A01537*                                                                         
A01537     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A01537        CONTINUE                                                  
A01537     ELSE                                                         
A01537        DISPLAY '*****************************************'       
A01537        DISPLAY 'ERROR FETCHING UTIL_CLASS CURSOR'                
A01537        DISPLAY ' 7420-FETCH-UTIL-ENVRNMT PARA'                   
A01537        DISPLAY 'ACCOUNT_NO ' UT-ACCOUNT-NO                       
A01537        DISPLAY 'SQLCODE ', SQLCODE                               
A01537        DISPLAY '*****************************************'       
A01537        PERFORM 9900-ABEND             THRU 9900-EXIT             
A01537     END-IF.                                                      
A01537*                                                                         
A01537 7420-EXIT.                                                       
A01537     EXIT.                                                        
A01537*                                                                         
A01537******************************************************************        
A01537 7430-CLOSE-UTIL-ENVRNMT.                                         
A01537******************************************************************        
A01537*                                                                         
A01537     EXEC SQL                                                     
A01537          CLOSE UTIL_CLASS                                        
A01537     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01537*                                                                         
A01537     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
A01537*                                                                         
A01537     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A01537        CONTINUE                                                  
A01537     ELSE                                                         
A01537        DISPLAY '*****************************************'       
A01537        DISPLAY 'ERROR CLOSING UTIL_CLASS CURSOR'                 
A01537        DISPLAY ' 7430-CLOSE-UTIL-ENVRNMT PARA'                   
A01537        DISPLAY 'SQLCODE ', SQLCODE                               
A01537        DISPLAY '*****************************************'       
A01537        PERFORM 9900-ABEND             THRU 9900-EXIT             
A01537     END-IF.                                                      
A01537*                                                                         
A01537 7430-EXIT.                                                       
A01537     EXIT.                                                        
A01537*                                                                         
A01537******************************************************************        
A01537 7450-SELECT-SAME-CLASS.                                          
A01537******************************************************************        
A01537*                                                                         
A01537     EXEC SQL                                                     
A01537     SELECT TOP(1) 1                                                     
A01537       INTO :WS-SAME-CLASS-ACC-EXISTS                             
A01537       FROM CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                     
A01537           ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                     
A01537       WHERE AT.CUSTOMER_NO        = :AT-CUSTOMER-NO              
A01537         AND AT.ACCT_CREATE_DT     <  CIS.CHAR2TIMESTAMP(
                                                     :AT-ACCT-CREATE-DT
              )          
A01537         AND AT.ACCOUNT_TYPE_CODE <> 'N'                          
A01537         AND AT.ACCOUNT_NO         = UT.ACCOUNT_NO                
A*5146         AND AT.COMPANY_NO         = :AT-COMPANY-NO               
A01537         AND CIS.SUBSTR3(CODE_REVENUE_CLASS, 2, 1) = 
                                                     :WS-CODE-REV-CLASS
A01537                                       
A01537     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*    SELECT 1                                                             
MFA-TR*      INTO :WS-SAME-CLASS-ACC-EXISTS                                     
MFA-TR*      FROM CSS_ACCOUNT      AT                                           
MFA-TR*          ,CSS_UTIL_ENVRNMT UT                                           
MFA-TR*      WHERE AT.CUSTOMER_NO        = :AT-CUSTOMER-NO                      
MFA-TR*        AND AT.ACCT_CREATE_DT     <  :AT-ACCT-CREATE-DT                  
MFA-TR*        AND AT.ACCOUNT_TYPE_CODE <> 'N'                                  
MFA-TR*        AND AT.ACCOUNT_NO         = UT.ACCOUNT_NO                        
MFA-TR*        AND AT.COMPANY_NO         = :AT-COMPANY-NO                       
MFA-TR*        AND SUBSTR(CODE_REVENUE_CLASS, 2, 1) = :WS-CODE-REV-CLASS        
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01537*                                                                         
A01537     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
A01537*                                                                         
A01537     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A01537        CONTINUE                                                  
A01537     ELSE                                                         
A01537        DISPLAY '*****************************************'       
A01537        DISPLAY 'ERROR FOR 7450-SELECT-SAME-CLASS    '            
A01537        DISPLAY 'CUSTOMER NO    ', AT-CUSTOMER-NO                 
A01537        DISPLAY 'CREATE DATE    ', AT-ACCT-CREATE-DT              
A01537        DISPLAY 'CODE REV CLASS ', WS-CODE-REV-CLASS              
A01537        DISPLAY 'SQLCODE ', SQLCODE                               
A01537        DISPLAY '*****************************************'       
A01537        PERFORM 9900-ABEND             THRU 9900-EXIT             
A01537     END-IF.                                                      
A01537*                                                                         
A01537 7450-EXIT.                                                       
A01537     EXIT.                                                        
A01537*                                                                         
A01537******************************************************************        
A01537 7460-SELECT-ONE-ACC.                                             
A01537******************************************************************        
A01537*                                                                         
A01537     EXEC SQL                                                     
A01537     SELECT TOP(1) AT.ACCOUNT_NO                                         
A01537       INTO :WS-AT-ACCOUNT-NO                                     
A01537       FROM CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                     
A01537           ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                     
A01537       WHERE AT.CUSTOMER_NO        = :AT-CUSTOMER-NO              
A01537         AND AT.ACCT_CREATE_DT     =  CIS.CHAR2TIMESTAMP(
                                                     :AT-ACCT-CREATE-DT
              )          
A01537         AND AT.ACCOUNT_TYPE_CODE <> 'N'                          
A01537         AND AT.ACCOUNT_NO         = UT.ACCOUNT_NO                
A01537         AND CIS.SUBSTR3(CODE_REVENUE_CLASS, 2, 1) = 
                                                     :WS-CODE-REV-CLASS
A01537         ORDER BY AT.ACCOUNT_NO                                   
A01537                                       
A01537     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*    SELECT AT.ACCOUNT_NO                                                 
MFA-TR*      INTO :WS-AT-ACCOUNT-NO                                             
MFA-TR*      FROM CSS_ACCOUNT      AT                                           
MFA-TR*          ,CSS_UTIL_ENVRNMT UT                                           
MFA-TR*      WHERE AT.CUSTOMER_NO        = :AT-CUSTOMER-NO                      
MFA-TR*        AND AT.ACCT_CREATE_DT     =  :AT-ACCT-CREATE-DT                  
MFA-TR*        AND AT.ACCOUNT_TYPE_CODE <> 'N'                                  
MFA-TR*        AND AT.ACCOUNT_NO         = UT.ACCOUNT_NO                        
MFA-TR*        AND SUBSTR(CODE_REVENUE_CLASS, 2, 1) = :WS-CODE-REV-CLASS        
MFA-TR*        ORDER BY AT.ACCOUNT_NO                                           
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01537*                                                                         
A01537     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
A01537*                                                                         
A01537     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A01537        CONTINUE                                                  
A01537     ELSE                                                         
A01537        DISPLAY '*****************************************'       
A01537        DISPLAY 'ERROR FOR 7460-SELECT-ONE-ACC       '            
A01537        DISPLAY 'CUSTOMER NO    ', AT-CUSTOMER-NO                 
A01537        DISPLAY 'CREATE DATE    ', AT-ACCT-CREATE-DT              
A01537        DISPLAY 'CODE REV CLASS ', WS-CODE-REV-CLASS              
A01537        DISPLAY 'SQLCODE ', SQLCODE                               
A01537        DISPLAY '*****************************************'       
A01537        PERFORM 9900-ABEND             THRU 9900-EXIT             
A01537     END-IF.                                                      
A01537*                                                                         
A01537 7460-EXIT.                                                       
A01537     EXIT.                                                        
A01537*                                                                         
A01537*****************************************************************         
       7500-SELECT-BILL-WINDOW.                                         
A01537*****************************************************************         
A01537*                                                                         
           EXEC SQL                                                     
               SELECT MIN(DATE_EXTRACT)                                 
                 INTO :BN-DATE-EXTRACT                                  
                 FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                     
                 WHERE DATE_EXTRACT >= IIF(TRY_CONVERT(DATE, 
                                                   :WS-L-PMAIL-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-L-PMAIL-RUN-DATE
              ) <> 0) OR (LEN(:WS-L-PMAIL-RUN-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-L-PMAIL-RUN-DATE
              ), CONVERT(DATE, :WS-L-PMAIL-RUN-DATE) )             
                   AND BILL_CYCLE    = :AT-BILL-CYCLE                   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MIN(DATE_EXTRACT)                                         
MFA-TR*          INTO :BN-DATE-EXTRACT                                          
MFA-TR*          FROM CSS_BILL_WINDOW                                           
MFA-TR*          WHERE DATE_EXTRACT >= :WS-L-PMAIL-RUN-DATE                     
MFA-TR*            AND BILL_CYCLE    = :AT-BILL-CYCLE                           
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01537*                                                                         
A01537     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
A01537*                                                                         
A01537     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A01537        CONTINUE                                                  
A01537     ELSE                                                         
A01537        DISPLAY '*****************************************'       
              DISPLAY 'ERROR FOR SELECT FOR CSS_BILL_WINDOW'            
              DISPLAY 'SQLCODE ', SQLCODE                               
              DISPLAY 'BILL CYCLE: ', AT-BILL-CYCLE                     
              DISPLAY 'DATE EXTRACT: ', WS-L-PMAIL-RUN-DATE             
A01537        DISPLAY '*****************************************'       
              PERFORM 9900-ABEND             THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A01537*****************************************************************         
       7520-SELECT-DEP-ON-HAND.                                         
A01537*****************************************************************         
A01537*                                                                         
           EXEC SQL                                                     
               SELECT SUM(AMT_DEPOSIT)                                  
                 INTO :DO-AMT-DEPOSIT :WS-NULL-DEPOSIT-AMT               
                 FROM CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO       = :DO-ACCOUNT-NO                 
                  AND DEPOSIT_STATUS_CD = 'A'                           
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_DEPOSIT)                                          
MFA-TR*          INTO :DO-AMT-DEPOSIT:WS-NULL-DEPOSIT-AMT                       
MFA-TR*          FROM CSS_DEP_ON_HAND                                           
MFA-TR*         WHERE ACCOUNT_NO       = :DO-ACCOUNT-NO                         
MFA-TR*           AND DEPOSIT_STATUS_CD = 'A'                                   
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01537*                                                                         
A01537     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
A01537*                                                                         
A01537     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A01537        CONTINUE                                                  
A01537     ELSE                                                         
A01537        DISPLAY '*****************************************'       
              DISPLAY 'ERROR FOR SELECT FOR CSS_DEP_ON_HAND'            
              DISPLAY 'SQLCODE ', SQLCODE                               
              DISPLAY 'ACCOUNT NO: ', DO-ACCOUNT-NO                     
A01537        DISPLAY '*****************************************'       
              PERFORM 9900-ABEND             THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
C30624******************************************************************        
C30624**  RETRIEVE CUSTOMER EMAIL INFO IF PRESENT.                    **        
C30624******************************************************************        
C30624 7530-SELECT-CSS-CUST-EMAIL.                                      
C30624******************************************************************        
      *                                                                         
C30624     EXEC SQL                                                     
C30624          SELECT TOP(1) 'Y'                                              
C30624            INTO :WS-CUST-EMAIL-IND                               
C30624            FROM CSS_CUST_EMAIL NE WITH(READUNCOMMITTED)                  
C30624           WHERE NE.CUSTOMER_NO = :NE-CUSTOMER-NO                 
P00465           AND CIS.SUBSTR3(
           NE.EMAIL_ADDRESS_TX,1,1) NOT IN ('*' , ' ') 
                                             
C30624     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-CUST-EMAIL-IND                                       
MFA-TR*           FROM CSS_CUST_EMAIL NE                                        
MFA-TR*          WHERE NE.CUSTOMER_NO = :NE-CUSTOMER-NO                         
MFA-TR*          AND SUBSTR(NE.EMAIL_ADDRESS_TX,1,1) NOT IN ('*' , ' ')         
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01537*                                                                         
A01537     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
A01537*                                                                         
A01537     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A01537         CONTINUE                                                 
A01537     ELSE                                                         
A01537        DISPLAY '*****************************************'       
C30624        DISPLAY 'PARA 7530-SELECT-CSS-CUST-EMAIL'                 
C30624        DISPLAY 'ERROR FOR SELECT FOR CSS_CUST_EMAIL'             
C30624        DISPLAY 'SQLCODE ', SQLCODE                               
C30624        DISPLAY 'ACCOUNT NO: ', AT-ACCOUNT-NO                     
C30624        DISPLAY 'CUSTOMER NO: ', NE-CUSTOMER-NO                   
A01537        DISPLAY '*****************************************'       
C30624        PERFORM 9900-ABEND             THRU 9900-EXIT             
C30624     END-IF.                                                      
                                                                        
C30624 7530-EXIT.                                                       
C30624     EXIT.                                                        
                                                                        
ACT070*****************************************************************         
ACT070*   SET NET VALUE FOR BATCH-EMAIL-ID                            *         
ACT070*****************************************************************         
ACT070 7532-SET-NEXT-VALUE.                                             
      *                                                                         
ACT070     EXEC SQL                                                     
ACT070        SELECT
              NEXT VALUE FOR SEQ_AE_BATCH_EMAIL_ID
            INTO
              :AE-BATCH-EMAIL-ID
ACT070     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ048
MFA-TR*    EXEC SQL                                                     07457000
MFA-TR*       SET :AE-BATCH-EMAIL-ID = NEXTVAL FOR SEQ_AE_BATCH_EMAIL_ID07458000
MFA-TR*    END-EXEC.                                                    07464000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
ACT070     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
ACT070     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT070        CONTINUE                                                  
ACT070     ELSE                                                         
ACT070        DISPLAY '***  ERROR IN PARA #: ' WS-ACTIVE-PARAGRAPH      
ACT070        DISPLAY '***   PARAGRAPH DESC: SET-NEXT-VALUE'            
ACT070        DISPLAY '***AE-BATCH-EMAIL-ID: ' AE-BATCH-EMAIL-ID        
ACT070        DISPLAY '***      RETURN CODE: ' WS-ACTIVE-RETURN-CODE    
ACT070        DISPLAY '***      PROCESSING TERMINATED     ***'          
ACT070        PERFORM 9900-ABEND                THRU 9900-EXIT          
ACT070     END-IF.                                                      
                                                                        
      *                                                                         
ACT070 7532-EXIT.                                                       
ACT070     EXIT.                                                        
      *                                                                 12950000
      ******************************************************************08079400
C30624******************************************************************        
C30624**  INSERT INTO CSS_BATCH_EMAIL.                                **        
C30624******************************************************************        
C30624 7535-INSERT-CSS-BATCH-EMAIL.                                     
C30624******************************************************************        
      *                                                                         
C30624     EXEC SQL                                                     
C30624          INSERT INTO CSS_BATCH_EMAIL                             
C30624                 (ACCOUNT_NO                                      
C30624                 ,CUSTOMER_NO                                     
C30624                 ,EMAIL_EVENT_CD                                  
C30624                 ,EMAIL_EVENT_DT                                  
ACT070                 ,BATCH_EMAIL_ID                                  
C30624                 ,COMPANY_NO)                                     
C30624          VALUES                                                  
C30624                 (:AE-ACCOUNT-NO                                  
C30624                 ,:AE-CUSTOMER-NO                                 
C30624                 ,:AE-EMAIL-EVENT-CD                              
C30624                 ,IIF(TRY_CONVERT(DATE, :AE-EMAIL-EVENT-DT
              ) IS NULL OR (PATINDEX('%.%', :AE-EMAIL-EVENT-DT
              ) <> 0) OR (LEN(:AE-EMAIL-EVENT-DT
              ) <> 10), CIS.CHAR2DATE(:AE-EMAIL-EVENT-DT
              ), CONVERT(DATE, :AE-EMAIL-EVENT-DT) )                           
ACT070                 ,:AE-BATCH-EMAIL-ID                              
C30624                 ,:AE-COMPANY-NO)                                 
C30624     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_BATCH_EMAIL                                     
MFA-TR*                (ACCOUNT_NO                                              
MFA-TR*                ,CUSTOMER_NO                                             
MFA-TR*                ,EMAIL_EVENT_CD                                          
MFA-TR*                ,EMAIL_EVENT_DT                                          
MFA-TR*                ,BATCH_EMAIL_ID                                          
MFA-TR*                ,COMPANY_NO)                                             
MFA-TR*         VALUES                                                          
MFA-TR*                (:AE-ACCOUNT-NO                                          
MFA-TR*                ,:AE-CUSTOMER-NO                                         
MFA-TR*                ,:AE-EMAIL-EVENT-CD                                      
MFA-TR*                ,:AE-EMAIL-EVENT-DT                                      
MFA-TR*                ,:AE-BATCH-EMAIL-ID                              08290000
MFA-TR*                ,:AE-COMPANY-NO)                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
C30624     ELSE                                                         
C30624        DISPLAY 'PARA 7535-INSERT-CSS-BATCH-EMAIL'                
C30624        DISPLAY 'ERROR FOR INSERT INTO CSS_BATCH_EMAIL'           
C30624        DISPLAY 'SQLCODE ', SQLCODE                               
C30624        DISPLAY 'ACCOUNT_NO: ', AE-ACCOUNT-NO                     
C30624        DISPLAY 'COMPANY_NO: ', AE-COMPANY-NO                     
C30624        DISPLAY 'CUSTOMER_NO: ', AE-CUSTOMER-NO                   
C30624        DISPLAY 'EMAIL_EVENT_CD: ', AE-EMAIL-EVENT-CD             
C30624        DISPLAY 'EMAIL_EVENT_DT: ', AE-EMAIL-EVENT-DT             
ACT070        DISPLAY 'BATCH_EMAIL_ID: ', AE-BATCH-EMAIL-ID             
C30624        PERFORM 9900-ABEND             THRU 9900-EXIT             
C30624     END-IF.                                                      
                                                                        
C30624 7535-EXIT.                                                       
C30624     EXIT.                                                        
                                                                        
P00465*-------------------------------------------------------------            
P00465*   RETRIEVE CUSTOMER EMAIL KIT STATUS.                                   
P00465*-------------------------------------------------------------            
P00465 7540-CHECK-EMAIL-STATUS.                                         
P00465*                                                                         
P00465     EXEC SQL                                                     
P00465          SELECT TOP(1) AE.PROCESSED_CD                                  
P00465            INTO :AE-PROCESSED-CD :WS-NULL-IND-CD                 
P00465            FROM CSS_BATCH_EMAIL AE WITH(READUNCOMMITTED)                 
P00465           WHERE AE.CUSTOMER_NO = :AE-CUSTOMER-NO                 
P00465             AND AE.ACCOUNT_NO  = :AE-ACCOUNT-NO                  
P00465             AND EMAIL_EVENT_CD = :AE-EMAIL-EVENT-CD              
P00465                                       
P00465                                                      
P00465     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT AE.PROCESSED_CD                                          
MFA-TR*           INTO :AE-PROCESSED-CD :WS-NULL-IND-CD                         
MFA-TR*           FROM CSS_BATCH_EMAIL AE                                       
MFA-TR*          WHERE AE.CUSTOMER_NO = :AE-CUSTOMER-NO                         
MFA-TR*            AND AE.ACCOUNT_NO  = :AE-ACCOUNT-NO                          
MFA-TR*            AND EMAIL_EVENT_CD = :AE-EMAIL-EVENT-CD                      
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*        QUERYNO 7540                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00465*                                                                         
P00465     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00465*                                                                         
P00465     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00465         IF WS-NULL-IND-CD = -1    OR NOT-FOUND                   
P00465            MOVE SPACES            TO AE-PROCESSED-CD             
P00465         END-IF                                                   
P00465     ELSE                                                         
P00465        DISPLAY '*****************************************'       
P00465        DISPLAY 'PARA  7540-CHECK-EMAIL-STATUS  '                 
P00465        DISPLAY 'ERROR FOR SELECT FOR CSS_CUST_EMAIL'             
P00465        DISPLAY 'SQLCODE ', SQLCODE                               
P00465        DISPLAY 'ACCOUNT NO:  ',AE-ACCOUNT-NO                     
P00465        DISPLAY 'CUSTOMER NO: ',AE-CUSTOMER-NO                    
P00465        DISPLAY '*****************************************'       
P00465        PERFORM 9900-ABEND             THRU 9900-EXIT             
P00465     END-IF.                                                      
P00465                                                                  
P00465 7540-EXIT.                                                       
P00465     EXIT.                                                        
P00465*                                                                         
P00465******************************************************************        
P00465**  RETRIEVE CUSTOMER EMAIL WELCOME FLAG.                       **        
P00465******************************************************************        
P00465 7550-GET-E-WELCOME-KIT-FL.                                       
P00465*                                                                         
P00465     EXEC SQL                                                     
P00465          SELECT CU.WELCOME_KIT_CD                                
P00465            INTO :CU-WELCOME-KIT-CD                               
P00465            FROM CSS_CUSTOMER CU WITH(READUNCOMMITTED)                    
P00465           WHERE CU.CUSTOMER_NO = :CU-CUSTOMER-NO                 
P00465                                                           
P00465                                                      
P00465     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT CU.WELCOME_KIT_CD                                        
MFA-TR*           INTO :CU-WELCOME-KIT-CD                                       
MFA-TR*           FROM CSS_CUSTOMER CU                                          
MFA-TR*          WHERE CU.CUSTOMER_NO = :CU-CUSTOMER-NO                         
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7550                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00465*                                                                         
P00465     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00465*                                                                         
P00465     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00465         CONTINUE                                                 
P00465     ELSE                                                         
P00465        DISPLAY '*****************************************'       
P00465        DISPLAY 'PARA 7550-GET-E-WELCOME-KIT-FL'                  
P00465        DISPLAY 'ERROR FOR SELECT FOR CSS_CUSTOMER'               
P00465        DISPLAY 'SQLCODE ', SQLCODE                               
P00465        DISPLAY 'ACCOUNT NO: ', AT-ACCOUNT-NO                     
P00465        DISPLAY 'CUSTOMER NO: ', CU-CUSTOMER-NO                   
P00465        DISPLAY '*****************************************'       
P00465        PERFORM 9900-ABEND             THRU 9900-EXIT             
P00465     END-IF.                                                      
P00465                                                                  
P00465 7550-EXIT.                                                       
P00465     EXIT.                                                        
      /*** 7600-START-FCSJC01                                                   
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
      *                                                                         
      /*** 7620-START-FCSCA00 VSAM CTRL FILE                                    
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
      *                                                                         
                                                                        
      /*** ALL SQL INSERTS, UPDATES, AND DELETES GO IN THE 8000-                
      **** RANGE OF PARAGRAPHS                                                  
                                                                        
      /*** UPDATE JOB PARM ENTRY FOR PCSCA143 FOR THE LAST RUN DATE.            
      ******************************************************************        
       8100-UPDATE-EMAIL-JOB-PARM.                                      
      ******************************************************************        
      *                                                                         
           MOVE WS-PGRMNAME             TO G6-PROGRAM-NAME.             
           MOVE '01'                    TO G6-COMPANY-NO.               
A01537     MOVE WS-LAST-EM-CMND-CODE    TO G6-CMND-CODE.                
           MOVE 'A'                     TO G6-STATUS.                   
A01537     MOVE WS-LAST-EM-SEQ-NBR      TO G6-SEQ-NO                    
A01537     MOVE WS-L-EMAIL-RUN-DATE     TO WS-SUCCESS-RUN-DATE          
           MOVE WS-COMMON-RUN-DATE      TO WS-L-EMAIL-RUN-DATE.         
           MOVE WS-LAST-EMAIL-PARM      TO G6-PARM-DATA.                
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_JOB_PARM                                       
                 SET PARM_DATA       = :G6-PARM-DATA                    
               WHERE  PROGRAM_NAME   = :G6-PROGRAM-NAME                 
                 AND  COMPANY_NO     = :G6-COMPANY-NO                   
                 AND  CMND_CODE      = :G6-CMND-CODE                    
                 AND  SEQ_NO         = :G6-SEQ-NO                       
                 AND  STATUS         = :G6-STATUS                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
             DISPLAY 'ERROR FOR UPDATE FOR CSS_JOB_PARM'                
             DISPLAY 'SQLCODE ', SQLCODE                                
             DISPLAY 'PROGRAM_NAME  =', G6-PROGRAM-NAME                 
             DISPLAY 'COMPANY_NO    =', G6-COMPANY-NO                   
             DISPLAY 'CMND_CODE     =', G6-CMND-CODE                    
             DISPLAY 'SEQ_NO        =', G6-SEQ-NO                       
             DISPLAY 'STATUS        =', G6-STATUS                       
             PERFORM 9900-ABEND             THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
A01537*                                                                         
A01537******************************************************************        
A01537 8200-UPDATE-PMAIL-JOB-PARM.                                      
A01537******************************************************************        
A01537*                                                                         
A01537     MOVE WS-PGRMNAME             TO G6-PROGRAM-NAME.             
A01537     MOVE '01'                    TO G6-COMPANY-NO.               
A01537     MOVE WS-LAST-PM-CMND-CODE    TO G6-CMND-CODE.                
A01537     MOVE 'A'                     TO G6-STATUS.                   
A01537     MOVE WS-LAST-PM-SEQ-NBR      TO G6-SEQ-NO                    
A01537     MOVE WS-L-PMAIL-RUN-DATE     TO WS-SUCCESS-RUN-DATE          
A01537     MOVE WS-NEW-BUSINESS-DAY     TO WS-L-PMAIL-RUN-DATE.         
A01537     MOVE WS-LAST-PMAIL-PARM      TO G6-PARM-DATA.                
A01537                                                                  
A01537     EXEC SQL                                                     
A01537        UPDATE CSS_JOB_PARM                                       
A01537           SET PARM_DATA       = :G6-PARM-DATA                    
A01537         WHERE  PROGRAM_NAME   = :G6-PROGRAM-NAME                 
A01537           AND  COMPANY_NO     = :G6-COMPANY-NO                   
A01537           AND  CMND_CODE      = :G6-CMND-CODE                    
A01537           AND  SEQ_NO         = :G6-SEQ-NO                       
A01537           AND  STATUS         = :G6-STATUS                       
A01537     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01537                                                                  
A01537     IF SQLCODE NOT = SUCCESSFUL-CALL                             
A01537       DISPLAY 'ERROR IN UPDATING PAPER MAIL DATE IN CSS_JOB_PARM'
A01537       DISPLAY 'SQLCODE ', SQLCODE                                
A01537       DISPLAY 'PROGRAM_NAME  =', G6-PROGRAM-NAME                 
A01537       DISPLAY 'COMPANY_NO    =', G6-COMPANY-NO                   
A01537       DISPLAY 'CMND_CODE     =', G6-CMND-CODE                    
A01537       DISPLAY 'SEQ_NO        =', G6-SEQ-NO                       
A01537       DISPLAY 'STATUS        =', G6-STATUS                       
A01537       PERFORM 9900-ABEND             THRU 9900-EXIT              
A01537     END-IF.                                                      
A01537*                                                                         
A01537 8200-EXIT.                                                       
A01537     EXIT.                                                        
A01537*                                                                         
A01537****************************************************************          
A01537 8898-COMMIT-EMAIL-PROCESS.                                       
A01537****************************************************************          
A01537*                                                                         
A01537     EXEC SQL                                                             
A01537         INCLUDE CPD00047                                                 
A01537     END-EXEC.                                                            
A01537                                                                  
A01537     DISPLAY '**********************************************'     
A01537     DISPLAY '** EMAIL PROCESS COMPLETED SUCCESSFULLY.    **'     
A01537     DISPLAY '** WELCOME EMAILS SENT FOR ACCOUNTS THAT    **'     
A01537     DISPLAY '** CREATED ON: ' WS-SUCCESS-RUN-DATE                
A01537     DISPLAY '**                                          **'     
A01537     DISPLAY '** ACCOUNTS FETCHED: ' WS-NUMBER-AT-FETCHED         
A01537     DISPLAY '** ACCOUNTS QUALIFY: ' WS-NUM-ACCOUNTS-QUAL         
A01537     DISPLAY '**********************************************'.    
A01537     DISPLAY ' '.                                                 
A01537*                                                                         
A01537     MOVE SPACES                   TO WS-SUCCESS-RUN-DATE         
A01537     MOVE ZEROS                    TO WS-NUM-ACCOUNTS-QUAL        
A01537                                      WS-NUMBER-AT-FETCHED.       
A01537*                                                                         
A01537 8898-EXIT.                                                       
A01537     EXIT.                                                        
A01537                                                                  
      ****************************************************************          
      **                                                            **          
      **    9000-TERMINATE                                          **          
      **        CLOSE ALL FILES                                     **          
      **                                                            **          
      ****************************************************************          
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE NAFILE.                                                
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ****************************************************                      
      **  9700-PROCESS-ABEND | BATCH ABEND COPYBOOK     **                      
      ****************************************************                      
      *                                                                         
       COPY CPD0023B.                                                           
      *                                                                         
      ****************************************************************          
      * 9900-ABEND INCLUDES SQL ROLLBACK                                        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
