       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA142.                                        
       DATE-WRITTEN.   03/06/02.                                        
       DATE-COMPILED.                                                   
       AUTHOR.         LISA FISHER                                      
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRICITY  & GAS              **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                   DB2                          *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE       INITIALS      REASON                             **         
      **                                                             **         
C25508** 06/11/02   LEF           FIX HVAC LOGIC                     **         
C25508** 04/30/02   LEF           LOAD WO DATE FOR FINAL BILLS       **         
C25508** 04/22/02   LEF           ADDED CHECK FOR ACTIVE METER       **         
C25508**                          CHANGED FIRM COMMERCIAL RATE TO 464**         
C25508** 04/22/02   LEF           REMOVED LOGIC FOR INDUSTRIAL       **         
C25508** 03/06/02   LEF           COLLECTION SYSTEM -                **         
C25508**                          LOAD CSS_COLLECT_HIST              **         
C26954** 10/02/02   SS82048       CREATE NEW QUEUES FOR SEBR ACCOUNTS**         
C28513** 03/03/03   SS82048       INCLUDE RATES 450, 461, 462 AND 463**         
      **                          IN THE FIRM COLLECTION QUEUE 'Fxxx'**         
C27949** 04/10/03   SS82048       CHANGES TO BRING IN PSNC ACCOUNTS  **         
      **                          WITH NON-UTIL ARREARS TO COLLECTION**         
      **                          SYSTEM                             **         
T29290** 07/14/03   COVANSYS      TO QUEUE PENDING FB ACCOUNTS IN THE**         
T29290**                          '05' QUEUE.                        **         
C29288** 07/24/03   SS82048       CHANGE CALCULATION OF QUEUE DAYS   **         
C29288**                          BASED ON BUSINESS DAYS INSTEAD OF  **         
C29288**                          CALENDAR DAYS.                     **         
C27949** 08/12/03   SS82048       CHANGE TO EXCLUDE LPN AND NSC FROM **         
      **            ACTIVITY 13   PSNC COLLECTION FOR ACTIVE ACCTS   **         
C29874** 10/22/03   SS82048       EXCLUDE SERVICE CARE COMPANY ACCTS **         
      **                          FROM COLLECTIONS                   **         
PRDFIX** 10/29/03   SS82048       INCLUDE HOST VARIABLE IN 7110-     **         
      **                          TO HANDLE NULL VALUES              **         
C31158** 10/08/04   RICK BLACK    ADDED COLLECTION ID 043 WHICH     **          
      **                          REPLACES 003 IN THE SEB REGION.    **         
T31893** 12/07/04   GOKUL         ADDED COLLECTION ID 044, 045, 046  **         
T31893**                          & 047 FOR SEB REGION.              **         
C30070** 01/06/05   RB19957       ADDED CODE TO CPD00319 FOR BEHAVIOR**         
C30070**            RICK BLACK    SCORE PROJECT SO SUPPORTING WS FLDS**         
C30070**                          AND DATABASE READS WERE ADDED TO   **         
C30070**                          THIS PROGRAM AND ALSO PCSCA144.    **         
C33928** 05/26/06   SB35550       ADDED WITH UR TO CURSORS/FETCHES   **         
      **                          REARRANGED SOME KEY FIELDS FOR     **         
      **                          BETTER PERFORMNACE  W/DANIE BOOOTHA**         
T33928** 09/21/06   JJ95645       REPLACED CSS_MODEL_SQL CALL TO     **         
      **                          SQL SET STATEMENT FOR PERFORMANCE. **         
C30169*  04/17/08   CVNS          WRITE-OFF RECOVERY CHANGES.        **         
      *             CHENNAI       1. CHANGES FOR CSS_FINAL_WO AND    **         
      *                              CSS_CHRG_OFF TABLE STRUCTURE    **         
      *                              IMPACT.                         **         
C30169*  07/14/08   SS42021       CHANGES TO BRING SCE&G ACCTS INTO  **         
      *                           COLLECTION SYSTEM                  **         
P00453*  03/21/11   WR19680       ADDING NEW COLLECTION QUE FOR      **         
P00453*                           PAY AS YOU GO ACCOUNTS.            **         
P00599*  06/25/12   ss42021       LOAD FINAL BILL ACCTS ON LPC DATE  **         
P00599*                           USING DATA FROM CSS_FIN_WO_ACTION  **         
P00599*                           AS WITH NEW FINAL LPC PROCESS NO   **         
P00599*                           BILL HEADER IS WRITTEN.            **         
A04491*  01/10/13   MC95456       FIX TO RESETTING OF FLAG           **         
A04491*                           WS-SEB-REGULATED-FLAG              **         
A04491*  02/12/13   ss42021       1. Move code to set regulated fl   **         
A04491*                              to beginning of acct processing.**         
A04491*                           2. Use correct field to load       **         
A04491*                              behavioral score rating flag for**         
A04491*                              Regulated Challenger rating 'C' **         
A04491*                              WS-BHV-C-COLL-FLAG-REG-CR.      **         
      *****************************************************************         
      *                   PCSCA142   NARRATIVE                        *         
      *                                                               *         
      * THIS PROGRAM GETS ALL THE ACCOUNTS THAT HAVE 30 DAY, 60 DAY,  *         
      * 90 DAY ARREARS AND LOADS THEM TO THE CSS_COLLECT_HIST UNDER   *         
      * THE CORRECT CATEGORY BASED ON ARREARS, TYPE ACCOUNT, AND      *         
      * BILL CYCLE.                                                   *         
      *****************************************************************         
      *                                                                         
HPCCDM*EJECT                                                                    
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA142'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-LITERALS.                                                 
           05 WS-D                             PIC X(01)  VALUE 'D'.    
           05 WS-Y                             PIC X(01)  VALUE 'Y'.    
           05 WS-N                             PIC X(01)  VALUE 'N'.    
           05 WS-CLOSED                        PIC X(01)  VALUE 'E'.    
           05 WS-CONTRACT                      PIC S9(04) COMP          
                                                          VALUE +100.   
           05 WS-ACTIVE                        PIC X(01)  VALUE 'B'.    
           05 WS-PGRMNAME                      PIC X(08)  VALUE         
              'PCSCA142'.                                               
      *                                                                         
       01  WS-VARIABLES.                                                
           05 WS-ROW-EXISTS                    PIC X(01).               
              88  ROW-EXISTS                   VALUE 'Y'.               
           05 WS-PREV-BILL-CYCLE               PIC X(02)  VALUE SPACES. 
           05 WS-PHONE-NO                      PIC X(10)  VALUE SPACES. 
           05 WS-CURRENT-DATE                  PIC X(10)  VALUE SPACES. 
           05 WS-NEXT-DAY                      PIC X(10)  VALUE SPACES. 
           05 WS-CALC-DATE                     PIC X(10)  VALUE SPACES. 
           05 WS-HOLD-DATE                     PIC X(10)  VALUE SPACES. 
           05 WS-PROCESS-DATE                  PIC X(10)  VALUE SPACES. 
           05 WS-WRITE-OFF-DT                  PIC X(10)  VALUE SPACES. 
           05 WS-WO-DATE                       PIC X(10)  VALUE SPACES. 
C30169     05 WS-THIRD-FINAL-DT                PIC X(10)  VALUE ZEROS.  
           05 WS-FINAL-WO-DATE                 PIC X(10)  VALUE SPACES. 
           05 WS-DAY                           PIC S9(04) COMP.         
C26954     05 WS-AMT-AR-DAY-00                 PIC S9(07)V99 COMP-3     
C26954                                             VALUE 0.             
           05 WS-AMT-AR-DAY-30                 PIC S9(07)V99 VALUE 0.   
           05 WS-AMT-AR-DAY-60                 PIC S9(07)V99 VALUE 0.   
           05 WS-AMT-AR-DAY-90                 PIC S9(07)V99 VALUE 0.   
C26954     05 WS-AMT-TRAN-BALANCE              PIC S9(07)V99 COMP-3     
C26954                                             VALUE 0.             
C26954     05 WS-GROUP1-CNT-ARREARS            PIC S9(07)V99 COMP-3     
C26954                                             VALUE 0.             
C26954     05 WS-GRP2-AR-DAY-00                PIC S9(07)V99 COMP-3     
C26954                                             VALUE 0.             
           05 WS-TOTAL-ARREARS                 PIC S9(09)V99 VALUE  0.  
           05 WS-ARREARS                       PIC 9(02)  VALUE ZEROS.  
              88 30-DAY-ARREARS                VALUE 30.                
              88 60-DAY-ARREARS                VALUE 60.                
              88 90-DAY-ARREARS                VALUE 90.                
           05 WS-ARREARS-EXIST                 PIC X(01)  VALUE 'N'.    
              88 ARREARS-EXIST                 VALUE 'Y'.               
           05 WS-CFA00-STATUS                  PIC X(02).               
              88  CFA00-SUCCESSFUL             VALUE '00'.              
           05 WS-ACA00-STATUS                  PIC X(02).               
              88  ACA00-SUCCESSFUL             VALUE '00'.              
           05 WS-DATE-FOUND                    PIC X(01) VALUE 'N'.     
              88  DATE-IS-FOUND                VALUE 'Y'.               
           05 WS-NEW-TIMESTAMP                 PIC X(26).               
           05 WS-HVAC-FLAG                     PIC X(01) VALUE 'N'.     
              88  WS-HVAC                      VALUE 'Y'.               
           05 WS-HVAC-ARREARS-FLAG             PIC X(01) VALUE 'N'.     
              88  WS-HVAC-ARREARS              VALUE 'Y'.               
           05 WS-ACCT-INFO-FOUND-FLAG          PIC X(01) VALUE 'N'.     
              88  WS-ACCT-INFO-FOUND           VALUE 'Y'.               
           05 WS-COLLECT-ACTIVE-FLAG           PIC X(01) VALUE 'N'.     
              88  WS-COLLECT-ACTIVE            VALUE 'Y'.               
           05 WS-PROCESS-FLAG                  PIC X(01) VALUE 'N'.     
              88  WS-PROCESS                   VALUE 'Y'.               
           05 WS-METER-ACTIVE-FLAG             PIC X(01) VALUE 'N'.     
              88  WS-METER-ACTIVE              VALUE 'Y'.               
           05 WS-GROUP1-CNT-FLAG               PIC X(01) VALUE 'N'.     
              88  WS-GROUP1-CNT-ACTIVE                   VALUE 'Y'.     
           05 WS-SEB-REGULATED-FLAG            PIC X(01) VALUE 'N'.     
              88  SEB-REGULATED                          VALUE 'Y'.     
C28513     05 WS-FIRM-RATE                     PIC X(03) VALUE SPACES.  
C28513        88  FIRM-RATE                    VALUE                    
C28513            '450', '461', '462', '463', '464',                    
C27949            '145', '150', '160', '175', '180'.                    
C27949     05  WS-DATABASE                     PIC 9(01) VALUE 0.       
C27949         88 CSR-DATABASE                           VALUE 1.       
C27949         88 SEB-DATABASE                           VALUE 2.       
C27949     05 WS-ACTIVE-COLLECTION-FLAG        PIC X(01) VALUE 'N'.     
C27949        88  ACTIVE-COLLECTION            VALUE 'Y'.               
C27949        88  NOT-ACTIVE-COLLECTION        VALUE 'N'.               
C27949     05 WS-SVC-CARE-FL                   PIC 9(01) VALUE 0.       
C27949        88  SVC-CARE                     VALUE 1.                 
C30169     05 WS-SVC-CARE-FL-PSNC              PIC 9(01) VALUE 0.       
C27949     05 WS-SVC-CNT-ARREARS       PIC S9(09)V99 COMP-3 VALUE 0.    
C27949     05 WS-ARREARS-NONUTL-XSVC   PIC S9(09)V99 COMP-3 VALUE 0.    
C27949     05 WS-TOTAL-ARREARS-NONUTL  PIC S9(09)V99 COMP-3 VALUE 0.    
C27949     05 WS-NULL-IND1             PIC S9(04)    COMP   VALUE 0.    
PRDFIX     05 WS-NULL-IND2             PIC S9(04)    COMP   VALUE 0.    
C27949     05 WS-SVC-CNT-ARREARS-NULL  PIC S9(04)    COMP   VALUE 0.    
C30070     05 WS-PROCESS-COLLEC-FLAG   PIC 9(01).                       
C30070     05 WS-AT-BHV-EXEMPT-CD      PIC X(01).                       
C30070     05 WS-CZ-BHV-RATING-HIST.                                    
C30070        10 WS-CZ-BHV-RATING      PIC X(01).                       
C30070        10 FILLER                PIC X(23).   
MAN008     05 WS-CZ-BHV-RATING-HIST-MAN008 REDEFINES
MAN008           WS-CZ-BHV-RATING-HIST PIC X(24).
C30169     05 WS-PLMT-TYPE             PIC X(05) VALUE SPACES.          
P00453     05 WS-PAYNGO-CUST-FLAG      PIC X(01) VALUE SPACES.          
                                                                        
COB305 01 WS-WO-BALANCE        PIC S9(09)V99 USAGE COMP-3 VALUE 0.      
COB305 01 WS-CONTRACT-WO-BALANCE        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.      
                                                                        
COB305 01 WS-HOLD-DEL-VALUE        PIC S9(4)V9(5) USAGE COMP-3 VALUE 0.     
                                                                        
       01  WS-DAY-COLL                 PIC X(20)                        
                           VALUE 'CQ-DAY-COLL         '.                
       01  WS-AMT-COLL                 PIC X(20)                        
                           VALUE 'CQ-AMT-COLL         '.                
C27949 01  WS-DELQ-WRITE-OFF           PIC X(20)                        
C27949                     VALUE 'CQ-WO-AMOUNT        '.                
C27949 01  WS-SVC-CARE                 PIC X(20)                        
C27949                     VALUE 'CQ-SVC-CARE         '.                
       01  WS-ACTIVE-DAYS              PIC 9(02) VALUE ZEROS.           
       01  WS-DELINQ-AMOUNT            PIC S9(09)V99 VALUE ZEROS.       
C27949 01  WS-DELINQ-WRITE-OFF-AMT     PIC S9(09)V99 VALUE ZEROS.       
C30169 01  WS-ACTIVE-DAYS-PSNC         PIC 9(02) VALUE ZEROS.           
C30169 01  WS-DELINQ-AMOUNT-PSNC       PIC S9(09)V99 VALUE ZEROS.       
C30169 01  WS-DELINQ-WRITE-OFF-AMT-PSNC PIC S9(09)V99 VALUE ZEROS.      
       01  WS-DAY-COUNTER              PIC 9(02) VALUE ZEROS.           
       01  WS-DAYS-DIFF                PIC S9(04) COMP.                 
C29288 01  WS-BUS-DAY-DIFF             PIC S9(04) COMP VALUE ZEROS.     
       01  WS-ACCT-TYPE-VALUE          PIC X(01) VALUE SPACES.          
       01  WS-DATE-CRED-ACT-NULL       PIC S9(04) COMP VALUE +0.        
       01  WS-WRITE-OFF-DT-NULL        PIC S9(04) COMP VALUE +0.        
       01  WS-ACCT-FINAL-DT-NULL       PIC S9(04) COMP VALUE +0.        
       01  WS-WO-BALANCE-NULL          PIC S9(04) COMP VALUE +0.        
       01  WS-AMT-AR-DAY-00-NULL       PIC S9(04) COMP VALUE +0.        
       01  WS-AMT-AR-DAY-30-NULL       PIC S9(04) COMP VALUE +0.        
       01  WS-AMT-AR-DAY-60-NULL       PIC S9(04) COMP VALUE +0.        
       01  WS-AMT-AR-DAY-90-NULL       PIC S9(04) COMP VALUE +0.        
C30070 01  WS-BEH-MODEL-A-CHAMP-REG    PIC X(20)                        
C30070               VALUE 'BEH-MODL-A-CHAMP-REG'.                      
C30070 01  WS-BHV-A-COLL-FLAG-REG-CH   PIC 9(01) VALUE ZEROES.          
C30070 01  WS-BEH-MODEL-B-CHAMP-REG    PIC X(20)                        
C30070               VALUE 'BEH-MODL-B-CHAMP-REG'.                      
C30070 01  WS-BHV-B-COLL-FLAG-REG-CH   PIC 9(01) VALUE ZEROES.          
C30070 01  WS-BEH-MODEL-C-CHAMP-REG    PIC X(20)                        
C30070               VALUE 'BEH-MODL-C-CHAMP-REG'.                      
C30070 01  WS-BHV-C-COLL-FLAG-REG-CH   PIC 9(01) VALUE ZEROES.          
C30070 01  WS-BEH-MODEL-D-CHAMP-REG    PIC X(20)                        
C30070               VALUE 'BEH-MODL-D-CHAMP-REG'.                      
C30070 01  WS-BHV-D-COLL-FLAG-REG-CH   PIC 9(01) VALUE ZEROES.          
C30070 01  WS-BEH-MODEL-E-CHAMP-REG    PIC X(20)                        
C30070               VALUE 'BEH-MODL-E-CHAMP-REG'.                      
C30070 01  WS-BHV-E-COLL-FLAG-REG-CH   PIC 9(01) VALUE ZEROES.          
C30070 01  WS-BEH-MODEL-F-CHAMP-REG    PIC X(20)                        
C30070               VALUE 'BEH-MODL-F-CHAMP-REG'.                      
C30070 01  WS-BHV-F-COLL-FLAG-REG-CH   PIC 9(01) VALUE ZEROES.          
C30070 01  WS-BEH-MODEL-G-CHAMP-REG    PIC X(20)                        
C30070               VALUE 'BEH-MODL-G-CHAMP-REG'.                      
C30070 01  WS-BHV-G-COLL-FLAG-REG-CH   PIC 9(01) VALUE ZEROES.          
C30070 01  WS-BEH-MODEL-H-CHAMP-REG    PIC X(20)                        
C30070               VALUE 'BEH-MODL-H-CHAMP-REG'.                      
C30070 01  WS-BHV-H-COLL-FLAG-REG-CH   PIC 9(01) VALUE ZEROES.          
C30070 01  WS-BEH-MODEL-A-CHAMP-DEREG  PIC X(20)                        
C30070               VALUE 'BEH-MODL-A-CHAMP-DRG'.                      
C30070 01  WS-BHV-A-COLL-FLAG-DEREG-CH PIC 9(01) VALUE ZEROES.          
C30070 01  WS-BEH-MODEL-B-CHAMP-DEREG  PIC X(20)                        
C30070               VALUE 'BEH-MODL-B-CHAMP-DRG'.                      
C30070 01  WS-BHV-B-COLL-FLAG-DEREG-CH PIC 9(01) VALUE ZEROES.          
C30070 01  WS-BEH-MODEL-C-CHAMP-DEREG  PIC X(23)                        
C30070               VALUE 'BEH-MODL-C-CHAMP-DRG'.                      
C30070 01  WS-BHV-C-COLL-FLAG-DEREG-CH PIC 9(01) VALUE ZEROES.          
C30070 01  WS-BEH-MODEL-D-CHAMP-DEREG  PIC X(20)                        
C30070               VALUE 'BEH-MODL-D-CHAMP-DRG'.                      
C30070 01  WS-BHV-D-COLL-FLAG-DEREG-CH PIC 9(01) VALUE ZEROES.          
C30070 01  WS-BEH-MODEL-E-CHAMP-DEREG  PIC X(20)                        
C30070               VALUE 'BEH-MODL-E-CHAMP-DRG'.                      
C30070 01  WS-BHV-E-COLL-FLAG-DEREG-CH PIC 9(01) VALUE ZEROES.          
C30070 01  WS-BEH-MODEL-F-CHAMP-DEREG  PIC X(20)                        
C30070               VALUE 'BEH-MODL-F-CHAMP-DRG'.                      
C30070 01  WS-BHV-F-COLL-FLAG-DEREG-CH PIC 9(01) VALUE ZEROES.          
C30070 01  WS-BEH-MODEL-G-CHAMP-DEREG  PIC X(20)                        
C30070               VALUE 'BEH-MODL-G-CHAMP-DRG'.                      
C30070 01  WS-BHV-G-COLL-FLAG-DEREG-CH PIC 9(01) VALUE ZEROES.          
C30070 01  WS-BEH-MODEL-H-CHAMP-DEREG  PIC X(20)                        
C30070               VALUE 'BEH-MODL-H-CHAMP-DRG'.                      
C30070 01  WS-BHV-H-COLL-FLAG-DEREG-CH PIC 9(01) VALUE ZEROES.          
C30070 01  WS-BEH-MODEL-A-CHALL-REG    PIC X(20)                        
C30070               VALUE 'BEH-MODL-A-CHALL-REG'.                      
C30070 01  WS-BHV-A-COLL-FLAG-REG-CR   PIC 9(01) VALUE ZEROES.          
C30070 01  WS-BEH-MODEL-B-CHALL-REG    PIC X(20)                        
C30070               VALUE 'BEH-MODL-B-CHALL-REG'.                      
C30070 01  WS-BHV-B-COLL-FLAG-REG-CR   PIC 9(01) VALUE ZEROES.          
C30070 01  WS-BEH-MODEL-C-CHALL-REG    PIC X(20)                        
C30070               VALUE 'BEH-MODL-C-CHALL-REG'.                      
C30070 01  WS-BHV-C-COLL-FLAG-REG-CR   PIC 9(01) VALUE ZEROES.          
C30070 01  WS-BEH-MODEL-D-CHALL-REG    PIC X(20)                        
C30070               VALUE 'BEH-MODL-D-CHALL-REG'.                      
C30070 01  WS-BHV-D-COLL-FLAG-REG-CR   PIC 9(01) VALUE ZEROES.          
C30070 01  WS-BEH-MODEL-E-CHALL-REG    PIC X(20)                        
C30070               VALUE 'BEH-MODL-E-CHALL-REG'.                      
C30070 01  WS-BHV-E-COLL-FLAG-REG-CR   PIC 9(01) VALUE ZEROES.          
C30070 01  WS-BEH-MODEL-F-CHALL-REG    PIC X(20)                        
C30070               VALUE 'BEH-MODL-F-CHALL-REG'.                      
C30070 01  WS-BHV-F-COLL-FLAG-REG-CR   PIC 9(01) VALUE ZEROES.          
C30070 01  WS-BEH-MODEL-G-CHALL-REG    PIC X(20)                        
C30070               VALUE 'BEH-MODL-G-CHALL-REG'.                      
C30070 01  WS-BHV-G-COLL-FLAG-REG-CR   PIC 9(01) VALUE ZEROES.          
C30070 01  WS-BEH-MODEL-H-CHALL-REG    PIC X(20)                        
C30070               VALUE 'BEH-MODL-H-CHALL-REG'.                      
C30070 01  WS-BHV-H-COLL-FLAG-REG-CR   PIC 9(01) VALUE ZEROES.          
C30070 01  WS-BEH-MODEL-A-CHALL-DEREG  PIC X(20)                        
C30070               VALUE 'BEH-MODL-A-CHALL-DRG'.                      
C30070 01  WS-BHV-A-COLL-FLAG-DEREG-CR PIC 9(01) VALUE ZEROES.          
C30070 01  WS-BEH-MODEL-B-CHALL-DEREG  PIC X(20)                        
C30070               VALUE 'BEH-MODL-B-CHALL-DRG'.                      
C30070 01  WS-BHV-B-COLL-FLAG-DEREG-CR PIC 9(01) VALUE ZEROES.          
C30070 01  WS-BEH-MODEL-C-CHALL-DEREG  PIC X(23)                        
C30070               VALUE 'BEH-MODL-C-CHALL-DRG'.                      
C30070 01  WS-BHV-C-COLL-FLAG-DEREG-CR PIC 9(01) VALUE ZEROES.          
C30070 01  WS-BEH-MODEL-D-CHALL-DEREG  PIC X(20)                        
C30070               VALUE 'BEH-MODL-D-CHALL-DRG'.                      
C30070 01  WS-BHV-D-COLL-FLAG-DEREG-CR PIC 9(01) VALUE ZEROES.          
C30070 01  WS-BEH-MODEL-E-CHALL-DEREG  PIC X(20)                        
C30070               VALUE 'BEH-MODL-E-CHALL-DRG'.                      
C30070 01  WS-BHV-E-COLL-FLAG-DEREG-CR PIC 9(01) VALUE ZEROES.          
C30070 01  WS-BEH-MODEL-F-CHALL-DEREG  PIC X(20)                        
C30070               VALUE 'BEH-MODL-F-CHALL-DRG'.                      
C30070 01  WS-BHV-F-COLL-FLAG-DEREG-CR PIC 9(01) VALUE ZEROES.          
C30070 01  WS-BEH-MODEL-G-CHALL-DEREG  PIC X(20)                        
C30070               VALUE 'BEH-MODL-G-CHALL-DRG'.                      
C30070 01  WS-BHV-G-COLL-FLAG-DEREG-CR PIC 9(01) VALUE ZEROES.          
C30070 01  WS-BEH-MODEL-H-CHALL-DEREG  PIC X(20)                        
C30070               VALUE 'BEH-MODL-H-CHALL-DRG'.                      
C30070 01  WS-BHV-H-COLL-FLAG-DEREG-CR PIC 9(01) VALUE ZEROES.          
                                                                        
       01  WS-COLL-EXEMPT-CD.                                           
           05  WS-COLL-BANKRUPTCY      PIC X(01).                       
           05  WS-COLL-JUDGEMENT       PIC X(01).                       
           05  WS-COLL-CRED-BUREAU     PIC X(01).                       
           05  WS-COLL-DNP-EXEMPT      PIC X(01).                       
           05  WS-COLL-MED-CERT        PIC X(01).                       
           05  WS-COLL-DO-NOT-CALL     PIC X(01).                       
           05  WS-COLL-NOTICE-EXEMPT   PIC X(01).                       
           05  WS-COLL-WO-CRED-BUREAU  PIC X(01).                       
           05  WS-COLL-DECEASED        PIC X(01).                       
           05  WS-COLL-CONDITION-CD    PIC X(01).                       
           05  FILLER                  PIC X(10).                       
      *                                                                         
      *****************************************************************         
      **      APPLICATION  TABLE DCLGENS                             **         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      **                                                                        
      *****************************************************************         
      *    CSS_ACCOUNT                                                          
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
      **                                                                        
      *****************************************************************         
      *    CSS_JOB_PARM                                                         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
      **                                                                        
      *****************************************************************         
      *    CSS_AR_CNTL                                                          
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBARCNTL                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_COMPANY                                                          
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBCOMPNY                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_CUST_PHONE                                                       
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBCSTPHN                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_NAME                                                             
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBNAME                                                     
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_BILLING_HDR                                                      
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBBLLHDR                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_CUSTOMER                                                         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBCUST                                                     
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_UTIL_ENVRNMT                                                     
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBUTLENV                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_MODEL_SQL                                                        
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBMODEL                                                    
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_DELINQUENCY                                                      
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_HOLIDAY                                                          
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBHLDAY                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_CRED_COLL                                                        
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBCRCOLL                                                 
           END-EXEC.                                                            
                                                                        
      ****************************************************************          
      *    CSS_CONTRACT                                                         
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBCNTRCT                                                 
           END-EXEC.                                                            
                                                                        
      ****************************************************************          
      *    CSS_COLLECT_HIST                                                     
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBCOLHST                                                 
           END-EXEC.                                                            
                                                                        
      ****************************************************************          
      *    CSS_COLL_ACCT_INFO                                                   
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBACCINF                                                 
           END-EXEC.                                                            
                                                                        
      ****************************************************************          
      * FW-CSS_FINAL_WO                                                         
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBFINLWO                                                 
           END-EXEC.                                                            
                                                                        
      ****************************************************************          
      * KD-CSS_FIN_WO_ACTION                                                    
      ****************************************************************          
C30169     EXEC SQL                                                             
C30169         INCLUDE TBFWACTN                                                 
C30169     END-EXEC.                                                            
                                                                        
      ****************************************************************          
      * IZ-CSS_FIN_WO_COLLECT                                                   
      ****************************************************************          
C30169     EXEC SQL                                                             
C30169         INCLUDE TBFWCLAG                                                 
C30169     END-EXEC.                                                            
                                                                        
      ****************************************************************          
      *    CSS_CHRG_OFF                                                         
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBCHGOFF                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_MTRD_ENVRNMT                                                     
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBMTRENV                                                   
           END-EXEC.                                                            
      *                                                                         
C26954*****************************************************************         
C26954*   CSS_REG_PROFILE                                                       
C26954*****************************************************************         
C26954     EXEC SQL                                                             
C26954       INCLUDE TBREGPRF                                                   
C26954     END-EXEC.                                                            
C30070*                                                                         
C30070****************************************************************          
C30070*    CSS_CREDIT_PROFILE                                        *          
C30070****************************************************************          
C30070     EXEC SQL                                                             
C30070         INCLUDE TBCRPROF                                                 
C30070     END-EXEC.                                                            
C30070*                                                                         
C30070****************************************************************          
C30070*    CSS_BHV_ACCT_SCORE                                        *          
C30070****************************************************************          
C30070     EXEC SQL                                                             
C30070         INCLUDE TBACSCRE                                                 
C30070     END-EXEC.                                                            
C30070*                                                                         
C30070****************************************************************          
C30070*    CSS_BHV_MODEL                                             *          
C30070****************************************************************          
C30070     EXEC SQL                                                             
C30070         INCLUDE TBBHMODL                                                 
C30070     END-EXEC.                                                            
      *                                                                         
P00453****************************************************************          
P00453*    CSS_PREPAY_HIST, PK                                                  
P00453****************************************************************          
P00453     EXEC SQL                                                             
P00453         INCLUDE TBPREHST                                                 
P00453     END-EXEC.                                                            
      *                                                                         
       COPY CWS00303.                                                           
      *-- COPY BOOK HAVING SUCCESSFUL-CALL AND NOT-FOUND                        
                                                                        
      *  ABEND SWITCH COPYBOOK                                                  
       COPY CWS09900.                                                           
      *                                                                         
      * -- USED BY CPD0303B                                                     
      * WS ABEND WORK AREA                                                      
       COPY CWS00010.                                                           
      *                                                                         
      *-- COPY BOOK THAT CONTAINS VARIABLES REQD TO GET JOB PARM DATE           
       COPY CJF00101.                                                           
       COPY FIOCA01.                                                            
       COPY FIOJC01.                                                            
       COPY FIOCA00.                                                            
       COPY CWS00038.                                                           
       COPY CWS00039.                                                           
      *                                                                         
      *-- COPY BOOK HAVING WS-EMB-INPUT                                         
       COPY CWS00011.                                                           
      *                                                                         
      *-- COPYBOOK FOR WS-CODES-DATA-PRESENT                                    
       COPY CWS00056.                                                           
      *                                                                         
      *****************************************************************         
      ** CURSOR DECLARATION TO GET ALL THE ACCOUNTS THAT BILLED FOR             
      ** FOR THE JOB PARM DATE.                                                 
C25067** THIS CURSOR SUMS UP 30-DAY, 60-DAY, AND 90-DAY FOR EACH ACCT           
C25067** AND SORTS THE BUCKETS DESCENDING.                                      
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
               DECLARE BILL-HDR CURSOR FOR                              
                 SELECT DISTINCT(BI.ACCOUNT_NO)                         
C25067                 ,SUM(AC.AMT_AR_DAY_00) AS SUM00                  
C25067                 ,SUM(AC.AMT_AR_DAY_30) AS SUM30                  
C25067                 ,SUM(AC.AMT_AR_DAY_60) AS SUM60                  
                       ,SUM(AC.AMT_AR_DAY_90) AS SUM90                  
C30169                 ,AT.COMPANY_NO                                   
                   FROM CSS_BILLING_HDR  BI WITH(READUNCOMMITTED)               
                       ,CSS_AR_CNTL      AC WITH(READUNCOMMITTED)               
C29874                 ,CSS_ACCOUNT      AT WITH(READUNCOMMITTED)               
                  WHERE BI.DATE_BILLED = IIF(TRY_CONVERT(DATE, 
                                                        :BI-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :BI-DATE-BILLED
              ) <> 0) OR (LEN(:BI-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :BI-DATE-BILLED
              ), CONVERT(DATE, :BI-DATE-BILLED) )                
                    AND AC.ACCOUNT_NO = BI.ACCOUNT_NO                   
C29874              AND AT.ACCOUNT_NO = BI.ACCOUNT_NO                   
C27949              AND BI.BILL_NO > 0                                  
                    AND (AC.ITEM_ID = 00)                               
C27949              AND AC.PYMT_PRIORITY_LVL > 0                        
C29874              AND (AT.LOCAL_OFFICE <> '301'                       
C29874              AND  AT.LOCAL_OFFICE <> '302'                       
C29874              AND  AT.LOCAL_OFFICE <> '303')                      
                  GROUP BY                                              
C30169                   AT.COMPANY_NO, BI.ACCOUNT_NO                   
C30169              ORDER BY AT.COMPANY_NO, BI.ACCOUNT_NO               
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE BILL-HDR CURSOR FOR                                      
MFA-TR*          SELECT DISTINCT(BI.ACCOUNT_NO)                                 
MFA-TR*                ,SUM(AC.AMT_AR_DAY_00) AS SUM00                          
MFA-TR*                ,SUM(AC.AMT_AR_DAY_30) AS SUM30                          
MFA-TR*                ,SUM(AC.AMT_AR_DAY_60) AS SUM60                          
MFA-TR*                ,SUM(AC.AMT_AR_DAY_90) AS SUM90                          
MFA-TR*                ,AT.COMPANY_NO                                           
MFA-TR*            FROM CSS_BILLING_HDR  BI                                     
MFA-TR*                ,CSS_AR_CNTL      AC                                     
MFA-TR*                ,CSS_ACCOUNT      AT                                     
MFA-TR*           WHERE BI.DATE_BILLED = :BI-DATE-BILLED                        
MFA-TR*             AND AC.ACCOUNT_NO = BI.ACCOUNT_NO                           
MFA-TR*             AND AT.ACCOUNT_NO = BI.ACCOUNT_NO                           
MFA-TR*             AND BI.BILL_NO > 0                                          
MFA-TR*             AND (AC.ITEM_ID = 00)                                       
MFA-TR*             AND AC.PYMT_PRIORITY_LVL > 0                                
MFA-TR*             AND (AT.LOCAL_OFFICE <> '301'                               
MFA-TR*             AND  AT.LOCAL_OFFICE <> '302'                               
MFA-TR*             AND  AT.LOCAL_OFFICE <> '303')                              
MFA-TR*           GROUP BY                                                      
MFA-TR*                  AT.COMPANY_NO, BI.ACCOUNT_NO                           
MFA-TR*             ORDER BY AT.COMPANY_NO, BI.ACCOUNT_NO                       
MFA-TR*             WITH UR                                                     
MFA-TR*    END-EXEC.                                                    33080000
                                                                        
                                                                        
           EXEC SQL                                                     
               DECLARE FINAL-WO CURSOR FOR                              
                 SELECT KD.ACCOUNT_NO                                   
                       ,KD.FW_ACTION_DT                                 
C30169                 ,KD.FW_ACTION_TYPE_CD                            
C30169                 ,AT.COMPANY_NO                                   
C30169           FROM CSS_FIN_WO_ACTION KD WITH(READUNCOMMITTED)                
C30169               ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
C29874            WHERE (AT.LOCAL_OFFICE <> '301'                       
C29874              AND  AT.LOCAL_OFFICE <> '302'                       
C29874              AND  AT.LOCAL_OFFICE <> '303')                      
C27949              AND  AT.ACCOUNT_NO     = KD.ACCOUNT_NO              
C30169              AND  KD.FW_ACTION_DT   = IIF(TRY_CONVERT(DATE, 
                                                       :WS-WRITE-OFF-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-WRITE-OFF-DT
              ) <> 0) OR (LEN(:WS-WRITE-OFF-DT) <> 10), CIS.CHAR2DATE(
                                                       :WS-WRITE-OFF-DT
              ), CONVERT(DATE, :WS-WRITE-OFF-DT) )           
P00599         AND  KD.FW_ACTION_TYPE_CD IN ('WO','90302','90305','LPC')
C30169              ORDER BY AT.COMPANY_NO                              
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE FINAL-WO CURSOR FOR                                      
MFA-TR*          SELECT KD.ACCOUNT_NO                                           
MFA-TR*                ,KD.FW_ACTION_DT                                         
MFA-TR*                ,KD.FW_ACTION_TYPE_CD                                    
MFA-TR*                ,AT.COMPANY_NO                                           
MFA-TR*          FROM CSS_FIN_WO_ACTION KD                                      
MFA-TR*              ,CSS_ACCOUNT AT                                            
MFA-TR*           WHERE (AT.LOCAL_OFFICE <> '301'                               
MFA-TR*             AND  AT.LOCAL_OFFICE <> '302'                               
MFA-TR*             AND  AT.LOCAL_OFFICE <> '303')                              
MFA-TR*             AND  AT.ACCOUNT_NO     = KD.ACCOUNT_NO                      
MFA-TR*             AND  KD.FW_ACTION_DT   = :WS-WRITE-OFF-DT                   
MFA-TR*        AND  KD.FW_ACTION_TYPE_CD IN ('WO','90302','90305','LPC')        
MFA-TR*             ORDER BY AT.COMPANY_NO                                      
MFA-TR*             WITH UR                                                     
MFA-TR*    END-EXEC.                                                    33080000
       PROCEDURE DIVISION.                                              
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
      *                                                                         
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
      *                                                                         
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   OPENS OUTPUT FILE AND GETS JOB PARM DATE AND REPORT DATE     *        
      ******************************************************************        
       0100-INITIALIZATION.                                             
      *                                                                         
C27949     MOVE 'DATABASE'                     TO C8-DELINQ-CD.         
C27949     MOVE '01'                           TO C8-COMPANY-NO.        
C27949     PERFORM 1900-SELECT-DELINQUENCY     THRU 1900-EXIT.          
C27949     MOVE WS-HOLD-DEL-VALUE              TO WS-DATABASE           
                                                                        
           PERFORM 6251-GET-FJC01-DATE         THRU 6251-EXIT.          
           IF  COMMON-DATE-NEEDED                                       
               PERFORM 6240-GET-FCA00-COMMON-DATE                       
                                               THRU 6240-EXIT           
               MOVE WS-FCA00-COMMON-DATE       TO WS-INPUT-DATE         
           END-IF.                                                      
      *                                                                 04650000
           MOVE WS-INPUT-DATE                  TO BI-DATE-BILLED,       
                                                  WS-WRITE-OFF-DT,      
                                                  WS-PROCESS-DATE,      
                                                  WS-HOLD-DATE.         
      *                                                                         
           PERFORM 7500-GET-CURRENT-DATE       THRU 7500-EXIT.          
                                                                        
           PERFORM 1800-GET-NEXT-BUSINESS-DAY THRU 1800-EXIT.           
           MOVE WS-HOLD-DATE TO WS-NEXT-DAY.                            
C30169     MOVE '01'        TO C8-COMPANY-NO.                           
           MOVE WS-DAY-COLL TO C8-DELINQ-CD.                            
           PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT.              
           MOVE WS-HOLD-DEL-VALUE TO WS-ACTIVE-DAYS.                    
                                                                        
           MOVE WS-AMT-COLL TO C8-DELINQ-CD.                            
           PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT.              
           MOVE WS-HOLD-DEL-VALUE TO WS-DELINQ-AMOUNT.                  
                                                                        
C27949     MOVE WS-DELQ-WRITE-OFF TO C8-DELINQ-CD.                      
C27949     PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT.              
C27949     MOVE WS-HOLD-DEL-VALUE TO WS-DELINQ-WRITE-OFF-AMT.           
                                                                        
C27949     MOVE WS-SVC-CARE TO C8-DELINQ-CD                             
C27949     PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT.              
C27949     MOVE WS-HOLD-DEL-VALUE TO WS-SVC-CARE-FL.                    
                                                                        
C30169     IF  CSR-DATABASE                                             
C30169         MOVE '26'    TO C8-COMPANY-NO                            
C30169         MOVE WS-DAY-COLL TO C8-DELINQ-CD                         
C30169         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30169         MOVE WS-HOLD-DEL-VALUE TO WS-ACTIVE-DAYS-PSNC            
C30169                                                                  
C30169         MOVE WS-AMT-COLL TO C8-DELINQ-CD                         
C30169         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30169         MOVE WS-HOLD-DEL-VALUE TO WS-DELINQ-AMOUNT-PSNC          
C30169                                                                  
C30169         MOVE WS-DELQ-WRITE-OFF TO C8-DELINQ-CD                   
C30169         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30169         MOVE WS-HOLD-DEL-VALUE TO WS-DELINQ-WRITE-OFF-AMT-PSNC   
C30169                                                                  
C30169         MOVE WS-SVC-CARE TO C8-DELINQ-CD                         
C30169         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30169         MOVE WS-HOLD-DEL-VALUE TO WS-SVC-CARE-FL-PSNC            
C30169     END-IF                                                       
C30070     IF SEB-DATABASE                                              
C30070         MOVE WS-BEH-MODEL-A-CHAMP-REG TO C8-DELINQ-CD            
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30070         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-A-COLL-FLAG-REG-CH      
C30070                                                                  
C30070         MOVE WS-BEH-MODEL-B-CHAMP-REG TO C8-DELINQ-CD            
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30070         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-B-COLL-FLAG-REG-CH      
C30070                                                                  
C30070         MOVE WS-BEH-MODEL-C-CHAMP-REG TO C8-DELINQ-CD            
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30070         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-C-COLL-FLAG-REG-CH      
C30070                                                                  
C30070         MOVE WS-BEH-MODEL-D-CHAMP-REG TO C8-DELINQ-CD            
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30070         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-D-COLL-FLAG-REG-CH      
C30070                                                                  
C30070         MOVE WS-BEH-MODEL-E-CHAMP-REG TO C8-DELINQ-CD            
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30070         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-E-COLL-FLAG-REG-CH      
C30070                                                                  
C30070         MOVE WS-BEH-MODEL-F-CHAMP-REG TO C8-DELINQ-CD            
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30070         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-F-COLL-FLAG-REG-CH      
C30070                                                                  
C30070         MOVE WS-BEH-MODEL-G-CHAMP-REG TO C8-DELINQ-CD            
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30070         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-G-COLL-FLAG-REG-CH      
C30070                                                                  
C30070         MOVE WS-BEH-MODEL-H-CHAMP-REG TO C8-DELINQ-CD            
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30070         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-H-COLL-FLAG-REG-CH      
C30070                                                                  
C30070         MOVE WS-BEH-MODEL-A-CHAMP-DEREG TO C8-DELINQ-CD          
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30070         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-A-COLL-FLAG-DEREG-CH    
C30070                                                                  
C30070         MOVE WS-BEH-MODEL-B-CHAMP-DEREG TO C8-DELINQ-CD          
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30070         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-B-COLL-FLAG-DEREG-CH    
C30070                                                                  
C30070         MOVE WS-BEH-MODEL-C-CHAMP-DEREG TO C8-DELINQ-CD          
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30070         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-C-COLL-FLAG-DEREG-CH    
C30070                                                                  
C30070         MOVE WS-BEH-MODEL-D-CHAMP-DEREG TO C8-DELINQ-CD          
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30070         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-D-COLL-FLAG-DEREG-CH    
C30070                                                                  
C30070         MOVE WS-BEH-MODEL-E-CHAMP-DEREG TO C8-DELINQ-CD          
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30070         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-E-COLL-FLAG-DEREG-CH    
C30070                                                                  
C30070         MOVE WS-BEH-MODEL-F-CHAMP-DEREG TO C8-DELINQ-CD          
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30070         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-F-COLL-FLAG-DEREG-CH    
C30070                                                                  
C30070         MOVE WS-BEH-MODEL-G-CHAMP-DEREG TO C8-DELINQ-CD          
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30070         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-G-COLL-FLAG-DEREG-CH    
C30070                                                                  
C30070         MOVE WS-BEH-MODEL-H-CHAMP-DEREG TO C8-DELINQ-CD          
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30070         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-H-COLL-FLAG-DEREG-CH    
C30070                                                                  
C30070         MOVE WS-BEH-MODEL-A-CHALL-REG TO C8-DELINQ-CD            
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30070         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-A-COLL-FLAG-REG-CR      
C30070                                                                  
C30070         MOVE WS-BEH-MODEL-B-CHALL-REG TO C8-DELINQ-CD            
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30070         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-B-COLL-FLAG-REG-CR      
C30070                                                                  
C30070         MOVE WS-BEH-MODEL-C-CHALL-REG TO C8-DELINQ-CD            
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
A04491         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-C-COLL-FLAG-REG-CR      
C30070                                                                  
C30070         MOVE WS-BEH-MODEL-D-CHALL-REG TO C8-DELINQ-CD            
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30070         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-D-COLL-FLAG-REG-CR      
C30070                                                                  
C30070         MOVE WS-BEH-MODEL-E-CHALL-REG TO C8-DELINQ-CD            
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30070         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-E-COLL-FLAG-REG-CR      
C30070                                                                  
C30070         MOVE WS-BEH-MODEL-F-CHALL-REG TO C8-DELINQ-CD            
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30070         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-F-COLL-FLAG-REG-CR      
C30070                                                                  
C30070         MOVE WS-BEH-MODEL-G-CHALL-REG TO C8-DELINQ-CD            
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30070         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-G-COLL-FLAG-REG-CR      
C30070                                                                  
C30070         MOVE WS-BEH-MODEL-H-CHALL-REG TO C8-DELINQ-CD            
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30070         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-H-COLL-FLAG-REG-CR      
C30070                                                                  
C30070         MOVE WS-BEH-MODEL-A-CHALL-DEREG TO C8-DELINQ-CD          
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30070         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-A-COLL-FLAG-DEREG-CR    
C30070                                                                  
C30070         MOVE WS-BEH-MODEL-B-CHALL-DEREG TO C8-DELINQ-CD          
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30070         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-B-COLL-FLAG-DEREG-CR    
C30070                                                                  
C30070         MOVE WS-BEH-MODEL-C-CHALL-DEREG TO C8-DELINQ-CD          
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30070         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-C-COLL-FLAG-DEREG-CR    
C30070                                                                  
C30070         MOVE WS-BEH-MODEL-D-CHALL-DEREG TO C8-DELINQ-CD          
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30070         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-D-COLL-FLAG-DEREG-CR    
C30070                                                                  
C30070         MOVE WS-BEH-MODEL-E-CHALL-DEREG TO C8-DELINQ-CD          
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30070         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-E-COLL-FLAG-DEREG-CR    
C30070                                                                  
C30070         MOVE WS-BEH-MODEL-F-CHALL-DEREG TO C8-DELINQ-CD          
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30070         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-F-COLL-FLAG-DEREG-CR    
C30070                                                                  
C30070         MOVE WS-BEH-MODEL-G-CHALL-DEREG TO C8-DELINQ-CD          
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30070         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-G-COLL-FLAG-DEREG-CR    
C30070                                                                  
C30070         MOVE WS-BEH-MODEL-H-CHALL-DEREG TO C8-DELINQ-CD          
C30070         PERFORM 1900-SELECT-DELINQUENCY THRU 1900-EXIT           
C30070         MOVE WS-HOLD-DEL-VALUE TO WS-BHV-H-COLL-FLAG-DEREG-CR    
C30070     END-IF.                                                      
C30070                                                                  
           MOVE WS-INPUT-DATE TO WS-HOLD-DATE.                          
           PERFORM 1800-GET-NEXT-BUSINESS-DAY THRU 1800-EXIT            
              VARYING WS-DAY-COUNTER FROM 1 BY 1                        
              UNTIL WS-DAY-COUNTER = WS-ACTIVE-DAYS.                    
                                                                        
           MOVE WS-HOLD-DATE TO WS-CALC-DATE.                           
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * PASSES CONTROL TO PROCESS EACH ACCOUNT FROM BILL-HDR CURSOR   **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 7000-OPEN-BILL-HDR-CURSOR   THRU 7000-EXIT.          
                                                                        
           PERFORM 7010-FETCH-BILL-HDR-CURSOR  THRU 7010-EXIT.          
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
C30169         IF CSR-DATABASE                                          
C30169            IF AT-COMPANY-NO = '26'                               
C30169               PERFORM 1010-LOAD-DELINQ-VALUES                    
C30169                  THRU 1010-EXIT                                  
C30169            END-IF                                                
C30169         END-IF                                                   
C27949         MOVE BI-ACCOUNT-NO TO AT-ACCOUNT-NO                      
C27949                               HC-ACCOUNT-NO                      
A04491         IF SEB-DATABASE                                          
A04491            MOVE 'N'           TO WS-SEB-REGULATED-FLAG           
A04491            MOVE AT-ACCOUNT-NO TO LR-ACCOUNT-NO                   
A04491            PERFORM 7800-SELECT-REG-PROFILE THRU 7800-EXIT        
A04491         END-IF                                                   
               COMPUTE WS-TOTAL-ARREARS = AC-AMT-AR-DAY-30 +            
                                          AC-AMT-AR-DAY-60 +            
                                          AC-AMT-AR-DAY-90              
               IF  WS-TOTAL-ARREARS > WS-DELINQ-AMOUNT                  
C27949             MOVE 'N' TO WS-COLLECT-ACTIVE-FLAG                   
C27949             PERFORM 7200-CHECK-FOR-COLLECTION THRU 7200-EXIT     
C27949             IF  WS-COLLECT-ACTIVE                                
C27949                 CONTINUE                                         
C27949             ELSE                                                 
C27949                 PERFORM 7300-GET-ACCT-DETAILS THRU 7300-EXIT     
C27949                 IF  CSR-DATABASE                                 
C27949                     PERFORM 7170-COMPUTE-NONUTL-ARREARS          
C27949                       THRU 7170-EXIT                             
C27949                 END-IF                                           
C27949                 PERFORM 6100-PROCESS-COLLECTION                  
C27949                    THRU 6100-PROCESS-COLLECTION-EXIT             
C27949                 IF  ACTIVE-COLLECTION                            
C27949*                    MOVE BI-ACCOUNT-NO TO AT-ACCOUNT-NO                  
                           PERFORM 2000-PROCESS-COLL-HIST               
                                              THRU 2000-EXIT            
                       END-IF                                           
C27949             END-IF                                               
C27949         END-IF                                                   
               PERFORM 7010-FETCH-BILL-HDR-CURSOR THRU 7010-EXIT        
           END-PERFORM.                                                 
           PERFORM 7020-CLOSE-BILL-HDR-CURSOR  THRU 7020-EXIT.          
                                                                        
           PERFORM 7100-OPEN-FINAL-WO-CURSOR THRU 7100-EXIT.            
                                                                        
           PERFORM 7110-FETCH-FINAL-WO-CURSOR THRU 7110-EXIT.           
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
P00599     INITIALIZE WS-WO-DATE                                        
P00599                WS-THIRD-FINAL-DT                                 
C30169         IF CSR-DATABASE                                          
C30169            IF AT-COMPANY-NO = '26'                               
C30169               PERFORM 1010-LOAD-DELINQ-VALUES                    
C30169                  THRU 1010-EXIT                                  
C30169            END-IF                                                
C30169         END-IF                                                   
A04491         IF SEB-DATABASE                                          
A04491            MOVE 'N'           TO WS-SEB-REGULATED-FLAG           
A04491            MOVE KD-ACCOUNT-NO TO LR-ACCOUNT-NO                   
A04491            PERFORM 7800-SELECT-REG-PROFILE THRU 7800-EXIT        
A04491         END-IF                                                   
C30169         EVALUATE KD-FW-ACTION-TYPE-CD                            
C30169            WHEN 'WO'                                             
C30169               MOVE KD-FW-ACTION-DT TO WS-WO-DATE                 
C30169            WHEN '90302'                                          
C30169            WHEN '90305'                                          
C30169               MOVE KD-FW-ACTION-DT TO WS-THIRD-FINAL-DT          
P00599            WHEN 'LPC'                                            
P00599               DISPLAY 'PROCESSING LPC ACCT ' KD-ACCOUNT-NO       
C30169         END-EVALUATE                                             
               MOVE 'N' TO WS-PROCESS-FLAG                              
               MOVE ZEROS TO AC-AMT-AR-DAY-00,                          
                             AC-AMT-AR-DAY-30,                          
                             AC-AMT-AR-DAY-60,                          
                             AC-AMT-AR-DAY-90                           
C27949         MOVE 'N' TO WS-COLLECT-ACTIVE-FLAG                       
C30169         MOVE KD-ACCOUNT-NO             TO AT-ACCOUNT-NO          
C27949                                           HC-ACCOUNT-NO          
C27949         PERFORM 7200-CHECK-FOR-COLLECTION THRU 7200-EXIT         
C27949         IF  WS-COLLECT-ACTIVE                                    
C27949             CONTINUE                                             
C27949         ELSE                                                     
C30169             IF KD-FW-ACTION-DT = WS-WO-DATE                      
                      PERFORM 7150-COMPUTE-WO-AMOUNT THRU 7150-EXIT     
                      IF WS-WO-BALANCE > 0                              
                         MOVE 'Y' TO WS-PROCESS-FLAG                    
C27949                   MOVE WS-WO-BALANCE  TO WS-TOTAL-ARREARS        
                      END-IF                                            
                   ELSE                                                 
                      PERFORM 7160-COMPUTE-FB-AMOUNT THRU 7160-EXIT     
                      COMPUTE WS-TOTAL-ARREARS = AC-AMT-AR-DAY-30 +     
                                                 AC-AMT-AR-DAY-60 +     
                                                 AC-AMT-AR-DAY-90       
                      IF WS-TOTAL-ARREARS > WS-DELINQ-AMOUNT            
                            MOVE 'Y' TO WS-PROCESS-FLAG                 
                      END-IF                                            
                   END-IF                                               
                   IF WS-PROCESS                                        
C27949                PERFORM 7300-GET-ACCT-DETAILS THRU 7300-EXIT      
C27949                PERFORM 6100-PROCESS-COLLECTION                   
C27949                   THRU 6100-PROCESS-COLLECTION-EXIT              
C27949                IF  ACTIVE-COLLECTION                             
C27949*                   MOVE FW-ACCOUNT-NO TO AT-ACCOUNT-NO                   
                          PERFORM 2000-PROCESS-COLL-HIST THRU 2000-EXIT 
C27949                END-IF                                            
C27949             END-IF                                               
               END-IF                                                   
               PERFORM 7110-FETCH-FINAL-WO-CURSOR THRU 7110-EXIT        
           END-PERFORM.                                                 
                                                                        
           PERFORM 7120-CLOSE-FINAL-WO-CURSOR THRU 7120-EXIT.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
C30169 1010-LOAD-DELINQ-VALUES.                                         
C30169*                                                                         
C30169     MOVE WS-ACTIVE-DAYS-PSNC                                     
C30169       TO WS-ACTIVE-DAYS                                          
C30169     MOVE WS-DELINQ-AMOUNT-PSNC                                   
C30169       TO WS-DELINQ-AMOUNT                                        
C30169     MOVE WS-DELINQ-WRITE-OFF-AMT-PSNC                            
C30169       TO WS-DELINQ-WRITE-OFF-AMT                                 
C30169     MOVE WS-SVC-CARE-FL-PSNC                                     
C30169       TO WS-SVC-CARE-FL.                                         
C30169*                                                                         
C30169 1010-EXIT.                                                       
C30169     EXIT.                                                        
                                                                        
       1800-GET-NEXT-BUSINESS-DAY.                                      
                                                                        
           MOVE WS-N                   TO WS-DATE-FOUND.                
           PERFORM 7097-GET-NEXT-DAY             THRU 7097-EXIT.        
           IF WS-DAY EQUAL 6 OR                                         
              WS-DAY EQUAL ZEROS                                        
               PERFORM 1810-GET-NEXT-DATE        THRU 1810-EXIT         
                   UNTIL DATE-IS-FOUND                                  
           ELSE                                                         
               MOVE WS-N               TO WS-ROW-EXISTS                 
               MOVE WS-HOLD-DATE       TO J8-HOLIDAY-DT                 
               PERFORM 7095-SELECT-HOLIDAY       THRU 7095-EXIT         
               IF ROW-EXISTS                                            
                   PERFORM 1810-GET-NEXT-DATE    THRU 1810-EXIT         
                       UNTIL DATE-IS-FOUND                              
               ELSE                                                     
                   MOVE WS-Y TO WS-DATE-FOUND                           
               END-IF                                                   
           END-IF.                                                      
                                                                        
       1800-EXIT.                                                       
            EXIT.                                                       
                                                                        
       1810-GET-NEXT-DATE.                                              
      *                                                                         
           PERFORM 7097-GET-NEXT-DAY             THRU 7097-EXIT.        
           IF WS-DAY EQUAL 6 OR                                         
              WS-DAY EQUAL ZEROS                                        
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-N               TO WS-ROW-EXISTS                 
               MOVE WS-HOLD-DATE       TO J8-HOLIDAY-DT                 
               PERFORM 7095-SELECT-HOLIDAY       THRU 7095-EXIT         
               IF ROW-EXISTS                                            
                   CONTINUE                                             
               ELSE                                                     
                   MOVE WS-Y           TO WS-DATE-FOUND                 
               END-IF                                                   
           END-IF.                                                      
                                                                        
       1810-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 1900-SELECT-DELINQUENCY.                                    *          
      **      LOADS THE VALUES TO DETERMINE THE NUMBER OF DAYS BEFORE*          
      **      THE SECOND NOTICE DATE TO CONSIDER AN ACCOUNT FOR      *          
      **      COLLECTION QUE PROCESSING                              *          
      ****************************************************************          
       1900-SELECT-DELINQUENCY.                                         
                                                                        
           EXEC SQL                                                     
             SELECT DELINQ_VALUE                                        
               INTO :WS-HOLD-DEL-VALUE                                  
               FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                       
              WHERE DELINQ_CD    = :C8-DELINQ-CD                        
                AND COMPANY_NO   = :C8-COMPANY-NO                       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DELINQ_VALUE                                                
MFA-TR*        INTO :WS-HOLD-DEL-VALUE                                          
MFA-TR*        FROM CSS_DELINQUENCY                                             
MFA-TR*       WHERE DELINQ_CD    = :C8-DELINQ-CD                                
MFA-TR*         AND COMPANY_NO   = :C8-COMPANY-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY ' DELINQUENCY CODE ' C8-DELINQ-CD                 
              DISPLAY ' DELINQUENCY COMPANY ' C8-COMPANY-NO             
              DISPLAY '** DELINQUENCY TABLE  '                          
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** 1900 :  RETURN CODE ERROR - SELECT '          
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       1900-EXIT.                                                       
            EXIT.                                                       
                                                                        
       2000-PROCESS-COLL-HIST.                                          
                                                                        
           MOVE AT-ACCOUNT-NO TO HC-ACCOUNT-NO.                         
                                                                        
C27949*    MOVE 'N' TO WS-COLLECT-ACTIVE-FLAG.                                  
C27949*    PERFORM 7200-CHECK-FOR-COLLECTION THRU 7200-EXIT.                    
                                                                        
           IF NOT (WS-COLLECT-ACTIVE)                                   
              MOVE SPACES TO HC-CALL-QUEUE-ID                           
C27949*       PERFORM 7300-GET-ACCT-DETAILS THRU 7300-EXIT                      
              MOVE 'Y' TO WS-METER-ACTIVE-FLAG                          
              IF AT-CODE-ACCT-STAT = 'A'                                
                 PERFORM 2500-CHECK-ACTIVE-METER THRU 2500-EXIT         
              END-IF                                                    
              PERFORM 7350-CHECK-FOR-HVAC THRU 7350-EXIT                
              IF (WS-METER-ACTIVE) OR (WS-HVAC)                         
C27949        OR (CSR-DATABASE AND AT-CREDIT-GROUP = 'D')               
                 MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT    
                 IF WS-HVAC                                             
                    IF AT-CODE-ACCT-STAT = 'S'                          
                       PERFORM 7380-CHECK-FOR-HVAC-WO THRU 7380-EXIT    
                    ELSE                                                
                       PERFORM 7375-CHECK-HVAC-ARREARS THRU 7375-EXIT   
                    END-IF                                              
                 END-IF                                                 
                                                                        
                 IF WS-HVAC-ARREARS                                     
                    MOVE 'H' TO HC-CALL-QUEUE-ID(1:1)                   
                 ELSE                                                   
                   IF AT-CREDIT-GROUP NOT = 'D'                         
                      PERFORM 2200-FIND-ACCT-TYPE THRU 2200-EXIT        
                   ELSE                                                 
                      MOVE 'N' TO HC-CALL-QUEUE-ID(1:1)                 
                      MOVE SPACES TO UT-RATE-PLAN-NO                    
                   END-IF                                               
                 END-IF                                                 
                                                                        
                 PERFORM 2100-CHECK-ACCT-INFO THRU 2100-EXIT            
                                                                        
                 PERFORM 2300-FIND-DNP-DATE THRU 2300-EXIT              
                 MOVE SPACES TO HC-WRITE-OFF-DT                         
                 IF AT-CODE-ACCT-STAT NOT = 'B' AND 'S'                 
                    MOVE AT-BILL-CYCLE TO HC-BILL-CYCLE,                
                                          HC-CALL-QUEUE-ID(3:2)         
                 ELSE                                                   
                    IF AT-CODE-ACCT-STAT = 'B'                          
                       MOVE AT-ACCT-FINALED-DT TO WS-FINAL-WO-DATE      
                       PERFORM 2400-CALC-DAYS-DIFF THRU 2400-EXIT       
                       PERFORM 2600-GET-WO-DATE THRU 2600-EXIT          
                    ELSE                                                
C30169                 MOVE KD-FW-ACTION-DT TO WS-FINAL-WO-DATE         
                                               HC-WRITE-OFF-DT          
                       PERFORM 7210-GET-COLL-ACCT THRU 7210-EXIT        
                       IF WS-COLL-CONDITION-CD > SPACES                 
                          MOVE WS-COLL-CONDITION-CD                     
                                              TO HC-CALL-QUEUE-ID(3:1)  
                       ELSE                                             
C30169                    PERFORM 2610-PROCESS-ACTION-TYPE-CD           
C30169                       THRU 2610-EXIT                             
C30169                    IF WS-PLMT-TYPE > SPACES                      
C30169                       MOVE WS-PLMT-TYPE TO IZ-FW-ACTION-TYPE-CD  
C30169                       PERFORM 7220-GET-COLL-AGENCY THRU 7220-EXIT
C30169                    ELSE                                          
C30169                       MOVE  SPACES TO  IZ-CODE-COLLEC-AGNCY      
C30169                    END-IF                                        
C30169                    IF  IZ-CODE-COLLEC-AGNCY > SPACES             
C30169                        MOVE IZ-CODE-COLLEC-AGNCY                 
C30169                          TO HC-CALL-QUEUE-ID(3:3)                
                          ELSE                                          
                              PERFORM 2400-CALC-DAYS-DIFF THRU 2400-EXIT
                          END-IF                                        
                       END-IF                                           
                    END-IF                                              
                 END-IF                                                 
                 MOVE AT-CODE-ACCT-STAT TO HC-CODE-ACCT-STATUS          
                 MOVE AT-DATE-BILL-DAY-00 TO HC-LAST-BILL-DT            
                 MOVE AC-AMT-AR-DAY-00 TO HC-AMT-AR-DAY-00              
                 MOVE AC-AMT-AR-DAY-30 TO HC-AMT-AR-DAY-30              
                 MOVE AC-AMT-AR-DAY-60 TO HC-AMT-AR-DAY-60              
                 MOVE AC-AMT-AR-DAY-90 TO HC-AMT-AR-DAY-90              
                                                                        
                 IF AT-CODE-ACCT-STAT = 'B'                             
                    MOVE 'F' TO HC-CALL-QUEUE-ID(2:1)                   
                    MOVE WS-INPUT-DATE TO HC-FUTURE-WORK-DT             
                 ELSE                                                   
                    IF AT-CODE-ACCT-STAT = 'S'                          
                       MOVE 'W' TO HC-CALL-QUEUE-ID(2:1)                
                       MOVE WS-INPUT-DATE TO HC-FUTURE-WORK-DT          
                    ELSE                                                
                       IF HC-AMT-AR-DAY-90 > 0                          
                          MOVE '3' TO HC-CALL-QUEUE-ID(2:1)             
                          MOVE WS-INPUT-DATE TO HC-FUTURE-WORK-DT       
                       ELSE                                             
                          IF HC-AMT-AR-DAY-60 > 0                       
                             MOVE '2' TO HC-CALL-QUEUE-ID(2:1)          
                             MOVE WS-INPUT-DATE TO HC-FUTURE-WORK-DT    
                          ELSE                                          
                             IF HC-AMT-AR-DAY-30 > 0                    
                                MOVE '1' TO HC-CALL-QUEUE-ID(2:1)       
                                MOVE WS-CALC-DATE TO HC-FUTURE-WORK-DT  
                             END-IF                                     
                          END-IF                                        
                       END-IF                                           
                    END-IF                                              
                 END-IF                                                 
                 PERFORM 7550-GET-TIMESTAMP THRU 7550-EXIT              
                 MOVE WS-NEW-TIMESTAMP TO HC-COLL-HIST-SEQ-TS           
                                                                        
                 PERFORM 7700-INSERT-COLL-HIST THRU 7700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-CHECK-ACCT-INFO.                                            
                                                                        
           PERFORM 7310-CHECK-ACCT-INFO THRU 7310-EXIT.                 
                                                                        
           IF NOT (WS-ACCT-INFO-FOUND)                                  
               INITIALIZE DCLCSS-COLL-ACCT-INFO                         
               MOVE AT-ACCOUNT-NO TO IF-ACCOUNT-NO                      
               MOVE AT-CUSTOMER-NO TO IF-CUSTOMER-NO                    
               MOVE WS-CODE-MEDICAL TO IF-COLL-EXEMPTION-CD(4:1)        
               MOVE WS-CURRENT-DATE TO IF-RECORD-CREATION-DT            
               PERFORM 7750-INSERT-COLL-ACCT-INFO THRU 7750-EXIT        
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2200-FIND-ACCT-TYPE.                                             
                                                                        
           MOVE AT-ACCOUNT-NO TO UT-ACCOUNT-NO                          
C30169     PERFORM 7450-GET-RATE-PLAN-NO      THRU 7450-EXIT            
C30169     MOVE AT-ACCOUNT-TYPE-CODE       TO WS-ACCT-TYPE-VALUE        
C26954     IF  SEB-REGULATED                                            
C26954         IF  LR-REG-GROUP-CD = '100'                              
C26954             IF  LR-SENIOR-FL = 'Y'                               
C26954                 MOVE 'W' TO HC-CALL-QUEUE-ID(1:1)                
C26954             ELSE                                                 
C26954                 MOVE 'X' TO HC-CALL-QUEUE-ID(1:1)                
C26954             END-IF                                               
C26954         ELSE                                                     
C26954             IF  LR-REG-GROUP-CD = '200'                          
C26954                 MOVE AT-ACCOUNT-NO         TO CT-ACCOUNT-NO      
C26954                 MOVE 530                   TO CT-CNT-NAME-CD     
C26954                 PERFORM 7810-SELECT-GROUP1-CNT THRU 7810-EXIT    
C26954                 IF  WS-GROUP1-CNT-ACTIVE                         
C26954                     MOVE 'N' TO WS-GROUP1-CNT-FLAG               
C26954*  SUBTRACT GROUP1 CNT AMT FROM TOTAL 00 DAY MONEY                        
C26954                     COMPUTE WS-GRP2-AR-DAY-00 = AC-AMT-AR-DAY-00 
C26954                                   - WS-AMT-AR-DAY-00             
C26954                     IF  WS-GRP2-AR-DAY-00 > 5                    
C26954*  IF GROUP1 CNT BALANCE EXISTS - ASSIGN 'Y'                              
C26954                         IF  WS-AMT-TRAN-BALANCE  > 0             
C26954                             MOVE 'Y' TO HC-CALL-QUEUE-ID(1:1)    
C26954                         ELSE                                     
C26954                             MOVE 'Z' TO HC-CALL-QUEUE-ID(1:1)    
C26954                         END-IF                                   
C26954                     ELSE                                         
C26954*  IF GROUP1 CNT ARREARS EXISTS - ASSIGN 'Y'                              
C26954                         IF  WS-GROUP1-CNT-ARREARS > 0            
C26954                             MOVE 'Y' TO HC-CALL-QUEUE-ID(1:1)    
C26954                         ELSE                                     
C26954                             MOVE 'Z' TO HC-CALL-QUEUE-ID(1:1)    
C26954                         END-IF
                           END-IF                                   
C26954                 ELSE                                             
C26954                     MOVE 'Z' TO HC-CALL-QUEUE-ID(1:1)            
C26954                 END-IF                                           
C26954             END-IF                                               
C26954         END-IF                                                   
C26954         GO TO 2200-EXIT                                          
C26954     END-IF                                                       
P00453*CHECK FOR PAYNGO CUSTOMERS                                               
P00453     IF SEB-DATABASE                                              
P00453         MOVE AT-ACCOUNT-NO TO PK-ACCOUNT-NO                      
P00453         MOVE SPACE TO WS-PAYNGO-CUST-FLAG                        
P00453         PERFORM 7900-CHECK-PAYNGO-CUST THRU 7900-EXIT            
P00453         IF WS-PAYNGO-CUST-FLAG = 'Y'                             
P00453             MOVE 'P' TO HC-CALL-QUEUE-ID(1:1)                    
P00453             GO TO 2200-EXIT                                      
P00453         END-IF                                                   
P00453     END-IF                                                       
C28513*CHANGES TO INCLUDE ACCTS WITH RATES 450, 461, 462 AND 463 IN THE         
C28513*FIRM COLLECTION QUEUE 'Fxxx'                                             
C28513     MOVE UT-RATE-PLAN-NO    TO WS-FIRM-RATE                      
C28513     IF  FIRM-RATE                                                
C28513         MOVE 'F' TO HC-CALL-QUEUE-ID(1:1)                        
C28513     ELSE                                                         
C30169         IF WS-ACCT-TYPE-VALUE = 'R'                              
                  MOVE 'R' TO HC-CALL-QUEUE-ID(1:1)                     
               ELSE                                                     
                  IF UT-RATE-PLAN-NO = '464'                            
                     MOVE 'F' TO HC-CALL-QUEUE-ID(1:1)                  
                  ELSE                                                  
                     MOVE 'C' TO HC-CALL-QUEUE-ID(1:1)                  
                  END-IF                                                
               END-IF                                                   
C28513     END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2300-FIND-DNP-DATE.                                              
                                                                        
           EXEC SQL                                                     
               SELECT CL.DATE_CREDIT_ACTION                             
                INTO  :CL-DATE-CREDIT-ACTION :WS-DATE-CRED-ACT-NULL     
                FROM  CSS_CRED_COLL CL WITH(READUNCOMMITTED)                    
               WHERE  CL.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                 AND  CL.CODE_NOTICE_TYPE = 'D'                         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     32960000
MFA-TR*        SELECT CL.DATE_CREDIT_ACTION                             32970000
MFA-TR*         INTO  :CL-DATE-CREDIT-ACTION :WS-DATE-CRED-ACT-NULL     32980000
MFA-TR*         FROM  CSS_CRED_COLL CL                                          
MFA-TR*        WHERE  CL.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*          AND  CL.CODE_NOTICE_TYPE = 'D'                                 
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                    33080000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-DATE-CRED-ACT-NULL < 0                              
                  MOVE LOW-VALUES TO CL-DATE-CREDIT-ACTION              
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                  MOVE LOW-VALUES TO CL-DATE-CREDIT-ACTION              
              ELSE                                                      
                  DISPLAY '********** PCSCA142 ABORT ************'      
                  DISPLAY '* 2300-FIND-DNP-DATE                 *'      
                  DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE        
                  DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                
                  DISPLAY '* PROGRAM ABORTING...                *'      
                  DISPLAY '********** PCSCA142 ABORT ************'      
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2400-CALC-DAYS-DIFF.                                             
                                                                        
           EXEC SQL                                                     
T33928        SELECT
              CIS.DAYS( IIF(TRY_CONVERT(DATE, :WS-PROCESS-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PROCESS-DATE
              ) <> 0) OR (LEN(:WS-PROCESS-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-PROCESS-DATE
              ), CONVERT(DATE, :WS-PROCESS-DATE) ) )               
T33928                           - CIS.DAYS( IIF(TRY_CONVERT(DATE, 
                                                      :WS-FINAL-WO-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-FINAL-WO-DATE
              ) <> 0) OR (LEN(:WS-FINAL-WO-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-FINAL-WO-DATE
              ), CONVERT(DATE, :WS-FINAL-WO-DATE) ) )
            INTO
              :WS-DAYS-DIFF              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-DAYS-DIFF =  DAYS(:WS-PROCESS-DATE)                       
MFA-TR*                          - DAYS(:WS-FINAL-WO-DATE)                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C27949     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C27949     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
C27949         CONTINUE                                                 
C27949     ELSE                                                         
C27949         DISPLAY '********** PCSCA142 ABORT ************'         
C27949         DISPLAY '* 2400-CALC-DAYS-DIFF    '                      
C27949         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
C27949         DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                   
C27949         DISPLAY '* PROGRAM ABORTING...                *'         
C27949         DISPLAY '********** PCSCA142 ABORT ************'         
C27949         PERFORM 9900-ABEND THRU 9900-EXIT                        
C27949     END-IF.                                                      
C29288*                                                                         
C29288     MOVE WS-FINAL-WO-DATE  TO WS-HOLD-DATE.                      
C29288     MOVE ZEROS             TO WS-BUS-DAY-DIFF.                   
C29288*                                                                         
T29288     IF  WS-HOLD-DATE <= WS-PROCESS-DATE                          
C29288         PERFORM UNTIL WS-HOLD-DATE = WS-PROCESS-DATE             
C29288            PERFORM 1800-GET-NEXT-BUSINESS-DAY THRU 1800-EXIT     
C29288            MOVE WS-HOLD-DATE TO WS-NEXT-DAY                      
C29288            ADD 1             TO WS-BUS-DAY-DIFF                  
C29288         END-PERFORM                                              
C29288     END-IF.                                                      
C29288*                                                                         
C29288     MOVE WS-BUS-DAY-DIFF   TO WS-DAYS-DIFF.                      
C29288*                                                                         
           IF AT-CODE-ACCT-STAT = 'B'                                   
            EVALUATE TRUE                                               
              WHEN WS-DAYS-DIFF >= 0                                    
              AND WS-DAYS-DIFF < 6   MOVE '05' TO HC-CALL-QUEUE-ID(3:2) 
             WHEN WS-DAYS-DIFF > 5                                      
              AND WS-DAYS-DIFF < 11  MOVE '10' TO HC-CALL-QUEUE-ID(3:2) 
             WHEN WS-DAYS-DIFF > 10                                     
              AND WS-DAYS-DIFF < 16  MOVE '15' TO HC-CALL-QUEUE-ID(3:2) 
             WHEN WS-DAYS-DIFF > 15                                     
              AND WS-DAYS-DIFF < 21  MOVE '20' TO HC-CALL-QUEUE-ID(3:2) 
             WHEN WS-DAYS-DIFF > 20                                     
              AND WS-DAYS-DIFF < 26  MOVE '25' TO HC-CALL-QUEUE-ID(3:2) 
             WHEN WS-DAYS-DIFF > 25                                     
              AND WS-DAYS-DIFF < 31  MOVE '30' TO HC-CALL-QUEUE-ID(3:2) 
             WHEN WS-DAYS-DIFF > 30                                     
              AND WS-DAYS-DIFF < 36  MOVE '35' TO HC-CALL-QUEUE-ID(3:2) 
             WHEN WS-DAYS-DIFF > 35                                     
              AND WS-DAYS-DIFF < 41  MOVE '40' TO HC-CALL-QUEUE-ID(3:2) 
             WHEN WS-DAYS-DIFF > 40                                     
              AND WS-DAYS-DIFF < 46  MOVE '45' TO HC-CALL-QUEUE-ID(3:2) 
             WHEN WS-DAYS-DIFF > 45                                     
              AND WS-DAYS-DIFF < 51  MOVE '50' TO HC-CALL-QUEUE-ID(3:2) 
             WHEN OTHER              MOVE '55' TO HC-CALL-QUEUE-ID(3:2) 
            END-EVALUATE                                                
           ELSE                                                         
            IF WS-DAYS-DIFF >= 0 AND WS-DAYS-DIFF < 6                   
               MOVE '05' TO HC-CALL-QUEUE-ID(3:2)                       
            ELSE                                                        
               MOVE '10' TO HC-CALL-QUEUE-ID(3:2)                       
            END-IF                                                      
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2500-CHECK-ACTIVE-METER.                                         
                                                                        
           EXEC SQL                                                     
               SELECT ACCOUNT_NO                                        
                 INTO :MN-ACCOUNT-NO                                    
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                 AND CODE_METER_STATUS NOT IN ('J','K')                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :MN-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*          AND CODE_METER_STATUS NOT IN ('J','K')                         
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -811       
               CONTINUE                                                 
           ELSE                                                         
C27949         IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
C27949             MOVE 'N' TO WS-METER-ACTIVE-FLAG                     
C27949         ELSE                                                     
C27949            DISPLAY '********** PCSCA142 ABORT ************'      
C27949            DISPLAY '* 2500-CHECK-ACTIVE-METER'                   
C27949            DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE        
C27949            DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                
C27949            DISPLAY '* PROGRAM ABORTING...                *'      
C27949            DISPLAY '********** PCSCA142 ABORT ************'      
C27949            PERFORM 9900-ABEND THRU 9900-EXIT                     
C27949         END-IF                                                   
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2600-GET-WO-DATE.                                                
                                                                        
           EXEC SQL                                                     
C30169         SELECT TOP(1) FW_ACTION_DT                                      
C30169           INTO :KD-FW-ACTION-DT                                  
C30169           FROM CSS_FIN_WO_ACTION WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                AND  FW_ACTION_TYPE_CD = 'WO'                           
                AND  FW_ACTION_AM = 0                                   
                ORDER BY FW_SEQ_NO DESC                                 
                                                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FW_ACTION_DT                                              
MFA-TR*          INTO :KD-FW-ACTION-DT                                          
MFA-TR*          FROM CSS_FIN_WO_ACTION                                         
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*         AND  FW_ACTION_TYPE_CD = 'WO'                                   
MFA-TR*         AND  FW_ACTION_AM = 0                                           
MFA-TR*         ORDER BY FW_SEQ_NO DESC                                         
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C30169         MOVE KD-FW-ACTION-DT TO HC-WRITE-OFF-DT                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND OR -811          
                 CONTINUE                                               
              ELSE                                                      
                  DISPLAY '********** PCSCA142 ABORT ************'      
                  DISPLAY '* 2600-GET-WO-DATE'                          
                  DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE        
                  DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                
                  DISPLAY '* PROGRAM ABORTING...                *'      
                  DISPLAY '********** PCSCA142 ABORT ************'      
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
C30169******************************************************************        
      *2610-PROCESS-ACTION-TYPE-CD.                                   *         
      ******************************************************************        
C30169*                                                                         
C30169 2610-PROCESS-ACTION-TYPE-CD.                                     
C30169     INITIALIZE WS-PLMT-TYPE.                                     
C30169     PERFORM 7510-SELECT-FINAL-WO       THRU 7510-EXIT            
C30169     EVALUATE FW-COLLECT-STATUS-CD                                
C30169         WHEN 'F'                                                 
C30169              MOVE '1PLMT'              TO WS-PLMT-TYPE           
C30169         WHEN 'H'                                                 
C30169              MOVE '2PLMT'              TO WS-PLMT-TYPE           
C30169         WHEN 'J'                                                 
C30169              MOVE '3PLMT'              TO WS-PLMT-TYPE           
C30169         WHEN 'D'                                                 
C30169              MOVE 'ATY'                TO WS-PLMT-TYPE           
C30169         WHEN OTHER                                               
C30169              MOVE SPACES               TO WS-PLMT-TYPE           
C30169     END-EVALUATE.                                                
C30169                                                                  
C30169 2610-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
                                                                        
C27949******************************************************************        
C27949* PARAGRAPH 6100-PROCESS-COLLECTION  IS IN CPD00319.              11187000
C27949******************************************************************11187100
C27949     EXEC SQL                                                             
C27949        INCLUDE CPD00319                                          11187200
C27949     END-EXEC.                                                            
      ******************************************************************        
      * PARAGRAPH 6240-GET-FCA00-COMMON-DATE IS IN CPD00040.            11187000
      ******************************************************************11187100
       COPY CPD00040.                                                   11187200
       COPY CPD00037.                                                   11188800
                                                                        
      ******************************************************************        
      * PARAGRAPH 7550-START-FCSJC01 IS IN CPD00038.                            
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * PARAGRAPH 7620-START-FCSCA00 IS IN CPD00039                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      **  OPENS BILL-HDR CURSOR TO GET ACCOUNTS BILLED FOR THE JOB    **        
      **  PARM DATE                                                   **        
      ******************************************************************        
      *                                                                         
       7000-OPEN-BILL-HDR-CURSOR.                                       
      *                                                                         
           EXEC SQL                                                     
              OPEN BILL-HDR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA142 ABORT ************'         
               DISPLAY '* 7000-OPEN-BILL-HDR-CURSOR          *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* BILL DATE ' , WS-INPUT-DATE                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA142 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCHES ACCOUNT NO, BILL CYCLE                              **        
      ******************************************************************        
      *                                                                         
       7010-FETCH-BILL-HDR-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
              FETCH BILL-HDR                                            
               INTO :BI-ACCOUNT-NO                                      
                   ,:AC-AMT-AR-DAY-00                                   
                   ,:AC-AMT-AR-DAY-30                                   
                   ,:AC-AMT-AR-DAY-60                                   
                   ,:AC-AMT-AR-DAY-90                                   
C30169             ,:AT-COMPANY-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA142 ABORT ************'         
               DISPLAY '* 7010-FETCH-BILL-HDR                *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* BILL DATE ' , WS-INPUT-DATE                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA142 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSES BILL-HDR CURSOR                                      **        
      ******************************************************************        
      *                                                                         
       7020-CLOSE-BILL-HDR-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
              CLOSE BILL-HDR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA142 ABORT ************'         
               DISPLAY '* 7020-CLOSE-BILL-HDR-CURSOR         *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* BILL DATE ' , WS-INPUT-DATE                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA142 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7100-OPEN-FINAL-WO-CURSOR.                                       
      *                                                                         
           EXEC SQL                                                     
              OPEN FINAL-WO                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA142 ABORT ************'         
               DISPLAY '* 7100-OPEN-FINAL-WO-CURSOR        *'           
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* BILL DATE ' , WS-INPUT-DATE                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA142 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCHES ACCOUNT NO, BILL CYCLE                              **        
      ******************************************************************        
      *                                                                         
       7110-FETCH-FINAL-WO-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
              FETCH FINAL-WO                                            
               INTO :KD-ACCOUNT-NO                                      
C30169             ,:KD-FW-ACTION-DT                                    
C30169             ,:KD-FW-ACTION-TYPE-CD                               
C30169             ,:AT-COMPANY-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA142 ABORT ************'         
               DISPLAY '* 7110-FETCH-FINAL-WO                *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* BILL DATE ' , WS-INPUT-DATE                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA142 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSES FINAL-WO CURSOR                                      **        
      ******************************************************************        
      *                                                                         
       7120-CLOSE-FINAL-WO-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
              CLOSE FINAL-WO                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA142 ABORT ************'         
               DISPLAY '* 7120-CLOSE-FINAL-WO-CURSOR       *'           
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* BILL DATE ' , WS-INPUT-DATE                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA142 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7150-COMPUTE-WO-AMOUNT.                                          
                                                                        
           EXEC SQL                                                     
              SELECT                                                    
                 SUM(AMT_TRANS)                                         
              INTO                                                      
                 :WS-WO-BALANCE :WS-WO-BALANCE-NULL                     
              FROM                                                      
                 CSS_CHRG_OFF WITH(READUNCOMMITTED)                             
              WHERE                                                     
C30169           ACCOUNT_NO = :KD-ACCOUNT-NO                            
                                                                 
          END-EXEC.                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*          SUM(AMT_TRANS)                                                 
MFA-TR*       INTO                                                              
MFA-TR*          :WS-WO-BALANCE :WS-WO-BALANCE-NULL                             
MFA-TR*       FROM                                                              
MFA-TR*          CSS_CHRG_OFF                                                   
MFA-TR*       WHERE                                                             
MFA-TR*          ACCOUNT_NO = :KD-ACCOUNT-NO                                    
MFA-TR*         WITH UR                                                         
MFA-TR*   END-EXEC.                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               IF WS-WO-BALANCE-NULL < 0                                
                  MOVE ZEROS TO WS-WO-BALANCE                           
               END-IF                                                   
           ELSE                                                         
               DISPLAY '********** PCSCA142 ABORT ************'         
               DISPLAY '* 7150-COMPUTE-WO-AMOUNT             *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* ACCOUNT NO ' , KD-ACCOUNT-NO                  
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA142 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7160-COMPUTE-FB-AMOUNT.                                          
                                                                        
           EXEC SQL                                                     
               SELECT                                                   
                  SUM(AC.AMT_AR_DAY_00) AS SUM00                        
                 ,SUM(AC.AMT_AR_DAY_30) AS SUM30                        
                 ,SUM(AC.AMT_AR_DAY_60) AS SUM60                        
                 ,SUM(AC.AMT_AR_DAY_90) AS SUM90                        
               INTO                                                     
                   :AC-AMT-AR-DAY-00 :WS-AMT-AR-DAY-00-NULL             
                  ,:AC-AMT-AR-DAY-30 :WS-AMT-AR-DAY-30-NULL             
                  ,:AC-AMT-AR-DAY-60 :WS-AMT-AR-DAY-60-NULL             
                  ,:AC-AMT-AR-DAY-90 :WS-AMT-AR-DAY-90-NULL             
               FROM CSS_AR_CNTL AC WITH(READUNCOMMITTED)                        
C30169         WHERE AC.ACCOUNT_NO = :KD-ACCOUNT-NO                     
                 AND AC.ITEM_ID = 00                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*           SUM(AC.AMT_AR_DAY_00) AS SUM00                                
MFA-TR*          ,SUM(AC.AMT_AR_DAY_30) AS SUM30                                
MFA-TR*          ,SUM(AC.AMT_AR_DAY_60) AS SUM60                                
MFA-TR*          ,SUM(AC.AMT_AR_DAY_90) AS SUM90                                
MFA-TR*        INTO                                                             
MFA-TR*            :AC-AMT-AR-DAY-00 :WS-AMT-AR-DAY-00-NULL                     
MFA-TR*           ,:AC-AMT-AR-DAY-30 :WS-AMT-AR-DAY-30-NULL                     
MFA-TR*           ,:AC-AMT-AR-DAY-60 :WS-AMT-AR-DAY-60-NULL                     
MFA-TR*           ,:AC-AMT-AR-DAY-90 :WS-AMT-AR-DAY-90-NULL                     
MFA-TR*        FROM CSS_AR_CNTL AC                                              
MFA-TR*        WHERE AC.ACCOUNT_NO = :KD-ACCOUNT-NO                             
MFA-TR*          AND AC.ITEM_ID = 00                                            
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                    33080000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA142 ABORT ************'         
               DISPLAY '* 7160-COMPUTE-FB-AMOUNT            *'          
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* ACCOUNT NO ' , KD-ACCOUNT-NO                  
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA142 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C27949 7170-COMPUTE-NONUTL-ARREARS.                                     
C27949                                                                  
C27949     EXEC SQL                                                     
C27949         SELECT                                                   
C27949             SUM(AC.AMT_AR_DAY_30)                                
C27949           + SUM(AC.AMT_AR_DAY_60)                                
C27949           + SUM(AC.AMT_AR_DAY_90)                                
C27949         INTO                                                     
C27949             :WS-TOTAL-ARREARS-NONUTL :WS-NULL-IND1                
C27949         FROM CSS_AR_CNTL AC WITH(READUNCOMMITTED)                        
C27949        WHERE AC.ACCOUNT_NO = :AT-ACCOUNT-NO                      
C27949****WARRANTY CHANGES REMOVED WILL BE ADDED LATER - SS- 09/12/03           
C27949****ADDED WARRANTY CHANGES ON 09/17/03 - SS82048                          
C27949****CHANGE DONE DURING WARRANTY PERIOD ACTIVITY 14 TO EXCLUDE             
C27949****LPN AND NSC FROM PSNC NON-UTIL AMOUNT                                 
C27949          AND AC.PYMT_PRIORITY_LVL IN (29,100,129)                
C27949*         AND AC.PYMT_PRIORITY_LVL IN (19,29,39,100,129)                  
C27949          AND AC.ITEM_ID = 00                                     
                                                                 
C27949     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*            SUM(AC.AMT_AR_DAY_30)                                        
MFA-TR*          + SUM(AC.AMT_AR_DAY_60)                                        
MFA-TR*          + SUM(AC.AMT_AR_DAY_90)                                        
MFA-TR*        INTO                                                             
MFA-TR*            :WS-TOTAL-ARREARS-NONUTL:WS-NULL-IND1                        
MFA-TR*        FROM CSS_AR_CNTL AC                                              
MFA-TR*       WHERE AC.ACCOUNT_NO = :AT-ACCOUNT-NO                              
MFA-TR****WARRANTY CHANGES REMOVED WILL BE ADDED LATER - SS- 09/12/03           
MFA-TR****ADDED WARRANTY CHANGES ON 09/17/03 - SS82048                          
MFA-TR****CHANGE DONE DURING WARRANTY PERIOD ACTIVITY 14 TO EXCLUDE             
MFA-TR****LPN AND NSC FROM PSNC NON-UTIL AMOUNT                                 
MFA-TR*         AND AC.PYMT_PRIORITY_LVL IN (29,100,129)                        
MFA-TR*         AND AC.PYMT_PRIORITY_LVL IN (19,29,39,100,129)                  
MFA-TR*         AND AC.ITEM_ID = 00                                             
MFA-TR*          with ur                                                        
MFA-TR*    END-EXEC.                                                    33080000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C27949                                                                  
C27949     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C27949     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
C27949     OR  NOT-FOUND                                                
C27949         IF  WS-NULL-IND1 < 0                                     
C27949             MOVE ZEROS     TO WS-TOTAL-ARREARS-NONUTL            
C27949                               WS-NULL-IND1                       
C27949         END-IF                                                   
C27949     ELSE                                                         
C27949         DISPLAY '********** PCSCA142 ABORT ************'         
C27949         DISPLAY '* 7170-COMPUTE-NONUTL-ARREARS       *'          
C27949         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
C27949         DISPLAY '* ACCOUNT NO ' , AC-ACCOUNT-NO                  
C27949         DISPLAY '* PROGRAM ABORTING...                *'         
C27949         DISPLAY '********** PCSCA142 ABORT ************'         
C27949         PERFORM 9900-ABEND              THRU 9900-EXIT           
C27949     END-IF.                                                      
C27949*                                                                         
C27949 7170-EXIT.                                                       
C27949     EXIT.                                                        
      ******************************************************************        
      **  OPENS PHONE-NO CURSOR                                        *        
      ******************************************************************        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7095-SELECT-HOLIDAY                                       **          
      **      CHECKS CSS_HOLIDAY TABLE TO SEE IF DATE IS A HOLIDAY. **          
      **                                                            **          
      ****************************************************************          
       7095-SELECT-HOLIDAY.                                             
      *                                                                         
           EXEC SQL                                                     
C30169          SELECT TOP(1) 'Y'                                              
                  INTO :WS-ROW-EXISTS                                   
                FROM CSS_HOLIDAY WITH(READUNCOMMITTED)                          
                WHERE HOLIDAY_DT = IIF(TRY_CONVERT(DATE, :J8-HOLIDAY-DT
              ) IS NULL OR (PATINDEX('%.%', :J8-HOLIDAY-DT
              ) <> 0) OR (LEN(:J8-HOLIDAY-DT) <> 10), CIS.CHAR2DATE(
                                                         :J8-HOLIDAY-DT
              ), CONVERT(DATE, :J8-HOLIDAY-DT) )                       
C30169                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-ROW-EXISTS                                           
MFA-TR*         FROM CSS_HOLIDAY                                                
MFA-TR*         WHERE HOLIDAY_DT = :J8-HOLIDAY-DT                               
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '************** PCSCA142 ******************'     
               DISPLAY '** 7095 :  RETURN CODE ERROR - SELECT'          
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '************** PCSCA142 ******************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7095-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7097-GET-NEXT-DAY                                         **          
      **      SELECTS THE DATE PLUS ONE DAY IN ORDER TO GET THE     **          
      **      NEXT VALID BUSINESS DAY.                              **          
      ****************************************************************          
       7097-GET-NEXT-DAY.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT DISTINCT(DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                          :WS-HOLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE
              ) <> 0) OR (LEN(:WS-HOLD-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-HOLD-DATE
              ), CONVERT(DATE, :WS-HOLD-DATE) ) )),            
              CIS.DAYS (DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                          :WS-HOLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE
              ) <> 0) OR (LEN(:WS-HOLD-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-HOLD-DATE
              ), CONVERT(DATE, :WS-HOLD-DATE) ) ))                       
              - (CIS.DAYS(DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                          :WS-HOLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE
              ) <> 0) OR (LEN(:WS-HOLD-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-HOLD-DATE
              ), CONVERT(DATE, :WS-HOLD-DATE) ) ))/7 * 7)     
                  INTO :WS-HOLD-DATE,                                   
                       :WS-DAY                                          
               FROM CSS_HOLIDAY                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DISTINCT(DATE(:WS-HOLD-DATE) + 1 DAYS),                    
MFA-TR*       DAYS (DATE(:WS-HOLD-DATE) + 1 DAYS)                               
MFA-TR*       - (INTEGER(DAYS(DATE(:WS-HOLD-DATE) + 1 DAYS)/7) * 7)             
MFA-TR*           INTO :WS-HOLD-DATE,                                           
MFA-TR*                :WS-DAY                                                  
MFA-TR*        FROM CSS_HOLIDAY                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '************* PCSCA142 *******************'     
               DISPLAY '** 7097 :  RETURN CODE ERROR'                   
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '************* PCSCA142 *******************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7097-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7200-CHECK-FOR-COLLECTION.                                       
                                                                        
           EXEC SQL                                                     
               SELECT HC.FUTURE_WORK_DT                                 
                INTO  :HC-FUTURE-WORK-DT                                
                FROM  CSS_COLLECT_HIST HC WITH(READUNCOMMITTED)                 
               WHERE  HC.ACCOUNT_NO = :HC-ACCOUNT-NO                    
                 AND  HC.FUTURE_WORK_DT IS NOT NULL                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     32960000
MFA-TR*        SELECT HC.FUTURE_WORK_DT                                 32970000
MFA-TR*         INTO  :HC-FUTURE-WORK-DT                                32980000
MFA-TR*         FROM  CSS_COLLECT_HIST HC                                       
MFA-TR*        WHERE  HC.ACCOUNT_NO = :HC-ACCOUNT-NO                            
MFA-TR*          AND  HC.FUTURE_WORK_DT IS NOT NULL                             
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                    33080000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE 'Y' TO WS-COLLECT-ACTIVE-FLAG                        
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 CONTINUE                                               
              ELSE                                                      
                 DISPLAY '********** PCSCA142 ABORT ************'       
                 DISPLAY '* 7200-CHECK-FOR-COLLECTION          *'       
                 DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
                 DISPLAY '* ACCOUNT NO ', HC-ACCOUNT-NO                 
                 DISPLAY '* PROGRAM ABORTING...                *'       
                 DISPLAY '********** PCSCA142 ABORT ************'       
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7210-GET-COLL-ACCT.                                              
                                                                        
           EXEC SQL                                                     
               SELECT CA.COLL_EXEMPTION_CD                              
                INTO  :IF-COLL-EXEMPTION-CD                             
                FROM  CSS_COLL_ACCT_INFO CA WITH(READUNCOMMITTED)               
               WHERE  CA.ACCOUNT_NO = :HC-ACCOUNT-NO                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     32960000
MFA-TR*        SELECT CA.COLL_EXEMPTION_CD                              32970000
MFA-TR*         INTO  :IF-COLL-EXEMPTION-CD                             32980000
MFA-TR*         FROM  CSS_COLL_ACCT_INFO CA                                     
MFA-TR*        WHERE  CA.ACCOUNT_NO = :HC-ACCOUNT-NO                            
MFA-TR*          with ur                                                        
MFA-TR*    END-EXEC.                                                    33080000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE IF-COLL-EXEMPTION-CD TO WS-COLL-EXEMPT-CD            
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 CONTINUE                                               
              ELSE                                                      
                 DISPLAY '********** PCSCA142 ABORT ************'       
                 DISPLAY '* 7210-GET-COLL-ACCT                 *'       
                 DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
                 DISPLAY '* ACCOUNT NO ', HC-ACCOUNT-NO                 
                 DISPLAY '* PROGRAM ABORTING...                *'       
                 DISPLAY '********** PCSCA142 ABORT ************'       
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7220-GET-COLL-AGENCY.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CODE_COLLEC_AGNCY                                  
              INTO :IZ-CODE-COLLEC-AGNCY                                
              FROM CSS_FIN_WO_COLLECT WITH(READUNCOMMITTED)                     
              WHERE ACCOUNT_NO        = :KD-ACCOUNT-NO                  
              AND   FW_ACTION_TYPE_CD = :IZ-FW-ACTION-TYPE-CD           
              ORDER BY FW_COLL_SEQ_NO DESC                              
                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     32960000
MFA-TR*       SELECT CODE_COLLEC_AGNCY                                          
MFA-TR*       INTO :IZ-CODE-COLLEC-AGNCY                                32980000
MFA-TR*       FROM CSS_FIN_WO_COLLECT                                           
MFA-TR*       WHERE ACCOUNT_NO        = :KD-ACCOUNT-NO                          
MFA-TR*       AND   FW_ACTION_TYPE_CD = :IZ-FW-ACTION-TYPE-CD                   
MFA-TR*       ORDER BY FW_COLL_SEQ_NO DESC                                      
MFA-TR*       FETCH FIRST 1 ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                    33080000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA142 ABORT ************'          
              DISPLAY '* 7220-GET-COLL-AGENCY               *'          
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* ACCOUNT NO ', HC-ACCOUNT-NO                    
              DISPLAY '* PROGRAM ABORTING...                *'          
              DISPLAY '********** PCSCA142 ABORT ************'          
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  GETS CUSTOMER NO, TOTAL AR BALANCE AND OTHER DETAILS FROM    *        
      **  CSS_ACCOUNT                                                  *        
      ******************************************************************        
      *                                                                         
       7300-GET-ACCT-DETAILS.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT AT.CODE_ACCT_STAT                                 
                     ,AT.CODES_DATA_PRESENT                             
                     ,AT.BILL_CYCLE                                     
                     ,AT.CUSTOMER_NO                                    
                     ,AT.DATE_BILL_DAY_00                               
                     ,AT.CREDIT_GROUP                                   
                     ,AT.BANKRUPTCY_IND                                 
                     ,AT.JUDGEMENT_CASE_NO                              
                     ,AT.CODE_DISC_OK                                   
                     ,AT.NOTICE_EXEMPT_CD                               
C30169               ,AT.ACCOUNT_TYPE_CODE                              
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           AT.ACCT_FINALED_DT, 121), ' ', '-'), ':', '.') 
           ACCT_FINALED_DT                                
                INTO  :AT-CODE-ACCT-STAT                                
                     ,:AT-CODES-DATA-PRESENT                            
                     ,:AT-BILL-CYCLE                                    
                     ,:AT-CUSTOMER-NO                                   
                     ,:AT-DATE-BILL-DAY-00                              
                     ,:AT-CREDIT-GROUP                                  
                     ,:AT-BANKRUPTCY-IND                                
                     ,:AT-JUDGEMENT-CASE-NO                             
                     ,:AT-CODE-DISC-OK                                  
                     ,:AT-NOTICE-EXEMPT-CD                              
C30169               ,:AT-ACCOUNT-TYPE-CODE                             
                     ,:AT-ACCT-FINALED-DT :WS-ACCT-FINAL-DT-NULL        
                FROM  CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
               WHERE  AT.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     32960000
MFA-TR*        SELECT AT.CODE_ACCT_STAT                                 32970000
MFA-TR*              ,AT.CODES_DATA_PRESENT                                     
MFA-TR*              ,AT.BILL_CYCLE                                     32970000
MFA-TR*              ,AT.CUSTOMER_NO                                            
MFA-TR*              ,AT.DATE_BILL_DAY_00                                       
MFA-TR*              ,AT.CREDIT_GROUP                                           
MFA-TR*              ,AT.BANKRUPTCY_IND                                         
MFA-TR*              ,AT.JUDGEMENT_CASE_NO                                      
MFA-TR*              ,AT.CODE_DISC_OK                                           
MFA-TR*              ,AT.NOTICE_EXEMPT_CD                                       
MFA-TR*              ,AT.ACCOUNT_TYPE_CODE                                      
MFA-TR*              ,AT.ACCT_FINALED_DT                                        
MFA-TR*         INTO  :AT-CODE-ACCT-STAT                                32980000
MFA-TR*              ,:AT-CODES-DATA-PRESENT                                    
MFA-TR*              ,:AT-BILL-CYCLE                                    32980000
MFA-TR*              ,:AT-CUSTOMER-NO                                   32980000
MFA-TR*              ,:AT-DATE-BILL-DAY-00                              33010000
MFA-TR*              ,:AT-CREDIT-GROUP                                          
MFA-TR*              ,:AT-BANKRUPTCY-IND                                        
MFA-TR*              ,:AT-JUDGEMENT-CASE-NO                                     
MFA-TR*              ,:AT-CODE-DISC-OK                                          
MFA-TR*              ,:AT-NOTICE-EXEMPT-CD                                      
MFA-TR*              ,:AT-ACCOUNT-TYPE-CODE                                     
MFA-TR*              ,:AT-ACCT-FINALED-DT :WS-ACCT-FINAL-DT-NULL                
MFA-TR*         FROM  CSS_ACCOUNT AT                                            
MFA-TR*        WHERE  AT.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                    33080000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T29290        IF WS-ACCT-FINAL-DT-NULL = -1                             
T29290           MOVE WS-PROCESS-DATE          TO AT-ACCT-FINALED-DT    
T29290        END-IF                                                    
T29290*       CONTINUE                                                          
           ELSE                                                         
               DISPLAY '********** PCSCA142 ABORT ************'         
               DISPLAY '* 7300-GET-ACCT-DET                  *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA142 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7310-CHECK-ACCT-INFO.                                            
      *                                                                         
           MOVE 'N' TO WS-ACCT-INFO-FOUND-FLAG.                         
                                                                        
           EXEC SQL                                                     
C30169          SELECT 'Y'                                              
                  INTO :WS-ACCT-INFO-FOUND-FLAG                         
                FROM CSS_COLL_ACCT_INFO WITH(READUNCOMMITTED)                   
                WHERE ACCOUNT_NO = :HC-ACCOUNT-NO                       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-ACCT-INFO-FOUND-FLAG                                 
MFA-TR*         FROM CSS_COLL_ACCT_INFO                                         
MFA-TR*         WHERE ACCOUNT_NO = :HC-ACCOUNT-NO                               
MFA-TR*          with ur                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '************** PCSCA142 ******************'     
               DISPLAY '** 7310 :  RETURN CODE ERROR - SELECT'          
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '************** PCSCA142 ******************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7310-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      **  GETS CUSTOMER NAME FROM CSS_NAME                             *        
      ******************************************************************        
      *                                                                         
       7350-CHECK-FOR-HVAC.                                             
                                                                        
           MOVE 'N' TO WS-HVAC-FLAG,                                    
                       WS-HVAC-ARREARS-FLAG.                            
                                                                        
           EXEC SQL                                                     
               SELECT CT.CNT_ITEM_ID                                    
                     ,CT.PYMT_PRIORITY_LVL                              
                     ,CT.CNT_STATUS_CD                                  
                INTO  :CT-CNT-ITEM-ID                                   
                     ,:CT-PYMT-PRIORITY-LVL                             
                     ,:CT-CNT-STATUS-CD                                 
                FROM  CSS_CONTRACT CT WITH(READUNCOMMITTED)                     
C27949               ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
               WHERE  CT.ACCOUNT_NO = :AT-ACCOUNT-NO                    
C27949           AND  CT.ACCOUNT_NO = AT.ACCOUNT_NO                     
C27949           AND  ((CT.CNT_NAME_CD IN (201,202,301,302,311)         
C27949                  AND AT.COMPANY_NO = '01')                       
C27949                OR (CT.CNT_NAME_CD IN (1080, 1022, 1023)          
C27949                    AND AT.COMPANY_NO = '26'))                    
                 AND  (CT.CNT_STATUS_CD = 'B' OR                        
                      CT.CNT_STATUS_CD =  'E')                          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     32960000
MFA-TR*        SELECT CT.CNT_ITEM_ID                                    32970000
MFA-TR*              ,CT.PYMT_PRIORITY_LVL                                      
MFA-TR*              ,CT.CNT_STATUS_CD                                          
MFA-TR*         INTO  :CT-CNT-ITEM-ID                                   32980000
MFA-TR*              ,:CT-PYMT-PRIORITY-LVL                                     
MFA-TR*              ,:CT-CNT-STATUS-CD                                         
MFA-TR*         FROM  CSS_CONTRACT CT                                           
MFA-TR*              ,CSS_ACCOUNT AT                                            
MFA-TR*        WHERE  CT.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*          AND  CT.ACCOUNT_NO = AT.ACCOUNT_NO                             
MFA-TR*          AND  ((CT.CNT_NAME_CD IN (201,202,301,302,311)                 
MFA-TR*                 AND AT.COMPANY_NO = '01')                               
MFA-TR*               OR (CT.CNT_NAME_CD IN (1080, 1022, 1023)                  
MFA-TR*                   AND AT.COMPANY_NO = '26'))                            
MFA-TR*          AND  (CT.CNT_STATUS_CD = 'B' OR                                
MFA-TR*               CT.CNT_STATUS_CD =  'E')                                  
MFA-TR*          with ur                                                        
MFA-TR*    END-EXEC.                                                    33080000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -811       
              IF CT-CNT-STATUS-CD = WS-ACTIVE OR                        
                (CT-CNT-STATUS-CD = WS-CLOSED AND                       
                 (AT-CODE-ACCT-STAT = 'B' OR 'S'))                      
                    MOVE 'Y' TO WS-HVAC-FLAG                            
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                  CONTINUE                                              
              ELSE                                                      
                  DISPLAY '********** PCSCA142 ABORT ************'      
                  DISPLAY '* 7350-CHECK-FOR-HVAC                *'      
                  DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE        
                  DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                
                  DISPLAY '* PROGRAM ABORTING...                *'      
                  DISPLAY '********** PCSCA142 ABORT ************'      
                  PERFORM 9900-ABEND              THRU 9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7375-CHECK-HVAC-ARREARS.                                         
                                                                        
           EXEC SQL                                                     
               SELECT AC.AMT_AR_DAY_30                                  
                     ,AC.AMT_AR_DAY_60                                  
                     ,AC.AMT_AR_DAY_90                                  
                INTO  :AC-AMT-AR-DAY-30                                 
                     ,:AC-AMT-AR-DAY-60                                 
                     ,:AC-AMT-AR-DAY-90                                 
                FROM  CSS_AR_CNTL AC WITH(READUNCOMMITTED)                      
               WHERE  AC.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                 AND  AC.PYMT_PRIORITY_LVL = :CT-PYMT-PRIORITY-LVL      
                 AND  AC.ITEM_ID = :CT-CNT-ITEM-ID                      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     32960000
MFA-TR*        SELECT AC.AMT_AR_DAY_30                                  32970000
MFA-TR*              ,AC.AMT_AR_DAY_60                                          
MFA-TR*              ,AC.AMT_AR_DAY_90                                          
MFA-TR*         INTO  :AC-AMT-AR-DAY-30                                 32980000
MFA-TR*              ,:AC-AMT-AR-DAY-60                                         
MFA-TR*              ,:AC-AMT-AR-DAY-90                                         
MFA-TR*         FROM  CSS_AR_CNTL AC                                            
MFA-TR*        WHERE  AC.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*          AND  AC.PYMT_PRIORITY_LVL = :CT-PYMT-PRIORITY-LVL              
MFA-TR*          AND  AC.ITEM_ID = :CT-CNT-ITEM-ID                              
MFA-TR*          with ur                                                        
MFA-TR*    END-EXEC.                                                    33080000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF AC-AMT-AR-DAY-30 > 0 OR                                
                 AC-AMT-AR-DAY-60 > 0 OR                                
                 AC-AMT-AR-DAY-90 > 0                                   
                   MOVE 'Y' TO WS-HVAC-ARREARS-FLAG                     
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                  CONTINUE                                              
              ELSE                                                      
                  DISPLAY '********** PCSCA142 ABORT ************'      
                  DISPLAY '* 7375-CHECK-HVAC-ARREARS            *'      
                  DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE        
                  DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                
                  DISPLAY '* PROGRAM ABORTING...                *'      
                  DISPLAY '********** PCSCA142 ABORT ************'      
                  PERFORM 9900-ABEND              THRU 9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7375-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7380-CHECK-FOR-HVAC-WO.                                          
                                                                        
           EXEC SQL                                                     
              SELECT                                                    
                 SUM(AMT_TRANS)                                         
              INTO                                                      
                 :WS-CONTRACT-WO-BALANCE :WS-WO-BALANCE-NULL            
              FROM                                                      
                 CSS_CHRG_OFF WITH(READUNCOMMITTED)                             
              WHERE                                                     
C30169           ACCOUNT_NO = :KD-ACCOUNT-NO AND                        
                 PYMT_PRIORITY_LVL = :WS-CONTRACT                       
                                                                 
          END-EXEC.                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*          SUM(AMT_TRANS)                                                 
MFA-TR*       INTO                                                              
MFA-TR*          :WS-CONTRACT-WO-BALANCE :WS-WO-BALANCE-NULL                    
MFA-TR*       FROM                                                              
MFA-TR*          CSS_CHRG_OFF                                                   
MFA-TR*       WHERE                                                             
MFA-TR*          ACCOUNT_NO = :KD-ACCOUNT-NO AND                                
MFA-TR*          PYMT_PRIORITY_LVL = :WS-CONTRACT                               
MFA-TR*          with ur                                                        
MFA-TR*   END-EXEC.                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-CONTRACT-WO-BALANCE > 0                             
                   MOVE 'Y' TO WS-HVAC-ARREARS-FLAG                     
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                  CONTINUE                                              
              ELSE                                                      
                  DISPLAY '********** PCSCA142 ABORT ************'      
                  DISPLAY '* 7380-CHECK-FOR-HVAC-WO             *'      
                  DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE        
                  DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                
                  DISPLAY '* PROGRAM ABORTING...                *'      
                  DISPLAY '********** PCSCA142 ABORT ************'      
                  PERFORM 9900-ABEND              THRU 9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7380-EXIT.                                                       
           EXIT.                                                        
C30169******************************************************************        
C30169**  GETS RATE PLAN NO FROM CSS_UTIL_ENVRNMNT                     *        
C30169******************************************************************        
C30169*                                                                         
C30169 7450-GET-RATE-PLAN-NO.                                           
C30169*                                                                         
C30169     EXEC SQL                                                     
C30169         SELECT TOP(1) RATE_PLAN_NO                                      
C30169          INTO  :UT-RATE-PLAN-NO                                  
C30169          FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                     
C30169         WHERE ACCOUNT_NO = :UT-ACCOUNT-NO                        
C30169         ORDER BY CODE_REVENUE_CLASS                              
C30169                                     
C30169     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     32960000
MFA-TR*        SELECT RATE_PLAN_NO                                      32970000
MFA-TR*         INTO  :UT-RATE-PLAN-NO                                  32980000
MFA-TR*         FROM CSS_UTIL_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO = :UT-ACCOUNT-NO                                
MFA-TR*        ORDER BY CODE_REVENUE_CLASS                                      
MFA-TR*        FETCH FIRST 1 ROW ONLY WITH UR                                   
MFA-TR*    END-EXEC.                                                    33080000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169                                                                  
C30169     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
C30169     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
C30169        CONTINUE                                                  
C30169     ELSE                                                         
C30169         DISPLAY '********** PCSCA142 ABORT ************'         
C30169         DISPLAY '* 7450-GET-RATE-PLAN-NO              *'         
C30169         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
C30169         DISPLAY '* ACCOUNT NO ', UT-ACCOUNT-NO                   
C30169         DISPLAY '* PROGRAM ABORTING...                *'         
C30169         DISPLAY '********** PCSCA142 ABORT ************'         
C30169         PERFORM 9900-ABEND              THRU 9900-EXIT           
C30169     END-IF.                                                      
C30169*                                                                         
C30169 7450-EXIT.                                                       
C30169     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  GETS CURRENT DATE FROM CSS_MODEL_SQL                         *        
      ******************************************************************        
      *                                                                         
       7500-GET-CURRENT-DATE.                                           
      *                                                                         
           EXEC SQL                                                     
T33928         SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     32960000
MFA-TR*        SET :WS-CURRENT-DATE = CURRENT DATE                              
MFA-TR*    END-EXEC.                                                    33080000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSCA142 ABORT ************'         
               DISPLAY '* 7500-GET-CURRENT-DATE              *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA142 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C30169*                                                                         
C30169 7510-SELECT-FINAL-WO.                                            
C30169     INITIALIZE FW-COLLECT-STATUS-CD.                             
           EXEC SQL                                                     
                SELECT COLLECT_STATUS_CD                                
                  INTO :FW-COLLECT-STATUS-CD                            
                FROM CSS_FINAL_WO WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :KD-ACCOUNT-NO                       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT COLLECT_STATUS_CD                                        
MFA-TR*           INTO :FW-COLLECT-STATUS-CD                                    
MFA-TR*         FROM CSS_FINAL_WO                                               
MFA-TR*         WHERE ACCOUNT_NO = :KD-ACCOUNT-NO                               
MFA-TR*          with ur                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '************** PCSCA142 ******************'     
               DISPLAY '** 7510 :  RETURN CODE ERROR - SELECT'          
               DISPLAY '** ACCOUNT NO ** ' KD-ACCOUNT-NO                
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '************** PCSCA142 ******************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
C30169 7510-EXIT.                                                       
C30169     EXIT.                                                        
      *                                                                         
       7550-GET-TIMESTAMP.                                              
      *                                                                         
           MOVE '7550'          TO ACTIVE-PARAGRAPH.                    
      *                                                                         
           EXEC SQL                                                     
T33928       SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-NEW-TIMESTAMP                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-NEW-TIMESTAMP = CURRENT TIMESTAMP                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSCA142 ABORT ************'         
               DISPLAY '* 7550-GET-TIMESTAMP                 *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA142 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7700-INSERT-COLL-HIST.                                           
                                                                        
           IF CL-DATE-CREDIT-ACTION = LOW-VALUES                        
              MOVE -1 TO WS-DATE-CRED-ACT-NULL                          
           END-IF.                                                      
                                                                        
           IF HC-WRITE-OFF-DT = LOW-VALUES OR SPACES                    
              MOVE -1 TO WS-WRITE-OFF-DT-NULL                           
           ELSE                                                         
              MOVE +0 TO WS-WRITE-OFF-DT-NULL                           
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_COLLECT_HIST                             
                    (ACCOUNT_NO,                                        
                     COLL_HIST_SEQ_TS,                                  
                     AMT_AR_DAY_00,                                     
                     AMT_AR_DAY_30,                                     
                     AMT_AR_DAY_60,                                     
                     AMT_AR_DAY_90,                                     
                     BILL_CYCLE,                                        
                     CALL_QUEUE_ID,                                     
                     CODE_ACCT_STATUS,                                  
                     DATE_FORECAST_DNP,                                 
                     FUTURE_WORK_DT,                                    
                     WRITE_OFF_DT,                                      
                     LAST_BILL_DT)                                      
               VALUES                                                   
                    (:HC-ACCOUNT-NO,                                    
                     CIS.CHAR2TIMESTAMP(:HC-COLL-HIST-SEQ-TS),                  
                     :HC-AMT-AR-DAY-00,                                 
                     :HC-AMT-AR-DAY-30,                                 
                     :HC-AMT-AR-DAY-60,                                 
                     :HC-AMT-AR-DAY-90,                                 
                     :HC-BILL-CYCLE,                                    
                     :HC-CALL-QUEUE-ID,                                 
                     :HC-CODE-ACCT-STATUS,                              
                     IIF(TRY_CONVERT(DATE, :CL-DATE-CREDIT-ACTION 
                                           :WS-DATE-CRED-ACT-NULL
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-CREDIT-ACTION 
                                                 :WS-DATE-CRED-ACT-NULL
              ) <> 0) OR (LEN(:CL-DATE-CREDIT-ACTION 
                                                 :WS-DATE-CRED-ACT-NULL
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-CREDIT-ACTION 
                                                 :WS-DATE-CRED-ACT-NULL
              ), CONVERT(DATE, :CL-DATE-CREDIT-ACTION 
                                                 :WS-DATE-CRED-ACT-NULL
              ) ),     
                     IIF(TRY_CONVERT(DATE, :HC-FUTURE-WORK-DT
              ) IS NULL OR (PATINDEX('%.%', :HC-FUTURE-WORK-DT
              ) <> 0) OR (LEN(:HC-FUTURE-WORK-DT
              ) <> 10), CIS.CHAR2DATE(:HC-FUTURE-WORK-DT
              ), CONVERT(DATE, :HC-FUTURE-WORK-DT) ),                          
                     IIF(TRY_CONVERT(DATE, :HC-WRITE-OFF-DT 
                                           :WS-WRITE-OFF-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :HC-WRITE-OFF-DT 
                                                  :WS-WRITE-OFF-DT-NULL
              ) <> 0) OR (LEN(:HC-WRITE-OFF-DT :WS-WRITE-OFF-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:HC-WRITE-OFF-DT 
                                                  :WS-WRITE-OFF-DT-NULL
              ), CONVERT(DATE, :HC-WRITE-OFF-DT :WS-WRITE-OFF-DT-NULL
              ) ),            
                     IIF(TRY_CONVERT(DATE, :HC-LAST-BILL-DT
              ) IS NULL OR (PATINDEX('%.%', :HC-LAST-BILL-DT
              ) <> 0) OR (LEN(:HC-LAST-BILL-DT) <> 10), CIS.CHAR2DATE(
                                                       :HC-LAST-BILL-DT
              ), CONVERT(DATE, :HC-LAST-BILL-DT) ))                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_COLLECT_HIST                                     
MFA-TR*             (ACCOUNT_NO,                                                
MFA-TR*              COLL_HIST_SEQ_TS,                                          
MFA-TR*              AMT_AR_DAY_00,                                             
MFA-TR*              AMT_AR_DAY_30,                                             
MFA-TR*              AMT_AR_DAY_60,                                             
MFA-TR*              AMT_AR_DAY_90,                                             
MFA-TR*              BILL_CYCLE,                                                
MFA-TR*              CALL_QUEUE_ID,                                             
MFA-TR*              CODE_ACCT_STATUS,                                          
MFA-TR*              DATE_FORECAST_DNP,                                         
MFA-TR*              FUTURE_WORK_DT,                                            
MFA-TR*              WRITE_OFF_DT,                                              
MFA-TR*              LAST_BILL_DT)                                              
MFA-TR*        VALUES                                                           
MFA-TR*             (:HC-ACCOUNT-NO,                                            
MFA-TR*              :HC-COLL-HIST-SEQ-TS,                                      
MFA-TR*              :HC-AMT-AR-DAY-00,                                         
MFA-TR*              :HC-AMT-AR-DAY-30,                                         
MFA-TR*              :HC-AMT-AR-DAY-60,                                         
MFA-TR*              :HC-AMT-AR-DAY-90,                                         
MFA-TR*              :HC-BILL-CYCLE,                                            
MFA-TR*              :HC-CALL-QUEUE-ID,                                         
MFA-TR*              :HC-CODE-ACCT-STATUS,                                      
MFA-TR*              :CL-DATE-CREDIT-ACTION :WS-DATE-CRED-ACT-NULL,             
MFA-TR*              :HC-FUTURE-WORK-DT,                                        
MFA-TR*              :HC-WRITE-OFF-DT :WS-WRITE-OFF-DT-NULL,                    
MFA-TR*              :HC-LAST-BILL-DT)                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  PROCESSING ERROR IN PGM PCSCA142  **'       
               DISPLAY '** PARA -  7700-INSERT-COLL-HIST      **'       
               DISPLAY '**      ERROR DURING INSERT FOR       **'       
               DISPLAY '**             CSS_COLLECT_HIST       **'       
               DISPLAY '**  ACCOUNT NO = ', AT-ACCOUNT-NO               
               DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7750-INSERT-COLL-ACCT-INFO.                                      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_COLL_ACCT_INFO                           
                    (ACCOUNT_NO,                                        
                     CUSTOMER_NO,                                       
                     COLL_EXEMPTION_CD,                                 
                     RECORD_CREATION_DT)                                
               VALUES                                                   
                    (:IF-ACCOUNT-NO,                                    
                     :IF-CUSTOMER-NO,                                   
                     :IF-COLL-EXEMPTION-CD,                             
                     IIF(TRY_CONVERT(DATE, :IF-RECORD-CREATION-DT
              ) IS NULL OR (PATINDEX('%.%', :IF-RECORD-CREATION-DT
              ) <> 0) OR (LEN(:IF-RECORD-CREATION-DT
              ) <> 10), CIS.CHAR2DATE(:IF-RECORD-CREATION-DT
              ), CONVERT(DATE, :IF-RECORD-CREATION-DT) ))                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_COLL_ACCT_INFO                                   
MFA-TR*             (ACCOUNT_NO,                                                
MFA-TR*              CUSTOMER_NO,                                               
MFA-TR*              COLL_EXEMPTION_CD,                                         
MFA-TR*              RECORD_CREATION_DT)                                        
MFA-TR*        VALUES                                                           
MFA-TR*             (:IF-ACCOUNT-NO,                                            
MFA-TR*              :IF-CUSTOMER-NO,                                           
MFA-TR*              :IF-COLL-EXEMPTION-CD,                                     
MFA-TR*              :IF-RECORD-CREATION-DT)                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  PROCESSING ERROR IN PGM PCSCA142  **'       
               DISPLAY '** PARA -  7750-INSERT-COLL-ACCT-INFO **'       
               DISPLAY '**      ERROR DURING INSERT FOR       **'       
               DISPLAY '**             CSS_COLL_ACCT_INFO     **'       
               DISPLAY '**  ACCOUNT NO = ', AT-ACCOUNT-NO               
               DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
       7750-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
       7800-SELECT-REG-PROFILE.                                         
      *                                                                         
           EXEC SQL                                                     
                SELECT 'Y'                                              
                      ,REG_GROUP_CD                                     
                      ,SENIOR_FL                                        
                  INTO :WS-SEB-REGULATED-FLAG                           
                      ,:LR-REG-GROUP-CD                                 
                      ,:LR-SENIOR-FL                                    
                FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                      
                WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*               ,REG_GROUP_CD                                             
MFA-TR*               ,SENIOR_FL                                                
MFA-TR*           INTO :WS-SEB-REGULATED-FLAG                                   
MFA-TR*               ,:LR-REG-GROUP-CD                                         
MFA-TR*               ,:LR-SENIOR-FL                                            
MFA-TR*         FROM CSS_REG_PROFILE                                            
MFA-TR*         WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                               
MFA-TR*          with ur                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '************** PCSCA142 ******************'     
               DISPLAY '** 7800 :  RETURN CODE ERROR - SELECT'          
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '************** PCSCA142 ******************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7810-SELECT-GROUP1-CNT.                                          
      *                                                                         
           EXEC SQL                                                     
                SELECT 'Y'                                              
                     ,AC.AMT_AR_DAY_00                                  
                     ,(AC.AMT_AR_DAY_30                                 
                     +AC.AMT_AR_DAY_60                                  
                     +AC.AMT_AR_DAY_90)                                 
                     ,AC.AMT_TRAN_BALANCE                               
                 INTO :WS-GROUP1-CNT-FLAG                               
                     ,:WS-AMT-AR-DAY-00                                 
                     ,:WS-GROUP1-CNT-ARREARS                            
                     ,:WS-AMT-TRAN-BALANCE                              
                FROM CSS_CONTRACT CT WITH(READUNCOMMITTED)                      
                    ,CSS_AR_CNTL  AC WITH(READUNCOMMITTED)                      
                WHERE CT.ACCOUNT_NO  = :CT-ACCOUNT-NO                   
                  AND AC.ACCOUNT_NO  = CT.ACCOUNT_NO                    
                  AND CT.PYMT_PRIORITY_LVL = AC.PYMT_PRIORITY_LVL       
                  AND CT.CNT_NAME_CD = :CT-CNT-NAME-CD                  
                  AND CT.CNT_ITEM_ID = AC.ITEM_ID                       
                  AND CT.CNT_STATUS_CD <> 'E'                           
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*              ,AC.AMT_AR_DAY_00                                  32970000
MFA-TR*              ,(AC.AMT_AR_DAY_30                                         
MFA-TR*              +AC.AMT_AR_DAY_60                                          
MFA-TR*              +AC.AMT_AR_DAY_90)                                         
MFA-TR*              ,AC.AMT_TRAN_BALANCE                                       
MFA-TR*          INTO :WS-GROUP1-CNT-FLAG                                       
MFA-TR*              ,:WS-AMT-AR-DAY-00                                 32980000
MFA-TR*              ,:WS-GROUP1-CNT-ARREARS                                    
MFA-TR*              ,:WS-AMT-TRAN-BALANCE                                      
MFA-TR*         FROM CSS_CONTRACT CT                                            
MFA-TR*             ,CSS_AR_CNTL  AC                                            
MFA-TR*         WHERE CT.ACCOUNT_NO  = :CT-ACCOUNT-NO                           
MFA-TR*           AND AC.ACCOUNT_NO  = CT.ACCOUNT_NO                            
MFA-TR*           AND CT.PYMT_PRIORITY_LVL = AC.PYMT_PRIORITY_LVL               
MFA-TR*           AND CT.CNT_NAME_CD = :CT-CNT-NAME-CD                          
MFA-TR*           AND CT.CNT_ITEM_ID = AC.ITEM_ID                               
MFA-TR*           AND CT.CNT_STATUS_CD <> 'E'                                   
MFA-TR*          with ur                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
           OR  -811                                                     
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '************** PCSCA142 ******************'     
               DISPLAY '** 7810 :  RETURN CODE ERROR - SELECT'          
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '************** PCSCA142 ******************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7810-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
P00453 7900-CHECK-PAYNGO-CUST.                                          
P00453*                                                                         
P00453     EXEC SQL                                                     
P00453          SELECT TOP(1) 'Y'                                              
P00453            INTO :WS-PAYNGO-CUST-FLAG                             
P00453          FROM CSS_PREPAY_HIST WITH(READUNCOMMITTED)                      
P00453          WHERE ACCOUNT_NO = :PK-ACCOUNT-NO                       
P00453                                           
P00453                                                           
P00453                                                      
P00453     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-PAYNGO-CUST-FLAG                                     
MFA-TR*         FROM CSS_PREPAY_HIST                                            
MFA-TR*         WHERE ACCOUNT_NO = :PK-ACCOUNT-NO                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7900                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00453*                                                                         
P00453     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00453*                                                                         
P00453     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
P00453         CONTINUE                                                 
P00453     ELSE                                                         
P00453         DISPLAY '************** PCSCA142 ******************'     
P00453         DISPLAY '** 7900 :  RETURN CODE ERROR - SELECT'          
P00453         DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
P00453         DISPLAY '************** PCSCA142 ******************'     
P00453         PERFORM 9900-ABEND                THRU 9900-EXIT         
P00453     END-IF.                                                      
P00453*                                                                         
P00453 7900-EXIT.                                                       
P00453     EXIT.                                                        
      *                                                                         
      ************************************************************              
      * CLOSES THE FILE  COLL-HIST.                                             
      ************************************************************              
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  COPY BOOK CONTAINING 9900-ABEND AND 9900-EXIT           ****           
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
