       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA141.                                        
       AUTHOR.         MELISSA JOHNSON.                                 
       DATE-WRITTEN.   MAR 2002.                                        
      ***************************************************************** 00050000
      ********   GENERATES FILE FOR GUARANTOR CONFIRMATION LETTER ***** 00060000
      ********                      DB2                           ***** 00070000
      ***************************************************************** 00080000
      *                                                             **  00090000
      *              PROGRAM  MODIFICATION  LOG                     **  00100000
      *    DATE    INITIALS     REASON                              **  00110000
      *    ----    --------     ------                              **  00120000
      ** 03/14/2002   MDJ     INITIAL PROGRAM VERSION               **  00130000
T25584** 03/14/2002   MDJ     ADDED COMMIT AND CHECKPOINT RESTART.  **  00140000
C25552*  05/29/2002   MDJ     DO NOT MOVE CUSTOMER NUMBER TO NUMERIC *  00150000
      *                       VARIABLE FIELD BECAUSE IT IS NOT LONG  *  00160000
      *                       ENOUGH TO HANDLE ALL CUSTOMER NUMBERS. *  00170000
      *                       MOVE ZEROES INSTEAD.  BILL PRINT PROGRAM  00180000
      *                       WILL FETCH CUSTOMER NUMBER BASED ON ACCT  00190000
      *                       NUMBER.                                *  00200000
T30823** 05/13/2004   CVNS    ADDED CODE TO RESET AND VALIDATE THE  **  00210000
      **              CHENNAI RESTART REQ PARM                      **  00220000
C26296** 11/08/2004   MDJ     NEW CURSOR ADDED TO DETERMINE THOSE   **  00230000
      **                      ACCTS THAT HAVE HAD THE CASH-ONLY IND **  00240000
      **                      SET ON PANEL 182 SINCE LAST RUN DATE. **  00250000
      **                      ADD TO CA141 FILE SO THAT THE CASH-ONLY*  00260000
      **                      LETTER (90207) CAN BE PROCESSED EACH  **  00270000
      **                      NIGHT.                                **  00280000
T33928** 07/12/2006   CVNS    ADDED FOR FETCH ONLY WITH UR TO THE   **  00290000
      **              CHENNAI CURSORS AND WITH UR TO THE SELECTS    **  00300000
C35584** 03/29/2007   MJ16632 UPDATE COMM-TYPE-CD AND COMM-SUB-CD   **  00310000
C35584**                      FOR LETTERS/NOTICES.                  **  00320000
C35584**                      INSERT TO CSS_COMM_DATA.              **  00330000
C35152** 02/13/2008   MELISSA JOHNSON/RICK BLACK                    **  00340000
C35152**                      REMOVE CPD00074 - NAME & ADDR         **  00350000
C35152**                      PROCESSING WILL BE STANDARDIZED ACROSS**  00360000
C35152**                      BILL PRINT.                           **  00370000
C26289** 08/06/2008  RICK BLACK  WITH 90810 LETTERS IF ACCOUNT TYPE   **00380000
C26289**           RB19957      EQUAL TO C OR I THEN GOTO DELINQUENCY **00390000
C26289**                        TABLE AND GET NUMBER OF MONTHS TO HOLD**00400000
C26289**                        DEPOSIT.  PASS VALUE IN FIORP000 FILE.**00410000
A00765** 01/15/2009   CVNS    ADDED 9000-SEND-ERROR-RESULT PARA.    **  00420000
A00765**              CHENNAI                                       **  00430000
A37741** 11/16/2009   VP94820 DECLARED S-RETURN-CODE RESPECTIVE     **  00440000
      **                      TO CPD00067 CHANGES.                  **  00450000
P00518** 06/14/2011   WR19680 CHANGE TO GET RETAIN-RES-DEPOSIT      **  00460000
P00518**                      DELIQUENCY VALUE INSTEAD OF DEFAULTING**  00470000
P00518**                      TO +12.                                   00480000
A03866** 01/20/2012   MC95456 MOVED MESSAGE ID TO PROMOTION-ID IN   **  00490000
A03866** A03866-ACT004        CSS_COMM_DATA.                        **  00500000
ACT034** 04/11/2012   NS75440 MOVED 6600-LOAD-CUST-COMM BEFORE      **  00510000
ACT034** A03967               8025-WRITE-FCSRP000(TO AVOID JUNK VALUE*  00520000
ACT034**                      FROM BEING INSERTED IN "CSS_COMM_DATA)**  00530000
P00599** 10/09/2012   AS7C117 MODIFIED THE PROGRAM TO CALL SCSKR125 **  00540000
P00599**                      SUB-PROGRAM INSTEAD OF WRITING TO THE **  00550000
P00599**                      RP000 FILE                            **  00560000
A04735** 08/08/2013   MC95456 REMOVED DCLGEN FOR CSS_CUST_COMM_MF   **          
ACT243** 08/21/2014   SS7F226 CHANGES TO REMOVE RESTART LOGIC AND   **          
ACT243**               A04880 FOR CASH ONLY LETTERS CURSOR AFTER    **          
ACT243**                      COMMIT UPDATED THE TIMESTAMP IN JOBPRM**          
ACT243**                      & CHANGED THE COMMIT LEVEL AND DELETED**          
ACT243**                      THE LUW-LIMIT&UPD-LIMIT.              **          
ACT264** 09/26/2014   SS7F226 CHANGES TO DELETE JOB PARM TIMESTAMP  **          
ACT264**               A04880 UPDATE WHILE END OF THE PROGRAM.      **          
ACT265** 09/29/2014   SS7F226 CHANGES TO ADD UPDATE TIMESTAMP WITH  **          
ACT265**               A04880 CURRENT TIMESTAMP WHILE END OF THE PGM**          
A05058** 07/24/2015   RB19957 INCLUDED MONEY ORDER RETURNS IN THE   **          
A05058**          RICK BLACK  RETURNED ITEMS CURSOR FOR CASH ONLY   **          
A05058**         APPL00005058 LETTER.                               **          
      ****************************************************************  00570000
      *                                                                 00580000
      *REMARKS.                                                         00590000
      *         COMPONENT PCSCA141 PRODUCES EXTRACT FILE FCSFA000       00600000
      *         WHICH IS USED TO GENERATE THE GUARANTOR CONFIRMATION    00610000
      *         LETTER AND CASH-ONLY LETTERS IN CLFN.                   00620000
      ***************************************************************** 00630000
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                 00660000
       SOURCE-COMPUTER.    IBM-4381.                                    
       OBJECT-COMPUTER.    IBM-4381.                                    
      *                                                                 00690000
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
      *                                                                 00730000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                 00760000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA141'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                        PIC X(45)                    
           VALUE 'WORKING STORAGE FOR PCSCA141 STARTS HERE'.            
      *                                                                 00810000
       01  WS-DATES.                                                    
           05  WS-NOTICE-DATE.                                          
               10  WS-NOTICE-YY            PIC 9(02) VALUE ZEROES.      
               10  WS-NOTICE-MM            PIC 9(02) VALUE ZEROES.      
               10  WS-NOTICE-DD            PIC 9(02) VALUE ZEROES.      
           05  WS-JOB-PARM                 PIC X(10) VALUE SPACES.      
           05  WS-JOB-PARM-R REDEFINES WS-JOB-PARM.                     
               10  FILLER                  PIC X(02).                   
               10  WS-JOB-PARM-YEAR        PIC X(02).                   
               10  FILLER                  PIC X(01).                   
               10  WS-JOB-PARM-MONTH       PIC X(02).                   
               10  FILLER                  PIC X(01).                   
               10  WS-JOB-PARM-DAY         PIC X(02).                   
           05  WS-HIST-DISP-DATE.                                       
               10  WS-HIST-DISP-MM         PIC X(02).                   
               10  FILLER                  PIC X(01) VALUE '/'.         
               10  WS-HIST-DISP-DD         PIC X(02).                   
               10  FILLER                  PIC X(01) VALUE '/'.         
               10  WS-HIST-DISP-YR         PIC X(04).                   
           05  WS-TRAN-DATE.                                            
               10  WS-TRAN-YEAR            PIC X(04).                   
               10  FILLER                  PIC X(01).                   
               10  WS-TRAN-MONTH           PIC X(02).                   
               10  FILLER                  PIC X(01).                   
               10  WS-TRAN-DAY             PIC X(02).                   
           05  WS-TRAN-TIME.                                            
               10  WS-TRAN-HOUR            PIC X(02).                   
               10  FILLER                  PIC X(01).                   
               10  WS-TRAN-MIN             PIC X(02).                   
               10  FILLER                  PIC X(01).                   
               10  WS-TRAN-SEC             PIC X(02).                   
                                                                        
       01  WS-PROG-MISC.                                                
           05  WS-SYSTEM                   PIC X(06) VALUE 'SYSTEM'.    
           05  PROGRAM-NAME                PIC X(08) VALUE 'PCSCA141'.  
           05  WS-PGRMNAME                 PIC X(08) VALUE 'PCSCA141'.  
           05  WS-TIMESTAMP                PIC X(26) VALUE SPACES.      
C35584     05  WS-COMM-TYPE-CD             PIC X(02) VALUE SPACES.      
C35584     05  WS-COMM-SUB-CD              PIC X(02) VALUE SPACES.      
C35584     05  WS-KO-CONTACT-NAME          PIC X(25) VALUE SPACES.      
C35584     05  WS-INITIAL-COMMENT-TX.                                   
C35584         10  WS-INITIAL-COMMENT-TX-LEN  PIC S9(4) USAGE COMP.     
C35584         10  WS-INITIAL-COMMENT-TX-TEXT PIC X(255) VALUE SPACES.  
C26296     05  WS-HOLD-TIMESTAMP           PIC X(26) VALUE SPACES.      
C26296     05  WS-LR-DATE-TIMESTAMP        PIC X(26)  VALUE SPACES.     
C26296     05  WS-LRD-PARM                 PIC X(14)  VALUE             
C26296             'LAST-RUN-DATE='.                                    
C26296     05  WS-JOB-PARM-DATA.                                        
C26296         10  WS-LRD                  PIC X(14)  VALUE SPACES.     
C26296         10  WS-LRD-TS.                                           
C26296             15  WS-LAST-RUN-DATE    PIC X(10).                   
C26296             15  WS-LAST-RUN-TSTMP   PIC X(16).                   
C26296         10  FILLER                  PIC X(40).                   
           05  WS-INDEX                    PIC 9(01) VALUE ZEROS.       
           05  WS-MAIL-CODE                PIC X(01) VALUE 'M'.         
           05  WS-END-OF-ROWS              PIC X(01) VALUE 'N'.         
               88  END-OF-ROWS             VALUE 'Y'.                   
           05  VALID-ROW-EXIST-FLAG        PIC X(01) VALUE 'N'.         
               88  VALID-ROW-EXIST         VALUE 'Y'.                   
           05  WS-DISPLAY-SQLCODE          PIC -ZZZZZZZZ9.              
           05  WS-DATABASE                 PIC 9(01) VALUE 0.           
               88  CSR-DATABASE                      VALUE 1.           
               88  SEB-DATABASE                      VALUE 2.           
           05  WS-DATA-FOUND               PIC X(1)  VALUE 'Y'.         
           05  WS-FFA00-REC-CNTR           PIC S9(07) COMP-3 VALUE ZERO.
           05  WS-FFA00-SEQ-NO             PIC S9(07) COMP-3 VALUE ZERO.
           05  WS-HOME-PHONE-NO            PIC X(10) VALUE SPACES.      
           05  WS-WORK-PHONE-NO            PIC X(10) VALUE SPACES.      
           05  WS-GUAR-EST-DT-NULL         PIC S9(04) COMP VALUE +0.    
C35584     05  WS-RED-FL-NULL-IND          PIC S9(04) COMP VALUE +0.    
C35584     05  WS-END-NULL-IND             PIC S9(04) COMP VALUE +0.    
C26289     05  WS-RETAIN-COMMER-DEP      PIC S9(04) COMP VALUE ZEROES.  
C26289     05  WS-RETAIN-INDUST-DEP      PIC S9(04) COMP VALUE ZEROES.  
P00518     05  WS-RETAIN-RESIDENT-DEP    PIC S9(04) COMP VALUE ZEROES.  
C26289     05  WS-CURRENT-COMPANY          PIC X(02) VALUE SPACES.      
P00599     05  WS-CURRENT-DATE             PIC X(10) VALUE SPACES.      
P00599     05  SCSKR125                    PIC X(08) VALUE 'SCSKR125'.  
P00599     05  WS-PREV-ACCOUNT-NO          PIC S9(13)V COMP-3 VALUE 0.  
P00599     05  WS-SEQ-NO-COUNT             PIC S9(4) USAGE COMP VALUE 0.
P00599     05  RS-KR125-RETURN-CODE        PIC S9(04) COMP VALUE 0.     
C26289*                                                                 01590000
C26289 01  WS-DELINQUENCY-VALUES-TABLE.                                 
C26289     05  WS-DELINQ-COMPANY-ENTRY-TB                               
P00518         OCCURS 6 TIMES                                           
C26289         INDEXED BY TB-CO-INDEX.                                  
C26289         10  WS-DELINQ-VALUE-ENTRY-TB                             
P00518             OCCURS 3 TIMES                                       
C26289             INDEXED BY TB-VAL-INDEX.                             
C26289             15  WS-DELINQ-COMPANY-TB  PIC X(02).                 
C26289             15  WS-DELINQ-CODE-TB     PIC X(20).                 
C26289             15  WS-DELINQ-VALUE-TB    PIC S9(05).                
T25584                                                                  
ACT243 01 WS-MISC.                                                      
ACT243     05  WS-COMMIT-COUNTER         PIC 9(04)   VALUE ZERO.        
ACT265     05  WS-COMMIT-FLAG            PIC X(01)   VALUE 'N'.         
ACT243     05  WS-READY-TO-COMMIT-COUNT  PIC S9(09) COMP VALUE +0.      
T25584     05  WS-PROCESS-TYPE           PIC 9(01).                     
T25584     05  WS-SEQ-NO                 PIC 9(04)   VALUE ZERO.        
T25584     05  WS-CHKP-ID.                                              
T25584         10  WS-CHKP-PGM-ID        PIC X(02)   VALUE '09'.        
T25584         10  WS-CHKP-PART-NO       PIC 9(01)   VALUE 1.           
T25584         10  WS-CHKP-SEQ-NO        PIC 9(05)   VALUE ZERO.        
C26296     05  WS-HOLD-HIST-SEQ-NO       PIC X(26)   VALUE SPACES.      
T25584*                                                                 01940000
       01  WS-LITERALS.                                                 
           05  WS-CN                       PIC X(02) VALUE 'CN'.        
           05  WS-N                        PIC X(01) VALUE 'N'.         
C35584     05  WS-O                        PIC X(01) VALUE 'O'.         
C35584     05  WS-L                        PIC X(01) VALUE 'L'.         
           05  WS-Y                        PIC X(01) VALUE 'Y'.         
           05  WS-P                        PIC X(01) VALUE 'P'.         
           05  WS-S                        PIC X(01) VALUE 'S'.         
T25584     05  WS-I                        PIC X(01) VALUE 'I'.         
           05  WS-F                        PIC X(01) VALUE 'F'.         
           05  WS-SCEG                     PIC X(02) VALUE '01'.        
           05  WS-ZERO                     PIC 9(01) VALUE  0.          
C35584     05  WS-NOTICE-COMM-TYPE         PIC X(02) VALUE '16'.        
C35584     05  WS-SECR-LTR-COMM-TYPE       PIC X(02) VALUE '05'.        
C35584     05  WS-COMM-SUB-90207           PIC X(02) VALUE '11'.        
C35584     05  WS-COMM-SUB-90810           PIC X(02) VALUE '12'.        
                                                                        
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE              PIC S9(04) COMP VALUE 0.     
           05  RS-RETURN-CODE-DISP         PIC +Z(04).                  
A37741     05  S-RETURN-CODE               PIC S9(9) VALUE +000 COMP.   
                                                                        
HPCCDM*EJECT                                                            02290000
      ******* WS FOR 6010-REDUCE-EMBEDDED SPACES ****************       02300000
       COPY CWS00011.                                                   02310000
                                                                        
      ******* WS FOR DB2 & CICS ERROR PROCESSING ****************       02330000
       COPY CWS00303.                                                   02340000
                                                                        
      ******* WS-ABEND WORK AREA  ****************                      02360000
       COPY CWS00010.                                                   02370000
                                                                        
      ******* WS-FCA00-MISC       ****************                      02390000
       COPY CWS00039.                                                   02400000
                                                                        
      ******* WS-ABEND-SWITCH     ****************                      02420000
       COPY CWS09900.                                                   02430000
                                                                        
P00599******* CORRESP NOTICE VARIABLES************                      02450000
P00599 COPY CWS00341.                                                   02460000
P00599                                                                  
                                                                        
P00599******************************************************************        
P00599* VARIABLES NEEDED FOR NOTICE PROCESSING                         *        
P00599******************************************************************        
P00599                                                                  
P00599     EXEC SQL                                                             
P00599        INCLUDE CWS00350                                                  
P00599     END-EXEC.                                                            
P00599                                                                  
      ******* FIOJC01 WORKING STORAGE ************                      02490000
       COPY FIOJC01.                                                    02500000
                                                                        
      ******* FCA00-KEY           ****************                      02520000
       COPY FIOCA00.                                                    02530000
                                                                        
           EXEC SQL                                                     02550000
                INCLUDE SQLCA                                           02560000
           END-EXEC.                                                    02570000
                                                                        
      ******* TABLE DECLARATION FOR CSS_ACCOUNT  *********************  02590000
                                                                        
           EXEC SQL                                                     02610000
                INCLUDE TBACCT                                          02620000
           END-EXEC.                                                    02630000
      *                                                                 02640000
      ******* TABLE DECLARATION FOR CSS_JOB_PARM      ******************02710000
      *                                                                 02720000
           EXEC SQL                                                     02730000
               INCLUDE TBJBPARM                                         02740000
           END-EXEC.                                                    02750000
      *                                                                 02760000
      ******* TABLE DECLARATION FOR CSS_MNT_TRANS_HIST****************  02770000
      *                                                                 02780000
           EXEC SQL                                                     02790000
               INCLUDE TBMNHIST                                         02800000
           END-EXEC.                                                    02810000
      *                                                                 02820000
      ******* TABLE DECLARATION FOR CSS_MT_TRN_HST_DET****************  02830000
      *                                                                 02840000
           EXEC SQL                                                     02850000
               INCLUDE TBMNHDT                                          02860000
           END-EXEC.                                                    02870000
      *                                                                 02880000
C26296******* TABLE DECLARATION FOR CSS_CREDIT_PROFILE****************  03010000
C26296*                                                                 03020000
C26296     EXEC SQL                                                     03030000
C26296         INCLUDE TBCRPROF                                         03040000
C26296     END-EXEC.                                                    03050000
C26296*                                                                 03060000
      *---< CSS_CUST_PHONE  >                                           03070000
           EXEC SQL                                                     03080000
              INCLUDE TBCSTPHN                                          03090000
           END-EXEC.                                                    03100000
                                                                        
      ******* WORKING STORAGE FOR WS-MISC.                              03170000
           EXEC SQL                                                     03180000
              INCLUDE CWS00038                                          03190000
           END-EXEC.                                                    03200000
      *                                                                 03210000
ACT243 01  WS-INSERT-ROW-COUNT REDEFINES WS-INPUT-DATA-BREAKDOWN.       
ACT243     10  WS-PARM-COMMIT-ROW-COUNT-TXT PIC X(9).                   
ACT243         88 COMMIT-ROW-CNT         VALUE 'COMMIT = '.             
ACT243     10  WS-NO-OF-ROWS-TO-COMMIT   PIC X(05).                     
ACT243     10  FILLER                    PIC X(66).                     
ACT243*                                                                         
      ******* TABLE DECLARATION FOR CSS_DELINQUENCY  ****************   03220000
           EXEC SQL                                                     03230000
               INCLUDE TBDELQ                                           03240000
           END-EXEC.                                                    03250000
      *                                                                 03260000
      ******* TABLE DECLARATION FOR CSS_GUARANTOR    ****************   03270000
           EXEC SQL                                                     03280000
               INCLUDE TBGTNTR                                          03290000
           END-EXEC.                                                    03300000
                                                                        
T25584     EXEC SQL                                                     03320000
T25584         INCLUDE TBRESTRT                                         03330000
T25584     END-EXEC.                                                    03340000
                                                                        
      ******* CURSOR DECLARATION FOR CSS_GUARANTOR                      03360000
           EXEC SQL                                                     
              DECLARE GUAR_CSR CURSOR WITH HOLD FOR                     
              SELECT A.ACCOUNT_NO,                                      
                     A.CNT_ITEM_ID,                                     
                     A.GUARNTR_ACCT_NO,                                 
                     A.ADDRESS_ID,                                      
                     A.GUAR_STATUS_CD,                                  
                     A.GUAR_LTR_STATUS_CD,                              
                     A.AMOUNT_GUARANTEED,                               
                     A.GUAR_ESTBLSH_DT,                                 
                     B.ACCOUNT_NO,                                      
                     B.CUSTOMER_NO,                                     
                     B.PREMISE_NO,                                      
                     B.COMPANY_NO,                                      
                     B.LOCAL_OFFICE,                                    
                     B.DATE_BILL_DAY_00,                                
                     B.DATE_BILL_DAY_30,                                
                     B.DATE_BILL_DAY_60,                                
                     B.DATE_BILL_DAY_90,                                
                     B.BILL_CYCLE,                                      
C35152               B.ADDRESS_ID,                                      
C35152               B.ADDRESS_FORMAT                                   
              FROM CSS_GUARANTOR A WITH(READUNCOMMITTED), CSS_ACCOUNT B
                           WITH(READUNCOMMITTED)                       
              WHERE A.GUARNTR_ACCT_NO = B.ACCOUNT_NO AND                
                    (A.GUAR_STATUS_CD = 'A' AND                         
                     A.GUAR_LTR_STATUS_CD = 'P')                        
T33928        FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     03370000
MFA-TR*       DECLARE GUAR_CSR CURSOR WITH HOLD FOR                     03380000
MFA-TR*       SELECT A.ACCOUNT_NO,                                      03390000
MFA-TR*              A.CNT_ITEM_ID,                                     03400000
MFA-TR*              A.GUARNTR_ACCT_NO,                                 03410000
MFA-TR*              A.ADDRESS_ID,                                      03420000
MFA-TR*              A.GUAR_STATUS_CD,                                  03430000
MFA-TR*              A.GUAR_LTR_STATUS_CD,                              03440000
MFA-TR*              A.AMOUNT_GUARANTEED,                               03450000
MFA-TR*              A.GUAR_ESTBLSH_DT,                                 03460000
MFA-TR*              B.ACCOUNT_NO,                                      03470000
MFA-TR*              B.CUSTOMER_NO,                                     03480000
MFA-TR*              B.PREMISE_NO,                                      03490000
MFA-TR*              B.COMPANY_NO,                                      03500000
MFA-TR*              B.LOCAL_OFFICE,                                    03510000
MFA-TR*              B.DATE_BILL_DAY_00,                                03520000
MFA-TR*              B.DATE_BILL_DAY_30,                                03530000
MFA-TR*              B.DATE_BILL_DAY_60,                                03540000
MFA-TR*              B.DATE_BILL_DAY_90,                                03550000
MFA-TR*              B.BILL_CYCLE,                                      03560000
MFA-TR*              B.ADDRESS_ID,                                      03570000
MFA-TR*              B.ADDRESS_FORMAT                                   03580000
MFA-TR*       FROM CSS_GUARANTOR A, CSS_ACCOUNT B                       03590000
MFA-TR*       WHERE A.GUARNTR_ACCT_NO = B.ACCOUNT_NO AND                03600000
MFA-TR*             (A.GUAR_STATUS_CD = 'A' AND                         03610000
MFA-TR*              A.GUAR_LTR_STATUS_CD = 'P')                        03620000
MFA-TR*       FOR FETCH ONLY WITH UR                                    03630000
MFA-TR*    END-EXEC.                                                    03640000
      **                                                                03650000
C26296****  THIS IS THE CURSOR SELECT FOR THE CASH ONLY LETTERS ***     03660000
           EXEC SQL                                                     
           DECLARE MNT_DET_SUM_CSR CURSOR WITH HOLD FOR                 
           SELECT MH.ACCOUNT_NO,                                        
                  MH.USER_ID,                                           
                  REPLACE(REPLACE(CONVERT(CHAR(26), MH.TRANS_HIST_SEQ_NO
           , 121), ' ', '-'), ':', '.') TRANS_HIST_SEQ_NO,                     
                  MI.TRAN_APPL_NO,                                      
                  MI.PRV_COLUMN_VALUE,                                  
                  MI.CHG_COLUMN_VALUE,                                  
                  AT.ACCOUNT_NO,                                        
                  AT.CUSTOMER_NO,                                       
                  AT.PREMISE_NO,                                        
                  AT.COMPANY_NO,                                        
                  AT.LOCAL_OFFICE,                                      
                  AT.DATE_BILL_DAY_00,                                  
                  AT.DATE_BILL_DAY_30,                                  
                  AT.DATE_BILL_DAY_60,                                  
                  AT.DATE_BILL_DAY_90,                                  
                  AT.BILL_CYCLE                                         
C35152           ,AT.ADDRESS_ID                                         
C35152           ,AT.ADDRESS_FORMAT                                     
            FROM  CSS_MNT_TRANS_HIST MH WITH(READUNCOMMITTED),                  
                  CSS_MT_TRN_HST_DET MI WITH(READUNCOMMITTED),                  
                  CSS_ACCOUNT AT WITH(READUNCOMMITTED),                         
                  CSS_CREDIT_PROFILE CZ WITH(READUNCOMMITTED)                   
            WHERE MH.TRANS_HIST_SEQ_NO <= CIS.CHAR2TIMESTAMP(
                                                     :WS-HOLD-TIMESTAMP
              )            
              AND MH.TRANS_HIST_SEQ_NO > CIS.CHAR2TIMESTAMP(
                                                  :WS-LR-DATE-TIMESTAMP
              )          
              AND MH.TRANS_HIST_SEQ_NO = MI.TRANS_HIST_SEQ_NO           
              AND (MI.COLUMN_DESC = 'CASH ONLY FL   '                   
                   AND MI.CHG_COLUMN_VALUE = 'Y')                       
              AND (MH.APPL_PROGRAM_ID = 'PANEL182D'                     
                 OR MH.APPL_PROGRAM_ID = 'PANEL182C'                    
A05058           OR MH.APPL_PROGRAM_ID = 'PANEL182O')                   
              AND MH.ACCOUNT_NO = AT.ACCOUNT_NO                         
              AND MH.ACCOUNT_NO = CZ.ACCOUNT_NO                         
              AND CZ.CASH_ONLY_FL = 'Y'                                 
            ORDER BY TRANS_HIST_SEQ_NO                               
T33928      FOR READ ONLY                                       
C26296      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     03670000
MFA-TR*    DECLARE MNT_DET_SUM_CSR CURSOR WITH HOLD FOR                 03680000
MFA-TR*    SELECT MH.ACCOUNT_NO,                                        03690000
MFA-TR*           MH.USER_ID,                                           03700000
MFA-TR*           MH.TRANS_HIST_SEQ_NO,                                 03710000
MFA-TR*           MI.TRAN_APPL_NO,                                      03720000
MFA-TR*           MI.PRV_COLUMN_VALUE,                                  03730000
MFA-TR*           MI.CHG_COLUMN_VALUE,                                  03740000
MFA-TR*           AT.ACCOUNT_NO,                                        03750000
MFA-TR*           AT.CUSTOMER_NO,                                       03760000
MFA-TR*           AT.PREMISE_NO,                                        03770000
MFA-TR*           AT.COMPANY_NO,                                        03780000
MFA-TR*           AT.LOCAL_OFFICE,                                      03790000
MFA-TR*           AT.DATE_BILL_DAY_00,                                  03800000
MFA-TR*           AT.DATE_BILL_DAY_30,                                  03810000
MFA-TR*           AT.DATE_BILL_DAY_60,                                  03820000
MFA-TR*           AT.DATE_BILL_DAY_90,                                  03830000
MFA-TR*           AT.BILL_CYCLE                                         03840000
MFA-TR*          ,AT.ADDRESS_ID                                         03850000
MFA-TR*          ,AT.ADDRESS_FORMAT                                     03860000
MFA-TR*     FROM  CSS_MNT_TRANS_HIST MH,                                03870000
MFA-TR*           CSS_MT_TRN_HST_DET MI,                                03880000
MFA-TR*           CSS_ACCOUNT AT,                                       03890000
MFA-TR*           CSS_CREDIT_PROFILE CZ                                 03900000
MFA-TR*     WHERE MH.TRANS_HIST_SEQ_NO <= :WS-HOLD-TIMESTAMP            03910000
MFA-TR*       AND MH.TRANS_HIST_SEQ_NO > :WS-LR-DATE-TIMESTAMP          03920000
MFA-TR*       AND MH.TRANS_HIST_SEQ_NO = MI.TRANS_HIST_SEQ_NO           03930000
MFA-TR*       AND (MI.COLUMN_DESC = 'CASH ONLY FL   '                   03940000
MFA-TR*            AND MI.CHG_COLUMN_VALUE = 'Y')                       03950000
MFA-TR*       AND (MH.APPL_PROGRAM_ID = 'PANEL182D'                     03960000
MFA-TR*          OR MH.APPL_PROGRAM_ID = 'PANEL182C'                    03970000
MFA-TR*          OR MH.APPL_PROGRAM_ID = 'PANEL182O')                   03970000
MFA-TR*       AND MH.ACCOUNT_NO = AT.ACCOUNT_NO                         03980000
MFA-TR*       AND MH.ACCOUNT_NO = CZ.ACCOUNT_NO                         03990000
MFA-TR*       AND CZ.CASH_ONLY_FL = 'Y'                                 04000000
MFA-TR*     ORDER BY MH.TRANS_HIST_SEQ_NO                               04010000
MFA-TR*     FOR FETCH ONLY WITH UR                                      04020000
MFA-TR*     END-EXEC.                                                   04030000
       01  WS-END                       PIC X(40)                       
           VALUE 'WORKING STORAGE FOR PCSCA141 ENDS HERE  '.            
HPCCDM*    EJECT                                                        04060000
                                                                        
*******LINKAGE SECTION.                                                 04080000
HPCCDM*EJECT                                                            04090000
                                                                        
       PROCEDURE DIVISION.                                              
      ******************************************************************04120000
      *                                                                *04130000
      *   0000-MAINLINE.                                               *04140000
      *        CONTROLS THE MAIN PROCESS OF PROGRAM                    *04150000
      *                                                                *04160000
      ******************************************************************04170000
       0000-MAINLINE.                                                   
      *                                                                 04190000
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
           PERFORM 1000-CURSOR-PROCESS THRU 1000-EXIT.                  
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
ACT265*                                                                 04490000
ACT265     PERFORM 4750-UPD-LAST-RUN-DATE     THRU 4750-EXIT.           
ACT265*                                                                         
ACT243     DISPLAY 'PCSCA141 COMPLETED SUCCESSFULLY'.                   
ACT243*                                                                 04230000
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04550000
      *                                                                *04560000
      *   0100-INITIALIZATION                                          *04570000
      *        COMMON INITIALIZATION ROUTINE                           *04580000
      *                                                                *04590000
      ***************************************************************** 04600000
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
ACT243     PERFORM 0115-GET-COMMIT-NBR-COUNT  THRU 0115-EXIT.           
ACT243*                                                                 04820000
ACT243     PERFORM 7700-SELECT-LAST-RUN-DATE  THRU 7700-EXIT            
ACT243     MOVE G6-PARM-DATA                 TO WS-JOB-PARM-DATA        
ACT243     MOVE WS-LRD-TS                    TO WS-LR-DATE-TIMESTAMP    
ACT243*                                                                 04840000
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT         
              MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE                
           END-IF.                                                      
                                                                        
           MOVE WS-INPUT-DATE TO WS-JOB-PARM.                           
                                                                        
C26296     PERFORM 7200-GET-TIMESTAMP THRU 7200-EXIT.                   
C26296     MOVE WS-TIMESTAMP TO WS-HOLD-TIMESTAMP.                      
C26289*                                                                 04950000
C26289     MOVE 'DATABASE' TO C8-DELINQ-CD.                             
C26289     MOVE '01'       TO C8-COMPANY-NO                             
C26289     PERFORM 7300-GET-DELINQ-VALUE THRU 7300-EXIT.                
C26289     MOVE C8-DELINQ-VALUE TO WS-DATABASE                          
P00599                             WS-CWS350-DATABASE.                  
C26289*                                                                 05000000
C26289     SET TB-CO-INDEX TO 1.                                        
C26289     SET TB-VAL-INDEX TO 1.                                       
C26289     PERFORM 0101-LOAD-DL-VARIABLE THRU 0101-EXIT.                
C26289     MOVE SPACES TO WS-CURRENT-COMPANY.                           
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
C26289                                                                  
C26289******************************************************************05090000
C26289*   0101-LOAD-DL-VARIABLE.                                       *05100000
C26289*        LOADS DELINQUENCY VALUES                                *05110000
C26289***************************************************************** 05120000
C26289 0101-LOAD-DL-VARIABLE.                                           
C26289                                                                  
C26289     MOVE '01'                TO WS-CURRENT-COMPANY.              
C26289     MOVE WS-CURRENT-COMPANY  TO C8-COMPANY-NO.                   
C26289     MOVE 'RETAIN-COMMER-DEP' TO C8-DELINQ-CD.                    
C26289     PERFORM 7300-GET-DELINQ-VALUE THRU 7300-EXIT.                
C26289     PERFORM 0102-LOAD-TABLE-ENTRY THRU 0102-EXIT.                
C26289     MOVE WS-CURRENT-COMPANY  TO C8-COMPANY-NO.                   
C26289     MOVE 'RETAIN-INDUST-DEP' TO C8-DELINQ-CD.                    
C26289     PERFORM 7300-GET-DELINQ-VALUE THRU 7300-EXIT.                
C26289     PERFORM 0102-LOAD-TABLE-ENTRY THRU 0102-EXIT.                
C26289     MOVE WS-CURRENT-COMPANY  TO C8-COMPANY-NO.                   
P00518     MOVE 'RETAIN-RESIDENT-DEP' TO C8-DELINQ-CD.                  
P00518     PERFORM 7300-GET-DELINQ-VALUE THRU 7300-EXIT.                
P00518     PERFORM 0102-LOAD-TABLE-ENTRY THRU 0102-EXIT.                
C26289*                                                                 05280000
C26289     IF CSR-DATABASE                                              
C26289         SET TB-CO-INDEX UP BY 1                                  
C26289         SET TB-VAL-INDEX TO 1                                    
C26289         MOVE '26'                TO WS-CURRENT-COMPANY           
C26289         MOVE WS-CURRENT-COMPANY  TO C8-COMPANY-NO                
C26289         MOVE 'RETAIN-COMMER-DEP' TO C8-DELINQ-CD                 
C26289         PERFORM 7300-GET-DELINQ-VALUE THRU 7300-EXIT             
C26289         PERFORM 0102-LOAD-TABLE-ENTRY THRU 0102-EXIT             
C26289         MOVE WS-CURRENT-COMPANY  TO C8-COMPANY-NO                
C26289         MOVE 'RETAIN-INDUST-DEP' TO C8-DELINQ-CD                 
C26289         PERFORM 7300-GET-DELINQ-VALUE THRU 7300-EXIT             
C26289         PERFORM 0102-LOAD-TABLE-ENTRY THRU 0102-EXIT             
C26289     END-IF.                                                      
C26289*                                                                 05420000
C26289 0101-EXIT.                                                       
C26289     EXIT.                                                        
C26289*                                                                 05450000
C26289******************************************************************05460000
C26289*   0102-LOAD-DL-VARIABLE.                                       *05470000
C26289*        LOADS DELINQUENCY VALUES                                *05480000
C26289***************************************************************** 05490000
C26289 0102-LOAD-TABLE-ENTRY.                                           
C26289*                                                                 05510000
C26289     MOVE WS-CURRENT-COMPANY TO                                   
C26289         WS-DELINQ-COMPANY-TB (TB-CO-INDEX, TB-VAL-INDEX).        
C26289     MOVE C8-DELINQ-CD   TO                                       
C26289         WS-DELINQ-CODE-TB (TB-CO-INDEX, TB-VAL-INDEX).           
C26289     MOVE C8-DELINQ-VALUE   TO                                    
C26289         WS-DELINQ-VALUE-TB (TB-CO-INDEX, TB-VAL-INDEX).          
C26289     SET TB-VAL-INDEX UP BY 1.                                    
C26289*                                                                 05590000
C26289 0102-EXIT.                                                       
C26289     EXIT.                                                        
ACT243*                                                                 05590000
ACT243******************************************************************        
ACT243* 0115-GET-COMMIT-NBR-COUNT.                                     *        
ACT243* GET THE COMMIT NBR COUNT FROM JOB PARM TABLE                   *        
ACT243******************************************************************        
ACT243 0115-GET-COMMIT-NBR-COUNT.                                       
ACT243*                                                                         
ACT243     MOVE  WS-PGRMNAME               TO WS-PROGRAM.               
ACT243     MOVE  WS-PARM                   TO WS-COMMAND.               
ACT243     MOVE  ZEROS                     TO WS-SEQUENCE.              
ACT243     MOVE  SPACES                    TO WS-SYSIPT.                
ACT243     MOVE  WS-KEY-AREA               TO E-FJC01-KEY.              
ACT243*                                                                         
ACT243     PERFORM 7600-START-FCSJC01      THRU  7600-EXIT.             
ACT243     PERFORM 7610-READ-FCSJC01       THRU  7610-EXIT              
ACT243        UNTIL (COMMIT-ROW-CNT AND INPUT-ACTIVE)                   
ACT243        OR  END-OF-SYSIPT.                                        
ACT243*                                                                         
ACT243     IF END-OF-SYSIPT                                             
ACT243        DISPLAY ' '                                               
ACT243        DISPLAY '** ' WS-PGRMNAME ' PROCESSING WARNING  **'       
ACT243        DISPLAY '**  COMMIT-ROW-CNT PARM NOT ACTIVE     **'       
ACT243        DISPLAY '**  DEFAULT OF 100 WILL BE USED  **'             
ACT243        DISPLAY '**  PROCESSING CONTINUING        **'             
ACT243        MOVE 100 TO WS-READY-TO-COMMIT-COUNT                      
ACT243     ELSE                                                         
ACT243        IF WS-NO-OF-ROWS-TO-COMMIT NUMERIC                        
ACT243           MOVE WS-NO-OF-ROWS-TO-COMMIT                           
ACT243                                   TO WS-READY-TO-COMMIT-COUNT    
ACT243        ELSE                                                      
ACT243           DISPLAY ' '                                            
ACT243           DISPLAY '**  ' WS-PGRMNAME ' PROCESSING WARNING  **'   
ACT243           DISPLAY '**  COMMIT-ROW-CNT PARM NOT NUMERIC  **'      
ACT243           DISPLAY '**  DEFAULT OF 100 WILL BE USED  **'          
ACT243           DISPLAY '**  PROCESSING CONTINUING        **'          
ACT243           MOVE 100 TO WS-READY-TO-COMMIT-COUNT                   
ACT243        END-IF                                                    
ACT243        PERFORM 7611-CLOSE THRU 7611-EXIT                         
ACT243     END-IF.                                                      
ACT243*                                                                         
ACT243 0115-EXIT.                                                       
ACT243     EXIT.                                                        
ACT243*                                                                         
      ******************************************************************06130000
      * OPENS THE CURSOR, FETCH AND PROCESS TO CHECK FOR GUARANTOR ACCT*06140000
      * THAT NEEDS CONFIRMATION LETTER GENERATED.                      *06150000
C26296* SEB DOES NOT SEND    GUARANTOR CONFIRMATION LETTERS.           *06160000
C26296* CASH ONLY LETTER CURSOR IS ALSO PROCESSED.                     *06170000
      ******************************************************************06180000
       1000-CURSOR-PROCESS.                                             
                                                                        
P00599     INITIALIZE WS-CORRESP-HDR.                                   
           PERFORM 7005-OPEN-CURSOR  THRU 7005-EXIT.                    
           PERFORM 7010-FETCH-CURSOR THRU 7010-EXIT.                    
C26296     IF WS-END-OF-ROWS = 'N'                                      
C26296        MOVE AT-COMPANY-NO          TO C8-COMPANY-NO              
C26296        MOVE    ZEROS               TO WS-DATABASE                
C26296        MOVE 'DATABASE'             TO C8-DELINQ-CD               
C26296        PERFORM 6500-GET-DATABASE   THRU 6500-EXIT                
C26296        IF SEB-DATABASE                                           
C26296           MOVE 'Y' TO WS-END-OF-ROWS                             
C26296        END-IF                                                    
C26296     END-IF.                                                      
           PERFORM 2000-PROCESS-RECORDS   THRU 2000-EXIT                
               UNTIL END-OF-ROWS.                                       
           PERFORM 7050-CLOSE-CURSOR THRU 7050-EXIT.                    
      *                                                                 06350000
P00599     INITIALIZE WS-CORRESP-HDR.                                   
C26296     MOVE 'N' TO WS-END-OF-ROWS.                                  
C26296     PERFORM 7060-OPEN-CURSOR  THRU 7060-EXIT.                    
C26296     PERFORM 7070-FETCH-CURSOR THRU 7070-EXIT.                    
C26296     PERFORM 2010-PROCESS-CASH-ONLY THRU 2010-EXIT                
C26296         UNTIL END-OF-ROWS.                                       
C26296     PERFORM 7080-CLOSE-CURSOR THRU 7080-EXIT.                    
      *                                                                 06420000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06450000
HPCCDM*EJECT                                                            06460000
      ******************************************************************06670000
      *                                                                *06680000
      *       2000-PROCESS-RECORDS                                     *06690000
      *                                                                *06700000
      *  PROCESSES EACH RECORD TO CREATE GUARANTOR CONFIRMATION LETTER.*06710000
      *                                                                *06720000
      ******************************************************************06730000
       2000-PROCESS-RECORDS.                                            
P00599                                                                  
P00599     INITIALIZE WS-CORRESP-NOTICE                                 
P00599                WS-CORRESP-VAR                                    
P00599                WS-MISC-PROCESSING-VARS                           
P00599                WS-KR125-COMM-DATA-VARS                           
P00599                WS-KR125-MNT-TRANS-VARS.                          
                                                                        
           MOVE AT-ACCOUNT-NO     TO MH-ACCOUNT-NO.                     
C26296     MOVE GU-ACCOUNT-NO     TO AT-ACCOUNT-NO.                     
C26296     MOVE MH-ACCOUNT-NO     TO AT-ACCOUNT-NO.                     
           PERFORM 7510-SELECT-HOME-PHONE    THRU 7510-EXIT.            
           PERFORM 7520-SELECT-WORK-PHONE    THRU 7520-EXIT.            
C26296     PERFORM 8000-MOVE-LETTER-INFO     THRU 8000-EXIT.            
C26296     PERFORM 8010-MOVE-GTOR-GTEE-INFO  THRU 8010-EXIT.            
ACT034     PERFORM 6600-LOAD-CUST-COMM       THRU 6600-EXIT.            
           PERFORM 8100-UPD-GUARANTOR        THRU 8100-EXIT.            
           PERFORM 8200-MOVE-TRANS-HIST      THRU 8200-EXIT.            
C26296     PERFORM 8210-MOVE-GTOR-HIST       THRU 8210-EXIT.            
P00599     PERFORM 5000-CALL-NOTICES         THRU 5000-EXIT.            
ACT243     ADD 1                             TO WS-COMMIT-COUNTER       
ACT243     IF WS-COMMIT-COUNTER = WS-READY-TO-COMMIT-COUNT              
C26296        MOVE SPACES                   TO                          
C26296                                     WS-HOLD-HIST-SEQ-NO          
T25584        PERFORM 8888-COMMIT                THRU 8888-EXIT         
ACT243        MOVE ZEROES                        TO WS-COMMIT-COUNTER   
T25584     END-IF.                                                      
T25584*                                                                 06960000
P00599     MOVE GU-GUARNTR-ACCT-NO           TO WS-PREV-ACCOUNT-NO      
           PERFORM 7010-FETCH-CURSOR         THRU 7010-EXIT.            
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07020000
      *                                                                *07030000
      *       2010-PROCESS-CASH-ONLY                                   *07040000
      *                                                                *07050000
      *  PROCESSES EACH RECORD TO CREATE CASH ONLY LETTER.             *07060000
      *                                                                *07070000
      ******************************************************************07080000
C26296 2010-PROCESS-CASH-ONLY.                                          
                                                                        
P00599     INITIALIZE WS-CORRESP-NOTICE                                 
P00599                WS-CORRESP-VAR                                    
P00599                WS-MISC-PROCESSING-VARS                           
P00599                WS-KR125-COMM-DATA-VARS                           
P00599                WS-KR125-MNT-TRANS-VARS.                          
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO      TO WS-HOLD-HIST-SEQ-NO.       
           PERFORM 7510-SELECT-HOME-PHONE     THRU 7510-EXIT.           
           PERFORM 7520-SELECT-WORK-PHONE     THRU 7520-EXIT.           
           PERFORM 8000-MOVE-LETTER-INFO      THRU 8000-EXIT.           
           PERFORM 8020-MOVE-CASH-ONLY-INFO   THRU 8020-EXIT.           
ACT034     PERFORM 6600-LOAD-CUST-COMM        THRU 6600-EXIT.           
           PERFORM 8200-MOVE-TRANS-HIST       THRU 8200-EXIT.           
           PERFORM 8220-MOVE-CASH-HIST        THRU 8220-EXIT.           
P00599     PERFORM 5000-CALL-NOTICES          THRU 5000-EXIT.           
ACT243     ADD 1                              TO WS-COMMIT-COUNTER      
ACT243     IF WS-COMMIT-COUNTER = WS-READY-TO-COMMIT-COUNT              
              PERFORM 8888-COMMIT                THRU 8888-EXIT         
ACT243        MOVE ZEROES                        TO WS-COMMIT-COUNTER   
ACT265        MOVE WS-Y                          TO WS-COMMIT-FLAG      
ACT243        PERFORM 4750-UPD-LAST-RUN-DATE     THRU 4750-EXIT         
           END-IF.                                                      
           PERFORM 7070-FETCH-CURSOR         THRU 7070-EXIT.            
                                                                        
C26296 2010-EXIT.                                                       
C26296     EXIT.                                                        
      ***************************************************************** 07380000
      ** 6240-GET-FCA00-COMMON-DATE                                     07390000
      ***************************************************************** 07400000
                                                                        
           EXEC SQL                                                     07420000
                INCLUDE CPD00040                                        07430000
           END-EXEC.                                                    07440000
                                                                        
      ***************************************************************** 07460000
      ** 6251-GET-FJC01-DATE                                         ** 07470000
      ***************************************************************** 07480000
                                                                        
           EXEC SQL                                                     07500000
                INCLUDE CPD00037                                        07510000
           END-EXEC.                                                    07520000
                                                                        
ACT243******************************************************************        
ACT243*  7600-START-FCSJC01                                            *        
ACT243*  7610-READ-FCSJC01                                             *        
ACT243*  7611-CLOSE                                                    *        
ACT243****************************************************************          
           EXEC SQL                                                     07700000
                INCLUDE CPD00038                                        07710000
           END-EXEC.                                                    07720000
                                                                        
           EXEC SQL                                                     07740000
                INCLUDE CPD00039                                        07750000
           END-EXEC.                                                    07760000
                                                                        
      ******************************************************************07780000
      *                                                                *07790000
      *      4750-UPD-LAST-RUN-DATE                                    *07800000
      *                                                                *07810000
      ******************************************************************07820000
C26296 4750-UPD-LAST-RUN-DATE.                                          
      *                                                                 07840000
           MOVE SPACES                     TO G6-PARM-DATA.             
ACT265*                                                                 07840000
ACT265     IF WS-COMMIT-FLAG = WS-Y                                     
ACT265        MOVE MH-TRANS-HIST-SEQ-NO    TO WS-LRD-TS                 
ACT265        MOVE WS-N                    TO WS-COMMIT-FLAG            
ACT265     ELSE                                                         
ACT265        MOVE WS-HOLD-TIMESTAMP       TO WS-LRD-TS                 
ACT265     END-IF.                                                      
      *                                                                 07880000
ACT265     MOVE WS-JOB-PARM-DATA           TO G6-PARM-DATA              
C26296     MOVE '10'                       TO G6-SEQ-NO                 
C26296     MOVE WS-PGRMNAME                TO G6-PROGRAM-NAME           
C26296     MOVE WS-SCEG                    TO G6-COMPANY-NO             
C26296     MOVE WS-A                       TO G6-STATUS                 
C26296     MOVE 'PARM'                     TO G6-CMND-CODE              
C26296     PERFORM 8870-RESET-JOB-PARM                  THRU 8870-EXIT. 
      *                                                                 07950000
       4750-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07980000
P00599******************************************************************07990000
P00599*5000-CALL-NOTICES                                                08000000
P00599******************************************************************08010000
P00599*                                                                 08020000
P00599 5000-CALL-NOTICES.                                               
P00599                                                                  
P00599     CALL SCSKR125 USING   WS-CORRESP-HDR                         
P00599                           WS-CORRESP-NOTICE                      
P00599                           WS-CORRESP-VAR                         
P00599                           WS-MISC-PROCESSING-VARS                
P00599                           WS-KR125-COMM-DATA-VARS                
P00599                           WS-KR125-MNT-TRANS-VARS                
P00599                           ABEND-FILE                             
P00599                           WS-CWS350-MISC                         
P00599                           WS-CORRESP-COMM-VAR                    
P00599                           RS-KR125-RETURN-CODE.                  
P00599                                                                  
P00599     IF ABEND-FUNCTION  > SPACES                                  
ACT243        IF (ABEND-SQLCODE = -803) AND                             
ACT243           (WS-CORRESP-MSG-ID = '90207' OR                        
ACT243            WS-CORRESP-MSG-ID = '90810')                          
ACT243           CONTINUE                                               
ACT243        ELSE                                                      
ACT243           MOVE ABEND-SQLCODE            TO RS-RETURN-CODE        
ACT243                                            WS-ACTIVE-RETURN-CODE 
ACT243           PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
ACT243        END-IF                                                    
P00599     END-IF.                                                      
P00599                                                                  
P00599 5000-EXIT.                                                       
P00599     EXIT.                                                        
      *                                                                 08210000
      ***************************************************************** 08220000
      * 6500-GET-DATABASE.                                            * 08230000
      *     SELECTS BILLING ENTITY (SEB OR SCEG) FROM CSS_DELINQUENCY * 08240000
      ***************************************************************** 08250000
C26296 6500-GET-DATABASE.                                               
      *                                                                 08270000
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD  = :C8-DELINQ-CD                         
               AND   COMPANY_NO = :C8-COMPANY-NO                        
T33928                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08280000
MFA-TR*       SELECT DELINQ_VALUE                                       08290000
MFA-TR*         INTO :C8-DELINQ-VALUE                                   08300000
MFA-TR*         FROM CSS_DELINQUENCY                                    08310000
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                         08320000
MFA-TR*        AND   COMPANY_NO = :C8-COMPANY-NO                        08330000
MFA-TR*        WITH UR                                                  08340000
MFA-TR*    END-EXEC.                                                    08350000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08360000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 08380000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE C8-DELINQ-VALUE          TO WS-DATABASE              
           ELSE                                                         
              MOVE '6500' TO WS-ACTIVE-PARAGRAPH                        
              DISPLAY '*************PCSCA141************************'   
              DISPLAY '** 6500-GET-DATABASE      :RETURN CODE ERROR '   
              DISPLAY '** RETURN CODE = ' SQLCODE                       
              DISPLAY '*** ACCOUNT = ' AT-ACCOUNT-NO                    
              DISPLAY '*************PCSCA141************************'   
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 08500000
C26296 6500-EXIT.                                                       
C26296     EXIT.                                                        
      ******************************************************************08530000
      *                                                                *08540000
      *   6600-LOAD-CUST-COMM.                                         *08550000
      ******************************************************************08560000
C35584 6600-LOAD-CUST-COMM.                                             
P00599                                                                  
P00599        MOVE AT-COMPANY-NO            TO WS-CORRESP-COMPANY-NO    
P00599                                         WS-PROCESS-COMPANY-NO.   
P00599        MOVE WS-JOB-PARM              TO WS-CORRESP-STMT-DT       
P00599                                         WS-COMMON-DATE.          
P00599        MOVE AT-CUSTOMER-NO           TO WS-KR125-CUSTOMER-NO.    
P00599                                                                  
P00599        MOVE WS-KO-CONTACT-NAME       TO WS-KR125-CONTACT-NAME.   
P00599                                                                  
P00599        MOVE ZEROES                   TO WS-KR125-PREMISE-NO.     
P00599                                                                  
P00599                                                                  
P00599        MOVE AT-ACCOUNT-NO            TO WS-KR125-COMM-ACCT-NO.   
P00599        MOVE WS-INITIAL-COMMENT-TX    TO WS-KR125-COMDAT-CMT.     
P00599        MOVE SPACES                   TO WS-KR125-PSC-COMPL-ID    
P00599                                         WS-KR125-RED-FL-EXP-DT   
P00599                                         WS-KR125-CALL-END-TIME.  
P00599        MOVE 'A'                      TO WS-KR125-COMM-ASSOC-CD.  
P00599                                                                  
C35584 6600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08790000
      *                                                                 08800000
      ******************************************************************08810000
      * 7005-OPEN-CURSOR                                               *08820000
      *  OPENS THE CURSOR FOR PROCESSING                               *08830000
      *                                                                *08840000
      ******************************************************************08850000
       7005-OPEN-CURSOR.                                                
      *                                                                 08870000
           EXEC SQL                                                     
              OPEN GUAR_CSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7005-OPEN-CURSOR'                               
                       ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 09000000
       7005-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09030000
      ******************************************************************09040000
      *                                                                *09050000
      *   7010-FETCH-CURSOR.                                           *09060000
      *        FETCHES THE RECORD FROM THE OPENED CURSOR               *09070000
      *                                                                *09080000
      ******************************************************************09090000
       7010-FETCH-CURSOR.                                               
                                                                        
           EXEC SQL                                                     
               FETCH GUAR_CSR                                           
               INTO :GU-ACCOUNT-NO,                                     
                    :GU-CNT-ITEM-ID,                                    
                    :GU-GUARNTR-ACCT-NO,                                
                    :GU-ADDRESS-ID,                                     
                    :GU-GUAR-STATUS-CD,                                 
                    :GU-GUAR-LTR-STATUS-CD,                             
                    :GU-AMOUNT-GUARANTEED,                              
                    :GU-GUAR-ESTBLSH-DT :WS-GUAR-EST-DT-NULL,           
                    :AT-ACCOUNT-NO,                                     
                    :AT-CUSTOMER-NO,                                    
                    :AT-PREMISE-NO,                                     
                    :AT-COMPANY-NO,                                     
                    :AT-LOCAL-OFFICE,                                   
                    :AT-DATE-BILL-DAY-00,                               
                    :AT-DATE-BILL-DAY-30,                               
                    :AT-DATE-BILL-DAY-60,                               
                    :AT-DATE-BILL-DAY-90,                               
                    :AT-BILL-CYCLE,                                     
C35152              :AT-ADDRESS-ID,                                     
C35152              :AT-ADDRESS-FORMAT                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE 'Y' TO VALID-ROW-EXIST-FLAG                         
               IF WS-GUAR-EST-DT-NULL < 0                               
                   MOVE SPACES         TO GU-GUAR-ESTBLSH-DT            
               END-IF                                                   
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                   MOVE 'Y' TO WS-END-OF-ROWS                           
                   IF WS-GUAR-EST-DT-NULL < 0                           
                       MOVE SPACES         TO GU-GUAR-ESTBLSH-DT        
                   END-IF                                               
               ELSE                                                     
                   DISPLAY '7010-FETCH-CURSOR'                          
                           ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE      
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
           END-IF.                                                      
      *                                                                 09550000
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09580000
      ******************************************************************09590000
      *   7050-CLOSE-CURSOR.                                           *09600000
      *        CLOSES THE OPENED CURSOR                                *09610000
      ******************************************************************09620000
       7050-CLOSE-CURSOR.                                               
                                                                        
           EXEC SQL                                                     
               CLOSE GUAR_CSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7050-CLOSE-CURSOR'                              
                       ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09820000
      *                                                                *09830000
      * 7060-OPEN-CURSOR                                               *09840000
      *  OPENS THE CURSOR FOR PROCESSING                               *09850000
      *                                                                *09860000
      ******************************************************************09870000
C26296 7060-OPEN-CURSOR.                                                
      *                                                                 09890000
           EXEC SQL                                                     
              OPEN MNT_DET_SUM_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 09930000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '*************PCSCA141************************'   
              DISPLAY '** 7060-OPEN-CURSOR       :RETURN CODE ERROR '   
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '*************PCSCA141************************'   
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 10040000
C26296 7060-EXIT.                                                       
C26296     EXIT.                                                        
      *                                                                 10070000
      ******************************************************************10080000
      *                                                                *10090000
      *   7070-FETCH-CURSOR.                                           *10100000
      *        FETCHES THE RECORD FORM THE OPENED CURSOR               *10110000
      *                                                                *10120000
      ******************************************************************10130000
C26296 7070-FETCH-CURSOR.                                               
      *                                                                 10150000
           EXEC SQL                                                     
               FETCH MNT_DET_SUM_CSR                                    
               INTO :MH-ACCOUNT-NO,                                     
                    :MH-USER-ID,                                        
                    :MH-TRANS-HIST-SEQ-NO,                              
                    :MI-TRAN-APPL-NO,                                   
                    :MI-PRV-COLUMN-VALUE,                               
                    :MI-CHG-COLUMN-VALUE,                               
                    :AT-ACCOUNT-NO,                                     
                    :AT-CUSTOMER-NO,                                    
                    :AT-PREMISE-NO,                                     
                    :AT-COMPANY-NO,                                     
                    :AT-LOCAL-OFFICE,                                   
                    :AT-DATE-BILL-DAY-00,                               
                    :AT-DATE-BILL-DAY-30,                               
                    :AT-DATE-BILL-DAY-60,                               
                    :AT-DATE-BILL-DAY-90,                               
                    :AT-BILL-CYCLE                                      
C35152             ,:AT-ADDRESS-ID                                      
C35152             ,:AT-ADDRESS-FORMAT                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 10370000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 10390000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                   MOVE 'Y' TO WS-END-OF-ROWS                           
               ELSE                                                     
              DISPLAY '*************PCSCA141************************'   
              DISPLAY '** 7070-FETCH-CURSOR      :RETURN CODE ERROR '   
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '*************PCSCA141************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
           END-IF.                                                      
      *                                                                 10530000
C26296 7070-EXIT.                                                       
C26296     EXIT.                                                        
      *                                                                 10560000
      ******************************************************************10570000
      *                                                                *10580000
      *   7080-CLOSE-CURSOR.                                           *10590000
      *        CLOSES THE OPENED CURSOR                                *10600000
      *                                                                *10610000
      ******************************************************************10620000
C26296 7080-CLOSE-CURSOR.                                               
      *                                                                 10640000
           EXEC SQL                                                     
               CLOSE MNT_DET_SUM_CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 10680000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 10700000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '*************PCSCA141************************'   
              DISPLAY '** 7080-CLOSE-CURSOR      :RETURN CODE ERROR '   
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '*************PCSCA141************************'   
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 10800000
C26296 7080-EXIT.                                                       
C26296     EXIT.                                                        
      *                                                                 10830000
      ******************************************************************11170000
      *        GET TIMESTAMP FOR MNT_TRANS_HIST FILE                   *11180000
      ******************************************************************11190000
       7200-GET-TIMESTAMP.                                              
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TIMESTAMP                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     11220000
MFA-TR*        SET :WS-TIMESTAMP = CURRENT TIMESTAMP                    11230000
MFA-TR*    END-EXEC.                                                    11240000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     11250000
MFA-TR*        SET :WS-CURRENT-DATE = CURRENT DATE                      11260000
MFA-TR*    END-EXEC.                                                    11270000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                NEXT SENTENCE                                           
           ELSE                                                         
                DISPLAY '*******************************************'   
                DISPLAY '** ERROR IN 7270-SELECT-TIMESTAMP        **'   
                DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
                DISPLAY '**        PROCESSING IS TERMINATED       **'   
                DISPLAY '** ACCOUNT NO ' AT-ACCOUNT-NO                  
                DISPLAY '*******************************************'   
                PERFORM 9900-ABEND                THRU 9900-EXIT        
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
C26289*                                                                 11450000
C26289***************************************************************** 11460000
C26289* 7300-GET-DELINQ-VALUE.                                        * 11470000
C26289*     SELECTS VALUES FROM CSS_DELINQUENCY                       * 11480000
C26289***************************************************************** 11490000
C26289 7300-GET-DELINQ-VALUE.                                           
C26289*                                                                 11510000
C26289     EXEC SQL                                                     
C26289        SELECT DELINQ_VALUE                                       
C26289          INTO :C8-DELINQ-VALUE                                   
C26289          FROM CSS_DELINQUENCY                                    
C26289         WHERE DELINQ_CD  = :C8-DELINQ-CD                         
C26289           AND COMPANY_NO = :C8-COMPANY-NO                        
C26289     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26289*                                                                 11590000
C26289     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C26289                                                                  
C26289     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C26289        MOVE 0 TO WS-ACTIVE-RETURN-CODE                           
C26289     ELSE                                                         
C26289        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
C26289        MOVE '7300'               TO ACTIVE-PARAGRAPH             
C26289        MOVE 'SELECT'             TO ABEND-FUNCTION               
C26289        MOVE 'CSS_DELINQUENCY'    TO TABLE-1                      
C26289        MOVE 'DELINQ_CD'          TO TABLE-ELEMENT-1              
C26289        MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-2              
C26289        MOVE C8-DELINQ-CD         TO HOSTVAR-ELEMENT-1            
C26289        MOVE C8-COMPANY-NO        TO HOSTVAR-ELEMENT-2            
C26289        PERFORM 9900-ABEND        THRU 9900-EXIT                  
C26289     END-IF.                                                      
C26289*                                                                 11750000
C26289 7300-EXIT.                                                       
C26289     EXIT.                                                        
                                                                        
      ****************************************************************  11790000
      * 7510-SELECT-HOME-PHONE                                       *  11800000
      *                                                              *  11810000
      *  SELECT HOME PHONE DETAILS  FOR THE GUARANTOR AND CASH ONLY  *  11820000
      *  ACCOUNT.                                                    *  11830000
      ****************************************************************  11840000
                                                                        
       7510-SELECT-HOME-PHONE.                                          
                                                                        
           MOVE SPACES TO WS-HOME-PHONE-NO.                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) PHONE_NO                                          
               INTO   :WS-HOME-PHONE-NO                                 
                 FROM CSS_CUST_PHONE WITH(READUNCOMMITTED)                      
                WHERE CUSTOMER_NO = :AT-CUSTOMER-NO AND                 
                      CUSTOMER_TYPE = 'C'           AND                 
                      PHONE_TYPE = 'H1'                                 
T33928                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11900000
MFA-TR*        SELECT PHONE_NO                                          11910000
MFA-TR*        INTO   :WS-HOME-PHONE-NO                                 11920000
MFA-TR*          FROM CSS_CUST_PHONE                                    11930000
MFA-TR*         WHERE CUSTOMER_NO = :AT-CUSTOMER-NO AND                 11940000
MFA-TR*               CUSTOMER_TYPE = 'C'           AND                 11950000
MFA-TR*               PHONE_TYPE = 'H1'                                 11960000
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                             11970000
MFA-TR*    END-EXEC.                                                    11980000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE 0 TO WS-ACTIVE-RETURN-CODE                           
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7510'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_PHONE'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
              MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-3              
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-4              
              MOVE AT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'C'                  TO HOSTVAR-ELEMENT-2            
              MOVE 'H1'                 TO HOSTVAR-ELEMENT-3            
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-4            
              PERFORM 9900-ABEND        THRU 9900-EXIT                  
           END-IF.                                                      
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  12230000
      * 7520-SELECT-WORK-PHONE                                       *  12240000
      *                                                              *  12250000
      *  SELECT WORK PHONE DETAILS  FOR THE GUARANTOR AND CASH ONLY  *  12260000
      *  ACCOUNT.                                                    *  12270000
      ****************************************************************  12280000
                                                                        
       7520-SELECT-WORK-PHONE.                                          
                                                                        
           MOVE SPACES                TO WS-WORK-PHONE-NO               
                                         CB-EXTENSION-NO.               
                                                                        
           EXEC SQL                                                     
               SELECT PHONE_NO, EXTENSION_NO                            
               INTO   :WS-WORK-PHONE-NO, :CB-EXTENSION-NO               
                 FROM CSS_CUST_PHONE WITH(READUNCOMMITTED)                      
                WHERE CUSTOMER_NO = :AT-CUSTOMER-NO AND                 
                      CUSTOMER_TYPE = 'C'           AND                 
                      PHONE_TYPE = 'W1'                                 
T33928                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     12350000
MFA-TR*        SELECT PHONE_NO, EXTENSION_NO                            12360000
MFA-TR*        INTO   :WS-WORK-PHONE-NO, :CB-EXTENSION-NO               12370000
MFA-TR*          FROM CSS_CUST_PHONE                                    12380000
MFA-TR*         WHERE CUSTOMER_NO = :AT-CUSTOMER-NO AND                 12390000
MFA-TR*               CUSTOMER_TYPE = 'C'           AND                 12400000
MFA-TR*               PHONE_TYPE = 'W1'                                 12410000
MFA-TR*        WITH UR                                                  12420000
MFA-TR*    END-EXEC.                                                    12430000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE 0 TO WS-ACTIVE-RETURN-CODE                           
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7520'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_PHONE'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
              MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-3              
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-4              
              MOVE AT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'C'                  TO HOSTVAR-ELEMENT-2            
              MOVE 'W1'                 TO HOSTVAR-ELEMENT-3            
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-4            
              PERFORM 9900-ABEND        THRU 9900-EXIT                  
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12670000
C26289****************************************************************  12680000
C26289* 7530-SELECT-CUST-ACCT-TYPE                                   *  12690000
C26289*                                                              *  12700000
C26289*  SELECT ACCOUNT TYPE CODE FOR THE GUARANTEE ACCOUNT.         *  12710000
C26289****************************************************************  12720000
C26289 7530-SELECT-CUST-ACCT-TYPE.                                      
C26289*                                                                 12740000
C26289     EXEC SQL                                                     
C26289         SELECT ACCOUNT_TYPE_CODE                                 
C26289         INTO   :AT-ACCOUNT-TYPE-CODE                             
C26289           FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
C26289          WHERE ACCOUNT_NO = :GU-ACCOUNT-NO                       
C26289                                                           
C26289     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     12750000
MFA-TR*        SELECT ACCOUNT_TYPE_CODE                                 12760000
MFA-TR*        INTO   :AT-ACCOUNT-TYPE-CODE                             12770000
MFA-TR*          FROM CSS_ACCOUNT                                       12780000
MFA-TR*         WHERE ACCOUNT_NO = :GU-ACCOUNT-NO                       12790000
MFA-TR*        WITH UR                                                  12800000
MFA-TR*    END-EXEC.                                                    12810000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26289*                                                                 12820000
C26289     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C26289*                                                                 12840000
C26289     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C26289        MOVE 0 TO WS-ACTIVE-RETURN-CODE                           
C26289     ELSE                                                         
C26289        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
C26289        MOVE '7530'               TO ACTIVE-PARAGRAPH             
C26289        MOVE 'SELECT'             TO ABEND-FUNCTION               
C26289        MOVE 'CSS_ACCOUNT'        TO TABLE-1                      
C26289        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
C26289        MOVE GU-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
C26289        PERFORM 9900-ABEND        THRU 9900-EXIT                  
C26289     END-IF.                                                      
C26289*                                                                 12960000
C26289 7530-EXIT.                                                       
C26289     EXIT.                                                        
      *                                                                 12990000
      ******************************************************************13000000
      *                                                                *13010000
      *      7700-SELECT-LAST-RUN-DATE                                 *13020000
      *                                                                *13030000
      ******************************************************************13040000
      *                                                                 13050000
C26296 7700-SELECT-LAST-RUN-DATE.                                       
      *                                                                 13070000
           EXEC SQL                                                     
               SELECT PROGRAM_NAME,                                     
                      COMPANY_NO,                                       
                      CMND_CODE,                                        
                      SEQ_NO,                                           
                      STATUS,                                           
                      PARM_DATA                                         
               INTO   :G6-PROGRAM-NAME,                                 
                      :G6-COMPANY-NO,                                   
                      :G6-CMND-CODE,                                    
                      :G6-SEQ-NO,                                       
                      :G6-STATUS,                                       
                      :G6-PARM-DATA                                     
               FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                       
               WHERE PROGRAM_NAME = 'PCSCA141'                          
                 AND COMPANY_NO   = '01'                                
                 AND CMND_CODE    = 'PARM'                              
                 AND SEQ_NO       = +10                                 
                 AND STATUS       = 'A'                                 
T33928                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13080000
MFA-TR*        SELECT PROGRAM_NAME,                                     13090000
MFA-TR*               COMPANY_NO,                                       13100000
MFA-TR*               CMND_CODE,                                        13110000
MFA-TR*               SEQ_NO,                                           13120000
MFA-TR*               STATUS,                                           13130000
MFA-TR*               PARM_DATA                                         13140000
MFA-TR*        INTO   :G6-PROGRAM-NAME,                                 13150000
MFA-TR*               :G6-COMPANY-NO,                                   13160000
MFA-TR*               :G6-CMND-CODE,                                    13170000
MFA-TR*               :G6-SEQ-NO,                                       13180000
MFA-TR*               :G6-STATUS,                                       13190000
MFA-TR*               :G6-PARM-DATA                                     13200000
MFA-TR*        FROM CSS_JOB_PARM G6                                     13210000
MFA-TR*        WHERE PROGRAM_NAME = 'PCSCA141'                          13220000
MFA-TR*          AND COMPANY_NO   = '01'                                13230000
MFA-TR*          AND CMND_CODE    = 'PARM'                              13240000
MFA-TR*          AND SEQ_NO       = +10                                 13250000
MFA-TR*          AND STATUS       = 'A'                                 13260000
MFA-TR*        WITH UR                                                  13270000
MFA-TR*    END-EXEC.                                                    13280000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13290000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 13310000
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*****************PCSCA141******************'    
               DISPLAY '* 7700 : RETURN CODE ERROR                *'    
               DISPLAY '* RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA141******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                 13420000
C26296 7700-EXIT.                                                       
C26296      EXIT.                                                       
      *                                                                 13450000
      ******************************************************************13460000
      *  UPDATE FIORP000 SO GUARANTOR CONFIRMATION LETTER               13470000
C26296*  AND CASH-ONLY LETTER CAN BE PRINTED.                           13480000
C25552*  BILL PRINT WILL SELECT CUSTOMER NO BASED ON ACCOUNT NO.        13490000
      ******************************************************************13500000
       8000-MOVE-LETTER-INFO.                                           
                                                                        
C35584     INITIALIZE WS-INITIAL-COMMENT-TX                             
C35584                WS-COMM-TYPE-CD                                   
C35584                WS-COMM-SUB-CD.                                   
P00599     MOVE AT-COMPANY-NO           TO WS-CORRESP-COMPANY-NO.       
P00599     MOVE WS-HOME-PHONE-NO        TO WS-GU-HOME-PHONE-NO.         
P00599     MOVE WS-WORK-PHONE-NO        TO WS-GU-WORK-PHONE-NO.         
P00599     MOVE CB-EXTENSION-NO         TO WS-CB-EXTENSION-NO.          
C26296 8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
C26296 8010-MOVE-GTOR-GTEE-INFO.                                        
P00599     MOVE 90810                   TO WS-CORRESP-MSG-ID.           
P00599     MOVE 'RECEIVABLES MANAGEMENT' TO WS-KR125-CONTACT-NAME       
C35584     MOVE 'GUARANTOR LETTER'      TO WS-INITIAL-COMMENT-TX-TEXT.  
C35584     MOVE 16                      TO WS-INITIAL-COMMENT-TX-LEN.   
P00599     MOVE GU-GUARNTR-ACCT-NO      TO WS-NOTICE-GUARANTOR-ACCT-NO. 
P00599     MOVE GU-ACCOUNT-NO           TO WS-NOTICE-ACCOUNT-NO.        
P00599     MOVE AT-LOCAL-OFFICE         TO WS-CWS350-LOCAL-OFFICE.      
P00599     MOVE AT-CUSTOMER-NO          TO WS-NOTICE-CUSTOMER-NO.       
P00599     MOVE GU-AMOUNT-GUARANTEED    TO WS-GU-AMOUNT-GUARANTEED.     
P00599     IF GU-GUARNTR-ACCT-NO = WS-PREV-ACCOUNT-NO                   
P00599        ADD +1                    TO WS-SEQ-NO-COUNT              
P00599     ELSE                                                         
P00599        MOVE 0                    TO WS-SEQ-NO-COUNT              
P00599     END-IF.                                                      
P00599     MOVE WS-SEQ-NO-COUNT         TO WS-CORRESP-SEQ-NO            
C35152     IF GU-ADDRESS-ID > 0                                         
C35152        MOVE GU-ADDRESS-ID        TO WS-CORRESP-GU-ADDR-ID        
C35152        MOVE WS-B                 TO WS-GU-ADDRESS-FORMAT         
C35152     ELSE                                                         
C35152        MOVE AT-ADDRESS-ID        TO WS-CORRESP-GU-ADDR-ID        
C35152        MOVE AT-ADDRESS-FORMAT    TO WS-GU-ADDRESS-FORMAT         
C35152     END-IF.                                                      
C26289     IF AT-COMPANY-NO NOT = WS-CURRENT-COMPANY                    
C26289        PERFORM 8400-LOAD-DELINQ-VALUES THRU 8400-EXIT            
C26289     END-IF.                                                      
C26289     PERFORM 7530-SELECT-CUST-ACCT-TYPE THRU 7530-EXIT.           
C26289     EVALUATE AT-ACCOUNT-TYPE-CODE                                
C26289        WHEN 'C'                                                  
P00599          MOVE WS-RETAIN-COMMER-DEP TO WS-RETAIN-DEP              
C26289        WHEN 'I'                                                  
P00599          MOVE WS-RETAIN-INDUST-DEP TO WS-RETAIN-DEP              
C26289        WHEN OTHER                                                
P00518          IF AT-COMPANY-NO = '01'                                 
P00599            MOVE WS-RETAIN-RESIDENT-DEP TO WS-RETAIN-DEP          
P00518          ELSE                                                    
C26289            MOVE 12 TO WS-RETAIN-DEP                              
P00518          END-IF                                                  
C26289     END-EVALUATE.                                                
                                                                        
C26296 8010-EXIT.                                                       
C26296     EXIT.                                                        
                                                                        
C26296 8020-MOVE-CASH-ONLY-INFO.                                        
P00599     MOVE 90207                   TO WS-CORRESP-MSG-ID.           
C35584     MOVE 'RECEIVABLES MANAGEMENT' TO WS-KO-CONTACT-NAME          
C35584     MOVE 'CASH ONLY LETTER'      TO WS-INITIAL-COMMENT-TX-TEXT.  
C35584     MOVE 16                      TO WS-INITIAL-COMMENT-TX-LEN.   
P00599     MOVE AT-ACCOUNT-NO           TO WS-NOTICE-ACCOUNT-NO.        
P00599     MOVE AT-CUSTOMER-NO          TO WS-NOTICE-CUSTOMER-NO.       
C35152     MOVE AT-ADDRESS-ID           TO WS-CORRESP-GU-ADDR-ID.       
C35152     MOVE AT-ADDRESS-FORMAT       TO WS-GU-ADDRESS-FORMAT.        
P00599     MOVE AT-LOCAL-OFFICE         TO WS-CWS350-LOCAL-OFFICE.      
C26296 8020-EXIT.                                                       
C26296     EXIT.                                                        
                                                                        
      *                                                                 14010000
      ******************************************************************14020000
      *  UPDATE GUAR-LTR-STATUS-CD TO 'S' IN CSS_GUARANTOR             *14030000
      *  TABLE.                                                        *14040000
      ******************************************************************14050000
       8100-UPD-GUARANTOR.                                              
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_GUARANTOR                                     
                 SET GUAR_LTR_STATUS_CD = :WS-S                         
                 WHERE ACCOUNT_NO  = :GU-ACCOUNT-NO                     
                   AND GUARNTR_ACCT_NO = :GU-GUARNTR-ACCT-NO            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '* 8100-UPD-GUARANTOR'                           
               DISPLAY '* ACCOUNT_NO = ' GU-ACCOUNT-NO                  
               DISPLAY '* GUARNTR_ACCT_NO = '                           
                                         GU-GUARNTR-ACCT-NO             
               DISPLAY '* SQL RETURN CODE = ' SQLCODE                   
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************14330000
      *  UPDATE CSS_MNT_TRANS_HIST TABLE SO GUAR CONFIRMATION LETTER   *14340000
C26296*  AND CASH ONLY LETTER                                          *14350000
      *  WILL SHOW ON TRANS HISTORY.                                   *14360000
      ******************************************************************14370000
       8200-MOVE-TRANS-HIST.                                            
P00599                                                                  
P00599     MOVE SPACES                      TO                          
P00599                                    WS-CORRESP-BARCODE-UNIQUE-ID. 
P00599     MOVE WS-JOB-PARM                 TO WS-COMMON-DATE           
P00599                                         WS-CORRESP-STMT-DT.      
P00599     MOVE WS-PGRMNAME                 TO WS-CALLING-PGM-NAME      
P00599                                    WS-CORRESP-CREATED-BY-PGM-ID  
P00599                                    WS-CORRESP-LAST-UPDATE-PGM-ID.
P00599                                                                  
P00599     PERFORM 7200-GET-TIMESTAMP       THRU 7200-EXIT.             
P00599     MOVE WS-TIMESTAMP                TO WS-CORRESP-CREATE-DT     
P00599                                                                  
P00599     MOVE WS-INPUT-DATE TO WS-KR125-MNT-DATE-TRANS.               
P00599                                                                  
P00599     MOVE 'H'                         TO WS-KR125-CODE-TRAN-TYP.  
P00599     MOVE ZEROS                       TO WS-KR125-MNT-PREMISE-NO  
P00599                                         WS-KR125-MNT-CUSTOMER-NO.
P00599     MOVE SPACES                      TO WS-KR125-RESP-AREA-ID.   
P00599     MOVE AT-ACCOUNT-NO               TO WS-KR125-MNT-ACCOUNT-NO. 
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8210-MOVE-GTOR-HIST.                                             
           STRING 'GUARANTOR CONFIRM LETTER ' DELIMITED BY SIZE,        
                  ';90810;  ' DELIMITED BY SIZE,                        
                  'MAILED: ' DELIMITED BY SIZE,                         
                  WS-HIST-DISP-DATE DELIMITED BY SIZE,                  
P00599             INTO                  WS-KR125-TRAN-CMT-TEXT.        
P00599     MOVE +52 TO                   WS-KR125-TRAN-CMT-LEN.         
C26296 8210-EXIT.                                                       
           EXIT.                                                        
                                                                        
C26296 8220-MOVE-CASH-HIST.                                             
           STRING 'CASH ONLY LETTER ' DELIMITED BY SIZE,                
                  ';90207;  ' DELIMITED BY SIZE,                        
                  'MAILED: ' DELIMITED BY SIZE,                         
                  WS-HIST-DISP-DATE DELIMITED BY SIZE,                  
P00599             INTO                  WS-KR125-TRAN-CMT-TEXT.        
P00599     MOVE +44 TO                   WS-KR125-TRAN-CMT-LEN.         
C26296 8220-EXIT.                                                       
C26296     EXIT.                                                        
                                                                        
C26289*                                                                 15020000
C26289******************************************************************15030000
C26289*                                                                *15040000
C26289*   8400-LOAD-DELINQ-VALUES.                                     *15050000
C26289******************************************************************15060000
C26289 8400-LOAD-DELINQ-VALUES.                                         
C26289*                                                                 15080000
C26289     SET TB-CO-INDEX TO 1.                                        
C26289     SET TB-VAL-INDEX TO 1.                                       
C26289*                                                                 15110000
C26289     PERFORM UNTIL                                                
C26289       AT-COMPANY-NO EQUAL                                        
C26289       WS-DELINQ-COMPANY-TB (TB-CO-INDEX, TB-VAL-INDEX)           
P00518       OR TB-CO-INDEX > 6                                         
C26289*      OR TB-CO-INDEX > 5                                         15160000
C26289         IF AT-COMPANY-NO EQUAL                                   
C26289            WS-DELINQ-COMPANY-TB (TB-CO-INDEX, TB-VAL-INDEX)      
C26289             NEXT SENTENCE                                        
C26289         ELSE                                                     
C26289             SET TB-CO-INDEX UP BY 1                              
C26289         END-IF                                                   
C26289     END-PERFORM.                                                 
C26289*                                                                 15240000
C26289     PERFORM 8410-LOAD-DL-VARIABLE THRU 8410-EXIT                 
P00518*        UNTIL TB-VAL-INDEX > 2.                                  15260000
P00518         UNTIL TB-VAL-INDEX > 3.                                  
C26289*                                                                 15280000
C26289     MOVE AT-COMPANY-NO TO WS-CURRENT-COMPANY.                    
C26289*                                                                 15300000
C26289 8400-EXIT.                                                       
C26289     EXIT.                                                        
C26289*                                                                 15330000
C26289******************************************************************15340000
C26289*                                                                *15350000
C26289*   8410-LOAD-DL-VARIABLE.                                       *15360000
C26289******************************************************************15370000
C26289 8410-LOAD-DL-VARIABLE.                                           
C26289                                                                  
C26289     EVALUATE WS-DELINQ-CODE-TB (TB-CO-INDEX, TB-VAL-INDEX)       
C26289        WHEN 'RETAIN-COMMER-DEP'                                  
C26289           MOVE WS-DELINQ-VALUE-TB (TB-CO-INDEX, TB-VAL-INDEX)    
C26289               TO WS-RETAIN-COMMER-DEP                            
C26289           SET TB-VAL-INDEX UP BY 1                               
C26289        WHEN 'RETAIN-INDUST-DEP'                                  
C26289           MOVE WS-DELINQ-VALUE-TB (TB-CO-INDEX, TB-VAL-INDEX)    
C26289               TO WS-RETAIN-INDUST-DEP                            
C26289           SET TB-VAL-INDEX UP BY 1                               
P00518        WHEN 'RETAIN-RESIDENT-DEP'                                
P00518           MOVE WS-DELINQ-VALUE-TB (TB-CO-INDEX, TB-VAL-INDEX)    
P00518               TO WS-RETAIN-RESIDENT-DEP                          
P00518           SET TB-VAL-INDEX UP BY 1                               
C26289        WHEN OTHER                                                
C26289           SET TB-VAL-INDEX UP BY 1                               
C26289     END-EVALUATE.                                                
C26289                                                                  
C26289 8410-EXIT.                                                       
C26289     EXIT.                                                        
C26289*                                                                 15590000
T30823***************************************************************** 16470000
T30823* 8870-RESET-JOB-PARM.                                          * 16480000
T30823***************************************************************** 16490000
T30823 8870-RESET-JOB-PARM.                                             
T30823*                                                                 16510000
T30823     EXEC SQL                                                     
T30823         UPDATE CSS_JOB_PARM                                      
T30823            SET STATUS       = :G6-STATUS,                        
T30823                PARM_DATA    = :G6-PARM-DATA                      
T30823          WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                   
T30823            AND CMND_CODE    = :G6-CMND-CODE                      
T30823            AND COMPANY_NO   = :G6-COMPANY-NO                     
T30823            AND SEQ_NO       = :G6-SEQ-NO                         
T30823     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T30823*                                                                 16610000
T30823     MOVE SQLCODE                  TO  WS-ACTIVE-RETURN-CODE      
T30823     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T30823        CONTINUE                                                  
T30823     ELSE                                                         
T30823        DISPLAY '*** ERROR IN 8870-RESET-JOB-PARM ***'            
T30823        DISPLAY '*** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
T30823        DISPLAY '***   PROCESSING TERMINATED ***'                 
T30823        PERFORM 9900-ABEND         THRU 9900-EXIT                 
T30823     END-IF.                                                      
T30823*                                                                 16710000
T30823 8870-EXIT.                                                       
T30823     EXIT.                                                        
T30823*                                                                 16740000
T25584***************************************************************** 16750000
T25584*    8888-COMMIT                                               ** 16760000
T25584*                                                              ** 16770000
C26296* CHANGE CURSOR TO BE WITH HOLD FOR SO THE OPEN IS NOT NECESSARY* 16780000
T25584***************************************************************** 16790000
T25584 8888-COMMIT.                                                     
ACT243*                                                                         
ACT243     ADD  1                            TO  WS-CHKP-SEQ-NO.        
ACT243*                                                                         
T25584     EXEC SQL                                                     16830000
T25584         INCLUDE CPD00047                                         16840000
T25584     END-EXEC.                                                    16850000
T25584     DISPLAY 'COMMIT POINT # ' WS-CHKP-SEQ-NO ' TAKEN.'.          
T25584*                                                                 16880000
T25584 8888-EXIT.                                                       
T25584     EXIT.                                                        
T25584*                                                                 16910000
A00765****************************************************************  17160000
A00765* 9000-SEND-ERROR-RESULT. REQUIRED BY THE COPYBOOK             *  17170000
A00765****************************************************************  17180000
A00765 9000-SEND-ERROR-RESULT.                                          
A00765                                                                  
A00765     GO TO 9000-EXIT.                                             
A00765*                                                                 17220000
      ******************************************************************17230000
      *                                                                *17240000
      *   9000-CLOSE-FILES.                                            *17250000
      *                                                                *17260000
      ******************************************************************17270000
       9000-TERMINATE.                                                  
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ** 9700-PROCESS-ABEND.                                         ** 17330000
      ***************************************************************** 17340000
                                                                        
           EXEC SQL                                                     17360000
               INCLUDE CPD0023B                                         17370000
           END-EXEC.                                                    17380000
                                                                        
      ****************************************************************  17400000
      **                                                            **  17410000
      **  9900-SQL-ERROR-ROUTINE                                    **  17420000
      **                                                            **  17430000
      ****************************************************************  17440000
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                 17460000
           MOVE SQLCODE                TO WS-DISPLAY-SQLCODE.           
           DISPLAY ' '                                                  
           DISPLAY '**********************************************'     
           DISPLAY '***** 9900-SQL-ERROR-ROUTINE            ******'     
           DISPLAY '**********************************************'     
           DISPLAY ' '                                                  
           DISPLAY 'SQLCODE = ' WS-DISPLAY-SQLCODE                      
           DISPLAY ABEND-RECORD-1-DATA                                  
           DISPLAY ABEND-RECORD-2-DATA                                  
           DISPLAY ABEND-RECORD-3-DATA                                  
           DISPLAY '**********************************************'.    
      ***************************************************************** 17580000
      ** 9900-ABEND.                                                 ** 17590000
      ***************************************************************** 17600000
                                                                        
           EXEC SQL                                                     17620000
               INCLUDE CPD09900                                         17630000
           END-EXEC.                                                    17640000
